#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
/*
 * BulkLoadUtils.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/BulkLoading.h"
#include "fdbclient/FDBTypes.h"
#include "fdbclient/NativeAPI.actor.h"
#include "fdbclient/S3Client.actor.h"
#include "fdbserver/BulkLoadUtil.actor.h"
#include "fdbserver/Knobs.h"
#include "fdbserver/RocksDBCheckpointUtils.actor.h"
#include "fdbserver/StorageMetrics.actor.h"
#include "flow/genericactors.actor.h"
#include "flow/actorcompiler.h" // has to be last include

															#line 34 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via readBulkFileBytes()
															#line 32 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
template <class ReadBulkFileBytesActor>
															#line 32 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
class ReadBulkFileBytesActorState {
															#line 41 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
public:
															#line 32 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	ReadBulkFileBytesActorState(std::string const& path,int64_t const& maxLength,std::shared_ptr<std::string> const& output) 
															#line 32 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
															#line 32 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		 : path(path),
															#line 32 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		   maxLength(maxLength),
															#line 32 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		   output(output)
															#line 52 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("readBulkFileBytes", reinterpret_cast<unsigned long>(this));

	}
	~ReadBulkFileBytesActorState() 
	{
		fdb_probe_actor_destroy("readBulkFileBytes", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 34 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
				output->clear();
															#line 35 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
				chunkSize = SERVER_KNOBS->BULKLOAD_ASYNC_READ_WRITE_BLOCK_SIZE;
															#line 36 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
				StrictFuture<Reference<IAsyncFile>> __when_expr_0 = IAsyncFileSystem::filesystem()->open( abspath(path), IAsyncFile::OPEN_NO_AIO | IAsyncFile::OPEN_READONLY | IAsyncFile::OPEN_UNCACHED, 0644);
															#line 36 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
				if (static_cast<ReadBulkFileBytesActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 74 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<ReadBulkFileBytesActor*>(this)->actor_wait_state = 1;
															#line 36 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ReadBulkFileBytesActor, 0, Reference<IAsyncFile> >*>(static_cast<ReadBulkFileBytesActor*>(this)));
															#line 79 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ReadBulkFileBytesActorState();
		static_cast<ReadBulkFileBytesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 68 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			TraceEvent(SevWarn, "ReadBulkFileBytesError").error(e).detail("Path", path).detail("MaxLength", maxLength);
															#line 69 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 111 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 38 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		StrictFuture<int64_t> __when_expr_1 = file->size();
															#line 38 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (static_cast<ReadBulkFileBytesActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 127 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<ReadBulkFileBytesActor*>(this)->actor_wait_state = 2;
															#line 38 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ReadBulkFileBytesActor, 1, int64_t >*>(static_cast<ReadBulkFileBytesActor*>(this)));
															#line 132 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Reference<IAsyncFile> const& __file,int loopDepth) 
	{
															#line 36 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		file = __file;
															#line 141 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Reference<IAsyncFile> && __file,int loopDepth) 
	{
		file = std::move(__file);
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ReadBulkFileBytesActor*>(this)->actor_wait_state > 0) static_cast<ReadBulkFileBytesActor*>(this)->actor_wait_state = 0;
		static_cast<ReadBulkFileBytesActor*>(this)->ActorCallback< ReadBulkFileBytesActor, 0, Reference<IAsyncFile> >::remove();

	}
	void a_callback_fire(ActorCallback< ReadBulkFileBytesActor, 0, Reference<IAsyncFile> >*,Reference<IAsyncFile> const& value) 
	{
		fdb_probe_actor_enter("readBulkFileBytes", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadBulkFileBytesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readBulkFileBytes", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ReadBulkFileBytesActor, 0, Reference<IAsyncFile> >*,Reference<IAsyncFile> && value) 
	{
		fdb_probe_actor_enter("readBulkFileBytes", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadBulkFileBytesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readBulkFileBytes", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ReadBulkFileBytesActor, 0, Reference<IAsyncFile> >*,Error err) 
	{
		fdb_probe_actor_enter("readBulkFileBytes", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadBulkFileBytesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readBulkFileBytes", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 39 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (fileSize > maxLength)
															#line 220 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		{
															#line 40 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			TraceEvent(SevError, "ReadBulkFileBytesTooLarge") .detail("FileSize", fileSize) .detail("MaxLength", maxLength);
															#line 43 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			return a_body1Catch2(file_too_large(), loopDepth);
															#line 226 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		}
															#line 45 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		output->reserve(fileSize);
															#line 48 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		offset = 0;
															#line 49 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		remaining = fileSize;
															#line 50 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		chunk = std::make_shared<std::string>();
															#line 51 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		;
															#line 238 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		loopDepth = a_body1cont3loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(int64_t const& __fileSize,int loopDepth) 
	{
															#line 38 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		fileSize = __fileSize;
															#line 247 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(int64_t && __fileSize,int loopDepth) 
	{
		fileSize = std::move(__fileSize);
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ReadBulkFileBytesActor*>(this)->actor_wait_state > 0) static_cast<ReadBulkFileBytesActor*>(this)->actor_wait_state = 0;
		static_cast<ReadBulkFileBytesActor*>(this)->ActorCallback< ReadBulkFileBytesActor, 1, int64_t >::remove();

	}
	void a_callback_fire(ActorCallback< ReadBulkFileBytesActor, 1, int64_t >*,int64_t const& value) 
	{
		fdb_probe_actor_enter("readBulkFileBytes", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadBulkFileBytesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readBulkFileBytes", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ReadBulkFileBytesActor, 1, int64_t >*,int64_t && value) 
	{
		fdb_probe_actor_enter("readBulkFileBytes", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadBulkFileBytesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readBulkFileBytes", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ReadBulkFileBytesActor, 1, int64_t >*,Error err) 
	{
		fdb_probe_actor_enter("readBulkFileBytes", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadBulkFileBytesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readBulkFileBytes", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 66 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (!static_cast<ReadBulkFileBytesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ReadBulkFileBytesActorState(); static_cast<ReadBulkFileBytesActor*>(this)->destroy(); return 0; }
															#line 326 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		new (&static_cast<ReadBulkFileBytesActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ReadBulkFileBytesActorState();
		static_cast<ReadBulkFileBytesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont3loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1(int loopDepth) 
	{
															#line 51 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (!(remaining > 0))
															#line 345 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		{
			return a_body1cont3break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 52 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		bytesToRead = std::min(chunkSize, remaining);
															#line 53 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		chunk->clear();
															#line 54 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		chunk->resize(bytesToRead);
															#line 55 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		StrictFuture<int> __when_expr_2 = uncancellable(holdWhile(chunk, file->read(chunk->data(), bytesToRead, offset)));
															#line 55 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (static_cast<ReadBulkFileBytesActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 359 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont3loopBody1when1(__when_expr_2.get(), loopDepth); };
		static_cast<ReadBulkFileBytesActor*>(this)->actor_wait_state = 3;
															#line 55 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ReadBulkFileBytesActor, 2, int >*>(static_cast<ReadBulkFileBytesActor*>(this)));
															#line 364 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3break1(int loopDepth) 
	{
		try {
			return a_body1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3loopBody1cont1(int loopDepth) 
	{
															#line 56 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (bytesRead != bytesToRead)
															#line 386 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		{
															#line 57 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			TraceEvent(SevError, "ReadBulkFileBytesError") .detail("BytesRead", bytesRead) .detail("BytesExpected", bytesToRead);
															#line 60 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			return a_body1Catch2(io_error(), std::max(0, loopDepth - 1));
															#line 392 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		}
															#line 62 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		output->append(*chunk);
															#line 63 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		offset += bytesRead;
															#line 64 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		remaining -= bytesRead;
															#line 400 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1cont3loopBody1when1(int const& __bytesRead,int loopDepth) 
	{
															#line 55 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		bytesRead = __bytesRead;
															#line 409 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		loopDepth = a_body1cont3loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1when1(int && __bytesRead,int loopDepth) 
	{
		bytesRead = std::move(__bytesRead);
		loopDepth = a_body1cont3loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ReadBulkFileBytesActor*>(this)->actor_wait_state > 0) static_cast<ReadBulkFileBytesActor*>(this)->actor_wait_state = 0;
		static_cast<ReadBulkFileBytesActor*>(this)->ActorCallback< ReadBulkFileBytesActor, 2, int >::remove();

	}
	void a_callback_fire(ActorCallback< ReadBulkFileBytesActor, 2, int >*,int const& value) 
	{
		fdb_probe_actor_enter("readBulkFileBytes", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadBulkFileBytesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readBulkFileBytes", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ReadBulkFileBytesActor, 2, int >*,int && value) 
	{
		fdb_probe_actor_enter("readBulkFileBytes", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadBulkFileBytesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readBulkFileBytes", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ReadBulkFileBytesActor, 2, int >*,Error err) 
	{
		fdb_probe_actor_enter("readBulkFileBytes", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadBulkFileBytesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readBulkFileBytes", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 32 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	std::string path;
															#line 32 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	int64_t maxLength;
															#line 32 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	std::shared_ptr<std::string> output;
															#line 35 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	int64_t chunkSize;
															#line 36 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	Reference<IAsyncFile> file;
															#line 38 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	int64_t fileSize;
															#line 48 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	int64_t offset;
															#line 49 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	int64_t remaining;
															#line 50 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	std::shared_ptr<std::string> chunk;
															#line 52 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	int64_t bytesToRead;
															#line 55 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	int bytesRead;
															#line 506 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
};
// This generated class is to be used only via readBulkFileBytes()
															#line 32 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
class ReadBulkFileBytesActor final : public Actor<Void>, public ActorCallback< ReadBulkFileBytesActor, 0, Reference<IAsyncFile> >, public ActorCallback< ReadBulkFileBytesActor, 1, int64_t >, public ActorCallback< ReadBulkFileBytesActor, 2, int >, public FastAllocated<ReadBulkFileBytesActor>, public ReadBulkFileBytesActorState<ReadBulkFileBytesActor> {
															#line 511 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
public:
	using FastAllocated<ReadBulkFileBytesActor>::operator new;
	using FastAllocated<ReadBulkFileBytesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15628702819208152320UL, 10314271264750855424UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ReadBulkFileBytesActor, 0, Reference<IAsyncFile> >;
friend struct ActorCallback< ReadBulkFileBytesActor, 1, int64_t >;
friend struct ActorCallback< ReadBulkFileBytesActor, 2, int >;
															#line 32 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	ReadBulkFileBytesActor(std::string const& path,int64_t const& maxLength,std::shared_ptr<std::string> const& output) 
															#line 530 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   ReadBulkFileBytesActorState<ReadBulkFileBytesActor>(path, maxLength, output),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("readBulkFileBytes", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9571244570997355520UL, 15750496131617490432UL);
		ActorExecutionContextHelper __helper(static_cast<ReadBulkFileBytesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("readBulkFileBytes");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("readBulkFileBytes", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ReadBulkFileBytesActor, 0, Reference<IAsyncFile> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ReadBulkFileBytesActor, 1, int64_t >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ReadBulkFileBytesActor, 2, int >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 32 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
[[nodiscard]] Future<Void> readBulkFileBytes( std::string const& path, int64_t const& maxLength, std::shared_ptr<std::string> const& output ) {
															#line 32 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	return Future<Void>(new ReadBulkFileBytesActor(path, maxLength, output));
															#line 565 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
}

#line 72 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"

															#line 570 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via writeBulkFileBytes()
															#line 73 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
template <class WriteBulkFileBytesActor>
															#line 73 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
class WriteBulkFileBytesActorState {
															#line 577 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
public:
															#line 73 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	WriteBulkFileBytesActorState(std::string const& path,std::shared_ptr<std::string> const& content) 
															#line 73 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
															#line 73 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		 : path(path),
															#line 73 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		   content(content)
															#line 586 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("writeBulkFileBytes", reinterpret_cast<unsigned long>(this));

	}
	~WriteBulkFileBytesActorState() 
	{
		fdb_probe_actor_destroy("writeBulkFileBytes", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 75 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
				chunkSize = SERVER_KNOBS->BULKLOAD_ASYNC_READ_WRITE_BLOCK_SIZE;
															#line 76 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
				StrictFuture<Reference<IAsyncFile>> __when_expr_0 = IAsyncFileSystem::filesystem()->open( abspath(path), IAsyncFile::OPEN_ATOMIC_WRITE_AND_CREATE | IAsyncFile::OPEN_READWRITE | IAsyncFile::OPEN_CREATE, 0644);
															#line 76 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
				if (static_cast<WriteBulkFileBytesActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 606 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<WriteBulkFileBytesActor*>(this)->actor_wait_state = 1;
															#line 76 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WriteBulkFileBytesActor, 0, Reference<IAsyncFile> >*>(static_cast<WriteBulkFileBytesActor*>(this)));
															#line 611 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WriteBulkFileBytesActorState();
		static_cast<WriteBulkFileBytesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 97 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			TraceEvent(SevWarn, "WriteBulkFileBytesError").error(e).detail("Path", path);
															#line 98 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 643 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 82 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		offset = 0;
															#line 83 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		remaining = content->size();
															#line 85 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		;
															#line 661 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Reference<IAsyncFile> const& __file,int loopDepth) 
	{
															#line 76 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		file = __file;
															#line 670 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Reference<IAsyncFile> && __file,int loopDepth) 
	{
		file = std::move(__file);
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WriteBulkFileBytesActor*>(this)->actor_wait_state > 0) static_cast<WriteBulkFileBytesActor*>(this)->actor_wait_state = 0;
		static_cast<WriteBulkFileBytesActor*>(this)->ActorCallback< WriteBulkFileBytesActor, 0, Reference<IAsyncFile> >::remove();

	}
	void a_callback_fire(ActorCallback< WriteBulkFileBytesActor, 0, Reference<IAsyncFile> >*,Reference<IAsyncFile> const& value) 
	{
		fdb_probe_actor_enter("writeBulkFileBytes", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteBulkFileBytesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeBulkFileBytes", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WriteBulkFileBytesActor, 0, Reference<IAsyncFile> >*,Reference<IAsyncFile> && value) 
	{
		fdb_probe_actor_enter("writeBulkFileBytes", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteBulkFileBytesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeBulkFileBytes", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WriteBulkFileBytesActor, 0, Reference<IAsyncFile> >*,Error err) 
	{
		fdb_probe_actor_enter("writeBulkFileBytes", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteBulkFileBytesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeBulkFileBytes", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 93 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		StrictFuture<Void> __when_expr_2 = file->truncate(content->size());
															#line 93 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (static_cast<WriteBulkFileBytesActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 751 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<WriteBulkFileBytesActor*>(this)->actor_wait_state = 3;
															#line 93 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WriteBulkFileBytesActor, 2, Void >*>(static_cast<WriteBulkFileBytesActor*>(this)));
															#line 756 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1(int loopDepth) 
	{
															#line 85 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (!(remaining > 0))
															#line 772 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		{
			return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 86 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		bytesToWrite = std::min(chunkSize, remaining);
															#line 87 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		StrictFuture<Void> __when_expr_1 = uncancellable(holdWhile(content, file->write(content->data() + offset, bytesToWrite, offset)));
															#line 87 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (static_cast<WriteBulkFileBytesActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 782 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<WriteBulkFileBytesActor*>(this)->actor_wait_state = 2;
															#line 87 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WriteBulkFileBytesActor, 1, Void >*>(static_cast<WriteBulkFileBytesActor*>(this)));
															#line 787 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2break1(int loopDepth) 
	{
		try {
			return a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 88 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		offset += bytesToWrite;
															#line 89 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		remaining -= bytesToWrite;
															#line 811 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 88 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		offset += bytesToWrite;
															#line 89 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		remaining -= bytesToWrite;
															#line 822 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WriteBulkFileBytesActor*>(this)->actor_wait_state > 0) static_cast<WriteBulkFileBytesActor*>(this)->actor_wait_state = 0;
		static_cast<WriteBulkFileBytesActor*>(this)->ActorCallback< WriteBulkFileBytesActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteBulkFileBytesActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeBulkFileBytes", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteBulkFileBytesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeBulkFileBytes", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WriteBulkFileBytesActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeBulkFileBytes", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteBulkFileBytesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeBulkFileBytes", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WriteBulkFileBytesActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeBulkFileBytes", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteBulkFileBytesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeBulkFileBytes", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 94 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		StrictFuture<Void> __when_expr_3 = file->sync();
															#line 94 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (static_cast<WriteBulkFileBytesActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 908 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch2(__when_expr_3.getError(), loopDepth); else return a_body1cont4when1(__when_expr_3.get(), loopDepth); };
		static_cast<WriteBulkFileBytesActor*>(this)->actor_wait_state = 4;
															#line 94 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< WriteBulkFileBytesActor, 3, Void >*>(static_cast<WriteBulkFileBytesActor*>(this)));
															#line 913 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 94 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		StrictFuture<Void> __when_expr_3 = file->sync();
															#line 94 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (static_cast<WriteBulkFileBytesActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 924 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch2(__when_expr_3.getError(), loopDepth); else return a_body1cont4when1(__when_expr_3.get(), loopDepth); };
		static_cast<WriteBulkFileBytesActor*>(this)->actor_wait_state = 4;
															#line 94 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< WriteBulkFileBytesActor, 3, Void >*>(static_cast<WriteBulkFileBytesActor*>(this)));
															#line 929 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<WriteBulkFileBytesActor*>(this)->actor_wait_state > 0) static_cast<WriteBulkFileBytesActor*>(this)->actor_wait_state = 0;
		static_cast<WriteBulkFileBytesActor*>(this)->ActorCallback< WriteBulkFileBytesActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteBulkFileBytesActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeBulkFileBytes", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteBulkFileBytesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeBulkFileBytes", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< WriteBulkFileBytesActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeBulkFileBytes", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteBulkFileBytesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeBulkFileBytes", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< WriteBulkFileBytesActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeBulkFileBytes", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteBulkFileBytesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeBulkFileBytes", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 95 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (!static_cast<WriteBulkFileBytesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WriteBulkFileBytesActorState(); static_cast<WriteBulkFileBytesActor*>(this)->destroy(); return 0; }
															#line 1013 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		new (&static_cast<WriteBulkFileBytesActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WriteBulkFileBytesActorState();
		static_cast<WriteBulkFileBytesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 95 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (!static_cast<WriteBulkFileBytesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WriteBulkFileBytesActorState(); static_cast<WriteBulkFileBytesActor*>(this)->destroy(); return 0; }
															#line 1025 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		new (&static_cast<WriteBulkFileBytesActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WriteBulkFileBytesActorState();
		static_cast<WriteBulkFileBytesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<WriteBulkFileBytesActor*>(this)->actor_wait_state > 0) static_cast<WriteBulkFileBytesActor*>(this)->actor_wait_state = 0;
		static_cast<WriteBulkFileBytesActor*>(this)->ActorCallback< WriteBulkFileBytesActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteBulkFileBytesActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeBulkFileBytes", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteBulkFileBytesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeBulkFileBytes", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< WriteBulkFileBytesActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeBulkFileBytes", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteBulkFileBytesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeBulkFileBytes", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< WriteBulkFileBytesActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeBulkFileBytes", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteBulkFileBytesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeBulkFileBytes", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 73 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	std::string path;
															#line 73 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	std::shared_ptr<std::string> content;
															#line 75 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	int64_t chunkSize;
															#line 76 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	Reference<IAsyncFile> file;
															#line 82 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	int64_t offset;
															#line 83 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	int64_t remaining;
															#line 86 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	int64_t bytesToWrite;
															#line 1122 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
};
// This generated class is to be used only via writeBulkFileBytes()
															#line 73 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
class WriteBulkFileBytesActor final : public Actor<Void>, public ActorCallback< WriteBulkFileBytesActor, 0, Reference<IAsyncFile> >, public ActorCallback< WriteBulkFileBytesActor, 1, Void >, public ActorCallback< WriteBulkFileBytesActor, 2, Void >, public ActorCallback< WriteBulkFileBytesActor, 3, Void >, public FastAllocated<WriteBulkFileBytesActor>, public WriteBulkFileBytesActorState<WriteBulkFileBytesActor> {
															#line 1127 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
public:
	using FastAllocated<WriteBulkFileBytesActor>::operator new;
	using FastAllocated<WriteBulkFileBytesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4759995264476607232UL, 12993864780869678848UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WriteBulkFileBytesActor, 0, Reference<IAsyncFile> >;
friend struct ActorCallback< WriteBulkFileBytesActor, 1, Void >;
friend struct ActorCallback< WriteBulkFileBytesActor, 2, Void >;
friend struct ActorCallback< WriteBulkFileBytesActor, 3, Void >;
															#line 73 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	WriteBulkFileBytesActor(std::string const& path,std::shared_ptr<std::string> const& content) 
															#line 1147 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   WriteBulkFileBytesActorState<WriteBulkFileBytesActor>(path, content),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("writeBulkFileBytes", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17005299131570403328UL, 17577297949485139968UL);
		ActorExecutionContextHelper __helper(static_cast<WriteBulkFileBytesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("writeBulkFileBytes");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("writeBulkFileBytes", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WriteBulkFileBytesActor, 0, Reference<IAsyncFile> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WriteBulkFileBytesActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< WriteBulkFileBytesActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< WriteBulkFileBytesActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 73 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
[[nodiscard]] Future<Void> writeBulkFileBytes( std::string const& path, std::shared_ptr<std::string> const& content ) {
															#line 73 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	return Future<Void>(new WriteBulkFileBytesActor(path, content));
															#line 1183 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
}

#line 101 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"

															#line 1188 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via copyBulkFile()
															#line 102 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
template <class CopyBulkFileActor>
															#line 102 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
class CopyBulkFileActorState {
															#line 1195 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
public:
															#line 102 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	CopyBulkFileActorState(std::string const& fromFile,std::string const& toFile,size_t const& fileBytesMax) 
															#line 102 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
															#line 102 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		 : fromFile(fromFile),
															#line 102 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		   toFile(toFile),
															#line 102 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		   fileBytesMax(fileBytesMax),
															#line 103 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		   content(std::make_shared<std::string>())
															#line 1208 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("copyBulkFile", reinterpret_cast<unsigned long>(this));

	}
	~CopyBulkFileActorState() 
	{
		fdb_probe_actor_destroy("copyBulkFile", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 104 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			StrictFuture<Void> __when_expr_0 = readBulkFileBytes(abspath(fromFile), fileBytesMax, content);
															#line 104 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			if (static_cast<CopyBulkFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1225 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CopyBulkFileActor*>(this)->actor_wait_state = 1;
															#line 104 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CopyBulkFileActor, 0, Void >*>(static_cast<CopyBulkFileActor*>(this)));
															#line 1230 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CopyBulkFileActorState();
		static_cast<CopyBulkFileActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 105 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		StrictFuture<Void> __when_expr_1 = writeBulkFileBytes(toFile, content);
															#line 105 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (static_cast<CopyBulkFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1255 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CopyBulkFileActor*>(this)->actor_wait_state = 2;
															#line 105 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CopyBulkFileActor, 1, Void >*>(static_cast<CopyBulkFileActor*>(this)));
															#line 1260 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 105 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		StrictFuture<Void> __when_expr_1 = writeBulkFileBytes(toFile, content);
															#line 105 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (static_cast<CopyBulkFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1271 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CopyBulkFileActor*>(this)->actor_wait_state = 2;
															#line 105 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CopyBulkFileActor, 1, Void >*>(static_cast<CopyBulkFileActor*>(this)));
															#line 1276 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CopyBulkFileActor*>(this)->actor_wait_state > 0) static_cast<CopyBulkFileActor*>(this)->actor_wait_state = 0;
		static_cast<CopyBulkFileActor*>(this)->ActorCallback< CopyBulkFileActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CopyBulkFileActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("copyBulkFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyBulkFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyBulkFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CopyBulkFileActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("copyBulkFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyBulkFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyBulkFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CopyBulkFileActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("copyBulkFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyBulkFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyBulkFile", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 106 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (!static_cast<CopyBulkFileActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CopyBulkFileActorState(); static_cast<CopyBulkFileActor*>(this)->destroy(); return 0; }
															#line 1360 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		new (&static_cast<CopyBulkFileActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CopyBulkFileActorState();
		static_cast<CopyBulkFileActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 106 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (!static_cast<CopyBulkFileActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CopyBulkFileActorState(); static_cast<CopyBulkFileActor*>(this)->destroy(); return 0; }
															#line 1372 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		new (&static_cast<CopyBulkFileActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CopyBulkFileActorState();
		static_cast<CopyBulkFileActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CopyBulkFileActor*>(this)->actor_wait_state > 0) static_cast<CopyBulkFileActor*>(this)->actor_wait_state = 0;
		static_cast<CopyBulkFileActor*>(this)->ActorCallback< CopyBulkFileActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CopyBulkFileActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("copyBulkFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyBulkFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyBulkFile", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CopyBulkFileActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("copyBulkFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyBulkFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyBulkFile", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CopyBulkFileActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("copyBulkFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyBulkFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyBulkFile", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 102 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	std::string fromFile;
															#line 102 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	std::string toFile;
															#line 102 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	size_t fileBytesMax;
															#line 103 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	std::shared_ptr<std::string> content;
															#line 1463 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
};
// This generated class is to be used only via copyBulkFile()
															#line 102 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
class CopyBulkFileActor final : public Actor<Void>, public ActorCallback< CopyBulkFileActor, 0, Void >, public ActorCallback< CopyBulkFileActor, 1, Void >, public FastAllocated<CopyBulkFileActor>, public CopyBulkFileActorState<CopyBulkFileActor> {
															#line 1468 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
public:
	using FastAllocated<CopyBulkFileActor>::operator new;
	using FastAllocated<CopyBulkFileActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7242439579538255360UL, 16699518352461114624UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CopyBulkFileActor, 0, Void >;
friend struct ActorCallback< CopyBulkFileActor, 1, Void >;
															#line 102 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	CopyBulkFileActor(std::string const& fromFile,std::string const& toFile,size_t const& fileBytesMax) 
															#line 1486 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   CopyBulkFileActorState<CopyBulkFileActor>(fromFile, toFile, fileBytesMax),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("copyBulkFile", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(871025483483831552UL, 9209667149474841088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyBulkFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("copyBulkFile");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("copyBulkFile", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CopyBulkFileActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CopyBulkFileActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 102 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
[[nodiscard]] Future<Void> copyBulkFile( std::string const& fromFile, std::string const& toFile, size_t const& fileBytesMax ) {
															#line 102 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	return Future<Void>(new CopyBulkFileActor(fromFile, toFile, fileBytesMax));
															#line 1520 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
}

#line 108 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"

															#line 1525 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via getBulkLoadTaskStateFromDataMove()
															#line 109 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
template <class GetBulkLoadTaskStateFromDataMoveActor>
															#line 109 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
class GetBulkLoadTaskStateFromDataMoveActorState {
															#line 1532 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
public:
															#line 109 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	GetBulkLoadTaskStateFromDataMoveActorState(Database const& cx,UID const& dataMoveId,Version const& atLeastVersion,UID const& logId) 
															#line 109 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
															#line 109 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		 : cx(cx),
															#line 109 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		   dataMoveId(dataMoveId),
															#line 109 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		   atLeastVersion(atLeastVersion),
															#line 109 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		   logId(logId),
															#line 113 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		   tr(cx),
															#line 114 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		   retryCount(0),
															#line 115 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		   metadataRetryCount(0),
															#line 116 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		   startTime(now())
															#line 1553 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getBulkLoadTaskStateFromDataMove", reinterpret_cast<unsigned long>(this));

	}
	~GetBulkLoadTaskStateFromDataMoveActorState() 
	{
		fdb_probe_actor_destroy("getBulkLoadTaskStateFromDataMove", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 117 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 118 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 119 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			;
															#line 1572 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetBulkLoadTaskStateFromDataMoveActorState();
		static_cast<GetBulkLoadTaskStateFromDataMoveActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 121 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr.get(dataMoveKeyFor(dataMoveId));
															#line 121 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			if (static_cast<GetBulkLoadTaskStateFromDataMoveActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1605 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetBulkLoadTaskStateFromDataMoveActor*>(this)->actor_wait_state = 1;
															#line 121 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetBulkLoadTaskStateFromDataMoveActor, 0, Optional<Value> >*>(static_cast<GetBulkLoadTaskStateFromDataMoveActor*>(this)));
															#line 1610 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 181 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			StrictFuture<Void> __when_expr_4 = tr.onError(e);
															#line 181 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			if (static_cast<GetBulkLoadTaskStateFromDataMoveActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1634 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_4.get(), loopDepth); };
			static_cast<GetBulkLoadTaskStateFromDataMoveActor*>(this)->actor_wait_state = 5;
															#line 181 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< GetBulkLoadTaskStateFromDataMoveActor, 4, Void >*>(static_cast<GetBulkLoadTaskStateFromDataMoveActor*>(this)));
															#line 1639 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 122 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		ASSERT(tr.getReadVersion().isReady());
															#line 123 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (tr.getReadVersion().get() < atLeastVersion)
															#line 1656 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		{
															#line 124 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			retryCount++;
															#line 125 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			if (retryCount % 100 == 0)
															#line 1662 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
			{
															#line 126 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
				TraceEvent(SevWarn, "SSBulkLoadTaskWaitingForVersion", logId) .detail("DataMoveID", dataMoveId) .detail("ReadVersion", tr.getReadVersion().get()) .detail("AtLeastVersion", atLeastVersion) .detail("RetryCount", retryCount) .detail("ElapsedSec", now() - startTime);
															#line 1666 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
			}
															#line 133 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			StrictFuture<Void> __when_expr_1 = delay(0.1);
															#line 133 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			if (static_cast<GetBulkLoadTaskStateFromDataMoveActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1672 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<GetBulkLoadTaskStateFromDataMoveActor*>(this)->actor_wait_state = 2;
															#line 133 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetBulkLoadTaskStateFromDataMoveActor, 1, Void >*>(static_cast<GetBulkLoadTaskStateFromDataMoveActor*>(this)));
															#line 1677 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& __val,int loopDepth) 
	{
															#line 121 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		val = __val;
															#line 1691 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && __val,int loopDepth) 
	{
		val = std::move(__val);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetBulkLoadTaskStateFromDataMoveActor*>(this)->actor_wait_state > 0) static_cast<GetBulkLoadTaskStateFromDataMoveActor*>(this)->actor_wait_state = 0;
		static_cast<GetBulkLoadTaskStateFromDataMoveActor*>(this)->ActorCallback< GetBulkLoadTaskStateFromDataMoveActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< GetBulkLoadTaskStateFromDataMoveActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("getBulkLoadTaskStateFromDataMove", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetBulkLoadTaskStateFromDataMoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBulkLoadTaskStateFromDataMove", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetBulkLoadTaskStateFromDataMoveActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("getBulkLoadTaskStateFromDataMove", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetBulkLoadTaskStateFromDataMoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBulkLoadTaskStateFromDataMove", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetBulkLoadTaskStateFromDataMoveActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("getBulkLoadTaskStateFromDataMove", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetBulkLoadTaskStateFromDataMoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBulkLoadTaskStateFromDataMove", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 139 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (val.present())
															#line 1770 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		{
															#line 140 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			dataMoveMetaData = decodeDataMoveValue(val.get());
															#line 141 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			if (dataMoveMetaData.bulkLoadTaskState.present())
															#line 1776 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
			{
															#line 142 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
				if (metadataRetryCount > 0 || retryCount > 0)
															#line 1780 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
				{
															#line 143 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
					TraceEvent(SevInfo, "SSBulkLoadTaskGotMetadata", logId) .detail("DataMoveID", dataMoveId) .detail("MetadataRetryCount", metadataRetryCount) .detail("VersionRetryCount", retryCount) .detail("ElapsedSec", now() - startTime);
															#line 1784 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
				}
															#line 149 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
				if (!static_cast<GetBulkLoadTaskStateFromDataMoveActor*>(this)->SAV<BulkLoadTaskState>::futures) { (void)(dataMoveMetaData.bulkLoadTaskState.get()); this->~GetBulkLoadTaskStateFromDataMoveActorState(); static_cast<GetBulkLoadTaskStateFromDataMoveActor*>(this)->destroy(); return 0; }
															#line 1788 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
				new (&static_cast<GetBulkLoadTaskStateFromDataMoveActor*>(this)->SAV< BulkLoadTaskState >::value()) BulkLoadTaskState(dataMoveMetaData.bulkLoadTaskState.get());
				this->~GetBulkLoadTaskStateFromDataMoveActorState();
				static_cast<GetBulkLoadTaskStateFromDataMoveActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 151 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
				metadataRetryCount++;
															#line 152 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
				if (metadataRetryCount % 100 == 0)
															#line 1800 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
				{
															#line 153 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
					TraceEvent(SevWarn, "SSBulkLoadTaskWaitingForMetadata", logId) .detail("DataMoveID", dataMoveId) .detail("DataMovePhase", static_cast<int>(dataMoveMetaData.getPhase())) .detail("MetadataRetryCount", metadataRetryCount) .detail("ElapsedSec", now() - startTime) .detail("Message", "DataMove exists but BulkLoadTaskState not yet written");
															#line 1804 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
				}
															#line 160 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
				StrictFuture<Void> __when_expr_2 = delay(0.1);
															#line 160 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
				if (static_cast<GetBulkLoadTaskStateFromDataMoveActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1810 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
				if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
				static_cast<GetBulkLoadTaskStateFromDataMoveActor*>(this)->actor_wait_state = 3;
															#line 160 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
				__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetBulkLoadTaskStateFromDataMoveActor, 2, Void >*>(static_cast<GetBulkLoadTaskStateFromDataMoveActor*>(this)));
															#line 1815 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
		}
		else
		{
			loopDepth = a_body1loopBody1cont7(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
															#line 134 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		tr.reset();
															#line 135 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 136 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 1834 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
															#line 134 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		tr.reset();
															#line 135 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 136 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 1847 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetBulkLoadTaskStateFromDataMoveActor*>(this)->actor_wait_state > 0) static_cast<GetBulkLoadTaskStateFromDataMoveActor*>(this)->actor_wait_state = 0;
		static_cast<GetBulkLoadTaskStateFromDataMoveActor*>(this)->ActorCallback< GetBulkLoadTaskStateFromDataMoveActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetBulkLoadTaskStateFromDataMoveActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getBulkLoadTaskStateFromDataMove", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetBulkLoadTaskStateFromDataMoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBulkLoadTaskStateFromDataMove", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetBulkLoadTaskStateFromDataMoveActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getBulkLoadTaskStateFromDataMove", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetBulkLoadTaskStateFromDataMoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBulkLoadTaskStateFromDataMove", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetBulkLoadTaskStateFromDataMoveActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getBulkLoadTaskStateFromDataMove", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetBulkLoadTaskStateFromDataMoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBulkLoadTaskStateFromDataMove", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont7(int loopDepth) 
	{
															#line 172 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		TraceEvent(SevWarnAlways, "SSBulkLoadTaskDataMoveIdNotExist", logId) .detail("Message", "This fetchKey is blocked and will be cancelled later") .detail("DataMoveID", dataMoveId) .detail("ReadVersion", tr.getReadVersion().get()) .detail("AtLeastVersion", atLeastVersion) .detail("ElapsedSec", now() - startTime);
															#line 178 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		StrictFuture<Void> __when_expr_3 = Never();
															#line 178 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (static_cast<GetBulkLoadTaskStateFromDataMoveActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1935 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont7when1(__when_expr_3.get(), loopDepth); };
		static_cast<GetBulkLoadTaskStateFromDataMoveActor*>(this)->actor_wait_state = 4;
															#line 178 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< GetBulkLoadTaskStateFromDataMoveActor, 3, Void >*>(static_cast<GetBulkLoadTaskStateFromDataMoveActor*>(this)));
															#line 1940 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont11(Void const& _,int loopDepth) 
	{
															#line 161 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		tr.reset();
															#line 162 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 163 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 1953 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1cont11(Void && _,int loopDepth) 
	{
															#line 161 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		tr.reset();
															#line 162 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 163 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 1966 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GetBulkLoadTaskStateFromDataMoveActor*>(this)->actor_wait_state > 0) static_cast<GetBulkLoadTaskStateFromDataMoveActor*>(this)->actor_wait_state = 0;
		static_cast<GetBulkLoadTaskStateFromDataMoveActor*>(this)->ActorCallback< GetBulkLoadTaskStateFromDataMoveActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetBulkLoadTaskStateFromDataMoveActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getBulkLoadTaskStateFromDataMove", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetBulkLoadTaskStateFromDataMoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBulkLoadTaskStateFromDataMove", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetBulkLoadTaskStateFromDataMoveActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getBulkLoadTaskStateFromDataMove", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetBulkLoadTaskStateFromDataMoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBulkLoadTaskStateFromDataMove", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetBulkLoadTaskStateFromDataMoveActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getBulkLoadTaskStateFromDataMove", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetBulkLoadTaskStateFromDataMoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBulkLoadTaskStateFromDataMove", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont13(Void const& _,int loopDepth) 
	{
															#line 179 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		return a_body1loopBody1Catch1(internal_error(), loopDepth);
															#line 2050 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"

		return loopDepth;
	}
	int a_body1loopBody1cont13(Void && _,int loopDepth) 
	{
															#line 179 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		return a_body1loopBody1Catch1(internal_error(), loopDepth);
															#line 2058 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"

		return loopDepth;
	}
	int a_body1loopBody1cont7when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont13(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont7when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont13(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<GetBulkLoadTaskStateFromDataMoveActor*>(this)->actor_wait_state > 0) static_cast<GetBulkLoadTaskStateFromDataMoveActor*>(this)->actor_wait_state = 0;
		static_cast<GetBulkLoadTaskStateFromDataMoveActor*>(this)->ActorCallback< GetBulkLoadTaskStateFromDataMoveActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetBulkLoadTaskStateFromDataMoveActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getBulkLoadTaskStateFromDataMove", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetBulkLoadTaskStateFromDataMoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBulkLoadTaskStateFromDataMove", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< GetBulkLoadTaskStateFromDataMoveActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getBulkLoadTaskStateFromDataMove", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetBulkLoadTaskStateFromDataMoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBulkLoadTaskStateFromDataMove", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< GetBulkLoadTaskStateFromDataMoveActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getBulkLoadTaskStateFromDataMove", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetBulkLoadTaskStateFromDataMoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBulkLoadTaskStateFromDataMove", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<GetBulkLoadTaskStateFromDataMoveActor*>(this)->actor_wait_state > 0) static_cast<GetBulkLoadTaskStateFromDataMoveActor*>(this)->actor_wait_state = 0;
		static_cast<GetBulkLoadTaskStateFromDataMoveActor*>(this)->ActorCallback< GetBulkLoadTaskStateFromDataMoveActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetBulkLoadTaskStateFromDataMoveActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getBulkLoadTaskStateFromDataMove", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetBulkLoadTaskStateFromDataMoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBulkLoadTaskStateFromDataMove", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< GetBulkLoadTaskStateFromDataMoveActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getBulkLoadTaskStateFromDataMove", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetBulkLoadTaskStateFromDataMoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBulkLoadTaskStateFromDataMove", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< GetBulkLoadTaskStateFromDataMoveActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getBulkLoadTaskStateFromDataMove", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetBulkLoadTaskStateFromDataMoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBulkLoadTaskStateFromDataMove", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 109 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	Database cx;
															#line 109 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	UID dataMoveId;
															#line 109 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	Version atLeastVersion;
															#line 109 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	UID logId;
															#line 113 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	Transaction tr;
															#line 114 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	int retryCount;
															#line 115 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	int metadataRetryCount;
															#line 116 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	double startTime;
															#line 121 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	Optional<Value> val;
															#line 140 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	DataMoveMetaData dataMoveMetaData;
															#line 2244 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getBulkLoadTaskStateFromDataMove()
															#line 109 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
class GetBulkLoadTaskStateFromDataMoveActor final : public Actor<BulkLoadTaskState>, public ActorCallback< GetBulkLoadTaskStateFromDataMoveActor, 0, Optional<Value> >, public ActorCallback< GetBulkLoadTaskStateFromDataMoveActor, 1, Void >, public ActorCallback< GetBulkLoadTaskStateFromDataMoveActor, 2, Void >, public ActorCallback< GetBulkLoadTaskStateFromDataMoveActor, 3, Void >, public ActorCallback< GetBulkLoadTaskStateFromDataMoveActor, 4, Void >, public FastAllocated<GetBulkLoadTaskStateFromDataMoveActor>, public GetBulkLoadTaskStateFromDataMoveActorState<GetBulkLoadTaskStateFromDataMoveActor> {
															#line 2249 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetBulkLoadTaskStateFromDataMoveActor>::operator new;
	using FastAllocated<GetBulkLoadTaskStateFromDataMoveActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7194647971426112256UL, 11560993328333544192UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<BulkLoadTaskState>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetBulkLoadTaskStateFromDataMoveActor, 0, Optional<Value> >;
friend struct ActorCallback< GetBulkLoadTaskStateFromDataMoveActor, 1, Void >;
friend struct ActorCallback< GetBulkLoadTaskStateFromDataMoveActor, 2, Void >;
friend struct ActorCallback< GetBulkLoadTaskStateFromDataMoveActor, 3, Void >;
friend struct ActorCallback< GetBulkLoadTaskStateFromDataMoveActor, 4, Void >;
															#line 109 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	GetBulkLoadTaskStateFromDataMoveActor(Database const& cx,UID const& dataMoveId,Version const& atLeastVersion,UID const& logId) 
															#line 2270 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		 : Actor<BulkLoadTaskState>(),
		   GetBulkLoadTaskStateFromDataMoveActorState<GetBulkLoadTaskStateFromDataMoveActor>(cx, dataMoveId, atLeastVersion, logId),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getBulkLoadTaskStateFromDataMove", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12479688157220202496UL, 14588692596896574464UL);
		ActorExecutionContextHelper __helper(static_cast<GetBulkLoadTaskStateFromDataMoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getBulkLoadTaskStateFromDataMove");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getBulkLoadTaskStateFromDataMove", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetBulkLoadTaskStateFromDataMoveActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetBulkLoadTaskStateFromDataMoveActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GetBulkLoadTaskStateFromDataMoveActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< GetBulkLoadTaskStateFromDataMoveActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< GetBulkLoadTaskStateFromDataMoveActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 109 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
[[nodiscard]] Future<BulkLoadTaskState> getBulkLoadTaskStateFromDataMove( Database const& cx, UID const& dataMoveId, Version const& atLeastVersion, UID const& logId ) {
															#line 109 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	return Future<BulkLoadTaskState>(new GetBulkLoadTaskStateFromDataMoveActor(cx, dataMoveId, atLeastVersion, logId));
															#line 2307 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
}

#line 185 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"

// Return true if generated the byte sampling file. Otherwise, return false.
// TODO(BulkDump): directly read from special key space.
															#line 2314 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via doBytesSamplingOnDataFile()
															#line 188 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
template <class DoBytesSamplingOnDataFileActor>
															#line 188 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
class DoBytesSamplingOnDataFileActorState {
															#line 2321 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
public:
															#line 188 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	DoBytesSamplingOnDataFileActorState(std::string const& dataFileFullPath,std::string const& byteSampleFileFullPath,UID const& logId) 
															#line 188 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
															#line 188 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		 : dataFileFullPath(dataFileFullPath),
															#line 188 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		   byteSampleFileFullPath(byteSampleFileFullPath),
															#line 188 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		   logId(logId),
															#line 191 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		   counter(0),
															#line 192 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		   res(false),
															#line 193 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		   retryCount(0),
															#line 194 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		   startTime(now())
															#line 2340 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("doBytesSamplingOnDataFile", reinterpret_cast<unsigned long>(this));

	}
	~DoBytesSamplingOnDataFileActorState() 
	{
		fdb_probe_actor_destroy("doBytesSamplingOnDataFile", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 195 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			;
															#line 2355 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DoBytesSamplingOnDataFileActorState();
		static_cast<DoBytesSamplingOnDataFileActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 241 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		TraceEvent(bulkLoadVerboseEventSev(), "SSBulkLoadTaskSamplingComplete", logId) .detail("DataFileFullPath", dataFileFullPath) .detail("ByteSampleFileFullPath", byteSampleFileFullPath) .detail("Duration", now() - startTime) .detail("RetryCount", retryCount);
															#line 246 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (!static_cast<DoBytesSamplingOnDataFileActor*>(this)->SAV<bool>::futures) { (void)(res); this->~DoBytesSamplingOnDataFileActorState(); static_cast<DoBytesSamplingOnDataFileActor*>(this)->destroy(); return 0; }
															#line 2380 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		new (&static_cast<DoBytesSamplingOnDataFileActor*>(this)->SAV< bool >::value()) bool(std::move(res)); // state_var_RVO
		this->~DoBytesSamplingOnDataFileActorState();
		static_cast<DoBytesSamplingOnDataFileActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 197 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			sstWriter = newRocksDBSstFileWriter();
															#line 198 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			sstWriter->open(abspath(byteSampleFileFullPath));
															#line 199 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			anySampled = false;
															#line 200 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			reader = newRocksDBSstFileReader();
															#line 201 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			reader->open(abspath(dataFileFullPath));
															#line 202 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			;
															#line 2410 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
			loopDepth = a_body1loopBody1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 227 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 2445 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
			{
															#line 228 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 2449 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
			}
															#line 230 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			TraceEvent(SevWarn, "SSBulkLoadTaskSamplingError", logId) .errorUnsuppressed(e) .detail("DataFileFullPath", dataFileFullPath) .detail("ByteSampleFileFullPath", byteSampleFileFullPath) .detail("Duration", now() - startTime) .detail("RetryCount", retryCount);
															#line 236 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			StrictFuture<Void> __when_expr_1 = delay(5.0);
															#line 236 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			if (static_cast<DoBytesSamplingOnDataFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2457 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<DoBytesSamplingOnDataFileActor*>(this)->actor_wait_state = 2;
															#line 236 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DoBytesSamplingOnDataFileActor, 1, Void >*>(static_cast<DoBytesSamplingOnDataFileActor*>(this)));
															#line 2462 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 218 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (anySampled)
															#line 2477 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		{
															#line 219 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			ASSERT(sstWriter->finish());
															#line 220 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			res = true;
															#line 2483 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		}
		else
		{
															#line 222 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			ASSERT(!sstWriter->finish());
															#line 223 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			deleteFile(abspath(byteSampleFileFullPath));
															#line 2491 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		}
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
															#line 202 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (!(reader->hasNext()))
															#line 2508 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		{
			return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 203 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		KeyValue kv = reader->next();
															#line 204 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		ByteSampleInfo sampleInfo = isKeyValueInSample(kv);
															#line 205 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (sampleInfo.inSample)
															#line 2518 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		{
															#line 206 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			sstWriter->write(kv.key, BinaryWriter::toValue(sampleInfo.sampledSize, Unversioned()));
															#line 207 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			anySampled = true;
															#line 208 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			counter++;
															#line 209 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			if (counter > SERVER_KNOBS->BULKLOAD_BYTE_SAMPLE_BATCH_KEY_COUNT)
															#line 2528 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
			{
															#line 210 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
				StrictFuture<Void> __when_expr_0 = yield();
															#line 210 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
				if (static_cast<DoBytesSamplingOnDataFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2534 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
				static_cast<DoBytesSamplingOnDataFileActor*>(this)->actor_wait_state = 1;
															#line 210 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DoBytesSamplingOnDataFileActor, 0, Void >*>(static_cast<DoBytesSamplingOnDataFileActor*>(this)));
															#line 2539 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1loopBody1loopBody1cont3(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3(int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont4(Void const& _,int loopDepth) 
	{
															#line 211 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		counter = 0;
															#line 2583 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont4(Void && _,int loopDepth) 
	{
															#line 211 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		counter = 0;
															#line 2592 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DoBytesSamplingOnDataFileActor*>(this)->actor_wait_state > 0) static_cast<DoBytesSamplingOnDataFileActor*>(this)->actor_wait_state = 0;
		static_cast<DoBytesSamplingOnDataFileActor*>(this)->ActorCallback< DoBytesSamplingOnDataFileActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoBytesSamplingOnDataFileActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doBytesSamplingOnDataFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBytesSamplingOnDataFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBytesSamplingOnDataFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DoBytesSamplingOnDataFileActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doBytesSamplingOnDataFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBytesSamplingOnDataFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBytesSamplingOnDataFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DoBytesSamplingOnDataFileActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doBytesSamplingOnDataFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoBytesSamplingOnDataFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBytesSamplingOnDataFile", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
															#line 237 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		deleteFile(abspath(byteSampleFileFullPath));
															#line 238 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		retryCount++;
															#line 2678 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
															#line 237 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		deleteFile(abspath(byteSampleFileFullPath));
															#line 238 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		retryCount++;
															#line 2689 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DoBytesSamplingOnDataFileActor*>(this)->actor_wait_state > 0) static_cast<DoBytesSamplingOnDataFileActor*>(this)->actor_wait_state = 0;
		static_cast<DoBytesSamplingOnDataFileActor*>(this)->ActorCallback< DoBytesSamplingOnDataFileActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoBytesSamplingOnDataFileActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doBytesSamplingOnDataFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBytesSamplingOnDataFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBytesSamplingOnDataFile", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DoBytesSamplingOnDataFileActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doBytesSamplingOnDataFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBytesSamplingOnDataFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBytesSamplingOnDataFile", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DoBytesSamplingOnDataFileActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doBytesSamplingOnDataFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoBytesSamplingOnDataFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBytesSamplingOnDataFile", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 188 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	std::string dataFileFullPath;
															#line 188 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	std::string byteSampleFileFullPath;
															#line 188 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	UID logId;
															#line 191 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	int counter;
															#line 192 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	bool res;
															#line 193 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	int retryCount;
															#line 194 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	double startTime;
															#line 197 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	std::unique_ptr<IRocksDBSstFileWriter> sstWriter;
															#line 199 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	bool anySampled;
															#line 200 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	std::unique_ptr<IRocksDBSstFileReader> reader;
															#line 2789 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
};
// This generated class is to be used only via doBytesSamplingOnDataFile()
															#line 188 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
class DoBytesSamplingOnDataFileActor final : public Actor<bool>, public ActorCallback< DoBytesSamplingOnDataFileActor, 0, Void >, public ActorCallback< DoBytesSamplingOnDataFileActor, 1, Void >, public FastAllocated<DoBytesSamplingOnDataFileActor>, public DoBytesSamplingOnDataFileActorState<DoBytesSamplingOnDataFileActor> {
															#line 2794 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
public:
	using FastAllocated<DoBytesSamplingOnDataFileActor>::operator new;
	using FastAllocated<DoBytesSamplingOnDataFileActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6445167535547581440UL, 12930426106328396288UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DoBytesSamplingOnDataFileActor, 0, Void >;
friend struct ActorCallback< DoBytesSamplingOnDataFileActor, 1, Void >;
															#line 188 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	DoBytesSamplingOnDataFileActor(std::string const& dataFileFullPath,std::string const& byteSampleFileFullPath,UID const& logId) 
															#line 2812 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		 : Actor<bool>(),
		   DoBytesSamplingOnDataFileActorState<DoBytesSamplingOnDataFileActor>(dataFileFullPath, byteSampleFileFullPath, logId),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("doBytesSamplingOnDataFile", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6947520146366501888UL, 10722775557252509440UL);
		ActorExecutionContextHelper __helper(static_cast<DoBytesSamplingOnDataFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("doBytesSamplingOnDataFile");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("doBytesSamplingOnDataFile", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DoBytesSamplingOnDataFileActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DoBytesSamplingOnDataFileActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 188 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
[[nodiscard]] Future<bool> doBytesSamplingOnDataFile( std::string const& dataFileFullPath, std::string const& byteSampleFileFullPath, UID const& logId ) {
															#line 188 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	return Future<bool>(new DoBytesSamplingOnDataFileActor(dataFileFullPath, byteSampleFileFullPath, logId));
															#line 2846 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
}

#line 248 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"

// TODO(BulkLoad): slow task
void clearFileFolder(const std::string& folderPath, const UID& logId, bool ignoreError) {
	try {
		platform::eraseDirectoryRecursive(abspath(folderPath));
	} catch (Error& e) {
		if (logId.isValid()) {
			TraceEvent(ignoreError ? SevWarn : SevWarnAlways, "ClearFileFolderError", logId)
			    .error(e)
			    .detail("FolderPath", folderPath);
		}
		if (ignoreError) {
			return;
		}
		throw e;
	}
	return;
}

// TODO(BulkLoad): slow task
void resetFileFolder(const std::string& folderPath) {
	clearFileFolder(abspath(folderPath));
	ASSERT(platform::createDirectory(abspath(folderPath)));
	return;
}

															#line 2876 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via bulkLoadTransportCP_impl()
															#line 274 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
template <class BulkLoadTransportCP_implActor>
															#line 274 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
class BulkLoadTransportCP_implActorState {
															#line 2883 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
public:
															#line 274 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	BulkLoadTransportCP_implActorState(BulkLoadFileSet const& fromRemoteFileSet,BulkLoadFileSet const& toLocalFileSet,size_t const& fileBytesMax,UID const& logId) 
															#line 274 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
															#line 274 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		 : fromRemoteFileSet(fromRemoteFileSet),
															#line 274 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		   toLocalFileSet(toLocalFileSet),
															#line 274 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		   fileBytesMax(fileBytesMax),
															#line 274 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		   logId(logId)
															#line 2896 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("bulkLoadTransportCP_impl", reinterpret_cast<unsigned long>(this));

	}
	~BulkLoadTransportCP_implActorState() 
	{
		fdb_probe_actor_destroy("bulkLoadTransportCP_impl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 279 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			resetFileFolder(abspath(toLocalFileSet.getFolder()));
															#line 281 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			StrictFuture<Void> __when_expr_0 = copyBulkFile( abspath(fromRemoteFileSet.getDataFileFullPath()), abspath(toLocalFileSet.getDataFileFullPath()), fileBytesMax);
															#line 281 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			if (static_cast<BulkLoadTransportCP_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2915 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<BulkLoadTransportCP_implActor*>(this)->actor_wait_state = 1;
															#line 281 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< BulkLoadTransportCP_implActor, 0, Void >*>(static_cast<BulkLoadTransportCP_implActor*>(this)));
															#line 2920 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~BulkLoadTransportCP_implActorState();
		static_cast<BulkLoadTransportCP_implActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 284 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (fromRemoteFileSet.hasByteSampleFile())
															#line 2943 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		{
															#line 285 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			StrictFuture<Void> __when_expr_1 = copyBulkFile(abspath(fromRemoteFileSet.getBytesSampleFileFullPath()), abspath(toLocalFileSet.getBytesSampleFileFullPath()), fileBytesMax);
															#line 285 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			if (static_cast<BulkLoadTransportCP_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2949 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<BulkLoadTransportCP_implActor*>(this)->actor_wait_state = 2;
															#line 285 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< BulkLoadTransportCP_implActor, 1, Void >*>(static_cast<BulkLoadTransportCP_implActor*>(this)));
															#line 2954 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 284 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (fromRemoteFileSet.hasByteSampleFile())
															#line 2968 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		{
															#line 285 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			StrictFuture<Void> __when_expr_1 = copyBulkFile(abspath(fromRemoteFileSet.getBytesSampleFileFullPath()), abspath(toLocalFileSet.getBytesSampleFileFullPath()), fileBytesMax);
															#line 285 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			if (static_cast<BulkLoadTransportCP_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2974 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<BulkLoadTransportCP_implActor*>(this)->actor_wait_state = 2;
															#line 285 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< BulkLoadTransportCP_implActor, 1, Void >*>(static_cast<BulkLoadTransportCP_implActor*>(this)));
															#line 2979 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<BulkLoadTransportCP_implActor*>(this)->actor_wait_state > 0) static_cast<BulkLoadTransportCP_implActor*>(this)->actor_wait_state = 0;
		static_cast<BulkLoadTransportCP_implActor*>(this)->ActorCallback< BulkLoadTransportCP_implActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BulkLoadTransportCP_implActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("bulkLoadTransportCP_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadTransportCP_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadTransportCP_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< BulkLoadTransportCP_implActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("bulkLoadTransportCP_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadTransportCP_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadTransportCP_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< BulkLoadTransportCP_implActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("bulkLoadTransportCP_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadTransportCP_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadTransportCP_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 290 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (!static_cast<BulkLoadTransportCP_implActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~BulkLoadTransportCP_implActorState(); static_cast<BulkLoadTransportCP_implActor*>(this)->destroy(); return 0; }
															#line 3068 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		new (&static_cast<BulkLoadTransportCP_implActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~BulkLoadTransportCP_implActorState();
		static_cast<BulkLoadTransportCP_implActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<BulkLoadTransportCP_implActor*>(this)->actor_wait_state > 0) static_cast<BulkLoadTransportCP_implActor*>(this)->actor_wait_state = 0;
		static_cast<BulkLoadTransportCP_implActor*>(this)->ActorCallback< BulkLoadTransportCP_implActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BulkLoadTransportCP_implActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("bulkLoadTransportCP_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadTransportCP_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadTransportCP_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< BulkLoadTransportCP_implActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("bulkLoadTransportCP_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadTransportCP_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadTransportCP_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< BulkLoadTransportCP_implActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("bulkLoadTransportCP_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadTransportCP_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadTransportCP_impl", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 274 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	BulkLoadFileSet fromRemoteFileSet;
															#line 274 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	BulkLoadFileSet toLocalFileSet;
															#line 274 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	size_t fileBytesMax;
															#line 274 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	UID logId;
															#line 3171 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
};
// This generated class is to be used only via bulkLoadTransportCP_impl()
															#line 274 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
class BulkLoadTransportCP_implActor final : public Actor<Void>, public ActorCallback< BulkLoadTransportCP_implActor, 0, Void >, public ActorCallback< BulkLoadTransportCP_implActor, 1, Void >, public FastAllocated<BulkLoadTransportCP_implActor>, public BulkLoadTransportCP_implActorState<BulkLoadTransportCP_implActor> {
															#line 3176 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
public:
	using FastAllocated<BulkLoadTransportCP_implActor>::operator new;
	using FastAllocated<BulkLoadTransportCP_implActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4662393640253639936UL, 1065439918045125376UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< BulkLoadTransportCP_implActor, 0, Void >;
friend struct ActorCallback< BulkLoadTransportCP_implActor, 1, Void >;
															#line 274 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	BulkLoadTransportCP_implActor(BulkLoadFileSet const& fromRemoteFileSet,BulkLoadFileSet const& toLocalFileSet,size_t const& fileBytesMax,UID const& logId) 
															#line 3194 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   BulkLoadTransportCP_implActorState<BulkLoadTransportCP_implActor>(fromRemoteFileSet, toLocalFileSet, fileBytesMax, logId),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("bulkLoadTransportCP_impl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5706731850230082304UL, 2932857527623400704UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadTransportCP_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("bulkLoadTransportCP_impl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("bulkLoadTransportCP_impl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< BulkLoadTransportCP_implActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< BulkLoadTransportCP_implActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 274 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
[[nodiscard]] Future<Void> bulkLoadTransportCP_impl( BulkLoadFileSet const& fromRemoteFileSet, BulkLoadFileSet const& toLocalFileSet, size_t const& fileBytesMax, UID const& logId ) {
															#line 274 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	return Future<Void>(new BulkLoadTransportCP_implActor(fromRemoteFileSet, toLocalFileSet, fileBytesMax, logId));
															#line 3228 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
}

#line 292 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"

															#line 3233 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via bulkLoadTransportBlobstore_impl()
															#line 293 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
template <class BulkLoadTransportBlobstore_implActor>
															#line 293 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
class BulkLoadTransportBlobstore_implActorState {
															#line 3240 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
public:
															#line 293 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	BulkLoadTransportBlobstore_implActorState(BulkLoadFileSet const& fromRemoteFileSet,BulkLoadFileSet const& toLocalFileSet,size_t const& fileBytesMax,UID const& logId) 
															#line 293 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
															#line 293 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		 : fromRemoteFileSet(fromRemoteFileSet),
															#line 293 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		   toLocalFileSet(toLocalFileSet),
															#line 293 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		   fileBytesMax(fileBytesMax),
															#line 293 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		   logId(logId)
															#line 3253 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("bulkLoadTransportBlobstore_impl", reinterpret_cast<unsigned long>(this));

	}
	~BulkLoadTransportBlobstore_implActorState() 
	{
		fdb_probe_actor_destroy("bulkLoadTransportBlobstore_impl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 298 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			resetFileFolder(abspath(toLocalFileSet.getFolder()));
															#line 299 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			TraceEvent(SevDebug, "BulkLoadBlobstoreTransportStart", logId) .detail("FromRemote", fromRemoteFileSet.toString()) .detail("ToLocal", toLocalFileSet.toString()) .detail("HasDataFile", fromRemoteFileSet.hasDataFile());
															#line 306 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			if (fromRemoteFileSet.hasDataFile())
															#line 3272 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
			{
															#line 307 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
				TraceEvent(SevDebug, "BulkLoadBlobstoreBeforeCopyDataFile", logId) .detail("FromPath", fromRemoteFileSet.getDataFileFullPath()) .detail("ToPath", abspath(toLocalFileSet.getDataFileFullPath()));
															#line 310 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
				StrictFuture<Void> __when_expr_0 = copyDownFile(fromRemoteFileSet.getDataFileFullPath(), abspath(toLocalFileSet.getDataFileFullPath()));
															#line 310 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
				if (static_cast<BulkLoadTransportBlobstore_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3280 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<BulkLoadTransportBlobstore_implActor*>(this)->actor_wait_state = 1;
															#line 310 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< BulkLoadTransportBlobstore_implActor, 0, Void >*>(static_cast<BulkLoadTransportBlobstore_implActor*>(this)));
															#line 3285 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
															#line 313 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
				TraceEvent("BulkLoadBlobstoreSkipEmptyRange", logId).detail("Reason", "No data file for empty range");
															#line 3292 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~BulkLoadTransportBlobstore_implActorState();
		static_cast<BulkLoadTransportBlobstore_implActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 316 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (fromRemoteFileSet.hasByteSampleFile())
															#line 3316 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		{
															#line 317 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			TraceEvent(SevDebug, "BulkLoadBlobstoreBeforeCopySampleFile", logId) .detail("FromPath", fromRemoteFileSet.getBytesSampleFileFullPath()) .detail("ToPath", abspath(toLocalFileSet.getBytesSampleFileFullPath()));
															#line 320 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			StrictFuture<Void> __when_expr_1 = copyDownFile(fromRemoteFileSet.getBytesSampleFileFullPath(), abspath(toLocalFileSet.getBytesSampleFileFullPath()));
															#line 320 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			if (static_cast<BulkLoadTransportBlobstore_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3324 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<BulkLoadTransportBlobstore_implActor*>(this)->actor_wait_state = 2;
															#line 320 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< BulkLoadTransportBlobstore_implActor, 1, Void >*>(static_cast<BulkLoadTransportBlobstore_implActor*>(this)));
															#line 3329 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont5(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 311 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		TraceEvent(SevDebug, "BulkLoadBlobstoreAfterCopyDataFile", logId);
															#line 3343 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 311 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		TraceEvent(SevDebug, "BulkLoadBlobstoreAfterCopyDataFile", logId);
															#line 3352 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<BulkLoadTransportBlobstore_implActor*>(this)->actor_wait_state > 0) static_cast<BulkLoadTransportBlobstore_implActor*>(this)->actor_wait_state = 0;
		static_cast<BulkLoadTransportBlobstore_implActor*>(this)->ActorCallback< BulkLoadTransportBlobstore_implActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BulkLoadTransportBlobstore_implActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("bulkLoadTransportBlobstore_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadTransportBlobstore_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadTransportBlobstore_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< BulkLoadTransportBlobstore_implActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("bulkLoadTransportBlobstore_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadTransportBlobstore_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadTransportBlobstore_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< BulkLoadTransportBlobstore_implActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("bulkLoadTransportBlobstore_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadTransportBlobstore_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadTransportBlobstore_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont5(int loopDepth) 
	{
															#line 325 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		TraceEvent(SevDebug, "BulkLoadBlobstoreTransportEnd", logId);
															#line 326 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (!static_cast<BulkLoadTransportBlobstore_implActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~BulkLoadTransportBlobstore_implActorState(); static_cast<BulkLoadTransportBlobstore_implActor*>(this)->destroy(); return 0; }
															#line 3438 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		new (&static_cast<BulkLoadTransportBlobstore_implActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~BulkLoadTransportBlobstore_implActorState();
		static_cast<BulkLoadTransportBlobstore_implActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 322 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		TraceEvent(SevDebug, "BulkLoadBlobstoreAfterCopySampleFile", logId);
															#line 3450 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 322 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		TraceEvent(SevDebug, "BulkLoadBlobstoreAfterCopySampleFile", logId);
															#line 3459 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<BulkLoadTransportBlobstore_implActor*>(this)->actor_wait_state > 0) static_cast<BulkLoadTransportBlobstore_implActor*>(this)->actor_wait_state = 0;
		static_cast<BulkLoadTransportBlobstore_implActor*>(this)->ActorCallback< BulkLoadTransportBlobstore_implActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BulkLoadTransportBlobstore_implActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("bulkLoadTransportBlobstore_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadTransportBlobstore_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadTransportBlobstore_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< BulkLoadTransportBlobstore_implActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("bulkLoadTransportBlobstore_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadTransportBlobstore_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadTransportBlobstore_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< BulkLoadTransportBlobstore_implActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("bulkLoadTransportBlobstore_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadTransportBlobstore_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadTransportBlobstore_impl", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 293 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	BulkLoadFileSet fromRemoteFileSet;
															#line 293 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	BulkLoadFileSet toLocalFileSet;
															#line 293 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	size_t fileBytesMax;
															#line 293 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	UID logId;
															#line 3547 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
};
// This generated class is to be used only via bulkLoadTransportBlobstore_impl()
															#line 293 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
class BulkLoadTransportBlobstore_implActor final : public Actor<Void>, public ActorCallback< BulkLoadTransportBlobstore_implActor, 0, Void >, public ActorCallback< BulkLoadTransportBlobstore_implActor, 1, Void >, public FastAllocated<BulkLoadTransportBlobstore_implActor>, public BulkLoadTransportBlobstore_implActorState<BulkLoadTransportBlobstore_implActor> {
															#line 3552 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
public:
	using FastAllocated<BulkLoadTransportBlobstore_implActor>::operator new;
	using FastAllocated<BulkLoadTransportBlobstore_implActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3090346122454093056UL, 10303659783895945216UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< BulkLoadTransportBlobstore_implActor, 0, Void >;
friend struct ActorCallback< BulkLoadTransportBlobstore_implActor, 1, Void >;
															#line 293 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	BulkLoadTransportBlobstore_implActor(BulkLoadFileSet const& fromRemoteFileSet,BulkLoadFileSet const& toLocalFileSet,size_t const& fileBytesMax,UID const& logId) 
															#line 3570 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   BulkLoadTransportBlobstore_implActorState<BulkLoadTransportBlobstore_implActor>(fromRemoteFileSet, toLocalFileSet, fileBytesMax, logId),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("bulkLoadTransportBlobstore_impl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8411043785109451008UL, 9533312045468678400UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadTransportBlobstore_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("bulkLoadTransportBlobstore_impl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("bulkLoadTransportBlobstore_impl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< BulkLoadTransportBlobstore_implActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< BulkLoadTransportBlobstore_implActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 293 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
[[nodiscard]] Future<Void> bulkLoadTransportBlobstore_impl( BulkLoadFileSet const& fromRemoteFileSet, BulkLoadFileSet const& toLocalFileSet, size_t const& fileBytesMax, UID const& logId ) {
															#line 293 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	return Future<Void>(new BulkLoadTransportBlobstore_implActor(fromRemoteFileSet, toLocalFileSet, fileBytesMax, logId));
															#line 3604 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
}

#line 328 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"

															#line 3609 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via bulkLoadDownloadTaskFileSet()
															#line 329 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
template <class BulkLoadDownloadTaskFileSetActor>
															#line 329 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
class BulkLoadDownloadTaskFileSetActorState {
															#line 3616 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
public:
															#line 329 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	BulkLoadDownloadTaskFileSetActorState(BulkLoadTransportMethod const& transportMethod,BulkLoadFileSet const& fromRemoteFileSet,std::string const& toLocalRoot,UID const& logId) 
															#line 329 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
															#line 329 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		 : transportMethod(transportMethod),
															#line 329 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		   fromRemoteFileSet(fromRemoteFileSet),
															#line 329 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		   toLocalRoot(toLocalRoot),
															#line 329 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		   logId(logId),
															#line 333 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		   retryCount(0),
															#line 334 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		   startTime(now())
															#line 3633 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("bulkLoadDownloadTaskFileSet", reinterpret_cast<unsigned long>(this));

	}
	~BulkLoadDownloadTaskFileSetActorState() 
	{
		fdb_probe_actor_destroy("bulkLoadDownloadTaskFileSet", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 335 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			ASSERT(transportMethod != BulkLoadTransportMethod::Invalid);
															#line 336 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			TraceEvent(SevDebug, "BulkLoadDownloadTaskFileSetStart", logId) .detail("FromRemoteFileSet", fromRemoteFileSet.toString()) .detail("ToLocalRoot", toLocalRoot) .detail("TransportMethod", transportMethod);
															#line 340 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			;
															#line 3652 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~BulkLoadDownloadTaskFileSetActorState();
		static_cast<BulkLoadDownloadTaskFileSetActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 342 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			TraceEvent(SevDebug, "BulkLoadDownloadTaskFileSetAttempt", logId) .detail("RetryCount", retryCount) .detail("Elapsed", now() - startTime);
															#line 346 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			toLocalFileSet = BulkLoadFileSet(toLocalRoot, fromRemoteFileSet.getRelativePath(), fromRemoteFileSet.getManifestFileName(), fromRemoteFileSet.getDataFileName(), fromRemoteFileSet.getByteSampleFileName(), BulkLoadChecksum());
															#line 354 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			if (transportMethod == BulkLoadTransportMethod::CP)
															#line 3687 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
			{
															#line 355 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
				ASSERT(fromRemoteFileSet.hasDataFile());
															#line 356 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
				TraceEvent(SevDebug, "BulkLoadDownloadBeforeCP", logId).detail("Elapsed", now() - startTime);
															#line 359 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
				StrictFuture<Void> __when_expr_0 = bulkLoadTransportCP_impl( fromRemoteFileSet, toLocalFileSet, SERVER_KNOBS->BULKLOAD_FILE_BYTES_MAX, logId);
															#line 359 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
				if (static_cast<BulkLoadDownloadTaskFileSetActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3697 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
				static_cast<BulkLoadDownloadTaskFileSetActor*>(this)->actor_wait_state = 1;
															#line 359 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< BulkLoadDownloadTaskFileSetActor, 0, Void >*>(static_cast<BulkLoadDownloadTaskFileSetActor*>(this)));
															#line 3702 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
															#line 362 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
				if (transportMethod == BulkLoadTransportMethod::BLOBSTORE)
															#line 3709 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
				{
															#line 363 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
					TraceEvent(SevDebug, "BulkLoadDownloadBeforeBlobstore", logId).detail("Elapsed", now() - startTime);
															#line 366 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
					StrictFuture<Void> __when_expr_1 = bulkLoadTransportBlobstore_impl( fromRemoteFileSet, toLocalFileSet, SERVER_KNOBS->BULKLOAD_FILE_BYTES_MAX, logId);
															#line 366 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
					if (static_cast<BulkLoadDownloadTaskFileSetActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3717 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
					if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
					static_cast<BulkLoadDownloadTaskFileSetActor*>(this)->actor_wait_state = 2;
															#line 366 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
					__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< BulkLoadDownloadTaskFileSetActor, 1, Void >*>(static_cast<BulkLoadDownloadTaskFileSetActor*>(this)));
															#line 3722 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
					loopDepth = 0;
				}
				else
				{
															#line 370 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
					UNREACHABLE();
															#line 3729 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
					loopDepth = a_body1loopBody1cont5(loopDepth);
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 381 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 3753 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
			{
															#line 382 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 3757 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
			}
															#line 384 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			TraceEvent(SevWarn, "SSBulkLoadTaskDownloadFileSetError", logId) .errorUnsuppressed(e) .detail("FromRemoteFileSet", fromRemoteFileSet.toString()) .detail("ToLocalRoot", toLocalRoot) .detail("Duration", now() - startTime) .detail("RetryCount", retryCount);
															#line 390 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			retryCount++;
															#line 391 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			if (retryCount > SERVER_KNOBS->BULKLOAD_DOWNLOAD_MAX_RETRIES)
															#line 3765 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
			{
															#line 392 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
				TraceEvent(SevError, "SSBulkLoadTaskDownloadFileSetMaxRetriesExceeded", logId) .errorUnsuppressed(e) .detail("FromRemoteFileSet", fromRemoteFileSet.toString()) .detail("ToLocalRoot", toLocalRoot) .detail("Duration", now() - startTime) .detail("RetryCount", retryCount) .detail("MaxRetries", SERVER_KNOBS->BULKLOAD_DOWNLOAD_MAX_RETRIES) .detail("OriginalError", e.code()) .detail("OriginalErrorName", e.name());
															#line 403 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
				return a_body1Catch1(bulkload_task_failed(), std::max(0, loopDepth - 1));
															#line 3771 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
			}
															#line 405 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			StrictFuture<Void> __when_expr_2 = delay(SERVER_KNOBS->BULKLOAD_DOWNLOAD_RETRY_DELAY);
															#line 405 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			if (static_cast<BulkLoadDownloadTaskFileSetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3777 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<BulkLoadDownloadTaskFileSetActor*>(this)->actor_wait_state = 3;
															#line 405 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< BulkLoadDownloadTaskFileSetActor, 2, Void >*>(static_cast<BulkLoadDownloadTaskFileSetActor*>(this)));
															#line 3782 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 372 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		TraceEvent(bulkLoadVerboseEventSev(), "SSBulkLoadTaskDownloadFileSet", logId) .detail("FromRemoteFileSet", fromRemoteFileSet.toString()) .detail("ToLocalRoot", toLocalRoot) .detail("Duration", now() - startTime) .detail("RetryCount", retryCount);
															#line 378 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (!static_cast<BulkLoadDownloadTaskFileSetActor*>(this)->SAV<BulkLoadFileSet>::futures) { (void)(toLocalFileSet); this->~BulkLoadDownloadTaskFileSetActorState(); static_cast<BulkLoadDownloadTaskFileSetActor*>(this)->destroy(); return 0; }
															#line 3799 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		new (&static_cast<BulkLoadDownloadTaskFileSetActor*>(this)->SAV< BulkLoadFileSet >::value()) BulkLoadFileSet(std::move(toLocalFileSet)); // state_var_RVO
		this->~BulkLoadDownloadTaskFileSetActorState();
		static_cast<BulkLoadDownloadTaskFileSetActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 361 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		TraceEvent(SevDebug, "BulkLoadDownloadAfterCP", logId).detail("Elapsed", now() - startTime);
															#line 3811 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 361 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		TraceEvent(SevDebug, "BulkLoadDownloadAfterCP", logId).detail("Elapsed", now() - startTime);
															#line 3820 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<BulkLoadDownloadTaskFileSetActor*>(this)->actor_wait_state > 0) static_cast<BulkLoadDownloadTaskFileSetActor*>(this)->actor_wait_state = 0;
		static_cast<BulkLoadDownloadTaskFileSetActor*>(this)->ActorCallback< BulkLoadDownloadTaskFileSetActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BulkLoadDownloadTaskFileSetActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("bulkLoadDownloadTaskFileSet", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadDownloadTaskFileSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadDownloadTaskFileSet", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< BulkLoadDownloadTaskFileSetActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("bulkLoadDownloadTaskFileSet", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadDownloadTaskFileSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadDownloadTaskFileSet", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< BulkLoadDownloadTaskFileSetActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("bulkLoadDownloadTaskFileSet", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadDownloadTaskFileSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadDownloadTaskFileSet", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont5(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void const& _,int loopDepth) 
	{
															#line 368 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		TraceEvent(SevDebug, "BulkLoadDownloadAfterBlobstore", logId).detail("Elapsed", now() - startTime);
															#line 3910 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void && _,int loopDepth) 
	{
															#line 368 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		TraceEvent(SevDebug, "BulkLoadDownloadAfterBlobstore", logId).detail("Elapsed", now() - startTime);
															#line 3919 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<BulkLoadDownloadTaskFileSetActor*>(this)->actor_wait_state > 0) static_cast<BulkLoadDownloadTaskFileSetActor*>(this)->actor_wait_state = 0;
		static_cast<BulkLoadDownloadTaskFileSetActor*>(this)->ActorCallback< BulkLoadDownloadTaskFileSetActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BulkLoadDownloadTaskFileSetActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("bulkLoadDownloadTaskFileSet", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadDownloadTaskFileSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadDownloadTaskFileSet", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< BulkLoadDownloadTaskFileSetActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("bulkLoadDownloadTaskFileSet", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadDownloadTaskFileSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadDownloadTaskFileSet", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< BulkLoadDownloadTaskFileSetActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("bulkLoadDownloadTaskFileSet", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadDownloadTaskFileSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadDownloadTaskFileSet", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<BulkLoadDownloadTaskFileSetActor*>(this)->actor_wait_state > 0) static_cast<BulkLoadDownloadTaskFileSetActor*>(this)->actor_wait_state = 0;
		static_cast<BulkLoadDownloadTaskFileSetActor*>(this)->ActorCallback< BulkLoadDownloadTaskFileSetActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BulkLoadDownloadTaskFileSetActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("bulkLoadDownloadTaskFileSet", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadDownloadTaskFileSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadDownloadTaskFileSet", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< BulkLoadDownloadTaskFileSetActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("bulkLoadDownloadTaskFileSet", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadDownloadTaskFileSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadDownloadTaskFileSet", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< BulkLoadDownloadTaskFileSetActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("bulkLoadDownloadTaskFileSet", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadDownloadTaskFileSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadDownloadTaskFileSet", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 329 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	BulkLoadTransportMethod transportMethod;
															#line 329 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	BulkLoadFileSet fromRemoteFileSet;
															#line 329 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	std::string toLocalRoot;
															#line 329 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	UID logId;
															#line 333 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	int retryCount;
															#line 334 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	double startTime;
															#line 346 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	BulkLoadFileSet toLocalFileSet;
															#line 4100 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
};
// This generated class is to be used only via bulkLoadDownloadTaskFileSet()
															#line 329 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
class BulkLoadDownloadTaskFileSetActor final : public Actor<BulkLoadFileSet>, public ActorCallback< BulkLoadDownloadTaskFileSetActor, 0, Void >, public ActorCallback< BulkLoadDownloadTaskFileSetActor, 1, Void >, public ActorCallback< BulkLoadDownloadTaskFileSetActor, 2, Void >, public FastAllocated<BulkLoadDownloadTaskFileSetActor>, public BulkLoadDownloadTaskFileSetActorState<BulkLoadDownloadTaskFileSetActor> {
															#line 4105 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
public:
	using FastAllocated<BulkLoadDownloadTaskFileSetActor>::operator new;
	using FastAllocated<BulkLoadDownloadTaskFileSetActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15540865672482208256UL, 627369344792465408UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<BulkLoadFileSet>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< BulkLoadDownloadTaskFileSetActor, 0, Void >;
friend struct ActorCallback< BulkLoadDownloadTaskFileSetActor, 1, Void >;
friend struct ActorCallback< BulkLoadDownloadTaskFileSetActor, 2, Void >;
															#line 329 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	BulkLoadDownloadTaskFileSetActor(BulkLoadTransportMethod const& transportMethod,BulkLoadFileSet const& fromRemoteFileSet,std::string const& toLocalRoot,UID const& logId) 
															#line 4124 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		 : Actor<BulkLoadFileSet>(),
		   BulkLoadDownloadTaskFileSetActorState<BulkLoadDownloadTaskFileSetActor>(transportMethod, fromRemoteFileSet, toLocalRoot, logId),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("bulkLoadDownloadTaskFileSet", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12376239698328371968UL, 12469107969741322240UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadDownloadTaskFileSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("bulkLoadDownloadTaskFileSet");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("bulkLoadDownloadTaskFileSet", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< BulkLoadDownloadTaskFileSetActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< BulkLoadDownloadTaskFileSetActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< BulkLoadDownloadTaskFileSetActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 329 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
[[nodiscard]] Future<BulkLoadFileSet> bulkLoadDownloadTaskFileSet( BulkLoadTransportMethod const& transportMethod, BulkLoadFileSet const& fromRemoteFileSet, std::string const& toLocalRoot, UID const& logId ) {
															#line 329 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	return Future<BulkLoadFileSet>(new BulkLoadDownloadTaskFileSetActor(transportMethod, fromRemoteFileSet, toLocalRoot, logId));
															#line 4159 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
}

#line 409 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"

															#line 4164 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via bulkLoadDownloadTaskFileSets()
															#line 410 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
template <class BulkLoadDownloadTaskFileSetsActor>
															#line 410 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
class BulkLoadDownloadTaskFileSetsActorState {
															#line 4171 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
public:
															#line 410 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	BulkLoadDownloadTaskFileSetsActorState(BulkLoadTransportMethod const& transportMethod,std::shared_ptr<BulkLoadFileSetKeyMap> const& fromRemoteFileSets,std::shared_ptr<BulkLoadFileSetKeyMap> const& localFileSets,std::string const& toLocalRoot,UID const& logId) 
															#line 410 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
															#line 410 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		 : transportMethod(transportMethod),
															#line 410 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		   fromRemoteFileSets(fromRemoteFileSets),
															#line 410 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		   localFileSets(localFileSets),
															#line 410 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		   toLocalRoot(toLocalRoot),
															#line 410 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		   logId(logId),
															#line 415 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		   iter(fromRemoteFileSets->begin()),
															#line 416 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		   keys()
															#line 4190 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("bulkLoadDownloadTaskFileSets", reinterpret_cast<unsigned long>(this));

	}
	~BulkLoadDownloadTaskFileSetsActorState() 
	{
		fdb_probe_actor_destroy("bulkLoadDownloadTaskFileSets", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 417 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			;
															#line 4205 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~BulkLoadDownloadTaskFileSetsActorState();
		static_cast<BulkLoadDownloadTaskFileSetsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 439 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (!static_cast<BulkLoadDownloadTaskFileSetsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~BulkLoadDownloadTaskFileSetsActorState(); static_cast<BulkLoadDownloadTaskFileSetsActor*>(this)->destroy(); return 0; }
															#line 4228 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		new (&static_cast<BulkLoadDownloadTaskFileSetsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~BulkLoadDownloadTaskFileSetsActorState();
		static_cast<BulkLoadDownloadTaskFileSetsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 417 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (!(iter != fromRemoteFileSets->end()))
															#line 4247 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 418 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		keys = iter->first;
															#line 419 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (!iter->second.hasDataFile())
															#line 4255 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		{
															#line 422 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			TraceEvent("BulkLoadDownloadSkipEmptyRange", logId) .detail("Keys", keys) .detail("Reason", "No data file for empty range");
															#line 426 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			BulkLoadFileSet emptyLocalFileSet(toLocalRoot, iter->second.getRelativePath(), iter->second.getManifestFileName(), "", "", BulkLoadChecksum());
															#line 432 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			localFileSets->push_back(std::make_pair(keys, emptyLocalFileSet));
															#line 4263 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
			return a_body1continue1(loopDepth); // continue
		}
															#line 435 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		StrictFuture<BulkLoadFileSet> __when_expr_0 = bulkLoadDownloadTaskFileSet(transportMethod, iter->second, toLocalRoot, logId);
															#line 435 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (static_cast<BulkLoadDownloadTaskFileSetsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4270 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<BulkLoadDownloadTaskFileSetsActor*>(this)->actor_wait_state = 1;
															#line 435 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< BulkLoadDownloadTaskFileSetsActor, 0, BulkLoadFileSet >*>(static_cast<BulkLoadDownloadTaskFileSetsActor*>(this)));
															#line 4275 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1continue1(int loopDepth) 
	{
															#line 417 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		iter++;
															#line 4297 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(BulkLoadFileSet const& localFileSet,int loopDepth) 
	{
															#line 437 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		localFileSets->push_back(std::make_pair(keys, localFileSet));
															#line 417 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		iter++;
															#line 4308 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(BulkLoadFileSet && localFileSet,int loopDepth) 
	{
															#line 437 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		localFileSets->push_back(std::make_pair(keys, localFileSet));
															#line 417 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		iter++;
															#line 4319 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(BulkLoadFileSet const& localFileSet,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(localFileSet, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(BulkLoadFileSet && localFileSet,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(localFileSet), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<BulkLoadDownloadTaskFileSetsActor*>(this)->actor_wait_state > 0) static_cast<BulkLoadDownloadTaskFileSetsActor*>(this)->actor_wait_state = 0;
		static_cast<BulkLoadDownloadTaskFileSetsActor*>(this)->ActorCallback< BulkLoadDownloadTaskFileSetsActor, 0, BulkLoadFileSet >::remove();

	}
	void a_callback_fire(ActorCallback< BulkLoadDownloadTaskFileSetsActor, 0, BulkLoadFileSet >*,BulkLoadFileSet const& value) 
	{
		fdb_probe_actor_enter("bulkLoadDownloadTaskFileSets", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadDownloadTaskFileSetsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadDownloadTaskFileSets", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< BulkLoadDownloadTaskFileSetsActor, 0, BulkLoadFileSet >*,BulkLoadFileSet && value) 
	{
		fdb_probe_actor_enter("bulkLoadDownloadTaskFileSets", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadDownloadTaskFileSetsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadDownloadTaskFileSets", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< BulkLoadDownloadTaskFileSetsActor, 0, BulkLoadFileSet >*,Error err) 
	{
		fdb_probe_actor_enter("bulkLoadDownloadTaskFileSets", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadDownloadTaskFileSetsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadDownloadTaskFileSets", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 410 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	BulkLoadTransportMethod transportMethod;
															#line 410 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	std::shared_ptr<BulkLoadFileSetKeyMap> fromRemoteFileSets;
															#line 410 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	std::shared_ptr<BulkLoadFileSetKeyMap> localFileSets;
															#line 410 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	std::string toLocalRoot;
															#line 410 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	UID logId;
															#line 415 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	BulkLoadFileSetKeyMap::iterator iter;
															#line 416 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	KeyRange keys;
															#line 4413 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
};
// This generated class is to be used only via bulkLoadDownloadTaskFileSets()
															#line 410 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
class BulkLoadDownloadTaskFileSetsActor final : public Actor<Void>, public ActorCallback< BulkLoadDownloadTaskFileSetsActor, 0, BulkLoadFileSet >, public FastAllocated<BulkLoadDownloadTaskFileSetsActor>, public BulkLoadDownloadTaskFileSetsActorState<BulkLoadDownloadTaskFileSetsActor> {
															#line 4418 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
public:
	using FastAllocated<BulkLoadDownloadTaskFileSetsActor>::operator new;
	using FastAllocated<BulkLoadDownloadTaskFileSetsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13382673557049940736UL, 5815934616496394752UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< BulkLoadDownloadTaskFileSetsActor, 0, BulkLoadFileSet >;
															#line 410 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	BulkLoadDownloadTaskFileSetsActor(BulkLoadTransportMethod const& transportMethod,std::shared_ptr<BulkLoadFileSetKeyMap> const& fromRemoteFileSets,std::shared_ptr<BulkLoadFileSetKeyMap> const& localFileSets,std::string const& toLocalRoot,UID const& logId) 
															#line 4435 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   BulkLoadDownloadTaskFileSetsActorState<BulkLoadDownloadTaskFileSetsActor>(transportMethod, fromRemoteFileSets, localFileSets, toLocalRoot, logId),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("bulkLoadDownloadTaskFileSets", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10639990215071692288UL, 10496662531958648576UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadDownloadTaskFileSetsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("bulkLoadDownloadTaskFileSets");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("bulkLoadDownloadTaskFileSets", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< BulkLoadDownloadTaskFileSetsActor, 0, BulkLoadFileSet >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 410 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
[[nodiscard]] Future<Void> bulkLoadDownloadTaskFileSets( BulkLoadTransportMethod const& transportMethod, std::shared_ptr<BulkLoadFileSetKeyMap> const& fromRemoteFileSets, std::shared_ptr<BulkLoadFileSetKeyMap> const& localFileSets, std::string const& toLocalRoot, UID const& logId ) {
															#line 410 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	return Future<Void>(new BulkLoadDownloadTaskFileSetsActor(transportMethod, fromRemoteFileSets, localFileSets, toLocalRoot, logId));
															#line 4468 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
}

#line 441 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"

															#line 4473 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via downloadManifestFile()
															#line 442 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
template <class DownloadManifestFileActor>
															#line 442 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
class DownloadManifestFileActorState {
															#line 4480 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
public:
															#line 442 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	DownloadManifestFileActorState(BulkLoadTransportMethod const& transportMethod,std::string const& fromRemotePath,std::string const& toLocalPath,UID const& logId) 
															#line 442 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
															#line 442 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		 : transportMethod(transportMethod),
															#line 442 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		   fromRemotePath(fromRemotePath),
															#line 442 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		   toLocalPath(toLocalPath),
															#line 442 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		   logId(logId),
															#line 446 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		   retryCount(0),
															#line 447 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		   startTime(now())
															#line 4497 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("downloadManifestFile", reinterpret_cast<unsigned long>(this));

	}
	~DownloadManifestFileActorState() 
	{
		fdb_probe_actor_destroy("downloadManifestFile", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 448 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			TraceEvent(SevDebug, "BulkLoadDownloadManifestStart", logId) .detail("FromRemotePath", fromRemotePath) .detail("ToLocalPath", toLocalPath) .detail("TransportMethod", transportMethod);
															#line 452 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			;
															#line 4514 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DownloadManifestFileActorState();
		static_cast<DownloadManifestFileActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 494 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (!static_cast<DownloadManifestFileActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DownloadManifestFileActorState(); static_cast<DownloadManifestFileActor*>(this)->destroy(); return 0; }
															#line 4537 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		new (&static_cast<DownloadManifestFileActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DownloadManifestFileActorState();
		static_cast<DownloadManifestFileActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 454 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			TraceEvent(SevDebug, "BulkLoadDownloadManifestAttempt", logId) .detail("RetryCount", retryCount) .detail("Elapsed", now() - startTime);
															#line 457 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			if (transportMethod == BulkLoadTransportMethod::CP)
															#line 4559 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
			{
															#line 458 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
				StrictFuture<Void> __when_expr_0 = copyBulkFile(abspath(fromRemotePath), abspath(toLocalPath), SERVER_KNOBS->BULKLOAD_FILE_BYTES_MAX);
															#line 458 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
				if (static_cast<DownloadManifestFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4565 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
				static_cast<DownloadManifestFileActor*>(this)->actor_wait_state = 1;
															#line 458 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DownloadManifestFileActor, 0, Void >*>(static_cast<DownloadManifestFileActor*>(this)));
															#line 4570 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
															#line 461 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
				if (transportMethod == BulkLoadTransportMethod::BLOBSTORE)
															#line 4577 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
				{
															#line 463 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
					StrictFuture<Void> __when_expr_2 = copyDownFile(fromRemotePath, abspath(toLocalPath));
															#line 463 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
					if (static_cast<DownloadManifestFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4583 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
					if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1when2(__when_expr_2.get(), loopDepth); };
					static_cast<DownloadManifestFileActor*>(this)->actor_wait_state = 3;
															#line 463 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
					__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< DownloadManifestFileActor, 2, Void >*>(static_cast<DownloadManifestFileActor*>(this)));
															#line 4588 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
					loopDepth = 0;
				}
				else
				{
															#line 465 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
					UNREACHABLE();
															#line 4595 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
					loopDepth = a_body1loopBody1cont5(loopDepth);
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 477 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 4632 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
			{
															#line 478 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 4636 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
			}
															#line 480 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			TraceEvent(SevWarnAlways, "BulkLoadDownloadManifestFileError", logId) .errorUnsuppressed(e) .detail("TransportMethod", transportMethod) .detail("FromRemotePath", fromRemotePath) .detail("ToLocalPath", toLocalPath) .detail("RetryCount", retryCount) .detail("Duration", now() - startTime);
															#line 487 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			retryCount++;
															#line 488 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			if (retryCount > 10)
															#line 4644 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
			{
															#line 489 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 4648 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
			}
															#line 491 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			StrictFuture<Void> __when_expr_3 = delay(SERVER_KNOBS->BULKLOAD_DOWNLOAD_RETRY_DELAY);
															#line 491 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			if (static_cast<DownloadManifestFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4654 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<DownloadManifestFileActor*>(this)->actor_wait_state = 4;
															#line 491 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< DownloadManifestFileActor, 3, Void >*>(static_cast<DownloadManifestFileActor*>(this)));
															#line 4659 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 467 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (!fileExists(abspath(toLocalPath)))
															#line 4674 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		{
															#line 468 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			return a_body1loopBody1Catch1(retry(), loopDepth);
															#line 4678 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		}
															#line 470 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		TraceEvent(bulkLoadVerboseEventSev(), "BulkLoadDownloadManifestFile", logId) .detail("FromRemotePath", fromRemotePath) .detail("ToLocalPath", toLocalPath) .detail("Duration", now() - startTime) .detail("RetryCount", retryCount);
															#line 4682 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 460 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(0.1);
															#line 460 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (static_cast<DownloadManifestFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4693 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_1.get(), loopDepth); };
		static_cast<DownloadManifestFileActor*>(this)->actor_wait_state = 2;
															#line 460 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DownloadManifestFileActor, 1, Void >*>(static_cast<DownloadManifestFileActor*>(this)));
															#line 4698 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 460 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(0.1);
															#line 460 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (static_cast<DownloadManifestFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4709 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_1.get(), loopDepth); };
		static_cast<DownloadManifestFileActor*>(this)->actor_wait_state = 2;
															#line 460 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DownloadManifestFileActor, 1, Void >*>(static_cast<DownloadManifestFileActor*>(this)));
															#line 4714 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DownloadManifestFileActor*>(this)->actor_wait_state > 0) static_cast<DownloadManifestFileActor*>(this)->actor_wait_state = 0;
		static_cast<DownloadManifestFileActor*>(this)->ActorCallback< DownloadManifestFileActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DownloadManifestFileActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("downloadManifestFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DownloadManifestFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("downloadManifestFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DownloadManifestFileActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("downloadManifestFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DownloadManifestFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("downloadManifestFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DownloadManifestFileActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("downloadManifestFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DownloadManifestFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("downloadManifestFile", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DownloadManifestFileActor*>(this)->actor_wait_state > 0) static_cast<DownloadManifestFileActor*>(this)->actor_wait_state = 0;
		static_cast<DownloadManifestFileActor*>(this)->ActorCallback< DownloadManifestFileActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DownloadManifestFileActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("downloadManifestFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DownloadManifestFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("downloadManifestFile", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DownloadManifestFileActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("downloadManifestFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DownloadManifestFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("downloadManifestFile", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DownloadManifestFileActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("downloadManifestFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DownloadManifestFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("downloadManifestFile", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont5(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<DownloadManifestFileActor*>(this)->actor_wait_state > 0) static_cast<DownloadManifestFileActor*>(this)->actor_wait_state = 0;
		static_cast<DownloadManifestFileActor*>(this)->ActorCallback< DownloadManifestFileActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DownloadManifestFileActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("downloadManifestFile", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DownloadManifestFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("downloadManifestFile", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< DownloadManifestFileActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("downloadManifestFile", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DownloadManifestFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("downloadManifestFile", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< DownloadManifestFileActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("downloadManifestFile", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DownloadManifestFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("downloadManifestFile", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<DownloadManifestFileActor*>(this)->actor_wait_state > 0) static_cast<DownloadManifestFileActor*>(this)->actor_wait_state = 0;
		static_cast<DownloadManifestFileActor*>(this)->ActorCallback< DownloadManifestFileActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DownloadManifestFileActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("downloadManifestFile", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DownloadManifestFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("downloadManifestFile", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< DownloadManifestFileActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("downloadManifestFile", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DownloadManifestFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("downloadManifestFile", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< DownloadManifestFileActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("downloadManifestFile", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DownloadManifestFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("downloadManifestFile", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 442 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	BulkLoadTransportMethod transportMethod;
															#line 442 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	std::string fromRemotePath;
															#line 442 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	std::string toLocalPath;
															#line 442 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	UID logId;
															#line 446 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	int retryCount;
															#line 447 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	double startTime;
															#line 5073 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
};
// This generated class is to be used only via downloadManifestFile()
															#line 442 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
class DownloadManifestFileActor final : public Actor<Void>, public ActorCallback< DownloadManifestFileActor, 0, Void >, public ActorCallback< DownloadManifestFileActor, 1, Void >, public ActorCallback< DownloadManifestFileActor, 2, Void >, public ActorCallback< DownloadManifestFileActor, 3, Void >, public FastAllocated<DownloadManifestFileActor>, public DownloadManifestFileActorState<DownloadManifestFileActor> {
															#line 5078 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
public:
	using FastAllocated<DownloadManifestFileActor>::operator new;
	using FastAllocated<DownloadManifestFileActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1650823911690944512UL, 16794549966000592640UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DownloadManifestFileActor, 0, Void >;
friend struct ActorCallback< DownloadManifestFileActor, 1, Void >;
friend struct ActorCallback< DownloadManifestFileActor, 2, Void >;
friend struct ActorCallback< DownloadManifestFileActor, 3, Void >;
															#line 442 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	DownloadManifestFileActor(BulkLoadTransportMethod const& transportMethod,std::string const& fromRemotePath,std::string const& toLocalPath,UID const& logId) 
															#line 5098 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   DownloadManifestFileActorState<DownloadManifestFileActor>(transportMethod, fromRemotePath, toLocalPath, logId),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("downloadManifestFile", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16667635394163167232UL, 11775713213349071360UL);
		ActorExecutionContextHelper __helper(static_cast<DownloadManifestFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("downloadManifestFile");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("downloadManifestFile", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DownloadManifestFileActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DownloadManifestFileActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< DownloadManifestFileActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< DownloadManifestFileActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 442 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
[[nodiscard]] Future<Void> downloadManifestFile( BulkLoadTransportMethod const& transportMethod, std::string const& fromRemotePath, std::string const& toLocalPath, UID const& logId ) {
															#line 442 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	return Future<Void>(new DownloadManifestFileActor(transportMethod, fromRemotePath, toLocalPath, logId));
															#line 5134 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
}

#line 496 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"

// Download job manifest file
// Each job has one manifest file including manifest paths of all tasks
															#line 5141 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via downloadBulkLoadJobManifestFile()
															#line 499 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
template <class DownloadBulkLoadJobManifestFileActor>
															#line 499 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
class DownloadBulkLoadJobManifestFileActorState {
															#line 5148 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
public:
															#line 499 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	DownloadBulkLoadJobManifestFileActorState(BulkLoadTransportMethod const& transportMethod,std::string const& localJobManifestFilePath,std::string const& remoteJobManifestFilePath,UID const& logId) 
															#line 499 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
															#line 499 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		 : transportMethod(transportMethod),
															#line 499 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		   localJobManifestFilePath(localJobManifestFilePath),
															#line 499 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		   remoteJobManifestFilePath(remoteJobManifestFilePath),
															#line 499 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		   logId(logId)
															#line 5161 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("downloadBulkLoadJobManifestFile", reinterpret_cast<unsigned long>(this));

	}
	~DownloadBulkLoadJobManifestFileActorState() 
	{
		fdb_probe_actor_destroy("downloadBulkLoadJobManifestFile", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 503 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			StrictFuture<Void> __when_expr_0 = downloadManifestFile(transportMethod, remoteJobManifestFilePath, localJobManifestFilePath, logId);
															#line 503 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			if (static_cast<DownloadBulkLoadJobManifestFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5178 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DownloadBulkLoadJobManifestFileActor*>(this)->actor_wait_state = 1;
															#line 503 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DownloadBulkLoadJobManifestFileActor, 0, Void >*>(static_cast<DownloadBulkLoadJobManifestFileActor*>(this)));
															#line 5183 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DownloadBulkLoadJobManifestFileActorState();
		static_cast<DownloadBulkLoadJobManifestFileActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 504 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (!static_cast<DownloadBulkLoadJobManifestFileActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DownloadBulkLoadJobManifestFileActorState(); static_cast<DownloadBulkLoadJobManifestFileActor*>(this)->destroy(); return 0; }
															#line 5206 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		new (&static_cast<DownloadBulkLoadJobManifestFileActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DownloadBulkLoadJobManifestFileActorState();
		static_cast<DownloadBulkLoadJobManifestFileActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 504 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (!static_cast<DownloadBulkLoadJobManifestFileActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DownloadBulkLoadJobManifestFileActorState(); static_cast<DownloadBulkLoadJobManifestFileActor*>(this)->destroy(); return 0; }
															#line 5218 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		new (&static_cast<DownloadBulkLoadJobManifestFileActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DownloadBulkLoadJobManifestFileActorState();
		static_cast<DownloadBulkLoadJobManifestFileActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DownloadBulkLoadJobManifestFileActor*>(this)->actor_wait_state > 0) static_cast<DownloadBulkLoadJobManifestFileActor*>(this)->actor_wait_state = 0;
		static_cast<DownloadBulkLoadJobManifestFileActor*>(this)->ActorCallback< DownloadBulkLoadJobManifestFileActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DownloadBulkLoadJobManifestFileActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("downloadBulkLoadJobManifestFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DownloadBulkLoadJobManifestFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("downloadBulkLoadJobManifestFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DownloadBulkLoadJobManifestFileActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("downloadBulkLoadJobManifestFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DownloadBulkLoadJobManifestFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("downloadBulkLoadJobManifestFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DownloadBulkLoadJobManifestFileActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("downloadBulkLoadJobManifestFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DownloadBulkLoadJobManifestFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("downloadBulkLoadJobManifestFile", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 499 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	BulkLoadTransportMethod transportMethod;
															#line 499 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	std::string localJobManifestFilePath;
															#line 499 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	std::string remoteJobManifestFilePath;
															#line 499 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	UID logId;
															#line 5309 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
};
// This generated class is to be used only via downloadBulkLoadJobManifestFile()
															#line 499 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
class DownloadBulkLoadJobManifestFileActor final : public Actor<Void>, public ActorCallback< DownloadBulkLoadJobManifestFileActor, 0, Void >, public FastAllocated<DownloadBulkLoadJobManifestFileActor>, public DownloadBulkLoadJobManifestFileActorState<DownloadBulkLoadJobManifestFileActor> {
															#line 5314 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
public:
	using FastAllocated<DownloadBulkLoadJobManifestFileActor>::operator new;
	using FastAllocated<DownloadBulkLoadJobManifestFileActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9466249748275912960UL, 12942549621892379136UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DownloadBulkLoadJobManifestFileActor, 0, Void >;
															#line 499 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	DownloadBulkLoadJobManifestFileActor(BulkLoadTransportMethod const& transportMethod,std::string const& localJobManifestFilePath,std::string const& remoteJobManifestFilePath,UID const& logId) 
															#line 5331 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   DownloadBulkLoadJobManifestFileActorState<DownloadBulkLoadJobManifestFileActor>(transportMethod, localJobManifestFilePath, remoteJobManifestFilePath, logId),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("downloadBulkLoadJobManifestFile", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12086591436448585472UL, 14493210584460522496UL);
		ActorExecutionContextHelper __helper(static_cast<DownloadBulkLoadJobManifestFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("downloadBulkLoadJobManifestFile");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("downloadBulkLoadJobManifestFile", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DownloadBulkLoadJobManifestFileActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 499 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
[[nodiscard]] Future<Void> downloadBulkLoadJobManifestFile( BulkLoadTransportMethod const& transportMethod, std::string const& localJobManifestFilePath, std::string const& remoteJobManifestFilePath, UID const& logId ) {
															#line 499 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	return Future<Void>(new DownloadBulkLoadJobManifestFileActor(transportMethod, localJobManifestFilePath, remoteJobManifestFilePath, logId));
															#line 5364 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
}

#line 506 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"

// Update manifestEntryMap and expanding mapRange if the input line overlaps with the job range.
KeyRange updateManifestEntryMap(const std::string& line,
                                const KeyRange& jobRange,
                                const KeyRange& mapRange,
                                std::shared_ptr<BulkLoadManifestFileMap> manifestEntryMap) {
	BulkLoadJobFileManifestEntry manifestEntry(line);
	KeyRange overlappingRange = jobRange & manifestEntry.getRange();
	if (!overlappingRange.empty()) {
		auto returnV = manifestEntryMap->insert({ overlappingRange.begin, manifestEntry });
		ASSERT(returnV.second);
		if (mapRange.empty()) {
			return KeyRangeRef(overlappingRange.begin, overlappingRange.end);
		} else {
			if (mapRange.begin > overlappingRange.begin) {
				return KeyRangeRef(overlappingRange.begin, mapRange.end);
			}
			if (mapRange.end < overlappingRange.end) {
				return KeyRangeRef(mapRange.begin, overlappingRange.end);
			}
		}
	}
	return mapRange;
}

// Get manifest within the input range.
// manifestEntryMap is the output.
// Return value is the range of the manifestEntryMap.
															#line 5396 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via getBulkLoadJobFileManifestEntryFromJobManifestFile()
															#line 534 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
template <class GetBulkLoadJobFileManifestEntryFromJobManifestFileActor>
															#line 534 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
class GetBulkLoadJobFileManifestEntryFromJobManifestFileActorState {
															#line 5403 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
public:
															#line 534 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	GetBulkLoadJobFileManifestEntryFromJobManifestFileActorState(std::string const& localJobManifestFilePath,KeyRange const& range,UID const& logId,std::shared_ptr<BulkLoadManifestFileMap> const& manifestEntryMap) 
															#line 534 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
															#line 534 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		 : localJobManifestFilePath(localJobManifestFilePath),
															#line 534 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		   range(range),
															#line 534 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		   logId(logId),
															#line 534 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		   manifestEntryMap(manifestEntryMap),
															#line 539 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		   mapRange(),
															#line 540 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		   startTime(now())
															#line 5420 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getBulkLoadJobFileManifestEntryFromJobManifestFile", reinterpret_cast<unsigned long>(this));

	}
	~GetBulkLoadJobFileManifestEntryFromJobManifestFileActorState() 
	{
		fdb_probe_actor_destroy("getBulkLoadJobFileManifestEntryFromJobManifestFile", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 541 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			ASSERT(fileExists(abspath(localJobManifestFilePath)));
															#line 542 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			ASSERT(manifestEntryMap->empty());
															#line 544 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			StrictFuture<Reference<IAsyncFile>> __when_expr_0 = IAsyncFileSystem::filesystem()->open( abspath(localJobManifestFilePath), IAsyncFile::OPEN_NO_AIO | IAsyncFile::OPEN_READONLY | IAsyncFile::OPEN_UNCACHED, 0644);
															#line 544 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			if (static_cast<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5441 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor*>(this)->actor_wait_state = 1;
															#line 544 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetBulkLoadJobFileManifestEntryFromJobManifestFileActor, 0, Reference<IAsyncFile> >*>(static_cast<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor*>(this)));
															#line 5446 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetBulkLoadJobFileManifestEntryFromJobManifestFileActorState();
		static_cast<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 549 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		StrictFuture<int64_t> __when_expr_1 = file->size();
															#line 549 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (static_cast<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5471 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor*>(this)->actor_wait_state = 2;
															#line 549 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetBulkLoadJobFileManifestEntryFromJobManifestFileActor, 1, int64_t >*>(static_cast<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor*>(this)));
															#line 5476 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Reference<IAsyncFile> const& __file,int loopDepth) 
	{
															#line 544 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		file = __file;
															#line 5485 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Reference<IAsyncFile> && __file,int loopDepth) 
	{
		file = std::move(__file);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor*>(this)->actor_wait_state > 0) static_cast<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor*>(this)->actor_wait_state = 0;
		static_cast<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor*>(this)->ActorCallback< GetBulkLoadJobFileManifestEntryFromJobManifestFileActor, 0, Reference<IAsyncFile> >::remove();

	}
	void a_callback_fire(ActorCallback< GetBulkLoadJobFileManifestEntryFromJobManifestFileActor, 0, Reference<IAsyncFile> >*,Reference<IAsyncFile> const& value) 
	{
		fdb_probe_actor_enter("getBulkLoadJobFileManifestEntryFromJobManifestFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBulkLoadJobFileManifestEntryFromJobManifestFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetBulkLoadJobFileManifestEntryFromJobManifestFileActor, 0, Reference<IAsyncFile> >*,Reference<IAsyncFile> && value) 
	{
		fdb_probe_actor_enter("getBulkLoadJobFileManifestEntryFromJobManifestFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBulkLoadJobFileManifestEntryFromJobManifestFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetBulkLoadJobFileManifestEntryFromJobManifestFileActor, 0, Reference<IAsyncFile> >*,Error err) 
	{
		fdb_probe_actor_enter("getBulkLoadJobFileManifestEntryFromJobManifestFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBulkLoadJobFileManifestEntryFromJobManifestFile", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 550 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (fileSize > SERVER_KNOBS->BULKLOAD_FILE_BYTES_MAX)
															#line 5564 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		{
															#line 551 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			TraceEvent(SevError, "ManifestFileTooBig", logId) .detail("FileSize", fileSize) .detail("MaxSize", SERVER_KNOBS->BULKLOAD_FILE_BYTES_MAX);
															#line 554 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			return a_body1Catch1(file_too_large(), loopDepth);
															#line 5570 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		}
															#line 557 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		chunkSize = 64 * 1024;
															#line 558 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		buffer = std::string();
															#line 559 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		offset = 0;
															#line 560 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		leftover = std::string();
															#line 561 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		headerProcessed = false;
															#line 5582 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		try {
															#line 564 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			;
															#line 5586 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
			loopDepth = a_body1cont2loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont2Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1when1(int64_t const& __fileSize,int loopDepth) 
	{
															#line 549 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		fileSize = __fileSize;
															#line 5601 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(int64_t && __fileSize,int loopDepth) 
	{
		fileSize = std::move(__fileSize);
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor*>(this)->actor_wait_state > 0) static_cast<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor*>(this)->actor_wait_state = 0;
		static_cast<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor*>(this)->ActorCallback< GetBulkLoadJobFileManifestEntryFromJobManifestFileActor, 1, int64_t >::remove();

	}
	void a_callback_fire(ActorCallback< GetBulkLoadJobFileManifestEntryFromJobManifestFileActor, 1, int64_t >*,int64_t const& value) 
	{
		fdb_probe_actor_enter("getBulkLoadJobFileManifestEntryFromJobManifestFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBulkLoadJobFileManifestEntryFromJobManifestFile", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetBulkLoadJobFileManifestEntryFromJobManifestFileActor, 1, int64_t >*,int64_t && value) 
	{
		fdb_probe_actor_enter("getBulkLoadJobFileManifestEntryFromJobManifestFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBulkLoadJobFileManifestEntryFromJobManifestFile", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetBulkLoadJobFileManifestEntryFromJobManifestFileActor, 1, int64_t >*,Error err) 
	{
		fdb_probe_actor_enter("getBulkLoadJobFileManifestEntryFromJobManifestFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBulkLoadJobFileManifestEntryFromJobManifestFile", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 624 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (!static_cast<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor*>(this)->SAV<KeyRange>::futures) { (void)(mapRange); this->~GetBulkLoadJobFileManifestEntryFromJobManifestFileActorState(); static_cast<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor*>(this)->destroy(); return 0; }
															#line 5680 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		new (&static_cast<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor*>(this)->SAV< KeyRange >::value()) KeyRange(std::move(mapRange)); // state_var_RVO
		this->~GetBulkLoadJobFileManifestEntryFromJobManifestFileActorState();
		static_cast<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 616 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			TraceEvent(SevWarnAlways, "BulkLoadJobFileManifestEntryError", logId) .errorUnsuppressed(e) .detail("LocalJobManifestFilePath", localJobManifestFilePath) .detail("Duration", now() - startTime) .detail("Offset", offset);
															#line 621 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 5695 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont5(int loopDepth) 
	{
															#line 607 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (!leftover.empty())
															#line 5709 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		{
															#line 608 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			if (!headerProcessed)
															#line 5713 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
			{
															#line 610 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
				BulkLoadJobManifestFileHeader header(leftover);
															#line 5717 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
			}
			else
			{
															#line 612 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
				mapRange = updateManifestEntryMap(leftover, range, mapRange, manifestEntryMap);
															#line 5723 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
			}
		}
		loopDepth = a_body1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1(int loopDepth) 
	{
															#line 564 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (!(offset < fileSize))
															#line 5741 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		{
			return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 565 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		bytesToRead = std::min(chunkSize, fileSize - offset);
															#line 566 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		buffer.resize(bytesToRead);
															#line 568 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		StrictFuture<int> __when_expr_2 = file->read(&buffer[0], bytesToRead, offset);
															#line 568 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (static_cast<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5753 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont2Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when1(__when_expr_2.get(), loopDepth); };
		static_cast<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor*>(this)->actor_wait_state = 3;
															#line 568 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetBulkLoadJobFileManifestEntryFromJobManifestFileActor, 2, int >*>(static_cast<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor*>(this)));
															#line 5758 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2break1(int loopDepth) 
	{
		try {
			return a_body1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont2Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(int loopDepth) 
	{
															#line 569 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (bytesRead != bytesToRead)
															#line 5780 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		{
															#line 570 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			TraceEvent(SevError, "ReadFileError", logId) .detail("BytesRead", bytesRead) .detail("BytesExpected", bytesToRead);
															#line 573 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			return a_body1cont2Catch1(io_error(), std::max(0, loopDepth - 1));
															#line 5786 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		}
															#line 577 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		chunk = leftover + buffer;
															#line 578 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		pos = 0;
															#line 579 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		lineStart = 0;
															#line 581 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		;
															#line 5796 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2loopBody1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(int const& __bytesRead,int loopDepth) 
	{
															#line 568 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		bytesRead = __bytesRead;
															#line 5805 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(int && __bytesRead,int loopDepth) 
	{
		bytesRead = std::move(__bytesRead);
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor*>(this)->actor_wait_state > 0) static_cast<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor*>(this)->actor_wait_state = 0;
		static_cast<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor*>(this)->ActorCallback< GetBulkLoadJobFileManifestEntryFromJobManifestFileActor, 2, int >::remove();

	}
	void a_callback_fire(ActorCallback< GetBulkLoadJobFileManifestEntryFromJobManifestFileActor, 2, int >*,int const& value) 
	{
		fdb_probe_actor_enter("getBulkLoadJobFileManifestEntryFromJobManifestFile", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBulkLoadJobFileManifestEntryFromJobManifestFile", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetBulkLoadJobFileManifestEntryFromJobManifestFileActor, 2, int >*,int && value) 
	{
		fdb_probe_actor_enter("getBulkLoadJobFileManifestEntryFromJobManifestFile", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBulkLoadJobFileManifestEntryFromJobManifestFile", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetBulkLoadJobFileManifestEntryFromJobManifestFileActor, 2, int >*,Error err) 
	{
		fdb_probe_actor_enter("getBulkLoadJobFileManifestEntryFromJobManifestFile", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBulkLoadJobFileManifestEntryFromJobManifestFile", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont2loopBody1cont3(int loopDepth) 
	{
															#line 601 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		leftover = chunk.substr(lineStart);
															#line 602 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		offset += bytesRead;
															#line 603 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		StrictFuture<Void> __when_expr_4 = yield();
															#line 603 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (static_cast<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5890 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont2Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1cont3when1(__when_expr_4.get(), loopDepth); };
		static_cast<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor*>(this)->actor_wait_state = 5;
															#line 603 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< GetBulkLoadJobFileManifestEntryFromJobManifestFileActor, 4, Void >*>(static_cast<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor*>(this)));
															#line 5895 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1loopBody1(int loopDepth) 
	{
															#line 581 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (!((pos = chunk.find(bulkLoadJobManifestLineTerminator, lineStart)) != std::string::npos))
															#line 5911 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		{
			return a_body1cont2loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 582 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		line = chunk.substr(lineStart, pos - lineStart);
															#line 583 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (!line.empty())
															#line 5919 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		{
															#line 584 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			if (!headerProcessed)
															#line 5923 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
			{
															#line 586 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
				BulkLoadJobManifestFileHeader header(line);
															#line 587 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
				headerProcessed = true;
															#line 5929 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
			}
			else
			{
															#line 589 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
				mapRange = updateManifestEntryMap(line, range, mapRange, manifestEntryMap);
															#line 5935 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
			}
		}
															#line 592 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		lineStart = pos + 1;
															#line 595 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (manifestEntryMap->size() % 100 == 0)
															#line 5942 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		{
															#line 596 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			StrictFuture<Void> __when_expr_3 = yield();
															#line 596 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			if (static_cast<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 5948 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont2Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 2)); else return a_body1cont2loopBody1cont1loopBody1when1(__when_expr_3.get(), loopDepth); };
			static_cast<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor*>(this)->actor_wait_state = 4;
															#line 596 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< GetBulkLoadJobFileManifestEntryFromJobManifestFileActor, 3, Void >*>(static_cast<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor*>(this)));
															#line 5953 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2loopBody1cont1loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont2loopBody1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont2Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1cont2Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont2loopBody1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1loopBody1cont6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1loopBody1cont6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor*>(this)->actor_wait_state > 0) static_cast<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor*>(this)->actor_wait_state = 0;
		static_cast<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor*>(this)->ActorCallback< GetBulkLoadJobFileManifestEntryFromJobManifestFileActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetBulkLoadJobFileManifestEntryFromJobManifestFileActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getBulkLoadJobFileManifestEntryFromJobManifestFile", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2loopBody1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBulkLoadJobFileManifestEntryFromJobManifestFile", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< GetBulkLoadJobFileManifestEntryFromJobManifestFileActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getBulkLoadJobFileManifestEntryFromJobManifestFile", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2loopBody1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBulkLoadJobFileManifestEntryFromJobManifestFile", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< GetBulkLoadJobFileManifestEntryFromJobManifestFileActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getBulkLoadJobFileManifestEntryFromJobManifestFile", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBulkLoadJobFileManifestEntryFromJobManifestFile", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont2loopBody1cont5(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont5(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor*>(this)->actor_wait_state > 0) static_cast<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor*>(this)->actor_wait_state = 0;
		static_cast<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor*>(this)->ActorCallback< GetBulkLoadJobFileManifestEntryFromJobManifestFileActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetBulkLoadJobFileManifestEntryFromJobManifestFileActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getBulkLoadJobFileManifestEntryFromJobManifestFile", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont2loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBulkLoadJobFileManifestEntryFromJobManifestFile", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< GetBulkLoadJobFileManifestEntryFromJobManifestFileActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getBulkLoadJobFileManifestEntryFromJobManifestFile", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont2loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBulkLoadJobFileManifestEntryFromJobManifestFile", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< GetBulkLoadJobFileManifestEntryFromJobManifestFileActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getBulkLoadJobFileManifestEntryFromJobManifestFile", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBulkLoadJobFileManifestEntryFromJobManifestFile", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont10(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 534 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	std::string localJobManifestFilePath;
															#line 534 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	KeyRange range;
															#line 534 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	UID logId;
															#line 534 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	std::shared_ptr<BulkLoadManifestFileMap> manifestEntryMap;
															#line 539 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	KeyRange mapRange;
															#line 540 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	double startTime;
															#line 544 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	Reference<IAsyncFile> file;
															#line 549 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	int64_t fileSize;
															#line 557 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	int64_t chunkSize;
															#line 558 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	std::string buffer;
															#line 559 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	int64_t offset;
															#line 560 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	std::string leftover;
															#line 561 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	bool headerProcessed;
															#line 565 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	int64_t bytesToRead;
															#line 568 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	int bytesRead;
															#line 577 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	std::string chunk;
															#line 578 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	size_t pos;
															#line 579 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	size_t lineStart;
															#line 582 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	std::string line;
															#line 6207 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getBulkLoadJobFileManifestEntryFromJobManifestFile()
															#line 534 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
class GetBulkLoadJobFileManifestEntryFromJobManifestFileActor final : public Actor<KeyRange>, public ActorCallback< GetBulkLoadJobFileManifestEntryFromJobManifestFileActor, 0, Reference<IAsyncFile> >, public ActorCallback< GetBulkLoadJobFileManifestEntryFromJobManifestFileActor, 1, int64_t >, public ActorCallback< GetBulkLoadJobFileManifestEntryFromJobManifestFileActor, 2, int >, public ActorCallback< GetBulkLoadJobFileManifestEntryFromJobManifestFileActor, 3, Void >, public ActorCallback< GetBulkLoadJobFileManifestEntryFromJobManifestFileActor, 4, Void >, public FastAllocated<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor>, public GetBulkLoadJobFileManifestEntryFromJobManifestFileActorState<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor> {
															#line 6212 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor>::operator new;
	using FastAllocated<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9994081114258446592UL, 14258008621101730048UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<KeyRange>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetBulkLoadJobFileManifestEntryFromJobManifestFileActor, 0, Reference<IAsyncFile> >;
friend struct ActorCallback< GetBulkLoadJobFileManifestEntryFromJobManifestFileActor, 1, int64_t >;
friend struct ActorCallback< GetBulkLoadJobFileManifestEntryFromJobManifestFileActor, 2, int >;
friend struct ActorCallback< GetBulkLoadJobFileManifestEntryFromJobManifestFileActor, 3, Void >;
friend struct ActorCallback< GetBulkLoadJobFileManifestEntryFromJobManifestFileActor, 4, Void >;
															#line 534 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	GetBulkLoadJobFileManifestEntryFromJobManifestFileActor(std::string const& localJobManifestFilePath,KeyRange const& range,UID const& logId,std::shared_ptr<BulkLoadManifestFileMap> const& manifestEntryMap) 
															#line 6233 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		 : Actor<KeyRange>(),
		   GetBulkLoadJobFileManifestEntryFromJobManifestFileActorState<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor>(localJobManifestFilePath, range, logId, manifestEntryMap),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getBulkLoadJobFileManifestEntryFromJobManifestFile", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1022494047704527360UL, 5796357985251372288UL);
		ActorExecutionContextHelper __helper(static_cast<GetBulkLoadJobFileManifestEntryFromJobManifestFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getBulkLoadJobFileManifestEntryFromJobManifestFile");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getBulkLoadJobFileManifestEntryFromJobManifestFile", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetBulkLoadJobFileManifestEntryFromJobManifestFileActor, 0, Reference<IAsyncFile> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetBulkLoadJobFileManifestEntryFromJobManifestFileActor, 1, int64_t >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GetBulkLoadJobFileManifestEntryFromJobManifestFileActor, 2, int >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< GetBulkLoadJobFileManifestEntryFromJobManifestFileActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< GetBulkLoadJobFileManifestEntryFromJobManifestFileActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 534 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
[[nodiscard]] Future<KeyRange> getBulkLoadJobFileManifestEntryFromJobManifestFile( std::string const& localJobManifestFilePath, KeyRange const& range, UID const& logId, std::shared_ptr<BulkLoadManifestFileMap> const& manifestEntryMap ) {
															#line 534 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	return Future<KeyRange>(new GetBulkLoadJobFileManifestEntryFromJobManifestFileActor(localJobManifestFilePath, range, logId, manifestEntryMap));
															#line 6270 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
}

#line 626 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"

															#line 6275 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via getBulkLoadManifestMetadataFromEntry()
															#line 627 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
template <class GetBulkLoadManifestMetadataFromEntryActor>
															#line 627 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
class GetBulkLoadManifestMetadataFromEntryActorState {
															#line 6282 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
public:
															#line 627 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	GetBulkLoadManifestMetadataFromEntryActorState(std::vector<BulkLoadJobFileManifestEntry> const& manifestEntries,std::string const& manifestLocalTempFolder,BulkLoadTransportMethod const& transportMethod,std::string const& jobRoot,UID const& logId) 
															#line 627 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
															#line 627 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		 : manifestEntries(manifestEntries),
															#line 627 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		   manifestLocalTempFolder(manifestLocalTempFolder),
															#line 627 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		   transportMethod(transportMethod),
															#line 627 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		   jobRoot(jobRoot),
															#line 627 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		   logId(logId),
															#line 633 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		   manifests(SERVER_KNOBS->MANIFEST_COUNT_MAX_PER_BULKLOAD_TASK),
															#line 634 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		   i(0)
															#line 6301 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getBulkLoadManifestMetadataFromEntry", reinterpret_cast<unsigned long>(this));

	}
	~GetBulkLoadManifestMetadataFromEntryActorState() 
	{
		fdb_probe_actor_destroy("getBulkLoadManifestMetadataFromEntry", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 635 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
			;
															#line 6316 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetBulkLoadManifestMetadataFromEntryActorState();
		static_cast<GetBulkLoadManifestMetadataFromEntryActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 648 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (!static_cast<GetBulkLoadManifestMetadataFromEntryActor*>(this)->SAV<BulkLoadManifestSet>::futures) { (void)(manifests); this->~GetBulkLoadManifestMetadataFromEntryActorState(); static_cast<GetBulkLoadManifestMetadataFromEntryActor*>(this)->destroy(); return 0; }
															#line 6339 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		new (&static_cast<GetBulkLoadManifestMetadataFromEntryActor*>(this)->SAV< BulkLoadManifestSet >::value()) BulkLoadManifestSet(std::move(manifests)); // state_var_RVO
		this->~GetBulkLoadManifestMetadataFromEntryActorState();
		static_cast<GetBulkLoadManifestMetadataFromEntryActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 635 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (!(i < manifestEntries.size()))
															#line 6358 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 636 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		remoteManifestFilePath = appendToPath(jobRoot, manifestEntries[i].getManifestRelativePath());
															#line 637 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		localManifestFilePath = joinPath(manifestLocalTempFolder, deterministicRandom()->randomUniqueID().toString() + "-" + basename(getPath(remoteManifestFilePath)));
															#line 640 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		StrictFuture<Void> __when_expr_0 = downloadManifestFile(transportMethod, remoteManifestFilePath, localManifestFilePath, logId);
															#line 640 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (static_cast<GetBulkLoadManifestMetadataFromEntryActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6370 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<GetBulkLoadManifestMetadataFromEntryActor*>(this)->actor_wait_state = 1;
															#line 640 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetBulkLoadManifestMetadataFromEntryActor, 0, Void >*>(static_cast<GetBulkLoadManifestMetadataFromEntryActor*>(this)));
															#line 6375 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 641 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		manifestRawString = std::make_shared<std::string>();
															#line 642 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		StrictFuture<Void> __when_expr_1 = readBulkFileBytes( abspath(localManifestFilePath), SERVER_KNOBS->BULKLOAD_FILE_BYTES_MAX, manifestRawString);
															#line 642 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (static_cast<GetBulkLoadManifestMetadataFromEntryActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6401 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<GetBulkLoadManifestMetadataFromEntryActor*>(this)->actor_wait_state = 2;
															#line 642 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetBulkLoadManifestMetadataFromEntryActor, 1, Void >*>(static_cast<GetBulkLoadManifestMetadataFromEntryActor*>(this)));
															#line 6406 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 641 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		manifestRawString = std::make_shared<std::string>();
															#line 642 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		StrictFuture<Void> __when_expr_1 = readBulkFileBytes( abspath(localManifestFilePath), SERVER_KNOBS->BULKLOAD_FILE_BYTES_MAX, manifestRawString);
															#line 642 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		if (static_cast<GetBulkLoadManifestMetadataFromEntryActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6419 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<GetBulkLoadManifestMetadataFromEntryActor*>(this)->actor_wait_state = 2;
															#line 642 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetBulkLoadManifestMetadataFromEntryActor, 1, Void >*>(static_cast<GetBulkLoadManifestMetadataFromEntryActor*>(this)));
															#line 6424 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetBulkLoadManifestMetadataFromEntryActor*>(this)->actor_wait_state > 0) static_cast<GetBulkLoadManifestMetadataFromEntryActor*>(this)->actor_wait_state = 0;
		static_cast<GetBulkLoadManifestMetadataFromEntryActor*>(this)->ActorCallback< GetBulkLoadManifestMetadataFromEntryActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetBulkLoadManifestMetadataFromEntryActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getBulkLoadManifestMetadataFromEntry", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetBulkLoadManifestMetadataFromEntryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBulkLoadManifestMetadataFromEntry", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetBulkLoadManifestMetadataFromEntryActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getBulkLoadManifestMetadataFromEntry", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetBulkLoadManifestMetadataFromEntryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBulkLoadManifestMetadataFromEntry", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetBulkLoadManifestMetadataFromEntryActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getBulkLoadManifestMetadataFromEntry", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetBulkLoadManifestMetadataFromEntryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBulkLoadManifestMetadataFromEntry", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 644 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		ASSERT(!manifestRawString->empty());
															#line 645 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		BulkLoadManifest manifest(*manifestRawString);
															#line 646 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		ASSERT(manifests.addManifest(manifest));
															#line 635 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		i++;
															#line 6514 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 644 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		ASSERT(!manifestRawString->empty());
															#line 645 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		BulkLoadManifest manifest(*manifestRawString);
															#line 646 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		ASSERT(manifests.addManifest(manifest));
															#line 635 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
		i++;
															#line 6529 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetBulkLoadManifestMetadataFromEntryActor*>(this)->actor_wait_state > 0) static_cast<GetBulkLoadManifestMetadataFromEntryActor*>(this)->actor_wait_state = 0;
		static_cast<GetBulkLoadManifestMetadataFromEntryActor*>(this)->ActorCallback< GetBulkLoadManifestMetadataFromEntryActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetBulkLoadManifestMetadataFromEntryActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getBulkLoadManifestMetadataFromEntry", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetBulkLoadManifestMetadataFromEntryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBulkLoadManifestMetadataFromEntry", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetBulkLoadManifestMetadataFromEntryActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getBulkLoadManifestMetadataFromEntry", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetBulkLoadManifestMetadataFromEntryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBulkLoadManifestMetadataFromEntry", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetBulkLoadManifestMetadataFromEntryActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getBulkLoadManifestMetadataFromEntry", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetBulkLoadManifestMetadataFromEntryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBulkLoadManifestMetadataFromEntry", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 627 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	std::vector<BulkLoadJobFileManifestEntry> manifestEntries;
															#line 627 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	std::string manifestLocalTempFolder;
															#line 627 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	BulkLoadTransportMethod transportMethod;
															#line 627 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	std::string jobRoot;
															#line 627 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	UID logId;
															#line 633 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	BulkLoadManifestSet manifests;
															#line 634 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	int i;
															#line 636 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	std::string remoteManifestFilePath;
															#line 637 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	std::string localManifestFilePath;
															#line 641 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	std::shared_ptr<std::string> manifestRawString;
															#line 6629 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getBulkLoadManifestMetadataFromEntry()
															#line 627 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
class GetBulkLoadManifestMetadataFromEntryActor final : public Actor<BulkLoadManifestSet>, public ActorCallback< GetBulkLoadManifestMetadataFromEntryActor, 0, Void >, public ActorCallback< GetBulkLoadManifestMetadataFromEntryActor, 1, Void >, public FastAllocated<GetBulkLoadManifestMetadataFromEntryActor>, public GetBulkLoadManifestMetadataFromEntryActorState<GetBulkLoadManifestMetadataFromEntryActor> {
															#line 6634 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetBulkLoadManifestMetadataFromEntryActor>::operator new;
	using FastAllocated<GetBulkLoadManifestMetadataFromEntryActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6912048976868617216UL, 6951054444629760768UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<BulkLoadManifestSet>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetBulkLoadManifestMetadataFromEntryActor, 0, Void >;
friend struct ActorCallback< GetBulkLoadManifestMetadataFromEntryActor, 1, Void >;
															#line 627 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	GetBulkLoadManifestMetadataFromEntryActor(std::vector<BulkLoadJobFileManifestEntry> const& manifestEntries,std::string const& manifestLocalTempFolder,BulkLoadTransportMethod const& transportMethod,std::string const& jobRoot,UID const& logId) 
															#line 6652 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
		 : Actor<BulkLoadManifestSet>(),
		   GetBulkLoadManifestMetadataFromEntryActorState<GetBulkLoadManifestMetadataFromEntryActor>(manifestEntries, manifestLocalTempFolder, transportMethod, jobRoot, logId),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getBulkLoadManifestMetadataFromEntry", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7741929640425726208UL, 7372106929495094016UL);
		ActorExecutionContextHelper __helper(static_cast<GetBulkLoadManifestMetadataFromEntryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getBulkLoadManifestMetadataFromEntry");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getBulkLoadManifestMetadataFromEntry", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetBulkLoadManifestMetadataFromEntryActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetBulkLoadManifestMetadataFromEntryActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 627 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
[[nodiscard]] Future<BulkLoadManifestSet> getBulkLoadManifestMetadataFromEntry( std::vector<BulkLoadJobFileManifestEntry> const& manifestEntries, std::string const& manifestLocalTempFolder, BulkLoadTransportMethod const& transportMethod, std::string const& jobRoot, UID const& logId ) {
															#line 627 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
	return Future<BulkLoadManifestSet>(new GetBulkLoadManifestMetadataFromEntryActor(manifestEntries, manifestLocalTempFolder, transportMethod, jobRoot, logId));
															#line 6686 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbserver/BulkLoadUtil.actor.g.cpp.py_gen"
}

#line 650 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbserver/BulkLoadUtil.actor.cpp"
