#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
/*
 * FlowTests.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Unit tests for the flow language and libraries

#include <chrono>
#include <thread>
#include "flow/Arena.h"
#include "flow/Error.h"
#include "flow/ProtocolVersion.h"
#include "flow/UnitTest.h"
#include "flow/DeterministicRandom.h"
#include "flow/IThreadPool.h"
#include "flow/WriteOnlySet.h"
#include "fdbrpc/fdbrpc.h"
#include "flow/IAsyncFile.h"
#include "flow/TLSConfig.actor.h"
#include "fdbrpc/grpc/AsyncTaskExecutor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

void forceLinkFlowTests() {}

constexpr int firstLine = __LINE__;
															#line 43 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via flowTestCase41()
															#line 41 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class FlowTestCase41Actor>
															#line 41 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase41ActorState {
															#line 50 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
															#line 41 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase41ActorState(UnitTestParameters const& params) 
															#line 41 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 41 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : params(params)
															#line 57 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("flowTestCase41", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase41ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase41", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 42 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			;
															#line 72 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase41ActorState();
		static_cast<FlowTestCase41Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 55 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		ASSERT(__FILE__sr.endsWith("FlowTests.actor.cpp"_sr));
															#line 56 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<FlowTestCase41Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase41ActorState(); static_cast<FlowTestCase41Actor*>(this)->destroy(); return 0; }
															#line 97 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		new (&static_cast<FlowTestCase41Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase41ActorState();
		static_cast<FlowTestCase41Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 44 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(__LINE__ == firstLine + 4);
															#line 45 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = Future<Void>(Void());
															#line 45 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (static_cast<FlowTestCase41Actor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 121 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase41Actor*>(this)->actor_wait_state = 1;
															#line 45 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase41Actor, 0, Void >*>(static_cast<FlowTestCase41Actor*>(this)));
															#line 126 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 49 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(__LINE__ == firstLine + 9);
															#line 50 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			StrictFuture<Void> __when_expr_1 = Future<Void>(Void());
															#line 50 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (static_cast<FlowTestCase41Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 165 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<FlowTestCase41Actor*>(this)->actor_wait_state = 2;
															#line 50 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase41Actor, 1, Void >*>(static_cast<FlowTestCase41Actor*>(this)));
															#line 170 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 46 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		ASSERT(__LINE__ == firstLine + 6);
															#line 47 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		return a_body1loopBody1Catch1(success(), loopDepth);
															#line 187 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 46 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		ASSERT(__LINE__ == firstLine + 6);
															#line 47 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		return a_body1loopBody1Catch1(success(), loopDepth);
															#line 197 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase41Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase41Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase41Actor*>(this)->ActorCallback< FlowTestCase41Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase41Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase41", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase41Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase41", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase41Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase41", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase41Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase41", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase41Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase41", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase41Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase41", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
															#line 51 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		ASSERT(__LINE__ == firstLine + 11);
															#line 280 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
															#line 51 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		ASSERT(__LINE__ == firstLine + 11);
															#line 289 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<FlowTestCase41Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase41Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase41Actor*>(this)->ActorCallback< FlowTestCase41Actor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase41Actor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase41", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase41Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase41", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FlowTestCase41Actor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase41", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase41Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase41", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FlowTestCase41Actor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase41", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase41Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase41", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 41 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	UnitTestParameters params;
															#line 371 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
};
// This generated class is to be used only via flowTestCase41()
															#line 41 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase41Actor final : public Actor<Void>, public ActorCallback< FlowTestCase41Actor, 0, Void >, public ActorCallback< FlowTestCase41Actor, 1, Void >, public FastAllocated<FlowTestCase41Actor>, public FlowTestCase41ActorState<FlowTestCase41Actor> {
															#line 376 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
	using FastAllocated<FlowTestCase41Actor>::operator new;
	using FastAllocated<FlowTestCase41Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8184056699778385152UL, 12136988461585012224UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase41Actor, 0, Void >;
friend struct ActorCallback< FlowTestCase41Actor, 1, Void >;
															#line 41 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase41Actor(UnitTestParameters const& params) 
															#line 394 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   FlowTestCase41ActorState<FlowTestCase41Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase41", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9036288986342350848UL, 9268930977875159808UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase41Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase41");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase41", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase41Actor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< FlowTestCase41Actor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 41 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> flowTestCase41( UnitTestParameters const& params ) {
															#line 41 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new FlowTestCase41Actor(params));
															#line 428 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
}
ACTOR_TEST_CASE(flowTestCase41, "/flow/actorcompiler/lineNumbers")

#line 58 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 434 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via flowTestCase59()
															#line 59 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class FlowTestCase59Actor>
															#line 59 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase59ActorState {
															#line 441 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
															#line 59 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase59ActorState(UnitTestParameters const& params) 
															#line 59 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 59 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : params(params)
															#line 448 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("flowTestCase59", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase59ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase59", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 60 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (FLOW_KNOBS->MAX_BUGGIFIED_DELAY == 0)
															#line 463 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			{
															#line 61 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				if (!static_cast<FlowTestCase59Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase59ActorState(); static_cast<FlowTestCase59Actor*>(this)->destroy(); return 0; }
															#line 467 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
				new (&static_cast<FlowTestCase59Actor*>(this)->SAV< Void >::value()) Void(Void());
				this->~FlowTestCase59ActorState();
				static_cast<FlowTestCase59Actor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 63 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			;
															#line 475 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase59ActorState();
		static_cast<FlowTestCase59Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 64 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		x = deterministicRandom()->random01();
															#line 65 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		last = 0;
															#line 66 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		f1 = map(delay(x), [last = &last](const Void&) { *last = 1; return Void(); });
															#line 70 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		f2 = map(delay(x), [last = &last](const Void&) { *last = 2; return Void(); });
															#line 74 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		StrictFuture<Void> __when_expr_0 = f1 && f2;
															#line 74 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (static_cast<FlowTestCase59Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 515 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<FlowTestCase59Actor*>(this)->actor_wait_state = 1;
															#line 74 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase59Actor, 0, Void >*>(static_cast<FlowTestCase59Actor*>(this)));
															#line 520 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 75 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (last == 1)
															#line 529 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		{
															#line 76 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			CODE_PROBE(true, "Delays can become ready out of order", probe::decoration::rare);
															#line 77 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (!static_cast<FlowTestCase59Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase59ActorState(); static_cast<FlowTestCase59Actor*>(this)->destroy(); return 0; }
															#line 535 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			new (&static_cast<FlowTestCase59Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase59ActorState();
			static_cast<FlowTestCase59Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 75 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (last == 1)
															#line 549 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		{
															#line 76 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			CODE_PROBE(true, "Delays can become ready out of order", probe::decoration::rare);
															#line 77 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (!static_cast<FlowTestCase59Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase59ActorState(); static_cast<FlowTestCase59Actor*>(this)->destroy(); return 0; }
															#line 555 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			new (&static_cast<FlowTestCase59Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase59ActorState();
			static_cast<FlowTestCase59Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase59Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase59Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase59Actor*>(this)->ActorCallback< FlowTestCase59Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase59Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase59", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase59Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase59", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase59Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase59", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase59Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase59", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase59Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase59", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase59Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase59", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 59 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	UnitTestParameters params;
															#line 64 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	double x;
															#line 65 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	int last;
															#line 66 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Future<Void> f1;
															#line 70 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Future<Void> f2;
															#line 650 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
};
// This generated class is to be used only via flowTestCase59()
															#line 59 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase59Actor final : public Actor<Void>, public ActorCallback< FlowTestCase59Actor, 0, Void >, public FastAllocated<FlowTestCase59Actor>, public FlowTestCase59ActorState<FlowTestCase59Actor> {
															#line 655 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
	using FastAllocated<FlowTestCase59Actor>::operator new;
	using FastAllocated<FlowTestCase59Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11266832611739699712UL, 9008275243740460288UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase59Actor, 0, Void >;
															#line 59 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase59Actor(UnitTestParameters const& params) 
															#line 672 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   FlowTestCase59ActorState<FlowTestCase59Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase59", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11639929796919967488UL, 5140402912124830208UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase59Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase59");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase59", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase59Actor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 59 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> flowTestCase59( UnitTestParameters const& params ) {
															#line 59 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new FlowTestCase59Actor(params));
															#line 705 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
}
ACTOR_TEST_CASE(flowTestCase59, "/flow/buggifiedDelay")

#line 81 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

template <class T, class Func, class ErrFunc, class CallbackType>
class LambdaCallback final : public CallbackType, public FastAllocated<LambdaCallback<T, Func, ErrFunc, CallbackType>> {
	Func func;
	ErrFunc errFunc;

	void fire(T const& t) override {
		CallbackType::remove();
		func(t);
		delete this;
	}
	void fire(T&& t) override {
		CallbackType::remove();
		func(std::move(t));
		delete this;
	}
	void error(Error e) override {
		CallbackType::remove();
		errFunc(e);
		delete this;
	}

public:
	LambdaCallback(Func&& f, ErrFunc&& e) : func(std::move(f)), errFunc(std::move(e)) {}
};

template <class T, class Func, class ErrFunc>
void onReady(Future<T>&& f, Func&& func, ErrFunc&& errFunc) {
	if (f.isReady()) {
		if (f.isError())
			errFunc(f.getError());
		else
			func(f.get());
	} else
		f.addCallbackAndClear(new LambdaCallback<T, Func, ErrFunc, Callback<T>>(std::move(func), std::move(errFunc)));
}

template <class T, class Func, class ErrFunc>
void onReady(FutureStream<T>&& f, Func&& func, ErrFunc&& errFunc) {
	if (f.isReady()) {
		if (f.isError())
			errFunc(f.getError());
		else
			func(f.pop());
	} else
		f.addCallbackAndClear(
		    new LambdaCallback<T, Func, ErrFunc, SingleCallback<T>>(std::move(func), std::move(errFunc)));
}

															#line 759 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via emptyVoidActor()
															#line 130 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class EmptyVoidActorActor>
															#line 130 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class EmptyVoidActorActorState {
															#line 766 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
															#line 130 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	EmptyVoidActorActorState() 
															#line 130 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	{
															#line 772 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		fdb_probe_actor_create("emptyVoidActor", reinterpret_cast<unsigned long>(this));

	}
	~EmptyVoidActorActorState() 
	{
		fdb_probe_actor_destroy("emptyVoidActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		delete static_cast<EmptyVoidActorActor*>(this);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 130 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		delete static_cast<EmptyVoidActorActor*>(this);
															#line 805 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		return 0;

		return loopDepth;
	}
};
// This generated class is to be used only via emptyVoidActor()
															#line 130 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class EmptyVoidActorActor final : public Actor<void>, public FastAllocated<EmptyVoidActorActor>, public EmptyVoidActorActorState<EmptyVoidActorActor> {
															#line 814 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
	using FastAllocated<EmptyVoidActorActor>::operator new;
	using FastAllocated<EmptyVoidActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15428417496430526208UL, 6083708671364299008UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() {{
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<void>*>(this)->~Actor();
        operator delete(this);
    }}
#pragma clang diagnostic pop
															#line 130 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	EmptyVoidActorActor() 
															#line 830 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		 : Actor<void>(),
		   EmptyVoidActorActorState<EmptyVoidActorActor>(),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("emptyVoidActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3992031095763062272UL, 6056561321581212416UL);
		ActorExecutionContextHelper __helper(static_cast<EmptyVoidActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("emptyVoidActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("emptyVoidActor", reinterpret_cast<unsigned long>(this), -1);

	}
};
} // namespace
															#line 130 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
static void emptyVoidActor(  ) {
															#line 130 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	new EmptyVoidActorActor();
															#line 854 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
}

#line 131 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 859 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via emptyActor()
															#line 132 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class EmptyActorActor>
															#line 132 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class EmptyActorActorState {
															#line 866 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
															#line 132 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	EmptyActorActorState() 
															#line 132 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	{
															#line 872 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		fdb_probe_actor_create("emptyActor", reinterpret_cast<unsigned long>(this));

	}
	~EmptyActorActorState() 
	{
		fdb_probe_actor_destroy("emptyActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 133 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (!static_cast<EmptyActorActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~EmptyActorActorState(); static_cast<EmptyActorActor*>(this)->destroy(); return 0; }
															#line 886 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			new (&static_cast<EmptyActorActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~EmptyActorActorState();
			static_cast<EmptyActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~EmptyActorActorState();
		static_cast<EmptyActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
};
// This generated class is to be used only via emptyActor()
															#line 132 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class EmptyActorActor final : public Actor<Void>, public FastAllocated<EmptyActorActor>, public EmptyActorActorState<EmptyActorActor> {
															#line 912 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
	using FastAllocated<EmptyActorActor>::operator new;
	using FastAllocated<EmptyActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4304234942776385792UL, 7339348954820184576UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 132 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	EmptyActorActor() 
															#line 928 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   EmptyActorActorState<EmptyActorActor>(),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("emptyActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15861535729408492288UL, 4290300210743134720UL);
		ActorExecutionContextHelper __helper(static_cast<EmptyActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("emptyActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("emptyActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 132 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> emptyActor(  ) {
															#line 132 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new EmptyActorActor());
															#line 960 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
}

#line 135 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 965 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via oneWaitVoidActor()
															#line 136 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class OneWaitVoidActorActor>
															#line 136 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class OneWaitVoidActorActorState {
															#line 972 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
															#line 136 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	OneWaitVoidActorActorState(Future<Void> const& f) 
															#line 136 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 136 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : f(f)
															#line 979 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("oneWaitVoidActor", reinterpret_cast<unsigned long>(this));

	}
	~OneWaitVoidActorActorState() 
	{
		fdb_probe_actor_destroy("oneWaitVoidActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 137 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = f;
															#line 137 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
															#line 996 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			static_cast<OneWaitVoidActorActor*>(this)->actor_wait_state = 1;
															#line 137 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< OneWaitVoidActorActor, 0, Void >*>(static_cast<OneWaitVoidActorActor*>(this)));
															#line 1000 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		delete static_cast<OneWaitVoidActorActor*>(this);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<OneWaitVoidActorActor*>(this)->actor_wait_state > 0) static_cast<OneWaitVoidActorActor*>(this)->actor_wait_state = 0;
		static_cast<OneWaitVoidActorActor*>(this)->ActorCallback< OneWaitVoidActorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< OneWaitVoidActorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("oneWaitVoidActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OneWaitVoidActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("oneWaitVoidActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< OneWaitVoidActorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("oneWaitVoidActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OneWaitVoidActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("oneWaitVoidActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< OneWaitVoidActorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("oneWaitVoidActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<OneWaitVoidActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("oneWaitVoidActor", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 136 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		delete static_cast<OneWaitVoidActorActor*>(this);
															#line 1109 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		return 0;

		return loopDepth;
	}
															#line 136 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Future<Void> f;
															#line 1116 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
};
// This generated class is to be used only via oneWaitVoidActor()
															#line 136 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class OneWaitVoidActorActor final : public Actor<void>, public ActorCallback< OneWaitVoidActorActor, 0, Void >, public FastAllocated<OneWaitVoidActorActor>, public OneWaitVoidActorActorState<OneWaitVoidActorActor> {
															#line 1121 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
	using FastAllocated<OneWaitVoidActorActor>::operator new;
	using FastAllocated<OneWaitVoidActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11827123642099745024UL, 12871643268472866304UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() {{
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<void>*>(this)->~Actor();
        operator delete(this);
    }}
#pragma clang diagnostic pop
friend struct ActorCallback< OneWaitVoidActorActor, 0, Void >;
															#line 136 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	OneWaitVoidActorActor(Future<Void> const& f) 
															#line 1138 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		 : Actor<void>(),
		   OneWaitVoidActorActorState<OneWaitVoidActorActor>(f),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("oneWaitVoidActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4959834572396190720UL, 15120160138639133440UL);
		ActorExecutionContextHelper __helper(static_cast<OneWaitVoidActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("oneWaitVoidActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("oneWaitVoidActor", reinterpret_cast<unsigned long>(this), -1);

	}
};
} // namespace
															#line 136 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
static void oneWaitVoidActor( Future<Void> const& f ) {
															#line 136 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	new OneWaitVoidActorActor(f);
															#line 1162 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
}

#line 139 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 1167 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via oneWaitActor()
															#line 140 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class OneWaitActorActor>
															#line 140 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class OneWaitActorActorState {
															#line 1174 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
															#line 140 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	OneWaitActorActorState(Future<Void> const& f) 
															#line 140 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 140 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : f(f)
															#line 1181 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("oneWaitActor", reinterpret_cast<unsigned long>(this));

	}
	~OneWaitActorActorState() 
	{
		fdb_probe_actor_destroy("oneWaitActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 141 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = f;
															#line 141 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (static_cast<OneWaitActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1198 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<OneWaitActorActor*>(this)->actor_wait_state = 1;
															#line 141 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< OneWaitActorActor, 0, Void >*>(static_cast<OneWaitActorActor*>(this)));
															#line 1203 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~OneWaitActorActorState();
		static_cast<OneWaitActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 142 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<OneWaitActorActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~OneWaitActorActorState(); static_cast<OneWaitActorActor*>(this)->destroy(); return 0; }
															#line 1226 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		new (&static_cast<OneWaitActorActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~OneWaitActorActorState();
		static_cast<OneWaitActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 142 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<OneWaitActorActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~OneWaitActorActorState(); static_cast<OneWaitActorActor*>(this)->destroy(); return 0; }
															#line 1238 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		new (&static_cast<OneWaitActorActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~OneWaitActorActorState();
		static_cast<OneWaitActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<OneWaitActorActor*>(this)->actor_wait_state > 0) static_cast<OneWaitActorActor*>(this)->actor_wait_state = 0;
		static_cast<OneWaitActorActor*>(this)->ActorCallback< OneWaitActorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< OneWaitActorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("oneWaitActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OneWaitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("oneWaitActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< OneWaitActorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("oneWaitActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OneWaitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("oneWaitActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< OneWaitActorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("oneWaitActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<OneWaitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("oneWaitActor", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 140 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Future<Void> f;
															#line 1323 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
};
// This generated class is to be used only via oneWaitActor()
															#line 140 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class OneWaitActorActor final : public Actor<Void>, public ActorCallback< OneWaitActorActor, 0, Void >, public FastAllocated<OneWaitActorActor>, public OneWaitActorActorState<OneWaitActorActor> {
															#line 1328 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
	using FastAllocated<OneWaitActorActor>::operator new;
	using FastAllocated<OneWaitActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4880114601548276736UL, 4263688228959626496UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< OneWaitActorActor, 0, Void >;
															#line 140 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	OneWaitActorActor(Future<Void> const& f) 
															#line 1345 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   OneWaitActorActorState<OneWaitActorActor>(f),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("oneWaitActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14706628315667835136UL, 3183390146889395968UL);
		ActorExecutionContextHelper __helper(static_cast<OneWaitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("oneWaitActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("oneWaitActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< OneWaitActorActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 140 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> oneWaitActor( Future<Void> const& f ) {
															#line 140 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new OneWaitActorActor(f));
															#line 1378 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
}

#line 144 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

Future<Void> g_cheese;
															#line 1384 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via cheeseWaitActor()
															#line 146 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class CheeseWaitActorActor>
															#line 146 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class CheeseWaitActorActorState {
															#line 1391 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
															#line 146 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	CheeseWaitActorActorState() 
															#line 146 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	{
															#line 1397 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		fdb_probe_actor_create("cheeseWaitActor", reinterpret_cast<unsigned long>(this));

	}
	~CheeseWaitActorActorState() 
	{
		fdb_probe_actor_destroy("cheeseWaitActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 147 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = g_cheese;
															#line 147 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (static_cast<CheeseWaitActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1413 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CheeseWaitActorActor*>(this)->actor_wait_state = 1;
															#line 147 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheeseWaitActorActor, 0, Void >*>(static_cast<CheeseWaitActorActor*>(this)));
															#line 1418 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheeseWaitActorActorState();
		static_cast<CheeseWaitActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 148 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<CheeseWaitActorActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheeseWaitActorActorState(); static_cast<CheeseWaitActorActor*>(this)->destroy(); return 0; }
															#line 1441 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		new (&static_cast<CheeseWaitActorActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CheeseWaitActorActorState();
		static_cast<CheeseWaitActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 148 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<CheeseWaitActorActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheeseWaitActorActorState(); static_cast<CheeseWaitActorActor*>(this)->destroy(); return 0; }
															#line 1453 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		new (&static_cast<CheeseWaitActorActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CheeseWaitActorActorState();
		static_cast<CheeseWaitActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheeseWaitActorActor*>(this)->actor_wait_state > 0) static_cast<CheeseWaitActorActor*>(this)->actor_wait_state = 0;
		static_cast<CheeseWaitActorActor*>(this)->ActorCallback< CheeseWaitActorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheeseWaitActorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("cheeseWaitActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheeseWaitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cheeseWaitActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheeseWaitActorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("cheeseWaitActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheeseWaitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cheeseWaitActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheeseWaitActorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("cheeseWaitActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheeseWaitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cheeseWaitActor", reinterpret_cast<unsigned long>(this), 0);

	}
};
// This generated class is to be used only via cheeseWaitActor()
															#line 146 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class CheeseWaitActorActor final : public Actor<Void>, public ActorCallback< CheeseWaitActorActor, 0, Void >, public FastAllocated<CheeseWaitActorActor>, public CheeseWaitActorActorState<CheeseWaitActorActor> {
															#line 1540 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
	using FastAllocated<CheeseWaitActorActor>::operator new;
	using FastAllocated<CheeseWaitActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15828915324226254336UL, 8333365059486050560UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheeseWaitActorActor, 0, Void >;
															#line 146 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	CheeseWaitActorActor() 
															#line 1557 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   CheeseWaitActorActorState<CheeseWaitActorActor>(),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("cheeseWaitActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11924659823367017728UL, 9190457517789878528UL);
		ActorExecutionContextHelper __helper(static_cast<CheeseWaitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("cheeseWaitActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("cheeseWaitActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheeseWaitActorActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 146 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> cheeseWaitActor(  ) {
															#line 146 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new CheeseWaitActorActor());
															#line 1590 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
}

#line 150 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

size_t cheeseWaitActorSize() {
#ifndef OPEN_FOR_IDE
	return sizeof(CheeseWaitActorActor);
#else
	return 0ul;
#endif
}

															#line 1603 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via trivialVoidActor()
															#line 159 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class TrivialVoidActorActor>
															#line 159 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class TrivialVoidActorActorState {
															#line 1610 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
															#line 159 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	TrivialVoidActorActorState(int* const& result) 
															#line 159 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 159 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : result(result)
															#line 1617 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("trivialVoidActor", reinterpret_cast<unsigned long>(this));

	}
	~TrivialVoidActorActorState() 
	{
		fdb_probe_actor_destroy("trivialVoidActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 160 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			*result = 1;
															#line 1632 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			loopDepth = a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		delete static_cast<TrivialVoidActorActor*>(this);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 159 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		delete static_cast<TrivialVoidActorActor*>(this);
															#line 1654 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		return 0;

		return loopDepth;
	}
															#line 159 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	int* result;
															#line 1661 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
};
// This generated class is to be used only via trivialVoidActor()
															#line 159 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class TrivialVoidActorActor final : public Actor<void>, public FastAllocated<TrivialVoidActorActor>, public TrivialVoidActorActorState<TrivialVoidActorActor> {
															#line 1666 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
	using FastAllocated<TrivialVoidActorActor>::operator new;
	using FastAllocated<TrivialVoidActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5143589224327568640UL, 16608863072170535168UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() {{
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<void>*>(this)->~Actor();
        operator delete(this);
    }}
#pragma clang diagnostic pop
															#line 159 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	TrivialVoidActorActor(int* const& result) 
															#line 1682 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		 : Actor<void>(),
		   TrivialVoidActorActorState<TrivialVoidActorActor>(result),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("trivialVoidActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15340033039238992128UL, 6049743622380387072UL);
		ActorExecutionContextHelper __helper(static_cast<TrivialVoidActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("trivialVoidActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("trivialVoidActor", reinterpret_cast<unsigned long>(this), -1);

	}
};
} // namespace
															#line 159 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
static void trivialVoidActor( int* const& result ) {
															#line 159 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	new TrivialVoidActorActor(result);
															#line 1706 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
}

#line 162 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 1711 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via return42Actor()
															#line 163 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class Return42ActorActor>
															#line 163 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class Return42ActorActorState {
															#line 1718 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
															#line 163 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Return42ActorActorState() 
															#line 163 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	{
															#line 1724 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		fdb_probe_actor_create("return42Actor", reinterpret_cast<unsigned long>(this));

	}
	~Return42ActorActorState() 
	{
		fdb_probe_actor_destroy("return42Actor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 164 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (!static_cast<Return42ActorActor*>(this)->SAV<int>::futures) { (void)(42); this->~Return42ActorActorState(); static_cast<Return42ActorActor*>(this)->destroy(); return 0; }
															#line 1738 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			new (&static_cast<Return42ActorActor*>(this)->SAV< int >::value()) int(42);
			this->~Return42ActorActorState();
			static_cast<Return42ActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~Return42ActorActorState();
		static_cast<Return42ActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
};
// This generated class is to be used only via return42Actor()
															#line 163 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class Return42ActorActor final : public Actor<int>, public FastAllocated<Return42ActorActor>, public Return42ActorActorState<Return42ActorActor> {
															#line 1764 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
	using FastAllocated<Return42ActorActor>::operator new;
	using FastAllocated<Return42ActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5494404381274134016UL, 10003286538624226304UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<int>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 163 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Return42ActorActor() 
															#line 1780 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		 : Actor<int>(),
		   Return42ActorActorState<Return42ActorActor>(),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("return42Actor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10940871408049559296UL, 4095833238457056256UL);
		ActorExecutionContextHelper __helper(static_cast<Return42ActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("return42Actor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("return42Actor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 163 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<int> return42Actor(  ) {
															#line 163 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<int>(new Return42ActorActor());
															#line 1812 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
}

#line 166 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 1817 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via voidWaitActor()
															#line 167 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class VoidWaitActorActor>
															#line 167 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class VoidWaitActorActorState {
															#line 1824 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
															#line 167 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	VoidWaitActorActorState(Future<int> const& in,int* const& result) 
															#line 167 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 167 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : in(in),
															#line 167 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		   result(result)
															#line 1833 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("voidWaitActor", reinterpret_cast<unsigned long>(this));

	}
	~VoidWaitActorActorState() 
	{
		fdb_probe_actor_destroy("voidWaitActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 168 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			StrictFuture<int> __when_expr_0 = in;
															#line 168 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
															#line 1850 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			static_cast<VoidWaitActorActor*>(this)->actor_wait_state = 1;
															#line 168 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< VoidWaitActorActor, 0, int >*>(static_cast<VoidWaitActorActor*>(this)));
															#line 1854 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		delete static_cast<VoidWaitActorActor*>(this);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int const& i,int loopDepth) 
	{
															#line 169 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		*result = i;
															#line 1876 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(int && i,int loopDepth) 
	{
															#line 169 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		*result = i;
															#line 1885 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1when1(int const& i,int loopDepth) 
	{
		loopDepth = a_body1cont1(i, loopDepth);

		return loopDepth;
	}
	int a_body1when1(int && i,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(i), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<VoidWaitActorActor*>(this)->actor_wait_state > 0) static_cast<VoidWaitActorActor*>(this)->actor_wait_state = 0;
		static_cast<VoidWaitActorActor*>(this)->ActorCallback< VoidWaitActorActor, 0, int >::remove();

	}
	void a_callback_fire(ActorCallback< VoidWaitActorActor, 0, int >*,int const& value) 
	{
		fdb_probe_actor_enter("voidWaitActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VoidWaitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("voidWaitActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< VoidWaitActorActor, 0, int >*,int && value) 
	{
		fdb_probe_actor_enter("voidWaitActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VoidWaitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("voidWaitActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< VoidWaitActorActor, 0, int >*,Error err) 
	{
		fdb_probe_actor_enter("voidWaitActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<VoidWaitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("voidWaitActor", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 167 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		delete static_cast<VoidWaitActorActor*>(this);
															#line 1969 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		return 0;

		return loopDepth;
	}
															#line 167 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Future<int> in;
															#line 167 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	int* result;
															#line 1978 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
};
// This generated class is to be used only via voidWaitActor()
															#line 167 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class VoidWaitActorActor final : public Actor<void>, public ActorCallback< VoidWaitActorActor, 0, int >, public FastAllocated<VoidWaitActorActor>, public VoidWaitActorActorState<VoidWaitActorActor> {
															#line 1983 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
	using FastAllocated<VoidWaitActorActor>::operator new;
	using FastAllocated<VoidWaitActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3410156738294152704UL, 10761260772531286784UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() {{
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<void>*>(this)->~Actor();
        operator delete(this);
    }}
#pragma clang diagnostic pop
friend struct ActorCallback< VoidWaitActorActor, 0, int >;
															#line 167 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	VoidWaitActorActor(Future<int> const& in,int* const& result) 
															#line 2000 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		 : Actor<void>(),
		   VoidWaitActorActorState<VoidWaitActorActor>(in, result),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("voidWaitActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4523678045317434112UL, 607490058614652416UL);
		ActorExecutionContextHelper __helper(static_cast<VoidWaitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("voidWaitActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("voidWaitActor", reinterpret_cast<unsigned long>(this), -1);

	}
};
} // namespace
															#line 167 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
static void voidWaitActor( Future<int> const& in, int* const& result ) {
															#line 167 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	new VoidWaitActorActor(in, result);
															#line 2024 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
}

#line 171 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 2029 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via addOneActor()
															#line 172 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class AddOneActorActor>
															#line 172 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class AddOneActorActorState {
															#line 2036 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
															#line 172 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	AddOneActorActorState(Future<int> const& in) 
															#line 172 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 172 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : in(in)
															#line 2043 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("addOneActor", reinterpret_cast<unsigned long>(this));

	}
	~AddOneActorActorState() 
	{
		fdb_probe_actor_destroy("addOneActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 173 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			StrictFuture<int> __when_expr_0 = in;
															#line 173 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (static_cast<AddOneActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2060 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<AddOneActorActor*>(this)->actor_wait_state = 1;
															#line 173 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< AddOneActorActor, 0, int >*>(static_cast<AddOneActorActor*>(this)));
															#line 2065 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~AddOneActorActorState();
		static_cast<AddOneActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int const& i,int loopDepth) 
	{
															#line 174 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<AddOneActorActor*>(this)->SAV<int>::futures) { (void)(i + 1); this->~AddOneActorActorState(); static_cast<AddOneActorActor*>(this)->destroy(); return 0; }
															#line 2088 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		new (&static_cast<AddOneActorActor*>(this)->SAV< int >::value()) int(i + 1);
		this->~AddOneActorActorState();
		static_cast<AddOneActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(int && i,int loopDepth) 
	{
															#line 174 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<AddOneActorActor*>(this)->SAV<int>::futures) { (void)(i + 1); this->~AddOneActorActorState(); static_cast<AddOneActorActor*>(this)->destroy(); return 0; }
															#line 2100 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		new (&static_cast<AddOneActorActor*>(this)->SAV< int >::value()) int(i + 1);
		this->~AddOneActorActorState();
		static_cast<AddOneActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(int const& i,int loopDepth) 
	{
		loopDepth = a_body1cont1(i, loopDepth);

		return loopDepth;
	}
	int a_body1when1(int && i,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(i), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<AddOneActorActor*>(this)->actor_wait_state > 0) static_cast<AddOneActorActor*>(this)->actor_wait_state = 0;
		static_cast<AddOneActorActor*>(this)->ActorCallback< AddOneActorActor, 0, int >::remove();

	}
	void a_callback_fire(ActorCallback< AddOneActorActor, 0, int >*,int const& value) 
	{
		fdb_probe_actor_enter("addOneActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddOneActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addOneActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< AddOneActorActor, 0, int >*,int && value) 
	{
		fdb_probe_actor_enter("addOneActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddOneActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addOneActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< AddOneActorActor, 0, int >*,Error err) 
	{
		fdb_probe_actor_enter("addOneActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AddOneActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addOneActor", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 172 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Future<int> in;
															#line 2185 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
};
// This generated class is to be used only via addOneActor()
															#line 172 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class AddOneActorActor final : public Actor<int>, public ActorCallback< AddOneActorActor, 0, int >, public FastAllocated<AddOneActorActor>, public AddOneActorActorState<AddOneActorActor> {
															#line 2190 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
	using FastAllocated<AddOneActorActor>::operator new;
	using FastAllocated<AddOneActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7738182331607828736UL, 6706656814373127936UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<int>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< AddOneActorActor, 0, int >;
															#line 172 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	AddOneActorActor(Future<int> const& in) 
															#line 2207 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		 : Actor<int>(),
		   AddOneActorActorState<AddOneActorActor>(in),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("addOneActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16535816285787488512UL, 16973372841591770112UL);
		ActorExecutionContextHelper __helper(static_cast<AddOneActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("addOneActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("addOneActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< AddOneActorActor, 0, int >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 172 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<int> addOneActor( Future<int> const& in ) {
															#line 172 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<int>(new AddOneActorActor(in));
															#line 2240 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
}

#line 176 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 2245 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via chooseTwoActor()
															#line 177 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class ChooseTwoActorActor>
															#line 177 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class ChooseTwoActorActorState {
															#line 2252 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
															#line 177 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	ChooseTwoActorActorState(Future<Void> const& f,Future<Void> const& g) 
															#line 177 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 177 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : f(f),
															#line 177 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		   g(g)
															#line 2261 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("chooseTwoActor", reinterpret_cast<unsigned long>(this));

	}
	~ChooseTwoActorActorState() 
	{
		fdb_probe_actor_destroy("chooseTwoActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 179 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = f;
															#line 178 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (static_cast<ChooseTwoActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2278 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
															#line 180 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			StrictFuture<Void> __when_expr_1 = g;
															#line 2282 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
			static_cast<ChooseTwoActorActor*>(this)->actor_wait_state = 1;
															#line 179 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ChooseTwoActorActor, 0, Void >*>(static_cast<ChooseTwoActorActor*>(this)));
															#line 180 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ChooseTwoActorActor, 1, Void >*>(static_cast<ChooseTwoActorActor*>(this)));
															#line 2289 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ChooseTwoActorActorState();
		static_cast<ChooseTwoActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 182 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<ChooseTwoActorActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ChooseTwoActorActorState(); static_cast<ChooseTwoActorActor*>(this)->destroy(); return 0; }
															#line 2312 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		new (&static_cast<ChooseTwoActorActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ChooseTwoActorActorState();
		static_cast<ChooseTwoActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ChooseTwoActorActor*>(this)->actor_wait_state > 0) static_cast<ChooseTwoActorActor*>(this)->actor_wait_state = 0;
		static_cast<ChooseTwoActorActor*>(this)->ActorCallback< ChooseTwoActorActor, 0, Void >::remove();
		static_cast<ChooseTwoActorActor*>(this)->ActorCallback< ChooseTwoActorActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChooseTwoActorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("chooseTwoActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChooseTwoActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("chooseTwoActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ChooseTwoActorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("chooseTwoActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChooseTwoActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("chooseTwoActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ChooseTwoActorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("chooseTwoActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChooseTwoActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("chooseTwoActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ChooseTwoActorActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("chooseTwoActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChooseTwoActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("chooseTwoActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ChooseTwoActorActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("chooseTwoActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChooseTwoActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("chooseTwoActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ChooseTwoActorActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("chooseTwoActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChooseTwoActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("chooseTwoActor", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 177 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Future<Void> f;
															#line 177 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Future<Void> g;
															#line 2469 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
};
// This generated class is to be used only via chooseTwoActor()
															#line 177 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class ChooseTwoActorActor final : public Actor<Void>, public ActorCallback< ChooseTwoActorActor, 0, Void >, public ActorCallback< ChooseTwoActorActor, 1, Void >, public FastAllocated<ChooseTwoActorActor>, public ChooseTwoActorActorState<ChooseTwoActorActor> {
															#line 2474 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
	using FastAllocated<ChooseTwoActorActor>::operator new;
	using FastAllocated<ChooseTwoActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2915178702904033792UL, 147379175403291136UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ChooseTwoActorActor, 0, Void >;
friend struct ActorCallback< ChooseTwoActorActor, 1, Void >;
															#line 177 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	ChooseTwoActorActor(Future<Void> const& f,Future<Void> const& g) 
															#line 2492 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   ChooseTwoActorActorState<ChooseTwoActorActor>(f, g),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("chooseTwoActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1758439379909727232UL, 9229871646340306944UL);
		ActorExecutionContextHelper __helper(static_cast<ChooseTwoActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("chooseTwoActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("chooseTwoActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ChooseTwoActorActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 177 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> chooseTwoActor( Future<Void> const& f, Future<Void> const& g ) {
															#line 177 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new ChooseTwoActorActor(f, g));
															#line 2525 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
}

#line 184 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 2530 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via consumeOneActor()
															#line 185 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class ConsumeOneActorActor>
															#line 185 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class ConsumeOneActorActorState {
															#line 2537 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
															#line 185 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	ConsumeOneActorActorState(FutureStream<int> const& in) 
															#line 185 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 185 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : in(in)
															#line 2544 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("consumeOneActor", reinterpret_cast<unsigned long>(this));

	}
	~ConsumeOneActorActorState() 
	{
		fdb_probe_actor_destroy("consumeOneActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 186 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			auto __when_expr_0 = in;
															#line 2559 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			static_assert(std::is_same<decltype(__when_expr_0), FutureStream<int>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<int>>::value, "invalid type");
															#line 186 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (static_cast<ConsumeOneActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2563 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.pop(), loopDepth); };
			static_cast<ConsumeOneActorActor*>(this)->actor_wait_state = 1;
															#line 186 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< ConsumeOneActorActor, 0, int >*>(static_cast<ConsumeOneActorActor*>(this)));
															#line 2568 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ConsumeOneActorActorState();
		static_cast<ConsumeOneActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int const& i,int loopDepth) 
	{
															#line 187 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<ConsumeOneActorActor*>(this)->SAV<int>::futures) { (void)(i); this->~ConsumeOneActorActorState(); static_cast<ConsumeOneActorActor*>(this)->destroy(); return 0; }
															#line 2591 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		new (&static_cast<ConsumeOneActorActor*>(this)->SAV< int >::value()) int(i);
		this->~ConsumeOneActorActorState();
		static_cast<ConsumeOneActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(int && i,int loopDepth) 
	{
															#line 187 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<ConsumeOneActorActor*>(this)->SAV<int>::futures) { (void)(i); this->~ConsumeOneActorActorState(); static_cast<ConsumeOneActorActor*>(this)->destroy(); return 0; }
															#line 2603 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		new (&static_cast<ConsumeOneActorActor*>(this)->SAV< int >::value()) int(i);
		this->~ConsumeOneActorActorState();
		static_cast<ConsumeOneActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(int const& i,int loopDepth) 
	{
		loopDepth = a_body1cont1(i, loopDepth);

		return loopDepth;
	}
	int a_body1when1(int && i,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(i), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ConsumeOneActorActor*>(this)->actor_wait_state > 0) static_cast<ConsumeOneActorActor*>(this)->actor_wait_state = 0;
		static_cast<ConsumeOneActorActor*>(this)->ActorSingleCallback< ConsumeOneActorActor, 0, int >::remove();

	}
	void a_callback_fire(ActorSingleCallback< ConsumeOneActorActor, 0, int >*,int const& value) 
	{
		fdb_probe_actor_enter("consumeOneActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsumeOneActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consumeOneActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< ConsumeOneActorActor, 0, int >*,int && value) 
	{
		fdb_probe_actor_enter("consumeOneActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsumeOneActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consumeOneActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< ConsumeOneActorActor, 0, int >*,Error err) 
	{
		fdb_probe_actor_enter("consumeOneActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConsumeOneActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consumeOneActor", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 185 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FutureStream<int> in;
															#line 2688 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
};
// This generated class is to be used only via consumeOneActor()
															#line 185 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class ConsumeOneActorActor final : public Actor<int>, public ActorSingleCallback< ConsumeOneActorActor, 0, int >, public FastAllocated<ConsumeOneActorActor>, public ConsumeOneActorActorState<ConsumeOneActorActor> {
															#line 2693 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
	using FastAllocated<ConsumeOneActorActor>::operator new;
	using FastAllocated<ConsumeOneActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7612459020792783616UL, 13020784797714386432UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<int>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< ConsumeOneActorActor, 0, int >;
															#line 185 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	ConsumeOneActorActor(FutureStream<int> const& in) 
															#line 2710 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		 : Actor<int>(),
		   ConsumeOneActorActorState<ConsumeOneActorActor>(in),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("consumeOneActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15463506707502989568UL, 14609495624834383104UL);
		ActorExecutionContextHelper __helper(static_cast<ConsumeOneActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("consumeOneActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("consumeOneActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< ConsumeOneActorActor, 0, int >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 185 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<int> consumeOneActor( FutureStream<int> const& in ) {
															#line 185 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<int>(new ConsumeOneActorActor(in));
															#line 2743 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
}

#line 189 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 2748 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via sumActor()
															#line 190 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class SumActorActor>
															#line 190 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class SumActorActorState {
															#line 2755 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
															#line 190 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	SumActorActorState(FutureStream<int> const& in) 
															#line 190 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 190 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : in(in),
															#line 191 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		   total(0)
															#line 2764 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("sumActor", reinterpret_cast<unsigned long>(this));

	}
	~SumActorActorState() 
	{
		fdb_probe_actor_destroy("sumActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 193 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				;
															#line 2780 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SumActorActorState();
		static_cast<SumActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 201 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<SumActorActor*>(this)->SAV<int>::futures) { (void)(total); this->~SumActorActorState(); static_cast<SumActorActor*>(this)->destroy(); return 0; }
															#line 2809 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		new (&static_cast<SumActorActor*>(this)->SAV< int >::value()) int(std::move(total)); // state_var_RVO
		this->~SumActorActorState();
		static_cast<SumActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 198 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (e.code() != error_code_end_of_stream)
															#line 2822 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			{
															#line 199 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 2826 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			}
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 194 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		auto __when_expr_0 = in;
															#line 2849 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		static_assert(std::is_same<decltype(__when_expr_0), FutureStream<int>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<int>>::value, "invalid type");
															#line 194 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (static_cast<SumActorActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2853 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
		static_cast<SumActorActor*>(this)->actor_wait_state = 1;
															#line 194 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< SumActorActor, 0, int >*>(static_cast<SumActorActor*>(this)));
															#line 2858 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int const& i,int loopDepth) 
	{
															#line 195 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		total += i;
															#line 2867 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(int && i,int loopDepth) 
	{
															#line 195 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		total += i;
															#line 2876 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(int const& i,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(i, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(int && i,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(i), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SumActorActor*>(this)->actor_wait_state > 0) static_cast<SumActorActor*>(this)->actor_wait_state = 0;
		static_cast<SumActorActor*>(this)->ActorSingleCallback< SumActorActor, 0, int >::remove();

	}
	void a_callback_fire(ActorSingleCallback< SumActorActor, 0, int >*,int const& value) 
	{
		fdb_probe_actor_enter("sumActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SumActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sumActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< SumActorActor, 0, int >*,int && value) 
	{
		fdb_probe_actor_enter("sumActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SumActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sumActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< SumActorActor, 0, int >*,Error err) 
	{
		fdb_probe_actor_enter("sumActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SumActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sumActor", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 190 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FutureStream<int> in;
															#line 191 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	int total;
															#line 2960 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
};
// This generated class is to be used only via sumActor()
															#line 190 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class SumActorActor final : public Actor<int>, public ActorSingleCallback< SumActorActor, 0, int >, public FastAllocated<SumActorActor>, public SumActorActorState<SumActorActor> {
															#line 2965 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
	using FastAllocated<SumActorActor>::operator new;
	using FastAllocated<SumActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11732034447778705152UL, 15726023065703078656UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<int>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< SumActorActor, 0, int >;
															#line 190 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	SumActorActor(FutureStream<int> const& in) 
															#line 2982 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		 : Actor<int>(),
		   SumActorActorState<SumActorActor>(in),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("sumActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4376063734086770688UL, 18309943484118422272UL);
		ActorExecutionContextHelper __helper(static_cast<SumActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("sumActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("sumActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< SumActorActor, 0, int >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 190 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<int> sumActor( FutureStream<int> const& in ) {
															#line 190 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<int>(new SumActorActor(in));
															#line 3015 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
}

#line 203 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 3020 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via templateActor()
															#line 204 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class T, class TemplateActorActor>
															#line 204 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class TemplateActorActorState {
															#line 3027 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
															#line 204 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	TemplateActorActorState(T const& t) 
															#line 204 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 204 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : t(t)
															#line 3034 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("templateActor", reinterpret_cast<unsigned long>(this));

	}
	~TemplateActorActorState() 
	{
		fdb_probe_actor_destroy("templateActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 206 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (!static_cast<TemplateActorActor*>(this)->SAV<T>::futures) { (void)(t); this->~TemplateActorActorState(); static_cast<TemplateActorActor*>(this)->destroy(); return 0; }
															#line 3049 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			new (&static_cast<TemplateActorActor*>(this)->SAV< T >::value()) T(std::move(t)); // state_var_RVO
			this->~TemplateActorActorState();
			static_cast<TemplateActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TemplateActorActorState();
		static_cast<TemplateActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 204 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	T t;
															#line 3073 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
};
// This generated class is to be used only via templateActor()
															#line 204 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class T>
															#line 204 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class TemplateActorActor final : public Actor<T>, public FastAllocated<TemplateActorActor<T>>, public TemplateActorActorState<T, TemplateActorActor<T>> {
															#line 3080 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
	using FastAllocated<TemplateActorActor<T>>::operator new;
	using FastAllocated<TemplateActorActor<T>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16925715740308242432UL, 4558504409683066624UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<T>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 204 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	TemplateActorActor(T const& t) 
															#line 3096 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		 : Actor<T>(),
		   TemplateActorActorState<T, TemplateActorActor<T>>(t),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("templateActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7976452068631605760UL, 5885036663855436800UL);
		ActorExecutionContextHelper __helper(static_cast<TemplateActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("templateActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("templateActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 204 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class T>
															#line 204 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<T> templateActor( T const& t ) {
															#line 204 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<T>(new TemplateActorActor<T>(t));
															#line 3130 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
}

#line 208 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

static int destroy() {
	return 666;
}
															#line 3138 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via testHygeine()
															#line 212 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class TestHygeineActor>
															#line 212 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class TestHygeineActorState {
															#line 3145 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
															#line 212 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	TestHygeineActorState() 
															#line 212 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	{
															#line 3151 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		fdb_probe_actor_create("testHygeine", reinterpret_cast<unsigned long>(this));

	}
	~TestHygeineActorState() 
	{
		fdb_probe_actor_destroy("testHygeine", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 213 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(destroy() == 666);
															#line 214 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (!static_cast<TestHygeineActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestHygeineActorState(); static_cast<TestHygeineActor*>(this)->destroy(); return 0; }
															#line 3167 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			new (&static_cast<TestHygeineActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~TestHygeineActorState();
			static_cast<TestHygeineActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestHygeineActorState();
		static_cast<TestHygeineActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
};
// This generated class is to be used only via testHygeine()
															#line 212 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class TestHygeineActor final : public Actor<Void>, public FastAllocated<TestHygeineActor>, public TestHygeineActorState<TestHygeineActor> {
															#line 3193 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
	using FastAllocated<TestHygeineActor>::operator new;
	using FastAllocated<TestHygeineActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8425131270719386112UL, 2834740223545858304UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 212 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	TestHygeineActor() 
															#line 3209 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   TestHygeineActorState<TestHygeineActor>(),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testHygeine", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1499353059620502784UL, 874173607718983936UL);
		ActorExecutionContextHelper __helper(static_cast<TestHygeineActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testHygeine");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testHygeine", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 212 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> testHygeine(  ) {
															#line 212 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new TestHygeineActor());
															#line 3241 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
}

#line 216 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

// bool expectActorCount(int x) { return actorCount == x; }
bool expectActorCount(int) {
	return true;
}

struct YieldMockNetwork final : INetwork, ReferenceCounted<YieldMockNetwork> {
	int ticks;
	Promise<Void> nextTick;
	int nextYield;
	INetwork* baseNetwork;

	flowGlobalType global(int id) const override { return baseNetwork->global(id); }
	void setGlobal(size_t id, flowGlobalType v) override {
		baseNetwork->setGlobal(id, v);
		return;
	}

	YieldMockNetwork() : ticks(0), nextYield(0) {
		baseNetwork = g_network;
		g_network = this;
	}
	~YieldMockNetwork() { g_network = baseNetwork; }

	void tick() {
		ticks++;
		Promise<Void> t;
		t.swap(nextTick);
		t.send(Void());
	}

	Future<class Void> delay(double seconds, TaskPriority taskID) override { return nextTick.getFuture(); }

	Future<class Void> orderedDelay(double seconds, TaskPriority taskID) override { return nextTick.getFuture(); }

	void _swiftEnqueue(void* task) override { abort(); }

	Future<class Void> yield(TaskPriority taskID) override {
		if (check_yield(taskID))
			return delay(0, taskID);
		return Void();
	}

	bool check_yield(TaskPriority taskID) override {
		if (nextYield > 0)
			--nextYield;
		return nextYield == 0;
	}

	// Delegate everything else.  TODO: Make a base class NetworkWrapper for delegating everything in INetwork
	TaskPriority getCurrentTask() const override { return baseNetwork->getCurrentTask(); }
	void setCurrentTask(TaskPriority taskID) override { baseNetwork->setCurrentTask(taskID); }
	double now() const override { return baseNetwork->now(); }
	double timer() override { return baseNetwork->timer(); }
	double timer_monotonic() override { return baseNetwork->timer_monotonic(); }
	void stop() override { return baseNetwork->stop(); }
	void addStopCallback(std::function<void()> fn) override {
		ASSERT(false);
		return;
	}
	bool isSimulated() const override { return baseNetwork->isSimulated(); }
	void onMainThread(Promise<Void>&& signal, TaskPriority taskID) override {
		return baseNetwork->onMainThread(std::move(signal), taskID);
	}
	bool isOnMainThread() const override { return baseNetwork->isOnMainThread(); }
	THREAD_HANDLE startThread(THREAD_FUNC_RETURN (*func)(void*), void* arg, int stackSize, const char* name) override {
		return baseNetwork->startThread(func, arg, stackSize, name);
	}
	Future<Reference<class IAsyncFile>> open(std::string filename, int64_t flags, int64_t mode) {
		return IAsyncFileSystem::filesystem()->open(filename, flags, mode);
	}
	Future<Void> deleteFile(std::string filename, bool mustBeDurable) {
		return IAsyncFileSystem::filesystem()->deleteFile(filename, mustBeDurable);
	}
	void run() override { return baseNetwork->run(); }
	bool checkRunnable() override { return baseNetwork->checkRunnable(); }
	void getDiskBytes(std::string const& directory, int64_t& free, int64_t& total) override {
		return baseNetwork->getDiskBytes(directory, free, total);
	}
	bool isAddressOnThisHost(NetworkAddress const& addr) const override {
		return baseNetwork->isAddressOnThisHost(addr);
	}
	const TLSConfig& getTLSConfig() const override {
		static TLSConfig emptyConfig;
		return emptyConfig;
	}
#ifdef ENABLE_SAMPLING
	ActorLineageSet& getActorLineageSet() override { throw std::exception(); }
#endif
	ProtocolVersion protocolVersion() const override { return baseNetwork->protocolVersion(); }
};

struct NonserializableThing {};
															#line 3338 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via testNonserializableThing()
															#line 309 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class TestNonserializableThingActor>
															#line 309 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class TestNonserializableThingActorState {
															#line 3345 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
															#line 309 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	TestNonserializableThingActorState() 
															#line 309 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	{
															#line 3351 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		fdb_probe_actor_create("testNonserializableThing", reinterpret_cast<unsigned long>(this));

	}
	~TestNonserializableThingActorState() 
	{
		fdb_probe_actor_destroy("testNonserializableThing", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 310 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (!static_cast<TestNonserializableThingActor*>(this)->SAV<NonserializableThing>::futures) { (void)(NonserializableThing()); this->~TestNonserializableThingActorState(); static_cast<TestNonserializableThingActor*>(this)->destroy(); return 0; }
															#line 3365 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			new (&static_cast<TestNonserializableThingActor*>(this)->SAV< NonserializableThing >::value()) NonserializableThing(NonserializableThing());
			this->~TestNonserializableThingActorState();
			static_cast<TestNonserializableThingActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestNonserializableThingActorState();
		static_cast<TestNonserializableThingActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
};
// This generated class is to be used only via testNonserializableThing()
															#line 309 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class TestNonserializableThingActor final : public Actor<NonserializableThing>, public FastAllocated<TestNonserializableThingActor>, public TestNonserializableThingActorState<TestNonserializableThingActor> {
															#line 3391 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
	using FastAllocated<TestNonserializableThingActor>::operator new;
	using FastAllocated<TestNonserializableThingActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11865837957236076288UL, 8852514050768158208UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<NonserializableThing>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 309 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	TestNonserializableThingActor() 
															#line 3407 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		 : Actor<NonserializableThing>(),
		   TestNonserializableThingActorState<TestNonserializableThingActor>(),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testNonserializableThing", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(149492758402805248UL, 11653784399266102528UL);
		ActorExecutionContextHelper __helper(static_cast<TestNonserializableThingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testNonserializableThing");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testNonserializableThing", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 309 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<NonserializableThing> testNonserializableThing(  ) {
															#line 309 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<NonserializableThing>(new TestNonserializableThingActor());
															#line 3439 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
}

#line 312 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 3444 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via testCancelled()
															#line 313 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class TestCancelledActor>
															#line 313 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class TestCancelledActorState {
															#line 3451 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
															#line 313 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	TestCancelledActorState(bool* const& exits,Future<Void> const& f) 
															#line 313 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 313 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : exits(exits),
															#line 313 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		   f(f)
															#line 3460 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("testCancelled", reinterpret_cast<unsigned long>(this));

	}
	~TestCancelledActorState() 
	{
		fdb_probe_actor_destroy("testCancelled", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 315 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				StrictFuture<Void> __when_expr_0 = Future<Void>(Never());
															#line 315 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				if (static_cast<TestCancelledActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 3478 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<TestCancelledActor*>(this)->actor_wait_state = 1;
															#line 315 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TestCancelledActor, 0, Void >*>(static_cast<TestCancelledActor*>(this)));
															#line 3483 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestCancelledActorState();
		static_cast<TestCancelledActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 326 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<TestCancelledActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestCancelledActorState(); static_cast<TestCancelledActor*>(this)->destroy(); return 0; }
															#line 3512 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		new (&static_cast<TestCancelledActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestCancelledActorState();
		static_cast<TestCancelledActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 317 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			err = e;
															#line 3525 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			try {
															#line 319 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				StrictFuture<Void> __when_expr_1 = Future<Void>(Never());
															#line 319 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				if (static_cast<TestCancelledActor*>(this)->actor_wait_state < 0) return a_body1Catch2Catch1(actor_cancelled(), loopDepth);
															#line 3531 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2Catch1(__when_expr_1.getError(), loopDepth); else return a_body1Catch2when1(__when_expr_1.get(), loopDepth); };
				static_cast<TestCancelledActor*>(this)->actor_wait_state = 2;
															#line 319 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestCancelledActor, 1, Void >*>(static_cast<TestCancelledActor*>(this)));
															#line 3536 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2Catch1(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TestCancelledActor*>(this)->actor_wait_state > 0) static_cast<TestCancelledActor*>(this)->actor_wait_state = 0;
		static_cast<TestCancelledActor*>(this)->ActorCallback< TestCancelledActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestCancelledActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testCancelled", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestCancelledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCancelled", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TestCancelledActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testCancelled", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestCancelledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCancelled", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TestCancelledActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testCancelled", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestCancelledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCancelled", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch2cont1(int loopDepth) 
	{
															#line 324 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		return a_body1Catch1(err, loopDepth);
															#line 3657 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"

		return loopDepth;
	}
	int a_body1Catch2Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 321 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			*exits = true;
															#line 322 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 3668 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch2cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1Catch2cont3(loopDepth);

		return loopDepth;
	}
	int a_body1Catch2cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1Catch2cont3(loopDepth);

		return loopDepth;
	}
	int a_body1Catch2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1Catch2cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1Catch2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1Catch2cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TestCancelledActor*>(this)->actor_wait_state > 0) static_cast<TestCancelledActor*>(this)->actor_wait_state = 0;
		static_cast<TestCancelledActor*>(this)->ActorCallback< TestCancelledActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestCancelledActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testCancelled", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestCancelledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2Catch1(error, 0);
		} catch (...) {
			a_body1Catch2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCancelled", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TestCancelledActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testCancelled", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestCancelledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2Catch1(error, 0);
		} catch (...) {
			a_body1Catch2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCancelled", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TestCancelledActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testCancelled", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestCancelledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2Catch1(error, 0);
		} catch (...) {
			a_body1Catch2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCancelled", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1Catch2cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1Catch2cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 313 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	bool* exits;
															#line 313 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Future<Void> f;
															#line 317 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Error err;
															#line 3784 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
};
// This generated class is to be used only via testCancelled()
															#line 313 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class TestCancelledActor final : public Actor<Void>, public ActorCallback< TestCancelledActor, 0, Void >, public ActorCallback< TestCancelledActor, 1, Void >, public FastAllocated<TestCancelledActor>, public TestCancelledActorState<TestCancelledActor> {
															#line 3789 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
	using FastAllocated<TestCancelledActor>::operator new;
	using FastAllocated<TestCancelledActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14473568503362305280UL, 9530331295335413760UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TestCancelledActor, 0, Void >;
friend struct ActorCallback< TestCancelledActor, 1, Void >;
															#line 313 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	TestCancelledActor(bool* const& exits,Future<Void> const& f) 
															#line 3807 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   TestCancelledActorState<TestCancelledActor>(exits, f),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testCancelled", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13170310579731969536UL, 17465607942907386624UL);
		ActorExecutionContextHelper __helper(static_cast<TestCancelledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testCancelled");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testCancelled", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TestCancelledActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TestCancelledActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 313 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
Future<Void> testCancelled( bool* const& exits, Future<Void> const& f ) {
															#line 313 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new TestCancelledActor(exits, f));
															#line 3841 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
}

#line 328 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 3846 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via flowTestCase329()
															#line 329 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class FlowTestCase329Actor>
															#line 329 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase329ActorState {
															#line 3853 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
															#line 329 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase329ActorState(UnitTestParameters const& params) 
															#line 329 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 329 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : params(params)
															#line 3860 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("flowTestCase329", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase329ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase329", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 330 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			bool exits = false;
															#line 331 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			Promise<Void> p;
															#line 332 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			Future<Void> test = testCancelled(&exits, p.getFuture());
															#line 333 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(p.getPromiseReferenceCount() == 1 && p.getFutureReferenceCount() == 1);
															#line 334 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			test.cancel();
															#line 335 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(exits);
															#line 336 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(test.getPromiseReferenceCount() == 0 && test.getFutureReferenceCount() == 1 && test.isReady() && test.isError() && test.getError().code() == error_code_actor_cancelled);
															#line 338 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(p.getPromiseReferenceCount() == 1 && p.getFutureReferenceCount() == 0);
															#line 340 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (!static_cast<FlowTestCase329Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase329ActorState(); static_cast<FlowTestCase329Actor*>(this)->destroy(); return 0; }
															#line 3891 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			new (&static_cast<FlowTestCase329Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase329ActorState();
			static_cast<FlowTestCase329Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase329ActorState();
		static_cast<FlowTestCase329Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 329 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	UnitTestParameters params;
															#line 3915 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
};
// This generated class is to be used only via flowTestCase329()
															#line 329 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase329Actor final : public Actor<Void>, public FastAllocated<FlowTestCase329Actor>, public FlowTestCase329ActorState<FlowTestCase329Actor> {
															#line 3920 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
	using FastAllocated<FlowTestCase329Actor>::operator new;
	using FastAllocated<FlowTestCase329Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4716530815196756224UL, 671539083829650688UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 329 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase329Actor(UnitTestParameters const& params) 
															#line 3936 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   FlowTestCase329ActorState<FlowTestCase329Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase329", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15566747794379184896UL, 16670226518228459776UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase329Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase329");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase329", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 329 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> flowTestCase329( UnitTestParameters const& params ) {
															#line 329 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new FlowTestCase329Actor(params));
															#line 3968 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
}
ACTOR_TEST_CASE(flowTestCase329, "/flow/flow/cancel1")

#line 342 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 3974 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via noteCancel()
															#line 343 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class NoteCancelActor>
															#line 343 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class NoteCancelActorState {
															#line 3981 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
															#line 343 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	NoteCancelActorState(int* const& cancelled) 
															#line 343 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 343 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : cancelled(cancelled)
															#line 3988 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("noteCancel", reinterpret_cast<unsigned long>(this));

	}
	~NoteCancelActorState() 
	{
		fdb_probe_actor_destroy("noteCancel", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 344 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			*cancelled = 0;
															#line 4003 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			try {
															#line 346 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				StrictFuture<Void> __when_expr_0 = Future<Void>(Never());
															#line 346 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				if (static_cast<NoteCancelActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 4009 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<NoteCancelActor*>(this)->actor_wait_state = 1;
															#line 346 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< NoteCancelActor, 0, Void >*>(static_cast<NoteCancelActor*>(this)));
															#line 4014 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~NoteCancelActorState();
		static_cast<NoteCancelActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& __current_error,int loopDepth=0) 
	{
		try {
															#line 349 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			printf("Cancelled!\n");
															#line 350 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			*cancelled = 1;
															#line 351 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			return a_body1Catch1(__current_error, loopDepth);
															#line 4048 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 347 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		return a_body1Catch2(internal_error(), loopDepth);
															#line 4062 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 347 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		return a_body1Catch2(internal_error(), loopDepth);
															#line 4070 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<NoteCancelActor*>(this)->actor_wait_state > 0) static_cast<NoteCancelActor*>(this)->actor_wait_state = 0;
		static_cast<NoteCancelActor*>(this)->ActorCallback< NoteCancelActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< NoteCancelActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("noteCancel", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NoteCancelActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("noteCancel", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< NoteCancelActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("noteCancel", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NoteCancelActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("noteCancel", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< NoteCancelActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("noteCancel", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<NoteCancelActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("noteCancel", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 343 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	int* cancelled;
															#line 4151 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
};
// This generated class is to be used only via noteCancel()
															#line 343 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class NoteCancelActor final : public Actor<Void>, public ActorCallback< NoteCancelActor, 0, Void >, public FastAllocated<NoteCancelActor>, public NoteCancelActorState<NoteCancelActor> {
															#line 4156 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
	using FastAllocated<NoteCancelActor>::operator new;
	using FastAllocated<NoteCancelActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2269110650075151360UL, 4346931651289291520UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< NoteCancelActor, 0, Void >;
															#line 343 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	NoteCancelActor(int* const& cancelled) 
															#line 4173 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   NoteCancelActorState<NoteCancelActor>(cancelled),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("noteCancel", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5033296790666848000UL, 8182302322103455744UL);
		ActorExecutionContextHelper __helper(static_cast<NoteCancelActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("noteCancel");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("noteCancel", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< NoteCancelActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 343 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> noteCancel( int* const& cancelled ) {
															#line 343 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new NoteCancelActor(cancelled));
															#line 4206 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
}

#line 354 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 4211 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via flowTestCase355()
															#line 355 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class FlowTestCase355Actor>
															#line 355 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase355ActorState {
															#line 4218 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
															#line 355 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase355ActorState(UnitTestParameters const& params) 
															#line 355 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 355 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : params(params)
															#line 4225 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("flowTestCase355", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase355ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase355", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 356 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			int c1 = 0, c2 = 0, c3 = 0;
															#line 358 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			Future<Void> cf = noteCancel(&c1);
															#line 359 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(c1 == 0);
															#line 360 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			cf = Future<Void>();
															#line 361 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(c1 == 1);
															#line 363 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			cf = noteCancel(&c2) && noteCancel(&c3);
															#line 364 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(c2 == 0 && c3 == 0);
															#line 365 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			cf = Future<Void>();
															#line 366 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(c2 == 1 && c3 == 1);
															#line 367 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (!static_cast<FlowTestCase355Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase355ActorState(); static_cast<FlowTestCase355Actor*>(this)->destroy(); return 0; }
															#line 4258 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			new (&static_cast<FlowTestCase355Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase355ActorState();
			static_cast<FlowTestCase355Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase355ActorState();
		static_cast<FlowTestCase355Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 355 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	UnitTestParameters params;
															#line 4282 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
};
// This generated class is to be used only via flowTestCase355()
															#line 355 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase355Actor final : public Actor<Void>, public FastAllocated<FlowTestCase355Actor>, public FlowTestCase355ActorState<FlowTestCase355Actor> {
															#line 4287 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
	using FastAllocated<FlowTestCase355Actor>::operator new;
	using FastAllocated<FlowTestCase355Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12123806892183517952UL, 11815335685684121856UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 355 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase355Actor(UnitTestParameters const& params) 
															#line 4303 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   FlowTestCase355ActorState<FlowTestCase355Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase355", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5349180865294101760UL, 7146828749675357952UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase355Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase355");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase355", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 355 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> flowTestCase355( UnitTestParameters const& params ) {
															#line 355 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new FlowTestCase355Actor(params));
															#line 4335 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
}
ACTOR_TEST_CASE(flowTestCase355, "/flow/flow/cancel2")

#line 369 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

namespace flow_tests_details {
// Simple message for flatbuffers unittests
struct Int {
	constexpr static FileIdentifier file_identifier = 12345;
	uint32_t value;
	Int() = default;
	Int(uint32_t value) : value(value) {}
	template <class Ar>
	void serialize(Ar& ar) {
		serializer(ar, value);
	}
};
} // namespace flow_tests_details

															#line 4355 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via flowTestCase384()
															#line 384 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class FlowTestCase384Actor>
															#line 384 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase384ActorState {
															#line 4362 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
															#line 384 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase384ActorState(UnitTestParameters const& params) 
															#line 384 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 384 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : params(params)
															#line 4369 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("flowTestCase384", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase384ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase384", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			{
															#line 387 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				Future<NonserializableThing> f = testNonserializableThing();
															#line 388 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				Promise<NonserializableThing> p;
															#line 389 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				p.send(NonserializableThing());
															#line 390 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				f = p.getFuture();
															#line 4391 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			}
			{
															#line 398 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				ReplyPromise<flow_tests_details::Int> rpInt;
															#line 399 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				Future<flow_tests_details::Int> f = rpInt.getFuture();
															#line 400 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				ASSERT(!f.isReady());
															#line 401 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				rpInt.send(123);
															#line 402 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				ASSERT(f.get().value == 123);
															#line 4404 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			}
			{
															#line 406 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				RequestStream<flow_tests_details::Int> rsInt;
															#line 407 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				FutureStream<flow_tests_details::Int> f = rsInt.getFuture();
															#line 408 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				rsInt.send(1);
															#line 409 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				rsInt.send(2);
															#line 410 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				ASSERT(f.pop().value == 1);
															#line 411 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				ASSERT(f.pop().value == 2);
															#line 4419 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			}
															#line 414 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (!static_cast<FlowTestCase384Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase384ActorState(); static_cast<FlowTestCase384Actor*>(this)->destroy(); return 0; }
															#line 4423 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			new (&static_cast<FlowTestCase384Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase384ActorState();
			static_cast<FlowTestCase384Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase384ActorState();
		static_cast<FlowTestCase384Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 384 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	UnitTestParameters params;
															#line 4447 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
};
// This generated class is to be used only via flowTestCase384()
															#line 384 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase384Actor final : public Actor<Void>, public FastAllocated<FlowTestCase384Actor>, public FlowTestCase384ActorState<FlowTestCase384Actor> {
															#line 4452 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
	using FastAllocated<FlowTestCase384Actor>::operator new;
	using FastAllocated<FlowTestCase384Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5046966114560855808UL, 7683608100162438144UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 384 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase384Actor(UnitTestParameters const& params) 
															#line 4468 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   FlowTestCase384ActorState<FlowTestCase384Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase384", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16407556973171164928UL, 2719702248691992320UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase384Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase384");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase384", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 384 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> flowTestCase384( UnitTestParameters const& params ) {
															#line 384 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new FlowTestCase384Actor(params));
															#line 4500 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
}
ACTOR_TEST_CASE(flowTestCase384, "/flow/flow/nonserializable futures")

#line 416 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 4506 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via flowTestCase417()
															#line 417 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class FlowTestCase417Actor>
															#line 417 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase417ActorState {
															#line 4513 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
															#line 417 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase417ActorState(UnitTestParameters const& params) 
															#line 417 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 417 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : params(params)
															#line 4520 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("flowTestCase417", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase417ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase417", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			{
															#line 420 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				RequestStream<flow_tests_details::Int> locInt;
															#line 421 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				BinaryWriter wr(IncludeVersion());
															#line 422 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				wr << locInt;
															#line 424 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				ASSERT(locInt.getEndpoint().isValid() && locInt.getEndpoint().isLocal() && locInt.getEndpoint().getPrimaryAddress() == FlowTransport::transport().getLocalAddress());
															#line 427 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				BinaryReader rd(wr.toValue(), IncludeVersion());
															#line 428 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				RequestStream<flow_tests_details::Int> remoteInt;
															#line 429 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				rd >> remoteInt;
															#line 431 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				ASSERT(remoteInt.getEndpoint() == locInt.getEndpoint());
															#line 4550 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			}
															#line 436 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (0)
															#line 4554 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			{
															#line 437 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				ReplyPromise<flow_tests_details::Int> locInt;
															#line 438 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				BinaryWriter wr(IncludeVersion());
															#line 439 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				wr << locInt;
															#line 441 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				ASSERT(locInt.getEndpoint().isValid() && locInt.getEndpoint().isLocal());
															#line 443 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				BinaryReader rd(wr.toValue(), IncludeVersion());
															#line 444 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				ReplyPromise<flow_tests_details::Int> remoteInt;
															#line 445 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				rd >> remoteInt;
															#line 447 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				ASSERT(remoteInt.getEndpoint() == locInt.getEndpoint());
															#line 4572 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			}
															#line 450 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (!static_cast<FlowTestCase417Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase417ActorState(); static_cast<FlowTestCase417Actor*>(this)->destroy(); return 0; }
															#line 4576 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			new (&static_cast<FlowTestCase417Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase417ActorState();
			static_cast<FlowTestCase417Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase417ActorState();
		static_cast<FlowTestCase417Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 417 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	UnitTestParameters params;
															#line 4600 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
};
// This generated class is to be used only via flowTestCase417()
															#line 417 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase417Actor final : public Actor<Void>, public FastAllocated<FlowTestCase417Actor>, public FlowTestCase417ActorState<FlowTestCase417Actor> {
															#line 4605 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
	using FastAllocated<FlowTestCase417Actor>::operator new;
	using FastAllocated<FlowTestCase417Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(536981357451843840UL, 17777057961792833792UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 417 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase417Actor(UnitTestParameters const& params) 
															#line 4621 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   FlowTestCase417ActorState<FlowTestCase417Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase417", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14778862965650136832UL, 8022077818935141120UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase417Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase417");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase417", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 417 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> flowTestCase417( UnitTestParameters const& params ) {
															#line 417 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new FlowTestCase417Actor(params));
															#line 4653 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
}
ACTOR_TEST_CASE(flowTestCase417, "/flow/flow/networked futures")

#line 452 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 4659 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via flowTestCase453()
															#line 453 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class FlowTestCase453Actor>
															#line 453 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase453ActorState {
															#line 4666 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
															#line 453 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase453ActorState(UnitTestParameters const& params) 
															#line 453 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 453 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : params(params)
															#line 4673 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("flowTestCase453", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase453ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase453", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 454 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			std::vector<Promise<int>> ps(5);
															#line 455 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			std::vector<Future<int>> fs;
															#line 456 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			std::vector<Future<Void>> qs;
															#line 457 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			for( auto& p : ps ) {
															#line 458 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				fs.push_back(p.getFuture());
															#line 4696 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			}
															#line 460 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			for(int i = 0;i <= ps.size();i++) {
															#line 461 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				qs.push_back(quorum(fs, i));
															#line 4702 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			}
															#line 463 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			for(int i = 0;i < ps.size();i++) {
															#line 464 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				ASSERT(qs[i].isReady());
															#line 465 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				ASSERT(!qs[i + 1].isReady());
															#line 466 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				ps[i].send(i);
															#line 4712 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			}
															#line 468 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(qs[ps.size()].isReady());
															#line 469 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (!static_cast<FlowTestCase453Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase453ActorState(); static_cast<FlowTestCase453Actor*>(this)->destroy(); return 0; }
															#line 4718 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			new (&static_cast<FlowTestCase453Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase453ActorState();
			static_cast<FlowTestCase453Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase453ActorState();
		static_cast<FlowTestCase453Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 453 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	UnitTestParameters params;
															#line 4742 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
};
// This generated class is to be used only via flowTestCase453()
															#line 453 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase453Actor final : public Actor<Void>, public FastAllocated<FlowTestCase453Actor>, public FlowTestCase453ActorState<FlowTestCase453Actor> {
															#line 4747 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
	using FastAllocated<FlowTestCase453Actor>::operator new;
	using FastAllocated<FlowTestCase453Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16812275174512750336UL, 2043292987811002880UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 453 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase453Actor(UnitTestParameters const& params) 
															#line 4763 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   FlowTestCase453ActorState<FlowTestCase453Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase453", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3780861377891986944UL, 16838074452003899392UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase453Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase453");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase453", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 453 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> flowTestCase453( UnitTestParameters const& params ) {
															#line 453 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new FlowTestCase453Actor(params));
															#line 4795 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
}
ACTOR_TEST_CASE(flowTestCase453, "/flow/flow/quorum")

#line 471 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 4801 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via flowTestCase472()
															#line 472 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class FlowTestCase472Actor>
															#line 472 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase472ActorState {
															#line 4808 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
															#line 472 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase472ActorState(UnitTestParameters const& params) 
															#line 472 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 472 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : params(params)
															#line 4815 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("flowTestCase472", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase472ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase472", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 473 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			Future<int> invalid;
															#line 474 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(!invalid.isValid());
															#line 476 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			Future<int> never = Never();
															#line 477 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(never.isValid() && !never.isReady());
															#line 479 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			Future<int> one = 1;
															#line 480 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(one.isValid() && one.isReady() && !one.isError());
															#line 481 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(one.get() == 1);
															#line 482 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(one.getFutureReferenceCount() == 1);
															#line 483 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (!static_cast<FlowTestCase472Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase472ActorState(); static_cast<FlowTestCase472Actor*>(this)->destroy(); return 0; }
															#line 4846 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			new (&static_cast<FlowTestCase472Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase472ActorState();
			static_cast<FlowTestCase472Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase472ActorState();
		static_cast<FlowTestCase472Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 472 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	UnitTestParameters params;
															#line 4870 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
};
// This generated class is to be used only via flowTestCase472()
															#line 472 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase472Actor final : public Actor<Void>, public FastAllocated<FlowTestCase472Actor>, public FlowTestCase472ActorState<FlowTestCase472Actor> {
															#line 4875 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
	using FastAllocated<FlowTestCase472Actor>::operator new;
	using FastAllocated<FlowTestCase472Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12398827722318684416UL, 9386834640781387776UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 472 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase472Actor(UnitTestParameters const& params) 
															#line 4891 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   FlowTestCase472ActorState<FlowTestCase472Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase472", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5598781920013419520UL, 16976122867298620672UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase472Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase472");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase472", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 472 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> flowTestCase472( UnitTestParameters const& params ) {
															#line 472 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new FlowTestCase472Actor(params));
															#line 4923 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
}
ACTOR_TEST_CASE(flowTestCase472, "/flow/flow/trivial futures")

#line 485 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 4929 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via flowTestCase486()
															#line 486 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class FlowTestCase486Actor>
															#line 486 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase486ActorState {
															#line 4936 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
															#line 486 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase486ActorState(UnitTestParameters const& params) 
															#line 486 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 486 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : params(params)
															#line 4943 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("flowTestCase486", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase486ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase486", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 487 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			Future<int> f;
															#line 489 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			Promise<int> p;
															#line 490 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(p.isValid());
															#line 491 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(!p.isSet());
															#line 492 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			p.send(1);
															#line 493 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(p.isSet());
															#line 494 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(p.getFuture().get() == 1);
															#line 496 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			Promise<int> p2;
															#line 497 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			f = p2.getFuture();
															#line 498 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(f.isValid() && !f.isReady());
															#line 499 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			p2.send(2);
															#line 500 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(f.isValid() && f.isReady() && !f.isError());
															#line 501 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(f.get() == 2);
															#line 503 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			Promise<int> p3;
															#line 504 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			f = p3.getFuture();
															#line 505 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			p3.sendError(end_of_stream());
															#line 506 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(f.isValid() && f.isReady() && f.isError());
															#line 507 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(f.getError().code() == error_code_end_of_stream);
															#line 509 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			Promise<int> p4;
															#line 510 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			f = p4.getFuture();
															#line 511 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			p4 = Promise<int>();
															#line 512 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(p4.isValid() && !p4.isSet());
															#line 513 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(f.isValid() && f.isReady() && f.isError());
															#line 514 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(f.getError().code() == error_code_broken_promise);
															#line 515 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (!static_cast<FlowTestCase486Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase486ActorState(); static_cast<FlowTestCase486Actor*>(this)->destroy(); return 0; }
															#line 5006 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			new (&static_cast<FlowTestCase486Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase486ActorState();
			static_cast<FlowTestCase486Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase486ActorState();
		static_cast<FlowTestCase486Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 486 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	UnitTestParameters params;
															#line 5030 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
};
// This generated class is to be used only via flowTestCase486()
															#line 486 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase486Actor final : public Actor<Void>, public FastAllocated<FlowTestCase486Actor>, public FlowTestCase486ActorState<FlowTestCase486Actor> {
															#line 5035 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
	using FastAllocated<FlowTestCase486Actor>::operator new;
	using FastAllocated<FlowTestCase486Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1259709651931991040UL, 981402168518023168UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 486 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase486Actor(UnitTestParameters const& params) 
															#line 5051 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   FlowTestCase486ActorState<FlowTestCase486Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase486", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2896134089767273216UL, 15490287775713841664UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase486Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase486");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase486", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 486 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> flowTestCase486( UnitTestParameters const& params ) {
															#line 486 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new FlowTestCase486Actor(params));
															#line 5083 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
}
ACTOR_TEST_CASE(flowTestCase486, "/flow/flow/trivial promises")

#line 517 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 5089 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via flowTestCase518()
															#line 518 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class FlowTestCase518Actor>
															#line 518 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase518ActorState {
															#line 5096 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
															#line 518 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase518ActorState(UnitTestParameters const& params) 
															#line 518 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 518 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : params(params)
															#line 5103 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("flowTestCase518", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase518ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase518", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 519 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			FutureStream<int> f;
															#line 521 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			PromiseStream<int> p;
															#line 522 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			p.send(1);
															#line 523 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(p.getFuture().isReady());
															#line 524 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(p.getFuture().pop() == 1);
															#line 526 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			PromiseStream<int> p2;
															#line 527 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			f = p2.getFuture();
															#line 528 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(f.isValid() && !f.isReady());
															#line 529 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			p2.send(2);
															#line 530 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			p2.send(3);
															#line 531 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(f.isValid() && f.isReady() && !f.isError());
															#line 532 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(f.pop() == 2);
															#line 533 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(f.pop() == 3);
															#line 535 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			PromiseStream<int> p3;
															#line 536 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			f = p3.getFuture();
															#line 537 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			p3.send(4);
															#line 538 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			p3.sendError(end_of_stream());
															#line 539 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(f.isReady() && !f.isError());
															#line 540 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(f.pop() == 4);
															#line 541 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(f.isError());
															#line 542 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(f.getError().code() == error_code_end_of_stream);
															#line 544 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			PromiseStream<int> p4;
															#line 545 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			f = p4.getFuture();
															#line 546 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			p4 = PromiseStream<int>();
															#line 547 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(f.isValid() && f.isReady() && f.isError());
															#line 548 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(f.getError().code() == error_code_broken_promise);
															#line 549 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (!static_cast<FlowTestCase518Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase518ActorState(); static_cast<FlowTestCase518Actor*>(this)->destroy(); return 0; }
															#line 5170 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			new (&static_cast<FlowTestCase518Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase518ActorState();
			static_cast<FlowTestCase518Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase518ActorState();
		static_cast<FlowTestCase518Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 518 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	UnitTestParameters params;
															#line 5194 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
};
// This generated class is to be used only via flowTestCase518()
															#line 518 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase518Actor final : public Actor<Void>, public FastAllocated<FlowTestCase518Actor>, public FlowTestCase518ActorState<FlowTestCase518Actor> {
															#line 5199 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
	using FastAllocated<FlowTestCase518Actor>::operator new;
	using FastAllocated<FlowTestCase518Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14256739180086232320UL, 1863313168192323584UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 518 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase518Actor(UnitTestParameters const& params) 
															#line 5215 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   FlowTestCase518ActorState<FlowTestCase518Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase518", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(463801543162199808UL, 10817026709096272384UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase518Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase518");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase518", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 518 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> flowTestCase518( UnitTestParameters const& params ) {
															#line 518 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new FlowTestCase518Actor(params));
															#line 5247 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
}
ACTOR_TEST_CASE(flowTestCase518, "/flow/flow/trivial promisestreams")

#line 551 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 5253 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via flowTestCase552()
															#line 552 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class FlowTestCase552Actor>
															#line 552 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase552ActorState {
															#line 5260 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
															#line 552 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase552ActorState(UnitTestParameters const& params) 
															#line 552 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 552 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : params(params)
															#line 5267 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("flowTestCase552", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase552ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase552", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 553 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			Promise<int> p;
															#line 554 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			Future<int> f = p.getFuture();
															#line 555 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			int result = 0;
															#line 556 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			bool happened = false;
															#line 558 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			onReady(std::move(f), [&result](int x) { result = x; }, [&result](Error e) { result = -1; });
															#line 559 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			onReady(p.getFuture(), [&happened](int) { happened = true; }, [&happened](Error) { happened = true; });
															#line 560 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(!f.isValid());
															#line 561 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(p.isValid() && !p.isSet() && p.getFutureReferenceCount() == 1);
															#line 562 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(result == 0 && !happened);
															#line 564 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			p.send(123);
															#line 565 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(result == 123 && happened);
															#line 566 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(p.isValid() && p.isSet() && p.getFutureReferenceCount() == 0 && p.getFuture().get() == 123);
															#line 568 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			result = 0;
															#line 569 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			onReady(p.getFuture(), [&result](int x) { result = x; }, [&result](Error e) { result = -1; });
															#line 570 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(result == 123);
															#line 571 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(p.isValid() && p.isSet() && p.getFutureReferenceCount() == 0 && p.getFuture().get() == 123);
															#line 573 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			p = Promise<int>();
															#line 574 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			f = p.getFuture();
															#line 575 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			result = 0;
															#line 576 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			onReady(std::move(f), [&result](int x) { result = x; }, [&result](Error e) { result = -e.code(); });
															#line 577 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(!f.isValid());
															#line 578 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(p.isValid() && !p.isSet() && p.getFutureReferenceCount() == 1);
															#line 579 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(result == 0);
															#line 581 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			p = Promise<int>();
															#line 582 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(result == -error_code_broken_promise);
															#line 583 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (!static_cast<FlowTestCase552Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase552ActorState(); static_cast<FlowTestCase552Actor*>(this)->destroy(); return 0; }
															#line 5332 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			new (&static_cast<FlowTestCase552Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase552ActorState();
			static_cast<FlowTestCase552Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase552ActorState();
		static_cast<FlowTestCase552Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 552 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	UnitTestParameters params;
															#line 5356 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
};
// This generated class is to be used only via flowTestCase552()
															#line 552 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase552Actor final : public Actor<Void>, public FastAllocated<FlowTestCase552Actor>, public FlowTestCase552ActorState<FlowTestCase552Actor> {
															#line 5361 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
	using FastAllocated<FlowTestCase552Actor>::operator new;
	using FastAllocated<FlowTestCase552Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10191015788607588352UL, 15143042730269425664UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 552 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase552Actor(UnitTestParameters const& params) 
															#line 5377 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   FlowTestCase552ActorState<FlowTestCase552Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase552", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12476725723183723008UL, 12930070128415838720UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase552Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase552");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase552", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 552 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> flowTestCase552( UnitTestParameters const& params ) {
															#line 552 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new FlowTestCase552Actor(params));
															#line 5409 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
}
ACTOR_TEST_CASE(flowTestCase552, "/flow/flow/callbacks")

#line 585 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 5415 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via flowTestCase586()
															#line 586 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class FlowTestCase586Actor>
															#line 586 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase586ActorState {
															#line 5422 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
															#line 586 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase586ActorState(UnitTestParameters const& params) 
															#line 586 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 586 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : params(params)
															#line 5429 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("flowTestCase586", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase586ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase586", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 587 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			PromiseStream<int> p;
															#line 589 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			int result = 0;
															#line 591 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			onReady(p.getFuture(), [&result](int x) { result = x; }, [&result](Error e) { result = -1; });
															#line 593 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(result == 0);
															#line 595 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			p.send(123);
															#line 596 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			p.send(456);
															#line 598 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(result == 123);
															#line 599 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			result = 0;
															#line 601 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			onReady(p.getFuture(), [&result](int x) { result = x; }, [&result](Error e) { result = -1; });
															#line 603 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(result == 456);
															#line 604 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			result = 0;
															#line 606 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			onReady(p.getFuture(), [&result](int x) { result = x; }, [&result](Error e) { result = -1; });
															#line 608 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(result == 0);
															#line 610 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			p = PromiseStream<int>();
															#line 612 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(result == -1);
															#line 613 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (!static_cast<FlowTestCase586Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase586ActorState(); static_cast<FlowTestCase586Actor*>(this)->destroy(); return 0; }
															#line 5474 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			new (&static_cast<FlowTestCase586Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase586ActorState();
			static_cast<FlowTestCase586Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase586ActorState();
		static_cast<FlowTestCase586Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 586 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	UnitTestParameters params;
															#line 5498 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
};
// This generated class is to be used only via flowTestCase586()
															#line 586 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase586Actor final : public Actor<Void>, public FastAllocated<FlowTestCase586Actor>, public FlowTestCase586ActorState<FlowTestCase586Actor> {
															#line 5503 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
	using FastAllocated<FlowTestCase586Actor>::operator new;
	using FastAllocated<FlowTestCase586Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5063394831694707968UL, 13536354092987783936UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 586 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase586Actor(UnitTestParameters const& params) 
															#line 5519 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   FlowTestCase586ActorState<FlowTestCase586Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase586", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17372355865915633664UL, 14153466278304974080UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase586Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase586");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase586", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 586 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> flowTestCase586( UnitTestParameters const& params ) {
															#line 586 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new FlowTestCase586Actor(params));
															#line 5551 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
}
ACTOR_TEST_CASE(flowTestCase586, "/flow/flow/promisestream callbacks")

#line 615 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

// Incompatible with --crash, so we are commenting it out for now
/*
TEST_CASE("/flow/flow/promisestream multiple wait error")
{
    state int result = 0;
    state PromiseStream<int> p;
    try {
        onReady(p.getFuture(), [&result](int x) { result = x; }, [&result](Error e){ result = -1; });
        result = 100;
        onReady(p.getFuture(), [&result](int x) { result = x; }, [&result](Error e){ result = -1; });
        ASSERT(false);
    }
    catch (Error& e) {
        ASSERT(e.code() == error_code_internal_error);
    }
    ASSERT(result == 100);
    p = PromiseStream<int>();
    ASSERT(result == -1);
    return Void();
}
*/

															#line 5579 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via flowTestCase638()
															#line 638 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class FlowTestCase638Actor>
															#line 638 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase638ActorState {
															#line 5586 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
															#line 638 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase638ActorState(UnitTestParameters const& params) 
															#line 638 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 638 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : params(params)
															#line 5593 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("flowTestCase638", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase638ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase638", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 639 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(expectActorCount(0));
															#line 641 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			int result = 0;
															#line 642 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			trivialVoidActor(&result);
															#line 643 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(result == 1);
															#line 644 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(expectActorCount(0));
															#line 646 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			Future<int> f = return42Actor();
															#line 647 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(f.isReady() && !f.isError() && f.get() == 42 && f.getFutureReferenceCount() == 1 && f.getPromiseReferenceCount() == 0);
															#line 649 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(expectActorCount(1));
															#line 650 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			f = Future<int>();
															#line 651 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(expectActorCount(0));
															#line 653 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			f = templateActor(24);
															#line 654 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(f.isReady() && !f.isError() && f.get() == 24 && f.getFutureReferenceCount() == 1 && f.getPromiseReferenceCount() == 0);
															#line 656 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(expectActorCount(1));
															#line 657 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			f = Future<int>();
															#line 658 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(expectActorCount(0));
															#line 660 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			result = 0;
															#line 661 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			voidWaitActor(2, &result);
															#line 662 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(result == 2 && expectActorCount(0));
															#line 664 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			Promise<int> p;
															#line 665 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			f = addOneActor(p.getFuture());
															#line 666 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(!f.isReady() && expectActorCount(1));
															#line 667 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			p.send(100);
															#line 668 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(f.isReady() && f.get() == 101);
															#line 669 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(expectActorCount(1));
															#line 670 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			f = Future<int>();
															#line 671 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(expectActorCount(0));
															#line 673 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			PromiseStream<int> ps;
															#line 674 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			f = consumeOneActor(ps.getFuture());
															#line 675 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(!f.isReady() && expectActorCount(1));
															#line 676 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ps.send(101);
															#line 677 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(f.get() == 101 && ps.isEmpty());
															#line 678 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ps.send(102);
															#line 679 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(!ps.isEmpty());
															#line 680 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			f = consumeOneActor(ps.getFuture());
															#line 681 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(f.get() == 102 && ps.isEmpty());
															#line 683 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			f = sumActor(ps.getFuture());
															#line 684 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ps.send(1);
															#line 685 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ps.send(10);
															#line 686 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ps.send(100);
															#line 687 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ps.sendError(end_of_stream());
															#line 688 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(f.get() == 111);
															#line 690 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(testHygeine().isReady());
															#line 691 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (!static_cast<FlowTestCase638Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase638ActorState(); static_cast<FlowTestCase638Actor*>(this)->destroy(); return 0; }
															#line 5692 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			new (&static_cast<FlowTestCase638Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase638ActorState();
			static_cast<FlowTestCase638Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase638ActorState();
		static_cast<FlowTestCase638Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 638 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	UnitTestParameters params;
															#line 5716 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
};
// This generated class is to be used only via flowTestCase638()
															#line 638 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase638Actor final : public Actor<Void>, public FastAllocated<FlowTestCase638Actor>, public FlowTestCase638ActorState<FlowTestCase638Actor> {
															#line 5721 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
	using FastAllocated<FlowTestCase638Actor>::operator new;
	using FastAllocated<FlowTestCase638Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(189276078092091904UL, 1357503292561989632UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 638 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase638Actor(UnitTestParameters const& params) 
															#line 5737 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   FlowTestCase638ActorState<FlowTestCase638Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase638", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8926318499705869056UL, 8546923920944049664UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase638Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase638");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase638", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 638 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> flowTestCase638( UnitTestParameters const& params ) {
															#line 638 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new FlowTestCase638Actor(params));
															#line 5769 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
}
ACTOR_TEST_CASE(flowTestCase638, "/flow/flow/trivial actors")

#line 693 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 5775 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via flowTestCase694()
															#line 694 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class FlowTestCase694Actor>
															#line 694 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase694ActorState {
															#line 5782 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
															#line 694 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase694ActorState(UnitTestParameters const& params) 
															#line 694 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 694 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : params(params)
															#line 5789 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("flowTestCase694", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase694ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase694", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 698 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			auto yn = makeReference<YieldMockNetwork>();
															#line 700 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			yn->nextYield = 0;
															#line 702 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			Promise<Void> p;
															#line 703 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			Future<Void> u = p.getFuture();
															#line 704 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			Future<Void> i = success(u);
															#line 706 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			std::vector<Future<Void>> v;
															#line 707 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			for(int i = 0;i < 5;i++) {
															#line 708 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				v.push_back(yieldedFuture(u));
															#line 5818 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			}
															#line 709 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			auto numReady = [&v]() { return std::count_if(v.begin(), v.end(), [](Future<Void> v) { return v.isReady(); }); };
															#line 711 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(numReady() == 0);
															#line 712 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			p.send(Void());
															#line 713 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(u.isReady() && i.isReady() && numReady() == 0);
															#line 715 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			for(int i = 0;i < 5;i++) {
															#line 716 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				yn->tick();
															#line 717 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				ASSERT(numReady() == i + 1);
															#line 5834 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			}
															#line 720 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			for(int i = 0;i < 5;i++) {
															#line 721 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				ASSERT(v[i].getPromiseReferenceCount() == 0 && v[i].getFutureReferenceCount() == 1);
															#line 5840 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			}
															#line 724 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (!static_cast<FlowTestCase694Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase694ActorState(); static_cast<FlowTestCase694Actor*>(this)->destroy(); return 0; }
															#line 5844 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			new (&static_cast<FlowTestCase694Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase694ActorState();
			static_cast<FlowTestCase694Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase694ActorState();
		static_cast<FlowTestCase694Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 694 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	UnitTestParameters params;
															#line 5868 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
};
// This generated class is to be used only via flowTestCase694()
															#line 694 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase694Actor final : public Actor<Void>, public FastAllocated<FlowTestCase694Actor>, public FlowTestCase694ActorState<FlowTestCase694Actor> {
															#line 5873 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
	using FastAllocated<FlowTestCase694Actor>::operator new;
	using FastAllocated<FlowTestCase694Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14484421258622895872UL, 9985912265400090880UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 694 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase694Actor(UnitTestParameters const& params) 
															#line 5889 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   FlowTestCase694ActorState<FlowTestCase694Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase694", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16093642462086646528UL, 12234540185744053248UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase694Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase694");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase694", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 694 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> flowTestCase694( UnitTestParameters const& params ) {
															#line 694 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new FlowTestCase694Actor(params));
															#line 5921 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
}
ACTOR_TEST_CASE(flowTestCase694, "/flow/flow/yieldedFuture/progress")

#line 726 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 5927 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via flowTestCase727()
															#line 727 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class FlowTestCase727Actor>
															#line 727 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase727ActorState {
															#line 5934 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
															#line 727 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase727ActorState(UnitTestParameters const& params) 
															#line 727 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 727 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : params(params)
															#line 5941 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("flowTestCase727", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase727ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase727", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 730 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			auto yn = makeReference<YieldMockNetwork>();
															#line 732 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			for(int r = 0;r < 100;r++) {
															#line 733 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				Promise<Void> p;
															#line 734 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				Future<Void> u = p.getFuture();
															#line 735 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				Future<Void> i = success(u);
															#line 737 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				std::vector<Future<Void>> v;
															#line 738 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				for(int i = 0;i < 25;i++) {
															#line 739 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					v.push_back(yieldedFuture(u));
															#line 5970 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
				}
															#line 740 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				auto numReady = [&v]() { return std::count_if(v.begin(), v.end(), [](Future<Void> v) { return v.isReady(); }); };
															#line 744 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				Future<Void> j = success(u);
															#line 746 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				ASSERT(numReady() == 0);
															#line 748 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				int expectYield = deterministicRandom()->randomInt(0, 4);
															#line 749 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				int expectReady = expectYield;
															#line 750 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				yn->nextYield = 1 + expectYield;
															#line 752 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				p.send(Void());
															#line 753 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				ASSERT(u.isReady() && i.isReady() && j.isReady() && numReady() == expectReady);
															#line 755 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				for(;numReady() != v.size();) {
															#line 756 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					expectYield = deterministicRandom()->randomInt(0, 4);
															#line 757 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					yn->nextYield = 1 + expectYield;
															#line 758 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					expectReady += 1 + expectYield;
															#line 759 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					yn->tick();
															#line 762 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					ASSERT(numReady() == std::min<int>(expectReady, v.size()));
															#line 6000 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
				}
															#line 765 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				for(int i = 0;i < v.size();i++) {
															#line 766 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					ASSERT(v[i].getPromiseReferenceCount() == 0 && v[i].getFutureReferenceCount() == 1);
															#line 6006 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
				}
			}
															#line 770 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (!static_cast<FlowTestCase727Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase727ActorState(); static_cast<FlowTestCase727Actor*>(this)->destroy(); return 0; }
															#line 6011 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			new (&static_cast<FlowTestCase727Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase727ActorState();
			static_cast<FlowTestCase727Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase727ActorState();
		static_cast<FlowTestCase727Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 727 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	UnitTestParameters params;
															#line 6035 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
};
// This generated class is to be used only via flowTestCase727()
															#line 727 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase727Actor final : public Actor<Void>, public FastAllocated<FlowTestCase727Actor>, public FlowTestCase727ActorState<FlowTestCase727Actor> {
															#line 6040 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
	using FastAllocated<FlowTestCase727Actor>::operator new;
	using FastAllocated<FlowTestCase727Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6372258999698390272UL, 265848300160585728UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 727 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase727Actor(UnitTestParameters const& params) 
															#line 6056 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   FlowTestCase727ActorState<FlowTestCase727Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase727", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4409634954555124992UL, 16751488767419794688UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase727Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase727");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase727", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 727 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> flowTestCase727( UnitTestParameters const& params ) {
															#line 727 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new FlowTestCase727Actor(params));
															#line 6088 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
}
ACTOR_TEST_CASE(flowTestCase727, "/flow/flow/yieldedFuture/random")

#line 772 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 6094 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via flowTestCase773()
															#line 773 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class FlowTestCase773Actor>
															#line 773 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase773ActorState {
															#line 6101 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
															#line 773 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase773ActorState(UnitTestParameters const& params) 
															#line 773 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 773 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : params(params)
															#line 6108 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("flowTestCase773", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase773ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase773", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 774 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			double start;
															#line 775 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			int N = 1000000;
															#line 777 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			auto yn = makeReference<YieldMockNetwork>();
															#line 779 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			yn->nextYield = 2 * N + 100;
															#line 781 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			Promise<Void> p;
															#line 782 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			Future<Void> f = p.getFuture();
															#line 783 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			std::vector<Future<Void>> ys;
															#line 785 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			start = timer();
															#line 786 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			for(int i = 0;i < N;i++) {
															#line 787 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				ys.push_back(yieldedFuture(f));
															#line 6141 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			}
															#line 788 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			printf("yieldedFuture(f) create: %0.1f M/sec\n", N / 1e6 / (timer() - start));
															#line 789 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			p.send(Void());
															#line 790 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			printf("yieldedFuture(f) total: %0.1f M/sec\n", N / 1e6 / (timer() - start));
															#line 792 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			for( auto& y : ys ) {
															#line 793 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				ASSERT(y.isReady());
															#line 6153 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			}
															#line 795 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			p = Promise<Void>();
															#line 796 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			f = p.getFuture();
															#line 798 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			start = timer();
															#line 799 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			for(int i = 0;i < N;i++) {
															#line 800 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				yieldedFuture(f);
															#line 6165 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			}
															#line 801 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			printf("yieldedFuture(f) cancel: %0.1f M/sec\n", N / 1e6 / (timer() - start));
															#line 803 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (!static_cast<FlowTestCase773Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase773ActorState(); static_cast<FlowTestCase773Actor*>(this)->destroy(); return 0; }
															#line 6171 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			new (&static_cast<FlowTestCase773Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase773ActorState();
			static_cast<FlowTestCase773Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase773ActorState();
		static_cast<FlowTestCase773Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 773 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	UnitTestParameters params;
															#line 6195 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
};
// This generated class is to be used only via flowTestCase773()
															#line 773 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase773Actor final : public Actor<Void>, public FastAllocated<FlowTestCase773Actor>, public FlowTestCase773ActorState<FlowTestCase773Actor> {
															#line 6200 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
	using FastAllocated<FlowTestCase773Actor>::operator new;
	using FastAllocated<FlowTestCase773Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15911997802561400320UL, 7896802055760800256UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 773 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase773Actor(UnitTestParameters const& params) 
															#line 6216 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   FlowTestCase773ActorState<FlowTestCase773Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase773", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2164477136972213504UL, 9144031046588979712UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase773Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase773");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase773", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 773 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> flowTestCase773( UnitTestParameters const& params ) {
															#line 773 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new FlowTestCase773Actor(params));
															#line 6248 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
}
ACTOR_TEST_CASE(flowTestCase773, "/flow/perf/yieldedFuture")

#line 805 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 6254 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via flowTestCase806()
															#line 806 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class FlowTestCase806Actor>
															#line 806 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase806ActorState {
															#line 6261 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
															#line 806 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase806ActorState(UnitTestParameters const& params) 
															#line 806 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 806 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : params(params)
															#line 6268 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("flowTestCase806", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase806ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase806", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 807 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(expectActorCount(0));
															#line 809 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			Promise<Void> a, b;
															#line 810 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			Future<Void> c = chooseTwoActor(a.getFuture(), b.getFuture());
															#line 811 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(a.getFutureReferenceCount() == 2 && b.getFutureReferenceCount() == 2 && !c.isReady());
															#line 812 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			b.send(Void());
															#line 813 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(a.getFutureReferenceCount() == 0 && b.getFutureReferenceCount() == 0 && c.isReady() && !c.isError() && expectActorCount(1));
															#line 815 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			c = Future<Void>();
															#line 816 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(a.getFutureReferenceCount() == 0 && b.getFutureReferenceCount() == 0 && expectActorCount(0));
															#line 817 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (!static_cast<FlowTestCase806Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase806ActorState(); static_cast<FlowTestCase806Actor*>(this)->destroy(); return 0; }
															#line 6299 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			new (&static_cast<FlowTestCase806Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase806ActorState();
			static_cast<FlowTestCase806Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase806ActorState();
		static_cast<FlowTestCase806Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 806 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	UnitTestParameters params;
															#line 6323 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
};
// This generated class is to be used only via flowTestCase806()
															#line 806 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase806Actor final : public Actor<Void>, public FastAllocated<FlowTestCase806Actor>, public FlowTestCase806ActorState<FlowTestCase806Actor> {
															#line 6328 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
	using FastAllocated<FlowTestCase806Actor>::operator new;
	using FastAllocated<FlowTestCase806Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13435840816080683520UL, 9124673078922648832UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 806 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase806Actor(UnitTestParameters const& params) 
															#line 6344 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   FlowTestCase806ActorState<FlowTestCase806Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase806", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13119145203896912896UL, 7539303562061006336UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase806Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase806");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase806", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 806 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> flowTestCase806( UnitTestParameters const& params ) {
															#line 806 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new FlowTestCase806Actor(params));
															#line 6376 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
}
ACTOR_TEST_CASE(flowTestCase806, "/flow/flow/chooseTwoActor")

#line 819 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 6382 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via flowTestCase820()
															#line 820 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class FlowTestCase820Actor>
															#line 820 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase820ActorState {
															#line 6389 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
															#line 820 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase820ActorState(UnitTestParameters const& params) 
															#line 820 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 820 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : params(params)
															#line 6396 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("flowTestCase820", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase820ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase820", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 821 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			double start;
															#line 822 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			int N = 1000000;
															#line 824 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(expectActorCount(0));
															#line 826 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			start = timer();
															#line 827 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			for(int i = 0;i < N;i++) {
															#line 828 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				emptyVoidActor();
															#line 6421 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			}
															#line 829 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			printf("emptyVoidActor(): %0.1f M/sec\n", N / 1e6 / (timer() - start));
															#line 831 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(expectActorCount(0));
															#line 833 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			start = timer();
															#line 834 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			for(int i = 0;i < N;i++) {
															#line 835 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				emptyActor();
															#line 6433 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			}
															#line 837 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			printf("emptyActor(): %0.1f M/sec\n", N / 1e6 / (timer() - start));
															#line 839 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(expectActorCount(0));
															#line 841 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			Promise<Void> neverSet;
															#line 842 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			Future<Void> never = neverSet.getFuture();
															#line 843 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			Future<Void> already = Void();
															#line 845 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			start = timer();
															#line 846 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			for(int i = 0;i < N;i++) {
															#line 847 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				oneWaitVoidActor(already);
															#line 6451 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			}
															#line 848 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			printf("oneWaitVoidActor(already): %0.1f M/sec\n", N / 1e6 / (timer() - start));
															#line 850 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(expectActorCount(0));
															#line 6457 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			{
															#line 858 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				start = timer();
															#line 859 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				for(int i = 0;i < N;i++) {
															#line 860 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					Future<Void> f = oneWaitActor(already);
															#line 861 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					ASSERT(f.isReady());
															#line 6467 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
				}
															#line 863 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				printf("oneWaitActor(already): %0.1f M/sec\n", N / 1e6 / (timer() - start));
															#line 6471 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			}
			{
															#line 867 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				start = timer();
															#line 868 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				for(int i = 0;i < N;i++) {
															#line 869 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					Future<Void> f = oneWaitActor(never);
															#line 870 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					ASSERT(!f.isReady());
															#line 6482 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
				}
															#line 872 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				printf("(cancelled) oneWaitActor(never): %0.1f M/sec\n", N / 1e6 / (timer() - start));
															#line 873 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				ASSERT(expectActorCount(0));
															#line 6488 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			}
			{
															#line 877 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				start = timer();
															#line 878 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				for(int i = 0;i < N;i++) {
															#line 879 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					Promise<Void> p;
															#line 880 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					Future<Void> f = oneWaitActor(p.getFuture());
															#line 881 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					p.send(Void());
															#line 882 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					ASSERT(f.isReady());
															#line 6503 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
				}
															#line 884 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				printf("oneWaitActor(after): %0.1f M/sec\n", N / 1e6 / (timer() - start));
															#line 6507 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			}
			{
															#line 888 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				std::vector<Promise<Void>> pipe(N);
															#line 889 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				std::vector<Future<Void>> out(N);
															#line 890 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				start = timer();
															#line 891 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				for(int i = 0;i < N;i++) {
															#line 892 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					out[i] = oneWaitActor(pipe[i].getFuture());
															#line 6520 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
				}
															#line 894 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				for(int i = 0;i < N;i++) {
															#line 895 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					pipe[i].send(Void());
															#line 896 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					ASSERT(out[i].isReady());
															#line 6528 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
				}
															#line 898 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				printf("oneWaitActor(fifo): %0.1f M/sec\n", N / 1e6 / (timer() - start));
															#line 6532 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			}
			{
															#line 902 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				std::vector<Promise<Void>> pipe(N);
															#line 903 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				std::vector<Future<Void>> out(N);
															#line 904 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				start = timer();
															#line 905 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				for(int i = 0;i < N;i++) {
															#line 906 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					out[i] = oneWaitActor(pipe[i].getFuture());
															#line 6545 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
				}
															#line 908 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				for(int i = N - 1;i >= 0;i--) {
															#line 909 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					pipe[i].send(Void());
															#line 910 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					ASSERT(out[i].isReady());
															#line 6553 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
				}
															#line 912 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				printf("oneWaitActor(lifo): %0.1f M/sec\n", N / 1e6 / (timer() - start));
															#line 6557 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			}
			{
															#line 916 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				start = timer();
															#line 917 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				for(int i = 0;i < N;i++) {
															#line 918 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					Future<Void> f = chooseTwoActor(already, already);
															#line 919 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					ASSERT(f.isReady());
															#line 6568 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
				}
															#line 921 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				printf("chooseTwoActor(already, already): %0.1f M/sec\n", N / 1e6 / (timer() - start));
															#line 6572 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			}
			{
															#line 925 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				start = timer();
															#line 926 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				for(int i = 0;i < N;i++) {
															#line 927 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					Future<Void> f = chooseTwoActor(already, never);
															#line 928 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					ASSERT(f.isReady());
															#line 6583 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
				}
															#line 930 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				printf("chooseTwoActor(already, never): %0.1f M/sec\n", N / 1e6 / (timer() - start));
															#line 6587 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			}
			{
															#line 934 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				start = timer();
															#line 935 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				for(int i = 0;i < N;i++) {
															#line 936 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					Future<Void> f = chooseTwoActor(never, already);
															#line 937 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					ASSERT(f.isReady());
															#line 6598 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
				}
															#line 939 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				printf("chooseTwoActor(never, already): %0.1f M/sec\n", N / 1e6 / (timer() - start));
															#line 6602 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			}
			{
															#line 943 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				start = timer();
															#line 944 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				for(int i = 0;i < N;i++) {
															#line 945 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					Future<Void> f = chooseTwoActor(never, never);
															#line 946 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					ASSERT(!f.isReady());
															#line 6613 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
				}
															#line 949 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				printf("(cancelled) chooseTwoActor(never, never): %0.1f M/sec\n", N / 1e6 / (timer() - start));
															#line 6617 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			}
			{
															#line 953 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				start = timer();
															#line 954 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				for(int i = 0;i < N;i++) {
															#line 955 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					Promise<Void> p;
															#line 956 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					Future<Void> f = chooseTwoActor(p.getFuture(), never);
															#line 957 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					p.send(Void());
															#line 958 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					ASSERT(f.isReady());
															#line 6632 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
				}
															#line 960 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				printf("chooseTwoActor(after, never): %0.1f M/sec\n", N / 1e6 / (timer() - start));
															#line 6636 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			}
			{
															#line 964 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				std::vector<Promise<Void>> pipe(N);
															#line 965 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				std::vector<Future<Void>> out(N);
															#line 966 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				start = timer();
															#line 967 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				for(int i = 0;i < N;i++) {
															#line 968 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					out[i] = chooseTwoActor(pipe[i].getFuture(), never);
															#line 6649 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
				}
															#line 970 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				for(int i = 0;i < N;i++) {
															#line 971 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					pipe[i].send(Void());
															#line 972 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					ASSERT(out[i].isReady());
															#line 6657 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
				}
															#line 974 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				printf("chooseTwoActor(fifo, never): %0.1f M/sec\n", N / 1e6 / (timer() - start));
															#line 6661 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			}
			{
															#line 978 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				std::vector<Promise<Void>> pipe(N);
															#line 979 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				std::vector<Future<Void>> out(N);
															#line 980 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				start = timer();
															#line 981 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				for(int i = 0;i < N;i++) {
															#line 982 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					out[i] = chooseTwoActor(pipe[i].getFuture(), pipe[i].getFuture());
															#line 6674 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
				}
															#line 984 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				for(int i = 0;i < N;i++) {
															#line 985 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					pipe[i].send(Void());
															#line 986 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					ASSERT(out[i].isReady());
															#line 6682 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
				}
															#line 988 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				printf("chooseTwoActor(fifo, fifo): %0.1f M/sec\n", N / 1e6 / (timer() - start));
															#line 6686 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			}
			{
															#line 992 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				std::vector<Promise<Void>> pipe(N);
															#line 993 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				std::vector<Future<Void>> out(N);
															#line 994 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				start = timer();
															#line 995 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				for(int i = 0;i < N;i++) {
															#line 996 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					out[i] = chooseTwoActor(chooseTwoActor(pipe[i].getFuture(), never), never);
															#line 6699 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
				}
															#line 998 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				for(int i = 0;i < N;i++) {
															#line 999 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					pipe[i].send(Void());
															#line 1000 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					ASSERT(out[i].isReady());
															#line 6707 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
				}
															#line 1002 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				printf("chooseTwoActor^2((fifo, never), never): %0.1f M/sec\n", N / 1e6 / (timer() - start));
															#line 6711 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			}
			{
															#line 1006 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				start = timer();
															#line 1007 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				for(int i = 0;i < N;i++) {
															#line 1008 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					Promise<Void> p;
															#line 1009 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					Future<Void> f = oneWaitActor(chooseTwoActor(p.getFuture(), never));
															#line 1010 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					p.send(Void());
															#line 1011 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					ASSERT(f.isReady());
															#line 6726 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
				}
															#line 1013 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				printf("oneWaitActor(chooseTwoActor(after, never)): %0.1f M/sec\n", N / 1e6 / (timer() - start));
															#line 6730 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			}
			{
															#line 1017 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				std::vector<Promise<Void>> pipe(N);
															#line 1018 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				std::vector<Future<Void>> out(N);
															#line 1019 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				start = timer();
															#line 1020 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				for(int i = 0;i < N;i++) {
															#line 1021 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					out[i] = oneWaitActor(chooseTwoActor(pipe[i].getFuture(), never));
															#line 6743 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
				}
															#line 1023 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				for(int i = 0;i < N;i++) {
															#line 1024 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					pipe[i].send(Void());
															#line 1025 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					ASSERT(out[i].isReady());
															#line 6751 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
				}
															#line 1027 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				printf("oneWaitActor(chooseTwoActor(fifo, never)): %0.1f M/sec\n", N / 1e6 / (timer() - start));
															#line 6755 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			}
			{
															#line 1031 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				start = timer();
															#line 1032 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				for(int i = 0;i < N;i++) {
															#line 1033 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					Promise<Void> p;
															#line 1034 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					Future<Void> f = chooseTwoActor(p.getFuture(), never);
															#line 1035 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					Future<Void> a = oneWaitActor(f);
															#line 1036 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					Future<Void> b = oneWaitActor(f);
															#line 1037 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					p.send(Void());
															#line 1038 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					ASSERT(f.isReady());
															#line 6774 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
				}
															#line 1040 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				printf("2xoneWaitActor(chooseTwoActor(after, never)): %0.2f M/sec\n", N / 1e6 / (timer() - start));
															#line 6778 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			}
			{
															#line 1044 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				std::vector<Promise<Void>> pipe(N);
															#line 1045 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				std::vector<Future<Void>> out1(N);
															#line 1046 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				std::vector<Future<Void>> out2(N);
															#line 1047 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				start = timer();
															#line 1048 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				for(int i = 0;i < N;i++) {
															#line 1049 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					Future<Void> f = chooseTwoActor(pipe[i].getFuture(), never);
															#line 1050 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					out1[i] = oneWaitActor(f);
															#line 1051 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					out2[i] = oneWaitActor(f);
															#line 6797 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
				}
															#line 1053 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				for(int i = 0;i < N;i++) {
															#line 1054 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					pipe[i].send(Void());
															#line 1055 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					ASSERT(out2[i].isReady());
															#line 6805 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
				}
															#line 1057 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				printf("2xoneWaitActor(chooseTwoActor(fifo, never)): %0.2f M/sec\n", N / 1e6 / (timer() - start));
															#line 6809 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			}
			{
															#line 1061 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				std::vector<Promise<Void>> pipe(N);
															#line 1062 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				std::vector<Future<Void>> out1(N);
															#line 1063 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				std::vector<Future<Void>> out2(N);
															#line 1064 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				start = timer();
															#line 1065 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				for(int i = 0;i < N;i++) {
															#line 1066 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					Future<Void> f = chooseTwoActor(oneWaitActor(pipe[i].getFuture()), never);
															#line 1067 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					out1[i] = oneWaitActor(f);
															#line 1068 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					out2[i] = oneWaitActor(f);
															#line 6828 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
				}
															#line 1070 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				for(int i = 0;i < N;i++) {
															#line 1071 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					pipe[i].send(Void());
															#line 1072 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					ASSERT(out2[i].isReady());
															#line 6836 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
				}
															#line 1074 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				printf("2xoneWaitActor(chooseTwoActor(oneWaitActor(fifo), never)): %0.2f M/sec\n", N / 1e6 / (timer() - start));
															#line 6840 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			}
			{
															#line 1078 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				std::vector<Promise<Void>> pipe(N);
															#line 1079 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				std::vector<Future<Void>> out1(N);
															#line 1080 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				std::vector<Future<Void>> out2(N);
															#line 1081 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				start = timer();
															#line 1082 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				for(int i = 0;i < N;i++) {
															#line 1083 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					g_cheese = pipe[i].getFuture();
															#line 1084 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					Future<Void> f = chooseTwoActor(cheeseWaitActor(), never);
															#line 1085 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					g_cheese = f;
															#line 1086 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					out1[i] = cheeseWaitActor();
															#line 1087 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					out2[i] = cheeseWaitActor();
															#line 6863 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
				}
															#line 1089 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				for(int i = 0;i < N;i++) {
															#line 1090 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					pipe[i].send(Void());
															#line 1091 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					ASSERT(out2[i].isReady());
															#line 6871 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
				}
															#line 1093 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				printf("2xcheeseActor(chooseTwoActor(cheeseActor(fifo), never)): %0.2f M/sec\n", N / 1e6 / (timer() - start));
															#line 1094 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				printf("sizeof(CheeseWaitActorActor) == %zu\n", cheeseWaitActorSize());
															#line 6877 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			}
			{
															#line 1098 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				PromiseStream<int> data;
															#line 1099 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				start = timer();
															#line 1100 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				Future<int> sum = sumActor(data.getFuture());
															#line 1101 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				for(int i = 0;i < N;i++) {
															#line 1102 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					data.send(1);
															#line 6890 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
				}
															#line 1103 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				data.sendError(end_of_stream());
															#line 1104 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				ASSERT(sum.get() == N);
															#line 1105 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				printf("sumActor: %0.2f M/sec\n", N / 1e6 / (timer() - start));
															#line 6898 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			}
			{
															#line 1109 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				start = timer();
															#line 1110 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				std::vector<Promise<Void>> ps(3);
															#line 1111 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				std::vector<Future<Void>> fs(3);
															#line 1113 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				for(int i = 0;i < N;i++) {
															#line 1114 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					ps.clear();
															#line 1115 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					ps.resize(3);
															#line 1116 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					for(int j = 0;j < ps.size();j++) {
															#line 1117 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
						fs[j] = ps[j].getFuture();
															#line 6917 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
					}
															#line 1119 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					Future<Void> q = quorum(fs, 2);
															#line 1120 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					for( auto& p : ps ) {
															#line 1121 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
						p.send(Void());
															#line 6925 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
					}
				}
															#line 1123 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				printf("quorum(2/3): %0.2f M/sec\n", N / 1e6 / (timer() - start));
															#line 6930 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			}
															#line 1126 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (!static_cast<FlowTestCase820Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase820ActorState(); static_cast<FlowTestCase820Actor*>(this)->destroy(); return 0; }
															#line 6934 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			new (&static_cast<FlowTestCase820Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase820ActorState();
			static_cast<FlowTestCase820Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase820ActorState();
		static_cast<FlowTestCase820Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 820 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	UnitTestParameters params;
															#line 6958 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
};
// This generated class is to be used only via flowTestCase820()
															#line 820 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase820Actor final : public Actor<Void>, public FastAllocated<FlowTestCase820Actor>, public FlowTestCase820ActorState<FlowTestCase820Actor> {
															#line 6963 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
	using FastAllocated<FlowTestCase820Actor>::operator new;
	using FastAllocated<FlowTestCase820Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(18255258780374115328UL, 18399311919202711552UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 820 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase820Actor(UnitTestParameters const& params) 
															#line 6979 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   FlowTestCase820ActorState<FlowTestCase820Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase820", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17391047783114961920UL, 3985622366939195904UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase820Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase820");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase820", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 820 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> flowTestCase820( UnitTestParameters const& params ) {
															#line 820 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new FlowTestCase820Actor(params));
															#line 7011 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
}
ACTOR_TEST_CASE(flowTestCase820, "#flow/flow/perf/actor patterns")

#line 1128 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

template <class YAM>
struct YAMRandom {
	YAM yam;
	std::vector<Future<Void>> onchanges;
	int kmax;

	YAMRandom() : kmax(3) {}

	void randomOp() {
		if (deterministicRandom()->random01() < 0.01)
			while (!check_yield())
				;

		int k = deterministicRandom()->randomInt(0, kmax);
		int op = deterministicRandom()->randomInt(0, 7);
		// printf("%d",op);
		if (op == 0) {
			onchanges.push_back(yam.onChange(k));
		} else if (op == 1) {
			onchanges.push_back(trigger([this]() { this->randomOp(); }, yam.onChange(k)));
		} else if (op == 2) {
			if (onchanges.size()) {
				int i = deterministicRandom()->randomInt(0, onchanges.size());
				onchanges[i] = onchanges.back();
				onchanges.pop_back();
			}
		} else if (op == 3) {
			onchanges.clear();
		} else if (op == 4) {
			int v = deterministicRandom()->randomInt(0, 3);
			yam.set(k, v);
		} else if (op == 5) {
			yam.trigger(k);
		} else if (op == 6) {
			int a = deterministicRandom()->randomInt(0, kmax);
			int b = deterministicRandom()->randomInt(0, kmax);
			yam.triggerRange(std::min(a, b), std::max(a, b) + 1);
		}
	}
};

															#line 7058 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via flowTestCase1170()
															#line 1170 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class FlowTestCase1170Actor>
															#line 1170 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase1170ActorState {
															#line 7065 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
															#line 1170 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase1170ActorState(UnitTestParameters const& params) 
															#line 1170 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 1170 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : params(params),
															#line 1171 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		   yamr(),
															#line 1172 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		   it()
															#line 7076 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("flowTestCase1170", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase1170ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase1170", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1173 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			it = 0;
															#line 7091 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase1170ActorState();
		static_cast<FlowTestCase1170Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1177 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<FlowTestCase1170Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase1170ActorState(); static_cast<FlowTestCase1170Actor*>(this)->destroy(); return 0; }
															#line 7114 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		new (&static_cast<FlowTestCase1170Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase1170ActorState();
		static_cast<FlowTestCase1170Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1173 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!(it < 100000))
															#line 7133 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1174 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		yamr.randomOp();
															#line 1175 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		StrictFuture<Void> __when_expr_0 = yield();
															#line 1175 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (static_cast<FlowTestCase1170Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7143 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<FlowTestCase1170Actor*>(this)->actor_wait_state = 1;
															#line 1175 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase1170Actor, 0, Void >*>(static_cast<FlowTestCase1170Actor*>(this)));
															#line 7148 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 1173 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		it++;
															#line 7170 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 1173 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		it++;
															#line 7179 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase1170Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase1170Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase1170Actor*>(this)->ActorCallback< FlowTestCase1170Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase1170Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase1170", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1170Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1170", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase1170Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase1170", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1170Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1170", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase1170Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase1170", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1170Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1170", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1170 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	UnitTestParameters params;
															#line 1171 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	YAMRandom<YieldedAsyncMap<int, int>> yamr;
															#line 1172 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	int it;
															#line 7265 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
};
// This generated class is to be used only via flowTestCase1170()
															#line 1170 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase1170Actor final : public Actor<Void>, public ActorCallback< FlowTestCase1170Actor, 0, Void >, public FastAllocated<FlowTestCase1170Actor>, public FlowTestCase1170ActorState<FlowTestCase1170Actor> {
															#line 7270 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
	using FastAllocated<FlowTestCase1170Actor>::operator new;
	using FastAllocated<FlowTestCase1170Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14949500988301062400UL, 565671913875302144UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase1170Actor, 0, Void >;
															#line 1170 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase1170Actor(UnitTestParameters const& params) 
															#line 7287 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   FlowTestCase1170ActorState<FlowTestCase1170Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase1170", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11181093503553763328UL, 7636669660623487232UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1170Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase1170");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase1170", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase1170Actor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1170 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> flowTestCase1170( UnitTestParameters const& params ) {
															#line 1170 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new FlowTestCase1170Actor(params));
															#line 7320 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
}
ACTOR_TEST_CASE(flowTestCase1170, "/flow/flow/YieldedAsyncMap/randomized")

#line 1179 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 7326 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via flowTestCase1180()
															#line 1180 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class FlowTestCase1180Actor>
															#line 1180 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase1180ActorState {
															#line 7333 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
															#line 1180 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase1180ActorState(UnitTestParameters const& params) 
															#line 1180 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 1180 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : params(params),
															#line 1181 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		   yamr(),
															#line 1182 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		   it()
															#line 7344 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("flowTestCase1180", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase1180ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase1180", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1183 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			it = 0;
															#line 7359 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase1180ActorState();
		static_cast<FlowTestCase1180Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1187 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<FlowTestCase1180Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase1180ActorState(); static_cast<FlowTestCase1180Actor*>(this)->destroy(); return 0; }
															#line 7382 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		new (&static_cast<FlowTestCase1180Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase1180ActorState();
		static_cast<FlowTestCase1180Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1183 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!(it < 100000))
															#line 7401 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1184 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		yamr.randomOp();
															#line 1185 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		StrictFuture<Void> __when_expr_0 = yield();
															#line 1185 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (static_cast<FlowTestCase1180Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7411 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<FlowTestCase1180Actor*>(this)->actor_wait_state = 1;
															#line 1185 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase1180Actor, 0, Void >*>(static_cast<FlowTestCase1180Actor*>(this)));
															#line 7416 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 1183 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		it++;
															#line 7438 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 1183 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		it++;
															#line 7447 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase1180Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase1180Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase1180Actor*>(this)->ActorCallback< FlowTestCase1180Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase1180Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase1180", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1180Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1180", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase1180Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase1180", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1180Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1180", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase1180Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase1180", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1180Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1180", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1180 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	UnitTestParameters params;
															#line 1181 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	YAMRandom<AsyncMap<int, int>> yamr;
															#line 1182 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	int it;
															#line 7533 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
};
// This generated class is to be used only via flowTestCase1180()
															#line 1180 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase1180Actor final : public Actor<Void>, public ActorCallback< FlowTestCase1180Actor, 0, Void >, public FastAllocated<FlowTestCase1180Actor>, public FlowTestCase1180ActorState<FlowTestCase1180Actor> {
															#line 7538 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
	using FastAllocated<FlowTestCase1180Actor>::operator new;
	using FastAllocated<FlowTestCase1180Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13104176612199646720UL, 5010644635950964224UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase1180Actor, 0, Void >;
															#line 1180 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase1180Actor(UnitTestParameters const& params) 
															#line 7555 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   FlowTestCase1180ActorState<FlowTestCase1180Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase1180", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5432906869568849664UL, 16258607181652212736UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1180Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase1180");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase1180", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase1180Actor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1180 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> flowTestCase1180( UnitTestParameters const& params ) {
															#line 1180 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new FlowTestCase1180Actor(params));
															#line 7588 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
}
ACTOR_TEST_CASE(flowTestCase1180, "/flow/flow/AsyncMap/randomized")

#line 1189 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 7594 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via flowTestCase1190()
															#line 1190 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class FlowTestCase1190Actor>
															#line 1190 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase1190ActorState {
															#line 7601 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
															#line 1190 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase1190ActorState(UnitTestParameters const& params) 
															#line 1190 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 1190 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : params(params),
															#line 1191 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		   yam(),
															#line 1192 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		   y0(yam.onChange(1))
															#line 7612 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("flowTestCase1190", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase1190ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase1190", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1193 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			yam.setUnconditional(1, 0);
															#line 1194 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			y1 = yam.onChange(1);
															#line 1195 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			y1a = yam.onChange(1);
															#line 1196 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			y1b = yam.onChange(1);
															#line 1197 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			yam.set(1, 1);
															#line 1201 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			y2 = yam.onChange(1);
															#line 1202 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = reportErrors(y0, "Y0");
															#line 1202 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (static_cast<FlowTestCase1190Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7641 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase1190Actor*>(this)->actor_wait_state = 1;
															#line 1202 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase1190Actor, 0, Void >*>(static_cast<FlowTestCase1190Actor*>(this)));
															#line 7646 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase1190ActorState();
		static_cast<FlowTestCase1190Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1203 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		StrictFuture<Void> __when_expr_1 = reportErrors(y1, "Y1");
															#line 1203 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (static_cast<FlowTestCase1190Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7671 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<FlowTestCase1190Actor*>(this)->actor_wait_state = 2;
															#line 1203 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase1190Actor, 1, Void >*>(static_cast<FlowTestCase1190Actor*>(this)));
															#line 7676 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1203 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		StrictFuture<Void> __when_expr_1 = reportErrors(y1, "Y1");
															#line 1203 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (static_cast<FlowTestCase1190Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7687 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<FlowTestCase1190Actor*>(this)->actor_wait_state = 2;
															#line 1203 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase1190Actor, 1, Void >*>(static_cast<FlowTestCase1190Actor*>(this)));
															#line 7692 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase1190Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase1190Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase1190Actor*>(this)->ActorCallback< FlowTestCase1190Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase1190Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase1190", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1190Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1190", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase1190Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase1190", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1190Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1190", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase1190Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase1190", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1190Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1190", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 1204 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		StrictFuture<Void> __when_expr_2 = reportErrors(y1a, "Y1a");
															#line 1204 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (static_cast<FlowTestCase1190Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7778 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<FlowTestCase1190Actor*>(this)->actor_wait_state = 3;
															#line 1204 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase1190Actor, 2, Void >*>(static_cast<FlowTestCase1190Actor*>(this)));
															#line 7783 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 1204 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		StrictFuture<Void> __when_expr_2 = reportErrors(y1a, "Y1a");
															#line 1204 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (static_cast<FlowTestCase1190Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7794 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<FlowTestCase1190Actor*>(this)->actor_wait_state = 3;
															#line 1204 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase1190Actor, 2, Void >*>(static_cast<FlowTestCase1190Actor*>(this)));
															#line 7799 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<FlowTestCase1190Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase1190Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase1190Actor*>(this)->ActorCallback< FlowTestCase1190Actor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase1190Actor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase1190", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1190Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1190", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FlowTestCase1190Actor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase1190", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1190Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1190", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FlowTestCase1190Actor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase1190", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1190Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1190", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 1205 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		StrictFuture<Void> __when_expr_3 = reportErrors(y1b, "Y1b");
															#line 1205 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (static_cast<FlowTestCase1190Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7885 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<FlowTestCase1190Actor*>(this)->actor_wait_state = 4;
															#line 1205 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase1190Actor, 3, Void >*>(static_cast<FlowTestCase1190Actor*>(this)));
															#line 7890 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 1205 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		StrictFuture<Void> __when_expr_3 = reportErrors(y1b, "Y1b");
															#line 1205 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (static_cast<FlowTestCase1190Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7901 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<FlowTestCase1190Actor*>(this)->actor_wait_state = 4;
															#line 1205 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase1190Actor, 3, Void >*>(static_cast<FlowTestCase1190Actor*>(this)));
															#line 7906 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<FlowTestCase1190Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase1190Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase1190Actor*>(this)->ActorCallback< FlowTestCase1190Actor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase1190Actor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase1190", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1190Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1190", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< FlowTestCase1190Actor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase1190", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1190Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1190", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< FlowTestCase1190Actor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase1190", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1190Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1190", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 1206 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		StrictFuture<Void> __when_expr_4 = reportErrors(timeout(y2, 5, Void()), "Y2");
															#line 1206 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (static_cast<FlowTestCase1190Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7992 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<FlowTestCase1190Actor*>(this)->actor_wait_state = 5;
															#line 1206 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase1190Actor, 4, Void >*>(static_cast<FlowTestCase1190Actor*>(this)));
															#line 7997 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 1206 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		StrictFuture<Void> __when_expr_4 = reportErrors(timeout(y2, 5, Void()), "Y2");
															#line 1206 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (static_cast<FlowTestCase1190Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8008 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<FlowTestCase1190Actor*>(this)->actor_wait_state = 5;
															#line 1206 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase1190Actor, 4, Void >*>(static_cast<FlowTestCase1190Actor*>(this)));
															#line 8013 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<FlowTestCase1190Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase1190Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase1190Actor*>(this)->ActorCallback< FlowTestCase1190Actor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase1190Actor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase1190", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1190Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1190", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< FlowTestCase1190Actor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase1190", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1190Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1190", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< FlowTestCase1190Actor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase1190", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1190Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1190", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 1208 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<FlowTestCase1190Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase1190ActorState(); static_cast<FlowTestCase1190Actor*>(this)->destroy(); return 0; }
															#line 8097 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		new (&static_cast<FlowTestCase1190Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase1190ActorState();
		static_cast<FlowTestCase1190Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 1208 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<FlowTestCase1190Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase1190ActorState(); static_cast<FlowTestCase1190Actor*>(this)->destroy(); return 0; }
															#line 8109 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		new (&static_cast<FlowTestCase1190Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase1190ActorState();
		static_cast<FlowTestCase1190Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<FlowTestCase1190Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase1190Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase1190Actor*>(this)->ActorCallback< FlowTestCase1190Actor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase1190Actor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase1190", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1190Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1190", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< FlowTestCase1190Actor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase1190", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1190Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1190", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< FlowTestCase1190Actor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase1190", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1190Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1190", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 1190 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	UnitTestParameters params;
															#line 1191 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	YieldedAsyncMap<int, int> yam;
															#line 1192 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Future<Void> y0;
															#line 1194 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Future<Void> y1;
															#line 1195 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Future<Void> y1a;
															#line 1196 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Future<Void> y1b;
															#line 1201 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Future<Void> y2;
															#line 8206 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
};
// This generated class is to be used only via flowTestCase1190()
															#line 1190 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase1190Actor final : public Actor<Void>, public ActorCallback< FlowTestCase1190Actor, 0, Void >, public ActorCallback< FlowTestCase1190Actor, 1, Void >, public ActorCallback< FlowTestCase1190Actor, 2, Void >, public ActorCallback< FlowTestCase1190Actor, 3, Void >, public ActorCallback< FlowTestCase1190Actor, 4, Void >, public FastAllocated<FlowTestCase1190Actor>, public FlowTestCase1190ActorState<FlowTestCase1190Actor> {
															#line 8211 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
	using FastAllocated<FlowTestCase1190Actor>::operator new;
	using FastAllocated<FlowTestCase1190Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15200743049323581184UL, 2169647153677272832UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase1190Actor, 0, Void >;
friend struct ActorCallback< FlowTestCase1190Actor, 1, Void >;
friend struct ActorCallback< FlowTestCase1190Actor, 2, Void >;
friend struct ActorCallback< FlowTestCase1190Actor, 3, Void >;
friend struct ActorCallback< FlowTestCase1190Actor, 4, Void >;
															#line 1190 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase1190Actor(UnitTestParameters const& params) 
															#line 8232 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   FlowTestCase1190ActorState<FlowTestCase1190Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase1190", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10431557326609293312UL, 10727873985957581568UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1190Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase1190");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase1190", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase1190Actor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< FlowTestCase1190Actor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< FlowTestCase1190Actor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< FlowTestCase1190Actor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< FlowTestCase1190Actor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1190 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> flowTestCase1190( UnitTestParameters const& params ) {
															#line 1190 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new FlowTestCase1190Actor(params));
															#line 8269 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
}
ACTOR_TEST_CASE(flowTestCase1190, "/flow/flow/YieldedAsyncMap/basic")

#line 1210 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 8275 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via flowTestCase1211()
															#line 1211 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class FlowTestCase1211Actor>
															#line 1211 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase1211ActorState {
															#line 8282 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
															#line 1211 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase1211ActorState(UnitTestParameters const& params) 
															#line 1211 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 1211 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : params(params),
															#line 1212 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		   yam()
															#line 8291 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("flowTestCase1211", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase1211ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase1211", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1218 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(yam.count(1) == 0);
															#line 1219 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			y1 = yam.onChange(1);
															#line 1220 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			y1a = yam.onChange(1);
															#line 1221 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			y1b = yam.onChange(1);
															#line 1222 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(yam.count(1) == 1);
															#line 1223 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			y1.cancel();
															#line 1224 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(!y1a.isReady());
															#line 1225 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			y1a.cancel();
															#line 1226 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(!y1b.isReady());
															#line 1227 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(yam.count(1) == 1);
															#line 1228 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			y1b.cancel();
															#line 1229 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(y1b.getError().code() == error_code_actor_cancelled);
															#line 1230 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(yam.count(1) == 0);
															#line 1232 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (!static_cast<FlowTestCase1211Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase1211ActorState(); static_cast<FlowTestCase1211Actor*>(this)->destroy(); return 0; }
															#line 8332 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			new (&static_cast<FlowTestCase1211Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase1211ActorState();
			static_cast<FlowTestCase1211Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase1211ActorState();
		static_cast<FlowTestCase1211Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 1211 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	UnitTestParameters params;
															#line 1212 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	YieldedAsyncMap<int, int> yam;
															#line 1219 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Future<Void> y1;
															#line 1220 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Future<Void> y1a;
															#line 1221 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Future<Void> y1b;
															#line 8364 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
};
// This generated class is to be used only via flowTestCase1211()
															#line 1211 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase1211Actor final : public Actor<Void>, public FastAllocated<FlowTestCase1211Actor>, public FlowTestCase1211ActorState<FlowTestCase1211Actor> {
															#line 8369 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
	using FastAllocated<FlowTestCase1211Actor>::operator new;
	using FastAllocated<FlowTestCase1211Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10507803377198803712UL, 3206256003299714048UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 1211 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase1211Actor(UnitTestParameters const& params) 
															#line 8385 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   FlowTestCase1211ActorState<FlowTestCase1211Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase1211", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12944336285734600192UL, 18330418782061127680UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1211Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase1211");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase1211", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 1211 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> flowTestCase1211( UnitTestParameters const& params ) {
															#line 1211 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new FlowTestCase1211Actor(params));
															#line 8417 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
}
ACTOR_TEST_CASE(flowTestCase1211, "/flow/flow/YieldedAsyncMap/cancel")

#line 1234 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 8423 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via flowTestCase1235()
															#line 1235 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class FlowTestCase1235Actor>
															#line 1235 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase1235ActorState {
															#line 8430 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
															#line 1235 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase1235ActorState(UnitTestParameters const& params) 
															#line 1235 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 1235 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : params(params),
															#line 1236 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		   yam(),
															#line 1238 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		   y1(yam.onChange(1)),
															#line 1239 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		   y2(yam.onChange(2))
															#line 8443 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("flowTestCase1235", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase1235ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase1235", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1241 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			auto* pyam = &yam;
															#line 1242 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			uncancellable(trigger( [pyam]() { printf("Triggered\n"); pyam->triggerAll(); }, delay(1)));
															#line 1249 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = y1;
															#line 1249 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (static_cast<FlowTestCase1235Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8464 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase1235Actor*>(this)->actor_wait_state = 1;
															#line 1249 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase1235Actor, 0, Void >*>(static_cast<FlowTestCase1235Actor*>(this)));
															#line 8469 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase1235ActorState();
		static_cast<FlowTestCase1235Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1250 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		printf("Got y1\n");
															#line 1251 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		y2.cancel();
															#line 1253 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<FlowTestCase1235Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase1235ActorState(); static_cast<FlowTestCase1235Actor*>(this)->destroy(); return 0; }
															#line 8496 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		new (&static_cast<FlowTestCase1235Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase1235ActorState();
		static_cast<FlowTestCase1235Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1250 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		printf("Got y1\n");
															#line 1251 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		y2.cancel();
															#line 1253 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<FlowTestCase1235Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase1235ActorState(); static_cast<FlowTestCase1235Actor*>(this)->destroy(); return 0; }
															#line 8512 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		new (&static_cast<FlowTestCase1235Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase1235ActorState();
		static_cast<FlowTestCase1235Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase1235Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase1235Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase1235Actor*>(this)->ActorCallback< FlowTestCase1235Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase1235Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase1235", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1235Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1235", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase1235Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase1235", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1235Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1235", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase1235Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase1235", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1235Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1235", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1235 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	UnitTestParameters params;
															#line 1236 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	YieldedAsyncMap<int, int> yam;
															#line 1238 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Future<Void> y1;
															#line 1239 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Future<Void> y2;
															#line 8603 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
};
// This generated class is to be used only via flowTestCase1235()
															#line 1235 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase1235Actor final : public Actor<Void>, public ActorCallback< FlowTestCase1235Actor, 0, Void >, public FastAllocated<FlowTestCase1235Actor>, public FlowTestCase1235ActorState<FlowTestCase1235Actor> {
															#line 8608 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
	using FastAllocated<FlowTestCase1235Actor>::operator new;
	using FastAllocated<FlowTestCase1235Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3303876202418115584UL, 5228965630935848704UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase1235Actor, 0, Void >;
															#line 1235 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase1235Actor(UnitTestParameters const& params) 
															#line 8625 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   FlowTestCase1235ActorState<FlowTestCase1235Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase1235", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12740957675032122880UL, 3312658083682497024UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1235Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase1235");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase1235", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase1235Actor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1235 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> flowTestCase1235( UnitTestParameters const& params ) {
															#line 1235 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new FlowTestCase1235Actor(params));
															#line 8658 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
}
ACTOR_TEST_CASE(flowTestCase1235, "/flow/flow/YieldedAsyncMap/cancel2")

#line 1255 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 8664 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via flowTestCase1256()
															#line 1256 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class FlowTestCase1256Actor>
															#line 1256 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase1256ActorState {
															#line 8671 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
															#line 1256 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase1256ActorState(UnitTestParameters const& params) 
															#line 1256 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 1256 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : params(params)
															#line 8678 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("flowTestCase1256", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase1256ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase1256", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1257 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			AsyncVar<int> av;
															#line 1258 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			Future<Void> ch = av.onChange();
															#line 1259 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(!ch.isReady());
															#line 1260 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			av.set(5);
															#line 1261 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(ch.isReady());
															#line 1262 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(av.get() == 5);
															#line 1264 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ch = av.onChange();
															#line 1265 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(!ch.isReady());
															#line 1266 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			av.set(6);
															#line 1267 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(ch.isReady());
															#line 1268 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(av.get() == 6);
															#line 1270 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (!static_cast<FlowTestCase1256Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase1256ActorState(); static_cast<FlowTestCase1256Actor*>(this)->destroy(); return 0; }
															#line 8715 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			new (&static_cast<FlowTestCase1256Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase1256ActorState();
			static_cast<FlowTestCase1256Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase1256ActorState();
		static_cast<FlowTestCase1256Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 1256 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	UnitTestParameters params;
															#line 8739 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
};
// This generated class is to be used only via flowTestCase1256()
															#line 1256 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase1256Actor final : public Actor<Void>, public FastAllocated<FlowTestCase1256Actor>, public FlowTestCase1256ActorState<FlowTestCase1256Actor> {
															#line 8744 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
	using FastAllocated<FlowTestCase1256Actor>::operator new;
	using FastAllocated<FlowTestCase1256Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(18133073730236627456UL, 15342177636272682240UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 1256 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase1256Actor(UnitTestParameters const& params) 
															#line 8760 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   FlowTestCase1256ActorState<FlowTestCase1256Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase1256", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3355718402559874048UL, 13203533607707371264UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1256Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase1256");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase1256", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 1256 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> flowTestCase1256( UnitTestParameters const& params ) {
															#line 1256 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new FlowTestCase1256Actor(params));
															#line 8792 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
}
ACTOR_TEST_CASE(flowTestCase1256, "/flow/flow/AsyncVar/basic")

#line 1272 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 8798 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via waitAfterCancel()
															#line 1273 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class WaitAfterCancelActor>
															#line 1273 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class WaitAfterCancelActorState {
															#line 8805 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
															#line 1273 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	WaitAfterCancelActorState(int* const& output) 
															#line 1273 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 1273 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : output(output)
															#line 8812 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("waitAfterCancel", reinterpret_cast<unsigned long>(this));

	}
	~WaitAfterCancelActorState() 
	{
		fdb_probe_actor_destroy("waitAfterCancel", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1274 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			*output = 0;
															#line 8827 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			try {
															#line 1276 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				StrictFuture<Void> __when_expr_0 = Never();
															#line 1276 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				if (static_cast<WaitAfterCancelActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 8833 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<WaitAfterCancelActor*>(this)->actor_wait_state = 1;
															#line 1276 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WaitAfterCancelActor, 0, Void >*>(static_cast<WaitAfterCancelActor*>(this)));
															#line 8838 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WaitAfterCancelActorState();
		static_cast<WaitAfterCancelActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1280 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		ASSERT(false);
															#line 1281 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<WaitAfterCancelActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WaitAfterCancelActorState(); static_cast<WaitAfterCancelActor*>(this)->destroy(); return 0; }
															#line 8869 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		new (&static_cast<WaitAfterCancelActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WaitAfterCancelActorState();
		static_cast<WaitAfterCancelActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& __current_error,int loopDepth=0) 
	{
		try {
															#line 1278 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			StrictFuture<Void> __when_expr_1 = (*output = 1, Future<Void>(Void()));
															#line 1278 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (static_cast<WaitAfterCancelActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8884 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1Catch2when1(__when_expr_1.get(), loopDepth); };
			static_cast<WaitAfterCancelActor*>(this)->actor_wait_state = 2;
															#line 1278 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WaitAfterCancelActor, 1, Void >*>(static_cast<WaitAfterCancelActor*>(this)));
															#line 8889 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WaitAfterCancelActor*>(this)->actor_wait_state > 0) static_cast<WaitAfterCancelActor*>(this)->actor_wait_state = 0;
		static_cast<WaitAfterCancelActor*>(this)->ActorCallback< WaitAfterCancelActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitAfterCancelActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitAfterCancel", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitAfterCancelActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitAfterCancel", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WaitAfterCancelActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitAfterCancel", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitAfterCancelActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitAfterCancel", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WaitAfterCancelActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitAfterCancel", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitAfterCancelActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitAfterCancel", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch2cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1Catch2cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1Catch2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1Catch2cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1Catch2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1Catch2cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WaitAfterCancelActor*>(this)->actor_wait_state > 0) static_cast<WaitAfterCancelActor*>(this)->actor_wait_state = 0;
		static_cast<WaitAfterCancelActor*>(this)->ActorCallback< WaitAfterCancelActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitAfterCancelActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitAfterCancel", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitAfterCancelActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitAfterCancel", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WaitAfterCancelActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitAfterCancel", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitAfterCancelActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitAfterCancel", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WaitAfterCancelActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitAfterCancel", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitAfterCancelActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitAfterCancel", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1273 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	int* output;
															#line 9089 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
};
// This generated class is to be used only via waitAfterCancel()
															#line 1273 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class WaitAfterCancelActor final : public Actor<Void>, public ActorCallback< WaitAfterCancelActor, 0, Void >, public ActorCallback< WaitAfterCancelActor, 1, Void >, public FastAllocated<WaitAfterCancelActor>, public WaitAfterCancelActorState<WaitAfterCancelActor> {
															#line 9094 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
	using FastAllocated<WaitAfterCancelActor>::operator new;
	using FastAllocated<WaitAfterCancelActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9230328877031301120UL, 9312752954722162688UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WaitAfterCancelActor, 0, Void >;
friend struct ActorCallback< WaitAfterCancelActor, 1, Void >;
															#line 1273 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	WaitAfterCancelActor(int* const& output) 
															#line 9112 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   WaitAfterCancelActorState<WaitAfterCancelActor>(output),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("waitAfterCancel", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8552318013271824384UL, 8060922132594515456UL);
		ActorExecutionContextHelper __helper(static_cast<WaitAfterCancelActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("waitAfterCancel");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("waitAfterCancel", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WaitAfterCancelActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WaitAfterCancelActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1273 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> waitAfterCancel( int* const& output ) {
															#line 1273 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new WaitAfterCancelActor(output));
															#line 9146 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
}

#line 1283 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 9151 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via flowTestCase1284()
															#line 1284 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class FlowTestCase1284Actor>
															#line 1284 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase1284ActorState {
															#line 9158 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
															#line 1284 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase1284ActorState(UnitTestParameters const& params) 
															#line 1284 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 1284 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : params(params)
															#line 9165 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("flowTestCase1284", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase1284ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase1284", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1285 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			int a = -1;
															#line 1286 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			Future<Void> f = waitAfterCancel(&a);
															#line 1287 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(a == 0);
															#line 1288 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			f.cancel();
															#line 1289 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(a == 1);
															#line 1290 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (!static_cast<FlowTestCase1284Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase1284ActorState(); static_cast<FlowTestCase1284Actor*>(this)->destroy(); return 0; }
															#line 9190 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			new (&static_cast<FlowTestCase1284Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase1284ActorState();
			static_cast<FlowTestCase1284Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase1284ActorState();
		static_cast<FlowTestCase1284Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 1284 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	UnitTestParameters params;
															#line 9214 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
};
// This generated class is to be used only via flowTestCase1284()
															#line 1284 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase1284Actor final : public Actor<Void>, public FastAllocated<FlowTestCase1284Actor>, public FlowTestCase1284ActorState<FlowTestCase1284Actor> {
															#line 9219 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
	using FastAllocated<FlowTestCase1284Actor>::operator new;
	using FastAllocated<FlowTestCase1284Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9567594612272465920UL, 1938410967438245888UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 1284 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase1284Actor(UnitTestParameters const& params) 
															#line 9235 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   FlowTestCase1284ActorState<FlowTestCase1284Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase1284", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10077708507740350720UL, 2132954299899708672UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1284Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase1284");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase1284", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 1284 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> flowTestCase1284( UnitTestParameters const& params ) {
															#line 1284 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new FlowTestCase1284Actor(params));
															#line 9267 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
}
ACTOR_TEST_CASE(flowTestCase1284, "/fdbrpc/flow/wait_expression_after_cancel_flow")

#line 1292 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

// Tests for https://github.com/apple/foundationdb/issues/1226

template <class>
struct ShouldNotGoIntoClassContextStack;

class Foo1 {
public:
	explicit Foo1(int x) : x(x) {}
	Future<int> foo() { return fooActor(this); }
																#line 9282 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
static Future<int> fooActor( Foo1* const& self );
template <class> friend class Foo1_FooActorActorState;

#line 1303 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

private:
	int x;
};
															#line 9291 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
// This generated class is to be used only via fooActor()
															#line 1307 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class Foo1_FooActorActor>
															#line 1307 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class Foo1_FooActorActorState {
															#line 9297 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
															#line 1307 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Foo1_FooActorActorState(Foo1* const& self) 
															#line 1307 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 1307 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : self(self)
															#line 9304 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("fooActor", reinterpret_cast<unsigned long>(this));

	}
	~Foo1_FooActorActorState() 
	{
		fdb_probe_actor_destroy("fooActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1308 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = Future<Void>();
															#line 1308 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (static_cast<Foo1_FooActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9321 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<Foo1_FooActorActor*>(this)->actor_wait_state = 1;
															#line 1308 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< Foo1_FooActorActor, 0, Void >*>(static_cast<Foo1_FooActorActor*>(this)));
															#line 9326 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~Foo1_FooActorActorState();
		static_cast<Foo1_FooActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1309 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<Foo1_FooActorActor*>(this)->SAV<int>::futures) { (void)(self->x); this->~Foo1_FooActorActorState(); static_cast<Foo1_FooActorActor*>(this)->destroy(); return 0; }
															#line 9349 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		new (&static_cast<Foo1_FooActorActor*>(this)->SAV< int >::value()) int(self->x);
		this->~Foo1_FooActorActorState();
		static_cast<Foo1_FooActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1309 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<Foo1_FooActorActor*>(this)->SAV<int>::futures) { (void)(self->x); this->~Foo1_FooActorActorState(); static_cast<Foo1_FooActorActor*>(this)->destroy(); return 0; }
															#line 9361 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		new (&static_cast<Foo1_FooActorActor*>(this)->SAV< int >::value()) int(self->x);
		this->~Foo1_FooActorActorState();
		static_cast<Foo1_FooActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<Foo1_FooActorActor*>(this)->actor_wait_state > 0) static_cast<Foo1_FooActorActor*>(this)->actor_wait_state = 0;
		static_cast<Foo1_FooActorActor*>(this)->ActorCallback< Foo1_FooActorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< Foo1_FooActorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fooActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Foo1_FooActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fooActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< Foo1_FooActorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fooActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Foo1_FooActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fooActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< Foo1_FooActorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fooActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<Foo1_FooActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fooActor", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1307 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Foo1* self;
															#line 9446 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
};
// This generated class is to be used only via fooActor()
															#line 1307 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class Foo1_FooActorActor final : public Actor<int>, public ActorCallback< Foo1_FooActorActor, 0, Void >, public FastAllocated<Foo1_FooActorActor>, public Foo1_FooActorActorState<Foo1_FooActorActor> {
															#line 9451 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
	using FastAllocated<Foo1_FooActorActor>::operator new;
	using FastAllocated<Foo1_FooActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16336398880794180352UL, 10118862442187344896UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<int>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< Foo1_FooActorActor, 0, Void >;
															#line 1307 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Foo1_FooActorActor(Foo1* const& self) 
															#line 9468 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		 : Actor<int>(),
		   Foo1_FooActorActorState<Foo1_FooActorActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("fooActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14379396290541012992UL, 3095081568235468032UL);
		ActorExecutionContextHelper __helper(static_cast<Foo1_FooActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("fooActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("fooActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< Foo1_FooActorActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1307 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
Future<int> Foo1::fooActor( Foo1* const& self ) {
															#line 1307 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<int>(new Foo1_FooActorActor(self));
															#line 9500 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
}

#line 1311 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

class [[nodiscard]] Foo2 {
public:
	explicit Foo2(int x) : x(x) {}
	Future<int> foo() { return fooActor(this); }
																#line 9509 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
static Future<int> fooActor( Foo2* const& self );
template <class> friend class Foo2_FooActorActorState;

#line 1317 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

private:
	int x;
};
															#line 9518 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
// This generated class is to be used only via fooActor()
															#line 1321 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class Foo2_FooActorActor>
															#line 1321 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class Foo2_FooActorActorState {
															#line 9524 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
															#line 1321 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Foo2_FooActorActorState(Foo2* const& self) 
															#line 1321 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 1321 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : self(self)
															#line 9531 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("fooActor", reinterpret_cast<unsigned long>(this));

	}
	~Foo2_FooActorActorState() 
	{
		fdb_probe_actor_destroy("fooActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1322 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = Future<Void>();
															#line 1322 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (static_cast<Foo2_FooActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9548 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<Foo2_FooActorActor*>(this)->actor_wait_state = 1;
															#line 1322 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< Foo2_FooActorActor, 0, Void >*>(static_cast<Foo2_FooActorActor*>(this)));
															#line 9553 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~Foo2_FooActorActorState();
		static_cast<Foo2_FooActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1323 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<Foo2_FooActorActor*>(this)->SAV<int>::futures) { (void)(self->x); this->~Foo2_FooActorActorState(); static_cast<Foo2_FooActorActor*>(this)->destroy(); return 0; }
															#line 9576 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		new (&static_cast<Foo2_FooActorActor*>(this)->SAV< int >::value()) int(self->x);
		this->~Foo2_FooActorActorState();
		static_cast<Foo2_FooActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1323 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<Foo2_FooActorActor*>(this)->SAV<int>::futures) { (void)(self->x); this->~Foo2_FooActorActorState(); static_cast<Foo2_FooActorActor*>(this)->destroy(); return 0; }
															#line 9588 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		new (&static_cast<Foo2_FooActorActor*>(this)->SAV< int >::value()) int(self->x);
		this->~Foo2_FooActorActorState();
		static_cast<Foo2_FooActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<Foo2_FooActorActor*>(this)->actor_wait_state > 0) static_cast<Foo2_FooActorActor*>(this)->actor_wait_state = 0;
		static_cast<Foo2_FooActorActor*>(this)->ActorCallback< Foo2_FooActorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< Foo2_FooActorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fooActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Foo2_FooActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fooActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< Foo2_FooActorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fooActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Foo2_FooActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fooActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< Foo2_FooActorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fooActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<Foo2_FooActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fooActor", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1321 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Foo2* self;
															#line 9673 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
};
// This generated class is to be used only via fooActor()
															#line 1321 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class Foo2_FooActorActor final : public Actor<int>, public ActorCallback< Foo2_FooActorActor, 0, Void >, public FastAllocated<Foo2_FooActorActor>, public Foo2_FooActorActorState<Foo2_FooActorActor> {
															#line 9678 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
	using FastAllocated<Foo2_FooActorActor>::operator new;
	using FastAllocated<Foo2_FooActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16336398880794180352UL, 10118862442187344896UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<int>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< Foo2_FooActorActor, 0, Void >;
															#line 1321 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Foo2_FooActorActor(Foo2* const& self) 
															#line 9695 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		 : Actor<int>(),
		   Foo2_FooActorActorState<Foo2_FooActorActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("fooActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5980048447256649728UL, 16289667340815723008UL);
		ActorExecutionContextHelper __helper(static_cast<Foo2_FooActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("fooActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("fooActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< Foo2_FooActorActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1321 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
Future<int> Foo2::fooActor( Foo2* const& self ) {
															#line 1321 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<int>(new Foo2_FooActorActor(self));
															#line 9727 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
}

#line 1325 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

class alignas(4) Foo3 {
public:
	explicit Foo3(int x) : x(x) {}
	Future<int> foo() { return fooActor(this); }
																#line 9736 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
static Future<int> fooActor( Foo3* const& self );
template <class> friend class Foo3_FooActorActorState;

#line 1331 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

private:
	int x;
};
															#line 9745 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
// This generated class is to be used only via fooActor()
															#line 1335 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class Foo3_FooActorActor>
															#line 1335 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class Foo3_FooActorActorState {
															#line 9751 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
															#line 1335 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Foo3_FooActorActorState(Foo3* const& self) 
															#line 1335 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 1335 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : self(self)
															#line 9758 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("fooActor", reinterpret_cast<unsigned long>(this));

	}
	~Foo3_FooActorActorState() 
	{
		fdb_probe_actor_destroy("fooActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1336 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = Future<Void>();
															#line 1336 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (static_cast<Foo3_FooActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9775 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<Foo3_FooActorActor*>(this)->actor_wait_state = 1;
															#line 1336 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< Foo3_FooActorActor, 0, Void >*>(static_cast<Foo3_FooActorActor*>(this)));
															#line 9780 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~Foo3_FooActorActorState();
		static_cast<Foo3_FooActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1337 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<Foo3_FooActorActor*>(this)->SAV<int>::futures) { (void)(self->x); this->~Foo3_FooActorActorState(); static_cast<Foo3_FooActorActor*>(this)->destroy(); return 0; }
															#line 9803 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		new (&static_cast<Foo3_FooActorActor*>(this)->SAV< int >::value()) int(self->x);
		this->~Foo3_FooActorActorState();
		static_cast<Foo3_FooActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1337 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<Foo3_FooActorActor*>(this)->SAV<int>::futures) { (void)(self->x); this->~Foo3_FooActorActorState(); static_cast<Foo3_FooActorActor*>(this)->destroy(); return 0; }
															#line 9815 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		new (&static_cast<Foo3_FooActorActor*>(this)->SAV< int >::value()) int(self->x);
		this->~Foo3_FooActorActorState();
		static_cast<Foo3_FooActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<Foo3_FooActorActor*>(this)->actor_wait_state > 0) static_cast<Foo3_FooActorActor*>(this)->actor_wait_state = 0;
		static_cast<Foo3_FooActorActor*>(this)->ActorCallback< Foo3_FooActorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< Foo3_FooActorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fooActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Foo3_FooActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fooActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< Foo3_FooActorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fooActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Foo3_FooActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fooActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< Foo3_FooActorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fooActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<Foo3_FooActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fooActor", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1335 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Foo3* self;
															#line 9900 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
};
// This generated class is to be used only via fooActor()
															#line 1335 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class Foo3_FooActorActor final : public Actor<int>, public ActorCallback< Foo3_FooActorActor, 0, Void >, public FastAllocated<Foo3_FooActorActor>, public Foo3_FooActorActorState<Foo3_FooActorActor> {
															#line 9905 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
	using FastAllocated<Foo3_FooActorActor>::operator new;
	using FastAllocated<Foo3_FooActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16336398880794180352UL, 10118862442187344896UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<int>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< Foo3_FooActorActor, 0, Void >;
															#line 1335 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Foo3_FooActorActor(Foo3* const& self) 
															#line 9922 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		 : Actor<int>(),
		   Foo3_FooActorActorState<Foo3_FooActorActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("fooActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(836691685770628608UL, 3656172371739853056UL);
		ActorExecutionContextHelper __helper(static_cast<Foo3_FooActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("fooActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("fooActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< Foo3_FooActorActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1335 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
Future<int> Foo3::fooActor( Foo3* const& self ) {
															#line 1335 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<int>(new Foo3_FooActorActor(self));
															#line 9954 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
}

#line 1339 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

struct Super {};

class Foo4 : Super {
public:
	explicit Foo4(int x) : x(x) {}
	Future<int> foo() { return fooActor(this); }
																#line 9965 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
static Future<int> fooActor( Foo4* const& self );
template <class> friend class Foo4_FooActorActorState;

#line 1347 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

private:
	int x;
};
															#line 9974 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
// This generated class is to be used only via fooActor()
															#line 1351 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class Foo4_FooActorActor>
															#line 1351 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class Foo4_FooActorActorState {
															#line 9980 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
															#line 1351 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Foo4_FooActorActorState(Foo4* const& self) 
															#line 1351 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 1351 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : self(self)
															#line 9987 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("fooActor", reinterpret_cast<unsigned long>(this));

	}
	~Foo4_FooActorActorState() 
	{
		fdb_probe_actor_destroy("fooActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1352 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = Future<Void>();
															#line 1352 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (static_cast<Foo4_FooActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10004 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<Foo4_FooActorActor*>(this)->actor_wait_state = 1;
															#line 1352 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< Foo4_FooActorActor, 0, Void >*>(static_cast<Foo4_FooActorActor*>(this)));
															#line 10009 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~Foo4_FooActorActorState();
		static_cast<Foo4_FooActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1353 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<Foo4_FooActorActor*>(this)->SAV<int>::futures) { (void)(self->x); this->~Foo4_FooActorActorState(); static_cast<Foo4_FooActorActor*>(this)->destroy(); return 0; }
															#line 10032 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		new (&static_cast<Foo4_FooActorActor*>(this)->SAV< int >::value()) int(self->x);
		this->~Foo4_FooActorActorState();
		static_cast<Foo4_FooActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1353 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<Foo4_FooActorActor*>(this)->SAV<int>::futures) { (void)(self->x); this->~Foo4_FooActorActorState(); static_cast<Foo4_FooActorActor*>(this)->destroy(); return 0; }
															#line 10044 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		new (&static_cast<Foo4_FooActorActor*>(this)->SAV< int >::value()) int(self->x);
		this->~Foo4_FooActorActorState();
		static_cast<Foo4_FooActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<Foo4_FooActorActor*>(this)->actor_wait_state > 0) static_cast<Foo4_FooActorActor*>(this)->actor_wait_state = 0;
		static_cast<Foo4_FooActorActor*>(this)->ActorCallback< Foo4_FooActorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< Foo4_FooActorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fooActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Foo4_FooActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fooActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< Foo4_FooActorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fooActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Foo4_FooActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fooActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< Foo4_FooActorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fooActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<Foo4_FooActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fooActor", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1351 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Foo4* self;
															#line 10129 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
};
// This generated class is to be used only via fooActor()
															#line 1351 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class Foo4_FooActorActor final : public Actor<int>, public ActorCallback< Foo4_FooActorActor, 0, Void >, public FastAllocated<Foo4_FooActorActor>, public Foo4_FooActorActorState<Foo4_FooActorActor> {
															#line 10134 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
	using FastAllocated<Foo4_FooActorActor>::operator new;
	using FastAllocated<Foo4_FooActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16336398880794180352UL, 10118862442187344896UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<int>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< Foo4_FooActorActor, 0, Void >;
															#line 1351 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Foo4_FooActorActor(Foo4* const& self) 
															#line 10151 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		 : Actor<int>(),
		   Foo4_FooActorActorState<Foo4_FooActorActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("fooActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10335068724183540736UL, 10041851579328590592UL);
		ActorExecutionContextHelper __helper(static_cast<Foo4_FooActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("fooActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("fooActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< Foo4_FooActorActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1351 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
Future<int> Foo4::fooActor( Foo4* const& self ) {
															#line 1351 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<int>(new Foo4_FooActorActor(self));
															#line 10183 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
}

#line 1355 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

struct Outer {
	class Foo5 : Super {
	public:
		explicit Foo5(int x) : x(x) {}
		Future<int> foo() { return fooActor(this); }
																	#line 10193 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
static Future<int> fooActor( Foo5* const& self );
template <class> friend class Outer_Foo5_FooActorActorState;

#line 1362 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

	private:
		int x;
	};
};
															#line 10203 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
// This generated class is to be used only via fooActor()
															#line 1367 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class Outer_Foo5_FooActorActor>
															#line 1367 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class Outer_Foo5_FooActorActorState {
															#line 10209 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
															#line 1367 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Outer_Foo5_FooActorActorState(Outer::Foo5* const& self) 
															#line 1367 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 1367 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : self(self)
															#line 10216 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("fooActor", reinterpret_cast<unsigned long>(this));

	}
	~Outer_Foo5_FooActorActorState() 
	{
		fdb_probe_actor_destroy("fooActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1368 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = Future<Void>();
															#line 1368 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (static_cast<Outer_Foo5_FooActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10233 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<Outer_Foo5_FooActorActor*>(this)->actor_wait_state = 1;
															#line 1368 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< Outer_Foo5_FooActorActor, 0, Void >*>(static_cast<Outer_Foo5_FooActorActor*>(this)));
															#line 10238 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~Outer_Foo5_FooActorActorState();
		static_cast<Outer_Foo5_FooActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1369 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<Outer_Foo5_FooActorActor*>(this)->SAV<int>::futures) { (void)(self->x); this->~Outer_Foo5_FooActorActorState(); static_cast<Outer_Foo5_FooActorActor*>(this)->destroy(); return 0; }
															#line 10261 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		new (&static_cast<Outer_Foo5_FooActorActor*>(this)->SAV< int >::value()) int(self->x);
		this->~Outer_Foo5_FooActorActorState();
		static_cast<Outer_Foo5_FooActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1369 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<Outer_Foo5_FooActorActor*>(this)->SAV<int>::futures) { (void)(self->x); this->~Outer_Foo5_FooActorActorState(); static_cast<Outer_Foo5_FooActorActor*>(this)->destroy(); return 0; }
															#line 10273 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		new (&static_cast<Outer_Foo5_FooActorActor*>(this)->SAV< int >::value()) int(self->x);
		this->~Outer_Foo5_FooActorActorState();
		static_cast<Outer_Foo5_FooActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<Outer_Foo5_FooActorActor*>(this)->actor_wait_state > 0) static_cast<Outer_Foo5_FooActorActor*>(this)->actor_wait_state = 0;
		static_cast<Outer_Foo5_FooActorActor*>(this)->ActorCallback< Outer_Foo5_FooActorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< Outer_Foo5_FooActorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fooActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Outer_Foo5_FooActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fooActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< Outer_Foo5_FooActorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fooActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Outer_Foo5_FooActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fooActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< Outer_Foo5_FooActorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fooActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<Outer_Foo5_FooActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fooActor", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1367 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Outer::Foo5* self;
															#line 10358 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
};
// This generated class is to be used only via fooActor()
															#line 1367 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class Outer_Foo5_FooActorActor final : public Actor<int>, public ActorCallback< Outer_Foo5_FooActorActor, 0, Void >, public FastAllocated<Outer_Foo5_FooActorActor>, public Outer_Foo5_FooActorActorState<Outer_Foo5_FooActorActor> {
															#line 10363 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
	using FastAllocated<Outer_Foo5_FooActorActor>::operator new;
	using FastAllocated<Outer_Foo5_FooActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16336398880794180352UL, 10118862442187344896UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<int>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< Outer_Foo5_FooActorActor, 0, Void >;
															#line 1367 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Outer_Foo5_FooActorActor(Outer::Foo5* const& self) 
															#line 10380 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		 : Actor<int>(),
		   Outer_Foo5_FooActorActorState<Outer_Foo5_FooActorActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("fooActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3544515340740103424UL, 6737337361604354048UL);
		ActorExecutionContextHelper __helper(static_cast<Outer_Foo5_FooActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("fooActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("fooActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< Outer_Foo5_FooActorActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1367 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
Future<int> Outer::Foo5::fooActor( Outer::Foo5* const& self ) {
															#line 1367 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<int>(new Outer_Foo5_FooActorActor(self));
															#line 10412 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
}

#line 1371 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

// Meant to be run with -fsanitize=undefined
															#line 10418 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via flowTestCase1373()
															#line 1373 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class FlowTestCase1373Actor>
															#line 1373 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase1373ActorState {
															#line 10425 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
															#line 1373 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase1373ActorState(UnitTestParameters const& params) 
															#line 1373 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 1373 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : params(params)
															#line 10432 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("flowTestCase1373", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase1373ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase1373", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1374 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			deterministicRandom()->randomInt(std::numeric_limits<int>::min(), 0);
															#line 1375 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			deterministicRandom()->randomInt(0, std::numeric_limits<int>::max());
															#line 1376 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			deterministicRandom()->randomInt(std::numeric_limits<int>::min(), std::numeric_limits<int>::max());
															#line 1377 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(deterministicRandom()->randomInt(std::numeric_limits<int>::min(), std::numeric_limits<int>::min() + 1) == std::numeric_limits<int>::min());
															#line 1379 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(deterministicRandom()->randomInt(std::numeric_limits<int>::max() - 1, std::numeric_limits<int>::max()) == std::numeric_limits<int>::max() - 1);
															#line 1382 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			deterministicRandom()->randomInt64(std::numeric_limits<int64_t>::min(), 0);
															#line 1383 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			deterministicRandom()->randomInt64(0, std::numeric_limits<int64_t>::max());
															#line 1384 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			deterministicRandom()->randomInt64(std::numeric_limits<int64_t>::min(), std::numeric_limits<int64_t>::max());
															#line 1385 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(deterministicRandom()->randomInt64(std::numeric_limits<int64_t>::min(), std::numeric_limits<int64_t>::min() + 1) == std::numeric_limits<int64_t>::min());
															#line 1388 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(deterministicRandom()->randomInt64(std::numeric_limits<int64_t>::max() - 1, std::numeric_limits<int64_t>::max()) == std::numeric_limits<int64_t>::max() - 1);
															#line 1391 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (!static_cast<FlowTestCase1373Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase1373ActorState(); static_cast<FlowTestCase1373Actor*>(this)->destroy(); return 0; }
															#line 10467 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			new (&static_cast<FlowTestCase1373Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase1373ActorState();
			static_cast<FlowTestCase1373Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase1373ActorState();
		static_cast<FlowTestCase1373Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 1373 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	UnitTestParameters params;
															#line 10491 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
};
// This generated class is to be used only via flowTestCase1373()
															#line 1373 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase1373Actor final : public Actor<Void>, public FastAllocated<FlowTestCase1373Actor>, public FlowTestCase1373ActorState<FlowTestCase1373Actor> {
															#line 10496 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
	using FastAllocated<FlowTestCase1373Actor>::operator new;
	using FastAllocated<FlowTestCase1373Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3748935145792291584UL, 4364716835485984256UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 1373 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase1373Actor(UnitTestParameters const& params) 
															#line 10512 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   FlowTestCase1373ActorState<FlowTestCase1373Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase1373", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5469211664167309312UL, 2747157699747706880UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1373Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase1373");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase1373", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 1373 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> flowTestCase1373( UnitTestParameters const& params ) {
															#line 1373 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new FlowTestCase1373Actor(params));
															#line 10544 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
}
ACTOR_TEST_CASE(flowTestCase1373, "/flow/DeterministicRandom/SignedOverflow")

#line 1393 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

struct Tracker {
	int copied;
	bool moved;
	Tracker(int copied = 0) : copied(copied), moved(false) {}
	Tracker(Tracker&& other) : Tracker(other.copied) {
		ASSERT(!other.moved);
		other.moved = true;
	}
	Tracker& operator=(Tracker&& other) {
		ASSERT(!other.moved);
		other.moved = true;
		this->moved = false;
		this->copied = other.copied;
		return *this;
	}
	Tracker(const Tracker& other) : Tracker(other.copied + 1) { ASSERT(!other.moved); }
	Tracker& operator=(const Tracker& other) {
		ASSERT(!other.moved);
		this->moved = false;
		this->copied = other.copied + 1;
		return *this;
	}
	~Tracker() = default;

																#line 10574 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
// This generated class is to be used only via listen()
															#line 1418 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class ListenActor>
															#line 1418 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class ListenActorState {
															#line 10580 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
															#line 1418 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	ListenActorState(FutureStream<Tracker> const& stream) 
															#line 1418 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 1418 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : stream(stream)
															#line 10587 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("listen", reinterpret_cast<unsigned long>(this));

	}
	~ListenActorState() 
	{
		fdb_probe_actor_destroy("listen", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1419 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			auto __when_expr_0 = stream;
															#line 10602 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			static_assert(std::is_same<decltype(__when_expr_0), FutureStream<Tracker>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<Tracker>>::value, "invalid type");
															#line 1419 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (static_cast<ListenActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10606 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.pop(), loopDepth); };
			static_cast<ListenActor*>(this)->actor_wait_state = 1;
															#line 1419 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< ListenActor, 0, Tracker >*>(static_cast<ListenActor*>(this)));
															#line 10611 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ListenActorState();
		static_cast<ListenActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Tracker const& movedTracker,int loopDepth) 
	{
															#line 1420 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		ASSERT(!movedTracker.moved);
															#line 1421 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		ASSERT(movedTracker.copied == 0);
															#line 1422 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<ListenActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ListenActorState(); static_cast<ListenActor*>(this)->destroy(); return 0; }
															#line 10638 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		new (&static_cast<ListenActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ListenActorState();
		static_cast<ListenActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Tracker && movedTracker,int loopDepth) 
	{
															#line 1420 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		ASSERT(!movedTracker.moved);
															#line 1421 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		ASSERT(movedTracker.copied == 0);
															#line 1422 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<ListenActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ListenActorState(); static_cast<ListenActor*>(this)->destroy(); return 0; }
															#line 10654 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		new (&static_cast<ListenActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ListenActorState();
		static_cast<ListenActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Tracker const& movedTracker,int loopDepth) 
	{
		loopDepth = a_body1cont1(movedTracker, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Tracker && movedTracker,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(movedTracker), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ListenActor*>(this)->actor_wait_state > 0) static_cast<ListenActor*>(this)->actor_wait_state = 0;
		static_cast<ListenActor*>(this)->ActorSingleCallback< ListenActor, 0, Tracker >::remove();

	}
	void a_callback_fire(ActorSingleCallback< ListenActor, 0, Tracker >*,Tracker const& value) 
	{
		fdb_probe_actor_enter("listen", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListenActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listen", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< ListenActor, 0, Tracker >*,Tracker && value) 
	{
		fdb_probe_actor_enter("listen", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListenActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listen", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< ListenActor, 0, Tracker >*,Error err) 
	{
		fdb_probe_actor_enter("listen", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ListenActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listen", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1418 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FutureStream<Tracker> stream;
															#line 10739 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
};
// This generated class is to be used only via listen()
															#line 1418 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class ListenActor final : public Actor<Void>, public ActorSingleCallback< ListenActor, 0, Tracker >, public FastAllocated<ListenActor>, public ListenActorState<ListenActor> {
															#line 10744 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
	using FastAllocated<ListenActor>::operator new;
	using FastAllocated<ListenActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5647694373609850624UL, 10512462336406817280UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< ListenActor, 0, Tracker >;
															#line 1418 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	ListenActor(FutureStream<Tracker> const& stream) 
															#line 10761 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   ListenActorState<ListenActor>(stream),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("listen", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9989528927518907392UL, 7817939837473479168UL);
		ActorExecutionContextHelper __helper(static_cast<ListenActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("listen");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("listen", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< ListenActor, 0, Tracker >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1418 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> listen( FutureStream<Tracker> const& stream ) {
															#line 1418 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new ListenActor(stream));
															#line 10793 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
}

#line 1424 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
};

															#line 10799 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via flowTestCase1426()
															#line 1426 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class FlowTestCase1426Actor>
															#line 1426 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase1426ActorState {
															#line 10806 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
															#line 1426 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase1426ActorState(UnitTestParameters const& params) 
															#line 1426 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 1426 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : params(params),
															#line 1427 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		   stream(),
															#line 1428 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		   listener()
															#line 10817 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("flowTestCase1426", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase1426ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase1426", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			{
															#line 1432 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				listener = Tracker::listen(stream.getFuture());
															#line 1433 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				stream.send(Tracker{});
															#line 1434 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				StrictFuture<Void> __when_expr_0 = listener;
															#line 1434 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				if (static_cast<FlowTestCase1426Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10839 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<FlowTestCase1426Actor*>(this)->actor_wait_state = 1;
															#line 1434 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase1426Actor, 0, Void >*>(static_cast<FlowTestCase1426Actor*>(this)));
															#line 10844 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase1426ActorState();
		static_cast<FlowTestCase1426Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
		{
															#line 1440 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			listener = Tracker::listen(stream.getFuture());
															#line 1441 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			Tracker namedTracker;
															#line 1442 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			stream.send(namedTracker);
															#line 1443 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			StrictFuture<Void> __when_expr_1 = listener;
															#line 1443 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (static_cast<FlowTestCase1426Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10877 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<FlowTestCase1426Actor*>(this)->actor_wait_state = 2;
															#line 1443 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase1426Actor, 1, Void >*>(static_cast<FlowTestCase1426Actor*>(this)));
															#line 10882 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase1426Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase1426Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase1426Actor*>(this)->ActorCallback< FlowTestCase1426Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase1426Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase1426", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1426Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1426", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase1426Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase1426", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1426Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1426", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase1426Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase1426", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1426Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1426", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
		{
															#line 1448 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			stream.send(Tracker{});
															#line 1449 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			stream.send(Tracker{});
															#line 10982 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			{
															#line 1451 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				auto __when_expr_2 = stream.getFuture();
															#line 10986 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
				static_assert(std::is_same<decltype(__when_expr_2), FutureStream<Tracker>>::value || std::is_same<decltype(__when_expr_2), ThreadFutureStream<Tracker>>::value, "invalid type");
															#line 1451 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				if (static_cast<FlowTestCase1426Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10990 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
				if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.pop(), loopDepth); };
				static_cast<FlowTestCase1426Actor*>(this)->actor_wait_state = 3;
															#line 1451 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				__when_expr_2.addCallbackAndClear(static_cast<ActorSingleCallback< FlowTestCase1426Actor, 2, Tracker >*>(static_cast<FlowTestCase1426Actor*>(this)));
															#line 10995 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
		}

		return loopDepth;
	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<FlowTestCase1426Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase1426Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase1426Actor*>(this)->ActorCallback< FlowTestCase1426Actor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase1426Actor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase1426", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1426Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1426", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FlowTestCase1426Actor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase1426", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1426Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1426", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FlowTestCase1426Actor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase1426", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1426Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1426", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(int loopDepth) 
	{
		{
															#line 1464 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			Tracker namedTracker1;
															#line 1465 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			Tracker namedTracker2;
															#line 1466 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			stream.send(namedTracker1);
															#line 1467 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			stream.send(namedTracker2);
															#line 11100 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			{
															#line 1469 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				auto __when_expr_4 = stream.getFuture();
															#line 11104 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
				static_assert(std::is_same<decltype(__when_expr_4), FutureStream<Tracker>>::value || std::is_same<decltype(__when_expr_4), ThreadFutureStream<Tracker>>::value, "invalid type");
															#line 1469 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				if (static_cast<FlowTestCase1426Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11108 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
				if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont5when1(__when_expr_4.pop(), loopDepth); };
				static_cast<FlowTestCase1426Actor*>(this)->actor_wait_state = 5;
															#line 1469 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				__when_expr_4.addCallbackAndClear(static_cast<ActorSingleCallback< FlowTestCase1426Actor, 4, Tracker >*>(static_cast<FlowTestCase1426Actor*>(this)));
															#line 11113 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
		}

		return loopDepth;
	}
	int a_body1cont6(int loopDepth) 
	{
		{
															#line 1456 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			auto __when_expr_3 = stream.getFuture();
															#line 11125 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			static_assert(std::is_same<decltype(__when_expr_3), FutureStream<Tracker>>::value || std::is_same<decltype(__when_expr_3), ThreadFutureStream<Tracker>>::value, "invalid type");
															#line 1456 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (static_cast<FlowTestCase1426Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11129 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont6when1(__when_expr_3.pop(), loopDepth); };
			static_cast<FlowTestCase1426Actor*>(this)->actor_wait_state = 4;
															#line 1456 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorSingleCallback< FlowTestCase1426Actor, 3, Tracker >*>(static_cast<FlowTestCase1426Actor*>(this)));
															#line 11134 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont7(int loopDepth) 
	{
															#line 1452 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		ASSERT(!movedTracker.moved);
															#line 1453 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		ASSERT(movedTracker.copied == 0);
															#line 11146 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Tracker const& __movedTracker,int loopDepth) 
	{
															#line 1451 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		movedTracker = __movedTracker;
															#line 11155 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Tracker && __movedTracker,int loopDepth) 
	{
		movedTracker = std::move(__movedTracker);
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<FlowTestCase1426Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase1426Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase1426Actor*>(this)->ActorSingleCallback< FlowTestCase1426Actor, 2, Tracker >::remove();

	}
	void a_callback_fire(ActorSingleCallback< FlowTestCase1426Actor, 2, Tracker >*,Tracker const& value) 
	{
		fdb_probe_actor_enter("flowTestCase1426", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1426Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1426", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorSingleCallback< FlowTestCase1426Actor, 2, Tracker >*,Tracker && value) 
	{
		fdb_probe_actor_enter("flowTestCase1426", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1426Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1426", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorSingleCallback< FlowTestCase1426Actor, 2, Tracker >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase1426", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1426Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1426", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont9(int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont10(Tracker const& movedTracker,int loopDepth) 
	{
															#line 1457 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		ASSERT(!movedTracker.moved);
															#line 1458 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		ASSERT(movedTracker.copied == 0);
															#line 11242 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont10(Tracker && movedTracker,int loopDepth) 
	{
															#line 1457 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		ASSERT(!movedTracker.moved);
															#line 1458 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		ASSERT(movedTracker.copied == 0);
															#line 11253 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Tracker const& movedTracker,int loopDepth) 
	{
		loopDepth = a_body1cont10(movedTracker, loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Tracker && movedTracker,int loopDepth) 
	{
		loopDepth = a_body1cont10(std::move(movedTracker), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<FlowTestCase1426Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase1426Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase1426Actor*>(this)->ActorSingleCallback< FlowTestCase1426Actor, 3, Tracker >::remove();

	}
	void a_callback_fire(ActorSingleCallback< FlowTestCase1426Actor, 3, Tracker >*,Tracker const& value) 
	{
		fdb_probe_actor_enter("flowTestCase1426", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1426Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1426", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorSingleCallback< FlowTestCase1426Actor, 3, Tracker >*,Tracker && value) 
	{
		fdb_probe_actor_enter("flowTestCase1426", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1426Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1426", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorSingleCallback< FlowTestCase1426Actor, 3, Tracker >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase1426", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1426Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1426", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont11(int loopDepth) 
	{
															#line 1482 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<FlowTestCase1426Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase1426ActorState(); static_cast<FlowTestCase1426Actor*>(this)->destroy(); return 0; }
															#line 11337 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		new (&static_cast<FlowTestCase1426Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase1426ActorState();
		static_cast<FlowTestCase1426Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont12(int loopDepth) 
	{
		{
															#line 1475 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			auto __when_expr_5 = stream.getFuture();
															#line 11350 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			static_assert(std::is_same<decltype(__when_expr_5), FutureStream<Tracker>>::value || std::is_same<decltype(__when_expr_5), ThreadFutureStream<Tracker>>::value, "invalid type");
															#line 1475 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (static_cast<FlowTestCase1426Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11354 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont12when1(__when_expr_5.pop(), loopDepth); };
			static_cast<FlowTestCase1426Actor*>(this)->actor_wait_state = 6;
															#line 1475 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorSingleCallback< FlowTestCase1426Actor, 5, Tracker >*>(static_cast<FlowTestCase1426Actor*>(this)));
															#line 11359 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont13(int loopDepth) 
	{
															#line 1470 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		ASSERT(!copiedTracker.moved);
															#line 1472 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		ASSERT(copiedTracker.copied == 1);
															#line 11371 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		loopDepth = a_body1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Tracker const& __copiedTracker,int loopDepth) 
	{
															#line 1469 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		copiedTracker = __copiedTracker;
															#line 11380 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		loopDepth = a_body1cont13(loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Tracker && __copiedTracker,int loopDepth) 
	{
		copiedTracker = std::move(__copiedTracker);
		loopDepth = a_body1cont13(loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<FlowTestCase1426Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase1426Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase1426Actor*>(this)->ActorSingleCallback< FlowTestCase1426Actor, 4, Tracker >::remove();

	}
	void a_callback_fire(ActorSingleCallback< FlowTestCase1426Actor, 4, Tracker >*,Tracker const& value) 
	{
		fdb_probe_actor_enter("flowTestCase1426", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1426Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1426", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorSingleCallback< FlowTestCase1426Actor, 4, Tracker >*,Tracker && value) 
	{
		fdb_probe_actor_enter("flowTestCase1426", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1426Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1426", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorSingleCallback< FlowTestCase1426Actor, 4, Tracker >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase1426", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1426Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1426", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont12cont1(int loopDepth) 
	{
		loopDepth = a_body1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont2(Tracker const& copiedTracker,int loopDepth) 
	{
															#line 1476 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		ASSERT(!copiedTracker.moved);
															#line 1478 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		ASSERT(copiedTracker.copied == 1);
															#line 11467 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		loopDepth = a_body1cont12cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont2(Tracker && copiedTracker,int loopDepth) 
	{
															#line 1476 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		ASSERT(!copiedTracker.moved);
															#line 1478 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		ASSERT(copiedTracker.copied == 1);
															#line 11478 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		loopDepth = a_body1cont12cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12when1(Tracker const& copiedTracker,int loopDepth) 
	{
		loopDepth = a_body1cont12cont2(copiedTracker, loopDepth);

		return loopDepth;
	}
	int a_body1cont12when1(Tracker && copiedTracker,int loopDepth) 
	{
		loopDepth = a_body1cont12cont2(std::move(copiedTracker), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<FlowTestCase1426Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase1426Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase1426Actor*>(this)->ActorSingleCallback< FlowTestCase1426Actor, 5, Tracker >::remove();

	}
	void a_callback_fire(ActorSingleCallback< FlowTestCase1426Actor, 5, Tracker >*,Tracker const& value) 
	{
		fdb_probe_actor_enter("flowTestCase1426", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1426Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont12when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1426", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorSingleCallback< FlowTestCase1426Actor, 5, Tracker >*,Tracker && value) 
	{
		fdb_probe_actor_enter("flowTestCase1426", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1426Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont12when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1426", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorSingleCallback< FlowTestCase1426Actor, 5, Tracker >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase1426", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1426Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1426", reinterpret_cast<unsigned long>(this), 5);

	}
															#line 1426 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	UnitTestParameters params;
															#line 1427 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	PromiseStream<Tracker> stream;
															#line 1428 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Future<Void> listener;
															#line 1451 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Tracker movedTracker;
															#line 1469 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Tracker copiedTracker;
															#line 11568 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
};
// This generated class is to be used only via flowTestCase1426()
															#line 1426 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase1426Actor final : public Actor<Void>, public ActorCallback< FlowTestCase1426Actor, 0, Void >, public ActorCallback< FlowTestCase1426Actor, 1, Void >, public ActorSingleCallback< FlowTestCase1426Actor, 2, Tracker >, public ActorSingleCallback< FlowTestCase1426Actor, 3, Tracker >, public ActorSingleCallback< FlowTestCase1426Actor, 4, Tracker >, public ActorSingleCallback< FlowTestCase1426Actor, 5, Tracker >, public FastAllocated<FlowTestCase1426Actor>, public FlowTestCase1426ActorState<FlowTestCase1426Actor> {
															#line 11573 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
	using FastAllocated<FlowTestCase1426Actor>::operator new;
	using FastAllocated<FlowTestCase1426Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8913654347470817536UL, 13323312865763083008UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase1426Actor, 0, Void >;
friend struct ActorCallback< FlowTestCase1426Actor, 1, Void >;
friend struct ActorSingleCallback< FlowTestCase1426Actor, 2, Tracker >;
friend struct ActorSingleCallback< FlowTestCase1426Actor, 3, Tracker >;
friend struct ActorSingleCallback< FlowTestCase1426Actor, 4, Tracker >;
friend struct ActorSingleCallback< FlowTestCase1426Actor, 5, Tracker >;
															#line 1426 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase1426Actor(UnitTestParameters const& params) 
															#line 11595 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   FlowTestCase1426ActorState<FlowTestCase1426Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase1426", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11262045475822546944UL, 5575827573216037120UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1426Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase1426");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase1426", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase1426Actor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< FlowTestCase1426Actor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorSingleCallback< FlowTestCase1426Actor, 2, Tracker >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorSingleCallback< FlowTestCase1426Actor, 3, Tracker >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorSingleCallback< FlowTestCase1426Actor, 4, Tracker >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorSingleCallback< FlowTestCase1426Actor, 5, Tracker >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1426 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> flowTestCase1426( UnitTestParameters const& params ) {
															#line 1426 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new FlowTestCase1426Actor(params));
															#line 11633 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
}
ACTOR_TEST_CASE(flowTestCase1426, "/flow/flow/PromiseStream/move")

#line 1484 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 11639 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via flowTestCase1485()
															#line 1485 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class FlowTestCase1485Actor>
															#line 1485 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase1485ActorState {
															#line 11646 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
															#line 1485 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase1485ActorState(UnitTestParameters const& params) 
															#line 1485 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 1485 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : params(params)
															#line 11653 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("flowTestCase1485", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase1485ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase1485", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1486 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			PromiseStream<Tracker> stream;
															#line 1487 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			stream.send(Tracker{});
															#line 1488 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			auto __when_expr_0 = stream.getFuture();
															#line 11672 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			static_assert(std::is_same<decltype(__when_expr_0), FutureStream<Tracker>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<Tracker>>::value, "invalid type");
															#line 1488 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (static_cast<FlowTestCase1485Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11676 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.pop(), loopDepth); };
			static_cast<FlowTestCase1485Actor*>(this)->actor_wait_state = 1;
															#line 1488 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< FlowTestCase1485Actor, 0, Tracker >*>(static_cast<FlowTestCase1485Actor*>(this)));
															#line 11681 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase1485ActorState();
		static_cast<FlowTestCase1485Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Tracker const& tracker,int loopDepth) 
	{
															#line 1489 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		Tracker movedTracker = std::move(tracker);
															#line 1490 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		ASSERT(tracker.moved);
															#line 1491 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		ASSERT(!movedTracker.moved);
															#line 1492 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		ASSERT(movedTracker.copied == 0);
															#line 1493 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<FlowTestCase1485Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase1485ActorState(); static_cast<FlowTestCase1485Actor*>(this)->destroy(); return 0; }
															#line 11712 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		new (&static_cast<FlowTestCase1485Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase1485ActorState();
		static_cast<FlowTestCase1485Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Tracker && tracker,int loopDepth) 
	{
															#line 1489 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		Tracker movedTracker = std::move(tracker);
															#line 1490 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		ASSERT(tracker.moved);
															#line 1491 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		ASSERT(!movedTracker.moved);
															#line 1492 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		ASSERT(movedTracker.copied == 0);
															#line 1493 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<FlowTestCase1485Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase1485ActorState(); static_cast<FlowTestCase1485Actor*>(this)->destroy(); return 0; }
															#line 11732 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		new (&static_cast<FlowTestCase1485Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase1485ActorState();
		static_cast<FlowTestCase1485Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Tracker const& tracker,int loopDepth) 
	{
		loopDepth = a_body1cont1(tracker, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Tracker && tracker,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(tracker), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase1485Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase1485Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase1485Actor*>(this)->ActorSingleCallback< FlowTestCase1485Actor, 0, Tracker >::remove();

	}
	void a_callback_fire(ActorSingleCallback< FlowTestCase1485Actor, 0, Tracker >*,Tracker const& value) 
	{
		fdb_probe_actor_enter("flowTestCase1485", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1485Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1485", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< FlowTestCase1485Actor, 0, Tracker >*,Tracker && value) 
	{
		fdb_probe_actor_enter("flowTestCase1485", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1485Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1485", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< FlowTestCase1485Actor, 0, Tracker >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase1485", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1485Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1485", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1485 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	UnitTestParameters params;
															#line 11817 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
};
// This generated class is to be used only via flowTestCase1485()
															#line 1485 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase1485Actor final : public Actor<Void>, public ActorSingleCallback< FlowTestCase1485Actor, 0, Tracker >, public FastAllocated<FlowTestCase1485Actor>, public FlowTestCase1485ActorState<FlowTestCase1485Actor> {
															#line 11822 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
	using FastAllocated<FlowTestCase1485Actor>::operator new;
	using FastAllocated<FlowTestCase1485Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10490698728726114048UL, 1328611268452463872UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< FlowTestCase1485Actor, 0, Tracker >;
															#line 1485 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase1485Actor(UnitTestParameters const& params) 
															#line 11839 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   FlowTestCase1485ActorState<FlowTestCase1485Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase1485", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17123061441899620864UL, 7664667309688468992UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1485Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase1485");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase1485", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< FlowTestCase1485Actor, 0, Tracker >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1485 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> flowTestCase1485( UnitTestParameters const& params ) {
															#line 1485 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new FlowTestCase1485Actor(params));
															#line 11872 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
}
ACTOR_TEST_CASE(flowTestCase1485, "/flow/flow/PromiseStream/move2")

#line 1495 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

constexpr double mutexTestDelay = 0.00001;

															#line 11880 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via mutexTest()
															#line 1498 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class MutexTestActor>
															#line 1498 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class MutexTestActorState {
															#line 11887 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
															#line 1498 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	MutexTestActorState(int const& id,FlowMutex* const& mutex,int const& n,bool const& allowError,bool* const& verbose) 
															#line 1498 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 1498 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : id(id),
															#line 1498 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		   mutex(mutex),
															#line 1498 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		   n(n),
															#line 1498 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		   allowError(allowError),
															#line 1498 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		   verbose(verbose)
															#line 11902 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("mutexTest", reinterpret_cast<unsigned long>(this));

	}
	~MutexTestActorState() 
	{
		fdb_probe_actor_destroy("mutexTest", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1499 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			;
															#line 11917 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MutexTestActorState();
		static_cast<MutexTestActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1542 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (*verbose)
															#line 11940 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		{
															#line 1543 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			printf("%d Returning\n", id);
															#line 11944 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		}
															#line 1545 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<MutexTestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~MutexTestActorState(); static_cast<MutexTestActor*>(this)->destroy(); return 0; }
															#line 11948 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		new (&static_cast<MutexTestActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~MutexTestActorState();
		static_cast<MutexTestActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1499 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!(n-- > 0))
															#line 11967 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1500 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		d = deterministicRandom()->random01() * mutexTestDelay;
															#line 1501 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (*verbose)
															#line 11975 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		{
															#line 1502 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			printf("%d:%d wait %f while unlocked\n", id, n, d);
															#line 11979 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		}
															#line 1504 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delay(d);
															#line 1504 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (static_cast<MutexTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 11985 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<MutexTestActor*>(this)->actor_wait_state = 1;
															#line 1504 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MutexTestActor, 0, Void >*>(static_cast<MutexTestActor*>(this)));
															#line 11990 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 1506 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (*verbose)
															#line 12012 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		{
															#line 1507 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			printf("%d:%d locking\n", id, n);
															#line 12016 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		}
															#line 1509 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		StrictFuture<FlowMutex::Lock> __when_expr_1 = mutex->take();
															#line 1509 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (static_cast<MutexTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 12022 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<MutexTestActor*>(this)->actor_wait_state = 2;
															#line 1509 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MutexTestActor, 1, FlowMutex::Lock >*>(static_cast<MutexTestActor*>(this)));
															#line 12027 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 1506 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (*verbose)
															#line 12036 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		{
															#line 1507 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			printf("%d:%d locking\n", id, n);
															#line 12040 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		}
															#line 1509 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		StrictFuture<FlowMutex::Lock> __when_expr_1 = mutex->take();
															#line 1509 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (static_cast<MutexTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 12046 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<MutexTestActor*>(this)->actor_wait_state = 2;
															#line 1509 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MutexTestActor, 1, FlowMutex::Lock >*>(static_cast<MutexTestActor*>(this)));
															#line 12051 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MutexTestActor*>(this)->actor_wait_state > 0) static_cast<MutexTestActor*>(this)->actor_wait_state = 0;
		static_cast<MutexTestActor*>(this)->ActorCallback< MutexTestActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MutexTestActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("mutexTest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MutexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("mutexTest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MutexTestActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("mutexTest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MutexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("mutexTest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MutexTestActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("mutexTest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MutexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("mutexTest", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont4(int loopDepth) 
	{
															#line 1510 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (*verbose)
															#line 12135 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		{
															#line 1511 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			printf("%d:%d locked\n", id, n);
															#line 12139 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		}
															#line 1514 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		d = deterministicRandom()->random01() * mutexTestDelay;
															#line 1515 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (*verbose)
															#line 12145 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		{
															#line 1516 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			printf("%d:%d wait %f while locked\n", id, n, d);
															#line 12149 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		}
															#line 1518 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		StrictFuture<Void> __when_expr_2 = delay(d);
															#line 1518 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (static_cast<MutexTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 12155 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont4when1(__when_expr_2.get(), loopDepth); };
		static_cast<MutexTestActor*>(this)->actor_wait_state = 3;
															#line 1518 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MutexTestActor, 2, Void >*>(static_cast<MutexTestActor*>(this)));
															#line 12160 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(FlowMutex::Lock const& __lock,int loopDepth) 
	{
															#line 1509 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		lock = __lock;
															#line 12169 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(FlowMutex::Lock && __lock,int loopDepth) 
	{
		lock = std::move(__lock);
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<MutexTestActor*>(this)->actor_wait_state > 0) static_cast<MutexTestActor*>(this)->actor_wait_state = 0;
		static_cast<MutexTestActor*>(this)->ActorCallback< MutexTestActor, 1, FlowMutex::Lock >::remove();

	}
	void a_callback_fire(ActorCallback< MutexTestActor, 1, FlowMutex::Lock >*,FlowMutex::Lock const& value) 
	{
		fdb_probe_actor_enter("mutexTest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MutexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("mutexTest", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MutexTestActor, 1, FlowMutex::Lock >*,FlowMutex::Lock && value) 
	{
		fdb_probe_actor_enter("mutexTest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MutexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("mutexTest", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< MutexTestActor, 1, FlowMutex::Lock >*,Error err) 
	{
		fdb_probe_actor_enter("mutexTest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MutexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("mutexTest", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont6(Void const& _,int loopDepth) 
	{
															#line 1521 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (n == 0 && allowError)
															#line 12248 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		{
															#line 1522 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (deterministicRandom()->coinflip())
															#line 12252 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			{
															#line 1524 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				if (*verbose)
															#line 12256 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
				{
															#line 1525 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					printf("%d:%d sending error\n", id, n);
															#line 12260 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
				}
															#line 1527 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				lock.error(end_of_stream());
															#line 12264 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			}
			else
			{
															#line 1530 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				if (*verbose)
															#line 12270 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
				{
															#line 1531 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					printf("%d:%d dropping promise, returning without unlock\n", id, n);
															#line 12274 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
				}
			}
		}
		else
		{
															#line 1535 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (*verbose)
															#line 12282 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			{
															#line 1536 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				printf("%d:%d unlocking\n", id, n);
															#line 12286 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			}
															#line 1538 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			lock.release();
															#line 12290 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void && _,int loopDepth) 
	{
															#line 1521 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (n == 0 && allowError)
															#line 12300 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		{
															#line 1522 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (deterministicRandom()->coinflip())
															#line 12304 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			{
															#line 1524 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				if (*verbose)
															#line 12308 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
				{
															#line 1525 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					printf("%d:%d sending error\n", id, n);
															#line 12312 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
				}
															#line 1527 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				lock.error(end_of_stream());
															#line 12316 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			}
			else
			{
															#line 1530 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				if (*verbose)
															#line 12322 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
				{
															#line 1531 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					printf("%d:%d dropping promise, returning without unlock\n", id, n);
															#line 12326 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
				}
			}
		}
		else
		{
															#line 1535 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (*verbose)
															#line 12334 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			{
															#line 1536 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				printf("%d:%d unlocking\n", id, n);
															#line 12338 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			}
															#line 1538 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			lock.release();
															#line 12342 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<MutexTestActor*>(this)->actor_wait_state > 0) static_cast<MutexTestActor*>(this)->actor_wait_state = 0;
		static_cast<MutexTestActor*>(this)->ActorCallback< MutexTestActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MutexTestActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("mutexTest", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MutexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("mutexTest", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< MutexTestActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("mutexTest", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MutexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("mutexTest", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< MutexTestActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("mutexTest", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MutexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("mutexTest", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 1498 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	int id;
															#line 1498 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowMutex* mutex;
															#line 1498 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	int n;
															#line 1498 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	bool allowError;
															#line 1498 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	bool* verbose;
															#line 1500 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	double d;
															#line 1509 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowMutex::Lock lock;
															#line 12437 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
};
// This generated class is to be used only via mutexTest()
															#line 1498 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class MutexTestActor final : public Actor<Void>, public ActorCallback< MutexTestActor, 0, Void >, public ActorCallback< MutexTestActor, 1, FlowMutex::Lock >, public ActorCallback< MutexTestActor, 2, Void >, public FastAllocated<MutexTestActor>, public MutexTestActorState<MutexTestActor> {
															#line 12442 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
	using FastAllocated<MutexTestActor>::operator new;
	using FastAllocated<MutexTestActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10612413443862059776UL, 10783893460613286400UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MutexTestActor, 0, Void >;
friend struct ActorCallback< MutexTestActor, 1, FlowMutex::Lock >;
friend struct ActorCallback< MutexTestActor, 2, Void >;
															#line 1498 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	MutexTestActor(int const& id,FlowMutex* const& mutex,int const& n,bool const& allowError,bool* const& verbose) 
															#line 12461 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   MutexTestActorState<MutexTestActor>(id, mutex, n, allowError, verbose),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("mutexTest", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12647773376049955584UL, 1562998753292856064UL);
		ActorExecutionContextHelper __helper(static_cast<MutexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("mutexTest");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("mutexTest", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MutexTestActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< MutexTestActor, 1, FlowMutex::Lock >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< MutexTestActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1498 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
Future<Void> mutexTest( int const& id, FlowMutex* const& mutex, int const& n, bool const& allowError, bool* const& verbose ) {
															#line 1498 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new MutexTestActor(id, mutex, n, allowError, verbose));
															#line 12496 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
}

#line 1547 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 12501 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via flowTestCase1548()
															#line 1548 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class FlowTestCase1548Actor>
															#line 1548 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase1548ActorState {
															#line 12508 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
															#line 1548 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase1548ActorState(UnitTestParameters const& params) 
															#line 1548 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 1548 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : params(params),
															#line 1549 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		   count(100000),
															#line 1552 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		   verboseSetting(false),
															#line 1554 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		   verboseTestIteration(-1)
															#line 12521 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("flowTestCase1548", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase1548ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase1548", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 1557 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				verbose = verboseSetting || count == verboseTestIteration;
															#line 1559 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				;
															#line 12539 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase1548ActorState();
		static_cast<FlowTestCase1548Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1615 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<FlowTestCase1548Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase1548ActorState(); static_cast<FlowTestCase1548Actor*>(this)->destroy(); return 0; }
															#line 12568 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		new (&static_cast<FlowTestCase1548Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase1548ActorState();
		static_cast<FlowTestCase1548Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1611 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			printf("Error at count=%d\n", count + 1);
															#line 1612 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(false);
															#line 12583 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1559 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!(--count > 0))
															#line 12611 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1560 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (count % 1000 == 0)
															#line 12617 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		{
															#line 1561 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			printf("%d tests left\n", count);
															#line 12621 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		}
															#line 1564 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		mutex = FlowMutex();
															#line 1565 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		tests = std::vector<Future<Void>>();
															#line 1567 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		allowErrors = deterministicRandom()->coinflip();
															#line 1568 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (verbose)
															#line 12631 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		{
															#line 1569 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			printf("\nTesting allowErrors=%d\n", allowErrors);
															#line 12635 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		}
															#line 1572 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		error = Optional<Error>();
															#line 12639 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		try {
															#line 1575 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			for(int i = 0;i < 10;++i) {
															#line 1576 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				tests.push_back(mutexTest(i, &mutex, 10, allowErrors, &verbose));
															#line 12645 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			}
															#line 1578 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = waitForAll(tests);
															#line 1578 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (static_cast<FlowTestCase1548Actor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 12651 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase1548Actor*>(this)->actor_wait_state = 1;
															#line 1578 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase1548Actor, 0, Void >*>(static_cast<FlowTestCase1548Actor*>(this)));
															#line 12656 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 1608 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		ASSERT(error.present() == allowErrors);
															#line 12684 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1587 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (verbose)
															#line 12694 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			{
															#line 1588 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				printf("Caught error %s\n", e.what());
															#line 12698 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			}
															#line 1590 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			error = e;
															#line 1594 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			i = int();
															#line 1595 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (verbose)
															#line 12706 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			{
															#line 1596 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				printf("Waiting for completions.  Future end states:\n");
															#line 12710 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			}
															#line 1598 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			i = 0;
															#line 12714 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			loopDepth = a_body1loopBody1Catch1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void const& _,int loopDepth) 
	{
															#line 1580 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (allowErrors)
															#line 12729 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		{
															#line 1581 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (verbose)
															#line 12733 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			{
															#line 1582 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				printf("Final wait in case error was injected by the last actor to finish\n");
															#line 12737 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			}
															#line 1584 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			StrictFuture<Void> __when_expr_1 = success(mutex.take());
															#line 1584 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (static_cast<FlowTestCase1548Actor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 12743 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont5when1(__when_expr_1.get(), loopDepth); };
			static_cast<FlowTestCase1548Actor*>(this)->actor_wait_state = 2;
															#line 1584 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase1548Actor, 1, Void >*>(static_cast<FlowTestCase1548Actor*>(this)));
															#line 12748 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont7(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void && _,int loopDepth) 
	{
															#line 1580 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (allowErrors)
															#line 12762 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		{
															#line 1581 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (verbose)
															#line 12766 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			{
															#line 1582 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				printf("Final wait in case error was injected by the last actor to finish\n");
															#line 12770 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			}
															#line 1584 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			StrictFuture<Void> __when_expr_1 = success(mutex.take());
															#line 1584 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (static_cast<FlowTestCase1548Actor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 12776 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont5when1(__when_expr_1.get(), loopDepth); };
			static_cast<FlowTestCase1548Actor*>(this)->actor_wait_state = 2;
															#line 1584 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase1548Actor, 1, Void >*>(static_cast<FlowTestCase1548Actor*>(this)));
															#line 12781 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont7(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase1548Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase1548Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase1548Actor*>(this)->ActorCallback< FlowTestCase1548Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase1548Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase1548", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1548Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1548", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase1548Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase1548", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1548Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1548", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase1548Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase1548", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1548Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1548", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont7(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont8(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont8(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<FlowTestCase1548Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase1548Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase1548Actor*>(this)->ActorCallback< FlowTestCase1548Actor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase1548Actor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase1548", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1548Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1548", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FlowTestCase1548Actor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase1548", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1548Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1548", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FlowTestCase1548Actor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase1548", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1548Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1548", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont10(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1Catch1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1loopBody1(int loopDepth) 
	{
															#line 1598 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!(i < tests.size()))
															#line 12989 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		{
			return a_body1loopBody1Catch1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1599 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		StrictFuture<ErrorOr<Void>> __when_expr_2 = errorOr(tests[i]);
															#line 1599 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (static_cast<FlowTestCase1548Actor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 12997 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1Catch1loopBody1when1(__when_expr_2.get(), loopDepth); };
		static_cast<FlowTestCase1548Actor*>(this)->actor_wait_state = 3;
															#line 1599 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase1548Actor, 2, ErrorOr<Void> >*>(static_cast<FlowTestCase1548Actor*>(this)));
															#line 13002 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1Catch1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1loopBody1cont1(ErrorOr<Void> const& f,int loopDepth) 
	{
															#line 1600 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (verbose)
															#line 13024 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		{
															#line 1601 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			printf("  %d: %s\n", i, f.isError() ? f.getError().what() : "done");
															#line 13028 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		}
															#line 1598 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		++i;
															#line 13032 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopBody1Catch1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1loopBody1cont1(ErrorOr<Void> && f,int loopDepth) 
	{
															#line 1600 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (verbose)
															#line 13041 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		{
															#line 1601 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			printf("  %d: %s\n", i, f.isError() ? f.getError().what() : "done");
															#line 13045 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		}
															#line 1598 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		++i;
															#line 13049 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopBody1Catch1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1loopBody1when1(ErrorOr<Void> const& f,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1loopBody1cont1(f, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1loopBody1when1(ErrorOr<Void> && f,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1loopBody1cont1(std::move(f), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<FlowTestCase1548Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase1548Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase1548Actor*>(this)->ActorCallback< FlowTestCase1548Actor, 2, ErrorOr<Void> >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase1548Actor, 2, ErrorOr<Void> >*,ErrorOr<Void> const& value) 
	{
		fdb_probe_actor_enter("flowTestCase1548", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1548Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1548", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< FlowTestCase1548Actor, 2, ErrorOr<Void> >*,ErrorOr<Void> && value) 
	{
		fdb_probe_actor_enter("flowTestCase1548", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1548Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1548", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< FlowTestCase1548Actor, 2, ErrorOr<Void> >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase1548", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1548Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1548", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 1548 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	UnitTestParameters params;
															#line 1549 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	int count;
															#line 1552 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	bool verboseSetting;
															#line 1554 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	int verboseTestIteration;
															#line 1557 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	bool verbose;
															#line 1564 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowMutex mutex;
															#line 1565 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	std::vector<Future<Void>> tests;
															#line 1567 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	bool allowErrors;
															#line 1572 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Optional<Error> error;
															#line 1594 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	int i;
															#line 13162 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
};
// This generated class is to be used only via flowTestCase1548()
															#line 1548 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase1548Actor final : public Actor<Void>, public ActorCallback< FlowTestCase1548Actor, 0, Void >, public ActorCallback< FlowTestCase1548Actor, 1, Void >, public ActorCallback< FlowTestCase1548Actor, 2, ErrorOr<Void> >, public FastAllocated<FlowTestCase1548Actor>, public FlowTestCase1548ActorState<FlowTestCase1548Actor> {
															#line 13167 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
	using FastAllocated<FlowTestCase1548Actor>::operator new;
	using FastAllocated<FlowTestCase1548Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5129104115276620800UL, 10663673665748959232UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase1548Actor, 0, Void >;
friend struct ActorCallback< FlowTestCase1548Actor, 1, Void >;
friend struct ActorCallback< FlowTestCase1548Actor, 2, ErrorOr<Void> >;
															#line 1548 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase1548Actor(UnitTestParameters const& params) 
															#line 13186 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   FlowTestCase1548ActorState<FlowTestCase1548Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase1548", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1478232379956875008UL, 5182197093383866112UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1548Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase1548");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase1548", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase1548Actor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< FlowTestCase1548Actor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< FlowTestCase1548Actor, 2, ErrorOr<Void> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1548 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> flowTestCase1548( UnitTestParameters const& params ) {
															#line 1548 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new FlowTestCase1548Actor(params));
															#line 13221 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
}
ACTOR_TEST_CASE(flowTestCase1548, "/flow/flow/FlowMutex")

#line 1617 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

using namespace std::chrono_literals;

															#line 13229 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via flowTestCase1620()
															#line 1620 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class FlowTestCase1620Actor>
															#line 1620 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase1620ActorState {
															#line 13236 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
															#line 1620 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase1620ActorState(UnitTestParameters const& params) 
															#line 1620 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 1620 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : params(params),
															#line 1621 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		   exc(1)
															#line 13245 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("flowTestCase1620", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase1620ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase1620", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1622 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			noUnseed = true;
															#line 1623 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ThreadReturnPromiseStream<int> stream;
															#line 1624 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			f = stream.getFuture();
															#line 1625 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			t = exc.post([stream = std::move(stream)]() mutable { for (int i = 0; i < 10; ++i) { stream.send(i); std::cout << "Sent: " << i << std::endl; std::this_thread::sleep_for(10ms); } stream.sendError(end_of_stream()); return Void(); });
															#line 1635 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			n = 0;
															#line 1636 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			;
															#line 13270 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase1620ActorState();
		static_cast<FlowTestCase1620Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1650 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		StrictFuture<Void> __when_expr_2 = t;
															#line 1650 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (static_cast<FlowTestCase1620Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13295 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<FlowTestCase1620Actor*>(this)->actor_wait_state = 3;
															#line 1650 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase1620Actor, 2, Void >*>(static_cast<FlowTestCase1620Actor*>(this)));
															#line 13300 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 1638 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			auto __when_expr_0 = f;
															#line 13317 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			static_assert(std::is_same<decltype(__when_expr_0), FutureStream<int>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<int>>::value, "invalid type");
															#line 1638 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (static_cast<FlowTestCase1620Actor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 13321 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
			static_cast<FlowTestCase1620Actor*>(this)->actor_wait_state = 1;
															#line 1638 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< FlowTestCase1620Actor, 0, int >*>(static_cast<FlowTestCase1620Actor*>(this)));
															#line 13326 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1644 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(e.code() == error_code_end_of_stream);
															#line 1645 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(n == 10);
															#line 13363 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 1639 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		std::cout << "Got: " << i << std::endl;
															#line 1640 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(0.1);
															#line 1640 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (static_cast<FlowTestCase1620Actor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 13382 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<FlowTestCase1620Actor*>(this)->actor_wait_state = 2;
															#line 1640 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase1620Actor, 1, Void >*>(static_cast<FlowTestCase1620Actor*>(this)));
															#line 13387 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(int const& __i,int loopDepth) 
	{
															#line 1638 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		i = __i;
															#line 13396 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(int && __i,int loopDepth) 
	{
		i = std::move(__i);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase1620Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase1620Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase1620Actor*>(this)->ActorSingleCallback< FlowTestCase1620Actor, 0, int >::remove();

	}
	void a_callback_fire(ActorSingleCallback< FlowTestCase1620Actor, 0, int >*,int const& value) 
	{
		fdb_probe_actor_enter("flowTestCase1620", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1620Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1620", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< FlowTestCase1620Actor, 0, int >*,int && value) 
	{
		fdb_probe_actor_enter("flowTestCase1620", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1620Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1620", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< FlowTestCase1620Actor, 0, int >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase1620", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1620Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1620", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 1641 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		ASSERT(i == n);
															#line 1642 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		++n;
															#line 13477 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 1641 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		ASSERT(i == n);
															#line 1642 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		++n;
															#line 13488 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<FlowTestCase1620Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase1620Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase1620Actor*>(this)->ActorCallback< FlowTestCase1620Actor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase1620Actor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase1620", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1620Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1620", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FlowTestCase1620Actor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase1620", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1620Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1620", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FlowTestCase1620Actor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase1620", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1620Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1620", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 1651 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<FlowTestCase1620Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase1620ActorState(); static_cast<FlowTestCase1620Actor*>(this)->destroy(); return 0; }
															#line 13585 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		new (&static_cast<FlowTestCase1620Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase1620ActorState();
		static_cast<FlowTestCase1620Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 1651 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<FlowTestCase1620Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase1620ActorState(); static_cast<FlowTestCase1620Actor*>(this)->destroy(); return 0; }
															#line 13597 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		new (&static_cast<FlowTestCase1620Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase1620ActorState();
		static_cast<FlowTestCase1620Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<FlowTestCase1620Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase1620Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase1620Actor*>(this)->ActorCallback< FlowTestCase1620Actor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase1620Actor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase1620", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1620Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1620", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< FlowTestCase1620Actor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase1620", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1620Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1620", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< FlowTestCase1620Actor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase1620", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1620Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1620", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 1620 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	UnitTestParameters params;
															#line 1621 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	AsyncTaskExecutor exc;
															#line 1624 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	ThreadFutureStream<int> f;
															#line 1625 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Future<Void> t;
															#line 1635 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	int n;
															#line 1638 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	int i;
															#line 13692 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
};
// This generated class is to be used only via flowTestCase1620()
															#line 1620 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase1620Actor final : public Actor<Void>, public ActorSingleCallback< FlowTestCase1620Actor, 0, int >, public ActorCallback< FlowTestCase1620Actor, 1, Void >, public ActorCallback< FlowTestCase1620Actor, 2, Void >, public FastAllocated<FlowTestCase1620Actor>, public FlowTestCase1620ActorState<FlowTestCase1620Actor> {
															#line 13697 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
	using FastAllocated<FlowTestCase1620Actor>::operator new;
	using FastAllocated<FlowTestCase1620Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1586296414368516864UL, 18348830863328380672UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< FlowTestCase1620Actor, 0, int >;
friend struct ActorCallback< FlowTestCase1620Actor, 1, Void >;
friend struct ActorCallback< FlowTestCase1620Actor, 2, Void >;
															#line 1620 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase1620Actor(UnitTestParameters const& params) 
															#line 13716 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   FlowTestCase1620ActorState<FlowTestCase1620Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase1620", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10648582079355331840UL, 8629153115587737344UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1620Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase1620");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase1620", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< FlowTestCase1620Actor, 0, int >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< FlowTestCase1620Actor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< FlowTestCase1620Actor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1620 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> flowTestCase1620( UnitTestParameters const& params ) {
															#line 1620 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new FlowTestCase1620Actor(params));
															#line 13751 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
}
ACTOR_TEST_CASE(flowTestCase1620, "/flow/thread/ThreadReturnPromiseStream_Simple")

#line 1653 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 13757 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via flowTestCase1654()
															#line 1654 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class FlowTestCase1654Actor>
															#line 1654 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase1654ActorState {
															#line 13764 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
															#line 1654 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase1654ActorState(UnitTestParameters const& params) 
															#line 1654 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 1654 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : params(params),
															#line 1655 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		   exc(1)
															#line 13773 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("flowTestCase1654", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase1654ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase1654", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1656 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			noUnseed = true;
															#line 1657 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ThreadReturnPromiseStream<int> stream;
															#line 1658 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			f = stream.getFuture();
															#line 1659 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			t = exc.post([stream = std::move(stream)]() mutable { for (int i = 0; i <= 3; ++i) { stream.send(i); std::this_thread::sleep_for(100ms); } stream.sendError(end_of_stream()); return Void(); });
															#line 1668 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			auto __when_expr_0 = f;
															#line 13796 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			static_assert(std::is_same<decltype(__when_expr_0), FutureStream<int>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<int>>::value, "invalid type");
															#line 1668 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (static_cast<FlowTestCase1654Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13800 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.pop(), loopDepth); };
			static_cast<FlowTestCase1654Actor*>(this)->actor_wait_state = 1;
															#line 1668 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< FlowTestCase1654Actor, 0, int >*>(static_cast<FlowTestCase1654Actor*>(this)));
															#line 13805 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase1654ActorState();
		static_cast<FlowTestCase1654Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int const& r0,int loopDepth) 
	{
															#line 1669 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		ASSERT(r0 == 0);
															#line 1670 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		auto __when_expr_1 = f;
															#line 13830 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		static_assert(std::is_same<decltype(__when_expr_1), FutureStream<int>>::value || std::is_same<decltype(__when_expr_1), ThreadFutureStream<int>>::value, "invalid type");
															#line 1670 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (static_cast<FlowTestCase1654Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13834 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.pop(), loopDepth); };
		static_cast<FlowTestCase1654Actor*>(this)->actor_wait_state = 2;
															#line 1670 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorSingleCallback< FlowTestCase1654Actor, 1, int >*>(static_cast<FlowTestCase1654Actor*>(this)));
															#line 13839 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int && r0,int loopDepth) 
	{
															#line 1669 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		ASSERT(r0 == 0);
															#line 1670 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		auto __when_expr_1 = f;
															#line 13850 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		static_assert(std::is_same<decltype(__when_expr_1), FutureStream<int>>::value || std::is_same<decltype(__when_expr_1), ThreadFutureStream<int>>::value, "invalid type");
															#line 1670 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (static_cast<FlowTestCase1654Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13854 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.pop(), loopDepth); };
		static_cast<FlowTestCase1654Actor*>(this)->actor_wait_state = 2;
															#line 1670 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorSingleCallback< FlowTestCase1654Actor, 1, int >*>(static_cast<FlowTestCase1654Actor*>(this)));
															#line 13859 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(int const& r0,int loopDepth) 
	{
		loopDepth = a_body1cont1(r0, loopDepth);

		return loopDepth;
	}
	int a_body1when1(int && r0,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(r0), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase1654Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase1654Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase1654Actor*>(this)->ActorSingleCallback< FlowTestCase1654Actor, 0, int >::remove();

	}
	void a_callback_fire(ActorSingleCallback< FlowTestCase1654Actor, 0, int >*,int const& value) 
	{
		fdb_probe_actor_enter("flowTestCase1654", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1654Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1654", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< FlowTestCase1654Actor, 0, int >*,int && value) 
	{
		fdb_probe_actor_enter("flowTestCase1654", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1654Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1654", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< FlowTestCase1654Actor, 0, int >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase1654", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1654Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1654", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int const& r1,int loopDepth) 
	{
															#line 1671 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		ASSERT(r1 == 1);
															#line 1672 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		auto __when_expr_2 = f;
															#line 13945 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		static_assert(std::is_same<decltype(__when_expr_2), FutureStream<int>>::value || std::is_same<decltype(__when_expr_2), ThreadFutureStream<int>>::value, "invalid type");
															#line 1672 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (static_cast<FlowTestCase1654Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13949 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.pop(), loopDepth); };
		static_cast<FlowTestCase1654Actor*>(this)->actor_wait_state = 3;
															#line 1672 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorSingleCallback< FlowTestCase1654Actor, 2, int >*>(static_cast<FlowTestCase1654Actor*>(this)));
															#line 13954 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(int && r1,int loopDepth) 
	{
															#line 1671 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		ASSERT(r1 == 1);
															#line 1672 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		auto __when_expr_2 = f;
															#line 13965 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		static_assert(std::is_same<decltype(__when_expr_2), FutureStream<int>>::value || std::is_same<decltype(__when_expr_2), ThreadFutureStream<int>>::value, "invalid type");
															#line 1672 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (static_cast<FlowTestCase1654Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13969 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.pop(), loopDepth); };
		static_cast<FlowTestCase1654Actor*>(this)->actor_wait_state = 3;
															#line 1672 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorSingleCallback< FlowTestCase1654Actor, 2, int >*>(static_cast<FlowTestCase1654Actor*>(this)));
															#line 13974 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(int const& r1,int loopDepth) 
	{
		loopDepth = a_body1cont2(r1, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(int && r1,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(r1), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<FlowTestCase1654Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase1654Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase1654Actor*>(this)->ActorSingleCallback< FlowTestCase1654Actor, 1, int >::remove();

	}
	void a_callback_fire(ActorSingleCallback< FlowTestCase1654Actor, 1, int >*,int const& value) 
	{
		fdb_probe_actor_enter("flowTestCase1654", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1654Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1654", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorSingleCallback< FlowTestCase1654Actor, 1, int >*,int && value) 
	{
		fdb_probe_actor_enter("flowTestCase1654", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1654Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1654", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorSingleCallback< FlowTestCase1654Actor, 1, int >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase1654", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1654Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1654", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(int const& r2,int loopDepth) 
	{
															#line 1673 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		ASSERT(r2 == 2);
															#line 1674 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		StrictFuture<Void> __when_expr_3 = delay(1.0);
															#line 1674 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (static_cast<FlowTestCase1654Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14062 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<FlowTestCase1654Actor*>(this)->actor_wait_state = 4;
															#line 1674 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase1654Actor, 3, Void >*>(static_cast<FlowTestCase1654Actor*>(this)));
															#line 14067 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(int && r2,int loopDepth) 
	{
															#line 1673 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		ASSERT(r2 == 2);
															#line 1674 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		StrictFuture<Void> __when_expr_3 = delay(1.0);
															#line 1674 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (static_cast<FlowTestCase1654Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14080 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<FlowTestCase1654Actor*>(this)->actor_wait_state = 4;
															#line 1674 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase1654Actor, 3, Void >*>(static_cast<FlowTestCase1654Actor*>(this)));
															#line 14085 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(int const& r2,int loopDepth) 
	{
		loopDepth = a_body1cont3(r2, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(int && r2,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(r2), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<FlowTestCase1654Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase1654Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase1654Actor*>(this)->ActorSingleCallback< FlowTestCase1654Actor, 2, int >::remove();

	}
	void a_callback_fire(ActorSingleCallback< FlowTestCase1654Actor, 2, int >*,int const& value) 
	{
		fdb_probe_actor_enter("flowTestCase1654", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1654Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1654", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorSingleCallback< FlowTestCase1654Actor, 2, int >*,int && value) 
	{
		fdb_probe_actor_enter("flowTestCase1654", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1654Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1654", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorSingleCallback< FlowTestCase1654Actor, 2, int >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase1654", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1654Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1654", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 1675 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		auto __when_expr_4 = f;
															#line 14169 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		static_assert(std::is_same<decltype(__when_expr_4), FutureStream<int>>::value || std::is_same<decltype(__when_expr_4), ThreadFutureStream<int>>::value, "invalid type");
															#line 1675 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (static_cast<FlowTestCase1654Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14173 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont4when1(__when_expr_4.pop(), loopDepth); };
		static_cast<FlowTestCase1654Actor*>(this)->actor_wait_state = 5;
															#line 1675 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorSingleCallback< FlowTestCase1654Actor, 4, int >*>(static_cast<FlowTestCase1654Actor*>(this)));
															#line 14178 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 1675 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		auto __when_expr_4 = f;
															#line 14187 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		static_assert(std::is_same<decltype(__when_expr_4), FutureStream<int>>::value || std::is_same<decltype(__when_expr_4), ThreadFutureStream<int>>::value, "invalid type");
															#line 1675 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (static_cast<FlowTestCase1654Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14191 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont4when1(__when_expr_4.pop(), loopDepth); };
		static_cast<FlowTestCase1654Actor*>(this)->actor_wait_state = 5;
															#line 1675 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorSingleCallback< FlowTestCase1654Actor, 4, int >*>(static_cast<FlowTestCase1654Actor*>(this)));
															#line 14196 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<FlowTestCase1654Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase1654Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase1654Actor*>(this)->ActorCallback< FlowTestCase1654Actor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase1654Actor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase1654", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1654Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1654", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< FlowTestCase1654Actor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase1654", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1654Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1654", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< FlowTestCase1654Actor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase1654", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1654Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1654", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont5(int const& r3,int loopDepth) 
	{
															#line 1676 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		ASSERT(r3 == 3);
															#line 1677 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		StrictFuture<Void> __when_expr_5 = t;
															#line 1677 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (static_cast<FlowTestCase1654Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14284 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont5when1(__when_expr_5.get(), loopDepth); };
		static_cast<FlowTestCase1654Actor*>(this)->actor_wait_state = 6;
															#line 1677 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase1654Actor, 5, Void >*>(static_cast<FlowTestCase1654Actor*>(this)));
															#line 14289 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5(int && r3,int loopDepth) 
	{
															#line 1676 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		ASSERT(r3 == 3);
															#line 1677 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		StrictFuture<Void> __when_expr_5 = t;
															#line 1677 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (static_cast<FlowTestCase1654Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14302 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont5when1(__when_expr_5.get(), loopDepth); };
		static_cast<FlowTestCase1654Actor*>(this)->actor_wait_state = 6;
															#line 1677 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase1654Actor, 5, Void >*>(static_cast<FlowTestCase1654Actor*>(this)));
															#line 14307 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4when1(int const& r3,int loopDepth) 
	{
		loopDepth = a_body1cont5(r3, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(int && r3,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(r3), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<FlowTestCase1654Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase1654Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase1654Actor*>(this)->ActorSingleCallback< FlowTestCase1654Actor, 4, int >::remove();

	}
	void a_callback_fire(ActorSingleCallback< FlowTestCase1654Actor, 4, int >*,int const& value) 
	{
		fdb_probe_actor_enter("flowTestCase1654", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1654Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1654", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorSingleCallback< FlowTestCase1654Actor, 4, int >*,int && value) 
	{
		fdb_probe_actor_enter("flowTestCase1654", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1654Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1654", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorSingleCallback< FlowTestCase1654Actor, 4, int >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase1654", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1654Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1654", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 1678 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<FlowTestCase1654Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase1654ActorState(); static_cast<FlowTestCase1654Actor*>(this)->destroy(); return 0; }
															#line 14391 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		new (&static_cast<FlowTestCase1654Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase1654ActorState();
		static_cast<FlowTestCase1654Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 1678 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<FlowTestCase1654Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase1654ActorState(); static_cast<FlowTestCase1654Actor*>(this)->destroy(); return 0; }
															#line 14403 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		new (&static_cast<FlowTestCase1654Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase1654ActorState();
		static_cast<FlowTestCase1654Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<FlowTestCase1654Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase1654Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase1654Actor*>(this)->ActorCallback< FlowTestCase1654Actor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase1654Actor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase1654", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1654Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1654", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< FlowTestCase1654Actor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase1654", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1654Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1654", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< FlowTestCase1654Actor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase1654", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1654Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1654", reinterpret_cast<unsigned long>(this), 5);

	}
															#line 1654 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	UnitTestParameters params;
															#line 1655 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	AsyncTaskExecutor exc;
															#line 1658 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	ThreadFutureStream<int> f;
															#line 1659 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Future<Void> t;
															#line 14494 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
};
// This generated class is to be used only via flowTestCase1654()
															#line 1654 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase1654Actor final : public Actor<Void>, public ActorSingleCallback< FlowTestCase1654Actor, 0, int >, public ActorSingleCallback< FlowTestCase1654Actor, 1, int >, public ActorSingleCallback< FlowTestCase1654Actor, 2, int >, public ActorCallback< FlowTestCase1654Actor, 3, Void >, public ActorSingleCallback< FlowTestCase1654Actor, 4, int >, public ActorCallback< FlowTestCase1654Actor, 5, Void >, public FastAllocated<FlowTestCase1654Actor>, public FlowTestCase1654ActorState<FlowTestCase1654Actor> {
															#line 14499 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
	using FastAllocated<FlowTestCase1654Actor>::operator new;
	using FastAllocated<FlowTestCase1654Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13497485049376901888UL, 7407169233711089152UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< FlowTestCase1654Actor, 0, int >;
friend struct ActorSingleCallback< FlowTestCase1654Actor, 1, int >;
friend struct ActorSingleCallback< FlowTestCase1654Actor, 2, int >;
friend struct ActorCallback< FlowTestCase1654Actor, 3, Void >;
friend struct ActorSingleCallback< FlowTestCase1654Actor, 4, int >;
friend struct ActorCallback< FlowTestCase1654Actor, 5, Void >;
															#line 1654 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase1654Actor(UnitTestParameters const& params) 
															#line 14521 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   FlowTestCase1654ActorState<FlowTestCase1654Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase1654", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(251278335264096000UL, 3463941444734233856UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1654Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase1654");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase1654", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< FlowTestCase1654Actor, 0, int >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorSingleCallback< FlowTestCase1654Actor, 1, int >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorSingleCallback< FlowTestCase1654Actor, 2, int >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< FlowTestCase1654Actor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorSingleCallback< FlowTestCase1654Actor, 4, int >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< FlowTestCase1654Actor, 5, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1654 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> flowTestCase1654( UnitTestParameters const& params ) {
															#line 1654 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new FlowTestCase1654Actor(params));
															#line 14559 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
}
ACTOR_TEST_CASE(flowTestCase1654, "/flow/thread/ThreadReturnPromiseStream_Seq")

#line 1680 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 14565 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via flowTestCase1681()
															#line 1681 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class FlowTestCase1681Actor>
															#line 1681 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase1681ActorState {
															#line 14572 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
															#line 1681 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase1681ActorState(UnitTestParameters const& params) 
															#line 1681 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 1681 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : params(params),
															#line 1682 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		   exc(1)
															#line 14581 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("flowTestCase1681", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase1681ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase1681", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1683 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			noUnseed = true;
															#line 14596 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			{
															#line 1686 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				ThreadReturnPromiseStream<int> s1;
															#line 1687 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				f1 = s1.getFuture();
															#line 1688 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				t1 = exc.post([s1 = std::move(s1)]() mutable { std::this_thread::sleep_for(2s); return Void(); });
															#line 14604 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
				try {
															#line 1694 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					auto __when_expr_0 = f1;
															#line 14608 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
					static_assert(std::is_same<decltype(__when_expr_0), FutureStream<int>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<int>>::value, "invalid type");
															#line 1694 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					if (static_cast<FlowTestCase1681Actor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 14612 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
					if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.pop(), loopDepth); };
					static_cast<FlowTestCase1681Actor*>(this)->actor_wait_state = 1;
															#line 1694 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< FlowTestCase1681Actor, 0, int >*>(static_cast<FlowTestCase1681Actor*>(this)));
															#line 14617 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
					loopDepth = 0;
				}
				catch (Error& error) {
					loopDepth = a_body1Catch2(error, loopDepth);
				} catch (...) {
					loopDepth = a_body1Catch2(unknown_error(), loopDepth);
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase1681ActorState();
		static_cast<FlowTestCase1681Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
		{
															#line 1704 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ThreadReturnPromiseStream<int> s2;
															#line 1705 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			f2 = s2.getFuture();
															#line 1706 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			t2 = exc.post([s2 = std::move(s2)]() mutable { std::this_thread::sleep_for(2s); s2.sendError(transaction_too_old()); return Void(); });
															#line 14652 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			try {
															#line 1713 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				auto __when_expr_2 = f2;
															#line 14656 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
				static_assert(std::is_same<decltype(__when_expr_2), FutureStream<int>>::value || std::is_same<decltype(__when_expr_2), ThreadFutureStream<int>>::value, "invalid type");
															#line 1713 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				if (static_cast<FlowTestCase1681Actor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 14660 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
				if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1when1(__when_expr_2.pop(), loopDepth); };
				static_cast<FlowTestCase1681Actor*>(this)->actor_wait_state = 3;
															#line 1713 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				__when_expr_2.addCallbackAndClear(static_cast<ActorSingleCallback< FlowTestCase1681Actor, 2, int >*>(static_cast<FlowTestCase1681Actor*>(this)));
															#line 14665 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1cont1Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
			}
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 1700 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		StrictFuture<Void> __when_expr_1 = t1;
															#line 1700 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (static_cast<FlowTestCase1681Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14683 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<FlowTestCase1681Actor*>(this)->actor_wait_state = 2;
															#line 1700 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase1681Actor, 1, Void >*>(static_cast<FlowTestCase1681Actor*>(this)));
															#line 14688 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1697 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(e.code() == error_code_broken_promise);
															#line 14698 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			loopDepth = a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3(int const& _,int loopDepth) 
	{
															#line 1695 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		ASSERT(false);
															#line 14713 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(int && _,int loopDepth) 
	{
															#line 1695 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		ASSERT(false);
															#line 14722 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1when1(int const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(int && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase1681Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase1681Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase1681Actor*>(this)->ActorSingleCallback< FlowTestCase1681Actor, 0, int >::remove();

	}
	void a_callback_fire(ActorSingleCallback< FlowTestCase1681Actor, 0, int >*,int const& value) 
	{
		fdb_probe_actor_enter("flowTestCase1681", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1681Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1681", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< FlowTestCase1681Actor, 0, int >*,int && value) 
	{
		fdb_probe_actor_enter("flowTestCase1681", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1681Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1681", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< FlowTestCase1681Actor, 0, int >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase1681", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1681Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1681", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<FlowTestCase1681Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase1681Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase1681Actor*>(this)->ActorCallback< FlowTestCase1681Actor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase1681Actor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase1681", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1681Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1681", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FlowTestCase1681Actor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase1681", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1681Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1681", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FlowTestCase1681Actor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase1681", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1681Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1681", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont7(int loopDepth) 
	{
															#line 1722 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<FlowTestCase1681Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase1681ActorState(); static_cast<FlowTestCase1681Actor*>(this)->destroy(); return 0; }
															#line 14906 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		new (&static_cast<FlowTestCase1681Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase1681ActorState();
		static_cast<FlowTestCase1681Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont8(int loopDepth) 
	{
															#line 1719 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		StrictFuture<Void> __when_expr_3 = t2;
															#line 1719 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (static_cast<FlowTestCase1681Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14920 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont8when1(__when_expr_3.get(), loopDepth); };
		static_cast<FlowTestCase1681Actor*>(this)->actor_wait_state = 4;
															#line 1719 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase1681Actor, 3, Void >*>(static_cast<FlowTestCase1681Actor*>(this)));
															#line 14925 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1716 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(e.code() == error_code_transaction_too_old);
															#line 14935 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			loopDepth = a_body1cont8(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont9(int const& _,int loopDepth) 
	{
															#line 1714 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		ASSERT(false);
															#line 14950 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		loopDepth = a_body1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1cont9(int && _,int loopDepth) 
	{
															#line 1714 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		ASSERT(false);
															#line 14959 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		loopDepth = a_body1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(int const& _,int loopDepth) 
	{
		loopDepth = a_body1cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(int && _,int loopDepth) 
	{
		loopDepth = a_body1cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<FlowTestCase1681Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase1681Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase1681Actor*>(this)->ActorSingleCallback< FlowTestCase1681Actor, 2, int >::remove();

	}
	void a_callback_fire(ActorSingleCallback< FlowTestCase1681Actor, 2, int >*,int const& value) 
	{
		fdb_probe_actor_enter("flowTestCase1681", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1681Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1681", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorSingleCallback< FlowTestCase1681Actor, 2, int >*,int && value) 
	{
		fdb_probe_actor_enter("flowTestCase1681", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1681Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1681", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorSingleCallback< FlowTestCase1681Actor, 2, int >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase1681", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1681Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1681", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont11(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont8(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont12(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<FlowTestCase1681Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase1681Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase1681Actor*>(this)->ActorCallback< FlowTestCase1681Actor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase1681Actor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase1681", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1681Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1681", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< FlowTestCase1681Actor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase1681", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1681Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1681", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< FlowTestCase1681Actor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase1681", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1681Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1681", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 1681 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	UnitTestParameters params;
															#line 1682 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	AsyncTaskExecutor exc;
															#line 1687 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	ThreadFutureStream<int> f1;
															#line 1688 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Future<Void> t1;
															#line 1705 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	ThreadFutureStream<int> f2;
															#line 1706 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Future<Void> t2;
															#line 15151 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
};
// This generated class is to be used only via flowTestCase1681()
															#line 1681 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase1681Actor final : public Actor<Void>, public ActorSingleCallback< FlowTestCase1681Actor, 0, int >, public ActorCallback< FlowTestCase1681Actor, 1, Void >, public ActorSingleCallback< FlowTestCase1681Actor, 2, int >, public ActorCallback< FlowTestCase1681Actor, 3, Void >, public FastAllocated<FlowTestCase1681Actor>, public FlowTestCase1681ActorState<FlowTestCase1681Actor> {
															#line 15156 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
	using FastAllocated<FlowTestCase1681Actor>::operator new;
	using FastAllocated<FlowTestCase1681Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(18018569867726085120UL, 191124570734680576UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< FlowTestCase1681Actor, 0, int >;
friend struct ActorCallback< FlowTestCase1681Actor, 1, Void >;
friend struct ActorSingleCallback< FlowTestCase1681Actor, 2, int >;
friend struct ActorCallback< FlowTestCase1681Actor, 3, Void >;
															#line 1681 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase1681Actor(UnitTestParameters const& params) 
															#line 15176 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   FlowTestCase1681ActorState<FlowTestCase1681Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase1681", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10660216062306209024UL, 14050239709078717696UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1681Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase1681");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase1681", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< FlowTestCase1681Actor, 0, int >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< FlowTestCase1681Actor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorSingleCallback< FlowTestCase1681Actor, 2, int >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< FlowTestCase1681Actor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1681 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> flowTestCase1681( UnitTestParameters const& params ) {
															#line 1681 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new FlowTestCase1681Actor(params));
															#line 15212 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
}
ACTOR_TEST_CASE(flowTestCase1681, "/flow/thread/ThreadReturnPromiseStream_Error")

#line 1724 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 15218 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via flowTestCase1725()
															#line 1725 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class FlowTestCase1725Actor>
															#line 1725 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase1725ActorState {
															#line 15225 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
															#line 1725 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase1725ActorState(UnitTestParameters const& params) 
															#line 1725 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 1725 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : params(params)
															#line 15232 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("flowTestCase1725", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase1725ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase1725", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1726 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			noUnseed = true;
															#line 15247 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			{
															#line 1729 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				std::cout << "ThreadReturnPromiseStream with future > 0, promise == 0, end_of_stream sent\n";
															#line 1732 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				fs1 = ([]() { ThreadReturnPromiseStream<int> p; auto ret = p.getFuture(); for (int i = 0; i < 10; i++) { p.send(i); } p.sendError(end_of_stream()); ASSERT(p.getFutureReferenceCount() == 1); return ret; })();
															#line 1743 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				StrictFuture<Void> __when_expr_0 = delay(1);
															#line 1743 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				if (static_cast<FlowTestCase1725Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15257 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<FlowTestCase1725Actor*>(this)->actor_wait_state = 1;
															#line 1743 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase1725Actor, 0, Void >*>(static_cast<FlowTestCase1725Actor*>(this)));
															#line 15262 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase1725ActorState();
		static_cast<FlowTestCase1725Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1760 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		std::cout << "ThreadReturnPromiseStream with future > 0,  promise == 0, no end_of_stream\n";
															#line 15286 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		{
															#line 1764 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			fs2 = ([]() { ThreadReturnPromiseStream<int> p; auto ret = p.getFuture(); for (int i = 0; i < 10; i++) { p.send(i); } ASSERT(p.getFutureReferenceCount() == 1); return ret; })();
															#line 1774 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			StrictFuture<Void> __when_expr_2 = delay(1);
															#line 1774 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (static_cast<FlowTestCase1725Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15294 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1when1(__when_expr_2.get(), loopDepth); };
			static_cast<FlowTestCase1725Actor*>(this)->actor_wait_state = 3;
															#line 1774 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase1725Actor, 2, Void >*>(static_cast<FlowTestCase1725Actor*>(this)));
															#line 15299 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 1745 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		recvd = 0;
															#line 15309 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		try {
															#line 1747 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			;
															#line 15313 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			loopDepth = a_body1cont2loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont2Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 1745 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		recvd = 0;
															#line 15328 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		try {
															#line 1747 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			;
															#line 15332 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			loopDepth = a_body1cont2loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont2Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase1725Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase1725Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase1725Actor*>(this)->ActorCallback< FlowTestCase1725Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase1725Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase1725", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1725Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1725", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase1725Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase1725", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1725Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1725", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase1725Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase1725", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1725Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1725", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2Catch1(const Error& err,int loopDepth=0) 
	{
		try {
															#line 1752 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (err.code() == error_code_end_of_stream)
															#line 15429 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			{
															#line 1753 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				ASSERT_EQ(recvd, 10);
															#line 15433 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			}
			else
			{
															#line 1755 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				ASSERT(false);
															#line 15439 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			}
			loopDepth = a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1(int loopDepth) 
	{
															#line 1748 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		auto __when_expr_1 = fs1;
															#line 15462 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		static_assert(std::is_same<decltype(__when_expr_1), FutureStream<int>>::value || std::is_same<decltype(__when_expr_1), ThreadFutureStream<int>>::value, "invalid type");
															#line 1748 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (static_cast<FlowTestCase1725Actor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 15466 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont2Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when1(__when_expr_1.pop(), loopDepth); };
		static_cast<FlowTestCase1725Actor*>(this)->actor_wait_state = 2;
															#line 1748 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorSingleCallback< FlowTestCase1725Actor, 1, int >*>(static_cast<FlowTestCase1725Actor*>(this)));
															#line 15471 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(int const& _,int loopDepth) 
	{
															#line 1749 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		recvd += 1;
															#line 15480 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(int && _,int loopDepth) 
	{
															#line 1749 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		recvd += 1;
															#line 15489 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(int const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(int && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<FlowTestCase1725Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase1725Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase1725Actor*>(this)->ActorSingleCallback< FlowTestCase1725Actor, 1, int >::remove();

	}
	void a_callback_fire(ActorSingleCallback< FlowTestCase1725Actor, 1, int >*,int const& value) 
	{
		fdb_probe_actor_enter("flowTestCase1725", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1725Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1725", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorSingleCallback< FlowTestCase1725Actor, 1, int >*,int && value) 
	{
		fdb_probe_actor_enter("flowTestCase1725", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1725Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1725", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorSingleCallback< FlowTestCase1725Actor, 1, int >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase1725", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1725Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1725", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(int loopDepth) 
	{
															#line 1791 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<FlowTestCase1725Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase1725ActorState(); static_cast<FlowTestCase1725Actor*>(this)->destroy(); return 0; }
															#line 15573 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		new (&static_cast<FlowTestCase1725Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase1725ActorState();
		static_cast<FlowTestCase1725Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
		try {
															#line 1777 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			;
															#line 15586 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			loopDepth = a_body1cont6loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont6Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont6Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
		try {
															#line 1777 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			;
															#line 15602 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			loopDepth = a_body1cont6loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont6Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont6Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<FlowTestCase1725Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase1725Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase1725Actor*>(this)->ActorCallback< FlowTestCase1725Actor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase1725Actor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase1725", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1725Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1725", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< FlowTestCase1725Actor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase1725", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1725Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1725", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< FlowTestCase1725Actor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase1725", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1725Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1725", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont7(int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont6Catch1(const Error& err,int loopDepth=0) 
	{
		try {
															#line 1787 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(err.code() == error_code_broken_promise);
															#line 15699 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
			loopDepth = a_body1cont7(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont8(int loopDepth) 
	{
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont6loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1(int loopDepth) 
	{
															#line 1779 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		auto __when_expr_3 = fs2;
															#line 15727 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		static_assert(std::is_same<decltype(__when_expr_3), FutureStream<int>>::value || std::is_same<decltype(__when_expr_3), ThreadFutureStream<int>>::value, "invalid type");
															#line 1778 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (static_cast<FlowTestCase1725Actor*>(this)->actor_wait_state < 0) return a_body1cont6Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 15731 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont6Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont6loopBody1when1(__when_expr_3.pop(), loopDepth); };
															#line 1780 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		StrictFuture<Void> __when_expr_4 = delay(1);
															#line 15735 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont6Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont6loopBody1when2(__when_expr_4.get(), loopDepth); };
		static_cast<FlowTestCase1725Actor*>(this)->actor_wait_state = 4;
															#line 1779 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorSingleCallback< FlowTestCase1725Actor, 3, int >*>(static_cast<FlowTestCase1725Actor*>(this)));
															#line 1780 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase1725Actor, 4, Void >*>(static_cast<FlowTestCase1725Actor*>(this)));
															#line 15742 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6break1(int loopDepth) 
	{
		try {
			return a_body1cont8(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont6Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont6Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont6loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont6loopHead1(0);

		return loopDepth;
	}
	int a_body1cont6loopBody1when1(int const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1when1(int && _,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1when2(Void const& _,int loopDepth) 
	{
															#line 1781 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		ASSERT(false);
															#line 15782 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		return a_body1cont6break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont6loopBody1when2(Void && _,int loopDepth) 
	{
															#line 1781 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		ASSERT(false);
															#line 15791 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		return a_body1cont6break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<FlowTestCase1725Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase1725Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase1725Actor*>(this)->ActorSingleCallback< FlowTestCase1725Actor, 3, int >::remove();
		static_cast<FlowTestCase1725Actor*>(this)->ActorCallback< FlowTestCase1725Actor, 4, Void >::remove();

	}
	void a_callback_fire(ActorSingleCallback< FlowTestCase1725Actor, 3, int >*,int const& value) 
	{
		fdb_probe_actor_enter("flowTestCase1725", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1725Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont6loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont6Catch1(error, 0);
		} catch (...) {
			a_body1cont6Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1725", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorSingleCallback< FlowTestCase1725Actor, 3, int >*,int && value) 
	{
		fdb_probe_actor_enter("flowTestCase1725", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1725Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont6loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont6Catch1(error, 0);
		} catch (...) {
			a_body1cont6Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1725", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorSingleCallback< FlowTestCase1725Actor, 3, int >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase1725", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1725Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont6Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont6Catch1(error, 0);
		} catch (...) {
			a_body1cont6Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1725", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< FlowTestCase1725Actor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase1725", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1725Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont6loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1cont6Catch1(error, 0);
		} catch (...) {
			a_body1cont6Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1725", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< FlowTestCase1725Actor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase1725", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1725Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont6loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont6Catch1(error, 0);
		} catch (...) {
			a_body1cont6Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1725", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< FlowTestCase1725Actor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase1725", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1725Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont6Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont6Catch1(error, 0);
		} catch (...) {
			a_body1cont6Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1725", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont9(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont7(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 1725 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	UnitTestParameters params;
															#line 1732 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	ThreadFutureStream<int> fs1;
															#line 1745 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	int recvd;
															#line 1764 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	ThreadFutureStream<int> fs2;
															#line 15938 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
};
// This generated class is to be used only via flowTestCase1725()
															#line 1725 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase1725Actor final : public Actor<Void>, public ActorCallback< FlowTestCase1725Actor, 0, Void >, public ActorSingleCallback< FlowTestCase1725Actor, 1, int >, public ActorCallback< FlowTestCase1725Actor, 2, Void >, public ActorSingleCallback< FlowTestCase1725Actor, 3, int >, public ActorCallback< FlowTestCase1725Actor, 4, Void >, public FastAllocated<FlowTestCase1725Actor>, public FlowTestCase1725ActorState<FlowTestCase1725Actor> {
															#line 15943 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
public:
	using FastAllocated<FlowTestCase1725Actor>::operator new;
	using FastAllocated<FlowTestCase1725Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15849519580017426688UL, 12908149694379704576UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase1725Actor, 0, Void >;
friend struct ActorSingleCallback< FlowTestCase1725Actor, 1, int >;
friend struct ActorCallback< FlowTestCase1725Actor, 2, Void >;
friend struct ActorSingleCallback< FlowTestCase1725Actor, 3, int >;
friend struct ActorCallback< FlowTestCase1725Actor, 4, Void >;
															#line 1725 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase1725Actor(UnitTestParameters const& params) 
															#line 15964 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   FlowTestCase1725ActorState<FlowTestCase1725Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase1725", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17807725085952758528UL, 14127676781542373120UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1725Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase1725");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase1725", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase1725Actor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorSingleCallback< FlowTestCase1725Actor, 1, int >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< FlowTestCase1725Actor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorSingleCallback< FlowTestCase1725Actor, 3, int >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1725 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> flowTestCase1725( UnitTestParameters const& params ) {
															#line 1725 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new FlowTestCase1725Actor(params));
															#line 16000 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp.py_gen"
}
ACTOR_TEST_CASE(flowTestCase1725, "/flow/IThreadPool/ThreadReturnPromiseStream_DestroyPromise")

#line 1793 "/codebuild/output/src69561759/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
