// Generated by the gRPC C++ plugin.
// If you make any local change, they will be lost.
// source: control_service.proto
#ifndef GRPC_control_5fservice_2eproto__INCLUDED
#define GRPC_control_5fservice_2eproto__INCLUDED

#include "control_service.pb.h"

#include <functional>
#include <grpcpp/generic/async_generic_service.h>
#include <grpcpp/support/async_stream.h>
#include <grpcpp/support/async_unary_call.h>
#include <grpcpp/support/client_callback.h>
#include <grpcpp/client_context.h>
#include <grpcpp/completion_queue.h>
#include <grpcpp/support/message_allocator.h>
#include <grpcpp/support/method_handler.h>
#include <grpcpp/impl/proto_utils.h>
#include <grpcpp/impl/rpc_method.h>
#include <grpcpp/support/server_callback.h>
#include <grpcpp/impl/server_callback_handlers.h>
#include <grpcpp/server_context.h>
#include <grpcpp/impl/service_type.h>
#include <grpcpp/support/status.h>
#include <grpcpp/support/stub_options.h>
#include <grpcpp/support/sync_stream.h>

namespace fdbctl {

// ------ RPCs ------
//
// ControlService provides administrative and management operations for a FoundationDB cluster.
// This service allows control over cluster configuration, coordinator management, worker lifecycle,
// and monitoring of cluster health and status.
class ControlService final {
 public:
  static constexpr char const* service_full_name() {
    return "fdbctl.ControlService";
  }
  class StubInterface {
   public:
    virtual ~StubInterface() {}
    // Retrieves the current list of coordinators for the cluster.
    virtual ::grpc::Status GetCoordinators(::grpc::ClientContext* context, const ::fdbctl::GetCoordinatorsRequest& request, ::fdbctl::GetCoordinatorsReply* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::fdbctl::GetCoordinatorsReply>> AsyncGetCoordinators(::grpc::ClientContext* context, const ::fdbctl::GetCoordinatorsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::fdbctl::GetCoordinatorsReply>>(AsyncGetCoordinatorsRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::fdbctl::GetCoordinatorsReply>> PrepareAsyncGetCoordinators(::grpc::ClientContext* context, const ::fdbctl::GetCoordinatorsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::fdbctl::GetCoordinatorsReply>>(PrepareAsyncGetCoordinatorsRaw(context, request, cq));
    }
    // Changes the cluster's coordinators. This is a critical operation that should be
    // performed carefully as coordinators maintain cluster configuration state.
    virtual ::grpc::Status ChangeCoordinators(::grpc::ClientContext* context, const ::fdbctl::ChangeCoordinatorsRequest& request, ::fdbctl::ChangeCoordinatorsReply* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::fdbctl::ChangeCoordinatorsReply>> AsyncChangeCoordinators(::grpc::ClientContext* context, const ::fdbctl::ChangeCoordinatorsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::fdbctl::ChangeCoordinatorsReply>>(AsyncChangeCoordinatorsRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::fdbctl::ChangeCoordinatorsReply>> PrepareAsyncChangeCoordinators(::grpc::ClientContext* context, const ::fdbctl::ChangeCoordinatorsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::fdbctl::ChangeCoordinatorsReply>>(PrepareAsyncChangeCoordinatorsRaw(context, request, cq));
    }
    // Suggests optimal configuration parameters based on current cluster topology.
    virtual ::grpc::Status ConfigureAutoSuggest(::grpc::ClientContext* context, const ::fdbctl::ConfigureAutoSuggestRequest& request, ::fdbctl::ConfigureAutoSuggestReply* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::fdbctl::ConfigureAutoSuggestReply>> AsyncConfigureAutoSuggest(::grpc::ClientContext* context, const ::fdbctl::ConfigureAutoSuggestRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::fdbctl::ConfigureAutoSuggestReply>>(AsyncConfigureAutoSuggestRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::fdbctl::ConfigureAutoSuggestReply>> PrepareAsyncConfigureAutoSuggest(::grpc::ClientContext* context, const ::fdbctl::ConfigureAutoSuggestRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::fdbctl::ConfigureAutoSuggestReply>>(PrepareAsyncConfigureAutoSuggestRaw(context, request, cq));
    }
    // Configures database settings including redundancy mode, storage engine, process counts, etc.
    virtual ::grpc::Status Configure(::grpc::ClientContext* context, const ::fdbctl::ConfigureRequest& request, ::fdbctl::ConfigureReply* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::fdbctl::ConfigureReply>> AsyncConfigure(::grpc::ClientContext* context, const ::fdbctl::ConfigureRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::fdbctl::ConfigureReply>>(AsyncConfigureRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::fdbctl::ConfigureReply>> PrepareAsyncConfigure(::grpc::ClientContext* context, const ::fdbctl::ConfigureRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::fdbctl::ConfigureReply>>(PrepareAsyncConfigureRaw(context, request, cq));
    }
    // Retrieves comprehensive cluster status including health, performance, and configuration.
    // Docs: https://github.com/apple/foundationdb/blob/main/documentation/sphinx/source/mr-status.rst
    virtual ::grpc::Status GetStatus(::grpc::ClientContext* context, const ::fdbctl::GetStatusRequest& request, ::fdbctl::GetStatusReply* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::fdbctl::GetStatusReply>> AsyncGetStatus(::grpc::ClientContext* context, const ::fdbctl::GetStatusRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::fdbctl::GetStatusReply>>(AsyncGetStatusRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::fdbctl::GetStatusReply>> PrepareAsyncGetStatus(::grpc::ClientContext* context, const ::fdbctl::GetStatusRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::fdbctl::GetStatusReply>>(PrepareAsyncGetStatusRaw(context, request, cq));
    }
    // Retrieves the list of all worker processes in the cluster.
    virtual ::grpc::Status GetWorkers(::grpc::ClientContext* context, const ::fdbctl::GetWorkersRequest& request, ::fdbctl::GetWorkersReply* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::fdbctl::GetWorkersReply>> AsyncGetWorkers(::grpc::ClientContext* context, const ::fdbctl::GetWorkersRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::fdbctl::GetWorkersReply>>(AsyncGetWorkersRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::fdbctl::GetWorkersReply>> PrepareAsyncGetWorkers(::grpc::ClientContext* context, const ::fdbctl::GetWorkersRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::fdbctl::GetWorkersReply>>(PrepareAsyncGetWorkersRaw(context, request, cq));
    }
    // Re-enables previously excluded workers, allowing them to rejoin the cluster.
    virtual ::grpc::Status Include(::grpc::ClientContext* context, const ::fdbctl::IncludeRequest& request, ::fdbctl::IncludeReply* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::fdbctl::IncludeReply>> AsyncInclude(::grpc::ClientContext* context, const ::fdbctl::IncludeRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::fdbctl::IncludeReply>>(AsyncIncludeRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::fdbctl::IncludeReply>> PrepareAsyncInclude(::grpc::ClientContext* context, const ::fdbctl::IncludeRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::fdbctl::IncludeReply>>(PrepareAsyncIncludeRaw(context, request, cq));
    }
    // Excludes workers from the cluster, triggering graceful data migration away from them.
    virtual ::grpc::Status Exclude(::grpc::ClientContext* context, const ::fdbctl::ExcludeRequest& request, ::fdbctl::ExcludeReply* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::fdbctl::ExcludeReply>> AsyncExclude(::grpc::ClientContext* context, const ::fdbctl::ExcludeRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::fdbctl::ExcludeReply>>(AsyncExcludeRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::fdbctl::ExcludeReply>> PrepareAsyncExclude(::grpc::ClientContext* context, const ::fdbctl::ExcludeRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::fdbctl::ExcludeReply>>(PrepareAsyncExcludeRaw(context, request, cq));
    }
    // Retrieves the status of worker exclusions including in-progress migrations.
    virtual ::grpc::Status ExcludeStatus(::grpc::ClientContext* context, const ::fdbctl::ExcludeStatusRequest& request, ::fdbctl::ExcludeStatusReply* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::fdbctl::ExcludeStatusReply>> AsyncExcludeStatus(::grpc::ClientContext* context, const ::fdbctl::ExcludeStatusRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::fdbctl::ExcludeStatusReply>>(AsyncExcludeStatusRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::fdbctl::ExcludeStatusReply>> PrepareAsyncExcludeStatus(::grpc::ClientContext* context, const ::fdbctl::ExcludeStatusRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::fdbctl::ExcludeStatusReply>>(PrepareAsyncExcludeStatusRaw(context, request, cq));
    }
    // Forcefully terminates worker processes. Use with caution - prefer Exclude for graceful removal.
    virtual ::grpc::Status Kill(::grpc::ClientContext* context, const ::fdbctl::KillRequest& request, ::fdbctl::KillReply* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::fdbctl::KillReply>> AsyncKill(::grpc::ClientContext* context, const ::fdbctl::KillRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::fdbctl::KillReply>>(AsyncKillRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::fdbctl::KillReply>> PrepareAsyncKill(::grpc::ClientContext* context, const ::fdbctl::KillRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::fdbctl::KillReply>>(PrepareAsyncKillRaw(context, request, cq));
    }
    // Manages maintenance mode for zones. Maintenance mode prevents data distribution from moving
    // data away from processes in the specified zone. A zone that is under maintenance will not
    // have data moved away from it even if processes in that zone fail. In particular, this means
    // the cluster will not attempt to heal the replication factor as a result of failures in the
    // maintenance zone. This is useful when the amount of time that the processes in a fault domain
    // are expected to be absent is reasonably short and you don’t want to move data to and from the
    // affected processes.
    virtual ::grpc::Status Maintenance(::grpc::ClientContext* context, const ::fdbctl::MaintenanceRequest& request, ::fdbctl::MaintenanceReply* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::fdbctl::MaintenanceReply>> AsyncMaintenance(::grpc::ClientContext* context, const ::fdbctl::MaintenanceRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::fdbctl::MaintenanceReply>>(AsyncMaintenanceRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::fdbctl::MaintenanceReply>> PrepareAsyncMaintenance(::grpc::ClientContext* context, const ::fdbctl::MaintenanceRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::fdbctl::MaintenanceReply>>(PrepareAsyncMaintenanceRaw(context, request, cq));
    }
    class async_interface {
     public:
      virtual ~async_interface() {}
      // Retrieves the current list of coordinators for the cluster.
      virtual void GetCoordinators(::grpc::ClientContext* context, const ::fdbctl::GetCoordinatorsRequest* request, ::fdbctl::GetCoordinatorsReply* response, std::function<void(::grpc::Status)>) = 0;
      virtual void GetCoordinators(::grpc::ClientContext* context, const ::fdbctl::GetCoordinatorsRequest* request, ::fdbctl::GetCoordinatorsReply* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Changes the cluster's coordinators. This is a critical operation that should be
      // performed carefully as coordinators maintain cluster configuration state.
      virtual void ChangeCoordinators(::grpc::ClientContext* context, const ::fdbctl::ChangeCoordinatorsRequest* request, ::fdbctl::ChangeCoordinatorsReply* response, std::function<void(::grpc::Status)>) = 0;
      virtual void ChangeCoordinators(::grpc::ClientContext* context, const ::fdbctl::ChangeCoordinatorsRequest* request, ::fdbctl::ChangeCoordinatorsReply* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Suggests optimal configuration parameters based on current cluster topology.
      virtual void ConfigureAutoSuggest(::grpc::ClientContext* context, const ::fdbctl::ConfigureAutoSuggestRequest* request, ::fdbctl::ConfigureAutoSuggestReply* response, std::function<void(::grpc::Status)>) = 0;
      virtual void ConfigureAutoSuggest(::grpc::ClientContext* context, const ::fdbctl::ConfigureAutoSuggestRequest* request, ::fdbctl::ConfigureAutoSuggestReply* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Configures database settings including redundancy mode, storage engine, process counts, etc.
      virtual void Configure(::grpc::ClientContext* context, const ::fdbctl::ConfigureRequest* request, ::fdbctl::ConfigureReply* response, std::function<void(::grpc::Status)>) = 0;
      virtual void Configure(::grpc::ClientContext* context, const ::fdbctl::ConfigureRequest* request, ::fdbctl::ConfigureReply* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Retrieves comprehensive cluster status including health, performance, and configuration.
      // Docs: https://github.com/apple/foundationdb/blob/main/documentation/sphinx/source/mr-status.rst
      virtual void GetStatus(::grpc::ClientContext* context, const ::fdbctl::GetStatusRequest* request, ::fdbctl::GetStatusReply* response, std::function<void(::grpc::Status)>) = 0;
      virtual void GetStatus(::grpc::ClientContext* context, const ::fdbctl::GetStatusRequest* request, ::fdbctl::GetStatusReply* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Retrieves the list of all worker processes in the cluster.
      virtual void GetWorkers(::grpc::ClientContext* context, const ::fdbctl::GetWorkersRequest* request, ::fdbctl::GetWorkersReply* response, std::function<void(::grpc::Status)>) = 0;
      virtual void GetWorkers(::grpc::ClientContext* context, const ::fdbctl::GetWorkersRequest* request, ::fdbctl::GetWorkersReply* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Re-enables previously excluded workers, allowing them to rejoin the cluster.
      virtual void Include(::grpc::ClientContext* context, const ::fdbctl::IncludeRequest* request, ::fdbctl::IncludeReply* response, std::function<void(::grpc::Status)>) = 0;
      virtual void Include(::grpc::ClientContext* context, const ::fdbctl::IncludeRequest* request, ::fdbctl::IncludeReply* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Excludes workers from the cluster, triggering graceful data migration away from them.
      virtual void Exclude(::grpc::ClientContext* context, const ::fdbctl::ExcludeRequest* request, ::fdbctl::ExcludeReply* response, std::function<void(::grpc::Status)>) = 0;
      virtual void Exclude(::grpc::ClientContext* context, const ::fdbctl::ExcludeRequest* request, ::fdbctl::ExcludeReply* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Retrieves the status of worker exclusions including in-progress migrations.
      virtual void ExcludeStatus(::grpc::ClientContext* context, const ::fdbctl::ExcludeStatusRequest* request, ::fdbctl::ExcludeStatusReply* response, std::function<void(::grpc::Status)>) = 0;
      virtual void ExcludeStatus(::grpc::ClientContext* context, const ::fdbctl::ExcludeStatusRequest* request, ::fdbctl::ExcludeStatusReply* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Forcefully terminates worker processes. Use with caution - prefer Exclude for graceful removal.
      virtual void Kill(::grpc::ClientContext* context, const ::fdbctl::KillRequest* request, ::fdbctl::KillReply* response, std::function<void(::grpc::Status)>) = 0;
      virtual void Kill(::grpc::ClientContext* context, const ::fdbctl::KillRequest* request, ::fdbctl::KillReply* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Manages maintenance mode for zones. Maintenance mode prevents data distribution from moving
      // data away from processes in the specified zone. A zone that is under maintenance will not
      // have data moved away from it even if processes in that zone fail. In particular, this means
      // the cluster will not attempt to heal the replication factor as a result of failures in the
      // maintenance zone. This is useful when the amount of time that the processes in a fault domain
      // are expected to be absent is reasonably short and you don’t want to move data to and from the
      // affected processes.
      virtual void Maintenance(::grpc::ClientContext* context, const ::fdbctl::MaintenanceRequest* request, ::fdbctl::MaintenanceReply* response, std::function<void(::grpc::Status)>) = 0;
      virtual void Maintenance(::grpc::ClientContext* context, const ::fdbctl::MaintenanceRequest* request, ::fdbctl::MaintenanceReply* response, ::grpc::ClientUnaryReactor* reactor) = 0;
    };
    typedef class async_interface experimental_async_interface;
    virtual class async_interface* async() { return nullptr; }
    class async_interface* experimental_async() { return async(); }
   private:
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::fdbctl::GetCoordinatorsReply>* AsyncGetCoordinatorsRaw(::grpc::ClientContext* context, const ::fdbctl::GetCoordinatorsRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::fdbctl::GetCoordinatorsReply>* PrepareAsyncGetCoordinatorsRaw(::grpc::ClientContext* context, const ::fdbctl::GetCoordinatorsRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::fdbctl::ChangeCoordinatorsReply>* AsyncChangeCoordinatorsRaw(::grpc::ClientContext* context, const ::fdbctl::ChangeCoordinatorsRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::fdbctl::ChangeCoordinatorsReply>* PrepareAsyncChangeCoordinatorsRaw(::grpc::ClientContext* context, const ::fdbctl::ChangeCoordinatorsRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::fdbctl::ConfigureAutoSuggestReply>* AsyncConfigureAutoSuggestRaw(::grpc::ClientContext* context, const ::fdbctl::ConfigureAutoSuggestRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::fdbctl::ConfigureAutoSuggestReply>* PrepareAsyncConfigureAutoSuggestRaw(::grpc::ClientContext* context, const ::fdbctl::ConfigureAutoSuggestRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::fdbctl::ConfigureReply>* AsyncConfigureRaw(::grpc::ClientContext* context, const ::fdbctl::ConfigureRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::fdbctl::ConfigureReply>* PrepareAsyncConfigureRaw(::grpc::ClientContext* context, const ::fdbctl::ConfigureRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::fdbctl::GetStatusReply>* AsyncGetStatusRaw(::grpc::ClientContext* context, const ::fdbctl::GetStatusRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::fdbctl::GetStatusReply>* PrepareAsyncGetStatusRaw(::grpc::ClientContext* context, const ::fdbctl::GetStatusRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::fdbctl::GetWorkersReply>* AsyncGetWorkersRaw(::grpc::ClientContext* context, const ::fdbctl::GetWorkersRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::fdbctl::GetWorkersReply>* PrepareAsyncGetWorkersRaw(::grpc::ClientContext* context, const ::fdbctl::GetWorkersRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::fdbctl::IncludeReply>* AsyncIncludeRaw(::grpc::ClientContext* context, const ::fdbctl::IncludeRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::fdbctl::IncludeReply>* PrepareAsyncIncludeRaw(::grpc::ClientContext* context, const ::fdbctl::IncludeRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::fdbctl::ExcludeReply>* AsyncExcludeRaw(::grpc::ClientContext* context, const ::fdbctl::ExcludeRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::fdbctl::ExcludeReply>* PrepareAsyncExcludeRaw(::grpc::ClientContext* context, const ::fdbctl::ExcludeRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::fdbctl::ExcludeStatusReply>* AsyncExcludeStatusRaw(::grpc::ClientContext* context, const ::fdbctl::ExcludeStatusRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::fdbctl::ExcludeStatusReply>* PrepareAsyncExcludeStatusRaw(::grpc::ClientContext* context, const ::fdbctl::ExcludeStatusRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::fdbctl::KillReply>* AsyncKillRaw(::grpc::ClientContext* context, const ::fdbctl::KillRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::fdbctl::KillReply>* PrepareAsyncKillRaw(::grpc::ClientContext* context, const ::fdbctl::KillRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::fdbctl::MaintenanceReply>* AsyncMaintenanceRaw(::grpc::ClientContext* context, const ::fdbctl::MaintenanceRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::fdbctl::MaintenanceReply>* PrepareAsyncMaintenanceRaw(::grpc::ClientContext* context, const ::fdbctl::MaintenanceRequest& request, ::grpc::CompletionQueue* cq) = 0;
  };
  class Stub final : public StubInterface {
   public:
    Stub(const std::shared_ptr< ::grpc::ChannelInterface>& channel, const ::grpc::StubOptions& options = ::grpc::StubOptions());
    ::grpc::Status GetCoordinators(::grpc::ClientContext* context, const ::fdbctl::GetCoordinatorsRequest& request, ::fdbctl::GetCoordinatorsReply* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::fdbctl::GetCoordinatorsReply>> AsyncGetCoordinators(::grpc::ClientContext* context, const ::fdbctl::GetCoordinatorsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::fdbctl::GetCoordinatorsReply>>(AsyncGetCoordinatorsRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::fdbctl::GetCoordinatorsReply>> PrepareAsyncGetCoordinators(::grpc::ClientContext* context, const ::fdbctl::GetCoordinatorsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::fdbctl::GetCoordinatorsReply>>(PrepareAsyncGetCoordinatorsRaw(context, request, cq));
    }
    ::grpc::Status ChangeCoordinators(::grpc::ClientContext* context, const ::fdbctl::ChangeCoordinatorsRequest& request, ::fdbctl::ChangeCoordinatorsReply* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::fdbctl::ChangeCoordinatorsReply>> AsyncChangeCoordinators(::grpc::ClientContext* context, const ::fdbctl::ChangeCoordinatorsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::fdbctl::ChangeCoordinatorsReply>>(AsyncChangeCoordinatorsRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::fdbctl::ChangeCoordinatorsReply>> PrepareAsyncChangeCoordinators(::grpc::ClientContext* context, const ::fdbctl::ChangeCoordinatorsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::fdbctl::ChangeCoordinatorsReply>>(PrepareAsyncChangeCoordinatorsRaw(context, request, cq));
    }
    ::grpc::Status ConfigureAutoSuggest(::grpc::ClientContext* context, const ::fdbctl::ConfigureAutoSuggestRequest& request, ::fdbctl::ConfigureAutoSuggestReply* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::fdbctl::ConfigureAutoSuggestReply>> AsyncConfigureAutoSuggest(::grpc::ClientContext* context, const ::fdbctl::ConfigureAutoSuggestRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::fdbctl::ConfigureAutoSuggestReply>>(AsyncConfigureAutoSuggestRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::fdbctl::ConfigureAutoSuggestReply>> PrepareAsyncConfigureAutoSuggest(::grpc::ClientContext* context, const ::fdbctl::ConfigureAutoSuggestRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::fdbctl::ConfigureAutoSuggestReply>>(PrepareAsyncConfigureAutoSuggestRaw(context, request, cq));
    }
    ::grpc::Status Configure(::grpc::ClientContext* context, const ::fdbctl::ConfigureRequest& request, ::fdbctl::ConfigureReply* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::fdbctl::ConfigureReply>> AsyncConfigure(::grpc::ClientContext* context, const ::fdbctl::ConfigureRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::fdbctl::ConfigureReply>>(AsyncConfigureRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::fdbctl::ConfigureReply>> PrepareAsyncConfigure(::grpc::ClientContext* context, const ::fdbctl::ConfigureRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::fdbctl::ConfigureReply>>(PrepareAsyncConfigureRaw(context, request, cq));
    }
    ::grpc::Status GetStatus(::grpc::ClientContext* context, const ::fdbctl::GetStatusRequest& request, ::fdbctl::GetStatusReply* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::fdbctl::GetStatusReply>> AsyncGetStatus(::grpc::ClientContext* context, const ::fdbctl::GetStatusRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::fdbctl::GetStatusReply>>(AsyncGetStatusRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::fdbctl::GetStatusReply>> PrepareAsyncGetStatus(::grpc::ClientContext* context, const ::fdbctl::GetStatusRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::fdbctl::GetStatusReply>>(PrepareAsyncGetStatusRaw(context, request, cq));
    }
    ::grpc::Status GetWorkers(::grpc::ClientContext* context, const ::fdbctl::GetWorkersRequest& request, ::fdbctl::GetWorkersReply* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::fdbctl::GetWorkersReply>> AsyncGetWorkers(::grpc::ClientContext* context, const ::fdbctl::GetWorkersRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::fdbctl::GetWorkersReply>>(AsyncGetWorkersRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::fdbctl::GetWorkersReply>> PrepareAsyncGetWorkers(::grpc::ClientContext* context, const ::fdbctl::GetWorkersRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::fdbctl::GetWorkersReply>>(PrepareAsyncGetWorkersRaw(context, request, cq));
    }
    ::grpc::Status Include(::grpc::ClientContext* context, const ::fdbctl::IncludeRequest& request, ::fdbctl::IncludeReply* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::fdbctl::IncludeReply>> AsyncInclude(::grpc::ClientContext* context, const ::fdbctl::IncludeRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::fdbctl::IncludeReply>>(AsyncIncludeRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::fdbctl::IncludeReply>> PrepareAsyncInclude(::grpc::ClientContext* context, const ::fdbctl::IncludeRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::fdbctl::IncludeReply>>(PrepareAsyncIncludeRaw(context, request, cq));
    }
    ::grpc::Status Exclude(::grpc::ClientContext* context, const ::fdbctl::ExcludeRequest& request, ::fdbctl::ExcludeReply* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::fdbctl::ExcludeReply>> AsyncExclude(::grpc::ClientContext* context, const ::fdbctl::ExcludeRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::fdbctl::ExcludeReply>>(AsyncExcludeRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::fdbctl::ExcludeReply>> PrepareAsyncExclude(::grpc::ClientContext* context, const ::fdbctl::ExcludeRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::fdbctl::ExcludeReply>>(PrepareAsyncExcludeRaw(context, request, cq));
    }
    ::grpc::Status ExcludeStatus(::grpc::ClientContext* context, const ::fdbctl::ExcludeStatusRequest& request, ::fdbctl::ExcludeStatusReply* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::fdbctl::ExcludeStatusReply>> AsyncExcludeStatus(::grpc::ClientContext* context, const ::fdbctl::ExcludeStatusRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::fdbctl::ExcludeStatusReply>>(AsyncExcludeStatusRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::fdbctl::ExcludeStatusReply>> PrepareAsyncExcludeStatus(::grpc::ClientContext* context, const ::fdbctl::ExcludeStatusRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::fdbctl::ExcludeStatusReply>>(PrepareAsyncExcludeStatusRaw(context, request, cq));
    }
    ::grpc::Status Kill(::grpc::ClientContext* context, const ::fdbctl::KillRequest& request, ::fdbctl::KillReply* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::fdbctl::KillReply>> AsyncKill(::grpc::ClientContext* context, const ::fdbctl::KillRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::fdbctl::KillReply>>(AsyncKillRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::fdbctl::KillReply>> PrepareAsyncKill(::grpc::ClientContext* context, const ::fdbctl::KillRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::fdbctl::KillReply>>(PrepareAsyncKillRaw(context, request, cq));
    }
    ::grpc::Status Maintenance(::grpc::ClientContext* context, const ::fdbctl::MaintenanceRequest& request, ::fdbctl::MaintenanceReply* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::fdbctl::MaintenanceReply>> AsyncMaintenance(::grpc::ClientContext* context, const ::fdbctl::MaintenanceRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::fdbctl::MaintenanceReply>>(AsyncMaintenanceRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::fdbctl::MaintenanceReply>> PrepareAsyncMaintenance(::grpc::ClientContext* context, const ::fdbctl::MaintenanceRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::fdbctl::MaintenanceReply>>(PrepareAsyncMaintenanceRaw(context, request, cq));
    }
    class async final :
      public StubInterface::async_interface {
     public:
      void GetCoordinators(::grpc::ClientContext* context, const ::fdbctl::GetCoordinatorsRequest* request, ::fdbctl::GetCoordinatorsReply* response, std::function<void(::grpc::Status)>) override;
      void GetCoordinators(::grpc::ClientContext* context, const ::fdbctl::GetCoordinatorsRequest* request, ::fdbctl::GetCoordinatorsReply* response, ::grpc::ClientUnaryReactor* reactor) override;
      void ChangeCoordinators(::grpc::ClientContext* context, const ::fdbctl::ChangeCoordinatorsRequest* request, ::fdbctl::ChangeCoordinatorsReply* response, std::function<void(::grpc::Status)>) override;
      void ChangeCoordinators(::grpc::ClientContext* context, const ::fdbctl::ChangeCoordinatorsRequest* request, ::fdbctl::ChangeCoordinatorsReply* response, ::grpc::ClientUnaryReactor* reactor) override;
      void ConfigureAutoSuggest(::grpc::ClientContext* context, const ::fdbctl::ConfigureAutoSuggestRequest* request, ::fdbctl::ConfigureAutoSuggestReply* response, std::function<void(::grpc::Status)>) override;
      void ConfigureAutoSuggest(::grpc::ClientContext* context, const ::fdbctl::ConfigureAutoSuggestRequest* request, ::fdbctl::ConfigureAutoSuggestReply* response, ::grpc::ClientUnaryReactor* reactor) override;
      void Configure(::grpc::ClientContext* context, const ::fdbctl::ConfigureRequest* request, ::fdbctl::ConfigureReply* response, std::function<void(::grpc::Status)>) override;
      void Configure(::grpc::ClientContext* context, const ::fdbctl::ConfigureRequest* request, ::fdbctl::ConfigureReply* response, ::grpc::ClientUnaryReactor* reactor) override;
      void GetStatus(::grpc::ClientContext* context, const ::fdbctl::GetStatusRequest* request, ::fdbctl::GetStatusReply* response, std::function<void(::grpc::Status)>) override;
      void GetStatus(::grpc::ClientContext* context, const ::fdbctl::GetStatusRequest* request, ::fdbctl::GetStatusReply* response, ::grpc::ClientUnaryReactor* reactor) override;
      void GetWorkers(::grpc::ClientContext* context, const ::fdbctl::GetWorkersRequest* request, ::fdbctl::GetWorkersReply* response, std::function<void(::grpc::Status)>) override;
      void GetWorkers(::grpc::ClientContext* context, const ::fdbctl::GetWorkersRequest* request, ::fdbctl::GetWorkersReply* response, ::grpc::ClientUnaryReactor* reactor) override;
      void Include(::grpc::ClientContext* context, const ::fdbctl::IncludeRequest* request, ::fdbctl::IncludeReply* response, std::function<void(::grpc::Status)>) override;
      void Include(::grpc::ClientContext* context, const ::fdbctl::IncludeRequest* request, ::fdbctl::IncludeReply* response, ::grpc::ClientUnaryReactor* reactor) override;
      void Exclude(::grpc::ClientContext* context, const ::fdbctl::ExcludeRequest* request, ::fdbctl::ExcludeReply* response, std::function<void(::grpc::Status)>) override;
      void Exclude(::grpc::ClientContext* context, const ::fdbctl::ExcludeRequest* request, ::fdbctl::ExcludeReply* response, ::grpc::ClientUnaryReactor* reactor) override;
      void ExcludeStatus(::grpc::ClientContext* context, const ::fdbctl::ExcludeStatusRequest* request, ::fdbctl::ExcludeStatusReply* response, std::function<void(::grpc::Status)>) override;
      void ExcludeStatus(::grpc::ClientContext* context, const ::fdbctl::ExcludeStatusRequest* request, ::fdbctl::ExcludeStatusReply* response, ::grpc::ClientUnaryReactor* reactor) override;
      void Kill(::grpc::ClientContext* context, const ::fdbctl::KillRequest* request, ::fdbctl::KillReply* response, std::function<void(::grpc::Status)>) override;
      void Kill(::grpc::ClientContext* context, const ::fdbctl::KillRequest* request, ::fdbctl::KillReply* response, ::grpc::ClientUnaryReactor* reactor) override;
      void Maintenance(::grpc::ClientContext* context, const ::fdbctl::MaintenanceRequest* request, ::fdbctl::MaintenanceReply* response, std::function<void(::grpc::Status)>) override;
      void Maintenance(::grpc::ClientContext* context, const ::fdbctl::MaintenanceRequest* request, ::fdbctl::MaintenanceReply* response, ::grpc::ClientUnaryReactor* reactor) override;
     private:
      friend class Stub;
      explicit async(Stub* stub): stub_(stub) { }
      Stub* stub() { return stub_; }
      Stub* stub_;
    };
    class async* async() override { return &async_stub_; }

   private:
    std::shared_ptr< ::grpc::ChannelInterface> channel_;
    class async async_stub_{this};
    ::grpc::ClientAsyncResponseReader< ::fdbctl::GetCoordinatorsReply>* AsyncGetCoordinatorsRaw(::grpc::ClientContext* context, const ::fdbctl::GetCoordinatorsRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::fdbctl::GetCoordinatorsReply>* PrepareAsyncGetCoordinatorsRaw(::grpc::ClientContext* context, const ::fdbctl::GetCoordinatorsRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::fdbctl::ChangeCoordinatorsReply>* AsyncChangeCoordinatorsRaw(::grpc::ClientContext* context, const ::fdbctl::ChangeCoordinatorsRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::fdbctl::ChangeCoordinatorsReply>* PrepareAsyncChangeCoordinatorsRaw(::grpc::ClientContext* context, const ::fdbctl::ChangeCoordinatorsRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::fdbctl::ConfigureAutoSuggestReply>* AsyncConfigureAutoSuggestRaw(::grpc::ClientContext* context, const ::fdbctl::ConfigureAutoSuggestRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::fdbctl::ConfigureAutoSuggestReply>* PrepareAsyncConfigureAutoSuggestRaw(::grpc::ClientContext* context, const ::fdbctl::ConfigureAutoSuggestRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::fdbctl::ConfigureReply>* AsyncConfigureRaw(::grpc::ClientContext* context, const ::fdbctl::ConfigureRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::fdbctl::ConfigureReply>* PrepareAsyncConfigureRaw(::grpc::ClientContext* context, const ::fdbctl::ConfigureRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::fdbctl::GetStatusReply>* AsyncGetStatusRaw(::grpc::ClientContext* context, const ::fdbctl::GetStatusRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::fdbctl::GetStatusReply>* PrepareAsyncGetStatusRaw(::grpc::ClientContext* context, const ::fdbctl::GetStatusRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::fdbctl::GetWorkersReply>* AsyncGetWorkersRaw(::grpc::ClientContext* context, const ::fdbctl::GetWorkersRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::fdbctl::GetWorkersReply>* PrepareAsyncGetWorkersRaw(::grpc::ClientContext* context, const ::fdbctl::GetWorkersRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::fdbctl::IncludeReply>* AsyncIncludeRaw(::grpc::ClientContext* context, const ::fdbctl::IncludeRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::fdbctl::IncludeReply>* PrepareAsyncIncludeRaw(::grpc::ClientContext* context, const ::fdbctl::IncludeRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::fdbctl::ExcludeReply>* AsyncExcludeRaw(::grpc::ClientContext* context, const ::fdbctl::ExcludeRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::fdbctl::ExcludeReply>* PrepareAsyncExcludeRaw(::grpc::ClientContext* context, const ::fdbctl::ExcludeRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::fdbctl::ExcludeStatusReply>* AsyncExcludeStatusRaw(::grpc::ClientContext* context, const ::fdbctl::ExcludeStatusRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::fdbctl::ExcludeStatusReply>* PrepareAsyncExcludeStatusRaw(::grpc::ClientContext* context, const ::fdbctl::ExcludeStatusRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::fdbctl::KillReply>* AsyncKillRaw(::grpc::ClientContext* context, const ::fdbctl::KillRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::fdbctl::KillReply>* PrepareAsyncKillRaw(::grpc::ClientContext* context, const ::fdbctl::KillRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::fdbctl::MaintenanceReply>* AsyncMaintenanceRaw(::grpc::ClientContext* context, const ::fdbctl::MaintenanceRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::fdbctl::MaintenanceReply>* PrepareAsyncMaintenanceRaw(::grpc::ClientContext* context, const ::fdbctl::MaintenanceRequest& request, ::grpc::CompletionQueue* cq) override;
    const ::grpc::internal::RpcMethod rpcmethod_GetCoordinators_;
    const ::grpc::internal::RpcMethod rpcmethod_ChangeCoordinators_;
    const ::grpc::internal::RpcMethod rpcmethod_ConfigureAutoSuggest_;
    const ::grpc::internal::RpcMethod rpcmethod_Configure_;
    const ::grpc::internal::RpcMethod rpcmethod_GetStatus_;
    const ::grpc::internal::RpcMethod rpcmethod_GetWorkers_;
    const ::grpc::internal::RpcMethod rpcmethod_Include_;
    const ::grpc::internal::RpcMethod rpcmethod_Exclude_;
    const ::grpc::internal::RpcMethod rpcmethod_ExcludeStatus_;
    const ::grpc::internal::RpcMethod rpcmethod_Kill_;
    const ::grpc::internal::RpcMethod rpcmethod_Maintenance_;
  };
  static std::unique_ptr<Stub> NewStub(const std::shared_ptr< ::grpc::ChannelInterface>& channel, const ::grpc::StubOptions& options = ::grpc::StubOptions());

  class Service : public ::grpc::Service {
   public:
    Service();
    virtual ~Service();
    // Retrieves the current list of coordinators for the cluster.
    virtual ::grpc::Status GetCoordinators(::grpc::ServerContext* context, const ::fdbctl::GetCoordinatorsRequest* request, ::fdbctl::GetCoordinatorsReply* response);
    // Changes the cluster's coordinators. This is a critical operation that should be
    // performed carefully as coordinators maintain cluster configuration state.
    virtual ::grpc::Status ChangeCoordinators(::grpc::ServerContext* context, const ::fdbctl::ChangeCoordinatorsRequest* request, ::fdbctl::ChangeCoordinatorsReply* response);
    // Suggests optimal configuration parameters based on current cluster topology.
    virtual ::grpc::Status ConfigureAutoSuggest(::grpc::ServerContext* context, const ::fdbctl::ConfigureAutoSuggestRequest* request, ::fdbctl::ConfigureAutoSuggestReply* response);
    // Configures database settings including redundancy mode, storage engine, process counts, etc.
    virtual ::grpc::Status Configure(::grpc::ServerContext* context, const ::fdbctl::ConfigureRequest* request, ::fdbctl::ConfigureReply* response);
    // Retrieves comprehensive cluster status including health, performance, and configuration.
    // Docs: https://github.com/apple/foundationdb/blob/main/documentation/sphinx/source/mr-status.rst
    virtual ::grpc::Status GetStatus(::grpc::ServerContext* context, const ::fdbctl::GetStatusRequest* request, ::fdbctl::GetStatusReply* response);
    // Retrieves the list of all worker processes in the cluster.
    virtual ::grpc::Status GetWorkers(::grpc::ServerContext* context, const ::fdbctl::GetWorkersRequest* request, ::fdbctl::GetWorkersReply* response);
    // Re-enables previously excluded workers, allowing them to rejoin the cluster.
    virtual ::grpc::Status Include(::grpc::ServerContext* context, const ::fdbctl::IncludeRequest* request, ::fdbctl::IncludeReply* response);
    // Excludes workers from the cluster, triggering graceful data migration away from them.
    virtual ::grpc::Status Exclude(::grpc::ServerContext* context, const ::fdbctl::ExcludeRequest* request, ::fdbctl::ExcludeReply* response);
    // Retrieves the status of worker exclusions including in-progress migrations.
    virtual ::grpc::Status ExcludeStatus(::grpc::ServerContext* context, const ::fdbctl::ExcludeStatusRequest* request, ::fdbctl::ExcludeStatusReply* response);
    // Forcefully terminates worker processes. Use with caution - prefer Exclude for graceful removal.
    virtual ::grpc::Status Kill(::grpc::ServerContext* context, const ::fdbctl::KillRequest* request, ::fdbctl::KillReply* response);
    // Manages maintenance mode for zones. Maintenance mode prevents data distribution from moving
    // data away from processes in the specified zone. A zone that is under maintenance will not
    // have data moved away from it even if processes in that zone fail. In particular, this means
    // the cluster will not attempt to heal the replication factor as a result of failures in the
    // maintenance zone. This is useful when the amount of time that the processes in a fault domain
    // are expected to be absent is reasonably short and you don’t want to move data to and from the
    // affected processes.
    virtual ::grpc::Status Maintenance(::grpc::ServerContext* context, const ::fdbctl::MaintenanceRequest* request, ::fdbctl::MaintenanceReply* response);
  };
  template <class BaseClass>
  class WithAsyncMethod_GetCoordinators : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_GetCoordinators() {
      ::grpc::Service::MarkMethodAsync(0);
    }
    ~WithAsyncMethod_GetCoordinators() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetCoordinators(::grpc::ServerContext* /*context*/, const ::fdbctl::GetCoordinatorsRequest* /*request*/, ::fdbctl::GetCoordinatorsReply* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestGetCoordinators(::grpc::ServerContext* context, ::fdbctl::GetCoordinatorsRequest* request, ::grpc::ServerAsyncResponseWriter< ::fdbctl::GetCoordinatorsReply>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(0, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_ChangeCoordinators : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_ChangeCoordinators() {
      ::grpc::Service::MarkMethodAsync(1);
    }
    ~WithAsyncMethod_ChangeCoordinators() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ChangeCoordinators(::grpc::ServerContext* /*context*/, const ::fdbctl::ChangeCoordinatorsRequest* /*request*/, ::fdbctl::ChangeCoordinatorsReply* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestChangeCoordinators(::grpc::ServerContext* context, ::fdbctl::ChangeCoordinatorsRequest* request, ::grpc::ServerAsyncResponseWriter< ::fdbctl::ChangeCoordinatorsReply>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(1, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_ConfigureAutoSuggest : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_ConfigureAutoSuggest() {
      ::grpc::Service::MarkMethodAsync(2);
    }
    ~WithAsyncMethod_ConfigureAutoSuggest() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ConfigureAutoSuggest(::grpc::ServerContext* /*context*/, const ::fdbctl::ConfigureAutoSuggestRequest* /*request*/, ::fdbctl::ConfigureAutoSuggestReply* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestConfigureAutoSuggest(::grpc::ServerContext* context, ::fdbctl::ConfigureAutoSuggestRequest* request, ::grpc::ServerAsyncResponseWriter< ::fdbctl::ConfigureAutoSuggestReply>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(2, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_Configure : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_Configure() {
      ::grpc::Service::MarkMethodAsync(3);
    }
    ~WithAsyncMethod_Configure() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Configure(::grpc::ServerContext* /*context*/, const ::fdbctl::ConfigureRequest* /*request*/, ::fdbctl::ConfigureReply* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestConfigure(::grpc::ServerContext* context, ::fdbctl::ConfigureRequest* request, ::grpc::ServerAsyncResponseWriter< ::fdbctl::ConfigureReply>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(3, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_GetStatus : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_GetStatus() {
      ::grpc::Service::MarkMethodAsync(4);
    }
    ~WithAsyncMethod_GetStatus() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetStatus(::grpc::ServerContext* /*context*/, const ::fdbctl::GetStatusRequest* /*request*/, ::fdbctl::GetStatusReply* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestGetStatus(::grpc::ServerContext* context, ::fdbctl::GetStatusRequest* request, ::grpc::ServerAsyncResponseWriter< ::fdbctl::GetStatusReply>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(4, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_GetWorkers : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_GetWorkers() {
      ::grpc::Service::MarkMethodAsync(5);
    }
    ~WithAsyncMethod_GetWorkers() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetWorkers(::grpc::ServerContext* /*context*/, const ::fdbctl::GetWorkersRequest* /*request*/, ::fdbctl::GetWorkersReply* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestGetWorkers(::grpc::ServerContext* context, ::fdbctl::GetWorkersRequest* request, ::grpc::ServerAsyncResponseWriter< ::fdbctl::GetWorkersReply>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(5, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_Include : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_Include() {
      ::grpc::Service::MarkMethodAsync(6);
    }
    ~WithAsyncMethod_Include() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Include(::grpc::ServerContext* /*context*/, const ::fdbctl::IncludeRequest* /*request*/, ::fdbctl::IncludeReply* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestInclude(::grpc::ServerContext* context, ::fdbctl::IncludeRequest* request, ::grpc::ServerAsyncResponseWriter< ::fdbctl::IncludeReply>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(6, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_Exclude : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_Exclude() {
      ::grpc::Service::MarkMethodAsync(7);
    }
    ~WithAsyncMethod_Exclude() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Exclude(::grpc::ServerContext* /*context*/, const ::fdbctl::ExcludeRequest* /*request*/, ::fdbctl::ExcludeReply* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestExclude(::grpc::ServerContext* context, ::fdbctl::ExcludeRequest* request, ::grpc::ServerAsyncResponseWriter< ::fdbctl::ExcludeReply>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(7, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_ExcludeStatus : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_ExcludeStatus() {
      ::grpc::Service::MarkMethodAsync(8);
    }
    ~WithAsyncMethod_ExcludeStatus() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ExcludeStatus(::grpc::ServerContext* /*context*/, const ::fdbctl::ExcludeStatusRequest* /*request*/, ::fdbctl::ExcludeStatusReply* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestExcludeStatus(::grpc::ServerContext* context, ::fdbctl::ExcludeStatusRequest* request, ::grpc::ServerAsyncResponseWriter< ::fdbctl::ExcludeStatusReply>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(8, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_Kill : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_Kill() {
      ::grpc::Service::MarkMethodAsync(9);
    }
    ~WithAsyncMethod_Kill() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Kill(::grpc::ServerContext* /*context*/, const ::fdbctl::KillRequest* /*request*/, ::fdbctl::KillReply* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestKill(::grpc::ServerContext* context, ::fdbctl::KillRequest* request, ::grpc::ServerAsyncResponseWriter< ::fdbctl::KillReply>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(9, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_Maintenance : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_Maintenance() {
      ::grpc::Service::MarkMethodAsync(10);
    }
    ~WithAsyncMethod_Maintenance() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Maintenance(::grpc::ServerContext* /*context*/, const ::fdbctl::MaintenanceRequest* /*request*/, ::fdbctl::MaintenanceReply* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestMaintenance(::grpc::ServerContext* context, ::fdbctl::MaintenanceRequest* request, ::grpc::ServerAsyncResponseWriter< ::fdbctl::MaintenanceReply>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(10, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  typedef WithAsyncMethod_GetCoordinators<WithAsyncMethod_ChangeCoordinators<WithAsyncMethod_ConfigureAutoSuggest<WithAsyncMethod_Configure<WithAsyncMethod_GetStatus<WithAsyncMethod_GetWorkers<WithAsyncMethod_Include<WithAsyncMethod_Exclude<WithAsyncMethod_ExcludeStatus<WithAsyncMethod_Kill<WithAsyncMethod_Maintenance<Service > > > > > > > > > > > AsyncService;
  template <class BaseClass>
  class WithCallbackMethod_GetCoordinators : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_GetCoordinators() {
      ::grpc::Service::MarkMethodCallback(0,
          new ::grpc::internal::CallbackUnaryHandler< ::fdbctl::GetCoordinatorsRequest, ::fdbctl::GetCoordinatorsReply>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::fdbctl::GetCoordinatorsRequest* request, ::fdbctl::GetCoordinatorsReply* response) { return this->GetCoordinators(context, request, response); }));}
    void SetMessageAllocatorFor_GetCoordinators(
        ::grpc::MessageAllocator< ::fdbctl::GetCoordinatorsRequest, ::fdbctl::GetCoordinatorsReply>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(0);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::fdbctl::GetCoordinatorsRequest, ::fdbctl::GetCoordinatorsReply>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_GetCoordinators() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetCoordinators(::grpc::ServerContext* /*context*/, const ::fdbctl::GetCoordinatorsRequest* /*request*/, ::fdbctl::GetCoordinatorsReply* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* GetCoordinators(
      ::grpc::CallbackServerContext* /*context*/, const ::fdbctl::GetCoordinatorsRequest* /*request*/, ::fdbctl::GetCoordinatorsReply* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_ChangeCoordinators : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_ChangeCoordinators() {
      ::grpc::Service::MarkMethodCallback(1,
          new ::grpc::internal::CallbackUnaryHandler< ::fdbctl::ChangeCoordinatorsRequest, ::fdbctl::ChangeCoordinatorsReply>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::fdbctl::ChangeCoordinatorsRequest* request, ::fdbctl::ChangeCoordinatorsReply* response) { return this->ChangeCoordinators(context, request, response); }));}
    void SetMessageAllocatorFor_ChangeCoordinators(
        ::grpc::MessageAllocator< ::fdbctl::ChangeCoordinatorsRequest, ::fdbctl::ChangeCoordinatorsReply>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(1);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::fdbctl::ChangeCoordinatorsRequest, ::fdbctl::ChangeCoordinatorsReply>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_ChangeCoordinators() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ChangeCoordinators(::grpc::ServerContext* /*context*/, const ::fdbctl::ChangeCoordinatorsRequest* /*request*/, ::fdbctl::ChangeCoordinatorsReply* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* ChangeCoordinators(
      ::grpc::CallbackServerContext* /*context*/, const ::fdbctl::ChangeCoordinatorsRequest* /*request*/, ::fdbctl::ChangeCoordinatorsReply* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_ConfigureAutoSuggest : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_ConfigureAutoSuggest() {
      ::grpc::Service::MarkMethodCallback(2,
          new ::grpc::internal::CallbackUnaryHandler< ::fdbctl::ConfigureAutoSuggestRequest, ::fdbctl::ConfigureAutoSuggestReply>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::fdbctl::ConfigureAutoSuggestRequest* request, ::fdbctl::ConfigureAutoSuggestReply* response) { return this->ConfigureAutoSuggest(context, request, response); }));}
    void SetMessageAllocatorFor_ConfigureAutoSuggest(
        ::grpc::MessageAllocator< ::fdbctl::ConfigureAutoSuggestRequest, ::fdbctl::ConfigureAutoSuggestReply>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(2);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::fdbctl::ConfigureAutoSuggestRequest, ::fdbctl::ConfigureAutoSuggestReply>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_ConfigureAutoSuggest() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ConfigureAutoSuggest(::grpc::ServerContext* /*context*/, const ::fdbctl::ConfigureAutoSuggestRequest* /*request*/, ::fdbctl::ConfigureAutoSuggestReply* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* ConfigureAutoSuggest(
      ::grpc::CallbackServerContext* /*context*/, const ::fdbctl::ConfigureAutoSuggestRequest* /*request*/, ::fdbctl::ConfigureAutoSuggestReply* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_Configure : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_Configure() {
      ::grpc::Service::MarkMethodCallback(3,
          new ::grpc::internal::CallbackUnaryHandler< ::fdbctl::ConfigureRequest, ::fdbctl::ConfigureReply>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::fdbctl::ConfigureRequest* request, ::fdbctl::ConfigureReply* response) { return this->Configure(context, request, response); }));}
    void SetMessageAllocatorFor_Configure(
        ::grpc::MessageAllocator< ::fdbctl::ConfigureRequest, ::fdbctl::ConfigureReply>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(3);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::fdbctl::ConfigureRequest, ::fdbctl::ConfigureReply>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_Configure() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Configure(::grpc::ServerContext* /*context*/, const ::fdbctl::ConfigureRequest* /*request*/, ::fdbctl::ConfigureReply* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* Configure(
      ::grpc::CallbackServerContext* /*context*/, const ::fdbctl::ConfigureRequest* /*request*/, ::fdbctl::ConfigureReply* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_GetStatus : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_GetStatus() {
      ::grpc::Service::MarkMethodCallback(4,
          new ::grpc::internal::CallbackUnaryHandler< ::fdbctl::GetStatusRequest, ::fdbctl::GetStatusReply>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::fdbctl::GetStatusRequest* request, ::fdbctl::GetStatusReply* response) { return this->GetStatus(context, request, response); }));}
    void SetMessageAllocatorFor_GetStatus(
        ::grpc::MessageAllocator< ::fdbctl::GetStatusRequest, ::fdbctl::GetStatusReply>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(4);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::fdbctl::GetStatusRequest, ::fdbctl::GetStatusReply>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_GetStatus() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetStatus(::grpc::ServerContext* /*context*/, const ::fdbctl::GetStatusRequest* /*request*/, ::fdbctl::GetStatusReply* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* GetStatus(
      ::grpc::CallbackServerContext* /*context*/, const ::fdbctl::GetStatusRequest* /*request*/, ::fdbctl::GetStatusReply* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_GetWorkers : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_GetWorkers() {
      ::grpc::Service::MarkMethodCallback(5,
          new ::grpc::internal::CallbackUnaryHandler< ::fdbctl::GetWorkersRequest, ::fdbctl::GetWorkersReply>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::fdbctl::GetWorkersRequest* request, ::fdbctl::GetWorkersReply* response) { return this->GetWorkers(context, request, response); }));}
    void SetMessageAllocatorFor_GetWorkers(
        ::grpc::MessageAllocator< ::fdbctl::GetWorkersRequest, ::fdbctl::GetWorkersReply>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(5);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::fdbctl::GetWorkersRequest, ::fdbctl::GetWorkersReply>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_GetWorkers() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetWorkers(::grpc::ServerContext* /*context*/, const ::fdbctl::GetWorkersRequest* /*request*/, ::fdbctl::GetWorkersReply* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* GetWorkers(
      ::grpc::CallbackServerContext* /*context*/, const ::fdbctl::GetWorkersRequest* /*request*/, ::fdbctl::GetWorkersReply* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_Include : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_Include() {
      ::grpc::Service::MarkMethodCallback(6,
          new ::grpc::internal::CallbackUnaryHandler< ::fdbctl::IncludeRequest, ::fdbctl::IncludeReply>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::fdbctl::IncludeRequest* request, ::fdbctl::IncludeReply* response) { return this->Include(context, request, response); }));}
    void SetMessageAllocatorFor_Include(
        ::grpc::MessageAllocator< ::fdbctl::IncludeRequest, ::fdbctl::IncludeReply>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(6);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::fdbctl::IncludeRequest, ::fdbctl::IncludeReply>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_Include() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Include(::grpc::ServerContext* /*context*/, const ::fdbctl::IncludeRequest* /*request*/, ::fdbctl::IncludeReply* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* Include(
      ::grpc::CallbackServerContext* /*context*/, const ::fdbctl::IncludeRequest* /*request*/, ::fdbctl::IncludeReply* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_Exclude : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_Exclude() {
      ::grpc::Service::MarkMethodCallback(7,
          new ::grpc::internal::CallbackUnaryHandler< ::fdbctl::ExcludeRequest, ::fdbctl::ExcludeReply>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::fdbctl::ExcludeRequest* request, ::fdbctl::ExcludeReply* response) { return this->Exclude(context, request, response); }));}
    void SetMessageAllocatorFor_Exclude(
        ::grpc::MessageAllocator< ::fdbctl::ExcludeRequest, ::fdbctl::ExcludeReply>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(7);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::fdbctl::ExcludeRequest, ::fdbctl::ExcludeReply>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_Exclude() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Exclude(::grpc::ServerContext* /*context*/, const ::fdbctl::ExcludeRequest* /*request*/, ::fdbctl::ExcludeReply* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* Exclude(
      ::grpc::CallbackServerContext* /*context*/, const ::fdbctl::ExcludeRequest* /*request*/, ::fdbctl::ExcludeReply* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_ExcludeStatus : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_ExcludeStatus() {
      ::grpc::Service::MarkMethodCallback(8,
          new ::grpc::internal::CallbackUnaryHandler< ::fdbctl::ExcludeStatusRequest, ::fdbctl::ExcludeStatusReply>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::fdbctl::ExcludeStatusRequest* request, ::fdbctl::ExcludeStatusReply* response) { return this->ExcludeStatus(context, request, response); }));}
    void SetMessageAllocatorFor_ExcludeStatus(
        ::grpc::MessageAllocator< ::fdbctl::ExcludeStatusRequest, ::fdbctl::ExcludeStatusReply>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(8);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::fdbctl::ExcludeStatusRequest, ::fdbctl::ExcludeStatusReply>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_ExcludeStatus() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ExcludeStatus(::grpc::ServerContext* /*context*/, const ::fdbctl::ExcludeStatusRequest* /*request*/, ::fdbctl::ExcludeStatusReply* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* ExcludeStatus(
      ::grpc::CallbackServerContext* /*context*/, const ::fdbctl::ExcludeStatusRequest* /*request*/, ::fdbctl::ExcludeStatusReply* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_Kill : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_Kill() {
      ::grpc::Service::MarkMethodCallback(9,
          new ::grpc::internal::CallbackUnaryHandler< ::fdbctl::KillRequest, ::fdbctl::KillReply>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::fdbctl::KillRequest* request, ::fdbctl::KillReply* response) { return this->Kill(context, request, response); }));}
    void SetMessageAllocatorFor_Kill(
        ::grpc::MessageAllocator< ::fdbctl::KillRequest, ::fdbctl::KillReply>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(9);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::fdbctl::KillRequest, ::fdbctl::KillReply>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_Kill() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Kill(::grpc::ServerContext* /*context*/, const ::fdbctl::KillRequest* /*request*/, ::fdbctl::KillReply* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* Kill(
      ::grpc::CallbackServerContext* /*context*/, const ::fdbctl::KillRequest* /*request*/, ::fdbctl::KillReply* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_Maintenance : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_Maintenance() {
      ::grpc::Service::MarkMethodCallback(10,
          new ::grpc::internal::CallbackUnaryHandler< ::fdbctl::MaintenanceRequest, ::fdbctl::MaintenanceReply>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::fdbctl::MaintenanceRequest* request, ::fdbctl::MaintenanceReply* response) { return this->Maintenance(context, request, response); }));}
    void SetMessageAllocatorFor_Maintenance(
        ::grpc::MessageAllocator< ::fdbctl::MaintenanceRequest, ::fdbctl::MaintenanceReply>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(10);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::fdbctl::MaintenanceRequest, ::fdbctl::MaintenanceReply>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_Maintenance() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Maintenance(::grpc::ServerContext* /*context*/, const ::fdbctl::MaintenanceRequest* /*request*/, ::fdbctl::MaintenanceReply* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* Maintenance(
      ::grpc::CallbackServerContext* /*context*/, const ::fdbctl::MaintenanceRequest* /*request*/, ::fdbctl::MaintenanceReply* /*response*/)  { return nullptr; }
  };
  typedef WithCallbackMethod_GetCoordinators<WithCallbackMethod_ChangeCoordinators<WithCallbackMethod_ConfigureAutoSuggest<WithCallbackMethod_Configure<WithCallbackMethod_GetStatus<WithCallbackMethod_GetWorkers<WithCallbackMethod_Include<WithCallbackMethod_Exclude<WithCallbackMethod_ExcludeStatus<WithCallbackMethod_Kill<WithCallbackMethod_Maintenance<Service > > > > > > > > > > > CallbackService;
  typedef CallbackService ExperimentalCallbackService;
  template <class BaseClass>
  class WithGenericMethod_GetCoordinators : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_GetCoordinators() {
      ::grpc::Service::MarkMethodGeneric(0);
    }
    ~WithGenericMethod_GetCoordinators() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetCoordinators(::grpc::ServerContext* /*context*/, const ::fdbctl::GetCoordinatorsRequest* /*request*/, ::fdbctl::GetCoordinatorsReply* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_ChangeCoordinators : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_ChangeCoordinators() {
      ::grpc::Service::MarkMethodGeneric(1);
    }
    ~WithGenericMethod_ChangeCoordinators() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ChangeCoordinators(::grpc::ServerContext* /*context*/, const ::fdbctl::ChangeCoordinatorsRequest* /*request*/, ::fdbctl::ChangeCoordinatorsReply* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_ConfigureAutoSuggest : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_ConfigureAutoSuggest() {
      ::grpc::Service::MarkMethodGeneric(2);
    }
    ~WithGenericMethod_ConfigureAutoSuggest() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ConfigureAutoSuggest(::grpc::ServerContext* /*context*/, const ::fdbctl::ConfigureAutoSuggestRequest* /*request*/, ::fdbctl::ConfigureAutoSuggestReply* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_Configure : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_Configure() {
      ::grpc::Service::MarkMethodGeneric(3);
    }
    ~WithGenericMethod_Configure() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Configure(::grpc::ServerContext* /*context*/, const ::fdbctl::ConfigureRequest* /*request*/, ::fdbctl::ConfigureReply* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_GetStatus : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_GetStatus() {
      ::grpc::Service::MarkMethodGeneric(4);
    }
    ~WithGenericMethod_GetStatus() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetStatus(::grpc::ServerContext* /*context*/, const ::fdbctl::GetStatusRequest* /*request*/, ::fdbctl::GetStatusReply* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_GetWorkers : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_GetWorkers() {
      ::grpc::Service::MarkMethodGeneric(5);
    }
    ~WithGenericMethod_GetWorkers() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetWorkers(::grpc::ServerContext* /*context*/, const ::fdbctl::GetWorkersRequest* /*request*/, ::fdbctl::GetWorkersReply* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_Include : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_Include() {
      ::grpc::Service::MarkMethodGeneric(6);
    }
    ~WithGenericMethod_Include() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Include(::grpc::ServerContext* /*context*/, const ::fdbctl::IncludeRequest* /*request*/, ::fdbctl::IncludeReply* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_Exclude : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_Exclude() {
      ::grpc::Service::MarkMethodGeneric(7);
    }
    ~WithGenericMethod_Exclude() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Exclude(::grpc::ServerContext* /*context*/, const ::fdbctl::ExcludeRequest* /*request*/, ::fdbctl::ExcludeReply* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_ExcludeStatus : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_ExcludeStatus() {
      ::grpc::Service::MarkMethodGeneric(8);
    }
    ~WithGenericMethod_ExcludeStatus() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ExcludeStatus(::grpc::ServerContext* /*context*/, const ::fdbctl::ExcludeStatusRequest* /*request*/, ::fdbctl::ExcludeStatusReply* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_Kill : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_Kill() {
      ::grpc::Service::MarkMethodGeneric(9);
    }
    ~WithGenericMethod_Kill() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Kill(::grpc::ServerContext* /*context*/, const ::fdbctl::KillRequest* /*request*/, ::fdbctl::KillReply* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_Maintenance : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_Maintenance() {
      ::grpc::Service::MarkMethodGeneric(10);
    }
    ~WithGenericMethod_Maintenance() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Maintenance(::grpc::ServerContext* /*context*/, const ::fdbctl::MaintenanceRequest* /*request*/, ::fdbctl::MaintenanceReply* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithRawMethod_GetCoordinators : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_GetCoordinators() {
      ::grpc::Service::MarkMethodRaw(0);
    }
    ~WithRawMethod_GetCoordinators() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetCoordinators(::grpc::ServerContext* /*context*/, const ::fdbctl::GetCoordinatorsRequest* /*request*/, ::fdbctl::GetCoordinatorsReply* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestGetCoordinators(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(0, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_ChangeCoordinators : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_ChangeCoordinators() {
      ::grpc::Service::MarkMethodRaw(1);
    }
    ~WithRawMethod_ChangeCoordinators() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ChangeCoordinators(::grpc::ServerContext* /*context*/, const ::fdbctl::ChangeCoordinatorsRequest* /*request*/, ::fdbctl::ChangeCoordinatorsReply* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestChangeCoordinators(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(1, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_ConfigureAutoSuggest : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_ConfigureAutoSuggest() {
      ::grpc::Service::MarkMethodRaw(2);
    }
    ~WithRawMethod_ConfigureAutoSuggest() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ConfigureAutoSuggest(::grpc::ServerContext* /*context*/, const ::fdbctl::ConfigureAutoSuggestRequest* /*request*/, ::fdbctl::ConfigureAutoSuggestReply* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestConfigureAutoSuggest(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(2, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_Configure : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_Configure() {
      ::grpc::Service::MarkMethodRaw(3);
    }
    ~WithRawMethod_Configure() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Configure(::grpc::ServerContext* /*context*/, const ::fdbctl::ConfigureRequest* /*request*/, ::fdbctl::ConfigureReply* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestConfigure(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(3, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_GetStatus : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_GetStatus() {
      ::grpc::Service::MarkMethodRaw(4);
    }
    ~WithRawMethod_GetStatus() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetStatus(::grpc::ServerContext* /*context*/, const ::fdbctl::GetStatusRequest* /*request*/, ::fdbctl::GetStatusReply* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestGetStatus(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(4, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_GetWorkers : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_GetWorkers() {
      ::grpc::Service::MarkMethodRaw(5);
    }
    ~WithRawMethod_GetWorkers() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetWorkers(::grpc::ServerContext* /*context*/, const ::fdbctl::GetWorkersRequest* /*request*/, ::fdbctl::GetWorkersReply* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestGetWorkers(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(5, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_Include : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_Include() {
      ::grpc::Service::MarkMethodRaw(6);
    }
    ~WithRawMethod_Include() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Include(::grpc::ServerContext* /*context*/, const ::fdbctl::IncludeRequest* /*request*/, ::fdbctl::IncludeReply* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestInclude(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(6, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_Exclude : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_Exclude() {
      ::grpc::Service::MarkMethodRaw(7);
    }
    ~WithRawMethod_Exclude() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Exclude(::grpc::ServerContext* /*context*/, const ::fdbctl::ExcludeRequest* /*request*/, ::fdbctl::ExcludeReply* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestExclude(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(7, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_ExcludeStatus : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_ExcludeStatus() {
      ::grpc::Service::MarkMethodRaw(8);
    }
    ~WithRawMethod_ExcludeStatus() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ExcludeStatus(::grpc::ServerContext* /*context*/, const ::fdbctl::ExcludeStatusRequest* /*request*/, ::fdbctl::ExcludeStatusReply* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestExcludeStatus(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(8, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_Kill : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_Kill() {
      ::grpc::Service::MarkMethodRaw(9);
    }
    ~WithRawMethod_Kill() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Kill(::grpc::ServerContext* /*context*/, const ::fdbctl::KillRequest* /*request*/, ::fdbctl::KillReply* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestKill(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(9, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_Maintenance : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_Maintenance() {
      ::grpc::Service::MarkMethodRaw(10);
    }
    ~WithRawMethod_Maintenance() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Maintenance(::grpc::ServerContext* /*context*/, const ::fdbctl::MaintenanceRequest* /*request*/, ::fdbctl::MaintenanceReply* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestMaintenance(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(10, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_GetCoordinators : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_GetCoordinators() {
      ::grpc::Service::MarkMethodRawCallback(0,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->GetCoordinators(context, request, response); }));
    }
    ~WithRawCallbackMethod_GetCoordinators() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetCoordinators(::grpc::ServerContext* /*context*/, const ::fdbctl::GetCoordinatorsRequest* /*request*/, ::fdbctl::GetCoordinatorsReply* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* GetCoordinators(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_ChangeCoordinators : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_ChangeCoordinators() {
      ::grpc::Service::MarkMethodRawCallback(1,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->ChangeCoordinators(context, request, response); }));
    }
    ~WithRawCallbackMethod_ChangeCoordinators() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ChangeCoordinators(::grpc::ServerContext* /*context*/, const ::fdbctl::ChangeCoordinatorsRequest* /*request*/, ::fdbctl::ChangeCoordinatorsReply* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* ChangeCoordinators(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_ConfigureAutoSuggest : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_ConfigureAutoSuggest() {
      ::grpc::Service::MarkMethodRawCallback(2,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->ConfigureAutoSuggest(context, request, response); }));
    }
    ~WithRawCallbackMethod_ConfigureAutoSuggest() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ConfigureAutoSuggest(::grpc::ServerContext* /*context*/, const ::fdbctl::ConfigureAutoSuggestRequest* /*request*/, ::fdbctl::ConfigureAutoSuggestReply* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* ConfigureAutoSuggest(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_Configure : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_Configure() {
      ::grpc::Service::MarkMethodRawCallback(3,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->Configure(context, request, response); }));
    }
    ~WithRawCallbackMethod_Configure() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Configure(::grpc::ServerContext* /*context*/, const ::fdbctl::ConfigureRequest* /*request*/, ::fdbctl::ConfigureReply* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* Configure(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_GetStatus : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_GetStatus() {
      ::grpc::Service::MarkMethodRawCallback(4,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->GetStatus(context, request, response); }));
    }
    ~WithRawCallbackMethod_GetStatus() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetStatus(::grpc::ServerContext* /*context*/, const ::fdbctl::GetStatusRequest* /*request*/, ::fdbctl::GetStatusReply* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* GetStatus(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_GetWorkers : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_GetWorkers() {
      ::grpc::Service::MarkMethodRawCallback(5,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->GetWorkers(context, request, response); }));
    }
    ~WithRawCallbackMethod_GetWorkers() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetWorkers(::grpc::ServerContext* /*context*/, const ::fdbctl::GetWorkersRequest* /*request*/, ::fdbctl::GetWorkersReply* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* GetWorkers(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_Include : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_Include() {
      ::grpc::Service::MarkMethodRawCallback(6,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->Include(context, request, response); }));
    }
    ~WithRawCallbackMethod_Include() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Include(::grpc::ServerContext* /*context*/, const ::fdbctl::IncludeRequest* /*request*/, ::fdbctl::IncludeReply* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* Include(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_Exclude : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_Exclude() {
      ::grpc::Service::MarkMethodRawCallback(7,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->Exclude(context, request, response); }));
    }
    ~WithRawCallbackMethod_Exclude() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Exclude(::grpc::ServerContext* /*context*/, const ::fdbctl::ExcludeRequest* /*request*/, ::fdbctl::ExcludeReply* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* Exclude(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_ExcludeStatus : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_ExcludeStatus() {
      ::grpc::Service::MarkMethodRawCallback(8,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->ExcludeStatus(context, request, response); }));
    }
    ~WithRawCallbackMethod_ExcludeStatus() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ExcludeStatus(::grpc::ServerContext* /*context*/, const ::fdbctl::ExcludeStatusRequest* /*request*/, ::fdbctl::ExcludeStatusReply* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* ExcludeStatus(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_Kill : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_Kill() {
      ::grpc::Service::MarkMethodRawCallback(9,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->Kill(context, request, response); }));
    }
    ~WithRawCallbackMethod_Kill() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Kill(::grpc::ServerContext* /*context*/, const ::fdbctl::KillRequest* /*request*/, ::fdbctl::KillReply* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* Kill(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_Maintenance : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_Maintenance() {
      ::grpc::Service::MarkMethodRawCallback(10,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->Maintenance(context, request, response); }));
    }
    ~WithRawCallbackMethod_Maintenance() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Maintenance(::grpc::ServerContext* /*context*/, const ::fdbctl::MaintenanceRequest* /*request*/, ::fdbctl::MaintenanceReply* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* Maintenance(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_GetCoordinators : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_GetCoordinators() {
      ::grpc::Service::MarkMethodStreamed(0,
        new ::grpc::internal::StreamedUnaryHandler<
          ::fdbctl::GetCoordinatorsRequest, ::fdbctl::GetCoordinatorsReply>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::fdbctl::GetCoordinatorsRequest, ::fdbctl::GetCoordinatorsReply>* streamer) {
                       return this->StreamedGetCoordinators(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_GetCoordinators() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status GetCoordinators(::grpc::ServerContext* /*context*/, const ::fdbctl::GetCoordinatorsRequest* /*request*/, ::fdbctl::GetCoordinatorsReply* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedGetCoordinators(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::fdbctl::GetCoordinatorsRequest,::fdbctl::GetCoordinatorsReply>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_ChangeCoordinators : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_ChangeCoordinators() {
      ::grpc::Service::MarkMethodStreamed(1,
        new ::grpc::internal::StreamedUnaryHandler<
          ::fdbctl::ChangeCoordinatorsRequest, ::fdbctl::ChangeCoordinatorsReply>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::fdbctl::ChangeCoordinatorsRequest, ::fdbctl::ChangeCoordinatorsReply>* streamer) {
                       return this->StreamedChangeCoordinators(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_ChangeCoordinators() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status ChangeCoordinators(::grpc::ServerContext* /*context*/, const ::fdbctl::ChangeCoordinatorsRequest* /*request*/, ::fdbctl::ChangeCoordinatorsReply* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedChangeCoordinators(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::fdbctl::ChangeCoordinatorsRequest,::fdbctl::ChangeCoordinatorsReply>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_ConfigureAutoSuggest : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_ConfigureAutoSuggest() {
      ::grpc::Service::MarkMethodStreamed(2,
        new ::grpc::internal::StreamedUnaryHandler<
          ::fdbctl::ConfigureAutoSuggestRequest, ::fdbctl::ConfigureAutoSuggestReply>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::fdbctl::ConfigureAutoSuggestRequest, ::fdbctl::ConfigureAutoSuggestReply>* streamer) {
                       return this->StreamedConfigureAutoSuggest(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_ConfigureAutoSuggest() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status ConfigureAutoSuggest(::grpc::ServerContext* /*context*/, const ::fdbctl::ConfigureAutoSuggestRequest* /*request*/, ::fdbctl::ConfigureAutoSuggestReply* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedConfigureAutoSuggest(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::fdbctl::ConfigureAutoSuggestRequest,::fdbctl::ConfigureAutoSuggestReply>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_Configure : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_Configure() {
      ::grpc::Service::MarkMethodStreamed(3,
        new ::grpc::internal::StreamedUnaryHandler<
          ::fdbctl::ConfigureRequest, ::fdbctl::ConfigureReply>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::fdbctl::ConfigureRequest, ::fdbctl::ConfigureReply>* streamer) {
                       return this->StreamedConfigure(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_Configure() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status Configure(::grpc::ServerContext* /*context*/, const ::fdbctl::ConfigureRequest* /*request*/, ::fdbctl::ConfigureReply* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedConfigure(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::fdbctl::ConfigureRequest,::fdbctl::ConfigureReply>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_GetStatus : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_GetStatus() {
      ::grpc::Service::MarkMethodStreamed(4,
        new ::grpc::internal::StreamedUnaryHandler<
          ::fdbctl::GetStatusRequest, ::fdbctl::GetStatusReply>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::fdbctl::GetStatusRequest, ::fdbctl::GetStatusReply>* streamer) {
                       return this->StreamedGetStatus(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_GetStatus() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status GetStatus(::grpc::ServerContext* /*context*/, const ::fdbctl::GetStatusRequest* /*request*/, ::fdbctl::GetStatusReply* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedGetStatus(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::fdbctl::GetStatusRequest,::fdbctl::GetStatusReply>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_GetWorkers : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_GetWorkers() {
      ::grpc::Service::MarkMethodStreamed(5,
        new ::grpc::internal::StreamedUnaryHandler<
          ::fdbctl::GetWorkersRequest, ::fdbctl::GetWorkersReply>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::fdbctl::GetWorkersRequest, ::fdbctl::GetWorkersReply>* streamer) {
                       return this->StreamedGetWorkers(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_GetWorkers() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status GetWorkers(::grpc::ServerContext* /*context*/, const ::fdbctl::GetWorkersRequest* /*request*/, ::fdbctl::GetWorkersReply* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedGetWorkers(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::fdbctl::GetWorkersRequest,::fdbctl::GetWorkersReply>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_Include : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_Include() {
      ::grpc::Service::MarkMethodStreamed(6,
        new ::grpc::internal::StreamedUnaryHandler<
          ::fdbctl::IncludeRequest, ::fdbctl::IncludeReply>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::fdbctl::IncludeRequest, ::fdbctl::IncludeReply>* streamer) {
                       return this->StreamedInclude(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_Include() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status Include(::grpc::ServerContext* /*context*/, const ::fdbctl::IncludeRequest* /*request*/, ::fdbctl::IncludeReply* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedInclude(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::fdbctl::IncludeRequest,::fdbctl::IncludeReply>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_Exclude : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_Exclude() {
      ::grpc::Service::MarkMethodStreamed(7,
        new ::grpc::internal::StreamedUnaryHandler<
          ::fdbctl::ExcludeRequest, ::fdbctl::ExcludeReply>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::fdbctl::ExcludeRequest, ::fdbctl::ExcludeReply>* streamer) {
                       return this->StreamedExclude(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_Exclude() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status Exclude(::grpc::ServerContext* /*context*/, const ::fdbctl::ExcludeRequest* /*request*/, ::fdbctl::ExcludeReply* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedExclude(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::fdbctl::ExcludeRequest,::fdbctl::ExcludeReply>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_ExcludeStatus : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_ExcludeStatus() {
      ::grpc::Service::MarkMethodStreamed(8,
        new ::grpc::internal::StreamedUnaryHandler<
          ::fdbctl::ExcludeStatusRequest, ::fdbctl::ExcludeStatusReply>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::fdbctl::ExcludeStatusRequest, ::fdbctl::ExcludeStatusReply>* streamer) {
                       return this->StreamedExcludeStatus(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_ExcludeStatus() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status ExcludeStatus(::grpc::ServerContext* /*context*/, const ::fdbctl::ExcludeStatusRequest* /*request*/, ::fdbctl::ExcludeStatusReply* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedExcludeStatus(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::fdbctl::ExcludeStatusRequest,::fdbctl::ExcludeStatusReply>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_Kill : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_Kill() {
      ::grpc::Service::MarkMethodStreamed(9,
        new ::grpc::internal::StreamedUnaryHandler<
          ::fdbctl::KillRequest, ::fdbctl::KillReply>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::fdbctl::KillRequest, ::fdbctl::KillReply>* streamer) {
                       return this->StreamedKill(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_Kill() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status Kill(::grpc::ServerContext* /*context*/, const ::fdbctl::KillRequest* /*request*/, ::fdbctl::KillReply* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedKill(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::fdbctl::KillRequest,::fdbctl::KillReply>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_Maintenance : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_Maintenance() {
      ::grpc::Service::MarkMethodStreamed(10,
        new ::grpc::internal::StreamedUnaryHandler<
          ::fdbctl::MaintenanceRequest, ::fdbctl::MaintenanceReply>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::fdbctl::MaintenanceRequest, ::fdbctl::MaintenanceReply>* streamer) {
                       return this->StreamedMaintenance(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_Maintenance() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status Maintenance(::grpc::ServerContext* /*context*/, const ::fdbctl::MaintenanceRequest* /*request*/, ::fdbctl::MaintenanceReply* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedMaintenance(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::fdbctl::MaintenanceRequest,::fdbctl::MaintenanceReply>* server_unary_streamer) = 0;
  };
  typedef WithStreamedUnaryMethod_GetCoordinators<WithStreamedUnaryMethod_ChangeCoordinators<WithStreamedUnaryMethod_ConfigureAutoSuggest<WithStreamedUnaryMethod_Configure<WithStreamedUnaryMethod_GetStatus<WithStreamedUnaryMethod_GetWorkers<WithStreamedUnaryMethod_Include<WithStreamedUnaryMethod_Exclude<WithStreamedUnaryMethod_ExcludeStatus<WithStreamedUnaryMethod_Kill<WithStreamedUnaryMethod_Maintenance<Service > > > > > > > > > > > StreamedUnaryService;
  typedef Service SplitStreamedService;
  typedef WithStreamedUnaryMethod_GetCoordinators<WithStreamedUnaryMethod_ChangeCoordinators<WithStreamedUnaryMethod_ConfigureAutoSuggest<WithStreamedUnaryMethod_Configure<WithStreamedUnaryMethod_GetStatus<WithStreamedUnaryMethod_GetWorkers<WithStreamedUnaryMethod_Include<WithStreamedUnaryMethod_Exclude<WithStreamedUnaryMethod_ExcludeStatus<WithStreamedUnaryMethod_Kill<WithStreamedUnaryMethod_Maintenance<Service > > > > > > > > > > > StreamedService;
};

}  // namespace fdbctl


#endif  // GRPC_control_5fservice_2eproto__INCLUDED
