#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/workloads/Rollback.actor.cpp"
/*
 * Rollback.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2026 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "flow/DeterministicRandom.h"
#include "fdbclient/NativeAPI.actor.h"
#include "fdbserver/TesterInterface.actor.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "fdbrpc/simulator.h"
#include "fdbserver/MasterInterface.h"
#include "fdbclient/SystemData.h"
#include "fdbserver/ServerDBInfo.h"
#include "flow/actorcompiler.h" // This must be the last #include.

// Choose a random proxy and a random tLog, represented as unclogTlog.
// The workload first clogs network link between the chosen proxy and all tLogs but the unclogTlog;
// While the network is still clogged, the workload kills the proxy and clogs the unclogged tlog's interface.
// Note: The clogged network link's latency will become "clogDuration".
struct RollbackWorkload : FailureInjectionWorkload {
	static constexpr auto NAME = "Rollback";

	bool enableFailures = false, multiple = true, enabled;
	double meanDelay = 20.0, clogDuration = clogDuration = 3.0, testDuration = 10.0;

	RollbackWorkload(WorkloadContext const& wcx, NoOptions) : FailureInjectionWorkload(wcx) {}

	RollbackWorkload(WorkloadContext const& wcx) : FailureInjectionWorkload(wcx) {
		enabled = !clientId; // only do this on the "first" client
		meanDelay = getOption(options, "meanDelay"_sr, meanDelay); // Only matters if multiple==true
		clogDuration = getOption(options, "clogDuration"_sr, clogDuration);
		testDuration = getOption(options, "testDuration"_sr, testDuration);
		enableFailures = getOption(options, "enableFailures"_sr, enableFailures);
		multiple = getOption(options, "multiple"_sr, multiple);
	}

	void initFailureInjectionMode(DeterministicRandom& random) override {
		enabled = clientId == 0;
		multiple = random.coinflip();
		enableFailures = random.random01() < 0.2;
	}

	Future<Void> setup(Database const& cx) override { return Void(); }
	Future<Void> start(Database const& cx) override {
		if (g_simulator == g_network && enabled)
			return timeout(reportErrors(rollbackFailureWorker(cx, this, meanDelay), "RollbackFailureWorkerError"),
			               testDuration,
			               Void());
		return Void();
	}
	Future<bool> check(Database const& cx) override { return true; }
	void getMetrics(std::vector<PerfMetric>& m) override {}

																#line 71 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Rollback.actor.g.cpp.py_gen"
// This generated class is to be used only via simulateFailure()
															#line 69 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/workloads/Rollback.actor.cpp"
template <class SimulateFailureActor>
															#line 69 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/workloads/Rollback.actor.cpp"
class SimulateFailureActorState {
															#line 77 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Rollback.actor.g.cpp.py_gen"
public:
															#line 69 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/workloads/Rollback.actor.cpp"
	SimulateFailureActorState(Database const& cx,RollbackWorkload* const& self) 
															#line 69 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/workloads/Rollback.actor.cpp"
															#line 69 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/workloads/Rollback.actor.cpp"
		 : cx(cx),
															#line 69 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/workloads/Rollback.actor.cpp"
		   self(self),
															#line 70 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/workloads/Rollback.actor.cpp"
		   system(self->dbInfo->get())
															#line 88 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Rollback.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("simulateFailure", reinterpret_cast<unsigned long>(this));

	}
	~SimulateFailureActorState() 
	{
		fdb_probe_actor_destroy("simulateFailure", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 71 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/workloads/Rollback.actor.cpp"
			auto tlogs = system.logSystemConfig.allPresentLogs();
															#line 73 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/workloads/Rollback.actor.cpp"
			if (tlogs.empty() || system.client.commitProxies.empty())
															#line 105 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Rollback.actor.g.cpp.py_gen"
			{
															#line 74 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/workloads/Rollback.actor.cpp"
				TraceEvent(SevInfo, "UnableToTriggerRollback").detail("Reason", "No tlogs in System Map");
															#line 75 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/workloads/Rollback.actor.cpp"
				if (!static_cast<SimulateFailureActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SimulateFailureActorState(); static_cast<SimulateFailureActor*>(this)->destroy(); return 0; }
															#line 111 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Rollback.actor.g.cpp.py_gen"
				new (&static_cast<SimulateFailureActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~SimulateFailureActorState();
				static_cast<SimulateFailureActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 78 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/workloads/Rollback.actor.cpp"
			proxy = deterministicRandom()->randomChoice(system.client.commitProxies);
															#line 80 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/workloads/Rollback.actor.cpp"
			int utIndex = deterministicRandom()->randomInt(0, tlogs.size());
															#line 81 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/workloads/Rollback.actor.cpp"
			uncloggedTLog = tlogs[utIndex].address();
															#line 83 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/workloads/Rollback.actor.cpp"
			for(int t = 0;t < tlogs.size();t++) {
															#line 84 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/workloads/Rollback.actor.cpp"
				if (t != utIndex)
															#line 127 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Rollback.actor.g.cpp.py_gen"
				{
															#line 85 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/workloads/Rollback.actor.cpp"
					if (tlogs[t].address().ip == proxy.address().ip)
															#line 131 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Rollback.actor.g.cpp.py_gen"
					{
															#line 86 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/workloads/Rollback.actor.cpp"
						TraceEvent(SevInfo, "UnableToTriggerRollback").detail("Reason", "proxy-clogged tLog shared IPs");
															#line 87 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/workloads/Rollback.actor.cpp"
						if (!static_cast<SimulateFailureActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SimulateFailureActorState(); static_cast<SimulateFailureActor*>(this)->destroy(); return 0; }
															#line 137 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Rollback.actor.g.cpp.py_gen"
						new (&static_cast<SimulateFailureActor*>(this)->SAV< Void >::value()) Void(Void());
						this->~SimulateFailureActorState();
						static_cast<SimulateFailureActor*>(this)->finishSendAndDelPromiseRef();
						return 0;
					}
				}
			}
															#line 90 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/workloads/Rollback.actor.cpp"
			TraceEvent("AttemptingToTriggerRollback") .detail("CommitProxy", proxy.address()) .detail("UncloggedTLog", uncloggedTLog);
															#line 94 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/workloads/Rollback.actor.cpp"
			for(int t = 0;t < tlogs.size();t++) {
															#line 95 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/workloads/Rollback.actor.cpp"
				if (t != utIndex)
															#line 151 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Rollback.actor.g.cpp.py_gen"
				{
															#line 96 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/workloads/Rollback.actor.cpp"
					g_simulator->clogPair(proxy.address().ip, tlogs[t].address().ip, self->clogDuration);
															#line 155 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Rollback.actor.g.cpp.py_gen"
				}
			}
															#line 103 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/workloads/Rollback.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(self->clogDuration / 3);
															#line 103 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/workloads/Rollback.actor.cpp"
			if (static_cast<SimulateFailureActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 162 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Rollback.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<SimulateFailureActor*>(this)->actor_wait_state = 1;
															#line 103 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/workloads/Rollback.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SimulateFailureActor, 0, Void >*>(static_cast<SimulateFailureActor*>(this)));
															#line 167 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Rollback.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SimulateFailureActorState();
		static_cast<SimulateFailureActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 104 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/workloads/Rollback.actor.cpp"
		system = self->dbInfo->get();
															#line 106 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/workloads/Rollback.actor.cpp"
		if (self->enableFailures)
															#line 192 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Rollback.actor.g.cpp.py_gen"
		{
															#line 108 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/workloads/Rollback.actor.cpp"
			g_simulator->rebootProcess(g_simulator->getProcessByAddress(proxy.address()), ISimulator::KillType::Reboot);
															#line 109 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/workloads/Rollback.actor.cpp"
			g_simulator->clogInterface(uncloggedTLog.ip, self->clogDuration, ClogAll);
															#line 198 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Rollback.actor.g.cpp.py_gen"
		}
		else
		{
															#line 112 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/workloads/Rollback.actor.cpp"
			g_simulator->clogInterface(proxy.address().ip, self->clogDuration, ClogAll);
															#line 113 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/workloads/Rollback.actor.cpp"
			g_simulator->clogInterface(uncloggedTLog.ip, self->clogDuration, ClogAll);
															#line 206 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Rollback.actor.g.cpp.py_gen"
		}
															#line 115 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/workloads/Rollback.actor.cpp"
		if (!static_cast<SimulateFailureActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SimulateFailureActorState(); static_cast<SimulateFailureActor*>(this)->destroy(); return 0; }
															#line 210 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Rollback.actor.g.cpp.py_gen"
		new (&static_cast<SimulateFailureActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SimulateFailureActorState();
		static_cast<SimulateFailureActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 104 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/workloads/Rollback.actor.cpp"
		system = self->dbInfo->get();
															#line 106 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/workloads/Rollback.actor.cpp"
		if (self->enableFailures)
															#line 224 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Rollback.actor.g.cpp.py_gen"
		{
															#line 108 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/workloads/Rollback.actor.cpp"
			g_simulator->rebootProcess(g_simulator->getProcessByAddress(proxy.address()), ISimulator::KillType::Reboot);
															#line 109 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/workloads/Rollback.actor.cpp"
			g_simulator->clogInterface(uncloggedTLog.ip, self->clogDuration, ClogAll);
															#line 230 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Rollback.actor.g.cpp.py_gen"
		}
		else
		{
															#line 112 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/workloads/Rollback.actor.cpp"
			g_simulator->clogInterface(proxy.address().ip, self->clogDuration, ClogAll);
															#line 113 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/workloads/Rollback.actor.cpp"
			g_simulator->clogInterface(uncloggedTLog.ip, self->clogDuration, ClogAll);
															#line 238 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Rollback.actor.g.cpp.py_gen"
		}
															#line 115 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/workloads/Rollback.actor.cpp"
		if (!static_cast<SimulateFailureActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SimulateFailureActorState(); static_cast<SimulateFailureActor*>(this)->destroy(); return 0; }
															#line 242 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Rollback.actor.g.cpp.py_gen"
		new (&static_cast<SimulateFailureActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SimulateFailureActorState();
		static_cast<SimulateFailureActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SimulateFailureActor*>(this)->actor_wait_state > 0) static_cast<SimulateFailureActor*>(this)->actor_wait_state = 0;
		static_cast<SimulateFailureActor*>(this)->ActorCallback< SimulateFailureActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SimulateFailureActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("simulateFailure", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SimulateFailureActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simulateFailure", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SimulateFailureActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("simulateFailure", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SimulateFailureActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simulateFailure", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SimulateFailureActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("simulateFailure", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SimulateFailureActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simulateFailure", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 69 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/workloads/Rollback.actor.cpp"
	Database cx;
															#line 69 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/workloads/Rollback.actor.cpp"
	RollbackWorkload* self;
															#line 70 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/workloads/Rollback.actor.cpp"
	ServerDBInfo system;
															#line 78 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/workloads/Rollback.actor.cpp"
	CommitProxyInterface proxy;
															#line 81 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/workloads/Rollback.actor.cpp"
	NetworkAddress uncloggedTLog;
															#line 335 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Rollback.actor.g.cpp.py_gen"
};
// This generated class is to be used only via simulateFailure()
															#line 69 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/workloads/Rollback.actor.cpp"
class SimulateFailureActor final : public Actor<Void>, public ActorCallback< SimulateFailureActor, 0, Void >, public FastAllocated<SimulateFailureActor>, public SimulateFailureActorState<SimulateFailureActor> {
															#line 340 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Rollback.actor.g.cpp.py_gen"
public:
	using FastAllocated<SimulateFailureActor>::operator new;
	using FastAllocated<SimulateFailureActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4819057449993907968UL, 16440626149975066880UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SimulateFailureActor, 0, Void >;
															#line 69 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/workloads/Rollback.actor.cpp"
	SimulateFailureActor(Database const& cx,RollbackWorkload* const& self) 
															#line 357 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Rollback.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   SimulateFailureActorState<SimulateFailureActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("simulateFailure", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7886126033834240000UL, 8994916749678400768UL);
		ActorExecutionContextHelper __helper(static_cast<SimulateFailureActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("simulateFailure");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("simulateFailure", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SimulateFailureActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 69 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/workloads/Rollback.actor.cpp"
[[nodiscard]] Future<Void> simulateFailure( Database const& cx, RollbackWorkload* const& self ) {
															#line 69 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/workloads/Rollback.actor.cpp"
	return Future<Void>(new SimulateFailureActor(cx, self));
															#line 389 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Rollback.actor.g.cpp.py_gen"
}

#line 117 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/workloads/Rollback.actor.cpp"

																#line 394 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Rollback.actor.g.cpp.py_gen"
// This generated class is to be used only via rollbackFailureWorker()
															#line 118 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/workloads/Rollback.actor.cpp"
template <class RollbackFailureWorkerActor>
															#line 118 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/workloads/Rollback.actor.cpp"
class RollbackFailureWorkerActorState {
															#line 400 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Rollback.actor.g.cpp.py_gen"
public:
															#line 118 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/workloads/Rollback.actor.cpp"
	RollbackFailureWorkerActorState(Database const& cx,RollbackWorkload* const& self,double const& delay) 
															#line 118 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/workloads/Rollback.actor.cpp"
															#line 118 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/workloads/Rollback.actor.cpp"
		 : cx(cx),
															#line 118 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/workloads/Rollback.actor.cpp"
		   self(self),
															#line 118 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/workloads/Rollback.actor.cpp"
		   delay(delay),
															#line 119 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/workloads/Rollback.actor.cpp"
		   events()
															#line 413 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Rollback.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("rollbackFailureWorker", reinterpret_cast<unsigned long>(this));

	}
	~RollbackFailureWorkerActorState() 
	{
		fdb_probe_actor_destroy("rollbackFailureWorker", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 120 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/workloads/Rollback.actor.cpp"
			if (self->multiple)
															#line 428 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Rollback.actor.g.cpp.py_gen"
			{
															#line 121 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/workloads/Rollback.actor.cpp"
				lastTime = now();
															#line 122 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/workloads/Rollback.actor.cpp"
				;
															#line 434 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Rollback.actor.g.cpp.py_gen"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			else
			{
															#line 127 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/workloads/Rollback.actor.cpp"
				StrictFuture<Void> __when_expr_2 = ::delay(deterministicRandom()->random01() * std::max(0.0, self->testDuration - self->clogDuration * 13.0));
															#line 127 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/workloads/Rollback.actor.cpp"
				if (static_cast<RollbackFailureWorkerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 443 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Rollback.actor.g.cpp.py_gen"
				if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1when1(__when_expr_2.get(), loopDepth); };
				static_cast<RollbackFailureWorkerActor*>(this)->actor_wait_state = 3;
															#line 127 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/workloads/Rollback.actor.cpp"
				__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RollbackFailureWorkerActor, 2, Void >*>(static_cast<RollbackFailureWorkerActor*>(this)));
															#line 448 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Rollback.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RollbackFailureWorkerActorState();
		static_cast<RollbackFailureWorkerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 131 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/workloads/Rollback.actor.cpp"
		if (!static_cast<RollbackFailureWorkerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RollbackFailureWorkerActorState(); static_cast<RollbackFailureWorkerActor*>(this)->destroy(); return 0; }
															#line 472 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Rollback.actor.g.cpp.py_gen"
		new (&static_cast<RollbackFailureWorkerActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RollbackFailureWorkerActorState();
		static_cast<RollbackFailureWorkerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 123 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/workloads/Rollback.actor.cpp"
		StrictFuture<Void> __when_expr_0 = poisson(&lastTime, delay);
															#line 123 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/workloads/Rollback.actor.cpp"
		if (static_cast<RollbackFailureWorkerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 493 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Rollback.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<RollbackFailureWorkerActor*>(this)->actor_wait_state = 1;
															#line 123 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/workloads/Rollback.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RollbackFailureWorkerActor, 0, Void >*>(static_cast<RollbackFailureWorkerActor*>(this)));
															#line 498 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Rollback.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 124 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/workloads/Rollback.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->simulateFailure(cx, self);
															#line 124 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/workloads/Rollback.actor.cpp"
		if (static_cast<RollbackFailureWorkerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 509 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Rollback.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<RollbackFailureWorkerActor*>(this)->actor_wait_state = 2;
															#line 124 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/workloads/Rollback.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RollbackFailureWorkerActor, 1, Void >*>(static_cast<RollbackFailureWorkerActor*>(this)));
															#line 514 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Rollback.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 124 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/workloads/Rollback.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->simulateFailure(cx, self);
															#line 124 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/workloads/Rollback.actor.cpp"
		if (static_cast<RollbackFailureWorkerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 525 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Rollback.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<RollbackFailureWorkerActor*>(this)->actor_wait_state = 2;
															#line 124 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/workloads/Rollback.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RollbackFailureWorkerActor, 1, Void >*>(static_cast<RollbackFailureWorkerActor*>(this)));
															#line 530 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Rollback.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RollbackFailureWorkerActor*>(this)->actor_wait_state > 0) static_cast<RollbackFailureWorkerActor*>(this)->actor_wait_state = 0;
		static_cast<RollbackFailureWorkerActor*>(this)->ActorCallback< RollbackFailureWorkerActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RollbackFailureWorkerActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("rollbackFailureWorker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RollbackFailureWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rollbackFailureWorker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RollbackFailureWorkerActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("rollbackFailureWorker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RollbackFailureWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rollbackFailureWorker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RollbackFailureWorkerActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("rollbackFailureWorker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RollbackFailureWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rollbackFailureWorker", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RollbackFailureWorkerActor*>(this)->actor_wait_state > 0) static_cast<RollbackFailureWorkerActor*>(this)->actor_wait_state = 0;
		static_cast<RollbackFailureWorkerActor*>(this)->ActorCallback< RollbackFailureWorkerActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RollbackFailureWorkerActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("rollbackFailureWorker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RollbackFailureWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rollbackFailureWorker", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RollbackFailureWorkerActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("rollbackFailureWorker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RollbackFailureWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rollbackFailureWorker", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RollbackFailureWorkerActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("rollbackFailureWorker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RollbackFailureWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rollbackFailureWorker", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 129 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/workloads/Rollback.actor.cpp"
		StrictFuture<Void> __when_expr_3 = self->simulateFailure(cx, self);
															#line 129 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/workloads/Rollback.actor.cpp"
		if (static_cast<RollbackFailureWorkerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 703 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Rollback.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<RollbackFailureWorkerActor*>(this)->actor_wait_state = 4;
															#line 129 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/workloads/Rollback.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< RollbackFailureWorkerActor, 3, Void >*>(static_cast<RollbackFailureWorkerActor*>(this)));
															#line 708 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Rollback.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 129 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/workloads/Rollback.actor.cpp"
		StrictFuture<Void> __when_expr_3 = self->simulateFailure(cx, self);
															#line 129 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/workloads/Rollback.actor.cpp"
		if (static_cast<RollbackFailureWorkerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 719 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Rollback.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<RollbackFailureWorkerActor*>(this)->actor_wait_state = 4;
															#line 129 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/workloads/Rollback.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< RollbackFailureWorkerActor, 3, Void >*>(static_cast<RollbackFailureWorkerActor*>(this)));
															#line 724 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Rollback.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<RollbackFailureWorkerActor*>(this)->actor_wait_state > 0) static_cast<RollbackFailureWorkerActor*>(this)->actor_wait_state = 0;
		static_cast<RollbackFailureWorkerActor*>(this)->ActorCallback< RollbackFailureWorkerActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RollbackFailureWorkerActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("rollbackFailureWorker", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RollbackFailureWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rollbackFailureWorker", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< RollbackFailureWorkerActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("rollbackFailureWorker", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RollbackFailureWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rollbackFailureWorker", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< RollbackFailureWorkerActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("rollbackFailureWorker", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RollbackFailureWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rollbackFailureWorker", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<RollbackFailureWorkerActor*>(this)->actor_wait_state > 0) static_cast<RollbackFailureWorkerActor*>(this)->actor_wait_state = 0;
		static_cast<RollbackFailureWorkerActor*>(this)->ActorCallback< RollbackFailureWorkerActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RollbackFailureWorkerActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("rollbackFailureWorker", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RollbackFailureWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rollbackFailureWorker", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< RollbackFailureWorkerActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("rollbackFailureWorker", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RollbackFailureWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rollbackFailureWorker", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< RollbackFailureWorkerActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("rollbackFailureWorker", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RollbackFailureWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rollbackFailureWorker", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 118 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/workloads/Rollback.actor.cpp"
	Database cx;
															#line 118 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/workloads/Rollback.actor.cpp"
	RollbackWorkload* self;
															#line 118 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/workloads/Rollback.actor.cpp"
	double delay;
															#line 119 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/workloads/Rollback.actor.cpp"
	PromiseStream<Void> events;
															#line 121 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/workloads/Rollback.actor.cpp"
	double lastTime;
															#line 901 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Rollback.actor.g.cpp.py_gen"
};
// This generated class is to be used only via rollbackFailureWorker()
															#line 118 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/workloads/Rollback.actor.cpp"
class RollbackFailureWorkerActor final : public Actor<Void>, public ActorCallback< RollbackFailureWorkerActor, 0, Void >, public ActorCallback< RollbackFailureWorkerActor, 1, Void >, public ActorCallback< RollbackFailureWorkerActor, 2, Void >, public ActorCallback< RollbackFailureWorkerActor, 3, Void >, public FastAllocated<RollbackFailureWorkerActor>, public RollbackFailureWorkerActorState<RollbackFailureWorkerActor> {
															#line 906 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Rollback.actor.g.cpp.py_gen"
public:
	using FastAllocated<RollbackFailureWorkerActor>::operator new;
	using FastAllocated<RollbackFailureWorkerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7525759465876058880UL, 2535628258153929728UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RollbackFailureWorkerActor, 0, Void >;
friend struct ActorCallback< RollbackFailureWorkerActor, 1, Void >;
friend struct ActorCallback< RollbackFailureWorkerActor, 2, Void >;
friend struct ActorCallback< RollbackFailureWorkerActor, 3, Void >;
															#line 118 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/workloads/Rollback.actor.cpp"
	RollbackFailureWorkerActor(Database const& cx,RollbackWorkload* const& self,double const& delay) 
															#line 926 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Rollback.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   RollbackFailureWorkerActorState<RollbackFailureWorkerActor>(cx, self, delay),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("rollbackFailureWorker", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8308122062281736960UL, 8943390452696421376UL);
		ActorExecutionContextHelper __helper(static_cast<RollbackFailureWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("rollbackFailureWorker");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("rollbackFailureWorker", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RollbackFailureWorkerActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RollbackFailureWorkerActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< RollbackFailureWorkerActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< RollbackFailureWorkerActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 118 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/workloads/Rollback.actor.cpp"
[[nodiscard]] Future<Void> rollbackFailureWorker( Database const& cx, RollbackWorkload* const& self, double const& delay ) {
															#line 118 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/workloads/Rollback.actor.cpp"
	return Future<Void>(new RollbackFailureWorkerActor(cx, self, delay));
															#line 961 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Rollback.actor.g.cpp.py_gen"
}

#line 133 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/workloads/Rollback.actor.cpp"
};

WorkloadFactory<RollbackWorkload> RollbackWorkloadFactory;
FailureInjectorFactory<RollbackWorkload> RollbackFailureInjectorFactory;
