#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
/*
 * CommitProxyServer.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2026 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <algorithm>
#include <string_view>
#include <tuple>
#include <variant>

#include "fdbclient/AccumulativeChecksum.h"
#include "fdbclient/Atomic.h"
#include "fdbclient/BackupAgent.actor.h"
#include "fdbclient/BuildIdempotencyIdMutations.h"
#include "fdbclient/CommitTransaction.h"
#include "fdbclient/DatabaseContext.h"
#include "fdbclient/FDBTypes.h"
#include "fdbclient/IdempotencyId.actor.h"
#include "fdbclient/Knobs.h"
#include "fdbclient/CommitProxyInterface.h"
#include "fdbclient/NativeAPI.actor.h"
#include "fdbclient/SystemData.h"
#include "fdbclient/Tracing.h"
#include "fdbclient/TransactionLineage.h"
#include "fdbrpc/sim_validation.h"
#include "fdbserver/AccumulativeChecksumUtil.h"
#include "fdbserver/ApplyMetadataMutation.h"
#include "fdbserver/ConflictSet.h"
#include "fdbserver/DataDistributorInterface.h"
#include "fdbserver/FDBExecHelper.actor.h"
#include "fdbserver/IKeyValueStore.h"
#include "fdbserver/Knobs.h"
#include "fdbserver/LogSystem.h"
#include "fdbserver/LogSystemDiskQueueAdapter.h"
#include "fdbserver/MasterInterface.h"
#include "fdbserver/MutationTracking.h"
#include "fdbserver/ProxyCommitData.actor.h"
#include "fdbserver/RatekeeperInterface.h"
#include "fdbserver/RecoveryState.h"
#include "fdbserver/RestoreUtil.h"
#include "fdbserver/ServerDBInfo.actor.h"
#include "fdbserver/WaitFailure.h"
#include "fdbserver/WorkerInterface.actor.h"
#include "flow/ActorCollection.h"
#include "flow/CodeProbe.h"
#include "flow/EncryptUtils.h"
#include "flow/Error.h"
#include "flow/IRandom.h"
#include "flow/Knobs.h"
#include "flow/Trace.h"
#include "flow/network.h"

#include "flow/actorcompiler.h" // This must be the last #include.

using WriteMutationRefVar = std::variant<MutationRef, VectorRef<MutationRef>>;

															#line 74 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via broadcastTxnRequest()
															#line 72 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
template <class BroadcastTxnRequestActor>
															#line 72 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class BroadcastTxnRequestActorState {
															#line 81 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
															#line 72 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	BroadcastTxnRequestActorState(TxnStateRequest const& req,int const& sendAmount,bool const& sendReply) 
															#line 72 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
															#line 72 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		 : req(req),
															#line 72 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   sendAmount(sendAmount),
															#line 72 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   sendReply(sendReply),
															#line 73 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   reply(req.reply)
															#line 94 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("broadcastTxnRequest", reinterpret_cast<unsigned long>(this));

	}
	~BroadcastTxnRequestActorState() 
	{
		fdb_probe_actor_destroy("broadcastTxnRequest", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 74 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			resetReply(req);
															#line 75 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			std::vector<Future<Void>> replies;
															#line 76 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			int currentStream = 0;
															#line 77 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			std::vector<Endpoint> broadcastEndpoints = req.broadcastInfo;
															#line 78 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			for(int i = 0;i < sendAmount && currentStream < broadcastEndpoints.size();i++) {
															#line 79 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				std::vector<Endpoint> endpoints;
															#line 80 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				RequestStream<TxnStateRequest> cur(broadcastEndpoints[currentStream++]);
															#line 81 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				for(;currentStream < broadcastEndpoints.size() * (i + 1) / sendAmount;) {
															#line 82 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					endpoints.push_back(broadcastEndpoints[currentStream++]);
															#line 125 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				}
															#line 84 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				req.broadcastInfo = endpoints;
															#line 85 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				replies.push_back(brokenPromiseToNever(cur.getReply(req)));
															#line 86 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				resetReply(req);
															#line 133 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
															#line 88 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			StrictFuture<Void> __when_expr_0 = waitForAll(replies);
															#line 88 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (static_cast<BroadcastTxnRequestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 139 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<BroadcastTxnRequestActor*>(this)->actor_wait_state = 1;
															#line 88 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< BroadcastTxnRequestActor, 0, Void >*>(static_cast<BroadcastTxnRequestActor*>(this)));
															#line 144 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~BroadcastTxnRequestActorState();
		static_cast<BroadcastTxnRequestActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 89 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (sendReply)
															#line 167 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 90 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			reply.send(Void());
															#line 171 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 92 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!static_cast<BroadcastTxnRequestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~BroadcastTxnRequestActorState(); static_cast<BroadcastTxnRequestActor*>(this)->destroy(); return 0; }
															#line 175 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		new (&static_cast<BroadcastTxnRequestActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~BroadcastTxnRequestActorState();
		static_cast<BroadcastTxnRequestActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 89 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (sendReply)
															#line 187 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 90 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			reply.send(Void());
															#line 191 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 92 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!static_cast<BroadcastTxnRequestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~BroadcastTxnRequestActorState(); static_cast<BroadcastTxnRequestActor*>(this)->destroy(); return 0; }
															#line 195 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		new (&static_cast<BroadcastTxnRequestActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~BroadcastTxnRequestActorState();
		static_cast<BroadcastTxnRequestActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<BroadcastTxnRequestActor*>(this)->actor_wait_state > 0) static_cast<BroadcastTxnRequestActor*>(this)->actor_wait_state = 0;
		static_cast<BroadcastTxnRequestActor*>(this)->ActorCallback< BroadcastTxnRequestActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BroadcastTxnRequestActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("broadcastTxnRequest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BroadcastTxnRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("broadcastTxnRequest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< BroadcastTxnRequestActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("broadcastTxnRequest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BroadcastTxnRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("broadcastTxnRequest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< BroadcastTxnRequestActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("broadcastTxnRequest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BroadcastTxnRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("broadcastTxnRequest", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 72 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	TxnStateRequest req;
															#line 72 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	int sendAmount;
															#line 72 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	bool sendReply;
															#line 73 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ReplyPromise<Void> reply;
															#line 286 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via broadcastTxnRequest()
															#line 72 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class BroadcastTxnRequestActor final : public Actor<Void>, public ActorCallback< BroadcastTxnRequestActor, 0, Void >, public FastAllocated<BroadcastTxnRequestActor>, public BroadcastTxnRequestActorState<BroadcastTxnRequestActor> {
															#line 291 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
	using FastAllocated<BroadcastTxnRequestActor>::operator new;
	using FastAllocated<BroadcastTxnRequestActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5009050020339259904UL, 6640026967676004096UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< BroadcastTxnRequestActor, 0, Void >;
															#line 72 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	BroadcastTxnRequestActor(TxnStateRequest const& req,int const& sendAmount,bool const& sendReply) 
															#line 308 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   BroadcastTxnRequestActorState<BroadcastTxnRequestActor>(req, sendAmount, sendReply),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("broadcastTxnRequest", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18432169453488638208UL, 15272042735295047168UL);
		ActorExecutionContextHelper __helper(static_cast<BroadcastTxnRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("broadcastTxnRequest");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("broadcastTxnRequest", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< BroadcastTxnRequestActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 72 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
[[nodiscard]] Future<Void> broadcastTxnRequest( TxnStateRequest const& req, int const& sendAmount, bool const& sendReply ) {
															#line 72 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	return Future<Void>(new BroadcastTxnRequestActor(req, sendAmount, sendReply));
															#line 341 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
}

#line 94 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"

															#line 346 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via discardCommit()
															#line 95 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
template <class DiscardCommitActor>
															#line 95 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class DiscardCommitActorState {
															#line 353 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
															#line 95 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	DiscardCommitActorState(UID const& id,Future<LogSystemDiskQueueAdapter::CommitMessage> const& fcm,Future<Void> const& dummyCommitState) 
															#line 95 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
															#line 95 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		 : id(id),
															#line 95 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   fcm(fcm),
															#line 95 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   dummyCommitState(dummyCommitState)
															#line 364 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("discardCommit", reinterpret_cast<unsigned long>(this));

	}
	~DiscardCommitActorState() 
	{
		fdb_probe_actor_destroy("discardCommit", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 96 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			ASSERT(!dummyCommitState.isReady());
															#line 97 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			StrictFuture<LogSystemDiskQueueAdapter::CommitMessage> __when_expr_0 = fcm;
															#line 97 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
															#line 383 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			static_cast<DiscardCommitActor*>(this)->actor_wait_state = 1;
															#line 97 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DiscardCommitActor, 0, LogSystemDiskQueueAdapter::CommitMessage >*>(static_cast<DiscardCommitActor*>(this)));
															#line 387 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		delete static_cast<DiscardCommitActor*>(this);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(LogSystemDiskQueueAdapter::CommitMessage const& cm,int loopDepth) 
	{
															#line 98 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		TraceEvent("Discarding", id).detail("Count", cm.messages.size());
															#line 99 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		cm.acknowledge.send(Void());
															#line 100 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		ASSERT(dummyCommitState.isReady());
															#line 413 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(LogSystemDiskQueueAdapter::CommitMessage && cm,int loopDepth) 
	{
															#line 98 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		TraceEvent("Discarding", id).detail("Count", cm.messages.size());
															#line 99 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		cm.acknowledge.send(Void());
															#line 100 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		ASSERT(dummyCommitState.isReady());
															#line 426 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1when1(LogSystemDiskQueueAdapter::CommitMessage const& cm,int loopDepth) 
	{
		loopDepth = a_body1cont1(cm, loopDepth);

		return loopDepth;
	}
	int a_body1when1(LogSystemDiskQueueAdapter::CommitMessage && cm,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(cm), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DiscardCommitActor*>(this)->actor_wait_state > 0) static_cast<DiscardCommitActor*>(this)->actor_wait_state = 0;
		static_cast<DiscardCommitActor*>(this)->ActorCallback< DiscardCommitActor, 0, LogSystemDiskQueueAdapter::CommitMessage >::remove();

	}
	void a_callback_fire(ActorCallback< DiscardCommitActor, 0, LogSystemDiskQueueAdapter::CommitMessage >*,LogSystemDiskQueueAdapter::CommitMessage const& value) 
	{
		fdb_probe_actor_enter("discardCommit", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DiscardCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("discardCommit", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DiscardCommitActor, 0, LogSystemDiskQueueAdapter::CommitMessage >*,LogSystemDiskQueueAdapter::CommitMessage && value) 
	{
		fdb_probe_actor_enter("discardCommit", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DiscardCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("discardCommit", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DiscardCommitActor, 0, LogSystemDiskQueueAdapter::CommitMessage >*,Error err) 
	{
		fdb_probe_actor_enter("discardCommit", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DiscardCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("discardCommit", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 95 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		delete static_cast<DiscardCommitActor*>(this);
															#line 510 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		return 0;

		return loopDepth;
	}
															#line 95 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	UID id;
															#line 95 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Future<LogSystemDiskQueueAdapter::CommitMessage> fcm;
															#line 95 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Future<Void> dummyCommitState;
															#line 521 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via discardCommit()
															#line 95 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class DiscardCommitActor final : public Actor<void>, public ActorCallback< DiscardCommitActor, 0, LogSystemDiskQueueAdapter::CommitMessage >, public FastAllocated<DiscardCommitActor>, public DiscardCommitActorState<DiscardCommitActor> {
															#line 526 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
	using FastAllocated<DiscardCommitActor>::operator new;
	using FastAllocated<DiscardCommitActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4197534749509497344UL, 17933367441248312832UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() {{
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<void>*>(this)->~Actor();
        operator delete(this);
    }}
#pragma clang diagnostic pop
friend struct ActorCallback< DiscardCommitActor, 0, LogSystemDiskQueueAdapter::CommitMessage >;
															#line 95 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	DiscardCommitActor(UID const& id,Future<LogSystemDiskQueueAdapter::CommitMessage> const& fcm,Future<Void> const& dummyCommitState) 
															#line 543 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		 : Actor<void>(),
		   DiscardCommitActorState<DiscardCommitActor>(id, fcm, dummyCommitState),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("discardCommit", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7339418273539287808UL, 9304446022786112512UL);
		ActorExecutionContextHelper __helper(static_cast<DiscardCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("discardCommit");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("discardCommit", reinterpret_cast<unsigned long>(this), -1);

	}
};
} // namespace
															#line 95 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
void discardCommit( UID const& id, Future<LogSystemDiskQueueAdapter::CommitMessage> const& fcm, Future<Void> const& dummyCommitState ) {
															#line 95 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	new DiscardCommitActor(id, fcm, dummyCommitState);
															#line 567 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
}

#line 102 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"

struct ResolutionRequestBuilder {
	const ProxyCommitData* self;

	// One request per resolver.
	std::vector<ResolveTransactionBatchRequest> requests;

	// Txn i to resolvers that have i'th data sent
	std::vector<std::vector<int>> transactionResolverMap;
	std::vector<CommitTransactionRef*> outTr;

	// Used to report conflicting keys, the format is
	// [CommitTransactionRef_Index][Resolver_Index][Read_Conflict_Range_Index_on_Resolver]
	// -> read_conflict_range's original index in the commitTransactionRef
	std::vector<std::vector<std::vector<int>>> txReadConflictRangeIndexMap;

	ResolutionRequestBuilder(ProxyCommitData* self,
	                         Version version,
	                         Version prevVersion,
	                         Version lastReceivedVersion,
	                         Version lastShardMove,
	                         Span& parentSpan)
	  : self(self), requests(self->resolvers.size()) {
		for (auto& req : requests) {
			req.spanContext = parentSpan.context;
			req.prevVersion = prevVersion;
			req.version = version;
			req.lastReceivedVersion = lastReceivedVersion;
			req.lastShardMove = lastShardMove;
		}
	}

	CommitTransactionRef& getOutTransaction(int resolver, Version read_snapshot) {
		CommitTransactionRef*& out = outTr[resolver];
		if (!out) {
			ResolveTransactionBatchRequest& request = requests[resolver];
			request.transactions.resize(request.arena, request.transactions.size() + 1);
			out = &request.transactions.back();
			out->read_snapshot = read_snapshot;
		}
		return *out;
	}

	// Returns a read conflict index map: [resolver_index][read_conflict_range_index_on_the_resolver]
	// -> read_conflict_range's original index
	std::vector<std::vector<int>> addReadConflictRanges(CommitTransactionRef& trIn) {
		std::vector<std::vector<int>> rCRIndexMap(requests.size());
		for (int idx = 0; idx < trIn.read_conflict_ranges.size(); ++idx) {
			const auto& r = trIn.read_conflict_ranges[idx];
			auto ranges = self->keyResolvers.intersectingRanges(r);
			std::vector<int> resolvers;
			resolvers.reserve(self->resolvers.size());
			// O(1) de-dup keyed by resolver id (deterministic)
			std::vector<unsigned char> seen(self->resolvers.size(), 0);
			for (auto& ir : ranges) {
				auto& version_resolver = ir.value();
				for (int i = version_resolver.size() - 1; i >= 0; i--) {
					const int resolver_id = version_resolver[i].second;
					if (!seen[resolver_id]) {
						seen[resolver_id] = 1;
						resolvers.push_back(resolver_id);
					}
					if (version_resolver[i].first < trIn.read_snapshot)
						break;
				}
			}
			if (SERVER_KNOBS->PROXY_USE_RESOLVER_PRIVATE_MUTATIONS && systemKeys.intersects(r)) {
				// All resolvers are eligible; skip per-id de-dup and just fill 0..N-1.
				resolvers.clear();
				for (int k = 0; k < self->resolvers.size(); ++k) {
					resolvers.push_back(k);
				}
			}
			ASSERT(resolvers.size());
			for (int resolver : resolvers) {
				getOutTransaction(resolver, trIn.read_snapshot)
				    .read_conflict_ranges.push_back(requests[resolver].arena, r);
				rCRIndexMap[resolver].push_back(idx);
			}
		}
		return rCRIndexMap;
	}

	void addWriteConflictRanges(CommitTransactionRef& trIn) {
		for (auto& r : trIn.write_conflict_ranges) {
			auto ranges = self->keyResolvers.intersectingRanges(r);
			std::vector<int> resolvers;
			resolvers.reserve(self->resolvers.size());
			std::vector<unsigned char> seen(self->resolvers.size(), 0);
			for (auto& ir : ranges) {
				auto& version_resolver = ir.value();
				if (!version_resolver.empty()) {
					const int resolver_id = version_resolver.back().second;
					if (!seen[resolver_id]) {
						seen[resolver_id] = 1;
						resolvers.push_back(resolver_id);
					}
				}
			}
			if (SERVER_KNOBS->PROXY_USE_RESOLVER_PRIVATE_MUTATIONS && systemKeys.intersects(r)) {
				// All resolvers are eligible.
				resolvers.clear();
				for (int k = 0; k < self->resolvers.size(); ++k) {
					resolvers.push_back(k);
				}
			}
			ASSERT(resolvers.size());
			for (int resolver : resolvers)
				getOutTransaction(resolver, trIn.read_snapshot)
				    .write_conflict_ranges.push_back(requests[resolver].arena, r);
		}
	}

	void addTransaction(CommitTransactionRequest& trRequest, Version ver, int transactionNumberInBatch) {
		auto& trIn = trRequest.transaction;
		// SOMEDAY: There are a couple of unnecessary O( # resolvers ) steps here
		outTr.assign(requests.size(), nullptr);
		ASSERT(transactionNumberInBatch >= 0 && transactionNumberInBatch < 32768);

		bool isTXNStateTransaction = false;
		for (auto& m : trIn.mutations) {
			DEBUG_MUTATION("AddTr", ver, m, self->dbgid).detail("Idx", transactionNumberInBatch);
			if (m.type == MutationRef::SetVersionstampedKey) {
				transformVersionstampMutation(m, &MutationRef::param1, requests[0].version, transactionNumberInBatch);
				trIn.write_conflict_ranges.push_back(requests[0].arena, singleKeyRange(m.param1, requests[0].arena));
			} else if (m.type == MutationRef::SetVersionstampedValue) {
				transformVersionstampMutation(m, &MutationRef::param2, requests[0].version, transactionNumberInBatch);
			}
			if (isMetadataMutation(m)) {
				isTXNStateTransaction = true;
				auto& tr = getOutTransaction(0, trIn.read_snapshot);
				tr.mutations.push_back(requests[0].arena, m);
				tr.lock_aware = trRequest.isLockAware();
			}
		}
		if (isTXNStateTransaction && !trRequest.isLockAware()) {
			// This mitigates https://github.com/apple/foundationdb/issues/3647. Since this transaction is not lock
			// aware, if this transaction got a read version then \xff/dbLocked must not have been set at this
			// transaction's read snapshot. If that changes by commit time, then it won't commit on any proxy because of
			// a conflict. A client could set a read version manually so this isn't totally bulletproof.
			trIn.read_conflict_ranges.push_back(trRequest.arena, KeyRangeRef(databaseLockedKey, databaseLockedKeyEnd));
		}

		std::vector<std::vector<int>> rCRIndexMap = addReadConflictRanges(trIn);
		txReadConflictRangeIndexMap.push_back(std::move(rCRIndexMap));

		addWriteConflictRanges(trIn);

		if (isTXNStateTransaction) {
			for (int r = 0; r < requests.size(); r++) {
				int transactionNumberInRequest =
				    &getOutTransaction(r, trIn.read_snapshot) - requests[r].transactions.begin();
				requests[r].txnStateTransactions.push_back(requests[r].arena, transactionNumberInRequest);
			}
			// Note only Resolver 0 got the correct spanContext, which means
			// the reply from Resolver 0 has the right one back.
			auto& tr = getOutTransaction(0, trIn.read_snapshot);
			tr.spanContext = trRequest.spanContext;
		}

		std::vector<int> resolversUsed;
		for (int r = 0; r < outTr.size(); r++)
			if (outTr[r]) {
				resolversUsed.push_back(r);
				outTr[r]->report_conflicting_keys = trIn.report_conflicting_keys;
			}
		transactionResolverMap.emplace_back(std::move(resolversUsed));
	}
};

															#line 741 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via commitBatcher()
															#line 272 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
template <class CommitBatcherActor>
															#line 272 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class CommitBatcherActorState {
															#line 748 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
															#line 272 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	CommitBatcherActorState(ProxyCommitData* const& commitData,PromiseStream<std::pair<std::vector<CommitTransactionRequest>, int>> const& out,FutureStream<CommitTransactionRequest> const& in,int const& desiredBytes,int64_t const& memBytesLimit) 
															#line 272 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
															#line 272 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		 : commitData(commitData),
															#line 272 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   out(out),
															#line 272 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   in(in),
															#line 272 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   desiredBytes(desiredBytes),
															#line 272 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   memBytesLimit(memBytesLimit)
															#line 763 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("commitBatcher", reinterpret_cast<unsigned long>(this));

	}
	~CommitBatcherActorState() 
	{
		fdb_probe_actor_destroy("commitBatcher", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 277 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delayJittered(commitData->commitBatchInterval, TaskPriority::ProxyCommitBatcher);
															#line 277 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (static_cast<CommitBatcherActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 780 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CommitBatcherActor*>(this)->actor_wait_state = 1;
															#line 277 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CommitBatcherActor, 0, Void >*>(static_cast<CommitBatcherActor*>(this)));
															#line 785 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CommitBatcherActorState();
		static_cast<CommitBatcherActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 279 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		lastBatch = 0;
															#line 281 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		;
															#line 810 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 279 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		lastBatch = 0;
															#line 281 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		;
															#line 821 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CommitBatcherActor*>(this)->actor_wait_state > 0) static_cast<CommitBatcherActor*>(this)->actor_wait_state = 0;
		static_cast<CommitBatcherActor*>(this)->ActorCallback< CommitBatcherActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CommitBatcherActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("commitBatcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitBatcher", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CommitBatcherActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("commitBatcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitBatcher", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CommitBatcherActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("commitBatcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitBatcher", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 282 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		timeout = Future<Void>();
															#line 283 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		batch = std::vector<CommitTransactionRequest>();
															#line 284 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		batchBytes = 0;
															#line 288 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (SERVER_KNOBS->MAX_COMMIT_BATCH_INTERVAL <= 0)
															#line 918 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 289 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			timeout = Never();
															#line 922 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
		else
		{
															#line 291 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			timeout = delayJittered(SERVER_KNOBS->MAX_COMMIT_BATCH_INTERVAL, TaskPriority::ProxyCommitBatcher);
															#line 928 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 294 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		;
															#line 932 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
															#line 362 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		commitData->triggerCommit.set(false);
															#line 363 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		out.send({ std::move(batch), batchBytes });
															#line 364 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		lastBatch = now();
															#line 945 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1(int loopDepth) 
	{
															#line 294 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!(!timeout.isReady() && !(batch.size() == SERVER_KNOBS->COMMIT_TRANSACTION_BATCH_COUNT_MAX || batchBytes >= desiredBytes)))
															#line 961 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
			return a_body1cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 297 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		auto __when_expr_1 = in;
															#line 967 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		static_assert(std::is_same<decltype(__when_expr_1), FutureStream<CommitTransactionRequest>>::value || std::is_same<decltype(__when_expr_1), ThreadFutureStream<CommitTransactionRequest>>::value, "invalid type");
															#line 296 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<CommitBatcherActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 971 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 2)); else return a_body1cont1loopBody1loopBody1when1(__when_expr_1.pop(), loopDepth); };
															#line 350 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_2 = timeout;
															#line 975 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 2)); else return a_body1cont1loopBody1loopBody1when2(__when_expr_2.get(), loopDepth); };
															#line 351 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_3 = commitData->triggerCommit.onChange();
															#line 979 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 2)); else return a_body1cont1loopBody1loopBody1when3(__when_expr_3.get(), loopDepth); };
		static_cast<CommitBatcherActor*>(this)->actor_wait_state = 2;
															#line 297 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorSingleCallback< CommitBatcherActor, 1, CommitTransactionRequest >*>(static_cast<CommitBatcherActor*>(this)));
															#line 350 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CommitBatcherActor, 2, Void >*>(static_cast<CommitBatcherActor*>(this)));
															#line 351 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CommitBatcherActor, 3, Void >*>(static_cast<CommitBatcherActor*>(this)));
															#line 988 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1cont1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when1(CommitTransactionRequest const& req,int loopDepth) 
	{
															#line 299 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		int bytes = getBytes(req);
															#line 302 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (commitData->commitBatchesMemBytesCount + bytes > memBytesLimit)
															#line 1018 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 303 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			++commitData->stats.txnCommitErrors;
															#line 304 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			req.reply.sendError(commit_proxy_memory_limit_exceeded());
															#line 305 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			TraceEvent(SevWarnAlways, "ProxyCommitBatchMemoryThresholdExceeded") .suppressFor(60) .detail("MemBytesCount", commitData->commitBatchesMemBytesCount) .detail("MemLimit", memBytesLimit);
															#line 1026 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			return a_body1cont1loopBody1loopHead1(loopDepth); // continue
		}
															#line 312 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (bytes > FLOW_KNOBS->PACKET_WARNING)
															#line 1031 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 313 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			TraceEvent(SevWarn, "LargeTransaction") .suppressFor(1.0) .detail("Size", bytes) .detail("Client", req.reply.getEndpoint().getPrimaryAddress());
															#line 1035 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 319 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		++commitData->stats.txnCommitIn;
															#line 320 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		commitData->stats.uniqueClients.insert(req.reply.getEndpoint().getPrimaryAddress());
															#line 322 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (req.debugID.present())
															#line 1043 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 323 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			g_traceBatch.addEvent("CommitDebug", req.debugID.get().first(), "CommitProxyServer.batcher");
															#line 1047 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 326 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!batch.size())
															#line 1051 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 327 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (now() - lastBatch > commitData->commitBatchInterval)
															#line 1055 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			{
															#line 328 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				timeout = delayJittered(SERVER_KNOBS->COMMIT_TRANSACTION_BATCH_INTERVAL_FROM_IDLE, TaskPriority::ProxyCommitBatcher);
															#line 1059 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
			else
			{
															#line 331 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				timeout = delayJittered(commitData->commitBatchInterval - (now() - lastBatch), TaskPriority::ProxyCommitBatcher);
															#line 1065 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
		}
															#line 336 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if ((batchBytes + bytes > CLIENT_KNOBS->TRANSACTION_SIZE_LIMIT || req.firstInBatch()) && batch.size())
															#line 1070 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 338 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			commitData->triggerCommit.set(false);
															#line 339 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			out.send({ std::move(batch), batchBytes });
															#line 340 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			lastBatch = now();
															#line 341 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			timeout = delayJittered(commitData->commitBatchInterval, TaskPriority::ProxyCommitBatcher);
															#line 342 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			batch.clear();
															#line 343 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			batchBytes = 0;
															#line 1084 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 346 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		batch.push_back(req);
															#line 347 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		batchBytes += bytes;
															#line 348 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		commitData->commitBatchesMemBytesCount += bytes;
															#line 1092 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when1(CommitTransactionRequest && req,int loopDepth) 
	{
															#line 299 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		int bytes = getBytes(req);
															#line 302 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (commitData->commitBatchesMemBytesCount + bytes > memBytesLimit)
															#line 1103 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 303 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			++commitData->stats.txnCommitErrors;
															#line 304 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			req.reply.sendError(commit_proxy_memory_limit_exceeded());
															#line 305 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			TraceEvent(SevWarnAlways, "ProxyCommitBatchMemoryThresholdExceeded") .suppressFor(60) .detail("MemBytesCount", commitData->commitBatchesMemBytesCount) .detail("MemLimit", memBytesLimit);
															#line 1111 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			return a_body1cont1loopBody1loopHead1(loopDepth); // continue
		}
															#line 312 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (bytes > FLOW_KNOBS->PACKET_WARNING)
															#line 1116 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 313 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			TraceEvent(SevWarn, "LargeTransaction") .suppressFor(1.0) .detail("Size", bytes) .detail("Client", req.reply.getEndpoint().getPrimaryAddress());
															#line 1120 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 319 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		++commitData->stats.txnCommitIn;
															#line 320 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		commitData->stats.uniqueClients.insert(req.reply.getEndpoint().getPrimaryAddress());
															#line 322 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (req.debugID.present())
															#line 1128 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 323 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			g_traceBatch.addEvent("CommitDebug", req.debugID.get().first(), "CommitProxyServer.batcher");
															#line 1132 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 326 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!batch.size())
															#line 1136 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 327 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (now() - lastBatch > commitData->commitBatchInterval)
															#line 1140 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			{
															#line 328 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				timeout = delayJittered(SERVER_KNOBS->COMMIT_TRANSACTION_BATCH_INTERVAL_FROM_IDLE, TaskPriority::ProxyCommitBatcher);
															#line 1144 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
			else
			{
															#line 331 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				timeout = delayJittered(commitData->commitBatchInterval - (now() - lastBatch), TaskPriority::ProxyCommitBatcher);
															#line 1150 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
		}
															#line 336 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if ((batchBytes + bytes > CLIENT_KNOBS->TRANSACTION_SIZE_LIMIT || req.firstInBatch()) && batch.size())
															#line 1155 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 338 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			commitData->triggerCommit.set(false);
															#line 339 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			out.send({ std::move(batch), batchBytes });
															#line 340 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			lastBatch = now();
															#line 341 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			timeout = delayJittered(commitData->commitBatchInterval, TaskPriority::ProxyCommitBatcher);
															#line 342 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			batch.clear();
															#line 343 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			batchBytes = 0;
															#line 1169 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 346 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		batch.push_back(req);
															#line 347 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		batchBytes += bytes;
															#line 348 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		commitData->commitBatchesMemBytesCount += bytes;
															#line 1177 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when3(Void const& _,int loopDepth) 
	{
															#line 352 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		ASSERT(commitData->triggerCommit.get());
															#line 353 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		double commitTime = lastBatch + SERVER_KNOBS->COMMIT_TRIGGER_DELAY;
															#line 354 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (now() > commitTime)
															#line 1202 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
			return a_body1cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 358 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		timeout = timeout || delayJittered(commitTime - now(), TaskPriority::ProxyCommitBatcher);
															#line 1208 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when3(Void && _,int loopDepth) 
	{
															#line 352 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		ASSERT(commitData->triggerCommit.get());
															#line 353 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		double commitTime = lastBatch + SERVER_KNOBS->COMMIT_TRIGGER_DELAY;
															#line 354 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (now() > commitTime)
															#line 1221 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
			return a_body1cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 358 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		timeout = timeout || delayJittered(commitTime - now(), TaskPriority::ProxyCommitBatcher);
															#line 1227 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CommitBatcherActor*>(this)->actor_wait_state > 0) static_cast<CommitBatcherActor*>(this)->actor_wait_state = 0;
		static_cast<CommitBatcherActor*>(this)->ActorSingleCallback< CommitBatcherActor, 1, CommitTransactionRequest >::remove();
		static_cast<CommitBatcherActor*>(this)->ActorCallback< CommitBatcherActor, 2, Void >::remove();
		static_cast<CommitBatcherActor*>(this)->ActorCallback< CommitBatcherActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorSingleCallback< CommitBatcherActor, 1, CommitTransactionRequest >*,CommitTransactionRequest const& value) 
	{
		fdb_probe_actor_enter("commitBatcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitBatcher", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorSingleCallback< CommitBatcherActor, 1, CommitTransactionRequest >*,CommitTransactionRequest && value) 
	{
		fdb_probe_actor_enter("commitBatcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitBatcher", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorSingleCallback< CommitBatcherActor, 1, CommitTransactionRequest >*,Error err) 
	{
		fdb_probe_actor_enter("commitBatcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitBatcher", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CommitBatcherActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("commitBatcher", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitBatcher", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CommitBatcherActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("commitBatcher", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitBatcher", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CommitBatcherActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("commitBatcher", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitBatcher", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CommitBatcherActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("commitBatcher", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitBatcher", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< CommitBatcherActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("commitBatcher", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitBatcher", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< CommitBatcherActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("commitBatcher", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitBatcher", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 272 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ProxyCommitData* commitData;
															#line 272 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	PromiseStream<std::pair<std::vector<CommitTransactionRequest>, int>> out;
															#line 272 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	FutureStream<CommitTransactionRequest> in;
															#line 272 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	int desiredBytes;
															#line 272 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	int64_t memBytesLimit;
															#line 279 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	double lastBatch;
															#line 282 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Future<Void> timeout;
															#line 283 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	std::vector<CommitTransactionRequest> batch;
															#line 284 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	int batchBytes;
															#line 1429 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via commitBatcher()
															#line 272 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class CommitBatcherActor final : public Actor<Void>, public ActorCallback< CommitBatcherActor, 0, Void >, public ActorSingleCallback< CommitBatcherActor, 1, CommitTransactionRequest >, public ActorCallback< CommitBatcherActor, 2, Void >, public ActorCallback< CommitBatcherActor, 3, Void >, public FastAllocated<CommitBatcherActor>, public CommitBatcherActorState<CommitBatcherActor> {
															#line 1434 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
	using FastAllocated<CommitBatcherActor>::operator new;
	using FastAllocated<CommitBatcherActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10153959609038281472UL, 929706056316172032UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CommitBatcherActor, 0, Void >;
friend struct ActorSingleCallback< CommitBatcherActor, 1, CommitTransactionRequest >;
friend struct ActorCallback< CommitBatcherActor, 2, Void >;
friend struct ActorCallback< CommitBatcherActor, 3, Void >;
															#line 272 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	CommitBatcherActor(ProxyCommitData* const& commitData,PromiseStream<std::pair<std::vector<CommitTransactionRequest>, int>> const& out,FutureStream<CommitTransactionRequest> const& in,int const& desiredBytes,int64_t const& memBytesLimit) 
															#line 1454 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   CommitBatcherActorState<CommitBatcherActor>(commitData, out, in, desiredBytes, memBytesLimit),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("commitBatcher", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16706688995745022464UL, 16424952413577766656UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("commitBatcher");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("commitBatcher", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CommitBatcherActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorSingleCallback< CommitBatcherActor, 1, CommitTransactionRequest >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 272 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
[[nodiscard]] Future<Void> commitBatcher( ProxyCommitData* const& commitData, PromiseStream<std::pair<std::vector<CommitTransactionRequest>, int>> const& out, FutureStream<CommitTransactionRequest> const& in, int const& desiredBytes, int64_t const& memBytesLimit ) {
															#line 272 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	return Future<Void>(new CommitBatcherActor(commitData, out, in, desiredBytes, memBytesLimit));
															#line 1488 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
}

#line 367 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"

void createWhitelistBinPathVec(const std::string& binPath, std::vector<Standalone<StringRef>>& binPathVec) {
	TraceEvent(SevDebug, "BinPathConverter").detail("Input", binPath);
	StringRef input(binPath);
	while (input != StringRef()) {
		StringRef token = input.eat(","_sr);
		if (token != StringRef()) {
			const uint8_t* ptr = token.begin();
			while (ptr != token.end() && *ptr == ' ') {
				ptr++;
			}
			if (ptr != token.end()) {
				Standalone<StringRef> newElement(token.substr(ptr - token.begin()));
				TraceEvent(SevDebug, "BinPathItem").detail("Element", newElement);
				binPathVec.push_back(newElement);
			}
		}
	}
	return;
}

bool isWhitelisted(const std::vector<Standalone<StringRef>>& binPathVec, StringRef binPath) {
	TraceEvent("BinPath").detail("Value", binPath);
	for (const auto& item : binPathVec) {
		TraceEvent("Element").detail("Value", item);
	}
	return std::find(binPathVec.begin(), binPathVec.end(), binPath) != binPathVec.end();
}

															#line 1521 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via addBackupMutations()
															#line 396 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
template <class AddBackupMutationsActor>
															#line 396 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class AddBackupMutationsActorState {
															#line 1528 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
															#line 396 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	AddBackupMutationsActorState(ProxyCommitData* const& self,const std::map<Key, MutationListRef>* const& logRangeMutations,LogPushData* const& toCommit,Version const& commitVersion,double* const& computeDuration,double* const& computeStart) 
															#line 396 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
															#line 396 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		 : self(self),
															#line 396 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   logRangeMutations(logRangeMutations),
															#line 396 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   toCommit(toCommit),
															#line 396 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   commitVersion(commitVersion),
															#line 396 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   computeDuration(computeDuration),
															#line 396 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   computeStart(computeStart),
															#line 402 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   logRangeMutation(logRangeMutations->cbegin()),
															#line 403 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   version(commitVersion / CLIENT_KNOBS->LOG_RANGE_BLOCK_SIZE),
															#line 404 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   yieldBytes(0),
															#line 405 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   valueWriter(Unversioned())
															#line 1553 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("addBackupMutations", reinterpret_cast<unsigned long>(this));

	}
	~AddBackupMutationsActorState() 
	{
		fdb_probe_actor_destroy("addBackupMutations", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 407 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			toCommit->addTransactionInfo(SpanContext());
															#line 410 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			;
															#line 1570 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~AddBackupMutationsActorState();
		static_cast<AddBackupMutationsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 481 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!static_cast<AddBackupMutationsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~AddBackupMutationsActorState(); static_cast<AddBackupMutationsActor*>(this)->destroy(); return 0; }
															#line 1593 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		new (&static_cast<AddBackupMutationsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~AddBackupMutationsActorState();
		static_cast<AddBackupMutationsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 410 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!(logRangeMutation != logRangeMutations->cend()))
															#line 1612 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 413 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		valueWriter = BinaryWriter(IncludeVersion(ProtocolVersion::withBackupMutations()));
															#line 414 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		valueWriter << logRangeMutation->second.totalSize();
															#line 416 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		blobIter = logRangeMutation->second.blob_begin;
															#line 417 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		;
															#line 1624 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 431 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		Key val = valueWriter.toValue();
															#line 433 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		BinaryWriter wr(Unversioned());
															#line 436 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		wr.serializeBytes(logRangeMutation->first);
															#line 439 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		wr << (uint8_t)hashlittle(&version, sizeof(version), 0);
															#line 440 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		wr << bigEndian64(commitVersion);
															#line 442 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		uint32_t* partBuffer = nullptr;
															#line 444 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		for(int part = 0;part * CLIENT_KNOBS->MUTATION_BLOCK_SIZE < val.size();part++) {
															#line 446 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			MutationRef backupMutation;
															#line 447 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			backupMutation.type = MutationRef::SetValue;
															#line 450 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			backupMutation.param2 = getBackupValue(val, part);
															#line 451 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			Key key = getBackupKey(wr, &partBuffer, part);
															#line 452 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			backupMutation.param1 = key;
															#line 453 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			ASSERT(backupMutation.param1.startsWith( logRangeMutation->first));
															#line 456 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			auto& tags = self->tagsForKey(backupMutation.param1);
															#line 457 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			toCommit->addTags(tags);
															#line 459 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (self->acsBuilder != nullptr)
															#line 1676 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			{
															#line 460 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				updateMutationWithAcsAndAddMutationToAcsBuilder( self->acsBuilder, backupMutation, tags, getCommitProxyAccumulativeChecksumIndex(self->commitProxyIndex), self->epoch, commitVersion, self->dbgid);
															#line 1680 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
															#line 470 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			toCommit->writeTypedMessage(backupMutation);
															#line 1684 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 410 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		++logRangeMutation;
															#line 1688 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
															#line 417 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!(blobIter))
															#line 1704 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
			return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 418 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (yieldBytes > SERVER_KNOBS->DESIRED_TOTAL_BYTES)
															#line 1710 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 419 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			yieldBytes = 0;
															#line 420 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (g_network->check_yield(TaskPriority::ProxyCommitYield1))
															#line 1716 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			{
															#line 421 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				*computeDuration += g_network->timer_monotonic() - *computeStart;
															#line 422 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				StrictFuture<Void> __when_expr_0 = delay(0, TaskPriority::ProxyCommitYield1);
															#line 422 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (static_cast<AddBackupMutationsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 1724 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
				static_cast<AddBackupMutationsActor*>(this)->actor_wait_state = 1;
															#line 422 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< AddBackupMutationsActor, 0, Void >*>(static_cast<AddBackupMutationsActor*>(this)));
															#line 1729 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1loopBody1loopBody1cont3(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
															#line 426 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		valueWriter.serializeBytes(blobIter->data);
															#line 427 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		yieldBytes += blobIter->data.size();
															#line 428 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		blobIter = blobIter->next;
															#line 1765 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3(int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont4(Void const& _,int loopDepth) 
	{
															#line 423 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		*computeStart = g_network->timer_monotonic();
															#line 1780 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont4(Void && _,int loopDepth) 
	{
															#line 423 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		*computeStart = g_network->timer_monotonic();
															#line 1789 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<AddBackupMutationsActor*>(this)->actor_wait_state > 0) static_cast<AddBackupMutationsActor*>(this)->actor_wait_state = 0;
		static_cast<AddBackupMutationsActor*>(this)->ActorCallback< AddBackupMutationsActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AddBackupMutationsActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("addBackupMutations", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddBackupMutationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addBackupMutations", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< AddBackupMutationsActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("addBackupMutations", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddBackupMutationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addBackupMutations", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< AddBackupMutationsActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("addBackupMutations", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AddBackupMutationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addBackupMutations", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 396 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ProxyCommitData* self;
															#line 396 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	const std::map<Key, MutationListRef>* logRangeMutations;
															#line 396 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	LogPushData* toCommit;
															#line 396 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Version commitVersion;
															#line 396 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	double* computeDuration;
															#line 396 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	double* computeStart;
															#line 402 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	std::map<Key, MutationListRef>::const_iterator logRangeMutation;
															#line 403 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	int32_t version;
															#line 404 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	int yieldBytes;
															#line 405 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	BinaryWriter valueWriter;
															#line 416 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	MutationListRef::Blob* blobIter;
															#line 1891 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via addBackupMutations()
															#line 396 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class AddBackupMutationsActor final : public Actor<Void>, public ActorCallback< AddBackupMutationsActor, 0, Void >, public FastAllocated<AddBackupMutationsActor>, public AddBackupMutationsActorState<AddBackupMutationsActor> {
															#line 1896 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
	using FastAllocated<AddBackupMutationsActor>::operator new;
	using FastAllocated<AddBackupMutationsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4337764389951478784UL, 17502869705423680256UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< AddBackupMutationsActor, 0, Void >;
															#line 396 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	AddBackupMutationsActor(ProxyCommitData* const& self,const std::map<Key, MutationListRef>* const& logRangeMutations,LogPushData* const& toCommit,Version const& commitVersion,double* const& computeDuration,double* const& computeStart) 
															#line 1913 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   AddBackupMutationsActorState<AddBackupMutationsActor>(self, logRangeMutations, toCommit, commitVersion, computeDuration, computeStart),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("addBackupMutations", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11549401446348182528UL, 12220003075087083264UL);
		ActorExecutionContextHelper __helper(static_cast<AddBackupMutationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("addBackupMutations");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("addBackupMutations", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< AddBackupMutationsActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 396 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
[[nodiscard]] Future<Void> addBackupMutations( ProxyCommitData* const& self, const std::map<Key, MutationListRef>* const& logRangeMutations, LogPushData* const& toCommit, Version const& commitVersion, double* const& computeDuration, double* const& computeStart ) {
															#line 396 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	return Future<Void>(new AddBackupMutationsActor(self, logRangeMutations, toCommit, commitVersion, computeDuration, computeStart));
															#line 1946 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
}

#line 483 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"

															#line 1951 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via releaseResolvingAfter()
															#line 484 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
template <class ReleaseResolvingAfterActor>
															#line 484 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class ReleaseResolvingAfterActorState {
															#line 1958 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
															#line 484 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ReleaseResolvingAfterActorState(ProxyCommitData* const& self,Future<Void> const& releaseDelay,int64_t const& localBatchNumber) 
															#line 484 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
															#line 484 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		 : self(self),
															#line 484 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   releaseDelay(releaseDelay),
															#line 484 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   localBatchNumber(localBatchNumber)
															#line 1969 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("releaseResolvingAfter", reinterpret_cast<unsigned long>(this));

	}
	~ReleaseResolvingAfterActorState() 
	{
		fdb_probe_actor_destroy("releaseResolvingAfter", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 485 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			StrictFuture<Void> __when_expr_0 = releaseDelay;
															#line 485 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (static_cast<ReleaseResolvingAfterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1986 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ReleaseResolvingAfterActor*>(this)->actor_wait_state = 1;
															#line 485 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ReleaseResolvingAfterActor, 0, Void >*>(static_cast<ReleaseResolvingAfterActor*>(this)));
															#line 1991 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ReleaseResolvingAfterActorState();
		static_cast<ReleaseResolvingAfterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 486 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		ASSERT(self->latestLocalCommitBatchResolving.get() == localBatchNumber - 1);
															#line 487 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->latestLocalCommitBatchResolving.set(localBatchNumber);
															#line 488 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!static_cast<ReleaseResolvingAfterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ReleaseResolvingAfterActorState(); static_cast<ReleaseResolvingAfterActor*>(this)->destroy(); return 0; }
															#line 2018 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		new (&static_cast<ReleaseResolvingAfterActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ReleaseResolvingAfterActorState();
		static_cast<ReleaseResolvingAfterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 486 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		ASSERT(self->latestLocalCommitBatchResolving.get() == localBatchNumber - 1);
															#line 487 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->latestLocalCommitBatchResolving.set(localBatchNumber);
															#line 488 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!static_cast<ReleaseResolvingAfterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ReleaseResolvingAfterActorState(); static_cast<ReleaseResolvingAfterActor*>(this)->destroy(); return 0; }
															#line 2034 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		new (&static_cast<ReleaseResolvingAfterActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ReleaseResolvingAfterActorState();
		static_cast<ReleaseResolvingAfterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ReleaseResolvingAfterActor*>(this)->actor_wait_state > 0) static_cast<ReleaseResolvingAfterActor*>(this)->actor_wait_state = 0;
		static_cast<ReleaseResolvingAfterActor*>(this)->ActorCallback< ReleaseResolvingAfterActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ReleaseResolvingAfterActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("releaseResolvingAfter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReleaseResolvingAfterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("releaseResolvingAfter", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ReleaseResolvingAfterActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("releaseResolvingAfter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReleaseResolvingAfterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("releaseResolvingAfter", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ReleaseResolvingAfterActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("releaseResolvingAfter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReleaseResolvingAfterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("releaseResolvingAfter", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 484 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ProxyCommitData* self;
															#line 484 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Future<Void> releaseDelay;
															#line 484 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	int64_t localBatchNumber;
															#line 2123 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via releaseResolvingAfter()
															#line 484 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class ReleaseResolvingAfterActor final : public Actor<Void>, public ActorCallback< ReleaseResolvingAfterActor, 0, Void >, public FastAllocated<ReleaseResolvingAfterActor>, public ReleaseResolvingAfterActorState<ReleaseResolvingAfterActor> {
															#line 2128 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
	using FastAllocated<ReleaseResolvingAfterActor>::operator new;
	using FastAllocated<ReleaseResolvingAfterActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10612913995073915648UL, 7221153999960350464UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ReleaseResolvingAfterActor, 0, Void >;
															#line 484 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ReleaseResolvingAfterActor(ProxyCommitData* const& self,Future<Void> const& releaseDelay,int64_t const& localBatchNumber) 
															#line 2145 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   ReleaseResolvingAfterActorState<ReleaseResolvingAfterActor>(self, releaseDelay, localBatchNumber),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("releaseResolvingAfter", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15016637786698726400UL, 2544269195532515072UL);
		ActorExecutionContextHelper __helper(static_cast<ReleaseResolvingAfterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("releaseResolvingAfter");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("releaseResolvingAfter", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ReleaseResolvingAfterActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 484 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
[[nodiscard]] Future<Void> releaseResolvingAfter( ProxyCommitData* const& self, Future<Void> const& releaseDelay, int64_t const& localBatchNumber ) {
															#line 484 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	return Future<Void>(new ReleaseResolvingAfterActor(self, releaseDelay, localBatchNumber));
															#line 2178 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
}

#line 490 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"

															#line 2183 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via trackResolutionMetrics()
															#line 491 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
template <class TrackResolutionMetricsActor>
															#line 491 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class TrackResolutionMetricsActorState {
															#line 2190 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
															#line 491 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	TrackResolutionMetricsActorState(Reference<Histogram> const& dist,Future<ResolveTransactionBatchReply> const& in) 
															#line 491 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
															#line 491 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		 : dist(dist),
															#line 491 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   in(in),
															#line 493 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   startTime(g_network->timer_monotonic())
															#line 2201 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("trackResolutionMetrics", reinterpret_cast<unsigned long>(this));

	}
	~TrackResolutionMetricsActorState() 
	{
		fdb_probe_actor_destroy("trackResolutionMetrics", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 494 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			StrictFuture<ResolveTransactionBatchReply> __when_expr_0 = in;
															#line 494 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (static_cast<TrackResolutionMetricsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2218 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TrackResolutionMetricsActor*>(this)->actor_wait_state = 1;
															#line 494 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TrackResolutionMetricsActor, 0, ResolveTransactionBatchReply >*>(static_cast<TrackResolutionMetricsActor*>(this)));
															#line 2223 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TrackResolutionMetricsActorState();
		static_cast<TrackResolutionMetricsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(ResolveTransactionBatchReply const& reply,int loopDepth) 
	{
															#line 495 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		dist->sampleSeconds(g_network->timer_monotonic() - startTime);
															#line 496 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!static_cast<TrackResolutionMetricsActor*>(this)->SAV<ResolveTransactionBatchReply>::futures) { (void)(reply); this->~TrackResolutionMetricsActorState(); static_cast<TrackResolutionMetricsActor*>(this)->destroy(); return 0; }
															#line 2248 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		new (&static_cast<TrackResolutionMetricsActor*>(this)->SAV< ResolveTransactionBatchReply >::value()) ResolveTransactionBatchReply(reply);
		this->~TrackResolutionMetricsActorState();
		static_cast<TrackResolutionMetricsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(ResolveTransactionBatchReply && reply,int loopDepth) 
	{
															#line 495 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		dist->sampleSeconds(g_network->timer_monotonic() - startTime);
															#line 496 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!static_cast<TrackResolutionMetricsActor*>(this)->SAV<ResolveTransactionBatchReply>::futures) { (void)(reply); this->~TrackResolutionMetricsActorState(); static_cast<TrackResolutionMetricsActor*>(this)->destroy(); return 0; }
															#line 2262 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		new (&static_cast<TrackResolutionMetricsActor*>(this)->SAV< ResolveTransactionBatchReply >::value()) ResolveTransactionBatchReply(reply);
		this->~TrackResolutionMetricsActorState();
		static_cast<TrackResolutionMetricsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(ResolveTransactionBatchReply const& reply,int loopDepth) 
	{
		loopDepth = a_body1cont1(reply, loopDepth);

		return loopDepth;
	}
	int a_body1when1(ResolveTransactionBatchReply && reply,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(reply), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TrackResolutionMetricsActor*>(this)->actor_wait_state > 0) static_cast<TrackResolutionMetricsActor*>(this)->actor_wait_state = 0;
		static_cast<TrackResolutionMetricsActor*>(this)->ActorCallback< TrackResolutionMetricsActor, 0, ResolveTransactionBatchReply >::remove();

	}
	void a_callback_fire(ActorCallback< TrackResolutionMetricsActor, 0, ResolveTransactionBatchReply >*,ResolveTransactionBatchReply const& value) 
	{
		fdb_probe_actor_enter("trackResolutionMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TrackResolutionMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackResolutionMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TrackResolutionMetricsActor, 0, ResolveTransactionBatchReply >*,ResolveTransactionBatchReply && value) 
	{
		fdb_probe_actor_enter("trackResolutionMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TrackResolutionMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackResolutionMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TrackResolutionMetricsActor, 0, ResolveTransactionBatchReply >*,Error err) 
	{
		fdb_probe_actor_enter("trackResolutionMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TrackResolutionMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackResolutionMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 491 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Reference<Histogram> dist;
															#line 491 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Future<ResolveTransactionBatchReply> in;
															#line 493 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	double startTime;
															#line 2351 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via trackResolutionMetrics()
															#line 491 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class TrackResolutionMetricsActor final : public Actor<ResolveTransactionBatchReply>, public ActorCallback< TrackResolutionMetricsActor, 0, ResolveTransactionBatchReply >, public FastAllocated<TrackResolutionMetricsActor>, public TrackResolutionMetricsActorState<TrackResolutionMetricsActor> {
															#line 2356 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
	using FastAllocated<TrackResolutionMetricsActor>::operator new;
	using FastAllocated<TrackResolutionMetricsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3545613844935661312UL, 12693559451079197952UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<ResolveTransactionBatchReply>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TrackResolutionMetricsActor, 0, ResolveTransactionBatchReply >;
															#line 491 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	TrackResolutionMetricsActor(Reference<Histogram> const& dist,Future<ResolveTransactionBatchReply> const& in) 
															#line 2373 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		 : Actor<ResolveTransactionBatchReply>(),
		   TrackResolutionMetricsActorState<TrackResolutionMetricsActor>(dist, in),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("trackResolutionMetrics", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(662851382450018048UL, 8345511031365611520UL);
		ActorExecutionContextHelper __helper(static_cast<TrackResolutionMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("trackResolutionMetrics");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("trackResolutionMetrics", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TrackResolutionMetricsActor, 0, ResolveTransactionBatchReply >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 491 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
[[nodiscard]] static Future<ResolveTransactionBatchReply> trackResolutionMetrics( Reference<Histogram> const& dist, Future<ResolveTransactionBatchReply> const& in ) {
															#line 491 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	return Future<ResolveTransactionBatchReply>(new TrackResolutionMetricsActor(dist, in));
															#line 2406 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
}

#line 498 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"

namespace CommitBatch {

constexpr const std::string_view UNSET = std::string_view();
constexpr const std::string_view INITIALIZE = "initialize"sv;
constexpr const std::string_view PRE_RESOLUTION = "preResolution"sv;
constexpr const std::string_view RESOLUTION = "resolution"sv;
constexpr const std::string_view POST_RESOLUTION = "postResolution"sv;
constexpr const std::string_view TRANSACTION_LOGGING = "transactionLogging"sv;
constexpr const std::string_view REPLY = "reply"sv;
constexpr const std::string_view COMPLETE = "complete"sv;

struct CommitBatchContext {
	using StoreCommit_t = std::vector<std::pair<Future<LogSystemDiskQueueAdapter::CommitMessage>, Future<Void>>>;

	ProxyCommitData* const pProxyCommitData;
	std::vector<CommitTransactionRequest> trs;
	const int currentBatchMemBytesCount;

	double startTime;

	// The current stage of batch commit
	std::string_view stage = UNSET;

	Optional<UID> debugID;

	bool forceRecovery = false;
	bool rejected = false; // If rejected due to long queue length

	int64_t localBatchNumber;
	LogPushData toCommit;

	int batchOperations = 0;

	Span span;

	int64_t batchBytes = 0;

	int latencyBucket = 0;

	Version commitVersion;
	Version prevVersion;

	int64_t maxTransactionBytes;
	std::vector<std::vector<int>> transactionResolverMap;
	std::vector<std::vector<std::vector<int>>> txReadConflictRangeIndexMap;

	Future<Void> releaseDelay;
	Future<Void> releaseFuture;

	std::vector<ResolveTransactionBatchReply> resolution;

	double computeStart;
	double computeDuration = 0;

	Arena arena;

	/// true if the batch is the 1st batch for this proxy, additional metadata
	/// processing is involved for this batch.
	bool isMyFirstBatch;
	bool firstStateMutations;

	Optional<Value> previousCoordinators;

	StoreCommit_t storeCommits;

	std::vector<uint8_t> committed;

	Optional<Key> lockedKey;
	bool locked;

	int commitCount = 0;

	std::vector<int> nextTr;

	bool lockedAfter;

	Optional<Value> metadataVersionAfter;

	int mutationCount = 0;
	int mutationBytes = 0;

	std::map<Key, MutationListRef> logRangeMutations;
	Arena logRangeMutationsArena;

	int transactionNum = 0;
	int yieldBytes = 0;

	LogSystemDiskQueueAdapter::CommitMessage msg;

	Future<Version> loggingComplete;

	double commitStartTime;

	std::unordered_map<uint16_t, Version> tpcvMap; // obtained from resolver
	std::set<Tag> writtenTags; // final set tags written to in the batch
	std::set<Tag> writtenTagsPreResolution; // tags written to in the batch not including any changes from the resolver.

	IdempotencyIdKVBuilder idempotencyKVBuilder;

	CommitBatchContext(ProxyCommitData*, const std::vector<CommitTransactionRequest>*, const int);

	void setupTraceBatch();

	std::set<Tag> getWrittenTagsPreResolution();

	void checkHotShards();

	bool rangeLockEnabled();

	Version lastShardMove;

private:
	void evaluateBatchSize();
};

bool CommitBatchContext::rangeLockEnabled() {
	return pProxyCommitData->rangeLockEnabled();
}

void CommitBatchContext::checkHotShards() {
	// removed expired hot shards
	for (auto it = pProxyCommitData->hotShards.begin(); it != pProxyCommitData->hotShards.end();) {
		if (now() > it->second) {
			it = pProxyCommitData->hotShards.erase(it);
		} else {
			++it;
		}
	}

	if (pProxyCommitData->hotShards.empty()) {
		return;
	}

	auto trsBegin = trs.begin();

	std::vector<size_t> transactionsToRemove;
	for (int transactionNum = 0; transactionNum < trs.size(); transactionNum++) {
		VectorRef<MutationRef>* pMutations = &trs[transactionNum].transaction.mutations;
		bool abortTransaction = false;
		for (int mutationNum = 0; mutationNum < pMutations->size(); mutationNum++) {
			auto& m = (*pMutations)[mutationNum];
			if (isSingleKeyMutation((MutationRef::Type)m.type)) {
				for (const auto& shard : pProxyCommitData->hotShards) {
					if (shard.first.contains(KeyRef(m.param1))) {
						abortTransaction = true;
						break;
					}
				}
			} else if (m.type == MutationRef::ClearRange) {
				for (const auto& shard : pProxyCommitData->hotShards) {
					if (shard.first.intersects(KeyRangeRef(m.param1, m.param2))) {
						abortTransaction = true;
						break;
					}
				}
			} else {
				UNREACHABLE();
			}
		}
		if (abortTransaction) {
			trs[transactionNum].reply.sendError(transaction_throttled_hot_shard());
			transactionsToRemove.push_back(transactionNum);
		}
	}
	// Remove transactions marked for removal in reverse order to avoid shifting indices
	for (auto it = transactionsToRemove.rbegin(); it != transactionsToRemove.rend(); ++it) {
		trs.erase(trsBegin + *it);
	}
	committed.resize(trs.size());
	return;
}

// Check whether the mutation intersects any legal backup ranges
// If so, it will be clamped to the intersecting range(s) later
inline bool shouldBackup(MutationRef const& m) {
	if (normalKeys.contains(m.param1) || m.param1 == metadataVersionKey) {
		return true;
	} else if (m.type != MutationRef::Type::ClearRange) {
		return systemBackupMutationMask().rangeContaining(m.param1).value();
	} else {
		for (auto& r : systemBackupMutationMask().intersectingRanges(KeyRangeRef(m.param1, m.param2))) {
			if (r->value()) {
				return true;
			}
		}
	}
	return false;
}

// Find the set of logs the batch is sent to. An empty set indicates it cannot be
// determined. In version vector, this means the batch should be sent to all logs.
std::set<Tag> CommitBatchContext::getWrittenTagsPreResolution() {
	std::set<Tag> transactionTags;
	lastShardMove = pProxyCommitData->lastShardMove;
	if (pProxyCommitData->txnStateStore->getReplaceContent()) {
		return std::set<Tag>();
	}
	if (pProxyCommitData->idempotencyClears.size()) {
		return std::set<Tag>();
	}
	for (int transactionNum = 0; transactionNum < trs.size(); transactionNum++) {
		int mutationNum = 0;
		VectorRef<MutationRef>* pMutations = &trs[transactionNum].transaction.mutations;
		if (trs[transactionNum].idempotencyId.valid()) {
			return std::set<Tag>();
		}
		for (; mutationNum < pMutations->size(); mutationNum++) {
			auto& m = (*pMutations)[mutationNum];
			// disable version vector's effect if any mutation in the batch is backed up.
			// TODO: make backup work with version vector.
			if (pProxyCommitData->vecBackupKeys.size() > 1 && shouldBackup(m)) {
				return std::set<Tag>();
			}
			if (isSingleKeyMutation((MutationRef::Type)m.type)) {
				auto& tags = pProxyCommitData->tagsForKey(m.param1);
				transactionTags.insert(tags.begin(), tags.end());
			} else if (m.type == MutationRef::ClearRange) {
				auto range = pProxyCommitData->keyInfo.rangeContaining(m.param1);
				if (range.end() >= m.param2) {
					range.value().populateTags();
					transactionTags.insert(range.value().tags.begin(), range.value().tags.end());
				} else {
					std::set<Tag> allSources;
					while (range.begin() < m.param2) {
						range.value().populateTags();
						allSources.insert(range.value().tags.begin(), range.value().tags.end());
						transactionTags.insert(range.value().tags.begin(), range.value().tags.end());
						++range;
					}
				}
				KeyRangeRef clearRange(KeyRangeRef(m.param1, m.param2));
			} else {
				UNREACHABLE();
			}
		}
	}

	if (toCommit.getLogRouterTags()) {
		toCommit.storeRandomRouterTag();
		transactionTags.insert(toCommit.savedRandomRouterTag.get());
	}

	return transactionTags;
}

CommitBatchContext::CommitBatchContext(ProxyCommitData* const pProxyCommitData_,
                                       const std::vector<CommitTransactionRequest>* trs_,
                                       const int currentBatchMemBytesCount)
  : pProxyCommitData(pProxyCommitData_), trs(std::move(*const_cast<std::vector<CommitTransactionRequest>*>(trs_))),
    currentBatchMemBytesCount(currentBatchMemBytesCount), startTime(g_network->now()),
    localBatchNumber(++pProxyCommitData->localCommitBatchesStarted),
    toCommit(pProxyCommitData->logSystem, pProxyCommitData->localTLogCount), span("MP:commitBatch"_loc),
    committed(trs.size()), lastShardMove(invalidVersion) {

	evaluateBatchSize();

	if (batchOperations != 0) {
		latencyBucket =
		    std::min<int>(SERVER_KNOBS->PROXY_COMPUTE_BUCKETS - 1,
		                  SERVER_KNOBS->PROXY_COMPUTE_BUCKETS * batchBytes /
		                      (batchOperations * (CLIENT_KNOBS->VALUE_SIZE_LIMIT + CLIENT_KNOBS->KEY_SIZE_LIMIT)));
	}

	// since we are using just the former to limit the number of versions actually in flight!
	ASSERT(SERVER_KNOBS->MAX_READ_TRANSACTION_LIFE_VERSIONS <= SERVER_KNOBS->MAX_VERSIONS_IN_FLIGHT);
}

void CommitBatchContext::setupTraceBatch() {
	for (const auto& tr : trs) {
		if (tr.debugID.present()) {
			if (!debugID.present()) {
				debugID = nondeterministicRandom()->randomUniqueID();
			}

			g_traceBatch.addAttach("CommitAttachID", tr.debugID.get().first(), debugID.get().first());
		}
		span.addLink(tr.spanContext);
	}

	if (debugID.present()) {
		g_traceBatch.addEvent("CommitDebug", debugID.get().first(), "CommitProxyServer.commitBatch.Before");
	}
}

void CommitBatchContext::evaluateBatchSize() {
	for (const auto& tr : trs) {
		const auto& mutations = tr.transaction.mutations;
		batchOperations += mutations.size();
		batchBytes += mutations.expectedSize();
	}
}

// Try to identify recovery transaction and backup's apply mutations (blind writes).
// Both cannot be rejected and are approximated by looking at first mutation
// starting with 0xff.
bool canReject(const std::vector<CommitTransactionRequest>& trs) {
	for (const auto& tr : trs) {
		if (tr.transaction.mutations.empty())
			continue;
		if (tr.transaction.mutations[0].param1.startsWith("\xff"_sr) || tr.transaction.read_conflict_ranges.empty()) {
			return false;
		}
	}
	return true;
}

double computeReleaseDelay(CommitBatchContext* self, double latencyBucket) {
	return std::min(SERVER_KNOBS->MAX_PROXY_COMPUTE,
	                self->batchOperations * self->pProxyCommitData->commitComputePerOperation[latencyBucket]);
}

															#line 2722 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
// This generated class is to be used only via preresolutionProcessing()
															#line 810 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
template <class PreresolutionProcessingActor>
															#line 810 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class PreresolutionProcessingActorState {
															#line 2728 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
															#line 810 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	PreresolutionProcessingActorState(CommitBatchContext* const& self) 
															#line 810 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
															#line 810 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		 : self(self),
															#line 812 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   pProxyCommitData(self->pProxyCommitData),
															#line 813 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   trs(self->trs),
															#line 814 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   localBatchNumber(self->localBatchNumber),
															#line 815 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   latencyBucket(self->latencyBucket),
															#line 816 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   debugID(self->debugID),
															#line 817 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   span("MP:preresolutionProcessing"_loc, self->span.context),
															#line 818 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   startTime(g_network->timer_monotonic())
															#line 2749 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("preresolutionProcessing", reinterpret_cast<unsigned long>(this));

	}
	~PreresolutionProcessingActorState() 
	{
		fdb_probe_actor_destroy("preresolutionProcessing", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 820 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (self->localBatchNumber - self->pProxyCommitData->latestLocalCommitBatchResolving.get() > SERVER_KNOBS->RESET_MASTER_BATCHES && now() - self->pProxyCommitData->lastMasterReset > SERVER_KNOBS->RESET_MASTER_DELAY)
															#line 2764 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			{
															#line 823 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				TraceEvent(SevWarnAlways, "ResetMasterNetwork", self->pProxyCommitData->dbgid) .detail("CurrentBatch", self->localBatchNumber) .detail("InProcessBatch", self->pProxyCommitData->latestLocalCommitBatchResolving.get());
															#line 826 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				FlowTransport::transport().resetConnection(self->pProxyCommitData->master.address());
															#line 827 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				self->pProxyCommitData->lastMasterReset = now();
															#line 2772 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
															#line 831 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			CODE_PROBE(pProxyCommitData->latestLocalCommitBatchResolving.get() < localBatchNumber - 1, "Wait for local batch");
															#line 832 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			StrictFuture<Void> __when_expr_0 = pProxyCommitData->latestLocalCommitBatchResolving.whenAtLeast(localBatchNumber - 1);
															#line 832 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (static_cast<PreresolutionProcessingActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2780 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<PreresolutionProcessingActor*>(this)->actor_wait_state = 1;
															#line 832 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PreresolutionProcessingActor, 0, Void >*>(static_cast<PreresolutionProcessingActor*>(this)));
															#line 2785 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PreresolutionProcessingActorState();
		static_cast<PreresolutionProcessingActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 833 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		double queuingDelay = g_network->timer_monotonic() - startTime;
															#line 834 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->stats.computeLatency.addMeasurement(queuingDelay);
															#line 835 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->stats.commitBatchQueuingDist->sampleSeconds(queuingDelay);
															#line 836 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if ((queuingDelay > (double)SERVER_KNOBS->MAX_READ_TRANSACTION_LIFE_VERSIONS / SERVER_KNOBS->VERSIONS_PER_SECOND || (g_network->isSimulated() && BUGGIFY_WITH_PROB(0.01))) && SERVER_KNOBS->PROXY_REJECT_BATCH_QUEUED_TOO_LONG && canReject(trs))
															#line 2814 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 840 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			CODE_PROBE(true, "Reject transactions in the batch");
															#line 841 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			TraceEvent(g_network->isSimulated() ? SevInfo : SevWarnAlways, "ProxyReject", pProxyCommitData->dbgid) .suppressFor(0.1) .detail("QDelay", queuingDelay) .detail("Transactions", trs.size()) .detail("BatchNumber", localBatchNumber);
															#line 846 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			ASSERT(pProxyCommitData->latestLocalCommitBatchResolving.get() == localBatchNumber - 1);
															#line 847 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			pProxyCommitData->latestLocalCommitBatchResolving.set(localBatchNumber);
															#line 849 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			StrictFuture<Void> __when_expr_1 = pProxyCommitData->latestLocalCommitBatchLogging.whenAtLeast(localBatchNumber - 1);
															#line 849 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (static_cast<PreresolutionProcessingActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2828 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<PreresolutionProcessingActor*>(this)->actor_wait_state = 2;
															#line 849 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PreresolutionProcessingActor, 1, Void >*>(static_cast<PreresolutionProcessingActor*>(this)));
															#line 2833 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 833 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		double queuingDelay = g_network->timer_monotonic() - startTime;
															#line 834 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->stats.computeLatency.addMeasurement(queuingDelay);
															#line 835 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->stats.commitBatchQueuingDist->sampleSeconds(queuingDelay);
															#line 836 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if ((queuingDelay > (double)SERVER_KNOBS->MAX_READ_TRANSACTION_LIFE_VERSIONS / SERVER_KNOBS->VERSIONS_PER_SECOND || (g_network->isSimulated() && BUGGIFY_WITH_PROB(0.01))) && SERVER_KNOBS->PROXY_REJECT_BATCH_QUEUED_TOO_LONG && canReject(trs))
															#line 2853 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 840 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			CODE_PROBE(true, "Reject transactions in the batch");
															#line 841 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			TraceEvent(g_network->isSimulated() ? SevInfo : SevWarnAlways, "ProxyReject", pProxyCommitData->dbgid) .suppressFor(0.1) .detail("QDelay", queuingDelay) .detail("Transactions", trs.size()) .detail("BatchNumber", localBatchNumber);
															#line 846 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			ASSERT(pProxyCommitData->latestLocalCommitBatchResolving.get() == localBatchNumber - 1);
															#line 847 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			pProxyCommitData->latestLocalCommitBatchResolving.set(localBatchNumber);
															#line 849 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			StrictFuture<Void> __when_expr_1 = pProxyCommitData->latestLocalCommitBatchLogging.whenAtLeast(localBatchNumber - 1);
															#line 849 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (static_cast<PreresolutionProcessingActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2867 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<PreresolutionProcessingActor*>(this)->actor_wait_state = 2;
															#line 849 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PreresolutionProcessingActor, 1, Void >*>(static_cast<PreresolutionProcessingActor*>(this)));
															#line 2872 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PreresolutionProcessingActor*>(this)->actor_wait_state > 0) static_cast<PreresolutionProcessingActor*>(this)->actor_wait_state = 0;
		static_cast<PreresolutionProcessingActor*>(this)->ActorCallback< PreresolutionProcessingActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PreresolutionProcessingActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("preresolutionProcessing", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PreresolutionProcessingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("preresolutionProcessing", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PreresolutionProcessingActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("preresolutionProcessing", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PreresolutionProcessingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("preresolutionProcessing", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PreresolutionProcessingActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("preresolutionProcessing", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PreresolutionProcessingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("preresolutionProcessing", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 862 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->releaseDelay = delay(computeReleaseDelay(self, latencyBucket), TaskPriority::ProxyMasterVersionReply);
															#line 864 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (debugID.present())
															#line 2963 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 865 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			g_traceBatch.addEvent( "CommitDebug", debugID.get().first(), "CommitProxyServer.commitBatch.GettingCommitVersion");
															#line 2967 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 869 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (SERVER_KNOBS->ENABLE_VERSION_VECTOR_TLOG_UNICAST)
															#line 2971 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 870 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			self->writtenTagsPreResolution = self->getWrittenTagsPreResolution();
															#line 2975 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 873 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (SERVER_KNOBS->HOT_SHARD_THROTTLING_ENABLED && !pProxyCommitData->hotShards.empty())
															#line 2979 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 874 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			self->checkHotShards();
															#line 2983 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 877 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		GetCommitVersionRequest req(span.context, pProxyCommitData->commitVersionRequestNumber++, pProxyCommitData->mostRecentProcessedRequestNumber, pProxyCommitData->dbgid);
															#line 881 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		beforeGettingCommitVersion = g_network->timer_monotonic();
															#line 882 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<GetCommitVersionReply> __when_expr_2 = brokenPromiseToNever( pProxyCommitData->master.getCommitVersion.getReply(req, TaskPriority::ProxyMasterVersionReply));
															#line 882 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<PreresolutionProcessingActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2993 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<PreresolutionProcessingActor*>(this)->actor_wait_state = 3;
															#line 882 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< PreresolutionProcessingActor, 2, GetCommitVersionReply >*>(static_cast<PreresolutionProcessingActor*>(this)));
															#line 2998 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 850 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		ASSERT(pProxyCommitData->latestLocalCommitBatchLogging.get() == localBatchNumber - 1);
															#line 851 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->latestLocalCommitBatchLogging.set(localBatchNumber);
															#line 852 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		for( const auto& tr : trs ) {
															#line 853 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			tr.reply.sendError(transaction_too_old());
															#line 3013 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 855 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		++pProxyCommitData->stats.commitBatchOut;
															#line 856 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->stats.txnCommitOut += trs.size();
															#line 857 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->stats.txnRejectedForQueuedTooLong += trs.size();
															#line 858 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->rejected = true;
															#line 859 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!static_cast<PreresolutionProcessingActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PreresolutionProcessingActorState(); static_cast<PreresolutionProcessingActor*>(this)->destroy(); return 0; }
															#line 3025 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		new (&static_cast<PreresolutionProcessingActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PreresolutionProcessingActorState();
		static_cast<PreresolutionProcessingActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 850 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		ASSERT(pProxyCommitData->latestLocalCommitBatchLogging.get() == localBatchNumber - 1);
															#line 851 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->latestLocalCommitBatchLogging.set(localBatchNumber);
															#line 852 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		for( const auto& tr : trs ) {
															#line 853 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			tr.reply.sendError(transaction_too_old());
															#line 3043 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 855 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		++pProxyCommitData->stats.commitBatchOut;
															#line 856 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->stats.txnCommitOut += trs.size();
															#line 857 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->stats.txnRejectedForQueuedTooLong += trs.size();
															#line 858 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->rejected = true;
															#line 859 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!static_cast<PreresolutionProcessingActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PreresolutionProcessingActorState(); static_cast<PreresolutionProcessingActor*>(this)->destroy(); return 0; }
															#line 3055 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		new (&static_cast<PreresolutionProcessingActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PreresolutionProcessingActorState();
		static_cast<PreresolutionProcessingActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<PreresolutionProcessingActor*>(this)->actor_wait_state > 0) static_cast<PreresolutionProcessingActor*>(this)->actor_wait_state = 0;
		static_cast<PreresolutionProcessingActor*>(this)->ActorCallback< PreresolutionProcessingActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PreresolutionProcessingActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("preresolutionProcessing", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PreresolutionProcessingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("preresolutionProcessing", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< PreresolutionProcessingActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("preresolutionProcessing", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PreresolutionProcessingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("preresolutionProcessing", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< PreresolutionProcessingActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("preresolutionProcessing", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PreresolutionProcessingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("preresolutionProcessing", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont7(GetCommitVersionReply const& versionReply,int loopDepth) 
	{
															#line 885 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->mostRecentProcessedRequestNumber = versionReply.requestNum;
															#line 887 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->stats.txnCommitVersionAssigned += trs.size();
															#line 888 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->stats.lastCommitVersionAssigned = versionReply.version;
															#line 889 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->stats.getCommitVersionDist->sampleSeconds(g_network->timer_monotonic() - beforeGettingCommitVersion);
															#line 892 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->commitVersion = versionReply.version;
															#line 893 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->prevVersion = versionReply.prevVersion;
															#line 897 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		for( auto it : versionReply.resolverChanges ) {
															#line 898 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			auto rs = pProxyCommitData->keyResolvers.modify(it.range);
															#line 899 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			for(auto r = rs.begin();r != rs.end();++r) {
															#line 900 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				r->value().emplace_back(versionReply.resolverChangesVersion, it.dest);
															#line 3160 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
		}
															#line 905 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (debugID.present())
															#line 3165 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 906 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			g_traceBatch.addEvent("CommitDebug", debugID.get().first(), "CommitProxyServer.commitBatch.GotCommitVersion");
															#line 3169 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 909 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!static_cast<PreresolutionProcessingActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PreresolutionProcessingActorState(); static_cast<PreresolutionProcessingActor*>(this)->destroy(); return 0; }
															#line 3173 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		new (&static_cast<PreresolutionProcessingActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PreresolutionProcessingActorState();
		static_cast<PreresolutionProcessingActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont7(GetCommitVersionReply && versionReply,int loopDepth) 
	{
															#line 885 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->mostRecentProcessedRequestNumber = versionReply.requestNum;
															#line 887 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->stats.txnCommitVersionAssigned += trs.size();
															#line 888 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->stats.lastCommitVersionAssigned = versionReply.version;
															#line 889 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->stats.getCommitVersionDist->sampleSeconds(g_network->timer_monotonic() - beforeGettingCommitVersion);
															#line 892 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->commitVersion = versionReply.version;
															#line 893 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->prevVersion = versionReply.prevVersion;
															#line 897 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		for( auto it : versionReply.resolverChanges ) {
															#line 898 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			auto rs = pProxyCommitData->keyResolvers.modify(it.range);
															#line 899 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			for(auto r = rs.begin();r != rs.end();++r) {
															#line 900 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				r->value().emplace_back(versionReply.resolverChangesVersion, it.dest);
															#line 3203 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
		}
															#line 905 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (debugID.present())
															#line 3208 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 906 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			g_traceBatch.addEvent("CommitDebug", debugID.get().first(), "CommitProxyServer.commitBatch.GotCommitVersion");
															#line 3212 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 909 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!static_cast<PreresolutionProcessingActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PreresolutionProcessingActorState(); static_cast<PreresolutionProcessingActor*>(this)->destroy(); return 0; }
															#line 3216 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		new (&static_cast<PreresolutionProcessingActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PreresolutionProcessingActorState();
		static_cast<PreresolutionProcessingActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3when1(GetCommitVersionReply const& versionReply,int loopDepth) 
	{
		loopDepth = a_body1cont7(versionReply, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(GetCommitVersionReply && versionReply,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(versionReply), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<PreresolutionProcessingActor*>(this)->actor_wait_state > 0) static_cast<PreresolutionProcessingActor*>(this)->actor_wait_state = 0;
		static_cast<PreresolutionProcessingActor*>(this)->ActorCallback< PreresolutionProcessingActor, 2, GetCommitVersionReply >::remove();

	}
	void a_callback_fire(ActorCallback< PreresolutionProcessingActor, 2, GetCommitVersionReply >*,GetCommitVersionReply const& value) 
	{
		fdb_probe_actor_enter("preresolutionProcessing", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PreresolutionProcessingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("preresolutionProcessing", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< PreresolutionProcessingActor, 2, GetCommitVersionReply >*,GetCommitVersionReply && value) 
	{
		fdb_probe_actor_enter("preresolutionProcessing", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PreresolutionProcessingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("preresolutionProcessing", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< PreresolutionProcessingActor, 2, GetCommitVersionReply >*,Error err) 
	{
		fdb_probe_actor_enter("preresolutionProcessing", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PreresolutionProcessingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("preresolutionProcessing", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 810 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	CommitBatchContext* self;
															#line 812 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ProxyCommitData* const pProxyCommitData;
															#line 813 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	std::vector<CommitTransactionRequest>& trs;
															#line 814 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	const int64_t localBatchNumber;
															#line 815 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	const int latencyBucket;
															#line 816 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	const Optional<UID>& debugID;
															#line 817 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Span span;
															#line 818 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	double startTime;
															#line 881 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	double beforeGettingCommitVersion;
															#line 3317 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via preresolutionProcessing()
															#line 810 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class PreresolutionProcessingActor final : public Actor<Void>, public ActorCallback< PreresolutionProcessingActor, 0, Void >, public ActorCallback< PreresolutionProcessingActor, 1, Void >, public ActorCallback< PreresolutionProcessingActor, 2, GetCommitVersionReply >, public FastAllocated<PreresolutionProcessingActor>, public PreresolutionProcessingActorState<PreresolutionProcessingActor> {
															#line 3322 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
	using FastAllocated<PreresolutionProcessingActor>::operator new;
	using FastAllocated<PreresolutionProcessingActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5731745994767103744UL, 1290891267469605376UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PreresolutionProcessingActor, 0, Void >;
friend struct ActorCallback< PreresolutionProcessingActor, 1, Void >;
friend struct ActorCallback< PreresolutionProcessingActor, 2, GetCommitVersionReply >;
															#line 810 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	PreresolutionProcessingActor(CommitBatchContext* const& self) 
															#line 3341 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   PreresolutionProcessingActorState<PreresolutionProcessingActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("preresolutionProcessing", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18247384368358389248UL, 1993642498905904640UL);
		ActorExecutionContextHelper __helper(static_cast<PreresolutionProcessingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("preresolutionProcessing");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("preresolutionProcessing", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PreresolutionProcessingActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< PreresolutionProcessingActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< PreresolutionProcessingActor, 2, GetCommitVersionReply >*)0, actor_cancelled()); break;
		}

	}
};
															#line 810 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
[[nodiscard]] Future<Void> preresolutionProcessing( CommitBatchContext* const& self ) {
															#line 810 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	return Future<Void>(new PreresolutionProcessingActor(self));
															#line 3375 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
}

#line 911 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"

															#line 3380 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
// This generated class is to be used only via getResolution()
															#line 912 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
template <class GetResolutionActor>
															#line 912 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class GetResolutionActorState {
															#line 3386 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
															#line 912 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	GetResolutionActorState(CommitBatchContext* const& self) 
															#line 912 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
															#line 912 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		 : self(self),
															#line 913 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   resolutionStart(g_network->timer_monotonic()),
															#line 916 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   pProxyCommitData(self->pProxyCommitData)
															#line 3397 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getResolution", reinterpret_cast<unsigned long>(this));

	}
	~GetResolutionActorState() 
	{
		fdb_probe_actor_destroy("getResolution", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 917 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			std::vector<CommitTransactionRequest>& trs = self->trs;
															#line 918 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			span = Span("MP:getResolution"_loc, self->span.context);
															#line 920 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			ResolutionRequestBuilder requests(pProxyCommitData, self->commitVersion, self->prevVersion, pProxyCommitData->version.get(), self->lastShardMove, span);
															#line 926 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			int conflictRangeCount = 0;
															#line 927 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			self->maxTransactionBytes = 0;
															#line 928 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			for(int t = 0;t < trs.size();t++) {
															#line 929 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				requests.addTransaction(trs[t], self->commitVersion, t);
															#line 930 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				conflictRangeCount += trs[t].transaction.read_conflict_ranges.size() + trs[t].transaction.write_conflict_ranges.size();
															#line 934 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				self->maxTransactionBytes = std::max<int64_t>(self->maxTransactionBytes, trs[t].transaction.expectedSize());
															#line 3428 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
															#line 937 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			pProxyCommitData->stats.conflictRanges += conflictRangeCount;
															#line 939 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			for(int r = 1;r < pProxyCommitData->resolvers.size();r++) {
															#line 940 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				ASSERT(requests.requests[r].txnStateTransactions.size() == requests.requests[0].txnStateTransactions.size());
															#line 3436 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
															#line 942 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			pProxyCommitData->stats.txnCommitResolving += trs.size();
															#line 943 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			std::vector<Future<ResolveTransactionBatchReply>> replies;
															#line 944 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			for(int r = 0;r < pProxyCommitData->resolvers.size();r++) {
															#line 945 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				requests.requests[r].debugID = self->debugID;
															#line 946 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				requests.requests[r].writtenTags = self->writtenTagsPreResolution;
															#line 947 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				replies.push_back(trackResolutionMetrics(pProxyCommitData->stats.resolverDist[r], brokenPromiseToNever(pProxyCommitData->resolvers[r].resolve.getReply( requests.requests[r], TaskPriority::ProxyResolverReply))));
															#line 3450 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
															#line 952 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			self->transactionResolverMap.swap(requests.transactionResolverMap);
															#line 954 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			self->txReadConflictRangeIndexMap.swap(requests.txReadConflictRangeIndexMap);
															#line 956 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			self->releaseFuture = releaseResolvingAfter(pProxyCommitData, self->releaseDelay, self->localBatchNumber);
															#line 958 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (self->localBatchNumber - self->pProxyCommitData->latestLocalCommitBatchLogging.get() > SERVER_KNOBS->RESET_RESOLVER_BATCHES && now() - self->pProxyCommitData->lastResolverReset > SERVER_KNOBS->RESET_RESOLVER_DELAY)
															#line 3460 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			{
															#line 961 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				for(int r = 0;r < self->pProxyCommitData->resolvers.size();r++) {
															#line 962 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					TraceEvent(SevWarnAlways, "ResetResolverNetwork", self->pProxyCommitData->dbgid) .detail("PeerAddr", self->pProxyCommitData->resolvers[r].address()) .detail("PeerAddress", self->pProxyCommitData->resolvers[r].address()) .detail("CurrentBatch", self->localBatchNumber) .detail("InProcessBatch", self->pProxyCommitData->latestLocalCommitBatchLogging.get());
															#line 967 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					FlowTransport::transport().resetConnection(self->pProxyCommitData->resolvers[r].address());
															#line 3468 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				}
															#line 969 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				self->pProxyCommitData->lastResolverReset = now();
															#line 3472 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
															#line 973 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			StrictFuture<std::vector<ResolveTransactionBatchReply>> __when_expr_0 = getAll(replies);
															#line 973 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (static_cast<GetResolutionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3478 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetResolutionActor*>(this)->actor_wait_state = 1;
															#line 973 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetResolutionActor, 0, std::vector<ResolveTransactionBatchReply> >*>(static_cast<GetResolutionActor*>(this)));
															#line 3483 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetResolutionActorState();
		static_cast<GetResolutionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<ResolveTransactionBatchReply> const& resolutionResp,int loopDepth) 
	{
															#line 974 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->resolution.swap(*const_cast<std::vector<ResolveTransactionBatchReply>*>(&resolutionResp));
															#line 976 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->pProxyCommitData->stats.resolutionDist->sampleSeconds(g_network->timer_monotonic() - resolutionStart);
															#line 977 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (self->debugID.present())
															#line 3510 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 978 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			g_traceBatch.addEvent( "CommitDebug", self->debugID.get().first(), "CommitProxyServer.commitBatch.AfterResolution");
															#line 3514 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 982 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!static_cast<GetResolutionActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetResolutionActorState(); static_cast<GetResolutionActor*>(this)->destroy(); return 0; }
															#line 3518 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		new (&static_cast<GetResolutionActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetResolutionActorState();
		static_cast<GetResolutionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<ResolveTransactionBatchReply> && resolutionResp,int loopDepth) 
	{
															#line 974 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->resolution.swap(*const_cast<std::vector<ResolveTransactionBatchReply>*>(&resolutionResp));
															#line 976 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->pProxyCommitData->stats.resolutionDist->sampleSeconds(g_network->timer_monotonic() - resolutionStart);
															#line 977 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (self->debugID.present())
															#line 3534 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 978 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			g_traceBatch.addEvent( "CommitDebug", self->debugID.get().first(), "CommitProxyServer.commitBatch.AfterResolution");
															#line 3538 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 982 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!static_cast<GetResolutionActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetResolutionActorState(); static_cast<GetResolutionActor*>(this)->destroy(); return 0; }
															#line 3542 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		new (&static_cast<GetResolutionActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetResolutionActorState();
		static_cast<GetResolutionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(std::vector<ResolveTransactionBatchReply> const& resolutionResp,int loopDepth) 
	{
		loopDepth = a_body1cont1(resolutionResp, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<ResolveTransactionBatchReply> && resolutionResp,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(resolutionResp), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetResolutionActor*>(this)->actor_wait_state > 0) static_cast<GetResolutionActor*>(this)->actor_wait_state = 0;
		static_cast<GetResolutionActor*>(this)->ActorCallback< GetResolutionActor, 0, std::vector<ResolveTransactionBatchReply> >::remove();

	}
	void a_callback_fire(ActorCallback< GetResolutionActor, 0, std::vector<ResolveTransactionBatchReply> >*,std::vector<ResolveTransactionBatchReply> const& value) 
	{
		fdb_probe_actor_enter("getResolution", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getResolution", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetResolutionActor, 0, std::vector<ResolveTransactionBatchReply> >*,std::vector<ResolveTransactionBatchReply> && value) 
	{
		fdb_probe_actor_enter("getResolution", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getResolution", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetResolutionActor, 0, std::vector<ResolveTransactionBatchReply> >*,Error err) 
	{
		fdb_probe_actor_enter("getResolution", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getResolution", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 912 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	CommitBatchContext* self;
															#line 913 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	double resolutionStart;
															#line 916 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ProxyCommitData* pProxyCommitData;
															#line 918 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Span span;
															#line 3633 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getResolution()
															#line 912 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class GetResolutionActor final : public Actor<Void>, public ActorCallback< GetResolutionActor, 0, std::vector<ResolveTransactionBatchReply> >, public FastAllocated<GetResolutionActor>, public GetResolutionActorState<GetResolutionActor> {
															#line 3638 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetResolutionActor>::operator new;
	using FastAllocated<GetResolutionActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6168919762439566592UL, 6163102210463452416UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetResolutionActor, 0, std::vector<ResolveTransactionBatchReply> >;
															#line 912 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	GetResolutionActor(CommitBatchContext* const& self) 
															#line 3655 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   GetResolutionActorState<GetResolutionActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getResolution", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8033480777775786752UL, 12535296860845315328UL);
		ActorExecutionContextHelper __helper(static_cast<GetResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getResolution");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getResolution", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetResolutionActor, 0, std::vector<ResolveTransactionBatchReply> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 912 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
[[nodiscard]] Future<Void> getResolution( CommitBatchContext* const& self ) {
															#line 912 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	return Future<Void>(new GetResolutionActor(self));
															#line 3687 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
}

#line 984 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"

void assertResolutionStateMutationsSizeConsistent(const std::vector<ResolveTransactionBatchReply>& resolution) {
	for (int r = 1; r < resolution.size(); r++) {
		ASSERT(resolution[r].stateMutations.size() == resolution[0].stateMutations.size());
		for (int s = 0; s < resolution[r].stateMutations.size(); s++) {
			ASSERT(resolution[r].stateMutations[s].size() == resolution[0].stateMutations[s].size());
		}
	}
}

// If the splitMutations is not empty, which means some clear range in mutations are split into multiple clear range
// ops. Modify mutations by replace the old clear range with the split clear ranges
void replaceRawClearRanges(Arena& arena,
                           VectorRef<MutationRef>& mutations,
                           std::vector<std::pair<int, std::vector<MutationRef>>>& splitMutations,
                           size_t totalSize,
                           Optional<UID> debugId = Optional<UID>()) {
	if (splitMutations.empty())
		return;

	int i = mutations.size() - 1;
	mutations.resize(arena, totalSize);
	// place from back
	int curr = totalSize - 1;
	for (; i >= 0; --i) {
		if (splitMutations.empty()) {
			ASSERT_EQ(curr, i);
			break;
		}

		if (splitMutations.back().first == i) {
			ASSERT_EQ(mutations[i].type, MutationRef::ClearRange);
			// TODO(gglass): legacy comment below references tenant. Possibly some
			// opportunity for simplification here. Legacy comment:
			// replace with tenant aligned mutations
			auto& currMutations = splitMutations.back().second;
			while (!currMutations.empty()) {
				mutations[curr] = currMutations.back();
				currMutations.pop_back();
				curr--;
			}
			splitMutations.pop_back();
		} else {
			ASSERT_GT(curr, i);
			mutations[curr] = mutations[i];
			curr--;
		}
	}

	ASSERT_EQ(splitMutations.size(), 0);
}
// Acknowledge transaction state store commits.
// Note: This acknowledgement will cause the transaction state store's popped version ("poppedUpTo", that's
// maintained in LogSystemDiskQueueAdapter) to get updated.
void acknowledgeTransactionStateStoreCommits(CommitBatchContext* self) {
	for (auto& p : self->storeCommits) {
		ASSERT(!p.second.isReady());
		p.first.get().acknowledge.send(Void());
		ASSERT(p.second.isReady());
	}
}

// Compute and apply "metadata" effects of each other proxy's most recent batch
void applyMetadataEffect(CommitBatchContext* self) {
	bool initialState = self->isMyFirstBatch;
	self->firstStateMutations = self->isMyFirstBatch;
	for (int versionIndex = 0; versionIndex < self->resolution[0].stateMutations.size(); versionIndex++) {
		// pProxyCommitData->logAdapter->setNextVersion( ??? );  << Ideally we would be telling the log adapter that the
		// pushes in this commit will be in the version at which these state mutations were committed by another proxy,
		// but at present we don't have that information here.  So the disk queue may be unnecessarily conservative
		// about popping.

		for (int transactionIndex = 0;
		     transactionIndex < self->resolution[0].stateMutations[versionIndex].size() && !self->forceRecovery;
		     transactionIndex++) {
			bool committed = true;
			for (int resolver = 0; resolver < self->resolution.size(); resolver++) {
				committed =
				    committed && self->resolution[resolver].stateMutations[versionIndex][transactionIndex].committed;
			}

			if (committed) {
				applyMetadataMutations(SpanContext(),
				                       *self->pProxyCommitData,
				                       self->arena,
				                       self->pProxyCommitData->logSystem,
				                       self->resolution[0].stateMutations[versionIndex][transactionIndex].mutations,
				                       /* pToCommit= */ nullptr,
				                       self->forceRecovery,
				                       /* version= */ self->commitVersion,
				                       /* popVersion= */ 0,
				                       /* initialCommit */ false,
				                       /* provisionalCommitProxy */ self->pProxyCommitData->provisional);
			}

			if (self->resolution[0].stateMutations[versionIndex][transactionIndex].mutations.size() &&
			    self->firstStateMutations) {
				ASSERT(committed);
				self->firstStateMutations = false;
				self->forceRecovery = false;
			}
		}
		// These changes to txnStateStore will be committed by the other proxy, so we simply discard the commit message
		auto fcm = self->pProxyCommitData->logAdapter->getCommitMessage();
		self->storeCommits.emplace_back(fcm, self->pProxyCommitData->txnStateStore->commit());

		if (initialState) {
			initialState = false;
			self->forceRecovery = false;
			self->pProxyCommitData->txnStateStore->resyncLog();

			acknowledgeTransactionStateStoreCommits(self);
			self->storeCommits.clear();
		}
	}
}

/// Determine which transactions actually committed (conservatively) by combining results from the resolvers
void determineCommittedTransactions(CommitBatchContext* self) {
	auto pProxyCommitData = self->pProxyCommitData;
	const auto& trs = self->trs;

	ASSERT(self->transactionResolverMap.size() == self->committed.size());
	// For each commitTransactionRef, it is only sent to resolvers specified in transactionResolverMap
	// Thus, we use this nextTr to track the correct transaction index on each resolver.
	self->nextTr.resize(self->resolution.size());
	for (int t = 0; t < trs.size(); t++) {
		uint8_t commit = ConflictBatch::TransactionCommitted;
		for (int r : self->transactionResolverMap[t]) {
			commit = std::min(self->resolution[r].committed[self->nextTr[r]++], commit);
		}
		self->committed[t] = commit;
	}
	for (int r = 0; r < self->resolution.size(); r++)
		ASSERT(self->nextTr[r] == self->resolution[r].committed.size());

	pProxyCommitData->logAdapter->setNextVersion(self->commitVersion);

	self->lockedKey = pProxyCommitData->txnStateStore->readValue(databaseLockedKey).get();
	self->locked = self->lockedKey.present() && self->lockedKey.get().size();

	const Optional<Value> mustContainSystemKey =
	    pProxyCommitData->txnStateStore->readValue(mustContainSystemMutationsKey).get();
	if (mustContainSystemKey.present() && mustContainSystemKey.get().size()) {
		for (int t = 0; t < trs.size(); t++) {
			if (self->committed[t] == ConflictBatch::TransactionCommitted) {
				bool foundSystem = false;
				for (auto& m : trs[t].transaction.mutations) {
					if ((m.type == MutationRef::ClearRange ? m.param2 : m.param1) >= nonMetadataSystemKeys.end) {
						foundSystem = true;
						break;
					}
				}
				if (!foundSystem) {
					self->committed[t] = ConflictBatch::TransactionConflict;
				}
			}
		}
	}
}

// This first pass through committed transactions deals with "metadata" effects (modifications of txnStateStore, changes
// to storage servers' responsibilities)
															#line 3854 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
// This generated class is to be used only via applyMetadataToCommittedTransactions()
															#line 1147 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
template <class ApplyMetadataToCommittedTransactionsActor>
															#line 1147 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class ApplyMetadataToCommittedTransactionsActorState {
															#line 3860 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
															#line 1147 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ApplyMetadataToCommittedTransactionsActorState(CommitBatchContext* const& self) 
															#line 1147 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
															#line 1147 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		 : self(self),
															#line 1148 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   pProxyCommitData(self->pProxyCommitData)
															#line 3869 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("applyMetadataToCommittedTransactions", reinterpret_cast<unsigned long>(this));

	}
	~ApplyMetadataToCommittedTransactionsActorState() 
	{
		fdb_probe_actor_destroy("applyMetadataToCommittedTransactions", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1149 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			auto& trs = self->trs;
															#line 1151 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			int t;
															#line 1152 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			for(t = 0;t < trs.size() && !self->forceRecovery;t++) {
															#line 1153 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (self->committed[t] == ConflictBatch::TransactionCommitted && (!self->locked || trs[t].isLockAware()))
															#line 3890 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				{
															#line 1154 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					self->commitCount++;
															#line 1155 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					applyMetadataMutations(trs[t].spanContext, *pProxyCommitData, self->arena, pProxyCommitData->logSystem, trs[t].transaction.mutations, SERVER_KNOBS->PROXY_USE_RESOLVER_PRIVATE_MUTATIONS ? nullptr : &self->toCommit, self->forceRecovery, self->commitVersion, self->commitVersion + 1, false, self->pProxyCommitData->provisional);
															#line 3896 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				}
															#line 1168 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (self->firstStateMutations)
															#line 3900 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				{
															#line 1169 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					ASSERT(self->committed[t] == ConflictBatch::TransactionCommitted);
															#line 1170 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					self->firstStateMutations = false;
															#line 1171 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					self->forceRecovery = false;
															#line 3908 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				}
			}
															#line 1175 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (self->forceRecovery)
															#line 3913 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			{
															#line 1176 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				for(;t < trs.size();t++) {
															#line 1177 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					self->committed[t] = ConflictBatch::TransactionConflict;
															#line 3919 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				}
															#line 1178 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				TraceEvent(SevWarn, "RestartingTxnSubsystem", pProxyCommitData->dbgid).detail("Stage", "AwaitCommit");
															#line 3923 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
															#line 1180 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (SERVER_KNOBS->PROXY_USE_RESOLVER_PRIVATE_MUTATIONS)
															#line 3927 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			{
															#line 1183 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				ResolveTransactionBatchReply& reply = self->resolution[0];
															#line 1184 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				self->toCommit.setMutations(reply.privateMutationCount, reply.privateMutations);
															#line 1185 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (SERVER_KNOBS->ENABLE_VERSION_VECTOR_TLOG_UNICAST)
															#line 3935 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				{
															#line 1187 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					self->tpcvMap = reply.tpcvMap;
															#line 1188 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					self->pProxyCommitData->lastShardMove = reply.lastShardMove;
															#line 1191 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					std::vector<int> fromLocations;
															#line 1192 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					fromLocations.reserve(reply.tpcvMap.size());
															#line 1193 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					for( const auto& pair : self->tpcvMap ) {
															#line 1194 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						fromLocations.push_back(pair.first);
															#line 3949 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
					}
															#line 1197 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					self->toCommit.setPushLocationsForTags(fromLocations);
															#line 3953 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				}
															#line 1199 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				self->toCommit.addWrittenTags(reply.writtenTags);
															#line 3957 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
															#line 1202 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			self->lockedKey = pProxyCommitData->txnStateStore->readValue(databaseLockedKey).get();
															#line 1203 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			self->lockedAfter = self->lockedKey.present() && self->lockedKey.get().size();
															#line 1205 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			self->metadataVersionAfter = pProxyCommitData->txnStateStore->readValue(metadataVersionKey).get();
															#line 1207 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			auto fcm = pProxyCommitData->logAdapter->getCommitMessage();
															#line 1208 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			self->storeCommits.emplace_back(fcm, pProxyCommitData->txnStateStore->commit());
															#line 1209 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			pProxyCommitData->version.set(self->commitVersion);
															#line 1210 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (!pProxyCommitData->validState.isSet())
															#line 3973 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			{
															#line 1211 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				pProxyCommitData->validState.send(Void());
															#line 3977 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
															#line 1212 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			ASSERT(self->commitVersion);
															#line 1214 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (!self->isMyFirstBatch && pProxyCommitData->txnStateStore->readValue(coordinatorsKey).get().get() != self->previousCoordinators.get())
															#line 3983 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			{
															#line 1216 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				StrictFuture<Void> __when_expr_0 = brokenPromiseToNever(pProxyCommitData->db->get().clusterInterface.changeCoordinators.getReply( ChangeCoordinatorsRequest(pProxyCommitData->txnStateStore->readValue(coordinatorsKey).get().get(), self->pProxyCommitData->master.id())));
															#line 1216 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (static_cast<ApplyMetadataToCommittedTransactionsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3989 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<ApplyMetadataToCommittedTransactionsActor*>(this)->actor_wait_state = 1;
															#line 1216 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ApplyMetadataToCommittedTransactionsActor, 0, Void >*>(static_cast<ApplyMetadataToCommittedTransactionsActor*>(this)));
															#line 3994 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ApplyMetadataToCommittedTransactionsActorState();
		static_cast<ApplyMetadataToCommittedTransactionsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1222 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!static_cast<ApplyMetadataToCommittedTransactionsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ApplyMetadataToCommittedTransactionsActorState(); static_cast<ApplyMetadataToCommittedTransactionsActor*>(this)->destroy(); return 0; }
															#line 4022 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		new (&static_cast<ApplyMetadataToCommittedTransactionsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ApplyMetadataToCommittedTransactionsActorState();
		static_cast<ApplyMetadataToCommittedTransactionsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont11(Void const& _,int loopDepth) 
	{
															#line 1219 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		ASSERT(false);
															#line 4034 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11(Void && _,int loopDepth) 
	{
															#line 1219 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		ASSERT(false);
															#line 4043 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ApplyMetadataToCommittedTransactionsActor*>(this)->actor_wait_state > 0) static_cast<ApplyMetadataToCommittedTransactionsActor*>(this)->actor_wait_state = 0;
		static_cast<ApplyMetadataToCommittedTransactionsActor*>(this)->ActorCallback< ApplyMetadataToCommittedTransactionsActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ApplyMetadataToCommittedTransactionsActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("applyMetadataToCommittedTransactions", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ApplyMetadataToCommittedTransactionsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("applyMetadataToCommittedTransactions", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ApplyMetadataToCommittedTransactionsActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("applyMetadataToCommittedTransactions", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ApplyMetadataToCommittedTransactionsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("applyMetadataToCommittedTransactions", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ApplyMetadataToCommittedTransactionsActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("applyMetadataToCommittedTransactions", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ApplyMetadataToCommittedTransactionsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("applyMetadataToCommittedTransactions", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1147 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	CommitBatchContext* self;
															#line 1148 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ProxyCommitData* const pProxyCommitData;
															#line 4127 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via applyMetadataToCommittedTransactions()
															#line 1147 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class ApplyMetadataToCommittedTransactionsActor final : public Actor<Void>, public ActorCallback< ApplyMetadataToCommittedTransactionsActor, 0, Void >, public FastAllocated<ApplyMetadataToCommittedTransactionsActor>, public ApplyMetadataToCommittedTransactionsActorState<ApplyMetadataToCommittedTransactionsActor> {
															#line 4132 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
	using FastAllocated<ApplyMetadataToCommittedTransactionsActor>::operator new;
	using FastAllocated<ApplyMetadataToCommittedTransactionsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16211359916500493568UL, 10161729404835207680UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ApplyMetadataToCommittedTransactionsActor, 0, Void >;
															#line 1147 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ApplyMetadataToCommittedTransactionsActor(CommitBatchContext* const& self) 
															#line 4149 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   ApplyMetadataToCommittedTransactionsActorState<ApplyMetadataToCommittedTransactionsActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("applyMetadataToCommittedTransactions", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6741896898587633920UL, 3623984856983436288UL);
		ActorExecutionContextHelper __helper(static_cast<ApplyMetadataToCommittedTransactionsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("applyMetadataToCommittedTransactions");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("applyMetadataToCommittedTransactions", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ApplyMetadataToCommittedTransactionsActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1147 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
[[nodiscard]] Future<Void> applyMetadataToCommittedTransactions( CommitBatchContext* const& self ) {
															#line 1147 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	return Future<Void>(new ApplyMetadataToCommittedTransactionsActor(self));
															#line 4181 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
}

#line 1224 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"

WriteMutationRefVar writeMutation(CommitBatchContext* self, const MutationRef* mutation) {
	self->toCommit.writeTypedMessage(*mutation);
	return std::variant<MutationRef, VectorRef<MutationRef>>{ *mutation };
}

void pushToBackupMutations(CommitBatchContext* self,
                           ProxyCommitData* const pProxyCommitData,
                           Arena& arena,
                           MutationRef const& m,
                           MutationRef const& writtenMutation) {
	if (m.type != MutationRef::Type::ClearRange) {
		// Add the mutation to the relevant backup tag
		for (auto backupName : pProxyCommitData->vecBackupKeys[m.param1]) {
			self->logRangeMutations[backupName].push_back_deep(self->logRangeMutationsArena, writtenMutation);
		}
	} else {
		KeyRangeRef mutationRange(m.param1, m.param2);
		KeyRangeRef intersectionRange;

		// Identify and add the intersecting ranges of the mutation to the array of mutations to serialize
		for (auto backupRange : pProxyCommitData->vecBackupKeys.intersectingRanges(mutationRange)) {
			// Get the backup sub range
			const auto& backupSubrange = backupRange.range();

			// Determine the intersecting range
			intersectionRange = mutationRange & backupSubrange;

			// Create the custom mutation for the specific backup tag
			MutationRef backupMutation(MutationRef::Type::ClearRange, intersectionRange.begin, intersectionRange.end);

			// Add the mutation to the relevant backup tag
			for (auto backupName : backupRange.value()) {
				self->logRangeMutations[backupName].push_back_deep(self->logRangeMutationsArena, backupMutation);
			}
		}
	}
}

void addAccumulativeChecksumMutations(CommitBatchContext* self) {
	ASSERT(self->pProxyCommitData->acsBuilder != nullptr);
	const uint16_t acsIndex = getCommitProxyAccumulativeChecksumIndex(self->pProxyCommitData->commitProxyIndex);
	for (const auto& [tag, acsState] : self->pProxyCommitData->acsBuilder->getAcsTable()) {
		ASSERT(tagSupportAccumulativeChecksum(tag));
		ASSERT(acsState.version <= self->commitVersion);
		if (acsState.version < self->commitVersion) {
			// Have not updated in the current commit batch
			// So, need not send acs mutation for this tag
			continue;
		}
		ASSERT(acsState.epoch == self->pProxyCommitData->epoch);
		MutationRef acsMutation;
		acsMutation.type = MutationRef::SetValue;
		acsMutation.param1 = accumulativeChecksumKey; // private mutation
		AccumulativeChecksumState acsToSend(acsIndex, acsState.acs, self->commitVersion, self->pProxyCommitData->epoch);
		Value acsValue = accumulativeChecksumValue(acsToSend);
		acsMutation.param2 = acsValue;
		acsMutation.setAccumulativeChecksumIndex(acsIndex);
		if (CLIENT_KNOBS->ENABLE_ACCUMULATIVE_CHECKSUM_LOGGING) {
			TraceEvent(SevInfo, "AcsBuilderIssueAccumulativeChecksumMutation", self->pProxyCommitData->dbgid)
			    .detail("AcsTag", tag)
			    .detail("AcsIndex", acsIndex)
			    .detail("AcsToSend", acsToSend.toString())
			    .detail("Mutation", acsMutation)
			    .detail("Version", self->commitVersion)
			    .detail("CommitProxyIndex", self->pProxyCommitData->commitProxyIndex);
		}
		DEBUG_MUTATION("ProxyCommit", self->commitVersion, acsMutation, self->pProxyCommitData->dbgid);
		self->toCommit.addTag(tag);
		self->toCommit.writeTypedMessage(acsMutation);
	}
}

void rejectMutationsForReadLockOnRange(CommitBatchContext* self) {
	ASSERT(self->rangeLockEnabled());
	ProxyCommitData* const pProxyCommitData = self->pProxyCommitData;
	ASSERT(pProxyCommitData->rangeLock != nullptr);
	std::vector<CommitTransactionRequest>& trs = self->trs;
	for (int i = self->transactionNum; i < trs.size(); i++) {
		if (self->committed[i] != ConflictBatch::TransactionCommitted) {
			continue;
		} else if (trs[i].isLockAware()) {
			continue; // rangeLock is transparent to lock-aware transactions
		}
		VectorRef<MutationRef>* pMutations = &trs[i].transaction.mutations;
		for (int j = 0; j < pMutations->size(); j++) {
			MutationRef m = (*pMutations)[j];
			KeyRange rangeToCheck;
			if (isSingleKeyMutation((MutationRef::Type)m.type)) {
				rangeToCheck = singleKeyRange(m.param1);
			} else if (m.type == MutationRef::ClearRange) {
				rangeToCheck = KeyRangeRef(m.param1, m.param2);
			}
			bool shouldReject = pProxyCommitData->rangeLock->isLocked(rangeToCheck);
			if (shouldReject) {
				self->committed[i] = ConflictBatch::TransactionLockReject;
				trs[i].reply.sendError(transaction_rejected_range_locked());
				break;
			}
		}
	}
}

/// This second pass through committed transactions assigns the actual mutations to the appropriate storage servers'
/// tags
															#line 4290 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
// This generated class is to be used only via assignMutationsToStorageServers()
															#line 1329 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
template <class AssignMutationsToStorageServersActor>
															#line 1329 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class AssignMutationsToStorageServersActorState {
															#line 4296 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
															#line 1329 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	AssignMutationsToStorageServersActorState(CommitBatchContext* const& self) 
															#line 1329 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
															#line 1329 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		 : self(self),
															#line 1330 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   pProxyCommitData(self->pProxyCommitData),
															#line 1331 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   trs(self->trs)
															#line 4307 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("assignMutationsToStorageServers", reinterpret_cast<unsigned long>(this));

	}
	~AssignMutationsToStorageServersActorState() 
	{
		fdb_probe_actor_destroy("assignMutationsToStorageServers", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1333 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			;
															#line 4322 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~AssignMutationsToStorageServersActorState();
		static_cast<AssignMutationsToStorageServersActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1516 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!static_cast<AssignMutationsToStorageServersActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~AssignMutationsToStorageServersActorState(); static_cast<AssignMutationsToStorageServersActor*>(this)->destroy(); return 0; }
															#line 4345 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		new (&static_cast<AssignMutationsToStorageServersActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~AssignMutationsToStorageServersActorState();
		static_cast<AssignMutationsToStorageServersActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1333 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!(self->transactionNum < trs.size()))
															#line 4364 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1334 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!(self->committed[self->transactionNum] == ConflictBatch::TransactionCommitted && (!self->locked || trs[self->transactionNum].isLockAware())))
															#line 4370 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
			return a_body1continue1(loopDepth); // continue
		}
															#line 1339 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		checkSample = trs[self->transactionNum].commitCostEstimation.present();
															#line 1340 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		trCost = &trs[self->transactionNum].commitCostEstimation;
															#line 1341 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		mutationNum = 0;
															#line 1342 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pMutations = &trs[self->transactionNum].transaction.mutations;
															#line 1344 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->toCommit.addTransactionInfo(trs[self->transactionNum].spanContext);
															#line 1346 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		;
															#line 4386 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1continue1(int loopDepth) 
	{
															#line 1333 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->transactionNum++;
															#line 4408 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 1510 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (checkSample)
															#line 4417 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 1511 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			self->pProxyCommitData->stats.txnExpensiveClearCostEstCount += trs[self->transactionNum].commitCostEstimation.get().expensiveCostEstCount;
															#line 4421 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 1333 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->transactionNum++;
															#line 4425 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
															#line 1346 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!(mutationNum < pMutations->size()))
															#line 4441 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
			return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1347 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (self->yieldBytes > SERVER_KNOBS->DESIRED_TOTAL_BYTES)
															#line 4447 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 1348 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			self->yieldBytes = 0;
															#line 1349 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (g_network->check_yield(TaskPriority::ProxyCommitYield1))
															#line 4453 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			{
															#line 1350 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				self->computeDuration += g_network->timer_monotonic() - self->computeStart;
															#line 1351 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				StrictFuture<Void> __when_expr_0 = delay(0, TaskPriority::ProxyCommitYield1);
															#line 1351 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (static_cast<AssignMutationsToStorageServersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 4461 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
				static_cast<AssignMutationsToStorageServersActor*>(this)->actor_wait_state = 1;
															#line 1351 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< AssignMutationsToStorageServersActor, 0, Void >*>(static_cast<AssignMutationsToStorageServersActor*>(this)));
															#line 4466 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1loopBody1loopBody1cont3(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1continue1(int loopDepth) 
	{
															#line 1346 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		mutationNum++;
															#line 4498 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
															#line 1356 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		m = (*pMutations)[mutationNum];
															#line 1357 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		arena = Arena();
															#line 1358 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		writtenMutation = MutationRef();
															#line 1359 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->mutationCount++;
															#line 1360 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->mutationBytes += m.expectedSize();
															#line 1361 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->yieldBytes += m.expectedSize();
															#line 1365 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (isSingleKeyMutation((MutationRef::Type)m.type))
															#line 4519 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 1366 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			auto& tags = pProxyCommitData->tagsForKey(m.param1);
															#line 1370 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (checkSample)
															#line 4525 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			{
															#line 1371 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				double totalCosts = trCost->get().writeCosts;
															#line 1372 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				double cost = getWriteOperationCost(m.expectedSize());
															#line 1373 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				double mul = std::max(1.0, totalCosts / std::max(1.0, (double)CLIENT_KNOBS->COMMIT_SAMPLE_COST));
															#line 1374 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				ASSERT(totalCosts > 0);
															#line 1375 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				double prob = mul * cost / totalCosts;
															#line 1377 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (deterministicRandom()->random01() < prob)
															#line 4539 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				{
															#line 1378 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					const auto& storageServers = pProxyCommitData->keyInfo[m.param1].src_info;
															#line 1379 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					for( const auto& ssInfo : storageServers ) {
															#line 1380 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						auto id = ssInfo->interf.id();
															#line 1382 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						cost = cost < CLIENT_KNOBS->COMMIT_SAMPLE_COST ? CLIENT_KNOBS->COMMIT_SAMPLE_COST : cost;
															#line 1383 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						pProxyCommitData->updateSSTagCost( id, trs[self->transactionNum].tagSet.get(), m, cost / storageServers.size());
															#line 4551 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
					}
				}
			}
															#line 1389 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			DEBUG_MUTATION("ProxyCommit", self->commitVersion, m, pProxyCommitData->dbgid).detail("To", tags);
															#line 1390 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			self->toCommit.addTags(tags);
															#line 1392 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (pProxyCommitData->acsBuilder != nullptr)
															#line 4561 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			{
															#line 1393 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				updateMutationWithAcsAndAddMutationToAcsBuilder( pProxyCommitData->acsBuilder, m, tags, getCommitProxyAccumulativeChecksumIndex(pProxyCommitData->commitProxyIndex), pProxyCommitData->epoch, self->commitVersion, pProxyCommitData->dbgid);
															#line 4565 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
															#line 1403 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			WriteMutationRefVar var = writeMutation(self, &m);
															#line 1405 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			ASSERT(std::holds_alternative<MutationRef>(var));
															#line 1406 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			writtenMutation = std::get<MutationRef>(var);
															#line 4573 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
		else
		{
															#line 1407 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (m.type == MutationRef::ClearRange)
															#line 4579 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			{
															#line 1408 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				auto range = pProxyCommitData->keyInfo.rangeContaining(m.param1);
															#line 1409 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (range.end() >= m.param2)
															#line 4585 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				{
															#line 1411 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					DEBUG_MUTATION("ProxyCommit", self->commitVersion, m, pProxyCommitData->dbgid) .detail("To", range.value().tags);
															#line 1413 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					range.value().populateTags();
															#line 1414 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					self->toCommit.addTags(range.value().tags);
															#line 1416 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					if (pProxyCommitData->acsBuilder != nullptr)
															#line 4595 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
					{
															#line 1417 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						updateMutationWithAcsAndAddMutationToAcsBuilder( pProxyCommitData->acsBuilder, m, range.value().tags, getCommitProxyAccumulativeChecksumIndex(pProxyCommitData->commitProxyIndex), pProxyCommitData->epoch, self->commitVersion, pProxyCommitData->dbgid);
															#line 4599 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
					}
															#line 1428 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					if (checkSample && !trCost->get().clearIdxCosts.empty() && trCost->get().clearIdxCosts[0].first == mutationNum)
															#line 4603 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
					{
															#line 1430 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						auto const& ssInfos = range.value().src_info;
															#line 1431 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						for( auto const& ssInfo : ssInfos ) {
															#line 1432 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
							auto id = ssInfo->interf.id();
															#line 1433 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
							pProxyCommitData->updateSSTagCost(id, trs[self->transactionNum].tagSet.get(), m, trCost->get().clearIdxCosts[0].second / ssInfos.size());
															#line 4613 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
						}
															#line 1438 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						trCost->get().clearIdxCosts.pop_front();
															#line 4617 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
					}
				}
				else
				{
															#line 1441 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					CODE_PROBE(true, "A clear range extends past a shard boundary");
															#line 1442 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					std::set<Tag> allSources;
															#line 1443 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					for(;range.begin() < m.param2;) {
															#line 1444 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						range.value().populateTags();
															#line 1445 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						allSources.insert(range.value().tags.begin(), range.value().tags.end());
															#line 1448 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						if (checkSample && !trCost->get().clearIdxCosts.empty() && trCost->get().clearIdxCosts[0].first == mutationNum)
															#line 4634 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
						{
															#line 1450 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
							auto const& ssInfos = range.value().src_info;
															#line 1451 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
							for( auto const& ssInfo : ssInfos ) {
															#line 1452 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
								auto id = ssInfo->interf.id();
															#line 1453 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
								pProxyCommitData->updateSSTagCost(id, trs[self->transactionNum].tagSet.get(), m, trCost->get().clearIdxCosts[0].second / ssInfos.size());
															#line 4644 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
							}
															#line 1459 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
							trCost->get().clearIdxCosts.pop_front();
															#line 4648 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
						}
															#line 1461 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						++range;
															#line 4652 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
					}
															#line 1464 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					DEBUG_MUTATION("ProxyCommit", self->commitVersion, m) .detail("Dbgid", pProxyCommitData->dbgid) .detail("To", allSources);
															#line 1467 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					self->toCommit.addTags(allSources);
															#line 1469 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					if (self->pProxyCommitData->acsBuilder != nullptr)
															#line 4660 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
					{
															#line 1470 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						updateMutationWithAcsAndAddMutationToAcsBuilder( pProxyCommitData->acsBuilder, m, allSources, getCommitProxyAccumulativeChecksumIndex(pProxyCommitData->commitProxyIndex), pProxyCommitData->epoch, self->commitVersion, pProxyCommitData->dbgid);
															#line 4664 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
					}
				}
															#line 1481 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				KeyRangeRef clearRange(KeyRangeRef(m.param1, m.param2));
															#line 1482 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				WriteMutationRefVar var = writeMutation(self, &m);
															#line 1484 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				ASSERT(std::holds_alternative<MutationRef>(var));
															#line 1485 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				writtenMutation = std::get<MutationRef>(var);
															#line 4675 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
			else
			{
															#line 1486 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (m.type == MutationRef::NoOp)
															#line 4681 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				{
															#line 1490 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					ASSERT(false);
															#line 4685 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
					return a_body1loopBody1continue1(loopDepth); // continue
				}
				else
				{
															#line 1493 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					UNREACHABLE();
															#line 4692 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				}
			}
		}
															#line 1496 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		DisabledTraceEvent(SevDebug, "BeforeBackup", pProxyCommitData->dbgid) .detail("M1", m.param1) .detail("M2", m.param2) .detail("MT", getTypeString(m.type)) .detail("VecBackupKeys", pProxyCommitData->vecBackupKeys.size()) .detail("ShouldBackup", shouldBackup(m));
															#line 1503 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (pProxyCommitData->vecBackupKeys.size() <= 1 || !shouldBackup(m))
															#line 4700 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
			return a_body1loopBody1continue1(loopDepth); // continue
		}
															#line 1507 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pushToBackupMutations(self, pProxyCommitData, arena, m, writtenMutation);
															#line 1346 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		mutationNum++;
															#line 4708 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3(int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont4(Void const& _,int loopDepth) 
	{
															#line 1352 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->computeStart = g_network->timer_monotonic();
															#line 4723 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont4(Void && _,int loopDepth) 
	{
															#line 1352 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->computeStart = g_network->timer_monotonic();
															#line 4732 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<AssignMutationsToStorageServersActor*>(this)->actor_wait_state > 0) static_cast<AssignMutationsToStorageServersActor*>(this)->actor_wait_state = 0;
		static_cast<AssignMutationsToStorageServersActor*>(this)->ActorCallback< AssignMutationsToStorageServersActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AssignMutationsToStorageServersActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("assignMutationsToStorageServers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AssignMutationsToStorageServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("assignMutationsToStorageServers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< AssignMutationsToStorageServersActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("assignMutationsToStorageServers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AssignMutationsToStorageServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("assignMutationsToStorageServers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< AssignMutationsToStorageServersActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("assignMutationsToStorageServers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AssignMutationsToStorageServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("assignMutationsToStorageServers", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1329 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	CommitBatchContext* self;
															#line 1330 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ProxyCommitData* const pProxyCommitData;
															#line 1331 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	std::vector<CommitTransactionRequest>& trs;
															#line 1339 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	bool checkSample;
															#line 1340 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Optional<ClientTrCommitCostEstimation>* trCost;
															#line 1341 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	int mutationNum;
															#line 1342 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	VectorRef<MutationRef>* pMutations;
															#line 1356 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	MutationRef m;
															#line 1357 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Arena arena;
															#line 1358 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	MutationRef writtenMutation;
															#line 4832 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via assignMutationsToStorageServers()
															#line 1329 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class AssignMutationsToStorageServersActor final : public Actor<Void>, public ActorCallback< AssignMutationsToStorageServersActor, 0, Void >, public FastAllocated<AssignMutationsToStorageServersActor>, public AssignMutationsToStorageServersActorState<AssignMutationsToStorageServersActor> {
															#line 4837 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
	using FastAllocated<AssignMutationsToStorageServersActor>::operator new;
	using FastAllocated<AssignMutationsToStorageServersActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6284897318578055680UL, 18038150271147441920UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< AssignMutationsToStorageServersActor, 0, Void >;
															#line 1329 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	AssignMutationsToStorageServersActor(CommitBatchContext* const& self) 
															#line 4854 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   AssignMutationsToStorageServersActorState<AssignMutationsToStorageServersActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("assignMutationsToStorageServers", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9890514799402802944UL, 16180603176411543808UL);
		ActorExecutionContextHelper __helper(static_cast<AssignMutationsToStorageServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("assignMutationsToStorageServers");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("assignMutationsToStorageServers", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< AssignMutationsToStorageServersActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1329 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
[[nodiscard]] Future<Void> assignMutationsToStorageServers( CommitBatchContext* const& self ) {
															#line 1329 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	return Future<Void>(new AssignMutationsToStorageServersActor(self));
															#line 4886 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
}

#line 1518 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"

															#line 4891 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
// This generated class is to be used only via postResolution()
															#line 1519 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
template <class PostResolutionActor>
															#line 1519 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class PostResolutionActorState {
															#line 4897 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
															#line 1519 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	PostResolutionActorState(CommitBatchContext* const& self) 
															#line 1519 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
															#line 1519 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		 : self(self),
															#line 1520 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   postResolutionStart(g_network->timer_monotonic()),
															#line 1521 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   pProxyCommitData(self->pProxyCommitData),
															#line 1522 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   trs(self->trs),
															#line 1523 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   localBatchNumber(self->localBatchNumber),
															#line 1524 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   debugID(self->debugID),
															#line 1525 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   span("MP:postResolution"_loc, self->span.context)
															#line 4916 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("postResolution", reinterpret_cast<unsigned long>(this));

	}
	~PostResolutionActorState() 
	{
		fdb_probe_actor_destroy("postResolution", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1527 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			bool queuedCommits = pProxyCommitData->latestLocalCommitBatchLogging.get() < localBatchNumber - 1;
															#line 1528 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			CODE_PROBE(queuedCommits, "Queuing post-resolution commit processing");
															#line 1529 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			StrictFuture<Void> __when_expr_0 = pProxyCommitData->latestLocalCommitBatchLogging.whenAtLeast(localBatchNumber - 1);
															#line 1529 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (static_cast<PostResolutionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4937 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<PostResolutionActor*>(this)->actor_wait_state = 1;
															#line 1529 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PostResolutionActor, 0, Void >*>(static_cast<PostResolutionActor*>(this)));
															#line 4942 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PostResolutionActorState();
		static_cast<PostResolutionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1530 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		postResolutionQueuing = g_network->timer_monotonic();
															#line 1531 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->stats.postResolutionDist->sampleSeconds(postResolutionQueuing - postResolutionStart);
															#line 1532 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_1 = yield(TaskPriority::ProxyCommitYield1);
															#line 1532 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<PostResolutionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4971 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<PostResolutionActor*>(this)->actor_wait_state = 2;
															#line 1532 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PostResolutionActor, 1, Void >*>(static_cast<PostResolutionActor*>(this)));
															#line 4976 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1530 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		postResolutionQueuing = g_network->timer_monotonic();
															#line 1531 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->stats.postResolutionDist->sampleSeconds(postResolutionQueuing - postResolutionStart);
															#line 1532 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_1 = yield(TaskPriority::ProxyCommitYield1);
															#line 1532 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<PostResolutionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4991 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<PostResolutionActor*>(this)->actor_wait_state = 2;
															#line 1532 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PostResolutionActor, 1, Void >*>(static_cast<PostResolutionActor*>(this)));
															#line 4996 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PostResolutionActor*>(this)->actor_wait_state > 0) static_cast<PostResolutionActor*>(this)->actor_wait_state = 0;
		static_cast<PostResolutionActor*>(this)->ActorCallback< PostResolutionActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PostResolutionActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("postResolution", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PostResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("postResolution", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PostResolutionActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("postResolution", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PostResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("postResolution", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PostResolutionActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("postResolution", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PostResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("postResolution", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 1534 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->computeStart = g_network->timer_monotonic();
															#line 1536 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->stats.txnCommitResolved += trs.size();
															#line 1538 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (debugID.present())
															#line 5084 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 1539 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			g_traceBatch.addEvent( "CommitDebug", debugID.get().first(), "CommitProxyServer.commitBatch.ProcessingMutations");
															#line 5088 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 1543 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->isMyFirstBatch = !pProxyCommitData->version.get();
															#line 1544 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->previousCoordinators = pProxyCommitData->txnStateStore->readValue(coordinatorsKey).get();
															#line 1546 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		assertResolutionStateMutationsSizeConsistent(self->resolution);
															#line 1548 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		applyMetadataEffect(self);
															#line 1550 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (debugID.present())
															#line 5100 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 1551 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			g_traceBatch.addEvent( "CommitDebug", debugID.get().first(), "CommitProxyServer.commitBatch.ApplyMetadataEffect");
															#line 5104 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 1555 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		determineCommittedTransactions(self);
															#line 1557 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (debugID.present())
															#line 5110 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 1558 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			g_traceBatch.addEvent( "CommitDebug", debugID.get().first(), "CommitProxyServer.commitBatch.DetermineCommittedTransactions");
															#line 5114 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 1562 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (self->forceRecovery)
															#line 5118 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 1563 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			StrictFuture<Void> __when_expr_2 = Future<Void>(Never());
															#line 1563 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (static_cast<PostResolutionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5124 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<PostResolutionActor*>(this)->actor_wait_state = 3;
															#line 1563 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< PostResolutionActor, 2, Void >*>(static_cast<PostResolutionActor*>(this)));
															#line 5129 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 1534 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->computeStart = g_network->timer_monotonic();
															#line 1536 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->stats.txnCommitResolved += trs.size();
															#line 1538 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (debugID.present())
															#line 5147 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 1539 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			g_traceBatch.addEvent( "CommitDebug", debugID.get().first(), "CommitProxyServer.commitBatch.ProcessingMutations");
															#line 5151 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 1543 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->isMyFirstBatch = !pProxyCommitData->version.get();
															#line 1544 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->previousCoordinators = pProxyCommitData->txnStateStore->readValue(coordinatorsKey).get();
															#line 1546 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		assertResolutionStateMutationsSizeConsistent(self->resolution);
															#line 1548 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		applyMetadataEffect(self);
															#line 1550 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (debugID.present())
															#line 5163 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 1551 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			g_traceBatch.addEvent( "CommitDebug", debugID.get().first(), "CommitProxyServer.commitBatch.ApplyMetadataEffect");
															#line 5167 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 1555 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		determineCommittedTransactions(self);
															#line 1557 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (debugID.present())
															#line 5173 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 1558 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			g_traceBatch.addEvent( "CommitDebug", debugID.get().first(), "CommitProxyServer.commitBatch.DetermineCommittedTransactions");
															#line 5177 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 1562 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (self->forceRecovery)
															#line 5181 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 1563 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			StrictFuture<Void> __when_expr_2 = Future<Void>(Never());
															#line 1563 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (static_cast<PostResolutionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5187 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<PostResolutionActor*>(this)->actor_wait_state = 3;
															#line 1563 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< PostResolutionActor, 2, Void >*>(static_cast<PostResolutionActor*>(this)));
															#line 5192 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<PostResolutionActor*>(this)->actor_wait_state > 0) static_cast<PostResolutionActor*>(this)->actor_wait_state = 0;
		static_cast<PostResolutionActor*>(this)->ActorCallback< PostResolutionActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PostResolutionActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("postResolution", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PostResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("postResolution", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< PostResolutionActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("postResolution", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PostResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("postResolution", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< PostResolutionActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("postResolution", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PostResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("postResolution", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 1567 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_3 = applyMetadataToCommittedTransactions(self);
															#line 1567 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<PostResolutionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5283 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<PostResolutionActor*>(this)->actor_wait_state = 4;
															#line 1567 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< PostResolutionActor, 3, Void >*>(static_cast<PostResolutionActor*>(this)));
															#line 5288 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont7(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<PostResolutionActor*>(this)->actor_wait_state > 0) static_cast<PostResolutionActor*>(this)->actor_wait_state = 0;
		static_cast<PostResolutionActor*>(this)->ActorCallback< PostResolutionActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PostResolutionActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("postResolution", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PostResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("postResolution", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< PostResolutionActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("postResolution", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PostResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("postResolution", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< PostResolutionActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("postResolution", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PostResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("postResolution", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont8(Void const& _,int loopDepth) 
	{
															#line 1569 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (debugID.present())
															#line 5384 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 1570 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			g_traceBatch.addEvent( "CommitDebug", debugID.get().first(), "CommitProxyServer.commitBatch.ApplyMetadataToCommittedTxn");
															#line 5388 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 1577 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (self->rangeLockEnabled())
															#line 5392 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 1578 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			rejectMutationsForReadLockOnRange(self);
															#line 5396 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 1582 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_4 = assignMutationsToStorageServers(self);
															#line 1582 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<PostResolutionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5402 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont8when1(__when_expr_4.get(), loopDepth); };
		static_cast<PostResolutionActor*>(this)->actor_wait_state = 5;
															#line 1582 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< PostResolutionActor, 4, Void >*>(static_cast<PostResolutionActor*>(this)));
															#line 5407 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont8(Void && _,int loopDepth) 
	{
															#line 1569 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (debugID.present())
															#line 5416 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 1570 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			g_traceBatch.addEvent( "CommitDebug", debugID.get().first(), "CommitProxyServer.commitBatch.ApplyMetadataToCommittedTxn");
															#line 5420 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 1577 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (self->rangeLockEnabled())
															#line 5424 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 1578 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			rejectMutationsForReadLockOnRange(self);
															#line 5428 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 1582 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_4 = assignMutationsToStorageServers(self);
															#line 1582 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<PostResolutionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5434 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont8when1(__when_expr_4.get(), loopDepth); };
		static_cast<PostResolutionActor*>(this)->actor_wait_state = 5;
															#line 1582 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< PostResolutionActor, 4, Void >*>(static_cast<PostResolutionActor*>(this)));
															#line 5439 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<PostResolutionActor*>(this)->actor_wait_state > 0) static_cast<PostResolutionActor*>(this)->actor_wait_state = 0;
		static_cast<PostResolutionActor*>(this)->ActorCallback< PostResolutionActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PostResolutionActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("postResolution", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PostResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("postResolution", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< PostResolutionActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("postResolution", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PostResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("postResolution", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< PostResolutionActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("postResolution", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PostResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("postResolution", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont9(Void const& _,int loopDepth) 
	{
															#line 1584 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (debugID.present())
															#line 5523 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 1585 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			g_traceBatch.addEvent("CommitDebug", debugID.get().first(), "CommitProxyServer.commitBatch.AssignMutationToSS");
															#line 5527 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 1589 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if ((pProxyCommitData->vecBackupKeys.size() > 1) && self->logRangeMutations.size())
															#line 5531 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 1590 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			StrictFuture<Void> __when_expr_5 = addBackupMutations(pProxyCommitData, &self->logRangeMutations, &self->toCommit, self->commitVersion, &self->computeDuration, &self->computeStart);
															#line 1590 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (static_cast<PostResolutionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5537 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont9when1(__when_expr_5.get(), loopDepth); };
			static_cast<PostResolutionActor*>(this)->actor_wait_state = 6;
															#line 1590 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< PostResolutionActor, 5, Void >*>(static_cast<PostResolutionActor*>(this)));
															#line 5542 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont12(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont9(Void && _,int loopDepth) 
	{
															#line 1584 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (debugID.present())
															#line 5556 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 1585 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			g_traceBatch.addEvent("CommitDebug", debugID.get().first(), "CommitProxyServer.commitBatch.AssignMutationToSS");
															#line 5560 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 1589 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if ((pProxyCommitData->vecBackupKeys.size() > 1) && self->logRangeMutations.size())
															#line 5564 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 1590 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			StrictFuture<Void> __when_expr_5 = addBackupMutations(pProxyCommitData, &self->logRangeMutations, &self->toCommit, self->commitVersion, &self->computeDuration, &self->computeStart);
															#line 1590 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (static_cast<PostResolutionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5570 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont9when1(__when_expr_5.get(), loopDepth); };
			static_cast<PostResolutionActor*>(this)->actor_wait_state = 6;
															#line 1590 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< PostResolutionActor, 5, Void >*>(static_cast<PostResolutionActor*>(this)));
															#line 5575 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont12(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont8when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<PostResolutionActor*>(this)->actor_wait_state > 0) static_cast<PostResolutionActor*>(this)->actor_wait_state = 0;
		static_cast<PostResolutionActor*>(this)->ActorCallback< PostResolutionActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PostResolutionActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("postResolution", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PostResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("postResolution", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< PostResolutionActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("postResolution", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PostResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("postResolution", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< PostResolutionActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("postResolution", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PostResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("postResolution", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont12(int loopDepth) 
	{
															#line 1602 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		buildIdempotencyIdMutations(self->trs, self->idempotencyKVBuilder, self->commitVersion, self->committed, ConflictBatch::TransactionCommitted, self->locked, [&](const KeyValue& kv) { MutationRef idempotencyIdSet; idempotencyIdSet.type = MutationRef::Type::SetValue; idempotencyIdSet.param1 = kv.key; idempotencyIdSet.param2 = kv.value; auto& tags = pProxyCommitData->tagsForKey(kv.key); ASSERT(!SERVER_KNOBS->ENABLE_VERSION_VECTOR_TLOG_UNICAST || pProxyCommitData->db->get().logSystemConfig.numLogs() == self->tpcvMap.size()); self->toCommit.addTags(tags); if (pProxyCommitData->acsBuilder != nullptr) { updateMutationWithAcsAndAddMutationToAcsBuilder( pProxyCommitData->acsBuilder, idempotencyIdSet, tags, getCommitProxyAccumulativeChecksumIndex(pProxyCommitData->commitProxyIndex), pProxyCommitData->epoch, self->commitVersion, pProxyCommitData->dbgid); } self->toCommit.writeTypedMessage(idempotencyIdSet); });
															#line 1631 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!SERVER_KNOBS->ENABLE_VERSION_VECTOR_TLOG_UNICAST || pProxyCommitData->db->get().logSystemConfig.numLogs() == self->tpcvMap.size())
															#line 5666 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 1633 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			i = 0;
															#line 1634 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			for(i = 0;i < pProxyCommitData->idempotencyClears.size();i++) {
															#line 1635 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				auto& tags = pProxyCommitData->tagsForKey(pProxyCommitData->idempotencyClears[i].param1);
															#line 1636 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				self->toCommit.addTags(tags);
															#line 1637 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (pProxyCommitData->acsBuilder != nullptr)
															#line 5678 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				{
															#line 1638 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					updateMutationWithAcsAndAddMutationToAcsBuilder( pProxyCommitData->acsBuilder, pProxyCommitData->idempotencyClears[i], tags, getCommitProxyAccumulativeChecksumIndex(pProxyCommitData->commitProxyIndex), pProxyCommitData->epoch, self->commitVersion, pProxyCommitData->dbgid);
															#line 5682 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				}
															#line 1647 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				WriteMutationRefVar var = writeMutation(self, &pProxyCommitData->idempotencyClears[i]);
															#line 1648 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				ASSERT(std::holds_alternative<MutationRef>(var));
															#line 5688 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
															#line 1650 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			pProxyCommitData->idempotencyClears = Standalone<VectorRef<MutationRef>>();
															#line 5692 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 1653 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->toCommit.saveTags(self->writtenTags);
															#line 1655 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->stats.mutations += self->mutationCount;
															#line 1656 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->stats.mutationBytes += self->mutationBytes;
															#line 1661 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (pProxyCommitData->committedVersion.get() < self->commitVersion - SERVER_KNOBS->MAX_READ_TRANSACTION_LIFE_VERSIONS)
															#line 5702 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 1663 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			self->computeDuration += g_network->timer_monotonic() - self->computeStart;
															#line 1664 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			waitVersionSpan = Span();
															#line 1665 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			;
															#line 5710 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			loopDepth = a_body1cont12loopHead1(loopDepth);
		}
		else
		{
			loopDepth = a_body1cont12cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont14(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1cont14(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1cont9when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont14(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont9when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont14(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<PostResolutionActor*>(this)->actor_wait_state > 0) static_cast<PostResolutionActor*>(this)->actor_wait_state = 0;
		static_cast<PostResolutionActor*>(this)->ActorCallback< PostResolutionActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PostResolutionActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("postResolution", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PostResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont9when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("postResolution", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< PostResolutionActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("postResolution", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PostResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("postResolution", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< PostResolutionActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("postResolution", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PostResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("postResolution", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont12cont1(int loopDepth) 
	{
															#line 1701 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->msg = self->storeCommits.back().first.get();
															#line 1703 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (self->debugID.present())
															#line 5813 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 1704 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			g_traceBatch.addEvent( "CommitDebug", self->debugID.get().first(), "CommitProxyServer.commitBatch.AfterStoreCommits");
															#line 5817 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 1708 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		bool firstMessage = true;
															#line 1709 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		for( auto m : self->msg.messages ) {
															#line 1710 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (firstMessage)
															#line 5825 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			{
															#line 1711 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				ASSERT(!SERVER_KNOBS->ENABLE_VERSION_VECTOR || pProxyCommitData->db->get().logSystemConfig.numLogs() == self->tpcvMap.size());
															#line 1713 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				self->toCommit.addTxsTag();
															#line 5831 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
															#line 1715 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			self->toCommit.writeMessage(StringRef(m.begin(), m.size()), !firstMessage);
															#line 1716 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			firstMessage = false;
															#line 5837 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 1719 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (self->prevVersion && self->commitVersion - self->prevVersion < SERVER_KNOBS->MAX_VERSIONS_IN_FLIGHT / 2)
															#line 5841 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 1720 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			debug_advanceMaxCommittedVersion(UID(), self->commitVersion);
															#line 5845 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 1729 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (self->prevVersion && self->commitVersion - self->prevVersion < SERVER_KNOBS->MAX_VERSIONS_IN_FLIGHT / 2)
															#line 5849 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 1730 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			debug_advanceMaxCommittedVersion(UID(), self->commitVersion);
															#line 5853 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 1732 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->commitStartTime = now();
															#line 1733 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->lastStartCommit = self->commitStartTime;
															#line 1734 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		Optional<std::unordered_map<uint16_t, Version>> tpcvMap = Optional<std::unordered_map<uint16_t, Version>>();
															#line 1735 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (SERVER_KNOBS->ENABLE_VERSION_VECTOR)
															#line 5863 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 1736 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			tpcvMap = self->tpcvMap;
															#line 5867 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 1738 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (self->pProxyCommitData->acsBuilder != nullptr)
															#line 5871 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 1740 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			addAccumulativeChecksumMutations(self);
															#line 5875 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 1742 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		const auto versionSet = ILogSystem::PushVersionSet{ self->prevVersion, self->commitVersion, pProxyCommitData->committedVersion.get(), pProxyCommitData->minKnownCommittedVersion };
															#line 1746 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->loggingComplete = pProxyCommitData->logSystem->push(versionSet, self->toCommit, span.context, self->debugID, tpcvMap);
															#line 1749 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		float ratio = self->toCommit.getEmptyMessageRatio();
															#line 1750 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->stats.commitBatchingEmptyMessageRatio.addMeasurement(ratio);
															#line 1752 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!self->forceRecovery)
															#line 5887 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 1753 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			ASSERT(pProxyCommitData->latestLocalCommitBatchLogging.get() == self->localBatchNumber - 1);
															#line 1754 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			pProxyCommitData->latestLocalCommitBatchLogging.set(self->localBatchNumber);
															#line 5893 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 1757 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->computeDuration += g_network->timer_monotonic() - self->computeStart;
															#line 1758 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (self->batchOperations > 0)
															#line 5899 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 1759 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			double estimatedDelay = computeReleaseDelay(self, self->latencyBucket);
															#line 1760 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			double computePerOperation = std::min(SERVER_KNOBS->MAX_COMPUTE_PER_OPERATION, self->computeDuration / self->batchOperations);
															#line 1763 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (computePerOperation <= pProxyCommitData->commitComputePerOperation[self->latencyBucket])
															#line 5907 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			{
															#line 1764 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				pProxyCommitData->commitComputePerOperation[self->latencyBucket] = computePerOperation;
															#line 5911 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
			else
			{
															#line 1766 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				pProxyCommitData->commitComputePerOperation[self->latencyBucket] = SERVER_KNOBS->PROXY_COMPUTE_GROWTH_RATE * computePerOperation + ((1.0 - SERVER_KNOBS->PROXY_COMPUTE_GROWTH_RATE) * pProxyCommitData->commitComputePerOperation[self->latencyBucket]);
															#line 5917 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
															#line 1771 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			pProxyCommitData->stats.maxComputeNS = std::max<int64_t>(pProxyCommitData->stats.maxComputeNS, 1e9 * pProxyCommitData->commitComputePerOperation[self->latencyBucket]);
															#line 1774 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			pProxyCommitData->stats.minComputeNS = std::min<int64_t>(pProxyCommitData->stats.minComputeNS, 1e9 * pProxyCommitData->commitComputePerOperation[self->latencyBucket]);
															#line 1778 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (estimatedDelay >= SERVER_KNOBS->MAX_COMPUTE_DURATION_LOG_CUTOFF || self->computeDuration >= SERVER_KNOBS->MAX_COMPUTE_DURATION_LOG_CUTOFF)
															#line 5925 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			{
															#line 1780 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				TraceEvent(SevInfo, "LongComputeDuration", pProxyCommitData->dbgid) .suppressFor(10.0) .detail("EstimatedComputeDuration", estimatedDelay) .detail("ComputeDuration", self->computeDuration) .detail("ComputePerOperation", computePerOperation) .detail("LatencyBucket", self->latencyBucket) .detail("UpdatedComputePerOperationEstimate", pProxyCommitData->commitComputePerOperation[self->latencyBucket]) .detail("BatchBytes", self->batchBytes) .detail("BatchOperations", self->batchOperations);
															#line 5929 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
		}
															#line 1793 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->stats.processingMutationDist->sampleSeconds(g_network->timer_monotonic() - postResolutionQueuing);
															#line 1794 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!static_cast<PostResolutionActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PostResolutionActorState(); static_cast<PostResolutionActor*>(this)->destroy(); return 0; }
															#line 5936 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		new (&static_cast<PostResolutionActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PostResolutionActorState();
		static_cast<PostResolutionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont12cont5(int loopDepth) 
	{
															#line 1697 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		waitVersionSpan = Span{};
															#line 1698 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->computeStart = g_network->timer_monotonic();
															#line 5950 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = a_body1cont12cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont12loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1(int loopDepth) 
	{
															#line 1665 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!(pProxyCommitData->committedVersion.get() < self->commitVersion - SERVER_KNOBS->MAX_READ_TRANSACTION_LIFE_VERSIONS))
															#line 5966 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
			return a_body1cont12break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1669 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		CODE_PROBE(true, "Semi-committed pipeline limited by MVCC window");
															#line 1671 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		waitVersionSpan = Span("MP:overMaxReadTransactionLifeVersions"_loc, span.context);
															#line 1673 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_6 = pProxyCommitData->committedVersion.whenAtLeast( self->commitVersion - SERVER_KNOBS->MAX_READ_TRANSACTION_LIFE_VERSIONS);
															#line 1672 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<PostResolutionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5978 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1when1(__when_expr_6.get(), loopDepth); };
															#line 1678 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_7 = pProxyCommitData->cx->onProxiesChanged();
															#line 5982 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1when2(__when_expr_7.get(), loopDepth); };
															#line 1682 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<GetRawCommittedVersionReply> __when_expr_8 = pProxyCommitData->master.getLiveCommittedVersion.getReply( GetRawCommittedVersionRequest(waitVersionSpan.context, debugID, invalidVersion), TaskPriority::GetLiveCommittedVersionReply);
															#line 5986 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1when3(__when_expr_8.get(), loopDepth); };
		static_cast<PostResolutionActor*>(this)->actor_wait_state = 7;
															#line 1673 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< PostResolutionActor, 6, Void >*>(static_cast<PostResolutionActor*>(this)));
															#line 1678 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< PostResolutionActor, 7, Void >*>(static_cast<PostResolutionActor*>(this)));
															#line 1682 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< PostResolutionActor, 8, GetRawCommittedVersionReply >*>(static_cast<PostResolutionActor*>(this)));
															#line 5995 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12break1(int loopDepth) 
	{
		try {
			return a_body1cont12cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont12loopHead1(0);

		return loopDepth;
	}
	int a_body1cont12loopBody1when1(Void const& _,int loopDepth) 
	{
															#line 1675 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_9 = yield();
															#line 1675 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<PostResolutionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6025 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1when1when1(__when_expr_9.get(), loopDepth); };
		static_cast<PostResolutionActor*>(this)->actor_wait_state = 8;
															#line 1675 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< PostResolutionActor, 9, Void >*>(static_cast<PostResolutionActor*>(this)));
															#line 6030 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12loopBody1when1(Void && _,int loopDepth) 
	{
															#line 1675 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_9 = yield();
															#line 1675 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<PostResolutionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6041 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1when1when1(__when_expr_9.get(), loopDepth); };
		static_cast<PostResolutionActor*>(this)->actor_wait_state = 8;
															#line 1675 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< PostResolutionActor, 9, Void >*>(static_cast<PostResolutionActor*>(this)));
															#line 6046 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12loopBody1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when3(GetRawCommittedVersionReply const& v,int loopDepth) 
	{
															#line 1685 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (v.version > pProxyCommitData->committedVersion.get())
															#line 6067 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 1686 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			pProxyCommitData->locked = v.locked;
															#line 1687 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			pProxyCommitData->metadataVersion = v.metadataVersion;
															#line 1688 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			pProxyCommitData->committedVersion.set(v.version);
															#line 6075 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 1691 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (pProxyCommitData->committedVersion.get() < self->commitVersion - SERVER_KNOBS->MAX_READ_TRANSACTION_LIFE_VERSIONS)
															#line 6079 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 1693 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			StrictFuture<Void> __when_expr_10 = delay(SERVER_KNOBS->PROXY_SPIN_DELAY);
															#line 1693 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (static_cast<PostResolutionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6085 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1Catch1(__when_expr_10.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1when3when1(__when_expr_10.get(), loopDepth); };
			static_cast<PostResolutionActor*>(this)->actor_wait_state = 9;
															#line 1693 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< PostResolutionActor, 10, Void >*>(static_cast<PostResolutionActor*>(this)));
															#line 6090 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont12loopBody1when3cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12loopBody1when3(GetRawCommittedVersionReply && v,int loopDepth) 
	{
															#line 1685 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (v.version > pProxyCommitData->committedVersion.get())
															#line 6104 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 1686 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			pProxyCommitData->locked = v.locked;
															#line 1687 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			pProxyCommitData->metadataVersion = v.metadataVersion;
															#line 1688 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			pProxyCommitData->committedVersion.set(v.version);
															#line 6112 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 1691 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (pProxyCommitData->committedVersion.get() < self->commitVersion - SERVER_KNOBS->MAX_READ_TRANSACTION_LIFE_VERSIONS)
															#line 6116 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 1693 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			StrictFuture<Void> __when_expr_10 = delay(SERVER_KNOBS->PROXY_SPIN_DELAY);
															#line 1693 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (static_cast<PostResolutionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6122 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1Catch1(__when_expr_10.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1when3when1(__when_expr_10.get(), loopDepth); };
			static_cast<PostResolutionActor*>(this)->actor_wait_state = 9;
															#line 1693 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< PostResolutionActor, 10, Void >*>(static_cast<PostResolutionActor*>(this)));
															#line 6127 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont12loopBody1when3cont1(loopDepth);
		}

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<PostResolutionActor*>(this)->actor_wait_state > 0) static_cast<PostResolutionActor*>(this)->actor_wait_state = 0;
		static_cast<PostResolutionActor*>(this)->ActorCallback< PostResolutionActor, 6, Void >::remove();
		static_cast<PostResolutionActor*>(this)->ActorCallback< PostResolutionActor, 7, Void >::remove();
		static_cast<PostResolutionActor*>(this)->ActorCallback< PostResolutionActor, 8, GetRawCommittedVersionReply >::remove();

	}
	int a_body1cont12loopBody1when1cont1(Void const& _,int loopDepth) 
	{
		return a_body1cont12break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont12loopBody1when1cont1(Void && _,int loopDepth) 
	{
		return a_body1cont12break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont12loopBody1when1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12loopBody1when1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12loopBody1when1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<PostResolutionActor*>(this)->actor_wait_state > 0) static_cast<PostResolutionActor*>(this)->actor_wait_state = 0;
		static_cast<PostResolutionActor*>(this)->ActorCallback< PostResolutionActor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PostResolutionActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("postResolution", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PostResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont12loopBody1when1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("postResolution", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< PostResolutionActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("postResolution", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PostResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont12loopBody1when1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("postResolution", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< PostResolutionActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("postResolution", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PostResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("postResolution", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< PostResolutionActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("postResolution", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PostResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont12loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("postResolution", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< PostResolutionActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("postResolution", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PostResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont12loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("postResolution", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< PostResolutionActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("postResolution", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PostResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("postResolution", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< PostResolutionActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("postResolution", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PostResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont12loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("postResolution", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< PostResolutionActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("postResolution", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PostResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont12loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("postResolution", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< PostResolutionActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("postResolution", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PostResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("postResolution", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont12loopBody1when3cont1(int loopDepth) 
	{
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when3cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12loopBody1when3cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when3cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12loopBody1when3cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12loopBody1when3cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12loopBody1when3cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<PostResolutionActor*>(this)->actor_wait_state > 0) static_cast<PostResolutionActor*>(this)->actor_wait_state = 0;
		static_cast<PostResolutionActor*>(this)->ActorCallback< PostResolutionActor, 10, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PostResolutionActor, 10, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("postResolution", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PostResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont12loopBody1when3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("postResolution", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< PostResolutionActor, 10, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("postResolution", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PostResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont12loopBody1when3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("postResolution", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< PostResolutionActor, 10, Void >*,Error err) 
	{
		fdb_probe_actor_enter("postResolution", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PostResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("postResolution", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< PostResolutionActor, 8, GetRawCommittedVersionReply >*,GetRawCommittedVersionReply const& value) 
	{
		fdb_probe_actor_enter("postResolution", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PostResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont12loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("postResolution", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< PostResolutionActor, 8, GetRawCommittedVersionReply >*,GetRawCommittedVersionReply && value) 
	{
		fdb_probe_actor_enter("postResolution", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PostResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont12loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("postResolution", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< PostResolutionActor, 8, GetRawCommittedVersionReply >*,Error err) 
	{
		fdb_probe_actor_enter("postResolution", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PostResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("postResolution", reinterpret_cast<unsigned long>(this), 8);

	}
															#line 1519 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	CommitBatchContext* self;
															#line 1520 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	double postResolutionStart;
															#line 1521 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ProxyCommitData* const pProxyCommitData;
															#line 1522 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	std::vector<CommitTransactionRequest>& trs;
															#line 1523 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	const int64_t localBatchNumber;
															#line 1524 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	const Optional<UID>& debugID;
															#line 1525 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Span span;
															#line 1530 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	double postResolutionQueuing;
															#line 1633 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	int i;
															#line 1664 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Span waitVersionSpan;
															#line 6516 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via postResolution()
															#line 1519 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class PostResolutionActor final : public Actor<Void>, public ActorCallback< PostResolutionActor, 0, Void >, public ActorCallback< PostResolutionActor, 1, Void >, public ActorCallback< PostResolutionActor, 2, Void >, public ActorCallback< PostResolutionActor, 3, Void >, public ActorCallback< PostResolutionActor, 4, Void >, public ActorCallback< PostResolutionActor, 5, Void >, public ActorCallback< PostResolutionActor, 6, Void >, public ActorCallback< PostResolutionActor, 9, Void >, public ActorCallback< PostResolutionActor, 7, Void >, public ActorCallback< PostResolutionActor, 8, GetRawCommittedVersionReply >, public ActorCallback< PostResolutionActor, 10, Void >, public FastAllocated<PostResolutionActor>, public PostResolutionActorState<PostResolutionActor> {
															#line 6521 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
	using FastAllocated<PostResolutionActor>::operator new;
	using FastAllocated<PostResolutionActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12820325120110386688UL, 11690757344545830656UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PostResolutionActor, 0, Void >;
friend struct ActorCallback< PostResolutionActor, 1, Void >;
friend struct ActorCallback< PostResolutionActor, 2, Void >;
friend struct ActorCallback< PostResolutionActor, 3, Void >;
friend struct ActorCallback< PostResolutionActor, 4, Void >;
friend struct ActorCallback< PostResolutionActor, 5, Void >;
friend struct ActorCallback< PostResolutionActor, 6, Void >;
friend struct ActorCallback< PostResolutionActor, 9, Void >;
friend struct ActorCallback< PostResolutionActor, 7, Void >;
friend struct ActorCallback< PostResolutionActor, 8, GetRawCommittedVersionReply >;
friend struct ActorCallback< PostResolutionActor, 10, Void >;
															#line 1519 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	PostResolutionActor(CommitBatchContext* const& self) 
															#line 6548 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   PostResolutionActorState<PostResolutionActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("postResolution", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15846867638177296640UL, 14373598132617893888UL);
		ActorExecutionContextHelper __helper(static_cast<PostResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("postResolution");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("postResolution", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PostResolutionActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< PostResolutionActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< PostResolutionActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< PostResolutionActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< PostResolutionActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< PostResolutionActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< PostResolutionActor, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< PostResolutionActor, 9, Void >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< PostResolutionActor, 10, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1519 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
[[nodiscard]] Future<Void> postResolution( CommitBatchContext* const& self ) {
															#line 1519 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	return Future<Void>(new PostResolutionActor(self));
															#line 6588 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
}

#line 1796 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"

															#line 6593 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
// This generated class is to be used only via transactionLogging()
															#line 1797 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
template <class TransactionLoggingActor>
															#line 1797 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class TransactionLoggingActorState {
															#line 6599 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
															#line 1797 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	TransactionLoggingActorState(CommitBatchContext* const& self) 
															#line 1797 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
															#line 1797 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		 : self(self),
															#line 1798 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   tLoggingStart(g_network->timer_monotonic()),
															#line 1799 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   pProxyCommitData(self->pProxyCommitData),
															#line 1800 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   span("MP:transactionLogging"_loc, self->span.context)
															#line 6612 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("transactionLogging", reinterpret_cast<unsigned long>(this));

	}
	~TransactionLoggingActorState() 
	{
		fdb_probe_actor_destroy("transactionLogging", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 1804 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				StrictFuture<Version> __when_expr_0 = self->loggingComplete;
															#line 1803 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (static_cast<TransactionLoggingActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 6630 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
															#line 1810 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				StrictFuture<Void> __when_expr_1 = pProxyCommitData->committedVersion.whenAtLeast(self->commitVersion + 1);
															#line 6634 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
				static_cast<TransactionLoggingActor*>(this)->actor_wait_state = 1;
															#line 1804 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TransactionLoggingActor, 0, Version >*>(static_cast<TransactionLoggingActor*>(this)));
															#line 1810 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TransactionLoggingActor, 1, Void >*>(static_cast<TransactionLoggingActor*>(this)));
															#line 6641 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TransactionLoggingActorState();
		static_cast<TransactionLoggingActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1819 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->lastCommitLatency = now() - self->commitStartTime;
															#line 1820 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->lastCommitTime = std::max(pProxyCommitData->lastCommitTime.get(), self->commitStartTime);
															#line 1822 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_2 = yield(TaskPriority::ProxyCommitYield2);
															#line 1822 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<TransactionLoggingActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6676 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<TransactionLoggingActor*>(this)->actor_wait_state = 2;
															#line 1822 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TransactionLoggingActor, 2, Void >*>(static_cast<TransactionLoggingActor*>(this)));
															#line 6681 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1813 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (e.code() == error_code_broken_promise)
															#line 6691 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			{
															#line 1814 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				return a_body1Catch1(tlog_failed(), loopDepth);
															#line 6695 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
															#line 1816 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 6699 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Version const& ver,int loopDepth) 
	{
															#line 1805 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!SERVER_KNOBS->ENABLE_VERSION_VECTOR_TLOG_UNICAST)
															#line 6719 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 1806 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			pProxyCommitData->minKnownCommittedVersion = std::max(pProxyCommitData->minKnownCommittedVersion, ver);
															#line 6723 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Version && ver,int loopDepth) 
	{
															#line 1805 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!SERVER_KNOBS->ENABLE_VERSION_VECTOR_TLOG_UNICAST)
															#line 6733 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 1806 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			pProxyCommitData->minKnownCommittedVersion = std::max(pProxyCommitData->minKnownCommittedVersion, ver);
															#line 6737 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TransactionLoggingActor*>(this)->actor_wait_state > 0) static_cast<TransactionLoggingActor*>(this)->actor_wait_state = 0;
		static_cast<TransactionLoggingActor*>(this)->ActorCallback< TransactionLoggingActor, 0, Version >::remove();
		static_cast<TransactionLoggingActor*>(this)->ActorCallback< TransactionLoggingActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TransactionLoggingActor, 0, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("transactionLogging", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TransactionLoggingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("transactionLogging", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TransactionLoggingActor, 0, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("transactionLogging", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TransactionLoggingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("transactionLogging", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TransactionLoggingActor, 0, Version >*,Error err) 
	{
		fdb_probe_actor_enter("transactionLogging", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TransactionLoggingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("transactionLogging", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TransactionLoggingActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("transactionLogging", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TransactionLoggingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("transactionLogging", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TransactionLoggingActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("transactionLogging", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TransactionLoggingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("transactionLogging", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TransactionLoggingActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("transactionLogging", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TransactionLoggingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("transactionLogging", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 1824 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (pProxyCommitData->popRemoteTxs && self->msg.popTo > (pProxyCommitData->txsPopVersions.size() ? pProxyCommitData->txsPopVersions.back().second : pProxyCommitData->lastTxsPop))
															#line 6893 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 1827 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (pProxyCommitData->txsPopVersions.size() >= SERVER_KNOBS->MAX_TXS_POP_VERSION_HISTORY)
															#line 6897 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			{
															#line 1828 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				TraceEvent(SevWarnAlways, "DiscardingTxsPopHistory").suppressFor(1.0);
															#line 1829 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				pProxyCommitData->txsPopVersions.pop_front();
															#line 6903 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
															#line 1832 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			pProxyCommitData->txsPopVersions.emplace_back(self->commitVersion, self->msg.popTo);
															#line 6907 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 1834 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->logSystem->popTxs(self->msg.popTo);
															#line 1835 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->stats.tlogLoggingDist->sampleSeconds(g_network->timer_monotonic() - tLoggingStart);
															#line 1836 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!static_cast<TransactionLoggingActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TransactionLoggingActorState(); static_cast<TransactionLoggingActor*>(this)->destroy(); return 0; }
															#line 6915 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		new (&static_cast<TransactionLoggingActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TransactionLoggingActorState();
		static_cast<TransactionLoggingActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 1824 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (pProxyCommitData->popRemoteTxs && self->msg.popTo > (pProxyCommitData->txsPopVersions.size() ? pProxyCommitData->txsPopVersions.back().second : pProxyCommitData->lastTxsPop))
															#line 6927 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 1827 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (pProxyCommitData->txsPopVersions.size() >= SERVER_KNOBS->MAX_TXS_POP_VERSION_HISTORY)
															#line 6931 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			{
															#line 1828 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				TraceEvent(SevWarnAlways, "DiscardingTxsPopHistory").suppressFor(1.0);
															#line 1829 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				pProxyCommitData->txsPopVersions.pop_front();
															#line 6937 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
															#line 1832 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			pProxyCommitData->txsPopVersions.emplace_back(self->commitVersion, self->msg.popTo);
															#line 6941 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 1834 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->logSystem->popTxs(self->msg.popTo);
															#line 1835 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->stats.tlogLoggingDist->sampleSeconds(g_network->timer_monotonic() - tLoggingStart);
															#line 1836 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!static_cast<TransactionLoggingActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TransactionLoggingActorState(); static_cast<TransactionLoggingActor*>(this)->destroy(); return 0; }
															#line 6949 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		new (&static_cast<TransactionLoggingActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TransactionLoggingActorState();
		static_cast<TransactionLoggingActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TransactionLoggingActor*>(this)->actor_wait_state > 0) static_cast<TransactionLoggingActor*>(this)->actor_wait_state = 0;
		static_cast<TransactionLoggingActor*>(this)->ActorCallback< TransactionLoggingActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TransactionLoggingActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("transactionLogging", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TransactionLoggingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("transactionLogging", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TransactionLoggingActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("transactionLogging", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TransactionLoggingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("transactionLogging", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TransactionLoggingActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("transactionLogging", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TransactionLoggingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("transactionLogging", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 1797 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	CommitBatchContext* self;
															#line 1798 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	double tLoggingStart;
															#line 1799 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ProxyCommitData* const pProxyCommitData;
															#line 1800 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Span span;
															#line 7040 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via transactionLogging()
															#line 1797 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class TransactionLoggingActor final : public Actor<Void>, public ActorCallback< TransactionLoggingActor, 0, Version >, public ActorCallback< TransactionLoggingActor, 1, Void >, public ActorCallback< TransactionLoggingActor, 2, Void >, public FastAllocated<TransactionLoggingActor>, public TransactionLoggingActorState<TransactionLoggingActor> {
															#line 7045 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
	using FastAllocated<TransactionLoggingActor>::operator new;
	using FastAllocated<TransactionLoggingActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15052827596125746688UL, 8922995046579238656UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TransactionLoggingActor, 0, Version >;
friend struct ActorCallback< TransactionLoggingActor, 1, Void >;
friend struct ActorCallback< TransactionLoggingActor, 2, Void >;
															#line 1797 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	TransactionLoggingActor(CommitBatchContext* const& self) 
															#line 7064 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   TransactionLoggingActorState<TransactionLoggingActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("transactionLogging", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3004937098039659520UL, 11889376626278748672UL);
		ActorExecutionContextHelper __helper(static_cast<TransactionLoggingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("transactionLogging");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("transactionLogging", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TransactionLoggingActor, 0, Version >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TransactionLoggingActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1797 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
[[nodiscard]] Future<Void> transactionLogging( CommitBatchContext* const& self ) {
															#line 1797 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	return Future<Void>(new TransactionLoggingActor(self));
															#line 7097 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
}

#line 1838 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"

															#line 7102 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
// This generated class is to be used only via reply()
															#line 1839 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
template <class ReplyActor>
															#line 1839 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class ReplyActorState {
															#line 7108 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
															#line 1839 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ReplyActorState(CommitBatchContext* const& self) 
															#line 1839 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
															#line 1839 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		 : self(self),
															#line 1840 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   replyStart(g_network->timer_monotonic()),
															#line 1841 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   pProxyCommitData(self->pProxyCommitData),
															#line 1842 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   span("MP:reply"_loc, self->span.context),
															#line 1844 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   debugID(self->debugID)
															#line 7123 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("reply", reinterpret_cast<unsigned long>(this));

	}
	~ReplyActorState() 
	{
		fdb_probe_actor_destroy("reply", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1846 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (!SERVER_KNOBS->ENABLE_VERSION_VECTOR_TLOG_UNICAST)
															#line 7138 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			{
															#line 1851 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (self->prevVersion && self->commitVersion - self->prevVersion < SERVER_KNOBS->MAX_VERSIONS_IN_FLIGHT / 2)
															#line 7142 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				{
															#line 1853 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					debug_advanceMinCommittedVersion(UID(), self->commitVersion);
															#line 7146 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				}
															#line 1857 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				acknowledgeTransactionStateStoreCommits(self);
															#line 7150 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
															#line 1863 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (debugID.present())
															#line 7154 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			{
															#line 1864 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				g_traceBatch.addEvent("CommitDebug", debugID.get().first(), "CommitProxyServer.commitBatch.AfterLogPush");
															#line 7158 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
															#line 1872 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			CODE_PROBE(pProxyCommitData->committedVersion.get() > self->commitVersion, "later version was reported committed first");
															#line 1875 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (self->commitVersion >= pProxyCommitData->committedVersion.get())
															#line 7164 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			{
															#line 1876 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				writtenTags = Optional<std::set<Tag>>();
															#line 1877 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (SERVER_KNOBS->ENABLE_VERSION_VECTOR)
															#line 7170 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				{
															#line 1878 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					writtenTags = self->writtenTags;
															#line 7174 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				}
															#line 1880 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				StrictFuture<Void> __when_expr_0 = pProxyCommitData->master.reportLiveCommittedVersion.getReply( ReportRawCommittedVersionRequest(self->commitVersion, self->lockedAfter, self->metadataVersionAfter, pProxyCommitData->minKnownCommittedVersion, self->prevVersion, writtenTags), TaskPriority::ProxyMasterVersionReply);
															#line 1880 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (static_cast<ReplyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7180 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<ReplyActor*>(this)->actor_wait_state = 1;
															#line 1880 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ReplyActor, 0, Void >*>(static_cast<ReplyActor*>(this)));
															#line 7185 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ReplyActorState();
		static_cast<ReplyActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1890 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (debugID.present())
															#line 7213 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 1891 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			g_traceBatch.addEvent( "CommitDebug", debugID.get().first(), "CommitProxyServer.commitBatch.AfterReportRawCommittedVersion");
															#line 7217 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 1895 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (SERVER_KNOBS->ENABLE_VERSION_VECTOR_TLOG_UNICAST)
															#line 7221 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 1900 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (self->prevVersion && self->commitVersion - self->prevVersion < SERVER_KNOBS->MAX_VERSIONS_IN_FLIGHT / 2)
															#line 7225 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			{
															#line 1902 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				debug_advanceMinCommittedVersion(UID(), self->commitVersion);
															#line 7229 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
															#line 1906 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			acknowledgeTransactionStateStoreCommits(self);
															#line 7233 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 1909 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (self->commitVersion > pProxyCommitData->committedVersion.get())
															#line 7237 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 1910 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			pProxyCommitData->locked = self->lockedAfter;
															#line 1911 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			pProxyCommitData->metadataVersion = self->metadataVersionAfter;
															#line 1912 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			pProxyCommitData->committedVersion.set(self->commitVersion);
															#line 1913 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (SERVER_KNOBS->ENABLE_VERSION_VECTOR_TLOG_UNICAST)
															#line 7247 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			{
															#line 1914 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				ASSERT(self->loggingComplete.isReady());
															#line 1915 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				pProxyCommitData->minKnownCommittedVersion = std::max(pProxyCommitData->minKnownCommittedVersion, self->loggingComplete.get());
															#line 7253 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
		}
															#line 1920 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (self->forceRecovery)
															#line 7258 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 1921 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			TraceEvent(SevWarn, "RestartingTxnSubsystem", pProxyCommitData->dbgid).detail("Stage", "ProxyShutdown");
															#line 1922 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			return a_body1Catch1(worker_removed(), loopDepth);
															#line 7264 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 1927 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		double endTime = g_network->timer();
															#line 1930 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		std::fill(self->nextTr.begin(), self->nextTr.end(), 0);
															#line 1931 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		std::unordered_map<uint8_t, int16_t> idCountsForKey;
															#line 1932 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		for(int t = 0;t < self->trs.size();t++) {
															#line 1933 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			auto& tr = self->trs[t];
															#line 1934 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (self->committed[t] == ConflictBatch::TransactionCommitted && (!self->locked || tr.isLockAware()))
															#line 7278 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			{
															#line 1935 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				ASSERT_WE_THINK(self->commitVersion != invalidVersion);
															#line 1936 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (self->trs[t].idempotencyId.valid())
															#line 7284 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				{
															#line 1937 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					idCountsForKey[uint8_t(t >> 8)] += 1;
															#line 7288 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				}
															#line 1939 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				tr.reply.send(CommitID(self->commitVersion, t, self->metadataVersionAfter));
															#line 7292 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
			else
			{
															#line 1940 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (self->committed[t] == ConflictBatch::TransactionTooOld)
															#line 7298 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				{
															#line 1941 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					tr.reply.sendError(transaction_too_old());
															#line 7302 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				}
				else
				{
															#line 1942 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					if (self->committed[t] == ConflictBatch::TransactionLockReject)
															#line 7308 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
					{
															#line 1944 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						ASSERT(tr.reply.isSet());
															#line 7312 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
					}
					else
					{
															#line 1948 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						if (tr.transaction.report_conflicting_keys)
															#line 7318 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
						{
															#line 1949 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
							Standalone<VectorRef<int>> conflictingKRIndices;
															#line 1950 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
							for( int resolverInd : self->transactionResolverMap[t] ) {
															#line 1951 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
								auto const& cKRs = self->resolution[resolverInd] .conflictingKeyRangeMap[self->nextTr[resolverInd]];
															#line 1955 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
								for( auto const& rCRIndex : cKRs ) {
															#line 1958 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
									conflictingKRIndices.push_back(conflictingKRIndices.arena(), self->txReadConflictRangeIndexMap[t][resolverInd][rCRIndex]);
															#line 7330 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
								}
							}
															#line 1962 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
							ASSERT(conflictingKRIndices.size());
															#line 1963 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
							tr.reply.send(CommitID( invalidVersion, t, Optional<Value>(), Optional<Standalone<VectorRef<int>>>(conflictingKRIndices)));
															#line 7337 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
						}
						else
						{
															#line 1966 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
							tr.reply.sendError(not_committed());
															#line 7343 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
						}
					}
				}
			}
															#line 1971 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			for( int resolverInd : self->transactionResolverMap[t] ) {
															#line 1972 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				self->nextTr[resolverInd]++;
															#line 7352 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
															#line 1975 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			const double duration = endTime - tr.requestTime();
															#line 1976 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			pProxyCommitData->stats.commitLatencySample.addMeasurement(duration);
															#line 1977 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (pProxyCommitData->latencyBandConfig.present())
															#line 7360 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			{
															#line 1978 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				bool filter = self->maxTransactionBytes > pProxyCommitData->latencyBandConfig.get().commitConfig.maxCommitBytes.orDefault( std::numeric_limits<int>::max());
															#line 1981 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				pProxyCommitData->stats.commitLatencyBands.addMeasurement(duration, 1, Filtered(filter));
															#line 7366 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
		}
															#line 1985 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		for( auto [highOrderBatchIndex, count] : idCountsForKey ) {
															#line 1986 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			pProxyCommitData->expectedIdempotencyIdCountForKey.send( ExpectedIdempotencyIdCountForKey{ self->commitVersion, count, highOrderBatchIndex });
															#line 7373 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 1990 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		++pProxyCommitData->stats.commitBatchOut;
															#line 1991 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->stats.txnCommitOut += self->trs.size();
															#line 1992 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->stats.txnConflicts += self->trs.size() - self->commitCount;
															#line 1993 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->stats.txnCommitOutSuccess += self->commitCount;
															#line 1995 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (now() - pProxyCommitData->lastCoalesceTime > SERVER_KNOBS->RESOLVER_COALESCE_TIME)
															#line 7385 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 1996 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			pProxyCommitData->lastCoalesceTime = now();
															#line 1997 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			int lastSize = pProxyCommitData->keyResolvers.size();
															#line 1998 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			auto rs = pProxyCommitData->keyResolvers.ranges();
															#line 1999 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			Version oldestVersion = self->prevVersion - SERVER_KNOBS->MAX_WRITE_TRANSACTION_LIFE_VERSIONS;
															#line 2000 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			for(auto r = rs.begin();r != rs.end();++r) {
															#line 2001 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				for(;r->value().size() > 1 && r->value()[1].first < oldestVersion;) {
															#line 2002 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					r->value().pop_front();
															#line 7401 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				}
															#line 2003 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (r->value().size() && r->value().front().first < oldestVersion)
															#line 7405 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				{
															#line 2004 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					r->value().front().first = 0;
															#line 7409 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				}
			}
															#line 2006 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (SERVER_KNOBS->PROXY_USE_RESOLVER_PRIVATE_MUTATIONS)
															#line 7414 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			{
															#line 2008 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				pProxyCommitData->keyResolvers.coalesce(normalKeys);
															#line 2009 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				auto& versions = pProxyCommitData->systemKeyVersions;
															#line 2010 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				for(;versions.size() > 1 && versions[1] < oldestVersion;) {
															#line 2011 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					versions.pop_front();
															#line 7424 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				}
															#line 2013 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (!versions.empty() && versions[0] < oldestVersion)
															#line 7428 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				{
															#line 2014 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					versions[0] = 0;
															#line 7432 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				}
			}
			else
			{
															#line 2017 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				pProxyCommitData->keyResolvers.coalesce(allKeys);
															#line 7439 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
															#line 2019 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (pProxyCommitData->keyResolvers.size() != lastSize)
															#line 7443 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			{
															#line 2020 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				TraceEvent("KeyResolverSize", pProxyCommitData->dbgid) .detail("Size", pProxyCommitData->keyResolvers.size());
															#line 7447 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
		}
															#line 2025 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		double target_latency = (now() - self->startTime) * SERVER_KNOBS->COMMIT_TRANSACTION_BATCH_INTERVAL_LATENCY_FRACTION;
															#line 2027 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->commitBatchInterval = std::max(SERVER_KNOBS->COMMIT_TRANSACTION_BATCH_INTERVAL_MIN, std::min(SERVER_KNOBS->COMMIT_TRANSACTION_BATCH_INTERVAL_MAX, target_latency * SERVER_KNOBS->COMMIT_TRANSACTION_BATCH_INTERVAL_SMOOTHER_ALPHA + pProxyCommitData->commitBatchInterval * (1 - SERVER_KNOBS->COMMIT_TRANSACTION_BATCH_INTERVAL_SMOOTHER_ALPHA)));
															#line 2033 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->stats.commitBatchingWindowSize.addMeasurement(pProxyCommitData->commitBatchInterval);
															#line 2034 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->commitBatchesMemBytesCount -= self->currentBatchMemBytesCount;
															#line 2035 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		ASSERT_ABORT(pProxyCommitData->commitBatchesMemBytesCount >= 0);
															#line 2036 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->releaseFuture;
															#line 2036 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<ReplyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7464 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ReplyActor*>(this)->actor_wait_state = 2;
															#line 2036 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ReplyActor, 1, Void >*>(static_cast<ReplyActor*>(this)));
															#line 7469 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ReplyActor*>(this)->actor_wait_state > 0) static_cast<ReplyActor*>(this)->actor_wait_state = 0;
		static_cast<ReplyActor*>(this)->ActorCallback< ReplyActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ReplyActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("reply", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReplyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reply", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ReplyActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("reply", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReplyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reply", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ReplyActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("reply", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReplyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reply", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont7(Void const& _,int loopDepth) 
	{
															#line 2037 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->stats.replyCommitDist->sampleSeconds(g_network->timer_monotonic() - replyStart);
															#line 2038 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!static_cast<ReplyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ReplyActorState(); static_cast<ReplyActor*>(this)->destroy(); return 0; }
															#line 7567 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		new (&static_cast<ReplyActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ReplyActorState();
		static_cast<ReplyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont7(Void && _,int loopDepth) 
	{
															#line 2037 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->stats.replyCommitDist->sampleSeconds(g_network->timer_monotonic() - replyStart);
															#line 2038 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!static_cast<ReplyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ReplyActorState(); static_cast<ReplyActor*>(this)->destroy(); return 0; }
															#line 7581 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		new (&static_cast<ReplyActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ReplyActorState();
		static_cast<ReplyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ReplyActor*>(this)->actor_wait_state > 0) static_cast<ReplyActor*>(this)->actor_wait_state = 0;
		static_cast<ReplyActor*>(this)->ActorCallback< ReplyActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ReplyActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("reply", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReplyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reply", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ReplyActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("reply", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReplyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reply", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ReplyActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("reply", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReplyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reply", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1839 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	CommitBatchContext* self;
															#line 1840 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	double replyStart;
															#line 1841 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ProxyCommitData* const pProxyCommitData;
															#line 1842 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Span span;
															#line 1844 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	const Optional<UID>& debugID;
															#line 1876 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Optional<std::set<Tag>> writtenTags;
															#line 7676 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via reply()
															#line 1839 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class ReplyActor final : public Actor<Void>, public ActorCallback< ReplyActor, 0, Void >, public ActorCallback< ReplyActor, 1, Void >, public FastAllocated<ReplyActor>, public ReplyActorState<ReplyActor> {
															#line 7681 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
	using FastAllocated<ReplyActor>::operator new;
	using FastAllocated<ReplyActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(18331258130196364032UL, 2153092928703441664UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ReplyActor, 0, Void >;
friend struct ActorCallback< ReplyActor, 1, Void >;
															#line 1839 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ReplyActor(CommitBatchContext* const& self) 
															#line 7699 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   ReplyActorState<ReplyActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("reply", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(412875400346227200UL, 2164551364787983616UL);
		ActorExecutionContextHelper __helper(static_cast<ReplyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("reply");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("reply", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ReplyActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ReplyActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1839 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
[[nodiscard]] Future<Void> reply( CommitBatchContext* const& self ) {
															#line 1839 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	return Future<Void>(new ReplyActor(self));
															#line 7732 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
}

#line 2040 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"

// Commit one batch of transactions trs
															#line 7738 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
// This generated class is to be used only via commitBatchImpl()
															#line 2042 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
template <class CommitBatchImplActor>
															#line 2042 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class CommitBatchImplActorState {
															#line 7744 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
															#line 2042 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	CommitBatchImplActorState(CommitBatchContext* const& pContext) 
															#line 2042 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
															#line 2042 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		 : pContext(pContext)
															#line 7751 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("commitBatchImpl", reinterpret_cast<unsigned long>(this));

	}
	~CommitBatchImplActorState() 
	{
		fdb_probe_actor_destroy("commitBatchImpl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2046 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			pContext->stage = INITIALIZE;
															#line 2047 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			getCurrentLineage()->modify(&TransactionLineage::operation) = TransactionLineage::Operation::Commit;
															#line 2051 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(0, TaskPriority::ProxyCommit);
															#line 2051 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (static_cast<CommitBatchImplActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7772 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CommitBatchImplActor*>(this)->actor_wait_state = 1;
															#line 2051 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CommitBatchImplActor, 0, Void >*>(static_cast<CommitBatchImplActor*>(this)));
															#line 7777 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CommitBatchImplActorState();
		static_cast<CommitBatchImplActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 2053 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pContext->pProxyCommitData->lastVersionTime = pContext->startTime;
															#line 2054 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		++pContext->pProxyCommitData->stats.commitBatchIn;
															#line 2055 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pContext->setupTraceBatch();
															#line 2059 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pContext->stage = PRE_RESOLUTION;
															#line 2060 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_1 = CommitBatch::preresolutionProcessing(pContext);
															#line 2060 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<CommitBatchImplActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7810 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CommitBatchImplActor*>(this)->actor_wait_state = 2;
															#line 2060 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CommitBatchImplActor, 1, Void >*>(static_cast<CommitBatchImplActor*>(this)));
															#line 7815 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 2053 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pContext->pProxyCommitData->lastVersionTime = pContext->startTime;
															#line 2054 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		++pContext->pProxyCommitData->stats.commitBatchIn;
															#line 2055 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pContext->setupTraceBatch();
															#line 2059 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pContext->stage = PRE_RESOLUTION;
															#line 2060 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_1 = CommitBatch::preresolutionProcessing(pContext);
															#line 2060 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<CommitBatchImplActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7834 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CommitBatchImplActor*>(this)->actor_wait_state = 2;
															#line 2060 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CommitBatchImplActor, 1, Void >*>(static_cast<CommitBatchImplActor*>(this)));
															#line 7839 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CommitBatchImplActor*>(this)->actor_wait_state > 0) static_cast<CommitBatchImplActor*>(this)->actor_wait_state = 0;
		static_cast<CommitBatchImplActor*>(this)->ActorCallback< CommitBatchImplActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CommitBatchImplActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("commitBatchImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatchImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitBatchImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CommitBatchImplActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("commitBatchImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatchImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitBatchImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CommitBatchImplActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("commitBatchImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatchImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitBatchImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 2061 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (pContext->rejected)
															#line 7923 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 2062 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			pContext->pProxyCommitData->commitBatchesMemBytesCount -= pContext->currentBatchMemBytesCount;
															#line 2063 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (!static_cast<CommitBatchImplActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CommitBatchImplActorState(); static_cast<CommitBatchImplActor*>(this)->destroy(); return 0; }
															#line 7929 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			new (&static_cast<CommitBatchImplActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~CommitBatchImplActorState();
			static_cast<CommitBatchImplActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2067 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pContext->stage = RESOLUTION;
															#line 2068 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_2 = CommitBatch::getResolution(pContext);
															#line 2068 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<CommitBatchImplActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7941 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<CommitBatchImplActor*>(this)->actor_wait_state = 3;
															#line 2068 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CommitBatchImplActor, 2, Void >*>(static_cast<CommitBatchImplActor*>(this)));
															#line 7946 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 2061 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (pContext->rejected)
															#line 7955 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 2062 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			pContext->pProxyCommitData->commitBatchesMemBytesCount -= pContext->currentBatchMemBytesCount;
															#line 2063 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (!static_cast<CommitBatchImplActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CommitBatchImplActorState(); static_cast<CommitBatchImplActor*>(this)->destroy(); return 0; }
															#line 7961 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			new (&static_cast<CommitBatchImplActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~CommitBatchImplActorState();
			static_cast<CommitBatchImplActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2067 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pContext->stage = RESOLUTION;
															#line 2068 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_2 = CommitBatch::getResolution(pContext);
															#line 2068 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<CommitBatchImplActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7973 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<CommitBatchImplActor*>(this)->actor_wait_state = 3;
															#line 2068 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CommitBatchImplActor, 2, Void >*>(static_cast<CommitBatchImplActor*>(this)));
															#line 7978 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CommitBatchImplActor*>(this)->actor_wait_state > 0) static_cast<CommitBatchImplActor*>(this)->actor_wait_state = 0;
		static_cast<CommitBatchImplActor*>(this)->ActorCallback< CommitBatchImplActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CommitBatchImplActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("commitBatchImpl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatchImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitBatchImpl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CommitBatchImplActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("commitBatchImpl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatchImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitBatchImpl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CommitBatchImplActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("commitBatchImpl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatchImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitBatchImpl", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 2072 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pContext->stage = POST_RESOLUTION;
															#line 2073 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_3 = CommitBatch::postResolution(pContext);
															#line 2073 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<CommitBatchImplActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8066 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<CommitBatchImplActor*>(this)->actor_wait_state = 4;
															#line 2073 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CommitBatchImplActor, 3, Void >*>(static_cast<CommitBatchImplActor*>(this)));
															#line 8071 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 2072 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pContext->stage = POST_RESOLUTION;
															#line 2073 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_3 = CommitBatch::postResolution(pContext);
															#line 2073 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<CommitBatchImplActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8084 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<CommitBatchImplActor*>(this)->actor_wait_state = 4;
															#line 2073 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CommitBatchImplActor, 3, Void >*>(static_cast<CommitBatchImplActor*>(this)));
															#line 8089 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CommitBatchImplActor*>(this)->actor_wait_state > 0) static_cast<CommitBatchImplActor*>(this)->actor_wait_state = 0;
		static_cast<CommitBatchImplActor*>(this)->ActorCallback< CommitBatchImplActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CommitBatchImplActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("commitBatchImpl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatchImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitBatchImpl", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CommitBatchImplActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("commitBatchImpl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatchImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitBatchImpl", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CommitBatchImplActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("commitBatchImpl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatchImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitBatchImpl", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 2076 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pContext->stage = TRANSACTION_LOGGING;
															#line 2077 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_4 = CommitBatch::transactionLogging(pContext);
															#line 2077 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<CommitBatchImplActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8177 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont5when1(__when_expr_4.get(), loopDepth); };
		static_cast<CommitBatchImplActor*>(this)->actor_wait_state = 5;
															#line 2077 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< CommitBatchImplActor, 4, Void >*>(static_cast<CommitBatchImplActor*>(this)));
															#line 8182 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 2076 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pContext->stage = TRANSACTION_LOGGING;
															#line 2077 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_4 = CommitBatch::transactionLogging(pContext);
															#line 2077 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<CommitBatchImplActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8195 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont5when1(__when_expr_4.get(), loopDepth); };
		static_cast<CommitBatchImplActor*>(this)->actor_wait_state = 5;
															#line 2077 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< CommitBatchImplActor, 4, Void >*>(static_cast<CommitBatchImplActor*>(this)));
															#line 8200 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<CommitBatchImplActor*>(this)->actor_wait_state > 0) static_cast<CommitBatchImplActor*>(this)->actor_wait_state = 0;
		static_cast<CommitBatchImplActor*>(this)->ActorCallback< CommitBatchImplActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CommitBatchImplActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("commitBatchImpl", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatchImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitBatchImpl", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< CommitBatchImplActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("commitBatchImpl", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatchImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitBatchImpl", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< CommitBatchImplActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("commitBatchImpl", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatchImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitBatchImpl", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 2081 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pContext->stage = REPLY;
															#line 2082 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_5 = CommitBatch::reply(pContext);
															#line 2082 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<CommitBatchImplActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8288 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont6when1(__when_expr_5.get(), loopDepth); };
		static_cast<CommitBatchImplActor*>(this)->actor_wait_state = 6;
															#line 2082 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< CommitBatchImplActor, 5, Void >*>(static_cast<CommitBatchImplActor*>(this)));
															#line 8293 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 2081 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pContext->stage = REPLY;
															#line 2082 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_5 = CommitBatch::reply(pContext);
															#line 2082 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<CommitBatchImplActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8306 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont6when1(__when_expr_5.get(), loopDepth); };
		static_cast<CommitBatchImplActor*>(this)->actor_wait_state = 6;
															#line 2082 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< CommitBatchImplActor, 5, Void >*>(static_cast<CommitBatchImplActor*>(this)));
															#line 8311 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<CommitBatchImplActor*>(this)->actor_wait_state > 0) static_cast<CommitBatchImplActor*>(this)->actor_wait_state = 0;
		static_cast<CommitBatchImplActor*>(this)->ActorCallback< CommitBatchImplActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CommitBatchImplActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("commitBatchImpl", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatchImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitBatchImpl", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< CommitBatchImplActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("commitBatchImpl", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatchImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitBatchImpl", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< CommitBatchImplActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("commitBatchImpl", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatchImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitBatchImpl", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont7(Void const& _,int loopDepth) 
	{
															#line 2084 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pContext->stage = COMPLETE;
															#line 2085 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!static_cast<CommitBatchImplActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CommitBatchImplActorState(); static_cast<CommitBatchImplActor*>(this)->destroy(); return 0; }
															#line 8397 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		new (&static_cast<CommitBatchImplActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CommitBatchImplActorState();
		static_cast<CommitBatchImplActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont7(Void && _,int loopDepth) 
	{
															#line 2084 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pContext->stage = COMPLETE;
															#line 2085 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!static_cast<CommitBatchImplActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CommitBatchImplActorState(); static_cast<CommitBatchImplActor*>(this)->destroy(); return 0; }
															#line 8411 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		new (&static_cast<CommitBatchImplActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CommitBatchImplActorState();
		static_cast<CommitBatchImplActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<CommitBatchImplActor*>(this)->actor_wait_state > 0) static_cast<CommitBatchImplActor*>(this)->actor_wait_state = 0;
		static_cast<CommitBatchImplActor*>(this)->ActorCallback< CommitBatchImplActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CommitBatchImplActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("commitBatchImpl", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatchImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitBatchImpl", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< CommitBatchImplActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("commitBatchImpl", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatchImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitBatchImpl", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< CommitBatchImplActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("commitBatchImpl", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatchImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitBatchImpl", reinterpret_cast<unsigned long>(this), 5);

	}
															#line 2042 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	CommitBatchContext* pContext;
															#line 8496 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via commitBatchImpl()
															#line 2042 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class CommitBatchImplActor final : public Actor<Void>, public ActorCallback< CommitBatchImplActor, 0, Void >, public ActorCallback< CommitBatchImplActor, 1, Void >, public ActorCallback< CommitBatchImplActor, 2, Void >, public ActorCallback< CommitBatchImplActor, 3, Void >, public ActorCallback< CommitBatchImplActor, 4, Void >, public ActorCallback< CommitBatchImplActor, 5, Void >, public FastAllocated<CommitBatchImplActor>, public CommitBatchImplActorState<CommitBatchImplActor> {
															#line 8501 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
	using FastAllocated<CommitBatchImplActor>::operator new;
	using FastAllocated<CommitBatchImplActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17199758251043732992UL, 3670696059662311680UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CommitBatchImplActor, 0, Void >;
friend struct ActorCallback< CommitBatchImplActor, 1, Void >;
friend struct ActorCallback< CommitBatchImplActor, 2, Void >;
friend struct ActorCallback< CommitBatchImplActor, 3, Void >;
friend struct ActorCallback< CommitBatchImplActor, 4, Void >;
friend struct ActorCallback< CommitBatchImplActor, 5, Void >;
															#line 2042 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	CommitBatchImplActor(CommitBatchContext* const& pContext) 
															#line 8523 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   CommitBatchImplActorState<CommitBatchImplActor>(pContext),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("commitBatchImpl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11797433405479390208UL, 8635865864950152704UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatchImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("commitBatchImpl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("commitBatchImpl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CommitBatchImplActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CommitBatchImplActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CommitBatchImplActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< CommitBatchImplActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< CommitBatchImplActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< CommitBatchImplActor, 5, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 2042 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
[[nodiscard]] Future<Void> commitBatchImpl( CommitBatchContext* const& pContext ) {
															#line 2042 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	return Future<Void>(new CommitBatchImplActor(pContext));
															#line 8560 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
}

#line 2087 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"

} // namespace CommitBatch

															#line 8567 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via commitBatch()
															#line 2090 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
template <class CommitBatchActor>
															#line 2090 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class CommitBatchActorState {
															#line 8574 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
															#line 2090 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	CommitBatchActorState(ProxyCommitData* const& pCommitData,std::vector<CommitTransactionRequest>* const& trs,int const& currentBatchMemBytesCount) 
															#line 2090 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
															#line 2090 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		 : pCommitData(pCommitData),
															#line 2090 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   trs(trs),
															#line 2090 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   currentBatchMemBytesCount(currentBatchMemBytesCount),
															#line 2094 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   context(pCommitData, trs, currentBatchMemBytesCount),
															#line 2095 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   commit(CommitBatch::commitBatchImpl(&context))
															#line 8589 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("commitBatch", reinterpret_cast<unsigned long>(this));

	}
	~CommitBatchActorState() 
	{
		fdb_probe_actor_destroy("commitBatch", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 2098 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				StrictFuture<Void> __when_expr_0 = timeoutError(commit, SERVER_KNOBS->COMMIT_PROXY_LIVENESS_TIMEOUT);
															#line 2098 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (static_cast<CommitBatchActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 8607 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<CommitBatchActor*>(this)->actor_wait_state = 1;
															#line 2098 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CommitBatchActor, 0, Void >*>(static_cast<CommitBatchActor*>(this)));
															#line 8612 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CommitBatchActorState();
		static_cast<CommitBatchActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2106 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!static_cast<CommitBatchActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CommitBatchActorState(); static_cast<CommitBatchActor*>(this)->destroy(); return 0; }
															#line 8641 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		new (&static_cast<CommitBatchActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CommitBatchActorState();
		static_cast<CommitBatchActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& err,int loopDepth=0) 
	{
		try {
															#line 2100 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			TraceEvent(SevInfo, "CommitBatchFailed", pCommitData->dbgid) .detail("Stage", context.stage) .detail("ErrorCode", err.code());
															#line 2103 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			return a_body1Catch1(failed_to_progress(), loopDepth);
															#line 8656 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CommitBatchActor*>(this)->actor_wait_state > 0) static_cast<CommitBatchActor*>(this)->actor_wait_state = 0;
		static_cast<CommitBatchActor*>(this)->ActorCallback< CommitBatchActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CommitBatchActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("commitBatch", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitBatch", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CommitBatchActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("commitBatch", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitBatch", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CommitBatchActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("commitBatch", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitBatch", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 2090 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ProxyCommitData* pCommitData;
															#line 2090 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	std::vector<CommitTransactionRequest>* trs;
															#line 2090 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	int currentBatchMemBytesCount;
															#line 2094 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	CommitBatch::CommitBatchContext context;
															#line 2095 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Future<Void> commit;
															#line 8776 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via commitBatch()
															#line 2090 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class CommitBatchActor final : public Actor<Void>, public ActorCallback< CommitBatchActor, 0, Void >, public FastAllocated<CommitBatchActor>, public CommitBatchActorState<CommitBatchActor> {
															#line 8781 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
	using FastAllocated<CommitBatchActor>::operator new;
	using FastAllocated<CommitBatchActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10825135348309578240UL, 511158250520679936UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CommitBatchActor, 0, Void >;
															#line 2090 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	CommitBatchActor(ProxyCommitData* const& pCommitData,std::vector<CommitTransactionRequest>* const& trs,int const& currentBatchMemBytesCount) 
															#line 8798 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   CommitBatchActorState<CommitBatchActor>(pCommitData, trs, currentBatchMemBytesCount),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("commitBatch", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17605101362369555456UL, 10066483790240320512UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("commitBatch");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("commitBatch", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CommitBatchActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2090 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
[[nodiscard]] Future<Void> commitBatch( ProxyCommitData* const& pCommitData, std::vector<CommitTransactionRequest>* const& trs, int const& currentBatchMemBytesCount ) {
															#line 2090 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	return Future<Void>(new CommitBatchActor(pCommitData, trs, currentBatchMemBytesCount));
															#line 8831 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
}

#line 2108 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"

// Add tss mapping data to the reply, if any of the included storage servers have a TSS pair
void maybeAddTssMapping(GetKeyServerLocationsReply& reply,
                        ProxyCommitData* commitData,
                        std::unordered_set<UID>& included,
                        UID ssId) {
	if (!included.contains(ssId)) {
		auto mappingItr = commitData->tssMapping.find(ssId);
		if (mappingItr != commitData->tssMapping.end()) {
			reply.resultsTssMapping.push_back(*mappingItr);
		}
		included.insert(ssId);
	}
}

void addTagMapping(GetKeyServerLocationsReply& reply, ProxyCommitData* commitData) {
	for (const auto& [_, shard] : reply.results) {
		for (auto& ssi : shard) {
			auto iter = commitData->storageCache.find(ssi.id());
			ASSERT_WE_THINK(iter != commitData->storageCache.end());
			reply.resultsTagMapping.emplace_back(ssi.id(), iter->second->tag);
		}
	}
}

															#line 8860 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via doKeyServerLocationRequest()
															#line 2133 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
template <class DoKeyServerLocationRequestActor>
															#line 2133 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class DoKeyServerLocationRequestActorState {
															#line 8867 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
															#line 2133 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	DoKeyServerLocationRequestActorState(GetKeyServerLocationsRequest const& req,ProxyCommitData* const& commitData) 
															#line 2133 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
															#line 2133 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		 : req(req),
															#line 2133 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   commitData(commitData)
															#line 8876 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("doKeyServerLocationRequest", reinterpret_cast<unsigned long>(this));

	}
	~DoKeyServerLocationRequestActorState() 
	{
		fdb_probe_actor_destroy("doKeyServerLocationRequest", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2135 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			getCurrentLineage()->modify(&TransactionLineage::operation) = TransactionLineage::Operation::GetKeyServersLocations;
															#line 2136 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			getCurrentLineage()->modify(&TransactionLineage::txID) = req.spanContext.traceID;
															#line 2138 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			StrictFuture<Void> __when_expr_0 = commitData->validState.getFuture();
															#line 2138 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (static_cast<DoKeyServerLocationRequestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8897 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DoKeyServerLocationRequestActor*>(this)->actor_wait_state = 1;
															#line 2138 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DoKeyServerLocationRequestActor, 0, Void >*>(static_cast<DoKeyServerLocationRequestActor*>(this)));
															#line 8902 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DoKeyServerLocationRequestActorState();
		static_cast<DoKeyServerLocationRequestActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 2140 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(0, TaskPriority::DefaultEndpoint);
															#line 2140 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<DoKeyServerLocationRequestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8927 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<DoKeyServerLocationRequestActor*>(this)->actor_wait_state = 2;
															#line 2140 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DoKeyServerLocationRequestActor, 1, Void >*>(static_cast<DoKeyServerLocationRequestActor*>(this)));
															#line 8932 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 2140 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(0, TaskPriority::DefaultEndpoint);
															#line 2140 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<DoKeyServerLocationRequestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8943 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<DoKeyServerLocationRequestActor*>(this)->actor_wait_state = 2;
															#line 2140 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DoKeyServerLocationRequestActor, 1, Void >*>(static_cast<DoKeyServerLocationRequestActor*>(this)));
															#line 8948 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DoKeyServerLocationRequestActor*>(this)->actor_wait_state > 0) static_cast<DoKeyServerLocationRequestActor*>(this)->actor_wait_state = 0;
		static_cast<DoKeyServerLocationRequestActor*>(this)->ActorCallback< DoKeyServerLocationRequestActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoKeyServerLocationRequestActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doKeyServerLocationRequest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoKeyServerLocationRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doKeyServerLocationRequest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DoKeyServerLocationRequestActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doKeyServerLocationRequest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoKeyServerLocationRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doKeyServerLocationRequest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DoKeyServerLocationRequestActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doKeyServerLocationRequest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoKeyServerLocationRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doKeyServerLocationRequest", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 2142 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		std::unordered_set<UID> tssMappingsIncluded;
															#line 2143 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		GetKeyServerLocationsReply rep;
															#line 2145 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!req.end.present())
															#line 9036 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 2146 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			auto r = req.reverse ? commitData->keyInfo.rangeContainingKeyBefore(req.begin) : commitData->keyInfo.rangeContaining(req.begin);
															#line 2148 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			std::vector<StorageServerInterface> ssis;
															#line 2149 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			ssis.reserve(r.value().src_info.size());
															#line 2150 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			for( auto& it : r.value().src_info ) {
															#line 2151 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				ssis.push_back(it->interf);
															#line 2152 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				maybeAddTssMapping(rep, commitData, tssMappingsIncluded, it->interf.id());
															#line 9050 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
															#line 2154 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			rep.results.emplace_back(r.range(), ssis);
															#line 9054 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
		else
		{
															#line 2155 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (!req.reverse)
															#line 9060 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			{
															#line 2156 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				int count = 0;
															#line 2157 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				for(auto r = commitData->keyInfo.rangeContaining(req.begin);r != commitData->keyInfo.ranges().end() && count < req.limit && r.begin() < req.end.get();++r) {
															#line 2160 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					std::vector<StorageServerInterface> ssis;
															#line 2161 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					ssis.reserve(r.value().src_info.size());
															#line 2162 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					for( auto& it : r.value().src_info ) {
															#line 2163 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						ssis.push_back(it->interf);
															#line 2164 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						maybeAddTssMapping(rep, commitData, tssMappingsIncluded, it->interf.id());
															#line 9076 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
					}
															#line 2166 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					rep.results.emplace_back(r.range(), ssis);
															#line 2167 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					count++;
															#line 9082 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				}
			}
			else
			{
															#line 2170 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				int count = 0;
															#line 2171 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				auto r = commitData->keyInfo.rangeContainingKeyBefore(req.end.get());
															#line 2172 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				for(;count < req.limit && req.begin < r.end();) {
															#line 2173 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					std::vector<StorageServerInterface> ssis;
															#line 2174 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					ssis.reserve(r.value().src_info.size());
															#line 2175 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					for( auto& it : r.value().src_info ) {
															#line 2176 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						ssis.push_back(it->interf);
															#line 2177 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						maybeAddTssMapping(rep, commitData, tssMappingsIncluded, it->interf.id());
															#line 9103 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
					}
															#line 2179 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					rep.results.emplace_back(r.range(), ssis);
															#line 2180 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					if (r == commitData->keyInfo.ranges().begin())
															#line 9109 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
					{
						break;
					}
															#line 2183 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					count++;
															#line 2184 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					--r;
															#line 9117 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				}
			}
		}
															#line 2187 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		addTagMapping(rep, commitData);
															#line 2188 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		req.reply.send(rep);
															#line 2189 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		++commitData->stats.keyServerLocationOut;
															#line 2190 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!static_cast<DoKeyServerLocationRequestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DoKeyServerLocationRequestActorState(); static_cast<DoKeyServerLocationRequestActor*>(this)->destroy(); return 0; }
															#line 9129 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		new (&static_cast<DoKeyServerLocationRequestActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DoKeyServerLocationRequestActorState();
		static_cast<DoKeyServerLocationRequestActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 2142 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		std::unordered_set<UID> tssMappingsIncluded;
															#line 2143 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		GetKeyServerLocationsReply rep;
															#line 2145 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!req.end.present())
															#line 9145 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 2146 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			auto r = req.reverse ? commitData->keyInfo.rangeContainingKeyBefore(req.begin) : commitData->keyInfo.rangeContaining(req.begin);
															#line 2148 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			std::vector<StorageServerInterface> ssis;
															#line 2149 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			ssis.reserve(r.value().src_info.size());
															#line 2150 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			for( auto& it : r.value().src_info ) {
															#line 2151 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				ssis.push_back(it->interf);
															#line 2152 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				maybeAddTssMapping(rep, commitData, tssMappingsIncluded, it->interf.id());
															#line 9159 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
															#line 2154 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			rep.results.emplace_back(r.range(), ssis);
															#line 9163 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
		else
		{
															#line 2155 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (!req.reverse)
															#line 9169 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			{
															#line 2156 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				int count = 0;
															#line 2157 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				for(auto r = commitData->keyInfo.rangeContaining(req.begin);r != commitData->keyInfo.ranges().end() && count < req.limit && r.begin() < req.end.get();++r) {
															#line 2160 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					std::vector<StorageServerInterface> ssis;
															#line 2161 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					ssis.reserve(r.value().src_info.size());
															#line 2162 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					for( auto& it : r.value().src_info ) {
															#line 2163 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						ssis.push_back(it->interf);
															#line 2164 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						maybeAddTssMapping(rep, commitData, tssMappingsIncluded, it->interf.id());
															#line 9185 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
					}
															#line 2166 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					rep.results.emplace_back(r.range(), ssis);
															#line 2167 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					count++;
															#line 9191 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				}
			}
			else
			{
															#line 2170 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				int count = 0;
															#line 2171 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				auto r = commitData->keyInfo.rangeContainingKeyBefore(req.end.get());
															#line 2172 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				for(;count < req.limit && req.begin < r.end();) {
															#line 2173 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					std::vector<StorageServerInterface> ssis;
															#line 2174 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					ssis.reserve(r.value().src_info.size());
															#line 2175 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					for( auto& it : r.value().src_info ) {
															#line 2176 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						ssis.push_back(it->interf);
															#line 2177 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						maybeAddTssMapping(rep, commitData, tssMappingsIncluded, it->interf.id());
															#line 9212 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
					}
															#line 2179 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					rep.results.emplace_back(r.range(), ssis);
															#line 2180 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					if (r == commitData->keyInfo.ranges().begin())
															#line 9218 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
					{
						break;
					}
															#line 2183 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					count++;
															#line 2184 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					--r;
															#line 9226 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				}
			}
		}
															#line 2187 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		addTagMapping(rep, commitData);
															#line 2188 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		req.reply.send(rep);
															#line 2189 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		++commitData->stats.keyServerLocationOut;
															#line 2190 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!static_cast<DoKeyServerLocationRequestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DoKeyServerLocationRequestActorState(); static_cast<DoKeyServerLocationRequestActor*>(this)->destroy(); return 0; }
															#line 9238 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		new (&static_cast<DoKeyServerLocationRequestActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DoKeyServerLocationRequestActorState();
		static_cast<DoKeyServerLocationRequestActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DoKeyServerLocationRequestActor*>(this)->actor_wait_state > 0) static_cast<DoKeyServerLocationRequestActor*>(this)->actor_wait_state = 0;
		static_cast<DoKeyServerLocationRequestActor*>(this)->ActorCallback< DoKeyServerLocationRequestActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoKeyServerLocationRequestActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doKeyServerLocationRequest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoKeyServerLocationRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doKeyServerLocationRequest", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DoKeyServerLocationRequestActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doKeyServerLocationRequest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoKeyServerLocationRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doKeyServerLocationRequest", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DoKeyServerLocationRequestActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doKeyServerLocationRequest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoKeyServerLocationRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doKeyServerLocationRequest", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 2133 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	GetKeyServerLocationsRequest req;
															#line 2133 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ProxyCommitData* commitData;
															#line 9325 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via doKeyServerLocationRequest()
															#line 2133 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class DoKeyServerLocationRequestActor final : public Actor<Void>, public ActorCallback< DoKeyServerLocationRequestActor, 0, Void >, public ActorCallback< DoKeyServerLocationRequestActor, 1, Void >, public FastAllocated<DoKeyServerLocationRequestActor>, public DoKeyServerLocationRequestActorState<DoKeyServerLocationRequestActor> {
															#line 9330 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
	using FastAllocated<DoKeyServerLocationRequestActor>::operator new;
	using FastAllocated<DoKeyServerLocationRequestActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8731565573110631424UL, 8630299731135419648UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DoKeyServerLocationRequestActor, 0, Void >;
friend struct ActorCallback< DoKeyServerLocationRequestActor, 1, Void >;
															#line 2133 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	DoKeyServerLocationRequestActor(GetKeyServerLocationsRequest const& req,ProxyCommitData* const& commitData) 
															#line 9348 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   DoKeyServerLocationRequestActorState<DoKeyServerLocationRequestActor>(req, commitData),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("doKeyServerLocationRequest", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4295041835434509824UL, 5382091244808472320UL);
		ActorExecutionContextHelper __helper(static_cast<DoKeyServerLocationRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("doKeyServerLocationRequest");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("doKeyServerLocationRequest", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DoKeyServerLocationRequestActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DoKeyServerLocationRequestActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2133 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
[[nodiscard]] static Future<Void> doKeyServerLocationRequest( GetKeyServerLocationsRequest const& req, ProxyCommitData* const& commitData ) {
															#line 2133 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	return Future<Void>(new DoKeyServerLocationRequestActor(req, commitData));
															#line 9382 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
}

#line 2192 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"

															#line 9387 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via readRequestServer()
															#line 2193 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
template <class ReadRequestServerActor>
															#line 2193 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class ReadRequestServerActorState {
															#line 9394 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
															#line 2193 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ReadRequestServerActorState(CommitProxyInterface const& proxy,PromiseStream<Future<Void>> const& addActor,ProxyCommitData* const& commitData) 
															#line 2193 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
															#line 2193 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		 : proxy(proxy),
															#line 2193 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   addActor(addActor),
															#line 2193 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   commitData(commitData)
															#line 9405 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("readRequestServer", reinterpret_cast<unsigned long>(this));

	}
	~ReadRequestServerActorState() 
	{
		fdb_probe_actor_destroy("readRequestServer", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2196 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			;
															#line 9420 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ReadRequestServerActorState();
		static_cast<ReadRequestServerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 2197 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		auto __when_expr_0 = proxy.getKeyServersLocations.getFuture();
															#line 9450 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		static_assert(std::is_same<decltype(__when_expr_0), FutureStream<GetKeyServerLocationsRequest>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<GetKeyServerLocationsRequest>>::value, "invalid type");
															#line 2197 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<ReadRequestServerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 9454 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
		static_cast<ReadRequestServerActor*>(this)->actor_wait_state = 1;
															#line 2197 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< ReadRequestServerActor, 0, GetKeyServerLocationsRequest >*>(static_cast<ReadRequestServerActor*>(this)));
															#line 9459 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(GetKeyServerLocationsRequest const& req,int loopDepth) 
	{
															#line 2199 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (req.limit != CLIENT_KNOBS->STORAGE_METRICS_SHARD_LIMIT && (commitData->stats.keyServerLocationIn.getValue() - commitData->stats.keyServerLocationOut.getValue() > SERVER_KNOBS->KEY_LOCATION_MAX_QUEUE_SIZE || (g_network->isSimulated() && BUGGIFY_WITH_PROB(0.001))))
															#line 9468 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 2203 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			++commitData->stats.keyServerLocationErrors;
															#line 2204 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			req.reply.sendError(commit_proxy_memory_limit_exceeded());
															#line 2205 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			TraceEvent(SevWarnAlways, "ProxyLocationRequestThresholdExceeded").suppressFor(60);
															#line 9476 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
		else
		{
															#line 2207 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			++commitData->stats.keyServerLocationIn;
															#line 2208 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			addActor.send(doKeyServerLocationRequest(req, commitData));
															#line 9484 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(GetKeyServerLocationsRequest && req,int loopDepth) 
	{
															#line 2199 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (req.limit != CLIENT_KNOBS->STORAGE_METRICS_SHARD_LIMIT && (commitData->stats.keyServerLocationIn.getValue() - commitData->stats.keyServerLocationOut.getValue() > SERVER_KNOBS->KEY_LOCATION_MAX_QUEUE_SIZE || (g_network->isSimulated() && BUGGIFY_WITH_PROB(0.001))))
															#line 9494 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 2203 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			++commitData->stats.keyServerLocationErrors;
															#line 2204 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			req.reply.sendError(commit_proxy_memory_limit_exceeded());
															#line 2205 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			TraceEvent(SevWarnAlways, "ProxyLocationRequestThresholdExceeded").suppressFor(60);
															#line 9502 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
		else
		{
															#line 2207 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			++commitData->stats.keyServerLocationIn;
															#line 2208 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			addActor.send(doKeyServerLocationRequest(req, commitData));
															#line 9510 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(GetKeyServerLocationsRequest const& req,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(req, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(GetKeyServerLocationsRequest && req,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(req), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ReadRequestServerActor*>(this)->actor_wait_state > 0) static_cast<ReadRequestServerActor*>(this)->actor_wait_state = 0;
		static_cast<ReadRequestServerActor*>(this)->ActorSingleCallback< ReadRequestServerActor, 0, GetKeyServerLocationsRequest >::remove();

	}
	void a_callback_fire(ActorSingleCallback< ReadRequestServerActor, 0, GetKeyServerLocationsRequest >*,GetKeyServerLocationsRequest const& value) 
	{
		fdb_probe_actor_enter("readRequestServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadRequestServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readRequestServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< ReadRequestServerActor, 0, GetKeyServerLocationsRequest >*,GetKeyServerLocationsRequest && value) 
	{
		fdb_probe_actor_enter("readRequestServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadRequestServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readRequestServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< ReadRequestServerActor, 0, GetKeyServerLocationsRequest >*,Error err) 
	{
		fdb_probe_actor_enter("readRequestServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadRequestServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readRequestServer", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 2193 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	CommitProxyInterface proxy;
															#line 2193 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	PromiseStream<Future<Void>> addActor;
															#line 2193 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ProxyCommitData* commitData;
															#line 9597 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via readRequestServer()
															#line 2193 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class ReadRequestServerActor final : public Actor<Void>, public ActorSingleCallback< ReadRequestServerActor, 0, GetKeyServerLocationsRequest >, public FastAllocated<ReadRequestServerActor>, public ReadRequestServerActorState<ReadRequestServerActor> {
															#line 9602 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
	using FastAllocated<ReadRequestServerActor>::operator new;
	using FastAllocated<ReadRequestServerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13551662828718066432UL, 9387445746176958720UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< ReadRequestServerActor, 0, GetKeyServerLocationsRequest >;
															#line 2193 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ReadRequestServerActor(CommitProxyInterface const& proxy,PromiseStream<Future<Void>> const& addActor,ProxyCommitData* const& commitData) 
															#line 9619 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   ReadRequestServerActorState<ReadRequestServerActor>(proxy, addActor, commitData),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("readRequestServer", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7015573509160306432UL, 3123064095005483520UL);
		ActorExecutionContextHelper __helper(static_cast<ReadRequestServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("readRequestServer");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("readRequestServer", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< ReadRequestServerActor, 0, GetKeyServerLocationsRequest >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2193 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
[[nodiscard]] static Future<Void> readRequestServer( CommitProxyInterface const& proxy, PromiseStream<Future<Void>> const& addActor, ProxyCommitData* const& commitData ) {
															#line 2193 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	return Future<Void>(new ReadRequestServerActor(proxy, addActor, commitData));
															#line 9652 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
}

#line 2212 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"

															#line 9657 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via rejoinServer()
															#line 2213 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
template <class RejoinServerActor>
															#line 2213 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class RejoinServerActorState {
															#line 9664 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
															#line 2213 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	RejoinServerActorState(CommitProxyInterface const& proxy,ProxyCommitData* const& commitData) 
															#line 2213 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
															#line 2213 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		 : proxy(proxy),
															#line 2213 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   commitData(commitData)
															#line 9673 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("rejoinServer", reinterpret_cast<unsigned long>(this));

	}
	~RejoinServerActorState() 
	{
		fdb_probe_actor_destroy("rejoinServer", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2215 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			StrictFuture<Void> __when_expr_0 = commitData->validState.getFuture();
															#line 2215 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (static_cast<RejoinServerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9690 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RejoinServerActor*>(this)->actor_wait_state = 1;
															#line 2215 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RejoinServerActor, 0, Void >*>(static_cast<RejoinServerActor*>(this)));
															#line 9695 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RejoinServerActorState();
		static_cast<RejoinServerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 2217 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		TraceEvent("ProxyReadyForReads", proxy.id()).log();
															#line 2219 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		;
															#line 9720 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 2217 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		TraceEvent("ProxyReadyForReads", proxy.id()).log();
															#line 2219 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		;
															#line 9731 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RejoinServerActor*>(this)->actor_wait_state > 0) static_cast<RejoinServerActor*>(this)->actor_wait_state = 0;
		static_cast<RejoinServerActor*>(this)->ActorCallback< RejoinServerActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RejoinServerActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("rejoinServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RejoinServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rejoinServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RejoinServerActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("rejoinServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RejoinServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rejoinServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RejoinServerActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("rejoinServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RejoinServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rejoinServer", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 2220 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		auto __when_expr_1 = proxy.getStorageServerRejoinInfo.getFuture();
															#line 9822 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		static_assert(std::is_same<decltype(__when_expr_1), FutureStream<GetStorageServerRejoinInfoRequest>>::value || std::is_same<decltype(__when_expr_1), ThreadFutureStream<GetStorageServerRejoinInfoRequest>>::value, "invalid type");
															#line 2220 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<RejoinServerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 9826 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.pop(), loopDepth); };
		static_cast<RejoinServerActor*>(this)->actor_wait_state = 2;
															#line 2220 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorSingleCallback< RejoinServerActor, 1, GetStorageServerRejoinInfoRequest >*>(static_cast<RejoinServerActor*>(this)));
															#line 9831 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(GetStorageServerRejoinInfoRequest const& req,int loopDepth) 
	{
															#line 2221 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (commitData->txnStateStore->readValue(serverListKeyFor(req.id)).get().present())
															#line 9840 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 2222 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			GetStorageServerRejoinInfoReply rep;
															#line 2223 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			rep.version = commitData->version.get();
															#line 2224 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			rep.tag = decodeServerTagValue(commitData->txnStateStore->readValue(serverTagKeyFor(req.id)).get().get());
															#line 2225 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			RangeResult history = commitData->txnStateStore->readRange(serverTagHistoryRangeFor(req.id)).get();
															#line 2226 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			for(int i = history.size() - 1;i >= 0;i--) {
															#line 2227 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				rep.history.push_back( std::make_pair(decodeServerTagHistoryKey(history[i].key), decodeServerTagValue(history[i].value)));
															#line 9854 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
															#line 2230 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			auto localityKey = commitData->txnStateStore->readValue(tagLocalityListKeyFor(req.dcId)).get();
															#line 2231 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			rep.newLocality = false;
															#line 2232 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (localityKey.present())
															#line 9862 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			{
															#line 2233 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				int8_t locality = decodeTagLocalityListValue(localityKey.get());
															#line 2234 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (locality != rep.tag.locality)
															#line 9868 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				{
															#line 2235 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					TraceEvent(SevWarnAlways, "SSRejoinedWithChangedLocality") .detail("Tag", rep.tag.toString()) .detail("DcId", req.dcId) .detail("NewLocality", locality);
															#line 9872 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				}
				else
				{
															#line 2239 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					if (locality != rep.tag.locality)
															#line 9878 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
					{
															#line 2240 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						uint16_t tagId = 0;
															#line 2241 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						std::vector<uint16_t> usedTags;
															#line 2242 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						auto tagKeys = commitData->txnStateStore->readRange(serverTagKeys).get();
															#line 2243 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						for( auto& kv : tagKeys ) {
															#line 2244 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
							Tag t = decodeServerTagValue(kv.value);
															#line 2245 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
							if (t.locality == locality)
															#line 9892 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
							{
															#line 2246 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
								usedTags.push_back(t.id);
															#line 9896 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
							}
						}
															#line 2249 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						auto historyKeys = commitData->txnStateStore->readRange(serverTagHistoryKeys).get();
															#line 2250 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						for( auto& kv : historyKeys ) {
															#line 2251 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
							Tag t = decodeServerTagValue(kv.value);
															#line 2252 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
							if (t.locality == locality)
															#line 9907 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
							{
															#line 2253 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
								usedTags.push_back(t.id);
															#line 9911 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
							}
						}
															#line 2256 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						std::sort(usedTags.begin(), usedTags.end());
															#line 2258 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						int usedIdx = 0;
															#line 2259 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						for(;usedTags.size() > 0 && tagId <= usedTags.end()[-1];tagId++) {
															#line 2260 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
							if (tagId < usedTags[usedIdx])
															#line 9922 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
							{
								break;
							}
							else
							{
															#line 2263 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
								usedIdx++;
															#line 9930 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
							}
						}
															#line 2266 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						rep.newTag = Tag(locality, tagId);
															#line 9935 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
					}
				}
			}
			else
			{
															#line 2269 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				ASSERT_WE_THINK(rep.tag.locality != tagLocalityUpgraded);
															#line 2270 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				TraceEvent(SevWarnAlways, "SSRejoinedWithUnknownLocality") .detail("Tag", rep.tag.toString()) .detail("DcId", req.dcId);
															#line 9945 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
															#line 2274 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			req.reply.send(rep);
															#line 9949 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
		else
		{
															#line 2276 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			req.reply.sendError(worker_removed());
															#line 9955 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(GetStorageServerRejoinInfoRequest && req,int loopDepth) 
	{
															#line 2221 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (commitData->txnStateStore->readValue(serverListKeyFor(req.id)).get().present())
															#line 9965 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 2222 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			GetStorageServerRejoinInfoReply rep;
															#line 2223 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			rep.version = commitData->version.get();
															#line 2224 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			rep.tag = decodeServerTagValue(commitData->txnStateStore->readValue(serverTagKeyFor(req.id)).get().get());
															#line 2225 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			RangeResult history = commitData->txnStateStore->readRange(serverTagHistoryRangeFor(req.id)).get();
															#line 2226 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			for(int i = history.size() - 1;i >= 0;i--) {
															#line 2227 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				rep.history.push_back( std::make_pair(decodeServerTagHistoryKey(history[i].key), decodeServerTagValue(history[i].value)));
															#line 9979 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
															#line 2230 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			auto localityKey = commitData->txnStateStore->readValue(tagLocalityListKeyFor(req.dcId)).get();
															#line 2231 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			rep.newLocality = false;
															#line 2232 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (localityKey.present())
															#line 9987 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			{
															#line 2233 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				int8_t locality = decodeTagLocalityListValue(localityKey.get());
															#line 2234 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (locality != rep.tag.locality)
															#line 9993 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				{
															#line 2235 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					TraceEvent(SevWarnAlways, "SSRejoinedWithChangedLocality") .detail("Tag", rep.tag.toString()) .detail("DcId", req.dcId) .detail("NewLocality", locality);
															#line 9997 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				}
				else
				{
															#line 2239 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					if (locality != rep.tag.locality)
															#line 10003 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
					{
															#line 2240 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						uint16_t tagId = 0;
															#line 2241 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						std::vector<uint16_t> usedTags;
															#line 2242 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						auto tagKeys = commitData->txnStateStore->readRange(serverTagKeys).get();
															#line 2243 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						for( auto& kv : tagKeys ) {
															#line 2244 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
							Tag t = decodeServerTagValue(kv.value);
															#line 2245 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
							if (t.locality == locality)
															#line 10017 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
							{
															#line 2246 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
								usedTags.push_back(t.id);
															#line 10021 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
							}
						}
															#line 2249 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						auto historyKeys = commitData->txnStateStore->readRange(serverTagHistoryKeys).get();
															#line 2250 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						for( auto& kv : historyKeys ) {
															#line 2251 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
							Tag t = decodeServerTagValue(kv.value);
															#line 2252 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
							if (t.locality == locality)
															#line 10032 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
							{
															#line 2253 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
								usedTags.push_back(t.id);
															#line 10036 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
							}
						}
															#line 2256 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						std::sort(usedTags.begin(), usedTags.end());
															#line 2258 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						int usedIdx = 0;
															#line 2259 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						for(;usedTags.size() > 0 && tagId <= usedTags.end()[-1];tagId++) {
															#line 2260 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
							if (tagId < usedTags[usedIdx])
															#line 10047 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
							{
								break;
							}
							else
							{
															#line 2263 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
								usedIdx++;
															#line 10055 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
							}
						}
															#line 2266 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						rep.newTag = Tag(locality, tagId);
															#line 10060 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
					}
				}
			}
			else
			{
															#line 2269 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				ASSERT_WE_THINK(rep.tag.locality != tagLocalityUpgraded);
															#line 2270 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				TraceEvent(SevWarnAlways, "SSRejoinedWithUnknownLocality") .detail("Tag", rep.tag.toString()) .detail("DcId", req.dcId);
															#line 10070 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
															#line 2274 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			req.reply.send(rep);
															#line 10074 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
		else
		{
															#line 2276 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			req.reply.sendError(worker_removed());
															#line 10080 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(GetStorageServerRejoinInfoRequest const& req,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(req, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(GetStorageServerRejoinInfoRequest && req,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(std::move(req), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RejoinServerActor*>(this)->actor_wait_state > 0) static_cast<RejoinServerActor*>(this)->actor_wait_state = 0;
		static_cast<RejoinServerActor*>(this)->ActorSingleCallback< RejoinServerActor, 1, GetStorageServerRejoinInfoRequest >::remove();

	}
	void a_callback_fire(ActorSingleCallback< RejoinServerActor, 1, GetStorageServerRejoinInfoRequest >*,GetStorageServerRejoinInfoRequest const& value) 
	{
		fdb_probe_actor_enter("rejoinServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RejoinServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rejoinServer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorSingleCallback< RejoinServerActor, 1, GetStorageServerRejoinInfoRequest >*,GetStorageServerRejoinInfoRequest && value) 
	{
		fdb_probe_actor_enter("rejoinServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RejoinServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rejoinServer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorSingleCallback< RejoinServerActor, 1, GetStorageServerRejoinInfoRequest >*,Error err) 
	{
		fdb_probe_actor_enter("rejoinServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RejoinServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rejoinServer", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 2213 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	CommitProxyInterface proxy;
															#line 2213 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ProxyCommitData* commitData;
															#line 10165 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via rejoinServer()
															#line 2213 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class RejoinServerActor final : public Actor<Void>, public ActorCallback< RejoinServerActor, 0, Void >, public ActorSingleCallback< RejoinServerActor, 1, GetStorageServerRejoinInfoRequest >, public FastAllocated<RejoinServerActor>, public RejoinServerActorState<RejoinServerActor> {
															#line 10170 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
	using FastAllocated<RejoinServerActor>::operator new;
	using FastAllocated<RejoinServerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13436962092914343936UL, 7353353091991650304UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RejoinServerActor, 0, Void >;
friend struct ActorSingleCallback< RejoinServerActor, 1, GetStorageServerRejoinInfoRequest >;
															#line 2213 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	RejoinServerActor(CommitProxyInterface const& proxy,ProxyCommitData* const& commitData) 
															#line 10188 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   RejoinServerActorState<RejoinServerActor>(proxy, commitData),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("rejoinServer", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6499651042657228288UL, 13021739501090474752UL);
		ActorExecutionContextHelper __helper(static_cast<RejoinServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("rejoinServer");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("rejoinServer", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RejoinServerActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorSingleCallback< RejoinServerActor, 1, GetStorageServerRejoinInfoRequest >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2213 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
[[nodiscard]] static Future<Void> rejoinServer( CommitProxyInterface const& proxy, ProxyCommitData* const& commitData ) {
															#line 2213 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	return Future<Void>(new RejoinServerActor(proxy, commitData));
															#line 10222 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
}

#line 2280 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"

															#line 10227 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via ddMetricsRequestServer()
															#line 2281 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
template <class DdMetricsRequestServerActor>
															#line 2281 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class DdMetricsRequestServerActorState {
															#line 10234 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
															#line 2281 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	DdMetricsRequestServerActorState(CommitProxyInterface const& proxy,Reference<AsyncVar<ServerDBInfo> const> const& db) 
															#line 2281 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
															#line 2281 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		 : proxy(proxy),
															#line 2281 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   db(db)
															#line 10243 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("ddMetricsRequestServer", reinterpret_cast<unsigned long>(this));

	}
	~DdMetricsRequestServerActorState() 
	{
		fdb_probe_actor_destroy("ddMetricsRequestServer", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2282 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			;
															#line 10258 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DdMetricsRequestServerActorState();
		static_cast<DdMetricsRequestServerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 2284 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		auto __when_expr_0 = proxy.getDDMetrics.getFuture();
															#line 10288 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		static_assert(std::is_same<decltype(__when_expr_0), FutureStream<GetDDMetricsRequest>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<GetDDMetricsRequest>>::value, "invalid type");
															#line 2283 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<DdMetricsRequestServerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 10292 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
		static_cast<DdMetricsRequestServerActor*>(this)->actor_wait_state = 1;
															#line 2284 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< DdMetricsRequestServerActor, 0, GetDDMetricsRequest >*>(static_cast<DdMetricsRequestServerActor*>(this)));
															#line 10297 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(GetDDMetricsRequest const& __req,int loopDepth) 
	{
															#line 2284 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		req = __req;
															#line 2285 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!db->get().distributor.present())
															#line 10314 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 2286 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			req.reply.sendError(dd_not_found());
															#line 10318 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			return a_body1loopHead1(loopDepth); // continue
		}
															#line 2289 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<ErrorOr<GetDataDistributorMetricsReply>> __when_expr_1 = errorOr(db->get().distributor.get().dataDistributorMetrics.getReply( GetDataDistributorMetricsRequest(req.keys, req.shardLimit)));
															#line 2289 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<DdMetricsRequestServerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 10325 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1when1(__when_expr_1.get(), loopDepth); };
		static_cast<DdMetricsRequestServerActor*>(this)->actor_wait_state = 2;
															#line 2289 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DdMetricsRequestServerActor, 1, ErrorOr<GetDataDistributorMetricsReply> >*>(static_cast<DdMetricsRequestServerActor*>(this)));
															#line 10330 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(GetDDMetricsRequest && __req,int loopDepth) 
	{
		req = std::move(__req);
															#line 2285 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!db->get().distributor.present())
															#line 10340 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 2286 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			req.reply.sendError(dd_not_found());
															#line 10344 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			return a_body1loopHead1(loopDepth); // continue
		}
															#line 2289 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<ErrorOr<GetDataDistributorMetricsReply>> __when_expr_1 = errorOr(db->get().distributor.get().dataDistributorMetrics.getReply( GetDataDistributorMetricsRequest(req.keys, req.shardLimit)));
															#line 2289 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<DdMetricsRequestServerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 10351 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1when1(__when_expr_1.get(), loopDepth); };
		static_cast<DdMetricsRequestServerActor*>(this)->actor_wait_state = 2;
															#line 2289 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DdMetricsRequestServerActor, 1, ErrorOr<GetDataDistributorMetricsReply> >*>(static_cast<DdMetricsRequestServerActor*>(this)));
															#line 10356 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DdMetricsRequestServerActor*>(this)->actor_wait_state > 0) static_cast<DdMetricsRequestServerActor*>(this)->actor_wait_state = 0;
		static_cast<DdMetricsRequestServerActor*>(this)->ActorSingleCallback< DdMetricsRequestServerActor, 0, GetDDMetricsRequest >::remove();

	}
	int a_body1loopBody1when1cont1(ErrorOr<GetDataDistributorMetricsReply> const& reply,int loopDepth) 
	{
															#line 2292 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (reply.isError())
															#line 10371 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 2293 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			req.reply.sendError(reply.getError());
															#line 10375 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
		else
		{
															#line 2295 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			GetDDMetricsReply newReply;
															#line 2296 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			newReply.storageMetricsList = reply.get().storageMetricsList;
															#line 2297 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			req.reply.send(newReply);
															#line 10385 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1cont1(ErrorOr<GetDataDistributorMetricsReply> && reply,int loopDepth) 
	{
															#line 2292 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (reply.isError())
															#line 10395 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 2293 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			req.reply.sendError(reply.getError());
															#line 10399 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
		else
		{
															#line 2295 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			GetDDMetricsReply newReply;
															#line 2296 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			newReply.storageMetricsList = reply.get().storageMetricsList;
															#line 2297 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			req.reply.send(newReply);
															#line 10409 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1when1(ErrorOr<GetDataDistributorMetricsReply> const& reply,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when1cont1(reply, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1when1(ErrorOr<GetDataDistributorMetricsReply> && reply,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when1cont1(std::move(reply), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DdMetricsRequestServerActor*>(this)->actor_wait_state > 0) static_cast<DdMetricsRequestServerActor*>(this)->actor_wait_state = 0;
		static_cast<DdMetricsRequestServerActor*>(this)->ActorCallback< DdMetricsRequestServerActor, 1, ErrorOr<GetDataDistributorMetricsReply> >::remove();

	}
	void a_callback_fire(ActorCallback< DdMetricsRequestServerActor, 1, ErrorOr<GetDataDistributorMetricsReply> >*,ErrorOr<GetDataDistributorMetricsReply> const& value) 
	{
		fdb_probe_actor_enter("ddMetricsRequestServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DdMetricsRequestServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ddMetricsRequestServer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DdMetricsRequestServerActor, 1, ErrorOr<GetDataDistributorMetricsReply> >*,ErrorOr<GetDataDistributorMetricsReply> && value) 
	{
		fdb_probe_actor_enter("ddMetricsRequestServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DdMetricsRequestServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ddMetricsRequestServer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DdMetricsRequestServerActor, 1, ErrorOr<GetDataDistributorMetricsReply> >*,Error err) 
	{
		fdb_probe_actor_enter("ddMetricsRequestServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DdMetricsRequestServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ddMetricsRequestServer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorSingleCallback< DdMetricsRequestServerActor, 0, GetDDMetricsRequest >*,GetDDMetricsRequest const& value) 
	{
		fdb_probe_actor_enter("ddMetricsRequestServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DdMetricsRequestServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ddMetricsRequestServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< DdMetricsRequestServerActor, 0, GetDDMetricsRequest >*,GetDDMetricsRequest && value) 
	{
		fdb_probe_actor_enter("ddMetricsRequestServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DdMetricsRequestServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ddMetricsRequestServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< DdMetricsRequestServerActor, 0, GetDDMetricsRequest >*,Error err) 
	{
		fdb_probe_actor_enter("ddMetricsRequestServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DdMetricsRequestServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ddMetricsRequestServer", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 2281 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	CommitProxyInterface proxy;
															#line 2281 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> db;
															#line 2284 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	GetDDMetricsRequest req;
															#line 10553 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via ddMetricsRequestServer()
															#line 2281 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class DdMetricsRequestServerActor final : public Actor<Void>, public ActorSingleCallback< DdMetricsRequestServerActor, 0, GetDDMetricsRequest >, public ActorCallback< DdMetricsRequestServerActor, 1, ErrorOr<GetDataDistributorMetricsReply> >, public FastAllocated<DdMetricsRequestServerActor>, public DdMetricsRequestServerActorState<DdMetricsRequestServerActor> {
															#line 10558 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
	using FastAllocated<DdMetricsRequestServerActor>::operator new;
	using FastAllocated<DdMetricsRequestServerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15622490732626985216UL, 14027546237769607680UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< DdMetricsRequestServerActor, 0, GetDDMetricsRequest >;
friend struct ActorCallback< DdMetricsRequestServerActor, 1, ErrorOr<GetDataDistributorMetricsReply> >;
															#line 2281 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	DdMetricsRequestServerActor(CommitProxyInterface const& proxy,Reference<AsyncVar<ServerDBInfo> const> const& db) 
															#line 10576 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   DdMetricsRequestServerActorState<DdMetricsRequestServerActor>(proxy, db),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("ddMetricsRequestServer", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2722599940322443264UL, 14232635602210436608UL);
		ActorExecutionContextHelper __helper(static_cast<DdMetricsRequestServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("ddMetricsRequestServer");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("ddMetricsRequestServer", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< DdMetricsRequestServerActor, 0, GetDDMetricsRequest >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DdMetricsRequestServerActor, 1, ErrorOr<GetDataDistributorMetricsReply> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2281 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
[[nodiscard]] Future<Void> ddMetricsRequestServer( CommitProxyInterface const& proxy, Reference<AsyncVar<ServerDBInfo> const> const& db ) {
															#line 2281 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	return Future<Void>(new DdMetricsRequestServerActor(proxy, db));
															#line 10610 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
}

#line 2303 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"

															#line 10615 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via monitorRemoteCommitted()
															#line 2304 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
template <class MonitorRemoteCommittedActor>
															#line 2304 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class MonitorRemoteCommittedActorState {
															#line 10622 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
															#line 2304 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	MonitorRemoteCommittedActorState(ProxyCommitData* const& self) 
															#line 2304 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
															#line 2304 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		 : self(self)
															#line 10629 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("monitorRemoteCommitted", reinterpret_cast<unsigned long>(this));

	}
	~MonitorRemoteCommittedActorState() 
	{
		fdb_probe_actor_destroy("monitorRemoteCommitted", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2305 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			;
															#line 10644 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MonitorRemoteCommittedActorState();
		static_cast<MonitorRemoteCommittedActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 2306 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delay(0);
															#line 2306 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<MonitorRemoteCommittedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 10676 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<MonitorRemoteCommittedActor*>(this)->actor_wait_state = 1;
															#line 2306 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MonitorRemoteCommittedActor, 0, Void >*>(static_cast<MonitorRemoteCommittedActor*>(this)));
															#line 10681 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 2307 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		remoteLogs = Optional<std::vector<OptionalInterface<TLogInterface>>>();
															#line 2308 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (self->db->get().recoveryState >= RecoveryState::ALL_LOGS_RECRUITED)
															#line 10692 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 2309 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			for( auto& logSet : self->db->get().logSystemConfig.tLogs ) {
															#line 2310 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (!logSet.isLocal)
															#line 10698 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				{
															#line 2311 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					remoteLogs = logSet.tLogs;
															#line 2312 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					for( auto& tLog : logSet.tLogs ) {
															#line 2313 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						if (!tLog.present())
															#line 10706 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
						{
															#line 2314 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
							remoteLogs = Optional<std::vector<OptionalInterface<TLogInterface>>>();
															#line 10710 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
							break;
						}
					}
					break;
				}
			}
		}
															#line 2323 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!remoteLogs.present())
															#line 10720 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 2324 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			StrictFuture<Void> __when_expr_1 = self->db->onChange();
															#line 2324 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (static_cast<MonitorRemoteCommittedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 10726 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<MonitorRemoteCommittedActor*>(this)->actor_wait_state = 2;
															#line 2324 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MonitorRemoteCommittedActor, 1, Void >*>(static_cast<MonitorRemoteCommittedActor*>(this)));
															#line 10731 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 2307 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		remoteLogs = Optional<std::vector<OptionalInterface<TLogInterface>>>();
															#line 2308 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (self->db->get().recoveryState >= RecoveryState::ALL_LOGS_RECRUITED)
															#line 10747 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 2309 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			for( auto& logSet : self->db->get().logSystemConfig.tLogs ) {
															#line 2310 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (!logSet.isLocal)
															#line 10753 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				{
															#line 2311 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					remoteLogs = logSet.tLogs;
															#line 2312 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					for( auto& tLog : logSet.tLogs ) {
															#line 2313 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						if (!tLog.present())
															#line 10761 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
						{
															#line 2314 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
							remoteLogs = Optional<std::vector<OptionalInterface<TLogInterface>>>();
															#line 10765 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
							break;
						}
					}
					break;
				}
			}
		}
															#line 2323 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!remoteLogs.present())
															#line 10775 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 2324 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			StrictFuture<Void> __when_expr_1 = self->db->onChange();
															#line 2324 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (static_cast<MonitorRemoteCommittedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 10781 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<MonitorRemoteCommittedActor*>(this)->actor_wait_state = 2;
															#line 2324 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MonitorRemoteCommittedActor, 1, Void >*>(static_cast<MonitorRemoteCommittedActor*>(this)));
															#line 10786 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MonitorRemoteCommittedActor*>(this)->actor_wait_state > 0) static_cast<MonitorRemoteCommittedActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorRemoteCommittedActor*>(this)->ActorCallback< MonitorRemoteCommittedActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorRemoteCommittedActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorRemoteCommitted", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorRemoteCommittedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorRemoteCommitted", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MonitorRemoteCommittedActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorRemoteCommitted", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorRemoteCommittedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorRemoteCommitted", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MonitorRemoteCommittedActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorRemoteCommitted", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorRemoteCommittedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorRemoteCommitted", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 2327 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->popRemoteTxs = true;
															#line 2329 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		onChange = self->db->onChange();
															#line 2330 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		;
															#line 10879 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont8(Void const& _,int loopDepth) 
	{
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1cont8(Void && _,int loopDepth) 
	{
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<MonitorRemoteCommittedActor*>(this)->actor_wait_state > 0) static_cast<MonitorRemoteCommittedActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorRemoteCommittedActor*>(this)->ActorCallback< MonitorRemoteCommittedActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorRemoteCommittedActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorRemoteCommitted", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorRemoteCommittedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorRemoteCommitted", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MonitorRemoteCommittedActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorRemoteCommitted", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorRemoteCommittedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorRemoteCommitted", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< MonitorRemoteCommittedActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorRemoteCommitted", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorRemoteCommittedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorRemoteCommitted", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont10(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1(int loopDepth) 
	{
															#line 2331 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		replies = std::vector<Future<TLogQueuingMetricsReply>>();
															#line 2332 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		for( auto& it : remoteLogs.get() ) {
															#line 2333 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			replies.push_back( brokenPromiseToNever(it.interf().getQueuingMetrics.getReply(TLogQueuingMetricsRequest())));
															#line 10992 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 2336 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_2 = waitForAll(replies) || onChange;
															#line 2336 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<MonitorRemoteCommittedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 10998 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont2loopBody1when1(__when_expr_2.get(), loopDepth); };
		static_cast<MonitorRemoteCommittedActor*>(this)->actor_wait_state = 3;
															#line 2336 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MonitorRemoteCommittedActor, 2, Void >*>(static_cast<MonitorRemoteCommittedActor*>(this)));
															#line 11003 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont10(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 2338 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (onChange.isReady())
															#line 11025 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
			return a_body1loopBody1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 2343 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		Version minVersion = std::numeric_limits<Version>::max();
															#line 2344 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		for( auto& it : replies ) {
															#line 2345 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			minVersion = std::min(minVersion, it.get().v);
															#line 11035 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 2348 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		for(;self->txsPopVersions.size() && self->txsPopVersions.front().first <= minVersion;) {
															#line 2349 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			self->lastTxsPop = self->txsPopVersions.front().second;
															#line 2350 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			self->logSystem->popTxs(self->txsPopVersions.front().second, tagLocalityRemoteLog);
															#line 2351 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			self->txsPopVersions.pop_front();
															#line 11045 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 2354 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_3 = delay(SERVER_KNOBS->UPDATE_REMOTE_LOG_VERSION_INTERVAL) || onChange;
															#line 2354 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<MonitorRemoteCommittedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 11051 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont2loopBody1cont1when1(__when_expr_3.get(), loopDepth); };
		static_cast<MonitorRemoteCommittedActor*>(this)->actor_wait_state = 4;
															#line 2354 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< MonitorRemoteCommittedActor, 3, Void >*>(static_cast<MonitorRemoteCommittedActor*>(this)));
															#line 11056 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 2338 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (onChange.isReady())
															#line 11065 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
			return a_body1loopBody1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 2343 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		Version minVersion = std::numeric_limits<Version>::max();
															#line 2344 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		for( auto& it : replies ) {
															#line 2345 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			minVersion = std::min(minVersion, it.get().v);
															#line 11075 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 2348 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		for(;self->txsPopVersions.size() && self->txsPopVersions.front().first <= minVersion;) {
															#line 2349 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			self->lastTxsPop = self->txsPopVersions.front().second;
															#line 2350 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			self->logSystem->popTxs(self->txsPopVersions.front().second, tagLocalityRemoteLog);
															#line 2351 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			self->txsPopVersions.pop_front();
															#line 11085 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 2354 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_3 = delay(SERVER_KNOBS->UPDATE_REMOTE_LOG_VERSION_INTERVAL) || onChange;
															#line 2354 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<MonitorRemoteCommittedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 11091 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont2loopBody1cont1when1(__when_expr_3.get(), loopDepth); };
		static_cast<MonitorRemoteCommittedActor*>(this)->actor_wait_state = 4;
															#line 2354 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< MonitorRemoteCommittedActor, 3, Void >*>(static_cast<MonitorRemoteCommittedActor*>(this)));
															#line 11096 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<MonitorRemoteCommittedActor*>(this)->actor_wait_state > 0) static_cast<MonitorRemoteCommittedActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorRemoteCommittedActor*>(this)->ActorCallback< MonitorRemoteCommittedActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorRemoteCommittedActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorRemoteCommitted", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorRemoteCommittedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorRemoteCommitted", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< MonitorRemoteCommittedActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorRemoteCommitted", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorRemoteCommittedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorRemoteCommitted", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< MonitorRemoteCommittedActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorRemoteCommitted", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorRemoteCommittedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorRemoteCommitted", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont2loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 2355 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (onChange.isReady())
															#line 11180 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
			return a_body1loopBody1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
		if (loopDepth == 0) return a_body1loopBody1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 2355 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (onChange.isReady())
															#line 11192 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
			return a_body1loopBody1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
		if (loopDepth == 0) return a_body1loopBody1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<MonitorRemoteCommittedActor*>(this)->actor_wait_state > 0) static_cast<MonitorRemoteCommittedActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorRemoteCommittedActor*>(this)->ActorCallback< MonitorRemoteCommittedActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorRemoteCommittedActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorRemoteCommitted", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorRemoteCommittedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont2loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorRemoteCommitted", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< MonitorRemoteCommittedActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorRemoteCommitted", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorRemoteCommittedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont2loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorRemoteCommitted", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< MonitorRemoteCommittedActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorRemoteCommitted", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorRemoteCommittedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorRemoteCommitted", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 2304 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ProxyCommitData* self;
															#line 2307 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Optional<std::vector<OptionalInterface<TLogInterface>>> remoteLogs;
															#line 2329 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Future<Void> onChange;
															#line 2331 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	std::vector<Future<TLogQueuingMetricsReply>> replies;
															#line 11283 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via monitorRemoteCommitted()
															#line 2304 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class MonitorRemoteCommittedActor final : public Actor<Void>, public ActorCallback< MonitorRemoteCommittedActor, 0, Void >, public ActorCallback< MonitorRemoteCommittedActor, 1, Void >, public ActorCallback< MonitorRemoteCommittedActor, 2, Void >, public ActorCallback< MonitorRemoteCommittedActor, 3, Void >, public FastAllocated<MonitorRemoteCommittedActor>, public MonitorRemoteCommittedActorState<MonitorRemoteCommittedActor> {
															#line 11288 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
	using FastAllocated<MonitorRemoteCommittedActor>::operator new;
	using FastAllocated<MonitorRemoteCommittedActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16838814560907689984UL, 5899020017403095040UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MonitorRemoteCommittedActor, 0, Void >;
friend struct ActorCallback< MonitorRemoteCommittedActor, 1, Void >;
friend struct ActorCallback< MonitorRemoteCommittedActor, 2, Void >;
friend struct ActorCallback< MonitorRemoteCommittedActor, 3, Void >;
															#line 2304 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	MonitorRemoteCommittedActor(ProxyCommitData* const& self) 
															#line 11308 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   MonitorRemoteCommittedActorState<MonitorRemoteCommittedActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("monitorRemoteCommitted", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5098072617628861952UL, 10945506090906970880UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorRemoteCommittedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("monitorRemoteCommitted");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("monitorRemoteCommitted", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MonitorRemoteCommittedActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< MonitorRemoteCommittedActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< MonitorRemoteCommittedActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< MonitorRemoteCommittedActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2304 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
[[nodiscard]] Future<Void> monitorRemoteCommitted( ProxyCommitData* const& self ) {
															#line 2304 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	return Future<Void>(new MonitorRemoteCommittedActor(self));
															#line 11344 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
}

#line 2361 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"

															#line 11349 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via proxySnapCreate()
															#line 2362 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
template <class ProxySnapCreateActor>
															#line 2362 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class ProxySnapCreateActorState {
															#line 11356 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
															#line 2362 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ProxySnapCreateActorState(ProxySnapRequest const& snapReq,ProxyCommitData* const& commitData) 
															#line 2362 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
															#line 2362 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		 : snapReq(snapReq),
															#line 2362 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   commitData(commitData)
															#line 11365 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("proxySnapCreate", reinterpret_cast<unsigned long>(this));

	}
	~ProxySnapCreateActorState() 
	{
		fdb_probe_actor_destroy("proxySnapCreate", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2363 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			TraceEvent("SnapCommitProxy_SnapReqEnter") .detail("SnapPayload", snapReq.snapPayload) .detail("SnapUID", snapReq.snapUID);
															#line 11380 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			try {
															#line 2368 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				ExecCmdValueString execArg(snapReq.snapPayload);
															#line 2369 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				StringRef binPath = execArg.getBinaryPath();
															#line 2370 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (!isWhitelisted(commitData->whitelistedBinPathVec, binPath))
															#line 11388 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				{
															#line 2371 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					TraceEvent("SnapCommitProxy_WhiteListCheckFailed") .detail("SnapPayload", snapReq.snapPayload) .detail("SnapUID", snapReq.snapUID);
															#line 2374 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					return a_body1Catch2(snap_path_not_whitelisted(), loopDepth);
															#line 11394 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				}
															#line 2377 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (commitData->db->get().recoveryState != RecoveryState::FULLY_RECOVERED)
															#line 11398 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				{
															#line 2383 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					TraceEvent("SnapCommitProxy_ClusterNotFullyRecovered") .detail("SnapPayload", snapReq.snapPayload) .detail("SnapUID", snapReq.snapUID);
															#line 2386 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					return a_body1Catch2(snap_not_fully_recovered_unsupported(), loopDepth);
															#line 11404 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				}
															#line 2389 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				auto result = commitData->txnStateStore->readValue("log_anti_quorum"_sr.withPrefix(configKeysPrefix)).get();
															#line 2390 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				int logAntiQuorum = 0;
															#line 2391 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (result.present())
															#line 11412 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				{
															#line 2392 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					logAntiQuorum = atoi(result.get().toString().c_str());
															#line 11416 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				}
															#line 2396 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (logAntiQuorum > 0)
															#line 11420 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				{
															#line 2397 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					TraceEvent("SnapCommitProxy_LogAntiQuorumNotSupported") .detail("SnapPayload", snapReq.snapPayload) .detail("SnapUID", snapReq.snapUID);
															#line 2400 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					return a_body1Catch2(snap_log_anti_quorum_unsupported(), loopDepth);
															#line 11426 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				}
															#line 2403 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				snapReqRetry = 0;
															#line 2404 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				snapRetryBackoff = FLOW_KNOBS->PREVENT_FAST_SPIN_DELAY;
															#line 2405 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				;
															#line 11434 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ProxySnapCreateActorState();
		static_cast<ProxySnapCreateActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2443 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		TraceEvent("SnapCommitProxy_SnapReqExit") .detail("SnapPayload", snapReq.snapPayload) .detail("SnapUID", snapReq.snapUID);
															#line 2446 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!static_cast<ProxySnapCreateActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ProxySnapCreateActorState(); static_cast<ProxySnapCreateActor*>(this)->destroy(); return 0; }
															#line 11465 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		new (&static_cast<ProxySnapCreateActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ProxySnapCreateActorState();
		static_cast<ProxySnapCreateActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2433 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			TraceEvent("SnapCommitProxy_SnapReqError") .errorUnsuppressed(e) .detail("SnapPayload", snapReq.snapPayload) .detail("SnapUID", snapReq.snapUID);
															#line 2437 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (e.code() != error_code_operation_cancelled)
															#line 11480 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			{
															#line 2438 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				snapReq.reply.sendError(e);
															#line 11484 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
			else
			{
															#line 2440 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 11490 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 2431 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		snapReq.reply.send(Void());
															#line 11506 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 2407 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!commitData->db->get().distributor.present())
															#line 11522 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 2408 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			TraceEvent(SevWarnAlways, "DataDistributorNotPresent").detail("Operation", "SnapRequest");
															#line 2409 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			return a_body1Catch2(dd_not_found(), std::max(0, loopDepth - 1));
															#line 11528 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
		try {
															#line 2412 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			Future<ErrorOr<Void>> ddSnapReq = commitData->db->get().distributor.get().distributorSnapReq.tryGetReply( DistributorSnapRequest(snapReq.snapPayload, snapReq.snapUID));
															#line 2415 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			StrictFuture<Void> __when_expr_0 = throwErrorOr(ddSnapReq);
															#line 2415 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (static_cast<ProxySnapCreateActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 11537 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ProxySnapCreateActor*>(this)->actor_wait_state = 1;
															#line 2415 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ProxySnapCreateActor, 0, Void >*>(static_cast<ProxySnapCreateActor*>(this)));
															#line 11542 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2418 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			TraceEvent("SnapCommitProxy_DDSnapResponseError") .errorUnsuppressed(e) .detail("SnapPayload", snapReq.snapPayload) .detail("SnapUID", snapReq.snapUID) .detail("Retry", snapReqRetry);
															#line 2424 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (e.code() != error_code_request_maybe_delivered || ++snapReqRetry > SERVER_KNOBS->SNAP_NETWORK_FAILURE_RETRY_LIMIT)
															#line 11579 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			{
															#line 2426 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				return a_body1Catch2(e, std::max(0, loopDepth - 1));
															#line 11583 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
															#line 2427 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			StrictFuture<Void> __when_expr_1 = delay(snapRetryBackoff);
															#line 2427 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (static_cast<ProxySnapCreateActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 11589 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<ProxySnapCreateActor*>(this)->actor_wait_state = 2;
															#line 2427 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ProxySnapCreateActor, 1, Void >*>(static_cast<ProxySnapCreateActor*>(this)));
															#line 11594 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ProxySnapCreateActor*>(this)->actor_wait_state > 0) static_cast<ProxySnapCreateActor*>(this)->actor_wait_state = 0;
		static_cast<ProxySnapCreateActor*>(this)->ActorCallback< ProxySnapCreateActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ProxySnapCreateActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("proxySnapCreate", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProxySnapCreateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("proxySnapCreate", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ProxySnapCreateActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("proxySnapCreate", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProxySnapCreateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("proxySnapCreate", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ProxySnapCreateActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("proxySnapCreate", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ProxySnapCreateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("proxySnapCreate", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
															#line 2428 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		snapRetryBackoff = snapRetryBackoff * 2;
															#line 11696 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
															#line 2428 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		snapRetryBackoff = snapRetryBackoff * 2;
															#line 11705 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ProxySnapCreateActor*>(this)->actor_wait_state > 0) static_cast<ProxySnapCreateActor*>(this)->actor_wait_state = 0;
		static_cast<ProxySnapCreateActor*>(this)->ActorCallback< ProxySnapCreateActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ProxySnapCreateActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("proxySnapCreate", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProxySnapCreateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("proxySnapCreate", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ProxySnapCreateActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("proxySnapCreate", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProxySnapCreateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("proxySnapCreate", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ProxySnapCreateActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("proxySnapCreate", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ProxySnapCreateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("proxySnapCreate", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont8(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 2362 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ProxySnapRequest snapReq;
															#line 2362 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ProxyCommitData* commitData;
															#line 2403 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	int snapReqRetry;
															#line 2404 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	double snapRetryBackoff;
															#line 11806 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via proxySnapCreate()
															#line 2362 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class ProxySnapCreateActor final : public Actor<Void>, public ActorCallback< ProxySnapCreateActor, 0, Void >, public ActorCallback< ProxySnapCreateActor, 1, Void >, public FastAllocated<ProxySnapCreateActor>, public ProxySnapCreateActorState<ProxySnapCreateActor> {
															#line 11811 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
	using FastAllocated<ProxySnapCreateActor>::operator new;
	using FastAllocated<ProxySnapCreateActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6473465054489625344UL, 2858050787947908096UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ProxySnapCreateActor, 0, Void >;
friend struct ActorCallback< ProxySnapCreateActor, 1, Void >;
															#line 2362 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ProxySnapCreateActor(ProxySnapRequest const& snapReq,ProxyCommitData* const& commitData) 
															#line 11829 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   ProxySnapCreateActorState<ProxySnapCreateActor>(snapReq, commitData),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("proxySnapCreate", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9779697684357553408UL, 1968612500139297024UL);
		ActorExecutionContextHelper __helper(static_cast<ProxySnapCreateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("proxySnapCreate");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("proxySnapCreate", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ProxySnapCreateActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ProxySnapCreateActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2362 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
[[nodiscard]] Future<Void> proxySnapCreate( ProxySnapRequest const& snapReq, ProxyCommitData* const& commitData ) {
															#line 2362 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	return Future<Void>(new ProxySnapCreateActor(snapReq, commitData));
															#line 11863 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
}

#line 2448 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"

															#line 11868 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via proxyCheckSafeExclusion()
															#line 2449 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
template <class ProxyCheckSafeExclusionActor>
															#line 2449 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class ProxyCheckSafeExclusionActorState {
															#line 11875 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
															#line 2449 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ProxyCheckSafeExclusionActorState(Reference<AsyncVar<ServerDBInfo> const> const& db,ExclusionSafetyCheckRequest const& req) 
															#line 2449 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
															#line 2449 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		 : db(db),
															#line 2449 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   req(req)
															#line 11884 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("proxyCheckSafeExclusion", reinterpret_cast<unsigned long>(this));

	}
	~ProxyCheckSafeExclusionActorState() 
	{
		fdb_probe_actor_destroy("proxyCheckSafeExclusion", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2451 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			TraceEvent("SafetyCheckCommitProxyBegin").log();
															#line 2452 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			reply = ExclusionSafetyCheckReply(false);
															#line 2453 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (!db->get().distributor.present())
															#line 11903 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			{
															#line 2454 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				TraceEvent(SevWarnAlways, "DataDistributorNotPresent").detail("Operation", "ExclusionSafetyCheck");
															#line 2455 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				req.reply.send(reply);
															#line 2456 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (!static_cast<ProxyCheckSafeExclusionActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ProxyCheckSafeExclusionActorState(); static_cast<ProxyCheckSafeExclusionActor*>(this)->destroy(); return 0; }
															#line 11911 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				new (&static_cast<ProxyCheckSafeExclusionActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~ProxyCheckSafeExclusionActorState();
				static_cast<ProxyCheckSafeExclusionActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			try {
															#line 2459 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				ddSafeFuture = db->get().distributor.get().distributorExclCheckReq.tryGetReply( DistributorExclusionSafetyCheckRequest(req.exclusions));
															#line 2462 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				StrictFuture<DistributorExclusionSafetyCheckReply> __when_expr_0 = throwErrorOr(ddSafeFuture);
															#line 2462 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (static_cast<ProxyCheckSafeExclusionActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 11924 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<ProxyCheckSafeExclusionActor*>(this)->actor_wait_state = 1;
															#line 2462 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ProxyCheckSafeExclusionActor, 0, DistributorExclusionSafetyCheckReply >*>(static_cast<ProxyCheckSafeExclusionActor*>(this)));
															#line 11929 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ProxyCheckSafeExclusionActorState();
		static_cast<ProxyCheckSafeExclusionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2473 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		TraceEvent("SafetyCheckCommitProxyFinish").log();
															#line 2474 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		req.reply.send(reply);
															#line 2475 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!static_cast<ProxyCheckSafeExclusionActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ProxyCheckSafeExclusionActorState(); static_cast<ProxyCheckSafeExclusionActor*>(this)->destroy(); return 0; }
															#line 11962 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		new (&static_cast<ProxyCheckSafeExclusionActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ProxyCheckSafeExclusionActorState();
		static_cast<ProxyCheckSafeExclusionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2465 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			TraceEvent("SafetyCheckCommitProxyResponseError").error(e);
															#line 2466 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (e.code() != error_code_operation_cancelled)
															#line 11977 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			{
															#line 2467 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				req.reply.sendError(e);
															#line 2468 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (!static_cast<ProxyCheckSafeExclusionActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ProxyCheckSafeExclusionActorState(); static_cast<ProxyCheckSafeExclusionActor*>(this)->destroy(); return 0; }
															#line 11983 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				new (&static_cast<ProxyCheckSafeExclusionActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~ProxyCheckSafeExclusionActorState();
				static_cast<ProxyCheckSafeExclusionActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 2470 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 11993 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3(DistributorExclusionSafetyCheckReply const& _reply,int loopDepth) 
	{
															#line 2463 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		reply.safe = _reply.safe;
															#line 12008 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(DistributorExclusionSafetyCheckReply && _reply,int loopDepth) 
	{
															#line 2463 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		reply.safe = _reply.safe;
															#line 12017 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1when1(DistributorExclusionSafetyCheckReply const& _reply,int loopDepth) 
	{
		loopDepth = a_body1cont3(_reply, loopDepth);

		return loopDepth;
	}
	int a_body1when1(DistributorExclusionSafetyCheckReply && _reply,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_reply), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ProxyCheckSafeExclusionActor*>(this)->actor_wait_state > 0) static_cast<ProxyCheckSafeExclusionActor*>(this)->actor_wait_state = 0;
		static_cast<ProxyCheckSafeExclusionActor*>(this)->ActorCallback< ProxyCheckSafeExclusionActor, 0, DistributorExclusionSafetyCheckReply >::remove();

	}
	void a_callback_fire(ActorCallback< ProxyCheckSafeExclusionActor, 0, DistributorExclusionSafetyCheckReply >*,DistributorExclusionSafetyCheckReply const& value) 
	{
		fdb_probe_actor_enter("proxyCheckSafeExclusion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProxyCheckSafeExclusionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("proxyCheckSafeExclusion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ProxyCheckSafeExclusionActor, 0, DistributorExclusionSafetyCheckReply >*,DistributorExclusionSafetyCheckReply && value) 
	{
		fdb_probe_actor_enter("proxyCheckSafeExclusion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProxyCheckSafeExclusionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("proxyCheckSafeExclusion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ProxyCheckSafeExclusionActor, 0, DistributorExclusionSafetyCheckReply >*,Error err) 
	{
		fdb_probe_actor_enter("proxyCheckSafeExclusion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ProxyCheckSafeExclusionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("proxyCheckSafeExclusion", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 2449 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> db;
															#line 2449 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ExclusionSafetyCheckRequest req;
															#line 2452 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ExclusionSafetyCheckReply reply;
															#line 2459 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Future<ErrorOr<DistributorExclusionSafetyCheckReply>> ddSafeFuture;
															#line 12118 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via proxyCheckSafeExclusion()
															#line 2449 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class ProxyCheckSafeExclusionActor final : public Actor<Void>, public ActorCallback< ProxyCheckSafeExclusionActor, 0, DistributorExclusionSafetyCheckReply >, public FastAllocated<ProxyCheckSafeExclusionActor>, public ProxyCheckSafeExclusionActorState<ProxyCheckSafeExclusionActor> {
															#line 12123 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
	using FastAllocated<ProxyCheckSafeExclusionActor>::operator new;
	using FastAllocated<ProxyCheckSafeExclusionActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15214471893915318784UL, 11826605592796978944UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ProxyCheckSafeExclusionActor, 0, DistributorExclusionSafetyCheckReply >;
															#line 2449 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ProxyCheckSafeExclusionActor(Reference<AsyncVar<ServerDBInfo> const> const& db,ExclusionSafetyCheckRequest const& req) 
															#line 12140 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   ProxyCheckSafeExclusionActorState<ProxyCheckSafeExclusionActor>(db, req),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("proxyCheckSafeExclusion", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1552417108573464832UL, 15142131124646932992UL);
		ActorExecutionContextHelper __helper(static_cast<ProxyCheckSafeExclusionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("proxyCheckSafeExclusion");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("proxyCheckSafeExclusion", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ProxyCheckSafeExclusionActor, 0, DistributorExclusionSafetyCheckReply >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2449 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
[[nodiscard]] Future<Void> proxyCheckSafeExclusion( Reference<AsyncVar<ServerDBInfo> const> const& db, ExclusionSafetyCheckRequest const& req ) {
															#line 2449 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	return Future<Void>(new ProxyCheckSafeExclusionActor(db, req));
															#line 12173 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
}

#line 2477 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"

															#line 12178 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via reportTxnTagCommitCost()
															#line 2478 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
template <class ReportTxnTagCommitCostActor>
															#line 2478 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class ReportTxnTagCommitCostActorState {
															#line 12185 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
															#line 2478 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ReportTxnTagCommitCostActorState(UID const& myID,Reference<AsyncVar<ServerDBInfo> const> const& db,UIDTransactionTagMap<TransactionCommitCostEstimation>* const& ssTrTagCommitCost) 
															#line 2478 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
															#line 2478 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		 : myID(myID),
															#line 2478 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   db(db),
															#line 2478 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   ssTrTagCommitCost(ssTrTagCommitCost),
															#line 2481 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   nextRequestTimer(Never()),
															#line 2482 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   nextReply(Never())
															#line 12200 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("reportTxnTagCommitCost", reinterpret_cast<unsigned long>(this));

	}
	~ReportTxnTagCommitCostActorState() 
	{
		fdb_probe_actor_destroy("reportTxnTagCommitCost", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2483 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (db->get().ratekeeper.present())
															#line 12215 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			{
															#line 2484 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				nextRequestTimer = Void();
															#line 12219 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
															#line 2485 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			;
															#line 12223 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ReportTxnTagCommitCostActorState();
		static_cast<ReportTxnTagCommitCostActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 2486 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_0 = db->onChange();
															#line 2485 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<ReportTxnTagCommitCostActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 12255 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
															#line 2495 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_1 = nextRequestTimer;
															#line 12259 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
															#line 2505 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_2 = nextReply;
															#line 12263 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when3(__when_expr_2.get(), loopDepth); };
		static_cast<ReportTxnTagCommitCostActor*>(this)->actor_wait_state = 1;
															#line 2486 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ReportTxnTagCommitCostActor, 0, Void >*>(static_cast<ReportTxnTagCommitCostActor*>(this)));
															#line 2495 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ReportTxnTagCommitCostActor, 1, Void >*>(static_cast<ReportTxnTagCommitCostActor*>(this)));
															#line 2505 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ReportTxnTagCommitCostActor, 2, Void >*>(static_cast<ReportTxnTagCommitCostActor*>(this)));
															#line 12272 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
															#line 2487 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (db->get().ratekeeper.present())
															#line 12287 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 2488 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			TraceEvent("ProxyRatekeeperChanged", myID).detail("RKID", db->get().ratekeeper.get().id());
															#line 2489 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			nextRequestTimer = Void();
															#line 12293 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
		else
		{
															#line 2491 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			TraceEvent("ProxyRatekeeperDied", myID).log();
															#line 2492 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			nextRequestTimer = Never();
															#line 12301 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
															#line 2487 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (db->get().ratekeeper.present())
															#line 12311 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 2488 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			TraceEvent("ProxyRatekeeperChanged", myID).detail("RKID", db->get().ratekeeper.get().id());
															#line 2489 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			nextRequestTimer = Void();
															#line 12317 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
		else
		{
															#line 2491 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			TraceEvent("ProxyRatekeeperDied", myID).log();
															#line 2492 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			nextRequestTimer = Never();
															#line 12325 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
															#line 2496 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		nextRequestTimer = Never();
															#line 2497 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (db->get().ratekeeper.present())
															#line 12337 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 2498 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			nextReply = brokenPromiseToNever(db->get().ratekeeper.get().reportCommitCostEstimation.getReply( ReportCommitCostEstimationRequest(std::move(*ssTrTagCommitCost))));
															#line 2500 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			ssTrTagCommitCost->clear();
															#line 12343 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
		else
		{
															#line 2502 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			nextReply = Never();
															#line 12349 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
															#line 2496 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		nextRequestTimer = Never();
															#line 2497 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (db->get().ratekeeper.present())
															#line 12361 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 2498 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			nextReply = brokenPromiseToNever(db->get().ratekeeper.get().reportCommitCostEstimation.getReply( ReportCommitCostEstimationRequest(std::move(*ssTrTagCommitCost))));
															#line 2500 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			ssTrTagCommitCost->clear();
															#line 12367 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
		else
		{
															#line 2502 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			nextReply = Never();
															#line 12373 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3(Void const& _,int loopDepth) 
	{
															#line 2506 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		nextReply = Never();
															#line 2507 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		nextRequestTimer = delay(SERVER_KNOBS->REPORT_TRANSACTION_COST_ESTIMATION_DELAY);
															#line 12385 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3(Void && _,int loopDepth) 
	{
															#line 2506 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		nextReply = Never();
															#line 2507 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		nextRequestTimer = delay(SERVER_KNOBS->REPORT_TRANSACTION_COST_ESTIMATION_DELAY);
															#line 12396 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ReportTxnTagCommitCostActor*>(this)->actor_wait_state > 0) static_cast<ReportTxnTagCommitCostActor*>(this)->actor_wait_state = 0;
		static_cast<ReportTxnTagCommitCostActor*>(this)->ActorCallback< ReportTxnTagCommitCostActor, 0, Void >::remove();
		static_cast<ReportTxnTagCommitCostActor*>(this)->ActorCallback< ReportTxnTagCommitCostActor, 1, Void >::remove();
		static_cast<ReportTxnTagCommitCostActor*>(this)->ActorCallback< ReportTxnTagCommitCostActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ReportTxnTagCommitCostActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("reportTxnTagCommitCost", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReportTxnTagCommitCostActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reportTxnTagCommitCost", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ReportTxnTagCommitCostActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("reportTxnTagCommitCost", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReportTxnTagCommitCostActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reportTxnTagCommitCost", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ReportTxnTagCommitCostActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("reportTxnTagCommitCost", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReportTxnTagCommitCostActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reportTxnTagCommitCost", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ReportTxnTagCommitCostActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("reportTxnTagCommitCost", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReportTxnTagCommitCostActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reportTxnTagCommitCost", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ReportTxnTagCommitCostActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("reportTxnTagCommitCost", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReportTxnTagCommitCostActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reportTxnTagCommitCost", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ReportTxnTagCommitCostActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("reportTxnTagCommitCost", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReportTxnTagCommitCostActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reportTxnTagCommitCost", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ReportTxnTagCommitCostActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("reportTxnTagCommitCost", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReportTxnTagCommitCostActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reportTxnTagCommitCost", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ReportTxnTagCommitCostActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("reportTxnTagCommitCost", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReportTxnTagCommitCostActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reportTxnTagCommitCost", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ReportTxnTagCommitCostActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("reportTxnTagCommitCost", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReportTxnTagCommitCostActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reportTxnTagCommitCost", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 2478 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	UID myID;
															#line 2478 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> db;
															#line 2478 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	UIDTransactionTagMap<TransactionCommitCostEstimation>* ssTrTagCommitCost;
															#line 2481 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Future<Void> nextRequestTimer;
															#line 2482 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Future<Void> nextReply;
															#line 12590 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via reportTxnTagCommitCost()
															#line 2478 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class ReportTxnTagCommitCostActor final : public Actor<Void>, public ActorCallback< ReportTxnTagCommitCostActor, 0, Void >, public ActorCallback< ReportTxnTagCommitCostActor, 1, Void >, public ActorCallback< ReportTxnTagCommitCostActor, 2, Void >, public FastAllocated<ReportTxnTagCommitCostActor>, public ReportTxnTagCommitCostActorState<ReportTxnTagCommitCostActor> {
															#line 12595 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
	using FastAllocated<ReportTxnTagCommitCostActor>::operator new;
	using FastAllocated<ReportTxnTagCommitCostActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13519964921901498624UL, 442283000417306880UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ReportTxnTagCommitCostActor, 0, Void >;
friend struct ActorCallback< ReportTxnTagCommitCostActor, 1, Void >;
friend struct ActorCallback< ReportTxnTagCommitCostActor, 2, Void >;
															#line 2478 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ReportTxnTagCommitCostActor(UID const& myID,Reference<AsyncVar<ServerDBInfo> const> const& db,UIDTransactionTagMap<TransactionCommitCostEstimation>* const& ssTrTagCommitCost) 
															#line 12614 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   ReportTxnTagCommitCostActorState<ReportTxnTagCommitCostActor>(myID, db, ssTrTagCommitCost),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("reportTxnTagCommitCost", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18129575439556995328UL, 8473472385509925632UL);
		ActorExecutionContextHelper __helper(static_cast<ReportTxnTagCommitCostActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("reportTxnTagCommitCost");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("reportTxnTagCommitCost", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ReportTxnTagCommitCostActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2478 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
[[nodiscard]] Future<Void> reportTxnTagCommitCost( UID const& myID, Reference<AsyncVar<ServerDBInfo> const> const& db, UIDTransactionTagMap<TransactionCommitCostEstimation>* const& ssTrTagCommitCost ) {
															#line 2478 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	return Future<Void>(new ReportTxnTagCommitCostActor(myID, db, ssTrTagCommitCost));
															#line 12647 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
}

#line 2511 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"

namespace {
struct ExpireServerEntry {
	int64_t timeReceived;
	int expectedCount = 0;
	int receivedCount = 0;
	bool initialized = false;
};

struct IdempotencyKey {
	Version version;
	uint8_t highOrderBatchIndex;
	bool operator==(const IdempotencyKey& other) const {
		return version == other.version && highOrderBatchIndex == other.highOrderBatchIndex;
	}
};

} // namespace

namespace std {
template <>
struct hash<IdempotencyKey> {
	std::size_t operator()(const IdempotencyKey& key) const {
		std::size_t seed = 0;
		boost::hash_combine(seed, std::hash<Version>{}(key.version));
		boost::hash_combine(seed, std::hash<uint8_t>{}(key.highOrderBatchIndex));
		return seed;
	}
};

} // namespace std

															#line 12683 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via idempotencyIdsExpireServer()
															#line 2543 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
template <class IdempotencyIdsExpireServerActor>
															#line 2543 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class IdempotencyIdsExpireServerActorState {
															#line 12690 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
															#line 2543 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	IdempotencyIdsExpireServerActorState(Database const& db,PublicRequestStream<ExpireIdempotencyIdRequest> const& expireIdempotencyId,PromiseStream<ExpectedIdempotencyIdCountForKey> const& expectedIdempotencyIdCountForKey,Standalone<VectorRef<MutationRef>>* const& idempotencyClears) 
															#line 2543 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
															#line 2543 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		 : db(db),
															#line 2543 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   expireIdempotencyId(expireIdempotencyId),
															#line 2543 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   expectedIdempotencyIdCountForKey(expectedIdempotencyIdCountForKey),
															#line 2543 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   idempotencyClears(idempotencyClears),
															#line 2548 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   idStatus(),
															#line 2549 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   iter(),
															#line 2550 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   purgeBefore(),
															#line 2551 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   key(),
															#line 2552 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   status(nullptr),
															#line 2553 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   purgeOld(Void())
															#line 12715 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("idempotencyIdsExpireServer", reinterpret_cast<unsigned long>(this));

	}
	~IdempotencyIdsExpireServerActorState() 
	{
		fdb_probe_actor_destroy("idempotencyIdsExpireServer", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2554 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			;
															#line 12730 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~IdempotencyIdsExpireServerActorState();
		static_cast<IdempotencyIdsExpireServerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 2556 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		auto __when_expr_0 = expireIdempotencyId.getFuture();
															#line 12760 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		static_assert(std::is_same<decltype(__when_expr_0), FutureStream<ExpireIdempotencyIdRequest>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<ExpireIdempotencyIdRequest>>::value, "invalid type");
															#line 2555 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<IdempotencyIdsExpireServerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 12764 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
															#line 2565 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		auto __when_expr_1 = expectedIdempotencyIdCountForKey.getFuture();
															#line 12768 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		static_assert(std::is_same<decltype(__when_expr_1), FutureStream<ExpectedIdempotencyIdCountForKey>>::value || std::is_same<decltype(__when_expr_1), ThreadFutureStream<ExpectedIdempotencyIdCountForKey>>::value, "invalid type");
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.pop(), loopDepth); };
															#line 2571 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_2 = purgeOld;
															#line 12773 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when3(__when_expr_2.get(), loopDepth); };
		static_cast<IdempotencyIdsExpireServerActor*>(this)->actor_wait_state = 1;
															#line 2556 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< IdempotencyIdsExpireServerActor, 0, ExpireIdempotencyIdRequest >*>(static_cast<IdempotencyIdsExpireServerActor*>(this)));
															#line 2565 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorSingleCallback< IdempotencyIdsExpireServerActor, 1, ExpectedIdempotencyIdCountForKey >*>(static_cast<IdempotencyIdsExpireServerActor*>(this)));
															#line 2571 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< IdempotencyIdsExpireServerActor, 2, Void >*>(static_cast<IdempotencyIdsExpireServerActor*>(this)));
															#line 12782 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 2587 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (status->initialized)
															#line 12791 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 2588 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (status->receivedCount == status->expectedCount)
															#line 12795 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			{
															#line 2589 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				auto keyRange = makeIdempotencySingleKeyRange(idempotencyClears->arena(), key.version, key.highOrderBatchIndex);
															#line 2591 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				idempotencyClears->push_back(idempotencyClears->arena(), MutationRef(MutationRef::ClearRange, keyRange.begin, keyRange.end));
															#line 2593 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				idStatus.erase(key);
															#line 12803 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
		}
		else
		{
															#line 2596 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			status->timeReceived = now();
															#line 2597 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			status->initialized = true;
															#line 12812 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(ExpireIdempotencyIdRequest const& req,int loopDepth) 
	{
															#line 2557 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		key = IdempotencyKey{ req.commitVersion, req.batchIndexHighByte };
															#line 2558 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		status = &idStatus[key];
															#line 2559 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		status->receivedCount += 1;
															#line 2560 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		CODE_PROBE(status->expectedCount == 0, "ExpireIdempotencyIdRequest received before count is known");
															#line 2561 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (status->expectedCount > 0)
															#line 12830 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 2562 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			ASSERT_LE(status->receivedCount, status->expectedCount);
															#line 12834 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(ExpireIdempotencyIdRequest && req,int loopDepth) 
	{
															#line 2557 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		key = IdempotencyKey{ req.commitVersion, req.batchIndexHighByte };
															#line 2558 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		status = &idStatus[key];
															#line 2559 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		status->receivedCount += 1;
															#line 2560 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		CODE_PROBE(status->expectedCount == 0, "ExpireIdempotencyIdRequest received before count is known");
															#line 2561 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (status->expectedCount > 0)
															#line 12852 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 2562 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			ASSERT_LE(status->receivedCount, status->expectedCount);
															#line 12856 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(ExpectedIdempotencyIdCountForKey const& req,int loopDepth) 
	{
															#line 2566 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		key = IdempotencyKey{ req.commitVersion, req.batchIndexHighByte };
															#line 2567 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		status = &idStatus[key];
															#line 2568 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		ASSERT_EQ(status->expectedCount, 0);
															#line 2569 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		status->expectedCount = req.idempotencyIdCount;
															#line 12872 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(ExpectedIdempotencyIdCountForKey && req,int loopDepth) 
	{
															#line 2566 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		key = IdempotencyKey{ req.commitVersion, req.batchIndexHighByte };
															#line 2567 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		status = &idStatus[key];
															#line 2568 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		ASSERT_EQ(status->expectedCount, 0);
															#line 2569 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		status->expectedCount = req.idempotencyIdCount;
															#line 12887 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3(Void const& _,int loopDepth) 
	{
															#line 2572 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		purgeOld = delay(SERVER_KNOBS->IDEMPOTENCY_ID_IN_MEMORY_LIFETIME);
															#line 2573 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		purgeBefore = now() - SERVER_KNOBS->IDEMPOTENCY_ID_IN_MEMORY_LIFETIME;
															#line 2574 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		iter = idStatus.begin();
															#line 12900 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1when3loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3(Void && _,int loopDepth) 
	{
															#line 2572 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		purgeOld = delay(SERVER_KNOBS->IDEMPOTENCY_ID_IN_MEMORY_LIFETIME);
															#line 2573 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		purgeBefore = now() - SERVER_KNOBS->IDEMPOTENCY_ID_IN_MEMORY_LIFETIME;
															#line 2574 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		iter = idStatus.begin();
															#line 12913 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1when3loopHead1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<IdempotencyIdsExpireServerActor*>(this)->actor_wait_state > 0) static_cast<IdempotencyIdsExpireServerActor*>(this)->actor_wait_state = 0;
		static_cast<IdempotencyIdsExpireServerActor*>(this)->ActorSingleCallback< IdempotencyIdsExpireServerActor, 0, ExpireIdempotencyIdRequest >::remove();
		static_cast<IdempotencyIdsExpireServerActor*>(this)->ActorSingleCallback< IdempotencyIdsExpireServerActor, 1, ExpectedIdempotencyIdCountForKey >::remove();
		static_cast<IdempotencyIdsExpireServerActor*>(this)->ActorCallback< IdempotencyIdsExpireServerActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorSingleCallback< IdempotencyIdsExpireServerActor, 0, ExpireIdempotencyIdRequest >*,ExpireIdempotencyIdRequest const& value) 
	{
		fdb_probe_actor_enter("idempotencyIdsExpireServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IdempotencyIdsExpireServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("idempotencyIdsExpireServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< IdempotencyIdsExpireServerActor, 0, ExpireIdempotencyIdRequest >*,ExpireIdempotencyIdRequest && value) 
	{
		fdb_probe_actor_enter("idempotencyIdsExpireServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IdempotencyIdsExpireServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("idempotencyIdsExpireServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< IdempotencyIdsExpireServerActor, 0, ExpireIdempotencyIdRequest >*,Error err) 
	{
		fdb_probe_actor_enter("idempotencyIdsExpireServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<IdempotencyIdsExpireServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("idempotencyIdsExpireServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< IdempotencyIdsExpireServerActor, 1, ExpectedIdempotencyIdCountForKey >*,ExpectedIdempotencyIdCountForKey const& value) 
	{
		fdb_probe_actor_enter("idempotencyIdsExpireServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IdempotencyIdsExpireServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("idempotencyIdsExpireServer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorSingleCallback< IdempotencyIdsExpireServerActor, 1, ExpectedIdempotencyIdCountForKey >*,ExpectedIdempotencyIdCountForKey && value) 
	{
		fdb_probe_actor_enter("idempotencyIdsExpireServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IdempotencyIdsExpireServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("idempotencyIdsExpireServer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorSingleCallback< IdempotencyIdsExpireServerActor, 1, ExpectedIdempotencyIdCountForKey >*,Error err) 
	{
		fdb_probe_actor_enter("idempotencyIdsExpireServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<IdempotencyIdsExpireServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("idempotencyIdsExpireServer", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1when3cont1(int loopDepth) 
	{
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1when3loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1when3loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3loopBody1(int loopDepth) 
	{
															#line 2574 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!(iter != idStatus.end()))
															#line 13057 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
			return a_body1loopBody1when3break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 2577 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_3 = yield();
															#line 2577 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<IdempotencyIdsExpireServerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 13065 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1when3loopBody1when1(__when_expr_3.get(), loopDepth); };
		static_cast<IdempotencyIdsExpireServerActor*>(this)->actor_wait_state = 2;
															#line 2577 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< IdempotencyIdsExpireServerActor, 3, Void >*>(static_cast<IdempotencyIdsExpireServerActor*>(this)));
															#line 13070 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when3break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1when3cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1when3loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 2578 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (iter->second.timeReceived < purgeBefore)
															#line 13092 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 2579 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			iter = idStatus.erase(iter);
															#line 13096 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
		else
		{
															#line 2581 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			++iter;
															#line 13102 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
		if (loopDepth == 0) return a_body1loopBody1when3loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when3loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 2578 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (iter->second.timeReceived < purgeBefore)
															#line 13112 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 2579 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			iter = idStatus.erase(iter);
															#line 13116 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
		else
		{
															#line 2581 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			++iter;
															#line 13122 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
		if (loopDepth == 0) return a_body1loopBody1when3loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when3loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when3loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when3loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<IdempotencyIdsExpireServerActor*>(this)->actor_wait_state > 0) static_cast<IdempotencyIdsExpireServerActor*>(this)->actor_wait_state = 0;
		static_cast<IdempotencyIdsExpireServerActor*>(this)->ActorCallback< IdempotencyIdsExpireServerActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< IdempotencyIdsExpireServerActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("idempotencyIdsExpireServer", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IdempotencyIdsExpireServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when3loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("idempotencyIdsExpireServer", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< IdempotencyIdsExpireServerActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("idempotencyIdsExpireServer", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IdempotencyIdsExpireServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when3loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("idempotencyIdsExpireServer", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< IdempotencyIdsExpireServerActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("idempotencyIdsExpireServer", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<IdempotencyIdsExpireServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("idempotencyIdsExpireServer", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< IdempotencyIdsExpireServerActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("idempotencyIdsExpireServer", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IdempotencyIdsExpireServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("idempotencyIdsExpireServer", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< IdempotencyIdsExpireServerActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("idempotencyIdsExpireServer", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IdempotencyIdsExpireServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("idempotencyIdsExpireServer", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< IdempotencyIdsExpireServerActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("idempotencyIdsExpireServer", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<IdempotencyIdsExpireServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("idempotencyIdsExpireServer", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 2543 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Database db;
															#line 2543 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	PublicRequestStream<ExpireIdempotencyIdRequest> expireIdempotencyId;
															#line 2543 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	PromiseStream<ExpectedIdempotencyIdCountForKey> expectedIdempotencyIdCountForKey;
															#line 2543 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Standalone<VectorRef<MutationRef>>* idempotencyClears;
															#line 2548 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	std::unordered_map<IdempotencyKey, ExpireServerEntry> idStatus;
															#line 2549 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	std::unordered_map<IdempotencyKey, ExpireServerEntry>::iterator iter;
															#line 2550 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	int64_t purgeBefore;
															#line 2551 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	IdempotencyKey key;
															#line 2552 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ExpireServerEntry* status;
															#line 2553 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Future<Void> purgeOld;
															#line 13280 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via idempotencyIdsExpireServer()
															#line 2543 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class IdempotencyIdsExpireServerActor final : public Actor<Void>, public ActorSingleCallback< IdempotencyIdsExpireServerActor, 0, ExpireIdempotencyIdRequest >, public ActorSingleCallback< IdempotencyIdsExpireServerActor, 1, ExpectedIdempotencyIdCountForKey >, public ActorCallback< IdempotencyIdsExpireServerActor, 2, Void >, public ActorCallback< IdempotencyIdsExpireServerActor, 3, Void >, public FastAllocated<IdempotencyIdsExpireServerActor>, public IdempotencyIdsExpireServerActorState<IdempotencyIdsExpireServerActor> {
															#line 13285 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
	using FastAllocated<IdempotencyIdsExpireServerActor>::operator new;
	using FastAllocated<IdempotencyIdsExpireServerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6141727351606388480UL, 16044032129937496320UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< IdempotencyIdsExpireServerActor, 0, ExpireIdempotencyIdRequest >;
friend struct ActorSingleCallback< IdempotencyIdsExpireServerActor, 1, ExpectedIdempotencyIdCountForKey >;
friend struct ActorCallback< IdempotencyIdsExpireServerActor, 2, Void >;
friend struct ActorCallback< IdempotencyIdsExpireServerActor, 3, Void >;
															#line 2543 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	IdempotencyIdsExpireServerActor(Database const& db,PublicRequestStream<ExpireIdempotencyIdRequest> const& expireIdempotencyId,PromiseStream<ExpectedIdempotencyIdCountForKey> const& expectedIdempotencyIdCountForKey,Standalone<VectorRef<MutationRef>>* const& idempotencyClears) 
															#line 13305 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   IdempotencyIdsExpireServerActorState<IdempotencyIdsExpireServerActor>(db, expireIdempotencyId, expectedIdempotencyIdCountForKey, idempotencyClears),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("idempotencyIdsExpireServer", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2194589099630311680UL, 4656839406185788928UL);
		ActorExecutionContextHelper __helper(static_cast<IdempotencyIdsExpireServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("idempotencyIdsExpireServer");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("idempotencyIdsExpireServer", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< IdempotencyIdsExpireServerActor, 0, ExpireIdempotencyIdRequest >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< IdempotencyIdsExpireServerActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2543 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
[[nodiscard]] static Future<Void> idempotencyIdsExpireServer( Database const& db, PublicRequestStream<ExpireIdempotencyIdRequest> const& expireIdempotencyId, PromiseStream<ExpectedIdempotencyIdCountForKey> const& expectedIdempotencyIdCountForKey, Standalone<VectorRef<MutationRef>>* const& idempotencyClears ) {
															#line 2543 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	return Future<Void>(new IdempotencyIdsExpireServerActor(db, expireIdempotencyId, expectedIdempotencyIdCountForKey, idempotencyClears));
															#line 13339 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
}

#line 2601 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"

namespace {

struct TransactionStateResolveContext {
	// Maximum sequence for txnStateRequest, this is defined when the request last flag is set.
	Sequence maxSequence = std::numeric_limits<Sequence>::max();

	// Flags marks received transaction state requests, we only process the transaction request when *all* requests are
	// received.
	std::unordered_set<Sequence> receivedSequences;

	ProxyCommitData* pCommitData = nullptr;

	// Pointer to transaction state store, shortcut for commitData.txnStateStore
	IKeyValueStore* pTxnStateStore = nullptr;

	Future<Void> txnRecovery;

	// Actor streams
	PromiseStream<Future<Void>>* pActors = nullptr;

	// Flag reports if the transaction state request is complete. This request should only happen during recover, i.e.
	// once per commit proxy.
	bool processed = false;

	TransactionStateResolveContext() = default;

	TransactionStateResolveContext(ProxyCommitData* pCommitData_, PromiseStream<Future<Void>>* pActors_)
	  : pCommitData(pCommitData_), pTxnStateStore(pCommitData_->txnStateStore), pActors(pActors_) {
		ASSERT(pTxnStateStore != nullptr);
	}
};

															#line 13376 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
// This generated class is to be used only via processCompleteTransactionStateRequest()
															#line 2634 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
template <class ProcessCompleteTransactionStateRequestActor>
															#line 2634 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class ProcessCompleteTransactionStateRequestActorState {
															#line 13382 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
															#line 2634 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ProcessCompleteTransactionStateRequestActorState(TransactionStateResolveContext* const& pContext) 
															#line 2634 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
															#line 2634 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		 : pContext(pContext),
															#line 2635 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   txnKeys(allKeys),
															#line 2636 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   tag_uid()
															#line 13393 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("processCompleteTransactionStateRequest", reinterpret_cast<unsigned long>(this));

	}
	~ProcessCompleteTransactionStateRequestActorState() 
	{
		fdb_probe_actor_destroy("processCompleteTransactionStateRequest", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2638 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			RangeResult UIDtoTagMap = pContext->pTxnStateStore->readRange(serverTagKeys).get();
															#line 2639 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			for( const KeyValueRef& kv : UIDtoTagMap ) {
															#line 2640 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				tag_uid[decodeServerTagValue(kv.value)] = decodeServerTagKey(kv.key);
															#line 13412 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
															#line 2643 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			;
															#line 13416 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ProcessCompleteTransactionStateRequestActorState();
		static_cast<ProcessCompleteTransactionStateRequestActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2719 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		auto lockedKey = pContext->pTxnStateStore->readValue(databaseLockedKey).get();
															#line 2720 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pContext->pCommitData->locked = lockedKey.present() && lockedKey.get().size();
															#line 2721 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pContext->pCommitData->metadataVersion = pContext->pTxnStateStore->readValue(metadataVersionKey).get();
															#line 2723 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pContext->pTxnStateStore->enableSnapshot();
															#line 2725 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!static_cast<ProcessCompleteTransactionStateRequestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ProcessCompleteTransactionStateRequestActorState(); static_cast<ProcessCompleteTransactionStateRequestActor*>(this)->destroy(); return 0; }
															#line 13447 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		new (&static_cast<ProcessCompleteTransactionStateRequestActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ProcessCompleteTransactionStateRequestActorState();
		static_cast<ProcessCompleteTransactionStateRequestActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 2644 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_0 = yield();
															#line 2644 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<ProcessCompleteTransactionStateRequestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 13468 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<ProcessCompleteTransactionStateRequestActor*>(this)->actor_wait_state = 1;
															#line 2644 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ProcessCompleteTransactionStateRequestActor, 0, Void >*>(static_cast<ProcessCompleteTransactionStateRequestActor*>(this)));
															#line 13473 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 2646 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		RangeResult data = pContext->pTxnStateStore ->readRange(txnKeys, SERVER_KNOBS->BUGGIFIED_ROW_LIMIT, SERVER_KNOBS->APPLY_MUTATION_BYTES) .get();
															#line 2650 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!data.size())
															#line 13497 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 2653 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		((KeyRangeRef&)txnKeys) = KeyRangeRef(keyAfter(data.back().key, txnKeys.arena()), txnKeys.end);
															#line 2655 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		MutationsVec mutations;
															#line 2656 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		std::vector<std::pair<MapPair<Key, ServerCacheInfo>, int>> keyInfoData;
															#line 2657 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		std::vector<UID> src, dest;
															#line 2658 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		ServerCacheInfo info;
															#line 2660 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		auto updateTagInfo = [pContext = pContext](const std::vector<UID>& uids, std::vector<Tag>& tags, std::vector<Reference<StorageInfo>>& storageInfoItems) { for (const auto& id : uids) { auto storageInfo = getStorageInfo(id, &pContext->pCommitData->storageCache, pContext->pTxnStateStore); ASSERT(storageInfo->tag != invalidTag); tags.push_back(storageInfo->tag); storageInfoItems.push_back(storageInfo); } };
															#line 2670 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		for( auto& kv : data ) {
															#line 2671 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (kv.key.startsWith(keyServersPrefix))
															#line 13517 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			{
															#line 2672 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				KeyRef k = kv.key.removePrefix(keyServersPrefix);
															#line 2673 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (k == allKeys.end)
															#line 13523 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				{
					continue;
				}
															#line 2676 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				decodeKeyServersValue(tag_uid, kv.value, src, dest);
															#line 2678 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				info.tags.clear();
															#line 2680 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				info.src_info.clear();
															#line 2681 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				updateTagInfo(src, info.tags, info.src_info);
															#line 2683 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				info.dest_info.clear();
															#line 2684 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				updateTagInfo(dest, info.tags, info.dest_info);
															#line 2686 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				uniquify(info.tags);
															#line 2687 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				keyInfoData.emplace_back(MapPair<Key, ServerCacheInfo>(k, info), 1);
															#line 13543 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
			else
			{
															#line 2688 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (kv.key.startsWith(rangeLockPrefix))
															#line 13549 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				{
															#line 2689 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					if (pContext->pCommitData->rangeLockEnabled())
															#line 13553 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
					{
															#line 2690 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						ASSERT(pContext->pCommitData->rangeLock != nullptr);
															#line 2691 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						Key keyInsert = kv.key.removePrefix(rangeLockPrefix);
															#line 2692 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						pContext->pCommitData->rangeLock->initKeyPoint(keyInsert, kv.value);
															#line 13561 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
					}
				}
				else
				{
															#line 2695 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					mutations.emplace_back(mutations.arena(), MutationRef::SetValue, kv.key, kv.value);
															#line 13568 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
					continue;
				}
			}
		}
															#line 2702 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pContext->pCommitData->keyInfo.rawInsert(keyInfoData);
															#line 2704 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		Arena arena;
															#line 2705 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		bool confChanges;
															#line 2706 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		applyMetadataMutations(SpanContext(), *pContext->pCommitData, arena, Reference<ILogSystem>(), mutations, nullptr, confChanges, 0, 0, true, pContext->pCommitData->provisional);
															#line 13581 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 2646 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		RangeResult data = pContext->pTxnStateStore ->readRange(txnKeys, SERVER_KNOBS->BUGGIFIED_ROW_LIMIT, SERVER_KNOBS->APPLY_MUTATION_BYTES) .get();
															#line 2650 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!data.size())
															#line 13592 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 2653 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		((KeyRangeRef&)txnKeys) = KeyRangeRef(keyAfter(data.back().key, txnKeys.arena()), txnKeys.end);
															#line 2655 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		MutationsVec mutations;
															#line 2656 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		std::vector<std::pair<MapPair<Key, ServerCacheInfo>, int>> keyInfoData;
															#line 2657 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		std::vector<UID> src, dest;
															#line 2658 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		ServerCacheInfo info;
															#line 2660 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		auto updateTagInfo = [pContext = pContext](const std::vector<UID>& uids, std::vector<Tag>& tags, std::vector<Reference<StorageInfo>>& storageInfoItems) { for (const auto& id : uids) { auto storageInfo = getStorageInfo(id, &pContext->pCommitData->storageCache, pContext->pTxnStateStore); ASSERT(storageInfo->tag != invalidTag); tags.push_back(storageInfo->tag); storageInfoItems.push_back(storageInfo); } };
															#line 2670 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		for( auto& kv : data ) {
															#line 2671 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (kv.key.startsWith(keyServersPrefix))
															#line 13612 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			{
															#line 2672 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				KeyRef k = kv.key.removePrefix(keyServersPrefix);
															#line 2673 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (k == allKeys.end)
															#line 13618 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				{
					continue;
				}
															#line 2676 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				decodeKeyServersValue(tag_uid, kv.value, src, dest);
															#line 2678 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				info.tags.clear();
															#line 2680 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				info.src_info.clear();
															#line 2681 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				updateTagInfo(src, info.tags, info.src_info);
															#line 2683 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				info.dest_info.clear();
															#line 2684 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				updateTagInfo(dest, info.tags, info.dest_info);
															#line 2686 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				uniquify(info.tags);
															#line 2687 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				keyInfoData.emplace_back(MapPair<Key, ServerCacheInfo>(k, info), 1);
															#line 13638 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
			else
			{
															#line 2688 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (kv.key.startsWith(rangeLockPrefix))
															#line 13644 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				{
															#line 2689 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					if (pContext->pCommitData->rangeLockEnabled())
															#line 13648 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
					{
															#line 2690 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						ASSERT(pContext->pCommitData->rangeLock != nullptr);
															#line 2691 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						Key keyInsert = kv.key.removePrefix(rangeLockPrefix);
															#line 2692 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						pContext->pCommitData->rangeLock->initKeyPoint(keyInsert, kv.value);
															#line 13656 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
					}
				}
				else
				{
															#line 2695 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					mutations.emplace_back(mutations.arena(), MutationRef::SetValue, kv.key, kv.value);
															#line 13663 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
					continue;
				}
			}
		}
															#line 2702 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pContext->pCommitData->keyInfo.rawInsert(keyInfoData);
															#line 2704 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		Arena arena;
															#line 2705 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		bool confChanges;
															#line 2706 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		applyMetadataMutations(SpanContext(), *pContext->pCommitData, arena, Reference<ILogSystem>(), mutations, nullptr, confChanges, 0, 0, true, pContext->pCommitData->provisional);
															#line 13676 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ProcessCompleteTransactionStateRequestActor*>(this)->actor_wait_state > 0) static_cast<ProcessCompleteTransactionStateRequestActor*>(this)->actor_wait_state = 0;
		static_cast<ProcessCompleteTransactionStateRequestActor*>(this)->ActorCallback< ProcessCompleteTransactionStateRequestActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ProcessCompleteTransactionStateRequestActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("processCompleteTransactionStateRequest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessCompleteTransactionStateRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processCompleteTransactionStateRequest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ProcessCompleteTransactionStateRequestActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("processCompleteTransactionStateRequest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessCompleteTransactionStateRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processCompleteTransactionStateRequest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ProcessCompleteTransactionStateRequestActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("processCompleteTransactionStateRequest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessCompleteTransactionStateRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processCompleteTransactionStateRequest", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 2634 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	TransactionStateResolveContext* pContext;
															#line 2635 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	KeyRange txnKeys;
															#line 2636 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	std::map<Tag, UID> tag_uid;
															#line 13762 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via processCompleteTransactionStateRequest()
															#line 2634 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class ProcessCompleteTransactionStateRequestActor final : public Actor<Void>, public ActorCallback< ProcessCompleteTransactionStateRequestActor, 0, Void >, public FastAllocated<ProcessCompleteTransactionStateRequestActor>, public ProcessCompleteTransactionStateRequestActorState<ProcessCompleteTransactionStateRequestActor> {
															#line 13767 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
	using FastAllocated<ProcessCompleteTransactionStateRequestActor>::operator new;
	using FastAllocated<ProcessCompleteTransactionStateRequestActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4057674067023301376UL, 15201335948626020608UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ProcessCompleteTransactionStateRequestActor, 0, Void >;
															#line 2634 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ProcessCompleteTransactionStateRequestActor(TransactionStateResolveContext* const& pContext) 
															#line 13784 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   ProcessCompleteTransactionStateRequestActorState<ProcessCompleteTransactionStateRequestActor>(pContext),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("processCompleteTransactionStateRequest", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8499504063907237888UL, 15656031568419423488UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessCompleteTransactionStateRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("processCompleteTransactionStateRequest");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("processCompleteTransactionStateRequest", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ProcessCompleteTransactionStateRequestActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 2634 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
[[nodiscard]] Future<Void> processCompleteTransactionStateRequest( TransactionStateResolveContext* const& pContext ) {
															#line 2634 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	return Future<Void>(new ProcessCompleteTransactionStateRequestActor(pContext));
															#line 13816 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
}

#line 2727 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"

															#line 13821 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
// This generated class is to be used only via processTransactionStateRequestPart()
															#line 2728 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
template <class ProcessTransactionStateRequestPartActor>
															#line 2728 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class ProcessTransactionStateRequestPartActorState {
															#line 13827 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
															#line 2728 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ProcessTransactionStateRequestPartActorState(TransactionStateResolveContext* const& pContext,TxnStateRequest const& request) 
															#line 2728 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
															#line 2728 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		 : pContext(pContext),
															#line 2728 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   request(request)
															#line 13836 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("processTransactionStateRequestPart", reinterpret_cast<unsigned long>(this));

	}
	~ProcessTransactionStateRequestPartActorState() 
	{
		fdb_probe_actor_destroy("processTransactionStateRequestPart", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2730 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			ASSERT(pContext->pCommitData != nullptr);
															#line 2731 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			ASSERT(pContext->pActors != nullptr);
															#line 2733 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (pContext->receivedSequences.contains(request.sequence))
															#line 13855 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			{
															#line 2734 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (pContext->receivedSequences.size() == pContext->maxSequence)
															#line 13859 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				{
															#line 2735 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					StrictFuture<Void> __when_expr_0 = pContext->txnRecovery;
															#line 2735 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					if (static_cast<ProcessTransactionStateRequestPartActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13865 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
					if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
					static_cast<ProcessTransactionStateRequestPartActor*>(this)->actor_wait_state = 1;
															#line 2735 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ProcessTransactionStateRequestPartActor, 0, Void >*>(static_cast<ProcessTransactionStateRequestPartActor*>(this)));
															#line 13870 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
					loopDepth = 0;
				}
				else
				{
					loopDepth = a_body1cont2(loopDepth);
				}
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ProcessTransactionStateRequestPartActorState();
		static_cast<ProcessTransactionStateRequestPartActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2743 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (request.last)
															#line 13903 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 2745 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			pContext->maxSequence = request.sequence + 1;
															#line 13907 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 2747 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pContext->receivedSequences.insert(request.sequence);
															#line 2752 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		ASSERT(!pContext->pCommitData->validState.isSet());
															#line 2754 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		for( auto& kv : request.data ) {
															#line 2755 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			pContext->pTxnStateStore->set(kv, &request.arena);
															#line 13917 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 2757 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pContext->pTxnStateStore->commit(true);
															#line 2759 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (pContext->receivedSequences.size() == pContext->maxSequence)
															#line 13923 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 2761 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			ASSERT(!pContext->processed);
															#line 2762 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			pContext->txnRecovery = processCompleteTransactionStateRequest(pContext);
															#line 2763 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			StrictFuture<Void> __when_expr_2 = pContext->txnRecovery;
															#line 2763 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (static_cast<ProcessTransactionStateRequestPartActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13933 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1when1(__when_expr_2.get(), loopDepth); };
			static_cast<ProcessTransactionStateRequestPartActor*>(this)->actor_wait_state = 3;
															#line 2763 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ProcessTransactionStateRequestPartActor, 2, Void >*>(static_cast<ProcessTransactionStateRequestPartActor*>(this)));
															#line 13938 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont6(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 2738 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pContext->pActors->send(broadcastTxnRequest(request, SERVER_KNOBS->TXN_STATE_SEND_AMOUNT, true));
															#line 2739 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_1 = yield();
															#line 2739 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<ProcessTransactionStateRequestPartActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13956 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<ProcessTransactionStateRequestPartActor*>(this)->actor_wait_state = 2;
															#line 2739 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ProcessTransactionStateRequestPartActor, 1, Void >*>(static_cast<ProcessTransactionStateRequestPartActor*>(this)));
															#line 13961 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ProcessTransactionStateRequestPartActor*>(this)->actor_wait_state > 0) static_cast<ProcessTransactionStateRequestPartActor*>(this)->actor_wait_state = 0;
		static_cast<ProcessTransactionStateRequestPartActor*>(this)->ActorCallback< ProcessTransactionStateRequestPartActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ProcessTransactionStateRequestPartActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("processTransactionStateRequestPart", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessTransactionStateRequestPartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processTransactionStateRequestPart", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ProcessTransactionStateRequestPartActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("processTransactionStateRequestPart", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessTransactionStateRequestPartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processTransactionStateRequestPart", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ProcessTransactionStateRequestPartActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("processTransactionStateRequestPart", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessTransactionStateRequestPartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processTransactionStateRequestPart", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 2740 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!static_cast<ProcessTransactionStateRequestPartActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ProcessTransactionStateRequestPartActorState(); static_cast<ProcessTransactionStateRequestPartActor*>(this)->destroy(); return 0; }
															#line 14057 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		new (&static_cast<ProcessTransactionStateRequestPartActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ProcessTransactionStateRequestPartActorState();
		static_cast<ProcessTransactionStateRequestPartActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 2740 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!static_cast<ProcessTransactionStateRequestPartActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ProcessTransactionStateRequestPartActorState(); static_cast<ProcessTransactionStateRequestPartActor*>(this)->destroy(); return 0; }
															#line 14069 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		new (&static_cast<ProcessTransactionStateRequestPartActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ProcessTransactionStateRequestPartActorState();
		static_cast<ProcessTransactionStateRequestPartActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ProcessTransactionStateRequestPartActor*>(this)->actor_wait_state > 0) static_cast<ProcessTransactionStateRequestPartActor*>(this)->actor_wait_state = 0;
		static_cast<ProcessTransactionStateRequestPartActor*>(this)->ActorCallback< ProcessTransactionStateRequestPartActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ProcessTransactionStateRequestPartActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("processTransactionStateRequestPart", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessTransactionStateRequestPartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processTransactionStateRequestPart", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ProcessTransactionStateRequestPartActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("processTransactionStateRequestPart", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessTransactionStateRequestPartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processTransactionStateRequestPart", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ProcessTransactionStateRequestPartActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("processTransactionStateRequestPart", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessTransactionStateRequestPartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processTransactionStateRequestPart", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont6(int loopDepth) 
	{
															#line 2767 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pContext->pActors->send(broadcastTxnRequest(request, SERVER_KNOBS->TXN_STATE_SEND_AMOUNT, true));
															#line 2768 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_3 = yield();
															#line 2768 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<ProcessTransactionStateRequestPartActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14160 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont6when1(__when_expr_3.get(), loopDepth); };
		static_cast<ProcessTransactionStateRequestPartActor*>(this)->actor_wait_state = 4;
															#line 2768 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ProcessTransactionStateRequestPartActor, 3, Void >*>(static_cast<ProcessTransactionStateRequestPartActor*>(this)));
															#line 14165 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont9(Void const& _,int loopDepth) 
	{
															#line 2764 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pContext->processed = true;
															#line 14174 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont9(Void && _,int loopDepth) 
	{
															#line 2764 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pContext->processed = true;
															#line 14183 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ProcessTransactionStateRequestPartActor*>(this)->actor_wait_state > 0) static_cast<ProcessTransactionStateRequestPartActor*>(this)->actor_wait_state = 0;
		static_cast<ProcessTransactionStateRequestPartActor*>(this)->ActorCallback< ProcessTransactionStateRequestPartActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ProcessTransactionStateRequestPartActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("processTransactionStateRequestPart", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessTransactionStateRequestPartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processTransactionStateRequestPart", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ProcessTransactionStateRequestPartActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("processTransactionStateRequestPart", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessTransactionStateRequestPartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processTransactionStateRequestPart", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ProcessTransactionStateRequestPartActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("processTransactionStateRequestPart", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessTransactionStateRequestPartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processTransactionStateRequestPart", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont11(Void const& _,int loopDepth) 
	{
															#line 2769 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!static_cast<ProcessTransactionStateRequestPartActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ProcessTransactionStateRequestPartActorState(); static_cast<ProcessTransactionStateRequestPartActor*>(this)->destroy(); return 0; }
															#line 14267 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		new (&static_cast<ProcessTransactionStateRequestPartActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ProcessTransactionStateRequestPartActorState();
		static_cast<ProcessTransactionStateRequestPartActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont11(Void && _,int loopDepth) 
	{
															#line 2769 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!static_cast<ProcessTransactionStateRequestPartActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ProcessTransactionStateRequestPartActorState(); static_cast<ProcessTransactionStateRequestPartActor*>(this)->destroy(); return 0; }
															#line 14279 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		new (&static_cast<ProcessTransactionStateRequestPartActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ProcessTransactionStateRequestPartActorState();
		static_cast<ProcessTransactionStateRequestPartActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<ProcessTransactionStateRequestPartActor*>(this)->actor_wait_state > 0) static_cast<ProcessTransactionStateRequestPartActor*>(this)->actor_wait_state = 0;
		static_cast<ProcessTransactionStateRequestPartActor*>(this)->ActorCallback< ProcessTransactionStateRequestPartActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ProcessTransactionStateRequestPartActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("processTransactionStateRequestPart", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessTransactionStateRequestPartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processTransactionStateRequestPart", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< ProcessTransactionStateRequestPartActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("processTransactionStateRequestPart", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessTransactionStateRequestPartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processTransactionStateRequestPart", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< ProcessTransactionStateRequestPartActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("processTransactionStateRequestPart", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessTransactionStateRequestPartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processTransactionStateRequestPart", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 2728 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	TransactionStateResolveContext* pContext;
															#line 2728 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	TxnStateRequest request;
															#line 14366 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via processTransactionStateRequestPart()
															#line 2728 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class ProcessTransactionStateRequestPartActor final : public Actor<Void>, public ActorCallback< ProcessTransactionStateRequestPartActor, 0, Void >, public ActorCallback< ProcessTransactionStateRequestPartActor, 1, Void >, public ActorCallback< ProcessTransactionStateRequestPartActor, 2, Void >, public ActorCallback< ProcessTransactionStateRequestPartActor, 3, Void >, public FastAllocated<ProcessTransactionStateRequestPartActor>, public ProcessTransactionStateRequestPartActorState<ProcessTransactionStateRequestPartActor> {
															#line 14371 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
	using FastAllocated<ProcessTransactionStateRequestPartActor>::operator new;
	using FastAllocated<ProcessTransactionStateRequestPartActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9530404097435202304UL, 13292397816433819392UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ProcessTransactionStateRequestPartActor, 0, Void >;
friend struct ActorCallback< ProcessTransactionStateRequestPartActor, 1, Void >;
friend struct ActorCallback< ProcessTransactionStateRequestPartActor, 2, Void >;
friend struct ActorCallback< ProcessTransactionStateRequestPartActor, 3, Void >;
															#line 2728 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ProcessTransactionStateRequestPartActor(TransactionStateResolveContext* const& pContext,TxnStateRequest const& request) 
															#line 14391 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   ProcessTransactionStateRequestPartActorState<ProcessTransactionStateRequestPartActor>(pContext, request),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("processTransactionStateRequestPart", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6249502656935116032UL, 7110093004433443328UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessTransactionStateRequestPartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("processTransactionStateRequestPart");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("processTransactionStateRequestPart", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ProcessTransactionStateRequestPartActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ProcessTransactionStateRequestPartActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ProcessTransactionStateRequestPartActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< ProcessTransactionStateRequestPartActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 2728 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
[[nodiscard]] Future<Void> processTransactionStateRequestPart( TransactionStateResolveContext* const& pContext, TxnStateRequest const& request ) {
															#line 2728 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	return Future<Void>(new ProcessTransactionStateRequestPartActor(pContext, request));
															#line 14426 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
}

#line 2771 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"

} // anonymous namespace

//
// Metrics related to the commit proxy are logged on a five second interval in
// the `ProxyMetrics` trace. However, it can be hard to determine workload
// burstiness when looking at such a large time range. This function adds much
// more frequent logging for certain metrics to provide fine-grained insight
// into workload patterns. The metrics logged by this function break down into
// two categories:
//
//   * existing counters reported by `ProxyMetrics`
//   * new counters that are only reported by this function
//
// Neither is implemented optimally, but the data collected should be helpful
// in identifying workload patterns on the server.
//
// Metrics reporting by this function can be disabled by setting the
// `BURSTINESS_METRICS_ENABLED` knob to false. The reporting interval can be
// adjusted by modifying the knob `BURSTINESS_METRICS_LOG_INTERVAL`.
//
															#line 14451 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via logDetailedMetrics()
															#line 2792 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
template <class LogDetailedMetricsActor>
															#line 2792 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class LogDetailedMetricsActorState {
															#line 14458 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
															#line 2792 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	LogDetailedMetricsActorState(ProxyCommitData* const& commitData) 
															#line 2792 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
															#line 2792 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		 : commitData(commitData),
															#line 2793 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   startTime(0),
															#line 2794 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   commitBatchInBaseline(0),
															#line 2795 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   txnCommitInBaseline(0),
															#line 2796 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   mutationsBaseline(0),
															#line 2797 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   mutationBytesBaseline(0)
															#line 14475 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("logDetailedMetrics", reinterpret_cast<unsigned long>(this));

	}
	~LogDetailedMetricsActorState() 
	{
		fdb_probe_actor_destroy("logDetailedMetrics", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2799 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			;
															#line 14490 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~LogDetailedMetricsActorState();
		static_cast<LogDetailedMetricsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 2800 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!SERVER_KNOBS->BURSTINESS_METRICS_ENABLED)
															#line 14520 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 2801 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (!static_cast<LogDetailedMetricsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~LogDetailedMetricsActorState(); static_cast<LogDetailedMetricsActor*>(this)->destroy(); return 0; }
															#line 14524 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			new (&static_cast<LogDetailedMetricsActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~LogDetailedMetricsActorState();
			static_cast<LogDetailedMetricsActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2804 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		startTime = now();
															#line 2805 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		commitBatchInBaseline = commitData->stats.commitBatchIn.getValue();
															#line 2806 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		txnCommitInBaseline = commitData->stats.txnCommitIn.getValue();
															#line 2807 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		mutationsBaseline = commitData->stats.mutations.getValue();
															#line 2808 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		mutationBytesBaseline = commitData->stats.mutationBytes.getValue();
															#line 2810 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delay(SERVER_KNOBS->BURSTINESS_METRICS_LOG_INTERVAL);
															#line 2810 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<LogDetailedMetricsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 14544 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<LogDetailedMetricsActor*>(this)->actor_wait_state = 1;
															#line 2810 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< LogDetailedMetricsActor, 0, Void >*>(static_cast<LogDetailedMetricsActor*>(this)));
															#line 14549 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 2812 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		int64_t commitBatchInReal = commitData->stats.commitBatchIn.getValue();
															#line 2813 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		int64_t txnCommitInReal = commitData->stats.txnCommitIn.getValue();
															#line 2814 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		int64_t mutationsReal = commitData->stats.mutations.getValue();
															#line 2815 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		int64_t mutationBytesReal = commitData->stats.mutationBytes.getValue();
															#line 2819 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (commitBatchInReal < commitBatchInBaseline || txnCommitInReal < txnCommitInBaseline || mutationsReal < mutationsBaseline || mutationBytesReal < mutationBytesBaseline)
															#line 14566 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
			return a_body1loopHead1(loopDepth); // continue
		}
															#line 2824 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		TraceEvent("ProxyDetailedMetrics") .detail("Elapsed", now() - startTime) .detail("CommitBatchIn", commitBatchInReal - commitBatchInBaseline) .detail("TxnCommitIn", txnCommitInReal - txnCommitInBaseline) .detail("Mutations", mutationsReal - mutationsBaseline) .detail("MutationBytes", mutationBytesReal - mutationBytesBaseline) .detail("UniqueClients", commitData->stats.getSizeAndResetUniqueClients());
															#line 14572 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 2812 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		int64_t commitBatchInReal = commitData->stats.commitBatchIn.getValue();
															#line 2813 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		int64_t txnCommitInReal = commitData->stats.txnCommitIn.getValue();
															#line 2814 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		int64_t mutationsReal = commitData->stats.mutations.getValue();
															#line 2815 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		int64_t mutationBytesReal = commitData->stats.mutationBytes.getValue();
															#line 2819 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (commitBatchInReal < commitBatchInBaseline || txnCommitInReal < txnCommitInBaseline || mutationsReal < mutationsBaseline || mutationBytesReal < mutationBytesBaseline)
															#line 14589 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
			return a_body1loopHead1(loopDepth); // continue
		}
															#line 2824 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		TraceEvent("ProxyDetailedMetrics") .detail("Elapsed", now() - startTime) .detail("CommitBatchIn", commitBatchInReal - commitBatchInBaseline) .detail("TxnCommitIn", txnCommitInReal - txnCommitInBaseline) .detail("Mutations", mutationsReal - mutationsBaseline) .detail("MutationBytes", mutationBytesReal - mutationBytesBaseline) .detail("UniqueClients", commitData->stats.getSizeAndResetUniqueClients());
															#line 14595 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<LogDetailedMetricsActor*>(this)->actor_wait_state > 0) static_cast<LogDetailedMetricsActor*>(this)->actor_wait_state = 0;
		static_cast<LogDetailedMetricsActor*>(this)->ActorCallback< LogDetailedMetricsActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LogDetailedMetricsActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("logDetailedMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LogDetailedMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("logDetailedMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< LogDetailedMetricsActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("logDetailedMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LogDetailedMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("logDetailedMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< LogDetailedMetricsActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("logDetailedMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LogDetailedMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("logDetailedMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 2792 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ProxyCommitData* commitData;
															#line 2793 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	double startTime;
															#line 2794 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	int64_t commitBatchInBaseline;
															#line 2795 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	int64_t txnCommitInBaseline;
															#line 2796 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	int64_t mutationsBaseline;
															#line 2797 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	int64_t mutationBytesBaseline;
															#line 14687 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via logDetailedMetrics()
															#line 2792 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class LogDetailedMetricsActor final : public Actor<Void>, public ActorCallback< LogDetailedMetricsActor, 0, Void >, public FastAllocated<LogDetailedMetricsActor>, public LogDetailedMetricsActorState<LogDetailedMetricsActor> {
															#line 14692 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
	using FastAllocated<LogDetailedMetricsActor>::operator new;
	using FastAllocated<LogDetailedMetricsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15415044741661711360UL, 11256630918646315520UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< LogDetailedMetricsActor, 0, Void >;
															#line 2792 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	LogDetailedMetricsActor(ProxyCommitData* const& commitData) 
															#line 14709 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   LogDetailedMetricsActorState<LogDetailedMetricsActor>(commitData),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("logDetailedMetrics", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10939827506186500608UL, 8271598043017025536UL);
		ActorExecutionContextHelper __helper(static_cast<LogDetailedMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("logDetailedMetrics");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("logDetailedMetrics", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< LogDetailedMetricsActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2792 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
[[nodiscard]] Future<Void> logDetailedMetrics( ProxyCommitData* const& commitData ) {
															#line 2792 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	return Future<Void>(new LogDetailedMetricsActor(commitData));
															#line 14742 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
}

#line 2833 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"

															#line 14747 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via commitProxyServerCore()
															#line 2834 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
template <class CommitProxyServerCoreActor>
															#line 2834 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class CommitProxyServerCoreActorState {
															#line 14754 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
															#line 2834 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	CommitProxyServerCoreActorState(CommitProxyInterface const& proxy,MasterInterface const& master,LifetimeToken const& masterLifetime,Reference<AsyncVar<ServerDBInfo> const> const& db,LogEpoch const& epoch,Version const& recoveryTransactionVersion,bool const& firstProxy,std::string const& whitelistBinPaths,bool const& provisional,uint16_t const& commitProxyIndex) 
															#line 2834 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
															#line 2834 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		 : proxy(proxy),
															#line 2834 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   master(master),
															#line 2834 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   masterLifetime(masterLifetime),
															#line 2834 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   db(db),
															#line 2834 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   epoch(epoch),
															#line 2834 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   recoveryTransactionVersion(recoveryTransactionVersion),
															#line 2834 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   firstProxy(firstProxy),
															#line 2834 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   whitelistBinPaths(whitelistBinPaths),
															#line 2834 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   provisional(provisional),
															#line 2834 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   commitProxyIndex(commitProxyIndex),
															#line 2844 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   commitData(proxy.id(), master, proxy.getConsistentReadVersion, recoveryTransactionVersion, proxy.commit, db, firstProxy, provisional, commitProxyIndex, epoch),
															#line 2855 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   sequenceFuture((Sequence)0),
															#line 2856 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   batchedCommits(),
															#line 2857 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   commitBatcherActor(),
															#line 2858 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   lastCommitComplete(Void()),
															#line 2860 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   addActor(),
															#line 2861 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   onError(transformError(actorCollection(addActor.getFuture()), broken_promise(), tlog_failed()))
															#line 14793 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("commitProxyServerCore", reinterpret_cast<unsigned long>(this));

	}
	~CommitProxyServerCoreActorState() 
	{
		fdb_probe_actor_destroy("commitProxyServerCore", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2863 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			addActor.send(waitFailureServer(proxy.waitFailure.getFuture()));
															#line 2864 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			addActor.send(traceRole(Role::COMMIT_PROXY, proxy.id()));
															#line 2869 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			;
															#line 14812 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CommitProxyServerCoreActorState();
		static_cast<CommitProxyServerCoreActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2874 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		dbInfoChange = commitData.db->onChange();
															#line 2877 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		commitData.resolvers = commitData.db->get().resolvers;
															#line 2878 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		commitData.localTLogCount = commitData.db->get().logSystemConfig.numLogs();
															#line 2879 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		ASSERT(commitData.resolvers.size() != 0);
															#line 2880 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		for(int i = 0;i < commitData.resolvers.size();++i) {
															#line 2881 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			commitData.stats.resolverDist.push_back(Histogram::getHistogram( "CommitProxy"_sr, "ToResolver_" + commitData.resolvers[i].id().toString(), Histogram::Unit::milliseconds));
															#line 14845 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 2886 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		auto rs = commitData.keyResolvers.modify(SERVER_KNOBS->PROXY_USE_RESOLVER_PRIVATE_MUTATIONS ? normalKeys : allKeys);
															#line 2887 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		for(auto r = rs.begin();r != rs.end();++r) {
															#line 2888 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			r->value().emplace_back(0, 0);
															#line 14853 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 2889 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		commitData.systemKeyVersions.push_back(0);
															#line 2891 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		commitData.logSystem = ILogSystem::fromServerDBInfo(proxy.id(), commitData.db->get(), false, addActor);
															#line 2892 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		commitData.logAdapter = new LogSystemDiskQueueAdapter(commitData.logSystem, Reference<AsyncVar<PeekTxsInfo>>(), 1, false);
															#line 2894 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		commitData.txnStateStore = keyValueStoreLogSystem( commitData.logAdapter, commitData.db, proxy.id(), 2e9, true, true, true);
															#line 2896 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		createWhitelistBinPathVec(whitelistBinPaths, commitData.whitelistedBinPathVec);
															#line 2898 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		commitData.updateLatencyBandConfig(commitData.db->get().latencyBandConfig);
															#line 2903 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		commitBatchesMemoryLimit = SERVER_KNOBS->COMMIT_BATCHES_MEM_BYTES_HARD_LIMIT;
															#line 2904 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (SERVER_KNOBS->SERVER_MEM_LIMIT > 0)
															#line 14871 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 2905 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			commitBatchesMemoryLimit = std::min( commitBatchesMemoryLimit, static_cast<int64_t>((SERVER_KNOBS->SERVER_MEM_LIMIT * SERVER_KNOBS->COMMIT_BATCHES_MEM_FRACTION_OF_TOTAL) / SERVER_KNOBS->COMMIT_BATCHES_MEM_TO_TOTAL_MEM_SCALE_FACTOR));
															#line 14875 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 2910 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		TraceEvent(SevInfo, "CommitBatchesMemoryLimit").detail("BytesLimit", commitBatchesMemoryLimit);
															#line 2913 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (commitData.rangeLockEnabled())
															#line 14881 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 2914 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			commitData.rangeLock = std::make_shared<RangeLock>(&commitData);
															#line 2915 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			TraceEvent(SevInfo, "CommitProxyRangeLockEnabled", commitData.dbgid);
															#line 14887 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 2918 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		addActor.send(monitorRemoteCommitted(&commitData));
															#line 2919 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		addActor.send(readRequestServer(proxy, addActor, &commitData));
															#line 2920 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		addActor.send(rejoinServer(proxy, &commitData));
															#line 2921 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		addActor.send(ddMetricsRequestServer(proxy, db));
															#line 2922 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		addActor.send(reportTxnTagCommitCost(proxy.id(), db, &commitData.ssTrTagCommitCost));
															#line 2923 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		addActor.send(logDetailedMetrics(&commitData));
															#line 2925 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		auto openDb = openDBOnServer(db);
															#line 2927 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (firstProxy)
															#line 14905 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 2928 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			addActor.send(recurringAsync( [openDb = openDb]() { return cleanIdempotencyIds(openDb, SERVER_KNOBS->IDEMPOTENCY_IDS_MIN_AGE_SECONDS); }, SERVER_KNOBS->IDEMPOTENCY_IDS_CLEANER_POLLING_INTERVAL, true, SERVER_KNOBS->IDEMPOTENCY_IDS_CLEANER_POLLING_INTERVAL));
															#line 14909 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 2934 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		addActor.send(idempotencyIdsExpireServer( openDb, proxy.expireIdempotencyId, commitData.expectedIdempotencyIdCountForKey, &commitData.idempotencyClears));
															#line 2938 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_1 = success(commitData.txnStateStore->readValue(StringRef()));
															#line 2938 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<CommitProxyServerCoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14917 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CommitProxyServerCoreActor*>(this)->actor_wait_state = 2;
															#line 2938 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CommitProxyServerCoreActor, 1, Void >*>(static_cast<CommitProxyServerCoreActor*>(this)));
															#line 14922 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 2869 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!(!(masterLifetime.isEqual(commitData.db->get().masterLifetime) && commitData.db->get().recoveryState >= RecoveryState::RECOVERY_TRANSACTION)))
															#line 14938 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 2872 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_0 = commitData.db->onChange();
															#line 2872 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<CommitProxyServerCoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 14946 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<CommitProxyServerCoreActor*>(this)->actor_wait_state = 1;
															#line 2872 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CommitProxyServerCoreActor, 0, Void >*>(static_cast<CommitProxyServerCoreActor*>(this)));
															#line 14951 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CommitProxyServerCoreActor*>(this)->actor_wait_state > 0) static_cast<CommitProxyServerCoreActor*>(this)->actor_wait_state = 0;
		static_cast<CommitProxyServerCoreActor*>(this)->ActorCallback< CommitProxyServerCoreActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CommitProxyServerCoreActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitProxyServerCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CommitProxyServerCoreActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitProxyServerCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CommitProxyServerCoreActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CommitProxyServerCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 2940 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		int commitBatchByteLimit = (int)std::min<double>(SERVER_KNOBS->COMMIT_TRANSACTION_BATCH_BYTES_MAX, std::max<double>(SERVER_KNOBS->COMMIT_TRANSACTION_BATCH_BYTES_MIN, SERVER_KNOBS->COMMIT_TRANSACTION_BATCH_BYTES_SCALE_BASE * pow(commitData.db->get().client.commitProxies.size(), SERVER_KNOBS->COMMIT_TRANSACTION_BATCH_BYTES_SCALE_POWER)));
															#line 2947 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		commitBatcherActor = commitBatcher( &commitData, batchedCommits, proxy.commit.getFuture(), commitBatchByteLimit, commitBatchesMemoryLimit);
															#line 2951 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		transactionStateResolveContext = TransactionStateResolveContext(&commitData, &addActor);
															#line 2953 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		;
															#line 15066 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 2940 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		int commitBatchByteLimit = (int)std::min<double>(SERVER_KNOBS->COMMIT_TRANSACTION_BATCH_BYTES_MAX, std::max<double>(SERVER_KNOBS->COMMIT_TRANSACTION_BATCH_BYTES_MIN, SERVER_KNOBS->COMMIT_TRANSACTION_BATCH_BYTES_SCALE_BASE * pow(commitData.db->get().client.commitProxies.size(), SERVER_KNOBS->COMMIT_TRANSACTION_BATCH_BYTES_SCALE_POWER)));
															#line 2947 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		commitBatcherActor = commitBatcher( &commitData, batchedCommits, proxy.commit.getFuture(), commitBatchByteLimit, commitBatchesMemoryLimit);
															#line 2951 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		transactionStateResolveContext = TransactionStateResolveContext(&commitData, &addActor);
															#line 2953 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		;
															#line 15081 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CommitProxyServerCoreActor*>(this)->actor_wait_state > 0) static_cast<CommitProxyServerCoreActor*>(this)->actor_wait_state = 0;
		static_cast<CommitProxyServerCoreActor*>(this)->ActorCallback< CommitProxyServerCoreActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CommitProxyServerCoreActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitProxyServerCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CommitProxyServerCoreActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitProxyServerCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CommitProxyServerCoreActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CommitProxyServerCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1(int loopDepth) 
	{
															#line 2954 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_2 = dbInfoChange;
															#line 2953 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<CommitProxyServerCoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 15174 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when1(__when_expr_2.get(), loopDepth); };
															#line 2967 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_3 = onError;
															#line 15178 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when2(__when_expr_3.get(), loopDepth); };
															#line 2968 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		auto __when_expr_4 = batchedCommits.getFuture();
															#line 15182 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		static_assert(std::is_same<decltype(__when_expr_4), FutureStream<std::pair<std::vector<CommitTransactionRequest>, int>>>::value || std::is_same<decltype(__when_expr_4), ThreadFutureStream<std::pair<std::vector<CommitTransactionRequest>, int>>>::value, "invalid type");
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when3(__when_expr_4.pop(), loopDepth); };
															#line 2998 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		auto __when_expr_5 = proxy.proxySnapReq.getFuture();
															#line 15187 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		static_assert(std::is_same<decltype(__when_expr_5), FutureStream<ProxySnapRequest>>::value || std::is_same<decltype(__when_expr_5), ThreadFutureStream<ProxySnapRequest>>::value, "invalid type");
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when4(__when_expr_5.pop(), loopDepth); };
															#line 3002 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		auto __when_expr_6 = proxy.exclusionSafetyCheckReq.getFuture();
															#line 15192 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		static_assert(std::is_same<decltype(__when_expr_6), FutureStream<ExclusionSafetyCheckRequest>>::value || std::is_same<decltype(__when_expr_6), ThreadFutureStream<ExclusionSafetyCheckRequest>>::value, "invalid type");
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when5(__when_expr_6.pop(), loopDepth); };
															#line 3005 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		auto __when_expr_7 = proxy.txnState.getFuture();
															#line 15197 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		static_assert(std::is_same<decltype(__when_expr_7), FutureStream<TxnStateRequest>>::value || std::is_same<decltype(__when_expr_7), ThreadFutureStream<TxnStateRequest>>::value, "invalid type");
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when6(__when_expr_7.pop(), loopDepth); };
															#line 3008 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		auto __when_expr_8 = proxy.setThrottledShard.getFuture();
															#line 15202 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		static_assert(std::is_same<decltype(__when_expr_8), FutureStream<SetThrottledShardRequest>>::value || std::is_same<decltype(__when_expr_8), ThreadFutureStream<SetThrottledShardRequest>>::value, "invalid type");
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when7(__when_expr_8.pop(), loopDepth); };
		static_cast<CommitProxyServerCoreActor*>(this)->actor_wait_state = 3;
															#line 2954 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CommitProxyServerCoreActor, 2, Void >*>(static_cast<CommitProxyServerCoreActor*>(this)));
															#line 2967 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CommitProxyServerCoreActor, 3, Void >*>(static_cast<CommitProxyServerCoreActor*>(this)));
															#line 2968 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorSingleCallback< CommitProxyServerCoreActor, 4, std::pair<std::vector<CommitTransactionRequest>, int> >*>(static_cast<CommitProxyServerCoreActor*>(this)));
															#line 2998 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorSingleCallback< CommitProxyServerCoreActor, 5, ProxySnapRequest >*>(static_cast<CommitProxyServerCoreActor*>(this)));
															#line 3002 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorSingleCallback< CommitProxyServerCoreActor, 6, ExclusionSafetyCheckRequest >*>(static_cast<CommitProxyServerCoreActor*>(this)));
															#line 3005 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorSingleCallback< CommitProxyServerCoreActor, 7, TxnStateRequest >*>(static_cast<CommitProxyServerCoreActor*>(this)));
															#line 3008 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorSingleCallback< CommitProxyServerCoreActor, 8, SetThrottledShardRequest >*>(static_cast<CommitProxyServerCoreActor*>(this)));
															#line 15220 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void const& _,int loopDepth) 
	{
															#line 2955 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		dbInfoChange = commitData.db->onChange();
															#line 2956 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (masterLifetime.isEqual(commitData.db->get().masterLifetime) && commitData.db->get().recoveryState >= RecoveryState::RECOVERY_TRANSACTION)
															#line 15237 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 2958 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			commitData.logSystem = ILogSystem::fromServerDBInfo(proxy.id(), commitData.db->get(), false, addActor);
															#line 2959 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			for( auto it : commitData.tag_popped ) {
															#line 2960 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				commitData.logSystem->pop(it.second, it.first);
															#line 15245 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
															#line 2962 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			commitData.logSystem->popTxs(commitData.lastTxsPop, tagLocalityRemoteLog);
															#line 15249 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 2965 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		commitData.updateLatencyBandConfig(commitData.db->get().latencyBandConfig);
															#line 15253 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void && _,int loopDepth) 
	{
															#line 2955 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		dbInfoChange = commitData.db->onChange();
															#line 2956 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (masterLifetime.isEqual(commitData.db->get().masterLifetime) && commitData.db->get().recoveryState >= RecoveryState::RECOVERY_TRANSACTION)
															#line 15264 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 2958 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			commitData.logSystem = ILogSystem::fromServerDBInfo(proxy.id(), commitData.db->get(), false, addActor);
															#line 2959 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			for( auto it : commitData.tag_popped ) {
															#line 2960 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				commitData.logSystem->pop(it.second, it.first);
															#line 15272 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
															#line 2962 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			commitData.logSystem->popTxs(commitData.lastTxsPop, tagLocalityRemoteLog);
															#line 15276 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 2965 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		commitData.updateLatencyBandConfig(commitData.db->get().latencyBandConfig);
															#line 15280 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when3(std::pair<std::vector<CommitTransactionRequest>, int> const& batchedRequests,int loopDepth) 
	{
															#line 2984 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		const std::vector<CommitTransactionRequest>& trs = batchedRequests.first;
															#line 2985 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		const int batchBytes = batchedRequests.second;
															#line 2986 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (trs.size() || (commitData.db->get().recoveryState >= RecoveryState::ACCEPTING_COMMITS && masterLifetime.isEqual(commitData.db->get().masterLifetime) && lastCommitComplete.isReady()))
															#line 15305 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 2990 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			lastCommitComplete = commitBatch(&commitData, const_cast<std::vector<CommitTransactionRequest>*>(&batchedRequests.first), batchBytes);
															#line 2995 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			addActor.send(lastCommitComplete);
															#line 15311 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when3(std::pair<std::vector<CommitTransactionRequest>, int> && batchedRequests,int loopDepth) 
	{
															#line 2984 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		const std::vector<CommitTransactionRequest>& trs = batchedRequests.first;
															#line 2985 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		const int batchBytes = batchedRequests.second;
															#line 2986 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (trs.size() || (commitData.db->get().recoveryState >= RecoveryState::ACCEPTING_COMMITS && masterLifetime.isEqual(commitData.db->get().masterLifetime) && lastCommitComplete.isReady()))
															#line 15325 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 2990 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			lastCommitComplete = commitBatch(&commitData, const_cast<std::vector<CommitTransactionRequest>*>(&batchedRequests.first), batchBytes);
															#line 2995 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			addActor.send(lastCommitComplete);
															#line 15331 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when4(ProxySnapRequest const& snapReq,int loopDepth) 
	{
															#line 2999 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		TraceEvent(SevDebug, "SnapMasterEnqueue").log();
															#line 3000 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		addActor.send(proxySnapCreate(snapReq, &commitData));
															#line 15343 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when4(ProxySnapRequest && snapReq,int loopDepth) 
	{
															#line 2999 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		TraceEvent(SevDebug, "SnapMasterEnqueue").log();
															#line 3000 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		addActor.send(proxySnapCreate(snapReq, &commitData));
															#line 15354 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when5(ExclusionSafetyCheckRequest const& exclCheckReq,int loopDepth) 
	{
															#line 3003 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		addActor.send(proxyCheckSafeExclusion(db, exclCheckReq));
															#line 15363 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when5(ExclusionSafetyCheckRequest && exclCheckReq,int loopDepth) 
	{
															#line 3003 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		addActor.send(proxyCheckSafeExclusion(db, exclCheckReq));
															#line 15372 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when6(TxnStateRequest const& request,int loopDepth) 
	{
															#line 3006 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		addActor.send(processTransactionStateRequestPart(&transactionStateResolveContext, request));
															#line 15381 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when6(TxnStateRequest && request,int loopDepth) 
	{
															#line 3006 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		addActor.send(processTransactionStateRequestPart(&transactionStateResolveContext, request));
															#line 15390 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when7(SetThrottledShardRequest const& request,int loopDepth) 
	{
															#line 3009 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		for( auto& shard : request.throttledShards ) {
															#line 3010 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			auto it = commitData.hotShards.begin();
															#line 3011 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			for(;it != commitData.hotShards.end();++it) {
															#line 3012 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (it->first == shard)
															#line 15405 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				{
															#line 3013 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					it->second = request.expirationTime;
															#line 15409 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
					break;
				}
			}
															#line 3017 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (it == commitData.hotShards.end())
															#line 15415 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			{
															#line 3018 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				commitData.hotShards.emplace_back(std::make_pair(shard, request.expirationTime));
															#line 15419 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
		}
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when7(SetThrottledShardRequest && request,int loopDepth) 
	{
															#line 3009 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		for( auto& shard : request.throttledShards ) {
															#line 3010 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			auto it = commitData.hotShards.begin();
															#line 3011 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			for(;it != commitData.hotShards.end();++it) {
															#line 3012 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (it->first == shard)
															#line 15436 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				{
															#line 3013 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					it->second = request.expirationTime;
															#line 15440 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
					break;
				}
			}
															#line 3017 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (it == commitData.hotShards.end())
															#line 15446 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			{
															#line 3018 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				commitData.hotShards.emplace_back(std::make_pair(shard, request.expirationTime));
															#line 15450 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
		}
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CommitProxyServerCoreActor*>(this)->actor_wait_state > 0) static_cast<CommitProxyServerCoreActor*>(this)->actor_wait_state = 0;
		static_cast<CommitProxyServerCoreActor*>(this)->ActorCallback< CommitProxyServerCoreActor, 2, Void >::remove();
		static_cast<CommitProxyServerCoreActor*>(this)->ActorCallback< CommitProxyServerCoreActor, 3, Void >::remove();
		static_cast<CommitProxyServerCoreActor*>(this)->ActorSingleCallback< CommitProxyServerCoreActor, 4, std::pair<std::vector<CommitTransactionRequest>, int> >::remove();
		static_cast<CommitProxyServerCoreActor*>(this)->ActorSingleCallback< CommitProxyServerCoreActor, 5, ProxySnapRequest >::remove();
		static_cast<CommitProxyServerCoreActor*>(this)->ActorSingleCallback< CommitProxyServerCoreActor, 6, ExclusionSafetyCheckRequest >::remove();
		static_cast<CommitProxyServerCoreActor*>(this)->ActorSingleCallback< CommitProxyServerCoreActor, 7, TxnStateRequest >::remove();
		static_cast<CommitProxyServerCoreActor*>(this)->ActorSingleCallback< CommitProxyServerCoreActor, 8, SetThrottledShardRequest >::remove();

	}
	void a_callback_fire(ActorCallback< CommitProxyServerCoreActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitProxyServerCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CommitProxyServerCoreActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitProxyServerCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CommitProxyServerCoreActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CommitProxyServerCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CommitProxyServerCoreActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitProxyServerCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< CommitProxyServerCoreActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitProxyServerCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< CommitProxyServerCoreActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CommitProxyServerCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorSingleCallback< CommitProxyServerCoreActor, 4, std::pair<std::vector<CommitTransactionRequest>, int> >*,std::pair<std::vector<CommitTransactionRequest>, int> const& value) 
	{
		fdb_probe_actor_enter("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitProxyServerCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorSingleCallback< CommitProxyServerCoreActor, 4, std::pair<std::vector<CommitTransactionRequest>, int> >*,std::pair<std::vector<CommitTransactionRequest>, int> && value) 
	{
		fdb_probe_actor_enter("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitProxyServerCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorSingleCallback< CommitProxyServerCoreActor, 4, std::pair<std::vector<CommitTransactionRequest>, int> >*,Error err) 
	{
		fdb_probe_actor_enter("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CommitProxyServerCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorSingleCallback< CommitProxyServerCoreActor, 5, ProxySnapRequest >*,ProxySnapRequest const& value) 
	{
		fdb_probe_actor_enter("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitProxyServerCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when4(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorSingleCallback< CommitProxyServerCoreActor, 5, ProxySnapRequest >*,ProxySnapRequest && value) 
	{
		fdb_probe_actor_enter("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitProxyServerCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when4(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorSingleCallback< CommitProxyServerCoreActor, 5, ProxySnapRequest >*,Error err) 
	{
		fdb_probe_actor_enter("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CommitProxyServerCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorSingleCallback< CommitProxyServerCoreActor, 6, ExclusionSafetyCheckRequest >*,ExclusionSafetyCheckRequest const& value) 
	{
		fdb_probe_actor_enter("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitProxyServerCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when5(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorSingleCallback< CommitProxyServerCoreActor, 6, ExclusionSafetyCheckRequest >*,ExclusionSafetyCheckRequest && value) 
	{
		fdb_probe_actor_enter("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitProxyServerCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when5(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorSingleCallback< CommitProxyServerCoreActor, 6, ExclusionSafetyCheckRequest >*,Error err) 
	{
		fdb_probe_actor_enter("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CommitProxyServerCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorSingleCallback< CommitProxyServerCoreActor, 7, TxnStateRequest >*,TxnStateRequest const& value) 
	{
		fdb_probe_actor_enter("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitProxyServerCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when6(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorSingleCallback< CommitProxyServerCoreActor, 7, TxnStateRequest >*,TxnStateRequest && value) 
	{
		fdb_probe_actor_enter("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitProxyServerCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when6(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorSingleCallback< CommitProxyServerCoreActor, 7, TxnStateRequest >*,Error err) 
	{
		fdb_probe_actor_enter("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CommitProxyServerCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorSingleCallback< CommitProxyServerCoreActor, 8, SetThrottledShardRequest >*,SetThrottledShardRequest const& value) 
	{
		fdb_probe_actor_enter("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitProxyServerCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when7(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorSingleCallback< CommitProxyServerCoreActor, 8, SetThrottledShardRequest >*,SetThrottledShardRequest && value) 
	{
		fdb_probe_actor_enter("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitProxyServerCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when7(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorSingleCallback< CommitProxyServerCoreActor, 8, SetThrottledShardRequest >*,Error err) 
	{
		fdb_probe_actor_enter("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CommitProxyServerCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitProxyServerCore", reinterpret_cast<unsigned long>(this), 8);

	}
															#line 2834 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	CommitProxyInterface proxy;
															#line 2834 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	MasterInterface master;
															#line 2834 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	LifetimeToken masterLifetime;
															#line 2834 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> db;
															#line 2834 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	LogEpoch epoch;
															#line 2834 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Version recoveryTransactionVersion;
															#line 2834 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	bool firstProxy;
															#line 2834 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	std::string whitelistBinPaths;
															#line 2834 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	bool provisional;
															#line 2834 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	uint16_t commitProxyIndex;
															#line 2844 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ProxyCommitData commitData;
															#line 2855 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Future<Sequence> sequenceFuture;
															#line 2856 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	PromiseStream<std::pair<std::vector<CommitTransactionRequest>, int>> batchedCommits;
															#line 2857 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Future<Void> commitBatcherActor;
															#line 2858 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Future<Void> lastCommitComplete;
															#line 2860 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	PromiseStream<Future<Void>> addActor;
															#line 2861 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Future<Void> onError;
															#line 2874 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Future<Void> dbInfoChange;
															#line 2903 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	int64_t commitBatchesMemoryLimit;
															#line 2951 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	TransactionStateResolveContext transactionStateResolveContext;
															#line 15908 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via commitProxyServerCore()
															#line 2834 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class CommitProxyServerCoreActor final : public Actor<Void>, public ActorCallback< CommitProxyServerCoreActor, 0, Void >, public ActorCallback< CommitProxyServerCoreActor, 1, Void >, public ActorCallback< CommitProxyServerCoreActor, 2, Void >, public ActorCallback< CommitProxyServerCoreActor, 3, Void >, public ActorSingleCallback< CommitProxyServerCoreActor, 4, std::pair<std::vector<CommitTransactionRequest>, int> >, public ActorSingleCallback< CommitProxyServerCoreActor, 5, ProxySnapRequest >, public ActorSingleCallback< CommitProxyServerCoreActor, 6, ExclusionSafetyCheckRequest >, public ActorSingleCallback< CommitProxyServerCoreActor, 7, TxnStateRequest >, public ActorSingleCallback< CommitProxyServerCoreActor, 8, SetThrottledShardRequest >, public FastAllocated<CommitProxyServerCoreActor>, public CommitProxyServerCoreActorState<CommitProxyServerCoreActor> {
															#line 15913 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
	using FastAllocated<CommitProxyServerCoreActor>::operator new;
	using FastAllocated<CommitProxyServerCoreActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6975522747527132416UL, 12407769829019740928UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CommitProxyServerCoreActor, 0, Void >;
friend struct ActorCallback< CommitProxyServerCoreActor, 1, Void >;
friend struct ActorCallback< CommitProxyServerCoreActor, 2, Void >;
friend struct ActorCallback< CommitProxyServerCoreActor, 3, Void >;
friend struct ActorSingleCallback< CommitProxyServerCoreActor, 4, std::pair<std::vector<CommitTransactionRequest>, int> >;
friend struct ActorSingleCallback< CommitProxyServerCoreActor, 5, ProxySnapRequest >;
friend struct ActorSingleCallback< CommitProxyServerCoreActor, 6, ExclusionSafetyCheckRequest >;
friend struct ActorSingleCallback< CommitProxyServerCoreActor, 7, TxnStateRequest >;
friend struct ActorSingleCallback< CommitProxyServerCoreActor, 8, SetThrottledShardRequest >;
															#line 2834 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	CommitProxyServerCoreActor(CommitProxyInterface const& proxy,MasterInterface const& master,LifetimeToken const& masterLifetime,Reference<AsyncVar<ServerDBInfo> const> const& db,LogEpoch const& epoch,Version const& recoveryTransactionVersion,bool const& firstProxy,std::string const& whitelistBinPaths,bool const& provisional,uint16_t const& commitProxyIndex) 
															#line 15938 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   CommitProxyServerCoreActorState<CommitProxyServerCoreActor>(proxy, master, masterLifetime, db, epoch, recoveryTransactionVersion, firstProxy, whitelistBinPaths, provisional, commitProxyIndex),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("commitProxyServerCore", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13651068504771179520UL, 3876791042535516160UL);
		ActorExecutionContextHelper __helper(static_cast<CommitProxyServerCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("commitProxyServerCore");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("commitProxyServerCore", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CommitProxyServerCoreActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CommitProxyServerCoreActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CommitProxyServerCoreActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2834 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
[[nodiscard]] Future<Void> commitProxyServerCore( CommitProxyInterface const& proxy, MasterInterface const& master, LifetimeToken const& masterLifetime, Reference<AsyncVar<ServerDBInfo> const> const& db, LogEpoch const& epoch, Version const& recoveryTransactionVersion, bool const& firstProxy, std::string const& whitelistBinPaths, bool const& provisional, uint16_t const& commitProxyIndex ) {
															#line 2834 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	return Future<Void>(new CommitProxyServerCoreActor(proxy, master, masterLifetime, db, epoch, recoveryTransactionVersion, firstProxy, whitelistBinPaths, provisional, commitProxyIndex));
															#line 15973 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
}

#line 3025 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"

// only update the local Db info if the CP is not removed
															#line 15979 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via updateLocalDbInfo()
															#line 3027 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
template <class UpdateLocalDbInfoActor>
															#line 3027 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class UpdateLocalDbInfoActorState {
															#line 15986 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
															#line 3027 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	UpdateLocalDbInfoActorState(Reference<AsyncVar<ServerDBInfo> const> const& in,Reference<AsyncVar<ServerDBInfo>> const& out,uint64_t const& recoveryCount,CommitProxyInterface const& myInterface) 
															#line 3027 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
															#line 3027 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		 : in(in),
															#line 3027 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   out(out),
															#line 3027 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   recoveryCount(recoveryCount),
															#line 3027 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   myInterface(myInterface),
															#line 3032 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   firstValidDbInfo(false)
															#line 16001 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("updateLocalDbInfo", reinterpret_cast<unsigned long>(this));

	}
	~UpdateLocalDbInfoActorState() 
	{
		fdb_probe_actor_destroy("updateLocalDbInfo", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 3034 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			;
															#line 16016 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~UpdateLocalDbInfoActorState();
		static_cast<UpdateLocalDbInfoActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 3035 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		bool isIncluded = std::count(in->get().client.commitProxies.begin(), in->get().client.commitProxies.end(), myInterface);
															#line 3037 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (in->get().recoveryCount >= recoveryCount && !isIncluded)
															#line 16048 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 3038 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			return a_body1Catch1(worker_removed(), std::max(0, loopDepth - 1));
															#line 16052 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 3041 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (isIncluded)
															#line 16056 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 3042 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			firstValidDbInfo = true;
															#line 16060 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		}
															#line 3047 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (isIncluded || !firstValidDbInfo)
															#line 16064 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		{
															#line 3048 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			DisabledTraceEvent("UpdateLocalDbInfo", myInterface.id()) .detail("Provisional", myInterface.provisional) .detail("Included", isIncluded) .detail("FirstValid", firstValidDbInfo) .detail("ReceivedRC", in->get().recoveryCount) .detail("RecoveryCount", recoveryCount);
															#line 3054 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (in->get().recoveryCount >= out->get().recoveryCount)
															#line 16070 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			{
															#line 3055 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				out->set(in->get());
															#line 16074 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
		}
															#line 3059 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_0 = in->onChange();
															#line 3059 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<UpdateLocalDbInfoActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 16081 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<UpdateLocalDbInfoActor*>(this)->actor_wait_state = 1;
															#line 3059 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< UpdateLocalDbInfoActor, 0, Void >*>(static_cast<UpdateLocalDbInfoActor*>(this)));
															#line 16086 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UpdateLocalDbInfoActor*>(this)->actor_wait_state > 0) static_cast<UpdateLocalDbInfoActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateLocalDbInfoActor*>(this)->ActorCallback< UpdateLocalDbInfoActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateLocalDbInfoActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateLocalDbInfo", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateLocalDbInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateLocalDbInfo", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UpdateLocalDbInfoActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateLocalDbInfo", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateLocalDbInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateLocalDbInfo", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< UpdateLocalDbInfoActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateLocalDbInfo", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateLocalDbInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateLocalDbInfo", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 3027 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> in;
															#line 3027 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Reference<AsyncVar<ServerDBInfo>> out;
															#line 3027 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	uint64_t recoveryCount;
															#line 3027 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	CommitProxyInterface myInterface;
															#line 3032 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	bool firstValidDbInfo;
															#line 16188 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via updateLocalDbInfo()
															#line 3027 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class UpdateLocalDbInfoActor final : public Actor<Void>, public ActorCallback< UpdateLocalDbInfoActor, 0, Void >, public FastAllocated<UpdateLocalDbInfoActor>, public UpdateLocalDbInfoActorState<UpdateLocalDbInfoActor> {
															#line 16193 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
	using FastAllocated<UpdateLocalDbInfoActor>::operator new;
	using FastAllocated<UpdateLocalDbInfoActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7770606034810253056UL, 18318181301003981056UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< UpdateLocalDbInfoActor, 0, Void >;
															#line 3027 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	UpdateLocalDbInfoActor(Reference<AsyncVar<ServerDBInfo> const> const& in,Reference<AsyncVar<ServerDBInfo>> const& out,uint64_t const& recoveryCount,CommitProxyInterface const& myInterface) 
															#line 16210 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   UpdateLocalDbInfoActorState<UpdateLocalDbInfoActor>(in, out, recoveryCount, myInterface),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("updateLocalDbInfo", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7818349006170799616UL, 15165590002087843072UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateLocalDbInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("updateLocalDbInfo");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("updateLocalDbInfo", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< UpdateLocalDbInfoActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 3027 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
[[nodiscard]] Future<Void> updateLocalDbInfo( Reference<AsyncVar<ServerDBInfo> const> const& in, Reference<AsyncVar<ServerDBInfo>> const& out, uint64_t const& recoveryCount, CommitProxyInterface const& myInterface ) {
															#line 3027 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	return Future<Void>(new UpdateLocalDbInfoActor(in, out, recoveryCount, myInterface));
															#line 16243 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
}

#line 3062 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"

															#line 16248 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via commitProxyServer()
															#line 3063 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
template <class CommitProxyServerActor>
															#line 3063 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class CommitProxyServerActorState {
															#line 16255 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
															#line 3063 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	CommitProxyServerActorState(CommitProxyInterface const& proxy,InitializeCommitProxyRequest const& req,Reference<AsyncVar<ServerDBInfo> const> const& db,std::string const& whitelistBinPaths) 
															#line 3063 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
															#line 3063 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		 : proxy(proxy),
															#line 3063 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   req(req),
															#line 3063 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   db(db),
															#line 3063 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   whitelistBinPaths(whitelistBinPaths)
															#line 16268 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("commitProxyServer", reinterpret_cast<unsigned long>(this));

	}
	~CommitProxyServerActorState() 
	{
		fdb_probe_actor_destroy("commitProxyServer", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 3068 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				localDb = makeReference<AsyncVar<ServerDBInfo>>();
															#line 3069 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				core = commitProxyServerCore(proxy, req.master, req.masterLifetime, localDb, req.recoveryCount, req.recoveryTransactionVersion, req.firstProxy, whitelistBinPaths, proxy.provisional, req.commitProxyIndex);
															#line 3079 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				StrictFuture<Void> __when_expr_0 = core || updateLocalDbInfo(db, localDb, req.recoveryCount, proxy);
															#line 3079 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (static_cast<CommitProxyServerActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 16290 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<CommitProxyServerActor*>(this)->actor_wait_state = 1;
															#line 3079 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CommitProxyServerActor, 0, Void >*>(static_cast<CommitProxyServerActor*>(this)));
															#line 16295 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CommitProxyServerActorState();
		static_cast<CommitProxyServerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 3092 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!static_cast<CommitProxyServerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CommitProxyServerActorState(); static_cast<CommitProxyServerActor*>(this)->destroy(); return 0; }
															#line 16324 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		new (&static_cast<CommitProxyServerActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CommitProxyServerActorState();
		static_cast<CommitProxyServerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 3081 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			Severity sev = e.code() == error_code_failed_to_progress ? SevWarnAlways : SevInfo;
															#line 3082 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			TraceEvent(sev, "CommitProxyTerminated", proxy.id()).errorUnsuppressed(e);
															#line 3084 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (e.code() != error_code_worker_removed && e.code() != error_code_tlog_stopped && e.code() != error_code_tlog_failed && e.code() != error_code_coordinators_changed && e.code() != error_code_coordinated_state_conflict && e.code() != error_code_new_coordinators_timed_out && e.code() != error_code_failed_to_progress)
															#line 16341 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			{
															#line 3088 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 16345 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			}
															#line 3090 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			CODE_PROBE(e.code() == error_code_failed_to_progress, "Commit proxy failed to progress");
															#line 16349 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CommitProxyServerActor*>(this)->actor_wait_state > 0) static_cast<CommitProxyServerActor*>(this)->actor_wait_state = 0;
		static_cast<CommitProxyServerActor*>(this)->ActorCallback< CommitProxyServerActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CommitProxyServerActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("commitProxyServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitProxyServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitProxyServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CommitProxyServerActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("commitProxyServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitProxyServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitProxyServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CommitProxyServerActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("commitProxyServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CommitProxyServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitProxyServer", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 3063 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	CommitProxyInterface proxy;
															#line 3063 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	InitializeCommitProxyRequest req;
															#line 3063 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> db;
															#line 3063 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	std::string whitelistBinPaths;
															#line 3068 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Reference<AsyncVar<ServerDBInfo>> localDb;
															#line 3069 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Future<Void> core;
															#line 16472 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
};
// This generated class is to be used only via commitProxyServer()
															#line 3063 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class CommitProxyServerActor final : public Actor<Void>, public ActorCallback< CommitProxyServerActor, 0, Void >, public FastAllocated<CommitProxyServerActor>, public CommitProxyServerActorState<CommitProxyServerActor> {
															#line 16477 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
public:
	using FastAllocated<CommitProxyServerActor>::operator new;
	using FastAllocated<CommitProxyServerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14965710348756205056UL, 3923446013481043200UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CommitProxyServerActor, 0, Void >;
															#line 3063 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	CommitProxyServerActor(CommitProxyInterface const& proxy,InitializeCommitProxyRequest const& req,Reference<AsyncVar<ServerDBInfo> const> const& db,std::string const& whitelistBinPaths) 
															#line 16494 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   CommitProxyServerActorState<CommitProxyServerActor>(proxy, req, db, whitelistBinPaths),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("commitProxyServer", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12704666793118132224UL, 3593437101714446336UL);
		ActorExecutionContextHelper __helper(static_cast<CommitProxyServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("commitProxyServer");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("commitProxyServer", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CommitProxyServerActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 3063 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
[[nodiscard]] Future<Void> commitProxyServer( CommitProxyInterface const& proxy, InitializeCommitProxyRequest const& req, Reference<AsyncVar<ServerDBInfo> const> const& db, std::string const& whitelistBinPaths ) {
															#line 3063 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	return Future<Void>(new CommitProxyServerActor(proxy, req, db, whitelistBinPaths));
															#line 16527 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp.py_gen"
}

#line 3094 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"

void forceLinkCommitProxyTests() {}
