#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
/*
 * BackupWorker.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2026 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/BackupAgent.actor.h"
#include "fdbclient/BackupContainer.h"
#include "fdbclient/DatabaseContext.h"
#include "fdbclient/CommitProxyInterface.h"
#include "fdbclient/SystemData.h"
#include "fdbserver/BackupInterface.h"
#include "fdbserver/BackupProgress.actor.h"
#include "fdbserver/Knobs.h"
#include "fdbserver/LogProtocolMessage.h"
#include "fdbserver/LogSystem.h"
#include "fdbserver/ServerDBInfo.actor.h"
#include "fdbserver/ServerDBInfo.h"
#include "fdbserver/WaitFailure.h"
#include "fdbserver/WorkerInterface.actor.h"
#include "flow/Error.h"

#include "flow/IRandom.h"
#include "fdbclient/Tracing.h"
#include "flow/actorcompiler.h" // This must be the last #include.

#define SevDebugMemory SevVerbose

struct VersionedMessage {
	LogMessageVersion version;
	StringRef message;
	VectorRef<Tag> tags;
	Arena arena; // Keep a reference to the memory containing the message
	Arena decryptArena; // Arena used for decrypt buffer.

	VersionedMessage(LogMessageVersion v, StringRef m, const VectorRef<Tag>& t, const Arena& a)
	  : version(v), message(m), tags(t), arena(a) {}
	Version getVersion() const { return version.version; }
	uint32_t getSubVersion() const { return version.sub; }
	// Returns the estimated size of the message in bytes, assuming 6 tags.
	size_t getEstimatedSize() const { return message.size() + TagsAndMessage::getHeaderSize(6); }

	// Returns true if the message is a mutation
	bool isThisMessageMutation(MutationRef* m) {
		for (Tag tag : tags) {
			if (tag.locality == tagLocalitySpecial || tag.locality == tagLocalityTxs) {
				return false; // skip Txs mutations
			}
		}

		ArenaReader reader(arena, message, AssumeVersion(g_network->protocolVersion()));

		// Return false for LogProtocolMessage and SpanContextMessage metadata messages.
		if (LogProtocolMessage::isNextIn(reader))
			return false;
		if (reader.protocolVersion().hasSpanContext() && SpanContextMessage::isNextIn(reader))
			return false;
		if (reader.protocolVersion().hasOTELSpanContext() && OTELSpanContextMessage::isNextIn(reader)) {
			CODE_PROBE(true, "Returning false for OTELSpanContextMessage");
			return false;
		}

		reader >> *m;
		return true;
	}

	// Returns true if the message is a mutation that could be backed up (normal keys, system key backup ranges, or the
	// metadata version key)
	bool isCandidateBackupMessage(MutationRef* m) {
		if (!isThisMessageMutation(m))
			return false;

		// Return true if the mutation intersects any legal backup ranges
		if (normalKeys.contains(m->param1) || m->param1 == metadataVersionKey) {
			return true;
		} else if (m->type != MutationRef::Type::ClearRange) {
			return systemBackupMutationMask().rangeContaining(m->param1).value();
		} else {
			for (auto& r : systemBackupMutationMask().intersectingRanges(KeyRangeRef(m->param1, m->param2))) {
				if (r->value()) {
					return true;
				}
			}

			return false;
		}
	}
};

struct BackupData {
	const UID myId;
	const Tag tag; // LogRouter tag for this worker, i.e., (-2, i)
	const int totalTags; // Total log router tags
	const Version startVersion; // This worker's start version
	const Optional<Version> endVersion; // old epoch's end version (inclusive), or empty for current epoch
	const LogEpoch recruitedEpoch; // current epoch whose tLogs are receiving mutations
	const LogEpoch backupEpoch; // the epoch workers should pull mutations
	LogEpoch oldestBackupEpoch = 0; // oldest epoch that still has data on tLogs for backup to pull
	Version minKnownCommittedVersion;
	Version savedVersion; // Largest version saved to blob storage
	Version popVersion; // Largest version popped in NOOP mode, can be larger than savedVersion.
	Reference<AsyncVar<ServerDBInfo> const> db;
	AsyncVar<Reference<ILogSystem>> logSystem;
	Database cx;
	std::vector<VersionedMessage> messages;
	NotifiedVersion pulledVersion;
	bool pulling = false;
	bool stopped = false;
	bool exitEarly = false; // If the worker is on an old epoch and all backups starts a version >= the endVersion
	AsyncVar<bool> paused; // Track if "backupPausedKey" is set.
	Reference<FlowLock> lock;

	struct PerBackupInfo {
		PerBackupInfo() = default;
		PerBackupInfo(BackupData* data, UID uid, Version v) : self(data), startVersion(v) {
			// Open the container and get key ranges
			BackupConfig config(uid);
			container = config.backupContainer().get(data->cx.getReference());
			ranges = config.backupRanges().get(data->cx.getReference());
			if (self->backupEpoch == self->recruitedEpoch) {
				// Only current epoch's worker update the number of backup workers.
				updateWorker = _updateStartedWorkers(this, data, uid);
			}
			TraceEvent("BackupWorkerAddJob", data->myId).detail("BackupID", uid).detail("Version", v);
		}

		void stop() {
			stopped = true;
			updateWorker = Void(); // cancel actors
		}

		void cancelUpdater() { updateWorker = Void(); }

		bool isReady() const { return stopped || (container.isReady() && ranges.isReady()); }

		Future<Void> waitReady() {
			if (stopped)
				return Void();
			return _waitReady(this);
		}

																	#line 158 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
// This generated class is to be used only via _waitReady()
															#line 156 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
template <class _waitReadyActor>
															#line 156 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
class _waitReadyActorState {
															#line 164 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
public:
															#line 156 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	_waitReadyActorState(PerBackupInfo* const& info) 
															#line 156 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
															#line 156 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		 : info(info)
															#line 171 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("_waitReady", reinterpret_cast<unsigned long>(this));

	}
	~_waitReadyActorState() 
	{
		fdb_probe_actor_destroy("_waitReady", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 157 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			StrictFuture<Void> __when_expr_0 = success(info->container) && success(info->ranges);
															#line 157 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (static_cast<_waitReadyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 188 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_waitReadyActor*>(this)->actor_wait_state = 1;
															#line 157 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _waitReadyActor, 0, Void >*>(static_cast<_waitReadyActor*>(this)));
															#line 193 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_waitReadyActorState();
		static_cast<_waitReadyActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 158 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (!static_cast<_waitReadyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_waitReadyActorState(); static_cast<_waitReadyActor*>(this)->destroy(); return 0; }
															#line 216 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		new (&static_cast<_waitReadyActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_waitReadyActorState();
		static_cast<_waitReadyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 158 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (!static_cast<_waitReadyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_waitReadyActorState(); static_cast<_waitReadyActor*>(this)->destroy(); return 0; }
															#line 228 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		new (&static_cast<_waitReadyActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_waitReadyActorState();
		static_cast<_waitReadyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_waitReadyActor*>(this)->actor_wait_state > 0) static_cast<_waitReadyActor*>(this)->actor_wait_state = 0;
		static_cast<_waitReadyActor*>(this)->ActorCallback< _waitReadyActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _waitReadyActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_waitReady", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_waitReadyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_waitReady", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _waitReadyActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_waitReady", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_waitReadyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_waitReady", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _waitReadyActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_waitReady", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_waitReadyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_waitReady", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 156 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	PerBackupInfo* info;
															#line 313 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
};
// This generated class is to be used only via _waitReady()
															#line 156 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
class _waitReadyActor final : public Actor<Void>, public ActorCallback< _waitReadyActor, 0, Void >, public FastAllocated<_waitReadyActor>, public _waitReadyActorState<_waitReadyActor> {
															#line 318 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
public:
	using FastAllocated<_waitReadyActor>::operator new;
	using FastAllocated<_waitReadyActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6139071313430524160UL, 8287759136208663296UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _waitReadyActor, 0, Void >;
															#line 156 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	_waitReadyActor(PerBackupInfo* const& info) 
															#line 335 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   _waitReadyActorState<_waitReadyActor>(info),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_waitReady", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2841224896791291648UL, 2872305995651855104UL);
		ActorExecutionContextHelper __helper(static_cast<_waitReadyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_waitReady");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_waitReady", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _waitReadyActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 156 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
[[nodiscard]] static Future<Void> _waitReady( PerBackupInfo* const& info ) {
															#line 156 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	return Future<Void>(new _waitReadyActor(info));
															#line 367 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
}

#line 160 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"

		// Update the number of backup workers in the BackupConfig. Each worker
		// writes (epoch, tag.id) into the key. Worker 0 monitors the key and once
		// all workers have updated the key, this backup is considered as started
		// (i.e., the "submitBackup" call is successful). Worker 0 then sets
		// the "allWorkerStarted" flag, which in turn unblocks
		// StartFullBackupTaskFunc::_execute.
																	#line 378 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
// This generated class is to be used only via _updateStartedWorkers()
															#line 167 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
template <class _updateStartedWorkersActor>
															#line 167 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
class _updateStartedWorkersActorState {
															#line 384 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
public:
															#line 167 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	_updateStartedWorkersActorState(PerBackupInfo* const& info,BackupData* const& self,UID const& uid) 
															#line 167 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
															#line 167 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		 : info(info),
															#line 167 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   self(self),
															#line 167 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   uid(uid),
															#line 168 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   config(uid),
															#line 169 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   watchFuture(),
															#line 170 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   updated(false),
															#line 171 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   firstWorker(info->self->tag.id == 0),
															#line 172 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   allUpdated(false),
															#line 173 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   workers(),
															#line 174 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   tr(new ReadYourWritesTransaction(self->cx))
															#line 409 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("_updateStartedWorkers", reinterpret_cast<unsigned long>(this));

	}
	~_updateStartedWorkersActorState() 
	{
		fdb_probe_actor_destroy("_updateStartedWorkers", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 176 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			;
															#line 424 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_updateStartedWorkersActorState();
		static_cast<_updateStartedWorkersActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 245 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		TraceEvent("BackupWorkerSetReady", self->myId).detail("BackupID", uid).detail("TagId", self->tag.id);
															#line 246 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (!static_cast<_updateStartedWorkersActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_updateStartedWorkersActorState(); static_cast<_updateStartedWorkersActor*>(this)->destroy(); return 0; }
															#line 449 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		new (&static_cast<_updateStartedWorkersActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_updateStartedWorkersActorState();
		static_cast<_updateStartedWorkersActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 178 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 179 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 180 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			tr->setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 182 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			StrictFuture<Optional<std::vector<std::pair<int64_t, int64_t>>>> __when_expr_0 = config.startedBackupWorkers().get(tr);
															#line 182 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (static_cast<_updateStartedWorkersActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 477 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_updateStartedWorkersActor*>(this)->actor_wait_state = 1;
															#line 182 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _updateStartedWorkersActor, 0, Optional<std::vector<std::pair<int64_t, int64_t>>> >*>(static_cast<_updateStartedWorkersActor*>(this)));
															#line 482 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 241 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			StrictFuture<Void> __when_expr_4 = tr->onError(e);
															#line 241 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (static_cast<_updateStartedWorkersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 519 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_4.get(), loopDepth); };
			static_cast<_updateStartedWorkersActor*>(this)->actor_wait_state = 5;
															#line 241 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _updateStartedWorkersActor, 4, Void >*>(static_cast<_updateStartedWorkersActor*>(this)));
															#line 524 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<std::vector<std::pair<int64_t, int64_t>>> const& tmp,int loopDepth) 
	{
															#line 184 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		workers = tmp;
															#line 185 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (!updated)
															#line 541 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		{
															#line 186 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (workers.present())
															#line 545 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			{
															#line 187 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
				workers.get().emplace_back(self->recruitedEpoch, (int64_t)self->tag.id);
															#line 549 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			}
			else
			{
															#line 189 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
				std::vector<std::pair<int64_t, int64_t>> v(1, { self->recruitedEpoch, self->tag.id });
															#line 190 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
				workers = Optional<std::vector<std::pair<int64_t, int64_t>>>(v);
															#line 557 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			}
		}
															#line 193 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (firstWorker)
															#line 562 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		{
															#line 194 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (!workers.present())
															#line 566 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			{
															#line 195 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
				TraceEvent("BackupWorkerDetectAbortedJob", self->myId).detail("BackupID", uid);
															#line 196 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
				if (!static_cast<_updateStartedWorkersActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_updateStartedWorkersActorState(); static_cast<_updateStartedWorkersActor*>(this)->destroy(); return 0; }
															#line 572 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
				new (&static_cast<_updateStartedWorkersActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~_updateStartedWorkersActorState();
				static_cast<_updateStartedWorkersActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 198 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			ASSERT(workers.present() && workers.get().size() > 0);
															#line 199 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			std::vector<std::pair<int64_t, int64_t>>& v = workers.get();
															#line 200 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			v.erase(std::remove_if(v.begin(), v.end(), [epoch = self->recruitedEpoch](const std::pair<int64_t, int64_t>& p) { return p.first != epoch; }), v.end());
															#line 206 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			std::set<int64_t> tags;
															#line 207 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			for( auto p : v ) {
															#line 208 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
				tags.insert(p.second);
															#line 590 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			}
															#line 210 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (self->totalTags == tags.size())
															#line 594 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			{
															#line 211 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
				config.allWorkerStarted().set(tr, true);
															#line 212 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
				allUpdated = true;
															#line 600 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			}
			else
			{
															#line 215 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
				watchFuture = tr->watch(config.startedBackupWorkers().key);
															#line 606 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			}
															#line 217 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			ASSERT(workers.present() && workers.get().size() > 0);
															#line 218 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (!updated)
															#line 612 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			{
															#line 219 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
				config.startedBackupWorkers().set(tr, workers.get());
															#line 616 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			}
															#line 221 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			for( auto p : workers.get() ) {
															#line 222 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
				TraceEvent("BackupWorkerDebugTag", self->myId) .detail("Epoch", p.first) .detail("TagID", p.second);
															#line 622 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			}
															#line 226 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr->commit();
															#line 226 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (static_cast<_updateStartedWorkersActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 628 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<_updateStartedWorkersActor*>(this)->actor_wait_state = 2;
															#line 226 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _updateStartedWorkersActor, 1, Void >*>(static_cast<_updateStartedWorkersActor*>(this)));
															#line 633 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
															#line 235 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			ASSERT(workers.present() && workers.get().size() > 0);
															#line 236 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			config.startedBackupWorkers().set(tr, workers.get());
															#line 237 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr->commit();
															#line 237 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (static_cast<_updateStartedWorkersActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 646 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont2when2(__when_expr_3.get(), loopDepth); };
			static_cast<_updateStartedWorkersActor*>(this)->actor_wait_state = 4;
															#line 237 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _updateStartedWorkersActor, 3, Void >*>(static_cast<_updateStartedWorkersActor*>(this)));
															#line 651 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<std::vector<std::pair<int64_t, int64_t>>> && tmp,int loopDepth) 
	{
															#line 184 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		workers = tmp;
															#line 185 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (!updated)
															#line 663 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		{
															#line 186 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (workers.present())
															#line 667 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			{
															#line 187 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
				workers.get().emplace_back(self->recruitedEpoch, (int64_t)self->tag.id);
															#line 671 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			}
			else
			{
															#line 189 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
				std::vector<std::pair<int64_t, int64_t>> v(1, { self->recruitedEpoch, self->tag.id });
															#line 190 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
				workers = Optional<std::vector<std::pair<int64_t, int64_t>>>(v);
															#line 679 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			}
		}
															#line 193 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (firstWorker)
															#line 684 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		{
															#line 194 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (!workers.present())
															#line 688 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			{
															#line 195 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
				TraceEvent("BackupWorkerDetectAbortedJob", self->myId).detail("BackupID", uid);
															#line 196 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
				if (!static_cast<_updateStartedWorkersActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_updateStartedWorkersActorState(); static_cast<_updateStartedWorkersActor*>(this)->destroy(); return 0; }
															#line 694 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
				new (&static_cast<_updateStartedWorkersActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~_updateStartedWorkersActorState();
				static_cast<_updateStartedWorkersActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 198 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			ASSERT(workers.present() && workers.get().size() > 0);
															#line 199 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			std::vector<std::pair<int64_t, int64_t>>& v = workers.get();
															#line 200 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			v.erase(std::remove_if(v.begin(), v.end(), [epoch = self->recruitedEpoch](const std::pair<int64_t, int64_t>& p) { return p.first != epoch; }), v.end());
															#line 206 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			std::set<int64_t> tags;
															#line 207 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			for( auto p : v ) {
															#line 208 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
				tags.insert(p.second);
															#line 712 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			}
															#line 210 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (self->totalTags == tags.size())
															#line 716 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			{
															#line 211 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
				config.allWorkerStarted().set(tr, true);
															#line 212 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
				allUpdated = true;
															#line 722 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			}
			else
			{
															#line 215 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
				watchFuture = tr->watch(config.startedBackupWorkers().key);
															#line 728 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			}
															#line 217 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			ASSERT(workers.present() && workers.get().size() > 0);
															#line 218 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (!updated)
															#line 734 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			{
															#line 219 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
				config.startedBackupWorkers().set(tr, workers.get());
															#line 738 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			}
															#line 221 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			for( auto p : workers.get() ) {
															#line 222 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
				TraceEvent("BackupWorkerDebugTag", self->myId) .detail("Epoch", p.first) .detail("TagID", p.second);
															#line 744 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			}
															#line 226 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr->commit();
															#line 226 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (static_cast<_updateStartedWorkersActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 750 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<_updateStartedWorkersActor*>(this)->actor_wait_state = 2;
															#line 226 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _updateStartedWorkersActor, 1, Void >*>(static_cast<_updateStartedWorkersActor*>(this)));
															#line 755 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
															#line 235 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			ASSERT(workers.present() && workers.get().size() > 0);
															#line 236 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			config.startedBackupWorkers().set(tr, workers.get());
															#line 237 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr->commit();
															#line 237 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (static_cast<_updateStartedWorkersActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 768 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont2when2(__when_expr_3.get(), loopDepth); };
			static_cast<_updateStartedWorkersActor*>(this)->actor_wait_state = 4;
															#line 237 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _updateStartedWorkersActor, 3, Void >*>(static_cast<_updateStartedWorkersActor*>(this)));
															#line 773 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<std::vector<std::pair<int64_t, int64_t>>> const& tmp,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(tmp, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<std::vector<std::pair<int64_t, int64_t>>> && tmp,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(tmp), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_updateStartedWorkersActor*>(this)->actor_wait_state > 0) static_cast<_updateStartedWorkersActor*>(this)->actor_wait_state = 0;
		static_cast<_updateStartedWorkersActor*>(this)->ActorCallback< _updateStartedWorkersActor, 0, Optional<std::vector<std::pair<int64_t, int64_t>>> >::remove();

	}
	void a_callback_fire(ActorCallback< _updateStartedWorkersActor, 0, Optional<std::vector<std::pair<int64_t, int64_t>>> >*,Optional<std::vector<std::pair<int64_t, int64_t>>> const& value) 
	{
		fdb_probe_actor_enter("_updateStartedWorkers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_updateStartedWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_updateStartedWorkers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _updateStartedWorkersActor, 0, Optional<std::vector<std::pair<int64_t, int64_t>>> >*,Optional<std::vector<std::pair<int64_t, int64_t>>> && value) 
	{
		fdb_probe_actor_enter("_updateStartedWorkers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_updateStartedWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_updateStartedWorkers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _updateStartedWorkersActor, 0, Optional<std::vector<std::pair<int64_t, int64_t>>> >*,Error err) 
	{
		fdb_probe_actor_enter("_updateStartedWorkers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_updateStartedWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_updateStartedWorkers", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont17(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont7(Void const& _,int loopDepth) 
	{
															#line 228 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		updated = true;
															#line 229 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (allUpdated)
															#line 866 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 232 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		StrictFuture<Void> __when_expr_2 = watchFuture;
															#line 232 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (static_cast<_updateStartedWorkersActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 874 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont7when1(__when_expr_2.get(), loopDepth); };
		static_cast<_updateStartedWorkersActor*>(this)->actor_wait_state = 3;
															#line 232 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _updateStartedWorkersActor, 2, Void >*>(static_cast<_updateStartedWorkersActor*>(this)));
															#line 879 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont7(Void && _,int loopDepth) 
	{
															#line 228 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		updated = true;
															#line 229 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (allUpdated)
															#line 890 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 232 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		StrictFuture<Void> __when_expr_2 = watchFuture;
															#line 232 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (static_cast<_updateStartedWorkersActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 898 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont7when1(__when_expr_2.get(), loopDepth); };
		static_cast<_updateStartedWorkersActor*>(this)->actor_wait_state = 3;
															#line 232 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _updateStartedWorkersActor, 2, Void >*>(static_cast<_updateStartedWorkersActor*>(this)));
															#line 903 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_updateStartedWorkersActor*>(this)->actor_wait_state > 0) static_cast<_updateStartedWorkersActor*>(this)->actor_wait_state = 0;
		static_cast<_updateStartedWorkersActor*>(this)->ActorCallback< _updateStartedWorkersActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _updateStartedWorkersActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_updateStartedWorkers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_updateStartedWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_updateStartedWorkers", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _updateStartedWorkersActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_updateStartedWorkers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_updateStartedWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_updateStartedWorkers", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _updateStartedWorkersActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_updateStartedWorkers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_updateStartedWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_updateStartedWorkers", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont14(Void const& _,int loopDepth) 
	{
															#line 233 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		tr->reset();
															#line 987 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont14(Void && _,int loopDepth) 
	{
															#line 233 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		tr->reset();
															#line 996 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont7when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont14(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont7when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont14(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_updateStartedWorkersActor*>(this)->actor_wait_state > 0) static_cast<_updateStartedWorkersActor*>(this)->actor_wait_state = 0;
		static_cast<_updateStartedWorkersActor*>(this)->ActorCallback< _updateStartedWorkersActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _updateStartedWorkersActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_updateStartedWorkers", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_updateStartedWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_updateStartedWorkers", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _updateStartedWorkersActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_updateStartedWorkers", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_updateStartedWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_updateStartedWorkers", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _updateStartedWorkersActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_updateStartedWorkers", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_updateStartedWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_updateStartedWorkers", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont16(Void const& _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont16(Void && _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont16(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont16(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<_updateStartedWorkersActor*>(this)->actor_wait_state > 0) static_cast<_updateStartedWorkersActor*>(this)->actor_wait_state = 0;
		static_cast<_updateStartedWorkersActor*>(this)->ActorCallback< _updateStartedWorkersActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _updateStartedWorkersActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_updateStartedWorkers", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_updateStartedWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont2when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_updateStartedWorkers", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _updateStartedWorkersActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_updateStartedWorkers", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_updateStartedWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont2when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_updateStartedWorkers", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< _updateStartedWorkersActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_updateStartedWorkers", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_updateStartedWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_updateStartedWorkers", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont17(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
															#line 242 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		allUpdated = false;
															#line 1180 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
															#line 242 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		allUpdated = false;
															#line 1189 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<_updateStartedWorkersActor*>(this)->actor_wait_state > 0) static_cast<_updateStartedWorkersActor*>(this)->actor_wait_state = 0;
		static_cast<_updateStartedWorkersActor*>(this)->ActorCallback< _updateStartedWorkersActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _updateStartedWorkersActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_updateStartedWorkers", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_updateStartedWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_updateStartedWorkers", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< _updateStartedWorkersActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_updateStartedWorkers", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_updateStartedWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_updateStartedWorkers", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< _updateStartedWorkersActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_updateStartedWorkers", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_updateStartedWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_updateStartedWorkers", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 167 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	PerBackupInfo* info;
															#line 167 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	BackupData* self;
															#line 167 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	UID uid;
															#line 168 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	BackupConfig config;
															#line 169 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	Future<Void> watchFuture;
															#line 170 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	bool updated;
															#line 171 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	bool firstWorker;
															#line 172 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	bool allUpdated;
															#line 173 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	Optional<std::vector<std::pair<int64_t, int64_t>>> workers;
															#line 174 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 1289 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
};
// This generated class is to be used only via _updateStartedWorkers()
															#line 167 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
class _updateStartedWorkersActor final : public Actor<Void>, public ActorCallback< _updateStartedWorkersActor, 0, Optional<std::vector<std::pair<int64_t, int64_t>>> >, public ActorCallback< _updateStartedWorkersActor, 1, Void >, public ActorCallback< _updateStartedWorkersActor, 2, Void >, public ActorCallback< _updateStartedWorkersActor, 3, Void >, public ActorCallback< _updateStartedWorkersActor, 4, Void >, public FastAllocated<_updateStartedWorkersActor>, public _updateStartedWorkersActorState<_updateStartedWorkersActor> {
															#line 1294 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
public:
	using FastAllocated<_updateStartedWorkersActor>::operator new;
	using FastAllocated<_updateStartedWorkersActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13345401053305126144UL, 3155839625223220736UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _updateStartedWorkersActor, 0, Optional<std::vector<std::pair<int64_t, int64_t>>> >;
friend struct ActorCallback< _updateStartedWorkersActor, 1, Void >;
friend struct ActorCallback< _updateStartedWorkersActor, 2, Void >;
friend struct ActorCallback< _updateStartedWorkersActor, 3, Void >;
friend struct ActorCallback< _updateStartedWorkersActor, 4, Void >;
															#line 167 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	_updateStartedWorkersActor(PerBackupInfo* const& info,BackupData* const& self,UID const& uid) 
															#line 1315 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   _updateStartedWorkersActorState<_updateStartedWorkersActor>(info, self, uid),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_updateStartedWorkers", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15701260814676215808UL, 3300621109131050240UL);
		ActorExecutionContextHelper __helper(static_cast<_updateStartedWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_updateStartedWorkers");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_updateStartedWorkers", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _updateStartedWorkersActor, 0, Optional<std::vector<std::pair<int64_t, int64_t>>> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _updateStartedWorkersActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _updateStartedWorkersActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< _updateStartedWorkersActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< _updateStartedWorkersActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 167 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
[[nodiscard]] static Future<Void> _updateStartedWorkers( PerBackupInfo* const& info, BackupData* const& self, UID const& uid ) {
															#line 167 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	return Future<Void>(new _updateStartedWorkersActor(info, self, uid));
															#line 1351 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
}

#line 248 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"

		BackupData* self = nullptr;

		// Backup request's commit version. Mutations are logged at some version after this.
		Version startVersion = invalidVersion;
		// The last mutation log's saved version (not inclusive), i.e., next log's begin version.
		Version lastSavedVersion = invalidVersion;

		Future<Optional<Reference<IBackupContainer>>> container;
		Future<Optional<std::vector<KeyRange>>> ranges; // Key ranges of this backup
		Future<Void> updateWorker;
		bool stopped = false; // Is the backup stopped?
	};

	std::map<UID, PerBackupInfo> backups; // Backup UID to infos
	AsyncTrigger changedTrigger;
	AsyncTrigger doneTrigger;

	CounterCollection cc;
	Future<Void> logger;
	Future<Void> noopPopper; // holds actor to save progress in NOOP mode
	AsyncVar<Version> popTrigger; // trigger to pop version in NOOP mode

	explicit BackupData(UID id, Reference<AsyncVar<ServerDBInfo> const> db, const InitializeBackupRequest& req)
	  : myId(id), tag(req.routerTag), totalTags(req.totalTags), startVersion(req.startVersion),
	    endVersion(req.endVersion), recruitedEpoch(req.recruitedEpoch), backupEpoch(req.backupEpoch),
	    minKnownCommittedVersion(invalidVersion), savedVersion(req.startVersion - 1), popVersion(req.startVersion - 1),
	    db(db), pulledVersion(0), paused(false), lock(new FlowLock(SERVER_KNOBS->BACKUP_WORKER_LOCK_BYTES)),
	    cc("BackupWorker", myId.toString()) {
		cx = openDBOnServer(db, TaskPriority::DefaultEndpoint, LockAware::True);

		specialCounter(cc, "SavedVersion", [this]() { return this->savedVersion; });
		specialCounter(cc, "MinKnownCommittedVersion", [this]() { return this->minKnownCommittedVersion; });
		specialCounter(cc, "MsgQ", [this]() { return this->messages.size(); });
		specialCounter(cc, "BufferedBytes", [this]() { return this->lock->activePermits(); });
		specialCounter(cc, "AvailableBytes", [this]() { return this->lock->available(); });
		logger =
		    cc.traceCounters("BackupWorkerMetrics", myId, SERVER_KNOBS->WORKER_LOGGING_INTERVAL, "BackupWorkerMetrics");
		popTrigger.set(invalidVersion);
		noopPopper = _noopPopper(this);
	}

	bool pullFinished() const { return endVersion.present() && pulledVersion.get() > endVersion.get(); }

	bool allMessageSaved() const {
		return (endVersion.present() && savedVersion >= endVersion.get()) || stopped || exitEarly;
	}

	Version maxPopVersion() const { return endVersion.present() ? endVersion.get() : minKnownCommittedVersion; }

	// Inserts a backup's single range into rangeMap.
	template <class T>
	void insertRange(KeyRangeMap<std::set<T>>& keyRangeMap, KeyRangeRef range, T value) {
		for (auto& logRange : keyRangeMap.modify(range)) {
			logRange->value().insert(value);
		}
		for (auto& logRange : keyRangeMap.modify(singleKeyRange(metadataVersionKey))) {
			logRange->value().insert(value);
		}
		TraceEvent("BackupWorkerInsertRange", myId)
		    .detail("Value", value)
		    .detail("Begin", range.begin)
		    .detail("End", range.end);
	}

	// Inserts a backup's ranges into rangeMap.
	template <class T>
	void insertRanges(KeyRangeMap<std::set<T>>& keyRangeMap, const Optional<std::vector<KeyRange>>& ranges, T value) {
		if (!ranges.present() || ranges.get().empty()) {
			// insert full ranges of normal keys
			return insertRange(keyRangeMap, normalKeys, value);
		}
		for (const auto& range : ranges.get()) {
			insertRange(keyRangeMap, range, value);
		}
	}

	void pop() {
		if (backupEpoch > oldestBackupEpoch || stopped) {
			// Defer pop if old epoch hasn't finished popping yet.
			// If stopped because of displacement, do NOT pop as the progress may
			// not be saved in a timely fashion. As a result, next epoch may still
			// need to read mutations in the version range. Let the next epoch's
			// worker do the pop instead.
			TraceEvent("BackupWorkerPopDeferred", myId)
			    .suppressFor(1.0)
			    .detail("BackupEpoch", backupEpoch)
			    .detail("OldestEpoch", oldestBackupEpoch)
			    .detail("Version", savedVersion);
			return;
		}
		ASSERT_WE_THINK(backupEpoch == oldestBackupEpoch);
		const Tag popTag = logSystem.get()->getPseudoPopTag(tag, ProcessClass::BackupClass);
		DisabledTraceEvent("BackupWorkerPop", myId)
		    .detail("Tag", popTag)
		    .detail("SavedVersion", savedVersion)
		    .detail("PopVersion", popVersion);
		logSystem.get()->pop(std::max(popVersion, savedVersion), popTag);
	}

	void stop() {
		stopped = true;
		for (auto& [uid, info] : backups) {
			// Cancel the actor. Because container is valid, CANNOT set the
			// "stop" flag that will block writing mutation files in
			// saveMutationsToFile().
			info.cancelUpdater();
		}
		doneTrigger.trigger();
	}

	// Erases messages and updates lock with memory released.
	void eraseMessages(int num) {
		ASSERT(num <= messages.size());
		if (num == 0)
			return;

		// Accumulate erased message sizes
		int64_t bytes = 0;
		for (int i = 0; i < num; i++) {
			bytes += messages[i].getEstimatedSize();
		}
		TraceEvent(SevDebugMemory, "BackupWorkerMemory", myId)
		    .detail("Release", bytes)
		    .detail("Total", lock->activePermits());
		lock->release(bytes);
		messages.erase(messages.begin(), messages.begin() + num);
	}

	void eraseMessagesAfterEndVersion() {
		ASSERT(endVersion.present());
		const Version ver = endVersion.get();
		while (!messages.empty()) {
			if (messages.back().getVersion() > ver) {
				size_t bytes = messages.back().getEstimatedSize();
				TraceEvent(SevDebugMemory, "BackupWorkerMemory", myId).detail("Release", bytes);
				lock->release(bytes);
				messages.pop_back();
			} else {
				return;
			}
		}
	}

	// Give a list of current active backups, compare with current list and decide
	// to start new backups and stop ones not in the active state.
	void onBackupChanges(const std::vector<std::pair<UID, Version>>& uidVersions) {
		std::set<UID> stopList;
		for (auto it : backups) {
			stopList.insert(it.first);
		}

		bool modified = false;
		bool minVersionChanged = false;
		Version minVersion = std::numeric_limits<Version>::max();
		for (const auto& [uid, version] : uidVersions) {
			auto it = backups.find(uid);
			if (it == backups.end()) {
				modified = true;
				backups.emplace(uid, BackupData::PerBackupInfo(this, uid, version));
				minVersion = std::min(minVersion, version);
				minVersionChanged = true;
			} else {
				stopList.erase(uid);
			}
		}

		for (UID uid : stopList) {
			auto it = backups.find(uid);
			ASSERT(it != backups.end());
			it->second.stop();
			modified = true;
		}
		if (minVersionChanged && backupEpoch < recruitedEpoch && savedVersion + 1 == startVersion) {
			// Advance savedVersion to minimize version ranges in case backupEpoch's
			// progress is not saved. Master may set a very low startVersion that
			// is already popped. Advance the version is safe because these
			// versions are not popped -- if they are popped, their progress should
			// be already recorded and Master would use a higher version than minVersion.
			savedVersion = std::max(minVersion, savedVersion);
		}
		if (modified)
			changedTrigger.trigger();
	}

	// Update the NOOP popped version so that when backup is started or resumed,
	// the worker can ignore any versions that are already popped.
																#line 1542 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
// This generated class is to be used only via _saveNoopVersion()
															#line 435 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
template <class _saveNoopVersionActor>
															#line 435 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
class _saveNoopVersionActorState {
															#line 1548 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
public:
															#line 435 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	_saveNoopVersionActorState(BackupData* const& self,Version const& poppedVersion) 
															#line 435 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
															#line 435 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		 : self(self),
															#line 435 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   poppedVersion(poppedVersion),
															#line 436 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   tr(self->cx)
															#line 1559 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("_saveNoopVersion", reinterpret_cast<unsigned long>(this));

	}
	~_saveNoopVersionActorState() 
	{
		fdb_probe_actor_destroy("_saveNoopVersion", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 438 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			;
															#line 1574 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_saveNoopVersionActorState();
		static_cast<_saveNoopVersionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 440 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 441 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 442 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 444 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr.get(backupWorkerMaxNoopVersionKey);
															#line 444 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (static_cast<_saveNoopVersionActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1613 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_saveNoopVersionActor*>(this)->actor_wait_state = 1;
															#line 444 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _saveNoopVersionActor, 0, Optional<Value> >*>(static_cast<_saveNoopVersionActor*>(this)));
															#line 1618 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 457 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 457 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (static_cast<_saveNoopVersionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1642 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<_saveNoopVersionActor*>(this)->actor_wait_state = 3;
															#line 457 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _saveNoopVersionActor, 2, Void >*>(static_cast<_saveNoopVersionActor*>(this)));
															#line 1647 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> const& noopValue,int loopDepth) 
	{
															#line 445 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (noopValue.present())
															#line 1662 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		{
															#line 446 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			Version noopVersion = BinaryReader::fromStringRef<Version>(noopValue.get(), Unversioned());
															#line 447 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (poppedVersion > noopVersion)
															#line 1668 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			{
															#line 448 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
				tr.set(backupWorkerMaxNoopVersionKey, BinaryWriter::toValue(poppedVersion, Unversioned()));
															#line 1672 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			}
		}
		else
		{
															#line 451 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			tr.set(backupWorkerMaxNoopVersionKey, BinaryWriter::toValue(poppedVersion, Unversioned()));
															#line 1679 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		}
															#line 454 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 454 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (static_cast<_saveNoopVersionActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1685 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<_saveNoopVersionActor*>(this)->actor_wait_state = 2;
															#line 454 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _saveNoopVersionActor, 1, Void >*>(static_cast<_saveNoopVersionActor*>(this)));
															#line 1690 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> && noopValue,int loopDepth) 
	{
															#line 445 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (noopValue.present())
															#line 1699 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		{
															#line 446 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			Version noopVersion = BinaryReader::fromStringRef<Version>(noopValue.get(), Unversioned());
															#line 447 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (poppedVersion > noopVersion)
															#line 1705 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			{
															#line 448 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
				tr.set(backupWorkerMaxNoopVersionKey, BinaryWriter::toValue(poppedVersion, Unversioned()));
															#line 1709 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			}
		}
		else
		{
															#line 451 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			tr.set(backupWorkerMaxNoopVersionKey, BinaryWriter::toValue(poppedVersion, Unversioned()));
															#line 1716 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		}
															#line 454 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 454 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (static_cast<_saveNoopVersionActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1722 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<_saveNoopVersionActor*>(this)->actor_wait_state = 2;
															#line 454 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _saveNoopVersionActor, 1, Void >*>(static_cast<_saveNoopVersionActor*>(this)));
															#line 1727 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& noopValue,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(noopValue, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && noopValue,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(noopValue), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_saveNoopVersionActor*>(this)->actor_wait_state > 0) static_cast<_saveNoopVersionActor*>(this)->actor_wait_state = 0;
		static_cast<_saveNoopVersionActor*>(this)->ActorCallback< _saveNoopVersionActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< _saveNoopVersionActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("_saveNoopVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_saveNoopVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_saveNoopVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _saveNoopVersionActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("_saveNoopVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_saveNoopVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_saveNoopVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _saveNoopVersionActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("_saveNoopVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_saveNoopVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_saveNoopVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 455 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (!static_cast<_saveNoopVersionActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_saveNoopVersionActorState(); static_cast<_saveNoopVersionActor*>(this)->destroy(); return 0; }
															#line 1811 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		new (&static_cast<_saveNoopVersionActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_saveNoopVersionActorState();
		static_cast<_saveNoopVersionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 455 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (!static_cast<_saveNoopVersionActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_saveNoopVersionActorState(); static_cast<_saveNoopVersionActor*>(this)->destroy(); return 0; }
															#line 1823 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		new (&static_cast<_saveNoopVersionActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_saveNoopVersionActorState();
		static_cast<_saveNoopVersionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_saveNoopVersionActor*>(this)->actor_wait_state > 0) static_cast<_saveNoopVersionActor*>(this)->actor_wait_state = 0;
		static_cast<_saveNoopVersionActor*>(this)->ActorCallback< _saveNoopVersionActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _saveNoopVersionActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_saveNoopVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_saveNoopVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_saveNoopVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _saveNoopVersionActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_saveNoopVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_saveNoopVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_saveNoopVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _saveNoopVersionActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_saveNoopVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_saveNoopVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_saveNoopVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_saveNoopVersionActor*>(this)->actor_wait_state > 0) static_cast<_saveNoopVersionActor*>(this)->actor_wait_state = 0;
		static_cast<_saveNoopVersionActor*>(this)->ActorCallback< _saveNoopVersionActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _saveNoopVersionActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_saveNoopVersion", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_saveNoopVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_saveNoopVersion", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _saveNoopVersionActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_saveNoopVersion", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_saveNoopVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_saveNoopVersion", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _saveNoopVersionActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_saveNoopVersion", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_saveNoopVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_saveNoopVersion", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 435 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	BackupData* self;
															#line 435 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	Version poppedVersion;
															#line 436 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	Transaction tr;
															#line 1999 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
};
// This generated class is to be used only via _saveNoopVersion()
															#line 435 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
class _saveNoopVersionActor final : public Actor<Void>, public ActorCallback< _saveNoopVersionActor, 0, Optional<Value> >, public ActorCallback< _saveNoopVersionActor, 1, Void >, public ActorCallback< _saveNoopVersionActor, 2, Void >, public FastAllocated<_saveNoopVersionActor>, public _saveNoopVersionActorState<_saveNoopVersionActor> {
															#line 2004 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
public:
	using FastAllocated<_saveNoopVersionActor>::operator new;
	using FastAllocated<_saveNoopVersionActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13359106447748865536UL, 1031630475662381312UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _saveNoopVersionActor, 0, Optional<Value> >;
friend struct ActorCallback< _saveNoopVersionActor, 1, Void >;
friend struct ActorCallback< _saveNoopVersionActor, 2, Void >;
															#line 435 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	_saveNoopVersionActor(BackupData* const& self,Version const& poppedVersion) 
															#line 2023 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   _saveNoopVersionActorState<_saveNoopVersionActor>(self, poppedVersion),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_saveNoopVersion", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15215348718762738432UL, 14746645298869324800UL);
		ActorExecutionContextHelper __helper(static_cast<_saveNoopVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_saveNoopVersion");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_saveNoopVersion", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _saveNoopVersionActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _saveNoopVersionActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _saveNoopVersionActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 435 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
[[nodiscard]] static Future<Void> _saveNoopVersion( BackupData* const& self, Version const& poppedVersion ) {
															#line 435 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	return Future<Void>(new _saveNoopVersionActor(self, poppedVersion));
															#line 2057 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
}

#line 461 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"

																#line 2062 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
// This generated class is to be used only via _noopPopper()
															#line 462 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
template <class _noopPopperActor>
															#line 462 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
class _noopPopperActorState {
															#line 2068 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
public:
															#line 462 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	_noopPopperActorState(BackupData* const& self) 
															#line 462 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
															#line 462 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		 : self(self),
															#line 463 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   onChange(self->popTrigger.onChange())
															#line 2077 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("_noopPopper", reinterpret_cast<unsigned long>(this));

	}
	~_noopPopperActorState() 
	{
		fdb_probe_actor_destroy("_noopPopper", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 465 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			;
															#line 2092 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_noopPopperActorState();
		static_cast<_noopPopperActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 466 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		StrictFuture<Void> __when_expr_0 = onChange;
															#line 466 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (static_cast<_noopPopperActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2124 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<_noopPopperActor*>(this)->actor_wait_state = 1;
															#line 466 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _noopPopperActor, 0, Void >*>(static_cast<_noopPopperActor*>(this)));
															#line 2129 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 467 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		onChange = self->popTrigger.onChange();
															#line 468 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (!self->pulling)
															#line 2140 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		{
															#line 471 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			popVersion = self->popTrigger.get();
															#line 472 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			ASSERT(self->popVersion <= popVersion);
															#line 473 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			StrictFuture<Void> __when_expr_1 = _saveNoopVersion(self, popVersion);
															#line 473 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (static_cast<_noopPopperActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2150 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<_noopPopperActor*>(this)->actor_wait_state = 2;
															#line 473 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _noopPopperActor, 1, Void >*>(static_cast<_noopPopperActor*>(this)));
															#line 2155 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 467 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		onChange = self->popTrigger.onChange();
															#line 468 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (!self->pulling)
															#line 2171 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		{
															#line 471 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			popVersion = self->popTrigger.get();
															#line 472 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			ASSERT(self->popVersion <= popVersion);
															#line 473 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			StrictFuture<Void> __when_expr_1 = _saveNoopVersion(self, popVersion);
															#line 473 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (static_cast<_noopPopperActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2181 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<_noopPopperActor*>(this)->actor_wait_state = 2;
															#line 473 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _noopPopperActor, 1, Void >*>(static_cast<_noopPopperActor*>(this)));
															#line 2186 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_noopPopperActor*>(this)->actor_wait_state > 0) static_cast<_noopPopperActor*>(this)->actor_wait_state = 0;
		static_cast<_noopPopperActor*>(this)->ActorCallback< _noopPopperActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _noopPopperActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_noopPopper", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_noopPopperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_noopPopper", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _noopPopperActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_noopPopper", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_noopPopperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_noopPopper", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _noopPopperActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_noopPopper", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_noopPopperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_noopPopper", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 474 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		self->popVersion = popVersion;
															#line 475 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		TraceEvent("BackupWorkerNoopPop", self->myId) .detail("Tag", self->tag) .detail("SavedVersion", self->savedVersion) .detail("PopVersion", popVersion);
															#line 479 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		self->pop();
															#line 2285 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 474 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		self->popVersion = popVersion;
															#line 475 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		TraceEvent("BackupWorkerNoopPop", self->myId) .detail("Tag", self->tag) .detail("SavedVersion", self->savedVersion) .detail("PopVersion", popVersion);
															#line 479 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		self->pop();
															#line 2298 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_noopPopperActor*>(this)->actor_wait_state > 0) static_cast<_noopPopperActor*>(this)->actor_wait_state = 0;
		static_cast<_noopPopperActor*>(this)->ActorCallback< _noopPopperActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _noopPopperActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_noopPopper", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_noopPopperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_noopPopper", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _noopPopperActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_noopPopper", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_noopPopperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_noopPopper", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _noopPopperActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_noopPopper", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_noopPopperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_noopPopper", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 462 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	BackupData* self;
															#line 463 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	Future<Void> onChange;
															#line 471 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	Version popVersion;
															#line 2384 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
};
// This generated class is to be used only via _noopPopper()
															#line 462 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
class _noopPopperActor final : public Actor<Void>, public ActorCallback< _noopPopperActor, 0, Void >, public ActorCallback< _noopPopperActor, 1, Void >, public FastAllocated<_noopPopperActor>, public _noopPopperActorState<_noopPopperActor> {
															#line 2389 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
public:
	using FastAllocated<_noopPopperActor>::operator new;
	using FastAllocated<_noopPopperActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7692707365231652608UL, 9506077218420219392UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _noopPopperActor, 0, Void >;
friend struct ActorCallback< _noopPopperActor, 1, Void >;
															#line 462 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	_noopPopperActor(BackupData* const& self) 
															#line 2407 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   _noopPopperActorState<_noopPopperActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_noopPopper", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2527352761133654784UL, 7744587887698722304UL);
		ActorExecutionContextHelper __helper(static_cast<_noopPopperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_noopPopper");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_noopPopper", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _noopPopperActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _noopPopperActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 462 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
[[nodiscard]] static Future<Void> _noopPopper( BackupData* const& self ) {
															#line 462 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	return Future<Void>(new _noopPopperActor(self));
															#line 2440 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
}

#line 483 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"

																#line 2445 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
// This generated class is to be used only via _waitAllInfoReady()
															#line 484 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
template <class _waitAllInfoReadyActor>
															#line 484 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
class _waitAllInfoReadyActorState {
															#line 2451 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
public:
															#line 484 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	_waitAllInfoReadyActorState(BackupData* const& self) 
															#line 484 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
															#line 484 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		 : self(self)
															#line 2458 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("_waitAllInfoReady", reinterpret_cast<unsigned long>(this));

	}
	~_waitAllInfoReadyActorState() 
	{
		fdb_probe_actor_destroy("_waitAllInfoReady", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 485 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			std::vector<Future<Void>> all;
															#line 486 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			for(auto it = self->backups.begin();it != self->backups.end();) {
															#line 487 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
				if (it->second.stopped)
															#line 2477 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
				{
															#line 488 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
					TraceEvent("BackupWorkerRemoveStoppedContainer", self->myId).detail("BackupId", it->first);
															#line 489 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
					it = self->backups.erase(it);
															#line 2483 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
					continue;
				}
															#line 493 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
				all.push_back(it->second.waitReady());
															#line 494 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
				it++;
															#line 2490 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			}
															#line 496 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			StrictFuture<Void> __when_expr_0 = waitForAll(all);
															#line 496 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (static_cast<_waitAllInfoReadyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2496 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_waitAllInfoReadyActor*>(this)->actor_wait_state = 1;
															#line 496 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _waitAllInfoReadyActor, 0, Void >*>(static_cast<_waitAllInfoReadyActor*>(this)));
															#line 2501 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_waitAllInfoReadyActorState();
		static_cast<_waitAllInfoReadyActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 497 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (!static_cast<_waitAllInfoReadyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_waitAllInfoReadyActorState(); static_cast<_waitAllInfoReadyActor*>(this)->destroy(); return 0; }
															#line 2524 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		new (&static_cast<_waitAllInfoReadyActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_waitAllInfoReadyActorState();
		static_cast<_waitAllInfoReadyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 497 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (!static_cast<_waitAllInfoReadyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_waitAllInfoReadyActorState(); static_cast<_waitAllInfoReadyActor*>(this)->destroy(); return 0; }
															#line 2536 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		new (&static_cast<_waitAllInfoReadyActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_waitAllInfoReadyActorState();
		static_cast<_waitAllInfoReadyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_waitAllInfoReadyActor*>(this)->actor_wait_state > 0) static_cast<_waitAllInfoReadyActor*>(this)->actor_wait_state = 0;
		static_cast<_waitAllInfoReadyActor*>(this)->ActorCallback< _waitAllInfoReadyActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _waitAllInfoReadyActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_waitAllInfoReady", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_waitAllInfoReadyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_waitAllInfoReady", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _waitAllInfoReadyActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_waitAllInfoReady", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_waitAllInfoReadyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_waitAllInfoReady", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _waitAllInfoReadyActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_waitAllInfoReady", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_waitAllInfoReadyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_waitAllInfoReady", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 484 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	BackupData* self;
															#line 2621 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
};
// This generated class is to be used only via _waitAllInfoReady()
															#line 484 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
class _waitAllInfoReadyActor final : public Actor<Void>, public ActorCallback< _waitAllInfoReadyActor, 0, Void >, public FastAllocated<_waitAllInfoReadyActor>, public _waitAllInfoReadyActorState<_waitAllInfoReadyActor> {
															#line 2626 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
public:
	using FastAllocated<_waitAllInfoReadyActor>::operator new;
	using FastAllocated<_waitAllInfoReadyActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5295575668831212544UL, 9038223363882087424UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _waitAllInfoReadyActor, 0, Void >;
															#line 484 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	_waitAllInfoReadyActor(BackupData* const& self) 
															#line 2643 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   _waitAllInfoReadyActorState<_waitAllInfoReadyActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_waitAllInfoReady", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9026822507671870720UL, 9655794640352953088UL);
		ActorExecutionContextHelper __helper(static_cast<_waitAllInfoReadyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_waitAllInfoReady");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_waitAllInfoReady", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _waitAllInfoReadyActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 484 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
[[nodiscard]] static Future<Void> _waitAllInfoReady( BackupData* const& self ) {
															#line 484 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	return Future<Void>(new _waitAllInfoReadyActor(self));
															#line 2675 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
}

#line 499 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"

	Future<Void> waitAllInfoReady() { return _waitAllInfoReady(this); }

	bool isAllInfoReady() const {
		for (const auto& [uid, info] : backups) {
			if (!info.isReady())
				return false;
		}
		return true;
	}

																#line 2690 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
// This generated class is to be used only via _getMinKnownCommittedVersion()
															#line 510 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
template <class _getMinKnownCommittedVersionActor>
															#line 510 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
class _getMinKnownCommittedVersionActorState {
															#line 2696 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
public:
															#line 510 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	_getMinKnownCommittedVersionActorState(BackupData* const& self) 
															#line 510 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
															#line 510 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		 : self(self),
															#line 511 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   span("BA:GetMinCommittedVersion"_loc)
															#line 2705 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("_getMinKnownCommittedVersion", reinterpret_cast<unsigned long>(this));

	}
	~_getMinKnownCommittedVersionActorState() 
	{
		fdb_probe_actor_destroy("_getMinKnownCommittedVersion", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 512 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			;
															#line 2720 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_getMinKnownCommittedVersionActorState();
		static_cast<_getMinKnownCommittedVersionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 514 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			GetReadVersionRequest request(span.context, 0, TransactionPriority::DEFAULT, invalidVersion, GetReadVersionRequest::FLAG_USE_MIN_KNOWN_COMMITTED_VERSION);
															#line 520 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->cx->onProxiesChanged();
															#line 519 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (static_cast<_getMinKnownCommittedVersionActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2755 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
															#line 521 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			StrictFuture<GetReadVersionReply> __when_expr_1 = basicLoadBalance(self->cx->getGrvProxies(UseProvisionalProxies::False), &GrvProxyInterface::getConsistentReadVersion, request, self->cx->taskID);
															#line 2759 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
			static_cast<_getMinKnownCommittedVersionActor*>(this)->actor_wait_state = 1;
															#line 520 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _getMinKnownCommittedVersionActor, 0, Void >*>(static_cast<_getMinKnownCommittedVersionActor*>(this)));
															#line 521 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _getMinKnownCommittedVersionActor, 1, GetReadVersionReply >*>(static_cast<_getMinKnownCommittedVersionActor*>(this)));
															#line 2766 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 531 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (e.code() == error_code_batch_transaction_throttled || e.code() == error_code_grv_proxy_memory_limit_exceeded)
															#line 2788 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			{
															#line 534 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
				StrictFuture<Void> __when_expr_2 = delayJittered(CLIENT_KNOBS->GRV_ERROR_RETRY_DELAY);
															#line 534 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
				if (static_cast<_getMinKnownCommittedVersionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2794 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
				if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
				static_cast<_getMinKnownCommittedVersionActor*>(this)->actor_wait_state = 2;
															#line 534 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
				__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _getMinKnownCommittedVersionActor, 2, Void >*>(static_cast<_getMinKnownCommittedVersionActor*>(this)));
															#line 2799 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
															#line 536 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 2806 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(GetReadVersionReply const& reply,int loopDepth) 
	{
															#line 526 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		self->cx->ssVersionVectorCache.applyDelta(reply.ssVersionVectorDelta);
															#line 527 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (!static_cast<_getMinKnownCommittedVersionActor*>(this)->SAV<Version>::futures) { (void)(reply.version); this->~_getMinKnownCommittedVersionActorState(); static_cast<_getMinKnownCommittedVersionActor*>(this)->destroy(); return 0; }
															#line 2841 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		new (&static_cast<_getMinKnownCommittedVersionActor*>(this)->SAV< Version >::value()) Version(reply.version);
		this->~_getMinKnownCommittedVersionActorState();
		static_cast<_getMinKnownCommittedVersionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when2(GetReadVersionReply && reply,int loopDepth) 
	{
															#line 526 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		self->cx->ssVersionVectorCache.applyDelta(reply.ssVersionVectorDelta);
															#line 527 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (!static_cast<_getMinKnownCommittedVersionActor*>(this)->SAV<Version>::futures) { (void)(reply.version); this->~_getMinKnownCommittedVersionActorState(); static_cast<_getMinKnownCommittedVersionActor*>(this)->destroy(); return 0; }
															#line 2855 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		new (&static_cast<_getMinKnownCommittedVersionActor*>(this)->SAV< Version >::value()) Version(reply.version);
		this->~_getMinKnownCommittedVersionActorState();
		static_cast<_getMinKnownCommittedVersionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_getMinKnownCommittedVersionActor*>(this)->actor_wait_state > 0) static_cast<_getMinKnownCommittedVersionActor*>(this)->actor_wait_state = 0;
		static_cast<_getMinKnownCommittedVersionActor*>(this)->ActorCallback< _getMinKnownCommittedVersionActor, 0, Void >::remove();
		static_cast<_getMinKnownCommittedVersionActor*>(this)->ActorCallback< _getMinKnownCommittedVersionActor, 1, GetReadVersionReply >::remove();

	}
	void a_callback_fire(ActorCallback< _getMinKnownCommittedVersionActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_getMinKnownCommittedVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_getMinKnownCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_getMinKnownCommittedVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _getMinKnownCommittedVersionActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_getMinKnownCommittedVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_getMinKnownCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_getMinKnownCommittedVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _getMinKnownCommittedVersionActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_getMinKnownCommittedVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_getMinKnownCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_getMinKnownCommittedVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _getMinKnownCommittedVersionActor, 1, GetReadVersionReply >*,GetReadVersionReply const& value) 
	{
		fdb_probe_actor_enter("_getMinKnownCommittedVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_getMinKnownCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_getMinKnownCommittedVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _getMinKnownCommittedVersionActor, 1, GetReadVersionReply >*,GetReadVersionReply && value) 
	{
		fdb_probe_actor_enter("_getMinKnownCommittedVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_getMinKnownCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_getMinKnownCommittedVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _getMinKnownCommittedVersionActor, 1, GetReadVersionReply >*,Error err) 
	{
		fdb_probe_actor_enter("_getMinKnownCommittedVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_getMinKnownCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_getMinKnownCommittedVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_getMinKnownCommittedVersionActor*>(this)->actor_wait_state > 0) static_cast<_getMinKnownCommittedVersionActor*>(this)->actor_wait_state = 0;
		static_cast<_getMinKnownCommittedVersionActor*>(this)->ActorCallback< _getMinKnownCommittedVersionActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _getMinKnownCommittedVersionActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_getMinKnownCommittedVersion", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_getMinKnownCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_getMinKnownCommittedVersion", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _getMinKnownCommittedVersionActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_getMinKnownCommittedVersion", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_getMinKnownCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_getMinKnownCommittedVersion", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _getMinKnownCommittedVersionActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_getMinKnownCommittedVersion", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_getMinKnownCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_getMinKnownCommittedVersion", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 510 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	BackupData* self;
															#line 511 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	Span span;
															#line 3094 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
};
// This generated class is to be used only via _getMinKnownCommittedVersion()
															#line 510 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
class _getMinKnownCommittedVersionActor final : public Actor<Version>, public ActorCallback< _getMinKnownCommittedVersionActor, 0, Void >, public ActorCallback< _getMinKnownCommittedVersionActor, 1, GetReadVersionReply >, public ActorCallback< _getMinKnownCommittedVersionActor, 2, Void >, public FastAllocated<_getMinKnownCommittedVersionActor>, public _getMinKnownCommittedVersionActorState<_getMinKnownCommittedVersionActor> {
															#line 3099 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
public:
	using FastAllocated<_getMinKnownCommittedVersionActor>::operator new;
	using FastAllocated<_getMinKnownCommittedVersionActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12976929309568921600UL, 1673817561593789952UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Version>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _getMinKnownCommittedVersionActor, 0, Void >;
friend struct ActorCallback< _getMinKnownCommittedVersionActor, 1, GetReadVersionReply >;
friend struct ActorCallback< _getMinKnownCommittedVersionActor, 2, Void >;
															#line 510 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	_getMinKnownCommittedVersionActor(BackupData* const& self) 
															#line 3118 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		 : Actor<Version>(),
		   _getMinKnownCommittedVersionActorState<_getMinKnownCommittedVersionActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_getMinKnownCommittedVersion", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14087104505730542592UL, 16499376419574723584UL);
		ActorExecutionContextHelper __helper(static_cast<_getMinKnownCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_getMinKnownCommittedVersion");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_getMinKnownCommittedVersion", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _getMinKnownCommittedVersionActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _getMinKnownCommittedVersionActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 510 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
[[nodiscard]] static Future<Version> _getMinKnownCommittedVersion( BackupData* const& self ) {
															#line 510 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	return Future<Version>(new _getMinKnownCommittedVersionActor(self));
															#line 3151 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
}

#line 541 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"

	Future<Version> getMinKnownCommittedVersion() { return _getMinKnownCommittedVersion(this); }
};

// Monitors "backupStartedKey". If "present" is true, wait until the key is set;
// otherwise, wait until the key is cleared. If "watch" is false, do not perform
// the wait for key set/clear events. Returns if key present.
															#line 3162 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via monitorBackupStartedKeyChanges()
															#line 548 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
template <class MonitorBackupStartedKeyChangesActor>
															#line 548 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
class MonitorBackupStartedKeyChangesActorState {
															#line 3169 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
public:
															#line 548 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	MonitorBackupStartedKeyChangesActorState(BackupData* const& self,bool const& present,bool const& watch) 
															#line 548 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
															#line 548 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		 : self(self),
															#line 548 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   present(present),
															#line 548 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   watch(watch)
															#line 3180 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("monitorBackupStartedKeyChanges", reinterpret_cast<unsigned long>(this));

	}
	~MonitorBackupStartedKeyChangesActorState() 
	{
		fdb_probe_actor_destroy("monitorBackupStartedKeyChanges", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 549 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			;
															#line 3195 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MonitorBackupStartedKeyChangesActorState();
		static_cast<MonitorBackupStartedKeyChangesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 550 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		tr = ReadYourWritesTransaction(self->cx);
															#line 552 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		;
															#line 3227 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
		try {
															#line 554 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 555 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 556 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr.get(backupStartedKey);
															#line 556 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (static_cast<MonitorBackupStartedKeyChangesActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3256 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<MonitorBackupStartedKeyChangesActor*>(this)->actor_wait_state = 1;
															#line 556 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MonitorBackupStartedKeyChangesActor, 0, Optional<Value> >*>(static_cast<MonitorBackupStartedKeyChangesActor*>(this)));
															#line 3261 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 589 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr.onError(e);
															#line 589 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (static_cast<MonitorBackupStartedKeyChangesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 3298 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<MonitorBackupStartedKeyChangesActor*>(this)->actor_wait_state = 4;
															#line 589 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< MonitorBackupStartedKeyChangesActor, 3, Void >*>(static_cast<MonitorBackupStartedKeyChangesActor*>(this)));
															#line 3303 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(Optional<Value> const& value,int loopDepth) 
	{
															#line 557 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		std::vector<std::pair<UID, Version>> uidVersions;
															#line 558 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		bool shouldExit = self->endVersion.present();
															#line 559 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (value.present())
															#line 3322 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		{
															#line 560 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			uidVersions = decodeBackupStartedValue(value.get());
															#line 561 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			TraceEvent e("BackupWorkerGotStartKey", self->myId);
															#line 562 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			int i = 1;
															#line 563 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			for( auto [uid, version] : uidVersions ) {
															#line 564 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
				e.detail(format("BackupID%d", i), uid).detail(format("Version%d", i), version);
															#line 565 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
				i++;
															#line 566 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
				if (shouldExit && version < self->endVersion.get())
															#line 3338 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
				{
															#line 567 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
					shouldExit = false;
															#line 3342 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
				}
			}
															#line 570 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			self->exitEarly = shouldExit;
															#line 571 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			self->onBackupChanges(uidVersions);
															#line 572 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (present || !watch)
															#line 3351 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			{
															#line 573 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
				if (!static_cast<MonitorBackupStartedKeyChangesActor*>(this)->SAV<bool>::futures) { (void)(true); this->~MonitorBackupStartedKeyChangesActorState(); static_cast<MonitorBackupStartedKeyChangesActor*>(this)->destroy(); return 0; }
															#line 3355 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
				new (&static_cast<MonitorBackupStartedKeyChangesActor*>(this)->SAV< bool >::value()) bool(true);
				this->~MonitorBackupStartedKeyChangesActorState();
				static_cast<MonitorBackupStartedKeyChangesActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
		else
		{
															#line 575 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			TraceEvent("BackupWorkerEmptyStartKey", self->myId).log();
															#line 576 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			self->onBackupChanges(uidVersions);
															#line 578 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			self->exitEarly = shouldExit;
															#line 579 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (!present || !watch)
															#line 3372 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			{
															#line 580 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
				if (!static_cast<MonitorBackupStartedKeyChangesActor*>(this)->SAV<bool>::futures) { (void)(false); this->~MonitorBackupStartedKeyChangesActorState(); static_cast<MonitorBackupStartedKeyChangesActor*>(this)->destroy(); return 0; }
															#line 3376 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
				new (&static_cast<MonitorBackupStartedKeyChangesActor*>(this)->SAV< bool >::value()) bool(false);
				this->~MonitorBackupStartedKeyChangesActorState();
				static_cast<MonitorBackupStartedKeyChangesActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 584 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		watchFuture = tr.watch(backupStartedKey);
															#line 585 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 585 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (static_cast<MonitorBackupStartedKeyChangesActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3389 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<MonitorBackupStartedKeyChangesActor*>(this)->actor_wait_state = 2;
															#line 585 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MonitorBackupStartedKeyChangesActor, 1, Void >*>(static_cast<MonitorBackupStartedKeyChangesActor*>(this)));
															#line 3394 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(Optional<Value> && value,int loopDepth) 
	{
															#line 557 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		std::vector<std::pair<UID, Version>> uidVersions;
															#line 558 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		bool shouldExit = self->endVersion.present();
															#line 559 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (value.present())
															#line 3407 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		{
															#line 560 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			uidVersions = decodeBackupStartedValue(value.get());
															#line 561 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			TraceEvent e("BackupWorkerGotStartKey", self->myId);
															#line 562 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			int i = 1;
															#line 563 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			for( auto [uid, version] : uidVersions ) {
															#line 564 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
				e.detail(format("BackupID%d", i), uid).detail(format("Version%d", i), version);
															#line 565 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
				i++;
															#line 566 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
				if (shouldExit && version < self->endVersion.get())
															#line 3423 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
				{
															#line 567 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
					shouldExit = false;
															#line 3427 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
				}
			}
															#line 570 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			self->exitEarly = shouldExit;
															#line 571 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			self->onBackupChanges(uidVersions);
															#line 572 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (present || !watch)
															#line 3436 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			{
															#line 573 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
				if (!static_cast<MonitorBackupStartedKeyChangesActor*>(this)->SAV<bool>::futures) { (void)(true); this->~MonitorBackupStartedKeyChangesActorState(); static_cast<MonitorBackupStartedKeyChangesActor*>(this)->destroy(); return 0; }
															#line 3440 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
				new (&static_cast<MonitorBackupStartedKeyChangesActor*>(this)->SAV< bool >::value()) bool(true);
				this->~MonitorBackupStartedKeyChangesActorState();
				static_cast<MonitorBackupStartedKeyChangesActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
		else
		{
															#line 575 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			TraceEvent("BackupWorkerEmptyStartKey", self->myId).log();
															#line 576 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			self->onBackupChanges(uidVersions);
															#line 578 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			self->exitEarly = shouldExit;
															#line 579 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (!present || !watch)
															#line 3457 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			{
															#line 580 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
				if (!static_cast<MonitorBackupStartedKeyChangesActor*>(this)->SAV<bool>::futures) { (void)(false); this->~MonitorBackupStartedKeyChangesActorState(); static_cast<MonitorBackupStartedKeyChangesActor*>(this)->destroy(); return 0; }
															#line 3461 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
				new (&static_cast<MonitorBackupStartedKeyChangesActor*>(this)->SAV< bool >::value()) bool(false);
				this->~MonitorBackupStartedKeyChangesActorState();
				static_cast<MonitorBackupStartedKeyChangesActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 584 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		watchFuture = tr.watch(backupStartedKey);
															#line 585 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 585 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (static_cast<MonitorBackupStartedKeyChangesActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3474 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<MonitorBackupStartedKeyChangesActor*>(this)->actor_wait_state = 2;
															#line 585 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MonitorBackupStartedKeyChangesActor, 1, Void >*>(static_cast<MonitorBackupStartedKeyChangesActor*>(this)));
															#line 3479 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Optional<Value> const& value,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont2(value, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Optional<Value> && value,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont2(std::move(value), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MonitorBackupStartedKeyChangesActor*>(this)->actor_wait_state > 0) static_cast<MonitorBackupStartedKeyChangesActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorBackupStartedKeyChangesActor*>(this)->ActorCallback< MonitorBackupStartedKeyChangesActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorBackupStartedKeyChangesActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("monitorBackupStartedKeyChanges", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBackupStartedKeyChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBackupStartedKeyChanges", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MonitorBackupStartedKeyChangesActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("monitorBackupStartedKeyChanges", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBackupStartedKeyChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBackupStartedKeyChanges", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MonitorBackupStartedKeyChangesActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("monitorBackupStartedKeyChanges", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBackupStartedKeyChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBackupStartedKeyChanges", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 586 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		StrictFuture<Void> __when_expr_2 = watchFuture;
															#line 586 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (static_cast<MonitorBackupStartedKeyChangesActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3565 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<MonitorBackupStartedKeyChangesActor*>(this)->actor_wait_state = 3;
															#line 586 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MonitorBackupStartedKeyChangesActor, 2, Void >*>(static_cast<MonitorBackupStartedKeyChangesActor*>(this)));
															#line 3570 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 586 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		StrictFuture<Void> __when_expr_2 = watchFuture;
															#line 586 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (static_cast<MonitorBackupStartedKeyChangesActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3581 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<MonitorBackupStartedKeyChangesActor*>(this)->actor_wait_state = 3;
															#line 586 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MonitorBackupStartedKeyChangesActor, 2, Void >*>(static_cast<MonitorBackupStartedKeyChangesActor*>(this)));
															#line 3586 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<MonitorBackupStartedKeyChangesActor*>(this)->actor_wait_state > 0) static_cast<MonitorBackupStartedKeyChangesActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorBackupStartedKeyChangesActor*>(this)->ActorCallback< MonitorBackupStartedKeyChangesActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorBackupStartedKeyChangesActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorBackupStartedKeyChanges", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBackupStartedKeyChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBackupStartedKeyChanges", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MonitorBackupStartedKeyChangesActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorBackupStartedKeyChanges", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBackupStartedKeyChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBackupStartedKeyChanges", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< MonitorBackupStartedKeyChangesActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorBackupStartedKeyChanges", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBackupStartedKeyChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBackupStartedKeyChanges", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1loopBody1cont10(Void const& _,int loopDepth) 
	{
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont10(Void && _,int loopDepth) 
	{
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<MonitorBackupStartedKeyChangesActor*>(this)->actor_wait_state > 0) static_cast<MonitorBackupStartedKeyChangesActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorBackupStartedKeyChangesActor*>(this)->ActorCallback< MonitorBackupStartedKeyChangesActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorBackupStartedKeyChangesActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorBackupStartedKeyChanges", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBackupStartedKeyChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBackupStartedKeyChanges", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< MonitorBackupStartedKeyChangesActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorBackupStartedKeyChanges", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBackupStartedKeyChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBackupStartedKeyChanges", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< MonitorBackupStartedKeyChangesActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorBackupStartedKeyChanges", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBackupStartedKeyChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBackupStartedKeyChanges", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<MonitorBackupStartedKeyChangesActor*>(this)->actor_wait_state > 0) static_cast<MonitorBackupStartedKeyChangesActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorBackupStartedKeyChangesActor*>(this)->ActorCallback< MonitorBackupStartedKeyChangesActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorBackupStartedKeyChangesActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorBackupStartedKeyChanges", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBackupStartedKeyChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBackupStartedKeyChanges", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< MonitorBackupStartedKeyChangesActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorBackupStartedKeyChanges", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBackupStartedKeyChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBackupStartedKeyChanges", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< MonitorBackupStartedKeyChangesActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorBackupStartedKeyChanges", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBackupStartedKeyChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBackupStartedKeyChanges", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 548 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	BackupData* self;
															#line 548 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	bool present;
															#line 548 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	bool watch;
															#line 550 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	ReadYourWritesTransaction tr;
															#line 584 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	Future<Void> watchFuture;
															#line 3850 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
};
// This generated class is to be used only via monitorBackupStartedKeyChanges()
															#line 548 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
class MonitorBackupStartedKeyChangesActor final : public Actor<bool>, public ActorCallback< MonitorBackupStartedKeyChangesActor, 0, Optional<Value> >, public ActorCallback< MonitorBackupStartedKeyChangesActor, 1, Void >, public ActorCallback< MonitorBackupStartedKeyChangesActor, 2, Void >, public ActorCallback< MonitorBackupStartedKeyChangesActor, 3, Void >, public FastAllocated<MonitorBackupStartedKeyChangesActor>, public MonitorBackupStartedKeyChangesActorState<MonitorBackupStartedKeyChangesActor> {
															#line 3855 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
public:
	using FastAllocated<MonitorBackupStartedKeyChangesActor>::operator new;
	using FastAllocated<MonitorBackupStartedKeyChangesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(111904788347530752UL, 17871863218557284864UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MonitorBackupStartedKeyChangesActor, 0, Optional<Value> >;
friend struct ActorCallback< MonitorBackupStartedKeyChangesActor, 1, Void >;
friend struct ActorCallback< MonitorBackupStartedKeyChangesActor, 2, Void >;
friend struct ActorCallback< MonitorBackupStartedKeyChangesActor, 3, Void >;
															#line 548 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	MonitorBackupStartedKeyChangesActor(BackupData* const& self,bool const& present,bool const& watch) 
															#line 3875 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		 : Actor<bool>(),
		   MonitorBackupStartedKeyChangesActorState<MonitorBackupStartedKeyChangesActor>(self, present, watch),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("monitorBackupStartedKeyChanges", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13517279204875337472UL, 5292722468620612864UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBackupStartedKeyChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("monitorBackupStartedKeyChanges");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("monitorBackupStartedKeyChanges", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MonitorBackupStartedKeyChangesActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< MonitorBackupStartedKeyChangesActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< MonitorBackupStartedKeyChangesActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< MonitorBackupStartedKeyChangesActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 548 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
[[nodiscard]] Future<bool> monitorBackupStartedKeyChanges( BackupData* const& self, bool const& present, bool const& watch ) {
															#line 548 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	return Future<bool>(new MonitorBackupStartedKeyChangesActor(self, present, watch));
															#line 3911 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
}

#line 594 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"

// Set "latestBackupWorkerSavedVersion" key for backups
															#line 3917 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via setBackupKeys()
															#line 596 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
template <class SetBackupKeysActor>
															#line 596 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
class SetBackupKeysActorState {
															#line 3924 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
public:
															#line 596 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	SetBackupKeysActorState(BackupData* const& self,std::map<UID, Version> const& savedLogVersions) 
															#line 596 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
															#line 596 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		 : self(self),
															#line 596 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   savedLogVersions(savedLogVersions),
															#line 597 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   tr(new ReadYourWritesTransaction(self->cx))
															#line 3935 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("setBackupKeys", reinterpret_cast<unsigned long>(this));

	}
	~SetBackupKeysActorState() 
	{
		fdb_probe_actor_destroy("setBackupKeys", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 599 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			;
															#line 3950 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SetBackupKeysActorState();
		static_cast<SetBackupKeysActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 601 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 602 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 603 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			tr->setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 605 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			prevVersions = std::vector<Future<Optional<Version>>>();
															#line 606 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			versionConfigs = std::vector<BackupConfig>();
															#line 607 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			allWorkersReady = std::vector<Future<Optional<bool>>>();
															#line 608 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			for( const auto& [uid, version] : savedLogVersions ) {
															#line 609 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
				versionConfigs.emplace_back(uid);
															#line 610 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
				prevVersions.push_back(versionConfigs.back().latestBackupWorkerSavedVersion().get(tr));
															#line 611 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
				allWorkersReady.push_back(versionConfigs.back().allWorkerStarted().get(tr));
															#line 3999 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			}
															#line 614 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			StrictFuture<Void> __when_expr_0 = waitForAll(prevVersions) && waitForAll(allWorkersReady);
															#line 614 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (static_cast<SetBackupKeysActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4005 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<SetBackupKeysActor*>(this)->actor_wait_state = 1;
															#line 614 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SetBackupKeysActor, 0, Void >*>(static_cast<SetBackupKeysActor*>(this)));
															#line 4010 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 640 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr->onError(e);
															#line 640 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (static_cast<SetBackupKeysActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4034 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<SetBackupKeysActor*>(this)->actor_wait_state = 3;
															#line 640 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< SetBackupKeysActor, 2, Void >*>(static_cast<SetBackupKeysActor*>(this)));
															#line 4039 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 616 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		for(int i = 0;i < prevVersions.size();i++) {
															#line 617 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (!allWorkersReady[i].get().present() || !allWorkersReady[i].get().get())
															#line 4056 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			{
				continue;
			}
															#line 620 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			const Version current = savedLogVersions[versionConfigs[i].getUid()];
															#line 621 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (prevVersions[i].get().present())
															#line 4064 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			{
															#line 622 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
				const Version prev = prevVersions[i].get().get();
															#line 623 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
				if (prev > current)
															#line 4070 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
				{
															#line 624 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
					TraceEvent(SevWarn, "BackupWorkerVersionInverse", self->myId) .detail("Prev", prev) .detail("Current", current);
															#line 4074 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
				}
			}
															#line 629 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (self->backupEpoch == self->oldestBackupEpoch && (!prevVersions[i].get().present() || prevVersions[i].get().get() < current))
															#line 4079 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			{
															#line 631 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
				TraceEvent("BackupWorkerSetVersion", self->myId) .detail("BackupID", versionConfigs[i].getUid()) .detail("Version", current);
															#line 634 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
				versionConfigs[i].latestBackupWorkerSavedVersion().set(tr, current);
															#line 4085 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			}
		}
															#line 637 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr->commit();
															#line 637 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (static_cast<SetBackupKeysActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4092 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<SetBackupKeysActor*>(this)->actor_wait_state = 2;
															#line 637 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SetBackupKeysActor, 1, Void >*>(static_cast<SetBackupKeysActor*>(this)));
															#line 4097 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 616 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		for(int i = 0;i < prevVersions.size();i++) {
															#line 617 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (!allWorkersReady[i].get().present() || !allWorkersReady[i].get().get())
															#line 4108 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			{
				continue;
			}
															#line 620 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			const Version current = savedLogVersions[versionConfigs[i].getUid()];
															#line 621 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (prevVersions[i].get().present())
															#line 4116 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			{
															#line 622 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
				const Version prev = prevVersions[i].get().get();
															#line 623 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
				if (prev > current)
															#line 4122 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
				{
															#line 624 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
					TraceEvent(SevWarn, "BackupWorkerVersionInverse", self->myId) .detail("Prev", prev) .detail("Current", current);
															#line 4126 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
				}
			}
															#line 629 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (self->backupEpoch == self->oldestBackupEpoch && (!prevVersions[i].get().present() || prevVersions[i].get().get() < current))
															#line 4131 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			{
															#line 631 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
				TraceEvent("BackupWorkerSetVersion", self->myId) .detail("BackupID", versionConfigs[i].getUid()) .detail("Version", current);
															#line 634 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
				versionConfigs[i].latestBackupWorkerSavedVersion().set(tr, current);
															#line 4137 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			}
		}
															#line 637 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr->commit();
															#line 637 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (static_cast<SetBackupKeysActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4144 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<SetBackupKeysActor*>(this)->actor_wait_state = 2;
															#line 637 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SetBackupKeysActor, 1, Void >*>(static_cast<SetBackupKeysActor*>(this)));
															#line 4149 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SetBackupKeysActor*>(this)->actor_wait_state > 0) static_cast<SetBackupKeysActor*>(this)->actor_wait_state = 0;
		static_cast<SetBackupKeysActor*>(this)->ActorCallback< SetBackupKeysActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SetBackupKeysActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("setBackupKeys", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetBackupKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setBackupKeys", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SetBackupKeysActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("setBackupKeys", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetBackupKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setBackupKeys", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SetBackupKeysActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("setBackupKeys", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SetBackupKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setBackupKeys", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
															#line 638 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (!static_cast<SetBackupKeysActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SetBackupKeysActorState(); static_cast<SetBackupKeysActor*>(this)->destroy(); return 0; }
															#line 4233 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		new (&static_cast<SetBackupKeysActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SetBackupKeysActorState();
		static_cast<SetBackupKeysActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
															#line 638 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (!static_cast<SetBackupKeysActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SetBackupKeysActorState(); static_cast<SetBackupKeysActor*>(this)->destroy(); return 0; }
															#line 4245 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		new (&static_cast<SetBackupKeysActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SetBackupKeysActorState();
		static_cast<SetBackupKeysActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<SetBackupKeysActor*>(this)->actor_wait_state > 0) static_cast<SetBackupKeysActor*>(this)->actor_wait_state = 0;
		static_cast<SetBackupKeysActor*>(this)->ActorCallback< SetBackupKeysActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SetBackupKeysActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("setBackupKeys", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetBackupKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setBackupKeys", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< SetBackupKeysActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("setBackupKeys", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetBackupKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setBackupKeys", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< SetBackupKeysActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("setBackupKeys", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SetBackupKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setBackupKeys", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<SetBackupKeysActor*>(this)->actor_wait_state > 0) static_cast<SetBackupKeysActor*>(this)->actor_wait_state = 0;
		static_cast<SetBackupKeysActor*>(this)->ActorCallback< SetBackupKeysActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SetBackupKeysActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("setBackupKeys", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetBackupKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setBackupKeys", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< SetBackupKeysActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("setBackupKeys", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetBackupKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setBackupKeys", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< SetBackupKeysActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("setBackupKeys", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SetBackupKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setBackupKeys", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 596 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	BackupData* self;
															#line 596 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	std::map<UID, Version> savedLogVersions;
															#line 597 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 605 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	std::vector<Future<Optional<Version>>> prevVersions;
															#line 606 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	std::vector<BackupConfig> versionConfigs;
															#line 607 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	std::vector<Future<Optional<bool>>> allWorkersReady;
															#line 4427 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
};
// This generated class is to be used only via setBackupKeys()
															#line 596 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
class SetBackupKeysActor final : public Actor<Void>, public ActorCallback< SetBackupKeysActor, 0, Void >, public ActorCallback< SetBackupKeysActor, 1, Void >, public ActorCallback< SetBackupKeysActor, 2, Void >, public FastAllocated<SetBackupKeysActor>, public SetBackupKeysActorState<SetBackupKeysActor> {
															#line 4432 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
public:
	using FastAllocated<SetBackupKeysActor>::operator new;
	using FastAllocated<SetBackupKeysActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12242371864427872512UL, 9533082804374248960UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SetBackupKeysActor, 0, Void >;
friend struct ActorCallback< SetBackupKeysActor, 1, Void >;
friend struct ActorCallback< SetBackupKeysActor, 2, Void >;
															#line 596 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	SetBackupKeysActor(BackupData* const& self,std::map<UID, Version> const& savedLogVersions) 
															#line 4451 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   SetBackupKeysActorState<SetBackupKeysActor>(self, savedLogVersions),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("setBackupKeys", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4250490297819043584UL, 2806497358835527424UL);
		ActorExecutionContextHelper __helper(static_cast<SetBackupKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("setBackupKeys");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("setBackupKeys", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SetBackupKeysActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< SetBackupKeysActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< SetBackupKeysActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 596 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
[[nodiscard]] Future<Void> setBackupKeys( BackupData* const& self, std::map<UID, Version> const& savedLogVersions ) {
															#line 596 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	return Future<Void>(new SetBackupKeysActor(self, savedLogVersions));
															#line 4486 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
}

#line 644 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"

// Note only worker with Tag (-2,0) runs this actor so that the latest saved
// version key is set by one process, which is stored in each BackupConfig in
// the system space. The client can know if a backup is restorable by checking
// log saved version > snapshot version.
															#line 4495 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via monitorBackupProgress()
															#line 649 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
template <class MonitorBackupProgressActor>
															#line 649 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
class MonitorBackupProgressActorState {
															#line 4502 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
public:
															#line 649 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	MonitorBackupProgressActorState(BackupData* const& self) 
															#line 649 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
															#line 649 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		 : self(self),
															#line 650 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   interval()
															#line 4511 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("monitorBackupProgress", reinterpret_cast<unsigned long>(this));

	}
	~MonitorBackupProgressActorState() 
	{
		fdb_probe_actor_destroy("monitorBackupProgress", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 652 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			;
															#line 4526 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MonitorBackupProgressActorState();
		static_cast<MonitorBackupProgressActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 653 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		interval = delay(SERVER_KNOBS->WORKER_LOGGING_INTERVAL / 2.0);
															#line 654 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		;
															#line 4558 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 660 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		progress = Reference<BackupProgress>(new BackupProgress(self->myId, {}));
															#line 661 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		StrictFuture<Void> __when_expr_1 = getBackupProgress(self->cx, self->myId, progress, false);
															#line 661 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (static_cast<MonitorBackupProgressActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4571 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<MonitorBackupProgressActor*>(this)->actor_wait_state = 2;
															#line 661 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MonitorBackupProgressActor, 1, Void >*>(static_cast<MonitorBackupProgressActor*>(this)));
															#line 4576 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
															#line 654 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (!(self->backups.empty() || !self->logSystem.get()))
															#line 4592 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		{
			return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 655 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		StrictFuture<Void> __when_expr_0 = self->changedTrigger.onTrigger() || self->logSystem.onChange();
															#line 655 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (static_cast<MonitorBackupProgressActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 4600 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<MonitorBackupProgressActor*>(this)->actor_wait_state = 1;
															#line 655 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MonitorBackupProgressActor, 0, Void >*>(static_cast<MonitorBackupProgressActor*>(this)));
															#line 4605 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MonitorBackupProgressActor*>(this)->actor_wait_state > 0) static_cast<MonitorBackupProgressActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorBackupProgressActor*>(this)->ActorCallback< MonitorBackupProgressActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorBackupProgressActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorBackupProgress", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBackupProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBackupProgress", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MonitorBackupProgressActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorBackupProgress", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBackupProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBackupProgress", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MonitorBackupProgressActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorBackupProgress", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBackupProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBackupProgress", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 662 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		tagVersions = progress->getEpochStatus(self->recruitedEpoch);
															#line 663 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		savedLogVersions = std::map<UID, Version>();
															#line 664 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (tagVersions.size() != self->totalTags)
															#line 4718 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		{
															#line 665 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			StrictFuture<Void> __when_expr_2 = interval;
															#line 665 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (static_cast<MonitorBackupProgressActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4724 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<MonitorBackupProgressActor*>(this)->actor_wait_state = 3;
															#line 665 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MonitorBackupProgressActor, 2, Void >*>(static_cast<MonitorBackupProgressActor*>(this)));
															#line 4729 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 662 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		tagVersions = progress->getEpochStatus(self->recruitedEpoch);
															#line 663 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		savedLogVersions = std::map<UID, Version>();
															#line 664 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (tagVersions.size() != self->totalTags)
															#line 4747 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		{
															#line 665 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			StrictFuture<Void> __when_expr_2 = interval;
															#line 665 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (static_cast<MonitorBackupProgressActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4753 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<MonitorBackupProgressActor*>(this)->actor_wait_state = 3;
															#line 665 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MonitorBackupProgressActor, 2, Void >*>(static_cast<MonitorBackupProgressActor*>(this)));
															#line 4758 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<MonitorBackupProgressActor*>(this)->actor_wait_state > 0) static_cast<MonitorBackupProgressActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorBackupProgressActor*>(this)->ActorCallback< MonitorBackupProgressActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorBackupProgressActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorBackupProgress", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBackupProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBackupProgress", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MonitorBackupProgressActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorBackupProgress", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBackupProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBackupProgress", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< MonitorBackupProgressActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorBackupProgress", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBackupProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBackupProgress", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 670 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		for( auto& [uid, info] : self->backups ) {
															#line 671 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (self->recruitedEpoch == self->oldestBackupEpoch)
															#line 4849 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			{
															#line 673 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
				Version v = std::numeric_limits<Version>::max();
															#line 674 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
				for( const auto& [tag, version] : tagVersions ) {
															#line 675 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
					v = std::min(v, version);
															#line 4857 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
				}
															#line 677 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
				savedLogVersions.emplace(uid, v);
															#line 678 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
				TraceEvent("BackupWorkerSavedBackupVersion", self->myId).detail("BackupID", uid).detail("Version", v);
															#line 4863 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			}
		}
															#line 681 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		Future<Void> setKeys = savedLogVersions.empty() ? Void() : setBackupKeys(self, savedLogVersions);
															#line 683 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		StrictFuture<Void> __when_expr_3 = interval && setKeys;
															#line 683 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (static_cast<MonitorBackupProgressActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4872 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<MonitorBackupProgressActor*>(this)->actor_wait_state = 4;
															#line 683 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< MonitorBackupProgressActor, 3, Void >*>(static_cast<MonitorBackupProgressActor*>(this)));
															#line 4877 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<MonitorBackupProgressActor*>(this)->actor_wait_state > 0) static_cast<MonitorBackupProgressActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorBackupProgressActor*>(this)->ActorCallback< MonitorBackupProgressActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorBackupProgressActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorBackupProgress", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBackupProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBackupProgress", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< MonitorBackupProgressActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorBackupProgress", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBackupProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBackupProgress", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< MonitorBackupProgressActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorBackupProgress", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBackupProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBackupProgress", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont6(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<MonitorBackupProgressActor*>(this)->actor_wait_state > 0) static_cast<MonitorBackupProgressActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorBackupProgressActor*>(this)->ActorCallback< MonitorBackupProgressActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorBackupProgressActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorBackupProgress", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBackupProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBackupProgress", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< MonitorBackupProgressActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorBackupProgress", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBackupProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBackupProgress", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< MonitorBackupProgressActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorBackupProgress", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBackupProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBackupProgress", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 649 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	BackupData* self;
															#line 650 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	Future<Void> interval;
															#line 660 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	Reference<BackupProgress> progress;
															#line 662 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	std::map<Tag, Version> tagVersions;
															#line 663 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	std::map<UID, Version> savedLogVersions;
															#line 5066 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
};
// This generated class is to be used only via monitorBackupProgress()
															#line 649 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
class MonitorBackupProgressActor final : public Actor<Void>, public ActorCallback< MonitorBackupProgressActor, 0, Void >, public ActorCallback< MonitorBackupProgressActor, 1, Void >, public ActorCallback< MonitorBackupProgressActor, 2, Void >, public ActorCallback< MonitorBackupProgressActor, 3, Void >, public FastAllocated<MonitorBackupProgressActor>, public MonitorBackupProgressActorState<MonitorBackupProgressActor> {
															#line 5071 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
public:
	using FastAllocated<MonitorBackupProgressActor>::operator new;
	using FastAllocated<MonitorBackupProgressActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17315287268545965824UL, 17004123248061694208UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MonitorBackupProgressActor, 0, Void >;
friend struct ActorCallback< MonitorBackupProgressActor, 1, Void >;
friend struct ActorCallback< MonitorBackupProgressActor, 2, Void >;
friend struct ActorCallback< MonitorBackupProgressActor, 3, Void >;
															#line 649 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	MonitorBackupProgressActor(BackupData* const& self) 
															#line 5091 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   MonitorBackupProgressActorState<MonitorBackupProgressActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("monitorBackupProgress", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11657820533249259776UL, 1975522792332850688UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBackupProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("monitorBackupProgress");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("monitorBackupProgress", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MonitorBackupProgressActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< MonitorBackupProgressActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< MonitorBackupProgressActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< MonitorBackupProgressActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 649 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
[[nodiscard]] Future<Void> monitorBackupProgress( BackupData* const& self ) {
															#line 649 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	return Future<Void>(new MonitorBackupProgressActor(self));
															#line 5127 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
}

#line 686 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"

															#line 5132 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via saveProgress()
															#line 687 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
template <class SaveProgressActor>
															#line 687 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
class SaveProgressActorState {
															#line 5139 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
public:
															#line 687 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	SaveProgressActorState(BackupData* const& self,Version const& backupVersion) 
															#line 687 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
															#line 687 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		 : self(self),
															#line 687 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   backupVersion(backupVersion),
															#line 688 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   tr(self->cx),
															#line 689 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   key(backupProgressKeyFor(self->myId))
															#line 5152 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("saveProgress", reinterpret_cast<unsigned long>(this));

	}
	~SaveProgressActorState() 
	{
		fdb_probe_actor_destroy("saveProgress", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 691 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			;
															#line 5167 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SaveProgressActorState();
		static_cast<SaveProgressActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 695 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 696 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 697 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 699 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			WorkerBackupStatus status(self->backupEpoch, backupVersion, self->tag, self->totalTags);
															#line 700 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			tr.set(key, backupProgressValue(status));
															#line 701 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			tr.addReadConflictRange(singleKeyRange(key));
															#line 702 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			StrictFuture<Void> __when_expr_0 = tr.commit();
															#line 702 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (static_cast<SaveProgressActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5212 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<SaveProgressActor*>(this)->actor_wait_state = 1;
															#line 702 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SaveProgressActor, 0, Void >*>(static_cast<SaveProgressActor*>(this)));
															#line 5217 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 705 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 705 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (static_cast<SaveProgressActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5241 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<SaveProgressActor*>(this)->actor_wait_state = 2;
															#line 705 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SaveProgressActor, 1, Void >*>(static_cast<SaveProgressActor*>(this)));
															#line 5246 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 703 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (!static_cast<SaveProgressActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SaveProgressActorState(); static_cast<SaveProgressActor*>(this)->destroy(); return 0; }
															#line 5261 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		new (&static_cast<SaveProgressActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SaveProgressActorState();
		static_cast<SaveProgressActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 703 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (!static_cast<SaveProgressActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SaveProgressActorState(); static_cast<SaveProgressActor*>(this)->destroy(); return 0; }
															#line 5273 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		new (&static_cast<SaveProgressActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SaveProgressActorState();
		static_cast<SaveProgressActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SaveProgressActor*>(this)->actor_wait_state > 0) static_cast<SaveProgressActor*>(this)->actor_wait_state = 0;
		static_cast<SaveProgressActor*>(this)->ActorCallback< SaveProgressActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SaveProgressActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("saveProgress", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SaveProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("saveProgress", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SaveProgressActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("saveProgress", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SaveProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("saveProgress", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SaveProgressActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("saveProgress", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SaveProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("saveProgress", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<SaveProgressActor*>(this)->actor_wait_state > 0) static_cast<SaveProgressActor*>(this)->actor_wait_state = 0;
		static_cast<SaveProgressActor*>(this)->ActorCallback< SaveProgressActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SaveProgressActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("saveProgress", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SaveProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("saveProgress", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< SaveProgressActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("saveProgress", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SaveProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("saveProgress", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< SaveProgressActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("saveProgress", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SaveProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("saveProgress", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 687 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	BackupData* self;
															#line 687 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	Version backupVersion;
															#line 688 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	Transaction tr;
															#line 689 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	Key key;
															#line 5451 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
};
// This generated class is to be used only via saveProgress()
															#line 687 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
class SaveProgressActor final : public Actor<Void>, public ActorCallback< SaveProgressActor, 0, Void >, public ActorCallback< SaveProgressActor, 1, Void >, public FastAllocated<SaveProgressActor>, public SaveProgressActorState<SaveProgressActor> {
															#line 5456 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
public:
	using FastAllocated<SaveProgressActor>::operator new;
	using FastAllocated<SaveProgressActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5903415095805166080UL, 1958035725625512448UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SaveProgressActor, 0, Void >;
friend struct ActorCallback< SaveProgressActor, 1, Void >;
															#line 687 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	SaveProgressActor(BackupData* const& self,Version const& backupVersion) 
															#line 5474 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   SaveProgressActorState<SaveProgressActor>(self, backupVersion),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("saveProgress", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11181064400611269888UL, 12244176878936082688UL);
		ActorExecutionContextHelper __helper(static_cast<SaveProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("saveProgress");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("saveProgress", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SaveProgressActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< SaveProgressActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 687 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
[[nodiscard]] Future<Void> saveProgress( BackupData* const& self, Version const& backupVersion ) {
															#line 687 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	return Future<Void>(new SaveProgressActor(self, backupVersion));
															#line 5508 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
}

#line 709 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"

// Write a mutation to a log file. Note the mutation can be different from
// message.message for clear mutations.
															#line 5515 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via addMutation()
															#line 712 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
template <class AddMutationActor>
															#line 712 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
class AddMutationActorState {
															#line 5522 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
public:
															#line 712 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	AddMutationActorState(Reference<IBackupFile> const& logFile,VersionedMessage const& message,StringRef const& mutation,int64_t* const& blockEnd,int const& blockSize) 
															#line 712 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
															#line 712 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		 : logFile(logFile),
															#line 712 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   message(message),
															#line 712 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   mutation(mutation),
															#line 712 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   blockEnd(blockEnd),
															#line 712 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   blockSize(blockSize),
															#line 718 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   bytes(sizeof(Version) + sizeof(uint32_t) + sizeof(int) + mutation.size())
															#line 5539 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("addMutation", reinterpret_cast<unsigned long>(this));

	}
	~AddMutationActorState() 
	{
		fdb_probe_actor_destroy("addMutation", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 724 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			BinaryWriter wr(Unversioned());
															#line 725 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			wr << bigEndian64(message.version.version) << bigEndian32(message.version.sub) << bigEndian32(mutation.size());
															#line 726 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			header = wr.toValue();
															#line 729 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (logFile->size() + bytes > *blockEnd)
															#line 5560 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			{
															#line 731 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
				const int bytesLeft = *blockEnd - logFile->size();
															#line 732 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
				if (bytesLeft > 0)
															#line 5566 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
				{
															#line 733 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
					paddingFFs = fileBackup::makePadding(bytesLeft);
															#line 734 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
					StrictFuture<Void> __when_expr_0 = logFile->append(paddingFFs.begin(), bytesLeft);
															#line 734 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
					if (static_cast<AddMutationActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5574 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
					if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
					static_cast<AddMutationActor*>(this)->actor_wait_state = 1;
															#line 734 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
					__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< AddMutationActor, 0, Void >*>(static_cast<AddMutationActor*>(this)));
															#line 5579 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
					loopDepth = 0;
				}
				else
				{
					loopDepth = a_body1cont2(loopDepth);
				}
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~AddMutationActorState();
		static_cast<AddMutationActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 742 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		StrictFuture<Void> __when_expr_2 = logFile->append((void*)header.begin(), header.size());
															#line 742 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (static_cast<AddMutationActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5614 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<AddMutationActor*>(this)->actor_wait_state = 3;
															#line 742 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< AddMutationActor, 2, Void >*>(static_cast<AddMutationActor*>(this)));
															#line 5619 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 737 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		*blockEnd += blockSize;
															#line 739 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		StrictFuture<Void> __when_expr_1 = logFile->append((uint8_t*)&PARTITIONED_MLOG_VERSION, sizeof(PARTITIONED_MLOG_VERSION));
															#line 739 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (static_cast<AddMutationActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5632 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<AddMutationActor*>(this)->actor_wait_state = 2;
															#line 739 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< AddMutationActor, 1, Void >*>(static_cast<AddMutationActor*>(this)));
															#line 5637 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<AddMutationActor*>(this)->actor_wait_state > 0) static_cast<AddMutationActor*>(this)->actor_wait_state = 0;
		static_cast<AddMutationActor*>(this)->ActorCallback< AddMutationActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AddMutationActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("addMutation", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddMutationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addMutation", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< AddMutationActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("addMutation", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddMutationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addMutation", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< AddMutationActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("addMutation", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AddMutationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addMutation", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<AddMutationActor*>(this)->actor_wait_state > 0) static_cast<AddMutationActor*>(this)->actor_wait_state = 0;
		static_cast<AddMutationActor*>(this)->ActorCallback< AddMutationActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AddMutationActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("addMutation", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddMutationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addMutation", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< AddMutationActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("addMutation", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddMutationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addMutation", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< AddMutationActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("addMutation", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AddMutationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addMutation", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 743 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		StrictFuture<Void> __when_expr_3 = logFile->append(mutation.begin(), mutation.size());
															#line 743 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (static_cast<AddMutationActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5822 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont5when1(__when_expr_3.get(), loopDepth); };
		static_cast<AddMutationActor*>(this)->actor_wait_state = 4;
															#line 743 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< AddMutationActor, 3, Void >*>(static_cast<AddMutationActor*>(this)));
															#line 5827 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 743 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		StrictFuture<Void> __when_expr_3 = logFile->append(mutation.begin(), mutation.size());
															#line 743 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (static_cast<AddMutationActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5838 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont5when1(__when_expr_3.get(), loopDepth); };
		static_cast<AddMutationActor*>(this)->actor_wait_state = 4;
															#line 743 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< AddMutationActor, 3, Void >*>(static_cast<AddMutationActor*>(this)));
															#line 5843 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<AddMutationActor*>(this)->actor_wait_state > 0) static_cast<AddMutationActor*>(this)->actor_wait_state = 0;
		static_cast<AddMutationActor*>(this)->ActorCallback< AddMutationActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AddMutationActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("addMutation", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddMutationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addMutation", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< AddMutationActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("addMutation", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddMutationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addMutation", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< AddMutationActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("addMutation", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AddMutationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addMutation", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 744 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (!static_cast<AddMutationActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~AddMutationActorState(); static_cast<AddMutationActor*>(this)->destroy(); return 0; }
															#line 5927 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		new (&static_cast<AddMutationActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~AddMutationActorState();
		static_cast<AddMutationActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 744 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (!static_cast<AddMutationActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~AddMutationActorState(); static_cast<AddMutationActor*>(this)->destroy(); return 0; }
															#line 5939 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		new (&static_cast<AddMutationActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~AddMutationActorState();
		static_cast<AddMutationActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<AddMutationActor*>(this)->actor_wait_state > 0) static_cast<AddMutationActor*>(this)->actor_wait_state = 0;
		static_cast<AddMutationActor*>(this)->ActorCallback< AddMutationActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AddMutationActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("addMutation", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddMutationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addMutation", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< AddMutationActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("addMutation", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddMutationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addMutation", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< AddMutationActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("addMutation", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AddMutationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addMutation", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 712 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	Reference<IBackupFile> logFile;
															#line 712 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	VersionedMessage message;
															#line 712 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	StringRef mutation;
															#line 712 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	int64_t* blockEnd;
															#line 712 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	int blockSize;
															#line 718 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	int bytes;
															#line 726 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	Standalone<StringRef> header;
															#line 733 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	Value paddingFFs;
															#line 6038 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
};
// This generated class is to be used only via addMutation()
															#line 712 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
class AddMutationActor final : public Actor<Void>, public ActorCallback< AddMutationActor, 0, Void >, public ActorCallback< AddMutationActor, 1, Void >, public ActorCallback< AddMutationActor, 2, Void >, public ActorCallback< AddMutationActor, 3, Void >, public FastAllocated<AddMutationActor>, public AddMutationActorState<AddMutationActor> {
															#line 6043 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
public:
	using FastAllocated<AddMutationActor>::operator new;
	using FastAllocated<AddMutationActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10301148521777342208UL, 8480630957825501184UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< AddMutationActor, 0, Void >;
friend struct ActorCallback< AddMutationActor, 1, Void >;
friend struct ActorCallback< AddMutationActor, 2, Void >;
friend struct ActorCallback< AddMutationActor, 3, Void >;
															#line 712 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	AddMutationActor(Reference<IBackupFile> const& logFile,VersionedMessage const& message,StringRef const& mutation,int64_t* const& blockEnd,int const& blockSize) 
															#line 6063 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   AddMutationActorState<AddMutationActor>(logFile, message, mutation, blockEnd, blockSize),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("addMutation", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1351666754517471232UL, 8923191686972481024UL);
		ActorExecutionContextHelper __helper(static_cast<AddMutationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("addMutation");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("addMutation", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< AddMutationActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< AddMutationActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< AddMutationActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< AddMutationActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 712 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
[[nodiscard]] Future<Void> addMutation( Reference<IBackupFile> const& logFile, VersionedMessage const& message, StringRef const& mutation, int64_t* const& blockEnd, int const& blockSize ) {
															#line 712 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	return Future<Void>(new AddMutationActor(logFile, message, mutation, blockEnd, blockSize));
															#line 6099 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
}

#line 746 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"

															#line 6104 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via updateLogBytesWritten()
															#line 747 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
template <class UpdateLogBytesWrittenActor>
															#line 747 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
class UpdateLogBytesWrittenActorState {
															#line 6111 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
public:
															#line 747 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	UpdateLogBytesWrittenActorState(BackupData* const& self,std::vector<UID> const& backupUids,std::vector<Reference<IBackupFile>> const& logFiles) 
															#line 747 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
															#line 747 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		 : self(self),
															#line 747 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   backupUids(backupUids),
															#line 747 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   logFiles(logFiles),
															#line 750 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   tr(new ReadYourWritesTransaction(self->cx))
															#line 6124 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("updateLogBytesWritten", reinterpret_cast<unsigned long>(this));

	}
	~UpdateLogBytesWrittenActorState() 
	{
		fdb_probe_actor_destroy("updateLogBytesWritten", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 752 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			ASSERT(backupUids.size() == logFiles.size());
															#line 753 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			;
															#line 6141 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~UpdateLogBytesWrittenActorState();
		static_cast<UpdateLogBytesWrittenActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 755 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 756 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			tr->setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 757 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 759 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			for(int i = 0;i < backupUids.size();i++) {
															#line 760 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
				BackupConfig config(backupUids[i]);
															#line 761 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
				config.logBytesWritten().atomicOp(tr, logFiles[i]->size(), MutationRef::AddValue);
															#line 6182 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			}
															#line 763 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			StrictFuture<Void> __when_expr_0 = tr->commit();
															#line 763 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (static_cast<UpdateLogBytesWrittenActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6188 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<UpdateLogBytesWrittenActor*>(this)->actor_wait_state = 1;
															#line 763 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< UpdateLogBytesWrittenActor, 0, Void >*>(static_cast<UpdateLogBytesWrittenActor*>(this)));
															#line 6193 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 766 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr->onError(e);
															#line 766 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (static_cast<UpdateLogBytesWrittenActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6217 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<UpdateLogBytesWrittenActor*>(this)->actor_wait_state = 2;
															#line 766 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< UpdateLogBytesWrittenActor, 1, Void >*>(static_cast<UpdateLogBytesWrittenActor*>(this)));
															#line 6222 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 764 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (!static_cast<UpdateLogBytesWrittenActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UpdateLogBytesWrittenActorState(); static_cast<UpdateLogBytesWrittenActor*>(this)->destroy(); return 0; }
															#line 6237 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		new (&static_cast<UpdateLogBytesWrittenActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~UpdateLogBytesWrittenActorState();
		static_cast<UpdateLogBytesWrittenActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 764 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (!static_cast<UpdateLogBytesWrittenActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UpdateLogBytesWrittenActorState(); static_cast<UpdateLogBytesWrittenActor*>(this)->destroy(); return 0; }
															#line 6249 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		new (&static_cast<UpdateLogBytesWrittenActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~UpdateLogBytesWrittenActorState();
		static_cast<UpdateLogBytesWrittenActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UpdateLogBytesWrittenActor*>(this)->actor_wait_state > 0) static_cast<UpdateLogBytesWrittenActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateLogBytesWrittenActor*>(this)->ActorCallback< UpdateLogBytesWrittenActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateLogBytesWrittenActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateLogBytesWritten", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateLogBytesWrittenActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateLogBytesWritten", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UpdateLogBytesWrittenActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateLogBytesWritten", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateLogBytesWrittenActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateLogBytesWritten", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< UpdateLogBytesWrittenActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateLogBytesWritten", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateLogBytesWrittenActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateLogBytesWritten", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<UpdateLogBytesWrittenActor*>(this)->actor_wait_state > 0) static_cast<UpdateLogBytesWrittenActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateLogBytesWrittenActor*>(this)->ActorCallback< UpdateLogBytesWrittenActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateLogBytesWrittenActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateLogBytesWritten", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateLogBytesWrittenActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateLogBytesWritten", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< UpdateLogBytesWrittenActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateLogBytesWritten", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateLogBytesWrittenActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateLogBytesWritten", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< UpdateLogBytesWrittenActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateLogBytesWritten", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateLogBytesWrittenActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateLogBytesWritten", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 747 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	BackupData* self;
															#line 747 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	std::vector<UID> backupUids;
															#line 747 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	std::vector<Reference<IBackupFile>> logFiles;
															#line 750 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 6427 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
};
// This generated class is to be used only via updateLogBytesWritten()
															#line 747 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
class UpdateLogBytesWrittenActor final : public Actor<Void>, public ActorCallback< UpdateLogBytesWrittenActor, 0, Void >, public ActorCallback< UpdateLogBytesWrittenActor, 1, Void >, public FastAllocated<UpdateLogBytesWrittenActor>, public UpdateLogBytesWrittenActorState<UpdateLogBytesWrittenActor> {
															#line 6432 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
public:
	using FastAllocated<UpdateLogBytesWrittenActor>::operator new;
	using FastAllocated<UpdateLogBytesWrittenActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1017074875182789888UL, 216106435017877760UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< UpdateLogBytesWrittenActor, 0, Void >;
friend struct ActorCallback< UpdateLogBytesWrittenActor, 1, Void >;
															#line 747 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	UpdateLogBytesWrittenActor(BackupData* const& self,std::vector<UID> const& backupUids,std::vector<Reference<IBackupFile>> const& logFiles) 
															#line 6450 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   UpdateLogBytesWrittenActorState<UpdateLogBytesWrittenActor>(self, backupUids, logFiles),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("updateLogBytesWritten", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2501124557465260800UL, 1735817436001543168UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateLogBytesWrittenActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("updateLogBytesWritten");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("updateLogBytesWritten", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< UpdateLogBytesWrittenActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< UpdateLogBytesWrittenActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 747 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
[[nodiscard]] static Future<Void> updateLogBytesWritten( BackupData* const& self, std::vector<UID> const& backupUids, std::vector<Reference<IBackupFile>> const& logFiles ) {
															#line 747 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	return Future<Void>(new UpdateLogBytesWrittenActor(self, backupUids, logFiles));
															#line 6484 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
}

#line 770 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"

// Saves messages in the range of [0, numMsg) to a file and then remove these
// messages. The file content format is a sequence of (Version, sub#, msgSize, message).
// Note only ready backups are saved.
															#line 6492 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via saveMutationsToFile()
															#line 774 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
template <class SaveMutationsToFileActor>
															#line 774 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
class SaveMutationsToFileActorState {
															#line 6499 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
public:
															#line 774 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	SaveMutationsToFileActorState(BackupData* const& self,Version const& popVersion,int const& numMsg) 
															#line 774 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
															#line 774 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		 : self(self),
															#line 774 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   popVersion(popVersion),
															#line 774 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   numMsg(numMsg),
															#line 775 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   blockSize(SERVER_KNOBS->BACKUP_FILE_BLOCK_BYTES),
															#line 776 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   logFileFutures(),
															#line 777 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   logFiles(),
															#line 778 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   blockEnds(),
															#line 779 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   activeUids(),
															#line 780 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   beginVersions(),
															#line 781 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   keyRangeMap(),
															#line 782 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   mutations(),
															#line 783 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   idx()
															#line 6528 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("saveMutationsToFile", reinterpret_cast<unsigned long>(this));

	}
	~SaveMutationsToFileActorState() 
	{
		fdb_probe_actor_destroy("saveMutationsToFile", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 786 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			;
															#line 6543 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SaveMutationsToFileActorState();
		static_cast<SaveMutationsToFileActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 790 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		for(auto it = self->backups.begin();it != self->backups.end();) {
															#line 791 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (it->second.stopped || !it->second.container.get().present())
															#line 6568 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			{
															#line 792 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
				TraceEvent("BackupWorkerNoContainer", self->myId).detail("BackupId", it->first);
															#line 793 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
				it = self->backups.erase(it);
															#line 6574 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
				continue;
			}
															#line 796 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			const int index = logFileFutures.size();
															#line 797 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			activeUids.push_back(it->first);
															#line 798 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			self->insertRanges(keyRangeMap, it->second.ranges.get(), index);
															#line 800 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (it->second.lastSavedVersion == invalidVersion)
															#line 6585 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			{
															#line 801 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
				if (it->second.startVersion > self->startVersion && !self->messages.empty())
															#line 6589 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
				{
															#line 803 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
					it->second.lastSavedVersion = self->messages[0].getVersion();
															#line 6593 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
				}
				else
				{
															#line 805 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
					it->second.lastSavedVersion = std::max({ self->popVersion, self->savedVersion, self->startVersion });
															#line 6599 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
				}
															#line 807 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
				TraceEvent("BackupWorkerTrueUp", self->myId).detail("LastSavedVersion", it->second.lastSavedVersion);
															#line 6603 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			}
															#line 811 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			beginVersions.push_back(it->second.lastSavedVersion);
															#line 813 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			logFileFutures.push_back(it->second.container.get().get()->writeTaggedLogFile( it->second.lastSavedVersion, popVersion + 1, blockSize, self->tag.id, self->totalTags));
															#line 815 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			it++;
															#line 6611 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		}
															#line 818 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		keyRangeMap.coalesce(allKeys);
															#line 819 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		StrictFuture<Void> __when_expr_1 = waitForAll(logFileFutures);
															#line 819 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (static_cast<SaveMutationsToFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6619 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<SaveMutationsToFileActor*>(this)->actor_wait_state = 2;
															#line 819 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SaveMutationsToFileActor, 1, Void >*>(static_cast<SaveMutationsToFileActor*>(this)));
															#line 6624 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 786 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (!(!self->isAllInfoReady()))
															#line 6640 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 787 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		StrictFuture<Void> __when_expr_0 = self->waitAllInfoReady();
															#line 787 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (static_cast<SaveMutationsToFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6648 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<SaveMutationsToFileActor*>(this)->actor_wait_state = 1;
															#line 787 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SaveMutationsToFileActor, 0, Void >*>(static_cast<SaveMutationsToFileActor*>(this)));
															#line 6653 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SaveMutationsToFileActor*>(this)->actor_wait_state > 0) static_cast<SaveMutationsToFileActor*>(this)->actor_wait_state = 0;
		static_cast<SaveMutationsToFileActor*>(this)->ActorCallback< SaveMutationsToFileActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SaveMutationsToFileActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("saveMutationsToFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SaveMutationsToFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("saveMutationsToFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SaveMutationsToFileActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("saveMutationsToFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SaveMutationsToFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("saveMutationsToFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SaveMutationsToFileActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("saveMutationsToFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SaveMutationsToFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("saveMutationsToFile", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 821 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		std::transform(logFileFutures.begin(), logFileFutures.end(), std::back_inserter(logFiles), [](const Future<Reference<IBackupFile>>& f) { return f.get(); });
															#line 826 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		ASSERT(activeUids.size() == logFiles.size() && beginVersions.size() == logFiles.size());
															#line 827 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		for(int i = 0;i < logFiles.size();i++) {
															#line 828 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			TraceEvent("OpenMutationFile", self->myId) .detail("BackupID", activeUids[i]) .detail("TagId", self->tag.id) .detail("File", logFiles[i]->getFileName());
															#line 6768 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		}
															#line 834 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		blockEnds = std::vector<int64_t>(logFiles.size(), 0);
															#line 835 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		idx = 0;
															#line 6774 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 821 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		std::transform(logFileFutures.begin(), logFileFutures.end(), std::back_inserter(logFiles), [](const Future<Reference<IBackupFile>>& f) { return f.get(); });
															#line 826 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		ASSERT(activeUids.size() == logFiles.size() && beginVersions.size() == logFiles.size());
															#line 827 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		for(int i = 0;i < logFiles.size();i++) {
															#line 828 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			TraceEvent("OpenMutationFile", self->myId) .detail("BackupID", activeUids[i]) .detail("TagId", self->tag.id) .detail("File", logFiles[i]->getFileName());
															#line 6789 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		}
															#line 834 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		blockEnds = std::vector<int64_t>(logFiles.size(), 0);
															#line 835 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		idx = 0;
															#line 6795 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<SaveMutationsToFileActor*>(this)->actor_wait_state > 0) static_cast<SaveMutationsToFileActor*>(this)->actor_wait_state = 0;
		static_cast<SaveMutationsToFileActor*>(this)->ActorCallback< SaveMutationsToFileActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SaveMutationsToFileActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("saveMutationsToFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SaveMutationsToFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("saveMutationsToFile", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< SaveMutationsToFileActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("saveMutationsToFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SaveMutationsToFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("saveMutationsToFile", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< SaveMutationsToFileActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("saveMutationsToFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SaveMutationsToFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("saveMutationsToFile", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont8(int loopDepth) 
	{
															#line 878 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		std::vector<Future<Void>> finished;
															#line 879 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		std::transform(logFiles.begin(), logFiles.end(), std::back_inserter(finished), [](const Reference<IBackupFile>& f) { return f->finish(); });
															#line 883 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		StrictFuture<Void> __when_expr_3 = waitForAll(finished);
															#line 883 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (static_cast<SaveMutationsToFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6885 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont8when1(__when_expr_3.get(), loopDepth); };
		static_cast<SaveMutationsToFileActor*>(this)->actor_wait_state = 4;
															#line 883 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< SaveMutationsToFileActor, 3, Void >*>(static_cast<SaveMutationsToFileActor*>(this)));
															#line 6890 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1(int loopDepth) 
	{
															#line 835 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (!(idx < numMsg))
															#line 6906 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		{
			return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 836 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		auto& message = self->messages[idx];
															#line 837 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		MutationRef m;
															#line 838 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (!message.isCandidateBackupMessage(&m))
															#line 6916 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		{
			return a_body1cont2continue1(loopDepth); // continue
		}
															#line 842 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		DEBUG_MUTATION("addMutation", message.version.version, m, self->myId) .detail("KCV", self->minKnownCommittedVersion) .detail("SavedVersion", self->savedVersion);
															#line 846 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		std::vector<Future<Void>> adds;
															#line 847 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (m.type != MutationRef::Type::ClearRange)
															#line 6926 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		{
															#line 848 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			for( int index : keyRangeMap[m.param1] ) {
															#line 849 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
				if (message.getVersion() >= beginVersions[index])
															#line 6932 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
				{
															#line 850 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
					adds.push_back( addMutation(logFiles[index], message, message.message, &blockEnds[index], blockSize));
															#line 6936 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
				}
			}
		}
		else
		{
															#line 855 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			KeyRangeRef mutationRange(m.param1, m.param2);
															#line 856 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			KeyRangeRef intersectionRange;
															#line 859 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			for( auto range : keyRangeMap.intersectingRanges(mutationRange) ) {
															#line 860 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
				const auto& subrange = range.range();
															#line 861 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
				intersectionRange = mutationRange & subrange;
															#line 862 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
				MutationRef subm(MutationRef::Type::ClearRange, intersectionRange.begin, intersectionRange.end);
															#line 863 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
				BinaryWriter wr(AssumeVersion(g_network->protocolVersion()));
															#line 864 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
				wr << subm;
															#line 865 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
				mutations.push_back(wr.toValue());
															#line 866 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
				for( int index : range.value() ) {
															#line 867 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
					if (message.getVersion() >= beginVersions[index])
															#line 6964 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
					{
															#line 868 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
						adds.push_back( addMutation(logFiles[index], message, mutations.back(), &blockEnds[index], blockSize));
															#line 6968 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
					}
				}
			}
		}
															#line 874 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		StrictFuture<Void> __when_expr_2 = waitForAll(adds);
															#line 874 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (static_cast<SaveMutationsToFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6977 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when1(__when_expr_2.get(), loopDepth); };
		static_cast<SaveMutationsToFileActor*>(this)->actor_wait_state = 3;
															#line 874 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< SaveMutationsToFileActor, 2, Void >*>(static_cast<SaveMutationsToFileActor*>(this)));
															#line 6982 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2break1(int loopDepth) 
	{
		try {
			return a_body1cont8(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2continue1(int loopDepth) 
	{
															#line 835 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		idx++;
															#line 7004 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 875 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		mutations.clear();
															#line 835 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		idx++;
															#line 7015 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 875 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		mutations.clear();
															#line 835 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		idx++;
															#line 7026 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<SaveMutationsToFileActor*>(this)->actor_wait_state > 0) static_cast<SaveMutationsToFileActor*>(this)->actor_wait_state = 0;
		static_cast<SaveMutationsToFileActor*>(this)->ActorCallback< SaveMutationsToFileActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SaveMutationsToFileActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("saveMutationsToFile", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SaveMutationsToFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("saveMutationsToFile", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< SaveMutationsToFileActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("saveMutationsToFile", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SaveMutationsToFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("saveMutationsToFile", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< SaveMutationsToFileActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("saveMutationsToFile", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SaveMutationsToFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("saveMutationsToFile", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont10(Void const& _,int loopDepth) 
	{
															#line 885 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		for( const auto& file : logFiles ) {
															#line 886 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			TraceEvent("CloseMutationFile", self->myId) .detail("FileSize", file->size()) .detail("TagId", self->tag.id) .detail("File", file->getFileName());
															#line 7112 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		}
															#line 891 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		for( const UID& uid : activeUids ) {
															#line 892 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			self->backups[uid].lastSavedVersion = popVersion + 1;
															#line 7118 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		}
															#line 895 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		StrictFuture<Void> __when_expr_4 = updateLogBytesWritten(self, activeUids, logFiles);
															#line 895 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (static_cast<SaveMutationsToFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7124 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont10when1(__when_expr_4.get(), loopDepth); };
		static_cast<SaveMutationsToFileActor*>(this)->actor_wait_state = 5;
															#line 895 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< SaveMutationsToFileActor, 4, Void >*>(static_cast<SaveMutationsToFileActor*>(this)));
															#line 7129 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10(Void && _,int loopDepth) 
	{
															#line 885 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		for( const auto& file : logFiles ) {
															#line 886 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			TraceEvent("CloseMutationFile", self->myId) .detail("FileSize", file->size()) .detail("TagId", self->tag.id) .detail("File", file->getFileName());
															#line 7140 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		}
															#line 891 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		for( const UID& uid : activeUids ) {
															#line 892 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			self->backups[uid].lastSavedVersion = popVersion + 1;
															#line 7146 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		}
															#line 895 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		StrictFuture<Void> __when_expr_4 = updateLogBytesWritten(self, activeUids, logFiles);
															#line 895 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (static_cast<SaveMutationsToFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7152 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont10when1(__when_expr_4.get(), loopDepth); };
		static_cast<SaveMutationsToFileActor*>(this)->actor_wait_state = 5;
															#line 895 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< SaveMutationsToFileActor, 4, Void >*>(static_cast<SaveMutationsToFileActor*>(this)));
															#line 7157 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont8when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<SaveMutationsToFileActor*>(this)->actor_wait_state > 0) static_cast<SaveMutationsToFileActor*>(this)->actor_wait_state = 0;
		static_cast<SaveMutationsToFileActor*>(this)->ActorCallback< SaveMutationsToFileActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SaveMutationsToFileActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("saveMutationsToFile", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SaveMutationsToFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("saveMutationsToFile", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< SaveMutationsToFileActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("saveMutationsToFile", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SaveMutationsToFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("saveMutationsToFile", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< SaveMutationsToFileActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("saveMutationsToFile", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SaveMutationsToFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("saveMutationsToFile", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont10cont1(Void const& _,int loopDepth) 
	{
															#line 896 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (!static_cast<SaveMutationsToFileActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SaveMutationsToFileActorState(); static_cast<SaveMutationsToFileActor*>(this)->destroy(); return 0; }
															#line 7241 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		new (&static_cast<SaveMutationsToFileActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SaveMutationsToFileActorState();
		static_cast<SaveMutationsToFileActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont10cont1(Void && _,int loopDepth) 
	{
															#line 896 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (!static_cast<SaveMutationsToFileActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SaveMutationsToFileActorState(); static_cast<SaveMutationsToFileActor*>(this)->destroy(); return 0; }
															#line 7253 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		new (&static_cast<SaveMutationsToFileActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SaveMutationsToFileActorState();
		static_cast<SaveMutationsToFileActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont10when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<SaveMutationsToFileActor*>(this)->actor_wait_state > 0) static_cast<SaveMutationsToFileActor*>(this)->actor_wait_state = 0;
		static_cast<SaveMutationsToFileActor*>(this)->ActorCallback< SaveMutationsToFileActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SaveMutationsToFileActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("saveMutationsToFile", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SaveMutationsToFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont10when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("saveMutationsToFile", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< SaveMutationsToFileActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("saveMutationsToFile", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SaveMutationsToFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont10when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("saveMutationsToFile", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< SaveMutationsToFileActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("saveMutationsToFile", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SaveMutationsToFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("saveMutationsToFile", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 774 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	BackupData* self;
															#line 774 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	Version popVersion;
															#line 774 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	int numMsg;
															#line 775 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	int blockSize;
															#line 776 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	std::vector<Future<Reference<IBackupFile>>> logFileFutures;
															#line 777 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	std::vector<Reference<IBackupFile>> logFiles;
															#line 778 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	std::vector<int64_t> blockEnds;
															#line 779 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	std::vector<UID> activeUids;
															#line 780 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	std::vector<Version> beginVersions;
															#line 781 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	KeyRangeMap<std::set<int>> keyRangeMap;
															#line 782 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	std::vector<Standalone<StringRef>> mutations;
															#line 783 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	int idx;
															#line 7360 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
};
// This generated class is to be used only via saveMutationsToFile()
															#line 774 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
class SaveMutationsToFileActor final : public Actor<Void>, public ActorCallback< SaveMutationsToFileActor, 0, Void >, public ActorCallback< SaveMutationsToFileActor, 1, Void >, public ActorCallback< SaveMutationsToFileActor, 2, Void >, public ActorCallback< SaveMutationsToFileActor, 3, Void >, public ActorCallback< SaveMutationsToFileActor, 4, Void >, public FastAllocated<SaveMutationsToFileActor>, public SaveMutationsToFileActorState<SaveMutationsToFileActor> {
															#line 7365 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
public:
	using FastAllocated<SaveMutationsToFileActor>::operator new;
	using FastAllocated<SaveMutationsToFileActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8865058522085733120UL, 13432680259008398592UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SaveMutationsToFileActor, 0, Void >;
friend struct ActorCallback< SaveMutationsToFileActor, 1, Void >;
friend struct ActorCallback< SaveMutationsToFileActor, 2, Void >;
friend struct ActorCallback< SaveMutationsToFileActor, 3, Void >;
friend struct ActorCallback< SaveMutationsToFileActor, 4, Void >;
															#line 774 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	SaveMutationsToFileActor(BackupData* const& self,Version const& popVersion,int const& numMsg) 
															#line 7386 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   SaveMutationsToFileActorState<SaveMutationsToFileActor>(self, popVersion, numMsg),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("saveMutationsToFile", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18095228256760288256UL, 3679545122714121728UL);
		ActorExecutionContextHelper __helper(static_cast<SaveMutationsToFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("saveMutationsToFile");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("saveMutationsToFile", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SaveMutationsToFileActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< SaveMutationsToFileActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< SaveMutationsToFileActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< SaveMutationsToFileActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< SaveMutationsToFileActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 774 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
[[nodiscard]] Future<Void> saveMutationsToFile( BackupData* const& self, Version const& popVersion, int const& numMsg ) {
															#line 774 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	return Future<Void>(new SaveMutationsToFileActor(self, popVersion, numMsg));
															#line 7423 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
}

#line 898 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"

// Uploads self->messages to cloud storage and updates savedVersion.
															#line 7429 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via uploadData()
															#line 900 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
template <class UploadDataActor>
															#line 900 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
class UploadDataActorState {
															#line 7436 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
public:
															#line 900 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	UploadDataActorState(BackupData* const& self) 
															#line 900 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
															#line 900 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		 : self(self),
															#line 901 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   popVersion(invalidVersion)
															#line 7445 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("uploadData", reinterpret_cast<unsigned long>(this));

	}
	~UploadDataActorState() 
	{
		fdb_probe_actor_destroy("uploadData", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 903 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			;
															#line 7460 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~UploadDataActorState();
		static_cast<UploadDataActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 905 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		uploadDelay = delay(SERVER_KNOBS->BACKUP_UPLOAD_DELAY);
															#line 907 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		numMsg = 0;
															#line 908 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		Version lastPopVersion = popVersion;
															#line 910 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		int lastVersionIndex = 0;
															#line 911 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		Version lastVersion = invalidVersion;
															#line 913 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		for( auto& message : self->messages ) {
															#line 915 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			const Version version = message.getVersion();
															#line 916 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (version > self->maxPopVersion())
															#line 7504 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			{
				break;
			}
															#line 919 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (version > popVersion)
															#line 7510 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			{
															#line 920 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
				lastVersionIndex = numMsg;
															#line 921 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
				lastVersion = popVersion;
															#line 922 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
				popVersion = version;
															#line 7518 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			}
															#line 924 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			numMsg++;
															#line 7522 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		}
															#line 926 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (self->pullFinished())
															#line 7526 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		{
															#line 927 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			popVersion = self->endVersion.get();
															#line 7530 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		}
		else
		{
															#line 930 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			popVersion = lastVersion;
															#line 931 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			numMsg = lastVersionIndex;
															#line 935 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			ASSERT(numMsg > 0 || self->lock->waiters() == 0);
															#line 7540 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		}
															#line 937 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (((numMsg > 0 || popVersion > lastPopVersion) && self->pulling) || self->pullFinished())
															#line 7544 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		{
															#line 938 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			TraceEvent("BackupWorkerSave", self->myId) .detail("Version", popVersion) .detail("LastPopVersion", lastPopVersion) .detail("Pulling", self->pulling) .detail("SavedVersion", self->savedVersion) .detail("NumMsg", numMsg) .detail("MsgQ", self->messages.size());
															#line 946 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			StrictFuture<Void> __when_expr_0 = saveMutationsToFile(self, popVersion, numMsg);
															#line 946 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (static_cast<UploadDataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7552 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<UploadDataActor*>(this)->actor_wait_state = 1;
															#line 946 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< UploadDataActor, 0, Void >*>(static_cast<UploadDataActor*>(this)));
															#line 7557 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 951 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (!self->pulling && self->backupEpoch == self->recruitedEpoch)
															#line 7571 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		{
															#line 952 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			self->eraseMessages(self->messages.size());
															#line 7575 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		}
															#line 955 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (popVersion > self->savedVersion && popVersion > self->popVersion)
															#line 7579 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		{
															#line 956 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			StrictFuture<Void> __when_expr_1 = saveProgress(self, popVersion);
															#line 956 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (static_cast<UploadDataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7585 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<UploadDataActor*>(this)->actor_wait_state = 2;
															#line 956 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< UploadDataActor, 1, Void >*>(static_cast<UploadDataActor*>(this)));
															#line 7590 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont9(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont7(Void const& _,int loopDepth) 
	{
															#line 947 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		self->eraseMessages(numMsg);
															#line 7604 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont7(Void && _,int loopDepth) 
	{
															#line 947 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		self->eraseMessages(numMsg);
															#line 7613 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UploadDataActor*>(this)->actor_wait_state > 0) static_cast<UploadDataActor*>(this)->actor_wait_state = 0;
		static_cast<UploadDataActor*>(this)->ActorCallback< UploadDataActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UploadDataActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("uploadData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UploadDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("uploadData", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UploadDataActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("uploadData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UploadDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("uploadData", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< UploadDataActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("uploadData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UploadDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("uploadData", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont9(int loopDepth) 
	{
															#line 965 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (self->allMessageSaved())
															#line 7697 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		{
															#line 966 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (!static_cast<UploadDataActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UploadDataActorState(); static_cast<UploadDataActor*>(this)->destroy(); return 0; }
															#line 7701 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			new (&static_cast<UploadDataActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~UploadDataActorState();
			static_cast<UploadDataActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 969 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (!self->pullFinished())
															#line 7709 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		{
															#line 970 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			StrictFuture<Void> __when_expr_2 = uploadDelay || self->doneTrigger.onTrigger();
															#line 970 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (static_cast<UploadDataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7715 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont9when1(__when_expr_2.get(), loopDepth); };
			static_cast<UploadDataActor*>(this)->actor_wait_state = 3;
															#line 970 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< UploadDataActor, 2, Void >*>(static_cast<UploadDataActor*>(this)));
															#line 7720 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont12(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont11(Void const& _,int loopDepth) 
	{
															#line 957 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		TraceEvent("BackupWorkerSavedProgress", self->myId) .detail("Tag", self->tag.toString()) .detail("Version", popVersion) .detail("MsgQ", self->messages.size());
															#line 961 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		self->savedVersion = std::max(popVersion, self->savedVersion);
															#line 962 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		self->pop();
															#line 7738 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont11(Void && _,int loopDepth) 
	{
															#line 957 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		TraceEvent("BackupWorkerSavedProgress", self->myId) .detail("Tag", self->tag.toString()) .detail("Version", popVersion) .detail("MsgQ", self->messages.size());
															#line 961 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		self->savedVersion = std::max(popVersion, self->savedVersion);
															#line 962 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		self->pop();
															#line 7751 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<UploadDataActor*>(this)->actor_wait_state > 0) static_cast<UploadDataActor*>(this)->actor_wait_state = 0;
		static_cast<UploadDataActor*>(this)->ActorCallback< UploadDataActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UploadDataActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("uploadData", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UploadDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("uploadData", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< UploadDataActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("uploadData", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UploadDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("uploadData", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< UploadDataActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("uploadData", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UploadDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("uploadData", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont12(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont14(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont14(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont9when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont14(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont9when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont14(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<UploadDataActor*>(this)->actor_wait_state > 0) static_cast<UploadDataActor*>(this)->actor_wait_state = 0;
		static_cast<UploadDataActor*>(this)->ActorCallback< UploadDataActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UploadDataActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("uploadData", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UploadDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont9when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("uploadData", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< UploadDataActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("uploadData", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UploadDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("uploadData", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< UploadDataActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("uploadData", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UploadDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("uploadData", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 900 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	BackupData* self;
															#line 901 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	Version popVersion;
															#line 905 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	Future<Void> uploadDelay;
															#line 907 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	int numMsg;
															#line 7932 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
};
// This generated class is to be used only via uploadData()
															#line 900 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
class UploadDataActor final : public Actor<Void>, public ActorCallback< UploadDataActor, 0, Void >, public ActorCallback< UploadDataActor, 1, Void >, public ActorCallback< UploadDataActor, 2, Void >, public FastAllocated<UploadDataActor>, public UploadDataActorState<UploadDataActor> {
															#line 7937 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
public:
	using FastAllocated<UploadDataActor>::operator new;
	using FastAllocated<UploadDataActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5399121756527844864UL, 7872676382149185024UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< UploadDataActor, 0, Void >;
friend struct ActorCallback< UploadDataActor, 1, Void >;
friend struct ActorCallback< UploadDataActor, 2, Void >;
															#line 900 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	UploadDataActor(BackupData* const& self) 
															#line 7956 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   UploadDataActorState<UploadDataActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("uploadData", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15797940681219010048UL, 1723175542107149824UL);
		ActorExecutionContextHelper __helper(static_cast<UploadDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("uploadData");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("uploadData", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< UploadDataActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< UploadDataActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< UploadDataActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 900 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
[[nodiscard]] Future<Void> uploadData( BackupData* const& self ) {
															#line 900 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	return Future<Void>(new UploadDataActor(self));
															#line 7991 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
}

#line 974 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"

															#line 7996 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via getNoopVersion()
															#line 975 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
template <class GetNoopVersionActor>
															#line 975 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
class GetNoopVersionActorState {
															#line 8003 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
public:
															#line 975 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	GetNoopVersionActorState(BackupData* const& self) 
															#line 975 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
															#line 975 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		 : self(self),
															#line 976 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   tr(self->cx)
															#line 8012 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getNoopVersion", reinterpret_cast<unsigned long>(this));

	}
	~GetNoopVersionActorState() 
	{
		fdb_probe_actor_destroy("getNoopVersion", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 978 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			;
															#line 8027 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetNoopVersionActorState();
		static_cast<GetNoopVersionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 980 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 981 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 982 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			tr.setOption(FDBTransactionOptions::READ_LOCK_AWARE);
															#line 984 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr.get(backupWorkerMaxNoopVersionKey);
															#line 984 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (static_cast<GetNoopVersionActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 8066 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetNoopVersionActor*>(this)->actor_wait_state = 1;
															#line 984 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetNoopVersionActor, 0, Optional<Value> >*>(static_cast<GetNoopVersionActor*>(this)));
															#line 8071 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 991 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 991 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (static_cast<GetNoopVersionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8095 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<GetNoopVersionActor*>(this)->actor_wait_state = 2;
															#line 991 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetNoopVersionActor, 1, Void >*>(static_cast<GetNoopVersionActor*>(this)));
															#line 8100 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> const& noopValue,int loopDepth) 
	{
															#line 985 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (noopValue.present())
															#line 8115 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		{
															#line 986 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (!static_cast<GetNoopVersionActor*>(this)->SAV<Version>::futures) { (void)(BinaryReader::fromStringRef<Version>(noopValue.get(), Unversioned())); this->~GetNoopVersionActorState(); static_cast<GetNoopVersionActor*>(this)->destroy(); return 0; }
															#line 8119 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			new (&static_cast<GetNoopVersionActor*>(this)->SAV< Version >::value()) Version(BinaryReader::fromStringRef<Version>(noopValue.get(), Unversioned()));
			this->~GetNoopVersionActorState();
			static_cast<GetNoopVersionActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		else
		{
															#line 988 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (!static_cast<GetNoopVersionActor*>(this)->SAV<Version>::futures) { (void)(invalidVersion); this->~GetNoopVersionActorState(); static_cast<GetNoopVersionActor*>(this)->destroy(); return 0; }
															#line 8129 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			new (&static_cast<GetNoopVersionActor*>(this)->SAV< Version >::value()) Version(invalidVersion);
			this->~GetNoopVersionActorState();
			static_cast<GetNoopVersionActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> && noopValue,int loopDepth) 
	{
															#line 985 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (noopValue.present())
															#line 8142 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		{
															#line 986 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (!static_cast<GetNoopVersionActor*>(this)->SAV<Version>::futures) { (void)(BinaryReader::fromStringRef<Version>(noopValue.get(), Unversioned())); this->~GetNoopVersionActorState(); static_cast<GetNoopVersionActor*>(this)->destroy(); return 0; }
															#line 8146 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			new (&static_cast<GetNoopVersionActor*>(this)->SAV< Version >::value()) Version(BinaryReader::fromStringRef<Version>(noopValue.get(), Unversioned()));
			this->~GetNoopVersionActorState();
			static_cast<GetNoopVersionActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		else
		{
															#line 988 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (!static_cast<GetNoopVersionActor*>(this)->SAV<Version>::futures) { (void)(invalidVersion); this->~GetNoopVersionActorState(); static_cast<GetNoopVersionActor*>(this)->destroy(); return 0; }
															#line 8156 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			new (&static_cast<GetNoopVersionActor*>(this)->SAV< Version >::value()) Version(invalidVersion);
			this->~GetNoopVersionActorState();
			static_cast<GetNoopVersionActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& noopValue,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(noopValue, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && noopValue,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(noopValue), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetNoopVersionActor*>(this)->actor_wait_state > 0) static_cast<GetNoopVersionActor*>(this)->actor_wait_state = 0;
		static_cast<GetNoopVersionActor*>(this)->ActorCallback< GetNoopVersionActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< GetNoopVersionActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("getNoopVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetNoopVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNoopVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetNoopVersionActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("getNoopVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetNoopVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNoopVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetNoopVersionActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("getNoopVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetNoopVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNoopVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetNoopVersionActor*>(this)->actor_wait_state > 0) static_cast<GetNoopVersionActor*>(this)->actor_wait_state = 0;
		static_cast<GetNoopVersionActor*>(this)->ActorCallback< GetNoopVersionActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetNoopVersionActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getNoopVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetNoopVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNoopVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetNoopVersionActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getNoopVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetNoopVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNoopVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetNoopVersionActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getNoopVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetNoopVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNoopVersion", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 975 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	BackupData* self;
															#line 976 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	Transaction tr;
															#line 8331 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getNoopVersion()
															#line 975 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
class GetNoopVersionActor final : public Actor<Version>, public ActorCallback< GetNoopVersionActor, 0, Optional<Value> >, public ActorCallback< GetNoopVersionActor, 1, Void >, public FastAllocated<GetNoopVersionActor>, public GetNoopVersionActorState<GetNoopVersionActor> {
															#line 8336 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetNoopVersionActor>::operator new;
	using FastAllocated<GetNoopVersionActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3971728470544687616UL, 14302553201760644864UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Version>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetNoopVersionActor, 0, Optional<Value> >;
friend struct ActorCallback< GetNoopVersionActor, 1, Void >;
															#line 975 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	GetNoopVersionActor(BackupData* const& self) 
															#line 8354 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		 : Actor<Version>(),
		   GetNoopVersionActorState<GetNoopVersionActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getNoopVersion", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2594413157595683584UL, 18381032131462800128UL);
		ActorExecutionContextHelper __helper(static_cast<GetNoopVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getNoopVersion");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getNoopVersion", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetNoopVersionActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetNoopVersionActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 975 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
[[nodiscard]] static Future<Version> getNoopVersion( BackupData* const& self ) {
															#line 975 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	return Future<Version>(new GetNoopVersionActor(self));
															#line 8388 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
}

#line 995 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"

// Pulls data from TLog servers using LogRouter tag.
															#line 8394 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via pullAsyncData()
															#line 997 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
template <class PullAsyncDataActor>
															#line 997 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
class PullAsyncDataActorState {
															#line 8401 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
public:
															#line 997 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	PullAsyncDataActorState(BackupData* const& self) 
															#line 997 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
															#line 997 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		 : self(self),
															#line 998 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   logSystemChange(Void()),
															#line 999 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   r(),
															#line 1004 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   tagAt(std::max({ self->pulledVersion.get(), self->startVersion, self->savedVersion, self->popVersion, self->popTrigger.get() }))
															#line 8414 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("pullAsyncData", reinterpret_cast<unsigned long>(this));

	}
	~PullAsyncDataActorState() 
	{
		fdb_probe_actor_destroy("pullAsyncData", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1010 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			TraceEvent("BackupWorkerPull", self->myId) .detail("Tag", self->tag) .detail("Version", tagAt) .detail("PopVersion", self->popVersion) .detail("TriggerVersion", self->popTrigger.get()) .detail("StartVersion", self->startVersion) .detail("SavedVersion", self->savedVersion);
															#line 1017 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			;
															#line 8431 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PullAsyncDataActorState();
		static_cast<PullAsyncDataActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1018 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		;
															#line 8461 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 1022 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		;
															#line 8470 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
															#line 1018 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (!(self->paused.get()))
															#line 8486 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		{
			return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1019 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		StrictFuture<Void> __when_expr_0 = self->paused.onChange();
															#line 1019 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (static_cast<PullAsyncDataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 8494 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<PullAsyncDataActor*>(this)->actor_wait_state = 1;
															#line 1019 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PullAsyncDataActor, 0, Void >*>(static_cast<PullAsyncDataActor*>(this)));
															#line 8499 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PullAsyncDataActor*>(this)->actor_wait_state > 0) static_cast<PullAsyncDataActor*>(this)->actor_wait_state = 0;
		static_cast<PullAsyncDataActor*>(this)->ActorCallback< PullAsyncDataActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PullAsyncDataActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("pullAsyncData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PullAsyncDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pullAsyncData", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PullAsyncDataActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("pullAsyncData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PullAsyncDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pullAsyncData", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PullAsyncDataActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("pullAsyncData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PullAsyncDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pullAsyncData", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 1041 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (r->popped() > 0)
															#line 8608 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		{
															#line 1042 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			StrictFuture<Version> __when_expr_3 = getNoopVersion(self);
															#line 1042 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (static_cast<PullAsyncDataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8614 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2when1(__when_expr_3.get(), loopDepth); };
			static_cast<PullAsyncDataActor*>(this)->actor_wait_state = 3;
															#line 1042 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< PullAsyncDataActor, 3, Version >*>(static_cast<PullAsyncDataActor*>(this)));
															#line 8619 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1(int loopDepth) 
	{
															#line 1023 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		StrictFuture<Void> __when_expr_1 = r ? r->getMore(TaskPriority::TLogCommit) : Never();
															#line 1022 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (static_cast<PullAsyncDataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 8642 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
															#line 1029 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		StrictFuture<Void> __when_expr_2 = logSystemChange;
															#line 8646 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1when2(__when_expr_2.get(), loopDepth); };
		static_cast<PullAsyncDataActor*>(this)->actor_wait_state = 2;
															#line 1023 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PullAsyncDataActor, 1, Void >*>(static_cast<PullAsyncDataActor*>(this)));
															#line 1029 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< PullAsyncDataActor, 2, Void >*>(static_cast<PullAsyncDataActor*>(this)));
															#line 8653 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
															#line 1024 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		DisabledTraceEvent("BackupWorkerGotMore", self->myId) .detail("Tag", self->tag) .detail("CursorVersion", r->version().version);
															#line 8681 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when1(Void && _,int loopDepth) 
	{
															#line 1024 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		DisabledTraceEvent("BackupWorkerGotMore", self->myId) .detail("Tag", self->tag) .detail("CursorVersion", r->version().version);
															#line 8690 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when2(Void const& _,int loopDepth) 
	{
															#line 1030 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (self->logSystem.get())
															#line 8699 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		{
															#line 1031 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			r = self->logSystem.get()->peekLogRouter( self->myId, tagAt, self->tag, SERVER_KNOBS->LOG_ROUTER_PEEK_FROM_SATELLITES_PREFERRED);
															#line 8703 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		}
		else
		{
															#line 1034 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			r = Reference<ILogSystem::IPeekCursor>();
															#line 8709 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		}
															#line 1036 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		logSystemChange = self->logSystem.onChange();
															#line 8713 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when2(Void && _,int loopDepth) 
	{
															#line 1030 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (self->logSystem.get())
															#line 8722 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		{
															#line 1031 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			r = self->logSystem.get()->peekLogRouter( self->myId, tagAt, self->tag, SERVER_KNOBS->LOG_ROUTER_PEEK_FROM_SATELLITES_PREFERRED);
															#line 8726 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		}
		else
		{
															#line 1034 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			r = Reference<ILogSystem::IPeekCursor>();
															#line 8732 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		}
															#line 1036 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		logSystemChange = self->logSystem.onChange();
															#line 8736 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<PullAsyncDataActor*>(this)->actor_wait_state > 0) static_cast<PullAsyncDataActor*>(this)->actor_wait_state = 0;
		static_cast<PullAsyncDataActor*>(this)->ActorCallback< PullAsyncDataActor, 1, Void >::remove();
		static_cast<PullAsyncDataActor*>(this)->ActorCallback< PullAsyncDataActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PullAsyncDataActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("pullAsyncData", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PullAsyncDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pullAsyncData", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< PullAsyncDataActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("pullAsyncData", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PullAsyncDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pullAsyncData", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< PullAsyncDataActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("pullAsyncData", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PullAsyncDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pullAsyncData", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< PullAsyncDataActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("pullAsyncData", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PullAsyncDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pullAsyncData", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< PullAsyncDataActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("pullAsyncData", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PullAsyncDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pullAsyncData", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< PullAsyncDataActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("pullAsyncData", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PullAsyncDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pullAsyncData", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 1058 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		self->minKnownCommittedVersion = std::max(self->minKnownCommittedVersion, r->getMinKnownCommittedVersion());
															#line 1062 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		peekedBytes = 0;
															#line 1066 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		tmpMessages = std::vector<VersionedMessage>();
															#line 1067 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		for(;r->hasMessage();) {
															#line 1068 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			tmpMessages.emplace_back(r->version(), r->getMessage(), r->getTags(), r->arena());
															#line 1069 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			peekedBytes += tmpMessages.back().getEstimatedSize();
															#line 1070 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			r->nextMessage();
															#line 8878 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		}
															#line 1072 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (peekedBytes > 0)
															#line 8882 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		{
															#line 1073 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			TraceEvent(SevDebugMemory, "BackupWorkerMemory", self->myId) .detail("Take", peekedBytes) .detail("Current", self->lock->activePermits());
															#line 1076 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			StrictFuture<Void> __when_expr_4 = self->lock->take(TaskPriority::DefaultYield, peekedBytes);
															#line 1076 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (static_cast<PullAsyncDataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8890 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont3when1(__when_expr_4.get(), loopDepth); };
			static_cast<PullAsyncDataActor*>(this)->actor_wait_state = 4;
															#line 1076 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< PullAsyncDataActor, 4, Void >*>(static_cast<PullAsyncDataActor*>(this)));
															#line 8895 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont6(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont4(Version const& maxNoopVersion,int loopDepth) 
	{
															#line 1043 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		Severity sev = maxNoopVersion != invalidVersion && maxNoopVersion < r->popped() ? SevError : SevWarnAlways;
															#line 1044 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		TraceEvent(sev, "BackupWorkerPullMissingMutations", self->myId) .detail("Tag", self->tag) .detail("BackupEpoch", self->backupEpoch) .detail("Popped", r->popped()) .detail("NoopPoppedVersion", maxNoopVersion) .detail("ExpectedPeekVersion", tagAt);
															#line 1050 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		ASSERT(self->backupEpoch < self->recruitedEpoch && maxNoopVersion >= r->popped());
															#line 8913 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4(Version && maxNoopVersion,int loopDepth) 
	{
															#line 1043 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		Severity sev = maxNoopVersion != invalidVersion && maxNoopVersion < r->popped() ? SevError : SevWarnAlways;
															#line 1044 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		TraceEvent(sev, "BackupWorkerPullMissingMutations", self->myId) .detail("Tag", self->tag) .detail("BackupEpoch", self->backupEpoch) .detail("Popped", r->popped()) .detail("NoopPoppedVersion", maxNoopVersion) .detail("ExpectedPeekVersion", tagAt);
															#line 1050 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		ASSERT(self->backupEpoch < self->recruitedEpoch && maxNoopVersion >= r->popped());
															#line 8926 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Version const& maxNoopVersion,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(maxNoopVersion, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Version && maxNoopVersion,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(maxNoopVersion), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<PullAsyncDataActor*>(this)->actor_wait_state > 0) static_cast<PullAsyncDataActor*>(this)->actor_wait_state = 0;
		static_cast<PullAsyncDataActor*>(this)->ActorCallback< PullAsyncDataActor, 3, Version >::remove();

	}
	void a_callback_fire(ActorCallback< PullAsyncDataActor, 3, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("pullAsyncData", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PullAsyncDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pullAsyncData", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< PullAsyncDataActor, 3, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("pullAsyncData", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PullAsyncDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pullAsyncData", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< PullAsyncDataActor, 3, Version >*,Error err) 
	{
		fdb_probe_actor_enter("pullAsyncData", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PullAsyncDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pullAsyncData", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont6(int loopDepth) 
	{
															#line 1082 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		tagAt = r->version().version;
															#line 1083 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		self->pulledVersion.set(tagAt);
															#line 1084 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		TraceEvent("BackupWorkerGot", self->myId).suppressFor(1.0).detail("V", tagAt);
															#line 1085 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (self->pullFinished())
															#line 9016 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		{
															#line 1086 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			self->eraseMessagesAfterEndVersion();
															#line 1087 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			self->doneTrigger.trigger();
															#line 1088 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			TraceEvent("BackupWorkerFinishPull", self->myId) .detail("Tag", self->tag.toString()) .detail("VersionGot", tagAt) .detail("EndVersion", self->endVersion.get()) .detail("MsgQ", self->messages.size());
															#line 1093 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (!static_cast<PullAsyncDataActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PullAsyncDataActorState(); static_cast<PullAsyncDataActor*>(this)->destroy(); return 0; }
															#line 9026 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			new (&static_cast<PullAsyncDataActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~PullAsyncDataActorState();
			static_cast<PullAsyncDataActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1095 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		StrictFuture<Void> __when_expr_5 = yield();
															#line 1095 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (static_cast<PullAsyncDataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 9036 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont6when1(__when_expr_5.get(), loopDepth); };
		static_cast<PullAsyncDataActor*>(this)->actor_wait_state = 5;
															#line 1095 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< PullAsyncDataActor, 5, Void >*>(static_cast<PullAsyncDataActor*>(this)));
															#line 9041 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont8(Void const& _,int loopDepth) 
	{
															#line 1077 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		self->messages.insert(self->messages.end(), std::make_move_iterator(tmpMessages.begin()), std::make_move_iterator(tmpMessages.end()));
															#line 9050 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont8(Void && _,int loopDepth) 
	{
															#line 1077 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		self->messages.insert(self->messages.end(), std::make_move_iterator(tmpMessages.begin()), std::make_move_iterator(tmpMessages.end()));
															#line 9059 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<PullAsyncDataActor*>(this)->actor_wait_state > 0) static_cast<PullAsyncDataActor*>(this)->actor_wait_state = 0;
		static_cast<PullAsyncDataActor*>(this)->ActorCallback< PullAsyncDataActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PullAsyncDataActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("pullAsyncData", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PullAsyncDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pullAsyncData", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< PullAsyncDataActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("pullAsyncData", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PullAsyncDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pullAsyncData", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< PullAsyncDataActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("pullAsyncData", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PullAsyncDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pullAsyncData", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1loopBody1cont10(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont10(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<PullAsyncDataActor*>(this)->actor_wait_state > 0) static_cast<PullAsyncDataActor*>(this)->actor_wait_state = 0;
		static_cast<PullAsyncDataActor*>(this)->ActorCallback< PullAsyncDataActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PullAsyncDataActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("pullAsyncData", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PullAsyncDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pullAsyncData", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< PullAsyncDataActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("pullAsyncData", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PullAsyncDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pullAsyncData", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< PullAsyncDataActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("pullAsyncData", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PullAsyncDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pullAsyncData", reinterpret_cast<unsigned long>(this), 5);

	}
															#line 997 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	BackupData* self;
															#line 998 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	Future<Void> logSystemChange;
															#line 999 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	Reference<ILogSystem::IPeekCursor> r;
															#line 1004 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	Version tagAt;
															#line 1062 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	int64_t peekedBytes;
															#line 1066 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	std::vector<VersionedMessage> tmpMessages;
															#line 9238 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
};
// This generated class is to be used only via pullAsyncData()
															#line 997 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
class PullAsyncDataActor final : public Actor<Void>, public ActorCallback< PullAsyncDataActor, 0, Void >, public ActorCallback< PullAsyncDataActor, 1, Void >, public ActorCallback< PullAsyncDataActor, 2, Void >, public ActorCallback< PullAsyncDataActor, 3, Version >, public ActorCallback< PullAsyncDataActor, 4, Void >, public ActorCallback< PullAsyncDataActor, 5, Void >, public FastAllocated<PullAsyncDataActor>, public PullAsyncDataActorState<PullAsyncDataActor> {
															#line 9243 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
public:
	using FastAllocated<PullAsyncDataActor>::operator new;
	using FastAllocated<PullAsyncDataActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6013382029062650880UL, 11778247784132292864UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PullAsyncDataActor, 0, Void >;
friend struct ActorCallback< PullAsyncDataActor, 1, Void >;
friend struct ActorCallback< PullAsyncDataActor, 2, Void >;
friend struct ActorCallback< PullAsyncDataActor, 3, Version >;
friend struct ActorCallback< PullAsyncDataActor, 4, Void >;
friend struct ActorCallback< PullAsyncDataActor, 5, Void >;
															#line 997 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	PullAsyncDataActor(BackupData* const& self) 
															#line 9265 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   PullAsyncDataActorState<PullAsyncDataActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("pullAsyncData", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8097422354448463360UL, 16625194706777794048UL);
		ActorExecutionContextHelper __helper(static_cast<PullAsyncDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("pullAsyncData");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("pullAsyncData", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PullAsyncDataActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< PullAsyncDataActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< PullAsyncDataActor, 3, Version >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< PullAsyncDataActor, 4, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< PullAsyncDataActor, 5, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 997 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
[[nodiscard]] Future<Void> pullAsyncData( BackupData* const& self ) {
															#line 997 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	return Future<Void>(new PullAsyncDataActor(self));
															#line 9302 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
}

#line 1098 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"

															#line 9307 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via monitorBackupKeyOrPullData()
															#line 1099 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
template <class MonitorBackupKeyOrPullDataActor>
															#line 1099 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
class MonitorBackupKeyOrPullDataActorState {
															#line 9314 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
public:
															#line 1099 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	MonitorBackupKeyOrPullDataActorState(BackupData* const& self,bool const& keyPresent) 
															#line 1099 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
															#line 1099 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		 : self(self),
															#line 1099 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   keyPresent(keyPresent),
															#line 1100 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   pullFinished(Void())
															#line 9325 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("monitorBackupKeyOrPullData", reinterpret_cast<unsigned long>(this));

	}
	~MonitorBackupKeyOrPullDataActorState() 
	{
		fdb_probe_actor_destroy("monitorBackupKeyOrPullData", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1102 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			;
															#line 9340 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MonitorBackupKeyOrPullDataActorState();
		static_cast<MonitorBackupKeyOrPullDataActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1103 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		present = monitorBackupStartedKeyChanges(self, !keyPresent, true);
															#line 1104 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (keyPresent)
															#line 9372 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		{
															#line 1105 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			pullFinished = pullAsyncData(self);
															#line 1106 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			self->pulling = true;
															#line 1107 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			StrictFuture<Void> __when_expr_0 = success(present) || pullFinished;
															#line 1107 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (static_cast<MonitorBackupKeyOrPullDataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 9382 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<MonitorBackupKeyOrPullDataActor*>(this)->actor_wait_state = 1;
															#line 1107 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MonitorBackupKeyOrPullDataActor, 0, Void >*>(static_cast<MonitorBackupKeyOrPullDataActor*>(this)));
															#line 9387 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
															#line 1122 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			committedVersion = self->getMinKnownCommittedVersion();
															#line 1124 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			;
															#line 9396 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			loopDepth = a_body1loopBody1loopHead1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 1149 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		ASSERT(!keyPresent == present.get());
															#line 1150 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		keyPresent = !keyPresent;
															#line 9408 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 1108 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (pullFinished.isReady())
															#line 9417 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		{
															#line 1109 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			self->pulling = false;
															#line 1110 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (!static_cast<MonitorBackupKeyOrPullDataActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~MonitorBackupKeyOrPullDataActorState(); static_cast<MonitorBackupKeyOrPullDataActor*>(this)->destroy(); return 0; }
															#line 9423 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			new (&static_cast<MonitorBackupKeyOrPullDataActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~MonitorBackupKeyOrPullDataActorState();
			static_cast<MonitorBackupKeyOrPullDataActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1115 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		StrictFuture<Version> __when_expr_1 = self->getMinKnownCommittedVersion();
															#line 1115 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (static_cast<MonitorBackupKeyOrPullDataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 9433 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<MonitorBackupKeyOrPullDataActor*>(this)->actor_wait_state = 2;
															#line 1115 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MonitorBackupKeyOrPullDataActor, 1, Version >*>(static_cast<MonitorBackupKeyOrPullDataActor*>(this)));
															#line 9438 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 1108 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (pullFinished.isReady())
															#line 9447 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		{
															#line 1109 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			self->pulling = false;
															#line 1110 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (!static_cast<MonitorBackupKeyOrPullDataActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~MonitorBackupKeyOrPullDataActorState(); static_cast<MonitorBackupKeyOrPullDataActor*>(this)->destroy(); return 0; }
															#line 9453 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			new (&static_cast<MonitorBackupKeyOrPullDataActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~MonitorBackupKeyOrPullDataActorState();
			static_cast<MonitorBackupKeyOrPullDataActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1115 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		StrictFuture<Version> __when_expr_1 = self->getMinKnownCommittedVersion();
															#line 1115 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (static_cast<MonitorBackupKeyOrPullDataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 9463 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<MonitorBackupKeyOrPullDataActor*>(this)->actor_wait_state = 2;
															#line 1115 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MonitorBackupKeyOrPullDataActor, 1, Version >*>(static_cast<MonitorBackupKeyOrPullDataActor*>(this)));
															#line 9468 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MonitorBackupKeyOrPullDataActor*>(this)->actor_wait_state > 0) static_cast<MonitorBackupKeyOrPullDataActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorBackupKeyOrPullDataActor*>(this)->ActorCallback< MonitorBackupKeyOrPullDataActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorBackupKeyOrPullDataActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorBackupKeyOrPullData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBackupKeyOrPullDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBackupKeyOrPullData", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MonitorBackupKeyOrPullDataActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorBackupKeyOrPullData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBackupKeyOrPullDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBackupKeyOrPullData", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MonitorBackupKeyOrPullDataActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorBackupKeyOrPullData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBackupKeyOrPullDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBackupKeyOrPullData", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Version const& currentVersion,int loopDepth) 
	{
															#line 1116 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		StrictFuture<Void> __when_expr_2 = self->pulledVersion.whenAtLeast(currentVersion);
															#line 1116 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (static_cast<MonitorBackupKeyOrPullDataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 9554 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<MonitorBackupKeyOrPullDataActor*>(this)->actor_wait_state = 3;
															#line 1116 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MonitorBackupKeyOrPullDataActor, 2, Void >*>(static_cast<MonitorBackupKeyOrPullDataActor*>(this)));
															#line 9559 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Version && currentVersion,int loopDepth) 
	{
															#line 1116 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		StrictFuture<Void> __when_expr_2 = self->pulledVersion.whenAtLeast(currentVersion);
															#line 1116 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (static_cast<MonitorBackupKeyOrPullDataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 9570 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<MonitorBackupKeyOrPullDataActor*>(this)->actor_wait_state = 3;
															#line 1116 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MonitorBackupKeyOrPullDataActor, 2, Void >*>(static_cast<MonitorBackupKeyOrPullDataActor*>(this)));
															#line 9575 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Version const& currentVersion,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(currentVersion, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Version && currentVersion,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(currentVersion), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<MonitorBackupKeyOrPullDataActor*>(this)->actor_wait_state > 0) static_cast<MonitorBackupKeyOrPullDataActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorBackupKeyOrPullDataActor*>(this)->ActorCallback< MonitorBackupKeyOrPullDataActor, 1, Version >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorBackupKeyOrPullDataActor, 1, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("monitorBackupKeyOrPullData", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBackupKeyOrPullDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBackupKeyOrPullData", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MonitorBackupKeyOrPullDataActor, 1, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("monitorBackupKeyOrPullData", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBackupKeyOrPullDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBackupKeyOrPullData", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< MonitorBackupKeyOrPullDataActor, 1, Version >*,Error err) 
	{
		fdb_probe_actor_enter("monitorBackupKeyOrPullData", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBackupKeyOrPullDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBackupKeyOrPullData", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont5(Void const& _,int loopDepth) 
	{
															#line 1117 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		pullFinished = Future<Void>();
															#line 1118 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		self->pulling = false;
															#line 1119 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		TraceEvent("BackupWorkerPaused", self->myId).detail("Reason", "NoBackup");
															#line 9663 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void && _,int loopDepth) 
	{
															#line 1117 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		pullFinished = Future<Void>();
															#line 1118 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		self->pulling = false;
															#line 1119 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		TraceEvent("BackupWorkerPaused", self->myId).detail("Reason", "NoBackup");
															#line 9676 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<MonitorBackupKeyOrPullDataActor*>(this)->actor_wait_state > 0) static_cast<MonitorBackupKeyOrPullDataActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorBackupKeyOrPullDataActor*>(this)->ActorCallback< MonitorBackupKeyOrPullDataActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorBackupKeyOrPullDataActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorBackupKeyOrPullData", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBackupKeyOrPullDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBackupKeyOrPullData", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< MonitorBackupKeyOrPullDataActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorBackupKeyOrPullData", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBackupKeyOrPullDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBackupKeyOrPullData", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< MonitorBackupKeyOrPullDataActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorBackupKeyOrPullData", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBackupKeyOrPullDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBackupKeyOrPullData", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont7(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
															#line 1125 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		StrictFuture<Void> __when_expr_3 = success(present);
															#line 1124 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (static_cast<MonitorBackupKeyOrPullDataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 9775 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1when1(__when_expr_3.get(), loopDepth); };
															#line 1128 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		StrictFuture<Void> __when_expr_4 = success(committedVersion) || delay(SERVER_KNOBS->BACKUP_NOOP_POP_DELAY, self->cx->taskID);
															#line 9779 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1when2(__when_expr_4.get(), loopDepth); };
		static_cast<MonitorBackupKeyOrPullDataActor*>(this)->actor_wait_state = 4;
															#line 1125 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< MonitorBackupKeyOrPullDataActor, 3, Void >*>(static_cast<MonitorBackupKeyOrPullDataActor*>(this)));
															#line 1128 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< MonitorBackupKeyOrPullDataActor, 4, Void >*>(static_cast<MonitorBackupKeyOrPullDataActor*>(this)));
															#line 9786 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont7(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when2(Void const& _,int loopDepth) 
	{
															#line 1129 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (committedVersion.isReady())
															#line 9826 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		{
															#line 1130 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			Version newPopVersion = std::max({ self->popVersion, self->savedVersion, committedVersion.get() });
															#line 1132 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			self->minKnownCommittedVersion = std::max(committedVersion.get(), self->minKnownCommittedVersion);
															#line 1134 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (newPopVersion < self->popTrigger.get())
															#line 9834 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			{
															#line 1136 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
				DisabledTraceEvent("BackupWorkerSkipTrigger", self->myId) .detail("Version", newPopVersion) .detail("OldPop", self->popTrigger.get());
															#line 9838 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			}
			else
			{
															#line 1140 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
				self->popTrigger.set(newPopVersion);
															#line 9844 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			}
															#line 1142 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			committedVersion = Never();
															#line 9848 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		}
		else
		{
															#line 1144 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			committedVersion = self->getMinKnownCommittedVersion();
															#line 9854 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when2(Void && _,int loopDepth) 
	{
															#line 1129 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (committedVersion.isReady())
															#line 9864 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		{
															#line 1130 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			Version newPopVersion = std::max({ self->popVersion, self->savedVersion, committedVersion.get() });
															#line 1132 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			self->minKnownCommittedVersion = std::max(committedVersion.get(), self->minKnownCommittedVersion);
															#line 1134 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (newPopVersion < self->popTrigger.get())
															#line 9872 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			{
															#line 1136 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
				DisabledTraceEvent("BackupWorkerSkipTrigger", self->myId) .detail("Version", newPopVersion) .detail("OldPop", self->popTrigger.get());
															#line 9876 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			}
			else
			{
															#line 1140 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
				self->popTrigger.set(newPopVersion);
															#line 9882 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			}
															#line 1142 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			committedVersion = Never();
															#line 9886 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		}
		else
		{
															#line 1144 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			committedVersion = self->getMinKnownCommittedVersion();
															#line 9892 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<MonitorBackupKeyOrPullDataActor*>(this)->actor_wait_state > 0) static_cast<MonitorBackupKeyOrPullDataActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorBackupKeyOrPullDataActor*>(this)->ActorCallback< MonitorBackupKeyOrPullDataActor, 3, Void >::remove();
		static_cast<MonitorBackupKeyOrPullDataActor*>(this)->ActorCallback< MonitorBackupKeyOrPullDataActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorBackupKeyOrPullDataActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorBackupKeyOrPullData", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBackupKeyOrPullDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBackupKeyOrPullData", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< MonitorBackupKeyOrPullDataActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorBackupKeyOrPullData", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBackupKeyOrPullDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBackupKeyOrPullData", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< MonitorBackupKeyOrPullDataActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorBackupKeyOrPullData", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBackupKeyOrPullDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBackupKeyOrPullData", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< MonitorBackupKeyOrPullDataActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorBackupKeyOrPullData", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBackupKeyOrPullDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBackupKeyOrPullData", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< MonitorBackupKeyOrPullDataActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorBackupKeyOrPullData", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBackupKeyOrPullDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBackupKeyOrPullData", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< MonitorBackupKeyOrPullDataActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorBackupKeyOrPullData", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBackupKeyOrPullDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBackupKeyOrPullData", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 1099 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	BackupData* self;
															#line 1099 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	bool keyPresent;
															#line 1100 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	Future<Void> pullFinished;
															#line 1103 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	Future<bool> present;
															#line 1122 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	Future<Version> committedVersion;
															#line 10029 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
};
// This generated class is to be used only via monitorBackupKeyOrPullData()
															#line 1099 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
class MonitorBackupKeyOrPullDataActor final : public Actor<Void>, public ActorCallback< MonitorBackupKeyOrPullDataActor, 0, Void >, public ActorCallback< MonitorBackupKeyOrPullDataActor, 1, Version >, public ActorCallback< MonitorBackupKeyOrPullDataActor, 2, Void >, public ActorCallback< MonitorBackupKeyOrPullDataActor, 3, Void >, public ActorCallback< MonitorBackupKeyOrPullDataActor, 4, Void >, public FastAllocated<MonitorBackupKeyOrPullDataActor>, public MonitorBackupKeyOrPullDataActorState<MonitorBackupKeyOrPullDataActor> {
															#line 10034 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
public:
	using FastAllocated<MonitorBackupKeyOrPullDataActor>::operator new;
	using FastAllocated<MonitorBackupKeyOrPullDataActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9590547086193588992UL, 4714847058584118272UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MonitorBackupKeyOrPullDataActor, 0, Void >;
friend struct ActorCallback< MonitorBackupKeyOrPullDataActor, 1, Version >;
friend struct ActorCallback< MonitorBackupKeyOrPullDataActor, 2, Void >;
friend struct ActorCallback< MonitorBackupKeyOrPullDataActor, 3, Void >;
friend struct ActorCallback< MonitorBackupKeyOrPullDataActor, 4, Void >;
															#line 1099 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	MonitorBackupKeyOrPullDataActor(BackupData* const& self,bool const& keyPresent) 
															#line 10055 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   MonitorBackupKeyOrPullDataActorState<MonitorBackupKeyOrPullDataActor>(self, keyPresent),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("monitorBackupKeyOrPullData", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7886700117831388672UL, 1447957588129246976UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBackupKeyOrPullDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("monitorBackupKeyOrPullData");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("monitorBackupKeyOrPullData", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MonitorBackupKeyOrPullDataActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< MonitorBackupKeyOrPullDataActor, 1, Version >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< MonitorBackupKeyOrPullDataActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< MonitorBackupKeyOrPullDataActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1099 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
[[nodiscard]] Future<Void> monitorBackupKeyOrPullData( BackupData* const& self, bool const& keyPresent ) {
															#line 1099 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	return Future<Void>(new MonitorBackupKeyOrPullDataActor(self, keyPresent));
															#line 10091 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
}

#line 1153 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"

															#line 10096 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via checkRemoved()
															#line 1154 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
template <class CheckRemovedActor>
															#line 1154 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
class CheckRemovedActorState {
															#line 10103 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
public:
															#line 1154 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	CheckRemovedActorState(Reference<AsyncVar<ServerDBInfo> const> const& db,LogEpoch const& recoveryCount,BackupData* const& self) 
															#line 1154 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
															#line 1154 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		 : db(db),
															#line 1154 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   recoveryCount(recoveryCount),
															#line 1154 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   self(self)
															#line 10114 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("checkRemoved", reinterpret_cast<unsigned long>(this));

	}
	~CheckRemovedActorState() 
	{
		fdb_probe_actor_destroy("checkRemoved", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1155 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			;
															#line 10129 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckRemovedActorState();
		static_cast<CheckRemovedActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1156 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		bool isDisplaced = db->get().recoveryCount > recoveryCount && db->get().recoveryState != RecoveryState::UNINITIALIZED;
															#line 1158 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (isDisplaced)
															#line 10161 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		{
															#line 1159 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			TraceEvent("BackupWorkerDisplaced", self->myId) .detail("RecoveryCount", recoveryCount) .detail("SavedVersion", self->savedVersion) .detail("BackupWorkers", describe(db->get().logSystemConfig.tLogs)) .detail("DBRecoveryCount", db->get().recoveryCount) .detail("RecoveryState", (int)db->get().recoveryState);
															#line 1165 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			return a_body1Catch1(worker_removed(), std::max(0, loopDepth - 1));
															#line 10167 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		}
															#line 1167 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		StrictFuture<Void> __when_expr_0 = db->onChange();
															#line 1167 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (static_cast<CheckRemovedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 10173 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<CheckRemovedActor*>(this)->actor_wait_state = 1;
															#line 1167 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckRemovedActor, 0, Void >*>(static_cast<CheckRemovedActor*>(this)));
															#line 10178 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckRemovedActor*>(this)->actor_wait_state > 0) static_cast<CheckRemovedActor*>(this)->actor_wait_state = 0;
		static_cast<CheckRemovedActor*>(this)->ActorCallback< CheckRemovedActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckRemovedActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkRemoved", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckRemovedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkRemoved", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckRemovedActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkRemoved", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckRemovedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkRemoved", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckRemovedActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkRemoved", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckRemovedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkRemoved", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1154 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> db;
															#line 1154 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	LogEpoch recoveryCount;
															#line 1154 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	BackupData* self;
															#line 10276 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
};
// This generated class is to be used only via checkRemoved()
															#line 1154 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
class CheckRemovedActor final : public Actor<Void>, public ActorCallback< CheckRemovedActor, 0, Void >, public FastAllocated<CheckRemovedActor>, public CheckRemovedActorState<CheckRemovedActor> {
															#line 10281 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
public:
	using FastAllocated<CheckRemovedActor>::operator new;
	using FastAllocated<CheckRemovedActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13318404902492762624UL, 17645877588265039616UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckRemovedActor, 0, Void >;
															#line 1154 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	CheckRemovedActor(Reference<AsyncVar<ServerDBInfo> const> const& db,LogEpoch const& recoveryCount,BackupData* const& self) 
															#line 10298 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   CheckRemovedActorState<CheckRemovedActor>(db, recoveryCount, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkRemoved", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15518436168711072512UL, 6662910151609573120UL);
		ActorExecutionContextHelper __helper(static_cast<CheckRemovedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkRemoved");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkRemoved", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckRemovedActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1154 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
[[nodiscard]] Future<Void> checkRemoved( Reference<AsyncVar<ServerDBInfo> const> const& db, LogEpoch const& recoveryCount, BackupData* const& self ) {
															#line 1154 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	return Future<Void>(new CheckRemovedActor(db, recoveryCount, self));
															#line 10331 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
}

#line 1170 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"

															#line 10336 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via monitorWorkerPause()
															#line 1171 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
template <class MonitorWorkerPauseActor>
															#line 1171 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
class MonitorWorkerPauseActorState {
															#line 10343 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
public:
															#line 1171 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	MonitorWorkerPauseActorState(BackupData* const& self) 
															#line 1171 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
															#line 1171 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		 : self(self),
															#line 1172 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   tr(new ReadYourWritesTransaction(self->cx)),
															#line 1173 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   watch()
															#line 10354 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("monitorWorkerPause", reinterpret_cast<unsigned long>(this));

	}
	~MonitorWorkerPauseActorState() 
	{
		fdb_probe_actor_destroy("monitorWorkerPause", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1175 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			;
															#line 10369 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MonitorWorkerPauseActorState();
		static_cast<MonitorWorkerPauseActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 1177 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 1178 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 1179 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			tr->setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 1181 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr->get(backupPausedKey);
															#line 1181 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (static_cast<MonitorWorkerPauseActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10408 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<MonitorWorkerPauseActor*>(this)->actor_wait_state = 1;
															#line 1181 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MonitorWorkerPauseActor, 0, Optional<Value> >*>(static_cast<MonitorWorkerPauseActor*>(this)));
															#line 10413 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1193 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr->onError(e);
															#line 1193 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (static_cast<MonitorWorkerPauseActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 10437 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<MonitorWorkerPauseActor*>(this)->actor_wait_state = 4;
															#line 1193 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< MonitorWorkerPauseActor, 3, Void >*>(static_cast<MonitorWorkerPauseActor*>(this)));
															#line 10442 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> const& value,int loopDepth) 
	{
															#line 1182 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		bool paused = value.present() && value.get() == "1"_sr;
															#line 1183 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (self->paused.get() != paused)
															#line 10459 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		{
															#line 1184 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			TraceEvent(paused ? "BackupWorkerPaused" : "BackupWorkerResumed", self->myId).log();
															#line 1185 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			self->paused.set(paused);
															#line 10465 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		}
															#line 1188 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		watch = tr->watch(backupPausedKey);
															#line 1189 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr->commit();
															#line 1189 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (static_cast<MonitorWorkerPauseActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10473 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<MonitorWorkerPauseActor*>(this)->actor_wait_state = 2;
															#line 1189 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MonitorWorkerPauseActor, 1, Void >*>(static_cast<MonitorWorkerPauseActor*>(this)));
															#line 10478 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> && value,int loopDepth) 
	{
															#line 1182 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		bool paused = value.present() && value.get() == "1"_sr;
															#line 1183 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (self->paused.get() != paused)
															#line 10489 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		{
															#line 1184 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			TraceEvent(paused ? "BackupWorkerPaused" : "BackupWorkerResumed", self->myId).log();
															#line 1185 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			self->paused.set(paused);
															#line 10495 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		}
															#line 1188 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		watch = tr->watch(backupPausedKey);
															#line 1189 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr->commit();
															#line 1189 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (static_cast<MonitorWorkerPauseActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10503 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<MonitorWorkerPauseActor*>(this)->actor_wait_state = 2;
															#line 1189 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MonitorWorkerPauseActor, 1, Void >*>(static_cast<MonitorWorkerPauseActor*>(this)));
															#line 10508 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& value,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(value, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && value,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(value), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MonitorWorkerPauseActor*>(this)->actor_wait_state > 0) static_cast<MonitorWorkerPauseActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorWorkerPauseActor*>(this)->ActorCallback< MonitorWorkerPauseActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorWorkerPauseActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("monitorWorkerPause", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorWorkerPauseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorWorkerPause", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MonitorWorkerPauseActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("monitorWorkerPause", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorWorkerPauseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorWorkerPause", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MonitorWorkerPauseActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("monitorWorkerPause", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorWorkerPauseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorWorkerPause", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 1190 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		StrictFuture<Void> __when_expr_2 = watch;
															#line 1190 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (static_cast<MonitorWorkerPauseActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10594 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<MonitorWorkerPauseActor*>(this)->actor_wait_state = 3;
															#line 1190 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MonitorWorkerPauseActor, 2, Void >*>(static_cast<MonitorWorkerPauseActor*>(this)));
															#line 10599 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 1190 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		StrictFuture<Void> __when_expr_2 = watch;
															#line 1190 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (static_cast<MonitorWorkerPauseActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10610 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<MonitorWorkerPauseActor*>(this)->actor_wait_state = 3;
															#line 1190 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MonitorWorkerPauseActor, 2, Void >*>(static_cast<MonitorWorkerPauseActor*>(this)));
															#line 10615 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<MonitorWorkerPauseActor*>(this)->actor_wait_state > 0) static_cast<MonitorWorkerPauseActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorWorkerPauseActor*>(this)->ActorCallback< MonitorWorkerPauseActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorWorkerPauseActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorWorkerPause", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorWorkerPauseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorWorkerPause", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MonitorWorkerPauseActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorWorkerPause", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorWorkerPauseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorWorkerPause", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< MonitorWorkerPauseActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorWorkerPause", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorWorkerPauseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorWorkerPause", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont5(Void const& _,int loopDepth) 
	{
															#line 1191 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		tr->reset();
															#line 10699 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void && _,int loopDepth) 
	{
															#line 1191 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		tr->reset();
															#line 10708 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<MonitorWorkerPauseActor*>(this)->actor_wait_state > 0) static_cast<MonitorWorkerPauseActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorWorkerPauseActor*>(this)->ActorCallback< MonitorWorkerPauseActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorWorkerPauseActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorWorkerPause", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorWorkerPauseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorWorkerPause", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< MonitorWorkerPauseActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorWorkerPause", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorWorkerPauseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorWorkerPause", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< MonitorWorkerPauseActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorWorkerPause", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorWorkerPauseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorWorkerPause", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont7(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<MonitorWorkerPauseActor*>(this)->actor_wait_state > 0) static_cast<MonitorWorkerPauseActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorWorkerPauseActor*>(this)->ActorCallback< MonitorWorkerPauseActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorWorkerPauseActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorWorkerPause", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorWorkerPauseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorWorkerPause", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< MonitorWorkerPauseActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorWorkerPause", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorWorkerPauseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorWorkerPause", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< MonitorWorkerPauseActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorWorkerPause", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorWorkerPauseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorWorkerPause", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 1171 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	BackupData* self;
															#line 1172 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 1173 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	Future<Void> watch;
															#line 10894 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
};
// This generated class is to be used only via monitorWorkerPause()
															#line 1171 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
class MonitorWorkerPauseActor final : public Actor<Void>, public ActorCallback< MonitorWorkerPauseActor, 0, Optional<Value> >, public ActorCallback< MonitorWorkerPauseActor, 1, Void >, public ActorCallback< MonitorWorkerPauseActor, 2, Void >, public ActorCallback< MonitorWorkerPauseActor, 3, Void >, public FastAllocated<MonitorWorkerPauseActor>, public MonitorWorkerPauseActorState<MonitorWorkerPauseActor> {
															#line 10899 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
public:
	using FastAllocated<MonitorWorkerPauseActor>::operator new;
	using FastAllocated<MonitorWorkerPauseActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(18067826451985918208UL, 2988122285638394624UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MonitorWorkerPauseActor, 0, Optional<Value> >;
friend struct ActorCallback< MonitorWorkerPauseActor, 1, Void >;
friend struct ActorCallback< MonitorWorkerPauseActor, 2, Void >;
friend struct ActorCallback< MonitorWorkerPauseActor, 3, Void >;
															#line 1171 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	MonitorWorkerPauseActor(BackupData* const& self) 
															#line 10919 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   MonitorWorkerPauseActorState<MonitorWorkerPauseActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("monitorWorkerPause", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7188464638591516160UL, 18010931341658145792UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorWorkerPauseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("monitorWorkerPause");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("monitorWorkerPause", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MonitorWorkerPauseActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< MonitorWorkerPauseActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< MonitorWorkerPauseActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< MonitorWorkerPauseActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1171 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
[[nodiscard]] static Future<Void> monitorWorkerPause( BackupData* const& self ) {
															#line 1171 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	return Future<Void>(new MonitorWorkerPauseActor(self));
															#line 10955 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
}

#line 1197 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"

															#line 10960 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via backupWorker()
															#line 1198 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
template <class BackupWorkerActor>
															#line 1198 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
class BackupWorkerActorState {
															#line 10967 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
public:
															#line 1198 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	BackupWorkerActorState(BackupInterface const& interf,InitializeBackupRequest const& req,Reference<AsyncVar<ServerDBInfo> const> const& db) 
															#line 1198 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
															#line 1198 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		 : interf(interf),
															#line 1198 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   req(req),
															#line 1198 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   db(db),
															#line 1201 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   self(interf.id(), db, req),
															#line 1202 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   addActor(),
															#line 1203 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   error(actorCollection(addActor.getFuture())),
															#line 1204 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   dbInfoChange(Void()),
															#line 1205 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   pull(),
															#line 1206 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   done()
															#line 10990 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("backupWorker", reinterpret_cast<unsigned long>(this));

	}
	~BackupWorkerActorState() 
	{
		fdb_probe_actor_destroy("backupWorker", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1208 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			TraceEvent("BackupWorkerStart", self.myId) .detail("Tag", req.routerTag.toString()) .detail("TotalTags", req.totalTags) .detail("StartVersion", req.startVersion) .detail("EndVersion", req.endVersion.present() ? req.endVersion.get() : -1) .detail("LogEpoch", req.recruitedEpoch) .detail("BackupEpoch", req.backupEpoch);
															#line 11005 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			try {
															#line 1216 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
				addActor.send(checkRemoved(db, req.recruitedEpoch, &self));
															#line 1217 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
				addActor.send(waitFailureServer(interf.waitFailure.getFuture()));
															#line 1218 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
				if (req.recruitedEpoch == req.backupEpoch && req.routerTag.id == 0)
															#line 11013 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
				{
															#line 1219 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
					addActor.send(monitorBackupProgress(&self));
															#line 11017 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
				}
															#line 1221 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
				addActor.send(monitorWorkerPause(&self));
															#line 1226 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
				StrictFuture<bool> __when_expr_0 = monitorBackupStartedKeyChanges(&self, true, false);
															#line 1226 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
				if (static_cast<BackupWorkerActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 11025 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<BackupWorkerActor*>(this)->actor_wait_state = 1;
															#line 1226 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< BackupWorkerActor, 0, bool >*>(static_cast<BackupWorkerActor*>(this)));
															#line 11030 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~BackupWorkerActorState();
		static_cast<BackupWorkerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1273 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (!static_cast<BackupWorkerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~BackupWorkerActorState(); static_cast<BackupWorkerActor*>(this)->destroy(); return 0; }
															#line 11059 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		new (&static_cast<BackupWorkerActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~BackupWorkerActorState();
		static_cast<BackupWorkerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1258 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			err = e;
															#line 1259 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (e.code() == error_code_worker_removed)
															#line 11074 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			{
															#line 1260 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
				pull = Void();
															#line 1261 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
				self.stop();
															#line 11080 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
				try {
															#line 1263 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
					StrictFuture<Void> __when_expr_5 = done;
															#line 1263 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
					if (static_cast<BackupWorkerActor*>(this)->actor_wait_state < 0) return a_body1Catch2Catch1(actor_cancelled(), loopDepth);
															#line 11086 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
					if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch2Catch1(__when_expr_5.getError(), loopDepth); else return a_body1Catch2when1(__when_expr_5.get(), loopDepth); };
					static_cast<BackupWorkerActor*>(this)->actor_wait_state = 4;
															#line 1263 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
					__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< BackupWorkerActor, 5, Void >*>(static_cast<BackupWorkerActor*>(this)));
															#line 11091 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
					loopDepth = 0;
				}
				catch (Error& error) {
					loopDepth = a_body1Catch2Catch1(error, loopDepth);
				} catch (...) {
					loopDepth = a_body1Catch2Catch1(unknown_error(), loopDepth);
				}
			}
			else
			{
				loopDepth = a_body1Catch2cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(bool const& present,int loopDepth) 
	{
															#line 1227 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		TraceEvent("BackupWorkerWaitKey", self.myId).detail("Present", present).detail("ExitEarly", self.exitEarly);
															#line 1229 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		pull = self.exitEarly ? Void() : monitorBackupKeyOrPullData(&self, present);
															#line 1230 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		addActor.send(pull);
															#line 1231 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		done = self.exitEarly ? Void() : uploadData(&self);
															#line 1233 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		;
															#line 11125 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(bool && present,int loopDepth) 
	{
															#line 1227 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		TraceEvent("BackupWorkerWaitKey", self.myId).detail("Present", present).detail("ExitEarly", self.exitEarly);
															#line 1229 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		pull = self.exitEarly ? Void() : monitorBackupKeyOrPullData(&self, present);
															#line 1230 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		addActor.send(pull);
															#line 1231 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		done = self.exitEarly ? Void() : uploadData(&self);
															#line 1233 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		;
															#line 11142 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(bool const& present,int loopDepth) 
	{
		loopDepth = a_body1cont2(present, loopDepth);

		return loopDepth;
	}
	int a_body1when1(bool && present,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(present), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<BackupWorkerActor*>(this)->actor_wait_state > 0) static_cast<BackupWorkerActor*>(this)->actor_wait_state = 0;
		static_cast<BackupWorkerActor*>(this)->ActorCallback< BackupWorkerActor, 0, bool >::remove();

	}
	void a_callback_fire(ActorCallback< BackupWorkerActor, 0, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("backupWorker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BackupWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("backupWorker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< BackupWorkerActor, 0, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("backupWorker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BackupWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("backupWorker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< BackupWorkerActor, 0, bool >*,Error err) 
	{
		fdb_probe_actor_enter("backupWorker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BackupWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("backupWorker", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1(int loopDepth) 
	{
															#line 1234 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		StrictFuture<Void> __when_expr_1 = dbInfoChange;
															#line 1233 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (static_cast<BackupWorkerActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 11241 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when1(__when_expr_1.get(), loopDepth); };
															#line 1247 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		StrictFuture<Void> __when_expr_2 = done;
															#line 11245 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when2(__when_expr_2.get(), loopDepth); };
															#line 1255 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		StrictFuture<Void> __when_expr_3 = error;
															#line 11249 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch2(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when3(__when_expr_3.get(), loopDepth); };
		static_cast<BackupWorkerActor*>(this)->actor_wait_state = 2;
															#line 1234 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< BackupWorkerActor, 1, Void >*>(static_cast<BackupWorkerActor*>(this)));
															#line 1247 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< BackupWorkerActor, 2, Void >*>(static_cast<BackupWorkerActor*>(this)));
															#line 1255 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< BackupWorkerActor, 3, Void >*>(static_cast<BackupWorkerActor*>(this)));
															#line 11258 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2break1(int loopDepth) 
	{
		try {
			return a_body1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void const& _,int loopDepth) 
	{
															#line 1235 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		dbInfoChange = db->onChange();
															#line 1236 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		Reference<ILogSystem> ls = ILogSystem::fromServerDBInfo(self.myId, db->get(), true);
															#line 1237 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		bool hasPseudoLocality = ls.isValid() && ls->hasPseudoLocality(tagLocalityBackup);
															#line 1238 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (hasPseudoLocality)
															#line 11292 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		{
															#line 1239 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			self.logSystem.set(ls);
															#line 1240 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			self.oldestBackupEpoch = std::max(self.oldestBackupEpoch, ls->getOldestBackupEpoch());
															#line 11298 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		}
															#line 1242 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		TraceEvent("BackupWorkerLogSystem", self.myId) .detail("HasBackupLocality", hasPseudoLocality) .detail("OldestBackupEpoch", self.oldestBackupEpoch) .detail("Tag", self.tag.toString());
															#line 11302 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void && _,int loopDepth) 
	{
															#line 1235 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		dbInfoChange = db->onChange();
															#line 1236 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		Reference<ILogSystem> ls = ILogSystem::fromServerDBInfo(self.myId, db->get(), true);
															#line 1237 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		bool hasPseudoLocality = ls.isValid() && ls->hasPseudoLocality(tagLocalityBackup);
															#line 1238 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (hasPseudoLocality)
															#line 11317 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		{
															#line 1239 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			self.logSystem.set(ls);
															#line 1240 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			self.oldestBackupEpoch = std::max(self.oldestBackupEpoch, ls->getOldestBackupEpoch());
															#line 11323 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		}
															#line 1242 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		TraceEvent("BackupWorkerLogSystem", self.myId) .detail("HasBackupLocality", hasPseudoLocality) .detail("OldestBackupEpoch", self.oldestBackupEpoch) .detail("Tag", self.tag.toString());
															#line 11327 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when2(Void const& _,int loopDepth) 
	{
															#line 1248 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		TraceEvent("BackupWorkerDone", self.myId).detail("BackupEpoch", self.backupEpoch);
															#line 1251 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		StrictFuture<Void> __when_expr_4 = brokenPromiseToNever(db->get().clusterInterface.notifyBackupWorkerDone.getReply( BackupWorkerDoneRequest(self.myId, self.backupEpoch)));
															#line 1251 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (static_cast<BackupWorkerActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 11340 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch2(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when2when1(__when_expr_4.get(), loopDepth); };
		static_cast<BackupWorkerActor*>(this)->actor_wait_state = 3;
															#line 1251 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< BackupWorkerActor, 4, Void >*>(static_cast<BackupWorkerActor*>(this)));
															#line 11345 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2loopBody1when2(Void && _,int loopDepth) 
	{
															#line 1248 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		TraceEvent("BackupWorkerDone", self.myId).detail("BackupEpoch", self.backupEpoch);
															#line 1251 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		StrictFuture<Void> __when_expr_4 = brokenPromiseToNever(db->get().clusterInterface.notifyBackupWorkerDone.getReply( BackupWorkerDoneRequest(self.myId, self.backupEpoch)));
															#line 1251 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (static_cast<BackupWorkerActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 11358 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch2(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when2when1(__when_expr_4.get(), loopDepth); };
		static_cast<BackupWorkerActor*>(this)->actor_wait_state = 3;
															#line 1251 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< BackupWorkerActor, 4, Void >*>(static_cast<BackupWorkerActor*>(this)));
															#line 11363 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2loopBody1when3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<BackupWorkerActor*>(this)->actor_wait_state > 0) static_cast<BackupWorkerActor*>(this)->actor_wait_state = 0;
		static_cast<BackupWorkerActor*>(this)->ActorCallback< BackupWorkerActor, 1, Void >::remove();
		static_cast<BackupWorkerActor*>(this)->ActorCallback< BackupWorkerActor, 2, Void >::remove();
		static_cast<BackupWorkerActor*>(this)->ActorCallback< BackupWorkerActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BackupWorkerActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("backupWorker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BackupWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("backupWorker", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< BackupWorkerActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("backupWorker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BackupWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("backupWorker", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< BackupWorkerActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("backupWorker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BackupWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("backupWorker", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont2loopBody1when2cont1(Void const& _,int loopDepth) 
	{
		return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont2loopBody1when2cont1(Void && _,int loopDepth) 
	{
		return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont2loopBody1when2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1when2cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1when2cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<BackupWorkerActor*>(this)->actor_wait_state > 0) static_cast<BackupWorkerActor*>(this)->actor_wait_state = 0;
		static_cast<BackupWorkerActor*>(this)->ActorCallback< BackupWorkerActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BackupWorkerActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("backupWorker", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BackupWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("backupWorker", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< BackupWorkerActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("backupWorker", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BackupWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("backupWorker", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< BackupWorkerActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("backupWorker", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BackupWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("backupWorker", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< BackupWorkerActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("backupWorker", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BackupWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("backupWorker", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< BackupWorkerActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("backupWorker", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BackupWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("backupWorker", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< BackupWorkerActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("backupWorker", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BackupWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("backupWorker", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< BackupWorkerActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("backupWorker", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BackupWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("backupWorker", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< BackupWorkerActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("backupWorker", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BackupWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("backupWorker", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< BackupWorkerActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("backupWorker", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BackupWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("backupWorker", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch2cont1(int loopDepth) 
	{
															#line 1268 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		TraceEvent("BackupWorkerTerminated", self.myId).errorUnsuppressed(err);
															#line 1269 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (err.code() != error_code_actor_cancelled && err.code() != error_code_worker_removed)
															#line 11665 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		{
															#line 1270 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			return a_body1Catch1(err, loopDepth);
															#line 11669 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1Catch2cont2(int loopDepth) 
	{
		loopDepth = a_body1Catch2cont1(loopDepth);

		return loopDepth;
	}
	int a_body1Catch2Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1265 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
			TraceEvent("BackupWorkerShutdownError", self.myId).errorUnsuppressed(e);
															#line 11686 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
			loopDepth = a_body1Catch2cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch2cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1Catch2cont4(loopDepth);

		return loopDepth;
	}
	int a_body1Catch2cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1Catch2cont4(loopDepth);

		return loopDepth;
	}
	int a_body1Catch2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1Catch2cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1Catch2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1Catch2cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<BackupWorkerActor*>(this)->actor_wait_state > 0) static_cast<BackupWorkerActor*>(this)->actor_wait_state = 0;
		static_cast<BackupWorkerActor*>(this)->ActorCallback< BackupWorkerActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BackupWorkerActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("backupWorker", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BackupWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2Catch1(error, 0);
		} catch (...) {
			a_body1Catch2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("backupWorker", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< BackupWorkerActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("backupWorker", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BackupWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2Catch1(error, 0);
		} catch (...) {
			a_body1Catch2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("backupWorker", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< BackupWorkerActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("backupWorker", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BackupWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2Catch1(error, 0);
		} catch (...) {
			a_body1Catch2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("backupWorker", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1Catch2cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1Catch2cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 1198 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	BackupInterface interf;
															#line 1198 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	InitializeBackupRequest req;
															#line 1198 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> db;
															#line 1201 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	BackupData self;
															#line 1202 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	PromiseStream<Future<Void>> addActor;
															#line 1203 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	Future<Void> error;
															#line 1204 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	Future<Void> dbInfoChange;
															#line 1205 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	Future<Void> pull;
															#line 1206 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	Future<Void> done;
															#line 1258 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	Error err;
															#line 11817 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
};
// This generated class is to be used only via backupWorker()
															#line 1198 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
class BackupWorkerActor final : public Actor<Void>, public ActorCallback< BackupWorkerActor, 0, bool >, public ActorCallback< BackupWorkerActor, 1, Void >, public ActorCallback< BackupWorkerActor, 2, Void >, public ActorCallback< BackupWorkerActor, 4, Void >, public ActorCallback< BackupWorkerActor, 3, Void >, public ActorCallback< BackupWorkerActor, 5, Void >, public FastAllocated<BackupWorkerActor>, public BackupWorkerActorState<BackupWorkerActor> {
															#line 11822 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
public:
	using FastAllocated<BackupWorkerActor>::operator new;
	using FastAllocated<BackupWorkerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14155993423614479872UL, 6674467340902779648UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< BackupWorkerActor, 0, bool >;
friend struct ActorCallback< BackupWorkerActor, 1, Void >;
friend struct ActorCallback< BackupWorkerActor, 2, Void >;
friend struct ActorCallback< BackupWorkerActor, 4, Void >;
friend struct ActorCallback< BackupWorkerActor, 3, Void >;
friend struct ActorCallback< BackupWorkerActor, 5, Void >;
															#line 1198 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	BackupWorkerActor(BackupInterface const& interf,InitializeBackupRequest const& req,Reference<AsyncVar<ServerDBInfo> const> const& db) 
															#line 11844 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   BackupWorkerActorState<BackupWorkerActor>(interf, req, db),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("backupWorker", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1836670724661246976UL, 17551872501433186048UL);
		ActorExecutionContextHelper __helper(static_cast<BackupWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("backupWorker");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("backupWorker", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< BackupWorkerActor, 0, bool >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< BackupWorkerActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< BackupWorkerActor, 4, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< BackupWorkerActor, 5, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1198 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
[[nodiscard]] Future<Void> backupWorker( BackupInterface const& interf, InitializeBackupRequest const& req, Reference<AsyncVar<ServerDBInfo> const> const& db ) {
															#line 1198 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
	return Future<Void>(new BackupWorkerActor(interf, req, db));
															#line 11880 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbserver/BackupWorker.actor.g.cpp.py_gen"
}

#line 1275 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbserver/BackupWorker.actor.cpp"
