#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
/*
 * RESTUtils.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2026 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/RESTUtils.h"
#include "fdbclient/Knobs.h"

#include "flow/flat_buffers.h"
#include "flow/UnitTest.h"
#include "flow/IConnection.h"

#include <boost/algorithm/string.hpp>
#include <queue>

#include "flow/actorcompiler.h" // always the last include

// RESTConnectionPool destructor implementation
RESTConnectionPool::~RESTConnectionPool() {
	// In simulation, explicitly close all pooled connections before destruction.
	// This satisfies Sim2Conn's assertion: !opened || closedByCaller
	// Without this, connections would be destroyed without being closed, causing assertion failures.
	if (g_network && g_network->isSimulated()) {
		for (auto& kv : connectionPoolMap) {
			while (!kv.second.empty()) {
				ReusableConnection& rconn = kv.second.front();
				if (rconn.conn.isValid()) {
					rconn.conn->close();
				}
				kv.second.pop();
			}
		}
	}
}

const std::unordered_map<std::string, RESTConnectionType> RESTConnectionType::supportedConnTypes = {
	{ "http", RESTConnectionType("http", RESTConnectionType::NOT_SECURE_CONNECTION) },
	{ "https", RESTConnectionType("https", RESTConnectionType::SECURE_CONNECTION) }
};

RESTConnectionType RESTConnectionType::getConnectionType(const std::string& protocol) {
	auto itr = RESTConnectionType::supportedConnTypes.find(protocol);
	if (itr == RESTConnectionType::supportedConnTypes.end()) {
		TraceEvent("RESTConnectionTypeUnsupportedPrototocol").detail("Protocol", protocol);
		CODE_PROBE(true, "REST URI unsupported protocol");
		throw rest_unsupported_protocol();
	}
	return itr->second;
}

bool RESTConnectionType::isProtocolSupported(const std::string& protocol) {
	auto itr = RESTConnectionType::supportedConnTypes.find(protocol);
	return itr != RESTConnectionType::supportedConnTypes.end();
}

bool RESTConnectionType::isSecure(const std::string& protocol) {
	auto itr = RESTConnectionType::supportedConnTypes.find(protocol);
	if (itr == RESTConnectionType::supportedConnTypes.end()) {
		TraceEvent("RESTConnectionTypeUnsupportedPrototocol").detail("Protocol", protocol);
		throw rest_unsupported_protocol();
	}
	return itr->second.secure == RESTConnectionType::SECURE_CONNECTION;
}

RESTClientKnobs::RESTClientKnobs() {
	connection_pool_size = FLOW_KNOBS->RESTCLIENT_MAX_CONNECTIONPOOL_SIZE;
	connect_tries = FLOW_KNOBS->RESTCLIENT_CONNECT_TRIES;
	connect_timeout = FLOW_KNOBS->RESTCLIENT_CONNECT_TIMEOUT;
	max_connection_life = FLOW_KNOBS->RESTCLIENT_MAX_CONNECTION_LIFE;
	request_tries = FLOW_KNOBS->RESTCLIENT_REQUEST_TRIES;
	request_timeout_secs = FLOW_KNOBS->RESTCLIENT_REQUEST_TIMEOUT_SEC;

	knobMap["connection_pool_size"] = std::addressof(connection_pool_size);
	knobMap["pz"] = std::addressof(connection_pool_size);
	knobMap["connect_tries"] = std::addressof(connect_tries);
	knobMap["ct"] = std::addressof(connect_tries);
	knobMap["connect_timeout"] = std::addressof(connect_timeout);
	knobMap["cto"] = std::addressof(connect_timeout);
	knobMap["max_connection_life"] = std::addressof(max_connection_life);
	knobMap["mcl"] = std::addressof(max_connection_life);
	knobMap["request_tries"] = std::addressof(request_tries);
	knobMap["rt"] = std::addressof(request_tries);
	knobMap["request_timeout_secs"] = std::addressof(request_timeout_secs);
	knobMap["rtom"] = std::addressof(request_timeout_secs);
}

void RESTClientKnobs::set(const std::unordered_map<std::string, int>& knobSettings) {

	for (const auto& itr : knobSettings) {
		const auto& kItr = RESTClientKnobs::knobMap.find(itr.first);
		if (kItr == RESTClientKnobs::knobMap.end()) {
			TraceEvent("RESTClientInvalidKnobName").detail("KnobName", itr.first);
			throw rest_invalid_rest_client_knob();
		}
		ASSERT_EQ(itr.first.compare(kItr->first), 0);
		*(kItr->second) = itr.second;
	}
}

std::unordered_map<std::string, int> RESTClientKnobs::get() const {
	std::unordered_map<std::string, int> details = {
		{ "connection_pool_size", connection_pool_size },
		{ "connect_tries", connect_tries },
		{ "connect_timeout", connect_timeout },
		{ "max_connection_life", max_connection_life },
		{ "request_tries", request_tries },
		{ "request_timeout_secs", request_timeout_secs },
	};

	return details;
}

															#line 130 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/RESTUtils.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via connect_impl()
															#line 128 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
template <class Connect_implActor>
															#line 128 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
class Connect_implActorState {
															#line 137 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/RESTUtils.actor.g.cpp.py_gen"
public:
															#line 128 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
	Connect_implActorState(Reference<RESTConnectionPool> const& connectionPool,RESTConnectionPoolKey const& connectKey,bool const& isSecure,int const& maxConnLife) 
															#line 128 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
															#line 128 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
		 : connectionPool(connectionPool),
															#line 128 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
		   connectKey(connectKey),
															#line 128 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
		   isSecure(isSecure),
															#line 128 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
		   maxConnLife(maxConnLife)
															#line 150 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/RESTUtils.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("connect_impl", reinterpret_cast<unsigned long>(this));

	}
	~Connect_implActorState() 
	{
		fdb_probe_actor_destroy("connect_impl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 133 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
			if (FLOW_KNOBS->REST_LOG_LEVEL >= RESTLogSeverity::VERBOSE)
															#line 165 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/RESTUtils.actor.g.cpp.py_gen"
			{
															#line 134 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
				TraceEvent("RESTUtilConnectStart") .detail("Host", connectKey.first) .detail("Service", connectKey.second) .detail("IsSecure", isSecure) .detail("ConnectPoolNumKeys", connectionPool->connectionPoolMap.size());
															#line 169 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/RESTUtils.actor.g.cpp.py_gen"
			}
															#line 141 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
			auto poolItr = connectionPool->connectionPoolMap.find(connectKey);
															#line 142 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
			for(;poolItr != connectionPool->connectionPoolMap.end() && !poolItr->second.empty();) {
															#line 143 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
				RESTConnectionPool::ReusableConnection rconn = poolItr->second.front();
															#line 144 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
				poolItr->second.pop();
															#line 146 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
				if (rconn.expirationTime > now())
															#line 181 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/RESTUtils.actor.g.cpp.py_gen"
				{
															#line 147 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
					if (FLOW_KNOBS->REST_LOG_LEVEL >= RESTLogSeverity::DEBUG)
															#line 185 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/RESTUtils.actor.g.cpp.py_gen"
					{
															#line 148 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
						TraceEvent("RESTUtilReuseConn") .detail("Host", connectKey.first) .detail("Service", connectKey.second) .detail("RemoteEndpoint", rconn.conn->getPeerAddress()) .detail("ExpireIn", rconn.expirationTime - now()) .detail("NumConnsInPool", poolItr->second.size());
															#line 189 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/RESTUtils.actor.g.cpp.py_gen"
					}
															#line 155 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
					if (!static_cast<Connect_implActor*>(this)->SAV<RESTConnectionPool::ReusableConnection>::futures) { (void)(rconn); this->~Connect_implActorState(); static_cast<Connect_implActor*>(this)->destroy(); return 0; }
															#line 193 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/RESTUtils.actor.g.cpp.py_gen"
					new (&static_cast<Connect_implActor*>(this)->SAV< RESTConnectionPool::ReusableConnection >::value()) RESTConnectionPool::ReusableConnection(rconn);
					this->~Connect_implActorState();
					static_cast<Connect_implActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
			}
															#line 159 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
			ASSERT(poolItr == connectionPool->connectionPoolMap.end() || poolItr->second.empty());
															#line 162 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
			StrictFuture<Reference<IConnection>> __when_expr_0 = INetworkConnections::net()->connect(connectKey.first, connectKey.second, isSecure);
															#line 162 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
			if (static_cast<Connect_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 206 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/RESTUtils.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<Connect_implActor*>(this)->actor_wait_state = 1;
															#line 162 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< Connect_implActor, 0, Reference<IConnection> >*>(static_cast<Connect_implActor*>(this)));
															#line 211 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/RESTUtils.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~Connect_implActorState();
		static_cast<Connect_implActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 164 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
		StrictFuture<Void> __when_expr_1 = conn->connectHandshake();
															#line 164 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
		if (static_cast<Connect_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 236 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/RESTUtils.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<Connect_implActor*>(this)->actor_wait_state = 2;
															#line 164 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< Connect_implActor, 1, Void >*>(static_cast<Connect_implActor*>(this)));
															#line 241 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/RESTUtils.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Reference<IConnection> const& __conn,int loopDepth) 
	{
															#line 162 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
		conn = __conn;
															#line 250 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/RESTUtils.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Reference<IConnection> && __conn,int loopDepth) 
	{
		conn = std::move(__conn);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<Connect_implActor*>(this)->actor_wait_state > 0) static_cast<Connect_implActor*>(this)->actor_wait_state = 0;
		static_cast<Connect_implActor*>(this)->ActorCallback< Connect_implActor, 0, Reference<IConnection> >::remove();

	}
	void a_callback_fire(ActorCallback< Connect_implActor, 0, Reference<IConnection> >*,Reference<IConnection> const& value) 
	{
		fdb_probe_actor_enter("connect_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Connect_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("connect_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< Connect_implActor, 0, Reference<IConnection> >*,Reference<IConnection> && value) 
	{
		fdb_probe_actor_enter("connect_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Connect_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("connect_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< Connect_implActor, 0, Reference<IConnection> >*,Error err) 
	{
		fdb_probe_actor_enter("connect_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<Connect_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("connect_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 166 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
		TraceEvent("RESTTUilCreateNewConn") .suppressFor(60) .detail("Host", connectKey.first) .detail("Service", connectKey.second) .detail("RemoteEndpoint", conn->getPeerAddress()) .detail("ConnPoolSize", connectionPool->connectionPoolMap.size());
															#line 173 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
		if (!static_cast<Connect_implActor*>(this)->SAV<RESTConnectionPool::ReusableConnection>::futures) { (void)(RESTConnectionPool::ReusableConnection({ conn, now() + maxConnLife })); this->~Connect_implActorState(); static_cast<Connect_implActor*>(this)->destroy(); return 0; }
															#line 331 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/RESTUtils.actor.g.cpp.py_gen"
		new (&static_cast<Connect_implActor*>(this)->SAV< RESTConnectionPool::ReusableConnection >::value()) RESTConnectionPool::ReusableConnection(RESTConnectionPool::ReusableConnection({ conn, now() + maxConnLife }));
		this->~Connect_implActorState();
		static_cast<Connect_implActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 166 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
		TraceEvent("RESTTUilCreateNewConn") .suppressFor(60) .detail("Host", connectKey.first) .detail("Service", connectKey.second) .detail("RemoteEndpoint", conn->getPeerAddress()) .detail("ConnPoolSize", connectionPool->connectionPoolMap.size());
															#line 173 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
		if (!static_cast<Connect_implActor*>(this)->SAV<RESTConnectionPool::ReusableConnection>::futures) { (void)(RESTConnectionPool::ReusableConnection({ conn, now() + maxConnLife })); this->~Connect_implActorState(); static_cast<Connect_implActor*>(this)->destroy(); return 0; }
															#line 345 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/RESTUtils.actor.g.cpp.py_gen"
		new (&static_cast<Connect_implActor*>(this)->SAV< RESTConnectionPool::ReusableConnection >::value()) RESTConnectionPool::ReusableConnection(RESTConnectionPool::ReusableConnection({ conn, now() + maxConnLife }));
		this->~Connect_implActorState();
		static_cast<Connect_implActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<Connect_implActor*>(this)->actor_wait_state > 0) static_cast<Connect_implActor*>(this)->actor_wait_state = 0;
		static_cast<Connect_implActor*>(this)->ActorCallback< Connect_implActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< Connect_implActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("connect_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Connect_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("connect_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< Connect_implActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("connect_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Connect_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("connect_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< Connect_implActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("connect_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<Connect_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("connect_impl", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 128 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
	Reference<RESTConnectionPool> connectionPool;
															#line 128 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
	RESTConnectionPoolKey connectKey;
															#line 128 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
	bool isSecure;
															#line 128 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
	int maxConnLife;
															#line 162 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
	Reference<IConnection> conn;
															#line 438 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/RESTUtils.actor.g.cpp.py_gen"
};
// This generated class is to be used only via connect_impl()
															#line 128 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
class Connect_implActor final : public Actor<RESTConnectionPool::ReusableConnection>, public ActorCallback< Connect_implActor, 0, Reference<IConnection> >, public ActorCallback< Connect_implActor, 1, Void >, public FastAllocated<Connect_implActor>, public Connect_implActorState<Connect_implActor> {
															#line 443 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/RESTUtils.actor.g.cpp.py_gen"
public:
	using FastAllocated<Connect_implActor>::operator new;
	using FastAllocated<Connect_implActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14163841771509209856UL, 5162906786243249664UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<RESTConnectionPool::ReusableConnection>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< Connect_implActor, 0, Reference<IConnection> >;
friend struct ActorCallback< Connect_implActor, 1, Void >;
															#line 128 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
	Connect_implActor(Reference<RESTConnectionPool> const& connectionPool,RESTConnectionPoolKey const& connectKey,bool const& isSecure,int const& maxConnLife) 
															#line 461 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/RESTUtils.actor.g.cpp.py_gen"
		 : Actor<RESTConnectionPool::ReusableConnection>(),
		   Connect_implActorState<Connect_implActor>(connectionPool, connectKey, isSecure, maxConnLife),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("connect_impl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7092978256320716288UL, 13901349198287939840UL);
		ActorExecutionContextHelper __helper(static_cast<Connect_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("connect_impl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("connect_impl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< Connect_implActor, 0, Reference<IConnection> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< Connect_implActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 128 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
[[nodiscard]] Future<RESTConnectionPool::ReusableConnection> connect_impl( Reference<RESTConnectionPool> const& connectionPool, RESTConnectionPoolKey const& connectKey, bool const& isSecure, int const& maxConnLife ) {
															#line 128 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
	return Future<RESTConnectionPool::ReusableConnection>(new Connect_implActor(connectionPool, connectKey, isSecure, maxConnLife));
															#line 495 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/RESTUtils.actor.g.cpp.py_gen"
}

#line 175 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"

Future<RESTConnectionPool::ReusableConnection> RESTConnectionPool::connect(RESTConnectionPoolKey connectKey,
                                                                           const bool isSecure,
                                                                           const int maxConnLife) {
	return connect_impl(Reference<RESTConnectionPool>::addRef(this), connectKey, isSecure, maxConnLife);
}

void RESTConnectionPool::returnConnection(RESTConnectionPoolKey connectKey,
                                          ReusableConnection& rconn,
                                          const int maxConnections) {
	if (FLOW_KNOBS->REST_LOG_LEVEL >= RESTLogSeverity::VERBOSE) {
		TraceEvent("RESTUtilReturnConnStart")
		    .detail("Host", connectKey.first)
		    .detail("Service", connectKey.second)
		    .detail("ConnectPoolNumKeys", connectionPoolMap.size());
	}

	auto poolItr = connectionPoolMap.find(connectKey);
	// If it expires in the future then add it to the pool in the front iff connection pool size is not maxed
	if (rconn.expirationTime > now()) {
		bool returned = true;
		if (poolItr == connectionPoolMap.end()) {
			connectionPoolMap.insert({ connectKey, std::queue<RESTConnectionPool::ReusableConnection>({ rconn }) });
		} else if (poolItr->second.size() < maxConnections) {
			poolItr->second.push(rconn);
		} else {
			// Connection pool at its capacity; do nothing
			returned = false;
		}

		if (FLOW_KNOBS->REST_LOG_LEVEL >= RESTLogSeverity::DEBUG && returned) {
			poolItr = connectionPoolMap.find(connectKey);
			TraceEvent("RESTUtilReturnConnToPool")
			    .detail("Host", connectKey.first)
			    .detail("Service", connectKey.second)
			    .detail("ConnPoolSize", connectionPoolMap.size())
			    .detail("CachedConns", poolItr->second.size())
			    .detail("TimeToExpire", rconn.expirationTime - now());
		}
	}
	rconn.conn = Reference<IConnection>();
}

RESTUrl::RESTUrl(const std::string& fUrl) {
	parseUrl(fUrl);
}

RESTUrl::RESTUrl(const std::string& fullUrl, const std::string& b) : body(b) {
	parseUrl(fullUrl);
}

void RESTUrl::parseUrl(const std::string& fullUrl) {
	// Sample valid URIs
	// 1. With 'host' & 'resource' := '<protocol>://<host>/<resource>'
	// 2. With 'host', 'service' & 'resource' := '<protocol>://<host>:port/<resource>'
	// 3. With 'host', 'service', 'resource' & 'reqParameters' := '<protocol>://<host>:port/<resource>?<parameter-list>'

	if (FLOW_KNOBS->REST_LOG_LEVEL >= RESTLogSeverity::VERBOSE) {
		TraceEvent("RESTParseURI").detail("URI", fullUrl);
	}

	try {
		StringRef t(fullUrl);
		StringRef p = t.eat("://");
		std::string protocol = p.toString();
		boost::algorithm::to_lower(protocol);
		this->connType = RESTConnectionType::getConnectionType(protocol);

		// extract 'resource' and optional 'parameter list' if supplied in the URL
		uint8_t foundSeparator = 0;
		StringRef hostPort = t.eatAny("/?", &foundSeparator);
		this->resource = "/";
		if (foundSeparator == '/') {
			this->resource += t.eat("?").toString();
			this->reqParameters = t.eat().toString();
		}

		// hostPort is at least a host or IP address, optionally followed by :portNumber or :serviceName
		StringRef hRef(hostPort);
		StringRef h = hRef.eat(":");
		if (h.size() == 0) {
			CODE_PROBE(true, "REST URI empty host");
			throw std::string("host cannot be empty");
		}
		this->host = h.toString();
		this->service = hRef.eat().toString();

		if (FLOW_KNOBS->REST_LOG_LEVEL >= RESTLogSeverity::DEBUG) {
			TraceEvent("RESTUtilParseURI")
			    .detail("URI", fullUrl)
			    .detail("Host", this->host)
			    .detail("Service", this->service)
			    .detail("Resource", this->resource)
			    .detail("ReqParameters", this->reqParameters)
			    .detail("ConnectionType", this->connType.toString());
		}
	} catch (std::string& err) {
		TraceEvent(SevWarnAlways, "RESTUtilParseError").detail("URI", fullUrl).detail("Error", err);
		throw rest_invalid_uri();
	}
}

double continuousTimeDecay(double initialValue, double decayRate, double time) {
	return initialValue * exp(-decayRate * time);
}

// Only used to link unit tests
void forceLinkRESTUtilsTests() {}

															#line 608 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/RESTUtils.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via flowTestCase284()
															#line 284 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
template <class FlowTestCase284Actor>
															#line 284 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
class FlowTestCase284ActorState {
															#line 615 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/RESTUtils.actor.g.cpp.py_gen"
public:
															#line 284 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
	FlowTestCase284ActorState(UnitTestParameters const& params) 
															#line 284 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
															#line 284 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
		 : params(params)
															#line 622 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/RESTUtils.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("flowTestCase284", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase284ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase284", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 286 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
				std::string uri("httpx://foo/bar");
															#line 287 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
				RESTUrl r(uri);
															#line 288 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
				ASSERT(false);
															#line 642 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/RESTUtils.actor.g.cpp.py_gen"
				loopDepth = a_body1cont3(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase284ActorState();
		static_cast<FlowTestCase284Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 294 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
		if (!static_cast<FlowTestCase284Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase284ActorState(); static_cast<FlowTestCase284Actor*>(this)->destroy(); return 0; }
															#line 671 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/RESTUtils.actor.g.cpp.py_gen"
		new (&static_cast<FlowTestCase284Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase284ActorState();
		static_cast<FlowTestCase284Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 290 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
			if (e.code() != error_code_rest_unsupported_protocol)
															#line 684 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/RESTUtils.actor.g.cpp.py_gen"
			{
															#line 291 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 688 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/RESTUtils.actor.g.cpp.py_gen"
			}
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 284 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
	UnitTestParameters params;
															#line 715 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/RESTUtils.actor.g.cpp.py_gen"
};
// This generated class is to be used only via flowTestCase284()
															#line 284 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
class FlowTestCase284Actor final : public Actor<Void>, public FastAllocated<FlowTestCase284Actor>, public FlowTestCase284ActorState<FlowTestCase284Actor> {
															#line 720 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/RESTUtils.actor.g.cpp.py_gen"
public:
	using FastAllocated<FlowTestCase284Actor>::operator new;
	using FastAllocated<FlowTestCase284Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7481547541257373952UL, 14370797557544960000UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 284 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
	FlowTestCase284Actor(UnitTestParameters const& params) 
															#line 736 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/RESTUtils.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   FlowTestCase284ActorState<FlowTestCase284Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase284", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2641975664356649216UL, 6303879041471052032UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase284Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase284");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase284", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 284 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
static Future<Void> flowTestCase284( UnitTestParameters const& params ) {
															#line 284 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
	return Future<Void>(new FlowTestCase284Actor(params));
															#line 768 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/RESTUtils.actor.g.cpp.py_gen"
}
ACTOR_TEST_CASE(flowTestCase284, "/RESTUtils/InvalidProtocol")

#line 296 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"

															#line 774 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/RESTUtils.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via flowTestCase297()
															#line 297 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
template <class FlowTestCase297Actor>
															#line 297 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
class FlowTestCase297ActorState {
															#line 781 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/RESTUtils.actor.g.cpp.py_gen"
public:
															#line 297 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
	FlowTestCase297ActorState(UnitTestParameters const& params) 
															#line 297 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
															#line 297 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
		 : params(params)
															#line 788 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/RESTUtils.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("flowTestCase297", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase297ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase297", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 299 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
				std::string uri("https://:/bar");
															#line 300 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
				RESTUrl r(uri);
															#line 301 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
				ASSERT(false);
															#line 808 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/RESTUtils.actor.g.cpp.py_gen"
				loopDepth = a_body1cont3(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase297ActorState();
		static_cast<FlowTestCase297Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 307 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
		if (!static_cast<FlowTestCase297Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase297ActorState(); static_cast<FlowTestCase297Actor*>(this)->destroy(); return 0; }
															#line 837 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/RESTUtils.actor.g.cpp.py_gen"
		new (&static_cast<FlowTestCase297Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase297ActorState();
		static_cast<FlowTestCase297Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 303 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
			if (e.code() != error_code_rest_invalid_uri)
															#line 850 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/RESTUtils.actor.g.cpp.py_gen"
			{
															#line 304 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 854 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/RESTUtils.actor.g.cpp.py_gen"
			}
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 297 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
	UnitTestParameters params;
															#line 881 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/RESTUtils.actor.g.cpp.py_gen"
};
// This generated class is to be used only via flowTestCase297()
															#line 297 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
class FlowTestCase297Actor final : public Actor<Void>, public FastAllocated<FlowTestCase297Actor>, public FlowTestCase297ActorState<FlowTestCase297Actor> {
															#line 886 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/RESTUtils.actor.g.cpp.py_gen"
public:
	using FastAllocated<FlowTestCase297Actor>::operator new;
	using FastAllocated<FlowTestCase297Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14562181401481403392UL, 7185463271110917632UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 297 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
	FlowTestCase297Actor(UnitTestParameters const& params) 
															#line 902 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/RESTUtils.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   FlowTestCase297ActorState<FlowTestCase297Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase297", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(606424212171168512UL, 684362954269675776UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase297Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase297");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase297", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 297 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
static Future<Void> flowTestCase297( UnitTestParameters const& params ) {
															#line 297 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
	return Future<Void>(new FlowTestCase297Actor(params));
															#line 934 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/RESTUtils.actor.g.cpp.py_gen"
}
ACTOR_TEST_CASE(flowTestCase297, "/RESTUtils/MissingHost")

#line 309 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"

															#line 940 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/RESTUtils.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via flowTestCase310()
															#line 310 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
template <class FlowTestCase310Actor>
															#line 310 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
class FlowTestCase310ActorState {
															#line 947 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/RESTUtils.actor.g.cpp.py_gen"
public:
															#line 310 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
	FlowTestCase310ActorState(UnitTestParameters const& params) 
															#line 310 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
															#line 310 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
		 : params(params)
															#line 954 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/RESTUtils.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("flowTestCase310", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase310ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase310", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 311 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
			std::string uri("https://host:80/foo/bar");
															#line 312 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
			RESTUrl r(uri);
															#line 313 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
			ASSERT_EQ(r.connType.secure, RESTConnectionType::SECURE_CONNECTION);
															#line 314 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
			ASSERT_EQ(r.host.compare("host"), 0);
															#line 315 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
			ASSERT_EQ(r.service.compare("80"), 0);
															#line 316 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
			ASSERT_EQ(r.resource.compare("/foo/bar"), 0);
															#line 317 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
			if (!static_cast<FlowTestCase310Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase310ActorState(); static_cast<FlowTestCase310Actor*>(this)->destroy(); return 0; }
															#line 981 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/RESTUtils.actor.g.cpp.py_gen"
			new (&static_cast<FlowTestCase310Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase310ActorState();
			static_cast<FlowTestCase310Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase310ActorState();
		static_cast<FlowTestCase310Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 310 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
	UnitTestParameters params;
															#line 1005 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/RESTUtils.actor.g.cpp.py_gen"
};
// This generated class is to be used only via flowTestCase310()
															#line 310 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
class FlowTestCase310Actor final : public Actor<Void>, public FastAllocated<FlowTestCase310Actor>, public FlowTestCase310ActorState<FlowTestCase310Actor> {
															#line 1010 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/RESTUtils.actor.g.cpp.py_gen"
public:
	using FastAllocated<FlowTestCase310Actor>::operator new;
	using FastAllocated<FlowTestCase310Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9805700679310382592UL, 18171267358128774912UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 310 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
	FlowTestCase310Actor(UnitTestParameters const& params) 
															#line 1026 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/RESTUtils.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   FlowTestCase310ActorState<FlowTestCase310Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase310", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7067232702339686144UL, 16456496449529723904UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase310Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase310");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase310", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 310 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
static Future<Void> flowTestCase310( UnitTestParameters const& params ) {
															#line 310 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
	return Future<Void>(new FlowTestCase310Actor(params));
															#line 1058 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/RESTUtils.actor.g.cpp.py_gen"
}
ACTOR_TEST_CASE(flowTestCase310, "/RESTUtils/ValidURIWithService")

#line 319 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"

															#line 1064 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/RESTUtils.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via flowTestCase320()
															#line 320 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
template <class FlowTestCase320Actor>
															#line 320 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
class FlowTestCase320ActorState {
															#line 1071 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/RESTUtils.actor.g.cpp.py_gen"
public:
															#line 320 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
	FlowTestCase320ActorState(UnitTestParameters const& params) 
															#line 320 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
															#line 320 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
		 : params(params)
															#line 1078 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/RESTUtils.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("flowTestCase320", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase320ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase320", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 321 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
			std::string uri("https://host/foo/bar");
															#line 322 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
			RESTUrl r(uri);
															#line 323 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
			ASSERT_EQ(r.connType.secure, RESTConnectionType::SECURE_CONNECTION);
															#line 324 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
			ASSERT_EQ(r.host.compare("host"), 0);
															#line 325 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
			ASSERT(r.service.empty());
															#line 326 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
			ASSERT_EQ(r.resource.compare("/foo/bar"), 0);
															#line 327 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
			if (!static_cast<FlowTestCase320Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase320ActorState(); static_cast<FlowTestCase320Actor*>(this)->destroy(); return 0; }
															#line 1105 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/RESTUtils.actor.g.cpp.py_gen"
			new (&static_cast<FlowTestCase320Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase320ActorState();
			static_cast<FlowTestCase320Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase320ActorState();
		static_cast<FlowTestCase320Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 320 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
	UnitTestParameters params;
															#line 1129 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/RESTUtils.actor.g.cpp.py_gen"
};
// This generated class is to be used only via flowTestCase320()
															#line 320 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
class FlowTestCase320Actor final : public Actor<Void>, public FastAllocated<FlowTestCase320Actor>, public FlowTestCase320ActorState<FlowTestCase320Actor> {
															#line 1134 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/RESTUtils.actor.g.cpp.py_gen"
public:
	using FastAllocated<FlowTestCase320Actor>::operator new;
	using FastAllocated<FlowTestCase320Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1562235714928036096UL, 11562821630056268544UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 320 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
	FlowTestCase320Actor(UnitTestParameters const& params) 
															#line 1150 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/RESTUtils.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   FlowTestCase320ActorState<FlowTestCase320Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase320", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8128052982833405440UL, 1736792504670414848UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase320Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase320");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase320", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 320 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
static Future<Void> flowTestCase320( UnitTestParameters const& params ) {
															#line 320 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
	return Future<Void>(new FlowTestCase320Actor(params));
															#line 1182 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/RESTUtils.actor.g.cpp.py_gen"
}
ACTOR_TEST_CASE(flowTestCase320, "/RESTUtils/ValidURIWithoutService")

#line 329 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"

															#line 1188 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/RESTUtils.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via flowTestCase330()
															#line 330 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
template <class FlowTestCase330Actor>
															#line 330 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
class FlowTestCase330ActorState {
															#line 1195 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/RESTUtils.actor.g.cpp.py_gen"
public:
															#line 330 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
	FlowTestCase330ActorState(UnitTestParameters const& params) 
															#line 330 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
															#line 330 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
		 : params(params)
															#line 1202 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/RESTUtils.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("flowTestCase330", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase330ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase330", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 331 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
			std::string uri("https://host//foo/bar");
															#line 332 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
			RESTUrl r(uri);
															#line 333 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
			ASSERT_EQ(r.connType.secure, RESTConnectionType::SECURE_CONNECTION);
															#line 334 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
			ASSERT_EQ(r.host.compare("host"), 0);
															#line 335 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
			ASSERT(r.service.empty());
															#line 336 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
			ASSERT_EQ(r.resource.compare("//foo/bar"), 0);
															#line 337 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
			if (!static_cast<FlowTestCase330Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase330ActorState(); static_cast<FlowTestCase330Actor*>(this)->destroy(); return 0; }
															#line 1229 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/RESTUtils.actor.g.cpp.py_gen"
			new (&static_cast<FlowTestCase330Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase330ActorState();
			static_cast<FlowTestCase330Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase330ActorState();
		static_cast<FlowTestCase330Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 330 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
	UnitTestParameters params;
															#line 1253 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/RESTUtils.actor.g.cpp.py_gen"
};
// This generated class is to be used only via flowTestCase330()
															#line 330 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
class FlowTestCase330Actor final : public Actor<Void>, public FastAllocated<FlowTestCase330Actor>, public FlowTestCase330ActorState<FlowTestCase330Actor> {
															#line 1258 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/RESTUtils.actor.g.cpp.py_gen"
public:
	using FastAllocated<FlowTestCase330Actor>::operator new;
	using FastAllocated<FlowTestCase330Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10486794993495225344UL, 369908993001033216UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 330 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
	FlowTestCase330Actor(UnitTestParameters const& params) 
															#line 1274 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/RESTUtils.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   FlowTestCase330ActorState<FlowTestCase330Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase330", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2579220317091724032UL, 11664629995225944064UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase330Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase330");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase330", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 330 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
static Future<Void> flowTestCase330( UnitTestParameters const& params ) {
															#line 330 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
	return Future<Void>(new FlowTestCase330Actor(params));
															#line 1306 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/RESTUtils.actor.g.cpp.py_gen"
}
ACTOR_TEST_CASE(flowTestCase330, "/RESTUtils/ValidURIWithExtraForwardSlash")

#line 339 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"

															#line 1312 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/RESTUtils.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via flowTestCase340()
															#line 340 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
template <class FlowTestCase340Actor>
															#line 340 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
class FlowTestCase340ActorState {
															#line 1319 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/RESTUtils.actor.g.cpp.py_gen"
public:
															#line 340 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
	FlowTestCase340ActorState(UnitTestParameters const& params) 
															#line 340 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
															#line 340 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
		 : params(params)
															#line 1326 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/RESTUtils.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("flowTestCase340", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase340ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase340", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 341 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
			std::string uri("https://host/foo/bar?param1,param2");
															#line 342 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
			RESTUrl r(uri);
															#line 343 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
			ASSERT_EQ(r.connType.secure, RESTConnectionType::SECURE_CONNECTION);
															#line 344 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
			ASSERT_EQ(r.host.compare("host"), 0);
															#line 345 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
			ASSERT(r.service.empty());
															#line 346 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
			ASSERT_EQ(r.resource.compare("/foo/bar"), 0);
															#line 347 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
			ASSERT_EQ(r.reqParameters.compare("param1,param2"), 0);
															#line 348 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
			if (!static_cast<FlowTestCase340Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase340ActorState(); static_cast<FlowTestCase340Actor*>(this)->destroy(); return 0; }
															#line 1355 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/RESTUtils.actor.g.cpp.py_gen"
			new (&static_cast<FlowTestCase340Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase340ActorState();
			static_cast<FlowTestCase340Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase340ActorState();
		static_cast<FlowTestCase340Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 340 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
	UnitTestParameters params;
															#line 1379 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/RESTUtils.actor.g.cpp.py_gen"
};
// This generated class is to be used only via flowTestCase340()
															#line 340 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
class FlowTestCase340Actor final : public Actor<Void>, public FastAllocated<FlowTestCase340Actor>, public FlowTestCase340ActorState<FlowTestCase340Actor> {
															#line 1384 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/RESTUtils.actor.g.cpp.py_gen"
public:
	using FastAllocated<FlowTestCase340Actor>::operator new;
	using FastAllocated<FlowTestCase340Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2658571203751898368UL, 957673615619635968UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 340 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
	FlowTestCase340Actor(UnitTestParameters const& params) 
															#line 1400 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/RESTUtils.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   FlowTestCase340ActorState<FlowTestCase340Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase340", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2916637392911660800UL, 9276626632474724864UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase340Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase340");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase340", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 340 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
static Future<Void> flowTestCase340( UnitTestParameters const& params ) {
															#line 340 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
	return Future<Void>(new FlowTestCase340Actor(params));
															#line 1432 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/RESTUtils.actor.g.cpp.py_gen"
}
ACTOR_TEST_CASE(flowTestCase340, "/RESTUtils/ValidURIWithParamsSecure")

#line 350 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/RESTUtils.actor.cpp"
