#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
/*
 * FileBackupAgent.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2026 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/CommitProxyInterface.h"
#include "fdbclient/DatabaseConfiguration.h"
#include "fdbrpc/simulator.h"
#include "flow/EncryptUtils.h"
#include "flow/FastRef.h"
#include "flow/flow.h"
#include "fmt/format.h"
#include "fdbclient/BackupAgent.actor.h"
#include "fdbclient/BackupContainer.h"
#include "fdbclient/BackupContainerFileSystem.h"
#include "fdbclient/BulkDumping.h"
#include "fdbclient/BulkLoading.h"
#include "fdbclient/ClientBooleanParams.h"
#include "fdbclient/DatabaseContext.h"
#include "fdbclient/FDBTypes.h"
#include "fdbclient/JsonBuilder.h"
#include "fdbclient/JSONDoc.h"
#include "fdbclient/KeyBackedTypes.actor.h"
#include "fdbclient/KeyRangeMap.h"
#include "fdbclient/Knobs.h"
#include "fdbclient/ManagementAPI.actor.h"
#include "fdbclient/PartitionedLogIterator.h"
#include "fdbclient/RestoreInterface.h"
#include "fdbclient/Status.h"
#include "fdbclient/SystemData.h"
#include "fdbclient/TaskBucket.h"
#include "flow/network.h"
#include "flow/Trace.h"

#include <cinttypes>
#include <cstdint>
#include <ctime>
#include <climits>
#include "flow/IAsyncFile.h"
#include "flow/genericactors.actor.h"
#include "flow/Hash3.h"
#include "flow/xxhash.h"

#include <memory>
#include <numeric>
#include <boost/algorithm/string/split.hpp>
#include <boost/algorithm/string/classification.hpp>
#include <algorithm>
#include <unordered_map>
#include <utility>

#include "flow/actorcompiler.h" // This must be the last #include.

// Counters to verify BulkDump/BulkLoad were actually used (for test assertions)
std::atomic<int> g_bulkDumpTaskCompleteCount(0);
std::atomic<int> g_bulkLoadRestoreTaskCompleteCount(0);

// Helper function to monitor BulkDump job completion
// Returns true if job completed successfully, false if timed out
															#line 77 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via monitorBulkDumpJobCompletion()
															#line 75 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class MonitorBulkDumpJobCompletionActor>
															#line 75 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class MonitorBulkDumpJobCompletionActorState {
															#line 84 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 75 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	MonitorBulkDumpJobCompletionActorState(Database const& cx,UID const& jobId,double const& timeoutDuration,double const& pollInterval) 
															#line 75 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 75 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : cx(cx),
															#line 75 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   jobId(jobId),
															#line 75 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   timeoutDuration(timeoutDuration),
															#line 75 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   pollInterval(pollInterval),
															#line 76 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   timeoutStart(now()),
															#line 77 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   tr(cx)
															#line 101 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("monitorBulkDumpJobCompletion", reinterpret_cast<unsigned long>(this));

	}
	~MonitorBulkDumpJobCompletionActorState() 
	{
		fdb_probe_actor_destroy("monitorBulkDumpJobCompletion", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 79 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			;
															#line 116 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MonitorBulkDumpJobCompletionActorState();
		static_cast<MonitorBulkDumpJobCompletionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 81 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Optional<BulkDumpState>> __when_expr_0 = getSubmittedBulkDumpJob(&tr);
															#line 81 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<MonitorBulkDumpJobCompletionActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 149 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<MonitorBulkDumpJobCompletionActor*>(this)->actor_wait_state = 1;
															#line 81 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MonitorBulkDumpJobCompletionActor, 0, Optional<BulkDumpState> >*>(static_cast<MonitorBulkDumpJobCompletionActor*>(this)));
															#line 154 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 95 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 95 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<MonitorBulkDumpJobCompletionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 178 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<MonitorBulkDumpJobCompletionActor*>(this)->actor_wait_state = 3;
															#line 95 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MonitorBulkDumpJobCompletionActor, 2, Void >*>(static_cast<MonitorBulkDumpJobCompletionActor*>(this)));
															#line 183 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<BulkDumpState> const& currentJob,int loopDepth) 
	{
															#line 82 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		bool stillRunning = currentJob.present() && currentJob.get().getJobId() == jobId;
															#line 84 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!stillRunning)
															#line 200 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 85 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!static_cast<MonitorBulkDumpJobCompletionActor*>(this)->SAV<bool>::futures) { (void)(true); this->~MonitorBulkDumpJobCompletionActorState(); static_cast<MonitorBulkDumpJobCompletionActor*>(this)->destroy(); return 0; }
															#line 204 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			new (&static_cast<MonitorBulkDumpJobCompletionActor*>(this)->SAV< bool >::value()) bool(true);
			this->~MonitorBulkDumpJobCompletionActorState();
			static_cast<MonitorBulkDumpJobCompletionActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 88 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (now() - timeoutStart > timeoutDuration)
															#line 212 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 89 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!static_cast<MonitorBulkDumpJobCompletionActor*>(this)->SAV<bool>::futures) { (void)(false); this->~MonitorBulkDumpJobCompletionActorState(); static_cast<MonitorBulkDumpJobCompletionActor*>(this)->destroy(); return 0; }
															#line 216 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			new (&static_cast<MonitorBulkDumpJobCompletionActor*>(this)->SAV< bool >::value()) bool(false);
			this->~MonitorBulkDumpJobCompletionActorState();
			static_cast<MonitorBulkDumpJobCompletionActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 92 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(pollInterval);
															#line 92 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<MonitorBulkDumpJobCompletionActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 226 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<MonitorBulkDumpJobCompletionActor*>(this)->actor_wait_state = 2;
															#line 92 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MonitorBulkDumpJobCompletionActor, 1, Void >*>(static_cast<MonitorBulkDumpJobCompletionActor*>(this)));
															#line 231 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<BulkDumpState> && currentJob,int loopDepth) 
	{
															#line 82 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		bool stillRunning = currentJob.present() && currentJob.get().getJobId() == jobId;
															#line 84 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!stillRunning)
															#line 242 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 85 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!static_cast<MonitorBulkDumpJobCompletionActor*>(this)->SAV<bool>::futures) { (void)(true); this->~MonitorBulkDumpJobCompletionActorState(); static_cast<MonitorBulkDumpJobCompletionActor*>(this)->destroy(); return 0; }
															#line 246 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			new (&static_cast<MonitorBulkDumpJobCompletionActor*>(this)->SAV< bool >::value()) bool(true);
			this->~MonitorBulkDumpJobCompletionActorState();
			static_cast<MonitorBulkDumpJobCompletionActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 88 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (now() - timeoutStart > timeoutDuration)
															#line 254 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 89 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!static_cast<MonitorBulkDumpJobCompletionActor*>(this)->SAV<bool>::futures) { (void)(false); this->~MonitorBulkDumpJobCompletionActorState(); static_cast<MonitorBulkDumpJobCompletionActor*>(this)->destroy(); return 0; }
															#line 258 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			new (&static_cast<MonitorBulkDumpJobCompletionActor*>(this)->SAV< bool >::value()) bool(false);
			this->~MonitorBulkDumpJobCompletionActorState();
			static_cast<MonitorBulkDumpJobCompletionActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 92 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(pollInterval);
															#line 92 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<MonitorBulkDumpJobCompletionActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 268 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<MonitorBulkDumpJobCompletionActor*>(this)->actor_wait_state = 2;
															#line 92 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MonitorBulkDumpJobCompletionActor, 1, Void >*>(static_cast<MonitorBulkDumpJobCompletionActor*>(this)));
															#line 273 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<BulkDumpState> const& currentJob,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(currentJob, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<BulkDumpState> && currentJob,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(currentJob), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MonitorBulkDumpJobCompletionActor*>(this)->actor_wait_state > 0) static_cast<MonitorBulkDumpJobCompletionActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorBulkDumpJobCompletionActor*>(this)->ActorCallback< MonitorBulkDumpJobCompletionActor, 0, Optional<BulkDumpState> >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorBulkDumpJobCompletionActor, 0, Optional<BulkDumpState> >*,Optional<BulkDumpState> const& value) 
	{
		fdb_probe_actor_enter("monitorBulkDumpJobCompletion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBulkDumpJobCompletionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBulkDumpJobCompletion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MonitorBulkDumpJobCompletionActor, 0, Optional<BulkDumpState> >*,Optional<BulkDumpState> && value) 
	{
		fdb_probe_actor_enter("monitorBulkDumpJobCompletion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBulkDumpJobCompletionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBulkDumpJobCompletion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MonitorBulkDumpJobCompletionActor, 0, Optional<BulkDumpState> >*,Error err) 
	{
		fdb_probe_actor_enter("monitorBulkDumpJobCompletion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBulkDumpJobCompletionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBulkDumpJobCompletion", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 93 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		tr.reset();
															#line 357 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 93 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		tr.reset();
															#line 366 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<MonitorBulkDumpJobCompletionActor*>(this)->actor_wait_state > 0) static_cast<MonitorBulkDumpJobCompletionActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorBulkDumpJobCompletionActor*>(this)->ActorCallback< MonitorBulkDumpJobCompletionActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorBulkDumpJobCompletionActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorBulkDumpJobCompletion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBulkDumpJobCompletionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBulkDumpJobCompletion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MonitorBulkDumpJobCompletionActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorBulkDumpJobCompletion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBulkDumpJobCompletionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBulkDumpJobCompletion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< MonitorBulkDumpJobCompletionActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorBulkDumpJobCompletion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBulkDumpJobCompletionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBulkDumpJobCompletion", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont7(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<MonitorBulkDumpJobCompletionActor*>(this)->actor_wait_state > 0) static_cast<MonitorBulkDumpJobCompletionActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorBulkDumpJobCompletionActor*>(this)->ActorCallback< MonitorBulkDumpJobCompletionActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorBulkDumpJobCompletionActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorBulkDumpJobCompletion", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBulkDumpJobCompletionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBulkDumpJobCompletion", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< MonitorBulkDumpJobCompletionActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorBulkDumpJobCompletion", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBulkDumpJobCompletionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBulkDumpJobCompletion", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< MonitorBulkDumpJobCompletionActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorBulkDumpJobCompletion", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBulkDumpJobCompletionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBulkDumpJobCompletion", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 75 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Database cx;
															#line 75 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	UID jobId;
															#line 75 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	double timeoutDuration;
															#line 75 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	double pollInterval;
															#line 76 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	double timeoutStart;
															#line 77 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Transaction tr;
															#line 558 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via monitorBulkDumpJobCompletion()
															#line 75 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class MonitorBulkDumpJobCompletionActor final : public Actor<bool>, public ActorCallback< MonitorBulkDumpJobCompletionActor, 0, Optional<BulkDumpState> >, public ActorCallback< MonitorBulkDumpJobCompletionActor, 1, Void >, public ActorCallback< MonitorBulkDumpJobCompletionActor, 2, Void >, public FastAllocated<MonitorBulkDumpJobCompletionActor>, public MonitorBulkDumpJobCompletionActorState<MonitorBulkDumpJobCompletionActor> {
															#line 563 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<MonitorBulkDumpJobCompletionActor>::operator new;
	using FastAllocated<MonitorBulkDumpJobCompletionActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11395645419687095040UL, 10827448424285814528UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MonitorBulkDumpJobCompletionActor, 0, Optional<BulkDumpState> >;
friend struct ActorCallback< MonitorBulkDumpJobCompletionActor, 1, Void >;
friend struct ActorCallback< MonitorBulkDumpJobCompletionActor, 2, Void >;
															#line 75 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	MonitorBulkDumpJobCompletionActor(Database const& cx,UID const& jobId,double const& timeoutDuration,double const& pollInterval) 
															#line 582 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<bool>(),
		   MonitorBulkDumpJobCompletionActorState<MonitorBulkDumpJobCompletionActor>(cx, jobId, timeoutDuration, pollInterval),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("monitorBulkDumpJobCompletion", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5529935736705965568UL, 14592322826510778880UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBulkDumpJobCompletionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("monitorBulkDumpJobCompletion");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("monitorBulkDumpJobCompletion", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MonitorBulkDumpJobCompletionActor, 0, Optional<BulkDumpState> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< MonitorBulkDumpJobCompletionActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< MonitorBulkDumpJobCompletionActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 75 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] Future<bool> monitorBulkDumpJobCompletion( Database const& cx, UID const& jobId, double const& timeoutDuration, double const& pollInterval ) {
															#line 75 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<bool>(new MonitorBulkDumpJobCompletionActor(cx, jobId, timeoutDuration, pollInterval));
															#line 617 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 99 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

// Helper function to monitor BulkLoad job completion
// Returns true if job completed successfully, false if timed out
// lockAware must be true when DB is locked (e.g., during restore)
															#line 625 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via monitorBulkLoadJobCompletion()
															#line 103 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class MonitorBulkLoadJobCompletionActor>
															#line 103 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class MonitorBulkLoadJobCompletionActorState {
															#line 632 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 103 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	MonitorBulkLoadJobCompletionActorState(Database const& cx,UID const& jobId,double const& timeoutDuration,double const& pollInterval,bool const& lockAware) 
															#line 103 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 103 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : cx(cx),
															#line 103 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   jobId(jobId),
															#line 103 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   timeoutDuration(timeoutDuration),
															#line 103 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   pollInterval(pollInterval),
															#line 103 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   lockAware(lockAware),
															#line 108 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   timeoutStart(now())
															#line 649 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("monitorBulkLoadJobCompletion", reinterpret_cast<unsigned long>(this));

	}
	~MonitorBulkLoadJobCompletionActorState() 
	{
		fdb_probe_actor_destroy("monitorBulkLoadJobCompletion", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 110 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			;
															#line 664 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MonitorBulkLoadJobCompletionActorState();
		static_cast<MonitorBulkLoadJobCompletionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 111 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Optional<BulkLoadJobState>> __when_expr_0 = getRunningBulkLoadJob(cx, lockAware);
															#line 111 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<MonitorBulkLoadJobCompletionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 696 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<MonitorBulkLoadJobCompletionActor*>(this)->actor_wait_state = 1;
															#line 111 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MonitorBulkLoadJobCompletionActor, 0, Optional<BulkLoadJobState> >*>(static_cast<MonitorBulkLoadJobCompletionActor*>(this)));
															#line 701 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Optional<BulkLoadJobState> const& currentJob,int loopDepth) 
	{
															#line 112 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		bool stillRunning = currentJob.present() && currentJob.get().getJobId() == jobId;
															#line 114 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!stillRunning)
															#line 712 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 115 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!static_cast<MonitorBulkLoadJobCompletionActor*>(this)->SAV<bool>::futures) { (void)(true); this->~MonitorBulkLoadJobCompletionActorState(); static_cast<MonitorBulkLoadJobCompletionActor*>(this)->destroy(); return 0; }
															#line 716 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			new (&static_cast<MonitorBulkLoadJobCompletionActor*>(this)->SAV< bool >::value()) bool(true);
			this->~MonitorBulkLoadJobCompletionActorState();
			static_cast<MonitorBulkLoadJobCompletionActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 118 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (now() - timeoutStart > timeoutDuration)
															#line 724 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 119 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!static_cast<MonitorBulkLoadJobCompletionActor*>(this)->SAV<bool>::futures) { (void)(false); this->~MonitorBulkLoadJobCompletionActorState(); static_cast<MonitorBulkLoadJobCompletionActor*>(this)->destroy(); return 0; }
															#line 728 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			new (&static_cast<MonitorBulkLoadJobCompletionActor*>(this)->SAV< bool >::value()) bool(false);
			this->~MonitorBulkLoadJobCompletionActorState();
			static_cast<MonitorBulkLoadJobCompletionActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 122 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(pollInterval);
															#line 122 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<MonitorBulkLoadJobCompletionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 738 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<MonitorBulkLoadJobCompletionActor*>(this)->actor_wait_state = 2;
															#line 122 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MonitorBulkLoadJobCompletionActor, 1, Void >*>(static_cast<MonitorBulkLoadJobCompletionActor*>(this)));
															#line 743 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Optional<BulkLoadJobState> && currentJob,int loopDepth) 
	{
															#line 112 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		bool stillRunning = currentJob.present() && currentJob.get().getJobId() == jobId;
															#line 114 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!stillRunning)
															#line 754 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 115 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!static_cast<MonitorBulkLoadJobCompletionActor*>(this)->SAV<bool>::futures) { (void)(true); this->~MonitorBulkLoadJobCompletionActorState(); static_cast<MonitorBulkLoadJobCompletionActor*>(this)->destroy(); return 0; }
															#line 758 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			new (&static_cast<MonitorBulkLoadJobCompletionActor*>(this)->SAV< bool >::value()) bool(true);
			this->~MonitorBulkLoadJobCompletionActorState();
			static_cast<MonitorBulkLoadJobCompletionActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 118 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (now() - timeoutStart > timeoutDuration)
															#line 766 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 119 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!static_cast<MonitorBulkLoadJobCompletionActor*>(this)->SAV<bool>::futures) { (void)(false); this->~MonitorBulkLoadJobCompletionActorState(); static_cast<MonitorBulkLoadJobCompletionActor*>(this)->destroy(); return 0; }
															#line 770 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			new (&static_cast<MonitorBulkLoadJobCompletionActor*>(this)->SAV< bool >::value()) bool(false);
			this->~MonitorBulkLoadJobCompletionActorState();
			static_cast<MonitorBulkLoadJobCompletionActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 122 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(pollInterval);
															#line 122 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<MonitorBulkLoadJobCompletionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 780 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<MonitorBulkLoadJobCompletionActor*>(this)->actor_wait_state = 2;
															#line 122 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MonitorBulkLoadJobCompletionActor, 1, Void >*>(static_cast<MonitorBulkLoadJobCompletionActor*>(this)));
															#line 785 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<BulkLoadJobState> const& currentJob,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(currentJob, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<BulkLoadJobState> && currentJob,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(currentJob), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MonitorBulkLoadJobCompletionActor*>(this)->actor_wait_state > 0) static_cast<MonitorBulkLoadJobCompletionActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorBulkLoadJobCompletionActor*>(this)->ActorCallback< MonitorBulkLoadJobCompletionActor, 0, Optional<BulkLoadJobState> >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorBulkLoadJobCompletionActor, 0, Optional<BulkLoadJobState> >*,Optional<BulkLoadJobState> const& value) 
	{
		fdb_probe_actor_enter("monitorBulkLoadJobCompletion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBulkLoadJobCompletionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBulkLoadJobCompletion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MonitorBulkLoadJobCompletionActor, 0, Optional<BulkLoadJobState> >*,Optional<BulkLoadJobState> && value) 
	{
		fdb_probe_actor_enter("monitorBulkLoadJobCompletion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBulkLoadJobCompletionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBulkLoadJobCompletion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MonitorBulkLoadJobCompletionActor, 0, Optional<BulkLoadJobState> >*,Error err) 
	{
		fdb_probe_actor_enter("monitorBulkLoadJobCompletion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBulkLoadJobCompletionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBulkLoadJobCompletion", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<MonitorBulkLoadJobCompletionActor*>(this)->actor_wait_state > 0) static_cast<MonitorBulkLoadJobCompletionActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorBulkLoadJobCompletionActor*>(this)->ActorCallback< MonitorBulkLoadJobCompletionActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorBulkLoadJobCompletionActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorBulkLoadJobCompletion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBulkLoadJobCompletionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBulkLoadJobCompletion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MonitorBulkLoadJobCompletionActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorBulkLoadJobCompletion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBulkLoadJobCompletionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBulkLoadJobCompletion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< MonitorBulkLoadJobCompletionActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorBulkLoadJobCompletion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBulkLoadJobCompletionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBulkLoadJobCompletion", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 103 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Database cx;
															#line 103 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	UID jobId;
															#line 103 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	double timeoutDuration;
															#line 103 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	double pollInterval;
															#line 103 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	bool lockAware;
															#line 108 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	double timeoutStart;
															#line 964 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via monitorBulkLoadJobCompletion()
															#line 103 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class MonitorBulkLoadJobCompletionActor final : public Actor<bool>, public ActorCallback< MonitorBulkLoadJobCompletionActor, 0, Optional<BulkLoadJobState> >, public ActorCallback< MonitorBulkLoadJobCompletionActor, 1, Void >, public FastAllocated<MonitorBulkLoadJobCompletionActor>, public MonitorBulkLoadJobCompletionActorState<MonitorBulkLoadJobCompletionActor> {
															#line 969 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<MonitorBulkLoadJobCompletionActor>::operator new;
	using FastAllocated<MonitorBulkLoadJobCompletionActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10309652574251154944UL, 8501367413964941056UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MonitorBulkLoadJobCompletionActor, 0, Optional<BulkLoadJobState> >;
friend struct ActorCallback< MonitorBulkLoadJobCompletionActor, 1, Void >;
															#line 103 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	MonitorBulkLoadJobCompletionActor(Database const& cx,UID const& jobId,double const& timeoutDuration,double const& pollInterval,bool const& lockAware) 
															#line 987 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<bool>(),
		   MonitorBulkLoadJobCompletionActorState<MonitorBulkLoadJobCompletionActor>(cx, jobId, timeoutDuration, pollInterval, lockAware),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("monitorBulkLoadJobCompletion", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1112861618613399552UL, 14147132304920947712UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBulkLoadJobCompletionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("monitorBulkLoadJobCompletion");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("monitorBulkLoadJobCompletion", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MonitorBulkLoadJobCompletionActor, 0, Optional<BulkLoadJobState> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< MonitorBulkLoadJobCompletionActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 103 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] Future<bool> monitorBulkLoadJobCompletion( Database const& cx, UID const& jobId, double const& timeoutDuration, double const& pollInterval, bool const& lockAware ) {
															#line 103 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<bool>(new MonitorBulkLoadJobCompletionActor(cx, jobId, timeoutDuration, pollInterval, lockAware));
															#line 1021 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 125 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

// Verify that a complete BulkDump dataset exists for BulkLoad restore
// Returns true if dataset is complete, false if incomplete
// JobId corresponds to a single BulkDump job which represents one snapshot at a specific version
															#line 1029 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via verifyBulkDumpDatasetCompleteness()
															#line 129 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class VerifyBulkDumpDatasetCompletenessActor>
															#line 129 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class VerifyBulkDumpDatasetCompletenessActorState {
															#line 1036 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 129 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	VerifyBulkDumpDatasetCompletenessActorState(Reference<IBackupContainer> const& bc,std::string const& bulkDumpJobId) 
															#line 129 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 129 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : bc(bc),
															#line 129 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   bulkDumpJobId(bulkDumpJobId)
															#line 1045 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("verifyBulkDumpDatasetCompleteness", reinterpret_cast<unsigned long>(this));

	}
	~VerifyBulkDumpDatasetCompletenessActorState() 
	{
		fdb_probe_actor_destroy("verifyBulkDumpDatasetCompleteness", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 131 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				if (bulkDumpJobId.empty())
															#line 1061 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
				{
															#line 132 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
					TraceEvent(SevWarn, "BulkLoadVerifyDatasetEmptyJobId");
															#line 133 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
					if (!static_cast<VerifyBulkDumpDatasetCompletenessActor*>(this)->SAV<bool>::futures) { (void)(false); this->~VerifyBulkDumpDatasetCompletenessActorState(); static_cast<VerifyBulkDumpDatasetCompletenessActor*>(this)->destroy(); return 0; }
															#line 1067 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
					new (&static_cast<VerifyBulkDumpDatasetCompletenessActor*>(this)->SAV< bool >::value()) bool(false);
					this->~VerifyBulkDumpDatasetCompletenessActorState();
					static_cast<VerifyBulkDumpDatasetCompletenessActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
															#line 139 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				jobDirectoryPath = "bulkdump_data/" + bulkDumpJobId + "/";
															#line 1075 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
				try {
															#line 143 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
					Reference<BackupContainerFileSystem> bcfs = bc.castTo<BackupContainerFileSystem>();
															#line 144 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
					if (bcfs)
															#line 1081 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
					{
															#line 146 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
						StrictFuture<BackupContainerFileSystem::FilesAndSizesT> __when_expr_0 = bcfs->listFiles(jobDirectoryPath);
															#line 146 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
						if (static_cast<VerifyBulkDumpDatasetCompletenessActor*>(this)->actor_wait_state < 0) return a_body1Catch3(actor_cancelled(), loopDepth);
															#line 1087 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
						if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch3(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
						static_cast<VerifyBulkDumpDatasetCompletenessActor*>(this)->actor_wait_state = 1;
															#line 146 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
						__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< VerifyBulkDumpDatasetCompletenessActor, 0, BackupContainerFileSystem::FilesAndSizesT >*>(static_cast<VerifyBulkDumpDatasetCompletenessActor*>(this)));
															#line 1092 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
						loopDepth = 0;
					}
					else
					{
															#line 165 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
						TraceEvent(SevWarn, "BulkLoadVerifyDatasetCannotCast") .detail("BulkDumpJobId", bulkDumpJobId) .detail("Note", "BackupContainer does not support file listing required for verification");
															#line 168 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
						if (!static_cast<VerifyBulkDumpDatasetCompletenessActor*>(this)->SAV<bool>::futures) { (void)(false); this->~VerifyBulkDumpDatasetCompletenessActorState(); static_cast<VerifyBulkDumpDatasetCompletenessActor*>(this)->destroy(); return 0; }
															#line 1101 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
						new (&static_cast<VerifyBulkDumpDatasetCompletenessActor*>(this)->SAV< bool >::value()) bool(false);
						this->~VerifyBulkDumpDatasetCompletenessActorState();
						static_cast<VerifyBulkDumpDatasetCompletenessActor*>(this)->finishSendAndDelPromiseRef();
						return 0;
					}
				}
				catch (Error& error) {
					loopDepth = a_body1Catch3(error, loopDepth);
				} catch (...) {
					loopDepth = a_body1Catch3(unknown_error(), loopDepth);
				}
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~VerifyBulkDumpDatasetCompletenessActorState();
		static_cast<VerifyBulkDumpDatasetCompletenessActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 181 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			TraceEvent(SevWarn, "BulkLoadVerifyDatasetError").error(e).detail("BulkDumpJobId", bulkDumpJobId);
															#line 182 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!static_cast<VerifyBulkDumpDatasetCompletenessActor*>(this)->SAV<bool>::futures) { (void)(false); this->~VerifyBulkDumpDatasetCompletenessActorState(); static_cast<VerifyBulkDumpDatasetCompletenessActor*>(this)->destroy(); return 0; }
															#line 1143 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			new (&static_cast<VerifyBulkDumpDatasetCompletenessActor*>(this)->SAV< bool >::value()) bool(false);
			this->~VerifyBulkDumpDatasetCompletenessActorState();
			static_cast<VerifyBulkDumpDatasetCompletenessActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch3(const Error& e,int loopDepth=0) 
	{
		try {
															#line 171 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (e.code() == error_code_file_not_found)
															#line 1162 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			{
															#line 172 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				TraceEvent(SevWarn, "BulkLoadVerifyDatasetJobDirectoryNotFound") .detail("JobDirectoryPath", jobDirectoryPath) .detail("BulkDumpJobId", bulkDumpJobId);
															#line 175 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				if (!static_cast<VerifyBulkDumpDatasetCompletenessActor*>(this)->SAV<bool>::futures) { (void)(false); this->~VerifyBulkDumpDatasetCompletenessActorState(); static_cast<VerifyBulkDumpDatasetCompletenessActor*>(this)->destroy(); return 0; }
															#line 1168 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
				new (&static_cast<VerifyBulkDumpDatasetCompletenessActor*>(this)->SAV< bool >::value()) bool(false);
				this->~VerifyBulkDumpDatasetCompletenessActorState();
				static_cast<VerifyBulkDumpDatasetCompletenessActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 177 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			return a_body1Catch2(e, loopDepth);
															#line 1176 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont5(BackupContainerFileSystem::FilesAndSizesT const& files,int loopDepth) 
	{
															#line 147 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (files.empty())
															#line 1190 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 148 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			TraceEvent(SevWarn, "BulkLoadVerifyDatasetJobDirectoryEmpty") .detail("JobDirectoryPath", jobDirectoryPath) .detail("BulkDumpJobId", bulkDumpJobId);
															#line 151 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!static_cast<VerifyBulkDumpDatasetCompletenessActor*>(this)->SAV<bool>::futures) { (void)(false); this->~VerifyBulkDumpDatasetCompletenessActorState(); static_cast<VerifyBulkDumpDatasetCompletenessActor*>(this)->destroy(); return 0; }
															#line 1196 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			new (&static_cast<VerifyBulkDumpDatasetCompletenessActor*>(this)->SAV< bool >::value()) bool(false);
			this->~VerifyBulkDumpDatasetCompletenessActorState();
			static_cast<VerifyBulkDumpDatasetCompletenessActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 154 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		TraceEvent("BulkLoadVerifyDatasetJobDirectoryFound") .detail("JobDirectoryPath", jobDirectoryPath) .detail("BulkDumpJobId", bulkDumpJobId) .detail("FileCount", files.size());
															#line 161 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<VerifyBulkDumpDatasetCompletenessActor*>(this)->SAV<bool>::futures) { (void)(true); this->~VerifyBulkDumpDatasetCompletenessActorState(); static_cast<VerifyBulkDumpDatasetCompletenessActor*>(this)->destroy(); return 0; }
															#line 1206 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<VerifyBulkDumpDatasetCompletenessActor*>(this)->SAV< bool >::value()) bool(true);
		this->~VerifyBulkDumpDatasetCompletenessActorState();
		static_cast<VerifyBulkDumpDatasetCompletenessActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5(BackupContainerFileSystem::FilesAndSizesT && files,int loopDepth) 
	{
															#line 147 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (files.empty())
															#line 1218 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 148 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			TraceEvent(SevWarn, "BulkLoadVerifyDatasetJobDirectoryEmpty") .detail("JobDirectoryPath", jobDirectoryPath) .detail("BulkDumpJobId", bulkDumpJobId);
															#line 151 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!static_cast<VerifyBulkDumpDatasetCompletenessActor*>(this)->SAV<bool>::futures) { (void)(false); this->~VerifyBulkDumpDatasetCompletenessActorState(); static_cast<VerifyBulkDumpDatasetCompletenessActor*>(this)->destroy(); return 0; }
															#line 1224 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			new (&static_cast<VerifyBulkDumpDatasetCompletenessActor*>(this)->SAV< bool >::value()) bool(false);
			this->~VerifyBulkDumpDatasetCompletenessActorState();
			static_cast<VerifyBulkDumpDatasetCompletenessActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 154 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		TraceEvent("BulkLoadVerifyDatasetJobDirectoryFound") .detail("JobDirectoryPath", jobDirectoryPath) .detail("BulkDumpJobId", bulkDumpJobId) .detail("FileCount", files.size());
															#line 161 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<VerifyBulkDumpDatasetCompletenessActor*>(this)->SAV<bool>::futures) { (void)(true); this->~VerifyBulkDumpDatasetCompletenessActorState(); static_cast<VerifyBulkDumpDatasetCompletenessActor*>(this)->destroy(); return 0; }
															#line 1234 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<VerifyBulkDumpDatasetCompletenessActor*>(this)->SAV< bool >::value()) bool(true);
		this->~VerifyBulkDumpDatasetCompletenessActorState();
		static_cast<VerifyBulkDumpDatasetCompletenessActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(BackupContainerFileSystem::FilesAndSizesT const& files,int loopDepth) 
	{
		loopDepth = a_body1cont5(files, loopDepth);

		return loopDepth;
	}
	int a_body1when1(BackupContainerFileSystem::FilesAndSizesT && files,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(files), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<VerifyBulkDumpDatasetCompletenessActor*>(this)->actor_wait_state > 0) static_cast<VerifyBulkDumpDatasetCompletenessActor*>(this)->actor_wait_state = 0;
		static_cast<VerifyBulkDumpDatasetCompletenessActor*>(this)->ActorCallback< VerifyBulkDumpDatasetCompletenessActor, 0, BackupContainerFileSystem::FilesAndSizesT >::remove();

	}
	void a_callback_fire(ActorCallback< VerifyBulkDumpDatasetCompletenessActor, 0, BackupContainerFileSystem::FilesAndSizesT >*,BackupContainerFileSystem::FilesAndSizesT const& value) 
	{
		fdb_probe_actor_enter("verifyBulkDumpDatasetCompleteness", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyBulkDumpDatasetCompletenessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch3(error, 0);
		} catch (...) {
			a_body1Catch3(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyBulkDumpDatasetCompleteness", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< VerifyBulkDumpDatasetCompletenessActor, 0, BackupContainerFileSystem::FilesAndSizesT >*,BackupContainerFileSystem::FilesAndSizesT && value) 
	{
		fdb_probe_actor_enter("verifyBulkDumpDatasetCompleteness", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyBulkDumpDatasetCompletenessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch3(error, 0);
		} catch (...) {
			a_body1Catch3(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyBulkDumpDatasetCompleteness", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< VerifyBulkDumpDatasetCompletenessActor, 0, BackupContainerFileSystem::FilesAndSizesT >*,Error err) 
	{
		fdb_probe_actor_enter("verifyBulkDumpDatasetCompleteness", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyBulkDumpDatasetCompletenessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch3(err, 0);
		}
		catch (Error& error) {
			a_body1Catch3(error, 0);
		} catch (...) {
			a_body1Catch3(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyBulkDumpDatasetCompleteness", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 129 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<IBackupContainer> bc;
															#line 129 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	std::string bulkDumpJobId;
															#line 139 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	std::string jobDirectoryPath;
															#line 1323 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via verifyBulkDumpDatasetCompleteness()
															#line 129 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class VerifyBulkDumpDatasetCompletenessActor final : public Actor<bool>, public ActorCallback< VerifyBulkDumpDatasetCompletenessActor, 0, BackupContainerFileSystem::FilesAndSizesT >, public FastAllocated<VerifyBulkDumpDatasetCompletenessActor>, public VerifyBulkDumpDatasetCompletenessActorState<VerifyBulkDumpDatasetCompletenessActor> {
															#line 1328 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<VerifyBulkDumpDatasetCompletenessActor>::operator new;
	using FastAllocated<VerifyBulkDumpDatasetCompletenessActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1927808224590057472UL, 2938868007103065600UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< VerifyBulkDumpDatasetCompletenessActor, 0, BackupContainerFileSystem::FilesAndSizesT >;
															#line 129 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	VerifyBulkDumpDatasetCompletenessActor(Reference<IBackupContainer> const& bc,std::string const& bulkDumpJobId) 
															#line 1345 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<bool>(),
		   VerifyBulkDumpDatasetCompletenessActorState<VerifyBulkDumpDatasetCompletenessActor>(bc, bulkDumpJobId),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("verifyBulkDumpDatasetCompleteness", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2860798591858006272UL, 6889877595501473280UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyBulkDumpDatasetCompletenessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("verifyBulkDumpDatasetCompleteness");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("verifyBulkDumpDatasetCompleteness", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< VerifyBulkDumpDatasetCompletenessActor, 0, BackupContainerFileSystem::FilesAndSizesT >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 129 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] Future<bool> verifyBulkDumpDatasetCompleteness( Reference<IBackupContainer> const& bc, std::string const& bulkDumpJobId ) {
															#line 129 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<bool>(new VerifyBulkDumpDatasetCompletenessActor(bc, bulkDumpJobId));
															#line 1378 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 185 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

// Note: BulkLoad configuration validation (shard_encode_location_metadata, enable_read_lock_on_range)
// is performed by the BulkLoad system on the server side. Client-side validation is not possible
// because SERVER_KNOBS are not accessible from fdbclient.

Optional<std::string> fileBackupAgentProxy = Optional<std::string>();

#define SevFRTestInfo SevVerbose
// #define SevFRTestInfo SevInfo

static std::string boolToYesOrNo(bool val) {
	return val ? std::string("Yes") : std::string("No");
}

static std::string versionToString(Optional<Version> version) {
	if (version.present())
		return std::to_string(version.get());
	else
		return "N/A";
}

static std::string timeStampToString(Optional<int64_t> epochs) {
	if (!epochs.present())
		return "N/A";
	return BackupAgentBase::formatTime(epochs.get());
}

static Future<Optional<int64_t>> getTimestampFromVersion(Optional<Version> ver,
                                                         Reference<ReadYourWritesTransaction> tr) {
	if (!ver.present())
		return Optional<int64_t>();

	return timeKeeperEpochsFromVersion(ver.get(), tr);
}

// Time format :
// <= 59 seconds
// <= 59.99 minutes
// <= 23.99 hours
// N.NN days
std::string secondsToTimeFormat(int64_t seconds) {
	if (seconds >= 86400)
		return format("%.2f day(s)", seconds / 86400.0);
	else if (seconds >= 3600)
		return format("%.2f hour(s)", seconds / 3600.0);
	else if (seconds >= 60)
		return format("%.2f minute(s)", seconds / 60.0);
	else
		return format("%lld second(s)", seconds);
}

const Key FileBackupAgent::keyLastRestorable = "last_restorable"_sr;

// For convenience
typedef FileBackupAgent::ERestoreState ERestoreState;

StringRef FileBackupAgent::restoreStateText(ERestoreState id) {
	switch (id) {
	case ERestoreState::UNINITIALIZED:
		return "uninitialized"_sr;
	case ERestoreState::QUEUED:
		return "queued"_sr;
	case ERestoreState::STARTING:
		return "starting"_sr;
	case ERestoreState::RUNNING:
		return "running"_sr;
	case ERestoreState::COMPLETED:
		return "completed"_sr;
	case ERestoreState::ABORTED:
		return "aborted"_sr;
	default:
		return "Unknown"_sr;
	}
}

Key FileBackupAgent::getPauseKey() {
	FileBackupAgent backupAgent;
	return backupAgent.taskBucket->getPauseKey();
}

															#line 1462 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via getAll_impl()
															#line 265 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class TagUidMap_GetAll_implActor>
															#line 265 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class TagUidMap_GetAll_implActorState {
															#line 1468 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 265 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	TagUidMap_GetAll_implActorState(TagUidMap* const& tagsMap,Reference<ReadYourWritesTransaction> const& tr,Snapshot const& snapshot) 
															#line 265 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 265 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : tagsMap(tagsMap),
															#line 265 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   tr(tr),
															#line 265 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   snapshot(snapshot),
															#line 268 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   prefix(tagsMap->prefix)
															#line 1481 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getAll_impl", reinterpret_cast<unsigned long>(this));

	}
	~TagUidMap_GetAll_implActorState() 
	{
		fdb_probe_actor_destroy("getAll_impl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 269 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<TagMap::RangeResultType> __when_expr_0 = tagsMap->getRange(tr, std::string(), {}, 1e6, snapshot);
															#line 269 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<TagUidMap_GetAll_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1498 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TagUidMap_GetAll_implActor*>(this)->actor_wait_state = 1;
															#line 269 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TagUidMap_GetAll_implActor, 0, TagMap::RangeResultType >*>(static_cast<TagUidMap_GetAll_implActor*>(this)));
															#line 1503 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TagUidMap_GetAll_implActorState();
		static_cast<TagUidMap_GetAll_implActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(TagMap::RangeResultType const& tagPairs,int loopDepth) 
	{
															#line 270 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		std::vector<KeyBackedTag> results;
															#line 271 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		for( auto& p : tagPairs.results ) {
															#line 272 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			results.push_back(KeyBackedTag(p.first, prefix));
															#line 1530 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
															#line 273 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<TagUidMap_GetAll_implActor*>(this)->SAV<std::vector<KeyBackedTag>>::futures) { (void)(results); this->~TagUidMap_GetAll_implActorState(); static_cast<TagUidMap_GetAll_implActor*>(this)->destroy(); return 0; }
															#line 1534 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<TagUidMap_GetAll_implActor*>(this)->SAV< std::vector<KeyBackedTag> >::value()) std::vector<KeyBackedTag>(results);
		this->~TagUidMap_GetAll_implActorState();
		static_cast<TagUidMap_GetAll_implActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(TagMap::RangeResultType && tagPairs,int loopDepth) 
	{
															#line 270 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		std::vector<KeyBackedTag> results;
															#line 271 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		for( auto& p : tagPairs.results ) {
															#line 272 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			results.push_back(KeyBackedTag(p.first, prefix));
															#line 1550 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
															#line 273 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<TagUidMap_GetAll_implActor*>(this)->SAV<std::vector<KeyBackedTag>>::futures) { (void)(results); this->~TagUidMap_GetAll_implActorState(); static_cast<TagUidMap_GetAll_implActor*>(this)->destroy(); return 0; }
															#line 1554 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<TagUidMap_GetAll_implActor*>(this)->SAV< std::vector<KeyBackedTag> >::value()) std::vector<KeyBackedTag>(results);
		this->~TagUidMap_GetAll_implActorState();
		static_cast<TagUidMap_GetAll_implActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(TagMap::RangeResultType const& tagPairs,int loopDepth) 
	{
		loopDepth = a_body1cont1(tagPairs, loopDepth);

		return loopDepth;
	}
	int a_body1when1(TagMap::RangeResultType && tagPairs,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(tagPairs), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TagUidMap_GetAll_implActor*>(this)->actor_wait_state > 0) static_cast<TagUidMap_GetAll_implActor*>(this)->actor_wait_state = 0;
		static_cast<TagUidMap_GetAll_implActor*>(this)->ActorCallback< TagUidMap_GetAll_implActor, 0, TagMap::RangeResultType >::remove();

	}
	void a_callback_fire(ActorCallback< TagUidMap_GetAll_implActor, 0, TagMap::RangeResultType >*,TagMap::RangeResultType const& value) 
	{
		fdb_probe_actor_enter("getAll_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TagUidMap_GetAll_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAll_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TagUidMap_GetAll_implActor, 0, TagMap::RangeResultType >*,TagMap::RangeResultType && value) 
	{
		fdb_probe_actor_enter("getAll_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TagUidMap_GetAll_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAll_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TagUidMap_GetAll_implActor, 0, TagMap::RangeResultType >*,Error err) 
	{
		fdb_probe_actor_enter("getAll_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TagUidMap_GetAll_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAll_impl", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 265 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	TagUidMap* tagsMap;
															#line 265 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 265 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Snapshot snapshot;
															#line 268 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Key prefix;
															#line 1645 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getAll_impl()
															#line 265 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class TagUidMap_GetAll_implActor final : public Actor<std::vector<KeyBackedTag>>, public ActorCallback< TagUidMap_GetAll_implActor, 0, TagMap::RangeResultType >, public FastAllocated<TagUidMap_GetAll_implActor>, public TagUidMap_GetAll_implActorState<TagUidMap_GetAll_implActor> {
															#line 1650 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<TagUidMap_GetAll_implActor>::operator new;
	using FastAllocated<TagUidMap_GetAll_implActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4844895045092282112UL, 5436906651642842624UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<KeyBackedTag>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TagUidMap_GetAll_implActor, 0, TagMap::RangeResultType >;
															#line 265 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	TagUidMap_GetAll_implActor(TagUidMap* const& tagsMap,Reference<ReadYourWritesTransaction> const& tr,Snapshot const& snapshot) 
															#line 1667 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<std::vector<KeyBackedTag>>(),
		   TagUidMap_GetAll_implActorState<TagUidMap_GetAll_implActor>(tagsMap, tr, snapshot),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getAll_impl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4531936230553832704UL, 10523325084301780224UL);
		ActorExecutionContextHelper __helper(static_cast<TagUidMap_GetAll_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getAll_impl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getAll_impl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TagUidMap_GetAll_implActor, 0, TagMap::RangeResultType >*)0, actor_cancelled()); break;
		}

	}
};
															#line 265 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] Future<std::vector<KeyBackedTag>> TagUidMap::getAll_impl( TagUidMap* const& tagsMap, Reference<ReadYourWritesTransaction> const& tr, Snapshot const& snapshot ) {
															#line 265 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<std::vector<KeyBackedTag>>(new TagUidMap_GetAll_implActor(tagsMap, tr, snapshot));
															#line 1699 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 275 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

KeyBackedTag::KeyBackedTag(std::string tagName, StringRef tagMapPrefix)
  : KeyBackedProperty<UidAndAbortedFlagT>(TagUidMap(tagMapPrefix).getProperty(tagName)), tagName(tagName),
    tagMapPrefix(tagMapPrefix) {}

// Lists all backups and find if any partitioned backup is running.
															#line 1709 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via anyPartitionedBackupRunning()
															#line 281 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class AnyPartitionedBackupRunningActor>
															#line 281 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class AnyPartitionedBackupRunningActorState {
															#line 1716 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 281 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	AnyPartitionedBackupRunningActorState(Reference<ReadYourWritesTransaction> const& tr) 
															#line 281 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 281 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : tr(tr)
															#line 1723 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("anyPartitionedBackupRunning", reinterpret_cast<unsigned long>(this));

	}
	~AnyPartitionedBackupRunningActorState() 
	{
		fdb_probe_actor_destroy("anyPartitionedBackupRunning", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 282 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 283 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 284 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<std::vector<KeyBackedTag>> __when_expr_0 = getAllBackupTags(tr);
															#line 284 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<AnyPartitionedBackupRunningActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1744 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<AnyPartitionedBackupRunningActor*>(this)->actor_wait_state = 1;
															#line 284 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< AnyPartitionedBackupRunningActor, 0, std::vector<KeyBackedTag> >*>(static_cast<AnyPartitionedBackupRunningActor*>(this)));
															#line 1749 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~AnyPartitionedBackupRunningActorState();
		static_cast<AnyPartitionedBackupRunningActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<KeyBackedTag> const& tags,int loopDepth) 
	{
															#line 286 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		futures = std::vector<Future<Optional<UidAndAbortedFlagT>>>();
															#line 287 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		for( const auto& tag : tags ) {
															#line 288 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			futures.push_back(tag.get(tr));
															#line 1776 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
															#line 291 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = waitForAll(futures);
															#line 291 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<AnyPartitionedBackupRunningActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1782 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<AnyPartitionedBackupRunningActor*>(this)->actor_wait_state = 2;
															#line 291 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< AnyPartitionedBackupRunningActor, 1, Void >*>(static_cast<AnyPartitionedBackupRunningActor*>(this)));
															#line 1787 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<KeyBackedTag> && tags,int loopDepth) 
	{
															#line 286 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		futures = std::vector<Future<Optional<UidAndAbortedFlagT>>>();
															#line 287 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		for( const auto& tag : tags ) {
															#line 288 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			futures.push_back(tag.get(tr));
															#line 1800 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
															#line 291 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = waitForAll(futures);
															#line 291 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<AnyPartitionedBackupRunningActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1806 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<AnyPartitionedBackupRunningActor*>(this)->actor_wait_state = 2;
															#line 291 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< AnyPartitionedBackupRunningActor, 1, Void >*>(static_cast<AnyPartitionedBackupRunningActor*>(this)));
															#line 1811 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(std::vector<KeyBackedTag> const& tags,int loopDepth) 
	{
		loopDepth = a_body1cont1(tags, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<KeyBackedTag> && tags,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(tags), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<AnyPartitionedBackupRunningActor*>(this)->actor_wait_state > 0) static_cast<AnyPartitionedBackupRunningActor*>(this)->actor_wait_state = 0;
		static_cast<AnyPartitionedBackupRunningActor*>(this)->ActorCallback< AnyPartitionedBackupRunningActor, 0, std::vector<KeyBackedTag> >::remove();

	}
	void a_callback_fire(ActorCallback< AnyPartitionedBackupRunningActor, 0, std::vector<KeyBackedTag> >*,std::vector<KeyBackedTag> const& value) 
	{
		fdb_probe_actor_enter("anyPartitionedBackupRunning", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AnyPartitionedBackupRunningActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("anyPartitionedBackupRunning", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< AnyPartitionedBackupRunningActor, 0, std::vector<KeyBackedTag> >*,std::vector<KeyBackedTag> && value) 
	{
		fdb_probe_actor_enter("anyPartitionedBackupRunning", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AnyPartitionedBackupRunningActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("anyPartitionedBackupRunning", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< AnyPartitionedBackupRunningActor, 0, std::vector<KeyBackedTag> >*,Error err) 
	{
		fdb_probe_actor_enter("anyPartitionedBackupRunning", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AnyPartitionedBackupRunningActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("anyPartitionedBackupRunning", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 292 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		i = 0;
															#line 293 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		i = 0;
															#line 1897 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 292 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		i = 0;
															#line 293 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		i = 0;
															#line 1908 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<AnyPartitionedBackupRunningActor*>(this)->actor_wait_state > 0) static_cast<AnyPartitionedBackupRunningActor*>(this)->actor_wait_state = 0;
		static_cast<AnyPartitionedBackupRunningActor*>(this)->ActorCallback< AnyPartitionedBackupRunningActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AnyPartitionedBackupRunningActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("anyPartitionedBackupRunning", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AnyPartitionedBackupRunningActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("anyPartitionedBackupRunning", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< AnyPartitionedBackupRunningActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("anyPartitionedBackupRunning", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AnyPartitionedBackupRunningActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("anyPartitionedBackupRunning", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< AnyPartitionedBackupRunningActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("anyPartitionedBackupRunning", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AnyPartitionedBackupRunningActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("anyPartitionedBackupRunning", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 306 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<AnyPartitionedBackupRunningActor*>(this)->SAV<bool>::futures) { (void)(false); this->~AnyPartitionedBackupRunningActorState(); static_cast<AnyPartitionedBackupRunningActor*>(this)->destroy(); return 0; }
															#line 1992 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<AnyPartitionedBackupRunningActor*>(this)->SAV< bool >::value()) bool(false);
		this->~AnyPartitionedBackupRunningActorState();
		static_cast<AnyPartitionedBackupRunningActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1(int loopDepth) 
	{
															#line 293 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!(i < futures.size()))
															#line 2011 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
			return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 294 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (futures[i].get().present())
															#line 2017 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 295 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			partitionedLog = Optional<bool>();
															#line 296 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			eState = EBackupState();
															#line 297 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			BackupConfig config(futures[i].get().get().first);
															#line 299 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_2 = store(eState, config.stateEnum().getD(tr, Snapshot::False, EBackupState::STATE_NEVERRAN)) && store(partitionedLog, config.partitionedLogEnabled().get(tr));
															#line 299 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<AnyPartitionedBackupRunningActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2029 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when1(__when_expr_2.get(), loopDepth); };
			static_cast<AnyPartitionedBackupRunningActor*>(this)->actor_wait_state = 3;
															#line 299 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< AnyPartitionedBackupRunningActor, 2, Void >*>(static_cast<AnyPartitionedBackupRunningActor*>(this)));
															#line 2034 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2break1(int loopDepth) 
	{
		try {
			return a_body1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(int loopDepth) 
	{
															#line 293 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		i++;
															#line 2061 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 301 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (FileBackupAgent::isRunnable(eState) && partitionedLog.present() && partitionedLog.get())
															#line 2070 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 302 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!static_cast<AnyPartitionedBackupRunningActor*>(this)->SAV<bool>::futures) { (void)(true); this->~AnyPartitionedBackupRunningActorState(); static_cast<AnyPartitionedBackupRunningActor*>(this)->destroy(); return 0; }
															#line 2074 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			new (&static_cast<AnyPartitionedBackupRunningActor*>(this)->SAV< bool >::value()) bool(true);
			this->~AnyPartitionedBackupRunningActorState();
			static_cast<AnyPartitionedBackupRunningActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 301 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (FileBackupAgent::isRunnable(eState) && partitionedLog.present() && partitionedLog.get())
															#line 2088 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 302 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!static_cast<AnyPartitionedBackupRunningActor*>(this)->SAV<bool>::futures) { (void)(true); this->~AnyPartitionedBackupRunningActorState(); static_cast<AnyPartitionedBackupRunningActor*>(this)->destroy(); return 0; }
															#line 2092 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			new (&static_cast<AnyPartitionedBackupRunningActor*>(this)->SAV< bool >::value()) bool(true);
			this->~AnyPartitionedBackupRunningActorState();
			static_cast<AnyPartitionedBackupRunningActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<AnyPartitionedBackupRunningActor*>(this)->actor_wait_state > 0) static_cast<AnyPartitionedBackupRunningActor*>(this)->actor_wait_state = 0;
		static_cast<AnyPartitionedBackupRunningActor*>(this)->ActorCallback< AnyPartitionedBackupRunningActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AnyPartitionedBackupRunningActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("anyPartitionedBackupRunning", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AnyPartitionedBackupRunningActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("anyPartitionedBackupRunning", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< AnyPartitionedBackupRunningActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("anyPartitionedBackupRunning", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AnyPartitionedBackupRunningActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("anyPartitionedBackupRunning", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< AnyPartitionedBackupRunningActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("anyPartitionedBackupRunning", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AnyPartitionedBackupRunningActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("anyPartitionedBackupRunning", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 281 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 286 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	std::vector<Future<Optional<UidAndAbortedFlagT>>> futures;
															#line 292 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	int i;
															#line 295 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Optional<bool> partitionedLog;
															#line 296 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	EBackupState eState;
															#line 2187 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via anyPartitionedBackupRunning()
															#line 281 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class AnyPartitionedBackupRunningActor final : public Actor<bool>, public ActorCallback< AnyPartitionedBackupRunningActor, 0, std::vector<KeyBackedTag> >, public ActorCallback< AnyPartitionedBackupRunningActor, 1, Void >, public ActorCallback< AnyPartitionedBackupRunningActor, 2, Void >, public FastAllocated<AnyPartitionedBackupRunningActor>, public AnyPartitionedBackupRunningActorState<AnyPartitionedBackupRunningActor> {
															#line 2192 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<AnyPartitionedBackupRunningActor>::operator new;
	using FastAllocated<AnyPartitionedBackupRunningActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1845779562877082880UL, 11337952368046647296UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< AnyPartitionedBackupRunningActor, 0, std::vector<KeyBackedTag> >;
friend struct ActorCallback< AnyPartitionedBackupRunningActor, 1, Void >;
friend struct ActorCallback< AnyPartitionedBackupRunningActor, 2, Void >;
															#line 281 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	AnyPartitionedBackupRunningActor(Reference<ReadYourWritesTransaction> const& tr) 
															#line 2211 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<bool>(),
		   AnyPartitionedBackupRunningActorState<AnyPartitionedBackupRunningActor>(tr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("anyPartitionedBackupRunning", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(587540076039375616UL, 15683259992114904576UL);
		ActorExecutionContextHelper __helper(static_cast<AnyPartitionedBackupRunningActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("anyPartitionedBackupRunning");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("anyPartitionedBackupRunning", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< AnyPartitionedBackupRunningActor, 0, std::vector<KeyBackedTag> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< AnyPartitionedBackupRunningActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< AnyPartitionedBackupRunningActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 281 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] Future<bool> anyPartitionedBackupRunning( Reference<ReadYourWritesTransaction> const& tr ) {
															#line 281 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<bool>(new AnyPartitionedBackupRunningActor(tr));
															#line 2246 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 308 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

class RestoreConfig : public KeyBackedTaskConfig {
public:
	RestoreConfig(UID uid = UID()) : KeyBackedTaskConfig(fileRestorePrefixRange.begin, uid) {}
	RestoreConfig(Reference<Task> task) : KeyBackedTaskConfig(fileRestorePrefixRange.begin, task) {}

	KeyBackedProperty<ERestoreState> stateEnum() { return configSpace.pack(__FUNCTION__sr); }
	Future<StringRef> stateText(Reference<ReadYourWritesTransaction> tr) {
		return map(stateEnum().getD(tr),
		           [](ERestoreState s) -> StringRef { return FileBackupAgent::restoreStateText(s); });
	}
	KeyBackedProperty<Key> addPrefix() { return configSpace.pack(__FUNCTION__sr); }
	KeyBackedProperty<Key> removePrefix() { return configSpace.pack(__FUNCTION__sr); }
	KeyBackedProperty<bool> onlyApplyMutationLogs() { return configSpace.pack(__FUNCTION__sr); }
	KeyBackedProperty<bool> inconsistentSnapshotOnly() { return configSpace.pack(__FUNCTION__sr); }
	KeyBackedProperty<bool> unlockDBAfterRestore() { return configSpace.pack(__FUNCTION__sr); }
	KeyBackedProperty<bool> transformPartitionedLog() { return configSpace.pack(__FUNCTION__sr); }
	// BulkLoad integration properties
	KeyBackedProperty<bool> useRangeFileRestore() { return configSpace.pack(__FUNCTION__sr); }
	KeyBackedProperty<std::string> bulkDumpJobId() { return configSpace.pack(__FUNCTION__sr); }
	KeyBackedProperty<Key> bulkLoadCompleteFuture() { return configSpace.pack(__FUNCTION__sr); }
	KeyBackedProperty<bool> bulkLoadComplete() { return configSpace.pack(__FUNCTION__sr); }
	// Original BulkLoad mode before restore enabled it - used to restore state after completion/crash
	KeyBackedProperty<int> originalBulkLoadMode() { return configSpace.pack(__FUNCTION__sr); }
	// XXX: Remove restoreRange() once it is safe to remove. It has been changed to restoreRanges
	KeyBackedProperty<KeyRange> restoreRange() { return configSpace.pack(__FUNCTION__sr); }
	// XXX: Changed to restoreRangeSet. It can be removed.
	KeyBackedProperty<std::vector<KeyRange>> restoreRanges() { return configSpace.pack(__FUNCTION__sr); }
	KeyBackedSet<KeyRange> restoreRangeSet() { return configSpace.pack(__FUNCTION__sr); }
	KeyBackedProperty<Key> batchFuture() { return configSpace.pack(__FUNCTION__sr); }
	KeyBackedProperty<Version> beginVersion() { return configSpace.pack(__FUNCTION__sr); }
	KeyBackedProperty<Version> restoreVersion() { return configSpace.pack(__FUNCTION__sr); }
	KeyBackedProperty<Version> firstConsistentVersion() { return configSpace.pack(__FUNCTION__sr); }

	KeyBackedProperty<Reference<IBackupContainer>> sourceContainer() { return configSpace.pack(__FUNCTION__sr); }
	// Get the source container as a bare URL, without creating a container instance
	KeyBackedProperty<Value> sourceContainerURL() { return configSpace.pack("sourceContainer"_sr); }

	// Total bytes written by all log and range restore tasks.
	KeyBackedBinaryValue<int64_t> bytesWritten() { return configSpace.pack(__FUNCTION__sr); }
	// File blocks that have had tasks created for them by the Dispatch task
	KeyBackedBinaryValue<int64_t> filesBlocksDispatched() { return configSpace.pack(__FUNCTION__sr); }
	// File blocks whose tasks have finished
	KeyBackedBinaryValue<int64_t> fileBlocksFinished() { return configSpace.pack(__FUNCTION__sr); }
	// Total number of files in the fileMap
	KeyBackedBinaryValue<int64_t> fileCount() { return configSpace.pack(__FUNCTION__sr); }
	// Total number of file blocks in the fileMap
	KeyBackedBinaryValue<int64_t> fileBlockCount() { return configSpace.pack(__FUNCTION__sr); }

	Future<std::vector<KeyRange>> getRestoreRangesOrDefault(Reference<ReadYourWritesTransaction> tr) {
		return getRestoreRangesOrDefault_impl(this, tr);
	}

																#line 2303 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via getRestoreRangesOrDefault_impl()
															#line 361 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class GetRestoreRangesOrDefault_implActor>
															#line 361 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class GetRestoreRangesOrDefault_implActorState {
															#line 2309 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 361 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	GetRestoreRangesOrDefault_implActorState(RestoreConfig* const& self,Reference<ReadYourWritesTransaction> const& tr) 
															#line 361 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 361 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : self(self),
															#line 361 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   tr(tr),
															#line 363 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   ranges(),
															#line 364 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   batchSize(BUGGIFY ? 1 : CLIENT_KNOBS->RESTORE_RANGES_READ_BATCH),
															#line 365 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   begin(),
															#line 366 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   arena()
															#line 2326 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getRestoreRangesOrDefault_impl", reinterpret_cast<unsigned long>(this));

	}
	~GetRestoreRangesOrDefault_implActorState() 
	{
		fdb_probe_actor_destroy("getRestoreRangesOrDefault_impl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 367 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			;
															#line 2341 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetRestoreRangesOrDefault_implActorState();
		static_cast<GetRestoreRangesOrDefault_implActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 379 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (ranges.empty())
															#line 2364 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 380 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<std::vector<KeyRange>> __when_expr_1 = self->restoreRanges().getD(tr);
															#line 380 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<GetRestoreRangesOrDefault_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2370 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<GetRestoreRangesOrDefault_implActor*>(this)->actor_wait_state = 2;
															#line 380 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetRestoreRangesOrDefault_implActor, 1, std::vector<KeyRange> >*>(static_cast<GetRestoreRangesOrDefault_implActor*>(this)));
															#line 2375 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 368 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<KeyBackedSet<KeyRange>::RangeResultType> __when_expr_0 = self->restoreRangeSet().getRange(tr, begin, {}, batchSize);
															#line 368 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<GetRestoreRangesOrDefault_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2398 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<GetRestoreRangesOrDefault_implActor*>(this)->actor_wait_state = 1;
															#line 368 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetRestoreRangesOrDefault_implActor, 0, KeyBackedSet<KeyRange>::RangeResultType >*>(static_cast<GetRestoreRangesOrDefault_implActor*>(this)));
															#line 2403 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(KeyBackedSet<KeyRange>::RangeResultType const& rangeResult,int loopDepth) 
	{
															#line 370 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		ranges.insert(ranges.end(), rangeResult.results.begin(), rangeResult.results.end());
															#line 371 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!rangeResult.more)
															#line 2427 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 374 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		ASSERT(!rangeResult.results.empty());
															#line 375 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		begin = KeyRangeRef(KeyRef(arena, ranges.back().begin), keyAfter(ranges.back().end, arena));
															#line 2435 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(KeyBackedSet<KeyRange>::RangeResultType && rangeResult,int loopDepth) 
	{
															#line 370 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		ranges.insert(ranges.end(), rangeResult.results.begin(), rangeResult.results.end());
															#line 371 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!rangeResult.more)
															#line 2446 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 374 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		ASSERT(!rangeResult.results.empty());
															#line 375 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		begin = KeyRangeRef(KeyRef(arena, ranges.back().begin), keyAfter(ranges.back().end, arena));
															#line 2454 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(KeyBackedSet<KeyRange>::RangeResultType const& rangeResult,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(rangeResult, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(KeyBackedSet<KeyRange>::RangeResultType && rangeResult,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(rangeResult), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetRestoreRangesOrDefault_implActor*>(this)->actor_wait_state > 0) static_cast<GetRestoreRangesOrDefault_implActor*>(this)->actor_wait_state = 0;
		static_cast<GetRestoreRangesOrDefault_implActor*>(this)->ActorCallback< GetRestoreRangesOrDefault_implActor, 0, KeyBackedSet<KeyRange>::RangeResultType >::remove();

	}
	void a_callback_fire(ActorCallback< GetRestoreRangesOrDefault_implActor, 0, KeyBackedSet<KeyRange>::RangeResultType >*,KeyBackedSet<KeyRange>::RangeResultType const& value) 
	{
		fdb_probe_actor_enter("getRestoreRangesOrDefault_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRestoreRangesOrDefault_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRestoreRangesOrDefault_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetRestoreRangesOrDefault_implActor, 0, KeyBackedSet<KeyRange>::RangeResultType >*,KeyBackedSet<KeyRange>::RangeResultType && value) 
	{
		fdb_probe_actor_enter("getRestoreRangesOrDefault_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRestoreRangesOrDefault_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRestoreRangesOrDefault_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetRestoreRangesOrDefault_implActor, 0, KeyBackedSet<KeyRange>::RangeResultType >*,Error err) 
	{
		fdb_probe_actor_enter("getRestoreRangesOrDefault_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRestoreRangesOrDefault_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRestoreRangesOrDefault_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 387 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<GetRestoreRangesOrDefault_implActor*>(this)->SAV<std::vector<KeyRange>>::futures) { (void)(ranges); this->~GetRestoreRangesOrDefault_implActorState(); static_cast<GetRestoreRangesOrDefault_implActor*>(this)->destroy(); return 0; }
															#line 2538 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<GetRestoreRangesOrDefault_implActor*>(this)->SAV< std::vector<KeyRange> >::value()) std::vector<KeyRange>(std::move(ranges)); // state_var_RVO
		this->~GetRestoreRangesOrDefault_implActorState();
		static_cast<GetRestoreRangesOrDefault_implActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(std::vector<KeyRange> const& _ranges,int loopDepth) 
	{
															#line 381 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		ranges = _ranges;
															#line 382 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (ranges.empty())
															#line 2552 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 383 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<KeyRange> __when_expr_2 = self->restoreRange().getD(tr);
															#line 383 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<GetRestoreRangesOrDefault_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2558 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
			static_cast<GetRestoreRangesOrDefault_implActor*>(this)->actor_wait_state = 3;
															#line 383 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetRestoreRangesOrDefault_implActor, 2, KeyRange >*>(static_cast<GetRestoreRangesOrDefault_implActor*>(this)));
															#line 2563 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3(std::vector<KeyRange> && _ranges,int loopDepth) 
	{
															#line 381 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		ranges = _ranges;
															#line 382 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (ranges.empty())
															#line 2579 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 383 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<KeyRange> __when_expr_2 = self->restoreRange().getD(tr);
															#line 383 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<GetRestoreRangesOrDefault_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2585 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
			static_cast<GetRestoreRangesOrDefault_implActor*>(this)->actor_wait_state = 3;
															#line 383 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetRestoreRangesOrDefault_implActor, 2, KeyRange >*>(static_cast<GetRestoreRangesOrDefault_implActor*>(this)));
															#line 2590 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1when1(std::vector<KeyRange> const& _ranges,int loopDepth) 
	{
		loopDepth = a_body1cont3(_ranges, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(std::vector<KeyRange> && _ranges,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_ranges), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetRestoreRangesOrDefault_implActor*>(this)->actor_wait_state > 0) static_cast<GetRestoreRangesOrDefault_implActor*>(this)->actor_wait_state = 0;
		static_cast<GetRestoreRangesOrDefault_implActor*>(this)->ActorCallback< GetRestoreRangesOrDefault_implActor, 1, std::vector<KeyRange> >::remove();

	}
	void a_callback_fire(ActorCallback< GetRestoreRangesOrDefault_implActor, 1, std::vector<KeyRange> >*,std::vector<KeyRange> const& value) 
	{
		fdb_probe_actor_enter("getRestoreRangesOrDefault_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRestoreRangesOrDefault_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRestoreRangesOrDefault_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetRestoreRangesOrDefault_implActor, 1, std::vector<KeyRange> >*,std::vector<KeyRange> && value) 
	{
		fdb_probe_actor_enter("getRestoreRangesOrDefault_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRestoreRangesOrDefault_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRestoreRangesOrDefault_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetRestoreRangesOrDefault_implActor, 1, std::vector<KeyRange> >*,Error err) 
	{
		fdb_probe_actor_enter("getRestoreRangesOrDefault_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRestoreRangesOrDefault_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRestoreRangesOrDefault_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(KeyRange const& range,int loopDepth) 
	{
															#line 384 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		ranges.push_back(range);
															#line 2685 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(KeyRange && range,int loopDepth) 
	{
															#line 384 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		ranges.push_back(range);
															#line 2694 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(KeyRange const& range,int loopDepth) 
	{
		loopDepth = a_body1cont5(range, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(KeyRange && range,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(range), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GetRestoreRangesOrDefault_implActor*>(this)->actor_wait_state > 0) static_cast<GetRestoreRangesOrDefault_implActor*>(this)->actor_wait_state = 0;
		static_cast<GetRestoreRangesOrDefault_implActor*>(this)->ActorCallback< GetRestoreRangesOrDefault_implActor, 2, KeyRange >::remove();

	}
	void a_callback_fire(ActorCallback< GetRestoreRangesOrDefault_implActor, 2, KeyRange >*,KeyRange const& value) 
	{
		fdb_probe_actor_enter("getRestoreRangesOrDefault_impl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRestoreRangesOrDefault_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRestoreRangesOrDefault_impl", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetRestoreRangesOrDefault_implActor, 2, KeyRange >*,KeyRange && value) 
	{
		fdb_probe_actor_enter("getRestoreRangesOrDefault_impl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRestoreRangesOrDefault_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRestoreRangesOrDefault_impl", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetRestoreRangesOrDefault_implActor, 2, KeyRange >*,Error err) 
	{
		fdb_probe_actor_enter("getRestoreRangesOrDefault_impl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRestoreRangesOrDefault_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRestoreRangesOrDefault_impl", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 361 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	RestoreConfig* self;
															#line 361 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 363 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	std::vector<KeyRange> ranges;
															#line 364 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	int batchSize;
															#line 365 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Optional<KeyRange> begin;
															#line 366 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Arena arena;
															#line 2786 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getRestoreRangesOrDefault_impl()
															#line 361 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class GetRestoreRangesOrDefault_implActor final : public Actor<std::vector<KeyRange>>, public ActorCallback< GetRestoreRangesOrDefault_implActor, 0, KeyBackedSet<KeyRange>::RangeResultType >, public ActorCallback< GetRestoreRangesOrDefault_implActor, 1, std::vector<KeyRange> >, public ActorCallback< GetRestoreRangesOrDefault_implActor, 2, KeyRange >, public FastAllocated<GetRestoreRangesOrDefault_implActor>, public GetRestoreRangesOrDefault_implActorState<GetRestoreRangesOrDefault_implActor> {
															#line 2791 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetRestoreRangesOrDefault_implActor>::operator new;
	using FastAllocated<GetRestoreRangesOrDefault_implActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17527814407178649856UL, 13932761222296879360UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<KeyRange>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetRestoreRangesOrDefault_implActor, 0, KeyBackedSet<KeyRange>::RangeResultType >;
friend struct ActorCallback< GetRestoreRangesOrDefault_implActor, 1, std::vector<KeyRange> >;
friend struct ActorCallback< GetRestoreRangesOrDefault_implActor, 2, KeyRange >;
															#line 361 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	GetRestoreRangesOrDefault_implActor(RestoreConfig* const& self,Reference<ReadYourWritesTransaction> const& tr) 
															#line 2810 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<std::vector<KeyRange>>(),
		   GetRestoreRangesOrDefault_implActorState<GetRestoreRangesOrDefault_implActor>(self, tr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getRestoreRangesOrDefault_impl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7781314247607341824UL, 4200768842030992896UL);
		ActorExecutionContextHelper __helper(static_cast<GetRestoreRangesOrDefault_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getRestoreRangesOrDefault_impl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getRestoreRangesOrDefault_impl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetRestoreRangesOrDefault_implActor, 0, KeyBackedSet<KeyRange>::RangeResultType >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetRestoreRangesOrDefault_implActor, 1, std::vector<KeyRange> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GetRestoreRangesOrDefault_implActor, 2, KeyRange >*)0, actor_cancelled()); break;
		}

	}
};
															#line 361 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] static Future<std::vector<KeyRange>> getRestoreRangesOrDefault_impl( RestoreConfig* const& self, Reference<ReadYourWritesTransaction> const& tr ) {
															#line 361 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<std::vector<KeyRange>>(new GetRestoreRangesOrDefault_implActor(self, tr));
															#line 2844 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 389 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

	// Describes a file to load blocks from during restore.  Ordered by version and then fileName to enable
	// incrementally advancing through the map, saving the version and path of the next starting point.
	struct RestoreFile {
		Version version; // this is beginVersion, not endVersion
		std::string fileName;
		bool isRange{ false }; // false for log file
		int64_t blockSize{ 0 };
		int64_t fileSize{ 0 };
		Version endVersion{ ::invalidVersion }; // not meaningful for range files
		int64_t tagId = -1; // only meaningful to log files, Log router tag. Non-negative for new backup format.
		int64_t totalTags = -1; // only meaningful to log files, Total number of log router tags.

		Tuple pack() const {
			return Tuple::makeTuple(
			    version, fileName, (int64_t)isRange, fileSize, blockSize, endVersion, tagId, totalTags);
		}
		static RestoreFile unpack(Tuple const& t) {
			RestoreFile r;
			int i = 0;
			r.version = t.getInt(i++);
			r.fileName = t.getString(i++).toString();
			r.isRange = t.getInt(i++) != 0;
			r.fileSize = t.getInt(i++);
			r.blockSize = t.getInt(i++);
			r.endVersion = t.getInt(i++);
			r.tagId = t.getInt(i++);
			r.totalTags = t.getInt(i++);
			return r;
		}
	};

	typedef KeyBackedSet<RestoreFile> FileSetT;
	FileSetT fileSet() { return configSpace.pack(__FUNCTION__sr); }

	FileSetT logFileSet() { return configSpace.pack(__FUNCTION__sr); }
	FileSetT rangeFileSet() { return configSpace.pack(__FUNCTION__sr); }

	Future<bool> isRunnable(Reference<ReadYourWritesTransaction> tr) {
		return map(stateEnum().getD(tr), [](ERestoreState s) -> bool {
			return s != ERestoreState::ABORTED && s != ERestoreState::COMPLETED && s != ERestoreState::UNINITIALIZED;
		});
	}

	Future<Void> logError(Database cx, Error e, std::string const& details, void* taskInstance = nullptr) {
		if (!uid.isValid()) {
			TraceEvent(SevError, "FileRestoreErrorNoUID").error(e).detail("Description", details);
			return Void();
		}
		TraceEvent t(SevWarn, "FileRestoreError");
		t.error(e)
		    .detail("RestoreUID", uid)
		    .detail("Description", details)
		    .detail("TaskInstance", (uint64_t)taskInstance);
		// key_not_found could happen
		if (e.code() == error_code_key_not_found)
			t.backtrace();

		return updateErrorInfo(cx, e, details);
	}

	Key mutationLogPrefix() { return uidPrefixKey(applyLogKeys.begin, uid); }

	Key applyMutationsMapPrefix() { return uidPrefixKey(applyMutationsKeyVersionMapRange.begin, uid); }

																#line 2913 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via getApplyVersionLag_impl()
															#line 454 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class GetApplyVersionLag_implActor>
															#line 454 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class GetApplyVersionLag_implActorState {
															#line 2919 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 454 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	GetApplyVersionLag_implActorState(Reference<ReadYourWritesTransaction> const& tr,UID const& uid) 
															#line 454 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 454 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : tr(tr),
															#line 454 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   uid(uid),
															#line 455 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   beginVal(tr->get(uidPrefixKey(applyMutationsBeginRange.begin, uid), Snapshot::True)),
															#line 457 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   endVal(tr->get(uidPrefixKey(applyMutationsEndRange.begin, uid), Snapshot::True))
															#line 2932 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getApplyVersionLag_impl", reinterpret_cast<unsigned long>(this));

	}
	~GetApplyVersionLag_implActorState() 
	{
		fdb_probe_actor_destroy("getApplyVersionLag_impl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 458 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_0 = success(beginVal) && success(endVal);
															#line 458 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<GetApplyVersionLag_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2949 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetApplyVersionLag_implActor*>(this)->actor_wait_state = 1;
															#line 458 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetApplyVersionLag_implActor, 0, Void >*>(static_cast<GetApplyVersionLag_implActor*>(this)));
															#line 2954 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetApplyVersionLag_implActorState();
		static_cast<GetApplyVersionLag_implActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 460 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!beginVal.get().present() || !endVal.get().present())
															#line 2977 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 461 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!static_cast<GetApplyVersionLag_implActor*>(this)->SAV<int64_t>::futures) { (void)(0); this->~GetApplyVersionLag_implActorState(); static_cast<GetApplyVersionLag_implActor*>(this)->destroy(); return 0; }
															#line 2981 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			new (&static_cast<GetApplyVersionLag_implActor*>(this)->SAV< int64_t >::value()) int64_t(0);
			this->~GetApplyVersionLag_implActorState();
			static_cast<GetApplyVersionLag_implActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 463 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		Version beginVersion = BinaryReader::fromStringRef<Version>(beginVal.get().get(), Unversioned());
															#line 464 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		Version endVersion = BinaryReader::fromStringRef<Version>(endVal.get().get(), Unversioned());
															#line 465 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<GetApplyVersionLag_implActor*>(this)->SAV<int64_t>::futures) { (void)(endVersion - beginVersion); this->~GetApplyVersionLag_implActorState(); static_cast<GetApplyVersionLag_implActor*>(this)->destroy(); return 0; }
															#line 2993 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<GetApplyVersionLag_implActor*>(this)->SAV< int64_t >::value()) int64_t(endVersion - beginVersion);
		this->~GetApplyVersionLag_implActorState();
		static_cast<GetApplyVersionLag_implActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 460 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!beginVal.get().present() || !endVal.get().present())
															#line 3005 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 461 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!static_cast<GetApplyVersionLag_implActor*>(this)->SAV<int64_t>::futures) { (void)(0); this->~GetApplyVersionLag_implActorState(); static_cast<GetApplyVersionLag_implActor*>(this)->destroy(); return 0; }
															#line 3009 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			new (&static_cast<GetApplyVersionLag_implActor*>(this)->SAV< int64_t >::value()) int64_t(0);
			this->~GetApplyVersionLag_implActorState();
			static_cast<GetApplyVersionLag_implActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 463 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		Version beginVersion = BinaryReader::fromStringRef<Version>(beginVal.get().get(), Unversioned());
															#line 464 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		Version endVersion = BinaryReader::fromStringRef<Version>(endVal.get().get(), Unversioned());
															#line 465 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<GetApplyVersionLag_implActor*>(this)->SAV<int64_t>::futures) { (void)(endVersion - beginVersion); this->~GetApplyVersionLag_implActorState(); static_cast<GetApplyVersionLag_implActor*>(this)->destroy(); return 0; }
															#line 3021 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<GetApplyVersionLag_implActor*>(this)->SAV< int64_t >::value()) int64_t(endVersion - beginVersion);
		this->~GetApplyVersionLag_implActorState();
		static_cast<GetApplyVersionLag_implActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetApplyVersionLag_implActor*>(this)->actor_wait_state > 0) static_cast<GetApplyVersionLag_implActor*>(this)->actor_wait_state = 0;
		static_cast<GetApplyVersionLag_implActor*>(this)->ActorCallback< GetApplyVersionLag_implActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetApplyVersionLag_implActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getApplyVersionLag_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetApplyVersionLag_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getApplyVersionLag_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetApplyVersionLag_implActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getApplyVersionLag_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetApplyVersionLag_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getApplyVersionLag_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetApplyVersionLag_implActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getApplyVersionLag_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetApplyVersionLag_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getApplyVersionLag_impl", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 454 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 454 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	UID uid;
															#line 455 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Future<Optional<Value>> beginVal;
															#line 457 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Future<Optional<Value>> endVal;
															#line 3112 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getApplyVersionLag_impl()
															#line 454 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class GetApplyVersionLag_implActor final : public Actor<int64_t>, public ActorCallback< GetApplyVersionLag_implActor, 0, Void >, public FastAllocated<GetApplyVersionLag_implActor>, public GetApplyVersionLag_implActorState<GetApplyVersionLag_implActor> {
															#line 3117 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetApplyVersionLag_implActor>::operator new;
	using FastAllocated<GetApplyVersionLag_implActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7783619256591580160UL, 14605957099953640704UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<int64_t>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetApplyVersionLag_implActor, 0, Void >;
															#line 454 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	GetApplyVersionLag_implActor(Reference<ReadYourWritesTransaction> const& tr,UID const& uid) 
															#line 3134 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<int64_t>(),
		   GetApplyVersionLag_implActorState<GetApplyVersionLag_implActor>(tr, uid),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getApplyVersionLag_impl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9614200584100791808UL, 10485171078912906496UL);
		ActorExecutionContextHelper __helper(static_cast<GetApplyVersionLag_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getApplyVersionLag_impl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getApplyVersionLag_impl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetApplyVersionLag_implActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 454 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] static Future<int64_t> getApplyVersionLag_impl( Reference<ReadYourWritesTransaction> const& tr, UID const& uid ) {
															#line 454 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<int64_t>(new GetApplyVersionLag_implActor(tr, uid));
															#line 3166 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 467 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

	Future<int64_t> getApplyVersionLag(Reference<ReadYourWritesTransaction> tr) {
		return getApplyVersionLag_impl(tr, uid);
	}

	void initApplyMutations(Reference<ReadYourWritesTransaction> tr,
	                        Key addPrefix,
	                        Key removePrefix,
	                        OnlyApplyMutationLogs onlyApplyMutationLogs) {
		// Set these because they have to match the applyMutations values.
		this->addPrefix().set(tr, addPrefix);
		this->removePrefix().set(tr, removePrefix);

		clearApplyMutationsKeys(tr);

		// Initialize add/remove prefix, range version map count and set the map's start key to InvalidVersion
		tr->set(uidPrefixKey(applyMutationsAddPrefixRange.begin, uid), addPrefix);
		tr->set(uidPrefixKey(applyMutationsRemovePrefixRange.begin, uid), removePrefix);

		int64_t startCount = 0;
		tr->set(uidPrefixKey(applyMutationsKeyVersionCountRange.begin, uid), StringRef((uint8_t*)&startCount, 8));
		Key mapStart = uidPrefixKey(applyMutationsKeyVersionMapRange.begin, uid);
		tr->set(mapStart, BinaryWriter::toValue<Version>(invalidVersion, Unversioned()));
	}

	void clearApplyMutationsKeys(Reference<ReadYourWritesTransaction> tr) {
		tr->setOption(FDBTransactionOptions::COMMIT_ON_FIRST_PROXY);

		// Clear add/remove prefix keys
		tr->clear(uidPrefixKey(applyMutationsAddPrefixRange.begin, uid));
		tr->clear(uidPrefixKey(applyMutationsRemovePrefixRange.begin, uid));

		// Clear range version map and count key
		tr->clear(uidPrefixKey(applyMutationsKeyVersionCountRange.begin, uid));
		Key mapStart = uidPrefixKey(applyMutationsKeyVersionMapRange.begin, uid);
		tr->clear(KeyRangeRef(mapStart, strinc(mapStart)));

		// Clear any loaded mutations that have not yet been applied
		Key mutationPrefix = mutationLogPrefix();
		tr->clear(KeyRangeRef(mutationPrefix, strinc(mutationPrefix)));

		// Clear end and begin versions (intentionally in this order)
		tr->clear(uidPrefixKey(applyMutationsEndRange.begin, uid));
		tr->clear(uidPrefixKey(applyMutationsBeginRange.begin, uid));
	}

	void setApplyBeginVersion(Reference<ReadYourWritesTransaction> tr, Version ver) {
		tr->set(uidPrefixKey(applyMutationsBeginRange.begin, uid), BinaryWriter::toValue(ver, Unversioned()));
	}

	Future<Version> getApplyBeginVersion(Reference<ReadYourWritesTransaction> tr) {
		return map(tr->get(uidPrefixKey(applyMutationsBeginRange.begin, uid)),
		           [=](Optional<Value> const& value) -> Version {
			           return value.present() ? BinaryReader::fromStringRef<Version>(value.get(), Unversioned()) : 0;
		           });
	}

	void setApplyEndVersion(Reference<ReadYourWritesTransaction> tr, Version ver) {
		tr->set(uidPrefixKey(applyMutationsEndRange.begin, uid), BinaryWriter::toValue(ver, Unversioned()));
	}

	Future<Version> getApplyEndVersion(Reference<ReadYourWritesTransaction> tr) {
		return map(tr->get(uidPrefixKey(applyMutationsEndRange.begin, uid)),
		           [=](Optional<Value> const& value) -> Version {
			           return value.present() ? BinaryReader::fromStringRef<Version>(value.get(), Unversioned()) : 0;
		           });
	}

																#line 3238 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via getCurrentVersion_impl()
															#line 535 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class GetCurrentVersion_implActor>
															#line 535 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class GetCurrentVersion_implActorState {
															#line 3244 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 535 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	GetCurrentVersion_implActorState(RestoreConfig* const& self,Reference<ReadYourWritesTransaction> const& tr) 
															#line 535 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 535 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : self(self),
															#line 535 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   tr(tr)
															#line 3253 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getCurrentVersion_impl", reinterpret_cast<unsigned long>(this));

	}
	~GetCurrentVersion_implActorState() 
	{
		fdb_probe_actor_destroy("getCurrentVersion_impl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 536 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<ERestoreState> __when_expr_0 = self->stateEnum().getD(tr);
															#line 536 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<GetCurrentVersion_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3270 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetCurrentVersion_implActor*>(this)->actor_wait_state = 1;
															#line 536 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetCurrentVersion_implActor, 0, ERestoreState >*>(static_cast<GetCurrentVersion_implActor*>(this)));
															#line 3275 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetCurrentVersion_implActorState();
		static_cast<GetCurrentVersion_implActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 537 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		version = -1;
															#line 538 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (status == ERestoreState::RUNNING)
															#line 3300 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 539 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_1 = store(version, self->getApplyBeginVersion(tr));
															#line 539 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<GetCurrentVersion_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3306 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<GetCurrentVersion_implActor*>(this)->actor_wait_state = 2;
															#line 539 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetCurrentVersion_implActor, 1, Void >*>(static_cast<GetCurrentVersion_implActor*>(this)));
															#line 3311 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
															#line 540 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (status == ERestoreState::COMPLETED)
															#line 3318 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			{
															#line 541 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				StrictFuture<Void> __when_expr_2 = store(version, self->restoreVersion().getD(tr));
															#line 541 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				if (static_cast<GetCurrentVersion_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3324 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
				if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1when2(__when_expr_2.get(), loopDepth); };
				static_cast<GetCurrentVersion_implActor*>(this)->actor_wait_state = 3;
															#line 541 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetCurrentVersion_implActor, 2, Void >*>(static_cast<GetCurrentVersion_implActor*>(this)));
															#line 3329 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont4(loopDepth);
			}
		}

		return loopDepth;
	}
	int a_body1when1(ERestoreState const& __status,int loopDepth) 
	{
															#line 536 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		status = __status;
															#line 3344 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(ERestoreState && __status,int loopDepth) 
	{
		status = std::move(__status);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetCurrentVersion_implActor*>(this)->actor_wait_state > 0) static_cast<GetCurrentVersion_implActor*>(this)->actor_wait_state = 0;
		static_cast<GetCurrentVersion_implActor*>(this)->ActorCallback< GetCurrentVersion_implActor, 0, ERestoreState >::remove();

	}
	void a_callback_fire(ActorCallback< GetCurrentVersion_implActor, 0, ERestoreState >*,ERestoreState const& value) 
	{
		fdb_probe_actor_enter("getCurrentVersion_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetCurrentVersion_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCurrentVersion_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetCurrentVersion_implActor, 0, ERestoreState >*,ERestoreState && value) 
	{
		fdb_probe_actor_enter("getCurrentVersion_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetCurrentVersion_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCurrentVersion_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetCurrentVersion_implActor, 0, ERestoreState >*,Error err) 
	{
		fdb_probe_actor_enter("getCurrentVersion_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetCurrentVersion_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCurrentVersion_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 543 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<GetCurrentVersion_implActor*>(this)->SAV<Version>::futures) { (void)(version); this->~GetCurrentVersion_implActorState(); static_cast<GetCurrentVersion_implActor*>(this)->destroy(); return 0; }
															#line 3423 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<GetCurrentVersion_implActor*>(this)->SAV< Version >::value()) Version(std::move(version)); // state_var_RVO
		this->~GetCurrentVersion_implActorState();
		static_cast<GetCurrentVersion_implActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetCurrentVersion_implActor*>(this)->actor_wait_state > 0) static_cast<GetCurrentVersion_implActor*>(this)->actor_wait_state = 0;
		static_cast<GetCurrentVersion_implActor*>(this)->ActorCallback< GetCurrentVersion_implActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetCurrentVersion_implActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getCurrentVersion_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetCurrentVersion_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCurrentVersion_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetCurrentVersion_implActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getCurrentVersion_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetCurrentVersion_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCurrentVersion_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetCurrentVersion_implActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getCurrentVersion_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetCurrentVersion_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCurrentVersion_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GetCurrentVersion_implActor*>(this)->actor_wait_state > 0) static_cast<GetCurrentVersion_implActor*>(this)->actor_wait_state = 0;
		static_cast<GetCurrentVersion_implActor*>(this)->ActorCallback< GetCurrentVersion_implActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetCurrentVersion_implActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getCurrentVersion_impl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetCurrentVersion_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCurrentVersion_impl", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetCurrentVersion_implActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getCurrentVersion_impl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetCurrentVersion_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCurrentVersion_impl", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetCurrentVersion_implActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getCurrentVersion_impl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetCurrentVersion_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCurrentVersion_impl", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 535 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	RestoreConfig* self;
															#line 535 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 536 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	ERestoreState status;
															#line 537 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Version version;
															#line 3619 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getCurrentVersion_impl()
															#line 535 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class GetCurrentVersion_implActor final : public Actor<Version>, public ActorCallback< GetCurrentVersion_implActor, 0, ERestoreState >, public ActorCallback< GetCurrentVersion_implActor, 1, Void >, public ActorCallback< GetCurrentVersion_implActor, 2, Void >, public FastAllocated<GetCurrentVersion_implActor>, public GetCurrentVersion_implActorState<GetCurrentVersion_implActor> {
															#line 3624 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetCurrentVersion_implActor>::operator new;
	using FastAllocated<GetCurrentVersion_implActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12690589243189620224UL, 16295052239498680320UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Version>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetCurrentVersion_implActor, 0, ERestoreState >;
friend struct ActorCallback< GetCurrentVersion_implActor, 1, Void >;
friend struct ActorCallback< GetCurrentVersion_implActor, 2, Void >;
															#line 535 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	GetCurrentVersion_implActor(RestoreConfig* const& self,Reference<ReadYourWritesTransaction> const& tr) 
															#line 3643 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<Version>(),
		   GetCurrentVersion_implActorState<GetCurrentVersion_implActor>(self, tr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getCurrentVersion_impl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6492461230199787776UL, 8628143503146865408UL);
		ActorExecutionContextHelper __helper(static_cast<GetCurrentVersion_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getCurrentVersion_impl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getCurrentVersion_impl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetCurrentVersion_implActor, 0, ERestoreState >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetCurrentVersion_implActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GetCurrentVersion_implActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 535 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] static Future<Version> getCurrentVersion_impl( RestoreConfig* const& self, Reference<ReadYourWritesTransaction> const& tr ) {
															#line 535 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Version>(new GetCurrentVersion_implActor(self, tr));
															#line 3677 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 545 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

	Future<Version> getCurrentVersion(Reference<ReadYourWritesTransaction> tr) {
		return getCurrentVersion_impl(this, tr);
	}

																#line 3686 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
[[nodiscard]] static Future<std::string> getProgress_impl( RestoreConfig const& restore, Reference<ReadYourWritesTransaction> const& tr );
template <class> friend class RestoreConfig_GetProgress_implActorState;

#line 551 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Future<std::string> getProgress(Reference<ReadYourWritesTransaction> tr) { return getProgress_impl(*this, tr); }

																#line 3693 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
[[nodiscard]] static Future<std::string> getFullStatus_impl( RestoreConfig const& restore, Reference<ReadYourWritesTransaction> const& tr );
template <class> friend class RestoreConfig_GetFullStatus_implActorState;

#line 554 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Future<std::string> getFullStatus(Reference<ReadYourWritesTransaction> tr) { return getFullStatus_impl(*this, tr); }
};

typedef RestoreConfig::RestoreFile RestoreFile;

															#line 3703 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via getProgress_impl()
															#line 559 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class RestoreConfig_GetProgress_implActor>
															#line 559 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class RestoreConfig_GetProgress_implActorState {
															#line 3709 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 559 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	RestoreConfig_GetProgress_implActorState(RestoreConfig const& restore,Reference<ReadYourWritesTransaction> const& tr) 
															#line 559 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 559 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : restore(restore),
															#line 559 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   tr(tr)
															#line 3718 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getProgress_impl", reinterpret_cast<unsigned long>(this));

	}
	~RestoreConfig_GetProgress_implActorState() 
	{
		fdb_probe_actor_destroy("getProgress_impl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 561 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 562 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 564 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			fileCount = restore.fileCount().getD(tr);
															#line 565 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			fileBlockCount = restore.fileBlockCount().getD(tr);
															#line 566 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			fileBlocksDispatched = restore.filesBlocksDispatched().getD(tr);
															#line 567 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			fileBlocksFinished = restore.fileBlocksFinished().getD(tr);
															#line 568 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			bytesWritten = restore.bytesWritten().getD(tr);
															#line 569 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			status = restore.stateText(tr);
															#line 570 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			currentVersion = restore.getCurrentVersion(tr);
															#line 571 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			lag = restore.getApplyVersionLag(tr);
															#line 572 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			firstConsistentVersion = restore.firstConsistentVersion().getD(tr);
															#line 573 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tag = restore.tag().getD(tr);
															#line 574 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			lastError = restore.lastError().getD(tr);
															#line 577 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			uid = restore.getUid();
															#line 578 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_0 = success(fileCount) && success(fileBlockCount) && success(fileBlocksDispatched) && success(fileBlocksFinished) && success(bytesWritten) && success(status) && success(currentVersion) && success(lag) && success(firstConsistentVersion) && success(tag) && success(lastError);
															#line 578 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<RestoreConfig_GetProgress_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3763 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RestoreConfig_GetProgress_implActor*>(this)->actor_wait_state = 1;
															#line 578 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RestoreConfig_GetProgress_implActor, 0, Void >*>(static_cast<RestoreConfig_GetProgress_implActor*>(this)));
															#line 3768 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RestoreConfig_GetProgress_implActorState();
		static_cast<RestoreConfig_GetProgress_implActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 582 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		std::string errstr = "None";
															#line 583 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (lastError.get().second != 0)
															#line 3793 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 584 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			errstr = format("'%s' %" PRId64 "s ago.\n", lastError.get().first.c_str(), (tr->getReadVersion().get() - lastError.get().second) / CLIENT_KNOBS->CORE_VERSIONSPERSECOND);
															#line 3797 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
															#line 588 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		TraceEvent("FileRestoreProgress") .detail("RestoreUID", uid) .detail("Tag", tag.get()) .detail("State", status.get().toString()) .detail("FileCount", fileCount.get()) .detail("FileBlocksFinished", fileBlocksFinished.get()) .detail("FileBlocksTotal", fileBlockCount.get()) .detail("FileBlocksInProgress", fileBlocksDispatched.get() - fileBlocksFinished.get()) .detail("BytesWritten", bytesWritten.get()) .detail("CurrentVersion", currentVersion.get()) .detail("FirstConsistentVersion", firstConsistentVersion.get()) .detail("ApplyLag", lag.get()) .detail("TaskInstance", THIS_ADDR);
															#line 602 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<RestoreConfig_GetProgress_implActor*>(this)->SAV<std::string>::futures) { (void)(format("Tag: %s  UID: %s  State: %s  Blocks: %lld/%lld  BlocksInProgress: %lld  Files: %lld  BytesWritten: " "%lld  ApplyVersionLag: %lld  LastError: %s", tag.get().c_str(), uid.toString().c_str(), status.get().toString().c_str(), fileBlocksFinished.get(), fileBlockCount.get(), fileBlocksDispatched.get() - fileBlocksFinished.get(), fileCount.get(), bytesWritten.get(), lag.get(), errstr.c_str())); this->~RestoreConfig_GetProgress_implActorState(); static_cast<RestoreConfig_GetProgress_implActor*>(this)->destroy(); return 0; }
															#line 3803 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<RestoreConfig_GetProgress_implActor*>(this)->SAV< std::string >::value()) std::string(format("Tag: %s  UID: %s  State: %s  Blocks: %lld/%lld  BlocksInProgress: %lld  Files: %lld  BytesWritten: " "%lld  ApplyVersionLag: %lld  LastError: %s", tag.get().c_str(), uid.toString().c_str(), status.get().toString().c_str(), fileBlocksFinished.get(), fileBlockCount.get(), fileBlocksDispatched.get() - fileBlocksFinished.get(), fileCount.get(), bytesWritten.get(), lag.get(), errstr.c_str()));
		this->~RestoreConfig_GetProgress_implActorState();
		static_cast<RestoreConfig_GetProgress_implActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 582 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		std::string errstr = "None";
															#line 583 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (lastError.get().second != 0)
															#line 3817 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 584 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			errstr = format("'%s' %" PRId64 "s ago.\n", lastError.get().first.c_str(), (tr->getReadVersion().get() - lastError.get().second) / CLIENT_KNOBS->CORE_VERSIONSPERSECOND);
															#line 3821 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
															#line 588 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		TraceEvent("FileRestoreProgress") .detail("RestoreUID", uid) .detail("Tag", tag.get()) .detail("State", status.get().toString()) .detail("FileCount", fileCount.get()) .detail("FileBlocksFinished", fileBlocksFinished.get()) .detail("FileBlocksTotal", fileBlockCount.get()) .detail("FileBlocksInProgress", fileBlocksDispatched.get() - fileBlocksFinished.get()) .detail("BytesWritten", bytesWritten.get()) .detail("CurrentVersion", currentVersion.get()) .detail("FirstConsistentVersion", firstConsistentVersion.get()) .detail("ApplyLag", lag.get()) .detail("TaskInstance", THIS_ADDR);
															#line 602 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<RestoreConfig_GetProgress_implActor*>(this)->SAV<std::string>::futures) { (void)(format("Tag: %s  UID: %s  State: %s  Blocks: %lld/%lld  BlocksInProgress: %lld  Files: %lld  BytesWritten: " "%lld  ApplyVersionLag: %lld  LastError: %s", tag.get().c_str(), uid.toString().c_str(), status.get().toString().c_str(), fileBlocksFinished.get(), fileBlockCount.get(), fileBlocksDispatched.get() - fileBlocksFinished.get(), fileCount.get(), bytesWritten.get(), lag.get(), errstr.c_str())); this->~RestoreConfig_GetProgress_implActorState(); static_cast<RestoreConfig_GetProgress_implActor*>(this)->destroy(); return 0; }
															#line 3827 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<RestoreConfig_GetProgress_implActor*>(this)->SAV< std::string >::value()) std::string(format("Tag: %s  UID: %s  State: %s  Blocks: %lld/%lld  BlocksInProgress: %lld  Files: %lld  BytesWritten: " "%lld  ApplyVersionLag: %lld  LastError: %s", tag.get().c_str(), uid.toString().c_str(), status.get().toString().c_str(), fileBlocksFinished.get(), fileBlockCount.get(), fileBlocksDispatched.get() - fileBlocksFinished.get(), fileCount.get(), bytesWritten.get(), lag.get(), errstr.c_str()));
		this->~RestoreConfig_GetProgress_implActorState();
		static_cast<RestoreConfig_GetProgress_implActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RestoreConfig_GetProgress_implActor*>(this)->actor_wait_state > 0) static_cast<RestoreConfig_GetProgress_implActor*>(this)->actor_wait_state = 0;
		static_cast<RestoreConfig_GetProgress_implActor*>(this)->ActorCallback< RestoreConfig_GetProgress_implActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RestoreConfig_GetProgress_implActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getProgress_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreConfig_GetProgress_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getProgress_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RestoreConfig_GetProgress_implActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getProgress_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreConfig_GetProgress_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getProgress_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RestoreConfig_GetProgress_implActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getProgress_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreConfig_GetProgress_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getProgress_impl", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 559 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	RestoreConfig restore;
															#line 559 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 564 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Future<int64_t> fileCount;
															#line 565 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Future<int64_t> fileBlockCount;
															#line 566 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Future<int64_t> fileBlocksDispatched;
															#line 567 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Future<int64_t> fileBlocksFinished;
															#line 568 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Future<int64_t> bytesWritten;
															#line 569 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Future<StringRef> status;
															#line 570 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Future<Version> currentVersion;
															#line 571 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Future<Version> lag;
															#line 572 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Future<Version> firstConsistentVersion;
															#line 573 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Future<std::string> tag;
															#line 574 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Future<std::pair<std::string, Version>> lastError;
															#line 577 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	UID uid;
															#line 3938 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getProgress_impl()
															#line 559 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class RestoreConfig_GetProgress_implActor final : public Actor<std::string>, public ActorCallback< RestoreConfig_GetProgress_implActor, 0, Void >, public FastAllocated<RestoreConfig_GetProgress_implActor>, public RestoreConfig_GetProgress_implActorState<RestoreConfig_GetProgress_implActor> {
															#line 3943 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<RestoreConfig_GetProgress_implActor>::operator new;
	using FastAllocated<RestoreConfig_GetProgress_implActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1032091502359761920UL, 5092993509722874624UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::string>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RestoreConfig_GetProgress_implActor, 0, Void >;
															#line 559 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	RestoreConfig_GetProgress_implActor(RestoreConfig const& restore,Reference<ReadYourWritesTransaction> const& tr) 
															#line 3960 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<std::string>(),
		   RestoreConfig_GetProgress_implActorState<RestoreConfig_GetProgress_implActor>(restore, tr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getProgress_impl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18275805459408915200UL, 825561359449413632UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreConfig_GetProgress_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getProgress_impl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getProgress_impl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RestoreConfig_GetProgress_implActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 559 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] Future<std::string> RestoreConfig::getProgress_impl( RestoreConfig const& restore, Reference<ReadYourWritesTransaction> const& tr ) {
															#line 559 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<std::string>(new RestoreConfig_GetProgress_implActor(restore, tr));
															#line 3992 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 615 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

															#line 3997 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via getFullStatus_impl()
															#line 616 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class RestoreConfig_GetFullStatus_implActor>
															#line 616 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class RestoreConfig_GetFullStatus_implActorState {
															#line 4003 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 616 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	RestoreConfig_GetFullStatus_implActorState(RestoreConfig const& restore,Reference<ReadYourWritesTransaction> const& tr) 
															#line 616 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 616 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : restore(restore),
															#line 616 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   tr(tr)
															#line 4012 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getFullStatus_impl", reinterpret_cast<unsigned long>(this));

	}
	~RestoreConfig_GetFullStatus_implActorState() 
	{
		fdb_probe_actor_destroy("getFullStatus_impl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 618 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 619 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 621 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			ranges = restore.getRestoreRangesOrDefault(tr);
															#line 622 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			addPrefix = restore.addPrefix().getD(tr);
															#line 623 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			removePrefix = restore.removePrefix().getD(tr);
															#line 624 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			url = restore.sourceContainerURL().getD(tr);
															#line 625 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			restoreVersion = restore.restoreVersion().getD(tr);
															#line 626 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			progress = restore.getProgress(tr);
															#line 627 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			restoreState = restore.stateEnum().getD(tr);
															#line 628 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			useRangeFileRestore = restore.useRangeFileRestore().get(tr);
															#line 629 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			bulkLoadComplete = restore.bulkLoadComplete().get(tr);
															#line 632 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_0 = success(ranges) && success(addPrefix) && success(removePrefix) && success(url) && success(restoreVersion) && success(progress) && success(restoreState) && success(useRangeFileRestore) && success(bulkLoadComplete);
															#line 632 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<RestoreConfig_GetFullStatus_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4051 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RestoreConfig_GetFullStatus_implActor*>(this)->actor_wait_state = 1;
															#line 632 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RestoreConfig_GetFullStatus_implActor, 0, Void >*>(static_cast<RestoreConfig_GetFullStatus_implActor*>(this)));
															#line 4056 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RestoreConfig_GetFullStatus_implActorState();
		static_cast<RestoreConfig_GetFullStatus_implActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 635 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		std::string returnStr;
															#line 636 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		returnStr = format("%s  URL: %s", progress.get().c_str(), url.get().toString().c_str());
															#line 637 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		for( auto& range : ranges.get() ) {
															#line 638 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			returnStr += format("  Range: '%s'-'%s'", printable(range.begin).c_str(), printable(range.end).c_str());
															#line 4085 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
															#line 640 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		returnStr += format("  AddPrefix: '%s'  RemovePrefix: '%s'  Version: %lld", printable(addPrefix.get()).c_str(), printable(removePrefix.get()).c_str(), restoreVersion.get());
															#line 647 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		bool usingBulkLoad = useRangeFileRestore.get().present() && !useRangeFileRestore.get().get();
															#line 648 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		std::string snapshotMethod = usingBulkLoad ? "bulkload" : "rangefile";
															#line 649 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		returnStr += format("  Snapshot Method: %s", snapshotMethod.c_str());
															#line 652 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		ERestoreState currentState = restoreState.get();
															#line 653 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (currentState == ERestoreState::RUNNING)
															#line 4099 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 654 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			bool bulkLoadDone = bulkLoadComplete.get().present() && bulkLoadComplete.get().get();
															#line 655 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (usingBulkLoad)
															#line 4105 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			{
															#line 656 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				std::string snapshotPhase = bulkLoadDone ? "complete" : "in_progress";
															#line 657 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				returnStr += format("  Snapshot Phase: %s", snapshotPhase.c_str());
															#line 658 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				std::string mutationPhase = bulkLoadDone ? "in_progress" : "not_started";
															#line 659 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				returnStr += format("  Mutation Log Phase: %s", mutationPhase.c_str());
															#line 4115 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			}
			else
			{
															#line 661 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				returnStr += "  Snapshot Phase: in_progress  Mutation Log Phase: in_progress";
															#line 4121 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			}
		}
		else
		{
															#line 663 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (currentState == ERestoreState::COMPLETED)
															#line 4128 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			{
															#line 664 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				returnStr += "  Snapshot Phase: complete  Mutation Log Phase: complete";
															#line 4132 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			}
		}
															#line 667 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<RestoreConfig_GetFullStatus_implActor*>(this)->SAV<std::string>::futures) { (void)(returnStr); this->~RestoreConfig_GetFullStatus_implActorState(); static_cast<RestoreConfig_GetFullStatus_implActor*>(this)->destroy(); return 0; }
															#line 4137 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<RestoreConfig_GetFullStatus_implActor*>(this)->SAV< std::string >::value()) std::string(returnStr);
		this->~RestoreConfig_GetFullStatus_implActorState();
		static_cast<RestoreConfig_GetFullStatus_implActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 635 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		std::string returnStr;
															#line 636 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		returnStr = format("%s  URL: %s", progress.get().c_str(), url.get().toString().c_str());
															#line 637 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		for( auto& range : ranges.get() ) {
															#line 638 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			returnStr += format("  Range: '%s'-'%s'", printable(range.begin).c_str(), printable(range.end).c_str());
															#line 4155 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
															#line 640 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		returnStr += format("  AddPrefix: '%s'  RemovePrefix: '%s'  Version: %lld", printable(addPrefix.get()).c_str(), printable(removePrefix.get()).c_str(), restoreVersion.get());
															#line 647 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		bool usingBulkLoad = useRangeFileRestore.get().present() && !useRangeFileRestore.get().get();
															#line 648 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		std::string snapshotMethod = usingBulkLoad ? "bulkload" : "rangefile";
															#line 649 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		returnStr += format("  Snapshot Method: %s", snapshotMethod.c_str());
															#line 652 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		ERestoreState currentState = restoreState.get();
															#line 653 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (currentState == ERestoreState::RUNNING)
															#line 4169 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 654 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			bool bulkLoadDone = bulkLoadComplete.get().present() && bulkLoadComplete.get().get();
															#line 655 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (usingBulkLoad)
															#line 4175 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			{
															#line 656 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				std::string snapshotPhase = bulkLoadDone ? "complete" : "in_progress";
															#line 657 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				returnStr += format("  Snapshot Phase: %s", snapshotPhase.c_str());
															#line 658 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				std::string mutationPhase = bulkLoadDone ? "in_progress" : "not_started";
															#line 659 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				returnStr += format("  Mutation Log Phase: %s", mutationPhase.c_str());
															#line 4185 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			}
			else
			{
															#line 661 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				returnStr += "  Snapshot Phase: in_progress  Mutation Log Phase: in_progress";
															#line 4191 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			}
		}
		else
		{
															#line 663 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (currentState == ERestoreState::COMPLETED)
															#line 4198 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			{
															#line 664 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				returnStr += "  Snapshot Phase: complete  Mutation Log Phase: complete";
															#line 4202 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			}
		}
															#line 667 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<RestoreConfig_GetFullStatus_implActor*>(this)->SAV<std::string>::futures) { (void)(returnStr); this->~RestoreConfig_GetFullStatus_implActorState(); static_cast<RestoreConfig_GetFullStatus_implActor*>(this)->destroy(); return 0; }
															#line 4207 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<RestoreConfig_GetFullStatus_implActor*>(this)->SAV< std::string >::value()) std::string(returnStr);
		this->~RestoreConfig_GetFullStatus_implActorState();
		static_cast<RestoreConfig_GetFullStatus_implActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RestoreConfig_GetFullStatus_implActor*>(this)->actor_wait_state > 0) static_cast<RestoreConfig_GetFullStatus_implActor*>(this)->actor_wait_state = 0;
		static_cast<RestoreConfig_GetFullStatus_implActor*>(this)->ActorCallback< RestoreConfig_GetFullStatus_implActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RestoreConfig_GetFullStatus_implActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getFullStatus_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreConfig_GetFullStatus_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getFullStatus_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RestoreConfig_GetFullStatus_implActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getFullStatus_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreConfig_GetFullStatus_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getFullStatus_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RestoreConfig_GetFullStatus_implActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getFullStatus_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreConfig_GetFullStatus_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getFullStatus_impl", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 616 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	RestoreConfig restore;
															#line 616 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 621 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Future<std::vector<KeyRange>> ranges;
															#line 622 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Future<Key> addPrefix;
															#line 623 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Future<Key> removePrefix;
															#line 624 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Future<Key> url;
															#line 625 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Future<Version> restoreVersion;
															#line 626 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Future<std::string> progress;
															#line 627 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Future<ERestoreState> restoreState;
															#line 628 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Future<Optional<bool>> useRangeFileRestore;
															#line 629 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Future<Optional<bool>> bulkLoadComplete;
															#line 4312 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getFullStatus_impl()
															#line 616 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class RestoreConfig_GetFullStatus_implActor final : public Actor<std::string>, public ActorCallback< RestoreConfig_GetFullStatus_implActor, 0, Void >, public FastAllocated<RestoreConfig_GetFullStatus_implActor>, public RestoreConfig_GetFullStatus_implActorState<RestoreConfig_GetFullStatus_implActor> {
															#line 4317 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<RestoreConfig_GetFullStatus_implActor>::operator new;
	using FastAllocated<RestoreConfig_GetFullStatus_implActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6384810285543209728UL, 1692160950992551936UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::string>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RestoreConfig_GetFullStatus_implActor, 0, Void >;
															#line 616 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	RestoreConfig_GetFullStatus_implActor(RestoreConfig const& restore,Reference<ReadYourWritesTransaction> const& tr) 
															#line 4334 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<std::string>(),
		   RestoreConfig_GetFullStatus_implActorState<RestoreConfig_GetFullStatus_implActor>(restore, tr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getFullStatus_impl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1316626605627362304UL, 15365334437446535168UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreConfig_GetFullStatus_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getFullStatus_impl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getFullStatus_impl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RestoreConfig_GetFullStatus_implActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 616 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] Future<std::string> RestoreConfig::getFullStatus_impl( RestoreConfig const& restore, Reference<ReadYourWritesTransaction> const& tr ) {
															#line 616 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<std::string>(new RestoreConfig_GetFullStatus_implActor(restore, tr));
															#line 4366 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 669 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

// two buffers are alternatively serving data and reading data from file
// thus when one buffer is serving data through peek()
// the other buffer is reading data from file to provide pipelining.
class TwoBuffers : public ReferenceCounted<TwoBuffers>, NonCopyable {
public:
	class IteratorBuffer : public ReferenceCounted<IteratorBuffer> {
	public:
		std::shared_ptr<char[]> data;
		// has_value means there is data, otherwise it means there is no data being fetched or ready
		// is_valid means data is being fetched, is_ready means data is ready
		std::optional<Future<Void>> fetchingData;
		size_t size;
		int index;
		int capacity;
		IteratorBuffer(int _capacity) {
			capacity = _capacity;
			data = std::shared_ptr<char[]>(new char[capacity]());
			fetchingData.reset();
			size = 0;
		}
		bool is_valid() { return fetchingData.has_value(); }
		void reset() {
			size = 0;
			index = 0;
			fetchingData.reset();
		}
	};
	TwoBuffers(int capacity, Reference<IBackupContainer> _bc, std::vector<RestoreConfig::RestoreFile>& _files, int tag);
	// ready need to be called first before calling peek
	// because a shared_ptr cannot be wrapped by a Future
	// this method ensures the current buffer has available data
	Future<Void> ready();
																#line 4403 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
[[nodiscard]] static Future<Void> ready( Reference<TwoBuffers> const& self );
template <class> friend class TwoBuffers_ReadyActorState;

#line 703 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	// fill buffer[index] with the next block of file
	// it has side effects to change currentFileIndex and currentFilePosition
																#line 4410 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
[[nodiscard]] static Future<Void> readNextBlock( Reference<TwoBuffers> const& self, int const& index );
template <class> friend class TwoBuffers_ReadNextBlockActorState;

#line 706 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	// peek can only be called after ready is called
	// it returns the pointer to the active buffer
	std::shared_ptr<char[]> peek();

	int getFileIndex();
	void setFileIndex(int);

	bool hasNext();

	void reset();

	// discard the current buffer and swap to the next one
	void discardAndSwap();

	// try to fill the buffer[index]
	// but no-op if the buffer have valid data or it is actively being filled
	void fillBufferIfAbsent(int index);

	size_t getBufferSize();

private:
	Reference<IteratorBuffer> buffers[2]; // Two buffers for alternating
	size_t bufferCapacity; // Size of each buffer in bytes
	Reference<IBackupContainer> bc;
	std::vector<RestoreConfig::RestoreFile> files;
	int tag;

	int cur; // Index of the current active buffer (0 or 1)
	size_t currentFileIndex; // Index of the current file being read
	size_t currentFilePosition; // Current read position in the current file
};

TwoBuffers::TwoBuffers(int capacity,
                       Reference<IBackupContainer> _bc,
                       std::vector<RestoreConfig::RestoreFile>& _files,
                       int _tag)
  : currentFileIndex(0), currentFilePosition(0), cur(0), bufferCapacity(capacity), files(_files), bc(_bc), tag(_tag) {
	buffers[0] = makeReference<IteratorBuffer>(capacity);
	buffers[1] = makeReference<IteratorBuffer>(capacity);
}

bool TwoBuffers::hasNext() {
	// if it is being load (valid but not ready, what would be the size?)
	while (currentFileIndex < files.size() && currentFilePosition >= files[currentFileIndex].fileSize) {
		currentFileIndex++;
		currentFilePosition = 0;
	}

	if (buffers[0]->is_valid() || buffers[1]->is_valid()) {
		return true;
	}

	return currentFileIndex != files.size();
}

Future<Void> TwoBuffers::ready() {
	return ready(Reference<TwoBuffers>::addRef(this));
}

															#line 4474 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via ready()
															#line 765 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class TwoBuffers_ReadyActor>
															#line 765 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class TwoBuffers_ReadyActorState {
															#line 4480 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 765 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	TwoBuffers_ReadyActorState(Reference<TwoBuffers> const& self) 
															#line 765 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 765 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : self(self)
															#line 4487 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("ready", reinterpret_cast<unsigned long>(this));

	}
	~TwoBuffers_ReadyActorState() 
	{
		fdb_probe_actor_destroy("ready", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 767 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!self->hasNext())
															#line 4502 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			{
															#line 768 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				if (!static_cast<TwoBuffers_ReadyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TwoBuffers_ReadyActorState(); static_cast<TwoBuffers_ReadyActor*>(this)->destroy(); return 0; }
															#line 4506 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
				new (&static_cast<TwoBuffers_ReadyActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~TwoBuffers_ReadyActorState();
				static_cast<TwoBuffers_ReadyActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 771 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			self->fillBufferIfAbsent(self->cur);
															#line 772 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->buffers[self->cur]->fetchingData.value();
															#line 772 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<TwoBuffers_ReadyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4518 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TwoBuffers_ReadyActor*>(this)->actor_wait_state = 1;
															#line 772 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TwoBuffers_ReadyActor, 0, Void >*>(static_cast<TwoBuffers_ReadyActor*>(this)));
															#line 4523 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TwoBuffers_ReadyActorState();
		static_cast<TwoBuffers_ReadyActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 774 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (self->hasNext())
															#line 4546 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 775 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			self->fillBufferIfAbsent(1 - self->cur);
															#line 4550 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
															#line 777 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<TwoBuffers_ReadyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TwoBuffers_ReadyActorState(); static_cast<TwoBuffers_ReadyActor*>(this)->destroy(); return 0; }
															#line 4554 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<TwoBuffers_ReadyActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TwoBuffers_ReadyActorState();
		static_cast<TwoBuffers_ReadyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 774 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (self->hasNext())
															#line 4566 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 775 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			self->fillBufferIfAbsent(1 - self->cur);
															#line 4570 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
															#line 777 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<TwoBuffers_ReadyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TwoBuffers_ReadyActorState(); static_cast<TwoBuffers_ReadyActor*>(this)->destroy(); return 0; }
															#line 4574 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<TwoBuffers_ReadyActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TwoBuffers_ReadyActorState();
		static_cast<TwoBuffers_ReadyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TwoBuffers_ReadyActor*>(this)->actor_wait_state > 0) static_cast<TwoBuffers_ReadyActor*>(this)->actor_wait_state = 0;
		static_cast<TwoBuffers_ReadyActor*>(this)->ActorCallback< TwoBuffers_ReadyActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TwoBuffers_ReadyActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("ready", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TwoBuffers_ReadyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ready", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TwoBuffers_ReadyActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("ready", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TwoBuffers_ReadyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ready", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TwoBuffers_ReadyActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("ready", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TwoBuffers_ReadyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ready", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 765 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<TwoBuffers> self;
															#line 4659 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via ready()
															#line 765 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class TwoBuffers_ReadyActor final : public Actor<Void>, public ActorCallback< TwoBuffers_ReadyActor, 0, Void >, public FastAllocated<TwoBuffers_ReadyActor>, public TwoBuffers_ReadyActorState<TwoBuffers_ReadyActor> {
															#line 4664 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<TwoBuffers_ReadyActor>::operator new;
	using FastAllocated<TwoBuffers_ReadyActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12904262673680531712UL, 3997658923878661376UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TwoBuffers_ReadyActor, 0, Void >;
															#line 765 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	TwoBuffers_ReadyActor(Reference<TwoBuffers> const& self) 
															#line 4681 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   TwoBuffers_ReadyActorState<TwoBuffers_ReadyActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("ready", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14937009140389269760UL, 8193691466251763968UL);
		ActorExecutionContextHelper __helper(static_cast<TwoBuffers_ReadyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("ready");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("ready", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TwoBuffers_ReadyActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 765 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] Future<Void> TwoBuffers::ready( Reference<TwoBuffers> const& self ) {
															#line 765 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Void>(new TwoBuffers_ReadyActor(self));
															#line 4713 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 779 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

std::shared_ptr<char[]> TwoBuffers::peek() {
	return buffers[cur]->data;
}

int TwoBuffers::getFileIndex() {
	return buffers[cur]->index;
}

void TwoBuffers::setFileIndex(int newIndex) {
	if (newIndex < 0 || newIndex >= files.size()) {
		TraceEvent(SevError, "TwoBuffersFileIndexOutOfBound")
		    .detail("FilesSize", files.size())
		    .detail("NewIndex", newIndex)
		    .log();
	}
	currentFileIndex = newIndex;
}

void TwoBuffers::discardAndSwap() {
	// invalidate cur and change cur to next
	buffers[cur]->fetchingData.reset();
	cur = 1 - cur;
}

void TwoBuffers::reset() {
	// invalidate cur and change cur to next
	buffers[0]->reset();
	buffers[1]->reset();
	cur = 0;
	currentFileIndex = 0;
	currentFilePosition = 0;
}

size_t TwoBuffers::getBufferSize() {
	return buffers[cur]->size;
}

static double testKeyToDouble(const KeyRef& p) {
	uint64_t x = 0;
	sscanf(p.toString().c_str(), "%" SCNx64, &x);
	return *(double*)&x;
}

// only one readNextBlock can be run at a single time, otherwie the same block might be loaded twice
															#line 4762 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via readNextBlock()
															#line 824 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class TwoBuffers_ReadNextBlockActor>
															#line 824 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class TwoBuffers_ReadNextBlockActorState {
															#line 4768 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 824 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	TwoBuffers_ReadNextBlockActorState(Reference<TwoBuffers> const& self,int const& index) 
															#line 824 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 824 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : self(self),
															#line 824 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   index(index),
															#line 825 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   asyncFile()
															#line 4779 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("readNextBlock", reinterpret_cast<unsigned long>(this));

	}
	~TwoBuffers_ReadNextBlockActorState() 
	{
		fdb_probe_actor_destroy("readNextBlock", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 826 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (self->currentFileIndex >= self->files.size())
															#line 4794 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			{
															#line 827 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				TraceEvent(SevError, "ReadNextBlockOutOfBound") .detail("FileIndex", self->currentFileIndex) .detail("Tag", self->tag) .detail("Position", self->currentFilePosition) .detail("FileSize", self->files[self->currentFileIndex].fileSize) .detail("FilesCount", self->files.size()) .log();
															#line 834 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				if (!static_cast<TwoBuffers_ReadNextBlockActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TwoBuffers_ReadNextBlockActorState(); static_cast<TwoBuffers_ReadNextBlockActor*>(this)->destroy(); return 0; }
															#line 4800 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
				new (&static_cast<TwoBuffers_ReadNextBlockActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~TwoBuffers_ReadNextBlockActorState();
				static_cast<TwoBuffers_ReadNextBlockActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 836 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Reference<IAsyncFile>> __when_expr_0 = self->bc->readFile(self->files[self->currentFileIndex].fileName);
															#line 836 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<TwoBuffers_ReadNextBlockActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4810 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TwoBuffers_ReadNextBlockActor*>(this)->actor_wait_state = 1;
															#line 836 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TwoBuffers_ReadNextBlockActor, 0, Reference<IAsyncFile> >*>(static_cast<TwoBuffers_ReadNextBlockActor*>(this)));
															#line 4815 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TwoBuffers_ReadNextBlockActorState();
		static_cast<TwoBuffers_ReadNextBlockActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Reference<IAsyncFile> const& asyncFileTmp,int loopDepth) 
	{
															#line 837 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		asyncFile = asyncFileTmp;
															#line 838 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		fileSize = self->files[self->currentFileIndex].fileSize;
															#line 839 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		size_t remaining = fileSize - self->currentFilePosition;
															#line 840 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		bytesToRead = std::min(self->bufferCapacity, remaining);
															#line 841 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<int> __when_expr_1 = asyncFile->read(static_cast<void*>(self->buffers[index]->data.get()), bytesToRead, self->currentFilePosition);
															#line 841 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<TwoBuffers_ReadNextBlockActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4848 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TwoBuffers_ReadNextBlockActor*>(this)->actor_wait_state = 2;
															#line 841 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TwoBuffers_ReadNextBlockActor, 1, int >*>(static_cast<TwoBuffers_ReadNextBlockActor*>(this)));
															#line 4853 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Reference<IAsyncFile> && asyncFileTmp,int loopDepth) 
	{
															#line 837 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		asyncFile = asyncFileTmp;
															#line 838 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		fileSize = self->files[self->currentFileIndex].fileSize;
															#line 839 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		size_t remaining = fileSize - self->currentFilePosition;
															#line 840 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		bytesToRead = std::min(self->bufferCapacity, remaining);
															#line 841 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<int> __when_expr_1 = asyncFile->read(static_cast<void*>(self->buffers[index]->data.get()), bytesToRead, self->currentFilePosition);
															#line 841 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<TwoBuffers_ReadNextBlockActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4872 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TwoBuffers_ReadNextBlockActor*>(this)->actor_wait_state = 2;
															#line 841 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TwoBuffers_ReadNextBlockActor, 1, int >*>(static_cast<TwoBuffers_ReadNextBlockActor*>(this)));
															#line 4877 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Reference<IAsyncFile> const& asyncFileTmp,int loopDepth) 
	{
		loopDepth = a_body1cont1(asyncFileTmp, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Reference<IAsyncFile> && asyncFileTmp,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(asyncFileTmp), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TwoBuffers_ReadNextBlockActor*>(this)->actor_wait_state > 0) static_cast<TwoBuffers_ReadNextBlockActor*>(this)->actor_wait_state = 0;
		static_cast<TwoBuffers_ReadNextBlockActor*>(this)->ActorCallback< TwoBuffers_ReadNextBlockActor, 0, Reference<IAsyncFile> >::remove();

	}
	void a_callback_fire(ActorCallback< TwoBuffers_ReadNextBlockActor, 0, Reference<IAsyncFile> >*,Reference<IAsyncFile> const& value) 
	{
		fdb_probe_actor_enter("readNextBlock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TwoBuffers_ReadNextBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readNextBlock", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TwoBuffers_ReadNextBlockActor, 0, Reference<IAsyncFile> >*,Reference<IAsyncFile> && value) 
	{
		fdb_probe_actor_enter("readNextBlock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TwoBuffers_ReadNextBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readNextBlock", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TwoBuffers_ReadNextBlockActor, 0, Reference<IAsyncFile> >*,Error err) 
	{
		fdb_probe_actor_enter("readNextBlock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TwoBuffers_ReadNextBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readNextBlock", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 843 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (bytesRead != bytesToRead)
															#line 4961 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 844 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			return a_body1Catch1(restore_bad_read(), loopDepth);
															#line 4965 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
															#line 845 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->buffers[index]->index = self->currentFileIndex;
															#line 846 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->buffers[index]->size = bytesRead;
															#line 847 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->currentFilePosition += bytesRead;
															#line 849 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<TwoBuffers_ReadNextBlockActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TwoBuffers_ReadNextBlockActorState(); static_cast<TwoBuffers_ReadNextBlockActor*>(this)->destroy(); return 0; }
															#line 4975 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<TwoBuffers_ReadNextBlockActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TwoBuffers_ReadNextBlockActorState();
		static_cast<TwoBuffers_ReadNextBlockActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(int const& __bytesRead,int loopDepth) 
	{
															#line 841 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		bytesRead = __bytesRead;
															#line 4987 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(int && __bytesRead,int loopDepth) 
	{
		bytesRead = std::move(__bytesRead);
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TwoBuffers_ReadNextBlockActor*>(this)->actor_wait_state > 0) static_cast<TwoBuffers_ReadNextBlockActor*>(this)->actor_wait_state = 0;
		static_cast<TwoBuffers_ReadNextBlockActor*>(this)->ActorCallback< TwoBuffers_ReadNextBlockActor, 1, int >::remove();

	}
	void a_callback_fire(ActorCallback< TwoBuffers_ReadNextBlockActor, 1, int >*,int const& value) 
	{
		fdb_probe_actor_enter("readNextBlock", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TwoBuffers_ReadNextBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readNextBlock", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TwoBuffers_ReadNextBlockActor, 1, int >*,int && value) 
	{
		fdb_probe_actor_enter("readNextBlock", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TwoBuffers_ReadNextBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readNextBlock", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TwoBuffers_ReadNextBlockActor, 1, int >*,Error err) 
	{
		fdb_probe_actor_enter("readNextBlock", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TwoBuffers_ReadNextBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readNextBlock", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 824 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<TwoBuffers> self;
															#line 824 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	int index;
															#line 825 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<IAsyncFile> asyncFile;
															#line 838 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	size_t fileSize;
															#line 840 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	size_t bytesToRead;
															#line 841 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	int bytesRead;
															#line 5074 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via readNextBlock()
															#line 824 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class TwoBuffers_ReadNextBlockActor final : public Actor<Void>, public ActorCallback< TwoBuffers_ReadNextBlockActor, 0, Reference<IAsyncFile> >, public ActorCallback< TwoBuffers_ReadNextBlockActor, 1, int >, public FastAllocated<TwoBuffers_ReadNextBlockActor>, public TwoBuffers_ReadNextBlockActorState<TwoBuffers_ReadNextBlockActor> {
															#line 5079 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<TwoBuffers_ReadNextBlockActor>::operator new;
	using FastAllocated<TwoBuffers_ReadNextBlockActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9913054566650507520UL, 484949646581561088UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TwoBuffers_ReadNextBlockActor, 0, Reference<IAsyncFile> >;
friend struct ActorCallback< TwoBuffers_ReadNextBlockActor, 1, int >;
															#line 824 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	TwoBuffers_ReadNextBlockActor(Reference<TwoBuffers> const& self,int const& index) 
															#line 5097 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   TwoBuffers_ReadNextBlockActorState<TwoBuffers_ReadNextBlockActor>(self, index),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("readNextBlock", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1542594355812348416UL, 14195273269523580672UL);
		ActorExecutionContextHelper __helper(static_cast<TwoBuffers_ReadNextBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("readNextBlock");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("readNextBlock", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TwoBuffers_ReadNextBlockActor, 0, Reference<IAsyncFile> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TwoBuffers_ReadNextBlockActor, 1, int >*)0, actor_cancelled()); break;
		}

	}
};
															#line 824 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] Future<Void> TwoBuffers::readNextBlock( Reference<TwoBuffers> const& self, int const& index ) {
															#line 824 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Void>(new TwoBuffers_ReadNextBlockActor(self, index));
															#line 5130 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 851 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

void TwoBuffers::fillBufferIfAbsent(int index) {
	if (buffers[index]->is_valid()) {
		// if this buffer is valid, then do not overwrite it
		return;
	}
	if (currentFileIndex == files.size()) {
		// quit if no more contents
		return;
	}
	auto self = Reference<TwoBuffers>::addRef(this);
	self->buffers[index]->fetchingData = readNextBlock(self, index);
	return;
}

bool endOfBlock(char* start, int offset) {
	const unsigned char paddingChar = '\xff';
	return (unsigned char)*(start + offset) == paddingChar;
}

class PartitionedLogIteratorSimple : public PartitionedLogIterator {
public:
	const int BATCH_READ_BLOCK_COUNT = 1;
	const int BLOCK_SIZE = CLIENT_KNOBS->BACKUP_LOGFILE_BLOCK_SIZE;
	const int mutationHeaderBytes = sizeof(int64_t) + sizeof(int32_t) + sizeof(int32_t);
	Reference<IBackupContainer> bc;
	size_t bufferCapacity;
	int tag;
	std::vector<RestoreConfig::RestoreFile> files;
	size_t bufferOffset; // Current read offset
	int bufferSize;
	int fileOffset;
	int fileIndex;
	std::shared_ptr<char[]> buffer;
	std::vector<Version> endVersions;

	PartitionedLogIteratorSimple(Reference<IBackupContainer> _bc,
	                             int _tag,
	                             std::vector<RestoreConfig::RestoreFile> _files,
	                             std::vector<Version> _endVersions);

	bool hasNext();
	Future<Void> loadNextBlock();
																#line 5177 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
[[nodiscard]] static Future<Void> loadNextBlock( Reference<PartitionedLogIteratorSimple> const& self );
template <class> friend class PartitionedLogIteratorSimple_LoadNextBlockActorState;

#line 895 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	void removeBlockHeader();

	Standalone<VectorRef<VersionedMutation>> consumeData(Version firstVersion);

	// find the next version without advanding the iterator
	Future<Version> peekNextVersion();
																#line 5188 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
[[nodiscard]] static Future<Version> peekNextVersion( Reference<PartitionedLogIteratorSimple> const& iterator );
template <class> friend class PartitionedLogIteratorSimple_PeekNextVersionActorState;

#line 902 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

	// get all the mutations of next version and advance the iterator
	// this might issue multiple consumeData() if the data of a version cross buffer boundary
	Future<Standalone<VectorRef<VersionedMutation>>> getNext();
																#line 5197 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
[[nodiscard]] static Future<Standalone<VectorRef<VersionedMutation>>> getNext( Reference<PartitionedLogIteratorSimple> const& iterator );
template <class> friend class PartitionedLogIteratorSimple_GetNextActorState;

#line 908 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
};

PartitionedLogIteratorSimple::PartitionedLogIteratorSimple(Reference<IBackupContainer> _bc,
                                                           int _tag,
                                                           std::vector<RestoreConfig::RestoreFile> _files,
                                                           std::vector<Version> _endVersions)
  : bc(_bc), tag(_tag), endVersions(_endVersions), files(std::move(_files)), bufferOffset(0) {
	bufferCapacity = BATCH_READ_BLOCK_COUNT * BLOCK_SIZE;
	buffer = std::shared_ptr<char[]>(new char[bufferCapacity]());
	fileOffset = 0;
	fileIndex = 0;
	bufferSize = 0;
}

// it will set fileOffset and fileIndex
bool PartitionedLogIteratorSimple::hasNext() {
	if (bufferOffset < bufferSize) {
		return true;
	}
	while (fileIndex < files.size() && fileOffset >= files[fileIndex].fileSize) {
		TraceEvent("ReachEndOfLogFiles")
		    .detail("BufferOffset", bufferOffset)
		    .detail("BufferSize", bufferSize)
		    .detail("FileOffset", fileOffset)
		    .detail("FileSize", files[fileIndex].fileSize)
		    .detail("FileName", files[fileIndex].fileName)
		    .detail("Tag", tag)
		    .detail("Index", fileIndex)
		    .log();
		fileOffset = 0;
		fileIndex++;
	}
	return fileIndex < files.size() && fileOffset < files[fileIndex].fileSize;
}

void PartitionedLogIteratorSimple::removeBlockHeader() {
	if (bufferOffset % BLOCK_SIZE == 0) {
		bufferOffset += sizeof(uint32_t);
	}
}

Standalone<VectorRef<VersionedMutation>> PartitionedLogIteratorSimple::consumeData(Version firstVersion) {
	Standalone<VectorRef<VersionedMutation>> mutations = Standalone<VectorRef<VersionedMutation>>();
	char* start = buffer.get();
	bool foundNewVersion = false;
	while (bufferOffset < bufferSize) {
		while (bufferOffset < bufferSize && !endOfBlock(start, bufferOffset)) {
			// for each block
			removeBlockHeader();

			// encoding format:
			// wr << bigEndian64(message.version.version) << bigEndian32(message.version.sub) <<
			// bigEndian32(mutation.size());
			Version version;
			std::memcpy(&version, start + bufferOffset, sizeof(Version));
			version = bigEndian64(version);
			if (version != firstVersion) {
				foundNewVersion = true;
				break; // Different version, stop here
			}

			int32_t subsequence;
			std::memcpy(&subsequence, start + bufferOffset + sizeof(Version), sizeof(int32_t));
			subsequence = bigEndian32(subsequence);

			int32_t mutationSize;
			std::memcpy(&mutationSize, start + bufferOffset + sizeof(Version) + sizeof(int32_t), sizeof(int32_t));
			mutationSize = bigEndian32(mutationSize);

			// assumption: the entire mutation is within the buffer
			size_t mutationTotalSize = mutationHeaderBytes + mutationSize;
			ASSERT(bufferOffset + mutationTotalSize <= bufferSize);

			// transform from stringref to mutationref here
			Standalone<StringRef> mutationData = makeString(mutationSize);
			std::memcpy(mutateString(mutationData), start + bufferOffset + mutationHeaderBytes, mutationSize);
			ArenaReader reader(mutationData.arena(), mutationData, AssumeVersion(g_network->protocolVersion()));
			MutationRef mutation;
			reader >> mutation;

			VersionedMutation vm;
			vm.version = version;
			vm.subsequence = subsequence;
			vm.mutation = mutation;
			mutations.push_back_deep(mutations.arena(), vm);
			// Move the bufferOffset to include this mutation
			bufferOffset += mutationTotalSize;
		}

		if (bufferOffset < bufferSize && endOfBlock(start, bufferOffset)) {
			// there are paddings
			int remain = BLOCK_SIZE - (bufferOffset % BLOCK_SIZE);
			bufferOffset += remain;
		}
		if (foundNewVersion) {
			break;
		}
	}

	return mutations;
}

Future<Void> PartitionedLogIteratorSimple::loadNextBlock() {
	return loadNextBlock(Reference<PartitionedLogIteratorSimple>::addRef(this));
}

															#line 5308 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via loadNextBlock()
															#line 1014 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class PartitionedLogIteratorSimple_LoadNextBlockActor>
															#line 1014 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class PartitionedLogIteratorSimple_LoadNextBlockActorState {
															#line 5314 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 1014 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	PartitionedLogIteratorSimple_LoadNextBlockActorState(Reference<PartitionedLogIteratorSimple> const& self) 
															#line 1014 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 1014 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : self(self)
															#line 5321 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("loadNextBlock", reinterpret_cast<unsigned long>(this));

	}
	~PartitionedLogIteratorSimple_LoadNextBlockActorState() 
	{
		fdb_probe_actor_destroy("loadNextBlock", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1015 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (self->bufferOffset < self->bufferSize)
															#line 5336 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			{
															#line 1017 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				if (!static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PartitionedLogIteratorSimple_LoadNextBlockActorState(); static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->destroy(); return 0; }
															#line 5340 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
				new (&static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~PartitionedLogIteratorSimple_LoadNextBlockActorState();
				static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 1019 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!self->hasNext())
															#line 5348 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			{
															#line 1020 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				if (!static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PartitionedLogIteratorSimple_LoadNextBlockActorState(); static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->destroy(); return 0; }
															#line 5352 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
				new (&static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~PartitionedLogIteratorSimple_LoadNextBlockActorState();
				static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 1022 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			asyncFile = Reference<IAsyncFile>();
															#line 1023 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Reference<IAsyncFile>> __when_expr_0 = self->bc->readFile(self->files[self->fileIndex].fileName);
															#line 1023 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5364 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->actor_wait_state = 1;
															#line 1023 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PartitionedLogIteratorSimple_LoadNextBlockActor, 0, Reference<IAsyncFile> >*>(static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)));
															#line 5369 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PartitionedLogIteratorSimple_LoadNextBlockActorState();
		static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Reference<IAsyncFile> const& asyncFileTmp,int loopDepth) 
	{
															#line 1024 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		asyncFile = asyncFileTmp;
															#line 1025 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		fileSize = self->files[self->fileIndex].fileSize;
															#line 1026 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		size_t remaining = fileSize - self->fileOffset;
															#line 1027 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		bytesToRead = std::min(self->bufferCapacity, remaining);
															#line 1028 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<int> __when_expr_1 = asyncFile->read(static_cast<void*>((self->buffer.get())), bytesToRead, self->fileOffset);
															#line 1028 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5402 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->actor_wait_state = 2;
															#line 1028 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PartitionedLogIteratorSimple_LoadNextBlockActor, 1, int >*>(static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)));
															#line 5407 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Reference<IAsyncFile> && asyncFileTmp,int loopDepth) 
	{
															#line 1024 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		asyncFile = asyncFileTmp;
															#line 1025 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		fileSize = self->files[self->fileIndex].fileSize;
															#line 1026 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		size_t remaining = fileSize - self->fileOffset;
															#line 1027 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		bytesToRead = std::min(self->bufferCapacity, remaining);
															#line 1028 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<int> __when_expr_1 = asyncFile->read(static_cast<void*>((self->buffer.get())), bytesToRead, self->fileOffset);
															#line 1028 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5426 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->actor_wait_state = 2;
															#line 1028 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PartitionedLogIteratorSimple_LoadNextBlockActor, 1, int >*>(static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)));
															#line 5431 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Reference<IAsyncFile> const& asyncFileTmp,int loopDepth) 
	{
		loopDepth = a_body1cont1(asyncFileTmp, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Reference<IAsyncFile> && asyncFileTmp,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(asyncFileTmp), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->actor_wait_state > 0) static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->actor_wait_state = 0;
		static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->ActorCallback< PartitionedLogIteratorSimple_LoadNextBlockActor, 0, Reference<IAsyncFile> >::remove();

	}
	void a_callback_fire(ActorCallback< PartitionedLogIteratorSimple_LoadNextBlockActor, 0, Reference<IAsyncFile> >*,Reference<IAsyncFile> const& value) 
	{
		fdb_probe_actor_enter("loadNextBlock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadNextBlock", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PartitionedLogIteratorSimple_LoadNextBlockActor, 0, Reference<IAsyncFile> >*,Reference<IAsyncFile> && value) 
	{
		fdb_probe_actor_enter("loadNextBlock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadNextBlock", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PartitionedLogIteratorSimple_LoadNextBlockActor, 0, Reference<IAsyncFile> >*,Error err) 
	{
		fdb_probe_actor_enter("loadNextBlock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadNextBlock", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 1030 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (bytesRead != bytesToRead)
															#line 5515 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 1031 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			return a_body1Catch1(restore_bad_read(), loopDepth);
															#line 5519 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
															#line 1032 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->bufferSize = bytesRead;
															#line 1033 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->bufferOffset = 0;
															#line 1034 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->fileOffset += bytesRead;
															#line 1035 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PartitionedLogIteratorSimple_LoadNextBlockActorState(); static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->destroy(); return 0; }
															#line 5529 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PartitionedLogIteratorSimple_LoadNextBlockActorState();
		static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(int const& __bytesRead,int loopDepth) 
	{
															#line 1028 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		bytesRead = __bytesRead;
															#line 5541 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(int && __bytesRead,int loopDepth) 
	{
		bytesRead = std::move(__bytesRead);
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->actor_wait_state > 0) static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->actor_wait_state = 0;
		static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->ActorCallback< PartitionedLogIteratorSimple_LoadNextBlockActor, 1, int >::remove();

	}
	void a_callback_fire(ActorCallback< PartitionedLogIteratorSimple_LoadNextBlockActor, 1, int >*,int const& value) 
	{
		fdb_probe_actor_enter("loadNextBlock", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadNextBlock", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< PartitionedLogIteratorSimple_LoadNextBlockActor, 1, int >*,int && value) 
	{
		fdb_probe_actor_enter("loadNextBlock", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadNextBlock", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< PartitionedLogIteratorSimple_LoadNextBlockActor, 1, int >*,Error err) 
	{
		fdb_probe_actor_enter("loadNextBlock", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadNextBlock", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1014 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<PartitionedLogIteratorSimple> self;
															#line 1022 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<IAsyncFile> asyncFile;
															#line 1025 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	size_t fileSize;
															#line 1027 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	size_t bytesToRead;
															#line 1028 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	int bytesRead;
															#line 5626 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via loadNextBlock()
															#line 1014 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class PartitionedLogIteratorSimple_LoadNextBlockActor final : public Actor<Void>, public ActorCallback< PartitionedLogIteratorSimple_LoadNextBlockActor, 0, Reference<IAsyncFile> >, public ActorCallback< PartitionedLogIteratorSimple_LoadNextBlockActor, 1, int >, public FastAllocated<PartitionedLogIteratorSimple_LoadNextBlockActor>, public PartitionedLogIteratorSimple_LoadNextBlockActorState<PartitionedLogIteratorSimple_LoadNextBlockActor> {
															#line 5631 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<PartitionedLogIteratorSimple_LoadNextBlockActor>::operator new;
	using FastAllocated<PartitionedLogIteratorSimple_LoadNextBlockActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17143783923616236288UL, 714185456702433024UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PartitionedLogIteratorSimple_LoadNextBlockActor, 0, Reference<IAsyncFile> >;
friend struct ActorCallback< PartitionedLogIteratorSimple_LoadNextBlockActor, 1, int >;
															#line 1014 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	PartitionedLogIteratorSimple_LoadNextBlockActor(Reference<PartitionedLogIteratorSimple> const& self) 
															#line 5649 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   PartitionedLogIteratorSimple_LoadNextBlockActorState<PartitionedLogIteratorSimple_LoadNextBlockActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("loadNextBlock", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9541533795093038848UL, 7792905219334807296UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("loadNextBlock");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("loadNextBlock", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PartitionedLogIteratorSimple_LoadNextBlockActor, 0, Reference<IAsyncFile> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< PartitionedLogIteratorSimple_LoadNextBlockActor, 1, int >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1014 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] Future<Void> PartitionedLogIteratorSimple::loadNextBlock( Reference<PartitionedLogIteratorSimple> const& self ) {
															#line 1014 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Void>(new PartitionedLogIteratorSimple_LoadNextBlockActor(self));
															#line 5682 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 1037 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

Future<Version> PartitionedLogIteratorSimple::peekNextVersion() {
	return peekNextVersion(Reference<PartitionedLogIteratorSimple>::addRef(this));
}

															#line 5691 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via peekNextVersion()
															#line 1042 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class PartitionedLogIteratorSimple_PeekNextVersionActor>
															#line 1042 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class PartitionedLogIteratorSimple_PeekNextVersionActorState {
															#line 5697 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 1042 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	PartitionedLogIteratorSimple_PeekNextVersionActorState(Reference<PartitionedLogIteratorSimple> const& self) 
															#line 1042 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 1042 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : self(self)
															#line 5704 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("peekNextVersion", reinterpret_cast<unsigned long>(this));

	}
	~PartitionedLogIteratorSimple_PeekNextVersionActorState() 
	{
		fdb_probe_actor_destroy("peekNextVersion", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1044 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!self->hasNext())
															#line 5719 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			{
															#line 1045 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				if (!static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)->SAV<Version>::futures) { (void)(Version(0)); this->~PartitionedLogIteratorSimple_PeekNextVersionActorState(); static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)->destroy(); return 0; }
															#line 5723 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
				new (&static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)->SAV< Version >::value()) Version(Version(0));
				this->~PartitionedLogIteratorSimple_PeekNextVersionActorState();
				static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 1047 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->loadNextBlock();
															#line 1047 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5733 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)->actor_wait_state = 1;
															#line 1047 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PartitionedLogIteratorSimple_PeekNextVersionActor, 0, Void >*>(static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)));
															#line 5738 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PartitionedLogIteratorSimple_PeekNextVersionActorState();
		static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1048 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->removeBlockHeader();
															#line 1049 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		version = Version();
															#line 1050 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		std::memcpy(&version, self->buffer.get() + self->bufferOffset, sizeof(Version));
															#line 1051 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		version = bigEndian64(version);
															#line 1053 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		;
															#line 5769 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1048 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->removeBlockHeader();
															#line 1049 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		version = Version();
															#line 1050 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		std::memcpy(&version, self->buffer.get() + self->bufferOffset, sizeof(Version));
															#line 1051 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		version = bigEndian64(version);
															#line 1053 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		;
															#line 5786 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)->actor_wait_state > 0) static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)->actor_wait_state = 0;
		static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)->ActorCallback< PartitionedLogIteratorSimple_PeekNextVersionActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PartitionedLogIteratorSimple_PeekNextVersionActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("peekNextVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("peekNextVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PartitionedLogIteratorSimple_PeekNextVersionActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("peekNextVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("peekNextVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PartitionedLogIteratorSimple_PeekNextVersionActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("peekNextVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("peekNextVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 1067 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)->SAV<Version>::futures) { (void)(version); this->~PartitionedLogIteratorSimple_PeekNextVersionActorState(); static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)->destroy(); return 0; }
															#line 5870 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)->SAV< Version >::value()) Version(std::move(version)); // state_var_RVO
		this->~PartitionedLogIteratorSimple_PeekNextVersionActorState();
		static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 1053 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!(self->fileIndex < self->endVersions.size() - 1 && version >= self->endVersions[self->fileIndex]))
															#line 5889 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1054 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		TraceEvent("SimpleIteratorFindOverlapAndSkip") .detail("Version", version) .detail("FileIndex", self->fileIndex) .log();
															#line 1058 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->bufferOffset = 0;
															#line 1059 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->bufferSize = 0;
															#line 1060 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->fileOffset = 0;
															#line 1061 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->fileIndex += 1;
															#line 1062 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->loadNextBlock();
															#line 1062 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5907 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)->actor_wait_state = 2;
															#line 1062 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PartitionedLogIteratorSimple_PeekNextVersionActor, 1, Void >*>(static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)));
															#line 5912 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 1063 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->removeBlockHeader();
															#line 1064 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		std::memcpy(&version, self->buffer.get() + self->bufferOffset, sizeof(Version));
															#line 1065 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		version = bigEndian64(version);
															#line 5938 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 1063 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->removeBlockHeader();
															#line 1064 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		std::memcpy(&version, self->buffer.get() + self->bufferOffset, sizeof(Version));
															#line 1065 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		version = bigEndian64(version);
															#line 5951 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)->actor_wait_state > 0) static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)->actor_wait_state = 0;
		static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)->ActorCallback< PartitionedLogIteratorSimple_PeekNextVersionActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PartitionedLogIteratorSimple_PeekNextVersionActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("peekNextVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("peekNextVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< PartitionedLogIteratorSimple_PeekNextVersionActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("peekNextVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("peekNextVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< PartitionedLogIteratorSimple_PeekNextVersionActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("peekNextVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("peekNextVersion", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1042 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<PartitionedLogIteratorSimple> self;
															#line 1049 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Version version;
															#line 6035 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via peekNextVersion()
															#line 1042 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class PartitionedLogIteratorSimple_PeekNextVersionActor final : public Actor<Version>, public ActorCallback< PartitionedLogIteratorSimple_PeekNextVersionActor, 0, Void >, public ActorCallback< PartitionedLogIteratorSimple_PeekNextVersionActor, 1, Void >, public FastAllocated<PartitionedLogIteratorSimple_PeekNextVersionActor>, public PartitionedLogIteratorSimple_PeekNextVersionActorState<PartitionedLogIteratorSimple_PeekNextVersionActor> {
															#line 6040 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<PartitionedLogIteratorSimple_PeekNextVersionActor>::operator new;
	using FastAllocated<PartitionedLogIteratorSimple_PeekNextVersionActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6022981480697513216UL, 4756298562928354560UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Version>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PartitionedLogIteratorSimple_PeekNextVersionActor, 0, Void >;
friend struct ActorCallback< PartitionedLogIteratorSimple_PeekNextVersionActor, 1, Void >;
															#line 1042 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	PartitionedLogIteratorSimple_PeekNextVersionActor(Reference<PartitionedLogIteratorSimple> const& self) 
															#line 6058 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<Version>(),
		   PartitionedLogIteratorSimple_PeekNextVersionActorState<PartitionedLogIteratorSimple_PeekNextVersionActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("peekNextVersion", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3510092154139981056UL, 14174065679173900288UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("peekNextVersion");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("peekNextVersion", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PartitionedLogIteratorSimple_PeekNextVersionActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< PartitionedLogIteratorSimple_PeekNextVersionActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1042 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] Future<Version> PartitionedLogIteratorSimple::peekNextVersion( Reference<PartitionedLogIteratorSimple> const& self ) {
															#line 1042 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Version>(new PartitionedLogIteratorSimple_PeekNextVersionActor(self));
															#line 6091 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 1069 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

															#line 6096 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via getNext()
															#line 1070 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class PartitionedLogIteratorSimple_GetNextActor>
															#line 1070 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class PartitionedLogIteratorSimple_GetNextActorState {
															#line 6102 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 1070 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	PartitionedLogIteratorSimple_GetNextActorState(Reference<PartitionedLogIteratorSimple> const& self) 
															#line 1070 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 1070 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : self(self),
															#line 1072 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   mutations()
															#line 6111 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getNext", reinterpret_cast<unsigned long>(this));

	}
	~PartitionedLogIteratorSimple_GetNextActorState() 
	{
		fdb_probe_actor_destroy("getNext", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1073 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!self->hasNext())
															#line 6126 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			{
															#line 1074 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				TraceEvent(SevWarn, "SimpleIteratorExhausted") .detail("BufferOffset", self->bufferOffset) .detail("BufferSize", self->bufferSize) .detail("Tag", self->tag) .log();
															#line 1079 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				if (!static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)->SAV<Standalone<VectorRef<VersionedMutation>>>::futures) { (void)(mutations); this->~PartitionedLogIteratorSimple_GetNextActorState(); static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)->destroy(); return 0; }
															#line 6132 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
				new (&static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)->SAV< Standalone<VectorRef<VersionedMutation>> >::value()) Standalone<VectorRef<VersionedMutation>>(std::move(mutations)); // state_var_RVO
				this->~PartitionedLogIteratorSimple_GetNextActorState();
				static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 1081 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Version> __when_expr_0 = self->peekNextVersion();
															#line 1081 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6142 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)->actor_wait_state = 1;
															#line 1081 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PartitionedLogIteratorSimple_GetNextActor, 0, Version >*>(static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)));
															#line 6147 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PartitionedLogIteratorSimple_GetNextActorState();
		static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1082 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		Standalone<VectorRef<VersionedMutation>> firstBatch = self->consumeData(firstVersion);
															#line 1083 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		mutations = firstBatch;
															#line 1087 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		;
															#line 6174 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Version const& __firstVersion,int loopDepth) 
	{
															#line 1081 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		firstVersion = __firstVersion;
															#line 6183 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Version && __firstVersion,int loopDepth) 
	{
		firstVersion = std::move(__firstVersion);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)->actor_wait_state > 0) static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)->actor_wait_state = 0;
		static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)->ActorCallback< PartitionedLogIteratorSimple_GetNextActor, 0, Version >::remove();

	}
	void a_callback_fire(ActorCallback< PartitionedLogIteratorSimple_GetNextActor, 0, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("getNext", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNext", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PartitionedLogIteratorSimple_GetNextActor, 0, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("getNext", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNext", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PartitionedLogIteratorSimple_GetNextActor, 0, Version >*,Error err) 
	{
		fdb_probe_actor_enter("getNext", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNext", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 1102 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)->SAV<Standalone<VectorRef<VersionedMutation>>>::futures) { (void)(mutations); this->~PartitionedLogIteratorSimple_GetNextActorState(); static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)->destroy(); return 0; }
															#line 6262 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)->SAV< Standalone<VectorRef<VersionedMutation>> >::value()) Standalone<VectorRef<VersionedMutation>>(std::move(mutations)); // state_var_RVO
		this->~PartitionedLogIteratorSimple_GetNextActorState();
		static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 1087 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!(self->bufferOffset >= self->bufferSize))
															#line 6281 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1090 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (self->hasNext())
															#line 6287 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 1093 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_1 = self->loadNextBlock();
															#line 1093 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6293 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)->actor_wait_state = 2;
															#line 1093 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PartitionedLogIteratorSimple_GetNextActor, 1, Void >*>(static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)));
															#line 6298 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 1094 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		Standalone<VectorRef<VersionedMutation>> batch = self->consumeData(firstVersion);
															#line 1095 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		for( const VersionedMutation& vm : batch ) {
															#line 1096 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			mutations.push_back_deep(mutations.arena(), vm);
															#line 6335 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 1094 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		Standalone<VectorRef<VersionedMutation>> batch = self->consumeData(firstVersion);
															#line 1095 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		for( const VersionedMutation& vm : batch ) {
															#line 1096 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			mutations.push_back_deep(mutations.arena(), vm);
															#line 6349 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)->actor_wait_state > 0) static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)->actor_wait_state = 0;
		static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)->ActorCallback< PartitionedLogIteratorSimple_GetNextActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PartitionedLogIteratorSimple_GetNextActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getNext", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNext", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< PartitionedLogIteratorSimple_GetNextActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getNext", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNext", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< PartitionedLogIteratorSimple_GetNextActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getNext", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNext", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1070 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<PartitionedLogIteratorSimple> self;
															#line 1072 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Standalone<VectorRef<VersionedMutation>> mutations;
															#line 1081 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Version firstVersion;
															#line 6436 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getNext()
															#line 1070 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class PartitionedLogIteratorSimple_GetNextActor final : public Actor<Standalone<VectorRef<VersionedMutation>>>, public ActorCallback< PartitionedLogIteratorSimple_GetNextActor, 0, Version >, public ActorCallback< PartitionedLogIteratorSimple_GetNextActor, 1, Void >, public FastAllocated<PartitionedLogIteratorSimple_GetNextActor>, public PartitionedLogIteratorSimple_GetNextActorState<PartitionedLogIteratorSimple_GetNextActor> {
															#line 6441 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<PartitionedLogIteratorSimple_GetNextActor>::operator new;
	using FastAllocated<PartitionedLogIteratorSimple_GetNextActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17912073783924882944UL, 11664836482154607872UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Standalone<VectorRef<VersionedMutation>>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PartitionedLogIteratorSimple_GetNextActor, 0, Version >;
friend struct ActorCallback< PartitionedLogIteratorSimple_GetNextActor, 1, Void >;
															#line 1070 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	PartitionedLogIteratorSimple_GetNextActor(Reference<PartitionedLogIteratorSimple> const& self) 
															#line 6459 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<Standalone<VectorRef<VersionedMutation>>>(),
		   PartitionedLogIteratorSimple_GetNextActorState<PartitionedLogIteratorSimple_GetNextActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getNext", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17700238840770020608UL, 1654640055383343616UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getNext");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getNext", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PartitionedLogIteratorSimple_GetNextActor, 0, Version >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< PartitionedLogIteratorSimple_GetNextActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1070 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] Future<Standalone<VectorRef<VersionedMutation>>> PartitionedLogIteratorSimple::getNext( Reference<PartitionedLogIteratorSimple> const& self ) {
															#line 1070 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Standalone<VectorRef<VersionedMutation>>>(new PartitionedLogIteratorSimple_GetNextActor(self));
															#line 6492 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 1104 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

Future<Standalone<VectorRef<VersionedMutation>>> PartitionedLogIteratorSimple::getNext() {
	return getNext(Reference<PartitionedLogIteratorSimple>::addRef(this));
}

class PartitionedLogIteratorTwoBuffers : public PartitionedLogIterator {
private:
	Reference<TwoBuffers> twobuffer;

	// consume single version data upto the end of the current batch
	// stop if seeing a different version from the parameter.
	// it has side effects to update bufferOffset after reading the data
	Future<Standalone<VectorRef<VersionedMutation>>> consumeData(Version firstVersion);
																#line 6509 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
[[nodiscard]] static Future<Standalone<VectorRef<VersionedMutation>>> consumeData( Reference<PartitionedLogIteratorTwoBuffers> const& self, Version const& v );
template <class> friend class PartitionedLogIteratorTwoBuffers_ConsumeDataActorState;

#line 1120 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

	// each block has a format of {<header>[mutations]<padding>}, need to skip the header to read mutations
	// this method check if bufferOffset is at the boundary and advance it if necessary
	void removeBlockHeader();

public:
	// read up to a fixed number of block count
	// noted that each version has to be contained within 2 blocks
	const int BATCH_READ_BLOCK_COUNT = 1;
	const int BLOCK_SIZE = CLIENT_KNOBS->BACKUP_LOGFILE_BLOCK_SIZE;
	const int mutationHeaderBytes = sizeof(int64_t) + sizeof(int32_t) + sizeof(int32_t);
	Reference<IBackupContainer> bc;
	int tag;
	std::vector<RestoreConfig::RestoreFile> files;
	std::vector<Version> endVersions;
	bool hasMoreData; // Flag indicating if more data is available
	size_t bufferOffset; // Current read offset
	// empty means no data, future is valid but not ready means being fetched
	// future is ready means it currently holds data

	PartitionedLogIteratorTwoBuffers(Reference<IBackupContainer> _bc,
	                                 int _tag,
	                                 std::vector<RestoreConfig::RestoreFile> _files,
	                                 std::vector<Version> _endVersions);

	// whether there are more contents for this tag in all files specified
	bool hasNext();

	// find the next version without advanding the iterator
	Future<Version> peekNextVersion();
																#line 6544 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
[[nodiscard]] static Future<Version> peekNextVersion( Reference<PartitionedLogIteratorTwoBuffers> const& iterator );
template <class> friend class PartitionedLogIteratorTwoBuffers_PeekNextVersionActorState;

#line 1151 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

	// get all the mutations of next version and advance the iterator
	// this might issue multiple consumeData() if the data of a version cross buffer boundary
	Future<Standalone<VectorRef<VersionedMutation>>> getNext();
																#line 6553 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
[[nodiscard]] static Future<Standalone<VectorRef<VersionedMutation>>> getNext( Reference<PartitionedLogIteratorTwoBuffers> const& iterator );
template <class> friend class PartitionedLogIteratorTwoBuffers_GetNextActorState;

#line 1157 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
};

Future<Standalone<VectorRef<VersionedMutation>>> PartitionedLogIteratorTwoBuffers::consumeData(Version firstVersion) {
	return consumeData(Reference<PartitionedLogIteratorTwoBuffers>::addRef(this), firstVersion);
}

															#line 6564 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via consumeData()
															#line 1163 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class PartitionedLogIteratorTwoBuffers_ConsumeDataActor>
															#line 1163 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class PartitionedLogIteratorTwoBuffers_ConsumeDataActorState {
															#line 6570 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 1163 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	PartitionedLogIteratorTwoBuffers_ConsumeDataActorState(Reference<PartitionedLogIteratorTwoBuffers> const& self,Version const& firstVersion) 
															#line 1163 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 1163 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : self(self),
															#line 1163 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   firstVersion(firstVersion),
															#line 1166 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   mutations(Standalone<VectorRef<VersionedMutation>>())
															#line 6581 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("consumeData", reinterpret_cast<unsigned long>(this));

	}
	~PartitionedLogIteratorTwoBuffers_ConsumeDataActorState() 
	{
		fdb_probe_actor_destroy("consumeData", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1167 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->twobuffer->ready();
															#line 1167 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<PartitionedLogIteratorTwoBuffers_ConsumeDataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6598 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<PartitionedLogIteratorTwoBuffers_ConsumeDataActor*>(this)->actor_wait_state = 1;
															#line 1167 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PartitionedLogIteratorTwoBuffers_ConsumeDataActor, 0, Void >*>(static_cast<PartitionedLogIteratorTwoBuffers_ConsumeDataActor*>(this)));
															#line 6603 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PartitionedLogIteratorTwoBuffers_ConsumeDataActorState();
		static_cast<PartitionedLogIteratorTwoBuffers_ConsumeDataActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1168 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		std::shared_ptr<char[]> start = self->twobuffer->peek();
															#line 1169 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		int size = self->twobuffer->getBufferSize();
															#line 1170 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		bool foundNewVersion = false;
															#line 1171 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		for(;self->bufferOffset < size;) {
															#line 1172 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			for(;self->bufferOffset < size && !endOfBlock(start.get(), self->bufferOffset);) {
															#line 1174 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				self->removeBlockHeader();
															#line 1179 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				Version version;
															#line 1180 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				std::memcpy(&version, start.get() + self->bufferOffset, sizeof(Version));
															#line 1181 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				version = bigEndian64(version);
															#line 1182 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				if (version != firstVersion)
															#line 6644 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
				{
															#line 1183 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
					foundNewVersion = true;
															#line 6648 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
					break;
				}
															#line 1187 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				int32_t subsequence;
															#line 1188 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				std::memcpy(&subsequence, start.get() + self->bufferOffset + sizeof(Version), sizeof(int32_t));
															#line 1189 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				subsequence = bigEndian32(subsequence);
															#line 1191 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				int32_t mutationSize;
															#line 1192 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				std::memcpy( &mutationSize, start.get() + self->bufferOffset + sizeof(Version) + sizeof(int32_t), sizeof(int32_t));
															#line 1194 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				mutationSize = bigEndian32(mutationSize);
															#line 1197 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				size_t mutationTotalSize = self->mutationHeaderBytes + mutationSize;
															#line 1198 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				ASSERT(self->bufferOffset + mutationTotalSize <= size);
															#line 1200 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				Standalone<StringRef> mutationData = makeString(mutationSize);
															#line 1201 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				std::memcpy( mutateString(mutationData), start.get() + self->bufferOffset + self->mutationHeaderBytes, mutationSize);
															#line 1204 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				ArenaReader reader(mutationData.arena(), mutationData, AssumeVersion(g_network->protocolVersion()));
															#line 1205 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				MutationRef mutation;
															#line 1206 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				reader >> mutation;
															#line 1208 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				VersionedMutation vm;
															#line 1209 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				vm.version = version;
															#line 1210 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				vm.subsequence = subsequence;
															#line 1211 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				vm.mutation = mutation;
															#line 1212 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				mutations.push_back_deep(mutations.arena(), vm);
															#line 1214 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				self->bufferOffset += mutationTotalSize;
															#line 6689 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			}
															#line 1217 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (self->bufferOffset < size && endOfBlock(start.get(), self->bufferOffset))
															#line 6693 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			{
															#line 1219 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				int remain = self->BLOCK_SIZE - (self->bufferOffset % self->BLOCK_SIZE);
															#line 1220 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				self->bufferOffset += remain;
															#line 6699 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			}
															#line 1222 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (foundNewVersion)
															#line 6703 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			{
				break;
			}
		}
															#line 1226 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<PartitionedLogIteratorTwoBuffers_ConsumeDataActor*>(this)->SAV<Standalone<VectorRef<VersionedMutation>>>::futures) { (void)(mutations); this->~PartitionedLogIteratorTwoBuffers_ConsumeDataActorState(); static_cast<PartitionedLogIteratorTwoBuffers_ConsumeDataActor*>(this)->destroy(); return 0; }
															#line 6710 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<PartitionedLogIteratorTwoBuffers_ConsumeDataActor*>(this)->SAV< Standalone<VectorRef<VersionedMutation>> >::value()) Standalone<VectorRef<VersionedMutation>>(std::move(mutations)); // state_var_RVO
		this->~PartitionedLogIteratorTwoBuffers_ConsumeDataActorState();
		static_cast<PartitionedLogIteratorTwoBuffers_ConsumeDataActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1168 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		std::shared_ptr<char[]> start = self->twobuffer->peek();
															#line 1169 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		int size = self->twobuffer->getBufferSize();
															#line 1170 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		bool foundNewVersion = false;
															#line 1171 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		for(;self->bufferOffset < size;) {
															#line 1172 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			for(;self->bufferOffset < size && !endOfBlock(start.get(), self->bufferOffset);) {
															#line 1174 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				self->removeBlockHeader();
															#line 1179 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				Version version;
															#line 1180 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				std::memcpy(&version, start.get() + self->bufferOffset, sizeof(Version));
															#line 1181 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				version = bigEndian64(version);
															#line 1182 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				if (version != firstVersion)
															#line 6740 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
				{
															#line 1183 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
					foundNewVersion = true;
															#line 6744 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
					break;
				}
															#line 1187 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				int32_t subsequence;
															#line 1188 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				std::memcpy(&subsequence, start.get() + self->bufferOffset + sizeof(Version), sizeof(int32_t));
															#line 1189 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				subsequence = bigEndian32(subsequence);
															#line 1191 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				int32_t mutationSize;
															#line 1192 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				std::memcpy( &mutationSize, start.get() + self->bufferOffset + sizeof(Version) + sizeof(int32_t), sizeof(int32_t));
															#line 1194 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				mutationSize = bigEndian32(mutationSize);
															#line 1197 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				size_t mutationTotalSize = self->mutationHeaderBytes + mutationSize;
															#line 1198 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				ASSERT(self->bufferOffset + mutationTotalSize <= size);
															#line 1200 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				Standalone<StringRef> mutationData = makeString(mutationSize);
															#line 1201 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				std::memcpy( mutateString(mutationData), start.get() + self->bufferOffset + self->mutationHeaderBytes, mutationSize);
															#line 1204 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				ArenaReader reader(mutationData.arena(), mutationData, AssumeVersion(g_network->protocolVersion()));
															#line 1205 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				MutationRef mutation;
															#line 1206 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				reader >> mutation;
															#line 1208 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				VersionedMutation vm;
															#line 1209 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				vm.version = version;
															#line 1210 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				vm.subsequence = subsequence;
															#line 1211 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				vm.mutation = mutation;
															#line 1212 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				mutations.push_back_deep(mutations.arena(), vm);
															#line 1214 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				self->bufferOffset += mutationTotalSize;
															#line 6785 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			}
															#line 1217 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (self->bufferOffset < size && endOfBlock(start.get(), self->bufferOffset))
															#line 6789 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			{
															#line 1219 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				int remain = self->BLOCK_SIZE - (self->bufferOffset % self->BLOCK_SIZE);
															#line 1220 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				self->bufferOffset += remain;
															#line 6795 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			}
															#line 1222 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (foundNewVersion)
															#line 6799 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			{
				break;
			}
		}
															#line 1226 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<PartitionedLogIteratorTwoBuffers_ConsumeDataActor*>(this)->SAV<Standalone<VectorRef<VersionedMutation>>>::futures) { (void)(mutations); this->~PartitionedLogIteratorTwoBuffers_ConsumeDataActorState(); static_cast<PartitionedLogIteratorTwoBuffers_ConsumeDataActor*>(this)->destroy(); return 0; }
															#line 6806 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<PartitionedLogIteratorTwoBuffers_ConsumeDataActor*>(this)->SAV< Standalone<VectorRef<VersionedMutation>> >::value()) Standalone<VectorRef<VersionedMutation>>(std::move(mutations)); // state_var_RVO
		this->~PartitionedLogIteratorTwoBuffers_ConsumeDataActorState();
		static_cast<PartitionedLogIteratorTwoBuffers_ConsumeDataActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PartitionedLogIteratorTwoBuffers_ConsumeDataActor*>(this)->actor_wait_state > 0) static_cast<PartitionedLogIteratorTwoBuffers_ConsumeDataActor*>(this)->actor_wait_state = 0;
		static_cast<PartitionedLogIteratorTwoBuffers_ConsumeDataActor*>(this)->ActorCallback< PartitionedLogIteratorTwoBuffers_ConsumeDataActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PartitionedLogIteratorTwoBuffers_ConsumeDataActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("consumeData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorTwoBuffers_ConsumeDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consumeData", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PartitionedLogIteratorTwoBuffers_ConsumeDataActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("consumeData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorTwoBuffers_ConsumeDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consumeData", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PartitionedLogIteratorTwoBuffers_ConsumeDataActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("consumeData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorTwoBuffers_ConsumeDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consumeData", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1163 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<PartitionedLogIteratorTwoBuffers> self;
															#line 1163 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Version firstVersion;
															#line 1166 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Standalone<VectorRef<VersionedMutation>> mutations;
															#line 6895 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via consumeData()
															#line 1163 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class PartitionedLogIteratorTwoBuffers_ConsumeDataActor final : public Actor<Standalone<VectorRef<VersionedMutation>>>, public ActorCallback< PartitionedLogIteratorTwoBuffers_ConsumeDataActor, 0, Void >, public FastAllocated<PartitionedLogIteratorTwoBuffers_ConsumeDataActor>, public PartitionedLogIteratorTwoBuffers_ConsumeDataActorState<PartitionedLogIteratorTwoBuffers_ConsumeDataActor> {
															#line 6900 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<PartitionedLogIteratorTwoBuffers_ConsumeDataActor>::operator new;
	using FastAllocated<PartitionedLogIteratorTwoBuffers_ConsumeDataActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15593181385317848064UL, 7509408817767185152UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Standalone<VectorRef<VersionedMutation>>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PartitionedLogIteratorTwoBuffers_ConsumeDataActor, 0, Void >;
															#line 1163 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	PartitionedLogIteratorTwoBuffers_ConsumeDataActor(Reference<PartitionedLogIteratorTwoBuffers> const& self,Version const& firstVersion) 
															#line 6917 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<Standalone<VectorRef<VersionedMutation>>>(),
		   PartitionedLogIteratorTwoBuffers_ConsumeDataActorState<PartitionedLogIteratorTwoBuffers_ConsumeDataActor>(self, firstVersion),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("consumeData", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6208903078462509824UL, 13390363306797634560UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorTwoBuffers_ConsumeDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("consumeData");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("consumeData", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PartitionedLogIteratorTwoBuffers_ConsumeDataActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1163 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] Future<Standalone<VectorRef<VersionedMutation>>> PartitionedLogIteratorTwoBuffers::consumeData( Reference<PartitionedLogIteratorTwoBuffers> const& self, Version const& firstVersion ) {
															#line 1163 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Standalone<VectorRef<VersionedMutation>>>(new PartitionedLogIteratorTwoBuffers_ConsumeDataActor(self, firstVersion));
															#line 6949 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 1228 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

void PartitionedLogIteratorTwoBuffers::removeBlockHeader() {
	if (bufferOffset % BLOCK_SIZE == 0) {
		bufferOffset += sizeof(uint32_t);
	}
}

PartitionedLogIteratorTwoBuffers::PartitionedLogIteratorTwoBuffers(Reference<IBackupContainer> _bc,
                                                                   int _tag,
                                                                   std::vector<RestoreConfig::RestoreFile> _files,
                                                                   std::vector<Version> _endVersions)
  : bc(_bc), tag(_tag), files(std::move(_files)), endVersions(_endVersions), bufferOffset(0) {
	int bufferCapacity = BATCH_READ_BLOCK_COUNT * BLOCK_SIZE;
	twobuffer = makeReference<TwoBuffers>(bufferCapacity, _bc, files, tag);
}

bool PartitionedLogIteratorTwoBuffers::hasNext() {
	return twobuffer->hasNext();
}

Future<Version> PartitionedLogIteratorTwoBuffers::peekNextVersion() {
	return peekNextVersion(Reference<PartitionedLogIteratorTwoBuffers>::addRef(this));
}
															#line 6976 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via peekNextVersion()
															#line 1251 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class PartitionedLogIteratorTwoBuffers_PeekNextVersionActor>
															#line 1251 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class PartitionedLogIteratorTwoBuffers_PeekNextVersionActorState {
															#line 6982 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 1251 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	PartitionedLogIteratorTwoBuffers_PeekNextVersionActorState(Reference<PartitionedLogIteratorTwoBuffers> const& self) 
															#line 1251 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 1251 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : self(self),
															#line 1254 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   start(),
															#line 1255 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   version(),
															#line 1256 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   fileIndex()
															#line 6995 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("peekNextVersion", reinterpret_cast<unsigned long>(this));

	}
	~PartitionedLogIteratorTwoBuffers_PeekNextVersionActorState() 
	{
		fdb_probe_actor_destroy("peekNextVersion", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1257 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!self->hasNext())
															#line 7010 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			{
															#line 1258 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				if (!static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)->SAV<Version>::futures) { (void)(Version(0)); this->~PartitionedLogIteratorTwoBuffers_PeekNextVersionActorState(); static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)->destroy(); return 0; }
															#line 7014 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
				new (&static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)->SAV< Version >::value()) Version(Version(0));
				this->~PartitionedLogIteratorTwoBuffers_PeekNextVersionActorState();
				static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 1260 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->twobuffer->ready();
															#line 1260 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7024 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)->actor_wait_state = 1;
															#line 1260 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PartitionedLogIteratorTwoBuffers_PeekNextVersionActor, 0, Void >*>(static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)));
															#line 7029 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PartitionedLogIteratorTwoBuffers_PeekNextVersionActorState();
		static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1261 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		start = self->twobuffer->peek();
															#line 1262 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->removeBlockHeader();
															#line 1263 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		std::memcpy(&version, start.get() + self->bufferOffset, sizeof(Version));
															#line 1264 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		version = bigEndian64(version);
															#line 1265 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		fileIndex = self->twobuffer->getFileIndex();
															#line 1266 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		;
															#line 7062 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1261 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		start = self->twobuffer->peek();
															#line 1262 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->removeBlockHeader();
															#line 1263 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		std::memcpy(&version, start.get() + self->bufferOffset, sizeof(Version));
															#line 1264 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		version = bigEndian64(version);
															#line 1265 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		fileIndex = self->twobuffer->getFileIndex();
															#line 1266 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		;
															#line 7081 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)->actor_wait_state > 0) static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)->actor_wait_state = 0;
		static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)->ActorCallback< PartitionedLogIteratorTwoBuffers_PeekNextVersionActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PartitionedLogIteratorTwoBuffers_PeekNextVersionActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("peekNextVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("peekNextVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PartitionedLogIteratorTwoBuffers_PeekNextVersionActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("peekNextVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("peekNextVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PartitionedLogIteratorTwoBuffers_PeekNextVersionActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("peekNextVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("peekNextVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 1282 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)->SAV<Version>::futures) { (void)(version); this->~PartitionedLogIteratorTwoBuffers_PeekNextVersionActorState(); static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)->destroy(); return 0; }
															#line 7165 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)->SAV< Version >::value()) Version(std::move(version)); // state_var_RVO
		this->~PartitionedLogIteratorTwoBuffers_PeekNextVersionActorState();
		static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 1266 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!(fileIndex < self->endVersions.size() - 1 && version >= self->endVersions[fileIndex]))
															#line 7184 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1267 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		TraceEvent("RestoreLogFilesFoundOverlapAndSkip") .detail("Version", version) .detail("FileIndex", fileIndex) .log();
															#line 1272 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->twobuffer->reset();
															#line 1273 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->bufferOffset = 0;
															#line 1274 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->twobuffer->setFileIndex(fileIndex + 1);
															#line 1275 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->twobuffer->ready();
															#line 1275 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7200 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)->actor_wait_state = 2;
															#line 1275 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PartitionedLogIteratorTwoBuffers_PeekNextVersionActor, 1, Void >*>(static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)));
															#line 7205 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 1276 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		start = self->twobuffer->peek();
															#line 1277 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->removeBlockHeader();
															#line 1278 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		std::memcpy(&version, start.get() + self->bufferOffset, sizeof(Version));
															#line 1279 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		version = bigEndian64(version);
															#line 1280 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		fileIndex = self->twobuffer->getFileIndex();
															#line 7235 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 1276 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		start = self->twobuffer->peek();
															#line 1277 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->removeBlockHeader();
															#line 1278 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		std::memcpy(&version, start.get() + self->bufferOffset, sizeof(Version));
															#line 1279 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		version = bigEndian64(version);
															#line 1280 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		fileIndex = self->twobuffer->getFileIndex();
															#line 7252 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)->actor_wait_state > 0) static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)->actor_wait_state = 0;
		static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)->ActorCallback< PartitionedLogIteratorTwoBuffers_PeekNextVersionActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PartitionedLogIteratorTwoBuffers_PeekNextVersionActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("peekNextVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("peekNextVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< PartitionedLogIteratorTwoBuffers_PeekNextVersionActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("peekNextVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("peekNextVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< PartitionedLogIteratorTwoBuffers_PeekNextVersionActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("peekNextVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("peekNextVersion", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1251 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<PartitionedLogIteratorTwoBuffers> self;
															#line 1254 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	std::shared_ptr<char[]> start;
															#line 1255 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Version version;
															#line 1256 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	int fileIndex;
															#line 7340 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via peekNextVersion()
															#line 1251 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class PartitionedLogIteratorTwoBuffers_PeekNextVersionActor final : public Actor<Version>, public ActorCallback< PartitionedLogIteratorTwoBuffers_PeekNextVersionActor, 0, Void >, public ActorCallback< PartitionedLogIteratorTwoBuffers_PeekNextVersionActor, 1, Void >, public FastAllocated<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor>, public PartitionedLogIteratorTwoBuffers_PeekNextVersionActorState<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor> {
															#line 7345 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor>::operator new;
	using FastAllocated<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6022981480697513216UL, 4756298562928354560UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Version>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PartitionedLogIteratorTwoBuffers_PeekNextVersionActor, 0, Void >;
friend struct ActorCallback< PartitionedLogIteratorTwoBuffers_PeekNextVersionActor, 1, Void >;
															#line 1251 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	PartitionedLogIteratorTwoBuffers_PeekNextVersionActor(Reference<PartitionedLogIteratorTwoBuffers> const& self) 
															#line 7363 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<Version>(),
		   PartitionedLogIteratorTwoBuffers_PeekNextVersionActorState<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("peekNextVersion", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(868233047335415808UL, 8756626667062018304UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("peekNextVersion");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("peekNextVersion", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PartitionedLogIteratorTwoBuffers_PeekNextVersionActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< PartitionedLogIteratorTwoBuffers_PeekNextVersionActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1251 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] Future<Version> PartitionedLogIteratorTwoBuffers::peekNextVersion( Reference<PartitionedLogIteratorTwoBuffers> const& self ) {
															#line 1251 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Version>(new PartitionedLogIteratorTwoBuffers_PeekNextVersionActor(self));
															#line 7396 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 1284 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

															#line 7401 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via getNext()
															#line 1285 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class PartitionedLogIteratorTwoBuffers_GetNextActor>
															#line 1285 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class PartitionedLogIteratorTwoBuffers_GetNextActorState {
															#line 7407 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 1285 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	PartitionedLogIteratorTwoBuffers_GetNextActorState(Reference<PartitionedLogIteratorTwoBuffers> const& self) 
															#line 1285 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 1285 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : self(self),
															#line 1287 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   mutations()
															#line 7416 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getNext", reinterpret_cast<unsigned long>(this));

	}
	~PartitionedLogIteratorTwoBuffers_GetNextActorState() 
	{
		fdb_probe_actor_destroy("getNext", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1288 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!self->hasNext())
															#line 7431 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			{
															#line 1289 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				TraceEvent(SevWarn, "IteratorExhausted").log();
															#line 1290 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				if (!static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->SAV<Standalone<VectorRef<VersionedMutation>>>::futures) { (void)(mutations); this->~PartitionedLogIteratorTwoBuffers_GetNextActorState(); static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->destroy(); return 0; }
															#line 7437 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
				new (&static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->SAV< Standalone<VectorRef<VersionedMutation>> >::value()) Standalone<VectorRef<VersionedMutation>>(std::move(mutations)); // state_var_RVO
				this->~PartitionedLogIteratorTwoBuffers_GetNextActorState();
				static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 1292 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Version> __when_expr_0 = self->peekNextVersion();
															#line 1292 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7447 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->actor_wait_state = 1;
															#line 1292 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 0, Version >*>(static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)));
															#line 7452 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PartitionedLogIteratorTwoBuffers_GetNextActorState();
		static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1294 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Standalone<VectorRef<VersionedMutation>>> __when_expr_1 = self->consumeData(firstVersion);
															#line 1294 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7477 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->actor_wait_state = 2;
															#line 1294 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 1, Standalone<VectorRef<VersionedMutation>> >*>(static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)));
															#line 7482 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Version const& __firstVersion,int loopDepth) 
	{
															#line 1292 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		firstVersion = __firstVersion;
															#line 7491 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Version && __firstVersion,int loopDepth) 
	{
		firstVersion = std::move(__firstVersion);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->actor_wait_state > 0) static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->actor_wait_state = 0;
		static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 0, Version >::remove();

	}
	void a_callback_fire(ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 0, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("getNext", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNext", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 0, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("getNext", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNext", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 0, Version >*,Error err) 
	{
		fdb_probe_actor_enter("getNext", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNext", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(Standalone<VectorRef<VersionedMutation>> const& firstBatch,int loopDepth) 
	{
															#line 1295 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		mutations = firstBatch;
															#line 1298 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		;
															#line 7572 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont3loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Standalone<VectorRef<VersionedMutation>> && firstBatch,int loopDepth) 
	{
															#line 1295 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		mutations = firstBatch;
															#line 1298 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		;
															#line 7583 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont3loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Standalone<VectorRef<VersionedMutation>> const& firstBatch,int loopDepth) 
	{
		loopDepth = a_body1cont3(firstBatch, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Standalone<VectorRef<VersionedMutation>> && firstBatch,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(firstBatch), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->actor_wait_state > 0) static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->actor_wait_state = 0;
		static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 1, Standalone<VectorRef<VersionedMutation>> >::remove();

	}
	void a_callback_fire(ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 1, Standalone<VectorRef<VersionedMutation>> >*,Standalone<VectorRef<VersionedMutation>> const& value) 
	{
		fdb_probe_actor_enter("getNext", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNext", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 1, Standalone<VectorRef<VersionedMutation>> >*,Standalone<VectorRef<VersionedMutation>> && value) 
	{
		fdb_probe_actor_enter("getNext", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNext", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 1, Standalone<VectorRef<VersionedMutation>> >*,Error err) 
	{
		fdb_probe_actor_enter("getNext", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNext", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 1318 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->SAV<Standalone<VectorRef<VersionedMutation>>>::futures) { (void)(mutations); this->~PartitionedLogIteratorTwoBuffers_GetNextActorState(); static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->destroy(); return 0; }
															#line 7667 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->SAV< Standalone<VectorRef<VersionedMutation>> >::value()) Standalone<VectorRef<VersionedMutation>>(std::move(mutations)); // state_var_RVO
		this->~PartitionedLogIteratorTwoBuffers_GetNextActorState();
		static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont3loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1(int loopDepth) 
	{
															#line 1298 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!(self->bufferOffset >= self->twobuffer->getBufferSize()))
															#line 7686 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
			return a_body1cont3break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1299 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->twobuffer->discardAndSwap();
															#line 1300 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->bufferOffset = 0;
															#line 1303 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (self->twobuffer->hasNext())
															#line 7696 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 1306 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Version> __when_expr_2 = self->peekNextVersion();
															#line 1306 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7702 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont3loopBody1when1(__when_expr_2.get(), loopDepth); };
			static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->actor_wait_state = 3;
															#line 1306 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 2, Version >*>(static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)));
															#line 7707 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			return a_body1cont3break1(loopDepth==0?0:loopDepth-1); // break
		}

		return loopDepth;
	}
	int a_body1cont3break1(int loopDepth) 
	{
		try {
			return a_body1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont3(Version const& nextVersion,int loopDepth) 
	{
															#line 1307 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (nextVersion != firstVersion)
															#line 7740 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
			return a_body1cont3break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1310 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Standalone<VectorRef<VersionedMutation>>> __when_expr_3 = self->consumeData(firstVersion);
															#line 1310 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7748 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont3loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->actor_wait_state = 4;
															#line 1310 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 3, Standalone<VectorRef<VersionedMutation>> >*>(static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)));
															#line 7753 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3loopBody1cont3(Version && nextVersion,int loopDepth) 
	{
															#line 1307 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (nextVersion != firstVersion)
															#line 7762 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
			return a_body1cont3break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1310 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Standalone<VectorRef<VersionedMutation>>> __when_expr_3 = self->consumeData(firstVersion);
															#line 1310 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7770 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont3loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->actor_wait_state = 4;
															#line 1310 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 3, Standalone<VectorRef<VersionedMutation>> >*>(static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)));
															#line 7775 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3loopBody1when1(Version const& nextVersion,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont3(nextVersion, loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1when1(Version && nextVersion,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont3(std::move(nextVersion), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->actor_wait_state > 0) static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->actor_wait_state = 0;
		static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 2, Version >::remove();

	}
	void a_callback_fire(ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 2, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("getNext", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNext", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 2, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("getNext", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNext", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 2, Version >*,Error err) 
	{
		fdb_probe_actor_enter("getNext", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNext", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont3loopBody1cont4(Standalone<VectorRef<VersionedMutation>> const& batch,int loopDepth) 
	{
															#line 1311 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		for( const VersionedMutation& vm : batch ) {
															#line 1312 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			mutations.push_back_deep(mutations.arena(), vm);
															#line 7861 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont3loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont4(Standalone<VectorRef<VersionedMutation>> && batch,int loopDepth) 
	{
															#line 1311 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		for( const VersionedMutation& vm : batch ) {
															#line 1312 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			mutations.push_back_deep(mutations.arena(), vm);
															#line 7873 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont3loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont3when1(Standalone<VectorRef<VersionedMutation>> const& batch,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont4(batch, loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont3when1(Standalone<VectorRef<VersionedMutation>> && batch,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont4(std::move(batch), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->actor_wait_state > 0) static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->actor_wait_state = 0;
		static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 3, Standalone<VectorRef<VersionedMutation>> >::remove();

	}
	void a_callback_fire(ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 3, Standalone<VectorRef<VersionedMutation>> >*,Standalone<VectorRef<VersionedMutation>> const& value) 
	{
		fdb_probe_actor_enter("getNext", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNext", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 3, Standalone<VectorRef<VersionedMutation>> >*,Standalone<VectorRef<VersionedMutation>> && value) 
	{
		fdb_probe_actor_enter("getNext", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNext", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 3, Standalone<VectorRef<VersionedMutation>> >*,Error err) 
	{
		fdb_probe_actor_enter("getNext", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNext", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 1285 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<PartitionedLogIteratorTwoBuffers> self;
															#line 1287 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Standalone<VectorRef<VersionedMutation>> mutations;
															#line 1292 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Version firstVersion;
															#line 7960 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getNext()
															#line 1285 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class PartitionedLogIteratorTwoBuffers_GetNextActor final : public Actor<Standalone<VectorRef<VersionedMutation>>>, public ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 0, Version >, public ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 1, Standalone<VectorRef<VersionedMutation>> >, public ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 2, Version >, public ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 3, Standalone<VectorRef<VersionedMutation>> >, public FastAllocated<PartitionedLogIteratorTwoBuffers_GetNextActor>, public PartitionedLogIteratorTwoBuffers_GetNextActorState<PartitionedLogIteratorTwoBuffers_GetNextActor> {
															#line 7965 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<PartitionedLogIteratorTwoBuffers_GetNextActor>::operator new;
	using FastAllocated<PartitionedLogIteratorTwoBuffers_GetNextActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17912073783924882944UL, 11664836482154607872UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Standalone<VectorRef<VersionedMutation>>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 0, Version >;
friend struct ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 1, Standalone<VectorRef<VersionedMutation>> >;
friend struct ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 2, Version >;
friend struct ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 3, Standalone<VectorRef<VersionedMutation>> >;
															#line 1285 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	PartitionedLogIteratorTwoBuffers_GetNextActor(Reference<PartitionedLogIteratorTwoBuffers> const& self) 
															#line 7985 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<Standalone<VectorRef<VersionedMutation>>>(),
		   PartitionedLogIteratorTwoBuffers_GetNextActorState<PartitionedLogIteratorTwoBuffers_GetNextActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getNext", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10518556646101966592UL, 11765083271327665664UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getNext");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getNext", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 0, Version >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 1, Standalone<VectorRef<VersionedMutation>> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 2, Version >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 3, Standalone<VectorRef<VersionedMutation>> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1285 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] Future<Standalone<VectorRef<VersionedMutation>>> PartitionedLogIteratorTwoBuffers::getNext( Reference<PartitionedLogIteratorTwoBuffers> const& self ) {
															#line 1285 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Standalone<VectorRef<VersionedMutation>>>(new PartitionedLogIteratorTwoBuffers_GetNextActor(self));
															#line 8020 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 1320 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

Future<Standalone<VectorRef<VersionedMutation>>> PartitionedLogIteratorTwoBuffers::getNext() {
	return getNext(Reference<PartitionedLogIteratorTwoBuffers>::addRef(this));
}

FileBackupAgent::FileBackupAgent()
  : subspace(Subspace(fileBackupPrefixRange.begin))
    // The other subspaces have logUID -> value
    ,
    config(subspace.get(BackupAgentBase::keyConfig)), lastRestorable(subspace.get(FileBackupAgent::keyLastRestorable)),
    taskBucket(new TaskBucket(subspace.get(BackupAgentBase::keyTasks),
                              AccessSystemKeys::True,
                              PriorityBatch::False,
                              LockAware::True)),
    futureBucket(new FutureBucket(subspace.get(BackupAgentBase::keyFutures), AccessSystemKeys::True, LockAware::True)) {
}

namespace fileBackup {

// Return a block of contiguous padding bytes, growing if needed.
Value makePadding(int size) {
	static Value pad;
	if (pad.size() < size) {
		pad = makeString(size);
		memset(mutateString(pad), '\xff', pad.size());
	}

	return pad.substr(0, size);
}

struct IRangeFileWriter {
public:
	virtual Future<Void> padEnd(bool final) = 0;

	virtual Future<Void> writeKV(Key k, Value v) = 0;

	virtual Future<Void> writeKey(Key k) = 0;

	virtual Future<Void> finish() = 0;

	virtual ~IRangeFileWriter() {}
};

// File Format handlers.
// Both Range and Log formats are designed to be readable starting at any BACKUP_RANGEFILE_BLOCK_SIZE boundary
// so they can be read in parallel.
//
// Writer instances must be kept alive while any member actors are in progress.
//
// RangeFileWriter must be used as follows:
//   1 - writeKey(key) the queried key range begin
//   2 - writeKV(k, v) each kv pair to restore
//   3 - writeKey(key) the queried key range end
//	 4 - finish()
//
// RangeFileWriter will insert the required padding, header, and extra
// end/begin keys around the 1MB boundaries as needed.
//
// Example:
//   The range a-z is queries and returns c-j which covers 3 blocks.
//   The client code writes keys in this sequence:
//             a c d e f g h i j z
//
//   H = header   P = padding   a...z = keys  v = value | = block boundary
//
//   Encoded file:  H a cv dv ev P | H e ev fv gv hv P | H h hv iv jv z
//   Decoded in blocks yields:
//           Block 1: range [a, e) with kv pairs cv, dv
//           Block 2: range [e, h) with kv pairs ev, fv, gv
//           Block 3: range [h, z) with kv pairs hv, iv, jv
//
//   NOTE: All blocks except for the final block will have one last
//   value which will not be used.  This isn't actually a waste since
//   if the next KV pair wouldn't fit within the block after the value
//   then the space after the final key to the next 1MB boundary would
//   just be padding anyway.
struct RangeFileWriter : public IRangeFileWriter {
	RangeFileWriter(Reference<IBackupFile> file = Reference<IBackupFile>(), int blockSize = 0)
	  : file(file), blockSize(blockSize), blockEnd(0), fileVersion(BACKUP_AGENT_SNAPSHOT_FILE_VERSION) {}

	// Handles the first block and internal blocks.  Ends current block if needed.
	// The final flag is used in simulation to pad the file's final block to a whole block size
																#line 8106 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via newBlock()
															#line 1402 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class NewBlockActor>
															#line 1402 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class NewBlockActorState {
															#line 8112 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 1402 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	NewBlockActorState(RangeFileWriter* const& self,int const& bytesNeeded,bool const& final = false) 
															#line 1402 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 1402 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : self(self),
															#line 1402 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   bytesNeeded(bytesNeeded),
															#line 1402 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   final(final)
															#line 8123 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("newBlock", reinterpret_cast<unsigned long>(this));

	}
	~NewBlockActorState() 
	{
		fdb_probe_actor_destroy("newBlock", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1404 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			int bytesLeft = self->blockEnd - self->file->size();
															#line 1405 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (bytesLeft > 0)
															#line 8140 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			{
															#line 1406 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				paddingFFs = makePadding(bytesLeft);
															#line 1407 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				StrictFuture<Void> __when_expr_0 = self->file->append(paddingFFs.begin(), bytesLeft);
															#line 1407 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				if (static_cast<NewBlockActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8148 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<NewBlockActor*>(this)->actor_wait_state = 1;
															#line 1407 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< NewBlockActor, 0, Void >*>(static_cast<NewBlockActor*>(this)));
															#line 8153 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~NewBlockActorState();
		static_cast<NewBlockActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1410 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (final)
															#line 8181 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 1411 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			ASSERT(g_network->isSimulated());
															#line 1412 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!static_cast<NewBlockActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~NewBlockActorState(); static_cast<NewBlockActor*>(this)->destroy(); return 0; }
															#line 8187 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			new (&static_cast<NewBlockActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~NewBlockActorState();
			static_cast<NewBlockActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1416 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->blockEnd += self->blockSize;
															#line 1419 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->file->append((uint8_t*)&self->fileVersion, sizeof(self->fileVersion));
															#line 1419 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<NewBlockActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8199 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<NewBlockActor*>(this)->actor_wait_state = 2;
															#line 1419 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< NewBlockActor, 1, Void >*>(static_cast<NewBlockActor*>(this)));
															#line 8204 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<NewBlockActor*>(this)->actor_wait_state > 0) static_cast<NewBlockActor*>(this)->actor_wait_state = 0;
		static_cast<NewBlockActor*>(this)->ActorCallback< NewBlockActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< NewBlockActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("newBlock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NewBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newBlock", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< NewBlockActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("newBlock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NewBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newBlock", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< NewBlockActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("newBlock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<NewBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newBlock", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 1422 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (self->blockEnd > self->blockSize)
															#line 8300 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 1423 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_2 = self->file->appendStringRefWithLen(self->lastKey);
															#line 1423 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<NewBlockActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8306 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
			static_cast<NewBlockActor*>(this)->actor_wait_state = 3;
															#line 1423 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< NewBlockActor, 2, Void >*>(static_cast<NewBlockActor*>(this)));
															#line 8311 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont5(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 1422 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (self->blockEnd > self->blockSize)
															#line 8325 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 1423 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_2 = self->file->appendStringRefWithLen(self->lastKey);
															#line 1423 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<NewBlockActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8331 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
			static_cast<NewBlockActor*>(this)->actor_wait_state = 3;
															#line 1423 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< NewBlockActor, 2, Void >*>(static_cast<NewBlockActor*>(this)));
															#line 8336 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont5(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<NewBlockActor*>(this)->actor_wait_state > 0) static_cast<NewBlockActor*>(this)->actor_wait_state = 0;
		static_cast<NewBlockActor*>(this)->ActorCallback< NewBlockActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< NewBlockActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("newBlock", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NewBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newBlock", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< NewBlockActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("newBlock", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NewBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newBlock", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< NewBlockActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("newBlock", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<NewBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newBlock", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(int loopDepth) 
	{
															#line 1429 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (self->file->size() + bytesNeeded > self->blockEnd)
															#line 8425 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 1430 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			return a_body1Catch1(backup_bad_block_size(), loopDepth);
															#line 8429 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
															#line 1432 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<NewBlockActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~NewBlockActorState(); static_cast<NewBlockActor*>(this)->destroy(); return 0; }
															#line 8433 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<NewBlockActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~NewBlockActorState();
		static_cast<NewBlockActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 1424 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_3 = self->file->appendStringRefWithLen(self->lastKey);
															#line 1424 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<NewBlockActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8447 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont6when1(__when_expr_3.get(), loopDepth); };
		static_cast<NewBlockActor*>(this)->actor_wait_state = 4;
															#line 1424 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< NewBlockActor, 3, Void >*>(static_cast<NewBlockActor*>(this)));
															#line 8452 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 1424 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_3 = self->file->appendStringRefWithLen(self->lastKey);
															#line 1424 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<NewBlockActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8463 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont6when1(__when_expr_3.get(), loopDepth); };
		static_cast<NewBlockActor*>(this)->actor_wait_state = 4;
															#line 1424 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< NewBlockActor, 3, Void >*>(static_cast<NewBlockActor*>(this)));
															#line 8468 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<NewBlockActor*>(this)->actor_wait_state > 0) static_cast<NewBlockActor*>(this)->actor_wait_state = 0;
		static_cast<NewBlockActor*>(this)->ActorCallback< NewBlockActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< NewBlockActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("newBlock", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NewBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newBlock", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< NewBlockActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("newBlock", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NewBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newBlock", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< NewBlockActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("newBlock", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<NewBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newBlock", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont7(Void const& _,int loopDepth) 
	{
															#line 1425 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_4 = self->file->appendStringRefWithLen(self->lastValue);
															#line 1425 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<NewBlockActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8554 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont7when1(__when_expr_4.get(), loopDepth); };
		static_cast<NewBlockActor*>(this)->actor_wait_state = 5;
															#line 1425 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< NewBlockActor, 4, Void >*>(static_cast<NewBlockActor*>(this)));
															#line 8559 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7(Void && _,int loopDepth) 
	{
															#line 1425 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_4 = self->file->appendStringRefWithLen(self->lastValue);
															#line 1425 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<NewBlockActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8570 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont7when1(__when_expr_4.get(), loopDepth); };
		static_cast<NewBlockActor*>(this)->actor_wait_state = 5;
															#line 1425 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< NewBlockActor, 4, Void >*>(static_cast<NewBlockActor*>(this)));
															#line 8575 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<NewBlockActor*>(this)->actor_wait_state > 0) static_cast<NewBlockActor*>(this)->actor_wait_state = 0;
		static_cast<NewBlockActor*>(this)->ActorCallback< NewBlockActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< NewBlockActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("newBlock", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NewBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newBlock", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< NewBlockActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("newBlock", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NewBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newBlock", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< NewBlockActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("newBlock", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<NewBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newBlock", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont8(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont8(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont7when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont7when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<NewBlockActor*>(this)->actor_wait_state > 0) static_cast<NewBlockActor*>(this)->actor_wait_state = 0;
		static_cast<NewBlockActor*>(this)->ActorCallback< NewBlockActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< NewBlockActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("newBlock", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NewBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newBlock", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< NewBlockActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("newBlock", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NewBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newBlock", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< NewBlockActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("newBlock", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<NewBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newBlock", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 1402 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	RangeFileWriter* self;
															#line 1402 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	int bytesNeeded;
															#line 1402 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	bool final;
															#line 1406 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Value paddingFFs;
															#line 8750 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via newBlock()
															#line 1402 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class NewBlockActor final : public Actor<Void>, public ActorCallback< NewBlockActor, 0, Void >, public ActorCallback< NewBlockActor, 1, Void >, public ActorCallback< NewBlockActor, 2, Void >, public ActorCallback< NewBlockActor, 3, Void >, public ActorCallback< NewBlockActor, 4, Void >, public FastAllocated<NewBlockActor>, public NewBlockActorState<NewBlockActor> {
															#line 8755 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<NewBlockActor>::operator new;
	using FastAllocated<NewBlockActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9153441743620621568UL, 5741102198931670016UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< NewBlockActor, 0, Void >;
friend struct ActorCallback< NewBlockActor, 1, Void >;
friend struct ActorCallback< NewBlockActor, 2, Void >;
friend struct ActorCallback< NewBlockActor, 3, Void >;
friend struct ActorCallback< NewBlockActor, 4, Void >;
															#line 1402 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	NewBlockActor(RangeFileWriter* const& self,int const& bytesNeeded,bool const& final = false) 
															#line 8776 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   NewBlockActorState<NewBlockActor>(self, bytesNeeded, final),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("newBlock", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11473969930622856192UL, 2275173024393763072UL);
		ActorExecutionContextHelper __helper(static_cast<NewBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("newBlock");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("newBlock", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< NewBlockActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< NewBlockActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< NewBlockActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< NewBlockActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< NewBlockActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1402 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] static Future<Void> newBlock( RangeFileWriter* const& self, int const& bytesNeeded, bool const& final = false ) {
															#line 1402 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Void>(new NewBlockActor(self, bytesNeeded, final));
															#line 8812 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 1434 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

	// Used in simulation only to create backup file sizes which are an integer multiple of the block size
	Future<Void> padEnd(bool final) {
		ASSERT(g_network->isSimulated());
		if (file->size() > 0) {
			return newBlock(this, 0, final);
		}
		return Void();
	}

	// Ends the current block if necessary based on bytesNeeded.
	Future<Void> newBlockIfNeeded(int bytesNeeded) {
		if (file->size() + bytesNeeded > blockEnd)
			return newBlock(this, bytesNeeded);
		return Void();
	}

	// Start a new block if needed, then write the key and value
																#line 8834 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via writeKV_impl()
															#line 1452 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class WriteKV_implActor>
															#line 1452 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class WriteKV_implActorState {
															#line 8840 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 1452 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	WriteKV_implActorState(RangeFileWriter* const& self,Key const& k,Value const& v) 
															#line 1452 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 1452 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : self(self),
															#line 1452 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   k(k),
															#line 1452 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   v(v)
															#line 8851 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("writeKV_impl", reinterpret_cast<unsigned long>(this));

	}
	~WriteKV_implActorState() 
	{
		fdb_probe_actor_destroy("writeKV_impl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1453 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			int toWrite = sizeof(int32_t) + k.size() + sizeof(int32_t) + v.size();
															#line 1454 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->newBlockIfNeeded(toWrite);
															#line 1454 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<WriteKV_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8870 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<WriteKV_implActor*>(this)->actor_wait_state = 1;
															#line 1454 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WriteKV_implActor, 0, Void >*>(static_cast<WriteKV_implActor*>(this)));
															#line 8875 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WriteKV_implActorState();
		static_cast<WriteKV_implActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1455 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->file->appendStringRefWithLen(k);
															#line 1455 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<WriteKV_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8900 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<WriteKV_implActor*>(this)->actor_wait_state = 2;
															#line 1455 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WriteKV_implActor, 1, Void >*>(static_cast<WriteKV_implActor*>(this)));
															#line 8905 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1455 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->file->appendStringRefWithLen(k);
															#line 1455 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<WriteKV_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8916 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<WriteKV_implActor*>(this)->actor_wait_state = 2;
															#line 1455 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WriteKV_implActor, 1, Void >*>(static_cast<WriteKV_implActor*>(this)));
															#line 8921 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WriteKV_implActor*>(this)->actor_wait_state > 0) static_cast<WriteKV_implActor*>(this)->actor_wait_state = 0;
		static_cast<WriteKV_implActor*>(this)->ActorCallback< WriteKV_implActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteKV_implActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WriteKV_implActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WriteKV_implActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 1456 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_2 = self->file->appendStringRefWithLen(v);
															#line 1456 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<WriteKV_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9007 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<WriteKV_implActor*>(this)->actor_wait_state = 3;
															#line 1456 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WriteKV_implActor, 2, Void >*>(static_cast<WriteKV_implActor*>(this)));
															#line 9012 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 1456 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_2 = self->file->appendStringRefWithLen(v);
															#line 1456 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<WriteKV_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9023 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<WriteKV_implActor*>(this)->actor_wait_state = 3;
															#line 1456 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WriteKV_implActor, 2, Void >*>(static_cast<WriteKV_implActor*>(this)));
															#line 9028 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WriteKV_implActor*>(this)->actor_wait_state > 0) static_cast<WriteKV_implActor*>(this)->actor_wait_state = 0;
		static_cast<WriteKV_implActor*>(this)->ActorCallback< WriteKV_implActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteKV_implActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WriteKV_implActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WriteKV_implActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 1457 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->lastKey = k;
															#line 1458 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->lastValue = v;
															#line 1459 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<WriteKV_implActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WriteKV_implActorState(); static_cast<WriteKV_implActor*>(this)->destroy(); return 0; }
															#line 9116 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<WriteKV_implActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WriteKV_implActorState();
		static_cast<WriteKV_implActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 1457 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->lastKey = k;
															#line 1458 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->lastValue = v;
															#line 1459 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<WriteKV_implActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WriteKV_implActorState(); static_cast<WriteKV_implActor*>(this)->destroy(); return 0; }
															#line 9132 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<WriteKV_implActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WriteKV_implActorState();
		static_cast<WriteKV_implActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<WriteKV_implActor*>(this)->actor_wait_state > 0) static_cast<WriteKV_implActor*>(this)->actor_wait_state = 0;
		static_cast<WriteKV_implActor*>(this)->ActorCallback< WriteKV_implActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteKV_implActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< WriteKV_implActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< WriteKV_implActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 1452 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	RangeFileWriter* self;
															#line 1452 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Key k;
															#line 1452 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Value v;
															#line 9221 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via writeKV_impl()
															#line 1452 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class WriteKV_implActor final : public Actor<Void>, public ActorCallback< WriteKV_implActor, 0, Void >, public ActorCallback< WriteKV_implActor, 1, Void >, public ActorCallback< WriteKV_implActor, 2, Void >, public FastAllocated<WriteKV_implActor>, public WriteKV_implActorState<WriteKV_implActor> {
															#line 9226 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<WriteKV_implActor>::operator new;
	using FastAllocated<WriteKV_implActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4540230450836218112UL, 15717187571763045376UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WriteKV_implActor, 0, Void >;
friend struct ActorCallback< WriteKV_implActor, 1, Void >;
friend struct ActorCallback< WriteKV_implActor, 2, Void >;
															#line 1452 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	WriteKV_implActor(RangeFileWriter* const& self,Key const& k,Value const& v) 
															#line 9245 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   WriteKV_implActorState<WriteKV_implActor>(self, k, v),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12331643623674153728UL, 17746951694630343424UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("writeKV_impl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WriteKV_implActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WriteKV_implActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< WriteKV_implActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1452 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] static Future<Void> writeKV_impl( RangeFileWriter* const& self, Key const& k, Value const& v ) {
															#line 1452 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Void>(new WriteKV_implActor(self, k, v));
															#line 9279 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 1461 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

	Future<Void> writeKV(Key k, Value v) { return writeKV_impl(this, k, v); }

	// Write begin key or end key.
																#line 9287 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via writeKey_impl()
															#line 1465 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class WriteKey_implActor>
															#line 1465 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class WriteKey_implActorState {
															#line 9293 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 1465 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	WriteKey_implActorState(RangeFileWriter* const& self,Key const& k) 
															#line 1465 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 1465 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : self(self),
															#line 1465 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   k(k)
															#line 9302 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("writeKey_impl", reinterpret_cast<unsigned long>(this));

	}
	~WriteKey_implActorState() 
	{
		fdb_probe_actor_destroy("writeKey_impl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1466 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			int toWrite = sizeof(uint32_t) + k.size();
															#line 1467 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->newBlockIfNeeded(toWrite);
															#line 1467 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<WriteKey_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9321 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<WriteKey_implActor*>(this)->actor_wait_state = 1;
															#line 1467 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WriteKey_implActor, 0, Void >*>(static_cast<WriteKey_implActor*>(this)));
															#line 9326 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WriteKey_implActorState();
		static_cast<WriteKey_implActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1468 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->file->appendStringRefWithLen(k);
															#line 1468 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<WriteKey_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9351 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<WriteKey_implActor*>(this)->actor_wait_state = 2;
															#line 1468 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WriteKey_implActor, 1, Void >*>(static_cast<WriteKey_implActor*>(this)));
															#line 9356 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1468 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->file->appendStringRefWithLen(k);
															#line 1468 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<WriteKey_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9367 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<WriteKey_implActor*>(this)->actor_wait_state = 2;
															#line 1468 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WriteKey_implActor, 1, Void >*>(static_cast<WriteKey_implActor*>(this)));
															#line 9372 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WriteKey_implActor*>(this)->actor_wait_state > 0) static_cast<WriteKey_implActor*>(this)->actor_wait_state = 0;
		static_cast<WriteKey_implActor*>(this)->ActorCallback< WriteKey_implActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteKey_implActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeKey_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKey_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKey_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WriteKey_implActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeKey_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKey_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKey_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WriteKey_implActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeKey_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKey_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKey_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 1469 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<WriteKey_implActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WriteKey_implActorState(); static_cast<WriteKey_implActor*>(this)->destroy(); return 0; }
															#line 9456 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<WriteKey_implActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WriteKey_implActorState();
		static_cast<WriteKey_implActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 1469 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<WriteKey_implActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WriteKey_implActorState(); static_cast<WriteKey_implActor*>(this)->destroy(); return 0; }
															#line 9468 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<WriteKey_implActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WriteKey_implActorState();
		static_cast<WriteKey_implActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WriteKey_implActor*>(this)->actor_wait_state > 0) static_cast<WriteKey_implActor*>(this)->actor_wait_state = 0;
		static_cast<WriteKey_implActor*>(this)->ActorCallback< WriteKey_implActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteKey_implActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeKey_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKey_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKey_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WriteKey_implActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeKey_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKey_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKey_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WriteKey_implActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeKey_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKey_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKey_impl", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1465 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	RangeFileWriter* self;
															#line 1465 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Key k;
															#line 9555 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via writeKey_impl()
															#line 1465 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class WriteKey_implActor final : public Actor<Void>, public ActorCallback< WriteKey_implActor, 0, Void >, public ActorCallback< WriteKey_implActor, 1, Void >, public FastAllocated<WriteKey_implActor>, public WriteKey_implActorState<WriteKey_implActor> {
															#line 9560 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<WriteKey_implActor>::operator new;
	using FastAllocated<WriteKey_implActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2413186177573209088UL, 2014698029399872768UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WriteKey_implActor, 0, Void >;
friend struct ActorCallback< WriteKey_implActor, 1, Void >;
															#line 1465 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	WriteKey_implActor(RangeFileWriter* const& self,Key const& k) 
															#line 9578 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   WriteKey_implActorState<WriteKey_implActor>(self, k),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("writeKey_impl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(551483992183075584UL, 8902642963360461568UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKey_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("writeKey_impl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("writeKey_impl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WriteKey_implActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WriteKey_implActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1465 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] static Future<Void> writeKey_impl( RangeFileWriter* const& self, Key const& k ) {
															#line 1465 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Void>(new WriteKey_implActor(self, k));
															#line 9611 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 1471 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

	Future<Void> writeKey(Key k) { return writeKey_impl(this, k); }

	Future<Void> finish() { return Void(); }

	Reference<IBackupFile> file;
	int blockSize;

private:
	int64_t blockEnd;
	uint32_t fileVersion;
	Key lastKey;
	Key lastValue;
};

void decodeKVPairs(StringRefReader* reader, Standalone<VectorRef<KeyValueRef>>* results) {
	// Read begin key, if this fails then block was invalid.
	uint32_t kLen = reader->consumeNetworkUInt32();
	const uint8_t* k = reader->consume(kLen);
	results->push_back(results->arena(), KeyValueRef(KeyRef(k, kLen), ValueRef()));
	KeyRef prevKey = KeyRef(k, kLen);
	// Read kv pairs and end key
	while (1) {
		// Read a key.
		kLen = reader->consumeNetworkUInt32();
		k = reader->consume(kLen);

		// If eof reached or first value len byte is 0xFF then a valid block end was reached.
		if (reader->eof() || *reader->rptr == 0xFF) {
			results->push_back(results->arena(), KeyValueRef(KeyRef(k, kLen), ValueRef()));
			break;
		}

		// Read a value, which must exist or the block is invalid
		uint32_t vLen = reader->consumeNetworkUInt32();
		const uint8_t* v = reader->consume(vLen);

		results->push_back(results->arena(), KeyValueRef(KeyRef(k, kLen), ValueRef(v, vLen)));

		// If eof reached or first byte of next key len is 0xFF then a valid block end was reached.
		if (reader->eof() || *reader->rptr == 0xFF)
			break;
	}

	// Make sure any remaining bytes in the block are 0xFF
	for (auto b : reader->remainder())
		if (b != 0xFF)
			throw restore_corrupted_data_padding();
}

static Reference<IBackupContainer> getBackupContainerWithProxy(Reference<IBackupContainer> _bc) {
	Reference<IBackupContainer> bc = IBackupContainer::openContainer(_bc->getURL(), fileBackupAgentProxy, {});
	return bc;
}

Standalone<VectorRef<KeyValueRef>> decodeRangeFileBlock(const Standalone<StringRef>& buf) {
	Standalone<VectorRef<KeyValueRef>> results({}, buf.arena());
	StringRefReader reader(buf, restore_corrupted_data());

	// Read header, currently only decoding BACKUP_AGENT_SNAPSHOT_FILE_VERSION
	if (reader.consume<int32_t>() != BACKUP_AGENT_SNAPSHOT_FILE_VERSION)
		throw restore_unsupported_file_version();

	// Read begin key, if this fails then block was invalid.
	uint32_t beginKeyLen = reader.consumeNetworkUInt32();
	const uint8_t* beginKey = reader.consume(beginKeyLen);
	results.push_back(results.arena(), KeyValueRef(KeyRef(beginKey, beginKeyLen), ValueRef()));

	// Read kv pairs and end key
	while (1) {
		// If eof reached or first value len byte is 0xFF then a valid block end was reached.
		if (reader.eof() || *reader.rptr == 0xFF) {
			break;
		}

		// Read a key, which must exist or the block is invalid
		uint32_t kLen = reader.consumeNetworkUInt32();
		const uint8_t* k = reader.consume(kLen);

		// If eof reached or first value len byte is 0xFF then a valid block end was reached.
		if (reader.eof() || *reader.rptr == 0xFF) {
			// The last block in the file, will have Read End key.
			results.push_back(results.arena(), KeyValueRef(KeyRef(k, kLen), ValueRef()));
			break;
		}

		// Read a value, which must exist or the block is invalid
		uint32_t vLen = reader.consumeNetworkUInt32();
		const uint8_t* v = reader.consume(vLen);
		results.push_back(results.arena(), KeyValueRef(KeyRef(k, kLen), ValueRef(v, vLen)));
	}

	// Make sure any remaining bytes in the block are 0xFF
	for (auto b : reader.remainder())
		if (b != 0xFF)
			throw restore_corrupted_data_padding();

	return results;
}

															#line 9715 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via decodeRangeFileBlock()
															#line 1571 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class DecodeRangeFileBlockActor>
															#line 1571 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class DecodeRangeFileBlockActorState {
															#line 9721 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 1571 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	DecodeRangeFileBlockActorState(Reference<IAsyncFile> const& file,int64_t const& offset,int const& len,Database const& cx) 
															#line 1571 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 1571 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : file(file),
															#line 1571 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   offset(offset),
															#line 1571 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   len(len),
															#line 1571 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   cx(cx),
															#line 1575 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   buf(makeString(len))
															#line 9736 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("decodeRangeFileBlock", reinterpret_cast<unsigned long>(this));

	}
	~DecodeRangeFileBlockActorState() 
	{
		fdb_probe_actor_destroy("decodeRangeFileBlock", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1576 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<int> __when_expr_0 = uncancellable(holdWhile(buf, file->read(mutateString(buf), len, offset)));
															#line 1576 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<DecodeRangeFileBlockActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9753 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DecodeRangeFileBlockActor*>(this)->actor_wait_state = 1;
															#line 1576 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DecodeRangeFileBlockActor, 0, int >*>(static_cast<DecodeRangeFileBlockActor*>(this)));
															#line 9758 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DecodeRangeFileBlockActorState();
		static_cast<DecodeRangeFileBlockActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int const& rLen,int loopDepth) 
	{
															#line 1577 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (rLen != len)
															#line 9781 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 1578 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			return a_body1Catch1(restore_bad_read(), loopDepth);
															#line 9785 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
															#line 1580 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		simulateBlobFailure();
															#line 1582 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		results = Standalone<VectorRef<KeyValueRef>>({}, buf.arena());
															#line 1583 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		reader = StringRefReader(buf, restore_corrupted_data());
															#line 1584 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		arena = Arena();
															#line 1585 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		blockDomainId = -1;
															#line 9797 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		try {
															#line 1588 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			int32_t file_version = reader.consume<int32_t>();
															#line 1589 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (file_version != BACKUP_AGENT_SNAPSHOT_FILE_VERSION)
															#line 9803 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			{
															#line 1590 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				return a_body1cont1Catch1(restore_unsupported_file_version(), loopDepth);
															#line 9807 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			}
															#line 1592 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			decodeKVPairs(&reader, &results);
															#line 1593 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!static_cast<DecodeRangeFileBlockActor*>(this)->SAV<Standalone<VectorRef<KeyValueRef>>>::futures) { (void)(results); this->~DecodeRangeFileBlockActorState(); static_cast<DecodeRangeFileBlockActor*>(this)->destroy(); return 0; }
															#line 9813 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			new (&static_cast<DecodeRangeFileBlockActor*>(this)->SAV< Standalone<VectorRef<KeyValueRef>> >::value()) Standalone<VectorRef<KeyValueRef>>(std::move(results)); // state_var_RVO
			this->~DecodeRangeFileBlockActorState();
			static_cast<DecodeRangeFileBlockActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(int && rLen,int loopDepth) 
	{
															#line 1577 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (rLen != len)
															#line 9831 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 1578 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			return a_body1Catch1(restore_bad_read(), loopDepth);
															#line 9835 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
															#line 1580 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		simulateBlobFailure();
															#line 1582 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		results = Standalone<VectorRef<KeyValueRef>>({}, buf.arena());
															#line 1583 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		reader = StringRefReader(buf, restore_corrupted_data());
															#line 1584 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		arena = Arena();
															#line 1585 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		blockDomainId = -1;
															#line 9847 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		try {
															#line 1588 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			int32_t file_version = reader.consume<int32_t>();
															#line 1589 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (file_version != BACKUP_AGENT_SNAPSHOT_FILE_VERSION)
															#line 9853 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			{
															#line 1590 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				return a_body1cont1Catch1(restore_unsupported_file_version(), loopDepth);
															#line 9857 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			}
															#line 1592 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			decodeKVPairs(&reader, &results);
															#line 1593 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!static_cast<DecodeRangeFileBlockActor*>(this)->SAV<Standalone<VectorRef<KeyValueRef>>>::futures) { (void)(results); this->~DecodeRangeFileBlockActorState(); static_cast<DecodeRangeFileBlockActor*>(this)->destroy(); return 0; }
															#line 9863 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			new (&static_cast<DecodeRangeFileBlockActor*>(this)->SAV< Standalone<VectorRef<KeyValueRef>> >::value()) Standalone<VectorRef<KeyValueRef>>(std::move(results)); // state_var_RVO
			this->~DecodeRangeFileBlockActorState();
			static_cast<DecodeRangeFileBlockActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(int const& rLen,int loopDepth) 
	{
		loopDepth = a_body1cont1(rLen, loopDepth);

		return loopDepth;
	}
	int a_body1when1(int && rLen,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(rLen), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DecodeRangeFileBlockActor*>(this)->actor_wait_state > 0) static_cast<DecodeRangeFileBlockActor*>(this)->actor_wait_state = 0;
		static_cast<DecodeRangeFileBlockActor*>(this)->ActorCallback< DecodeRangeFileBlockActor, 0, int >::remove();

	}
	void a_callback_fire(ActorCallback< DecodeRangeFileBlockActor, 0, int >*,int const& value) 
	{
		fdb_probe_actor_enter("decodeRangeFileBlock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DecodeRangeFileBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("decodeRangeFileBlock", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DecodeRangeFileBlockActor, 0, int >*,int && value) 
	{
		fdb_probe_actor_enter("decodeRangeFileBlock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DecodeRangeFileBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("decodeRangeFileBlock", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DecodeRangeFileBlockActor, 0, int >*,Error err) 
	{
		fdb_probe_actor_enter("decodeRangeFileBlock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DecodeRangeFileBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("decodeRangeFileBlock", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1595 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			TraceEvent(SevWarn, "FileRestoreDecodeRangeFileBlockFailed") .error(e) .detail("Filename", file->getFilename()) .detail("BlockOffset", offset) .detail("BlockLen", len) .detail("ErrorRelativeOffset", reader.rptr - buf.begin()) .detail("ErrorAbsoluteOffset", reader.rptr - buf.begin() + offset);
															#line 1602 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 9959 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 1571 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<IAsyncFile> file;
															#line 1571 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	int64_t offset;
															#line 1571 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	int len;
															#line 1571 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Database cx;
															#line 1575 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Standalone<StringRef> buf;
															#line 1582 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Standalone<VectorRef<KeyValueRef>> results;
															#line 1583 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	StringRefReader reader;
															#line 1584 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Arena arena;
															#line 1585 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	int64_t blockDomainId;
															#line 9987 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via decodeRangeFileBlock()
															#line 1571 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class DecodeRangeFileBlockActor final : public Actor<Standalone<VectorRef<KeyValueRef>>>, public ActorCallback< DecodeRangeFileBlockActor, 0, int >, public FastAllocated<DecodeRangeFileBlockActor>, public DecodeRangeFileBlockActorState<DecodeRangeFileBlockActor> {
															#line 9992 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<DecodeRangeFileBlockActor>::operator new;
	using FastAllocated<DecodeRangeFileBlockActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9150861275632937216UL, 13103159751882158080UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Standalone<VectorRef<KeyValueRef>>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DecodeRangeFileBlockActor, 0, int >;
															#line 1571 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	DecodeRangeFileBlockActor(Reference<IAsyncFile> const& file,int64_t const& offset,int const& len,Database const& cx) 
															#line 10009 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<Standalone<VectorRef<KeyValueRef>>>(),
		   DecodeRangeFileBlockActorState<DecodeRangeFileBlockActor>(file, offset, len, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("decodeRangeFileBlock", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16131528145190661120UL, 4810314581124466176UL);
		ActorExecutionContextHelper __helper(static_cast<DecodeRangeFileBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("decodeRangeFileBlock");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("decodeRangeFileBlock", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DecodeRangeFileBlockActor, 0, int >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1571 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] Future<Standalone<VectorRef<KeyValueRef>>> decodeRangeFileBlock( Reference<IAsyncFile> const& file, int64_t const& offset, int const& len, Database const& cx ) {
															#line 1571 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Standalone<VectorRef<KeyValueRef>>>(new DecodeRangeFileBlockActor(file, offset, len, cx));
															#line 10041 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 1605 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

// Very simple format compared to KeyRange files.
// Header, [Key, Value]... Key len
struct LogFileWriter {
	LogFileWriter(Reference<IBackupFile> file = Reference<IBackupFile>(), int blockSize = 0)
	  : file(file), blockSize(blockSize), blockEnd(0) {}

	// Start a new block if needed, then write the key and value
																#line 10053 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via writeKV_impl()
															#line 1613 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class WriteKV_implActor1>
															#line 1613 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class WriteKV_implActor1State {
															#line 10059 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 1613 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	WriteKV_implActor1State(LogFileWriter* const& self,Key const& k,Value const& v) 
															#line 1613 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 1613 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : self(self),
															#line 1613 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   k(k),
															#line 1613 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   v(v)
															#line 10070 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("writeKV_impl", reinterpret_cast<unsigned long>(this));

	}
	~WriteKV_implActor1State() 
	{
		fdb_probe_actor_destroy("writeKV_impl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1615 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			int toWrite = sizeof(int32_t) + k.size() + sizeof(int32_t) + v.size();
															#line 1616 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (self->file->size() + toWrite > self->blockEnd)
															#line 10087 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			{
															#line 1618 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				int bytesLeft = self->blockEnd - self->file->size();
															#line 1619 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				if (bytesLeft > 0)
															#line 10093 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
				{
															#line 1620 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
					paddingFFs = makePadding(bytesLeft);
															#line 1621 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
					StrictFuture<Void> __when_expr_0 = self->file->append(paddingFFs.begin(), bytesLeft);
															#line 1621 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
					if (static_cast<WriteKV_implActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10101 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
					if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
					static_cast<WriteKV_implActor1*>(this)->actor_wait_state = 1;
															#line 1621 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
					__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WriteKV_implActor1, 0, Void >*>(static_cast<WriteKV_implActor1*>(this)));
															#line 10106 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
					loopDepth = 0;
				}
				else
				{
					loopDepth = a_body1cont2(loopDepth);
				}
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WriteKV_implActor1State();
		static_cast<WriteKV_implActor1*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1631 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_2 = self->file->appendStringRefWithLen(k);
															#line 1631 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<WriteKV_implActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10141 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<WriteKV_implActor1*>(this)->actor_wait_state = 3;
															#line 1631 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WriteKV_implActor1, 2, Void >*>(static_cast<WriteKV_implActor1*>(this)));
															#line 10146 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 1625 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->blockEnd += self->blockSize;
															#line 1628 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->file->append((uint8_t*)&BACKUP_AGENT_MLOG_VERSION, sizeof(BACKUP_AGENT_MLOG_VERSION));
															#line 1628 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<WriteKV_implActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10159 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<WriteKV_implActor1*>(this)->actor_wait_state = 2;
															#line 1628 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WriteKV_implActor1, 1, Void >*>(static_cast<WriteKV_implActor1*>(this)));
															#line 10164 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WriteKV_implActor1*>(this)->actor_wait_state > 0) static_cast<WriteKV_implActor1*>(this)->actor_wait_state = 0;
		static_cast<WriteKV_implActor1*>(this)->ActorCallback< WriteKV_implActor1, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteKV_implActor1, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WriteKV_implActor1, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WriteKV_implActor1, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WriteKV_implActor1*>(this)->actor_wait_state > 0) static_cast<WriteKV_implActor1*>(this)->actor_wait_state = 0;
		static_cast<WriteKV_implActor1*>(this)->ActorCallback< WriteKV_implActor1, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteKV_implActor1, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WriteKV_implActor1, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WriteKV_implActor1, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 1632 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_3 = self->file->appendStringRefWithLen(v);
															#line 1632 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<WriteKV_implActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10349 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont5when1(__when_expr_3.get(), loopDepth); };
		static_cast<WriteKV_implActor1*>(this)->actor_wait_state = 4;
															#line 1632 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< WriteKV_implActor1, 3, Void >*>(static_cast<WriteKV_implActor1*>(this)));
															#line 10354 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 1632 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_3 = self->file->appendStringRefWithLen(v);
															#line 1632 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<WriteKV_implActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10365 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont5when1(__when_expr_3.get(), loopDepth); };
		static_cast<WriteKV_implActor1*>(this)->actor_wait_state = 4;
															#line 1632 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< WriteKV_implActor1, 3, Void >*>(static_cast<WriteKV_implActor1*>(this)));
															#line 10370 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<WriteKV_implActor1*>(this)->actor_wait_state > 0) static_cast<WriteKV_implActor1*>(this)->actor_wait_state = 0;
		static_cast<WriteKV_implActor1*>(this)->ActorCallback< WriteKV_implActor1, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteKV_implActor1, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< WriteKV_implActor1, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< WriteKV_implActor1, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 1635 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (self->file->size() > self->blockEnd)
															#line 10454 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 1636 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			return a_body1Catch1(backup_bad_block_size(), loopDepth);
															#line 10458 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
															#line 1638 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<WriteKV_implActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WriteKV_implActor1State(); static_cast<WriteKV_implActor1*>(this)->destroy(); return 0; }
															#line 10462 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<WriteKV_implActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~WriteKV_implActor1State();
		static_cast<WriteKV_implActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 1635 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (self->file->size() > self->blockEnd)
															#line 10474 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 1636 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			return a_body1Catch1(backup_bad_block_size(), loopDepth);
															#line 10478 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
															#line 1638 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<WriteKV_implActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WriteKV_implActor1State(); static_cast<WriteKV_implActor1*>(this)->destroy(); return 0; }
															#line 10482 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<WriteKV_implActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~WriteKV_implActor1State();
		static_cast<WriteKV_implActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<WriteKV_implActor1*>(this)->actor_wait_state > 0) static_cast<WriteKV_implActor1*>(this)->actor_wait_state = 0;
		static_cast<WriteKV_implActor1*>(this)->ActorCallback< WriteKV_implActor1, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteKV_implActor1, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< WriteKV_implActor1, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< WriteKV_implActor1, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 1613 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	LogFileWriter* self;
															#line 1613 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Key k;
															#line 1613 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Value v;
															#line 1620 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Value paddingFFs;
															#line 10573 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via writeKV_impl()
															#line 1613 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class WriteKV_implActor1 final : public Actor<Void>, public ActorCallback< WriteKV_implActor1, 0, Void >, public ActorCallback< WriteKV_implActor1, 1, Void >, public ActorCallback< WriteKV_implActor1, 2, Void >, public ActorCallback< WriteKV_implActor1, 3, Void >, public FastAllocated<WriteKV_implActor1>, public WriteKV_implActor1State<WriteKV_implActor1> {
															#line 10578 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<WriteKV_implActor1>::operator new;
	using FastAllocated<WriteKV_implActor1>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4540230450836218112UL, 15717187571763045376UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WriteKV_implActor1, 0, Void >;
friend struct ActorCallback< WriteKV_implActor1, 1, Void >;
friend struct ActorCallback< WriteKV_implActor1, 2, Void >;
friend struct ActorCallback< WriteKV_implActor1, 3, Void >;
															#line 1613 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	WriteKV_implActor1(LogFileWriter* const& self,Key const& k,Value const& v) 
															#line 10598 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   WriteKV_implActor1State<WriteKV_implActor1>(self, k, v),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16217267337946238464UL, 13255526101699148288UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("writeKV_impl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WriteKV_implActor1, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WriteKV_implActor1, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< WriteKV_implActor1, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< WriteKV_implActor1, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1613 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] static Future<Void> writeKV_impl( LogFileWriter* const& self, Key const& k, Value const& v ) {
															#line 1613 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Void>(new WriteKV_implActor1(self, k, v));
															#line 10633 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 1640 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

	Future<Void> writeKV(Key k, Value v) { return writeKV_impl(this, k, v); }

	Reference<IBackupFile> file;
	int blockSize;

private:
	int64_t blockEnd;
};

// input: a string of [param1, param2], [param1, param2] ..., [param1, param2]
// output: a vector of [param1, param2] after removing the length info
Standalone<VectorRef<KeyValueRef>> decodeMutationLogFileBlock(const Standalone<StringRef>& buf) {
	Standalone<VectorRef<KeyValueRef>> results({}, buf.arena());
	StringRefReader reader(buf, restore_corrupted_data());

	// Read header, currently only decoding version BACKUP_AGENT_MLOG_VERSION
	if (reader.consume<int32_t>() != BACKUP_AGENT_MLOG_VERSION)
		throw restore_unsupported_file_version();

	// Read k/v pairs.  Block ends either at end of last value exactly or with 0xFF as first key len byte.
	while (1) {
		// If eof reached or first key len bytes is 0xFF then end of block was reached.
		if (reader.eof() || *reader.rptr == 0xFF)
			break;

		// Read key and value.  If anything throws then there is a problem.
		uint32_t kLen = reader.consumeNetworkUInt32();
		const uint8_t* k = reader.consume(kLen);
		uint32_t vLen = reader.consumeNetworkUInt32();
		const uint8_t* v = reader.consume(vLen);

		results.push_back(results.arena(), KeyValueRef(KeyRef(k, kLen), ValueRef(v, vLen)));
	}

	// Make sure any remaining bytes in the block are 0xFF
	for (auto b : reader.remainder())
		if (b != 0xFF)
			throw restore_corrupted_data_padding();

	return results;
}

															#line 10680 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via decodeMutationLogFileBlock()
															#line 1683 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class DecodeMutationLogFileBlockActor>
															#line 1683 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class DecodeMutationLogFileBlockActorState {
															#line 10686 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 1683 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	DecodeMutationLogFileBlockActorState(Reference<IAsyncFile> const& file,int64_t const& offset,int const& len) 
															#line 1683 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 1683 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : file(file),
															#line 1683 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   offset(offset),
															#line 1683 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   len(len),
															#line 1686 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   buf(makeString(len))
															#line 10699 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("decodeMutationLogFileBlock", reinterpret_cast<unsigned long>(this));

	}
	~DecodeMutationLogFileBlockActorState() 
	{
		fdb_probe_actor_destroy("decodeMutationLogFileBlock", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1687 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<int> __when_expr_0 = file->read(mutateString(buf), len, offset);
															#line 1687 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<DecodeMutationLogFileBlockActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10716 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DecodeMutationLogFileBlockActor*>(this)->actor_wait_state = 1;
															#line 1687 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DecodeMutationLogFileBlockActor, 0, int >*>(static_cast<DecodeMutationLogFileBlockActor*>(this)));
															#line 10721 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DecodeMutationLogFileBlockActorState();
		static_cast<DecodeMutationLogFileBlockActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int const& rLen,int loopDepth) 
	{
															#line 1688 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (rLen != len)
															#line 10744 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 1689 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			return a_body1Catch1(restore_bad_read(), loopDepth);
															#line 10748 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
		try {
															#line 1692 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!static_cast<DecodeMutationLogFileBlockActor*>(this)->SAV<Standalone<VectorRef<KeyValueRef>>>::futures) { (void)(decodeMutationLogFileBlock(buf)); this->~DecodeMutationLogFileBlockActorState(); static_cast<DecodeMutationLogFileBlockActor*>(this)->destroy(); return 0; }
															#line 10753 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			new (&static_cast<DecodeMutationLogFileBlockActor*>(this)->SAV< Standalone<VectorRef<KeyValueRef>> >::value()) Standalone<VectorRef<KeyValueRef>>(decodeMutationLogFileBlock(buf));
			this->~DecodeMutationLogFileBlockActorState();
			static_cast<DecodeMutationLogFileBlockActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(int && rLen,int loopDepth) 
	{
															#line 1688 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (rLen != len)
															#line 10771 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 1689 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			return a_body1Catch1(restore_bad_read(), loopDepth);
															#line 10775 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
		try {
															#line 1692 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!static_cast<DecodeMutationLogFileBlockActor*>(this)->SAV<Standalone<VectorRef<KeyValueRef>>>::futures) { (void)(decodeMutationLogFileBlock(buf)); this->~DecodeMutationLogFileBlockActorState(); static_cast<DecodeMutationLogFileBlockActor*>(this)->destroy(); return 0; }
															#line 10780 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			new (&static_cast<DecodeMutationLogFileBlockActor*>(this)->SAV< Standalone<VectorRef<KeyValueRef>> >::value()) Standalone<VectorRef<KeyValueRef>>(decodeMutationLogFileBlock(buf));
			this->~DecodeMutationLogFileBlockActorState();
			static_cast<DecodeMutationLogFileBlockActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(int const& rLen,int loopDepth) 
	{
		loopDepth = a_body1cont1(rLen, loopDepth);

		return loopDepth;
	}
	int a_body1when1(int && rLen,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(rLen), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DecodeMutationLogFileBlockActor*>(this)->actor_wait_state > 0) static_cast<DecodeMutationLogFileBlockActor*>(this)->actor_wait_state = 0;
		static_cast<DecodeMutationLogFileBlockActor*>(this)->ActorCallback< DecodeMutationLogFileBlockActor, 0, int >::remove();

	}
	void a_callback_fire(ActorCallback< DecodeMutationLogFileBlockActor, 0, int >*,int const& value) 
	{
		fdb_probe_actor_enter("decodeMutationLogFileBlock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DecodeMutationLogFileBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("decodeMutationLogFileBlock", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DecodeMutationLogFileBlockActor, 0, int >*,int && value) 
	{
		fdb_probe_actor_enter("decodeMutationLogFileBlock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DecodeMutationLogFileBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("decodeMutationLogFileBlock", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DecodeMutationLogFileBlockActor, 0, int >*,Error err) 
	{
		fdb_probe_actor_enter("decodeMutationLogFileBlock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DecodeMutationLogFileBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("decodeMutationLogFileBlock", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1694 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			TraceEvent(SevWarn, "FileRestoreCorruptLogFileBlock") .error(e) .detail("Filename", file->getFilename()) .detail("BlockOffset", offset) .detail("BlockLen", len);
															#line 1699 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 10876 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 1683 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<IAsyncFile> file;
															#line 1683 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	int64_t offset;
															#line 1683 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	int len;
															#line 1686 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Standalone<StringRef> buf;
															#line 10894 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via decodeMutationLogFileBlock()
															#line 1683 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class DecodeMutationLogFileBlockActor final : public Actor<Standalone<VectorRef<KeyValueRef>>>, public ActorCallback< DecodeMutationLogFileBlockActor, 0, int >, public FastAllocated<DecodeMutationLogFileBlockActor>, public DecodeMutationLogFileBlockActorState<DecodeMutationLogFileBlockActor> {
															#line 10899 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<DecodeMutationLogFileBlockActor>::operator new;
	using FastAllocated<DecodeMutationLogFileBlockActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6550658940338161152UL, 5531750897386469632UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Standalone<VectorRef<KeyValueRef>>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DecodeMutationLogFileBlockActor, 0, int >;
															#line 1683 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	DecodeMutationLogFileBlockActor(Reference<IAsyncFile> const& file,int64_t const& offset,int const& len) 
															#line 10916 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<Standalone<VectorRef<KeyValueRef>>>(),
		   DecodeMutationLogFileBlockActorState<DecodeMutationLogFileBlockActor>(file, offset, len),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("decodeMutationLogFileBlock", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10553348071887031296UL, 14129820410599961600UL);
		ActorExecutionContextHelper __helper(static_cast<DecodeMutationLogFileBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("decodeMutationLogFileBlock");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("decodeMutationLogFileBlock", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DecodeMutationLogFileBlockActor, 0, int >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1683 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] Future<Standalone<VectorRef<KeyValueRef>>> decodeMutationLogFileBlock( Reference<IAsyncFile> const& file, int64_t const& offset, int const& len ) {
															#line 1683 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Standalone<VectorRef<KeyValueRef>>>(new DecodeMutationLogFileBlockActor(file, offset, len));
															#line 10948 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 1702 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

															#line 10953 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via checkTaskVersion()
															#line 1703 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class CheckTaskVersionActor>
															#line 1703 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class CheckTaskVersionActorState {
															#line 10959 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 1703 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	CheckTaskVersionActorState(Database const& cx,Reference<Task> const& task,StringRef const& name,uint32_t const& version) 
															#line 1703 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 1703 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : cx(cx),
															#line 1703 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   task(task),
															#line 1703 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   name(name),
															#line 1703 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   version(version)
															#line 10972 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("checkTaskVersion", reinterpret_cast<unsigned long>(this));

	}
	~CheckTaskVersionActorState() 
	{
		fdb_probe_actor_destroy("checkTaskVersion", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1704 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			uint32_t taskVersion = task->getVersion();
															#line 1705 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (taskVersion > version)
															#line 10989 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			{
															#line 1706 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				err = task_invalid_version();
															#line 1708 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				TraceEvent(SevWarn, "BA_BackupRangeTaskFuncExecute") .detail("TaskVersion", taskVersion) .detail("Name", name) .detail("Version", version);
															#line 1712 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				if (KeyBackedTaskConfig::TaskParams.uid().exists(task))
															#line 10997 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
				{
															#line 1713 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
					std::string msg = format("%s task version `%lu' is greater than supported version `%lu'", task->params[Task::reservedTaskParamKeyType].toString().c_str(), (unsigned long)taskVersion, (unsigned long)version);
															#line 1717 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
					StrictFuture<Void> __when_expr_0 = BackupConfig(task).logError(cx, err, msg);
															#line 1717 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
					if (static_cast<CheckTaskVersionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11005 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
					if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
					static_cast<CheckTaskVersionActor*>(this)->actor_wait_state = 1;
															#line 1717 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
					__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckTaskVersionActor, 0, Void >*>(static_cast<CheckTaskVersionActor*>(this)));
															#line 11010 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
					loopDepth = 0;
				}
				else
				{
					loopDepth = a_body1cont2(loopDepth);
				}
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckTaskVersionActorState();
		static_cast<CheckTaskVersionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1723 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<CheckTaskVersionActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckTaskVersionActorState(); static_cast<CheckTaskVersionActor*>(this)->destroy(); return 0; }
															#line 11043 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<CheckTaskVersionActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CheckTaskVersionActorState();
		static_cast<CheckTaskVersionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 1720 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		return a_body1Catch1(err, loopDepth);
															#line 11055 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckTaskVersionActor*>(this)->actor_wait_state > 0) static_cast<CheckTaskVersionActor*>(this)->actor_wait_state = 0;
		static_cast<CheckTaskVersionActor*>(this)->ActorCallback< CheckTaskVersionActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckTaskVersionActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkTaskVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckTaskVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkTaskVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckTaskVersionActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkTaskVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckTaskVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkTaskVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckTaskVersionActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkTaskVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckTaskVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkTaskVersion", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1703 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Database cx;
															#line 1703 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<Task> task;
															#line 1703 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	StringRef name;
															#line 1703 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	uint32_t version;
															#line 1706 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Error err;
															#line 11156 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via checkTaskVersion()
															#line 1703 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class CheckTaskVersionActor final : public Actor<Void>, public ActorCallback< CheckTaskVersionActor, 0, Void >, public FastAllocated<CheckTaskVersionActor>, public CheckTaskVersionActorState<CheckTaskVersionActor> {
															#line 11161 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<CheckTaskVersionActor>::operator new;
	using FastAllocated<CheckTaskVersionActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6140405245305934848UL, 4423809629576681472UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckTaskVersionActor, 0, Void >;
															#line 1703 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	CheckTaskVersionActor(Database const& cx,Reference<Task> const& task,StringRef const& name,uint32_t const& version) 
															#line 11178 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   CheckTaskVersionActorState<CheckTaskVersionActor>(cx, task, name, version),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkTaskVersion", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3362756845853264896UL, 17854206522136534528UL);
		ActorExecutionContextHelper __helper(static_cast<CheckTaskVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkTaskVersion");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkTaskVersion", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckTaskVersionActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1703 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] Future<Void> checkTaskVersion( Database const& cx, Reference<Task> const& task, StringRef const& name, uint32_t const& version ) {
															#line 1703 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Void>(new CheckTaskVersionActor(cx, task, name, version));
															#line 11210 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 1725 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

															#line 11215 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via abortFiveZeroBackup()
															#line 1726 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class AbortFiveZeroBackupActor>
															#line 1726 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class AbortFiveZeroBackupActorState {
															#line 11221 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 1726 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	AbortFiveZeroBackupActorState(FileBackupAgent* const& backupAgent,Reference<ReadYourWritesTransaction> const& tr,std::string const& tagName) 
															#line 1726 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 1726 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : backupAgent(backupAgent),
															#line 1726 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   tr(tr),
															#line 1726 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   tagName(tagName)
															#line 11232 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("abortFiveZeroBackup", reinterpret_cast<unsigned long>(this));

	}
	~AbortFiveZeroBackupActorState() 
	{
		fdb_probe_actor_destroy("abortFiveZeroBackup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1729 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 1730 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 1732 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tagNames = backupAgent->subspace.get(BackupAgentBase::keyTagName);
															#line 1733 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr->get(tagNames.pack(Key(tagName)));
															#line 1733 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<AbortFiveZeroBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11255 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<AbortFiveZeroBackupActor*>(this)->actor_wait_state = 1;
															#line 1733 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< AbortFiveZeroBackupActor, 0, Optional<Value> >*>(static_cast<AbortFiveZeroBackupActor*>(this)));
															#line 11260 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~AbortFiveZeroBackupActorState();
		static_cast<AbortFiveZeroBackupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> const& uidStr,int loopDepth) 
	{
															#line 1734 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!uidStr.present())
															#line 11283 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 1735 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			TraceEvent(SevWarn, "FileBackupAbortIncompatibleBackup_TagNotFound").detail("TagName", tagName.c_str());
															#line 1736 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!static_cast<AbortFiveZeroBackupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~AbortFiveZeroBackupActorState(); static_cast<AbortFiveZeroBackupActor*>(this)->destroy(); return 0; }
															#line 11289 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			new (&static_cast<AbortFiveZeroBackupActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~AbortFiveZeroBackupActorState();
			static_cast<AbortFiveZeroBackupActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1738 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		uid = BinaryReader::fromStringRef<UID>(uidStr.get(), Unversioned());
															#line 1740 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		statusSpace = backupAgent->subspace.get(BackupAgentBase::keyStates).get(uid.toString());
															#line 1741 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		globalConfig = backupAgent->subspace.get(BackupAgentBase::keyConfig).get(uid.toString());
															#line 1742 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		newConfigSpace = uidPrefixKey("uid->config/"_sr.withPrefix(fileBackupPrefixRange.begin), uid);
															#line 1744 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_1 = tr->get(statusSpace.pack(FileBackupAgent::keyStateStatus));
															#line 1744 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<AbortFiveZeroBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11307 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<AbortFiveZeroBackupActor*>(this)->actor_wait_state = 2;
															#line 1744 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< AbortFiveZeroBackupActor, 1, Optional<Value> >*>(static_cast<AbortFiveZeroBackupActor*>(this)));
															#line 11312 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> && uidStr,int loopDepth) 
	{
															#line 1734 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!uidStr.present())
															#line 11321 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 1735 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			TraceEvent(SevWarn, "FileBackupAbortIncompatibleBackup_TagNotFound").detail("TagName", tagName.c_str());
															#line 1736 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!static_cast<AbortFiveZeroBackupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~AbortFiveZeroBackupActorState(); static_cast<AbortFiveZeroBackupActor*>(this)->destroy(); return 0; }
															#line 11327 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			new (&static_cast<AbortFiveZeroBackupActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~AbortFiveZeroBackupActorState();
			static_cast<AbortFiveZeroBackupActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1738 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		uid = BinaryReader::fromStringRef<UID>(uidStr.get(), Unversioned());
															#line 1740 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		statusSpace = backupAgent->subspace.get(BackupAgentBase::keyStates).get(uid.toString());
															#line 1741 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		globalConfig = backupAgent->subspace.get(BackupAgentBase::keyConfig).get(uid.toString());
															#line 1742 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		newConfigSpace = uidPrefixKey("uid->config/"_sr.withPrefix(fileBackupPrefixRange.begin), uid);
															#line 1744 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_1 = tr->get(statusSpace.pack(FileBackupAgent::keyStateStatus));
															#line 1744 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<AbortFiveZeroBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11345 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<AbortFiveZeroBackupActor*>(this)->actor_wait_state = 2;
															#line 1744 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< AbortFiveZeroBackupActor, 1, Optional<Value> >*>(static_cast<AbortFiveZeroBackupActor*>(this)));
															#line 11350 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Optional<Value> const& uidStr,int loopDepth) 
	{
		loopDepth = a_body1cont1(uidStr, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<Value> && uidStr,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(uidStr), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<AbortFiveZeroBackupActor*>(this)->actor_wait_state > 0) static_cast<AbortFiveZeroBackupActor*>(this)->actor_wait_state = 0;
		static_cast<AbortFiveZeroBackupActor*>(this)->ActorCallback< AbortFiveZeroBackupActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< AbortFiveZeroBackupActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("abortFiveZeroBackup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AbortFiveZeroBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("abortFiveZeroBackup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< AbortFiveZeroBackupActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("abortFiveZeroBackup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AbortFiveZeroBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("abortFiveZeroBackup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< AbortFiveZeroBackupActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("abortFiveZeroBackup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AbortFiveZeroBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("abortFiveZeroBackup", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Optional<Value> const& statusStr,int loopDepth) 
	{
															#line 1745 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		status = !statusStr.present() ? EBackupState::STATE_NEVERRAN : BackupAgentBase::getState(statusStr.get().toString());
															#line 1748 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		TraceEvent(SevInfo, "FileBackupAbortIncompatibleBackup") .detail("TagName", tagName.c_str()) .detail("Status", BackupAgentBase::getStateText(status));
															#line 1753 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		tr->clear(singleKeyRange(StringRef(globalConfig.pack(FileBackupAgent::keyFolderId))));
															#line 1756 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		Key configPath = uidPrefixKey(logRangesRange.begin, uid);
															#line 1757 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		Key logsPath = uidPrefixKey(backupLogKeys.begin, uid);
															#line 1758 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		tr->clear(KeyRangeRef(configPath, strinc(configPath)));
															#line 1759 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		tr->clear(KeyRangeRef(logsPath, strinc(logsPath)));
															#line 1762 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		tr->clear(newConfigSpace.range());
															#line 1764 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		Key statusKey = StringRef(statusSpace.pack(FileBackupAgent::keyStateStatus));
															#line 1767 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (backupAgent->isRunnable(status))
															#line 11452 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 1768 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tr->set(statusKey, StringRef(FileBackupAgent::getStateText(EBackupState::STATE_ABORTED)));
															#line 11456 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
															#line 1770 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<AbortFiveZeroBackupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~AbortFiveZeroBackupActorState(); static_cast<AbortFiveZeroBackupActor*>(this)->destroy(); return 0; }
															#line 11460 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<AbortFiveZeroBackupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~AbortFiveZeroBackupActorState();
		static_cast<AbortFiveZeroBackupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Optional<Value> && statusStr,int loopDepth) 
	{
															#line 1745 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		status = !statusStr.present() ? EBackupState::STATE_NEVERRAN : BackupAgentBase::getState(statusStr.get().toString());
															#line 1748 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		TraceEvent(SevInfo, "FileBackupAbortIncompatibleBackup") .detail("TagName", tagName.c_str()) .detail("Status", BackupAgentBase::getStateText(status));
															#line 1753 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		tr->clear(singleKeyRange(StringRef(globalConfig.pack(FileBackupAgent::keyFolderId))));
															#line 1756 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		Key configPath = uidPrefixKey(logRangesRange.begin, uid);
															#line 1757 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		Key logsPath = uidPrefixKey(backupLogKeys.begin, uid);
															#line 1758 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		tr->clear(KeyRangeRef(configPath, strinc(configPath)));
															#line 1759 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		tr->clear(KeyRangeRef(logsPath, strinc(logsPath)));
															#line 1762 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		tr->clear(newConfigSpace.range());
															#line 1764 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		Key statusKey = StringRef(statusSpace.pack(FileBackupAgent::keyStateStatus));
															#line 1767 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (backupAgent->isRunnable(status))
															#line 11490 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 1768 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tr->set(statusKey, StringRef(FileBackupAgent::getStateText(EBackupState::STATE_ABORTED)));
															#line 11494 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
															#line 1770 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<AbortFiveZeroBackupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~AbortFiveZeroBackupActorState(); static_cast<AbortFiveZeroBackupActor*>(this)->destroy(); return 0; }
															#line 11498 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<AbortFiveZeroBackupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~AbortFiveZeroBackupActorState();
		static_cast<AbortFiveZeroBackupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Optional<Value> const& statusStr,int loopDepth) 
	{
		loopDepth = a_body1cont2(statusStr, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Optional<Value> && statusStr,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(statusStr), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<AbortFiveZeroBackupActor*>(this)->actor_wait_state > 0) static_cast<AbortFiveZeroBackupActor*>(this)->actor_wait_state = 0;
		static_cast<AbortFiveZeroBackupActor*>(this)->ActorCallback< AbortFiveZeroBackupActor, 1, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< AbortFiveZeroBackupActor, 1, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("abortFiveZeroBackup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AbortFiveZeroBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("abortFiveZeroBackup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< AbortFiveZeroBackupActor, 1, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("abortFiveZeroBackup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AbortFiveZeroBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("abortFiveZeroBackup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< AbortFiveZeroBackupActor, 1, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("abortFiveZeroBackup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AbortFiveZeroBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("abortFiveZeroBackup", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1726 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	FileBackupAgent* backupAgent;
															#line 1726 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 1726 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	std::string tagName;
															#line 1732 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Subspace tagNames;
															#line 1738 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	UID uid;
															#line 1740 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Subspace statusSpace;
															#line 1741 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Subspace globalConfig;
															#line 1742 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Subspace newConfigSpace;
															#line 1745 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	EBackupState status;
															#line 11599 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via abortFiveZeroBackup()
															#line 1726 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class AbortFiveZeroBackupActor final : public Actor<Void>, public ActorCallback< AbortFiveZeroBackupActor, 0, Optional<Value> >, public ActorCallback< AbortFiveZeroBackupActor, 1, Optional<Value> >, public FastAllocated<AbortFiveZeroBackupActor>, public AbortFiveZeroBackupActorState<AbortFiveZeroBackupActor> {
															#line 11604 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<AbortFiveZeroBackupActor>::operator new;
	using FastAllocated<AbortFiveZeroBackupActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10402475501639711488UL, 14077706720573726208UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< AbortFiveZeroBackupActor, 0, Optional<Value> >;
friend struct ActorCallback< AbortFiveZeroBackupActor, 1, Optional<Value> >;
															#line 1726 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	AbortFiveZeroBackupActor(FileBackupAgent* const& backupAgent,Reference<ReadYourWritesTransaction> const& tr,std::string const& tagName) 
															#line 11622 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   AbortFiveZeroBackupActorState<AbortFiveZeroBackupActor>(backupAgent, tr, tagName),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("abortFiveZeroBackup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9684559041468978176UL, 9313393515895828736UL);
		ActorExecutionContextHelper __helper(static_cast<AbortFiveZeroBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("abortFiveZeroBackup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("abortFiveZeroBackup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< AbortFiveZeroBackupActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< AbortFiveZeroBackupActor, 1, Optional<Value> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1726 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] static Future<Void> abortFiveZeroBackup( FileBackupAgent* const& backupAgent, Reference<ReadYourWritesTransaction> const& tr, std::string const& tagName ) {
															#line 1726 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Void>(new AbortFiveZeroBackupActor(backupAgent, tr, tagName));
															#line 11655 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 1772 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

struct AbortFiveZeroBackupTask : TaskFuncBase {
	static StringRef name;
																#line 11662 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via _finish()
															#line 1775 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class _finishActor>
															#line 1775 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class _finishActorState {
															#line 11668 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 1775 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	_finishActorState(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,Reference<FutureBucket> const& futureBucket,Reference<Task> const& task) 
															#line 1775 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 1775 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : tr(tr),
															#line 1775 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   taskBucket(taskBucket),
															#line 1775 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   futureBucket(futureBucket),
															#line 1775 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   task(task),
															#line 1779 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   backupAgent(),
															#line 1780 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   tagName(task->params[BackupAgentBase::keyConfigBackupTag].toString())
															#line 11685 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("_finish", reinterpret_cast<unsigned long>(this));

	}
	~_finishActorState() 
	{
		fdb_probe_actor_destroy("_finish", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1782 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			TraceEvent(SevInfo, "FileBackupCancelOldTask") .detail("Task", task->params[Task::reservedTaskParamKeyType]) .detail("TagName", tagName);
															#line 1785 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_0 = abortFiveZeroBackup(&backupAgent, tr, tagName);
															#line 1785 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<_finishActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11704 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_finishActor*>(this)->actor_wait_state = 1;
															#line 1785 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _finishActor, 0, Void >*>(static_cast<_finishActor*>(this)));
															#line 11709 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_finishActorState();
		static_cast<_finishActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1787 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = taskBucket->finish(tr, task);
															#line 1787 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<_finishActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11734 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_finishActor*>(this)->actor_wait_state = 2;
															#line 1787 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _finishActor, 1, Void >*>(static_cast<_finishActor*>(this)));
															#line 11739 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1787 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = taskBucket->finish(tr, task);
															#line 1787 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<_finishActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11750 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_finishActor*>(this)->actor_wait_state = 2;
															#line 1787 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _finishActor, 1, Void >*>(static_cast<_finishActor*>(this)));
															#line 11755 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_finishActor*>(this)->actor_wait_state > 0) static_cast<_finishActor*>(this)->actor_wait_state = 0;
		static_cast<_finishActor*>(this)->ActorCallback< _finishActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _finishActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _finishActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _finishActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 1788 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<_finishActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_finishActorState(); static_cast<_finishActor*>(this)->destroy(); return 0; }
															#line 11839 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<_finishActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_finishActorState();
		static_cast<_finishActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 1788 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<_finishActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_finishActorState(); static_cast<_finishActor*>(this)->destroy(); return 0; }
															#line 11851 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<_finishActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_finishActorState();
		static_cast<_finishActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_finishActor*>(this)->actor_wait_state > 0) static_cast<_finishActor*>(this)->actor_wait_state = 0;
		static_cast<_finishActor*>(this)->ActorCallback< _finishActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _finishActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _finishActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _finishActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1775 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 1775 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<TaskBucket> taskBucket;
															#line 1775 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<FutureBucket> futureBucket;
															#line 1775 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<Task> task;
															#line 1779 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	FileBackupAgent backupAgent;
															#line 1780 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	std::string tagName;
															#line 11946 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via _finish()
															#line 1775 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class _finishActor final : public Actor<Void>, public ActorCallback< _finishActor, 0, Void >, public ActorCallback< _finishActor, 1, Void >, public FastAllocated<_finishActor>, public _finishActorState<_finishActor> {
															#line 11951 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<_finishActor>::operator new;
	using FastAllocated<_finishActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10246208490604551680UL, 9162223405864444928UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _finishActor, 0, Void >;
friend struct ActorCallback< _finishActor, 1, Void >;
															#line 1775 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	_finishActor(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,Reference<FutureBucket> const& futureBucket,Reference<Task> const& task) 
															#line 11969 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   _finishActorState<_finishActor>(tr, taskBucket, futureBucket, task),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5805366160711900928UL, 534046083987129088UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_finish");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _finishActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _finishActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1775 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] static Future<Void> _finish( Reference<ReadYourWritesTransaction> const& tr, Reference<TaskBucket> const& taskBucket, Reference<FutureBucket> const& futureBucket, Reference<Task> const& task ) {
															#line 1775 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Void>(new _finishActor(tr, taskBucket, futureBucket, task));
															#line 12002 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 1790 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

	StringRef getName() const override {
		TraceEvent(SevError, "FileBackupError")
		    .detail("Cause", "AbortFiveZeroBackupTaskFunc::name() should never be called");
		ASSERT(false);
		return StringRef();
	}

	Future<Void> execute(Database cx,
	                     Reference<TaskBucket> tb,
	                     Reference<FutureBucket> fb,
	                     Reference<Task> task) override {
		return Future<Void>(Void());
	};
	Future<Void> finish(Reference<ReadYourWritesTransaction> tr,
	                    Reference<TaskBucket> tb,
	                    Reference<FutureBucket> fb,
	                    Reference<Task> task) override {
		return _finish(tr, tb, fb, task);
	};
};
StringRef AbortFiveZeroBackupTask::name = "abort_legacy_backup"_sr;
REGISTER_TASKFUNC(AbortFiveZeroBackupTask);
REGISTER_TASKFUNC_ALIAS(AbortFiveZeroBackupTask, file_backup_diff_logs);
REGISTER_TASKFUNC_ALIAS(AbortFiveZeroBackupTask, file_backup_log_range);
REGISTER_TASKFUNC_ALIAS(AbortFiveZeroBackupTask, file_backup_logs);
REGISTER_TASKFUNC_ALIAS(AbortFiveZeroBackupTask, file_backup_range);
REGISTER_TASKFUNC_ALIAS(AbortFiveZeroBackupTask, file_backup_restorable);
REGISTER_TASKFUNC_ALIAS(AbortFiveZeroBackupTask, file_finish_full_backup);
REGISTER_TASKFUNC_ALIAS(AbortFiveZeroBackupTask, file_finished_full_backup);
REGISTER_TASKFUNC_ALIAS(AbortFiveZeroBackupTask, file_start_full_backup);

															#line 12038 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via abortFiveOneBackup()
															#line 1822 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class AbortFiveOneBackupActor>
															#line 1822 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class AbortFiveOneBackupActorState {
															#line 12044 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 1822 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	AbortFiveOneBackupActorState(FileBackupAgent* const& backupAgent,Reference<ReadYourWritesTransaction> const& tr,std::string const& tagName) 
															#line 1822 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 1822 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : backupAgent(backupAgent),
															#line 1822 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   tr(tr),
															#line 1822 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   tagName(tagName)
															#line 12055 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("abortFiveOneBackup", reinterpret_cast<unsigned long>(this));

	}
	~AbortFiveOneBackupActorState() 
	{
		fdb_probe_actor_destroy("abortFiveOneBackup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1825 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 1826 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 1828 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tag = makeBackupTag(tagName);
															#line 1829 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<UidAndAbortedFlagT> __when_expr_0 = tag.getOrThrow(tr, Snapshot::False, backup_unneeded());
															#line 1829 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<AbortFiveOneBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12078 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<AbortFiveOneBackupActor*>(this)->actor_wait_state = 1;
															#line 1829 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< AbortFiveOneBackupActor, 0, UidAndAbortedFlagT >*>(static_cast<AbortFiveOneBackupActor*>(this)));
															#line 12083 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~AbortFiveOneBackupActorState();
		static_cast<AbortFiveOneBackupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1831 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		config = BackupConfig(current.first);
															#line 1832 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<EBackupState> __when_expr_1 = config.stateEnum().getD(tr, Snapshot::False, EBackupState::STATE_NEVERRAN);
															#line 1832 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<AbortFiveOneBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12110 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<AbortFiveOneBackupActor*>(this)->actor_wait_state = 2;
															#line 1832 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< AbortFiveOneBackupActor, 1, EBackupState >*>(static_cast<AbortFiveOneBackupActor*>(this)));
															#line 12115 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(UidAndAbortedFlagT const& __current,int loopDepth) 
	{
															#line 1829 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		current = __current;
															#line 12124 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(UidAndAbortedFlagT && __current,int loopDepth) 
	{
		current = std::move(__current);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<AbortFiveOneBackupActor*>(this)->actor_wait_state > 0) static_cast<AbortFiveOneBackupActor*>(this)->actor_wait_state = 0;
		static_cast<AbortFiveOneBackupActor*>(this)->ActorCallback< AbortFiveOneBackupActor, 0, UidAndAbortedFlagT >::remove();

	}
	void a_callback_fire(ActorCallback< AbortFiveOneBackupActor, 0, UidAndAbortedFlagT >*,UidAndAbortedFlagT const& value) 
	{
		fdb_probe_actor_enter("abortFiveOneBackup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AbortFiveOneBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("abortFiveOneBackup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< AbortFiveOneBackupActor, 0, UidAndAbortedFlagT >*,UidAndAbortedFlagT && value) 
	{
		fdb_probe_actor_enter("abortFiveOneBackup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AbortFiveOneBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("abortFiveOneBackup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< AbortFiveOneBackupActor, 0, UidAndAbortedFlagT >*,Error err) 
	{
		fdb_probe_actor_enter("abortFiveOneBackup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AbortFiveOneBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("abortFiveOneBackup", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(EBackupState const& status,int loopDepth) 
	{
															#line 1834 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!backupAgent->isRunnable(status))
															#line 12203 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 1835 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			return a_body1Catch1(backup_unneeded(), loopDepth);
															#line 12207 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
															#line 1838 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		TraceEvent(SevInfo, "FBA_AbortFileOneBackup") .detail("TagName", tagName.c_str()) .detail("Status", BackupAgentBase::getStateText(status));
															#line 1843 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tag.cancel(tr);
															#line 1843 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<AbortFiveOneBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12215 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<AbortFiveOneBackupActor*>(this)->actor_wait_state = 3;
															#line 1843 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< AbortFiveOneBackupActor, 2, Void >*>(static_cast<AbortFiveOneBackupActor*>(this)));
															#line 12220 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(EBackupState && status,int loopDepth) 
	{
															#line 1834 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!backupAgent->isRunnable(status))
															#line 12229 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 1835 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			return a_body1Catch1(backup_unneeded(), loopDepth);
															#line 12233 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
															#line 1838 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		TraceEvent(SevInfo, "FBA_AbortFileOneBackup") .detail("TagName", tagName.c_str()) .detail("Status", BackupAgentBase::getStateText(status));
															#line 1843 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tag.cancel(tr);
															#line 1843 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<AbortFiveOneBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12241 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<AbortFiveOneBackupActor*>(this)->actor_wait_state = 3;
															#line 1843 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< AbortFiveOneBackupActor, 2, Void >*>(static_cast<AbortFiveOneBackupActor*>(this)));
															#line 12246 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(EBackupState const& status,int loopDepth) 
	{
		loopDepth = a_body1cont2(status, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(EBackupState && status,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(status), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<AbortFiveOneBackupActor*>(this)->actor_wait_state > 0) static_cast<AbortFiveOneBackupActor*>(this)->actor_wait_state = 0;
		static_cast<AbortFiveOneBackupActor*>(this)->ActorCallback< AbortFiveOneBackupActor, 1, EBackupState >::remove();

	}
	void a_callback_fire(ActorCallback< AbortFiveOneBackupActor, 1, EBackupState >*,EBackupState const& value) 
	{
		fdb_probe_actor_enter("abortFiveOneBackup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AbortFiveOneBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("abortFiveOneBackup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< AbortFiveOneBackupActor, 1, EBackupState >*,EBackupState && value) 
	{
		fdb_probe_actor_enter("abortFiveOneBackup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AbortFiveOneBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("abortFiveOneBackup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< AbortFiveOneBackupActor, 1, EBackupState >*,Error err) 
	{
		fdb_probe_actor_enter("abortFiveOneBackup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AbortFiveOneBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("abortFiveOneBackup", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 1845 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		Key configPath = uidPrefixKey(logRangesRange.begin, config.getUid());
															#line 1846 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		Key logsPath = uidPrefixKey(backupLogKeys.begin, config.getUid());
															#line 1848 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		tr->clear(KeyRangeRef(configPath, strinc(configPath)));
															#line 1849 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		tr->clear(KeyRangeRef(logsPath, strinc(logsPath)));
															#line 1851 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		config.stateEnum().set(tr, EBackupState::STATE_ABORTED);
															#line 1853 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<AbortFiveOneBackupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~AbortFiveOneBackupActorState(); static_cast<AbortFiveOneBackupActor*>(this)->destroy(); return 0; }
															#line 12340 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<AbortFiveOneBackupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~AbortFiveOneBackupActorState();
		static_cast<AbortFiveOneBackupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 1845 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		Key configPath = uidPrefixKey(logRangesRange.begin, config.getUid());
															#line 1846 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		Key logsPath = uidPrefixKey(backupLogKeys.begin, config.getUid());
															#line 1848 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		tr->clear(KeyRangeRef(configPath, strinc(configPath)));
															#line 1849 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		tr->clear(KeyRangeRef(logsPath, strinc(logsPath)));
															#line 1851 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		config.stateEnum().set(tr, EBackupState::STATE_ABORTED);
															#line 1853 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<AbortFiveOneBackupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~AbortFiveOneBackupActorState(); static_cast<AbortFiveOneBackupActor*>(this)->destroy(); return 0; }
															#line 12362 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<AbortFiveOneBackupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~AbortFiveOneBackupActorState();
		static_cast<AbortFiveOneBackupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<AbortFiveOneBackupActor*>(this)->actor_wait_state > 0) static_cast<AbortFiveOneBackupActor*>(this)->actor_wait_state = 0;
		static_cast<AbortFiveOneBackupActor*>(this)->ActorCallback< AbortFiveOneBackupActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AbortFiveOneBackupActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("abortFiveOneBackup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AbortFiveOneBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("abortFiveOneBackup", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< AbortFiveOneBackupActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("abortFiveOneBackup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AbortFiveOneBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("abortFiveOneBackup", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< AbortFiveOneBackupActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("abortFiveOneBackup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AbortFiveOneBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("abortFiveOneBackup", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 1822 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	FileBackupAgent* backupAgent;
															#line 1822 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 1822 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	std::string tagName;
															#line 1828 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	KeyBackedTag tag;
															#line 1829 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	UidAndAbortedFlagT current;
															#line 1831 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	BackupConfig config;
															#line 12457 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via abortFiveOneBackup()
															#line 1822 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class AbortFiveOneBackupActor final : public Actor<Void>, public ActorCallback< AbortFiveOneBackupActor, 0, UidAndAbortedFlagT >, public ActorCallback< AbortFiveOneBackupActor, 1, EBackupState >, public ActorCallback< AbortFiveOneBackupActor, 2, Void >, public FastAllocated<AbortFiveOneBackupActor>, public AbortFiveOneBackupActorState<AbortFiveOneBackupActor> {
															#line 12462 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<AbortFiveOneBackupActor>::operator new;
	using FastAllocated<AbortFiveOneBackupActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14318426040590996992UL, 8069418112414057728UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< AbortFiveOneBackupActor, 0, UidAndAbortedFlagT >;
friend struct ActorCallback< AbortFiveOneBackupActor, 1, EBackupState >;
friend struct ActorCallback< AbortFiveOneBackupActor, 2, Void >;
															#line 1822 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	AbortFiveOneBackupActor(FileBackupAgent* const& backupAgent,Reference<ReadYourWritesTransaction> const& tr,std::string const& tagName) 
															#line 12481 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   AbortFiveOneBackupActorState<AbortFiveOneBackupActor>(backupAgent, tr, tagName),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("abortFiveOneBackup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12508330983096255488UL, 5977812422500027136UL);
		ActorExecutionContextHelper __helper(static_cast<AbortFiveOneBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("abortFiveOneBackup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("abortFiveOneBackup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< AbortFiveOneBackupActor, 0, UidAndAbortedFlagT >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< AbortFiveOneBackupActor, 1, EBackupState >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< AbortFiveOneBackupActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1822 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] static Future<Void> abortFiveOneBackup( FileBackupAgent* const& backupAgent, Reference<ReadYourWritesTransaction> const& tr, std::string const& tagName ) {
															#line 1822 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Void>(new AbortFiveOneBackupActor(backupAgent, tr, tagName));
															#line 12515 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 1855 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

struct AbortFiveOneBackupTask : TaskFuncBase {
	static StringRef name;
																#line 12522 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via _finish()
															#line 1858 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class _finishActor1>
															#line 1858 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class _finishActor1State {
															#line 12528 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 1858 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	_finishActor1State(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,Reference<FutureBucket> const& futureBucket,Reference<Task> const& task) 
															#line 1858 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 1858 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : tr(tr),
															#line 1858 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   taskBucket(taskBucket),
															#line 1858 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   futureBucket(futureBucket),
															#line 1858 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   task(task),
															#line 1862 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   backupAgent(),
															#line 1863 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   config(task)
															#line 12545 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("_finish", reinterpret_cast<unsigned long>(this));

	}
	~_finishActor1State() 
	{
		fdb_probe_actor_destroy("_finish", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1864 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<std::string> __when_expr_0 = config.tag().getOrThrow(tr);
															#line 1864 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<_finishActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12562 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_finishActor1*>(this)->actor_wait_state = 1;
															#line 1864 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _finishActor1, 0, std::string >*>(static_cast<_finishActor1*>(this)));
															#line 12567 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_finishActor1State();
		static_cast<_finishActor1*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1866 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		TraceEvent(SevInfo, "FileBackupCancelFiveOneTask") .detail("Task", task->params[Task::reservedTaskParamKeyType]) .detail("TagName", tagName);
															#line 1869 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = abortFiveOneBackup(&backupAgent, tr, tagName);
															#line 1869 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<_finishActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12594 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_finishActor1*>(this)->actor_wait_state = 2;
															#line 1869 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _finishActor1, 1, Void >*>(static_cast<_finishActor1*>(this)));
															#line 12599 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(std::string const& __tagName,int loopDepth) 
	{
															#line 1864 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		tagName = __tagName;
															#line 12608 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::string && __tagName,int loopDepth) 
	{
		tagName = std::move(__tagName);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_finishActor1*>(this)->actor_wait_state > 0) static_cast<_finishActor1*>(this)->actor_wait_state = 0;
		static_cast<_finishActor1*>(this)->ActorCallback< _finishActor1, 0, std::string >::remove();

	}
	void a_callback_fire(ActorCallback< _finishActor1, 0, std::string >*,std::string const& value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _finishActor1, 0, std::string >*,std::string && value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _finishActor1, 0, std::string >*,Error err) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 1871 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_2 = taskBucket->finish(tr, task);
															#line 1871 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<_finishActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12689 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<_finishActor1*>(this)->actor_wait_state = 3;
															#line 1871 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _finishActor1, 2, Void >*>(static_cast<_finishActor1*>(this)));
															#line 12694 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 1871 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_2 = taskBucket->finish(tr, task);
															#line 1871 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<_finishActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12705 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<_finishActor1*>(this)->actor_wait_state = 3;
															#line 1871 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _finishActor1, 2, Void >*>(static_cast<_finishActor1*>(this)));
															#line 12710 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_finishActor1*>(this)->actor_wait_state > 0) static_cast<_finishActor1*>(this)->actor_wait_state = 0;
		static_cast<_finishActor1*>(this)->ActorCallback< _finishActor1, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _finishActor1, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _finishActor1, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _finishActor1, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 1872 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<_finishActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_finishActor1State(); static_cast<_finishActor1*>(this)->destroy(); return 0; }
															#line 12794 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<_finishActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~_finishActor1State();
		static_cast<_finishActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 1872 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<_finishActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_finishActor1State(); static_cast<_finishActor1*>(this)->destroy(); return 0; }
															#line 12806 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<_finishActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~_finishActor1State();
		static_cast<_finishActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_finishActor1*>(this)->actor_wait_state > 0) static_cast<_finishActor1*>(this)->actor_wait_state = 0;
		static_cast<_finishActor1*>(this)->ActorCallback< _finishActor1, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _finishActor1, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _finishActor1, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _finishActor1, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 1858 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 1858 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<TaskBucket> taskBucket;
															#line 1858 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<FutureBucket> futureBucket;
															#line 1858 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<Task> task;
															#line 1862 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	FileBackupAgent backupAgent;
															#line 1863 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	BackupConfig config;
															#line 1864 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	std::string tagName;
															#line 12903 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via _finish()
															#line 1858 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class _finishActor1 final : public Actor<Void>, public ActorCallback< _finishActor1, 0, std::string >, public ActorCallback< _finishActor1, 1, Void >, public ActorCallback< _finishActor1, 2, Void >, public FastAllocated<_finishActor1>, public _finishActor1State<_finishActor1> {
															#line 12908 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<_finishActor1>::operator new;
	using FastAllocated<_finishActor1>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10246208490604551680UL, 9162223405864444928UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _finishActor1, 0, std::string >;
friend struct ActorCallback< _finishActor1, 1, Void >;
friend struct ActorCallback< _finishActor1, 2, Void >;
															#line 1858 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	_finishActor1(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,Reference<FutureBucket> const& futureBucket,Reference<Task> const& task) 
															#line 12927 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   _finishActor1State<_finishActor1>(tr, taskBucket, futureBucket, task),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9581808447337778176UL, 9167718057927325696UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_finish");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _finishActor1, 0, std::string >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _finishActor1, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _finishActor1, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1858 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] static Future<Void> _finish( Reference<ReadYourWritesTransaction> const& tr, Reference<TaskBucket> const& taskBucket, Reference<FutureBucket> const& futureBucket, Reference<Task> const& task ) {
															#line 1858 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Void>(new _finishActor1(tr, taskBucket, futureBucket, task));
															#line 12961 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 1874 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

	StringRef getName() const override {
		TraceEvent(SevError, "FileBackupError")
		    .detail("Cause", "AbortFiveOneBackupTaskFunc::name() should never be called");
		ASSERT(false);
		return StringRef();
	}

	Future<Void> execute(Database cx,
	                     Reference<TaskBucket> tb,
	                     Reference<FutureBucket> fb,
	                     Reference<Task> task) override {
		return Future<Void>(Void());
	};
	Future<Void> finish(Reference<ReadYourWritesTransaction> tr,
	                    Reference<TaskBucket> tb,
	                    Reference<FutureBucket> fb,
	                    Reference<Task> task) override {
		return _finish(tr, tb, fb, task);
	};
};
StringRef AbortFiveOneBackupTask::name = "abort_legacy_backup_5.2"_sr;
REGISTER_TASKFUNC(AbortFiveOneBackupTask);
REGISTER_TASKFUNC_ALIAS(AbortFiveOneBackupTask, file_backup_write_range);
REGISTER_TASKFUNC_ALIAS(AbortFiveOneBackupTask, file_backup_dispatch_ranges);
REGISTER_TASKFUNC_ALIAS(AbortFiveOneBackupTask, file_backup_write_logs);
REGISTER_TASKFUNC_ALIAS(AbortFiveOneBackupTask, file_backup_erase_logs);
REGISTER_TASKFUNC_ALIAS(AbortFiveOneBackupTask, file_backup_dispatch_logs);
REGISTER_TASKFUNC_ALIAS(AbortFiveOneBackupTask, file_backup_finished);
REGISTER_TASKFUNC_ALIAS(AbortFiveOneBackupTask, file_backup_write_snapshot_manifest);
REGISTER_TASKFUNC_ALIAS(AbortFiveOneBackupTask, file_backup_start);

std::function<void(Reference<Task>)> NOP_SETUP_TASK_FN = [](Reference<Task> task) { /* NOP */ };
															#line 12998 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via addBackupTask()
															#line 1907 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class AddBackupTaskActor>
															#line 1907 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class AddBackupTaskActorState {
															#line 13004 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 1907 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	AddBackupTaskActorState(StringRef const& name,uint32_t const& version,Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,TaskCompletionKey const& completionKey,BackupConfig const& config,Reference<TaskFuture> const& waitFor = Reference<TaskFuture>(),std::function<void(Reference<Task>)> const& setupTaskFn = NOP_SETUP_TASK_FN,int const& priority = 0,SetValidation const& setValidation = SetValidation::True) 
															#line 1907 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 1907 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : name(name),
															#line 1907 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   version(version),
															#line 1907 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   tr(tr),
															#line 1907 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   taskBucket(taskBucket),
															#line 1907 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   completionKey(completionKey),
															#line 1907 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   config(config),
															#line 1907 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   waitFor(waitFor),
															#line 1907 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   setupTaskFn(setupTaskFn),
															#line 1907 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   priority(priority),
															#line 1907 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   setValidation(setValidation)
															#line 13029 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("addBackupTask", reinterpret_cast<unsigned long>(this));

	}
	~AddBackupTaskActorState() 
	{
		fdb_probe_actor_destroy("addBackupTask", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1917 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 1918 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 1920 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Key> __when_expr_0 = completionKey.get(tr, taskBucket);
															#line 1920 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<AddBackupTaskActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13050 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<AddBackupTaskActor*>(this)->actor_wait_state = 1;
															#line 1920 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< AddBackupTaskActor, 0, Key >*>(static_cast<AddBackupTaskActor*>(this)));
															#line 13055 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~AddBackupTaskActorState();
		static_cast<AddBackupTaskActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Key const& doneKey,int loopDepth) 
	{
															#line 1921 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		task = Reference<Task>(new Task(name, version, doneKey, priority));
															#line 1925 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = config.toTask(tr, task, setValidation);
															#line 1925 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<AddBackupTaskActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13082 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<AddBackupTaskActor*>(this)->actor_wait_state = 2;
															#line 1925 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< AddBackupTaskActor, 1, Void >*>(static_cast<AddBackupTaskActor*>(this)));
															#line 13087 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Key && doneKey,int loopDepth) 
	{
															#line 1921 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		task = Reference<Task>(new Task(name, version, doneKey, priority));
															#line 1925 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = config.toTask(tr, task, setValidation);
															#line 1925 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<AddBackupTaskActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13100 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<AddBackupTaskActor*>(this)->actor_wait_state = 2;
															#line 1925 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< AddBackupTaskActor, 1, Void >*>(static_cast<AddBackupTaskActor*>(this)));
															#line 13105 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Key const& doneKey,int loopDepth) 
	{
		loopDepth = a_body1cont1(doneKey, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Key && doneKey,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(doneKey), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<AddBackupTaskActor*>(this)->actor_wait_state > 0) static_cast<AddBackupTaskActor*>(this)->actor_wait_state = 0;
		static_cast<AddBackupTaskActor*>(this)->ActorCallback< AddBackupTaskActor, 0, Key >::remove();

	}
	void a_callback_fire(ActorCallback< AddBackupTaskActor, 0, Key >*,Key const& value) 
	{
		fdb_probe_actor_enter("addBackupTask", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddBackupTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addBackupTask", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< AddBackupTaskActor, 0, Key >*,Key && value) 
	{
		fdb_probe_actor_enter("addBackupTask", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddBackupTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addBackupTask", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< AddBackupTaskActor, 0, Key >*,Error err) 
	{
		fdb_probe_actor_enter("addBackupTask", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AddBackupTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addBackupTask", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 1928 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		setupTaskFn(task);
															#line 1930 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!waitFor)
															#line 13191 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 1931 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!static_cast<AddBackupTaskActor*>(this)->SAV<Key>::futures) { (void)(taskBucket->addTask(tr, task)); this->~AddBackupTaskActorState(); static_cast<AddBackupTaskActor*>(this)->destroy(); return 0; }
															#line 13195 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			new (&static_cast<AddBackupTaskActor*>(this)->SAV< Key >::value()) Key(taskBucket->addTask(tr, task));
			this->~AddBackupTaskActorState();
			static_cast<AddBackupTaskActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1933 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_2 = waitFor->onSetAddTask(tr, taskBucket, task);
															#line 1933 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<AddBackupTaskActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13205 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<AddBackupTaskActor*>(this)->actor_wait_state = 3;
															#line 1933 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< AddBackupTaskActor, 2, Void >*>(static_cast<AddBackupTaskActor*>(this)));
															#line 13210 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 1928 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		setupTaskFn(task);
															#line 1930 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!waitFor)
															#line 13221 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 1931 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!static_cast<AddBackupTaskActor*>(this)->SAV<Key>::futures) { (void)(taskBucket->addTask(tr, task)); this->~AddBackupTaskActorState(); static_cast<AddBackupTaskActor*>(this)->destroy(); return 0; }
															#line 13225 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			new (&static_cast<AddBackupTaskActor*>(this)->SAV< Key >::value()) Key(taskBucket->addTask(tr, task));
			this->~AddBackupTaskActorState();
			static_cast<AddBackupTaskActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1933 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_2 = waitFor->onSetAddTask(tr, taskBucket, task);
															#line 1933 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<AddBackupTaskActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13235 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<AddBackupTaskActor*>(this)->actor_wait_state = 3;
															#line 1933 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< AddBackupTaskActor, 2, Void >*>(static_cast<AddBackupTaskActor*>(this)));
															#line 13240 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<AddBackupTaskActor*>(this)->actor_wait_state > 0) static_cast<AddBackupTaskActor*>(this)->actor_wait_state = 0;
		static_cast<AddBackupTaskActor*>(this)->ActorCallback< AddBackupTaskActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AddBackupTaskActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("addBackupTask", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddBackupTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addBackupTask", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< AddBackupTaskActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("addBackupTask", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddBackupTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addBackupTask", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< AddBackupTaskActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("addBackupTask", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AddBackupTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addBackupTask", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 1935 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<AddBackupTaskActor*>(this)->SAV<Key>::futures) { (void)("OnSetAddTask"_sr); this->~AddBackupTaskActorState(); static_cast<AddBackupTaskActor*>(this)->destroy(); return 0; }
															#line 13324 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<AddBackupTaskActor*>(this)->SAV< Key >::value()) Key("OnSetAddTask"_sr);
		this->~AddBackupTaskActorState();
		static_cast<AddBackupTaskActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 1935 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<AddBackupTaskActor*>(this)->SAV<Key>::futures) { (void)("OnSetAddTask"_sr); this->~AddBackupTaskActorState(); static_cast<AddBackupTaskActor*>(this)->destroy(); return 0; }
															#line 13336 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<AddBackupTaskActor*>(this)->SAV< Key >::value()) Key("OnSetAddTask"_sr);
		this->~AddBackupTaskActorState();
		static_cast<AddBackupTaskActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<AddBackupTaskActor*>(this)->actor_wait_state > 0) static_cast<AddBackupTaskActor*>(this)->actor_wait_state = 0;
		static_cast<AddBackupTaskActor*>(this)->ActorCallback< AddBackupTaskActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AddBackupTaskActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("addBackupTask", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddBackupTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addBackupTask", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< AddBackupTaskActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("addBackupTask", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddBackupTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addBackupTask", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< AddBackupTaskActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("addBackupTask", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AddBackupTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addBackupTask", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 1907 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	StringRef name;
															#line 1907 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	uint32_t version;
															#line 1907 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 1907 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<TaskBucket> taskBucket;
															#line 1907 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	TaskCompletionKey completionKey;
															#line 1907 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	BackupConfig config;
															#line 1907 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<TaskFuture> waitFor;
															#line 1907 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	std::function<void(Reference<Task>)> setupTaskFn;
															#line 1907 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	int priority;
															#line 1907 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	SetValidation setValidation;
															#line 1921 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<Task> task;
															#line 13441 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via addBackupTask()
															#line 1907 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class AddBackupTaskActor final : public Actor<Key>, public ActorCallback< AddBackupTaskActor, 0, Key >, public ActorCallback< AddBackupTaskActor, 1, Void >, public ActorCallback< AddBackupTaskActor, 2, Void >, public FastAllocated<AddBackupTaskActor>, public AddBackupTaskActorState<AddBackupTaskActor> {
															#line 13446 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<AddBackupTaskActor>::operator new;
	using FastAllocated<AddBackupTaskActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8547246753426125312UL, 15509338752541051904UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Key>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< AddBackupTaskActor, 0, Key >;
friend struct ActorCallback< AddBackupTaskActor, 1, Void >;
friend struct ActorCallback< AddBackupTaskActor, 2, Void >;
															#line 1907 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	AddBackupTaskActor(StringRef const& name,uint32_t const& version,Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,TaskCompletionKey const& completionKey,BackupConfig const& config,Reference<TaskFuture> const& waitFor = Reference<TaskFuture>(),std::function<void(Reference<Task>)> const& setupTaskFn = NOP_SETUP_TASK_FN,int const& priority = 0,SetValidation const& setValidation = SetValidation::True) 
															#line 13465 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<Key>(),
		   AddBackupTaskActorState<AddBackupTaskActor>(name, version, tr, taskBucket, completionKey, config, waitFor, setupTaskFn, priority, setValidation),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("addBackupTask", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9042814576718378240UL, 18087378901118404352UL);
		ActorExecutionContextHelper __helper(static_cast<AddBackupTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("addBackupTask");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("addBackupTask", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< AddBackupTaskActor, 0, Key >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< AddBackupTaskActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< AddBackupTaskActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1907 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] static Future<Key> addBackupTask( StringRef const& name, uint32_t const& version, Reference<ReadYourWritesTransaction> const& tr, Reference<TaskBucket> const& taskBucket, TaskCompletionKey const& completionKey, BackupConfig const& config, Reference<TaskFuture> const& waitFor = Reference<TaskFuture>(), std::function<void(Reference<Task>)> const& setupTaskFn = NOP_SETUP_TASK_FN, int const& priority = 0, SetValidation const& setValidation = SetValidation::True ) {
															#line 1907 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Key>(new AddBackupTaskActor(name, version, tr, taskBucket, completionKey, config, waitFor, setupTaskFn, priority, setValidation));
															#line 13499 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 1937 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

// Clears the backup ID from "backupStartedKey" to pause backup workers.
															#line 13505 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via clearBackupStartID()
															#line 1939 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class ClearBackupStartIDActor>
															#line 1939 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class ClearBackupStartIDActorState {
															#line 13511 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 1939 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	ClearBackupStartIDActorState(Reference<ReadYourWritesTransaction> const& tr,UID const& backupUid) 
															#line 1939 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 1939 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : tr(tr),
															#line 1939 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   backupUid(backupUid)
															#line 13520 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("clearBackupStartID", reinterpret_cast<unsigned long>(this));

	}
	~ClearBackupStartIDActorState() 
	{
		fdb_probe_actor_destroy("clearBackupStartID", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1941 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr->get(backupStartedKey);
															#line 1941 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<ClearBackupStartIDActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13537 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ClearBackupStartIDActor*>(this)->actor_wait_state = 1;
															#line 1941 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ClearBackupStartIDActor, 0, Optional<Value> >*>(static_cast<ClearBackupStartIDActor*>(this)));
															#line 13542 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ClearBackupStartIDActorState();
		static_cast<ClearBackupStartIDActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> const& started,int loopDepth) 
	{
															#line 1942 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		std::vector<std::pair<UID, Version>> ids;
															#line 1943 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (started.present())
															#line 13567 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 1944 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			ids = decodeBackupStartedValue(started.get());
															#line 13571 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
															#line 1946 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		auto it = std::find_if(ids.begin(), ids.end(), [=](const std::pair<UID, Version>& p) { return p.first == backupUid; });
															#line 1948 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (it != ids.end())
															#line 13577 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 1949 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			ids.erase(it);
															#line 13581 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
															#line 1952 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (ids.empty())
															#line 13585 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 1953 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			TraceEvent("ClearBackup").detail("BackupID", backupUid);
															#line 1954 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tr->clear(backupStartedKey);
															#line 13591 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
		else
		{
															#line 1956 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tr->set(backupStartedKey, encodeBackupStartedValue(ids));
															#line 13597 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
															#line 1958 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<ClearBackupStartIDActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ClearBackupStartIDActorState(); static_cast<ClearBackupStartIDActor*>(this)->destroy(); return 0; }
															#line 13601 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<ClearBackupStartIDActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ClearBackupStartIDActorState();
		static_cast<ClearBackupStartIDActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> && started,int loopDepth) 
	{
															#line 1942 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		std::vector<std::pair<UID, Version>> ids;
															#line 1943 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (started.present())
															#line 13615 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 1944 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			ids = decodeBackupStartedValue(started.get());
															#line 13619 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
															#line 1946 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		auto it = std::find_if(ids.begin(), ids.end(), [=](const std::pair<UID, Version>& p) { return p.first == backupUid; });
															#line 1948 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (it != ids.end())
															#line 13625 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 1949 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			ids.erase(it);
															#line 13629 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
															#line 1952 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (ids.empty())
															#line 13633 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 1953 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			TraceEvent("ClearBackup").detail("BackupID", backupUid);
															#line 1954 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tr->clear(backupStartedKey);
															#line 13639 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
		else
		{
															#line 1956 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tr->set(backupStartedKey, encodeBackupStartedValue(ids));
															#line 13645 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
															#line 1958 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<ClearBackupStartIDActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ClearBackupStartIDActorState(); static_cast<ClearBackupStartIDActor*>(this)->destroy(); return 0; }
															#line 13649 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<ClearBackupStartIDActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ClearBackupStartIDActorState();
		static_cast<ClearBackupStartIDActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Optional<Value> const& started,int loopDepth) 
	{
		loopDepth = a_body1cont1(started, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<Value> && started,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(started), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ClearBackupStartIDActor*>(this)->actor_wait_state > 0) static_cast<ClearBackupStartIDActor*>(this)->actor_wait_state = 0;
		static_cast<ClearBackupStartIDActor*>(this)->ActorCallback< ClearBackupStartIDActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< ClearBackupStartIDActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("clearBackupStartID", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearBackupStartIDActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearBackupStartID", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ClearBackupStartIDActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("clearBackupStartID", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearBackupStartIDActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearBackupStartID", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ClearBackupStartIDActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("clearBackupStartID", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClearBackupStartIDActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearBackupStartID", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1939 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 1939 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	UID backupUid;
															#line 13736 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via clearBackupStartID()
															#line 1939 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class ClearBackupStartIDActor final : public Actor<Void>, public ActorCallback< ClearBackupStartIDActor, 0, Optional<Value> >, public FastAllocated<ClearBackupStartIDActor>, public ClearBackupStartIDActorState<ClearBackupStartIDActor> {
															#line 13741 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<ClearBackupStartIDActor>::operator new;
	using FastAllocated<ClearBackupStartIDActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6296029262690006016UL, 15788735483170350336UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ClearBackupStartIDActor, 0, Optional<Value> >;
															#line 1939 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	ClearBackupStartIDActor(Reference<ReadYourWritesTransaction> const& tr,UID const& backupUid) 
															#line 13758 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   ClearBackupStartIDActorState<ClearBackupStartIDActor>(tr, backupUid),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("clearBackupStartID", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2638382467860152832UL, 17874567724139410688UL);
		ActorExecutionContextHelper __helper(static_cast<ClearBackupStartIDActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("clearBackupStartID");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("clearBackupStartID", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ClearBackupStartIDActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1939 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] static Future<Void> clearBackupStartID( Reference<ReadYourWritesTransaction> const& tr, UID const& backupUid ) {
															#line 1939 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Void>(new ClearBackupStartIDActor(tr, backupUid));
															#line 13790 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 1960 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

// Backup and Restore taskFunc definitions will inherit from one of the following classes which
// servers to catch and log to the appropriate config any error that execute/finish didn't catch and log.
struct RestoreTaskFuncBase : TaskFuncBase {
	Future<Void> handleError(Database cx, Reference<Task> task, Error const& error) final {
		return RestoreConfig(task).logError(
		    cx,
		    error,
		    format("'%s' on '%s'", error.what(), task->params[Task::reservedTaskParamKeyType].printable().c_str()));
	}
	virtual std::string toString(Reference<Task> task) const { return ""; }
};

struct BackupTaskFuncBase : TaskFuncBase {
	Future<Void> handleError(Database cx, Reference<Task> task, Error const& error) final {
		return BackupConfig(task).logError(
		    cx,
		    error,
		    format("'%s' on '%s'", error.what(), task->params[Task::reservedTaskParamKeyType].printable().c_str()));
	}
	virtual std::string toString(Reference<Task> task) const { return ""; }
};

															#line 13817 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via getBlockOfShards()
															#line 1983 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class GetBlockOfShardsActor>
															#line 1983 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class GetBlockOfShardsActorState {
															#line 13823 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 1983 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	GetBlockOfShardsActorState(Reference<ReadYourWritesTransaction> const& tr,Key const& beginKey,Key const& endKey,int const& limit) 
															#line 1983 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 1983 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : tr(tr),
															#line 1983 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   beginKey(beginKey),
															#line 1983 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   endKey(endKey),
															#line 1983 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   limit(limit)
															#line 13836 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getBlockOfShards", reinterpret_cast<unsigned long>(this));

	}
	~GetBlockOfShardsActorState() 
	{
		fdb_probe_actor_destroy("getBlockOfShards", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1988 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 1989 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 1990 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			results = Standalone<VectorRef<KeyRef>>();
															#line 1991 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr->getRange( KeyRangeRef(keyAfter(beginKey.withPrefix(keyServersPrefix)), endKey.withPrefix(keyServersPrefix)), limit);
															#line 1991 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<GetBlockOfShardsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13859 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetBlockOfShardsActor*>(this)->actor_wait_state = 1;
															#line 1991 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetBlockOfShardsActor, 0, RangeResult >*>(static_cast<GetBlockOfShardsActor*>(this)));
															#line 13864 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetBlockOfShardsActorState();
		static_cast<GetBlockOfShardsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(RangeResult const& values,int loopDepth) 
	{
															#line 1994 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		for( auto& s : values ) {
															#line 1995 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			KeyRef k = s.key.removePrefix(keyServersPrefix);
															#line 1996 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			results.push_back_deep(results.arena(), k);
															#line 13891 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
															#line 1999 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<GetBlockOfShardsActor*>(this)->SAV<Standalone<VectorRef<KeyRef>>>::futures) { (void)(results); this->~GetBlockOfShardsActorState(); static_cast<GetBlockOfShardsActor*>(this)->destroy(); return 0; }
															#line 13895 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<GetBlockOfShardsActor*>(this)->SAV< Standalone<VectorRef<KeyRef>> >::value()) Standalone<VectorRef<KeyRef>>(std::move(results)); // state_var_RVO
		this->~GetBlockOfShardsActorState();
		static_cast<GetBlockOfShardsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(RangeResult && values,int loopDepth) 
	{
															#line 1994 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		for( auto& s : values ) {
															#line 1995 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			KeyRef k = s.key.removePrefix(keyServersPrefix);
															#line 1996 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			results.push_back_deep(results.arena(), k);
															#line 13911 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
															#line 1999 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<GetBlockOfShardsActor*>(this)->SAV<Standalone<VectorRef<KeyRef>>>::futures) { (void)(results); this->~GetBlockOfShardsActorState(); static_cast<GetBlockOfShardsActor*>(this)->destroy(); return 0; }
															#line 13915 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<GetBlockOfShardsActor*>(this)->SAV< Standalone<VectorRef<KeyRef>> >::value()) Standalone<VectorRef<KeyRef>>(std::move(results)); // state_var_RVO
		this->~GetBlockOfShardsActorState();
		static_cast<GetBlockOfShardsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(RangeResult const& values,int loopDepth) 
	{
		loopDepth = a_body1cont1(values, loopDepth);

		return loopDepth;
	}
	int a_body1when1(RangeResult && values,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(values), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetBlockOfShardsActor*>(this)->actor_wait_state > 0) static_cast<GetBlockOfShardsActor*>(this)->actor_wait_state = 0;
		static_cast<GetBlockOfShardsActor*>(this)->ActorCallback< GetBlockOfShardsActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< GetBlockOfShardsActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("getBlockOfShards", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetBlockOfShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBlockOfShards", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetBlockOfShardsActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("getBlockOfShards", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetBlockOfShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBlockOfShards", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetBlockOfShardsActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("getBlockOfShards", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetBlockOfShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBlockOfShards", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1983 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 1983 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Key beginKey;
															#line 1983 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Key endKey;
															#line 1983 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	int limit;
															#line 1990 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Standalone<VectorRef<KeyRef>> results;
															#line 14008 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getBlockOfShards()
															#line 1983 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class GetBlockOfShardsActor final : public Actor<Standalone<VectorRef<KeyRef>>>, public ActorCallback< GetBlockOfShardsActor, 0, RangeResult >, public FastAllocated<GetBlockOfShardsActor>, public GetBlockOfShardsActorState<GetBlockOfShardsActor> {
															#line 14013 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetBlockOfShardsActor>::operator new;
	using FastAllocated<GetBlockOfShardsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3718688294638950144UL, 993742926314191104UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Standalone<VectorRef<KeyRef>>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetBlockOfShardsActor, 0, RangeResult >;
															#line 1983 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	GetBlockOfShardsActor(Reference<ReadYourWritesTransaction> const& tr,Key const& beginKey,Key const& endKey,int const& limit) 
															#line 14030 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<Standalone<VectorRef<KeyRef>>>(),
		   GetBlockOfShardsActorState<GetBlockOfShardsActor>(tr, beginKey, endKey, limit),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getBlockOfShards", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13286161151181671680UL, 17379547947322064896UL);
		ActorExecutionContextHelper __helper(static_cast<GetBlockOfShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getBlockOfShards");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getBlockOfShards", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetBlockOfShardsActor, 0, RangeResult >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1983 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] static Future<Standalone<VectorRef<KeyRef>>> getBlockOfShards( Reference<ReadYourWritesTransaction> const& tr, Key const& beginKey, Key const& endKey, int const& limit ) {
															#line 1983 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Standalone<VectorRef<KeyRef>>>(new GetBlockOfShardsActor(tr, beginKey, endKey, limit));
															#line 14062 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 2001 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

struct BackupRangeTaskFunc : BackupTaskFuncBase {
	static StringRef name;
	static constexpr uint32_t version = 1;

	static struct {
		static TaskParam<Key> beginKey() { return __FUNCTION__sr; }
		static TaskParam<Key> endKey() { return __FUNCTION__sr; }
		static TaskParam<bool> addBackupRangeTasks() { return __FUNCTION__sr; }
	} Params;

	std::string toString(Reference<Task> task) const override {
		return format("beginKey '%s' endKey '%s' addTasks %d",
		              Params.beginKey().get(task).printable().c_str(),
		              Params.endKey().get(task).printable().c_str(),
		              Params.addBackupRangeTasks().get(task));
	}

	StringRef getName() const override { return name; };

	Future<Void> execute(Database cx,
	                     Reference<TaskBucket> tb,
	                     Reference<FutureBucket> fb,
	                     Reference<Task> task) override {
		return _execute(cx, tb, fb, task);
	};
	Future<Void> finish(Reference<ReadYourWritesTransaction> tr,
	                    Reference<TaskBucket> tb,
	                    Reference<FutureBucket> fb,
	                    Reference<Task> task) override {
		return _finish(tr, tb, fb, task);
	};

	// Finish (which flushes/syncs) the file, and then in a single transaction, make some range backup progress
	// durable. This means:
	//  - increment the backup config's range bytes written
	//  - update the range file map
	//  - update the task begin key
	//  - save/extend the task with the new params
	// Returns whether or not the caller should continue executing the task.
																#line 14106 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via finishRangeFile()
															#line 2041 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class FinishRangeFileActor>
															#line 2041 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class FinishRangeFileActorState {
															#line 14112 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 2041 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	FinishRangeFileActorState(Reference<IBackupFile> const& file,Database const& cx,Reference<Task> const& task,Reference<TaskBucket> const& taskBucket,KeyRange const& range,Version const& version) 
															#line 2041 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 2041 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : file(file),
															#line 2041 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   cx(cx),
															#line 2041 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   task(task),
															#line 2041 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   taskBucket(taskBucket),
															#line 2041 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   range(range),
															#line 2041 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   version(version)
															#line 14129 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("finishRangeFile", reinterpret_cast<unsigned long>(this));

	}
	~FinishRangeFileActorState() 
	{
		fdb_probe_actor_destroy("finishRangeFile", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2047 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_0 = file->finish();
															#line 2047 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<FinishRangeFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14146 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FinishRangeFileActor*>(this)->actor_wait_state = 1;
															#line 2047 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FinishRangeFileActor, 0, Void >*>(static_cast<FinishRangeFileActor*>(this)));
															#line 14151 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FinishRangeFileActorState();
		static_cast<FinishRangeFileActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 2050 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (range.empty())
															#line 14174 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 2051 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!static_cast<FinishRangeFileActor*>(this)->SAV<bool>::futures) { (void)(false); this->~FinishRangeFileActorState(); static_cast<FinishRangeFileActor*>(this)->destroy(); return 0; }
															#line 14178 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			new (&static_cast<FinishRangeFileActor*>(this)->SAV< bool >::value()) bool(false);
			this->~FinishRangeFileActorState();
			static_cast<FinishRangeFileActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2053 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		tr = Reference<ReadYourWritesTransaction>(new ReadYourWritesTransaction(cx));
															#line 2054 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		backup = BackupConfig(task);
															#line 2055 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		usedFile = false;
															#line 2059 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = task->extendMutex.take();
															#line 2059 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<FinishRangeFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14194 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<FinishRangeFileActor*>(this)->actor_wait_state = 2;
															#line 2059 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FinishRangeFileActor, 1, Void >*>(static_cast<FinishRangeFileActor*>(this)));
															#line 14199 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 2050 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (range.empty())
															#line 14208 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 2051 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!static_cast<FinishRangeFileActor*>(this)->SAV<bool>::futures) { (void)(false); this->~FinishRangeFileActorState(); static_cast<FinishRangeFileActor*>(this)->destroy(); return 0; }
															#line 14212 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			new (&static_cast<FinishRangeFileActor*>(this)->SAV< bool >::value()) bool(false);
			this->~FinishRangeFileActorState();
			static_cast<FinishRangeFileActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2053 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		tr = Reference<ReadYourWritesTransaction>(new ReadYourWritesTransaction(cx));
															#line 2054 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		backup = BackupConfig(task);
															#line 2055 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		usedFile = false;
															#line 2059 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = task->extendMutex.take();
															#line 2059 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<FinishRangeFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14228 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<FinishRangeFileActor*>(this)->actor_wait_state = 2;
															#line 2059 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FinishRangeFileActor, 1, Void >*>(static_cast<FinishRangeFileActor*>(this)));
															#line 14233 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FinishRangeFileActor*>(this)->actor_wait_state > 0) static_cast<FinishRangeFileActor*>(this)->actor_wait_state = 0;
		static_cast<FinishRangeFileActor*>(this)->ActorCallback< FinishRangeFileActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FinishRangeFileActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("finishRangeFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishRangeFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishRangeFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FinishRangeFileActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("finishRangeFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishRangeFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishRangeFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FinishRangeFileActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("finishRangeFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FinishRangeFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishRangeFile", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 2060 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		releaser = FlowLock::Releaser(task->extendMutex, 1);
															#line 2062 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		;
															#line 14319 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 2060 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		releaser = FlowLock::Releaser(task->extendMutex, 1);
															#line 2062 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		;
															#line 14330 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<FinishRangeFileActor*>(this)->actor_wait_state > 0) static_cast<FinishRangeFileActor*>(this)->actor_wait_state = 0;
		static_cast<FinishRangeFileActor*>(this)->ActorCallback< FinishRangeFileActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FinishRangeFileActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("finishRangeFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishRangeFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishRangeFile", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FinishRangeFileActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("finishRangeFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishRangeFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishRangeFile", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FinishRangeFileActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("finishRangeFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FinishRangeFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishRangeFile", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 2094 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<FinishRangeFileActor*>(this)->SAV<bool>::futures) { (void)(usedFile); this->~FinishRangeFileActorState(); static_cast<FinishRangeFileActor*>(this)->destroy(); return 0; }
															#line 14414 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<FinishRangeFileActor*>(this)->SAV< bool >::value()) bool(std::move(usedFile)); // state_var_RVO
		this->~FinishRangeFileActorState();
		static_cast<FinishRangeFileActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1(int loopDepth) 
	{
		try {
															#line 2064 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 2065 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 2069 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			Params.beginKey().set(task, range.end);
															#line 2072 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Version> __when_expr_2 = taskBucket->extendTimeout(tr, task, UpdateParams::True);
															#line 2072 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<FinishRangeFileActor*>(this)->actor_wait_state < 0) return a_body1cont2loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 14442 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont2loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2loopBody1when1(__when_expr_2.get(), loopDepth); };
			static_cast<FinishRangeFileActor*>(this)->actor_wait_state = 3;
															#line 2072 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< FinishRangeFileActor, 2, Version >*>(static_cast<FinishRangeFileActor*>(this)));
															#line 14447 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont2loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2break1(int loopDepth) 
	{
		try {
			return a_body1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2090 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_5 = tr->onError(e);
															#line 2090 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<FinishRangeFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 14484 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1Catch1when1(__when_expr_5.get(), loopDepth); };
			static_cast<FinishRangeFileActor*>(this)->actor_wait_state = 6;
															#line 2090 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< FinishRangeFileActor, 5, Void >*>(static_cast<FinishRangeFileActor*>(this)));
															#line 14489 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont2(int loopDepth) 
	{
															#line 2075 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		backup.rangeBytesWritten().atomicOp(tr, file->size(), MutationRef::AddValue);
															#line 2076 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		backup.snapshotRangeFileCount().atomicOp(tr, 1, MutationRef::AddValue);
															#line 2079 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Optional<BackupConfig::RangeSlice>> __when_expr_3 = backup.snapshotRangeFileMap().get(tr, range.end);
															#line 2079 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<FinishRangeFileActor*>(this)->actor_wait_state < 0) return a_body1cont2loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 14510 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont2loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont2loopBody1cont2when1(__when_expr_3.get(), loopDepth); };
		static_cast<FinishRangeFileActor*>(this)->actor_wait_state = 4;
															#line 2079 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< FinishRangeFileActor, 3, Optional<BackupConfig::RangeSlice> >*>(static_cast<FinishRangeFileActor*>(this)));
															#line 14515 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Version const& __newTimeout,int loopDepth) 
	{
															#line 2072 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		newTimeout = __newTimeout;
															#line 14524 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Version && __newTimeout,int loopDepth) 
	{
		newTimeout = std::move(__newTimeout);
		loopDepth = a_body1cont2loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<FinishRangeFileActor*>(this)->actor_wait_state > 0) static_cast<FinishRangeFileActor*>(this)->actor_wait_state = 0;
		static_cast<FinishRangeFileActor*>(this)->ActorCallback< FinishRangeFileActor, 2, Version >::remove();

	}
	void a_callback_fire(ActorCallback< FinishRangeFileActor, 2, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("finishRangeFile", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishRangeFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishRangeFile", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< FinishRangeFileActor, 2, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("finishRangeFile", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishRangeFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishRangeFile", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< FinishRangeFileActor, 2, Version >*,Error err) 
	{
		fdb_probe_actor_enter("finishRangeFile", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FinishRangeFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishRangeFile", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont2loopBody1cont3(Optional<BackupConfig::RangeSlice> const& s,int loopDepth) 
	{
															#line 2080 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!s.present() || s.get().begin >= range.begin)
															#line 14603 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 2081 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			backup.snapshotRangeFileMap().set( tr, range.end, { range.begin, version, file->getFileName(), file->size() });
															#line 2083 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			usedFile = true;
															#line 14609 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
															#line 2086 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_4 = tr->commit();
															#line 2086 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<FinishRangeFileActor*>(this)->actor_wait_state < 0) return a_body1cont2loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 14615 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont2loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont2loopBody1cont3when1(__when_expr_4.get(), loopDepth); };
		static_cast<FinishRangeFileActor*>(this)->actor_wait_state = 5;
															#line 2086 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< FinishRangeFileActor, 4, Void >*>(static_cast<FinishRangeFileActor*>(this)));
															#line 14620 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2loopBody1cont3(Optional<BackupConfig::RangeSlice> && s,int loopDepth) 
	{
															#line 2080 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!s.present() || s.get().begin >= range.begin)
															#line 14629 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 2081 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			backup.snapshotRangeFileMap().set( tr, range.end, { range.begin, version, file->getFileName(), file->size() });
															#line 2083 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			usedFile = true;
															#line 14635 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
															#line 2086 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_4 = tr->commit();
															#line 2086 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<FinishRangeFileActor*>(this)->actor_wait_state < 0) return a_body1cont2loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 14641 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont2loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont2loopBody1cont3when1(__when_expr_4.get(), loopDepth); };
		static_cast<FinishRangeFileActor*>(this)->actor_wait_state = 5;
															#line 2086 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< FinishRangeFileActor, 4, Void >*>(static_cast<FinishRangeFileActor*>(this)));
															#line 14646 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2loopBody1cont2when1(Optional<BackupConfig::RangeSlice> const& s,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont3(s, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont2when1(Optional<BackupConfig::RangeSlice> && s,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont3(std::move(s), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<FinishRangeFileActor*>(this)->actor_wait_state > 0) static_cast<FinishRangeFileActor*>(this)->actor_wait_state = 0;
		static_cast<FinishRangeFileActor*>(this)->ActorCallback< FinishRangeFileActor, 3, Optional<BackupConfig::RangeSlice> >::remove();

	}
	void a_callback_fire(ActorCallback< FinishRangeFileActor, 3, Optional<BackupConfig::RangeSlice> >*,Optional<BackupConfig::RangeSlice> const& value) 
	{
		fdb_probe_actor_enter("finishRangeFile", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishRangeFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishRangeFile", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< FinishRangeFileActor, 3, Optional<BackupConfig::RangeSlice> >*,Optional<BackupConfig::RangeSlice> && value) 
	{
		fdb_probe_actor_enter("finishRangeFile", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishRangeFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishRangeFile", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< FinishRangeFileActor, 3, Optional<BackupConfig::RangeSlice> >*,Error err) 
	{
		fdb_probe_actor_enter("finishRangeFile", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FinishRangeFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishRangeFile", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont2loopBody1cont4(Void const& _,int loopDepth) 
	{
															#line 2087 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		task->timeoutVersion = newTimeout;
															#line 14730 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont2loopBody1cont4(Void && _,int loopDepth) 
	{
															#line 2087 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		task->timeoutVersion = newTimeout;
															#line 14739 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont2loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<FinishRangeFileActor*>(this)->actor_wait_state > 0) static_cast<FinishRangeFileActor*>(this)->actor_wait_state = 0;
		static_cast<FinishRangeFileActor*>(this)->ActorCallback< FinishRangeFileActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FinishRangeFileActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("finishRangeFile", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishRangeFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont2loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishRangeFile", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< FinishRangeFileActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("finishRangeFile", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishRangeFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont2loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishRangeFile", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< FinishRangeFileActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("finishRangeFile", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FinishRangeFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont2loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishRangeFile", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont2loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<FinishRangeFileActor*>(this)->actor_wait_state > 0) static_cast<FinishRangeFileActor*>(this)->actor_wait_state = 0;
		static_cast<FinishRangeFileActor*>(this)->ActorCallback< FinishRangeFileActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FinishRangeFileActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("finishRangeFile", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishRangeFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont2loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishRangeFile", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< FinishRangeFileActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("finishRangeFile", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishRangeFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont2loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishRangeFile", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< FinishRangeFileActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("finishRangeFile", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FinishRangeFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishRangeFile", reinterpret_cast<unsigned long>(this), 5);

	}
															#line 2041 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<IBackupFile> file;
															#line 2041 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Database cx;
															#line 2041 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<Task> task;
															#line 2041 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<TaskBucket> taskBucket;
															#line 2041 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	KeyRange range;
															#line 2041 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Version version;
															#line 2053 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 2054 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	BackupConfig backup;
															#line 2055 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	bool usedFile;
															#line 2060 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	FlowLock::Releaser releaser;
															#line 2072 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Version newTimeout;
															#line 14928 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via finishRangeFile()
															#line 2041 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class FinishRangeFileActor final : public Actor<bool>, public ActorCallback< FinishRangeFileActor, 0, Void >, public ActorCallback< FinishRangeFileActor, 1, Void >, public ActorCallback< FinishRangeFileActor, 2, Version >, public ActorCallback< FinishRangeFileActor, 3, Optional<BackupConfig::RangeSlice> >, public ActorCallback< FinishRangeFileActor, 4, Void >, public ActorCallback< FinishRangeFileActor, 5, Void >, public FastAllocated<FinishRangeFileActor>, public FinishRangeFileActorState<FinishRangeFileActor> {
															#line 14933 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<FinishRangeFileActor>::operator new;
	using FastAllocated<FinishRangeFileActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1988389613902731008UL, 10892509980934753792UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FinishRangeFileActor, 0, Void >;
friend struct ActorCallback< FinishRangeFileActor, 1, Void >;
friend struct ActorCallback< FinishRangeFileActor, 2, Version >;
friend struct ActorCallback< FinishRangeFileActor, 3, Optional<BackupConfig::RangeSlice> >;
friend struct ActorCallback< FinishRangeFileActor, 4, Void >;
friend struct ActorCallback< FinishRangeFileActor, 5, Void >;
															#line 2041 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	FinishRangeFileActor(Reference<IBackupFile> const& file,Database const& cx,Reference<Task> const& task,Reference<TaskBucket> const& taskBucket,KeyRange const& range,Version const& version) 
															#line 14955 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<bool>(),
		   FinishRangeFileActorState<FinishRangeFileActor>(file, cx, task, taskBucket, range, version),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("finishRangeFile", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3667902104148193536UL, 8200535100199061504UL);
		ActorExecutionContextHelper __helper(static_cast<FinishRangeFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("finishRangeFile");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("finishRangeFile", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FinishRangeFileActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< FinishRangeFileActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< FinishRangeFileActor, 2, Version >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< FinishRangeFileActor, 3, Optional<BackupConfig::RangeSlice> >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< FinishRangeFileActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< FinishRangeFileActor, 5, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 2041 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] static Future<bool> finishRangeFile( Reference<IBackupFile> const& file, Database const& cx, Reference<Task> const& task, Reference<TaskBucket> const& taskBucket, KeyRange const& range, Version const& version ) {
															#line 2041 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<bool>(new FinishRangeFileActor(file, cx, task, taskBucket, range, version));
															#line 14992 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 2096 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

																#line 14997 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via addTask()
															#line 2097 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class AddTaskActor>
															#line 2097 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class AddTaskActorState {
															#line 15003 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 2097 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	AddTaskActorState(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,Reference<Task> const& parentTask,int const& priority,Key const& begin,Key const& end,TaskCompletionKey const& completionKey,Reference<TaskFuture> const& waitFor = Reference<TaskFuture>(),Version const& scheduledVersion = invalidVersion) 
															#line 2097 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 2097 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : tr(tr),
															#line 2097 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   taskBucket(taskBucket),
															#line 2097 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   parentTask(parentTask),
															#line 2097 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   priority(priority),
															#line 2097 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   begin(begin),
															#line 2097 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   end(end),
															#line 2097 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   completionKey(completionKey),
															#line 2097 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   waitFor(waitFor),
															#line 2097 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   scheduledVersion(scheduledVersion)
															#line 15026 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("addTask", reinterpret_cast<unsigned long>(this));

	}
	~AddTaskActorState() 
	{
		fdb_probe_actor_destroy("addTask", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2106 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Key> __when_expr_0 = addBackupTask( BackupRangeTaskFunc::name, BackupRangeTaskFunc::version, tr, taskBucket, completionKey, BackupConfig(parentTask), waitFor, [=](Reference<Task> task) { Params.beginKey().set(task, begin); Params.endKey().set(task, end); Params.addBackupRangeTasks().set(task, false); if (scheduledVersion != invalidVersion) ReservedTaskParams::scheduledVersion().set(task, scheduledVersion); }, priority);
															#line 2106 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<AddTaskActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15043 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<AddTaskActor*>(this)->actor_wait_state = 1;
															#line 2106 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< AddTaskActor, 0, Key >*>(static_cast<AddTaskActor*>(this)));
															#line 15048 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~AddTaskActorState();
		static_cast<AddTaskActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Key const& key,int loopDepth) 
	{
															#line 2122 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<AddTaskActor*>(this)->SAV<Key>::futures) { (void)(key); this->~AddTaskActorState(); static_cast<AddTaskActor*>(this)->destroy(); return 0; }
															#line 15071 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<AddTaskActor*>(this)->SAV< Key >::value()) Key(key);
		this->~AddTaskActorState();
		static_cast<AddTaskActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Key && key,int loopDepth) 
	{
															#line 2122 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<AddTaskActor*>(this)->SAV<Key>::futures) { (void)(key); this->~AddTaskActorState(); static_cast<AddTaskActor*>(this)->destroy(); return 0; }
															#line 15083 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<AddTaskActor*>(this)->SAV< Key >::value()) Key(key);
		this->~AddTaskActorState();
		static_cast<AddTaskActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Key const& key,int loopDepth) 
	{
		loopDepth = a_body1cont1(key, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Key && key,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(key), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<AddTaskActor*>(this)->actor_wait_state > 0) static_cast<AddTaskActor*>(this)->actor_wait_state = 0;
		static_cast<AddTaskActor*>(this)->ActorCallback< AddTaskActor, 0, Key >::remove();

	}
	void a_callback_fire(ActorCallback< AddTaskActor, 0, Key >*,Key const& value) 
	{
		fdb_probe_actor_enter("addTask", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addTask", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< AddTaskActor, 0, Key >*,Key && value) 
	{
		fdb_probe_actor_enter("addTask", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addTask", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< AddTaskActor, 0, Key >*,Error err) 
	{
		fdb_probe_actor_enter("addTask", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AddTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addTask", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 2097 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 2097 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<TaskBucket> taskBucket;
															#line 2097 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<Task> parentTask;
															#line 2097 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	int priority;
															#line 2097 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Key begin;
															#line 2097 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Key end;
															#line 2097 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	TaskCompletionKey completionKey;
															#line 2097 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<TaskFuture> waitFor;
															#line 2097 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Version scheduledVersion;
															#line 15184 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via addTask()
															#line 2097 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class AddTaskActor final : public Actor<Key>, public ActorCallback< AddTaskActor, 0, Key >, public FastAllocated<AddTaskActor>, public AddTaskActorState<AddTaskActor> {
															#line 15189 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<AddTaskActor>::operator new;
	using FastAllocated<AddTaskActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5143048427509330944UL, 4969338633465486592UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Key>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< AddTaskActor, 0, Key >;
															#line 2097 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	AddTaskActor(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,Reference<Task> const& parentTask,int const& priority,Key const& begin,Key const& end,TaskCompletionKey const& completionKey,Reference<TaskFuture> const& waitFor = Reference<TaskFuture>(),Version const& scheduledVersion = invalidVersion) 
															#line 15206 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<Key>(),
		   AddTaskActorState<AddTaskActor>(tr, taskBucket, parentTask, priority, begin, end, completionKey, waitFor, scheduledVersion),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("addTask", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6060296532077720576UL, 16456885635641163264UL);
		ActorExecutionContextHelper __helper(static_cast<AddTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("addTask");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("addTask", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< AddTaskActor, 0, Key >*)0, actor_cancelled()); break;
		}

	}
};
															#line 2097 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] static Future<Key> addTask( Reference<ReadYourWritesTransaction> const& tr, Reference<TaskBucket> const& taskBucket, Reference<Task> const& parentTask, int const& priority, Key const& begin, Key const& end, TaskCompletionKey const& completionKey, Reference<TaskFuture> const& waitFor = Reference<TaskFuture>(), Version const& scheduledVersion = invalidVersion ) {
															#line 2097 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Key>(new AddTaskActor(tr, taskBucket, parentTask, priority, begin, end, completionKey, waitFor, scheduledVersion));
															#line 15238 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 2124 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

																#line 15243 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via _execute()
															#line 2125 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class _executeActor>
															#line 2125 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class _executeActorState {
															#line 15249 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 2125 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	_executeActorState(Database const& cx,Reference<TaskBucket> const& taskBucket,Reference<FutureBucket> const& futureBucket,Reference<Task> const& task) 
															#line 2125 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 2125 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : cx(cx),
															#line 2125 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   taskBucket(taskBucket),
															#line 2125 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   futureBucket(futureBucket),
															#line 2125 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   task(task),
															#line 2129 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   lock(new FlowLock(CLIENT_KNOBS->BACKUP_LOCK_BYTES))
															#line 15264 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("_execute", reinterpret_cast<unsigned long>(this));

	}
	~_executeActorState() 
	{
		fdb_probe_actor_destroy("_execute", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2131 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_0 = checkTaskVersion(cx, task, BackupRangeTaskFunc::name, BackupRangeTaskFunc::version);
															#line 2131 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<_executeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15281 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_executeActor*>(this)->actor_wait_state = 1;
															#line 2131 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _executeActor, 0, Void >*>(static_cast<_executeActor*>(this)));
															#line 15286 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_executeActorState();
		static_cast<_executeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 2133 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		beginKey = Params.beginKey().get(task);
															#line 2134 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		endKey = Params.endKey().get(task);
															#line 2136 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		TraceEvent("FileBackupRangeStart") .suppressFor(60) .detail("BackupUID", BackupConfig(task).getUid()) .detail("BeginKey", Params.beginKey().get(task).printable()) .detail("EndKey", Params.endKey().get(task).printable()) .detail("TaskKey", task->key.printable());
															#line 2145 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (beginKey == endKey)
															#line 15315 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 2146 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!static_cast<_executeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_executeActorState(); static_cast<_executeActor*>(this)->destroy(); return 0; }
															#line 15319 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			new (&static_cast<_executeActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~_executeActorState();
			static_cast<_executeActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2149 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Standalone<VectorRef<KeyRef>>> __when_expr_1 = runRYWTransaction( cx, [=](Reference<ReadYourWritesTransaction> tr) { return getBlockOfShards(tr, beginKey, endKey, 1); });
															#line 2149 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<_executeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15329 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_executeActor*>(this)->actor_wait_state = 2;
															#line 2149 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _executeActor, 1, Standalone<VectorRef<KeyRef>> >*>(static_cast<_executeActor*>(this)));
															#line 15334 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 2133 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		beginKey = Params.beginKey().get(task);
															#line 2134 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		endKey = Params.endKey().get(task);
															#line 2136 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		TraceEvent("FileBackupRangeStart") .suppressFor(60) .detail("BackupUID", BackupConfig(task).getUid()) .detail("BeginKey", Params.beginKey().get(task).printable()) .detail("EndKey", Params.endKey().get(task).printable()) .detail("TaskKey", task->key.printable());
															#line 2145 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (beginKey == endKey)
															#line 15349 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 2146 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!static_cast<_executeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_executeActorState(); static_cast<_executeActor*>(this)->destroy(); return 0; }
															#line 15353 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			new (&static_cast<_executeActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~_executeActorState();
			static_cast<_executeActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2149 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Standalone<VectorRef<KeyRef>>> __when_expr_1 = runRYWTransaction( cx, [=](Reference<ReadYourWritesTransaction> tr) { return getBlockOfShards(tr, beginKey, endKey, 1); });
															#line 2149 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<_executeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15363 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_executeActor*>(this)->actor_wait_state = 2;
															#line 2149 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _executeActor, 1, Standalone<VectorRef<KeyRef>> >*>(static_cast<_executeActor*>(this)));
															#line 15368 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_executeActor*>(this)->actor_wait_state > 0) static_cast<_executeActor*>(this)->actor_wait_state = 0;
		static_cast<_executeActor*>(this)->ActorCallback< _executeActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _executeActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _executeActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _executeActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Standalone<VectorRef<KeyRef>> const& keys,int loopDepth) 
	{
															#line 2151 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (keys.size() > 0)
															#line 15452 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 2152 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			Params.addBackupRangeTasks().set(task, true);
															#line 2153 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!static_cast<_executeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_executeActorState(); static_cast<_executeActor*>(this)->destroy(); return 0; }
															#line 15458 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			new (&static_cast<_executeActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~_executeActorState();
			static_cast<_executeActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2159 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		outFile = Reference<IBackupFile>();
															#line 2160 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		outVersion = invalidVersion;
															#line 2161 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		lastKey = Key();
															#line 2164 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		results = PromiseStream<RangeResultWithVersion>();
															#line 2166 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		rc = readCommitted(cx, results, lock, KeyRangeRef(beginKey, endKey), Terminator::True, AccessSystemKeys::True, LockAware::True);
															#line 2173 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		rangeFile = std::unique_ptr<IRangeFileWriter>();
															#line 2174 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		backup = BackupConfig(task);
															#line 2175 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		arena = Arena();
															#line 2177 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<DatabaseConfiguration> __when_expr_2 = getDatabaseConfiguration(cx);
															#line 2177 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<_executeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15484 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<_executeActor*>(this)->actor_wait_state = 3;
															#line 2177 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _executeActor, 2, DatabaseConfiguration >*>(static_cast<_executeActor*>(this)));
															#line 15489 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Standalone<VectorRef<KeyRef>> && keys,int loopDepth) 
	{
															#line 2151 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (keys.size() > 0)
															#line 15498 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 2152 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			Params.addBackupRangeTasks().set(task, true);
															#line 2153 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!static_cast<_executeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_executeActorState(); static_cast<_executeActor*>(this)->destroy(); return 0; }
															#line 15504 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			new (&static_cast<_executeActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~_executeActorState();
			static_cast<_executeActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2159 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		outFile = Reference<IBackupFile>();
															#line 2160 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		outVersion = invalidVersion;
															#line 2161 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		lastKey = Key();
															#line 2164 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		results = PromiseStream<RangeResultWithVersion>();
															#line 2166 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		rc = readCommitted(cx, results, lock, KeyRangeRef(beginKey, endKey), Terminator::True, AccessSystemKeys::True, LockAware::True);
															#line 2173 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		rangeFile = std::unique_ptr<IRangeFileWriter>();
															#line 2174 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		backup = BackupConfig(task);
															#line 2175 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		arena = Arena();
															#line 2177 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<DatabaseConfiguration> __when_expr_2 = getDatabaseConfiguration(cx);
															#line 2177 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<_executeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15530 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<_executeActor*>(this)->actor_wait_state = 3;
															#line 2177 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _executeActor, 2, DatabaseConfiguration >*>(static_cast<_executeActor*>(this)));
															#line 15535 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Standalone<VectorRef<KeyRef>> const& keys,int loopDepth) 
	{
		loopDepth = a_body1cont2(keys, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Standalone<VectorRef<KeyRef>> && keys,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(keys), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_executeActor*>(this)->actor_wait_state > 0) static_cast<_executeActor*>(this)->actor_wait_state = 0;
		static_cast<_executeActor*>(this)->ActorCallback< _executeActor, 1, Standalone<VectorRef<KeyRef>> >::remove();

	}
	void a_callback_fire(ActorCallback< _executeActor, 1, Standalone<VectorRef<KeyRef>> >*,Standalone<VectorRef<KeyRef>> const& value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _executeActor, 1, Standalone<VectorRef<KeyRef>> >*,Standalone<VectorRef<KeyRef>> && value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _executeActor, 1, Standalone<VectorRef<KeyRef>> >*,Error err) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(DatabaseConfiguration const& config,int loopDepth) 
	{
															#line 2181 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Reference<IBackupContainer>> __when_expr_3 = backup.backupContainer().getD(cx.getReference());
															#line 2181 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<_executeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15621 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont4when1(__when_expr_3.get(), loopDepth); };
		static_cast<_executeActor*>(this)->actor_wait_state = 4;
															#line 2181 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _executeActor, 3, Reference<IBackupContainer> >*>(static_cast<_executeActor*>(this)));
															#line 15626 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(DatabaseConfiguration && config,int loopDepth) 
	{
															#line 2181 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Reference<IBackupContainer>> __when_expr_3 = backup.backupContainer().getD(cx.getReference());
															#line 2181 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<_executeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15637 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont4when1(__when_expr_3.get(), loopDepth); };
		static_cast<_executeActor*>(this)->actor_wait_state = 4;
															#line 2181 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _executeActor, 3, Reference<IBackupContainer> >*>(static_cast<_executeActor*>(this)));
															#line 15642 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(DatabaseConfiguration const& config,int loopDepth) 
	{
		loopDepth = a_body1cont4(config, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(DatabaseConfiguration && config,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(config), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_executeActor*>(this)->actor_wait_state > 0) static_cast<_executeActor*>(this)->actor_wait_state = 0;
		static_cast<_executeActor*>(this)->ActorCallback< _executeActor, 2, DatabaseConfiguration >::remove();

	}
	void a_callback_fire(ActorCallback< _executeActor, 2, DatabaseConfiguration >*,DatabaseConfiguration const& value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _executeActor, 2, DatabaseConfiguration >*,DatabaseConfiguration && value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _executeActor, 2, DatabaseConfiguration >*,Error err) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont6(Reference<IBackupContainer> const& _bc,int loopDepth) 
	{
															#line 2182 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!_bc)
															#line 15726 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 2183 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!static_cast<_executeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_executeActorState(); static_cast<_executeActor*>(this)->destroy(); return 0; }
															#line 15730 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			new (&static_cast<_executeActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~_executeActorState();
			static_cast<_executeActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2185 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		bc = getBackupContainerWithProxy(_bc);
															#line 2186 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		done = false;
															#line 2187 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		nrKeys = 0;
															#line 2189 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		;
															#line 15744 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont6loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Reference<IBackupContainer> && _bc,int loopDepth) 
	{
															#line 2182 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!_bc)
															#line 15753 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 2183 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!static_cast<_executeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_executeActorState(); static_cast<_executeActor*>(this)->destroy(); return 0; }
															#line 15757 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			new (&static_cast<_executeActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~_executeActorState();
			static_cast<_executeActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2185 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		bc = getBackupContainerWithProxy(_bc);
															#line 2186 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		done = false;
															#line 2187 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		nrKeys = 0;
															#line 2189 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		;
															#line 15771 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont6loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Reference<IBackupContainer> const& _bc,int loopDepth) 
	{
		loopDepth = a_body1cont6(_bc, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Reference<IBackupContainer> && _bc,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_bc), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<_executeActor*>(this)->actor_wait_state > 0) static_cast<_executeActor*>(this)->actor_wait_state = 0;
		static_cast<_executeActor*>(this)->ActorCallback< _executeActor, 3, Reference<IBackupContainer> >::remove();

	}
	void a_callback_fire(ActorCallback< _executeActor, 3, Reference<IBackupContainer> >*,Reference<IBackupContainer> const& value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _executeActor, 3, Reference<IBackupContainer> >*,Reference<IBackupContainer> && value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< _executeActor, 3, Reference<IBackupContainer> >*,Error err) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont6loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont6loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1(int loopDepth) 
	{
															#line 2190 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		values = RangeResultWithVersion();
															#line 15862 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		try {
															#line 2192 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			auto __when_expr_4 = results.getFuture();
															#line 15866 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			static_assert(std::is_same<decltype(__when_expr_4), FutureStream<RangeResultWithVersion>>::value || std::is_same<decltype(__when_expr_4), ThreadFutureStream<RangeResultWithVersion>>::value, "invalid type");
															#line 2192 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<_executeActor*>(this)->actor_wait_state < 0) return a_body1cont6loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 15870 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont6loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont6loopBody1when1(__when_expr_4.pop(), loopDepth); };
			static_cast<_executeActor*>(this)->actor_wait_state = 5;
															#line 2192 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorSingleCallback< _executeActor, 4, RangeResultWithVersion >*>(static_cast<_executeActor*>(this)));
															#line 15875 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont6loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont6loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont6loopBody1cont1(int loopDepth) 
	{
															#line 2204 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (values.second != outVersion || done)
															#line 15890 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 2205 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (outFile)
															#line 15894 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			{
															#line 2206 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				CODE_PROBE(outVersion != invalidVersion, "Backup range task wrote multiple versions");
															#line 2207 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				nextKey = done ? endKey : keyAfter(lastKey);
															#line 2208 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				StrictFuture<Void> __when_expr_5 = rangeFile->writeKey(nextKey);
															#line 2208 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				if (static_cast<_executeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 15904 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
				if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1cont6loopBody1cont1when1(__when_expr_5.get(), loopDepth); };
				static_cast<_executeActor*>(this)->actor_wait_state = 6;
															#line 2208 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< _executeActor, 5, Void >*>(static_cast<_executeActor*>(this)));
															#line 15909 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont6loopBody1cont6(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont6loopBody1cont5(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont6loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2196 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (e.code() == error_code_end_of_stream)
															#line 15929 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			{
															#line 2197 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				done = true;
															#line 15933 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			}
			else
			{
															#line 2199 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 15939 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			}
			loopDepth = a_body1cont6loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont6loopBody1cont2(RangeResultWithVersion const& _values,int loopDepth) 
	{
															#line 2193 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		values = _values;
															#line 2194 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		lock->release(values.first.expectedSize());
															#line 15957 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont6loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont2(RangeResultWithVersion && _values,int loopDepth) 
	{
															#line 2193 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		values = _values;
															#line 2194 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		lock->release(values.first.expectedSize());
															#line 15968 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont6loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1when1(RangeResultWithVersion const& _values,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont2(_values, loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1when1(RangeResultWithVersion && _values,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont2(std::move(_values), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<_executeActor*>(this)->actor_wait_state > 0) static_cast<_executeActor*>(this)->actor_wait_state = 0;
		static_cast<_executeActor*>(this)->ActorSingleCallback< _executeActor, 4, RangeResultWithVersion >::remove();

	}
	void a_callback_fire(ActorSingleCallback< _executeActor, 4, RangeResultWithVersion >*,RangeResultWithVersion const& value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont6loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont6loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont6loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorSingleCallback< _executeActor, 4, RangeResultWithVersion >*,RangeResultWithVersion && value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont6loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont6loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont6loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorSingleCallback< _executeActor, 4, RangeResultWithVersion >*,Error err) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont6loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont6loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont6loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont6loopBody1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont6loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont6loopBody1cont5(int loopDepth) 
	{
															#line 2271 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (values.first.size() != 0)
															#line 16065 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 2272 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			i = 0;
															#line 2273 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			;
															#line 16071 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = a_body1cont6loopBody1cont5loopHead1(loopDepth);
		}
		else
		{
			loopDepth = a_body1cont6loopBody1cont13(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont6loopBody1cont6(int loopDepth) 
	{
															#line 2232 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (done)
															#line 16085 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 2233 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!static_cast<_executeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_executeActorState(); static_cast<_executeActor*>(this)->destroy(); return 0; }
															#line 16089 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			new (&static_cast<_executeActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~_executeActorState();
			static_cast<_executeActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2237 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		outVersion = values.second;
															#line 2240 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		blockSize = BUGGIFY ? deterministicRandom()->randomInt(250e3, 4e6) : CLIENT_KNOBS->BACKUP_RANGEFILE_BLOCK_SIZE;
															#line 2242 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		snapshotBeginVersion = Version();
															#line 2243 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		snapshotRangeFileCount = int64_t();
															#line 2245 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		tr = Reference<ReadYourWritesTransaction>(new ReadYourWritesTransaction(cx));
															#line 2246 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		;
															#line 16107 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont6loopBody1cont6loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont7(Void const& _,int loopDepth) 
	{
															#line 2210 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (BUGGIFY)
															#line 16116 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 2211 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_6 = rangeFile->padEnd(true);
															#line 2211 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<_executeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 16122 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1cont6loopBody1cont7when1(__when_expr_6.get(), loopDepth); };
			static_cast<_executeActor*>(this)->actor_wait_state = 7;
															#line 2211 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< _executeActor, 6, Void >*>(static_cast<_executeActor*>(this)));
															#line 16127 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont6loopBody1cont8(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont6loopBody1cont7(Void && _,int loopDepth) 
	{
															#line 2210 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (BUGGIFY)
															#line 16141 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 2211 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_6 = rangeFile->padEnd(true);
															#line 2211 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<_executeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 16147 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1cont6loopBody1cont7when1(__when_expr_6.get(), loopDepth); };
			static_cast<_executeActor*>(this)->actor_wait_state = 7;
															#line 2211 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< _executeActor, 6, Void >*>(static_cast<_executeActor*>(this)));
															#line 16152 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont6loopBody1cont8(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont6loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<_executeActor*>(this)->actor_wait_state > 0) static_cast<_executeActor*>(this)->actor_wait_state = 0;
		static_cast<_executeActor*>(this)->ActorCallback< _executeActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _executeActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont6loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< _executeActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont6loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< _executeActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont6loopBody1cont8(int loopDepth) 
	{
															#line 2214 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_7 = rangeFile->finish();
															#line 2214 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<_executeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 16243 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), std::max(0, loopDepth - 1)); else return a_body1cont6loopBody1cont8when1(__when_expr_7.get(), loopDepth); };
		static_cast<_executeActor*>(this)->actor_wait_state = 8;
															#line 2214 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< _executeActor, 7, Void >*>(static_cast<_executeActor*>(this)));
															#line 16248 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6loopBody1cont9(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont9(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont7when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont7when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<_executeActor*>(this)->actor_wait_state > 0) static_cast<_executeActor*>(this)->actor_wait_state = 0;
		static_cast<_executeActor*>(this)->ActorCallback< _executeActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _executeActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont6loopBody1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< _executeActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont6loopBody1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< _executeActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont6loopBody1cont10(Void const& _,int loopDepth) 
	{
															#line 2216 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<bool> __when_expr_8 = finishRangeFile(outFile, cx, task, taskBucket, KeyRangeRef(beginKey, nextKey), outVersion);
															#line 2216 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<_executeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 16346 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), std::max(0, loopDepth - 1)); else return a_body1cont6loopBody1cont10when1(__when_expr_8.get(), loopDepth); };
		static_cast<_executeActor*>(this)->actor_wait_state = 9;
															#line 2216 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< _executeActor, 8, bool >*>(static_cast<_executeActor*>(this)));
															#line 16351 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6loopBody1cont10(Void && _,int loopDepth) 
	{
															#line 2216 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<bool> __when_expr_8 = finishRangeFile(outFile, cx, task, taskBucket, KeyRangeRef(beginKey, nextKey), outVersion);
															#line 2216 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<_executeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 16362 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), std::max(0, loopDepth - 1)); else return a_body1cont6loopBody1cont10when1(__when_expr_8.get(), loopDepth); };
		static_cast<_executeActor*>(this)->actor_wait_state = 9;
															#line 2216 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< _executeActor, 8, bool >*>(static_cast<_executeActor*>(this)));
															#line 16367 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6loopBody1cont8when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont8when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<_executeActor*>(this)->actor_wait_state > 0) static_cast<_executeActor*>(this)->actor_wait_state = 0;
		static_cast<_executeActor*>(this)->ActorCallback< _executeActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _executeActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont6loopBody1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< _executeActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont6loopBody1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< _executeActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont6loopBody1cont10cont1(bool const& usedFile,int loopDepth) 
	{
															#line 2218 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		TraceEvent("FileBackupWroteRangeFile") .suppressFor(60) .detail("BackupUID", backup.getUid()) .detail("Size", outFile->size()) .detail("Keys", nrKeys) .detail("ReadVersion", outVersion) .detail("BeginKey", beginKey.printable()) .detail("EndKey", nextKey.printable()) .detail("AddedFileToMap", usedFile);
															#line 2228 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		nrKeys = 0;
															#line 2229 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		beginKey = nextKey;
															#line 16455 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont6loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont10cont1(bool && usedFile,int loopDepth) 
	{
															#line 2218 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		TraceEvent("FileBackupWroteRangeFile") .suppressFor(60) .detail("BackupUID", backup.getUid()) .detail("Size", outFile->size()) .detail("Keys", nrKeys) .detail("ReadVersion", outVersion) .detail("BeginKey", beginKey.printable()) .detail("EndKey", nextKey.printable()) .detail("AddedFileToMap", usedFile);
															#line 2228 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		nrKeys = 0;
															#line 2229 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		beginKey = nextKey;
															#line 16468 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont6loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont10when1(bool const& usedFile,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont10cont1(usedFile, loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont10when1(bool && usedFile,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont10cont1(std::move(usedFile), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<_executeActor*>(this)->actor_wait_state > 0) static_cast<_executeActor*>(this)->actor_wait_state = 0;
		static_cast<_executeActor*>(this)->ActorCallback< _executeActor, 8, bool >::remove();

	}
	void a_callback_fire(ActorCallback< _executeActor, 8, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont6loopBody1cont10when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< _executeActor, 8, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont6loopBody1cont10when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< _executeActor, 8, bool >*,Error err) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont6loopBody1cont11(int loopDepth) 
	{
															#line 2261 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Reference<IBackupFile>> __when_expr_11 = bc->writeRangeFile(snapshotBeginVersion, snapshotRangeFileCount, outVersion, blockSize);
															#line 2261 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<_executeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 16554 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1Catch1(__when_expr_11.getError(), std::max(0, loopDepth - 1)); else return a_body1cont6loopBody1cont11when1(__when_expr_11.get(), loopDepth); };
		static_cast<_executeActor*>(this)->actor_wait_state = 12;
															#line 2261 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< _executeActor, 11, Reference<IBackupFile> >*>(static_cast<_executeActor*>(this)));
															#line 16559 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6loopBody1cont6loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont6loopBody1cont6loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont6loopBody1(int loopDepth) 
	{
		try {
															#line 2248 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 2249 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 2251 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_9 = taskBucket->keepRunning(tr, task) && storeOrThrow(snapshotBeginVersion, backup.snapshotBeginVersion().get(tr)) && store(snapshotRangeFileCount, backup.snapshotRangeFileCount().getD(tr));
															#line 2251 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<_executeActor*>(this)->actor_wait_state < 0) return a_body1cont6loopBody1cont6loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 16582 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1cont6loopBody1cont6loopBody1Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont6loopBody1cont6loopBody1when1(__when_expr_9.get(), loopDepth); };
			static_cast<_executeActor*>(this)->actor_wait_state = 10;
															#line 2251 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< _executeActor, 9, Void >*>(static_cast<_executeActor*>(this)));
															#line 16587 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont6loopBody1cont6loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont6loopBody1cont6loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont6loopBody1cont6break1(int loopDepth) 
	{
		try {
			return a_body1cont6loopBody1cont11(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont6loopBody1cont6loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont6loopBody1cont6loopHead1(0);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont6loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2257 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_10 = tr->onError(e);
															#line 2257 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<_executeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 16624 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1Catch1(__when_expr_10.getError(), std::max(0, loopDepth - 2)); else return a_body1cont6loopBody1cont6loopBody1Catch1when1(__when_expr_10.get(), loopDepth); };
			static_cast<_executeActor*>(this)->actor_wait_state = 11;
															#line 2257 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< _executeActor, 10, Void >*>(static_cast<_executeActor*>(this)));
															#line 16629 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1cont6loopBody1cont6loopBody1cont2(Void const& _,int loopDepth) 
	{
		return a_body1cont6loopBody1cont6break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont6loopBody1cont6loopBody1cont2(Void && _,int loopDepth) 
	{
		return a_body1cont6loopBody1cont6break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont6loopBody1cont6loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont6loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont6loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont6loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<_executeActor*>(this)->actor_wait_state > 0) static_cast<_executeActor*>(this)->actor_wait_state = 0;
		static_cast<_executeActor*>(this)->ActorCallback< _executeActor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _executeActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont6loopBody1cont6loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont6loopBody1cont6loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont6loopBody1cont6loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< _executeActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont6loopBody1cont6loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont6loopBody1cont6loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont6loopBody1cont6loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< _executeActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont6loopBody1cont6loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont6loopBody1cont6loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont6loopBody1cont6loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1cont6loopBody1cont6loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont6loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont6loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont6loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont6loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont6loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont6loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont6loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose11() 
	{
		if (static_cast<_executeActor*>(this)->actor_wait_state > 0) static_cast<_executeActor*>(this)->actor_wait_state = 0;
		static_cast<_executeActor*>(this)->ActorCallback< _executeActor, 10, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _executeActor, 10, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont6loopBody1cont6loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< _executeActor, 10, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont6loopBody1cont6loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< _executeActor, 10, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 10);

	}
	int a_body1cont6loopBody1cont11cont1(Reference<IBackupFile> const& f,int loopDepth) 
	{
															#line 2263 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		outFile = f;
															#line 2266 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		rangeFile = std::make_unique<RangeFileWriter>(outFile, blockSize);
															#line 2267 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_12 = rangeFile->writeKey(beginKey);
															#line 2267 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<_executeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 16824 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_12.isReady()) { if (__when_expr_12.isError()) return a_body1Catch1(__when_expr_12.getError(), std::max(0, loopDepth - 1)); else return a_body1cont6loopBody1cont11cont1when1(__when_expr_12.get(), loopDepth); };
		static_cast<_executeActor*>(this)->actor_wait_state = 13;
															#line 2267 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_12.addCallbackAndClear(static_cast<ActorCallback< _executeActor, 12, Void >*>(static_cast<_executeActor*>(this)));
															#line 16829 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6loopBody1cont11cont1(Reference<IBackupFile> && f,int loopDepth) 
	{
															#line 2263 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		outFile = f;
															#line 2266 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		rangeFile = std::make_unique<RangeFileWriter>(outFile, blockSize);
															#line 2267 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_12 = rangeFile->writeKey(beginKey);
															#line 2267 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<_executeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 16844 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_12.isReady()) { if (__when_expr_12.isError()) return a_body1Catch1(__when_expr_12.getError(), std::max(0, loopDepth - 1)); else return a_body1cont6loopBody1cont11cont1when1(__when_expr_12.get(), loopDepth); };
		static_cast<_executeActor*>(this)->actor_wait_state = 13;
															#line 2267 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_12.addCallbackAndClear(static_cast<ActorCallback< _executeActor, 12, Void >*>(static_cast<_executeActor*>(this)));
															#line 16849 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6loopBody1cont11when1(Reference<IBackupFile> const& f,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont11cont1(f, loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont11when1(Reference<IBackupFile> && f,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont11cont1(std::move(f), loopDepth);

		return loopDepth;
	}
	void a_exitChoose12() 
	{
		if (static_cast<_executeActor*>(this)->actor_wait_state > 0) static_cast<_executeActor*>(this)->actor_wait_state = 0;
		static_cast<_executeActor*>(this)->ActorCallback< _executeActor, 11, Reference<IBackupFile> >::remove();

	}
	void a_callback_fire(ActorCallback< _executeActor, 11, Reference<IBackupFile> >*,Reference<IBackupFile> const& value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont6loopBody1cont11when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorCallback< _executeActor, 11, Reference<IBackupFile> >*,Reference<IBackupFile> && value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont6loopBody1cont11when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_error(ActorCallback< _executeActor, 11, Reference<IBackupFile> >*,Error err) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 11);

	}
	int a_body1cont6loopBody1cont11cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont11cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont11cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont11cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont11cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont11cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose13() 
	{
		if (static_cast<_executeActor*>(this)->actor_wait_state > 0) static_cast<_executeActor*>(this)->actor_wait_state = 0;
		static_cast<_executeActor*>(this)->ActorCallback< _executeActor, 12, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _executeActor, 12, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont6loopBody1cont11cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_fire(ActorCallback< _executeActor, 12, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont6loopBody1cont11cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_error(ActorCallback< _executeActor, 12, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 12);

	}
	int a_body1cont6loopBody1cont13(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont6loopHead1(0);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont14(int loopDepth) 
	{
															#line 2276 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		lastKey = values.first.back().key;
															#line 2277 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		nrKeys += values.first.size();
															#line 17028 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont6loopBody1cont13(loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont5loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont6loopBody1cont5loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont5loopBody1(int loopDepth) 
	{
															#line 2273 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!(i < values.first.size()))
															#line 17044 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
			return a_body1cont6loopBody1cont5break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 2274 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_13 = rangeFile->writeKV(values.first[i].key, values.first[i].value);
															#line 2274 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<_executeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 17052 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_13.isReady()) { if (__when_expr_13.isError()) return a_body1Catch1(__when_expr_13.getError(), std::max(0, loopDepth - 2)); else return a_body1cont6loopBody1cont5loopBody1when1(__when_expr_13.get(), loopDepth); };
		static_cast<_executeActor*>(this)->actor_wait_state = 14;
															#line 2274 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_13.addCallbackAndClear(static_cast<ActorCallback< _executeActor, 13, Void >*>(static_cast<_executeActor*>(this)));
															#line 17057 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6loopBody1cont5break1(int loopDepth) 
	{
		try {
			return a_body1cont6loopBody1cont14(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont6loopBody1cont5loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 2273 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		++i;
															#line 17079 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont6loopBody1cont5loopHead1(0);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont5loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 2273 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		++i;
															#line 17088 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont6loopBody1cont5loopHead1(0);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont5loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont5loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont5loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont5loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose14() 
	{
		if (static_cast<_executeActor*>(this)->actor_wait_state > 0) static_cast<_executeActor*>(this)->actor_wait_state = 0;
		static_cast<_executeActor*>(this)->ActorCallback< _executeActor, 13, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _executeActor, 13, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont6loopBody1cont5loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_fire(ActorCallback< _executeActor, 13, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont6loopBody1cont5loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_error(ActorCallback< _executeActor, 13, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 13);

	}
															#line 2125 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Database cx;
															#line 2125 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<TaskBucket> taskBucket;
															#line 2125 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<FutureBucket> futureBucket;
															#line 2125 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<Task> task;
															#line 2129 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<FlowLock> lock;
															#line 2133 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Key beginKey;
															#line 2134 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Key endKey;
															#line 2159 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<IBackupFile> outFile;
															#line 2160 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Version outVersion;
															#line 2161 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Key lastKey;
															#line 2164 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	PromiseStream<RangeResultWithVersion> results;
															#line 2166 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Future<Void> rc;
															#line 2173 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	std::unique_ptr<IRangeFileWriter> rangeFile;
															#line 2174 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	BackupConfig backup;
															#line 2175 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Arena arena;
															#line 2185 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<IBackupContainer> bc;
															#line 2186 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	bool done;
															#line 2187 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	int64_t nrKeys;
															#line 2190 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	RangeResultWithVersion values;
															#line 2207 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Key nextKey;
															#line 2240 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	int blockSize;
															#line 2242 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Version snapshotBeginVersion;
															#line 2243 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	int64_t snapshotRangeFileCount;
															#line 2245 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 2272 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	size_t i;
															#line 17218 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via _execute()
															#line 2125 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class _executeActor final : public Actor<Void>, public ActorCallback< _executeActor, 0, Void >, public ActorCallback< _executeActor, 1, Standalone<VectorRef<KeyRef>> >, public ActorCallback< _executeActor, 2, DatabaseConfiguration >, public ActorCallback< _executeActor, 3, Reference<IBackupContainer> >, public ActorSingleCallback< _executeActor, 4, RangeResultWithVersion >, public ActorCallback< _executeActor, 5, Void >, public ActorCallback< _executeActor, 6, Void >, public ActorCallback< _executeActor, 7, Void >, public ActorCallback< _executeActor, 8, bool >, public ActorCallback< _executeActor, 9, Void >, public ActorCallback< _executeActor, 10, Void >, public ActorCallback< _executeActor, 11, Reference<IBackupFile> >, public ActorCallback< _executeActor, 12, Void >, public ActorCallback< _executeActor, 13, Void >, public FastAllocated<_executeActor>, public _executeActorState<_executeActor> {
															#line 17223 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<_executeActor>::operator new;
	using FastAllocated<_executeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5810801776138313728UL, 15117852636941300992UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _executeActor, 0, Void >;
friend struct ActorCallback< _executeActor, 1, Standalone<VectorRef<KeyRef>> >;
friend struct ActorCallback< _executeActor, 2, DatabaseConfiguration >;
friend struct ActorCallback< _executeActor, 3, Reference<IBackupContainer> >;
friend struct ActorSingleCallback< _executeActor, 4, RangeResultWithVersion >;
friend struct ActorCallback< _executeActor, 5, Void >;
friend struct ActorCallback< _executeActor, 6, Void >;
friend struct ActorCallback< _executeActor, 7, Void >;
friend struct ActorCallback< _executeActor, 8, bool >;
friend struct ActorCallback< _executeActor, 9, Void >;
friend struct ActorCallback< _executeActor, 10, Void >;
friend struct ActorCallback< _executeActor, 11, Reference<IBackupFile> >;
friend struct ActorCallback< _executeActor, 12, Void >;
friend struct ActorCallback< _executeActor, 13, Void >;
															#line 2125 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	_executeActor(Database const& cx,Reference<TaskBucket> const& taskBucket,Reference<FutureBucket> const& futureBucket,Reference<Task> const& task) 
															#line 17253 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   _executeActorState<_executeActor>(cx, taskBucket, futureBucket, task),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11570159100681900032UL, 1174875376554251520UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_execute");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _executeActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _executeActor, 1, Standalone<VectorRef<KeyRef>> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _executeActor, 2, DatabaseConfiguration >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< _executeActor, 3, Reference<IBackupContainer> >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorSingleCallback< _executeActor, 4, RangeResultWithVersion >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< _executeActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< _executeActor, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< _executeActor, 7, Void >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< _executeActor, 8, bool >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< _executeActor, 9, Void >*)0, actor_cancelled()); break;
		case 11: this->a_callback_error((ActorCallback< _executeActor, 10, Void >*)0, actor_cancelled()); break;
		case 12: this->a_callback_error((ActorCallback< _executeActor, 11, Reference<IBackupFile> >*)0, actor_cancelled()); break;
		case 13: this->a_callback_error((ActorCallback< _executeActor, 12, Void >*)0, actor_cancelled()); break;
		case 14: this->a_callback_error((ActorCallback< _executeActor, 13, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 2125 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] static Future<Void> _execute( Database const& cx, Reference<TaskBucket> const& taskBucket, Reference<FutureBucket> const& futureBucket, Reference<Task> const& task ) {
															#line 2125 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Void>(new _executeActor(cx, taskBucket, futureBucket, task));
															#line 17298 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 2281 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

																#line 17303 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via startBackupRangeInternal()
															#line 2282 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class StartBackupRangeInternalActor>
															#line 2282 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class StartBackupRangeInternalActorState {
															#line 17309 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 2282 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	StartBackupRangeInternalActorState(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,Reference<FutureBucket> const& futureBucket,Reference<Task> const& task,Reference<TaskFuture> const& onDone) 
															#line 2282 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 2282 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : tr(tr),
															#line 2282 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   taskBucket(taskBucket),
															#line 2282 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   futureBucket(futureBucket),
															#line 2282 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   task(task),
															#line 2282 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   onDone(onDone)
															#line 17324 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("startBackupRangeInternal", reinterpret_cast<unsigned long>(this));

	}
	~StartBackupRangeInternalActorState() 
	{
		fdb_probe_actor_destroy("startBackupRangeInternal", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2287 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 2288 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 2289 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			nextKey = Params.beginKey().get(task);
															#line 2290 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			endKey = Params.endKey().get(task);
															#line 2292 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Standalone<VectorRef<KeyRef>>> __when_expr_0 = getBlockOfShards(tr, nextKey, endKey, CLIENT_KNOBS->BACKUP_SHARD_TASK_LIMIT);
															#line 2292 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<StartBackupRangeInternalActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17349 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<StartBackupRangeInternalActor*>(this)->actor_wait_state = 1;
															#line 2292 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< StartBackupRangeInternalActor, 0, Standalone<VectorRef<KeyRef>> >*>(static_cast<StartBackupRangeInternalActor*>(this)));
															#line 17354 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~StartBackupRangeInternalActorState();
		static_cast<StartBackupRangeInternalActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2295 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		std::vector<Future<Key>> addTaskVector;
															#line 2296 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		for(int idx = 0;idx < keys.size();++idx) {
															#line 2297 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (nextKey != keys[idx])
															#line 17381 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			{
															#line 2298 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				addTaskVector.push_back(addTask(tr, taskBucket, task, task->getPriority(), nextKey, keys[idx], TaskCompletionKey::joinWith(onDone)));
															#line 2305 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				TraceEvent("FileBackupRangeSplit") .suppressFor(60) .detail("BackupUID", BackupConfig(task).getUid()) .detail("BeginKey", Params.beginKey().get(task).printable()) .detail("EndKey", Params.endKey().get(task).printable()) .detail("SliceBeginKey", nextKey.printable()) .detail("SliceEndKey", keys[idx].printable());
															#line 17387 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			}
															#line 2313 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			nextKey = keys[idx];
															#line 17391 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
															#line 2316 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = waitForAll(addTaskVector);
															#line 2316 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<StartBackupRangeInternalActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17397 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<StartBackupRangeInternalActor*>(this)->actor_wait_state = 2;
															#line 2316 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< StartBackupRangeInternalActor, 1, Void >*>(static_cast<StartBackupRangeInternalActor*>(this)));
															#line 17402 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Standalone<VectorRef<KeyRef>> const& __keys,int loopDepth) 
	{
															#line 2292 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		keys = __keys;
															#line 17411 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Standalone<VectorRef<KeyRef>> && __keys,int loopDepth) 
	{
		keys = std::move(__keys);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<StartBackupRangeInternalActor*>(this)->actor_wait_state > 0) static_cast<StartBackupRangeInternalActor*>(this)->actor_wait_state = 0;
		static_cast<StartBackupRangeInternalActor*>(this)->ActorCallback< StartBackupRangeInternalActor, 0, Standalone<VectorRef<KeyRef>> >::remove();

	}
	void a_callback_fire(ActorCallback< StartBackupRangeInternalActor, 0, Standalone<VectorRef<KeyRef>> >*,Standalone<VectorRef<KeyRef>> const& value) 
	{
		fdb_probe_actor_enter("startBackupRangeInternal", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartBackupRangeInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startBackupRangeInternal", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< StartBackupRangeInternalActor, 0, Standalone<VectorRef<KeyRef>> >*,Standalone<VectorRef<KeyRef>> && value) 
	{
		fdb_probe_actor_enter("startBackupRangeInternal", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartBackupRangeInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startBackupRangeInternal", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< StartBackupRangeInternalActor, 0, Standalone<VectorRef<KeyRef>> >*,Error err) 
	{
		fdb_probe_actor_enter("startBackupRangeInternal", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartBackupRangeInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startBackupRangeInternal", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 2318 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (nextKey != endKey)
															#line 17490 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 2320 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_2 = success(addTask(tr, taskBucket, task, task->getPriority(), nextKey, endKey, TaskCompletionKey::joinWith(onDone), Reference<TaskFuture>(), task->getPriority()));
															#line 2320 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<StartBackupRangeInternalActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17496 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<StartBackupRangeInternalActor*>(this)->actor_wait_state = 3;
															#line 2320 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< StartBackupRangeInternalActor, 2, Void >*>(static_cast<StartBackupRangeInternalActor*>(this)));
															#line 17501 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont5(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 2318 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (nextKey != endKey)
															#line 17515 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 2320 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_2 = success(addTask(tr, taskBucket, task, task->getPriority(), nextKey, endKey, TaskCompletionKey::joinWith(onDone), Reference<TaskFuture>(), task->getPriority()));
															#line 2320 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<StartBackupRangeInternalActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17521 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<StartBackupRangeInternalActor*>(this)->actor_wait_state = 3;
															#line 2320 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< StartBackupRangeInternalActor, 2, Void >*>(static_cast<StartBackupRangeInternalActor*>(this)));
															#line 17526 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont5(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<StartBackupRangeInternalActor*>(this)->actor_wait_state > 0) static_cast<StartBackupRangeInternalActor*>(this)->actor_wait_state = 0;
		static_cast<StartBackupRangeInternalActor*>(this)->ActorCallback< StartBackupRangeInternalActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StartBackupRangeInternalActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("startBackupRangeInternal", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartBackupRangeInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startBackupRangeInternal", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< StartBackupRangeInternalActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("startBackupRangeInternal", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartBackupRangeInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startBackupRangeInternal", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< StartBackupRangeInternalActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("startBackupRangeInternal", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartBackupRangeInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startBackupRangeInternal", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(int loopDepth) 
	{
															#line 2331 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<StartBackupRangeInternalActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~StartBackupRangeInternalActorState(); static_cast<StartBackupRangeInternalActor*>(this)->destroy(); return 0; }
															#line 17615 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<StartBackupRangeInternalActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~StartBackupRangeInternalActorState();
		static_cast<StartBackupRangeInternalActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<StartBackupRangeInternalActor*>(this)->actor_wait_state > 0) static_cast<StartBackupRangeInternalActor*>(this)->actor_wait_state = 0;
		static_cast<StartBackupRangeInternalActor*>(this)->ActorCallback< StartBackupRangeInternalActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StartBackupRangeInternalActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("startBackupRangeInternal", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartBackupRangeInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startBackupRangeInternal", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< StartBackupRangeInternalActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("startBackupRangeInternal", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartBackupRangeInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startBackupRangeInternal", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< StartBackupRangeInternalActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("startBackupRangeInternal", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartBackupRangeInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startBackupRangeInternal", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 2282 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 2282 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<TaskBucket> taskBucket;
															#line 2282 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<FutureBucket> futureBucket;
															#line 2282 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<Task> task;
															#line 2282 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<TaskFuture> onDone;
															#line 2289 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Key nextKey;
															#line 2290 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Key endKey;
															#line 2292 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Standalone<VectorRef<KeyRef>> keys;
															#line 17726 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via startBackupRangeInternal()
															#line 2282 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class StartBackupRangeInternalActor final : public Actor<Void>, public ActorCallback< StartBackupRangeInternalActor, 0, Standalone<VectorRef<KeyRef>> >, public ActorCallback< StartBackupRangeInternalActor, 1, Void >, public ActorCallback< StartBackupRangeInternalActor, 2, Void >, public FastAllocated<StartBackupRangeInternalActor>, public StartBackupRangeInternalActorState<StartBackupRangeInternalActor> {
															#line 17731 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<StartBackupRangeInternalActor>::operator new;
	using FastAllocated<StartBackupRangeInternalActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11813432458248110592UL, 16244762102185875456UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< StartBackupRangeInternalActor, 0, Standalone<VectorRef<KeyRef>> >;
friend struct ActorCallback< StartBackupRangeInternalActor, 1, Void >;
friend struct ActorCallback< StartBackupRangeInternalActor, 2, Void >;
															#line 2282 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	StartBackupRangeInternalActor(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,Reference<FutureBucket> const& futureBucket,Reference<Task> const& task,Reference<TaskFuture> const& onDone) 
															#line 17750 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   StartBackupRangeInternalActorState<StartBackupRangeInternalActor>(tr, taskBucket, futureBucket, task, onDone),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("startBackupRangeInternal", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14943095139744488960UL, 2433527876298934528UL);
		ActorExecutionContextHelper __helper(static_cast<StartBackupRangeInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("startBackupRangeInternal");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("startBackupRangeInternal", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< StartBackupRangeInternalActor, 0, Standalone<VectorRef<KeyRef>> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< StartBackupRangeInternalActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< StartBackupRangeInternalActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 2282 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] static Future<Void> startBackupRangeInternal( Reference<ReadYourWritesTransaction> const& tr, Reference<TaskBucket> const& taskBucket, Reference<FutureBucket> const& futureBucket, Reference<Task> const& task, Reference<TaskFuture> const& onDone ) {
															#line 2282 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Void>(new StartBackupRangeInternalActor(tr, taskBucket, futureBucket, task, onDone));
															#line 17784 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 2333 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

																#line 17789 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via _finish()
															#line 2334 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class _finishActor2>
															#line 2334 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class _finishActor2State {
															#line 17795 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 2334 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	_finishActor2State(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,Reference<FutureBucket> const& futureBucket,Reference<Task> const& task) 
															#line 2334 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 2334 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : tr(tr),
															#line 2334 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   taskBucket(taskBucket),
															#line 2334 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   futureBucket(futureBucket),
															#line 2334 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   task(task),
															#line 2338 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   taskFuture(futureBucket->unpack(task->params[Task::reservedTaskParamKeyDone]))
															#line 17810 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("_finish", reinterpret_cast<unsigned long>(this));

	}
	~_finishActor2State() 
	{
		fdb_probe_actor_destroy("_finish", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2339 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (Params.addBackupRangeTasks().get(task))
															#line 17825 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			{
															#line 2340 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				StrictFuture<Void> __when_expr_0 = startBackupRangeInternal(tr, taskBucket, futureBucket, task, taskFuture);
															#line 2340 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				if (static_cast<_finishActor2*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17831 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<_finishActor2*>(this)->actor_wait_state = 1;
															#line 2340 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _finishActor2, 0, Void >*>(static_cast<_finishActor2*>(this)));
															#line 17836 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
															#line 2342 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				StrictFuture<Void> __when_expr_1 = taskFuture->set(tr, taskBucket);
															#line 2342 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				if (static_cast<_finishActor2*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17845 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
				static_cast<_finishActor2*>(this)->actor_wait_state = 2;
															#line 2342 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _finishActor2, 1, Void >*>(static_cast<_finishActor2*>(this)));
															#line 17850 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_finishActor2State();
		static_cast<_finishActor2*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2345 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_2 = taskBucket->finish(tr, task);
															#line 2345 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<_finishActor2*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17876 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<_finishActor2*>(this)->actor_wait_state = 3;
															#line 2345 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _finishActor2, 2, Void >*>(static_cast<_finishActor2*>(this)));
															#line 17881 "/codebuild/output/src2298219144/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_finishActor2*>(this)->actor_wait_state > 0) static_cast<_finishActor2*>(this)->actor_wait_state = 0;
		static_cast<_finishActor2*>(this)->ActorCallback< _finishActor2, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _finishActor2, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor2*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _finishActor2, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor2*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _finishActor2, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219