/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.tuple;

import com.apple.foundationdb.tuple.FastByteComparisons;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

class ArrayUtilSortTest {
    private static final int SAMPLE_COUNT = 100000;
    private static final int SAMPLE_MAX_SIZE = 2048;
    private static List<byte[]> unsafe;
    private static List<byte[]> java;

    ArrayUtilSortTest() {
    }

    @BeforeAll
    static void initTestClass() {
        unsafe = new ArrayList<byte[]>(100000);
        java = new ArrayList<byte[]>(100000);
        Random random = new Random();
        for (int i = 0; i <= 100000; ++i) {
            byte[] byArray = new byte[random.nextInt(2048)];
            random.nextBytes(byArray);
            unsafe.add(byArray);
            java.add(byArray);
        }
    }

    @Test
    void testUnsafeSortSorts() throws Exception {
        Collections.sort(unsafe, FastByteComparisons.lexicographicalComparerUnsafeImpl());
        Collections.sort(java, FastByteComparisons.lexicographicalComparerJavaImpl());
        Assertions.assertEquals((int)java.size(), (int)unsafe.size(), (String)"unsafe and java comparators disagree");
        for (int i = 0; i < java.size(); ++i) {
            Assertions.assertArrayEquals((byte[])java.get(i), (byte[])unsafe.get(i), (String)("[pos ]" + i + ": comparators disagree"));
        }
    }

    @Test
    void testUnsafeComparison() {
        for (int i = 0; i < unsafe.size(); ++i) {
            Assertions.assertEquals((int)0, (int)FastByteComparisons.lexicographicalComparerUnsafeImpl().compare((Object)unsafe.get(i), (Object)java.get(i)));
        }
    }

    @Test
    void testJavaComparison() {
        for (int i = 0; i < unsafe.size(); ++i) {
            Assertions.assertEquals((int)0, (int)FastByteComparisons.lexicographicalComparerJavaImpl().compare((Object)unsafe.get(i), (Object)java.get(i)));
        }
    }

    @Test
    void testUnsafeComparisonWithOffset() {
        for (int i = 0; i < unsafe.size(); ++i) {
            if (unsafe.get(i).length <= 5) continue;
            Assertions.assertEquals((int)0, (int)FastByteComparisons.lexicographicalComparerUnsafeImpl().compareTo((Object)unsafe.get(i), 4, unsafe.get(i).length - 4, (Object)java.get(i), 4, java.get(i).length - 4));
        }
    }

    @Test
    void testJavaComparisonWithOffset() {
        for (int i = 0; i < unsafe.size(); ++i) {
            if (unsafe.get(i).length <= 5) continue;
            Assertions.assertEquals((int)0, (int)FastByteComparisons.lexicographicalComparerJavaImpl().compareTo((Object)unsafe.get(i), 4, unsafe.get(i).length - 4, (Object)java.get(i), 4, java.get(i).length - 4));
        }
    }
}

