/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.test;

import com.apple.foundationdb.Range;
import com.apple.foundationdb.ReadTransactionContext;
import com.apple.foundationdb.async.AsyncUtil;
import com.apple.foundationdb.directory.Directory;
import com.apple.foundationdb.directory.DirectoryLayer;
import com.apple.foundationdb.subspace.Subspace;
import com.apple.foundationdb.test.DirectoryOperation;
import com.apple.foundationdb.test.DirectoryUtil;
import com.apple.foundationdb.test.Instruction;
import com.apple.foundationdb.test.StackUtils;
import com.apple.foundationdb.tuple.Tuple;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;

class AsyncDirectoryExtension {
    List<Object> dirList = new ArrayList<Object>();
    int dirIndex = 0;
    int errorIndex = 0;

    AsyncDirectoryExtension() {
        this.dirList.add(DirectoryLayer.getDefault());
    }

    Directory directory() {
        return (Directory)this.dirList.get(this.dirIndex);
    }

    Subspace subspace() {
        return (Subspace)this.dirList.get(this.dirIndex);
    }

    CompletableFuture<Void> processInstruction(Instruction instruction) {
        return this.executeInstruction(instruction).exceptionally(throwable -> {
            DirectoryUtil.pushError(instruction, throwable, this.dirList);
            return null;
        });
    }

    CompletableFuture<Void> executeInstruction(Instruction instruction) {
        DirectoryOperation directoryOperation = DirectoryOperation.valueOf(instruction.op);
        if (directoryOperation == DirectoryOperation.DIRECTORY_CREATE_SUBSPACE) {
            return DirectoryUtil.popTuple(instruction).thenComposeAsync(tuple -> instruction.popParam().thenAccept(object -> this.dirList.add(new Subspace(tuple, (byte[])object))));
        }
        if (directoryOperation == DirectoryOperation.DIRECTORY_CREATE_LAYER) {
            return instruction.popParams(3).thenAcceptAsync(list -> {
                boolean bl;
                Subspace subspace = (Subspace)this.dirList.get(StackUtils.getInt(list.get(0)));
                Subspace subspace2 = (Subspace)this.dirList.get(StackUtils.getInt(list.get(1)));
                boolean bl2 = bl = StackUtils.getInt(list.get(2)) == 1;
                if (subspace == null || subspace2 == null) {
                    this.dirList.add(null);
                } else {
                    this.dirList.add(new DirectoryLayer(subspace, subspace2, bl));
                }
            });
        }
        if (directoryOperation == DirectoryOperation.DIRECTORY_CHANGE) {
            return instruction.popParam().thenAcceptAsync(object -> {
                this.dirIndex = StackUtils.getInt(object);
                if (this.dirList.get(this.dirIndex) == null) {
                    this.dirIndex = this.errorIndex;
                }
            });
        }
        if (directoryOperation == DirectoryOperation.DIRECTORY_SET_ERROR_INDEX) {
            return instruction.popParam().thenAcceptAsync(object -> {
                this.errorIndex = StackUtils.getInt(object);
            });
        }
        if (directoryOperation == DirectoryOperation.DIRECTORY_CREATE_OR_OPEN || directoryOperation == DirectoryOperation.DIRECTORY_OPEN) {
            return DirectoryUtil.popPath(instruction).thenComposeAsync(list -> instruction.popParam().thenComposeAsync(object -> {
                CompletableFuture completableFuture = object == null ? (directoryOperation == DirectoryOperation.DIRECTORY_CREATE_OR_OPEN ? this.directory().createOrOpen(instruction.tcx, list) : this.directory().open(instruction.readTcx, list)) : (directoryOperation == DirectoryOperation.DIRECTORY_CREATE_OR_OPEN ? this.directory().createOrOpen(instruction.tcx, list, (byte[])object) : this.directory().open(instruction.readTcx, list, (byte[])object));
                return completableFuture.thenAccept(this.dirList::add);
            }));
        }
        if (directoryOperation == DirectoryOperation.DIRECTORY_CREATE) {
            return DirectoryUtil.popPath(instruction).thenComposeAsync(list -> instruction.popParams(2).thenComposeAsync(list2 -> {
                CompletableFuture completableFuture;
                byte[] byArray = (byte[])list2.get(0);
                byte[] byArray2 = (byte[])list2.get(1);
                if (byArray == null && byArray2 == null) {
                    completableFuture = this.directory().create(instruction.tcx, list);
                } else if (byArray2 == null) {
                    completableFuture = this.directory().create(instruction.tcx, list, byArray);
                } else {
                    if (byArray == null) {
                        byArray = new byte[]{};
                    }
                    completableFuture = this.directory().create(instruction.tcx, list, byArray, byArray2);
                }
                return completableFuture.thenAccept(this.dirList::add);
            }));
        }
        if (directoryOperation == DirectoryOperation.DIRECTORY_MOVE) {
            return ((CompletableFuture)DirectoryUtil.popPaths(instruction, 2).thenComposeAsync(list -> this.directory().move(instruction.tcx, (List)list.get(0), (List)list.get(1)))).thenAccept(this.dirList::add);
        }
        if (directoryOperation == DirectoryOperation.DIRECTORY_MOVE_TO) {
            return ((CompletableFuture)DirectoryUtil.popPath(instruction).thenComposeAsync(list -> this.directory().moveTo(instruction.tcx, list))).thenAccept(this.dirList::add);
        }
        if (directoryOperation == DirectoryOperation.DIRECTORY_REMOVE) {
            return ((CompletableFuture)instruction.popParam().thenComposeAsync(object -> DirectoryUtil.popPaths(instruction, StackUtils.getInt(object)))).thenComposeAsync(list -> {
                if (list.size() == 0) {
                    return this.directory().remove(instruction.tcx);
                }
                return this.directory().remove(instruction.tcx, (List)list.get(0));
            });
        }
        if (directoryOperation == DirectoryOperation.DIRECTORY_REMOVE_IF_EXISTS) {
            return ((CompletableFuture)instruction.popParam().thenComposeAsync(object -> DirectoryUtil.popPaths(instruction, StackUtils.getInt(object)))).thenComposeAsync(list -> {
                if (list.size() == 0) {
                    return AsyncUtil.success((CompletableFuture)this.directory().removeIfExists(instruction.tcx));
                }
                return AsyncUtil.success((CompletableFuture)this.directory().removeIfExists(instruction.tcx, (List)list.get(0)));
            });
        }
        if (directoryOperation == DirectoryOperation.DIRECTORY_LIST) {
            return ((CompletableFuture)((CompletableFuture)instruction.popParam().thenComposeAsync(object -> DirectoryUtil.popPaths(instruction, StackUtils.getInt(object)))).thenComposeAsync(list -> {
                if (list.size() == 0) {
                    return this.directory().list(instruction.readTcx);
                }
                return this.directory().list(instruction.readTcx, (List)list.get(0));
            })).thenAccept(list -> instruction.push(Tuple.fromItems((Iterable)list).pack()));
        }
        if (directoryOperation == DirectoryOperation.DIRECTORY_EXISTS) {
            return ((CompletableFuture)((CompletableFuture)((CompletableFuture)instruction.readTcx.readAsync(readTransaction -> readTransaction.getReadVersion()).thenComposeAsync(l -> instruction.popParam())).thenComposeAsync(object -> DirectoryUtil.popPaths(instruction, StackUtils.getInt(object)))).thenComposeAsync(list -> {
                if (list.size() == 0) {
                    return this.directory().exists(instruction.readTcx);
                }
                return this.directory().exists(instruction.readTcx, (List)list.get(0));
            })).thenAccept(bl -> instruction.push(bl != false ? 1 : 0));
        }
        if (directoryOperation == DirectoryOperation.DIRECTORY_PACK_KEY) {
            return DirectoryUtil.popTuple(instruction).thenAccept(tuple -> instruction.push(this.subspace().pack(tuple)));
        }
        if (directoryOperation == DirectoryOperation.DIRECTORY_UNPACK_KEY) {
            return instruction.popParam().thenAcceptAsync(object -> {
                Tuple tuple = this.subspace().unpack((byte[])object);
                for (Object e : tuple) {
                    instruction.push(e);
                }
            });
        }
        if (directoryOperation == DirectoryOperation.DIRECTORY_RANGE) {
            return DirectoryUtil.popTuple(instruction).thenAcceptAsync(tuple -> {
                Range range = this.subspace().range(tuple);
                instruction.push(range.begin);
                instruction.push(range.end);
            });
        }
        if (directoryOperation == DirectoryOperation.DIRECTORY_CONTAINS) {
            return instruction.popParam().thenAccept(object -> instruction.push(this.subspace().contains((byte[])object) ? 1 : 0));
        }
        if (directoryOperation == DirectoryOperation.DIRECTORY_OPEN_SUBSPACE) {
            return DirectoryUtil.popTuple(instruction).thenAcceptAsync(tuple -> this.dirList.add(this.subspace().subspace(tuple)));
        }
        if (directoryOperation == DirectoryOperation.DIRECTORY_LOG_SUBSPACE) {
            return instruction.popParam().thenComposeAsync(object -> instruction.tcx.runAsync(transaction -> {
                transaction.set(Tuple.from((Object[])new Object[]{this.dirIndex}).pack((byte[])object), this.subspace().getKey());
                return AsyncUtil.DONE;
            }));
        }
        if (directoryOperation == DirectoryOperation.DIRECTORY_LOG_DIRECTORY) {
            return instruction.popParam().thenComposeAsync(object -> {
                Subspace subspace = new Subspace(new Tuple().add((long)this.dirIndex), (byte[])object);
                return instruction.tcx.runAsync(transaction -> ((CompletableFuture)this.directory().exists((ReadTransactionContext)transaction).thenComposeAsync(bl -> {
                    transaction.set(subspace.pack((Object)"path"), Tuple.fromItems((Iterable)this.directory().getPath()).pack());
                    transaction.set(subspace.pack((Object)"layer"), new Tuple().add(this.directory().getLayer()).pack());
                    transaction.set(subspace.pack((Object)"exists"), new Tuple().add(bl != false ? 1L : 0L).pack());
                    if (bl.booleanValue()) {
                        return this.directory().list((ReadTransactionContext)transaction);
                    }
                    return CompletableFuture.completedFuture(Collections.emptyList());
                })).thenAcceptAsync(list -> transaction.set(subspace.pack((Object)"children"), Tuple.fromItems((Iterable)list).pack())));
            });
        }
        if (directoryOperation == DirectoryOperation.DIRECTORY_STRIP_PREFIX) {
            return instruction.popParam().thenAcceptAsync(object -> {
                byte[] byArray = (byte[])object;
                byte[] byArray2 = this.subspace().getKey();
                if (byArray.length < byArray2.length) {
                    throw new RuntimeException("String does not start with raw prefix");
                }
                for (int i = 0; i < byArray2.length; ++i) {
                    if (byArray[i] == byArray2[i]) continue;
                    throw new RuntimeException("String does not start with raw prefix");
                }
                instruction.push(Arrays.copyOfRange(byArray, byArray2.length, byArray.length));
            });
        }
        throw new RuntimeException("Unknown operation:" + instruction.op);
    }
}

