#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
/*
 * TenantCapacityLimits.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <cstdint>
#include <limits>
#include "fdbclient/ClusterConnectionMemoryRecord.h"
#include "fdbclient/FDBOptions.g.h"
#include "fdbclient/GenericManagementAPI.actor.h"
#include "fdbclient/MultiVersionTransaction.h"
#include "fdbclient/ReadYourWrites.h"
#include "fdbclient/RunRYWTransaction.actor.h"
#include "fdbclient/Tenant.h"
#include "fdbclient/TenantManagement.actor.h"
#include "fdbclient/TenantSpecialKeys.actor.h"
#include "fdbclient/ThreadSafeTransaction.h"
#include "fdbrpc/simulator.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "fdbserver/Knobs.h"
#include "flow/BooleanParam.h"
#include "flow/Error.h"
#include "flow/IRandom.h"
#include "flow/ThreadHelper.actor.h"
#include "flow/Trace.h"
#include "flow/flow.h"

#include "metacluster/Metacluster.h"
#include "metacluster/MetaclusterConsistency.actor.h"

#include "flow/actorcompiler.h" // This must be the last #include.

struct TenantCapacityLimits : TestWorkload {
	static constexpr auto NAME = "TenantCapacityLimits";

	Reference<IDatabase> managementDb;
	Database dataDb;

	int64_t tenantIdPrefix;
	bool useMetacluster = false;
	const Key specialKeysTenantMapPrefix = SpecialKeySpace::getModuleRange(SpecialKeySpace::MODULE::MANAGEMENT)
	                                           .begin.withSuffix(TenantRangeImpl::submoduleRange.begin)
	                                           .withSuffix(TenantRangeImpl::mapSubRange.begin);

	TenantCapacityLimits(WorkloadContext const& wcx) : TestWorkload(wcx) {
		tenantIdPrefix = getOption(options,
		                           "tenantIdPrefix"_sr,
		                           deterministicRandom()->randomInt(TenantAPI::TENANT_ID_PREFIX_MIN_VALUE,
		                                                            TenantAPI::TENANT_ID_PREFIX_MAX_VALUE + 1));
		if (clientId == 0) {
			useMetacluster = deterministicRandom()->coinflip();
		}
	}

	Future<Void> setup(Database const& cx) override {
		if (clientId == 0) {
			return _setup(cx, this);
		} else {
			return Void();
		}
	}
																#line 79 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantCapacityLimits.actor.g.cpp"
// This generated class is to be used only via _setup()
															#line 77 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
template <class _setupActor>
															#line 77 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
class _setupActorState {
															#line 85 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantCapacityLimits.actor.g.cpp"
public:
															#line 77 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
	_setupActorState(Database const& cx,TenantCapacityLimits* const& self) 
															#line 77 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
															#line 77 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
		 : cx(cx),
															#line 77 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
		   self(self)
															#line 94 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantCapacityLimits.actor.g.cpp"
	{
		fdb_probe_actor_create("_setup", reinterpret_cast<unsigned long>(this));

	}
	~_setupActorState() 
	{
		fdb_probe_actor_destroy("_setup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 78 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
			if (self->useMetacluster)
															#line 109 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantCapacityLimits.actor.g.cpp"
			{
															#line 79 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
				metacluster::DataClusterEntry entry;
															#line 80 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
				entry.capacity.numTenantGroups = 1e9;
															#line 82 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
				StrictFuture<metacluster::util::SimulatedMetacluster> __when_expr_0 = metacluster::util::createSimulatedMetacluster(cx, self->tenantIdPrefix, entry);
															#line 82 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
				if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 119 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantCapacityLimits.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<_setupActor*>(this)->actor_wait_state = 1;
															#line 82 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 0, metacluster::util::SimulatedMetacluster >*>(static_cast<_setupActor*>(this)));
															#line 124 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantCapacityLimits.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 89 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
				self->dataDb = cx;
															#line 131 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantCapacityLimits.actor.g.cpp"
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 92 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
		if (!static_cast<_setupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_setupActorState(); static_cast<_setupActor*>(this)->destroy(); return 0; }
															#line 155 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantCapacityLimits.actor.g.cpp"
		new (&static_cast<_setupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(metacluster::util::SimulatedMetacluster const& simMetacluster,int loopDepth) 
	{
															#line 85 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
		self->managementDb = simMetacluster.managementDb;
															#line 86 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
		ASSERT_EQ(simMetacluster.dataDbs.size(), 1);
															#line 87 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
		self->dataDb = simMetacluster.dataDbs.begin()->second;
															#line 171 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantCapacityLimits.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(metacluster::util::SimulatedMetacluster && simMetacluster,int loopDepth) 
	{
															#line 85 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
		self->managementDb = simMetacluster.managementDb;
															#line 86 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
		ASSERT_EQ(simMetacluster.dataDbs.size(), 1);
															#line 87 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
		self->dataDb = simMetacluster.dataDbs.begin()->second;
															#line 184 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantCapacityLimits.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(metacluster::util::SimulatedMetacluster const& simMetacluster,int loopDepth) 
	{
		loopDepth = a_body1cont2(simMetacluster, loopDepth);

		return loopDepth;
	}
	int a_body1when1(metacluster::util::SimulatedMetacluster && simMetacluster,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(simMetacluster), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_setupActor*>(this)->actor_wait_state > 0) static_cast<_setupActor*>(this)->actor_wait_state = 0;
		static_cast<_setupActor*>(this)->ActorCallback< _setupActor, 0, metacluster::util::SimulatedMetacluster >::remove();

	}
	void a_callback_fire(ActorCallback< _setupActor, 0, metacluster::util::SimulatedMetacluster >*,metacluster::util::SimulatedMetacluster const& value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _setupActor, 0, metacluster::util::SimulatedMetacluster >*,metacluster::util::SimulatedMetacluster && value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _setupActor, 0, metacluster::util::SimulatedMetacluster >*,Error err) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 77 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
	Database cx;
															#line 77 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
	TenantCapacityLimits* self;
															#line 268 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantCapacityLimits.actor.g.cpp"
};
// This generated class is to be used only via _setup()
															#line 77 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
class _setupActor final : public Actor<Void>, public ActorCallback< _setupActor, 0, metacluster::util::SimulatedMetacluster >, public FastAllocated<_setupActor>, public _setupActorState<_setupActor> {
															#line 273 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantCapacityLimits.actor.g.cpp"
public:
	using FastAllocated<_setupActor>::operator new;
	using FastAllocated<_setupActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8183712119401766912UL, 11386739628635933696UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _setupActor, 0, metacluster::util::SimulatedMetacluster >;
															#line 77 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
	_setupActor(Database const& cx,TenantCapacityLimits* const& self) 
															#line 290 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantCapacityLimits.actor.g.cpp"
		 : Actor<Void>(),
		   _setupActorState<_setupActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3044502327521131520UL, 13387266639422932480UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_setup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _setupActor, 0, metacluster::util::SimulatedMetacluster >*)0, actor_cancelled()); break;
		}

	}
};
															#line 77 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
[[nodiscard]] static Future<Void> _setup( Database const& cx, TenantCapacityLimits* const& self ) {
															#line 77 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
	return Future<Void>(new _setupActor(cx, self));
															#line 322 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantCapacityLimits.actor.g.cpp"
}

#line 94 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"

	Future<Void> start(Database const& cx) override {
		if (clientId == 0) {
			return _start(cx, this);
		} else {
			return Void();
		}
	}

																#line 335 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantCapacityLimits.actor.g.cpp"
// This generated class is to be used only via setLastTenantId()
															#line 103 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
template <class SetLastTenantIdActor>
															#line 103 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
class SetLastTenantIdActorState {
															#line 341 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantCapacityLimits.actor.g.cpp"
public:
															#line 103 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
	SetLastTenantIdActorState(Database const& dataDb,int64_t const& tenantId) 
															#line 103 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
															#line 103 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
		 : dataDb(dataDb),
															#line 103 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
		   tenantId(tenantId),
															#line 105 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
		   dataTr(makeReference<ReadYourWritesTransaction>(dataDb))
															#line 352 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantCapacityLimits.actor.g.cpp"
	{
		fdb_probe_actor_create("setLastTenantId", reinterpret_cast<unsigned long>(this));

	}
	~SetLastTenantIdActorState() 
	{
		fdb_probe_actor_destroy("setLastTenantId", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 106 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
			;
															#line 367 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantCapacityLimits.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SetLastTenantIdActorState();
		static_cast<SetLastTenantIdActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 116 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
		if (!static_cast<SetLastTenantIdActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SetLastTenantIdActorState(); static_cast<SetLastTenantIdActor*>(this)->destroy(); return 0; }
															#line 390 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantCapacityLimits.actor.g.cpp"
		new (&static_cast<SetLastTenantIdActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SetLastTenantIdActorState();
		static_cast<SetLastTenantIdActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 108 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
			dataTr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 109 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
			TenantMetadata::lastTenantId().set(dataTr, tenantId);
															#line 110 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
			StrictFuture<Void> __when_expr_0 = dataTr->commit();
															#line 110 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
			if (static_cast<SetLastTenantIdActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 416 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantCapacityLimits.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<SetLastTenantIdActor*>(this)->actor_wait_state = 1;
															#line 110 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SetLastTenantIdActor, 0, Void >*>(static_cast<SetLastTenantIdActor*>(this)));
															#line 421 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantCapacityLimits.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 113 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
			StrictFuture<Void> __when_expr_1 = dataTr->onError(e);
															#line 113 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
			if (static_cast<SetLastTenantIdActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 458 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantCapacityLimits.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<SetLastTenantIdActor*>(this)->actor_wait_state = 2;
															#line 113 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SetLastTenantIdActor, 1, Void >*>(static_cast<SetLastTenantIdActor*>(this)));
															#line 463 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantCapacityLimits.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SetLastTenantIdActor*>(this)->actor_wait_state > 0) static_cast<SetLastTenantIdActor*>(this)->actor_wait_state = 0;
		static_cast<SetLastTenantIdActor*>(this)->ActorCallback< SetLastTenantIdActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SetLastTenantIdActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("setLastTenantId", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetLastTenantIdActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setLastTenantId", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SetLastTenantIdActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("setLastTenantId", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetLastTenantIdActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setLastTenantId", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SetLastTenantIdActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("setLastTenantId", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SetLastTenantIdActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setLastTenantId", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<SetLastTenantIdActor*>(this)->actor_wait_state > 0) static_cast<SetLastTenantIdActor*>(this)->actor_wait_state = 0;
		static_cast<SetLastTenantIdActor*>(this)->ActorCallback< SetLastTenantIdActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SetLastTenantIdActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("setLastTenantId", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetLastTenantIdActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setLastTenantId", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< SetLastTenantIdActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("setLastTenantId", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetLastTenantIdActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setLastTenantId", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< SetLastTenantIdActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("setLastTenantId", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SetLastTenantIdActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setLastTenantId", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 103 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
	Database dataDb;
															#line 103 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
	int64_t tenantId;
															#line 105 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
	Reference<ReadYourWritesTransaction> dataTr;
															#line 654 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantCapacityLimits.actor.g.cpp"
};
// This generated class is to be used only via setLastTenantId()
															#line 103 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
class SetLastTenantIdActor final : public Actor<Void>, public ActorCallback< SetLastTenantIdActor, 0, Void >, public ActorCallback< SetLastTenantIdActor, 1, Void >, public FastAllocated<SetLastTenantIdActor>, public SetLastTenantIdActorState<SetLastTenantIdActor> {
															#line 659 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantCapacityLimits.actor.g.cpp"
public:
	using FastAllocated<SetLastTenantIdActor>::operator new;
	using FastAllocated<SetLastTenantIdActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9259158278484131072UL, 469571640701646080UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SetLastTenantIdActor, 0, Void >;
friend struct ActorCallback< SetLastTenantIdActor, 1, Void >;
															#line 103 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
	SetLastTenantIdActor(Database const& dataDb,int64_t const& tenantId) 
															#line 677 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantCapacityLimits.actor.g.cpp"
		 : Actor<Void>(),
		   SetLastTenantIdActorState<SetLastTenantIdActor>(dataDb, tenantId),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("setLastTenantId", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3953930831650758912UL, 14389724972230472448UL);
		ActorExecutionContextHelper __helper(static_cast<SetLastTenantIdActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("setLastTenantId");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("setLastTenantId", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SetLastTenantIdActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< SetLastTenantIdActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 103 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
[[nodiscard]] static Future<Void> setLastTenantId( Database const& dataDb, int64_t const& tenantId ) {
															#line 103 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
	return Future<Void>(new SetLastTenantIdActor(dataDb, tenantId));
															#line 710 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantCapacityLimits.actor.g.cpp"
}

#line 118 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"

																#line 715 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantCapacityLimits.actor.g.cpp"
// This generated class is to be used only via _start()
															#line 119 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
template <class _startActor>
															#line 119 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
class _startActorState {
															#line 721 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantCapacityLimits.actor.g.cpp"
public:
															#line 119 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
	_startActorState(Database const& cx,TenantCapacityLimits* const& self) 
															#line 119 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
															#line 119 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
		 : cx(cx),
															#line 119 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
		   self(self)
															#line 730 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantCapacityLimits.actor.g.cpp"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 120 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
			if (self->useMetacluster)
															#line 745 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantCapacityLimits.actor.g.cpp"
			{
															#line 122 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
				tr = self->managementDb->createTransaction();
															#line 123 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
				;
															#line 751 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantCapacityLimits.actor.g.cpp"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			else
			{
															#line 148 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
				StrictFuture<Void> __when_expr_3 = setLastTenantId(self->dataDb, TenantAPI::getMaxAllowableTenantId(0));
															#line 148 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
				if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 760 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantCapacityLimits.actor.g.cpp"
				if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1when1(__when_expr_3.get(), loopDepth); };
				static_cast<_startActor*>(this)->actor_wait_state = 4;
															#line 148 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
				__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _startActor, 3, Void >*>(static_cast<_startActor*>(this)));
															#line 765 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantCapacityLimits.actor.g.cpp"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 179 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 789 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantCapacityLimits.actor.g.cpp"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
		try {
															#line 136 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
			metacluster::MetaclusterTenantMapEntry entry;
															#line 137 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
			entry.tenantName = "test_tenant_metacluster"_sr;
															#line 138 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
			StrictFuture<Void> __when_expr_2 = metacluster::createTenant(self->managementDb, entry, metacluster::AssignClusterAutomatically::True, metacluster::IgnoreCapacityLimit::False);
															#line 138 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), loopDepth);
															#line 808 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantCapacityLimits.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont2Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 138 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, Void >*>(static_cast<_startActor*>(this)));
															#line 813 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantCapacityLimits.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont2Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 125 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 126 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
			int64_t maxTenantId = TenantAPI::getMaxAllowableTenantId(self->tenantIdPrefix << 48);
															#line 127 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
			metacluster::metadata::management::tenantMetadata().lastTenantId.set(tr, maxTenantId);
															#line 128 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
			StrictFuture<Void> __when_expr_0 = safeThreadFutureToFuture(tr->commit());
															#line 128 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 844 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantCapacityLimits.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 128 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, Void >*>(static_cast<_startActor*>(this)));
															#line 849 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantCapacityLimits.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 131 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
			StrictFuture<Void> __when_expr_1 = safeThreadFutureToFuture(tr->onError(e));
															#line 131 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 886 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantCapacityLimits.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 131 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 891 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantCapacityLimits.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _startActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 144 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
			ASSERT(e.code() == error_code_cluster_no_capacity);
															#line 1087 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantCapacityLimits.actor.g.cpp"
			loopDepth = a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 142 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
		ASSERT(false);
															#line 1102 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantCapacityLimits.actor.g.cpp"
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 142 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
		ASSERT(false);
															#line 1111 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantCapacityLimits.actor.g.cpp"
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _startActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont6(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont7(Void const& _,int loopDepth) 
	{
		try {
															#line 151 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
			StrictFuture<Void> __when_expr_4 = success(TenantAPI::createTenant(self->dataDb.getReference(), "test_tenant_management_api"_sr));
															#line 151 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont7Catch1(actor_cancelled(), loopDepth);
															#line 1211 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantCapacityLimits.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont7Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont7when1(__when_expr_4.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 5;
															#line 151 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _startActor, 4, Void >*>(static_cast<_startActor*>(this)));
															#line 1216 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantCapacityLimits.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont7Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont7Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont7(Void && _,int loopDepth) 
	{
		try {
															#line 151 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
			StrictFuture<Void> __when_expr_4 = success(TenantAPI::createTenant(self->dataDb.getReference(), "test_tenant_management_api"_sr));
															#line 151 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont7Catch1(actor_cancelled(), loopDepth);
															#line 1234 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantCapacityLimits.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont7Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont7when1(__when_expr_4.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 5;
															#line 151 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _startActor, 4, Void >*>(static_cast<_startActor*>(this)));
															#line 1239 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantCapacityLimits.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont7Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont7Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< _startActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont8(int loopDepth) 
	{
															#line 157 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
		StrictFuture<Void> __when_expr_5 = setLastTenantId(self->dataDb, TenantAPI::getMaxAllowableTenantId(0) - 2);
															#line 157 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1331 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantCapacityLimits.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont8when1(__when_expr_5.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 6;
															#line 157 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< _startActor, 5, Void >*>(static_cast<_startActor*>(this)));
															#line 1336 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantCapacityLimits.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 154 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
			ASSERT(e.code() == error_code_cluster_no_capacity);
															#line 1346 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantCapacityLimits.actor.g.cpp"
			loopDepth = a_body1cont8(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont9(Void const& _,int loopDepth) 
	{
															#line 152 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
		ASSERT(false);
															#line 1361 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantCapacityLimits.actor.g.cpp"
		loopDepth = a_body1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1cont9(Void && _,int loopDepth) 
	{
															#line 152 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
		ASSERT(false);
															#line 1370 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantCapacityLimits.actor.g.cpp"
		loopDepth = a_body1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1cont7when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont7when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont7Catch1(error, 0);
		} catch (...) {
			a_body1cont7Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< _startActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont7Catch1(error, 0);
		} catch (...) {
			a_body1cont7Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< _startActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont7Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont7Catch1(error, 0);
		} catch (...) {
			a_body1cont7Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont11(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont8(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12(Void const& _,int loopDepth) 
	{
															#line 159 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
		dataTr = makeReference<ReadYourWritesTransaction>(self->dataDb);
															#line 160 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
		;
															#line 1469 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantCapacityLimits.actor.g.cpp"
		loopDepth = a_body1cont12loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12(Void && _,int loopDepth) 
	{
															#line 159 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
		dataTr = makeReference<ReadYourWritesTransaction>(self->dataDb);
															#line 160 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
		;
															#line 1480 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantCapacityLimits.actor.g.cpp"
		loopDepth = a_body1cont12loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< _startActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< _startActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont12cont1(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont12loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1(int loopDepth) 
	{
		try {
															#line 162 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
			dataTr->reset();
															#line 163 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
			dataTr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 164 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
			dataTr->setOption(FDBTransactionOptions::SPECIAL_KEY_SPACE_ENABLE_WRITES);
															#line 165 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
			dataTr->set(self->specialKeysTenantMapPrefix.withSuffix("test_tenant_special_keys_1"_sr), ""_sr);
															#line 166 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
			dataTr->set(self->specialKeysTenantMapPrefix.withSuffix("test_tenant_special_keys_2"_sr), ""_sr);
															#line 167 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
			dataTr->set(self->specialKeysTenantMapPrefix.withSuffix("test_tenant_special_keys_3"_sr), ""_sr);
															#line 168 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
			StrictFuture<Void> __when_expr_6 = dataTr->commit();
															#line 168 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont12loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1592 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantCapacityLimits.actor.g.cpp"
			if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1cont12loopBody1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont12loopBody1when1(__when_expr_6.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 7;
															#line 168 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
			__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< _startActor, 6, Void >*>(static_cast<_startActor*>(this)));
															#line 1597 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantCapacityLimits.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont12loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont12loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12break1(int loopDepth) 
	{
		try {
			return a_body1cont12cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont12loopHead1(0);

		return loopDepth;
	}
	int a_body1cont12loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 171 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
			if (e.code() == error_code_cluster_no_capacity)
															#line 1632 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantCapacityLimits.actor.g.cpp"
			{
				return a_body1cont12break1(loopDepth==0?0:loopDepth-1); // break
			}
															#line 174 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
			StrictFuture<Void> __when_expr_7 = dataTr->onError(e);
															#line 174 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1640 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantCapacityLimits.actor.g.cpp"
			if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1Catch1when1(__when_expr_7.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 8;
															#line 174 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
			__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< _startActor, 7, Void >*>(static_cast<_startActor*>(this)));
															#line 1645 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantCapacityLimits.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont12loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 169 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
		ASSERT(false);
															#line 1660 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantCapacityLimits.actor.g.cpp"
		loopDepth = a_body1cont12loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 169 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
		ASSERT(false);
															#line 1669 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantCapacityLimits.actor.g.cpp"
		loopDepth = a_body1cont12loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont12loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont12loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont12loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< _startActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont12loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont12loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont12loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< _startActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont12loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont12loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont12loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont12loopBody1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont12loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont12loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont12loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< _startActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont12loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< _startActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 7);

	}
															#line 119 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
	Database cx;
															#line 119 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
	TenantCapacityLimits* self;
															#line 122 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
	Reference<ITransaction> tr;
															#line 159 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
	Reference<ReadYourWritesTransaction> dataTr;
															#line 1857 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantCapacityLimits.actor.g.cpp"
};
// This generated class is to be used only via _start()
															#line 119 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, Void >, public ActorCallback< _startActor, 1, Void >, public ActorCallback< _startActor, 2, Void >, public ActorCallback< _startActor, 3, Void >, public ActorCallback< _startActor, 4, Void >, public ActorCallback< _startActor, 5, Void >, public ActorCallback< _startActor, 6, Void >, public ActorCallback< _startActor, 7, Void >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 1862 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantCapacityLimits.actor.g.cpp"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15433050021386247168UL, 15346613410084414464UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, Void >;
friend struct ActorCallback< _startActor, 1, Void >;
friend struct ActorCallback< _startActor, 2, Void >;
friend struct ActorCallback< _startActor, 3, Void >;
friend struct ActorCallback< _startActor, 4, Void >;
friend struct ActorCallback< _startActor, 5, Void >;
friend struct ActorCallback< _startActor, 6, Void >;
friend struct ActorCallback< _startActor, 7, Void >;
															#line 119 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
	_startActor(Database const& cx,TenantCapacityLimits* const& self) 
															#line 1886 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantCapacityLimits.actor.g.cpp"
		 : Actor<Void>(),
		   _startActorState<_startActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _startActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _startActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< _startActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< _startActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< _startActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< _startActor, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< _startActor, 7, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 119 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
[[nodiscard]] static Future<Void> _start( Database const& cx, TenantCapacityLimits* const& self ) {
															#line 119 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"
	return Future<Void>(new _startActor(cx, self));
															#line 1925 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantCapacityLimits.actor.g.cpp"
}

#line 181 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/TenantCapacityLimits.actor.cpp"

	Future<bool> check(Database const& cx) override { return true; }
	void getMetrics(std::vector<PerfMetric>& m) override {}
};

WorkloadFactory<TenantCapacityLimits> TenantCapacityLimitsFactory;
