#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
/*
 * KillRegion.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/NativeAPI.actor.h"
#include "fdbserver/TesterInterface.actor.h"
#include "fdbserver/WorkerInterface.actor.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "fdbserver/RecoveryState.h"
#include "fdbserver/ServerDBInfo.h"
#include "fdbrpc/simulator.h"
#include "fdbclient/ManagementAPI.actor.h"
#include "flow/actorcompiler.h" // This must be the last include.

struct KillRegionWorkload : TestWorkload {
	static constexpr auto NAME = "KillRegion";
	bool enabled;
	double testDuration;

	KillRegionWorkload(WorkloadContext const& wcx) : TestWorkload(wcx) {
		enabled =
		    !clientId && g_network->isSimulated(); // only do this on the "first" client, and only when in simulation
		testDuration = getOption(options, "testDuration"_sr, 10.0);
		g_simulator->usableRegions = 1;
	}

	void disableFailureInjectionWorkloads(std::set<std::string>& out) const override { out.insert("all"); }

	Future<Void> setup(Database const& cx) override {
		if (enabled) {
			return _setup(this, cx);
		}
		return Void();
	}
	Future<Void> start(Database const& cx) override {
		if (enabled) {
			return killRegion(this, cx);
		}
		return Void();
	}
	Future<bool> check(Database const& cx) override { return true; }
	void getMetrics(std::vector<PerfMetric>& m) override {}

																#line 62 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/KillRegion.actor.g.cpp"
// This generated class is to be used only via _setup()
															#line 60 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
template <class _setupActor>
															#line 60 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
class _setupActorState {
															#line 68 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/KillRegion.actor.g.cpp"
public:
															#line 60 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
	_setupActorState(KillRegionWorkload* const& self,Database const& cx) 
															#line 60 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
															#line 60 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
		 : self(self),
															#line 60 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
		   cx(cx)
															#line 77 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/KillRegion.actor.g.cpp"
	{
		fdb_probe_actor_create("_setup", reinterpret_cast<unsigned long>(this));

	}
	~_setupActorState() 
	{
		fdb_probe_actor_destroy("_setup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 61 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
			TraceEvent("ForceRecovery_DisablePrimaryBegin").log();
															#line 62 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
			StrictFuture<Void> __when_expr_0 = success(ManagementAPI::changeConfig(cx.getReference(), g_simulator->disablePrimary, true));
															#line 62 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
			if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 96 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/KillRegion.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_setupActor*>(this)->actor_wait_state = 1;
															#line 62 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 0, Void >*>(static_cast<_setupActor*>(this)));
															#line 101 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/KillRegion.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 63 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
		TraceEvent("ForceRecovery_WaitForRemote").log();
															#line 64 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
		StrictFuture<Void> __when_expr_1 = waitForPrimaryDC(cx, "1"_sr);
															#line 64 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
		if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 128 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/KillRegion.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_setupActor*>(this)->actor_wait_state = 2;
															#line 64 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 1, Void >*>(static_cast<_setupActor*>(this)));
															#line 133 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/KillRegion.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 63 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
		TraceEvent("ForceRecovery_WaitForRemote").log();
															#line 64 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
		StrictFuture<Void> __when_expr_1 = waitForPrimaryDC(cx, "1"_sr);
															#line 64 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
		if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 146 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/KillRegion.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_setupActor*>(this)->actor_wait_state = 2;
															#line 64 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 1, Void >*>(static_cast<_setupActor*>(this)));
															#line 151 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/KillRegion.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_setupActor*>(this)->actor_wait_state > 0) static_cast<_setupActor*>(this)->actor_wait_state = 0;
		static_cast<_setupActor*>(this)->ActorCallback< _setupActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _setupActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _setupActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _setupActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 65 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
		TraceEvent("ForceRecovery_DisablePrimaryComplete").log();
															#line 66 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
		if (!static_cast<_setupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_setupActorState(); static_cast<_setupActor*>(this)->destroy(); return 0; }
															#line 237 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/KillRegion.actor.g.cpp"
		new (&static_cast<_setupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 65 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
		TraceEvent("ForceRecovery_DisablePrimaryComplete").log();
															#line 66 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
		if (!static_cast<_setupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_setupActorState(); static_cast<_setupActor*>(this)->destroy(); return 0; }
															#line 251 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/KillRegion.actor.g.cpp"
		new (&static_cast<_setupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_setupActor*>(this)->actor_wait_state > 0) static_cast<_setupActor*>(this)->actor_wait_state = 0;
		static_cast<_setupActor*>(this)->ActorCallback< _setupActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _setupActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _setupActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _setupActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 60 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
	KillRegionWorkload* self;
															#line 60 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
	Database cx;
															#line 338 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/KillRegion.actor.g.cpp"
};
// This generated class is to be used only via _setup()
															#line 60 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
class _setupActor final : public Actor<Void>, public ActorCallback< _setupActor, 0, Void >, public ActorCallback< _setupActor, 1, Void >, public FastAllocated<_setupActor>, public _setupActorState<_setupActor> {
															#line 343 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/KillRegion.actor.g.cpp"
public:
	using FastAllocated<_setupActor>::operator new;
	using FastAllocated<_setupActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10625507408678319872UL, 10780454260656056576UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _setupActor, 0, Void >;
friend struct ActorCallback< _setupActor, 1, Void >;
															#line 60 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
	_setupActor(KillRegionWorkload* const& self,Database const& cx) 
															#line 361 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/KillRegion.actor.g.cpp"
		 : Actor<Void>(),
		   _setupActorState<_setupActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3044502327521131520UL, 13387266639422932480UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_setup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _setupActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _setupActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 60 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
[[nodiscard]] static Future<Void> _setup( KillRegionWorkload* const& self, Database const& cx ) {
															#line 60 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
	return Future<Void>(new _setupActor(self, cx));
															#line 394 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/KillRegion.actor.g.cpp"
}

#line 68 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"

																#line 399 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/KillRegion.actor.g.cpp"
// This generated class is to be used only via waitForStorageRecovered()
															#line 69 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
template <class WaitForStorageRecoveredActor>
															#line 69 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
class WaitForStorageRecoveredActorState {
															#line 405 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/KillRegion.actor.g.cpp"
public:
															#line 69 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
	WaitForStorageRecoveredActorState(KillRegionWorkload* const& self) 
															#line 69 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
															#line 69 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
		 : self(self)
															#line 412 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/KillRegion.actor.g.cpp"
	{
		fdb_probe_actor_create("waitForStorageRecovered", reinterpret_cast<unsigned long>(this));

	}
	~WaitForStorageRecoveredActorState() 
	{
		fdb_probe_actor_destroy("waitForStorageRecovered", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 70 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
			;
															#line 427 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/KillRegion.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WaitForStorageRecoveredActorState();
		static_cast<WaitForStorageRecoveredActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 73 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
		if (!static_cast<WaitForStorageRecoveredActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WaitForStorageRecoveredActorState(); static_cast<WaitForStorageRecoveredActor*>(this)->destroy(); return 0; }
															#line 450 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/KillRegion.actor.g.cpp"
		new (&static_cast<WaitForStorageRecoveredActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WaitForStorageRecoveredActorState();
		static_cast<WaitForStorageRecoveredActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 70 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
		if (!(self->dbInfo->get().recoveryState < RecoveryState::STORAGE_RECOVERED))
															#line 469 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/KillRegion.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 71 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
		StrictFuture<Void> __when_expr_0 = self->dbInfo->onChange();
															#line 71 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
		if (static_cast<WaitForStorageRecoveredActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 477 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/KillRegion.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<WaitForStorageRecoveredActor*>(this)->actor_wait_state = 1;
															#line 71 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WaitForStorageRecoveredActor, 0, Void >*>(static_cast<WaitForStorageRecoveredActor*>(this)));
															#line 482 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/KillRegion.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WaitForStorageRecoveredActor*>(this)->actor_wait_state > 0) static_cast<WaitForStorageRecoveredActor*>(this)->actor_wait_state = 0;
		static_cast<WaitForStorageRecoveredActor*>(this)->ActorCallback< WaitForStorageRecoveredActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitForStorageRecoveredActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitForStorageRecovered", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForStorageRecoveredActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForStorageRecovered", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WaitForStorageRecoveredActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitForStorageRecovered", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForStorageRecoveredActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForStorageRecovered", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WaitForStorageRecoveredActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitForStorageRecovered", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForStorageRecoveredActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForStorageRecovered", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 69 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
	KillRegionWorkload* self;
															#line 589 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/KillRegion.actor.g.cpp"
};
// This generated class is to be used only via waitForStorageRecovered()
															#line 69 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
class WaitForStorageRecoveredActor final : public Actor<Void>, public ActorCallback< WaitForStorageRecoveredActor, 0, Void >, public FastAllocated<WaitForStorageRecoveredActor>, public WaitForStorageRecoveredActorState<WaitForStorageRecoveredActor> {
															#line 594 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/KillRegion.actor.g.cpp"
public:
	using FastAllocated<WaitForStorageRecoveredActor>::operator new;
	using FastAllocated<WaitForStorageRecoveredActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12765406203719680512UL, 16737439058370442496UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WaitForStorageRecoveredActor, 0, Void >;
															#line 69 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
	WaitForStorageRecoveredActor(KillRegionWorkload* const& self) 
															#line 611 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/KillRegion.actor.g.cpp"
		 : Actor<Void>(),
		   WaitForStorageRecoveredActorState<WaitForStorageRecoveredActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("waitForStorageRecovered", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10721522214896757760UL, 11872153364310944000UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForStorageRecoveredActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("waitForStorageRecovered");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("waitForStorageRecovered", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WaitForStorageRecoveredActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 69 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
[[nodiscard]] static Future<Void> waitForStorageRecovered( KillRegionWorkload* const& self ) {
															#line 69 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
	return Future<Void>(new WaitForStorageRecoveredActor(self));
															#line 643 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/KillRegion.actor.g.cpp"
}

#line 75 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"

																#line 648 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/KillRegion.actor.g.cpp"
// This generated class is to be used only via killRegion()
															#line 76 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
template <class KillRegionActor>
															#line 76 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
class KillRegionActorState {
															#line 654 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/KillRegion.actor.g.cpp"
public:
															#line 76 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
	KillRegionActorState(KillRegionWorkload* const& self,Database const& cx) 
															#line 76 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
															#line 76 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
		 : self(self),
															#line 76 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
		   cx(cx)
															#line 663 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/KillRegion.actor.g.cpp"
	{
		fdb_probe_actor_create("killRegion", reinterpret_cast<unsigned long>(this));

	}
	~KillRegionActorState() 
	{
		fdb_probe_actor_destroy("killRegion", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 77 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
			ASSERT(g_network->isSimulated());
															#line 78 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
			if (deterministicRandom()->random01() < 0.5)
															#line 680 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/KillRegion.actor.g.cpp"
			{
															#line 79 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
				TraceEvent("ForceRecovery_DisableRemoteBegin").log();
															#line 80 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
				StrictFuture<Void> __when_expr_0 = success(ManagementAPI::changeConfig(cx.getReference(), g_simulator->disableRemote, true));
															#line 80 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
				if (static_cast<KillRegionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 688 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/KillRegion.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<KillRegionActor*>(this)->actor_wait_state = 1;
															#line 80 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< KillRegionActor, 0, Void >*>(static_cast<KillRegionActor*>(this)));
															#line 693 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/KillRegion.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~KillRegionActorState();
		static_cast<KillRegionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 86 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
		TraceEvent("ForceRecovery_Wait").log();
															#line 87 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
		StrictFuture<Void> __when_expr_3 = delay(deterministicRandom()->random01() * self->testDuration);
															#line 87 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
		if (static_cast<KillRegionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 725 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/KillRegion.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont1when1(__when_expr_3.get(), loopDepth); };
		static_cast<KillRegionActor*>(this)->actor_wait_state = 4;
															#line 87 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< KillRegionActor, 3, Void >*>(static_cast<KillRegionActor*>(this)));
															#line 730 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/KillRegion.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 81 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
		TraceEvent("ForceRecovery_WaitForPrimary").log();
															#line 82 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
		StrictFuture<Void> __when_expr_1 = waitForPrimaryDC(cx, "0"_sr);
															#line 82 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
		if (static_cast<KillRegionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 743 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/KillRegion.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<KillRegionActor*>(this)->actor_wait_state = 2;
															#line 82 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< KillRegionActor, 1, Void >*>(static_cast<KillRegionActor*>(this)));
															#line 748 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/KillRegion.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 81 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
		TraceEvent("ForceRecovery_WaitForPrimary").log();
															#line 82 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
		StrictFuture<Void> __when_expr_1 = waitForPrimaryDC(cx, "0"_sr);
															#line 82 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
		if (static_cast<KillRegionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 761 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/KillRegion.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<KillRegionActor*>(this)->actor_wait_state = 2;
															#line 82 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< KillRegionActor, 1, Void >*>(static_cast<KillRegionActor*>(this)));
															#line 766 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/KillRegion.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<KillRegionActor*>(this)->actor_wait_state > 0) static_cast<KillRegionActor*>(this)->actor_wait_state = 0;
		static_cast<KillRegionActor*>(this)->ActorCallback< KillRegionActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< KillRegionActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("killRegion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<KillRegionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("killRegion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< KillRegionActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("killRegion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<KillRegionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("killRegion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< KillRegionActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("killRegion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<KillRegionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("killRegion", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 83 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
		TraceEvent("ForceRecovery_DisableRemoteComplete").log();
															#line 84 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
		StrictFuture<Void> __when_expr_2 = success(ManagementAPI::changeConfig(cx.getReference(), g_simulator->originalRegions, true));
															#line 84 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
		if (static_cast<KillRegionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 854 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/KillRegion.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<KillRegionActor*>(this)->actor_wait_state = 3;
															#line 84 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< KillRegionActor, 2, Void >*>(static_cast<KillRegionActor*>(this)));
															#line 859 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/KillRegion.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 83 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
		TraceEvent("ForceRecovery_DisableRemoteComplete").log();
															#line 84 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
		StrictFuture<Void> __when_expr_2 = success(ManagementAPI::changeConfig(cx.getReference(), g_simulator->originalRegions, true));
															#line 84 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
		if (static_cast<KillRegionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 872 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/KillRegion.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<KillRegionActor*>(this)->actor_wait_state = 3;
															#line 84 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< KillRegionActor, 2, Void >*>(static_cast<KillRegionActor*>(this)));
															#line 877 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/KillRegion.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<KillRegionActor*>(this)->actor_wait_state > 0) static_cast<KillRegionActor*>(this)->actor_wait_state = 0;
		static_cast<KillRegionActor*>(this)->ActorCallback< KillRegionActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< KillRegionActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("killRegion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<KillRegionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("killRegion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< KillRegionActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("killRegion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<KillRegionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("killRegion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< KillRegionActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("killRegion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<KillRegionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("killRegion", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<KillRegionActor*>(this)->actor_wait_state > 0) static_cast<KillRegionActor*>(this)->actor_wait_state = 0;
		static_cast<KillRegionActor*>(this)->ActorCallback< KillRegionActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< KillRegionActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("killRegion", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<KillRegionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("killRegion", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< KillRegionActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("killRegion", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<KillRegionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("killRegion", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< KillRegionActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("killRegion", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<KillRegionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("killRegion", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 91 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
		g_simulator->killDataCenter("0"_sr, deterministicRandom()->random01() < 0.5 ? ISimulator::KillType::KillInstantly : ISimulator::KillType::RebootAndDelete, true);
															#line 95 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
		g_simulator->killDataCenter("2"_sr, deterministicRandom()->random01() < 0.5 ? ISimulator::KillType::KillInstantly : ISimulator::KillType::RebootAndDelete, true);
															#line 99 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
		g_simulator->killDataCenter("4"_sr, deterministicRandom()->random01() < 0.5 ? ISimulator::KillType::KillInstantly : ISimulator::KillType::RebootAndDelete, true);
															#line 104 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
		TraceEvent("ForceRecovery_Begin").log();
															#line 106 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
		StrictFuture<Void> __when_expr_4 = forceRecovery(cx->getConnectionRecord(), "1"_sr);
															#line 106 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
		if (static_cast<KillRegionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1058 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/KillRegion.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont5when1(__when_expr_4.get(), loopDepth); };
		static_cast<KillRegionActor*>(this)->actor_wait_state = 5;
															#line 106 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< KillRegionActor, 4, Void >*>(static_cast<KillRegionActor*>(this)));
															#line 1063 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/KillRegion.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 91 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
		g_simulator->killDataCenter("0"_sr, deterministicRandom()->random01() < 0.5 ? ISimulator::KillType::KillInstantly : ISimulator::KillType::RebootAndDelete, true);
															#line 95 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
		g_simulator->killDataCenter("2"_sr, deterministicRandom()->random01() < 0.5 ? ISimulator::KillType::KillInstantly : ISimulator::KillType::RebootAndDelete, true);
															#line 99 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
		g_simulator->killDataCenter("4"_sr, deterministicRandom()->random01() < 0.5 ? ISimulator::KillType::KillInstantly : ISimulator::KillType::RebootAndDelete, true);
															#line 104 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
		TraceEvent("ForceRecovery_Begin").log();
															#line 106 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
		StrictFuture<Void> __when_expr_4 = forceRecovery(cx->getConnectionRecord(), "1"_sr);
															#line 106 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
		if (static_cast<KillRegionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1082 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/KillRegion.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont5when1(__when_expr_4.get(), loopDepth); };
		static_cast<KillRegionActor*>(this)->actor_wait_state = 5;
															#line 106 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< KillRegionActor, 4, Void >*>(static_cast<KillRegionActor*>(this)));
															#line 1087 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/KillRegion.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<KillRegionActor*>(this)->actor_wait_state > 0) static_cast<KillRegionActor*>(this)->actor_wait_state = 0;
		static_cast<KillRegionActor*>(this)->ActorCallback< KillRegionActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< KillRegionActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("killRegion", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<KillRegionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("killRegion", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< KillRegionActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("killRegion", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<KillRegionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("killRegion", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< KillRegionActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("killRegion", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<KillRegionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("killRegion", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 108 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
		TraceEvent("ForceRecovery_UsableRegions").log();
															#line 110 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
		StrictFuture<DatabaseConfiguration> __when_expr_5 = getDatabaseConfiguration(cx);
															#line 110 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
		if (static_cast<KillRegionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1175 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/KillRegion.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont6when1(__when_expr_5.get(), loopDepth); };
		static_cast<KillRegionActor*>(this)->actor_wait_state = 6;
															#line 110 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< KillRegionActor, 5, DatabaseConfiguration >*>(static_cast<KillRegionActor*>(this)));
															#line 1180 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/KillRegion.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 108 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
		TraceEvent("ForceRecovery_UsableRegions").log();
															#line 110 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
		StrictFuture<DatabaseConfiguration> __when_expr_5 = getDatabaseConfiguration(cx);
															#line 110 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
		if (static_cast<KillRegionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1193 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/KillRegion.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont6when1(__when_expr_5.get(), loopDepth); };
		static_cast<KillRegionActor*>(this)->actor_wait_state = 6;
															#line 110 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< KillRegionActor, 5, DatabaseConfiguration >*>(static_cast<KillRegionActor*>(this)));
															#line 1198 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/KillRegion.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<KillRegionActor*>(this)->actor_wait_state > 0) static_cast<KillRegionActor*>(this)->actor_wait_state = 0;
		static_cast<KillRegionActor*>(this)->ActorCallback< KillRegionActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< KillRegionActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("killRegion", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<KillRegionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("killRegion", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< KillRegionActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("killRegion", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<KillRegionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("killRegion", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< KillRegionActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("killRegion", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<KillRegionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("killRegion", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont7(DatabaseConfiguration const& conf,int loopDepth) 
	{
															#line 112 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
		TraceEvent("ForceRecovery_GotConfig") .setMaxEventLength(11000) .setMaxFieldLength(10000) .detail("Conf", conf.toString());
															#line 117 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
		if (conf.usableRegions > 1)
															#line 1284 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/KillRegion.actor.g.cpp"
		{
															#line 118 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
			;
															#line 1288 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/KillRegion.actor.g.cpp"
			loopDepth = a_body1cont7loopHead1(loopDepth);
		}
		else
		{
			loopDepth = a_body1cont8(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont7(DatabaseConfiguration && conf,int loopDepth) 
	{
															#line 112 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
		TraceEvent("ForceRecovery_GotConfig") .setMaxEventLength(11000) .setMaxFieldLength(10000) .detail("Conf", conf.toString());
															#line 117 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
		if (conf.usableRegions > 1)
															#line 1304 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/KillRegion.actor.g.cpp"
		{
															#line 118 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
			;
															#line 1308 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/KillRegion.actor.g.cpp"
			loopDepth = a_body1cont7loopHead1(loopDepth);
		}
		else
		{
			loopDepth = a_body1cont8(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont6when1(DatabaseConfiguration const& conf,int loopDepth) 
	{
		loopDepth = a_body1cont7(conf, loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(DatabaseConfiguration && conf,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(conf), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<KillRegionActor*>(this)->actor_wait_state > 0) static_cast<KillRegionActor*>(this)->actor_wait_state = 0;
		static_cast<KillRegionActor*>(this)->ActorCallback< KillRegionActor, 5, DatabaseConfiguration >::remove();

	}
	void a_callback_fire(ActorCallback< KillRegionActor, 5, DatabaseConfiguration >*,DatabaseConfiguration const& value) 
	{
		fdb_probe_actor_enter("killRegion", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<KillRegionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("killRegion", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< KillRegionActor, 5, DatabaseConfiguration >*,DatabaseConfiguration && value) 
	{
		fdb_probe_actor_enter("killRegion", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<KillRegionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("killRegion", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< KillRegionActor, 5, DatabaseConfiguration >*,Error err) 
	{
		fdb_probe_actor_enter("killRegion", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<KillRegionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("killRegion", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont8(int loopDepth) 
	{
															#line 132 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
		TraceEvent("ForceRecovery_Complete").log();
															#line 134 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
		if (!static_cast<KillRegionActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~KillRegionActorState(); static_cast<KillRegionActor*>(this)->destroy(); return 0; }
															#line 1399 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/KillRegion.actor.g.cpp"
		new (&static_cast<KillRegionActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~KillRegionActorState();
		static_cast<KillRegionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont9(int loopDepth) 
	{
															#line 129 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
		StrictFuture<Void> __when_expr_9 = success(ManagementAPI::changeConfig(cx.getReference(), "usable_regions=1", true));
															#line 129 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
		if (static_cast<KillRegionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1413 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/KillRegion.actor.g.cpp"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont9when1(__when_expr_9.get(), loopDepth); };
		static_cast<KillRegionActor*>(this)->actor_wait_state = 9;
															#line 129 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< KillRegionActor, 9, Void >*>(static_cast<KillRegionActor*>(this)));
															#line 1418 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/KillRegion.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont7loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont7loopBody1(int loopDepth) 
	{
															#line 120 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
		StrictFuture<Void> __when_expr_6 = success(ManagementAPI::changeConfig( cx.getReference(), g_simulator->disablePrimary + " repopulate_anti_quorum=1", true));
															#line 120 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
		if (static_cast<KillRegionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1436 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/KillRegion.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1cont7loopBody1when1(__when_expr_6.get(), loopDepth); };
		static_cast<KillRegionActor*>(this)->actor_wait_state = 7;
															#line 120 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< KillRegionActor, 6, Void >*>(static_cast<KillRegionActor*>(this)));
															#line 1441 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/KillRegion.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7break1(int loopDepth) 
	{
		try {
			return a_body1cont9(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont7loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 123 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
		StrictFuture<Void> __when_expr_7 = waitForStorageRecovered(self);
															#line 122 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
		if (static_cast<KillRegionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1465 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/KillRegion.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), std::max(0, loopDepth - 1)); else return a_body1cont7loopBody1cont1when1(__when_expr_7.get(), loopDepth); };
															#line 126 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
		StrictFuture<Void> __when_expr_8 = delay(300.0);
															#line 1469 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/KillRegion.actor.g.cpp"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), std::max(0, loopDepth - 1)); else return a_body1cont7loopBody1cont1when2(__when_expr_8.get(), loopDepth); };
		static_cast<KillRegionActor*>(this)->actor_wait_state = 8;
															#line 123 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< KillRegionActor, 7, Void >*>(static_cast<KillRegionActor*>(this)));
															#line 126 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< KillRegionActor, 8, Void >*>(static_cast<KillRegionActor*>(this)));
															#line 1476 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/KillRegion.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 123 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
		StrictFuture<Void> __when_expr_7 = waitForStorageRecovered(self);
															#line 122 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
		if (static_cast<KillRegionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1487 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/KillRegion.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), std::max(0, loopDepth - 1)); else return a_body1cont7loopBody1cont1when1(__when_expr_7.get(), loopDepth); };
															#line 126 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
		StrictFuture<Void> __when_expr_8 = delay(300.0);
															#line 1491 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/KillRegion.actor.g.cpp"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), std::max(0, loopDepth - 1)); else return a_body1cont7loopBody1cont1when2(__when_expr_8.get(), loopDepth); };
		static_cast<KillRegionActor*>(this)->actor_wait_state = 8;
															#line 123 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< KillRegionActor, 7, Void >*>(static_cast<KillRegionActor*>(this)));
															#line 126 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< KillRegionActor, 8, Void >*>(static_cast<KillRegionActor*>(this)));
															#line 1498 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/KillRegion.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont7loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<KillRegionActor*>(this)->actor_wait_state > 0) static_cast<KillRegionActor*>(this)->actor_wait_state = 0;
		static_cast<KillRegionActor*>(this)->ActorCallback< KillRegionActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< KillRegionActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("killRegion", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<KillRegionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont7loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("killRegion", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< KillRegionActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("killRegion", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<KillRegionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont7loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("killRegion", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< KillRegionActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("killRegion", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<KillRegionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("killRegion", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont7loopBody1cont2(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont7loopHead1(0);

		return loopDepth;
	}
	int a_body1cont7loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		return a_body1cont7break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont7loopBody1cont1when1(Void && _,int loopDepth) 
	{
		return a_body1cont7break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont7loopBody1cont1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont7loopBody1cont1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<KillRegionActor*>(this)->actor_wait_state > 0) static_cast<KillRegionActor*>(this)->actor_wait_state = 0;
		static_cast<KillRegionActor*>(this)->ActorCallback< KillRegionActor, 7, Void >::remove();
		static_cast<KillRegionActor*>(this)->ActorCallback< KillRegionActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< KillRegionActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("killRegion", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<KillRegionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont7loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("killRegion", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< KillRegionActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("killRegion", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<KillRegionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont7loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("killRegion", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< KillRegionActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("killRegion", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<KillRegionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("killRegion", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< KillRegionActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("killRegion", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<KillRegionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont7loopBody1cont1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("killRegion", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< KillRegionActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("killRegion", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<KillRegionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont7loopBody1cont1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("killRegion", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< KillRegionActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("killRegion", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<KillRegionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("killRegion", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont10(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont10(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont9when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont9when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<KillRegionActor*>(this)->actor_wait_state > 0) static_cast<KillRegionActor*>(this)->actor_wait_state = 0;
		static_cast<KillRegionActor*>(this)->ActorCallback< KillRegionActor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< KillRegionActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("killRegion", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<KillRegionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont9when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("killRegion", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< KillRegionActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("killRegion", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<KillRegionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("killRegion", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< KillRegionActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("killRegion", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<KillRegionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("killRegion", reinterpret_cast<unsigned long>(this), 9);

	}
															#line 76 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
	KillRegionWorkload* self;
															#line 76 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
	Database cx;
															#line 1820 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/KillRegion.actor.g.cpp"
};
// This generated class is to be used only via killRegion()
															#line 76 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
class KillRegionActor final : public Actor<Void>, public ActorCallback< KillRegionActor, 0, Void >, public ActorCallback< KillRegionActor, 1, Void >, public ActorCallback< KillRegionActor, 2, Void >, public ActorCallback< KillRegionActor, 3, Void >, public ActorCallback< KillRegionActor, 4, Void >, public ActorCallback< KillRegionActor, 5, DatabaseConfiguration >, public ActorCallback< KillRegionActor, 6, Void >, public ActorCallback< KillRegionActor, 7, Void >, public ActorCallback< KillRegionActor, 8, Void >, public ActorCallback< KillRegionActor, 9, Void >, public FastAllocated<KillRegionActor>, public KillRegionActorState<KillRegionActor> {
															#line 1825 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/KillRegion.actor.g.cpp"
public:
	using FastAllocated<KillRegionActor>::operator new;
	using FastAllocated<KillRegionActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1087374485525645824UL, 5887901546001232640UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< KillRegionActor, 0, Void >;
friend struct ActorCallback< KillRegionActor, 1, Void >;
friend struct ActorCallback< KillRegionActor, 2, Void >;
friend struct ActorCallback< KillRegionActor, 3, Void >;
friend struct ActorCallback< KillRegionActor, 4, Void >;
friend struct ActorCallback< KillRegionActor, 5, DatabaseConfiguration >;
friend struct ActorCallback< KillRegionActor, 6, Void >;
friend struct ActorCallback< KillRegionActor, 7, Void >;
friend struct ActorCallback< KillRegionActor, 8, Void >;
friend struct ActorCallback< KillRegionActor, 9, Void >;
															#line 76 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
	KillRegionActor(KillRegionWorkload* const& self,Database const& cx) 
															#line 1851 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/KillRegion.actor.g.cpp"
		 : Actor<Void>(),
		   KillRegionActorState<KillRegionActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("killRegion", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10885017457043919360UL, 11918441341219410176UL);
		ActorExecutionContextHelper __helper(static_cast<KillRegionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("killRegion");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("killRegion", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< KillRegionActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< KillRegionActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< KillRegionActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< KillRegionActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< KillRegionActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< KillRegionActor, 5, DatabaseConfiguration >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< KillRegionActor, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< KillRegionActor, 7, Void >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< KillRegionActor, 9, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 76 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
[[nodiscard]] static Future<Void> killRegion( KillRegionWorkload* const& self, Database const& cx ) {
															#line 76 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
	return Future<Void>(new KillRegionActor(self, cx));
															#line 1891 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/KillRegion.actor.g.cpp"
}

#line 136 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/KillRegion.actor.cpp"
};

WorkloadFactory<KillRegionWorkload> KillRegionWorkloadFactory;
