#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
/*
 * Cycle.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "flow/Arena.h"
#include "flow/IRandom.h"
#include "flow/Trace.h"
#include "flow/UnitTest.h"
#include "flow/WipedString.h"
#include "flow/serialize.h"
#include "fdbrpc/simulator.h"
#include "fdbrpc/TokenSign.h"
#include "fdbrpc/TenantInfo.h"
#include "fdbclient/FDBOptions.g.h"
#include "fdbclient/NativeAPI.actor.h"
#include "fdbserver/TesterInterface.actor.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "fdbserver/workloads/BulkSetup.actor.h"

#include "flow/actorcompiler.h" // This must be the last #include.

template <bool MultiTenancy>
struct CycleMembers {};

template <>
struct CycleMembers<true> {
	Arena arena;
	TenantName tenant;
	int64_t tenantId;
	WipedString signedToken;
	bool useToken;
};

template <bool>
struct CycleWorkload;

															#line 55 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp"
[[nodiscard]] Future<Void> prepareToken( Database const& cx, CycleWorkload<true>* const& self );

#line 54 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"

template <bool MultiTenancy>
struct CycleWorkload : TestWorkload, CycleMembers<MultiTenancy> {
	static constexpr auto NAME = MultiTenancy ? "TenantCycle" : "Cycle";
	static constexpr auto TenantEnabled = MultiTenancy;
	int actorCount, nodeCount;
	double testDuration, transactionsPerSecond, minExpectedTransactionsPerSecond, traceParentProbability;
	bool unseedCheck{ true };
	bool skipSetup{ false }; // Useful for restarting tests
	Key keyPrefix;

	std::vector<Future<Void>> clients;
	PerfIntCounter transactions, retries, tooOldRetries, commitFailedRetries;
	PerfDoubleCounter totalLatency;

	CycleWorkload(WorkloadContext const& wcx)
	  : TestWorkload(wcx), transactions("Transactions"), retries("Retries"), tooOldRetries("Retries.too_old"),
	    commitFailedRetries("Retries.commit_failed"), totalLatency("Latency") {
		testDuration = getOption(options, "testDuration"_sr, 10.0);
		transactionsPerSecond = getOption(options, "transactionsPerSecond"_sr, 5000.0) / clientCount;
		actorCount = getOption(options, "actorsPerClient"_sr, transactionsPerSecond / 5);
		nodeCount = getOption(options, "nodeCount"_sr, transactionsPerSecond * clientCount);
		keyPrefix = unprintable(getOption(options, "keyPrefix"_sr, ""_sr).toString());
		traceParentProbability = getOption(options, "traceParentProbability"_sr, 0.01);
		minExpectedTransactionsPerSecond = transactionsPerSecond * getOption(options, "expectedRate"_sr, 0.7);
		unseedCheck = getOption(options, "unseedCheck"_sr, true);
		skipSetup = getOption(options, "skipSetup"_sr, false);
		if constexpr (MultiTenancy) {
			ASSERT(g_network->isSimulated());
			this->useToken = getOption(options, "useToken"_sr, true);
			this->tenant = getOption(options, "tenant"_sr, "CycleTenant"_sr);
			this->tenantId = TenantInfo::INVALID_TENANT;
		}
	}

	Future<Void> setup(Database const& cx) override {
		if (!unseedCheck) {
			noUnseed = true;
		}
		if (skipSetup) {
			return Void();
		}
		Future<Void> prepare;
		if constexpr (MultiTenancy) {
			prepare = prepareToken(cx, this);
		} else {
			prepare = Void();
		}
		return runAfter(prepare, [this, cx](Void) { return bulkSetup(cx, this, nodeCount, Promise<double>()); });
	}
	Future<Void> start(Database const& cx) override {
		if constexpr (MultiTenancy) {
			cx->defaultTenant = this->tenant;
		}
		for (int c = 0; c < actorCount; c++)
			clients.push_back(
			    timeout(cycleClient(cx->clone(), this, actorCount / transactionsPerSecond), testDuration, Void()));
		return delay(testDuration);
	}
	Future<bool> check(Database const& cx) override {
		if constexpr (MultiTenancy) {
			cx->defaultTenant = this->tenant;
		}
		int errors = 0;
		for (int c = 0; c < clients.size(); c++)
			errors += clients[c].isError();
		if (errors)
			TraceEvent(SevError, "TestFailure").detail("Reason", "There were client errors.");
		clients.clear();
		return cycleCheck(cx->clone(), this, !errors);
	}
	void getMetrics(std::vector<PerfMetric>& m) override {
		m.push_back(transactions.getMetric());
		m.push_back(retries.getMetric());
		m.push_back(tooOldRetries.getMetric());
		m.push_back(commitFailedRetries.getMetric());
		m.emplace_back("Avg Latency (ms)", 1000 * totalLatency.getValue() / transactions.getValue(), Averaged::True);
		m.emplace_back("Read rows/simsec (approx)", transactions.getValue() * 3 / testDuration, Averaged::False);
		m.emplace_back("Write rows/simsec (approx)", transactions.getValue() * 4 / testDuration, Averaged::False);
	}

	Key keyForIndex(int n) { return key(n); }
	Key key(int n) { return doubleToTestKey((double)n / nodeCount, keyPrefix); }
	Value value(int n) { return doubleToTestKey(n, keyPrefix); }
	KeyRange keyRange(int n) {
		Key beginKey = doubleToTestKey((double)n / nodeCount, keyPrefix);
		Key endKey = beginKey.withSuffix(" end"_sr);
		return KeyRangeRef(beginKey, endKey);
	}
	int fromValue(const ValueRef& v) { return testKeyToDouble(v, keyPrefix); }

	Standalone<KeyValueRef> operator()(int n) { return KeyValueRef(key(n), value((n + 1) % nodeCount)); }

	void badRead(const char* name, int r, Transaction& tr) {
		TraceEvent(SevError, "CycleBadRead")
		    .detail(name, r)
		    .detail("Key", printable(key(r)))
		    .detail("Version", tr.getReadVersion().get())
		    .detailf("From", "%016llx", debug_lastLoadBalanceResultEndpointToken);
	}

	template <bool B = MultiTenancy>
	std::enable_if_t<B> setAuthToken(Transaction& tr) const {
		if (this->useToken)
			tr.setOption(FDBTransactionOptions::AUTHORIZATION_TOKEN, this->signedToken);
	}

	template <bool B = MultiTenancy>
	std::enable_if_t<!B> setAuthToken(Transaction& tr) const {}

																#line 169 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp"
// This generated class is to be used only via cycleClient()
															#line 164 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
template <class CycleClientActor>
															#line 164 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
class CycleClientActorState {
															#line 175 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp"
public:
															#line 164 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
	CycleClientActorState(Database const& cx,CycleWorkload* const& self,double const& delay) 
															#line 164 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
															#line 164 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		 : cx(cx),
															#line 164 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		   self(self),
															#line 164 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		   delay(delay),
															#line 165 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		   lastTime(now())
															#line 188 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp"
	{
		fdb_probe_actor_create("cycleClient", reinterpret_cast<unsigned long>(this));

	}
	~CycleClientActorState() 
	{
		fdb_probe_actor_destroy("cycleClient", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 166 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
			TraceEvent("CycleClientStart").log();
															#line 203 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp"
			try {
															#line 168 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
				;
															#line 207 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CycleClientActorState();
		static_cast<CycleClientActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 231 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
			TraceEvent(SevError, "CycleClient").error(e);
															#line 232 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 239 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 169 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		StrictFuture<Void> __when_expr_0 = poisson(&lastTime, delay);
															#line 169 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		if (static_cast<CycleClientActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 262 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<CycleClientActor*>(this)->actor_wait_state = 1;
															#line 169 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CycleClientActor, 0, Void >*>(static_cast<CycleClientActor*>(this)));
															#line 267 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 171 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		tstart = now();
															#line 172 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		r = deterministicRandom()->randomInt(0, self->nodeCount);
															#line 173 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		tr = Transaction(cx);
															#line 174 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		if (deterministicRandom()->random01() <= self->traceParentProbability)
															#line 282 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp"
		{
															#line 175 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
			span = Span("CycleClient"_loc);
															#line 176 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
			TraceEvent("CycleTracingTransaction", span.context.traceID).log();
															#line 177 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
			tr.setOption(FDBTransactionOptions::SPAN_PARENT, BinaryWriter::toValue(span.context, IncludeVersion()));
															#line 290 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp"
		}
															#line 180 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		;
															#line 294 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 171 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		tstart = now();
															#line 172 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		r = deterministicRandom()->randomInt(0, self->nodeCount);
															#line 173 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		tr = Transaction(cx);
															#line 174 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		if (deterministicRandom()->random01() <= self->traceParentProbability)
															#line 309 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp"
		{
															#line 175 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
			span = Span("CycleClient"_loc);
															#line 176 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
			TraceEvent("CycleTracingTransaction", span.context.traceID).log();
															#line 177 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
			tr.setOption(FDBTransactionOptions::SPAN_PARENT, BinaryWriter::toValue(span.context, IncludeVersion()));
															#line 317 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp"
		}
															#line 180 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		;
															#line 321 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CycleClientActor*>(this)->actor_wait_state > 0) static_cast<CycleClientActor*>(this)->actor_wait_state = 0;
		static_cast<CycleClientActor*>(this)->ActorCallback< CycleClientActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CycleClientActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("cycleClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CycleClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cycleClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CycleClientActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("cycleClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CycleClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cycleClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CycleClientActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("cycleClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CycleClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cycleClient", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 227 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		++self->transactions;
															#line 228 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		self->totalLatency += now() - tstart;
															#line 407 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1(int loopDepth) 
	{
		try {
															#line 182 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
			self->setAuthToken(tr);
															#line 184 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_1 = tr.get(self->key(r));
															#line 184 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
			if (static_cast<CycleClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 428 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1cont1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<CycleClientActor*>(this)->actor_wait_state = 2;
															#line 184 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CycleClientActor, 1, Optional<Value> >*>(static_cast<CycleClientActor*>(this)));
															#line 433 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont1(int loopDepth) 
	{
															#line 225 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		++self->retries;
															#line 461 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 219 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
			if (e.code() == error_code_transaction_too_old)
															#line 471 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp"
			{
															#line 220 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
				++self->tooOldRetries;
															#line 475 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp"
			}
			else
			{
															#line 221 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
				if (e.code() == error_code_not_committed)
															#line 481 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp"
				{
															#line 222 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
					++self->commitFailedRetries;
															#line 485 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp"
				}
			}
															#line 223 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
			StrictFuture<Void> __when_expr_5 = tr.onError(e);
															#line 223 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
			if (static_cast<CycleClientActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 492 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch2(__when_expr_5.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1Catch1when1(__when_expr_5.get(), loopDepth); };
			static_cast<CycleClientActor*>(this)->actor_wait_state = 6;
															#line 223 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< CycleClientActor, 5, Void >*>(static_cast<CycleClientActor*>(this)));
															#line 497 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont2(Optional<Value> const& v,int loopDepth) 
	{
															#line 185 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		if (!v.present())
															#line 512 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp"
		{
															#line 186 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
			self->badRead("KeyR", r, tr);
															#line 516 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp"
		}
															#line 188 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		r2 = self->fromValue(v.get());
															#line 189 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_2 = tr.get(self->key(r2));
															#line 189 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		if (static_cast<CycleClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 524 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1cont1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<CycleClientActor*>(this)->actor_wait_state = 3;
															#line 189 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CycleClientActor, 2, Optional<Value> >*>(static_cast<CycleClientActor*>(this)));
															#line 529 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont2(Optional<Value> && v,int loopDepth) 
	{
															#line 185 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		if (!v.present())
															#line 538 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp"
		{
															#line 186 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
			self->badRead("KeyR", r, tr);
															#line 542 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp"
		}
															#line 188 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		r2 = self->fromValue(v.get());
															#line 189 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_2 = tr.get(self->key(r2));
															#line 189 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		if (static_cast<CycleClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 550 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1cont1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<CycleClientActor*>(this)->actor_wait_state = 3;
															#line 189 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CycleClientActor, 2, Optional<Value> >*>(static_cast<CycleClientActor*>(this)));
															#line 555 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when1(Optional<Value> const& v,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont2(v, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when1(Optional<Value> && v,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont2(std::move(v), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CycleClientActor*>(this)->actor_wait_state > 0) static_cast<CycleClientActor*>(this)->actor_wait_state = 0;
		static_cast<CycleClientActor*>(this)->ActorCallback< CycleClientActor, 1, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< CycleClientActor, 1, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("cycleClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CycleClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cycleClient", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CycleClientActor, 1, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("cycleClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CycleClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cycleClient", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CycleClientActor, 1, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("cycleClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CycleClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cycleClient", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont1loopBody1cont3(Optional<Value> const& v2,int loopDepth) 
	{
															#line 190 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		if (!v2.present())
															#line 639 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp"
		{
															#line 191 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
			self->badRead("KeyR2", r2, tr);
															#line 643 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp"
		}
															#line 192 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		r3 = self->fromValue(v2.get());
															#line 193 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_3 = tr.get(self->key(r3));
															#line 193 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		if (static_cast<CycleClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 651 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1cont1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<CycleClientActor*>(this)->actor_wait_state = 4;
															#line 193 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CycleClientActor, 3, Optional<Value> >*>(static_cast<CycleClientActor*>(this)));
															#line 656 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont3(Optional<Value> && v2,int loopDepth) 
	{
															#line 190 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		if (!v2.present())
															#line 665 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp"
		{
															#line 191 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
			self->badRead("KeyR2", r2, tr);
															#line 669 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp"
		}
															#line 192 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		r3 = self->fromValue(v2.get());
															#line 193 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_3 = tr.get(self->key(r3));
															#line 193 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		if (static_cast<CycleClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 677 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1cont1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<CycleClientActor*>(this)->actor_wait_state = 4;
															#line 193 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CycleClientActor, 3, Optional<Value> >*>(static_cast<CycleClientActor*>(this)));
															#line 682 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont2when1(Optional<Value> const& v2,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont3(v2, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont2when1(Optional<Value> && v2,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont3(std::move(v2), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CycleClientActor*>(this)->actor_wait_state > 0) static_cast<CycleClientActor*>(this)->actor_wait_state = 0;
		static_cast<CycleClientActor*>(this)->ActorCallback< CycleClientActor, 2, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< CycleClientActor, 2, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("cycleClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CycleClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cycleClient", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CycleClientActor, 2, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("cycleClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CycleClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cycleClient", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CycleClientActor, 2, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("cycleClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CycleClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cycleClient", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont1loopBody1cont5(Optional<Value> const& v3,int loopDepth) 
	{
															#line 194 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		if (!v3.present())
															#line 766 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp"
		{
															#line 195 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
			self->badRead("KeyR3", r3, tr);
															#line 770 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp"
		}
															#line 196 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		r4 = self->fromValue(v3.get());
															#line 200 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		tr.clear( self->keyRange(r), AddConflictRange::True);
															#line 203 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		tr.set(self->key(r), self->value(r3));
															#line 204 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		tr.set(self->key(r2), self->value(r4));
															#line 205 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		tr.set(self->key(r3), self->value(r2));
															#line 210 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		StrictFuture<Void> __when_expr_4 = tr.commit();
															#line 210 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		if (static_cast<CycleClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 786 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1loopBody1cont1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1cont5when1(__when_expr_4.get(), loopDepth); };
		static_cast<CycleClientActor*>(this)->actor_wait_state = 5;
															#line 210 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< CycleClientActor, 4, Void >*>(static_cast<CycleClientActor*>(this)));
															#line 791 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont5(Optional<Value> && v3,int loopDepth) 
	{
															#line 194 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		if (!v3.present())
															#line 800 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp"
		{
															#line 195 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
			self->badRead("KeyR3", r3, tr);
															#line 804 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp"
		}
															#line 196 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		r4 = self->fromValue(v3.get());
															#line 200 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		tr.clear( self->keyRange(r), AddConflictRange::True);
															#line 203 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		tr.set(self->key(r), self->value(r3));
															#line 204 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		tr.set(self->key(r2), self->value(r4));
															#line 205 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		tr.set(self->key(r3), self->value(r2));
															#line 210 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		StrictFuture<Void> __when_expr_4 = tr.commit();
															#line 210 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		if (static_cast<CycleClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 820 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1loopBody1cont1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1cont5when1(__when_expr_4.get(), loopDepth); };
		static_cast<CycleClientActor*>(this)->actor_wait_state = 5;
															#line 210 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< CycleClientActor, 4, Void >*>(static_cast<CycleClientActor*>(this)));
															#line 825 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont3when1(Optional<Value> const& v3,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont5(v3, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont3when1(Optional<Value> && v3,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont5(std::move(v3), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<CycleClientActor*>(this)->actor_wait_state > 0) static_cast<CycleClientActor*>(this)->actor_wait_state = 0;
		static_cast<CycleClientActor*>(this)->ActorCallback< CycleClientActor, 3, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< CycleClientActor, 3, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("cycleClient", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CycleClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cycleClient", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< CycleClientActor, 3, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("cycleClient", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CycleClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cycleClient", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< CycleClientActor, 3, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("cycleClient", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CycleClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cycleClient", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont1loopBody1cont7(Void const& _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont7(Void && _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<CycleClientActor*>(this)->actor_wait_state > 0) static_cast<CycleClientActor*>(this)->actor_wait_state = 0;
		static_cast<CycleClientActor*>(this)->ActorCallback< CycleClientActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CycleClientActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("cycleClient", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CycleClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont1loopBody1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cycleClient", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< CycleClientActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("cycleClient", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CycleClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont1loopBody1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cycleClient", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< CycleClientActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("cycleClient", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CycleClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cycleClient", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1loopBody1cont1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<CycleClientActor*>(this)->actor_wait_state > 0) static_cast<CycleClientActor*>(this)->actor_wait_state = 0;
		static_cast<CycleClientActor*>(this)->ActorCallback< CycleClientActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CycleClientActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("cycleClient", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CycleClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cycleClient", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< CycleClientActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("cycleClient", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CycleClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cycleClient", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< CycleClientActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("cycleClient", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CycleClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cycleClient", reinterpret_cast<unsigned long>(this), 5);

	}
															#line 164 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
	Database cx;
															#line 164 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
	CycleWorkload* self;
															#line 164 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
	double delay;
															#line 165 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
	double lastTime;
															#line 171 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
	double tstart;
															#line 172 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
	int r;
															#line 173 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
	Transaction tr;
															#line 175 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
	Span span;
															#line 188 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
	int r2;
															#line 192 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
	int r3;
															#line 196 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
	int r4;
															#line 1101 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp"
};
// This generated class is to be used only via cycleClient()
															#line 164 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
class CycleClientActor final : public Actor<Void>, public ActorCallback< CycleClientActor, 0, Void >, public ActorCallback< CycleClientActor, 1, Optional<Value> >, public ActorCallback< CycleClientActor, 2, Optional<Value> >, public ActorCallback< CycleClientActor, 3, Optional<Value> >, public ActorCallback< CycleClientActor, 4, Void >, public ActorCallback< CycleClientActor, 5, Void >, public FastAllocated<CycleClientActor>, public CycleClientActorState<CycleClientActor> {
															#line 1106 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp"
public:
	using FastAllocated<CycleClientActor>::operator new;
	using FastAllocated<CycleClientActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8040942473240828928UL, 8012988387951699456UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CycleClientActor, 0, Void >;
friend struct ActorCallback< CycleClientActor, 1, Optional<Value> >;
friend struct ActorCallback< CycleClientActor, 2, Optional<Value> >;
friend struct ActorCallback< CycleClientActor, 3, Optional<Value> >;
friend struct ActorCallback< CycleClientActor, 4, Void >;
friend struct ActorCallback< CycleClientActor, 5, Void >;
															#line 164 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
	CycleClientActor(Database const& cx,CycleWorkload* const& self,double const& delay) 
															#line 1128 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp"
		 : Actor<Void>(),
		   CycleClientActorState<CycleClientActor>(cx, self, delay),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("cycleClient", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8966781505302877440UL, 11126568448771745280UL);
		ActorExecutionContextHelper __helper(static_cast<CycleClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("cycleClient");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("cycleClient", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CycleClientActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CycleClientActor, 1, Optional<Value> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CycleClientActor, 2, Optional<Value> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< CycleClientActor, 3, Optional<Value> >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< CycleClientActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< CycleClientActor, 5, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 164 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
[[nodiscard]] Future<Void> cycleClient( Database const& cx, CycleWorkload* const& self, double const& delay ) {
															#line 164 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
	return Future<Void>(new CycleClientActor(cx, self, delay));
															#line 1165 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp"
}

#line 235 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"

	void logTestData(const VectorRef<KeyValueRef>& data) {
		TraceEvent("TestFailureDetail").log();
		int index = 0;
		for (auto& entry : data) {
			TraceEvent("CurrentDataEntry")
			    .detail("Index", index)
			    .detail("Key", entry.key.toString())
			    .detail("Value", entry.value.toString());
			index++;
		}
	}

	bool cycleCheckData(const VectorRef<KeyValueRef>& data, Version v) {
		if (data.size() != nodeCount) {
			logTestData(data);
			TraceEvent(SevError, "TestFailure")
			    .detail("Reason", "Node count changed")
			    .detail("Before", nodeCount)
			    .detail("After", data.size())
			    .detail("Version", v)
			    .detail("KeyPrefix", keyPrefix.printable());
			TraceEvent(SevError, "TestFailureInfo")
			    .detail("DataSize", data.size())
			    .detail("NodeCount", nodeCount)
			    .detail("Workload", description());
			return false;
		}
		int i = 0;
		int iPrev = 0;
		double d;
		int c;
		for (c = 0; c < nodeCount; c++) {
			if (c && !i) {
				TraceEvent(SevError, "TestFailure")
				    .detail("Reason", "Cycle got shorter")
				    .detail("Before", nodeCount)
				    .detail("After", c)
				    .detail("KeyPrefix", keyPrefix.printable());
				logTestData(data);
				return false;
			}
			if (data[i].key != key(i)) {
				TraceEvent(SevError, "TestFailure")
				    .detail("Reason", "Key changed")
				    .detail("KeyPrefix", keyPrefix.printable());
				logTestData(data);
				return false;
			}
			d = testKeyToDouble(data[i].value, keyPrefix);
			iPrev = i;
			i = (int)d;
			if (i != d || i < 0 || i >= nodeCount) {
				TraceEvent(SevError, "TestFailure")
				    .detail("Reason", "Invalid value")
				    .detail("KeyPrefix", keyPrefix.printable());
				logTestData(data);
				return false;
			}
		}
		if (i != 0) {
			TraceEvent(SevError, "TestFailure")
			    .detail("Reason", "Cycle got longer")
			    .detail("KeyPrefix", keyPrefix.printable())
			    .detail("Key", key(i))
			    .detail("Value", data[i].value)
			    .detail("Iteration", c)
			    .detail("Nodecount", nodeCount)
			    .detail("Int", i)
			    .detail("Double", d)
			    .detail("ValuePrev", data[iPrev].value)
			    .detail("KeyPrev", data[iPrev].key);
			logTestData(data);
			return false;
		}
		return true;
	}

																#line 1247 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp"
// This generated class is to be used only via cycleCheck()
															#line 313 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
template <class CycleCheckActor>
															#line 313 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
class CycleCheckActorState {
															#line 1253 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp"
public:
															#line 313 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
	CycleCheckActorState(Database const& cx,CycleWorkload* const& self,bool const& ok) 
															#line 313 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
															#line 313 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		 : cx(cx),
															#line 313 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		   self(self),
															#line 313 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		   ok(ok)
															#line 1264 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp"
	{
		fdb_probe_actor_create("cycleCheck", reinterpret_cast<unsigned long>(this));

	}
	~CycleCheckActorState() 
	{
		fdb_probe_actor_destroy("cycleCheck", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 314 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
			if (self->transactions.getMetric().value() < self->testDuration * self->minExpectedTransactionsPerSecond)
															#line 1279 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp"
			{
															#line 315 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
				TraceEvent(SevWarnAlways, "TestFailure") .detail("Reason", "Rate below desired rate") .detail("File", __FILE__) .detail( "Details", format("%.2f", self->transactions.getMetric().value() / (self->transactionsPerSecond * self->testDuration))) .detail("TransactionsAchieved", self->transactions.getMetric().value()) .detail("MinTransactionsExpected", self->testDuration * self->minExpectedTransactionsPerSecond) .detail("TransactionGoal", self->transactionsPerSecond * self->testDuration);
															#line 325 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
				ok = false;
															#line 1285 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp"
			}
															#line 327 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
			if (!self->clientId)
															#line 1289 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp"
			{
															#line 329 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
				tr = Transaction(cx);
															#line 330 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
				retryCount = 0;
															#line 331 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
				;
															#line 1297 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CycleCheckActorState();
		static_cast<CycleCheckActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 352 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		if (!self->unseedCheck)
															#line 1325 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp"
		{
															#line 353 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
			ASSERT(noUnseed);
															#line 1329 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp"
		}
															#line 355 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		if (!static_cast<CycleCheckActor*>(this)->SAV<bool>::futures) { (void)(ok); this->~CycleCheckActorState(); static_cast<CycleCheckActor*>(this)->destroy(); return 0; }
															#line 1333 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp"
		new (&static_cast<CycleCheckActor*>(this)->SAV< bool >::value()) bool(std::move(ok)); // state_var_RVO
		this->~CycleCheckActorState();
		static_cast<CycleCheckActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 333 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
			self->setAuthToken(tr);
															#line 334 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
			StrictFuture<Version> __when_expr_0 = tr.getReadVersion();
															#line 334 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
			if (static_cast<CycleCheckActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1363 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CycleCheckActor*>(this)->actor_wait_state = 1;
															#line 334 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CycleCheckActor, 0, Version >*>(static_cast<CycleCheckActor*>(this)));
															#line 1368 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 341 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
			retryCount++;
															#line 342 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
			TraceEvent(retryCount > 20 ? SevWarnAlways : SevWarn, "CycleCheckError").error(e);
															#line 343 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
			if (g_network->isSimulated() && retryCount > 50)
															#line 1407 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp"
			{
															#line 344 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
				CODE_PROBE(true, "Cycle check enable speedUpSimulation because too many transaction_too_old()");
															#line 346 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
				g_simulator->speedUpSimulation = true;
															#line 1413 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp"
			}
															#line 348 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 348 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
			if (static_cast<CycleCheckActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1419 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<CycleCheckActor*>(this)->actor_wait_state = 3;
															#line 348 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CycleCheckActor, 2, Void >*>(static_cast<CycleCheckActor*>(this)));
															#line 1424 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 335 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		StrictFuture<RangeResult> __when_expr_1 = tr.getRange(firstGreaterOrEqual(doubleToTestKey(0.0, self->keyPrefix)), firstGreaterOrEqual(doubleToTestKey(1.0, self->keyPrefix)), self->nodeCount + 1);
															#line 335 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		if (static_cast<CycleCheckActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1441 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<CycleCheckActor*>(this)->actor_wait_state = 2;
															#line 335 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CycleCheckActor, 1, RangeResult >*>(static_cast<CycleCheckActor*>(this)));
															#line 1446 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Version const& __v,int loopDepth) 
	{
															#line 334 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		v = __v;
															#line 1455 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Version && __v,int loopDepth) 
	{
		v = std::move(__v);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CycleCheckActor*>(this)->actor_wait_state > 0) static_cast<CycleCheckActor*>(this)->actor_wait_state = 0;
		static_cast<CycleCheckActor*>(this)->ActorCallback< CycleCheckActor, 0, Version >::remove();

	}
	void a_callback_fire(ActorCallback< CycleCheckActor, 0, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("cycleCheck", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CycleCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cycleCheck", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CycleCheckActor, 0, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("cycleCheck", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CycleCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cycleCheck", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CycleCheckActor, 0, Version >*,Error err) 
	{
		fdb_probe_actor_enter("cycleCheck", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CycleCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cycleCheck", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(RangeResult const& data,int loopDepth) 
	{
															#line 338 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		ok = self->cycleCheckData(data, v) && ok;
															#line 1534 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont3(RangeResult && data,int loopDepth) 
	{
															#line 338 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		ok = self->cycleCheckData(data, v) && ok;
															#line 1543 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(RangeResult const& data,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(data, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(RangeResult && data,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(data), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CycleCheckActor*>(this)->actor_wait_state > 0) static_cast<CycleCheckActor*>(this)->actor_wait_state = 0;
		static_cast<CycleCheckActor*>(this)->ActorCallback< CycleCheckActor, 1, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< CycleCheckActor, 1, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("cycleCheck", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CycleCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cycleCheck", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CycleCheckActor, 1, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("cycleCheck", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CycleCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cycleCheck", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CycleCheckActor, 1, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("cycleCheck", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CycleCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cycleCheck", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CycleCheckActor*>(this)->actor_wait_state > 0) static_cast<CycleCheckActor*>(this)->actor_wait_state = 0;
		static_cast<CycleCheckActor*>(this)->ActorCallback< CycleCheckActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CycleCheckActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("cycleCheck", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CycleCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cycleCheck", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CycleCheckActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("cycleCheck", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CycleCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cycleCheck", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CycleCheckActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("cycleCheck", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CycleCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cycleCheck", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 313 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
	Database cx;
															#line 313 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
	CycleWorkload* self;
															#line 313 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
	bool ok;
															#line 329 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
	Transaction tr;
															#line 330 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
	int retryCount;
															#line 334 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
	Version v;
															#line 1722 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp"
};
// This generated class is to be used only via cycleCheck()
															#line 313 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
class CycleCheckActor final : public Actor<bool>, public ActorCallback< CycleCheckActor, 0, Version >, public ActorCallback< CycleCheckActor, 1, RangeResult >, public ActorCallback< CycleCheckActor, 2, Void >, public FastAllocated<CycleCheckActor>, public CycleCheckActorState<CycleCheckActor> {
															#line 1727 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp"
public:
	using FastAllocated<CycleCheckActor>::operator new;
	using FastAllocated<CycleCheckActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3109784221072526080UL, 12167460577730086144UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CycleCheckActor, 0, Version >;
friend struct ActorCallback< CycleCheckActor, 1, RangeResult >;
friend struct ActorCallback< CycleCheckActor, 2, Void >;
															#line 313 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
	CycleCheckActor(Database const& cx,CycleWorkload* const& self,bool const& ok) 
															#line 1746 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp"
		 : Actor<bool>(),
		   CycleCheckActorState<CycleCheckActor>(cx, self, ok),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("cycleCheck", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3005189881623422208UL, 7841844818168212480UL);
		ActorExecutionContextHelper __helper(static_cast<CycleCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("cycleCheck");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("cycleCheck", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CycleCheckActor, 0, Version >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CycleCheckActor, 1, RangeResult >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CycleCheckActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 313 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
[[nodiscard]] Future<bool> cycleCheck( Database const& cx, CycleWorkload* const& self, bool const& ok ) {
															#line 313 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
	return Future<bool>(new CycleCheckActor(cx, self, ok));
															#line 1780 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp"
}

#line 357 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
};

															#line 1786 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp"
namespace {
// This generated class is to be used only via prepareToken()
															#line 359 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
template <class PrepareTokenActor>
															#line 359 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
class PrepareTokenActorState {
															#line 1793 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp"
public:
															#line 359 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
	PrepareTokenActorState(Database const& cx,CycleWorkload<true>* const& self) 
															#line 359 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
															#line 359 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		 : cx(cx),
															#line 359 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		   self(self)
															#line 1802 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp"
	{
		fdb_probe_actor_create("prepareToken", reinterpret_cast<unsigned long>(this));

	}
	~PrepareTokenActorState() 
	{
		fdb_probe_actor_destroy("prepareToken", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 360 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
			cx->defaultTenant = self->tenant;
															#line 361 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
			StrictFuture<int64_t> __when_expr_0 = cx->lookupTenant(self->tenant);
															#line 361 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
			if (static_cast<PrepareTokenActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1821 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<PrepareTokenActor*>(this)->actor_wait_state = 1;
															#line 361 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PrepareTokenActor, 0, int64_t >*>(static_cast<PrepareTokenActor*>(this)));
															#line 1826 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PrepareTokenActorState();
		static_cast<PrepareTokenActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int64_t const& tenantId,int loopDepth) 
	{
															#line 362 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		self->tenantId = tenantId;
															#line 363 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		ASSERT_NE(self->tenantId, TenantInfo::INVALID_TENANT);
															#line 365 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		self->signedToken = g_simulator->makeToken(self->tenantId, uint64_t(std::lround(self->getCheckTimeout())) + uint64_t(std::lround(self->testDuration)) + 100);
															#line 368 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		if (!static_cast<PrepareTokenActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PrepareTokenActorState(); static_cast<PrepareTokenActor*>(this)->destroy(); return 0; }
															#line 1855 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp"
		new (&static_cast<PrepareTokenActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PrepareTokenActorState();
		static_cast<PrepareTokenActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(int64_t && tenantId,int loopDepth) 
	{
															#line 362 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		self->tenantId = tenantId;
															#line 363 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		ASSERT_NE(self->tenantId, TenantInfo::INVALID_TENANT);
															#line 365 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		self->signedToken = g_simulator->makeToken(self->tenantId, uint64_t(std::lround(self->getCheckTimeout())) + uint64_t(std::lround(self->testDuration)) + 100);
															#line 368 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
		if (!static_cast<PrepareTokenActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PrepareTokenActorState(); static_cast<PrepareTokenActor*>(this)->destroy(); return 0; }
															#line 1873 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp"
		new (&static_cast<PrepareTokenActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PrepareTokenActorState();
		static_cast<PrepareTokenActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(int64_t const& tenantId,int loopDepth) 
	{
		loopDepth = a_body1cont1(tenantId, loopDepth);

		return loopDepth;
	}
	int a_body1when1(int64_t && tenantId,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(tenantId), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PrepareTokenActor*>(this)->actor_wait_state > 0) static_cast<PrepareTokenActor*>(this)->actor_wait_state = 0;
		static_cast<PrepareTokenActor*>(this)->ActorCallback< PrepareTokenActor, 0, int64_t >::remove();

	}
	void a_callback_fire(ActorCallback< PrepareTokenActor, 0, int64_t >*,int64_t const& value) 
	{
		fdb_probe_actor_enter("prepareToken", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PrepareTokenActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("prepareToken", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PrepareTokenActor, 0, int64_t >*,int64_t && value) 
	{
		fdb_probe_actor_enter("prepareToken", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PrepareTokenActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("prepareToken", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PrepareTokenActor, 0, int64_t >*,Error err) 
	{
		fdb_probe_actor_enter("prepareToken", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PrepareTokenActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("prepareToken", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 359 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
	Database cx;
															#line 359 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
	CycleWorkload<true>* self;
															#line 1960 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp"
};
// This generated class is to be used only via prepareToken()
															#line 359 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
class PrepareTokenActor final : public Actor<Void>, public ActorCallback< PrepareTokenActor, 0, int64_t >, public FastAllocated<PrepareTokenActor>, public PrepareTokenActorState<PrepareTokenActor> {
															#line 1965 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp"
public:
	using FastAllocated<PrepareTokenActor>::operator new;
	using FastAllocated<PrepareTokenActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15844575848154437888UL, 18130025086296355840UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PrepareTokenActor, 0, int64_t >;
															#line 359 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
	PrepareTokenActor(Database const& cx,CycleWorkload<true>* const& self) 
															#line 1982 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp"
		 : Actor<Void>(),
		   PrepareTokenActorState<PrepareTokenActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("prepareToken", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14604907130122892288UL, 16574658246375810048UL);
		ActorExecutionContextHelper __helper(static_cast<PrepareTokenActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("prepareToken");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("prepareToken", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PrepareTokenActor, 0, int64_t >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 359 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
[[nodiscard]] Future<Void> prepareToken( Database const& cx, CycleWorkload<true>* const& self ) {
															#line 359 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"
	return Future<Void>(new PrepareTokenActor(cx, self));
															#line 2015 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Cycle.actor.g.cpp"
}

#line 370 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/workloads/Cycle.actor.cpp"

WorkloadFactory<CycleWorkload<false>> CycleWorkloadFactory(UntrustedMode::False);
WorkloadFactory<CycleWorkload<true>> TenantCycleWorkloadFactory(UntrustedMode::True);
