#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
/*
 * CommitProxyServer.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <algorithm>
#include <string_view>
#include <tuple>
#include <variant>

#include "fdbclient/AccumulativeChecksum.h"
#include "fdbclient/Atomic.h"
#include "fdbclient/BackupAgent.actor.h"
#include "fdbclient/BlobCipher.h"
#include "fdbclient/BuildIdempotencyIdMutations.h"
#include "fdbclient/CommitTransaction.h"
#include "fdbclient/DatabaseContext.h"
#include "fdbclient/FDBTypes.h"
#include "fdbclient/IdempotencyId.actor.h"
#include "fdbclient/Knobs.h"
#include "fdbclient/CommitProxyInterface.h"
#include "fdbclient/NativeAPI.actor.h"
#include "fdbclient/SystemData.h"
#include "fdbclient/Tenant.h"
#include "fdbclient/TenantManagement.actor.h"
#include "fdbclient/Tracing.h"
#include "fdbclient/TransactionLineage.h"
#include "fdbrpc/TenantInfo.h"
#include "fdbrpc/sim_validation.h"
#include "fdbserver/AccumulativeChecksumUtil.h"
#include "fdbserver/ApplyMetadataMutation.h"
#include "fdbserver/ConflictSet.h"
#include "fdbserver/DataDistributorInterface.h"
#include "fdbserver/FDBExecHelper.actor.h"
#include "fdbclient/GetEncryptCipherKeys.h"
#include "fdbserver/IKeyValueStore.h"
#include "fdbserver/Knobs.h"
#include "fdbserver/LogSystem.h"
#include "fdbserver/LogSystemDiskQueueAdapter.h"
#include "fdbserver/MasterInterface.h"
#include "fdbserver/MutationTracking.h"
#include "fdbserver/ProxyCommitData.actor.h"
#include "fdbserver/RatekeeperInterface.h"
#include "fdbserver/RecoveryState.h"
#include "fdbserver/RestoreUtil.h"
#include "fdbserver/ServerDBInfo.actor.h"
#include "fdbserver/WaitFailure.h"
#include "fdbserver/WorkerInterface.actor.h"
#include "flow/ActorCollection.h"
#include "flow/CodeProbe.h"
#include "flow/EncryptUtils.h"
#include "flow/Error.h"
#include "flow/IRandom.h"
#include "flow/Knobs.h"
#include "flow/Trace.h"
#include "flow/network.h"

#include "flow/actorcompiler.h" // This must be the last #include.

using WriteMutationRefVar = std::variant<MutationRef, VectorRef<MutationRef>>;

															#line 79 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
namespace {
// This generated class is to be used only via broadcastTxnRequest()
															#line 77 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
template <class BroadcastTxnRequestActor>
															#line 77 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class BroadcastTxnRequestActorState {
															#line 86 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
public:
															#line 77 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	BroadcastTxnRequestActorState(TxnStateRequest const& req,int const& sendAmount,bool const& sendReply) 
															#line 77 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
															#line 77 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		 : req(req),
															#line 77 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   sendAmount(sendAmount),
															#line 77 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   sendReply(sendReply),
															#line 78 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   reply(req.reply)
															#line 99 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
	{
		fdb_probe_actor_create("broadcastTxnRequest", reinterpret_cast<unsigned long>(this));

	}
	~BroadcastTxnRequestActorState() 
	{
		fdb_probe_actor_destroy("broadcastTxnRequest", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 79 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			resetReply(req);
															#line 80 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			std::vector<Future<Void>> replies;
															#line 81 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			int currentStream = 0;
															#line 82 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			std::vector<Endpoint> broadcastEndpoints = req.broadcastInfo;
															#line 83 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			for(int i = 0;i < sendAmount && currentStream < broadcastEndpoints.size();i++) {
															#line 84 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				std::vector<Endpoint> endpoints;
															#line 85 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				RequestStream<TxnStateRequest> cur(broadcastEndpoints[currentStream++]);
															#line 86 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				for(;currentStream < broadcastEndpoints.size() * (i + 1) / sendAmount;) {
															#line 87 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					endpoints.push_back(broadcastEndpoints[currentStream++]);
															#line 130 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
				}
															#line 89 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				req.broadcastInfo = endpoints;
															#line 90 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				replies.push_back(brokenPromiseToNever(cur.getReply(req)));
															#line 91 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				resetReply(req);
															#line 138 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			}
															#line 93 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			StrictFuture<Void> __when_expr_0 = waitForAll(replies);
															#line 93 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (static_cast<BroadcastTxnRequestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 144 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<BroadcastTxnRequestActor*>(this)->actor_wait_state = 1;
															#line 93 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< BroadcastTxnRequestActor, 0, Void >*>(static_cast<BroadcastTxnRequestActor*>(this)));
															#line 149 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~BroadcastTxnRequestActorState();
		static_cast<BroadcastTxnRequestActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 94 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (sendReply)
															#line 172 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 95 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			reply.send(Void());
															#line 176 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		}
															#line 97 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!static_cast<BroadcastTxnRequestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~BroadcastTxnRequestActorState(); static_cast<BroadcastTxnRequestActor*>(this)->destroy(); return 0; }
															#line 180 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		new (&static_cast<BroadcastTxnRequestActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~BroadcastTxnRequestActorState();
		static_cast<BroadcastTxnRequestActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 94 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (sendReply)
															#line 192 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 95 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			reply.send(Void());
															#line 196 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		}
															#line 97 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!static_cast<BroadcastTxnRequestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~BroadcastTxnRequestActorState(); static_cast<BroadcastTxnRequestActor*>(this)->destroy(); return 0; }
															#line 200 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		new (&static_cast<BroadcastTxnRequestActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~BroadcastTxnRequestActorState();
		static_cast<BroadcastTxnRequestActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<BroadcastTxnRequestActor*>(this)->actor_wait_state > 0) static_cast<BroadcastTxnRequestActor*>(this)->actor_wait_state = 0;
		static_cast<BroadcastTxnRequestActor*>(this)->ActorCallback< BroadcastTxnRequestActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BroadcastTxnRequestActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("broadcastTxnRequest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BroadcastTxnRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("broadcastTxnRequest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< BroadcastTxnRequestActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("broadcastTxnRequest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BroadcastTxnRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("broadcastTxnRequest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< BroadcastTxnRequestActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("broadcastTxnRequest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BroadcastTxnRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("broadcastTxnRequest", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 77 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	TxnStateRequest req;
															#line 77 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	int sendAmount;
															#line 77 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	bool sendReply;
															#line 78 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ReplyPromise<Void> reply;
															#line 291 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
};
// This generated class is to be used only via broadcastTxnRequest()
															#line 77 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class BroadcastTxnRequestActor final : public Actor<Void>, public ActorCallback< BroadcastTxnRequestActor, 0, Void >, public FastAllocated<BroadcastTxnRequestActor>, public BroadcastTxnRequestActorState<BroadcastTxnRequestActor> {
															#line 296 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
public:
	using FastAllocated<BroadcastTxnRequestActor>::operator new;
	using FastAllocated<BroadcastTxnRequestActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16348650866370899712UL, 4382539798826444032UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< BroadcastTxnRequestActor, 0, Void >;
															#line 77 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	BroadcastTxnRequestActor(TxnStateRequest const& req,int const& sendAmount,bool const& sendReply) 
															#line 313 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		 : Actor<Void>(),
		   BroadcastTxnRequestActorState<BroadcastTxnRequestActor>(req, sendAmount, sendReply),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("broadcastTxnRequest", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18432169453488638208UL, 15272042735295047168UL);
		ActorExecutionContextHelper __helper(static_cast<BroadcastTxnRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("broadcastTxnRequest");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("broadcastTxnRequest", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< BroadcastTxnRequestActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 77 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
[[nodiscard]] Future<Void> broadcastTxnRequest( TxnStateRequest const& req, int const& sendAmount, bool const& sendReply ) {
															#line 77 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	return Future<Void>(new BroadcastTxnRequestActor(req, sendAmount, sendReply));
															#line 346 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
}

#line 99 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"

															#line 351 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
namespace {
// This generated class is to be used only via discardCommit()
															#line 100 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
template <class DiscardCommitActor>
															#line 100 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class DiscardCommitActorState {
															#line 358 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
public:
															#line 100 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	DiscardCommitActorState(UID const& id,Future<LogSystemDiskQueueAdapter::CommitMessage> const& fcm,Future<Void> const& dummyCommitState) 
															#line 100 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
															#line 100 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		 : id(id),
															#line 100 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   fcm(fcm),
															#line 100 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   dummyCommitState(dummyCommitState)
															#line 369 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
	{
		fdb_probe_actor_create("discardCommit", reinterpret_cast<unsigned long>(this));

	}
	~DiscardCommitActorState() 
	{
		fdb_probe_actor_destroy("discardCommit", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 101 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			ASSERT(!dummyCommitState.isReady());
															#line 102 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			StrictFuture<LogSystemDiskQueueAdapter::CommitMessage> __when_expr_0 = fcm;
															#line 102 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
															#line 388 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			static_cast<DiscardCommitActor*>(this)->actor_wait_state = 1;
															#line 102 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DiscardCommitActor, 0, LogSystemDiskQueueAdapter::CommitMessage >*>(static_cast<DiscardCommitActor*>(this)));
															#line 392 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		delete static_cast<DiscardCommitActor*>(this);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(LogSystemDiskQueueAdapter::CommitMessage const& cm,int loopDepth) 
	{
															#line 103 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		TraceEvent("Discarding", id).detail("Count", cm.messages.size());
															#line 104 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		cm.acknowledge.send(Void());
															#line 105 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		ASSERT(dummyCommitState.isReady());
															#line 418 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(LogSystemDiskQueueAdapter::CommitMessage && cm,int loopDepth) 
	{
															#line 103 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		TraceEvent("Discarding", id).detail("Count", cm.messages.size());
															#line 104 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		cm.acknowledge.send(Void());
															#line 105 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		ASSERT(dummyCommitState.isReady());
															#line 431 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1when1(LogSystemDiskQueueAdapter::CommitMessage const& cm,int loopDepth) 
	{
		loopDepth = a_body1cont1(cm, loopDepth);

		return loopDepth;
	}
	int a_body1when1(LogSystemDiskQueueAdapter::CommitMessage && cm,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(cm), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DiscardCommitActor*>(this)->actor_wait_state > 0) static_cast<DiscardCommitActor*>(this)->actor_wait_state = 0;
		static_cast<DiscardCommitActor*>(this)->ActorCallback< DiscardCommitActor, 0, LogSystemDiskQueueAdapter::CommitMessage >::remove();

	}
	void a_callback_fire(ActorCallback< DiscardCommitActor, 0, LogSystemDiskQueueAdapter::CommitMessage >*,LogSystemDiskQueueAdapter::CommitMessage const& value) 
	{
		fdb_probe_actor_enter("discardCommit", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DiscardCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("discardCommit", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DiscardCommitActor, 0, LogSystemDiskQueueAdapter::CommitMessage >*,LogSystemDiskQueueAdapter::CommitMessage && value) 
	{
		fdb_probe_actor_enter("discardCommit", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DiscardCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("discardCommit", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DiscardCommitActor, 0, LogSystemDiskQueueAdapter::CommitMessage >*,Error err) 
	{
		fdb_probe_actor_enter("discardCommit", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DiscardCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("discardCommit", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 100 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		delete static_cast<DiscardCommitActor*>(this);
															#line 515 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		return 0;

		return loopDepth;
	}
															#line 100 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	UID id;
															#line 100 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Future<LogSystemDiskQueueAdapter::CommitMessage> fcm;
															#line 100 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Future<Void> dummyCommitState;
															#line 526 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
};
// This generated class is to be used only via discardCommit()
															#line 100 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class DiscardCommitActor final : public Actor<void>, public ActorCallback< DiscardCommitActor, 0, LogSystemDiskQueueAdapter::CommitMessage >, public FastAllocated<DiscardCommitActor>, public DiscardCommitActorState<DiscardCommitActor> {
															#line 531 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
public:
	using FastAllocated<DiscardCommitActor>::operator new;
	using FastAllocated<DiscardCommitActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5384538275240278528UL, 4578135642482706432UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() {{
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<void>*>(this)->~Actor();
        operator delete(this);
    }}
#pragma clang diagnostic pop
friend struct ActorCallback< DiscardCommitActor, 0, LogSystemDiskQueueAdapter::CommitMessage >;
															#line 100 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	DiscardCommitActor(UID const& id,Future<LogSystemDiskQueueAdapter::CommitMessage> const& fcm,Future<Void> const& dummyCommitState) 
															#line 548 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		 : Actor<void>(),
		   DiscardCommitActorState<DiscardCommitActor>(id, fcm, dummyCommitState),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("discardCommit", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7339418273539287808UL, 9304446022786112512UL);
		ActorExecutionContextHelper __helper(static_cast<DiscardCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("discardCommit");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("discardCommit", reinterpret_cast<unsigned long>(this), -1);

	}
};
} // namespace
															#line 100 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
void discardCommit( UID const& id, Future<LogSystemDiskQueueAdapter::CommitMessage> const& fcm, Future<Void> const& dummyCommitState ) {
															#line 100 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	new DiscardCommitActor(id, fcm, dummyCommitState);
															#line 572 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
}

#line 107 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"

struct ResolutionRequestBuilder {
	const ProxyCommitData* self;

	// One request per resolver.
	std::vector<ResolveTransactionBatchRequest> requests;

	// Txn i to resolvers that have i'th data sent
	std::vector<std::vector<int>> transactionResolverMap;
	std::vector<CommitTransactionRef*> outTr;

	// Used to report conflicting keys, the format is
	// [CommitTransactionRef_Index][Resolver_Index][Read_Conflict_Range_Index_on_Resolver]
	// -> read_conflict_range's original index in the commitTransactionRef
	std::vector<std::vector<std::vector<int>>> txReadConflictRangeIndexMap;

	ResolutionRequestBuilder(ProxyCommitData* self,
	                         Version version,
	                         Version prevVersion,
	                         Version lastReceivedVersion,
	                         Version lastShardMove,
	                         Span& parentSpan)
	  : self(self), requests(self->resolvers.size()) {
		for (auto& req : requests) {
			req.spanContext = parentSpan.context;
			req.prevVersion = prevVersion;
			req.version = version;
			req.lastReceivedVersion = lastReceivedVersion;
			req.lastShardMove = lastShardMove;
		}
	}

	CommitTransactionRef& getOutTransaction(int resolver, Version read_snapshot) {
		CommitTransactionRef*& out = outTr[resolver];
		if (!out) {
			ResolveTransactionBatchRequest& request = requests[resolver];
			request.transactions.resize(request.arena, request.transactions.size() + 1);
			out = &request.transactions.back();
			out->read_snapshot = read_snapshot;
		}
		return *out;
	}

	// Returns a read conflict index map: [resolver_index][read_conflict_range_index_on_the_resolver]
	// -> read_conflict_range's original index
	std::vector<std::vector<int>> addReadConflictRanges(CommitTransactionRef& trIn) {
		std::vector<std::vector<int>> rCRIndexMap(requests.size());
		for (int idx = 0; idx < trIn.read_conflict_ranges.size(); ++idx) {
			const auto& r = trIn.read_conflict_ranges[idx];
			auto ranges = self->keyResolvers.intersectingRanges(r);
			std::vector<int> resolvers;
			resolvers.reserve(self->resolvers.size());
			// O(1) de-dup keyed by resolver id (deterministic)
			std::vector<unsigned char> seen(self->resolvers.size(), 0);
			for (auto& ir : ranges) {
				auto& version_resolver = ir.value();
				for (int i = version_resolver.size() - 1; i >= 0; i--) {
					const int resolver_id = version_resolver[i].second;
					if (!seen[resolver_id]) {
						seen[resolver_id] = 1;
						resolvers.push_back(resolver_id);
					}
					if (version_resolver[i].first < trIn.read_snapshot)
						break;
				}
			}
			if (SERVER_KNOBS->PROXY_USE_RESOLVER_PRIVATE_MUTATIONS && systemKeys.intersects(r)) {
				// All resolvers are eligible; skip per-id de-dup and just fill 0..N-1.
				resolvers.clear();
				for (int k = 0; k < self->resolvers.size(); ++k) {
					resolvers.push_back(k);
				}
			}
			ASSERT(resolvers.size());
			for (int resolver : resolvers) {
				getOutTransaction(resolver, trIn.read_snapshot)
				    .read_conflict_ranges.push_back(requests[resolver].arena, r);
				rCRIndexMap[resolver].push_back(idx);
			}
		}
		return rCRIndexMap;
	}

	void addWriteConflictRanges(CommitTransactionRef& trIn) {
		for (auto& r : trIn.write_conflict_ranges) {
			auto ranges = self->keyResolvers.intersectingRanges(r);
			std::vector<int> resolvers;
			resolvers.reserve(self->resolvers.size());
			std::vector<unsigned char> seen(self->resolvers.size(), 0);
			for (auto& ir : ranges) {
				auto& version_resolver = ir.value();
				if (!version_resolver.empty()) {
					const int resolver_id = version_resolver.back().second;
					if (!seen[resolver_id]) {
						seen[resolver_id] = 1;
						resolvers.push_back(resolver_id);
					}
				}
			}
			if (SERVER_KNOBS->PROXY_USE_RESOLVER_PRIVATE_MUTATIONS && systemKeys.intersects(r)) {
				// All resolvers are eligible.
				resolvers.clear();
				for (int k = 0; k < self->resolvers.size(); ++k) {
					resolvers.push_back(k);
				}
			}
			ASSERT(resolvers.size());
			for (int resolver : resolvers)
				getOutTransaction(resolver, trIn.read_snapshot)
				    .write_conflict_ranges.push_back(requests[resolver].arena, r);
		}
	}

	void addTransaction(CommitTransactionRequest& trRequest, Version ver, int transactionNumberInBatch) {
		auto& trIn = trRequest.transaction;
		// SOMEDAY: There are a couple of unnecessary O( # resolvers ) steps here
		outTr.assign(requests.size(), nullptr);
		ASSERT(transactionNumberInBatch >= 0 && transactionNumberInBatch < 32768);

		bool isTXNStateTransaction = false;
		DisabledTraceEvent("AddTransaction", self->dbgid).detail("TenantMode", (int)self->getTenantMode());
		bool needParseTenantId = !trRequest.tenantInfo.hasTenant() && self->getTenantMode() == TenantMode::REQUIRED;
		VectorRef<int64_t> tenantIds;
		for (auto& m : trIn.mutations) {
			DEBUG_MUTATION("AddTr", ver, m, self->dbgid).detail("Idx", transactionNumberInBatch);
			if (m.type == MutationRef::SetVersionstampedKey) {
				transformVersionstampMutation(m, &MutationRef::param1, requests[0].version, transactionNumberInBatch);
				trIn.write_conflict_ranges.push_back(requests[0].arena, singleKeyRange(m.param1, requests[0].arena));
			} else if (m.type == MutationRef::SetVersionstampedValue) {
				transformVersionstampMutation(m, &MutationRef::param2, requests[0].version, transactionNumberInBatch);
			}
			if (isMetadataMutation(m)) {
				isTXNStateTransaction = true;
				auto& tr = getOutTransaction(0, trIn.read_snapshot);
				tr.mutations.push_back(requests[0].arena, m);
				tr.lock_aware = trRequest.isLockAware();
			} else if (needParseTenantId && !isSystemKey(m.param1) && isSingleKeyMutation((MutationRef::Type)m.type)) {
				tenantIds.push_back(requests[0].arena, TenantAPI::extractTenantIdFromMutation(m));
			}
		}
		if (isTXNStateTransaction && !trRequest.isLockAware()) {
			// This mitigates https://github.com/apple/foundationdb/issues/3647. Since this transaction is not lock
			// aware, if this transaction got a read version then \xff/dbLocked must not have been set at this
			// transaction's read snapshot. If that changes by commit time, then it won't commit on any proxy because of
			// a conflict. A client could set a read version manually so this isn't totally bulletproof.
			trIn.read_conflict_ranges.push_back(trRequest.arena, KeyRangeRef(databaseLockedKey, databaseLockedKeyEnd));
		}

		std::vector<std::vector<int>> rCRIndexMap = addReadConflictRanges(trIn);
		txReadConflictRangeIndexMap.push_back(std::move(rCRIndexMap));

		addWriteConflictRanges(trIn);

		if (isTXNStateTransaction) {
			for (int r = 0; r < requests.size(); r++) {
				int transactionNumberInRequest =
				    &getOutTransaction(r, trIn.read_snapshot) - requests[r].transactions.begin();
				requests[r].txnStateTransactions.push_back(requests[r].arena, transactionNumberInRequest);
			}
			// Note only Resolver 0 got the correct spanContext, which means
			// the reply from Resolver 0 has the right one back.
			auto& tr = getOutTransaction(0, trIn.read_snapshot);
			tr.spanContext = trRequest.spanContext;
			if (self->getTenantMode() == TenantMode::REQUIRED) {
				tr.tenantIds = tenantIds;
			}
		}

		std::vector<int> resolversUsed;
		for (int r = 0; r < outTr.size(); r++)
			if (outTr[r]) {
				resolversUsed.push_back(r);
				outTr[r]->report_conflicting_keys = trIn.report_conflicting_keys;
			}
		transactionResolverMap.emplace_back(std::move(resolversUsed));
	}
};

bool checkTenantNoWait(ProxyCommitData* commitData, int64_t tenant, const char* context, bool logOnFailure) {
	if (tenant != TenantInfo::INVALID_TENANT) {
		auto itr = commitData->tenantMap.find(tenant);
		if (itr == commitData->tenantMap.end()) {
			if (logOnFailure) {
				TraceEvent(SevWarn, "CommitProxyTenantNotFound", commitData->dbgid)
				    .detail("Tenant", tenant)
				    .detail("Context", context);
			}
			CODE_PROBE(true, "Commit proxy tenant not found");
			return false;
		}

		return true;
	}

	return true;
}

															#line 773 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
namespace {
// This generated class is to be used only via checkTenant()
															#line 304 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
template <class CheckTenantActor>
															#line 304 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class CheckTenantActorState {
															#line 780 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
public:
															#line 304 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	CheckTenantActorState(ProxyCommitData* const& commitData,int64_t const& tenant,Version const& minVersion,const char* const& context) 
															#line 304 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
															#line 304 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		 : commitData(commitData),
															#line 304 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   tenant(tenant),
															#line 304 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   minVersion(minVersion),
															#line 304 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   context(context)
															#line 793 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
	{
		fdb_probe_actor_create("checkTenant", reinterpret_cast<unsigned long>(this));

	}
	~CheckTenantActorState() 
	{
		fdb_probe_actor_destroy("checkTenant", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 305 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			;
															#line 808 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckTenantActorState();
		static_cast<CheckTenantActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 306 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		currentVersion = commitData->version.get();
															#line 307 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (checkTenantNoWait(commitData, tenant, context, currentVersion >= minVersion))
															#line 840 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 308 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (!static_cast<CheckTenantActor*>(this)->SAV<bool>::futures) { (void)(true); this->~CheckTenantActorState(); static_cast<CheckTenantActor*>(this)->destroy(); return 0; }
															#line 844 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			new (&static_cast<CheckTenantActor*>(this)->SAV< bool >::value()) bool(true);
			this->~CheckTenantActorState();
			static_cast<CheckTenantActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		else
		{
															#line 309 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (currentVersion >= minVersion)
															#line 854 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			{
															#line 310 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (!static_cast<CheckTenantActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckTenantActorState(); static_cast<CheckTenantActor*>(this)->destroy(); return 0; }
															#line 858 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
				new (&static_cast<CheckTenantActor*>(this)->SAV< bool >::value()) bool(false);
				this->~CheckTenantActorState();
				static_cast<CheckTenantActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 312 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				CODE_PROBE(true, "Commit proxy tenant not found waiting for min version");
															#line 313 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				StrictFuture<Void> __when_expr_0 = commitData->version.whenAtLeast(currentVersion + 1);
															#line 313 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (static_cast<CheckTenantActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 872 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
				static_cast<CheckTenantActor*>(this)->actor_wait_state = 1;
															#line 313 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckTenantActor, 0, Void >*>(static_cast<CheckTenantActor*>(this)));
															#line 877 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
				loopDepth = 0;
			}
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckTenantActor*>(this)->actor_wait_state > 0) static_cast<CheckTenantActor*>(this)->actor_wait_state = 0;
		static_cast<CheckTenantActor*>(this)->ActorCallback< CheckTenantActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckTenantActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkTenant", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckTenantActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkTenant", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckTenantActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkTenant", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 304 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ProxyCommitData* commitData;
															#line 304 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	int64_t tenant;
															#line 304 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Version minVersion;
															#line 304 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	const char* context;
															#line 306 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Version currentVersion;
															#line 993 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
};
// This generated class is to be used only via checkTenant()
															#line 304 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class CheckTenantActor final : public Actor<bool>, public ActorCallback< CheckTenantActor, 0, Void >, public FastAllocated<CheckTenantActor>, public CheckTenantActorState<CheckTenantActor> {
															#line 998 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
public:
	using FastAllocated<CheckTenantActor>::operator new;
	using FastAllocated<CheckTenantActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5939321001996518144UL, 13874799368557787392UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckTenantActor, 0, Void >;
															#line 304 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	CheckTenantActor(ProxyCommitData* const& commitData,int64_t const& tenant,Version const& minVersion,const char* const& context) 
															#line 1015 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		 : Actor<bool>(),
		   CheckTenantActorState<CheckTenantActor>(commitData, tenant, minVersion, context),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkTenant", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9395887922174162944UL, 17950773902749026048UL);
		ActorExecutionContextHelper __helper(static_cast<CheckTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkTenant");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkTenant", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckTenantActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 304 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
[[nodiscard]] Future<bool> checkTenant( ProxyCommitData* const& commitData, int64_t const& tenant, Version const& minVersion, const char* const& context ) {
															#line 304 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	return Future<bool>(new CheckTenantActor(commitData, tenant, minVersion, context));
															#line 1048 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
}

#line 317 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"

bool verifyTenantPrefix(ProxyCommitData* const commitData, const CommitTransactionRequest& req) {
	if (req.tenantInfo.hasTenant()) {
		KeyRef tenantPrefix = req.tenantInfo.prefix.get();
		for (auto& m : req.transaction.mutations) {
			if (m.param1 != metadataVersionKey) {
				if (!m.param1.startsWith(tenantPrefix)) {
					TraceEvent(SevWarnAlways, "TenantPrefixMismatch")
					    .detail("Tenant", req.tenantInfo.tenantId)
					    .detail("Prefix", tenantPrefix)
					    .detail("Key", m.param1);
					CODE_PROBE(true, "Committed mutation tenant prefix mismatch", probe::decoration::rare);
					return false;
				}

				if (m.type == MutationRef::ClearRange && !m.param2.startsWith(tenantPrefix)) {
					TraceEvent(SevWarnAlways, "TenantClearRangePrefixMismatch")
					    .suppressFor(60)
					    .detail("Tenant", req.tenantInfo.tenantId)
					    .detail("Prefix", tenantPrefix)
					    .detail("Key", m.param2);
					CODE_PROBE(true, "Committed mutation clear range prefix mismatch", probe::decoration::rare);
					return false;
				} else if (m.type == MutationRef::SetVersionstampedKey) {
					ASSERT(m.param1.size() >= 4);
					uint8_t* key = const_cast<uint8_t*>(m.param1.begin());
					int* offset = reinterpret_cast<int*>(&key[m.param1.size() - 4]);
					if (*offset < tenantPrefix.size()) {
						TraceEvent(SevWarnAlways, "TenantVersionstampInvalidOffset")
						    .suppressFor(60)
						    .detail("Tenant", req.tenantInfo.tenantId)
						    .detail("Prefix", tenantPrefix)
						    .detail("Key", m.param1)
						    .detail("Offset", *offset);
						CODE_PROBE(true,
						           "Committed mutation versionstamp offset inside tenant prefix",
						           probe::decoration::rare);
						return false;
					}
				}
			} else {
				CODE_PROBE(true, "Modifying metadata version key in tenant");
			}
		}

		for (auto& rc : req.transaction.read_conflict_ranges) {
			if (rc.begin != metadataVersionKey &&
			    (!rc.begin.startsWith(tenantPrefix) || !rc.end.startsWith(tenantPrefix))) {
				TraceEvent(SevWarnAlways, "TenantReadConflictPrefixMismatch")
				    .suppressFor(60)
				    .detail("Tenant", req.tenantInfo.tenantId)
				    .detail("Prefix", tenantPrefix)
				    .detail("BeginKey", rc.begin)
				    .detail("EndKey", rc.end);
				CODE_PROBE(true, "Committed mutation read conflict prefix mismatch", probe::decoration::rare);
				return false;
			}
		}

		for (auto& wc : req.transaction.write_conflict_ranges) {
			if (wc.begin != metadataVersionKey &&
			    (!wc.begin.startsWith(tenantPrefix) || !wc.end.startsWith(tenantPrefix))) {
				TraceEvent(SevWarnAlways, "TenantWriteConflictPrefixMismatch")
				    .suppressFor(60)
				    .detail("Tenant", req.tenantInfo.tenantId)
				    .detail("Prefix", tenantPrefix)
				    .detail("BeginKey", wc.begin)
				    .detail("EndKey", wc.end);
				CODE_PROBE(true, "Committed mutation write conflict prefix mismatch", probe::decoration::rare);
				return false;
			}
		}
	}

	return true;
}

															#line 1129 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
namespace {
// This generated class is to be used only via commitBatcher()
															#line 394 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
template <class CommitBatcherActor>
															#line 394 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class CommitBatcherActorState {
															#line 1136 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
public:
															#line 394 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	CommitBatcherActorState(ProxyCommitData* const& commitData,PromiseStream<std::pair<std::vector<CommitTransactionRequest>, int>> const& out,FutureStream<CommitTransactionRequest> const& in,int const& desiredBytes,int64_t const& memBytesLimit) 
															#line 394 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
															#line 394 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		 : commitData(commitData),
															#line 394 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   out(out),
															#line 394 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   in(in),
															#line 394 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   desiredBytes(desiredBytes),
															#line 394 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   memBytesLimit(memBytesLimit)
															#line 1151 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
	{
		fdb_probe_actor_create("commitBatcher", reinterpret_cast<unsigned long>(this));

	}
	~CommitBatcherActorState() 
	{
		fdb_probe_actor_destroy("commitBatcher", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 399 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delayJittered(commitData->commitBatchInterval, TaskPriority::ProxyCommitBatcher);
															#line 399 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (static_cast<CommitBatcherActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1168 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CommitBatcherActor*>(this)->actor_wait_state = 1;
															#line 399 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CommitBatcherActor, 0, Void >*>(static_cast<CommitBatcherActor*>(this)));
															#line 1173 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CommitBatcherActorState();
		static_cast<CommitBatcherActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 401 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		lastBatch = 0;
															#line 403 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		;
															#line 1198 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 401 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		lastBatch = 0;
															#line 403 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		;
															#line 1209 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CommitBatcherActor*>(this)->actor_wait_state > 0) static_cast<CommitBatcherActor*>(this)->actor_wait_state = 0;
		static_cast<CommitBatcherActor*>(this)->ActorCallback< CommitBatcherActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CommitBatcherActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("commitBatcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitBatcher", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CommitBatcherActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("commitBatcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitBatcher", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CommitBatcherActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("commitBatcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitBatcher", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 404 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		timeout = Future<Void>();
															#line 405 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		batch = std::vector<CommitTransactionRequest>();
															#line 406 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		batchBytes = 0;
															#line 410 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (SERVER_KNOBS->MAX_COMMIT_BATCH_INTERVAL <= 0)
															#line 1306 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 411 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			timeout = Never();
															#line 1310 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		}
		else
		{
															#line 413 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			timeout = delayJittered(SERVER_KNOBS->MAX_COMMIT_BATCH_INTERVAL, TaskPriority::ProxyCommitBatcher);
															#line 1316 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		}
															#line 416 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		;
															#line 1320 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
															#line 497 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		commitData->triggerCommit.set(false);
															#line 498 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		out.send({ std::move(batch), batchBytes });
															#line 499 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		lastBatch = now();
															#line 1333 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1(int loopDepth) 
	{
															#line 416 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!(!timeout.isReady() && !(batch.size() == SERVER_KNOBS->COMMIT_TRANSACTION_BATCH_COUNT_MAX || batchBytes >= desiredBytes)))
															#line 1349 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
			return a_body1cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 419 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		auto __when_expr_1 = in;
															#line 1355 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_1), FutureStream<CommitTransactionRequest>>::value || std::is_same<decltype(__when_expr_1), ThreadFutureStream<CommitTransactionRequest>>::value, "invalid type");
															#line 418 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<CommitBatcherActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 1359 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 2)); else return a_body1cont1loopBody1loopBody1when1(__when_expr_1.pop(), loopDepth); };
															#line 485 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_2 = timeout;
															#line 1363 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 2)); else return a_body1cont1loopBody1loopBody1when2(__when_expr_2.get(), loopDepth); };
															#line 486 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_3 = commitData->triggerCommit.onChange();
															#line 1367 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 2)); else return a_body1cont1loopBody1loopBody1when3(__when_expr_3.get(), loopDepth); };
		static_cast<CommitBatcherActor*>(this)->actor_wait_state = 2;
															#line 419 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorSingleCallback< CommitBatcherActor, 1, CommitTransactionRequest >*>(static_cast<CommitBatcherActor*>(this)));
															#line 485 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CommitBatcherActor, 2, Void >*>(static_cast<CommitBatcherActor*>(this)));
															#line 486 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CommitBatcherActor, 3, Void >*>(static_cast<CommitBatcherActor*>(this)));
															#line 1376 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1cont1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when1(CommitTransactionRequest const& req,int loopDepth) 
	{
															#line 421 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		int bytes = getBytes(req);
															#line 424 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (commitData->commitBatchesMemBytesCount + bytes > memBytesLimit)
															#line 1406 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 425 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			++commitData->stats.txnCommitErrors;
															#line 426 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			req.reply.sendError(commit_proxy_memory_limit_exceeded());
															#line 427 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			TraceEvent(SevWarnAlways, "ProxyCommitBatchMemoryThresholdExceeded") .suppressFor(60) .detail("MemBytesCount", commitData->commitBatchesMemBytesCount) .detail("MemLimit", memBytesLimit);
															#line 1414 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			return a_body1cont1loopBody1loopHead1(loopDepth); // continue
		}
															#line 434 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (bytes > FLOW_KNOBS->PACKET_WARNING)
															#line 1419 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 435 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			TraceEvent(SevWarn, "LargeTransaction") .suppressFor(1.0) .detail("Size", bytes) .detail("Client", req.reply.getEndpoint().getPrimaryAddress());
															#line 1423 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		}
															#line 441 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!verifyTenantPrefix(commitData, req))
															#line 1427 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 442 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			++commitData->stats.txnCommitErrors;
															#line 443 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			req.reply.sendError(illegal_tenant_access());
															#line 1433 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			return a_body1cont1loopBody1loopHead1(loopDepth); // continue
		}
															#line 447 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (SERVER_KNOBS->STORAGE_QUOTA_ENABLED && !req.bypassStorageQuota() && req.tenantInfo.hasTenant() && commitData->tenantsOverStorageQuota.contains(req.tenantInfo.tenantId))
															#line 1438 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 450 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			req.reply.sendError(storage_quota_exceeded());
															#line 1442 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			return a_body1cont1loopBody1loopHead1(loopDepth); // continue
		}
															#line 454 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		++commitData->stats.txnCommitIn;
															#line 455 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		commitData->stats.uniqueClients.insert(req.reply.getEndpoint().getPrimaryAddress());
															#line 457 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (req.debugID.present())
															#line 1451 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 458 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			g_traceBatch.addEvent("CommitDebug", req.debugID.get().first(), "CommitProxyServer.batcher");
															#line 1455 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		}
															#line 461 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!batch.size())
															#line 1459 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 462 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (now() - lastBatch > commitData->commitBatchInterval)
															#line 1463 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			{
															#line 463 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				timeout = delayJittered(SERVER_KNOBS->COMMIT_TRANSACTION_BATCH_INTERVAL_FROM_IDLE, TaskPriority::ProxyCommitBatcher);
															#line 1467 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			}
			else
			{
															#line 466 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				timeout = delayJittered(commitData->commitBatchInterval - (now() - lastBatch), TaskPriority::ProxyCommitBatcher);
															#line 1473 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			}
		}
															#line 471 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if ((batchBytes + bytes > CLIENT_KNOBS->TRANSACTION_SIZE_LIMIT || req.firstInBatch()) && batch.size())
															#line 1478 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 473 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			commitData->triggerCommit.set(false);
															#line 474 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			out.send({ std::move(batch), batchBytes });
															#line 475 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			lastBatch = now();
															#line 476 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			timeout = delayJittered(commitData->commitBatchInterval, TaskPriority::ProxyCommitBatcher);
															#line 477 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			batch.clear();
															#line 478 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			batchBytes = 0;
															#line 1492 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		}
															#line 481 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		batch.push_back(req);
															#line 482 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		batchBytes += bytes;
															#line 483 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		commitData->commitBatchesMemBytesCount += bytes;
															#line 1500 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when1(CommitTransactionRequest && req,int loopDepth) 
	{
															#line 421 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		int bytes = getBytes(req);
															#line 424 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (commitData->commitBatchesMemBytesCount + bytes > memBytesLimit)
															#line 1511 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 425 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			++commitData->stats.txnCommitErrors;
															#line 426 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			req.reply.sendError(commit_proxy_memory_limit_exceeded());
															#line 427 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			TraceEvent(SevWarnAlways, "ProxyCommitBatchMemoryThresholdExceeded") .suppressFor(60) .detail("MemBytesCount", commitData->commitBatchesMemBytesCount) .detail("MemLimit", memBytesLimit);
															#line 1519 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			return a_body1cont1loopBody1loopHead1(loopDepth); // continue
		}
															#line 434 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (bytes > FLOW_KNOBS->PACKET_WARNING)
															#line 1524 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 435 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			TraceEvent(SevWarn, "LargeTransaction") .suppressFor(1.0) .detail("Size", bytes) .detail("Client", req.reply.getEndpoint().getPrimaryAddress());
															#line 1528 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		}
															#line 441 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!verifyTenantPrefix(commitData, req))
															#line 1532 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 442 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			++commitData->stats.txnCommitErrors;
															#line 443 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			req.reply.sendError(illegal_tenant_access());
															#line 1538 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			return a_body1cont1loopBody1loopHead1(loopDepth); // continue
		}
															#line 447 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (SERVER_KNOBS->STORAGE_QUOTA_ENABLED && !req.bypassStorageQuota() && req.tenantInfo.hasTenant() && commitData->tenantsOverStorageQuota.contains(req.tenantInfo.tenantId))
															#line 1543 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 450 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			req.reply.sendError(storage_quota_exceeded());
															#line 1547 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			return a_body1cont1loopBody1loopHead1(loopDepth); // continue
		}
															#line 454 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		++commitData->stats.txnCommitIn;
															#line 455 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		commitData->stats.uniqueClients.insert(req.reply.getEndpoint().getPrimaryAddress());
															#line 457 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (req.debugID.present())
															#line 1556 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 458 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			g_traceBatch.addEvent("CommitDebug", req.debugID.get().first(), "CommitProxyServer.batcher");
															#line 1560 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		}
															#line 461 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!batch.size())
															#line 1564 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 462 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (now() - lastBatch > commitData->commitBatchInterval)
															#line 1568 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			{
															#line 463 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				timeout = delayJittered(SERVER_KNOBS->COMMIT_TRANSACTION_BATCH_INTERVAL_FROM_IDLE, TaskPriority::ProxyCommitBatcher);
															#line 1572 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			}
			else
			{
															#line 466 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				timeout = delayJittered(commitData->commitBatchInterval - (now() - lastBatch), TaskPriority::ProxyCommitBatcher);
															#line 1578 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			}
		}
															#line 471 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if ((batchBytes + bytes > CLIENT_KNOBS->TRANSACTION_SIZE_LIMIT || req.firstInBatch()) && batch.size())
															#line 1583 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 473 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			commitData->triggerCommit.set(false);
															#line 474 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			out.send({ std::move(batch), batchBytes });
															#line 475 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			lastBatch = now();
															#line 476 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			timeout = delayJittered(commitData->commitBatchInterval, TaskPriority::ProxyCommitBatcher);
															#line 477 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			batch.clear();
															#line 478 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			batchBytes = 0;
															#line 1597 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		}
															#line 481 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		batch.push_back(req);
															#line 482 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		batchBytes += bytes;
															#line 483 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		commitData->commitBatchesMemBytesCount += bytes;
															#line 1605 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when3(Void const& _,int loopDepth) 
	{
															#line 487 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		ASSERT(commitData->triggerCommit.get());
															#line 488 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		double commitTime = lastBatch + SERVER_KNOBS->COMMIT_TRIGGER_DELAY;
															#line 489 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (now() > commitTime)
															#line 1630 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
			return a_body1cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 493 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		timeout = timeout || delayJittered(commitTime - now(), TaskPriority::ProxyCommitBatcher);
															#line 1636 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when3(Void && _,int loopDepth) 
	{
															#line 487 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		ASSERT(commitData->triggerCommit.get());
															#line 488 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		double commitTime = lastBatch + SERVER_KNOBS->COMMIT_TRIGGER_DELAY;
															#line 489 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (now() > commitTime)
															#line 1649 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
			return a_body1cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 493 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		timeout = timeout || delayJittered(commitTime - now(), TaskPriority::ProxyCommitBatcher);
															#line 1655 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CommitBatcherActor*>(this)->actor_wait_state > 0) static_cast<CommitBatcherActor*>(this)->actor_wait_state = 0;
		static_cast<CommitBatcherActor*>(this)->ActorSingleCallback< CommitBatcherActor, 1, CommitTransactionRequest >::remove();
		static_cast<CommitBatcherActor*>(this)->ActorCallback< CommitBatcherActor, 2, Void >::remove();
		static_cast<CommitBatcherActor*>(this)->ActorCallback< CommitBatcherActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorSingleCallback< CommitBatcherActor, 1, CommitTransactionRequest >*,CommitTransactionRequest const& value) 
	{
		fdb_probe_actor_enter("commitBatcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitBatcher", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorSingleCallback< CommitBatcherActor, 1, CommitTransactionRequest >*,CommitTransactionRequest && value) 
	{
		fdb_probe_actor_enter("commitBatcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitBatcher", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorSingleCallback< CommitBatcherActor, 1, CommitTransactionRequest >*,Error err) 
	{
		fdb_probe_actor_enter("commitBatcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitBatcher", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CommitBatcherActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("commitBatcher", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitBatcher", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CommitBatcherActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("commitBatcher", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitBatcher", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CommitBatcherActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("commitBatcher", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitBatcher", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CommitBatcherActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("commitBatcher", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitBatcher", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< CommitBatcherActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("commitBatcher", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitBatcher", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< CommitBatcherActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("commitBatcher", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitBatcher", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 394 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ProxyCommitData* commitData;
															#line 394 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	PromiseStream<std::pair<std::vector<CommitTransactionRequest>, int>> out;
															#line 394 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	FutureStream<CommitTransactionRequest> in;
															#line 394 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	int desiredBytes;
															#line 394 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	int64_t memBytesLimit;
															#line 401 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	double lastBatch;
															#line 404 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Future<Void> timeout;
															#line 405 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	std::vector<CommitTransactionRequest> batch;
															#line 406 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	int batchBytes;
															#line 1857 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
};
// This generated class is to be used only via commitBatcher()
															#line 394 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class CommitBatcherActor final : public Actor<Void>, public ActorCallback< CommitBatcherActor, 0, Void >, public ActorSingleCallback< CommitBatcherActor, 1, CommitTransactionRequest >, public ActorCallback< CommitBatcherActor, 2, Void >, public ActorCallback< CommitBatcherActor, 3, Void >, public FastAllocated<CommitBatcherActor>, public CommitBatcherActorState<CommitBatcherActor> {
															#line 1862 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
public:
	using FastAllocated<CommitBatcherActor>::operator new;
	using FastAllocated<CommitBatcherActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13186947786330275584UL, 15400086685365765120UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CommitBatcherActor, 0, Void >;
friend struct ActorSingleCallback< CommitBatcherActor, 1, CommitTransactionRequest >;
friend struct ActorCallback< CommitBatcherActor, 2, Void >;
friend struct ActorCallback< CommitBatcherActor, 3, Void >;
															#line 394 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	CommitBatcherActor(ProxyCommitData* const& commitData,PromiseStream<std::pair<std::vector<CommitTransactionRequest>, int>> const& out,FutureStream<CommitTransactionRequest> const& in,int const& desiredBytes,int64_t const& memBytesLimit) 
															#line 1882 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		 : Actor<Void>(),
		   CommitBatcherActorState<CommitBatcherActor>(commitData, out, in, desiredBytes, memBytesLimit),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("commitBatcher", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16706688995745022464UL, 16424952413577766656UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("commitBatcher");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("commitBatcher", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CommitBatcherActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorSingleCallback< CommitBatcherActor, 1, CommitTransactionRequest >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 394 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
[[nodiscard]] Future<Void> commitBatcher( ProxyCommitData* const& commitData, PromiseStream<std::pair<std::vector<CommitTransactionRequest>, int>> const& out, FutureStream<CommitTransactionRequest> const& in, int const& desiredBytes, int64_t const& memBytesLimit ) {
															#line 394 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	return Future<Void>(new CommitBatcherActor(commitData, out, in, desiredBytes, memBytesLimit));
															#line 1916 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
}

#line 502 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"

void createWhitelistBinPathVec(const std::string& binPath, std::vector<Standalone<StringRef>>& binPathVec) {
	TraceEvent(SevDebug, "BinPathConverter").detail("Input", binPath);
	StringRef input(binPath);
	while (input != StringRef()) {
		StringRef token = input.eat(","_sr);
		if (token != StringRef()) {
			const uint8_t* ptr = token.begin();
			while (ptr != token.end() && *ptr == ' ') {
				ptr++;
			}
			if (ptr != token.end()) {
				Standalone<StringRef> newElement(token.substr(ptr - token.begin()));
				TraceEvent(SevDebug, "BinPathItem").detail("Element", newElement);
				binPathVec.push_back(newElement);
			}
		}
	}
	return;
}

bool isWhitelisted(const std::vector<Standalone<StringRef>>& binPathVec, StringRef binPath) {
	TraceEvent("BinPath").detail("Value", binPath);
	for (const auto& item : binPathVec) {
		TraceEvent("Element").detail("Value", item);
	}
	return std::find(binPathVec.begin(), binPathVec.end(), binPath) != binPathVec.end();
}

															#line 1949 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
namespace {
// This generated class is to be used only via addBackupMutations()
															#line 531 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
template <class AddBackupMutationsActor>
															#line 531 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class AddBackupMutationsActorState {
															#line 1956 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
public:
															#line 531 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	AddBackupMutationsActorState(ProxyCommitData* const& self,const std::map<Key, MutationListRef>* const& logRangeMutations,LogPushData* const& toCommit,Version const& commitVersion,double* const& computeDuration,double* const& computeStart) 
															#line 531 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
															#line 531 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		 : self(self),
															#line 531 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   logRangeMutations(logRangeMutations),
															#line 531 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   toCommit(toCommit),
															#line 531 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   commitVersion(commitVersion),
															#line 531 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   computeDuration(computeDuration),
															#line 531 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   computeStart(computeStart),
															#line 537 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   logRangeMutation(logRangeMutations->cbegin()),
															#line 538 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   version(commitVersion / CLIENT_KNOBS->LOG_RANGE_BLOCK_SIZE),
															#line 539 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   yieldBytes(0),
															#line 540 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   valueWriter(Unversioned())
															#line 1981 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
	{
		fdb_probe_actor_create("addBackupMutations", reinterpret_cast<unsigned long>(this));

	}
	~AddBackupMutationsActorState() 
	{
		fdb_probe_actor_destroy("addBackupMutations", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 542 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			toCommit->addTransactionInfo(SpanContext());
															#line 545 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			;
															#line 1998 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~AddBackupMutationsActorState();
		static_cast<AddBackupMutationsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 616 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!static_cast<AddBackupMutationsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~AddBackupMutationsActorState(); static_cast<AddBackupMutationsActor*>(this)->destroy(); return 0; }
															#line 2021 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		new (&static_cast<AddBackupMutationsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~AddBackupMutationsActorState();
		static_cast<AddBackupMutationsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 545 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!(logRangeMutation != logRangeMutations->cend()))
															#line 2040 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 548 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		valueWriter = BinaryWriter(IncludeVersion(ProtocolVersion::withBackupMutations()));
															#line 549 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		valueWriter << logRangeMutation->second.totalSize();
															#line 551 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		blobIter = logRangeMutation->second.blob_begin;
															#line 552 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		;
															#line 2052 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		loopDepth = a_body1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 566 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		Key val = valueWriter.toValue();
															#line 568 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		BinaryWriter wr(Unversioned());
															#line 571 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		wr.serializeBytes(logRangeMutation->first);
															#line 574 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		wr << (uint8_t)hashlittle(&version, sizeof(version), 0);
															#line 575 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		wr << bigEndian64(commitVersion);
															#line 577 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		uint32_t* partBuffer = nullptr;
															#line 579 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		for(int part = 0;part * CLIENT_KNOBS->MUTATION_BLOCK_SIZE < val.size();part++) {
															#line 581 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			MutationRef backupMutation;
															#line 582 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			backupMutation.type = MutationRef::SetValue;
															#line 585 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			backupMutation.param2 = getBackupValue(val, part);
															#line 586 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			Key key = getBackupKey(wr, &partBuffer, part);
															#line 587 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			backupMutation.param1 = key;
															#line 588 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			ASSERT(backupMutation.param1.startsWith( logRangeMutation->first));
															#line 591 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			auto& tags = self->tagsForKey(backupMutation.param1);
															#line 592 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			toCommit->addTags(tags);
															#line 594 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (self->acsBuilder != nullptr)
															#line 2104 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			{
															#line 595 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				updateMutationWithAcsAndAddMutationToAcsBuilder( self->acsBuilder, backupMutation, tags, getCommitProxyAccumulativeChecksumIndex(self->commitProxyIndex), self->epoch, commitVersion, self->dbgid);
															#line 2108 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			}
															#line 605 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			toCommit->writeTypedMessage(backupMutation);
															#line 2112 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		}
															#line 545 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		++logRangeMutation;
															#line 2116 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
															#line 552 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!(blobIter))
															#line 2132 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
			return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 553 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (yieldBytes > SERVER_KNOBS->DESIRED_TOTAL_BYTES)
															#line 2138 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 554 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			yieldBytes = 0;
															#line 555 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (g_network->check_yield(TaskPriority::ProxyCommitYield1))
															#line 2144 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			{
															#line 556 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				*computeDuration += g_network->timer_monotonic() - *computeStart;
															#line 557 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				StrictFuture<Void> __when_expr_0 = delay(0, TaskPriority::ProxyCommitYield1);
															#line 557 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (static_cast<AddBackupMutationsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 2152 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
				static_cast<AddBackupMutationsActor*>(this)->actor_wait_state = 1;
															#line 557 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< AddBackupMutationsActor, 0, Void >*>(static_cast<AddBackupMutationsActor*>(this)));
															#line 2157 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1loopBody1loopBody1cont3(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
															#line 561 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		valueWriter.serializeBytes(blobIter->data);
															#line 562 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		yieldBytes += blobIter->data.size();
															#line 563 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		blobIter = blobIter->next;
															#line 2193 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3(int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont4(Void const& _,int loopDepth) 
	{
															#line 558 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		*computeStart = g_network->timer_monotonic();
															#line 2208 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		loopDepth = a_body1loopBody1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont4(Void && _,int loopDepth) 
	{
															#line 558 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		*computeStart = g_network->timer_monotonic();
															#line 2217 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		loopDepth = a_body1loopBody1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<AddBackupMutationsActor*>(this)->actor_wait_state > 0) static_cast<AddBackupMutationsActor*>(this)->actor_wait_state = 0;
		static_cast<AddBackupMutationsActor*>(this)->ActorCallback< AddBackupMutationsActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AddBackupMutationsActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("addBackupMutations", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddBackupMutationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addBackupMutations", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< AddBackupMutationsActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("addBackupMutations", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddBackupMutationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addBackupMutations", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< AddBackupMutationsActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("addBackupMutations", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AddBackupMutationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addBackupMutations", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 531 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ProxyCommitData* self;
															#line 531 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	const std::map<Key, MutationListRef>* logRangeMutations;
															#line 531 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	LogPushData* toCommit;
															#line 531 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Version commitVersion;
															#line 531 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	double* computeDuration;
															#line 531 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	double* computeStart;
															#line 537 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	std::map<Key, MutationListRef>::const_iterator logRangeMutation;
															#line 538 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	int32_t version;
															#line 539 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	int yieldBytes;
															#line 540 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	BinaryWriter valueWriter;
															#line 551 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	MutationListRef::Blob* blobIter;
															#line 2319 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
};
// This generated class is to be used only via addBackupMutations()
															#line 531 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class AddBackupMutationsActor final : public Actor<Void>, public ActorCallback< AddBackupMutationsActor, 0, Void >, public FastAllocated<AddBackupMutationsActor>, public AddBackupMutationsActorState<AddBackupMutationsActor> {
															#line 2324 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
public:
	using FastAllocated<AddBackupMutationsActor>::operator new;
	using FastAllocated<AddBackupMutationsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10524005627297504000UL, 15369449013711744768UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< AddBackupMutationsActor, 0, Void >;
															#line 531 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	AddBackupMutationsActor(ProxyCommitData* const& self,const std::map<Key, MutationListRef>* const& logRangeMutations,LogPushData* const& toCommit,Version const& commitVersion,double* const& computeDuration,double* const& computeStart) 
															#line 2341 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		 : Actor<Void>(),
		   AddBackupMutationsActorState<AddBackupMutationsActor>(self, logRangeMutations, toCommit, commitVersion, computeDuration, computeStart),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("addBackupMutations", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11549401446348182528UL, 12220003075087083264UL);
		ActorExecutionContextHelper __helper(static_cast<AddBackupMutationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("addBackupMutations");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("addBackupMutations", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< AddBackupMutationsActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 531 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
[[nodiscard]] Future<Void> addBackupMutations( ProxyCommitData* const& self, const std::map<Key, MutationListRef>* const& logRangeMutations, LogPushData* const& toCommit, Version const& commitVersion, double* const& computeDuration, double* const& computeStart ) {
															#line 531 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	return Future<Void>(new AddBackupMutationsActor(self, logRangeMutations, toCommit, commitVersion, computeDuration, computeStart));
															#line 2374 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
}

#line 618 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"

															#line 2379 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
namespace {
// This generated class is to be used only via releaseResolvingAfter()
															#line 619 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
template <class ReleaseResolvingAfterActor>
															#line 619 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class ReleaseResolvingAfterActorState {
															#line 2386 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
public:
															#line 619 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ReleaseResolvingAfterActorState(ProxyCommitData* const& self,Future<Void> const& releaseDelay,int64_t const& localBatchNumber) 
															#line 619 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
															#line 619 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		 : self(self),
															#line 619 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   releaseDelay(releaseDelay),
															#line 619 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   localBatchNumber(localBatchNumber)
															#line 2397 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
	{
		fdb_probe_actor_create("releaseResolvingAfter", reinterpret_cast<unsigned long>(this));

	}
	~ReleaseResolvingAfterActorState() 
	{
		fdb_probe_actor_destroy("releaseResolvingAfter", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 620 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			StrictFuture<Void> __when_expr_0 = releaseDelay;
															#line 620 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (static_cast<ReleaseResolvingAfterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2414 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ReleaseResolvingAfterActor*>(this)->actor_wait_state = 1;
															#line 620 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ReleaseResolvingAfterActor, 0, Void >*>(static_cast<ReleaseResolvingAfterActor*>(this)));
															#line 2419 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ReleaseResolvingAfterActorState();
		static_cast<ReleaseResolvingAfterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 621 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		ASSERT(self->latestLocalCommitBatchResolving.get() == localBatchNumber - 1);
															#line 622 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->latestLocalCommitBatchResolving.set(localBatchNumber);
															#line 623 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!static_cast<ReleaseResolvingAfterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ReleaseResolvingAfterActorState(); static_cast<ReleaseResolvingAfterActor*>(this)->destroy(); return 0; }
															#line 2446 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		new (&static_cast<ReleaseResolvingAfterActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ReleaseResolvingAfterActorState();
		static_cast<ReleaseResolvingAfterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 621 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		ASSERT(self->latestLocalCommitBatchResolving.get() == localBatchNumber - 1);
															#line 622 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->latestLocalCommitBatchResolving.set(localBatchNumber);
															#line 623 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!static_cast<ReleaseResolvingAfterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ReleaseResolvingAfterActorState(); static_cast<ReleaseResolvingAfterActor*>(this)->destroy(); return 0; }
															#line 2462 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		new (&static_cast<ReleaseResolvingAfterActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ReleaseResolvingAfterActorState();
		static_cast<ReleaseResolvingAfterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ReleaseResolvingAfterActor*>(this)->actor_wait_state > 0) static_cast<ReleaseResolvingAfterActor*>(this)->actor_wait_state = 0;
		static_cast<ReleaseResolvingAfterActor*>(this)->ActorCallback< ReleaseResolvingAfterActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ReleaseResolvingAfterActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("releaseResolvingAfter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReleaseResolvingAfterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("releaseResolvingAfter", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ReleaseResolvingAfterActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("releaseResolvingAfter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReleaseResolvingAfterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("releaseResolvingAfter", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ReleaseResolvingAfterActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("releaseResolvingAfter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReleaseResolvingAfterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("releaseResolvingAfter", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 619 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ProxyCommitData* self;
															#line 619 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Future<Void> releaseDelay;
															#line 619 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	int64_t localBatchNumber;
															#line 2551 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
};
// This generated class is to be used only via releaseResolvingAfter()
															#line 619 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class ReleaseResolvingAfterActor final : public Actor<Void>, public ActorCallback< ReleaseResolvingAfterActor, 0, Void >, public FastAllocated<ReleaseResolvingAfterActor>, public ReleaseResolvingAfterActorState<ReleaseResolvingAfterActor> {
															#line 2556 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
public:
	using FastAllocated<ReleaseResolvingAfterActor>::operator new;
	using FastAllocated<ReleaseResolvingAfterActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15985396926096427264UL, 15303439270000182016UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ReleaseResolvingAfterActor, 0, Void >;
															#line 619 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ReleaseResolvingAfterActor(ProxyCommitData* const& self,Future<Void> const& releaseDelay,int64_t const& localBatchNumber) 
															#line 2573 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		 : Actor<Void>(),
		   ReleaseResolvingAfterActorState<ReleaseResolvingAfterActor>(self, releaseDelay, localBatchNumber),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("releaseResolvingAfter", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15016637786698726400UL, 2544269195532515072UL);
		ActorExecutionContextHelper __helper(static_cast<ReleaseResolvingAfterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("releaseResolvingAfter");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("releaseResolvingAfter", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ReleaseResolvingAfterActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 619 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
[[nodiscard]] Future<Void> releaseResolvingAfter( ProxyCommitData* const& self, Future<Void> const& releaseDelay, int64_t const& localBatchNumber ) {
															#line 619 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	return Future<Void>(new ReleaseResolvingAfterActor(self, releaseDelay, localBatchNumber));
															#line 2606 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
}

#line 625 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"

															#line 2611 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
namespace {
// This generated class is to be used only via trackResolutionMetrics()
															#line 626 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
template <class TrackResolutionMetricsActor>
															#line 626 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class TrackResolutionMetricsActorState {
															#line 2618 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
public:
															#line 626 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	TrackResolutionMetricsActorState(Reference<Histogram> const& dist,Future<ResolveTransactionBatchReply> const& in) 
															#line 626 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
															#line 626 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		 : dist(dist),
															#line 626 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   in(in),
															#line 628 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   startTime(g_network->timer_monotonic())
															#line 2629 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
	{
		fdb_probe_actor_create("trackResolutionMetrics", reinterpret_cast<unsigned long>(this));

	}
	~TrackResolutionMetricsActorState() 
	{
		fdb_probe_actor_destroy("trackResolutionMetrics", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 629 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			StrictFuture<ResolveTransactionBatchReply> __when_expr_0 = in;
															#line 629 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (static_cast<TrackResolutionMetricsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2646 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TrackResolutionMetricsActor*>(this)->actor_wait_state = 1;
															#line 629 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TrackResolutionMetricsActor, 0, ResolveTransactionBatchReply >*>(static_cast<TrackResolutionMetricsActor*>(this)));
															#line 2651 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TrackResolutionMetricsActorState();
		static_cast<TrackResolutionMetricsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(ResolveTransactionBatchReply const& reply,int loopDepth) 
	{
															#line 630 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		dist->sampleSeconds(g_network->timer_monotonic() - startTime);
															#line 631 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!static_cast<TrackResolutionMetricsActor*>(this)->SAV<ResolveTransactionBatchReply>::futures) { (void)(reply); this->~TrackResolutionMetricsActorState(); static_cast<TrackResolutionMetricsActor*>(this)->destroy(); return 0; }
															#line 2676 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		new (&static_cast<TrackResolutionMetricsActor*>(this)->SAV< ResolveTransactionBatchReply >::value()) ResolveTransactionBatchReply(reply);
		this->~TrackResolutionMetricsActorState();
		static_cast<TrackResolutionMetricsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(ResolveTransactionBatchReply && reply,int loopDepth) 
	{
															#line 630 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		dist->sampleSeconds(g_network->timer_monotonic() - startTime);
															#line 631 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!static_cast<TrackResolutionMetricsActor*>(this)->SAV<ResolveTransactionBatchReply>::futures) { (void)(reply); this->~TrackResolutionMetricsActorState(); static_cast<TrackResolutionMetricsActor*>(this)->destroy(); return 0; }
															#line 2690 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		new (&static_cast<TrackResolutionMetricsActor*>(this)->SAV< ResolveTransactionBatchReply >::value()) ResolveTransactionBatchReply(reply);
		this->~TrackResolutionMetricsActorState();
		static_cast<TrackResolutionMetricsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(ResolveTransactionBatchReply const& reply,int loopDepth) 
	{
		loopDepth = a_body1cont1(reply, loopDepth);

		return loopDepth;
	}
	int a_body1when1(ResolveTransactionBatchReply && reply,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(reply), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TrackResolutionMetricsActor*>(this)->actor_wait_state > 0) static_cast<TrackResolutionMetricsActor*>(this)->actor_wait_state = 0;
		static_cast<TrackResolutionMetricsActor*>(this)->ActorCallback< TrackResolutionMetricsActor, 0, ResolveTransactionBatchReply >::remove();

	}
	void a_callback_fire(ActorCallback< TrackResolutionMetricsActor, 0, ResolveTransactionBatchReply >*,ResolveTransactionBatchReply const& value) 
	{
		fdb_probe_actor_enter("trackResolutionMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TrackResolutionMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackResolutionMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TrackResolutionMetricsActor, 0, ResolveTransactionBatchReply >*,ResolveTransactionBatchReply && value) 
	{
		fdb_probe_actor_enter("trackResolutionMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TrackResolutionMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackResolutionMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TrackResolutionMetricsActor, 0, ResolveTransactionBatchReply >*,Error err) 
	{
		fdb_probe_actor_enter("trackResolutionMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TrackResolutionMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackResolutionMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 626 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Reference<Histogram> dist;
															#line 626 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Future<ResolveTransactionBatchReply> in;
															#line 628 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	double startTime;
															#line 2779 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
};
// This generated class is to be used only via trackResolutionMetrics()
															#line 626 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class TrackResolutionMetricsActor final : public Actor<ResolveTransactionBatchReply>, public ActorCallback< TrackResolutionMetricsActor, 0, ResolveTransactionBatchReply >, public FastAllocated<TrackResolutionMetricsActor>, public TrackResolutionMetricsActorState<TrackResolutionMetricsActor> {
															#line 2784 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
public:
	using FastAllocated<TrackResolutionMetricsActor>::operator new;
	using FastAllocated<TrackResolutionMetricsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6531871091695597568UL, 8288194910770558976UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<ResolveTransactionBatchReply>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TrackResolutionMetricsActor, 0, ResolveTransactionBatchReply >;
															#line 626 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	TrackResolutionMetricsActor(Reference<Histogram> const& dist,Future<ResolveTransactionBatchReply> const& in) 
															#line 2801 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		 : Actor<ResolveTransactionBatchReply>(),
		   TrackResolutionMetricsActorState<TrackResolutionMetricsActor>(dist, in),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("trackResolutionMetrics", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(662851382450018048UL, 8345511031365611520UL);
		ActorExecutionContextHelper __helper(static_cast<TrackResolutionMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("trackResolutionMetrics");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("trackResolutionMetrics", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TrackResolutionMetricsActor, 0, ResolveTransactionBatchReply >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 626 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
[[nodiscard]] static Future<ResolveTransactionBatchReply> trackResolutionMetrics( Reference<Histogram> const& dist, Future<ResolveTransactionBatchReply> const& in ) {
															#line 626 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	return Future<ResolveTransactionBatchReply>(new TrackResolutionMetricsActor(dist, in));
															#line 2834 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
}

#line 633 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"

namespace CommitBatch {

constexpr const std::string_view UNSET = std::string_view();
constexpr const std::string_view INITIALIZE = "initialize"sv;
constexpr const std::string_view PRE_RESOLUTION = "preResolution"sv;
constexpr const std::string_view RESOLUTION = "resolution"sv;
constexpr const std::string_view POST_RESOLUTION = "postResolution"sv;
constexpr const std::string_view TRANSACTION_LOGGING = "transactionLogging"sv;
constexpr const std::string_view REPLY = "reply"sv;
constexpr const std::string_view COMPLETE = "complete"sv;

struct CommitBatchContext {
	using StoreCommit_t = std::vector<std::pair<Future<LogSystemDiskQueueAdapter::CommitMessage>, Future<Void>>>;

	ProxyCommitData* const pProxyCommitData;
	std::vector<CommitTransactionRequest> trs;
	const int currentBatchMemBytesCount;

	double startTime;

	// The current stage of batch commit
	std::string_view stage = UNSET;

	// If encryption is enabled this value represents the total time (in nanoseconds) that was spent on encryption in
	// the commit proxy for a given Commit Batch
	Optional<double> encryptionTime;

	Optional<UID> debugID;

	bool forceRecovery = false;
	bool rejected = false; // If rejected due to long queue length

	int64_t localBatchNumber;
	LogPushData toCommit;

	int batchOperations = 0;

	Span span;

	int64_t batchBytes = 0;

	int latencyBucket = 0;

	Version commitVersion;
	Version prevVersion;

	int64_t maxTransactionBytes;
	std::vector<std::vector<int>> transactionResolverMap;
	std::vector<std::vector<std::vector<int>>> txReadConflictRangeIndexMap;

	Future<Void> releaseDelay;
	Future<Void> releaseFuture;

	std::vector<ResolveTransactionBatchReply> resolution;

	double computeStart;
	double computeDuration = 0;

	Arena arena;

	/// true if the batch is the 1st batch for this proxy, additional metadata
	/// processing is involved for this batch.
	bool isMyFirstBatch;
	bool firstStateMutations;

	Optional<Value> previousCoordinators;

	StoreCommit_t storeCommits;

	std::vector<uint8_t> committed;

	Optional<Key> lockedKey;
	bool locked;

	int commitCount = 0;

	std::vector<int> nextTr;

	bool lockedAfter;

	Optional<Value> metadataVersionAfter;

	int mutationCount = 0;
	int mutationBytes = 0;

	std::map<Key, MutationListRef> logRangeMutations;
	Arena logRangeMutationsArena;

	int transactionNum = 0;
	int yieldBytes = 0;

	LogSystemDiskQueueAdapter::CommitMessage msg;

	Future<Version> loggingComplete;

	double commitStartTime;

	std::unordered_map<uint16_t, Version> tpcvMap; // obtained from resolver
	std::set<Tag> writtenTags; // final set tags written to in the batch
	std::set<Tag> writtenTagsPreResolution; // tags written to in the batch not including any changes from the resolver.

	// Cipher keys to be used to encrypt mutations
	std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> cipherKeys;

	IdempotencyIdKVBuilder idempotencyKVBuilder;

	CommitBatchContext(ProxyCommitData*, const std::vector<CommitTransactionRequest>*, const int);

	void setupTraceBatch();

	std::set<Tag> getWrittenTagsPreResolution();

	void checkHotShards();

	bool rangeLockEnabled();

	Version lastShardMove;

private:
	void evaluateBatchSize();
};

bool CommitBatchContext::rangeLockEnabled() {
	return pProxyCommitData->rangeLockEnabled();
}

void CommitBatchContext::checkHotShards() {
	// removed expired hot shards
	for (auto it = pProxyCommitData->hotShards.begin(); it != pProxyCommitData->hotShards.end();) {
		if (now() > it->second) {
			it = pProxyCommitData->hotShards.erase(it);
		} else {
			++it;
		}
	}

	if (pProxyCommitData->hotShards.empty()) {
		return;
	}

	auto trsBegin = trs.begin();

	std::vector<size_t> transactionsToRemove;
	for (int transactionNum = 0; transactionNum < trs.size(); transactionNum++) {
		VectorRef<MutationRef>* pMutations = &trs[transactionNum].transaction.mutations;
		bool abortTransaction = false;
		for (int mutationNum = 0; mutationNum < pMutations->size(); mutationNum++) {
			auto& m = (*pMutations)[mutationNum];
			if (isSingleKeyMutation((MutationRef::Type)m.type)) {
				for (const auto& shard : pProxyCommitData->hotShards) {
					if (shard.first.contains(KeyRef(m.param1))) {
						abortTransaction = true;
						break;
					}
				}
			} else if (m.type == MutationRef::ClearRange) {
				for (const auto& shard : pProxyCommitData->hotShards) {
					if (shard.first.intersects(KeyRangeRef(m.param1, m.param2))) {
						abortTransaction = true;
						break;
					}
				}
			} else {
				UNREACHABLE();
			}
		}
		if (abortTransaction) {
			trs[transactionNum].reply.sendError(transaction_throttled_hot_shard());
			transactionsToRemove.push_back(transactionNum);
		}
	}
	// Remove transactions marked for removal in reverse order to avoid shifting indices
	for (auto it = transactionsToRemove.rbegin(); it != transactionsToRemove.rend(); ++it) {
		trs.erase(trsBegin + *it);
	}
	committed.resize(trs.size());
	return;
}

// Check whether the mutation intersects any legal backup ranges
// If so, it will be clamped to the intersecting range(s) later
inline bool shouldBackup(MutationRef const& m) {
	if (normalKeys.contains(m.param1) || m.param1 == metadataVersionKey) {
		return true;
	} else if (m.type != MutationRef::Type::ClearRange) {
		return systemBackupMutationMask().rangeContaining(m.param1).value();
	} else {
		for (auto& r : systemBackupMutationMask().intersectingRanges(KeyRangeRef(m.param1, m.param2))) {
			if (r->value()) {
				return true;
			}
		}
	}
	return false;
}

// Find the set of logs the batch is sent to. An empty set indicates it cannot be
// determined. In version vector, this means the batch should be sent to all logs.
std::set<Tag> CommitBatchContext::getWrittenTagsPreResolution() {
	std::set<Tag> transactionTags;
	std::vector<Tag> cacheVector = { cacheTag };
	lastShardMove = pProxyCommitData->lastShardMove;
	if (pProxyCommitData->txnStateStore->getReplaceContent()) {
		return std::set<Tag>();
	}
	if (pProxyCommitData->idempotencyClears.size()) {
		return std::set<Tag>();
	}
	for (int transactionNum = 0; transactionNum < trs.size(); transactionNum++) {
		int mutationNum = 0;
		VectorRef<MutationRef>* pMutations = &trs[transactionNum].transaction.mutations;
		if (trs[transactionNum].idempotencyId.valid()) {
			return std::set<Tag>();
		}
		for (; mutationNum < pMutations->size(); mutationNum++) {
			auto& m = (*pMutations)[mutationNum];
			// disable version vector's effect if any mutation in the batch is backed up.
			// TODO: make backup work with version vector.
			if (pProxyCommitData->vecBackupKeys.size() > 1 && shouldBackup(m)) {
				return std::set<Tag>();
			}
			if (isSingleKeyMutation((MutationRef::Type)m.type)) {
				auto& tags = pProxyCommitData->tagsForKey(m.param1);
				transactionTags.insert(tags.begin(), tags.end());
				if (pProxyCommitData->cacheInfo[m.param1]) {
					transactionTags.insert(cacheTag);
				}
			} else if (m.type == MutationRef::ClearRange) {
				auto range = pProxyCommitData->keyInfo.rangeContaining(m.param1);
				if (range.end() >= m.param2) {
					range.value().populateTags();
					transactionTags.insert(range.value().tags.begin(), range.value().tags.end());
				} else {
					std::set<Tag> allSources;
					while (range.begin() < m.param2) {
						range.value().populateTags();
						allSources.insert(range.value().tags.begin(), range.value().tags.end());
						transactionTags.insert(range.value().tags.begin(), range.value().tags.end());
						++range;
					}
				}
				KeyRangeRef clearRange(KeyRangeRef(m.param1, m.param2));
				if (pProxyCommitData->needsCacheTag(clearRange)) {
					transactionTags.insert(cacheTag);
				}
			} else {
				UNREACHABLE();
			}
		}
	}

	if (toCommit.getLogRouterTags()) {
		toCommit.storeRandomRouterTag();
		transactionTags.insert(toCommit.savedRandomRouterTag.get());
	}

	return transactionTags;
}

CommitBatchContext::CommitBatchContext(ProxyCommitData* const pProxyCommitData_,
                                       const std::vector<CommitTransactionRequest>* trs_,
                                       const int currentBatchMemBytesCount)
  : pProxyCommitData(pProxyCommitData_), trs(std::move(*const_cast<std::vector<CommitTransactionRequest>*>(trs_))),
    currentBatchMemBytesCount(currentBatchMemBytesCount), startTime(g_network->now()),
    localBatchNumber(++pProxyCommitData->localCommitBatchesStarted),
    toCommit(pProxyCommitData->logSystem, pProxyCommitData->localTLogCount), span("MP:commitBatch"_loc),
    committed(trs.size()), lastShardMove(invalidVersion) {

	evaluateBatchSize();

	if (batchOperations != 0) {
		latencyBucket =
		    std::min<int>(SERVER_KNOBS->PROXY_COMPUTE_BUCKETS - 1,
		                  SERVER_KNOBS->PROXY_COMPUTE_BUCKETS * batchBytes /
		                      (batchOperations * (CLIENT_KNOBS->VALUE_SIZE_LIMIT + CLIENT_KNOBS->KEY_SIZE_LIMIT)));
	}

	// since we are using just the former to limit the number of versions actually in flight!
	ASSERT(SERVER_KNOBS->MAX_READ_TRANSACTION_LIFE_VERSIONS <= SERVER_KNOBS->MAX_VERSIONS_IN_FLIGHT);
}

void CommitBatchContext::setupTraceBatch() {
	for (const auto& tr : trs) {
		if (tr.debugID.present()) {
			if (!debugID.present()) {
				debugID = nondeterministicRandom()->randomUniqueID();
			}

			g_traceBatch.addAttach("CommitAttachID", tr.debugID.get().first(), debugID.get().first());
		}
		span.addLink(tr.spanContext);
	}

	if (debugID.present()) {
		g_traceBatch.addEvent("CommitDebug", debugID.get().first(), "CommitProxyServer.commitBatch.Before");
	}
}

void CommitBatchContext::evaluateBatchSize() {
	for (const auto& tr : trs) {
		const auto& mutations = tr.transaction.mutations;
		batchOperations += mutations.size();
		batchBytes += mutations.expectedSize();
	}
}

// Try to identify recovery transaction and backup's apply mutations (blind writes).
// Both cannot be rejected and are approximated by looking at first mutation
// starting with 0xff.
bool canReject(const std::vector<CommitTransactionRequest>& trs) {
	for (const auto& tr : trs) {
		if (tr.transaction.mutations.empty())
			continue;
		if (!tr.tenantInfo.hasTenant() &&
		    (tr.transaction.mutations[0].param1.startsWith("\xff"_sr) || tr.transaction.read_conflict_ranges.empty())) {
			return false;
		}
	}
	return true;
}

double computeReleaseDelay(CommitBatchContext* self, double latencyBucket) {
	return std::min(SERVER_KNOBS->MAX_PROXY_COMPUTE,
	                self->batchOperations * self->pProxyCommitData->commitComputePerOperation[latencyBucket]);
}

															#line 3165 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
// This generated class is to be used only via preresolutionProcessing()
															#line 960 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
template <class PreresolutionProcessingActor>
															#line 960 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class PreresolutionProcessingActorState {
															#line 3171 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
public:
															#line 960 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	PreresolutionProcessingActorState(CommitBatchContext* const& self) 
															#line 960 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
															#line 960 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		 : self(self),
															#line 962 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   pProxyCommitData(self->pProxyCommitData),
															#line 963 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   trs(self->trs),
															#line 964 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   localBatchNumber(self->localBatchNumber),
															#line 965 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   latencyBucket(self->latencyBucket),
															#line 966 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   debugID(self->debugID),
															#line 967 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   span("MP:preresolutionProcessing"_loc, self->span.context),
															#line 968 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   startTime(g_network->timer_monotonic())
															#line 3192 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
	{
		fdb_probe_actor_create("preresolutionProcessing", reinterpret_cast<unsigned long>(this));

	}
	~PreresolutionProcessingActorState() 
	{
		fdb_probe_actor_destroy("preresolutionProcessing", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 970 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (self->localBatchNumber - self->pProxyCommitData->latestLocalCommitBatchResolving.get() > SERVER_KNOBS->RESET_MASTER_BATCHES && now() - self->pProxyCommitData->lastMasterReset > SERVER_KNOBS->RESET_MASTER_DELAY)
															#line 3207 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			{
															#line 973 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				TraceEvent(SevWarnAlways, "ResetMasterNetwork", self->pProxyCommitData->dbgid) .detail("CurrentBatch", self->localBatchNumber) .detail("InProcessBatch", self->pProxyCommitData->latestLocalCommitBatchResolving.get());
															#line 976 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				FlowTransport::transport().resetConnection(self->pProxyCommitData->master.address());
															#line 977 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				self->pProxyCommitData->lastMasterReset = now();
															#line 3215 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			}
															#line 981 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			CODE_PROBE(pProxyCommitData->latestLocalCommitBatchResolving.get() < localBatchNumber - 1, "Wait for local batch");
															#line 982 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			StrictFuture<Void> __when_expr_0 = pProxyCommitData->latestLocalCommitBatchResolving.whenAtLeast(localBatchNumber - 1);
															#line 982 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (static_cast<PreresolutionProcessingActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3223 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<PreresolutionProcessingActor*>(this)->actor_wait_state = 1;
															#line 982 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PreresolutionProcessingActor, 0, Void >*>(static_cast<PreresolutionProcessingActor*>(this)));
															#line 3228 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PreresolutionProcessingActorState();
		static_cast<PreresolutionProcessingActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 983 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		double queuingDelay = g_network->timer_monotonic() - startTime;
															#line 984 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->stats.computeLatency.addMeasurement(queuingDelay);
															#line 985 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->stats.commitBatchQueuingDist->sampleSeconds(queuingDelay);
															#line 986 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if ((queuingDelay > (double)SERVER_KNOBS->MAX_READ_TRANSACTION_LIFE_VERSIONS / SERVER_KNOBS->VERSIONS_PER_SECOND || (g_network->isSimulated() && BUGGIFY_WITH_PROB(0.01))) && SERVER_KNOBS->PROXY_REJECT_BATCH_QUEUED_TOO_LONG && canReject(trs))
															#line 3257 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 990 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			CODE_PROBE(true, "Reject transactions in the batch");
															#line 991 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			TraceEvent(g_network->isSimulated() ? SevInfo : SevWarnAlways, "ProxyReject", pProxyCommitData->dbgid) .suppressFor(0.1) .detail("QDelay", queuingDelay) .detail("Transactions", trs.size()) .detail("BatchNumber", localBatchNumber);
															#line 996 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			ASSERT(pProxyCommitData->latestLocalCommitBatchResolving.get() == localBatchNumber - 1);
															#line 997 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			pProxyCommitData->latestLocalCommitBatchResolving.set(localBatchNumber);
															#line 999 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			StrictFuture<Void> __when_expr_1 = pProxyCommitData->latestLocalCommitBatchLogging.whenAtLeast(localBatchNumber - 1);
															#line 999 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (static_cast<PreresolutionProcessingActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3271 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<PreresolutionProcessingActor*>(this)->actor_wait_state = 2;
															#line 999 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PreresolutionProcessingActor, 1, Void >*>(static_cast<PreresolutionProcessingActor*>(this)));
															#line 3276 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 983 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		double queuingDelay = g_network->timer_monotonic() - startTime;
															#line 984 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->stats.computeLatency.addMeasurement(queuingDelay);
															#line 985 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->stats.commitBatchQueuingDist->sampleSeconds(queuingDelay);
															#line 986 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if ((queuingDelay > (double)SERVER_KNOBS->MAX_READ_TRANSACTION_LIFE_VERSIONS / SERVER_KNOBS->VERSIONS_PER_SECOND || (g_network->isSimulated() && BUGGIFY_WITH_PROB(0.01))) && SERVER_KNOBS->PROXY_REJECT_BATCH_QUEUED_TOO_LONG && canReject(trs))
															#line 3296 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 990 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			CODE_PROBE(true, "Reject transactions in the batch");
															#line 991 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			TraceEvent(g_network->isSimulated() ? SevInfo : SevWarnAlways, "ProxyReject", pProxyCommitData->dbgid) .suppressFor(0.1) .detail("QDelay", queuingDelay) .detail("Transactions", trs.size()) .detail("BatchNumber", localBatchNumber);
															#line 996 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			ASSERT(pProxyCommitData->latestLocalCommitBatchResolving.get() == localBatchNumber - 1);
															#line 997 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			pProxyCommitData->latestLocalCommitBatchResolving.set(localBatchNumber);
															#line 999 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			StrictFuture<Void> __when_expr_1 = pProxyCommitData->latestLocalCommitBatchLogging.whenAtLeast(localBatchNumber - 1);
															#line 999 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (static_cast<PreresolutionProcessingActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3310 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<PreresolutionProcessingActor*>(this)->actor_wait_state = 2;
															#line 999 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PreresolutionProcessingActor, 1, Void >*>(static_cast<PreresolutionProcessingActor*>(this)));
															#line 3315 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PreresolutionProcessingActor*>(this)->actor_wait_state > 0) static_cast<PreresolutionProcessingActor*>(this)->actor_wait_state = 0;
		static_cast<PreresolutionProcessingActor*>(this)->ActorCallback< PreresolutionProcessingActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PreresolutionProcessingActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("preresolutionProcessing", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PreresolutionProcessingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("preresolutionProcessing", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PreresolutionProcessingActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("preresolutionProcessing", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PreresolutionProcessingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("preresolutionProcessing", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PreresolutionProcessingActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("preresolutionProcessing", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PreresolutionProcessingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("preresolutionProcessing", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 1012 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->releaseDelay = delay(computeReleaseDelay(self, latencyBucket), TaskPriority::ProxyMasterVersionReply);
															#line 1014 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (debugID.present())
															#line 3406 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 1015 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			g_traceBatch.addEvent( "CommitDebug", debugID.get().first(), "CommitProxyServer.commitBatch.GettingCommitVersion");
															#line 3410 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		}
															#line 1019 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (SERVER_KNOBS->ENABLE_VERSION_VECTOR_TLOG_UNICAST)
															#line 3414 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 1020 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			self->writtenTagsPreResolution = self->getWrittenTagsPreResolution();
															#line 3418 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		}
															#line 1023 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (SERVER_KNOBS->HOT_SHARD_THROTTLING_ENABLED && !pProxyCommitData->hotShards.empty())
															#line 3422 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 1024 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			self->checkHotShards();
															#line 3426 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		}
															#line 1027 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		GetCommitVersionRequest req(span.context, pProxyCommitData->commitVersionRequestNumber++, pProxyCommitData->mostRecentProcessedRequestNumber, pProxyCommitData->dbgid);
															#line 1031 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		beforeGettingCommitVersion = g_network->timer_monotonic();
															#line 1032 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<GetCommitVersionReply> __when_expr_2 = brokenPromiseToNever( pProxyCommitData->master.getCommitVersion.getReply(req, TaskPriority::ProxyMasterVersionReply));
															#line 1032 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<PreresolutionProcessingActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3436 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<PreresolutionProcessingActor*>(this)->actor_wait_state = 3;
															#line 1032 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< PreresolutionProcessingActor, 2, GetCommitVersionReply >*>(static_cast<PreresolutionProcessingActor*>(this)));
															#line 3441 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 1000 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		ASSERT(pProxyCommitData->latestLocalCommitBatchLogging.get() == localBatchNumber - 1);
															#line 1001 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->latestLocalCommitBatchLogging.set(localBatchNumber);
															#line 1002 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		for( const auto& tr : trs ) {
															#line 1003 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			tr.reply.sendError(transaction_too_old());
															#line 3456 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		}
															#line 1005 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		++pProxyCommitData->stats.commitBatchOut;
															#line 1006 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->stats.txnCommitOut += trs.size();
															#line 1007 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->stats.txnRejectedForQueuedTooLong += trs.size();
															#line 1008 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->rejected = true;
															#line 1009 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!static_cast<PreresolutionProcessingActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PreresolutionProcessingActorState(); static_cast<PreresolutionProcessingActor*>(this)->destroy(); return 0; }
															#line 3468 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		new (&static_cast<PreresolutionProcessingActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PreresolutionProcessingActorState();
		static_cast<PreresolutionProcessingActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 1000 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		ASSERT(pProxyCommitData->latestLocalCommitBatchLogging.get() == localBatchNumber - 1);
															#line 1001 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->latestLocalCommitBatchLogging.set(localBatchNumber);
															#line 1002 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		for( const auto& tr : trs ) {
															#line 1003 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			tr.reply.sendError(transaction_too_old());
															#line 3486 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		}
															#line 1005 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		++pProxyCommitData->stats.commitBatchOut;
															#line 1006 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->stats.txnCommitOut += trs.size();
															#line 1007 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->stats.txnRejectedForQueuedTooLong += trs.size();
															#line 1008 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->rejected = true;
															#line 1009 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!static_cast<PreresolutionProcessingActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PreresolutionProcessingActorState(); static_cast<PreresolutionProcessingActor*>(this)->destroy(); return 0; }
															#line 3498 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		new (&static_cast<PreresolutionProcessingActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PreresolutionProcessingActorState();
		static_cast<PreresolutionProcessingActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<PreresolutionProcessingActor*>(this)->actor_wait_state > 0) static_cast<PreresolutionProcessingActor*>(this)->actor_wait_state = 0;
		static_cast<PreresolutionProcessingActor*>(this)->ActorCallback< PreresolutionProcessingActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PreresolutionProcessingActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("preresolutionProcessing", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PreresolutionProcessingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("preresolutionProcessing", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< PreresolutionProcessingActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("preresolutionProcessing", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PreresolutionProcessingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("preresolutionProcessing", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< PreresolutionProcessingActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("preresolutionProcessing", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PreresolutionProcessingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("preresolutionProcessing", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont7(GetCommitVersionReply const& versionReply,int loopDepth) 
	{
															#line 1035 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->mostRecentProcessedRequestNumber = versionReply.requestNum;
															#line 1037 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->stats.txnCommitVersionAssigned += trs.size();
															#line 1038 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->stats.lastCommitVersionAssigned = versionReply.version;
															#line 1039 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->stats.getCommitVersionDist->sampleSeconds(g_network->timer_monotonic() - beforeGettingCommitVersion);
															#line 1042 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->commitVersion = versionReply.version;
															#line 1043 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->prevVersion = versionReply.prevVersion;
															#line 1047 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		for( auto it : versionReply.resolverChanges ) {
															#line 1048 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			auto rs = pProxyCommitData->keyResolvers.modify(it.range);
															#line 1049 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			for(auto r = rs.begin();r != rs.end();++r) {
															#line 1050 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				r->value().emplace_back(versionReply.resolverChangesVersion, it.dest);
															#line 3603 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			}
		}
															#line 1055 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (debugID.present())
															#line 3608 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 1056 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			g_traceBatch.addEvent("CommitDebug", debugID.get().first(), "CommitProxyServer.commitBatch.GotCommitVersion");
															#line 3612 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		}
															#line 1059 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!static_cast<PreresolutionProcessingActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PreresolutionProcessingActorState(); static_cast<PreresolutionProcessingActor*>(this)->destroy(); return 0; }
															#line 3616 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		new (&static_cast<PreresolutionProcessingActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PreresolutionProcessingActorState();
		static_cast<PreresolutionProcessingActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont7(GetCommitVersionReply && versionReply,int loopDepth) 
	{
															#line 1035 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->mostRecentProcessedRequestNumber = versionReply.requestNum;
															#line 1037 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->stats.txnCommitVersionAssigned += trs.size();
															#line 1038 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->stats.lastCommitVersionAssigned = versionReply.version;
															#line 1039 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->stats.getCommitVersionDist->sampleSeconds(g_network->timer_monotonic() - beforeGettingCommitVersion);
															#line 1042 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->commitVersion = versionReply.version;
															#line 1043 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->prevVersion = versionReply.prevVersion;
															#line 1047 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		for( auto it : versionReply.resolverChanges ) {
															#line 1048 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			auto rs = pProxyCommitData->keyResolvers.modify(it.range);
															#line 1049 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			for(auto r = rs.begin();r != rs.end();++r) {
															#line 1050 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				r->value().emplace_back(versionReply.resolverChangesVersion, it.dest);
															#line 3646 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			}
		}
															#line 1055 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (debugID.present())
															#line 3651 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 1056 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			g_traceBatch.addEvent("CommitDebug", debugID.get().first(), "CommitProxyServer.commitBatch.GotCommitVersion");
															#line 3655 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		}
															#line 1059 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!static_cast<PreresolutionProcessingActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PreresolutionProcessingActorState(); static_cast<PreresolutionProcessingActor*>(this)->destroy(); return 0; }
															#line 3659 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		new (&static_cast<PreresolutionProcessingActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PreresolutionProcessingActorState();
		static_cast<PreresolutionProcessingActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3when1(GetCommitVersionReply const& versionReply,int loopDepth) 
	{
		loopDepth = a_body1cont7(versionReply, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(GetCommitVersionReply && versionReply,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(versionReply), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<PreresolutionProcessingActor*>(this)->actor_wait_state > 0) static_cast<PreresolutionProcessingActor*>(this)->actor_wait_state = 0;
		static_cast<PreresolutionProcessingActor*>(this)->ActorCallback< PreresolutionProcessingActor, 2, GetCommitVersionReply >::remove();

	}
	void a_callback_fire(ActorCallback< PreresolutionProcessingActor, 2, GetCommitVersionReply >*,GetCommitVersionReply const& value) 
	{
		fdb_probe_actor_enter("preresolutionProcessing", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PreresolutionProcessingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("preresolutionProcessing", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< PreresolutionProcessingActor, 2, GetCommitVersionReply >*,GetCommitVersionReply && value) 
	{
		fdb_probe_actor_enter("preresolutionProcessing", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PreresolutionProcessingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("preresolutionProcessing", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< PreresolutionProcessingActor, 2, GetCommitVersionReply >*,Error err) 
	{
		fdb_probe_actor_enter("preresolutionProcessing", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PreresolutionProcessingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("preresolutionProcessing", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 960 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	CommitBatchContext* self;
															#line 962 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ProxyCommitData* const pProxyCommitData;
															#line 963 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	std::vector<CommitTransactionRequest>& trs;
															#line 964 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	const int64_t localBatchNumber;
															#line 965 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	const int latencyBucket;
															#line 966 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	const Optional<UID>& debugID;
															#line 967 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Span span;
															#line 968 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	double startTime;
															#line 1031 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	double beforeGettingCommitVersion;
															#line 3760 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
};
// This generated class is to be used only via preresolutionProcessing()
															#line 960 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class PreresolutionProcessingActor final : public Actor<Void>, public ActorCallback< PreresolutionProcessingActor, 0, Void >, public ActorCallback< PreresolutionProcessingActor, 1, Void >, public ActorCallback< PreresolutionProcessingActor, 2, GetCommitVersionReply >, public FastAllocated<PreresolutionProcessingActor>, public PreresolutionProcessingActorState<PreresolutionProcessingActor> {
															#line 3765 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
public:
	using FastAllocated<PreresolutionProcessingActor>::operator new;
	using FastAllocated<PreresolutionProcessingActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(276236310155773440UL, 17602851574688644864UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PreresolutionProcessingActor, 0, Void >;
friend struct ActorCallback< PreresolutionProcessingActor, 1, Void >;
friend struct ActorCallback< PreresolutionProcessingActor, 2, GetCommitVersionReply >;
															#line 960 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	PreresolutionProcessingActor(CommitBatchContext* const& self) 
															#line 3784 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		 : Actor<Void>(),
		   PreresolutionProcessingActorState<PreresolutionProcessingActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("preresolutionProcessing", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18247384368358389248UL, 1993642498905904640UL);
		ActorExecutionContextHelper __helper(static_cast<PreresolutionProcessingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("preresolutionProcessing");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("preresolutionProcessing", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PreresolutionProcessingActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< PreresolutionProcessingActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< PreresolutionProcessingActor, 2, GetCommitVersionReply >*)0, actor_cancelled()); break;
		}

	}
};
															#line 960 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
[[nodiscard]] Future<Void> preresolutionProcessing( CommitBatchContext* const& self ) {
															#line 960 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	return Future<Void>(new PreresolutionProcessingActor(self));
															#line 3818 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
}

#line 1061 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"

namespace {
EncryptCipherDomainId getEncryptDetailsFromMutationRef(ProxyCommitData* commitData, MutationRef m) {
	EncryptCipherDomainId domainId = INVALID_ENCRYPT_DOMAIN_ID;

	// Possible scenarios:
	// 1. Encryption domain (Tenant details) weren't explicitly provided, extract Tenant details using
	// TenantPrefix (first 8 bytes of FDBKey)
	// 2. Encryption domain isn't available, leverage 'default encryption domain'

	if (isSystemKey(m.param1)) {
		// Encryption domain == FDB SystemKeyspace encryption domain
		domainId = SYSTEM_KEYSPACE_ENCRYPT_DOMAIN_ID;
	} else if (commitData->tenantMap.empty() || commitData->encryptMode.mode == EncryptionAtRestMode::CLUSTER_AWARE) {
		// Cluster serves no-tenants; use 'default encryption domain'
	} else if (isSingleKeyMutation((MutationRef::Type)m.type)) {
		ASSERT_NE((MutationRef::Type)m.type, MutationRef::Type::ClearRange);

		if (m.param1.size() >= TenantAPI::PREFIX_SIZE) {
			// Parse mutation key to determine mutation encryption domain
			StringRef prefix = m.param1.substr(0, TenantAPI::PREFIX_SIZE);
			int64_t tenantId = TenantAPI::prefixToId(prefix, EnforceValidTenantId::False);
			if (commitData->tenantMap.contains(tenantId)) {
				domainId = tenantId;
			} else {
				// Leverage 'default encryption domain'
			}
		}
	} else {
		// ClearRange is the 'only' MultiKey transaction allowed
		ASSERT_EQ((MutationRef::Type)m.type, MutationRef::Type::ClearRange);

		// FIXME: Handle Clear-range transaction, actions needed:
		// 1. Transaction range can spawn multiple encryption domains (tenants)
		// 2. Transaction can be a multi-key transaction spawning multiple tenants
		// For now fallback to 'default encryption domain'

		CODE_PROBE(true, "ClearRange mutation encryption", probe::decoration::rare);
	}

	// Unknown tenant, fallback to fdb default encryption domain
	if (domainId == INVALID_ENCRYPT_DOMAIN_ID) {
		domainId = FDB_DEFAULT_ENCRYPT_DOMAIN_ID;

		CODE_PROBE(true, "Default domain mutation encryption", probe::decoration::rare);
	}

	return domainId;
}

} // namespace

															#line 3874 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
// This generated class is to be used only via getResolution()
															#line 1113 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
template <class GetResolutionActor>
															#line 1113 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class GetResolutionActorState {
															#line 3880 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
public:
															#line 1113 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	GetResolutionActorState(CommitBatchContext* const& self) 
															#line 1113 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
															#line 1113 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		 : self(self),
															#line 1114 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   resolutionStart(g_network->timer_monotonic()),
															#line 1117 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   pProxyCommitData(self->pProxyCommitData)
															#line 3891 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
	{
		fdb_probe_actor_create("getResolution", reinterpret_cast<unsigned long>(this));

	}
	~GetResolutionActorState() 
	{
		fdb_probe_actor_destroy("getResolution", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1118 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			std::vector<CommitTransactionRequest>& trs = self->trs;
															#line 1119 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			span = Span("MP:getResolution"_loc, self->span.context);
															#line 1121 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			ResolutionRequestBuilder requests(pProxyCommitData, self->commitVersion, self->prevVersion, pProxyCommitData->version.get(), self->lastShardMove, span);
															#line 1127 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			int conflictRangeCount = 0;
															#line 1128 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			self->maxTransactionBytes = 0;
															#line 1129 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			for(int t = 0;t < trs.size();t++) {
															#line 1130 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				requests.addTransaction(trs[t], self->commitVersion, t);
															#line 1131 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				conflictRangeCount += trs[t].transaction.read_conflict_ranges.size() + trs[t].transaction.write_conflict_ranges.size();
															#line 1135 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				self->maxTransactionBytes = std::max<int64_t>(self->maxTransactionBytes, trs[t].transaction.expectedSize());
															#line 3922 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			}
															#line 1138 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			pProxyCommitData->stats.conflictRanges += conflictRangeCount;
															#line 1140 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			for(int r = 1;r < pProxyCommitData->resolvers.size();r++) {
															#line 1141 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				ASSERT(requests.requests[r].txnStateTransactions.size() == requests.requests[0].txnStateTransactions.size());
															#line 3930 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			}
															#line 1143 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			pProxyCommitData->stats.txnCommitResolving += trs.size();
															#line 1144 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			std::vector<Future<ResolveTransactionBatchReply>> replies;
															#line 1145 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			for(int r = 0;r < pProxyCommitData->resolvers.size();r++) {
															#line 1146 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				requests.requests[r].debugID = self->debugID;
															#line 1147 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				requests.requests[r].writtenTags = self->writtenTagsPreResolution;
															#line 1148 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				replies.push_back(trackResolutionMetrics(pProxyCommitData->stats.resolverDist[r], brokenPromiseToNever(pProxyCommitData->resolvers[r].resolve.getReply( requests.requests[r], TaskPriority::ProxyResolverReply))));
															#line 3944 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			}
															#line 1153 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			self->transactionResolverMap.swap(requests.transactionResolverMap);
															#line 1155 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			self->txReadConflictRangeIndexMap.swap(requests.txReadConflictRangeIndexMap);
															#line 1158 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			getCipherKeys = Future<std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>>>();
															#line 1159 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (pProxyCommitData->encryptMode.isEncryptionEnabled())
															#line 3954 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			{
															#line 1160 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				std::unordered_set<EncryptCipherDomainId> encryptDomainIds = { SYSTEM_KEYSPACE_ENCRYPT_DOMAIN_ID, FDB_DEFAULT_ENCRYPT_DOMAIN_ID };
															#line 1162 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (FLOW_KNOBS->ENCRYPT_HEADER_AUTH_TOKEN_ENABLED)
															#line 3960 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
				{
															#line 1163 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					encryptDomainIds.insert(ENCRYPT_HEADER_DOMAIN_ID);
															#line 3964 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
				}
															#line 1166 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (pProxyCommitData->encryptMode.mode == EncryptionAtRestMode::DOMAIN_AWARE)
															#line 3968 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
				{
															#line 1167 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					for(int t = 0;t < trs.size();t++) {
															#line 1168 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						TenantInfo const& tenantInfo = trs[t].tenantInfo;
															#line 1169 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						int64_t tenantId = tenantInfo.tenantId;
															#line 1170 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						if (tenantId != TenantInfo::INVALID_TENANT)
															#line 3978 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
						{
															#line 1171 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
							encryptDomainIds.emplace(tenantId);
															#line 3982 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
						}
					}
				}
															#line 1175 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				getCipherKeys = GetEncryptCipherKeys<ServerDBInfo>::getLatestEncryptCipherKeys( pProxyCommitData->db, encryptDomainIds, BlobCipherMetrics::TLOG, pProxyCommitData->encryptionMonitor);
															#line 3988 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			}
															#line 1179 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			self->releaseFuture = releaseResolvingAfter(pProxyCommitData, self->releaseDelay, self->localBatchNumber);
															#line 1181 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (self->localBatchNumber - self->pProxyCommitData->latestLocalCommitBatchLogging.get() > SERVER_KNOBS->RESET_RESOLVER_BATCHES && now() - self->pProxyCommitData->lastResolverReset > SERVER_KNOBS->RESET_RESOLVER_DELAY)
															#line 3994 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			{
															#line 1184 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				for(int r = 0;r < self->pProxyCommitData->resolvers.size();r++) {
															#line 1185 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					TraceEvent(SevWarnAlways, "ResetResolverNetwork", self->pProxyCommitData->dbgid) .detail("PeerAddr", self->pProxyCommitData->resolvers[r].address()) .detail("PeerAddress", self->pProxyCommitData->resolvers[r].address()) .detail("CurrentBatch", self->localBatchNumber) .detail("InProcessBatch", self->pProxyCommitData->latestLocalCommitBatchLogging.get());
															#line 1190 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					FlowTransport::transport().resetConnection(self->pProxyCommitData->resolvers[r].address());
															#line 4002 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
				}
															#line 1192 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				self->pProxyCommitData->lastResolverReset = now();
															#line 4006 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			}
															#line 1196 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			StrictFuture<std::vector<ResolveTransactionBatchReply>> __when_expr_0 = getAll(replies);
															#line 1196 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (static_cast<GetResolutionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4012 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetResolutionActor*>(this)->actor_wait_state = 1;
															#line 1196 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetResolutionActor, 0, std::vector<ResolveTransactionBatchReply> >*>(static_cast<GetResolutionActor*>(this)));
															#line 4017 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetResolutionActorState();
		static_cast<GetResolutionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<ResolveTransactionBatchReply> const& resolutionResp,int loopDepth) 
	{
															#line 1197 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->resolution.swap(*const_cast<std::vector<ResolveTransactionBatchReply>*>(&resolutionResp));
															#line 1199 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->pProxyCommitData->stats.resolutionDist->sampleSeconds(g_network->timer_monotonic() - resolutionStart);
															#line 1200 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (self->debugID.present())
															#line 4044 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 1201 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			g_traceBatch.addEvent( "CommitDebug", self->debugID.get().first(), "CommitProxyServer.commitBatch.AfterResolution");
															#line 4048 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		}
															#line 1204 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (pProxyCommitData->encryptMode.isEncryptionEnabled())
															#line 4052 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 1205 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			StrictFuture<std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>>> __when_expr_1 = getCipherKeys;
															#line 1205 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (static_cast<GetResolutionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4058 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<GetResolutionActor*>(this)->actor_wait_state = 2;
															#line 1205 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetResolutionActor, 1, std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> >*>(static_cast<GetResolutionActor*>(this)));
															#line 4063 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont12(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(std::vector<ResolveTransactionBatchReply> && resolutionResp,int loopDepth) 
	{
															#line 1197 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->resolution.swap(*const_cast<std::vector<ResolveTransactionBatchReply>*>(&resolutionResp));
															#line 1199 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->pProxyCommitData->stats.resolutionDist->sampleSeconds(g_network->timer_monotonic() - resolutionStart);
															#line 1200 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (self->debugID.present())
															#line 4081 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 1201 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			g_traceBatch.addEvent( "CommitDebug", self->debugID.get().first(), "CommitProxyServer.commitBatch.AfterResolution");
															#line 4085 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		}
															#line 1204 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (pProxyCommitData->encryptMode.isEncryptionEnabled())
															#line 4089 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 1205 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			StrictFuture<std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>>> __when_expr_1 = getCipherKeys;
															#line 1205 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (static_cast<GetResolutionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4095 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<GetResolutionActor*>(this)->actor_wait_state = 2;
															#line 1205 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetResolutionActor, 1, std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> >*>(static_cast<GetResolutionActor*>(this)));
															#line 4100 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont12(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(std::vector<ResolveTransactionBatchReply> const& resolutionResp,int loopDepth) 
	{
		loopDepth = a_body1cont1(resolutionResp, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<ResolveTransactionBatchReply> && resolutionResp,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(resolutionResp), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetResolutionActor*>(this)->actor_wait_state > 0) static_cast<GetResolutionActor*>(this)->actor_wait_state = 0;
		static_cast<GetResolutionActor*>(this)->ActorCallback< GetResolutionActor, 0, std::vector<ResolveTransactionBatchReply> >::remove();

	}
	void a_callback_fire(ActorCallback< GetResolutionActor, 0, std::vector<ResolveTransactionBatchReply> >*,std::vector<ResolveTransactionBatchReply> const& value) 
	{
		fdb_probe_actor_enter("getResolution", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getResolution", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetResolutionActor, 0, std::vector<ResolveTransactionBatchReply> >*,std::vector<ResolveTransactionBatchReply> && value) 
	{
		fdb_probe_actor_enter("getResolution", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getResolution", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetResolutionActor, 0, std::vector<ResolveTransactionBatchReply> >*,Error err) 
	{
		fdb_probe_actor_enter("getResolution", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getResolution", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont12(int loopDepth) 
	{
															#line 1209 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!static_cast<GetResolutionActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetResolutionActorState(); static_cast<GetResolutionActor*>(this)->destroy(); return 0; }
															#line 4189 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		new (&static_cast<GetResolutionActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetResolutionActorState();
		static_cast<GetResolutionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont14(std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> const& cipherKeys,int loopDepth) 
	{
															#line 1206 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->cipherKeys = cipherKeys;
															#line 4201 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		loopDepth = a_body1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1cont14(std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> && cipherKeys,int loopDepth) 
	{
															#line 1206 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->cipherKeys = cipherKeys;
															#line 4210 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		loopDepth = a_body1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> const& cipherKeys,int loopDepth) 
	{
		loopDepth = a_body1cont14(cipherKeys, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> && cipherKeys,int loopDepth) 
	{
		loopDepth = a_body1cont14(std::move(cipherKeys), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetResolutionActor*>(this)->actor_wait_state > 0) static_cast<GetResolutionActor*>(this)->actor_wait_state = 0;
		static_cast<GetResolutionActor*>(this)->ActorCallback< GetResolutionActor, 1, std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> >::remove();

	}
	void a_callback_fire(ActorCallback< GetResolutionActor, 1, std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> >*,std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> const& value) 
	{
		fdb_probe_actor_enter("getResolution", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getResolution", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetResolutionActor, 1, std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> >*,std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> && value) 
	{
		fdb_probe_actor_enter("getResolution", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getResolution", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetResolutionActor, 1, std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> >*,Error err) 
	{
		fdb_probe_actor_enter("getResolution", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getResolution", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1113 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	CommitBatchContext* self;
															#line 1114 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	double resolutionStart;
															#line 1117 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ProxyCommitData* pProxyCommitData;
															#line 1119 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Span span;
															#line 1158 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Future<std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>>> getCipherKeys;
															#line 4300 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
};
// This generated class is to be used only via getResolution()
															#line 1113 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class GetResolutionActor final : public Actor<Void>, public ActorCallback< GetResolutionActor, 0, std::vector<ResolveTransactionBatchReply> >, public ActorCallback< GetResolutionActor, 1, std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> >, public FastAllocated<GetResolutionActor>, public GetResolutionActorState<GetResolutionActor> {
															#line 4305 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
public:
	using FastAllocated<GetResolutionActor>::operator new;
	using FastAllocated<GetResolutionActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17096422353445878528UL, 9064878501490883328UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetResolutionActor, 0, std::vector<ResolveTransactionBatchReply> >;
friend struct ActorCallback< GetResolutionActor, 1, std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> >;
															#line 1113 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	GetResolutionActor(CommitBatchContext* const& self) 
															#line 4323 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		 : Actor<Void>(),
		   GetResolutionActorState<GetResolutionActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getResolution", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8033480777775786752UL, 12535296860845315328UL);
		ActorExecutionContextHelper __helper(static_cast<GetResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getResolution");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getResolution", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetResolutionActor, 0, std::vector<ResolveTransactionBatchReply> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetResolutionActor, 1, std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1113 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
[[nodiscard]] Future<Void> getResolution( CommitBatchContext* const& self ) {
															#line 1113 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	return Future<Void>(new GetResolutionActor(self));
															#line 4356 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
}

#line 1211 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"

void assertResolutionStateMutationsSizeConsistent(const std::vector<ResolveTransactionBatchReply>& resolution) {
	for (int r = 1; r < resolution.size(); r++) {
		ASSERT(resolution[r].stateMutations.size() == resolution[0].stateMutations.size());
		for (int s = 0; s < resolution[r].stateMutations.size(); s++) {
			ASSERT(resolution[r].stateMutations[s].size() == resolution[0].stateMutations[s].size());
		}
	}
}

// Return true if a single-key mutation is associated with a valid tenant id or a system key
bool validTenantAccess(MutationRef m, std::map<int64_t, TenantName> const& tenantMap, Optional<int64_t>& tenantId) {
	if (isSingleKeyMutation((MutationRef::Type)m.type)) {
		tenantId = TenantAPI::extractTenantIdFromMutation(m);
		bool isLegalTenant = tenantMap.contains(tenantId.get());
		CODE_PROBE(!isLegalTenant, "Commit proxy access invalid tenant");
		return isLegalTenant;
	}
	return true;
}

// return an iterator to the first tenantId whose idToPrefix(id) >= prefix[0..8] in lexicographic order. If no such id,
// return tenantMap.end()
inline auto lowerBoundTenantId(const StringRef& prefix, const std::map<int64_t, TenantName>& tenantMap) {
	Optional<int64_t> id = TenantIdCodec::lowerBound(prefix.substr(0, std::min(prefix.size(), TenantAPI::PREFIX_SIZE)));
	return id.present() ? tenantMap.lower_bound(id.get()) : tenantMap.end();
}

															#line 4388 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
// This generated class is to be used only via flowTestCase1239()
															#line 1239 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
template <class FlowTestCase1239Actor>
															#line 1239 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class FlowTestCase1239ActorState {
															#line 4394 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
public:
															#line 1239 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	FlowTestCase1239ActorState(UnitTestParameters const& params) 
															#line 1239 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
															#line 1239 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		 : params(params)
															#line 4401 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase1239", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase1239ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase1239", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1240 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			int mapSize = 1000;
															#line 1241 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			std::map<int64_t, TenantName> tenantMap;
															#line 1242 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			for(int i = 0;i < mapSize;++i) {
															#line 1243 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				tenantMap[i * 2] = ""_sr;
															#line 4422 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			}
															#line 1246 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			int64_t tid = lowerBoundTenantId(""_sr, tenantMap)->first;
															#line 1247 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			ASSERT_EQ(tid, 0);
															#line 1249 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			auto it = lowerBoundTenantId("\xff"_sr, tenantMap);
															#line 1250 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			ASSERT(it == tenantMap.end());
															#line 1252 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			it = lowerBoundTenantId("\xff\x01\x02\x03\x04\x05\x06\x07\x08"_sr, tenantMap);
															#line 1253 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			ASSERT(it == tenantMap.end());
															#line 1255 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			it = lowerBoundTenantId("\x99\x01\x02\x03\x04\x05\x06\x07\x08"_sr, tenantMap);
															#line 1256 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			ASSERT(it == tenantMap.end());
															#line 1258 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			int64_t targetId = deterministicRandom()->randomInt64(0, mapSize) * 2;
															#line 1259 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			Key prefix = TenantAPI::idToPrefix(targetId);
															#line 1260 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			tid = lowerBoundTenantId(prefix, tenantMap)->first;
															#line 1261 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			ASSERT_EQ(tid, targetId);
															#line 1263 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			tid = lowerBoundTenantId(prefix.withSuffix("any"_sr), tenantMap)->first;
															#line 1264 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			ASSERT_EQ(tid, targetId);
															#line 1266 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			targetId = deterministicRandom()->randomInt64(1, mapSize) * 2;
															#line 1267 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			prefix = TenantAPI::idToPrefix(targetId - 1);
															#line 1268 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			tid = lowerBoundTenantId(prefix, tenantMap)->first;
															#line 1269 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			ASSERT_EQ(tid, targetId);
															#line 1271 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			targetId = deterministicRandom()->randomInt64(mapSize * 2, mapSize * 3);
															#line 1272 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			prefix = TenantAPI::idToPrefix(targetId);
															#line 1273 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			it = lowerBoundTenantId(prefix, tenantMap);
															#line 1274 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			ASSERT(it == tenantMap.end());
															#line 1276 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			targetId = deterministicRandom()->randomInt64((int64_t)1 << 32, std::numeric_limits<int64_t>::max());
															#line 1277 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			tenantMap[targetId] = ""_sr;
															#line 1278 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			prefix = TenantAPI::idToPrefix(targetId);
															#line 1279 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			int shift = deterministicRandom()->randomInt(0, TenantAPI::PREFIX_SIZE / 2);
															#line 1280 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			prefix = prefix.substr(0, TenantAPI::PREFIX_SIZE - shift);
															#line 1281 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			tid = lowerBoundTenantId(prefix, tenantMap)->first;
															#line 1282 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			ASSERT_EQ(tid, targetId);
															#line 1284 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (!static_cast<FlowTestCase1239Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase1239ActorState(); static_cast<FlowTestCase1239Actor*>(this)->destroy(); return 0; }
															#line 4484 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			new (&static_cast<FlowTestCase1239Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase1239ActorState();
			static_cast<FlowTestCase1239Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase1239ActorState();
		static_cast<FlowTestCase1239Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 1239 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	UnitTestParameters params;
															#line 4508 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase1239()
															#line 1239 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class FlowTestCase1239Actor final : public Actor<Void>, public FastAllocated<FlowTestCase1239Actor>, public FlowTestCase1239ActorState<FlowTestCase1239Actor> {
															#line 4513 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase1239Actor>::operator new;
	using FastAllocated<FlowTestCase1239Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12185328403205152000UL, 12444831763829248768UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 1239 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	FlowTestCase1239Actor(UnitTestParameters const& params) 
															#line 4529 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase1239ActorState<FlowTestCase1239Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase1239", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14938408229867687424UL, 10754008880962996224UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1239Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase1239");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase1239", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
															#line 1239 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
static Future<Void> flowTestCase1239( UnitTestParameters const& params ) {
															#line 1239 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	return Future<Void>(new FlowTestCase1239Actor(params));
															#line 4560 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase1239, "/CommitProxy/SplitRange/LowerBoundTenantId")

#line 1286 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"

// Given a clear range [a, b), make a vector of clear range mutations split by tenant boundary [a, t0_end), [t1_begin,
// t1_end), ... [tn_begin, b); The references are allocated on arena;
std::vector<MutationRef> splitClearRangeByTenant(Arena& arena,
                                                 const MutationRef& mutation,
                                                 const std::map<int64_t, TenantName>& tenantMap,
                                                 std::vector<int64_t>* tenantIds = nullptr) {
	std::vector<MutationRef> results;
	auto it = lowerBoundTenantId(mutation.param1, tenantMap);
	while (it != tenantMap.end()) {
		if (tenantIds != nullptr) {
			tenantIds->push_back(it->first);
		}
		KeyRef tPrefix = TenantAPI::idToPrefix(arena, it->first);
		if (tPrefix >= mutation.param2) {
			break;
		}

		// max(tenant_begin, range begin)
		KeyRef param1 = tPrefix >= mutation.param1 ? tPrefix : mutation.param1;

		// min(tenant end, range end)
		KeyRef param2 = strinc(tPrefix, arena);
		if (param2 >= mutation.param2) {
			param2 = mutation.param2;
			results.emplace_back(MutationRef::ClearRange, param1, param2);
			break;
		}
		results.emplace_back(MutationRef::ClearRange, param1, param2);
		++it;
	}

	if (KeyRangeRef(mutation.param1, mutation.param2).intersects(systemKeys)) {
		results.emplace_back(MutationRef::ClearRange,
		                     std::max(mutation.param1, systemKeys.begin),
		                     std::min(mutation.param2, systemKeys.end));
	}

	return results;
}

															#line 4606 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
// This generated class is to be used only via flowTestCase1327()
															#line 1327 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
template <class FlowTestCase1327Actor>
															#line 1327 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class FlowTestCase1327ActorState {
															#line 4612 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
public:
															#line 1327 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	FlowTestCase1327ActorState(UnitTestParameters const& params) 
															#line 1327 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
															#line 1327 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		 : params(params)
															#line 4619 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase1327", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase1327ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase1327", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1328 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			int mapSize = 1000;
															#line 1329 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			std::map<int64_t, TenantName> tenantMap;
															#line 1330 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			for(int i = 0;i < mapSize;++i) {
															#line 1331 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				tenantMap[i * 2] = ""_sr;
															#line 4640 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			}
															#line 1335 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			Arena arena(15 << 10);
															#line 1336 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			int64_t tenantId = deterministicRandom()->randomInt64(0, mapSize) * 2;
															#line 1337 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			KeyRef prefix = TenantAPI::idToPrefix(arena, tenantId);
															#line 1338 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			KeyRef param1 = prefix.withSuffix("a"_sr, arena);
															#line 1339 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			KeyRef param2 = prefix.withSuffix("b"_sr, arena);
															#line 1340 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			MutationRef mutation(MutationRef::ClearRange, param1, param2);
															#line 1341 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			std::vector<MutationRef> result = splitClearRangeByTenant(arena, mutation, tenantMap);
															#line 1342 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			ASSERT_EQ(result.size(), 1);
															#line 1343 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			ASSERT(result.front().param1 == param1);
															#line 1344 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			ASSERT(result.front().param2 == param2);
															#line 1347 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			int64_t tid1 = deterministicRandom()->randomInt64(0, mapSize - 2);
															#line 1348 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			int64_t tid2 = deterministicRandom()->randomInt64(tid1 + 2, mapSize) * 2;
															#line 1349 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			tid1 *= 2;
															#line 1350 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			KeyRef prefix1 = TenantAPI::idToPrefix(arena, tid1);
															#line 1351 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			param1 = deterministicRandom()->coinflip() ? prefix1 : prefix1.withSuffix("a"_sr, arena);
															#line 1352 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			KeyRef prefix2 = TenantAPI::idToPrefix(arena, tid2);
															#line 1353 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			bool tailAligned = deterministicRandom()->coinflip();
															#line 1354 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			param2 = tailAligned ? prefix2 : prefix2.withSuffix("b"_sr, arena);
															#line 1355 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			int targetSize = (tid2 - tid1) / 2 + (!tailAligned);
															#line 1356 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			mutation.param1 = param1;
															#line 1357 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			mutation.param2 = param2;
															#line 1358 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			result = splitClearRangeByTenant(arena, mutation, tenantMap);
															#line 1359 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			ASSERT_EQ(result.size(), targetSize);
															#line 1360 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			ASSERT(result.front().param1 == param1);
															#line 1361 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (tailAligned)
															#line 4692 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			{
															#line 1362 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				KeyRange r = prefixRange(TenantAPI::idToPrefix(tid2 - 2));
															#line 1363 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				ASSERT(r == KeyRangeRef(result.back().param1, result.back().param2));
															#line 4698 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			}
			else
			{
															#line 1365 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				ASSERT(result.back().param1 == prefix2);
															#line 1366 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				ASSERT(result.back().param2 == param2);
															#line 4706 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			}
															#line 1370 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			targetSize = mapSize - tid1 / 2 + 1;
															#line 1371 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			Key randomSysKey = systemKeys.begin.withSuffix("sf"_sr, arena);
															#line 1372 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			mutation.param2 = randomSysKey;
															#line 1373 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			result = splitClearRangeByTenant(arena, mutation, tenantMap);
															#line 1374 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			ASSERT_EQ(result.size(), targetSize);
															#line 1375 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			ASSERT(result.back().param1 == systemKeys.begin);
															#line 1376 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			ASSERT(result.back().param2 == randomSysKey);
															#line 1379 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			Key sysKey1 = systemKeys.begin.withSuffix("a"_sr, arena);
															#line 1380 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			mutation.param1 = sysKey1;
															#line 1381 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			result = splitClearRangeByTenant(arena, mutation, tenantMap);
															#line 1382 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			ASSERT_EQ(result.size(), 1);
															#line 1383 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			ASSERT(result.front().param1 == sysKey1);
															#line 1384 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			ASSERT(result.front().param2 == randomSysKey);
															#line 1387 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			tenantMap.clear();
															#line 1388 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			mutation.param1 = prefix.withSuffix("a"_sr, arena);
															#line 1389 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			mutation.param2 = prefix.withSuffix("b"_sr, arena);
															#line 1390 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			result = splitClearRangeByTenant(arena, mutation, tenantMap);
															#line 1391 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			ASSERT(result.empty());
															#line 1392 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (!static_cast<FlowTestCase1327Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase1327ActorState(); static_cast<FlowTestCase1327Actor*>(this)->destroy(); return 0; }
															#line 4746 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			new (&static_cast<FlowTestCase1327Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase1327ActorState();
			static_cast<FlowTestCase1327Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase1327ActorState();
		static_cast<FlowTestCase1327Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 1327 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	UnitTestParameters params;
															#line 4770 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase1327()
															#line 1327 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class FlowTestCase1327Actor final : public Actor<Void>, public FastAllocated<FlowTestCase1327Actor>, public FlowTestCase1327ActorState<FlowTestCase1327Actor> {
															#line 4775 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase1327Actor>::operator new;
	using FastAllocated<FlowTestCase1327Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16631874727886241792UL, 10075416837535928064UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 1327 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	FlowTestCase1327Actor(UnitTestParameters const& params) 
															#line 4791 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase1327ActorState<FlowTestCase1327Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase1327", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10564678164647521280UL, 16783740284380891648UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1327Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase1327");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase1327", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
															#line 1327 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
static Future<Void> flowTestCase1327( UnitTestParameters const& params ) {
															#line 1327 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	return Future<Void>(new FlowTestCase1327Actor(params));
															#line 4822 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase1327, "/CommitProxy/SplitRange/SplitClearRangeByTenant")

#line 1394 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"

// If the splitMutations is not empty, which means some clear range in mutations are split into multiple clear range
// ops. Modify mutations by replace the old clear range with the split clear ranges
void replaceRawClearRanges(Arena& arena,
                           VectorRef<MutationRef>& mutations,
                           std::vector<std::pair<int, std::vector<MutationRef>>>& splitMutations,
                           size_t totalSize,
                           Optional<UID> debugId = Optional<UID>()) {
	if (splitMutations.empty())
		return;

	int i = mutations.size() - 1;
	mutations.resize(arena, totalSize);
	// place from back
	int curr = totalSize - 1;
	for (; i >= 0; --i) {
		if (splitMutations.empty()) {
			ASSERT_EQ(curr, i);
			break;
		}

		if (splitMutations.back().first == i) {
			ASSERT_EQ(mutations[i].type, MutationRef::ClearRange);
			// replace with tenant aligned mutations
			auto& currMutations = splitMutations.back().second;
			while (!currMutations.empty()) {
				mutations[curr] = currMutations.back();
				currMutations.pop_back();
				curr--;
			}
			splitMutations.pop_back();
		} else {
			ASSERT_GT(curr, i);
			mutations[curr] = mutations[i];
			curr--;
		}
	}

	ASSERT_EQ(splitMutations.size(), 0);
}

// split clear range mutation according to tenantMap. If the original mutation is split to multiple mutations, push the
// mutation offset and the split ones into idxSplitMutations
size_t processClearRangeMutation(Arena& arena,
                                 const std::map<int64_t, TenantName>& tenantMap,
                                 MutationRef& mutation,
                                 int mutationIdx,
                                 int& newMutationSize,
                                 std::vector<std::pair<int, std::vector<MutationRef>>>& idxSplitMutations,
                                 std::vector<int64_t>* tenantIds = nullptr) {
	std::vector<MutationRef> newClears = splitClearRangeByTenant(arena, mutation, tenantMap, tenantIds);
	if (newClears.size() == 1) {
		mutation = newClears[0];
	} else if (newClears.size() > 1) {
		CODE_PROBE(true, "Clear Range raw access or cross multiple tenants");
		idxSplitMutations.emplace_back(mutationIdx, newClears);
		newMutationSize += newClears.size() - 1;
	} else {
		mutation.type = MutationRef::NoOp;
	}
	return newClears.size();
}

															#line 4890 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
// This generated class is to be used only via flowTestCase1457()
															#line 1457 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
template <class FlowTestCase1457Actor>
															#line 1457 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class FlowTestCase1457ActorState {
															#line 4896 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
public:
															#line 1457 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	FlowTestCase1457ActorState(UnitTestParameters const& params) 
															#line 1457 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
															#line 1457 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		 : params(params)
															#line 4903 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase1457", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase1457ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase1457", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1458 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			int mapSize = 1000;
															#line 1459 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			std::map<int64_t, TenantName> tenantMap;
															#line 1460 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			for(int i = 0;i < mapSize;++i) {
															#line 1461 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				tenantMap[i * 2] = ""_sr;
															#line 4924 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			}
															#line 1464 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			Arena arena(15 << 10);
															#line 1465 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			VectorRef<MutationRef> mutations;
															#line 1466 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			VectorRef<MutationRef> targetMutations;
															#line 1467 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			mutations.emplace_back_deep(arena, MutationRef::SetValue, "0"_sr, ""_sr);
															#line 1468 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			targetMutations.emplace_back_deep(arena, MutationRef::SetValue, "0"_sr, ""_sr);
															#line 1470 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			int64_t tenantId = deterministicRandom()->randomInt64(0, mapSize) * 2;
															#line 1471 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			KeyRef prefix = TenantAPI::idToPrefix(arena, tenantId);
															#line 1472 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			KeyRef param1 = prefix.withSuffix("a"_sr, arena);
															#line 1473 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			KeyRef param2 = prefix.withSuffix("b"_sr, arena);
															#line 1474 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			mutations.emplace_back(arena, MutationRef::ClearRange, param1, param2);
															#line 1475 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			targetMutations.emplace_back_deep(arena, MutationRef::ClearRange, param1, param2);
															#line 1478 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			mutations.emplace_back_deep(arena, MutationRef::SetValue, "1"_sr, ""_sr);
															#line 1479 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			targetMutations.emplace_back_deep(arena, MutationRef::SetValue, "1"_sr, ""_sr);
															#line 1482 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			int64_t tid1 = deterministicRandom()->randomInt64(0, mapSize - 1) * 2;
															#line 1483 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			KeyRef prefix1 = TenantAPI::idToPrefix(arena, tid1);
															#line 1484 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			param1 = deterministicRandom()->coinflip() ? prefix1 : prefix1.withSuffix("a"_sr, arena);
															#line 1486 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			int targetSize = mapSize - tid1 / 2 + 1;
															#line 1487 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			Key randomSysKey = systemKeys.begin.withSuffix("sf"_sr, arena);
															#line 1488 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			mutations.emplace_back(arena, MutationRef::ClearRange, param1, randomSysKey);
															#line 1489 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			auto sMutations = splitClearRangeByTenant(arena, mutations.back(), tenantMap);
															#line 1490 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			ASSERT_EQ(targetSize, sMutations.size());
															#line 1491 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			targetMutations.append(arena, sMutations.begin(), sMutations.size());
															#line 1494 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			mutations.emplace_back_deep(arena, MutationRef::SetValue, "3"_sr, ""_sr);
															#line 1495 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			targetMutations.emplace_back_deep(arena, MutationRef::SetValue, "3"_sr, ""_sr);
															#line 1498 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			std::vector<std::pair<int, std::vector<MutationRef>>> idxSplitMutations;
															#line 1499 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			int newMutationSize = mutations.size();
															#line 1500 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			for(int i = 0;i < mutations.size();++i) {
															#line 1501 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (mutations[i].type == MutationRef::ClearRange)
															#line 4982 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
				{
															#line 1502 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					processClearRangeMutation(arena, tenantMap, mutations[i], i, newMutationSize, idxSplitMutations);
															#line 4986 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
				}
			}
															#line 1506 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			replaceRawClearRanges(arena, mutations, idxSplitMutations, newMutationSize);
															#line 1508 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			ASSERT_EQ(mutations.size(), targetMutations.size());
															#line 1509 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			for(int i = 0;i < mutations.size();++i) {
															#line 1510 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				ASSERT_EQ(targetMutations[i].type, mutations[i].type);
															#line 1511 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				ASSERT(targetMutations[i].param1 == mutations[i].param1);
															#line 1512 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				ASSERT(targetMutations[i].param2 == mutations[i].param2);
															#line 5001 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			}
															#line 1514 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (!static_cast<FlowTestCase1457Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase1457ActorState(); static_cast<FlowTestCase1457Actor*>(this)->destroy(); return 0; }
															#line 5005 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			new (&static_cast<FlowTestCase1457Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase1457ActorState();
			static_cast<FlowTestCase1457Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase1457ActorState();
		static_cast<FlowTestCase1457Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 1457 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	UnitTestParameters params;
															#line 5029 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase1457()
															#line 1457 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class FlowTestCase1457Actor final : public Actor<Void>, public FastAllocated<FlowTestCase1457Actor>, public FlowTestCase1457ActorState<FlowTestCase1457Actor> {
															#line 5034 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase1457Actor>::operator new;
	using FastAllocated<FlowTestCase1457Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13158429185785412352UL, 1865961249402829056UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 1457 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	FlowTestCase1457Actor(UnitTestParameters const& params) 
															#line 5050 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase1457ActorState<FlowTestCase1457Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase1457", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18098089614306115584UL, 8348412194066376704UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1457Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase1457");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase1457", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
															#line 1457 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
static Future<Void> flowTestCase1457( UnitTestParameters const& params ) {
															#line 1457 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	return Future<Void>(new FlowTestCase1457Actor(params));
															#line 5081 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase1457, "/CommitProxy/SplitRange/replaceRawClearRanges")

#line 1516 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"

// Return success and properly split clear range mutations if all tenant check pass. Otherwise, return corresponding
// error
Error validateAndProcessTenantAccess(Arena& arena,
                                     VectorRef<MutationRef>& mutations,
                                     ProxyCommitData* const pProxyCommitData,
                                     std::unordered_set<int64_t>& rawAccessTenantIds,
                                     Optional<UID> debugId = Optional<UID>(),
                                     const char* context = "") {
	bool changeTenant = false;
	bool writeNormalKey = false;
	std::vector<int64_t> tids; // tenant ids accessed by the raw access transaction

	std::vector<std::pair<int, std::vector<MutationRef>>> idxSplitMutations;
	int newMutationSize = mutations.size();
	KeyRangeRef tenantMapRange = TenantMetadata::tenantMap().subspace;
	for (int i = 0; i < mutations.size(); ++i) {
		auto& mutation = mutations[i];
		Optional<int64_t> tenantId;
		bool validAccess = true;
		changeTenant = changeTenant || TenantAPI::tenantMapChanging(mutation, tenantMapRange);

		if (mutation.type == MutationRef::ClearRange) {
			int newClearSize = processClearRangeMutation(
			    arena, pProxyCommitData->tenantMap, mutation, i, newMutationSize, idxSplitMutations, &tids);

			if (debugId.present()) {
				DisabledTraceEvent(SevDebug, "SplitTenantClearRange", pProxyCommitData->dbgid)
				    .detail("TxnId", debugId)
				    .detail("Idx", i)
				    .detail("TenantMap", pProxyCommitData->tenantMap.size())
				    .detail("NewMutationSize", newMutationSize)
				    .detail("OldMutationSize", mutations.size())
				    .detail("NewClears", newClearSize);
			}
		} else if (!isSystemKey(mutation.param1)) {
			validAccess = validTenantAccess(mutation, pProxyCommitData->tenantMap, tenantId);
			writeNormalKey = true;
		}

		if (debugId.present()) {
			DisabledTraceEvent(SevDebug, "ValidateAndProcessTenantAccess", pProxyCommitData->dbgid)
			    .detail("Context", context)
			    .detail("TxnId", debugId)
			    .detail("Version", pProxyCommitData->version.get())
			    .detail("ChangeTenant", changeTenant)
			    .detail("WriteNormalKey", writeNormalKey)
			    .detail("TenantId", tenantId)
			    .detail("ValidAccess", validAccess)
			    .detail("MutationType", getTypeString(mutation.type))
			    .detail("Mutation1", mutation.param1)
			    .detail("Mutation2", mutation.param2);
		}

		if (!validAccess) {
			TraceEvent(SevWarn, "IllegalTenantAccess", pProxyCommitData->dbgid)
			    .suppressFor(10.0)
			    .detail("Reason", "Raw write to unknown tenant");
			return illegal_tenant_access();
		}

		if (writeNormalKey && changeTenant) {
			TraceEvent(SevWarn, "IllegalTenantAccess", pProxyCommitData->dbgid)
			    .suppressFor(10.0)
			    .detail("Reason", "Tenant change and normal key write in same transaction");
			CODE_PROBE(true, "Writing normal keys while changing the tenant map");
			return illegal_tenant_access();
		}
		if (tenantId.present()) {
			ASSERT(tenantId.get() != TenantInfo::INVALID_TENANT);
			tids.push_back(tenantId.get());
		}
	}
	rawAccessTenantIds.insert(tids.begin(), tids.end());

	replaceRawClearRanges(arena, mutations, idxSplitMutations, newMutationSize);
	return success();
}

// If the validation success, return the list of tenant Ids referred by the transaction via tenantIds.
Error validateAndProcessTenantAccess(CommitTransactionRequest& tr,
                                     ProxyCommitData* const pProxyCommitData,
                                     std::unordered_set<int64_t>& rawAccessTenantIds) {
	bool isValid = checkTenantNoWait(pProxyCommitData, tr.tenantInfo.tenantId, "Commit", true);
	if (!isValid) {
		return tenant_not_found();
	}
	if (!tr.isLockAware() && pProxyCommitData->lockedTenants.contains(tr.tenantInfo.tenantId)) {
		CODE_PROBE(true, "Attempt access to locked tenant without lock awareness");
		return tenant_locked();
	}

	// only do the mutation check when the transaction use raw_access option and the tenant mode is required
	if (pProxyCommitData->getTenantMode() != TenantMode::REQUIRED || tr.tenantInfo.hasTenant()) {
		if (tr.tenantInfo.hasTenant()) {
			rawAccessTenantIds.insert(tr.tenantInfo.tenantId);
		}
		return success();
	}

	return validateAndProcessTenantAccess(tr.arena,
	                                      tr.transaction.mutations,
	                                      pProxyCommitData,
	                                      rawAccessTenantIds,
	                                      tr.debugID,
	                                      "validateAndProcessTenantAccess");
}

// Compute and apply "metadata" effects of each other proxy's most recent batch
void applyMetadataEffect(CommitBatchContext* self) {
	bool initialState = self->isMyFirstBatch;
	self->firstStateMutations = self->isMyFirstBatch;
	KeyRangeRef tenantMapRange = TenantMetadata::tenantMap().subspace;
	for (int versionIndex = 0; versionIndex < self->resolution[0].stateMutations.size(); versionIndex++) {
		// pProxyCommitData->logAdapter->setNextVersion( ??? );  << Ideally we would be telling the log adapter that the
		// pushes in this commit will be in the version at which these state mutations were committed by another proxy,
		// but at present we don't have that information here.  So the disk queue may be unnecessarily conservative
		// about popping.

		for (int transactionIndex = 0;
		     transactionIndex < self->resolution[0].stateMutations[versionIndex].size() && !self->forceRecovery;
		     transactionIndex++) {
			bool committed = true;
			for (int resolver = 0; resolver < self->resolution.size(); resolver++) {
				committed =
				    committed && self->resolution[resolver].stateMutations[versionIndex][transactionIndex].committed;
			}

			if (committed && self->pProxyCommitData->getTenantMode() == TenantMode::REQUIRED) {
				auto& tenantIds = self->resolution[0].stateMutations[versionIndex][transactionIndex].tenantIds;
				ASSERT(tenantIds.present());
				// fail transaction if it contain both of tenant changes and normal key writing
				auto& mutations = self->resolution[0].stateMutations[versionIndex][transactionIndex].mutations;
				committed =
				    tenantIds.get().empty() || std::none_of(mutations.begin(), mutations.end(), [&](MutationRef m) {
					    return TenantAPI::tenantMapChanging(m, tenantMapRange);
				    });

				// check if all tenant ids are valid if committed == true
				committed = committed &&
				            std::all_of(tenantIds.get().begin(), tenantIds.get().end(), [self](const int64_t& tid) {
					            return self->pProxyCommitData->tenantMap.contains(tid);
				            });

				if (self->debugID.present()) {
					TraceEvent(SevDebug, "TenantAccessCheck_ApplyMetadataEffect", self->debugID.get())
					    .detail("TenantIds", tenantIds)
					    .detail("Mutations", mutations);
				}
			}

			if (committed) {
				// Note: since we are not to commit, we don't need to pass cipherKeys for encryption.
				applyMetadataMutations(SpanContext(),
				                       *self->pProxyCommitData,
				                       self->arena,
				                       self->pProxyCommitData->logSystem,
				                       self->resolution[0].stateMutations[versionIndex][transactionIndex].mutations,
				                       /* pToCommit= */ nullptr,
				                       /* pCipherKeys= */ nullptr,
				                       EncryptionAtRestMode::DISABLED,
				                       self->forceRecovery,
				                       /* version= */ self->commitVersion,
				                       /* popVersion= */ 0,
				                       /* initialCommit */ false,
				                       /* provisionalCommitProxy */ self->pProxyCommitData->provisional);
			}

			if (self->resolution[0].stateMutations[versionIndex][transactionIndex].mutations.size() &&
			    self->firstStateMutations) {
				ASSERT(committed);
				self->firstStateMutations = false;
				self->forceRecovery = false;
			}
		}

		// These changes to txnStateStore will be committed by the other proxy, so we simply discard the commit message
		auto fcm = self->pProxyCommitData->logAdapter->getCommitMessage();
		self->storeCommits.emplace_back(fcm, self->pProxyCommitData->txnStateStore->commit());

		if (initialState) {
			initialState = false;
			self->forceRecovery = false;
			self->pProxyCommitData->txnStateStore->resyncLog();

			for (auto& p : self->storeCommits) {
				ASSERT(!p.second.isReady());
				p.first.get().acknowledge.send(Void());
				ASSERT(p.second.isReady());
			}
			self->storeCommits.clear();
		}
	}
}

/// Determine which transactions actually committed (conservatively) by combining results from the resolvers
void determineCommittedTransactions(CommitBatchContext* self) {
	auto pProxyCommitData = self->pProxyCommitData;
	const auto& trs = self->trs;

	ASSERT(self->transactionResolverMap.size() == self->committed.size());
	// For each commitTransactionRef, it is only sent to resolvers specified in transactionResolverMap
	// Thus, we use this nextTr to track the correct transaction index on each resolver.
	self->nextTr.resize(self->resolution.size());
	for (int t = 0; t < trs.size(); t++) {
		uint8_t commit = ConflictBatch::TransactionCommitted;
		for (int r : self->transactionResolverMap[t]) {
			commit = std::min(self->resolution[r].committed[self->nextTr[r]++], commit);
		}
		self->committed[t] = commit;
	}
	for (int r = 0; r < self->resolution.size(); r++)
		ASSERT(self->nextTr[r] == self->resolution[r].committed.size());

	pProxyCommitData->logAdapter->setNextVersion(self->commitVersion);

	self->lockedKey = pProxyCommitData->txnStateStore->readValue(databaseLockedKey).get();
	self->locked = self->lockedKey.present() && self->lockedKey.get().size();

	const Optional<Value> mustContainSystemKey =
	    pProxyCommitData->txnStateStore->readValue(mustContainSystemMutationsKey).get();
	if (mustContainSystemKey.present() && mustContainSystemKey.get().size()) {
		for (int t = 0; t < trs.size(); t++) {
			if (self->committed[t] == ConflictBatch::TransactionCommitted) {
				bool foundSystem = false;
				for (auto& m : trs[t].transaction.mutations) {
					if ((m.type == MutationRef::ClearRange ? m.param2 : m.param1) >= nonMetadataSystemKeys.end) {
						foundSystem = true;
						break;
					}
				}
				if (!foundSystem) {
					self->committed[t] = ConflictBatch::TransactionConflict;
				}
			}
		}
	}
}

// This first pass through committed transactions deals with "metadata" effects (modifications of txnStateStore, changes
// to storage servers' responsibilities)
															#line 5327 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
// This generated class is to be used only via applyMetadataToCommittedTransactions()
															#line 1757 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
template <class ApplyMetadataToCommittedTransactionsActor>
															#line 1757 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class ApplyMetadataToCommittedTransactionsActorState {
															#line 5333 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
public:
															#line 1757 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ApplyMetadataToCommittedTransactionsActorState(CommitBatchContext* const& self) 
															#line 1757 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
															#line 1757 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		 : self(self),
															#line 1758 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   pProxyCommitData(self->pProxyCommitData),
															#line 1759 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   rawAccessTenantIds()
															#line 5344 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
	{
		fdb_probe_actor_create("applyMetadataToCommittedTransactions", reinterpret_cast<unsigned long>(this));

	}
	~ApplyMetadataToCommittedTransactionsActorState() 
	{
		fdb_probe_actor_destroy("applyMetadataToCommittedTransactions", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1760 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			auto& trs = self->trs;
															#line 1762 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			int t;
															#line 1763 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			for(t = 0;t < trs.size() && !self->forceRecovery;t++) {
															#line 1764 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				Error e = validateAndProcessTenantAccess(trs[t], pProxyCommitData, rawAccessTenantIds);
															#line 1765 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (e.code() != error_code_success)
															#line 5367 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
				{
															#line 1766 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					trs[t].reply.sendError(e);
															#line 1767 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					self->committed[t] = ConflictBatch::TransactionTenantFailure;
															#line 1768 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					CODE_PROBE(true, "Commit proxy transaction tenant failure");
															#line 5375 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
				}
				else
				{
															#line 1769 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					if (self->committed[t] == ConflictBatch::TransactionCommitted && (!self->locked || trs[t].isLockAware()))
															#line 5381 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
					{
															#line 1771 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						self->commitCount++;
															#line 1772 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						applyMetadataMutations(trs[t].spanContext, *pProxyCommitData, self->arena, pProxyCommitData->logSystem, trs[t].transaction.mutations, SERVER_KNOBS->PROXY_USE_RESOLVER_PRIVATE_MUTATIONS ? nullptr : &self->toCommit, &self->cipherKeys, pProxyCommitData->encryptMode, self->forceRecovery, self->commitVersion, self->commitVersion + 1, false, self->pProxyCommitData->provisional);
															#line 5387 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
					}
				}
															#line 1787 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (self->firstStateMutations)
															#line 5392 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
				{
															#line 1788 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					ASSERT(self->committed[t] == ConflictBatch::TransactionCommitted);
															#line 1789 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					self->firstStateMutations = false;
															#line 1790 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					self->forceRecovery = false;
															#line 5400 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
				}
			}
															#line 1794 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (self->forceRecovery)
															#line 5405 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			{
															#line 1795 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				for(;t < trs.size();t++) {
															#line 1796 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					self->committed[t] = ConflictBatch::TransactionConflict;
															#line 5411 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
				}
															#line 1797 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				TraceEvent(SevWarn, "RestartingTxnSubsystem", pProxyCommitData->dbgid).detail("Stage", "AwaitCommit");
															#line 5415 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			}
															#line 1799 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (SERVER_KNOBS->PROXY_USE_RESOLVER_PRIVATE_MUTATIONS)
															#line 5419 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			{
															#line 1802 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				ResolveTransactionBatchReply& reply = self->resolution[0];
															#line 1803 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				self->toCommit.setMutations(reply.privateMutationCount, reply.privateMutations);
															#line 1804 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (SERVER_KNOBS->ENABLE_VERSION_VECTOR_TLOG_UNICAST)
															#line 5427 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
				{
															#line 1806 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					self->tpcvMap = reply.tpcvMap;
															#line 1807 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					self->pProxyCommitData->lastShardMove = reply.lastShardMove;
															#line 1810 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					std::vector<int> fromLocations;
															#line 1811 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					fromLocations.reserve(reply.tpcvMap.size());
															#line 1812 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					for( const auto& pair : self->tpcvMap ) {
															#line 1813 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						fromLocations.push_back(pair.first);
															#line 5441 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
					}
															#line 1816 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					self->toCommit.setPushLocationsForTags(fromLocations);
															#line 5445 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
				}
															#line 1818 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				self->toCommit.addWrittenTags(reply.writtenTags);
															#line 5449 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			}
															#line 1821 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			self->lockedKey = pProxyCommitData->txnStateStore->readValue(databaseLockedKey).get();
															#line 1822 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			self->lockedAfter = self->lockedKey.present() && self->lockedKey.get().size();
															#line 1824 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			self->metadataVersionAfter = pProxyCommitData->txnStateStore->readValue(metadataVersionKey).get();
															#line 1826 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			auto fcm = pProxyCommitData->logAdapter->getCommitMessage();
															#line 1827 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			self->storeCommits.emplace_back(fcm, pProxyCommitData->txnStateStore->commit());
															#line 1828 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			pProxyCommitData->version.set(self->commitVersion);
															#line 1829 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (!pProxyCommitData->validState.isSet())
															#line 5465 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			{
															#line 1830 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				pProxyCommitData->validState.send(Void());
															#line 5469 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			}
															#line 1831 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			ASSERT(self->commitVersion);
															#line 1833 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (!self->isMyFirstBatch && pProxyCommitData->txnStateStore->readValue(coordinatorsKey).get().get() != self->previousCoordinators.get())
															#line 5475 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			{
															#line 1835 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				StrictFuture<Void> __when_expr_0 = brokenPromiseToNever(pProxyCommitData->db->get().clusterInterface.changeCoordinators.getReply( ChangeCoordinatorsRequest(pProxyCommitData->txnStateStore->readValue(coordinatorsKey).get().get(), self->pProxyCommitData->master.id())));
															#line 1835 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (static_cast<ApplyMetadataToCommittedTransactionsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5481 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<ApplyMetadataToCommittedTransactionsActor*>(this)->actor_wait_state = 1;
															#line 1835 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ApplyMetadataToCommittedTransactionsActor, 0, Void >*>(static_cast<ApplyMetadataToCommittedTransactionsActor*>(this)));
															#line 5486 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ApplyMetadataToCommittedTransactionsActorState();
		static_cast<ApplyMetadataToCommittedTransactionsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1843 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (pProxyCommitData->encryptMode == EncryptionAtRestMode::DOMAIN_AWARE && !rawAccessTenantIds.empty())
															#line 5514 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 1844 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			std::unordered_set<EncryptCipherDomainId> extraDomainIds;
															#line 1845 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			for( auto tenantId : rawAccessTenantIds ) {
															#line 1846 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (!self->cipherKeys.contains(tenantId))
															#line 5522 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
				{
															#line 1847 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					extraDomainIds.insert(tenantId);
															#line 5526 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
				}
			}
															#line 1850 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (!extraDomainIds.empty())
															#line 5531 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			{
															#line 1851 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				StrictFuture<std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>>> __when_expr_1 = GetEncryptCipherKeys<ServerDBInfo>::getLatestEncryptCipherKeys( pProxyCommitData->db, extraDomainIds, BlobCipherMetrics::TLOG_POST_RESOLUTION);
															#line 1851 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (static_cast<ApplyMetadataToCommittedTransactionsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5537 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
				static_cast<ApplyMetadataToCommittedTransactionsActor*>(this)->actor_wait_state = 2;
															#line 1851 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ApplyMetadataToCommittedTransactionsActor, 1, std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> >*>(static_cast<ApplyMetadataToCommittedTransactionsActor*>(this)));
															#line 5542 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont15(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont14(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont13(Void const& _,int loopDepth) 
	{
															#line 1838 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		ASSERT(false);
															#line 5561 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont13(Void && _,int loopDepth) 
	{
															#line 1838 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		ASSERT(false);
															#line 5570 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont13(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont13(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ApplyMetadataToCommittedTransactionsActor*>(this)->actor_wait_state > 0) static_cast<ApplyMetadataToCommittedTransactionsActor*>(this)->actor_wait_state = 0;
		static_cast<ApplyMetadataToCommittedTransactionsActor*>(this)->ActorCallback< ApplyMetadataToCommittedTransactionsActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ApplyMetadataToCommittedTransactionsActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("applyMetadataToCommittedTransactions", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ApplyMetadataToCommittedTransactionsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("applyMetadataToCommittedTransactions", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ApplyMetadataToCommittedTransactionsActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("applyMetadataToCommittedTransactions", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ApplyMetadataToCommittedTransactionsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("applyMetadataToCommittedTransactions", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ApplyMetadataToCommittedTransactionsActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("applyMetadataToCommittedTransactions", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ApplyMetadataToCommittedTransactionsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("applyMetadataToCommittedTransactions", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont14(int loopDepth) 
	{
															#line 1858 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!static_cast<ApplyMetadataToCommittedTransactionsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ApplyMetadataToCommittedTransactionsActorState(); static_cast<ApplyMetadataToCommittedTransactionsActor*>(this)->destroy(); return 0; }
															#line 5654 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		new (&static_cast<ApplyMetadataToCommittedTransactionsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ApplyMetadataToCommittedTransactionsActorState();
		static_cast<ApplyMetadataToCommittedTransactionsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont15(int loopDepth) 
	{
		loopDepth = a_body1cont14(loopDepth);

		return loopDepth;
	}
	int a_body1cont18(std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> const& extraCipherKeys,int loopDepth) 
	{
															#line 1854 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->cipherKeys.insert(extraCipherKeys.begin(), extraCipherKeys.end());
															#line 5672 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		loopDepth = a_body1cont15(loopDepth);

		return loopDepth;
	}
	int a_body1cont18(std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> && extraCipherKeys,int loopDepth) 
	{
															#line 1854 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->cipherKeys.insert(extraCipherKeys.begin(), extraCipherKeys.end());
															#line 5681 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		loopDepth = a_body1cont15(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> const& extraCipherKeys,int loopDepth) 
	{
		loopDepth = a_body1cont18(extraCipherKeys, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> && extraCipherKeys,int loopDepth) 
	{
		loopDepth = a_body1cont18(std::move(extraCipherKeys), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ApplyMetadataToCommittedTransactionsActor*>(this)->actor_wait_state > 0) static_cast<ApplyMetadataToCommittedTransactionsActor*>(this)->actor_wait_state = 0;
		static_cast<ApplyMetadataToCommittedTransactionsActor*>(this)->ActorCallback< ApplyMetadataToCommittedTransactionsActor, 1, std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> >::remove();

	}
	void a_callback_fire(ActorCallback< ApplyMetadataToCommittedTransactionsActor, 1, std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> >*,std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> const& value) 
	{
		fdb_probe_actor_enter("applyMetadataToCommittedTransactions", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ApplyMetadataToCommittedTransactionsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("applyMetadataToCommittedTransactions", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ApplyMetadataToCommittedTransactionsActor, 1, std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> >*,std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> && value) 
	{
		fdb_probe_actor_enter("applyMetadataToCommittedTransactions", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ApplyMetadataToCommittedTransactionsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("applyMetadataToCommittedTransactions", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ApplyMetadataToCommittedTransactionsActor, 1, std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> >*,Error err) 
	{
		fdb_probe_actor_enter("applyMetadataToCommittedTransactions", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ApplyMetadataToCommittedTransactionsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("applyMetadataToCommittedTransactions", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1757 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	CommitBatchContext* self;
															#line 1758 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ProxyCommitData* const pProxyCommitData;
															#line 1759 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	std::unordered_set<int64_t> rawAccessTenantIds;
															#line 5767 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
};
// This generated class is to be used only via applyMetadataToCommittedTransactions()
															#line 1757 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class ApplyMetadataToCommittedTransactionsActor final : public Actor<Void>, public ActorCallback< ApplyMetadataToCommittedTransactionsActor, 0, Void >, public ActorCallback< ApplyMetadataToCommittedTransactionsActor, 1, std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> >, public FastAllocated<ApplyMetadataToCommittedTransactionsActor>, public ApplyMetadataToCommittedTransactionsActorState<ApplyMetadataToCommittedTransactionsActor> {
															#line 5772 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
public:
	using FastAllocated<ApplyMetadataToCommittedTransactionsActor>::operator new;
	using FastAllocated<ApplyMetadataToCommittedTransactionsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5932500156913404672UL, 8956068439499345920UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ApplyMetadataToCommittedTransactionsActor, 0, Void >;
friend struct ActorCallback< ApplyMetadataToCommittedTransactionsActor, 1, std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> >;
															#line 1757 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ApplyMetadataToCommittedTransactionsActor(CommitBatchContext* const& self) 
															#line 5790 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		 : Actor<Void>(),
		   ApplyMetadataToCommittedTransactionsActorState<ApplyMetadataToCommittedTransactionsActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("applyMetadataToCommittedTransactions", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6741896898587633920UL, 3623984856983436288UL);
		ActorExecutionContextHelper __helper(static_cast<ApplyMetadataToCommittedTransactionsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("applyMetadataToCommittedTransactions");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("applyMetadataToCommittedTransactions", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ApplyMetadataToCommittedTransactionsActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ApplyMetadataToCommittedTransactionsActor, 1, std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1757 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
[[nodiscard]] Future<Void> applyMetadataToCommittedTransactions( CommitBatchContext* const& self ) {
															#line 1757 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	return Future<Void>(new ApplyMetadataToCommittedTransactionsActor(self));
															#line 5823 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
}

#line 1860 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"

															#line 5828 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
// This generated class is to be used only via writeMutationEncryptedMutation()
															#line 1861 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
template <class WriteMutationEncryptedMutationActor>
															#line 1861 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class WriteMutationEncryptedMutationActorState {
															#line 5834 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
public:
															#line 1861 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	WriteMutationEncryptedMutationActorState(CommitBatchContext* const& self,int64_t const& tenantId,const MutationRef* const& mutation,Optional<MutationRef>* const& encryptedMutationOpt,Arena* const& arena) 
															#line 1861 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
															#line 1861 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		 : self(self),
															#line 1861 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   tenantId(tenantId),
															#line 1861 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   mutation(mutation),
															#line 1861 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   encryptedMutationOpt(encryptedMutationOpt),
															#line 1861 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   arena(arena),
															#line 1866 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   encryptedMutation(encryptedMutationOpt->get()),
															#line 1867 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   headerRef(),
															#line 1868 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   decryptedMutation()
															#line 5855 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
	{
		fdb_probe_actor_create("writeMutationEncryptedMutation", reinterpret_cast<unsigned long>(this));

	}
	~WriteMutationEncryptedMutationActorState() 
	{
		fdb_probe_actor_destroy("writeMutationEncryptedMutation", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1870 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			static_assert(TenantInfo::INVALID_TENANT == INVALID_ENCRYPT_DOMAIN_ID);
															#line 1871 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			ASSERT(self->pProxyCommitData->encryptMode.isEncryptionEnabled());
															#line 1872 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			ASSERT(g_network && g_network->isSimulated());
															#line 1874 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			ASSERT(encryptedMutation.isEncrypted());
															#line 1875 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			Reference<AsyncVar<ServerDBInfo> const> dbInfo = self->pProxyCommitData->db;
															#line 1876 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			headerRef = encryptedMutation.configurableEncryptionHeader();
															#line 1877 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			StrictFuture<TextAndHeaderCipherKeys> __when_expr_0 = GetEncryptCipherKeys<ServerDBInfo>::getEncryptCipherKeys( dbInfo, headerRef, BlobCipherMetrics::TLOG, self->pProxyCommitData->encryptionMonitor);
															#line 1877 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (static_cast<WriteMutationEncryptedMutationActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5884 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<WriteMutationEncryptedMutationActor*>(this)->actor_wait_state = 1;
															#line 1877 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WriteMutationEncryptedMutationActor, 0, TextAndHeaderCipherKeys >*>(static_cast<WriteMutationEncryptedMutationActor*>(this)));
															#line 5889 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WriteMutationEncryptedMutationActorState();
		static_cast<WriteMutationEncryptedMutationActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(TextAndHeaderCipherKeys const& cipherKeys,int loopDepth) 
	{
															#line 1879 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		decryptedMutation = encryptedMutation.decrypt(cipherKeys, *arena, BlobCipherMetrics::TLOG);
															#line 1881 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		ASSERT(decryptedMutation.type == mutation->type);
															#line 1882 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		ASSERT(decryptedMutation.param1 == mutation->param1);
															#line 1883 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		ASSERT(decryptedMutation.param2 == mutation->param2);
															#line 1885 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		CODE_PROBE(true, "encrypting non-metadata mutations", probe::decoration::rare);
															#line 1886 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->toCommit.writeTypedMessage(encryptedMutation);
															#line 1887 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!static_cast<WriteMutationEncryptedMutationActor*>(this)->SAV<WriteMutationRefVar>::futures) { (void)(encryptedMutation); this->~WriteMutationEncryptedMutationActorState(); static_cast<WriteMutationEncryptedMutationActor*>(this)->destroy(); return 0; }
															#line 5924 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		new (&static_cast<WriteMutationEncryptedMutationActor*>(this)->SAV< WriteMutationRefVar >::value()) WriteMutationRefVar(std::move(encryptedMutation)); // state_var_RVO
		this->~WriteMutationEncryptedMutationActorState();
		static_cast<WriteMutationEncryptedMutationActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(TextAndHeaderCipherKeys && cipherKeys,int loopDepth) 
	{
															#line 1879 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		decryptedMutation = encryptedMutation.decrypt(cipherKeys, *arena, BlobCipherMetrics::TLOG);
															#line 1881 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		ASSERT(decryptedMutation.type == mutation->type);
															#line 1882 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		ASSERT(decryptedMutation.param1 == mutation->param1);
															#line 1883 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		ASSERT(decryptedMutation.param2 == mutation->param2);
															#line 1885 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		CODE_PROBE(true, "encrypting non-metadata mutations", probe::decoration::rare);
															#line 1886 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->toCommit.writeTypedMessage(encryptedMutation);
															#line 1887 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!static_cast<WriteMutationEncryptedMutationActor*>(this)->SAV<WriteMutationRefVar>::futures) { (void)(encryptedMutation); this->~WriteMutationEncryptedMutationActorState(); static_cast<WriteMutationEncryptedMutationActor*>(this)->destroy(); return 0; }
															#line 5948 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		new (&static_cast<WriteMutationEncryptedMutationActor*>(this)->SAV< WriteMutationRefVar >::value()) WriteMutationRefVar(std::move(encryptedMutation)); // state_var_RVO
		this->~WriteMutationEncryptedMutationActorState();
		static_cast<WriteMutationEncryptedMutationActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(TextAndHeaderCipherKeys const& cipherKeys,int loopDepth) 
	{
		loopDepth = a_body1cont1(cipherKeys, loopDepth);

		return loopDepth;
	}
	int a_body1when1(TextAndHeaderCipherKeys && cipherKeys,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(cipherKeys), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WriteMutationEncryptedMutationActor*>(this)->actor_wait_state > 0) static_cast<WriteMutationEncryptedMutationActor*>(this)->actor_wait_state = 0;
		static_cast<WriteMutationEncryptedMutationActor*>(this)->ActorCallback< WriteMutationEncryptedMutationActor, 0, TextAndHeaderCipherKeys >::remove();

	}
	void a_callback_fire(ActorCallback< WriteMutationEncryptedMutationActor, 0, TextAndHeaderCipherKeys >*,TextAndHeaderCipherKeys const& value) 
	{
		fdb_probe_actor_enter("writeMutationEncryptedMutation", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteMutationEncryptedMutationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeMutationEncryptedMutation", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WriteMutationEncryptedMutationActor, 0, TextAndHeaderCipherKeys >*,TextAndHeaderCipherKeys && value) 
	{
		fdb_probe_actor_enter("writeMutationEncryptedMutation", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteMutationEncryptedMutationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeMutationEncryptedMutation", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WriteMutationEncryptedMutationActor, 0, TextAndHeaderCipherKeys >*,Error err) 
	{
		fdb_probe_actor_enter("writeMutationEncryptedMutation", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteMutationEncryptedMutationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeMutationEncryptedMutation", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1861 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	CommitBatchContext* self;
															#line 1861 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	int64_t tenantId;
															#line 1861 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	const MutationRef* mutation;
															#line 1861 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Optional<MutationRef>* encryptedMutationOpt;
															#line 1861 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Arena* arena;
															#line 1866 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	MutationRef encryptedMutation;
															#line 1867 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	BlobCipherEncryptHeaderRef headerRef;
															#line 1868 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	MutationRef decryptedMutation;
															#line 6047 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
};
// This generated class is to be used only via writeMutationEncryptedMutation()
															#line 1861 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class WriteMutationEncryptedMutationActor final : public Actor<WriteMutationRefVar>, public ActorCallback< WriteMutationEncryptedMutationActor, 0, TextAndHeaderCipherKeys >, public FastAllocated<WriteMutationEncryptedMutationActor>, public WriteMutationEncryptedMutationActorState<WriteMutationEncryptedMutationActor> {
															#line 6052 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
public:
	using FastAllocated<WriteMutationEncryptedMutationActor>::operator new;
	using FastAllocated<WriteMutationEncryptedMutationActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10691580766972531200UL, 10307793708403993344UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<WriteMutationRefVar>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WriteMutationEncryptedMutationActor, 0, TextAndHeaderCipherKeys >;
															#line 1861 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	WriteMutationEncryptedMutationActor(CommitBatchContext* const& self,int64_t const& tenantId,const MutationRef* const& mutation,Optional<MutationRef>* const& encryptedMutationOpt,Arena* const& arena) 
															#line 6069 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		 : Actor<WriteMutationRefVar>(),
		   WriteMutationEncryptedMutationActorState<WriteMutationEncryptedMutationActor>(self, tenantId, mutation, encryptedMutationOpt, arena),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("writeMutationEncryptedMutation", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8025453204033948160UL, 16846001034469967616UL);
		ActorExecutionContextHelper __helper(static_cast<WriteMutationEncryptedMutationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("writeMutationEncryptedMutation");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("writeMutationEncryptedMutation", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WriteMutationEncryptedMutationActor, 0, TextAndHeaderCipherKeys >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1861 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
[[nodiscard]] Future<WriteMutationRefVar> writeMutationEncryptedMutation( CommitBatchContext* const& self, int64_t const& tenantId, const MutationRef* const& mutation, Optional<MutationRef>* const& encryptedMutationOpt, Arena* const& arena ) {
															#line 1861 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	return Future<WriteMutationRefVar>(new WriteMutationEncryptedMutationActor(self, tenantId, mutation, encryptedMutationOpt, arena));
															#line 6101 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
}

#line 1889 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"

Future<WriteMutationRefVar> writeMutation(CommitBatchContext* self,
                                          int64_t domainId,
                                          const MutationRef* mutation,
                                          Optional<MutationRef>* encryptedMutationOpt,
                                          Arena* arena,
                                          double* encryptTime = nullptr) {
	static_assert(TenantInfo::INVALID_TENANT == INVALID_ENCRYPT_DOMAIN_ID);

	// WriteMutation routine is responsible for appending mutations to be persisted in TLog, the operation
	// isn't a 'blocking' operation, except for few cases when Encryption is supported by the cluster such
	// as:
	// 1. Fetch encryption keys to encrypt the mutation.
	// 2. Split ClearRange mutation to respect Encryption domain boundaries.
	// 3. Ensure sanity of already encrypted mutation - simulation limited check.
	//
	// Approach optimizes "fast" path by avoiding alloc/dealloc overhead due to be ACTOR framework support,
	// the penalty happens iff any of above conditions are met. Otherwise, corresponding handle routine (ACTOR
	// compliant) gets invoked ("slow path").

	if (self->pProxyCommitData->encryptMode.isEncryptionEnabled()) {
		if (self->pProxyCommitData->encryptMode.mode == EncryptionAtRestMode::CLUSTER_AWARE) {
			ASSERT(domainId == FDB_DEFAULT_ENCRYPT_DOMAIN_ID || domainId == SYSTEM_KEYSPACE_ENCRYPT_DOMAIN_ID);
		}
		MutationRef encryptedMutation;
		CODE_PROBE(self->pProxyCommitData->getTenantMode() == TenantMode::DISABLED, "using disabled tenant mode");
		CODE_PROBE(self->pProxyCommitData->getTenantMode() == TenantMode::OPTIONAL_TENANT,
		           "using optional tenant mode");
		CODE_PROBE(self->pProxyCommitData->getTenantMode() == TenantMode::REQUIRED, "using required tenant mode");

		if (encryptedMutationOpt && encryptedMutationOpt->present()) {
			CODE_PROBE(true, "using already encrypted mutation", probe::decoration::rare);
			encryptedMutation = encryptedMutationOpt->get();
			ASSERT(encryptedMutation.isEncrypted());
			// During simulation check whether the encrypted mutation matches the decrpyted mutation
			if (g_network && g_network->isSimulated()) {
				return writeMutationEncryptedMutation(self, domainId, mutation, encryptedMutationOpt, arena);
			}
		} else {
			if (domainId == INVALID_ENCRYPT_DOMAIN_ID) {
				domainId = getEncryptDetailsFromMutationRef(self->pProxyCommitData, *mutation);
				CODE_PROBE(true, "Raw access mutation encryption", probe::decoration::rare);
			}
			ASSERT_NE(domainId, INVALID_ENCRYPT_DOMAIN_ID);
			ASSERT(self->cipherKeys.contains(domainId));
			encryptedMutation =
			    mutation->encrypt(self->cipherKeys, domainId, *arena, BlobCipherMetrics::TLOG, encryptTime);
		}
		ASSERT(encryptedMutation.isEncrypted());
		CODE_PROBE(true, "encrypting non-metadata mutations", probe::decoration::rare);
		self->toCommit.writeTypedMessage(encryptedMutation);
		return std::variant<MutationRef, VectorRef<MutationRef>>{ encryptedMutation };
	} else {
		self->toCommit.writeTypedMessage(*mutation);
		return std::variant<MutationRef, VectorRef<MutationRef>>{ *mutation };
	}
}

double pushToBackupMutations(CommitBatchContext* self,
                             ProxyCommitData* const pProxyCommitData,
                             Arena& arena,
                             MutationRef const& m,
                             MutationRef const& writtenMutation,
                             Optional<MutationRef> const& encryptedMutation) {
	// In required tenant mode, the clear ranges are already split by tenant
	double encryptionTime = 0;
	if (m.type != MutationRef::Type::ClearRange ||
	    (pProxyCommitData->getTenantMode() == TenantMode::REQUIRED && !systemKeys.contains(m.param1))) {
		if (EXPENSIVE_VALIDATION && m.type == MutationRef::ClearRange) {
			DisabledTraceEvent("DebugSingleTenant", pProxyCommitData->dbgid)
			    .detail("M1", m.param1)
			    .detail("M2", m.param2)
			    .detail("TenantMap", pProxyCommitData->tenantMap.size());
			ASSERT(TenantAPI::withinSingleTenant(KeyRangeRef(m.param1, m.param2)));
		}
		ASSERT(!pProxyCommitData->encryptMode.isEncryptionEnabled() || writtenMutation.isEncrypted());

		// Add the mutation to the relevant backup tag
		for (auto backupName : pProxyCommitData->vecBackupKeys[m.param1]) {
			// If encryption is enabled make sure the mutation we are writing is also encrypted
			CODE_PROBE(writtenMutation.isEncrypted(), "using encrypted backup mutation", probe::decoration::rare);
			self->logRangeMutations[backupName].push_back_deep(self->logRangeMutationsArena, writtenMutation);
		}

	} else {
		KeyRangeRef mutationRange(m.param1, m.param2);
		KeyRangeRef intersectionRange;

		// Identify and add the intersecting ranges of the mutation to the array of mutations to serialize
		for (auto backupRange : pProxyCommitData->vecBackupKeys.intersectingRanges(mutationRange)) {
			// Get the backup sub range
			const auto& backupSubrange = backupRange.range();

			// Determine the intersecting range
			intersectionRange = mutationRange & backupSubrange;

			// Create the custom mutation for the specific backup tag
			MutationRef backupMutation(MutationRef::Type::ClearRange, intersectionRange.begin, intersectionRange.end);

			if (pProxyCommitData->encryptMode.isEncryptionEnabled()) {
				CODE_PROBE(true, "encrypting clear range backup mutation", probe::decoration::rare);
				if (backupMutation.param1 == m.param1 && backupMutation.param2 == m.param2 &&
				    encryptedMutation.present()) {
					backupMutation = encryptedMutation.get();
				} else {
					EncryptCipherDomainId domainId = getEncryptDetailsFromMutationRef(pProxyCommitData, backupMutation);
					double encryptionTimeV = 0;
					backupMutation = backupMutation.encrypt(
					    self->cipherKeys, domainId, arena, BlobCipherMetrics::BACKUP, &encryptionTimeV);
					encryptionTime += encryptionTimeV;
				}
			}
			ASSERT(!pProxyCommitData->encryptMode.isEncryptionEnabled() || backupMutation.isEncrypted());

			// Add the mutation to the relevant backup tag
			for (auto backupName : backupRange.value()) {
				self->logRangeMutations[backupName].push_back_deep(self->logRangeMutationsArena, backupMutation);
			}
		}
	}
	return encryptionTime;
}

void addAccumulativeChecksumMutations(CommitBatchContext* self) {
	ASSERT(self->pProxyCommitData->acsBuilder != nullptr);
	const uint16_t acsIndex = getCommitProxyAccumulativeChecksumIndex(self->pProxyCommitData->commitProxyIndex);
	for (const auto& [tag, acsState] : self->pProxyCommitData->acsBuilder->getAcsTable()) {
		ASSERT(tagSupportAccumulativeChecksum(tag));
		ASSERT(acsState.version <= self->commitVersion);
		if (acsState.version < self->commitVersion) {
			// Have not updated in the current commit batch
			// So, need not send acs mutation for this tag
			continue;
		}
		ASSERT(acsState.epoch == self->pProxyCommitData->epoch);
		MutationRef acsMutation;
		acsMutation.type = MutationRef::SetValue;
		acsMutation.param1 = accumulativeChecksumKey; // private mutation
		AccumulativeChecksumState acsToSend(acsIndex, acsState.acs, self->commitVersion, self->pProxyCommitData->epoch);
		Value acsValue = accumulativeChecksumValue(acsToSend);
		acsMutation.param2 = acsValue;
		acsMutation.setAccumulativeChecksumIndex(acsIndex);
		if (CLIENT_KNOBS->ENABLE_ACCUMULATIVE_CHECKSUM_LOGGING) {
			TraceEvent(SevInfo, "AcsBuilderIssueAccumulativeChecksumMutation", self->pProxyCommitData->dbgid)
			    .detail("AcsTag", tag)
			    .detail("AcsIndex", acsIndex)
			    .detail("AcsToSend", acsToSend.toString())
			    .detail("Mutation", acsMutation)
			    .detail("Version", self->commitVersion)
			    .detail("CommitProxyIndex", self->pProxyCommitData->commitProxyIndex);
		}
		DEBUG_MUTATION("ProxyCommit", self->commitVersion, acsMutation, self->pProxyCommitData->dbgid);
		self->toCommit.addTag(tag);
		self->toCommit.writeTypedMessage(acsMutation);
	}
}
// RangeLock takes effect only when the feature flag is on and database is unlocked and the mutation is not encrypted
void rejectMutationsForReadLockOnRange(CommitBatchContext* self) {
	ASSERT(self->rangeLockEnabled());
	ProxyCommitData* const pProxyCommitData = self->pProxyCommitData;
	ASSERT(pProxyCommitData->rangeLock != nullptr);
	std::vector<CommitTransactionRequest>& trs = self->trs;
	for (int i = self->transactionNum; i < trs.size(); i++) {
		if (self->committed[i] != ConflictBatch::TransactionCommitted) {
			continue;
		} else if (trs[i].isLockAware()) {
			continue; // rangeLock is transparent to lock-aware transactions
		}
		VectorRef<MutationRef>* pMutations = &trs[i].transaction.mutations;
		bool transactionRejected = false;
		for (int j = 0; j < pMutations->size(); j++) {
			MutationRef m = (*pMutations)[j];
			ASSERT_WE_THINK(!m.isEncrypted());
			if (m.isEncrypted()) {
				continue;
			}
			KeyRange rangeToCheck;
			if (isSingleKeyMutation((MutationRef::Type)m.type)) {
				rangeToCheck = singleKeyRange(m.param1);
			} else if (m.type == MutationRef::ClearRange) {
				rangeToCheck = KeyRangeRef(m.param1, m.param2);
			}
			bool shouldReject = pProxyCommitData->rangeLock->isLocked(rangeToCheck);
			if (shouldReject) {
				self->committed[i] = ConflictBatch::TransactionLockReject;
				trs[i].reply.sendError(transaction_rejected_range_locked());
				transactionRejected = true;
			}
			if (transactionRejected) {
				break;
			}
		}
	}
	return;
}

/// This second pass through committed transactions assigns the actual mutations to the appropriate storage servers'
/// tags
															#line 6303 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
// This generated class is to be used only via assignMutationsToStorageServers()
															#line 2087 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
template <class AssignMutationsToStorageServersActor>
															#line 2087 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class AssignMutationsToStorageServersActorState {
															#line 6309 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
public:
															#line 2087 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	AssignMutationsToStorageServersActorState(CommitBatchContext* const& self) 
															#line 2087 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
															#line 2087 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		 : self(self),
															#line 2088 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   pProxyCommitData(self->pProxyCommitData),
															#line 2089 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   trs(self->trs),
															#line 2090 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   curEncryptionTime(0),
															#line 2091 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   totalEncryptionTime(0)
															#line 6324 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
	{
		fdb_probe_actor_create("assignMutationsToStorageServers", reinterpret_cast<unsigned long>(this));

	}
	~AssignMutationsToStorageServersActorState() 
	{
		fdb_probe_actor_destroy("assignMutationsToStorageServers", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2093 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			;
															#line 6339 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~AssignMutationsToStorageServersActorState();
		static_cast<AssignMutationsToStorageServersActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2313 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		ASSERT(CLIENT_KNOBS->ENABLE_ENCRYPTION_CPU_TIME_LOGGING || self->encryptionTime == 0);
															#line 2314 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (self->pProxyCommitData->encryptMode.isEncryptionEnabled())
															#line 6364 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 2315 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			self->encryptionTime = totalEncryptionTime;
															#line 6368 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		}
															#line 2318 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!static_cast<AssignMutationsToStorageServersActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~AssignMutationsToStorageServersActorState(); static_cast<AssignMutationsToStorageServersActor*>(this)->destroy(); return 0; }
															#line 6372 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		new (&static_cast<AssignMutationsToStorageServersActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~AssignMutationsToStorageServersActorState();
		static_cast<AssignMutationsToStorageServersActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 2093 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!(self->transactionNum < trs.size()))
															#line 6391 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 2094 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!(self->committed[self->transactionNum] == ConflictBatch::TransactionCommitted && (!self->locked || trs[self->transactionNum].isLockAware())))
															#line 6397 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
			return a_body1continue1(loopDepth); // continue
		}
															#line 2099 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		checkSample = trs[self->transactionNum].commitCostEstimation.present();
															#line 2100 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		trCost = &trs[self->transactionNum].commitCostEstimation;
															#line 2101 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		mutationNum = 0;
															#line 2102 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pMutations = &trs[self->transactionNum].transaction.mutations;
															#line 2103 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		encryptedMutations = &trs[self->transactionNum].transaction.encryptedMutations;
															#line 2106 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!encryptedMutations->empty())
															#line 6413 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 2107 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			ASSERT_EQ(encryptedMutations->size(), pMutations->size());
															#line 6417 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		}
															#line 2110 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		encryptDomain = trs[self->transactionNum].tenantInfo.tenantId;
															#line 2111 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (self->pProxyCommitData->encryptMode.mode == EncryptionAtRestMode::CLUSTER_AWARE && encryptDomain != SYSTEM_KEYSPACE_ENCRYPT_DOMAIN_ID)
															#line 6423 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 2113 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			encryptDomain = FDB_DEFAULT_ENCRYPT_DOMAIN_ID;
															#line 6427 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		}
															#line 2116 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->toCommit.addTransactionInfo(trs[self->transactionNum].spanContext);
															#line 2118 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		;
															#line 6433 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		loopDepth = a_body1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1continue1(int loopDepth) 
	{
															#line 2093 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->transactionNum++;
															#line 6455 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 2307 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (checkSample)
															#line 6464 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 2308 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			self->pProxyCommitData->stats.txnExpensiveClearCostEstCount += trs[self->transactionNum].commitCostEstimation.get().expensiveCostEstCount;
															#line 6468 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		}
															#line 2093 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->transactionNum++;
															#line 6472 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
															#line 2118 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!(mutationNum < pMutations->size()))
															#line 6488 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
			return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 2119 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (self->yieldBytes > SERVER_KNOBS->DESIRED_TOTAL_BYTES)
															#line 6494 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 2120 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			self->yieldBytes = 0;
															#line 2121 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (g_network->check_yield(TaskPriority::ProxyCommitYield1))
															#line 6500 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			{
															#line 2122 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				self->computeDuration += g_network->timer_monotonic() - self->computeStart;
															#line 2123 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				StrictFuture<Void> __when_expr_0 = delay(0, TaskPriority::ProxyCommitYield1);
															#line 2123 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (static_cast<AssignMutationsToStorageServersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 6508 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
				static_cast<AssignMutationsToStorageServersActor*>(this)->actor_wait_state = 1;
															#line 2123 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< AssignMutationsToStorageServersActor, 0, Void >*>(static_cast<AssignMutationsToStorageServersActor*>(this)));
															#line 6513 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1loopBody1loopBody1cont3(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1continue1(int loopDepth) 
	{
															#line 2118 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		mutationNum++;
															#line 6545 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
															#line 2128 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		m = (*pMutations)[mutationNum];
															#line 2129 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		encryptedMutation = encryptedMutations->size() > 0 ? (*encryptedMutations)[mutationNum] : Optional<MutationRef>();
															#line 2131 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		arena = Arena();
															#line 2132 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		writtenMutation = MutationRef();
															#line 2133 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->mutationCount++;
															#line 2134 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->mutationBytes += m.expectedSize();
															#line 2135 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->yieldBytes += m.expectedSize();
															#line 2136 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		ASSERT(!m.isEncrypted());
															#line 2139 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (isSingleKeyMutation((MutationRef::Type)m.type))
															#line 6570 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 2140 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			auto& tags = pProxyCommitData->tagsForKey(m.param1);
															#line 2144 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (checkSample)
															#line 6576 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			{
															#line 2145 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				double totalCosts = trCost->get().writeCosts;
															#line 2146 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				double cost = getWriteOperationCost(m.expectedSize());
															#line 2147 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				double mul = std::max(1.0, totalCosts / std::max(1.0, (double)CLIENT_KNOBS->COMMIT_SAMPLE_COST));
															#line 2148 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				ASSERT(totalCosts > 0);
															#line 2149 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				double prob = mul * cost / totalCosts;
															#line 2151 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (deterministicRandom()->random01() < prob)
															#line 6590 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
				{
															#line 2152 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					const auto& storageServers = pProxyCommitData->keyInfo[m.param1].src_info;
															#line 2153 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					for( const auto& ssInfo : storageServers ) {
															#line 2154 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						auto id = ssInfo->interf.id();
															#line 2156 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						cost = cost < CLIENT_KNOBS->COMMIT_SAMPLE_COST ? CLIENT_KNOBS->COMMIT_SAMPLE_COST : cost;
															#line 2157 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						pProxyCommitData->updateSSTagCost( id, trs[self->transactionNum].tagSet.get(), m, cost / storageServers.size());
															#line 6602 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
					}
				}
			}
															#line 2163 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (pProxyCommitData->singleKeyMutationEvent->enabled)
															#line 6608 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			{
															#line 2164 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				KeyRangeRef shard = pProxyCommitData->keyInfo.rangeContaining(m.param1).range();
															#line 2165 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				pProxyCommitData->singleKeyMutationEvent->tag1 = (int64_t)tags[0].id;
															#line 2166 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				pProxyCommitData->singleKeyMutationEvent->tag2 = (int64_t)tags[1].id;
															#line 2167 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				pProxyCommitData->singleKeyMutationEvent->tag3 = (int64_t)tags[2].id;
															#line 2168 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				pProxyCommitData->singleKeyMutationEvent->shardBegin = shard.begin;
															#line 2169 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				pProxyCommitData->singleKeyMutationEvent->shardEnd = shard.end;
															#line 2170 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				pProxyCommitData->singleKeyMutationEvent->log();
															#line 6624 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			}
															#line 2173 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			DEBUG_MUTATION("ProxyCommit", self->commitVersion, m, pProxyCommitData->dbgid).detail("To", tags);
															#line 2174 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			self->toCommit.addTags(tags);
															#line 2175 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (pProxyCommitData->cacheInfo[m.param1])
															#line 6632 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			{
															#line 2176 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				self->toCommit.addTag(cacheTag);
															#line 6636 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			}
															#line 2178 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (encryptedMutation.present())
															#line 6640 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			{
															#line 2179 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				ASSERT(encryptedMutation.get().isEncrypted());
															#line 6644 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			}
															#line 2182 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (pProxyCommitData->acsBuilder != nullptr)
															#line 6648 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			{
															#line 2183 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				updateMutationWithAcsAndAddMutationToAcsBuilder( pProxyCommitData->acsBuilder, m, tags, getCommitProxyAccumulativeChecksumIndex(pProxyCommitData->commitProxyIndex), pProxyCommitData->epoch, self->commitVersion, pProxyCommitData->dbgid);
															#line 6652 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			}
															#line 2193 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			StrictFuture<WriteMutationRefVar> __when_expr_1 = writeMutation(self, encryptDomain, &m, &encryptedMutation, &arena, &curEncryptionTime);
															#line 2193 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (static_cast<AssignMutationsToStorageServersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 6658 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<AssignMutationsToStorageServersActor*>(this)->actor_wait_state = 2;
															#line 2193 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< AssignMutationsToStorageServersActor, 1, WriteMutationRefVar >*>(static_cast<AssignMutationsToStorageServersActor*>(this)));
															#line 6663 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 2199 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (m.type == MutationRef::ClearRange)
															#line 6670 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			{
															#line 2200 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				auto range = pProxyCommitData->keyInfo.rangeContaining(m.param1);
															#line 2201 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (range.end() >= m.param2)
															#line 6676 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
				{
															#line 2203 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					DEBUG_MUTATION("ProxyCommit", self->commitVersion, m, pProxyCommitData->dbgid) .detail("To", range.value().tags);
															#line 2205 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					range.value().populateTags();
															#line 2206 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					self->toCommit.addTags(range.value().tags);
															#line 2208 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					if (pProxyCommitData->acsBuilder != nullptr)
															#line 6686 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
					{
															#line 2209 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						updateMutationWithAcsAndAddMutationToAcsBuilder( pProxyCommitData->acsBuilder, m, range.value().tags, getCommitProxyAccumulativeChecksumIndex(pProxyCommitData->commitProxyIndex), pProxyCommitData->epoch, self->commitVersion, pProxyCommitData->dbgid);
															#line 6690 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
					}
															#line 2220 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					if (checkSample && !trCost->get().clearIdxCosts.empty() && trCost->get().clearIdxCosts[0].first == mutationNum)
															#line 6694 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
					{
															#line 2222 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						auto const& ssInfos = range.value().src_info;
															#line 2223 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						for( auto const& ssInfo : ssInfos ) {
															#line 2224 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
							auto id = ssInfo->interf.id();
															#line 2225 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
							pProxyCommitData->updateSSTagCost(id, trs[self->transactionNum].tagSet.get(), m, trCost->get().clearIdxCosts[0].second / ssInfos.size());
															#line 6704 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
						}
															#line 2230 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						trCost->get().clearIdxCosts.pop_front();
															#line 6708 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
					}
				}
				else
				{
															#line 2233 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					CODE_PROBE(true, "A clear range extends past a shard boundary");
															#line 2234 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					std::set<Tag> allSources;
															#line 2235 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					for(;range.begin() < m.param2;) {
															#line 2236 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						range.value().populateTags();
															#line 2237 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						allSources.insert(range.value().tags.begin(), range.value().tags.end());
															#line 2240 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						if (checkSample && !trCost->get().clearIdxCosts.empty() && trCost->get().clearIdxCosts[0].first == mutationNum)
															#line 6725 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
						{
															#line 2242 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
							auto const& ssInfos = range.value().src_info;
															#line 2243 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
							for( auto const& ssInfo : ssInfos ) {
															#line 2244 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
								auto id = ssInfo->interf.id();
															#line 2245 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
								pProxyCommitData->updateSSTagCost(id, trs[self->transactionNum].tagSet.get(), m, trCost->get().clearIdxCosts[0].second / ssInfos.size());
															#line 6735 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
							}
															#line 2251 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
							trCost->get().clearIdxCosts.pop_front();
															#line 6739 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
						}
															#line 2253 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						++range;
															#line 6743 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
					}
															#line 2256 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					DEBUG_MUTATION("ProxyCommit", self->commitVersion, m) .detail("Dbgid", pProxyCommitData->dbgid) .detail("To", allSources);
															#line 2259 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					self->toCommit.addTags(allSources);
															#line 2261 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					if (self->pProxyCommitData->acsBuilder != nullptr)
															#line 6751 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
					{
															#line 2262 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						updateMutationWithAcsAndAddMutationToAcsBuilder( pProxyCommitData->acsBuilder, m, allSources, getCommitProxyAccumulativeChecksumIndex(pProxyCommitData->commitProxyIndex), pProxyCommitData->epoch, self->commitVersion, pProxyCommitData->dbgid);
															#line 6755 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
					}
				}
															#line 2273 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				KeyRangeRef clearRange(KeyRangeRef(m.param1, m.param2));
															#line 2274 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (pProxyCommitData->needsCacheTag(clearRange))
															#line 6762 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
				{
															#line 2275 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					self->toCommit.addTag(cacheTag);
															#line 6766 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
				}
															#line 2277 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				StrictFuture<WriteMutationRefVar> __when_expr_2 = writeMutation(self, encryptDomain, &m, &encryptedMutation, &arena, &curEncryptionTime);
															#line 2277 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (static_cast<AssignMutationsToStorageServersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 6772 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
				if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1cont1when2(__when_expr_2.get(), loopDepth); };
				static_cast<AssignMutationsToStorageServersActor*>(this)->actor_wait_state = 3;
															#line 2277 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< AssignMutationsToStorageServersActor, 2, WriteMutationRefVar >*>(static_cast<AssignMutationsToStorageServersActor*>(this)));
															#line 6777 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 2283 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (m.type == MutationRef::NoOp)
															#line 6784 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
				{
															#line 2284 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					ASSERT_EQ(pProxyCommitData->getTenantMode(), TenantMode::REQUIRED);
															#line 6788 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
					return a_body1loopBody1continue1(loopDepth); // continue
				}
				else
				{
															#line 2287 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					UNREACHABLE();
															#line 6795 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
				}
				loopDepth = a_body1loopBody1loopBody1cont16(loopDepth);
			}
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3(int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont4(Void const& _,int loopDepth) 
	{
															#line 2124 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->computeStart = g_network->timer_monotonic();
															#line 6813 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		loopDepth = a_body1loopBody1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont4(Void && _,int loopDepth) 
	{
															#line 2124 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->computeStart = g_network->timer_monotonic();
															#line 6822 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		loopDepth = a_body1loopBody1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<AssignMutationsToStorageServersActor*>(this)->actor_wait_state > 0) static_cast<AssignMutationsToStorageServersActor*>(this)->actor_wait_state = 0;
		static_cast<AssignMutationsToStorageServersActor*>(this)->ActorCallback< AssignMutationsToStorageServersActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AssignMutationsToStorageServersActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("assignMutationsToStorageServers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AssignMutationsToStorageServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("assignMutationsToStorageServers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< AssignMutationsToStorageServersActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("assignMutationsToStorageServers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AssignMutationsToStorageServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("assignMutationsToStorageServers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< AssignMutationsToStorageServersActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("assignMutationsToStorageServers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AssignMutationsToStorageServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("assignMutationsToStorageServers", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1loopBody1cont6(int loopDepth) 
	{
															#line 2290 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		DisabledTraceEvent(SevDebug, "BeforeBackup", pProxyCommitData->dbgid) .detail("M1", m.param1) .detail("M2", m.param2) .detail("MT", getTypeString(m.type)) .detail("VecBackupKeys", pProxyCommitData->vecBackupKeys.size()) .detail("ShouldBackup", shouldBackup(m)) .detail("TenantMapSize", pProxyCommitData->tenantMap.size()) .detail("TenantMode", (int)pProxyCommitData->getTenantMode());
															#line 2299 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (pProxyCommitData->vecBackupKeys.size() <= 1 || !shouldBackup(m))
															#line 6908 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
			return a_body1loopBody1continue1(loopDepth); // continue
		}
															#line 2303 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		totalEncryptionTime += pushToBackupMutations(self, pProxyCommitData, arena, m, writtenMutation, encryptedMutation);
															#line 2118 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		mutationNum++;
															#line 6916 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont7(WriteMutationRefVar const& var,int loopDepth) 
	{
															#line 2195 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		totalEncryptionTime += curEncryptionTime;
															#line 2197 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		ASSERT(std::holds_alternative<MutationRef>(var));
															#line 2198 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		writtenMutation = std::get<MutationRef>(var);
															#line 6929 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		loopDepth = a_body1loopBody1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont7(WriteMutationRefVar && var,int loopDepth) 
	{
															#line 2195 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		totalEncryptionTime += curEncryptionTime;
															#line 2197 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		ASSERT(std::holds_alternative<MutationRef>(var));
															#line 2198 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		writtenMutation = std::get<MutationRef>(var);
															#line 6942 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		loopDepth = a_body1loopBody1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1when1(WriteMutationRefVar const& var,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont7(var, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1when1(WriteMutationRefVar && var,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont7(std::move(var), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<AssignMutationsToStorageServersActor*>(this)->actor_wait_state > 0) static_cast<AssignMutationsToStorageServersActor*>(this)->actor_wait_state = 0;
		static_cast<AssignMutationsToStorageServersActor*>(this)->ActorCallback< AssignMutationsToStorageServersActor, 1, WriteMutationRefVar >::remove();

	}
	void a_callback_fire(ActorCallback< AssignMutationsToStorageServersActor, 1, WriteMutationRefVar >*,WriteMutationRefVar const& value) 
	{
		fdb_probe_actor_enter("assignMutationsToStorageServers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AssignMutationsToStorageServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("assignMutationsToStorageServers", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< AssignMutationsToStorageServersActor, 1, WriteMutationRefVar >*,WriteMutationRefVar && value) 
	{
		fdb_probe_actor_enter("assignMutationsToStorageServers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AssignMutationsToStorageServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("assignMutationsToStorageServers", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< AssignMutationsToStorageServersActor, 1, WriteMutationRefVar >*,Error err) 
	{
		fdb_probe_actor_enter("assignMutationsToStorageServers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AssignMutationsToStorageServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("assignMutationsToStorageServers", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1loopBody1cont16(int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont17(WriteMutationRefVar const& var,int loopDepth) 
	{
															#line 2279 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		totalEncryptionTime += curEncryptionTime;
															#line 2281 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		ASSERT(std::holds_alternative<MutationRef>(var));
															#line 2282 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		writtenMutation = std::get<MutationRef>(var);
															#line 7036 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		loopDepth = a_body1loopBody1loopBody1cont16(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont17(WriteMutationRefVar && var,int loopDepth) 
	{
															#line 2279 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		totalEncryptionTime += curEncryptionTime;
															#line 2281 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		ASSERT(std::holds_alternative<MutationRef>(var));
															#line 2282 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		writtenMutation = std::get<MutationRef>(var);
															#line 7049 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		loopDepth = a_body1loopBody1loopBody1cont16(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1when2(WriteMutationRefVar const& var,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont17(var, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1when2(WriteMutationRefVar && var,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont17(std::move(var), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<AssignMutationsToStorageServersActor*>(this)->actor_wait_state > 0) static_cast<AssignMutationsToStorageServersActor*>(this)->actor_wait_state = 0;
		static_cast<AssignMutationsToStorageServersActor*>(this)->ActorCallback< AssignMutationsToStorageServersActor, 2, WriteMutationRefVar >::remove();

	}
	void a_callback_fire(ActorCallback< AssignMutationsToStorageServersActor, 2, WriteMutationRefVar >*,WriteMutationRefVar const& value) 
	{
		fdb_probe_actor_enter("assignMutationsToStorageServers", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AssignMutationsToStorageServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1cont1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("assignMutationsToStorageServers", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< AssignMutationsToStorageServersActor, 2, WriteMutationRefVar >*,WriteMutationRefVar && value) 
	{
		fdb_probe_actor_enter("assignMutationsToStorageServers", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AssignMutationsToStorageServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1cont1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("assignMutationsToStorageServers", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< AssignMutationsToStorageServersActor, 2, WriteMutationRefVar >*,Error err) 
	{
		fdb_probe_actor_enter("assignMutationsToStorageServers", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AssignMutationsToStorageServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("assignMutationsToStorageServers", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 2087 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	CommitBatchContext* self;
															#line 2088 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ProxyCommitData* const pProxyCommitData;
															#line 2089 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	std::vector<CommitTransactionRequest>& trs;
															#line 2090 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	double curEncryptionTime;
															#line 2091 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	double totalEncryptionTime;
															#line 2099 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	bool checkSample;
															#line 2100 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Optional<ClientTrCommitCostEstimation>* trCost;
															#line 2101 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	int mutationNum;
															#line 2102 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	VectorRef<MutationRef>* pMutations;
															#line 2103 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	VectorRef<Optional<MutationRef>>* encryptedMutations;
															#line 2110 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	int64_t encryptDomain;
															#line 2128 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	MutationRef m;
															#line 2129 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Optional<MutationRef> encryptedMutation;
															#line 2131 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Arena arena;
															#line 2132 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	MutationRef writtenMutation;
															#line 7159 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
};
// This generated class is to be used only via assignMutationsToStorageServers()
															#line 2087 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class AssignMutationsToStorageServersActor final : public Actor<Void>, public ActorCallback< AssignMutationsToStorageServersActor, 0, Void >, public ActorCallback< AssignMutationsToStorageServersActor, 1, WriteMutationRefVar >, public ActorCallback< AssignMutationsToStorageServersActor, 2, WriteMutationRefVar >, public FastAllocated<AssignMutationsToStorageServersActor>, public AssignMutationsToStorageServersActorState<AssignMutationsToStorageServersActor> {
															#line 7164 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
public:
	using FastAllocated<AssignMutationsToStorageServersActor>::operator new;
	using FastAllocated<AssignMutationsToStorageServersActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11489417509168184832UL, 14088962417926897408UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< AssignMutationsToStorageServersActor, 0, Void >;
friend struct ActorCallback< AssignMutationsToStorageServersActor, 1, WriteMutationRefVar >;
friend struct ActorCallback< AssignMutationsToStorageServersActor, 2, WriteMutationRefVar >;
															#line 2087 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	AssignMutationsToStorageServersActor(CommitBatchContext* const& self) 
															#line 7183 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		 : Actor<Void>(),
		   AssignMutationsToStorageServersActorState<AssignMutationsToStorageServersActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("assignMutationsToStorageServers", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9890514799402802944UL, 16180603176411543808UL);
		ActorExecutionContextHelper __helper(static_cast<AssignMutationsToStorageServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("assignMutationsToStorageServers");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("assignMutationsToStorageServers", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< AssignMutationsToStorageServersActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< AssignMutationsToStorageServersActor, 1, WriteMutationRefVar >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< AssignMutationsToStorageServersActor, 2, WriteMutationRefVar >*)0, actor_cancelled()); break;
		}

	}
};
															#line 2087 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
[[nodiscard]] Future<Void> assignMutationsToStorageServers( CommitBatchContext* const& self ) {
															#line 2087 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	return Future<Void>(new AssignMutationsToStorageServersActor(self));
															#line 7217 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
}

#line 2320 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"

															#line 7222 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
// This generated class is to be used only via postResolution()
															#line 2321 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
template <class PostResolutionActor>
															#line 2321 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class PostResolutionActorState {
															#line 7228 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
public:
															#line 2321 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	PostResolutionActorState(CommitBatchContext* const& self) 
															#line 2321 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
															#line 2321 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		 : self(self),
															#line 2322 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   postResolutionStart(g_network->timer_monotonic()),
															#line 2323 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   pProxyCommitData(self->pProxyCommitData),
															#line 2324 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   trs(self->trs),
															#line 2325 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   localBatchNumber(self->localBatchNumber),
															#line 2326 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   debugID(self->debugID),
															#line 2327 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   span("MP:postResolution"_loc, self->span.context)
															#line 7247 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
	{
		fdb_probe_actor_create("postResolution", reinterpret_cast<unsigned long>(this));

	}
	~PostResolutionActorState() 
	{
		fdb_probe_actor_destroy("postResolution", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2329 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			bool queuedCommits = pProxyCommitData->latestLocalCommitBatchLogging.get() < localBatchNumber - 1;
															#line 2330 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			CODE_PROBE(queuedCommits, "Queuing post-resolution commit processing");
															#line 2331 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			StrictFuture<Void> __when_expr_0 = pProxyCommitData->latestLocalCommitBatchLogging.whenAtLeast(localBatchNumber - 1);
															#line 2331 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (static_cast<PostResolutionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7268 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<PostResolutionActor*>(this)->actor_wait_state = 1;
															#line 2331 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PostResolutionActor, 0, Void >*>(static_cast<PostResolutionActor*>(this)));
															#line 7273 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PostResolutionActorState();
		static_cast<PostResolutionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 2332 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		postResolutionQueuing = g_network->timer_monotonic();
															#line 2333 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->stats.postResolutionDist->sampleSeconds(postResolutionQueuing - postResolutionStart);
															#line 2334 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_1 = yield(TaskPriority::ProxyCommitYield1);
															#line 2334 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<PostResolutionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7302 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<PostResolutionActor*>(this)->actor_wait_state = 2;
															#line 2334 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PostResolutionActor, 1, Void >*>(static_cast<PostResolutionActor*>(this)));
															#line 7307 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 2332 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		postResolutionQueuing = g_network->timer_monotonic();
															#line 2333 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->stats.postResolutionDist->sampleSeconds(postResolutionQueuing - postResolutionStart);
															#line 2334 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_1 = yield(TaskPriority::ProxyCommitYield1);
															#line 2334 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<PostResolutionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7322 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<PostResolutionActor*>(this)->actor_wait_state = 2;
															#line 2334 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PostResolutionActor, 1, Void >*>(static_cast<PostResolutionActor*>(this)));
															#line 7327 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PostResolutionActor*>(this)->actor_wait_state > 0) static_cast<PostResolutionActor*>(this)->actor_wait_state = 0;
		static_cast<PostResolutionActor*>(this)->ActorCallback< PostResolutionActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PostResolutionActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("postResolution", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PostResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("postResolution", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PostResolutionActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("postResolution", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PostResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("postResolution", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PostResolutionActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("postResolution", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PostResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("postResolution", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 2336 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->computeStart = g_network->timer_monotonic();
															#line 2338 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->stats.txnCommitResolved += trs.size();
															#line 2340 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (debugID.present())
															#line 7415 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 2341 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			g_traceBatch.addEvent( "CommitDebug", debugID.get().first(), "CommitProxyServer.commitBatch.ProcessingMutations");
															#line 7419 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		}
															#line 2345 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->isMyFirstBatch = !pProxyCommitData->version.get();
															#line 2346 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->previousCoordinators = pProxyCommitData->txnStateStore->readValue(coordinatorsKey).get();
															#line 2348 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		assertResolutionStateMutationsSizeConsistent(self->resolution);
															#line 2350 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		applyMetadataEffect(self);
															#line 2352 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (debugID.present())
															#line 7431 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 2353 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			g_traceBatch.addEvent( "CommitDebug", debugID.get().first(), "CommitProxyServer.commitBatch.ApplyMetadataEffect");
															#line 7435 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		}
															#line 2357 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		determineCommittedTransactions(self);
															#line 2359 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (debugID.present())
															#line 7441 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 2360 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			g_traceBatch.addEvent( "CommitDebug", debugID.get().first(), "CommitProxyServer.commitBatch.DetermineCommittedTransactions");
															#line 7445 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		}
															#line 2364 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (self->forceRecovery)
															#line 7449 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 2365 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			StrictFuture<Void> __when_expr_2 = Future<Void>(Never());
															#line 2365 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (static_cast<PostResolutionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7455 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<PostResolutionActor*>(this)->actor_wait_state = 3;
															#line 2365 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< PostResolutionActor, 2, Void >*>(static_cast<PostResolutionActor*>(this)));
															#line 7460 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 2336 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->computeStart = g_network->timer_monotonic();
															#line 2338 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->stats.txnCommitResolved += trs.size();
															#line 2340 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (debugID.present())
															#line 7478 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 2341 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			g_traceBatch.addEvent( "CommitDebug", debugID.get().first(), "CommitProxyServer.commitBatch.ProcessingMutations");
															#line 7482 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		}
															#line 2345 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->isMyFirstBatch = !pProxyCommitData->version.get();
															#line 2346 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->previousCoordinators = pProxyCommitData->txnStateStore->readValue(coordinatorsKey).get();
															#line 2348 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		assertResolutionStateMutationsSizeConsistent(self->resolution);
															#line 2350 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		applyMetadataEffect(self);
															#line 2352 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (debugID.present())
															#line 7494 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 2353 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			g_traceBatch.addEvent( "CommitDebug", debugID.get().first(), "CommitProxyServer.commitBatch.ApplyMetadataEffect");
															#line 7498 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		}
															#line 2357 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		determineCommittedTransactions(self);
															#line 2359 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (debugID.present())
															#line 7504 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 2360 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			g_traceBatch.addEvent( "CommitDebug", debugID.get().first(), "CommitProxyServer.commitBatch.DetermineCommittedTransactions");
															#line 7508 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		}
															#line 2364 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (self->forceRecovery)
															#line 7512 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 2365 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			StrictFuture<Void> __when_expr_2 = Future<Void>(Never());
															#line 2365 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (static_cast<PostResolutionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7518 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<PostResolutionActor*>(this)->actor_wait_state = 3;
															#line 2365 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< PostResolutionActor, 2, Void >*>(static_cast<PostResolutionActor*>(this)));
															#line 7523 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<PostResolutionActor*>(this)->actor_wait_state > 0) static_cast<PostResolutionActor*>(this)->actor_wait_state = 0;
		static_cast<PostResolutionActor*>(this)->ActorCallback< PostResolutionActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PostResolutionActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("postResolution", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PostResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("postResolution", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< PostResolutionActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("postResolution", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PostResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("postResolution", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< PostResolutionActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("postResolution", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PostResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("postResolution", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 2369 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_3 = applyMetadataToCommittedTransactions(self);
															#line 2369 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<PostResolutionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7614 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<PostResolutionActor*>(this)->actor_wait_state = 4;
															#line 2369 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< PostResolutionActor, 3, Void >*>(static_cast<PostResolutionActor*>(this)));
															#line 7619 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont7(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<PostResolutionActor*>(this)->actor_wait_state > 0) static_cast<PostResolutionActor*>(this)->actor_wait_state = 0;
		static_cast<PostResolutionActor*>(this)->ActorCallback< PostResolutionActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PostResolutionActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("postResolution", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PostResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("postResolution", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< PostResolutionActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("postResolution", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PostResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("postResolution", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< PostResolutionActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("postResolution", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PostResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("postResolution", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont8(Void const& _,int loopDepth) 
	{
															#line 2371 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (debugID.present())
															#line 7715 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 2372 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			g_traceBatch.addEvent( "CommitDebug", debugID.get().first(), "CommitProxyServer.commitBatch.ApplyMetadataToCommittedTxn");
															#line 7719 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		}
															#line 2379 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (self->rangeLockEnabled())
															#line 7723 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 2380 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			rejectMutationsForReadLockOnRange(self);
															#line 7727 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		}
															#line 2384 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_4 = assignMutationsToStorageServers(self);
															#line 2384 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<PostResolutionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7733 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont8when1(__when_expr_4.get(), loopDepth); };
		static_cast<PostResolutionActor*>(this)->actor_wait_state = 5;
															#line 2384 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< PostResolutionActor, 4, Void >*>(static_cast<PostResolutionActor*>(this)));
															#line 7738 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont8(Void && _,int loopDepth) 
	{
															#line 2371 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (debugID.present())
															#line 7747 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 2372 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			g_traceBatch.addEvent( "CommitDebug", debugID.get().first(), "CommitProxyServer.commitBatch.ApplyMetadataToCommittedTxn");
															#line 7751 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		}
															#line 2379 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (self->rangeLockEnabled())
															#line 7755 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 2380 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			rejectMutationsForReadLockOnRange(self);
															#line 7759 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		}
															#line 2384 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_4 = assignMutationsToStorageServers(self);
															#line 2384 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<PostResolutionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7765 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont8when1(__when_expr_4.get(), loopDepth); };
		static_cast<PostResolutionActor*>(this)->actor_wait_state = 5;
															#line 2384 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< PostResolutionActor, 4, Void >*>(static_cast<PostResolutionActor*>(this)));
															#line 7770 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<PostResolutionActor*>(this)->actor_wait_state > 0) static_cast<PostResolutionActor*>(this)->actor_wait_state = 0;
		static_cast<PostResolutionActor*>(this)->ActorCallback< PostResolutionActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PostResolutionActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("postResolution", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PostResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("postResolution", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< PostResolutionActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("postResolution", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PostResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("postResolution", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< PostResolutionActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("postResolution", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PostResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("postResolution", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont9(Void const& _,int loopDepth) 
	{
															#line 2386 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (debugID.present())
															#line 7854 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 2387 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			g_traceBatch.addEvent("CommitDebug", debugID.get().first(), "CommitProxyServer.commitBatch.AssignMutationToSS");
															#line 7858 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		}
															#line 2391 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if ((pProxyCommitData->vecBackupKeys.size() > 1) && self->logRangeMutations.size())
															#line 7862 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 2392 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			StrictFuture<Void> __when_expr_5 = addBackupMutations(pProxyCommitData, &self->logRangeMutations, &self->toCommit, self->commitVersion, &self->computeDuration, &self->computeStart);
															#line 2392 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (static_cast<PostResolutionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7868 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont9when1(__when_expr_5.get(), loopDepth); };
			static_cast<PostResolutionActor*>(this)->actor_wait_state = 6;
															#line 2392 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< PostResolutionActor, 5, Void >*>(static_cast<PostResolutionActor*>(this)));
															#line 7873 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont12(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont9(Void && _,int loopDepth) 
	{
															#line 2386 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (debugID.present())
															#line 7887 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 2387 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			g_traceBatch.addEvent("CommitDebug", debugID.get().first(), "CommitProxyServer.commitBatch.AssignMutationToSS");
															#line 7891 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		}
															#line 2391 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if ((pProxyCommitData->vecBackupKeys.size() > 1) && self->logRangeMutations.size())
															#line 7895 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 2392 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			StrictFuture<Void> __when_expr_5 = addBackupMutations(pProxyCommitData, &self->logRangeMutations, &self->toCommit, self->commitVersion, &self->computeDuration, &self->computeStart);
															#line 2392 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (static_cast<PostResolutionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7901 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont9when1(__when_expr_5.get(), loopDepth); };
			static_cast<PostResolutionActor*>(this)->actor_wait_state = 6;
															#line 2392 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< PostResolutionActor, 5, Void >*>(static_cast<PostResolutionActor*>(this)));
															#line 7906 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont12(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont8when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<PostResolutionActor*>(this)->actor_wait_state > 0) static_cast<PostResolutionActor*>(this)->actor_wait_state = 0;
		static_cast<PostResolutionActor*>(this)->ActorCallback< PostResolutionActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PostResolutionActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("postResolution", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PostResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("postResolution", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< PostResolutionActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("postResolution", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PostResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("postResolution", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< PostResolutionActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("postResolution", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PostResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("postResolution", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont12(int loopDepth) 
	{
															#line 2404 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		buildIdempotencyIdMutations( self->trs, self->idempotencyKVBuilder, self->commitVersion, self->committed, ConflictBatch::TransactionCommitted, self->locked, [&](const KeyValue& kv) { MutationRef idempotencyIdSet; idempotencyIdSet.type = MutationRef::Type::SetValue; idempotencyIdSet.param1 = kv.key; idempotencyIdSet.param2 = kv.value; auto& tags = pProxyCommitData->tagsForKey(kv.key); ASSERT(!SERVER_KNOBS->ENABLE_VERSION_VECTOR_TLOG_UNICAST || pProxyCommitData->db->get().logSystemConfig.numLogs() == self->tpcvMap.size()); self->toCommit.addTags(tags); if (self->pProxyCommitData->encryptMode.isEncryptionEnabled()) { CODE_PROBE(true, "encrypting idempotency mutation", probe::decoration::rare); EncryptCipherDomainId domainId = getEncryptDetailsFromMutationRef(self->pProxyCommitData, idempotencyIdSet); MutationRef encryptedMutation = idempotencyIdSet.encrypt(self->cipherKeys, domainId, self->arena, BlobCipherMetrics::TLOG); ASSERT(encryptedMutation.isEncrypted()); self->toCommit.writeTypedMessage(encryptedMutation); } else { if (pProxyCommitData->acsBuilder != nullptr) { updateMutationWithAcsAndAddMutationToAcsBuilder( pProxyCommitData->acsBuilder, idempotencyIdSet, tags, getCommitProxyAccumulativeChecksumIndex(pProxyCommitData->commitProxyIndex), pProxyCommitData->epoch, self->commitVersion, pProxyCommitData->dbgid); } self->toCommit.writeTypedMessage(idempotencyIdSet); } });
															#line 2443 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!SERVER_KNOBS->ENABLE_VERSION_VECTOR_TLOG_UNICAST || pProxyCommitData->db->get().logSystemConfig.numLogs() == self->tpcvMap.size())
															#line 7997 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 2445 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			i = 0;
															#line 2446 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			i = 0;
															#line 8003 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			loopDepth = a_body1cont12loopHead1(loopDepth);
		}
		else
		{
			loopDepth = a_body1cont12cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont14(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1cont14(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1cont9when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont14(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont9when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont14(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<PostResolutionActor*>(this)->actor_wait_state > 0) static_cast<PostResolutionActor*>(this)->actor_wait_state = 0;
		static_cast<PostResolutionActor*>(this)->ActorCallback< PostResolutionActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PostResolutionActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("postResolution", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PostResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont9when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("postResolution", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< PostResolutionActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("postResolution", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PostResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("postResolution", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< PostResolutionActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("postResolution", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PostResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("postResolution", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont12cont1(int loopDepth) 
	{
															#line 2468 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->toCommit.saveTags(self->writtenTags);
															#line 2470 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->stats.mutations += self->mutationCount;
															#line 2471 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->stats.mutationBytes += self->mutationBytes;
															#line 2476 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (pProxyCommitData->committedVersion.get() < self->commitVersion - SERVER_KNOBS->MAX_READ_TRANSACTION_LIFE_VERSIONS)
															#line 8110 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 2478 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			self->computeDuration += g_network->timer_monotonic() - self->computeStart;
															#line 2479 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			waitVersionSpan = Span();
															#line 2480 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			;
															#line 8118 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			loopDepth = a_body1cont12cont1loopHead1(loopDepth);
		}
		else
		{
			loopDepth = a_body1cont12cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12cont2(int loopDepth) 
	{
															#line 2465 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->idempotencyClears = Standalone<VectorRef<MutationRef>>();
															#line 8132 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		loopDepth = a_body1cont12cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont12loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1(int loopDepth) 
	{
															#line 2446 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!(i < pProxyCommitData->idempotencyClears.size()))
															#line 8148 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
			return a_body1cont12break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 2447 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		auto& tags = pProxyCommitData->tagsForKey(pProxyCommitData->idempotencyClears[i].param1);
															#line 2448 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->toCommit.addTags(tags);
															#line 2450 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		Arena& arena = pProxyCommitData->idempotencyClears.arena();
															#line 2451 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (pProxyCommitData->acsBuilder != nullptr)
															#line 8160 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 2452 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			updateMutationWithAcsAndAddMutationToAcsBuilder( pProxyCommitData->acsBuilder, pProxyCommitData->idempotencyClears[i], tags, getCommitProxyAccumulativeChecksumIndex(pProxyCommitData->commitProxyIndex), pProxyCommitData->epoch, self->commitVersion, pProxyCommitData->dbgid);
															#line 8164 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		}
															#line 2461 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<WriteMutationRefVar> __when_expr_6 = writeMutation( self, SYSTEM_KEYSPACE_ENCRYPT_DOMAIN_ID, &pProxyCommitData->idempotencyClears[i], nullptr, &arena);
															#line 2461 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<PostResolutionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8170 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1when1(__when_expr_6.get(), loopDepth); };
		static_cast<PostResolutionActor*>(this)->actor_wait_state = 7;
															#line 2461 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< PostResolutionActor, 6, WriteMutationRefVar >*>(static_cast<PostResolutionActor*>(this)));
															#line 8175 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12break1(int loopDepth) 
	{
		try {
			return a_body1cont12cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12loopBody1cont1(WriteMutationRefVar const& var,int loopDepth) 
	{
															#line 2463 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		ASSERT(std::holds_alternative<MutationRef>(var));
															#line 2446 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		i++;
															#line 8199 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont12loopHead1(0);

		return loopDepth;
	}
	int a_body1cont12loopBody1cont1(WriteMutationRefVar && var,int loopDepth) 
	{
															#line 2463 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		ASSERT(std::holds_alternative<MutationRef>(var));
															#line 2446 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		i++;
															#line 8210 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont12loopHead1(0);

		return loopDepth;
	}
	int a_body1cont12loopBody1when1(WriteMutationRefVar const& var,int loopDepth) 
	{
		loopDepth = a_body1cont12loopBody1cont1(var, loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when1(WriteMutationRefVar && var,int loopDepth) 
	{
		loopDepth = a_body1cont12loopBody1cont1(std::move(var), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<PostResolutionActor*>(this)->actor_wait_state > 0) static_cast<PostResolutionActor*>(this)->actor_wait_state = 0;
		static_cast<PostResolutionActor*>(this)->ActorCallback< PostResolutionActor, 6, WriteMutationRefVar >::remove();

	}
	void a_callback_fire(ActorCallback< PostResolutionActor, 6, WriteMutationRefVar >*,WriteMutationRefVar const& value) 
	{
		fdb_probe_actor_enter("postResolution", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PostResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont12loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("postResolution", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< PostResolutionActor, 6, WriteMutationRefVar >*,WriteMutationRefVar && value) 
	{
		fdb_probe_actor_enter("postResolution", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PostResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont12loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("postResolution", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< PostResolutionActor, 6, WriteMutationRefVar >*,Error err) 
	{
		fdb_probe_actor_enter("postResolution", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PostResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("postResolution", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont12cont4(int loopDepth) 
	{
															#line 2516 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->msg = self->storeCommits.back().first.get();
															#line 2518 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (self->debugID.present())
															#line 8296 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 2519 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			g_traceBatch.addEvent( "CommitDebug", self->debugID.get().first(), "CommitProxyServer.commitBatch.AfterStoreCommits");
															#line 8300 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		}
															#line 2523 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		bool firstMessage = true;
															#line 2524 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		for( auto m : self->msg.messages ) {
															#line 2525 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (firstMessage)
															#line 8308 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			{
															#line 2526 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				ASSERT(!SERVER_KNOBS->ENABLE_VERSION_VECTOR || pProxyCommitData->db->get().logSystemConfig.numLogs() == self->tpcvMap.size());
															#line 2528 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				self->toCommit.addTxsTag();
															#line 8314 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			}
															#line 2530 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			self->toCommit.writeMessage(StringRef(m.begin(), m.size()), !firstMessage);
															#line 2531 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			firstMessage = false;
															#line 8320 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		}
															#line 2534 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (self->prevVersion && self->commitVersion - self->prevVersion < SERVER_KNOBS->MAX_VERSIONS_IN_FLIGHT / 2)
															#line 8324 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 2535 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			debug_advanceMaxCommittedVersion(UID(), self->commitVersion);
															#line 8328 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		}
															#line 2544 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (self->prevVersion && self->commitVersion - self->prevVersion < SERVER_KNOBS->MAX_VERSIONS_IN_FLIGHT / 2)
															#line 8332 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 2545 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			debug_advanceMaxCommittedVersion(UID(), self->commitVersion);
															#line 8336 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		}
															#line 2547 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->commitStartTime = now();
															#line 2548 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->lastStartCommit = self->commitStartTime;
															#line 2549 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		Optional<std::unordered_map<uint16_t, Version>> tpcvMap = Optional<std::unordered_map<uint16_t, Version>>();
															#line 2550 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (SERVER_KNOBS->ENABLE_VERSION_VECTOR)
															#line 8346 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 2551 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			tpcvMap = self->tpcvMap;
															#line 8350 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		}
															#line 2553 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (self->pProxyCommitData->acsBuilder != nullptr)
															#line 8354 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 2555 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			addAccumulativeChecksumMutations(self);
															#line 8358 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		}
															#line 2557 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		const auto versionSet = ILogSystem::PushVersionSet{ self->prevVersion, self->commitVersion, pProxyCommitData->committedVersion.get(), pProxyCommitData->minKnownCommittedVersion };
															#line 2561 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->loggingComplete = pProxyCommitData->logSystem->push(versionSet, self->toCommit, span.context, self->debugID, tpcvMap);
															#line 2564 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		float ratio = self->toCommit.getEmptyMessageRatio();
															#line 2565 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->stats.commitBatchingEmptyMessageRatio.addMeasurement(ratio);
															#line 2567 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!self->forceRecovery)
															#line 8370 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 2568 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			ASSERT(pProxyCommitData->latestLocalCommitBatchLogging.get() == self->localBatchNumber - 1);
															#line 2569 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			pProxyCommitData->latestLocalCommitBatchLogging.set(self->localBatchNumber);
															#line 8376 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		}
															#line 2572 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->computeDuration += g_network->timer_monotonic() - self->computeStart;
															#line 2573 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (self->batchOperations > 0)
															#line 8382 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 2574 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			double estimatedDelay = computeReleaseDelay(self, self->latencyBucket);
															#line 2575 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			double computePerOperation = std::min(SERVER_KNOBS->MAX_COMPUTE_PER_OPERATION, self->computeDuration / self->batchOperations);
															#line 2578 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (computePerOperation <= pProxyCommitData->commitComputePerOperation[self->latencyBucket])
															#line 8390 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			{
															#line 2579 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				pProxyCommitData->commitComputePerOperation[self->latencyBucket] = computePerOperation;
															#line 8394 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			}
			else
			{
															#line 2581 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				pProxyCommitData->commitComputePerOperation[self->latencyBucket] = SERVER_KNOBS->PROXY_COMPUTE_GROWTH_RATE * computePerOperation + ((1.0 - SERVER_KNOBS->PROXY_COMPUTE_GROWTH_RATE) * pProxyCommitData->commitComputePerOperation[self->latencyBucket]);
															#line 8400 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			}
															#line 2586 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			pProxyCommitData->stats.maxComputeNS = std::max<int64_t>(pProxyCommitData->stats.maxComputeNS, 1e9 * pProxyCommitData->commitComputePerOperation[self->latencyBucket]);
															#line 2589 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			pProxyCommitData->stats.minComputeNS = std::min<int64_t>(pProxyCommitData->stats.minComputeNS, 1e9 * pProxyCommitData->commitComputePerOperation[self->latencyBucket]);
															#line 2593 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (estimatedDelay >= SERVER_KNOBS->MAX_COMPUTE_DURATION_LOG_CUTOFF || self->computeDuration >= SERVER_KNOBS->MAX_COMPUTE_DURATION_LOG_CUTOFF)
															#line 8408 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			{
															#line 2595 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				TraceEvent(SevInfo, "LongComputeDuration", pProxyCommitData->dbgid) .suppressFor(10.0) .detail("EstimatedComputeDuration", estimatedDelay) .detail("ComputeDuration", self->computeDuration) .detail("ComputePerOperation", computePerOperation) .detail("LatencyBucket", self->latencyBucket) .detail("UpdatedComputePerOperationEstimate", pProxyCommitData->commitComputePerOperation[self->latencyBucket]) .detail("BatchBytes", self->batchBytes) .detail("BatchOperations", self->batchOperations);
															#line 8412 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			}
		}
															#line 2608 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->stats.processingMutationDist->sampleSeconds(g_network->timer_monotonic() - postResolutionQueuing);
															#line 2609 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!static_cast<PostResolutionActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PostResolutionActorState(); static_cast<PostResolutionActor*>(this)->destroy(); return 0; }
															#line 8419 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		new (&static_cast<PostResolutionActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PostResolutionActorState();
		static_cast<PostResolutionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont12cont5(int loopDepth) 
	{
															#line 2512 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		waitVersionSpan = Span{};
															#line 2513 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->computeStart = g_network->timer_monotonic();
															#line 8433 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		loopDepth = a_body1cont12cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont12cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont1loopBody1(int loopDepth) 
	{
															#line 2480 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!(pProxyCommitData->committedVersion.get() < self->commitVersion - SERVER_KNOBS->MAX_READ_TRANSACTION_LIFE_VERSIONS))
															#line 8449 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
			return a_body1cont12cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 2484 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		CODE_PROBE(true, "Semi-committed pipeline limited by MVCC window");
															#line 2486 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		waitVersionSpan = Span("MP:overMaxReadTransactionLifeVersions"_loc, span.context);
															#line 2488 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_7 = pProxyCommitData->committedVersion.whenAtLeast( self->commitVersion - SERVER_KNOBS->MAX_READ_TRANSACTION_LIFE_VERSIONS);
															#line 2487 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<PostResolutionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8461 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12cont1loopBody1when1(__when_expr_7.get(), loopDepth); };
															#line 2493 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_8 = pProxyCommitData->cx->onProxiesChanged();
															#line 8465 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12cont1loopBody1when2(__when_expr_8.get(), loopDepth); };
															#line 2497 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<GetRawCommittedVersionReply> __when_expr_9 = pProxyCommitData->master.getLiveCommittedVersion.getReply( GetRawCommittedVersionRequest(waitVersionSpan.context, debugID, invalidVersion), TaskPriority::GetLiveCommittedVersionReply);
															#line 8469 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12cont1loopBody1when3(__when_expr_9.get(), loopDepth); };
		static_cast<PostResolutionActor*>(this)->actor_wait_state = 8;
															#line 2488 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< PostResolutionActor, 7, Void >*>(static_cast<PostResolutionActor*>(this)));
															#line 2493 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< PostResolutionActor, 8, Void >*>(static_cast<PostResolutionActor*>(this)));
															#line 2497 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< PostResolutionActor, 9, GetRawCommittedVersionReply >*>(static_cast<PostResolutionActor*>(this)));
															#line 8478 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont12cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont12cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont12cont1loopBody1when1(Void const& _,int loopDepth) 
	{
															#line 2490 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_10 = yield();
															#line 2490 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<PostResolutionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8508 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1Catch1(__when_expr_10.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12cont1loopBody1when1when1(__when_expr_10.get(), loopDepth); };
		static_cast<PostResolutionActor*>(this)->actor_wait_state = 9;
															#line 2490 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< PostResolutionActor, 10, Void >*>(static_cast<PostResolutionActor*>(this)));
															#line 8513 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont1loopBody1when1(Void && _,int loopDepth) 
	{
															#line 2490 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_10 = yield();
															#line 2490 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<PostResolutionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8524 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1Catch1(__when_expr_10.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12cont1loopBody1when1when1(__when_expr_10.get(), loopDepth); };
		static_cast<PostResolutionActor*>(this)->actor_wait_state = 9;
															#line 2490 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< PostResolutionActor, 10, Void >*>(static_cast<PostResolutionActor*>(this)));
															#line 8529 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont1loopBody1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont1loopBody1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont1loopBody1when3(GetRawCommittedVersionReply const& v,int loopDepth) 
	{
															#line 2500 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (v.version > pProxyCommitData->committedVersion.get())
															#line 8550 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 2501 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			pProxyCommitData->locked = v.locked;
															#line 2502 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			pProxyCommitData->metadataVersion = v.metadataVersion;
															#line 2503 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			pProxyCommitData->committedVersion.set(v.version);
															#line 8558 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		}
															#line 2506 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (pProxyCommitData->committedVersion.get() < self->commitVersion - SERVER_KNOBS->MAX_READ_TRANSACTION_LIFE_VERSIONS)
															#line 8562 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 2508 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			StrictFuture<Void> __when_expr_11 = delay(SERVER_KNOBS->PROXY_SPIN_DELAY);
															#line 2508 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (static_cast<PostResolutionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8568 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1Catch1(__when_expr_11.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12cont1loopBody1when3when1(__when_expr_11.get(), loopDepth); };
			static_cast<PostResolutionActor*>(this)->actor_wait_state = 10;
															#line 2508 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< PostResolutionActor, 11, Void >*>(static_cast<PostResolutionActor*>(this)));
															#line 8573 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont12cont1loopBody1when3cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12cont1loopBody1when3(GetRawCommittedVersionReply && v,int loopDepth) 
	{
															#line 2500 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (v.version > pProxyCommitData->committedVersion.get())
															#line 8587 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 2501 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			pProxyCommitData->locked = v.locked;
															#line 2502 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			pProxyCommitData->metadataVersion = v.metadataVersion;
															#line 2503 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			pProxyCommitData->committedVersion.set(v.version);
															#line 8595 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		}
															#line 2506 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (pProxyCommitData->committedVersion.get() < self->commitVersion - SERVER_KNOBS->MAX_READ_TRANSACTION_LIFE_VERSIONS)
															#line 8599 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 2508 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			StrictFuture<Void> __when_expr_11 = delay(SERVER_KNOBS->PROXY_SPIN_DELAY);
															#line 2508 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (static_cast<PostResolutionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8605 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1Catch1(__when_expr_11.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12cont1loopBody1when3when1(__when_expr_11.get(), loopDepth); };
			static_cast<PostResolutionActor*>(this)->actor_wait_state = 10;
															#line 2508 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< PostResolutionActor, 11, Void >*>(static_cast<PostResolutionActor*>(this)));
															#line 8610 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont12cont1loopBody1when3cont1(loopDepth);
		}

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<PostResolutionActor*>(this)->actor_wait_state > 0) static_cast<PostResolutionActor*>(this)->actor_wait_state = 0;
		static_cast<PostResolutionActor*>(this)->ActorCallback< PostResolutionActor, 7, Void >::remove();
		static_cast<PostResolutionActor*>(this)->ActorCallback< PostResolutionActor, 8, Void >::remove();
		static_cast<PostResolutionActor*>(this)->ActorCallback< PostResolutionActor, 9, GetRawCommittedVersionReply >::remove();

	}
	int a_body1cont12cont1loopBody1when1cont1(Void const& _,int loopDepth) 
	{
		return a_body1cont12cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont12cont1loopBody1when1cont1(Void && _,int loopDepth) 
	{
		return a_body1cont12cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont12cont1loopBody1when1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont1loopBody1when1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont1loopBody1when1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont1loopBody1when1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<PostResolutionActor*>(this)->actor_wait_state > 0) static_cast<PostResolutionActor*>(this)->actor_wait_state = 0;
		static_cast<PostResolutionActor*>(this)->ActorCallback< PostResolutionActor, 10, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PostResolutionActor, 10, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("postResolution", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PostResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont12cont1loopBody1when1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("postResolution", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< PostResolutionActor, 10, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("postResolution", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PostResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont12cont1loopBody1when1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("postResolution", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< PostResolutionActor, 10, Void >*,Error err) 
	{
		fdb_probe_actor_enter("postResolution", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PostResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("postResolution", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< PostResolutionActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("postResolution", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PostResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont12cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("postResolution", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< PostResolutionActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("postResolution", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PostResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont12cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("postResolution", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< PostResolutionActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("postResolution", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PostResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("postResolution", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< PostResolutionActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("postResolution", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PostResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont12cont1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("postResolution", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< PostResolutionActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("postResolution", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PostResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont12cont1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("postResolution", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< PostResolutionActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("postResolution", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PostResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("postResolution", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont12cont1loopBody1when3cont1(int loopDepth) 
	{
		loopDepth = a_body1cont12cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont1loopBody1when3cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont1loopBody1when3cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont1loopBody1when3cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont1loopBody1when3cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont1loopBody1when3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont1loopBody1when3cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont1loopBody1when3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont1loopBody1when3cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<PostResolutionActor*>(this)->actor_wait_state > 0) static_cast<PostResolutionActor*>(this)->actor_wait_state = 0;
		static_cast<PostResolutionActor*>(this)->ActorCallback< PostResolutionActor, 11, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PostResolutionActor, 11, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("postResolution", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PostResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont12cont1loopBody1when3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("postResolution", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorCallback< PostResolutionActor, 11, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("postResolution", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PostResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont12cont1loopBody1when3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("postResolution", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_error(ActorCallback< PostResolutionActor, 11, Void >*,Error err) 
	{
		fdb_probe_actor_enter("postResolution", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PostResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("postResolution", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorCallback< PostResolutionActor, 9, GetRawCommittedVersionReply >*,GetRawCommittedVersionReply const& value) 
	{
		fdb_probe_actor_enter("postResolution", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PostResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont12cont1loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("postResolution", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< PostResolutionActor, 9, GetRawCommittedVersionReply >*,GetRawCommittedVersionReply && value) 
	{
		fdb_probe_actor_enter("postResolution", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PostResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont12cont1loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("postResolution", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< PostResolutionActor, 9, GetRawCommittedVersionReply >*,Error err) 
	{
		fdb_probe_actor_enter("postResolution", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PostResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("postResolution", reinterpret_cast<unsigned long>(this), 9);

	}
															#line 2321 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	CommitBatchContext* self;
															#line 2322 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	double postResolutionStart;
															#line 2323 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ProxyCommitData* const pProxyCommitData;
															#line 2324 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	std::vector<CommitTransactionRequest>& trs;
															#line 2325 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	const int64_t localBatchNumber;
															#line 2326 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	const Optional<UID>& debugID;
															#line 2327 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Span span;
															#line 2332 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	double postResolutionQueuing;
															#line 2445 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	int i;
															#line 2479 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Span waitVersionSpan;
															#line 8999 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
};
// This generated class is to be used only via postResolution()
															#line 2321 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class PostResolutionActor final : public Actor<Void>, public ActorCallback< PostResolutionActor, 0, Void >, public ActorCallback< PostResolutionActor, 1, Void >, public ActorCallback< PostResolutionActor, 2, Void >, public ActorCallback< PostResolutionActor, 3, Void >, public ActorCallback< PostResolutionActor, 4, Void >, public ActorCallback< PostResolutionActor, 5, Void >, public ActorCallback< PostResolutionActor, 6, WriteMutationRefVar >, public ActorCallback< PostResolutionActor, 7, Void >, public ActorCallback< PostResolutionActor, 10, Void >, public ActorCallback< PostResolutionActor, 8, Void >, public ActorCallback< PostResolutionActor, 9, GetRawCommittedVersionReply >, public ActorCallback< PostResolutionActor, 11, Void >, public FastAllocated<PostResolutionActor>, public PostResolutionActorState<PostResolutionActor> {
															#line 9004 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
public:
	using FastAllocated<PostResolutionActor>::operator new;
	using FastAllocated<PostResolutionActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9700952931419515392UL, 4200878526225016832UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PostResolutionActor, 0, Void >;
friend struct ActorCallback< PostResolutionActor, 1, Void >;
friend struct ActorCallback< PostResolutionActor, 2, Void >;
friend struct ActorCallback< PostResolutionActor, 3, Void >;
friend struct ActorCallback< PostResolutionActor, 4, Void >;
friend struct ActorCallback< PostResolutionActor, 5, Void >;
friend struct ActorCallback< PostResolutionActor, 6, WriteMutationRefVar >;
friend struct ActorCallback< PostResolutionActor, 7, Void >;
friend struct ActorCallback< PostResolutionActor, 10, Void >;
friend struct ActorCallback< PostResolutionActor, 8, Void >;
friend struct ActorCallback< PostResolutionActor, 9, GetRawCommittedVersionReply >;
friend struct ActorCallback< PostResolutionActor, 11, Void >;
															#line 2321 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	PostResolutionActor(CommitBatchContext* const& self) 
															#line 9032 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		 : Actor<Void>(),
		   PostResolutionActorState<PostResolutionActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("postResolution", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15846867638177296640UL, 14373598132617893888UL);
		ActorExecutionContextHelper __helper(static_cast<PostResolutionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("postResolution");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("postResolution", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PostResolutionActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< PostResolutionActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< PostResolutionActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< PostResolutionActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< PostResolutionActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< PostResolutionActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< PostResolutionActor, 6, WriteMutationRefVar >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< PostResolutionActor, 7, Void >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< PostResolutionActor, 10, Void >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< PostResolutionActor, 11, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 2321 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
[[nodiscard]] Future<Void> postResolution( CommitBatchContext* const& self ) {
															#line 2321 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	return Future<Void>(new PostResolutionActor(self));
															#line 9073 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
}

#line 2611 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"

															#line 9078 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
// This generated class is to be used only via transactionLogging()
															#line 2612 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
template <class TransactionLoggingActor>
															#line 2612 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class TransactionLoggingActorState {
															#line 9084 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
public:
															#line 2612 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	TransactionLoggingActorState(CommitBatchContext* const& self) 
															#line 2612 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
															#line 2612 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		 : self(self),
															#line 2613 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   tLoggingStart(g_network->timer_monotonic()),
															#line 2614 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   pProxyCommitData(self->pProxyCommitData),
															#line 2615 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   span("MP:transactionLogging"_loc, self->span.context)
															#line 9097 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
	{
		fdb_probe_actor_create("transactionLogging", reinterpret_cast<unsigned long>(this));

	}
	~TransactionLoggingActorState() 
	{
		fdb_probe_actor_destroy("transactionLogging", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 2619 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				StrictFuture<Version> __when_expr_0 = self->loggingComplete;
															#line 2618 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (static_cast<TransactionLoggingActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 9115 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
															#line 2625 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				StrictFuture<Void> __when_expr_1 = pProxyCommitData->committedVersion.whenAtLeast(self->commitVersion + 1);
															#line 9119 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
				static_cast<TransactionLoggingActor*>(this)->actor_wait_state = 1;
															#line 2619 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TransactionLoggingActor, 0, Version >*>(static_cast<TransactionLoggingActor*>(this)));
															#line 2625 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TransactionLoggingActor, 1, Void >*>(static_cast<TransactionLoggingActor*>(this)));
															#line 9126 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TransactionLoggingActorState();
		static_cast<TransactionLoggingActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2634 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->lastCommitLatency = now() - self->commitStartTime;
															#line 2635 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->lastCommitTime = std::max(pProxyCommitData->lastCommitTime.get(), self->commitStartTime);
															#line 2637 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_2 = yield(TaskPriority::ProxyCommitYield2);
															#line 2637 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<TransactionLoggingActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9161 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<TransactionLoggingActor*>(this)->actor_wait_state = 2;
															#line 2637 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TransactionLoggingActor, 2, Void >*>(static_cast<TransactionLoggingActor*>(this)));
															#line 9166 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2628 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (e.code() == error_code_broken_promise)
															#line 9176 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			{
															#line 2629 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				return a_body1Catch1(tlog_failed(), loopDepth);
															#line 9180 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			}
															#line 2631 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 9184 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Version const& ver,int loopDepth) 
	{
															#line 2620 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!SERVER_KNOBS->ENABLE_VERSION_VECTOR_TLOG_UNICAST)
															#line 9204 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 2621 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			pProxyCommitData->minKnownCommittedVersion = std::max(pProxyCommitData->minKnownCommittedVersion, ver);
															#line 9208 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		}
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Version && ver,int loopDepth) 
	{
															#line 2620 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!SERVER_KNOBS->ENABLE_VERSION_VECTOR_TLOG_UNICAST)
															#line 9218 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 2621 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			pProxyCommitData->minKnownCommittedVersion = std::max(pProxyCommitData->minKnownCommittedVersion, ver);
															#line 9222 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		}
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TransactionLoggingActor*>(this)->actor_wait_state > 0) static_cast<TransactionLoggingActor*>(this)->actor_wait_state = 0;
		static_cast<TransactionLoggingActor*>(this)->ActorCallback< TransactionLoggingActor, 0, Version >::remove();
		static_cast<TransactionLoggingActor*>(this)->ActorCallback< TransactionLoggingActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TransactionLoggingActor, 0, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("transactionLogging", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TransactionLoggingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("transactionLogging", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TransactionLoggingActor, 0, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("transactionLogging", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TransactionLoggingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("transactionLogging", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TransactionLoggingActor, 0, Version >*,Error err) 
	{
		fdb_probe_actor_enter("transactionLogging", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TransactionLoggingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("transactionLogging", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TransactionLoggingActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("transactionLogging", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TransactionLoggingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("transactionLogging", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TransactionLoggingActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("transactionLogging", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TransactionLoggingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("transactionLogging", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TransactionLoggingActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("transactionLogging", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TransactionLoggingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("transactionLogging", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 2639 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (pProxyCommitData->popRemoteTxs && self->msg.popTo > (pProxyCommitData->txsPopVersions.size() ? pProxyCommitData->txsPopVersions.back().second : pProxyCommitData->lastTxsPop))
															#line 9378 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 2642 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (pProxyCommitData->txsPopVersions.size() >= SERVER_KNOBS->MAX_TXS_POP_VERSION_HISTORY)
															#line 9382 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			{
															#line 2643 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				TraceEvent(SevWarnAlways, "DiscardingTxsPopHistory").suppressFor(1.0);
															#line 2644 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				pProxyCommitData->txsPopVersions.pop_front();
															#line 9388 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			}
															#line 2647 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			pProxyCommitData->txsPopVersions.emplace_back(self->commitVersion, self->msg.popTo);
															#line 9392 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		}
															#line 2649 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->logSystem->popTxs(self->msg.popTo);
															#line 2650 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->stats.tlogLoggingDist->sampleSeconds(g_network->timer_monotonic() - tLoggingStart);
															#line 2651 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!static_cast<TransactionLoggingActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TransactionLoggingActorState(); static_cast<TransactionLoggingActor*>(this)->destroy(); return 0; }
															#line 9400 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		new (&static_cast<TransactionLoggingActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TransactionLoggingActorState();
		static_cast<TransactionLoggingActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 2639 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (pProxyCommitData->popRemoteTxs && self->msg.popTo > (pProxyCommitData->txsPopVersions.size() ? pProxyCommitData->txsPopVersions.back().second : pProxyCommitData->lastTxsPop))
															#line 9412 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 2642 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (pProxyCommitData->txsPopVersions.size() >= SERVER_KNOBS->MAX_TXS_POP_VERSION_HISTORY)
															#line 9416 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			{
															#line 2643 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				TraceEvent(SevWarnAlways, "DiscardingTxsPopHistory").suppressFor(1.0);
															#line 2644 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				pProxyCommitData->txsPopVersions.pop_front();
															#line 9422 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			}
															#line 2647 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			pProxyCommitData->txsPopVersions.emplace_back(self->commitVersion, self->msg.popTo);
															#line 9426 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		}
															#line 2649 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->logSystem->popTxs(self->msg.popTo);
															#line 2650 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->stats.tlogLoggingDist->sampleSeconds(g_network->timer_monotonic() - tLoggingStart);
															#line 2651 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!static_cast<TransactionLoggingActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TransactionLoggingActorState(); static_cast<TransactionLoggingActor*>(this)->destroy(); return 0; }
															#line 9434 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		new (&static_cast<TransactionLoggingActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TransactionLoggingActorState();
		static_cast<TransactionLoggingActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TransactionLoggingActor*>(this)->actor_wait_state > 0) static_cast<TransactionLoggingActor*>(this)->actor_wait_state = 0;
		static_cast<TransactionLoggingActor*>(this)->ActorCallback< TransactionLoggingActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TransactionLoggingActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("transactionLogging", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TransactionLoggingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("transactionLogging", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TransactionLoggingActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("transactionLogging", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TransactionLoggingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("transactionLogging", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TransactionLoggingActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("transactionLogging", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TransactionLoggingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("transactionLogging", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 2612 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	CommitBatchContext* self;
															#line 2613 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	double tLoggingStart;
															#line 2614 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ProxyCommitData* const pProxyCommitData;
															#line 2615 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Span span;
															#line 9525 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
};
// This generated class is to be used only via transactionLogging()
															#line 2612 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class TransactionLoggingActor final : public Actor<Void>, public ActorCallback< TransactionLoggingActor, 0, Version >, public ActorCallback< TransactionLoggingActor, 1, Void >, public ActorCallback< TransactionLoggingActor, 2, Void >, public FastAllocated<TransactionLoggingActor>, public TransactionLoggingActorState<TransactionLoggingActor> {
															#line 9530 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
public:
	using FastAllocated<TransactionLoggingActor>::operator new;
	using FastAllocated<TransactionLoggingActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8108715124679270656UL, 5551241319675979520UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TransactionLoggingActor, 0, Version >;
friend struct ActorCallback< TransactionLoggingActor, 1, Void >;
friend struct ActorCallback< TransactionLoggingActor, 2, Void >;
															#line 2612 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	TransactionLoggingActor(CommitBatchContext* const& self) 
															#line 9549 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		 : Actor<Void>(),
		   TransactionLoggingActorState<TransactionLoggingActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("transactionLogging", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3004937098039659520UL, 11889376626278748672UL);
		ActorExecutionContextHelper __helper(static_cast<TransactionLoggingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("transactionLogging");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("transactionLogging", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TransactionLoggingActor, 0, Version >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TransactionLoggingActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 2612 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
[[nodiscard]] Future<Void> transactionLogging( CommitBatchContext* const& self ) {
															#line 2612 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	return Future<Void>(new TransactionLoggingActor(self));
															#line 9582 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
}

#line 2653 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"

															#line 9587 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
// This generated class is to be used only via reply()
															#line 2654 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
template <class ReplyActor>
															#line 2654 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class ReplyActorState {
															#line 9593 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
public:
															#line 2654 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ReplyActorState(CommitBatchContext* const& self) 
															#line 2654 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
															#line 2654 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		 : self(self),
															#line 2655 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   replyStart(g_network->timer_monotonic()),
															#line 2656 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   pProxyCommitData(self->pProxyCommitData),
															#line 2657 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   span("MP:reply"_loc, self->span.context),
															#line 2659 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   debugID(self->debugID)
															#line 9608 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
	{
		fdb_probe_actor_create("reply", reinterpret_cast<unsigned long>(this));

	}
	~ReplyActorState() 
	{
		fdb_probe_actor_destroy("reply", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2661 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (!SERVER_KNOBS->ENABLE_VERSION_VECTOR_TLOG_UNICAST)
															#line 9623 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			{
															#line 2665 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (self->prevVersion && self->commitVersion - self->prevVersion < SERVER_KNOBS->MAX_VERSIONS_IN_FLIGHT / 2)
															#line 9627 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
				{
															#line 2667 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					debug_advanceMinCommittedVersion(UID(), self->commitVersion);
															#line 9631 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
				}
			}
															#line 2674 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (debugID.present())
															#line 9636 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			{
															#line 2675 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				g_traceBatch.addEvent("CommitDebug", debugID.get().first(), "CommitProxyServer.commitBatch.AfterLogPush");
															#line 9640 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			}
															#line 2677 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			for( auto& p : self->storeCommits ) {
															#line 2678 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				ASSERT(!p.second.isReady());
															#line 2679 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				p.first.get().acknowledge.send(Void());
															#line 2680 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				ASSERT(p.second.isReady());
															#line 9650 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			}
															#line 2689 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			CODE_PROBE(pProxyCommitData->committedVersion.get() > self->commitVersion, "later version was reported committed first");
															#line 2692 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (self->commitVersion >= pProxyCommitData->committedVersion.get())
															#line 9656 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			{
															#line 2693 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				writtenTags = Optional<std::set<Tag>>();
															#line 2694 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (SERVER_KNOBS->ENABLE_VERSION_VECTOR)
															#line 9662 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
				{
															#line 2695 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					writtenTags = self->writtenTags;
															#line 9666 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
				}
															#line 2697 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				StrictFuture<Void> __when_expr_0 = pProxyCommitData->master.reportLiveCommittedVersion.getReply( ReportRawCommittedVersionRequest(self->commitVersion, self->lockedAfter, self->metadataVersionAfter, pProxyCommitData->minKnownCommittedVersion, self->prevVersion, writtenTags), TaskPriority::ProxyMasterVersionReply);
															#line 2697 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (static_cast<ReplyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9672 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<ReplyActor*>(this)->actor_wait_state = 1;
															#line 2697 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ReplyActor, 0, Void >*>(static_cast<ReplyActor*>(this)));
															#line 9677 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ReplyActorState();
		static_cast<ReplyActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2707 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (debugID.present())
															#line 9705 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 2708 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			g_traceBatch.addEvent( "CommitDebug", debugID.get().first(), "CommitProxyServer.commitBatch.AfterReportRawCommittedVersion");
															#line 9709 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		}
															#line 2712 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (SERVER_KNOBS->ENABLE_VERSION_VECTOR_TLOG_UNICAST)
															#line 9713 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 2715 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (self->prevVersion && self->commitVersion - self->prevVersion < SERVER_KNOBS->MAX_VERSIONS_IN_FLIGHT / 2)
															#line 9717 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			{
															#line 2717 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				debug_advanceMinCommittedVersion(UID(), self->commitVersion);
															#line 9721 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			}
		}
															#line 2721 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (self->commitVersion > pProxyCommitData->committedVersion.get())
															#line 9726 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 2722 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			pProxyCommitData->locked = self->lockedAfter;
															#line 2723 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			pProxyCommitData->metadataVersion = self->metadataVersionAfter;
															#line 2724 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			pProxyCommitData->committedVersion.set(self->commitVersion);
															#line 2725 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (SERVER_KNOBS->ENABLE_VERSION_VECTOR_TLOG_UNICAST)
															#line 9736 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			{
															#line 2726 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				ASSERT(self->loggingComplete.isReady());
															#line 2727 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				pProxyCommitData->minKnownCommittedVersion = std::max(pProxyCommitData->minKnownCommittedVersion, self->loggingComplete.get());
															#line 9742 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			}
		}
															#line 2732 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (self->forceRecovery)
															#line 9747 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 2733 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			TraceEvent(SevWarn, "RestartingTxnSubsystem", pProxyCommitData->dbgid).detail("Stage", "ProxyShutdown");
															#line 2734 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			return a_body1Catch1(worker_removed(), loopDepth);
															#line 9753 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		}
															#line 2739 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		double endTime = g_network->timer();
															#line 2742 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		std::fill(self->nextTr.begin(), self->nextTr.end(), 0);
															#line 2743 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		std::unordered_map<uint8_t, int16_t> idCountsForKey;
															#line 2744 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		for(int t = 0;t < self->trs.size();t++) {
															#line 2745 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			auto& tr = self->trs[t];
															#line 2746 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (self->committed[t] == ConflictBatch::TransactionCommitted && (!self->locked || tr.isLockAware()))
															#line 9767 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			{
															#line 2747 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				ASSERT_WE_THINK(self->commitVersion != invalidVersion);
															#line 2748 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (self->trs[t].idempotencyId.valid())
															#line 9773 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
				{
															#line 2749 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					idCountsForKey[uint8_t(t >> 8)] += 1;
															#line 9777 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
				}
															#line 2751 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				tr.reply.send(CommitID(self->commitVersion, t, self->metadataVersionAfter));
															#line 9781 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			}
			else
			{
															#line 2752 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (self->committed[t] == ConflictBatch::TransactionTooOld)
															#line 9787 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
				{
															#line 2753 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					tr.reply.sendError(transaction_too_old());
															#line 9791 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
				}
				else
				{
															#line 2754 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					if (self->committed[t] == ConflictBatch::TransactionTenantFailure || self->committed[t] == ConflictBatch::TransactionLockReject)
															#line 9797 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
					{
															#line 2757 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						ASSERT(tr.reply.isSet());
															#line 9801 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
					}
					else
					{
															#line 2761 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						if (tr.transaction.report_conflicting_keys)
															#line 9807 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
						{
															#line 2762 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
							Standalone<VectorRef<int>> conflictingKRIndices;
															#line 2763 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
							for( int resolverInd : self->transactionResolverMap[t] ) {
															#line 2764 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
								auto const& cKRs = self->resolution[resolverInd] .conflictingKeyRangeMap[self->nextTr[resolverInd]];
															#line 2768 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
								for( auto const& rCRIndex : cKRs ) {
															#line 2771 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
									conflictingKRIndices.push_back(conflictingKRIndices.arena(), self->txReadConflictRangeIndexMap[t][resolverInd][rCRIndex]);
															#line 9819 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
								}
							}
															#line 2775 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
							ASSERT(conflictingKRIndices.size());
															#line 2776 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
							tr.reply.send(CommitID( invalidVersion, t, Optional<Value>(), Optional<Standalone<VectorRef<int>>>(conflictingKRIndices)));
															#line 9826 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
						}
						else
						{
															#line 2779 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
							tr.reply.sendError(not_committed());
															#line 9832 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
						}
					}
				}
			}
															#line 2784 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			for( int resolverInd : self->transactionResolverMap[t] ) {
															#line 2785 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				self->nextTr[resolverInd]++;
															#line 9841 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			}
															#line 2788 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			const double duration = endTime - tr.requestTime();
															#line 2789 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			pProxyCommitData->stats.commitLatencySample.addMeasurement(duration);
															#line 2790 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (pProxyCommitData->latencyBandConfig.present())
															#line 9849 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			{
															#line 2791 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				bool filter = self->maxTransactionBytes > pProxyCommitData->latencyBandConfig.get().commitConfig.maxCommitBytes.orDefault( std::numeric_limits<int>::max());
															#line 2794 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				pProxyCommitData->stats.commitLatencyBands.addMeasurement(duration, 1, Filtered(filter));
															#line 9855 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			}
		}
															#line 2798 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		for( auto [highOrderBatchIndex, count] : idCountsForKey ) {
															#line 2799 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			pProxyCommitData->expectedIdempotencyIdCountForKey.send( ExpectedIdempotencyIdCountForKey{ self->commitVersion, count, highOrderBatchIndex });
															#line 9862 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		}
															#line 2803 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (self->pProxyCommitData->encryptMode.isEncryptionEnabled() && self->encryptionTime.present())
															#line 9866 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 2804 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			pProxyCommitData->stats.encryptionLatencySample.addMeasurement(self->encryptionTime.get());
															#line 9870 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		}
															#line 2806 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		++pProxyCommitData->stats.commitBatchOut;
															#line 2807 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->stats.txnCommitOut += self->trs.size();
															#line 2808 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->stats.txnConflicts += self->trs.size() - self->commitCount;
															#line 2809 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->stats.txnCommitOutSuccess += self->commitCount;
															#line 2811 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (now() - pProxyCommitData->lastCoalesceTime > SERVER_KNOBS->RESOLVER_COALESCE_TIME)
															#line 9882 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 2812 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			pProxyCommitData->lastCoalesceTime = now();
															#line 2813 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			int lastSize = pProxyCommitData->keyResolvers.size();
															#line 2814 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			auto rs = pProxyCommitData->keyResolvers.ranges();
															#line 2815 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			Version oldestVersion = self->prevVersion - SERVER_KNOBS->MAX_WRITE_TRANSACTION_LIFE_VERSIONS;
															#line 2816 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			for(auto r = rs.begin();r != rs.end();++r) {
															#line 2817 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				for(;r->value().size() > 1 && r->value()[1].first < oldestVersion;) {
															#line 2818 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					r->value().pop_front();
															#line 9898 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
				}
															#line 2819 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (r->value().size() && r->value().front().first < oldestVersion)
															#line 9902 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
				{
															#line 2820 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					r->value().front().first = 0;
															#line 9906 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
				}
			}
															#line 2822 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (SERVER_KNOBS->PROXY_USE_RESOLVER_PRIVATE_MUTATIONS)
															#line 9911 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			{
															#line 2824 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				pProxyCommitData->keyResolvers.coalesce(normalKeys);
															#line 2825 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				auto& versions = pProxyCommitData->systemKeyVersions;
															#line 2826 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				for(;versions.size() > 1 && versions[1] < oldestVersion;) {
															#line 2827 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					versions.pop_front();
															#line 9921 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
				}
															#line 2829 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (!versions.empty() && versions[0] < oldestVersion)
															#line 9925 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
				{
															#line 2830 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					versions[0] = 0;
															#line 9929 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
				}
			}
			else
			{
															#line 2833 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				pProxyCommitData->keyResolvers.coalesce(allKeys);
															#line 9936 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			}
															#line 2835 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (pProxyCommitData->keyResolvers.size() != lastSize)
															#line 9940 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			{
															#line 2836 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				TraceEvent("KeyResolverSize", pProxyCommitData->dbgid) .detail("Size", pProxyCommitData->keyResolvers.size());
															#line 9944 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			}
		}
															#line 2841 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		double target_latency = (now() - self->startTime) * SERVER_KNOBS->COMMIT_TRANSACTION_BATCH_INTERVAL_LATENCY_FRACTION;
															#line 2843 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->commitBatchInterval = std::max(SERVER_KNOBS->COMMIT_TRANSACTION_BATCH_INTERVAL_MIN, std::min(SERVER_KNOBS->COMMIT_TRANSACTION_BATCH_INTERVAL_MAX, target_latency * SERVER_KNOBS->COMMIT_TRANSACTION_BATCH_INTERVAL_SMOOTHER_ALPHA + pProxyCommitData->commitBatchInterval * (1 - SERVER_KNOBS->COMMIT_TRANSACTION_BATCH_INTERVAL_SMOOTHER_ALPHA)));
															#line 2849 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->stats.commitBatchingWindowSize.addMeasurement(pProxyCommitData->commitBatchInterval);
															#line 2850 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->commitBatchesMemBytesCount -= self->currentBatchMemBytesCount;
															#line 2851 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		ASSERT_ABORT(pProxyCommitData->commitBatchesMemBytesCount >= 0);
															#line 2852 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->releaseFuture;
															#line 2852 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<ReplyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9961 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ReplyActor*>(this)->actor_wait_state = 2;
															#line 2852 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ReplyActor, 1, Void >*>(static_cast<ReplyActor*>(this)));
															#line 9966 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ReplyActor*>(this)->actor_wait_state > 0) static_cast<ReplyActor*>(this)->actor_wait_state = 0;
		static_cast<ReplyActor*>(this)->ActorCallback< ReplyActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ReplyActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("reply", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReplyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reply", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ReplyActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("reply", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReplyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reply", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ReplyActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("reply", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReplyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reply", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont8(Void const& _,int loopDepth) 
	{
															#line 2853 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->stats.replyCommitDist->sampleSeconds(g_network->timer_monotonic() - replyStart);
															#line 2854 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!static_cast<ReplyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ReplyActorState(); static_cast<ReplyActor*>(this)->destroy(); return 0; }
															#line 10064 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		new (&static_cast<ReplyActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ReplyActorState();
		static_cast<ReplyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont8(Void && _,int loopDepth) 
	{
															#line 2853 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pProxyCommitData->stats.replyCommitDist->sampleSeconds(g_network->timer_monotonic() - replyStart);
															#line 2854 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!static_cast<ReplyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ReplyActorState(); static_cast<ReplyActor*>(this)->destroy(); return 0; }
															#line 10078 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		new (&static_cast<ReplyActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ReplyActorState();
		static_cast<ReplyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ReplyActor*>(this)->actor_wait_state > 0) static_cast<ReplyActor*>(this)->actor_wait_state = 0;
		static_cast<ReplyActor*>(this)->ActorCallback< ReplyActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ReplyActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("reply", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReplyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reply", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ReplyActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("reply", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReplyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reply", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ReplyActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("reply", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReplyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reply", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 2654 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	CommitBatchContext* self;
															#line 2655 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	double replyStart;
															#line 2656 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ProxyCommitData* const pProxyCommitData;
															#line 2657 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Span span;
															#line 2659 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	const Optional<UID>& debugID;
															#line 2693 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Optional<std::set<Tag>> writtenTags;
															#line 10173 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
};
// This generated class is to be used only via reply()
															#line 2654 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class ReplyActor final : public Actor<Void>, public ActorCallback< ReplyActor, 0, Void >, public ActorCallback< ReplyActor, 1, Void >, public FastAllocated<ReplyActor>, public ReplyActorState<ReplyActor> {
															#line 10178 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
public:
	using FastAllocated<ReplyActor>::operator new;
	using FastAllocated<ReplyActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11981573040169410048UL, 13124213213316952320UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ReplyActor, 0, Void >;
friend struct ActorCallback< ReplyActor, 1, Void >;
															#line 2654 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ReplyActor(CommitBatchContext* const& self) 
															#line 10196 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		 : Actor<Void>(),
		   ReplyActorState<ReplyActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("reply", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(412875400346227200UL, 2164551364787983616UL);
		ActorExecutionContextHelper __helper(static_cast<ReplyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("reply");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("reply", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ReplyActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ReplyActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 2654 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
[[nodiscard]] Future<Void> reply( CommitBatchContext* const& self ) {
															#line 2654 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	return Future<Void>(new ReplyActor(self));
															#line 10229 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
}

#line 2856 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"

// Commit one batch of transactions trs
															#line 10235 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
// This generated class is to be used only via commitBatchImpl()
															#line 2858 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
template <class CommitBatchImplActor>
															#line 2858 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class CommitBatchImplActorState {
															#line 10241 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
public:
															#line 2858 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	CommitBatchImplActorState(CommitBatchContext* const& pContext) 
															#line 2858 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
															#line 2858 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		 : pContext(pContext)
															#line 10248 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
	{
		fdb_probe_actor_create("commitBatchImpl", reinterpret_cast<unsigned long>(this));

	}
	~CommitBatchImplActorState() 
	{
		fdb_probe_actor_destroy("commitBatchImpl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2862 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			pContext->stage = INITIALIZE;
															#line 2863 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			getCurrentLineage()->modify(&TransactionLineage::operation) = TransactionLineage::Operation::Commit;
															#line 2867 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(0, TaskPriority::ProxyCommit);
															#line 2867 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (static_cast<CommitBatchImplActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10269 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CommitBatchImplActor*>(this)->actor_wait_state = 1;
															#line 2867 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CommitBatchImplActor, 0, Void >*>(static_cast<CommitBatchImplActor*>(this)));
															#line 10274 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CommitBatchImplActorState();
		static_cast<CommitBatchImplActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 2869 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pContext->pProxyCommitData->lastVersionTime = pContext->startTime;
															#line 2870 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		++pContext->pProxyCommitData->stats.commitBatchIn;
															#line 2871 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pContext->setupTraceBatch();
															#line 2875 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pContext->stage = PRE_RESOLUTION;
															#line 2876 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_1 = CommitBatch::preresolutionProcessing(pContext);
															#line 2876 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<CommitBatchImplActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10307 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CommitBatchImplActor*>(this)->actor_wait_state = 2;
															#line 2876 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CommitBatchImplActor, 1, Void >*>(static_cast<CommitBatchImplActor*>(this)));
															#line 10312 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 2869 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pContext->pProxyCommitData->lastVersionTime = pContext->startTime;
															#line 2870 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		++pContext->pProxyCommitData->stats.commitBatchIn;
															#line 2871 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pContext->setupTraceBatch();
															#line 2875 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pContext->stage = PRE_RESOLUTION;
															#line 2876 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_1 = CommitBatch::preresolutionProcessing(pContext);
															#line 2876 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<CommitBatchImplActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10331 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CommitBatchImplActor*>(this)->actor_wait_state = 2;
															#line 2876 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CommitBatchImplActor, 1, Void >*>(static_cast<CommitBatchImplActor*>(this)));
															#line 10336 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CommitBatchImplActor*>(this)->actor_wait_state > 0) static_cast<CommitBatchImplActor*>(this)->actor_wait_state = 0;
		static_cast<CommitBatchImplActor*>(this)->ActorCallback< CommitBatchImplActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CommitBatchImplActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("commitBatchImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatchImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitBatchImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CommitBatchImplActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("commitBatchImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatchImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitBatchImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CommitBatchImplActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("commitBatchImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatchImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitBatchImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 2877 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (pContext->rejected)
															#line 10420 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 2878 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			pContext->pProxyCommitData->commitBatchesMemBytesCount -= pContext->currentBatchMemBytesCount;
															#line 2879 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (!static_cast<CommitBatchImplActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CommitBatchImplActorState(); static_cast<CommitBatchImplActor*>(this)->destroy(); return 0; }
															#line 10426 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			new (&static_cast<CommitBatchImplActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~CommitBatchImplActorState();
			static_cast<CommitBatchImplActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2883 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pContext->stage = RESOLUTION;
															#line 2884 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_2 = CommitBatch::getResolution(pContext);
															#line 2884 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<CommitBatchImplActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10438 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<CommitBatchImplActor*>(this)->actor_wait_state = 3;
															#line 2884 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CommitBatchImplActor, 2, Void >*>(static_cast<CommitBatchImplActor*>(this)));
															#line 10443 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 2877 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (pContext->rejected)
															#line 10452 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 2878 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			pContext->pProxyCommitData->commitBatchesMemBytesCount -= pContext->currentBatchMemBytesCount;
															#line 2879 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (!static_cast<CommitBatchImplActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CommitBatchImplActorState(); static_cast<CommitBatchImplActor*>(this)->destroy(); return 0; }
															#line 10458 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			new (&static_cast<CommitBatchImplActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~CommitBatchImplActorState();
			static_cast<CommitBatchImplActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2883 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pContext->stage = RESOLUTION;
															#line 2884 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_2 = CommitBatch::getResolution(pContext);
															#line 2884 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<CommitBatchImplActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10470 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<CommitBatchImplActor*>(this)->actor_wait_state = 3;
															#line 2884 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CommitBatchImplActor, 2, Void >*>(static_cast<CommitBatchImplActor*>(this)));
															#line 10475 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CommitBatchImplActor*>(this)->actor_wait_state > 0) static_cast<CommitBatchImplActor*>(this)->actor_wait_state = 0;
		static_cast<CommitBatchImplActor*>(this)->ActorCallback< CommitBatchImplActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CommitBatchImplActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("commitBatchImpl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatchImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitBatchImpl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CommitBatchImplActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("commitBatchImpl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatchImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitBatchImpl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CommitBatchImplActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("commitBatchImpl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatchImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitBatchImpl", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 2888 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pContext->stage = POST_RESOLUTION;
															#line 2889 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_3 = CommitBatch::postResolution(pContext);
															#line 2889 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<CommitBatchImplActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10563 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<CommitBatchImplActor*>(this)->actor_wait_state = 4;
															#line 2889 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CommitBatchImplActor, 3, Void >*>(static_cast<CommitBatchImplActor*>(this)));
															#line 10568 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 2888 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pContext->stage = POST_RESOLUTION;
															#line 2889 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_3 = CommitBatch::postResolution(pContext);
															#line 2889 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<CommitBatchImplActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10581 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<CommitBatchImplActor*>(this)->actor_wait_state = 4;
															#line 2889 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CommitBatchImplActor, 3, Void >*>(static_cast<CommitBatchImplActor*>(this)));
															#line 10586 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CommitBatchImplActor*>(this)->actor_wait_state > 0) static_cast<CommitBatchImplActor*>(this)->actor_wait_state = 0;
		static_cast<CommitBatchImplActor*>(this)->ActorCallback< CommitBatchImplActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CommitBatchImplActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("commitBatchImpl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatchImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitBatchImpl", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CommitBatchImplActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("commitBatchImpl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatchImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitBatchImpl", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CommitBatchImplActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("commitBatchImpl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatchImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitBatchImpl", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 2892 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pContext->stage = TRANSACTION_LOGGING;
															#line 2893 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_4 = CommitBatch::transactionLogging(pContext);
															#line 2893 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<CommitBatchImplActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10674 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont5when1(__when_expr_4.get(), loopDepth); };
		static_cast<CommitBatchImplActor*>(this)->actor_wait_state = 5;
															#line 2893 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< CommitBatchImplActor, 4, Void >*>(static_cast<CommitBatchImplActor*>(this)));
															#line 10679 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 2892 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pContext->stage = TRANSACTION_LOGGING;
															#line 2893 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_4 = CommitBatch::transactionLogging(pContext);
															#line 2893 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<CommitBatchImplActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10692 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont5when1(__when_expr_4.get(), loopDepth); };
		static_cast<CommitBatchImplActor*>(this)->actor_wait_state = 5;
															#line 2893 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< CommitBatchImplActor, 4, Void >*>(static_cast<CommitBatchImplActor*>(this)));
															#line 10697 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<CommitBatchImplActor*>(this)->actor_wait_state > 0) static_cast<CommitBatchImplActor*>(this)->actor_wait_state = 0;
		static_cast<CommitBatchImplActor*>(this)->ActorCallback< CommitBatchImplActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CommitBatchImplActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("commitBatchImpl", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatchImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitBatchImpl", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< CommitBatchImplActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("commitBatchImpl", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatchImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitBatchImpl", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< CommitBatchImplActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("commitBatchImpl", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatchImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitBatchImpl", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 2897 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pContext->stage = REPLY;
															#line 2898 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_5 = CommitBatch::reply(pContext);
															#line 2898 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<CommitBatchImplActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10785 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont6when1(__when_expr_5.get(), loopDepth); };
		static_cast<CommitBatchImplActor*>(this)->actor_wait_state = 6;
															#line 2898 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< CommitBatchImplActor, 5, Void >*>(static_cast<CommitBatchImplActor*>(this)));
															#line 10790 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 2897 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pContext->stage = REPLY;
															#line 2898 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_5 = CommitBatch::reply(pContext);
															#line 2898 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<CommitBatchImplActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10803 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont6when1(__when_expr_5.get(), loopDepth); };
		static_cast<CommitBatchImplActor*>(this)->actor_wait_state = 6;
															#line 2898 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< CommitBatchImplActor, 5, Void >*>(static_cast<CommitBatchImplActor*>(this)));
															#line 10808 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<CommitBatchImplActor*>(this)->actor_wait_state > 0) static_cast<CommitBatchImplActor*>(this)->actor_wait_state = 0;
		static_cast<CommitBatchImplActor*>(this)->ActorCallback< CommitBatchImplActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CommitBatchImplActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("commitBatchImpl", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatchImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitBatchImpl", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< CommitBatchImplActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("commitBatchImpl", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatchImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitBatchImpl", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< CommitBatchImplActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("commitBatchImpl", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatchImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitBatchImpl", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont7(Void const& _,int loopDepth) 
	{
															#line 2900 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pContext->stage = COMPLETE;
															#line 2901 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!static_cast<CommitBatchImplActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CommitBatchImplActorState(); static_cast<CommitBatchImplActor*>(this)->destroy(); return 0; }
															#line 10894 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		new (&static_cast<CommitBatchImplActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CommitBatchImplActorState();
		static_cast<CommitBatchImplActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont7(Void && _,int loopDepth) 
	{
															#line 2900 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		pContext->stage = COMPLETE;
															#line 2901 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!static_cast<CommitBatchImplActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CommitBatchImplActorState(); static_cast<CommitBatchImplActor*>(this)->destroy(); return 0; }
															#line 10908 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		new (&static_cast<CommitBatchImplActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CommitBatchImplActorState();
		static_cast<CommitBatchImplActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<CommitBatchImplActor*>(this)->actor_wait_state > 0) static_cast<CommitBatchImplActor*>(this)->actor_wait_state = 0;
		static_cast<CommitBatchImplActor*>(this)->ActorCallback< CommitBatchImplActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CommitBatchImplActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("commitBatchImpl", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatchImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitBatchImpl", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< CommitBatchImplActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("commitBatchImpl", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatchImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitBatchImpl", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< CommitBatchImplActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("commitBatchImpl", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatchImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitBatchImpl", reinterpret_cast<unsigned long>(this), 5);

	}
															#line 2858 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	CommitBatchContext* pContext;
															#line 10993 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
};
// This generated class is to be used only via commitBatchImpl()
															#line 2858 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class CommitBatchImplActor final : public Actor<Void>, public ActorCallback< CommitBatchImplActor, 0, Void >, public ActorCallback< CommitBatchImplActor, 1, Void >, public ActorCallback< CommitBatchImplActor, 2, Void >, public ActorCallback< CommitBatchImplActor, 3, Void >, public ActorCallback< CommitBatchImplActor, 4, Void >, public ActorCallback< CommitBatchImplActor, 5, Void >, public FastAllocated<CommitBatchImplActor>, public CommitBatchImplActorState<CommitBatchImplActor> {
															#line 10998 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
public:
	using FastAllocated<CommitBatchImplActor>::operator new;
	using FastAllocated<CommitBatchImplActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1297061235507559424UL, 7356108830261931008UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CommitBatchImplActor, 0, Void >;
friend struct ActorCallback< CommitBatchImplActor, 1, Void >;
friend struct ActorCallback< CommitBatchImplActor, 2, Void >;
friend struct ActorCallback< CommitBatchImplActor, 3, Void >;
friend struct ActorCallback< CommitBatchImplActor, 4, Void >;
friend struct ActorCallback< CommitBatchImplActor, 5, Void >;
															#line 2858 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	CommitBatchImplActor(CommitBatchContext* const& pContext) 
															#line 11020 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		 : Actor<Void>(),
		   CommitBatchImplActorState<CommitBatchImplActor>(pContext),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("commitBatchImpl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11797433405479390208UL, 8635865864950152704UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatchImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("commitBatchImpl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("commitBatchImpl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CommitBatchImplActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CommitBatchImplActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CommitBatchImplActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< CommitBatchImplActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< CommitBatchImplActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< CommitBatchImplActor, 5, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 2858 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
[[nodiscard]] Future<Void> commitBatchImpl( CommitBatchContext* const& pContext ) {
															#line 2858 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	return Future<Void>(new CommitBatchImplActor(pContext));
															#line 11057 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
}

#line 2903 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"

} // namespace CommitBatch

															#line 11064 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
namespace {
// This generated class is to be used only via commitBatch()
															#line 2906 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
template <class CommitBatchActor>
															#line 2906 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class CommitBatchActorState {
															#line 11071 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
public:
															#line 2906 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	CommitBatchActorState(ProxyCommitData* const& pCommitData,std::vector<CommitTransactionRequest>* const& trs,int const& currentBatchMemBytesCount) 
															#line 2906 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
															#line 2906 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		 : pCommitData(pCommitData),
															#line 2906 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   trs(trs),
															#line 2906 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   currentBatchMemBytesCount(currentBatchMemBytesCount),
															#line 2910 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   context(pCommitData, trs, currentBatchMemBytesCount)
															#line 11084 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
	{
		fdb_probe_actor_create("commitBatch", reinterpret_cast<unsigned long>(this));

	}
	~CommitBatchActorState() 
	{
		fdb_probe_actor_destroy("commitBatch", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2912 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			Future<Void> commit = CommitBatch::commitBatchImpl(&context);
															#line 2919 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			Future<Void> livenessTimeout = timeoutErrorIfCleared( commit, pCommitData->encryptionMonitor->degraded(), SERVER_KNOBS->COMMIT_PROXY_LIVENESS_TIMEOUT);
															#line 2922 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			Future<Void> maxLivenessTimeout = timeoutError(livenessTimeout, SERVER_KNOBS->COMMIT_PROXY_MAX_LIVENESS_TIMEOUT);
															#line 11103 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			try {
															#line 2924 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				StrictFuture<Void> __when_expr_0 = maxLivenessTimeout;
															#line 2924 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (static_cast<CommitBatchActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 11109 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<CommitBatchActor*>(this)->actor_wait_state = 1;
															#line 2924 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CommitBatchActor, 0, Void >*>(static_cast<CommitBatchActor*>(this)));
															#line 11114 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CommitBatchActorState();
		static_cast<CommitBatchActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2930 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!static_cast<CommitBatchActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CommitBatchActorState(); static_cast<CommitBatchActor*>(this)->destroy(); return 0; }
															#line 11143 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		new (&static_cast<CommitBatchActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CommitBatchActorState();
		static_cast<CommitBatchActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& err,int loopDepth=0) 
	{
		try {
															#line 2926 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			TraceEvent(SevInfo, "CommitBatchFailed").detail("Stage", context.stage).detail("ErrorCode", err.code());
															#line 2927 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			return a_body1Catch1(failed_to_progress(), loopDepth);
															#line 11158 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CommitBatchActor*>(this)->actor_wait_state > 0) static_cast<CommitBatchActor*>(this)->actor_wait_state = 0;
		static_cast<CommitBatchActor*>(this)->ActorCallback< CommitBatchActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CommitBatchActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("commitBatch", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitBatch", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CommitBatchActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("commitBatch", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitBatch", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CommitBatchActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("commitBatch", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitBatch", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 2906 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ProxyCommitData* pCommitData;
															#line 2906 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	std::vector<CommitTransactionRequest>* trs;
															#line 2906 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	int currentBatchMemBytesCount;
															#line 2910 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	CommitBatch::CommitBatchContext context;
															#line 11276 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
};
// This generated class is to be used only via commitBatch()
															#line 2906 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class CommitBatchActor final : public Actor<Void>, public ActorCallback< CommitBatchActor, 0, Void >, public FastAllocated<CommitBatchActor>, public CommitBatchActorState<CommitBatchActor> {
															#line 11281 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
public:
	using FastAllocated<CommitBatchActor>::operator new;
	using FastAllocated<CommitBatchActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5488603610504897024UL, 2627591930370033408UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CommitBatchActor, 0, Void >;
															#line 2906 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	CommitBatchActor(ProxyCommitData* const& pCommitData,std::vector<CommitTransactionRequest>* const& trs,int const& currentBatchMemBytesCount) 
															#line 11298 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		 : Actor<Void>(),
		   CommitBatchActorState<CommitBatchActor>(pCommitData, trs, currentBatchMemBytesCount),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("commitBatch", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17605101362369555456UL, 10066483790240320512UL);
		ActorExecutionContextHelper __helper(static_cast<CommitBatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("commitBatch");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("commitBatch", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CommitBatchActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2906 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
[[nodiscard]] Future<Void> commitBatch( ProxyCommitData* const& pCommitData, std::vector<CommitTransactionRequest>* const& trs, int const& currentBatchMemBytesCount ) {
															#line 2906 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	return Future<Void>(new CommitBatchActor(pCommitData, trs, currentBatchMemBytesCount));
															#line 11331 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
}

#line 2932 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"

// Add tss mapping data to the reply, if any of the included storage servers have a TSS pair
void maybeAddTssMapping(GetKeyServerLocationsReply& reply,
                        ProxyCommitData* commitData,
                        std::unordered_set<UID>& included,
                        UID ssId) {
	if (!included.contains(ssId)) {
		auto mappingItr = commitData->tssMapping.find(ssId);
		if (mappingItr != commitData->tssMapping.end()) {
			reply.resultsTssMapping.push_back(*mappingItr);
		}
		included.insert(ssId);
	}
}

void addTagMapping(GetKeyServerLocationsReply& reply, ProxyCommitData* commitData) {
	for (const auto& [_, shard] : reply.results) {
		for (auto& ssi : shard) {
			auto iter = commitData->storageCache.find(ssi.id());
			ASSERT_WE_THINK(iter != commitData->storageCache.end());
			reply.resultsTagMapping.emplace_back(ssi.id(), iter->second->tag);
		}
	}
}

															#line 11360 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
namespace {
// This generated class is to be used only via doTenantIdRequest()
															#line 2957 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
template <class DoTenantIdRequestActor>
															#line 2957 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class DoTenantIdRequestActorState {
															#line 11367 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
public:
															#line 2957 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	DoTenantIdRequestActorState(GetTenantIdRequest const& req,ProxyCommitData* const& commitData) 
															#line 2957 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
															#line 2957 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		 : req(req),
															#line 2957 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   commitData(commitData)
															#line 11376 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
	{
		fdb_probe_actor_create("doTenantIdRequest", reinterpret_cast<unsigned long>(this));

	}
	~DoTenantIdRequestActorState() 
	{
		fdb_probe_actor_destroy("doTenantIdRequest", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2959 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			StrictFuture<Void> __when_expr_0 = commitData->validState.getFuture();
															#line 2959 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (static_cast<DoTenantIdRequestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11393 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DoTenantIdRequestActor*>(this)->actor_wait_state = 1;
															#line 2959 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DoTenantIdRequestActor, 0, Void >*>(static_cast<DoTenantIdRequestActor*>(this)));
															#line 11398 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DoTenantIdRequestActorState();
		static_cast<DoTenantIdRequestActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 2960 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(0, TaskPriority::DefaultEndpoint);
															#line 2960 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<DoTenantIdRequestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11423 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<DoTenantIdRequestActor*>(this)->actor_wait_state = 2;
															#line 2960 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DoTenantIdRequestActor, 1, Void >*>(static_cast<DoTenantIdRequestActor*>(this)));
															#line 11428 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 2960 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(0, TaskPriority::DefaultEndpoint);
															#line 2960 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<DoTenantIdRequestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11439 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<DoTenantIdRequestActor*>(this)->actor_wait_state = 2;
															#line 2960 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DoTenantIdRequestActor, 1, Void >*>(static_cast<DoTenantIdRequestActor*>(this)));
															#line 11444 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DoTenantIdRequestActor*>(this)->actor_wait_state > 0) static_cast<DoTenantIdRequestActor*>(this)->actor_wait_state = 0;
		static_cast<DoTenantIdRequestActor*>(this)->ActorCallback< DoTenantIdRequestActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoTenantIdRequestActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doTenantIdRequest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoTenantIdRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doTenantIdRequest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DoTenantIdRequestActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doTenantIdRequest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoTenantIdRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doTenantIdRequest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DoTenantIdRequestActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doTenantIdRequest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoTenantIdRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doTenantIdRequest", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 2962 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		CODE_PROBE( req.minTenantVersion != latestVersion, "Tenant ID request with specific version", probe::decoration::rare);
															#line 2964 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		CODE_PROBE(req.minTenantVersion == latestVersion, "Tenant ID request at latest version");
															#line 2966 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		tenantId = ErrorOr<int64_t>();
															#line 2967 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		minTenantVersion = req.minTenantVersion == latestVersion ? commitData->stats.lastCommitVersionAssigned + 1 : req.minTenantVersion;
															#line 2971 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		futureVersionDelay = minTenantVersion > commitData->stats.lastCommitVersionAssigned + 1 ? delay(SERVER_KNOBS->FUTURE_VERSION_DELAY) : Never();
															#line 2975 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (minTenantVersion > commitData->version.get())
															#line 11538 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 2976 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			CODE_PROBE(true, "Tenant ID request trigger commit");
															#line 2977 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			commitData->triggerCommit.set(true);
															#line 11544 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		}
															#line 2984 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_2 = commitData->version.whenAtLeast(minTenantVersion);
															#line 2980 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<DoTenantIdRequestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11550 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
															#line 2987 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_3 = futureVersionDelay;
															#line 11554 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont2when2(__when_expr_3.get(), loopDepth); };
		static_cast<DoTenantIdRequestActor*>(this)->actor_wait_state = 3;
															#line 2984 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< DoTenantIdRequestActor, 2, Void >*>(static_cast<DoTenantIdRequestActor*>(this)));
															#line 2987 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< DoTenantIdRequestActor, 3, Void >*>(static_cast<DoTenantIdRequestActor*>(this)));
															#line 11561 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 2962 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		CODE_PROBE( req.minTenantVersion != latestVersion, "Tenant ID request with specific version", probe::decoration::rare);
															#line 2964 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		CODE_PROBE(req.minTenantVersion == latestVersion, "Tenant ID request at latest version");
															#line 2966 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		tenantId = ErrorOr<int64_t>();
															#line 2967 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		minTenantVersion = req.minTenantVersion == latestVersion ? commitData->stats.lastCommitVersionAssigned + 1 : req.minTenantVersion;
															#line 2971 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		futureVersionDelay = minTenantVersion > commitData->stats.lastCommitVersionAssigned + 1 ? delay(SERVER_KNOBS->FUTURE_VERSION_DELAY) : Never();
															#line 2975 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (minTenantVersion > commitData->version.get())
															#line 11580 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 2976 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			CODE_PROBE(true, "Tenant ID request trigger commit");
															#line 2977 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			commitData->triggerCommit.set(true);
															#line 11586 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		}
															#line 2984 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_2 = commitData->version.whenAtLeast(minTenantVersion);
															#line 2980 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<DoTenantIdRequestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11592 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
															#line 2987 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_3 = futureVersionDelay;
															#line 11596 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont2when2(__when_expr_3.get(), loopDepth); };
		static_cast<DoTenantIdRequestActor*>(this)->actor_wait_state = 3;
															#line 2984 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< DoTenantIdRequestActor, 2, Void >*>(static_cast<DoTenantIdRequestActor*>(this)));
															#line 2987 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< DoTenantIdRequestActor, 3, Void >*>(static_cast<DoTenantIdRequestActor*>(this)));
															#line 11603 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DoTenantIdRequestActor*>(this)->actor_wait_state > 0) static_cast<DoTenantIdRequestActor*>(this)->actor_wait_state = 0;
		static_cast<DoTenantIdRequestActor*>(this)->ActorCallback< DoTenantIdRequestActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoTenantIdRequestActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doTenantIdRequest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoTenantIdRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doTenantIdRequest", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DoTenantIdRequestActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doTenantIdRequest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoTenantIdRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doTenantIdRequest", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DoTenantIdRequestActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doTenantIdRequest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoTenantIdRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doTenantIdRequest", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 2996 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		auto itr = commitData->tenantNameIndex.find(req.tenantName);
															#line 2997 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (itr != commitData->tenantNameIndex.end())
															#line 11689 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 2998 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			req.reply.send(GetTenantIdReply(itr->second));
															#line 11693 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		}
		else
		{
															#line 3000 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			TraceEvent(SevWarn, "CommitProxyTenantNotFound", commitData->dbgid).detail("TenantName", req.tenantName);
															#line 3001 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			++commitData->stats.tenantIdRequestErrors;
															#line 3002 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			req.reply.sendError(tenant_not_found());
															#line 11703 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		}
															#line 3005 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		++commitData->stats.tenantIdRequestOut;
															#line 3006 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!static_cast<DoTenantIdRequestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DoTenantIdRequestActorState(); static_cast<DoTenantIdRequestActor*>(this)->destroy(); return 0; }
															#line 11709 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		new (&static_cast<DoTenantIdRequestActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DoTenantIdRequestActorState();
		static_cast<DoTenantIdRequestActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
															#line 2985 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		CODE_PROBE(true, "Tenant ID request wait for min version");
															#line 11721 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
															#line 2985 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		CODE_PROBE(true, "Tenant ID request wait for min version");
															#line 11730 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when2(Void const& _,int loopDepth) 
	{
															#line 2988 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		CODE_PROBE(true, "Tenant ID request future version", probe::decoration::rare);
															#line 2989 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		req.reply.sendError(future_version());
															#line 2990 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		++commitData->stats.tenantIdRequestOut;
															#line 2991 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		++commitData->stats.tenantIdRequestErrors;
															#line 2992 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!static_cast<DoTenantIdRequestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DoTenantIdRequestActorState(); static_cast<DoTenantIdRequestActor*>(this)->destroy(); return 0; }
															#line 11747 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		new (&static_cast<DoTenantIdRequestActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DoTenantIdRequestActorState();
		static_cast<DoTenantIdRequestActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when2(Void && _,int loopDepth) 
	{
															#line 2988 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		CODE_PROBE(true, "Tenant ID request future version", probe::decoration::rare);
															#line 2989 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		req.reply.sendError(future_version());
															#line 2990 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		++commitData->stats.tenantIdRequestOut;
															#line 2991 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		++commitData->stats.tenantIdRequestErrors;
															#line 2992 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!static_cast<DoTenantIdRequestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DoTenantIdRequestActorState(); static_cast<DoTenantIdRequestActor*>(this)->destroy(); return 0; }
															#line 11767 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		new (&static_cast<DoTenantIdRequestActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DoTenantIdRequestActorState();
		static_cast<DoTenantIdRequestActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<DoTenantIdRequestActor*>(this)->actor_wait_state > 0) static_cast<DoTenantIdRequestActor*>(this)->actor_wait_state = 0;
		static_cast<DoTenantIdRequestActor*>(this)->ActorCallback< DoTenantIdRequestActor, 2, Void >::remove();
		static_cast<DoTenantIdRequestActor*>(this)->ActorCallback< DoTenantIdRequestActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoTenantIdRequestActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doTenantIdRequest", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoTenantIdRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doTenantIdRequest", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< DoTenantIdRequestActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doTenantIdRequest", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoTenantIdRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doTenantIdRequest", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< DoTenantIdRequestActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doTenantIdRequest", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoTenantIdRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doTenantIdRequest", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< DoTenantIdRequestActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doTenantIdRequest", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoTenantIdRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doTenantIdRequest", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< DoTenantIdRequestActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doTenantIdRequest", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoTenantIdRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doTenantIdRequest", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< DoTenantIdRequestActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doTenantIdRequest", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoTenantIdRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doTenantIdRequest", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 2957 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	GetTenantIdRequest req;
															#line 2957 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ProxyCommitData* commitData;
															#line 2966 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ErrorOr<int64_t> tenantId;
															#line 2967 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Version minTenantVersion;
															#line 2971 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Future<Void> futureVersionDelay;
															#line 11906 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
};
// This generated class is to be used only via doTenantIdRequest()
															#line 2957 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class DoTenantIdRequestActor final : public Actor<Void>, public ActorCallback< DoTenantIdRequestActor, 0, Void >, public ActorCallback< DoTenantIdRequestActor, 1, Void >, public ActorCallback< DoTenantIdRequestActor, 2, Void >, public ActorCallback< DoTenantIdRequestActor, 3, Void >, public FastAllocated<DoTenantIdRequestActor>, public DoTenantIdRequestActorState<DoTenantIdRequestActor> {
															#line 11911 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
public:
	using FastAllocated<DoTenantIdRequestActor>::operator new;
	using FastAllocated<DoTenantIdRequestActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13772952734567078912UL, 3819583784633141760UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DoTenantIdRequestActor, 0, Void >;
friend struct ActorCallback< DoTenantIdRequestActor, 1, Void >;
friend struct ActorCallback< DoTenantIdRequestActor, 2, Void >;
friend struct ActorCallback< DoTenantIdRequestActor, 3, Void >;
															#line 2957 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	DoTenantIdRequestActor(GetTenantIdRequest const& req,ProxyCommitData* const& commitData) 
															#line 11931 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		 : Actor<Void>(),
		   DoTenantIdRequestActorState<DoTenantIdRequestActor>(req, commitData),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("doTenantIdRequest", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8442246751508607232UL, 8187247901102380288UL);
		ActorExecutionContextHelper __helper(static_cast<DoTenantIdRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("doTenantIdRequest");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("doTenantIdRequest", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DoTenantIdRequestActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DoTenantIdRequestActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< DoTenantIdRequestActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2957 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
[[nodiscard]] static Future<Void> doTenantIdRequest( GetTenantIdRequest const& req, ProxyCommitData* const& commitData ) {
															#line 2957 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	return Future<Void>(new DoTenantIdRequestActor(req, commitData));
															#line 11966 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
}

#line 3008 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"

															#line 11971 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
namespace {
// This generated class is to be used only via tenantIdServer()
															#line 3009 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
template <class TenantIdServerActor>
															#line 3009 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class TenantIdServerActorState {
															#line 11978 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
public:
															#line 3009 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	TenantIdServerActorState(CommitProxyInterface const& proxy,PromiseStream<Future<Void>> const& addActor,ProxyCommitData* const& commitData) 
															#line 3009 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
															#line 3009 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		 : proxy(proxy),
															#line 3009 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   addActor(addActor),
															#line 3009 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   commitData(commitData)
															#line 11989 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
	{
		fdb_probe_actor_create("tenantIdServer", reinterpret_cast<unsigned long>(this));

	}
	~TenantIdServerActorState() 
	{
		fdb_probe_actor_destroy("tenantIdServer", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 3012 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			;
															#line 12004 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TenantIdServerActorState();
		static_cast<TenantIdServerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 3013 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		auto __when_expr_0 = proxy.getTenantId.getFuture();
															#line 12034 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_0), FutureStream<GetTenantIdRequest>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<GetTenantIdRequest>>::value, "invalid type");
															#line 3013 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<TenantIdServerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 12038 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
		static_cast<TenantIdServerActor*>(this)->actor_wait_state = 1;
															#line 3013 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< TenantIdServerActor, 0, GetTenantIdRequest >*>(static_cast<TenantIdServerActor*>(this)));
															#line 12043 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(GetTenantIdRequest const& req,int loopDepth) 
	{
															#line 3015 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (commitData->stats.tenantIdRequestIn.getValue() - commitData->stats.tenantIdRequestOut.getValue() > SERVER_KNOBS->TENANT_ID_REQUEST_MAX_QUEUE_SIZE || (g_network->isSimulated() && !g_simulator->speedUpSimulation && BUGGIFY_WITH_PROB(0.0001)))
															#line 12052 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 3018 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			++commitData->stats.tenantIdRequestErrors;
															#line 3019 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			req.reply.sendError(commit_proxy_memory_limit_exceeded());
															#line 3020 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			TraceEvent(SevWarnAlways, "ProxyGetTenantRequestThresholdExceeded").suppressFor(60);
															#line 12060 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		}
		else
		{
															#line 3022 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			++commitData->stats.tenantIdRequestIn;
															#line 3023 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			addActor.send(doTenantIdRequest(req, commitData));
															#line 12068 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(GetTenantIdRequest && req,int loopDepth) 
	{
															#line 3015 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (commitData->stats.tenantIdRequestIn.getValue() - commitData->stats.tenantIdRequestOut.getValue() > SERVER_KNOBS->TENANT_ID_REQUEST_MAX_QUEUE_SIZE || (g_network->isSimulated() && !g_simulator->speedUpSimulation && BUGGIFY_WITH_PROB(0.0001)))
															#line 12078 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 3018 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			++commitData->stats.tenantIdRequestErrors;
															#line 3019 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			req.reply.sendError(commit_proxy_memory_limit_exceeded());
															#line 3020 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			TraceEvent(SevWarnAlways, "ProxyGetTenantRequestThresholdExceeded").suppressFor(60);
															#line 12086 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		}
		else
		{
															#line 3022 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			++commitData->stats.tenantIdRequestIn;
															#line 3023 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			addActor.send(doTenantIdRequest(req, commitData));
															#line 12094 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(GetTenantIdRequest const& req,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(req, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(GetTenantIdRequest && req,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(req), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TenantIdServerActor*>(this)->actor_wait_state > 0) static_cast<TenantIdServerActor*>(this)->actor_wait_state = 0;
		static_cast<TenantIdServerActor*>(this)->ActorSingleCallback< TenantIdServerActor, 0, GetTenantIdRequest >::remove();

	}
	void a_callback_fire(ActorSingleCallback< TenantIdServerActor, 0, GetTenantIdRequest >*,GetTenantIdRequest const& value) 
	{
		fdb_probe_actor_enter("tenantIdServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantIdServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantIdServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< TenantIdServerActor, 0, GetTenantIdRequest >*,GetTenantIdRequest && value) 
	{
		fdb_probe_actor_enter("tenantIdServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantIdServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantIdServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< TenantIdServerActor, 0, GetTenantIdRequest >*,Error err) 
	{
		fdb_probe_actor_enter("tenantIdServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TenantIdServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantIdServer", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 3009 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	CommitProxyInterface proxy;
															#line 3009 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	PromiseStream<Future<Void>> addActor;
															#line 3009 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ProxyCommitData* commitData;
															#line 12181 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
};
// This generated class is to be used only via tenantIdServer()
															#line 3009 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class TenantIdServerActor final : public Actor<Void>, public ActorSingleCallback< TenantIdServerActor, 0, GetTenantIdRequest >, public FastAllocated<TenantIdServerActor>, public TenantIdServerActorState<TenantIdServerActor> {
															#line 12186 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
public:
	using FastAllocated<TenantIdServerActor>::operator new;
	using FastAllocated<TenantIdServerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1219994188027763456UL, 7781406581831967488UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< TenantIdServerActor, 0, GetTenantIdRequest >;
															#line 3009 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	TenantIdServerActor(CommitProxyInterface const& proxy,PromiseStream<Future<Void>> const& addActor,ProxyCommitData* const& commitData) 
															#line 12203 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		 : Actor<Void>(),
		   TenantIdServerActorState<TenantIdServerActor>(proxy, addActor, commitData),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("tenantIdServer", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4403679220055348992UL, 11064231585235136768UL);
		ActorExecutionContextHelper __helper(static_cast<TenantIdServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("tenantIdServer");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("tenantIdServer", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< TenantIdServerActor, 0, GetTenantIdRequest >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 3009 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
[[nodiscard]] static Future<Void> tenantIdServer( CommitProxyInterface const& proxy, PromiseStream<Future<Void>> const& addActor, ProxyCommitData* const& commitData ) {
															#line 3009 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	return Future<Void>(new TenantIdServerActor(proxy, addActor, commitData));
															#line 12236 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
}

#line 3027 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"

															#line 12241 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
namespace {
// This generated class is to be used only via doKeyServerLocationRequest()
															#line 3028 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
template <class DoKeyServerLocationRequestActor>
															#line 3028 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class DoKeyServerLocationRequestActorState {
															#line 12248 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
public:
															#line 3028 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	DoKeyServerLocationRequestActorState(GetKeyServerLocationsRequest const& req,ProxyCommitData* const& commitData) 
															#line 3028 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
															#line 3028 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		 : req(req),
															#line 3028 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   commitData(commitData)
															#line 12257 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
	{
		fdb_probe_actor_create("doKeyServerLocationRequest", reinterpret_cast<unsigned long>(this));

	}
	~DoKeyServerLocationRequestActorState() 
	{
		fdb_probe_actor_destroy("doKeyServerLocationRequest", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 3030 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			getCurrentLineage()->modify(&TransactionLineage::operation) = TransactionLineage::Operation::GetKeyServersLocations;
															#line 3031 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			getCurrentLineage()->modify(&TransactionLineage::txID) = req.spanContext.traceID;
															#line 3033 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			CODE_PROBE(req.minTenantVersion != latestVersion, "Key server location request with specific version");
															#line 3034 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			CODE_PROBE(req.minTenantVersion == latestVersion, "Key server location request at latest version");
															#line 3036 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			StrictFuture<Void> __when_expr_0 = commitData->validState.getFuture();
															#line 3036 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (static_cast<DoKeyServerLocationRequestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12282 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DoKeyServerLocationRequestActor*>(this)->actor_wait_state = 1;
															#line 3036 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DoKeyServerLocationRequestActor, 0, Void >*>(static_cast<DoKeyServerLocationRequestActor*>(this)));
															#line 12287 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DoKeyServerLocationRequestActorState();
		static_cast<DoKeyServerLocationRequestActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 3038 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		minVersion = req.minTenantVersion == latestVersion ? commitData->stats.lastCommitVersionAssigned + 1 : req.minTenantVersion;
															#line 3041 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(0, TaskPriority::DefaultEndpoint);
															#line 3041 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<DoKeyServerLocationRequestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12314 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<DoKeyServerLocationRequestActor*>(this)->actor_wait_state = 2;
															#line 3041 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DoKeyServerLocationRequestActor, 1, Void >*>(static_cast<DoKeyServerLocationRequestActor*>(this)));
															#line 12319 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 3038 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		minVersion = req.minTenantVersion == latestVersion ? commitData->stats.lastCommitVersionAssigned + 1 : req.minTenantVersion;
															#line 3041 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(0, TaskPriority::DefaultEndpoint);
															#line 3041 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<DoKeyServerLocationRequestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12332 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<DoKeyServerLocationRequestActor*>(this)->actor_wait_state = 2;
															#line 3041 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DoKeyServerLocationRequestActor, 1, Void >*>(static_cast<DoKeyServerLocationRequestActor*>(this)));
															#line 12337 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DoKeyServerLocationRequestActor*>(this)->actor_wait_state > 0) static_cast<DoKeyServerLocationRequestActor*>(this)->actor_wait_state = 0;
		static_cast<DoKeyServerLocationRequestActor*>(this)->ActorCallback< DoKeyServerLocationRequestActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoKeyServerLocationRequestActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doKeyServerLocationRequest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoKeyServerLocationRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doKeyServerLocationRequest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DoKeyServerLocationRequestActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doKeyServerLocationRequest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoKeyServerLocationRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doKeyServerLocationRequest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DoKeyServerLocationRequestActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doKeyServerLocationRequest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoKeyServerLocationRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doKeyServerLocationRequest", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 3043 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<bool> __when_expr_2 = checkTenant(commitData, req.tenant.tenantId, minVersion, "GetKeyServerLocation");
															#line 3043 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<DoKeyServerLocationRequestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12423 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<DoKeyServerLocationRequestActor*>(this)->actor_wait_state = 3;
															#line 3043 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< DoKeyServerLocationRequestActor, 2, bool >*>(static_cast<DoKeyServerLocationRequestActor*>(this)));
															#line 12428 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 3043 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<bool> __when_expr_2 = checkTenant(commitData, req.tenant.tenantId, minVersion, "GetKeyServerLocation");
															#line 3043 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<DoKeyServerLocationRequestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12439 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<DoKeyServerLocationRequestActor*>(this)->actor_wait_state = 3;
															#line 3043 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< DoKeyServerLocationRequestActor, 2, bool >*>(static_cast<DoKeyServerLocationRequestActor*>(this)));
															#line 12444 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DoKeyServerLocationRequestActor*>(this)->actor_wait_state > 0) static_cast<DoKeyServerLocationRequestActor*>(this)->actor_wait_state = 0;
		static_cast<DoKeyServerLocationRequestActor*>(this)->ActorCallback< DoKeyServerLocationRequestActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoKeyServerLocationRequestActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doKeyServerLocationRequest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoKeyServerLocationRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doKeyServerLocationRequest", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DoKeyServerLocationRequestActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doKeyServerLocationRequest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoKeyServerLocationRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doKeyServerLocationRequest", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DoKeyServerLocationRequestActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doKeyServerLocationRequest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoKeyServerLocationRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doKeyServerLocationRequest", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(bool const& validTenant,int loopDepth) 
	{
															#line 3045 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!validTenant)
															#line 12528 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 3046 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			CODE_PROBE(true, "Key server location request with invalid tenant");
															#line 3047 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			++commitData->stats.keyServerLocationOut;
															#line 3048 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			req.reply.sendError(tenant_not_found());
															#line 3049 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (!static_cast<DoKeyServerLocationRequestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DoKeyServerLocationRequestActorState(); static_cast<DoKeyServerLocationRequestActor*>(this)->destroy(); return 0; }
															#line 12538 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			new (&static_cast<DoKeyServerLocationRequestActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~DoKeyServerLocationRequestActorState();
			static_cast<DoKeyServerLocationRequestActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 3052 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		std::unordered_set<UID> tssMappingsIncluded;
															#line 3053 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		GetKeyServerLocationsReply rep;
															#line 3055 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (req.tenant.hasTenant())
															#line 12550 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 3056 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			req.begin = req.begin.withPrefix(req.tenant.prefix.get(), req.arena);
															#line 3057 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (req.end.present())
															#line 12556 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			{
															#line 3058 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				req.end = req.end.get().withPrefix(req.tenant.prefix.get(), req.arena);
															#line 12560 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			}
		}
															#line 3062 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!req.end.present())
															#line 12565 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 3063 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			auto r = req.reverse ? commitData->keyInfo.rangeContainingKeyBefore(req.begin) : commitData->keyInfo.rangeContaining(req.begin);
															#line 3065 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			std::vector<StorageServerInterface> ssis;
															#line 3066 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			ssis.reserve(r.value().src_info.size());
															#line 3067 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			for( auto& it : r.value().src_info ) {
															#line 3068 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				ssis.push_back(it->interf);
															#line 3069 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				maybeAddTssMapping(rep, commitData, tssMappingsIncluded, it->interf.id());
															#line 12579 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			}
															#line 3071 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			rep.results.emplace_back(TenantAPI::clampRangeToTenant(r.range(), req.tenant, req.arena), ssis);
															#line 12583 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		}
		else
		{
															#line 3072 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (!req.reverse)
															#line 12589 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			{
															#line 3073 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				int count = 0;
															#line 3074 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				for(auto r = commitData->keyInfo.rangeContaining(req.begin);r != commitData->keyInfo.ranges().end() && count < req.limit && r.begin() < req.end.get();++r) {
															#line 3077 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					std::vector<StorageServerInterface> ssis;
															#line 3078 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					ssis.reserve(r.value().src_info.size());
															#line 3079 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					for( auto& it : r.value().src_info ) {
															#line 3080 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						ssis.push_back(it->interf);
															#line 3081 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						maybeAddTssMapping(rep, commitData, tssMappingsIncluded, it->interf.id());
															#line 12605 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
					}
															#line 3083 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					rep.results.emplace_back(TenantAPI::clampRangeToTenant(r.range(), req.tenant, req.arena), ssis);
															#line 3084 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					count++;
															#line 12611 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
				}
			}
			else
			{
															#line 3087 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				int count = 0;
															#line 3088 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				auto r = commitData->keyInfo.rangeContainingKeyBefore(req.end.get());
															#line 3089 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				for(;count < req.limit && req.begin < r.end();) {
															#line 3090 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					std::vector<StorageServerInterface> ssis;
															#line 3091 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					ssis.reserve(r.value().src_info.size());
															#line 3092 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					for( auto& it : r.value().src_info ) {
															#line 3093 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						ssis.push_back(it->interf);
															#line 3094 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						maybeAddTssMapping(rep, commitData, tssMappingsIncluded, it->interf.id());
															#line 12632 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
					}
															#line 3096 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					rep.results.emplace_back(TenantAPI::clampRangeToTenant(r.range(), req.tenant, req.arena), ssis);
															#line 3097 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					if (r == commitData->keyInfo.ranges().begin())
															#line 12638 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
					{
						break;
					}
															#line 3100 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					count++;
															#line 3101 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					--r;
															#line 12646 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
				}
			}
		}
															#line 3104 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		addTagMapping(rep, commitData);
															#line 3105 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		req.reply.send(rep);
															#line 3106 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		++commitData->stats.keyServerLocationOut;
															#line 3107 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!static_cast<DoKeyServerLocationRequestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DoKeyServerLocationRequestActorState(); static_cast<DoKeyServerLocationRequestActor*>(this)->destroy(); return 0; }
															#line 12658 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		new (&static_cast<DoKeyServerLocationRequestActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DoKeyServerLocationRequestActorState();
		static_cast<DoKeyServerLocationRequestActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(bool && validTenant,int loopDepth) 
	{
															#line 3045 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!validTenant)
															#line 12670 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 3046 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			CODE_PROBE(true, "Key server location request with invalid tenant");
															#line 3047 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			++commitData->stats.keyServerLocationOut;
															#line 3048 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			req.reply.sendError(tenant_not_found());
															#line 3049 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (!static_cast<DoKeyServerLocationRequestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DoKeyServerLocationRequestActorState(); static_cast<DoKeyServerLocationRequestActor*>(this)->destroy(); return 0; }
															#line 12680 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			new (&static_cast<DoKeyServerLocationRequestActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~DoKeyServerLocationRequestActorState();
			static_cast<DoKeyServerLocationRequestActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 3052 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		std::unordered_set<UID> tssMappingsIncluded;
															#line 3053 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		GetKeyServerLocationsReply rep;
															#line 3055 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (req.tenant.hasTenant())
															#line 12692 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 3056 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			req.begin = req.begin.withPrefix(req.tenant.prefix.get(), req.arena);
															#line 3057 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (req.end.present())
															#line 12698 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			{
															#line 3058 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				req.end = req.end.get().withPrefix(req.tenant.prefix.get(), req.arena);
															#line 12702 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			}
		}
															#line 3062 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!req.end.present())
															#line 12707 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 3063 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			auto r = req.reverse ? commitData->keyInfo.rangeContainingKeyBefore(req.begin) : commitData->keyInfo.rangeContaining(req.begin);
															#line 3065 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			std::vector<StorageServerInterface> ssis;
															#line 3066 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			ssis.reserve(r.value().src_info.size());
															#line 3067 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			for( auto& it : r.value().src_info ) {
															#line 3068 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				ssis.push_back(it->interf);
															#line 3069 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				maybeAddTssMapping(rep, commitData, tssMappingsIncluded, it->interf.id());
															#line 12721 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			}
															#line 3071 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			rep.results.emplace_back(TenantAPI::clampRangeToTenant(r.range(), req.tenant, req.arena), ssis);
															#line 12725 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		}
		else
		{
															#line 3072 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (!req.reverse)
															#line 12731 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			{
															#line 3073 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				int count = 0;
															#line 3074 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				for(auto r = commitData->keyInfo.rangeContaining(req.begin);r != commitData->keyInfo.ranges().end() && count < req.limit && r.begin() < req.end.get();++r) {
															#line 3077 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					std::vector<StorageServerInterface> ssis;
															#line 3078 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					ssis.reserve(r.value().src_info.size());
															#line 3079 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					for( auto& it : r.value().src_info ) {
															#line 3080 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						ssis.push_back(it->interf);
															#line 3081 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						maybeAddTssMapping(rep, commitData, tssMappingsIncluded, it->interf.id());
															#line 12747 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
					}
															#line 3083 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					rep.results.emplace_back(TenantAPI::clampRangeToTenant(r.range(), req.tenant, req.arena), ssis);
															#line 3084 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					count++;
															#line 12753 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
				}
			}
			else
			{
															#line 3087 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				int count = 0;
															#line 3088 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				auto r = commitData->keyInfo.rangeContainingKeyBefore(req.end.get());
															#line 3089 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				for(;count < req.limit && req.begin < r.end();) {
															#line 3090 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					std::vector<StorageServerInterface> ssis;
															#line 3091 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					ssis.reserve(r.value().src_info.size());
															#line 3092 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					for( auto& it : r.value().src_info ) {
															#line 3093 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						ssis.push_back(it->interf);
															#line 3094 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						maybeAddTssMapping(rep, commitData, tssMappingsIncluded, it->interf.id());
															#line 12774 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
					}
															#line 3096 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					rep.results.emplace_back(TenantAPI::clampRangeToTenant(r.range(), req.tenant, req.arena), ssis);
															#line 3097 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					if (r == commitData->keyInfo.ranges().begin())
															#line 12780 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
					{
						break;
					}
															#line 3100 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					count++;
															#line 3101 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					--r;
															#line 12788 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
				}
			}
		}
															#line 3104 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		addTagMapping(rep, commitData);
															#line 3105 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		req.reply.send(rep);
															#line 3106 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		++commitData->stats.keyServerLocationOut;
															#line 3107 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!static_cast<DoKeyServerLocationRequestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DoKeyServerLocationRequestActorState(); static_cast<DoKeyServerLocationRequestActor*>(this)->destroy(); return 0; }
															#line 12800 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		new (&static_cast<DoKeyServerLocationRequestActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DoKeyServerLocationRequestActorState();
		static_cast<DoKeyServerLocationRequestActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(bool const& validTenant,int loopDepth) 
	{
		loopDepth = a_body1cont3(validTenant, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(bool && validTenant,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(validTenant), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<DoKeyServerLocationRequestActor*>(this)->actor_wait_state > 0) static_cast<DoKeyServerLocationRequestActor*>(this)->actor_wait_state = 0;
		static_cast<DoKeyServerLocationRequestActor*>(this)->ActorCallback< DoKeyServerLocationRequestActor, 2, bool >::remove();

	}
	void a_callback_fire(ActorCallback< DoKeyServerLocationRequestActor, 2, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("doKeyServerLocationRequest", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoKeyServerLocationRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doKeyServerLocationRequest", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< DoKeyServerLocationRequestActor, 2, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("doKeyServerLocationRequest", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoKeyServerLocationRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doKeyServerLocationRequest", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< DoKeyServerLocationRequestActor, 2, bool >*,Error err) 
	{
		fdb_probe_actor_enter("doKeyServerLocationRequest", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoKeyServerLocationRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doKeyServerLocationRequest", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 3028 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	GetKeyServerLocationsRequest req;
															#line 3028 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ProxyCommitData* commitData;
															#line 3038 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Version minVersion;
															#line 12889 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
};
// This generated class is to be used only via doKeyServerLocationRequest()
															#line 3028 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class DoKeyServerLocationRequestActor final : public Actor<Void>, public ActorCallback< DoKeyServerLocationRequestActor, 0, Void >, public ActorCallback< DoKeyServerLocationRequestActor, 1, Void >, public ActorCallback< DoKeyServerLocationRequestActor, 2, bool >, public FastAllocated<DoKeyServerLocationRequestActor>, public DoKeyServerLocationRequestActorState<DoKeyServerLocationRequestActor> {
															#line 12894 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
public:
	using FastAllocated<DoKeyServerLocationRequestActor>::operator new;
	using FastAllocated<DoKeyServerLocationRequestActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1037822576998846720UL, 3046940585941874176UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DoKeyServerLocationRequestActor, 0, Void >;
friend struct ActorCallback< DoKeyServerLocationRequestActor, 1, Void >;
friend struct ActorCallback< DoKeyServerLocationRequestActor, 2, bool >;
															#line 3028 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	DoKeyServerLocationRequestActor(GetKeyServerLocationsRequest const& req,ProxyCommitData* const& commitData) 
															#line 12913 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		 : Actor<Void>(),
		   DoKeyServerLocationRequestActorState<DoKeyServerLocationRequestActor>(req, commitData),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("doKeyServerLocationRequest", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4295041835434509824UL, 5382091244808472320UL);
		ActorExecutionContextHelper __helper(static_cast<DoKeyServerLocationRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("doKeyServerLocationRequest");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("doKeyServerLocationRequest", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DoKeyServerLocationRequestActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DoKeyServerLocationRequestActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< DoKeyServerLocationRequestActor, 2, bool >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 3028 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
[[nodiscard]] static Future<Void> doKeyServerLocationRequest( GetKeyServerLocationsRequest const& req, ProxyCommitData* const& commitData ) {
															#line 3028 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	return Future<Void>(new DoKeyServerLocationRequestActor(req, commitData));
															#line 12948 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
}

#line 3109 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"

															#line 12953 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
namespace {
// This generated class is to be used only via readRequestServer()
															#line 3110 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
template <class ReadRequestServerActor>
															#line 3110 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class ReadRequestServerActorState {
															#line 12960 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
public:
															#line 3110 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ReadRequestServerActorState(CommitProxyInterface const& proxy,PromiseStream<Future<Void>> const& addActor,ProxyCommitData* const& commitData) 
															#line 3110 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
															#line 3110 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		 : proxy(proxy),
															#line 3110 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   addActor(addActor),
															#line 3110 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   commitData(commitData)
															#line 12971 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
	{
		fdb_probe_actor_create("readRequestServer", reinterpret_cast<unsigned long>(this));

	}
	~ReadRequestServerActorState() 
	{
		fdb_probe_actor_destroy("readRequestServer", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 3113 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			;
															#line 12986 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ReadRequestServerActorState();
		static_cast<ReadRequestServerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 3114 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		auto __when_expr_0 = proxy.getKeyServersLocations.getFuture();
															#line 13016 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_0), FutureStream<GetKeyServerLocationsRequest>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<GetKeyServerLocationsRequest>>::value, "invalid type");
															#line 3114 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<ReadRequestServerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 13020 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
		static_cast<ReadRequestServerActor*>(this)->actor_wait_state = 1;
															#line 3114 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< ReadRequestServerActor, 0, GetKeyServerLocationsRequest >*>(static_cast<ReadRequestServerActor*>(this)));
															#line 13025 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(GetKeyServerLocationsRequest const& req,int loopDepth) 
	{
															#line 3116 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (req.limit != CLIENT_KNOBS->STORAGE_METRICS_SHARD_LIMIT && (commitData->stats.keyServerLocationIn.getValue() - commitData->stats.keyServerLocationOut.getValue() > SERVER_KNOBS->KEY_LOCATION_MAX_QUEUE_SIZE || (g_network->isSimulated() && BUGGIFY_WITH_PROB(0.001))))
															#line 13034 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 3120 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			++commitData->stats.keyServerLocationErrors;
															#line 3121 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			req.reply.sendError(commit_proxy_memory_limit_exceeded());
															#line 3122 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			TraceEvent(SevWarnAlways, "ProxyLocationRequestThresholdExceeded").suppressFor(60);
															#line 13042 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		}
		else
		{
															#line 3124 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			++commitData->stats.keyServerLocationIn;
															#line 3125 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			addActor.send(doKeyServerLocationRequest(req, commitData));
															#line 13050 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(GetKeyServerLocationsRequest && req,int loopDepth) 
	{
															#line 3116 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (req.limit != CLIENT_KNOBS->STORAGE_METRICS_SHARD_LIMIT && (commitData->stats.keyServerLocationIn.getValue() - commitData->stats.keyServerLocationOut.getValue() > SERVER_KNOBS->KEY_LOCATION_MAX_QUEUE_SIZE || (g_network->isSimulated() && BUGGIFY_WITH_PROB(0.001))))
															#line 13060 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 3120 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			++commitData->stats.keyServerLocationErrors;
															#line 3121 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			req.reply.sendError(commit_proxy_memory_limit_exceeded());
															#line 3122 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			TraceEvent(SevWarnAlways, "ProxyLocationRequestThresholdExceeded").suppressFor(60);
															#line 13068 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		}
		else
		{
															#line 3124 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			++commitData->stats.keyServerLocationIn;
															#line 3125 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			addActor.send(doKeyServerLocationRequest(req, commitData));
															#line 13076 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(GetKeyServerLocationsRequest const& req,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(req, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(GetKeyServerLocationsRequest && req,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(req), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ReadRequestServerActor*>(this)->actor_wait_state > 0) static_cast<ReadRequestServerActor*>(this)->actor_wait_state = 0;
		static_cast<ReadRequestServerActor*>(this)->ActorSingleCallback< ReadRequestServerActor, 0, GetKeyServerLocationsRequest >::remove();

	}
	void a_callback_fire(ActorSingleCallback< ReadRequestServerActor, 0, GetKeyServerLocationsRequest >*,GetKeyServerLocationsRequest const& value) 
	{
		fdb_probe_actor_enter("readRequestServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadRequestServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readRequestServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< ReadRequestServerActor, 0, GetKeyServerLocationsRequest >*,GetKeyServerLocationsRequest && value) 
	{
		fdb_probe_actor_enter("readRequestServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadRequestServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readRequestServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< ReadRequestServerActor, 0, GetKeyServerLocationsRequest >*,Error err) 
	{
		fdb_probe_actor_enter("readRequestServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadRequestServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readRequestServer", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 3110 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	CommitProxyInterface proxy;
															#line 3110 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	PromiseStream<Future<Void>> addActor;
															#line 3110 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ProxyCommitData* commitData;
															#line 13163 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
};
// This generated class is to be used only via readRequestServer()
															#line 3110 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class ReadRequestServerActor final : public Actor<Void>, public ActorSingleCallback< ReadRequestServerActor, 0, GetKeyServerLocationsRequest >, public FastAllocated<ReadRequestServerActor>, public ReadRequestServerActorState<ReadRequestServerActor> {
															#line 13168 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
public:
	using FastAllocated<ReadRequestServerActor>::operator new;
	using FastAllocated<ReadRequestServerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1916758369846668800UL, 9733367197498906624UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< ReadRequestServerActor, 0, GetKeyServerLocationsRequest >;
															#line 3110 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ReadRequestServerActor(CommitProxyInterface const& proxy,PromiseStream<Future<Void>> const& addActor,ProxyCommitData* const& commitData) 
															#line 13185 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		 : Actor<Void>(),
		   ReadRequestServerActorState<ReadRequestServerActor>(proxy, addActor, commitData),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("readRequestServer", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7015573509160306432UL, 3123064095005483520UL);
		ActorExecutionContextHelper __helper(static_cast<ReadRequestServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("readRequestServer");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("readRequestServer", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< ReadRequestServerActor, 0, GetKeyServerLocationsRequest >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 3110 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
[[nodiscard]] static Future<Void> readRequestServer( CommitProxyInterface const& proxy, PromiseStream<Future<Void>> const& addActor, ProxyCommitData* const& commitData ) {
															#line 3110 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	return Future<Void>(new ReadRequestServerActor(proxy, addActor, commitData));
															#line 13218 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
}

#line 3129 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"

// Right now this just proxies a call to read the system keyspace for tenant+authorization purposes, but this will
// eventually be extended to have this mapping in the transaction state store
															#line 13225 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
namespace {
// This generated class is to be used only via doBlobGranuleLocationRequest()
															#line 3132 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
template <class DoBlobGranuleLocationRequestActor>
															#line 3132 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class DoBlobGranuleLocationRequestActorState {
															#line 13232 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
public:
															#line 3132 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	DoBlobGranuleLocationRequestActorState(GetBlobGranuleLocationsRequest const& req,ProxyCommitData* const& commitData) 
															#line 3132 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
															#line 3132 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		 : req(req),
															#line 3132 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   commitData(commitData)
															#line 13241 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
	{
		fdb_probe_actor_create("doBlobGranuleLocationRequest", reinterpret_cast<unsigned long>(this));

	}
	~DoBlobGranuleLocationRequestActorState() 
	{
		fdb_probe_actor_destroy("doBlobGranuleLocationRequest", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 3134 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (req.reverse)
															#line 13256 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			{
															#line 3136 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				++commitData->stats.blobGranuleLocationOut;
															#line 3137 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				req.reply.sendError(unsupported_operation());
															#line 3138 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (!static_cast<DoBlobGranuleLocationRequestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DoBlobGranuleLocationRequestActorState(); static_cast<DoBlobGranuleLocationRequestActor*>(this)->destroy(); return 0; }
															#line 13264 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
				new (&static_cast<DoBlobGranuleLocationRequestActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~DoBlobGranuleLocationRequestActorState();
				static_cast<DoBlobGranuleLocationRequestActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 3140 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (req.end.present() && req.end.get() <= req.begin)
															#line 13272 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			{
															#line 3141 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				++commitData->stats.blobGranuleLocationOut;
															#line 3142 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				req.reply.sendError(unsupported_operation());
															#line 3143 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (!static_cast<DoBlobGranuleLocationRequestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DoBlobGranuleLocationRequestActorState(); static_cast<DoBlobGranuleLocationRequestActor*>(this)->destroy(); return 0; }
															#line 13280 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
				new (&static_cast<DoBlobGranuleLocationRequestActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~DoBlobGranuleLocationRequestActorState();
				static_cast<DoBlobGranuleLocationRequestActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 3146 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			StrictFuture<Void> __when_expr_0 = commitData->validState.getFuture();
															#line 3146 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (static_cast<DoBlobGranuleLocationRequestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13290 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DoBlobGranuleLocationRequestActor*>(this)->actor_wait_state = 1;
															#line 3146 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DoBlobGranuleLocationRequestActor, 0, Void >*>(static_cast<DoBlobGranuleLocationRequestActor*>(this)));
															#line 13295 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DoBlobGranuleLocationRequestActorState();
		static_cast<DoBlobGranuleLocationRequestActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 3147 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		i = 0;
															#line 3149 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		minVersion = req.minTenantVersion == latestVersion ? commitData->stats.lastCommitVersionAssigned + 1 : req.minTenantVersion;
															#line 3152 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(0, TaskPriority::DefaultEndpoint);
															#line 3152 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<DoBlobGranuleLocationRequestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13324 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<DoBlobGranuleLocationRequestActor*>(this)->actor_wait_state = 2;
															#line 3152 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DoBlobGranuleLocationRequestActor, 1, Void >*>(static_cast<DoBlobGranuleLocationRequestActor*>(this)));
															#line 13329 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 3147 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		i = 0;
															#line 3149 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		minVersion = req.minTenantVersion == latestVersion ? commitData->stats.lastCommitVersionAssigned + 1 : req.minTenantVersion;
															#line 3152 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(0, TaskPriority::DefaultEndpoint);
															#line 3152 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<DoBlobGranuleLocationRequestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13344 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<DoBlobGranuleLocationRequestActor*>(this)->actor_wait_state = 2;
															#line 3152 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DoBlobGranuleLocationRequestActor, 1, Void >*>(static_cast<DoBlobGranuleLocationRequestActor*>(this)));
															#line 13349 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DoBlobGranuleLocationRequestActor*>(this)->actor_wait_state > 0) static_cast<DoBlobGranuleLocationRequestActor*>(this)->actor_wait_state = 0;
		static_cast<DoBlobGranuleLocationRequestActor*>(this)->ActorCallback< DoBlobGranuleLocationRequestActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoBlobGranuleLocationRequestActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doBlobGranuleLocationRequest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBlobGranuleLocationRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBlobGranuleLocationRequest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DoBlobGranuleLocationRequestActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doBlobGranuleLocationRequest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBlobGranuleLocationRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBlobGranuleLocationRequest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DoBlobGranuleLocationRequestActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doBlobGranuleLocationRequest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoBlobGranuleLocationRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBlobGranuleLocationRequest", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 3154 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<bool> __when_expr_2 = checkTenant(commitData, req.tenant.tenantId, minVersion, "GetBlobGranuleLocation");
															#line 3154 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<DoBlobGranuleLocationRequestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13435 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont4when1(__when_expr_2.get(), loopDepth); };
		static_cast<DoBlobGranuleLocationRequestActor*>(this)->actor_wait_state = 3;
															#line 3154 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< DoBlobGranuleLocationRequestActor, 2, bool >*>(static_cast<DoBlobGranuleLocationRequestActor*>(this)));
															#line 13440 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 3154 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<bool> __when_expr_2 = checkTenant(commitData, req.tenant.tenantId, minVersion, "GetBlobGranuleLocation");
															#line 3154 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<DoBlobGranuleLocationRequestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13451 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont4when1(__when_expr_2.get(), loopDepth); };
		static_cast<DoBlobGranuleLocationRequestActor*>(this)->actor_wait_state = 3;
															#line 3154 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< DoBlobGranuleLocationRequestActor, 2, bool >*>(static_cast<DoBlobGranuleLocationRequestActor*>(this)));
															#line 13456 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DoBlobGranuleLocationRequestActor*>(this)->actor_wait_state > 0) static_cast<DoBlobGranuleLocationRequestActor*>(this)->actor_wait_state = 0;
		static_cast<DoBlobGranuleLocationRequestActor*>(this)->ActorCallback< DoBlobGranuleLocationRequestActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoBlobGranuleLocationRequestActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doBlobGranuleLocationRequest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBlobGranuleLocationRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBlobGranuleLocationRequest", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DoBlobGranuleLocationRequestActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doBlobGranuleLocationRequest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBlobGranuleLocationRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBlobGranuleLocationRequest", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DoBlobGranuleLocationRequestActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doBlobGranuleLocationRequest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoBlobGranuleLocationRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBlobGranuleLocationRequest", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(bool const& validTenant,int loopDepth) 
	{
															#line 3156 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!validTenant)
															#line 13540 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 3157 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			++commitData->stats.blobGranuleLocationOut;
															#line 3158 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			req.reply.sendError(tenant_not_found());
															#line 3159 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (!static_cast<DoBlobGranuleLocationRequestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DoBlobGranuleLocationRequestActorState(); static_cast<DoBlobGranuleLocationRequestActor*>(this)->destroy(); return 0; }
															#line 13548 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			new (&static_cast<DoBlobGranuleLocationRequestActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~DoBlobGranuleLocationRequestActorState();
			static_cast<DoBlobGranuleLocationRequestActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 3162 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		rep = GetBlobGranuleLocationsReply();
															#line 3163 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		keyRange = KeyRange();
															#line 3164 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (req.end.present())
															#line 13560 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 3165 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			keyRange = KeyRangeRef(req.begin, req.end.get());
															#line 13564 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		}
		else
		{
															#line 3167 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			keyRange = KeyRangeRef(req.begin, keyAfter(req.begin, req.arena));
															#line 13570 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		}
															#line 3169 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (req.tenant.hasTenant())
															#line 13574 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 3170 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			keyRange = keyRange.withPrefix(req.tenant.prefix.get(), req.arena);
															#line 13578 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		}
															#line 3173 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		req.limit = std::min(req.limit, CLIENT_KNOBS->BG_TOO_MANY_GRANULES);
															#line 3175 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		ASSERT(!keyRange.empty());
															#line 3177 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		tr = Transaction(commitData->cx);
															#line 13586 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		try {
															#line 3182 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			blobGranuleMapping = RangeResult();
															#line 3186 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			req.limit = std::max(3, req.limit + 1);
															#line 3187 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (req.justGranules)
															#line 13594 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			{
															#line 3189 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				StrictFuture<Void> __when_expr_3 = store( blobGranuleMapping, krmGetRangesUnaligned( &tr, blobGranuleMappingKeys.begin, keyRange, req.limit, GetRangeLimits::BYTE_LIMIT_UNLIMITED));
															#line 3189 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (static_cast<DoBlobGranuleLocationRequestActor*>(this)->actor_wait_state < 0) return a_body1cont5Catch1(actor_cancelled(), loopDepth);
															#line 13600 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
				if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont5Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont5when1(__when_expr_3.get(), loopDepth); };
				static_cast<DoBlobGranuleLocationRequestActor*>(this)->actor_wait_state = 4;
															#line 3189 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< DoBlobGranuleLocationRequestActor, 3, Void >*>(static_cast<DoBlobGranuleLocationRequestActor*>(this)));
															#line 13605 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 3195 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				StrictFuture<Void> __when_expr_4 = store( blobGranuleMapping, krmGetRanges( &tr, blobGranuleMappingKeys.begin, keyRange, req.limit, GetRangeLimits::BYTE_LIMIT_UNLIMITED));
															#line 3195 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (static_cast<DoBlobGranuleLocationRequestActor*>(this)->actor_wait_state < 0) return a_body1cont5Catch1(actor_cancelled(), loopDepth);
															#line 13614 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
				if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont5Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont5when2(__when_expr_4.get(), loopDepth); };
				static_cast<DoBlobGranuleLocationRequestActor*>(this)->actor_wait_state = 5;
															#line 3195 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< DoBlobGranuleLocationRequestActor, 4, Void >*>(static_cast<DoBlobGranuleLocationRequestActor*>(this)));
															#line 13619 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1cont5Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont5Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont5(bool && validTenant,int loopDepth) 
	{
															#line 3156 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!validTenant)
															#line 13635 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 3157 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			++commitData->stats.blobGranuleLocationOut;
															#line 3158 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			req.reply.sendError(tenant_not_found());
															#line 3159 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (!static_cast<DoBlobGranuleLocationRequestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DoBlobGranuleLocationRequestActorState(); static_cast<DoBlobGranuleLocationRequestActor*>(this)->destroy(); return 0; }
															#line 13643 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			new (&static_cast<DoBlobGranuleLocationRequestActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~DoBlobGranuleLocationRequestActorState();
			static_cast<DoBlobGranuleLocationRequestActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 3162 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		rep = GetBlobGranuleLocationsReply();
															#line 3163 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		keyRange = KeyRange();
															#line 3164 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (req.end.present())
															#line 13655 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 3165 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			keyRange = KeyRangeRef(req.begin, req.end.get());
															#line 13659 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		}
		else
		{
															#line 3167 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			keyRange = KeyRangeRef(req.begin, keyAfter(req.begin, req.arena));
															#line 13665 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		}
															#line 3169 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (req.tenant.hasTenant())
															#line 13669 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 3170 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			keyRange = keyRange.withPrefix(req.tenant.prefix.get(), req.arena);
															#line 13673 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		}
															#line 3173 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		req.limit = std::min(req.limit, CLIENT_KNOBS->BG_TOO_MANY_GRANULES);
															#line 3175 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		ASSERT(!keyRange.empty());
															#line 3177 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		tr = Transaction(commitData->cx);
															#line 13681 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		try {
															#line 3182 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			blobGranuleMapping = RangeResult();
															#line 3186 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			req.limit = std::max(3, req.limit + 1);
															#line 3187 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (req.justGranules)
															#line 13689 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			{
															#line 3189 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				StrictFuture<Void> __when_expr_3 = store( blobGranuleMapping, krmGetRangesUnaligned( &tr, blobGranuleMappingKeys.begin, keyRange, req.limit, GetRangeLimits::BYTE_LIMIT_UNLIMITED));
															#line 3189 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (static_cast<DoBlobGranuleLocationRequestActor*>(this)->actor_wait_state < 0) return a_body1cont5Catch1(actor_cancelled(), loopDepth);
															#line 13695 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
				if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont5Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont5when1(__when_expr_3.get(), loopDepth); };
				static_cast<DoBlobGranuleLocationRequestActor*>(this)->actor_wait_state = 4;
															#line 3189 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< DoBlobGranuleLocationRequestActor, 3, Void >*>(static_cast<DoBlobGranuleLocationRequestActor*>(this)));
															#line 13700 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 3195 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				StrictFuture<Void> __when_expr_4 = store( blobGranuleMapping, krmGetRanges( &tr, blobGranuleMappingKeys.begin, keyRange, req.limit, GetRangeLimits::BYTE_LIMIT_UNLIMITED));
															#line 3195 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (static_cast<DoBlobGranuleLocationRequestActor*>(this)->actor_wait_state < 0) return a_body1cont5Catch1(actor_cancelled(), loopDepth);
															#line 13709 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
				if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont5Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont5when2(__when_expr_4.get(), loopDepth); };
				static_cast<DoBlobGranuleLocationRequestActor*>(this)->actor_wait_state = 5;
															#line 3195 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< DoBlobGranuleLocationRequestActor, 4, Void >*>(static_cast<DoBlobGranuleLocationRequestActor*>(this)));
															#line 13714 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1cont5Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont5Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4when1(bool const& validTenant,int loopDepth) 
	{
		loopDepth = a_body1cont5(validTenant, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(bool && validTenant,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(validTenant), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<DoBlobGranuleLocationRequestActor*>(this)->actor_wait_state > 0) static_cast<DoBlobGranuleLocationRequestActor*>(this)->actor_wait_state = 0;
		static_cast<DoBlobGranuleLocationRequestActor*>(this)->ActorCallback< DoBlobGranuleLocationRequestActor, 2, bool >::remove();

	}
	void a_callback_fire(ActorCallback< DoBlobGranuleLocationRequestActor, 2, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("doBlobGranuleLocationRequest", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBlobGranuleLocationRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBlobGranuleLocationRequest", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< DoBlobGranuleLocationRequestActor, 2, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("doBlobGranuleLocationRequest", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBlobGranuleLocationRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBlobGranuleLocationRequest", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< DoBlobGranuleLocationRequestActor, 2, bool >*,Error err) 
	{
		fdb_probe_actor_enter("doBlobGranuleLocationRequest", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoBlobGranuleLocationRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBlobGranuleLocationRequest", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont6(int loopDepth) 
	{
															#line 3275 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		req.reply.send(rep);
															#line 3276 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		++commitData->stats.blobGranuleLocationOut;
															#line 3277 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!static_cast<DoBlobGranuleLocationRequestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DoBlobGranuleLocationRequestActorState(); static_cast<DoBlobGranuleLocationRequestActor*>(this)->destroy(); return 0; }
															#line 13809 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		new (&static_cast<DoBlobGranuleLocationRequestActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DoBlobGranuleLocationRequestActorState();
		static_cast<DoBlobGranuleLocationRequestActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 3266 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			++commitData->stats.blobGranuleLocationOut;
															#line 3267 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (e.code() == error_code_operation_cancelled)
															#line 13824 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			{
															#line 3268 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 13828 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			}
															#line 3271 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			req.reply.sendError(e);
															#line 3272 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (!static_cast<DoBlobGranuleLocationRequestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DoBlobGranuleLocationRequestActorState(); static_cast<DoBlobGranuleLocationRequestActor*>(this)->destroy(); return 0; }
															#line 13834 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			new (&static_cast<DoBlobGranuleLocationRequestActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~DoBlobGranuleLocationRequestActorState();
			static_cast<DoBlobGranuleLocationRequestActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11(int loopDepth) 
	{
															#line 3200 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		rep.arena.dependsOn(blobGranuleMapping.arena());
															#line 3201 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		ASSERT(blobGranuleMapping.empty() || blobGranuleMapping.size() >= 2);
															#line 3206 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		std::unordered_set<UID> bwiLookedUp;
															#line 3207 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		bwiLookupFutures = std::vector<Future<Optional<Value>>>();
															#line 3208 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		for(i = 0;i < blobGranuleMapping.size() - 1;i++) {
															#line 3209 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (!blobGranuleMapping[i].value.size())
															#line 13862 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			{
															#line 3210 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (req.justGranules)
															#line 13866 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
				{
					continue;
				}
															#line 3214 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				return a_body1cont5Catch1(blob_granule_transaction_too_old(), loopDepth);
															#line 13872 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			}
															#line 3217 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			UID workerId = decodeBlobGranuleMappingValue(blobGranuleMapping[i].value);
															#line 3218 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (workerId == UID() && !req.justGranules)
															#line 13878 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			{
															#line 3220 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				return a_body1cont5Catch1(blob_granule_transaction_too_old(), loopDepth);
															#line 13882 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			}
															#line 3223 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (!req.justGranules && !commitData->blobWorkerInterfCache.contains(workerId) && !bwiLookedUp.contains(workerId))
															#line 13886 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			{
															#line 3225 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				bwiLookedUp.insert(workerId);
															#line 3226 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				bwiLookupFutures.push_back(tr.get(blobWorkerListKeyFor(workerId)));
															#line 13892 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			}
		}
															#line 3230 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_5 = waitForAll(bwiLookupFutures);
															#line 3230 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<DoBlobGranuleLocationRequestActor*>(this)->actor_wait_state < 0) return a_body1cont5Catch1(actor_cancelled(), loopDepth);
															#line 13899 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont5Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont11when1(__when_expr_5.get(), loopDepth); };
		static_cast<DoBlobGranuleLocationRequestActor*>(this)->actor_wait_state = 6;
															#line 3230 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< DoBlobGranuleLocationRequestActor, 5, Void >*>(static_cast<DoBlobGranuleLocationRequestActor*>(this)));
															#line 13904 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1cont12(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<DoBlobGranuleLocationRequestActor*>(this)->actor_wait_state > 0) static_cast<DoBlobGranuleLocationRequestActor*>(this)->actor_wait_state = 0;
		static_cast<DoBlobGranuleLocationRequestActor*>(this)->ActorCallback< DoBlobGranuleLocationRequestActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoBlobGranuleLocationRequestActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doBlobGranuleLocationRequest", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBlobGranuleLocationRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont5Catch1(error, 0);
		} catch (...) {
			a_body1cont5Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBlobGranuleLocationRequest", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< DoBlobGranuleLocationRequestActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doBlobGranuleLocationRequest", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBlobGranuleLocationRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont5Catch1(error, 0);
		} catch (...) {
			a_body1cont5Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBlobGranuleLocationRequest", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< DoBlobGranuleLocationRequestActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doBlobGranuleLocationRequest", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoBlobGranuleLocationRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont5Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont5Catch1(error, 0);
		} catch (...) {
			a_body1cont5Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBlobGranuleLocationRequest", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont13(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1cont13(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1cont5when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont13(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont13(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<DoBlobGranuleLocationRequestActor*>(this)->actor_wait_state > 0) static_cast<DoBlobGranuleLocationRequestActor*>(this)->actor_wait_state = 0;
		static_cast<DoBlobGranuleLocationRequestActor*>(this)->ActorCallback< DoBlobGranuleLocationRequestActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoBlobGranuleLocationRequestActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doBlobGranuleLocationRequest", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBlobGranuleLocationRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont5when2(value, 0);
		}
		catch (Error& error) {
			a_body1cont5Catch1(error, 0);
		} catch (...) {
			a_body1cont5Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBlobGranuleLocationRequest", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< DoBlobGranuleLocationRequestActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doBlobGranuleLocationRequest", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBlobGranuleLocationRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont5when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont5Catch1(error, 0);
		} catch (...) {
			a_body1cont5Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBlobGranuleLocationRequest", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< DoBlobGranuleLocationRequestActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doBlobGranuleLocationRequest", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoBlobGranuleLocationRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont5Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont5Catch1(error, 0);
		} catch (...) {
			a_body1cont5Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBlobGranuleLocationRequest", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont11cont1(Void const& _,int loopDepth) 
	{
															#line 3232 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		for( auto& f : bwiLookupFutures ) {
															#line 3233 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			Optional<Value> workerInterface = f.get();
															#line 3237 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (!workerInterface.present())
															#line 14091 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			{
															#line 3238 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				return a_body1cont5Catch1(blob_granule_request_failed(), loopDepth);
															#line 14095 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			}
															#line 3241 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			BlobWorkerInterface bwInterf = decodeBlobWorkerListValue(workerInterface.get());
															#line 3242 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			commitData->blobWorkerInterfCache[bwInterf.id()] = bwInterf;
															#line 14101 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		}
															#line 3246 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		std::unordered_set<UID> interfsIncluded;
															#line 3247 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		for(i = 0;i < blobGranuleMapping.size() - 1;i++) {
															#line 3248 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			KeyRangeRef granule(blobGranuleMapping[i].key, blobGranuleMapping[i + 1].key);
															#line 3249 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (req.justGranules)
															#line 14111 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			{
															#line 3250 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (!blobGranuleMapping[i].value.size())
															#line 14115 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
				{
					continue;
				}
															#line 3253 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				rep.results.push_back({ granule, UID() });
															#line 14121 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			}
			else
			{
															#line 3256 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				UID workerId = decodeBlobGranuleMappingValue(blobGranuleMapping[i].value);
															#line 3257 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				rep.results.push_back({ granule, workerId });
															#line 3258 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (interfsIncluded.insert(workerId).second)
															#line 14131 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
				{
															#line 3259 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					rep.bwInterfs.push_back(commitData->blobWorkerInterfCache[workerId]);
															#line 14135 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
				}
			}
		}
															#line 3264 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		rep.more = blobGranuleMapping.more;
															#line 14141 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		loopDepth = a_body1cont11cont15(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont1(Void && _,int loopDepth) 
	{
															#line 3232 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		for( auto& f : bwiLookupFutures ) {
															#line 3233 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			Optional<Value> workerInterface = f.get();
															#line 3237 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (!workerInterface.present())
															#line 14154 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			{
															#line 3238 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				return a_body1cont5Catch1(blob_granule_request_failed(), loopDepth);
															#line 14158 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			}
															#line 3241 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			BlobWorkerInterface bwInterf = decodeBlobWorkerListValue(workerInterface.get());
															#line 3242 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			commitData->blobWorkerInterfCache[bwInterf.id()] = bwInterf;
															#line 14164 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		}
															#line 3246 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		std::unordered_set<UID> interfsIncluded;
															#line 3247 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		for(i = 0;i < blobGranuleMapping.size() - 1;i++) {
															#line 3248 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			KeyRangeRef granule(blobGranuleMapping[i].key, blobGranuleMapping[i + 1].key);
															#line 3249 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (req.justGranules)
															#line 14174 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			{
															#line 3250 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (!blobGranuleMapping[i].value.size())
															#line 14178 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
				{
					continue;
				}
															#line 3253 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				rep.results.push_back({ granule, UID() });
															#line 14184 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			}
			else
			{
															#line 3256 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				UID workerId = decodeBlobGranuleMappingValue(blobGranuleMapping[i].value);
															#line 3257 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				rep.results.push_back({ granule, workerId });
															#line 3258 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (interfsIncluded.insert(workerId).second)
															#line 14194 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
				{
															#line 3259 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					rep.bwInterfs.push_back(commitData->blobWorkerInterfCache[workerId]);
															#line 14198 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
				}
			}
		}
															#line 3264 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		rep.more = blobGranuleMapping.more;
															#line 14204 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		loopDepth = a_body1cont11cont15(loopDepth);

		return loopDepth;
	}
	int a_body1cont11when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<DoBlobGranuleLocationRequestActor*>(this)->actor_wait_state > 0) static_cast<DoBlobGranuleLocationRequestActor*>(this)->actor_wait_state = 0;
		static_cast<DoBlobGranuleLocationRequestActor*>(this)->ActorCallback< DoBlobGranuleLocationRequestActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoBlobGranuleLocationRequestActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doBlobGranuleLocationRequest", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBlobGranuleLocationRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont11when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont5Catch1(error, 0);
		} catch (...) {
			a_body1cont5Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBlobGranuleLocationRequest", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< DoBlobGranuleLocationRequestActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doBlobGranuleLocationRequest", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBlobGranuleLocationRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont11when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont5Catch1(error, 0);
		} catch (...) {
			a_body1cont5Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBlobGranuleLocationRequest", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< DoBlobGranuleLocationRequestActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doBlobGranuleLocationRequest", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoBlobGranuleLocationRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont5Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont5Catch1(error, 0);
		} catch (...) {
			a_body1cont5Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBlobGranuleLocationRequest", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont11cont15(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont6(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 3132 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	GetBlobGranuleLocationsRequest req;
															#line 3132 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ProxyCommitData* commitData;
															#line 3147 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	int i;
															#line 3149 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Version minVersion;
															#line 3162 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	GetBlobGranuleLocationsReply rep;
															#line 3163 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	KeyRange keyRange;
															#line 3177 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Transaction tr;
															#line 3182 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	RangeResult blobGranuleMapping;
															#line 3207 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	std::vector<Future<Optional<Value>>> bwiLookupFutures;
															#line 14315 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
};
// This generated class is to be used only via doBlobGranuleLocationRequest()
															#line 3132 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class DoBlobGranuleLocationRequestActor final : public Actor<Void>, public ActorCallback< DoBlobGranuleLocationRequestActor, 0, Void >, public ActorCallback< DoBlobGranuleLocationRequestActor, 1, Void >, public ActorCallback< DoBlobGranuleLocationRequestActor, 2, bool >, public ActorCallback< DoBlobGranuleLocationRequestActor, 3, Void >, public ActorCallback< DoBlobGranuleLocationRequestActor, 4, Void >, public ActorCallback< DoBlobGranuleLocationRequestActor, 5, Void >, public FastAllocated<DoBlobGranuleLocationRequestActor>, public DoBlobGranuleLocationRequestActorState<DoBlobGranuleLocationRequestActor> {
															#line 14320 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
public:
	using FastAllocated<DoBlobGranuleLocationRequestActor>::operator new;
	using FastAllocated<DoBlobGranuleLocationRequestActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2752018484699160320UL, 6426317628441034240UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DoBlobGranuleLocationRequestActor, 0, Void >;
friend struct ActorCallback< DoBlobGranuleLocationRequestActor, 1, Void >;
friend struct ActorCallback< DoBlobGranuleLocationRequestActor, 2, bool >;
friend struct ActorCallback< DoBlobGranuleLocationRequestActor, 3, Void >;
friend struct ActorCallback< DoBlobGranuleLocationRequestActor, 4, Void >;
friend struct ActorCallback< DoBlobGranuleLocationRequestActor, 5, Void >;
															#line 3132 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	DoBlobGranuleLocationRequestActor(GetBlobGranuleLocationsRequest const& req,ProxyCommitData* const& commitData) 
															#line 14342 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		 : Actor<Void>(),
		   DoBlobGranuleLocationRequestActorState<DoBlobGranuleLocationRequestActor>(req, commitData),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("doBlobGranuleLocationRequest", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17820623407375859456UL, 9784597645843978240UL);
		ActorExecutionContextHelper __helper(static_cast<DoBlobGranuleLocationRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("doBlobGranuleLocationRequest");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("doBlobGranuleLocationRequest", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DoBlobGranuleLocationRequestActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DoBlobGranuleLocationRequestActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< DoBlobGranuleLocationRequestActor, 2, bool >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< DoBlobGranuleLocationRequestActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< DoBlobGranuleLocationRequestActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< DoBlobGranuleLocationRequestActor, 5, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 3132 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
[[nodiscard]] static Future<Void> doBlobGranuleLocationRequest( GetBlobGranuleLocationsRequest const& req, ProxyCommitData* const& commitData ) {
															#line 3132 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	return Future<Void>(new DoBlobGranuleLocationRequestActor(req, commitData));
															#line 14380 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
}

#line 3279 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"

															#line 14385 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
namespace {
// This generated class is to be used only via bgReadRequestServer()
															#line 3280 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
template <class BgReadRequestServerActor>
															#line 3280 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class BgReadRequestServerActorState {
															#line 14392 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
public:
															#line 3280 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	BgReadRequestServerActorState(CommitProxyInterface const& proxy,PromiseStream<Future<Void>> const& addActor,ProxyCommitData* const& commitData) 
															#line 3280 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
															#line 3280 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		 : proxy(proxy),
															#line 3280 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   addActor(addActor),
															#line 3280 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   commitData(commitData)
															#line 14403 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
	{
		fdb_probe_actor_create("bgReadRequestServer", reinterpret_cast<unsigned long>(this));

	}
	~BgReadRequestServerActorState() 
	{
		fdb_probe_actor_destroy("bgReadRequestServer", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 3283 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			;
															#line 14418 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~BgReadRequestServerActorState();
		static_cast<BgReadRequestServerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 3284 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		auto __when_expr_0 = proxy.getBlobGranuleLocations.getFuture();
															#line 14448 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_0), FutureStream<GetBlobGranuleLocationsRequest>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<GetBlobGranuleLocationsRequest>>::value, "invalid type");
															#line 3284 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<BgReadRequestServerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 14452 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
		static_cast<BgReadRequestServerActor*>(this)->actor_wait_state = 1;
															#line 3284 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< BgReadRequestServerActor, 0, GetBlobGranuleLocationsRequest >*>(static_cast<BgReadRequestServerActor*>(this)));
															#line 14457 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(GetBlobGranuleLocationsRequest const& req,int loopDepth) 
	{
															#line 3286 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if ((commitData->stats.blobGranuleLocationIn.getValue() - commitData->stats.blobGranuleLocationOut.getValue() > SERVER_KNOBS->BLOB_GRANULE_LOCATION_MAX_QUEUE_SIZE) || (g_network->isSimulated() && !g_simulator->speedUpSimulation && BUGGIFY_WITH_PROB(0.0001)))
															#line 14466 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 3289 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			++commitData->stats.blobGranuleLocationErrors;
															#line 3290 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			req.reply.sendError(commit_proxy_memory_limit_exceeded());
															#line 3291 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			TraceEvent(SevWarnAlways, "ProxyBGLocationRequestThresholdExceeded", commitData->dbgid).suppressFor(60);
															#line 14474 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		}
		else
		{
															#line 3293 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			++commitData->stats.blobGranuleLocationIn;
															#line 3294 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			addActor.send(doBlobGranuleLocationRequest(req, commitData));
															#line 14482 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(GetBlobGranuleLocationsRequest && req,int loopDepth) 
	{
															#line 3286 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if ((commitData->stats.blobGranuleLocationIn.getValue() - commitData->stats.blobGranuleLocationOut.getValue() > SERVER_KNOBS->BLOB_GRANULE_LOCATION_MAX_QUEUE_SIZE) || (g_network->isSimulated() && !g_simulator->speedUpSimulation && BUGGIFY_WITH_PROB(0.0001)))
															#line 14492 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 3289 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			++commitData->stats.blobGranuleLocationErrors;
															#line 3290 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			req.reply.sendError(commit_proxy_memory_limit_exceeded());
															#line 3291 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			TraceEvent(SevWarnAlways, "ProxyBGLocationRequestThresholdExceeded", commitData->dbgid).suppressFor(60);
															#line 14500 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		}
		else
		{
															#line 3293 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			++commitData->stats.blobGranuleLocationIn;
															#line 3294 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			addActor.send(doBlobGranuleLocationRequest(req, commitData));
															#line 14508 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(GetBlobGranuleLocationsRequest const& req,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(req, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(GetBlobGranuleLocationsRequest && req,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(req), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<BgReadRequestServerActor*>(this)->actor_wait_state > 0) static_cast<BgReadRequestServerActor*>(this)->actor_wait_state = 0;
		static_cast<BgReadRequestServerActor*>(this)->ActorSingleCallback< BgReadRequestServerActor, 0, GetBlobGranuleLocationsRequest >::remove();

	}
	void a_callback_fire(ActorSingleCallback< BgReadRequestServerActor, 0, GetBlobGranuleLocationsRequest >*,GetBlobGranuleLocationsRequest const& value) 
	{
		fdb_probe_actor_enter("bgReadRequestServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BgReadRequestServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bgReadRequestServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< BgReadRequestServerActor, 0, GetBlobGranuleLocationsRequest >*,GetBlobGranuleLocationsRequest && value) 
	{
		fdb_probe_actor_enter("bgReadRequestServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BgReadRequestServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bgReadRequestServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< BgReadRequestServerActor, 0, GetBlobGranuleLocationsRequest >*,Error err) 
	{
		fdb_probe_actor_enter("bgReadRequestServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BgReadRequestServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bgReadRequestServer", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 3280 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	CommitProxyInterface proxy;
															#line 3280 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	PromiseStream<Future<Void>> addActor;
															#line 3280 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ProxyCommitData* commitData;
															#line 14595 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
};
// This generated class is to be used only via bgReadRequestServer()
															#line 3280 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class BgReadRequestServerActor final : public Actor<Void>, public ActorSingleCallback< BgReadRequestServerActor, 0, GetBlobGranuleLocationsRequest >, public FastAllocated<BgReadRequestServerActor>, public BgReadRequestServerActorState<BgReadRequestServerActor> {
															#line 14600 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
public:
	using FastAllocated<BgReadRequestServerActor>::operator new;
	using FastAllocated<BgReadRequestServerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2293560762590614016UL, 17250747420198034688UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< BgReadRequestServerActor, 0, GetBlobGranuleLocationsRequest >;
															#line 3280 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	BgReadRequestServerActor(CommitProxyInterface const& proxy,PromiseStream<Future<Void>> const& addActor,ProxyCommitData* const& commitData) 
															#line 14617 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		 : Actor<Void>(),
		   BgReadRequestServerActorState<BgReadRequestServerActor>(proxy, addActor, commitData),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("bgReadRequestServer", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1091783368840102144UL, 800811687254458624UL);
		ActorExecutionContextHelper __helper(static_cast<BgReadRequestServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("bgReadRequestServer");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("bgReadRequestServer", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< BgReadRequestServerActor, 0, GetBlobGranuleLocationsRequest >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 3280 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
[[nodiscard]] static Future<Void> bgReadRequestServer( CommitProxyInterface const& proxy, PromiseStream<Future<Void>> const& addActor, ProxyCommitData* const& commitData ) {
															#line 3280 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	return Future<Void>(new BgReadRequestServerActor(proxy, addActor, commitData));
															#line 14650 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
}

#line 3298 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"

															#line 14655 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
namespace {
// This generated class is to be used only via rejoinServer()
															#line 3299 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
template <class RejoinServerActor>
															#line 3299 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class RejoinServerActorState {
															#line 14662 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
public:
															#line 3299 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	RejoinServerActorState(CommitProxyInterface const& proxy,ProxyCommitData* const& commitData) 
															#line 3299 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
															#line 3299 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		 : proxy(proxy),
															#line 3299 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   commitData(commitData)
															#line 14671 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
	{
		fdb_probe_actor_create("rejoinServer", reinterpret_cast<unsigned long>(this));

	}
	~RejoinServerActorState() 
	{
		fdb_probe_actor_destroy("rejoinServer", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 3301 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			StrictFuture<Void> __when_expr_0 = commitData->validState.getFuture();
															#line 3301 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (static_cast<RejoinServerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14688 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RejoinServerActor*>(this)->actor_wait_state = 1;
															#line 3301 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RejoinServerActor, 0, Void >*>(static_cast<RejoinServerActor*>(this)));
															#line 14693 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RejoinServerActorState();
		static_cast<RejoinServerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 3303 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		TraceEvent("ProxyReadyForReads", proxy.id()).log();
															#line 3305 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		;
															#line 14718 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 3303 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		TraceEvent("ProxyReadyForReads", proxy.id()).log();
															#line 3305 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		;
															#line 14729 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RejoinServerActor*>(this)->actor_wait_state > 0) static_cast<RejoinServerActor*>(this)->actor_wait_state = 0;
		static_cast<RejoinServerActor*>(this)->ActorCallback< RejoinServerActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RejoinServerActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("rejoinServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RejoinServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rejoinServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RejoinServerActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("rejoinServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RejoinServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rejoinServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RejoinServerActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("rejoinServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RejoinServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rejoinServer", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 3306 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		auto __when_expr_1 = proxy.getStorageServerRejoinInfo.getFuture();
															#line 14820 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_1), FutureStream<GetStorageServerRejoinInfoRequest>>::value || std::is_same<decltype(__when_expr_1), ThreadFutureStream<GetStorageServerRejoinInfoRequest>>::value, "invalid type");
															#line 3306 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<RejoinServerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 14824 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.pop(), loopDepth); };
		static_cast<RejoinServerActor*>(this)->actor_wait_state = 2;
															#line 3306 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorSingleCallback< RejoinServerActor, 1, GetStorageServerRejoinInfoRequest >*>(static_cast<RejoinServerActor*>(this)));
															#line 14829 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(GetStorageServerRejoinInfoRequest const& req,int loopDepth) 
	{
															#line 3307 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (commitData->txnStateStore->readValue(serverListKeyFor(req.id)).get().present())
															#line 14838 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 3308 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			GetStorageServerRejoinInfoReply rep;
															#line 3309 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			rep.version = commitData->version.get();
															#line 3310 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			rep.tag = decodeServerTagValue(commitData->txnStateStore->readValue(serverTagKeyFor(req.id)).get().get());
															#line 3311 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			RangeResult history = commitData->txnStateStore->readRange(serverTagHistoryRangeFor(req.id)).get();
															#line 3312 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			for(int i = history.size() - 1;i >= 0;i--) {
															#line 3313 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				rep.history.push_back( std::make_pair(decodeServerTagHistoryKey(history[i].key), decodeServerTagValue(history[i].value)));
															#line 14852 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			}
															#line 3316 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			auto localityKey = commitData->txnStateStore->readValue(tagLocalityListKeyFor(req.dcId)).get();
															#line 3317 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			rep.newLocality = false;
															#line 3318 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (localityKey.present())
															#line 14860 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			{
															#line 3319 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				int8_t locality = decodeTagLocalityListValue(localityKey.get());
															#line 3320 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (locality != rep.tag.locality)
															#line 14866 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
				{
															#line 3321 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					TraceEvent(SevWarnAlways, "SSRejoinedWithChangedLocality") .detail("Tag", rep.tag.toString()) .detail("DcId", req.dcId) .detail("NewLocality", locality);
															#line 14870 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
				}
				else
				{
															#line 3325 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					if (locality != rep.tag.locality)
															#line 14876 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
					{
															#line 3326 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						uint16_t tagId = 0;
															#line 3327 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						std::vector<uint16_t> usedTags;
															#line 3328 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						auto tagKeys = commitData->txnStateStore->readRange(serverTagKeys).get();
															#line 3329 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						for( auto& kv : tagKeys ) {
															#line 3330 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
							Tag t = decodeServerTagValue(kv.value);
															#line 3331 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
							if (t.locality == locality)
															#line 14890 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
							{
															#line 3332 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
								usedTags.push_back(t.id);
															#line 14894 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
							}
						}
															#line 3335 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						auto historyKeys = commitData->txnStateStore->readRange(serverTagHistoryKeys).get();
															#line 3336 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						for( auto& kv : historyKeys ) {
															#line 3337 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
							Tag t = decodeServerTagValue(kv.value);
															#line 3338 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
							if (t.locality == locality)
															#line 14905 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
							{
															#line 3339 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
								usedTags.push_back(t.id);
															#line 14909 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
							}
						}
															#line 3342 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						std::sort(usedTags.begin(), usedTags.end());
															#line 3344 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						int usedIdx = 0;
															#line 3345 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						for(;usedTags.size() > 0 && tagId <= usedTags.end()[-1];tagId++) {
															#line 3346 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
							if (tagId < usedTags[usedIdx])
															#line 14920 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
							{
								break;
							}
							else
							{
															#line 3349 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
								usedIdx++;
															#line 14928 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
							}
						}
															#line 3352 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						rep.newTag = Tag(locality, tagId);
															#line 14933 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
					}
				}
			}
			else
			{
															#line 3355 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				ASSERT_WE_THINK(rep.tag.locality != tagLocalityUpgraded);
															#line 3356 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				TraceEvent(SevWarnAlways, "SSRejoinedWithUnknownLocality") .detail("Tag", rep.tag.toString()) .detail("DcId", req.dcId);
															#line 14943 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			}
															#line 3360 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			rep.encryptMode = commitData->encryptMode;
															#line 3361 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			req.reply.send(rep);
															#line 14949 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		}
		else
		{
															#line 3363 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			req.reply.sendError(worker_removed());
															#line 14955 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		}
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(GetStorageServerRejoinInfoRequest && req,int loopDepth) 
	{
															#line 3307 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (commitData->txnStateStore->readValue(serverListKeyFor(req.id)).get().present())
															#line 14965 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 3308 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			GetStorageServerRejoinInfoReply rep;
															#line 3309 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			rep.version = commitData->version.get();
															#line 3310 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			rep.tag = decodeServerTagValue(commitData->txnStateStore->readValue(serverTagKeyFor(req.id)).get().get());
															#line 3311 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			RangeResult history = commitData->txnStateStore->readRange(serverTagHistoryRangeFor(req.id)).get();
															#line 3312 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			for(int i = history.size() - 1;i >= 0;i--) {
															#line 3313 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				rep.history.push_back( std::make_pair(decodeServerTagHistoryKey(history[i].key), decodeServerTagValue(history[i].value)));
															#line 14979 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			}
															#line 3316 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			auto localityKey = commitData->txnStateStore->readValue(tagLocalityListKeyFor(req.dcId)).get();
															#line 3317 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			rep.newLocality = false;
															#line 3318 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (localityKey.present())
															#line 14987 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			{
															#line 3319 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				int8_t locality = decodeTagLocalityListValue(localityKey.get());
															#line 3320 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (locality != rep.tag.locality)
															#line 14993 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
				{
															#line 3321 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					TraceEvent(SevWarnAlways, "SSRejoinedWithChangedLocality") .detail("Tag", rep.tag.toString()) .detail("DcId", req.dcId) .detail("NewLocality", locality);
															#line 14997 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
				}
				else
				{
															#line 3325 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					if (locality != rep.tag.locality)
															#line 15003 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
					{
															#line 3326 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						uint16_t tagId = 0;
															#line 3327 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						std::vector<uint16_t> usedTags;
															#line 3328 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						auto tagKeys = commitData->txnStateStore->readRange(serverTagKeys).get();
															#line 3329 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						for( auto& kv : tagKeys ) {
															#line 3330 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
							Tag t = decodeServerTagValue(kv.value);
															#line 3331 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
							if (t.locality == locality)
															#line 15017 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
							{
															#line 3332 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
								usedTags.push_back(t.id);
															#line 15021 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
							}
						}
															#line 3335 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						auto historyKeys = commitData->txnStateStore->readRange(serverTagHistoryKeys).get();
															#line 3336 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						for( auto& kv : historyKeys ) {
															#line 3337 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
							Tag t = decodeServerTagValue(kv.value);
															#line 3338 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
							if (t.locality == locality)
															#line 15032 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
							{
															#line 3339 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
								usedTags.push_back(t.id);
															#line 15036 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
							}
						}
															#line 3342 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						std::sort(usedTags.begin(), usedTags.end());
															#line 3344 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						int usedIdx = 0;
															#line 3345 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						for(;usedTags.size() > 0 && tagId <= usedTags.end()[-1];tagId++) {
															#line 3346 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
							if (tagId < usedTags[usedIdx])
															#line 15047 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
							{
								break;
							}
							else
							{
															#line 3349 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
								usedIdx++;
															#line 15055 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
							}
						}
															#line 3352 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						rep.newTag = Tag(locality, tagId);
															#line 15060 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
					}
				}
			}
			else
			{
															#line 3355 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				ASSERT_WE_THINK(rep.tag.locality != tagLocalityUpgraded);
															#line 3356 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				TraceEvent(SevWarnAlways, "SSRejoinedWithUnknownLocality") .detail("Tag", rep.tag.toString()) .detail("DcId", req.dcId);
															#line 15070 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			}
															#line 3360 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			rep.encryptMode = commitData->encryptMode;
															#line 3361 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			req.reply.send(rep);
															#line 15076 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		}
		else
		{
															#line 3363 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			req.reply.sendError(worker_removed());
															#line 15082 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		}
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(GetStorageServerRejoinInfoRequest const& req,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(req, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(GetStorageServerRejoinInfoRequest && req,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(std::move(req), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RejoinServerActor*>(this)->actor_wait_state > 0) static_cast<RejoinServerActor*>(this)->actor_wait_state = 0;
		static_cast<RejoinServerActor*>(this)->ActorSingleCallback< RejoinServerActor, 1, GetStorageServerRejoinInfoRequest >::remove();

	}
	void a_callback_fire(ActorSingleCallback< RejoinServerActor, 1, GetStorageServerRejoinInfoRequest >*,GetStorageServerRejoinInfoRequest const& value) 
	{
		fdb_probe_actor_enter("rejoinServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RejoinServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rejoinServer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorSingleCallback< RejoinServerActor, 1, GetStorageServerRejoinInfoRequest >*,GetStorageServerRejoinInfoRequest && value) 
	{
		fdb_probe_actor_enter("rejoinServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RejoinServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rejoinServer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorSingleCallback< RejoinServerActor, 1, GetStorageServerRejoinInfoRequest >*,Error err) 
	{
		fdb_probe_actor_enter("rejoinServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RejoinServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rejoinServer", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 3299 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	CommitProxyInterface proxy;
															#line 3299 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ProxyCommitData* commitData;
															#line 15167 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
};
// This generated class is to be used only via rejoinServer()
															#line 3299 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class RejoinServerActor final : public Actor<Void>, public ActorCallback< RejoinServerActor, 0, Void >, public ActorSingleCallback< RejoinServerActor, 1, GetStorageServerRejoinInfoRequest >, public FastAllocated<RejoinServerActor>, public RejoinServerActorState<RejoinServerActor> {
															#line 15172 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
public:
	using FastAllocated<RejoinServerActor>::operator new;
	using FastAllocated<RejoinServerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3916526946420194304UL, 8983055452261622528UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RejoinServerActor, 0, Void >;
friend struct ActorSingleCallback< RejoinServerActor, 1, GetStorageServerRejoinInfoRequest >;
															#line 3299 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	RejoinServerActor(CommitProxyInterface const& proxy,ProxyCommitData* const& commitData) 
															#line 15190 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		 : Actor<Void>(),
		   RejoinServerActorState<RejoinServerActor>(proxy, commitData),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("rejoinServer", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6499651042657228288UL, 13021739501090474752UL);
		ActorExecutionContextHelper __helper(static_cast<RejoinServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("rejoinServer");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("rejoinServer", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RejoinServerActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorSingleCallback< RejoinServerActor, 1, GetStorageServerRejoinInfoRequest >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 3299 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
[[nodiscard]] static Future<Void> rejoinServer( CommitProxyInterface const& proxy, ProxyCommitData* const& commitData ) {
															#line 3299 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	return Future<Void>(new RejoinServerActor(proxy, commitData));
															#line 15224 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
}

#line 3367 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"

															#line 15229 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
namespace {
// This generated class is to be used only via ddMetricsRequestServer()
															#line 3368 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
template <class DdMetricsRequestServerActor>
															#line 3368 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class DdMetricsRequestServerActorState {
															#line 15236 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
public:
															#line 3368 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	DdMetricsRequestServerActorState(CommitProxyInterface const& proxy,Reference<AsyncVar<ServerDBInfo> const> const& db) 
															#line 3368 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
															#line 3368 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		 : proxy(proxy),
															#line 3368 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   db(db)
															#line 15245 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
	{
		fdb_probe_actor_create("ddMetricsRequestServer", reinterpret_cast<unsigned long>(this));

	}
	~DdMetricsRequestServerActorState() 
	{
		fdb_probe_actor_destroy("ddMetricsRequestServer", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 3369 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			;
															#line 15260 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DdMetricsRequestServerActorState();
		static_cast<DdMetricsRequestServerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 3371 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		auto __when_expr_0 = proxy.getDDMetrics.getFuture();
															#line 15290 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_0), FutureStream<GetDDMetricsRequest>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<GetDDMetricsRequest>>::value, "invalid type");
															#line 3370 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<DdMetricsRequestServerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 15294 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
		static_cast<DdMetricsRequestServerActor*>(this)->actor_wait_state = 1;
															#line 3371 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< DdMetricsRequestServerActor, 0, GetDDMetricsRequest >*>(static_cast<DdMetricsRequestServerActor*>(this)));
															#line 15299 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(GetDDMetricsRequest const& __req,int loopDepth) 
	{
															#line 3371 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		req = __req;
															#line 3372 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!db->get().distributor.present())
															#line 15316 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 3373 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			req.reply.sendError(dd_not_found());
															#line 15320 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			return a_body1loopHead1(loopDepth); // continue
		}
															#line 3376 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<ErrorOr<GetDataDistributorMetricsReply>> __when_expr_1 = errorOr(db->get().distributor.get().dataDistributorMetrics.getReply( GetDataDistributorMetricsRequest(req.keys, req.shardLimit)));
															#line 3376 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<DdMetricsRequestServerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 15327 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1when1(__when_expr_1.get(), loopDepth); };
		static_cast<DdMetricsRequestServerActor*>(this)->actor_wait_state = 2;
															#line 3376 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DdMetricsRequestServerActor, 1, ErrorOr<GetDataDistributorMetricsReply> >*>(static_cast<DdMetricsRequestServerActor*>(this)));
															#line 15332 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(GetDDMetricsRequest && __req,int loopDepth) 
	{
		req = std::move(__req);
															#line 3372 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!db->get().distributor.present())
															#line 15342 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 3373 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			req.reply.sendError(dd_not_found());
															#line 15346 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			return a_body1loopHead1(loopDepth); // continue
		}
															#line 3376 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<ErrorOr<GetDataDistributorMetricsReply>> __when_expr_1 = errorOr(db->get().distributor.get().dataDistributorMetrics.getReply( GetDataDistributorMetricsRequest(req.keys, req.shardLimit)));
															#line 3376 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<DdMetricsRequestServerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 15353 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1when1(__when_expr_1.get(), loopDepth); };
		static_cast<DdMetricsRequestServerActor*>(this)->actor_wait_state = 2;
															#line 3376 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DdMetricsRequestServerActor, 1, ErrorOr<GetDataDistributorMetricsReply> >*>(static_cast<DdMetricsRequestServerActor*>(this)));
															#line 15358 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DdMetricsRequestServerActor*>(this)->actor_wait_state > 0) static_cast<DdMetricsRequestServerActor*>(this)->actor_wait_state = 0;
		static_cast<DdMetricsRequestServerActor*>(this)->ActorSingleCallback< DdMetricsRequestServerActor, 0, GetDDMetricsRequest >::remove();

	}
	int a_body1loopBody1when1cont1(ErrorOr<GetDataDistributorMetricsReply> const& reply,int loopDepth) 
	{
															#line 3379 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (reply.isError())
															#line 15373 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 3380 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			req.reply.sendError(reply.getError());
															#line 15377 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		}
		else
		{
															#line 3382 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			GetDDMetricsReply newReply;
															#line 3383 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			newReply.storageMetricsList = reply.get().storageMetricsList;
															#line 3384 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			req.reply.send(newReply);
															#line 15387 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1cont1(ErrorOr<GetDataDistributorMetricsReply> && reply,int loopDepth) 
	{
															#line 3379 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (reply.isError())
															#line 15397 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 3380 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			req.reply.sendError(reply.getError());
															#line 15401 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		}
		else
		{
															#line 3382 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			GetDDMetricsReply newReply;
															#line 3383 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			newReply.storageMetricsList = reply.get().storageMetricsList;
															#line 3384 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			req.reply.send(newReply);
															#line 15411 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1when1(ErrorOr<GetDataDistributorMetricsReply> const& reply,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when1cont1(reply, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1when1(ErrorOr<GetDataDistributorMetricsReply> && reply,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when1cont1(std::move(reply), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DdMetricsRequestServerActor*>(this)->actor_wait_state > 0) static_cast<DdMetricsRequestServerActor*>(this)->actor_wait_state = 0;
		static_cast<DdMetricsRequestServerActor*>(this)->ActorCallback< DdMetricsRequestServerActor, 1, ErrorOr<GetDataDistributorMetricsReply> >::remove();

	}
	void a_callback_fire(ActorCallback< DdMetricsRequestServerActor, 1, ErrorOr<GetDataDistributorMetricsReply> >*,ErrorOr<GetDataDistributorMetricsReply> const& value) 
	{
		fdb_probe_actor_enter("ddMetricsRequestServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DdMetricsRequestServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ddMetricsRequestServer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DdMetricsRequestServerActor, 1, ErrorOr<GetDataDistributorMetricsReply> >*,ErrorOr<GetDataDistributorMetricsReply> && value) 
	{
		fdb_probe_actor_enter("ddMetricsRequestServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DdMetricsRequestServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ddMetricsRequestServer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DdMetricsRequestServerActor, 1, ErrorOr<GetDataDistributorMetricsReply> >*,Error err) 
	{
		fdb_probe_actor_enter("ddMetricsRequestServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DdMetricsRequestServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ddMetricsRequestServer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorSingleCallback< DdMetricsRequestServerActor, 0, GetDDMetricsRequest >*,GetDDMetricsRequest const& value) 
	{
		fdb_probe_actor_enter("ddMetricsRequestServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DdMetricsRequestServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ddMetricsRequestServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< DdMetricsRequestServerActor, 0, GetDDMetricsRequest >*,GetDDMetricsRequest && value) 
	{
		fdb_probe_actor_enter("ddMetricsRequestServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DdMetricsRequestServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ddMetricsRequestServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< DdMetricsRequestServerActor, 0, GetDDMetricsRequest >*,Error err) 
	{
		fdb_probe_actor_enter("ddMetricsRequestServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DdMetricsRequestServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ddMetricsRequestServer", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 3368 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	CommitProxyInterface proxy;
															#line 3368 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> db;
															#line 3371 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	GetDDMetricsRequest req;
															#line 15555 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
};
// This generated class is to be used only via ddMetricsRequestServer()
															#line 3368 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class DdMetricsRequestServerActor final : public Actor<Void>, public ActorSingleCallback< DdMetricsRequestServerActor, 0, GetDDMetricsRequest >, public ActorCallback< DdMetricsRequestServerActor, 1, ErrorOr<GetDataDistributorMetricsReply> >, public FastAllocated<DdMetricsRequestServerActor>, public DdMetricsRequestServerActorState<DdMetricsRequestServerActor> {
															#line 15560 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
public:
	using FastAllocated<DdMetricsRequestServerActor>::operator new;
	using FastAllocated<DdMetricsRequestServerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9532993235749531136UL, 5872287643553780480UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< DdMetricsRequestServerActor, 0, GetDDMetricsRequest >;
friend struct ActorCallback< DdMetricsRequestServerActor, 1, ErrorOr<GetDataDistributorMetricsReply> >;
															#line 3368 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	DdMetricsRequestServerActor(CommitProxyInterface const& proxy,Reference<AsyncVar<ServerDBInfo> const> const& db) 
															#line 15578 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		 : Actor<Void>(),
		   DdMetricsRequestServerActorState<DdMetricsRequestServerActor>(proxy, db),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("ddMetricsRequestServer", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2722599940322443264UL, 14232635602210436608UL);
		ActorExecutionContextHelper __helper(static_cast<DdMetricsRequestServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("ddMetricsRequestServer");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("ddMetricsRequestServer", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< DdMetricsRequestServerActor, 0, GetDDMetricsRequest >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DdMetricsRequestServerActor, 1, ErrorOr<GetDataDistributorMetricsReply> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 3368 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
[[nodiscard]] Future<Void> ddMetricsRequestServer( CommitProxyInterface const& proxy, Reference<AsyncVar<ServerDBInfo> const> const& db ) {
															#line 3368 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	return Future<Void>(new DdMetricsRequestServerActor(proxy, db));
															#line 15612 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
}

#line 3390 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"

															#line 15617 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
namespace {
// This generated class is to be used only via monitorRemoteCommitted()
															#line 3391 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
template <class MonitorRemoteCommittedActor>
															#line 3391 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class MonitorRemoteCommittedActorState {
															#line 15624 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
public:
															#line 3391 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	MonitorRemoteCommittedActorState(ProxyCommitData* const& self) 
															#line 3391 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
															#line 3391 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		 : self(self)
															#line 15631 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
	{
		fdb_probe_actor_create("monitorRemoteCommitted", reinterpret_cast<unsigned long>(this));

	}
	~MonitorRemoteCommittedActorState() 
	{
		fdb_probe_actor_destroy("monitorRemoteCommitted", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 3392 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			;
															#line 15646 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MonitorRemoteCommittedActorState();
		static_cast<MonitorRemoteCommittedActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 3393 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delay(0);
															#line 3393 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<MonitorRemoteCommittedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 15678 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<MonitorRemoteCommittedActor*>(this)->actor_wait_state = 1;
															#line 3393 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MonitorRemoteCommittedActor, 0, Void >*>(static_cast<MonitorRemoteCommittedActor*>(this)));
															#line 15683 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 3394 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		remoteLogs = Optional<std::vector<OptionalInterface<TLogInterface>>>();
															#line 3395 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (self->db->get().recoveryState >= RecoveryState::ALL_LOGS_RECRUITED)
															#line 15694 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 3396 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			for( auto& logSet : self->db->get().logSystemConfig.tLogs ) {
															#line 3397 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (!logSet.isLocal)
															#line 15700 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
				{
															#line 3398 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					remoteLogs = logSet.tLogs;
															#line 3399 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					for( auto& tLog : logSet.tLogs ) {
															#line 3400 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						if (!tLog.present())
															#line 15708 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
						{
															#line 3401 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
							remoteLogs = Optional<std::vector<OptionalInterface<TLogInterface>>>();
															#line 15712 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
							break;
						}
					}
					break;
				}
			}
		}
															#line 3410 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!remoteLogs.present())
															#line 15722 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 3411 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			StrictFuture<Void> __when_expr_1 = self->db->onChange();
															#line 3411 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (static_cast<MonitorRemoteCommittedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 15728 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<MonitorRemoteCommittedActor*>(this)->actor_wait_state = 2;
															#line 3411 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MonitorRemoteCommittedActor, 1, Void >*>(static_cast<MonitorRemoteCommittedActor*>(this)));
															#line 15733 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 3394 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		remoteLogs = Optional<std::vector<OptionalInterface<TLogInterface>>>();
															#line 3395 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (self->db->get().recoveryState >= RecoveryState::ALL_LOGS_RECRUITED)
															#line 15749 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 3396 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			for( auto& logSet : self->db->get().logSystemConfig.tLogs ) {
															#line 3397 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (!logSet.isLocal)
															#line 15755 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
				{
															#line 3398 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					remoteLogs = logSet.tLogs;
															#line 3399 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					for( auto& tLog : logSet.tLogs ) {
															#line 3400 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
						if (!tLog.present())
															#line 15763 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
						{
															#line 3401 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
							remoteLogs = Optional<std::vector<OptionalInterface<TLogInterface>>>();
															#line 15767 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
							break;
						}
					}
					break;
				}
			}
		}
															#line 3410 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!remoteLogs.present())
															#line 15777 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 3411 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			StrictFuture<Void> __when_expr_1 = self->db->onChange();
															#line 3411 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (static_cast<MonitorRemoteCommittedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 15783 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<MonitorRemoteCommittedActor*>(this)->actor_wait_state = 2;
															#line 3411 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MonitorRemoteCommittedActor, 1, Void >*>(static_cast<MonitorRemoteCommittedActor*>(this)));
															#line 15788 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MonitorRemoteCommittedActor*>(this)->actor_wait_state > 0) static_cast<MonitorRemoteCommittedActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorRemoteCommittedActor*>(this)->ActorCallback< MonitorRemoteCommittedActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorRemoteCommittedActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorRemoteCommitted", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorRemoteCommittedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorRemoteCommitted", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MonitorRemoteCommittedActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorRemoteCommitted", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorRemoteCommittedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorRemoteCommitted", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MonitorRemoteCommittedActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorRemoteCommitted", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorRemoteCommittedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorRemoteCommitted", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 3414 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		self->popRemoteTxs = true;
															#line 3416 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		onChange = self->db->onChange();
															#line 3417 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		;
															#line 15881 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont8(Void const& _,int loopDepth) 
	{
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1cont8(Void && _,int loopDepth) 
	{
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<MonitorRemoteCommittedActor*>(this)->actor_wait_state > 0) static_cast<MonitorRemoteCommittedActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorRemoteCommittedActor*>(this)->ActorCallback< MonitorRemoteCommittedActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorRemoteCommittedActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorRemoteCommitted", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorRemoteCommittedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorRemoteCommitted", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MonitorRemoteCommittedActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorRemoteCommitted", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorRemoteCommittedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorRemoteCommitted", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< MonitorRemoteCommittedActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorRemoteCommitted", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorRemoteCommittedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorRemoteCommitted", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont10(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1(int loopDepth) 
	{
															#line 3418 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		replies = std::vector<Future<TLogQueuingMetricsReply>>();
															#line 3419 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		for( auto& it : remoteLogs.get() ) {
															#line 3420 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			replies.push_back( brokenPromiseToNever(it.interf().getQueuingMetrics.getReply(TLogQueuingMetricsRequest())));
															#line 15994 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		}
															#line 3423 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_2 = waitForAll(replies) || onChange;
															#line 3423 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<MonitorRemoteCommittedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 16000 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont2loopBody1when1(__when_expr_2.get(), loopDepth); };
		static_cast<MonitorRemoteCommittedActor*>(this)->actor_wait_state = 3;
															#line 3423 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MonitorRemoteCommittedActor, 2, Void >*>(static_cast<MonitorRemoteCommittedActor*>(this)));
															#line 16005 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont10(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 3425 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (onChange.isReady())
															#line 16027 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
			return a_body1loopBody1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 3430 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		Version minVersion = std::numeric_limits<Version>::max();
															#line 3431 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		for( auto& it : replies ) {
															#line 3432 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			minVersion = std::min(minVersion, it.get().v);
															#line 16037 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		}
															#line 3435 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		for(;self->txsPopVersions.size() && self->txsPopVersions.front().first <= minVersion;) {
															#line 3436 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			self->lastTxsPop = self->txsPopVersions.front().second;
															#line 3437 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			self->logSystem->popTxs(self->txsPopVersions.front().second, tagLocalityRemoteLog);
															#line 3438 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			self->txsPopVersions.pop_front();
															#line 16047 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		}
															#line 3441 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_3 = delay(SERVER_KNOBS->UPDATE_REMOTE_LOG_VERSION_INTERVAL) || onChange;
															#line 3441 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<MonitorRemoteCommittedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 16053 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont2loopBody1cont1when1(__when_expr_3.get(), loopDepth); };
		static_cast<MonitorRemoteCommittedActor*>(this)->actor_wait_state = 4;
															#line 3441 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< MonitorRemoteCommittedActor, 3, Void >*>(static_cast<MonitorRemoteCommittedActor*>(this)));
															#line 16058 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 3425 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (onChange.isReady())
															#line 16067 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
			return a_body1loopBody1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 3430 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		Version minVersion = std::numeric_limits<Version>::max();
															#line 3431 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		for( auto& it : replies ) {
															#line 3432 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			minVersion = std::min(minVersion, it.get().v);
															#line 16077 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		}
															#line 3435 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		for(;self->txsPopVersions.size() && self->txsPopVersions.front().first <= minVersion;) {
															#line 3436 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			self->lastTxsPop = self->txsPopVersions.front().second;
															#line 3437 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			self->logSystem->popTxs(self->txsPopVersions.front().second, tagLocalityRemoteLog);
															#line 3438 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			self->txsPopVersions.pop_front();
															#line 16087 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		}
															#line 3441 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_3 = delay(SERVER_KNOBS->UPDATE_REMOTE_LOG_VERSION_INTERVAL) || onChange;
															#line 3441 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (static_cast<MonitorRemoteCommittedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 16093 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont2loopBody1cont1when1(__when_expr_3.get(), loopDepth); };
		static_cast<MonitorRemoteCommittedActor*>(this)->actor_wait_state = 4;
															#line 3441 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< MonitorRemoteCommittedActor, 3, Void >*>(static_cast<MonitorRemoteCommittedActor*>(this)));
															#line 16098 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<MonitorRemoteCommittedActor*>(this)->actor_wait_state > 0) static_cast<MonitorRemoteCommittedActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorRemoteCommittedActor*>(this)->ActorCallback< MonitorRemoteCommittedActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorRemoteCommittedActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorRemoteCommitted", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorRemoteCommittedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorRemoteCommitted", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< MonitorRemoteCommittedActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorRemoteCommitted", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorRemoteCommittedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorRemoteCommitted", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< MonitorRemoteCommittedActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorRemoteCommitted", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorRemoteCommittedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorRemoteCommitted", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont2loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 3442 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (onChange.isReady())
															#line 16182 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
			return a_body1loopBody1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
		if (loopDepth == 0) return a_body1loopBody1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 3442 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (onChange.isReady())
															#line 16194 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
			return a_body1loopBody1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
		if (loopDepth == 0) return a_body1loopBody1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<MonitorRemoteCommittedActor*>(this)->actor_wait_state > 0) static_cast<MonitorRemoteCommittedActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorRemoteCommittedActor*>(this)->ActorCallback< MonitorRemoteCommittedActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorRemoteCommittedActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorRemoteCommitted", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorRemoteCommittedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont2loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorRemoteCommitted", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< MonitorRemoteCommittedActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorRemoteCommitted", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorRemoteCommittedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont2loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorRemoteCommitted", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< MonitorRemoteCommittedActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorRemoteCommitted", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorRemoteCommittedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorRemoteCommitted", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 3391 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ProxyCommitData* self;
															#line 3394 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Optional<std::vector<OptionalInterface<TLogInterface>>> remoteLogs;
															#line 3416 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	Future<Void> onChange;
															#line 3418 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	std::vector<Future<TLogQueuingMetricsReply>> replies;
															#line 16285 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
};
// This generated class is to be used only via monitorRemoteCommitted()
															#line 3391 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class MonitorRemoteCommittedActor final : public Actor<Void>, public ActorCallback< MonitorRemoteCommittedActor, 0, Void >, public ActorCallback< MonitorRemoteCommittedActor, 1, Void >, public ActorCallback< MonitorRemoteCommittedActor, 2, Void >, public ActorCallback< MonitorRemoteCommittedActor, 3, Void >, public FastAllocated<MonitorRemoteCommittedActor>, public MonitorRemoteCommittedActorState<MonitorRemoteCommittedActor> {
															#line 16290 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
public:
	using FastAllocated<MonitorRemoteCommittedActor>::operator new;
	using FastAllocated<MonitorRemoteCommittedActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9105779788017451520UL, 8359081137283394816UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MonitorRemoteCommittedActor, 0, Void >;
friend struct ActorCallback< MonitorRemoteCommittedActor, 1, Void >;
friend struct ActorCallback< MonitorRemoteCommittedActor, 2, Void >;
friend struct ActorCallback< MonitorRemoteCommittedActor, 3, Void >;
															#line 3391 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	MonitorRemoteCommittedActor(ProxyCommitData* const& self) 
															#line 16310 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		 : Actor<Void>(),
		   MonitorRemoteCommittedActorState<MonitorRemoteCommittedActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("monitorRemoteCommitted", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5098072617628861952UL, 10945506090906970880UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorRemoteCommittedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("monitorRemoteCommitted");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("monitorRemoteCommitted", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MonitorRemoteCommittedActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< MonitorRemoteCommittedActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< MonitorRemoteCommittedActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< MonitorRemoteCommittedActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 3391 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
[[nodiscard]] Future<Void> monitorRemoteCommitted( ProxyCommitData* const& self ) {
															#line 3391 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	return Future<Void>(new MonitorRemoteCommittedActor(self));
															#line 16346 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
}

#line 3448 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"

															#line 16351 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
namespace {
// This generated class is to be used only via proxySnapCreate()
															#line 3449 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
template <class ProxySnapCreateActor>
															#line 3449 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class ProxySnapCreateActorState {
															#line 16358 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
public:
															#line 3449 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ProxySnapCreateActorState(ProxySnapRequest const& snapReq,ProxyCommitData* const& commitData) 
															#line 3449 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
															#line 3449 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		 : snapReq(snapReq),
															#line 3449 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   commitData(commitData)
															#line 16367 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
	{
		fdb_probe_actor_create("proxySnapCreate", reinterpret_cast<unsigned long>(this));

	}
	~ProxySnapCreateActorState() 
	{
		fdb_probe_actor_destroy("proxySnapCreate", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 3450 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			TraceEvent("SnapCommitProxy_SnapReqEnter") .detail("SnapPayload", snapReq.snapPayload) .detail("SnapUID", snapReq.snapUID);
															#line 16382 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			try {
															#line 3455 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				ExecCmdValueString execArg(snapReq.snapPayload);
															#line 3456 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				StringRef binPath = execArg.getBinaryPath();
															#line 3457 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (!isWhitelisted(commitData->whitelistedBinPathVec, binPath))
															#line 16390 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
				{
															#line 3458 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					TraceEvent("SnapCommitProxy_WhiteListCheckFailed") .detail("SnapPayload", snapReq.snapPayload) .detail("SnapUID", snapReq.snapUID);
															#line 3461 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					return a_body1Catch2(snap_path_not_whitelisted(), loopDepth);
															#line 16396 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
				}
															#line 3464 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (commitData->db->get().recoveryState != RecoveryState::FULLY_RECOVERED)
															#line 16400 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
				{
															#line 3470 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					TraceEvent("SnapCommitProxy_ClusterNotFullyRecovered") .detail("SnapPayload", snapReq.snapPayload) .detail("SnapUID", snapReq.snapUID);
															#line 3473 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					return a_body1Catch2(snap_not_fully_recovered_unsupported(), loopDepth);
															#line 16406 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
				}
															#line 3476 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				auto result = commitData->txnStateStore->readValue("log_anti_quorum"_sr.withPrefix(configKeysPrefix)).get();
															#line 3477 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				int logAntiQuorum = 0;
															#line 3478 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (result.present())
															#line 16414 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
				{
															#line 3479 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					logAntiQuorum = atoi(result.get().toString().c_str());
															#line 16418 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
				}
															#line 3483 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (logAntiQuorum > 0)
															#line 16422 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
				{
															#line 3484 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					TraceEvent("SnapCommitProxy_LogAntiQuorumNotSupported") .detail("SnapPayload", snapReq.snapPayload) .detail("SnapUID", snapReq.snapUID);
															#line 3487 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
					return a_body1Catch2(snap_log_anti_quorum_unsupported(), loopDepth);
															#line 16428 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
				}
															#line 3490 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				snapReqRetry = 0;
															#line 3491 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				snapRetryBackoff = FLOW_KNOBS->PREVENT_FAST_SPIN_DELAY;
															#line 3492 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				;
															#line 16436 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ProxySnapCreateActorState();
		static_cast<ProxySnapCreateActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 3530 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		TraceEvent("SnapCommitProxy_SnapReqExit") .detail("SnapPayload", snapReq.snapPayload) .detail("SnapUID", snapReq.snapUID);
															#line 3533 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!static_cast<ProxySnapCreateActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ProxySnapCreateActorState(); static_cast<ProxySnapCreateActor*>(this)->destroy(); return 0; }
															#line 16467 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		new (&static_cast<ProxySnapCreateActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ProxySnapCreateActorState();
		static_cast<ProxySnapCreateActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 3520 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			TraceEvent("SnapCommitProxy_SnapReqError") .errorUnsuppressed(e) .detail("SnapPayload", snapReq.snapPayload) .detail("SnapUID", snapReq.snapUID);
															#line 3524 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (e.code() != error_code_operation_cancelled)
															#line 16482 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			{
															#line 3525 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				snapReq.reply.sendError(e);
															#line 16486 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			}
			else
			{
															#line 3527 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 16492 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			}
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 3518 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		snapReq.reply.send(Void());
															#line 16508 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 3494 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!commitData->db->get().distributor.present())
															#line 16524 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		{
															#line 3495 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			TraceEvent(SevWarnAlways, "DataDistributorNotPresent").detail("Operation", "SnapRequest");
															#line 3496 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			return a_body1Catch2(dd_not_found(), std::max(0, loopDepth - 1));
															#line 16530 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		}
		try {
															#line 3499 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			Future<ErrorOr<Void>> ddSnapReq = commitData->db->get().distributor.get().distributorSnapReq.tryGetReply( DistributorSnapRequest(snapReq.snapPayload, snapReq.snapUID));
															#line 3502 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			StrictFuture<Void> __when_expr_0 = throwErrorOr(ddSnapReq);
															#line 3502 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (static_cast<ProxySnapCreateActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 16539 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ProxySnapCreateActor*>(this)->actor_wait_state = 1;
															#line 3502 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ProxySnapCreateActor, 0, Void >*>(static_cast<ProxySnapCreateActor*>(this)));
															#line 16544 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 3505 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			TraceEvent("SnapCommitProxy_DDSnapResponseError") .errorUnsuppressed(e) .detail("SnapPayload", snapReq.snapPayload) .detail("SnapUID", snapReq.snapUID) .detail("Retry", snapReqRetry);
															#line 3511 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (e.code() != error_code_request_maybe_delivered || ++snapReqRetry > SERVER_KNOBS->SNAP_NETWORK_FAILURE_RETRY_LIMIT)
															#line 16581 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			{
															#line 3513 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				return a_body1Catch2(e, std::max(0, loopDepth - 1));
															#line 16585 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			}
															#line 3514 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			StrictFuture<Void> __when_expr_1 = delay(snapRetryBackoff);
															#line 3514 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (static_cast<ProxySnapCreateActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 16591 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<ProxySnapCreateActor*>(this)->actor_wait_state = 2;
															#line 3514 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ProxySnapCreateActor, 1, Void >*>(static_cast<ProxySnapCreateActor*>(this)));
															#line 16596 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ProxySnapCreateActor*>(this)->actor_wait_state > 0) static_cast<ProxySnapCreateActor*>(this)->actor_wait_state = 0;
		static_cast<ProxySnapCreateActor*>(this)->ActorCallback< ProxySnapCreateActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ProxySnapCreateActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("proxySnapCreate", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProxySnapCreateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("proxySnapCreate", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ProxySnapCreateActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("proxySnapCreate", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProxySnapCreateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("proxySnapCreate", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ProxySnapCreateActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("proxySnapCreate", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ProxySnapCreateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("proxySnapCreate", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
															#line 3515 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		snapRetryBackoff = snapRetryBackoff * 2;
															#line 16698 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
															#line 3515 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		snapRetryBackoff = snapRetryBackoff * 2;
															#line 16707 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ProxySnapCreateActor*>(this)->actor_wait_state > 0) static_cast<ProxySnapCreateActor*>(this)->actor_wait_state = 0;
		static_cast<ProxySnapCreateActor*>(this)->ActorCallback< ProxySnapCreateActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ProxySnapCreateActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("proxySnapCreate", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProxySnapCreateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("proxySnapCreate", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ProxySnapCreateActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("proxySnapCreate", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProxySnapCreateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("proxySnapCreate", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ProxySnapCreateActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("proxySnapCreate", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ProxySnapCreateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("proxySnapCreate", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont8(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 3449 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ProxySnapRequest snapReq;
															#line 3449 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ProxyCommitData* commitData;
															#line 3490 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	int snapReqRetry;
															#line 3491 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	double snapRetryBackoff;
															#line 16808 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
};
// This generated class is to be used only via proxySnapCreate()
															#line 3449 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class ProxySnapCreateActor final : public Actor<Void>, public ActorCallback< ProxySnapCreateActor, 0, Void >, public ActorCallback< ProxySnapCreateActor, 1, Void >, public FastAllocated<ProxySnapCreateActor>, public ProxySnapCreateActorState<ProxySnapCreateActor> {
															#line 16813 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
public:
	using FastAllocated<ProxySnapCreateActor>::operator new;
	using FastAllocated<ProxySnapCreateActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1198610799911156480UL, 10774471195306216960UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ProxySnapCreateActor, 0, Void >;
friend struct ActorCallback< ProxySnapCreateActor, 1, Void >;
															#line 3449 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ProxySnapCreateActor(ProxySnapRequest const& snapReq,ProxyCommitData* const& commitData) 
															#line 16831 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		 : Actor<Void>(),
		   ProxySnapCreateActorState<ProxySnapCreateActor>(snapReq, commitData),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("proxySnapCreate", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9779697684357553408UL, 1968612500139297024UL);
		ActorExecutionContextHelper __helper(static_cast<ProxySnapCreateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("proxySnapCreate");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("proxySnapCreate", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ProxySnapCreateActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ProxySnapCreateActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 3449 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
[[nodiscard]] Future<Void> proxySnapCreate( ProxySnapRequest const& snapReq, ProxyCommitData* const& commitData ) {
															#line 3449 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	return Future<Void>(new ProxySnapCreateActor(snapReq, commitData));
															#line 16865 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
}

#line 3535 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"

															#line 16870 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
namespace {
// This generated class is to be used only via proxyCheckSafeExclusion()
															#line 3536 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
template <class ProxyCheckSafeExclusionActor>
															#line 3536 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
class ProxyCheckSafeExclusionActorState {
															#line 16877 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
public:
															#line 3536 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
	ProxyCheckSafeExclusionActorState(Reference<AsyncVar<ServerDBInfo> const> const& db,ExclusionSafetyCheckRequest const& req) 
															#line 3536 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
															#line 3536 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		 : db(db),
															#line 3536 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		   req(req)
															#line 16886 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
	{
		fdb_probe_actor_create("proxyCheckSafeExclusion", reinterpret_cast<unsigned long>(this));

	}
	~ProxyCheckSafeExclusionActorState() 
	{
		fdb_probe_actor_destroy("proxyCheckSafeExclusion", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 3538 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			TraceEvent("SafetyCheckCommitProxyBegin").log();
															#line 3539 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			reply = ExclusionSafetyCheckReply(false);
															#line 3540 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (!db->get().distributor.present())
															#line 16905 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			{
															#line 3541 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				TraceEvent(SevWarnAlways, "DataDistributorNotPresent").detail("Operation", "ExclusionSafetyCheck");
															#line 3542 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				req.reply.send(reply);
															#line 3543 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (!static_cast<ProxyCheckSafeExclusionActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ProxyCheckSafeExclusionActorState(); static_cast<ProxyCheckSafeExclusionActor*>(this)->destroy(); return 0; }
															#line 16913 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
				new (&static_cast<ProxyCheckSafeExclusionActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~ProxyCheckSafeExclusionActorState();
				static_cast<ProxyCheckSafeExclusionActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			try {
															#line 3546 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				ddSafeFuture = db->get().distributor.get().distributorExclCheckReq.tryGetReply( DistributorExclusionSafetyCheckRequest(req.exclusions));
															#line 3549 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				StrictFuture<DistributorExclusionSafetyCheckReply> __when_expr_0 = throwErrorOr(ddSafeFuture);
															#line 3549 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (static_cast<ProxyCheckSafeExclusionActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 16926 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<ProxyCheckSafeExclusionActor*>(this)->actor_wait_state = 1;
															#line 3549 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ProxyCheckSafeExclusionActor, 0, DistributorExclusionSafetyCheckReply >*>(static_cast<ProxyCheckSafeExclusionActor*>(this)));
															#line 16931 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ProxyCheckSafeExclusionActorState();
		static_cast<ProxyCheckSafeExclusionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 3570 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		TraceEvent("SafetyCheckCommitProxyFinish").log();
															#line 3571 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		req.reply.send(reply);
															#line 3572 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
		if (!static_cast<ProxyCheckSafeExclusionActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ProxyCheckSafeExclusionActorState(); static_cast<ProxyCheckSafeExclusionActor*>(this)->destroy(); return 0; }
															#line 16964 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
		new (&static_cast<ProxyCheckSafeExclusionActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ProxyCheckSafeExclusionActorState();
		static_cast<ProxyCheckSafeExclusionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 3562 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			TraceEvent("SafetyCheckCommitProxyResponseError").error(e);
															#line 3563 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
			if (e.code() != error_code_operation_cancelled)
															#line 16979 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
			{
															#line 3564 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				req.reply.sendError(e);
															#line 3565 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				if (!static_cast<ProxyCheckSafeExclusionActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ProxyCheckSafeExclusionActorState(); static_cast<ProxyCheckSafeExclusionActor*>(this)->destroy(); return 0; }
															#line 16985 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/build_output/fdbserver/CommitProxyServer.actor.g.cpp"
				new (&static_cast<ProxyCheckSafeExclusionActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~ProxyCheckSafeExclusionActorState();
				static_cast<ProxyCheckSafeExclusionActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 3567 "/codebuild/output/src2270659404/src/github.com/apple/foundationdb/fdbserver/CommitProxyServer.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line