#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
/*
 * IAsyncFile.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2022 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "flow/IAsyncFile.h"
#include "flow/Error.h"
#include "flow/Knobs.h"
#include "flow/Platform.h"
#include "flow/UnitTest.h"
#include <iostream>
#include "flow/actorcompiler.h" // has to be last include

IAsyncFile::~IAsyncFile() = default;

const static unsigned int ONE_MEGABYTE = 1 << 20;
const static unsigned int FOUR_KILOBYTES = 4 << 10;

															#line 36 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
namespace {
// This generated class is to be used only via zeroRangeHelper()
															#line 34 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
template <class ZeroRangeHelperActor>
															#line 34 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
class ZeroRangeHelperActorState {
															#line 43 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
public:
															#line 34 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
	ZeroRangeHelperActorState(Reference<IAsyncFile> const& f,int64_t const& offset,int64_t const& length,int const& fixedbyte) 
															#line 34 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
															#line 34 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		 : f(f),
															#line 34 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		   offset(offset),
															#line 34 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		   length(length),
															#line 34 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		   fixedbyte(fixedbyte),
															#line 35 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		   pos(offset),
															#line 36 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		   zeros(aligned_alloc(ONE_MEGABYTE, ONE_MEGABYTE))
															#line 60 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
	{
		fdb_probe_actor_create("zeroRangeHelper", reinterpret_cast<unsigned long>(this));

	}
	~ZeroRangeHelperActorState() 
	{
		fdb_probe_actor_destroy("zeroRangeHelper", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 37 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
			memset(zeros, fixedbyte, ONE_MEGABYTE);
															#line 39 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
			;
															#line 77 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ZeroRangeHelperActorState();
		static_cast<ZeroRangeHelperActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 46 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		aligned_free(zeros);
															#line 47 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (!static_cast<ZeroRangeHelperActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ZeroRangeHelperActorState(); static_cast<ZeroRangeHelperActor*>(this)->destroy(); return 0; }
															#line 102 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		new (&static_cast<ZeroRangeHelperActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ZeroRangeHelperActorState();
		static_cast<ZeroRangeHelperActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 39 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (!(pos < offset + length))
															#line 121 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 40 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		len = std::min<int64_t>(ONE_MEGABYTE, offset + length - pos);
															#line 41 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		StrictFuture<Void> __when_expr_0 = f->write(zeros, len, pos);
															#line 41 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (static_cast<ZeroRangeHelperActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 131 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<ZeroRangeHelperActor*>(this)->actor_wait_state = 1;
															#line 41 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ZeroRangeHelperActor, 0, Void >*>(static_cast<ZeroRangeHelperActor*>(this)));
															#line 136 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 42 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		pos += len;
															#line 43 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		StrictFuture<Void> __when_expr_1 = yield();
															#line 43 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (static_cast<ZeroRangeHelperActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 162 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ZeroRangeHelperActor*>(this)->actor_wait_state = 2;
															#line 43 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ZeroRangeHelperActor, 1, Void >*>(static_cast<ZeroRangeHelperActor*>(this)));
															#line 167 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 42 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		pos += len;
															#line 43 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		StrictFuture<Void> __when_expr_1 = yield();
															#line 43 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (static_cast<ZeroRangeHelperActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 180 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ZeroRangeHelperActor*>(this)->actor_wait_state = 2;
															#line 43 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ZeroRangeHelperActor, 1, Void >*>(static_cast<ZeroRangeHelperActor*>(this)));
															#line 185 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ZeroRangeHelperActor*>(this)->actor_wait_state > 0) static_cast<ZeroRangeHelperActor*>(this)->actor_wait_state = 0;
		static_cast<ZeroRangeHelperActor*>(this)->ActorCallback< ZeroRangeHelperActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ZeroRangeHelperActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("zeroRangeHelper", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("zeroRangeHelper", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ZeroRangeHelperActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("zeroRangeHelper", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("zeroRangeHelper", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ZeroRangeHelperActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("zeroRangeHelper", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("zeroRangeHelper", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ZeroRangeHelperActor*>(this)->actor_wait_state > 0) static_cast<ZeroRangeHelperActor*>(this)->actor_wait_state = 0;
		static_cast<ZeroRangeHelperActor*>(this)->ActorCallback< ZeroRangeHelperActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ZeroRangeHelperActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("zeroRangeHelper", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("zeroRangeHelper", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ZeroRangeHelperActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("zeroRangeHelper", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("zeroRangeHelper", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ZeroRangeHelperActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("zeroRangeHelper", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("zeroRangeHelper", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 34 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
	Reference<IAsyncFile> f;
															#line 34 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
	int64_t offset;
															#line 34 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
	int64_t length;
															#line 34 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
	int fixedbyte;
															#line 35 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
	int64_t pos;
															#line 36 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
	void* zeros;
															#line 40 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
	int len;
															#line 342 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
};
// This generated class is to be used only via zeroRangeHelper()
															#line 34 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
class ZeroRangeHelperActor final : public Actor<Void>, public ActorCallback< ZeroRangeHelperActor, 0, Void >, public ActorCallback< ZeroRangeHelperActor, 1, Void >, public FastAllocated<ZeroRangeHelperActor>, public ZeroRangeHelperActorState<ZeroRangeHelperActor> {
															#line 347 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
public:
	using FastAllocated<ZeroRangeHelperActor>::operator new;
	using FastAllocated<ZeroRangeHelperActor>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<Void>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
friend struct ActorCallback< ZeroRangeHelperActor, 0, Void >;
friend struct ActorCallback< ZeroRangeHelperActor, 1, Void >;
															#line 34 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
	ZeroRangeHelperActor(Reference<IAsyncFile> const& f,int64_t const& offset,int64_t const& length,int const& fixedbyte) 
															#line 359 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		 : Actor<Void>(),
		   ZeroRangeHelperActorState<ZeroRangeHelperActor>(f, offset, length, fixedbyte)
	{
		fdb_probe_actor_enter("zeroRangeHelper", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("zeroRangeHelper");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("zeroRangeHelper", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ZeroRangeHelperActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ZeroRangeHelperActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
}
															#line 34 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
[[nodiscard]] static Future<Void> zeroRangeHelper( Reference<IAsyncFile> const& f, int64_t const& offset, int64_t const& length, int const& fixedbyte ) {
															#line 34 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
	return Future<Void>(new ZeroRangeHelperActor(f, offset, length, fixedbyte));
															#line 388 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
}

#line 49 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"

Future<Void> IAsyncFile::zeroRange(int64_t offset, int64_t length) {
	return uncancellable(zeroRangeHelper(Reference<IAsyncFile>::addRef(this), offset, length, 0));
}

															#line 397 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase54()
															#line 54 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
template <class FlowTestCase54Actor>
															#line 54 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
class FlowTestCase54ActorState {
															#line 404 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
public:
															#line 54 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
	FlowTestCase54ActorState(UnitTestParameters const& params) 
															#line 54 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
															#line 54 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		 : params(params),
															#line 55 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		   filename("/tmp/__ZEROJUNK__")
															#line 413 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase54", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase54ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase54", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 56 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
			StrictFuture<Reference<IAsyncFile>> __when_expr_0 = IAsyncFileSystem::filesystem()->open( filename, IAsyncFile::OPEN_ATOMIC_WRITE_AND_CREATE | IAsyncFile::OPEN_CREATE | IAsyncFile::OPEN_READWRITE, 0);
															#line 56 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
			if (static_cast<FlowTestCase54Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 430 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase54Actor*>(this)->actor_wait_state = 1;
															#line 56 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase54Actor, 0, Reference<IAsyncFile> >*>(static_cast<FlowTestCase54Actor*>(this)));
															#line 435 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase54ActorState();
		static_cast<FlowTestCase54Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 60 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		StrictFuture<Void> __when_expr_1 = f->sync();
															#line 60 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (static_cast<FlowTestCase54Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 460 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<FlowTestCase54Actor*>(this)->actor_wait_state = 2;
															#line 60 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase54Actor, 1, Void >*>(static_cast<FlowTestCase54Actor*>(this)));
															#line 465 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Reference<IAsyncFile> const& __f,int loopDepth) 
	{
															#line 56 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		f = __f;
															#line 474 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Reference<IAsyncFile> && __f,int loopDepth) 
	{
		f = std::move(__f);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase54Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase54Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase54Actor*>(this)->ActorCallback< FlowTestCase54Actor, 0, Reference<IAsyncFile> >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase54Actor, 0, Reference<IAsyncFile> >*,Reference<IAsyncFile> const& value) 
	{
		fdb_probe_actor_enter("flowTestCase54", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase54", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase54Actor, 0, Reference<IAsyncFile> >*,Reference<IAsyncFile> && value) 
	{
		fdb_probe_actor_enter("flowTestCase54", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase54", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase54Actor, 0, Reference<IAsyncFile> >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase54", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase54", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 61 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		StrictFuture<Void> __when_expr_2 = f->zeroRange(0, ONE_MEGABYTE);
															#line 61 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (static_cast<FlowTestCase54Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 543 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<FlowTestCase54Actor*>(this)->actor_wait_state = 3;
															#line 61 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase54Actor, 2, Void >*>(static_cast<FlowTestCase54Actor*>(this)));
															#line 548 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 61 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		StrictFuture<Void> __when_expr_2 = f->zeroRange(0, ONE_MEGABYTE);
															#line 61 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (static_cast<FlowTestCase54Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 559 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<FlowTestCase54Actor*>(this)->actor_wait_state = 3;
															#line 61 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase54Actor, 2, Void >*>(static_cast<FlowTestCase54Actor*>(this)));
															#line 564 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<FlowTestCase54Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase54Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase54Actor*>(this)->ActorCallback< FlowTestCase54Actor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase54Actor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase54", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase54", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FlowTestCase54Actor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase54", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase54", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FlowTestCase54Actor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase54", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase54", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 62 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		StrictFuture<int64_t> __when_expr_3 = f->size();
															#line 62 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (static_cast<FlowTestCase54Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 638 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<FlowTestCase54Actor*>(this)->actor_wait_state = 4;
															#line 62 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase54Actor, 3, int64_t >*>(static_cast<FlowTestCase54Actor*>(this)));
															#line 643 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 62 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		StrictFuture<int64_t> __when_expr_3 = f->size();
															#line 62 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (static_cast<FlowTestCase54Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 654 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<FlowTestCase54Actor*>(this)->actor_wait_state = 4;
															#line 62 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase54Actor, 3, int64_t >*>(static_cast<FlowTestCase54Actor*>(this)));
															#line 659 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<FlowTestCase54Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase54Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase54Actor*>(this)->ActorCallback< FlowTestCase54Actor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase54Actor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase54", reinterpret_cast<unsigned long>(this), 2);
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase54", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< FlowTestCase54Actor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase54", reinterpret_cast<unsigned long>(this), 2);
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase54", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< FlowTestCase54Actor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase54", reinterpret_cast<unsigned long>(this), 2);
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase54", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont4(int64_t const& size,int loopDepth) 
	{
															#line 63 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		ASSERT(ONE_MEGABYTE == size);
															#line 66 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		StrictFuture<Void> __when_expr_4 = zeroRangeHelper(f, 0, ONE_MEGABYTE, 0xff);
															#line 66 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (static_cast<FlowTestCase54Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 735 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<FlowTestCase54Actor*>(this)->actor_wait_state = 5;
															#line 66 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase54Actor, 4, Void >*>(static_cast<FlowTestCase54Actor*>(this)));
															#line 740 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(int64_t && size,int loopDepth) 
	{
															#line 63 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		ASSERT(ONE_MEGABYTE == size);
															#line 66 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		StrictFuture<Void> __when_expr_4 = zeroRangeHelper(f, 0, ONE_MEGABYTE, 0xff);
															#line 66 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (static_cast<FlowTestCase54Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 753 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<FlowTestCase54Actor*>(this)->actor_wait_state = 5;
															#line 66 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase54Actor, 4, Void >*>(static_cast<FlowTestCase54Actor*>(this)));
															#line 758 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3when1(int64_t const& size,int loopDepth) 
	{
		loopDepth = a_body1cont4(size, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(int64_t && size,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(size), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<FlowTestCase54Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase54Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase54Actor*>(this)->ActorCallback< FlowTestCase54Actor, 3, int64_t >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase54Actor, 3, int64_t >*,int64_t const& value) 
	{
		fdb_probe_actor_enter("flowTestCase54", reinterpret_cast<unsigned long>(this), 3);
		a_exitChoose4();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase54", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< FlowTestCase54Actor, 3, int64_t >*,int64_t && value) 
	{
		fdb_probe_actor_enter("flowTestCase54", reinterpret_cast<unsigned long>(this), 3);
		a_exitChoose4();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase54", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< FlowTestCase54Actor, 3, int64_t >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase54", reinterpret_cast<unsigned long>(this), 3);
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase54", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 67 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		StrictFuture<Void> __when_expr_5 = f->zeroRange(0, ONE_MEGABYTE);
															#line 67 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (static_cast<FlowTestCase54Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 832 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont5when1(__when_expr_5.get(), loopDepth); };
		static_cast<FlowTestCase54Actor*>(this)->actor_wait_state = 6;
															#line 67 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase54Actor, 5, Void >*>(static_cast<FlowTestCase54Actor*>(this)));
															#line 837 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 67 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		StrictFuture<Void> __when_expr_5 = f->zeroRange(0, ONE_MEGABYTE);
															#line 67 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (static_cast<FlowTestCase54Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 848 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont5when1(__when_expr_5.get(), loopDepth); };
		static_cast<FlowTestCase54Actor*>(this)->actor_wait_state = 6;
															#line 67 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase54Actor, 5, Void >*>(static_cast<FlowTestCase54Actor*>(this)));
															#line 853 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<FlowTestCase54Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase54Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase54Actor*>(this)->ActorCallback< FlowTestCase54Actor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase54Actor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase54", reinterpret_cast<unsigned long>(this), 4);
		a_exitChoose5();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase54", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< FlowTestCase54Actor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase54", reinterpret_cast<unsigned long>(this), 4);
		a_exitChoose5();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase54", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< FlowTestCase54Actor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase54", reinterpret_cast<unsigned long>(this), 4);
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase54", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 68 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		page = (uint8_t*)malloc(FOUR_KILOBYTES);
															#line 69 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		StrictFuture<int> __when_expr_6 = f->read(page, FOUR_KILOBYTES, 0);
															#line 69 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (static_cast<FlowTestCase54Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 929 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont6when1(__when_expr_6.get(), loopDepth); };
		static_cast<FlowTestCase54Actor*>(this)->actor_wait_state = 7;
															#line 69 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase54Actor, 6, int >*>(static_cast<FlowTestCase54Actor*>(this)));
															#line 934 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 68 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		page = (uint8_t*)malloc(FOUR_KILOBYTES);
															#line 69 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		StrictFuture<int> __when_expr_6 = f->read(page, FOUR_KILOBYTES, 0);
															#line 69 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (static_cast<FlowTestCase54Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 947 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont6when1(__when_expr_6.get(), loopDepth); };
		static_cast<FlowTestCase54Actor*>(this)->actor_wait_state = 7;
															#line 69 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase54Actor, 6, int >*>(static_cast<FlowTestCase54Actor*>(this)));
															#line 952 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<FlowTestCase54Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase54Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase54Actor*>(this)->ActorCallback< FlowTestCase54Actor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase54Actor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase54", reinterpret_cast<unsigned long>(this), 5);
		a_exitChoose6();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase54", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< FlowTestCase54Actor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase54", reinterpret_cast<unsigned long>(this), 5);
		a_exitChoose6();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase54", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< FlowTestCase54Actor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase54", reinterpret_cast<unsigned long>(this), 5);
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase54", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont7(int const& n,int loopDepth) 
	{
															#line 70 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		ASSERT(n == FOUR_KILOBYTES);
															#line 71 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		for(int i = 0;i < FOUR_KILOBYTES;i++) {
															#line 72 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
			ASSERT(page[i] == 0);
															#line 1028 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		}
															#line 74 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		free(page);
															#line 77 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		f.clear();
															#line 78 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		StrictFuture<Void> __when_expr_7 = IAsyncFileSystem::filesystem()->deleteFile(filename, true);
															#line 78 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (static_cast<FlowTestCase54Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1038 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont7when1(__when_expr_7.get(), loopDepth); };
		static_cast<FlowTestCase54Actor*>(this)->actor_wait_state = 8;
															#line 78 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase54Actor, 7, Void >*>(static_cast<FlowTestCase54Actor*>(this)));
															#line 1043 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7(int && n,int loopDepth) 
	{
															#line 70 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		ASSERT(n == FOUR_KILOBYTES);
															#line 71 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		for(int i = 0;i < FOUR_KILOBYTES;i++) {
															#line 72 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
			ASSERT(page[i] == 0);
															#line 1056 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		}
															#line 74 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		free(page);
															#line 77 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		f.clear();
															#line 78 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		StrictFuture<Void> __when_expr_7 = IAsyncFileSystem::filesystem()->deleteFile(filename, true);
															#line 78 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (static_cast<FlowTestCase54Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1066 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont7when1(__when_expr_7.get(), loopDepth); };
		static_cast<FlowTestCase54Actor*>(this)->actor_wait_state = 8;
															#line 78 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase54Actor, 7, Void >*>(static_cast<FlowTestCase54Actor*>(this)));
															#line 1071 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6when1(int const& n,int loopDepth) 
	{
		loopDepth = a_body1cont7(n, loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(int && n,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(n), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<FlowTestCase54Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase54Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase54Actor*>(this)->ActorCallback< FlowTestCase54Actor, 6, int >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase54Actor, 6, int >*,int const& value) 
	{
		fdb_probe_actor_enter("flowTestCase54", reinterpret_cast<unsigned long>(this), 6);
		a_exitChoose7();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase54", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< FlowTestCase54Actor, 6, int >*,int && value) 
	{
		fdb_probe_actor_enter("flowTestCase54", reinterpret_cast<unsigned long>(this), 6);
		a_exitChoose7();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase54", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< FlowTestCase54Actor, 6, int >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase54", reinterpret_cast<unsigned long>(this), 6);
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase54", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont8(Void const& _,int loopDepth) 
	{
															#line 79 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (!static_cast<FlowTestCase54Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase54ActorState(); static_cast<FlowTestCase54Actor*>(this)->destroy(); return 0; }
															#line 1143 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		new (&static_cast<FlowTestCase54Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase54ActorState();
		static_cast<FlowTestCase54Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont8(Void && _,int loopDepth) 
	{
															#line 79 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (!static_cast<FlowTestCase54Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase54ActorState(); static_cast<FlowTestCase54Actor*>(this)->destroy(); return 0; }
															#line 1155 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		new (&static_cast<FlowTestCase54Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase54ActorState();
		static_cast<FlowTestCase54Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont7when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont7when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<FlowTestCase54Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase54Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase54Actor*>(this)->ActorCallback< FlowTestCase54Actor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase54Actor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase54", reinterpret_cast<unsigned long>(this), 7);
		a_exitChoose8();
		try {
			a_body1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase54", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< FlowTestCase54Actor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase54", reinterpret_cast<unsigned long>(this), 7);
		a_exitChoose8();
		try {
			a_body1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase54", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< FlowTestCase54Actor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase54", reinterpret_cast<unsigned long>(this), 7);
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase54", reinterpret_cast<unsigned long>(this), 7);

	}
															#line 54 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
	UnitTestParameters params;
															#line 55 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
	std::string filename;
															#line 56 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
	Reference<IAsyncFile> f;
															#line 68 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
	uint8_t* page;
															#line 1234 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase54()
															#line 54 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
class FlowTestCase54Actor final : public Actor<Void>, public ActorCallback< FlowTestCase54Actor, 0, Reference<IAsyncFile> >, public ActorCallback< FlowTestCase54Actor, 1, Void >, public ActorCallback< FlowTestCase54Actor, 2, Void >, public ActorCallback< FlowTestCase54Actor, 3, int64_t >, public ActorCallback< FlowTestCase54Actor, 4, Void >, public ActorCallback< FlowTestCase54Actor, 5, Void >, public ActorCallback< FlowTestCase54Actor, 6, int >, public ActorCallback< FlowTestCase54Actor, 7, Void >, public FastAllocated<FlowTestCase54Actor>, public FlowTestCase54ActorState<FlowTestCase54Actor> {
															#line 1239 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase54Actor>::operator new;
	using FastAllocated<FlowTestCase54Actor>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<Void>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase54Actor, 0, Reference<IAsyncFile> >;
friend struct ActorCallback< FlowTestCase54Actor, 1, Void >;
friend struct ActorCallback< FlowTestCase54Actor, 2, Void >;
friend struct ActorCallback< FlowTestCase54Actor, 3, int64_t >;
friend struct ActorCallback< FlowTestCase54Actor, 4, Void >;
friend struct ActorCallback< FlowTestCase54Actor, 5, Void >;
friend struct ActorCallback< FlowTestCase54Actor, 6, int >;
friend struct ActorCallback< FlowTestCase54Actor, 7, Void >;
															#line 54 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
	FlowTestCase54Actor(UnitTestParameters const& params) 
															#line 1257 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase54ActorState<FlowTestCase54Actor>(params)
	{
		fdb_probe_actor_enter("flowTestCase54", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase54");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase54", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase54Actor, 0, Reference<IAsyncFile> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< FlowTestCase54Actor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< FlowTestCase54Actor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< FlowTestCase54Actor, 3, int64_t >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< FlowTestCase54Actor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< FlowTestCase54Actor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< FlowTestCase54Actor, 6, int >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< FlowTestCase54Actor, 7, Void >*)0, actor_cancelled()); break;
		}

	}
};
}
															#line 54 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
static Future<Void> flowTestCase54( UnitTestParameters const& params ) {
															#line 54 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
	return Future<Void>(new FlowTestCase54Actor(params));
															#line 1292 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase54, "/fileio/zero")

#line 81 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"

															#line 1298 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
namespace {
// This generated class is to be used only via incrementalDeleteHelper()
															#line 82 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
template <class IncrementalDeleteHelperActor>
															#line 82 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
class IncrementalDeleteHelperActorState {
															#line 1305 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
public:
															#line 82 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
	IncrementalDeleteHelperActorState(std::string const& filename,bool const& mustBeDurable,int64_t const& truncateAmt,double const& interval) 
															#line 82 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
															#line 82 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		 : filename(filename),
															#line 82 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		   mustBeDurable(mustBeDurable),
															#line 82 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		   truncateAmt(truncateAmt),
															#line 82 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		   interval(interval),
															#line 86 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		   file(),
															#line 87 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		   remainingFileSize(),
															#line 88 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		   exists(fileExists(filename))
															#line 1324 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
	{
		fdb_probe_actor_create("incrementalDeleteHelper", reinterpret_cast<unsigned long>(this));

	}
	~IncrementalDeleteHelperActorState() 
	{
		fdb_probe_actor_destroy("incrementalDeleteHelper", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 90 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
			if (exists)
															#line 1339 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
			{
															#line 91 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
				StrictFuture<Reference<IAsyncFile>> __when_expr_0 = IAsyncFileSystem::filesystem()->open( filename, IAsyncFile::OPEN_READWRITE | IAsyncFile::OPEN_UNCACHED | IAsyncFile::OPEN_UNBUFFERED, 0);
															#line 91 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
				if (static_cast<IncrementalDeleteHelperActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1345 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<IncrementalDeleteHelperActor*>(this)->actor_wait_state = 1;
															#line 91 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< IncrementalDeleteHelperActor, 0, Reference<IAsyncFile> >*>(static_cast<IncrementalDeleteHelperActor*>(this)));
															#line 1350 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~IncrementalDeleteHelperActorState();
		static_cast<IncrementalDeleteHelperActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 99 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		StrictFuture<Void> __when_expr_2 = IAsyncFileSystem::filesystem()->deleteFile(filename, mustBeDurable);
															#line 99 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (static_cast<IncrementalDeleteHelperActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1380 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<IncrementalDeleteHelperActor*>(this)->actor_wait_state = 3;
															#line 99 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< IncrementalDeleteHelperActor, 2, Void >*>(static_cast<IncrementalDeleteHelperActor*>(this)));
															#line 1385 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Reference<IAsyncFile> const& f,int loopDepth) 
	{
															#line 93 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		file = f;
															#line 95 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		StrictFuture<int64_t> __when_expr_1 = file->size();
															#line 95 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (static_cast<IncrementalDeleteHelperActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1398 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<IncrementalDeleteHelperActor*>(this)->actor_wait_state = 2;
															#line 95 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< IncrementalDeleteHelperActor, 1, int64_t >*>(static_cast<IncrementalDeleteHelperActor*>(this)));
															#line 1403 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Reference<IAsyncFile> && f,int loopDepth) 
	{
															#line 93 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		file = f;
															#line 95 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		StrictFuture<int64_t> __when_expr_1 = file->size();
															#line 95 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (static_cast<IncrementalDeleteHelperActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1416 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<IncrementalDeleteHelperActor*>(this)->actor_wait_state = 2;
															#line 95 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< IncrementalDeleteHelperActor, 1, int64_t >*>(static_cast<IncrementalDeleteHelperActor*>(this)));
															#line 1421 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Reference<IAsyncFile> const& f,int loopDepth) 
	{
		loopDepth = a_body1cont2(f, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Reference<IAsyncFile> && f,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(f), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<IncrementalDeleteHelperActor*>(this)->actor_wait_state > 0) static_cast<IncrementalDeleteHelperActor*>(this)->actor_wait_state = 0;
		static_cast<IncrementalDeleteHelperActor*>(this)->ActorCallback< IncrementalDeleteHelperActor, 0, Reference<IAsyncFile> >::remove();

	}
	void a_callback_fire(ActorCallback< IncrementalDeleteHelperActor, 0, Reference<IAsyncFile> >*,Reference<IAsyncFile> const& value) 
	{
		fdb_probe_actor_enter("incrementalDeleteHelper", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incrementalDeleteHelper", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< IncrementalDeleteHelperActor, 0, Reference<IAsyncFile> >*,Reference<IAsyncFile> && value) 
	{
		fdb_probe_actor_enter("incrementalDeleteHelper", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incrementalDeleteHelper", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< IncrementalDeleteHelperActor, 0, Reference<IAsyncFile> >*,Error err) 
	{
		fdb_probe_actor_enter("incrementalDeleteHelper", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incrementalDeleteHelper", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int64_t const& fileSize,int loopDepth) 
	{
															#line 96 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		remainingFileSize = fileSize;
															#line 1493 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(int64_t && fileSize,int loopDepth) 
	{
															#line 96 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		remainingFileSize = fileSize;
															#line 1502 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(int64_t const& fileSize,int loopDepth) 
	{
		loopDepth = a_body1cont3(fileSize, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(int64_t && fileSize,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(fileSize), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<IncrementalDeleteHelperActor*>(this)->actor_wait_state > 0) static_cast<IncrementalDeleteHelperActor*>(this)->actor_wait_state = 0;
		static_cast<IncrementalDeleteHelperActor*>(this)->ActorCallback< IncrementalDeleteHelperActor, 1, int64_t >::remove();

	}
	void a_callback_fire(ActorCallback< IncrementalDeleteHelperActor, 1, int64_t >*,int64_t const& value) 
	{
		fdb_probe_actor_enter("incrementalDeleteHelper", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose2();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incrementalDeleteHelper", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< IncrementalDeleteHelperActor, 1, int64_t >*,int64_t && value) 
	{
		fdb_probe_actor_enter("incrementalDeleteHelper", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose2();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incrementalDeleteHelper", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< IncrementalDeleteHelperActor, 1, int64_t >*,Error err) 
	{
		fdb_probe_actor_enter("incrementalDeleteHelper", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incrementalDeleteHelper", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 101 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (exists)
															#line 1574 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		{
															#line 102 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
			;
															#line 1578 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
			loopDepth = a_body1cont5loopHead1(loopDepth);
		}
		else
		{
			loopDepth = a_body1cont6(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 101 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (exists)
															#line 1592 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		{
															#line 102 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
			;
															#line 1596 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
			loopDepth = a_body1cont5loopHead1(loopDepth);
		}
		else
		{
			loopDepth = a_body1cont6(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<IncrementalDeleteHelperActor*>(this)->actor_wait_state > 0) static_cast<IncrementalDeleteHelperActor*>(this)->actor_wait_state = 0;
		static_cast<IncrementalDeleteHelperActor*>(this)->ActorCallback< IncrementalDeleteHelperActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< IncrementalDeleteHelperActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("incrementalDeleteHelper", reinterpret_cast<unsigned long>(this), 2);
		a_exitChoose3();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incrementalDeleteHelper", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< IncrementalDeleteHelperActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("incrementalDeleteHelper", reinterpret_cast<unsigned long>(this), 2);
		a_exitChoose3();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incrementalDeleteHelper", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< IncrementalDeleteHelperActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("incrementalDeleteHelper", reinterpret_cast<unsigned long>(this), 2);
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incrementalDeleteHelper", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont6(int loopDepth) 
	{
															#line 109 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (!static_cast<IncrementalDeleteHelperActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~IncrementalDeleteHelperActorState(); static_cast<IncrementalDeleteHelperActor*>(this)->destroy(); return 0; }
															#line 1673 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		new (&static_cast<IncrementalDeleteHelperActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~IncrementalDeleteHelperActorState();
		static_cast<IncrementalDeleteHelperActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont7(int loopDepth) 
	{
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont5loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont5loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont5loopBody1(int loopDepth) 
	{
															#line 102 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (!(remainingFileSize > 0))
															#line 1698 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		{
			return a_body1cont5break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 103 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		StrictFuture<Void> __when_expr_3 = file->truncate(remainingFileSize);
															#line 103 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (static_cast<IncrementalDeleteHelperActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1706 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont5loopBody1when1(__when_expr_3.get(), loopDepth); };
		static_cast<IncrementalDeleteHelperActor*>(this)->actor_wait_state = 4;
															#line 103 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< IncrementalDeleteHelperActor, 3, Void >*>(static_cast<IncrementalDeleteHelperActor*>(this)));
															#line 1711 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5break1(int loopDepth) 
	{
		try {
			return a_body1cont7(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont5loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 104 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		StrictFuture<Void> __when_expr_4 = file->sync();
															#line 104 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (static_cast<IncrementalDeleteHelperActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1735 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont5loopBody1cont1when1(__when_expr_4.get(), loopDepth); };
		static_cast<IncrementalDeleteHelperActor*>(this)->actor_wait_state = 5;
															#line 104 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< IncrementalDeleteHelperActor, 4, Void >*>(static_cast<IncrementalDeleteHelperActor*>(this)));
															#line 1740 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 104 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		StrictFuture<Void> __when_expr_4 = file->sync();
															#line 104 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (static_cast<IncrementalDeleteHelperActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1751 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont5loopBody1cont1when1(__when_expr_4.get(), loopDepth); };
		static_cast<IncrementalDeleteHelperActor*>(this)->actor_wait_state = 5;
															#line 104 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< IncrementalDeleteHelperActor, 4, Void >*>(static_cast<IncrementalDeleteHelperActor*>(this)));
															#line 1756 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<IncrementalDeleteHelperActor*>(this)->actor_wait_state > 0) static_cast<IncrementalDeleteHelperActor*>(this)->actor_wait_state = 0;
		static_cast<IncrementalDeleteHelperActor*>(this)->ActorCallback< IncrementalDeleteHelperActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< IncrementalDeleteHelperActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("incrementalDeleteHelper", reinterpret_cast<unsigned long>(this), 3);
		a_exitChoose4();
		try {
			a_body1cont5loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incrementalDeleteHelper", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< IncrementalDeleteHelperActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("incrementalDeleteHelper", reinterpret_cast<unsigned long>(this), 3);
		a_exitChoose4();
		try {
			a_body1cont5loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incrementalDeleteHelper", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< IncrementalDeleteHelperActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("incrementalDeleteHelper", reinterpret_cast<unsigned long>(this), 3);
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incrementalDeleteHelper", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont5loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 105 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		StrictFuture<Void> __when_expr_5 = delay(interval);
															#line 105 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (static_cast<IncrementalDeleteHelperActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1830 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1cont5loopBody1cont3when1(__when_expr_5.get(), loopDepth); };
		static_cast<IncrementalDeleteHelperActor*>(this)->actor_wait_state = 6;
															#line 105 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< IncrementalDeleteHelperActor, 5, Void >*>(static_cast<IncrementalDeleteHelperActor*>(this)));
															#line 1835 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 105 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		StrictFuture<Void> __when_expr_5 = delay(interval);
															#line 105 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (static_cast<IncrementalDeleteHelperActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1846 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1cont5loopBody1cont3when1(__when_expr_5.get(), loopDepth); };
		static_cast<IncrementalDeleteHelperActor*>(this)->actor_wait_state = 6;
															#line 105 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< IncrementalDeleteHelperActor, 5, Void >*>(static_cast<IncrementalDeleteHelperActor*>(this)));
															#line 1851 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<IncrementalDeleteHelperActor*>(this)->actor_wait_state > 0) static_cast<IncrementalDeleteHelperActor*>(this)->actor_wait_state = 0;
		static_cast<IncrementalDeleteHelperActor*>(this)->ActorCallback< IncrementalDeleteHelperActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< IncrementalDeleteHelperActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("incrementalDeleteHelper", reinterpret_cast<unsigned long>(this), 4);
		a_exitChoose5();
		try {
			a_body1cont5loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incrementalDeleteHelper", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< IncrementalDeleteHelperActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("incrementalDeleteHelper", reinterpret_cast<unsigned long>(this), 4);
		a_exitChoose5();
		try {
			a_body1cont5loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incrementalDeleteHelper", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< IncrementalDeleteHelperActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("incrementalDeleteHelper", reinterpret_cast<unsigned long>(this), 4);
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incrementalDeleteHelper", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont5loopBody1cont4(Void const& _,int loopDepth) 
	{
															#line 102 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		remainingFileSize -= truncateAmt;
															#line 1923 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont5loopHead1(0);

		return loopDepth;
	}
	int a_body1cont5loopBody1cont4(Void && _,int loopDepth) 
	{
															#line 102 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		remainingFileSize -= truncateAmt;
															#line 1932 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont5loopHead1(0);

		return loopDepth;
	}
	int a_body1cont5loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<IncrementalDeleteHelperActor*>(this)->actor_wait_state > 0) static_cast<IncrementalDeleteHelperActor*>(this)->actor_wait_state = 0;
		static_cast<IncrementalDeleteHelperActor*>(this)->ActorCallback< IncrementalDeleteHelperActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< IncrementalDeleteHelperActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("incrementalDeleteHelper", reinterpret_cast<unsigned long>(this), 5);
		a_exitChoose6();
		try {
			a_body1cont5loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incrementalDeleteHelper", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< IncrementalDeleteHelperActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("incrementalDeleteHelper", reinterpret_cast<unsigned long>(this), 5);
		a_exitChoose6();
		try {
			a_body1cont5loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incrementalDeleteHelper", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< IncrementalDeleteHelperActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("incrementalDeleteHelper", reinterpret_cast<unsigned long>(this), 5);
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incrementalDeleteHelper", reinterpret_cast<unsigned long>(this), 5);

	}
															#line 82 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
	std::string filename;
															#line 82 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
	bool mustBeDurable;
															#line 82 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
	int64_t truncateAmt;
															#line 82 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
	double interval;
															#line 86 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
	Reference<IAsyncFile> file;
															#line 87 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
	int64_t remainingFileSize;
															#line 88 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
	bool exists;
															#line 2014 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
};
// This generated class is to be used only via incrementalDeleteHelper()
															#line 82 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
class IncrementalDeleteHelperActor final : public Actor<Void>, public ActorCallback< IncrementalDeleteHelperActor, 0, Reference<IAsyncFile> >, public ActorCallback< IncrementalDeleteHelperActor, 1, int64_t >, public ActorCallback< IncrementalDeleteHelperActor, 2, Void >, public ActorCallback< IncrementalDeleteHelperActor, 3, Void >, public ActorCallback< IncrementalDeleteHelperActor, 4, Void >, public ActorCallback< IncrementalDeleteHelperActor, 5, Void >, public FastAllocated<IncrementalDeleteHelperActor>, public IncrementalDeleteHelperActorState<IncrementalDeleteHelperActor> {
															#line 2019 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
public:
	using FastAllocated<IncrementalDeleteHelperActor>::operator new;
	using FastAllocated<IncrementalDeleteHelperActor>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<Void>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
friend struct ActorCallback< IncrementalDeleteHelperActor, 0, Reference<IAsyncFile> >;
friend struct ActorCallback< IncrementalDeleteHelperActor, 1, int64_t >;
friend struct ActorCallback< IncrementalDeleteHelperActor, 2, Void >;
friend struct ActorCallback< IncrementalDeleteHelperActor, 3, Void >;
friend struct ActorCallback< IncrementalDeleteHelperActor, 4, Void >;
friend struct ActorCallback< IncrementalDeleteHelperActor, 5, Void >;
															#line 82 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
	IncrementalDeleteHelperActor(std::string const& filename,bool const& mustBeDurable,int64_t const& truncateAmt,double const& interval) 
															#line 2035 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		 : Actor<Void>(),
		   IncrementalDeleteHelperActorState<IncrementalDeleteHelperActor>(filename, mustBeDurable, truncateAmt, interval)
	{
		fdb_probe_actor_enter("incrementalDeleteHelper", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("incrementalDeleteHelper");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("incrementalDeleteHelper", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< IncrementalDeleteHelperActor, 0, Reference<IAsyncFile> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< IncrementalDeleteHelperActor, 1, int64_t >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< IncrementalDeleteHelperActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< IncrementalDeleteHelperActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< IncrementalDeleteHelperActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< IncrementalDeleteHelperActor, 5, Void >*)0, actor_cancelled()); break;
		}

	}
};
}
															#line 82 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
[[nodiscard]] static Future<Void> incrementalDeleteHelper( std::string const& filename, bool const& mustBeDurable, int64_t const& truncateAmt, double const& interval ) {
															#line 82 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
	return Future<Void>(new IncrementalDeleteHelperActor(filename, mustBeDurable, truncateAmt, interval));
															#line 2068 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
}

#line 111 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"

Future<Void> IAsyncFileSystem::incrementalDeleteFile(const std::string& filename, bool mustBeDurable) {
	return uncancellable(incrementalDeleteHelper(filename,
	                                             mustBeDurable,
	                                             FLOW_KNOBS->INCREMENTAL_DELETE_TRUNCATE_AMOUNT,
	                                             FLOW_KNOBS->INCREMENTAL_DELETE_INTERVAL));
}

															#line 2080 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase119()
															#line 119 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
template <class FlowTestCase119Actor>
															#line 119 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
class FlowTestCase119ActorState {
															#line 2087 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
public:
															#line 119 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
	FlowTestCase119ActorState(UnitTestParameters const& params) 
															#line 119 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
															#line 119 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		 : params(params),
															#line 121 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		   fileSize(5e9),
															#line 122 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		   filename("/tmp/__JUNK__")
															#line 2098 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase119", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase119ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase119", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 123 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
			StrictFuture<Reference<IAsyncFile>> __when_expr_0 = IAsyncFileSystem::filesystem()->open( filename, IAsyncFile::OPEN_ATOMIC_WRITE_AND_CREATE | IAsyncFile::OPEN_CREATE | IAsyncFile::OPEN_READWRITE, 0);
															#line 123 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
			if (static_cast<FlowTestCase119Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2115 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase119Actor*>(this)->actor_wait_state = 1;
															#line 123 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase119Actor, 0, Reference<IAsyncFile> >*>(static_cast<FlowTestCase119Actor*>(this)));
															#line 2120 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase119ActorState();
		static_cast<FlowTestCase119Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 125 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		StrictFuture<Void> __when_expr_1 = f->sync();
															#line 125 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (static_cast<FlowTestCase119Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2145 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<FlowTestCase119Actor*>(this)->actor_wait_state = 2;
															#line 125 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase119Actor, 1, Void >*>(static_cast<FlowTestCase119Actor*>(this)));
															#line 2150 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Reference<IAsyncFile> const& __f,int loopDepth) 
	{
															#line 123 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		f = __f;
															#line 2159 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Reference<IAsyncFile> && __f,int loopDepth) 
	{
		f = std::move(__f);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase119Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase119Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase119Actor*>(this)->ActorCallback< FlowTestCase119Actor, 0, Reference<IAsyncFile> >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase119Actor, 0, Reference<IAsyncFile> >*,Reference<IAsyncFile> const& value) 
	{
		fdb_probe_actor_enter("flowTestCase119", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase119", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase119Actor, 0, Reference<IAsyncFile> >*,Reference<IAsyncFile> && value) 
	{
		fdb_probe_actor_enter("flowTestCase119", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase119", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase119Actor, 0, Reference<IAsyncFile> >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase119", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase119", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 126 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		StrictFuture<Void> __when_expr_2 = f->truncate(fileSize);
															#line 126 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (static_cast<FlowTestCase119Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2228 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<FlowTestCase119Actor*>(this)->actor_wait_state = 3;
															#line 126 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase119Actor, 2, Void >*>(static_cast<FlowTestCase119Actor*>(this)));
															#line 2233 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 126 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		StrictFuture<Void> __when_expr_2 = f->truncate(fileSize);
															#line 126 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (static_cast<FlowTestCase119Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2244 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<FlowTestCase119Actor*>(this)->actor_wait_state = 3;
															#line 126 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase119Actor, 2, Void >*>(static_cast<FlowTestCase119Actor*>(this)));
															#line 2249 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<FlowTestCase119Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase119Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase119Actor*>(this)->ActorCallback< FlowTestCase119Actor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase119Actor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase119", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase119", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FlowTestCase119Actor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase119", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase119", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FlowTestCase119Actor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase119", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase119", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 128 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		f.clear();
															#line 129 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		StrictFuture<Void> __when_expr_3 = IAsyncFileSystem::filesystem()->incrementalDeleteFile(filename, true);
															#line 129 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (static_cast<FlowTestCase119Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2325 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<FlowTestCase119Actor*>(this)->actor_wait_state = 4;
															#line 129 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase119Actor, 3, Void >*>(static_cast<FlowTestCase119Actor*>(this)));
															#line 2330 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 128 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		f.clear();
															#line 129 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		StrictFuture<Void> __when_expr_3 = IAsyncFileSystem::filesystem()->incrementalDeleteFile(filename, true);
															#line 129 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (static_cast<FlowTestCase119Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2343 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<FlowTestCase119Actor*>(this)->actor_wait_state = 4;
															#line 129 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase119Actor, 3, Void >*>(static_cast<FlowTestCase119Actor*>(this)));
															#line 2348 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<FlowTestCase119Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase119Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase119Actor*>(this)->ActorCallback< FlowTestCase119Actor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase119Actor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase119", reinterpret_cast<unsigned long>(this), 2);
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase119", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< FlowTestCase119Actor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase119", reinterpret_cast<unsigned long>(this), 2);
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase119", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< FlowTestCase119Actor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase119", reinterpret_cast<unsigned long>(this), 2);
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase119", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 130 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (!static_cast<FlowTestCase119Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase119ActorState(); static_cast<FlowTestCase119Actor*>(this)->destroy(); return 0; }
															#line 2420 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		new (&static_cast<FlowTestCase119Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase119ActorState();
		static_cast<FlowTestCase119Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 130 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (!static_cast<FlowTestCase119Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase119ActorState(); static_cast<FlowTestCase119Actor*>(this)->destroy(); return 0; }
															#line 2432 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		new (&static_cast<FlowTestCase119Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase119ActorState();
		static_cast<FlowTestCase119Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<FlowTestCase119Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase119Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase119Actor*>(this)->ActorCallback< FlowTestCase119Actor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase119Actor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase119", reinterpret_cast<unsigned long>(this), 3);
		a_exitChoose4();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase119", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< FlowTestCase119Actor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase119", reinterpret_cast<unsigned long>(this), 3);
		a_exitChoose4();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase119", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< FlowTestCase119Actor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase119", reinterpret_cast<unsigned long>(this), 3);
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase119", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 119 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
	UnitTestParameters params;
															#line 121 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
	int64_t fileSize;
															#line 122 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
	std::string filename;
															#line 123 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
	Reference<IAsyncFile> f;
															#line 2511 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase119()
															#line 119 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
class FlowTestCase119Actor final : public Actor<Void>, public ActorCallback< FlowTestCase119Actor, 0, Reference<IAsyncFile> >, public ActorCallback< FlowTestCase119Actor, 1, Void >, public ActorCallback< FlowTestCase119Actor, 2, Void >, public ActorCallback< FlowTestCase119Actor, 3, Void >, public FastAllocated<FlowTestCase119Actor>, public FlowTestCase119ActorState<FlowTestCase119Actor> {
															#line 2516 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase119Actor>::operator new;
	using FastAllocated<FlowTestCase119Actor>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<Void>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase119Actor, 0, Reference<IAsyncFile> >;
friend struct ActorCallback< FlowTestCase119Actor, 1, Void >;
friend struct ActorCallback< FlowTestCase119Actor, 2, Void >;
friend struct ActorCallback< FlowTestCase119Actor, 3, Void >;
															#line 119 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
	FlowTestCase119Actor(UnitTestParameters const& params) 
															#line 2530 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase119ActorState<FlowTestCase119Actor>(params)
	{
		fdb_probe_actor_enter("flowTestCase119", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase119");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase119", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase119Actor, 0, Reference<IAsyncFile> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< FlowTestCase119Actor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< FlowTestCase119Actor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< FlowTestCase119Actor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
}
															#line 119 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
static Future<Void> flowTestCase119( UnitTestParameters const& params ) {
															#line 119 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
	return Future<Void>(new FlowTestCase119Actor(params));
															#line 2561 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase119, "/fileio/incrementalDelete")

#line 132 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"

															#line 2567 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase133()
															#line 133 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
template <class FlowTestCase133Actor>
															#line 133 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
class FlowTestCase133ActorState {
															#line 2574 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
public:
															#line 133 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
	FlowTestCase133ActorState(UnitTestParameters const& params) 
															#line 133 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
															#line 133 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		 : params(params),
															#line 135 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		   fileSize(100e6),
															#line 136 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		   filename("/tmp/__JUNK__." + deterministicRandom()->randomUniqueID().toString()),
															#line 137 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		   renamedFile("/tmp/__RENAMED_JUNK__." + deterministicRandom()->randomUniqueID().toString()),
															#line 138 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		   data(new char[4096]),
															#line 139 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		   readData(new char[4096])
															#line 2591 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase133", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase133ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase133", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 140 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
			StrictFuture<Reference<IAsyncFile>> __when_expr_0 = IAsyncFileSystem::filesystem()->open( filename, IAsyncFile::OPEN_ATOMIC_WRITE_AND_CREATE | IAsyncFile::OPEN_CREATE | IAsyncFile::OPEN_READWRITE, 0644);
															#line 140 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
			if (static_cast<FlowTestCase133Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2608 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase133Actor*>(this)->actor_wait_state = 1;
															#line 140 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase133Actor, 0, Reference<IAsyncFile> >*>(static_cast<FlowTestCase133Actor*>(this)));
															#line 2613 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase133ActorState();
		static_cast<FlowTestCase133Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 145 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		StrictFuture<Void> __when_expr_1 = f->sync();
															#line 145 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (static_cast<FlowTestCase133Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2638 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<FlowTestCase133Actor*>(this)->actor_wait_state = 2;
															#line 145 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase133Actor, 1, Void >*>(static_cast<FlowTestCase133Actor*>(this)));
															#line 2643 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Reference<IAsyncFile> const& __f,int loopDepth) 
	{
															#line 140 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		f = __f;
															#line 2652 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Reference<IAsyncFile> && __f,int loopDepth) 
	{
		f = std::move(__f);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase133Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase133Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase133Actor*>(this)->ActorCallback< FlowTestCase133Actor, 0, Reference<IAsyncFile> >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase133Actor, 0, Reference<IAsyncFile> >*,Reference<IAsyncFile> const& value) 
	{
		fdb_probe_actor_enter("flowTestCase133", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase133", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase133Actor, 0, Reference<IAsyncFile> >*,Reference<IAsyncFile> && value) 
	{
		fdb_probe_actor_enter("flowTestCase133", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase133", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase133Actor, 0, Reference<IAsyncFile> >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase133", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase133", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 146 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		StrictFuture<Void> __when_expr_2 = f->truncate(fileSize);
															#line 146 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (static_cast<FlowTestCase133Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2721 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<FlowTestCase133Actor*>(this)->actor_wait_state = 3;
															#line 146 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase133Actor, 2, Void >*>(static_cast<FlowTestCase133Actor*>(this)));
															#line 2726 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 146 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		StrictFuture<Void> __when_expr_2 = f->truncate(fileSize);
															#line 146 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (static_cast<FlowTestCase133Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2737 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<FlowTestCase133Actor*>(this)->actor_wait_state = 3;
															#line 146 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase133Actor, 2, Void >*>(static_cast<FlowTestCase133Actor*>(this)));
															#line 2742 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<FlowTestCase133Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase133Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase133Actor*>(this)->ActorCallback< FlowTestCase133Actor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase133Actor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase133", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase133", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FlowTestCase133Actor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase133", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase133", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FlowTestCase133Actor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase133", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase133", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 147 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		memset(data.get(), 0, 4096);
															#line 149 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		for(int i = 0;i < 16;++i) {
															#line 150 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
			data[i] = deterministicRandom()->randomAlphaNumeric();
															#line 2818 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		}
															#line 153 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		StrictFuture<Void> __when_expr_3 = f->write(data.get(), 4096, 0);
															#line 153 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (static_cast<FlowTestCase133Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2824 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<FlowTestCase133Actor*>(this)->actor_wait_state = 4;
															#line 153 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase133Actor, 3, Void >*>(static_cast<FlowTestCase133Actor*>(this)));
															#line 2829 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 147 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		memset(data.get(), 0, 4096);
															#line 149 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		for(int i = 0;i < 16;++i) {
															#line 150 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
			data[i] = deterministicRandom()->randomAlphaNumeric();
															#line 2842 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		}
															#line 153 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		StrictFuture<Void> __when_expr_3 = f->write(data.get(), 4096, 0);
															#line 153 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (static_cast<FlowTestCase133Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2848 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<FlowTestCase133Actor*>(this)->actor_wait_state = 4;
															#line 153 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase133Actor, 3, Void >*>(static_cast<FlowTestCase133Actor*>(this)));
															#line 2853 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<FlowTestCase133Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase133Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase133Actor*>(this)->ActorCallback< FlowTestCase133Actor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase133Actor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase133", reinterpret_cast<unsigned long>(this), 2);
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase133", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< FlowTestCase133Actor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase133", reinterpret_cast<unsigned long>(this), 2);
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase133", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< FlowTestCase133Actor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase133", reinterpret_cast<unsigned long>(this), 2);
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase133", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 154 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		StrictFuture<Void> __when_expr_4 = f->write(data.get(), 4096, fileSize - 4096);
															#line 154 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (static_cast<FlowTestCase133Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2927 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<FlowTestCase133Actor*>(this)->actor_wait_state = 5;
															#line 154 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase133Actor, 4, Void >*>(static_cast<FlowTestCase133Actor*>(this)));
															#line 2932 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 154 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		StrictFuture<Void> __when_expr_4 = f->write(data.get(), 4096, fileSize - 4096);
															#line 154 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (static_cast<FlowTestCase133Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2943 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<FlowTestCase133Actor*>(this)->actor_wait_state = 5;
															#line 154 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase133Actor, 4, Void >*>(static_cast<FlowTestCase133Actor*>(this)));
															#line 2948 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<FlowTestCase133Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase133Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase133Actor*>(this)->ActorCallback< FlowTestCase133Actor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase133Actor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase133", reinterpret_cast<unsigned long>(this), 3);
		a_exitChoose4();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase133", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< FlowTestCase133Actor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase133", reinterpret_cast<unsigned long>(this), 3);
		a_exitChoose4();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase133", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< FlowTestCase133Actor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase133", reinterpret_cast<unsigned long>(this), 3);
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase133", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 155 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		StrictFuture<Void> __when_expr_5 = f->sync();
															#line 155 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (static_cast<FlowTestCase133Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3022 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont6when1(__when_expr_5.get(), loopDepth); };
		static_cast<FlowTestCase133Actor*>(this)->actor_wait_state = 6;
															#line 155 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase133Actor, 5, Void >*>(static_cast<FlowTestCase133Actor*>(this)));
															#line 3027 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 155 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		StrictFuture<Void> __when_expr_5 = f->sync();
															#line 155 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (static_cast<FlowTestCase133Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3038 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont6when1(__when_expr_5.get(), loopDepth); };
		static_cast<FlowTestCase133Actor*>(this)->actor_wait_state = 6;
															#line 155 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase133Actor, 5, Void >*>(static_cast<FlowTestCase133Actor*>(this)));
															#line 3043 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<FlowTestCase133Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase133Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase133Actor*>(this)->ActorCallback< FlowTestCase133Actor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase133Actor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase133", reinterpret_cast<unsigned long>(this), 4);
		a_exitChoose5();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase133", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< FlowTestCase133Actor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase133", reinterpret_cast<unsigned long>(this), 4);
		a_exitChoose5();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase133", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< FlowTestCase133Actor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase133", reinterpret_cast<unsigned long>(this), 4);
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase133", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont7(Void const& _,int loopDepth) 
	{
															#line 157 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		f.clear();
															#line 158 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		StrictFuture<Void> __when_expr_6 = IAsyncFileSystem::filesystem()->renameFile(filename, renamedFile);
															#line 158 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (static_cast<FlowTestCase133Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3119 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont7when1(__when_expr_6.get(), loopDepth); };
		static_cast<FlowTestCase133Actor*>(this)->actor_wait_state = 7;
															#line 158 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase133Actor, 6, Void >*>(static_cast<FlowTestCase133Actor*>(this)));
															#line 3124 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7(Void && _,int loopDepth) 
	{
															#line 157 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		f.clear();
															#line 158 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		StrictFuture<Void> __when_expr_6 = IAsyncFileSystem::filesystem()->renameFile(filename, renamedFile);
															#line 158 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (static_cast<FlowTestCase133Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3137 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont7when1(__when_expr_6.get(), loopDepth); };
		static_cast<FlowTestCase133Actor*>(this)->actor_wait_state = 7;
															#line 158 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase133Actor, 6, Void >*>(static_cast<FlowTestCase133Actor*>(this)));
															#line 3142 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<FlowTestCase133Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase133Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase133Actor*>(this)->ActorCallback< FlowTestCase133Actor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase133Actor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase133", reinterpret_cast<unsigned long>(this), 5);
		a_exitChoose6();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase133", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< FlowTestCase133Actor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase133", reinterpret_cast<unsigned long>(this), 5);
		a_exitChoose6();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase133", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< FlowTestCase133Actor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase133", reinterpret_cast<unsigned long>(this), 5);
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase133", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont8(Void const& _,int loopDepth) 
	{
															#line 159 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		StrictFuture<Reference<IAsyncFile>> __when_expr_7 = IAsyncFileSystem::filesystem()->open(renamedFile, IAsyncFile::OPEN_READONLY, 0);
															#line 159 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (static_cast<FlowTestCase133Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3216 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont8when1(__when_expr_7.get(), loopDepth); };
		static_cast<FlowTestCase133Actor*>(this)->actor_wait_state = 8;
															#line 159 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase133Actor, 7, Reference<IAsyncFile> >*>(static_cast<FlowTestCase133Actor*>(this)));
															#line 3221 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont8(Void && _,int loopDepth) 
	{
															#line 159 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		StrictFuture<Reference<IAsyncFile>> __when_expr_7 = IAsyncFileSystem::filesystem()->open(renamedFile, IAsyncFile::OPEN_READONLY, 0);
															#line 159 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (static_cast<FlowTestCase133Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3232 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont8when1(__when_expr_7.get(), loopDepth); };
		static_cast<FlowTestCase133Actor*>(this)->actor_wait_state = 8;
															#line 159 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase133Actor, 7, Reference<IAsyncFile> >*>(static_cast<FlowTestCase133Actor*>(this)));
															#line 3237 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont7when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<FlowTestCase133Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase133Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase133Actor*>(this)->ActorCallback< FlowTestCase133Actor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase133Actor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase133", reinterpret_cast<unsigned long>(this), 6);
		a_exitChoose7();
		try {
			a_body1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase133", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< FlowTestCase133Actor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase133", reinterpret_cast<unsigned long>(this), 6);
		a_exitChoose7();
		try {
			a_body1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase133", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< FlowTestCase133Actor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase133", reinterpret_cast<unsigned long>(this), 6);
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase133", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont9(Reference<IAsyncFile> const& _f,int loopDepth) 
	{
															#line 160 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		f = _f;
															#line 163 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		bool renamedExists = false;
															#line 164 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		auto bName = basename(renamedFile);
															#line 165 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		auto files = platform::listFiles("/tmp/");
															#line 166 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		for( const auto& file : files ) {
															#line 167 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
			if (file == bName)
															#line 3319 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
			{
															#line 168 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
				renamedExists = true;
															#line 3323 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
			}
															#line 170 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
			ASSERT(file != filename);
															#line 3327 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		}
															#line 172 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		ASSERT(renamedExists);
															#line 175 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		StrictFuture<int> __when_expr_8 = f->read(readData.get(), 4096, 0);
															#line 175 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (static_cast<FlowTestCase133Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3335 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont9when1(__when_expr_8.get(), loopDepth); };
		static_cast<FlowTestCase133Actor*>(this)->actor_wait_state = 9;
															#line 175 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase133Actor, 8, int >*>(static_cast<FlowTestCase133Actor*>(this)));
															#line 3340 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont9(Reference<IAsyncFile> && _f,int loopDepth) 
	{
															#line 160 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		f = _f;
															#line 163 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		bool renamedExists = false;
															#line 164 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		auto bName = basename(renamedFile);
															#line 165 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		auto files = platform::listFiles("/tmp/");
															#line 166 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		for( const auto& file : files ) {
															#line 167 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
			if (file == bName)
															#line 3359 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
			{
															#line 168 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
				renamedExists = true;
															#line 3363 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
			}
															#line 170 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
			ASSERT(file != filename);
															#line 3367 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		}
															#line 172 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		ASSERT(renamedExists);
															#line 175 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		StrictFuture<int> __when_expr_8 = f->read(readData.get(), 4096, 0);
															#line 175 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (static_cast<FlowTestCase133Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3375 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont9when1(__when_expr_8.get(), loopDepth); };
		static_cast<FlowTestCase133Actor*>(this)->actor_wait_state = 9;
															#line 175 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase133Actor, 8, int >*>(static_cast<FlowTestCase133Actor*>(this)));
															#line 3380 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont8when1(Reference<IAsyncFile> const& _f,int loopDepth) 
	{
		loopDepth = a_body1cont9(_f, loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(Reference<IAsyncFile> && _f,int loopDepth) 
	{
		loopDepth = a_body1cont9(std::move(_f), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<FlowTestCase133Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase133Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase133Actor*>(this)->ActorCallback< FlowTestCase133Actor, 7, Reference<IAsyncFile> >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase133Actor, 7, Reference<IAsyncFile> >*,Reference<IAsyncFile> const& value) 
	{
		fdb_probe_actor_enter("flowTestCase133", reinterpret_cast<unsigned long>(this), 7);
		a_exitChoose8();
		try {
			a_body1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase133", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< FlowTestCase133Actor, 7, Reference<IAsyncFile> >*,Reference<IAsyncFile> && value) 
	{
		fdb_probe_actor_enter("flowTestCase133", reinterpret_cast<unsigned long>(this), 7);
		a_exitChoose8();
		try {
			a_body1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase133", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< FlowTestCase133Actor, 7, Reference<IAsyncFile> >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase133", reinterpret_cast<unsigned long>(this), 7);
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase133", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont10(int const& length,int loopDepth) 
	{
															#line 176 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		ASSERT(length == 4096);
															#line 177 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		ASSERT(memcmp(readData.get(), data.get(), 4096) == 0);
															#line 179 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		f.clear();
															#line 182 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		StrictFuture<Void> __when_expr_9 = IAsyncFileSystem::filesystem()->deleteFile(renamedFile, true);
															#line 182 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (static_cast<FlowTestCase133Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3460 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont10when1(__when_expr_9.get(), loopDepth); };
		static_cast<FlowTestCase133Actor*>(this)->actor_wait_state = 10;
															#line 182 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase133Actor, 9, Void >*>(static_cast<FlowTestCase133Actor*>(this)));
															#line 3465 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10(int && length,int loopDepth) 
	{
															#line 176 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		ASSERT(length == 4096);
															#line 177 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		ASSERT(memcmp(readData.get(), data.get(), 4096) == 0);
															#line 179 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		f.clear();
															#line 182 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		StrictFuture<Void> __when_expr_9 = IAsyncFileSystem::filesystem()->deleteFile(renamedFile, true);
															#line 182 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (static_cast<FlowTestCase133Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3482 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont10when1(__when_expr_9.get(), loopDepth); };
		static_cast<FlowTestCase133Actor*>(this)->actor_wait_state = 10;
															#line 182 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase133Actor, 9, Void >*>(static_cast<FlowTestCase133Actor*>(this)));
															#line 3487 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont9when1(int const& length,int loopDepth) 
	{
		loopDepth = a_body1cont10(length, loopDepth);

		return loopDepth;
	}
	int a_body1cont9when1(int && length,int loopDepth) 
	{
		loopDepth = a_body1cont10(std::move(length), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<FlowTestCase133Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase133Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase133Actor*>(this)->ActorCallback< FlowTestCase133Actor, 8, int >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase133Actor, 8, int >*,int const& value) 
	{
		fdb_probe_actor_enter("flowTestCase133", reinterpret_cast<unsigned long>(this), 8);
		a_exitChoose9();
		try {
			a_body1cont9when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase133", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< FlowTestCase133Actor, 8, int >*,int && value) 
	{
		fdb_probe_actor_enter("flowTestCase133", reinterpret_cast<unsigned long>(this), 8);
		a_exitChoose9();
		try {
			a_body1cont9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase133", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< FlowTestCase133Actor, 8, int >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase133", reinterpret_cast<unsigned long>(this), 8);
		a_exitChoose9();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase133", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont10cont1(Void const& _,int loopDepth) 
	{
															#line 183 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (!static_cast<FlowTestCase133Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase133ActorState(); static_cast<FlowTestCase133Actor*>(this)->destroy(); return 0; }
															#line 3559 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		new (&static_cast<FlowTestCase133Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase133ActorState();
		static_cast<FlowTestCase133Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont10cont1(Void && _,int loopDepth) 
	{
															#line 183 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (!static_cast<FlowTestCase133Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase133ActorState(); static_cast<FlowTestCase133Actor*>(this)->destroy(); return 0; }
															#line 3571 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		new (&static_cast<FlowTestCase133Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase133ActorState();
		static_cast<FlowTestCase133Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont10when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<FlowTestCase133Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase133Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase133Actor*>(this)->ActorCallback< FlowTestCase133Actor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase133Actor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase133", reinterpret_cast<unsigned long>(this), 9);
		a_exitChoose10();
		try {
			a_body1cont10when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase133", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< FlowTestCase133Actor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase133", reinterpret_cast<unsigned long>(this), 9);
		a_exitChoose10();
		try {
			a_body1cont10when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase133", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< FlowTestCase133Actor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase133", reinterpret_cast<unsigned long>(this), 9);
		a_exitChoose10();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase133", reinterpret_cast<unsigned long>(this), 9);

	}
															#line 133 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
	UnitTestParameters params;
															#line 135 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
	int64_t fileSize;
															#line 136 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
	std::string filename;
															#line 137 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
	std::string renamedFile;
															#line 138 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
	std::unique_ptr<char[]> data;
															#line 139 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
	std::unique_ptr<char[]> readData;
															#line 140 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
	Reference<IAsyncFile> f;
															#line 3656 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase133()
															#line 133 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
class FlowTestCase133Actor final : public Actor<Void>, public ActorCallback< FlowTestCase133Actor, 0, Reference<IAsyncFile> >, public ActorCallback< FlowTestCase133Actor, 1, Void >, public ActorCallback< FlowTestCase133Actor, 2, Void >, public ActorCallback< FlowTestCase133Actor, 3, Void >, public ActorCallback< FlowTestCase133Actor, 4, Void >, public ActorCallback< FlowTestCase133Actor, 5, Void >, public ActorCallback< FlowTestCase133Actor, 6, Void >, public ActorCallback< FlowTestCase133Actor, 7, Reference<IAsyncFile> >, public ActorCallback< FlowTestCase133Actor, 8, int >, public ActorCallback< FlowTestCase133Actor, 9, Void >, public FastAllocated<FlowTestCase133Actor>, public FlowTestCase133ActorState<FlowTestCase133Actor> {
															#line 3661 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase133Actor>::operator new;
	using FastAllocated<FlowTestCase133Actor>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<Void>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase133Actor, 0, Reference<IAsyncFile> >;
friend struct ActorCallback< FlowTestCase133Actor, 1, Void >;
friend struct ActorCallback< FlowTestCase133Actor, 2, Void >;
friend struct ActorCallback< FlowTestCase133Actor, 3, Void >;
friend struct ActorCallback< FlowTestCase133Actor, 4, Void >;
friend struct ActorCallback< FlowTestCase133Actor, 5, Void >;
friend struct ActorCallback< FlowTestCase133Actor, 6, Void >;
friend struct ActorCallback< FlowTestCase133Actor, 7, Reference<IAsyncFile> >;
friend struct ActorCallback< FlowTestCase133Actor, 8, int >;
friend struct ActorCallback< FlowTestCase133Actor, 9, Void >;
															#line 133 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
	FlowTestCase133Actor(UnitTestParameters const& params) 
															#line 3681 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase133ActorState<FlowTestCase133Actor>(params)
	{
		fdb_probe_actor_enter("flowTestCase133", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase133");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase133", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase133Actor, 0, Reference<IAsyncFile> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< FlowTestCase133Actor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< FlowTestCase133Actor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< FlowTestCase133Actor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< FlowTestCase133Actor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< FlowTestCase133Actor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< FlowTestCase133Actor, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< FlowTestCase133Actor, 7, Reference<IAsyncFile> >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< FlowTestCase133Actor, 8, int >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< FlowTestCase133Actor, 9, Void >*)0, actor_cancelled()); break;
		}

	}
};
}
															#line 133 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
static Future<Void> flowTestCase133( UnitTestParameters const& params ) {
															#line 133 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
	return Future<Void>(new FlowTestCase133Actor(params));
															#line 3718 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase133, "/fileio/rename")

#line 185 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"

// Truncating to extend size should zero the new data
															#line 3725 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase187()
															#line 187 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
template <class FlowTestCase187Actor>
															#line 187 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
class FlowTestCase187ActorState {
															#line 3732 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
public:
															#line 187 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
	FlowTestCase187ActorState(UnitTestParameters const& params) 
															#line 187 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
															#line 187 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		 : params(params),
															#line 188 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		   filename("/tmp/__JUNK__")
															#line 3741 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase187", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase187ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase187", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 189 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
			StrictFuture<Reference<IAsyncFile>> __when_expr_0 = IAsyncFileSystem::filesystem()->open( filename, IAsyncFile::OPEN_ATOMIC_WRITE_AND_CREATE | IAsyncFile::OPEN_CREATE | IAsyncFile::OPEN_READWRITE, 0);
															#line 189 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
			if (static_cast<FlowTestCase187Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3758 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase187Actor*>(this)->actor_wait_state = 1;
															#line 189 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase187Actor, 0, Reference<IAsyncFile> >*>(static_cast<FlowTestCase187Actor*>(this)));
															#line 3763 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase187ActorState();
		static_cast<FlowTestCase187Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 191 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		data = std::array<char, 4096>();
															#line 192 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		StrictFuture<Void> __when_expr_1 = f->sync();
															#line 192 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (static_cast<FlowTestCase187Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3790 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<FlowTestCase187Actor*>(this)->actor_wait_state = 2;
															#line 192 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase187Actor, 1, Void >*>(static_cast<FlowTestCase187Actor*>(this)));
															#line 3795 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Reference<IAsyncFile> const& __f,int loopDepth) 
	{
															#line 189 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		f = __f;
															#line 3804 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Reference<IAsyncFile> && __f,int loopDepth) 
	{
		f = std::move(__f);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase187Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase187Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase187Actor*>(this)->ActorCallback< FlowTestCase187Actor, 0, Reference<IAsyncFile> >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase187Actor, 0, Reference<IAsyncFile> >*,Reference<IAsyncFile> const& value) 
	{
		fdb_probe_actor_enter("flowTestCase187", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase187", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase187Actor, 0, Reference<IAsyncFile> >*,Reference<IAsyncFile> && value) 
	{
		fdb_probe_actor_enter("flowTestCase187", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase187", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase187Actor, 0, Reference<IAsyncFile> >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase187", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase187", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 193 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		StrictFuture<Void> __when_expr_2 = f->truncate(4096);
															#line 193 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (static_cast<FlowTestCase187Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3873 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<FlowTestCase187Actor*>(this)->actor_wait_state = 3;
															#line 193 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase187Actor, 2, Void >*>(static_cast<FlowTestCase187Actor*>(this)));
															#line 3878 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 193 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		StrictFuture<Void> __when_expr_2 = f->truncate(4096);
															#line 193 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (static_cast<FlowTestCase187Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3889 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<FlowTestCase187Actor*>(this)->actor_wait_state = 3;
															#line 193 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase187Actor, 2, Void >*>(static_cast<FlowTestCase187Actor*>(this)));
															#line 3894 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<FlowTestCase187Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase187Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase187Actor*>(this)->ActorCallback< FlowTestCase187Actor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase187Actor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase187", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase187", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FlowTestCase187Actor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase187", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase187", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FlowTestCase187Actor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase187", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase187", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 194 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		StrictFuture<int> __when_expr_3 = f->read(&data[0], 4096, 0);
															#line 194 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (static_cast<FlowTestCase187Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3968 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<FlowTestCase187Actor*>(this)->actor_wait_state = 4;
															#line 194 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase187Actor, 3, int >*>(static_cast<FlowTestCase187Actor*>(this)));
															#line 3973 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 194 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		StrictFuture<int> __when_expr_3 = f->read(&data[0], 4096, 0);
															#line 194 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (static_cast<FlowTestCase187Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3984 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<FlowTestCase187Actor*>(this)->actor_wait_state = 4;
															#line 194 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase187Actor, 3, int >*>(static_cast<FlowTestCase187Actor*>(this)));
															#line 3989 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<FlowTestCase187Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase187Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase187Actor*>(this)->ActorCallback< FlowTestCase187Actor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase187Actor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase187", reinterpret_cast<unsigned long>(this), 2);
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase187", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< FlowTestCase187Actor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase187", reinterpret_cast<unsigned long>(this), 2);
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase187", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< FlowTestCase187Actor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase187", reinterpret_cast<unsigned long>(this), 2);
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase187", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont4(int const& length,int loopDepth) 
	{
															#line 195 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		ASSERT(length == 4096);
															#line 196 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		for( auto c : data ) {
															#line 197 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
			ASSERT(c == '\0');
															#line 4065 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		}
															#line 200 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		f.clear();
															#line 201 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		StrictFuture<Void> __when_expr_4 = IAsyncFileSystem::filesystem()->incrementalDeleteFile(filename, true);
															#line 201 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (static_cast<FlowTestCase187Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4073 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<FlowTestCase187Actor*>(this)->actor_wait_state = 5;
															#line 201 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase187Actor, 4, Void >*>(static_cast<FlowTestCase187Actor*>(this)));
															#line 4078 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(int && length,int loopDepth) 
	{
															#line 195 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		ASSERT(length == 4096);
															#line 196 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		for( auto c : data ) {
															#line 197 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
			ASSERT(c == '\0');
															#line 4091 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		}
															#line 200 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		f.clear();
															#line 201 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		StrictFuture<Void> __when_expr_4 = IAsyncFileSystem::filesystem()->incrementalDeleteFile(filename, true);
															#line 201 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (static_cast<FlowTestCase187Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4099 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<FlowTestCase187Actor*>(this)->actor_wait_state = 5;
															#line 201 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase187Actor, 4, Void >*>(static_cast<FlowTestCase187Actor*>(this)));
															#line 4104 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3when1(int const& length,int loopDepth) 
	{
		loopDepth = a_body1cont4(length, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(int && length,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(length), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<FlowTestCase187Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase187Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase187Actor*>(this)->ActorCallback< FlowTestCase187Actor, 3, int >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase187Actor, 3, int >*,int const& value) 
	{
		fdb_probe_actor_enter("flowTestCase187", reinterpret_cast<unsigned long>(this), 3);
		a_exitChoose4();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase187", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< FlowTestCase187Actor, 3, int >*,int && value) 
	{
		fdb_probe_actor_enter("flowTestCase187", reinterpret_cast<unsigned long>(this), 3);
		a_exitChoose4();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase187", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< FlowTestCase187Actor, 3, int >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase187", reinterpret_cast<unsigned long>(this), 3);
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase187", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 202 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (!static_cast<FlowTestCase187Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase187ActorState(); static_cast<FlowTestCase187Actor*>(this)->destroy(); return 0; }
															#line 4176 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		new (&static_cast<FlowTestCase187Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase187ActorState();
		static_cast<FlowTestCase187Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 202 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
		if (!static_cast<FlowTestCase187Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase187ActorState(); static_cast<FlowTestCase187Actor*>(this)->destroy(); return 0; }
															#line 4188 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		new (&static_cast<FlowTestCase187Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase187ActorState();
		static_cast<FlowTestCase187Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<FlowTestCase187Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase187Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase187Actor*>(this)->ActorCallback< FlowTestCase187Actor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase187Actor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase187", reinterpret_cast<unsigned long>(this), 4);
		a_exitChoose5();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase187", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< FlowTestCase187Actor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase187", reinterpret_cast<unsigned long>(this), 4);
		a_exitChoose5();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase187", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< FlowTestCase187Actor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase187", reinterpret_cast<unsigned long>(this), 4);
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase187", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 187 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
	UnitTestParameters params;
															#line 188 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
	std::string filename;
															#line 189 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
	Reference<IAsyncFile> f;
															#line 191 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
	std::array<char, 4096> data;
															#line 4267 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase187()
															#line 187 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
class FlowTestCase187Actor final : public Actor<Void>, public ActorCallback< FlowTestCase187Actor, 0, Reference<IAsyncFile> >, public ActorCallback< FlowTestCase187Actor, 1, Void >, public ActorCallback< FlowTestCase187Actor, 2, Void >, public ActorCallback< FlowTestCase187Actor, 3, int >, public ActorCallback< FlowTestCase187Actor, 4, Void >, public FastAllocated<FlowTestCase187Actor>, public FlowTestCase187ActorState<FlowTestCase187Actor> {
															#line 4272 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase187Actor>::operator new;
	using FastAllocated<FlowTestCase187Actor>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<Void>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase187Actor, 0, Reference<IAsyncFile> >;
friend struct ActorCallback< FlowTestCase187Actor, 1, Void >;
friend struct ActorCallback< FlowTestCase187Actor, 2, Void >;
friend struct ActorCallback< FlowTestCase187Actor, 3, int >;
friend struct ActorCallback< FlowTestCase187Actor, 4, Void >;
															#line 187 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
	FlowTestCase187Actor(UnitTestParameters const& params) 
															#line 4287 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase187ActorState<FlowTestCase187Actor>(params)
	{
		fdb_probe_actor_enter("flowTestCase187", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase187");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase187", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase187Actor, 0, Reference<IAsyncFile> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< FlowTestCase187Actor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< FlowTestCase187Actor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< FlowTestCase187Actor, 3, int >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< FlowTestCase187Actor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
}
															#line 187 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
static Future<Void> flowTestCase187( UnitTestParameters const& params ) {
															#line 187 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
	return Future<Void>(new FlowTestCase187Actor(params));
															#line 4319 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/build_output/flow/IAsyncFile.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase187, "/fileio/truncateAndRead")

#line 204 "/codebuild/output/src1081771908/src/github.com/apple/foundationdb/flow/IAsyncFile.actor.cpp"
