#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"
/*
 * ReadHotDetection.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbrpc/DDSketch.h"
#include "fdbclient/NativeAPI.actor.h"
#include "fdbserver/TesterInterface.actor.h"
#include "fdbserver/workloads/BulkSetup.actor.h"
#include "fdbclient/ReadYourWrites.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

struct ReadHotDetectionWorkload : TestWorkload {
	static constexpr auto NAME = "ReadHotDetection";

	int actorCount, keyCount;

	double testDuration, transactionsPerSecond;
	std::vector<Future<Void>> clients;
	Future<Void> readHotCheck;
	Key readKey;
	KeyRange wholeRange;
	bool passed;

	ReadHotDetectionWorkload(WorkloadContext const& wcx) : TestWorkload(wcx) {
		testDuration = getOption(options, "testDuration"_sr, 120.0);
		transactionsPerSecond = getOption(options, "transactionsPerSecond"_sr, 1000.0) / clientCount;
		actorCount = getOption(options, "actorsPerClient"_sr, transactionsPerSecond / 5);
		keyCount = getOption(options, "keyCount"_sr, 100);
		readKey = StringRef(format("testkey%08x", deterministicRandom()->randomInt(0, keyCount)));
	}

	Future<Void> setup(Database const& cx) override { return _setup(cx, this); }

	Future<Void> start(Database const& cx) override {
		for (int c = 0; c < actorCount; c++) {
			clients.push_back(timeout(
			    keyReader(
			        cx->clone(), this, actorCount / transactionsPerSecond, deterministicRandom()->random01() > 0.4),
			    testDuration,
			    Void()));
		}
		readHotCheck = clientId == 0 ? _check(cx->clone(), this) : Void();
		return delay(testDuration);
	}

	Future<bool> check(Database const& cx) override {
		if (clientId != 0)
			return true;
		return passed;
	}

																#line 71 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadHotDetection.actor.g.cpp"
// This generated class is to be used only via _setup()
															#line 69 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"
template <class _setupActor>
															#line 69 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"
class _setupActorState {
															#line 77 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadHotDetection.actor.g.cpp"
public:
															#line 69 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"
	_setupActorState(Database const& cx,ReadHotDetectionWorkload* const& self) 
															#line 69 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"
															#line 69 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"
		 : cx(cx),
															#line 69 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"
		   self(self),
															#line 70 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"
		   largeValue(),
															#line 71 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"
		   smallValue()
															#line 90 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadHotDetection.actor.g.cpp"
	{
		fdb_probe_actor_create("_setup", reinterpret_cast<unsigned long>(this));

	}
	~_setupActorState() 
	{
		fdb_probe_actor_destroy("_setup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 72 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"
			largeValue = self->randomString(largeValue.arena(), 100000);
															#line 73 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"
			smallValue = self->randomString(smallValue.arena(), 100);
															#line 74 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"
			tr = ReadYourWritesTransaction(cx);
															#line 75 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"
			;
															#line 111 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadHotDetection.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 91 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"
		self->wholeRange = KeyRangeRef(""_sr, "\xff"_sr);
															#line 93 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"
		if (!static_cast<_setupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_setupActorState(); static_cast<_setupActor*>(this)->destroy(); return 0; }
															#line 136 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadHotDetection.actor.g.cpp"
		new (&static_cast<_setupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 77 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"
			for(int i = 0;i < self->keyCount;i++) {
															#line 78 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"
				Standalone<StringRef> key = StringRef(format("testkey%08x", i));
															#line 79 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"
				if (key == self->readKey)
															#line 160 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadHotDetection.actor.g.cpp"
				{
															#line 80 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"
					tr.set(key, largeValue);
															#line 164 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadHotDetection.actor.g.cpp"
				}
				else
				{
															#line 82 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"
					tr.set(key, deterministicRandom()->random01() > 0.8 ? largeValue : smallValue);
															#line 170 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadHotDetection.actor.g.cpp"
				}
			}
															#line 85 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"
			StrictFuture<Void> __when_expr_0 = tr.commit();
															#line 85 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"
			if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 177 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadHotDetection.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_setupActor*>(this)->actor_wait_state = 1;
															#line 85 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 0, Void >*>(static_cast<_setupActor*>(this)));
															#line 182 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadHotDetection.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 88 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 88 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"
			if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 219 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadHotDetection.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<_setupActor*>(this)->actor_wait_state = 2;
															#line 88 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 1, Void >*>(static_cast<_setupActor*>(this)));
															#line 224 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadHotDetection.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_setupActor*>(this)->actor_wait_state > 0) static_cast<_setupActor*>(this)->actor_wait_state = 0;
		static_cast<_setupActor*>(this)->ActorCallback< _setupActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _setupActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _setupActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _setupActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_setupActor*>(this)->actor_wait_state > 0) static_cast<_setupActor*>(this)->actor_wait_state = 0;
		static_cast<_setupActor*>(this)->ActorCallback< _setupActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _setupActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _setupActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _setupActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 69 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"
	Database cx;
															#line 69 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"
	ReadHotDetectionWorkload* self;
															#line 70 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"
	Standalone<StringRef> largeValue;
															#line 71 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"
	Standalone<StringRef> smallValue;
															#line 74 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"
	ReadYourWritesTransaction tr;
															#line 419 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadHotDetection.actor.g.cpp"
};
// This generated class is to be used only via _setup()
															#line 69 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"
class _setupActor final : public Actor<Void>, public ActorCallback< _setupActor, 0, Void >, public ActorCallback< _setupActor, 1, Void >, public FastAllocated<_setupActor>, public _setupActorState<_setupActor> {
															#line 424 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadHotDetection.actor.g.cpp"
public:
	using FastAllocated<_setupActor>::operator new;
	using FastAllocated<_setupActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11336305332082565888UL, 4293294170870725888UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _setupActor, 0, Void >;
friend struct ActorCallback< _setupActor, 1, Void >;
															#line 69 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"
	_setupActor(Database const& cx,ReadHotDetectionWorkload* const& self) 
															#line 442 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadHotDetection.actor.g.cpp"
		 : Actor<Void>(),
		   _setupActorState<_setupActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3044502327521131520UL, 13387266639422932480UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_setup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _setupActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _setupActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 69 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"
[[nodiscard]] Future<Void> _setup( Database const& cx, ReadHotDetectionWorkload* const& self ) {
															#line 69 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"
	return Future<Void>(new _setupActor(cx, self));
															#line 475 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadHotDetection.actor.g.cpp"
}

#line 95 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"

																#line 480 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadHotDetection.actor.g.cpp"
// This generated class is to be used only via _check()
															#line 96 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"
template <class _checkActor>
															#line 96 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"
class _checkActorState {
															#line 486 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadHotDetection.actor.g.cpp"
public:
															#line 96 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"
	_checkActorState(Database const& cx,ReadHotDetectionWorkload* const& self) 
															#line 96 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"
															#line 96 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"
		 : cx(cx),
															#line 96 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"
		   self(self)
															#line 495 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadHotDetection.actor.g.cpp"
	{
		fdb_probe_actor_create("_check", reinterpret_cast<unsigned long>(this));

	}
	~_checkActorState() 
	{
		fdb_probe_actor_destroy("_check", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 97 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"
			;
															#line 510 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadHotDetection.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_checkActorState();
		static_cast<_checkActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 98 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"
		tr = Transaction(cx);
															#line 540 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadHotDetection.actor.g.cpp"
		try {
															#line 100 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"
			StrictFuture<StorageMetrics> __when_expr_0 = cx->getStorageMetrics(self->wholeRange, 100);
															#line 100 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"
			if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 546 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadHotDetection.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_checkActor*>(this)->actor_wait_state = 1;
															#line 100 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 0, StorageMetrics >*>(static_cast<_checkActor*>(this)));
															#line 551 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadHotDetection.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 129 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 129 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"
			if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 575 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadHotDetection.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<_checkActor*>(this)->actor_wait_state = 3;
															#line 129 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 2, Void >*>(static_cast<_checkActor*>(this)));
															#line 580 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadHotDetection.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(StorageMetrics const& sm,int loopDepth) 
	{
															#line 104 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"
		StrictFuture<Standalone<VectorRef<ReadHotRangeWithMetrics>>> __when_expr_1 = cx->getReadHotRanges(self->wholeRange);
															#line 104 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"
		if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 597 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadHotDetection.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<_checkActor*>(this)->actor_wait_state = 2;
															#line 104 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 1, Standalone<VectorRef<ReadHotRangeWithMetrics>> >*>(static_cast<_checkActor*>(this)));
															#line 602 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadHotDetection.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(StorageMetrics && sm,int loopDepth) 
	{
															#line 104 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"
		StrictFuture<Standalone<VectorRef<ReadHotRangeWithMetrics>>> __when_expr_1 = cx->getReadHotRanges(self->wholeRange);
															#line 104 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"
		if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 613 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadHotDetection.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<_checkActor*>(this)->actor_wait_state = 2;
															#line 104 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 1, Standalone<VectorRef<ReadHotRangeWithMetrics>> >*>(static_cast<_checkActor*>(this)));
															#line 618 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadHotDetection.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(StorageMetrics const& sm,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(sm, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(StorageMetrics && sm,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(sm), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 0, StorageMetrics >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 0, StorageMetrics >*,StorageMetrics const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _checkActor, 0, StorageMetrics >*,StorageMetrics && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _checkActor, 0, StorageMetrics >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Standalone<VectorRef<ReadHotRangeWithMetrics>> const& keyRanges,int loopDepth) 
	{
															#line 111 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"
		for( const auto& kr : keyRanges ) {
															#line 112 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"
			if (kr.keys.contains(self->readKey))
															#line 704 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadHotDetection.actor.g.cpp"
			{
															#line 113 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"
				self->passed = true;
															#line 114 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"
				if (!static_cast<_checkActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_checkActorState(); static_cast<_checkActor*>(this)->destroy(); return 0; }
															#line 710 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadHotDetection.actor.g.cpp"
				new (&static_cast<_checkActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~_checkActorState();
				static_cast<_checkActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 126 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"
		self->passed = false;
															#line 719 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadHotDetection.actor.g.cpp"
		loopDepth = a_body1loopBody1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Standalone<VectorRef<ReadHotRangeWithMetrics>> && keyRanges,int loopDepth) 
	{
															#line 111 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"
		for( const auto& kr : keyRanges ) {
															#line 112 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"
			if (kr.keys.contains(self->readKey))
															#line 730 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadHotDetection.actor.g.cpp"
			{
															#line 113 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"
				self->passed = true;
															#line 114 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"
				if (!static_cast<_checkActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_checkActorState(); static_cast<_checkActor*>(this)->destroy(); return 0; }
															#line 736 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadHotDetection.actor.g.cpp"
				new (&static_cast<_checkActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~_checkActorState();
				static_cast<_checkActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 126 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"
		self->passed = false;
															#line 745 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadHotDetection.actor.g.cpp"
		loopDepth = a_body1loopBody1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Standalone<VectorRef<ReadHotRangeWithMetrics>> const& keyRanges,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(keyRanges, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Standalone<VectorRef<ReadHotRangeWithMetrics>> && keyRanges,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(keyRanges), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 1, Standalone<VectorRef<ReadHotRangeWithMetrics>> >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 1, Standalone<VectorRef<ReadHotRangeWithMetrics>> >*,Standalone<VectorRef<ReadHotRangeWithMetrics>> const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _checkActor, 1, Standalone<VectorRef<ReadHotRangeWithMetrics>> >*,Standalone<VectorRef<ReadHotRangeWithMetrics>> && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _checkActor, 1, Standalone<VectorRef<ReadHotRangeWithMetrics>> >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont7(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _checkActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _checkActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 96 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"
	Database cx;
															#line 96 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"
	ReadHotDetectionWorkload* self;
															#line 98 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"
	Transaction tr;
															#line 931 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadHotDetection.actor.g.cpp"
};
// This generated class is to be used only via _check()
															#line 96 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"
class _checkActor final : public Actor<Void>, public ActorCallback< _checkActor, 0, StorageMetrics >, public ActorCallback< _checkActor, 1, Standalone<VectorRef<ReadHotRangeWithMetrics>> >, public ActorCallback< _checkActor, 2, Void >, public FastAllocated<_checkActor>, public _checkActorState<_checkActor> {
															#line 936 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadHotDetection.actor.g.cpp"
public:
	using FastAllocated<_checkActor>::operator new;
	using FastAllocated<_checkActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(892044100978297600UL, 4458976952352636160UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _checkActor, 0, StorageMetrics >;
friend struct ActorCallback< _checkActor, 1, Standalone<VectorRef<ReadHotRangeWithMetrics>> >;
friend struct ActorCallback< _checkActor, 2, Void >;
															#line 96 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"
	_checkActor(Database const& cx,ReadHotDetectionWorkload* const& self) 
															#line 955 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadHotDetection.actor.g.cpp"
		 : Actor<Void>(),
		   _checkActorState<_checkActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18414574916690025728UL, 14115196402046968064UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_check");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _checkActor, 0, StorageMetrics >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _checkActor, 1, Standalone<VectorRef<ReadHotRangeWithMetrics>> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _checkActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 96 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"
[[nodiscard]] Future<Void> _check( Database const& cx, ReadHotDetectionWorkload* const& self ) {
															#line 96 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"
	return Future<Void>(new _checkActor(cx, self));
															#line 989 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadHotDetection.actor.g.cpp"
}

#line 133 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"

	void getMetrics(std::vector<PerfMetric>& m) override {}

																#line 996 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadHotDetection.actor.g.cpp"
// This generated class is to be used only via keyReader()
															#line 136 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"
template <class KeyReaderActor>
															#line 136 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"
class KeyReaderActorState {
															#line 1002 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadHotDetection.actor.g.cpp"
public:
															#line 136 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"
	KeyReaderActorState(Database const& cx,ReadHotDetectionWorkload* const& self,double const& delay,bool const& useReadKey) 
															#line 136 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"
															#line 136 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"
		 : cx(cx),
															#line 136 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"
		   self(self),
															#line 136 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"
		   delay(delay),
															#line 136 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"
		   useReadKey(useReadKey),
															#line 137 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"
		   lastTime(now())
															#line 1017 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadHotDetection.actor.g.cpp"
	{
		fdb_probe_actor_create("keyReader", reinterpret_cast<unsigned long>(this));

	}
	~KeyReaderActorState() 
	{
		fdb_probe_actor_destroy("keyReader", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 138 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"
			;
															#line 1032 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadHotDetection.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~KeyReaderActorState();
		static_cast<KeyReaderActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 139 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"
		StrictFuture<Void> __when_expr_0 = poisson(&lastTime, delay);
															#line 139 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"
		if (static_cast<KeyReaderActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1064 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadHotDetection.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<KeyReaderActor*>(this)->actor_wait_state = 1;
															#line 139 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< KeyReaderActor, 0, Void >*>(static_cast<KeyReaderActor*>(this)));
															#line 1069 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadHotDetection.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 140 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"
		tr = ReadYourWritesTransaction(cx);
															#line 141 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"
		;
															#line 1080 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadHotDetection.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 140 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"
		tr = ReadYourWritesTransaction(cx);
															#line 141 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"
		;
															#line 1091 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadHotDetection.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<KeyReaderActor*>(this)->actor_wait_state > 0) static_cast<KeyReaderActor*>(this)->actor_wait_state = 0;
		static_cast<KeyReaderActor*>(this)->ActorCallback< KeyReaderActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< KeyReaderActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("keyReader", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<KeyReaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("keyReader", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< KeyReaderActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("keyReader", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<KeyReaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("keyReader", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< KeyReaderActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("keyReader", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<KeyReaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("keyReader", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1(int loopDepth) 
	{
		try {
															#line 143 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_1 = tr.get( useReadKey ? self->readKey : StringRef(format("testkey%08x", deterministicRandom()->randomInt(0, self->keyCount))));
															#line 143 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"
			if (static_cast<KeyReaderActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1191 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadHotDetection.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1cont1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<KeyReaderActor*>(this)->actor_wait_state = 2;
															#line 143 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< KeyReaderActor, 1, Optional<Value> >*>(static_cast<KeyReaderActor*>(this)));
															#line 1196 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadHotDetection.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 149 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 149 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"
			if (static_cast<KeyReaderActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 1233 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadHotDetection.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<KeyReaderActor*>(this)->actor_wait_state = 3;
															#line 149 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< KeyReaderActor, 2, Void >*>(static_cast<KeyReaderActor*>(this)));
															#line 1238 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadHotDetection.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont2(Optional<Value> const& v,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont2(Optional<Value> && v,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when1(Optional<Value> const& v,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont2(v, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when1(Optional<Value> && v,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont2(std::move(v), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<KeyReaderActor*>(this)->actor_wait_state > 0) static_cast<KeyReaderActor*>(this)->actor_wait_state = 0;
		static_cast<KeyReaderActor*>(this)->ActorCallback< KeyReaderActor, 1, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< KeyReaderActor, 1, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("keyReader", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<KeyReaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("keyReader", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< KeyReaderActor, 1, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("keyReader", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<KeyReaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("keyReader", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< KeyReaderActor, 1, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("keyReader", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<KeyReaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("keyReader", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<KeyReaderActor*>(this)->actor_wait_state > 0) static_cast<KeyReaderActor*>(this)->actor_wait_state = 0;
		static_cast<KeyReaderActor*>(this)->ActorCallback< KeyReaderActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< KeyReaderActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("keyReader", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<KeyReaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("keyReader", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< KeyReaderActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("keyReader", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<KeyReaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("keyReader", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< KeyReaderActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("keyReader", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<KeyReaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("keyReader", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 136 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"
	Database cx;
															#line 136 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"
	ReadHotDetectionWorkload* self;
															#line 136 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"
	double delay;
															#line 136 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"
	bool useReadKey;
															#line 137 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"
	double lastTime;
															#line 140 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"
	ReadYourWritesTransaction tr;
															#line 1435 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadHotDetection.actor.g.cpp"
};
// This generated class is to be used only via keyReader()
															#line 136 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"
class KeyReaderActor final : public Actor<Void>, public ActorCallback< KeyReaderActor, 0, Void >, public ActorCallback< KeyReaderActor, 1, Optional<Value> >, public ActorCallback< KeyReaderActor, 2, Void >, public FastAllocated<KeyReaderActor>, public KeyReaderActorState<KeyReaderActor> {
															#line 1440 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadHotDetection.actor.g.cpp"
public:
	using FastAllocated<KeyReaderActor>::operator new;
	using FastAllocated<KeyReaderActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4085874178510284032UL, 13929693173481507584UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< KeyReaderActor, 0, Void >;
friend struct ActorCallback< KeyReaderActor, 1, Optional<Value> >;
friend struct ActorCallback< KeyReaderActor, 2, Void >;
															#line 136 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"
	KeyReaderActor(Database const& cx,ReadHotDetectionWorkload* const& self,double const& delay,bool const& useReadKey) 
															#line 1459 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadHotDetection.actor.g.cpp"
		 : Actor<Void>(),
		   KeyReaderActorState<KeyReaderActor>(cx, self, delay, useReadKey),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("keyReader", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13550316836238213888UL, 6789961581589619200UL);
		ActorExecutionContextHelper __helper(static_cast<KeyReaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("keyReader");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("keyReader", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< KeyReaderActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< KeyReaderActor, 1, Optional<Value> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< KeyReaderActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 136 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"
[[nodiscard]] Future<Void> keyReader( Database const& cx, ReadHotDetectionWorkload* const& self, double const& delay, bool const& useReadKey ) {
															#line 136 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"
	return Future<Void>(new KeyReaderActor(cx, self, delay, useReadKey));
															#line 1493 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadHotDetection.actor.g.cpp"
}

#line 154 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/ReadHotDetection.actor.cpp"
	StringRef randomString(Arena& arena, int len, char firstChar = 'a', char lastChar = 'z') {
		++lastChar;
		StringRef s = makeString(len, arena);
		for (int i = 0; i < len; ++i) {
			*(uint8_t*)(s.begin() + i) = (uint8_t)deterministicRandom()->randomInt(firstChar, lastChar);
		}
		return s;
	}
};

WorkloadFactory<ReadHotDetectionWorkload> ReadHotDetectionWorkloadFactory;
