#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
/*
 * GetRangeStream.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/NativeAPI.actor.h"
#include "fdbserver/TesterInterface.actor.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "fdbserver/workloads/BulkSetup.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

struct GetRangeStream : TestWorkload {
	static constexpr auto NAME = "GetRangeStream";
	PerfIntCounter bytesRead;
	bool useGetRange;
	Key begin;
	Key end;
	bool printKVPairs;

	GetRangeStream(WorkloadContext const& wcx) : TestWorkload(wcx), bytesRead("BytesRead") {
		useGetRange = getOption(options, "useGetRange"_sr, false);
		begin = getOption(options, "begin"_sr, normalKeys.begin);
		end = getOption(options, "end"_sr, normalKeys.end);
		printKVPairs = getOption(options, "printKVPairs"_sr, false);
	}

	Future<Void> setup(Database const& cx) override { return Void(); }

	Future<Void> start(Database const& cx) override {
		return clientId != 0 ? Void() : useGetRange ? fdbClientGetRange(cx, this) : fdbClientStream(cx, this);
	}

	Future<bool> check(Database const& cx) override { return true; }

	void getMetrics(std::vector<PerfMetric>& m) override { m.push_back(bytesRead.getMetric()); }

																#line 54 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetRangeStream.actor.g.cpp"
// This generated class is to be used only via logThroughput()
															#line 52 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
template <class LogThroughputActor>
															#line 52 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
class LogThroughputActorState {
															#line 60 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetRangeStream.actor.g.cpp"
public:
															#line 52 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
	LogThroughputActorState(GetRangeStream* const& self,Key* const& next) 
															#line 52 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
															#line 52 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
		 : self(self),
															#line 52 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
		   next(next)
															#line 69 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetRangeStream.actor.g.cpp"
	{
		fdb_probe_actor_create("logThroughput", reinterpret_cast<unsigned long>(this));

	}
	~LogThroughputActorState() 
	{
		fdb_probe_actor_destroy("logThroughput", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 53 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
			;
															#line 84 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetRangeStream.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~LogThroughputActorState();
		static_cast<LogThroughputActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 54 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
		last = self->bytesRead.getValue();
															#line 55 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
		before = g_network->now();
															#line 56 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delay(1);
															#line 56 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
		if (static_cast<LogThroughputActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 120 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetRangeStream.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<LogThroughputActor*>(this)->actor_wait_state = 1;
															#line 56 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< LogThroughputActor, 0, Void >*>(static_cast<LogThroughputActor*>(this)));
															#line 125 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetRangeStream.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 57 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
		after = g_network->now();
															#line 58 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
		if (after > before)
															#line 136 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetRangeStream.actor.g.cpp"
		{
															#line 59 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
			printf("throughput: %g bytes/s, next: %s\n", (self->bytesRead.getValue() - last) / (after - before), printable(*next).c_str());
															#line 140 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetRangeStream.actor.g.cpp"
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 57 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
		after = g_network->now();
															#line 58 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
		if (after > before)
															#line 152 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetRangeStream.actor.g.cpp"
		{
															#line 59 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
			printf("throughput: %g bytes/s, next: %s\n", (self->bytesRead.getValue() - last) / (after - before), printable(*next).c_str());
															#line 156 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetRangeStream.actor.g.cpp"
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<LogThroughputActor*>(this)->actor_wait_state > 0) static_cast<LogThroughputActor*>(this)->actor_wait_state = 0;
		static_cast<LogThroughputActor*>(this)->ActorCallback< LogThroughputActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LogThroughputActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("logThroughput", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LogThroughputActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("logThroughput", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< LogThroughputActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("logThroughput", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LogThroughputActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("logThroughput", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< LogThroughputActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("logThroughput", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LogThroughputActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("logThroughput", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 52 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
	GetRangeStream* self;
															#line 52 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
	Key* next;
															#line 54 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
	int64_t last;
															#line 55 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
	double before;
															#line 57 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
	double after;
															#line 247 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetRangeStream.actor.g.cpp"
};
// This generated class is to be used only via logThroughput()
															#line 52 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
class LogThroughputActor final : public Actor<Void>, public ActorCallback< LogThroughputActor, 0, Void >, public FastAllocated<LogThroughputActor>, public LogThroughputActorState<LogThroughputActor> {
															#line 252 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetRangeStream.actor.g.cpp"
public:
	using FastAllocated<LogThroughputActor>::operator new;
	using FastAllocated<LogThroughputActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8687371642396454912UL, 11521995112147429888UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< LogThroughputActor, 0, Void >;
															#line 52 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
	LogThroughputActor(GetRangeStream* const& self,Key* const& next) 
															#line 269 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetRangeStream.actor.g.cpp"
		 : Actor<Void>(),
		   LogThroughputActorState<LogThroughputActor>(self, next),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("logThroughput", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2415456824429687552UL, 17289377887960322816UL);
		ActorExecutionContextHelper __helper(static_cast<LogThroughputActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("logThroughput");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("logThroughput", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< LogThroughputActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 52 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
[[nodiscard]] static Future<Void> logThroughput( GetRangeStream* const& self, Key* const& next ) {
															#line 52 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
	return Future<Void>(new LogThroughputActor(self, next));
															#line 301 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetRangeStream.actor.g.cpp"
}

#line 65 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"

																#line 306 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetRangeStream.actor.g.cpp"
// This generated class is to be used only via fdbClientGetRange()
															#line 66 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
template <class FdbClientGetRangeActor>
															#line 66 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
class FdbClientGetRangeActorState {
															#line 312 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetRangeStream.actor.g.cpp"
public:
															#line 66 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
	FdbClientGetRangeActorState(Database const& db,GetRangeStream* const& self) 
															#line 66 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
															#line 66 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
		 : db(db),
															#line 66 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
		   self(self),
															#line 67 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
		   tx(db),
															#line 68 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
		   next(self->begin),
															#line 69 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
		   logFuture(logThroughput(self, &next))
															#line 327 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetRangeStream.actor.g.cpp"
	{
		fdb_probe_actor_create("fdbClientGetRange", reinterpret_cast<unsigned long>(this));

	}
	~FdbClientGetRangeActorState() 
	{
		fdb_probe_actor_destroy("fdbClientGetRange", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 70 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
			;
															#line 342 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetRangeStream.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FdbClientGetRangeActorState();
		static_cast<FdbClientGetRangeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 90 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
		if (!static_cast<FdbClientGetRangeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FdbClientGetRangeActorState(); static_cast<FdbClientGetRangeActor*>(this)->destroy(); return 0; }
															#line 365 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetRangeStream.actor.g.cpp"
		new (&static_cast<FdbClientGetRangeActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FdbClientGetRangeActorState();
		static_cast<FdbClientGetRangeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 72 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
			StrictFuture<Standalone<RangeResultRef>> __when_expr_0 = tx.getRange(KeySelector(firstGreaterOrEqual(next), next.arena()), KeySelector(firstGreaterOrEqual(self->end)), GetRangeLimits(GetRangeLimits::ROW_LIMIT_UNLIMITED, CLIENT_KNOBS->REPLY_BYTE_LIMIT));
															#line 72 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
			if (static_cast<FdbClientGetRangeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 387 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetRangeStream.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FdbClientGetRangeActor*>(this)->actor_wait_state = 1;
															#line 72 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FdbClientGetRangeActor, 0, Standalone<RangeResultRef> >*>(static_cast<FdbClientGetRangeActor*>(this)));
															#line 392 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetRangeStream.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 87 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tx.onError(e);
															#line 87 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
			if (static_cast<FdbClientGetRangeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 429 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetRangeStream.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<FdbClientGetRangeActor*>(this)->actor_wait_state = 2;
															#line 87 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FdbClientGetRangeActor, 1, Void >*>(static_cast<FdbClientGetRangeActor*>(this)));
															#line 434 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetRangeStream.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Standalone<RangeResultRef> const& range,int loopDepth) 
	{
															#line 76 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
		for( const auto& [k, v] : range ) {
															#line 77 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
			if (self->printKVPairs)
															#line 451 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetRangeStream.actor.g.cpp"
			{
															#line 78 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
				printf("%s -> %s\n", printable(k).c_str(), printable(v).c_str());
															#line 455 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetRangeStream.actor.g.cpp"
			}
															#line 80 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
			self->bytesRead += k.size() + v.size();
															#line 459 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetRangeStream.actor.g.cpp"
		}
															#line 82 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
		if (!range.more)
															#line 463 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetRangeStream.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 85 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
		next = keyAfter(range.back().key);
															#line 469 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetRangeStream.actor.g.cpp"
		loopDepth = a_body1loopBody1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2(Standalone<RangeResultRef> && range,int loopDepth) 
	{
															#line 76 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
		for( const auto& [k, v] : range ) {
															#line 77 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
			if (self->printKVPairs)
															#line 480 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetRangeStream.actor.g.cpp"
			{
															#line 78 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
				printf("%s -> %s\n", printable(k).c_str(), printable(v).c_str());
															#line 484 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetRangeStream.actor.g.cpp"
			}
															#line 80 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
			self->bytesRead += k.size() + v.size();
															#line 488 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetRangeStream.actor.g.cpp"
		}
															#line 82 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
		if (!range.more)
															#line 492 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetRangeStream.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 85 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
		next = keyAfter(range.back().key);
															#line 498 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetRangeStream.actor.g.cpp"
		loopDepth = a_body1loopBody1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Standalone<RangeResultRef> const& range,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(range, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Standalone<RangeResultRef> && range,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(range), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FdbClientGetRangeActor*>(this)->actor_wait_state > 0) static_cast<FdbClientGetRangeActor*>(this)->actor_wait_state = 0;
		static_cast<FdbClientGetRangeActor*>(this)->ActorCallback< FdbClientGetRangeActor, 0, Standalone<RangeResultRef> >::remove();

	}
	void a_callback_fire(ActorCallback< FdbClientGetRangeActor, 0, Standalone<RangeResultRef> >*,Standalone<RangeResultRef> const& value) 
	{
		fdb_probe_actor_enter("fdbClientGetRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FdbClientGetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fdbClientGetRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FdbClientGetRangeActor, 0, Standalone<RangeResultRef> >*,Standalone<RangeResultRef> && value) 
	{
		fdb_probe_actor_enter("fdbClientGetRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FdbClientGetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fdbClientGetRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FdbClientGetRangeActor, 0, Standalone<RangeResultRef> >*,Error err) 
	{
		fdb_probe_actor_enter("fdbClientGetRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FdbClientGetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fdbClientGetRange", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont7(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<FdbClientGetRangeActor*>(this)->actor_wait_state > 0) static_cast<FdbClientGetRangeActor*>(this)->actor_wait_state = 0;
		static_cast<FdbClientGetRangeActor*>(this)->ActorCallback< FdbClientGetRangeActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FdbClientGetRangeActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fdbClientGetRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FdbClientGetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fdbClientGetRange", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FdbClientGetRangeActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fdbClientGetRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FdbClientGetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fdbClientGetRange", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FdbClientGetRangeActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fdbClientGetRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FdbClientGetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fdbClientGetRange", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 66 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
	Database db;
															#line 66 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
	GetRangeStream* self;
															#line 67 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
	Transaction tx;
															#line 68 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
	Key next;
															#line 69 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
	Future<Void> logFuture;
															#line 688 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetRangeStream.actor.g.cpp"
};
// This generated class is to be used only via fdbClientGetRange()
															#line 66 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
class FdbClientGetRangeActor final : public Actor<Void>, public ActorCallback< FdbClientGetRangeActor, 0, Standalone<RangeResultRef> >, public ActorCallback< FdbClientGetRangeActor, 1, Void >, public FastAllocated<FdbClientGetRangeActor>, public FdbClientGetRangeActorState<FdbClientGetRangeActor> {
															#line 693 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetRangeStream.actor.g.cpp"
public:
	using FastAllocated<FdbClientGetRangeActor>::operator new;
	using FastAllocated<FdbClientGetRangeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3087210536466833664UL, 3584190793560860160UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FdbClientGetRangeActor, 0, Standalone<RangeResultRef> >;
friend struct ActorCallback< FdbClientGetRangeActor, 1, Void >;
															#line 66 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
	FdbClientGetRangeActor(Database const& db,GetRangeStream* const& self) 
															#line 711 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetRangeStream.actor.g.cpp"
		 : Actor<Void>(),
		   FdbClientGetRangeActorState<FdbClientGetRangeActor>(db, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("fdbClientGetRange", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(431275374245541632UL, 2355442063886276352UL);
		ActorExecutionContextHelper __helper(static_cast<FdbClientGetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("fdbClientGetRange");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("fdbClientGetRange", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FdbClientGetRangeActor, 0, Standalone<RangeResultRef> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< FdbClientGetRangeActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 66 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
[[nodiscard]] static Future<Void> fdbClientGetRange( Database const& db, GetRangeStream* const& self ) {
															#line 66 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
	return Future<Void>(new FdbClientGetRangeActor(db, self));
															#line 744 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetRangeStream.actor.g.cpp"
}

#line 92 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"

																#line 749 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetRangeStream.actor.g.cpp"
// This generated class is to be used only via fdbClientStream()
															#line 93 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
template <class FdbClientStreamActor>
															#line 93 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
class FdbClientStreamActorState {
															#line 755 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetRangeStream.actor.g.cpp"
public:
															#line 93 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
	FdbClientStreamActorState(Database const& db,GetRangeStream* const& self) 
															#line 93 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
															#line 93 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
		 : db(db),
															#line 93 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
		   self(self),
															#line 94 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
		   tx(db),
															#line 95 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
		   next(self->begin),
															#line 96 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
		   logFuture(logThroughput(self, &next))
															#line 770 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetRangeStream.actor.g.cpp"
	{
		fdb_probe_actor_create("fdbClientStream", reinterpret_cast<unsigned long>(this));

	}
	~FdbClientStreamActorState() 
	{
		fdb_probe_actor_destroy("fdbClientStream", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 97 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
			;
															#line 785 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetRangeStream.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FdbClientStreamActorState();
		static_cast<FdbClientStreamActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 123 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
		if (!static_cast<FdbClientStreamActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FdbClientStreamActorState(); static_cast<FdbClientStreamActor*>(this)->destroy(); return 0; }
															#line 808 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetRangeStream.actor.g.cpp"
		new (&static_cast<FdbClientStreamActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FdbClientStreamActorState();
		static_cast<FdbClientStreamActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 98 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
		results = PromiseStream<Standalone<RangeResultRef>>();
															#line 827 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetRangeStream.actor.g.cpp"
		try {
															#line 100 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
			stream = tx.getRangeStream(results, KeySelector(firstGreaterOrEqual(next), next.arena()), KeySelector(firstGreaterOrEqual(self->end)), GetRangeLimits());
															#line 104 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
			;
															#line 833 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetRangeStream.actor.g.cpp"
			loopDepth = a_body1loopBody1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 117 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
			if (e.code() == error_code_end_of_stream)
															#line 868 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetRangeStream.actor.g.cpp"
			{
				return a_body1break1(loopDepth==0?0:loopDepth-1); // break
			}
															#line 120 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tx.onError(e);
															#line 120 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
			if (static_cast<FdbClientStreamActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 876 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetRangeStream.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<FdbClientStreamActor*>(this)->actor_wait_state = 2;
															#line 120 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FdbClientStreamActor, 1, Void >*>(static_cast<FdbClientStreamActor*>(this)));
															#line 881 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetRangeStream.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
															#line 105 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
		auto __when_expr_0 = results.getFuture();
															#line 903 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetRangeStream.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_0), FutureStream<Standalone<RangeResultRef>>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<Standalone<RangeResultRef>>>::value, "invalid type");
															#line 105 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
		if (static_cast<FdbClientStreamActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 907 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetRangeStream.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1loopBody1when1(__when_expr_0.pop(), loopDepth); };
		static_cast<FdbClientStreamActor*>(this)->actor_wait_state = 1;
															#line 105 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< FdbClientStreamActor, 0, Standalone<RangeResultRef> >*>(static_cast<FdbClientStreamActor*>(this)));
															#line 912 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetRangeStream.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(Standalone<RangeResultRef> const& range,int loopDepth) 
	{
															#line 106 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
		for( const auto& [k, v] : range ) {
															#line 107 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
			if (self->printKVPairs)
															#line 923 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetRangeStream.actor.g.cpp"
			{
															#line 108 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
				printf("%s -> %s\n", printable(k).c_str(), printable(v).c_str());
															#line 927 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetRangeStream.actor.g.cpp"
			}
															#line 110 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
			self->bytesRead += k.size() + v.size();
															#line 931 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetRangeStream.actor.g.cpp"
		}
															#line 112 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
		if (range.size())
															#line 935 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetRangeStream.actor.g.cpp"
		{
															#line 113 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
			next = keyAfter(range.back().key);
															#line 939 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetRangeStream.actor.g.cpp"
		}
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(Standalone<RangeResultRef> && range,int loopDepth) 
	{
															#line 106 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
		for( const auto& [k, v] : range ) {
															#line 107 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
			if (self->printKVPairs)
															#line 951 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetRangeStream.actor.g.cpp"
			{
															#line 108 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
				printf("%s -> %s\n", printable(k).c_str(), printable(v).c_str());
															#line 955 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetRangeStream.actor.g.cpp"
			}
															#line 110 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
			self->bytesRead += k.size() + v.size();
															#line 959 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetRangeStream.actor.g.cpp"
		}
															#line 112 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
		if (range.size())
															#line 963 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetRangeStream.actor.g.cpp"
		{
															#line 113 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
			next = keyAfter(range.back().key);
															#line 967 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetRangeStream.actor.g.cpp"
		}
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Standalone<RangeResultRef> const& range,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(range, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Standalone<RangeResultRef> && range,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(std::move(range), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FdbClientStreamActor*>(this)->actor_wait_state > 0) static_cast<FdbClientStreamActor*>(this)->actor_wait_state = 0;
		static_cast<FdbClientStreamActor*>(this)->ActorSingleCallback< FdbClientStreamActor, 0, Standalone<RangeResultRef> >::remove();

	}
	void a_callback_fire(ActorSingleCallback< FdbClientStreamActor, 0, Standalone<RangeResultRef> >*,Standalone<RangeResultRef> const& value) 
	{
		fdb_probe_actor_enter("fdbClientStream", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FdbClientStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fdbClientStream", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< FdbClientStreamActor, 0, Standalone<RangeResultRef> >*,Standalone<RangeResultRef> && value) 
	{
		fdb_probe_actor_enter("fdbClientStream", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FdbClientStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fdbClientStream", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< FdbClientStreamActor, 0, Standalone<RangeResultRef> >*,Error err) 
	{
		fdb_probe_actor_enter("fdbClientStream", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FdbClientStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fdbClientStream", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<FdbClientStreamActor*>(this)->actor_wait_state > 0) static_cast<FdbClientStreamActor*>(this)->actor_wait_state = 0;
		static_cast<FdbClientStreamActor*>(this)->ActorCallback< FdbClientStreamActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FdbClientStreamActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fdbClientStream", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FdbClientStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fdbClientStream", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FdbClientStreamActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fdbClientStream", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FdbClientStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fdbClientStream", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FdbClientStreamActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fdbClientStream", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FdbClientStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fdbClientStream", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 93 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
	Database db;
															#line 93 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
	GetRangeStream* self;
															#line 94 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
	Transaction tx;
															#line 95 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
	Key next;
															#line 96 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
	Future<Void> logFuture;
															#line 98 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
	PromiseStream<Standalone<RangeResultRef>> results;
															#line 100 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
	Future<Void> stream;
															#line 1149 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetRangeStream.actor.g.cpp"
};
// This generated class is to be used only via fdbClientStream()
															#line 93 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
class FdbClientStreamActor final : public Actor<Void>, public ActorSingleCallback< FdbClientStreamActor, 0, Standalone<RangeResultRef> >, public ActorCallback< FdbClientStreamActor, 1, Void >, public FastAllocated<FdbClientStreamActor>, public FdbClientStreamActorState<FdbClientStreamActor> {
															#line 1154 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetRangeStream.actor.g.cpp"
public:
	using FastAllocated<FdbClientStreamActor>::operator new;
	using FastAllocated<FdbClientStreamActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16982833191523893248UL, 2069520423683355392UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< FdbClientStreamActor, 0, Standalone<RangeResultRef> >;
friend struct ActorCallback< FdbClientStreamActor, 1, Void >;
															#line 93 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
	FdbClientStreamActor(Database const& db,GetRangeStream* const& self) 
															#line 1172 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetRangeStream.actor.g.cpp"
		 : Actor<Void>(),
		   FdbClientStreamActorState<FdbClientStreamActor>(db, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("fdbClientStream", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11970803611283168000UL, 3665065125492980736UL);
		ActorExecutionContextHelper __helper(static_cast<FdbClientStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("fdbClientStream");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("fdbClientStream", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< FdbClientStreamActor, 0, Standalone<RangeResultRef> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< FdbClientStreamActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 93 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
[[nodiscard]] static Future<Void> fdbClientStream( Database const& db, GetRangeStream* const& self ) {
															#line 93 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
	return Future<Void>(new FdbClientStreamActor(db, self));
															#line 1205 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/GetRangeStream.actor.g.cpp"
}

#line 125 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbserver/workloads/GetRangeStream.actor.cpp"
};

WorkloadFactory<GetRangeStream> GetRangeStreamWorkloadFactory;
