#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
/*
 * SpecialKeySpace.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "boost/lexical_cast.hpp"
#include "boost/algorithm/string.hpp"

#include <string>
#include <time.h>
#include <msgpack.hpp>

#include <exception>
#include <unordered_set>

#include "fdbclient/ActorLineageProfiler.h"
#include "fdbclient/ClusterConnectionMemoryRecord.h"
#include "fdbclient/FDBOptions.g.h"
#include "fdbclient/Knobs.h"
#include "fdbclient/ProcessInterface.h"
#include "fdbclient/GlobalConfig.actor.h"
#include "fdbclient/SpecialKeySpace.actor.h"
#include "flow/Arena.h"
#include "flow/UnitTest.h"
#include "fdbclient/ManagementAPI.actor.h"
#include "fdbclient/StatusClient.h"
#include "flow/actorcompiler.h" // This must be the last #include.

namespace {
const std::string kTracingTransactionIdKey = "transaction_id";
const std::string kTracingTokenKey = "token";

static bool isAlphaNumeric(const std::string& key) {
	// [A-Za-z0-9_]+
	if (!key.size())
		return false;
	for (const char& c : key) {
		if (!((c >= '0' && c <= '9') || (c >= 'A' && c <= 'Z') || (c >= 'a' && c <= 'z') || c == '_'))
			return false;
	}
	return true;
}
} // namespace

std::unordered_map<SpecialKeySpace::MODULE, KeyRange> SpecialKeySpace::moduleToBoundary = {
	{ SpecialKeySpace::MODULE::TRANSACTION, KeyRangeRef("\xff\xff/transaction/"_sr, "\xff\xff/transaction0"_sr) },
	{ SpecialKeySpace::MODULE::WORKERINTERFACE,
	  KeyRangeRef("\xff\xff/worker_interfaces/"_sr, "\xff\xff/worker_interfaces0"_sr) },
	{ SpecialKeySpace::MODULE::STATUSJSON, singleKeyRange("\xff\xff/status/json"_sr) },
	{ SpecialKeySpace::MODULE::CONNECTIONSTRING, singleKeyRange("\xff\xff/connection_string"_sr) },
	{ SpecialKeySpace::MODULE::CLUSTERFILEPATH, singleKeyRange("\xff\xff/cluster_file_path"_sr) },
	{ SpecialKeySpace::MODULE::METRICS, KeyRangeRef("\xff\xff/metrics/"_sr, "\xff\xff/metrics0"_sr) },
	{ SpecialKeySpace::MODULE::MANAGEMENT, KeyRangeRef("\xff\xff/management/"_sr, "\xff\xff/management0"_sr) },
	{ SpecialKeySpace::MODULE::ERRORMSG, singleKeyRange("\xff\xff/error_message"_sr) },
	{ SpecialKeySpace::MODULE::CONFIGURATION, KeyRangeRef("\xff\xff/configuration/"_sr, "\xff\xff/configuration0"_sr) },
	{ SpecialKeySpace::MODULE::GLOBALCONFIG, KeyRangeRef("\xff\xff/global_config/"_sr, "\xff\xff/global_config0"_sr) },
	{ SpecialKeySpace::MODULE::TRACING, KeyRangeRef("\xff\xff/tracing/"_sr, "\xff\xff/tracing0"_sr) },
	{ SpecialKeySpace::MODULE::ACTORLINEAGE, KeyRangeRef("\xff\xff/actor_lineage/"_sr, "\xff\xff/actor_lineage0"_sr) },
	{ SpecialKeySpace::MODULE::ACTOR_PROFILER_CONF,
	  KeyRangeRef("\xff\xff/actor_profiler_conf/"_sr, "\xff\xff/actor_profiler_conf0"_sr) },
	{ SpecialKeySpace::MODULE::CLUSTERID, singleKeyRange("\xff\xff/cluster_id"_sr) },
};

std::unordered_map<std::string, KeyRange> SpecialKeySpace::managementApiCommandToRange = {
	{ "exclude", KeyRangeRef("excluded/"_sr, "excluded0"_sr).withPrefix(moduleToBoundary[MODULE::MANAGEMENT].begin) },
	{ "failed", KeyRangeRef("failed/"_sr, "failed0"_sr).withPrefix(moduleToBoundary[MODULE::MANAGEMENT].begin) },
	{ "excludedlocality",
	  KeyRangeRef("excluded_locality/"_sr, "excluded_locality0"_sr)
	      .withPrefix(moduleToBoundary[MODULE::MANAGEMENT].begin) },
	{ "failedlocality",
	  KeyRangeRef("failed_locality/"_sr, "failed_locality0"_sr)
	      .withPrefix(moduleToBoundary[MODULE::MANAGEMENT].begin) },
	{ "lock", singleKeyRange("db_locked"_sr).withPrefix(moduleToBoundary[MODULE::MANAGEMENT].begin) },
	{ "consistencycheck",
	  singleKeyRange("consistency_check_suspended"_sr).withPrefix(moduleToBoundary[MODULE::MANAGEMENT].begin) },
	{ "coordinators",
	  KeyRangeRef("coordinators/"_sr, "coordinators0"_sr).withPrefix(moduleToBoundary[MODULE::CONFIGURATION].begin) },
	{ "advanceversion",
	  singleKeyRange("min_required_commit_version"_sr).withPrefix(moduleToBoundary[MODULE::MANAGEMENT].begin) },
	{ "versionepoch", singleKeyRange("version_epoch"_sr).withPrefix(moduleToBoundary[MODULE::MANAGEMENT].begin) },
	{ "profile", KeyRangeRef("profiling/"_sr, "profiling0"_sr).withPrefix(moduleToBoundary[MODULE::MANAGEMENT].begin) },
	{ "maintenance",
	  KeyRangeRef("maintenance/"_sr, "maintenance0"_sr).withPrefix(moduleToBoundary[MODULE::MANAGEMENT].begin) },
	{ "datadistribution",
	  KeyRangeRef("data_distribution/"_sr, "data_distribution0"_sr)
	      .withPrefix(moduleToBoundary[MODULE::MANAGEMENT].begin) },
	{ "tenant", KeyRangeRef("tenant/"_sr, "tenant0"_sr).withPrefix(moduleToBoundary[MODULE::MANAGEMENT].begin) },
	{ "tenantmap",
	  KeyRangeRef("tenant_map/"_sr, "tenant_map0"_sr).withPrefix(moduleToBoundary[MODULE::MANAGEMENT].begin) }
};

std::unordered_map<std::string, KeyRange> SpecialKeySpace::actorLineageApiCommandToRange = {
	{ "state", KeyRangeRef("state/"_sr, "state0"_sr).withPrefix(moduleToBoundary[MODULE::ACTORLINEAGE].begin) },
	{ "time", KeyRangeRef("time/"_sr, "time0"_sr).withPrefix(moduleToBoundary[MODULE::ACTORLINEAGE].begin) }
};

std::set<std::string> SpecialKeySpace::options = { "excluded/force",
	                                               "failed/force",
	                                               "excluded_locality/force",
	                                               "failed_locality/force",
	                                               "worker_interfaces/verify" };

std::set<std::string> SpecialKeySpace::tracingOptions = { kTracingTransactionIdKey, kTracingTokenKey };

RangeResult rywGetRange(ReadYourWritesTransaction* ryw, const KeyRangeRef& kr, const RangeResult& res);

// This function will move the given KeySelector as far as possible to the standard form:
// orEqual == false && offset == 1 (Standard form)
// If the corresponding key is not in the underlying key range, it will move over the range
// The cache object is used to cache the first read result from the rpc call during the key resolution,
// then when we need to do key resolution or result filtering,
// we, instead of rpc call, read from this cache object have consistent results
															#line 130 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
namespace {
// This generated class is to be used only via moveKeySelectorOverRangeActor()
															#line 128 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
template <class MoveKeySelectorOverRangeActorActor>
															#line 128 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class MoveKeySelectorOverRangeActorActorState {
															#line 137 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
public:
															#line 128 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	MoveKeySelectorOverRangeActorActorState(const SpecialKeyRangeReadImpl* const& skrImpl,ReadYourWritesTransaction* const& ryw,KeySelector* const& ks,KeyRangeMap<Optional<RangeResult>>* const& cache) 
															#line 128 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
															#line 128 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		 : skrImpl(skrImpl),
															#line 128 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   ryw(ryw),
															#line 128 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   ks(ks),
															#line 128 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   cache(cache)
															#line 150 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
	{
		fdb_probe_actor_create("moveKeySelectorOverRangeActor", reinterpret_cast<unsigned long>(this));

	}
	~MoveKeySelectorOverRangeActorActorState() 
	{
		fdb_probe_actor_destroy("moveKeySelectorOverRangeActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 133 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ASSERT(!ks->orEqual);
															#line 136 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ASSERT(ks->offset != 1);
															#line 139 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (ryw->getTenant().present() && !skrImpl->supportsTenants())
															#line 169 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			{
															#line 140 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				CODE_PROBE(true, "Illegal tenant access to special keys module");
															#line 141 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				return a_body1Catch1(illegal_tenant_access(), loopDepth);
															#line 175 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			}
															#line 144 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			startKey = Key(skrImpl->getKeyRange().begin);
															#line 145 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			endKey = Key(skrImpl->getKeyRange().end);
															#line 146 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			result = RangeResult();
															#line 148 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (ks->offset < 1)
															#line 185 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			{
															#line 150 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (skrImpl->getKeyRange().contains(ks->getKey()))
															#line 189 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
				{
															#line 151 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					endKey = ks->getKey();
															#line 193 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
				}
			}
			else
			{
															#line 154 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (skrImpl->getKeyRange().contains(ks->getKey()))
															#line 200 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
				{
															#line 155 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					startKey = ks->getKey();
															#line 204 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
				}
			}
															#line 159 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ASSERT(startKey < endKey);
															#line 161 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			DisabledTraceEvent(SevDebug, "NormalizeKeySelector") .detail("OriginalKey", ks->getKey()) .detail("OriginalOffset", ks->offset) .detail("SpecialKeyRangeStart", skrImpl->getKeyRange().begin) .detail("SpecialKeyRangeEnd", skrImpl->getKeyRange().end);
															#line 167 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			GetRangeLimits limitsHint(ks->offset >= 1 ? ks->offset : 1 - ks->offset);
															#line 169 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (skrImpl->isAsync())
															#line 215 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			{
															#line 170 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				const SpecialKeyRangeAsyncImpl* ptr = dynamic_cast<const SpecialKeyRangeAsyncImpl*>(skrImpl);
															#line 171 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				StrictFuture<RangeResult> __when_expr_0 = ptr->getRange(ryw, KeyRangeRef(startKey, endKey), limitsHint, cache);
															#line 171 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (static_cast<MoveKeySelectorOverRangeActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 223 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<MoveKeySelectorOverRangeActorActor*>(this)->actor_wait_state = 1;
															#line 171 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MoveKeySelectorOverRangeActorActor, 0, RangeResult >*>(static_cast<MoveKeySelectorOverRangeActorActor*>(this)));
															#line 228 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 174 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				StrictFuture<RangeResult> __when_expr_1 = skrImpl->getRange(ryw, KeyRangeRef(startKey, endKey), limitsHint);
															#line 174 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (static_cast<MoveKeySelectorOverRangeActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 237 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
				static_cast<MoveKeySelectorOverRangeActorActor*>(this)->actor_wait_state = 2;
															#line 174 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MoveKeySelectorOverRangeActorActor, 1, RangeResult >*>(static_cast<MoveKeySelectorOverRangeActorActor*>(this)));
															#line 242 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MoveKeySelectorOverRangeActorActorState();
		static_cast<MoveKeySelectorOverRangeActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 178 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (result.size() == 0)
															#line 266 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		{
															#line 179 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			TraceEvent(SevDebug, "ZeroElementsIntheRange").detail("Start", startKey).detail("End", endKey);
															#line 180 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (!static_cast<MoveKeySelectorOverRangeActorActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~MoveKeySelectorOverRangeActorActorState(); static_cast<MoveKeySelectorOverRangeActorActor*>(this)->destroy(); return 0; }
															#line 272 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			new (&static_cast<MoveKeySelectorOverRangeActorActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~MoveKeySelectorOverRangeActorActorState();
			static_cast<MoveKeySelectorOverRangeActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 183 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (ks->offset < 1)
															#line 280 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		{
															#line 184 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (result.size() >= 1 - ks->offset)
															#line 284 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			{
															#line 185 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				ks->setKey(KeyRef(ks->arena(), result[result.size() - (1 - ks->offset)].key));
															#line 186 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				ks->offset = 1;
															#line 290 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			}
			else
			{
															#line 188 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				ks->setKey(KeyRef(ks->arena(), result[0].key));
															#line 189 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				ks->offset += result.size();
															#line 298 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			}
		}
		else
		{
															#line 192 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (result.size() >= ks->offset)
															#line 305 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			{
															#line 193 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				ks->setKey(KeyRef(ks->arena(), result[ks->offset - 1].key));
															#line 194 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				ks->offset = 1;
															#line 311 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			}
			else
			{
															#line 197 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				ks->setKey(KeyRef(ks->arena(), keyAfter(result[result.size() - 1].key)));
															#line 198 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				ks->offset -= result.size();
															#line 319 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			}
		}
															#line 201 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		DisabledTraceEvent(SevDebug, "NormalizeKeySelector") .detail("NormalizedKey", ks->getKey()) .detail("NormalizedOffset", ks->offset) .detail("SpecialKeyRangeStart", skrImpl->getKeyRange().begin) .detail("SpecialKeyRangeEnd", skrImpl->getKeyRange().end);
															#line 206 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<MoveKeySelectorOverRangeActorActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~MoveKeySelectorOverRangeActorActorState(); static_cast<MoveKeySelectorOverRangeActorActor*>(this)->destroy(); return 0; }
															#line 326 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		new (&static_cast<MoveKeySelectorOverRangeActorActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~MoveKeySelectorOverRangeActorActorState();
		static_cast<MoveKeySelectorOverRangeActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont7(RangeResult const& result_,int loopDepth) 
	{
															#line 172 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		result = result_;
															#line 338 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont7(RangeResult && result_,int loopDepth) 
	{
															#line 172 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		result = result_;
															#line 347 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(RangeResult const& result_,int loopDepth) 
	{
		loopDepth = a_body1cont7(result_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(RangeResult && result_,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(result_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MoveKeySelectorOverRangeActorActor*>(this)->actor_wait_state > 0) static_cast<MoveKeySelectorOverRangeActorActor*>(this)->actor_wait_state = 0;
		static_cast<MoveKeySelectorOverRangeActorActor*>(this)->ActorCallback< MoveKeySelectorOverRangeActorActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< MoveKeySelectorOverRangeActorActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("moveKeySelectorOverRangeActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MoveKeySelectorOverRangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("moveKeySelectorOverRangeActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MoveKeySelectorOverRangeActorActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("moveKeySelectorOverRangeActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MoveKeySelectorOverRangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("moveKeySelectorOverRangeActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MoveKeySelectorOverRangeActorActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("moveKeySelectorOverRangeActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MoveKeySelectorOverRangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("moveKeySelectorOverRangeActor", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont9(RangeResult const& result_,int loopDepth) 
	{
															#line 175 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		result = result_;
															#line 431 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont9(RangeResult && result_,int loopDepth) 
	{
															#line 175 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		result = result_;
															#line 440 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when2(RangeResult const& result_,int loopDepth) 
	{
		loopDepth = a_body1cont9(result_, loopDepth);

		return loopDepth;
	}
	int a_body1when2(RangeResult && result_,int loopDepth) 
	{
		loopDepth = a_body1cont9(std::move(result_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<MoveKeySelectorOverRangeActorActor*>(this)->actor_wait_state > 0) static_cast<MoveKeySelectorOverRangeActorActor*>(this)->actor_wait_state = 0;
		static_cast<MoveKeySelectorOverRangeActorActor*>(this)->ActorCallback< MoveKeySelectorOverRangeActorActor, 1, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< MoveKeySelectorOverRangeActorActor, 1, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("moveKeySelectorOverRangeActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MoveKeySelectorOverRangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("moveKeySelectorOverRangeActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MoveKeySelectorOverRangeActorActor, 1, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("moveKeySelectorOverRangeActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MoveKeySelectorOverRangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("moveKeySelectorOverRangeActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< MoveKeySelectorOverRangeActorActor, 1, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("moveKeySelectorOverRangeActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MoveKeySelectorOverRangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("moveKeySelectorOverRangeActor", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 128 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	const SpecialKeyRangeReadImpl* skrImpl;
															#line 128 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	ReadYourWritesTransaction* ryw;
															#line 128 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	KeySelector* ks;
															#line 128 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	KeyRangeMap<Optional<RangeResult>>* cache;
															#line 144 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	Key startKey;
															#line 145 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	Key endKey;
															#line 146 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	RangeResult result;
															#line 534 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
};
// This generated class is to be used only via moveKeySelectorOverRangeActor()
															#line 128 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class MoveKeySelectorOverRangeActorActor final : public Actor<Void>, public ActorCallback< MoveKeySelectorOverRangeActorActor, 0, RangeResult >, public ActorCallback< MoveKeySelectorOverRangeActorActor, 1, RangeResult >, public FastAllocated<MoveKeySelectorOverRangeActorActor>, public MoveKeySelectorOverRangeActorActorState<MoveKeySelectorOverRangeActorActor> {
															#line 539 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
public:
	using FastAllocated<MoveKeySelectorOverRangeActorActor>::operator new;
	using FastAllocated<MoveKeySelectorOverRangeActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5081213584881213952UL, 2545753388419461120UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MoveKeySelectorOverRangeActorActor, 0, RangeResult >;
friend struct ActorCallback< MoveKeySelectorOverRangeActorActor, 1, RangeResult >;
															#line 128 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	MoveKeySelectorOverRangeActorActor(const SpecialKeyRangeReadImpl* const& skrImpl,ReadYourWritesTransaction* const& ryw,KeySelector* const& ks,KeyRangeMap<Optional<RangeResult>>* const& cache) 
															#line 557 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		 : Actor<Void>(),
		   MoveKeySelectorOverRangeActorActorState<MoveKeySelectorOverRangeActorActor>(skrImpl, ryw, ks, cache),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("moveKeySelectorOverRangeActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16581637658165629440UL, 5960354244137475072UL);
		ActorExecutionContextHelper __helper(static_cast<MoveKeySelectorOverRangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("moveKeySelectorOverRangeActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("moveKeySelectorOverRangeActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MoveKeySelectorOverRangeActorActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< MoveKeySelectorOverRangeActorActor, 1, RangeResult >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 128 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
[[nodiscard]] Future<Void> moveKeySelectorOverRangeActor( const SpecialKeyRangeReadImpl* const& skrImpl, ReadYourWritesTransaction* const& ryw, KeySelector* const& ks, KeyRangeMap<Optional<RangeResult>>* const& cache ) {
															#line 128 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	return Future<Void>(new MoveKeySelectorOverRangeActorActor(skrImpl, ryw, ks, cache));
															#line 591 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
}

#line 208 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"

// This function will normalize the given KeySelector to a standard KeySelector:
// orEqual == false && offset == 1 (Standard form)
// If the corresponding key is outside the whole space, it will move to the begin or the end
// It does have overhead here since we query all keys twice in the worst case.
// However, moving the KeySelector while handling other parameters like limits makes the code much more complex and hard
// to maintain; Thus, separate each part to make the code easy to understand and more compact
// Boundary is the range of the legal key space, which, by default is the range of the module
// And (\xff\xff, \xff\xff\xff) if SPECIAL_KEY_SPACE_RELAXED is turned on
															#line 604 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
namespace {
// This generated class is to be used only via normalizeKeySelectorActor()
															#line 217 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
template <class NormalizeKeySelectorActorActor>
															#line 217 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class NormalizeKeySelectorActorActorState {
															#line 611 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
public:
															#line 217 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	NormalizeKeySelectorActorActorState(SpecialKeySpace* const& sks,ReadYourWritesTransaction* const& ryw,KeySelector* const& ks,KeyRangeRef const& boundary,int* const& actualOffset,RangeResult* const& result,KeyRangeMap<Optional<RangeResult>>* const& cache) 
															#line 217 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
															#line 217 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		 : sks(sks),
															#line 217 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   ryw(ryw),
															#line 217 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   ks(ks),
															#line 217 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   boundary(boundary),
															#line 217 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   actualOffset(actualOffset),
															#line 217 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   result(result),
															#line 217 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   cache(cache),
															#line 229 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   iter(ks->offset < 1 ? sks->getReadImpls().rangeContainingKeyBefore(ks->getKey()) : sks->getReadImpls().rangeContaining(ks->getKey()))
															#line 632 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
	{
		fdb_probe_actor_create("normalizeKeySelectorActor", reinterpret_cast<unsigned long>(this));

	}
	~NormalizeKeySelectorActorActorState() 
	{
		fdb_probe_actor_destroy("normalizeKeySelectorActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 232 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			;
															#line 647 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~NormalizeKeySelectorActorActorState();
		static_cast<NormalizeKeySelectorActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 248 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		*actualOffset = ks->offset;
															#line 250 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!ks->isFirstGreaterOrEqual())
															#line 672 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		{
															#line 251 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			TraceEvent(SevDebug, "ReadToBoundary") .detail("TerminateKey", ks->getKey()) .detail("TerminateOffset", ks->offset);
															#line 256 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (ks->offset < 1)
															#line 678 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			{
															#line 257 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				result->readToBegin = true;
															#line 258 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				ks->setKey(boundary.begin);
															#line 684 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			}
			else
			{
															#line 260 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				result->readThroughEnd = true;
															#line 261 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				ks->setKey(boundary.end);
															#line 692 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			}
															#line 263 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ks->offset = 1;
															#line 696 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		}
															#line 265 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<NormalizeKeySelectorActorActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~NormalizeKeySelectorActorActorState(); static_cast<NormalizeKeySelectorActorActor*>(this)->destroy(); return 0; }
															#line 700 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		new (&static_cast<NormalizeKeySelectorActorActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~NormalizeKeySelectorActorActorState();
		static_cast<NormalizeKeySelectorActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 232 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!((ks->offset < 1 && iter->begin() >= boundary.begin) || (ks->offset > 1 && iter->begin() < boundary.end)))
															#line 719 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 233 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (iter->value() != nullptr)
															#line 725 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		{
															#line 234 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			StrictFuture<Void> __when_expr_0 = moveKeySelectorOverRangeActor(iter->value(), ryw, ks, cache);
															#line 234 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (static_cast<NormalizeKeySelectorActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 731 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<NormalizeKeySelectorActorActor*>(this)->actor_wait_state = 1;
															#line 234 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< NormalizeKeySelectorActorActor, 0, Void >*>(static_cast<NormalizeKeySelectorActorActor*>(this)));
															#line 736 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 237 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (ks->offset < 1)
															#line 763 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		{
															#line 238 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (iter == sks->getReadImpls().ranges().begin())
															#line 767 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			{
				return a_body1break1(loopDepth==0?0:loopDepth-1); // break
			}
			else
			{
															#line 241 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				--iter;
															#line 775 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			}
		}
		else
		{
															#line 243 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (ks->offset > 1)
															#line 782 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			{
															#line 245 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				++iter;
															#line 786 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			}
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<NormalizeKeySelectorActorActor*>(this)->actor_wait_state > 0) static_cast<NormalizeKeySelectorActorActor*>(this)->actor_wait_state = 0;
		static_cast<NormalizeKeySelectorActorActor*>(this)->ActorCallback< NormalizeKeySelectorActorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< NormalizeKeySelectorActorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("normalizeKeySelectorActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NormalizeKeySelectorActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("normalizeKeySelectorActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< NormalizeKeySelectorActorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("normalizeKeySelectorActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NormalizeKeySelectorActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("normalizeKeySelectorActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< NormalizeKeySelectorActorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("normalizeKeySelectorActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<NormalizeKeySelectorActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("normalizeKeySelectorActor", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 217 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	SpecialKeySpace* sks;
															#line 217 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	ReadYourWritesTransaction* ryw;
															#line 217 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	KeySelector* ks;
															#line 217 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	KeyRangeRef boundary;
															#line 217 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	int* actualOffset;
															#line 217 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	RangeResult* result;
															#line 217 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	KeyRangeMap<Optional<RangeResult>>* cache;
															#line 229 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	RangeMap<Key, SpecialKeyRangeReadImpl*, KeyRangeRef>::iterator iter;
															#line 896 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
};
// This generated class is to be used only via normalizeKeySelectorActor()
															#line 217 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class NormalizeKeySelectorActorActor final : public Actor<Void>, public ActorCallback< NormalizeKeySelectorActorActor, 0, Void >, public FastAllocated<NormalizeKeySelectorActorActor>, public NormalizeKeySelectorActorActorState<NormalizeKeySelectorActorActor> {
															#line 901 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
public:
	using FastAllocated<NormalizeKeySelectorActorActor>::operator new;
	using FastAllocated<NormalizeKeySelectorActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16378374254794931200UL, 3955740761653720064UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< NormalizeKeySelectorActorActor, 0, Void >;
															#line 217 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	NormalizeKeySelectorActorActor(SpecialKeySpace* const& sks,ReadYourWritesTransaction* const& ryw,KeySelector* const& ks,KeyRangeRef const& boundary,int* const& actualOffset,RangeResult* const& result,KeyRangeMap<Optional<RangeResult>>* const& cache) 
															#line 918 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		 : Actor<Void>(),
		   NormalizeKeySelectorActorActorState<NormalizeKeySelectorActorActor>(sks, ryw, ks, boundary, actualOffset, result, cache),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("normalizeKeySelectorActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2217121789477885952UL, 10501505158022201600UL);
		ActorExecutionContextHelper __helper(static_cast<NormalizeKeySelectorActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("normalizeKeySelectorActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("normalizeKeySelectorActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< NormalizeKeySelectorActorActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 217 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
[[nodiscard]] Future<Void> normalizeKeySelectorActor( SpecialKeySpace* const& sks, ReadYourWritesTransaction* const& ryw, KeySelector* const& ks, KeyRangeRef const& boundary, int* const& actualOffset, RangeResult* const& result, KeyRangeMap<Optional<RangeResult>>* const& cache ) {
															#line 217 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	return Future<Void>(new NormalizeKeySelectorActorActor(sks, ryw, ks, boundary, actualOffset, result, cache));
															#line 951 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
}

#line 267 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"

SpecialKeySpace::SpecialKeySpace(KeyRef spaceStartKey, KeyRef spaceEndKey, bool testOnly)
  : readImpls(nullptr, spaceEndKey),
    modules(testOnly ? SpecialKeySpace::MODULE::TESTONLY : SpecialKeySpace::MODULE::UNKNOWN, spaceEndKey),
    writeImpls(nullptr, spaceEndKey), range(KeyRangeRef(spaceStartKey, spaceEndKey)) {
	// Default begin of KeyRangeMap is Key(), insert the range to update start key
	readImpls.insert(range, nullptr);
	writeImpls.insert(range, nullptr);
	if (!testOnly) {
		// testOnly is used in the correctness workload
		modulesBoundaryInit();
	}
}

void SpecialKeySpace::modulesBoundaryInit() {
	for (const auto& pair : moduleToBoundary) {
		ASSERT(range.contains(pair.second));
		// Make sure the module is not overlapping with any registered read modules
		// Note: same like ranges, one module's end cannot be another module's start, relax the condition if needed
		ASSERT(modules.rangeContaining(pair.second.begin) == modules.rangeContaining(pair.second.end) &&
		       modules[pair.second.begin] == SpecialKeySpace::MODULE::UNKNOWN);
		modules.insert(pair.second, pair.first);
		// Note: Due to underlying implementation, the insertion here is important to make cross_module_read being
		// handled correctly
		readImpls.insert(pair.second, nullptr);
		writeImpls.insert(pair.second, nullptr);
	}
}

															#line 984 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
// This generated class is to be used only via checkRYWValid()
															#line 296 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
template <class SpecialKeySpace_CheckRYWValidActor>
															#line 296 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class SpecialKeySpace_CheckRYWValidActorState {
															#line 990 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
public:
															#line 296 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	SpecialKeySpace_CheckRYWValidActorState(SpecialKeySpace* const& sks,ReadYourWritesTransaction* const& ryw,KeySelector const& begin,KeySelector const& end,GetRangeLimits const& limits,Reverse const& reverse) 
															#line 296 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
															#line 296 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		 : sks(sks),
															#line 296 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   ryw(ryw),
															#line 296 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   begin(begin),
															#line 296 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   end(end),
															#line 296 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   limits(limits),
															#line 296 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   reverse(reverse)
															#line 1007 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
	{
		fdb_probe_actor_create("checkRYWValid", reinterpret_cast<unsigned long>(this));

	}
	~SpecialKeySpace_CheckRYWValidActorState() 
	{
		fdb_probe_actor_destroy("checkRYWValid", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 302 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ASSERT(ryw);
															#line 304 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = SpecialKeySpace::getRangeAggregationActor(sks, ryw, begin, end, limits, reverse);
															#line 303 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (static_cast<SpecialKeySpace_CheckRYWValidActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1026 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
															#line 308 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			StrictFuture<Void> __when_expr_1 = ryw->resetFuture();
															#line 1030 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
			static_cast<SpecialKeySpace_CheckRYWValidActor*>(this)->actor_wait_state = 1;
															#line 304 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SpecialKeySpace_CheckRYWValidActor, 0, RangeResult >*>(static_cast<SpecialKeySpace_CheckRYWValidActor*>(this)));
															#line 308 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SpecialKeySpace_CheckRYWValidActor, 1, Void >*>(static_cast<SpecialKeySpace_CheckRYWValidActor*>(this)));
															#line 1037 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SpecialKeySpace_CheckRYWValidActorState();
		static_cast<SpecialKeySpace_CheckRYWValidActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(RangeResult const& result,int loopDepth) 
	{
															#line 306 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<SpecialKeySpace_CheckRYWValidActor*>(this)->SAV<RangeResult>::futures) { (void)(result); this->~SpecialKeySpace_CheckRYWValidActorState(); static_cast<SpecialKeySpace_CheckRYWValidActor*>(this)->destroy(); return 0; }
															#line 1060 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		new (&static_cast<SpecialKeySpace_CheckRYWValidActor*>(this)->SAV< RangeResult >::value()) RangeResult(result);
		this->~SpecialKeySpace_CheckRYWValidActorState();
		static_cast<SpecialKeySpace_CheckRYWValidActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(RangeResult && result,int loopDepth) 
	{
															#line 306 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<SpecialKeySpace_CheckRYWValidActor*>(this)->SAV<RangeResult>::futures) { (void)(result); this->~SpecialKeySpace_CheckRYWValidActorState(); static_cast<SpecialKeySpace_CheckRYWValidActor*>(this)->destroy(); return 0; }
															#line 1072 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		new (&static_cast<SpecialKeySpace_CheckRYWValidActor*>(this)->SAV< RangeResult >::value()) RangeResult(result);
		this->~SpecialKeySpace_CheckRYWValidActorState();
		static_cast<SpecialKeySpace_CheckRYWValidActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when2(Void const& _,int loopDepth) 
	{
															#line 309 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		return a_body1Catch1(internal_error(), loopDepth);
															#line 1084 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"

		return loopDepth;
	}
	int a_body1when2(Void && _,int loopDepth) 
	{
															#line 309 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		return a_body1Catch1(internal_error(), loopDepth);
															#line 1092 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SpecialKeySpace_CheckRYWValidActor*>(this)->actor_wait_state > 0) static_cast<SpecialKeySpace_CheckRYWValidActor*>(this)->actor_wait_state = 0;
		static_cast<SpecialKeySpace_CheckRYWValidActor*>(this)->ActorCallback< SpecialKeySpace_CheckRYWValidActor, 0, RangeResult >::remove();
		static_cast<SpecialKeySpace_CheckRYWValidActor*>(this)->ActorCallback< SpecialKeySpace_CheckRYWValidActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SpecialKeySpace_CheckRYWValidActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("checkRYWValid", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SpecialKeySpace_CheckRYWValidActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkRYWValid", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SpecialKeySpace_CheckRYWValidActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("checkRYWValid", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SpecialKeySpace_CheckRYWValidActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkRYWValid", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SpecialKeySpace_CheckRYWValidActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("checkRYWValid", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SpecialKeySpace_CheckRYWValidActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkRYWValid", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SpecialKeySpace_CheckRYWValidActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkRYWValid", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SpecialKeySpace_CheckRYWValidActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkRYWValid", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< SpecialKeySpace_CheckRYWValidActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkRYWValid", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SpecialKeySpace_CheckRYWValidActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkRYWValid", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< SpecialKeySpace_CheckRYWValidActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkRYWValid", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SpecialKeySpace_CheckRYWValidActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkRYWValid", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 296 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	SpecialKeySpace* sks;
															#line 296 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	ReadYourWritesTransaction* ryw;
															#line 296 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	KeySelector begin;
															#line 296 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	KeySelector end;
															#line 296 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	GetRangeLimits limits;
															#line 296 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	Reverse reverse;
															#line 1229 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
};
// This generated class is to be used only via checkRYWValid()
															#line 296 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class SpecialKeySpace_CheckRYWValidActor final : public Actor<RangeResult>, public ActorCallback< SpecialKeySpace_CheckRYWValidActor, 0, RangeResult >, public ActorCallback< SpecialKeySpace_CheckRYWValidActor, 1, Void >, public FastAllocated<SpecialKeySpace_CheckRYWValidActor>, public SpecialKeySpace_CheckRYWValidActorState<SpecialKeySpace_CheckRYWValidActor> {
															#line 1234 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
public:
	using FastAllocated<SpecialKeySpace_CheckRYWValidActor>::operator new;
	using FastAllocated<SpecialKeySpace_CheckRYWValidActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15032118385182363648UL, 5797033560593955328UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<RangeResult>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SpecialKeySpace_CheckRYWValidActor, 0, RangeResult >;
friend struct ActorCallback< SpecialKeySpace_CheckRYWValidActor, 1, Void >;
															#line 296 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	SpecialKeySpace_CheckRYWValidActor(SpecialKeySpace* const& sks,ReadYourWritesTransaction* const& ryw,KeySelector const& begin,KeySelector const& end,GetRangeLimits const& limits,Reverse const& reverse) 
															#line 1252 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		 : Actor<RangeResult>(),
		   SpecialKeySpace_CheckRYWValidActorState<SpecialKeySpace_CheckRYWValidActor>(sks, ryw, begin, end, limits, reverse),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkRYWValid", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(771692089335300352UL, 2740106847181895936UL);
		ActorExecutionContextHelper __helper(static_cast<SpecialKeySpace_CheckRYWValidActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkRYWValid");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkRYWValid", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SpecialKeySpace_CheckRYWValidActor, 0, RangeResult >*)0, actor_cancelled()); break;
		}

	}
};
															#line 296 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
[[nodiscard]] Future<RangeResult> SpecialKeySpace::checkRYWValid( SpecialKeySpace* const& sks, ReadYourWritesTransaction* const& ryw, KeySelector const& begin, KeySelector const& end, GetRangeLimits const& limits, Reverse const& reverse ) {
															#line 296 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	return Future<RangeResult>(new SpecialKeySpace_CheckRYWValidActor(sks, ryw, begin, end, limits, reverse));
															#line 1284 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
}

#line 313 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"

															#line 1289 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
// This generated class is to be used only via getRangeAggregationActor()
															#line 314 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
template <class SpecialKeySpace_GetRangeAggregationActorActor>
															#line 314 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class SpecialKeySpace_GetRangeAggregationActorActorState {
															#line 1295 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
public:
															#line 314 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	SpecialKeySpace_GetRangeAggregationActorActorState(SpecialKeySpace* const& sks,ReadYourWritesTransaction* const& ryw,KeySelector const& begin,KeySelector const& end,GetRangeLimits const& limits,Reverse const& reverse) 
															#line 314 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
															#line 314 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		 : sks(sks),
															#line 314 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   ryw(ryw),
															#line 314 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   begin(begin),
															#line 314 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   end(end),
															#line 314 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   limits(limits),
															#line 314 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   reverse(reverse),
															#line 322 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   result(),
															#line 323 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   pairs(),
															#line 324 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   iter(),
															#line 325 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   actualBeginOffset(),
															#line 326 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   actualEndOffset(),
															#line 327 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   moduleBoundary(),
															#line 330 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   cache(Optional<RangeResult>(), specialKeys.end)
															#line 1326 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
	{
		fdb_probe_actor_create("getRangeAggregationActor", reinterpret_cast<unsigned long>(this));

	}
	~SpecialKeySpace_GetRangeAggregationActorActorState() 
	{
		fdb_probe_actor_destroy("getRangeAggregationActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 332 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (ryw->specialKeySpaceRelaxed())
															#line 1341 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			{
															#line 333 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				moduleBoundary = sks->range;
															#line 1345 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			}
			else
			{
															#line 335 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				auto beginIter = sks->getModules().rangeContaining(begin.getKey());
															#line 336 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (beginIter->begin() <= end.getKey() && end.getKey() <= beginIter->end())
															#line 1353 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
				{
															#line 337 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					if (beginIter->value() == SpecialKeySpace::MODULE::UNKNOWN)
															#line 1357 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
					{
															#line 338 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						return a_body1Catch1(special_keys_no_module_found(), loopDepth);
															#line 1361 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
					}
					else
					{
															#line 340 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						moduleBoundary = beginIter->range();
															#line 1367 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
					}
				}
				else
				{
															#line 342 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					TraceEvent(SevInfo, "SpecialKeyCrossModuleRead") .detail("Begin", begin) .detail("End", end) .detail("BoundaryBegin", beginIter->begin()) .detail("BoundaryEnd", beginIter->end());
															#line 347 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					return a_body1Catch1(special_keys_cross_module_read(), loopDepth);
															#line 1376 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
				}
			}
															#line 351 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			StrictFuture<Void> __when_expr_0 = normalizeKeySelectorActor(sks, ryw, &begin, moduleBoundary, &actualBeginOffset, &result, &cache);
															#line 351 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1383 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->actor_wait_state = 1;
															#line 351 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SpecialKeySpace_GetRangeAggregationActorActor, 0, Void >*>(static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)));
															#line 1388 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SpecialKeySpace_GetRangeAggregationActorActorState();
		static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 352 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		StrictFuture<Void> __when_expr_1 = normalizeKeySelectorActor(sks, ryw, &end, moduleBoundary, &actualEndOffset, &result, &cache);
															#line 352 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1413 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->actor_wait_state = 2;
															#line 352 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SpecialKeySpace_GetRangeAggregationActorActor, 1, Void >*>(static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)));
															#line 1418 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 352 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		StrictFuture<Void> __when_expr_1 = normalizeKeySelectorActor(sks, ryw, &end, moduleBoundary, &actualEndOffset, &result, &cache);
															#line 352 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1429 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->actor_wait_state = 2;
															#line 352 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SpecialKeySpace_GetRangeAggregationActorActor, 1, Void >*>(static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)));
															#line 1434 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->actor_wait_state > 0) static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->actor_wait_state = 0;
		static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->ActorCallback< SpecialKeySpace_GetRangeAggregationActorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SpecialKeySpace_GetRangeAggregationActorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getRangeAggregationActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeAggregationActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SpecialKeySpace_GetRangeAggregationActorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getRangeAggregationActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeAggregationActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SpecialKeySpace_GetRangeAggregationActorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getRangeAggregationActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeAggregationActor", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont8(Void const& _,int loopDepth) 
	{
															#line 355 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (actualBeginOffset >= actualEndOffset && begin.getKey() >= end.getKey())
															#line 1518 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		{
															#line 356 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			CODE_PROBE(true, "inverted range");
															#line 357 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (!static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->SAV<RangeResult>::futures) { (void)(RangeResultRef(false, false)); this->~SpecialKeySpace_GetRangeAggregationActorActorState(); static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->destroy(); return 0; }
															#line 1524 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			new (&static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->SAV< RangeResult >::value()) RangeResult(RangeResultRef(false, false));
			this->~SpecialKeySpace_GetRangeAggregationActorActorState();
			static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 360 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (begin.getKey() == moduleBoundary.end || end.getKey() == moduleBoundary.begin)
															#line 1532 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		{
															#line 361 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			CODE_PROBE(true, "query touches begin or end");
															#line 362 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (!static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->SAV<RangeResult>::futures) { (void)(result); this->~SpecialKeySpace_GetRangeAggregationActorActorState(); static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->destroy(); return 0; }
															#line 1538 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			new (&static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->SAV< RangeResult >::value()) RangeResult(std::move(result)); // state_var_RVO
			this->~SpecialKeySpace_GetRangeAggregationActorActorState();
			static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 364 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		ranges = sks->getReadImpls().intersectingRanges(KeyRangeRef(begin.getKey(), end.getKey()));
															#line 370 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (ryw->getTenant().present())
															#line 1548 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		{
															#line 371 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			for( auto iter : ranges ) {
															#line 372 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (iter->value() == nullptr)
															#line 1554 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
				{
					continue;
				}
															#line 375 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (!iter->value()->supportsTenants())
															#line 1560 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
				{
															#line 376 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					CODE_PROBE(true, "Illegal tenant access to special keys module");
															#line 377 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					return a_body1Catch1(illegal_tenant_access(), loopDepth);
															#line 1566 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
				}
			}
		}
															#line 384 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		iter = reverse ? ranges.end() : ranges.begin();
															#line 385 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (reverse)
															#line 1574 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		{
															#line 386 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			;
															#line 1578 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			loopDepth = a_body1cont8loopHead1(loopDepth);
		}
		else
		{
															#line 418 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			iter = ranges.begin();
															#line 1585 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			loopDepth = a_body1cont8loopHead2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont8(Void && _,int loopDepth) 
	{
															#line 355 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (actualBeginOffset >= actualEndOffset && begin.getKey() >= end.getKey())
															#line 1595 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		{
															#line 356 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			CODE_PROBE(true, "inverted range");
															#line 357 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (!static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->SAV<RangeResult>::futures) { (void)(RangeResultRef(false, false)); this->~SpecialKeySpace_GetRangeAggregationActorActorState(); static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->destroy(); return 0; }
															#line 1601 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			new (&static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->SAV< RangeResult >::value()) RangeResult(RangeResultRef(false, false));
			this->~SpecialKeySpace_GetRangeAggregationActorActorState();
			static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 360 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (begin.getKey() == moduleBoundary.end || end.getKey() == moduleBoundary.begin)
															#line 1609 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		{
															#line 361 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			CODE_PROBE(true, "query touches begin or end");
															#line 362 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (!static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->SAV<RangeResult>::futures) { (void)(result); this->~SpecialKeySpace_GetRangeAggregationActorActorState(); static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->destroy(); return 0; }
															#line 1615 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			new (&static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->SAV< RangeResult >::value()) RangeResult(std::move(result)); // state_var_RVO
			this->~SpecialKeySpace_GetRangeAggregationActorActorState();
			static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 364 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		ranges = sks->getReadImpls().intersectingRanges(KeyRangeRef(begin.getKey(), end.getKey()));
															#line 370 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (ryw->getTenant().present())
															#line 1625 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		{
															#line 371 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			for( auto iter : ranges ) {
															#line 372 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (iter->value() == nullptr)
															#line 1631 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
				{
					continue;
				}
															#line 375 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (!iter->value()->supportsTenants())
															#line 1637 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
				{
															#line 376 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					CODE_PROBE(true, "Illegal tenant access to special keys module");
															#line 377 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					return a_body1Catch1(illegal_tenant_access(), loopDepth);
															#line 1643 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
				}
			}
		}
															#line 384 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		iter = reverse ? ranges.end() : ranges.begin();
															#line 385 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (reverse)
															#line 1651 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		{
															#line 386 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			;
															#line 1655 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			loopDepth = a_body1cont8loopHead1(loopDepth);
		}
		else
		{
															#line 418 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			iter = ranges.begin();
															#line 1662 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			loopDepth = a_body1cont8loopHead2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->actor_wait_state > 0) static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->actor_wait_state = 0;
		static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->ActorCallback< SpecialKeySpace_GetRangeAggregationActorActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SpecialKeySpace_GetRangeAggregationActorActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getRangeAggregationActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeAggregationActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< SpecialKeySpace_GetRangeAggregationActorActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getRangeAggregationActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeAggregationActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< SpecialKeySpace_GetRangeAggregationActorActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getRangeAggregationActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeAggregationActor", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont9(int loopDepth) 
	{
															#line 449 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->SAV<RangeResult>::futures) { (void)(result); this->~SpecialKeySpace_GetRangeAggregationActorActorState(); static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->destroy(); return 0; }
															#line 1747 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		new (&static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->SAV< RangeResult >::value()) RangeResult(std::move(result)); // state_var_RVO
		this->~SpecialKeySpace_GetRangeAggregationActorActorState();
		static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont16(int loopDepth) 
	{
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont8loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont8loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont8loopBody1(int loopDepth) 
	{
															#line 386 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!(iter != ranges.begin()))
															#line 1772 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		{
			return a_body1cont8break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 387 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		--iter;
															#line 388 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (iter->value() == nullptr)
															#line 1780 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		{
			return a_body1cont8loopHead1(loopDepth); // continue
		}
															#line 390 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		KeyRangeRef kr = iter->range();
															#line 391 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		KeyRef keyStart = kr.contains(begin.getKey()) ? begin.getKey() : kr.begin;
															#line 392 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		KeyRef keyEnd = kr.contains(end.getKey()) ? end.getKey() : kr.end;
															#line 393 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (iter->value()->isAsync() && cache.rangeContaining(keyStart).value().present())
															#line 1792 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		{
															#line 394 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			const SpecialKeyRangeAsyncImpl* ptr = dynamic_cast<const SpecialKeyRangeAsyncImpl*>(iter->value());
															#line 395 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			StrictFuture<RangeResult> __when_expr_2 = ptr->getRange(ryw, KeyRangeRef(keyStart, keyEnd), limits, &cache);
															#line 395 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1800 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont8loopBody1when1(__when_expr_2.get(), loopDepth); };
			static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->actor_wait_state = 3;
															#line 395 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< SpecialKeySpace_GetRangeAggregationActorActor, 2, RangeResult >*>(static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)));
															#line 1805 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 398 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			StrictFuture<RangeResult> __when_expr_3 = iter->value()->getRange(ryw, KeyRangeRef(keyStart, keyEnd), limits);
															#line 398 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1814 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont8loopBody1when2(__when_expr_3.get(), loopDepth); };
			static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->actor_wait_state = 4;
															#line 398 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< SpecialKeySpace_GetRangeAggregationActorActor, 3, RangeResult >*>(static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)));
															#line 1819 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont8break1(int loopDepth) 
	{
		try {
			return a_body1cont16(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont8loopBody1cont1(int loopDepth) 
	{
															#line 401 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		result.arena().dependsOn(pairs.arena());
															#line 403 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		for(int i = pairs.size() - 1;i >= 0;--i) {
															#line 404 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ASSERT(iter->range().contains(pairs[i].key));
															#line 405 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			result.push_back(result.arena(), pairs[i]);
															#line 409 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			limits.decrement(pairs[i]);
															#line 410 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (limits.isReached())
															#line 1852 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			{
															#line 411 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				result.more = true;
															#line 412 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				result.readToBegin = false;
															#line 413 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (!static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->SAV<RangeResult>::futures) { (void)(result); this->~SpecialKeySpace_GetRangeAggregationActorActorState(); static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->destroy(); return 0; }
															#line 1860 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
				new (&static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->SAV< RangeResult >::value()) RangeResult(std::move(result)); // state_var_RVO
				this->~SpecialKeySpace_GetRangeAggregationActorActorState();
				static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
		if (loopDepth == 0) return a_body1cont8loopHead1(0);

		return loopDepth;
	}
	int a_body1cont8loopBody1cont4(RangeResult const& pairs_,int loopDepth) 
	{
															#line 396 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		pairs = pairs_;
															#line 1875 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		loopDepth = a_body1cont8loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont8loopBody1cont4(RangeResult && pairs_,int loopDepth) 
	{
															#line 396 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		pairs = pairs_;
															#line 1884 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		loopDepth = a_body1cont8loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont8loopBody1when1(RangeResult const& pairs_,int loopDepth) 
	{
		loopDepth = a_body1cont8loopBody1cont4(pairs_, loopDepth);

		return loopDepth;
	}
	int a_body1cont8loopBody1when1(RangeResult && pairs_,int loopDepth) 
	{
		loopDepth = a_body1cont8loopBody1cont4(std::move(pairs_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->actor_wait_state > 0) static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->actor_wait_state = 0;
		static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->ActorCallback< SpecialKeySpace_GetRangeAggregationActorActor, 2, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< SpecialKeySpace_GetRangeAggregationActorActor, 2, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("getRangeAggregationActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont8loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeAggregationActor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< SpecialKeySpace_GetRangeAggregationActorActor, 2, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("getRangeAggregationActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont8loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeAggregationActor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< SpecialKeySpace_GetRangeAggregationActorActor, 2, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("getRangeAggregationActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeAggregationActor", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont8loopBody1cont6(RangeResult const& pairs_,int loopDepth) 
	{
															#line 399 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		pairs = pairs_;
															#line 1968 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		loopDepth = a_body1cont8loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont8loopBody1cont6(RangeResult && pairs_,int loopDepth) 
	{
															#line 399 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		pairs = pairs_;
															#line 1977 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		loopDepth = a_body1cont8loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont8loopBody1when2(RangeResult const& pairs_,int loopDepth) 
	{
		loopDepth = a_body1cont8loopBody1cont6(pairs_, loopDepth);

		return loopDepth;
	}
	int a_body1cont8loopBody1when2(RangeResult && pairs_,int loopDepth) 
	{
		loopDepth = a_body1cont8loopBody1cont6(std::move(pairs_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->actor_wait_state > 0) static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->actor_wait_state = 0;
		static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->ActorCallback< SpecialKeySpace_GetRangeAggregationActorActor, 3, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< SpecialKeySpace_GetRangeAggregationActorActor, 3, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("getRangeAggregationActor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont8loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeAggregationActor", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< SpecialKeySpace_GetRangeAggregationActorActor, 3, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("getRangeAggregationActor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont8loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeAggregationActor", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< SpecialKeySpace_GetRangeAggregationActorActor, 3, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("getRangeAggregationActor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeAggregationActor", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont17(int loopDepth) 
	{
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont8loopHead2(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont8loopBody2(loopDepth);

		return loopDepth;
	}
	int a_body1cont8loopBody2(int loopDepth) 
	{
															#line 418 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!(iter != ranges.end()))
															#line 2074 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		{
			return a_body1cont8break2(loopDepth==0?0:loopDepth-1); // break
		}
															#line 419 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (iter->value() == nullptr)
															#line 2080 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		{
			return a_body1cont8continue1(loopDepth); // continue
		}
															#line 421 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		KeyRangeRef kr = iter->range();
															#line 422 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		KeyRef keyStart = kr.contains(begin.getKey()) ? begin.getKey() : kr.begin;
															#line 423 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		KeyRef keyEnd = kr.contains(end.getKey()) ? end.getKey() : kr.end;
															#line 424 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (iter->value()->isAsync() && cache.rangeContaining(keyStart).value().present())
															#line 2092 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		{
															#line 425 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			const SpecialKeyRangeAsyncImpl* ptr = dynamic_cast<const SpecialKeyRangeAsyncImpl*>(iter->value());
															#line 426 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			StrictFuture<RangeResult> __when_expr_4 = ptr->getRange(ryw, KeyRangeRef(keyStart, keyEnd), limits, &cache);
															#line 426 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2100 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont8loopBody2when1(__when_expr_4.get(), loopDepth); };
			static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->actor_wait_state = 5;
															#line 426 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< SpecialKeySpace_GetRangeAggregationActorActor, 4, RangeResult >*>(static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)));
															#line 2105 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 429 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			StrictFuture<RangeResult> __when_expr_5 = iter->value()->getRange(ryw, KeyRangeRef(keyStart, keyEnd), limits);
															#line 429 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2114 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1cont8loopBody2when2(__when_expr_5.get(), loopDepth); };
			static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->actor_wait_state = 6;
															#line 429 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< SpecialKeySpace_GetRangeAggregationActorActor, 5, RangeResult >*>(static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)));
															#line 2119 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont8break2(int loopDepth) 
	{
		try {
			return a_body1cont17(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont8continue1(int loopDepth) 
	{
															#line 418 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		++iter;
															#line 2142 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont8loopHead2(0);

		return loopDepth;
	}
	int a_body1cont8loopBody2cont1(int loopDepth) 
	{
															#line 432 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		result.arena().dependsOn(pairs.arena());
															#line 434 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		for(int i = 0;i < pairs.size();++i) {
															#line 435 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ASSERT(iter->range().contains(pairs[i].key));
															#line 436 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			result.push_back(result.arena(), pairs[i]);
															#line 440 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			limits.decrement(pairs[i]);
															#line 441 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (limits.isReached())
															#line 2161 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			{
															#line 442 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				result.more = true;
															#line 443 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				result.readThroughEnd = false;
															#line 444 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (!static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->SAV<RangeResult>::futures) { (void)(result); this->~SpecialKeySpace_GetRangeAggregationActorActorState(); static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->destroy(); return 0; }
															#line 2169 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
				new (&static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->SAV< RangeResult >::value()) RangeResult(std::move(result)); // state_var_RVO
				this->~SpecialKeySpace_GetRangeAggregationActorActorState();
				static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 418 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		++iter;
															#line 2178 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont8loopHead2(0);

		return loopDepth;
	}
	int a_body1cont8loopBody2cont4(RangeResult const& pairs_,int loopDepth) 
	{
															#line 427 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		pairs = pairs_;
															#line 2187 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		loopDepth = a_body1cont8loopBody2cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont8loopBody2cont4(RangeResult && pairs_,int loopDepth) 
	{
															#line 427 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		pairs = pairs_;
															#line 2196 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		loopDepth = a_body1cont8loopBody2cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont8loopBody2when1(RangeResult const& pairs_,int loopDepth) 
	{
		loopDepth = a_body1cont8loopBody2cont4(pairs_, loopDepth);

		return loopDepth;
	}
	int a_body1cont8loopBody2when1(RangeResult && pairs_,int loopDepth) 
	{
		loopDepth = a_body1cont8loopBody2cont4(std::move(pairs_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->actor_wait_state > 0) static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->actor_wait_state = 0;
		static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->ActorCallback< SpecialKeySpace_GetRangeAggregationActorActor, 4, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< SpecialKeySpace_GetRangeAggregationActorActor, 4, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("getRangeAggregationActor", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont8loopBody2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeAggregationActor", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< SpecialKeySpace_GetRangeAggregationActorActor, 4, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("getRangeAggregationActor", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont8loopBody2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeAggregationActor", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< SpecialKeySpace_GetRangeAggregationActorActor, 4, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("getRangeAggregationActor", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeAggregationActor", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont8loopBody2cont6(RangeResult const& pairs_,int loopDepth) 
	{
															#line 430 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		pairs = pairs_;
															#line 2280 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		loopDepth = a_body1cont8loopBody2cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont8loopBody2cont6(RangeResult && pairs_,int loopDepth) 
	{
															#line 430 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		pairs = pairs_;
															#line 2289 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		loopDepth = a_body1cont8loopBody2cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont8loopBody2when2(RangeResult const& pairs_,int loopDepth) 
	{
		loopDepth = a_body1cont8loopBody2cont6(pairs_, loopDepth);

		return loopDepth;
	}
	int a_body1cont8loopBody2when2(RangeResult && pairs_,int loopDepth) 
	{
		loopDepth = a_body1cont8loopBody2cont6(std::move(pairs_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->actor_wait_state > 0) static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->actor_wait_state = 0;
		static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->ActorCallback< SpecialKeySpace_GetRangeAggregationActorActor, 5, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< SpecialKeySpace_GetRangeAggregationActorActor, 5, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("getRangeAggregationActor", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont8loopBody2when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeAggregationActor", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< SpecialKeySpace_GetRangeAggregationActorActor, 5, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("getRangeAggregationActor", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont8loopBody2when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeAggregationActor", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< SpecialKeySpace_GetRangeAggregationActorActor, 5, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("getRangeAggregationActor", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeAggregationActor", reinterpret_cast<unsigned long>(this), 5);

	}
															#line 314 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	SpecialKeySpace* sks;
															#line 314 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	ReadYourWritesTransaction* ryw;
															#line 314 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	KeySelector begin;
															#line 314 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	KeySelector end;
															#line 314 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	GetRangeLimits limits;
															#line 314 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	Reverse reverse;
															#line 322 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	RangeResult result;
															#line 323 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	RangeResult pairs;
															#line 324 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	RangeMap<Key, SpecialKeyRangeReadImpl*, KeyRangeRef>::iterator iter;
															#line 325 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	int actualBeginOffset;
															#line 326 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	int actualEndOffset;
															#line 327 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	KeyRangeRef moduleBoundary;
															#line 330 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	KeyRangeMap<Optional<RangeResult>> cache;
															#line 364 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	RangeMap<Key, SpecialKeyRangeReadImpl*, KeyRangeRef>::Ranges ranges;
															#line 2397 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
};
// This generated class is to be used only via getRangeAggregationActor()
															#line 314 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class SpecialKeySpace_GetRangeAggregationActorActor final : public Actor<RangeResult>, public ActorCallback< SpecialKeySpace_GetRangeAggregationActorActor, 0, Void >, public ActorCallback< SpecialKeySpace_GetRangeAggregationActorActor, 1, Void >, public ActorCallback< SpecialKeySpace_GetRangeAggregationActorActor, 2, RangeResult >, public ActorCallback< SpecialKeySpace_GetRangeAggregationActorActor, 3, RangeResult >, public ActorCallback< SpecialKeySpace_GetRangeAggregationActorActor, 4, RangeResult >, public ActorCallback< SpecialKeySpace_GetRangeAggregationActorActor, 5, RangeResult >, public FastAllocated<SpecialKeySpace_GetRangeAggregationActorActor>, public SpecialKeySpace_GetRangeAggregationActorActorState<SpecialKeySpace_GetRangeAggregationActorActor> {
															#line 2402 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
public:
	using FastAllocated<SpecialKeySpace_GetRangeAggregationActorActor>::operator new;
	using FastAllocated<SpecialKeySpace_GetRangeAggregationActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13726605992140516096UL, 6053729720956271104UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<RangeResult>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SpecialKeySpace_GetRangeAggregationActorActor, 0, Void >;
friend struct ActorCallback< SpecialKeySpace_GetRangeAggregationActorActor, 1, Void >;
friend struct ActorCallback< SpecialKeySpace_GetRangeAggregationActorActor, 2, RangeResult >;
friend struct ActorCallback< SpecialKeySpace_GetRangeAggregationActorActor, 3, RangeResult >;
friend struct ActorCallback< SpecialKeySpace_GetRangeAggregationActorActor, 4, RangeResult >;
friend struct ActorCallback< SpecialKeySpace_GetRangeAggregationActorActor, 5, RangeResult >;
															#line 314 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	SpecialKeySpace_GetRangeAggregationActorActor(SpecialKeySpace* const& sks,ReadYourWritesTransaction* const& ryw,KeySelector const& begin,KeySelector const& end,GetRangeLimits const& limits,Reverse const& reverse) 
															#line 2424 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		 : Actor<RangeResult>(),
		   SpecialKeySpace_GetRangeAggregationActorActorState<SpecialKeySpace_GetRangeAggregationActorActor>(sks, ryw, begin, end, limits, reverse),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getRangeAggregationActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3238308827241114624UL, 16709983472663675392UL);
		ActorExecutionContextHelper __helper(static_cast<SpecialKeySpace_GetRangeAggregationActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getRangeAggregationActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getRangeAggregationActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SpecialKeySpace_GetRangeAggregationActorActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< SpecialKeySpace_GetRangeAggregationActorActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< SpecialKeySpace_GetRangeAggregationActorActor, 2, RangeResult >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< SpecialKeySpace_GetRangeAggregationActorActor, 3, RangeResult >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< SpecialKeySpace_GetRangeAggregationActorActor, 4, RangeResult >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< SpecialKeySpace_GetRangeAggregationActorActor, 5, RangeResult >*)0, actor_cancelled()); break;
		}

	}
};
															#line 314 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
[[nodiscard]] Future<RangeResult> SpecialKeySpace::getRangeAggregationActor( SpecialKeySpace* const& sks, ReadYourWritesTransaction* const& ryw, KeySelector const& begin, KeySelector const& end, GetRangeLimits const& limits, Reverse const& reverse ) {
															#line 314 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	return Future<RangeResult>(new SpecialKeySpace_GetRangeAggregationActorActor(sks, ryw, begin, end, limits, reverse));
															#line 2461 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
}

#line 451 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"

Future<RangeResult> SpecialKeySpace::getRange(ReadYourWritesTransaction* ryw,
                                              KeySelector begin,
                                              KeySelector end,
                                              GetRangeLimits limits,
                                              Reverse reverse) {
	// validate limits here
	if (!limits.isValid())
		return range_limits_invalid();
	if (limits.isReached()) {
		CODE_PROBE(true, "Special Key Space range read limit 0");
		return RangeResult();
	}
	// make sure orEqual == false
	begin.removeOrEqual(begin.arena());
	end.removeOrEqual(end.arena());

	if (begin.offset >= end.offset && begin.getKey() >= end.getKey()) {
		CODE_PROBE(true, "range inverted");
		return RangeResult();
	}

	return checkRYWValid(this, ryw, begin, end, limits, reverse);
}

															#line 2490 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
// This generated class is to be used only via getActor()
															#line 476 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
template <class SpecialKeySpace_GetActorActor>
															#line 476 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class SpecialKeySpace_GetActorActorState {
															#line 2496 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
public:
															#line 476 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	SpecialKeySpace_GetActorActorState(SpecialKeySpace* const& sks,ReadYourWritesTransaction* const& ryw,KeyRef const& key) 
															#line 476 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
															#line 476 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		 : sks(sks),
															#line 476 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   ryw(ryw),
															#line 476 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   key(key)
															#line 2507 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
	{
		fdb_probe_actor_create("getActor", reinterpret_cast<unsigned long>(this));

	}
	~SpecialKeySpace_GetActorActorState() 
	{
		fdb_probe_actor_destroy("getActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 480 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = sks->getRange(ryw, KeySelector(firstGreaterOrEqual(key)), KeySelector(firstGreaterOrEqual(keyAfter(key))), GetRangeLimits(CLIENT_KNOBS->TOO_MANY), Reverse::False);
															#line 480 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (static_cast<SpecialKeySpace_GetActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2524 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<SpecialKeySpace_GetActorActor*>(this)->actor_wait_state = 1;
															#line 480 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SpecialKeySpace_GetActorActor, 0, RangeResult >*>(static_cast<SpecialKeySpace_GetActorActor*>(this)));
															#line 2529 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SpecialKeySpace_GetActorActorState();
		static_cast<SpecialKeySpace_GetActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(RangeResult const& result,int loopDepth) 
	{
															#line 485 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		ASSERT(result.size() <= 1);
															#line 486 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (result.size())
															#line 2554 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		{
															#line 487 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (!static_cast<SpecialKeySpace_GetActorActor*>(this)->SAV<Optional<Value>>::futures) { (void)(Optional<Value>(result[0].value)); this->~SpecialKeySpace_GetActorActorState(); static_cast<SpecialKeySpace_GetActorActor*>(this)->destroy(); return 0; }
															#line 2558 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			new (&static_cast<SpecialKeySpace_GetActorActor*>(this)->SAV< Optional<Value> >::value()) Optional<Value>(Optional<Value>(result[0].value));
			this->~SpecialKeySpace_GetActorActorState();
			static_cast<SpecialKeySpace_GetActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		else
		{
															#line 489 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (!static_cast<SpecialKeySpace_GetActorActor*>(this)->SAV<Optional<Value>>::futures) { (void)(Optional<Value>()); this->~SpecialKeySpace_GetActorActorState(); static_cast<SpecialKeySpace_GetActorActor*>(this)->destroy(); return 0; }
															#line 2568 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			new (&static_cast<SpecialKeySpace_GetActorActor*>(this)->SAV< Optional<Value> >::value()) Optional<Value>(Optional<Value>());
			this->~SpecialKeySpace_GetActorActorState();
			static_cast<SpecialKeySpace_GetActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}

		return loopDepth;
	}
	int a_body1cont1(RangeResult && result,int loopDepth) 
	{
															#line 485 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		ASSERT(result.size() <= 1);
															#line 486 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (result.size())
															#line 2583 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		{
															#line 487 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (!static_cast<SpecialKeySpace_GetActorActor*>(this)->SAV<Optional<Value>>::futures) { (void)(Optional<Value>(result[0].value)); this->~SpecialKeySpace_GetActorActorState(); static_cast<SpecialKeySpace_GetActorActor*>(this)->destroy(); return 0; }
															#line 2587 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			new (&static_cast<SpecialKeySpace_GetActorActor*>(this)->SAV< Optional<Value> >::value()) Optional<Value>(Optional<Value>(result[0].value));
			this->~SpecialKeySpace_GetActorActorState();
			static_cast<SpecialKeySpace_GetActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		else
		{
															#line 489 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (!static_cast<SpecialKeySpace_GetActorActor*>(this)->SAV<Optional<Value>>::futures) { (void)(Optional<Value>()); this->~SpecialKeySpace_GetActorActorState(); static_cast<SpecialKeySpace_GetActorActor*>(this)->destroy(); return 0; }
															#line 2597 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			new (&static_cast<SpecialKeySpace_GetActorActor*>(this)->SAV< Optional<Value> >::value()) Optional<Value>(Optional<Value>());
			this->~SpecialKeySpace_GetActorActorState();
			static_cast<SpecialKeySpace_GetActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}

		return loopDepth;
	}
	int a_body1when1(RangeResult const& result,int loopDepth) 
	{
		loopDepth = a_body1cont1(result, loopDepth);

		return loopDepth;
	}
	int a_body1when1(RangeResult && result,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SpecialKeySpace_GetActorActor*>(this)->actor_wait_state > 0) static_cast<SpecialKeySpace_GetActorActor*>(this)->actor_wait_state = 0;
		static_cast<SpecialKeySpace_GetActorActor*>(this)->ActorCallback< SpecialKeySpace_GetActorActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< SpecialKeySpace_GetActorActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("getActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SpecialKeySpace_GetActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SpecialKeySpace_GetActorActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("getActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SpecialKeySpace_GetActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SpecialKeySpace_GetActorActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("getActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SpecialKeySpace_GetActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getActor", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 476 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	SpecialKeySpace* sks;
															#line 476 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	ReadYourWritesTransaction* ryw;
															#line 476 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	KeyRef key;
															#line 2687 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
};
// This generated class is to be used only via getActor()
															#line 476 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class SpecialKeySpace_GetActorActor final : public Actor<Optional<Value>>, public ActorCallback< SpecialKeySpace_GetActorActor, 0, RangeResult >, public FastAllocated<SpecialKeySpace_GetActorActor>, public SpecialKeySpace_GetActorActorState<SpecialKeySpace_GetActorActor> {
															#line 2692 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
public:
	using FastAllocated<SpecialKeySpace_GetActorActor>::operator new;
	using FastAllocated<SpecialKeySpace_GetActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4964143675297138944UL, 13241041430302215168UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Optional<Value>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SpecialKeySpace_GetActorActor, 0, RangeResult >;
															#line 476 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	SpecialKeySpace_GetActorActor(SpecialKeySpace* const& sks,ReadYourWritesTransaction* const& ryw,KeyRef const& key) 
															#line 2709 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		 : Actor<Optional<Value>>(),
		   SpecialKeySpace_GetActorActorState<SpecialKeySpace_GetActorActor>(sks, ryw, key),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7181471174476362496UL, 1925644596793483776UL);
		ActorExecutionContextHelper __helper(static_cast<SpecialKeySpace_GetActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SpecialKeySpace_GetActorActor, 0, RangeResult >*)0, actor_cancelled()); break;
		}

	}
};
															#line 476 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
[[nodiscard]] Future<Optional<Value>> SpecialKeySpace::getActor( SpecialKeySpace* const& sks, ReadYourWritesTransaction* const& ryw, KeyRef const& key ) {
															#line 476 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	return Future<Optional<Value>>(new SpecialKeySpace_GetActorActor(sks, ryw, key));
															#line 2741 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
}

#line 492 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"

Future<Optional<Value>> SpecialKeySpace::get(ReadYourWritesTransaction* ryw, const Key& key) {
	return getActor(this, ryw, key);
}

void SpecialKeySpace::set(ReadYourWritesTransaction* ryw, const KeyRef& key, const ValueRef& value) {
	if (!ryw->specialKeySpaceChangeConfiguration())
		throw special_keys_write_disabled();
	auto impl = writeImpls[key];
	if (impl == nullptr) {
		TraceEvent(SevDebug, "SpecialKeySpaceNoWriteModuleFound")
		    .detail("Key", key.toString())
		    .detail("Value", value.toString());
		throw special_keys_no_write_module_found();
	}
	if (!impl->supportsTenants() && ryw->getTenant().present()) {
		CODE_PROBE(true, "Illegal tenant write to special keys module");
		throw illegal_tenant_access();
	}
	return impl->set(ryw, key, value);
}

void SpecialKeySpace::clear(ReadYourWritesTransaction* ryw, const KeyRangeRef& range) {
	if (!ryw->specialKeySpaceChangeConfiguration())
		throw special_keys_write_disabled();
	if (range.empty())
		return;
	auto begin = writeImpls[range.begin];
	auto end = writeImpls.rangeContainingKeyBefore(range.end)->value();
	if (begin != end) {
		TraceEvent(SevDebug, "SpecialKeySpaceCrossModuleClear").detail("Range", range);
		throw special_keys_cross_module_clear(); // ban cross module clear
	} else if (begin == nullptr) {
		TraceEvent(SevDebug, "SpecialKeySpaceNoWriteModuleFound").detail("Range", range);
		throw special_keys_no_write_module_found();
	}
	if (!begin->supportsTenants() && ryw->getTenant().present()) {
		CODE_PROBE(true, "Illegal tenant clear range to special keys module");
		throw illegal_tenant_access();
	}
	return begin->clear(ryw, range);
}

void SpecialKeySpace::clear(ReadYourWritesTransaction* ryw, const KeyRef& key) {
	if (!ryw->specialKeySpaceChangeConfiguration())
		throw special_keys_write_disabled();
	auto impl = writeImpls[key];
	if (impl == nullptr)
		throw special_keys_no_write_module_found();
	if (!impl->supportsTenants() && ryw->getTenant().present()) {
		CODE_PROBE(true, "Illegal tenant clear to special keys module", probe::decoration::rare);
		throw illegal_tenant_access();
	}
	return impl->clear(ryw, key);
}

bool validateSnakeCaseNaming(const KeyRef& k) {
	KeyRef key(k);
	// Remove prefix \xff\xff
	ASSERT(key.startsWith(specialKeys.begin));
	key = key.removePrefix(specialKeys.begin);
	// Suffix can be \xff\xff or \x00 in single key range
	if (key.endsWith(specialKeys.begin))
		key = key.removeSuffix(specialKeys.end);
	else if (key.endsWith("\x00"_sr))
		key = key.removeSuffix("\x00"_sr);
	for (const char& c : key.toString()) {
		// only small letters, numbers, '/', '_' is allowed
		ASSERT((c >= 'a' && c <= 'z') || (c >= '0' && c <= '9') || c == '/' || c == '_');
	}
	return true;
}

void SpecialKeySpace::registerKeyRange(SpecialKeySpace::MODULE module,
                                       SpecialKeySpace::IMPLTYPE type,
                                       const KeyRangeRef& kr,
                                       SpecialKeyRangeReadImpl* impl) {
	// Not allowed to register an empty range
	ASSERT(!kr.empty());
	// module boundary check
	if (module == SpecialKeySpace::MODULE::TESTONLY) {
		ASSERT(normalKeys.contains(kr));
	} else {
		ASSERT(moduleToBoundary.at(module).contains(kr));
		// validate keys follow snake case naming style
		ASSERT(validateSnakeCaseNaming(kr.begin) && validateSnakeCaseNaming(kr.end));
	}
	// make sure the registered range is not overlapping with existing ones
	// Note: kr.end should not be the same as another range's begin, although it should work even they are the same
	for (auto iter = readImpls.rangeContaining(kr.begin); true; ++iter) {
		ASSERT(iter->value() == nullptr);
		if (iter == readImpls.rangeContaining(kr.end)) {
			// Note: relax the condition that the end can be another range's start, if needed
			break;
		}
	}
	readImpls.insert(kr, impl);
	// if rw, it means the module can do both read and write
	if (type == SpecialKeySpace::IMPLTYPE::READWRITE) {
		// since write impls are always subset of read impls,
		// no need to check overlapped registration
		auto rwImpl = dynamic_cast<SpecialKeyRangeRWImpl*>(impl);
		ASSERT(rwImpl);
		writeImpls.insert(kr, rwImpl);
	}
}

Key SpecialKeySpace::decode(const KeyRef& key) {
	auto impl = writeImpls[key];
	ASSERT(impl != nullptr);
	return impl->decode(key);
}

KeyRange SpecialKeySpace::decode(const KeyRangeRef& kr) {
	// Only allow to decode key range in the same underlying impl range
	auto begin = writeImpls.rangeContaining(kr.begin);
	ASSERT(begin->value() != nullptr);
	auto end = writeImpls.rangeContainingKeyBefore(kr.end);
	ASSERT(begin == end);
	return KeyRangeRef(begin->value()->decode(kr.begin), begin->value()->decode(kr.end));
}

															#line 2867 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
namespace {
// This generated class is to be used only via commitActor()
															#line 614 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
template <class CommitActorActor>
															#line 614 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class CommitActorActorState {
															#line 2874 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
public:
															#line 614 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	CommitActorActorState(SpecialKeySpace* const& sks,ReadYourWritesTransaction* const& ryw) 
															#line 614 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
															#line 614 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		 : sks(sks),
															#line 614 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   ryw(ryw),
															#line 615 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   ranges(ryw->getSpecialKeySpaceWriteMap().containedRanges(specialKeys)),
															#line 617 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   iter(ranges.begin()),
															#line 618 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   writeModulePtrs()
															#line 2889 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
	{
		fdb_probe_actor_create("commitActor", reinterpret_cast<unsigned long>(this));

	}
	~CommitActorActorState() 
	{
		fdb_probe_actor_destroy("commitActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 619 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			std::unordered_set<SpecialKeyRangeRWImpl*> deduplicate;
															#line 620 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			for(;iter != ranges.end();) {
															#line 621 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				std::pair<bool, Optional<Value>> entry = iter->value();
															#line 622 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (entry.first)
															#line 2910 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
				{
															#line 623 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					auto modulePtr = sks->getRWImpls().rangeContaining(iter->begin())->value();
															#line 624 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					auto [_, inserted] = deduplicate.insert(modulePtr);
															#line 625 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					if (inserted)
															#line 2918 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
					{
															#line 626 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						writeModulePtrs.push_back(modulePtr);
															#line 2922 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
					}
				}
															#line 629 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				++iter;
															#line 2927 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			}
															#line 631 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			it = std::vector<SpecialKeyRangeRWImpl*>::const_iterator();
															#line 634 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (ryw->getTenant().present())
															#line 2933 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			{
															#line 635 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				for(it = writeModulePtrs.begin();it != writeModulePtrs.end();++it) {
															#line 636 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					if (!(*it)->supportsTenants())
															#line 2939 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
					{
															#line 637 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						CODE_PROBE(true, "Illegal tenant commit to special keys module", probe::decoration::rare);
															#line 638 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						return a_body1Catch1(illegal_tenant_access(), loopDepth);
															#line 2945 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
					}
				}
			}
															#line 643 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			it = writeModulePtrs.begin();
															#line 2951 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CommitActorActorState();
		static_cast<CommitActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 653 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<CommitActorActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CommitActorActorState(); static_cast<CommitActorActor*>(this)->destroy(); return 0; }
															#line 2974 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		new (&static_cast<CommitActorActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CommitActorActorState();
		static_cast<CommitActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 643 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!(it != writeModulePtrs.end()))
															#line 2993 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 644 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		StrictFuture<Optional<std::string>> __when_expr_0 = (*it)->commit(ryw);
															#line 644 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (static_cast<CommitActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3001 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<CommitActorActor*>(this)->actor_wait_state = 1;
															#line 644 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CommitActorActor, 0, Optional<std::string> >*>(static_cast<CommitActorActor*>(this)));
															#line 3006 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Optional<std::string> const& msg,int loopDepth) 
	{
															#line 645 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (msg.present())
															#line 3028 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		{
															#line 646 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ryw->setSpecialKeySpaceErrorMsg(msg.get());
															#line 647 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			TraceEvent(SevDebug, "SpecialKeySpaceManagementAPIError") .detail("Reason", msg.get()) .detail("Range", (*it)->getKeyRange().toString());
															#line 650 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			return a_body1Catch1(special_keys_api_failure(), std::max(0, loopDepth - 1));
															#line 3036 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		}
															#line 643 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		++it;
															#line 3040 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Optional<std::string> && msg,int loopDepth) 
	{
															#line 645 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (msg.present())
															#line 3049 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		{
															#line 646 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ryw->setSpecialKeySpaceErrorMsg(msg.get());
															#line 647 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			TraceEvent(SevDebug, "SpecialKeySpaceManagementAPIError") .detail("Reason", msg.get()) .detail("Range", (*it)->getKeyRange().toString());
															#line 650 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			return a_body1Catch1(special_keys_api_failure(), std::max(0, loopDepth - 1));
															#line 3057 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		}
															#line 643 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		++it;
															#line 3061 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<std::string> const& msg,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(msg, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<std::string> && msg,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(msg), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CommitActorActor*>(this)->actor_wait_state > 0) static_cast<CommitActorActor*>(this)->actor_wait_state = 0;
		static_cast<CommitActorActor*>(this)->ActorCallback< CommitActorActor, 0, Optional<std::string> >::remove();

	}
	void a_callback_fire(ActorCallback< CommitActorActor, 0, Optional<std::string> >*,Optional<std::string> const& value) 
	{
		fdb_probe_actor_enter("commitActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CommitActorActor, 0, Optional<std::string> >*,Optional<std::string> && value) 
	{
		fdb_probe_actor_enter("commitActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CommitActorActor, 0, Optional<std::string> >*,Error err) 
	{
		fdb_probe_actor_enter("commitActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CommitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitActor", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 614 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	SpecialKeySpace* sks;
															#line 614 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	ReadYourWritesTransaction* ryw;
															#line 615 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	RangeMap<Key, std::pair<bool, Optional<Value>>, KeyRangeRef>::Ranges ranges;
															#line 617 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	RangeMap<Key, std::pair<bool, Optional<Value>>, KeyRangeRef>::iterator iter;
															#line 618 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	std::vector<SpecialKeyRangeRWImpl*> writeModulePtrs;
															#line 631 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	std::vector<SpecialKeyRangeRWImpl*>::const_iterator it;
															#line 3153 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
};
// This generated class is to be used only via commitActor()
															#line 614 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class CommitActorActor final : public Actor<Void>, public ActorCallback< CommitActorActor, 0, Optional<std::string> >, public FastAllocated<CommitActorActor>, public CommitActorActorState<CommitActorActor> {
															#line 3158 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
public:
	using FastAllocated<CommitActorActor>::operator new;
	using FastAllocated<CommitActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9775607193803700736UL, 3978557147481251840UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CommitActorActor, 0, Optional<std::string> >;
															#line 614 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	CommitActorActor(SpecialKeySpace* const& sks,ReadYourWritesTransaction* const& ryw) 
															#line 3175 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		 : Actor<Void>(),
		   CommitActorActorState<CommitActorActor>(sks, ryw),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("commitActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12544606552870480896UL, 18376267601331500032UL);
		ActorExecutionContextHelper __helper(static_cast<CommitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("commitActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("commitActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CommitActorActor, 0, Optional<std::string> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 614 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
[[nodiscard]] Future<Void> commitActor( SpecialKeySpace* const& sks, ReadYourWritesTransaction* const& ryw ) {
															#line 614 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	return Future<Void>(new CommitActorActor(sks, ryw));
															#line 3208 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
}

#line 655 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"

Future<Void> SpecialKeySpace::commit(ReadYourWritesTransaction* ryw) {
	return commitActor(this, ryw);
}

// For SKSCTestRWImpl and SKSCTestAsyncReadImpl
Future<RangeResult> SKSCTestGetRangeBase(ReadYourWritesTransaction* ryw, KeyRangeRef kr, GetRangeLimits limitsHint) {
	auto resultFuture = ryw->getRange(kr, CLIENT_KNOBS->TOO_MANY);
	// all keys are written to RYW, since GRV is set, the read should happen locally
	ASSERT(resultFuture.isReady());
	auto result = resultFuture.getValue();
	ASSERT(!result.more && result.size() < CLIENT_KNOBS->TOO_MANY);
	auto kvs = resultFuture.getValue();
	return rywGetRange(ryw, kr, kvs);
}

SKSCTestRWImpl::SKSCTestRWImpl(KeyRangeRef kr) : SpecialKeyRangeRWImpl(kr) {}

Future<RangeResult> SKSCTestRWImpl::getRange(ReadYourWritesTransaction* ryw,
                                             KeyRangeRef kr,
                                             GetRangeLimits limitsHint) const {
	ASSERT(range.contains(kr));
	return SKSCTestGetRangeBase(ryw, kr, limitsHint);
}

Future<Optional<std::string>> SKSCTestRWImpl::commit(ReadYourWritesTransaction* ryw) {
	ASSERT(false);
	return Optional<std::string>();
}

SKSCTestAsyncReadImpl::SKSCTestAsyncReadImpl(KeyRangeRef kr) : SpecialKeyRangeAsyncImpl(kr) {}

Future<RangeResult> SKSCTestAsyncReadImpl::getRange(ReadYourWritesTransaction* ryw,
                                                    KeyRangeRef kr,
                                                    GetRangeLimits limitsHint) const {
	ASSERT(range.contains(kr));
	return SKSCTestGetRangeBase(ryw, kr, limitsHint);
}

ReadConflictRangeImpl::ReadConflictRangeImpl(KeyRangeRef kr) : SpecialKeyRangeReadImpl(kr) {}

															#line 3253 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
namespace {
// This generated class is to be used only via getReadConflictRangeImpl()
															#line 696 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
template <class GetReadConflictRangeImplActor>
															#line 696 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class GetReadConflictRangeImplActorState {
															#line 3260 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
public:
															#line 696 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	GetReadConflictRangeImplActorState(ReadYourWritesTransaction* const& ryw,KeyRange const& kr) 
															#line 696 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
															#line 696 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		 : ryw(ryw),
															#line 696 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   kr(kr)
															#line 3269 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
	{
		fdb_probe_actor_create("getReadConflictRangeImpl", reinterpret_cast<unsigned long>(this));

	}
	~GetReadConflictRangeImplActorState() 
	{
		fdb_probe_actor_destroy("getReadConflictRangeImpl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 697 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			StrictFuture<Void> __when_expr_0 = ryw->pendingReads();
															#line 697 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (static_cast<GetReadConflictRangeImplActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3286 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetReadConflictRangeImplActor*>(this)->actor_wait_state = 1;
															#line 697 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetReadConflictRangeImplActor, 0, Void >*>(static_cast<GetReadConflictRangeImplActor*>(this)));
															#line 3291 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetReadConflictRangeImplActorState();
		static_cast<GetReadConflictRangeImplActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 698 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<GetReadConflictRangeImplActor*>(this)->SAV<RangeResult>::futures) { (void)(ryw->getReadConflictRangeIntersecting(kr)); this->~GetReadConflictRangeImplActorState(); static_cast<GetReadConflictRangeImplActor*>(this)->destroy(); return 0; }
															#line 3314 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		new (&static_cast<GetReadConflictRangeImplActor*>(this)->SAV< RangeResult >::value()) RangeResult(ryw->getReadConflictRangeIntersecting(kr));
		this->~GetReadConflictRangeImplActorState();
		static_cast<GetReadConflictRangeImplActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 698 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<GetReadConflictRangeImplActor*>(this)->SAV<RangeResult>::futures) { (void)(ryw->getReadConflictRangeIntersecting(kr)); this->~GetReadConflictRangeImplActorState(); static_cast<GetReadConflictRangeImplActor*>(this)->destroy(); return 0; }
															#line 3326 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		new (&static_cast<GetReadConflictRangeImplActor*>(this)->SAV< RangeResult >::value()) RangeResult(ryw->getReadConflictRangeIntersecting(kr));
		this->~GetReadConflictRangeImplActorState();
		static_cast<GetReadConflictRangeImplActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetReadConflictRangeImplActor*>(this)->actor_wait_state > 0) static_cast<GetReadConflictRangeImplActor*>(this)->actor_wait_state = 0;
		static_cast<GetReadConflictRangeImplActor*>(this)->ActorCallback< GetReadConflictRangeImplActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetReadConflictRangeImplActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getReadConflictRangeImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetReadConflictRangeImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getReadConflictRangeImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetReadConflictRangeImplActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getReadConflictRangeImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetReadConflictRangeImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getReadConflictRangeImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetReadConflictRangeImplActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getReadConflictRangeImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetReadConflictRangeImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getReadConflictRangeImpl", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 696 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	ReadYourWritesTransaction* ryw;
															#line 696 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	KeyRange kr;
															#line 3413 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
};
// This generated class is to be used only via getReadConflictRangeImpl()
															#line 696 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class GetReadConflictRangeImplActor final : public Actor<RangeResult>, public ActorCallback< GetReadConflictRangeImplActor, 0, Void >, public FastAllocated<GetReadConflictRangeImplActor>, public GetReadConflictRangeImplActorState<GetReadConflictRangeImplActor> {
															#line 3418 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
public:
	using FastAllocated<GetReadConflictRangeImplActor>::operator new;
	using FastAllocated<GetReadConflictRangeImplActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8635008586174962432UL, 13205078191106581248UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<RangeResult>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetReadConflictRangeImplActor, 0, Void >;
															#line 696 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	GetReadConflictRangeImplActor(ReadYourWritesTransaction* const& ryw,KeyRange const& kr) 
															#line 3435 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		 : Actor<RangeResult>(),
		   GetReadConflictRangeImplActorState<GetReadConflictRangeImplActor>(ryw, kr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getReadConflictRangeImpl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16810417646147414272UL, 12854869489784131584UL);
		ActorExecutionContextHelper __helper(static_cast<GetReadConflictRangeImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getReadConflictRangeImpl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getReadConflictRangeImpl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetReadConflictRangeImplActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 696 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
[[nodiscard]] static Future<RangeResult> getReadConflictRangeImpl( ReadYourWritesTransaction* const& ryw, KeyRange const& kr ) {
															#line 696 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	return Future<RangeResult>(new GetReadConflictRangeImplActor(ryw, kr));
															#line 3468 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
}

#line 700 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"

Future<RangeResult> ReadConflictRangeImpl::getRange(ReadYourWritesTransaction* ryw,
                                                    KeyRangeRef kr,
                                                    GetRangeLimits limitsHint) const {
	return getReadConflictRangeImpl(ryw, kr);
}

WriteConflictRangeImpl::WriteConflictRangeImpl(KeyRangeRef kr) : SpecialKeyRangeReadImpl(kr) {}

Future<RangeResult> WriteConflictRangeImpl::getRange(ReadYourWritesTransaction* ryw,
                                                     KeyRangeRef kr,
                                                     GetRangeLimits limitsHint) const {
	return ryw->getWriteConflictRangeIntersecting(kr);
}

ConflictingKeysImpl::ConflictingKeysImpl(KeyRangeRef kr) : SpecialKeyRangeReadImpl(kr) {}

Future<RangeResult> ConflictingKeysImpl::getRange(ReadYourWritesTransaction* ryw,
                                                  KeyRangeRef kr,
                                                  GetRangeLimits limitsHint) const {
	RangeResult result;
	if (ryw->getTransactionState()->conflictingKeys) {
		auto krMapPtr = ryw->getTransactionState()->conflictingKeys.get();
		auto beginIter = krMapPtr->rangeContaining(kr.begin);
		auto endIter = krMapPtr->rangeContaining(kr.end);

		if (!kr.contains(beginIter->begin()) && beginIter != endIter)
			++beginIter;
		for (auto it = beginIter; it != endIter; ++it) {
			result.push_back_deep(result.arena(), KeyValueRef(it->begin(), it->value()));
		}
		if (kr.contains(endIter->begin()))
			result.push_back_deep(result.arena(), KeyValueRef(endIter->begin(), endIter->value()));
	}
	return result;
}

															#line 3509 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
namespace {
// This generated class is to be used only via ddMetricsGetRangeActor()
															#line 737 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
template <class DdMetricsGetRangeActorActor>
															#line 737 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class DdMetricsGetRangeActorActorState {
															#line 3516 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
public:
															#line 737 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	DdMetricsGetRangeActorActorState(ReadYourWritesTransaction* const& ryw,KeyRangeRef const& kr) 
															#line 737 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
															#line 737 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		 : ryw(ryw),
															#line 737 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   kr(kr)
															#line 3525 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
	{
		fdb_probe_actor_create("ddMetricsGetRangeActor", reinterpret_cast<unsigned long>(this));

	}
	~DdMetricsGetRangeActorActorState() 
	{
		fdb_probe_actor_destroy("ddMetricsGetRangeActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 738 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			;
															#line 3540 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DdMetricsGetRangeActorActorState();
		static_cast<DdMetricsGetRangeActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 740 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			auto keys = kr.removePrefix(ddStatsRange.begin);
															#line 741 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			StrictFuture<Standalone<VectorRef<DDMetricsRef>>> __when_expr_0 = waitDataDistributionMetricsList(ryw->getDatabase(), keys, CLIENT_KNOBS->TOO_MANY);
															#line 741 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (static_cast<DdMetricsGetRangeActorActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3575 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DdMetricsGetRangeActorActor*>(this)->actor_wait_state = 1;
															#line 741 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DdMetricsGetRangeActorActor, 0, Standalone<VectorRef<DDMetricsRef>> >*>(static_cast<DdMetricsGetRangeActorActor*>(this)));
															#line 3580 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 758 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			err = Error(e);
															#line 759 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (e.code() == error_code_dd_not_found)
															#line 3598 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			{
															#line 760 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				TraceEvent(SevWarnAlways, "DataDistributorNotPresent") .detail("Operation", "DDMetricsReqestThroughSpecialKeys");
															#line 762 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				StrictFuture<Void> __when_expr_1 = delayJittered(FLOW_KNOBS->PREVENT_FAST_SPIN_DELAY);
															#line 762 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (static_cast<DdMetricsGetRangeActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3606 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
				static_cast<DdMetricsGetRangeActorActor*>(this)->actor_wait_state = 2;
															#line 762 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DdMetricsGetRangeActorActor, 1, Void >*>(static_cast<DdMetricsGetRangeActorActor*>(this)));
															#line 3611 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1loopBody1Catch1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Standalone<VectorRef<DDMetricsRef>> const& resultWithoutPrefix,int loopDepth) 
	{
															#line 743 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		RangeResult result;
															#line 744 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		for( const auto& ddMetricsRef : resultWithoutPrefix ) {
															#line 746 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			KeyRef beginKey = ddMetricsRef.beginKey.withPrefix(ddStatsRange.begin, result.arena());
															#line 748 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			json_spirit::mObject statsObj;
															#line 749 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			statsObj["shard_bytes"] = ddMetricsRef.shardBytes;
															#line 750 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			statsObj["shard_bytes_per_ksecond"] = ddMetricsRef.shardBytesPerKSecond;
															#line 751 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			std::string statsString = json_spirit::write_string(json_spirit::mValue(statsObj), json_spirit::Output_options::raw_utf8);
															#line 753 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ValueRef bytes(result.arena(), statsString);
															#line 754 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			result.push_back(result.arena(), KeyValueRef(beginKey, bytes));
															#line 3647 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		}
															#line 756 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<DdMetricsGetRangeActorActor*>(this)->SAV<RangeResult>::futures) { (void)(result); this->~DdMetricsGetRangeActorActorState(); static_cast<DdMetricsGetRangeActorActor*>(this)->destroy(); return 0; }
															#line 3651 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		new (&static_cast<DdMetricsGetRangeActorActor*>(this)->SAV< RangeResult >::value()) RangeResult(result);
		this->~DdMetricsGetRangeActorActorState();
		static_cast<DdMetricsGetRangeActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Standalone<VectorRef<DDMetricsRef>> && resultWithoutPrefix,int loopDepth) 
	{
															#line 743 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		RangeResult result;
															#line 744 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		for( const auto& ddMetricsRef : resultWithoutPrefix ) {
															#line 746 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			KeyRef beginKey = ddMetricsRef.beginKey.withPrefix(ddStatsRange.begin, result.arena());
															#line 748 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			json_spirit::mObject statsObj;
															#line 749 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			statsObj["shard_bytes"] = ddMetricsRef.shardBytes;
															#line 750 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			statsObj["shard_bytes_per_ksecond"] = ddMetricsRef.shardBytesPerKSecond;
															#line 751 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			std::string statsString = json_spirit::write_string(json_spirit::mValue(statsObj), json_spirit::Output_options::raw_utf8);
															#line 753 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ValueRef bytes(result.arena(), statsString);
															#line 754 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			result.push_back(result.arena(), KeyValueRef(beginKey, bytes));
															#line 3679 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		}
															#line 756 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<DdMetricsGetRangeActorActor*>(this)->SAV<RangeResult>::futures) { (void)(result); this->~DdMetricsGetRangeActorActorState(); static_cast<DdMetricsGetRangeActorActor*>(this)->destroy(); return 0; }
															#line 3683 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		new (&static_cast<DdMetricsGetRangeActorActor*>(this)->SAV< RangeResult >::value()) RangeResult(result);
		this->~DdMetricsGetRangeActorActorState();
		static_cast<DdMetricsGetRangeActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Standalone<VectorRef<DDMetricsRef>> const& resultWithoutPrefix,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(resultWithoutPrefix, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Standalone<VectorRef<DDMetricsRef>> && resultWithoutPrefix,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(resultWithoutPrefix), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DdMetricsGetRangeActorActor*>(this)->actor_wait_state > 0) static_cast<DdMetricsGetRangeActorActor*>(this)->actor_wait_state = 0;
		static_cast<DdMetricsGetRangeActorActor*>(this)->ActorCallback< DdMetricsGetRangeActorActor, 0, Standalone<VectorRef<DDMetricsRef>> >::remove();

	}
	void a_callback_fire(ActorCallback< DdMetricsGetRangeActorActor, 0, Standalone<VectorRef<DDMetricsRef>> >*,Standalone<VectorRef<DDMetricsRef>> const& value) 
	{
		fdb_probe_actor_enter("ddMetricsGetRangeActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DdMetricsGetRangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ddMetricsGetRangeActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DdMetricsGetRangeActorActor, 0, Standalone<VectorRef<DDMetricsRef>> >*,Standalone<VectorRef<DDMetricsRef>> && value) 
	{
		fdb_probe_actor_enter("ddMetricsGetRangeActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DdMetricsGetRangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ddMetricsGetRangeActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DdMetricsGetRangeActorActor, 0, Standalone<VectorRef<DDMetricsRef>> >*,Error err) 
	{
		fdb_probe_actor_enter("ddMetricsGetRangeActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DdMetricsGetRangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ddMetricsGetRangeActor", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(int loopDepth) 
	{
															#line 765 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		return a_body1Catch1(err, std::max(0, loopDepth - 1));
															#line 3770 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2(Void const& _,int loopDepth) 
	{
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2(Void && _,int loopDepth) 
	{
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DdMetricsGetRangeActorActor*>(this)->actor_wait_state > 0) static_cast<DdMetricsGetRangeActorActor*>(this)->actor_wait_state = 0;
		static_cast<DdMetricsGetRangeActorActor*>(this)->ActorCallback< DdMetricsGetRangeActorActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DdMetricsGetRangeActorActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("ddMetricsGetRangeActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DdMetricsGetRangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ddMetricsGetRangeActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DdMetricsGetRangeActorActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("ddMetricsGetRangeActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DdMetricsGetRangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ddMetricsGetRangeActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DdMetricsGetRangeActorActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("ddMetricsGetRangeActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DdMetricsGetRangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ddMetricsGetRangeActor", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 737 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	ReadYourWritesTransaction* ryw;
															#line 737 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	KeyRangeRef kr;
															#line 758 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	Error err;
															#line 3867 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
};
// This generated class is to be used only via ddMetricsGetRangeActor()
															#line 737 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class DdMetricsGetRangeActorActor final : public Actor<RangeResult>, public ActorCallback< DdMetricsGetRangeActorActor, 0, Standalone<VectorRef<DDMetricsRef>> >, public ActorCallback< DdMetricsGetRangeActorActor, 1, Void >, public FastAllocated<DdMetricsGetRangeActorActor>, public DdMetricsGetRangeActorActorState<DdMetricsGetRangeActorActor> {
															#line 3872 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
public:
	using FastAllocated<DdMetricsGetRangeActorActor>::operator new;
	using FastAllocated<DdMetricsGetRangeActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(18114406886379119872UL, 9248242053678043136UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<RangeResult>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DdMetricsGetRangeActorActor, 0, Standalone<VectorRef<DDMetricsRef>> >;
friend struct ActorCallback< DdMetricsGetRangeActorActor, 1, Void >;
															#line 737 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	DdMetricsGetRangeActorActor(ReadYourWritesTransaction* const& ryw,KeyRangeRef const& kr) 
															#line 3890 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		 : Actor<RangeResult>(),
		   DdMetricsGetRangeActorActorState<DdMetricsGetRangeActorActor>(ryw, kr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("ddMetricsGetRangeActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16840869640598210816UL, 9829802680711520256UL);
		ActorExecutionContextHelper __helper(static_cast<DdMetricsGetRangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("ddMetricsGetRangeActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("ddMetricsGetRangeActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DdMetricsGetRangeActorActor, 0, Standalone<VectorRef<DDMetricsRef>> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DdMetricsGetRangeActorActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 737 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
[[nodiscard]] Future<RangeResult> ddMetricsGetRangeActor( ReadYourWritesTransaction* const& ryw, KeyRangeRef const& kr ) {
															#line 737 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	return Future<RangeResult>(new DdMetricsGetRangeActorActor(ryw, kr));
															#line 3924 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
}

#line 769 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"

DDStatsRangeImpl::DDStatsRangeImpl(KeyRangeRef kr) : SpecialKeyRangeAsyncImpl(kr) {}

Future<RangeResult> DDStatsRangeImpl::getRange(ReadYourWritesTransaction* ryw,
                                               KeyRangeRef kr,
                                               GetRangeLimits limitsHint) const {
	return ddMetricsGetRangeActor(ryw, kr);
}

Key SpecialKeySpace::getManagementApiCommandOptionSpecialKey(const std::string& command, const std::string& option) {
	Key prefix = "options/"_sr.withPrefix(moduleToBoundary[MODULE::MANAGEMENT].begin);
	auto pair = command + "/" + option;
	ASSERT(options.find(pair) != options.end());
	return prefix.withSuffix(pair);
}

ManagementCommandsOptionsImpl::ManagementCommandsOptionsImpl(KeyRangeRef kr) : SpecialKeyRangeRWImpl(kr) {}

Future<RangeResult> ManagementCommandsOptionsImpl::getRange(ReadYourWritesTransaction* ryw,
                                                            KeyRangeRef kr,
                                                            GetRangeLimits limitsHint) const {
	RangeResult result;
	// Since we only have limit number of options, a brute force loop here is enough
	for (const auto& option : SpecialKeySpace::getManagementApiOptionsSet()) {
		auto key = getKeyRange().begin.withSuffix(option);
		// ignore all invalid keys
		auto r = ryw->getSpecialKeySpaceWriteMap()[key];
		if (kr.contains(key) && r.first && r.second.present()) {
			result.push_back(result.arena(), KeyValueRef(key, ValueRef()));
			result.arena().dependsOn(key.arena());
		}
	}
	return result;
}

void ManagementCommandsOptionsImpl::set(ReadYourWritesTransaction* ryw, const KeyRef& key, const ValueRef& value) {
	std::string option = key.removePrefix(getKeyRange().begin).toString();
	// ignore all invalid keys
	if (SpecialKeySpace::getManagementApiOptionsSet().find(option) !=
	    SpecialKeySpace::getManagementApiOptionsSet().end()) {
		TraceEvent(SevDebug, "ManagementApiOption").detail("Option", option).detail("Key", key);
		ryw->getSpecialKeySpaceWriteMap().insert(key, std::make_pair(true, Optional<Value>(value)));
	}
}

void ManagementCommandsOptionsImpl::clear(ReadYourWritesTransaction* ryw, const KeyRangeRef& range) {
	ryw->getSpecialKeySpaceWriteMap().rawErase(range);
}

void ManagementCommandsOptionsImpl::clear(ReadYourWritesTransaction* ryw, const KeyRef& key) {
	std::string option = key.removePrefix(getKeyRange().begin).toString();
	// ignore all invalid keys
	if (SpecialKeySpace::getManagementApiOptionsSet().find(option) !=
	    SpecialKeySpace::getManagementApiOptionsSet().end()) {
		ryw->getSpecialKeySpaceWriteMap().rawErase(singleKeyRange(key));
	}
}

Future<Optional<std::string>> ManagementCommandsOptionsImpl::commit(ReadYourWritesTransaction* ryw) {
	// Nothing to do, keys should be used by other impls' commit callback
	return Optional<std::string>();
}

RangeResult rywGetRange(ReadYourWritesTransaction* ryw, const KeyRangeRef& kr, const RangeResult& res) {
	// "res" is the read result regardless of your writes, if ryw disabled, return immediately
	if (ryw->readYourWritesDisabled())
		return res;
	// If ryw enabled, we update it with writes from the transaction
	RangeResult result;
	RangeMap<Key, std::pair<bool, Optional<Value>>, KeyRangeRef>::Ranges ranges =
	    ryw->getSpecialKeySpaceWriteMap().containedRanges(kr);
	RangeMap<Key, std::pair<bool, Optional<Value>>, KeyRangeRef>::iterator iter = ranges.begin();
	auto iter2 = res.begin();
	result.arena().dependsOn(res.arena());
	while (iter != ranges.end() || iter2 != res.end()) {
		if (iter == ranges.end()) {
			result.push_back(result.arena(), KeyValueRef(iter2->key, iter2->value));
			++iter2;
		} else if (iter2 == res.end()) {
			// insert if it is a set entry
			std::pair<bool, Optional<Value>> entry = iter->value();
			if (entry.first && entry.second.present()) {
				result.push_back_deep(result.arena(), KeyValueRef(iter->begin(), entry.second.get()));
			}
			++iter;
		} else if (iter->range().contains(iter2->key)) {
			std::pair<bool, Optional<Value>> entry = iter->value();
			// if this is a valid range either for set or clear, move iter2 outside the range
			if (entry.first) {
				// insert if this is a set entry
				if (entry.second.present())
					result.push_back_deep(result.arena(), KeyValueRef(iter->begin(), entry.second.get()));
				// move iter2 outside the range
				while (iter2 != res.end() && iter->range().contains(iter2->key))
					++iter2;
			}
			++iter;
		} else if (iter->begin() > iter2->key) {
			result.push_back(result.arena(), KeyValueRef(iter2->key, iter2->value));
			++iter2;
		} else if (iter->end() <= iter2->key) {
			// insert if it is a set entry
			std::pair<bool, Optional<Value>> entry = iter->value();
			if (entry.first && entry.second.present()) {
				result.push_back_deep(result.arena(), KeyValueRef(iter->begin(), entry.second.get()));
			}
			++iter;
		}
	}
	return result;
}

// read from those readwrite modules in which special keys have one-to-one mapping with real persisted keys
															#line 4041 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
namespace {
// This generated class is to be used only via rwModuleWithMappingGetRangeActor()
															#line 882 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
template <class RwModuleWithMappingGetRangeActorActor>
															#line 882 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class RwModuleWithMappingGetRangeActorActorState {
															#line 4048 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
public:
															#line 882 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	RwModuleWithMappingGetRangeActorActorState(ReadYourWritesTransaction* const& ryw,const SpecialKeyRangeRWImpl* const& impl,KeyRangeRef const& kr) 
															#line 882 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
															#line 882 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		 : ryw(ryw),
															#line 882 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   impl(impl),
															#line 882 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   kr(kr)
															#line 4059 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
	{
		fdb_probe_actor_create("rwModuleWithMappingGetRangeActor", reinterpret_cast<unsigned long>(this));

	}
	~RwModuleWithMappingGetRangeActorActorState() 
	{
		fdb_probe_actor_destroy("rwModuleWithMappingGetRangeActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 885 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = ryw->getTransaction().getRange(ryw->getDatabase()->specialKeySpace->decode(kr), CLIENT_KNOBS->TOO_MANY);
															#line 885 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (static_cast<RwModuleWithMappingGetRangeActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4076 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RwModuleWithMappingGetRangeActorActor*>(this)->actor_wait_state = 1;
															#line 885 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RwModuleWithMappingGetRangeActorActor, 0, RangeResult >*>(static_cast<RwModuleWithMappingGetRangeActorActor*>(this)));
															#line 4081 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RwModuleWithMappingGetRangeActorActorState();
		static_cast<RwModuleWithMappingGetRangeActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(RangeResult const& resultWithoutPrefix,int loopDepth) 
	{
															#line 887 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		ASSERT(!resultWithoutPrefix.more && resultWithoutPrefix.size() < CLIENT_KNOBS->TOO_MANY);
															#line 888 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		RangeResult result;
															#line 889 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		for( const KeyValueRef& kv : resultWithoutPrefix ) {
															#line 890 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			result.push_back_deep(result.arena(), KeyValueRef(impl->encode(kv.key), kv.value));
															#line 4110 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		}
															#line 891 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<RwModuleWithMappingGetRangeActorActor*>(this)->SAV<RangeResult>::futures) { (void)(rywGetRange(ryw, kr, result)); this->~RwModuleWithMappingGetRangeActorActorState(); static_cast<RwModuleWithMappingGetRangeActorActor*>(this)->destroy(); return 0; }
															#line 4114 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		new (&static_cast<RwModuleWithMappingGetRangeActorActor*>(this)->SAV< RangeResult >::value()) RangeResult(rywGetRange(ryw, kr, result));
		this->~RwModuleWithMappingGetRangeActorActorState();
		static_cast<RwModuleWithMappingGetRangeActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(RangeResult && resultWithoutPrefix,int loopDepth) 
	{
															#line 887 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		ASSERT(!resultWithoutPrefix.more && resultWithoutPrefix.size() < CLIENT_KNOBS->TOO_MANY);
															#line 888 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		RangeResult result;
															#line 889 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		for( const KeyValueRef& kv : resultWithoutPrefix ) {
															#line 890 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			result.push_back_deep(result.arena(), KeyValueRef(impl->encode(kv.key), kv.value));
															#line 4132 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		}
															#line 891 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<RwModuleWithMappingGetRangeActorActor*>(this)->SAV<RangeResult>::futures) { (void)(rywGetRange(ryw, kr, result)); this->~RwModuleWithMappingGetRangeActorActorState(); static_cast<RwModuleWithMappingGetRangeActorActor*>(this)->destroy(); return 0; }
															#line 4136 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		new (&static_cast<RwModuleWithMappingGetRangeActorActor*>(this)->SAV< RangeResult >::value()) RangeResult(rywGetRange(ryw, kr, result));
		this->~RwModuleWithMappingGetRangeActorActorState();
		static_cast<RwModuleWithMappingGetRangeActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(RangeResult const& resultWithoutPrefix,int loopDepth) 
	{
		loopDepth = a_body1cont1(resultWithoutPrefix, loopDepth);

		return loopDepth;
	}
	int a_body1when1(RangeResult && resultWithoutPrefix,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(resultWithoutPrefix), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RwModuleWithMappingGetRangeActorActor*>(this)->actor_wait_state > 0) static_cast<RwModuleWithMappingGetRangeActorActor*>(this)->actor_wait_state = 0;
		static_cast<RwModuleWithMappingGetRangeActorActor*>(this)->ActorCallback< RwModuleWithMappingGetRangeActorActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< RwModuleWithMappingGetRangeActorActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("rwModuleWithMappingGetRangeActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RwModuleWithMappingGetRangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rwModuleWithMappingGetRangeActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RwModuleWithMappingGetRangeActorActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("rwModuleWithMappingGetRangeActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RwModuleWithMappingGetRangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rwModuleWithMappingGetRangeActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RwModuleWithMappingGetRangeActorActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("rwModuleWithMappingGetRangeActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RwModuleWithMappingGetRangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rwModuleWithMappingGetRangeActor", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 882 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	ReadYourWritesTransaction* ryw;
															#line 882 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	const SpecialKeyRangeRWImpl* impl;
															#line 882 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	KeyRangeRef kr;
															#line 4225 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
};
// This generated class is to be used only via rwModuleWithMappingGetRangeActor()
															#line 882 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class RwModuleWithMappingGetRangeActorActor final : public Actor<RangeResult>, public ActorCallback< RwModuleWithMappingGetRangeActorActor, 0, RangeResult >, public FastAllocated<RwModuleWithMappingGetRangeActorActor>, public RwModuleWithMappingGetRangeActorActorState<RwModuleWithMappingGetRangeActorActor> {
															#line 4230 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
public:
	using FastAllocated<RwModuleWithMappingGetRangeActorActor>::operator new;
	using FastAllocated<RwModuleWithMappingGetRangeActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17430142582473806592UL, 7059590259746734336UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<RangeResult>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RwModuleWithMappingGetRangeActorActor, 0, RangeResult >;
															#line 882 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	RwModuleWithMappingGetRangeActorActor(ReadYourWritesTransaction* const& ryw,const SpecialKeyRangeRWImpl* const& impl,KeyRangeRef const& kr) 
															#line 4247 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		 : Actor<RangeResult>(),
		   RwModuleWithMappingGetRangeActorActorState<RwModuleWithMappingGetRangeActorActor>(ryw, impl, kr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("rwModuleWithMappingGetRangeActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9619561100216225280UL, 9781716562600313856UL);
		ActorExecutionContextHelper __helper(static_cast<RwModuleWithMappingGetRangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("rwModuleWithMappingGetRangeActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("rwModuleWithMappingGetRangeActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RwModuleWithMappingGetRangeActorActor, 0, RangeResult >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 882 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
[[nodiscard]] Future<RangeResult> rwModuleWithMappingGetRangeActor( ReadYourWritesTransaction* const& ryw, const SpecialKeyRangeRWImpl* const& impl, KeyRangeRef const& kr ) {
															#line 882 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	return Future<RangeResult>(new RwModuleWithMappingGetRangeActorActor(ryw, impl, kr));
															#line 4280 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
}

#line 893 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"

ExcludeServersRangeImpl::ExcludeServersRangeImpl(KeyRangeRef kr) : SpecialKeyRangeRWImpl(kr) {}

Future<RangeResult> ExcludeServersRangeImpl::getRange(ReadYourWritesTransaction* ryw,
                                                      KeyRangeRef kr,
                                                      GetRangeLimits limitsHint) const {
	ryw->setOption(FDBTransactionOptions::RAW_ACCESS);
	return rwModuleWithMappingGetRangeActor(ryw, this, kr);
}

void ExcludeServersRangeImpl::set(ReadYourWritesTransaction* ryw, const KeyRef& key, const ValueRef& value) {
	// ignore value
	ryw->getSpecialKeySpaceWriteMap().insert(key, std::make_pair(true, Optional<Value>(ValueRef())));
}

Key ExcludeServersRangeImpl::decode(const KeyRef& key) const {
	return key.removePrefix(SpecialKeySpace::getModuleRange(SpecialKeySpace::MODULE::MANAGEMENT).begin)
	    .withPrefix("\xff/conf/"_sr);
}

Key ExcludeServersRangeImpl::encode(const KeyRef& key) const {
	return key.removePrefix("\xff/conf/"_sr)
	    .withPrefix(SpecialKeySpace::getModuleRange(SpecialKeySpace::MODULE::MANAGEMENT).begin);
}

bool parseNetWorkAddrFromKeys(ReadYourWritesTransaction* ryw,
                              bool failed,
                              std::vector<AddressExclusion>& addresses,
                              std::set<AddressExclusion>& exclusions,
                              Optional<std::string>& msg) {
	KeyRangeRef range = failed ? SpecialKeySpace::getManagementApiCommandRange("failed")
	                           : SpecialKeySpace::getManagementApiCommandRange("exclude");
	auto ranges = ryw->getSpecialKeySpaceWriteMap().containedRanges(range);
	auto iter = ranges.begin();
	while (iter != ranges.end()) {
		auto entry = iter->value();
		// only check for exclude(set) operation, include(clear) are not checked
		TraceEvent(SevDebug, "ParseNetworkAddress")
		    .detail("Valid", entry.first)
		    .detail("Set", entry.second.present())
		    .detail("Key", iter->begin().toString());
		if (entry.first && entry.second.present()) {
			Key address = iter->begin().removePrefix(range.begin);
			auto a = AddressExclusion::parse(address);
			if (!a.isValid()) {
				std::string error = "ERROR: \'" + address.toString() + "\' is not a valid network endpoint address\n";
				if (address.toString().find(":tls") != std::string::npos)
					error += "        Do not include the `:tls' suffix when naming a process\n";
				msg = ManagementAPIError::toJsonString(
				    false, entry.second.present() ? (failed ? "exclude failed" : "exclude") : "include", error);
				return false;
			}
			addresses.push_back(a);
			exclusions.insert(a);
		}
		++iter;
	}
	return true;
}

															#line 4344 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
namespace {
// This generated class is to be used only via checkExclusion()
															#line 953 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
template <class CheckExclusionActor>
															#line 953 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class CheckExclusionActorState {
															#line 4351 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
public:
															#line 953 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	CheckExclusionActorState(Database const& db,std::vector<AddressExclusion> const& addresses,std::set<AddressExclusion> const& exclusions,std::unordered_set<std::string> const& localities,bool const& markFailed,Optional<std::string>* const& msg) 
															#line 953 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
															#line 953 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		 : db(db),
															#line 953 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   addresses(addresses),
															#line 953 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   exclusions(exclusions),
															#line 953 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   localities(localities),
															#line 953 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   markFailed(markFailed),
															#line 953 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   msg(msg)
															#line 4368 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
	{
		fdb_probe_actor_create("checkExclusion", reinterpret_cast<unsigned long>(this));

	}
	~CheckExclusionActorState() 
	{
		fdb_probe_actor_destroy("checkExclusion", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 959 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			StrictFuture<StatusObject> __when_expr_0 = StatusClient::statusFetcher(db);
															#line 959 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (static_cast<CheckExclusionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4385 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CheckExclusionActor*>(this)->actor_wait_state = 1;
															#line 959 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckExclusionActor, 0, StatusObject >*>(static_cast<CheckExclusionActor*>(this)));
															#line 4390 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckExclusionActorState();
		static_cast<CheckExclusionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(StatusObject const& status,int loopDepth) 
	{
															#line 960 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		errorString = "ERROR: Could not calculate the impact of this exclude on the total available space in the cluster.\n" "Please try the exclude again in 30 seconds.\n" "Call set(\"0xff0xff/management/options/exclude/force\", ...) first to exclude without checking available " "space.\n";
															#line 966 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		StatusObjectReader statusObj(status);
															#line 968 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		StatusObjectReader statusObjCluster;
															#line 969 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!statusObj.get("cluster", statusObjCluster))
															#line 4419 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		{
															#line 970 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			*msg = ManagementAPIError::toJsonString( false, markFailed ? "exclude failed" : "exclude", errorString + "Field 'cluster' missing.\n");
															#line 972 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (!static_cast<CheckExclusionActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckExclusionActorState(); static_cast<CheckExclusionActor*>(this)->destroy(); return 0; }
															#line 4425 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			new (&static_cast<CheckExclusionActor*>(this)->SAV< bool >::value()) bool(false);
			this->~CheckExclusionActorState();
			static_cast<CheckExclusionActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 975 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		StatusObjectReader processesMap;
															#line 976 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!statusObjCluster.get("processes", processesMap))
															#line 4435 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		{
															#line 977 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			*msg = ManagementAPIError::toJsonString( false, markFailed ? "exclude failed" : "exclude", errorString + "Field 'processes' missing.\n");
															#line 979 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (!static_cast<CheckExclusionActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckExclusionActorState(); static_cast<CheckExclusionActor*>(this)->destroy(); return 0; }
															#line 4441 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			new (&static_cast<CheckExclusionActor*>(this)->SAV< bool >::value()) bool(false);
			this->~CheckExclusionActorState();
			static_cast<CheckExclusionActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 982 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		ssTotalCount = 0;
															#line 983 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		ssExcludedCount = 0;
															#line 985 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		diskLocalities = std::unordered_set<std::string>();
															#line 986 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		totalKvStoreFreeBytes = 0;
															#line 987 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		totalKvStoreFreeBytesNotExcluded = 0;
															#line 988 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		totalKvStoreUsedBytes = 0;
															#line 989 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		totalKvStoreUsedBytesNotExcluded = 0;
															#line 990 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		totalKvStoreAvailableBytes = 0;
															#line 991 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		parsedLocalities = std::map<std::string, std::vector<std::string>>();
															#line 994 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		for( const auto& locality : localities ) {
															#line 995 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			std::pair<std::string, std::string> locality_key_value = decodeLocality(locality);
															#line 996 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (locality_key_value.first == "")
															#line 4471 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			{
				continue;
			}
															#line 1000 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			parsedLocalities[locality_key_value.first].push_back(locality_key_value.second);
															#line 4477 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		}
															#line 1011 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		excludedAddresses = std::vector<AddressExclusion>();
															#line 1012 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (markFailed && !addresses.empty())
															#line 4483 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		{
															#line 1013 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			excludedAddresses = addresses;
															#line 4487 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		}
		try {
															#line 1017 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			for( auto proc : processesMap.obj() ) {
															#line 1018 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				StatusObjectReader process(proc.second);
															#line 1019 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				StatusObjectReader localityObj;
															#line 1020 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				bool hasLocalities = process.get("locality", localityObj);
															#line 1022 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				bool excluded = process.has("excluded") && process.last().get_bool();
															#line 1025 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (!excluded)
															#line 4502 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
				{
															#line 1027 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					std::string addrStr;
															#line 1028 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					if (!process.get("address", addrStr))
															#line 4508 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
					{
															#line 1029 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						*msg = ManagementAPIError::toJsonString(false, markFailed ? "exclude failed" : "exclude", errorString);
															#line 1031 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						if (!static_cast<CheckExclusionActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckExclusionActorState(); static_cast<CheckExclusionActor*>(this)->destroy(); return 0; }
															#line 4514 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
						new (&static_cast<CheckExclusionActor*>(this)->SAV< bool >::value()) bool(false);
						this->~CheckExclusionActorState();
						static_cast<CheckExclusionActor*>(this)->finishSendAndDelPromiseRef();
						return 0;
					}
															#line 1033 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					NetworkAddress addr = NetworkAddress::parse(addrStr);
															#line 1034 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					excluded = addressExcluded(exclusions, addr);
															#line 1038 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					if (!excluded && hasLocalities && !parsedLocalities.empty())
															#line 4526 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
					{
															#line 1040 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						for( const auto& [localityKey, localityVec] : parsedLocalities ) {
															#line 1041 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
							std::string localityValue;
															#line 1042 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
							if (!localityObj.get(localityKey, localityValue))
															#line 4534 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
							{
								continue;
							}
															#line 1048 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
							if (std::find(localityVec.begin(), localityVec.end(), localityValue) != localityVec.end())
															#line 4540 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
							{
															#line 1049 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
								excluded = true;
															#line 1053 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
								if (markFailed)
															#line 4546 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
								{
															#line 1054 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
									auto addrExclusion = AddressExclusion(addr.ip, addr.port);
															#line 1055 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
									if (std::find(excludedAddresses.begin(), excludedAddresses.end(), addrExclusion) != excludedAddresses.end())
															#line 4552 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
									{
															#line 1057 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
										excludedAddresses.push_back(addrExclusion);
															#line 4556 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
									}
								}
								break;
							}
						}
					}
				}
															#line 1067 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				std::string disk_id;
															#line 1068 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (hasLocalities)
															#line 4568 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
				{
															#line 1069 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					process.get("disk_id", disk_id);
															#line 4572 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
				}
															#line 1072 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				StatusArray rolesArray = proc.second.get_obj()["roles"].get_array();
															#line 1073 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				for( StatusObjectReader role : rolesArray ) {
															#line 1074 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					if (role["role"].get_str() == "storage")
															#line 4580 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
					{
															#line 1075 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						ssTotalCount++;
															#line 1076 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						if (excluded)
															#line 4586 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
						{
															#line 1077 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
							ssExcludedCount++;
															#line 4590 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
						}
															#line 1080 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						int64_t used_bytes;
															#line 1081 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						if (!role.get("kvstore_used_bytes", used_bytes))
															#line 4596 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
						{
															#line 1082 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
							*msg = ManagementAPIError::toJsonString( false, markFailed ? "exclude failed" : "exclude", errorString + "Field 'kvstore_used_bytes' missing for storage role.\n");
															#line 1086 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
							if (!static_cast<CheckExclusionActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckExclusionActorState(); static_cast<CheckExclusionActor*>(this)->destroy(); return 0; }
															#line 4602 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
							new (&static_cast<CheckExclusionActor*>(this)->SAV< bool >::value()) bool(false);
							this->~CheckExclusionActorState();
							static_cast<CheckExclusionActor*>(this)->finishSendAndDelPromiseRef();
							return 0;
						}
															#line 1089 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						int64_t free_bytes;
															#line 1090 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						if (!role.get("kvstore_free_bytes", free_bytes))
															#line 4612 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
						{
															#line 1091 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
							*msg = ManagementAPIError::toJsonString( false, markFailed ? "exclude failed" : "exclude", errorString + "Field 'kvstore_free_bytes' missing for storage role.\n");
															#line 1095 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
							if (!static_cast<CheckExclusionActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckExclusionActorState(); static_cast<CheckExclusionActor*>(this)->destroy(); return 0; }
															#line 4618 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
							new (&static_cast<CheckExclusionActor*>(this)->SAV< bool >::value()) bool(false);
							this->~CheckExclusionActorState();
							static_cast<CheckExclusionActor*>(this)->finishSendAndDelPromiseRef();
							return 0;
						}
															#line 1098 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						int64_t available_bytes;
															#line 1099 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						if (!role.get("kvstore_available_bytes", available_bytes))
															#line 4628 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
						{
															#line 1100 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
							*msg = ManagementAPIError::toJsonString( false, markFailed ? "exclude failed" : "exclude", errorString + "Field 'kvstore_available_bytes' missing for storage role.\n");
															#line 1104 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
							if (!static_cast<CheckExclusionActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckExclusionActorState(); static_cast<CheckExclusionActor*>(this)->destroy(); return 0; }
															#line 4634 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
							new (&static_cast<CheckExclusionActor*>(this)->SAV< bool >::value()) bool(false);
							this->~CheckExclusionActorState();
							static_cast<CheckExclusionActor*>(this)->finishSendAndDelPromiseRef();
							return 0;
						}
															#line 1107 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						totalKvStoreUsedBytes += used_bytes;
															#line 1108 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						totalKvStoreFreeBytes += free_bytes;
															#line 1109 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						totalKvStoreAvailableBytes += available_bytes;
															#line 1111 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						if (!excluded)
															#line 4648 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
						{
															#line 1112 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
							totalKvStoreUsedBytesNotExcluded += used_bytes;
															#line 1114 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
							if (disk_id.empty() || diskLocalities.find(disk_id) == diskLocalities.end())
															#line 4654 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
							{
															#line 1115 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
								totalKvStoreFreeBytesNotExcluded += free_bytes;
															#line 1116 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
								if (!disk_id.empty())
															#line 4660 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
								{
															#line 1117 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
									diskLocalities.insert(disk_id);
															#line 4664 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
								}
							}
						}
					}
				}
			}
			loopDepth = a_body1cont28(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(StatusObject && status,int loopDepth) 
	{
															#line 960 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		errorString = "ERROR: Could not calculate the impact of this exclude on the total available space in the cluster.\n" "Please try the exclude again in 30 seconds.\n" "Call set(\"0xff0xff/management/options/exclude/force\", ...) first to exclude without checking available " "space.\n";
															#line 966 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		StatusObjectReader statusObj(status);
															#line 968 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		StatusObjectReader statusObjCluster;
															#line 969 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!statusObj.get("cluster", statusObjCluster))
															#line 4691 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		{
															#line 970 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			*msg = ManagementAPIError::toJsonString( false, markFailed ? "exclude failed" : "exclude", errorString + "Field 'cluster' missing.\n");
															#line 972 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (!static_cast<CheckExclusionActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckExclusionActorState(); static_cast<CheckExclusionActor*>(this)->destroy(); return 0; }
															#line 4697 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			new (&static_cast<CheckExclusionActor*>(this)->SAV< bool >::value()) bool(false);
			this->~CheckExclusionActorState();
			static_cast<CheckExclusionActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 975 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		StatusObjectReader processesMap;
															#line 976 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!statusObjCluster.get("processes", processesMap))
															#line 4707 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		{
															#line 977 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			*msg = ManagementAPIError::toJsonString( false, markFailed ? "exclude failed" : "exclude", errorString + "Field 'processes' missing.\n");
															#line 979 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (!static_cast<CheckExclusionActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckExclusionActorState(); static_cast<CheckExclusionActor*>(this)->destroy(); return 0; }
															#line 4713 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			new (&static_cast<CheckExclusionActor*>(this)->SAV< bool >::value()) bool(false);
			this->~CheckExclusionActorState();
			static_cast<CheckExclusionActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 982 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		ssTotalCount = 0;
															#line 983 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		ssExcludedCount = 0;
															#line 985 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		diskLocalities = std::unordered_set<std::string>();
															#line 986 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		totalKvStoreFreeBytes = 0;
															#line 987 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		totalKvStoreFreeBytesNotExcluded = 0;
															#line 988 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		totalKvStoreUsedBytes = 0;
															#line 989 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		totalKvStoreUsedBytesNotExcluded = 0;
															#line 990 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		totalKvStoreAvailableBytes = 0;
															#line 991 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		parsedLocalities = std::map<std::string, std::vector<std::string>>();
															#line 994 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		for( const auto& locality : localities ) {
															#line 995 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			std::pair<std::string, std::string> locality_key_value = decodeLocality(locality);
															#line 996 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (locality_key_value.first == "")
															#line 4743 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			{
				continue;
			}
															#line 1000 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			parsedLocalities[locality_key_value.first].push_back(locality_key_value.second);
															#line 4749 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		}
															#line 1011 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		excludedAddresses = std::vector<AddressExclusion>();
															#line 1012 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (markFailed && !addresses.empty())
															#line 4755 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		{
															#line 1013 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			excludedAddresses = addresses;
															#line 4759 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		}
		try {
															#line 1017 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			for( auto proc : processesMap.obj() ) {
															#line 1018 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				StatusObjectReader process(proc.second);
															#line 1019 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				StatusObjectReader localityObj;
															#line 1020 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				bool hasLocalities = process.get("locality", localityObj);
															#line 1022 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				bool excluded = process.has("excluded") && process.last().get_bool();
															#line 1025 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (!excluded)
															#line 4774 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
				{
															#line 1027 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					std::string addrStr;
															#line 1028 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					if (!process.get("address", addrStr))
															#line 4780 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
					{
															#line 1029 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						*msg = ManagementAPIError::toJsonString(false, markFailed ? "exclude failed" : "exclude", errorString);
															#line 1031 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						if (!static_cast<CheckExclusionActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckExclusionActorState(); static_cast<CheckExclusionActor*>(this)->destroy(); return 0; }
															#line 4786 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
						new (&static_cast<CheckExclusionActor*>(this)->SAV< bool >::value()) bool(false);
						this->~CheckExclusionActorState();
						static_cast<CheckExclusionActor*>(this)->finishSendAndDelPromiseRef();
						return 0;
					}
															#line 1033 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					NetworkAddress addr = NetworkAddress::parse(addrStr);
															#line 1034 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					excluded = addressExcluded(exclusions, addr);
															#line 1038 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					if (!excluded && hasLocalities && !parsedLocalities.empty())
															#line 4798 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
					{
															#line 1040 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						for( const auto& [localityKey, localityVec] : parsedLocalities ) {
															#line 1041 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
							std::string localityValue;
															#line 1042 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
							if (!localityObj.get(localityKey, localityValue))
															#line 4806 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
							{
								continue;
							}
															#line 1048 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
							if (std::find(localityVec.begin(), localityVec.end(), localityValue) != localityVec.end())
															#line 4812 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
							{
															#line 1049 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
								excluded = true;
															#line 1053 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
								if (markFailed)
															#line 4818 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
								{
															#line 1054 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
									auto addrExclusion = AddressExclusion(addr.ip, addr.port);
															#line 1055 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
									if (std::find(excludedAddresses.begin(), excludedAddresses.end(), addrExclusion) != excludedAddresses.end())
															#line 4824 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
									{
															#line 1057 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
										excludedAddresses.push_back(addrExclusion);
															#line 4828 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
									}
								}
								break;
							}
						}
					}
				}
															#line 1067 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				std::string disk_id;
															#line 1068 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (hasLocalities)
															#line 4840 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
				{
															#line 1069 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					process.get("disk_id", disk_id);
															#line 4844 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
				}
															#line 1072 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				StatusArray rolesArray = proc.second.get_obj()["roles"].get_array();
															#line 1073 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				for( StatusObjectReader role : rolesArray ) {
															#line 1074 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					if (role["role"].get_str() == "storage")
															#line 4852 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
					{
															#line 1075 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						ssTotalCount++;
															#line 1076 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						if (excluded)
															#line 4858 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
						{
															#line 1077 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
							ssExcludedCount++;
															#line 4862 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
						}
															#line 1080 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						int64_t used_bytes;
															#line 1081 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						if (!role.get("kvstore_used_bytes", used_bytes))
															#line 4868 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
						{
															#line 1082 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
							*msg = ManagementAPIError::toJsonString( false, markFailed ? "exclude failed" : "exclude", errorString + "Field 'kvstore_used_bytes' missing for storage role.\n");
															#line 1086 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
							if (!static_cast<CheckExclusionActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckExclusionActorState(); static_cast<CheckExclusionActor*>(this)->destroy(); return 0; }
															#line 4874 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
							new (&static_cast<CheckExclusionActor*>(this)->SAV< bool >::value()) bool(false);
							this->~CheckExclusionActorState();
							static_cast<CheckExclusionActor*>(this)->finishSendAndDelPromiseRef();
							return 0;
						}
															#line 1089 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						int64_t free_bytes;
															#line 1090 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						if (!role.get("kvstore_free_bytes", free_bytes))
															#line 4884 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
						{
															#line 1091 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
							*msg = ManagementAPIError::toJsonString( false, markFailed ? "exclude failed" : "exclude", errorString + "Field 'kvstore_free_bytes' missing for storage role.\n");
															#line 1095 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
							if (!static_cast<CheckExclusionActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckExclusionActorState(); static_cast<CheckExclusionActor*>(this)->destroy(); return 0; }
															#line 4890 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
							new (&static_cast<CheckExclusionActor*>(this)->SAV< bool >::value()) bool(false);
							this->~CheckExclusionActorState();
							static_cast<CheckExclusionActor*>(this)->finishSendAndDelPromiseRef();
							return 0;
						}
															#line 1098 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						int64_t available_bytes;
															#line 1099 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						if (!role.get("kvstore_available_bytes", available_bytes))
															#line 4900 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
						{
															#line 1100 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
							*msg = ManagementAPIError::toJsonString( false, markFailed ? "exclude failed" : "exclude", errorString + "Field 'kvstore_available_bytes' missing for storage role.\n");
															#line 1104 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
							if (!static_cast<CheckExclusionActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckExclusionActorState(); static_cast<CheckExclusionActor*>(this)->destroy(); return 0; }
															#line 4906 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
							new (&static_cast<CheckExclusionActor*>(this)->SAV< bool >::value()) bool(false);
							this->~CheckExclusionActorState();
							static_cast<CheckExclusionActor*>(this)->finishSendAndDelPromiseRef();
							return 0;
						}
															#line 1107 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						totalKvStoreUsedBytes += used_bytes;
															#line 1108 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						totalKvStoreFreeBytes += free_bytes;
															#line 1109 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						totalKvStoreAvailableBytes += available_bytes;
															#line 1111 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						if (!excluded)
															#line 4920 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
						{
															#line 1112 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
							totalKvStoreUsedBytesNotExcluded += used_bytes;
															#line 1114 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
							if (disk_id.empty() || diskLocalities.find(disk_id) == diskLocalities.end())
															#line 4926 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
							{
															#line 1115 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
								totalKvStoreFreeBytesNotExcluded += free_bytes;
															#line 1116 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
								if (!disk_id.empty())
															#line 4932 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
								{
															#line 1117 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
									diskLocalities.insert(disk_id);
															#line 4936 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
								}
							}
						}
					}
				}
			}
			loopDepth = a_body1cont28(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(StatusObject const& status,int loopDepth) 
	{
		loopDepth = a_body1cont1(status, loopDepth);

		return loopDepth;
	}
	int a_body1when1(StatusObject && status,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(status), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckExclusionActor*>(this)->actor_wait_state > 0) static_cast<CheckExclusionActor*>(this)->actor_wait_state = 0;
		static_cast<CheckExclusionActor*>(this)->ActorCallback< CheckExclusionActor, 0, StatusObject >::remove();

	}
	void a_callback_fire(ActorCallback< CheckExclusionActor, 0, StatusObject >*,StatusObject const& value) 
	{
		fdb_probe_actor_enter("checkExclusion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckExclusionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkExclusion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckExclusionActor, 0, StatusObject >*,StatusObject && value) 
	{
		fdb_probe_actor_enter("checkExclusion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckExclusionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkExclusion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckExclusionActor, 0, StatusObject >*,Error err) 
	{
		fdb_probe_actor_enter("checkExclusion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckExclusionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkExclusion", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 1136 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (ssExcludedCount > 0)
															#line 5032 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		{
															#line 1141 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			double finalUnavailableRatio = (double)(totalKvStoreUsedBytes + totalKvStoreFreeBytes - totalKvStoreAvailableBytes) / std::max((double)(totalKvStoreUsedBytesNotExcluded + totalKvStoreFreeBytesNotExcluded), (double)1);
															#line 1145 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			TraceEvent(SevInfo, "CheckExclusionDetails") .detail("SsTotalCount", ssTotalCount) .detail("SsExcludedCount", ssExcludedCount) .detail("FinalUnavailableRatio", finalUnavailableRatio) .detail("TotalKvStoreUsedBytes", totalKvStoreUsedBytes) .detail("TotalKvStoreFreeBytes", totalKvStoreFreeBytes) .detail("TotalKvStoreAvailableBytes", totalKvStoreAvailableBytes) .detail("TotalKvStoreUsedBytesNotExcluded", totalKvStoreUsedBytesNotExcluded) .detail("TotalKvStoreFreeBytesNotExcluded", totalKvStoreFreeBytesNotExcluded);
															#line 1155 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (ssExcludedCount == ssTotalCount || finalUnavailableRatio > 0.9)
															#line 5040 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			{
															#line 1156 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				std::string temp = "ERROR: This exclude may cause the total available space in the cluster to drop below 10%.\n" "Call set(\"0xff0xff/management/options/exclude/force\", ...) first to exclude without " "checking available space.\n";
															#line 1160 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				*msg = ManagementAPIError::toJsonString(false, markFailed ? "exclude failed" : "exclude", temp);
															#line 1161 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (!static_cast<CheckExclusionActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckExclusionActorState(); static_cast<CheckExclusionActor*>(this)->destroy(); return 0; }
															#line 5048 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
				new (&static_cast<CheckExclusionActor*>(this)->SAV< bool >::value()) bool(false);
				this->~CheckExclusionActorState();
				static_cast<CheckExclusionActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 1165 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (markFailed)
															#line 5057 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		{
															#line 1166 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			safe = bool();
															#line 5061 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			try {
															#line 1168 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				StrictFuture<bool> __when_expr_1 = checkSafeExclusions(db, addresses);
															#line 1168 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (static_cast<CheckExclusionActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), loopDepth);
															#line 5067 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont2Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
				static_cast<CheckExclusionActor*>(this)->actor_wait_state = 2;
															#line 1168 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckExclusionActor, 1, bool >*>(static_cast<CheckExclusionActor*>(this)));
															#line 5072 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1cont2Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1cont2Catch1(unknown_error(), loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont29(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1Catch1(const Error& __current_error,int loopDepth=0) 
	{
		try {
															#line 1129 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			*msg = ManagementAPIError::toJsonString( false, markFailed ? "exclude failed" : "exclude", errorString + "General exception raised.\n");
															#line 1131 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (!static_cast<CheckExclusionActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckExclusionActorState(); static_cast<CheckExclusionActor*>(this)->destroy(); return 0; }
															#line 5095 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			new (&static_cast<CheckExclusionActor*>(this)->SAV< bool >::value()) bool(false);
			this->~CheckExclusionActorState();
			static_cast<CheckExclusionActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont28(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont29(int loopDepth) 
	{
															#line 1188 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<CheckExclusionActor*>(this)->SAV<bool>::futures) { (void)(true); this->~CheckExclusionActorState(); static_cast<CheckExclusionActor*>(this)->destroy(); return 0; }
															#line 5126 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		new (&static_cast<CheckExclusionActor*>(this)->SAV< bool >::value()) bool(true);
		this->~CheckExclusionActorState();
		static_cast<CheckExclusionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont32(int loopDepth) 
	{
															#line 1176 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!safe)
															#line 5138 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		{
															#line 1177 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			std::string temp = "ERROR: It is unsafe to exclude the specified servers at this time.\n" "Please check that this exclusion does not bring down an entire storage team.\n" "Please also ensure that the exclusion will keep a majority of coordinators alive.\n" "You may add more storage processes or coordinators to make the operation safe.\n" "Call set(\"0xff0xff/management/failed/<ADDRESS...>\", ...) to exclude without " "performing safety checks.\n";
															#line 1183 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			*msg = ManagementAPIError::toJsonString(false, markFailed ? "exclude failed" : "exclude", temp);
															#line 1184 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (!static_cast<CheckExclusionActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckExclusionActorState(); static_cast<CheckExclusionActor*>(this)->destroy(); return 0; }
															#line 5146 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			new (&static_cast<CheckExclusionActor*>(this)->SAV< bool >::value()) bool(false);
			this->~CheckExclusionActorState();
			static_cast<CheckExclusionActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1cont29(loopDepth);

		return loopDepth;
	}
	int a_body1cont2Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1171 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 5161 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			{
															#line 1172 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 5165 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			}
															#line 1173 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			TraceEvent("CheckSafeExclusionsError").error(e);
															#line 1174 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			safe = false;
															#line 5171 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			loopDepth = a_body1cont32(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont33(bool const& _safe,int loopDepth) 
	{
															#line 1169 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		safe = _safe;
															#line 5186 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		loopDepth = a_body1cont33cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont33(bool && _safe,int loopDepth) 
	{
															#line 1169 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		safe = _safe;
															#line 5195 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		loopDepth = a_body1cont33cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(bool const& _safe,int loopDepth) 
	{
		loopDepth = a_body1cont33(_safe, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(bool && _safe,int loopDepth) 
	{
		loopDepth = a_body1cont33(std::move(_safe), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CheckExclusionActor*>(this)->actor_wait_state > 0) static_cast<CheckExclusionActor*>(this)->actor_wait_state = 0;
		static_cast<CheckExclusionActor*>(this)->ActorCallback< CheckExclusionActor, 1, bool >::remove();

	}
	void a_callback_fire(ActorCallback< CheckExclusionActor, 1, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("checkExclusion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckExclusionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkExclusion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CheckExclusionActor, 1, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("checkExclusion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckExclusionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkExclusion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CheckExclusionActor, 1, bool >*,Error err) 
	{
		fdb_probe_actor_enter("checkExclusion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckExclusionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkExclusion", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont33cont2(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont32(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 953 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	Database db;
															#line 953 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	std::vector<AddressExclusion> addresses;
															#line 953 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	std::set<AddressExclusion> exclusions;
															#line 953 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	std::unordered_set<std::string> localities;
															#line 953 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	bool markFailed;
															#line 953 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	Optional<std::string>* msg;
															#line 960 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	std::string errorString;
															#line 982 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	int ssTotalCount;
															#line 983 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	int ssExcludedCount;
															#line 985 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	std::unordered_set<std::string> diskLocalities;
															#line 986 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	int64_t totalKvStoreFreeBytes;
															#line 987 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	int64_t totalKvStoreFreeBytesNotExcluded;
															#line 988 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	int64_t totalKvStoreUsedBytes;
															#line 989 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	int64_t totalKvStoreUsedBytesNotExcluded;
															#line 990 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	int64_t totalKvStoreAvailableBytes;
															#line 991 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	std::map<std::string, std::vector<std::string>> parsedLocalities;
															#line 1011 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	std::vector<AddressExclusion> excludedAddresses;
															#line 1166 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	bool safe;
															#line 5324 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
};
// This generated class is to be used only via checkExclusion()
															#line 953 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class CheckExclusionActor final : public Actor<bool>, public ActorCallback< CheckExclusionActor, 0, StatusObject >, public ActorCallback< CheckExclusionActor, 1, bool >, public FastAllocated<CheckExclusionActor>, public CheckExclusionActorState<CheckExclusionActor> {
															#line 5329 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
public:
	using FastAllocated<CheckExclusionActor>::operator new;
	using FastAllocated<CheckExclusionActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14773306065394340352UL, 12577716640985271296UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckExclusionActor, 0, StatusObject >;
friend struct ActorCallback< CheckExclusionActor, 1, bool >;
															#line 953 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	CheckExclusionActor(Database const& db,std::vector<AddressExclusion> const& addresses,std::set<AddressExclusion> const& exclusions,std::unordered_set<std::string> const& localities,bool const& markFailed,Optional<std::string>* const& msg) 
															#line 5347 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		 : Actor<bool>(),
		   CheckExclusionActorState<CheckExclusionActor>(db, addresses, exclusions, localities, markFailed, msg),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkExclusion", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6176846843304675328UL, 17798302181591411200UL);
		ActorExecutionContextHelper __helper(static_cast<CheckExclusionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkExclusion");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkExclusion", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckExclusionActor, 0, StatusObject >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CheckExclusionActor, 1, bool >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 953 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
[[nodiscard]] Future<bool> checkExclusion( Database const& db, std::vector<AddressExclusion> const& addresses, std::set<AddressExclusion> const& exclusions, std::unordered_set<std::string> const& localities, bool const& markFailed, Optional<std::string>* const& msg ) {
															#line 953 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	return Future<bool>(new CheckExclusionActor(db, addresses, exclusions, localities, markFailed, msg));
															#line 5381 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
}

#line 1190 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"

void includeServers(ReadYourWritesTransaction* ryw) {
	ryw->setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
	ryw->setOption(FDBTransactionOptions::LOCK_AWARE);
	ryw->setOption(FDBTransactionOptions::USE_PROVISIONAL_PROXIES);
	ryw->setOption(FDBTransactionOptions::RAW_ACCESS);
	// includeServers might be used in an emergency transaction, so make sure it is retry-self-conflicting and
	// CAUSAL_WRITE_RISKY
	ryw->setOption(FDBTransactionOptions::CAUSAL_WRITE_RISKY);
	std::string versionKey = deterministicRandom()->randomUniqueID().toString();
	// for excluded servers
	auto ranges =
	    ryw->getSpecialKeySpaceWriteMap().containedRanges(SpecialKeySpace::getManagementApiCommandRange("exclude"));
	auto iter = ranges.begin();
	Transaction& tr = ryw->getTransaction();
	while (iter != ranges.end()) {
		auto entry = iter->value();
		if (entry.first && !entry.second.present()) {
			tr.addReadConflictRange(singleKeyRange(excludedServersVersionKey));
			tr.set(excludedServersVersionKey, versionKey);
			tr.clear(ryw->getDatabase()->specialKeySpace->decode(iter->range()));
		}
		++iter;
	}
	// for failed servers
	ranges = ryw->getSpecialKeySpaceWriteMap().containedRanges(SpecialKeySpace::getManagementApiCommandRange("failed"));
	iter = ranges.begin();
	while (iter != ranges.end()) {
		auto entry = iter->value();
		if (entry.first && !entry.second.present()) {
			tr.addReadConflictRange(singleKeyRange(failedServersVersionKey));
			tr.set(failedServersVersionKey, versionKey);
			tr.clear(ryw->getDatabase()->specialKeySpace->decode(iter->range()));
		}
		++iter;
	}
}

															#line 5423 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
namespace {
// This generated class is to be used only via excludeCommitActor()
															#line 1228 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
template <class ExcludeCommitActorActor>
															#line 1228 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class ExcludeCommitActorActorState {
															#line 5430 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
public:
															#line 1228 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	ExcludeCommitActorActorState(ReadYourWritesTransaction* const& ryw,bool const& failed) 
															#line 1228 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
															#line 1228 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		 : ryw(ryw),
															#line 1228 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   failed(failed),
															#line 1230 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   result(),
															#line 1231 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   addresses(),
															#line 1232 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   exclusions(),
															#line 1233 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   localities()
															#line 5447 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
	{
		fdb_probe_actor_create("excludeCommitActor", reinterpret_cast<unsigned long>(this));

	}
	~ExcludeCommitActorActorState() 
	{
		fdb_probe_actor_destroy("excludeCommitActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1235 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (!parseNetWorkAddrFromKeys(ryw, failed, addresses, exclusions, result))
															#line 5462 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			{
															#line 1236 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (!static_cast<ExcludeCommitActorActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(result); this->~ExcludeCommitActorActorState(); static_cast<ExcludeCommitActorActor*>(this)->destroy(); return 0; }
															#line 5466 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
				new (&static_cast<ExcludeCommitActorActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(std::move(result)); // state_var_RVO
				this->~ExcludeCommitActorActorState();
				static_cast<ExcludeCommitActorActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 1238 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			auto force = ryw->getSpecialKeySpaceWriteMap()[SpecialKeySpace::getManagementApiCommandOptionSpecialKey( failed ? "failed" : "excluded", "force")];
															#line 1241 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (addresses.size() && !(force.first && force.second.present()))
															#line 5476 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			{
															#line 1242 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				StrictFuture<bool> __when_expr_0 = checkExclusion(ryw->getDatabase(), addresses, exclusions, localities, failed, &result);
															#line 1242 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (static_cast<ExcludeCommitActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5482 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<ExcludeCommitActorActor*>(this)->actor_wait_state = 1;
															#line 1242 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ExcludeCommitActorActor, 0, bool >*>(static_cast<ExcludeCommitActorActor*>(this)));
															#line 5487 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ExcludeCommitActorActorState();
		static_cast<ExcludeCommitActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1246 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		StrictFuture<Void> __when_expr_1 = excludeServers(&(ryw->getTransaction()), addresses, failed);
															#line 1246 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (static_cast<ExcludeCommitActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5517 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ExcludeCommitActorActor*>(this)->actor_wait_state = 2;
															#line 1246 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ExcludeCommitActorActor, 1, Void >*>(static_cast<ExcludeCommitActorActor*>(this)));
															#line 5522 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(bool const& safe,int loopDepth) 
	{
															#line 1243 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!safe)
															#line 5531 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		{
															#line 1244 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (!static_cast<ExcludeCommitActorActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(result); this->~ExcludeCommitActorActorState(); static_cast<ExcludeCommitActorActor*>(this)->destroy(); return 0; }
															#line 5535 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			new (&static_cast<ExcludeCommitActorActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(std::move(result)); // state_var_RVO
			this->~ExcludeCommitActorActorState();
			static_cast<ExcludeCommitActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(bool && safe,int loopDepth) 
	{
															#line 1243 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!safe)
															#line 5549 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		{
															#line 1244 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (!static_cast<ExcludeCommitActorActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(result); this->~ExcludeCommitActorActorState(); static_cast<ExcludeCommitActorActor*>(this)->destroy(); return 0; }
															#line 5553 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			new (&static_cast<ExcludeCommitActorActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(std::move(result)); // state_var_RVO
			this->~ExcludeCommitActorActorState();
			static_cast<ExcludeCommitActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(bool const& safe,int loopDepth) 
	{
		loopDepth = a_body1cont3(safe, loopDepth);

		return loopDepth;
	}
	int a_body1when1(bool && safe,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(safe), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ExcludeCommitActorActor*>(this)->actor_wait_state > 0) static_cast<ExcludeCommitActorActor*>(this)->actor_wait_state = 0;
		static_cast<ExcludeCommitActorActor*>(this)->ActorCallback< ExcludeCommitActorActor, 0, bool >::remove();

	}
	void a_callback_fire(ActorCallback< ExcludeCommitActorActor, 0, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("excludeCommitActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExcludeCommitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("excludeCommitActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ExcludeCommitActorActor, 0, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("excludeCommitActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExcludeCommitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("excludeCommitActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ExcludeCommitActorActor, 0, bool >*,Error err) 
	{
		fdb_probe_actor_enter("excludeCommitActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ExcludeCommitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("excludeCommitActor", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 1247 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		includeServers(ryw);
															#line 1249 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<ExcludeCommitActorActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(result); this->~ExcludeCommitActorActorState(); static_cast<ExcludeCommitActorActor*>(this)->destroy(); return 0; }
															#line 5644 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		new (&static_cast<ExcludeCommitActorActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(std::move(result)); // state_var_RVO
		this->~ExcludeCommitActorActorState();
		static_cast<ExcludeCommitActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 1247 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		includeServers(ryw);
															#line 1249 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<ExcludeCommitActorActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(result); this->~ExcludeCommitActorActorState(); static_cast<ExcludeCommitActorActor*>(this)->destroy(); return 0; }
															#line 5658 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		new (&static_cast<ExcludeCommitActorActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(std::move(result)); // state_var_RVO
		this->~ExcludeCommitActorActorState();
		static_cast<ExcludeCommitActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ExcludeCommitActorActor*>(this)->actor_wait_state > 0) static_cast<ExcludeCommitActorActor*>(this)->actor_wait_state = 0;
		static_cast<ExcludeCommitActorActor*>(this)->ActorCallback< ExcludeCommitActorActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ExcludeCommitActorActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("excludeCommitActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExcludeCommitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("excludeCommitActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ExcludeCommitActorActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("excludeCommitActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExcludeCommitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("excludeCommitActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ExcludeCommitActorActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("excludeCommitActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ExcludeCommitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("excludeCommitActor", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1228 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	ReadYourWritesTransaction* ryw;
															#line 1228 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	bool failed;
															#line 1230 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	Optional<std::string> result;
															#line 1231 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	std::vector<AddressExclusion> addresses;
															#line 1232 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	std::set<AddressExclusion> exclusions;
															#line 1233 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	std::unordered_set<std::string> localities;
															#line 5753 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
};
// This generated class is to be used only via excludeCommitActor()
															#line 1228 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class ExcludeCommitActorActor final : public Actor<Optional<std::string>>, public ActorCallback< ExcludeCommitActorActor, 0, bool >, public ActorCallback< ExcludeCommitActorActor, 1, Void >, public FastAllocated<ExcludeCommitActorActor>, public ExcludeCommitActorActorState<ExcludeCommitActorActor> {
															#line 5758 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
public:
	using FastAllocated<ExcludeCommitActorActor>::operator new;
	using FastAllocated<ExcludeCommitActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12659809189843125248UL, 258071360196125952UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Optional<std::string>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ExcludeCommitActorActor, 0, bool >;
friend struct ActorCallback< ExcludeCommitActorActor, 1, Void >;
															#line 1228 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	ExcludeCommitActorActor(ReadYourWritesTransaction* const& ryw,bool const& failed) 
															#line 5776 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		 : Actor<Optional<std::string>>(),
		   ExcludeCommitActorActorState<ExcludeCommitActorActor>(ryw, failed),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("excludeCommitActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7997247617364751360UL, 12542231733836832256UL);
		ActorExecutionContextHelper __helper(static_cast<ExcludeCommitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("excludeCommitActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("excludeCommitActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ExcludeCommitActorActor, 0, bool >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ExcludeCommitActorActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1228 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
[[nodiscard]] Future<Optional<std::string>> excludeCommitActor( ReadYourWritesTransaction* const& ryw, bool const& failed ) {
															#line 1228 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	return Future<Optional<std::string>>(new ExcludeCommitActorActor(ryw, failed));
															#line 5810 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
}

#line 1251 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"

Future<Optional<std::string>> ExcludeServersRangeImpl::commit(ReadYourWritesTransaction* ryw) {
	return excludeCommitActor(ryw, false);
}

FailedServersRangeImpl::FailedServersRangeImpl(KeyRangeRef kr) : SpecialKeyRangeRWImpl(kr) {}

Future<RangeResult> FailedServersRangeImpl::getRange(ReadYourWritesTransaction* ryw,
                                                     KeyRangeRef kr,
                                                     GetRangeLimits limitsHint) const {
	ryw->setOption(FDBTransactionOptions::RAW_ACCESS);
	return rwModuleWithMappingGetRangeActor(ryw, this, kr);
}

void FailedServersRangeImpl::set(ReadYourWritesTransaction* ryw, const KeyRef& key, const ValueRef& value) {
	// ignore value
	ryw->getSpecialKeySpaceWriteMap().insert(key, std::make_pair(true, Optional<Value>(ValueRef())));
}

Key FailedServersRangeImpl::decode(const KeyRef& key) const {
	return key.removePrefix(SpecialKeySpace::getModuleRange(SpecialKeySpace::MODULE::MANAGEMENT).begin)
	    .withPrefix("\xff/conf/"_sr);
}

Key FailedServersRangeImpl::encode(const KeyRef& key) const {
	return key.removePrefix("\xff/conf/"_sr)
	    .withPrefix(SpecialKeySpace::getModuleRange(SpecialKeySpace::MODULE::MANAGEMENT).begin);
}

Future<Optional<std::string>> FailedServersRangeImpl::commit(ReadYourWritesTransaction* ryw) {
	return excludeCommitActor(ryw, true);
}

															#line 5847 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
namespace {
// This generated class is to be used only via ExclusionInProgressActor()
															#line 1284 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
template <class ExclusionInProgressActorActor>
															#line 1284 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class ExclusionInProgressActorActorState {
															#line 5854 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
public:
															#line 1284 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	ExclusionInProgressActorActorState(ReadYourWritesTransaction* const& ryw,KeyRef const& prefix,KeyRangeRef const& kr) 
															#line 1284 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
															#line 1284 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		 : ryw(ryw),
															#line 1284 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   prefix(prefix),
															#line 1284 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   kr(kr),
															#line 1285 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   result(),
															#line 1286 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   tr(ryw->getTransaction())
															#line 5869 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
	{
		fdb_probe_actor_create("ExclusionInProgressActor", reinterpret_cast<unsigned long>(this));

	}
	~ExclusionInProgressActorActorState() 
	{
		fdb_probe_actor_destroy("ExclusionInProgressActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1287 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			tr.setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 1288 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 1289 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 1291 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			fExclusions = getAllExcludedServers(&tr);
															#line 1292 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			fExcludedLocalities = getAllExcludedLocalities(&tr);
															#line 1293 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			fServerList = tr.getRange(serverListKeys, CLIENT_KNOBS->TOO_MANY);
															#line 1294 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			fLogsKey = tr.get(logsKey);
															#line 1295 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			StrictFuture<Void> __when_expr_0 = success(fExclusions) && success(fExcludedLocalities) && success(fServerList);
															#line 1295 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (static_cast<ExclusionInProgressActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5900 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ExclusionInProgressActorActor*>(this)->actor_wait_state = 1;
															#line 1295 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ExclusionInProgressActorActor, 0, Void >*>(static_cast<ExclusionInProgressActorActor*>(this)));
															#line 5905 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ExclusionInProgressActorActorState();
		static_cast<ExclusionInProgressActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1297 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		excl = fExclusions.get();
															#line 1298 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		exclusions = std::set<AddressExclusion>(excl.begin(), excl.end());
															#line 1299 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		inProgressExclusion = std::set<NetworkAddress>();
															#line 1302 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		serverList = fServerList.get();
															#line 1303 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		ASSERT(!serverList.more && serverList.size() < CLIENT_KNOBS->TOO_MANY);
															#line 1307 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		excludedLocalities = fExcludedLocalities.get();
															#line 1309 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		decodedExcludedLocalities = std::vector<std::pair<std::string, std::string>>();
															#line 1310 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		for( auto& excludedLocality : excludedLocalities ) {
															#line 1311 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			decodedExcludedLocalities.push_back(decodeLocality(excludedLocality));
															#line 5944 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		}
															#line 1314 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		for( auto& s : serverList ) {
															#line 1315 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			auto decodedServer = decodeServerListValue(s.value);
															#line 1316 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			auto addresses = decodedServer.getKeyValues.getEndpoint().addresses;
															#line 1317 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (addressExcluded(exclusions, addresses.address))
															#line 5954 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			{
															#line 1318 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				inProgressExclusion.insert(addresses.address);
															#line 5958 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			}
															#line 1321 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (addresses.secondaryAddress.present() && addressExcluded(exclusions, addresses.secondaryAddress.get()))
															#line 5962 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			{
															#line 1322 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				inProgressExclusion.insert(addresses.secondaryAddress.get());
															#line 5966 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			}
															#line 1326 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			for( auto& excludedLocality : decodedExcludedLocalities ) {
															#line 1327 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (!decodedServer.locality.isPresent(excludedLocality.first))
															#line 5972 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
				{
					continue;
				}
															#line 1331 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (decodedServer.locality.get(excludedLocality.first) != excludedLocality.second)
															#line 5978 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
				{
					continue;
				}
															#line 1335 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				inProgressExclusion.insert(addresses.address);
															#line 1336 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (addresses.secondaryAddress.present())
															#line 5986 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
				{
															#line 1337 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					inProgressExclusion.insert(addresses.secondaryAddress.get());
															#line 5990 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
				}
			}
		}
															#line 1342 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		StrictFuture<Void> __when_expr_1 = success(fLogsKey);
															#line 1342 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (static_cast<ExclusionInProgressActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5998 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ExclusionInProgressActorActor*>(this)->actor_wait_state = 2;
															#line 1342 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ExclusionInProgressActorActor, 1, Void >*>(static_cast<ExclusionInProgressActorActor*>(this)));
															#line 6003 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1297 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		excl = fExclusions.get();
															#line 1298 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		exclusions = std::set<AddressExclusion>(excl.begin(), excl.end());
															#line 1299 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		inProgressExclusion = std::set<NetworkAddress>();
															#line 1302 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		serverList = fServerList.get();
															#line 1303 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		ASSERT(!serverList.more && serverList.size() < CLIENT_KNOBS->TOO_MANY);
															#line 1307 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		excludedLocalities = fExcludedLocalities.get();
															#line 1309 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		decodedExcludedLocalities = std::vector<std::pair<std::string, std::string>>();
															#line 1310 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		for( auto& excludedLocality : excludedLocalities ) {
															#line 1311 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			decodedExcludedLocalities.push_back(decodeLocality(excludedLocality));
															#line 6028 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		}
															#line 1314 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		for( auto& s : serverList ) {
															#line 1315 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			auto decodedServer = decodeServerListValue(s.value);
															#line 1316 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			auto addresses = decodedServer.getKeyValues.getEndpoint().addresses;
															#line 1317 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (addressExcluded(exclusions, addresses.address))
															#line 6038 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			{
															#line 1318 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				inProgressExclusion.insert(addresses.address);
															#line 6042 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			}
															#line 1321 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (addresses.secondaryAddress.present() && addressExcluded(exclusions, addresses.secondaryAddress.get()))
															#line 6046 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			{
															#line 1322 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				inProgressExclusion.insert(addresses.secondaryAddress.get());
															#line 6050 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			}
															#line 1326 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			for( auto& excludedLocality : decodedExcludedLocalities ) {
															#line 1327 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (!decodedServer.locality.isPresent(excludedLocality.first))
															#line 6056 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
				{
					continue;
				}
															#line 1331 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (decodedServer.locality.get(excludedLocality.first) != excludedLocality.second)
															#line 6062 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
				{
					continue;
				}
															#line 1335 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				inProgressExclusion.insert(addresses.address);
															#line 1336 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (addresses.secondaryAddress.present())
															#line 6070 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
				{
															#line 1337 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					inProgressExclusion.insert(addresses.secondaryAddress.get());
															#line 6074 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
				}
			}
		}
															#line 1342 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		StrictFuture<Void> __when_expr_1 = success(fLogsKey);
															#line 1342 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (static_cast<ExclusionInProgressActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6082 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ExclusionInProgressActorActor*>(this)->actor_wait_state = 2;
															#line 1342 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ExclusionInProgressActorActor, 1, Void >*>(static_cast<ExclusionInProgressActorActor*>(this)));
															#line 6087 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ExclusionInProgressActorActor*>(this)->actor_wait_state > 0) static_cast<ExclusionInProgressActorActor*>(this)->actor_wait_state = 0;
		static_cast<ExclusionInProgressActorActor*>(this)->ActorCallback< ExclusionInProgressActorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ExclusionInProgressActorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("ExclusionInProgressActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExclusionInProgressActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ExclusionInProgressActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ExclusionInProgressActorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("ExclusionInProgressActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExclusionInProgressActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ExclusionInProgressActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ExclusionInProgressActorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("ExclusionInProgressActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ExclusionInProgressActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ExclusionInProgressActor", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 1343 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		Optional<Standalone<StringRef>> value = fLogsKey.get();
															#line 1344 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		ASSERT(value.present());
															#line 1348 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		auto logs = decodeLogsValue(value.get());
															#line 1349 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		for( auto const& log : logs.first ) {
															#line 1350 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (log.second == NetworkAddress() || addressExcluded(exclusions, log.second))
															#line 6179 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			{
															#line 1351 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				inProgressExclusion.insert(log.second);
															#line 6183 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			}
		}
															#line 1354 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		for( auto const& log : logs.second ) {
															#line 1355 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (log.second == NetworkAddress() || addressExcluded(exclusions, log.second))
															#line 6190 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			{
															#line 1356 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				inProgressExclusion.insert(log.second);
															#line 6194 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			}
		}
															#line 1361 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		std::set<std::string> inProgressAddresses;
															#line 1362 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		for( auto const& address : inProgressExclusion ) {
															#line 1363 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			inProgressAddresses.insert(formatIpPort(address.ip, address.port));
															#line 6203 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		}
															#line 1366 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		for( auto const& address : inProgressAddresses ) {
															#line 1367 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			Key addrKey = prefix.withSuffix(address);
															#line 1368 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (kr.contains(addrKey))
															#line 6211 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			{
															#line 1369 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				result.push_back(result.arena(), KeyValueRef(addrKey, ValueRef()));
															#line 1370 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				result.arena().dependsOn(addrKey.arena());
															#line 6217 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			}
		}
															#line 1374 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<ExclusionInProgressActorActor*>(this)->SAV<RangeResult>::futures) { (void)(result); this->~ExclusionInProgressActorActorState(); static_cast<ExclusionInProgressActorActor*>(this)->destroy(); return 0; }
															#line 6222 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		new (&static_cast<ExclusionInProgressActorActor*>(this)->SAV< RangeResult >::value()) RangeResult(std::move(result)); // state_var_RVO
		this->~ExclusionInProgressActorActorState();
		static_cast<ExclusionInProgressActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 1343 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		Optional<Standalone<StringRef>> value = fLogsKey.get();
															#line 1344 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		ASSERT(value.present());
															#line 1348 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		auto logs = decodeLogsValue(value.get());
															#line 1349 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		for( auto const& log : logs.first ) {
															#line 1350 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (log.second == NetworkAddress() || addressExcluded(exclusions, log.second))
															#line 6242 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			{
															#line 1351 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				inProgressExclusion.insert(log.second);
															#line 6246 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			}
		}
															#line 1354 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		for( auto const& log : logs.second ) {
															#line 1355 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (log.second == NetworkAddress() || addressExcluded(exclusions, log.second))
															#line 6253 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			{
															#line 1356 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				inProgressExclusion.insert(log.second);
															#line 6257 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			}
		}
															#line 1361 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		std::set<std::string> inProgressAddresses;
															#line 1362 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		for( auto const& address : inProgressExclusion ) {
															#line 1363 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			inProgressAddresses.insert(formatIpPort(address.ip, address.port));
															#line 6266 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		}
															#line 1366 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		for( auto const& address : inProgressAddresses ) {
															#line 1367 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			Key addrKey = prefix.withSuffix(address);
															#line 1368 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (kr.contains(addrKey))
															#line 6274 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			{
															#line 1369 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				result.push_back(result.arena(), KeyValueRef(addrKey, ValueRef()));
															#line 1370 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				result.arena().dependsOn(addrKey.arena());
															#line 6280 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			}
		}
															#line 1374 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<ExclusionInProgressActorActor*>(this)->SAV<RangeResult>::futures) { (void)(result); this->~ExclusionInProgressActorActorState(); static_cast<ExclusionInProgressActorActor*>(this)->destroy(); return 0; }
															#line 6285 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		new (&static_cast<ExclusionInProgressActorActor*>(this)->SAV< RangeResult >::value()) RangeResult(std::move(result)); // state_var_RVO
		this->~ExclusionInProgressActorActorState();
		static_cast<ExclusionInProgressActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ExclusionInProgressActorActor*>(this)->actor_wait_state > 0) static_cast<ExclusionInProgressActorActor*>(this)->actor_wait_state = 0;
		static_cast<ExclusionInProgressActorActor*>(this)->ActorCallback< ExclusionInProgressActorActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ExclusionInProgressActorActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("ExclusionInProgressActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExclusionInProgressActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ExclusionInProgressActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ExclusionInProgressActorActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("ExclusionInProgressActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExclusionInProgressActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ExclusionInProgressActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ExclusionInProgressActorActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("ExclusionInProgressActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ExclusionInProgressActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ExclusionInProgressActor", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1284 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	ReadYourWritesTransaction* ryw;
															#line 1284 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	KeyRef prefix;
															#line 1284 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	KeyRangeRef kr;
															#line 1285 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	RangeResult result;
															#line 1286 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	Transaction& tr;
															#line 1291 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	Future<std::vector<AddressExclusion>> fExclusions;
															#line 1292 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	Future<std::vector<std::string>> fExcludedLocalities;
															#line 1293 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	Future<RangeResult> fServerList;
															#line 1294 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	Future<Optional<Standalone<StringRef>>> fLogsKey;
															#line 1297 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	std::vector<AddressExclusion> excl;
															#line 1298 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	std::set<AddressExclusion> exclusions;
															#line 1299 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	std::set<NetworkAddress> inProgressExclusion;
															#line 1302 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	RangeResult serverList;
															#line 1307 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	std::vector<std::string> excludedLocalities;
															#line 1309 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	std::vector<std::pair<std::string, std::string>> decodedExcludedLocalities;
															#line 6398 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
};
// This generated class is to be used only via ExclusionInProgressActor()
															#line 1284 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class ExclusionInProgressActorActor final : public Actor<RangeResult>, public ActorCallback< ExclusionInProgressActorActor, 0, Void >, public ActorCallback< ExclusionInProgressActorActor, 1, Void >, public FastAllocated<ExclusionInProgressActorActor>, public ExclusionInProgressActorActorState<ExclusionInProgressActorActor> {
															#line 6403 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
public:
	using FastAllocated<ExclusionInProgressActorActor>::operator new;
	using FastAllocated<ExclusionInProgressActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16806532741856106752UL, 12015815440330644480UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<RangeResult>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ExclusionInProgressActorActor, 0, Void >;
friend struct ActorCallback< ExclusionInProgressActorActor, 1, Void >;
															#line 1284 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	ExclusionInProgressActorActor(ReadYourWritesTransaction* const& ryw,KeyRef const& prefix,KeyRangeRef const& kr) 
															#line 6421 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		 : Actor<RangeResult>(),
		   ExclusionInProgressActorActorState<ExclusionInProgressActorActor>(ryw, prefix, kr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("ExclusionInProgressActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10733041304823415808UL, 1142347301358771456UL);
		ActorExecutionContextHelper __helper(static_cast<ExclusionInProgressActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("ExclusionInProgressActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("ExclusionInProgressActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ExclusionInProgressActorActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ExclusionInProgressActorActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1284 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
[[nodiscard]] Future<RangeResult> ExclusionInProgressActor( ReadYourWritesTransaction* const& ryw, KeyRef const& prefix, KeyRangeRef const& kr ) {
															#line 1284 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	return Future<RangeResult>(new ExclusionInProgressActorActor(ryw, prefix, kr));
															#line 6455 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
}

#line 1376 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"

ExclusionInProgressRangeImpl::ExclusionInProgressRangeImpl(KeyRangeRef kr) : SpecialKeyRangeAsyncImpl(kr) {}

Future<RangeResult> ExclusionInProgressRangeImpl::getRange(ReadYourWritesTransaction* ryw,
                                                           KeyRangeRef kr,
                                                           GetRangeLimits limitsHint) const {
	return ExclusionInProgressActor(ryw, getKeyRange().begin, kr);
}

															#line 6468 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
namespace {
// This generated class is to be used only via getProcessClassActor()
															#line 1385 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
template <class GetProcessClassActorActor>
															#line 1385 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class GetProcessClassActorActorState {
															#line 6475 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
public:
															#line 1385 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	GetProcessClassActorActorState(ReadYourWritesTransaction* const& ryw,KeyRef const& prefix,KeyRangeRef const& kr) 
															#line 1385 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
															#line 1385 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		 : ryw(ryw),
															#line 1385 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   prefix(prefix),
															#line 1385 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   kr(kr)
															#line 6486 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
	{
		fdb_probe_actor_create("getProcessClassActor", reinterpret_cast<unsigned long>(this));

	}
	~GetProcessClassActorActorState() 
	{
		fdb_probe_actor_destroy("getProcessClassActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1386 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ryw->setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 1387 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			StrictFuture<std::vector<ProcessData>> __when_expr_0 = getWorkers(&ryw->getTransaction());
															#line 1387 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (static_cast<GetProcessClassActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6505 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetProcessClassActorActor*>(this)->actor_wait_state = 1;
															#line 1387 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetProcessClassActorActor, 0, std::vector<ProcessData> >*>(static_cast<GetProcessClassActorActor*>(this)));
															#line 6510 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetProcessClassActorActorState();
		static_cast<GetProcessClassActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<ProcessData> const& _workers,int loopDepth) 
	{
															#line 1388 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		auto workers = _workers;
															#line 1390 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		std::sort(workers.begin(), workers.end(), [](const ProcessData& lhs, const ProcessData& rhs) { return formatIpPort(lhs.address.ip, lhs.address.port) < formatIpPort(rhs.address.ip, rhs.address.port); });
															#line 1394 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		auto last = std::unique(workers.begin(), workers.end(), [](const ProcessData& lhs, const ProcessData& rhs) { return formatIpPort(lhs.address.ip, lhs.address.port) == formatIpPort(rhs.address.ip, rhs.address.port); });
															#line 1398 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		workers.erase(last, workers.end());
															#line 1399 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		RangeResult result;
															#line 1400 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		for( auto& w : workers ) {
															#line 1402 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			KeyRef k(prefix.withSuffix(formatIpPort(w.address.ip, w.address.port), result.arena()));
															#line 1403 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (kr.contains(k))
															#line 6547 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			{
															#line 1404 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				ValueRef v(result.arena(), w.processClass.toString());
															#line 1405 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				result.push_back(result.arena(), KeyValueRef(k, v));
															#line 6553 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			}
		}
															#line 1408 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<GetProcessClassActorActor*>(this)->SAV<RangeResult>::futures) { (void)(rywGetRange(ryw, kr, result)); this->~GetProcessClassActorActorState(); static_cast<GetProcessClassActorActor*>(this)->destroy(); return 0; }
															#line 6558 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		new (&static_cast<GetProcessClassActorActor*>(this)->SAV< RangeResult >::value()) RangeResult(rywGetRange(ryw, kr, result));
		this->~GetProcessClassActorActorState();
		static_cast<GetProcessClassActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<ProcessData> && _workers,int loopDepth) 
	{
															#line 1388 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		auto workers = _workers;
															#line 1390 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		std::sort(workers.begin(), workers.end(), [](const ProcessData& lhs, const ProcessData& rhs) { return formatIpPort(lhs.address.ip, lhs.address.port) < formatIpPort(rhs.address.ip, rhs.address.port); });
															#line 1394 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		auto last = std::unique(workers.begin(), workers.end(), [](const ProcessData& lhs, const ProcessData& rhs) { return formatIpPort(lhs.address.ip, lhs.address.port) == formatIpPort(rhs.address.ip, rhs.address.port); });
															#line 1398 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		workers.erase(last, workers.end());
															#line 1399 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		RangeResult result;
															#line 1400 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		for( auto& w : workers ) {
															#line 1402 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			KeyRef k(prefix.withSuffix(formatIpPort(w.address.ip, w.address.port), result.arena()));
															#line 1403 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (kr.contains(k))
															#line 6584 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			{
															#line 1404 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				ValueRef v(result.arena(), w.processClass.toString());
															#line 1405 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				result.push_back(result.arena(), KeyValueRef(k, v));
															#line 6590 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			}
		}
															#line 1408 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<GetProcessClassActorActor*>(this)->SAV<RangeResult>::futures) { (void)(rywGetRange(ryw, kr, result)); this->~GetProcessClassActorActorState(); static_cast<GetProcessClassActorActor*>(this)->destroy(); return 0; }
															#line 6595 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		new (&static_cast<GetProcessClassActorActor*>(this)->SAV< RangeResult >::value()) RangeResult(rywGetRange(ryw, kr, result));
		this->~GetProcessClassActorActorState();
		static_cast<GetProcessClassActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(std::vector<ProcessData> const& _workers,int loopDepth) 
	{
		loopDepth = a_body1cont1(_workers, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<ProcessData> && _workers,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_workers), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetProcessClassActorActor*>(this)->actor_wait_state > 0) static_cast<GetProcessClassActorActor*>(this)->actor_wait_state = 0;
		static_cast<GetProcessClassActorActor*>(this)->ActorCallback< GetProcessClassActorActor, 0, std::vector<ProcessData> >::remove();

	}
	void a_callback_fire(ActorCallback< GetProcessClassActorActor, 0, std::vector<ProcessData> >*,std::vector<ProcessData> const& value) 
	{
		fdb_probe_actor_enter("getProcessClassActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetProcessClassActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getProcessClassActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetProcessClassActorActor, 0, std::vector<ProcessData> >*,std::vector<ProcessData> && value) 
	{
		fdb_probe_actor_enter("getProcessClassActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetProcessClassActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getProcessClassActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetProcessClassActorActor, 0, std::vector<ProcessData> >*,Error err) 
	{
		fdb_probe_actor_enter("getProcessClassActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetProcessClassActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getProcessClassActor", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1385 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	ReadYourWritesTransaction* ryw;
															#line 1385 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	KeyRef prefix;
															#line 1385 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	KeyRangeRef kr;
															#line 6684 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
};
// This generated class is to be used only via getProcessClassActor()
															#line 1385 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class GetProcessClassActorActor final : public Actor<RangeResult>, public ActorCallback< GetProcessClassActorActor, 0, std::vector<ProcessData> >, public FastAllocated<GetProcessClassActorActor>, public GetProcessClassActorActorState<GetProcessClassActorActor> {
															#line 6689 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
public:
	using FastAllocated<GetProcessClassActorActor>::operator new;
	using FastAllocated<GetProcessClassActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7418368249512960UL, 13901330696975917312UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<RangeResult>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetProcessClassActorActor, 0, std::vector<ProcessData> >;
															#line 1385 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	GetProcessClassActorActor(ReadYourWritesTransaction* const& ryw,KeyRef const& prefix,KeyRangeRef const& kr) 
															#line 6706 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		 : Actor<RangeResult>(),
		   GetProcessClassActorActorState<GetProcessClassActorActor>(ryw, prefix, kr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getProcessClassActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17035494225643581952UL, 4137256890976619776UL);
		ActorExecutionContextHelper __helper(static_cast<GetProcessClassActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getProcessClassActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getProcessClassActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetProcessClassActorActor, 0, std::vector<ProcessData> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1385 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
[[nodiscard]] Future<RangeResult> getProcessClassActor( ReadYourWritesTransaction* const& ryw, KeyRef const& prefix, KeyRangeRef const& kr ) {
															#line 1385 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	return Future<RangeResult>(new GetProcessClassActorActor(ryw, prefix, kr));
															#line 6739 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
}

#line 1410 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"

															#line 6744 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
namespace {
// This generated class is to be used only via processClassCommitActor()
															#line 1411 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
template <class ProcessClassCommitActorActor>
															#line 1411 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class ProcessClassCommitActorActorState {
															#line 6751 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
public:
															#line 1411 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	ProcessClassCommitActorActorState(ReadYourWritesTransaction* const& ryw,KeyRangeRef const& range) 
															#line 1411 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
															#line 1411 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		 : ryw(ryw),
															#line 1411 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   range(range)
															#line 6760 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
	{
		fdb_probe_actor_create("processClassCommitActor", reinterpret_cast<unsigned long>(this));

	}
	~ProcessClassCommitActorActorState() 
	{
		fdb_probe_actor_destroy("processClassCommitActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1413 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ryw->setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 1414 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ryw->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 1415 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ryw->setOption(FDBTransactionOptions::USE_PROVISIONAL_PROXIES);
															#line 1416 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ryw->setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 1417 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			StrictFuture<std::vector<ProcessData>> __when_expr_0 = getWorkers(&ryw->getTransaction());
															#line 1417 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (static_cast<ProcessClassCommitActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6785 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ProcessClassCommitActorActor*>(this)->actor_wait_state = 1;
															#line 1417 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ProcessClassCommitActorActor, 0, std::vector<ProcessData> >*>(static_cast<ProcessClassCommitActorActor*>(this)));
															#line 6790 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ProcessClassCommitActorActorState();
		static_cast<ProcessClassCommitActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<ProcessData> const& workers,int loopDepth) 
	{
															#line 1420 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		auto ranges = ryw->getSpecialKeySpaceWriteMap().containedRanges(range);
															#line 1421 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		auto iter = ranges.begin();
															#line 1422 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		for(;iter != ranges.end();) {
															#line 1423 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			auto entry = iter->value();
															#line 1425 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (entry.first && entry.second.present())
															#line 6821 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			{
															#line 1427 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				Key address = iter->begin().removePrefix(range.begin);
															#line 1428 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				AddressExclusion addr = AddressExclusion::parse(address);
															#line 1430 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				ValueRef processClassType = entry.second.get();
															#line 1431 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				ProcessClass processClass(processClassType.toString(), ProcessClass::DBSource);
															#line 1433 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				bool foundChange = false;
															#line 1434 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				for(int i = 0;i < workers.size();i++) {
															#line 1435 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					if (addr.excludes(workers[i].address))
															#line 6837 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
					{
															#line 1436 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						if (processClass.classType() != ProcessClass::InvalidClass)
															#line 6841 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
						{
															#line 1437 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
							ryw->getTransaction().set(processClassKeyFor(workers[i].locality.processId().get()), processClassValue(processClass));
															#line 6845 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
						}
						else
						{
															#line 1440 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
							ryw->getTransaction().clear(processClassKeyFor(workers[i].locality.processId().get()));
															#line 6851 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
						}
															#line 1441 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						foundChange = true;
															#line 6855 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
					}
				}
															#line 1444 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (foundChange)
															#line 6860 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
				{
															#line 1445 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					ryw->getTransaction().set(processClassChangeKey, deterministicRandom()->randomUniqueID().toString());
															#line 6864 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
				}
			}
															#line 1447 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			++iter;
															#line 6869 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		}
															#line 1449 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<ProcessClassCommitActorActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(Optional<std::string>()); this->~ProcessClassCommitActorActorState(); static_cast<ProcessClassCommitActorActor*>(this)->destroy(); return 0; }
															#line 6873 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		new (&static_cast<ProcessClassCommitActorActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(Optional<std::string>());
		this->~ProcessClassCommitActorActorState();
		static_cast<ProcessClassCommitActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<ProcessData> && workers,int loopDepth) 
	{
															#line 1420 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		auto ranges = ryw->getSpecialKeySpaceWriteMap().containedRanges(range);
															#line 1421 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		auto iter = ranges.begin();
															#line 1422 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		for(;iter != ranges.end();) {
															#line 1423 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			auto entry = iter->value();
															#line 1425 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (entry.first && entry.second.present())
															#line 6893 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			{
															#line 1427 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				Key address = iter->begin().removePrefix(range.begin);
															#line 1428 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				AddressExclusion addr = AddressExclusion::parse(address);
															#line 1430 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				ValueRef processClassType = entry.second.get();
															#line 1431 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				ProcessClass processClass(processClassType.toString(), ProcessClass::DBSource);
															#line 1433 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				bool foundChange = false;
															#line 1434 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				for(int i = 0;i < workers.size();i++) {
															#line 1435 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					if (addr.excludes(workers[i].address))
															#line 6909 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
					{
															#line 1436 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						if (processClass.classType() != ProcessClass::InvalidClass)
															#line 6913 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
						{
															#line 1437 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
							ryw->getTransaction().set(processClassKeyFor(workers[i].locality.processId().get()), processClassValue(processClass));
															#line 6917 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
						}
						else
						{
															#line 1440 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
							ryw->getTransaction().clear(processClassKeyFor(workers[i].locality.processId().get()));
															#line 6923 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
						}
															#line 1441 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						foundChange = true;
															#line 6927 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
					}
				}
															#line 1444 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (foundChange)
															#line 6932 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
				{
															#line 1445 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					ryw->getTransaction().set(processClassChangeKey, deterministicRandom()->randomUniqueID().toString());
															#line 6936 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
				}
			}
															#line 1447 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			++iter;
															#line 6941 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		}
															#line 1449 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<ProcessClassCommitActorActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(Optional<std::string>()); this->~ProcessClassCommitActorActorState(); static_cast<ProcessClassCommitActorActor*>(this)->destroy(); return 0; }
															#line 6945 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		new (&static_cast<ProcessClassCommitActorActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(Optional<std::string>());
		this->~ProcessClassCommitActorActorState();
		static_cast<ProcessClassCommitActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(std::vector<ProcessData> const& workers,int loopDepth) 
	{
		loopDepth = a_body1cont1(workers, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<ProcessData> && workers,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(workers), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ProcessClassCommitActorActor*>(this)->actor_wait_state > 0) static_cast<ProcessClassCommitActorActor*>(this)->actor_wait_state = 0;
		static_cast<ProcessClassCommitActorActor*>(this)->ActorCallback< ProcessClassCommitActorActor, 0, std::vector<ProcessData> >::remove();

	}
	void a_callback_fire(ActorCallback< ProcessClassCommitActorActor, 0, std::vector<ProcessData> >*,std::vector<ProcessData> const& value) 
	{
		fdb_probe_actor_enter("processClassCommitActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessClassCommitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processClassCommitActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ProcessClassCommitActorActor, 0, std::vector<ProcessData> >*,std::vector<ProcessData> && value) 
	{
		fdb_probe_actor_enter("processClassCommitActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessClassCommitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processClassCommitActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ProcessClassCommitActorActor, 0, std::vector<ProcessData> >*,Error err) 
	{
		fdb_probe_actor_enter("processClassCommitActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessClassCommitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processClassCommitActor", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1411 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	ReadYourWritesTransaction* ryw;
															#line 1411 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	KeyRangeRef range;
															#line 7032 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
};
// This generated class is to be used only via processClassCommitActor()
															#line 1411 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class ProcessClassCommitActorActor final : public Actor<Optional<std::string>>, public ActorCallback< ProcessClassCommitActorActor, 0, std::vector<ProcessData> >, public FastAllocated<ProcessClassCommitActorActor>, public ProcessClassCommitActorActorState<ProcessClassCommitActorActor> {
															#line 7037 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
public:
	using FastAllocated<ProcessClassCommitActorActor>::operator new;
	using FastAllocated<ProcessClassCommitActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(198336988203799552UL, 3792571445027698432UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Optional<std::string>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ProcessClassCommitActorActor, 0, std::vector<ProcessData> >;
															#line 1411 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	ProcessClassCommitActorActor(ReadYourWritesTransaction* const& ryw,KeyRangeRef const& range) 
															#line 7054 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		 : Actor<Optional<std::string>>(),
		   ProcessClassCommitActorActorState<ProcessClassCommitActorActor>(ryw, range),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("processClassCommitActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6201390959570557184UL, 15133764612521489664UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessClassCommitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("processClassCommitActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("processClassCommitActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ProcessClassCommitActorActor, 0, std::vector<ProcessData> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1411 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
[[nodiscard]] Future<Optional<std::string>> processClassCommitActor( ReadYourWritesTransaction* const& ryw, KeyRangeRef const& range ) {
															#line 1411 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	return Future<Optional<std::string>>(new ProcessClassCommitActorActor(ryw, range));
															#line 7087 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
}

#line 1451 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"

ProcessClassRangeImpl::ProcessClassRangeImpl(KeyRangeRef kr) : SpecialKeyRangeRWImpl(kr) {}

Future<RangeResult> ProcessClassRangeImpl::getRange(ReadYourWritesTransaction* ryw,
                                                    KeyRangeRef kr,
                                                    GetRangeLimits limitsHint) const {
	return getProcessClassActor(ryw, getKeyRange().begin, kr);
}

Future<Optional<std::string>> ProcessClassRangeImpl::commit(ReadYourWritesTransaction* ryw) {
	// Validate network address and process class type
	Optional<std::string> errorMsg;
	auto ranges = ryw->getSpecialKeySpaceWriteMap().containedRanges(getKeyRange());
	auto iter = ranges.begin();
	while (iter != ranges.end()) {
		auto entry = iter->value();
		// only check for setclass(set) operation, (clear) are forbidden thus not exist
		if (entry.first && entry.second.present()) {
			// validate network address
			Key address = iter->begin().removePrefix(range.begin);
			AddressExclusion addr = AddressExclusion::parse(address);
			if (!addr.isValid()) {
				std::string error = "ERROR: \'" + address.toString() + "\' is not a valid network endpoint address\n";
				if (address.toString().find(":tls") != std::string::npos)
					error += "        Do not include the `:tls' suffix when naming a process\n";
				errorMsg = ManagementAPIError::toJsonString(false, "setclass", error);
				return errorMsg;
			}
			// validate class type
			ValueRef processClassType = entry.second.get();
			ProcessClass processClass(processClassType.toString(), ProcessClass::DBSource);
			if (processClass.classType() == ProcessClass::InvalidClass && processClassType != "default"_sr) {
				std::string error = "ERROR: \'" + processClassType.toString() + "\' is not a valid process class\n";
				errorMsg = ManagementAPIError::toJsonString(false, "setclass", error);
				return errorMsg;
			}
		}
		++iter;
	}
	return processClassCommitActor(ryw, getKeyRange());
}

void throwSpecialKeyApiFailure(ReadYourWritesTransaction* ryw, std::string command, std::string message) {
	auto msg = ManagementAPIError::toJsonString(false, command, message);
	ryw->setSpecialKeySpaceErrorMsg(msg);
	throw special_keys_api_failure();
}

void ProcessClassRangeImpl::clear(ReadYourWritesTransaction* ryw, const KeyRangeRef& range) {
	return throwSpecialKeyApiFailure(ryw, "setclass", "Clear operation is meaningless thus forbidden for setclass");
}

void ProcessClassRangeImpl::clear(ReadYourWritesTransaction* ryw, const KeyRef& key) {
	return throwSpecialKeyApiFailure(
	    ryw, "setclass", "Clear range operation is meaningless thus forbidden for setclass");
}

															#line 7148 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
namespace {
// This generated class is to be used only via getProcessClassSourceActor()
															#line 1508 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
template <class GetProcessClassSourceActorActor>
															#line 1508 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class GetProcessClassSourceActorActorState {
															#line 7155 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
public:
															#line 1508 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	GetProcessClassSourceActorActorState(ReadYourWritesTransaction* const& ryw,KeyRef const& prefix,KeyRangeRef const& kr) 
															#line 1508 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
															#line 1508 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		 : ryw(ryw),
															#line 1508 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   prefix(prefix),
															#line 1508 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   kr(kr)
															#line 7166 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
	{
		fdb_probe_actor_create("getProcessClassSourceActor", reinterpret_cast<unsigned long>(this));

	}
	~GetProcessClassSourceActorActorState() 
	{
		fdb_probe_actor_destroy("getProcessClassSourceActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1509 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ryw->setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 1510 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			StrictFuture<std::vector<ProcessData>> __when_expr_0 = getWorkers(&ryw->getTransaction());
															#line 1510 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (static_cast<GetProcessClassSourceActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7185 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetProcessClassSourceActorActor*>(this)->actor_wait_state = 1;
															#line 1510 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetProcessClassSourceActorActor, 0, std::vector<ProcessData> >*>(static_cast<GetProcessClassSourceActorActor*>(this)));
															#line 7190 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetProcessClassSourceActorActorState();
		static_cast<GetProcessClassSourceActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<ProcessData> const& _workers,int loopDepth) 
	{
															#line 1511 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		auto workers = _workers;
															#line 1513 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		std::sort(workers.begin(), workers.end(), [](const ProcessData& lhs, const ProcessData& rhs) { return formatIpPort(lhs.address.ip, lhs.address.port) < formatIpPort(rhs.address.ip, rhs.address.port); });
															#line 1517 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		auto last = std::unique(workers.begin(), workers.end(), [](const ProcessData& lhs, const ProcessData& rhs) { return formatIpPort(lhs.address.ip, lhs.address.port) == formatIpPort(rhs.address.ip, rhs.address.port); });
															#line 1521 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		workers.erase(last, workers.end());
															#line 1522 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		RangeResult result;
															#line 1523 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		for( auto& w : workers ) {
															#line 1525 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			Key k(prefix.withSuffix(formatIpPort(w.address.ip, w.address.port)));
															#line 1526 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (kr.contains(k))
															#line 7227 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			{
															#line 1527 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				Value v(w.processClass.sourceString());
															#line 1528 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				result.push_back(result.arena(), KeyValueRef(k, v));
															#line 1529 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				result.arena().dependsOn(k.arena());
															#line 1530 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				result.arena().dependsOn(v.arena());
															#line 7237 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			}
		}
															#line 1533 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<GetProcessClassSourceActorActor*>(this)->SAV<RangeResult>::futures) { (void)(result); this->~GetProcessClassSourceActorActorState(); static_cast<GetProcessClassSourceActorActor*>(this)->destroy(); return 0; }
															#line 7242 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		new (&static_cast<GetProcessClassSourceActorActor*>(this)->SAV< RangeResult >::value()) RangeResult(result);
		this->~GetProcessClassSourceActorActorState();
		static_cast<GetProcessClassSourceActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<ProcessData> && _workers,int loopDepth) 
	{
															#line 1511 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		auto workers = _workers;
															#line 1513 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		std::sort(workers.begin(), workers.end(), [](const ProcessData& lhs, const ProcessData& rhs) { return formatIpPort(lhs.address.ip, lhs.address.port) < formatIpPort(rhs.address.ip, rhs.address.port); });
															#line 1517 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		auto last = std::unique(workers.begin(), workers.end(), [](const ProcessData& lhs, const ProcessData& rhs) { return formatIpPort(lhs.address.ip, lhs.address.port) == formatIpPort(rhs.address.ip, rhs.address.port); });
															#line 1521 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		workers.erase(last, workers.end());
															#line 1522 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		RangeResult result;
															#line 1523 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		for( auto& w : workers ) {
															#line 1525 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			Key k(prefix.withSuffix(formatIpPort(w.address.ip, w.address.port)));
															#line 1526 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (kr.contains(k))
															#line 7268 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			{
															#line 1527 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				Value v(w.processClass.sourceString());
															#line 1528 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				result.push_back(result.arena(), KeyValueRef(k, v));
															#line 1529 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				result.arena().dependsOn(k.arena());
															#line 1530 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				result.arena().dependsOn(v.arena());
															#line 7278 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			}
		}
															#line 1533 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<GetProcessClassSourceActorActor*>(this)->SAV<RangeResult>::futures) { (void)(result); this->~GetProcessClassSourceActorActorState(); static_cast<GetProcessClassSourceActorActor*>(this)->destroy(); return 0; }
															#line 7283 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		new (&static_cast<GetProcessClassSourceActorActor*>(this)->SAV< RangeResult >::value()) RangeResult(result);
		this->~GetProcessClassSourceActorActorState();
		static_cast<GetProcessClassSourceActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(std::vector<ProcessData> const& _workers,int loopDepth) 
	{
		loopDepth = a_body1cont1(_workers, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<ProcessData> && _workers,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_workers), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetProcessClassSourceActorActor*>(this)->actor_wait_state > 0) static_cast<GetProcessClassSourceActorActor*>(this)->actor_wait_state = 0;
		static_cast<GetProcessClassSourceActorActor*>(this)->ActorCallback< GetProcessClassSourceActorActor, 0, std::vector<ProcessData> >::remove();

	}
	void a_callback_fire(ActorCallback< GetProcessClassSourceActorActor, 0, std::vector<ProcessData> >*,std::vector<ProcessData> const& value) 
	{
		fdb_probe_actor_enter("getProcessClassSourceActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetProcessClassSourceActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getProcessClassSourceActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetProcessClassSourceActorActor, 0, std::vector<ProcessData> >*,std::vector<ProcessData> && value) 
	{
		fdb_probe_actor_enter("getProcessClassSourceActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetProcessClassSourceActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getProcessClassSourceActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetProcessClassSourceActorActor, 0, std::vector<ProcessData> >*,Error err) 
	{
		fdb_probe_actor_enter("getProcessClassSourceActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetProcessClassSourceActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getProcessClassSourceActor", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1508 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	ReadYourWritesTransaction* ryw;
															#line 1508 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	KeyRef prefix;
															#line 1508 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	KeyRangeRef kr;
															#line 7372 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
};
// This generated class is to be used only via getProcessClassSourceActor()
															#line 1508 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class GetProcessClassSourceActorActor final : public Actor<RangeResult>, public ActorCallback< GetProcessClassSourceActorActor, 0, std::vector<ProcessData> >, public FastAllocated<GetProcessClassSourceActorActor>, public GetProcessClassSourceActorActorState<GetProcessClassSourceActorActor> {
															#line 7377 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
public:
	using FastAllocated<GetProcessClassSourceActorActor>::operator new;
	using FastAllocated<GetProcessClassSourceActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9809777187880200192UL, 12761235214748964864UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<RangeResult>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetProcessClassSourceActorActor, 0, std::vector<ProcessData> >;
															#line 1508 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	GetProcessClassSourceActorActor(ReadYourWritesTransaction* const& ryw,KeyRef const& prefix,KeyRangeRef const& kr) 
															#line 7394 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		 : Actor<RangeResult>(),
		   GetProcessClassSourceActorActorState<GetProcessClassSourceActorActor>(ryw, prefix, kr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getProcessClassSourceActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2541792583674743040UL, 11696546713018679040UL);
		ActorExecutionContextHelper __helper(static_cast<GetProcessClassSourceActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getProcessClassSourceActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getProcessClassSourceActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetProcessClassSourceActorActor, 0, std::vector<ProcessData> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1508 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
[[nodiscard]] Future<RangeResult> getProcessClassSourceActor( ReadYourWritesTransaction* const& ryw, KeyRef const& prefix, KeyRangeRef const& kr ) {
															#line 1508 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	return Future<RangeResult>(new GetProcessClassSourceActorActor(ryw, prefix, kr));
															#line 7427 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
}

#line 1535 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"

ProcessClassSourceRangeImpl::ProcessClassSourceRangeImpl(KeyRangeRef kr) : SpecialKeyRangeReadImpl(kr) {}

Future<RangeResult> ProcessClassSourceRangeImpl::getRange(ReadYourWritesTransaction* ryw,
                                                          KeyRangeRef kr,
                                                          GetRangeLimits limitsHint) const {
	return getProcessClassSourceActor(ryw, getKeyRange().begin, kr);
}

															#line 7440 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
namespace {
// This generated class is to be used only via getLockedKeyActor()
															#line 1544 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
template <class GetLockedKeyActorActor>
															#line 1544 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class GetLockedKeyActorActorState {
															#line 7447 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
public:
															#line 1544 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	GetLockedKeyActorActorState(ReadYourWritesTransaction* const& ryw,KeyRangeRef const& kr) 
															#line 1544 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
															#line 1544 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		 : ryw(ryw),
															#line 1544 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   kr(kr)
															#line 7456 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
	{
		fdb_probe_actor_create("getLockedKeyActor", reinterpret_cast<unsigned long>(this));

	}
	~GetLockedKeyActorActorState() 
	{
		fdb_probe_actor_destroy("getLockedKeyActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1545 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ryw->getTransaction().setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 1546 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ryw->getTransaction().setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 1547 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = ryw->getTransaction().get(databaseLockedKey);
															#line 1547 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (static_cast<GetLockedKeyActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7477 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetLockedKeyActorActor*>(this)->actor_wait_state = 1;
															#line 1547 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetLockedKeyActorActor, 0, Optional<Value> >*>(static_cast<GetLockedKeyActorActor*>(this)));
															#line 7482 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetLockedKeyActorActorState();
		static_cast<GetLockedKeyActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> const& val,int loopDepth) 
	{
															#line 1548 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		RangeResult result;
															#line 1549 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (val.present())
															#line 7507 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		{
															#line 1550 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			UID uid = UID::fromString(BinaryReader::fromStringRef<UID>(val.get().substr(10), Unversioned()).toString());
															#line 1551 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			result.push_back_deep(result.arena(), KeyValueRef(kr.begin, Value(uid.toString())));
															#line 7513 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		}
															#line 1553 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<GetLockedKeyActorActor*>(this)->SAV<RangeResult>::futures) { (void)(result); this->~GetLockedKeyActorActorState(); static_cast<GetLockedKeyActorActor*>(this)->destroy(); return 0; }
															#line 7517 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		new (&static_cast<GetLockedKeyActorActor*>(this)->SAV< RangeResult >::value()) RangeResult(result);
		this->~GetLockedKeyActorActorState();
		static_cast<GetLockedKeyActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> && val,int loopDepth) 
	{
															#line 1548 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		RangeResult result;
															#line 1549 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (val.present())
															#line 7531 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		{
															#line 1550 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			UID uid = UID::fromString(BinaryReader::fromStringRef<UID>(val.get().substr(10), Unversioned()).toString());
															#line 1551 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			result.push_back_deep(result.arena(), KeyValueRef(kr.begin, Value(uid.toString())));
															#line 7537 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		}
															#line 1553 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<GetLockedKeyActorActor*>(this)->SAV<RangeResult>::futures) { (void)(result); this->~GetLockedKeyActorActorState(); static_cast<GetLockedKeyActorActor*>(this)->destroy(); return 0; }
															#line 7541 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		new (&static_cast<GetLockedKeyActorActor*>(this)->SAV< RangeResult >::value()) RangeResult(result);
		this->~GetLockedKeyActorActorState();
		static_cast<GetLockedKeyActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Optional<Value> const& val,int loopDepth) 
	{
		loopDepth = a_body1cont1(val, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<Value> && val,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(val), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetLockedKeyActorActor*>(this)->actor_wait_state > 0) static_cast<GetLockedKeyActorActor*>(this)->actor_wait_state = 0;
		static_cast<GetLockedKeyActorActor*>(this)->ActorCallback< GetLockedKeyActorActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< GetLockedKeyActorActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("getLockedKeyActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetLockedKeyActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLockedKeyActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetLockedKeyActorActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("getLockedKeyActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetLockedKeyActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLockedKeyActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetLockedKeyActorActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("getLockedKeyActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetLockedKeyActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLockedKeyActor", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1544 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	ReadYourWritesTransaction* ryw;
															#line 1544 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	KeyRangeRef kr;
															#line 7628 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
};
// This generated class is to be used only via getLockedKeyActor()
															#line 1544 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class GetLockedKeyActorActor final : public Actor<RangeResult>, public ActorCallback< GetLockedKeyActorActor, 0, Optional<Value> >, public FastAllocated<GetLockedKeyActorActor>, public GetLockedKeyActorActorState<GetLockedKeyActorActor> {
															#line 7633 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
public:
	using FastAllocated<GetLockedKeyActorActor>::operator new;
	using FastAllocated<GetLockedKeyActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(938428098756267776UL, 11114165369555004672UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<RangeResult>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetLockedKeyActorActor, 0, Optional<Value> >;
															#line 1544 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	GetLockedKeyActorActor(ReadYourWritesTransaction* const& ryw,KeyRangeRef const& kr) 
															#line 7650 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		 : Actor<RangeResult>(),
		   GetLockedKeyActorActorState<GetLockedKeyActorActor>(ryw, kr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getLockedKeyActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1065936102906652160UL, 2992215969153277440UL);
		ActorExecutionContextHelper __helper(static_cast<GetLockedKeyActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getLockedKeyActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getLockedKeyActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetLockedKeyActorActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1544 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
[[nodiscard]] Future<RangeResult> getLockedKeyActor( ReadYourWritesTransaction* const& ryw, KeyRangeRef const& kr ) {
															#line 1544 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	return Future<RangeResult>(new GetLockedKeyActorActor(ryw, kr));
															#line 7683 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
}

#line 1555 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"

LockDatabaseImpl::LockDatabaseImpl(KeyRangeRef kr) : SpecialKeyRangeRWImpl(kr) {}

Future<RangeResult> LockDatabaseImpl::getRange(ReadYourWritesTransaction* ryw,
                                               KeyRangeRef kr,
                                               GetRangeLimits limitsHint) const {
	// single key range, the queried range should always be the same as the underlying range
	ASSERT(kr == getKeyRange());
	auto lockEntry = ryw->getSpecialKeySpaceWriteMap()[SpecialKeySpace::getManagementApiCommandPrefix("lock")];
	if (!ryw->readYourWritesDisabled() && lockEntry.first) {
		// ryw enabled and we have written to the special key
		RangeResult result;
		if (lockEntry.second.present()) {
			result.push_back_deep(result.arena(), KeyValueRef(kr.begin, lockEntry.second.get()));
		}
		return result;
	} else {
		return getLockedKeyActor(ryw, kr);
	}
}

															#line 7708 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
namespace {
// This generated class is to be used only via lockDatabaseCommitActor()
															#line 1576 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
template <class LockDatabaseCommitActorActor>
															#line 1576 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class LockDatabaseCommitActorActorState {
															#line 7715 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
public:
															#line 1576 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	LockDatabaseCommitActorActorState(ReadYourWritesTransaction* const& ryw,UID const& uid) 
															#line 1576 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
															#line 1576 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		 : ryw(ryw),
															#line 1576 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   uid(uid),
															#line 1577 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   msg()
															#line 7726 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
	{
		fdb_probe_actor_create("lockDatabaseCommitActor", reinterpret_cast<unsigned long>(this));

	}
	~LockDatabaseCommitActorActorState() 
	{
		fdb_probe_actor_destroy("lockDatabaseCommitActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1578 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ryw->getTransaction().setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 1579 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ryw->getTransaction().setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 1580 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = ryw->getTransaction().get(databaseLockedKey);
															#line 1580 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (static_cast<LockDatabaseCommitActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7747 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<LockDatabaseCommitActorActor*>(this)->actor_wait_state = 1;
															#line 1580 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< LockDatabaseCommitActorActor, 0, Optional<Value> >*>(static_cast<LockDatabaseCommitActorActor*>(this)));
															#line 7752 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~LockDatabaseCommitActorActorState();
		static_cast<LockDatabaseCommitActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> const& val,int loopDepth) 
	{
															#line 1582 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (val.present() && BinaryReader::fromStringRef<UID>(val.get().substr(10), Unversioned()) != uid)
															#line 7775 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		{
															#line 1585 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			return a_body1Catch1(database_locked(), loopDepth);
															#line 7779 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		}
		else
		{
															#line 1586 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (!val.present())
															#line 7785 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			{
															#line 1588 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				ryw->getTransaction().atomicOp( databaseLockedKey, BinaryWriter::toValue(uid, Unversioned()).withPrefix("0123456789"_sr).withSuffix("\x00\x00\x00\x00"_sr), MutationRef::SetVersionstampedValue);
															#line 1592 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				ryw->getTransaction().addWriteConflictRange(normalKeys);
															#line 7791 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			}
		}
															#line 1595 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<LockDatabaseCommitActorActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(msg); this->~LockDatabaseCommitActorActorState(); static_cast<LockDatabaseCommitActorActor*>(this)->destroy(); return 0; }
															#line 7796 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		new (&static_cast<LockDatabaseCommitActorActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(std::move(msg)); // state_var_RVO
		this->~LockDatabaseCommitActorActorState();
		static_cast<LockDatabaseCommitActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> && val,int loopDepth) 
	{
															#line 1582 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (val.present() && BinaryReader::fromStringRef<UID>(val.get().substr(10), Unversioned()) != uid)
															#line 7808 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		{
															#line 1585 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			return a_body1Catch1(database_locked(), loopDepth);
															#line 7812 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		}
		else
		{
															#line 1586 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (!val.present())
															#line 7818 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			{
															#line 1588 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				ryw->getTransaction().atomicOp( databaseLockedKey, BinaryWriter::toValue(uid, Unversioned()).withPrefix("0123456789"_sr).withSuffix("\x00\x00\x00\x00"_sr), MutationRef::SetVersionstampedValue);
															#line 1592 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				ryw->getTransaction().addWriteConflictRange(normalKeys);
															#line 7824 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			}
		}
															#line 1595 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<LockDatabaseCommitActorActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(msg); this->~LockDatabaseCommitActorActorState(); static_cast<LockDatabaseCommitActorActor*>(this)->destroy(); return 0; }
															#line 7829 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		new (&static_cast<LockDatabaseCommitActorActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(std::move(msg)); // state_var_RVO
		this->~LockDatabaseCommitActorActorState();
		static_cast<LockDatabaseCommitActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Optional<Value> const& val,int loopDepth) 
	{
		loopDepth = a_body1cont1(val, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<Value> && val,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(val), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<LockDatabaseCommitActorActor*>(this)->actor_wait_state > 0) static_cast<LockDatabaseCommitActorActor*>(this)->actor_wait_state = 0;
		static_cast<LockDatabaseCommitActorActor*>(this)->ActorCallback< LockDatabaseCommitActorActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< LockDatabaseCommitActorActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("lockDatabaseCommitActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LockDatabaseCommitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lockDatabaseCommitActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< LockDatabaseCommitActorActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("lockDatabaseCommitActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LockDatabaseCommitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lockDatabaseCommitActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< LockDatabaseCommitActorActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("lockDatabaseCommitActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LockDatabaseCommitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lockDatabaseCommitActor", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1576 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	ReadYourWritesTransaction* ryw;
															#line 1576 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	UID uid;
															#line 1577 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	Optional<std::string> msg;
															#line 7918 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
};
// This generated class is to be used only via lockDatabaseCommitActor()
															#line 1576 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class LockDatabaseCommitActorActor final : public Actor<Optional<std::string>>, public ActorCallback< LockDatabaseCommitActorActor, 0, Optional<Value> >, public FastAllocated<LockDatabaseCommitActorActor>, public LockDatabaseCommitActorActorState<LockDatabaseCommitActorActor> {
															#line 7923 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
public:
	using FastAllocated<LockDatabaseCommitActorActor>::operator new;
	using FastAllocated<LockDatabaseCommitActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11405843492667270656UL, 1407527792281163264UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Optional<std::string>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< LockDatabaseCommitActorActor, 0, Optional<Value> >;
															#line 1576 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	LockDatabaseCommitActorActor(ReadYourWritesTransaction* const& ryw,UID const& uid) 
															#line 7940 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		 : Actor<Optional<std::string>>(),
		   LockDatabaseCommitActorActorState<LockDatabaseCommitActorActor>(ryw, uid),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("lockDatabaseCommitActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(126074855386773248UL, 15412498777109478144UL);
		ActorExecutionContextHelper __helper(static_cast<LockDatabaseCommitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("lockDatabaseCommitActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("lockDatabaseCommitActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< LockDatabaseCommitActorActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1576 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
[[nodiscard]] Future<Optional<std::string>> lockDatabaseCommitActor( ReadYourWritesTransaction* const& ryw, UID const& uid ) {
															#line 1576 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	return Future<Optional<std::string>>(new LockDatabaseCommitActorActor(ryw, uid));
															#line 7973 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
}

#line 1597 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"

															#line 7978 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
namespace {
// This generated class is to be used only via unlockDatabaseCommitActor()
															#line 1598 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
template <class UnlockDatabaseCommitActorActor>
															#line 1598 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class UnlockDatabaseCommitActorActorState {
															#line 7985 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
public:
															#line 1598 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	UnlockDatabaseCommitActorActorState(ReadYourWritesTransaction* const& ryw) 
															#line 1598 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
															#line 1598 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		 : ryw(ryw)
															#line 7992 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
	{
		fdb_probe_actor_create("unlockDatabaseCommitActor", reinterpret_cast<unsigned long>(this));

	}
	~UnlockDatabaseCommitActorActorState() 
	{
		fdb_probe_actor_destroy("unlockDatabaseCommitActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1599 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ryw->getTransaction().setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 1600 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ryw->getTransaction().setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 1601 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = ryw->getTransaction().get(databaseLockedKey);
															#line 1601 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (static_cast<UnlockDatabaseCommitActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8013 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<UnlockDatabaseCommitActorActor*>(this)->actor_wait_state = 1;
															#line 1601 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< UnlockDatabaseCommitActorActor, 0, Optional<Value> >*>(static_cast<UnlockDatabaseCommitActorActor*>(this)));
															#line 8018 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~UnlockDatabaseCommitActorActorState();
		static_cast<UnlockDatabaseCommitActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> const& val,int loopDepth) 
	{
															#line 1602 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (val.present())
															#line 8041 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		{
															#line 1603 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ryw->getTransaction().clear(singleKeyRange(databaseLockedKey));
															#line 8045 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		}
															#line 1605 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<UnlockDatabaseCommitActorActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(Optional<std::string>()); this->~UnlockDatabaseCommitActorActorState(); static_cast<UnlockDatabaseCommitActorActor*>(this)->destroy(); return 0; }
															#line 8049 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		new (&static_cast<UnlockDatabaseCommitActorActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(Optional<std::string>());
		this->~UnlockDatabaseCommitActorActorState();
		static_cast<UnlockDatabaseCommitActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> && val,int loopDepth) 
	{
															#line 1602 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (val.present())
															#line 8061 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		{
															#line 1603 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ryw->getTransaction().clear(singleKeyRange(databaseLockedKey));
															#line 8065 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		}
															#line 1605 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<UnlockDatabaseCommitActorActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(Optional<std::string>()); this->~UnlockDatabaseCommitActorActorState(); static_cast<UnlockDatabaseCommitActorActor*>(this)->destroy(); return 0; }
															#line 8069 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		new (&static_cast<UnlockDatabaseCommitActorActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(Optional<std::string>());
		this->~UnlockDatabaseCommitActorActorState();
		static_cast<UnlockDatabaseCommitActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Optional<Value> const& val,int loopDepth) 
	{
		loopDepth = a_body1cont1(val, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<Value> && val,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(val), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UnlockDatabaseCommitActorActor*>(this)->actor_wait_state > 0) static_cast<UnlockDatabaseCommitActorActor*>(this)->actor_wait_state = 0;
		static_cast<UnlockDatabaseCommitActorActor*>(this)->ActorCallback< UnlockDatabaseCommitActorActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< UnlockDatabaseCommitActorActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("unlockDatabaseCommitActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UnlockDatabaseCommitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("unlockDatabaseCommitActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UnlockDatabaseCommitActorActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("unlockDatabaseCommitActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UnlockDatabaseCommitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("unlockDatabaseCommitActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< UnlockDatabaseCommitActorActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("unlockDatabaseCommitActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UnlockDatabaseCommitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("unlockDatabaseCommitActor", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1598 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	ReadYourWritesTransaction* ryw;
															#line 8154 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
};
// This generated class is to be used only via unlockDatabaseCommitActor()
															#line 1598 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class UnlockDatabaseCommitActorActor final : public Actor<Optional<std::string>>, public ActorCallback< UnlockDatabaseCommitActorActor, 0, Optional<Value> >, public FastAllocated<UnlockDatabaseCommitActorActor>, public UnlockDatabaseCommitActorActorState<UnlockDatabaseCommitActorActor> {
															#line 8159 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
public:
	using FastAllocated<UnlockDatabaseCommitActorActor>::operator new;
	using FastAllocated<UnlockDatabaseCommitActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(85279437328035840UL, 8766164067476944128UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Optional<std::string>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< UnlockDatabaseCommitActorActor, 0, Optional<Value> >;
															#line 1598 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	UnlockDatabaseCommitActorActor(ReadYourWritesTransaction* const& ryw) 
															#line 8176 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		 : Actor<Optional<std::string>>(),
		   UnlockDatabaseCommitActorActorState<UnlockDatabaseCommitActorActor>(ryw),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("unlockDatabaseCommitActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14993729202959126272UL, 16424019614688849920UL);
		ActorExecutionContextHelper __helper(static_cast<UnlockDatabaseCommitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("unlockDatabaseCommitActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("unlockDatabaseCommitActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< UnlockDatabaseCommitActorActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1598 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
[[nodiscard]] Future<Optional<std::string>> unlockDatabaseCommitActor( ReadYourWritesTransaction* const& ryw ) {
															#line 1598 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	return Future<Optional<std::string>>(new UnlockDatabaseCommitActorActor(ryw));
															#line 8209 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
}

#line 1607 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"

Future<Optional<std::string>> LockDatabaseImpl::commit(ReadYourWritesTransaction* ryw) {
	auto lockId = ryw->getSpecialKeySpaceWriteMap()[SpecialKeySpace::getManagementApiCommandPrefix("lock")].second;
	if (lockId.present()) {
		std::string uidStr = lockId.get().toString();
		UID uid;
		try {
			uid = UID::fromString(uidStr);
		} catch (Error& e) {
			return Optional<std::string>(
			    ManagementAPIError::toJsonString(false, "lock", "Invalid UID hex string: " + uidStr));
		}
		return lockDatabaseCommitActor(ryw, uid);
	} else {
		return unlockDatabaseCommitActor(ryw);
	}
}

															#line 8231 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
namespace {
// This generated class is to be used only via getConsistencyCheckKeyActor()
															#line 1625 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
template <class GetConsistencyCheckKeyActorActor>
															#line 1625 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class GetConsistencyCheckKeyActorActorState {
															#line 8238 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
public:
															#line 1625 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	GetConsistencyCheckKeyActorActorState(ReadYourWritesTransaction* const& ryw,KeyRangeRef const& kr) 
															#line 1625 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
															#line 1625 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		 : ryw(ryw),
															#line 1625 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   kr(kr)
															#line 8247 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
	{
		fdb_probe_actor_create("getConsistencyCheckKeyActor", reinterpret_cast<unsigned long>(this));

	}
	~GetConsistencyCheckKeyActorActorState() 
	{
		fdb_probe_actor_destroy("getConsistencyCheckKeyActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1626 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ryw->getTransaction().setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 1627 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ryw->getTransaction().setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 1628 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ryw->getTransaction().setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 1629 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = ryw->getTransaction().get(fdbShouldConsistencyCheckBeSuspended);
															#line 1629 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (static_cast<GetConsistencyCheckKeyActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8270 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetConsistencyCheckKeyActorActor*>(this)->actor_wait_state = 1;
															#line 1629 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetConsistencyCheckKeyActorActor, 0, Optional<Value> >*>(static_cast<GetConsistencyCheckKeyActorActor*>(this)));
															#line 8275 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetConsistencyCheckKeyActorActorState();
		static_cast<GetConsistencyCheckKeyActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> const& val,int loopDepth) 
	{
															#line 1630 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		bool ccSuspendSetting = val.present() ? BinaryReader::fromStringRef<bool>(val.get(), Unversioned()) : false;
															#line 1631 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		RangeResult result;
															#line 1632 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (ccSuspendSetting)
															#line 8302 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		{
															#line 1633 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			result.push_back_deep(result.arena(), KeyValueRef(kr.begin, ValueRef()));
															#line 8306 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		}
															#line 1635 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<GetConsistencyCheckKeyActorActor*>(this)->SAV<RangeResult>::futures) { (void)(result); this->~GetConsistencyCheckKeyActorActorState(); static_cast<GetConsistencyCheckKeyActorActor*>(this)->destroy(); return 0; }
															#line 8310 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		new (&static_cast<GetConsistencyCheckKeyActorActor*>(this)->SAV< RangeResult >::value()) RangeResult(result);
		this->~GetConsistencyCheckKeyActorActorState();
		static_cast<GetConsistencyCheckKeyActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> && val,int loopDepth) 
	{
															#line 1630 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		bool ccSuspendSetting = val.present() ? BinaryReader::fromStringRef<bool>(val.get(), Unversioned()) : false;
															#line 1631 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		RangeResult result;
															#line 1632 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (ccSuspendSetting)
															#line 8326 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		{
															#line 1633 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			result.push_back_deep(result.arena(), KeyValueRef(kr.begin, ValueRef()));
															#line 8330 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		}
															#line 1635 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<GetConsistencyCheckKeyActorActor*>(this)->SAV<RangeResult>::futures) { (void)(result); this->~GetConsistencyCheckKeyActorActorState(); static_cast<GetConsistencyCheckKeyActorActor*>(this)->destroy(); return 0; }
															#line 8334 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		new (&static_cast<GetConsistencyCheckKeyActorActor*>(this)->SAV< RangeResult >::value()) RangeResult(result);
		this->~GetConsistencyCheckKeyActorActorState();
		static_cast<GetConsistencyCheckKeyActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Optional<Value> const& val,int loopDepth) 
	{
		loopDepth = a_body1cont1(val, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<Value> && val,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(val), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetConsistencyCheckKeyActorActor*>(this)->actor_wait_state > 0) static_cast<GetConsistencyCheckKeyActorActor*>(this)->actor_wait_state = 0;
		static_cast<GetConsistencyCheckKeyActorActor*>(this)->ActorCallback< GetConsistencyCheckKeyActorActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< GetConsistencyCheckKeyActorActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("getConsistencyCheckKeyActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetConsistencyCheckKeyActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getConsistencyCheckKeyActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetConsistencyCheckKeyActorActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("getConsistencyCheckKeyActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetConsistencyCheckKeyActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getConsistencyCheckKeyActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetConsistencyCheckKeyActorActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("getConsistencyCheckKeyActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetConsistencyCheckKeyActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getConsistencyCheckKeyActor", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1625 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	ReadYourWritesTransaction* ryw;
															#line 1625 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	KeyRangeRef kr;
															#line 8421 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
};
// This generated class is to be used only via getConsistencyCheckKeyActor()
															#line 1625 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class GetConsistencyCheckKeyActorActor final : public Actor<RangeResult>, public ActorCallback< GetConsistencyCheckKeyActorActor, 0, Optional<Value> >, public FastAllocated<GetConsistencyCheckKeyActorActor>, public GetConsistencyCheckKeyActorActorState<GetConsistencyCheckKeyActorActor> {
															#line 8426 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
public:
	using FastAllocated<GetConsistencyCheckKeyActorActor>::operator new;
	using FastAllocated<GetConsistencyCheckKeyActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8788247492836152320UL, 14402760385005610496UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<RangeResult>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetConsistencyCheckKeyActorActor, 0, Optional<Value> >;
															#line 1625 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	GetConsistencyCheckKeyActorActor(ReadYourWritesTransaction* const& ryw,KeyRangeRef const& kr) 
															#line 8443 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		 : Actor<RangeResult>(),
		   GetConsistencyCheckKeyActorActorState<GetConsistencyCheckKeyActorActor>(ryw, kr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getConsistencyCheckKeyActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14611963771812431104UL, 9262370184234012160UL);
		ActorExecutionContextHelper __helper(static_cast<GetConsistencyCheckKeyActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getConsistencyCheckKeyActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getConsistencyCheckKeyActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetConsistencyCheckKeyActorActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1625 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
[[nodiscard]] Future<RangeResult> getConsistencyCheckKeyActor( ReadYourWritesTransaction* const& ryw, KeyRangeRef const& kr ) {
															#line 1625 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	return Future<RangeResult>(new GetConsistencyCheckKeyActorActor(ryw, kr));
															#line 8476 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
}

#line 1637 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"

ConsistencyCheckImpl::ConsistencyCheckImpl(KeyRangeRef kr) : SpecialKeyRangeRWImpl(kr) {}

Future<RangeResult> ConsistencyCheckImpl::getRange(ReadYourWritesTransaction* ryw,
                                                   KeyRangeRef kr,
                                                   GetRangeLimits limitsHint) const {
	// single key range, the queried range should always be the same as the underlying range
	ASSERT(kr == getKeyRange());
	auto entry = ryw->getSpecialKeySpaceWriteMap()[SpecialKeySpace::getManagementApiCommandPrefix("consistencycheck")];
	if (!ryw->readYourWritesDisabled() && entry.first) {
		// ryw enabled and we have written to the special key
		RangeResult result;
		if (entry.second.present()) {
			result.push_back_deep(result.arena(), KeyValueRef(kr.begin, entry.second.get()));
		}
		return result;
	} else {
		return getConsistencyCheckKeyActor(ryw, kr);
	}
}

Future<Optional<std::string>> ConsistencyCheckImpl::commit(ReadYourWritesTransaction* ryw) {
	auto entry =
	    ryw->getSpecialKeySpaceWriteMap()[SpecialKeySpace::getManagementApiCommandPrefix("consistencycheck")].second;
	ryw->getTransaction().setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
	ryw->getTransaction().setOption(FDBTransactionOptions::LOCK_AWARE);
	ryw->getTransaction().setOption(FDBTransactionOptions::RAW_ACCESS);
	ryw->getTransaction().set(fdbShouldConsistencyCheckBeSuspended,
	                          BinaryWriter::toValue(entry.present(), Unversioned()));
	return Optional<std::string>();
}

GlobalConfigImpl::GlobalConfigImpl(KeyRangeRef kr) : SpecialKeyRangeRWImpl(kr) {}

// Returns key-value pairs for each value stored in the global configuration
// framework within the range specified. The special-key-space getrange
// function should only be used for informational purposes. All values are
// returned as strings regardless of their true type.
Future<RangeResult> GlobalConfigImpl::getRange(ReadYourWritesTransaction* ryw,
                                               KeyRangeRef kr,
                                               GetRangeLimits limitsHint) const {
	RangeResult result;
	KeyRangeRef modified =
	    KeyRangeRef(kr.begin.removePrefix(getKeyRange().begin), kr.end.removePrefix(getKeyRange().begin));
	std::map<KeyRef, Reference<ConfigValue>> values = ryw->getDatabase()->globalConfig->get(modified);
	for (const auto& [key, config] : values) {
		Key prefixedKey = key.withPrefix(getKeyRange().begin);
		if (config.isValid() && config->value.has_value()) {
			if (config->value.type() == typeid(StringRef)) {
				result.push_back_deep(result.arena(),
				                      KeyValueRef(prefixedKey, std::any_cast<StringRef>(config->value).toString()));
			} else if (config->value.type() == typeid(int64_t)) {
				result.push_back_deep(result.arena(),
				                      KeyValueRef(prefixedKey, std::to_string(std::any_cast<int64_t>(config->value))));
			} else if (config->value.type() == typeid(bool)) {
				result.push_back_deep(result.arena(),
				                      KeyValueRef(prefixedKey, std::to_string(std::any_cast<bool>(config->value))));
			} else if (config->value.type() == typeid(float)) {
				result.push_back_deep(result.arena(),
				                      KeyValueRef(prefixedKey, std::to_string(std::any_cast<float>(config->value))));
			} else if (config->value.type() == typeid(double)) {
				result.push_back_deep(result.arena(),
				                      KeyValueRef(prefixedKey, std::to_string(std::any_cast<double>(config->value))));
			} else {
				ASSERT(false);
			}
		}
	}

	return result;
}

// Marks the key for insertion into global configuration.
void GlobalConfigImpl::set(ReadYourWritesTransaction* ryw, const KeyRef& key, const ValueRef& value) {
	ryw->getSpecialKeySpaceWriteMap().insert(key, std::make_pair(true, Optional<Value>(value)));
}

// Writes global configuration changes to durable memory. Also writes the
// changes made in the transaction to a recent history set, and updates the
// latest version which the global configuration was updated at.
															#line 8560 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
namespace {
// This generated class is to be used only via globalConfigCommitActor()
															#line 1717 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
template <class GlobalConfigCommitActorActor>
															#line 1717 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class GlobalConfigCommitActorActorState {
															#line 8567 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
public:
															#line 1717 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	GlobalConfigCommitActorActorState(GlobalConfigImpl* const& globalConfig,ReadYourWritesTransaction* const& ryw) 
															#line 1717 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
															#line 1717 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		 : globalConfig(globalConfig),
															#line 1717 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   ryw(ryw),
															#line 1719 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   tr(ryw->getTransaction())
															#line 8578 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
	{
		fdb_probe_actor_create("globalConfigCommitActor", reinterpret_cast<unsigned long>(this));

	}
	~GlobalConfigCommitActorActorState() 
	{
		fdb_probe_actor_destroy("globalConfigCommitActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1720 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ryw->setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 1724 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr.getRange(globalConfigHistoryKeys, CLIENT_KNOBS->TOO_MANY);
															#line 1724 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (static_cast<GlobalConfigCommitActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8597 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GlobalConfigCommitActorActor*>(this)->actor_wait_state = 1;
															#line 1724 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GlobalConfigCommitActorActor, 0, RangeResult >*>(static_cast<GlobalConfigCommitActorActor*>(this)));
															#line 8602 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GlobalConfigCommitActorActorState();
		static_cast<GlobalConfigCommitActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(RangeResult const& history,int loopDepth) 
	{
															#line 1725 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		constexpr int kGlobalConfigMaxHistorySize = 3;
															#line 1726 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (history.size() > kGlobalConfigMaxHistorySize - 1)
															#line 8627 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		{
															#line 1727 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			for(int i = 0;i < history.size() - (kGlobalConfigMaxHistorySize - 1);++i) {
															#line 1728 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				tr.clear(history[i].key);
															#line 8633 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			}
		}
															#line 1732 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		Standalone<VectorRef<KeyValueRef>> insertions;
															#line 1733 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		Standalone<VectorRef<KeyRangeRef>> clears;
															#line 1738 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		ranges = ryw->getSpecialKeySpaceWriteMap().containedRanges(specialKeys);
															#line 1740 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		iter = ranges.begin();
															#line 1741 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		for(;iter != ranges.end();) {
															#line 1742 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			std::pair<bool, Optional<Value>> entry = iter->value();
															#line 1743 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (entry.first)
															#line 8650 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			{
															#line 1744 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (entry.second.present() && iter->begin().startsWith(globalConfig->getKeyRange().begin))
															#line 8654 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
				{
															#line 1745 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					Key bareKey = iter->begin().removePrefix(globalConfig->getKeyRange().begin);
															#line 1746 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					insertions.push_back_deep(insertions.arena(), KeyValueRef(bareKey, entry.second.get()));
															#line 8660 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
				}
				else
				{
															#line 1747 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					if (!entry.second.present() && iter->range().begin.startsWith(globalConfig->getKeyRange().begin) && iter->range().end.startsWith(globalConfig->getKeyRange().begin))
															#line 8666 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
					{
															#line 1749 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						KeyRef bareRangeBegin = iter->range().begin.removePrefix(globalConfig->getKeyRange().begin);
															#line 1750 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						KeyRef bareRangeEnd = iter->range().end.removePrefix(globalConfig->getKeyRange().begin);
															#line 1751 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						clears.push_back_deep(clears.arena(), KeyRangeRef(bareRangeBegin, bareRangeEnd));
															#line 8674 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
					}
				}
			}
															#line 1754 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			++iter;
															#line 8680 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		}
															#line 1756 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		GlobalConfig::applyChanges(tr, insertions, clears);
															#line 1758 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<GlobalConfigCommitActorActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(Optional<std::string>()); this->~GlobalConfigCommitActorActorState(); static_cast<GlobalConfigCommitActorActor*>(this)->destroy(); return 0; }
															#line 8686 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		new (&static_cast<GlobalConfigCommitActorActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(Optional<std::string>());
		this->~GlobalConfigCommitActorActorState();
		static_cast<GlobalConfigCommitActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(RangeResult && history,int loopDepth) 
	{
															#line 1725 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		constexpr int kGlobalConfigMaxHistorySize = 3;
															#line 1726 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (history.size() > kGlobalConfigMaxHistorySize - 1)
															#line 8700 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		{
															#line 1727 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			for(int i = 0;i < history.size() - (kGlobalConfigMaxHistorySize - 1);++i) {
															#line 1728 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				tr.clear(history[i].key);
															#line 8706 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			}
		}
															#line 1732 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		Standalone<VectorRef<KeyValueRef>> insertions;
															#line 1733 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		Standalone<VectorRef<KeyRangeRef>> clears;
															#line 1738 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		ranges = ryw->getSpecialKeySpaceWriteMap().containedRanges(specialKeys);
															#line 1740 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		iter = ranges.begin();
															#line 1741 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		for(;iter != ranges.end();) {
															#line 1742 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			std::pair<bool, Optional<Value>> entry = iter->value();
															#line 1743 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (entry.first)
															#line 8723 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			{
															#line 1744 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (entry.second.present() && iter->begin().startsWith(globalConfig->getKeyRange().begin))
															#line 8727 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
				{
															#line 1745 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					Key bareKey = iter->begin().removePrefix(globalConfig->getKeyRange().begin);
															#line 1746 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					insertions.push_back_deep(insertions.arena(), KeyValueRef(bareKey, entry.second.get()));
															#line 8733 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
				}
				else
				{
															#line 1747 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					if (!entry.second.present() && iter->range().begin.startsWith(globalConfig->getKeyRange().begin) && iter->range().end.startsWith(globalConfig->getKeyRange().begin))
															#line 8739 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
					{
															#line 1749 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						KeyRef bareRangeBegin = iter->range().begin.removePrefix(globalConfig->getKeyRange().begin);
															#line 1750 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						KeyRef bareRangeEnd = iter->range().end.removePrefix(globalConfig->getKeyRange().begin);
															#line 1751 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						clears.push_back_deep(clears.arena(), KeyRangeRef(bareRangeBegin, bareRangeEnd));
															#line 8747 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
					}
				}
			}
															#line 1754 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			++iter;
															#line 8753 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		}
															#line 1756 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		GlobalConfig::applyChanges(tr, insertions, clears);
															#line 1758 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<GlobalConfigCommitActorActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(Optional<std::string>()); this->~GlobalConfigCommitActorActorState(); static_cast<GlobalConfigCommitActorActor*>(this)->destroy(); return 0; }
															#line 8759 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		new (&static_cast<GlobalConfigCommitActorActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(Optional<std::string>());
		this->~GlobalConfigCommitActorActorState();
		static_cast<GlobalConfigCommitActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(RangeResult const& history,int loopDepth) 
	{
		loopDepth = a_body1cont1(history, loopDepth);

		return loopDepth;
	}
	int a_body1when1(RangeResult && history,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(history), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GlobalConfigCommitActorActor*>(this)->actor_wait_state > 0) static_cast<GlobalConfigCommitActorActor*>(this)->actor_wait_state = 0;
		static_cast<GlobalConfigCommitActorActor*>(this)->ActorCallback< GlobalConfigCommitActorActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< GlobalConfigCommitActorActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("globalConfigCommitActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigCommitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigCommitActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GlobalConfigCommitActorActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("globalConfigCommitActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigCommitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigCommitActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GlobalConfigCommitActorActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("globalConfigCommitActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigCommitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigCommitActor", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1717 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	GlobalConfigImpl* globalConfig;
															#line 1717 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	ReadYourWritesTransaction* ryw;
															#line 1719 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	Transaction& tr;
															#line 1738 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	RangeMap<Key, std::pair<bool, Optional<Value>>, KeyRangeRef>::Ranges ranges;
															#line 1740 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	RangeMap<Key, std::pair<bool, Optional<Value>>, KeyRangeRef>::iterator iter;
															#line 8852 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
};
// This generated class is to be used only via globalConfigCommitActor()
															#line 1717 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class GlobalConfigCommitActorActor final : public Actor<Optional<std::string>>, public ActorCallback< GlobalConfigCommitActorActor, 0, RangeResult >, public FastAllocated<GlobalConfigCommitActorActor>, public GlobalConfigCommitActorActorState<GlobalConfigCommitActorActor> {
															#line 8857 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
public:
	using FastAllocated<GlobalConfigCommitActorActor>::operator new;
	using FastAllocated<GlobalConfigCommitActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12709388026743853568UL, 8699405687876768256UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Optional<std::string>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GlobalConfigCommitActorActor, 0, RangeResult >;
															#line 1717 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	GlobalConfigCommitActorActor(GlobalConfigImpl* const& globalConfig,ReadYourWritesTransaction* const& ryw) 
															#line 8874 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		 : Actor<Optional<std::string>>(),
		   GlobalConfigCommitActorActorState<GlobalConfigCommitActorActor>(globalConfig, ryw),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("globalConfigCommitActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7286398798349763072UL, 930146673228728064UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigCommitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("globalConfigCommitActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("globalConfigCommitActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GlobalConfigCommitActorActor, 0, RangeResult >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1717 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
[[nodiscard]] Future<Optional<std::string>> globalConfigCommitActor( GlobalConfigImpl* const& globalConfig, ReadYourWritesTransaction* const& ryw ) {
															#line 1717 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	return Future<Optional<std::string>>(new GlobalConfigCommitActorActor(globalConfig, ryw));
															#line 8907 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
}

#line 1760 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"

// Called when a transaction includes keys in the global configuration special-key-space range.
Future<Optional<std::string>> GlobalConfigImpl::commit(ReadYourWritesTransaction* ryw) {
	return globalConfigCommitActor(this, ryw);
}

// Marks the range for deletion from global configuration.
void GlobalConfigImpl::clear(ReadYourWritesTransaction* ryw, const KeyRangeRef& range) {
	ryw->getSpecialKeySpaceWriteMap().insert(range, std::make_pair(true, Optional<Value>()));
}

// Marks the key for deletion from global configuration.
void GlobalConfigImpl::clear(ReadYourWritesTransaction* ryw, const KeyRef& key) {
	ryw->getSpecialKeySpaceWriteMap().insert(key, std::make_pair(true, Optional<Value>()));
}

TracingOptionsImpl::TracingOptionsImpl(KeyRangeRef kr) : SpecialKeyRangeRWImpl(kr) {}

Future<RangeResult> TracingOptionsImpl::getRange(ReadYourWritesTransaction* ryw,
                                                 KeyRangeRef kr,
                                                 GetRangeLimits limitsHint) const {
	RangeResult result;
	for (const auto& option : SpecialKeySpace::getTracingOptions()) {
		auto key = getKeyRange().begin.withSuffix(option);
		if (!kr.contains(key)) {
			continue;
		}

		if (key.endsWith(kTracingTransactionIdKey)) {
			result.push_back_deep(result.arena(),
			                      KeyValueRef(key, ryw->getTransactionState()->spanContext.traceID.toString()));
		} else if (key.endsWith(kTracingTokenKey)) {
			result.push_back_deep(result.arena(),
			                      KeyValueRef(key, std::to_string(ryw->getTransactionState()->spanContext.spanID)));
		}
	}
	return result;
}

void TracingOptionsImpl::set(ReadYourWritesTransaction* ryw, const KeyRef& key, const ValueRef& value) {
	if (ryw->getApproximateSize() > 0) {
		ryw->setSpecialKeySpaceErrorMsg(
		    ManagementAPIError::toJsonString(false, "configure trace", "tracing options must be set first"));
		ryw->getSpecialKeySpaceWriteMap().insert(key, std::make_pair(true, Optional<Value>()));
		return;
	}

	if (key.endsWith(kTracingTransactionIdKey)) {
		ryw->setTransactionID(UID::fromString(value.toString()));
	} else if (key.endsWith(kTracingTokenKey)) {
		if (value.toString() == "true") {
			ryw->setToken(deterministicRandom()->randomUInt64());
		} else if (value.toString() == "false") {
			ryw->setToken(0);
		} else {
			ryw->setSpecialKeySpaceErrorMsg(
			    ManagementAPIError::toJsonString(false, "configure trace token", "token must be set to true/false"));
			throw special_keys_api_failure();
		}
	}
}

Future<Optional<std::string>> TracingOptionsImpl::commit(ReadYourWritesTransaction* ryw) {
	if (ryw->getSpecialKeySpaceWriteMap().size() > 0) {
		throw special_keys_api_failure();
	}
	return Optional<std::string>();
}

void TracingOptionsImpl::clear(ReadYourWritesTransaction* ryw, const KeyRangeRef& range) {
	ryw->setSpecialKeySpaceErrorMsg(ManagementAPIError::toJsonString(false, "clear trace", "clear range disabled"));
	throw special_keys_api_failure();
}

void TracingOptionsImpl::clear(ReadYourWritesTransaction* ryw, const KeyRef& key) {
	ryw->setSpecialKeySpaceErrorMsg(ManagementAPIError::toJsonString(false, "clear trace", "clear disabled"));
	throw special_keys_api_failure();
}

CoordinatorsImpl::CoordinatorsImpl(KeyRangeRef kr) : SpecialKeyRangeRWImpl(kr) {}

															#line 8992 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
namespace {
// This generated class is to be used only via coordinatorsGetRangeActor()
															#line 1841 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
template <class CoordinatorsGetRangeActorActor>
															#line 1841 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class CoordinatorsGetRangeActorActorState {
															#line 8999 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
public:
															#line 1841 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	CoordinatorsGetRangeActorActorState(ReadYourWritesTransaction* const& ryw,KeyRef const& prefix,KeyRangeRef const& kr) 
															#line 1841 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
															#line 1841 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		 : ryw(ryw),
															#line 1841 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   prefix(prefix),
															#line 1841 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   kr(kr),
															#line 1842 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   cs(ryw->getDatabase()->getConnectionRecord()->getConnectionString())
															#line 9012 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
	{
		fdb_probe_actor_create("coordinatorsGetRangeActor", reinterpret_cast<unsigned long>(this));

	}
	~CoordinatorsGetRangeActorActorState() 
	{
		fdb_probe_actor_destroy("coordinatorsGetRangeActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1843 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			StrictFuture<std::vector<NetworkAddress>> __when_expr_0 = cs.tryResolveHostnames();
															#line 1843 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (static_cast<CoordinatorsGetRangeActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9029 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CoordinatorsGetRangeActorActor*>(this)->actor_wait_state = 1;
															#line 1843 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CoordinatorsGetRangeActorActor, 0, std::vector<NetworkAddress> >*>(static_cast<CoordinatorsGetRangeActorActor*>(this)));
															#line 9034 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CoordinatorsGetRangeActorActorState();
		static_cast<CoordinatorsGetRangeActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1844 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		RangeResult result;
															#line 1845 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		Key cluster_description_key = prefix.withSuffix("cluster_description"_sr);
															#line 1846 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (kr.contains(cluster_description_key))
															#line 9061 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		{
															#line 1847 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			result.push_back_deep(result.arena(), KeyValueRef(cluster_description_key, cs.clusterKeyName()));
															#line 9065 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		}
															#line 1851 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		std::sort(coordinator_processes.begin(), coordinator_processes.end(), [](const NetworkAddress& lhs, const NetworkAddress& rhs) { return lhs.toString() < rhs.toString(); });
															#line 1854 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		std::string processes_str;
															#line 1855 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		for( const auto& w : coordinator_processes ) {
															#line 1856 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (processes_str.size())
															#line 9075 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			{
															#line 1857 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				processes_str += ",";
															#line 9079 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			}
															#line 1858 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			processes_str += w.toString();
															#line 9083 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		}
															#line 1860 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		Key processes_key = prefix.withSuffix("processes"_sr);
															#line 1861 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (kr.contains(processes_key))
															#line 9089 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		{
															#line 1862 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			result.push_back_deep(result.arena(), KeyValueRef(processes_key, Value(processes_str)));
															#line 9093 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		}
															#line 1864 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<CoordinatorsGetRangeActorActor*>(this)->SAV<RangeResult>::futures) { (void)(rywGetRange(ryw, kr, result)); this->~CoordinatorsGetRangeActorActorState(); static_cast<CoordinatorsGetRangeActorActor*>(this)->destroy(); return 0; }
															#line 9097 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		new (&static_cast<CoordinatorsGetRangeActorActor*>(this)->SAV< RangeResult >::value()) RangeResult(rywGetRange(ryw, kr, result));
		this->~CoordinatorsGetRangeActorActorState();
		static_cast<CoordinatorsGetRangeActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(std::vector<NetworkAddress> const& __coordinator_processes,int loopDepth) 
	{
															#line 1843 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		coordinator_processes = __coordinator_processes;
															#line 9109 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<NetworkAddress> && __coordinator_processes,int loopDepth) 
	{
		coordinator_processes = std::move(__coordinator_processes);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CoordinatorsGetRangeActorActor*>(this)->actor_wait_state > 0) static_cast<CoordinatorsGetRangeActorActor*>(this)->actor_wait_state = 0;
		static_cast<CoordinatorsGetRangeActorActor*>(this)->ActorCallback< CoordinatorsGetRangeActorActor, 0, std::vector<NetworkAddress> >::remove();

	}
	void a_callback_fire(ActorCallback< CoordinatorsGetRangeActorActor, 0, std::vector<NetworkAddress> >*,std::vector<NetworkAddress> const& value) 
	{
		fdb_probe_actor_enter("coordinatorsGetRangeActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CoordinatorsGetRangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("coordinatorsGetRangeActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CoordinatorsGetRangeActorActor, 0, std::vector<NetworkAddress> >*,std::vector<NetworkAddress> && value) 
	{
		fdb_probe_actor_enter("coordinatorsGetRangeActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CoordinatorsGetRangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("coordinatorsGetRangeActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CoordinatorsGetRangeActorActor, 0, std::vector<NetworkAddress> >*,Error err) 
	{
		fdb_probe_actor_enter("coordinatorsGetRangeActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CoordinatorsGetRangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("coordinatorsGetRangeActor", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1841 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	ReadYourWritesTransaction* ryw;
															#line 1841 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	KeyRef prefix;
															#line 1841 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	KeyRangeRef kr;
															#line 1842 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	ClusterConnectionString cs;
															#line 1843 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	std::vector<NetworkAddress> coordinator_processes;
															#line 9194 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
};
// This generated class is to be used only via coordinatorsGetRangeActor()
															#line 1841 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class CoordinatorsGetRangeActorActor final : public Actor<RangeResult>, public ActorCallback< CoordinatorsGetRangeActorActor, 0, std::vector<NetworkAddress> >, public FastAllocated<CoordinatorsGetRangeActorActor>, public CoordinatorsGetRangeActorActorState<CoordinatorsGetRangeActorActor> {
															#line 9199 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
public:
	using FastAllocated<CoordinatorsGetRangeActorActor>::operator new;
	using FastAllocated<CoordinatorsGetRangeActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(261385292474407936UL, 11707538877200273152UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<RangeResult>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CoordinatorsGetRangeActorActor, 0, std::vector<NetworkAddress> >;
															#line 1841 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	CoordinatorsGetRangeActorActor(ReadYourWritesTransaction* const& ryw,KeyRef const& prefix,KeyRangeRef const& kr) 
															#line 9216 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		 : Actor<RangeResult>(),
		   CoordinatorsGetRangeActorActorState<CoordinatorsGetRangeActorActor>(ryw, prefix, kr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("coordinatorsGetRangeActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6364174339737764352UL, 13532682984794991360UL);
		ActorExecutionContextHelper __helper(static_cast<CoordinatorsGetRangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("coordinatorsGetRangeActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("coordinatorsGetRangeActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CoordinatorsGetRangeActorActor, 0, std::vector<NetworkAddress> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1841 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
[[nodiscard]] Future<RangeResult> coordinatorsGetRangeActor( ReadYourWritesTransaction* const& ryw, KeyRef const& prefix, KeyRangeRef const& kr ) {
															#line 1841 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	return Future<RangeResult>(new CoordinatorsGetRangeActorActor(ryw, prefix, kr));
															#line 9249 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
}

#line 1866 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"

Future<RangeResult> CoordinatorsImpl::getRange(ReadYourWritesTransaction* ryw,
                                               KeyRangeRef kr,
                                               GetRangeLimits limitsHint) const {
	KeyRef prefix(getKeyRange().begin);
	return coordinatorsGetRangeActor(ryw, prefix, kr);
}

															#line 9261 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
namespace {
// This generated class is to be used only via coordinatorsCommitActor()
															#line 1874 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
template <class CoordinatorsCommitActorActor>
															#line 1874 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class CoordinatorsCommitActorActorState {
															#line 9268 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
public:
															#line 1874 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	CoordinatorsCommitActorActorState(ReadYourWritesTransaction* const& ryw,KeyRangeRef const& kr) 
															#line 1874 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
															#line 1874 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		 : ryw(ryw),
															#line 1874 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   kr(kr),
															#line 1875 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   conn(),
															#line 1876 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   process_address_or_hostname_strs(),
															#line 1877 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   msg(),
															#line 1878 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   index(),
															#line 1879 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   parse_error(false)
															#line 9287 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
	{
		fdb_probe_actor_create("coordinatorsCommitActor", reinterpret_cast<unsigned long>(this));

	}
	~CoordinatorsCommitActorActorState() 
	{
		fdb_probe_actor_destroy("coordinatorsCommitActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1882 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			Key processes_key = "processes"_sr.withPrefix(kr.begin);
															#line 1883 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			auto processes_entry = ryw->getSpecialKeySpaceWriteMap()[processes_key];
															#line 1884 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (processes_entry.first)
															#line 9306 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			{
															#line 1885 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				ASSERT(processes_entry.second.present());
															#line 1886 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				auto processesStr = processes_entry.second.get().toString();
															#line 1887 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				boost::split(process_address_or_hostname_strs, processesStr, [](char c) { return c == ','; });
															#line 1888 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (!process_address_or_hostname_strs.size())
															#line 9316 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
				{
															#line 1889 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					if (!static_cast<CoordinatorsCommitActorActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(ManagementAPIError::toJsonString( false, "coordinators", "New coordinators\' processes are empty, please specify new processes\' network addresses with format " "\"IP:PORT,IP:PORT,...,IP:PORT\" or \"HOSTNAME:PORT,HOSTNAME:PORT,...,HOSTNAME:PORT\"")); this->~CoordinatorsCommitActorActorState(); static_cast<CoordinatorsCommitActorActor*>(this)->destroy(); return 0; }
															#line 9320 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
					new (&static_cast<CoordinatorsCommitActorActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(ManagementAPIError::toJsonString( false, "coordinators", "New coordinators\' processes are empty, please specify new processes\' network addresses with format " "\"IP:PORT,IP:PORT,...,IP:PORT\" or \"HOSTNAME:PORT,HOSTNAME:PORT,...,HOSTNAME:PORT\""));
					this->~CoordinatorsCommitActorActorState();
					static_cast<CoordinatorsCommitActorActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
															#line 1895 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				index = 0;
															#line 9328 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CoordinatorsCommitActorActorState();
		static_cast<CoordinatorsCommitActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1920 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		std::string newName;
															#line 1922 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		Key cluster_description_key = "cluster_description"_sr.withPrefix(kr.begin);
															#line 1923 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		auto entry = ryw->getSpecialKeySpaceWriteMap()[cluster_description_key];
															#line 1924 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (entry.first)
															#line 9362 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		{
															#line 1926 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (entry.second.present() && isAlphaNumeric(entry.second.get().toString()))
															#line 9366 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			{
															#line 1928 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				newName = entry.second.get().toString();
															#line 9370 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			}
			else
			{
															#line 1931 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (!static_cast<CoordinatorsCommitActorActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(ManagementAPIError::toJsonString( false, "coordinators", "Cluster description must match [A-Za-z0-9_]+")); this->~CoordinatorsCommitActorActorState(); static_cast<CoordinatorsCommitActorActor*>(this)->destroy(); return 0; }
															#line 9376 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
				new (&static_cast<CoordinatorsCommitActorActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(ManagementAPIError::toJsonString( false, "coordinators", "Cluster description must match [A-Za-z0-9_]+"));
				this->~CoordinatorsCommitActorActorState();
				static_cast<CoordinatorsCommitActorActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 1936 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		auto configDBEntry = ryw->getSpecialKeySpaceWriteMap()["config_db"_sr.withPrefix(kr.begin)];
															#line 1938 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		TraceEvent(SevDebug, "SKSChangeCoordinatorsStart") .detail("NewConnectionString", conn.toString()) .detail("Description", entry.first ? entry.second.get().toString() : "") .detail("ConfigDBDisabled", configDBEntry.first);
															#line 1943 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		StrictFuture<Optional<CoordinatorsResult>> __when_expr_0 = changeQuorumChecker(&ryw->getTransaction(), &conn, newName, configDBEntry.first);
															#line 1943 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (static_cast<CoordinatorsCommitActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9391 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1cont1when1(__when_expr_0.get(), loopDepth); };
		static_cast<CoordinatorsCommitActorActor*>(this)->actor_wait_state = 1;
															#line 1943 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CoordinatorsCommitActorActor, 0, Optional<CoordinatorsResult> >*>(static_cast<CoordinatorsCommitActorActor*>(this)));
															#line 9396 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1895 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!(index < process_address_or_hostname_strs.size()))
															#line 9418 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		try {
															#line 1897 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (Hostname::isHostname(process_address_or_hostname_strs[index]))
															#line 9425 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			{
															#line 1898 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				conn.hostnames.push_back(Hostname::parse(process_address_or_hostname_strs[index]));
															#line 9429 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			}
			else
			{
															#line 1900 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				NetworkAddress a = NetworkAddress::parse(process_address_or_hostname_strs[index]);
															#line 1901 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (!a.isValid())
															#line 9437 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
				{
															#line 1902 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					parse_error = true;
															#line 9441 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
				}
				else
				{
															#line 1904 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					conn.coords.push_back(a);
															#line 9447 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
				}
			}
			loopDepth = a_body1loopBody1cont8(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 1912 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (parse_error)
															#line 9477 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		{
															#line 1913 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			std::string error = "ERROR: \'" + process_address_or_hostname_strs[index] + "\' is not a valid network endpoint address\n";
															#line 1915 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (!static_cast<CoordinatorsCommitActorActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(ManagementAPIError::toJsonString(false, "coordinators", error)); this->~CoordinatorsCommitActorActorState(); static_cast<CoordinatorsCommitActorActor*>(this)->destroy(); return 0; }
															#line 9483 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			new (&static_cast<CoordinatorsCommitActorActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(ManagementAPIError::toJsonString(false, "coordinators", error));
			this->~CoordinatorsCommitActorActorState();
			static_cast<CoordinatorsCommitActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1895 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		index++;
															#line 9491 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1908 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			TraceEvent(SevDebug, "SpecialKeysNetworkParseError").error(e);
															#line 1909 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			parse_error = true;
															#line 9503 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont8(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont4(Optional<CoordinatorsResult> const& r,int loopDepth) 
	{
															#line 1946 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		TraceEvent(SevDebug, "SKSChangeCoordinatorsFinish") .detail("Result", r.present() ? static_cast<int>(r.get()) : -1);
															#line 1948 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (r.present())
															#line 9533 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		{
															#line 1949 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			auto res = r.get();
															#line 1950 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			bool retriable = false;
															#line 1951 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (res == CoordinatorsResult::COORDINATOR_UNREACHABLE)
															#line 9541 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			{
															#line 1952 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				retriable = true;
															#line 9545 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			}
			else
			{
															#line 1953 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (res == CoordinatorsResult::SUCCESS)
															#line 9551 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
				{
															#line 1954 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					TraceEvent(SevError, "SpecialKeysForCoordinators").detail("UnexpectedSuccessfulResult", "");
															#line 1955 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					ASSERT(false);
															#line 9557 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
				}
			}
															#line 1957 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			msg = ManagementAPIError::toJsonString(retriable, "coordinators", ManagementAPI::generateErrorMessage(res));
															#line 9562 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		}
															#line 1959 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<CoordinatorsCommitActorActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(msg); this->~CoordinatorsCommitActorActorState(); static_cast<CoordinatorsCommitActorActor*>(this)->destroy(); return 0; }
															#line 9566 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		new (&static_cast<CoordinatorsCommitActorActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(std::move(msg)); // state_var_RVO
		this->~CoordinatorsCommitActorActorState();
		static_cast<CoordinatorsCommitActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4(Optional<CoordinatorsResult> && r,int loopDepth) 
	{
															#line 1946 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		TraceEvent(SevDebug, "SKSChangeCoordinatorsFinish") .detail("Result", r.present() ? static_cast<int>(r.get()) : -1);
															#line 1948 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (r.present())
															#line 9580 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		{
															#line 1949 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			auto res = r.get();
															#line 1950 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			bool retriable = false;
															#line 1951 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (res == CoordinatorsResult::COORDINATOR_UNREACHABLE)
															#line 9588 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			{
															#line 1952 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				retriable = true;
															#line 9592 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			}
			else
			{
															#line 1953 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (res == CoordinatorsResult::SUCCESS)
															#line 9598 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
				{
															#line 1954 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					TraceEvent(SevError, "SpecialKeysForCoordinators").detail("UnexpectedSuccessfulResult", "");
															#line 1955 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					ASSERT(false);
															#line 9604 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
				}
			}
															#line 1957 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			msg = ManagementAPIError::toJsonString(retriable, "coordinators", ManagementAPI::generateErrorMessage(res));
															#line 9609 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		}
															#line 1959 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<CoordinatorsCommitActorActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(msg); this->~CoordinatorsCommitActorActorState(); static_cast<CoordinatorsCommitActorActor*>(this)->destroy(); return 0; }
															#line 9613 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		new (&static_cast<CoordinatorsCommitActorActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(std::move(msg)); // state_var_RVO
		this->~CoordinatorsCommitActorActorState();
		static_cast<CoordinatorsCommitActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Optional<CoordinatorsResult> const& r,int loopDepth) 
	{
		loopDepth = a_body1cont4(r, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Optional<CoordinatorsResult> && r,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(r), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CoordinatorsCommitActorActor*>(this)->actor_wait_state > 0) static_cast<CoordinatorsCommitActorActor*>(this)->actor_wait_state = 0;
		static_cast<CoordinatorsCommitActorActor*>(this)->ActorCallback< CoordinatorsCommitActorActor, 0, Optional<CoordinatorsResult> >::remove();

	}
	void a_callback_fire(ActorCallback< CoordinatorsCommitActorActor, 0, Optional<CoordinatorsResult> >*,Optional<CoordinatorsResult> const& value) 
	{
		fdb_probe_actor_enter("coordinatorsCommitActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CoordinatorsCommitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("coordinatorsCommitActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CoordinatorsCommitActorActor, 0, Optional<CoordinatorsResult> >*,Optional<CoordinatorsResult> && value) 
	{
		fdb_probe_actor_enter("coordinatorsCommitActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CoordinatorsCommitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("coordinatorsCommitActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CoordinatorsCommitActorActor, 0, Optional<CoordinatorsResult> >*,Error err) 
	{
		fdb_probe_actor_enter("coordinatorsCommitActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CoordinatorsCommitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("coordinatorsCommitActor", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1874 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	ReadYourWritesTransaction* ryw;
															#line 1874 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	KeyRangeRef kr;
															#line 1875 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	ClusterConnectionString conn;
															#line 1876 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	std::vector<std::string> process_address_or_hostname_strs;
															#line 1877 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	Optional<std::string> msg;
															#line 1878 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	int index;
															#line 1879 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	bool parse_error;
															#line 9710 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
};
// This generated class is to be used only via coordinatorsCommitActor()
															#line 1874 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class CoordinatorsCommitActorActor final : public Actor<Optional<std::string>>, public ActorCallback< CoordinatorsCommitActorActor, 0, Optional<CoordinatorsResult> >, public FastAllocated<CoordinatorsCommitActorActor>, public CoordinatorsCommitActorActorState<CoordinatorsCommitActorActor> {
															#line 9715 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
public:
	using FastAllocated<CoordinatorsCommitActorActor>::operator new;
	using FastAllocated<CoordinatorsCommitActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16714905218823364096UL, 10602732898760825088UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Optional<std::string>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CoordinatorsCommitActorActor, 0, Optional<CoordinatorsResult> >;
															#line 1874 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	CoordinatorsCommitActorActor(ReadYourWritesTransaction* const& ryw,KeyRangeRef const& kr) 
															#line 9732 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		 : Actor<Optional<std::string>>(),
		   CoordinatorsCommitActorActorState<CoordinatorsCommitActorActor>(ryw, kr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("coordinatorsCommitActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1759015567785200128UL, 14922565753913665792UL);
		ActorExecutionContextHelper __helper(static_cast<CoordinatorsCommitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("coordinatorsCommitActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("coordinatorsCommitActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CoordinatorsCommitActorActor, 0, Optional<CoordinatorsResult> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1874 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
[[nodiscard]] static Future<Optional<std::string>> coordinatorsCommitActor( ReadYourWritesTransaction* const& ryw, KeyRangeRef const& kr ) {
															#line 1874 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	return Future<Optional<std::string>>(new CoordinatorsCommitActorActor(ryw, kr));
															#line 9765 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
}

#line 1961 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"

Future<Optional<std::string>> CoordinatorsImpl::commit(ReadYourWritesTransaction* ryw) {
	return coordinatorsCommitActor(ryw, getKeyRange());
}

void CoordinatorsImpl::clear(ReadYourWritesTransaction* ryw, const KeyRangeRef& range) {
	return throwSpecialKeyApiFailure(ryw, "coordinators", "Clear range is meaningless thus forbidden for coordinators");
}

void CoordinatorsImpl::clear(ReadYourWritesTransaction* ryw, const KeyRef& key) {
	return throwSpecialKeyApiFailure(
	    ryw, "coordinators", "Clear operation is meaningless thus forbidden for coordinators");
}

CoordinatorsAutoImpl::CoordinatorsAutoImpl(KeyRangeRef kr) : SpecialKeyRangeReadImpl(kr) {}

															#line 9785 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
namespace {
// This generated class is to be used only via CoordinatorsAutoImplActor()
															#line 1977 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
template <class CoordinatorsAutoImplActorActor>
															#line 1977 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class CoordinatorsAutoImplActorActorState {
															#line 9792 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
public:
															#line 1977 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	CoordinatorsAutoImplActorActorState(ReadYourWritesTransaction* const& ryw,KeyRangeRef const& kr) 
															#line 1977 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
															#line 1977 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		 : ryw(ryw),
															#line 1977 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   kr(kr),
															#line 1978 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   res(),
															#line 1979 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   autoCoordinatorsKey(),
															#line 1980 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   tr(ryw->getTransaction())
															#line 9807 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
	{
		fdb_probe_actor_create("CoordinatorsAutoImplActor", reinterpret_cast<unsigned long>(this));

	}
	~CoordinatorsAutoImplActorActorState() 
	{
		fdb_probe_actor_destroy("CoordinatorsAutoImplActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1982 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 1983 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			tr.setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 1984 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			tr.setOption(FDBTransactionOptions::USE_PROVISIONAL_PROXIES);
															#line 1985 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 1986 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr.get(coordinatorsKey);
															#line 1986 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (static_cast<CoordinatorsAutoImplActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9832 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CoordinatorsAutoImplActorActor*>(this)->actor_wait_state = 1;
															#line 1986 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CoordinatorsAutoImplActorActor, 0, Optional<Value> >*>(static_cast<CoordinatorsAutoImplActorActor*>(this)));
															#line 9837 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CoordinatorsAutoImplActorActorState();
		static_cast<CoordinatorsAutoImplActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> const& currentKey,int loopDepth) 
	{
															#line 1988 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!currentKey.present())
															#line 9860 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		{
															#line 1989 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ryw->setSpecialKeySpaceErrorMsg( ManagementAPIError::toJsonString(false, "auto_coordinators", "The coordinator key does not exist"));
															#line 1991 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			return a_body1Catch1(special_keys_api_failure(), loopDepth);
															#line 9866 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		}
															#line 1993 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		old = ClusterConnectionString(currentKey.get().toString());
															#line 1994 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		result = CoordinatorsResult::SUCCESS;
															#line 1996 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		StrictFuture<std::vector<NetworkAddress>> __when_expr_1 = old.tryResolveHostnames();
															#line 1996 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (static_cast<CoordinatorsAutoImplActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9876 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CoordinatorsAutoImplActorActor*>(this)->actor_wait_state = 2;
															#line 1996 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CoordinatorsAutoImplActorActor, 1, std::vector<NetworkAddress> >*>(static_cast<CoordinatorsAutoImplActorActor*>(this)));
															#line 9881 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> && currentKey,int loopDepth) 
	{
															#line 1988 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!currentKey.present())
															#line 9890 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		{
															#line 1989 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ryw->setSpecialKeySpaceErrorMsg( ManagementAPIError::toJsonString(false, "auto_coordinators", "The coordinator key does not exist"));
															#line 1991 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			return a_body1Catch1(special_keys_api_failure(), loopDepth);
															#line 9896 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		}
															#line 1993 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		old = ClusterConnectionString(currentKey.get().toString());
															#line 1994 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		result = CoordinatorsResult::SUCCESS;
															#line 1996 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		StrictFuture<std::vector<NetworkAddress>> __when_expr_1 = old.tryResolveHostnames();
															#line 1996 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (static_cast<CoordinatorsAutoImplActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9906 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CoordinatorsAutoImplActorActor*>(this)->actor_wait_state = 2;
															#line 1996 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CoordinatorsAutoImplActorActor, 1, std::vector<NetworkAddress> >*>(static_cast<CoordinatorsAutoImplActorActor*>(this)));
															#line 9911 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Optional<Value> const& currentKey,int loopDepth) 
	{
		loopDepth = a_body1cont1(currentKey, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<Value> && currentKey,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(currentKey), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CoordinatorsAutoImplActorActor*>(this)->actor_wait_state > 0) static_cast<CoordinatorsAutoImplActorActor*>(this)->actor_wait_state = 0;
		static_cast<CoordinatorsAutoImplActorActor*>(this)->ActorCallback< CoordinatorsAutoImplActorActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< CoordinatorsAutoImplActorActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("CoordinatorsAutoImplActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CoordinatorsAutoImplActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("CoordinatorsAutoImplActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CoordinatorsAutoImplActorActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("CoordinatorsAutoImplActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CoordinatorsAutoImplActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("CoordinatorsAutoImplActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CoordinatorsAutoImplActorActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("CoordinatorsAutoImplActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CoordinatorsAutoImplActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("CoordinatorsAutoImplActor", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(std::vector<NetworkAddress> const& oldCoordinators,int loopDepth) 
	{
															#line 1997 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		StrictFuture<std::vector<NetworkAddress>> __when_expr_2 = autoQuorumChange()->getDesiredCoordinators( &tr, oldCoordinators, Reference<ClusterConnectionMemoryRecord>(new ClusterConnectionMemoryRecord(old)), result);
															#line 1997 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (static_cast<CoordinatorsAutoImplActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9997 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<CoordinatorsAutoImplActorActor*>(this)->actor_wait_state = 3;
															#line 1997 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CoordinatorsAutoImplActorActor, 2, std::vector<NetworkAddress> >*>(static_cast<CoordinatorsAutoImplActorActor*>(this)));
															#line 10002 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(std::vector<NetworkAddress> && oldCoordinators,int loopDepth) 
	{
															#line 1997 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		StrictFuture<std::vector<NetworkAddress>> __when_expr_2 = autoQuorumChange()->getDesiredCoordinators( &tr, oldCoordinators, Reference<ClusterConnectionMemoryRecord>(new ClusterConnectionMemoryRecord(old)), result);
															#line 1997 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (static_cast<CoordinatorsAutoImplActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10013 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<CoordinatorsAutoImplActorActor*>(this)->actor_wait_state = 3;
															#line 1997 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CoordinatorsAutoImplActorActor, 2, std::vector<NetworkAddress> >*>(static_cast<CoordinatorsAutoImplActorActor*>(this)));
															#line 10018 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(std::vector<NetworkAddress> const& oldCoordinators,int loopDepth) 
	{
		loopDepth = a_body1cont2(oldCoordinators, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(std::vector<NetworkAddress> && oldCoordinators,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(oldCoordinators), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CoordinatorsAutoImplActorActor*>(this)->actor_wait_state > 0) static_cast<CoordinatorsAutoImplActorActor*>(this)->actor_wait_state = 0;
		static_cast<CoordinatorsAutoImplActorActor*>(this)->ActorCallback< CoordinatorsAutoImplActorActor, 1, std::vector<NetworkAddress> >::remove();

	}
	void a_callback_fire(ActorCallback< CoordinatorsAutoImplActorActor, 1, std::vector<NetworkAddress> >*,std::vector<NetworkAddress> const& value) 
	{
		fdb_probe_actor_enter("CoordinatorsAutoImplActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CoordinatorsAutoImplActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("CoordinatorsAutoImplActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CoordinatorsAutoImplActorActor, 1, std::vector<NetworkAddress> >*,std::vector<NetworkAddress> && value) 
	{
		fdb_probe_actor_enter("CoordinatorsAutoImplActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CoordinatorsAutoImplActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("CoordinatorsAutoImplActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CoordinatorsAutoImplActorActor, 1, std::vector<NetworkAddress> >*,Error err) 
	{
		fdb_probe_actor_enter("CoordinatorsAutoImplActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CoordinatorsAutoImplActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("CoordinatorsAutoImplActor", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(std::vector<NetworkAddress> const& _desiredCoordinators,int loopDepth) 
	{
															#line 2003 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (result == CoordinatorsResult::NOT_ENOUGH_MACHINES)
															#line 10102 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		{
															#line 2006 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ryw->setSpecialKeySpaceErrorMsg(ManagementAPIError::toJsonString( true, "auto_coordinators", "Too few fdbserver machines to provide coordination at the current redundancy level"));
															#line 2010 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			return a_body1Catch1(special_keys_api_failure(), loopDepth);
															#line 10108 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		}
															#line 2013 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (result == CoordinatorsResult::SAME_NETWORK_ADDRESSES)
															#line 10112 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		{
															#line 2014 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			for( const auto& host : old.hostnames ) {
															#line 2015 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				autoCoordinatorsKey += autoCoordinatorsKey.size() ? "," : "";
															#line 2016 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				autoCoordinatorsKey += host.toString();
															#line 10120 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			}
															#line 2018 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			for( const auto& coord : old.coords ) {
															#line 2019 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				autoCoordinatorsKey += autoCoordinatorsKey.size() ? "," : "";
															#line 2020 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				autoCoordinatorsKey += coord.toString();
															#line 10128 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			}
		}
		else
		{
															#line 2023 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			for( const auto& address : _desiredCoordinators ) {
															#line 2024 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				autoCoordinatorsKey += autoCoordinatorsKey.size() ? "," : "";
															#line 2025 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				autoCoordinatorsKey += address.toString();
															#line 10139 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			}
		}
															#line 2028 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		res.push_back_deep(res.arena(), KeyValueRef(kr.begin, Value(autoCoordinatorsKey)));
															#line 2029 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<CoordinatorsAutoImplActorActor*>(this)->SAV<RangeResult>::futures) { (void)(res); this->~CoordinatorsAutoImplActorActorState(); static_cast<CoordinatorsAutoImplActorActor*>(this)->destroy(); return 0; }
															#line 10146 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		new (&static_cast<CoordinatorsAutoImplActorActor*>(this)->SAV< RangeResult >::value()) RangeResult(std::move(res)); // state_var_RVO
		this->~CoordinatorsAutoImplActorActorState();
		static_cast<CoordinatorsAutoImplActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4(std::vector<NetworkAddress> && _desiredCoordinators,int loopDepth) 
	{
															#line 2003 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (result == CoordinatorsResult::NOT_ENOUGH_MACHINES)
															#line 10158 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		{
															#line 2006 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ryw->setSpecialKeySpaceErrorMsg(ManagementAPIError::toJsonString( true, "auto_coordinators", "Too few fdbserver machines to provide coordination at the current redundancy level"));
															#line 2010 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			return a_body1Catch1(special_keys_api_failure(), loopDepth);
															#line 10164 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		}
															#line 2013 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (result == CoordinatorsResult::SAME_NETWORK_ADDRESSES)
															#line 10168 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		{
															#line 2014 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			for( const auto& host : old.hostnames ) {
															#line 2015 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				autoCoordinatorsKey += autoCoordinatorsKey.size() ? "," : "";
															#line 2016 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				autoCoordinatorsKey += host.toString();
															#line 10176 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			}
															#line 2018 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			for( const auto& coord : old.coords ) {
															#line 2019 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				autoCoordinatorsKey += autoCoordinatorsKey.size() ? "," : "";
															#line 2020 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				autoCoordinatorsKey += coord.toString();
															#line 10184 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			}
		}
		else
		{
															#line 2023 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			for( const auto& address : _desiredCoordinators ) {
															#line 2024 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				autoCoordinatorsKey += autoCoordinatorsKey.size() ? "," : "";
															#line 2025 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				autoCoordinatorsKey += address.toString();
															#line 10195 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			}
		}
															#line 2028 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		res.push_back_deep(res.arena(), KeyValueRef(kr.begin, Value(autoCoordinatorsKey)));
															#line 2029 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<CoordinatorsAutoImplActorActor*>(this)->SAV<RangeResult>::futures) { (void)(res); this->~CoordinatorsAutoImplActorActorState(); static_cast<CoordinatorsAutoImplActorActor*>(this)->destroy(); return 0; }
															#line 10202 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		new (&static_cast<CoordinatorsAutoImplActorActor*>(this)->SAV< RangeResult >::value()) RangeResult(std::move(res)); // state_var_RVO
		this->~CoordinatorsAutoImplActorActorState();
		static_cast<CoordinatorsAutoImplActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(std::vector<NetworkAddress> const& _desiredCoordinators,int loopDepth) 
	{
		loopDepth = a_body1cont4(_desiredCoordinators, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(std::vector<NetworkAddress> && _desiredCoordinators,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_desiredCoordinators), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CoordinatorsAutoImplActorActor*>(this)->actor_wait_state > 0) static_cast<CoordinatorsAutoImplActorActor*>(this)->actor_wait_state = 0;
		static_cast<CoordinatorsAutoImplActorActor*>(this)->ActorCallback< CoordinatorsAutoImplActorActor, 2, std::vector<NetworkAddress> >::remove();

	}
	void a_callback_fire(ActorCallback< CoordinatorsAutoImplActorActor, 2, std::vector<NetworkAddress> >*,std::vector<NetworkAddress> const& value) 
	{
		fdb_probe_actor_enter("CoordinatorsAutoImplActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CoordinatorsAutoImplActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("CoordinatorsAutoImplActor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CoordinatorsAutoImplActorActor, 2, std::vector<NetworkAddress> >*,std::vector<NetworkAddress> && value) 
	{
		fdb_probe_actor_enter("CoordinatorsAutoImplActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CoordinatorsAutoImplActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("CoordinatorsAutoImplActor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CoordinatorsAutoImplActorActor, 2, std::vector<NetworkAddress> >*,Error err) 
	{
		fdb_probe_actor_enter("CoordinatorsAutoImplActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CoordinatorsAutoImplActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("CoordinatorsAutoImplActor", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 1977 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	ReadYourWritesTransaction* ryw;
															#line 1977 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	KeyRangeRef kr;
															#line 1978 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	RangeResult res;
															#line 1979 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	std::string autoCoordinatorsKey;
															#line 1980 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	Transaction& tr;
															#line 1993 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	ClusterConnectionString old;
															#line 1994 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	CoordinatorsResult result;
															#line 10299 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
};
// This generated class is to be used only via CoordinatorsAutoImplActor()
															#line 1977 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class CoordinatorsAutoImplActorActor final : public Actor<RangeResult>, public ActorCallback< CoordinatorsAutoImplActorActor, 0, Optional<Value> >, public ActorCallback< CoordinatorsAutoImplActorActor, 1, std::vector<NetworkAddress> >, public ActorCallback< CoordinatorsAutoImplActorActor, 2, std::vector<NetworkAddress> >, public FastAllocated<CoordinatorsAutoImplActorActor>, public CoordinatorsAutoImplActorActorState<CoordinatorsAutoImplActorActor> {
															#line 10304 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
public:
	using FastAllocated<CoordinatorsAutoImplActorActor>::operator new;
	using FastAllocated<CoordinatorsAutoImplActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13694342244230052864UL, 5243602815759360768UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<RangeResult>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CoordinatorsAutoImplActorActor, 0, Optional<Value> >;
friend struct ActorCallback< CoordinatorsAutoImplActorActor, 1, std::vector<NetworkAddress> >;
friend struct ActorCallback< CoordinatorsAutoImplActorActor, 2, std::vector<NetworkAddress> >;
															#line 1977 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	CoordinatorsAutoImplActorActor(ReadYourWritesTransaction* const& ryw,KeyRangeRef const& kr) 
															#line 10323 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		 : Actor<RangeResult>(),
		   CoordinatorsAutoImplActorActorState<CoordinatorsAutoImplActorActor>(ryw, kr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("CoordinatorsAutoImplActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8864986884343506176UL, 12776331881952517376UL);
		ActorExecutionContextHelper __helper(static_cast<CoordinatorsAutoImplActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("CoordinatorsAutoImplActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("CoordinatorsAutoImplActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CoordinatorsAutoImplActorActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CoordinatorsAutoImplActorActor, 1, std::vector<NetworkAddress> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CoordinatorsAutoImplActorActor, 2, std::vector<NetworkAddress> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1977 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
[[nodiscard]] static Future<RangeResult> CoordinatorsAutoImplActor( ReadYourWritesTransaction* const& ryw, KeyRangeRef const& kr ) {
															#line 1977 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	return Future<RangeResult>(new CoordinatorsAutoImplActorActor(ryw, kr));
															#line 10358 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
}

#line 2031 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"

Future<RangeResult> CoordinatorsAutoImpl::getRange(ReadYourWritesTransaction* ryw,
                                                   KeyRangeRef kr,
                                                   GetRangeLimits limitsHint) const {
	// single key range, the queried range should always be the same as the underlying range
	ASSERT(kr == getKeyRange());
	return CoordinatorsAutoImplActor(ryw, kr);
}

															#line 10371 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
namespace {
// This generated class is to be used only via getMinCommitVersionActor()
															#line 2040 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
template <class GetMinCommitVersionActorActor>
															#line 2040 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class GetMinCommitVersionActorActorState {
															#line 10378 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
public:
															#line 2040 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	GetMinCommitVersionActorActorState(ReadYourWritesTransaction* const& ryw,KeyRangeRef const& kr) 
															#line 2040 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
															#line 2040 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		 : ryw(ryw),
															#line 2040 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   kr(kr)
															#line 10387 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
	{
		fdb_probe_actor_create("getMinCommitVersionActor", reinterpret_cast<unsigned long>(this));

	}
	~GetMinCommitVersionActorActorState() 
	{
		fdb_probe_actor_destroy("getMinCommitVersionActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2041 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ryw->getTransaction().setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 2042 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ryw->getTransaction().setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 2043 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = ryw->getTransaction().get(minRequiredCommitVersionKey);
															#line 2043 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (static_cast<GetMinCommitVersionActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10408 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetMinCommitVersionActorActor*>(this)->actor_wait_state = 1;
															#line 2043 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetMinCommitVersionActorActor, 0, Optional<Value> >*>(static_cast<GetMinCommitVersionActorActor*>(this)));
															#line 10413 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetMinCommitVersionActorActorState();
		static_cast<GetMinCommitVersionActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> const& val,int loopDepth) 
	{
															#line 2044 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		RangeResult result;
															#line 2045 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (val.present())
															#line 10438 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		{
															#line 2046 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			Version minRequiredCommitVersion = BinaryReader::fromStringRef<Version>(val.get(), Unversioned());
															#line 2047 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ValueRef version(result.arena(), boost::lexical_cast<std::string>(minRequiredCommitVersion));
															#line 2048 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			result.push_back_deep(result.arena(), KeyValueRef(kr.begin, version));
															#line 10446 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		}
															#line 2050 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<GetMinCommitVersionActorActor*>(this)->SAV<RangeResult>::futures) { (void)(result); this->~GetMinCommitVersionActorActorState(); static_cast<GetMinCommitVersionActorActor*>(this)->destroy(); return 0; }
															#line 10450 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		new (&static_cast<GetMinCommitVersionActorActor*>(this)->SAV< RangeResult >::value()) RangeResult(result);
		this->~GetMinCommitVersionActorActorState();
		static_cast<GetMinCommitVersionActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> && val,int loopDepth) 
	{
															#line 2044 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		RangeResult result;
															#line 2045 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (val.present())
															#line 10464 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		{
															#line 2046 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			Version minRequiredCommitVersion = BinaryReader::fromStringRef<Version>(val.get(), Unversioned());
															#line 2047 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ValueRef version(result.arena(), boost::lexical_cast<std::string>(minRequiredCommitVersion));
															#line 2048 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			result.push_back_deep(result.arena(), KeyValueRef(kr.begin, version));
															#line 10472 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		}
															#line 2050 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<GetMinCommitVersionActorActor*>(this)->SAV<RangeResult>::futures) { (void)(result); this->~GetMinCommitVersionActorActorState(); static_cast<GetMinCommitVersionActorActor*>(this)->destroy(); return 0; }
															#line 10476 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		new (&static_cast<GetMinCommitVersionActorActor*>(this)->SAV< RangeResult >::value()) RangeResult(result);
		this->~GetMinCommitVersionActorActorState();
		static_cast<GetMinCommitVersionActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Optional<Value> const& val,int loopDepth) 
	{
		loopDepth = a_body1cont1(val, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<Value> && val,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(val), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetMinCommitVersionActorActor*>(this)->actor_wait_state > 0) static_cast<GetMinCommitVersionActorActor*>(this)->actor_wait_state = 0;
		static_cast<GetMinCommitVersionActorActor*>(this)->ActorCallback< GetMinCommitVersionActorActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< GetMinCommitVersionActorActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("getMinCommitVersionActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetMinCommitVersionActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getMinCommitVersionActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetMinCommitVersionActorActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("getMinCommitVersionActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetMinCommitVersionActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getMinCommitVersionActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetMinCommitVersionActorActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("getMinCommitVersionActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetMinCommitVersionActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getMinCommitVersionActor", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 2040 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	ReadYourWritesTransaction* ryw;
															#line 2040 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	KeyRangeRef kr;
															#line 10563 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
};
// This generated class is to be used only via getMinCommitVersionActor()
															#line 2040 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class GetMinCommitVersionActorActor final : public Actor<RangeResult>, public ActorCallback< GetMinCommitVersionActorActor, 0, Optional<Value> >, public FastAllocated<GetMinCommitVersionActorActor>, public GetMinCommitVersionActorActorState<GetMinCommitVersionActorActor> {
															#line 10568 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
public:
	using FastAllocated<GetMinCommitVersionActorActor>::operator new;
	using FastAllocated<GetMinCommitVersionActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(90791282641696256UL, 425157148223435520UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<RangeResult>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetMinCommitVersionActorActor, 0, Optional<Value> >;
															#line 2040 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	GetMinCommitVersionActorActor(ReadYourWritesTransaction* const& ryw,KeyRangeRef const& kr) 
															#line 10585 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		 : Actor<RangeResult>(),
		   GetMinCommitVersionActorActorState<GetMinCommitVersionActorActor>(ryw, kr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getMinCommitVersionActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16975584647062044416UL, 988944995584749824UL);
		ActorExecutionContextHelper __helper(static_cast<GetMinCommitVersionActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getMinCommitVersionActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getMinCommitVersionActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetMinCommitVersionActorActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2040 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
[[nodiscard]] static Future<RangeResult> getMinCommitVersionActor( ReadYourWritesTransaction* const& ryw, KeyRangeRef const& kr ) {
															#line 2040 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	return Future<RangeResult>(new GetMinCommitVersionActorActor(ryw, kr));
															#line 10618 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
}

#line 2052 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"

AdvanceVersionImpl::AdvanceVersionImpl(KeyRangeRef kr) : SpecialKeyRangeRWImpl(kr) {}

Future<RangeResult> AdvanceVersionImpl::getRange(ReadYourWritesTransaction* ryw,
                                                 KeyRangeRef kr,
                                                 GetRangeLimits limitsHint) const {
	// single key range, the queried range should always be the same as the underlying range
	ASSERT(kr == getKeyRange());
	auto entry = ryw->getSpecialKeySpaceWriteMap()[SpecialKeySpace::getManagementApiCommandPrefix("advanceversion")];
	if (!ryw->readYourWritesDisabled() && entry.first) {
		// ryw enabled and we have written to the special key
		RangeResult result;
		if (entry.second.present()) {
			result.push_back_deep(result.arena(), KeyValueRef(kr.begin, entry.second.get()));
		}
		return result;
	} else {
		return getMinCommitVersionActor(ryw, kr);
	}
}

															#line 10643 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
namespace {
// This generated class is to be used only via advanceVersionCommitActor()
															#line 2073 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
template <class AdvanceVersionCommitActorActor>
															#line 2073 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class AdvanceVersionCommitActorActorState {
															#line 10650 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
public:
															#line 2073 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	AdvanceVersionCommitActorActorState(ReadYourWritesTransaction* const& ryw,Version const& v) 
															#line 2073 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
															#line 2073 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		 : ryw(ryw),
															#line 2073 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   v(v)
															#line 10659 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
	{
		fdb_probe_actor_create("advanceVersionCommitActor", reinterpret_cast<unsigned long>(this));

	}
	~AdvanceVersionCommitActorActorState() 
	{
		fdb_probe_actor_destroy("advanceVersionCommitActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2074 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			StrictFuture<Optional<Standalone<StringRef>>> __when_expr_0 = ryw->getTransaction().get(versionEpochKey);
															#line 2074 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (static_cast<AdvanceVersionCommitActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10676 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<AdvanceVersionCommitActorActor*>(this)->actor_wait_state = 1;
															#line 2074 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< AdvanceVersionCommitActorActor, 0, Optional<Standalone<StringRef>> >*>(static_cast<AdvanceVersionCommitActorActor*>(this)));
															#line 10681 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~AdvanceVersionCommitActorActorState();
		static_cast<AdvanceVersionCommitActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Standalone<StringRef>> const& versionEpochValue,int loopDepth) 
	{
															#line 2075 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (versionEpochValue.present())
															#line 10704 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		{
															#line 2076 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (!static_cast<AdvanceVersionCommitActorActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(ManagementAPIError::toJsonString( false, "advanceversion", "Illegal to modify the version while the version epoch is enabled")); this->~AdvanceVersionCommitActorActorState(); static_cast<AdvanceVersionCommitActorActor*>(this)->destroy(); return 0; }
															#line 10708 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			new (&static_cast<AdvanceVersionCommitActorActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(ManagementAPIError::toJsonString( false, "advanceversion", "Illegal to modify the version while the version epoch is enabled"));
			this->~AdvanceVersionCommitActorActorState();
			static_cast<AdvanceVersionCommitActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2082 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		static const Version maxAllowedVerion = std::numeric_limits<int64_t>::max() - 1 - CLIENT_KNOBS->VERSIONS_PER_SECOND * 3600 * 24 * 365 * 1000;
															#line 2085 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		ryw->getTransaction().setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 2086 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		ryw->getTransaction().setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 2087 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		TraceEvent(SevDebug, "AdvanceVersion").detail("MaxAllowedVersion", maxAllowedVerion);
															#line 2088 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (v > maxAllowedVerion)
															#line 10724 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		{
															#line 2089 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (!static_cast<AdvanceVersionCommitActorActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(ManagementAPIError::toJsonString( false, "advanceversion", "The given version is larger than the maximum allowed value(2**63-1-version_per_second*3600*24*365*1000)")); this->~AdvanceVersionCommitActorActorState(); static_cast<AdvanceVersionCommitActorActor*>(this)->destroy(); return 0; }
															#line 10728 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			new (&static_cast<AdvanceVersionCommitActorActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(ManagementAPIError::toJsonString( false, "advanceversion", "The given version is larger than the maximum allowed value(2**63-1-version_per_second*3600*24*365*1000)"));
			this->~AdvanceVersionCommitActorActorState();
			static_cast<AdvanceVersionCommitActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2094 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		StrictFuture<Version> __when_expr_1 = ryw->getTransaction().getReadVersion();
															#line 2094 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (static_cast<AdvanceVersionCommitActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10738 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<AdvanceVersionCommitActorActor*>(this)->actor_wait_state = 2;
															#line 2094 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< AdvanceVersionCommitActorActor, 1, Version >*>(static_cast<AdvanceVersionCommitActorActor*>(this)));
															#line 10743 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Standalone<StringRef>> && versionEpochValue,int loopDepth) 
	{
															#line 2075 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (versionEpochValue.present())
															#line 10752 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		{
															#line 2076 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (!static_cast<AdvanceVersionCommitActorActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(ManagementAPIError::toJsonString( false, "advanceversion", "Illegal to modify the version while the version epoch is enabled")); this->~AdvanceVersionCommitActorActorState(); static_cast<AdvanceVersionCommitActorActor*>(this)->destroy(); return 0; }
															#line 10756 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			new (&static_cast<AdvanceVersionCommitActorActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(ManagementAPIError::toJsonString( false, "advanceversion", "Illegal to modify the version while the version epoch is enabled"));
			this->~AdvanceVersionCommitActorActorState();
			static_cast<AdvanceVersionCommitActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2082 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		static const Version maxAllowedVerion = std::numeric_limits<int64_t>::max() - 1 - CLIENT_KNOBS->VERSIONS_PER_SECOND * 3600 * 24 * 365 * 1000;
															#line 2085 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		ryw->getTransaction().setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 2086 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		ryw->getTransaction().setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 2087 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		TraceEvent(SevDebug, "AdvanceVersion").detail("MaxAllowedVersion", maxAllowedVerion);
															#line 2088 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (v > maxAllowedVerion)
															#line 10772 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		{
															#line 2089 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (!static_cast<AdvanceVersionCommitActorActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(ManagementAPIError::toJsonString( false, "advanceversion", "The given version is larger than the maximum allowed value(2**63-1-version_per_second*3600*24*365*1000)")); this->~AdvanceVersionCommitActorActorState(); static_cast<AdvanceVersionCommitActorActor*>(this)->destroy(); return 0; }
															#line 10776 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			new (&static_cast<AdvanceVersionCommitActorActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(ManagementAPIError::toJsonString( false, "advanceversion", "The given version is larger than the maximum allowed value(2**63-1-version_per_second*3600*24*365*1000)"));
			this->~AdvanceVersionCommitActorActorState();
			static_cast<AdvanceVersionCommitActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2094 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		StrictFuture<Version> __when_expr_1 = ryw->getTransaction().getReadVersion();
															#line 2094 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (static_cast<AdvanceVersionCommitActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10786 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<AdvanceVersionCommitActorActor*>(this)->actor_wait_state = 2;
															#line 2094 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< AdvanceVersionCommitActorActor, 1, Version >*>(static_cast<AdvanceVersionCommitActorActor*>(this)));
															#line 10791 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Optional<Standalone<StringRef>> const& versionEpochValue,int loopDepth) 
	{
		loopDepth = a_body1cont1(versionEpochValue, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<Standalone<StringRef>> && versionEpochValue,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(versionEpochValue), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<AdvanceVersionCommitActorActor*>(this)->actor_wait_state > 0) static_cast<AdvanceVersionCommitActorActor*>(this)->actor_wait_state = 0;
		static_cast<AdvanceVersionCommitActorActor*>(this)->ActorCallback< AdvanceVersionCommitActorActor, 0, Optional<Standalone<StringRef>> >::remove();

	}
	void a_callback_fire(ActorCallback< AdvanceVersionCommitActorActor, 0, Optional<Standalone<StringRef>> >*,Optional<Standalone<StringRef>> const& value) 
	{
		fdb_probe_actor_enter("advanceVersionCommitActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AdvanceVersionCommitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("advanceVersionCommitActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< AdvanceVersionCommitActorActor, 0, Optional<Standalone<StringRef>> >*,Optional<Standalone<StringRef>> && value) 
	{
		fdb_probe_actor_enter("advanceVersionCommitActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AdvanceVersionCommitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("advanceVersionCommitActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< AdvanceVersionCommitActorActor, 0, Optional<Standalone<StringRef>> >*,Error err) 
	{
		fdb_probe_actor_enter("advanceVersionCommitActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AdvanceVersionCommitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("advanceVersionCommitActor", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Version const& rv,int loopDepth) 
	{
															#line 2095 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (rv <= v)
															#line 10875 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		{
															#line 2096 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ryw->getTransaction().set(minRequiredCommitVersionKey, BinaryWriter::toValue(v + 1, Unversioned()));
															#line 10879 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		}
		else
		{
															#line 2098 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (!static_cast<AdvanceVersionCommitActorActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(ManagementAPIError::toJsonString( false, "advanceversion", "Current read version is larger than the given version")); this->~AdvanceVersionCommitActorActorState(); static_cast<AdvanceVersionCommitActorActor*>(this)->destroy(); return 0; }
															#line 10885 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			new (&static_cast<AdvanceVersionCommitActorActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(ManagementAPIError::toJsonString( false, "advanceversion", "Current read version is larger than the given version"));
			this->~AdvanceVersionCommitActorActorState();
			static_cast<AdvanceVersionCommitActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2101 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<AdvanceVersionCommitActorActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(Optional<std::string>()); this->~AdvanceVersionCommitActorActorState(); static_cast<AdvanceVersionCommitActorActor*>(this)->destroy(); return 0; }
															#line 10893 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		new (&static_cast<AdvanceVersionCommitActorActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(Optional<std::string>());
		this->~AdvanceVersionCommitActorActorState();
		static_cast<AdvanceVersionCommitActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Version && rv,int loopDepth) 
	{
															#line 2095 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (rv <= v)
															#line 10905 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		{
															#line 2096 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ryw->getTransaction().set(minRequiredCommitVersionKey, BinaryWriter::toValue(v + 1, Unversioned()));
															#line 10909 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		}
		else
		{
															#line 2098 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (!static_cast<AdvanceVersionCommitActorActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(ManagementAPIError::toJsonString( false, "advanceversion", "Current read version is larger than the given version")); this->~AdvanceVersionCommitActorActorState(); static_cast<AdvanceVersionCommitActorActor*>(this)->destroy(); return 0; }
															#line 10915 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			new (&static_cast<AdvanceVersionCommitActorActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(ManagementAPIError::toJsonString( false, "advanceversion", "Current read version is larger than the given version"));
			this->~AdvanceVersionCommitActorActorState();
			static_cast<AdvanceVersionCommitActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2101 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<AdvanceVersionCommitActorActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(Optional<std::string>()); this->~AdvanceVersionCommitActorActorState(); static_cast<AdvanceVersionCommitActorActor*>(this)->destroy(); return 0; }
															#line 10923 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		new (&static_cast<AdvanceVersionCommitActorActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(Optional<std::string>());
		this->~AdvanceVersionCommitActorActorState();
		static_cast<AdvanceVersionCommitActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Version const& rv,int loopDepth) 
	{
		loopDepth = a_body1cont2(rv, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Version && rv,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(rv), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<AdvanceVersionCommitActorActor*>(this)->actor_wait_state > 0) static_cast<AdvanceVersionCommitActorActor*>(this)->actor_wait_state = 0;
		static_cast<AdvanceVersionCommitActorActor*>(this)->ActorCallback< AdvanceVersionCommitActorActor, 1, Version >::remove();

	}
	void a_callback_fire(ActorCallback< AdvanceVersionCommitActorActor, 1, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("advanceVersionCommitActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AdvanceVersionCommitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("advanceVersionCommitActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< AdvanceVersionCommitActorActor, 1, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("advanceVersionCommitActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AdvanceVersionCommitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("advanceVersionCommitActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< AdvanceVersionCommitActorActor, 1, Version >*,Error err) 
	{
		fdb_probe_actor_enter("advanceVersionCommitActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AdvanceVersionCommitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("advanceVersionCommitActor", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 2073 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	ReadYourWritesTransaction* ryw;
															#line 2073 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	Version v;
															#line 11010 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
};
// This generated class is to be used only via advanceVersionCommitActor()
															#line 2073 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class AdvanceVersionCommitActorActor final : public Actor<Optional<std::string>>, public ActorCallback< AdvanceVersionCommitActorActor, 0, Optional<Standalone<StringRef>> >, public ActorCallback< AdvanceVersionCommitActorActor, 1, Version >, public FastAllocated<AdvanceVersionCommitActorActor>, public AdvanceVersionCommitActorActorState<AdvanceVersionCommitActorActor> {
															#line 11015 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
public:
	using FastAllocated<AdvanceVersionCommitActorActor>::operator new;
	using FastAllocated<AdvanceVersionCommitActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10734536756447688192UL, 9286268962139390464UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Optional<std::string>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< AdvanceVersionCommitActorActor, 0, Optional<Standalone<StringRef>> >;
friend struct ActorCallback< AdvanceVersionCommitActorActor, 1, Version >;
															#line 2073 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	AdvanceVersionCommitActorActor(ReadYourWritesTransaction* const& ryw,Version const& v) 
															#line 11033 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		 : Actor<Optional<std::string>>(),
		   AdvanceVersionCommitActorActorState<AdvanceVersionCommitActorActor>(ryw, v),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("advanceVersionCommitActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15411806673587825152UL, 12887272844449880320UL);
		ActorExecutionContextHelper __helper(static_cast<AdvanceVersionCommitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("advanceVersionCommitActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("advanceVersionCommitActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< AdvanceVersionCommitActorActor, 0, Optional<Standalone<StringRef>> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< AdvanceVersionCommitActorActor, 1, Version >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2073 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
[[nodiscard]] static Future<Optional<std::string>> advanceVersionCommitActor( ReadYourWritesTransaction* const& ryw, Version const& v ) {
															#line 2073 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	return Future<Optional<std::string>>(new AdvanceVersionCommitActorActor(ryw, v));
															#line 11067 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
}

#line 2103 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"

Future<Optional<std::string>> AdvanceVersionImpl::commit(ReadYourWritesTransaction* ryw) {
	ryw->getTransaction().setOption(FDBTransactionOptions::RAW_ACCESS);
	auto minCommitVersion =
	    ryw->getSpecialKeySpaceWriteMap()[SpecialKeySpace::getManagementApiCommandPrefix("advanceversion")].second;
	if (minCommitVersion.present()) {
		try {
			// Version is int64_t
			Version v = boost::lexical_cast<int64_t>(minCommitVersion.get().toString());
			return advanceVersionCommitActor(ryw, v);
		} catch (boost::bad_lexical_cast& e) {
			return Optional<std::string>(ManagementAPIError::toJsonString(
			    false, "advanceversion", "Invalid version(int64_t) argument: " + minCommitVersion.get().toString()));
		}
	} else {
		ryw->getTransaction().clear(minRequiredCommitVersionKey);
	}
	return Optional<std::string>();
}

															#line 11091 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
namespace {
// This generated class is to be used only via getVersionEpochActor()
															#line 2123 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
template <class GetVersionEpochActorActor>
															#line 2123 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class GetVersionEpochActorActorState {
															#line 11098 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
public:
															#line 2123 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	GetVersionEpochActorActorState(ReadYourWritesTransaction* const& ryw,KeyRangeRef const& kr) 
															#line 2123 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
															#line 2123 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		 : ryw(ryw),
															#line 2123 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   kr(kr)
															#line 11107 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
	{
		fdb_probe_actor_create("getVersionEpochActor", reinterpret_cast<unsigned long>(this));

	}
	~GetVersionEpochActorActorState() 
	{
		fdb_probe_actor_destroy("getVersionEpochActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2124 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ryw->getTransaction().setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 2125 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ryw->getTransaction().setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 2126 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = ryw->getTransaction().get(versionEpochKey);
															#line 2126 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (static_cast<GetVersionEpochActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11128 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetVersionEpochActorActor*>(this)->actor_wait_state = 1;
															#line 2126 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetVersionEpochActorActor, 0, Optional<Value> >*>(static_cast<GetVersionEpochActorActor*>(this)));
															#line 11133 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetVersionEpochActorActorState();
		static_cast<GetVersionEpochActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> const& val,int loopDepth) 
	{
															#line 2127 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		RangeResult result;
															#line 2128 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (val.present())
															#line 11158 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		{
															#line 2129 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			int64_t versionEpoch = BinaryReader::fromStringRef<int64_t>(val.get(), Unversioned());
															#line 2130 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ValueRef version(result.arena(), boost::lexical_cast<std::string>(versionEpoch));
															#line 2131 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			result.push_back_deep(result.arena(), KeyValueRef(kr.begin, version));
															#line 11166 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		}
															#line 2133 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<GetVersionEpochActorActor*>(this)->SAV<RangeResult>::futures) { (void)(result); this->~GetVersionEpochActorActorState(); static_cast<GetVersionEpochActorActor*>(this)->destroy(); return 0; }
															#line 11170 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		new (&static_cast<GetVersionEpochActorActor*>(this)->SAV< RangeResult >::value()) RangeResult(result);
		this->~GetVersionEpochActorActorState();
		static_cast<GetVersionEpochActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> && val,int loopDepth) 
	{
															#line 2127 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		RangeResult result;
															#line 2128 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (val.present())
															#line 11184 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		{
															#line 2129 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			int64_t versionEpoch = BinaryReader::fromStringRef<int64_t>(val.get(), Unversioned());
															#line 2130 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ValueRef version(result.arena(), boost::lexical_cast<std::string>(versionEpoch));
															#line 2131 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			result.push_back_deep(result.arena(), KeyValueRef(kr.begin, version));
															#line 11192 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		}
															#line 2133 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<GetVersionEpochActorActor*>(this)->SAV<RangeResult>::futures) { (void)(result); this->~GetVersionEpochActorActorState(); static_cast<GetVersionEpochActorActor*>(this)->destroy(); return 0; }
															#line 11196 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		new (&static_cast<GetVersionEpochActorActor*>(this)->SAV< RangeResult >::value()) RangeResult(result);
		this->~GetVersionEpochActorActorState();
		static_cast<GetVersionEpochActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Optional<Value> const& val,int loopDepth) 
	{
		loopDepth = a_body1cont1(val, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<Value> && val,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(val), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetVersionEpochActorActor*>(this)->actor_wait_state > 0) static_cast<GetVersionEpochActorActor*>(this)->actor_wait_state = 0;
		static_cast<GetVersionEpochActorActor*>(this)->ActorCallback< GetVersionEpochActorActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< GetVersionEpochActorActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("getVersionEpochActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionEpochActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getVersionEpochActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetVersionEpochActorActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("getVersionEpochActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionEpochActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getVersionEpochActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetVersionEpochActorActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("getVersionEpochActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionEpochActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getVersionEpochActor", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 2123 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	ReadYourWritesTransaction* ryw;
															#line 2123 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	KeyRangeRef kr;
															#line 11283 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
};
// This generated class is to be used only via getVersionEpochActor()
															#line 2123 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class GetVersionEpochActorActor final : public Actor<RangeResult>, public ActorCallback< GetVersionEpochActorActor, 0, Optional<Value> >, public FastAllocated<GetVersionEpochActorActor>, public GetVersionEpochActorActorState<GetVersionEpochActorActor> {
															#line 11288 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
public:
	using FastAllocated<GetVersionEpochActorActor>::operator new;
	using FastAllocated<GetVersionEpochActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17259559263209163776UL, 6138614899688003328UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<RangeResult>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetVersionEpochActorActor, 0, Optional<Value> >;
															#line 2123 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	GetVersionEpochActorActor(ReadYourWritesTransaction* const& ryw,KeyRangeRef const& kr) 
															#line 11305 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		 : Actor<RangeResult>(),
		   GetVersionEpochActorActorState<GetVersionEpochActorActor>(ryw, kr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getVersionEpochActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6887551967245793024UL, 9563326708339697408UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionEpochActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getVersionEpochActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getVersionEpochActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetVersionEpochActorActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2123 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
[[nodiscard]] static Future<RangeResult> getVersionEpochActor( ReadYourWritesTransaction* const& ryw, KeyRangeRef const& kr ) {
															#line 2123 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	return Future<RangeResult>(new GetVersionEpochActorActor(ryw, kr));
															#line 11338 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
}

#line 2135 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"

VersionEpochImpl::VersionEpochImpl(KeyRangeRef kr) : SpecialKeyRangeRWImpl(kr) {}

Future<RangeResult> VersionEpochImpl::getRange(ReadYourWritesTransaction* ryw,
                                               KeyRangeRef kr,
                                               GetRangeLimits limitsHint) const {
	ASSERT(kr == getKeyRange());
	return getVersionEpochActor(ryw, kr);
}

Future<Optional<std::string>> VersionEpochImpl::commit(ReadYourWritesTransaction* ryw) {
	auto versionEpoch =
	    ryw->getSpecialKeySpaceWriteMap()[SpecialKeySpace::getManagementApiCommandPrefix("versionepoch")].second;
	if (versionEpoch.present()) {
		int64_t epoch = BinaryReader::fromStringRef<int64_t>(versionEpoch.get(), Unversioned());
		ryw->getTransaction().setOption(FDBTransactionOptions::LOCK_AWARE);
		ryw->getTransaction().setOption(FDBTransactionOptions::RAW_ACCESS);
		ryw->getTransaction().set(versionEpochKey, BinaryWriter::toValue(epoch, Unversioned()));
	} else {
		ryw->getTransaction().clear(versionEpochKey);
	}
	return Optional<std::string>();
}

ClientProfilingImpl::ClientProfilingImpl(KeyRangeRef kr) : SpecialKeyRangeRWImpl(kr) {}

Future<RangeResult> ClientProfilingImpl::getRange(ReadYourWritesTransaction* ryw,
                                                  KeyRangeRef kr,
                                                  GetRangeLimits limitsHint) const {
	KeyRef prefix = getKeyRange().begin;
	RangeResult result = RangeResult();
	// client_txn_sample_rate
	Key sampleRateKey = "client_txn_sample_rate"_sr.withPrefix(prefix);

	ryw->getTransaction().setOption(FDBTransactionOptions::RAW_ACCESS);

	if (kr.contains(sampleRateKey)) {
		auto entry = ryw->getSpecialKeySpaceWriteMap()[sampleRateKey];
		if (!ryw->readYourWritesDisabled() && entry.first) {
			// clear is forbidden
			ASSERT(entry.second.present());
			result.push_back_deep(result.arena(), KeyValueRef(sampleRateKey, entry.second.get()));
		} else {
			std::string sampleRateStr = "default";
			const double sampleRateDbl = ryw->getDatabase()->globalConfig->get<double>(
			    fdbClientInfoTxnSampleRate, std::numeric_limits<double>::infinity());
			if (!std::isinf(sampleRateDbl)) {
				sampleRateStr = std::to_string(sampleRateDbl);
			}
			result.push_back_deep(result.arena(), KeyValueRef(sampleRateKey, Value(sampleRateStr)));
		}
	}
	// client_txn_size_limit
	Key txnSizeLimitKey = "client_txn_size_limit"_sr.withPrefix(prefix);
	if (kr.contains(txnSizeLimitKey)) {
		auto entry = ryw->getSpecialKeySpaceWriteMap()[txnSizeLimitKey];
		if (!ryw->readYourWritesDisabled() && entry.first) {
			// clear is forbidden
			ASSERT(entry.second.present());
			result.push_back_deep(result.arena(), KeyValueRef(txnSizeLimitKey, entry.second.get()));
		} else {
			std::string sizeLimitStr = "default";
			const int64_t sizeLimit = ryw->getDatabase()->globalConfig->get<int64_t>(fdbClientInfoTxnSizeLimit, -1);
			if (sizeLimit != -1) {
				sizeLimitStr = boost::lexical_cast<std::string>(sizeLimit);
			}
			result.push_back_deep(result.arena(), KeyValueRef(txnSizeLimitKey, Value(sizeLimitStr)));
		}
	}
	return result;
}

Future<Optional<std::string>> ClientProfilingImpl::commit(ReadYourWritesTransaction* ryw) {
	ryw->getTransaction().setOption(FDBTransactionOptions::RAW_ACCESS);

	Standalone<VectorRef<KeyValueRef>> insertions;
	Standalone<VectorRef<KeyRangeRef>> clears;

	// client_txn_sample_rate
	Key sampleRateKey = "client_txn_sample_rate"_sr.withPrefix(getKeyRange().begin);
	auto rateEntry = ryw->getSpecialKeySpaceWriteMap()[sampleRateKey];

	if (rateEntry.first && rateEntry.second.present()) {
		std::string sampleRateStr = rateEntry.second.get().toString();
		if (sampleRateStr == "default") {
			clears.push_back_deep(clears.arena(),
			                      KeyRangeRef(fdbClientInfoTxnSampleRate, keyAfter(fdbClientInfoTxnSampleRate)));
		} else {
			try {
				double sampleRate = boost::lexical_cast<double>(sampleRateStr);
				Tuple rate = Tuple::makeTuple(sampleRate);
				insertions.push_back_deep(insertions.arena(), KeyValueRef(fdbClientInfoTxnSampleRate, rate.pack()));
			} catch (boost::bad_lexical_cast& e) {
				return Optional<std::string>(ManagementAPIError::toJsonString(
				    false, "profile", "Invalid transaction sample rate(double): " + sampleRateStr));
			}
		}
	}
	// client_txn_size_limit
	Key txnSizeLimitKey = "client_txn_size_limit"_sr.withPrefix(getKeyRange().begin);
	auto sizeLimitEntry = ryw->getSpecialKeySpaceWriteMap()[txnSizeLimitKey];
	if (sizeLimitEntry.first && sizeLimitEntry.second.present()) {
		std::string sizeLimitStr = sizeLimitEntry.second.get().toString();
		if (sizeLimitStr == "default") {
			clears.push_back_deep(clears.arena(),
			                      KeyRangeRef(fdbClientInfoTxnSizeLimit, keyAfter(fdbClientInfoTxnSizeLimit)));
		} else {
			try {
				int64_t sizeLimit = boost::lexical_cast<int64_t>(sizeLimitStr);
				Tuple size = Tuple::makeTuple(sizeLimit);
				insertions.push_back_deep(insertions.arena(), KeyValueRef(fdbClientInfoTxnSizeLimit, size.pack()));
			} catch (boost::bad_lexical_cast& e) {
				return Optional<std::string>(ManagementAPIError::toJsonString(
				    false, "profile", "Invalid transaction size limit(int64_t): " + sizeLimitStr));
			}
		}
	}
	GlobalConfig::applyChanges(ryw->getTransaction(), insertions, clears);
	return Optional<std::string>();
}

void ClientProfilingImpl::clear(ReadYourWritesTransaction* ryw, const KeyRangeRef& range) {
	return throwSpecialKeyApiFailure(
	    ryw, "profile", "Clear range is forbidden for profile client. You can set it to default to disable profiling.");
}

void ClientProfilingImpl::clear(ReadYourWritesTransaction* ryw, const KeyRef& key) {
	return throwSpecialKeyApiFailure(
	    ryw,
	    "profile",
	    "Clear operation is forbidden for profile client. You can set it to default to disable profiling.");
}

ActorLineageImpl::ActorLineageImpl(KeyRangeRef kr) : SpecialKeyRangeReadImpl(kr) {}

void parse(StringRef& val, int& i) {
	i = std::stoi(val.toString());
}

void parse(StringRef& val, double& d) {
	d = std::stod(val.toString());
}

void parse(StringRef& val, WaitState& w) {
	if (val == "disk"_sr || val == "Disk"_sr) {
		w = WaitState::Disk;
	} else if (val == "network"_sr || val == "Network"_sr) {
		w = WaitState::Network;
	} else if (val == "running"_sr || val == "Running"_sr) {
		w = WaitState::Running;
	} else {
		throw std::range_error("failed to parse run state");
	}
}

void parse(StringRef& val, time_t& t) {
	struct tm tm;
#ifdef _WIN32
	std::istringstream s(val.toString());
	s.imbue(std::locale(setlocale(LC_TIME, nullptr)));
	s >> std::get_time(&tm, "%FT%T%z");
	if (s.fail()) {
		throw std::invalid_argument("failed to parse ISO 8601 datetime");
	}
	long timezone;
	if (_get_timezone(&timezone) != 0) {
		throw std::runtime_error("failed to convert ISO 8601 datetime");
	}
	timezone = -timezone;
#else
	if (strptime(val.toString().c_str(), "%FT%T%z", &tm) == nullptr) {
		throw std::invalid_argument("failed to parse ISO 8601 datetime");
	}
	long timezone = tm.tm_gmtoff;
	t = timegm(&tm);
	if (t == -1) {
		throw std::runtime_error("failed to convert ISO 8601 datetime");
	}
	t -= timezone;
#endif
}

void parse(StringRef& val, NetworkAddress& a) {
	auto address = NetworkAddress::parse(val.toString());
	if (!address.isValid()) {
		throw std::invalid_argument("invalid host");
	}
	a = address;
}

// Base case function for parsing function below.
template <typename T>
void parse(std::vector<StringRef>::iterator it, std::vector<StringRef>::iterator end, T& t1) {
	if (it == end) {
		return;
	}
	parse(*it, t1);
}

// Given an iterator into a vector of string tokens, an iterator to the end of
// the search space in the vector (exclusive), and a list of references to
// types, parses each token in the vector into the associated type according to
// the order of the arguments.
//
// For example, given the vector ["1", "1.5", "127.0.0.1:4000"] and the
// argument list int a, double b, NetworkAddress c, after this function returns
// each parameter passed in will hold the parsed value from the token list.
//
// The appropriate parsing function must be implemented for the type you wish
// to parse. See the existing parsing functions above, and add your own if
// necessary.
template <typename T, typename... Types>
void parse(std::vector<StringRef>::iterator it, std::vector<StringRef>::iterator end, T& t1, Types&... remaining) {
	// Return as soon as all tokens have been parsed. This allows parameters
	// passed at the end to act as optional parameters -- they will only be set
	// if the value exists.
	if (it == end) {
		return;
	}

	try {
		parse(*it, t1);
		parse(++it, end, remaining...);
	} catch (Error& e) {
		throw e;
	} catch (std::exception& e) {
		throw e;
	}
}

															#line 11572 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
namespace {
// This generated class is to be used only via actorLineageGetRangeActor()
															#line 2365 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
template <class ActorLineageGetRangeActorActor>
															#line 2365 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class ActorLineageGetRangeActorActorState {
															#line 11579 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
public:
															#line 2365 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	ActorLineageGetRangeActorActorState(ReadYourWritesTransaction* const& ryw,KeyRef const& prefix,KeyRangeRef const& kr) 
															#line 2365 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
															#line 2365 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		 : ryw(ryw),
															#line 2365 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   prefix(prefix),
															#line 2365 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   kr(kr),
															#line 2368 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   result(),
															#line 2372 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   host(),
															#line 2373 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   waitStateStart(WaitState{ 0 }),
															#line 2374 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   waitStateEnd(WaitState{ 2 }),
															#line 2375 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   timeStart(0),
															#line 2376 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   timeEnd(std::numeric_limits<time_t>::max()),
															#line 2377 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   seqStart(0),
															#line 2378 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   seqEnd(std::numeric_limits<int>::max()),
															#line 2380 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   beginValues(kr.begin.removePrefix(prefix).splitAny("/"_sr)),
															#line 2381 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   endValues(kr.end.removePrefix(prefix).splitAny("/"_sr))
															#line 11610 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
	{
		fdb_probe_actor_create("actorLineageGetRangeActor", reinterpret_cast<unsigned long>(this));

	}
	~ActorLineageGetRangeActorActorState() 
	{
		fdb_probe_actor_destroy("actorLineageGetRangeActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2383 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (beginValues.size() < 2 || endValues.size() < 2)
															#line 11625 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			{
															#line 2384 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				ryw->setSpecialKeySpaceErrorMsg( ManagementAPIError::toJsonString(false, "read actor_lineage", "missing required parameters (index, host)"));
															#line 2386 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				return a_body1Catch1(special_keys_api_failure(), loopDepth);
															#line 11631 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			}
															#line 2389 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			endRangeHost = NetworkAddress();
															#line 11635 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			try {
															#line 2391 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (SpecialKeySpace::getActorLineageApiCommandRange("state").contains(kr))
															#line 11639 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
				{
															#line 2393 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					parse(beginValues.begin() + 1, beginValues.end(), host, waitStateStart, timeStart, seqStart);
															#line 2394 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					if (kr.begin != kr.end)
															#line 11645 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
					{
															#line 2395 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						parse(endValues.begin() + 1, endValues.end(), endRangeHost, waitStateEnd, timeEnd, seqEnd);
															#line 11649 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
					}
				}
				else
				{
															#line 2397 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					if (SpecialKeySpace::getActorLineageApiCommandRange("time").contains(kr))
															#line 11656 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
					{
															#line 2399 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						parse(beginValues.begin() + 1, beginValues.end(), host, timeStart, waitStateStart, seqStart);
															#line 2400 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						if (kr.begin != kr.end)
															#line 11662 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
						{
															#line 2401 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
							parse(endValues.begin() + 1, endValues.end(), endRangeHost, timeEnd, waitStateEnd, seqEnd);
															#line 11666 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
						}
					}
					else
					{
															#line 2404 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						ryw->setSpecialKeySpaceErrorMsg( ManagementAPIError::toJsonString(false, "read actor_lineage", "invalid index in actor_lineage"));
															#line 2406 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						return a_body1Catch2(special_keys_api_failure(), loopDepth);
															#line 11675 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
					}
				}
				loopDepth = a_body1cont10(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ActorLineageGetRangeActorActorState();
		static_cast<ActorLineageGetRangeActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2418 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (kr.begin != kr.end && host != endRangeHost)
															#line 11706 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		{
															#line 2421 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ryw->setSpecialKeySpaceErrorMsg(ManagementAPIError::toJsonString( false, "read actor_lineage", "the host must remain the same on both ends of the range"));
															#line 2423 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			return a_body1Catch1(special_keys_api_failure(), loopDepth);
															#line 11712 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		}
															#line 2428 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		process = ProcessInterface();
															#line 2429 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		process.getInterface = RequestStream<GetProcessInterfaceRequest>(Endpoint::wellKnown({ host }, WLTOKEN_PROCESS));
															#line 2430 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		StrictFuture<ProcessInterface> __when_expr_0 = retryBrokenPromise(process.getInterface, GetProcessInterfaceRequest{});
															#line 2430 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (static_cast<ActorLineageGetRangeActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11722 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1cont1when1(__when_expr_0.get(), loopDepth); };
		static_cast<ActorLineageGetRangeActorActor*>(this)->actor_wait_state = 1;
															#line 2430 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ActorLineageGetRangeActorActor, 0, ProcessInterface >*>(static_cast<ActorLineageGetRangeActorActor*>(this)));
															#line 11727 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2409 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (e.code() != special_keys_api_failure().code())
															#line 11737 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			{
															#line 2410 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				ryw->setSpecialKeySpaceErrorMsg( ManagementAPIError::toJsonString(false, "read actor_lineage", "failed to parse key"));
															#line 2412 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				return a_body1Catch1(special_keys_api_failure(), loopDepth);
															#line 11743 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			}
			else
			{
															#line 2414 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 11749 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11(ProcessInterface const& p,int loopDepth) 
	{
															#line 2431 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		process = p;
															#line 2433 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		ActorLineageRequest actorLineageRequest;
															#line 2434 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		actorLineageRequest.waitStateStart = waitStateStart;
															#line 2435 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		actorLineageRequest.waitStateEnd = waitStateEnd;
															#line 2436 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		actorLineageRequest.timeStart = timeStart;
															#line 2437 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		actorLineageRequest.timeEnd = timeEnd;
															#line 2438 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		StrictFuture<ActorLineageReply> __when_expr_1 = process.actorLineage.getReply(actorLineageRequest);
															#line 2438 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (static_cast<ActorLineageGetRangeActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11791 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont11when1(__when_expr_1.get(), loopDepth); };
		static_cast<ActorLineageGetRangeActorActor*>(this)->actor_wait_state = 2;
															#line 2438 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ActorLineageGetRangeActorActor, 1, ActorLineageReply >*>(static_cast<ActorLineageGetRangeActorActor*>(this)));
															#line 11796 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11(ProcessInterface && p,int loopDepth) 
	{
															#line 2431 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		process = p;
															#line 2433 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		ActorLineageRequest actorLineageRequest;
															#line 2434 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		actorLineageRequest.waitStateStart = waitStateStart;
															#line 2435 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		actorLineageRequest.waitStateEnd = waitStateEnd;
															#line 2436 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		actorLineageRequest.timeStart = timeStart;
															#line 2437 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		actorLineageRequest.timeEnd = timeEnd;
															#line 2438 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		StrictFuture<ActorLineageReply> __when_expr_1 = process.actorLineage.getReply(actorLineageRequest);
															#line 2438 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (static_cast<ActorLineageGetRangeActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11819 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont11when1(__when_expr_1.get(), loopDepth); };
		static_cast<ActorLineageGetRangeActorActor*>(this)->actor_wait_state = 2;
															#line 2438 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ActorLineageGetRangeActorActor, 1, ActorLineageReply >*>(static_cast<ActorLineageGetRangeActorActor*>(this)));
															#line 11824 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(ProcessInterface const& p,int loopDepth) 
	{
		loopDepth = a_body1cont11(p, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(ProcessInterface && p,int loopDepth) 
	{
		loopDepth = a_body1cont11(std::move(p), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ActorLineageGetRangeActorActor*>(this)->actor_wait_state > 0) static_cast<ActorLineageGetRangeActorActor*>(this)->actor_wait_state = 0;
		static_cast<ActorLineageGetRangeActorActor*>(this)->ActorCallback< ActorLineageGetRangeActorActor, 0, ProcessInterface >::remove();

	}
	void a_callback_fire(ActorCallback< ActorLineageGetRangeActorActor, 0, ProcessInterface >*,ProcessInterface const& value) 
	{
		fdb_probe_actor_enter("actorLineageGetRangeActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ActorLineageGetRangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("actorLineageGetRangeActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ActorLineageGetRangeActorActor, 0, ProcessInterface >*,ProcessInterface && value) 
	{
		fdb_probe_actor_enter("actorLineageGetRangeActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ActorLineageGetRangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("actorLineageGetRangeActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ActorLineageGetRangeActorActor, 0, ProcessInterface >*,Error err) 
	{
		fdb_probe_actor_enter("actorLineageGetRangeActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ActorLineageGetRangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("actorLineageGetRangeActor", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont11cont1(ActorLineageReply const& reply,int loopDepth) 
	{
															#line 2440 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		time_t dt = 0;
															#line 2441 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		int seq = -1;
															#line 2442 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		for( const auto& sample : reply.samples ) {
															#line 2443 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			time_t datetime = (time_t)sample.time;
															#line 2444 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			char buf[50];
															#line 2445 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			struct tm* tm;
															#line 2446 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			tm = localtime(&datetime);
															#line 2447 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			size_t size = strftime(buf, 50, "%FT%T%z", tm);
															#line 2448 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			std::string date(buf, size);
															#line 2450 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			seq = dt == datetime ? seq + 1 : 0;
															#line 2451 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			dt = datetime;
															#line 2453 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			for( const auto& [waitState, data] : sample.data ) {
															#line 2454 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (seq < seqStart)
															#line 11932 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
				{
					continue;
				}
				else
				{
															#line 2456 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					if (seq >= seqEnd)
															#line 11940 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
					{
						break;
					}
				}
															#line 2460 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				std::ostringstream streamKey;
															#line 2461 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (SpecialKeySpace::getActorLineageApiCommandRange("state").contains(kr))
															#line 11949 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
				{
															#line 2462 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					streamKey << SpecialKeySpace::getActorLineageApiCommandPrefix("state").toString() << host.toString() << "/" << to_string(waitState) << "/" << date;
															#line 11953 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
				}
				else
				{
															#line 2464 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					if (SpecialKeySpace::getActorLineageApiCommandRange("time").contains(kr))
															#line 11959 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
					{
															#line 2465 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						streamKey << SpecialKeySpace::getActorLineageApiCommandPrefix("time").toString() << host.toString() << "/" << date << "/" << to_string(waitState);
															#line 11963 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
					}
					else
					{
															#line 2468 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						ASSERT(false);
															#line 11969 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
					}
				}
															#line 2470 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				streamKey << "/" << seq;
															#line 2472 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				msgpack::object_handle oh = msgpack::unpack(data.data(), data.size());
															#line 2473 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				msgpack::object deserialized = oh.get();
															#line 2475 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				std::ostringstream stream;
															#line 2476 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				stream << deserialized;
															#line 2478 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				result.push_back_deep(result.arena(), KeyValueRef(streamKey.str(), stream.str()));
															#line 11984 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			}
															#line 2481 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (sample.data.size() == 0)
															#line 11988 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			{
															#line 2482 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				std::ostringstream streamKey;
															#line 2483 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (SpecialKeySpace::getActorLineageApiCommandRange("state").contains(kr))
															#line 11994 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
				{
															#line 2484 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					streamKey << SpecialKeySpace::getActorLineageApiCommandPrefix("state").toString() << host.toString() << "/Running/" << date;
															#line 11998 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
				}
				else
				{
															#line 2486 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					if (SpecialKeySpace::getActorLineageApiCommandRange("time").contains(kr))
															#line 12004 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
					{
															#line 2487 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						streamKey << SpecialKeySpace::getActorLineageApiCommandPrefix("time").toString() << host.toString() << "/" << date << "/Running";
															#line 12008 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
					}
					else
					{
															#line 2490 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						ASSERT(false);
															#line 12014 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
					}
				}
															#line 2492 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				streamKey << "/" << seq;
															#line 2493 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				result.push_back_deep(result.arena(), KeyValueRef(streamKey.str(), "{}"_sr));
															#line 12021 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			}
		}
															#line 2497 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<ActorLineageGetRangeActorActor*>(this)->SAV<RangeResult>::futures) { (void)(result); this->~ActorLineageGetRangeActorActorState(); static_cast<ActorLineageGetRangeActorActor*>(this)->destroy(); return 0; }
															#line 12026 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		new (&static_cast<ActorLineageGetRangeActorActor*>(this)->SAV< RangeResult >::value()) RangeResult(std::move(result)); // state_var_RVO
		this->~ActorLineageGetRangeActorActorState();
		static_cast<ActorLineageGetRangeActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont11cont1(ActorLineageReply && reply,int loopDepth) 
	{
															#line 2440 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		time_t dt = 0;
															#line 2441 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		int seq = -1;
															#line 2442 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		for( const auto& sample : reply.samples ) {
															#line 2443 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			time_t datetime = (time_t)sample.time;
															#line 2444 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			char buf[50];
															#line 2445 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			struct tm* tm;
															#line 2446 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			tm = localtime(&datetime);
															#line 2447 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			size_t size = strftime(buf, 50, "%FT%T%z", tm);
															#line 2448 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			std::string date(buf, size);
															#line 2450 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			seq = dt == datetime ? seq + 1 : 0;
															#line 2451 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			dt = datetime;
															#line 2453 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			for( const auto& [waitState, data] : sample.data ) {
															#line 2454 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (seq < seqStart)
															#line 12062 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
				{
					continue;
				}
				else
				{
															#line 2456 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					if (seq >= seqEnd)
															#line 12070 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
					{
						break;
					}
				}
															#line 2460 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				std::ostringstream streamKey;
															#line 2461 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (SpecialKeySpace::getActorLineageApiCommandRange("state").contains(kr))
															#line 12079 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
				{
															#line 2462 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					streamKey << SpecialKeySpace::getActorLineageApiCommandPrefix("state").toString() << host.toString() << "/" << to_string(waitState) << "/" << date;
															#line 12083 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
				}
				else
				{
															#line 2464 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					if (SpecialKeySpace::getActorLineageApiCommandRange("time").contains(kr))
															#line 12089 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
					{
															#line 2465 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						streamKey << SpecialKeySpace::getActorLineageApiCommandPrefix("time").toString() << host.toString() << "/" << date << "/" << to_string(waitState);
															#line 12093 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
					}
					else
					{
															#line 2468 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						ASSERT(false);
															#line 12099 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
					}
				}
															#line 2470 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				streamKey << "/" << seq;
															#line 2472 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				msgpack::object_handle oh = msgpack::unpack(data.data(), data.size());
															#line 2473 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				msgpack::object deserialized = oh.get();
															#line 2475 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				std::ostringstream stream;
															#line 2476 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				stream << deserialized;
															#line 2478 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				result.push_back_deep(result.arena(), KeyValueRef(streamKey.str(), stream.str()));
															#line 12114 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			}
															#line 2481 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (sample.data.size() == 0)
															#line 12118 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			{
															#line 2482 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				std::ostringstream streamKey;
															#line 2483 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (SpecialKeySpace::getActorLineageApiCommandRange("state").contains(kr))
															#line 12124 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
				{
															#line 2484 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					streamKey << SpecialKeySpace::getActorLineageApiCommandPrefix("state").toString() << host.toString() << "/Running/" << date;
															#line 12128 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
				}
				else
				{
															#line 2486 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					if (SpecialKeySpace::getActorLineageApiCommandRange("time").contains(kr))
															#line 12134 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
					{
															#line 2487 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						streamKey << SpecialKeySpace::getActorLineageApiCommandPrefix("time").toString() << host.toString() << "/" << date << "/Running";
															#line 12138 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
					}
					else
					{
															#line 2490 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
						ASSERT(false);
															#line 12144 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
					}
				}
															#line 2492 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				streamKey << "/" << seq;
															#line 2493 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				result.push_back_deep(result.arena(), KeyValueRef(streamKey.str(), "{}"_sr));
															#line 12151 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			}
		}
															#line 2497 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<ActorLineageGetRangeActorActor*>(this)->SAV<RangeResult>::futures) { (void)(result); this->~ActorLineageGetRangeActorActorState(); static_cast<ActorLineageGetRangeActorActor*>(this)->destroy(); return 0; }
															#line 12156 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		new (&static_cast<ActorLineageGetRangeActorActor*>(this)->SAV< RangeResult >::value()) RangeResult(std::move(result)); // state_var_RVO
		this->~ActorLineageGetRangeActorActorState();
		static_cast<ActorLineageGetRangeActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont11when1(ActorLineageReply const& reply,int loopDepth) 
	{
		loopDepth = a_body1cont11cont1(reply, loopDepth);

		return loopDepth;
	}
	int a_body1cont11when1(ActorLineageReply && reply,int loopDepth) 
	{
		loopDepth = a_body1cont11cont1(std::move(reply), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ActorLineageGetRangeActorActor*>(this)->actor_wait_state > 0) static_cast<ActorLineageGetRangeActorActor*>(this)->actor_wait_state = 0;
		static_cast<ActorLineageGetRangeActorActor*>(this)->ActorCallback< ActorLineageGetRangeActorActor, 1, ActorLineageReply >::remove();

	}
	void a_callback_fire(ActorCallback< ActorLineageGetRangeActorActor, 1, ActorLineageReply >*,ActorLineageReply const& value) 
	{
		fdb_probe_actor_enter("actorLineageGetRangeActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ActorLineageGetRangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont11when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("actorLineageGetRangeActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ActorLineageGetRangeActorActor, 1, ActorLineageReply >*,ActorLineageReply && value) 
	{
		fdb_probe_actor_enter("actorLineageGetRangeActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ActorLineageGetRangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont11when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("actorLineageGetRangeActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ActorLineageGetRangeActorActor, 1, ActorLineageReply >*,Error err) 
	{
		fdb_probe_actor_enter("actorLineageGetRangeActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ActorLineageGetRangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("actorLineageGetRangeActor", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 2365 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	ReadYourWritesTransaction* ryw;
															#line 2365 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	KeyRef prefix;
															#line 2365 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	KeyRangeRef kr;
															#line 2368 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	RangeResult result;
															#line 2372 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	NetworkAddress host;
															#line 2373 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	WaitState waitStateStart;
															#line 2374 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	WaitState waitStateEnd;
															#line 2375 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	time_t timeStart;
															#line 2376 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	time_t timeEnd;
															#line 2377 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	int seqStart;
															#line 2378 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	int seqEnd;
															#line 2380 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	std::vector<StringRef> beginValues;
															#line 2381 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	std::vector<StringRef> endValues;
															#line 2389 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	NetworkAddress endRangeHost;
															#line 2428 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	ProcessInterface process;
															#line 12269 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
};
// This generated class is to be used only via actorLineageGetRangeActor()
															#line 2365 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class ActorLineageGetRangeActorActor final : public Actor<RangeResult>, public ActorCallback< ActorLineageGetRangeActorActor, 0, ProcessInterface >, public ActorCallback< ActorLineageGetRangeActorActor, 1, ActorLineageReply >, public FastAllocated<ActorLineageGetRangeActorActor>, public ActorLineageGetRangeActorActorState<ActorLineageGetRangeActorActor> {
															#line 12274 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
public:
	using FastAllocated<ActorLineageGetRangeActorActor>::operator new;
	using FastAllocated<ActorLineageGetRangeActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5583003934477956864UL, 18417623805428313088UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<RangeResult>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ActorLineageGetRangeActorActor, 0, ProcessInterface >;
friend struct ActorCallback< ActorLineageGetRangeActorActor, 1, ActorLineageReply >;
															#line 2365 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	ActorLineageGetRangeActorActor(ReadYourWritesTransaction* const& ryw,KeyRef const& prefix,KeyRangeRef const& kr) 
															#line 12292 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		 : Actor<RangeResult>(),
		   ActorLineageGetRangeActorActorState<ActorLineageGetRangeActorActor>(ryw, prefix, kr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("actorLineageGetRangeActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5704535707815985408UL, 4894892317905807872UL);
		ActorExecutionContextHelper __helper(static_cast<ActorLineageGetRangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("actorLineageGetRangeActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("actorLineageGetRangeActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ActorLineageGetRangeActorActor, 0, ProcessInterface >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ActorLineageGetRangeActorActor, 1, ActorLineageReply >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2365 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
[[nodiscard]] static Future<RangeResult> actorLineageGetRangeActor( ReadYourWritesTransaction* const& ryw, KeyRef const& prefix, KeyRangeRef const& kr ) {
															#line 2365 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	return Future<RangeResult>(new ActorLineageGetRangeActorActor(ryw, prefix, kr));
															#line 12326 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
}

#line 2499 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"

Future<RangeResult> ActorLineageImpl::getRange(ReadYourWritesTransaction* ryw,
                                               KeyRangeRef kr,
                                               GetRangeLimits limitsHint) const {
	return actorLineageGetRangeActor(ryw, getKeyRange().begin, kr);
}

namespace {
std::string_view to_string_view(StringRef sr) {
	return std::string_view(reinterpret_cast<const char*>(sr.begin()), sr.size());
}
} // namespace

ActorProfilerConf::ActorProfilerConf(KeyRangeRef kr)
  : SpecialKeyRangeRWImpl(kr), config(ProfilerConfig::instance().getConfig()) {}

Future<RangeResult> ActorProfilerConf::getRange(ReadYourWritesTransaction* ryw,
                                                KeyRangeRef kr,
                                                GetRangeLimits limitsHint) const {
	RangeResult res;
	std::string_view begin(to_string_view(kr.begin.removePrefix(range.begin))),
	    end(to_string_view(kr.end.removePrefix(range.begin)));
	for (auto& p : config) {
		if (p.first > end) {
			break;
		} else if (p.first > begin) {
			KeyValueRef kv;
			kv.key = StringRef(res.arena(), p.first).withPrefix(kr.begin, res.arena());
			kv.value = StringRef(res.arena(), p.second);
			res.push_back(res.arena(), kv);
		}
	}
	return res;
}

void ActorProfilerConf::set(ReadYourWritesTransaction* ryw, const KeyRef& key, const ValueRef& value) {
	config[key.removePrefix(range.begin).toString()] = value.toString();
	ryw->getSpecialKeySpaceWriteMap().insert(key, std::make_pair(true, Optional<Value>(value)));
	didWrite = true;
}

void ActorProfilerConf::clear(ReadYourWritesTransaction* ryw, const KeyRangeRef& kr) {
	std::string begin(kr.begin.removePrefix(range.begin).toString()), end(kr.end.removePrefix(range.begin).toString());
	auto first = config.lower_bound(begin);
	if (first == config.end()) {
		// nothing to clear
		return;
	}
	didWrite = true;
	auto last = config.upper_bound(end);
	config.erase(first, last);
}

void ActorProfilerConf::clear(ReadYourWritesTransaction* ryw, const KeyRef& key) {
	std::string k = key.removePrefix(range.begin).toString();
	auto iter = config.find(k);
	if (iter != config.end()) {
		config.erase(iter);
	}
	didWrite = true;
}

Future<Optional<std::string>> ActorProfilerConf::commit(ReadYourWritesTransaction* ryw) {
	Optional<std::string> res{};
	try {
		if (didWrite) {
			ProfilerConfig::instance().reset(config);
		}
		return res;
	} catch (ConfigError& err) {
		return Optional<std::string>{ err.description };
	}
}

MaintenanceImpl::MaintenanceImpl(KeyRangeRef kr) : SpecialKeyRangeRWImpl(kr) {}

// Used to read the healthZoneKey
// If the key is persisted and the delayed read version is still larger than current read version,
// we will calculate the remaining time(truncated to integer, the same as fdbcli) and return back as the value
// If the zoneId is the special one `ignoreSSFailuresZoneString`,
// value will be 0 (same as fdbcli)
															#line 12411 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
namespace {
// This generated class is to be used only via MaintenanceGetRangeActor()
															#line 2580 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
template <class MaintenanceGetRangeActorActor>
															#line 2580 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class MaintenanceGetRangeActorActorState {
															#line 12418 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
public:
															#line 2580 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	MaintenanceGetRangeActorActorState(ReadYourWritesTransaction* const& ryw,KeyRef const& prefix,KeyRangeRef const& kr) 
															#line 2580 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
															#line 2580 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		 : ryw(ryw),
															#line 2580 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   prefix(prefix),
															#line 2580 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   kr(kr),
															#line 2583 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   result()
															#line 12431 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
	{
		fdb_probe_actor_create("MaintenanceGetRangeActor", reinterpret_cast<unsigned long>(this));

	}
	~MaintenanceGetRangeActorActorState() 
	{
		fdb_probe_actor_destroy("MaintenanceGetRangeActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2585 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ryw->getTransaction().setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 2586 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ryw->getTransaction().setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 2587 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = ryw->getTransaction().get(healthyZoneKey);
															#line 2587 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (static_cast<MaintenanceGetRangeActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12452 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<MaintenanceGetRangeActorActor*>(this)->actor_wait_state = 1;
															#line 2587 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MaintenanceGetRangeActorActor, 0, Optional<Value> >*>(static_cast<MaintenanceGetRangeActorActor*>(this)));
															#line 12457 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MaintenanceGetRangeActorActorState();
		static_cast<MaintenanceGetRangeActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> const& val,int loopDepth) 
	{
															#line 2588 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (val.present())
															#line 12480 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		{
															#line 2589 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			auto healthyZone = decodeHealthyZoneValue(val.get());
															#line 2590 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if ((healthyZone.first == ignoreSSFailuresZoneString) || (healthyZone.second > ryw->getTransaction().getReadVersion().get()))
															#line 12486 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			{
															#line 2592 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				Key zone_key = healthyZone.first.withPrefix(prefix);
															#line 2593 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				double seconds = healthyZone.first == ignoreSSFailuresZoneString ? 0 : (healthyZone.second - ryw->getTransaction().getReadVersion().get()) / CLIENT_KNOBS->CORE_VERSIONSPERSECOND;
															#line 2597 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (kr.contains(zone_key))
															#line 12494 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
				{
															#line 2598 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					result.push_back_deep(result.arena(), KeyValueRef(zone_key, Value(boost::lexical_cast<std::string>(seconds))));
															#line 12498 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
				}
			}
		}
															#line 2603 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<MaintenanceGetRangeActorActor*>(this)->SAV<RangeResult>::futures) { (void)(rywGetRange(ryw, kr, result)); this->~MaintenanceGetRangeActorActorState(); static_cast<MaintenanceGetRangeActorActor*>(this)->destroy(); return 0; }
															#line 12504 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		new (&static_cast<MaintenanceGetRangeActorActor*>(this)->SAV< RangeResult >::value()) RangeResult(rywGetRange(ryw, kr, result));
		this->~MaintenanceGetRangeActorActorState();
		static_cast<MaintenanceGetRangeActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> && val,int loopDepth) 
	{
															#line 2588 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (val.present())
															#line 12516 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		{
															#line 2589 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			auto healthyZone = decodeHealthyZoneValue(val.get());
															#line 2590 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if ((healthyZone.first == ignoreSSFailuresZoneString) || (healthyZone.second > ryw->getTransaction().getReadVersion().get()))
															#line 12522 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			{
															#line 2592 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				Key zone_key = healthyZone.first.withPrefix(prefix);
															#line 2593 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				double seconds = healthyZone.first == ignoreSSFailuresZoneString ? 0 : (healthyZone.second - ryw->getTransaction().getReadVersion().get()) / CLIENT_KNOBS->CORE_VERSIONSPERSECOND;
															#line 2597 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (kr.contains(zone_key))
															#line 12530 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
				{
															#line 2598 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					result.push_back_deep(result.arena(), KeyValueRef(zone_key, Value(boost::lexical_cast<std::string>(seconds))));
															#line 12534 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
				}
			}
		}
															#line 2603 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<MaintenanceGetRangeActorActor*>(this)->SAV<RangeResult>::futures) { (void)(rywGetRange(ryw, kr, result)); this->~MaintenanceGetRangeActorActorState(); static_cast<MaintenanceGetRangeActorActor*>(this)->destroy(); return 0; }
															#line 12540 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		new (&static_cast<MaintenanceGetRangeActorActor*>(this)->SAV< RangeResult >::value()) RangeResult(rywGetRange(ryw, kr, result));
		this->~MaintenanceGetRangeActorActorState();
		static_cast<MaintenanceGetRangeActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Optional<Value> const& val,int loopDepth) 
	{
		loopDepth = a_body1cont1(val, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<Value> && val,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(val), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MaintenanceGetRangeActorActor*>(this)->actor_wait_state > 0) static_cast<MaintenanceGetRangeActorActor*>(this)->actor_wait_state = 0;
		static_cast<MaintenanceGetRangeActorActor*>(this)->ActorCallback< MaintenanceGetRangeActorActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< MaintenanceGetRangeActorActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("MaintenanceGetRangeActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MaintenanceGetRangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("MaintenanceGetRangeActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MaintenanceGetRangeActorActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("MaintenanceGetRangeActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MaintenanceGetRangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("MaintenanceGetRangeActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MaintenanceGetRangeActorActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("MaintenanceGetRangeActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MaintenanceGetRangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("MaintenanceGetRangeActor", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 2580 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	ReadYourWritesTransaction* ryw;
															#line 2580 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	KeyRef prefix;
															#line 2580 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	KeyRangeRef kr;
															#line 2583 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	RangeResult result;
															#line 12631 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
};
// This generated class is to be used only via MaintenanceGetRangeActor()
															#line 2580 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class MaintenanceGetRangeActorActor final : public Actor<RangeResult>, public ActorCallback< MaintenanceGetRangeActorActor, 0, Optional<Value> >, public FastAllocated<MaintenanceGetRangeActorActor>, public MaintenanceGetRangeActorActorState<MaintenanceGetRangeActorActor> {
															#line 12636 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
public:
	using FastAllocated<MaintenanceGetRangeActorActor>::operator new;
	using FastAllocated<MaintenanceGetRangeActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16113303930837923840UL, 4513025120189166336UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<RangeResult>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MaintenanceGetRangeActorActor, 0, Optional<Value> >;
															#line 2580 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	MaintenanceGetRangeActorActor(ReadYourWritesTransaction* const& ryw,KeyRef const& prefix,KeyRangeRef const& kr) 
															#line 12653 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		 : Actor<RangeResult>(),
		   MaintenanceGetRangeActorActorState<MaintenanceGetRangeActorActor>(ryw, prefix, kr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("MaintenanceGetRangeActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16464056766269663232UL, 11056517360414997248UL);
		ActorExecutionContextHelper __helper(static_cast<MaintenanceGetRangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("MaintenanceGetRangeActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("MaintenanceGetRangeActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MaintenanceGetRangeActorActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2580 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
[[nodiscard]] static Future<RangeResult> MaintenanceGetRangeActor( ReadYourWritesTransaction* const& ryw, KeyRef const& prefix, KeyRangeRef const& kr ) {
															#line 2580 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	return Future<RangeResult>(new MaintenanceGetRangeActorActor(ryw, prefix, kr));
															#line 12686 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
}

#line 2605 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"

Future<RangeResult> MaintenanceImpl::getRange(ReadYourWritesTransaction* ryw,
                                              KeyRangeRef kr,
                                              GetRangeLimits limitsHint) const {
	return MaintenanceGetRangeActor(ryw, getKeyRange().begin, kr);
}

// Commit the change to healthZoneKey
// We do not allow more than one zone to be set in maintenance in one transaction
// In addition, if the zoneId now is 'ignoreSSFailuresZoneString',
// which means the data distribution is disabled for storage failures.
// Only clear this specific key is allowed, any other operations will throw error
															#line 12702 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
namespace {
// This generated class is to be used only via maintenanceCommitActor()
															#line 2617 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
template <class MaintenanceCommitActorActor>
															#line 2617 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class MaintenanceCommitActorActorState {
															#line 12709 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
public:
															#line 2617 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	MaintenanceCommitActorActorState(ReadYourWritesTransaction* const& ryw,KeyRangeRef const& kr) 
															#line 2617 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
															#line 2617 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		 : ryw(ryw),
															#line 2617 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   kr(kr)
															#line 12718 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
	{
		fdb_probe_actor_create("maintenanceCommitActor", reinterpret_cast<unsigned long>(this));

	}
	~MaintenanceCommitActorActorState() 
	{
		fdb_probe_actor_destroy("maintenanceCommitActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2619 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ryw->getTransaction().setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 2620 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ryw->getTransaction().setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 2621 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ryw->getTransaction().setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 2622 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = ryw->getTransaction().get(healthyZoneKey);
															#line 2622 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (static_cast<MaintenanceCommitActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12741 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<MaintenanceCommitActorActor*>(this)->actor_wait_state = 1;
															#line 2622 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MaintenanceCommitActorActor, 0, Optional<Value> >*>(static_cast<MaintenanceCommitActorActor*>(this)));
															#line 12746 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MaintenanceCommitActorActorState();
		static_cast<MaintenanceCommitActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> const& val,int loopDepth) 
	{
															#line 2623 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		Optional<std::pair<Key, Version>> healthyZone = val.present() ? decodeHealthyZoneValue(val.get()) : Optional<std::pair<Key, Version>>();
															#line 2626 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		ranges = ryw->getSpecialKeySpaceWriteMap().containedRanges(kr);
															#line 2628 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		Key zoneId;
															#line 2629 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		double seconds;
															#line 2630 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		bool isSet = false;
															#line 2634 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		for(auto iter = ranges.begin();iter != ranges.end();++iter) {
															#line 2635 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (!iter->value().first)
															#line 12781 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			{
				continue;
			}
															#line 2637 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (iter->value().second.present())
															#line 12787 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			{
															#line 2638 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (isSet)
															#line 12791 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
				{
															#line 2639 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					if (!static_cast<MaintenanceCommitActorActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(Optional<std::string>(ManagementAPIError::toJsonString( false, "maintenance", "Multiple zones given for maintenance, only one allowed at the same time"))); this->~MaintenanceCommitActorActorState(); static_cast<MaintenanceCommitActorActor*>(this)->destroy(); return 0; }
															#line 12795 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
					new (&static_cast<MaintenanceCommitActorActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(Optional<std::string>(ManagementAPIError::toJsonString( false, "maintenance", "Multiple zones given for maintenance, only one allowed at the same time")));
					this->~MaintenanceCommitActorActorState();
					static_cast<MaintenanceCommitActorActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
															#line 2641 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				isSet = true;
															#line 2642 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				zoneId = iter->begin().removePrefix(kr.begin);
															#line 2643 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				seconds = boost::lexical_cast<double>(iter->value().second.get().toString());
															#line 12807 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			}
			else
			{
															#line 2646 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (!isSet && healthyZone.present() && iter.range().contains(healthyZone.get().first.withPrefix(kr.begin)))
															#line 12813 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
				{
															#line 2647 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					ryw->getTransaction().clear(healthyZoneKey);
															#line 12817 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
				}
			}
		}
															#line 2651 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (isSet)
															#line 12823 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		{
															#line 2652 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (healthyZone.present() && healthyZone.get().first == ignoreSSFailuresZoneString)
															#line 12827 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			{
															#line 2653 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				std::string msg = "Maintenance mode cannot be used while data distribution is disabled for storage " "server failures.";
															#line 2655 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (!static_cast<MaintenanceCommitActorActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(Optional<std::string>(ManagementAPIError::toJsonString(false, "maintenance", msg))); this->~MaintenanceCommitActorActorState(); static_cast<MaintenanceCommitActorActor*>(this)->destroy(); return 0; }
															#line 12833 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
				new (&static_cast<MaintenanceCommitActorActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(Optional<std::string>(ManagementAPIError::toJsonString(false, "maintenance", msg)));
				this->~MaintenanceCommitActorActorState();
				static_cast<MaintenanceCommitActorActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 2656 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (seconds < 0)
															#line 12843 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
				{
															#line 2657 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					std::string msg = "The specified maintenance time " + boost::lexical_cast<std::string>(seconds) + " is a negative value";
															#line 2659 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					if (!static_cast<MaintenanceCommitActorActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(Optional<std::string>(ManagementAPIError::toJsonString(false, "maintenance", msg))); this->~MaintenanceCommitActorActorState(); static_cast<MaintenanceCommitActorActor*>(this)->destroy(); return 0; }
															#line 12849 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
					new (&static_cast<MaintenanceCommitActorActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(Optional<std::string>(ManagementAPIError::toJsonString(false, "maintenance", msg)));
					this->~MaintenanceCommitActorActorState();
					static_cast<MaintenanceCommitActorActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
				else
				{
															#line 2661 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					TraceEvent(SevDebug, "SKSMaintenanceSet").detail("ZoneId", zoneId.toString());
															#line 2662 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					ryw->getTransaction().set(healthyZoneKey, healthyZoneValue(zoneId, ryw->getTransaction().getReadVersion().get() + (seconds * CLIENT_KNOBS->CORE_VERSIONSPERSECOND)));
															#line 12861 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
				}
			}
		}
															#line 2668 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<MaintenanceCommitActorActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(Optional<std::string>()); this->~MaintenanceCommitActorActorState(); static_cast<MaintenanceCommitActorActor*>(this)->destroy(); return 0; }
															#line 12867 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		new (&static_cast<MaintenanceCommitActorActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(Optional<std::string>());
		this->~MaintenanceCommitActorActorState();
		static_cast<MaintenanceCommitActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> && val,int loopDepth) 
	{
															#line 2623 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		Optional<std::pair<Key, Version>> healthyZone = val.present() ? decodeHealthyZoneValue(val.get()) : Optional<std::pair<Key, Version>>();
															#line 2626 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		ranges = ryw->getSpecialKeySpaceWriteMap().containedRanges(kr);
															#line 2628 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		Key zoneId;
															#line 2629 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		double seconds;
															#line 2630 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		bool isSet = false;
															#line 2634 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		for(auto iter = ranges.begin();iter != ranges.end();++iter) {
															#line 2635 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (!iter->value().first)
															#line 12891 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			{
				continue;
			}
															#line 2637 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (iter->value().second.present())
															#line 12897 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			{
															#line 2638 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (isSet)
															#line 12901 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
				{
															#line 2639 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					if (!static_cast<MaintenanceCommitActorActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(Optional<std::string>(ManagementAPIError::toJsonString( false, "maintenance", "Multiple zones given for maintenance, only one allowed at the same time"))); this->~MaintenanceCommitActorActorState(); static_cast<MaintenanceCommitActorActor*>(this)->destroy(); return 0; }
															#line 12905 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
					new (&static_cast<MaintenanceCommitActorActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(Optional<std::string>(ManagementAPIError::toJsonString( false, "maintenance", "Multiple zones given for maintenance, only one allowed at the same time")));
					this->~MaintenanceCommitActorActorState();
					static_cast<MaintenanceCommitActorActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
															#line 2641 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				isSet = true;
															#line 2642 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				zoneId = iter->begin().removePrefix(kr.begin);
															#line 2643 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				seconds = boost::lexical_cast<double>(iter->value().second.get().toString());
															#line 12917 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			}
			else
			{
															#line 2646 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (!isSet && healthyZone.present() && iter.range().contains(healthyZone.get().first.withPrefix(kr.begin)))
															#line 12923 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
				{
															#line 2647 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					ryw->getTransaction().clear(healthyZoneKey);
															#line 12927 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
				}
			}
		}
															#line 2651 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (isSet)
															#line 12933 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		{
															#line 2652 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (healthyZone.present() && healthyZone.get().first == ignoreSSFailuresZoneString)
															#line 12937 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			{
															#line 2653 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				std::string msg = "Maintenance mode cannot be used while data distribution is disabled for storage " "server failures.";
															#line 2655 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (!static_cast<MaintenanceCommitActorActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(Optional<std::string>(ManagementAPIError::toJsonString(false, "maintenance", msg))); this->~MaintenanceCommitActorActorState(); static_cast<MaintenanceCommitActorActor*>(this)->destroy(); return 0; }
															#line 12943 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
				new (&static_cast<MaintenanceCommitActorActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(Optional<std::string>(ManagementAPIError::toJsonString(false, "maintenance", msg)));
				this->~MaintenanceCommitActorActorState();
				static_cast<MaintenanceCommitActorActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 2656 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (seconds < 0)
															#line 12953 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
				{
															#line 2657 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					std::string msg = "The specified maintenance time " + boost::lexical_cast<std::string>(seconds) + " is a negative value";
															#line 2659 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					if (!static_cast<MaintenanceCommitActorActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(Optional<std::string>(ManagementAPIError::toJsonString(false, "maintenance", msg))); this->~MaintenanceCommitActorActorState(); static_cast<MaintenanceCommitActorActor*>(this)->destroy(); return 0; }
															#line 12959 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
					new (&static_cast<MaintenanceCommitActorActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(Optional<std::string>(ManagementAPIError::toJsonString(false, "maintenance", msg)));
					this->~MaintenanceCommitActorActorState();
					static_cast<MaintenanceCommitActorActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
				else
				{
															#line 2661 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					TraceEvent(SevDebug, "SKSMaintenanceSet").detail("ZoneId", zoneId.toString());
															#line 2662 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					ryw->getTransaction().set(healthyZoneKey, healthyZoneValue(zoneId, ryw->getTransaction().getReadVersion().get() + (seconds * CLIENT_KNOBS->CORE_VERSIONSPERSECOND)));
															#line 12971 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
				}
			}
		}
															#line 2668 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<MaintenanceCommitActorActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(Optional<std::string>()); this->~MaintenanceCommitActorActorState(); static_cast<MaintenanceCommitActorActor*>(this)->destroy(); return 0; }
															#line 12977 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		new (&static_cast<MaintenanceCommitActorActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(Optional<std::string>());
		this->~MaintenanceCommitActorActorState();
		static_cast<MaintenanceCommitActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Optional<Value> const& val,int loopDepth) 
	{
		loopDepth = a_body1cont1(val, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<Value> && val,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(val), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MaintenanceCommitActorActor*>(this)->actor_wait_state > 0) static_cast<MaintenanceCommitActorActor*>(this)->actor_wait_state = 0;
		static_cast<MaintenanceCommitActorActor*>(this)->ActorCallback< MaintenanceCommitActorActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< MaintenanceCommitActorActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("maintenanceCommitActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MaintenanceCommitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("maintenanceCommitActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MaintenanceCommitActorActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("maintenanceCommitActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MaintenanceCommitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("maintenanceCommitActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MaintenanceCommitActorActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("maintenanceCommitActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MaintenanceCommitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("maintenanceCommitActor", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 2617 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	ReadYourWritesTransaction* ryw;
															#line 2617 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	KeyRangeRef kr;
															#line 2626 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	RangeMap<Key, std::pair<bool, Optional<Value>>, KeyRangeRef>::Ranges ranges;
															#line 13066 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
};
// This generated class is to be used only via maintenanceCommitActor()
															#line 2617 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class MaintenanceCommitActorActor final : public Actor<Optional<std::string>>, public ActorCallback< MaintenanceCommitActorActor, 0, Optional<Value> >, public FastAllocated<MaintenanceCommitActorActor>, public MaintenanceCommitActorActorState<MaintenanceCommitActorActor> {
															#line 13071 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
public:
	using FastAllocated<MaintenanceCommitActorActor>::operator new;
	using FastAllocated<MaintenanceCommitActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4609427093561395200UL, 9697999785459558656UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Optional<std::string>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MaintenanceCommitActorActor, 0, Optional<Value> >;
															#line 2617 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	MaintenanceCommitActorActor(ReadYourWritesTransaction* const& ryw,KeyRangeRef const& kr) 
															#line 13088 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		 : Actor<Optional<std::string>>(),
		   MaintenanceCommitActorActorState<MaintenanceCommitActorActor>(ryw, kr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("maintenanceCommitActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10112509306944654592UL, 3774263305590945024UL);
		ActorExecutionContextHelper __helper(static_cast<MaintenanceCommitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("maintenanceCommitActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("maintenanceCommitActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MaintenanceCommitActorActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2617 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
[[nodiscard]] static Future<Optional<std::string>> maintenanceCommitActor( ReadYourWritesTransaction* const& ryw, KeyRangeRef const& kr ) {
															#line 2617 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	return Future<Optional<std::string>>(new MaintenanceCommitActorActor(ryw, kr));
															#line 13121 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
}

#line 2670 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"

Future<Optional<std::string>> MaintenanceImpl::commit(ReadYourWritesTransaction* ryw) {
	return maintenanceCommitActor(ryw, getKeyRange());
}

DataDistributionImpl::DataDistributionImpl(KeyRangeRef kr) : SpecialKeyRangeRWImpl(kr) {}

// Read the system keys dataDistributionModeKey and rebalanceDDIgnoreKey
															#line 13133 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
namespace {
// This generated class is to be used only via DataDistributionGetRangeActor()
															#line 2678 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
template <class DataDistributionGetRangeActorActor>
															#line 2678 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class DataDistributionGetRangeActorActorState {
															#line 13140 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
public:
															#line 2678 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	DataDistributionGetRangeActorActorState(ReadYourWritesTransaction* const& ryw,KeyRef const& prefix,KeyRangeRef const& kr) 
															#line 2678 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
															#line 2678 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		 : ryw(ryw),
															#line 2678 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   prefix(prefix),
															#line 2678 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   kr(kr),
															#line 2681 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   result(),
															#line 2683 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   modeKey("mode"_sr.withPrefix(prefix))
															#line 13155 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
	{
		fdb_probe_actor_create("DataDistributionGetRangeActor", reinterpret_cast<unsigned long>(this));

	}
	~DataDistributionGetRangeActorActorState() 
	{
		fdb_probe_actor_destroy("DataDistributionGetRangeActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2685 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ryw->getTransaction().setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 2687 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (kr.contains(modeKey))
															#line 13172 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			{
															#line 2688 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				auto entry = ryw->getSpecialKeySpaceWriteMap()[modeKey];
															#line 2689 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (ryw->readYourWritesDisabled() || !entry.first)
															#line 13178 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
				{
															#line 2690 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					StrictFuture<Optional<Value>> __when_expr_0 = ryw->getTransaction().get(dataDistributionModeKey);
															#line 2690 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					if (static_cast<DataDistributionGetRangeActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13184 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
					if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
					static_cast<DataDistributionGetRangeActorActor*>(this)->actor_wait_state = 1;
															#line 2690 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DataDistributionGetRangeActorActor, 0, Optional<Value> >*>(static_cast<DataDistributionGetRangeActorActor*>(this)));
															#line 13189 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
					loopDepth = 0;
				}
				else
				{
					loopDepth = a_body1cont2(loopDepth);
				}
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DataDistributionGetRangeActorActorState();
		static_cast<DataDistributionGetRangeActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2699 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		rebalanceIgnoredKey = "rebalance_ignored"_sr.withPrefix(prefix);
															#line 2700 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (kr.contains(rebalanceIgnoredKey))
															#line 13224 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		{
															#line 2701 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			auto entry = ryw->getSpecialKeySpaceWriteMap()[rebalanceIgnoredKey];
															#line 2702 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (ryw->readYourWritesDisabled() || !entry.first)
															#line 13230 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			{
															#line 2703 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				StrictFuture<Optional<Value>> __when_expr_1 = ryw->getTransaction().get(rebalanceDDIgnoreKey);
															#line 2703 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (static_cast<DataDistributionGetRangeActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13236 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
				static_cast<DataDistributionGetRangeActorActor*>(this)->actor_wait_state = 2;
															#line 2703 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DataDistributionGetRangeActorActor, 1, Optional<Value> >*>(static_cast<DataDistributionGetRangeActorActor*>(this)));
															#line 13241 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont7(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont6(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Optional<Value> const& f,int loopDepth) 
	{
															#line 2691 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		int mode = -1;
															#line 2692 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (f.present())
															#line 13268 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		{
															#line 2693 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			mode = BinaryReader::fromStringRef<int>(f.get(), Unversioned());
															#line 13272 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		}
															#line 2695 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		result.push_back_deep(result.arena(), KeyValueRef(modeKey, Value(boost::lexical_cast<std::string>(mode))));
															#line 13276 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Optional<Value> && f,int loopDepth) 
	{
															#line 2691 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		int mode = -1;
															#line 2692 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (f.present())
															#line 13287 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		{
															#line 2693 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			mode = BinaryReader::fromStringRef<int>(f.get(), Unversioned());
															#line 13291 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		}
															#line 2695 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		result.push_back_deep(result.arena(), KeyValueRef(modeKey, Value(boost::lexical_cast<std::string>(mode))));
															#line 13295 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<Value> const& f,int loopDepth) 
	{
		loopDepth = a_body1cont3(f, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<Value> && f,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(f), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DataDistributionGetRangeActorActor*>(this)->actor_wait_state > 0) static_cast<DataDistributionGetRangeActorActor*>(this)->actor_wait_state = 0;
		static_cast<DataDistributionGetRangeActorActor*>(this)->ActorCallback< DataDistributionGetRangeActorActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< DataDistributionGetRangeActorActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("DataDistributionGetRangeActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DataDistributionGetRangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("DataDistributionGetRangeActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DataDistributionGetRangeActorActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("DataDistributionGetRangeActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DataDistributionGetRangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("DataDistributionGetRangeActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DataDistributionGetRangeActorActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("DataDistributionGetRangeActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DataDistributionGetRangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("DataDistributionGetRangeActor", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont6(int loopDepth) 
	{
															#line 2709 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<DataDistributionGetRangeActorActor*>(this)->SAV<RangeResult>::futures) { (void)(rywGetRange(ryw, kr, result)); this->~DataDistributionGetRangeActorActorState(); static_cast<DataDistributionGetRangeActorActor*>(this)->destroy(); return 0; }
															#line 13379 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		new (&static_cast<DataDistributionGetRangeActorActor*>(this)->SAV< RangeResult >::value()) RangeResult(rywGetRange(ryw, kr, result));
		this->~DataDistributionGetRangeActorActorState();
		static_cast<DataDistributionGetRangeActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont7(int loopDepth) 
	{
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont8(Optional<Value> const& f,int loopDepth) 
	{
															#line 2704 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (f.present())
															#line 13397 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		{
															#line 2705 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			result.push_back_deep(result.arena(), KeyValueRef(rebalanceIgnoredKey, Value()));
															#line 13401 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		}
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont8(Optional<Value> && f,int loopDepth) 
	{
															#line 2704 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (f.present())
															#line 13411 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		{
															#line 2705 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			result.push_back_deep(result.arena(), KeyValueRef(rebalanceIgnoredKey, Value()));
															#line 13415 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		}
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Optional<Value> const& f,int loopDepth) 
	{
		loopDepth = a_body1cont8(f, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Optional<Value> && f,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(f), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DataDistributionGetRangeActorActor*>(this)->actor_wait_state > 0) static_cast<DataDistributionGetRangeActorActor*>(this)->actor_wait_state = 0;
		static_cast<DataDistributionGetRangeActorActor*>(this)->ActorCallback< DataDistributionGetRangeActorActor, 1, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< DataDistributionGetRangeActorActor, 1, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("DataDistributionGetRangeActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DataDistributionGetRangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("DataDistributionGetRangeActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DataDistributionGetRangeActorActor, 1, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("DataDistributionGetRangeActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DataDistributionGetRangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("DataDistributionGetRangeActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DataDistributionGetRangeActorActor, 1, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("DataDistributionGetRangeActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DataDistributionGetRangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("DataDistributionGetRangeActor", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 2678 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	ReadYourWritesTransaction* ryw;
															#line 2678 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	KeyRef prefix;
															#line 2678 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	KeyRangeRef kr;
															#line 2681 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	RangeResult result;
															#line 2683 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	Key modeKey;
															#line 2699 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	Key rebalanceIgnoredKey;
															#line 13508 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
};
// This generated class is to be used only via DataDistributionGetRangeActor()
															#line 2678 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class DataDistributionGetRangeActorActor final : public Actor<RangeResult>, public ActorCallback< DataDistributionGetRangeActorActor, 0, Optional<Value> >, public ActorCallback< DataDistributionGetRangeActorActor, 1, Optional<Value> >, public FastAllocated<DataDistributionGetRangeActorActor>, public DataDistributionGetRangeActorActorState<DataDistributionGetRangeActorActor> {
															#line 13513 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
public:
	using FastAllocated<DataDistributionGetRangeActorActor>::operator new;
	using FastAllocated<DataDistributionGetRangeActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12308521106159322112UL, 9545143656646864384UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<RangeResult>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DataDistributionGetRangeActorActor, 0, Optional<Value> >;
friend struct ActorCallback< DataDistributionGetRangeActorActor, 1, Optional<Value> >;
															#line 2678 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	DataDistributionGetRangeActorActor(ReadYourWritesTransaction* const& ryw,KeyRef const& prefix,KeyRangeRef const& kr) 
															#line 13531 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		 : Actor<RangeResult>(),
		   DataDistributionGetRangeActorActorState<DataDistributionGetRangeActorActor>(ryw, prefix, kr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("DataDistributionGetRangeActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2365075205275177216UL, 1751127139512214016UL);
		ActorExecutionContextHelper __helper(static_cast<DataDistributionGetRangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("DataDistributionGetRangeActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("DataDistributionGetRangeActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DataDistributionGetRangeActorActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DataDistributionGetRangeActorActor, 1, Optional<Value> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2678 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
[[nodiscard]] static Future<RangeResult> DataDistributionGetRangeActor( ReadYourWritesTransaction* const& ryw, KeyRef const& prefix, KeyRangeRef const& kr ) {
															#line 2678 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	return Future<RangeResult>(new DataDistributionGetRangeActorActor(ryw, prefix, kr));
															#line 13565 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
}

#line 2711 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"

Future<RangeResult> DataDistributionImpl::getRange(ReadYourWritesTransaction* ryw,
                                                   KeyRangeRef kr,
                                                   GetRangeLimits limitsHint) const {
	return DataDistributionGetRangeActor(ryw, getKeyRange().begin, kr);
}

Future<Optional<std::string>> DataDistributionImpl::commit(ReadYourWritesTransaction* ryw) {
	// there are two valid keys in the range
	// <prefix>/mode -> dataDistributionModeKey, the value is only allowed to be set as "0"(disable) or "1"(enable)
	// <prefix>/rebalance_ignored -> rebalanceDDIgnoreKey, value is unused thus empty
	ryw->getTransaction().setOption(FDBTransactionOptions::RAW_ACCESS);

	Optional<std::string> msg;
	KeyRangeRef kr = getKeyRange();
	Key modeKey = "mode"_sr.withPrefix(kr.begin);
	Key rebalanceIgnoredKey = "rebalance_ignored"_sr.withPrefix(kr.begin);
	auto ranges = ryw->getSpecialKeySpaceWriteMap().containedRanges(kr);
	for (auto iter = ranges.begin(); iter != ranges.end(); ++iter) {
		if (!iter->value().first)
			continue;
		if (iter->value().second.present()) {
			if (iter->range() == singleKeyRange(modeKey)) {
				try {
					int mode = boost::lexical_cast<int>(iter->value().second.get().toString());
					Value modeVal = BinaryWriter::toValue(mode, Unversioned());
					if (mode == 0 || mode == 1 || mode == 2) {
						// Whenever configuration changes or DD related system keyspace is changed,
						// actor must grab the moveKeysLockOwnerKey and update moveKeysLockWriteKey.
						// This prevents concurrent write to the same system keyspace.
						// When the owner of the DD related system keyspace changes, DD will reboot
						BinaryWriter wrMyOwner(Unversioned());
						wrMyOwner << dataDistributionModeLock;
						ryw->getTransaction().set(moveKeysLockOwnerKey, wrMyOwner.toValue());
						BinaryWriter wrLastWrite(Unversioned());
						wrLastWrite << deterministicRandom()->randomUniqueID();
						ryw->getTransaction().set(moveKeysLockWriteKey, wrLastWrite.toValue());
						// set mode
						ryw->getTransaction().set(dataDistributionModeKey, modeVal);
					} else
						msg = ManagementAPIError::toJsonString(false,
						                                       "datadistribution",
						                                       "Please set the value of the data_distribution/mode to "
						                                       "0(disable) or 1(enable), other values are not allowed");
				} catch (boost::bad_lexical_cast& e) {
					msg = ManagementAPIError::toJsonString(false,
					                                       "datadistribution",
					                                       "Invalid datadistribution mode(int): " +
					                                           iter->value().second.get().toString());
				}
			} else if (iter->range() == singleKeyRange(rebalanceIgnoredKey)) {
				ValueRef val = iter->value().second.get();
				try {
					boost::lexical_cast<int>(iter->value().second.get().toString());
				} catch (boost::bad_lexical_cast& e) {
					ManagementAPIError::toJsonString(
					    false,
					    "datadistribution",
					    "Invalid datadistribution rebalance ignore option (int or empty): " +
					        iter->value().second.get().toString());
					val = ""_sr;
				}
				ryw->getTransaction().set(rebalanceDDIgnoreKey, iter->value().second.get());
			} else {
				msg = ManagementAPIError::toJsonString(
				    false,
				    "datadistribution",
				    "Changing invalid keys, please read the documentation to check valid keys in the range");
			}
		} else {
			// clear
			if (iter->range().contains(modeKey))
				ryw->getTransaction().clear(dataDistributionModeKey);
			else if (iter->range().contains(rebalanceIgnoredKey))
				ryw->getTransaction().clear(rebalanceDDIgnoreKey);
		}
	}
	return msg;
}

// Clears the special management api keys excludeLocality and failedLocality.
void includeLocalities(ReadYourWritesTransaction* ryw) {
	ryw->setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
	ryw->setOption(FDBTransactionOptions::LOCK_AWARE);
	ryw->setOption(FDBTransactionOptions::RAW_ACCESS);
	ryw->setOption(FDBTransactionOptions::USE_PROVISIONAL_PROXIES);
	// includeLocalities might be used in an emergency transaction, so make sure it is retry-self-conflicting and
	// CAUSAL_WRITE_RISKY
	ryw->setOption(FDBTransactionOptions::CAUSAL_WRITE_RISKY);
	std::string versionKey = deterministicRandom()->randomUniqueID().toString();
	// for excluded localities
	auto ranges = ryw->getSpecialKeySpaceWriteMap().containedRanges(
	    SpecialKeySpace::getManagementApiCommandRange("excludedlocality"));
	Transaction& tr = ryw->getTransaction();
	for (auto& iter : ranges) {
		auto entry = iter.value();
		if (entry.first && !entry.second.present()) {
			tr.addReadConflictRange(singleKeyRange(excludedLocalityVersionKey));
			tr.set(excludedLocalityVersionKey, versionKey);
			tr.clear(ryw->getDatabase()->specialKeySpace->decode(iter.range()));
		}
	}
	// for failed localities
	ranges = ryw->getSpecialKeySpaceWriteMap().containedRanges(
	    SpecialKeySpace::getManagementApiCommandRange("failedlocality"));
	for (auto& iter : ranges) {
		auto entry = iter.value();
		if (entry.first && !entry.second.present()) {
			tr.addReadConflictRange(singleKeyRange(failedLocalityVersionKey));
			tr.set(failedLocalityVersionKey, versionKey);
			tr.clear(ryw->getDatabase()->specialKeySpace->decode(iter.range()));
		}
	}
}

// Reads the excludedlocality and failed locality keys using management api,
// parses them and returns the list.
bool parseLocalitiesFromKeys(ReadYourWritesTransaction* ryw,
                             bool failed,
                             std::unordered_set<std::string>& localities,
                             Optional<std::string>& msg) {
	KeyRangeRef range = failed ? SpecialKeySpace::getManagementApiCommandRange("failedlocality")
	                           : SpecialKeySpace::getManagementApiCommandRange("excludedlocality");
	auto ranges = ryw->getSpecialKeySpaceWriteMap().containedRanges(range);
	auto iter = ranges.begin();
	while (iter != ranges.end()) {
		auto entry = iter->value();
		// only check for exclude(set) operation, include(clear) are not checked
		TraceEvent(SevDebug, "ParseLocalities")
		    .detail("Valid", entry.first)
		    .detail("Set", entry.second.present())
		    .detail("Key", iter->begin().toString());
		if (entry.first && entry.second.present()) {
			Key locality = iter->begin().removePrefix(range.begin);
			if (locality.startsWith(LocalityData::ExcludeLocalityPrefix) &&
			    locality.toString().find(':') != std::string::npos) {
				localities.insert(locality.toString());
			} else {
				std::string error = "ERROR: \'" + locality.toString() + "\' is not a valid locality\n";
				msg = ManagementAPIError::toJsonString(
				    false, entry.second.present() ? (failed ? "exclude failed" : "exclude") : "include", error);
				return false;
			}
		}
		++iter;
	}
	return true;
}

// On commit, parses the special exclusion keys and get the localities to be excluded, check for exclusions
// and add them to the exclusion list. Also, clears the special management api keys with includeLocalities.
															#line 13720 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
namespace {
// This generated class is to be used only via excludeLocalityCommitActor()
															#line 2862 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
template <class ExcludeLocalityCommitActorActor>
															#line 2862 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class ExcludeLocalityCommitActorActorState {
															#line 13727 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
public:
															#line 2862 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	ExcludeLocalityCommitActorActorState(ReadYourWritesTransaction* const& ryw,bool const& failed) 
															#line 2862 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
															#line 2862 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		 : ryw(ryw),
															#line 2862 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   failed(failed),
															#line 2863 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   result(),
															#line 2864 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   localities(),
															#line 2865 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   addresses(),
															#line 2866 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   exclusions()
															#line 13744 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
	{
		fdb_probe_actor_create("excludeLocalityCommitActor", reinterpret_cast<unsigned long>(this));

	}
	~ExcludeLocalityCommitActorActorState() 
	{
		fdb_probe_actor_destroy("excludeLocalityCommitActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2868 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ryw->setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 2869 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ryw->setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 2870 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ryw->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 2876 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (!parseLocalitiesFromKeys(ryw, failed, localities, result))
															#line 13765 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			{
															#line 2877 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (!static_cast<ExcludeLocalityCommitActorActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(result); this->~ExcludeLocalityCommitActorActorState(); static_cast<ExcludeLocalityCommitActorActor*>(this)->destroy(); return 0; }
															#line 13769 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
				new (&static_cast<ExcludeLocalityCommitActorActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(std::move(result)); // state_var_RVO
				this->~ExcludeLocalityCommitActorActorState();
				static_cast<ExcludeLocalityCommitActorActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 2879 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			auto force = ryw->getSpecialKeySpaceWriteMap()[SpecialKeySpace::getManagementApiCommandOptionSpecialKey( failed ? "failed_locality" : "excluded_locality", "force")];
															#line 2882 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (localities.size() && !(force.first && force.second.present()))
															#line 13779 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			{
															#line 2883 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				StrictFuture<bool> __when_expr_0 = checkExclusion(ryw->getDatabase(), addresses, exclusions, localities, failed, &result);
															#line 2883 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (static_cast<ExcludeLocalityCommitActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13785 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<ExcludeLocalityCommitActorActor*>(this)->actor_wait_state = 1;
															#line 2883 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ExcludeLocalityCommitActorActor, 0, bool >*>(static_cast<ExcludeLocalityCommitActorActor*>(this)));
															#line 13790 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ExcludeLocalityCommitActorActorState();
		static_cast<ExcludeLocalityCommitActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2888 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		StrictFuture<Void> __when_expr_1 = excludeLocalities(&ryw->getTransaction(), localities, failed);
															#line 2888 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (static_cast<ExcludeLocalityCommitActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13820 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ExcludeLocalityCommitActorActor*>(this)->actor_wait_state = 2;
															#line 2888 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ExcludeLocalityCommitActorActor, 1, Void >*>(static_cast<ExcludeLocalityCommitActorActor*>(this)));
															#line 13825 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(bool const& safe,int loopDepth) 
	{
															#line 2884 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!safe)
															#line 13834 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		{
															#line 2885 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (!static_cast<ExcludeLocalityCommitActorActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(result); this->~ExcludeLocalityCommitActorActorState(); static_cast<ExcludeLocalityCommitActorActor*>(this)->destroy(); return 0; }
															#line 13838 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			new (&static_cast<ExcludeLocalityCommitActorActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(std::move(result)); // state_var_RVO
			this->~ExcludeLocalityCommitActorActorState();
			static_cast<ExcludeLocalityCommitActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(bool && safe,int loopDepth) 
	{
															#line 2884 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!safe)
															#line 13852 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		{
															#line 2885 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (!static_cast<ExcludeLocalityCommitActorActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(result); this->~ExcludeLocalityCommitActorActorState(); static_cast<ExcludeLocalityCommitActorActor*>(this)->destroy(); return 0; }
															#line 13856 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			new (&static_cast<ExcludeLocalityCommitActorActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(std::move(result)); // state_var_RVO
			this->~ExcludeLocalityCommitActorActorState();
			static_cast<ExcludeLocalityCommitActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(bool const& safe,int loopDepth) 
	{
		loopDepth = a_body1cont3(safe, loopDepth);

		return loopDepth;
	}
	int a_body1when1(bool && safe,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(safe), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ExcludeLocalityCommitActorActor*>(this)->actor_wait_state > 0) static_cast<ExcludeLocalityCommitActorActor*>(this)->actor_wait_state = 0;
		static_cast<ExcludeLocalityCommitActorActor*>(this)->ActorCallback< ExcludeLocalityCommitActorActor, 0, bool >::remove();

	}
	void a_callback_fire(ActorCallback< ExcludeLocalityCommitActorActor, 0, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("excludeLocalityCommitActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExcludeLocalityCommitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("excludeLocalityCommitActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ExcludeLocalityCommitActorActor, 0, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("excludeLocalityCommitActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExcludeLocalityCommitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("excludeLocalityCommitActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ExcludeLocalityCommitActorActor, 0, bool >*,Error err) 
	{
		fdb_probe_actor_enter("excludeLocalityCommitActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ExcludeLocalityCommitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("excludeLocalityCommitActor", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 2889 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		includeLocalities(ryw);
															#line 2891 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<ExcludeLocalityCommitActorActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(result); this->~ExcludeLocalityCommitActorActorState(); static_cast<ExcludeLocalityCommitActorActor*>(this)->destroy(); return 0; }
															#line 13947 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		new (&static_cast<ExcludeLocalityCommitActorActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(std::move(result)); // state_var_RVO
		this->~ExcludeLocalityCommitActorActorState();
		static_cast<ExcludeLocalityCommitActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 2889 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		includeLocalities(ryw);
															#line 2891 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<ExcludeLocalityCommitActorActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(result); this->~ExcludeLocalityCommitActorActorState(); static_cast<ExcludeLocalityCommitActorActor*>(this)->destroy(); return 0; }
															#line 13961 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		new (&static_cast<ExcludeLocalityCommitActorActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(std::move(result)); // state_var_RVO
		this->~ExcludeLocalityCommitActorActorState();
		static_cast<ExcludeLocalityCommitActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ExcludeLocalityCommitActorActor*>(this)->actor_wait_state > 0) static_cast<ExcludeLocalityCommitActorActor*>(this)->actor_wait_state = 0;
		static_cast<ExcludeLocalityCommitActorActor*>(this)->ActorCallback< ExcludeLocalityCommitActorActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ExcludeLocalityCommitActorActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("excludeLocalityCommitActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExcludeLocalityCommitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("excludeLocalityCommitActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ExcludeLocalityCommitActorActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("excludeLocalityCommitActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExcludeLocalityCommitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("excludeLocalityCommitActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ExcludeLocalityCommitActorActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("excludeLocalityCommitActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ExcludeLocalityCommitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("excludeLocalityCommitActor", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 2862 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	ReadYourWritesTransaction* ryw;
															#line 2862 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	bool failed;
															#line 2863 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	Optional<std::string> result;
															#line 2864 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	std::unordered_set<std::string> localities;
															#line 2865 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	std::vector<AddressExclusion> addresses;
															#line 2866 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	std::set<AddressExclusion> exclusions;
															#line 14056 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
};
// This generated class is to be used only via excludeLocalityCommitActor()
															#line 2862 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class ExcludeLocalityCommitActorActor final : public Actor<Optional<std::string>>, public ActorCallback< ExcludeLocalityCommitActorActor, 0, bool >, public ActorCallback< ExcludeLocalityCommitActorActor, 1, Void >, public FastAllocated<ExcludeLocalityCommitActorActor>, public ExcludeLocalityCommitActorActorState<ExcludeLocalityCommitActorActor> {
															#line 14061 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
public:
	using FastAllocated<ExcludeLocalityCommitActorActor>::operator new;
	using FastAllocated<ExcludeLocalityCommitActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2031683088501076736UL, 4100000487269146368UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Optional<std::string>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ExcludeLocalityCommitActorActor, 0, bool >;
friend struct ActorCallback< ExcludeLocalityCommitActorActor, 1, Void >;
															#line 2862 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	ExcludeLocalityCommitActorActor(ReadYourWritesTransaction* const& ryw,bool const& failed) 
															#line 14079 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		 : Actor<Optional<std::string>>(),
		   ExcludeLocalityCommitActorActorState<ExcludeLocalityCommitActorActor>(ryw, failed),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("excludeLocalityCommitActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11551239430571558400UL, 17348860154491991296UL);
		ActorExecutionContextHelper __helper(static_cast<ExcludeLocalityCommitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("excludeLocalityCommitActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("excludeLocalityCommitActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ExcludeLocalityCommitActorActor, 0, bool >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ExcludeLocalityCommitActorActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2862 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
[[nodiscard]] Future<Optional<std::string>> excludeLocalityCommitActor( ReadYourWritesTransaction* const& ryw, bool const& failed ) {
															#line 2862 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	return Future<Optional<std::string>>(new ExcludeLocalityCommitActorActor(ryw, failed));
															#line 14113 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
}

#line 2893 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"

ExcludedLocalitiesRangeImpl::ExcludedLocalitiesRangeImpl(KeyRangeRef kr) : SpecialKeyRangeRWImpl(kr) {}

Future<RangeResult> ExcludedLocalitiesRangeImpl::getRange(ReadYourWritesTransaction* ryw,
                                                          KeyRangeRef kr,
                                                          GetRangeLimits limitsHint) const {
	ryw->setOption(FDBTransactionOptions::RAW_ACCESS);
	return rwModuleWithMappingGetRangeActor(ryw, this, kr);
}

void ExcludedLocalitiesRangeImpl::set(ReadYourWritesTransaction* ryw, const KeyRef& key, const ValueRef& value) {
	// ignore value
	ryw->getSpecialKeySpaceWriteMap().insert(key, std::make_pair(true, Optional<Value>(ValueRef())));
}

Key ExcludedLocalitiesRangeImpl::decode(const KeyRef& key) const {
	return key.removePrefix(SpecialKeySpace::getModuleRange(SpecialKeySpace::MODULE::MANAGEMENT).begin)
	    .withPrefix("\xff/conf/"_sr);
}

Key ExcludedLocalitiesRangeImpl::encode(const KeyRef& key) const {
	return key.removePrefix("\xff/conf/"_sr)
	    .withPrefix(SpecialKeySpace::getModuleRange(SpecialKeySpace::MODULE::MANAGEMENT).begin);
}

Future<Optional<std::string>> ExcludedLocalitiesRangeImpl::commit(ReadYourWritesTransaction* ryw) {
	// exclude locality with failed option as false.
	return excludeLocalityCommitActor(ryw, false);
}

FailedLocalitiesRangeImpl::FailedLocalitiesRangeImpl(KeyRangeRef kr) : SpecialKeyRangeRWImpl(kr) {}

Future<RangeResult> FailedLocalitiesRangeImpl::getRange(ReadYourWritesTransaction* ryw,
                                                        KeyRangeRef kr,
                                                        GetRangeLimits limitsHint) const {
	ryw->setOption(FDBTransactionOptions::RAW_ACCESS);
	return rwModuleWithMappingGetRangeActor(ryw, this, kr);
}

void FailedLocalitiesRangeImpl::set(ReadYourWritesTransaction* ryw, const KeyRef& key, const ValueRef& value) {
	// ignore value
	ryw->getSpecialKeySpaceWriteMap().insert(key, std::make_pair(true, Optional<Value>(ValueRef())));
}

Key FailedLocalitiesRangeImpl::decode(const KeyRef& key) const {
	return key.removePrefix(SpecialKeySpace::getModuleRange(SpecialKeySpace::MODULE::MANAGEMENT).begin)
	    .withPrefix("\xff/conf/"_sr);
}

Key FailedLocalitiesRangeImpl::encode(const KeyRef& key) const {
	return key.removePrefix("\xff/conf/"_sr)
	    .withPrefix(SpecialKeySpace::getModuleRange(SpecialKeySpace::MODULE::MANAGEMENT).begin);
}

Future<Optional<std::string>> FailedLocalitiesRangeImpl::commit(ReadYourWritesTransaction* ryw) {
	// exclude locality with failed option as true.
	return excludeLocalityCommitActor(ryw, true);
}

// Defined in ReadYourWrites.actor.cpp
															#line 14177 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
[[nodiscard]] Future<RangeResult> getWorkerInterfaces( Reference<IClusterConnectionRecord> const& clusterRecord );

#line 2954 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
// Defined in NativeAPI.actor.cpp
															#line 14182 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
[[nodiscard]] Future<bool> verifyInterfaceActor( Reference<FlowLock> const& connectLock, ClientWorkerInterface const& workerInterf );

#line 2956 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"

															#line 14187 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
namespace {
// This generated class is to be used only via workerInterfacesImplGetRangeActor()
															#line 2957 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
template <class WorkerInterfacesImplGetRangeActorActor>
															#line 2957 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class WorkerInterfacesImplGetRangeActorActorState {
															#line 14194 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
public:
															#line 2957 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	WorkerInterfacesImplGetRangeActorActorState(ReadYourWritesTransaction* const& ryw,KeyRef const& prefix,KeyRangeRef const& kr) 
															#line 2957 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
															#line 2957 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		 : ryw(ryw),
															#line 2957 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   prefix(prefix),
															#line 2957 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   kr(kr)
															#line 14205 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
	{
		fdb_probe_actor_create("workerInterfacesImplGetRangeActor", reinterpret_cast<unsigned long>(this));

	}
	~WorkerInterfacesImplGetRangeActorActorState() 
	{
		fdb_probe_actor_destroy("workerInterfacesImplGetRangeActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2960 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (!ryw->getDatabase().getPtr() || !ryw->getDatabase()->getConnectionRecord())
															#line 14220 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			{
															#line 2961 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (!static_cast<WorkerInterfacesImplGetRangeActorActor*>(this)->SAV<RangeResult>::futures) { (void)(RangeResult()); this->~WorkerInterfacesImplGetRangeActorActorState(); static_cast<WorkerInterfacesImplGetRangeActorActor*>(this)->destroy(); return 0; }
															#line 14224 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
				new (&static_cast<WorkerInterfacesImplGetRangeActorActor*>(this)->SAV< RangeResult >::value()) RangeResult(RangeResult());
				this->~WorkerInterfacesImplGetRangeActorActorState();
				static_cast<WorkerInterfacesImplGetRangeActorActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 2963 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = getWorkerInterfaces(ryw->getDatabase()->getConnectionRecord());
															#line 2963 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (static_cast<WorkerInterfacesImplGetRangeActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14234 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<WorkerInterfacesImplGetRangeActorActor*>(this)->actor_wait_state = 1;
															#line 2963 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WorkerInterfacesImplGetRangeActorActor, 0, RangeResult >*>(static_cast<WorkerInterfacesImplGetRangeActorActor*>(this)));
															#line 14239 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WorkerInterfacesImplGetRangeActorActorState();
		static_cast<WorkerInterfacesImplGetRangeActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2965 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		auto [verify, _] = ryw->getSpecialKeySpaceWriteMap()[SpecialKeySpace::getManagementApiCommandOptionSpecialKey( "worker_interfaces", "verify")];
															#line 2967 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		result = RangeResult();
															#line 2968 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (verify)
															#line 14266 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		{
															#line 2970 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			Reference<FlowLock> connectLock(new FlowLock(CLIENT_KNOBS->CLI_CONNECT_PARALLELISM));
															#line 2971 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			verifyInterfs = std::vector<Future<bool>>();
															#line 2972 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			for( const auto& [k_, value] : interfs ) {
															#line 2973 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				auto k = k_.withPrefix(prefix);
															#line 2974 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (kr.contains(k))
															#line 14278 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
				{
															#line 2975 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					ClientWorkerInterface workerInterf = BinaryReader::fromStringRef<ClientWorkerInterface>(value, IncludeVersion());
															#line 2977 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					verifyInterfs.push_back(verifyInterfaceActor(connectLock, workerInterf));
															#line 14284 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
				}
				else
				{
															#line 2979 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					verifyInterfs.push_back(false);
															#line 14290 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
				}
			}
															#line 2982 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			StrictFuture<Void> __when_expr_1 = waitForAll(verifyInterfs);
															#line 2982 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (static_cast<WorkerInterfacesImplGetRangeActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14297 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<WorkerInterfacesImplGetRangeActorActor*>(this)->actor_wait_state = 2;
															#line 2982 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WorkerInterfacesImplGetRangeActorActor, 1, Void >*>(static_cast<WorkerInterfacesImplGetRangeActorActor*>(this)));
															#line 14302 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 2992 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			for( const auto& [k_, v] : interfs ) {
															#line 2993 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				auto k = k_.withPrefix(prefix);
															#line 2994 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (kr.contains(k))
															#line 14313 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
				{
															#line 2995 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					result.push_back_deep(result.arena(), KeyValueRef(k, v));
															#line 14317 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
				}
			}
			loopDepth = a_body1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(RangeResult const& __interfs,int loopDepth) 
	{
															#line 2963 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		interfs = __interfs;
															#line 14329 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(RangeResult && __interfs,int loopDepth) 
	{
		interfs = std::move(__interfs);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WorkerInterfacesImplGetRangeActorActor*>(this)->actor_wait_state > 0) static_cast<WorkerInterfacesImplGetRangeActorActor*>(this)->actor_wait_state = 0;
		static_cast<WorkerInterfacesImplGetRangeActorActor*>(this)->ActorCallback< WorkerInterfacesImplGetRangeActorActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< WorkerInterfacesImplGetRangeActorActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("workerInterfacesImplGetRangeActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerInterfacesImplGetRangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerInterfacesImplGetRangeActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WorkerInterfacesImplGetRangeActorActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("workerInterfacesImplGetRangeActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerInterfacesImplGetRangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerInterfacesImplGetRangeActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WorkerInterfacesImplGetRangeActorActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("workerInterfacesImplGetRangeActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerInterfacesImplGetRangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerInterfacesImplGetRangeActor", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 2998 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		std::sort(result.begin(), result.end(), KeyValueRef::OrderByKey{});
															#line 2999 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<WorkerInterfacesImplGetRangeActorActor*>(this)->SAV<RangeResult>::futures) { (void)(result); this->~WorkerInterfacesImplGetRangeActorActorState(); static_cast<WorkerInterfacesImplGetRangeActorActor*>(this)->destroy(); return 0; }
															#line 14410 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		new (&static_cast<WorkerInterfacesImplGetRangeActorActor*>(this)->SAV< RangeResult >::value()) RangeResult(std::move(result)); // state_var_RVO
		this->~WorkerInterfacesImplGetRangeActorActorState();
		static_cast<WorkerInterfacesImplGetRangeActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 2984 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		for(int index = 0;index < interfs.size();index++) {
															#line 2985 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (verifyInterfs[index].get())
															#line 14424 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			{
															#line 2987 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				result.push_back_deep(result.arena(), KeyValueRef(interfs[index].key.withPrefix(prefix), interfs[index].value));
															#line 14428 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			}
		}
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 2984 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		for(int index = 0;index < interfs.size();index++) {
															#line 2985 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (verifyInterfs[index].get())
															#line 14441 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			{
															#line 2987 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				result.push_back_deep(result.arena(), KeyValueRef(interfs[index].key.withPrefix(prefix), interfs[index].value));
															#line 14445 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			}
		}
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WorkerInterfacesImplGetRangeActorActor*>(this)->actor_wait_state > 0) static_cast<WorkerInterfacesImplGetRangeActorActor*>(this)->actor_wait_state = 0;
		static_cast<WorkerInterfacesImplGetRangeActorActor*>(this)->ActorCallback< WorkerInterfacesImplGetRangeActorActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WorkerInterfacesImplGetRangeActorActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("workerInterfacesImplGetRangeActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerInterfacesImplGetRangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerInterfacesImplGetRangeActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WorkerInterfacesImplGetRangeActorActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("workerInterfacesImplGetRangeActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerInterfacesImplGetRangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerInterfacesImplGetRangeActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WorkerInterfacesImplGetRangeActorActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("workerInterfacesImplGetRangeActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerInterfacesImplGetRangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerInterfacesImplGetRangeActor", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 2957 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	ReadYourWritesTransaction* ryw;
															#line 2957 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	KeyRef prefix;
															#line 2957 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	KeyRangeRef kr;
															#line 2963 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	RangeResult interfs;
															#line 2967 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	RangeResult result;
															#line 2971 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	std::vector<Future<bool>> verifyInterfs;
															#line 14539 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
};
// This generated class is to be used only via workerInterfacesImplGetRangeActor()
															#line 2957 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class WorkerInterfacesImplGetRangeActorActor final : public Actor<RangeResult>, public ActorCallback< WorkerInterfacesImplGetRangeActorActor, 0, RangeResult >, public ActorCallback< WorkerInterfacesImplGetRangeActorActor, 1, Void >, public FastAllocated<WorkerInterfacesImplGetRangeActorActor>, public WorkerInterfacesImplGetRangeActorActorState<WorkerInterfacesImplGetRangeActorActor> {
															#line 14544 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
public:
	using FastAllocated<WorkerInterfacesImplGetRangeActorActor>::operator new;
	using FastAllocated<WorkerInterfacesImplGetRangeActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11080308452906549504UL, 12907078918821261056UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<RangeResult>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WorkerInterfacesImplGetRangeActorActor, 0, RangeResult >;
friend struct ActorCallback< WorkerInterfacesImplGetRangeActorActor, 1, Void >;
															#line 2957 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	WorkerInterfacesImplGetRangeActorActor(ReadYourWritesTransaction* const& ryw,KeyRef const& prefix,KeyRangeRef const& kr) 
															#line 14562 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		 : Actor<RangeResult>(),
		   WorkerInterfacesImplGetRangeActorActorState<WorkerInterfacesImplGetRangeActorActor>(ryw, prefix, kr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("workerInterfacesImplGetRangeActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9308834139300597760UL, 12982850668395028224UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerInterfacesImplGetRangeActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("workerInterfacesImplGetRangeActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("workerInterfacesImplGetRangeActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WorkerInterfacesImplGetRangeActorActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WorkerInterfacesImplGetRangeActorActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2957 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
[[nodiscard]] static Future<RangeResult> workerInterfacesImplGetRangeActor( ReadYourWritesTransaction* const& ryw, KeyRef const& prefix, KeyRangeRef const& kr ) {
															#line 2957 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	return Future<RangeResult>(new WorkerInterfacesImplGetRangeActorActor(ryw, prefix, kr));
															#line 14596 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
}

#line 3001 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"

WorkerInterfacesSpecialKeyImpl::WorkerInterfacesSpecialKeyImpl(KeyRangeRef kr) : SpecialKeyRangeReadImpl(kr) {}

Future<RangeResult> WorkerInterfacesSpecialKeyImpl::getRange(ReadYourWritesTransaction* ryw,
                                                             KeyRangeRef kr,
                                                             GetRangeLimits limitsHint) const {
	return workerInterfacesImplGetRangeActor(ryw, getKeyRange().begin, kr);
}

															#line 14609 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
[[nodiscard]] Future<Optional<Value>> getJSON( Database const& db, std::string const& jsonField = "" );

#line 3011 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"

															#line 14614 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
namespace {
// This generated class is to be used only via FaultToleranceMetricsImplActor()
															#line 3012 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
template <class FaultToleranceMetricsImplActorActor>
															#line 3012 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class FaultToleranceMetricsImplActorActorState {
															#line 14621 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
public:
															#line 3012 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	FaultToleranceMetricsImplActorActorState(ReadYourWritesTransaction* const& ryw,KeyRangeRef const& kr) 
															#line 3012 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
															#line 3012 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		 : ryw(ryw),
															#line 3012 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   kr(kr),
															#line 3013 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   res()
															#line 14632 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
	{
		fdb_probe_actor_create("FaultToleranceMetricsImplActor", reinterpret_cast<unsigned long>(this));

	}
	~FaultToleranceMetricsImplActorActorState() 
	{
		fdb_probe_actor_destroy("FaultToleranceMetricsImplActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 3014 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (ryw->getDatabase().getPtr() && ryw->getDatabase()->getConnectionRecord())
															#line 14647 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			{
															#line 3015 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				StrictFuture<Optional<Value>> __when_expr_0 = getJSON(ryw->getDatabase(), "fault_tolerance");
															#line 3015 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (static_cast<FaultToleranceMetricsImplActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14653 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<FaultToleranceMetricsImplActorActor*>(this)->actor_wait_state = 1;
															#line 3015 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FaultToleranceMetricsImplActorActor, 0, Optional<Value> >*>(static_cast<FaultToleranceMetricsImplActorActor*>(this)));
															#line 14658 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FaultToleranceMetricsImplActorActorState();
		static_cast<FaultToleranceMetricsImplActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 3020 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<FaultToleranceMetricsImplActorActor*>(this)->SAV<RangeResult>::futures) { (void)(res); this->~FaultToleranceMetricsImplActorActorState(); static_cast<FaultToleranceMetricsImplActorActor*>(this)->destroy(); return 0; }
															#line 14686 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		new (&static_cast<FaultToleranceMetricsImplActorActor*>(this)->SAV< RangeResult >::value()) RangeResult(std::move(res)); // state_var_RVO
		this->~FaultToleranceMetricsImplActorActorState();
		static_cast<FaultToleranceMetricsImplActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Optional<Value> const& val,int loopDepth) 
	{
															#line 3016 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (val.present())
															#line 14698 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		{
															#line 3017 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			res.push_back_deep(res.arena(), KeyValueRef(kr.begin, val.get()));
															#line 14702 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		}
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Optional<Value> && val,int loopDepth) 
	{
															#line 3016 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (val.present())
															#line 14712 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		{
															#line 3017 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			res.push_back_deep(res.arena(), KeyValueRef(kr.begin, val.get()));
															#line 14716 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		}
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<Value> const& val,int loopDepth) 
	{
		loopDepth = a_body1cont2(val, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<Value> && val,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(val), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FaultToleranceMetricsImplActorActor*>(this)->actor_wait_state > 0) static_cast<FaultToleranceMetricsImplActorActor*>(this)->actor_wait_state = 0;
		static_cast<FaultToleranceMetricsImplActorActor*>(this)->ActorCallback< FaultToleranceMetricsImplActorActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< FaultToleranceMetricsImplActorActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("FaultToleranceMetricsImplActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FaultToleranceMetricsImplActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("FaultToleranceMetricsImplActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FaultToleranceMetricsImplActorActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("FaultToleranceMetricsImplActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FaultToleranceMetricsImplActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("FaultToleranceMetricsImplActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FaultToleranceMetricsImplActorActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("FaultToleranceMetricsImplActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FaultToleranceMetricsImplActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("FaultToleranceMetricsImplActor", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 3012 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	ReadYourWritesTransaction* ryw;
															#line 3012 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	KeyRangeRef kr;
															#line 3013 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	RangeResult res;
															#line 14803 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
};
// This generated class is to be used only via FaultToleranceMetricsImplActor()
															#line 3012 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class FaultToleranceMetricsImplActorActor final : public Actor<RangeResult>, public ActorCallback< FaultToleranceMetricsImplActorActor, 0, Optional<Value> >, public FastAllocated<FaultToleranceMetricsImplActorActor>, public FaultToleranceMetricsImplActorActorState<FaultToleranceMetricsImplActorActor> {
															#line 14808 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
public:
	using FastAllocated<FaultToleranceMetricsImplActorActor>::operator new;
	using FastAllocated<FaultToleranceMetricsImplActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10266966278137265920UL, 6015778611810953216UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<RangeResult>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FaultToleranceMetricsImplActorActor, 0, Optional<Value> >;
															#line 3012 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	FaultToleranceMetricsImplActorActor(ReadYourWritesTransaction* const& ryw,KeyRangeRef const& kr) 
															#line 14825 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		 : Actor<RangeResult>(),
		   FaultToleranceMetricsImplActorActorState<FaultToleranceMetricsImplActorActor>(ryw, kr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("FaultToleranceMetricsImplActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16663529165361424896UL, 2276141065095804672UL);
		ActorExecutionContextHelper __helper(static_cast<FaultToleranceMetricsImplActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("FaultToleranceMetricsImplActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("FaultToleranceMetricsImplActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FaultToleranceMetricsImplActorActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 3012 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
[[nodiscard]] static Future<RangeResult> FaultToleranceMetricsImplActor( ReadYourWritesTransaction* const& ryw, KeyRangeRef const& kr ) {
															#line 3012 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	return Future<RangeResult>(new FaultToleranceMetricsImplActorActor(ryw, kr));
															#line 14858 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
}

#line 3022 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"

FaultToleranceMetricsImpl::FaultToleranceMetricsImpl(KeyRangeRef kr) : SpecialKeyRangeReadImpl(kr) {}

Future<RangeResult> FaultToleranceMetricsImpl::getRange(ReadYourWritesTransaction* ryw,
                                                        KeyRangeRef kr,
                                                        GetRangeLimits limitsHint) const {
	// single key range, the queried range should always be the same as the underlying range
	ASSERT(kr == getKeyRange());
	return FaultToleranceMetricsImplActor(ryw, kr);
}

															#line 14873 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
namespace {
// This generated class is to be used only via validateSpecialSubrangeRead()
															#line 3033 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
template <class ValidateSpecialSubrangeReadActor>
															#line 3033 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class ValidateSpecialSubrangeReadActorState {
															#line 14880 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
public:
															#line 3033 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	ValidateSpecialSubrangeReadActorState(ReadYourWritesTransaction* const& ryw,KeySelector const& begin,KeySelector const& end,GetRangeLimits const& limits,Reverse const& reverse,RangeResult const& result) 
															#line 3033 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
															#line 3033 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		 : ryw(ryw),
															#line 3033 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   begin(begin),
															#line 3033 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   end(end),
															#line 3033 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   limits(limits),
															#line 3033 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   reverse(reverse),
															#line 3033 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		   result(result)
															#line 14897 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
	{
		fdb_probe_actor_create("validateSpecialSubrangeRead", reinterpret_cast<unsigned long>(this));

	}
	~ValidateSpecialSubrangeReadActorState() 
	{
		fdb_probe_actor_destroy("validateSpecialSubrangeRead", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 3039 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (!result.size())
															#line 14912 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			{
															#line 3040 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				StrictFuture<RangeResult> __when_expr_0 = ryw->getRange(begin, end, limits, Snapshot::True, reverse);
															#line 3040 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (static_cast<ValidateSpecialSubrangeReadActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14918 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<ValidateSpecialSubrangeReadActor*>(this)->actor_wait_state = 1;
															#line 3040 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ValidateSpecialSubrangeReadActor, 0, RangeResult >*>(static_cast<ValidateSpecialSubrangeReadActor*>(this)));
															#line 14923 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ValidateSpecialSubrangeReadActorState();
		static_cast<ValidateSpecialSubrangeReadActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 3045 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (reverse)
															#line 14951 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		{
															#line 3046 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ASSERT(std::is_sorted(result.begin(), result.end(), KeyValueRef::OrderByKeyBack{}));
															#line 14955 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		}
		else
		{
															#line 3048 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ASSERT(std::is_sorted(result.begin(), result.end(), KeyValueRef::OrderByKey{}));
															#line 14961 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		}
															#line 3053 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		std::vector<Key> candidateKeys;
															#line 3054 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (reverse)
															#line 14967 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		{
															#line 3055 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			for(int i = result.size() - 1;i >= 0;--i) {
															#line 3056 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				candidateKeys.emplace_back(result[i].key);
															#line 3057 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (i - 1 >= 0)
															#line 14975 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
				{
															#line 3058 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					candidateKeys.emplace_back(keyBetween(KeyRangeRef(result[i].key, result[i - 1].key)));
															#line 14979 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
				}
			}
		}
		else
		{
															#line 3062 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			for(int i = 0;i < result.size();++i) {
															#line 3063 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				candidateKeys.emplace_back(result[i].key);
															#line 3064 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				if (i + 1 < result.size())
															#line 14991 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
				{
															#line 3065 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
					candidateKeys.emplace_back(keyBetween(KeyRangeRef(result[i].key, result[i + 1].key)));
															#line 14995 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
				}
			}
		}
															#line 3069 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		std::sort(candidateKeys.begin(), candidateKeys.end());
															#line 3070 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		int originalSize = candidateKeys.size();
															#line 3072 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		for(int i = 0;i < originalSize - 1;++i) {
															#line 3073 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			candidateKeys.emplace_back(keyBetween(KeyRangeRef(candidateKeys[i], candidateKeys[i + 1])));
															#line 15007 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		}
															#line 3075 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		std::vector<Key> keys;
															#line 3076 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		keys = { deterministicRandom()->randomChoice(candidateKeys), deterministicRandom()->randomChoice(candidateKeys) };
															#line 3077 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		std::sort(keys.begin(), keys.end());
															#line 3078 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		testBegin = firstGreaterOrEqual(keys[0]);
															#line 3079 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		testEnd = firstGreaterOrEqual(keys[1]);
															#line 3083 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		expectedResult = RangeResult();
															#line 3086 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		for( const auto& kr : result ) {
															#line 3087 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			if (kr.key >= keys[0] && kr.key < keys[1])
															#line 15025 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			{
															#line 3088 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				expectedResult.push_back(expectedResult.arena(), kr);
															#line 15029 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			}
		}
															#line 3093 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		StrictFuture<RangeResult> __when_expr_1 = ryw->getRange(testBegin, testEnd, limits, Snapshot::True, reverse);
															#line 3093 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (static_cast<ValidateSpecialSubrangeReadActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15036 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ValidateSpecialSubrangeReadActor*>(this)->actor_wait_state = 2;
															#line 3093 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ValidateSpecialSubrangeReadActor, 1, RangeResult >*>(static_cast<ValidateSpecialSubrangeReadActor*>(this)));
															#line 15041 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(RangeResult const& testResult,int loopDepth) 
	{
															#line 3041 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		ASSERT(testResult == result);
															#line 3042 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<ValidateSpecialSubrangeReadActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ValidateSpecialSubrangeReadActorState(); static_cast<ValidateSpecialSubrangeReadActor*>(this)->destroy(); return 0; }
															#line 15052 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		new (&static_cast<ValidateSpecialSubrangeReadActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ValidateSpecialSubrangeReadActorState();
		static_cast<ValidateSpecialSubrangeReadActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(RangeResult && testResult,int loopDepth) 
	{
															#line 3041 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		ASSERT(testResult == result);
															#line 3042 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<ValidateSpecialSubrangeReadActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ValidateSpecialSubrangeReadActorState(); static_cast<ValidateSpecialSubrangeReadActor*>(this)->destroy(); return 0; }
															#line 15066 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		new (&static_cast<ValidateSpecialSubrangeReadActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ValidateSpecialSubrangeReadActorState();
		static_cast<ValidateSpecialSubrangeReadActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(RangeResult const& testResult,int loopDepth) 
	{
		loopDepth = a_body1cont2(testResult, loopDepth);

		return loopDepth;
	}
	int a_body1when1(RangeResult && testResult,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(testResult), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ValidateSpecialSubrangeReadActor*>(this)->actor_wait_state > 0) static_cast<ValidateSpecialSubrangeReadActor*>(this)->actor_wait_state = 0;
		static_cast<ValidateSpecialSubrangeReadActor*>(this)->ActorCallback< ValidateSpecialSubrangeReadActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< ValidateSpecialSubrangeReadActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("validateSpecialSubrangeRead", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateSpecialSubrangeReadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateSpecialSubrangeRead", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ValidateSpecialSubrangeReadActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("validateSpecialSubrangeRead", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateSpecialSubrangeReadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateSpecialSubrangeRead", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ValidateSpecialSubrangeReadActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("validateSpecialSubrangeRead", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateSpecialSubrangeReadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateSpecialSubrangeRead", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(RangeResult const& testResult,int loopDepth) 
	{
															#line 3094 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (testResult != expectedResult)
															#line 15153 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		{
															#line 3095 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			fmt::print("Reverse: {}\n", static_cast<bool>(reverse));
															#line 3096 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			fmt::print("Original range: [{}, {})\n", begin.toString(), end.toString());
															#line 3097 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			fmt::print("Original result:\n");
															#line 3098 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			for( const auto& kr : result ) {
															#line 3099 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				fmt::print("	{} -> {}\n", kr.key.printable(), kr.value.printable());
															#line 15165 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			}
															#line 3101 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			fmt::print("Test range: [{}, {})\n", testBegin.getKey().printable(), testEnd.getKey().printable());
															#line 3102 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			fmt::print("Expected:\n");
															#line 3103 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			for( const auto& kr : expectedResult ) {
															#line 3104 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				fmt::print("	{} -> {}\n", kr.key.printable(), kr.value.printable());
															#line 15175 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			}
															#line 3106 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			fmt::print("Got:\n");
															#line 3107 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			for( const auto& kr : testResult ) {
															#line 3108 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				fmt::print("	{} -> {}\n", kr.key.printable(), kr.value.printable());
															#line 15183 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			}
															#line 3110 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ASSERT(testResult == expectedResult);
															#line 15187 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		}
															#line 3112 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<ValidateSpecialSubrangeReadActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ValidateSpecialSubrangeReadActorState(); static_cast<ValidateSpecialSubrangeReadActor*>(this)->destroy(); return 0; }
															#line 15191 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		new (&static_cast<ValidateSpecialSubrangeReadActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ValidateSpecialSubrangeReadActorState();
		static_cast<ValidateSpecialSubrangeReadActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4(RangeResult && testResult,int loopDepth) 
	{
															#line 3094 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (testResult != expectedResult)
															#line 15203 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		{
															#line 3095 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			fmt::print("Reverse: {}\n", static_cast<bool>(reverse));
															#line 3096 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			fmt::print("Original range: [{}, {})\n", begin.toString(), end.toString());
															#line 3097 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			fmt::print("Original result:\n");
															#line 3098 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			for( const auto& kr : result ) {
															#line 3099 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				fmt::print("	{} -> {}\n", kr.key.printable(), kr.value.printable());
															#line 15215 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			}
															#line 3101 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			fmt::print("Test range: [{}, {})\n", testBegin.getKey().printable(), testEnd.getKey().printable());
															#line 3102 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			fmt::print("Expected:\n");
															#line 3103 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			for( const auto& kr : expectedResult ) {
															#line 3104 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				fmt::print("	{} -> {}\n", kr.key.printable(), kr.value.printable());
															#line 15225 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			}
															#line 3106 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			fmt::print("Got:\n");
															#line 3107 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			for( const auto& kr : testResult ) {
															#line 3108 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
				fmt::print("	{} -> {}\n", kr.key.printable(), kr.value.printable());
															#line 15233 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
			}
															#line 3110 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
			ASSERT(testResult == expectedResult);
															#line 15237 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		}
															#line 3112 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
		if (!static_cast<ValidateSpecialSubrangeReadActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ValidateSpecialSubrangeReadActorState(); static_cast<ValidateSpecialSubrangeReadActor*>(this)->destroy(); return 0; }
															#line 15241 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		new (&static_cast<ValidateSpecialSubrangeReadActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ValidateSpecialSubrangeReadActorState();
		static_cast<ValidateSpecialSubrangeReadActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(RangeResult const& testResult,int loopDepth) 
	{
		loopDepth = a_body1cont4(testResult, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(RangeResult && testResult,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(testResult), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ValidateSpecialSubrangeReadActor*>(this)->actor_wait_state > 0) static_cast<ValidateSpecialSubrangeReadActor*>(this)->actor_wait_state = 0;
		static_cast<ValidateSpecialSubrangeReadActor*>(this)->ActorCallback< ValidateSpecialSubrangeReadActor, 1, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< ValidateSpecialSubrangeReadActor, 1, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("validateSpecialSubrangeRead", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateSpecialSubrangeReadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateSpecialSubrangeRead", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ValidateSpecialSubrangeReadActor, 1, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("validateSpecialSubrangeRead", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateSpecialSubrangeReadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateSpecialSubrangeRead", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ValidateSpecialSubrangeReadActor, 1, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("validateSpecialSubrangeRead", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateSpecialSubrangeReadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateSpecialSubrangeRead", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 3033 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	ReadYourWritesTransaction* ryw;
															#line 3033 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	KeySelector begin;
															#line 3033 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	KeySelector end;
															#line 3033 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	GetRangeLimits limits;
															#line 3033 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	Reverse reverse;
															#line 3033 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	RangeResult result;
															#line 3078 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	KeySelector testBegin;
															#line 3079 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	KeySelector testEnd;
															#line 3083 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	RangeResult expectedResult;
															#line 15342 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
};
// This generated class is to be used only via validateSpecialSubrangeRead()
															#line 3033 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
class ValidateSpecialSubrangeReadActor final : public Actor<Void>, public ActorCallback< ValidateSpecialSubrangeReadActor, 0, RangeResult >, public ActorCallback< ValidateSpecialSubrangeReadActor, 1, RangeResult >, public FastAllocated<ValidateSpecialSubrangeReadActor>, public ValidateSpecialSubrangeReadActorState<ValidateSpecialSubrangeReadActor> {
															#line 15347 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
public:
	using FastAllocated<ValidateSpecialSubrangeReadActor>::operator new;
	using FastAllocated<ValidateSpecialSubrangeReadActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(18316595459912958208UL, 16498315960810074368UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ValidateSpecialSubrangeReadActor, 0, RangeResult >;
friend struct ActorCallback< ValidateSpecialSubrangeReadActor, 1, RangeResult >;
															#line 3033 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	ValidateSpecialSubrangeReadActor(ReadYourWritesTransaction* const& ryw,KeySelector const& begin,KeySelector const& end,GetRangeLimits const& limits,Reverse const& reverse,RangeResult const& result) 
															#line 15365 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
		 : Actor<Void>(),
		   ValidateSpecialSubrangeReadActorState<ValidateSpecialSubrangeReadActor>(ryw, begin, end, limits, reverse, result),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("validateSpecialSubrangeRead", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9908613209698180352UL, 4450646321188080896UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateSpecialSubrangeReadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("validateSpecialSubrangeRead");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("validateSpecialSubrangeRead", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ValidateSpecialSubrangeReadActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ValidateSpecialSubrangeReadActor, 1, RangeResult >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 3033 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
[[nodiscard]] Future<Void> validateSpecialSubrangeRead( ReadYourWritesTransaction* const& ryw, KeySelector const& begin, KeySelector const& end, GetRangeLimits const& limits, Reverse const& reverse, RangeResult const& result ) {
															#line 3033 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
	return Future<Void>(new ValidateSpecialSubrangeReadActor(ryw, begin, end, limits, reverse, result));
															#line 15399 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/build_output/fdbclient/SpecialKeySpace.actor.g.cpp"
}

#line 3114 "/codebuild/output/src1168930650/src/github.com/apple/foundationdb/fdbclient/SpecialKeySpace.actor.cpp"
