#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
/*
 * GetCluster.actor.h
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#pragma once
#if defined(NO_INTELLISENSE) && !defined(METACLUSTER_GETCLUSTER_ACTOR_G_H)
#define METACLUSTER_GETCLUSTER_ACTOR_G_H
#include "metacluster/GetCluster.actor.g.h"
#elif !defined(METACLUSTER_GETCLUSTER_ACTOR_H)
#define METACLUSTER_GETCLUSTER_ACTOR_H

#include "fdbclient/Tenant.h"
#include "flow/flow.h"
#include "flow/genericactors.actor.h"

#include "metacluster/MetaclusterTypes.h"

#include "flow/actorcompiler.h" // has to be last include

namespace metacluster {

															#line 40 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetCluster.actor.g.h"
// This generated class is to be used only via tryGetClusterTransaction()
															#line 38 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
template <class Transaction, class TryGetClusterTransactionActor>
															#line 38 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
class TryGetClusterTransactionActorState {
															#line 46 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetCluster.actor.g.h"
public:
															#line 38 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
	TryGetClusterTransactionActorState(Transaction const& tr,ClusterName const& name) 
															#line 38 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
															#line 38 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
		 : tr(tr),
															#line 38 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
		   name(name)
															#line 55 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetCluster.actor.g.h"
	{
		fdb_probe_actor_create("tryGetClusterTransaction", reinterpret_cast<unsigned long>(this));

	}
	~TryGetClusterTransactionActorState() 
	{
		fdb_probe_actor_destroy("tryGetClusterTransaction", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 40 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
			CODE_PROBE(true, "Try get cluster");
															#line 41 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
			tr->setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 43 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
			metaclusterRegistrationCheck = TenantAPI::checkTenantMode(tr, ClusterType::METACLUSTER_MANAGEMENT);
															#line 46 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
			clusterEntryFuture = metadata::management::dataClusters().get(tr, name);
															#line 47 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
			connectionRecordFuture = metadata::management::dataClusterConnectionRecords().get(tr, name);
															#line 50 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
			StrictFuture<Void> __when_expr_0 = metaclusterRegistrationCheck;
															#line 50 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
			if (static_cast<TryGetClusterTransactionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 82 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetCluster.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TryGetClusterTransactionActor*>(this)->actor_wait_state = 1;
															#line 50 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TryGetClusterTransactionActor, 0, Void >*>(static_cast<TryGetClusterTransactionActor*>(this)));
															#line 87 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetCluster.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TryGetClusterTransactionActorState();
		static_cast<TryGetClusterTransactionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 52 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
		StrictFuture<Optional<DataClusterEntry>> __when_expr_1 = clusterEntryFuture;
															#line 52 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
		if (static_cast<TryGetClusterTransactionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 112 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetCluster.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TryGetClusterTransactionActor*>(this)->actor_wait_state = 2;
															#line 52 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TryGetClusterTransactionActor, 1, Optional<DataClusterEntry> >*>(static_cast<TryGetClusterTransactionActor*>(this)));
															#line 117 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetCluster.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 52 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
		StrictFuture<Optional<DataClusterEntry>> __when_expr_1 = clusterEntryFuture;
															#line 52 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
		if (static_cast<TryGetClusterTransactionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 128 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetCluster.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TryGetClusterTransactionActor*>(this)->actor_wait_state = 2;
															#line 52 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TryGetClusterTransactionActor, 1, Optional<DataClusterEntry> >*>(static_cast<TryGetClusterTransactionActor*>(this)));
															#line 133 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetCluster.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TryGetClusterTransactionActor*>(this)->actor_wait_state > 0) static_cast<TryGetClusterTransactionActor*>(this)->actor_wait_state = 0;
		static_cast<TryGetClusterTransactionActor*>(this)->ActorCallback< TryGetClusterTransactionActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TryGetClusterTransactionActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tryGetClusterTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TryGetClusterTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryGetClusterTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TryGetClusterTransactionActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tryGetClusterTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TryGetClusterTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryGetClusterTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TryGetClusterTransactionActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tryGetClusterTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TryGetClusterTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryGetClusterTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 53 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
		StrictFuture<Optional<ClusterConnectionString>> __when_expr_2 = connectionRecordFuture;
															#line 53 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
		if (static_cast<TryGetClusterTransactionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 219 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetCluster.actor.g.h"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<TryGetClusterTransactionActor*>(this)->actor_wait_state = 3;
															#line 53 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TryGetClusterTransactionActor, 2, Optional<ClusterConnectionString> >*>(static_cast<TryGetClusterTransactionActor*>(this)));
															#line 224 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetCluster.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Optional<DataClusterEntry> const& __clusterEntry,int loopDepth) 
	{
															#line 52 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
		clusterEntry = __clusterEntry;
															#line 233 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetCluster.actor.g.h"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Optional<DataClusterEntry> && __clusterEntry,int loopDepth) 
	{
		clusterEntry = std::move(__clusterEntry);
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TryGetClusterTransactionActor*>(this)->actor_wait_state > 0) static_cast<TryGetClusterTransactionActor*>(this)->actor_wait_state = 0;
		static_cast<TryGetClusterTransactionActor*>(this)->ActorCallback< TryGetClusterTransactionActor, 1, Optional<DataClusterEntry> >::remove();

	}
	void a_callback_fire(ActorCallback< TryGetClusterTransactionActor, 1, Optional<DataClusterEntry> >*,Optional<DataClusterEntry> const& value) 
	{
		fdb_probe_actor_enter("tryGetClusterTransaction", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TryGetClusterTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryGetClusterTransaction", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TryGetClusterTransactionActor, 1, Optional<DataClusterEntry> >*,Optional<DataClusterEntry> && value) 
	{
		fdb_probe_actor_enter("tryGetClusterTransaction", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TryGetClusterTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryGetClusterTransaction", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TryGetClusterTransactionActor, 1, Optional<DataClusterEntry> >*,Error err) 
	{
		fdb_probe_actor_enter("tryGetClusterTransaction", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TryGetClusterTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryGetClusterTransaction", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Optional<ClusterConnectionString> const& connectionString,int loopDepth) 
	{
															#line 55 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
		if (clusterEntry.present())
															#line 312 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetCluster.actor.g.h"
		{
															#line 56 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
			ASSERT(connectionString.present());
															#line 57 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
			if (!static_cast<TryGetClusterTransactionActor*>(this)->SAV<Optional<DataClusterMetadata>>::futures) { (void)(Optional<DataClusterMetadata>(DataClusterMetadata(clusterEntry.get(), connectionString.get()))); this->~TryGetClusterTransactionActorState(); static_cast<TryGetClusterTransactionActor*>(this)->destroy(); return 0; }
															#line 318 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetCluster.actor.g.h"
			new (&static_cast<TryGetClusterTransactionActor*>(this)->SAV< Optional<DataClusterMetadata> >::value()) Optional<DataClusterMetadata>(Optional<DataClusterMetadata>(DataClusterMetadata(clusterEntry.get(), connectionString.get())));
			this->~TryGetClusterTransactionActorState();
			static_cast<TryGetClusterTransactionActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		else
		{
															#line 59 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
			if (!static_cast<TryGetClusterTransactionActor*>(this)->SAV<Optional<DataClusterMetadata>>::futures) { (void)(Optional<DataClusterMetadata>()); this->~TryGetClusterTransactionActorState(); static_cast<TryGetClusterTransactionActor*>(this)->destroy(); return 0; }
															#line 328 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetCluster.actor.g.h"
			new (&static_cast<TryGetClusterTransactionActor*>(this)->SAV< Optional<DataClusterMetadata> >::value()) Optional<DataClusterMetadata>(Optional<DataClusterMetadata>());
			this->~TryGetClusterTransactionActorState();
			static_cast<TryGetClusterTransactionActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}

		return loopDepth;
	}
	int a_body1cont3(Optional<ClusterConnectionString> && connectionString,int loopDepth) 
	{
															#line 55 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
		if (clusterEntry.present())
															#line 341 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetCluster.actor.g.h"
		{
															#line 56 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
			ASSERT(connectionString.present());
															#line 57 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
			if (!static_cast<TryGetClusterTransactionActor*>(this)->SAV<Optional<DataClusterMetadata>>::futures) { (void)(Optional<DataClusterMetadata>(DataClusterMetadata(clusterEntry.get(), connectionString.get()))); this->~TryGetClusterTransactionActorState(); static_cast<TryGetClusterTransactionActor*>(this)->destroy(); return 0; }
															#line 347 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetCluster.actor.g.h"
			new (&static_cast<TryGetClusterTransactionActor*>(this)->SAV< Optional<DataClusterMetadata> >::value()) Optional<DataClusterMetadata>(Optional<DataClusterMetadata>(DataClusterMetadata(clusterEntry.get(), connectionString.get())));
			this->~TryGetClusterTransactionActorState();
			static_cast<TryGetClusterTransactionActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		else
		{
															#line 59 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
			if (!static_cast<TryGetClusterTransactionActor*>(this)->SAV<Optional<DataClusterMetadata>>::futures) { (void)(Optional<DataClusterMetadata>()); this->~TryGetClusterTransactionActorState(); static_cast<TryGetClusterTransactionActor*>(this)->destroy(); return 0; }
															#line 357 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetCluster.actor.g.h"
			new (&static_cast<TryGetClusterTransactionActor*>(this)->SAV< Optional<DataClusterMetadata> >::value()) Optional<DataClusterMetadata>(Optional<DataClusterMetadata>());
			this->~TryGetClusterTransactionActorState();
			static_cast<TryGetClusterTransactionActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}

		return loopDepth;
	}
	int a_body1cont2when1(Optional<ClusterConnectionString> const& connectionString,int loopDepth) 
	{
		loopDepth = a_body1cont3(connectionString, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Optional<ClusterConnectionString> && connectionString,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(connectionString), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TryGetClusterTransactionActor*>(this)->actor_wait_state > 0) static_cast<TryGetClusterTransactionActor*>(this)->actor_wait_state = 0;
		static_cast<TryGetClusterTransactionActor*>(this)->ActorCallback< TryGetClusterTransactionActor, 2, Optional<ClusterConnectionString> >::remove();

	}
	void a_callback_fire(ActorCallback< TryGetClusterTransactionActor, 2, Optional<ClusterConnectionString> >*,Optional<ClusterConnectionString> const& value) 
	{
		fdb_probe_actor_enter("tryGetClusterTransaction", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TryGetClusterTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryGetClusterTransaction", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TryGetClusterTransactionActor, 2, Optional<ClusterConnectionString> >*,Optional<ClusterConnectionString> && value) 
	{
		fdb_probe_actor_enter("tryGetClusterTransaction", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TryGetClusterTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryGetClusterTransaction", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TryGetClusterTransactionActor, 2, Optional<ClusterConnectionString> >*,Error err) 
	{
		fdb_probe_actor_enter("tryGetClusterTransaction", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TryGetClusterTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryGetClusterTransaction", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 38 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
	Transaction tr;
															#line 38 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
	ClusterName name;
															#line 43 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
	Future<Void> metaclusterRegistrationCheck;
															#line 46 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
	Future<Optional<DataClusterEntry>> clusterEntryFuture;
															#line 47 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
	Future<Optional<ClusterConnectionString>> connectionRecordFuture;
															#line 52 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
	Optional<DataClusterEntry> clusterEntry;
															#line 453 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetCluster.actor.g.h"
};
// This generated class is to be used only via tryGetClusterTransaction()
															#line 38 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
template <class Transaction>
															#line 38 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
class TryGetClusterTransactionActor final : public Actor<Optional<DataClusterMetadata>>, public ActorCallback< TryGetClusterTransactionActor<Transaction>, 0, Void >, public ActorCallback< TryGetClusterTransactionActor<Transaction>, 1, Optional<DataClusterEntry> >, public ActorCallback< TryGetClusterTransactionActor<Transaction>, 2, Optional<ClusterConnectionString> >, public FastAllocated<TryGetClusterTransactionActor<Transaction>>, public TryGetClusterTransactionActorState<Transaction, TryGetClusterTransactionActor<Transaction>> {
															#line 460 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetCluster.actor.g.h"
public:
	using FastAllocated<TryGetClusterTransactionActor<Transaction>>::operator new;
	using FastAllocated<TryGetClusterTransactionActor<Transaction>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2326418628742321664UL, 14750731541396710400UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Optional<DataClusterMetadata>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TryGetClusterTransactionActor<Transaction>, 0, Void >;
friend struct ActorCallback< TryGetClusterTransactionActor<Transaction>, 1, Optional<DataClusterEntry> >;
friend struct ActorCallback< TryGetClusterTransactionActor<Transaction>, 2, Optional<ClusterConnectionString> >;
															#line 38 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
	TryGetClusterTransactionActor(Transaction const& tr,ClusterName const& name) 
															#line 479 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetCluster.actor.g.h"
		 : Actor<Optional<DataClusterMetadata>>(),
		   TryGetClusterTransactionActorState<Transaction, TryGetClusterTransactionActor<Transaction>>(tr, name),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("tryGetClusterTransaction", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5245994449145975040UL, 13655752693813703680UL);
		ActorExecutionContextHelper __helper(static_cast<TryGetClusterTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("tryGetClusterTransaction");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("tryGetClusterTransaction", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TryGetClusterTransactionActor<Transaction>, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TryGetClusterTransactionActor<Transaction>, 1, Optional<DataClusterEntry> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TryGetClusterTransactionActor<Transaction>, 2, Optional<ClusterConnectionString> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 38 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
template <class Transaction>
															#line 38 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
[[nodiscard]] Future<Optional<DataClusterMetadata>> tryGetClusterTransaction( Transaction const& tr, ClusterName const& name ) {
															#line 38 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
	return Future<Optional<DataClusterMetadata>>(new TryGetClusterTransactionActor<Transaction>(tr, name));
															#line 515 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetCluster.actor.g.h"
}

#line 62 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"

															#line 520 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetCluster.actor.g.h"
// This generated class is to be used only via tryGetCluster()
															#line 63 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
template <class DB, class TryGetClusterActor>
															#line 63 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
class TryGetClusterActorState {
															#line 526 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetCluster.actor.g.h"
public:
															#line 63 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
	TryGetClusterActorState(Reference<DB> const& db,ClusterName const& name) 
															#line 63 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
															#line 63 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
		 : db(db),
															#line 63 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
		   name(name),
															#line 65 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
		   tr(db->createTransaction())
															#line 537 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetCluster.actor.g.h"
	{
		fdb_probe_actor_create("tryGetCluster", reinterpret_cast<unsigned long>(this));

	}
	~TryGetClusterActorState() 
	{
		fdb_probe_actor_destroy("tryGetCluster", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 67 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
			;
															#line 552 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetCluster.actor.g.h"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TryGetClusterActorState();
		static_cast<TryGetClusterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 69 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
			tr->setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 70 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
			StrictFuture<Optional<DataClusterMetadata>> __when_expr_0 = tryGetClusterTransaction(tr, name);
															#line 70 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
			if (static_cast<TryGetClusterActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 587 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetCluster.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TryGetClusterActor*>(this)->actor_wait_state = 1;
															#line 70 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TryGetClusterActor, 0, Optional<DataClusterMetadata> >*>(static_cast<TryGetClusterActor*>(this)));
															#line 592 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetCluster.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 73 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
			StrictFuture<Void> __when_expr_1 = safeThreadFutureToFuture(tr->onError(e));
															#line 73 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
			if (static_cast<TryGetClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 616 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetCluster.actor.g.h"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<TryGetClusterActor*>(this)->actor_wait_state = 2;
															#line 73 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TryGetClusterActor, 1, Void >*>(static_cast<TryGetClusterActor*>(this)));
															#line 621 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetCluster.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<DataClusterMetadata> const& metadata,int loopDepth) 
	{
															#line 71 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
		if (!static_cast<TryGetClusterActor*>(this)->SAV<Optional<DataClusterMetadata>>::futures) { (void)(metadata); this->~TryGetClusterActorState(); static_cast<TryGetClusterActor*>(this)->destroy(); return 0; }
															#line 636 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetCluster.actor.g.h"
		new (&static_cast<TryGetClusterActor*>(this)->SAV< Optional<DataClusterMetadata> >::value()) Optional<DataClusterMetadata>(metadata);
		this->~TryGetClusterActorState();
		static_cast<TryGetClusterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<DataClusterMetadata> && metadata,int loopDepth) 
	{
															#line 71 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
		if (!static_cast<TryGetClusterActor*>(this)->SAV<Optional<DataClusterMetadata>>::futures) { (void)(metadata); this->~TryGetClusterActorState(); static_cast<TryGetClusterActor*>(this)->destroy(); return 0; }
															#line 648 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetCluster.actor.g.h"
		new (&static_cast<TryGetClusterActor*>(this)->SAV< Optional<DataClusterMetadata> >::value()) Optional<DataClusterMetadata>(metadata);
		this->~TryGetClusterActorState();
		static_cast<TryGetClusterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<DataClusterMetadata> const& metadata,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(metadata, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<DataClusterMetadata> && metadata,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(metadata), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TryGetClusterActor*>(this)->actor_wait_state > 0) static_cast<TryGetClusterActor*>(this)->actor_wait_state = 0;
		static_cast<TryGetClusterActor*>(this)->ActorCallback< TryGetClusterActor, 0, Optional<DataClusterMetadata> >::remove();

	}
	void a_callback_fire(ActorCallback< TryGetClusterActor, 0, Optional<DataClusterMetadata> >*,Optional<DataClusterMetadata> const& value) 
	{
		fdb_probe_actor_enter("tryGetCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TryGetClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryGetCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TryGetClusterActor, 0, Optional<DataClusterMetadata> >*,Optional<DataClusterMetadata> && value) 
	{
		fdb_probe_actor_enter("tryGetCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TryGetClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryGetCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TryGetClusterActor, 0, Optional<DataClusterMetadata> >*,Error err) 
	{
		fdb_probe_actor_enter("tryGetCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TryGetClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryGetCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TryGetClusterActor*>(this)->actor_wait_state > 0) static_cast<TryGetClusterActor*>(this)->actor_wait_state = 0;
		static_cast<TryGetClusterActor*>(this)->ActorCallback< TryGetClusterActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TryGetClusterActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tryGetCluster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TryGetClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryGetCluster", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TryGetClusterActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tryGetCluster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TryGetClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryGetCluster", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TryGetClusterActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tryGetCluster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TryGetClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryGetCluster", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 63 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
	Reference<DB> db;
															#line 63 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
	ClusterName name;
															#line 65 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
	Reference<typename DB::TransactionT> tr;
															#line 824 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetCluster.actor.g.h"
};
// This generated class is to be used only via tryGetCluster()
															#line 63 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
template <class DB>
															#line 63 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
class TryGetClusterActor final : public Actor<Optional<DataClusterMetadata>>, public ActorCallback< TryGetClusterActor<DB>, 0, Optional<DataClusterMetadata> >, public ActorCallback< TryGetClusterActor<DB>, 1, Void >, public FastAllocated<TryGetClusterActor<DB>>, public TryGetClusterActorState<DB, TryGetClusterActor<DB>> {
															#line 831 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetCluster.actor.g.h"
public:
	using FastAllocated<TryGetClusterActor<DB>>::operator new;
	using FastAllocated<TryGetClusterActor<DB>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16898537966223639552UL, 9322556688099525120UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Optional<DataClusterMetadata>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TryGetClusterActor<DB>, 0, Optional<DataClusterMetadata> >;
friend struct ActorCallback< TryGetClusterActor<DB>, 1, Void >;
															#line 63 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
	TryGetClusterActor(Reference<DB> const& db,ClusterName const& name) 
															#line 849 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetCluster.actor.g.h"
		 : Actor<Optional<DataClusterMetadata>>(),
		   TryGetClusterActorState<DB, TryGetClusterActor<DB>>(db, name),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("tryGetCluster", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8069646211821923584UL, 13841934290099350528UL);
		ActorExecutionContextHelper __helper(static_cast<TryGetClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("tryGetCluster");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("tryGetCluster", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TryGetClusterActor<DB>, 0, Optional<DataClusterMetadata> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TryGetClusterActor<DB>, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 63 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
template <class DB>
															#line 63 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
[[nodiscard]] Future<Optional<DataClusterMetadata>> tryGetCluster( Reference<DB> const& db, ClusterName const& name ) {
															#line 63 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
	return Future<Optional<DataClusterMetadata>>(new TryGetClusterActor<DB>(db, name));
															#line 884 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetCluster.actor.g.h"
}

#line 77 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"

															#line 889 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetCluster.actor.g.h"
// This generated class is to be used only via getClusterTransaction()
															#line 78 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
template <class Transaction, class GetClusterTransactionActor>
															#line 78 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
class GetClusterTransactionActorState {
															#line 895 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetCluster.actor.g.h"
public:
															#line 78 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
	GetClusterTransactionActorState(Transaction const& tr,ClusterNameRef const& name) 
															#line 78 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
															#line 78 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
		 : tr(tr),
															#line 78 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
		   name(name)
															#line 904 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetCluster.actor.g.h"
	{
		fdb_probe_actor_create("getClusterTransaction", reinterpret_cast<unsigned long>(this));

	}
	~GetClusterTransactionActorState() 
	{
		fdb_probe_actor_destroy("getClusterTransaction", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 80 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
			StrictFuture<Optional<DataClusterMetadata>> __when_expr_0 = tryGetClusterTransaction(tr, name);
															#line 80 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
			if (static_cast<GetClusterTransactionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 921 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetCluster.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetClusterTransactionActor*>(this)->actor_wait_state = 1;
															#line 80 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetClusterTransactionActor, 0, Optional<DataClusterMetadata> >*>(static_cast<GetClusterTransactionActor*>(this)));
															#line 926 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetCluster.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetClusterTransactionActorState();
		static_cast<GetClusterTransactionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<DataClusterMetadata> const& metadata,int loopDepth) 
	{
															#line 81 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
		if (!metadata.present())
															#line 949 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetCluster.actor.g.h"
		{
															#line 82 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
			return a_body1Catch1(cluster_not_found(), loopDepth);
															#line 953 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetCluster.actor.g.h"
		}
															#line 85 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
		if (!static_cast<GetClusterTransactionActor*>(this)->SAV<DataClusterMetadata>::futures) { (void)(metadata.get()); this->~GetClusterTransactionActorState(); static_cast<GetClusterTransactionActor*>(this)->destroy(); return 0; }
															#line 957 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetCluster.actor.g.h"
		new (&static_cast<GetClusterTransactionActor*>(this)->SAV< DataClusterMetadata >::value()) DataClusterMetadata(metadata.get());
		this->~GetClusterTransactionActorState();
		static_cast<GetClusterTransactionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<DataClusterMetadata> && metadata,int loopDepth) 
	{
															#line 81 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
		if (!metadata.present())
															#line 969 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetCluster.actor.g.h"
		{
															#line 82 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
			return a_body1Catch1(cluster_not_found(), loopDepth);
															#line 973 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetCluster.actor.g.h"
		}
															#line 85 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
		if (!static_cast<GetClusterTransactionActor*>(this)->SAV<DataClusterMetadata>::futures) { (void)(metadata.get()); this->~GetClusterTransactionActorState(); static_cast<GetClusterTransactionActor*>(this)->destroy(); return 0; }
															#line 977 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetCluster.actor.g.h"
		new (&static_cast<GetClusterTransactionActor*>(this)->SAV< DataClusterMetadata >::value()) DataClusterMetadata(metadata.get());
		this->~GetClusterTransactionActorState();
		static_cast<GetClusterTransactionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Optional<DataClusterMetadata> const& metadata,int loopDepth) 
	{
		loopDepth = a_body1cont1(metadata, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<DataClusterMetadata> && metadata,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(metadata), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetClusterTransactionActor*>(this)->actor_wait_state > 0) static_cast<GetClusterTransactionActor*>(this)->actor_wait_state = 0;
		static_cast<GetClusterTransactionActor*>(this)->ActorCallback< GetClusterTransactionActor, 0, Optional<DataClusterMetadata> >::remove();

	}
	void a_callback_fire(ActorCallback< GetClusterTransactionActor, 0, Optional<DataClusterMetadata> >*,Optional<DataClusterMetadata> const& value) 
	{
		fdb_probe_actor_enter("getClusterTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetClusterTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getClusterTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetClusterTransactionActor, 0, Optional<DataClusterMetadata> >*,Optional<DataClusterMetadata> && value) 
	{
		fdb_probe_actor_enter("getClusterTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetClusterTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getClusterTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetClusterTransactionActor, 0, Optional<DataClusterMetadata> >*,Error err) 
	{
		fdb_probe_actor_enter("getClusterTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetClusterTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getClusterTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 78 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
	Transaction tr;
															#line 78 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
	ClusterNameRef name;
															#line 1064 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetCluster.actor.g.h"
};
// This generated class is to be used only via getClusterTransaction()
															#line 78 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
template <class Transaction>
															#line 78 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
class GetClusterTransactionActor final : public Actor<DataClusterMetadata>, public ActorCallback< GetClusterTransactionActor<Transaction>, 0, Optional<DataClusterMetadata> >, public FastAllocated<GetClusterTransactionActor<Transaction>>, public GetClusterTransactionActorState<Transaction, GetClusterTransactionActor<Transaction>> {
															#line 1071 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetCluster.actor.g.h"
public:
	using FastAllocated<GetClusterTransactionActor<Transaction>>::operator new;
	using FastAllocated<GetClusterTransactionActor<Transaction>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7829800623063144704UL, 16226966827670517248UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<DataClusterMetadata>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetClusterTransactionActor<Transaction>, 0, Optional<DataClusterMetadata> >;
															#line 78 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
	GetClusterTransactionActor(Transaction const& tr,ClusterNameRef const& name) 
															#line 1088 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetCluster.actor.g.h"
		 : Actor<DataClusterMetadata>(),
		   GetClusterTransactionActorState<Transaction, GetClusterTransactionActor<Transaction>>(tr, name),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getClusterTransaction", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15929562747964814080UL, 16550313194749314816UL);
		ActorExecutionContextHelper __helper(static_cast<GetClusterTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getClusterTransaction");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getClusterTransaction", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetClusterTransactionActor<Transaction>, 0, Optional<DataClusterMetadata> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 78 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
template <class Transaction>
															#line 78 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
[[nodiscard]] Future<DataClusterMetadata> getClusterTransaction( Transaction const& tr, ClusterNameRef const& name ) {
															#line 78 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
	return Future<DataClusterMetadata>(new GetClusterTransactionActor<Transaction>(tr, name));
															#line 1122 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetCluster.actor.g.h"
}

#line 87 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"

															#line 1127 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetCluster.actor.g.h"
// This generated class is to be used only via getCluster()
															#line 88 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
template <class DB, class GetClusterActor>
															#line 88 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
class GetClusterActorState {
															#line 1133 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetCluster.actor.g.h"
public:
															#line 88 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
	GetClusterActorState(Reference<DB> const& db,ClusterName const& name) 
															#line 88 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
															#line 88 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
		 : db(db),
															#line 88 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
		   name(name)
															#line 1142 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetCluster.actor.g.h"
	{
		fdb_probe_actor_create("getCluster", reinterpret_cast<unsigned long>(this));

	}
	~GetClusterActorState() 
	{
		fdb_probe_actor_destroy("getCluster", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 90 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
			StrictFuture<Optional<DataClusterMetadata>> __when_expr_0 = tryGetCluster(db, name);
															#line 90 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
			if (static_cast<GetClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1159 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetCluster.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetClusterActor*>(this)->actor_wait_state = 1;
															#line 90 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetClusterActor, 0, Optional<DataClusterMetadata> >*>(static_cast<GetClusterActor*>(this)));
															#line 1164 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetCluster.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetClusterActorState();
		static_cast<GetClusterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<DataClusterMetadata> const& metadata,int loopDepth) 
	{
															#line 91 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
		if (!metadata.present())
															#line 1187 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetCluster.actor.g.h"
		{
															#line 92 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
			return a_body1Catch1(cluster_not_found(), loopDepth);
															#line 1191 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetCluster.actor.g.h"
		}
															#line 95 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
		if (!static_cast<GetClusterActor*>(this)->SAV<DataClusterMetadata>::futures) { (void)(metadata.get()); this->~GetClusterActorState(); static_cast<GetClusterActor*>(this)->destroy(); return 0; }
															#line 1195 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetCluster.actor.g.h"
		new (&static_cast<GetClusterActor*>(this)->SAV< DataClusterMetadata >::value()) DataClusterMetadata(metadata.get());
		this->~GetClusterActorState();
		static_cast<GetClusterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<DataClusterMetadata> && metadata,int loopDepth) 
	{
															#line 91 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
		if (!metadata.present())
															#line 1207 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetCluster.actor.g.h"
		{
															#line 92 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
			return a_body1Catch1(cluster_not_found(), loopDepth);
															#line 1211 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetCluster.actor.g.h"
		}
															#line 95 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
		if (!static_cast<GetClusterActor*>(this)->SAV<DataClusterMetadata>::futures) { (void)(metadata.get()); this->~GetClusterActorState(); static_cast<GetClusterActor*>(this)->destroy(); return 0; }
															#line 1215 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetCluster.actor.g.h"
		new (&static_cast<GetClusterActor*>(this)->SAV< DataClusterMetadata >::value()) DataClusterMetadata(metadata.get());
		this->~GetClusterActorState();
		static_cast<GetClusterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Optional<DataClusterMetadata> const& metadata,int loopDepth) 
	{
		loopDepth = a_body1cont1(metadata, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<DataClusterMetadata> && metadata,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(metadata), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetClusterActor*>(this)->actor_wait_state > 0) static_cast<GetClusterActor*>(this)->actor_wait_state = 0;
		static_cast<GetClusterActor*>(this)->ActorCallback< GetClusterActor, 0, Optional<DataClusterMetadata> >::remove();

	}
	void a_callback_fire(ActorCallback< GetClusterActor, 0, Optional<DataClusterMetadata> >*,Optional<DataClusterMetadata> const& value) 
	{
		fdb_probe_actor_enter("getCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetClusterActor, 0, Optional<DataClusterMetadata> >*,Optional<DataClusterMetadata> && value) 
	{
		fdb_probe_actor_enter("getCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetClusterActor, 0, Optional<DataClusterMetadata> >*,Error err) 
	{
		fdb_probe_actor_enter("getCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCluster", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 88 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
	Reference<DB> db;
															#line 88 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
	ClusterName name;
															#line 1302 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetCluster.actor.g.h"
};
// This generated class is to be used only via getCluster()
															#line 88 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
template <class DB>
															#line 88 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
class GetClusterActor final : public Actor<DataClusterMetadata>, public ActorCallback< GetClusterActor<DB>, 0, Optional<DataClusterMetadata> >, public FastAllocated<GetClusterActor<DB>>, public GetClusterActorState<DB, GetClusterActor<DB>> {
															#line 1309 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetCluster.actor.g.h"
public:
	using FastAllocated<GetClusterActor<DB>>::operator new;
	using FastAllocated<GetClusterActor<DB>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16055269780940934912UL, 8746527404709094656UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<DataClusterMetadata>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetClusterActor<DB>, 0, Optional<DataClusterMetadata> >;
															#line 88 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
	GetClusterActor(Reference<DB> const& db,ClusterName const& name) 
															#line 1326 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetCluster.actor.g.h"
		 : Actor<DataClusterMetadata>(),
		   GetClusterActorState<DB, GetClusterActor<DB>>(db, name),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getCluster", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3838274093655030272UL, 16128179049859696384UL);
		ActorExecutionContextHelper __helper(static_cast<GetClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getCluster");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getCluster", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetClusterActor<DB>, 0, Optional<DataClusterMetadata> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 88 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
template <class DB>
															#line 88 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
[[nodiscard]] Future<DataClusterMetadata> getCluster( Reference<DB> const& db, ClusterName const& name ) {
															#line 88 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"
	return Future<DataClusterMetadata>(new GetClusterActor<DB>(db, name));
															#line 1360 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetCluster.actor.g.h"
}

#line 97 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetCluster.actor.h"

} // namespace metacluster

#include "flow/unactorcompiler.h"
#endif