#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
/*
 * ConsistencyCheck.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <math.h>
#include "boost/lexical_cast.hpp"

#include "flow/IRandom.h"
#include "flow/ProcessEvents.h"
#include "fdbclient/NativeAPI.actor.h"
#include "fdbclient/FDBTypes.h"
#include "fdbserver/TesterInterface.actor.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "flow/IRateControl.h"
#include "fdbrpc/simulator.h"
#include "fdbserver/Knobs.h"
#include "fdbserver/StorageMetrics.actor.h"
#include "fdbserver/DataDistribution.actor.h"
#include "fdbserver/QuietDatabase.h"
#include "fdbserver/TSSMappingUtil.actor.h"
#include "flow/DeterministicRandom.h"
#include "fdbclient/ManagementAPI.actor.h"
#include "fdbclient/StorageServerInterface.h"
#include "flow/network.h"
#include "fdbrpc/SimulatorProcessInfo.h"

#include "flow/actorcompiler.h" // This must be the last #include.

// #define SevCCheckInfo SevVerbose
#define SevCCheckInfo SevInfo

struct ConsistencyCheckWorkload : TestWorkload {
	struct OnTimeout {
		ConsistencyCheckWorkload& self;
		explicit OnTimeout(ConsistencyCheckWorkload& self) : self(self) {}
		void operator()(StringRef name, std::any const& msg, Error const& e) {
			TraceEvent(SevError, "ConsistencyCheckFailure")
			    .error(e)
			    .detail("EventName", name)
			    .detail("EventMessage", std::any_cast<StringRef>(msg))
			    .log();
		}
	};

	static constexpr auto NAME = "ConsistencyCheck";
	// Whether or not we should perform checks that will only pass if the database is in a quiescent state
	bool performQuiescentChecks;

	// Whether or not perform consistency check between storage cache servers and storage servers
	bool performCacheCheck;

	// Whether or not to perform consistency check between storage servers and pair TSS
	bool performTSSCheck;

	// How long to wait for the database to go quiet before failing (if doing quiescent checks)
	double quiescentWaitTimeout;

	// If true, then perform all checks on this client.  The first client is the only one to perform all of the fast
	// checks All other clients will perform slow checks if this test is distributed
	bool firstClient;

	// If true, then the expensive checks will be distributed to multiple clients
	bool distributed;

	// Determines how many shards are checked for consistency: out of every <shardSampleFactor> shards, 1 will be
	// checked
	int shardSampleFactor;

	// The previous data distribution mode
	int oldDataDistributionMode;

	// If true, then any failure of the consistency check will be logged as SevError.  Otherwise, it will be logged as
	// SevWarn
	bool failureIsError;

	// Max number of bytes per second to read from each storage server
	int rateLimitMax;

	// DataSet Size
	int64_t bytesReadInPreviousRound;

	// Randomize shard order with each iteration if true
	bool shuffleShards;

	bool success;

	// Number of times this client has run its portion of the consistency check
	int64_t repetitions;

	// Whether to continuously perform the consistency check
	bool indefinite;

	// Whether to suspendConsistencyCheck
	AsyncVar<bool> suspendConsistencyCheck;

	Future<Void> monitorConsistencyCheckSettingsActor;

	OnTimeout onTimeout;
	ProcessEvents::Event onTimeoutEvent;

	ConsistencyCheckWorkload(WorkloadContext const& wcx)
	  : TestWorkload(wcx), onTimeout(*this), onTimeoutEvent({ "Timeout"_sr, "TracedTooManyLines"_sr }, onTimeout) {
		performQuiescentChecks = getOption(options, "performQuiescentChecks"_sr, false);
		performCacheCheck = getOption(options, "performCacheCheck"_sr, false);
		performTSSCheck = getOption(options, "performTSSCheck"_sr, true);
		quiescentWaitTimeout = getOption(options, "quiescentWaitTimeout"_sr, 600.0);
		distributed = getOption(options, "distributed"_sr, true);
		shardSampleFactor = std::max(getOption(options, "shardSampleFactor"_sr, 1), 1);
		failureIsError = getOption(options, "failureIsError"_sr, false);
		rateLimitMax = getOption(options, "rateLimitMax"_sr, 0);
		shuffleShards = getOption(options, "shuffleShards"_sr, false);
		indefinite = getOption(options, "indefinite"_sr, false);
		suspendConsistencyCheck.set(true);

		success = true;

		firstClient = clientId == 0;

		repetitions = 0;
		bytesReadInPreviousRound = 0;
	}

	Future<Void> setup(Database const& cx) override { return _setup(cx, this); }

																#line 143 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
// This generated class is to be used only via _setup()
															#line 141 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
template <class _setupActor>
															#line 141 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
class _setupActorState {
															#line 149 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
public:
															#line 141 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	_setupActorState(Database const& cx,ConsistencyCheckWorkload* const& self) 
															#line 141 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
															#line 141 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		 : cx(cx),
															#line 141 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		   self(self)
															#line 158 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
	{
		fdb_probe_actor_create("_setup", reinterpret_cast<unsigned long>(this));

	}
	~_setupActorState() 
	{
		fdb_probe_actor_destroy("_setup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 143 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (self->firstClient && self->performQuiescentChecks)
															#line 173 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 144 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				if (g_network->isSimulated())
															#line 177 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				{
															#line 145 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					StrictFuture<Void> __when_expr_0 = timeKeeperSetDisable(cx);
															#line 145 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 183 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
					if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
					static_cast<_setupActor*>(this)->actor_wait_state = 1;
															#line 145 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 0, Void >*>(static_cast<_setupActor*>(this)));
															#line 188 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
					loopDepth = 0;
				}
				else
				{
					loopDepth = a_body1cont2(loopDepth);
				}
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 162 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		self->monitorConsistencyCheckSettingsActor = self->monitorConsistencyCheckSettings(cx, self);
															#line 163 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!static_cast<_setupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_setupActorState(); static_cast<_setupActor*>(this)->destroy(); return 0; }
															#line 223 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		new (&static_cast<_setupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
		try {
															#line 149 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			StrictFuture<Void> __when_expr_1 = timeoutError(quietDatabase(cx, self->dbInfo, "ConsistencyCheckStart", 0, 1e5, 0, 0), self->quiescentWaitTimeout);
															#line 149 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), loopDepth);
															#line 238 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont2Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<_setupActor*>(this)->actor_wait_state = 2;
															#line 149 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 1, Void >*>(static_cast<_setupActor*>(this)));
															#line 243 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont2Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_setupActor*>(this)->actor_wait_state > 0) static_cast<_setupActor*>(this)->actor_wait_state = 0;
		static_cast<_setupActor*>(this)->ActorCallback< _setupActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _setupActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _setupActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _setupActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 156 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent("ConsistencyCheck_QuietDatabaseError").error(e);
															#line 157 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			self->testFailure("Unable to achieve a quiet database");
															#line 158 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			self->performQuiescentChecks = false;
															#line 356 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			loopDepth = a_body1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 151 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (g_network->isSimulated())
															#line 371 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 152 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			g_simulator->quiesced = true;
															#line 153 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent("ConsistencyCheckQuiesced").detail("Quiesced", g_simulator->quiesced);
															#line 377 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 151 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (g_network->isSimulated())
															#line 387 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 152 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			g_simulator->quiesced = true;
															#line 153 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent("ConsistencyCheckQuiesced").detail("Quiesced", g_simulator->quiesced);
															#line 393 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_setupActor*>(this)->actor_wait_state > 0) static_cast<_setupActor*>(this)->actor_wait_state = 0;
		static_cast<_setupActor*>(this)->ActorCallback< _setupActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _setupActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _setupActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _setupActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont8(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 141 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Database cx;
															#line 141 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	ConsistencyCheckWorkload* self;
															#line 491 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
};
// This generated class is to be used only via _setup()
															#line 141 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
class _setupActor final : public Actor<Void>, public ActorCallback< _setupActor, 0, Void >, public ActorCallback< _setupActor, 1, Void >, public FastAllocated<_setupActor>, public _setupActorState<_setupActor> {
															#line 496 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
public:
	using FastAllocated<_setupActor>::operator new;
	using FastAllocated<_setupActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9658322299909350144UL, 15366788342301879552UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _setupActor, 0, Void >;
friend struct ActorCallback< _setupActor, 1, Void >;
															#line 141 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	_setupActor(Database const& cx,ConsistencyCheckWorkload* const& self) 
															#line 514 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		 : Actor<Void>(),
		   _setupActorState<_setupActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3044502327521131520UL, 13387266639422932480UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_setup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _setupActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _setupActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 141 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
[[nodiscard]] Future<Void> _setup( Database const& cx, ConsistencyCheckWorkload* const& self ) {
															#line 141 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	return Future<Void>(new _setupActor(cx, self));
															#line 547 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
}

#line 165 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"

	Future<Void> start(Database const& cx) override {
		TraceEvent("ConsistencyCheck").log();
		return _start(cx, this);
	}

	Future<bool> check(Database const& cx) override { return success; }

	void getMetrics(std::vector<PerfMetric>& m) override {}

	void testFailure(std::string message, bool isError = false) {
		success = false;

		TraceEvent failEvent((failureIsError || isError) ? SevError : SevWarn, "TestFailure");
		if (performQuiescentChecks)
			failEvent.detail("Workload", "QuiescentCheck");
		else
			failEvent.detail("Workload", "ConsistencyCheck");

		failEvent.detail("Reason", "Consistency check: " + message);
	}

																#line 573 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
// This generated class is to be used only via monitorConsistencyCheckSettings()
															#line 187 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
template <class MonitorConsistencyCheckSettingsActor>
															#line 187 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
class MonitorConsistencyCheckSettingsActorState {
															#line 579 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
public:
															#line 187 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	MonitorConsistencyCheckSettingsActorState(Database const& cx,ConsistencyCheckWorkload* const& self) 
															#line 187 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
															#line 187 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		 : cx(cx),
															#line 187 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		   self(self)
															#line 588 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
	{
		fdb_probe_actor_create("monitorConsistencyCheckSettings", reinterpret_cast<unsigned long>(this));

	}
	~MonitorConsistencyCheckSettingsActorState() 
	{
		fdb_probe_actor_destroy("monitorConsistencyCheckSettings", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 188 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			;
															#line 603 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MonitorConsistencyCheckSettingsActorState();
		static_cast<MonitorConsistencyCheckSettingsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 189 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		tr = ReadYourWritesTransaction(cx);
															#line 633 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		try {
															#line 191 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 192 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 193 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 194 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr.get(fdbShouldConsistencyCheckBeSuspended);
															#line 194 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (static_cast<MonitorConsistencyCheckSettingsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 645 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<MonitorConsistencyCheckSettingsActor*>(this)->actor_wait_state = 1;
															#line 194 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MonitorConsistencyCheckSettingsActor, 0, Optional<Value> >*>(static_cast<MonitorConsistencyCheckSettingsActor*>(this)));
															#line 650 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 203 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr.onError(e);
															#line 203 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (static_cast<MonitorConsistencyCheckSettingsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 674 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<MonitorConsistencyCheckSettingsActor*>(this)->actor_wait_state = 4;
															#line 203 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< MonitorConsistencyCheckSettingsActor, 3, Void >*>(static_cast<MonitorConsistencyCheckSettingsActor*>(this)));
															#line 679 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 195 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		bool ccSuspend = ccSuspendVal.present() ? BinaryReader::fromStringRef<bool>(ccSuspendVal.get(), Unversioned()) : false;
															#line 198 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		self->suspendConsistencyCheck.set(ccSuspend);
															#line 199 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		watchCCSuspendFuture = tr.watch(fdbShouldConsistencyCheckBeSuspended);
															#line 200 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 200 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<MonitorConsistencyCheckSettingsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 702 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<MonitorConsistencyCheckSettingsActor*>(this)->actor_wait_state = 2;
															#line 200 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MonitorConsistencyCheckSettingsActor, 1, Void >*>(static_cast<MonitorConsistencyCheckSettingsActor*>(this)));
															#line 707 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& __ccSuspendVal,int loopDepth) 
	{
															#line 194 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		ccSuspendVal = __ccSuspendVal;
															#line 716 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && __ccSuspendVal,int loopDepth) 
	{
		ccSuspendVal = std::move(__ccSuspendVal);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MonitorConsistencyCheckSettingsActor*>(this)->actor_wait_state > 0) static_cast<MonitorConsistencyCheckSettingsActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorConsistencyCheckSettingsActor*>(this)->ActorCallback< MonitorConsistencyCheckSettingsActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorConsistencyCheckSettingsActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("monitorConsistencyCheckSettings", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorConsistencyCheckSettingsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorConsistencyCheckSettings", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MonitorConsistencyCheckSettingsActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("monitorConsistencyCheckSettings", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorConsistencyCheckSettingsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorConsistencyCheckSettings", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MonitorConsistencyCheckSettingsActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("monitorConsistencyCheckSettings", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorConsistencyCheckSettingsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorConsistencyCheckSettings", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 201 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<Void> __when_expr_2 = watchCCSuspendFuture;
															#line 201 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<MonitorConsistencyCheckSettingsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 797 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<MonitorConsistencyCheckSettingsActor*>(this)->actor_wait_state = 3;
															#line 201 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MonitorConsistencyCheckSettingsActor, 2, Void >*>(static_cast<MonitorConsistencyCheckSettingsActor*>(this)));
															#line 802 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 201 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<Void> __when_expr_2 = watchCCSuspendFuture;
															#line 201 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<MonitorConsistencyCheckSettingsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 813 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<MonitorConsistencyCheckSettingsActor*>(this)->actor_wait_state = 3;
															#line 201 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MonitorConsistencyCheckSettingsActor, 2, Void >*>(static_cast<MonitorConsistencyCheckSettingsActor*>(this)));
															#line 818 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<MonitorConsistencyCheckSettingsActor*>(this)->actor_wait_state > 0) static_cast<MonitorConsistencyCheckSettingsActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorConsistencyCheckSettingsActor*>(this)->ActorCallback< MonitorConsistencyCheckSettingsActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorConsistencyCheckSettingsActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorConsistencyCheckSettings", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorConsistencyCheckSettingsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorConsistencyCheckSettings", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MonitorConsistencyCheckSettingsActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorConsistencyCheckSettings", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorConsistencyCheckSettingsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorConsistencyCheckSettings", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< MonitorConsistencyCheckSettingsActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorConsistencyCheckSettings", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorConsistencyCheckSettingsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorConsistencyCheckSettings", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<MonitorConsistencyCheckSettingsActor*>(this)->actor_wait_state > 0) static_cast<MonitorConsistencyCheckSettingsActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorConsistencyCheckSettingsActor*>(this)->ActorCallback< MonitorConsistencyCheckSettingsActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorConsistencyCheckSettingsActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorConsistencyCheckSettings", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorConsistencyCheckSettingsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorConsistencyCheckSettings", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< MonitorConsistencyCheckSettingsActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorConsistencyCheckSettings", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorConsistencyCheckSettingsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorConsistencyCheckSettings", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< MonitorConsistencyCheckSettingsActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorConsistencyCheckSettings", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorConsistencyCheckSettingsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorConsistencyCheckSettings", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<MonitorConsistencyCheckSettingsActor*>(this)->actor_wait_state > 0) static_cast<MonitorConsistencyCheckSettingsActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorConsistencyCheckSettingsActor*>(this)->ActorCallback< MonitorConsistencyCheckSettingsActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorConsistencyCheckSettingsActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorConsistencyCheckSettings", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorConsistencyCheckSettingsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorConsistencyCheckSettings", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< MonitorConsistencyCheckSettingsActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorConsistencyCheckSettings", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorConsistencyCheckSettingsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorConsistencyCheckSettings", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< MonitorConsistencyCheckSettingsActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorConsistencyCheckSettings", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorConsistencyCheckSettingsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorConsistencyCheckSettings", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 187 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Database cx;
															#line 187 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	ConsistencyCheckWorkload* self;
															#line 189 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	ReadYourWritesTransaction tr;
															#line 194 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Optional<Value> ccSuspendVal;
															#line 199 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Future<Void> watchCCSuspendFuture;
															#line 1095 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
};
// This generated class is to be used only via monitorConsistencyCheckSettings()
															#line 187 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
class MonitorConsistencyCheckSettingsActor final : public Actor<Void>, public ActorCallback< MonitorConsistencyCheckSettingsActor, 0, Optional<Value> >, public ActorCallback< MonitorConsistencyCheckSettingsActor, 1, Void >, public ActorCallback< MonitorConsistencyCheckSettingsActor, 2, Void >, public ActorCallback< MonitorConsistencyCheckSettingsActor, 3, Void >, public FastAllocated<MonitorConsistencyCheckSettingsActor>, public MonitorConsistencyCheckSettingsActorState<MonitorConsistencyCheckSettingsActor> {
															#line 1100 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
public:
	using FastAllocated<MonitorConsistencyCheckSettingsActor>::operator new;
	using FastAllocated<MonitorConsistencyCheckSettingsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15224174366639316224UL, 14589184725560657408UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MonitorConsistencyCheckSettingsActor, 0, Optional<Value> >;
friend struct ActorCallback< MonitorConsistencyCheckSettingsActor, 1, Void >;
friend struct ActorCallback< MonitorConsistencyCheckSettingsActor, 2, Void >;
friend struct ActorCallback< MonitorConsistencyCheckSettingsActor, 3, Void >;
															#line 187 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	MonitorConsistencyCheckSettingsActor(Database const& cx,ConsistencyCheckWorkload* const& self) 
															#line 1120 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		 : Actor<Void>(),
		   MonitorConsistencyCheckSettingsActorState<MonitorConsistencyCheckSettingsActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("monitorConsistencyCheckSettings", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16598048751331225600UL, 3236326283404452096UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorConsistencyCheckSettingsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("monitorConsistencyCheckSettings");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("monitorConsistencyCheckSettings", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MonitorConsistencyCheckSettingsActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< MonitorConsistencyCheckSettingsActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< MonitorConsistencyCheckSettingsActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< MonitorConsistencyCheckSettingsActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 187 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
[[nodiscard]] Future<Void> monitorConsistencyCheckSettings( Database const& cx, ConsistencyCheckWorkload* const& self ) {
															#line 187 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	return Future<Void>(new MonitorConsistencyCheckSettingsActor(cx, self));
															#line 1155 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
}

#line 207 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"

																#line 1160 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
// This generated class is to be used only via _start()
															#line 208 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
template <class _startActor>
															#line 208 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
class _startActorState {
															#line 1166 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
public:
															#line 208 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	_startActorState(Database const& cx,ConsistencyCheckWorkload* const& self) 
															#line 208 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
															#line 208 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		 : cx(cx),
															#line 208 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		   self(self)
															#line 1175 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 209 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			;
															#line 1190 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 225 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (self->firstClient && g_network->isSimulated() && self->performQuiescentChecks)
															#line 1213 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 226 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			g_simulator->quiesced = false;
															#line 227 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent("ConsistencyCheckQuiescedEnd").detail("Quiesced", g_simulator->quiesced);
															#line 1219 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 229 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 1223 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 210 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		;
															#line 1242 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = a_body1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 214 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		TraceEvent("ConsistencyCheck_StartingOrResuming").log();
															#line 216 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->runCheck(cx, self);
															#line 215 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1268 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
															#line 222 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<Void> __when_expr_2 = self->suspendConsistencyCheck.onChange();
															#line 1272 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when2(__when_expr_2.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 216 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 222 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, Void >*>(static_cast<_startActor*>(this)));
															#line 1279 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
															#line 210 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!(self->suspendConsistencyCheck.get()))
															#line 1295 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
			return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 211 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		TraceEvent("ConsistencyCheck_Suspended").log();
															#line 212 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<Void> __when_expr_0 = self->suspendConsistencyCheck.onChange();
															#line 212 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 1305 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 212 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, Void >*>(static_cast<_startActor*>(this)));
															#line 1310 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
															#line 217 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!self->indefinite)
															#line 1425 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 219 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		self->repetitions++;
															#line 220 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<Void> __when_expr_3 = delay(5.0);
															#line 220 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1435 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1when1(__when_expr_3.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 220 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _startActor, 3, Void >*>(static_cast<_startActor*>(this)));
															#line 1440 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
															#line 217 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!self->indefinite)
															#line 1449 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 219 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		self->repetitions++;
															#line 220 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<Void> __when_expr_3 = delay(5.0);
															#line 220 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1459 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1when1(__when_expr_3.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 220 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _startActor, 3, Void >*>(static_cast<_startActor*>(this)));
															#line 1464 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 1, Void >::remove();
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 2, Void >::remove();

	}
	int a_body1loopBody1cont1when1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1when1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1when1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1when1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1when1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< _startActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _startActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _startActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 208 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Database cx;
															#line 208 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	ConsistencyCheckWorkload* self;
															#line 1693 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
};
// This generated class is to be used only via _start()
															#line 208 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, Void >, public ActorCallback< _startActor, 1, Void >, public ActorCallback< _startActor, 3, Void >, public ActorCallback< _startActor, 2, Void >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 1698 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7542829621371580160UL, 9183014375827263232UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, Void >;
friend struct ActorCallback< _startActor, 1, Void >;
friend struct ActorCallback< _startActor, 3, Void >;
friend struct ActorCallback< _startActor, 2, Void >;
															#line 208 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	_startActor(Database const& cx,ConsistencyCheckWorkload* const& self) 
															#line 1718 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		 : Actor<Void>(),
		   _startActorState<_startActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _startActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _startActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 208 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
[[nodiscard]] Future<Void> _start( Database const& cx, ConsistencyCheckWorkload* const& self ) {
															#line 208 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	return Future<Void>(new _startActor(cx, self));
															#line 1752 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
}

#line 231 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"

																#line 1757 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
// This generated class is to be used only via runCheck()
															#line 232 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
template <class RunCheckActor>
															#line 232 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
class RunCheckActorState {
															#line 1763 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
public:
															#line 232 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	RunCheckActorState(Database const& cx,ConsistencyCheckWorkload* const& self) 
															#line 232 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
															#line 232 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		 : cx(cx),
															#line 232 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		   self(self)
															#line 1772 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
	{
		fdb_probe_actor_create("runCheck", reinterpret_cast<unsigned long>(this));

	}
	~RunCheckActorState() 
	{
		fdb_probe_actor_destroy("runCheck", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 233 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			CODE_PROBE(self->performQuiescentChecks, "Quiescent consistency check");
															#line 234 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			CODE_PROBE(!self->performQuiescentChecks, "Non-quiescent consistency check");
															#line 235 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			consistenyCheckerBeginTime = now();
															#line 237 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (self->firstClient || self->distributed)
															#line 1793 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
				try {
															#line 239 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					configuration = DatabaseConfiguration();
															#line 240 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					tssMapping = std::map<UID, StorageServerInterface>();
															#line 242 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					tr = Transaction(cx);
															#line 243 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 244 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					;
															#line 1806 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
					loopDepth = a_body1loopHead1(loopDepth);
				}
				catch (Error& error) {
					loopDepth = a_body1Catch2(error, loopDepth);
				} catch (...) {
					loopDepth = a_body1Catch2(unknown_error(), loopDepth);
				}
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RunCheckActorState();
		static_cast<RunCheckActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 409 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		TraceEvent("ConsistencyCheck_FinishedCheck") .detail("Repetitions", self->repetitions) .detail("TimeSpan", now() - consistenyCheckerBeginTime);
															#line 413 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!static_cast<RunCheckActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunCheckActorState(); static_cast<RunCheckActor*>(this)->destroy(); return 0; }
															#line 1842 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		new (&static_cast<RunCheckActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RunCheckActorState();
		static_cast<RunCheckActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 398 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (e.code() == error_code_transaction_too_old || e.code() == error_code_future_version || e.code() == error_code_wrong_shard_server || e.code() == error_code_all_alternatives_failed || e.code() == error_code_process_behind || e.code() == error_code_actor_cancelled)
															#line 1861 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 401 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				TraceEvent("ConsistencyCheck_Retry") .error(e);
															#line 1865 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			}
			else
			{
															#line 404 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				self->testFailure(format("Error %d - %s", e.code(), e.name()));
															#line 1871 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			}
			loopDepth = a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3(int loopDepth) 
	{
															#line 264 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (self->firstClient && self->performQuiescentChecks)
															#line 1887 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 267 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			StrictFuture<bool> __when_expr_3 = self->checkForUndesirableServers(cx, configuration, self);
															#line 267 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (static_cast<RunCheckActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 1893 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch2(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
			static_cast<RunCheckActor*>(this)->actor_wait_state = 4;
															#line 267 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< RunCheckActor, 3, bool >*>(static_cast<RunCheckActor*>(this)));
															#line 1898 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 246 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (self->performTSSCheck)
															#line 1920 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 247 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				tssMapping.clear();
															#line 248 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				StrictFuture<Void> __when_expr_0 = readTSSMapping(&tr, &tssMapping);
															#line 248 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				if (static_cast<RunCheckActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1928 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
				static_cast<RunCheckActor*>(this)->actor_wait_state = 1;
															#line 248 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RunCheckActor, 0, Void >*>(static_cast<RunCheckActor*>(this)));
															#line 1933 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1loopBody1cont2(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 259 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 259 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (static_cast<RunCheckActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1975 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<RunCheckActor*>(this)->actor_wait_state = 3;
															#line 259 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RunCheckActor, 2, Void >*>(static_cast<RunCheckActor*>(this)));
															#line 1980 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 250 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<RangeResult> __when_expr_1 = tr.getRange(configKeys, 1000);
															#line 250 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<RunCheckActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1997 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<RunCheckActor*>(this)->actor_wait_state = 2;
															#line 250 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RunCheckActor, 1, RangeResult >*>(static_cast<RunCheckActor*>(this)));
															#line 2002 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RunCheckActor*>(this)->actor_wait_state > 0) static_cast<RunCheckActor*>(this)->actor_wait_state = 0;
		static_cast<RunCheckActor*>(this)->ActorCallback< RunCheckActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RunCheckActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont4(RangeResult const& res,int loopDepth) 
	{
															#line 251 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (res.size() == 1000)
															#line 2098 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 252 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent("ConsistencyCheck_TooManyConfigOptions").log();
															#line 253 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			self->testFailure("Read too many configuration options");
															#line 2104 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 255 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for(int i = 0;i < res.size();i++) {
															#line 256 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			configuration.set(res[i].key, res[i].value);
															#line 2110 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont4(RangeResult && res,int loopDepth) 
	{
															#line 251 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (res.size() == 1000)
															#line 2120 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 252 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent("ConsistencyCheck_TooManyConfigOptions").log();
															#line 253 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			self->testFailure("Read too many configuration options");
															#line 2126 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 255 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for(int i = 0;i < res.size();i++) {
															#line 256 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			configuration.set(res[i].key, res[i].value);
															#line 2132 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(RangeResult const& res,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(res, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(RangeResult && res,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(res), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RunCheckActor*>(this)->actor_wait_state > 0) static_cast<RunCheckActor*>(this)->actor_wait_state = 0;
		static_cast<RunCheckActor*>(this)->ActorCallback< RunCheckActor, 1, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 1, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 1, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RunCheckActor, 1, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<RunCheckActor*>(this)->actor_wait_state > 0) static_cast<RunCheckActor*>(this)->actor_wait_state = 0;
		static_cast<RunCheckActor*>(this)->ActorCallback< RunCheckActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< RunCheckActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 351 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		keyServerPromise = Promise<std::vector<std::pair<KeyRange, std::vector<StorageServerInterface>>>>();
															#line 352 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<bool> __when_expr_15 = getKeyServers(cx, keyServerPromise, keyServersKeys, self->performQuiescentChecks, self->failureIsError, &self->success);
															#line 352 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<RunCheckActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 2308 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_15.isReady()) { if (__when_expr_15.isError()) return a_body1Catch2(__when_expr_15.getError(), loopDepth); else return a_body1cont4when1(__when_expr_15.get(), loopDepth); };
		static_cast<RunCheckActor*>(this)->actor_wait_state = 16;
															#line 352 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_15.addCallbackAndClear(static_cast<ActorCallback< RunCheckActor, 15, bool >*>(static_cast<RunCheckActor*>(this)));
															#line 2313 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5(int loopDepth) 
	{
															#line 270 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<int64_t> __when_expr_4 = getDataDistributionQueueSize(cx, self->dbInfo, true);
															#line 270 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<RunCheckActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 2324 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch2(__when_expr_4.getError(), loopDepth); else return a_body1cont5when1(__when_expr_4.get(), loopDepth); };
		static_cast<RunCheckActor*>(this)->actor_wait_state = 5;
															#line 270 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< RunCheckActor, 4, int64_t >*>(static_cast<RunCheckActor*>(this)));
															#line 2329 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3when1(bool const& __hasUndesirableServers,int loopDepth) 
	{
															#line 267 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		hasUndesirableServers = __hasUndesirableServers;
															#line 2338 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(bool && __hasUndesirableServers,int loopDepth) 
	{
		hasUndesirableServers = std::move(__hasUndesirableServers);
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<RunCheckActor*>(this)->actor_wait_state > 0) static_cast<RunCheckActor*>(this)->actor_wait_state = 0;
		static_cast<RunCheckActor*>(this)->ActorCallback< RunCheckActor, 3, bool >::remove();

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 3, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 3, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< RunCheckActor, 3, bool >*,Error err) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont6(int64_t const& inDataDistributionQueue,int loopDepth) 
	{
															#line 271 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (inDataDistributionQueue > 0)
															#line 2417 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 272 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent("ConsistencyCheck_NonZeroDataDistributionQueue") .detail("QueueSize", inDataDistributionQueue);
															#line 274 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			self->testFailure("Non-zero data distribution queue/in-flight size");
															#line 2423 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 279 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<bool> __when_expr_5 = getTeamCollectionValid(cx, self->dbInfo);
															#line 279 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<RunCheckActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 2429 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch2(__when_expr_5.getError(), loopDepth); else return a_body1cont6when1(__when_expr_5.get(), loopDepth); };
		static_cast<RunCheckActor*>(this)->actor_wait_state = 6;
															#line 279 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< RunCheckActor, 5, bool >*>(static_cast<RunCheckActor*>(this)));
															#line 2434 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6(int64_t && inDataDistributionQueue,int loopDepth) 
	{
															#line 271 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (inDataDistributionQueue > 0)
															#line 2443 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 272 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent("ConsistencyCheck_NonZeroDataDistributionQueue") .detail("QueueSize", inDataDistributionQueue);
															#line 274 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			self->testFailure("Non-zero data distribution queue/in-flight size");
															#line 2449 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 279 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<bool> __when_expr_5 = getTeamCollectionValid(cx, self->dbInfo);
															#line 279 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<RunCheckActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 2455 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch2(__when_expr_5.getError(), loopDepth); else return a_body1cont6when1(__when_expr_5.get(), loopDepth); };
		static_cast<RunCheckActor*>(this)->actor_wait_state = 6;
															#line 279 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< RunCheckActor, 5, bool >*>(static_cast<RunCheckActor*>(this)));
															#line 2460 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5when1(int64_t const& inDataDistributionQueue,int loopDepth) 
	{
		loopDepth = a_body1cont6(inDataDistributionQueue, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(int64_t && inDataDistributionQueue,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(inDataDistributionQueue), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<RunCheckActor*>(this)->actor_wait_state > 0) static_cast<RunCheckActor*>(this)->actor_wait_state = 0;
		static_cast<RunCheckActor*>(this)->ActorCallback< RunCheckActor, 4, int64_t >::remove();

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 4, int64_t >*,int64_t const& value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 4, int64_t >*,int64_t && value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< RunCheckActor, 4, int64_t >*,Error err) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont7(bool const& teamCollectionValid,int loopDepth) 
	{
															#line 280 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!teamCollectionValid)
															#line 2544 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 281 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent(SevError, "ConsistencyCheck_TooManyTeams").log();
															#line 282 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			self->testFailure("The number of process or machine teams is larger than the allowed maximum " "number of teams");
															#line 2550 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 287 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<std::pair<int64_t, int64_t>> __when_expr_6 = getTLogQueueInfo(cx, self->dbInfo);
															#line 287 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<RunCheckActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 2556 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch2(__when_expr_6.getError(), loopDepth); else return a_body1cont7when1(__when_expr_6.get(), loopDepth); };
		static_cast<RunCheckActor*>(this)->actor_wait_state = 7;
															#line 287 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< RunCheckActor, 6, std::pair<int64_t, int64_t> >*>(static_cast<RunCheckActor*>(this)));
															#line 2561 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7(bool && teamCollectionValid,int loopDepth) 
	{
															#line 280 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!teamCollectionValid)
															#line 2570 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 281 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent(SevError, "ConsistencyCheck_TooManyTeams").log();
															#line 282 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			self->testFailure("The number of process or machine teams is larger than the allowed maximum " "number of teams");
															#line 2576 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 287 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<std::pair<int64_t, int64_t>> __when_expr_6 = getTLogQueueInfo(cx, self->dbInfo);
															#line 287 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<RunCheckActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 2582 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch2(__when_expr_6.getError(), loopDepth); else return a_body1cont7when1(__when_expr_6.get(), loopDepth); };
		static_cast<RunCheckActor*>(this)->actor_wait_state = 7;
															#line 287 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< RunCheckActor, 6, std::pair<int64_t, int64_t> >*>(static_cast<RunCheckActor*>(this)));
															#line 2587 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6when1(bool const& teamCollectionValid,int loopDepth) 
	{
		loopDepth = a_body1cont7(teamCollectionValid, loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(bool && teamCollectionValid,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(teamCollectionValid), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<RunCheckActor*>(this)->actor_wait_state > 0) static_cast<RunCheckActor*>(this)->actor_wait_state = 0;
		static_cast<RunCheckActor*>(this)->ActorCallback< RunCheckActor, 5, bool >::remove();

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 5, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 5, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< RunCheckActor, 5, bool >*,Error err) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont9(std::pair<int64_t, int64_t> const& maxTLogQueueInfo,int loopDepth) 
	{
															#line 288 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (maxTLogQueueInfo.first > 1e5)
															#line 2671 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 290 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent("ConsistencyCheck_NonZeroTLogQueue").detail("MaxQueueSize", maxTLogQueueInfo.first);
															#line 291 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			self->testFailure("Non-zero tlog queue size");
															#line 2677 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 294 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (maxTLogQueueInfo.second > 30e6)
															#line 2681 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 295 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent("ConsistencyCheck_PoppedVersionLag") .detail("PoppedVersionLag", maxTLogQueueInfo.second);
															#line 297 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			self->testFailure("large popped version lag");
															#line 2687 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
		try {
															#line 302 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			StrictFuture<int64_t> __when_expr_7 = getMaxStorageServerQueueSize(cx, self->dbInfo, invalidVersion);
															#line 302 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (static_cast<RunCheckActor*>(this)->actor_wait_state < 0) return a_body1cont9Catch1(actor_cancelled(), loopDepth);
															#line 2694 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1cont9Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont9when1(__when_expr_7.get(), loopDepth); };
			static_cast<RunCheckActor*>(this)->actor_wait_state = 8;
															#line 302 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< RunCheckActor, 7, int64_t >*>(static_cast<RunCheckActor*>(this)));
															#line 2699 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont9Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont9Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont9(std::pair<int64_t, int64_t> && maxTLogQueueInfo,int loopDepth) 
	{
															#line 288 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (maxTLogQueueInfo.first > 1e5)
															#line 2714 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 290 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent("ConsistencyCheck_NonZeroTLogQueue").detail("MaxQueueSize", maxTLogQueueInfo.first);
															#line 291 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			self->testFailure("Non-zero tlog queue size");
															#line 2720 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 294 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (maxTLogQueueInfo.second > 30e6)
															#line 2724 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 295 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent("ConsistencyCheck_PoppedVersionLag") .detail("PoppedVersionLag", maxTLogQueueInfo.second);
															#line 297 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			self->testFailure("large popped version lag");
															#line 2730 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
		try {
															#line 302 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			StrictFuture<int64_t> __when_expr_7 = getMaxStorageServerQueueSize(cx, self->dbInfo, invalidVersion);
															#line 302 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (static_cast<RunCheckActor*>(this)->actor_wait_state < 0) return a_body1cont9Catch1(actor_cancelled(), loopDepth);
															#line 2737 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1cont9Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont9when1(__when_expr_7.get(), loopDepth); };
			static_cast<RunCheckActor*>(this)->actor_wait_state = 8;
															#line 302 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< RunCheckActor, 7, int64_t >*>(static_cast<RunCheckActor*>(this)));
															#line 2742 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont9Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont9Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont7when1(std::pair<int64_t, int64_t> const& maxTLogQueueInfo,int loopDepth) 
	{
		loopDepth = a_body1cont9(maxTLogQueueInfo, loopDepth);

		return loopDepth;
	}
	int a_body1cont7when1(std::pair<int64_t, int64_t> && maxTLogQueueInfo,int loopDepth) 
	{
		loopDepth = a_body1cont9(std::move(maxTLogQueueInfo), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<RunCheckActor*>(this)->actor_wait_state > 0) static_cast<RunCheckActor*>(this)->actor_wait_state = 0;
		static_cast<RunCheckActor*>(this)->ActorCallback< RunCheckActor, 6, std::pair<int64_t, int64_t> >::remove();

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 6, std::pair<int64_t, int64_t> >*,std::pair<int64_t, int64_t> const& value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 6, std::pair<int64_t, int64_t> >*,std::pair<int64_t, int64_t> && value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< RunCheckActor, 6, std::pair<int64_t, int64_t> >*,Error err) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont11(int loopDepth) 
	{
															#line 323 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<Void> __when_expr_8 = ::success(self->checkForStorage(cx, configuration, tssMapping, self));
															#line 323 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<RunCheckActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 2834 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch2(__when_expr_8.getError(), loopDepth); else return a_body1cont11when1(__when_expr_8.get(), loopDepth); };
		static_cast<RunCheckActor*>(this)->actor_wait_state = 9;
															#line 323 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< RunCheckActor, 8, Void >*>(static_cast<RunCheckActor*>(this)));
															#line 2839 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont9Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 310 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (e.code() == error_code_attribute_not_found)
															#line 2849 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 311 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				TraceEvent("ConsistencyCheck_StorageQueueSizeError") .error(e) .detail("Reason", "Could not read queue size");
															#line 317 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				if (!hasUndesirableServers)
															#line 2855 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				{
															#line 318 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					self->testFailure("Could not read storage queue size");
															#line 2859 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				}
			}
			else
			{
															#line 320 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				return a_body1Catch2(e, loopDepth);
															#line 2866 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			}
			loopDepth = a_body1cont11(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont14(int64_t const& maxStorageServerQueueSize,int loopDepth) 
	{
															#line 304 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (maxStorageServerQueueSize > 0)
															#line 2882 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 305 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent("ConsistencyCheck_ExceedStorageServerQueueLimit") .detail("MaxQueueSize", maxStorageServerQueueSize);
															#line 307 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			self->testFailure("Storage server queue size exceeds limit");
															#line 2888 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
		loopDepth = a_body1cont14cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont14(int64_t && maxStorageServerQueueSize,int loopDepth) 
	{
															#line 304 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (maxStorageServerQueueSize > 0)
															#line 2898 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 305 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent("ConsistencyCheck_ExceedStorageServerQueueLimit") .detail("MaxQueueSize", maxStorageServerQueueSize);
															#line 307 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			self->testFailure("Storage server queue size exceeds limit");
															#line 2904 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
		loopDepth = a_body1cont14cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont9when1(int64_t const& maxStorageServerQueueSize,int loopDepth) 
	{
		loopDepth = a_body1cont14(maxStorageServerQueueSize, loopDepth);

		return loopDepth;
	}
	int a_body1cont9when1(int64_t && maxStorageServerQueueSize,int loopDepth) 
	{
		loopDepth = a_body1cont14(std::move(maxStorageServerQueueSize), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<RunCheckActor*>(this)->actor_wait_state > 0) static_cast<RunCheckActor*>(this)->actor_wait_state = 0;
		static_cast<RunCheckActor*>(this)->ActorCallback< RunCheckActor, 7, int64_t >::remove();

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 7, int64_t >*,int64_t const& value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont9when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont9Catch1(error, 0);
		} catch (...) {
			a_body1cont9Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 7, int64_t >*,int64_t && value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont9Catch1(error, 0);
		} catch (...) {
			a_body1cont9Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< RunCheckActor, 7, int64_t >*,Error err) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont9Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont9Catch1(error, 0);
		} catch (...) {
			a_body1cont9Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont14cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont11(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont1(Void const& _,int loopDepth) 
	{
															#line 324 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<Void> __when_expr_9 = ::success(self->checkForExtraDataStores(cx, self));
															#line 324 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<RunCheckActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 3004 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch2(__when_expr_9.getError(), loopDepth); else return a_body1cont11cont1when1(__when_expr_9.get(), loopDepth); };
		static_cast<RunCheckActor*>(this)->actor_wait_state = 10;
															#line 324 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< RunCheckActor, 9, Void >*>(static_cast<RunCheckActor*>(this)));
															#line 3009 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont1(Void && _,int loopDepth) 
	{
															#line 324 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<Void> __when_expr_9 = ::success(self->checkForExtraDataStores(cx, self));
															#line 324 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<RunCheckActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 3020 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch2(__when_expr_9.getError(), loopDepth); else return a_body1cont11cont1when1(__when_expr_9.get(), loopDepth); };
		static_cast<RunCheckActor*>(this)->actor_wait_state = 10;
															#line 324 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< RunCheckActor, 9, Void >*>(static_cast<RunCheckActor*>(this)));
															#line 3025 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<RunCheckActor*>(this)->actor_wait_state > 0) static_cast<RunCheckActor*>(this)->actor_wait_state = 0;
		static_cast<RunCheckActor*>(this)->ActorCallback< RunCheckActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont11when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont11when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< RunCheckActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont11cont2(Void const& _,int loopDepth) 
	{
															#line 325 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<Void> __when_expr_10 = ::success(self->checkStorageMetadata(cx, self));
															#line 325 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<RunCheckActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 3111 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1Catch2(__when_expr_10.getError(), loopDepth); else return a_body1cont11cont2when1(__when_expr_10.get(), loopDepth); };
		static_cast<RunCheckActor*>(this)->actor_wait_state = 11;
															#line 325 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< RunCheckActor, 10, Void >*>(static_cast<RunCheckActor*>(this)));
															#line 3116 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont2(Void && _,int loopDepth) 
	{
															#line 325 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<Void> __when_expr_10 = ::success(self->checkStorageMetadata(cx, self));
															#line 325 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<RunCheckActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 3127 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1Catch2(__when_expr_10.getError(), loopDepth); else return a_body1cont11cont2when1(__when_expr_10.get(), loopDepth); };
		static_cast<RunCheckActor*>(this)->actor_wait_state = 11;
															#line 325 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< RunCheckActor, 10, Void >*>(static_cast<RunCheckActor*>(this)));
															#line 3132 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<RunCheckActor*>(this)->actor_wait_state > 0) static_cast<RunCheckActor*>(this)->actor_wait_state = 0;
		static_cast<RunCheckActor*>(this)->ActorCallback< RunCheckActor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont11cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont11cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< RunCheckActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1cont11cont3(Void const& _,int loopDepth) 
	{
															#line 328 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<bool> __when_expr_11 = self->checkUsingDesiredClasses(cx, self);
															#line 328 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<RunCheckActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 3218 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1Catch2(__when_expr_11.getError(), loopDepth); else return a_body1cont11cont3when1(__when_expr_11.get(), loopDepth); };
		static_cast<RunCheckActor*>(this)->actor_wait_state = 12;
															#line 328 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< RunCheckActor, 11, bool >*>(static_cast<RunCheckActor*>(this)));
															#line 3223 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont3(Void && _,int loopDepth) 
	{
															#line 328 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<bool> __when_expr_11 = self->checkUsingDesiredClasses(cx, self);
															#line 328 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<RunCheckActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 3234 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1Catch2(__when_expr_11.getError(), loopDepth); else return a_body1cont11cont3when1(__when_expr_11.get(), loopDepth); };
		static_cast<RunCheckActor*>(this)->actor_wait_state = 12;
															#line 328 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< RunCheckActor, 11, bool >*>(static_cast<RunCheckActor*>(this)));
															#line 3239 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose11() 
	{
		if (static_cast<RunCheckActor*>(this)->actor_wait_state > 0) static_cast<RunCheckActor*>(this)->actor_wait_state = 0;
		static_cast<RunCheckActor*>(this)->ActorCallback< RunCheckActor, 10, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 10, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont11cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 10, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont11cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< RunCheckActor, 10, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 10);

	}
	int a_body1cont11cont4(bool const& usingDesiredClasses,int loopDepth) 
	{
															#line 329 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!usingDesiredClasses)
															#line 3323 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 330 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			self->testFailure("Cluster has machine(s) not using requested classes");
															#line 3327 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 332 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<bool> __when_expr_12 = self->checkWorkerList(cx, self);
															#line 332 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<RunCheckActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 3333 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_12.isReady()) { if (__when_expr_12.isError()) return a_body1Catch2(__when_expr_12.getError(), loopDepth); else return a_body1cont11cont4when1(__when_expr_12.get(), loopDepth); };
		static_cast<RunCheckActor*>(this)->actor_wait_state = 13;
															#line 332 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_12.addCallbackAndClear(static_cast<ActorCallback< RunCheckActor, 12, bool >*>(static_cast<RunCheckActor*>(this)));
															#line 3338 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont4(bool && usingDesiredClasses,int loopDepth) 
	{
															#line 329 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!usingDesiredClasses)
															#line 3347 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 330 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			self->testFailure("Cluster has machine(s) not using requested classes");
															#line 3351 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 332 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<bool> __when_expr_12 = self->checkWorkerList(cx, self);
															#line 332 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<RunCheckActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 3357 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_12.isReady()) { if (__when_expr_12.isError()) return a_body1Catch2(__when_expr_12.getError(), loopDepth); else return a_body1cont11cont4when1(__when_expr_12.get(), loopDepth); };
		static_cast<RunCheckActor*>(this)->actor_wait_state = 13;
															#line 332 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_12.addCallbackAndClear(static_cast<ActorCallback< RunCheckActor, 12, bool >*>(static_cast<RunCheckActor*>(this)));
															#line 3362 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont3when1(bool const& usingDesiredClasses,int loopDepth) 
	{
		loopDepth = a_body1cont11cont4(usingDesiredClasses, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont3when1(bool && usingDesiredClasses,int loopDepth) 
	{
		loopDepth = a_body1cont11cont4(std::move(usingDesiredClasses), loopDepth);

		return loopDepth;
	}
	void a_exitChoose12() 
	{
		if (static_cast<RunCheckActor*>(this)->actor_wait_state > 0) static_cast<RunCheckActor*>(this)->actor_wait_state = 0;
		static_cast<RunCheckActor*>(this)->ActorCallback< RunCheckActor, 11, bool >::remove();

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 11, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont11cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 11, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont11cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_error(ActorCallback< RunCheckActor, 11, bool >*,Error err) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 11);

	}
	int a_body1cont11cont5(bool const& workerListCorrect,int loopDepth) 
	{
															#line 333 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!workerListCorrect)
															#line 3446 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 334 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			self->testFailure("Worker list incorrect");
															#line 3450 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 336 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<bool> __when_expr_13 = self->checkCoordinators(cx);
															#line 336 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<RunCheckActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 3456 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_13.isReady()) { if (__when_expr_13.isError()) return a_body1Catch2(__when_expr_13.getError(), loopDepth); else return a_body1cont11cont5when1(__when_expr_13.get(), loopDepth); };
		static_cast<RunCheckActor*>(this)->actor_wait_state = 14;
															#line 336 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_13.addCallbackAndClear(static_cast<ActorCallback< RunCheckActor, 13, bool >*>(static_cast<RunCheckActor*>(this)));
															#line 3461 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont5(bool && workerListCorrect,int loopDepth) 
	{
															#line 333 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!workerListCorrect)
															#line 3470 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 334 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			self->testFailure("Worker list incorrect");
															#line 3474 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 336 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<bool> __when_expr_13 = self->checkCoordinators(cx);
															#line 336 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<RunCheckActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 3480 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_13.isReady()) { if (__when_expr_13.isError()) return a_body1Catch2(__when_expr_13.getError(), loopDepth); else return a_body1cont11cont5when1(__when_expr_13.get(), loopDepth); };
		static_cast<RunCheckActor*>(this)->actor_wait_state = 14;
															#line 336 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_13.addCallbackAndClear(static_cast<ActorCallback< RunCheckActor, 13, bool >*>(static_cast<RunCheckActor*>(this)));
															#line 3485 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont4when1(bool const& workerListCorrect,int loopDepth) 
	{
		loopDepth = a_body1cont11cont5(workerListCorrect, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont4when1(bool && workerListCorrect,int loopDepth) 
	{
		loopDepth = a_body1cont11cont5(std::move(workerListCorrect), loopDepth);

		return loopDepth;
	}
	void a_exitChoose13() 
	{
		if (static_cast<RunCheckActor*>(this)->actor_wait_state > 0) static_cast<RunCheckActor*>(this)->actor_wait_state = 0;
		static_cast<RunCheckActor*>(this)->ActorCallback< RunCheckActor, 12, bool >::remove();

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 12, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont11cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 12, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont11cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_error(ActorCallback< RunCheckActor, 12, bool >*,Error err) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 12);

	}
	int a_body1cont11cont7(bool const& coordinatorsCorrect,int loopDepth) 
	{
															#line 337 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!coordinatorsCorrect)
															#line 3569 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 338 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			self->testFailure("Coordinators incorrect");
															#line 3573 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 340 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<bool> __when_expr_14 = self->checkConsistencyScan(cx);
															#line 340 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<RunCheckActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 3579 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_14.isReady()) { if (__when_expr_14.isError()) return a_body1Catch2(__when_expr_14.getError(), loopDepth); else return a_body1cont11cont7when1(__when_expr_14.get(), loopDepth); };
		static_cast<RunCheckActor*>(this)->actor_wait_state = 15;
															#line 340 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_14.addCallbackAndClear(static_cast<ActorCallback< RunCheckActor, 14, bool >*>(static_cast<RunCheckActor*>(this)));
															#line 3584 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont7(bool && coordinatorsCorrect,int loopDepth) 
	{
															#line 337 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!coordinatorsCorrect)
															#line 3593 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 338 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			self->testFailure("Coordinators incorrect");
															#line 3597 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 340 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<bool> __when_expr_14 = self->checkConsistencyScan(cx);
															#line 340 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<RunCheckActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 3603 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_14.isReady()) { if (__when_expr_14.isError()) return a_body1Catch2(__when_expr_14.getError(), loopDepth); else return a_body1cont11cont7when1(__when_expr_14.get(), loopDepth); };
		static_cast<RunCheckActor*>(this)->actor_wait_state = 15;
															#line 340 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_14.addCallbackAndClear(static_cast<ActorCallback< RunCheckActor, 14, bool >*>(static_cast<RunCheckActor*>(this)));
															#line 3608 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont5when1(bool const& coordinatorsCorrect,int loopDepth) 
	{
		loopDepth = a_body1cont11cont7(coordinatorsCorrect, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont5when1(bool && coordinatorsCorrect,int loopDepth) 
	{
		loopDepth = a_body1cont11cont7(std::move(coordinatorsCorrect), loopDepth);

		return loopDepth;
	}
	void a_exitChoose14() 
	{
		if (static_cast<RunCheckActor*>(this)->actor_wait_state > 0) static_cast<RunCheckActor*>(this)->actor_wait_state = 0;
		static_cast<RunCheckActor*>(this)->ActorCallback< RunCheckActor, 13, bool >::remove();

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 13, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont11cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 13, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont11cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_error(ActorCallback< RunCheckActor, 13, bool >*,Error err) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 13);

	}
	int a_body1cont11cont9(bool const& consistencyScanStopped,int loopDepth) 
	{
															#line 341 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!consistencyScanStopped)
															#line 3692 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 342 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			self->testFailure("Consistency scan active");
															#line 3696 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont9(bool && consistencyScanStopped,int loopDepth) 
	{
															#line 341 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!consistencyScanStopped)
															#line 3706 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 342 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			self->testFailure("Consistency scan active");
															#line 3710 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont7when1(bool const& consistencyScanStopped,int loopDepth) 
	{
		loopDepth = a_body1cont11cont9(consistencyScanStopped, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont7when1(bool && consistencyScanStopped,int loopDepth) 
	{
		loopDepth = a_body1cont11cont9(std::move(consistencyScanStopped), loopDepth);

		return loopDepth;
	}
	void a_exitChoose15() 
	{
		if (static_cast<RunCheckActor*>(this)->actor_wait_state > 0) static_cast<RunCheckActor*>(this)->actor_wait_state = 0;
		static_cast<RunCheckActor*>(this)->ActorCallback< RunCheckActor, 14, bool >::remove();

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 14, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1cont11cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 14, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1cont11cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_error(ActorCallback< RunCheckActor, 14, bool >*,Error err) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 14);

	}
	int a_body1cont15(bool const& keyServerResult,int loopDepth) 
	{
															#line 358 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (keyServerResult)
															#line 3795 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 359 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			keyServers = keyServerPromise.getFuture().get();
															#line 363 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			keyLocationPromise = Promise<Standalone<VectorRef<KeyValueRef>>>();
															#line 364 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			StrictFuture<bool> __when_expr_16 = getKeyLocations( cx, keyServers, keyLocationPromise, self->performQuiescentChecks, &self->success);
															#line 364 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (static_cast<RunCheckActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 3805 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			if (__when_expr_16.isReady()) { if (__when_expr_16.isError()) return a_body1Catch2(__when_expr_16.getError(), loopDepth); else return a_body1cont15when1(__when_expr_16.get(), loopDepth); };
			static_cast<RunCheckActor*>(this)->actor_wait_state = 17;
															#line 364 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			__when_expr_16.addCallbackAndClear(static_cast<ActorCallback< RunCheckActor, 16, bool >*>(static_cast<RunCheckActor*>(this)));
															#line 3810 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont15cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont15(bool && keyServerResult,int loopDepth) 
	{
															#line 358 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (keyServerResult)
															#line 3824 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 359 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			keyServers = keyServerPromise.getFuture().get();
															#line 363 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			keyLocationPromise = Promise<Standalone<VectorRef<KeyValueRef>>>();
															#line 364 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			StrictFuture<bool> __when_expr_16 = getKeyLocations( cx, keyServers, keyLocationPromise, self->performQuiescentChecks, &self->success);
															#line 364 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (static_cast<RunCheckActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 3834 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			if (__when_expr_16.isReady()) { if (__when_expr_16.isError()) return a_body1Catch2(__when_expr_16.getError(), loopDepth); else return a_body1cont15when1(__when_expr_16.get(), loopDepth); };
			static_cast<RunCheckActor*>(this)->actor_wait_state = 17;
															#line 364 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			__when_expr_16.addCallbackAndClear(static_cast<ActorCallback< RunCheckActor, 16, bool >*>(static_cast<RunCheckActor*>(this)));
															#line 3839 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont15cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4when1(bool const& keyServerResult,int loopDepth) 
	{
		loopDepth = a_body1cont15(keyServerResult, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(bool && keyServerResult,int loopDepth) 
	{
		loopDepth = a_body1cont15(std::move(keyServerResult), loopDepth);

		return loopDepth;
	}
	void a_exitChoose16() 
	{
		if (static_cast<RunCheckActor*>(this)->actor_wait_state > 0) static_cast<RunCheckActor*>(this)->actor_wait_state = 0;
		static_cast<RunCheckActor*>(this)->ActorCallback< RunCheckActor, 15, bool >::remove();

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 15, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 15);

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 15, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 15);

	}
	void a_callback_error(ActorCallback< RunCheckActor, 15, bool >*,Error err) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 15);

	}
	int a_body1cont15cont1(int loopDepth) 
	{
		loopDepth = a_body1cont15cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont15cont2(bool const& keyLocationResult,int loopDepth) 
	{
															#line 366 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (keyLocationResult)
															#line 3934 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 367 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			keyLocations = keyLocationPromise.getFuture().get();
															#line 370 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			StrictFuture<Void> __when_expr_17 = checkDataConsistency(cx, keyLocations, configuration, tssMapping, self->performQuiescentChecks, self->performTSSCheck, self->firstClient, self->failureIsError, self->clientId, self->clientCount, self->distributed, self->shuffleShards, self->shardSampleFactor, self->sharedRandomNumber, self->repetitions, &(self->bytesReadInPreviousRound), true, self->rateLimitMax, CLIENT_KNOBS->CONSISTENCY_CHECK_ONE_ROUND_TARGET_COMPLETION_TIME, &self->success);
															#line 370 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (static_cast<RunCheckActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 3942 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			if (__when_expr_17.isReady()) { if (__when_expr_17.isError()) return a_body1Catch2(__when_expr_17.getError(), loopDepth); else return a_body1cont15cont2when1(__when_expr_17.get(), loopDepth); };
			static_cast<RunCheckActor*>(this)->actor_wait_state = 18;
															#line 370 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			__when_expr_17.addCallbackAndClear(static_cast<ActorCallback< RunCheckActor, 17, Void >*>(static_cast<RunCheckActor*>(this)));
															#line 3947 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont15cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont15cont2(bool && keyLocationResult,int loopDepth) 
	{
															#line 366 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (keyLocationResult)
															#line 3961 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 367 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			keyLocations = keyLocationPromise.getFuture().get();
															#line 370 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			StrictFuture<Void> __when_expr_17 = checkDataConsistency(cx, keyLocations, configuration, tssMapping, self->performQuiescentChecks, self->performTSSCheck, self->firstClient, self->failureIsError, self->clientId, self->clientCount, self->distributed, self->shuffleShards, self->shardSampleFactor, self->sharedRandomNumber, self->repetitions, &(self->bytesReadInPreviousRound), true, self->rateLimitMax, CLIENT_KNOBS->CONSISTENCY_CHECK_ONE_ROUND_TARGET_COMPLETION_TIME, &self->success);
															#line 370 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (static_cast<RunCheckActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 3969 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			if (__when_expr_17.isReady()) { if (__when_expr_17.isError()) return a_body1Catch2(__when_expr_17.getError(), loopDepth); else return a_body1cont15cont2when1(__when_expr_17.get(), loopDepth); };
			static_cast<RunCheckActor*>(this)->actor_wait_state = 18;
															#line 370 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			__when_expr_17.addCallbackAndClear(static_cast<ActorCallback< RunCheckActor, 17, Void >*>(static_cast<RunCheckActor*>(this)));
															#line 3974 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont15cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont15when1(bool const& keyLocationResult,int loopDepth) 
	{
		loopDepth = a_body1cont15cont2(keyLocationResult, loopDepth);

		return loopDepth;
	}
	int a_body1cont15when1(bool && keyLocationResult,int loopDepth) 
	{
		loopDepth = a_body1cont15cont2(std::move(keyLocationResult), loopDepth);

		return loopDepth;
	}
	void a_exitChoose17() 
	{
		if (static_cast<RunCheckActor*>(this)->actor_wait_state > 0) static_cast<RunCheckActor*>(this)->actor_wait_state = 0;
		static_cast<RunCheckActor*>(this)->ActorCallback< RunCheckActor, 16, bool >::remove();

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 16, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose17();
		try {
			a_body1cont15when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 16);

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 16, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose17();
		try {
			a_body1cont15when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 16);

	}
	void a_callback_error(ActorCallback< RunCheckActor, 16, bool >*,Error err) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose17();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 16);

	}
	int a_body1cont15cont3(int loopDepth) 
	{
		loopDepth = a_body1cont15cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont15cont4(Void const& _,int loopDepth) 
	{
															#line 392 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (self->performCacheCheck)
															#line 4069 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 393 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			StrictFuture<Void> __when_expr_18 = self->checkCacheConsistency(cx, keyLocations, self);
															#line 393 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (static_cast<RunCheckActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 4075 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			if (__when_expr_18.isReady()) { if (__when_expr_18.isError()) return a_body1Catch2(__when_expr_18.getError(), loopDepth); else return a_body1cont15cont4when1(__when_expr_18.get(), loopDepth); };
			static_cast<RunCheckActor*>(this)->actor_wait_state = 19;
															#line 393 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			__when_expr_18.addCallbackAndClear(static_cast<ActorCallback< RunCheckActor, 18, Void >*>(static_cast<RunCheckActor*>(this)));
															#line 4080 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont15cont5(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont15cont4(Void && _,int loopDepth) 
	{
															#line 392 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (self->performCacheCheck)
															#line 4094 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 393 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			StrictFuture<Void> __when_expr_18 = self->checkCacheConsistency(cx, keyLocations, self);
															#line 393 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (static_cast<RunCheckActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 4100 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			if (__when_expr_18.isReady()) { if (__when_expr_18.isError()) return a_body1Catch2(__when_expr_18.getError(), loopDepth); else return a_body1cont15cont4when1(__when_expr_18.get(), loopDepth); };
			static_cast<RunCheckActor*>(this)->actor_wait_state = 19;
															#line 393 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			__when_expr_18.addCallbackAndClear(static_cast<ActorCallback< RunCheckActor, 18, Void >*>(static_cast<RunCheckActor*>(this)));
															#line 4105 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont15cont5(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont15cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont15cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont15cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont15cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose18() 
	{
		if (static_cast<RunCheckActor*>(this)->actor_wait_state > 0) static_cast<RunCheckActor*>(this)->actor_wait_state = 0;
		static_cast<RunCheckActor*>(this)->ActorCallback< RunCheckActor, 17, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 17, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 17);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose18();
		try {
			a_body1cont15cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 17);

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 17, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 17);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose18();
		try {
			a_body1cont15cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 17);

	}
	void a_callback_error(ActorCallback< RunCheckActor, 17, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 17);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose18();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 17);

	}
	int a_body1cont15cont5(int loopDepth) 
	{
		loopDepth = a_body1cont15cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont15cont6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont15cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont15cont6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont15cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont15cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont15cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont15cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont15cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose19() 
	{
		if (static_cast<RunCheckActor*>(this)->actor_wait_state > 0) static_cast<RunCheckActor*>(this)->actor_wait_state = 0;
		static_cast<RunCheckActor*>(this)->ActorCallback< RunCheckActor, 18, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 18, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 18);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose19();
		try {
			a_body1cont15cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 18);

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 18, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 18);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose19();
		try {
			a_body1cont15cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 18);

	}
	void a_callback_error(ActorCallback< RunCheckActor, 18, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 18);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose19();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 18);

	}
	int a_body1cont15cont7(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 232 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Database cx;
															#line 232 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	ConsistencyCheckWorkload* self;
															#line 235 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	double consistenyCheckerBeginTime;
															#line 239 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	DatabaseConfiguration configuration;
															#line 240 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	std::map<UID, StorageServerInterface> tssMapping;
															#line 242 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Transaction tr;
															#line 267 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	bool hasUndesirableServers;
															#line 351 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Promise<std::vector<std::pair<KeyRange, std::vector<StorageServerInterface>>>> keyServerPromise;
															#line 359 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	std::vector<std::pair<KeyRange, std::vector<StorageServerInterface>>> keyServers;
															#line 363 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Promise<Standalone<VectorRef<KeyValueRef>>> keyLocationPromise;
															#line 367 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Standalone<VectorRef<KeyValueRef>> keyLocations;
															#line 4318 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
};
// This generated class is to be used only via runCheck()
															#line 232 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
class RunCheckActor final : public Actor<Void>, public ActorCallback< RunCheckActor, 0, Void >, public ActorCallback< RunCheckActor, 1, RangeResult >, public ActorCallback< RunCheckActor, 2, Void >, public ActorCallback< RunCheckActor, 3, bool >, public ActorCallback< RunCheckActor, 4, int64_t >, public ActorCallback< RunCheckActor, 5, bool >, public ActorCallback< RunCheckActor, 6, std::pair<int64_t, int64_t> >, public ActorCallback< RunCheckActor, 7, int64_t >, public ActorCallback< RunCheckActor, 8, Void >, public ActorCallback< RunCheckActor, 9, Void >, public ActorCallback< RunCheckActor, 10, Void >, public ActorCallback< RunCheckActor, 11, bool >, public ActorCallback< RunCheckActor, 12, bool >, public ActorCallback< RunCheckActor, 13, bool >, public ActorCallback< RunCheckActor, 14, bool >, public ActorCallback< RunCheckActor, 15, bool >, public ActorCallback< RunCheckActor, 16, bool >, public ActorCallback< RunCheckActor, 17, Void >, public ActorCallback< RunCheckActor, 18, Void >, public FastAllocated<RunCheckActor>, public RunCheckActorState<RunCheckActor> {
															#line 4323 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
public:
	using FastAllocated<RunCheckActor>::operator new;
	using FastAllocated<RunCheckActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3727906860278031872UL, 11844865600308670976UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RunCheckActor, 0, Void >;
friend struct ActorCallback< RunCheckActor, 1, RangeResult >;
friend struct ActorCallback< RunCheckActor, 2, Void >;
friend struct ActorCallback< RunCheckActor, 3, bool >;
friend struct ActorCallback< RunCheckActor, 4, int64_t >;
friend struct ActorCallback< RunCheckActor, 5, bool >;
friend struct ActorCallback< RunCheckActor, 6, std::pair<int64_t, int64_t> >;
friend struct ActorCallback< RunCheckActor, 7, int64_t >;
friend struct ActorCallback< RunCheckActor, 8, Void >;
friend struct ActorCallback< RunCheckActor, 9, Void >;
friend struct ActorCallback< RunCheckActor, 10, Void >;
friend struct ActorCallback< RunCheckActor, 11, bool >;
friend struct ActorCallback< RunCheckActor, 12, bool >;
friend struct ActorCallback< RunCheckActor, 13, bool >;
friend struct ActorCallback< RunCheckActor, 14, bool >;
friend struct ActorCallback< RunCheckActor, 15, bool >;
friend struct ActorCallback< RunCheckActor, 16, bool >;
friend struct ActorCallback< RunCheckActor, 17, Void >;
friend struct ActorCallback< RunCheckActor, 18, Void >;
															#line 232 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	RunCheckActor(Database const& cx,ConsistencyCheckWorkload* const& self) 
															#line 4358 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		 : Actor<Void>(),
		   RunCheckActorState<RunCheckActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15195670578295965440UL, 8790465732451613440UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("runCheck");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RunCheckActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RunCheckActor, 1, RangeResult >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< RunCheckActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< RunCheckActor, 3, bool >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< RunCheckActor, 4, int64_t >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< RunCheckActor, 5, bool >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< RunCheckActor, 6, std::pair<int64_t, int64_t> >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< RunCheckActor, 7, int64_t >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< RunCheckActor, 8, Void >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< RunCheckActor, 9, Void >*)0, actor_cancelled()); break;
		case 11: this->a_callback_error((ActorCallback< RunCheckActor, 10, Void >*)0, actor_cancelled()); break;
		case 12: this->a_callback_error((ActorCallback< RunCheckActor, 11, bool >*)0, actor_cancelled()); break;
		case 13: this->a_callback_error((ActorCallback< RunCheckActor, 12, bool >*)0, actor_cancelled()); break;
		case 14: this->a_callback_error((ActorCallback< RunCheckActor, 13, bool >*)0, actor_cancelled()); break;
		case 15: this->a_callback_error((ActorCallback< RunCheckActor, 14, bool >*)0, actor_cancelled()); break;
		case 16: this->a_callback_error((ActorCallback< RunCheckActor, 15, bool >*)0, actor_cancelled()); break;
		case 17: this->a_callback_error((ActorCallback< RunCheckActor, 16, bool >*)0, actor_cancelled()); break;
		case 18: this->a_callback_error((ActorCallback< RunCheckActor, 17, Void >*)0, actor_cancelled()); break;
		case 19: this->a_callback_error((ActorCallback< RunCheckActor, 18, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 232 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
[[nodiscard]] Future<Void> runCheck( Database const& cx, ConsistencyCheckWorkload* const& self ) {
															#line 232 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	return Future<Void>(new RunCheckActor(cx, self));
															#line 4408 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
}

#line 415 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"

	// Check the data consistency between storage cache servers and storage servers
	// keyLocations: all key/value pairs persisted in the database, reused from previous consistency check on all
	// storage servers
																#line 4416 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
// This generated class is to be used only via checkCacheConsistency()
															#line 419 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
template <class CheckCacheConsistencyActor>
															#line 419 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
class CheckCacheConsistencyActorState {
															#line 4422 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
public:
															#line 419 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	CheckCacheConsistencyActorState(Database const& cx,VectorRef<KeyValueRef> const& keyLocations,ConsistencyCheckWorkload* const& self) 
															#line 419 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
															#line 419 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		 : cx(cx),
															#line 419 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		   keyLocations(keyLocations),
															#line 419 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		   self(self),
															#line 422 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		   cacheKeyPromise(),
															#line 423 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		   cacheServerKeyPromise(),
															#line 424 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		   serverListKeyPromise(),
															#line 425 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		   serverTagKeyPromise(),
															#line 426 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		   cacheKey(),
															#line 427 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		   cacheServer(),
															#line 429 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		   serverList(),
															#line 431 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		   serverTag()
															#line 4449 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
	{
		fdb_probe_actor_create("checkCacheConsistency", reinterpret_cast<unsigned long>(this));

	}
	~CheckCacheConsistencyActorState() 
	{
		fdb_probe_actor_destroy("checkCacheConsistency", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 433 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			std::vector<Future<bool>> cacheResultsPromise;
															#line 434 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			cacheResultsPromise.push_back(self->fetchKeyValuesFromSS(cx, self, storageCacheKeys, cacheKeyPromise, true));
															#line 435 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			cacheResultsPromise.push_back( self->fetchKeyValuesFromSS(cx, self, storageCacheServerKeys, cacheServerKeyPromise, false));
															#line 437 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			cacheResultsPromise.push_back( self->fetchKeyValuesFromSS(cx, self, serverListKeys, serverListKeyPromise, false));
															#line 439 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			cacheResultsPromise.push_back(self->fetchKeyValuesFromSS(cx, self, serverTagKeys, serverTagKeyPromise, false));
															#line 440 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			StrictFuture<std::vector<bool>> __when_expr_0 = getAll(cacheResultsPromise);
															#line 440 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (static_cast<CheckCacheConsistencyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4476 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CheckCacheConsistencyActor*>(this)->actor_wait_state = 1;
															#line 440 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckCacheConsistencyActor, 0, std::vector<bool> >*>(static_cast<CheckCacheConsistencyActor*>(this)));
															#line 4481 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckCacheConsistencyActorState();
		static_cast<CheckCacheConsistencyActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<bool> const& cacheResults,int loopDepth) 
	{
															#line 441 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (std::all_of(cacheResults.begin(), cacheResults.end(), [](bool success) { return success; }))
															#line 4504 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 442 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			cacheKey = cacheKeyPromise.getFuture().get();
															#line 443 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			cacheServer = cacheServerKeyPromise.getFuture().get();
															#line 444 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			serverList = serverListKeyPromise.getFuture().get();
															#line 445 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			serverTag = serverTagKeyPromise.getFuture().get();
															#line 4514 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
		else
		{
															#line 447 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent(SevDebug, "CheckCacheConsistencyFailed") .detail("CacheKey", boost::lexical_cast<std::string>(cacheResults[0])) .detail("CacheServerKey", boost::lexical_cast<std::string>(cacheResults[1])) .detail("ServerListKey", boost::lexical_cast<std::string>(cacheResults[2])) .detail("ServerTagKey", boost::lexical_cast<std::string>(cacheResults[3]));
															#line 452 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			self->success = false;
															#line 453 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (!static_cast<CheckCacheConsistencyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckCacheConsistencyActorState(); static_cast<CheckCacheConsistencyActor*>(this)->destroy(); return 0; }
															#line 4524 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			new (&static_cast<CheckCacheConsistencyActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~CheckCacheConsistencyActorState();
			static_cast<CheckCacheConsistencyActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 456 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		rateLimitForThisRound = self->bytesReadInPreviousRound == 0 ? self->rateLimitMax : std::min( self->rateLimitMax, static_cast<int>(ceil(self->bytesReadInPreviousRound / (float)CLIENT_KNOBS->CONSISTENCY_CHECK_ONE_ROUND_TARGET_COMPLETION_TIME)));
															#line 463 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		ASSERT(rateLimitForThisRound >= 0 && rateLimitForThisRound <= self->rateLimitMax);
															#line 464 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		TraceEvent("CacheConsistencyCheck_RateLimitForThisRound").detail("RateLimit", rateLimitForThisRound);
															#line 465 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		rateLimiter = Reference<IRateControl>(new SpeedLimit(rateLimitForThisRound, 1));
															#line 466 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		rateLimiterStartTime = now();
															#line 467 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		bytesReadInRange = 0;
															#line 472 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		cacheServerInterfaces = std::vector<StorageServerInterface>();
															#line 473 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for( const auto& kv : cacheServer ) {
															#line 474 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			StorageServerInterface cacheServer = decodeServerListValue(kv.value);
															#line 476 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			ASSERT(std::find(cacheServerInterfaces.begin(), cacheServerInterfaces.end(), cacheServer) == cacheServerInterfaces.end());
															#line 478 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			cacheServerInterfaces.push_back(cacheServer);
															#line 4552 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 480 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		TraceEvent(SevDebug, "CheckCacheConsistencyCacheServers") .detail("CacheSSInterfaces", describe(cacheServerInterfaces));
															#line 485 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		cachedKeysLocationMap = KeyRangeMap<std::vector<StorageServerInterface>>();
															#line 487 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for(int k = 0;k < cacheKey.size();k++) {
															#line 488 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			std::vector<uint16_t> serverIndices;
															#line 489 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			decodeStorageCacheValue(cacheKey[k].value, serverIndices);
															#line 491 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (serverIndices.size())
															#line 4566 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 492 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				KeyRangeRef range(cacheKey[k].key, (k < cacheKey.size() - 1) ? cacheKey[k + 1].key : allKeys.end);
															#line 493 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				cachedKeysLocationMap.insert(range, cacheServerInterfaces);
															#line 494 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				TraceEvent(SevDebug, "CheckCacheConsistency").detail("CachedRange", range).detail("Index", k);
															#line 4574 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			}
		}
															#line 499 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		UIDtoSSMap = std::map<UID, StorageServerInterface>();
															#line 500 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for( const auto& kv : serverList ) {
															#line 501 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			UID serverId = decodeServerListKey(kv.key);
															#line 502 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			UIDtoSSMap[serverId] = decodeServerListValue(kv.value);
															#line 503 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent(SevDebug, "CheckCacheConsistencyStorageServer").detail("UID", serverId);
															#line 4587 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 507 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for(int k = 0;k < keyLocations.size() - 1;k++) {
															#line 508 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			KeyRangeRef range(keyLocations[k].key, keyLocations[k + 1].key);
															#line 509 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			std::vector<UID> sourceStorageServers;
															#line 510 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			std::vector<UID> destStorageServers;
															#line 511 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			decodeKeyServersValue(RangeResultRef(serverTag, false), keyLocations[k].value, sourceStorageServers, destStorageServers, false);
															#line 516 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			bool isRelocating = destStorageServers.size() > 0;
															#line 517 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			std::vector<UID> storageServers = (isRelocating) ? destStorageServers : sourceStorageServers;
															#line 518 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			std::vector<StorageServerInterface> storageServerInterfaces;
															#line 519 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			for( const auto& UID : storageServers ) {
															#line 520 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				storageServerInterfaces.push_back(UIDtoSSMap[UID]);
															#line 4609 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			}
															#line 522 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			std::vector<StorageServerInterface> allSS(cacheServerInterfaces);
															#line 523 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			allSS.insert(allSS.end(), storageServerInterfaces.begin(), storageServerInterfaces.end());
															#line 530 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			auto begin_iter = cachedKeysLocationMap.rangeContaining(range.begin);
															#line 531 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			ASSERT(begin_iter->begin() == range.begin);
															#line 533 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			auto end_iter = cachedKeysLocationMap.rangeContaining(range.end);
															#line 534 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (end_iter->begin() != range.end)
															#line 4623 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 535 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				cachedKeysLocationMap.insert(KeyRangeRef(end_iter->begin(), range.end), end_iter->value());
															#line 4627 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			}
															#line 537 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			for(auto iter = cachedKeysLocationMap.rangeContaining(range.begin);iter != cachedKeysLocationMap.rangeContaining(range.end);++iter) {
															#line 540 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				if (iter->value().size())
															#line 4633 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				{
															#line 542 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					iter->value().push_back(deterministicRandom()->randomChoice(storageServerInterfaces));
															#line 4637 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				}
			}
		}
															#line 548 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		iter_ranges = cachedKeysLocationMap.containedRanges(allKeys);
															#line 550 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		iter = iter_ranges.begin();
															#line 551 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		iter_ss = std::vector<StorageServerInterface>();
															#line 552 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		effectiveClientCount = (self->distributed) ? self->clientCount : 1;
															#line 553 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		increment = self->distributed ? effectiveClientCount * self->shardSampleFactor : 1;
															#line 554 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		shard = 0;
															#line 556 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for(;shard < self->clientId * self->shardSampleFactor && iter != iter_ranges.end();) {
															#line 557 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (iter->value().empty())
															#line 4657 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 558 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				++iter;
															#line 4661 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				continue;
			}
															#line 561 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			++iter;
															#line 562 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			++shard;
															#line 4668 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 564 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		;
															#line 4672 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(std::vector<bool> && cacheResults,int loopDepth) 
	{
															#line 441 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (std::all_of(cacheResults.begin(), cacheResults.end(), [](bool success) { return success; }))
															#line 4681 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 442 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			cacheKey = cacheKeyPromise.getFuture().get();
															#line 443 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			cacheServer = cacheServerKeyPromise.getFuture().get();
															#line 444 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			serverList = serverListKeyPromise.getFuture().get();
															#line 445 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			serverTag = serverTagKeyPromise.getFuture().get();
															#line 4691 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
		else
		{
															#line 447 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent(SevDebug, "CheckCacheConsistencyFailed") .detail("CacheKey", boost::lexical_cast<std::string>(cacheResults[0])) .detail("CacheServerKey", boost::lexical_cast<std::string>(cacheResults[1])) .detail("ServerListKey", boost::lexical_cast<std::string>(cacheResults[2])) .detail("ServerTagKey", boost::lexical_cast<std::string>(cacheResults[3]));
															#line 452 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			self->success = false;
															#line 453 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (!static_cast<CheckCacheConsistencyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckCacheConsistencyActorState(); static_cast<CheckCacheConsistencyActor*>(this)->destroy(); return 0; }
															#line 4701 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			new (&static_cast<CheckCacheConsistencyActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~CheckCacheConsistencyActorState();
			static_cast<CheckCacheConsistencyActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 456 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		rateLimitForThisRound = self->bytesReadInPreviousRound == 0 ? self->rateLimitMax : std::min( self->rateLimitMax, static_cast<int>(ceil(self->bytesReadInPreviousRound / (float)CLIENT_KNOBS->CONSISTENCY_CHECK_ONE_ROUND_TARGET_COMPLETION_TIME)));
															#line 463 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		ASSERT(rateLimitForThisRound >= 0 && rateLimitForThisRound <= self->rateLimitMax);
															#line 464 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		TraceEvent("CacheConsistencyCheck_RateLimitForThisRound").detail("RateLimit", rateLimitForThisRound);
															#line 465 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		rateLimiter = Reference<IRateControl>(new SpeedLimit(rateLimitForThisRound, 1));
															#line 466 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		rateLimiterStartTime = now();
															#line 467 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		bytesReadInRange = 0;
															#line 472 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		cacheServerInterfaces = std::vector<StorageServerInterface>();
															#line 473 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for( const auto& kv : cacheServer ) {
															#line 474 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			StorageServerInterface cacheServer = decodeServerListValue(kv.value);
															#line 476 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			ASSERT(std::find(cacheServerInterfaces.begin(), cacheServerInterfaces.end(), cacheServer) == cacheServerInterfaces.end());
															#line 478 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			cacheServerInterfaces.push_back(cacheServer);
															#line 4729 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 480 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		TraceEvent(SevDebug, "CheckCacheConsistencyCacheServers") .detail("CacheSSInterfaces", describe(cacheServerInterfaces));
															#line 485 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		cachedKeysLocationMap = KeyRangeMap<std::vector<StorageServerInterface>>();
															#line 487 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for(int k = 0;k < cacheKey.size();k++) {
															#line 488 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			std::vector<uint16_t> serverIndices;
															#line 489 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			decodeStorageCacheValue(cacheKey[k].value, serverIndices);
															#line 491 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (serverIndices.size())
															#line 4743 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 492 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				KeyRangeRef range(cacheKey[k].key, (k < cacheKey.size() - 1) ? cacheKey[k + 1].key : allKeys.end);
															#line 493 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				cachedKeysLocationMap.insert(range, cacheServerInterfaces);
															#line 494 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				TraceEvent(SevDebug, "CheckCacheConsistency").detail("CachedRange", range).detail("Index", k);
															#line 4751 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			}
		}
															#line 499 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		UIDtoSSMap = std::map<UID, StorageServerInterface>();
															#line 500 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for( const auto& kv : serverList ) {
															#line 501 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			UID serverId = decodeServerListKey(kv.key);
															#line 502 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			UIDtoSSMap[serverId] = decodeServerListValue(kv.value);
															#line 503 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent(SevDebug, "CheckCacheConsistencyStorageServer").detail("UID", serverId);
															#line 4764 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 507 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for(int k = 0;k < keyLocations.size() - 1;k++) {
															#line 508 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			KeyRangeRef range(keyLocations[k].key, keyLocations[k + 1].key);
															#line 509 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			std::vector<UID> sourceStorageServers;
															#line 510 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			std::vector<UID> destStorageServers;
															#line 511 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			decodeKeyServersValue(RangeResultRef(serverTag, false), keyLocations[k].value, sourceStorageServers, destStorageServers, false);
															#line 516 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			bool isRelocating = destStorageServers.size() > 0;
															#line 517 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			std::vector<UID> storageServers = (isRelocating) ? destStorageServers : sourceStorageServers;
															#line 518 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			std::vector<StorageServerInterface> storageServerInterfaces;
															#line 519 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			for( const auto& UID : storageServers ) {
															#line 520 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				storageServerInterfaces.push_back(UIDtoSSMap[UID]);
															#line 4786 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			}
															#line 522 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			std::vector<StorageServerInterface> allSS(cacheServerInterfaces);
															#line 523 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			allSS.insert(allSS.end(), storageServerInterfaces.begin(), storageServerInterfaces.end());
															#line 530 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			auto begin_iter = cachedKeysLocationMap.rangeContaining(range.begin);
															#line 531 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			ASSERT(begin_iter->begin() == range.begin);
															#line 533 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			auto end_iter = cachedKeysLocationMap.rangeContaining(range.end);
															#line 534 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (end_iter->begin() != range.end)
															#line 4800 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 535 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				cachedKeysLocationMap.insert(KeyRangeRef(end_iter->begin(), range.end), end_iter->value());
															#line 4804 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			}
															#line 537 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			for(auto iter = cachedKeysLocationMap.rangeContaining(range.begin);iter != cachedKeysLocationMap.rangeContaining(range.end);++iter) {
															#line 540 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				if (iter->value().size())
															#line 4810 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				{
															#line 542 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					iter->value().push_back(deterministicRandom()->randomChoice(storageServerInterfaces));
															#line 4814 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				}
			}
		}
															#line 548 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		iter_ranges = cachedKeysLocationMap.containedRanges(allKeys);
															#line 550 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		iter = iter_ranges.begin();
															#line 551 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		iter_ss = std::vector<StorageServerInterface>();
															#line 552 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		effectiveClientCount = (self->distributed) ? self->clientCount : 1;
															#line 553 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		increment = self->distributed ? effectiveClientCount * self->shardSampleFactor : 1;
															#line 554 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		shard = 0;
															#line 556 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for(;shard < self->clientId * self->shardSampleFactor && iter != iter_ranges.end();) {
															#line 557 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (iter->value().empty())
															#line 4834 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 558 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				++iter;
															#line 4838 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				continue;
			}
															#line 561 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			++iter;
															#line 562 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			++shard;
															#line 4845 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 564 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		;
															#line 4849 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<bool> const& cacheResults,int loopDepth) 
	{
		loopDepth = a_body1cont1(cacheResults, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<bool> && cacheResults,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(cacheResults), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckCacheConsistencyActor*>(this)->actor_wait_state > 0) static_cast<CheckCacheConsistencyActor*>(this)->actor_wait_state = 0;
		static_cast<CheckCacheConsistencyActor*>(this)->ActorCallback< CheckCacheConsistencyActor, 0, std::vector<bool> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckCacheConsistencyActor, 0, std::vector<bool> >*,std::vector<bool> const& value) 
	{
		fdb_probe_actor_enter("checkCacheConsistency", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckCacheConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkCacheConsistency", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckCacheConsistencyActor, 0, std::vector<bool> >*,std::vector<bool> && value) 
	{
		fdb_probe_actor_enter("checkCacheConsistency", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckCacheConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkCacheConsistency", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckCacheConsistencyActor, 0, std::vector<bool> >*,Error err) 
	{
		fdb_probe_actor_enter("checkCacheConsistency", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckCacheConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkCacheConsistency", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 795 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!static_cast<CheckCacheConsistencyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckCacheConsistencyActorState(); static_cast<CheckCacheConsistencyActor*>(this)->destroy(); return 0; }
															#line 4933 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		new (&static_cast<CheckCacheConsistencyActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CheckCacheConsistencyActorState();
		static_cast<CheckCacheConsistencyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 564 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!(iter != iter_ranges.end()))
															#line 4952 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 565 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		iter_ss = iter->value();
															#line 566 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (iter_ss.empty())
															#line 4960 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
			return a_body1cont1continue1(loopDepth); // continue
		}
															#line 568 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (shard % increment != (self->clientId * self->shardSampleFactor) % increment)
															#line 4966 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 569 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			++shard;
															#line 4970 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			return a_body1cont1continue1(loopDepth); // continue
		}
															#line 574 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		lastSampleKey = Key();
															#line 575 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		lastStartSampleKey = Key();
															#line 576 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		totalReadAmount = 0;
															#line 578 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		begin = firstGreaterOrEqual(iter->begin());
															#line 579 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		onErrorTr = Transaction(cx);
															#line 582 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		;
															#line 4985 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1continue1(int loopDepth) 
	{
															#line 564 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		++iter;
															#line 5007 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
															#line 788 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (bytesReadInRange > 0)
															#line 5016 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 789 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent("CacheConsistencyCheck_ReadRange") .suppressFor(1.0) .detail("Range", iter->range()) .detail("BytesRead", bytesReadInRange);
															#line 5020 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 564 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		++iter;
															#line 5024 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1(int loopDepth) 
	{
		try {
															#line 584 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			lastSampleKey = lastStartSampleKey;
															#line 587 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			StrictFuture<Version> __when_expr_1 = getVersion(cx);
															#line 587 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (static_cast<CheckCacheConsistencyActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5045 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1loopBody1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<CheckCacheConsistencyActor*>(this)->actor_wait_state = 2;
															#line 587 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckCacheConsistencyActor, 1, Version >*>(static_cast<CheckCacheConsistencyActor*>(this)));
															#line 5050 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1cont1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 782 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			err = e;
															#line 783 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			StrictFuture<Void> __when_expr_4 = onErrorTr.onError(err);
															#line 783 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (static_cast<CheckCacheConsistencyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 5089 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 2)); else return a_body1cont1loopBody1loopBody1Catch1when1(__when_expr_4.get(), loopDepth); };
			static_cast<CheckCacheConsistencyActor*>(this)->actor_wait_state = 5;
															#line 783 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< CheckCacheConsistencyActor, 4, Void >*>(static_cast<CheckCacheConsistencyActor*>(this)));
															#line 5094 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont2(Version const& version,int loopDepth) 
	{
															#line 589 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		req = GetKeyValuesRequest();
															#line 590 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		req.begin = begin;
															#line 591 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		req.end = firstGreaterOrEqual(iter->end());
															#line 592 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		req.limit = 1e4;
															#line 593 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		req.limitBytes = CLIENT_KNOBS->REPLY_BYTE_LIMIT;
															#line 594 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		req.version = version;
															#line 595 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		req.tags = TagSet();
															#line 596 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		req.options = ReadOptions(debugRandom()->randomUniqueID());
															#line 597 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		DisabledTraceEvent("CCD", req.options.get().debugID.get()).detail("Version", version);
															#line 600 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		keyValueFutures = std::vector<Future<ErrorOr<GetKeyValuesReply>>>();
															#line 601 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		j = 0;
															#line 602 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for(j = 0;j < iter_ss.size();j++) {
															#line 603 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			resetReply(req);
															#line 604 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (SERVER_KNOBS->ENABLE_VERSION_VECTOR)
															#line 5135 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 605 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				cx->getLatestCommitVersion(iter_ss[j], req.version, req.ssLatestCommitVersions);
															#line 5139 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			}
															#line 607 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			keyValueFutures.push_back(iter_ss[j].getKeyValues.getReplyUnlessFailedFor(req, 2, 0));
															#line 5143 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 610 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<Void> __when_expr_2 = waitForAll(keyValueFutures);
															#line 610 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<CheckCacheConsistencyActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5149 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<CheckCacheConsistencyActor*>(this)->actor_wait_state = 3;
															#line 610 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CheckCacheConsistencyActor, 2, Void >*>(static_cast<CheckCacheConsistencyActor*>(this)));
															#line 5154 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont2(Version && version,int loopDepth) 
	{
															#line 589 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		req = GetKeyValuesRequest();
															#line 590 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		req.begin = begin;
															#line 591 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		req.end = firstGreaterOrEqual(iter->end());
															#line 592 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		req.limit = 1e4;
															#line 593 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		req.limitBytes = CLIENT_KNOBS->REPLY_BYTE_LIMIT;
															#line 594 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		req.version = version;
															#line 595 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		req.tags = TagSet();
															#line 596 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		req.options = ReadOptions(debugRandom()->randomUniqueID());
															#line 597 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		DisabledTraceEvent("CCD", req.options.get().debugID.get()).detail("Version", version);
															#line 600 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		keyValueFutures = std::vector<Future<ErrorOr<GetKeyValuesReply>>>();
															#line 601 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		j = 0;
															#line 602 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for(j = 0;j < iter_ss.size();j++) {
															#line 603 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			resetReply(req);
															#line 604 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (SERVER_KNOBS->ENABLE_VERSION_VECTOR)
															#line 5189 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 605 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				cx->getLatestCommitVersion(iter_ss[j], req.version, req.ssLatestCommitVersions);
															#line 5193 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			}
															#line 607 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			keyValueFutures.push_back(iter_ss[j].getKeyValues.getReplyUnlessFailedFor(req, 2, 0));
															#line 5197 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 610 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<Void> __when_expr_2 = waitForAll(keyValueFutures);
															#line 610 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<CheckCacheConsistencyActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5203 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<CheckCacheConsistencyActor*>(this)->actor_wait_state = 3;
															#line 610 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CheckCacheConsistencyActor, 2, Void >*>(static_cast<CheckCacheConsistencyActor*>(this)));
															#line 5208 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when1(Version const& version,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont2(version, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when1(Version && version,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont2(std::move(version), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CheckCacheConsistencyActor*>(this)->actor_wait_state > 0) static_cast<CheckCacheConsistencyActor*>(this)->actor_wait_state = 0;
		static_cast<CheckCacheConsistencyActor*>(this)->ActorCallback< CheckCacheConsistencyActor, 1, Version >::remove();

	}
	void a_callback_fire(ActorCallback< CheckCacheConsistencyActor, 1, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("checkCacheConsistency", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckCacheConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkCacheConsistency", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CheckCacheConsistencyActor, 1, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("checkCacheConsistency", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckCacheConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkCacheConsistency", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CheckCacheConsistencyActor, 1, Version >*,Error err) 
	{
		fdb_probe_actor_enter("checkCacheConsistency", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckCacheConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkCacheConsistency", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 611 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		TraceEvent(SevDebug, "CheckCacheConsistencyComparison") .detail("Begin", req.begin) .detail("End", req.end) .detail("SSInterfaces", describe(iter_ss));
															#line 617 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		firstValidServer = -1;
															#line 618 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		totalReadAmount = 0;
															#line 619 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for(j = 0;j < keyValueFutures.size();j++) {
															#line 620 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			ErrorOr<GetKeyValuesReply> rangeResult = keyValueFutures[j].get();
															#line 626 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (rangeResult.present() && !rangeResult.get().error.present())
															#line 5302 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 627 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				current = rangeResult.get();
															#line 628 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				totalReadAmount += current.data.expectedSize();
															#line 629 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				TraceEvent(SevDebug, "CheckCacheConsistencyResult") .detail("SSInterface", iter_ss[j].uniqueID);
															#line 633 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				if (firstValidServer == -1)
															#line 5312 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				{
															#line 634 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					firstValidServer = j;
															#line 5316 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				}
				else
				{
															#line 638 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					GetKeyValuesReply reference = keyValueFutures[firstValidServer].get().get();
															#line 640 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					if (current.data != reference.data || current.more != reference.more)
															#line 5324 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
					{
															#line 642 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						if (g_network->isSimulated())
															#line 5328 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
						{
															#line 643 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
							int invalidIndex = -1;
															#line 644 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
							printf("\nSERVER %d (%s); shard = %s - %s:\n", j, iter_ss[j].address().toString().c_str(), printable(req.begin.getKey()).c_str(), printable(req.end.getKey()).c_str());
															#line 649 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
							for(int k = 0;k < current.data.size();k++) {
															#line 650 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
								printf("%d. %s => %s\n", k, printable(current.data[k].key).c_str(), printable(current.data[k].value).c_str());
															#line 654 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
								if (invalidIndex < 0 && (k >= reference.data.size() || current.data[k].key != reference.data[k].key || current.data[k].value != reference.data[k].value))
															#line 5340 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
								{
															#line 657 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
									invalidIndex = k;
															#line 5344 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
								}
							}
															#line 660 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
							printf("\nSERVER %d (%s); shard = %s - %s:\n", firstValidServer, iter_ss[firstValidServer].address().toString().c_str(), printable(req.begin.getKey()).c_str(), printable(req.end.getKey()).c_str());
															#line 665 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
							for(int k = 0;k < reference.data.size();k++) {
															#line 666 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
								printf("%d. %s => %s\n", k, printable(reference.data[k].key).c_str(), printable(reference.data[k].value).c_str());
															#line 670 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
								if (invalidIndex < 0 && (k >= current.data.size() || reference.data[k].key != current.data[k].key || reference.data[k].value != current.data[k].value))
															#line 5355 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
								{
															#line 673 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
									invalidIndex = k;
															#line 5359 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
								}
							}
															#line 676 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
							printf("\nMISMATCH AT %d\n\n", invalidIndex);
															#line 5364 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
						}
															#line 681 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						int currentUniques = 0;
															#line 683 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						int referenceUniques = 0;
															#line 685 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						int valueMismatches = 0;
															#line 687 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						int matchingKVPairs = 0;
															#line 689 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						KeyRef currentUniqueKey;
															#line 691 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						KeyRef referenceUniqueKey;
															#line 693 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						KeyRef valueMismatchKey;
															#line 696 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						int currentI = 0;
															#line 697 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						int referenceI = 0;
															#line 698 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						for(;currentI < current.data.size() || referenceI < reference.data.size();) {
															#line 699 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
							if (currentI >= current.data.size())
															#line 5388 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
							{
															#line 700 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
								referenceUniqueKey = reference.data[referenceI].key;
															#line 701 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
								referenceUniques++;
															#line 702 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
								referenceI++;
															#line 5396 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
							}
							else
							{
															#line 703 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
								if (referenceI >= reference.data.size())
															#line 5402 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
								{
															#line 704 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
									currentUniqueKey = current.data[currentI].key;
															#line 705 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
									currentUniques++;
															#line 706 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
									currentI++;
															#line 5410 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
								}
								else
								{
															#line 708 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
									KeyValueRef currentKV = current.data[currentI];
															#line 709 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
									KeyValueRef referenceKV = reference.data[referenceI];
															#line 711 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
									if (currentKV.key == referenceKV.key)
															#line 5420 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
									{
															#line 712 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
										if (currentKV.value == referenceKV.value)
															#line 5424 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
										{
															#line 713 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
											matchingKVPairs++;
															#line 5428 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
										}
										else
										{
															#line 715 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
											valueMismatchKey = currentKV.key;
															#line 716 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
											valueMismatches++;
															#line 5436 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
										}
															#line 719 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
										currentI++;
															#line 720 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
										referenceI++;
															#line 5442 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
									}
									else
									{
															#line 721 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
										if (currentKV.key < referenceKV.key)
															#line 5448 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
										{
															#line 722 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
											currentUniqueKey = currentKV.key;
															#line 723 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
											currentUniques++;
															#line 724 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
											currentI++;
															#line 5456 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
										}
										else
										{
															#line 726 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
											referenceUniqueKey = referenceKV.key;
															#line 727 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
											referenceUniques++;
															#line 728 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
											referenceI++;
															#line 5466 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
										}
									}
								}
							}
						}
															#line 733 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						TraceEvent("CacheConsistencyCheck_DataInconsistent") .detail(format("StorageServer%d", j).c_str(), iter_ss[j].toString()) .detail(format("StorageServer%d", firstValidServer).c_str(), iter_ss[firstValidServer].toString()) .detail("ShardBegin", req.begin.getKey()) .detail("ShardEnd", req.end.getKey()) .detail("VersionNumber", req.version) .detail(format("Server%dUniques", j).c_str(), currentUniques) .detail(format("Server%dUniqueKey", j).c_str(), currentUniqueKey) .detail(format("Server%dUniques", firstValidServer).c_str(), referenceUniques) .detail(format("Server%dUniqueKey", firstValidServer).c_str(), referenceUniqueKey) .detail("ValueMismatches", valueMismatches) .detail("ValueMismatchKey", valueMismatchKey) .detail("MatchingKVPairs", matchingKVPairs);
															#line 749 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						self->testFailure("Data inconsistent", true);
															#line 5476 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
					}
				}
			}
		}
															#line 756 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (rateLimitForThisRound > 0)
															#line 5483 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 757 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			StrictFuture<Void> __when_expr_3 = rateLimiter->getAllowance(totalReadAmount);
															#line 757 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (static_cast<CheckCacheConsistencyActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5489 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont1loopBody1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
			static_cast<CheckCacheConsistencyActor*>(this)->actor_wait_state = 4;
															#line 757 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CheckCacheConsistencyActor, 3, Void >*>(static_cast<CheckCacheConsistencyActor*>(this)));
															#line 5494 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont1loopBody1loopBody1cont6(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 611 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		TraceEvent(SevDebug, "CheckCacheConsistencyComparison") .detail("Begin", req.begin) .detail("End", req.end) .detail("SSInterfaces", describe(iter_ss));
															#line 617 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		firstValidServer = -1;
															#line 618 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		totalReadAmount = 0;
															#line 619 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for(j = 0;j < keyValueFutures.size();j++) {
															#line 620 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			ErrorOr<GetKeyValuesReply> rangeResult = keyValueFutures[j].get();
															#line 626 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (rangeResult.present() && !rangeResult.get().error.present())
															#line 5518 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 627 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				current = rangeResult.get();
															#line 628 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				totalReadAmount += current.data.expectedSize();
															#line 629 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				TraceEvent(SevDebug, "CheckCacheConsistencyResult") .detail("SSInterface", iter_ss[j].uniqueID);
															#line 633 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				if (firstValidServer == -1)
															#line 5528 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				{
															#line 634 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					firstValidServer = j;
															#line 5532 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				}
				else
				{
															#line 638 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					GetKeyValuesReply reference = keyValueFutures[firstValidServer].get().get();
															#line 640 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					if (current.data != reference.data || current.more != reference.more)
															#line 5540 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
					{
															#line 642 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						if (g_network->isSimulated())
															#line 5544 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
						{
															#line 643 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
							int invalidIndex = -1;
															#line 644 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
							printf("\nSERVER %d (%s); shard = %s - %s:\n", j, iter_ss[j].address().toString().c_str(), printable(req.begin.getKey()).c_str(), printable(req.end.getKey()).c_str());
															#line 649 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
							for(int k = 0;k < current.data.size();k++) {
															#line 650 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
								printf("%d. %s => %s\n", k, printable(current.data[k].key).c_str(), printable(current.data[k].value).c_str());
															#line 654 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
								if (invalidIndex < 0 && (k >= reference.data.size() || current.data[k].key != reference.data[k].key || current.data[k].value != reference.data[k].value))
															#line 5556 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
								{
															#line 657 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
									invalidIndex = k;
															#line 5560 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
								}
							}
															#line 660 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
							printf("\nSERVER %d (%s); shard = %s - %s:\n", firstValidServer, iter_ss[firstValidServer].address().toString().c_str(), printable(req.begin.getKey()).c_str(), printable(req.end.getKey()).c_str());
															#line 665 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
							for(int k = 0;k < reference.data.size();k++) {
															#line 666 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
								printf("%d. %s => %s\n", k, printable(reference.data[k].key).c_str(), printable(reference.data[k].value).c_str());
															#line 670 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
								if (invalidIndex < 0 && (k >= current.data.size() || reference.data[k].key != current.data[k].key || reference.data[k].value != current.data[k].value))
															#line 5571 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
								{
															#line 673 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
									invalidIndex = k;
															#line 5575 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
								}
							}
															#line 676 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
							printf("\nMISMATCH AT %d\n\n", invalidIndex);
															#line 5580 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
						}
															#line 681 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						int currentUniques = 0;
															#line 683 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						int referenceUniques = 0;
															#line 685 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						int valueMismatches = 0;
															#line 687 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						int matchingKVPairs = 0;
															#line 689 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						KeyRef currentUniqueKey;
															#line 691 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						KeyRef referenceUniqueKey;
															#line 693 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						KeyRef valueMismatchKey;
															#line 696 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						int currentI = 0;
															#line 697 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						int referenceI = 0;
															#line 698 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						for(;currentI < current.data.size() || referenceI < reference.data.size();) {
															#line 699 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
							if (currentI >= current.data.size())
															#line 5604 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
							{
															#line 700 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
								referenceUniqueKey = reference.data[referenceI].key;
															#line 701 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
								referenceUniques++;
															#line 702 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
								referenceI++;
															#line 5612 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
							}
							else
							{
															#line 703 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
								if (referenceI >= reference.data.size())
															#line 5618 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
								{
															#line 704 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
									currentUniqueKey = current.data[currentI].key;
															#line 705 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
									currentUniques++;
															#line 706 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
									currentI++;
															#line 5626 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
								}
								else
								{
															#line 708 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
									KeyValueRef currentKV = current.data[currentI];
															#line 709 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
									KeyValueRef referenceKV = reference.data[referenceI];
															#line 711 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
									if (currentKV.key == referenceKV.key)
															#line 5636 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
									{
															#line 712 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
										if (currentKV.value == referenceKV.value)
															#line 5640 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
										{
															#line 713 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
											matchingKVPairs++;
															#line 5644 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
										}
										else
										{
															#line 715 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
											valueMismatchKey = currentKV.key;
															#line 716 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
											valueMismatches++;
															#line 5652 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
										}
															#line 719 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
										currentI++;
															#line 720 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
										referenceI++;
															#line 5658 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
									}
									else
									{
															#line 721 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
										if (currentKV.key < referenceKV.key)
															#line 5664 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
										{
															#line 722 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
											currentUniqueKey = currentKV.key;
															#line 723 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
											currentUniques++;
															#line 724 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
											currentI++;
															#line 5672 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
										}
										else
										{
															#line 726 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
											referenceUniqueKey = referenceKV.key;
															#line 727 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
											referenceUniques++;
															#line 728 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
											referenceI++;
															#line 5682 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
										}
									}
								}
							}
						}
															#line 733 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						TraceEvent("CacheConsistencyCheck_DataInconsistent") .detail(format("StorageServer%d", j).c_str(), iter_ss[j].toString()) .detail(format("StorageServer%d", firstValidServer).c_str(), iter_ss[firstValidServer].toString()) .detail("ShardBegin", req.begin.getKey()) .detail("ShardEnd", req.end.getKey()) .detail("VersionNumber", req.version) .detail(format("Server%dUniques", j).c_str(), currentUniques) .detail(format("Server%dUniqueKey", j).c_str(), currentUniqueKey) .detail(format("Server%dUniques", firstValidServer).c_str(), referenceUniques) .detail(format("Server%dUniqueKey", firstValidServer).c_str(), referenceUniqueKey) .detail("ValueMismatches", valueMismatches) .detail("ValueMismatchKey", valueMismatchKey) .detail("MatchingKVPairs", matchingKVPairs);
															#line 749 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						self->testFailure("Data inconsistent", true);
															#line 5692 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
					}
				}
			}
		}
															#line 756 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (rateLimitForThisRound > 0)
															#line 5699 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 757 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			StrictFuture<Void> __when_expr_3 = rateLimiter->getAllowance(totalReadAmount);
															#line 757 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (static_cast<CheckCacheConsistencyActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5705 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont1loopBody1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
			static_cast<CheckCacheConsistencyActor*>(this)->actor_wait_state = 4;
															#line 757 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CheckCacheConsistencyActor, 3, Void >*>(static_cast<CheckCacheConsistencyActor*>(this)));
															#line 5710 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont1loopBody1loopBody1cont6(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CheckCacheConsistencyActor*>(this)->actor_wait_state > 0) static_cast<CheckCacheConsistencyActor*>(this)->actor_wait_state = 0;
		static_cast<CheckCacheConsistencyActor*>(this)->ActorCallback< CheckCacheConsistencyActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckCacheConsistencyActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkCacheConsistency", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckCacheConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkCacheConsistency", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CheckCacheConsistencyActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkCacheConsistency", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckCacheConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkCacheConsistency", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CheckCacheConsistencyActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkCacheConsistency", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckCacheConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkCacheConsistency", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1loopBody1cont6(int loopDepth) 
	{
															#line 769 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		bytesReadInRange += totalReadAmount;
															#line 772 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (firstValidServer >= 0 && keyValueFutures[firstValidServer].get().get().more)
															#line 5801 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 773 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			VectorRef<KeyValueRef> result = keyValueFutures[firstValidServer].get().get().data;
															#line 774 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			ASSERT(result.size() > 0);
															#line 775 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			begin = firstGreaterThan(result[result.size() - 1].key);
															#line 776 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			ASSERT(begin.getKey() != allKeys.end);
															#line 777 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			lastStartSampleKey = lastSampleKey;
															#line 778 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent(SevDebug, "CacheConsistencyCheckNextBeginKey").detail("Key", begin);
															#line 5815 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
		else
		{
			return a_body1cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
		loopDepth = a_body1cont1loopBody1loopBody1cont32(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont28(Void const& _,int loopDepth) 
	{
															#line 759 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (now() - rateLimiterStartTime > 1.1 * CLIENT_KNOBS->CONSISTENCY_CHECK_ONE_ROUND_TARGET_COMPLETION_TIME && rateLimitForThisRound != self->rateLimitMax)
															#line 5829 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 762 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			rateLimitForThisRound = self->rateLimitMax;
															#line 763 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			rateLimiter = Reference<IRateControl>(new SpeedLimit(rateLimitForThisRound, 1));
															#line 764 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			rateLimiterStartTime = now();
															#line 765 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent(SevInfo, "CacheConsistencyCheck_RateLimitSetMaxForThisRound") .detail("RateLimit", rateLimitForThisRound);
															#line 5839 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
		loopDepth = a_body1cont1loopBody1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont28(Void && _,int loopDepth) 
	{
															#line 759 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (now() - rateLimiterStartTime > 1.1 * CLIENT_KNOBS->CONSISTENCY_CHECK_ONE_ROUND_TARGET_COMPLETION_TIME && rateLimitForThisRound != self->rateLimitMax)
															#line 5849 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 762 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			rateLimitForThisRound = self->rateLimitMax;
															#line 763 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			rateLimiter = Reference<IRateControl>(new SpeedLimit(rateLimitForThisRound, 1));
															#line 764 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			rateLimiterStartTime = now();
															#line 765 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent(SevInfo, "CacheConsistencyCheck_RateLimitSetMaxForThisRound") .detail("RateLimit", rateLimitForThisRound);
															#line 5859 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
		loopDepth = a_body1cont1loopBody1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont28(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont28(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<CheckCacheConsistencyActor*>(this)->actor_wait_state > 0) static_cast<CheckCacheConsistencyActor*>(this)->actor_wait_state = 0;
		static_cast<CheckCacheConsistencyActor*>(this)->ActorCallback< CheckCacheConsistencyActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckCacheConsistencyActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkCacheConsistency", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckCacheConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkCacheConsistency", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< CheckCacheConsistencyActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkCacheConsistency", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckCacheConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkCacheConsistency", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< CheckCacheConsistencyActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkCacheConsistency", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckCacheConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkCacheConsistency", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont1loopBody1loopBody1cont32(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1loopBody1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
															#line 784 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		TraceEvent("CacheConsistencyCheck_RetryDataConsistency").error(err);
															#line 5957 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
															#line 784 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		TraceEvent("CacheConsistencyCheck_RetryDataConsistency").error(err);
															#line 5966 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<CheckCacheConsistencyActor*>(this)->actor_wait_state > 0) static_cast<CheckCacheConsistencyActor*>(this)->actor_wait_state = 0;
		static_cast<CheckCacheConsistencyActor*>(this)->ActorCallback< CheckCacheConsistencyActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckCacheConsistencyActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkCacheConsistency", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckCacheConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkCacheConsistency", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< CheckCacheConsistencyActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkCacheConsistency", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckCacheConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkCacheConsistency", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< CheckCacheConsistencyActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkCacheConsistency", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckCacheConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkCacheConsistency", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 419 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Database cx;
															#line 419 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	VectorRef<KeyValueRef> keyLocations;
															#line 419 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	ConsistencyCheckWorkload* self;
															#line 422 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Promise<Standalone<VectorRef<KeyValueRef>>> cacheKeyPromise;
															#line 423 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Promise<Standalone<VectorRef<KeyValueRef>>> cacheServerKeyPromise;
															#line 424 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Promise<Standalone<VectorRef<KeyValueRef>>> serverListKeyPromise;
															#line 425 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Promise<Standalone<VectorRef<KeyValueRef>>> serverTagKeyPromise;
															#line 426 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Standalone<VectorRef<KeyValueRef>> cacheKey;
															#line 427 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Standalone<VectorRef<KeyValueRef>> cacheServer;
															#line 429 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Standalone<VectorRef<KeyValueRef>> serverList;
															#line 431 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Standalone<VectorRef<KeyValueRef>> serverTag;
															#line 456 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	int rateLimitForThisRound;
															#line 465 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Reference<IRateControl> rateLimiter;
															#line 466 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	double rateLimiterStartTime;
															#line 467 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	int bytesReadInRange;
															#line 472 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	std::vector<StorageServerInterface> cacheServerInterfaces;
															#line 485 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	KeyRangeMap<std::vector<StorageServerInterface>> cachedKeysLocationMap;
															#line 499 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	std::map<UID, StorageServerInterface> UIDtoSSMap;
															#line 548 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	RangeMap<Key, std::vector<StorageServerInterface>, KeyRangeRef>::Ranges iter_ranges;
															#line 550 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	RangeMap<Key, std::vector<StorageServerInterface>, KeyRangeRef>::iterator iter;
															#line 551 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	std::vector<StorageServerInterface> iter_ss;
															#line 552 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	int effectiveClientCount;
															#line 553 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	int increment;
															#line 554 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	int shard;
															#line 574 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Key lastSampleKey;
															#line 575 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Key lastStartSampleKey;
															#line 576 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	int64_t totalReadAmount;
															#line 578 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	KeySelector begin;
															#line 579 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Transaction onErrorTr;
															#line 589 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	GetKeyValuesRequest req;
															#line 600 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	std::vector<Future<ErrorOr<GetKeyValuesReply>>> keyValueFutures;
															#line 601 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	int j;
															#line 617 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	int firstValidServer;
															#line 627 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	GetKeyValuesReply current;
															#line 782 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Error err;
															#line 6116 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
};
// This generated class is to be used only via checkCacheConsistency()
															#line 419 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
class CheckCacheConsistencyActor final : public Actor<Void>, public ActorCallback< CheckCacheConsistencyActor, 0, std::vector<bool> >, public ActorCallback< CheckCacheConsistencyActor, 1, Version >, public ActorCallback< CheckCacheConsistencyActor, 2, Void >, public ActorCallback< CheckCacheConsistencyActor, 3, Void >, public ActorCallback< CheckCacheConsistencyActor, 4, Void >, public FastAllocated<CheckCacheConsistencyActor>, public CheckCacheConsistencyActorState<CheckCacheConsistencyActor> {
															#line 6121 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
public:
	using FastAllocated<CheckCacheConsistencyActor>::operator new;
	using FastAllocated<CheckCacheConsistencyActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16786160608664495360UL, 12073020087488237568UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckCacheConsistencyActor, 0, std::vector<bool> >;
friend struct ActorCallback< CheckCacheConsistencyActor, 1, Version >;
friend struct ActorCallback< CheckCacheConsistencyActor, 2, Void >;
friend struct ActorCallback< CheckCacheConsistencyActor, 3, Void >;
friend struct ActorCallback< CheckCacheConsistencyActor, 4, Void >;
															#line 419 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	CheckCacheConsistencyActor(Database const& cx,VectorRef<KeyValueRef> const& keyLocations,ConsistencyCheckWorkload* const& self) 
															#line 6142 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		 : Actor<Void>(),
		   CheckCacheConsistencyActorState<CheckCacheConsistencyActor>(cx, keyLocations, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkCacheConsistency", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9430085582066714624UL, 7832144406646334976UL);
		ActorExecutionContextHelper __helper(static_cast<CheckCacheConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkCacheConsistency");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkCacheConsistency", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckCacheConsistencyActor, 0, std::vector<bool> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CheckCacheConsistencyActor, 1, Version >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CheckCacheConsistencyActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< CheckCacheConsistencyActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< CheckCacheConsistencyActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 419 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
[[nodiscard]] Future<Void> checkCacheConsistency( Database const& cx, VectorRef<KeyValueRef> const& keyLocations, ConsistencyCheckWorkload* const& self ) {
															#line 419 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	return Future<Void>(new CheckCacheConsistencyActor(cx, keyLocations, self));
															#line 6178 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
}

#line 797 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"

	// Directly fetch key/values from storage servers through GetKeyValuesRequest
	// In particular, avoid transaction-based read which may read data from storage cache servers
	// range: all key/values in the range will be fetched
	// removePrefix: if true, remove the prefix of the range, e.g. \xff/storageCacheServer/
																#line 6187 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
// This generated class is to be used only via fetchKeyValuesFromSS()
															#line 802 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
template <class FetchKeyValuesFromSSActor>
															#line 802 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
class FetchKeyValuesFromSSActorState {
															#line 6193 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
public:
															#line 802 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	FetchKeyValuesFromSSActorState(Database const& cx,ConsistencyCheckWorkload* const& self,KeyRangeRef const& range,Promise<Standalone<VectorRef<KeyValueRef>>> const& resultPromise,bool const& removePrefix) 
															#line 802 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
															#line 802 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		 : cx(cx),
															#line 802 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		   self(self),
															#line 802 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		   range(range),
															#line 802 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		   resultPromise(resultPromise),
															#line 802 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		   removePrefix(removePrefix),
															#line 808 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		   keyServerPromise()
															#line 6210 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
	{
		fdb_probe_actor_create("fetchKeyValuesFromSS", reinterpret_cast<unsigned long>(this));

	}
	~FetchKeyValuesFromSSActorState() 
	{
		fdb_probe_actor_destroy("fetchKeyValuesFromSS", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 809 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			StrictFuture<bool> __when_expr_0 = getKeyServers( cx, keyServerPromise, range, self->performQuiescentChecks, self->failureIsError, &self->success);
															#line 809 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (static_cast<FetchKeyValuesFromSSActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6227 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FetchKeyValuesFromSSActor*>(this)->actor_wait_state = 1;
															#line 809 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FetchKeyValuesFromSSActor, 0, bool >*>(static_cast<FetchKeyValuesFromSSActor*>(this)));
															#line 6232 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FetchKeyValuesFromSSActorState();
		static_cast<FetchKeyValuesFromSSActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(bool const& keyServerResult,int loopDepth) 
	{
															#line 811 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!keyServerResult)
															#line 6255 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 812 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (!static_cast<FetchKeyValuesFromSSActor*>(this)->SAV<bool>::futures) { (void)(false); this->~FetchKeyValuesFromSSActorState(); static_cast<FetchKeyValuesFromSSActor*>(this)->destroy(); return 0; }
															#line 6259 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			new (&static_cast<FetchKeyValuesFromSSActor*>(this)->SAV< bool >::value()) bool(false);
			this->~FetchKeyValuesFromSSActorState();
			static_cast<FetchKeyValuesFromSSActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 813 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		shards = keyServerPromise.getFuture().get();
															#line 817 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		result = Standalone<VectorRef<KeyValueRef>>();
															#line 818 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		beginKey = allKeys.begin.withPrefix(range.begin);
															#line 819 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		endKey = allKeys.end.withPrefix(range.begin);
															#line 820 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		i = int();
															#line 821 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		onErrorTr = Transaction(cx);
															#line 825 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		i = 0;
															#line 6279 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(bool && keyServerResult,int loopDepth) 
	{
															#line 811 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!keyServerResult)
															#line 6288 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 812 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (!static_cast<FetchKeyValuesFromSSActor*>(this)->SAV<bool>::futures) { (void)(false); this->~FetchKeyValuesFromSSActorState(); static_cast<FetchKeyValuesFromSSActor*>(this)->destroy(); return 0; }
															#line 6292 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			new (&static_cast<FetchKeyValuesFromSSActor*>(this)->SAV< bool >::value()) bool(false);
			this->~FetchKeyValuesFromSSActorState();
			static_cast<FetchKeyValuesFromSSActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 813 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		shards = keyServerPromise.getFuture().get();
															#line 817 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		result = Standalone<VectorRef<KeyValueRef>>();
															#line 818 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		beginKey = allKeys.begin.withPrefix(range.begin);
															#line 819 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		endKey = allKeys.end.withPrefix(range.begin);
															#line 820 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		i = int();
															#line 821 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		onErrorTr = Transaction(cx);
															#line 825 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		i = 0;
															#line 6312 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(bool const& keyServerResult,int loopDepth) 
	{
		loopDepth = a_body1cont1(keyServerResult, loopDepth);

		return loopDepth;
	}
	int a_body1when1(bool && keyServerResult,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(keyServerResult), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FetchKeyValuesFromSSActor*>(this)->actor_wait_state > 0) static_cast<FetchKeyValuesFromSSActor*>(this)->actor_wait_state = 0;
		static_cast<FetchKeyValuesFromSSActor*>(this)->ActorCallback< FetchKeyValuesFromSSActor, 0, bool >::remove();

	}
	void a_callback_fire(ActorCallback< FetchKeyValuesFromSSActor, 0, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("fetchKeyValuesFromSS", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchKeyValuesFromSSActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchKeyValuesFromSS", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FetchKeyValuesFromSSActor, 0, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("fetchKeyValuesFromSS", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchKeyValuesFromSSActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchKeyValuesFromSS", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FetchKeyValuesFromSSActor, 0, bool >*,Error err) 
	{
		fdb_probe_actor_enter("fetchKeyValuesFromSS", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FetchKeyValuesFromSSActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchKeyValuesFromSS", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 911 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		resultPromise.send(result);
															#line 912 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!static_cast<FetchKeyValuesFromSSActor*>(this)->SAV<bool>::futures) { (void)(true); this->~FetchKeyValuesFromSSActorState(); static_cast<FetchKeyValuesFromSSActor*>(this)->destroy(); return 0; }
															#line 6398 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		new (&static_cast<FetchKeyValuesFromSSActor*>(this)->SAV< bool >::value()) bool(true);
		this->~FetchKeyValuesFromSSActorState();
		static_cast<FetchKeyValuesFromSSActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 825 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!(i < shards.size()))
															#line 6417 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 826 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		;
															#line 6423 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
															#line 825 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		i++;
															#line 6445 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1(int loopDepth) 
	{
															#line 826 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!(beginKey < std::min<KeyRef>(shards[i].first.end, endKey)))
															#line 6461 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
			return a_body1cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
		try {
															#line 828 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			StrictFuture<Version> __when_expr_1 = getVersion(cx);
															#line 828 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (static_cast<FetchKeyValuesFromSSActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6470 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1loopBody1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<FetchKeyValuesFromSSActor*>(this)->actor_wait_state = 2;
															#line 828 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FetchKeyValuesFromSSActor, 1, Version >*>(static_cast<FetchKeyValuesFromSSActor*>(this)));
															#line 6475 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1cont1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 904 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			err = e;
															#line 905 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			StrictFuture<Void> __when_expr_3 = onErrorTr.onError(err);
															#line 905 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (static_cast<FetchKeyValuesFromSSActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 6514 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 2)); else return a_body1cont1loopBody1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<FetchKeyValuesFromSSActor*>(this)->actor_wait_state = 4;
															#line 905 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< FetchKeyValuesFromSSActor, 3, Void >*>(static_cast<FetchKeyValuesFromSSActor*>(this)));
															#line 6519 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont3(Version const& version,int loopDepth) 
	{
															#line 830 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		GetKeyValuesRequest req;
															#line 831 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		req.begin = firstGreaterOrEqual(beginKey);
															#line 832 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		req.end = firstGreaterOrEqual(std::min<KeyRef>(shards[i].first.end, endKey));
															#line 833 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		req.limit = SERVER_KNOBS->MOVE_KEYS_KRM_LIMIT;
															#line 834 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		req.limitBytes = SERVER_KNOBS->MOVE_KEYS_KRM_LIMIT_BYTES;
															#line 835 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		req.version = version;
															#line 836 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		req.tags = TagSet();
															#line 841 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		keyValueFutures = std::vector<Future<ErrorOr<GetKeyValuesReply>>>();
															#line 842 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for( const auto& kv : shards[i].second ) {
															#line 843 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			resetReply(req);
															#line 844 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (SERVER_KNOBS->ENABLE_VERSION_VECTOR)
															#line 6554 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 845 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				cx->getLatestCommitVersion(kv, req.version, req.ssLatestCommitVersions);
															#line 6558 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			}
															#line 847 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			keyValueFutures.push_back(kv.getKeyValues.getReplyUnlessFailedFor(req, 2, 0));
															#line 6562 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 850 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<Void> __when_expr_2 = waitForAll(keyValueFutures);
															#line 850 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<FetchKeyValuesFromSSActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6568 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<FetchKeyValuesFromSSActor*>(this)->actor_wait_state = 3;
															#line 850 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< FetchKeyValuesFromSSActor, 2, Void >*>(static_cast<FetchKeyValuesFromSSActor*>(this)));
															#line 6573 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont3(Version && version,int loopDepth) 
	{
															#line 830 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		GetKeyValuesRequest req;
															#line 831 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		req.begin = firstGreaterOrEqual(beginKey);
															#line 832 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		req.end = firstGreaterOrEqual(std::min<KeyRef>(shards[i].first.end, endKey));
															#line 833 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		req.limit = SERVER_KNOBS->MOVE_KEYS_KRM_LIMIT;
															#line 834 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		req.limitBytes = SERVER_KNOBS->MOVE_KEYS_KRM_LIMIT_BYTES;
															#line 835 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		req.version = version;
															#line 836 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		req.tags = TagSet();
															#line 841 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		keyValueFutures = std::vector<Future<ErrorOr<GetKeyValuesReply>>>();
															#line 842 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for( const auto& kv : shards[i].second ) {
															#line 843 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			resetReply(req);
															#line 844 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (SERVER_KNOBS->ENABLE_VERSION_VECTOR)
															#line 6602 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 845 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				cx->getLatestCommitVersion(kv, req.version, req.ssLatestCommitVersions);
															#line 6606 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			}
															#line 847 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			keyValueFutures.push_back(kv.getKeyValues.getReplyUnlessFailedFor(req, 2, 0));
															#line 6610 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 850 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<Void> __when_expr_2 = waitForAll(keyValueFutures);
															#line 850 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<FetchKeyValuesFromSSActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6616 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<FetchKeyValuesFromSSActor*>(this)->actor_wait_state = 3;
															#line 850 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< FetchKeyValuesFromSSActor, 2, Void >*>(static_cast<FetchKeyValuesFromSSActor*>(this)));
															#line 6621 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when1(Version const& version,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont3(version, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when1(Version && version,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont3(std::move(version), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<FetchKeyValuesFromSSActor*>(this)->actor_wait_state > 0) static_cast<FetchKeyValuesFromSSActor*>(this)->actor_wait_state = 0;
		static_cast<FetchKeyValuesFromSSActor*>(this)->ActorCallback< FetchKeyValuesFromSSActor, 1, Version >::remove();

	}
	void a_callback_fire(ActorCallback< FetchKeyValuesFromSSActor, 1, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("fetchKeyValuesFromSS", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchKeyValuesFromSSActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchKeyValuesFromSS", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FetchKeyValuesFromSSActor, 1, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("fetchKeyValuesFromSS", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchKeyValuesFromSSActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchKeyValuesFromSS", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FetchKeyValuesFromSSActor, 1, Version >*,Error err) 
	{
		fdb_probe_actor_enter("fetchKeyValuesFromSS", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FetchKeyValuesFromSSActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchKeyValuesFromSS", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1loopBody1cont4(Void const& _,int loopDepth) 
	{
															#line 852 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		int firstValidStorageServer = -1;
															#line 855 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for(int j = 0;j < keyValueFutures.size();j++) {
															#line 856 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			ErrorOr<GetKeyValuesReply> reply = keyValueFutures[j].get();
															#line 858 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (!reply.present() || reply.get().error.present())
															#line 6711 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 860 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				if (self->performQuiescentChecks)
															#line 6715 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				{
															#line 861 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					TraceEvent("CacheConsistencyCheck_KeyServerUnavailable") .detail("StorageServer", shards[i].second[j].id().toString().c_str());
															#line 863 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					self->testFailure("Key server unavailable");
															#line 864 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					if (!static_cast<FetchKeyValuesFromSSActor*>(this)->SAV<bool>::futures) { (void)(false); this->~FetchKeyValuesFromSSActorState(); static_cast<FetchKeyValuesFromSSActor*>(this)->destroy(); return 0; }
															#line 6723 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
					new (&static_cast<FetchKeyValuesFromSSActor*>(this)->SAV< bool >::value()) bool(false);
					this->~FetchKeyValuesFromSSActorState();
					static_cast<FetchKeyValuesFromSSActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
				else
				{
															#line 868 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					if (firstValidStorageServer < 0 && j == keyValueFutures.size() - 1)
															#line 6733 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
					{
															#line 869 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						return a_body1cont1loopBody1loopBody1Catch1(all_alternatives_failed(), loopDepth);
															#line 6737 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
					}
				}
			}
			else
			{
															#line 873 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				if (firstValidStorageServer < 0)
															#line 6745 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				{
															#line 874 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					firstValidStorageServer = j;
															#line 6749 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				}
				else
				{
															#line 878 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					if (reply.get().data != keyValueFutures[firstValidStorageServer].get().get().data || reply.get().more != keyValueFutures[firstValidStorageServer].get().get().more)
															#line 6755 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
					{
															#line 880 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						TraceEvent("CacheConsistencyCheck_InconsistentKeyServers") .detail("StorageServer1", shards[i].second[firstValidStorageServer].id()) .detail("StorageServer2", shards[i].second[j].id());
															#line 883 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						self->testFailure("Key servers inconsistent", true);
															#line 884 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						if (!static_cast<FetchKeyValuesFromSSActor*>(this)->SAV<bool>::futures) { (void)(false); this->~FetchKeyValuesFromSSActorState(); static_cast<FetchKeyValuesFromSSActor*>(this)->destroy(); return 0; }
															#line 6763 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
						new (&static_cast<FetchKeyValuesFromSSActor*>(this)->SAV< bool >::value()) bool(false);
						this->~FetchKeyValuesFromSSActorState();
						static_cast<FetchKeyValuesFromSSActor*>(this)->finishSendAndDelPromiseRef();
						return 0;
					}
				}
			}
		}
															#line 888 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		auto keyValueResponse = keyValueFutures[firstValidStorageServer].get().get();
															#line 890 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for( const auto& kv : keyValueResponse.data ) {
															#line 891 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			result.push_back_deep( result.arena(), KeyValueRef(removePrefix ? kv.key.removePrefix(range.begin) : kv.key, kv.value));
															#line 6778 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 897 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		ASSERT(result.size() >= 1);
															#line 898 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!keyValueResponse.more)
															#line 6784 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 899 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			beginKey = shards[i].first.end;
															#line 6788 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
		else
		{
															#line 901 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			beginKey = keyAfter(keyValueResponse.data.end()[-1].key);
															#line 6794 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
		loopDepth = a_body1cont1loopBody1loopBody1cont20(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont4(Void && _,int loopDepth) 
	{
															#line 852 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		int firstValidStorageServer = -1;
															#line 855 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for(int j = 0;j < keyValueFutures.size();j++) {
															#line 856 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			ErrorOr<GetKeyValuesReply> reply = keyValueFutures[j].get();
															#line 858 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (!reply.present() || reply.get().error.present())
															#line 6810 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 860 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				if (self->performQuiescentChecks)
															#line 6814 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				{
															#line 861 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					TraceEvent("CacheConsistencyCheck_KeyServerUnavailable") .detail("StorageServer", shards[i].second[j].id().toString().c_str());
															#line 863 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					self->testFailure("Key server unavailable");
															#line 864 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					if (!static_cast<FetchKeyValuesFromSSActor*>(this)->SAV<bool>::futures) { (void)(false); this->~FetchKeyValuesFromSSActorState(); static_cast<FetchKeyValuesFromSSActor*>(this)->destroy(); return 0; }
															#line 6822 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
					new (&static_cast<FetchKeyValuesFromSSActor*>(this)->SAV< bool >::value()) bool(false);
					this->~FetchKeyValuesFromSSActorState();
					static_cast<FetchKeyValuesFromSSActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
				else
				{
															#line 868 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					if (firstValidStorageServer < 0 && j == keyValueFutures.size() - 1)
															#line 6832 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
					{
															#line 869 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						return a_body1cont1loopBody1loopBody1Catch1(all_alternatives_failed(), loopDepth);
															#line 6836 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
					}
				}
			}
			else
			{
															#line 873 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				if (firstValidStorageServer < 0)
															#line 6844 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				{
															#line 874 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					firstValidStorageServer = j;
															#line 6848 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				}
				else
				{
															#line 878 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					if (reply.get().data != keyValueFutures[firstValidStorageServer].get().get().data || reply.get().more != keyValueFutures[firstValidStorageServer].get().get().more)
															#line 6854 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
					{
															#line 880 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						TraceEvent("CacheConsistencyCheck_InconsistentKeyServers") .detail("StorageServer1", shards[i].second[firstValidStorageServer].id()) .detail("StorageServer2", shards[i].second[j].id());
															#line 883 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						self->testFailure("Key servers inconsistent", true);
															#line 884 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						if (!static_cast<FetchKeyValuesFromSSActor*>(this)->SAV<bool>::futures) { (void)(false); this->~FetchKeyValuesFromSSActorState(); static_cast<FetchKeyValuesFromSSActor*>(this)->destroy(); return 0; }
															#line 6862 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
						new (&static_cast<FetchKeyValuesFromSSActor*>(this)->SAV< bool >::value()) bool(false);
						this->~FetchKeyValuesFromSSActorState();
						static_cast<FetchKeyValuesFromSSActor*>(this)->finishSendAndDelPromiseRef();
						return 0;
					}
				}
			}
		}
															#line 888 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		auto keyValueResponse = keyValueFutures[firstValidStorageServer].get().get();
															#line 890 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for( const auto& kv : keyValueResponse.data ) {
															#line 891 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			result.push_back_deep( result.arena(), KeyValueRef(removePrefix ? kv.key.removePrefix(range.begin) : kv.key, kv.value));
															#line 6877 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 897 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		ASSERT(result.size() >= 1);
															#line 898 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!keyValueResponse.more)
															#line 6883 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 899 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			beginKey = shards[i].first.end;
															#line 6887 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
		else
		{
															#line 901 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			beginKey = keyAfter(keyValueResponse.data.end()[-1].key);
															#line 6893 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
		loopDepth = a_body1cont1loopBody1loopBody1cont20(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<FetchKeyValuesFromSSActor*>(this)->actor_wait_state > 0) static_cast<FetchKeyValuesFromSSActor*>(this)->actor_wait_state = 0;
		static_cast<FetchKeyValuesFromSSActor*>(this)->ActorCallback< FetchKeyValuesFromSSActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FetchKeyValuesFromSSActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fetchKeyValuesFromSS", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchKeyValuesFromSSActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchKeyValuesFromSS", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< FetchKeyValuesFromSSActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fetchKeyValuesFromSS", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchKeyValuesFromSSActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchKeyValuesFromSS", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< FetchKeyValuesFromSSActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fetchKeyValuesFromSS", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FetchKeyValuesFromSSActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchKeyValuesFromSS", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1loopBody1cont20(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1loopBody1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
															#line 906 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		TraceEvent("CacheConsistencyCheck_RetryGetKeyLocations").error(err);
															#line 6991 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
															#line 906 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		TraceEvent("CacheConsistencyCheck_RetryGetKeyLocations").error(err);
															#line 7000 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<FetchKeyValuesFromSSActor*>(this)->actor_wait_state > 0) static_cast<FetchKeyValuesFromSSActor*>(this)->actor_wait_state = 0;
		static_cast<FetchKeyValuesFromSSActor*>(this)->ActorCallback< FetchKeyValuesFromSSActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FetchKeyValuesFromSSActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fetchKeyValuesFromSS", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchKeyValuesFromSSActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchKeyValuesFromSS", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< FetchKeyValuesFromSSActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fetchKeyValuesFromSS", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchKeyValuesFromSSActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchKeyValuesFromSS", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< FetchKeyValuesFromSSActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fetchKeyValuesFromSS", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FetchKeyValuesFromSSActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchKeyValuesFromSS", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 802 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Database cx;
															#line 802 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	ConsistencyCheckWorkload* self;
															#line 802 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	KeyRangeRef range;
															#line 802 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Promise<Standalone<VectorRef<KeyValueRef>>> resultPromise;
															#line 802 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	bool removePrefix;
															#line 808 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Promise<std::vector<std::pair<KeyRange, std::vector<StorageServerInterface>>>> keyServerPromise;
															#line 813 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	std::vector<std::pair<KeyRange, std::vector<StorageServerInterface>>> shards;
															#line 817 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Standalone<VectorRef<KeyValueRef>> result;
															#line 818 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Key beginKey;
															#line 819 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Key endKey;
															#line 820 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	int i;
															#line 821 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Transaction onErrorTr;
															#line 841 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	std::vector<Future<ErrorOr<GetKeyValuesReply>>> keyValueFutures;
															#line 904 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Error err;
															#line 7108 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
};
// This generated class is to be used only via fetchKeyValuesFromSS()
															#line 802 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
class FetchKeyValuesFromSSActor final : public Actor<bool>, public ActorCallback< FetchKeyValuesFromSSActor, 0, bool >, public ActorCallback< FetchKeyValuesFromSSActor, 1, Version >, public ActorCallback< FetchKeyValuesFromSSActor, 2, Void >, public ActorCallback< FetchKeyValuesFromSSActor, 3, Void >, public FastAllocated<FetchKeyValuesFromSSActor>, public FetchKeyValuesFromSSActorState<FetchKeyValuesFromSSActor> {
															#line 7113 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
public:
	using FastAllocated<FetchKeyValuesFromSSActor>::operator new;
	using FastAllocated<FetchKeyValuesFromSSActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16239911758922492928UL, 12403177062017033984UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FetchKeyValuesFromSSActor, 0, bool >;
friend struct ActorCallback< FetchKeyValuesFromSSActor, 1, Version >;
friend struct ActorCallback< FetchKeyValuesFromSSActor, 2, Void >;
friend struct ActorCallback< FetchKeyValuesFromSSActor, 3, Void >;
															#line 802 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	FetchKeyValuesFromSSActor(Database const& cx,ConsistencyCheckWorkload* const& self,KeyRangeRef const& range,Promise<Standalone<VectorRef<KeyValueRef>>> const& resultPromise,bool const& removePrefix) 
															#line 7133 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		 : Actor<bool>(),
		   FetchKeyValuesFromSSActorState<FetchKeyValuesFromSSActor>(cx, self, range, resultPromise, removePrefix),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("fetchKeyValuesFromSS", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1813994210122685440UL, 2419768122244924160UL);
		ActorExecutionContextHelper __helper(static_cast<FetchKeyValuesFromSSActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("fetchKeyValuesFromSS");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("fetchKeyValuesFromSS", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FetchKeyValuesFromSSActor, 0, bool >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< FetchKeyValuesFromSSActor, 1, Version >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< FetchKeyValuesFromSSActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< FetchKeyValuesFromSSActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 802 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
[[nodiscard]] Future<bool> fetchKeyValuesFromSS( Database const& cx, ConsistencyCheckWorkload* const& self, KeyRangeRef const& range, Promise<Standalone<VectorRef<KeyValueRef>>> const& resultPromise, bool const& removePrefix ) {
															#line 802 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	return Future<bool>(new FetchKeyValuesFromSSActor(cx, self, range, resultPromise, removePrefix));
															#line 7168 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
}

#line 914 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"

	// Comparison function used to compare map elements by value
	template <class K, class T>
	static bool compareByValue(std::pair<K, T> a, std::pair<K, T> b) {
		return a.second < b.second;
	}

	// Returns true if any storage servers have the exact same network address or are not using the correct key value
	// store type
																#line 7181 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
// This generated class is to be used only via checkForUndesirableServers()
															#line 923 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
template <class CheckForUndesirableServersActor>
															#line 923 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
class CheckForUndesirableServersActorState {
															#line 7187 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
public:
															#line 923 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	CheckForUndesirableServersActorState(Database const& cx,DatabaseConfiguration const& configuration,ConsistencyCheckWorkload* const& self) 
															#line 923 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
															#line 923 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		 : cx(cx),
															#line 923 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		   configuration(configuration),
															#line 923 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		   self(self),
															#line 926 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		   i(),
															#line 927 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		   j()
															#line 7202 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
	{
		fdb_probe_actor_create("checkForUndesirableServers", reinterpret_cast<unsigned long>(this));

	}
	~CheckForUndesirableServersActorState() 
	{
		fdb_probe_actor_destroy("checkForUndesirableServers", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 928 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			StrictFuture<std::vector<StorageServerInterface>> __when_expr_0 = getStorageServers(cx);
															#line 928 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (static_cast<CheckForUndesirableServersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7219 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CheckForUndesirableServersActor*>(this)->actor_wait_state = 1;
															#line 928 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckForUndesirableServersActor, 0, std::vector<StorageServerInterface> >*>(static_cast<CheckForUndesirableServersActor*>(this)));
															#line 7224 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckForUndesirableServersActorState();
		static_cast<CheckForUndesirableServersActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 929 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		wiggleLocalityKeyValue = configuration.perpetualStorageWiggleLocality;
															#line 930 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		wiggleLocalityKeyValues = ParsePerpetualStorageWiggleLocality(configuration.perpetualStorageWiggleLocality);
															#line 934 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		i = 0;
															#line 7251 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<StorageServerInterface> const& __storageServers,int loopDepth) 
	{
															#line 928 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		storageServers = __storageServers;
															#line 7260 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<StorageServerInterface> && __storageServers,int loopDepth) 
	{
		storageServers = std::move(__storageServers);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckForUndesirableServersActor*>(this)->actor_wait_state > 0) static_cast<CheckForUndesirableServersActor*>(this)->actor_wait_state = 0;
		static_cast<CheckForUndesirableServersActor*>(this)->ActorCallback< CheckForUndesirableServersActor, 0, std::vector<StorageServerInterface> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckForUndesirableServersActor, 0, std::vector<StorageServerInterface> >*,std::vector<StorageServerInterface> const& value) 
	{
		fdb_probe_actor_enter("checkForUndesirableServers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForUndesirableServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkForUndesirableServers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckForUndesirableServersActor, 0, std::vector<StorageServerInterface> >*,std::vector<StorageServerInterface> && value) 
	{
		fdb_probe_actor_enter("checkForUndesirableServers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForUndesirableServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkForUndesirableServers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckForUndesirableServersActor, 0, std::vector<StorageServerInterface> >*,Error err) 
	{
		fdb_probe_actor_enter("checkForUndesirableServers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForUndesirableServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkForUndesirableServers", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 997 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!static_cast<CheckForUndesirableServersActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckForUndesirableServersActorState(); static_cast<CheckForUndesirableServersActor*>(this)->destroy(); return 0; }
															#line 7339 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		new (&static_cast<CheckForUndesirableServersActor*>(this)->SAV< bool >::value()) bool(false);
		this->~CheckForUndesirableServersActorState();
		static_cast<CheckForUndesirableServersActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 934 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!(i < storageServers.size()))
															#line 7358 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 936 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		ReplyPromise<KeyValueStoreType> typeReply;
															#line 937 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<ErrorOr<KeyValueStoreType>> __when_expr_1 = storageServers[i].getKeyValueStoreType.getReplyUnlessFailedFor(typeReply, 2, 0);
															#line 937 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<CheckForUndesirableServersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7368 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CheckForUndesirableServersActor*>(this)->actor_wait_state = 2;
															#line 937 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckForUndesirableServersActor, 1, ErrorOr<KeyValueStoreType> >*>(static_cast<CheckForUndesirableServersActor*>(this)));
															#line 7373 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(ErrorOr<KeyValueStoreType> const& keyValueStoreType,int loopDepth) 
	{
															#line 940 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!keyValueStoreType.present())
															#line 7395 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 941 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent("ConsistencyCheck_ServerUnavailable").detail("ServerID", storageServers[i].id());
															#line 942 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			self->testFailure("Storage server unavailable");
															#line 7401 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
		else
		{
															#line 943 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (configuration.perpetualStoreType.isValid())
															#line 7407 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 946 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				if (wiggleLocalityKeyValue == "0" || localityMatchInList(wiggleLocalityKeyValues, storageServers[i].locality))
															#line 7411 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				{
															#line 948 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					if (keyValueStoreType.get() != configuration.perpetualStoreType)
															#line 7415 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
					{
															#line 949 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						TraceEvent("ConsistencyCheck_WrongKeyValueStoreType") .detail("ServerID", storageServers[i].id()) .detail("StoreType", keyValueStoreType.get().toString()) .detail("DesiredType", configuration.perpetualStoreType.toString()) .detail("IsPerpetualStoreType", true);
															#line 954 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						self->testFailure("Storage server has wrong key-value store type");
															#line 955 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						if (!static_cast<CheckForUndesirableServersActor*>(this)->SAV<bool>::futures) { (void)(true); this->~CheckForUndesirableServersActorState(); static_cast<CheckForUndesirableServersActor*>(this)->destroy(); return 0; }
															#line 7423 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
						new (&static_cast<CheckForUndesirableServersActor*>(this)->SAV< bool >::value()) bool(true);
						this->~CheckForUndesirableServersActorState();
						static_cast<CheckForUndesirableServersActor*>(this)->finishSendAndDelPromiseRef();
						return 0;
					}
				}
				else
				{
															#line 957 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					if ((!storageServers[i].isTss() && keyValueStoreType.get() != configuration.storageServerStoreType) || (storageServers[i].isTss() && keyValueStoreType.get() != configuration.testingStorageServerStoreType))
															#line 7434 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
					{
															#line 961 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						TraceEvent("ConsistencyCheck_WrongKeyValueStoreType") .detail("ServerID", storageServers[i].id()) .detail("StoreType", keyValueStoreType.get().toString()) .detail("DesiredType", configuration.perpetualStoreType.toString()) .detail("IsPerpetualStoreType", false);
															#line 966 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						self->testFailure("Storage server has wrong key-value store type");
															#line 967 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						if (!static_cast<CheckForUndesirableServersActor*>(this)->SAV<bool>::futures) { (void)(true); this->~CheckForUndesirableServersActorState(); static_cast<CheckForUndesirableServersActor*>(this)->destroy(); return 0; }
															#line 7442 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
						new (&static_cast<CheckForUndesirableServersActor*>(this)->SAV< bool >::value()) bool(true);
						this->~CheckForUndesirableServersActorState();
						static_cast<CheckForUndesirableServersActor*>(this)->finishSendAndDelPromiseRef();
						return 0;
					}
				}
			}
			else
			{
															#line 969 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				if (((!storageServers[i].isTss() && keyValueStoreType.get() != configuration.storageServerStoreType) || (storageServers[i].isTss() && keyValueStoreType.get() != configuration.testingStorageServerStoreType)) && (wiggleLocalityKeyValue == "0" || localityMatchInList(wiggleLocalityKeyValues, storageServers[i].locality)))
															#line 7454 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				{
															#line 975 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					TraceEvent("ConsistencyCheck_WrongKeyValueStoreType") .detail("ServerID", storageServers[i].id()) .detail("StoreType", keyValueStoreType.get().toString()) .detail("DesiredType", configuration.storageServerStoreType.toString()) .detail("IsPerpetualStoreType", false);
															#line 980 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					self->testFailure("Storage server has wrong key-value store type");
															#line 981 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					if (!static_cast<CheckForUndesirableServersActor*>(this)->SAV<bool>::futures) { (void)(true); this->~CheckForUndesirableServersActorState(); static_cast<CheckForUndesirableServersActor*>(this)->destroy(); return 0; }
															#line 7462 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
					new (&static_cast<CheckForUndesirableServersActor*>(this)->SAV< bool >::value()) bool(true);
					this->~CheckForUndesirableServersActorState();
					static_cast<CheckForUndesirableServersActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
			}
		}
															#line 985 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for(j = i + 1;j < storageServers.size();j++) {
															#line 986 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (storageServers[i].address() == storageServers[j].address())
															#line 7474 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 987 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				TraceEvent("ConsistencyCheck_UndesirableServer") .detail("StorageServer1", storageServers[i].id()) .detail("StorageServer2", storageServers[j].id()) .detail("Address", storageServers[i].address());
															#line 991 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				self->testFailure("Multiple storage servers have the same address");
															#line 992 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				if (!static_cast<CheckForUndesirableServersActor*>(this)->SAV<bool>::futures) { (void)(true); this->~CheckForUndesirableServersActorState(); static_cast<CheckForUndesirableServersActor*>(this)->destroy(); return 0; }
															#line 7482 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				new (&static_cast<CheckForUndesirableServersActor*>(this)->SAV< bool >::value()) bool(true);
				this->~CheckForUndesirableServersActorState();
				static_cast<CheckForUndesirableServersActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 934 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		i++;
															#line 7491 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(ErrorOr<KeyValueStoreType> && keyValueStoreType,int loopDepth) 
	{
															#line 940 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!keyValueStoreType.present())
															#line 7500 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 941 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent("ConsistencyCheck_ServerUnavailable").detail("ServerID", storageServers[i].id());
															#line 942 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			self->testFailure("Storage server unavailable");
															#line 7506 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
		else
		{
															#line 943 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (configuration.perpetualStoreType.isValid())
															#line 7512 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 946 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				if (wiggleLocalityKeyValue == "0" || localityMatchInList(wiggleLocalityKeyValues, storageServers[i].locality))
															#line 7516 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				{
															#line 948 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					if (keyValueStoreType.get() != configuration.perpetualStoreType)
															#line 7520 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
					{
															#line 949 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						TraceEvent("ConsistencyCheck_WrongKeyValueStoreType") .detail("ServerID", storageServers[i].id()) .detail("StoreType", keyValueStoreType.get().toString()) .detail("DesiredType", configuration.perpetualStoreType.toString()) .detail("IsPerpetualStoreType", true);
															#line 954 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						self->testFailure("Storage server has wrong key-value store type");
															#line 955 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						if (!static_cast<CheckForUndesirableServersActor*>(this)->SAV<bool>::futures) { (void)(true); this->~CheckForUndesirableServersActorState(); static_cast<CheckForUndesirableServersActor*>(this)->destroy(); return 0; }
															#line 7528 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
						new (&static_cast<CheckForUndesirableServersActor*>(this)->SAV< bool >::value()) bool(true);
						this->~CheckForUndesirableServersActorState();
						static_cast<CheckForUndesirableServersActor*>(this)->finishSendAndDelPromiseRef();
						return 0;
					}
				}
				else
				{
															#line 957 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					if ((!storageServers[i].isTss() && keyValueStoreType.get() != configuration.storageServerStoreType) || (storageServers[i].isTss() && keyValueStoreType.get() != configuration.testingStorageServerStoreType))
															#line 7539 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
					{
															#line 961 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						TraceEvent("ConsistencyCheck_WrongKeyValueStoreType") .detail("ServerID", storageServers[i].id()) .detail("StoreType", keyValueStoreType.get().toString()) .detail("DesiredType", configuration.perpetualStoreType.toString()) .detail("IsPerpetualStoreType", false);
															#line 966 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						self->testFailure("Storage server has wrong key-value store type");
															#line 967 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						if (!static_cast<CheckForUndesirableServersActor*>(this)->SAV<bool>::futures) { (void)(true); this->~CheckForUndesirableServersActorState(); static_cast<CheckForUndesirableServersActor*>(this)->destroy(); return 0; }
															#line 7547 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
						new (&static_cast<CheckForUndesirableServersActor*>(this)->SAV< bool >::value()) bool(true);
						this->~CheckForUndesirableServersActorState();
						static_cast<CheckForUndesirableServersActor*>(this)->finishSendAndDelPromiseRef();
						return 0;
					}
				}
			}
			else
			{
															#line 969 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				if (((!storageServers[i].isTss() && keyValueStoreType.get() != configuration.storageServerStoreType) || (storageServers[i].isTss() && keyValueStoreType.get() != configuration.testingStorageServerStoreType)) && (wiggleLocalityKeyValue == "0" || localityMatchInList(wiggleLocalityKeyValues, storageServers[i].locality)))
															#line 7559 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				{
															#line 975 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					TraceEvent("ConsistencyCheck_WrongKeyValueStoreType") .detail("ServerID", storageServers[i].id()) .detail("StoreType", keyValueStoreType.get().toString()) .detail("DesiredType", configuration.storageServerStoreType.toString()) .detail("IsPerpetualStoreType", false);
															#line 980 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					self->testFailure("Storage server has wrong key-value store type");
															#line 981 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					if (!static_cast<CheckForUndesirableServersActor*>(this)->SAV<bool>::futures) { (void)(true); this->~CheckForUndesirableServersActorState(); static_cast<CheckForUndesirableServersActor*>(this)->destroy(); return 0; }
															#line 7567 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
					new (&static_cast<CheckForUndesirableServersActor*>(this)->SAV< bool >::value()) bool(true);
					this->~CheckForUndesirableServersActorState();
					static_cast<CheckForUndesirableServersActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
			}
		}
															#line 985 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for(j = i + 1;j < storageServers.size();j++) {
															#line 986 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (storageServers[i].address() == storageServers[j].address())
															#line 7579 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 987 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				TraceEvent("ConsistencyCheck_UndesirableServer") .detail("StorageServer1", storageServers[i].id()) .detail("StorageServer2", storageServers[j].id()) .detail("Address", storageServers[i].address());
															#line 991 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				self->testFailure("Multiple storage servers have the same address");
															#line 992 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				if (!static_cast<CheckForUndesirableServersActor*>(this)->SAV<bool>::futures) { (void)(true); this->~CheckForUndesirableServersActorState(); static_cast<CheckForUndesirableServersActor*>(this)->destroy(); return 0; }
															#line 7587 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				new (&static_cast<CheckForUndesirableServersActor*>(this)->SAV< bool >::value()) bool(true);
				this->~CheckForUndesirableServersActorState();
				static_cast<CheckForUndesirableServersActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 934 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		i++;
															#line 7596 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(ErrorOr<KeyValueStoreType> const& keyValueStoreType,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(keyValueStoreType, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(ErrorOr<KeyValueStoreType> && keyValueStoreType,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(std::move(keyValueStoreType), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CheckForUndesirableServersActor*>(this)->actor_wait_state > 0) static_cast<CheckForUndesirableServersActor*>(this)->actor_wait_state = 0;
		static_cast<CheckForUndesirableServersActor*>(this)->ActorCallback< CheckForUndesirableServersActor, 1, ErrorOr<KeyValueStoreType> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckForUndesirableServersActor, 1, ErrorOr<KeyValueStoreType> >*,ErrorOr<KeyValueStoreType> const& value) 
	{
		fdb_probe_actor_enter("checkForUndesirableServers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForUndesirableServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkForUndesirableServers", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CheckForUndesirableServersActor, 1, ErrorOr<KeyValueStoreType> >*,ErrorOr<KeyValueStoreType> && value) 
	{
		fdb_probe_actor_enter("checkForUndesirableServers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForUndesirableServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkForUndesirableServers", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CheckForUndesirableServersActor, 1, ErrorOr<KeyValueStoreType> >*,Error err) 
	{
		fdb_probe_actor_enter("checkForUndesirableServers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForUndesirableServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkForUndesirableServers", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 923 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Database cx;
															#line 923 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	DatabaseConfiguration configuration;
															#line 923 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	ConsistencyCheckWorkload* self;
															#line 926 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	int i;
															#line 927 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	int j;
															#line 928 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	std::vector<StorageServerInterface> storageServers;
															#line 929 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	std::string wiggleLocalityKeyValue;
															#line 930 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	std::vector<std::pair<Optional<Value>, Optional<Value>>> wiggleLocalityKeyValues;
															#line 7692 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
};
// This generated class is to be used only via checkForUndesirableServers()
															#line 923 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
class CheckForUndesirableServersActor final : public Actor<bool>, public ActorCallback< CheckForUndesirableServersActor, 0, std::vector<StorageServerInterface> >, public ActorCallback< CheckForUndesirableServersActor, 1, ErrorOr<KeyValueStoreType> >, public FastAllocated<CheckForUndesirableServersActor>, public CheckForUndesirableServersActorState<CheckForUndesirableServersActor> {
															#line 7697 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
public:
	using FastAllocated<CheckForUndesirableServersActor>::operator new;
	using FastAllocated<CheckForUndesirableServersActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(786430635916577792UL, 9039068970435493632UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckForUndesirableServersActor, 0, std::vector<StorageServerInterface> >;
friend struct ActorCallback< CheckForUndesirableServersActor, 1, ErrorOr<KeyValueStoreType> >;
															#line 923 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	CheckForUndesirableServersActor(Database const& cx,DatabaseConfiguration const& configuration,ConsistencyCheckWorkload* const& self) 
															#line 7715 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		 : Actor<bool>(),
		   CheckForUndesirableServersActorState<CheckForUndesirableServersActor>(cx, configuration, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkForUndesirableServers", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11876187790522090240UL, 13735064405301590272UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForUndesirableServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkForUndesirableServers");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkForUndesirableServers", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckForUndesirableServersActor, 0, std::vector<StorageServerInterface> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CheckForUndesirableServersActor, 1, ErrorOr<KeyValueStoreType> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 923 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
[[nodiscard]] Future<bool> checkForUndesirableServers( Database const& cx, DatabaseConfiguration const& configuration, ConsistencyCheckWorkload* const& self ) {
															#line 923 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	return Future<bool>(new CheckForUndesirableServersActor(cx, configuration, self));
															#line 7748 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
}

#line 999 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"

	// Every storage server should have it metadata populated and no metadata leak when the database reach the quiescent
	// state
																#line 7755 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
// This generated class is to be used only via checkStorageMetadata()
															#line 1002 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
template <class CheckStorageMetadataActor>
															#line 1002 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
class CheckStorageMetadataActorState {
															#line 7761 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
public:
															#line 1002 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	CheckStorageMetadataActorState(Database const& cx,ConsistencyCheckWorkload* const& self) 
															#line 1002 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
															#line 1002 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		 : cx(cx),
															#line 1002 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		   self(self),
															#line 1003 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		   metadataMap(serverMetadataKeys.begin, IncludeVersion()),
															#line 1005 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		   servers(),
															#line 1006 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		   id_ssi(),
															#line 1007 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		   tr(cx)
															#line 7778 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
	{
		fdb_probe_actor_create("checkStorageMetadata", reinterpret_cast<unsigned long>(this));

	}
	~CheckStorageMetadataActorState() 
	{
		fdb_probe_actor_destroy("checkStorageMetadata", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1008 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			;
															#line 7793 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckStorageMetadataActorState();
		static_cast<CheckStorageMetadataActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1030 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for( auto& ssi : servers ) {
															#line 1031 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			ASSERT(id_ssi.contains(ssi.id()));
															#line 7818 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 1033 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!static_cast<CheckStorageMetadataActor*>(this)->SAV<bool>::futures) { (void)(true); this->~CheckStorageMetadataActorState(); static_cast<CheckStorageMetadataActor*>(this)->destroy(); return 0; }
															#line 7822 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		new (&static_cast<CheckStorageMetadataActor*>(this)->SAV< bool >::value()) bool(true);
		this->~CheckStorageMetadataActorState();
		static_cast<CheckStorageMetadataActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1009 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		servers.clear();
															#line 1010 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		id_ssi.clear();
															#line 1011 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 1012 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 7847 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		try {
															#line 1014 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			StrictFuture<KeyBackedRangeResult<std::pair<UID, StorageMetadataType>>> __when_expr_0 = metadataMap.getRange(&tr, {}, {}, CLIENT_KNOBS->TOO_MANY);
															#line 1014 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (static_cast<CheckStorageMetadataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7853 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CheckStorageMetadataActor*>(this)->actor_wait_state = 1;
															#line 1014 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckStorageMetadataActor, 0, KeyBackedRangeResult<std::pair<UID, StorageMetadataType>> >*>(static_cast<CheckStorageMetadataActor*>(this)));
															#line 7858 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1026 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 1026 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (static_cast<CheckStorageMetadataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7895 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<CheckStorageMetadataActor*>(this)->actor_wait_state = 3;
															#line 1026 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CheckStorageMetadataActor, 2, Void >*>(static_cast<CheckStorageMetadataActor*>(this)));
															#line 7900 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 1016 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		ASSERT(!metadata.more && metadata.results.size() < CLIENT_KNOBS->TOO_MANY);
															#line 1017 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<RangeResult> __when_expr_1 = tr.getRange(serverListKeys, CLIENT_KNOBS->TOO_MANY);
															#line 1017 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<CheckStorageMetadataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7919 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<CheckStorageMetadataActor*>(this)->actor_wait_state = 2;
															#line 1017 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckStorageMetadataActor, 1, RangeResult >*>(static_cast<CheckStorageMetadataActor*>(this)));
															#line 7924 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(KeyBackedRangeResult<std::pair<UID, StorageMetadataType>> const& __metadata,int loopDepth) 
	{
															#line 1014 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		metadata = __metadata;
															#line 7933 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(KeyBackedRangeResult<std::pair<UID, StorageMetadataType>> && __metadata,int loopDepth) 
	{
		metadata = std::move(__metadata);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckStorageMetadataActor*>(this)->actor_wait_state > 0) static_cast<CheckStorageMetadataActor*>(this)->actor_wait_state = 0;
		static_cast<CheckStorageMetadataActor*>(this)->ActorCallback< CheckStorageMetadataActor, 0, KeyBackedRangeResult<std::pair<UID, StorageMetadataType>> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckStorageMetadataActor, 0, KeyBackedRangeResult<std::pair<UID, StorageMetadataType>> >*,KeyBackedRangeResult<std::pair<UID, StorageMetadataType>> const& value) 
	{
		fdb_probe_actor_enter("checkStorageMetadata", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkStorageMetadata", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckStorageMetadataActor, 0, KeyBackedRangeResult<std::pair<UID, StorageMetadataType>> >*,KeyBackedRangeResult<std::pair<UID, StorageMetadataType>> && value) 
	{
		fdb_probe_actor_enter("checkStorageMetadata", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkStorageMetadata", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckStorageMetadataActor, 0, KeyBackedRangeResult<std::pair<UID, StorageMetadataType>> >*,Error err) 
	{
		fdb_probe_actor_enter("checkStorageMetadata", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkStorageMetadata", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(RangeResult const& serverList,int loopDepth) 
	{
															#line 1018 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		ASSERT(!serverList.more && serverList.size() < CLIENT_KNOBS->TOO_MANY);
															#line 1019 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		ASSERT_EQ(metadata.results.size(), serverList.size());
															#line 1020 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		id_ssi = std::unordered_map<UID, StorageMetadataType>(metadata.results.begin(), metadata.results.end());
															#line 1021 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		servers.reserve(serverList.size());
															#line 1022 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for(int i = 0;i < serverList.size();i++) {
															#line 1023 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			servers.push_back(decodeServerListValue(serverList[i].value));
															#line 8022 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont3(RangeResult && serverList,int loopDepth) 
	{
															#line 1018 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		ASSERT(!serverList.more && serverList.size() < CLIENT_KNOBS->TOO_MANY);
															#line 1019 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		ASSERT_EQ(metadata.results.size(), serverList.size());
															#line 1020 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		id_ssi = std::unordered_map<UID, StorageMetadataType>(metadata.results.begin(), metadata.results.end());
															#line 1021 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		servers.reserve(serverList.size());
															#line 1022 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for(int i = 0;i < serverList.size();i++) {
															#line 1023 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			servers.push_back(decodeServerListValue(serverList[i].value));
															#line 8042 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(RangeResult const& serverList,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(serverList, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(RangeResult && serverList,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(serverList), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CheckStorageMetadataActor*>(this)->actor_wait_state > 0) static_cast<CheckStorageMetadataActor*>(this)->actor_wait_state = 0;
		static_cast<CheckStorageMetadataActor*>(this)->ActorCallback< CheckStorageMetadataActor, 1, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< CheckStorageMetadataActor, 1, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("checkStorageMetadata", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkStorageMetadata", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CheckStorageMetadataActor, 1, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("checkStorageMetadata", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkStorageMetadata", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CheckStorageMetadataActor, 1, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("checkStorageMetadata", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkStorageMetadata", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CheckStorageMetadataActor*>(this)->actor_wait_state > 0) static_cast<CheckStorageMetadataActor*>(this)->actor_wait_state = 0;
		static_cast<CheckStorageMetadataActor*>(this)->ActorCallback< CheckStorageMetadataActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckStorageMetadataActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkStorageMetadata", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkStorageMetadata", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CheckStorageMetadataActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkStorageMetadata", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkStorageMetadata", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CheckStorageMetadataActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkStorageMetadata", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkStorageMetadata", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 1002 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Database cx;
															#line 1002 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	ConsistencyCheckWorkload* self;
															#line 1003 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	KeyBackedObjectMap<UID, StorageMetadataType, decltype(IncludeVersion())> metadataMap;
															#line 1005 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	std::vector<StorageServerInterface> servers;
															#line 1006 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	std::unordered_map<UID, StorageMetadataType> id_ssi;
															#line 1007 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Transaction tr;
															#line 1014 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	KeyBackedRangeResult<std::pair<UID, StorageMetadataType>> metadata;
															#line 8224 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
};
// This generated class is to be used only via checkStorageMetadata()
															#line 1002 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
class CheckStorageMetadataActor final : public Actor<bool>, public ActorCallback< CheckStorageMetadataActor, 0, KeyBackedRangeResult<std::pair<UID, StorageMetadataType>> >, public ActorCallback< CheckStorageMetadataActor, 1, RangeResult >, public ActorCallback< CheckStorageMetadataActor, 2, Void >, public FastAllocated<CheckStorageMetadataActor>, public CheckStorageMetadataActorState<CheckStorageMetadataActor> {
															#line 8229 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
public:
	using FastAllocated<CheckStorageMetadataActor>::operator new;
	using FastAllocated<CheckStorageMetadataActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6625923800726519296UL, 8154070523363283200UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckStorageMetadataActor, 0, KeyBackedRangeResult<std::pair<UID, StorageMetadataType>> >;
friend struct ActorCallback< CheckStorageMetadataActor, 1, RangeResult >;
friend struct ActorCallback< CheckStorageMetadataActor, 2, Void >;
															#line 1002 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	CheckStorageMetadataActor(Database const& cx,ConsistencyCheckWorkload* const& self) 
															#line 8248 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		 : Actor<bool>(),
		   CheckStorageMetadataActorState<CheckStorageMetadataActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkStorageMetadata", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14773869242612564736UL, 6352906758137099520UL);
		ActorExecutionContextHelper __helper(static_cast<CheckStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkStorageMetadata");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkStorageMetadata", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckStorageMetadataActor, 0, KeyBackedRangeResult<std::pair<UID, StorageMetadataType>> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CheckStorageMetadataActor, 1, RangeResult >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CheckStorageMetadataActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1002 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
[[nodiscard]] Future<bool> checkStorageMetadata( Database const& cx, ConsistencyCheckWorkload* const& self ) {
															#line 1002 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	return Future<bool>(new CheckStorageMetadataActor(cx, self));
															#line 8282 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
}

#line 1035 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"

	// Returns false if any worker that should have a storage server does not have one
																#line 8288 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
// This generated class is to be used only via checkForStorage()
															#line 1037 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
template <class CheckForStorageActor>
															#line 1037 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
class CheckForStorageActorState {
															#line 8294 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
public:
															#line 1037 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	CheckForStorageActorState(Database const& cx,DatabaseConfiguration const& configuration,std::map<UID, StorageServerInterface> const& tssMapping,ConsistencyCheckWorkload* const& self) 
															#line 1037 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
															#line 1037 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		 : cx(cx),
															#line 1037 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		   configuration(configuration),
															#line 1037 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		   tssMapping(tssMapping),
															#line 1037 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		   self(self)
															#line 8307 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
	{
		fdb_probe_actor_create("checkForStorage", reinterpret_cast<unsigned long>(this));

	}
	~CheckForStorageActorState() 
	{
		fdb_probe_actor_destroy("checkForStorage", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1041 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			StrictFuture<std::vector<WorkerDetails>> __when_expr_0 = getWorkers(self->dbInfo);
															#line 1041 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (static_cast<CheckForStorageActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8324 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CheckForStorageActor*>(this)->actor_wait_state = 1;
															#line 1041 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckForStorageActor, 0, std::vector<WorkerDetails> >*>(static_cast<CheckForStorageActor*>(this)));
															#line 8329 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckForStorageActorState();
		static_cast<CheckForStorageActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1042 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<std::vector<StorageServerInterface>> __when_expr_1 = getStorageServers(cx);
															#line 1042 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<CheckForStorageActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8354 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CheckForStorageActor*>(this)->actor_wait_state = 2;
															#line 1042 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckForStorageActor, 1, std::vector<StorageServerInterface> >*>(static_cast<CheckForStorageActor*>(this)));
															#line 8359 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(std::vector<WorkerDetails> const& __workers,int loopDepth) 
	{
															#line 1041 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		workers = __workers;
															#line 8368 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<WorkerDetails> && __workers,int loopDepth) 
	{
		workers = std::move(__workers);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckForStorageActor*>(this)->actor_wait_state > 0) static_cast<CheckForStorageActor*>(this)->actor_wait_state = 0;
		static_cast<CheckForStorageActor*>(this)->ActorCallback< CheckForStorageActor, 0, std::vector<WorkerDetails> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckForStorageActor, 0, std::vector<WorkerDetails> >*,std::vector<WorkerDetails> const& value) 
	{
		fdb_probe_actor_enter("checkForStorage", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkForStorage", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckForStorageActor, 0, std::vector<WorkerDetails> >*,std::vector<WorkerDetails> && value) 
	{
		fdb_probe_actor_enter("checkForStorage", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkForStorage", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckForStorageActor, 0, std::vector<WorkerDetails> >*,Error err) 
	{
		fdb_probe_actor_enter("checkForStorage", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkForStorage", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 1043 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		std::vector<Optional<Key>> missingStorage;
															#line 1045 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for(int i = 0;i < workers.size();i++) {
															#line 1046 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			NetworkAddress addr = workers[i].interf.stableAddress();
															#line 1047 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (!configuration.isExcludedServer(workers[i].interf.addresses(), workers[i].interf.locality) && (workers[i].processClass == ProcessClass::StorageClass || workers[i].processClass == ProcessClass::UnsetClass))
															#line 8453 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 1050 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				bool found = false;
															#line 1051 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				for(int j = 0;j < storageServers.size();j++) {
															#line 1052 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					if (storageServers[j].stableAddress() == addr)
															#line 8461 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
					{
															#line 1053 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						found = true;
															#line 8465 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
						break;
					}
				}
															#line 1057 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				if (!found)
															#line 8471 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				{
															#line 1058 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					TraceEvent("ConsistencyCheck_NoStorage") .detail("Address", addr) .detail("ProcessId", workers[i].interf.locality.processId()) .detail("ProcessClassEqualToStorageClass", (int)(workers[i].processClass == ProcessClass::StorageClass));
															#line 1063 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					missingStorage.push_back(workers[i].interf.locality.dcId());
															#line 8477 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				}
			}
		}
															#line 1068 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		int missingDc0 = configuration.regions.size() == 0 ? 0 : std::count(missingStorage.begin(), missingStorage.end(), configuration.regions[0].dcId);
															#line 1071 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		int missingDc1 = configuration.regions.size() < 2 ? 0 : std::count(missingStorage.begin(), missingStorage.end(), configuration.regions[1].dcId);
															#line 1075 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if ((configuration.regions.size() == 0 && missingStorage.size()) || (configuration.regions.size() == 1 && missingDc0) || (configuration.regions.size() == 2 && configuration.usableRegions == 1 && missingDc0 && missingDc1) || (configuration.regions.size() == 2 && configuration.usableRegions > 1 && (missingDc0 || missingDc1)))
															#line 8487 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 1081 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			bool couldExpectMissingTss = (configuration.desiredTSSCount - tssMapping.size()) > 0;
															#line 1083 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			int countMissing = missingStorage.size();
															#line 1084 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			int acceptableTssMissing = 1;
															#line 1085 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (configuration.regions.size() == 1)
															#line 8497 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 1086 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				countMissing = missingDc0;
															#line 8501 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			}
			else
			{
															#line 1087 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				if (configuration.regions.size() == 2)
															#line 8507 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				{
															#line 1088 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					if (configuration.usableRegions == 1)
															#line 8511 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
					{
															#line 1090 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						countMissing = std::min(missingDc0, missingDc1);
															#line 8515 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
					}
					else
					{
															#line 1091 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						if (configuration.usableRegions == 2)
															#line 8521 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
						{
															#line 1092 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
							countMissing = missingDc0 + missingDc1;
															#line 1093 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
							acceptableTssMissing = 2;
															#line 8527 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
						}
						else
						{
															#line 1095 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
							ASSERT(false);
															#line 8533 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
						}
					}
				}
			}
															#line 1099 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (!couldExpectMissingTss || countMissing > acceptableTssMissing)
															#line 8540 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 1100 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				self->testFailure("No storage server on worker");
															#line 1101 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				if (!static_cast<CheckForStorageActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckForStorageActorState(); static_cast<CheckForStorageActor*>(this)->destroy(); return 0; }
															#line 8546 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				new (&static_cast<CheckForStorageActor*>(this)->SAV< bool >::value()) bool(false);
				this->~CheckForStorageActorState();
				static_cast<CheckForStorageActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 1103 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				TraceEvent(SevWarn, "ConsistencyCheck_TSSMissing").log();
															#line 8556 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			}
		}
															#line 1107 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!static_cast<CheckForStorageActor*>(this)->SAV<bool>::futures) { (void)(true); this->~CheckForStorageActorState(); static_cast<CheckForStorageActor*>(this)->destroy(); return 0; }
															#line 8561 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		new (&static_cast<CheckForStorageActor*>(this)->SAV< bool >::value()) bool(true);
		this->~CheckForStorageActorState();
		static_cast<CheckForStorageActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(std::vector<StorageServerInterface> const& __storageServers,int loopDepth) 
	{
															#line 1042 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		storageServers = __storageServers;
															#line 8573 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(std::vector<StorageServerInterface> && __storageServers,int loopDepth) 
	{
		storageServers = std::move(__storageServers);
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CheckForStorageActor*>(this)->actor_wait_state > 0) static_cast<CheckForStorageActor*>(this)->actor_wait_state = 0;
		static_cast<CheckForStorageActor*>(this)->ActorCallback< CheckForStorageActor, 1, std::vector<StorageServerInterface> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckForStorageActor, 1, std::vector<StorageServerInterface> >*,std::vector<StorageServerInterface> const& value) 
	{
		fdb_probe_actor_enter("checkForStorage", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkForStorage", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CheckForStorageActor, 1, std::vector<StorageServerInterface> >*,std::vector<StorageServerInterface> && value) 
	{
		fdb_probe_actor_enter("checkForStorage", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkForStorage", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CheckForStorageActor, 1, std::vector<StorageServerInterface> >*,Error err) 
	{
		fdb_probe_actor_enter("checkForStorage", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkForStorage", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1037 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Database cx;
															#line 1037 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	DatabaseConfiguration configuration;
															#line 1037 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	std::map<UID, StorageServerInterface> tssMapping;
															#line 1037 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	ConsistencyCheckWorkload* self;
															#line 1041 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	std::vector<WorkerDetails> workers;
															#line 1042 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	std::vector<StorageServerInterface> storageServers;
															#line 8660 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
};
// This generated class is to be used only via checkForStorage()
															#line 1037 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
class CheckForStorageActor final : public Actor<bool>, public ActorCallback< CheckForStorageActor, 0, std::vector<WorkerDetails> >, public ActorCallback< CheckForStorageActor, 1, std::vector<StorageServerInterface> >, public FastAllocated<CheckForStorageActor>, public CheckForStorageActorState<CheckForStorageActor> {
															#line 8665 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
public:
	using FastAllocated<CheckForStorageActor>::operator new;
	using FastAllocated<CheckForStorageActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2908040837724204800UL, 15854047445495558656UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckForStorageActor, 0, std::vector<WorkerDetails> >;
friend struct ActorCallback< CheckForStorageActor, 1, std::vector<StorageServerInterface> >;
															#line 1037 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	CheckForStorageActor(Database const& cx,DatabaseConfiguration const& configuration,std::map<UID, StorageServerInterface> const& tssMapping,ConsistencyCheckWorkload* const& self) 
															#line 8683 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		 : Actor<bool>(),
		   CheckForStorageActorState<CheckForStorageActor>(cx, configuration, tssMapping, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkForStorage", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8398300410677844736UL, 6230040935244071680UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkForStorage");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkForStorage", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckForStorageActor, 0, std::vector<WorkerDetails> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CheckForStorageActor, 1, std::vector<StorageServerInterface> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1037 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
[[nodiscard]] Future<bool> checkForStorage( Database const& cx, DatabaseConfiguration const& configuration, std::map<UID, StorageServerInterface> const& tssMapping, ConsistencyCheckWorkload* const& self ) {
															#line 1037 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	return Future<bool>(new CheckForStorageActor(cx, configuration, tssMapping, self));
															#line 8716 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
}

#line 1109 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"

																#line 8721 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
// This generated class is to be used only via checkForExtraDataStores()
															#line 1110 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
template <class CheckForExtraDataStoresActor>
															#line 1110 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
class CheckForExtraDataStoresActorState {
															#line 8727 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
public:
															#line 1110 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	CheckForExtraDataStoresActorState(Database const& cx,ConsistencyCheckWorkload* const& self) 
															#line 1110 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
															#line 1110 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		 : cx(cx),
															#line 1110 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		   self(self)
															#line 8736 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
	{
		fdb_probe_actor_create("checkForExtraDataStores", reinterpret_cast<unsigned long>(this));

	}
	~CheckForExtraDataStoresActorState() 
	{
		fdb_probe_actor_destroy("checkForExtraDataStores", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1111 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			StrictFuture<std::vector<WorkerDetails>> __when_expr_0 = getWorkers(self->dbInfo);
															#line 1111 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (static_cast<CheckForExtraDataStoresActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8753 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CheckForExtraDataStoresActor*>(this)->actor_wait_state = 1;
															#line 1111 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckForExtraDataStoresActor, 0, std::vector<WorkerDetails> >*>(static_cast<CheckForExtraDataStoresActor*>(this)));
															#line 8758 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckForExtraDataStoresActorState();
		static_cast<CheckForExtraDataStoresActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1112 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<std::vector<StorageServerInterface>> __when_expr_1 = getStorageServers(cx);
															#line 1112 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<CheckForExtraDataStoresActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8783 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CheckForExtraDataStoresActor*>(this)->actor_wait_state = 2;
															#line 1112 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckForExtraDataStoresActor, 1, std::vector<StorageServerInterface> >*>(static_cast<CheckForExtraDataStoresActor*>(this)));
															#line 8788 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(std::vector<WorkerDetails> const& __workers,int loopDepth) 
	{
															#line 1111 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		workers = __workers;
															#line 8797 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<WorkerDetails> && __workers,int loopDepth) 
	{
		workers = std::move(__workers);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckForExtraDataStoresActor*>(this)->actor_wait_state > 0) static_cast<CheckForExtraDataStoresActor*>(this)->actor_wait_state = 0;
		static_cast<CheckForExtraDataStoresActor*>(this)->ActorCallback< CheckForExtraDataStoresActor, 0, std::vector<WorkerDetails> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckForExtraDataStoresActor, 0, std::vector<WorkerDetails> >*,std::vector<WorkerDetails> const& value) 
	{
		fdb_probe_actor_enter("checkForExtraDataStores", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForExtraDataStoresActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkForExtraDataStores", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckForExtraDataStoresActor, 0, std::vector<WorkerDetails> >*,std::vector<WorkerDetails> && value) 
	{
		fdb_probe_actor_enter("checkForExtraDataStores", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForExtraDataStoresActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkForExtraDataStores", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckForExtraDataStoresActor, 0, std::vector<WorkerDetails> >*,Error err) 
	{
		fdb_probe_actor_enter("checkForExtraDataStores", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForExtraDataStoresActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkForExtraDataStores", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 1113 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<std::vector<WorkerInterface>> __when_expr_2 = getCoordWorkers(cx, self->dbInfo);
															#line 1113 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<CheckForExtraDataStoresActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8878 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<CheckForExtraDataStoresActor*>(this)->actor_wait_state = 3;
															#line 1113 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CheckForExtraDataStoresActor, 2, std::vector<WorkerInterface> >*>(static_cast<CheckForExtraDataStoresActor*>(this)));
															#line 8883 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(std::vector<StorageServerInterface> const& __storageServers,int loopDepth) 
	{
															#line 1112 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		storageServers = __storageServers;
															#line 8892 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(std::vector<StorageServerInterface> && __storageServers,int loopDepth) 
	{
		storageServers = std::move(__storageServers);
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CheckForExtraDataStoresActor*>(this)->actor_wait_state > 0) static_cast<CheckForExtraDataStoresActor*>(this)->actor_wait_state = 0;
		static_cast<CheckForExtraDataStoresActor*>(this)->ActorCallback< CheckForExtraDataStoresActor, 1, std::vector<StorageServerInterface> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckForExtraDataStoresActor, 1, std::vector<StorageServerInterface> >*,std::vector<StorageServerInterface> const& value) 
	{
		fdb_probe_actor_enter("checkForExtraDataStores", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForExtraDataStoresActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkForExtraDataStores", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CheckForExtraDataStoresActor, 1, std::vector<StorageServerInterface> >*,std::vector<StorageServerInterface> && value) 
	{
		fdb_probe_actor_enter("checkForExtraDataStores", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForExtraDataStoresActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkForExtraDataStores", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CheckForExtraDataStoresActor, 1, std::vector<StorageServerInterface> >*,Error err) 
	{
		fdb_probe_actor_enter("checkForExtraDataStores", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForExtraDataStoresActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkForExtraDataStores", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 1114 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		auto& db = self->dbInfo->get();
															#line 1115 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		logs = db.logSystemConfig.allPresentLogs();
															#line 1117 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		itr = std::vector<WorkerDetails>::iterator();
															#line 1118 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		foundExtraDataStore = false;
															#line 1119 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		protectedProcessesToKill = std::vector<struct ProcessInfo*>();
															#line 1121 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		statefulProcesses = std::map<NetworkAddress, std::set<UID>>();
															#line 1122 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for( const auto& ss : storageServers ) {
															#line 1123 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			statefulProcesses[ss.address()].insert(ss.id());
															#line 1125 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (ss.secondaryAddress().present())
															#line 8987 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 1126 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				statefulProcesses[ss.secondaryAddress().get()].insert(ss.id());
															#line 8991 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			}
															#line 1128 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent(SevCCheckInfo, "StatefulProcess") .detail("StorageServer", ss.id()) .detail("PrimaryAddress", ss.address().toString()) .detail("SecondaryAddress", ss.secondaryAddress().present() ? ss.secondaryAddress().get().toString() : "Unset");
															#line 8995 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 1134 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for( const auto& log : logs ) {
															#line 1135 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			statefulProcesses[log.address()].insert(log.id());
															#line 1136 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (log.secondaryAddress().present())
															#line 9003 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 1137 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				statefulProcesses[log.secondaryAddress().get()].insert(log.id());
															#line 9007 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			}
															#line 1139 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent(SevCCheckInfo, "StatefulProcess") .detail("Log", log.id()) .detail("PrimaryAddress", log.address().toString()) .detail("SecondaryAddress", log.secondaryAddress().present() ? log.secondaryAddress().get().toString() : "Unset");
															#line 9011 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 1146 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for( const auto& cWorker : coordWorkers ) {
															#line 1147 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			statefulProcesses[cWorker.address()].insert(cWorker.id());
															#line 1148 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (cWorker.secondaryAddress().present())
															#line 9019 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 1149 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				statefulProcesses[cWorker.secondaryAddress().get()].insert(cWorker.id());
															#line 9023 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			}
															#line 1151 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent(SevCCheckInfo, "StatefulProcess") .detail("Coordinator", cWorker.id()) .detail("PrimaryAddress", cWorker.address().toString()) .detail("SecondaryAddress", cWorker.secondaryAddress().present() ? cWorker.secondaryAddress().get().toString() : "Unset");
															#line 9027 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 1158 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		itr = workers.begin();
															#line 9031 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = a_body1cont3loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(std::vector<WorkerInterface> const& __coordWorkers,int loopDepth) 
	{
															#line 1113 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		coordWorkers = __coordWorkers;
															#line 9040 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(std::vector<WorkerInterface> && __coordWorkers,int loopDepth) 
	{
		coordWorkers = std::move(__coordWorkers);
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CheckForExtraDataStoresActor*>(this)->actor_wait_state > 0) static_cast<CheckForExtraDataStoresActor*>(this)->actor_wait_state = 0;
		static_cast<CheckForExtraDataStoresActor*>(this)->ActorCallback< CheckForExtraDataStoresActor, 2, std::vector<WorkerInterface> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckForExtraDataStoresActor, 2, std::vector<WorkerInterface> >*,std::vector<WorkerInterface> const& value) 
	{
		fdb_probe_actor_enter("checkForExtraDataStores", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForExtraDataStoresActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkForExtraDataStores", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CheckForExtraDataStoresActor, 2, std::vector<WorkerInterface> >*,std::vector<WorkerInterface> && value) 
	{
		fdb_probe_actor_enter("checkForExtraDataStores", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForExtraDataStoresActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkForExtraDataStores", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CheckForExtraDataStoresActor, 2, std::vector<WorkerInterface> >*,Error err) 
	{
		fdb_probe_actor_enter("checkForExtraDataStores", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForExtraDataStoresActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkForExtraDataStores", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 1211 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (foundExtraDataStore)
															#line 9119 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 1212 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			self->testFailure("Extra data stores present on workers");
															#line 1213 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (!static_cast<CheckForExtraDataStoresActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckForExtraDataStoresActorState(); static_cast<CheckForExtraDataStoresActor*>(this)->destroy(); return 0; }
															#line 9125 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			new (&static_cast<CheckForExtraDataStoresActor*>(this)->SAV< bool >::value()) bool(false);
			this->~CheckForExtraDataStoresActorState();
			static_cast<CheckForExtraDataStoresActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1216 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!static_cast<CheckForExtraDataStoresActor*>(this)->SAV<bool>::futures) { (void)(true); this->~CheckForExtraDataStoresActorState(); static_cast<CheckForExtraDataStoresActor*>(this)->destroy(); return 0; }
															#line 9133 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		new (&static_cast<CheckForExtraDataStoresActor*>(this)->SAV< bool >::value()) bool(true);
		this->~CheckForExtraDataStoresActorState();
		static_cast<CheckForExtraDataStoresActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont3loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1(int loopDepth) 
	{
															#line 1158 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!(itr != workers.end()))
															#line 9152 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
			return a_body1cont3break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1159 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<ErrorOr<Standalone<VectorRef<UID>>>> __when_expr_3 = itr->interf.diskStoreRequest.getReplyUnlessFailedFor(DiskStoreRequest(false), 2, 0);
															#line 1159 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<CheckForExtraDataStoresActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 9160 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont3loopBody1when1(__when_expr_3.get(), loopDepth); };
		static_cast<CheckForExtraDataStoresActor*>(this)->actor_wait_state = 4;
															#line 1159 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CheckForExtraDataStoresActor, 3, ErrorOr<Standalone<VectorRef<UID>>> >*>(static_cast<CheckForExtraDataStoresActor*>(this)));
															#line 9165 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3break1(int loopDepth) 
	{
		try {
			return a_body1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3loopBody1cont1(ErrorOr<Standalone<VectorRef<UID>>> const& stores,int loopDepth) 
	{
															#line 1161 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (stores.isError())
															#line 9187 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 1162 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent("ConsistencyCheck_GetDataStoreFailure") .error(stores.getError()) .detail("Address", itr->interf.address());
															#line 1165 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			self->testFailure("Failed to get data stores");
															#line 1166 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (!static_cast<CheckForExtraDataStoresActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckForExtraDataStoresActorState(); static_cast<CheckForExtraDataStoresActor*>(this)->destroy(); return 0; }
															#line 9195 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			new (&static_cast<CheckForExtraDataStoresActor*>(this)->SAV< bool >::value()) bool(false);
			this->~CheckForExtraDataStoresActorState();
			static_cast<CheckForExtraDataStoresActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1169 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		TraceEvent(SevCCheckInfo, "ConsistencyCheck_ExtraDataStore") .detail("Worker", itr->interf.id().toString()) .detail("PrimaryAddress", itr->interf.address().toString()) .detail("SecondaryAddress", itr->interf.secondaryAddress().present() ? itr->interf.secondaryAddress().get().toString() : "Unset");
															#line 1175 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for( const auto& id : stores.get() ) {
															#line 1176 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (statefulProcesses[itr->interf.address()].contains(id))
															#line 9207 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
				continue;
			}
															#line 1180 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent("ConsistencyCheck_ExtraDataStore") .detail("Address", itr->interf.address()) .detail("DataStoreID", id);
															#line 1183 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (g_network->isSimulated())
															#line 9215 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 1187 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				ISimulator::ProcessInfo* p = g_simulator->getProcessByAddress(itr->interf.address());
															#line 1190 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				TraceEvent("ConsistencyCheck_RebootProcess") .detail("Address", itr->interf.address()) .detail("ProcessPrimaryAddress", p->address) .detail("ProcessAddresses", p->addresses.toString()) .detail("DataStoreID", id) .detail("Protected", g_simulator->protectedAddresses.contains(itr->interf.address())) .detail("Reliable", p->isReliable()) .detail("ReliableInfo", p->getReliableInfo()) .detail("KillOrRebootProcess", p->address);
															#line 1200 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				if (p->isReliable())
															#line 9223 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				{
															#line 1201 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					g_simulator->rebootProcess(p, ISimulator::KillType::RebootProcess);
															#line 9227 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				}
				else
				{
															#line 1203 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					g_simulator->killProcess(p, ISimulator::KillType::KillInstantly);
															#line 9233 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				}
			}
															#line 1207 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			foundExtraDataStore = true;
															#line 9238 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 1158 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		++itr;
															#line 9242 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont1(ErrorOr<Standalone<VectorRef<UID>>> && stores,int loopDepth) 
	{
															#line 1161 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (stores.isError())
															#line 9251 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 1162 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent("ConsistencyCheck_GetDataStoreFailure") .error(stores.getError()) .detail("Address", itr->interf.address());
															#line 1165 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			self->testFailure("Failed to get data stores");
															#line 1166 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (!static_cast<CheckForExtraDataStoresActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckForExtraDataStoresActorState(); static_cast<CheckForExtraDataStoresActor*>(this)->destroy(); return 0; }
															#line 9259 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			new (&static_cast<CheckForExtraDataStoresActor*>(this)->SAV< bool >::value()) bool(false);
			this->~CheckForExtraDataStoresActorState();
			static_cast<CheckForExtraDataStoresActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1169 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		TraceEvent(SevCCheckInfo, "ConsistencyCheck_ExtraDataStore") .detail("Worker", itr->interf.id().toString()) .detail("PrimaryAddress", itr->interf.address().toString()) .detail("SecondaryAddress", itr->interf.secondaryAddress().present() ? itr->interf.secondaryAddress().get().toString() : "Unset");
															#line 1175 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for( const auto& id : stores.get() ) {
															#line 1176 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (statefulProcesses[itr->interf.address()].contains(id))
															#line 9271 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
				continue;
			}
															#line 1180 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent("ConsistencyCheck_ExtraDataStore") .detail("Address", itr->interf.address()) .detail("DataStoreID", id);
															#line 1183 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (g_network->isSimulated())
															#line 9279 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 1187 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				ISimulator::ProcessInfo* p = g_simulator->getProcessByAddress(itr->interf.address());
															#line 1190 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				TraceEvent("ConsistencyCheck_RebootProcess") .detail("Address", itr->interf.address()) .detail("ProcessPrimaryAddress", p->address) .detail("ProcessAddresses", p->addresses.toString()) .detail("DataStoreID", id) .detail("Protected", g_simulator->protectedAddresses.contains(itr->interf.address())) .detail("Reliable", p->isReliable()) .detail("ReliableInfo", p->getReliableInfo()) .detail("KillOrRebootProcess", p->address);
															#line 1200 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				if (p->isReliable())
															#line 9287 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				{
															#line 1201 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					g_simulator->rebootProcess(p, ISimulator::KillType::RebootProcess);
															#line 9291 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				}
				else
				{
															#line 1203 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					g_simulator->killProcess(p, ISimulator::KillType::KillInstantly);
															#line 9297 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				}
			}
															#line 1207 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			foundExtraDataStore = true;
															#line 9302 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 1158 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		++itr;
															#line 9306 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1cont3loopBody1when1(ErrorOr<Standalone<VectorRef<UID>>> const& stores,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont1(stores, loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1when1(ErrorOr<Standalone<VectorRef<UID>>> && stores,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont1(std::move(stores), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<CheckForExtraDataStoresActor*>(this)->actor_wait_state > 0) static_cast<CheckForExtraDataStoresActor*>(this)->actor_wait_state = 0;
		static_cast<CheckForExtraDataStoresActor*>(this)->ActorCallback< CheckForExtraDataStoresActor, 3, ErrorOr<Standalone<VectorRef<UID>>> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckForExtraDataStoresActor, 3, ErrorOr<Standalone<VectorRef<UID>>> >*,ErrorOr<Standalone<VectorRef<UID>>> const& value) 
	{
		fdb_probe_actor_enter("checkForExtraDataStores", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForExtraDataStoresActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkForExtraDataStores", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< CheckForExtraDataStoresActor, 3, ErrorOr<Standalone<VectorRef<UID>>> >*,ErrorOr<Standalone<VectorRef<UID>>> && value) 
	{
		fdb_probe_actor_enter("checkForExtraDataStores", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForExtraDataStoresActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkForExtraDataStores", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< CheckForExtraDataStoresActor, 3, ErrorOr<Standalone<VectorRef<UID>>> >*,Error err) 
	{
		fdb_probe_actor_enter("checkForExtraDataStores", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForExtraDataStoresActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkForExtraDataStores", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 1110 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Database cx;
															#line 1110 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	ConsistencyCheckWorkload* self;
															#line 1111 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	std::vector<WorkerDetails> workers;
															#line 1112 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	std::vector<StorageServerInterface> storageServers;
															#line 1113 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	std::vector<WorkerInterface> coordWorkers;
															#line 1115 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	std::vector<TLogInterface> logs;
															#line 1117 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	std::vector<WorkerDetails>::iterator itr;
															#line 1118 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	bool foundExtraDataStore;
															#line 1119 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	std::vector<struct ProcessInfo*> protectedProcessesToKill;
															#line 1121 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	std::map<NetworkAddress, std::set<UID>> statefulProcesses;
															#line 9406 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
};
// This generated class is to be used only via checkForExtraDataStores()
															#line 1110 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
class CheckForExtraDataStoresActor final : public Actor<bool>, public ActorCallback< CheckForExtraDataStoresActor, 0, std::vector<WorkerDetails> >, public ActorCallback< CheckForExtraDataStoresActor, 1, std::vector<StorageServerInterface> >, public ActorCallback< CheckForExtraDataStoresActor, 2, std::vector<WorkerInterface> >, public ActorCallback< CheckForExtraDataStoresActor, 3, ErrorOr<Standalone<VectorRef<UID>>> >, public FastAllocated<CheckForExtraDataStoresActor>, public CheckForExtraDataStoresActorState<CheckForExtraDataStoresActor> {
															#line 9411 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
public:
	using FastAllocated<CheckForExtraDataStoresActor>::operator new;
	using FastAllocated<CheckForExtraDataStoresActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11837918247788896768UL, 14651455054962573568UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckForExtraDataStoresActor, 0, std::vector<WorkerDetails> >;
friend struct ActorCallback< CheckForExtraDataStoresActor, 1, std::vector<StorageServerInterface> >;
friend struct ActorCallback< CheckForExtraDataStoresActor, 2, std::vector<WorkerInterface> >;
friend struct ActorCallback< CheckForExtraDataStoresActor, 3, ErrorOr<Standalone<VectorRef<UID>>> >;
															#line 1110 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	CheckForExtraDataStoresActor(Database const& cx,ConsistencyCheckWorkload* const& self) 
															#line 9431 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		 : Actor<bool>(),
		   CheckForExtraDataStoresActorState<CheckForExtraDataStoresActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkForExtraDataStores", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(427473886050604288UL, 3872966658194644992UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForExtraDataStoresActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkForExtraDataStores");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkForExtraDataStores", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckForExtraDataStoresActor, 0, std::vector<WorkerDetails> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CheckForExtraDataStoresActor, 1, std::vector<StorageServerInterface> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CheckForExtraDataStoresActor, 2, std::vector<WorkerInterface> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< CheckForExtraDataStoresActor, 3, ErrorOr<Standalone<VectorRef<UID>>> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1110 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
[[nodiscard]] Future<bool> checkForExtraDataStores( Database const& cx, ConsistencyCheckWorkload* const& self ) {
															#line 1110 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	return Future<bool>(new CheckForExtraDataStoresActor(cx, self));
															#line 9466 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
}

#line 1218 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"

																#line 9471 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
// This generated class is to be used only via checkWorkerList()
															#line 1219 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
template <class CheckWorkerListActor>
															#line 1219 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
class CheckWorkerListActorState {
															#line 9477 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
public:
															#line 1219 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	CheckWorkerListActorState(Database const& cx,ConsistencyCheckWorkload* const& self) 
															#line 1219 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
															#line 1219 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		 : cx(cx),
															#line 1219 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		   self(self)
															#line 9486 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
	{
		fdb_probe_actor_create("checkWorkerList", reinterpret_cast<unsigned long>(this));

	}
	~CheckWorkerListActorState() 
	{
		fdb_probe_actor_destroy("checkWorkerList", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1220 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (!g_simulator->extraDatabases.empty())
															#line 9501 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 1221 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				if (!static_cast<CheckWorkerListActor*>(this)->SAV<bool>::futures) { (void)(true); this->~CheckWorkerListActorState(); static_cast<CheckWorkerListActor*>(this)->destroy(); return 0; }
															#line 9505 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				new (&static_cast<CheckWorkerListActor*>(this)->SAV< bool >::value()) bool(true);
				this->~CheckWorkerListActorState();
				static_cast<CheckWorkerListActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 1224 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			StrictFuture<std::vector<WorkerDetails>> __when_expr_0 = getWorkers(self->dbInfo);
															#line 1224 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (static_cast<CheckWorkerListActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9515 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CheckWorkerListActor*>(this)->actor_wait_state = 1;
															#line 1224 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckWorkerListActor, 0, std::vector<WorkerDetails> >*>(static_cast<CheckWorkerListActor*>(this)));
															#line 9520 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckWorkerListActorState();
		static_cast<CheckWorkerListActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<WorkerDetails> const& workers,int loopDepth) 
	{
															#line 1225 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		std::set<NetworkAddress> workerAddresses;
															#line 1227 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for( const auto& it : workers ) {
															#line 1228 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			NetworkAddress addr = it.interf.tLog.getEndpoint().addresses.getTLSAddress();
															#line 1229 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			ISimulator::ProcessInfo* info = g_simulator->getProcessByAddress(addr);
															#line 1230 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (!info || info->failed)
															#line 9551 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 1231 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				TraceEvent("ConsistencyCheck_FailedWorkerInList").detail("Addr", it.interf.address());
															#line 1232 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				if (!static_cast<CheckWorkerListActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckWorkerListActorState(); static_cast<CheckWorkerListActor*>(this)->destroy(); return 0; }
															#line 9557 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				new (&static_cast<CheckWorkerListActor*>(this)->SAV< bool >::value()) bool(false);
				this->~CheckWorkerListActorState();
				static_cast<CheckWorkerListActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 1234 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			workerAddresses.insert(NetworkAddress(addr.ip, addr.port, true, addr.isTLS()));
															#line 9565 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 1237 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		std::vector<ISimulator::ProcessInfo*> all = g_simulator->getAllProcesses();
															#line 1238 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for(int i = 0;i < all.size();i++) {
															#line 1239 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (all[i]->isReliable() && all[i]->name == std::string("Server") && all[i]->startingClass != ProcessClass::TesterClass && all[i]->startingClass != ProcessClass::SimHTTPServerClass && all[i]->protocolVersion == g_network->protocolVersion())
															#line 9573 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 1243 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				if (!workerAddresses.contains(all[i]->address))
															#line 9577 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				{
															#line 1244 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					TraceEvent("ConsistencyCheck_WorkerMissingFromList").detail("Addr", all[i]->address);
															#line 1245 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					if (!static_cast<CheckWorkerListActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckWorkerListActorState(); static_cast<CheckWorkerListActor*>(this)->destroy(); return 0; }
															#line 9583 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
					new (&static_cast<CheckWorkerListActor*>(this)->SAV< bool >::value()) bool(false);
					this->~CheckWorkerListActorState();
					static_cast<CheckWorkerListActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
			}
		}
															#line 1250 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!static_cast<CheckWorkerListActor*>(this)->SAV<bool>::futures) { (void)(true); this->~CheckWorkerListActorState(); static_cast<CheckWorkerListActor*>(this)->destroy(); return 0; }
															#line 9593 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		new (&static_cast<CheckWorkerListActor*>(this)->SAV< bool >::value()) bool(true);
		this->~CheckWorkerListActorState();
		static_cast<CheckWorkerListActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<WorkerDetails> && workers,int loopDepth) 
	{
															#line 1225 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		std::set<NetworkAddress> workerAddresses;
															#line 1227 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for( const auto& it : workers ) {
															#line 1228 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			NetworkAddress addr = it.interf.tLog.getEndpoint().addresses.getTLSAddress();
															#line 1229 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			ISimulator::ProcessInfo* info = g_simulator->getProcessByAddress(addr);
															#line 1230 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (!info || info->failed)
															#line 9613 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 1231 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				TraceEvent("ConsistencyCheck_FailedWorkerInList").detail("Addr", it.interf.address());
															#line 1232 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				if (!static_cast<CheckWorkerListActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckWorkerListActorState(); static_cast<CheckWorkerListActor*>(this)->destroy(); return 0; }
															#line 9619 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				new (&static_cast<CheckWorkerListActor*>(this)->SAV< bool >::value()) bool(false);
				this->~CheckWorkerListActorState();
				static_cast<CheckWorkerListActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 1234 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			workerAddresses.insert(NetworkAddress(addr.ip, addr.port, true, addr.isTLS()));
															#line 9627 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 1237 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		std::vector<ISimulator::ProcessInfo*> all = g_simulator->getAllProcesses();
															#line 1238 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for(int i = 0;i < all.size();i++) {
															#line 1239 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (all[i]->isReliable() && all[i]->name == std::string("Server") && all[i]->startingClass != ProcessClass::TesterClass && all[i]->startingClass != ProcessClass::SimHTTPServerClass && all[i]->protocolVersion == g_network->protocolVersion())
															#line 9635 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 1243 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				if (!workerAddresses.contains(all[i]->address))
															#line 9639 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				{
															#line 1244 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					TraceEvent("ConsistencyCheck_WorkerMissingFromList").detail("Addr", all[i]->address);
															#line 1245 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					if (!static_cast<CheckWorkerListActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckWorkerListActorState(); static_cast<CheckWorkerListActor*>(this)->destroy(); return 0; }
															#line 9645 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
					new (&static_cast<CheckWorkerListActor*>(this)->SAV< bool >::value()) bool(false);
					this->~CheckWorkerListActorState();
					static_cast<CheckWorkerListActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
			}
		}
															#line 1250 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!static_cast<CheckWorkerListActor*>(this)->SAV<bool>::futures) { (void)(true); this->~CheckWorkerListActorState(); static_cast<CheckWorkerListActor*>(this)->destroy(); return 0; }
															#line 9655 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		new (&static_cast<CheckWorkerListActor*>(this)->SAV< bool >::value()) bool(true);
		this->~CheckWorkerListActorState();
		static_cast<CheckWorkerListActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(std::vector<WorkerDetails> const& workers,int loopDepth) 
	{
		loopDepth = a_body1cont1(workers, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<WorkerDetails> && workers,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(workers), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckWorkerListActor*>(this)->actor_wait_state > 0) static_cast<CheckWorkerListActor*>(this)->actor_wait_state = 0;
		static_cast<CheckWorkerListActor*>(this)->ActorCallback< CheckWorkerListActor, 0, std::vector<WorkerDetails> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckWorkerListActor, 0, std::vector<WorkerDetails> >*,std::vector<WorkerDetails> const& value) 
	{
		fdb_probe_actor_enter("checkWorkerList", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckWorkerListActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkWorkerList", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckWorkerListActor, 0, std::vector<WorkerDetails> >*,std::vector<WorkerDetails> && value) 
	{
		fdb_probe_actor_enter("checkWorkerList", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckWorkerListActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkWorkerList", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckWorkerListActor, 0, std::vector<WorkerDetails> >*,Error err) 
	{
		fdb_probe_actor_enter("checkWorkerList", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckWorkerListActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkWorkerList", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1219 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Database cx;
															#line 1219 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	ConsistencyCheckWorkload* self;
															#line 9742 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
};
// This generated class is to be used only via checkWorkerList()
															#line 1219 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
class CheckWorkerListActor final : public Actor<bool>, public ActorCallback< CheckWorkerListActor, 0, std::vector<WorkerDetails> >, public FastAllocated<CheckWorkerListActor>, public CheckWorkerListActorState<CheckWorkerListActor> {
															#line 9747 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
public:
	using FastAllocated<CheckWorkerListActor>::operator new;
	using FastAllocated<CheckWorkerListActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5760543883811238400UL, 13777768868365870848UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckWorkerListActor, 0, std::vector<WorkerDetails> >;
															#line 1219 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	CheckWorkerListActor(Database const& cx,ConsistencyCheckWorkload* const& self) 
															#line 9764 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		 : Actor<bool>(),
		   CheckWorkerListActorState<CheckWorkerListActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkWorkerList", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13452236408503872000UL, 17501392737149118464UL);
		ActorExecutionContextHelper __helper(static_cast<CheckWorkerListActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkWorkerList");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkWorkerList", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckWorkerListActor, 0, std::vector<WorkerDetails> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1219 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
[[nodiscard]] Future<bool> checkWorkerList( Database const& cx, ConsistencyCheckWorkload* const& self ) {
															#line 1219 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	return Future<bool>(new CheckWorkerListActor(cx, self));
															#line 9796 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
}

#line 1252 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"

	static ProcessClass::Fitness getBestAvailableFitness(
	    const std::vector<ProcessClass::ClassType>& availableClassTypes,
	    ProcessClass::ClusterRole role) {
		ProcessClass::Fitness bestAvailableFitness = ProcessClass::NeverAssign;
		for (auto classType : availableClassTypes) {
			bestAvailableFitness = std::min(
			    bestAvailableFitness, ProcessClass(classType, ProcessClass::InvalidSource).machineClassFitness(role));
		}

		return bestAvailableFitness;
	}

	template <class T>
	static std::string getOptionalString(Optional<T> opt) {
		if (opt.present())
			return opt.get().toString();
		return "NotSet";
	}

																#line 9820 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
// This generated class is to be used only via checkCoordinators()
															#line 1272 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
template <class CheckCoordinatorsActor>
															#line 1272 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
class CheckCoordinatorsActorState {
															#line 9826 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
public:
															#line 1272 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	CheckCoordinatorsActorState(Database const& cx) 
															#line 1272 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
															#line 1272 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		 : cx(cx),
															#line 1273 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		   tr(cx)
															#line 9835 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
	{
		fdb_probe_actor_create("checkCoordinators", reinterpret_cast<unsigned long>(this));

	}
	~CheckCoordinatorsActorState() 
	{
		fdb_probe_actor_destroy("checkCoordinators", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1274 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			;
															#line 9850 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckCoordinatorsActorState();
		static_cast<CheckCoordinatorsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 1276 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 1277 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr.get(coordinatorsKey);
															#line 1277 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (static_cast<CheckCoordinatorsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9885 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CheckCoordinatorsActor*>(this)->actor_wait_state = 1;
															#line 1277 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckCoordinatorsActor, 0, Optional<Value> >*>(static_cast<CheckCoordinatorsActor*>(this)));
															#line 9890 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1310 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr.onError(e);
															#line 1310 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (static_cast<CheckCoordinatorsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 9914 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<CheckCoordinatorsActor*>(this)->actor_wait_state = 4;
															#line 1310 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CheckCoordinatorsActor, 3, Void >*>(static_cast<CheckCoordinatorsActor*>(this)));
															#line 9919 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> const& currentKey,int loopDepth) 
	{
															#line 1279 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!currentKey.present())
															#line 9934 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 1280 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent("ConsistencyCheck_NoCoordinatorKey").log();
															#line 1281 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (!static_cast<CheckCoordinatorsActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckCoordinatorsActorState(); static_cast<CheckCoordinatorsActor*>(this)->destroy(); return 0; }
															#line 9940 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			new (&static_cast<CheckCoordinatorsActor*>(this)->SAV< bool >::value()) bool(false);
			this->~CheckCoordinatorsActorState();
			static_cast<CheckCoordinatorsActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1284 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		ClusterConnectionString old(currentKey.get().toString());
															#line 1285 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<std::vector<NetworkAddress>> __when_expr_1 = old.tryResolveHostnames();
															#line 1285 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<CheckCoordinatorsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9952 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<CheckCoordinatorsActor*>(this)->actor_wait_state = 2;
															#line 1285 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckCoordinatorsActor, 1, std::vector<NetworkAddress> >*>(static_cast<CheckCoordinatorsActor*>(this)));
															#line 9957 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> && currentKey,int loopDepth) 
	{
															#line 1279 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!currentKey.present())
															#line 9966 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 1280 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent("ConsistencyCheck_NoCoordinatorKey").log();
															#line 1281 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (!static_cast<CheckCoordinatorsActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckCoordinatorsActorState(); static_cast<CheckCoordinatorsActor*>(this)->destroy(); return 0; }
															#line 9972 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			new (&static_cast<CheckCoordinatorsActor*>(this)->SAV< bool >::value()) bool(false);
			this->~CheckCoordinatorsActorState();
			static_cast<CheckCoordinatorsActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1284 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		ClusterConnectionString old(currentKey.get().toString());
															#line 1285 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<std::vector<NetworkAddress>> __when_expr_1 = old.tryResolveHostnames();
															#line 1285 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<CheckCoordinatorsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9984 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<CheckCoordinatorsActor*>(this)->actor_wait_state = 2;
															#line 1285 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckCoordinatorsActor, 1, std::vector<NetworkAddress> >*>(static_cast<CheckCoordinatorsActor*>(this)));
															#line 9989 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& currentKey,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(currentKey, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && currentKey,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(currentKey), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckCoordinatorsActor*>(this)->actor_wait_state > 0) static_cast<CheckCoordinatorsActor*>(this)->actor_wait_state = 0;
		static_cast<CheckCoordinatorsActor*>(this)->ActorCallback< CheckCoordinatorsActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckCoordinatorsActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("checkCoordinators", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkCoordinators", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckCoordinatorsActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("checkCoordinators", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkCoordinators", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckCoordinatorsActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("checkCoordinators", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkCoordinators", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 1287 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<std::vector<ProcessData>> __when_expr_2 = ::getWorkers(&tr);
															#line 1287 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<CheckCoordinatorsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10075 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<CheckCoordinatorsActor*>(this)->actor_wait_state = 3;
															#line 1287 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CheckCoordinatorsActor, 2, std::vector<ProcessData> >*>(static_cast<CheckCoordinatorsActor*>(this)));
															#line 10080 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(std::vector<NetworkAddress> const& __oldCoordinators,int loopDepth) 
	{
															#line 1285 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		oldCoordinators = __oldCoordinators;
															#line 10089 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(std::vector<NetworkAddress> && __oldCoordinators,int loopDepth) 
	{
		oldCoordinators = std::move(__oldCoordinators);
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CheckCoordinatorsActor*>(this)->actor_wait_state > 0) static_cast<CheckCoordinatorsActor*>(this)->actor_wait_state = 0;
		static_cast<CheckCoordinatorsActor*>(this)->ActorCallback< CheckCoordinatorsActor, 1, std::vector<NetworkAddress> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckCoordinatorsActor, 1, std::vector<NetworkAddress> >*,std::vector<NetworkAddress> const& value) 
	{
		fdb_probe_actor_enter("checkCoordinators", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkCoordinators", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CheckCoordinatorsActor, 1, std::vector<NetworkAddress> >*,std::vector<NetworkAddress> && value) 
	{
		fdb_probe_actor_enter("checkCoordinators", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkCoordinators", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CheckCoordinatorsActor, 1, std::vector<NetworkAddress> >*,Error err) 
	{
		fdb_probe_actor_enter("checkCoordinators", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkCoordinators", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont5(std::vector<ProcessData> const& workers,int loopDepth) 
	{
															#line 1289 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		std::map<NetworkAddress, LocalityData> addr_locality;
															#line 1290 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for( auto w : workers ) {
															#line 1291 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			addr_locality[w.address] = w.locality;
															#line 10172 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 1294 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		std::set<Optional<Standalone<StringRef>>> checkDuplicates;
															#line 1295 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for( const auto& addr : oldCoordinators ) {
															#line 1296 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			auto findResult = addr_locality.find(addr);
															#line 1297 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (findResult != addr_locality.end())
															#line 10182 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 1298 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				if (checkDuplicates.contains(findResult->second.zoneId()))
															#line 10186 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				{
															#line 1299 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					TraceEvent("ConsistencyCheck_BadCoordinator") .detail("Addr", addr) .detail("NotFound", findResult == addr_locality.end());
															#line 1302 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					if (!static_cast<CheckCoordinatorsActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckCoordinatorsActorState(); static_cast<CheckCoordinatorsActor*>(this)->destroy(); return 0; }
															#line 10192 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
					new (&static_cast<CheckCoordinatorsActor*>(this)->SAV< bool >::value()) bool(false);
					this->~CheckCoordinatorsActorState();
					static_cast<CheckCoordinatorsActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
															#line 1304 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				checkDuplicates.insert(findResult->second.zoneId());
															#line 10200 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			}
		}
															#line 1308 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!static_cast<CheckCoordinatorsActor*>(this)->SAV<bool>::futures) { (void)(true); this->~CheckCoordinatorsActorState(); static_cast<CheckCoordinatorsActor*>(this)->destroy(); return 0; }
															#line 10205 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		new (&static_cast<CheckCoordinatorsActor*>(this)->SAV< bool >::value()) bool(true);
		this->~CheckCoordinatorsActorState();
		static_cast<CheckCoordinatorsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont5(std::vector<ProcessData> && workers,int loopDepth) 
	{
															#line 1289 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		std::map<NetworkAddress, LocalityData> addr_locality;
															#line 1290 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for( auto w : workers ) {
															#line 1291 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			addr_locality[w.address] = w.locality;
															#line 10221 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 1294 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		std::set<Optional<Standalone<StringRef>>> checkDuplicates;
															#line 1295 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for( const auto& addr : oldCoordinators ) {
															#line 1296 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			auto findResult = addr_locality.find(addr);
															#line 1297 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (findResult != addr_locality.end())
															#line 10231 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 1298 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				if (checkDuplicates.contains(findResult->second.zoneId()))
															#line 10235 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				{
															#line 1299 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					TraceEvent("ConsistencyCheck_BadCoordinator") .detail("Addr", addr) .detail("NotFound", findResult == addr_locality.end());
															#line 1302 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					if (!static_cast<CheckCoordinatorsActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckCoordinatorsActorState(); static_cast<CheckCoordinatorsActor*>(this)->destroy(); return 0; }
															#line 10241 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
					new (&static_cast<CheckCoordinatorsActor*>(this)->SAV< bool >::value()) bool(false);
					this->~CheckCoordinatorsActorState();
					static_cast<CheckCoordinatorsActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
															#line 1304 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				checkDuplicates.insert(findResult->second.zoneId());
															#line 10249 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			}
		}
															#line 1308 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!static_cast<CheckCoordinatorsActor*>(this)->SAV<bool>::futures) { (void)(true); this->~CheckCoordinatorsActorState(); static_cast<CheckCoordinatorsActor*>(this)->destroy(); return 0; }
															#line 10254 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		new (&static_cast<CheckCoordinatorsActor*>(this)->SAV< bool >::value()) bool(true);
		this->~CheckCoordinatorsActorState();
		static_cast<CheckCoordinatorsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(std::vector<ProcessData> const& workers,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(workers, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(std::vector<ProcessData> && workers,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(std::move(workers), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CheckCoordinatorsActor*>(this)->actor_wait_state > 0) static_cast<CheckCoordinatorsActor*>(this)->actor_wait_state = 0;
		static_cast<CheckCoordinatorsActor*>(this)->ActorCallback< CheckCoordinatorsActor, 2, std::vector<ProcessData> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckCoordinatorsActor, 2, std::vector<ProcessData> >*,std::vector<ProcessData> const& value) 
	{
		fdb_probe_actor_enter("checkCoordinators", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkCoordinators", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CheckCoordinatorsActor, 2, std::vector<ProcessData> >*,std::vector<ProcessData> && value) 
	{
		fdb_probe_actor_enter("checkCoordinators", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkCoordinators", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CheckCoordinatorsActor, 2, std::vector<ProcessData> >*,Error err) 
	{
		fdb_probe_actor_enter("checkCoordinators", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkCoordinators", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<CheckCoordinatorsActor*>(this)->actor_wait_state > 0) static_cast<CheckCoordinatorsActor*>(this)->actor_wait_state = 0;
		static_cast<CheckCoordinatorsActor*>(this)->ActorCallback< CheckCoordinatorsActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckCoordinatorsActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkCoordinators", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkCoordinators", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< CheckCoordinatorsActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkCoordinators", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkCoordinators", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< CheckCoordinatorsActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkCoordinators", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkCoordinators", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 1272 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Database cx;
															#line 1273 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Transaction tr;
															#line 1285 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	std::vector<NetworkAddress> oldCoordinators;
															#line 10430 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
};
// This generated class is to be used only via checkCoordinators()
															#line 1272 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
class CheckCoordinatorsActor final : public Actor<bool>, public ActorCallback< CheckCoordinatorsActor, 0, Optional<Value> >, public ActorCallback< CheckCoordinatorsActor, 1, std::vector<NetworkAddress> >, public ActorCallback< CheckCoordinatorsActor, 2, std::vector<ProcessData> >, public ActorCallback< CheckCoordinatorsActor, 3, Void >, public FastAllocated<CheckCoordinatorsActor>, public CheckCoordinatorsActorState<CheckCoordinatorsActor> {
															#line 10435 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
public:
	using FastAllocated<CheckCoordinatorsActor>::operator new;
	using FastAllocated<CheckCoordinatorsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5398540821985513472UL, 5943891646095917824UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckCoordinatorsActor, 0, Optional<Value> >;
friend struct ActorCallback< CheckCoordinatorsActor, 1, std::vector<NetworkAddress> >;
friend struct ActorCallback< CheckCoordinatorsActor, 2, std::vector<ProcessData> >;
friend struct ActorCallback< CheckCoordinatorsActor, 3, Void >;
															#line 1272 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	CheckCoordinatorsActor(Database const& cx) 
															#line 10455 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		 : Actor<bool>(),
		   CheckCoordinatorsActorState<CheckCoordinatorsActor>(cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkCoordinators", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4936341211804007168UL, 10483879935152264448UL);
		ActorExecutionContextHelper __helper(static_cast<CheckCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkCoordinators");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkCoordinators", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckCoordinatorsActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CheckCoordinatorsActor, 1, std::vector<NetworkAddress> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CheckCoordinatorsActor, 2, std::vector<ProcessData> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< CheckCoordinatorsActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1272 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
[[nodiscard]] Future<bool> checkCoordinators( Database const& cx ) {
															#line 1272 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	return Future<bool>(new CheckCoordinatorsActor(cx));
															#line 10490 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
}

#line 1314 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"

	// Returns true if all machines in the cluster that specified a desired class are operating in that class
																#line 10496 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
// This generated class is to be used only via checkUsingDesiredClasses()
															#line 1316 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
template <class CheckUsingDesiredClassesActor>
															#line 1316 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
class CheckUsingDesiredClassesActorState {
															#line 10502 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
public:
															#line 1316 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	CheckUsingDesiredClassesActorState(Database const& cx,ConsistencyCheckWorkload* const& self) 
															#line 1316 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
															#line 1316 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		 : cx(cx),
															#line 1316 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		   self(self),
															#line 1317 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		   expectedPrimaryDcId(),
															#line 1318 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		   expectedRemoteDcId()
															#line 10515 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
	{
		fdb_probe_actor_create("checkUsingDesiredClasses", reinterpret_cast<unsigned long>(this));

	}
	~CheckUsingDesiredClassesActorState() 
	{
		fdb_probe_actor_destroy("checkUsingDesiredClasses", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1319 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			StrictFuture<DatabaseConfiguration> __when_expr_0 = getDatabaseConfiguration(cx);
															#line 1319 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (static_cast<CheckUsingDesiredClassesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10532 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CheckUsingDesiredClassesActor*>(this)->actor_wait_state = 1;
															#line 1319 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckUsingDesiredClassesActor, 0, DatabaseConfiguration >*>(static_cast<CheckUsingDesiredClassesActor*>(this)));
															#line 10537 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckUsingDesiredClassesActorState();
		static_cast<CheckUsingDesiredClassesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1320 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<std::vector<WorkerDetails>> __when_expr_1 = getWorkers(self->dbInfo);
															#line 1320 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<CheckUsingDesiredClassesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10562 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CheckUsingDesiredClassesActor*>(this)->actor_wait_state = 2;
															#line 1320 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckUsingDesiredClassesActor, 1, std::vector<WorkerDetails> >*>(static_cast<CheckUsingDesiredClassesActor*>(this)));
															#line 10567 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(DatabaseConfiguration const& __config,int loopDepth) 
	{
															#line 1319 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		config = __config;
															#line 10576 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(DatabaseConfiguration && __config,int loopDepth) 
	{
		config = std::move(__config);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckUsingDesiredClassesActor*>(this)->actor_wait_state > 0) static_cast<CheckUsingDesiredClassesActor*>(this)->actor_wait_state = 0;
		static_cast<CheckUsingDesiredClassesActor*>(this)->ActorCallback< CheckUsingDesiredClassesActor, 0, DatabaseConfiguration >::remove();

	}
	void a_callback_fire(ActorCallback< CheckUsingDesiredClassesActor, 0, DatabaseConfiguration >*,DatabaseConfiguration const& value) 
	{
		fdb_probe_actor_enter("checkUsingDesiredClasses", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckUsingDesiredClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkUsingDesiredClasses", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckUsingDesiredClassesActor, 0, DatabaseConfiguration >*,DatabaseConfiguration && value) 
	{
		fdb_probe_actor_enter("checkUsingDesiredClasses", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckUsingDesiredClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkUsingDesiredClasses", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckUsingDesiredClassesActor, 0, DatabaseConfiguration >*,Error err) 
	{
		fdb_probe_actor_enter("checkUsingDesiredClasses", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckUsingDesiredClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkUsingDesiredClasses", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 1321 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<std::vector<WorkerDetails>> __when_expr_2 = getWorkers(self->dbInfo, GetWorkersRequest::NON_EXCLUDED_PROCESSES_ONLY);
															#line 1321 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<CheckUsingDesiredClassesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10657 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<CheckUsingDesiredClassesActor*>(this)->actor_wait_state = 3;
															#line 1321 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CheckUsingDesiredClassesActor, 2, std::vector<WorkerDetails> >*>(static_cast<CheckUsingDesiredClassesActor*>(this)));
															#line 10662 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(std::vector<WorkerDetails> const& __allWorkers,int loopDepth) 
	{
															#line 1320 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		allWorkers = __allWorkers;
															#line 10671 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(std::vector<WorkerDetails> && __allWorkers,int loopDepth) 
	{
		allWorkers = std::move(__allWorkers);
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CheckUsingDesiredClassesActor*>(this)->actor_wait_state > 0) static_cast<CheckUsingDesiredClassesActor*>(this)->actor_wait_state = 0;
		static_cast<CheckUsingDesiredClassesActor*>(this)->ActorCallback< CheckUsingDesiredClassesActor, 1, std::vector<WorkerDetails> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckUsingDesiredClassesActor, 1, std::vector<WorkerDetails> >*,std::vector<WorkerDetails> const& value) 
	{
		fdb_probe_actor_enter("checkUsingDesiredClasses", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckUsingDesiredClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkUsingDesiredClasses", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CheckUsingDesiredClassesActor, 1, std::vector<WorkerDetails> >*,std::vector<WorkerDetails> && value) 
	{
		fdb_probe_actor_enter("checkUsingDesiredClasses", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckUsingDesiredClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkUsingDesiredClasses", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CheckUsingDesiredClassesActor, 1, std::vector<WorkerDetails> >*,Error err) 
	{
		fdb_probe_actor_enter("checkUsingDesiredClasses", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckUsingDesiredClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkUsingDesiredClasses", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 1323 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		auto& db = self->dbInfo->get();
															#line 1325 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		std::map<NetworkAddress, WorkerDetails> allWorkerProcessMap;
															#line 1326 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		std::map<Optional<Key>, std::vector<ProcessClass::ClassType>> dcToAllClassTypes;
															#line 1327 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for( const auto& worker : allWorkers ) {
															#line 1328 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			allWorkerProcessMap[worker.interf.address()] = worker;
															#line 1329 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			Optional<Key> dc = worker.interf.locality.dcId();
															#line 1330 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (!dcToAllClassTypes.contains(dc))
															#line 10762 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 1331 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				dcToAllClassTypes.insert({});
															#line 10766 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			}
															#line 1332 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			dcToAllClassTypes[dc].push_back(worker.processClass.classType());
															#line 10770 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 1335 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		std::map<NetworkAddress, WorkerDetails> nonExcludedWorkerProcessMap;
															#line 1336 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		std::map<Optional<Key>, std::vector<ProcessClass::ClassType>> dcToNonExcludedClassTypes;
															#line 1337 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for( const auto& worker : nonExcludedWorkers ) {
															#line 1338 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			nonExcludedWorkerProcessMap[worker.interf.address()] = worker;
															#line 1339 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			Optional<Key> dc = worker.interf.locality.dcId();
															#line 1340 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (!dcToNonExcludedClassTypes.contains(dc))
															#line 10784 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 1341 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				dcToNonExcludedClassTypes.insert({});
															#line 10788 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			}
															#line 1342 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			dcToNonExcludedClassTypes[dc].push_back(worker.processClass.classType());
															#line 10792 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 1345 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!allWorkerProcessMap.contains(db.clusterInterface.clientInterface.address()))
															#line 10796 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 1346 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent("ConsistencyCheck_CCNotInWorkerList") .detail("CCAddress", db.clusterInterface.clientInterface.address().toString());
															#line 1348 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (!static_cast<CheckUsingDesiredClassesActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckUsingDesiredClassesActorState(); static_cast<CheckUsingDesiredClassesActor*>(this)->destroy(); return 0; }
															#line 10802 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			new (&static_cast<CheckUsingDesiredClassesActor*>(this)->SAV< bool >::value()) bool(false);
			this->~CheckUsingDesiredClassesActorState();
			static_cast<CheckUsingDesiredClassesActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1350 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!allWorkerProcessMap.contains(db.master.address()))
															#line 10810 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 1351 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent("ConsistencyCheck_MasterNotInWorkerList") .detail("MasterAddress", db.master.address().toString());
															#line 1353 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (!static_cast<CheckUsingDesiredClassesActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckUsingDesiredClassesActorState(); static_cast<CheckUsingDesiredClassesActor*>(this)->destroy(); return 0; }
															#line 10816 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			new (&static_cast<CheckUsingDesiredClassesActor*>(this)->SAV< bool >::value()) bool(false);
			this->~CheckUsingDesiredClassesActorState();
			static_cast<CheckUsingDesiredClassesActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1356 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		Optional<Key> ccDcId = allWorkerProcessMap[db.clusterInterface.clientInterface.address()].interf.locality.dcId();
															#line 1358 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		Optional<Key> masterDcId = allWorkerProcessMap[db.master.address()].interf.locality.dcId();
															#line 1360 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (ccDcId != masterDcId)
															#line 10828 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 1361 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent("ConsistencyCheck_CCAndMasterNotInSameDC") .detail("ClusterControllerDcId", getOptionalString(ccDcId)) .detail("MasterDcId", getOptionalString(masterDcId));
															#line 1364 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (!static_cast<CheckUsingDesiredClassesActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckUsingDesiredClassesActorState(); static_cast<CheckUsingDesiredClassesActor*>(this)->destroy(); return 0; }
															#line 10834 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			new (&static_cast<CheckUsingDesiredClassesActor*>(this)->SAV< bool >::value()) bool(false);
			this->~CheckUsingDesiredClassesActorState();
			static_cast<CheckUsingDesiredClassesActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1369 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (g_network->isSimulated() && config.usableRegions > 1 && g_simulator->primaryDcId.present() && !g_simulator->datacenterDead(g_simulator->primaryDcId) && !g_simulator->datacenterDead(g_simulator->remoteDcId))
															#line 10842 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 1372 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			expectedPrimaryDcId = config.regions[0].dcId;
															#line 1373 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			expectedRemoteDcId = config.regions[1].dcId;
															#line 1375 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (config.regions[0].priority == config.regions[1].priority)
															#line 10850 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 1376 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				expectedPrimaryDcId = masterDcId;
															#line 1377 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				expectedRemoteDcId = config.regions[0].dcId == expectedPrimaryDcId.get() ? config.regions[1].dcId : config.regions[0].dcId;
															#line 10856 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			}
															#line 1381 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (ccDcId != expectedPrimaryDcId)
															#line 10860 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 1382 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				TraceEvent("ConsistencyCheck_ClusterControllerDcNotBest") .detail("PreferredDcId", getOptionalString(expectedPrimaryDcId)) .detail("ExistingDcId", getOptionalString(ccDcId));
															#line 1385 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				if (!static_cast<CheckUsingDesiredClassesActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckUsingDesiredClassesActorState(); static_cast<CheckUsingDesiredClassesActor*>(this)->destroy(); return 0; }
															#line 10866 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				new (&static_cast<CheckUsingDesiredClassesActor*>(this)->SAV< bool >::value()) bool(false);
				this->~CheckUsingDesiredClassesActorState();
				static_cast<CheckUsingDesiredClassesActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 1387 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (masterDcId != expectedPrimaryDcId)
															#line 10874 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 1388 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				TraceEvent("ConsistencyCheck_MasterDcNotBest") .detail("PreferredDcId", getOptionalString(expectedPrimaryDcId)) .detail("ExistingDcId", getOptionalString(masterDcId));
															#line 1391 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				if (!static_cast<CheckUsingDesiredClassesActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckUsingDesiredClassesActorState(); static_cast<CheckUsingDesiredClassesActor*>(this)->destroy(); return 0; }
															#line 10880 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				new (&static_cast<CheckUsingDesiredClassesActor*>(this)->SAV< bool >::value()) bool(false);
				this->~CheckUsingDesiredClassesActorState();
				static_cast<CheckUsingDesiredClassesActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 1396 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		ProcessClass::Fitness bestClusterControllerFitness = getBestAvailableFitness(dcToNonExcludedClassTypes[ccDcId], ProcessClass::ClusterController);
															#line 1398 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!nonExcludedWorkerProcessMap.contains(db.clusterInterface.clientInterface.address()) || nonExcludedWorkerProcessMap[db.clusterInterface.clientInterface.address()].processClass.machineClassFitness( ProcessClass::ClusterController) != bestClusterControllerFitness)
															#line 10891 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 1401 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent("ConsistencyCheck_ClusterControllerNotBest") .detail("BestClusterControllerFitness", bestClusterControllerFitness) .detail("ExistingClusterControllerFit", nonExcludedWorkerProcessMap.contains(db.clusterInterface.clientInterface.address()) ? nonExcludedWorkerProcessMap[db.clusterInterface.clientInterface.address()] .processClass.machineClassFitness(ProcessClass::ClusterController) : -1);
															#line 1408 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (!static_cast<CheckUsingDesiredClassesActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckUsingDesiredClassesActorState(); static_cast<CheckUsingDesiredClassesActor*>(this)->destroy(); return 0; }
															#line 10897 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			new (&static_cast<CheckUsingDesiredClassesActor*>(this)->SAV< bool >::value()) bool(false);
			this->~CheckUsingDesiredClassesActorState();
			static_cast<CheckUsingDesiredClassesActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1412 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		ProcessClass::Fitness bestMasterFitness = getBestAvailableFitness(dcToNonExcludedClassTypes[masterDcId], ProcessClass::Master);
															#line 1414 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (bestMasterFitness == ProcessClass::NeverAssign)
															#line 10907 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 1415 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			bestMasterFitness = getBestAvailableFitness(dcToAllClassTypes[masterDcId], ProcessClass::Master);
															#line 1416 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (bestMasterFitness != ProcessClass::NeverAssign)
															#line 10913 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 1417 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				bestMasterFitness = ProcessClass::ExcludeFit;
															#line 10917 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			}
		}
															#line 1421 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if ((!nonExcludedWorkerProcessMap.contains(db.master.address()) && bestMasterFitness != ProcessClass::ExcludeFit) || nonExcludedWorkerProcessMap[db.master.address()].processClass.machineClassFitness(ProcessClass::Master) != bestMasterFitness)
															#line 10922 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 1425 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent("ConsistencyCheck_MasterNotBest") .detail("BestMasterFitness", bestMasterFitness) .detail("ExistingMasterFit", nonExcludedWorkerProcessMap.contains(db.master.address()) ? nonExcludedWorkerProcessMap[db.master.address()].processClass.machineClassFitness( ProcessClass::Master) : -1);
															#line 1432 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (!static_cast<CheckUsingDesiredClassesActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckUsingDesiredClassesActorState(); static_cast<CheckUsingDesiredClassesActor*>(this)->destroy(); return 0; }
															#line 10928 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			new (&static_cast<CheckUsingDesiredClassesActor*>(this)->SAV< bool >::value()) bool(false);
			this->~CheckUsingDesiredClassesActorState();
			static_cast<CheckUsingDesiredClassesActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1436 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		ProcessClass::Fitness bestCommitProxyFitness = getBestAvailableFitness(dcToNonExcludedClassTypes[masterDcId], ProcessClass::CommitProxy);
															#line 1438 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for( const auto& commitProxy : db.client.commitProxies ) {
															#line 1439 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (!nonExcludedWorkerProcessMap.contains(commitProxy.address()) || nonExcludedWorkerProcessMap[commitProxy.address()].processClass.machineClassFitness( ProcessClass::CommitProxy) != bestCommitProxyFitness)
															#line 10940 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 1442 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				TraceEvent("ConsistencyCheck_CommitProxyNotBest") .detail("BestCommitProxyFitness", bestCommitProxyFitness) .detail("ExistingCommitProxyFitness", nonExcludedWorkerProcessMap.contains(commitProxy.address()) ? nonExcludedWorkerProcessMap[commitProxy.address()].processClass.machineClassFitness( ProcessClass::CommitProxy) : -1);
															#line 1449 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				if (!static_cast<CheckUsingDesiredClassesActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckUsingDesiredClassesActorState(); static_cast<CheckUsingDesiredClassesActor*>(this)->destroy(); return 0; }
															#line 10946 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				new (&static_cast<CheckUsingDesiredClassesActor*>(this)->SAV< bool >::value()) bool(false);
				this->~CheckUsingDesiredClassesActorState();
				static_cast<CheckUsingDesiredClassesActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 1454 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		ProcessClass::Fitness bestGrvProxyFitness = getBestAvailableFitness(dcToNonExcludedClassTypes[masterDcId], ProcessClass::GrvProxy);
															#line 1456 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for( const auto& grvProxy : db.client.grvProxies ) {
															#line 1457 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (!nonExcludedWorkerProcessMap.contains(grvProxy.address()) || nonExcludedWorkerProcessMap[grvProxy.address()].processClass.machineClassFitness( ProcessClass::GrvProxy) != bestGrvProxyFitness)
															#line 10959 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 1460 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				TraceEvent("ConsistencyCheck_GrvProxyNotBest") .detail("BestGrvProxyFitness", bestGrvProxyFitness) .detail("ExistingGrvProxyFitness", nonExcludedWorkerProcessMap.contains(grvProxy.address()) ? nonExcludedWorkerProcessMap[grvProxy.address()].processClass.machineClassFitness( ProcessClass::GrvProxy) : -1);
															#line 1467 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				if (!static_cast<CheckUsingDesiredClassesActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckUsingDesiredClassesActorState(); static_cast<CheckUsingDesiredClassesActor*>(this)->destroy(); return 0; }
															#line 10965 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				new (&static_cast<CheckUsingDesiredClassesActor*>(this)->SAV< bool >::value()) bool(false);
				this->~CheckUsingDesiredClassesActorState();
				static_cast<CheckUsingDesiredClassesActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 1472 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		ProcessClass::Fitness bestResolverFitness = getBestAvailableFitness(dcToNonExcludedClassTypes[masterDcId], ProcessClass::Resolver);
															#line 1474 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for( const auto& resolver : db.resolvers ) {
															#line 1475 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (!nonExcludedWorkerProcessMap.contains(resolver.address()) || nonExcludedWorkerProcessMap[resolver.address()].processClass.machineClassFitness( ProcessClass::Resolver) != bestResolverFitness)
															#line 10978 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 1478 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				TraceEvent("ConsistencyCheck_ResolverNotBest") .detail("BestResolverFitness", bestResolverFitness) .detail("ExistingResolverFitness", nonExcludedWorkerProcessMap.contains(resolver.address()) ? nonExcludedWorkerProcessMap[resolver.address()].processClass.machineClassFitness( ProcessClass::Resolver) : -1);
															#line 1485 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				if (!static_cast<CheckUsingDesiredClassesActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckUsingDesiredClassesActorState(); static_cast<CheckUsingDesiredClassesActor*>(this)->destroy(); return 0; }
															#line 10984 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				new (&static_cast<CheckUsingDesiredClassesActor*>(this)->SAV< bool >::value()) bool(false);
				this->~CheckUsingDesiredClassesActorState();
				static_cast<CheckUsingDesiredClassesActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 1490 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (g_network->isSimulated() && config.usableRegions > 1 && g_simulator->primaryDcId.present() && !g_simulator->datacenterDead(g_simulator->primaryDcId) && !g_simulator->datacenterDead(g_simulator->remoteDcId))
															#line 10993 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 1493 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			for( auto& tlogSet : db.logSystemConfig.tLogs ) {
															#line 1494 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				if (!tlogSet.isLocal && tlogSet.logRouters.size())
															#line 10999 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				{
															#line 1495 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					for( auto& logRouter : tlogSet.logRouters ) {
															#line 1496 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						if (!nonExcludedWorkerProcessMap.contains(logRouter.interf().address()))
															#line 11005 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
						{
															#line 1497 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
							TraceEvent("ConsistencyCheck_LogRouterNotInNonExcludedWorkers") .detail("Id", logRouter.id());
															#line 1499 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
							if (!static_cast<CheckUsingDesiredClassesActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckUsingDesiredClassesActorState(); static_cast<CheckUsingDesiredClassesActor*>(this)->destroy(); return 0; }
															#line 11011 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
							new (&static_cast<CheckUsingDesiredClassesActor*>(this)->SAV< bool >::value()) bool(false);
							this->~CheckUsingDesiredClassesActorState();
							static_cast<CheckUsingDesiredClassesActor*>(this)->finishSendAndDelPromiseRef();
							return 0;
						}
															#line 1501 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						if (logRouter.interf().filteredLocality.dcId() != expectedRemoteDcId)
															#line 11019 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
						{
															#line 1502 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
							TraceEvent("ConsistencyCheck_LogRouterNotBestDC") .detail("expectedDC", getOptionalString(expectedRemoteDcId)) .detail("ActualDC", getOptionalString(logRouter.interf().filteredLocality.dcId()));
															#line 1505 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
							if (!static_cast<CheckUsingDesiredClassesActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckUsingDesiredClassesActorState(); static_cast<CheckUsingDesiredClassesActor*>(this)->destroy(); return 0; }
															#line 11025 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
							new (&static_cast<CheckUsingDesiredClassesActor*>(this)->SAV< bool >::value()) bool(false);
							this->~CheckUsingDesiredClassesActorState();
							static_cast<CheckUsingDesiredClassesActor*>(this)->finishSendAndDelPromiseRef();
							return 0;
						}
					}
				}
			}
		}
															#line 1513 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		ProcessClass::Fitness fitnessLowerBound = allWorkerProcessMap[db.master.address()].processClass.machineClassFitness(ProcessClass::DataDistributor);
															#line 1515 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (db.distributor.present() && (!nonExcludedWorkerProcessMap.contains(db.distributor.get().address()) || nonExcludedWorkerProcessMap[db.distributor.get().address()].processClass.machineClassFitness( ProcessClass::DataDistributor) > fitnessLowerBound))
															#line 11039 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 1519 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent("ConsistencyCheck_DistributorNotBest") .detail("DataDistributorFitnessLowerBound", fitnessLowerBound) .detail( "ExistingDistributorFitness", nonExcludedWorkerProcessMap.contains(db.distributor.get().address()) ? nonExcludedWorkerProcessMap[db.distributor.get().address()].processClass.machineClassFitness( ProcessClass::DataDistributor) : -1);
															#line 1527 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (!static_cast<CheckUsingDesiredClassesActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckUsingDesiredClassesActorState(); static_cast<CheckUsingDesiredClassesActor*>(this)->destroy(); return 0; }
															#line 11045 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			new (&static_cast<CheckUsingDesiredClassesActor*>(this)->SAV< bool >::value()) bool(false);
			this->~CheckUsingDesiredClassesActorState();
			static_cast<CheckUsingDesiredClassesActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1531 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (db.ratekeeper.present() && (!nonExcludedWorkerProcessMap.contains(db.ratekeeper.get().address()) || nonExcludedWorkerProcessMap[db.ratekeeper.get().address()].processClass.machineClassFitness( ProcessClass::Ratekeeper) > fitnessLowerBound))
															#line 11053 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 1535 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent("ConsistencyCheck_RatekeeperNotBest") .detail("BestRatekeeperFitness", fitnessLowerBound) .detail( "ExistingRatekeeperFitness", nonExcludedWorkerProcessMap.contains(db.ratekeeper.get().address()) ? nonExcludedWorkerProcessMap[db.ratekeeper.get().address()].processClass.machineClassFitness( ProcessClass::Ratekeeper) : -1);
															#line 1543 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (!static_cast<CheckUsingDesiredClassesActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckUsingDesiredClassesActorState(); static_cast<CheckUsingDesiredClassesActor*>(this)->destroy(); return 0; }
															#line 11059 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			new (&static_cast<CheckUsingDesiredClassesActor*>(this)->SAV< bool >::value()) bool(false);
			this->~CheckUsingDesiredClassesActorState();
			static_cast<CheckUsingDesiredClassesActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1547 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (config.encryptionAtRestMode.isEncryptionEnabled() && db.client.encryptKeyProxy.present() && (!nonExcludedWorkerProcessMap.contains(db.client.encryptKeyProxy.get().address()) || nonExcludedWorkerProcessMap[db.client.encryptKeyProxy.get().address()].processClass.machineClassFitness( ProcessClass::EncryptKeyProxy) > fitnessLowerBound))
															#line 11067 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 1551 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent("ConsistencyCheck_EncryptKeyProxyNotBest") .detail("BestEncryptKeyProxyFitness", fitnessLowerBound) .detail("ExistingEncryptKeyProxyFitness", nonExcludedWorkerProcessMap.contains(db.client.encryptKeyProxy.get().address()) ? nonExcludedWorkerProcessMap[db.client.encryptKeyProxy.get().address()] .processClass.machineClassFitness(ProcessClass::EncryptKeyProxy) : -1);
															#line 1558 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (!static_cast<CheckUsingDesiredClassesActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckUsingDesiredClassesActorState(); static_cast<CheckUsingDesiredClassesActor*>(this)->destroy(); return 0; }
															#line 11073 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			new (&static_cast<CheckUsingDesiredClassesActor*>(this)->SAV< bool >::value()) bool(false);
			this->~CheckUsingDesiredClassesActorState();
			static_cast<CheckUsingDesiredClassesActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1562 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (db.consistencyScan.present() && (!nonExcludedWorkerProcessMap.contains(db.consistencyScan.get().address()) || nonExcludedWorkerProcessMap[db.consistencyScan.get().address()].processClass.machineClassFitness( ProcessClass::ConsistencyScan) > fitnessLowerBound))
															#line 11081 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 1566 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent("ConsistencyCheck_ConsistencyScanNotBest") .detail("BestConsistencyScanFitness", fitnessLowerBound) .detail("ExistingConsistencyScanFitness", nonExcludedWorkerProcessMap.contains(db.consistencyScan.get().address()) ? nonExcludedWorkerProcessMap[db.consistencyScan.get().address()] .processClass.machineClassFitness(ProcessClass::ConsistencyScan) : -1);
															#line 1573 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (!static_cast<CheckUsingDesiredClassesActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckUsingDesiredClassesActorState(); static_cast<CheckUsingDesiredClassesActor*>(this)->destroy(); return 0; }
															#line 11087 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			new (&static_cast<CheckUsingDesiredClassesActor*>(this)->SAV< bool >::value()) bool(false);
			this->~CheckUsingDesiredClassesActorState();
			static_cast<CheckUsingDesiredClassesActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1578 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!static_cast<CheckUsingDesiredClassesActor*>(this)->SAV<bool>::futures) { (void)(true); this->~CheckUsingDesiredClassesActorState(); static_cast<CheckUsingDesiredClassesActor*>(this)->destroy(); return 0; }
															#line 11095 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		new (&static_cast<CheckUsingDesiredClassesActor*>(this)->SAV< bool >::value()) bool(true);
		this->~CheckUsingDesiredClassesActorState();
		static_cast<CheckUsingDesiredClassesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(std::vector<WorkerDetails> const& __nonExcludedWorkers,int loopDepth) 
	{
															#line 1321 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		nonExcludedWorkers = __nonExcludedWorkers;
															#line 11107 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(std::vector<WorkerDetails> && __nonExcludedWorkers,int loopDepth) 
	{
		nonExcludedWorkers = std::move(__nonExcludedWorkers);
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CheckUsingDesiredClassesActor*>(this)->actor_wait_state > 0) static_cast<CheckUsingDesiredClassesActor*>(this)->actor_wait_state = 0;
		static_cast<CheckUsingDesiredClassesActor*>(this)->ActorCallback< CheckUsingDesiredClassesActor, 2, std::vector<WorkerDetails> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckUsingDesiredClassesActor, 2, std::vector<WorkerDetails> >*,std::vector<WorkerDetails> const& value) 
	{
		fdb_probe_actor_enter("checkUsingDesiredClasses", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckUsingDesiredClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkUsingDesiredClasses", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CheckUsingDesiredClassesActor, 2, std::vector<WorkerDetails> >*,std::vector<WorkerDetails> && value) 
	{
		fdb_probe_actor_enter("checkUsingDesiredClasses", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckUsingDesiredClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkUsingDesiredClasses", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CheckUsingDesiredClassesActor, 2, std::vector<WorkerDetails> >*,Error err) 
	{
		fdb_probe_actor_enter("checkUsingDesiredClasses", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckUsingDesiredClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkUsingDesiredClasses", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 1316 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Database cx;
															#line 1316 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	ConsistencyCheckWorkload* self;
															#line 1317 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Optional<Key> expectedPrimaryDcId;
															#line 1318 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Optional<Key> expectedRemoteDcId;
															#line 1319 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	DatabaseConfiguration config;
															#line 1320 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	std::vector<WorkerDetails> allWorkers;
															#line 1321 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	std::vector<WorkerDetails> nonExcludedWorkers;
															#line 11196 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
};
// This generated class is to be used only via checkUsingDesiredClasses()
															#line 1316 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
class CheckUsingDesiredClassesActor final : public Actor<bool>, public ActorCallback< CheckUsingDesiredClassesActor, 0, DatabaseConfiguration >, public ActorCallback< CheckUsingDesiredClassesActor, 1, std::vector<WorkerDetails> >, public ActorCallback< CheckUsingDesiredClassesActor, 2, std::vector<WorkerDetails> >, public FastAllocated<CheckUsingDesiredClassesActor>, public CheckUsingDesiredClassesActorState<CheckUsingDesiredClassesActor> {
															#line 11201 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
public:
	using FastAllocated<CheckUsingDesiredClassesActor>::operator new;
	using FastAllocated<CheckUsingDesiredClassesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12090705943226918400UL, 13635827408524279808UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckUsingDesiredClassesActor, 0, DatabaseConfiguration >;
friend struct ActorCallback< CheckUsingDesiredClassesActor, 1, std::vector<WorkerDetails> >;
friend struct ActorCallback< CheckUsingDesiredClassesActor, 2, std::vector<WorkerDetails> >;
															#line 1316 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	CheckUsingDesiredClassesActor(Database const& cx,ConsistencyCheckWorkload* const& self) 
															#line 11220 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		 : Actor<bool>(),
		   CheckUsingDesiredClassesActorState<CheckUsingDesiredClassesActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkUsingDesiredClasses", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16621575950694749952UL, 13688324977771477760UL);
		ActorExecutionContextHelper __helper(static_cast<CheckUsingDesiredClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkUsingDesiredClasses");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkUsingDesiredClasses", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckUsingDesiredClassesActor, 0, DatabaseConfiguration >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CheckUsingDesiredClassesActor, 1, std::vector<WorkerDetails> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CheckUsingDesiredClassesActor, 2, std::vector<WorkerDetails> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1316 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
[[nodiscard]] Future<bool> checkUsingDesiredClasses( Database const& cx, ConsistencyCheckWorkload* const& self ) {
															#line 1316 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	return Future<bool>(new CheckUsingDesiredClassesActor(cx, self));
															#line 11254 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
}

#line 1580 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"

	// returns true if stopped, false otherwise
																#line 11260 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
// This generated class is to be used only via checkConsistencyScan()
															#line 1582 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
template <class CheckConsistencyScanActor>
															#line 1582 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
class CheckConsistencyScanActorState {
															#line 11266 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
public:
															#line 1582 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	CheckConsistencyScanActorState(Database const& cx) 
															#line 1582 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
															#line 1582 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		 : cx(cx)
															#line 11273 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
	{
		fdb_probe_actor_create("checkConsistencyScan", reinterpret_cast<unsigned long>(this));

	}
	~CheckConsistencyScanActorState() 
	{
		fdb_probe_actor_destroy("checkConsistencyScan", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1583 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (!g_network->isSimulated())
															#line 11288 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 1584 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				if (!static_cast<CheckConsistencyScanActor*>(this)->SAV<bool>::futures) { (void)(true); this->~CheckConsistencyScanActorState(); static_cast<CheckConsistencyScanActor*>(this)->destroy(); return 0; }
															#line 11292 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				new (&static_cast<CheckConsistencyScanActor*>(this)->SAV< bool >::value()) bool(true);
				this->~CheckConsistencyScanActorState();
				static_cast<CheckConsistencyScanActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 1586 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			tr = makeReference<ReadYourWritesTransaction>(cx);
															#line 1587 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			cs = ConsistencyScanState();
															#line 1588 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			;
															#line 11304 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckConsistencyScanActorState();
		static_cast<CheckConsistencyScanActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 1590 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			SystemDBWriteLockedNow(cx.getReference())->setOptions(tr);
															#line 1591 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			StrictFuture<ConsistencyScanState::Config> __when_expr_0 = cs.config().getD(tr);
															#line 1591 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (static_cast<CheckConsistencyScanActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 11339 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CheckConsistencyScanActor*>(this)->actor_wait_state = 1;
															#line 1591 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckConsistencyScanActor, 0, ConsistencyScanState::Config >*>(static_cast<CheckConsistencyScanActor*>(this)));
															#line 11344 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1594 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr->onError(e);
															#line 1594 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (static_cast<CheckConsistencyScanActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 11368 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<CheckConsistencyScanActor*>(this)->actor_wait_state = 2;
															#line 1594 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckConsistencyScanActor, 1, Void >*>(static_cast<CheckConsistencyScanActor*>(this)));
															#line 11373 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(ConsistencyScanState::Config const& config,int loopDepth) 
	{
															#line 1592 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!static_cast<CheckConsistencyScanActor*>(this)->SAV<bool>::futures) { (void)(!config.enabled); this->~CheckConsistencyScanActorState(); static_cast<CheckConsistencyScanActor*>(this)->destroy(); return 0; }
															#line 11388 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		new (&static_cast<CheckConsistencyScanActor*>(this)->SAV< bool >::value()) bool(!config.enabled);
		this->~CheckConsistencyScanActorState();
		static_cast<CheckConsistencyScanActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(ConsistencyScanState::Config && config,int loopDepth) 
	{
															#line 1592 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!static_cast<CheckConsistencyScanActor*>(this)->SAV<bool>::futures) { (void)(!config.enabled); this->~CheckConsistencyScanActorState(); static_cast<CheckConsistencyScanActor*>(this)->destroy(); return 0; }
															#line 11400 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		new (&static_cast<CheckConsistencyScanActor*>(this)->SAV< bool >::value()) bool(!config.enabled);
		this->~CheckConsistencyScanActorState();
		static_cast<CheckConsistencyScanActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(ConsistencyScanState::Config const& config,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(config, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(ConsistencyScanState::Config && config,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(config), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckConsistencyScanActor*>(this)->actor_wait_state > 0) static_cast<CheckConsistencyScanActor*>(this)->actor_wait_state = 0;
		static_cast<CheckConsistencyScanActor*>(this)->ActorCallback< CheckConsistencyScanActor, 0, ConsistencyScanState::Config >::remove();

	}
	void a_callback_fire(ActorCallback< CheckConsistencyScanActor, 0, ConsistencyScanState::Config >*,ConsistencyScanState::Config const& value) 
	{
		fdb_probe_actor_enter("checkConsistencyScan", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckConsistencyScanActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkConsistencyScan", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckConsistencyScanActor, 0, ConsistencyScanState::Config >*,ConsistencyScanState::Config && value) 
	{
		fdb_probe_actor_enter("checkConsistencyScan", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckConsistencyScanActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkConsistencyScan", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckConsistencyScanActor, 0, ConsistencyScanState::Config >*,Error err) 
	{
		fdb_probe_actor_enter("checkConsistencyScan", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckConsistencyScanActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkConsistencyScan", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CheckConsistencyScanActor*>(this)->actor_wait_state > 0) static_cast<CheckConsistencyScanActor*>(this)->actor_wait_state = 0;
		static_cast<CheckConsistencyScanActor*>(this)->ActorCallback< CheckConsistencyScanActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckConsistencyScanActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkConsistencyScan", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckConsistencyScanActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkConsistencyScan", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CheckConsistencyScanActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkConsistencyScan", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckConsistencyScanActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkConsistencyScan", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CheckConsistencyScanActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkConsistencyScan", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckConsistencyScanActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkConsistencyScan", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1582 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Database cx;
															#line 1586 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 1587 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	ConsistencyScanState cs;
															#line 11576 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
};
// This generated class is to be used only via checkConsistencyScan()
															#line 1582 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
class CheckConsistencyScanActor final : public Actor<bool>, public ActorCallback< CheckConsistencyScanActor, 0, ConsistencyScanState::Config >, public ActorCallback< CheckConsistencyScanActor, 1, Void >, public FastAllocated<CheckConsistencyScanActor>, public CheckConsistencyScanActorState<CheckConsistencyScanActor> {
															#line 11581 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
public:
	using FastAllocated<CheckConsistencyScanActor>::operator new;
	using FastAllocated<CheckConsistencyScanActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16785438762777524992UL, 2989731607157169408UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckConsistencyScanActor, 0, ConsistencyScanState::Config >;
friend struct ActorCallback< CheckConsistencyScanActor, 1, Void >;
															#line 1582 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	CheckConsistencyScanActor(Database const& cx) 
															#line 11599 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		 : Actor<bool>(),
		   CheckConsistencyScanActorState<CheckConsistencyScanActor>(cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkConsistencyScan", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13688259443744744960UL, 983808638632960256UL);
		ActorExecutionContextHelper __helper(static_cast<CheckConsistencyScanActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkConsistencyScan");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkConsistencyScan", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckConsistencyScanActor, 0, ConsistencyScanState::Config >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CheckConsistencyScanActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1582 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
[[nodiscard]] Future<bool> checkConsistencyScan( Database const& cx ) {
															#line 1582 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	return Future<bool>(new CheckConsistencyScanActor(cx));
															#line 11632 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
}

#line 1598 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"

	bool checkSingleSingleton(std::vector<ISimulator::ProcessInfo*> const& allProcesses,
	                          TraceEvent& ev,
	                          std::string const& role,
	                          int expectedCount) {
		// FIXME: this doesn't actually check that there aren't multiple of the same role running on the same process
		// either
		int count = 0;
		for (int i = 0; i < allProcesses.size(); i++) {
			if (g_simulator->hasRole(allProcesses[i]->address, role)) {
				count++;
				ev.detail(role + std::to_string(count), allProcesses[i]->address.toString());
			}
		}
		ev.detail(role + "Count", count).detail(role + "ExpectedCount", expectedCount);
		if (count != expectedCount) {
			fmt::print("ConsistencyCheck failure: incorrect number {0} of singleton {1} running (expected {2})\n",
			           count,
			           role,
			           expectedCount);
		}
		return count == expectedCount;
	}

	// checks that there is only one instance of each singleton running in the cluster in simulation
	bool checkSingleSingletons(ConsistencyCheckWorkload* self, DatabaseConfiguration config) {
		if (!g_network->isSimulated()) {
			return true;
		}

		CODE_PROBE(self->performQuiescentChecks, "Checking for single singletons");

		std::vector<ISimulator::ProcessInfo*> allProcesses = g_simulator->getAllProcesses();

		bool success = true;
		TraceEvent ev("CheckSingletons");

		success &= self->checkSingleSingleton(allProcesses, ev, "Ratekeeper", 1);
		success &= self->checkSingleSingleton(allProcesses, ev, "DataDistributor", 1);
		success &= self->checkSingleSingleton(allProcesses, ev, "ConsistencyScan", 1);

		success &= self->checkSingleSingleton(
		    allProcesses,
		    ev,
		    "EncryptKeyProxy",
		    config.encryptionAtRestMode.isEncryptionEnabled() || SERVER_KNOBS->ENABLE_REST_KMS_COMMUNICATION ? 1 : 0);

		if (!success) {
			// TODO REMOVE
			fmt::print("ConsistencyCheck singletons: roles map:\n");
			for (int i = 0; i < allProcesses.size(); i++) {
				fmt::print(
				    "{0}: {1}\n", allProcesses[i]->address.toString(), g_simulator->getRoles(allProcesses[i]->address));
			}
		}

		return success;
	}
};

WorkloadFactory<ConsistencyCheckWorkload> ConsistencyCheckWorkloadFactory;
