#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbrpc/DDSketchTest.actor.cpp"
#include "fdbrpc/DDSketch.h"
#include "flow/Error.h"
#include "flow/IRandom.h"
#include "flow/UnitTest.h"
#include <limits>
#include <random>
#include "flow/actorcompiler.h" // has to be last include
void forceLinkDDSketchTests() {}

															#line 12 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbrpc/DDSketchTest.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase10()
															#line 10 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbrpc/DDSketchTest.actor.cpp"
template <class FlowTestCase10Actor>
															#line 10 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbrpc/DDSketchTest.actor.cpp"
class FlowTestCase10ActorState {
															#line 19 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbrpc/DDSketchTest.actor.g.cpp"
public:
															#line 10 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbrpc/DDSketchTest.actor.cpp"
	FlowTestCase10ActorState(UnitTestParameters const& params) 
															#line 10 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbrpc/DDSketchTest.actor.cpp"
															#line 10 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbrpc/DDSketchTest.actor.cpp"
		 : params(params)
															#line 26 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbrpc/DDSketchTest.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase10", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase10ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase10", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 12 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbrpc/DDSketchTest.actor.cpp"
			int TRY = 100, SIZE = 1e6;
															#line 13 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbrpc/DDSketchTest.actor.cpp"
			const int totalPercentiles = 7;
															#line 14 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbrpc/DDSketchTest.actor.cpp"
			double targetPercentiles[totalPercentiles] = { .0001, .01, .1, .50, .90, .99, .9999 };
															#line 15 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbrpc/DDSketchTest.actor.cpp"
			double stat[totalPercentiles] = { 0 };
															#line 16 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbrpc/DDSketchTest.actor.cpp"
			for(int t = 0;t < TRY;t++) {
															#line 17 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbrpc/DDSketchTest.actor.cpp"
				DDSketch<double> dd;
															#line 18 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbrpc/DDSketchTest.actor.cpp"
				std::vector<double> nums;
															#line 19 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbrpc/DDSketchTest.actor.cpp"
				for(int i = 0;i < SIZE;i++) {
															#line 20 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbrpc/DDSketchTest.actor.cpp"
					static double a = 1, b = 1;
															#line 21 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbrpc/DDSketchTest.actor.cpp"
					auto y = deterministicRandom()->random01();
															#line 22 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbrpc/DDSketchTest.actor.cpp"
					auto num = b / pow(1 - y, 1 / a);
															#line 23 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbrpc/DDSketchTest.actor.cpp"
					nums.push_back(num);
															#line 24 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbrpc/DDSketchTest.actor.cpp"
					dd.addSample(num);
															#line 65 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbrpc/DDSketchTest.actor.g.cpp"
				}
															#line 26 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbrpc/DDSketchTest.actor.cpp"
				std::sort(nums.begin(), nums.end());
															#line 27 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbrpc/DDSketchTest.actor.cpp"
				for(int percentID = 0;percentID < totalPercentiles;percentID++) {
															#line 28 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbrpc/DDSketchTest.actor.cpp"
					double percentile = targetPercentiles[percentID];
															#line 29 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbrpc/DDSketchTest.actor.cpp"
					double ground = nums[percentile * (SIZE - 1)], ddvalue = dd.percentile(percentile);
															#line 30 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbrpc/DDSketchTest.actor.cpp"
					double relativeError = fabs(ground - ddvalue) / ground;
															#line 31 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbrpc/DDSketchTest.actor.cpp"
					stat[percentID] += relativeError;
															#line 79 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbrpc/DDSketchTest.actor.g.cpp"
				}
			}
															#line 35 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbrpc/DDSketchTest.actor.cpp"
			for(int percentID = 0;percentID < totalPercentiles;percentID++) {
															#line 36 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbrpc/DDSketchTest.actor.cpp"
				printf("%.4lf per, relative error %.4lf\n", targetPercentiles[percentID], stat[percentID] / TRY);
															#line 86 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbrpc/DDSketchTest.actor.g.cpp"
			}
															#line 39 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbrpc/DDSketchTest.actor.cpp"
			if (!static_cast<FlowTestCase10Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase10ActorState(); static_cast<FlowTestCase10Actor*>(this)->destroy(); return 0; }
															#line 90 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbrpc/DDSketchTest.actor.g.cpp"
			new (&static_cast<FlowTestCase10Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase10ActorState();
			static_cast<FlowTestCase10Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase10ActorState();
		static_cast<FlowTestCase10Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 10 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbrpc/DDSketchTest.actor.cpp"
	UnitTestParameters params;
															#line 114 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbrpc/DDSketchTest.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase10()
															#line 10 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbrpc/DDSketchTest.actor.cpp"
class FlowTestCase10Actor final : public Actor<Void>, public FastAllocated<FlowTestCase10Actor>, public FlowTestCase10ActorState<FlowTestCase10Actor> {
															#line 119 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbrpc/DDSketchTest.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase10Actor>::operator new;
	using FastAllocated<FlowTestCase10Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8973769497125309440UL, 16092273321312587520UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 10 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbrpc/DDSketchTest.actor.cpp"
	FlowTestCase10Actor(UnitTestParameters const& params) 
															#line 135 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbrpc/DDSketchTest.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase10ActorState<FlowTestCase10Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase10", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8374354160890674176UL, 2811880604792684800UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase10Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase10");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase10", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 10 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbrpc/DDSketchTest.actor.cpp"
static Future<Void> flowTestCase10( UnitTestParameters const& params ) {
															#line 10 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbrpc/DDSketchTest.actor.cpp"
	return Future<Void>(new FlowTestCase10Actor(params));
															#line 167 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbrpc/DDSketchTest.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase10, "/fdbrpc/ddsketch/accuracy")

#line 41 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbrpc/DDSketchTest.actor.cpp"

															#line 173 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbrpc/DDSketchTest.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase42()
															#line 42 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbrpc/DDSketchTest.actor.cpp"
template <class FlowTestCase42Actor>
															#line 42 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbrpc/DDSketchTest.actor.cpp"
class FlowTestCase42ActorState {
															#line 180 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbrpc/DDSketchTest.actor.g.cpp"
public:
															#line 42 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbrpc/DDSketchTest.actor.cpp"
	FlowTestCase42ActorState(UnitTestParameters const& params) 
															#line 42 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbrpc/DDSketchTest.actor.cpp"
															#line 42 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbrpc/DDSketchTest.actor.cpp"
		 : params(params)
															#line 187 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbrpc/DDSketchTest.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase42", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase42ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase42", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 43 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbrpc/DDSketchTest.actor.cpp"
			DDSketch<double> dd;
															#line 45 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbrpc/DDSketchTest.actor.cpp"
			for(int i = 0;i < 4000;i++) {
															#line 48 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbrpc/DDSketchTest.actor.cpp"
				double sample = (static_cast<double>(deterministicRandom()->randomSkewedUInt32(40, 1000)) / 100000);
															#line 49 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbrpc/DDSketchTest.actor.cpp"
				dd.addSample(sample);
															#line 208 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbrpc/DDSketchTest.actor.g.cpp"
			}
															#line 51 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbrpc/DDSketchTest.actor.cpp"
			double p50 = dd.percentile(0.5);
															#line 52 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbrpc/DDSketchTest.actor.cpp"
			ASSERT(p50 > 0 && p50 != std::numeric_limits<double>::infinity());
															#line 53 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbrpc/DDSketchTest.actor.cpp"
			double p90 = dd.percentile(0.9);
															#line 54 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbrpc/DDSketchTest.actor.cpp"
			ASSERT(p90 > 0 && p90 != std::numeric_limits<double>::infinity());
															#line 55 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbrpc/DDSketchTest.actor.cpp"
			double p95 = dd.percentile(0.95);
															#line 56 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbrpc/DDSketchTest.actor.cpp"
			ASSERT(p95 > 0 && p95 != std::numeric_limits<double>::infinity());
															#line 57 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbrpc/DDSketchTest.actor.cpp"
			double p99 = dd.percentile(0.99);
															#line 58 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbrpc/DDSketchTest.actor.cpp"
			ASSERT(p99 > 0 && p99 != std::numeric_limits<double>::infinity());
															#line 59 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbrpc/DDSketchTest.actor.cpp"
			double p999 = dd.percentile(0.999);
															#line 60 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbrpc/DDSketchTest.actor.cpp"
			ASSERT(p999 > 0 && p999 != std::numeric_limits<double>::infinity());
															#line 61 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbrpc/DDSketchTest.actor.cpp"
			if (!static_cast<FlowTestCase42Actor*>(this)->SAV<Void>::futures) { (void)(Void{}); this->~FlowTestCase42ActorState(); static_cast<FlowTestCase42Actor*>(this)->destroy(); return 0; }
															#line 232 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbrpc/DDSketchTest.actor.g.cpp"
			new (&static_cast<FlowTestCase42Actor*>(this)->SAV< Void >::value()) Void(Void{});
			this->~FlowTestCase42ActorState();
			static_cast<FlowTestCase42Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase42ActorState();
		static_cast<FlowTestCase42Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 42 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbrpc/DDSketchTest.actor.cpp"
	UnitTestParameters params;
															#line 256 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbrpc/DDSketchTest.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase42()
															#line 42 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbrpc/DDSketchTest.actor.cpp"
class FlowTestCase42Actor final : public Actor<Void>, public FastAllocated<FlowTestCase42Actor>, public FlowTestCase42ActorState<FlowTestCase42Actor> {
															#line 261 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbrpc/DDSketchTest.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase42Actor>::operator new;
	using FastAllocated<FlowTestCase42Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6034188684848535040UL, 7586659659735719424UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 42 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbrpc/DDSketchTest.actor.cpp"
	FlowTestCase42Actor(UnitTestParameters const& params) 
															#line 277 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbrpc/DDSketchTest.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase42ActorState<FlowTestCase42Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase42", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16469678612378021632UL, 17997021132250192896UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase42Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase42");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase42", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 42 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbrpc/DDSketchTest.actor.cpp"
static Future<Void> flowTestCase42( UnitTestParameters const& params ) {
															#line 42 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbrpc/DDSketchTest.actor.cpp"
	return Future<Void>(new FlowTestCase42Actor(params));
															#line 309 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/fdbrpc/DDSketchTest.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase42, "/fdbrpc/ddsketch/correctness")

#line 63 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/fdbrpc/DDSketchTest.actor.cpp"
