#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
/*
 * Tester.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "tester/Tester.actor.h"
#include <cinttypes>
#ifdef __linux__
#include <string.h>
#endif

#include "bindings/flow/Tuple.h"
#include "bindings/flow/FDBLoanerTypes.h"
#include "fdbrpc/fdbrpc.h"
#include "flow/DeterministicRandom.h"
#include "flow/TLSConfig.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

// Otherwise we have to type setupNetwork(), FDB::open(), etc.
using namespace FDB;

std::map<std::string, FDBMutationType> optionInfo;
std::set<std::string> opsThatCreateDirectories;

std::map<Standalone<StringRef>, Reference<Transaction>> trMap;

// NOTE: This was taken from within fdb_c.cpp (where it is defined as a static within the get_range function).
// If that changes, this will also have to be changed.
const int ITERATION_PROGRESSION[] = { 256, 1000, 4096, 6144, 9216, 13824, 20736, 31104, 46656, 69984, 80000 };
const int MAX_ITERATION = sizeof(ITERATION_PROGRESSION) / sizeof(int);

static Future<Void> runTest(Reference<FlowTesterData> const& data,
                            Reference<Database> const& db,
                            StringRef const& prefix);

THREAD_FUNC networkThread(void* api) {
	// This is the fdb_flow network we're running on a thread
	((API*)api)->runNetwork();
	THREAD_RETURN;
}

bool hasEnding(std::string const& fullString, std::string const& ending) {
	if (fullString.length() >= ending.length()) {
		return (0 == fullString.compare(fullString.length() - ending.length(), ending.length(), ending));
	} else {
		return false;
	}
}

															#line 67 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
namespace {
// This generated class is to be used only via waitAndPop()
															#line 65 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
template <class WaitAndPopActor>
															#line 65 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
class WaitAndPopActorState {
															#line 74 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
public:
															#line 65 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	WaitAndPopActorState(FlowTesterStack* const& self,int const& count) 
															#line 65 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
															#line 65 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		 : self(self),
															#line 65 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		   count(count),
															#line 66 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		   tuples(),
															#line 67 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		   items(self->pop(count)),
															#line 69 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		   index()
															#line 89 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
	{
		fdb_probe_actor_create("waitAndPop", reinterpret_cast<unsigned long>(this));

	}
	~WaitAndPopActorState() 
	{
		fdb_probe_actor_destroy("waitAndPop", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 70 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			index = 0;
															#line 104 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WaitAndPopActorState();
		static_cast<WaitAndPopActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 75 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (!static_cast<WaitAndPopActor*>(this)->SAV<std::vector<Tuple>>::futures) { (void)(tuples); this->~WaitAndPopActorState(); static_cast<WaitAndPopActor*>(this)->destroy(); return 0; }
															#line 127 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		new (&static_cast<WaitAndPopActor*>(this)->SAV< std::vector<Tuple> >::value()) std::vector<Tuple>(std::move(tuples)); // state_var_RVO
		this->~WaitAndPopActorState();
		static_cast<WaitAndPopActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 70 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (!(index < items.size()))
															#line 146 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 71 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		StrictFuture<Standalone<StringRef>> __when_expr_0 = items[index].value;
															#line 71 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (static_cast<WaitAndPopActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 154 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<WaitAndPopActor*>(this)->actor_wait_state = 1;
															#line 71 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WaitAndPopActor, 0, Standalone<StringRef> >*>(static_cast<WaitAndPopActor*>(this)));
															#line 159 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Standalone<StringRef> const& itemStr,int loopDepth) 
	{
															#line 72 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		tuples.push_back(Tuple::unpack(itemStr));
															#line 70 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		++index;
															#line 183 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Standalone<StringRef> && itemStr,int loopDepth) 
	{
															#line 72 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		tuples.push_back(Tuple::unpack(itemStr));
															#line 70 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		++index;
															#line 194 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Standalone<StringRef> const& itemStr,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(itemStr, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Standalone<StringRef> && itemStr,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(itemStr), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WaitAndPopActor*>(this)->actor_wait_state > 0) static_cast<WaitAndPopActor*>(this)->actor_wait_state = 0;
		static_cast<WaitAndPopActor*>(this)->ActorCallback< WaitAndPopActor, 0, Standalone<StringRef> >::remove();

	}
	void a_callback_fire(ActorCallback< WaitAndPopActor, 0, Standalone<StringRef> >*,Standalone<StringRef> const& value) 
	{
		fdb_probe_actor_enter("waitAndPop", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitAndPopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitAndPop", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WaitAndPopActor, 0, Standalone<StringRef> >*,Standalone<StringRef> && value) 
	{
		fdb_probe_actor_enter("waitAndPop", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitAndPopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitAndPop", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WaitAndPopActor, 0, Standalone<StringRef> >*,Error err) 
	{
		fdb_probe_actor_enter("waitAndPop", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitAndPopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitAndPop", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 65 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	FlowTesterStack* self;
															#line 65 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	int count;
															#line 66 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	std::vector<Tuple> tuples;
															#line 67 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	std::vector<StackItem> items;
															#line 69 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	int index;
															#line 284 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
};
// This generated class is to be used only via waitAndPop()
															#line 65 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
class WaitAndPopActor final : public Actor<std::vector<Tuple>>, public ActorCallback< WaitAndPopActor, 0, Standalone<StringRef> >, public FastAllocated<WaitAndPopActor>, public WaitAndPopActorState<WaitAndPopActor> {
															#line 289 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
public:
	using FastAllocated<WaitAndPopActor>::operator new;
	using FastAllocated<WaitAndPopActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4565381991441003008UL, 14715457880247596032UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<Tuple>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WaitAndPopActor, 0, Standalone<StringRef> >;
															#line 65 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	WaitAndPopActor(FlowTesterStack* const& self,int const& count) 
															#line 306 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		 : Actor<std::vector<Tuple>>(),
		   WaitAndPopActorState<WaitAndPopActor>(self, count),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("waitAndPop", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2276367422354721024UL, 17569921465329150208UL);
		ActorExecutionContextHelper __helper(static_cast<WaitAndPopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("waitAndPop");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("waitAndPop", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WaitAndPopActor, 0, Standalone<StringRef> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 65 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
[[nodiscard]] Future<std::vector<Tuple>> waitAndPop( FlowTesterStack* const& self, int const& count ) {
															#line 65 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	return Future<std::vector<Tuple>>(new WaitAndPopActor(self, count));
															#line 339 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
}

#line 77 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"

Future<std::vector<Tuple>> FlowTesterStack::waitAndPop(int count) {
	return ::waitAndPop(this, count);
}

															#line 348 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
namespace {
// This generated class is to be used only via waitAndPop()
															#line 82 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
template <class WaitAndPopActor1>
															#line 82 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
class WaitAndPopActor1State {
															#line 355 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
public:
															#line 82 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	WaitAndPopActor1State(FlowTesterStack* const& self) 
															#line 82 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
															#line 82 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		 : self(self)
															#line 362 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
	{
		fdb_probe_actor_create("waitAndPop", reinterpret_cast<unsigned long>(this));

	}
	~WaitAndPopActor1State() 
	{
		fdb_probe_actor_destroy("waitAndPop", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 83 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			StrictFuture<std::vector<Tuple>> __when_expr_0 = waitAndPop(self, 1);
															#line 83 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (static_cast<WaitAndPopActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 379 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<WaitAndPopActor1*>(this)->actor_wait_state = 1;
															#line 83 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WaitAndPopActor1, 0, std::vector<Tuple> >*>(static_cast<WaitAndPopActor1*>(this)));
															#line 384 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WaitAndPopActor1State();
		static_cast<WaitAndPopActor1*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<Tuple> const& tuples,int loopDepth) 
	{
															#line 84 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (!static_cast<WaitAndPopActor1*>(this)->SAV<Tuple>::futures) { (void)(tuples[0]); this->~WaitAndPopActor1State(); static_cast<WaitAndPopActor1*>(this)->destroy(); return 0; }
															#line 407 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		new (&static_cast<WaitAndPopActor1*>(this)->SAV< Tuple >::value()) Tuple(tuples[0]);
		this->~WaitAndPopActor1State();
		static_cast<WaitAndPopActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<Tuple> && tuples,int loopDepth) 
	{
															#line 84 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (!static_cast<WaitAndPopActor1*>(this)->SAV<Tuple>::futures) { (void)(tuples[0]); this->~WaitAndPopActor1State(); static_cast<WaitAndPopActor1*>(this)->destroy(); return 0; }
															#line 419 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		new (&static_cast<WaitAndPopActor1*>(this)->SAV< Tuple >::value()) Tuple(tuples[0]);
		this->~WaitAndPopActor1State();
		static_cast<WaitAndPopActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(std::vector<Tuple> const& tuples,int loopDepth) 
	{
		loopDepth = a_body1cont1(tuples, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<Tuple> && tuples,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(tuples), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WaitAndPopActor1*>(this)->actor_wait_state > 0) static_cast<WaitAndPopActor1*>(this)->actor_wait_state = 0;
		static_cast<WaitAndPopActor1*>(this)->ActorCallback< WaitAndPopActor1, 0, std::vector<Tuple> >::remove();

	}
	void a_callback_fire(ActorCallback< WaitAndPopActor1, 0, std::vector<Tuple> >*,std::vector<Tuple> const& value) 
	{
		fdb_probe_actor_enter("waitAndPop", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitAndPopActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitAndPop", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WaitAndPopActor1, 0, std::vector<Tuple> >*,std::vector<Tuple> && value) 
	{
		fdb_probe_actor_enter("waitAndPop", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitAndPopActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitAndPop", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WaitAndPopActor1, 0, std::vector<Tuple> >*,Error err) 
	{
		fdb_probe_actor_enter("waitAndPop", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitAndPopActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitAndPop", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 82 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	FlowTesterStack* self;
															#line 504 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
};
// This generated class is to be used only via waitAndPop()
															#line 82 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
class WaitAndPopActor1 final : public Actor<Tuple>, public ActorCallback< WaitAndPopActor1, 0, std::vector<Tuple> >, public FastAllocated<WaitAndPopActor1>, public WaitAndPopActor1State<WaitAndPopActor1> {
															#line 509 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
public:
	using FastAllocated<WaitAndPopActor1>::operator new;
	using FastAllocated<WaitAndPopActor1>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4565381991441003008UL, 14715457880247596032UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Tuple>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WaitAndPopActor1, 0, std::vector<Tuple> >;
															#line 82 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	WaitAndPopActor1(FlowTesterStack* const& self) 
															#line 526 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		 : Actor<Tuple>(),
		   WaitAndPopActor1State<WaitAndPopActor1>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("waitAndPop", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17590324452960953600UL, 17035958224850430976UL);
		ActorExecutionContextHelper __helper(static_cast<WaitAndPopActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("waitAndPop");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("waitAndPop", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WaitAndPopActor1, 0, std::vector<Tuple> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 82 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
[[nodiscard]] Future<Tuple> waitAndPop( FlowTesterStack* const& self ) {
															#line 82 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	return Future<Tuple>(new WaitAndPopActor1(self));
															#line 559 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
}

#line 86 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"

Future<Tuple> FlowTesterStack::waitAndPop() {
	return ::waitAndPop(this);
}

std::string tupleToString(Tuple const& tuple) {
	std::string str = "(";
	for (int i = 0; i < tuple.size(); ++i) {
		Tuple::ElementType type = tuple.getType(i);
		if (type == Tuple::NULL_TYPE) {
			str += "NULL";
		} else if (type == Tuple::BYTES || type == Tuple::UTF8) {
			if (type == Tuple::UTF8) {
				str += "u";
			}
			str += "\'" + tuple.getString(i).printable() + "\'";
		} else if (type == Tuple::INT) {
			str += format("%ld", tuple.getInt(i));
		} else if (type == Tuple::FLOAT) {
			str += format("%f", tuple.getFloat(i));
		} else if (type == Tuple::DOUBLE) {
			str += format("%f", tuple.getDouble(i));
		} else if (type == Tuple::BOOL) {
			str += tuple.getBool(i) ? "true" : "false";
		} else if (type == Tuple::UUID) {
			Uuid u = tuple.getUuid(i);
			str += format("%016llx%016llx", *(uint64_t*)u.getData().begin(), *(uint64_t*)(u.getData().begin() + 8));
		} else if (type == Tuple::NESTED) {
			str += tupleToString(tuple.getNested(i));
		} else if (type == Tuple::VERSIONSTAMP) {
			Versionstamp versionstamp = tuple.getVersionstamp(i);
			str += format("Transaction Version: '%ld', BatchNumber: '%hd', UserVersion : '%hd'",
			              versionstamp.getVersion(),
			              versionstamp.getBatchNumber(),
			              versionstamp.getUserVersion());
		} else {
			ASSERT(false);
		}

		if (i < tuple.size() - 1) {
			str += ", ";
		}
	}

	str += ")";
	return str;
}

															#line 611 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
namespace {
// This generated class is to be used only via getRange()
															#line 134 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
template <class GetRangeActor>
															#line 134 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
class GetRangeActorState {
															#line 618 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
public:
															#line 134 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	GetRangeActorState(Reference<Transaction> const& tr,KeySelectorRef const& begin,KeySelectorRef const& end,int const& limits = 0,bool const& snapshot = false,bool const& reverse = false,FDBStreamingMode const& streamingMode = FDB_STREAMING_MODE_SERIAL) 
															#line 134 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
															#line 134 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		 : tr(tr),
															#line 134 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		   begin(begin),
															#line 134 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		   end(end),
															#line 134 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		   limits(limits),
															#line 134 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		   snapshot(snapshot),
															#line 134 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		   reverse(reverse),
															#line 134 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		   streamingMode(streamingMode),
															#line 141 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		   ks_begin(begin),
															#line 142 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		   ks_end(end),
															#line 143 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		   results(),
															#line 144 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		   iteration(1)
															#line 645 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
	{
		fdb_probe_actor_create("getRange", reinterpret_cast<unsigned long>(this));

	}
	~GetRangeActorState() 
	{
		fdb_probe_actor_destroy("getRange", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 145 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			;
															#line 660 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetRangeActorState();
		static_cast<GetRangeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 148 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		r = FDBStandalone<RangeResultRef>();
															#line 149 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (streamingMode == FDB_STREAMING_MODE_ITERATOR && iteration > 1)
															#line 692 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		{
															#line 150 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			int effective_iteration = std::min(iteration, MAX_ITERATION);
															#line 151 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			int bytes_limit = ITERATION_PROGRESSION[effective_iteration - 1];
															#line 152 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			StrictFuture<FDBStandalone<RangeResultRef>> __when_expr_0 = tr->getRange(ks_begin, ks_end, GetRangeLimits(limits, bytes_limit), snapshot, reverse, (FDBStreamingMode)FDB_STREAMING_MODE_EXACT);
															#line 152 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (static_cast<GetRangeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 702 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetRangeActor*>(this)->actor_wait_state = 1;
															#line 152 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetRangeActor, 0, FDBStandalone<RangeResultRef> >*>(static_cast<GetRangeActor*>(this)));
															#line 707 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 160 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			StrictFuture<FDBStandalone<RangeResultRef>> __when_expr_1 = tr->getRange(ks_begin, ks_end, limits, snapshot, reverse, streamingMode);
															#line 160 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (static_cast<GetRangeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 716 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
			static_cast<GetRangeActor*>(this)->actor_wait_state = 2;
															#line 160 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetRangeActor, 1, FDBStandalone<RangeResultRef> >*>(static_cast<GetRangeActor*>(this)));
															#line 721 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 164 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		iteration += 1;
															#line 166 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		for( auto& s : r ) {
															#line 169 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			results.push_back_deep(results.arena(), s);
															#line 171 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (reverse)
															#line 737 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			{
															#line 172 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
				ks_end = KeySelector(firstGreaterOrEqual(s.key));
															#line 741 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			}
			else
			{
															#line 174 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
				ks_begin = KeySelector(firstGreaterThan(s.key));
															#line 747 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			}
		}
															#line 177 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		ASSERT(limits == 0 || limits >= r.size());
															#line 179 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (!r.more || (limits > 0 && limits == r.size()))
															#line 754 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		{
															#line 180 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (!static_cast<GetRangeActor*>(this)->SAV<Standalone<RangeResultRef>>::futures) { (void)(results); this->~GetRangeActorState(); static_cast<GetRangeActor*>(this)->destroy(); return 0; }
															#line 758 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			new (&static_cast<GetRangeActor*>(this)->SAV< Standalone<RangeResultRef> >::value()) Standalone<RangeResultRef>(std::move(results)); // state_var_RVO
			this->~GetRangeActorState();
			static_cast<GetRangeActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 183 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (limits > 0)
															#line 766 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		{
															#line 184 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			limits -= r.size();
															#line 770 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2(FDBStandalone<RangeResultRef> const& rTemp,int loopDepth) 
	{
															#line 158 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		r = rTemp;
															#line 780 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2(FDBStandalone<RangeResultRef> && rTemp,int loopDepth) 
	{
															#line 158 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		r = rTemp;
															#line 789 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(FDBStandalone<RangeResultRef> const& rTemp,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(rTemp, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(FDBStandalone<RangeResultRef> && rTemp,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(rTemp), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetRangeActor*>(this)->actor_wait_state > 0) static_cast<GetRangeActor*>(this)->actor_wait_state = 0;
		static_cast<GetRangeActor*>(this)->ActorCallback< GetRangeActor, 0, FDBStandalone<RangeResultRef> >::remove();

	}
	void a_callback_fire(ActorCallback< GetRangeActor, 0, FDBStandalone<RangeResultRef> >*,FDBStandalone<RangeResultRef> const& value) 
	{
		fdb_probe_actor_enter("getRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetRangeActor, 0, FDBStandalone<RangeResultRef> >*,FDBStandalone<RangeResultRef> && value) 
	{
		fdb_probe_actor_enter("getRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetRangeActor, 0, FDBStandalone<RangeResultRef> >*,Error err) 
	{
		fdb_probe_actor_enter("getRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRange", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont4(FDBStandalone<RangeResultRef> const& rTemp,int loopDepth) 
	{
															#line 162 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		r = rTemp;
															#line 873 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4(FDBStandalone<RangeResultRef> && rTemp,int loopDepth) 
	{
															#line 162 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		r = rTemp;
															#line 882 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(FDBStandalone<RangeResultRef> const& rTemp,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(rTemp, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(FDBStandalone<RangeResultRef> && rTemp,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(rTemp), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetRangeActor*>(this)->actor_wait_state > 0) static_cast<GetRangeActor*>(this)->actor_wait_state = 0;
		static_cast<GetRangeActor*>(this)->ActorCallback< GetRangeActor, 1, FDBStandalone<RangeResultRef> >::remove();

	}
	void a_callback_fire(ActorCallback< GetRangeActor, 1, FDBStandalone<RangeResultRef> >*,FDBStandalone<RangeResultRef> const& value) 
	{
		fdb_probe_actor_enter("getRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRange", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetRangeActor, 1, FDBStandalone<RangeResultRef> >*,FDBStandalone<RangeResultRef> && value) 
	{
		fdb_probe_actor_enter("getRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRange", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetRangeActor, 1, FDBStandalone<RangeResultRef> >*,Error err) 
	{
		fdb_probe_actor_enter("getRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRange", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 134 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Reference<Transaction> tr;
															#line 134 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	KeySelectorRef begin;
															#line 134 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	KeySelectorRef end;
															#line 134 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	int limits;
															#line 134 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	bool snapshot;
															#line 134 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	bool reverse;
															#line 134 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	FDBStreamingMode streamingMode;
															#line 141 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	KeySelector ks_begin;
															#line 142 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	KeySelector ks_end;
															#line 143 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Standalone<RangeResultRef> results;
															#line 144 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	int iteration;
															#line 148 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	FDBStandalone<RangeResultRef> r;
															#line 986 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
};
// This generated class is to be used only via getRange()
															#line 134 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
class GetRangeActor final : public Actor<Standalone<RangeResultRef>>, public ActorCallback< GetRangeActor, 0, FDBStandalone<RangeResultRef> >, public ActorCallback< GetRangeActor, 1, FDBStandalone<RangeResultRef> >, public FastAllocated<GetRangeActor>, public GetRangeActorState<GetRangeActor> {
															#line 991 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
public:
	using FastAllocated<GetRangeActor>::operator new;
	using FastAllocated<GetRangeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16516927833547530240UL, 14738995955412540160UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Standalone<RangeResultRef>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetRangeActor, 0, FDBStandalone<RangeResultRef> >;
friend struct ActorCallback< GetRangeActor, 1, FDBStandalone<RangeResultRef> >;
															#line 134 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	GetRangeActor(Reference<Transaction> const& tr,KeySelectorRef const& begin,KeySelectorRef const& end,int const& limits = 0,bool const& snapshot = false,bool const& reverse = false,FDBStreamingMode const& streamingMode = FDB_STREAMING_MODE_SERIAL) 
															#line 1009 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		 : Actor<Standalone<RangeResultRef>>(),
		   GetRangeActorState<GetRangeActor>(tr, begin, end, limits, snapshot, reverse, streamingMode),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getRange", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2910272544121951744UL, 708275608187718144UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getRange");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getRange", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetRangeActor, 0, FDBStandalone<RangeResultRef> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetRangeActor, 1, FDBStandalone<RangeResultRef> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 134 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
[[nodiscard]] Future<Standalone<RangeResultRef>> getRange( Reference<Transaction> const& tr, KeySelectorRef const& begin, KeySelectorRef const& end, int const& limits = 0, bool const& snapshot = false, bool const& reverse = false, FDBStreamingMode const& streamingMode = FDB_STREAMING_MODE_SERIAL ) {
															#line 134 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	return Future<Standalone<RangeResultRef>>(new GetRangeActor(tr, begin, end, limits, snapshot, reverse, streamingMode));
															#line 1043 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
}

#line 188 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"

															#line 1048 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
namespace {
// This generated class is to be used only via getRange()
															#line 189 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
template <class GetRangeActor1>
															#line 189 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
class GetRangeActor1State {
															#line 1055 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
public:
															#line 189 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	GetRangeActor1State(Reference<Transaction> const& tr,KeyRange const& keys,int const& limits = 0,bool const& snapshot = false,bool const& reverse = false,FDBStreamingMode const& streamingMode = FDB_STREAMING_MODE_SERIAL) 
															#line 189 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
															#line 189 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		 : tr(tr),
															#line 189 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		   keys(keys),
															#line 189 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		   limits(limits),
															#line 189 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		   snapshot(snapshot),
															#line 189 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		   reverse(reverse),
															#line 189 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		   streamingMode(streamingMode),
															#line 195 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		   begin(keys.begin),
															#line 196 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		   end(keys.end),
															#line 197 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		   results(),
															#line 198 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		   iteration(1)
															#line 1080 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
	{
		fdb_probe_actor_create("getRange", reinterpret_cast<unsigned long>(this));

	}
	~GetRangeActor1State() 
	{
		fdb_probe_actor_destroy("getRange", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 199 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			;
															#line 1095 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetRangeActor1State();
		static_cast<GetRangeActor1*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 201 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		KeyRange keyRange(KeyRangeRef(begin, end > begin ? end : begin));
															#line 202 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		r = FDBStandalone<RangeResultRef>();
															#line 203 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (streamingMode == FDB_STREAMING_MODE_ITERATOR && iteration > 1)
															#line 1129 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		{
															#line 204 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			int effective_iteration = std::min(iteration, MAX_ITERATION);
															#line 205 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			int bytes_limit = ITERATION_PROGRESSION[effective_iteration - 1];
															#line 206 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			StrictFuture<FDBStandalone<RangeResultRef>> __when_expr_0 = tr->getRange(keyRange, GetRangeLimits(limits, bytes_limit), snapshot, reverse, (FDBStreamingMode)FDB_STREAMING_MODE_EXACT);
															#line 206 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (static_cast<GetRangeActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1139 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetRangeActor1*>(this)->actor_wait_state = 1;
															#line 206 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetRangeActor1, 0, FDBStandalone<RangeResultRef> >*>(static_cast<GetRangeActor1*>(this)));
															#line 1144 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 213 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			StrictFuture<FDBStandalone<RangeResultRef>> __when_expr_1 = tr->getRange(keyRange, limits, snapshot, reverse, streamingMode);
															#line 213 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (static_cast<GetRangeActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1153 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
			static_cast<GetRangeActor1*>(this)->actor_wait_state = 2;
															#line 213 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetRangeActor1, 1, FDBStandalone<RangeResultRef> >*>(static_cast<GetRangeActor1*>(this)));
															#line 1158 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 217 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		iteration += 1;
															#line 219 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		for( auto& s : r ) {
															#line 222 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			results.push_back_deep(results.arena(), s);
															#line 224 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (reverse)
															#line 1174 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			{
															#line 225 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
				end = s.key;
															#line 1178 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			}
			else
			{
															#line 227 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
				begin = keyAfter(s.key);
															#line 1184 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			}
		}
															#line 230 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		ASSERT(limits == 0 || limits >= r.size());
															#line 232 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (!r.more || (limits > 0 && limits == r.size()))
															#line 1191 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		{
															#line 233 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (!static_cast<GetRangeActor1*>(this)->SAV<Standalone<RangeResultRef>>::futures) { (void)(results); this->~GetRangeActor1State(); static_cast<GetRangeActor1*>(this)->destroy(); return 0; }
															#line 1195 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			new (&static_cast<GetRangeActor1*>(this)->SAV< Standalone<RangeResultRef> >::value()) Standalone<RangeResultRef>(std::move(results)); // state_var_RVO
			this->~GetRangeActor1State();
			static_cast<GetRangeActor1*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 236 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (limits > 0)
															#line 1203 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		{
															#line 237 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			limits -= r.size();
															#line 1207 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2(FDBStandalone<RangeResultRef> const& rTemp,int loopDepth) 
	{
															#line 211 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		r = rTemp;
															#line 1217 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2(FDBStandalone<RangeResultRef> && rTemp,int loopDepth) 
	{
															#line 211 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		r = rTemp;
															#line 1226 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(FDBStandalone<RangeResultRef> const& rTemp,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(rTemp, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(FDBStandalone<RangeResultRef> && rTemp,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(rTemp), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetRangeActor1*>(this)->actor_wait_state > 0) static_cast<GetRangeActor1*>(this)->actor_wait_state = 0;
		static_cast<GetRangeActor1*>(this)->ActorCallback< GetRangeActor1, 0, FDBStandalone<RangeResultRef> >::remove();

	}
	void a_callback_fire(ActorCallback< GetRangeActor1, 0, FDBStandalone<RangeResultRef> >*,FDBStandalone<RangeResultRef> const& value) 
	{
		fdb_probe_actor_enter("getRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetRangeActor1, 0, FDBStandalone<RangeResultRef> >*,FDBStandalone<RangeResultRef> && value) 
	{
		fdb_probe_actor_enter("getRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetRangeActor1, 0, FDBStandalone<RangeResultRef> >*,Error err) 
	{
		fdb_probe_actor_enter("getRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRange", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont4(FDBStandalone<RangeResultRef> const& rTemp,int loopDepth) 
	{
															#line 215 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		r = rTemp;
															#line 1310 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4(FDBStandalone<RangeResultRef> && rTemp,int loopDepth) 
	{
															#line 215 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		r = rTemp;
															#line 1319 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(FDBStandalone<RangeResultRef> const& rTemp,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(rTemp, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(FDBStandalone<RangeResultRef> && rTemp,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(rTemp), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetRangeActor1*>(this)->actor_wait_state > 0) static_cast<GetRangeActor1*>(this)->actor_wait_state = 0;
		static_cast<GetRangeActor1*>(this)->ActorCallback< GetRangeActor1, 1, FDBStandalone<RangeResultRef> >::remove();

	}
	void a_callback_fire(ActorCallback< GetRangeActor1, 1, FDBStandalone<RangeResultRef> >*,FDBStandalone<RangeResultRef> const& value) 
	{
		fdb_probe_actor_enter("getRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRange", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetRangeActor1, 1, FDBStandalone<RangeResultRef> >*,FDBStandalone<RangeResultRef> && value) 
	{
		fdb_probe_actor_enter("getRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRange", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetRangeActor1, 1, FDBStandalone<RangeResultRef> >*,Error err) 
	{
		fdb_probe_actor_enter("getRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRange", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 189 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Reference<Transaction> tr;
															#line 189 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	KeyRange keys;
															#line 189 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	int limits;
															#line 189 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	bool snapshot;
															#line 189 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	bool reverse;
															#line 189 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	FDBStreamingMode streamingMode;
															#line 195 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Key begin;
															#line 196 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Key end;
															#line 197 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Standalone<RangeResultRef> results;
															#line 198 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	int iteration;
															#line 202 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	FDBStandalone<RangeResultRef> r;
															#line 1421 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
};
// This generated class is to be used only via getRange()
															#line 189 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
class GetRangeActor1 final : public Actor<Standalone<RangeResultRef>>, public ActorCallback< GetRangeActor1, 0, FDBStandalone<RangeResultRef> >, public ActorCallback< GetRangeActor1, 1, FDBStandalone<RangeResultRef> >, public FastAllocated<GetRangeActor1>, public GetRangeActor1State<GetRangeActor1> {
															#line 1426 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
public:
	using FastAllocated<GetRangeActor1>::operator new;
	using FastAllocated<GetRangeActor1>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16516927833547530240UL, 14738995955412540160UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Standalone<RangeResultRef>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetRangeActor1, 0, FDBStandalone<RangeResultRef> >;
friend struct ActorCallback< GetRangeActor1, 1, FDBStandalone<RangeResultRef> >;
															#line 189 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	GetRangeActor1(Reference<Transaction> const& tr,KeyRange const& keys,int const& limits = 0,bool const& snapshot = false,bool const& reverse = false,FDBStreamingMode const& streamingMode = FDB_STREAMING_MODE_SERIAL) 
															#line 1444 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		 : Actor<Standalone<RangeResultRef>>(),
		   GetRangeActor1State<GetRangeActor1>(tr, keys, limits, snapshot, reverse, streamingMode),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getRange", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14899016192186556672UL, 17515356096133262080UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getRange");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getRange", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetRangeActor1, 0, FDBStandalone<RangeResultRef> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetRangeActor1, 1, FDBStandalone<RangeResultRef> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 189 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
[[nodiscard]] Future<Standalone<RangeResultRef>> getRange( Reference<Transaction> const& tr, KeyRange const& keys, int const& limits = 0, bool const& snapshot = false, bool const& reverse = false, FDBStreamingMode const& streamingMode = FDB_STREAMING_MODE_SERIAL ) {
															#line 189 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	return Future<Standalone<RangeResultRef>>(new GetRangeActor1(tr, keys, limits, snapshot, reverse, streamingMode));
															#line 1478 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
}

#line 241 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"

// ACTOR static Future<Void> debugPrintRange(Reference<Transaction> tr, std::string subspace, std::string msg) {
//	if (!tr)
//		return Void();
//
//	Standalone<RangeResultRef> results = wait(getRange(tr, KeyRange(KeyRangeRef(subspace + '\x00', subspace +
//'\xff')))); 	printf("==================================================DB:%s:%s, count:%d\n", msg.c_str(),
//	       StringRef(subspace).printable().c_str(), results.size());
//	for (auto & s : results) {
//		printf("=====key:%s, value:%s\n", StringRef(s.key).printable().c_str(), StringRef(s.value).printable().c_str());
//	}
//
//	return Void();
//}

															#line 1497 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
namespace {
// This generated class is to be used only via stackSub()
															#line 256 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
template <class StackSubActor>
															#line 256 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
class StackSubActorState {
															#line 1504 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
public:
															#line 256 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	StackSubActorState(FlowTesterStack* const& stack) 
															#line 256 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
															#line 256 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		 : stack(stack)
															#line 1511 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
	{
		fdb_probe_actor_create("stackSub", reinterpret_cast<unsigned long>(this));

	}
	~StackSubActorState() 
	{
		fdb_probe_actor_destroy("stackSub", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 257 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (stack->data.size() < 2)
															#line 1526 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			{
															#line 258 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
				if (!static_cast<StackSubActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~StackSubActorState(); static_cast<StackSubActor*>(this)->destroy(); return 0; }
															#line 1530 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
				new (&static_cast<StackSubActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~StackSubActorState();
				static_cast<StackSubActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 260 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			StackItem a = stack->data.back();
															#line 261 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			stack->data.pop_back();
															#line 262 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			StrictFuture<Standalone<StringRef>> __when_expr_0 = a.value;
															#line 262 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (static_cast<StackSubActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1544 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<StackSubActor*>(this)->actor_wait_state = 1;
															#line 262 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< StackSubActor, 0, Standalone<StringRef> >*>(static_cast<StackSubActor*>(this)));
															#line 1549 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~StackSubActorState();
		static_cast<StackSubActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 264 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		StackItem b = stack->data.back();
															#line 265 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		stack->data.pop_back();
															#line 266 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		StrictFuture<Standalone<StringRef>> __when_expr_1 = b.value;
															#line 266 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (static_cast<StackSubActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1578 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<StackSubActor*>(this)->actor_wait_state = 2;
															#line 266 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< StackSubActor, 1, Standalone<StringRef> >*>(static_cast<StackSubActor*>(this)));
															#line 1583 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Standalone<StringRef> const& __sa,int loopDepth) 
	{
															#line 262 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		sa = __sa;
															#line 1592 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Standalone<StringRef> && __sa,int loopDepth) 
	{
		sa = std::move(__sa);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<StackSubActor*>(this)->actor_wait_state > 0) static_cast<StackSubActor*>(this)->actor_wait_state = 0;
		static_cast<StackSubActor*>(this)->ActorCallback< StackSubActor, 0, Standalone<StringRef> >::remove();

	}
	void a_callback_fire(ActorCallback< StackSubActor, 0, Standalone<StringRef> >*,Standalone<StringRef> const& value) 
	{
		fdb_probe_actor_enter("stackSub", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StackSubActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("stackSub", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< StackSubActor, 0, Standalone<StringRef> >*,Standalone<StringRef> && value) 
	{
		fdb_probe_actor_enter("stackSub", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StackSubActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("stackSub", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< StackSubActor, 0, Standalone<StringRef> >*,Error err) 
	{
		fdb_probe_actor_enter("stackSub", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StackSubActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("stackSub", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(Standalone<StringRef> const& sb,int loopDepth) 
	{
															#line 268 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		int64_t c = Tuple::unpack(sa).getInt(0) - Tuple::unpack(sb).getInt(0);
															#line 269 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		Tuple f;
															#line 270 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		f.append(c);
															#line 271 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		stack->push(f.pack());
															#line 273 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (!static_cast<StackSubActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~StackSubActorState(); static_cast<StackSubActor*>(this)->destroy(); return 0; }
															#line 1679 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		new (&static_cast<StackSubActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~StackSubActorState();
		static_cast<StackSubActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Standalone<StringRef> && sb,int loopDepth) 
	{
															#line 268 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		int64_t c = Tuple::unpack(sa).getInt(0) - Tuple::unpack(sb).getInt(0);
															#line 269 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		Tuple f;
															#line 270 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		f.append(c);
															#line 271 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		stack->push(f.pack());
															#line 273 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (!static_cast<StackSubActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~StackSubActorState(); static_cast<StackSubActor*>(this)->destroy(); return 0; }
															#line 1699 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		new (&static_cast<StackSubActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~StackSubActorState();
		static_cast<StackSubActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Standalone<StringRef> const& sb,int loopDepth) 
	{
		loopDepth = a_body1cont3(sb, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Standalone<StringRef> && sb,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(sb), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<StackSubActor*>(this)->actor_wait_state > 0) static_cast<StackSubActor*>(this)->actor_wait_state = 0;
		static_cast<StackSubActor*>(this)->ActorCallback< StackSubActor, 1, Standalone<StringRef> >::remove();

	}
	void a_callback_fire(ActorCallback< StackSubActor, 1, Standalone<StringRef> >*,Standalone<StringRef> const& value) 
	{
		fdb_probe_actor_enter("stackSub", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StackSubActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("stackSub", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< StackSubActor, 1, Standalone<StringRef> >*,Standalone<StringRef> && value) 
	{
		fdb_probe_actor_enter("stackSub", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StackSubActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("stackSub", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< StackSubActor, 1, Standalone<StringRef> >*,Error err) 
	{
		fdb_probe_actor_enter("stackSub", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StackSubActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("stackSub", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 256 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	FlowTesterStack* stack;
															#line 262 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Standalone<StringRef> sa;
															#line 1786 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
};
// This generated class is to be used only via stackSub()
															#line 256 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
class StackSubActor final : public Actor<Void>, public ActorCallback< StackSubActor, 0, Standalone<StringRef> >, public ActorCallback< StackSubActor, 1, Standalone<StringRef> >, public FastAllocated<StackSubActor>, public StackSubActorState<StackSubActor> {
															#line 1791 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
public:
	using FastAllocated<StackSubActor>::operator new;
	using FastAllocated<StackSubActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11303568713690403584UL, 1034621591775035136UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< StackSubActor, 0, Standalone<StringRef> >;
friend struct ActorCallback< StackSubActor, 1, Standalone<StringRef> >;
															#line 256 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	StackSubActor(FlowTesterStack* const& stack) 
															#line 1809 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		 : Actor<Void>(),
		   StackSubActorState<StackSubActor>(stack),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("stackSub", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7612860044756040704UL, 18307318686107614464UL);
		ActorExecutionContextHelper __helper(static_cast<StackSubActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("stackSub");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("stackSub", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< StackSubActor, 0, Standalone<StringRef> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< StackSubActor, 1, Standalone<StringRef> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 256 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
[[nodiscard]] Future<Void> stackSub( FlowTesterStack* const& stack ) {
															#line 256 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	return Future<Void>(new StackSubActor(stack));
															#line 1843 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
}

#line 275 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"

															#line 1848 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
namespace {
// This generated class is to be used only via stackConcat()
															#line 276 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
template <class StackConcatActor>
															#line 276 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
class StackConcatActorState {
															#line 1855 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
public:
															#line 276 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	StackConcatActorState(FlowTesterStack* const& stack) 
															#line 276 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
															#line 276 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		 : stack(stack)
															#line 1862 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
	{
		fdb_probe_actor_create("stackConcat", reinterpret_cast<unsigned long>(this));

	}
	~StackConcatActorState() 
	{
		fdb_probe_actor_destroy("stackConcat", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 277 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (stack->data.size() < 2)
															#line 1877 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			{
															#line 278 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
				if (!static_cast<StackConcatActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~StackConcatActorState(); static_cast<StackConcatActor*>(this)->destroy(); return 0; }
															#line 1881 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
				new (&static_cast<StackConcatActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~StackConcatActorState();
				static_cast<StackConcatActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 280 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			StackItem a = stack->data.back();
															#line 281 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			stack->data.pop_back();
															#line 282 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			StrictFuture<Standalone<StringRef>> __when_expr_0 = a.value;
															#line 282 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (static_cast<StackConcatActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1895 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<StackConcatActor*>(this)->actor_wait_state = 1;
															#line 282 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< StackConcatActor, 0, Standalone<StringRef> >*>(static_cast<StackConcatActor*>(this)));
															#line 1900 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~StackConcatActorState();
		static_cast<StackConcatActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 283 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		ta = Tuple::unpack(sa);
															#line 285 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		StackItem b = stack->data.back();
															#line 286 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		stack->data.pop_back();
															#line 287 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		StrictFuture<Standalone<StringRef>> __when_expr_1 = b.value;
															#line 287 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (static_cast<StackConcatActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1931 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<StackConcatActor*>(this)->actor_wait_state = 2;
															#line 287 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< StackConcatActor, 1, Standalone<StringRef> >*>(static_cast<StackConcatActor*>(this)));
															#line 1936 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Standalone<StringRef> const& __sa,int loopDepth) 
	{
															#line 282 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		sa = __sa;
															#line 1945 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Standalone<StringRef> && __sa,int loopDepth) 
	{
		sa = std::move(__sa);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<StackConcatActor*>(this)->actor_wait_state > 0) static_cast<StackConcatActor*>(this)->actor_wait_state = 0;
		static_cast<StackConcatActor*>(this)->ActorCallback< StackConcatActor, 0, Standalone<StringRef> >::remove();

	}
	void a_callback_fire(ActorCallback< StackConcatActor, 0, Standalone<StringRef> >*,Standalone<StringRef> const& value) 
	{
		fdb_probe_actor_enter("stackConcat", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StackConcatActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("stackConcat", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< StackConcatActor, 0, Standalone<StringRef> >*,Standalone<StringRef> && value) 
	{
		fdb_probe_actor_enter("stackConcat", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StackConcatActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("stackConcat", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< StackConcatActor, 0, Standalone<StringRef> >*,Error err) 
	{
		fdb_probe_actor_enter("stackConcat", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StackConcatActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("stackConcat", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(Standalone<StringRef> const& sb,int loopDepth) 
	{
															#line 288 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		tb = Tuple::unpack(sb);
															#line 290 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		ASSERT(ta.getType(0) == tb.getType(0));
															#line 291 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		stack->pushTuple(tb.getString(0).withPrefix(ta.getString(0)), ta.getType(0) == Tuple::ElementType::UTF8);
															#line 293 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (!static_cast<StackConcatActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~StackConcatActorState(); static_cast<StackConcatActor*>(this)->destroy(); return 0; }
															#line 2030 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		new (&static_cast<StackConcatActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~StackConcatActorState();
		static_cast<StackConcatActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Standalone<StringRef> && sb,int loopDepth) 
	{
															#line 288 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		tb = Tuple::unpack(sb);
															#line 290 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		ASSERT(ta.getType(0) == tb.getType(0));
															#line 291 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		stack->pushTuple(tb.getString(0).withPrefix(ta.getString(0)), ta.getType(0) == Tuple::ElementType::UTF8);
															#line 293 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (!static_cast<StackConcatActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~StackConcatActorState(); static_cast<StackConcatActor*>(this)->destroy(); return 0; }
															#line 2048 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		new (&static_cast<StackConcatActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~StackConcatActorState();
		static_cast<StackConcatActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Standalone<StringRef> const& sb,int loopDepth) 
	{
		loopDepth = a_body1cont3(sb, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Standalone<StringRef> && sb,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(sb), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<StackConcatActor*>(this)->actor_wait_state > 0) static_cast<StackConcatActor*>(this)->actor_wait_state = 0;
		static_cast<StackConcatActor*>(this)->ActorCallback< StackConcatActor, 1, Standalone<StringRef> >::remove();

	}
	void a_callback_fire(ActorCallback< StackConcatActor, 1, Standalone<StringRef> >*,Standalone<StringRef> const& value) 
	{
		fdb_probe_actor_enter("stackConcat", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StackConcatActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("stackConcat", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< StackConcatActor, 1, Standalone<StringRef> >*,Standalone<StringRef> && value) 
	{
		fdb_probe_actor_enter("stackConcat", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StackConcatActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("stackConcat", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< StackConcatActor, 1, Standalone<StringRef> >*,Error err) 
	{
		fdb_probe_actor_enter("stackConcat", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StackConcatActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("stackConcat", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 276 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	FlowTesterStack* stack;
															#line 282 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Standalone<StringRef> sa;
															#line 283 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Tuple ta;
															#line 288 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Tuple tb;
															#line 2139 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
};
// This generated class is to be used only via stackConcat()
															#line 276 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
class StackConcatActor final : public Actor<Void>, public ActorCallback< StackConcatActor, 0, Standalone<StringRef> >, public ActorCallback< StackConcatActor, 1, Standalone<StringRef> >, public FastAllocated<StackConcatActor>, public StackConcatActorState<StackConcatActor> {
															#line 2144 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
public:
	using FastAllocated<StackConcatActor>::operator new;
	using FastAllocated<StackConcatActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15910153477292436736UL, 5621153445599748864UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< StackConcatActor, 0, Standalone<StringRef> >;
friend struct ActorCallback< StackConcatActor, 1, Standalone<StringRef> >;
															#line 276 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	StackConcatActor(FlowTesterStack* const& stack) 
															#line 2162 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		 : Actor<Void>(),
		   StackConcatActorState<StackConcatActor>(stack),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("stackConcat", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3105878759550054400UL, 8428380095987763968UL);
		ActorExecutionContextHelper __helper(static_cast<StackConcatActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("stackConcat");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("stackConcat", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< StackConcatActor, 0, Standalone<StringRef> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< StackConcatActor, 1, Standalone<StringRef> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 276 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
[[nodiscard]] Future<Void> stackConcat( FlowTesterStack* const& stack ) {
															#line 276 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	return Future<Void>(new StackConcatActor(stack));
															#line 2196 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
}

#line 295 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"

															#line 2201 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
namespace {
// This generated class is to be used only via stackSwap()
															#line 296 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
template <class StackSwapActor>
															#line 296 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
class StackSwapActorState {
															#line 2208 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
public:
															#line 296 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	StackSwapActorState(FlowTesterStack* const& stack) 
															#line 296 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
															#line 296 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		 : stack(stack)
															#line 2215 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
	{
		fdb_probe_actor_create("stackSwap", reinterpret_cast<unsigned long>(this));

	}
	~StackSwapActorState() 
	{
		fdb_probe_actor_destroy("stackSwap", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 297 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (stack->data.size() < 3)
															#line 2230 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			{
															#line 298 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
				if (!static_cast<StackSwapActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~StackSwapActorState(); static_cast<StackSwapActor*>(this)->destroy(); return 0; }
															#line 2234 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
				new (&static_cast<StackSwapActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~StackSwapActorState();
				static_cast<StackSwapActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 300 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			StackItem pop = stack->data.back();
															#line 301 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			stack->data.pop_back();
															#line 303 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			StrictFuture<Standalone<StringRef>> __when_expr_0 = pop.value;
															#line 303 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (static_cast<StackSwapActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2248 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<StackSwapActor*>(this)->actor_wait_state = 1;
															#line 303 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< StackSwapActor, 0, Standalone<StringRef> >*>(static_cast<StackSwapActor*>(this)));
															#line 2253 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~StackSwapActorState();
		static_cast<StackSwapActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Standalone<StringRef> const& sv,int loopDepth) 
	{
															#line 304 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		int64_t idx = stack->data.size() - 1;
															#line 305 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		int64_t idx1 = idx - Tuple::unpack(sv).getInt(0);
															#line 306 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (idx1 < idx)
															#line 2280 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		{
															#line 308 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			StackItem item = stack->data[idx];
															#line 309 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			stack->data[idx] = stack->data[idx1];
															#line 310 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			stack->data[idx1] = item;
															#line 2288 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		}
															#line 312 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (!static_cast<StackSwapActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~StackSwapActorState(); static_cast<StackSwapActor*>(this)->destroy(); return 0; }
															#line 2292 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		new (&static_cast<StackSwapActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~StackSwapActorState();
		static_cast<StackSwapActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Standalone<StringRef> && sv,int loopDepth) 
	{
															#line 304 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		int64_t idx = stack->data.size() - 1;
															#line 305 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		int64_t idx1 = idx - Tuple::unpack(sv).getInt(0);
															#line 306 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (idx1 < idx)
															#line 2308 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		{
															#line 308 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			StackItem item = stack->data[idx];
															#line 309 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			stack->data[idx] = stack->data[idx1];
															#line 310 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			stack->data[idx1] = item;
															#line 2316 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		}
															#line 312 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (!static_cast<StackSwapActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~StackSwapActorState(); static_cast<StackSwapActor*>(this)->destroy(); return 0; }
															#line 2320 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		new (&static_cast<StackSwapActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~StackSwapActorState();
		static_cast<StackSwapActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Standalone<StringRef> const& sv,int loopDepth) 
	{
		loopDepth = a_body1cont1(sv, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Standalone<StringRef> && sv,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(sv), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<StackSwapActor*>(this)->actor_wait_state > 0) static_cast<StackSwapActor*>(this)->actor_wait_state = 0;
		static_cast<StackSwapActor*>(this)->ActorCallback< StackSwapActor, 0, Standalone<StringRef> >::remove();

	}
	void a_callback_fire(ActorCallback< StackSwapActor, 0, Standalone<StringRef> >*,Standalone<StringRef> const& value) 
	{
		fdb_probe_actor_enter("stackSwap", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StackSwapActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("stackSwap", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< StackSwapActor, 0, Standalone<StringRef> >*,Standalone<StringRef> && value) 
	{
		fdb_probe_actor_enter("stackSwap", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StackSwapActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("stackSwap", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< StackSwapActor, 0, Standalone<StringRef> >*,Error err) 
	{
		fdb_probe_actor_enter("stackSwap", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StackSwapActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("stackSwap", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 296 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	FlowTesterStack* stack;
															#line 2405 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
};
// This generated class is to be used only via stackSwap()
															#line 296 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
class StackSwapActor final : public Actor<Void>, public ActorCallback< StackSwapActor, 0, Standalone<StringRef> >, public FastAllocated<StackSwapActor>, public StackSwapActorState<StackSwapActor> {
															#line 2410 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
public:
	using FastAllocated<StackSwapActor>::operator new;
	using FastAllocated<StackSwapActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13368151383255564288UL, 10340195970231537152UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< StackSwapActor, 0, Standalone<StringRef> >;
															#line 296 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	StackSwapActor(FlowTesterStack* const& stack) 
															#line 2427 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		 : Actor<Void>(),
		   StackSwapActorState<StackSwapActor>(stack),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("stackSwap", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(71592883347869696UL, 2715053316354241024UL);
		ActorExecutionContextHelper __helper(static_cast<StackSwapActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("stackSwap");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("stackSwap", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< StackSwapActor, 0, Standalone<StringRef> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 296 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
[[nodiscard]] Future<Void> stackSwap( FlowTesterStack* const& stack ) {
															#line 296 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	return Future<Void>(new StackSwapActor(stack));
															#line 2460 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
}

#line 314 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"

															#line 2465 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
namespace {
// This generated class is to be used only via printFlowTesterStack()
															#line 315 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
template <class PrintFlowTesterStackActor>
															#line 315 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
class PrintFlowTesterStackActorState {
															#line 2472 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
public:
															#line 315 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	PrintFlowTesterStackActorState(FlowTesterStack* const& stack) 
															#line 315 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
															#line 315 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		 : stack(stack),
															#line 317 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		   idx()
															#line 2481 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
	{
		fdb_probe_actor_create("printFlowTesterStack", reinterpret_cast<unsigned long>(this));

	}
	~PrintFlowTesterStackActorState() 
	{
		fdb_probe_actor_destroy("printFlowTesterStack", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 318 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			idx = stack->data.size() - 1;
															#line 2496 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PrintFlowTesterStackActorState();
		static_cast<PrintFlowTesterStackActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 323 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (!static_cast<PrintFlowTesterStackActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PrintFlowTesterStackActorState(); static_cast<PrintFlowTesterStackActor*>(this)->destroy(); return 0; }
															#line 2519 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		new (&static_cast<PrintFlowTesterStackActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PrintFlowTesterStackActorState();
		static_cast<PrintFlowTesterStackActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 318 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (!(idx >= 0))
															#line 2538 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 319 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		StrictFuture<Standalone<StringRef>> __when_expr_0 = stack->data[idx].value;
															#line 319 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (static_cast<PrintFlowTesterStackActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2546 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<PrintFlowTesterStackActor*>(this)->actor_wait_state = 1;
															#line 319 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PrintFlowTesterStackActor, 0, Standalone<StringRef> >*>(static_cast<PrintFlowTesterStackActor*>(this)));
															#line 2551 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Standalone<StringRef> const& value,int loopDepth) 
	{
															#line 318 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		--idx;
															#line 2573 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Standalone<StringRef> && value,int loopDepth) 
	{
															#line 318 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		--idx;
															#line 2582 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Standalone<StringRef> const& value,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(value, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Standalone<StringRef> && value,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(value), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PrintFlowTesterStackActor*>(this)->actor_wait_state > 0) static_cast<PrintFlowTesterStackActor*>(this)->actor_wait_state = 0;
		static_cast<PrintFlowTesterStackActor*>(this)->ActorCallback< PrintFlowTesterStackActor, 0, Standalone<StringRef> >::remove();

	}
	void a_callback_fire(ActorCallback< PrintFlowTesterStackActor, 0, Standalone<StringRef> >*,Standalone<StringRef> const& value) 
	{
		fdb_probe_actor_enter("printFlowTesterStack", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PrintFlowTesterStackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printFlowTesterStack", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PrintFlowTesterStackActor, 0, Standalone<StringRef> >*,Standalone<StringRef> && value) 
	{
		fdb_probe_actor_enter("printFlowTesterStack", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PrintFlowTesterStackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printFlowTesterStack", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PrintFlowTesterStackActor, 0, Standalone<StringRef> >*,Error err) 
	{
		fdb_probe_actor_enter("printFlowTesterStack", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PrintFlowTesterStackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printFlowTesterStack", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 315 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	FlowTesterStack* stack;
															#line 317 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	int idx;
															#line 2666 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
};
// This generated class is to be used only via printFlowTesterStack()
															#line 315 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
class PrintFlowTesterStackActor final : public Actor<Void>, public ActorCallback< PrintFlowTesterStackActor, 0, Standalone<StringRef> >, public FastAllocated<PrintFlowTesterStackActor>, public PrintFlowTesterStackActorState<PrintFlowTesterStackActor> {
															#line 2671 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
public:
	using FastAllocated<PrintFlowTesterStackActor>::operator new;
	using FastAllocated<PrintFlowTesterStackActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2015648238655041280UL, 5525734793495736832UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PrintFlowTesterStackActor, 0, Standalone<StringRef> >;
															#line 315 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	PrintFlowTesterStackActor(FlowTesterStack* const& stack) 
															#line 2688 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		 : Actor<Void>(),
		   PrintFlowTesterStackActorState<PrintFlowTesterStackActor>(stack),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("printFlowTesterStack", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4996504667307107584UL, 4985815071369647872UL);
		ActorExecutionContextHelper __helper(static_cast<PrintFlowTesterStackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("printFlowTesterStack");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("printFlowTesterStack", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PrintFlowTesterStackActor, 0, Standalone<StringRef> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 315 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
[[nodiscard]] Future<Void> printFlowTesterStack( FlowTesterStack* const& stack ) {
															#line 315 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	return Future<Void>(new PrintFlowTesterStackActor(stack));
															#line 2721 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
}

#line 325 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"

//
// Data Operations
//

struct PushFunc : InstructionFunc {
	static const char* name;

	static Future<Void> call(Reference<FlowTesterData> const& data, Reference<InstructionData> const& instruction) {
		Tuple t = Tuple::unpack(instruction->instruction);
		Standalone<StringRef> param = t.subTuple(1).pack();
		data->stack.push(param);
		return Void();
	}
};
const char* PushFunc::name = "PUSH";
REGISTER_INSTRUCTION_FUNC(PushFunc);

struct DupFunc : InstructionFunc {
	static const char* name;

	static Future<Void> call(Reference<FlowTesterData> const& data, Reference<InstructionData> const& instruction) {
		data->stack.dup();
		return Void();
	}
};
const char* DupFunc::name = "DUP";
REGISTER_INSTRUCTION_FUNC(DupFunc);

struct EmptyStackFunc : InstructionFunc {
	static const char* name;

	static Future<Void> call(Reference<FlowTesterData> const& data, Reference<InstructionData> const& instruction) {
		// wait(printFlowTesterStack(&(data->stack)));
		// wait(debugPrintRange(instruction->tr, "\x01test_results", ""));
		data->stack.clear();
		return Void();
	}
};
const char* EmptyStackFunc::name = "EMPTY_STACK";
REGISTER_INSTRUCTION_FUNC(EmptyStackFunc);

struct SwapFunc : InstructionFunc {
	static const char* name;

																#line 2770 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
// This generated class is to be used only via call()
															#line 370 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
template <class CallActor>
															#line 370 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
class CallActorState {
															#line 2776 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
public:
															#line 370 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	CallActorState(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 370 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
															#line 370 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		 : data(data),
															#line 370 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		   instruction(instruction)
															#line 2785 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
	{
		fdb_probe_actor_create("call", reinterpret_cast<unsigned long>(this));

	}
	~CallActorState() 
	{
		fdb_probe_actor_destroy("call", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 371 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			StrictFuture<Void> __when_expr_0 = stackSwap(&(data->stack));
															#line 371 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (static_cast<CallActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2802 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CallActor*>(this)->actor_wait_state = 1;
															#line 371 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CallActor, 0, Void >*>(static_cast<CallActor*>(this)));
															#line 2807 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CallActorState();
		static_cast<CallActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 372 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (!static_cast<CallActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActorState(); static_cast<CallActor*>(this)->destroy(); return 0; }
															#line 2830 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		new (&static_cast<CallActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CallActorState();
		static_cast<CallActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 372 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (!static_cast<CallActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActorState(); static_cast<CallActor*>(this)->destroy(); return 0; }
															#line 2842 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		new (&static_cast<CallActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CallActorState();
		static_cast<CallActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CallActor*>(this)->actor_wait_state > 0) static_cast<CallActor*>(this)->actor_wait_state = 0;
		static_cast<CallActor*>(this)->ActorCallback< CallActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CallActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CallActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 370 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Reference<FlowTesterData> data;
															#line 370 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Reference<InstructionData> instruction;
															#line 2929 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
};
// This generated class is to be used only via call()
															#line 370 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
class CallActor final : public Actor<Void>, public ActorCallback< CallActor, 0, Void >, public FastAllocated<CallActor>, public CallActorState<CallActor> {
															#line 2934 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
public:
	using FastAllocated<CallActor>::operator new;
	using FastAllocated<CallActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9317237842190798848UL, 4308047855804869376UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CallActor, 0, Void >;
															#line 370 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	CallActor(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 2951 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		 : Actor<Void>(),
		   CallActorState<CallActor>(data, instruction),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7627573813278715136UL, 12862468809175655680UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("call");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CallActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 370 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
[[nodiscard]] static Future<Void> call( Reference<FlowTesterData> const& data, Reference<InstructionData> const& instruction ) {
															#line 370 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	return Future<Void>(new CallActor(data, instruction));
															#line 2983 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
}

#line 374 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
};
const char* SwapFunc::name = "SWAP";
REGISTER_INSTRUCTION_FUNC(SwapFunc);

struct PopFunc : InstructionFunc {
	static const char* name;

																#line 2994 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
// This generated class is to be used only via call()
															#line 381 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
template <class CallActor1>
															#line 381 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
class CallActor1State {
															#line 3000 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
public:
															#line 381 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	CallActor1State(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 381 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
															#line 381 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		 : data(data),
															#line 381 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		   instruction(instruction),
															#line 382 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		   items(data->stack.pop())
															#line 3011 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
	{
		fdb_probe_actor_create("call", reinterpret_cast<unsigned long>(this));

	}
	~CallActor1State() 
	{
		fdb_probe_actor_destroy("call", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 383 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			RangeForbody1Iterator0 = std::begin(items);
															#line 3026 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CallActor1State();
		static_cast<CallActor1*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 386 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (!static_cast<CallActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor1State(); static_cast<CallActor1*>(this)->destroy(); return 0; }
															#line 3049 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		new (&static_cast<CallActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~CallActor1State();
		static_cast<CallActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 383 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (!(RangeForbody1Iterator0 != std::end(items)))
															#line 3068 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 383 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		StackItem item = *RangeForbody1Iterator0;
															#line 3074 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		{
															#line 384 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			StrictFuture<Void> __when_expr_0 = success(item.value);
															#line 384 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (static_cast<CallActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3080 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CallActor1*>(this)->actor_wait_state = 1;
															#line 384 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CallActor1, 0, Void >*>(static_cast<CallActor1*>(this)));
															#line 3085 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 383 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		++RangeForbody1Iterator0;
															#line 3108 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CallActor1*>(this)->actor_wait_state > 0) static_cast<CallActor1*>(this)->actor_wait_state = 0;
		static_cast<CallActor1*>(this)->ActorCallback< CallActor1, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor1, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CallActor1, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CallActor1, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 381 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Reference<FlowTesterData> data;
															#line 381 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Reference<InstructionData> instruction;
															#line 382 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	std::vector<StackItem> items;
															#line 383 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	decltype(std::begin(std::declval<std::vector<StackItem>>())) RangeForbody1Iterator0;
															#line 3208 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
};
// This generated class is to be used only via call()
															#line 381 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
class CallActor1 final : public Actor<Void>, public ActorCallback< CallActor1, 0, Void >, public FastAllocated<CallActor1>, public CallActor1State<CallActor1> {
															#line 3213 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
public:
	using FastAllocated<CallActor1>::operator new;
	using FastAllocated<CallActor1>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9317237842190798848UL, 4308047855804869376UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CallActor1, 0, Void >;
															#line 381 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	CallActor1(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 3230 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		 : Actor<Void>(),
		   CallActor1State<CallActor1>(data, instruction),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11408034284726002688UL, 16335413270408340480UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("call");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CallActor1, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 381 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
[[nodiscard]] static Future<Void> call( Reference<FlowTesterData> const& data, Reference<InstructionData> const& instruction ) {
															#line 381 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	return Future<Void>(new CallActor1(data, instruction));
															#line 3262 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
}

#line 388 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
};
const char* PopFunc::name = "POP";
REGISTER_INSTRUCTION_FUNC(PopFunc);

struct SubFunc : InstructionFunc {
	static const char* name;

																#line 3273 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
// This generated class is to be used only via call()
															#line 395 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
template <class CallActor2>
															#line 395 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
class CallActor2State {
															#line 3279 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
public:
															#line 395 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	CallActor2State(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 395 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
															#line 395 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		 : data(data),
															#line 395 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		   instruction(instruction)
															#line 3288 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
	{
		fdb_probe_actor_create("call", reinterpret_cast<unsigned long>(this));

	}
	~CallActor2State() 
	{
		fdb_probe_actor_destroy("call", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 396 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			StrictFuture<Void> __when_expr_0 = stackSub(&(data->stack));
															#line 396 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (static_cast<CallActor2*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3305 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CallActor2*>(this)->actor_wait_state = 1;
															#line 396 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CallActor2, 0, Void >*>(static_cast<CallActor2*>(this)));
															#line 3310 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CallActor2State();
		static_cast<CallActor2*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 397 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (!static_cast<CallActor2*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor2State(); static_cast<CallActor2*>(this)->destroy(); return 0; }
															#line 3333 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		new (&static_cast<CallActor2*>(this)->SAV< Void >::value()) Void(Void());
		this->~CallActor2State();
		static_cast<CallActor2*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 397 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (!static_cast<CallActor2*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor2State(); static_cast<CallActor2*>(this)->destroy(); return 0; }
															#line 3345 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		new (&static_cast<CallActor2*>(this)->SAV< Void >::value()) Void(Void());
		this->~CallActor2State();
		static_cast<CallActor2*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CallActor2*>(this)->actor_wait_state > 0) static_cast<CallActor2*>(this)->actor_wait_state = 0;
		static_cast<CallActor2*>(this)->ActorCallback< CallActor2, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor2, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor2*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CallActor2, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor2*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CallActor2, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor2*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 395 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Reference<FlowTesterData> data;
															#line 395 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Reference<InstructionData> instruction;
															#line 3432 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
};
// This generated class is to be used only via call()
															#line 395 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
class CallActor2 final : public Actor<Void>, public ActorCallback< CallActor2, 0, Void >, public FastAllocated<CallActor2>, public CallActor2State<CallActor2> {
															#line 3437 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
public:
	using FastAllocated<CallActor2>::operator new;
	using FastAllocated<CallActor2>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9317237842190798848UL, 4308047855804869376UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CallActor2, 0, Void >;
															#line 395 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	CallActor2(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 3454 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		 : Actor<Void>(),
		   CallActor2State<CallActor2>(data, instruction),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3817665306019306496UL, 7653278230371291904UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor2*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("call");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CallActor2, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 395 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
[[nodiscard]] static Future<Void> call( Reference<FlowTesterData> const& data, Reference<InstructionData> const& instruction ) {
															#line 395 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	return Future<Void>(new CallActor2(data, instruction));
															#line 3486 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
}

#line 399 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
};
const char* SubFunc::name = "SUB";
REGISTER_INSTRUCTION_FUNC(SubFunc);

struct ConcatFunc : InstructionFunc {
	static const char* name;

																#line 3497 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
// This generated class is to be used only via call()
															#line 406 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
template <class CallActor3>
															#line 406 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
class CallActor3State {
															#line 3503 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
public:
															#line 406 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	CallActor3State(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 406 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
															#line 406 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		 : data(data),
															#line 406 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		   instruction(instruction)
															#line 3512 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
	{
		fdb_probe_actor_create("call", reinterpret_cast<unsigned long>(this));

	}
	~CallActor3State() 
	{
		fdb_probe_actor_destroy("call", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 407 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			StrictFuture<Void> __when_expr_0 = stackConcat(&(data->stack));
															#line 407 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (static_cast<CallActor3*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3529 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CallActor3*>(this)->actor_wait_state = 1;
															#line 407 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CallActor3, 0, Void >*>(static_cast<CallActor3*>(this)));
															#line 3534 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CallActor3State();
		static_cast<CallActor3*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 408 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (!static_cast<CallActor3*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor3State(); static_cast<CallActor3*>(this)->destroy(); return 0; }
															#line 3557 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		new (&static_cast<CallActor3*>(this)->SAV< Void >::value()) Void(Void());
		this->~CallActor3State();
		static_cast<CallActor3*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 408 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (!static_cast<CallActor3*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor3State(); static_cast<CallActor3*>(this)->destroy(); return 0; }
															#line 3569 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		new (&static_cast<CallActor3*>(this)->SAV< Void >::value()) Void(Void());
		this->~CallActor3State();
		static_cast<CallActor3*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CallActor3*>(this)->actor_wait_state > 0) static_cast<CallActor3*>(this)->actor_wait_state = 0;
		static_cast<CallActor3*>(this)->ActorCallback< CallActor3, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor3, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor3*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CallActor3, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor3*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CallActor3, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor3*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 406 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Reference<FlowTesterData> data;
															#line 406 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Reference<InstructionData> instruction;
															#line 3656 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
};
// This generated class is to be used only via call()
															#line 406 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
class CallActor3 final : public Actor<Void>, public ActorCallback< CallActor3, 0, Void >, public FastAllocated<CallActor3>, public CallActor3State<CallActor3> {
															#line 3661 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
public:
	using FastAllocated<CallActor3>::operator new;
	using FastAllocated<CallActor3>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9317237842190798848UL, 4308047855804869376UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CallActor3, 0, Void >;
															#line 406 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	CallActor3(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 3678 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		 : Actor<Void>(),
		   CallActor3State<CallActor3>(data, instruction),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14974279663439659008UL, 13489961173622453504UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor3*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("call");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CallActor3, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 406 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
[[nodiscard]] static Future<Void> call( Reference<FlowTesterData> const& data, Reference<InstructionData> const& instruction ) {
															#line 406 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	return Future<Void>(new CallActor3(data, instruction));
															#line 3710 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
}

#line 410 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
};
const char* ConcatFunc::name = "CONCAT";
REGISTER_INSTRUCTION_FUNC(ConcatFunc);

struct LogStackFunc : InstructionFunc {
	static const char* name;

																#line 3721 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
// This generated class is to be used only via logStack()
															#line 417 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
template <class LogStackActor>
															#line 417 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
class LogStackActorState {
															#line 3727 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
public:
															#line 417 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	LogStackActorState(Reference<FlowTesterData> const& data,std::map<int, StackItem> const& entries,Standalone<StringRef> const& prefix) 
															#line 417 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
															#line 417 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		 : data(data),
															#line 417 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		   entries(entries),
															#line 417 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		   prefix(prefix)
															#line 3738 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
	{
		fdb_probe_actor_create("logStack", reinterpret_cast<unsigned long>(this));

	}
	~LogStackActorState() 
	{
		fdb_probe_actor_destroy("logStack", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 420 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			;
															#line 3753 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~LogStackActorState();
		static_cast<LogStackActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 421 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		tr = data->db->createTransaction();
															#line 3783 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		try {
															#line 423 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			RangeForbody1loopBody1Iterator0 = std::begin(entries);
															#line 3787 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			loopDepth = a_body1loopBody1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 435 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr->onError(e);
															#line 435 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (static_cast<LogStackActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3811 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<LogStackActor*>(this)->actor_wait_state = 3;
															#line 435 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< LogStackActor, 2, Void >*>(static_cast<LogStackActor*>(this)));
															#line 3816 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 432 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr->commit();
															#line 432 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (static_cast<LogStackActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3833 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<LogStackActor*>(this)->actor_wait_state = 2;
															#line 432 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< LogStackActor, 1, Void >*>(static_cast<LogStackActor*>(this)));
															#line 3838 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
															#line 423 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (!(RangeForbody1loopBody1Iterator0 != std::end(entries)))
															#line 3854 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		{
			return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 423 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		auto it = *RangeForbody1loopBody1Iterator0;
															#line 3860 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		{
															#line 424 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			Tuple tk;
															#line 425 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			tk.append(it.first);
															#line 426 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			tk.append((int64_t)it.second.index);
															#line 427 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			pk = tk.pack().withPrefix(prefix);
															#line 428 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			StrictFuture<Standalone<StringRef>> __when_expr_0 = it.second.value;
															#line 428 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (static_cast<LogStackActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3874 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<LogStackActor*>(this)->actor_wait_state = 1;
															#line 428 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< LogStackActor, 0, Standalone<StringRef> >*>(static_cast<LogStackActor*>(this)));
															#line 3879 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
															#line 423 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		++RangeForbody1loopBody1Iterator0;
															#line 3902 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3(Standalone<StringRef> const& pv,int loopDepth) 
	{
															#line 429 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		tr->set(pk, pv.substr(0, std::min(pv.size(), 40000)));
															#line 3911 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3(Standalone<StringRef> && pv,int loopDepth) 
	{
															#line 429 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		tr->set(pk, pv.substr(0, std::min(pv.size(), 40000)));
															#line 3920 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Standalone<StringRef> const& pv,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont3(pv, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Standalone<StringRef> && pv,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont3(std::move(pv), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<LogStackActor*>(this)->actor_wait_state > 0) static_cast<LogStackActor*>(this)->actor_wait_state = 0;
		static_cast<LogStackActor*>(this)->ActorCallback< LogStackActor, 0, Standalone<StringRef> >::remove();

	}
	void a_callback_fire(ActorCallback< LogStackActor, 0, Standalone<StringRef> >*,Standalone<StringRef> const& value) 
	{
		fdb_probe_actor_enter("logStack", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LogStackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("logStack", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< LogStackActor, 0, Standalone<StringRef> >*,Standalone<StringRef> && value) 
	{
		fdb_probe_actor_enter("logStack", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LogStackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("logStack", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< LogStackActor, 0, Standalone<StringRef> >*,Error err) 
	{
		fdb_probe_actor_enter("logStack", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LogStackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("logStack", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 433 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (!static_cast<LogStackActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~LogStackActorState(); static_cast<LogStackActor*>(this)->destroy(); return 0; }
															#line 4004 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		new (&static_cast<LogStackActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~LogStackActorState();
		static_cast<LogStackActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 433 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (!static_cast<LogStackActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~LogStackActorState(); static_cast<LogStackActor*>(this)->destroy(); return 0; }
															#line 4016 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		new (&static_cast<LogStackActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~LogStackActorState();
		static_cast<LogStackActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<LogStackActor*>(this)->actor_wait_state > 0) static_cast<LogStackActor*>(this)->actor_wait_state = 0;
		static_cast<LogStackActor*>(this)->ActorCallback< LogStackActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LogStackActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("logStack", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LogStackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("logStack", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< LogStackActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("logStack", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LogStackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("logStack", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< LogStackActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("logStack", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LogStackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("logStack", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<LogStackActor*>(this)->actor_wait_state > 0) static_cast<LogStackActor*>(this)->actor_wait_state = 0;
		static_cast<LogStackActor*>(this)->ActorCallback< LogStackActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LogStackActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("logStack", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LogStackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("logStack", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< LogStackActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("logStack", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LogStackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("logStack", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< LogStackActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("logStack", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LogStackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("logStack", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 417 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Reference<FlowTesterData> data;
															#line 417 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	std::map<int, StackItem> entries;
															#line 417 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Standalone<StringRef> prefix;
															#line 421 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Reference<Transaction> tr;
															#line 423 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	decltype(std::begin(std::declval<std::map<int, StackItem>>())) RangeForbody1loopBody1Iterator0;
															#line 427 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Standalone<StringRef> pk;
															#line 4198 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
};
// This generated class is to be used only via logStack()
															#line 417 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
class LogStackActor final : public Actor<Void>, public ActorCallback< LogStackActor, 0, Standalone<StringRef> >, public ActorCallback< LogStackActor, 1, Void >, public ActorCallback< LogStackActor, 2, Void >, public FastAllocated<LogStackActor>, public LogStackActorState<LogStackActor> {
															#line 4203 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
public:
	using FastAllocated<LogStackActor>::operator new;
	using FastAllocated<LogStackActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6865444047686332160UL, 11224539340701265664UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< LogStackActor, 0, Standalone<StringRef> >;
friend struct ActorCallback< LogStackActor, 1, Void >;
friend struct ActorCallback< LogStackActor, 2, Void >;
															#line 417 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	LogStackActor(Reference<FlowTesterData> const& data,std::map<int, StackItem> const& entries,Standalone<StringRef> const& prefix) 
															#line 4222 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		 : Actor<Void>(),
		   LogStackActorState<LogStackActor>(data, entries, prefix),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("logStack", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17321845345858461952UL, 11506699616519958272UL);
		ActorExecutionContextHelper __helper(static_cast<LogStackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("logStack");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("logStack", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< LogStackActor, 0, Standalone<StringRef> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< LogStackActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< LogStackActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 417 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
[[nodiscard]] static Future<Void> logStack( Reference<FlowTesterData> const& data, std::map<int, StackItem> const& entries, Standalone<StringRef> const& prefix ) {
															#line 417 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	return Future<Void>(new LogStackActor(data, entries, prefix));
															#line 4256 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
}

#line 439 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"

																#line 4261 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
// This generated class is to be used only via call()
															#line 440 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
template <class CallActor4>
															#line 440 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
class CallActor4State {
															#line 4267 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
public:
															#line 440 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	CallActor4State(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 440 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
															#line 440 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		 : data(data),
															#line 440 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		   instruction(instruction),
															#line 441 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		   items(data->stack.pop())
															#line 4278 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
	{
		fdb_probe_actor_create("call", reinterpret_cast<unsigned long>(this));

	}
	~CallActor4State() 
	{
		fdb_probe_actor_destroy("call", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 442 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (items.empty())
															#line 4293 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			{
															#line 443 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
				if (!static_cast<CallActor4*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor4State(); static_cast<CallActor4*>(this)->destroy(); return 0; }
															#line 4297 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
				new (&static_cast<CallActor4*>(this)->SAV< Void >::value()) Void(Void());
				this->~CallActor4State();
				static_cast<CallActor4*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 445 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			StrictFuture<Standalone<StringRef>> __when_expr_0 = items[0].value;
															#line 445 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (static_cast<CallActor4*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4307 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CallActor4*>(this)->actor_wait_state = 1;
															#line 445 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CallActor4, 0, Standalone<StringRef> >*>(static_cast<CallActor4*>(this)));
															#line 4312 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CallActor4State();
		static_cast<CallActor4*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Standalone<StringRef> const& s1,int loopDepth) 
	{
															#line 446 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		prefix = Tuple::unpack(s1).getString(0);
															#line 448 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		entries = std::map<int, StackItem>();
															#line 449 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		;
															#line 4339 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Standalone<StringRef> && s1,int loopDepth) 
	{
															#line 446 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		prefix = Tuple::unpack(s1).getString(0);
															#line 448 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		entries = std::map<int, StackItem>();
															#line 449 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		;
															#line 4352 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Standalone<StringRef> const& s1,int loopDepth) 
	{
		loopDepth = a_body1cont1(s1, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Standalone<StringRef> && s1,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(s1), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CallActor4*>(this)->actor_wait_state > 0) static_cast<CallActor4*>(this)->actor_wait_state = 0;
		static_cast<CallActor4*>(this)->ActorCallback< CallActor4, 0, Standalone<StringRef> >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor4, 0, Standalone<StringRef> >*,Standalone<StringRef> const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor4*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CallActor4, 0, Standalone<StringRef> >*,Standalone<StringRef> && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor4*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CallActor4, 0, Standalone<StringRef> >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor4*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 458 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		StrictFuture<Void> __when_expr_2 = logStack(data, entries, prefix);
															#line 458 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (static_cast<CallActor4*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4438 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<CallActor4*>(this)->actor_wait_state = 3;
															#line 458 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CallActor4, 2, Void >*>(static_cast<CallActor4*>(this)));
															#line 4443 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 449 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (!(data->stack.data.size() > 0))
															#line 4459 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 450 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		it = data->stack.pop();
															#line 451 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		ASSERT(it.size() == 1);
															#line 452 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		entries[data->stack.data.size()] = it.front();
															#line 453 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (entries.size() == 100)
															#line 4471 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		{
															#line 454 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			StrictFuture<Void> __when_expr_1 = logStack(data, entries, prefix);
															#line 454 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (static_cast<CallActor4*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4477 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<CallActor4*>(this)->actor_wait_state = 2;
															#line 454 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CallActor4, 1, Void >*>(static_cast<CallActor4*>(this)));
															#line 4482 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont1loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 455 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		entries.clear();
															#line 4515 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 455 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		entries.clear();
															#line 4524 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CallActor4*>(this)->actor_wait_state > 0) static_cast<CallActor4*>(this)->actor_wait_state = 0;
		static_cast<CallActor4*>(this)->ActorCallback< CallActor4, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor4, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor4*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CallActor4, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor4*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CallActor4, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor4*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 460 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (!static_cast<CallActor4*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor4State(); static_cast<CallActor4*>(this)->destroy(); return 0; }
															#line 4608 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		new (&static_cast<CallActor4*>(this)->SAV< Void >::value()) Void(Void());
		this->~CallActor4State();
		static_cast<CallActor4*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 460 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (!static_cast<CallActor4*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor4State(); static_cast<CallActor4*>(this)->destroy(); return 0; }
															#line 4620 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		new (&static_cast<CallActor4*>(this)->SAV< Void >::value()) Void(Void());
		this->~CallActor4State();
		static_cast<CallActor4*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CallActor4*>(this)->actor_wait_state > 0) static_cast<CallActor4*>(this)->actor_wait_state = 0;
		static_cast<CallActor4*>(this)->ActorCallback< CallActor4, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor4, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor4*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CallActor4, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor4*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CallActor4, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor4*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 440 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Reference<FlowTesterData> data;
															#line 440 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Reference<InstructionData> instruction;
															#line 441 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	std::vector<StackItem> items;
															#line 446 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Standalone<StringRef> prefix;
															#line 448 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	std::map<int, StackItem> entries;
															#line 450 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	std::vector<StackItem> it;
															#line 4715 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
};
// This generated class is to be used only via call()
															#line 440 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
class CallActor4 final : public Actor<Void>, public ActorCallback< CallActor4, 0, Standalone<StringRef> >, public ActorCallback< CallActor4, 1, Void >, public ActorCallback< CallActor4, 2, Void >, public FastAllocated<CallActor4>, public CallActor4State<CallActor4> {
															#line 4720 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
public:
	using FastAllocated<CallActor4>::operator new;
	using FastAllocated<CallActor4>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9317237842190798848UL, 4308047855804869376UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CallActor4, 0, Standalone<StringRef> >;
friend struct ActorCallback< CallActor4, 1, Void >;
friend struct ActorCallback< CallActor4, 2, Void >;
															#line 440 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	CallActor4(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 4739 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		 : Actor<Void>(),
		   CallActor4State<CallActor4>(data, instruction),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1885067825512278016UL, 1963067322261558784UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor4*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("call");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CallActor4, 0, Standalone<StringRef> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CallActor4, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CallActor4, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 440 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
[[nodiscard]] static Future<Void> call( Reference<FlowTesterData> const& data, Reference<InstructionData> const& instruction ) {
															#line 440 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	return Future<Void>(new CallActor4(data, instruction));
															#line 4773 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
}

#line 462 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
};
const char* LogStackFunc::name = "LOG_STACK";
REGISTER_INSTRUCTION_FUNC(LogStackFunc);

//
// FoundationDB Operations
//
															#line 4784 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
namespace {
// This generated class is to be used only via waitForVoid()
															#line 469 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
template <class WaitForVoidActor>
															#line 469 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
class WaitForVoidActorState {
															#line 4791 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
public:
															#line 469 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	WaitForVoidActorState(Future<Void> const& f) 
															#line 469 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
															#line 469 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		 : f(f)
															#line 4798 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
	{
		fdb_probe_actor_create("waitForVoid", reinterpret_cast<unsigned long>(this));

	}
	~WaitForVoidActorState() 
	{
		fdb_probe_actor_destroy("waitForVoid", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 471 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
				StrictFuture<Void> __when_expr_0 = f;
															#line 471 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
				if (static_cast<WaitForVoidActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 4816 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<WaitForVoidActor*>(this)->actor_wait_state = 1;
															#line 471 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WaitForVoidActor, 0, Void >*>(static_cast<WaitForVoidActor*>(this)));
															#line 4821 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WaitForVoidActorState();
		static_cast<WaitForVoidActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 477 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			Tuple t;
															#line 478 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			t.append("ERROR"_sr);
															#line 479 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			t.append(format("%d", e.code()));
															#line 481 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			Tuple ret;
															#line 482 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			ret.append(t.pack());
															#line 483 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (!static_cast<WaitForVoidActor*>(this)->SAV<Standalone<StringRef>>::futures) { (void)(ret.pack()); this->~WaitForVoidActorState(); static_cast<WaitForVoidActor*>(this)->destroy(); return 0; }
															#line 4861 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			new (&static_cast<WaitForVoidActor*>(this)->SAV< Standalone<StringRef> >::value()) Standalone<StringRef>(ret.pack());
			this->~WaitForVoidActorState();
			static_cast<WaitForVoidActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 472 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		Tuple t;
															#line 473 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		t.append("RESULT_NOT_PRESENT"_sr);
															#line 474 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (!static_cast<WaitForVoidActor*>(this)->SAV<Standalone<StringRef>>::futures) { (void)(t.pack()); this->~WaitForVoidActorState(); static_cast<WaitForVoidActor*>(this)->destroy(); return 0; }
															#line 4883 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		new (&static_cast<WaitForVoidActor*>(this)->SAV< Standalone<StringRef> >::value()) Standalone<StringRef>(t.pack());
		this->~WaitForVoidActorState();
		static_cast<WaitForVoidActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 472 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		Tuple t;
															#line 473 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		t.append("RESULT_NOT_PRESENT"_sr);
															#line 474 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (!static_cast<WaitForVoidActor*>(this)->SAV<Standalone<StringRef>>::futures) { (void)(t.pack()); this->~WaitForVoidActorState(); static_cast<WaitForVoidActor*>(this)->destroy(); return 0; }
															#line 4899 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		new (&static_cast<WaitForVoidActor*>(this)->SAV< Standalone<StringRef> >::value()) Standalone<StringRef>(t.pack());
		this->~WaitForVoidActorState();
		static_cast<WaitForVoidActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WaitForVoidActor*>(this)->actor_wait_state > 0) static_cast<WaitForVoidActor*>(this)->actor_wait_state = 0;
		static_cast<WaitForVoidActor*>(this)->ActorCallback< WaitForVoidActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitForVoidActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitForVoid", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForVoidActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForVoid", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WaitForVoidActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitForVoid", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForVoidActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForVoid", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WaitForVoidActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitForVoid", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForVoidActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForVoid", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 469 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Future<Void> f;
															#line 4984 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
};
// This generated class is to be used only via waitForVoid()
															#line 469 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
class WaitForVoidActor final : public Actor<Standalone<StringRef>>, public ActorCallback< WaitForVoidActor, 0, Void >, public FastAllocated<WaitForVoidActor>, public WaitForVoidActorState<WaitForVoidActor> {
															#line 4989 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
public:
	using FastAllocated<WaitForVoidActor>::operator new;
	using FastAllocated<WaitForVoidActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5992626861198040576UL, 4359769315764069120UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Standalone<StringRef>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WaitForVoidActor, 0, Void >;
															#line 469 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	WaitForVoidActor(Future<Void> const& f) 
															#line 5006 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		 : Actor<Standalone<StringRef>>(),
		   WaitForVoidActorState<WaitForVoidActor>(f),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("waitForVoid", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17518363078881837312UL, 16805068020850269184UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForVoidActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("waitForVoid");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("waitForVoid", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WaitForVoidActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 469 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
[[nodiscard]] Future<Standalone<StringRef>> waitForVoid( Future<Void> const& f ) {
															#line 469 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	return Future<Standalone<StringRef>>(new WaitForVoidActor(f));
															#line 5039 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
}

#line 486 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"

															#line 5044 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
namespace {
// This generated class is to be used only via waitForValue()
															#line 487 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
template <class WaitForValueActor>
															#line 487 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
class WaitForValueActorState {
															#line 5051 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
public:
															#line 487 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	WaitForValueActorState(Future<FDBStandalone<KeyRef>> const& f) 
															#line 487 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
															#line 487 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		 : f(f)
															#line 5058 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
	{
		fdb_probe_actor_create("waitForValue", reinterpret_cast<unsigned long>(this));

	}
	~WaitForValueActorState() 
	{
		fdb_probe_actor_destroy("waitForValue", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 489 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
				StrictFuture<FDBStandalone<KeyRef>> __when_expr_0 = f;
															#line 489 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
				if (static_cast<WaitForValueActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 5076 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<WaitForValueActor*>(this)->actor_wait_state = 1;
															#line 489 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WaitForValueActor, 0, FDBStandalone<KeyRef> >*>(static_cast<WaitForValueActor*>(this)));
															#line 5081 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WaitForValueActorState();
		static_cast<WaitForValueActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 495 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			Tuple t;
															#line 496 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			t.append("ERROR"_sr);
															#line 497 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			t.append(format("%d", e.code()));
															#line 499 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			Tuple ret;
															#line 500 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			ret.append(t.pack());
															#line 501 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (!static_cast<WaitForValueActor*>(this)->SAV<Standalone<StringRef>>::futures) { (void)(ret.pack()); this->~WaitForValueActorState(); static_cast<WaitForValueActor*>(this)->destroy(); return 0; }
															#line 5121 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			new (&static_cast<WaitForValueActor*>(this)->SAV< Standalone<StringRef> >::value()) Standalone<StringRef>(ret.pack());
			this->~WaitForValueActorState();
			static_cast<WaitForValueActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(FDBStandalone<KeyRef> const& value,int loopDepth) 
	{
															#line 490 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		Tuple t;
															#line 491 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		t.append(value);
															#line 492 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (!static_cast<WaitForValueActor*>(this)->SAV<Standalone<StringRef>>::futures) { (void)(t.pack()); this->~WaitForValueActorState(); static_cast<WaitForValueActor*>(this)->destroy(); return 0; }
															#line 5143 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		new (&static_cast<WaitForValueActor*>(this)->SAV< Standalone<StringRef> >::value()) Standalone<StringRef>(t.pack());
		this->~WaitForValueActorState();
		static_cast<WaitForValueActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(FDBStandalone<KeyRef> && value,int loopDepth) 
	{
															#line 490 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		Tuple t;
															#line 491 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		t.append(value);
															#line 492 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (!static_cast<WaitForValueActor*>(this)->SAV<Standalone<StringRef>>::futures) { (void)(t.pack()); this->~WaitForValueActorState(); static_cast<WaitForValueActor*>(this)->destroy(); return 0; }
															#line 5159 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		new (&static_cast<WaitForValueActor*>(this)->SAV< Standalone<StringRef> >::value()) Standalone<StringRef>(t.pack());
		this->~WaitForValueActorState();
		static_cast<WaitForValueActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(FDBStandalone<KeyRef> const& value,int loopDepth) 
	{
		loopDepth = a_body1cont2(value, loopDepth);

		return loopDepth;
	}
	int a_body1when1(FDBStandalone<KeyRef> && value,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(value), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WaitForValueActor*>(this)->actor_wait_state > 0) static_cast<WaitForValueActor*>(this)->actor_wait_state = 0;
		static_cast<WaitForValueActor*>(this)->ActorCallback< WaitForValueActor, 0, FDBStandalone<KeyRef> >::remove();

	}
	void a_callback_fire(ActorCallback< WaitForValueActor, 0, FDBStandalone<KeyRef> >*,FDBStandalone<KeyRef> const& value) 
	{
		fdb_probe_actor_enter("waitForValue", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForValue", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WaitForValueActor, 0, FDBStandalone<KeyRef> >*,FDBStandalone<KeyRef> && value) 
	{
		fdb_probe_actor_enter("waitForValue", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForValue", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WaitForValueActor, 0, FDBStandalone<KeyRef> >*,Error err) 
	{
		fdb_probe_actor_enter("waitForValue", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForValue", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 487 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Future<FDBStandalone<KeyRef>> f;
															#line 5244 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
};
// This generated class is to be used only via waitForValue()
															#line 487 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
class WaitForValueActor final : public Actor<Standalone<StringRef>>, public ActorCallback< WaitForValueActor, 0, FDBStandalone<KeyRef> >, public FastAllocated<WaitForValueActor>, public WaitForValueActorState<WaitForValueActor> {
															#line 5249 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
public:
	using FastAllocated<WaitForValueActor>::operator new;
	using FastAllocated<WaitForValueActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7964207935347787520UL, 2125763230272020736UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Standalone<StringRef>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WaitForValueActor, 0, FDBStandalone<KeyRef> >;
															#line 487 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	WaitForValueActor(Future<FDBStandalone<KeyRef>> const& f) 
															#line 5266 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		 : Actor<Standalone<StringRef>>(),
		   WaitForValueActorState<WaitForValueActor>(f),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("waitForValue", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4720093944759506432UL, 9928750131020560128UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("waitForValue");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("waitForValue", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WaitForValueActor, 0, FDBStandalone<KeyRef> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 487 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
[[nodiscard]] Future<Standalone<StringRef>> waitForValue( Future<FDBStandalone<KeyRef>> const& f ) {
															#line 487 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	return Future<Standalone<StringRef>>(new WaitForValueActor(f));
															#line 5299 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
}

#line 504 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"

															#line 5304 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
namespace {
// This generated class is to be used only via waitForValue()
															#line 505 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
template <class WaitForValueActor1>
															#line 505 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
class WaitForValueActor1State {
															#line 5311 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
public:
															#line 505 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	WaitForValueActor1State(Future<Optional<FDBStandalone<ValueRef>>> const& f) 
															#line 505 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
															#line 505 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		 : f(f)
															#line 5318 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
	{
		fdb_probe_actor_create("waitForValue", reinterpret_cast<unsigned long>(this));

	}
	~WaitForValueActor1State() 
	{
		fdb_probe_actor_destroy("waitForValue", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 507 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
				StrictFuture<Optional<FDBStandalone<ValueRef>>> __when_expr_0 = f;
															#line 507 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
				if (static_cast<WaitForValueActor1*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 5336 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<WaitForValueActor1*>(this)->actor_wait_state = 1;
															#line 507 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WaitForValueActor1, 0, Optional<FDBStandalone<ValueRef>> >*>(static_cast<WaitForValueActor1*>(this)));
															#line 5341 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WaitForValueActor1State();
		static_cast<WaitForValueActor1*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 519 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			Tuple t;
															#line 520 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			t.append("ERROR"_sr);
															#line 521 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			t.append(format("%d", e.code()));
															#line 523 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			Tuple ret;
															#line 524 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			ret.append(t.pack());
															#line 525 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (!static_cast<WaitForValueActor1*>(this)->SAV<Standalone<StringRef>>::futures) { (void)(ret.pack()); this->~WaitForValueActor1State(); static_cast<WaitForValueActor1*>(this)->destroy(); return 0; }
															#line 5381 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			new (&static_cast<WaitForValueActor1*>(this)->SAV< Standalone<StringRef> >::value()) Standalone<StringRef>(ret.pack());
			this->~WaitForValueActor1State();
			static_cast<WaitForValueActor1*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Optional<FDBStandalone<ValueRef>> const& value,int loopDepth) 
	{
															#line 508 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		Standalone<StringRef> str;
															#line 509 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (value.present())
															#line 5401 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		{
															#line 510 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			str = value.get();
															#line 5405 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		}
		else
		{
															#line 512 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			str = "RESULT_NOT_PRESENT"_sr;
															#line 5411 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		}
															#line 514 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		Tuple t;
															#line 515 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		t.append(str);
															#line 516 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (!static_cast<WaitForValueActor1*>(this)->SAV<Standalone<StringRef>>::futures) { (void)(t.pack()); this->~WaitForValueActor1State(); static_cast<WaitForValueActor1*>(this)->destroy(); return 0; }
															#line 5419 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		new (&static_cast<WaitForValueActor1*>(this)->SAV< Standalone<StringRef> >::value()) Standalone<StringRef>(t.pack());
		this->~WaitForValueActor1State();
		static_cast<WaitForValueActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Optional<FDBStandalone<ValueRef>> && value,int loopDepth) 
	{
															#line 508 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		Standalone<StringRef> str;
															#line 509 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (value.present())
															#line 5433 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		{
															#line 510 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			str = value.get();
															#line 5437 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		}
		else
		{
															#line 512 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			str = "RESULT_NOT_PRESENT"_sr;
															#line 5443 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		}
															#line 514 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		Tuple t;
															#line 515 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		t.append(str);
															#line 516 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (!static_cast<WaitForValueActor1*>(this)->SAV<Standalone<StringRef>>::futures) { (void)(t.pack()); this->~WaitForValueActor1State(); static_cast<WaitForValueActor1*>(this)->destroy(); return 0; }
															#line 5451 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		new (&static_cast<WaitForValueActor1*>(this)->SAV< Standalone<StringRef> >::value()) Standalone<StringRef>(t.pack());
		this->~WaitForValueActor1State();
		static_cast<WaitForValueActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Optional<FDBStandalone<ValueRef>> const& value,int loopDepth) 
	{
		loopDepth = a_body1cont2(value, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<FDBStandalone<ValueRef>> && value,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(value), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WaitForValueActor1*>(this)->actor_wait_state > 0) static_cast<WaitForValueActor1*>(this)->actor_wait_state = 0;
		static_cast<WaitForValueActor1*>(this)->ActorCallback< WaitForValueActor1, 0, Optional<FDBStandalone<ValueRef>> >::remove();

	}
	void a_callback_fire(ActorCallback< WaitForValueActor1, 0, Optional<FDBStandalone<ValueRef>> >*,Optional<FDBStandalone<ValueRef>> const& value) 
	{
		fdb_probe_actor_enter("waitForValue", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForValueActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForValue", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WaitForValueActor1, 0, Optional<FDBStandalone<ValueRef>> >*,Optional<FDBStandalone<ValueRef>> && value) 
	{
		fdb_probe_actor_enter("waitForValue", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForValueActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForValue", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WaitForValueActor1, 0, Optional<FDBStandalone<ValueRef>> >*,Error err) 
	{
		fdb_probe_actor_enter("waitForValue", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForValueActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForValue", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 505 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Future<Optional<FDBStandalone<ValueRef>>> f;
															#line 5536 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
};
// This generated class is to be used only via waitForValue()
															#line 505 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
class WaitForValueActor1 final : public Actor<Standalone<StringRef>>, public ActorCallback< WaitForValueActor1, 0, Optional<FDBStandalone<ValueRef>> >, public FastAllocated<WaitForValueActor1>, public WaitForValueActor1State<WaitForValueActor1> {
															#line 5541 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
public:
	using FastAllocated<WaitForValueActor1>::operator new;
	using FastAllocated<WaitForValueActor1>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7964207935347787520UL, 2125763230272020736UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Standalone<StringRef>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WaitForValueActor1, 0, Optional<FDBStandalone<ValueRef>> >;
															#line 505 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	WaitForValueActor1(Future<Optional<FDBStandalone<ValueRef>>> const& f) 
															#line 5558 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		 : Actor<Standalone<StringRef>>(),
		   WaitForValueActor1State<WaitForValueActor1>(f),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("waitForValue", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16914345804625883904UL, 11749059737519828480UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForValueActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("waitForValue");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("waitForValue", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WaitForValueActor1, 0, Optional<FDBStandalone<ValueRef>> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 505 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
[[nodiscard]] Future<Standalone<StringRef>> waitForValue( Future<Optional<FDBStandalone<ValueRef>>> const& f ) {
															#line 505 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	return Future<Standalone<StringRef>>(new WaitForValueActor1(f));
															#line 5591 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
}

#line 528 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"

															#line 5596 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
namespace {
// This generated class is to be used only via getKey()
															#line 529 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
template <class GetKeyActor>
															#line 529 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
class GetKeyActorState {
															#line 5603 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
public:
															#line 529 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	GetKeyActorState(Future<FDBStandalone<KeyRef>> const& f,Standalone<StringRef> const& prefixFilter) 
															#line 529 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
															#line 529 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		 : f(f),
															#line 529 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		   prefixFilter(prefixFilter)
															#line 5612 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
	{
		fdb_probe_actor_create("getKey", reinterpret_cast<unsigned long>(this));

	}
	~GetKeyActorState() 
	{
		fdb_probe_actor_destroy("getKey", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 531 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
				StrictFuture<FDBStandalone<KeyRef>> __when_expr_0 = f;
															#line 531 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
				if (static_cast<GetKeyActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 5630 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<GetKeyActor*>(this)->actor_wait_state = 1;
															#line 531 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetKeyActor, 0, FDBStandalone<KeyRef> >*>(static_cast<GetKeyActor*>(this)));
															#line 5635 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetKeyActorState();
		static_cast<GetKeyActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 545 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			Tuple t;
															#line 546 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			t.append("ERROR"_sr);
															#line 547 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			t.append(format("%d", e.code()));
															#line 549 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			Tuple ret;
															#line 550 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			ret.append(t.pack());
															#line 551 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (!static_cast<GetKeyActor*>(this)->SAV<Standalone<StringRef>>::futures) { (void)(ret.pack()); this->~GetKeyActorState(); static_cast<GetKeyActor*>(this)->destroy(); return 0; }
															#line 5675 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			new (&static_cast<GetKeyActor*>(this)->SAV< Standalone<StringRef> >::value()) Standalone<StringRef>(ret.pack());
			this->~GetKeyActorState();
			static_cast<GetKeyActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(FDBStandalone<KeyRef> const& key,int loopDepth) 
	{
															#line 532 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		Tuple t;
															#line 534 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (key.startsWith(prefixFilter))
															#line 5695 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		{
															#line 535 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			t.append(key);
															#line 5699 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		}
		else
		{
															#line 536 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (key < prefixFilter)
															#line 5705 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			{
															#line 537 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
				t.append(prefixFilter);
															#line 5709 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			}
			else
			{
															#line 539 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
				t.append(strinc(prefixFilter));
															#line 5715 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			}
		}
															#line 542 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (!static_cast<GetKeyActor*>(this)->SAV<Standalone<StringRef>>::futures) { (void)(t.pack()); this->~GetKeyActorState(); static_cast<GetKeyActor*>(this)->destroy(); return 0; }
															#line 5720 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		new (&static_cast<GetKeyActor*>(this)->SAV< Standalone<StringRef> >::value()) Standalone<StringRef>(t.pack());
		this->~GetKeyActorState();
		static_cast<GetKeyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(FDBStandalone<KeyRef> && key,int loopDepth) 
	{
															#line 532 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		Tuple t;
															#line 534 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (key.startsWith(prefixFilter))
															#line 5734 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		{
															#line 535 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			t.append(key);
															#line 5738 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		}
		else
		{
															#line 536 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (key < prefixFilter)
															#line 5744 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			{
															#line 537 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
				t.append(prefixFilter);
															#line 5748 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			}
			else
			{
															#line 539 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
				t.append(strinc(prefixFilter));
															#line 5754 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			}
		}
															#line 542 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (!static_cast<GetKeyActor*>(this)->SAV<Standalone<StringRef>>::futures) { (void)(t.pack()); this->~GetKeyActorState(); static_cast<GetKeyActor*>(this)->destroy(); return 0; }
															#line 5759 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		new (&static_cast<GetKeyActor*>(this)->SAV< Standalone<StringRef> >::value()) Standalone<StringRef>(t.pack());
		this->~GetKeyActorState();
		static_cast<GetKeyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(FDBStandalone<KeyRef> const& key,int loopDepth) 
	{
		loopDepth = a_body1cont2(key, loopDepth);

		return loopDepth;
	}
	int a_body1when1(FDBStandalone<KeyRef> && key,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(key), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetKeyActor*>(this)->actor_wait_state > 0) static_cast<GetKeyActor*>(this)->actor_wait_state = 0;
		static_cast<GetKeyActor*>(this)->ActorCallback< GetKeyActor, 0, FDBStandalone<KeyRef> >::remove();

	}
	void a_callback_fire(ActorCallback< GetKeyActor, 0, FDBStandalone<KeyRef> >*,FDBStandalone<KeyRef> const& value) 
	{
		fdb_probe_actor_enter("getKey", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKey", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetKeyActor, 0, FDBStandalone<KeyRef> >*,FDBStandalone<KeyRef> && value) 
	{
		fdb_probe_actor_enter("getKey", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKey", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetKeyActor, 0, FDBStandalone<KeyRef> >*,Error err) 
	{
		fdb_probe_actor_enter("getKey", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKey", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 529 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Future<FDBStandalone<KeyRef>> f;
															#line 529 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Standalone<StringRef> prefixFilter;
															#line 5846 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
};
// This generated class is to be used only via getKey()
															#line 529 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
class GetKeyActor final : public Actor<Standalone<StringRef>>, public ActorCallback< GetKeyActor, 0, FDBStandalone<KeyRef> >, public FastAllocated<GetKeyActor>, public GetKeyActorState<GetKeyActor> {
															#line 5851 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
public:
	using FastAllocated<GetKeyActor>::operator new;
	using FastAllocated<GetKeyActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6067035194829538560UL, 3827223449766491648UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Standalone<StringRef>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetKeyActor, 0, FDBStandalone<KeyRef> >;
															#line 529 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	GetKeyActor(Future<FDBStandalone<KeyRef>> const& f,Standalone<StringRef> const& prefixFilter) 
															#line 5868 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		 : Actor<Standalone<StringRef>>(),
		   GetKeyActorState<GetKeyActor>(f, prefixFilter),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getKey", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3161838746568296704UL, 16159820804706226432UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getKey");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getKey", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetKeyActor, 0, FDBStandalone<KeyRef> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 529 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
[[nodiscard]] Future<Standalone<StringRef>> getKey( Future<FDBStandalone<KeyRef>> const& f, Standalone<StringRef> const& prefixFilter ) {
															#line 529 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	return Future<Standalone<StringRef>>(new GetKeyActor(f, prefixFilter));
															#line 5901 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
}

#line 554 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"

struct NewTransactionFunc : InstructionFunc {
	static const char* name;

	static Future<Void> call(Reference<FlowTesterData> const& data, Reference<InstructionData> const& instruction) {
		trMap[data->trName] = data->db->createTransaction();
		return Void();
	}
};
const char* NewTransactionFunc::name = "NEW_TRANSACTION";
REGISTER_INSTRUCTION_FUNC(NewTransactionFunc);

struct UseTransactionFunc : InstructionFunc {
	static const char* name;

																#line 5920 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
// This generated class is to be used only via call()
															#line 569 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
template <class CallActor5>
															#line 569 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
class CallActor5State {
															#line 5926 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
public:
															#line 569 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	CallActor5State(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 569 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
															#line 569 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		 : data(data),
															#line 569 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		   instruction(instruction),
															#line 570 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		   items(data->stack.pop())
															#line 5937 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
	{
		fdb_probe_actor_create("call", reinterpret_cast<unsigned long>(this));

	}
	~CallActor5State() 
	{
		fdb_probe_actor_destroy("call", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 571 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			StrictFuture<Standalone<StringRef>> __when_expr_0 = items[0].value;
															#line 571 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (static_cast<CallActor5*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5954 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CallActor5*>(this)->actor_wait_state = 1;
															#line 571 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CallActor5, 0, Standalone<StringRef> >*>(static_cast<CallActor5*>(this)));
															#line 5959 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CallActor5State();
		static_cast<CallActor5*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Standalone<StringRef> const& name,int loopDepth) 
	{
															#line 572 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		data->trName = name;
															#line 574 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (trMap.count(data->trName) == 0)
															#line 5984 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		{
															#line 575 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			trMap[data->trName] = data->db->createTransaction();
															#line 5988 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		}
															#line 577 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (!static_cast<CallActor5*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor5State(); static_cast<CallActor5*>(this)->destroy(); return 0; }
															#line 5992 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		new (&static_cast<CallActor5*>(this)->SAV< Void >::value()) Void(Void());
		this->~CallActor5State();
		static_cast<CallActor5*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Standalone<StringRef> && name,int loopDepth) 
	{
															#line 572 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		data->trName = name;
															#line 574 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (trMap.count(data->trName) == 0)
															#line 6006 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		{
															#line 575 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			trMap[data->trName] = data->db->createTransaction();
															#line 6010 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		}
															#line 577 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (!static_cast<CallActor5*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor5State(); static_cast<CallActor5*>(this)->destroy(); return 0; }
															#line 6014 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		new (&static_cast<CallActor5*>(this)->SAV< Void >::value()) Void(Void());
		this->~CallActor5State();
		static_cast<CallActor5*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Standalone<StringRef> const& name,int loopDepth) 
	{
		loopDepth = a_body1cont1(name, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Standalone<StringRef> && name,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(name), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CallActor5*>(this)->actor_wait_state > 0) static_cast<CallActor5*>(this)->actor_wait_state = 0;
		static_cast<CallActor5*>(this)->ActorCallback< CallActor5, 0, Standalone<StringRef> >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor5, 0, Standalone<StringRef> >*,Standalone<StringRef> const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor5*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CallActor5, 0, Standalone<StringRef> >*,Standalone<StringRef> && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor5*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CallActor5, 0, Standalone<StringRef> >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor5*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 569 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Reference<FlowTesterData> data;
															#line 569 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Reference<InstructionData> instruction;
															#line 570 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	std::vector<StackItem> items;
															#line 6103 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
};
// This generated class is to be used only via call()
															#line 569 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
class CallActor5 final : public Actor<Void>, public ActorCallback< CallActor5, 0, Standalone<StringRef> >, public FastAllocated<CallActor5>, public CallActor5State<CallActor5> {
															#line 6108 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
public:
	using FastAllocated<CallActor5>::operator new;
	using FastAllocated<CallActor5>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9317237842190798848UL, 4308047855804869376UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CallActor5, 0, Standalone<StringRef> >;
															#line 569 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	CallActor5(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 6125 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		 : Actor<Void>(),
		   CallActor5State<CallActor5>(data, instruction),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8830978267066932480UL, 12194855831069212160UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor5*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("call");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CallActor5, 0, Standalone<StringRef> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 569 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
[[nodiscard]] static Future<Void> call( Reference<FlowTesterData> const& data, Reference<InstructionData> const& instruction ) {
															#line 569 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	return Future<Void>(new CallActor5(data, instruction));
															#line 6157 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
}

#line 579 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
};
const char* UseTransactionFunc::name = "USE_TRANSACTION";
REGISTER_INSTRUCTION_FUNC(UseTransactionFunc);

struct OnErrorFunc : InstructionFunc {
	static const char* name;

																#line 6168 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
// This generated class is to be used only via call()
															#line 586 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
template <class CallActor6>
															#line 586 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
class CallActor6State {
															#line 6174 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
public:
															#line 586 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	CallActor6State(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 586 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
															#line 586 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		 : data(data),
															#line 586 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		   instruction(instruction),
															#line 587 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		   items(data->stack.pop())
															#line 6185 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
	{
		fdb_probe_actor_create("call", reinterpret_cast<unsigned long>(this));

	}
	~CallActor6State() 
	{
		fdb_probe_actor_destroy("call", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 588 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (items.empty())
															#line 6200 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			{
															#line 589 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
				if (!static_cast<CallActor6*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor6State(); static_cast<CallActor6*>(this)->destroy(); return 0; }
															#line 6204 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
				new (&static_cast<CallActor6*>(this)->SAV< Void >::value()) Void(Void());
				this->~CallActor6State();
				static_cast<CallActor6*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 591 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			StrictFuture<Standalone<StringRef>> __when_expr_0 = items[0].value;
															#line 591 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (static_cast<CallActor6*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6214 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CallActor6*>(this)->actor_wait_state = 1;
															#line 591 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CallActor6, 0, Standalone<StringRef> >*>(static_cast<CallActor6*>(this)));
															#line 6219 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CallActor6State();
		static_cast<CallActor6*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Standalone<StringRef> const& value,int loopDepth) 
	{
															#line 592 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		int err_code = Tuple::unpack(value).getInt(0);
															#line 595 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		data->stack.push(waitForVoid(instruction->tr->onError(Error(err_code))));
															#line 596 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (!static_cast<CallActor6*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor6State(); static_cast<CallActor6*>(this)->destroy(); return 0; }
															#line 6246 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		new (&static_cast<CallActor6*>(this)->SAV< Void >::value()) Void(Void());
		this->~CallActor6State();
		static_cast<CallActor6*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Standalone<StringRef> && value,int loopDepth) 
	{
															#line 592 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		int err_code = Tuple::unpack(value).getInt(0);
															#line 595 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		data->stack.push(waitForVoid(instruction->tr->onError(Error(err_code))));
															#line 596 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (!static_cast<CallActor6*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor6State(); static_cast<CallActor6*>(this)->destroy(); return 0; }
															#line 6262 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		new (&static_cast<CallActor6*>(this)->SAV< Void >::value()) Void(Void());
		this->~CallActor6State();
		static_cast<CallActor6*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Standalone<StringRef> const& value,int loopDepth) 
	{
		loopDepth = a_body1cont1(value, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Standalone<StringRef> && value,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(value), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CallActor6*>(this)->actor_wait_state > 0) static_cast<CallActor6*>(this)->actor_wait_state = 0;
		static_cast<CallActor6*>(this)->ActorCallback< CallActor6, 0, Standalone<StringRef> >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor6, 0, Standalone<StringRef> >*,Standalone<StringRef> const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor6*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CallActor6, 0, Standalone<StringRef> >*,Standalone<StringRef> && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor6*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CallActor6, 0, Standalone<StringRef> >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor6*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 586 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Reference<FlowTesterData> data;
															#line 586 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Reference<InstructionData> instruction;
															#line 587 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	std::vector<StackItem> items;
															#line 6351 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
};
// This generated class is to be used only via call()
															#line 586 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
class CallActor6 final : public Actor<Void>, public ActorCallback< CallActor6, 0, Standalone<StringRef> >, public FastAllocated<CallActor6>, public CallActor6State<CallActor6> {
															#line 6356 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
public:
	using FastAllocated<CallActor6>::operator new;
	using FastAllocated<CallActor6>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9317237842190798848UL, 4308047855804869376UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CallActor6, 0, Standalone<StringRef> >;
															#line 586 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	CallActor6(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 6373 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		 : Actor<Void>(),
		   CallActor6State<CallActor6>(data, instruction),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2057654832222722560UL, 6470415639012464640UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor6*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("call");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CallActor6, 0, Standalone<StringRef> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 586 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
[[nodiscard]] static Future<Void> call( Reference<FlowTesterData> const& data, Reference<InstructionData> const& instruction ) {
															#line 586 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	return Future<Void>(new CallActor6(data, instruction));
															#line 6405 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
}

#line 598 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
};
const char* OnErrorFunc::name = "ON_ERROR";
REGISTER_INSTRUCTION_FUNC(OnErrorFunc);

struct SetFunc : InstructionFunc {
	static const char* name;

																#line 6416 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
// This generated class is to be used only via call()
															#line 605 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
template <class CallActor7>
															#line 605 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
class CallActor7State {
															#line 6422 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
public:
															#line 605 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	CallActor7State(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 605 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
															#line 605 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		 : data(data),
															#line 605 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		   instruction(instruction),
															#line 606 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		   items(data->stack.pop(2))
															#line 6433 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
	{
		fdb_probe_actor_create("call", reinterpret_cast<unsigned long>(this));

	}
	~CallActor7State() 
	{
		fdb_probe_actor_destroy("call", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 607 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (items.size() != 2)
															#line 6448 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			{
															#line 608 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
				if (!static_cast<CallActor7*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor7State(); static_cast<CallActor7*>(this)->destroy(); return 0; }
															#line 6452 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
				new (&static_cast<CallActor7*>(this)->SAV< Void >::value()) Void(Void());
				this->~CallActor7State();
				static_cast<CallActor7*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 610 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			StrictFuture<Standalone<StringRef>> __when_expr_0 = items[0].value;
															#line 610 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (static_cast<CallActor7*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6462 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CallActor7*>(this)->actor_wait_state = 1;
															#line 610 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CallActor7, 0, Standalone<StringRef> >*>(static_cast<CallActor7*>(this)));
															#line 6467 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CallActor7State();
		static_cast<CallActor7*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Standalone<StringRef> const& sk,int loopDepth) 
	{
															#line 611 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		key = Tuple::unpack(sk).getString(0);
															#line 614 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		StrictFuture<Standalone<StringRef>> __when_expr_1 = items[1].value;
															#line 614 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (static_cast<CallActor7*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6494 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CallActor7*>(this)->actor_wait_state = 2;
															#line 614 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CallActor7, 1, Standalone<StringRef> >*>(static_cast<CallActor7*>(this)));
															#line 6499 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Standalone<StringRef> && sk,int loopDepth) 
	{
															#line 611 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		key = Tuple::unpack(sk).getString(0);
															#line 614 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		StrictFuture<Standalone<StringRef>> __when_expr_1 = items[1].value;
															#line 614 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (static_cast<CallActor7*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6512 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CallActor7*>(this)->actor_wait_state = 2;
															#line 614 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CallActor7, 1, Standalone<StringRef> >*>(static_cast<CallActor7*>(this)));
															#line 6517 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Standalone<StringRef> const& sk,int loopDepth) 
	{
		loopDepth = a_body1cont1(sk, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Standalone<StringRef> && sk,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(sk), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CallActor7*>(this)->actor_wait_state > 0) static_cast<CallActor7*>(this)->actor_wait_state = 0;
		static_cast<CallActor7*>(this)->ActorCallback< CallActor7, 0, Standalone<StringRef> >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor7, 0, Standalone<StringRef> >*,Standalone<StringRef> const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor7*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CallActor7, 0, Standalone<StringRef> >*,Standalone<StringRef> && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor7*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CallActor7, 0, Standalone<StringRef> >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor7*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(Standalone<StringRef> const& sv,int loopDepth) 
	{
															#line 615 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		Standalone<StringRef> value = Tuple::unpack(sv).getString(0);
															#line 618 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		Reference<InstructionData> instructionCopy = instruction;
															#line 619 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		Standalone<StringRef> keyCopy = key;
															#line 621 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		Future<Void> mutation = executeMutation(instruction, [instructionCopy, keyCopy, value]() -> Future<Void> { instructionCopy->tr->set(keyCopy, value); return Void(); });
															#line 626 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (instruction->isDatabase)
															#line 6609 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		{
															#line 627 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			data->stack.push(waitForVoid(mutation));
															#line 6613 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			loopDepth = a_body1cont4(loopDepth);
		}
		else
		{
															#line 629 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			StrictFuture<Void> __when_expr_2 = mutation;
															#line 629 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (static_cast<CallActor7*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6622 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
			static_cast<CallActor7*>(this)->actor_wait_state = 3;
															#line 629 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CallActor7, 2, Void >*>(static_cast<CallActor7*>(this)));
															#line 6627 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont3(Standalone<StringRef> && sv,int loopDepth) 
	{
															#line 615 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		Standalone<StringRef> value = Tuple::unpack(sv).getString(0);
															#line 618 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		Reference<InstructionData> instructionCopy = instruction;
															#line 619 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		Standalone<StringRef> keyCopy = key;
															#line 621 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		Future<Void> mutation = executeMutation(instruction, [instructionCopy, keyCopy, value]() -> Future<Void> { instructionCopy->tr->set(keyCopy, value); return Void(); });
															#line 626 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (instruction->isDatabase)
															#line 6645 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		{
															#line 627 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			data->stack.push(waitForVoid(mutation));
															#line 6649 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			loopDepth = a_body1cont4(loopDepth);
		}
		else
		{
															#line 629 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			StrictFuture<Void> __when_expr_2 = mutation;
															#line 629 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (static_cast<CallActor7*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6658 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
			static_cast<CallActor7*>(this)->actor_wait_state = 3;
															#line 629 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CallActor7, 2, Void >*>(static_cast<CallActor7*>(this)));
															#line 6663 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont1when1(Standalone<StringRef> const& sv,int loopDepth) 
	{
		loopDepth = a_body1cont3(sv, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Standalone<StringRef> && sv,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(sv), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CallActor7*>(this)->actor_wait_state > 0) static_cast<CallActor7*>(this)->actor_wait_state = 0;
		static_cast<CallActor7*>(this)->ActorCallback< CallActor7, 1, Standalone<StringRef> >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor7, 1, Standalone<StringRef> >*,Standalone<StringRef> const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor7*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CallActor7, 1, Standalone<StringRef> >*,Standalone<StringRef> && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor7*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CallActor7, 1, Standalone<StringRef> >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor7*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 632 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (!static_cast<CallActor7*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor7State(); static_cast<CallActor7*>(this)->destroy(); return 0; }
															#line 6748 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		new (&static_cast<CallActor7*>(this)->SAV< Void >::value()) Void(Void());
		this->~CallActor7State();
		static_cast<CallActor7*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CallActor7*>(this)->actor_wait_state > 0) static_cast<CallActor7*>(this)->actor_wait_state = 0;
		static_cast<CallActor7*>(this)->ActorCallback< CallActor7, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor7, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor7*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CallActor7, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor7*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CallActor7, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor7*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 605 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Reference<FlowTesterData> data;
															#line 605 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Reference<InstructionData> instruction;
															#line 606 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	std::vector<StackItem> items;
															#line 611 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Standalone<StringRef> key;
															#line 6851 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
};
// This generated class is to be used only via call()
															#line 605 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
class CallActor7 final : public Actor<Void>, public ActorCallback< CallActor7, 0, Standalone<StringRef> >, public ActorCallback< CallActor7, 1, Standalone<StringRef> >, public ActorCallback< CallActor7, 2, Void >, public FastAllocated<CallActor7>, public CallActor7State<CallActor7> {
															#line 6856 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
public:
	using FastAllocated<CallActor7>::operator new;
	using FastAllocated<CallActor7>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9317237842190798848UL, 4308047855804869376UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CallActor7, 0, Standalone<StringRef> >;
friend struct ActorCallback< CallActor7, 1, Standalone<StringRef> >;
friend struct ActorCallback< CallActor7, 2, Void >;
															#line 605 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	CallActor7(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 6875 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		 : Actor<Void>(),
		   CallActor7State<CallActor7>(data, instruction),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16126275780308219648UL, 15827223303016527872UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor7*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("call");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CallActor7, 0, Standalone<StringRef> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CallActor7, 1, Standalone<StringRef> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CallActor7, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 605 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
[[nodiscard]] static Future<Void> call( Reference<FlowTesterData> const& data, Reference<InstructionData> const& instruction ) {
															#line 605 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	return Future<Void>(new CallActor7(data, instruction));
															#line 6909 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
}

#line 634 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
};
const char* SetFunc::name = "SET";
REGISTER_INSTRUCTION_FUNC(SetFunc);

struct GetFunc : InstructionFunc {
	static const char* name;

																#line 6920 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
// This generated class is to be used only via call()
															#line 641 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
template <class CallActor8>
															#line 641 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
class CallActor8State {
															#line 6926 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
public:
															#line 641 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	CallActor8State(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 641 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
															#line 641 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		 : data(data),
															#line 641 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		   instruction(instruction),
															#line 642 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		   items(data->stack.pop())
															#line 6937 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
	{
		fdb_probe_actor_create("call", reinterpret_cast<unsigned long>(this));

	}
	~CallActor8State() 
	{
		fdb_probe_actor_destroy("call", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 643 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (items.size() != 1)
															#line 6952 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			{
															#line 644 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
				if (!static_cast<CallActor8*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor8State(); static_cast<CallActor8*>(this)->destroy(); return 0; }
															#line 6956 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
				new (&static_cast<CallActor8*>(this)->SAV< Void >::value()) Void(Void());
				this->~CallActor8State();
				static_cast<CallActor8*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 646 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			StrictFuture<Standalone<StringRef>> __when_expr_0 = items[0].value;
															#line 646 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (static_cast<CallActor8*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6966 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CallActor8*>(this)->actor_wait_state = 1;
															#line 646 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CallActor8, 0, Standalone<StringRef> >*>(static_cast<CallActor8*>(this)));
															#line 6971 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CallActor8State();
		static_cast<CallActor8*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Standalone<StringRef> const& sk,int loopDepth) 
	{
															#line 647 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		key = Tuple::unpack(sk).getString(0);
															#line 649 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		Future<Optional<FDBStandalone<ValueRef>>> fk = instruction->tr->get(StringRef(key), instruction->isSnapshot);
															#line 650 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		data->stack.push(waitForValue(holdWhile(instruction->tr, fk)));
															#line 652 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (!static_cast<CallActor8*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor8State(); static_cast<CallActor8*>(this)->destroy(); return 0; }
															#line 7000 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		new (&static_cast<CallActor8*>(this)->SAV< Void >::value()) Void(Void());
		this->~CallActor8State();
		static_cast<CallActor8*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Standalone<StringRef> && sk,int loopDepth) 
	{
															#line 647 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		key = Tuple::unpack(sk).getString(0);
															#line 649 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		Future<Optional<FDBStandalone<ValueRef>>> fk = instruction->tr->get(StringRef(key), instruction->isSnapshot);
															#line 650 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		data->stack.push(waitForValue(holdWhile(instruction->tr, fk)));
															#line 652 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (!static_cast<CallActor8*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor8State(); static_cast<CallActor8*>(this)->destroy(); return 0; }
															#line 7018 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		new (&static_cast<CallActor8*>(this)->SAV< Void >::value()) Void(Void());
		this->~CallActor8State();
		static_cast<CallActor8*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Standalone<StringRef> const& sk,int loopDepth) 
	{
		loopDepth = a_body1cont1(sk, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Standalone<StringRef> && sk,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(sk), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CallActor8*>(this)->actor_wait_state > 0) static_cast<CallActor8*>(this)->actor_wait_state = 0;
		static_cast<CallActor8*>(this)->ActorCallback< CallActor8, 0, Standalone<StringRef> >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor8, 0, Standalone<StringRef> >*,Standalone<StringRef> const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor8*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CallActor8, 0, Standalone<StringRef> >*,Standalone<StringRef> && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor8*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CallActor8, 0, Standalone<StringRef> >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor8*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 641 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Reference<FlowTesterData> data;
															#line 641 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Reference<InstructionData> instruction;
															#line 642 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	std::vector<StackItem> items;
															#line 647 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Standalone<StringRef> key;
															#line 7109 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
};
// This generated class is to be used only via call()
															#line 641 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
class CallActor8 final : public Actor<Void>, public ActorCallback< CallActor8, 0, Standalone<StringRef> >, public FastAllocated<CallActor8>, public CallActor8State<CallActor8> {
															#line 7114 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
public:
	using FastAllocated<CallActor8>::operator new;
	using FastAllocated<CallActor8>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9317237842190798848UL, 4308047855804869376UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CallActor8, 0, Standalone<StringRef> >;
															#line 641 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	CallActor8(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 7131 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		 : Actor<Void>(),
		   CallActor8State<CallActor8>(data, instruction),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3112439155534353664UL, 8740650210331251712UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor8*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("call");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CallActor8, 0, Standalone<StringRef> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 641 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
[[nodiscard]] static Future<Void> call( Reference<FlowTesterData> const& data, Reference<InstructionData> const& instruction ) {
															#line 641 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	return Future<Void>(new CallActor8(data, instruction));
															#line 7163 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
}

#line 654 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
};
const char* GetFunc::name = "GET";
REGISTER_INSTRUCTION_FUNC(GetFunc);

struct GetEstimatedRangeSize : InstructionFunc {
	static const char* name;

																#line 7174 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
// This generated class is to be used only via call()
															#line 661 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
template <class CallActor9>
															#line 661 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
class CallActor9State {
															#line 7180 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
public:
															#line 661 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	CallActor9State(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 661 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
															#line 661 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		 : data(data),
															#line 661 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		   instruction(instruction),
															#line 662 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		   items(data->stack.pop(2))
															#line 7191 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
	{
		fdb_probe_actor_create("call", reinterpret_cast<unsigned long>(this));

	}
	~CallActor9State() 
	{
		fdb_probe_actor_destroy("call", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 663 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (items.size() != 2)
															#line 7206 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			{
															#line 664 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
				if (!static_cast<CallActor9*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor9State(); static_cast<CallActor9*>(this)->destroy(); return 0; }
															#line 7210 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
				new (&static_cast<CallActor9*>(this)->SAV< Void >::value()) Void(Void());
				this->~CallActor9State();
				static_cast<CallActor9*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 666 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			StrictFuture<Standalone<StringRef>> __when_expr_0 = items[0].value;
															#line 666 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (static_cast<CallActor9*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7220 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CallActor9*>(this)->actor_wait_state = 1;
															#line 666 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CallActor9, 0, Standalone<StringRef> >*>(static_cast<CallActor9*>(this)));
															#line 7225 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CallActor9State();
		static_cast<CallActor9*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Standalone<StringRef> const& s1,int loopDepth) 
	{
															#line 667 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		beginKey = Tuple::unpack(s1).getString(0);
															#line 669 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		StrictFuture<Standalone<StringRef>> __when_expr_1 = items[1].value;
															#line 669 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (static_cast<CallActor9*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7252 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CallActor9*>(this)->actor_wait_state = 2;
															#line 669 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CallActor9, 1, Standalone<StringRef> >*>(static_cast<CallActor9*>(this)));
															#line 7257 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Standalone<StringRef> && s1,int loopDepth) 
	{
															#line 667 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		beginKey = Tuple::unpack(s1).getString(0);
															#line 669 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		StrictFuture<Standalone<StringRef>> __when_expr_1 = items[1].value;
															#line 669 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (static_cast<CallActor9*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7270 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CallActor9*>(this)->actor_wait_state = 2;
															#line 669 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CallActor9, 1, Standalone<StringRef> >*>(static_cast<CallActor9*>(this)));
															#line 7275 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Standalone<StringRef> const& s1,int loopDepth) 
	{
		loopDepth = a_body1cont1(s1, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Standalone<StringRef> && s1,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(s1), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CallActor9*>(this)->actor_wait_state > 0) static_cast<CallActor9*>(this)->actor_wait_state = 0;
		static_cast<CallActor9*>(this)->ActorCallback< CallActor9, 0, Standalone<StringRef> >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor9, 0, Standalone<StringRef> >*,Standalone<StringRef> const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor9*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CallActor9, 0, Standalone<StringRef> >*,Standalone<StringRef> && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor9*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CallActor9, 0, Standalone<StringRef> >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor9*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(Standalone<StringRef> const& s2,int loopDepth) 
	{
															#line 670 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		endKey = Tuple::unpack(s2).getString(0);
															#line 671 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		Future<int64_t> fsize = instruction->tr->getEstimatedRangeSizeBytes(KeyRangeRef(beginKey, endKey));
															#line 672 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		StrictFuture<int64_t> __when_expr_2 = fsize;
															#line 672 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (static_cast<CallActor9*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7365 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<CallActor9*>(this)->actor_wait_state = 3;
															#line 672 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CallActor9, 2, int64_t >*>(static_cast<CallActor9*>(this)));
															#line 7370 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Standalone<StringRef> && s2,int loopDepth) 
	{
															#line 670 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		endKey = Tuple::unpack(s2).getString(0);
															#line 671 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		Future<int64_t> fsize = instruction->tr->getEstimatedRangeSizeBytes(KeyRangeRef(beginKey, endKey));
															#line 672 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		StrictFuture<int64_t> __when_expr_2 = fsize;
															#line 672 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (static_cast<CallActor9*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7385 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<CallActor9*>(this)->actor_wait_state = 3;
															#line 672 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CallActor9, 2, int64_t >*>(static_cast<CallActor9*>(this)));
															#line 7390 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Standalone<StringRef> const& s2,int loopDepth) 
	{
		loopDepth = a_body1cont3(s2, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Standalone<StringRef> && s2,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(s2), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CallActor9*>(this)->actor_wait_state > 0) static_cast<CallActor9*>(this)->actor_wait_state = 0;
		static_cast<CallActor9*>(this)->ActorCallback< CallActor9, 1, Standalone<StringRef> >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor9, 1, Standalone<StringRef> >*,Standalone<StringRef> const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor9*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CallActor9, 1, Standalone<StringRef> >*,Standalone<StringRef> && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor9*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CallActor9, 1, Standalone<StringRef> >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor9*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(int64_t const& size,int loopDepth) 
	{
															#line 673 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		data->stack.pushTuple("GOT_ESTIMATED_RANGE_SIZE"_sr);
															#line 675 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (!static_cast<CallActor9*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor9State(); static_cast<CallActor9*>(this)->destroy(); return 0; }
															#line 7476 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		new (&static_cast<CallActor9*>(this)->SAV< Void >::value()) Void(Void());
		this->~CallActor9State();
		static_cast<CallActor9*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4(int64_t && size,int loopDepth) 
	{
															#line 673 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		data->stack.pushTuple("GOT_ESTIMATED_RANGE_SIZE"_sr);
															#line 675 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (!static_cast<CallActor9*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor9State(); static_cast<CallActor9*>(this)->destroy(); return 0; }
															#line 7490 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		new (&static_cast<CallActor9*>(this)->SAV< Void >::value()) Void(Void());
		this->~CallActor9State();
		static_cast<CallActor9*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3when1(int64_t const& size,int loopDepth) 
	{
		loopDepth = a_body1cont4(size, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(int64_t && size,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(size), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CallActor9*>(this)->actor_wait_state > 0) static_cast<CallActor9*>(this)->actor_wait_state = 0;
		static_cast<CallActor9*>(this)->ActorCallback< CallActor9, 2, int64_t >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor9, 2, int64_t >*,int64_t const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor9*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CallActor9, 2, int64_t >*,int64_t && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor9*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CallActor9, 2, int64_t >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor9*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 661 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Reference<FlowTesterData> data;
															#line 661 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Reference<InstructionData> instruction;
															#line 662 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	std::vector<StackItem> items;
															#line 667 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Standalone<StringRef> beginKey;
															#line 670 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Standalone<StringRef> endKey;
															#line 7583 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
};
// This generated class is to be used only via call()
															#line 661 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
class CallActor9 final : public Actor<Void>, public ActorCallback< CallActor9, 0, Standalone<StringRef> >, public ActorCallback< CallActor9, 1, Standalone<StringRef> >, public ActorCallback< CallActor9, 2, int64_t >, public FastAllocated<CallActor9>, public CallActor9State<CallActor9> {
															#line 7588 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
public:
	using FastAllocated<CallActor9>::operator new;
	using FastAllocated<CallActor9>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9317237842190798848UL, 4308047855804869376UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CallActor9, 0, Standalone<StringRef> >;
friend struct ActorCallback< CallActor9, 1, Standalone<StringRef> >;
friend struct ActorCallback< CallActor9, 2, int64_t >;
															#line 661 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	CallActor9(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 7607 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		 : Actor<Void>(),
		   CallActor9State<CallActor9>(data, instruction),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1262208671142567936UL, 15420667126183834624UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor9*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("call");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CallActor9, 0, Standalone<StringRef> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CallActor9, 1, Standalone<StringRef> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CallActor9, 2, int64_t >*)0, actor_cancelled()); break;
		}

	}
};
															#line 661 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
[[nodiscard]] static Future<Void> call( Reference<FlowTesterData> const& data, Reference<InstructionData> const& instruction ) {
															#line 661 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	return Future<Void>(new CallActor9(data, instruction));
															#line 7641 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
}

#line 677 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
};
const char* GetEstimatedRangeSize::name = "GET_ESTIMATED_RANGE_SIZE";
REGISTER_INSTRUCTION_FUNC(GetEstimatedRangeSize);

struct GetRangeSplitPoints : InstructionFunc {
	static const char* name;

																#line 7652 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
// This generated class is to be used only via call()
															#line 684 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
template <class CallActor10>
															#line 684 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
class CallActor10State {
															#line 7658 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
public:
															#line 684 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	CallActor10State(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 684 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
															#line 684 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		 : data(data),
															#line 684 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		   instruction(instruction),
															#line 685 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		   items(data->stack.pop(3))
															#line 7669 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
	{
		fdb_probe_actor_create("call", reinterpret_cast<unsigned long>(this));

	}
	~CallActor10State() 
	{
		fdb_probe_actor_destroy("call", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 686 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (items.size() != 3)
															#line 7684 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			{
															#line 687 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
				if (!static_cast<CallActor10*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor10State(); static_cast<CallActor10*>(this)->destroy(); return 0; }
															#line 7688 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
				new (&static_cast<CallActor10*>(this)->SAV< Void >::value()) Void(Void());
				this->~CallActor10State();
				static_cast<CallActor10*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 689 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			StrictFuture<Standalone<StringRef>> __when_expr_0 = items[0].value;
															#line 689 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (static_cast<CallActor10*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7698 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CallActor10*>(this)->actor_wait_state = 1;
															#line 689 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CallActor10, 0, Standalone<StringRef> >*>(static_cast<CallActor10*>(this)));
															#line 7703 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CallActor10State();
		static_cast<CallActor10*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Standalone<StringRef> const& s1,int loopDepth) 
	{
															#line 690 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		beginKey = Tuple::unpack(s1).getString(0);
															#line 692 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		StrictFuture<Standalone<StringRef>> __when_expr_1 = items[1].value;
															#line 692 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (static_cast<CallActor10*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7730 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CallActor10*>(this)->actor_wait_state = 2;
															#line 692 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CallActor10, 1, Standalone<StringRef> >*>(static_cast<CallActor10*>(this)));
															#line 7735 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Standalone<StringRef> && s1,int loopDepth) 
	{
															#line 690 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		beginKey = Tuple::unpack(s1).getString(0);
															#line 692 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		StrictFuture<Standalone<StringRef>> __when_expr_1 = items[1].value;
															#line 692 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (static_cast<CallActor10*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7748 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CallActor10*>(this)->actor_wait_state = 2;
															#line 692 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CallActor10, 1, Standalone<StringRef> >*>(static_cast<CallActor10*>(this)));
															#line 7753 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Standalone<StringRef> const& s1,int loopDepth) 
	{
		loopDepth = a_body1cont1(s1, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Standalone<StringRef> && s1,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(s1), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CallActor10*>(this)->actor_wait_state > 0) static_cast<CallActor10*>(this)->actor_wait_state = 0;
		static_cast<CallActor10*>(this)->ActorCallback< CallActor10, 0, Standalone<StringRef> >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor10, 0, Standalone<StringRef> >*,Standalone<StringRef> const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor10*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CallActor10, 0, Standalone<StringRef> >*,Standalone<StringRef> && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor10*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CallActor10, 0, Standalone<StringRef> >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor10*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(Standalone<StringRef> const& s2,int loopDepth) 
	{
															#line 693 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		endKey = Tuple::unpack(s2).getString(0);
															#line 695 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		StrictFuture<Standalone<StringRef>> __when_expr_2 = items[2].value;
															#line 695 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (static_cast<CallActor10*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7841 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<CallActor10*>(this)->actor_wait_state = 3;
															#line 695 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CallActor10, 2, Standalone<StringRef> >*>(static_cast<CallActor10*>(this)));
															#line 7846 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Standalone<StringRef> && s2,int loopDepth) 
	{
															#line 693 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		endKey = Tuple::unpack(s2).getString(0);
															#line 695 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		StrictFuture<Standalone<StringRef>> __when_expr_2 = items[2].value;
															#line 695 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (static_cast<CallActor10*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7859 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<CallActor10*>(this)->actor_wait_state = 3;
															#line 695 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CallActor10, 2, Standalone<StringRef> >*>(static_cast<CallActor10*>(this)));
															#line 7864 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Standalone<StringRef> const& s2,int loopDepth) 
	{
		loopDepth = a_body1cont3(s2, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Standalone<StringRef> && s2,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(s2), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CallActor10*>(this)->actor_wait_state > 0) static_cast<CallActor10*>(this)->actor_wait_state = 0;
		static_cast<CallActor10*>(this)->ActorCallback< CallActor10, 1, Standalone<StringRef> >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor10, 1, Standalone<StringRef> >*,Standalone<StringRef> const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor10*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CallActor10, 1, Standalone<StringRef> >*,Standalone<StringRef> && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor10*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CallActor10, 1, Standalone<StringRef> >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor10*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(Standalone<StringRef> const& s3,int loopDepth) 
	{
															#line 696 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		chunkSize = Tuple::unpack(s3).getInt(0);
															#line 698 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		Future<FDBStandalone<VectorRef<KeyRef>>> fsplitPoints = instruction->tr->getRangeSplitPoints(KeyRangeRef(beginKey, endKey), chunkSize);
															#line 700 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		StrictFuture<FDBStandalone<VectorRef<KeyRef>>> __when_expr_3 = fsplitPoints;
															#line 700 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (static_cast<CallActor10*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7954 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont4when1(__when_expr_3.get(), loopDepth); };
		static_cast<CallActor10*>(this)->actor_wait_state = 4;
															#line 700 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CallActor10, 3, FDBStandalone<VectorRef<KeyRef>> >*>(static_cast<CallActor10*>(this)));
															#line 7959 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(Standalone<StringRef> && s3,int loopDepth) 
	{
															#line 696 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		chunkSize = Tuple::unpack(s3).getInt(0);
															#line 698 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		Future<FDBStandalone<VectorRef<KeyRef>>> fsplitPoints = instruction->tr->getRangeSplitPoints(KeyRangeRef(beginKey, endKey), chunkSize);
															#line 700 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		StrictFuture<FDBStandalone<VectorRef<KeyRef>>> __when_expr_3 = fsplitPoints;
															#line 700 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (static_cast<CallActor10*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7974 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont4when1(__when_expr_3.get(), loopDepth); };
		static_cast<CallActor10*>(this)->actor_wait_state = 4;
															#line 700 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CallActor10, 3, FDBStandalone<VectorRef<KeyRef>> >*>(static_cast<CallActor10*>(this)));
															#line 7979 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3when1(Standalone<StringRef> const& s3,int loopDepth) 
	{
		loopDepth = a_body1cont4(s3, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Standalone<StringRef> && s3,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(s3), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CallActor10*>(this)->actor_wait_state > 0) static_cast<CallActor10*>(this)->actor_wait_state = 0;
		static_cast<CallActor10*>(this)->ActorCallback< CallActor10, 2, Standalone<StringRef> >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor10, 2, Standalone<StringRef> >*,Standalone<StringRef> const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor10*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CallActor10, 2, Standalone<StringRef> >*,Standalone<StringRef> && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor10*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CallActor10, 2, Standalone<StringRef> >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor10*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont5(FDBStandalone<VectorRef<KeyRef>> const& splitPoints,int loopDepth) 
	{
															#line 701 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		data->stack.pushTuple("GOT_RANGE_SPLIT_POINTS"_sr);
															#line 703 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (!static_cast<CallActor10*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor10State(); static_cast<CallActor10*>(this)->destroy(); return 0; }
															#line 8065 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		new (&static_cast<CallActor10*>(this)->SAV< Void >::value()) Void(Void());
		this->~CallActor10State();
		static_cast<CallActor10*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5(FDBStandalone<VectorRef<KeyRef>> && splitPoints,int loopDepth) 
	{
															#line 701 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		data->stack.pushTuple("GOT_RANGE_SPLIT_POINTS"_sr);
															#line 703 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (!static_cast<CallActor10*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor10State(); static_cast<CallActor10*>(this)->destroy(); return 0; }
															#line 8079 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		new (&static_cast<CallActor10*>(this)->SAV< Void >::value()) Void(Void());
		this->~CallActor10State();
		static_cast<CallActor10*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4when1(FDBStandalone<VectorRef<KeyRef>> const& splitPoints,int loopDepth) 
	{
		loopDepth = a_body1cont5(splitPoints, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(FDBStandalone<VectorRef<KeyRef>> && splitPoints,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(splitPoints), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<CallActor10*>(this)->actor_wait_state > 0) static_cast<CallActor10*>(this)->actor_wait_state = 0;
		static_cast<CallActor10*>(this)->ActorCallback< CallActor10, 3, FDBStandalone<VectorRef<KeyRef>> >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor10, 3, FDBStandalone<VectorRef<KeyRef>> >*,FDBStandalone<VectorRef<KeyRef>> const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor10*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< CallActor10, 3, FDBStandalone<VectorRef<KeyRef>> >*,FDBStandalone<VectorRef<KeyRef>> && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor10*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< CallActor10, 3, FDBStandalone<VectorRef<KeyRef>> >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor10*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 684 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Reference<FlowTesterData> data;
															#line 684 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Reference<InstructionData> instruction;
															#line 685 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	std::vector<StackItem> items;
															#line 690 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Standalone<StringRef> beginKey;
															#line 693 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Standalone<StringRef> endKey;
															#line 696 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	int64_t chunkSize;
															#line 8174 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
};
// This generated class is to be used only via call()
															#line 684 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
class CallActor10 final : public Actor<Void>, public ActorCallback< CallActor10, 0, Standalone<StringRef> >, public ActorCallback< CallActor10, 1, Standalone<StringRef> >, public ActorCallback< CallActor10, 2, Standalone<StringRef> >, public ActorCallback< CallActor10, 3, FDBStandalone<VectorRef<KeyRef>> >, public FastAllocated<CallActor10>, public CallActor10State<CallActor10> {
															#line 8179 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
public:
	using FastAllocated<CallActor10>::operator new;
	using FastAllocated<CallActor10>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9317237842190798848UL, 4308047855804869376UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CallActor10, 0, Standalone<StringRef> >;
friend struct ActorCallback< CallActor10, 1, Standalone<StringRef> >;
friend struct ActorCallback< CallActor10, 2, Standalone<StringRef> >;
friend struct ActorCallback< CallActor10, 3, FDBStandalone<VectorRef<KeyRef>> >;
															#line 684 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	CallActor10(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 8199 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		 : Actor<Void>(),
		   CallActor10State<CallActor10>(data, instruction),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3522948110971150336UL, 7853058901089034240UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor10*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("call");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CallActor10, 0, Standalone<StringRef> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CallActor10, 1, Standalone<StringRef> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CallActor10, 2, Standalone<StringRef> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< CallActor10, 3, FDBStandalone<VectorRef<KeyRef>> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 684 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
[[nodiscard]] static Future<Void> call( Reference<FlowTesterData> const& data, Reference<InstructionData> const& instruction ) {
															#line 684 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	return Future<Void>(new CallActor10(data, instruction));
															#line 8234 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
}

#line 705 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
};
const char* GetRangeSplitPoints::name = "GET_RANGE_SPLIT_POINTS";
REGISTER_INSTRUCTION_FUNC(GetRangeSplitPoints);

struct GetKeyFunc : InstructionFunc {
	static const char* name;

																#line 8245 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
// This generated class is to be used only via call()
															#line 712 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
template <class CallActor11>
															#line 712 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
class CallActor11State {
															#line 8251 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
public:
															#line 712 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	CallActor11State(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 712 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
															#line 712 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		 : data(data),
															#line 712 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		   instruction(instruction),
															#line 713 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		   items(data->stack.pop(4))
															#line 8262 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
	{
		fdb_probe_actor_create("call", reinterpret_cast<unsigned long>(this));

	}
	~CallActor11State() 
	{
		fdb_probe_actor_destroy("call", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 714 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (items.size() != 4)
															#line 8277 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			{
															#line 715 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
				if (!static_cast<CallActor11*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor11State(); static_cast<CallActor11*>(this)->destroy(); return 0; }
															#line 8281 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
				new (&static_cast<CallActor11*>(this)->SAV< Void >::value()) Void(Void());
				this->~CallActor11State();
				static_cast<CallActor11*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 717 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			StrictFuture<Standalone<StringRef>> __when_expr_0 = items[0].value;
															#line 717 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (static_cast<CallActor11*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8291 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CallActor11*>(this)->actor_wait_state = 1;
															#line 717 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CallActor11, 0, Standalone<StringRef> >*>(static_cast<CallActor11*>(this)));
															#line 8296 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CallActor11State();
		static_cast<CallActor11*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Standalone<StringRef> const& s1,int loopDepth) 
	{
															#line 718 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		key = Tuple::unpack(s1).getString(0);
															#line 720 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		StrictFuture<Standalone<StringRef>> __when_expr_1 = items[1].value;
															#line 720 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (static_cast<CallActor11*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8323 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CallActor11*>(this)->actor_wait_state = 2;
															#line 720 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CallActor11, 1, Standalone<StringRef> >*>(static_cast<CallActor11*>(this)));
															#line 8328 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Standalone<StringRef> && s1,int loopDepth) 
	{
															#line 718 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		key = Tuple::unpack(s1).getString(0);
															#line 720 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		StrictFuture<Standalone<StringRef>> __when_expr_1 = items[1].value;
															#line 720 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (static_cast<CallActor11*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8341 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CallActor11*>(this)->actor_wait_state = 2;
															#line 720 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CallActor11, 1, Standalone<StringRef> >*>(static_cast<CallActor11*>(this)));
															#line 8346 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Standalone<StringRef> const& s1,int loopDepth) 
	{
		loopDepth = a_body1cont1(s1, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Standalone<StringRef> && s1,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(s1), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CallActor11*>(this)->actor_wait_state > 0) static_cast<CallActor11*>(this)->actor_wait_state = 0;
		static_cast<CallActor11*>(this)->ActorCallback< CallActor11, 0, Standalone<StringRef> >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor11, 0, Standalone<StringRef> >*,Standalone<StringRef> const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor11*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CallActor11, 0, Standalone<StringRef> >*,Standalone<StringRef> && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor11*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CallActor11, 0, Standalone<StringRef> >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor11*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(Standalone<StringRef> const& s2,int loopDepth) 
	{
															#line 721 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		or_equal = Tuple::unpack(s2).getInt(0);
															#line 723 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		StrictFuture<Standalone<StringRef>> __when_expr_2 = items[2].value;
															#line 723 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (static_cast<CallActor11*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8434 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<CallActor11*>(this)->actor_wait_state = 3;
															#line 723 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CallActor11, 2, Standalone<StringRef> >*>(static_cast<CallActor11*>(this)));
															#line 8439 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Standalone<StringRef> && s2,int loopDepth) 
	{
															#line 721 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		or_equal = Tuple::unpack(s2).getInt(0);
															#line 723 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		StrictFuture<Standalone<StringRef>> __when_expr_2 = items[2].value;
															#line 723 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (static_cast<CallActor11*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8452 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<CallActor11*>(this)->actor_wait_state = 3;
															#line 723 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CallActor11, 2, Standalone<StringRef> >*>(static_cast<CallActor11*>(this)));
															#line 8457 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Standalone<StringRef> const& s2,int loopDepth) 
	{
		loopDepth = a_body1cont3(s2, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Standalone<StringRef> && s2,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(s2), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CallActor11*>(this)->actor_wait_state > 0) static_cast<CallActor11*>(this)->actor_wait_state = 0;
		static_cast<CallActor11*>(this)->ActorCallback< CallActor11, 1, Standalone<StringRef> >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor11, 1, Standalone<StringRef> >*,Standalone<StringRef> const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor11*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CallActor11, 1, Standalone<StringRef> >*,Standalone<StringRef> && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor11*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CallActor11, 1, Standalone<StringRef> >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor11*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(Standalone<StringRef> const& s3,int loopDepth) 
	{
															#line 724 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		offset = Tuple::unpack(s3).getInt(0);
															#line 726 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		StrictFuture<Standalone<StringRef>> __when_expr_3 = items[3].value;
															#line 726 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (static_cast<CallActor11*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8545 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont4when1(__when_expr_3.get(), loopDepth); };
		static_cast<CallActor11*>(this)->actor_wait_state = 4;
															#line 726 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CallActor11, 3, Standalone<StringRef> >*>(static_cast<CallActor11*>(this)));
															#line 8550 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(Standalone<StringRef> && s3,int loopDepth) 
	{
															#line 724 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		offset = Tuple::unpack(s3).getInt(0);
															#line 726 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		StrictFuture<Standalone<StringRef>> __when_expr_3 = items[3].value;
															#line 726 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (static_cast<CallActor11*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8563 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont4when1(__when_expr_3.get(), loopDepth); };
		static_cast<CallActor11*>(this)->actor_wait_state = 4;
															#line 726 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CallActor11, 3, Standalone<StringRef> >*>(static_cast<CallActor11*>(this)));
															#line 8568 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3when1(Standalone<StringRef> const& s3,int loopDepth) 
	{
		loopDepth = a_body1cont4(s3, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Standalone<StringRef> && s3,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(s3), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CallActor11*>(this)->actor_wait_state > 0) static_cast<CallActor11*>(this)->actor_wait_state = 0;
		static_cast<CallActor11*>(this)->ActorCallback< CallActor11, 2, Standalone<StringRef> >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor11, 2, Standalone<StringRef> >*,Standalone<StringRef> const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor11*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CallActor11, 2, Standalone<StringRef> >*,Standalone<StringRef> && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor11*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CallActor11, 2, Standalone<StringRef> >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor11*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont5(Standalone<StringRef> const& s4,int loopDepth) 
	{
															#line 727 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		Standalone<StringRef> prefix = Tuple::unpack(s4).getString(0);
															#line 730 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		Future<FDBStandalone<KeyRef>> fk = instruction->tr->getKey(KeySelector(KeySelectorRef(key, or_equal, offset)), instruction->isSnapshot);
															#line 732 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		data->stack.push(getKey(holdWhile(instruction->tr, fk), prefix));
															#line 734 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (!static_cast<CallActor11*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor11State(); static_cast<CallActor11*>(this)->destroy(); return 0; }
															#line 8658 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		new (&static_cast<CallActor11*>(this)->SAV< Void >::value()) Void(Void());
		this->~CallActor11State();
		static_cast<CallActor11*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5(Standalone<StringRef> && s4,int loopDepth) 
	{
															#line 727 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		Standalone<StringRef> prefix = Tuple::unpack(s4).getString(0);
															#line 730 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		Future<FDBStandalone<KeyRef>> fk = instruction->tr->getKey(KeySelector(KeySelectorRef(key, or_equal, offset)), instruction->isSnapshot);
															#line 732 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		data->stack.push(getKey(holdWhile(instruction->tr, fk), prefix));
															#line 734 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (!static_cast<CallActor11*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor11State(); static_cast<CallActor11*>(this)->destroy(); return 0; }
															#line 8676 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		new (&static_cast<CallActor11*>(this)->SAV< Void >::value()) Void(Void());
		this->~CallActor11State();
		static_cast<CallActor11*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4when1(Standalone<StringRef> const& s4,int loopDepth) 
	{
		loopDepth = a_body1cont5(s4, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Standalone<StringRef> && s4,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(s4), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<CallActor11*>(this)->actor_wait_state > 0) static_cast<CallActor11*>(this)->actor_wait_state = 0;
		static_cast<CallActor11*>(this)->ActorCallback< CallActor11, 3, Standalone<StringRef> >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor11, 3, Standalone<StringRef> >*,Standalone<StringRef> const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor11*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< CallActor11, 3, Standalone<StringRef> >*,Standalone<StringRef> && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor11*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< CallActor11, 3, Standalone<StringRef> >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor11*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 712 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Reference<FlowTesterData> data;
															#line 712 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Reference<InstructionData> instruction;
															#line 713 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	std::vector<StackItem> items;
															#line 718 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Standalone<StringRef> key;
															#line 721 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	int64_t or_equal;
															#line 724 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	int64_t offset;
															#line 8771 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
};
// This generated class is to be used only via call()
															#line 712 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
class CallActor11 final : public Actor<Void>, public ActorCallback< CallActor11, 0, Standalone<StringRef> >, public ActorCallback< CallActor11, 1, Standalone<StringRef> >, public ActorCallback< CallActor11, 2, Standalone<StringRef> >, public ActorCallback< CallActor11, 3, Standalone<StringRef> >, public FastAllocated<CallActor11>, public CallActor11State<CallActor11> {
															#line 8776 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
public:
	using FastAllocated<CallActor11>::operator new;
	using FastAllocated<CallActor11>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9317237842190798848UL, 4308047855804869376UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CallActor11, 0, Standalone<StringRef> >;
friend struct ActorCallback< CallActor11, 1, Standalone<StringRef> >;
friend struct ActorCallback< CallActor11, 2, Standalone<StringRef> >;
friend struct ActorCallback< CallActor11, 3, Standalone<StringRef> >;
															#line 712 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	CallActor11(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 8796 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		 : Actor<Void>(),
		   CallActor11State<CallActor11>(data, instruction),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6696347954121557504UL, 1612576802491870464UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor11*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("call");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CallActor11, 0, Standalone<StringRef> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CallActor11, 1, Standalone<StringRef> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CallActor11, 2, Standalone<StringRef> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< CallActor11, 3, Standalone<StringRef> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 712 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
[[nodiscard]] static Future<Void> call( Reference<FlowTesterData> const& data, Reference<InstructionData> const& instruction ) {
															#line 712 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	return Future<Void>(new CallActor11(data, instruction));
															#line 8831 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
}

#line 736 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
};
const char* GetKeyFunc::name = "GET_KEY";
REGISTER_INSTRUCTION_FUNC(GetKeyFunc);

struct GetReadVersionFunc : InstructionFunc {
	static const char* name;

																#line 8842 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
// This generated class is to be used only via call()
															#line 743 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
template <class CallActor12>
															#line 743 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
class CallActor12State {
															#line 8848 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
public:
															#line 743 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	CallActor12State(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 743 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
															#line 743 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		 : data(data),
															#line 743 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		   instruction(instruction)
															#line 8857 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
	{
		fdb_probe_actor_create("call", reinterpret_cast<unsigned long>(this));

	}
	~CallActor12State() 
	{
		fdb_probe_actor_destroy("call", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 744 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			StrictFuture<Version> __when_expr_0 = instruction->tr->getReadVersion();
															#line 744 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (static_cast<CallActor12*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8874 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CallActor12*>(this)->actor_wait_state = 1;
															#line 744 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CallActor12, 0, Version >*>(static_cast<CallActor12*>(this)));
															#line 8879 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CallActor12State();
		static_cast<CallActor12*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Version const& v,int loopDepth) 
	{
															#line 745 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		data->lastVersion = v;
															#line 746 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		data->stack.pushTuple("GOT_READ_VERSION"_sr);
															#line 747 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (!static_cast<CallActor12*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor12State(); static_cast<CallActor12*>(this)->destroy(); return 0; }
															#line 8906 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		new (&static_cast<CallActor12*>(this)->SAV< Void >::value()) Void(Void());
		this->~CallActor12State();
		static_cast<CallActor12*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Version && v,int loopDepth) 
	{
															#line 745 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		data->lastVersion = v;
															#line 746 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		data->stack.pushTuple("GOT_READ_VERSION"_sr);
															#line 747 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (!static_cast<CallActor12*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor12State(); static_cast<CallActor12*>(this)->destroy(); return 0; }
															#line 8922 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		new (&static_cast<CallActor12*>(this)->SAV< Void >::value()) Void(Void());
		this->~CallActor12State();
		static_cast<CallActor12*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Version const& v,int loopDepth) 
	{
		loopDepth = a_body1cont1(v, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Version && v,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(v), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CallActor12*>(this)->actor_wait_state > 0) static_cast<CallActor12*>(this)->actor_wait_state = 0;
		static_cast<CallActor12*>(this)->ActorCallback< CallActor12, 0, Version >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor12, 0, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor12*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CallActor12, 0, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor12*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CallActor12, 0, Version >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor12*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 743 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Reference<FlowTesterData> data;
															#line 743 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Reference<InstructionData> instruction;
															#line 9009 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
};
// This generated class is to be used only via call()
															#line 743 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
class CallActor12 final : public Actor<Void>, public ActorCallback< CallActor12, 0, Version >, public FastAllocated<CallActor12>, public CallActor12State<CallActor12> {
															#line 9014 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
public:
	using FastAllocated<CallActor12>::operator new;
	using FastAllocated<CallActor12>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9317237842190798848UL, 4308047855804869376UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CallActor12, 0, Version >;
															#line 743 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	CallActor12(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 9031 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		 : Actor<Void>(),
		   CallActor12State<CallActor12>(data, instruction),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17568513329667169024UL, 4132702070643368960UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor12*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("call");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CallActor12, 0, Version >*)0, actor_cancelled()); break;
		}

	}
};
															#line 743 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
[[nodiscard]] static Future<Void> call( Reference<FlowTesterData> const& data, Reference<InstructionData> const& instruction ) {
															#line 743 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	return Future<Void>(new CallActor12(data, instruction));
															#line 9063 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
}

#line 749 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
};
const char* GetReadVersionFunc::name = "GET_READ_VERSION";
REGISTER_INSTRUCTION_FUNC(GetReadVersionFunc);

struct SetReadVersionFunc : InstructionFunc {
	static const char* name;

	static Future<Void> call(Reference<FlowTesterData> const& data, Reference<InstructionData> const& instruction) {
		instruction->tr->setReadVersion(data->lastVersion);
		return Void();
	}
};
const char* SetReadVersionFunc::name = "SET_READ_VERSION";
REGISTER_INSTRUCTION_FUNC(SetReadVersionFunc);

// GET_COMMITTED_VERSION
struct GetCommittedVersionFunc : InstructionFunc {
	static const char* name;

	static Future<Void> call(Reference<FlowTesterData> const& data, Reference<InstructionData> const& instruction) {
		data->lastVersion = instruction->tr->getCommittedVersion();
		data->stack.pushTuple("GOT_COMMITTED_VERSION"_sr);
		return Void();
	}
};
const char* GetCommittedVersionFunc::name = "GET_COMMITTED_VERSION";
REGISTER_INSTRUCTION_FUNC(GetCommittedVersionFunc);

// GET_APPROXIMATE_SIZE
struct GetApproximateSizeFunc : InstructionFunc {
	static const char* name;

																#line 9099 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
// This generated class is to be used only via call()
															#line 781 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
template <class CallActor13>
															#line 781 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
class CallActor13State {
															#line 9105 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
public:
															#line 781 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	CallActor13State(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 781 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
															#line 781 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		 : data(data),
															#line 781 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		   instruction(instruction)
															#line 9114 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
	{
		fdb_probe_actor_create("call", reinterpret_cast<unsigned long>(this));

	}
	~CallActor13State() 
	{
		fdb_probe_actor_destroy("call", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 782 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			StrictFuture<int64_t> __when_expr_0 = instruction->tr->getApproximateSize();
															#line 782 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (static_cast<CallActor13*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9131 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CallActor13*>(this)->actor_wait_state = 1;
															#line 782 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CallActor13, 0, int64_t >*>(static_cast<CallActor13*>(this)));
															#line 9136 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CallActor13State();
		static_cast<CallActor13*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int64_t const& _,int loopDepth) 
	{
															#line 783 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		(void)_;
															#line 784 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		data->stack.pushTuple("GOT_APPROXIMATE_SIZE"_sr);
															#line 785 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (!static_cast<CallActor13*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor13State(); static_cast<CallActor13*>(this)->destroy(); return 0; }
															#line 9163 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		new (&static_cast<CallActor13*>(this)->SAV< Void >::value()) Void(Void());
		this->~CallActor13State();
		static_cast<CallActor13*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(int64_t && _,int loopDepth) 
	{
															#line 783 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		(void)_;
															#line 784 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		data->stack.pushTuple("GOT_APPROXIMATE_SIZE"_sr);
															#line 785 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (!static_cast<CallActor13*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor13State(); static_cast<CallActor13*>(this)->destroy(); return 0; }
															#line 9179 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		new (&static_cast<CallActor13*>(this)->SAV< Void >::value()) Void(Void());
		this->~CallActor13State();
		static_cast<CallActor13*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(int64_t const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(int64_t && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CallActor13*>(this)->actor_wait_state > 0) static_cast<CallActor13*>(this)->actor_wait_state = 0;
		static_cast<CallActor13*>(this)->ActorCallback< CallActor13, 0, int64_t >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor13, 0, int64_t >*,int64_t const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor13*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CallActor13, 0, int64_t >*,int64_t && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor13*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CallActor13, 0, int64_t >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor13*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 781 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Reference<FlowTesterData> data;
															#line 781 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Reference<InstructionData> instruction;
															#line 9266 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
};
// This generated class is to be used only via call()
															#line 781 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
class CallActor13 final : public Actor<Void>, public ActorCallback< CallActor13, 0, int64_t >, public FastAllocated<CallActor13>, public CallActor13State<CallActor13> {
															#line 9271 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
public:
	using FastAllocated<CallActor13>::operator new;
	using FastAllocated<CallActor13>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9317237842190798848UL, 4308047855804869376UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CallActor13, 0, int64_t >;
															#line 781 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	CallActor13(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 9288 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		 : Actor<Void>(),
		   CallActor13State<CallActor13>(data, instruction),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11142119912061252096UL, 1170081608514710272UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor13*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("call");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CallActor13, 0, int64_t >*)0, actor_cancelled()); break;
		}

	}
};
															#line 781 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
[[nodiscard]] static Future<Void> call( Reference<FlowTesterData> const& data, Reference<InstructionData> const& instruction ) {
															#line 781 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	return Future<Void>(new CallActor13(data, instruction));
															#line 9320 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
}

#line 787 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
};
const char* GetApproximateSizeFunc::name = "GET_APPROXIMATE_SIZE";
REGISTER_INSTRUCTION_FUNC(GetApproximateSizeFunc);

// GET_VERSIONSTAMP
struct GetVersionstampFunc : InstructionFunc {
	static const char* name;

	static Future<Void> call(Reference<FlowTesterData> const& data, Reference<InstructionData> const& instruction) {
		data->stack.push(waitForValue(instruction->tr->getVersionstamp()));
		return Void();
	}
};
const char* GetVersionstampFunc::name = "GET_VERSIONSTAMP";
REGISTER_INSTRUCTION_FUNC(GetVersionstampFunc);

// COMMIT
struct CommitFunc : InstructionFunc {
	static const char* name;

	static Future<Void> call(Reference<FlowTesterData> const& data, Reference<InstructionData> const& instruction) {
		data->stack.push(waitForVoid(holdWhile(instruction->tr, instruction->tr->commit())));
		return Void();
	}
};
const char* CommitFunc::name = "COMMIT";
REGISTER_INSTRUCTION_FUNC(CommitFunc);

// WAIT_FUTURE
struct WaitFutureFunc : InstructionFunc {
	static const char* name;

																#line 9356 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
// This generated class is to be used only via call()
															#line 819 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
template <class CallActor14>
															#line 819 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
class CallActor14State {
															#line 9362 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
public:
															#line 819 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	CallActor14State(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 819 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
															#line 819 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		 : data(data),
															#line 819 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		   instruction(instruction),
															#line 820 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		   items(data->stack.pop())
															#line 9373 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
	{
		fdb_probe_actor_create("call", reinterpret_cast<unsigned long>(this));

	}
	~CallActor14State() 
	{
		fdb_probe_actor_destroy("call", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 821 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (items.size() != 1)
															#line 9388 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			{
															#line 822 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
				if (!static_cast<CallActor14*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor14State(); static_cast<CallActor14*>(this)->destroy(); return 0; }
															#line 9392 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
				new (&static_cast<CallActor14*>(this)->SAV< Void >::value()) Void(Void());
				this->~CallActor14State();
				static_cast<CallActor14*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 824 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			StrictFuture<Standalone<StringRef>> __when_expr_0 = items[0].value;
															#line 824 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (static_cast<CallActor14*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9402 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CallActor14*>(this)->actor_wait_state = 1;
															#line 824 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CallActor14, 0, Standalone<StringRef> >*>(static_cast<CallActor14*>(this)));
															#line 9407 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CallActor14State();
		static_cast<CallActor14*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Standalone<StringRef> const& sk,int loopDepth) 
	{
															#line 825 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		data->stack.push(StackItem(items[0].index, sk));
															#line 826 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (!static_cast<CallActor14*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor14State(); static_cast<CallActor14*>(this)->destroy(); return 0; }
															#line 9432 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		new (&static_cast<CallActor14*>(this)->SAV< Void >::value()) Void(Void());
		this->~CallActor14State();
		static_cast<CallActor14*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Standalone<StringRef> && sk,int loopDepth) 
	{
															#line 825 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		data->stack.push(StackItem(items[0].index, sk));
															#line 826 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (!static_cast<CallActor14*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor14State(); static_cast<CallActor14*>(this)->destroy(); return 0; }
															#line 9446 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		new (&static_cast<CallActor14*>(this)->SAV< Void >::value()) Void(Void());
		this->~CallActor14State();
		static_cast<CallActor14*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Standalone<StringRef> const& sk,int loopDepth) 
	{
		loopDepth = a_body1cont1(sk, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Standalone<StringRef> && sk,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(sk), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CallActor14*>(this)->actor_wait_state > 0) static_cast<CallActor14*>(this)->actor_wait_state = 0;
		static_cast<CallActor14*>(this)->ActorCallback< CallActor14, 0, Standalone<StringRef> >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor14, 0, Standalone<StringRef> >*,Standalone<StringRef> const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor14*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CallActor14, 0, Standalone<StringRef> >*,Standalone<StringRef> && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor14*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CallActor14, 0, Standalone<StringRef> >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor14*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 819 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Reference<FlowTesterData> data;
															#line 819 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Reference<InstructionData> instruction;
															#line 820 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	std::vector<StackItem> items;
															#line 9535 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
};
// This generated class is to be used only via call()
															#line 819 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
class CallActor14 final : public Actor<Void>, public ActorCallback< CallActor14, 0, Standalone<StringRef> >, public FastAllocated<CallActor14>, public CallActor14State<CallActor14> {
															#line 9540 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
public:
	using FastAllocated<CallActor14>::operator new;
	using FastAllocated<CallActor14>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9317237842190798848UL, 4308047855804869376UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CallActor14, 0, Standalone<StringRef> >;
															#line 819 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	CallActor14(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 9557 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		 : Actor<Void>(),
		   CallActor14State<CallActor14>(data, instruction),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9789270765737524736UL, 5353044720919876096UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor14*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("call");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CallActor14, 0, Standalone<StringRef> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 819 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
[[nodiscard]] static Future<Void> call( Reference<FlowTesterData> const& data, Reference<InstructionData> const& instruction ) {
															#line 819 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	return Future<Void>(new CallActor14(data, instruction));
															#line 9589 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
}

#line 828 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
};
const char* WaitFutureFunc::name = "WAIT_FUTURE";
REGISTER_INSTRUCTION_FUNC(WaitFutureFunc);

// CLEAR
struct ClearFunc : InstructionFunc {
	static const char* name;

																#line 9601 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
// This generated class is to be used only via call()
															#line 836 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
template <class CallActor15>
															#line 836 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
class CallActor15State {
															#line 9607 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
public:
															#line 836 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	CallActor15State(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 836 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
															#line 836 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		 : data(data),
															#line 836 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		   instruction(instruction),
															#line 837 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		   items(data->stack.pop())
															#line 9618 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
	{
		fdb_probe_actor_create("call", reinterpret_cast<unsigned long>(this));

	}
	~CallActor15State() 
	{
		fdb_probe_actor_destroy("call", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 838 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (items.size() != 1)
															#line 9633 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			{
															#line 839 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
				if (!static_cast<CallActor15*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor15State(); static_cast<CallActor15*>(this)->destroy(); return 0; }
															#line 9637 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
				new (&static_cast<CallActor15*>(this)->SAV< Void >::value()) Void(Void());
				this->~CallActor15State();
				static_cast<CallActor15*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 841 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			StrictFuture<Standalone<StringRef>> __when_expr_0 = items[0].value;
															#line 841 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (static_cast<CallActor15*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9647 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CallActor15*>(this)->actor_wait_state = 1;
															#line 841 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CallActor15, 0, Standalone<StringRef> >*>(static_cast<CallActor15*>(this)));
															#line 9652 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CallActor15State();
		static_cast<CallActor15*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Standalone<StringRef> const& sk,int loopDepth) 
	{
															#line 842 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		Standalone<StringRef> key = Tuple::unpack(sk).getString(0);
															#line 844 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		Reference<InstructionData> instructionCopy = instruction;
															#line 846 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		Future<Void> mutation = executeMutation(instruction, [instructionCopy, key]() -> Future<Void> { instructionCopy->tr->clear(key); return Void(); });
															#line 851 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (instruction->isDatabase)
															#line 9681 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		{
															#line 852 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			data->stack.push(waitForVoid(mutation));
															#line 9685 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			loopDepth = a_body1cont3(loopDepth);
		}
		else
		{
															#line 854 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			StrictFuture<Void> __when_expr_1 = mutation;
															#line 854 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (static_cast<CallActor15*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9694 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<CallActor15*>(this)->actor_wait_state = 2;
															#line 854 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CallActor15, 1, Void >*>(static_cast<CallActor15*>(this)));
															#line 9699 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont1(Standalone<StringRef> && sk,int loopDepth) 
	{
															#line 842 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		Standalone<StringRef> key = Tuple::unpack(sk).getString(0);
															#line 844 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		Reference<InstructionData> instructionCopy = instruction;
															#line 846 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		Future<Void> mutation = executeMutation(instruction, [instructionCopy, key]() -> Future<Void> { instructionCopy->tr->clear(key); return Void(); });
															#line 851 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (instruction->isDatabase)
															#line 9715 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		{
															#line 852 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			data->stack.push(waitForVoid(mutation));
															#line 9719 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			loopDepth = a_body1cont3(loopDepth);
		}
		else
		{
															#line 854 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			StrictFuture<Void> __when_expr_1 = mutation;
															#line 854 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (static_cast<CallActor15*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9728 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<CallActor15*>(this)->actor_wait_state = 2;
															#line 854 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CallActor15, 1, Void >*>(static_cast<CallActor15*>(this)));
															#line 9733 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1when1(Standalone<StringRef> const& sk,int loopDepth) 
	{
		loopDepth = a_body1cont1(sk, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Standalone<StringRef> && sk,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(sk), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CallActor15*>(this)->actor_wait_state > 0) static_cast<CallActor15*>(this)->actor_wait_state = 0;
		static_cast<CallActor15*>(this)->ActorCallback< CallActor15, 0, Standalone<StringRef> >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor15, 0, Standalone<StringRef> >*,Standalone<StringRef> const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor15*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CallActor15, 0, Standalone<StringRef> >*,Standalone<StringRef> && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor15*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CallActor15, 0, Standalone<StringRef> >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor15*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 857 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (!static_cast<CallActor15*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor15State(); static_cast<CallActor15*>(this)->destroy(); return 0; }
															#line 9818 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		new (&static_cast<CallActor15*>(this)->SAV< Void >::value()) Void(Void());
		this->~CallActor15State();
		static_cast<CallActor15*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CallActor15*>(this)->actor_wait_state > 0) static_cast<CallActor15*>(this)->actor_wait_state = 0;
		static_cast<CallActor15*>(this)->ActorCallback< CallActor15, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor15, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor15*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CallActor15, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor15*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CallActor15, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor15*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 836 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Reference<FlowTesterData> data;
															#line 836 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Reference<InstructionData> instruction;
															#line 837 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	std::vector<StackItem> items;
															#line 9919 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
};
// This generated class is to be used only via call()
															#line 836 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
class CallActor15 final : public Actor<Void>, public ActorCallback< CallActor15, 0, Standalone<StringRef> >, public ActorCallback< CallActor15, 1, Void >, public FastAllocated<CallActor15>, public CallActor15State<CallActor15> {
															#line 9924 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
public:
	using FastAllocated<CallActor15>::operator new;
	using FastAllocated<CallActor15>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9317237842190798848UL, 4308047855804869376UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CallActor15, 0, Standalone<StringRef> >;
friend struct ActorCallback< CallActor15, 1, Void >;
															#line 836 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	CallActor15(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 9942 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		 : Actor<Void>(),
		   CallActor15State<CallActor15>(data, instruction),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1001577460772027136UL, 5007029484457101568UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor15*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("call");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CallActor15, 0, Standalone<StringRef> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CallActor15, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 836 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
[[nodiscard]] static Future<Void> call( Reference<FlowTesterData> const& data, Reference<InstructionData> const& instruction ) {
															#line 836 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	return Future<Void>(new CallActor15(data, instruction));
															#line 9975 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
}

#line 859 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
};
const char* ClearFunc::name = "CLEAR";
REGISTER_INSTRUCTION_FUNC(ClearFunc);

// RESET
struct ResetFunc : InstructionFunc {
	static const char* name;

	static Future<Void> call(Reference<FlowTesterData> const& data, Reference<InstructionData> const& instruction) {
		instruction->tr->reset();
		return Void();
	}
};
const char* ResetFunc::name = "RESET";
REGISTER_INSTRUCTION_FUNC(ResetFunc);

// CANCEL
struct CancelFunc : InstructionFunc {
	static const char* name;

	static Future<Void> call(Reference<FlowTesterData> const& data, Reference<InstructionData> const& instruction) {
		instruction->tr->cancel();
		return Void();
	}
};
const char* CancelFunc::name = "CANCEL";
REGISTER_INSTRUCTION_FUNC(CancelFunc);

struct GetRangeFunc : InstructionFunc {
	static const char* name;

																#line 10010 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
// This generated class is to be used only via call()
															#line 890 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
template <class CallActor16>
															#line 890 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
class CallActor16State {
															#line 10016 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
public:
															#line 890 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	CallActor16State(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 890 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
															#line 890 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		 : data(data),
															#line 890 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		   instruction(instruction),
															#line 891 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		   items(data->stack.pop(5))
															#line 10027 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
	{
		fdb_probe_actor_create("call", reinterpret_cast<unsigned long>(this));

	}
	~CallActor16State() 
	{
		fdb_probe_actor_destroy("call", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 892 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (items.size() != 5)
															#line 10042 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			{
															#line 893 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
				if (!static_cast<CallActor16*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor16State(); static_cast<CallActor16*>(this)->destroy(); return 0; }
															#line 10046 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
				new (&static_cast<CallActor16*>(this)->SAV< Void >::value()) Void(Void());
				this->~CallActor16State();
				static_cast<CallActor16*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 895 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			StrictFuture<Standalone<StringRef>> __when_expr_0 = items[0].value;
															#line 895 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (static_cast<CallActor16*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10056 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CallActor16*>(this)->actor_wait_state = 1;
															#line 895 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CallActor16, 0, Standalone<StringRef> >*>(static_cast<CallActor16*>(this)));
															#line 10061 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CallActor16State();
		static_cast<CallActor16*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Standalone<StringRef> const& s1,int loopDepth) 
	{
															#line 896 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		begin = Tuple::unpack(s1).getString(0);
															#line 898 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		StrictFuture<Standalone<StringRef>> __when_expr_1 = items[1].value;
															#line 898 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (static_cast<CallActor16*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10088 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CallActor16*>(this)->actor_wait_state = 2;
															#line 898 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CallActor16, 1, Standalone<StringRef> >*>(static_cast<CallActor16*>(this)));
															#line 10093 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Standalone<StringRef> && s1,int loopDepth) 
	{
															#line 896 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		begin = Tuple::unpack(s1).getString(0);
															#line 898 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		StrictFuture<Standalone<StringRef>> __when_expr_1 = items[1].value;
															#line 898 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (static_cast<CallActor16*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10106 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CallActor16*>(this)->actor_wait_state = 2;
															#line 898 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CallActor16, 1, Standalone<StringRef> >*>(static_cast<CallActor16*>(this)));
															#line 10111 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Standalone<StringRef> const& s1,int loopDepth) 
	{
		loopDepth = a_body1cont1(s1, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Standalone<StringRef> && s1,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(s1), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CallActor16*>(this)->actor_wait_state > 0) static_cast<CallActor16*>(this)->actor_wait_state = 0;
		static_cast<CallActor16*>(this)->ActorCallback< CallActor16, 0, Standalone<StringRef> >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor16, 0, Standalone<StringRef> >*,Standalone<StringRef> const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor16*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CallActor16, 0, Standalone<StringRef> >*,Standalone<StringRef> && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor16*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CallActor16, 0, Standalone<StringRef> >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor16*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(Standalone<StringRef> const& s2,int loopDepth) 
	{
															#line 899 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		end = Tuple::unpack(s2).getString(0);
															#line 901 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		StrictFuture<Standalone<StringRef>> __when_expr_2 = items[2].value;
															#line 901 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (static_cast<CallActor16*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10199 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<CallActor16*>(this)->actor_wait_state = 3;
															#line 901 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CallActor16, 2, Standalone<StringRef> >*>(static_cast<CallActor16*>(this)));
															#line 10204 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Standalone<StringRef> && s2,int loopDepth) 
	{
															#line 899 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		end = Tuple::unpack(s2).getString(0);
															#line 901 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		StrictFuture<Standalone<StringRef>> __when_expr_2 = items[2].value;
															#line 901 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (static_cast<CallActor16*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10217 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<CallActor16*>(this)->actor_wait_state = 3;
															#line 901 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CallActor16, 2, Standalone<StringRef> >*>(static_cast<CallActor16*>(this)));
															#line 10222 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Standalone<StringRef> const& s2,int loopDepth) 
	{
		loopDepth = a_body1cont3(s2, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Standalone<StringRef> && s2,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(s2), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CallActor16*>(this)->actor_wait_state > 0) static_cast<CallActor16*>(this)->actor_wait_state = 0;
		static_cast<CallActor16*>(this)->ActorCallback< CallActor16, 1, Standalone<StringRef> >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor16, 1, Standalone<StringRef> >*,Standalone<StringRef> const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor16*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CallActor16, 1, Standalone<StringRef> >*,Standalone<StringRef> && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor16*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CallActor16, 1, Standalone<StringRef> >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor16*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(Standalone<StringRef> const& s3,int loopDepth) 
	{
															#line 902 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		limit = Tuple::unpack(s3).getInt(0);
															#line 904 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		StrictFuture<Standalone<StringRef>> __when_expr_3 = items[3].value;
															#line 904 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (static_cast<CallActor16*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10310 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont4when1(__when_expr_3.get(), loopDepth); };
		static_cast<CallActor16*>(this)->actor_wait_state = 4;
															#line 904 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CallActor16, 3, Standalone<StringRef> >*>(static_cast<CallActor16*>(this)));
															#line 10315 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(Standalone<StringRef> && s3,int loopDepth) 
	{
															#line 902 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		limit = Tuple::unpack(s3).getInt(0);
															#line 904 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		StrictFuture<Standalone<StringRef>> __when_expr_3 = items[3].value;
															#line 904 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (static_cast<CallActor16*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10328 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont4when1(__when_expr_3.get(), loopDepth); };
		static_cast<CallActor16*>(this)->actor_wait_state = 4;
															#line 904 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CallActor16, 3, Standalone<StringRef> >*>(static_cast<CallActor16*>(this)));
															#line 10333 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3when1(Standalone<StringRef> const& s3,int loopDepth) 
	{
		loopDepth = a_body1cont4(s3, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Standalone<StringRef> && s3,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(s3), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CallActor16*>(this)->actor_wait_state > 0) static_cast<CallActor16*>(this)->actor_wait_state = 0;
		static_cast<CallActor16*>(this)->ActorCallback< CallActor16, 2, Standalone<StringRef> >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor16, 2, Standalone<StringRef> >*,Standalone<StringRef> const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor16*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CallActor16, 2, Standalone<StringRef> >*,Standalone<StringRef> && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor16*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CallActor16, 2, Standalone<StringRef> >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor16*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont5(Standalone<StringRef> const& s4,int loopDepth) 
	{
															#line 905 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		reverse = Tuple::unpack(s4).getInt(0);
															#line 907 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		StrictFuture<Standalone<StringRef>> __when_expr_4 = items[4].value;
															#line 907 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (static_cast<CallActor16*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10421 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont5when1(__when_expr_4.get(), loopDepth); };
		static_cast<CallActor16*>(this)->actor_wait_state = 5;
															#line 907 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< CallActor16, 4, Standalone<StringRef> >*>(static_cast<CallActor16*>(this)));
															#line 10426 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5(Standalone<StringRef> && s4,int loopDepth) 
	{
															#line 905 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		reverse = Tuple::unpack(s4).getInt(0);
															#line 907 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		StrictFuture<Standalone<StringRef>> __when_expr_4 = items[4].value;
															#line 907 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (static_cast<CallActor16*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10439 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont5when1(__when_expr_4.get(), loopDepth); };
		static_cast<CallActor16*>(this)->actor_wait_state = 5;
															#line 907 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< CallActor16, 4, Standalone<StringRef> >*>(static_cast<CallActor16*>(this)));
															#line 10444 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4when1(Standalone<StringRef> const& s4,int loopDepth) 
	{
		loopDepth = a_body1cont5(s4, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Standalone<StringRef> && s4,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(s4), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<CallActor16*>(this)->actor_wait_state > 0) static_cast<CallActor16*>(this)->actor_wait_state = 0;
		static_cast<CallActor16*>(this)->ActorCallback< CallActor16, 3, Standalone<StringRef> >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor16, 3, Standalone<StringRef> >*,Standalone<StringRef> const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor16*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< CallActor16, 3, Standalone<StringRef> >*,Standalone<StringRef> && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor16*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< CallActor16, 3, Standalone<StringRef> >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor16*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont6(Standalone<StringRef> const& s5,int loopDepth) 
	{
															#line 908 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		FDBStreamingMode mode = (FDBStreamingMode)Tuple::unpack(s5).getInt(0);
															#line 913 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		StrictFuture<Standalone<RangeResultRef>> __when_expr_5 = getRange(instruction->tr, KeyRange(KeyRangeRef(begin, end > begin ? end : begin)), limit, instruction->isSnapshot, reverse, mode);
															#line 913 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (static_cast<CallActor16*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10532 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont6when1(__when_expr_5.get(), loopDepth); };
		static_cast<CallActor16*>(this)->actor_wait_state = 6;
															#line 913 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< CallActor16, 5, Standalone<RangeResultRef> >*>(static_cast<CallActor16*>(this)));
															#line 10537 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6(Standalone<StringRef> && s5,int loopDepth) 
	{
															#line 908 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		FDBStreamingMode mode = (FDBStreamingMode)Tuple::unpack(s5).getInt(0);
															#line 913 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		StrictFuture<Standalone<RangeResultRef>> __when_expr_5 = getRange(instruction->tr, KeyRange(KeyRangeRef(begin, end > begin ? end : begin)), limit, instruction->isSnapshot, reverse, mode);
															#line 913 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (static_cast<CallActor16*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10550 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont6when1(__when_expr_5.get(), loopDepth); };
		static_cast<CallActor16*>(this)->actor_wait_state = 6;
															#line 913 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< CallActor16, 5, Standalone<RangeResultRef> >*>(static_cast<CallActor16*>(this)));
															#line 10555 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5when1(Standalone<StringRef> const& s5,int loopDepth) 
	{
		loopDepth = a_body1cont6(s5, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Standalone<StringRef> && s5,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(s5), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<CallActor16*>(this)->actor_wait_state > 0) static_cast<CallActor16*>(this)->actor_wait_state = 0;
		static_cast<CallActor16*>(this)->ActorCallback< CallActor16, 4, Standalone<StringRef> >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor16, 4, Standalone<StringRef> >*,Standalone<StringRef> const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor16*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< CallActor16, 4, Standalone<StringRef> >*,Standalone<StringRef> && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor16*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< CallActor16, 4, Standalone<StringRef> >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor16*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont7(Standalone<RangeResultRef> const& results,int loopDepth) 
	{
															#line 919 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		Tuple t;
															#line 920 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		for( auto& s : results ) {
															#line 921 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			t.append(s.key);
															#line 922 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			t.append(s.value);
															#line 10645 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		}
															#line 928 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		data->stack.push(Tuple().append(t.pack()).pack());
															#line 929 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (!static_cast<CallActor16*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor16State(); static_cast<CallActor16*>(this)->destroy(); return 0; }
															#line 10651 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		new (&static_cast<CallActor16*>(this)->SAV< Void >::value()) Void(Void());
		this->~CallActor16State();
		static_cast<CallActor16*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont7(Standalone<RangeResultRef> && results,int loopDepth) 
	{
															#line 919 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		Tuple t;
															#line 920 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		for( auto& s : results ) {
															#line 921 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			t.append(s.key);
															#line 922 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			t.append(s.value);
															#line 10669 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		}
															#line 928 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		data->stack.push(Tuple().append(t.pack()).pack());
															#line 929 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (!static_cast<CallActor16*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor16State(); static_cast<CallActor16*>(this)->destroy(); return 0; }
															#line 10675 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		new (&static_cast<CallActor16*>(this)->SAV< Void >::value()) Void(Void());
		this->~CallActor16State();
		static_cast<CallActor16*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont6when1(Standalone<RangeResultRef> const& results,int loopDepth) 
	{
		loopDepth = a_body1cont7(results, loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Standalone<RangeResultRef> && results,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(results), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<CallActor16*>(this)->actor_wait_state > 0) static_cast<CallActor16*>(this)->actor_wait_state = 0;
		static_cast<CallActor16*>(this)->ActorCallback< CallActor16, 5, Standalone<RangeResultRef> >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor16, 5, Standalone<RangeResultRef> >*,Standalone<RangeResultRef> const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor16*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< CallActor16, 5, Standalone<RangeResultRef> >*,Standalone<RangeResultRef> && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor16*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< CallActor16, 5, Standalone<RangeResultRef> >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor16*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 5);

	}
															#line 890 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Reference<FlowTesterData> data;
															#line 890 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Reference<InstructionData> instruction;
															#line 891 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	std::vector<StackItem> items;
															#line 896 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Standalone<StringRef> begin;
															#line 899 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Standalone<StringRef> end;
															#line 902 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	int limit;
															#line 905 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	int reverse;
															#line 10772 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
};
// This generated class is to be used only via call()
															#line 890 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
class CallActor16 final : public Actor<Void>, public ActorCallback< CallActor16, 0, Standalone<StringRef> >, public ActorCallback< CallActor16, 1, Standalone<StringRef> >, public ActorCallback< CallActor16, 2, Standalone<StringRef> >, public ActorCallback< CallActor16, 3, Standalone<StringRef> >, public ActorCallback< CallActor16, 4, Standalone<StringRef> >, public ActorCallback< CallActor16, 5, Standalone<RangeResultRef> >, public FastAllocated<CallActor16>, public CallActor16State<CallActor16> {
															#line 10777 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
public:
	using FastAllocated<CallActor16>::operator new;
	using FastAllocated<CallActor16>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9317237842190798848UL, 4308047855804869376UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CallActor16, 0, Standalone<StringRef> >;
friend struct ActorCallback< CallActor16, 1, Standalone<StringRef> >;
friend struct ActorCallback< CallActor16, 2, Standalone<StringRef> >;
friend struct ActorCallback< CallActor16, 3, Standalone<StringRef> >;
friend struct ActorCallback< CallActor16, 4, Standalone<StringRef> >;
friend struct ActorCallback< CallActor16, 5, Standalone<RangeResultRef> >;
															#line 890 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	CallActor16(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 10799 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		 : Actor<Void>(),
		   CallActor16State<CallActor16>(data, instruction),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10377893681063907840UL, 14239149758808705280UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor16*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("call");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CallActor16, 0, Standalone<StringRef> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CallActor16, 1, Standalone<StringRef> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CallActor16, 2, Standalone<StringRef> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< CallActor16, 3, Standalone<StringRef> >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< CallActor16, 4, Standalone<StringRef> >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< CallActor16, 5, Standalone<RangeResultRef> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 890 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
[[nodiscard]] static Future<Void> call( Reference<FlowTesterData> const& data, Reference<InstructionData> const& instruction ) {
															#line 890 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	return Future<Void>(new CallActor16(data, instruction));
															#line 10836 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
}

#line 931 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
};
const char* GetRangeFunc::name = "GET_RANGE";
REGISTER_INSTRUCTION_FUNC(GetRangeFunc);

struct GetRangeStartsWithFunc : InstructionFunc {
	static const char* name;

																#line 10847 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
// This generated class is to be used only via call()
															#line 938 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
template <class CallActor17>
															#line 938 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
class CallActor17State {
															#line 10853 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
public:
															#line 938 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	CallActor17State(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 938 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
															#line 938 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		 : data(data),
															#line 938 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		   instruction(instruction),
															#line 939 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		   items(data->stack.pop(4))
															#line 10864 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
	{
		fdb_probe_actor_create("call", reinterpret_cast<unsigned long>(this));

	}
	~CallActor17State() 
	{
		fdb_probe_actor_destroy("call", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 940 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (items.size() != 4)
															#line 10879 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			{
															#line 941 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
				if (!static_cast<CallActor17*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor17State(); static_cast<CallActor17*>(this)->destroy(); return 0; }
															#line 10883 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
				new (&static_cast<CallActor17*>(this)->SAV< Void >::value()) Void(Void());
				this->~CallActor17State();
				static_cast<CallActor17*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 943 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			StrictFuture<Standalone<StringRef>> __when_expr_0 = items[0].value;
															#line 943 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (static_cast<CallActor17*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10893 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CallActor17*>(this)->actor_wait_state = 1;
															#line 943 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CallActor17, 0, Standalone<StringRef> >*>(static_cast<CallActor17*>(this)));
															#line 10898 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CallActor17State();
		static_cast<CallActor17*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Standalone<StringRef> const& s1,int loopDepth) 
	{
															#line 944 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		prefix = Tuple::unpack(s1).getString(0);
															#line 946 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		StrictFuture<Standalone<StringRef>> __when_expr_1 = items[1].value;
															#line 946 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (static_cast<CallActor17*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10925 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CallActor17*>(this)->actor_wait_state = 2;
															#line 946 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CallActor17, 1, Standalone<StringRef> >*>(static_cast<CallActor17*>(this)));
															#line 10930 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Standalone<StringRef> && s1,int loopDepth) 
	{
															#line 944 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		prefix = Tuple::unpack(s1).getString(0);
															#line 946 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		StrictFuture<Standalone<StringRef>> __when_expr_1 = items[1].value;
															#line 946 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (static_cast<CallActor17*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10943 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CallActor17*>(this)->actor_wait_state = 2;
															#line 946 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CallActor17, 1, Standalone<StringRef> >*>(static_cast<CallActor17*>(this)));
															#line 10948 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Standalone<StringRef> const& s1,int loopDepth) 
	{
		loopDepth = a_body1cont1(s1, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Standalone<StringRef> && s1,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(s1), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CallActor17*>(this)->actor_wait_state > 0) static_cast<CallActor17*>(this)->actor_wait_state = 0;
		static_cast<CallActor17*>(this)->ActorCallback< CallActor17, 0, Standalone<StringRef> >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor17, 0, Standalone<StringRef> >*,Standalone<StringRef> const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor17*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CallActor17, 0, Standalone<StringRef> >*,Standalone<StringRef> && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor17*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CallActor17, 0, Standalone<StringRef> >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor17*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(Standalone<StringRef> const& s2,int loopDepth) 
	{
															#line 947 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		limit = Tuple::unpack(s2).getInt(0);
															#line 949 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		StrictFuture<Standalone<StringRef>> __when_expr_2 = items[2].value;
															#line 949 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (static_cast<CallActor17*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11036 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<CallActor17*>(this)->actor_wait_state = 3;
															#line 949 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CallActor17, 2, Standalone<StringRef> >*>(static_cast<CallActor17*>(this)));
															#line 11041 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Standalone<StringRef> && s2,int loopDepth) 
	{
															#line 947 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		limit = Tuple::unpack(s2).getInt(0);
															#line 949 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		StrictFuture<Standalone<StringRef>> __when_expr_2 = items[2].value;
															#line 949 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (static_cast<CallActor17*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11054 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<CallActor17*>(this)->actor_wait_state = 3;
															#line 949 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CallActor17, 2, Standalone<StringRef> >*>(static_cast<CallActor17*>(this)));
															#line 11059 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Standalone<StringRef> const& s2,int loopDepth) 
	{
		loopDepth = a_body1cont3(s2, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Standalone<StringRef> && s2,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(s2), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CallActor17*>(this)->actor_wait_state > 0) static_cast<CallActor17*>(this)->actor_wait_state = 0;
		static_cast<CallActor17*>(this)->ActorCallback< CallActor17, 1, Standalone<StringRef> >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor17, 1, Standalone<StringRef> >*,Standalone<StringRef> const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor17*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CallActor17, 1, Standalone<StringRef> >*,Standalone<StringRef> && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor17*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CallActor17, 1, Standalone<StringRef> >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor17*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(Standalone<StringRef> const& s3,int loopDepth) 
	{
															#line 950 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		reverse = Tuple::unpack(s3).getInt(0);
															#line 952 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		StrictFuture<Standalone<StringRef>> __when_expr_3 = items[3].value;
															#line 952 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (static_cast<CallActor17*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11147 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont4when1(__when_expr_3.get(), loopDepth); };
		static_cast<CallActor17*>(this)->actor_wait_state = 4;
															#line 952 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CallActor17, 3, Standalone<StringRef> >*>(static_cast<CallActor17*>(this)));
															#line 11152 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(Standalone<StringRef> && s3,int loopDepth) 
	{
															#line 950 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		reverse = Tuple::unpack(s3).getInt(0);
															#line 952 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		StrictFuture<Standalone<StringRef>> __when_expr_3 = items[3].value;
															#line 952 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (static_cast<CallActor17*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11165 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont4when1(__when_expr_3.get(), loopDepth); };
		static_cast<CallActor17*>(this)->actor_wait_state = 4;
															#line 952 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CallActor17, 3, Standalone<StringRef> >*>(static_cast<CallActor17*>(this)));
															#line 11170 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3when1(Standalone<StringRef> const& s3,int loopDepth) 
	{
		loopDepth = a_body1cont4(s3, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Standalone<StringRef> && s3,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(s3), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CallActor17*>(this)->actor_wait_state > 0) static_cast<CallActor17*>(this)->actor_wait_state = 0;
		static_cast<CallActor17*>(this)->ActorCallback< CallActor17, 2, Standalone<StringRef> >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor17, 2, Standalone<StringRef> >*,Standalone<StringRef> const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor17*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CallActor17, 2, Standalone<StringRef> >*,Standalone<StringRef> && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor17*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CallActor17, 2, Standalone<StringRef> >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor17*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont5(Standalone<StringRef> const& s4,int loopDepth) 
	{
															#line 953 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		FDBStreamingMode mode = (FDBStreamingMode)Tuple::unpack(s4).getInt(0);
															#line 957 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		StrictFuture<Standalone<RangeResultRef>> __when_expr_4 = getRange(instruction->tr, KeyRange(KeyRangeRef(prefix, strinc(prefix))), limit, instruction->isSnapshot, reverse, mode);
															#line 957 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (static_cast<CallActor17*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11258 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont5when1(__when_expr_4.get(), loopDepth); };
		static_cast<CallActor17*>(this)->actor_wait_state = 5;
															#line 957 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< CallActor17, 4, Standalone<RangeResultRef> >*>(static_cast<CallActor17*>(this)));
															#line 11263 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5(Standalone<StringRef> && s4,int loopDepth) 
	{
															#line 953 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		FDBStreamingMode mode = (FDBStreamingMode)Tuple::unpack(s4).getInt(0);
															#line 957 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		StrictFuture<Standalone<RangeResultRef>> __when_expr_4 = getRange(instruction->tr, KeyRange(KeyRangeRef(prefix, strinc(prefix))), limit, instruction->isSnapshot, reverse, mode);
															#line 957 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (static_cast<CallActor17*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11276 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont5when1(__when_expr_4.get(), loopDepth); };
		static_cast<CallActor17*>(this)->actor_wait_state = 5;
															#line 957 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< CallActor17, 4, Standalone<RangeResultRef> >*>(static_cast<CallActor17*>(this)));
															#line 11281 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4when1(Standalone<StringRef> const& s4,int loopDepth) 
	{
		loopDepth = a_body1cont5(s4, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Standalone<StringRef> && s4,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(s4), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<CallActor17*>(this)->actor_wait_state > 0) static_cast<CallActor17*>(this)->actor_wait_state = 0;
		static_cast<CallActor17*>(this)->ActorCallback< CallActor17, 3, Standalone<StringRef> >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor17, 3, Standalone<StringRef> >*,Standalone<StringRef> const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor17*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< CallActor17, 3, Standalone<StringRef> >*,Standalone<StringRef> && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor17*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< CallActor17, 3, Standalone<StringRef> >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor17*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont6(Standalone<RangeResultRef> const& results,int loopDepth) 
	{
															#line 963 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		Tuple t;
															#line 965 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		for( auto& s : results ) {
															#line 966 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			t.append(s.key);
															#line 967 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			t.append(s.value);
															#line 11371 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		}
															#line 972 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		data->stack.push(Tuple().append(t.pack()).pack());
															#line 973 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (!static_cast<CallActor17*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor17State(); static_cast<CallActor17*>(this)->destroy(); return 0; }
															#line 11377 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		new (&static_cast<CallActor17*>(this)->SAV< Void >::value()) Void(Void());
		this->~CallActor17State();
		static_cast<CallActor17*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont6(Standalone<RangeResultRef> && results,int loopDepth) 
	{
															#line 963 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		Tuple t;
															#line 965 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		for( auto& s : results ) {
															#line 966 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			t.append(s.key);
															#line 967 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			t.append(s.value);
															#line 11395 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		}
															#line 972 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		data->stack.push(Tuple().append(t.pack()).pack());
															#line 973 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (!static_cast<CallActor17*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor17State(); static_cast<CallActor17*>(this)->destroy(); return 0; }
															#line 11401 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		new (&static_cast<CallActor17*>(this)->SAV< Void >::value()) Void(Void());
		this->~CallActor17State();
		static_cast<CallActor17*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5when1(Standalone<RangeResultRef> const& results,int loopDepth) 
	{
		loopDepth = a_body1cont6(results, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Standalone<RangeResultRef> && results,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(results), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<CallActor17*>(this)->actor_wait_state > 0) static_cast<CallActor17*>(this)->actor_wait_state = 0;
		static_cast<CallActor17*>(this)->ActorCallback< CallActor17, 4, Standalone<RangeResultRef> >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor17, 4, Standalone<RangeResultRef> >*,Standalone<RangeResultRef> const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor17*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< CallActor17, 4, Standalone<RangeResultRef> >*,Standalone<RangeResultRef> && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor17*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< CallActor17, 4, Standalone<RangeResultRef> >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor17*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 938 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Reference<FlowTesterData> data;
															#line 938 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Reference<InstructionData> instruction;
															#line 939 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	std::vector<StackItem> items;
															#line 944 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Standalone<StringRef> prefix;
															#line 947 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	int limit;
															#line 950 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	int reverse;
															#line 11496 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
};
// This generated class is to be used only via call()
															#line 938 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
class CallActor17 final : public Actor<Void>, public ActorCallback< CallActor17, 0, Standalone<StringRef> >, public ActorCallback< CallActor17, 1, Standalone<StringRef> >, public ActorCallback< CallActor17, 2, Standalone<StringRef> >, public ActorCallback< CallActor17, 3, Standalone<StringRef> >, public ActorCallback< CallActor17, 4, Standalone<RangeResultRef> >, public FastAllocated<CallActor17>, public CallActor17State<CallActor17> {
															#line 11501 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
public:
	using FastAllocated<CallActor17>::operator new;
	using FastAllocated<CallActor17>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9317237842190798848UL, 4308047855804869376UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CallActor17, 0, Standalone<StringRef> >;
friend struct ActorCallback< CallActor17, 1, Standalone<StringRef> >;
friend struct ActorCallback< CallActor17, 2, Standalone<StringRef> >;
friend struct ActorCallback< CallActor17, 3, Standalone<StringRef> >;
friend struct ActorCallback< CallActor17, 4, Standalone<RangeResultRef> >;
															#line 938 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	CallActor17(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 11522 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		 : Actor<Void>(),
		   CallActor17State<CallActor17>(data, instruction),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14162605372392254464UL, 17481129796109892096UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor17*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("call");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CallActor17, 0, Standalone<StringRef> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CallActor17, 1, Standalone<StringRef> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CallActor17, 2, Standalone<StringRef> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< CallActor17, 3, Standalone<StringRef> >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< CallActor17, 4, Standalone<RangeResultRef> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 938 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
[[nodiscard]] static Future<Void> call( Reference<FlowTesterData> const& data, Reference<InstructionData> const& instruction ) {
															#line 938 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	return Future<Void>(new CallActor17(data, instruction));
															#line 11558 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
}

#line 975 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
};
const char* GetRangeStartsWithFunc::name = "GET_RANGE_STARTS_WITH";
REGISTER_INSTRUCTION_FUNC(GetRangeStartsWithFunc);

struct ClearRangeFunc : InstructionFunc {
	static const char* name;

																#line 11569 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
// This generated class is to be used only via call()
															#line 982 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
template <class CallActor18>
															#line 982 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
class CallActor18State {
															#line 11575 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
public:
															#line 982 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	CallActor18State(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 982 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
															#line 982 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		 : data(data),
															#line 982 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		   instruction(instruction),
															#line 983 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		   items(data->stack.pop(2))
															#line 11586 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
	{
		fdb_probe_actor_create("call", reinterpret_cast<unsigned long>(this));

	}
	~CallActor18State() 
	{
		fdb_probe_actor_destroy("call", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 984 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (items.size() != 2)
															#line 11601 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			{
															#line 985 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
				if (!static_cast<CallActor18*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor18State(); static_cast<CallActor18*>(this)->destroy(); return 0; }
															#line 11605 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
				new (&static_cast<CallActor18*>(this)->SAV< Void >::value()) Void(Void());
				this->~CallActor18State();
				static_cast<CallActor18*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 987 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			StrictFuture<Standalone<StringRef>> __when_expr_0 = items[0].value;
															#line 987 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (static_cast<CallActor18*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11615 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CallActor18*>(this)->actor_wait_state = 1;
															#line 987 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CallActor18, 0, Standalone<StringRef> >*>(static_cast<CallActor18*>(this)));
															#line 11620 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CallActor18State();
		static_cast<CallActor18*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Standalone<StringRef> const& s1,int loopDepth) 
	{
															#line 988 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		begin = Tuple::unpack(s1).getString(0);
															#line 990 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		StrictFuture<Standalone<StringRef>> __when_expr_1 = items[1].value;
															#line 990 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (static_cast<CallActor18*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11647 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CallActor18*>(this)->actor_wait_state = 2;
															#line 990 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CallActor18, 1, Standalone<StringRef> >*>(static_cast<CallActor18*>(this)));
															#line 11652 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Standalone<StringRef> && s1,int loopDepth) 
	{
															#line 988 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		begin = Tuple::unpack(s1).getString(0);
															#line 990 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		StrictFuture<Standalone<StringRef>> __when_expr_1 = items[1].value;
															#line 990 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (static_cast<CallActor18*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11665 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CallActor18*>(this)->actor_wait_state = 2;
															#line 990 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CallActor18, 1, Standalone<StringRef> >*>(static_cast<CallActor18*>(this)));
															#line 11670 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Standalone<StringRef> const& s1,int loopDepth) 
	{
		loopDepth = a_body1cont1(s1, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Standalone<StringRef> && s1,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(s1), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CallActor18*>(this)->actor_wait_state > 0) static_cast<CallActor18*>(this)->actor_wait_state = 0;
		static_cast<CallActor18*>(this)->ActorCallback< CallActor18, 0, Standalone<StringRef> >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor18, 0, Standalone<StringRef> >*,Standalone<StringRef> const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor18*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CallActor18, 0, Standalone<StringRef> >*,Standalone<StringRef> && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor18*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CallActor18, 0, Standalone<StringRef> >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor18*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(Standalone<StringRef> const& s2,int loopDepth) 
	{
															#line 991 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		Standalone<StringRef> end = Tuple::unpack(s2).getString(0);
															#line 993 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		Reference<InstructionData> instructionCopy = instruction;
															#line 994 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		Standalone<StringRef> beginCopy = begin;
															#line 996 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		Future<Void> mutation = executeMutation(instruction, [instructionCopy, beginCopy, end]() -> Future<Void> { instructionCopy->tr->clear(KeyRangeRef(beginCopy, end)); return Void(); });
															#line 1001 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (instruction->isDatabase)
															#line 11762 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		{
															#line 1002 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			data->stack.push(waitForVoid(mutation));
															#line 11766 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			loopDepth = a_body1cont4(loopDepth);
		}
		else
		{
															#line 1004 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			StrictFuture<Void> __when_expr_2 = mutation;
															#line 1004 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (static_cast<CallActor18*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11775 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
			static_cast<CallActor18*>(this)->actor_wait_state = 3;
															#line 1004 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CallActor18, 2, Void >*>(static_cast<CallActor18*>(this)));
															#line 11780 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont3(Standalone<StringRef> && s2,int loopDepth) 
	{
															#line 991 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		Standalone<StringRef> end = Tuple::unpack(s2).getString(0);
															#line 993 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		Reference<InstructionData> instructionCopy = instruction;
															#line 994 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		Standalone<StringRef> beginCopy = begin;
															#line 996 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		Future<Void> mutation = executeMutation(instruction, [instructionCopy, beginCopy, end]() -> Future<Void> { instructionCopy->tr->clear(KeyRangeRef(beginCopy, end)); return Void(); });
															#line 1001 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (instruction->isDatabase)
															#line 11798 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		{
															#line 1002 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			data->stack.push(waitForVoid(mutation));
															#line 11802 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			loopDepth = a_body1cont4(loopDepth);
		}
		else
		{
															#line 1004 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			StrictFuture<Void> __when_expr_2 = mutation;
															#line 1004 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (static_cast<CallActor18*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11811 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
			static_cast<CallActor18*>(this)->actor_wait_state = 3;
															#line 1004 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CallActor18, 2, Void >*>(static_cast<CallActor18*>(this)));
															#line 11816 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont1when1(Standalone<StringRef> const& s2,int loopDepth) 
	{
		loopDepth = a_body1cont3(s2, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Standalone<StringRef> && s2,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(s2), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CallActor18*>(this)->actor_wait_state > 0) static_cast<CallActor18*>(this)->actor_wait_state = 0;
		static_cast<CallActor18*>(this)->ActorCallback< CallActor18, 1, Standalone<StringRef> >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor18, 1, Standalone<StringRef> >*,Standalone<StringRef> const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor18*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CallActor18, 1, Standalone<StringRef> >*,Standalone<StringRef> && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor18*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CallActor18, 1, Standalone<StringRef> >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor18*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 1007 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (!static_cast<CallActor18*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor18State(); static_cast<CallActor18*>(this)->destroy(); return 0; }
															#line 11901 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		new (&static_cast<CallActor18*>(this)->SAV< Void >::value()) Void(Void());
		this->~CallActor18State();
		static_cast<CallActor18*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CallActor18*>(this)->actor_wait_state > 0) static_cast<CallActor18*>(this)->actor_wait_state = 0;
		static_cast<CallActor18*>(this)->ActorCallback< CallActor18, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor18, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor18*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CallActor18, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor18*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CallActor18, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor18*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 982 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Reference<FlowTesterData> data;
															#line 982 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Reference<InstructionData> instruction;
															#line 983 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	std::vector<StackItem> items;
															#line 988 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Standalone<StringRef> begin;
															#line 12004 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
};
// This generated class is to be used only via call()
															#line 982 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
class CallActor18 final : public Actor<Void>, public ActorCallback< CallActor18, 0, Standalone<StringRef> >, public ActorCallback< CallActor18, 1, Standalone<StringRef> >, public ActorCallback< CallActor18, 2, Void >, public FastAllocated<CallActor18>, public CallActor18State<CallActor18> {
															#line 12009 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
public:
	using FastAllocated<CallActor18>::operator new;
	using FastAllocated<CallActor18>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9317237842190798848UL, 4308047855804869376UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CallActor18, 0, Standalone<StringRef> >;
friend struct ActorCallback< CallActor18, 1, Standalone<StringRef> >;
friend struct ActorCallback< CallActor18, 2, Void >;
															#line 982 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	CallActor18(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 12028 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		 : Actor<Void>(),
		   CallActor18State<CallActor18>(data, instruction),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12288014878387528448UL, 17479771282318694656UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor18*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("call");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CallActor18, 0, Standalone<StringRef> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CallActor18, 1, Standalone<StringRef> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CallActor18, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 982 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
[[nodiscard]] static Future<Void> call( Reference<FlowTesterData> const& data, Reference<InstructionData> const& instruction ) {
															#line 982 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	return Future<Void>(new CallActor18(data, instruction));
															#line 12062 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
}

#line 1009 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
};
const char* ClearRangeFunc::name = "CLEAR_RANGE";
REGISTER_INSTRUCTION_FUNC(ClearRangeFunc);

struct ClearRangeStartWithFunc : InstructionFunc {
	static const char* name;

																#line 12073 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
// This generated class is to be used only via call()
															#line 1016 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
template <class CallActor19>
															#line 1016 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
class CallActor19State {
															#line 12079 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
public:
															#line 1016 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	CallActor19State(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 1016 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
															#line 1016 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		 : data(data),
															#line 1016 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		   instruction(instruction),
															#line 1017 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		   items(data->stack.pop())
															#line 12090 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
	{
		fdb_probe_actor_create("call", reinterpret_cast<unsigned long>(this));

	}
	~CallActor19State() 
	{
		fdb_probe_actor_destroy("call", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1018 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (items.size() != 1)
															#line 12105 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			{
															#line 1019 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
				if (!static_cast<CallActor19*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor19State(); static_cast<CallActor19*>(this)->destroy(); return 0; }
															#line 12109 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
				new (&static_cast<CallActor19*>(this)->SAV< Void >::value()) Void(Void());
				this->~CallActor19State();
				static_cast<CallActor19*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 1021 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			StrictFuture<Standalone<StringRef>> __when_expr_0 = items[0].value;
															#line 1021 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (static_cast<CallActor19*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12119 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CallActor19*>(this)->actor_wait_state = 1;
															#line 1021 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CallActor19, 0, Standalone<StringRef> >*>(static_cast<CallActor19*>(this)));
															#line 12124 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CallActor19State();
		static_cast<CallActor19*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Standalone<StringRef> const& s1,int loopDepth) 
	{
															#line 1022 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		Standalone<StringRef> begin = Tuple::unpack(s1).getString(0);
															#line 1024 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		Reference<InstructionData> instructionCopy = instruction;
															#line 1026 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		Future<Void> mutation = executeMutation(instruction, [instructionCopy, begin]() -> Future<Void> { instructionCopy->tr->clear(KeyRangeRef(begin, strinc(begin))); return Void(); });
															#line 1031 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (instruction->isDatabase)
															#line 12153 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		{
															#line 1032 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			data->stack.push(waitForVoid(mutation));
															#line 12157 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			loopDepth = a_body1cont3(loopDepth);
		}
		else
		{
															#line 1034 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			StrictFuture<Void> __when_expr_1 = mutation;
															#line 1034 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (static_cast<CallActor19*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12166 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<CallActor19*>(this)->actor_wait_state = 2;
															#line 1034 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CallActor19, 1, Void >*>(static_cast<CallActor19*>(this)));
															#line 12171 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont1(Standalone<StringRef> && s1,int loopDepth) 
	{
															#line 1022 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		Standalone<StringRef> begin = Tuple::unpack(s1).getString(0);
															#line 1024 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		Reference<InstructionData> instructionCopy = instruction;
															#line 1026 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		Future<Void> mutation = executeMutation(instruction, [instructionCopy, begin]() -> Future<Void> { instructionCopy->tr->clear(KeyRangeRef(begin, strinc(begin))); return Void(); });
															#line 1031 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (instruction->isDatabase)
															#line 12187 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		{
															#line 1032 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			data->stack.push(waitForVoid(mutation));
															#line 12191 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			loopDepth = a_body1cont3(loopDepth);
		}
		else
		{
															#line 1034 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			StrictFuture<Void> __when_expr_1 = mutation;
															#line 1034 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (static_cast<CallActor19*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12200 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<CallActor19*>(this)->actor_wait_state = 2;
															#line 1034 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CallActor19, 1, Void >*>(static_cast<CallActor19*>(this)));
															#line 12205 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1when1(Standalone<StringRef> const& s1,int loopDepth) 
	{
		loopDepth = a_body1cont1(s1, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Standalone<StringRef> && s1,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(s1), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CallActor19*>(this)->actor_wait_state > 0) static_cast<CallActor19*>(this)->actor_wait_state = 0;
		static_cast<CallActor19*>(this)->ActorCallback< CallActor19, 0, Standalone<StringRef> >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor19, 0, Standalone<StringRef> >*,Standalone<StringRef> const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor19*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CallActor19, 0, Standalone<StringRef> >*,Standalone<StringRef> && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor19*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CallActor19, 0, Standalone<StringRef> >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor19*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 1037 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (!static_cast<CallActor19*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor19State(); static_cast<CallActor19*>(this)->destroy(); return 0; }
															#line 12290 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		new (&static_cast<CallActor19*>(this)->SAV< Void >::value()) Void(Void());
		this->~CallActor19State();
		static_cast<CallActor19*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CallActor19*>(this)->actor_wait_state > 0) static_cast<CallActor19*>(this)->actor_wait_state = 0;
		static_cast<CallActor19*>(this)->ActorCallback< CallActor19, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor19, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor19*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CallActor19, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor19*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CallActor19, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor19*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1016 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Reference<FlowTesterData> data;
															#line 1016 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Reference<InstructionData> instruction;
															#line 1017 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	std::vector<StackItem> items;
															#line 12391 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
};
// This generated class is to be used only via call()
															#line 1016 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
class CallActor19 final : public Actor<Void>, public ActorCallback< CallActor19, 0, Standalone<StringRef> >, public ActorCallback< CallActor19, 1, Void >, public FastAllocated<CallActor19>, public CallActor19State<CallActor19> {
															#line 12396 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
public:
	using FastAllocated<CallActor19>::operator new;
	using FastAllocated<CallActor19>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9317237842190798848UL, 4308047855804869376UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CallActor19, 0, Standalone<StringRef> >;
friend struct ActorCallback< CallActor19, 1, Void >;
															#line 1016 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	CallActor19(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 12414 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		 : Actor<Void>(),
		   CallActor19State<CallActor19>(data, instruction),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7745861353199056384UL, 1084195677578843392UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor19*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("call");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CallActor19, 0, Standalone<StringRef> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CallActor19, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1016 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
[[nodiscard]] static Future<Void> call( Reference<FlowTesterData> const& data, Reference<InstructionData> const& instruction ) {
															#line 1016 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	return Future<Void>(new CallActor19(data, instruction));
															#line 12447 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
}

#line 1039 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
};
const char* ClearRangeStartWithFunc::name = "CLEAR_RANGE_STARTS_WITH";
REGISTER_INSTRUCTION_FUNC(ClearRangeStartWithFunc);

struct GetRangeSelectorFunc : InstructionFunc {
	static const char* name;

																#line 12458 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
// This generated class is to be used only via call()
															#line 1046 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
template <class CallActor20>
															#line 1046 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
class CallActor20State {
															#line 12464 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
public:
															#line 1046 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	CallActor20State(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 1046 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
															#line 1046 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		 : data(data),
															#line 1046 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		   instruction(instruction),
															#line 1047 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		   items(data->stack.pop(10))
															#line 12475 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
	{
		fdb_probe_actor_create("call", reinterpret_cast<unsigned long>(this));

	}
	~CallActor20State() 
	{
		fdb_probe_actor_destroy("call", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1048 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (items.size() != 10)
															#line 12490 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			{
															#line 1049 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
				if (!static_cast<CallActor20*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor20State(); static_cast<CallActor20*>(this)->destroy(); return 0; }
															#line 12494 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
				new (&static_cast<CallActor20*>(this)->SAV< Void >::value()) Void(Void());
				this->~CallActor20State();
				static_cast<CallActor20*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 1051 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			StrictFuture<Standalone<StringRef>> __when_expr_0 = items[0].value;
															#line 1051 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (static_cast<CallActor20*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12504 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CallActor20*>(this)->actor_wait_state = 1;
															#line 1051 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CallActor20, 0, Standalone<StringRef> >*>(static_cast<CallActor20*>(this)));
															#line 12509 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CallActor20State();
		static_cast<CallActor20*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Standalone<StringRef> const& s1,int loopDepth) 
	{
															#line 1052 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		begin = Tuple::unpack(s1).getString(0);
															#line 1054 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		StrictFuture<Standalone<StringRef>> __when_expr_1 = items[1].value;
															#line 1054 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (static_cast<CallActor20*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12536 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CallActor20*>(this)->actor_wait_state = 2;
															#line 1054 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CallActor20, 1, Standalone<StringRef> >*>(static_cast<CallActor20*>(this)));
															#line 12541 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Standalone<StringRef> && s1,int loopDepth) 
	{
															#line 1052 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		begin = Tuple::unpack(s1).getString(0);
															#line 1054 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		StrictFuture<Standalone<StringRef>> __when_expr_1 = items[1].value;
															#line 1054 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (static_cast<CallActor20*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12554 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CallActor20*>(this)->actor_wait_state = 2;
															#line 1054 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CallActor20, 1, Standalone<StringRef> >*>(static_cast<CallActor20*>(this)));
															#line 12559 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Standalone<StringRef> const& s1,int loopDepth) 
	{
		loopDepth = a_body1cont1(s1, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Standalone<StringRef> && s1,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(s1), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CallActor20*>(this)->actor_wait_state > 0) static_cast<CallActor20*>(this)->actor_wait_state = 0;
		static_cast<CallActor20*>(this)->ActorCallback< CallActor20, 0, Standalone<StringRef> >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor20, 0, Standalone<StringRef> >*,Standalone<StringRef> const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor20*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CallActor20, 0, Standalone<StringRef> >*,Standalone<StringRef> && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor20*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CallActor20, 0, Standalone<StringRef> >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor20*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(Standalone<StringRef> const& s2,int loopDepth) 
	{
															#line 1055 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		begin_or_equal = Tuple::unpack(s2).getInt(0);
															#line 1057 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		StrictFuture<Standalone<StringRef>> __when_expr_2 = items[2].value;
															#line 1057 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (static_cast<CallActor20*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12647 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<CallActor20*>(this)->actor_wait_state = 3;
															#line 1057 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CallActor20, 2, Standalone<StringRef> >*>(static_cast<CallActor20*>(this)));
															#line 12652 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Standalone<StringRef> && s2,int loopDepth) 
	{
															#line 1055 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		begin_or_equal = Tuple::unpack(s2).getInt(0);
															#line 1057 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		StrictFuture<Standalone<StringRef>> __when_expr_2 = items[2].value;
															#line 1057 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (static_cast<CallActor20*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12665 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<CallActor20*>(this)->actor_wait_state = 3;
															#line 1057 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CallActor20, 2, Standalone<StringRef> >*>(static_cast<CallActor20*>(this)));
															#line 12670 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Standalone<StringRef> const& s2,int loopDepth) 
	{
		loopDepth = a_body1cont3(s2, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Standalone<StringRef> && s2,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(s2), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CallActor20*>(this)->actor_wait_state > 0) static_cast<CallActor20*>(this)->actor_wait_state = 0;
		static_cast<CallActor20*>(this)->ActorCallback< CallActor20, 1, Standalone<StringRef> >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor20, 1, Standalone<StringRef> >*,Standalone<StringRef> const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor20*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CallActor20, 1, Standalone<StringRef> >*,Standalone<StringRef> && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor20*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CallActor20, 1, Standalone<StringRef> >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor20*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(Standalone<StringRef> const& s3,int loopDepth) 
	{
															#line 1058 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		begin_offset = Tuple::unpack(s3).getInt(0);
															#line 1060 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		StrictFuture<Standalone<StringRef>> __when_expr_3 = items[3].value;
															#line 1060 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (static_cast<CallActor20*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12758 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont4when1(__when_expr_3.get(), loopDepth); };
		static_cast<CallActor20*>(this)->actor_wait_state = 4;
															#line 1060 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CallActor20, 3, Standalone<StringRef> >*>(static_cast<CallActor20*>(this)));
															#line 12763 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(Standalone<StringRef> && s3,int loopDepth) 
	{
															#line 1058 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		begin_offset = Tuple::unpack(s3).getInt(0);
															#line 1060 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		StrictFuture<Standalone<StringRef>> __when_expr_3 = items[3].value;
															#line 1060 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (static_cast<CallActor20*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12776 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont4when1(__when_expr_3.get(), loopDepth); };
		static_cast<CallActor20*>(this)->actor_wait_state = 4;
															#line 1060 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CallActor20, 3, Standalone<StringRef> >*>(static_cast<CallActor20*>(this)));
															#line 12781 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3when1(Standalone<StringRef> const& s3,int loopDepth) 
	{
		loopDepth = a_body1cont4(s3, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Standalone<StringRef> && s3,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(s3), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CallActor20*>(this)->actor_wait_state > 0) static_cast<CallActor20*>(this)->actor_wait_state = 0;
		static_cast<CallActor20*>(this)->ActorCallback< CallActor20, 2, Standalone<StringRef> >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor20, 2, Standalone<StringRef> >*,Standalone<StringRef> const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor20*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CallActor20, 2, Standalone<StringRef> >*,Standalone<StringRef> && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor20*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CallActor20, 2, Standalone<StringRef> >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor20*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont5(Standalone<StringRef> const& s4,int loopDepth) 
	{
															#line 1061 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		end = Tuple::unpack(s4).getString(0);
															#line 1063 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		StrictFuture<Standalone<StringRef>> __when_expr_4 = items[4].value;
															#line 1063 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (static_cast<CallActor20*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12869 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont5when1(__when_expr_4.get(), loopDepth); };
		static_cast<CallActor20*>(this)->actor_wait_state = 5;
															#line 1063 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< CallActor20, 4, Standalone<StringRef> >*>(static_cast<CallActor20*>(this)));
															#line 12874 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5(Standalone<StringRef> && s4,int loopDepth) 
	{
															#line 1061 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		end = Tuple::unpack(s4).getString(0);
															#line 1063 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		StrictFuture<Standalone<StringRef>> __when_expr_4 = items[4].value;
															#line 1063 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (static_cast<CallActor20*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12887 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont5when1(__when_expr_4.get(), loopDepth); };
		static_cast<CallActor20*>(this)->actor_wait_state = 5;
															#line 1063 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< CallActor20, 4, Standalone<StringRef> >*>(static_cast<CallActor20*>(this)));
															#line 12892 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4when1(Standalone<StringRef> const& s4,int loopDepth) 
	{
		loopDepth = a_body1cont5(s4, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Standalone<StringRef> && s4,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(s4), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<CallActor20*>(this)->actor_wait_state > 0) static_cast<CallActor20*>(this)->actor_wait_state = 0;
		static_cast<CallActor20*>(this)->ActorCallback< CallActor20, 3, Standalone<StringRef> >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor20, 3, Standalone<StringRef> >*,Standalone<StringRef> const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor20*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< CallActor20, 3, Standalone<StringRef> >*,Standalone<StringRef> && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor20*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< CallActor20, 3, Standalone<StringRef> >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor20*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont6(Standalone<StringRef> const& s5,int loopDepth) 
	{
															#line 1064 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		end_or_equal = Tuple::unpack(s5).getInt(0);
															#line 1066 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		StrictFuture<Standalone<StringRef>> __when_expr_5 = items[5].value;
															#line 1066 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (static_cast<CallActor20*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12980 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont6when1(__when_expr_5.get(), loopDepth); };
		static_cast<CallActor20*>(this)->actor_wait_state = 6;
															#line 1066 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< CallActor20, 5, Standalone<StringRef> >*>(static_cast<CallActor20*>(this)));
															#line 12985 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6(Standalone<StringRef> && s5,int loopDepth) 
	{
															#line 1064 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		end_or_equal = Tuple::unpack(s5).getInt(0);
															#line 1066 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		StrictFuture<Standalone<StringRef>> __when_expr_5 = items[5].value;
															#line 1066 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (static_cast<CallActor20*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12998 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont6when1(__when_expr_5.get(), loopDepth); };
		static_cast<CallActor20*>(this)->actor_wait_state = 6;
															#line 1066 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< CallActor20, 5, Standalone<StringRef> >*>(static_cast<CallActor20*>(this)));
															#line 13003 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5when1(Standalone<StringRef> const& s5,int loopDepth) 
	{
		loopDepth = a_body1cont6(s5, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Standalone<StringRef> && s5,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(s5), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<CallActor20*>(this)->actor_wait_state > 0) static_cast<CallActor20*>(this)->actor_wait_state = 0;
		static_cast<CallActor20*>(this)->ActorCallback< CallActor20, 4, Standalone<StringRef> >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor20, 4, Standalone<StringRef> >*,Standalone<StringRef> const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor20*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< CallActor20, 4, Standalone<StringRef> >*,Standalone<StringRef> && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor20*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< CallActor20, 4, Standalone<StringRef> >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor20*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont7(Standalone<StringRef> const& s6,int loopDepth) 
	{
															#line 1067 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		end_offset = Tuple::unpack(s6).getInt(0);
															#line 1069 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		StrictFuture<Standalone<StringRef>> __when_expr_6 = items[6].value;
															#line 1069 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (static_cast<CallActor20*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13091 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont7when1(__when_expr_6.get(), loopDepth); };
		static_cast<CallActor20*>(this)->actor_wait_state = 7;
															#line 1069 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< CallActor20, 6, Standalone<StringRef> >*>(static_cast<CallActor20*>(this)));
															#line 13096 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7(Standalone<StringRef> && s6,int loopDepth) 
	{
															#line 1067 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		end_offset = Tuple::unpack(s6).getInt(0);
															#line 1069 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		StrictFuture<Standalone<StringRef>> __when_expr_6 = items[6].value;
															#line 1069 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (static_cast<CallActor20*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13109 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont7when1(__when_expr_6.get(), loopDepth); };
		static_cast<CallActor20*>(this)->actor_wait_state = 7;
															#line 1069 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< CallActor20, 6, Standalone<StringRef> >*>(static_cast<CallActor20*>(this)));
															#line 13114 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6when1(Standalone<StringRef> const& s6,int loopDepth) 
	{
		loopDepth = a_body1cont7(s6, loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Standalone<StringRef> && s6,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(s6), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<CallActor20*>(this)->actor_wait_state > 0) static_cast<CallActor20*>(this)->actor_wait_state = 0;
		static_cast<CallActor20*>(this)->ActorCallback< CallActor20, 5, Standalone<StringRef> >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor20, 5, Standalone<StringRef> >*,Standalone<StringRef> const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor20*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< CallActor20, 5, Standalone<StringRef> >*,Standalone<StringRef> && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor20*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< CallActor20, 5, Standalone<StringRef> >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor20*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont8(Standalone<StringRef> const& s7,int loopDepth) 
	{
															#line 1070 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		limit = Tuple::unpack(s7).getInt(0);
															#line 1072 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		StrictFuture<Standalone<StringRef>> __when_expr_7 = items[7].value;
															#line 1072 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (static_cast<CallActor20*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13202 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont8when1(__when_expr_7.get(), loopDepth); };
		static_cast<CallActor20*>(this)->actor_wait_state = 8;
															#line 1072 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< CallActor20, 7, Standalone<StringRef> >*>(static_cast<CallActor20*>(this)));
															#line 13207 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont8(Standalone<StringRef> && s7,int loopDepth) 
	{
															#line 1070 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		limit = Tuple::unpack(s7).getInt(0);
															#line 1072 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		StrictFuture<Standalone<StringRef>> __when_expr_7 = items[7].value;
															#line 1072 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (static_cast<CallActor20*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13220 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont8when1(__when_expr_7.get(), loopDepth); };
		static_cast<CallActor20*>(this)->actor_wait_state = 8;
															#line 1072 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< CallActor20, 7, Standalone<StringRef> >*>(static_cast<CallActor20*>(this)));
															#line 13225 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7when1(Standalone<StringRef> const& s7,int loopDepth) 
	{
		loopDepth = a_body1cont8(s7, loopDepth);

		return loopDepth;
	}
	int a_body1cont7when1(Standalone<StringRef> && s7,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(s7), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<CallActor20*>(this)->actor_wait_state > 0) static_cast<CallActor20*>(this)->actor_wait_state = 0;
		static_cast<CallActor20*>(this)->ActorCallback< CallActor20, 6, Standalone<StringRef> >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor20, 6, Standalone<StringRef> >*,Standalone<StringRef> const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor20*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< CallActor20, 6, Standalone<StringRef> >*,Standalone<StringRef> && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor20*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< CallActor20, 6, Standalone<StringRef> >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor20*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont9(Standalone<StringRef> const& s8,int loopDepth) 
	{
															#line 1073 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		reverse = Tuple::unpack(s8).getInt(0);
															#line 1075 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		StrictFuture<Standalone<StringRef>> __when_expr_8 = items[8].value;
															#line 1075 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (static_cast<CallActor20*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13313 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont9when1(__when_expr_8.get(), loopDepth); };
		static_cast<CallActor20*>(this)->actor_wait_state = 9;
															#line 1075 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< CallActor20, 8, Standalone<StringRef> >*>(static_cast<CallActor20*>(this)));
															#line 13318 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont9(Standalone<StringRef> && s8,int loopDepth) 
	{
															#line 1073 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		reverse = Tuple::unpack(s8).getInt(0);
															#line 1075 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		StrictFuture<Standalone<StringRef>> __when_expr_8 = items[8].value;
															#line 1075 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (static_cast<CallActor20*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13331 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont9when1(__when_expr_8.get(), loopDepth); };
		static_cast<CallActor20*>(this)->actor_wait_state = 9;
															#line 1075 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< CallActor20, 8, Standalone<StringRef> >*>(static_cast<CallActor20*>(this)));
															#line 13336 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont8when1(Standalone<StringRef> const& s8,int loopDepth) 
	{
		loopDepth = a_body1cont9(s8, loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(Standalone<StringRef> && s8,int loopDepth) 
	{
		loopDepth = a_body1cont9(std::move(s8), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<CallActor20*>(this)->actor_wait_state > 0) static_cast<CallActor20*>(this)->actor_wait_state = 0;
		static_cast<CallActor20*>(this)->ActorCallback< CallActor20, 7, Standalone<StringRef> >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor20, 7, Standalone<StringRef> >*,Standalone<StringRef> const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor20*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< CallActor20, 7, Standalone<StringRef> >*,Standalone<StringRef> && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor20*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< CallActor20, 7, Standalone<StringRef> >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor20*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont10(Standalone<StringRef> const& s9,int loopDepth) 
	{
															#line 1076 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		mode = (FDBStreamingMode)Tuple::unpack(s9).getInt(0);
															#line 1078 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		StrictFuture<Standalone<StringRef>> __when_expr_9 = items[9].value;
															#line 1078 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (static_cast<CallActor20*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13424 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont10when1(__when_expr_9.get(), loopDepth); };
		static_cast<CallActor20*>(this)->actor_wait_state = 10;
															#line 1078 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< CallActor20, 9, Standalone<StringRef> >*>(static_cast<CallActor20*>(this)));
															#line 13429 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10(Standalone<StringRef> && s9,int loopDepth) 
	{
															#line 1076 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		mode = (FDBStreamingMode)Tuple::unpack(s9).getInt(0);
															#line 1078 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		StrictFuture<Standalone<StringRef>> __when_expr_9 = items[9].value;
															#line 1078 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (static_cast<CallActor20*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13442 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont10when1(__when_expr_9.get(), loopDepth); };
		static_cast<CallActor20*>(this)->actor_wait_state = 10;
															#line 1078 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< CallActor20, 9, Standalone<StringRef> >*>(static_cast<CallActor20*>(this)));
															#line 13447 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont9when1(Standalone<StringRef> const& s9,int loopDepth) 
	{
		loopDepth = a_body1cont10(s9, loopDepth);

		return loopDepth;
	}
	int a_body1cont9when1(Standalone<StringRef> && s9,int loopDepth) 
	{
		loopDepth = a_body1cont10(std::move(s9), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<CallActor20*>(this)->actor_wait_state > 0) static_cast<CallActor20*>(this)->actor_wait_state = 0;
		static_cast<CallActor20*>(this)->ActorCallback< CallActor20, 8, Standalone<StringRef> >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor20, 8, Standalone<StringRef> >*,Standalone<StringRef> const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor20*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont9when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< CallActor20, 8, Standalone<StringRef> >*,Standalone<StringRef> && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor20*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< CallActor20, 8, Standalone<StringRef> >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor20*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont10cont1(Standalone<StringRef> const& s10,int loopDepth) 
	{
															#line 1079 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		prefix = Optional<Standalone<StringRef>>();
															#line 1080 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		Tuple t10 = Tuple::unpack(s10);
															#line 1081 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (t10.getType(0) != Tuple::ElementType::NULL_TYPE)
															#line 13535 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		{
															#line 1082 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			prefix = t10.getString(0);
															#line 13539 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		}
															#line 1088 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		Future<Standalone<RangeResultRef>> f = getRange(instruction->tr, KeySelectorRef(begin, begin_or_equal, begin_offset), KeySelectorRef(end, end_or_equal, end_offset), limit, instruction->isSnapshot, reverse, mode);
															#line 1095 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		StrictFuture<Standalone<RangeResultRef>> __when_expr_10 = holdWhile(instruction->tr, f);
															#line 1095 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (static_cast<CallActor20*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13547 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1Catch1(__when_expr_10.getError(), loopDepth); else return a_body1cont10cont1when1(__when_expr_10.get(), loopDepth); };
		static_cast<CallActor20*>(this)->actor_wait_state = 11;
															#line 1095 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< CallActor20, 10, Standalone<RangeResultRef> >*>(static_cast<CallActor20*>(this)));
															#line 13552 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont1(Standalone<StringRef> && s10,int loopDepth) 
	{
															#line 1079 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		prefix = Optional<Standalone<StringRef>>();
															#line 1080 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		Tuple t10 = Tuple::unpack(s10);
															#line 1081 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (t10.getType(0) != Tuple::ElementType::NULL_TYPE)
															#line 13565 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		{
															#line 1082 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			prefix = t10.getString(0);
															#line 13569 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		}
															#line 1088 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		Future<Standalone<RangeResultRef>> f = getRange(instruction->tr, KeySelectorRef(begin, begin_or_equal, begin_offset), KeySelectorRef(end, end_or_equal, end_offset), limit, instruction->isSnapshot, reverse, mode);
															#line 1095 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		StrictFuture<Standalone<RangeResultRef>> __when_expr_10 = holdWhile(instruction->tr, f);
															#line 1095 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (static_cast<CallActor20*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13577 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1Catch1(__when_expr_10.getError(), loopDepth); else return a_body1cont10cont1when1(__when_expr_10.get(), loopDepth); };
		static_cast<CallActor20*>(this)->actor_wait_state = 11;
															#line 1095 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< CallActor20, 10, Standalone<RangeResultRef> >*>(static_cast<CallActor20*>(this)));
															#line 13582 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10when1(Standalone<StringRef> const& s10,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1(s10, loopDepth);

		return loopDepth;
	}
	int a_body1cont10when1(Standalone<StringRef> && s10,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1(std::move(s10), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<CallActor20*>(this)->actor_wait_state > 0) static_cast<CallActor20*>(this)->actor_wait_state = 0;
		static_cast<CallActor20*>(this)->ActorCallback< CallActor20, 9, Standalone<StringRef> >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor20, 9, Standalone<StringRef> >*,Standalone<StringRef> const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor20*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont10when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< CallActor20, 9, Standalone<StringRef> >*,Standalone<StringRef> && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor20*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont10when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< CallActor20, 9, Standalone<StringRef> >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor20*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1cont10cont2(Standalone<RangeResultRef> const& results,int loopDepth) 
	{
															#line 1096 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		Tuple t;
															#line 1098 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		for( auto& s : results ) {
															#line 1099 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (!prefix.present() || s.key.startsWith(prefix.get()))
															#line 13670 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			{
															#line 1100 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
				t.append(s.key);
															#line 1101 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
				t.append(s.value);
															#line 13676 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			}
		}
															#line 1107 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		data->stack.push(Tuple().append(t.pack()).pack());
															#line 1108 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (!static_cast<CallActor20*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor20State(); static_cast<CallActor20*>(this)->destroy(); return 0; }
															#line 13683 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		new (&static_cast<CallActor20*>(this)->SAV< Void >::value()) Void(Void());
		this->~CallActor20State();
		static_cast<CallActor20*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont10cont2(Standalone<RangeResultRef> && results,int loopDepth) 
	{
															#line 1096 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		Tuple t;
															#line 1098 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		for( auto& s : results ) {
															#line 1099 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (!prefix.present() || s.key.startsWith(prefix.get()))
															#line 13699 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			{
															#line 1100 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
				t.append(s.key);
															#line 1101 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
				t.append(s.value);
															#line 13705 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			}
		}
															#line 1107 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		data->stack.push(Tuple().append(t.pack()).pack());
															#line 1108 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (!static_cast<CallActor20*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor20State(); static_cast<CallActor20*>(this)->destroy(); return 0; }
															#line 13712 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		new (&static_cast<CallActor20*>(this)->SAV< Void >::value()) Void(Void());
		this->~CallActor20State();
		static_cast<CallActor20*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont10cont1when1(Standalone<RangeResultRef> const& results,int loopDepth) 
	{
		loopDepth = a_body1cont10cont2(results, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont1when1(Standalone<RangeResultRef> && results,int loopDepth) 
	{
		loopDepth = a_body1cont10cont2(std::move(results), loopDepth);

		return loopDepth;
	}
	void a_exitChoose11() 
	{
		if (static_cast<CallActor20*>(this)->actor_wait_state > 0) static_cast<CallActor20*>(this)->actor_wait_state = 0;
		static_cast<CallActor20*>(this)->ActorCallback< CallActor20, 10, Standalone<RangeResultRef> >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor20, 10, Standalone<RangeResultRef> >*,Standalone<RangeResultRef> const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor20*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont10cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< CallActor20, 10, Standalone<RangeResultRef> >*,Standalone<RangeResultRef> && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor20*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont10cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< CallActor20, 10, Standalone<RangeResultRef> >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor20*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 10);

	}
															#line 1046 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Reference<FlowTesterData> data;
															#line 1046 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Reference<InstructionData> instruction;
															#line 1047 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	std::vector<StackItem> items;
															#line 1052 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Standalone<StringRef> begin;
															#line 1055 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	bool begin_or_equal;
															#line 1058 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	int64_t begin_offset;
															#line 1061 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Standalone<StringRef> end;
															#line 1064 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	bool end_or_equal;
															#line 1067 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	int64_t end_offset;
															#line 1070 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	int limit;
															#line 1073 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	int reverse;
															#line 1076 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	FDBStreamingMode mode;
															#line 1079 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Optional<Standalone<StringRef>> prefix;
															#line 13821 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
};
// This generated class is to be used only via call()
															#line 1046 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
class CallActor20 final : public Actor<Void>, public ActorCallback< CallActor20, 0, Standalone<StringRef> >, public ActorCallback< CallActor20, 1, Standalone<StringRef> >, public ActorCallback< CallActor20, 2, Standalone<StringRef> >, public ActorCallback< CallActor20, 3, Standalone<StringRef> >, public ActorCallback< CallActor20, 4, Standalone<StringRef> >, public ActorCallback< CallActor20, 5, Standalone<StringRef> >, public ActorCallback< CallActor20, 6, Standalone<StringRef> >, public ActorCallback< CallActor20, 7, Standalone<StringRef> >, public ActorCallback< CallActor20, 8, Standalone<StringRef> >, public ActorCallback< CallActor20, 9, Standalone<StringRef> >, public ActorCallback< CallActor20, 10, Standalone<RangeResultRef> >, public FastAllocated<CallActor20>, public CallActor20State<CallActor20> {
															#line 13826 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
public:
	using FastAllocated<CallActor20>::operator new;
	using FastAllocated<CallActor20>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9317237842190798848UL, 4308047855804869376UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CallActor20, 0, Standalone<StringRef> >;
friend struct ActorCallback< CallActor20, 1, Standalone<StringRef> >;
friend struct ActorCallback< CallActor20, 2, Standalone<StringRef> >;
friend struct ActorCallback< CallActor20, 3, Standalone<StringRef> >;
friend struct ActorCallback< CallActor20, 4, Standalone<StringRef> >;
friend struct ActorCallback< CallActor20, 5, Standalone<StringRef> >;
friend struct ActorCallback< CallActor20, 6, Standalone<StringRef> >;
friend struct ActorCallback< CallActor20, 7, Standalone<StringRef> >;
friend struct ActorCallback< CallActor20, 8, Standalone<StringRef> >;
friend struct ActorCallback< CallActor20, 9, Standalone<StringRef> >;
friend struct ActorCallback< CallActor20, 10, Standalone<RangeResultRef> >;
															#line 1046 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	CallActor20(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 13853 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		 : Actor<Void>(),
		   CallActor20State<CallActor20>(data, instruction),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4151036423440242688UL, 3717798664353829376UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor20*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("call");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CallActor20, 0, Standalone<StringRef> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CallActor20, 1, Standalone<StringRef> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CallActor20, 2, Standalone<StringRef> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< CallActor20, 3, Standalone<StringRef> >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< CallActor20, 4, Standalone<StringRef> >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< CallActor20, 5, Standalone<StringRef> >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< CallActor20, 6, Standalone<StringRef> >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< CallActor20, 7, Standalone<StringRef> >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< CallActor20, 8, Standalone<StringRef> >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< CallActor20, 9, Standalone<StringRef> >*)0, actor_cancelled()); break;
		case 11: this->a_callback_error((ActorCallback< CallActor20, 10, Standalone<RangeResultRef> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1046 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
[[nodiscard]] static Future<Void> call( Reference<FlowTesterData> const& data, Reference<InstructionData> const& instruction ) {
															#line 1046 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	return Future<Void>(new CallActor20(data, instruction));
															#line 13895 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
}

#line 1110 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
};
const char* GetRangeSelectorFunc::name = "GET_RANGE_SELECTOR";
REGISTER_INSTRUCTION_FUNC(GetRangeSelectorFunc);

// Tuple Operations
// TUPLE_PACK
struct TuplePackFunc : InstructionFunc {
	static const char* name;

																#line 13908 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
// This generated class is to be used only via call()
															#line 1119 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
template <class CallActor21>
															#line 1119 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
class CallActor21State {
															#line 13914 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
public:
															#line 1119 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	CallActor21State(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 1119 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
															#line 1119 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		 : data(data),
															#line 1119 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		   instruction(instruction),
															#line 1120 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		   items(data->stack.pop())
															#line 13925 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
	{
		fdb_probe_actor_create("call", reinterpret_cast<unsigned long>(this));

	}
	~CallActor21State() 
	{
		fdb_probe_actor_destroy("call", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1121 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (items.size() != 1)
															#line 13940 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			{
															#line 1122 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
				if (!static_cast<CallActor21*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor21State(); static_cast<CallActor21*>(this)->destroy(); return 0; }
															#line 13944 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
				new (&static_cast<CallActor21*>(this)->SAV< Void >::value()) Void(Void());
				this->~CallActor21State();
				static_cast<CallActor21*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 1124 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			StrictFuture<Standalone<StringRef>> __when_expr_0 = items[0].value;
															#line 1124 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (static_cast<CallActor21*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13954 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CallActor21*>(this)->actor_wait_state = 1;
															#line 1124 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CallActor21, 0, Standalone<StringRef> >*>(static_cast<CallActor21*>(this)));
															#line 13959 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CallActor21State();
		static_cast<CallActor21*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Standalone<StringRef> const& s1,int loopDepth) 
	{
															#line 1125 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		count = Tuple::unpack(s1).getInt(0);
															#line 1127 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		items1 = data->stack.pop(count);
															#line 1128 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (items1.size() != count)
															#line 13986 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		{
															#line 1129 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (!static_cast<CallActor21*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor21State(); static_cast<CallActor21*>(this)->destroy(); return 0; }
															#line 13990 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			new (&static_cast<CallActor21*>(this)->SAV< Void >::value()) Void(Void());
			this->~CallActor21State();
			static_cast<CallActor21*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1131 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		tuple = Tuple();
															#line 1132 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		i = 0;
															#line 1133 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		;
															#line 14002 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Standalone<StringRef> && s1,int loopDepth) 
	{
															#line 1125 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		count = Tuple::unpack(s1).getInt(0);
															#line 1127 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		items1 = data->stack.pop(count);
															#line 1128 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (items1.size() != count)
															#line 14015 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		{
															#line 1129 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (!static_cast<CallActor21*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor21State(); static_cast<CallActor21*>(this)->destroy(); return 0; }
															#line 14019 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			new (&static_cast<CallActor21*>(this)->SAV< Void >::value()) Void(Void());
			this->~CallActor21State();
			static_cast<CallActor21*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1131 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		tuple = Tuple();
															#line 1132 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		i = 0;
															#line 1133 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		;
															#line 14031 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Standalone<StringRef> const& s1,int loopDepth) 
	{
		loopDepth = a_body1cont1(s1, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Standalone<StringRef> && s1,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(s1), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CallActor21*>(this)->actor_wait_state > 0) static_cast<CallActor21*>(this)->actor_wait_state = 0;
		static_cast<CallActor21*>(this)->ActorCallback< CallActor21, 0, Standalone<StringRef> >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor21, 0, Standalone<StringRef> >*,Standalone<StringRef> const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor21*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CallActor21, 0, Standalone<StringRef> >*,Standalone<StringRef> && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor21*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CallActor21, 0, Standalone<StringRef> >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor21*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 1166 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		data->stack.pushTuple(tuple.pack());
															#line 1167 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (!static_cast<CallActor21*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor21State(); static_cast<CallActor21*>(this)->destroy(); return 0; }
															#line 14117 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		new (&static_cast<CallActor21*>(this)->SAV< Void >::value()) Void(Void());
		this->~CallActor21State();
		static_cast<CallActor21*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 1133 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (!(i < items1.size()))
															#line 14136 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1134 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		StrictFuture<Standalone<StringRef>> __when_expr_1 = items1[i].value;
															#line 1134 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (static_cast<CallActor21*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 14144 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CallActor21*>(this)->actor_wait_state = 2;
															#line 1134 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CallActor21, 1, Standalone<StringRef> >*>(static_cast<CallActor21*>(this)));
															#line 14149 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Standalone<StringRef> const& str,int loopDepth) 
	{
															#line 1135 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		Tuple itemTuple = Tuple::unpack(str);
															#line 1136 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (deterministicRandom()->coinflip())
															#line 14173 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		{
															#line 1137 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			Tuple::ElementType type = itemTuple.getType(0);
															#line 1138 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (type == Tuple::NULL_TYPE)
															#line 14179 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			{
															#line 1139 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
				tuple.appendNull();
															#line 14183 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			}
			else
			{
															#line 1140 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
				if (type == Tuple::INT)
															#line 14189 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
				{
															#line 1141 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
					tuple << itemTuple.getInt(0);
															#line 14193 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
				}
				else
				{
															#line 1142 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
					if (type == Tuple::BYTES)
															#line 14199 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
					{
															#line 1143 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
						tuple.append(itemTuple.getString(0), false);
															#line 14203 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
					}
					else
					{
															#line 1144 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
						if (type == Tuple::UTF8)
															#line 14209 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
						{
															#line 1145 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
							tuple.append(itemTuple.getString(0), true);
															#line 14213 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
						}
						else
						{
															#line 1146 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
							if (type == Tuple::FLOAT)
															#line 14219 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
							{
															#line 1147 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
								tuple << itemTuple.getFloat(0);
															#line 14223 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
							}
							else
							{
															#line 1148 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
								if (type == Tuple::DOUBLE)
															#line 14229 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
								{
															#line 1149 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
									tuple << itemTuple.getDouble(0);
															#line 14233 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
								}
								else
								{
															#line 1150 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
									if (type == Tuple::BOOL)
															#line 14239 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
									{
															#line 1151 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
										tuple << itemTuple.getBool(0);
															#line 14243 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
									}
									else
									{
															#line 1152 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
										if (type == Tuple::UUID)
															#line 14249 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
										{
															#line 1153 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
											tuple << itemTuple.getUuid(0);
															#line 14253 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
										}
										else
										{
															#line 1154 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
											if (type == Tuple::NESTED)
															#line 14259 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
											{
															#line 1155 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
												tuple.appendNested(itemTuple.getNested(0));
															#line 14263 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
											}
											else
											{
															#line 1156 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
												if (type == Tuple::VERSIONSTAMP)
															#line 14269 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
												{
															#line 1157 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
													tuple.appendVersionstamp(itemTuple.getVersionstamp(0));
															#line 14273 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
												}
												else
												{
															#line 1159 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
													ASSERT(false);
															#line 14279 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
		else
		{
															#line 1162 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			tuple << itemTuple;
															#line 14295 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		}
															#line 1133 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		++i;
															#line 14299 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Standalone<StringRef> && str,int loopDepth) 
	{
															#line 1135 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		Tuple itemTuple = Tuple::unpack(str);
															#line 1136 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (deterministicRandom()->coinflip())
															#line 14310 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		{
															#line 1137 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			Tuple::ElementType type = itemTuple.getType(0);
															#line 1138 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (type == Tuple::NULL_TYPE)
															#line 14316 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			{
															#line 1139 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
				tuple.appendNull();
															#line 14320 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			}
			else
			{
															#line 1140 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
				if (type == Tuple::INT)
															#line 14326 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
				{
															#line 1141 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
					tuple << itemTuple.getInt(0);
															#line 14330 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
				}
				else
				{
															#line 1142 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
					if (type == Tuple::BYTES)
															#line 14336 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
					{
															#line 1143 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
						tuple.append(itemTuple.getString(0), false);
															#line 14340 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
					}
					else
					{
															#line 1144 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
						if (type == Tuple::UTF8)
															#line 14346 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
						{
															#line 1145 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
							tuple.append(itemTuple.getString(0), true);
															#line 14350 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
						}
						else
						{
															#line 1146 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
							if (type == Tuple::FLOAT)
															#line 14356 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
							{
															#line 1147 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
								tuple << itemTuple.getFloat(0);
															#line 14360 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
							}
							else
							{
															#line 1148 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
								if (type == Tuple::DOUBLE)
															#line 14366 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
								{
															#line 1149 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
									tuple << itemTuple.getDouble(0);
															#line 14370 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
								}
								else
								{
															#line 1150 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
									if (type == Tuple::BOOL)
															#line 14376 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
									{
															#line 1151 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
										tuple << itemTuple.getBool(0);
															#line 14380 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
									}
									else
									{
															#line 1152 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
										if (type == Tuple::UUID)
															#line 14386 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
										{
															#line 1153 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
											tuple << itemTuple.getUuid(0);
															#line 14390 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
										}
										else
										{
															#line 1154 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
											if (type == Tuple::NESTED)
															#line 14396 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
											{
															#line 1155 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
												tuple.appendNested(itemTuple.getNested(0));
															#line 14400 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
											}
											else
											{
															#line 1156 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
												if (type == Tuple::VERSIONSTAMP)
															#line 14406 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
												{
															#line 1157 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
													tuple.appendVersionstamp(itemTuple.getVersionstamp(0));
															#line 14410 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
												}
												else
												{
															#line 1159 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
													ASSERT(false);
															#line 14416 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
		else
		{
															#line 1162 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			tuple << itemTuple;
															#line 14432 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		}
															#line 1133 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		++i;
															#line 14436 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Standalone<StringRef> const& str,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(str, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Standalone<StringRef> && str,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(std::move(str), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CallActor21*>(this)->actor_wait_state > 0) static_cast<CallActor21*>(this)->actor_wait_state = 0;
		static_cast<CallActor21*>(this)->ActorCallback< CallActor21, 1, Standalone<StringRef> >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor21, 1, Standalone<StringRef> >*,Standalone<StringRef> const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor21*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CallActor21, 1, Standalone<StringRef> >*,Standalone<StringRef> && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor21*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CallActor21, 1, Standalone<StringRef> >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor21*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1119 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Reference<FlowTesterData> data;
															#line 1119 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Reference<InstructionData> instruction;
															#line 1120 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	std::vector<StackItem> items;
															#line 1125 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	int64_t count;
															#line 1127 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	std::vector<StackItem> items1;
															#line 1131 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Tuple tuple;
															#line 1132 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	int i;
															#line 14530 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
};
// This generated class is to be used only via call()
															#line 1119 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
class CallActor21 final : public Actor<Void>, public ActorCallback< CallActor21, 0, Standalone<StringRef> >, public ActorCallback< CallActor21, 1, Standalone<StringRef> >, public FastAllocated<CallActor21>, public CallActor21State<CallActor21> {
															#line 14535 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
public:
	using FastAllocated<CallActor21>::operator new;
	using FastAllocated<CallActor21>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9317237842190798848UL, 4308047855804869376UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CallActor21, 0, Standalone<StringRef> >;
friend struct ActorCallback< CallActor21, 1, Standalone<StringRef> >;
															#line 1119 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	CallActor21(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 14553 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		 : Actor<Void>(),
		   CallActor21State<CallActor21>(data, instruction),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(161276209975055872UL, 17579429687451322880UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor21*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("call");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CallActor21, 0, Standalone<StringRef> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CallActor21, 1, Standalone<StringRef> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1119 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
[[nodiscard]] static Future<Void> call( Reference<FlowTesterData> const& data, Reference<InstructionData> const& instruction ) {
															#line 1119 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	return Future<Void>(new CallActor21(data, instruction));
															#line 14586 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
}

#line 1169 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
};
const char* TuplePackFunc::name = "TUPLE_PACK";
REGISTER_INSTRUCTION_FUNC(TuplePackFunc);

// TUPLE_UNPACK
struct TupleUnpackFunc : InstructionFunc {
	static const char* name;

																#line 14598 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
// This generated class is to be used only via call()
															#line 1177 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
template <class CallActor22>
															#line 1177 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
class CallActor22State {
															#line 14604 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
public:
															#line 1177 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	CallActor22State(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 1177 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
															#line 1177 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		 : data(data),
															#line 1177 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		   instruction(instruction),
															#line 1178 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		   items(data->stack.pop())
															#line 14615 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
	{
		fdb_probe_actor_create("call", reinterpret_cast<unsigned long>(this));

	}
	~CallActor22State() 
	{
		fdb_probe_actor_destroy("call", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1179 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (items.size() != 1)
															#line 14630 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			{
															#line 1180 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
				if (!static_cast<CallActor22*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor22State(); static_cast<CallActor22*>(this)->destroy(); return 0; }
															#line 14634 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
				new (&static_cast<CallActor22*>(this)->SAV< Void >::value()) Void(Void());
				this->~CallActor22State();
				static_cast<CallActor22*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 1182 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			StrictFuture<Standalone<StringRef>> __when_expr_0 = items[0].value;
															#line 1182 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (static_cast<CallActor22*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14644 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CallActor22*>(this)->actor_wait_state = 1;
															#line 1182 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CallActor22, 0, Standalone<StringRef> >*>(static_cast<CallActor22*>(this)));
															#line 14649 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CallActor22State();
		static_cast<CallActor22*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Standalone<StringRef> const& s1,int loopDepth) 
	{
															#line 1183 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		Tuple t = Tuple::unpack(Tuple::unpack(s1).getString(0));
															#line 1185 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		for(int i = 0;i < t.size();++i) {
															#line 1186 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			Standalone<StringRef> str = t.subTuple(i, i + 1).pack();
															#line 1188 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			data->stack.pushTuple(str);
															#line 14678 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		}
															#line 1190 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (!static_cast<CallActor22*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor22State(); static_cast<CallActor22*>(this)->destroy(); return 0; }
															#line 14682 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		new (&static_cast<CallActor22*>(this)->SAV< Void >::value()) Void(Void());
		this->~CallActor22State();
		static_cast<CallActor22*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Standalone<StringRef> && s1,int loopDepth) 
	{
															#line 1183 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		Tuple t = Tuple::unpack(Tuple::unpack(s1).getString(0));
															#line 1185 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		for(int i = 0;i < t.size();++i) {
															#line 1186 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			Standalone<StringRef> str = t.subTuple(i, i + 1).pack();
															#line 1188 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			data->stack.pushTuple(str);
															#line 14700 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		}
															#line 1190 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (!static_cast<CallActor22*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor22State(); static_cast<CallActor22*>(this)->destroy(); return 0; }
															#line 14704 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		new (&static_cast<CallActor22*>(this)->SAV< Void >::value()) Void(Void());
		this->~CallActor22State();
		static_cast<CallActor22*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Standalone<StringRef> const& s1,int loopDepth) 
	{
		loopDepth = a_body1cont1(s1, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Standalone<StringRef> && s1,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(s1), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CallActor22*>(this)->actor_wait_state > 0) static_cast<CallActor22*>(this)->actor_wait_state = 0;
		static_cast<CallActor22*>(this)->ActorCallback< CallActor22, 0, Standalone<StringRef> >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor22, 0, Standalone<StringRef> >*,Standalone<StringRef> const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor22*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CallActor22, 0, Standalone<StringRef> >*,Standalone<StringRef> && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor22*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CallActor22, 0, Standalone<StringRef> >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor22*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1177 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Reference<FlowTesterData> data;
															#line 1177 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Reference<InstructionData> instruction;
															#line 1178 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	std::vector<StackItem> items;
															#line 14793 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
};
// This generated class is to be used only via call()
															#line 1177 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
class CallActor22 final : public Actor<Void>, public ActorCallback< CallActor22, 0, Standalone<StringRef> >, public FastAllocated<CallActor22>, public CallActor22State<CallActor22> {
															#line 14798 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
public:
	using FastAllocated<CallActor22>::operator new;
	using FastAllocated<CallActor22>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9317237842190798848UL, 4308047855804869376UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CallActor22, 0, Standalone<StringRef> >;
															#line 1177 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	CallActor22(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 14815 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		 : Actor<Void>(),
		   CallActor22State<CallActor22>(data, instruction),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17002564202806475520UL, 3520261829484349696UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor22*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("call");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CallActor22, 0, Standalone<StringRef> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1177 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
[[nodiscard]] static Future<Void> call( Reference<FlowTesterData> const& data, Reference<InstructionData> const& instruction ) {
															#line 1177 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	return Future<Void>(new CallActor22(data, instruction));
															#line 14847 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
}

#line 1192 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
};
const char* TupleUnpackFunc::name = "TUPLE_UNPACK";
REGISTER_INSTRUCTION_FUNC(TupleUnpackFunc);

// TUPLE_RANGE
struct TupleRangeFunc : InstructionFunc {
	static const char* name;

																#line 14859 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
// This generated class is to be used only via call()
															#line 1200 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
template <class CallActor23>
															#line 1200 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
class CallActor23State {
															#line 14865 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
public:
															#line 1200 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	CallActor23State(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 1200 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
															#line 1200 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		 : data(data),
															#line 1200 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		   instruction(instruction),
															#line 1201 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		   items(data->stack.pop())
															#line 14876 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
	{
		fdb_probe_actor_create("call", reinterpret_cast<unsigned long>(this));

	}
	~CallActor23State() 
	{
		fdb_probe_actor_destroy("call", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1202 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (items.size() != 1)
															#line 14891 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			{
															#line 1203 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
				if (!static_cast<CallActor23*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor23State(); static_cast<CallActor23*>(this)->destroy(); return 0; }
															#line 14895 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
				new (&static_cast<CallActor23*>(this)->SAV< Void >::value()) Void(Void());
				this->~CallActor23State();
				static_cast<CallActor23*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 1205 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			StrictFuture<Standalone<StringRef>> __when_expr_0 = items[0].value;
															#line 1205 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (static_cast<CallActor23*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14905 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CallActor23*>(this)->actor_wait_state = 1;
															#line 1205 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CallActor23, 0, Standalone<StringRef> >*>(static_cast<CallActor23*>(this)));
															#line 14910 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CallActor23State();
		static_cast<CallActor23*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Standalone<StringRef> const& s1,int loopDepth) 
	{
															#line 1206 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		count = Tuple::unpack(s1).getInt(0);
															#line 1208 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		items1 = data->stack.pop(count);
															#line 1209 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (items1.size() != count)
															#line 14937 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		{
															#line 1210 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (!static_cast<CallActor23*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor23State(); static_cast<CallActor23*>(this)->destroy(); return 0; }
															#line 14941 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			new (&static_cast<CallActor23*>(this)->SAV< Void >::value()) Void(Void());
			this->~CallActor23State();
			static_cast<CallActor23*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1212 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		tuple = Tuple();
															#line 1213 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		i = 0;
															#line 1214 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		;
															#line 14953 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Standalone<StringRef> && s1,int loopDepth) 
	{
															#line 1206 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		count = Tuple::unpack(s1).getInt(0);
															#line 1208 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		items1 = data->stack.pop(count);
															#line 1209 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (items1.size() != count)
															#line 14966 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		{
															#line 1210 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (!static_cast<CallActor23*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor23State(); static_cast<CallActor23*>(this)->destroy(); return 0; }
															#line 14970 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			new (&static_cast<CallActor23*>(this)->SAV< Void >::value()) Void(Void());
			this->~CallActor23State();
			static_cast<CallActor23*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1212 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		tuple = Tuple();
															#line 1213 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		i = 0;
															#line 1214 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		;
															#line 14982 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Standalone<StringRef> const& s1,int loopDepth) 
	{
		loopDepth = a_body1cont1(s1, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Standalone<StringRef> && s1,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(s1), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CallActor23*>(this)->actor_wait_state > 0) static_cast<CallActor23*>(this)->actor_wait_state = 0;
		static_cast<CallActor23*>(this)->ActorCallback< CallActor23, 0, Standalone<StringRef> >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor23, 0, Standalone<StringRef> >*,Standalone<StringRef> const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor23*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CallActor23, 0, Standalone<StringRef> >*,Standalone<StringRef> && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor23*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CallActor23, 0, Standalone<StringRef> >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor23*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 1247 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		KeyRange range = tuple.range();
															#line 1249 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		data->stack.pushTuple(range.begin);
															#line 1250 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		data->stack.pushTuple(range.end);
															#line 1251 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (!static_cast<CallActor23*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor23State(); static_cast<CallActor23*>(this)->destroy(); return 0; }
															#line 15072 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		new (&static_cast<CallActor23*>(this)->SAV< Void >::value()) Void(Void());
		this->~CallActor23State();
		static_cast<CallActor23*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 1214 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (!(i < items1.size()))
															#line 15091 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1215 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		StrictFuture<Standalone<StringRef>> __when_expr_1 = items1[i].value;
															#line 1215 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (static_cast<CallActor23*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 15099 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CallActor23*>(this)->actor_wait_state = 2;
															#line 1215 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CallActor23, 1, Standalone<StringRef> >*>(static_cast<CallActor23*>(this)));
															#line 15104 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Standalone<StringRef> const& str,int loopDepth) 
	{
															#line 1216 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		Tuple itemTuple = Tuple::unpack(str);
															#line 1217 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (deterministicRandom()->coinflip())
															#line 15128 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		{
															#line 1218 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			Tuple::ElementType type = itemTuple.getType(0);
															#line 1219 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (type == Tuple::NULL_TYPE)
															#line 15134 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			{
															#line 1220 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
				tuple.appendNull();
															#line 15138 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			}
			else
			{
															#line 1221 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
				if (type == Tuple::INT)
															#line 15144 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
				{
															#line 1222 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
					tuple << itemTuple.getInt(0);
															#line 15148 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
				}
				else
				{
															#line 1223 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
					if (type == Tuple::BYTES)
															#line 15154 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
					{
															#line 1224 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
						tuple.append(itemTuple.getString(0), false);
															#line 15158 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
					}
					else
					{
															#line 1225 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
						if (type == Tuple::UTF8)
															#line 15164 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
						{
															#line 1226 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
							tuple.append(itemTuple.getString(0), true);
															#line 15168 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
						}
						else
						{
															#line 1227 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
							if (type == Tuple::FLOAT)
															#line 15174 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
							{
															#line 1228 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
								tuple << itemTuple.getFloat(0);
															#line 15178 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
							}
							else
							{
															#line 1229 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
								if (type == Tuple::DOUBLE)
															#line 15184 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
								{
															#line 1230 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
									tuple << itemTuple.getDouble(0);
															#line 15188 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
								}
								else
								{
															#line 1231 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
									if (type == Tuple::BOOL)
															#line 15194 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
									{
															#line 1232 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
										tuple << itemTuple.getBool(0);
															#line 15198 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
									}
									else
									{
															#line 1233 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
										if (type == Tuple::UUID)
															#line 15204 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
										{
															#line 1234 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
											tuple << itemTuple.getUuid(0);
															#line 15208 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
										}
										else
										{
															#line 1235 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
											if (type == Tuple::NESTED)
															#line 15214 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
											{
															#line 1236 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
												tuple.appendNested(itemTuple.getNested(0));
															#line 15218 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
											}
											else
											{
															#line 1237 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
												if (type == Tuple::VERSIONSTAMP)
															#line 15224 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
												{
															#line 1238 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
													tuple.appendVersionstamp(itemTuple.getVersionstamp(0));
															#line 15228 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
												}
												else
												{
															#line 1240 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
													ASSERT(false);
															#line 15234 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
		else
		{
															#line 1243 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			tuple << itemTuple;
															#line 15250 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		}
															#line 1214 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		++i;
															#line 15254 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Standalone<StringRef> && str,int loopDepth) 
	{
															#line 1216 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		Tuple itemTuple = Tuple::unpack(str);
															#line 1217 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (deterministicRandom()->coinflip())
															#line 15265 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		{
															#line 1218 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			Tuple::ElementType type = itemTuple.getType(0);
															#line 1219 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (type == Tuple::NULL_TYPE)
															#line 15271 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			{
															#line 1220 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
				tuple.appendNull();
															#line 15275 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			}
			else
			{
															#line 1221 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
				if (type == Tuple::INT)
															#line 15281 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
				{
															#line 1222 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
					tuple << itemTuple.getInt(0);
															#line 15285 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
				}
				else
				{
															#line 1223 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
					if (type == Tuple::BYTES)
															#line 15291 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
					{
															#line 1224 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
						tuple.append(itemTuple.getString(0), false);
															#line 15295 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
					}
					else
					{
															#line 1225 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
						if (type == Tuple::UTF8)
															#line 15301 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
						{
															#line 1226 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
							tuple.append(itemTuple.getString(0), true);
															#line 15305 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
						}
						else
						{
															#line 1227 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
							if (type == Tuple::FLOAT)
															#line 15311 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
							{
															#line 1228 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
								tuple << itemTuple.getFloat(0);
															#line 15315 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
							}
							else
							{
															#line 1229 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
								if (type == Tuple::DOUBLE)
															#line 15321 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
								{
															#line 1230 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
									tuple << itemTuple.getDouble(0);
															#line 15325 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
								}
								else
								{
															#line 1231 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
									if (type == Tuple::BOOL)
															#line 15331 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
									{
															#line 1232 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
										tuple << itemTuple.getBool(0);
															#line 15335 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
									}
									else
									{
															#line 1233 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
										if (type == Tuple::UUID)
															#line 15341 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
										{
															#line 1234 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
											tuple << itemTuple.getUuid(0);
															#line 15345 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
										}
										else
										{
															#line 1235 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
											if (type == Tuple::NESTED)
															#line 15351 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
											{
															#line 1236 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
												tuple.appendNested(itemTuple.getNested(0));
															#line 15355 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
											}
											else
											{
															#line 1237 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
												if (type == Tuple::VERSIONSTAMP)
															#line 15361 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
												{
															#line 1238 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
													tuple.appendVersionstamp(itemTuple.getVersionstamp(0));
															#line 15365 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
												}
												else
												{
															#line 1240 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
													ASSERT(false);
															#line 15371 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
		else
		{
															#line 1243 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			tuple << itemTuple;
															#line 15387 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		}
															#line 1214 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		++i;
															#line 15391 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Standalone<StringRef> const& str,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(str, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Standalone<StringRef> && str,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(std::move(str), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CallActor23*>(this)->actor_wait_state > 0) static_cast<CallActor23*>(this)->actor_wait_state = 0;
		static_cast<CallActor23*>(this)->ActorCallback< CallActor23, 1, Standalone<StringRef> >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor23, 1, Standalone<StringRef> >*,Standalone<StringRef> const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor23*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CallActor23, 1, Standalone<StringRef> >*,Standalone<StringRef> && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor23*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CallActor23, 1, Standalone<StringRef> >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor23*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1200 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Reference<FlowTesterData> data;
															#line 1200 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Reference<InstructionData> instruction;
															#line 1201 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	std::vector<StackItem> items;
															#line 1206 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	int64_t count;
															#line 1208 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	std::vector<StackItem> items1;
															#line 1212 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Tuple tuple;
															#line 1213 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	size_t i;
															#line 15485 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
};
// This generated class is to be used only via call()
															#line 1200 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
class CallActor23 final : public Actor<Void>, public ActorCallback< CallActor23, 0, Standalone<StringRef> >, public ActorCallback< CallActor23, 1, Standalone<StringRef> >, public FastAllocated<CallActor23>, public CallActor23State<CallActor23> {
															#line 15490 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
public:
	using FastAllocated<CallActor23>::operator new;
	using FastAllocated<CallActor23>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9317237842190798848UL, 4308047855804869376UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CallActor23, 0, Standalone<StringRef> >;
friend struct ActorCallback< CallActor23, 1, Standalone<StringRef> >;
															#line 1200 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	CallActor23(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 15508 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		 : Actor<Void>(),
		   CallActor23State<CallActor23>(data, instruction),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9325791650431721472UL, 3929602136997461760UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor23*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("call");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CallActor23, 0, Standalone<StringRef> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CallActor23, 1, Standalone<StringRef> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1200 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
[[nodiscard]] static Future<Void> call( Reference<FlowTesterData> const& data, Reference<InstructionData> const& instruction ) {
															#line 1200 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	return Future<Void>(new CallActor23(data, instruction));
															#line 15541 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
}

#line 1253 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
};
const char* TupleRangeFunc::name = "TUPLE_RANGE";
REGISTER_INSTRUCTION_FUNC(TupleRangeFunc);

// TUPLE_SORT
struct TupleSortFunc : InstructionFunc {
	static const char* name;

																#line 15553 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
// This generated class is to be used only via call()
															#line 1261 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
template <class CallActor24>
															#line 1261 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
class CallActor24State {
															#line 15559 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
public:
															#line 1261 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	CallActor24State(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 1261 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
															#line 1261 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		 : data(data),
															#line 1261 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		   instruction(instruction),
															#line 1262 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		   items(data->stack.pop())
															#line 15570 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
	{
		fdb_probe_actor_create("call", reinterpret_cast<unsigned long>(this));

	}
	~CallActor24State() 
	{
		fdb_probe_actor_destroy("call", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1263 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (items.size() != 1)
															#line 15585 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			{
															#line 1264 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
				if (!static_cast<CallActor24*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor24State(); static_cast<CallActor24*>(this)->destroy(); return 0; }
															#line 15589 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
				new (&static_cast<CallActor24*>(this)->SAV< Void >::value()) Void(Void());
				this->~CallActor24State();
				static_cast<CallActor24*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 1266 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			StrictFuture<Standalone<StringRef>> __when_expr_0 = items[0].value;
															#line 1266 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (static_cast<CallActor24*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15599 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CallActor24*>(this)->actor_wait_state = 1;
															#line 1266 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CallActor24, 0, Standalone<StringRef> >*>(static_cast<CallActor24*>(this)));
															#line 15604 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CallActor24State();
		static_cast<CallActor24*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Standalone<StringRef> const& s1,int loopDepth) 
	{
															#line 1267 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		count = Tuple::unpack(s1).getInt(0);
															#line 1269 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		items1 = data->stack.pop(count);
															#line 1270 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (items1.size() != count)
															#line 15631 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		{
															#line 1271 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (!static_cast<CallActor24*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor24State(); static_cast<CallActor24*>(this)->destroy(); return 0; }
															#line 15635 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			new (&static_cast<CallActor24*>(this)->SAV< Void >::value()) Void(Void());
			this->~CallActor24State();
			static_cast<CallActor24*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1273 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		tuples = std::vector<Tuple>();
															#line 1274 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		i = 0;
															#line 1275 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		;
															#line 15647 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Standalone<StringRef> && s1,int loopDepth) 
	{
															#line 1267 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		count = Tuple::unpack(s1).getInt(0);
															#line 1269 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		items1 = data->stack.pop(count);
															#line 1270 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (items1.size() != count)
															#line 15660 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		{
															#line 1271 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (!static_cast<CallActor24*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor24State(); static_cast<CallActor24*>(this)->destroy(); return 0; }
															#line 15664 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			new (&static_cast<CallActor24*>(this)->SAV< Void >::value()) Void(Void());
			this->~CallActor24State();
			static_cast<CallActor24*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1273 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		tuples = std::vector<Tuple>();
															#line 1274 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		i = 0;
															#line 1275 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		;
															#line 15676 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Standalone<StringRef> const& s1,int loopDepth) 
	{
		loopDepth = a_body1cont1(s1, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Standalone<StringRef> && s1,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(s1), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CallActor24*>(this)->actor_wait_state > 0) static_cast<CallActor24*>(this)->actor_wait_state = 0;
		static_cast<CallActor24*>(this)->ActorCallback< CallActor24, 0, Standalone<StringRef> >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor24, 0, Standalone<StringRef> >*,Standalone<StringRef> const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor24*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CallActor24, 0, Standalone<StringRef> >*,Standalone<StringRef> && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor24*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CallActor24, 0, Standalone<StringRef> >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor24*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 1280 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		std::sort(tuples.begin(), tuples.end());
															#line 1281 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		for( Tuple const& t : tuples ) {
															#line 1282 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			data->stack.push(t.pack());
															#line 15764 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		}
															#line 1285 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (!static_cast<CallActor24*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor24State(); static_cast<CallActor24*>(this)->destroy(); return 0; }
															#line 15768 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		new (&static_cast<CallActor24*>(this)->SAV< Void >::value()) Void(Void());
		this->~CallActor24State();
		static_cast<CallActor24*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 1275 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (!(i < items1.size()))
															#line 15787 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1276 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		StrictFuture<Standalone<StringRef>> __when_expr_1 = items1[i].value;
															#line 1276 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (static_cast<CallActor24*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 15795 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CallActor24*>(this)->actor_wait_state = 2;
															#line 1276 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CallActor24, 1, Standalone<StringRef> >*>(static_cast<CallActor24*>(this)));
															#line 15800 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Standalone<StringRef> const& value,int loopDepth) 
	{
															#line 1277 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		tuples.push_back(Tuple::unpack(value));
															#line 1275 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		i++;
															#line 15824 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Standalone<StringRef> && value,int loopDepth) 
	{
															#line 1277 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		tuples.push_back(Tuple::unpack(value));
															#line 1275 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		i++;
															#line 15835 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Standalone<StringRef> const& value,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(value, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Standalone<StringRef> && value,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(std::move(value), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CallActor24*>(this)->actor_wait_state > 0) static_cast<CallActor24*>(this)->actor_wait_state = 0;
		static_cast<CallActor24*>(this)->ActorCallback< CallActor24, 1, Standalone<StringRef> >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor24, 1, Standalone<StringRef> >*,Standalone<StringRef> const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor24*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CallActor24, 1, Standalone<StringRef> >*,Standalone<StringRef> && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor24*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CallActor24, 1, Standalone<StringRef> >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor24*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1261 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Reference<FlowTesterData> data;
															#line 1261 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Reference<InstructionData> instruction;
															#line 1262 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	std::vector<StackItem> items;
															#line 1267 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	int64_t count;
															#line 1269 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	std::vector<StackItem> items1;
															#line 1273 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	std::vector<Tuple> tuples;
															#line 1274 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	size_t i;
															#line 15929 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
};
// This generated class is to be used only via call()
															#line 1261 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
class CallActor24 final : public Actor<Void>, public ActorCallback< CallActor24, 0, Standalone<StringRef> >, public ActorCallback< CallActor24, 1, Standalone<StringRef> >, public FastAllocated<CallActor24>, public CallActor24State<CallActor24> {
															#line 15934 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
public:
	using FastAllocated<CallActor24>::operator new;
	using FastAllocated<CallActor24>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9317237842190798848UL, 4308047855804869376UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CallActor24, 0, Standalone<StringRef> >;
friend struct ActorCallback< CallActor24, 1, Standalone<StringRef> >;
															#line 1261 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	CallActor24(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 15952 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		 : Actor<Void>(),
		   CallActor24State<CallActor24>(data, instruction),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8708211050906319872UL, 10010623433051552768UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor24*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("call");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CallActor24, 0, Standalone<StringRef> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CallActor24, 1, Standalone<StringRef> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1261 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
[[nodiscard]] static Future<Void> call( Reference<FlowTesterData> const& data, Reference<InstructionData> const& instruction ) {
															#line 1261 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	return Future<Void>(new CallActor24(data, instruction));
															#line 15985 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
}

#line 1287 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
};
const char* TupleSortFunc::name = "TUPLE_SORT";
REGISTER_INSTRUCTION_FUNC(TupleSortFunc);

// ENCODE_FLOAT
struct EncodeFloatFunc : InstructionFunc {
	static const char* name;

																#line 15997 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
// This generated class is to be used only via call()
															#line 1295 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
template <class CallActor25>
															#line 1295 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
class CallActor25State {
															#line 16003 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
public:
															#line 1295 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	CallActor25State(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 1295 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
															#line 1295 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		 : data(data),
															#line 1295 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		   instruction(instruction)
															#line 16012 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
	{
		fdb_probe_actor_create("call", reinterpret_cast<unsigned long>(this));

	}
	~CallActor25State() 
	{
		fdb_probe_actor_destroy("call", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1296 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			std::vector<StackItem> items = data->stack.pop();
															#line 1297 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (items.size() != 1)
															#line 16029 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			{
															#line 1298 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
				if (!static_cast<CallActor25*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor25State(); static_cast<CallActor25*>(this)->destroy(); return 0; }
															#line 16033 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
				new (&static_cast<CallActor25*>(this)->SAV< Void >::value()) Void(Void());
				this->~CallActor25State();
				static_cast<CallActor25*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 1300 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			StrictFuture<Standalone<StringRef>> __when_expr_0 = items[0].value;
															#line 1300 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (static_cast<CallActor25*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 16043 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CallActor25*>(this)->actor_wait_state = 1;
															#line 1300 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CallActor25, 0, Standalone<StringRef> >*>(static_cast<CallActor25*>(this)));
															#line 16048 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CallActor25State();
		static_cast<CallActor25*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Standalone<StringRef> const& s1,int loopDepth) 
	{
															#line 1301 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		Standalone<StringRef> fBytes = Tuple::unpack(s1).getString(0);
															#line 1302 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		ASSERT(fBytes.size() == 4);
															#line 1304 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		int32_t intVal = *(int32_t*)fBytes.begin();
															#line 1305 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		intVal = bigEndian32(intVal);
															#line 1306 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		float fVal = *(float*)&intVal;
															#line 1308 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		Tuple t;
															#line 1309 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		t.append(fVal);
															#line 1310 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		data->stack.push(t.pack());
															#line 1312 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (!static_cast<CallActor25*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor25State(); static_cast<CallActor25*>(this)->destroy(); return 0; }
															#line 16087 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		new (&static_cast<CallActor25*>(this)->SAV< Void >::value()) Void(Void());
		this->~CallActor25State();
		static_cast<CallActor25*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Standalone<StringRef> && s1,int loopDepth) 
	{
															#line 1301 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		Standalone<StringRef> fBytes = Tuple::unpack(s1).getString(0);
															#line 1302 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		ASSERT(fBytes.size() == 4);
															#line 1304 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		int32_t intVal = *(int32_t*)fBytes.begin();
															#line 1305 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		intVal = bigEndian32(intVal);
															#line 1306 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		float fVal = *(float*)&intVal;
															#line 1308 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		Tuple t;
															#line 1309 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		t.append(fVal);
															#line 1310 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		data->stack.push(t.pack());
															#line 1312 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (!static_cast<CallActor25*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor25State(); static_cast<CallActor25*>(this)->destroy(); return 0; }
															#line 16115 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		new (&static_cast<CallActor25*>(this)->SAV< Void >::value()) Void(Void());
		this->~CallActor25State();
		static_cast<CallActor25*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Standalone<StringRef> const& s1,int loopDepth) 
	{
		loopDepth = a_body1cont1(s1, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Standalone<StringRef> && s1,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(s1), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CallActor25*>(this)->actor_wait_state > 0) static_cast<CallActor25*>(this)->actor_wait_state = 0;
		static_cast<CallActor25*>(this)->ActorCallback< CallActor25, 0, Standalone<StringRef> >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor25, 0, Standalone<StringRef> >*,Standalone<StringRef> const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor25*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CallActor25, 0, Standalone<StringRef> >*,Standalone<StringRef> && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor25*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CallActor25, 0, Standalone<StringRef> >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor25*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1295 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Reference<FlowTesterData> data;
															#line 1295 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Reference<InstructionData> instruction;
															#line 16202 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
};
// This generated class is to be used only via call()
															#line 1295 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
class CallActor25 final : public Actor<Void>, public ActorCallback< CallActor25, 0, Standalone<StringRef> >, public FastAllocated<CallActor25>, public CallActor25State<CallActor25> {
															#line 16207 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
public:
	using FastAllocated<CallActor25>::operator new;
	using FastAllocated<CallActor25>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9317237842190798848UL, 4308047855804869376UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CallActor25, 0, Standalone<StringRef> >;
															#line 1295 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	CallActor25(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 16224 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		 : Actor<Void>(),
		   CallActor25State<CallActor25>(data, instruction),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5053931112803435264UL, 18189552258208093696UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor25*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("call");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CallActor25, 0, Standalone<StringRef> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1295 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
[[nodiscard]] static Future<Void> call( Reference<FlowTesterData> const& data, Reference<InstructionData> const& instruction ) {
															#line 1295 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	return Future<Void>(new CallActor25(data, instruction));
															#line 16256 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
}

#line 1314 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
};
const char* EncodeFloatFunc::name = "ENCODE_FLOAT";
REGISTER_INSTRUCTION_FUNC(EncodeFloatFunc);

// ENCODE_DOUBLE
struct EncodeDoubleFunc : InstructionFunc {
	static const char* name;

																#line 16268 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
// This generated class is to be used only via call()
															#line 1322 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
template <class CallActor26>
															#line 1322 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
class CallActor26State {
															#line 16274 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
public:
															#line 1322 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	CallActor26State(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 1322 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
															#line 1322 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		 : data(data),
															#line 1322 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		   instruction(instruction)
															#line 16283 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
	{
		fdb_probe_actor_create("call", reinterpret_cast<unsigned long>(this));

	}
	~CallActor26State() 
	{
		fdb_probe_actor_destroy("call", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1323 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			std::vector<StackItem> items = data->stack.pop();
															#line 1324 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (items.size() != 1)
															#line 16300 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			{
															#line 1325 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
				if (!static_cast<CallActor26*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor26State(); static_cast<CallActor26*>(this)->destroy(); return 0; }
															#line 16304 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
				new (&static_cast<CallActor26*>(this)->SAV< Void >::value()) Void(Void());
				this->~CallActor26State();
				static_cast<CallActor26*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 1327 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			StrictFuture<Standalone<StringRef>> __when_expr_0 = items[0].value;
															#line 1327 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (static_cast<CallActor26*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 16314 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CallActor26*>(this)->actor_wait_state = 1;
															#line 1327 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CallActor26, 0, Standalone<StringRef> >*>(static_cast<CallActor26*>(this)));
															#line 16319 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CallActor26State();
		static_cast<CallActor26*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Standalone<StringRef> const& s1,int loopDepth) 
	{
															#line 1328 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		Standalone<StringRef> dBytes = Tuple::unpack(s1).getString(0);
															#line 1329 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		ASSERT(dBytes.size() == 8);
															#line 1331 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		int64_t intVal = *(int64_t*)dBytes.begin();
															#line 1332 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		intVal = bigEndian64(intVal);
															#line 1333 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		double dVal = *(double*)&intVal;
															#line 1335 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		Tuple t;
															#line 1336 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		t.append(dVal);
															#line 1337 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		data->stack.push(t.pack());
															#line 1339 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (!static_cast<CallActor26*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor26State(); static_cast<CallActor26*>(this)->destroy(); return 0; }
															#line 16358 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		new (&static_cast<CallActor26*>(this)->SAV< Void >::value()) Void(Void());
		this->~CallActor26State();
		static_cast<CallActor26*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Standalone<StringRef> && s1,int loopDepth) 
	{
															#line 1328 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		Standalone<StringRef> dBytes = Tuple::unpack(s1).getString(0);
															#line 1329 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		ASSERT(dBytes.size() == 8);
															#line 1331 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		int64_t intVal = *(int64_t*)dBytes.begin();
															#line 1332 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		intVal = bigEndian64(intVal);
															#line 1333 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		double dVal = *(double*)&intVal;
															#line 1335 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		Tuple t;
															#line 1336 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		t.append(dVal);
															#line 1337 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		data->stack.push(t.pack());
															#line 1339 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (!static_cast<CallActor26*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor26State(); static_cast<CallActor26*>(this)->destroy(); return 0; }
															#line 16386 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		new (&static_cast<CallActor26*>(this)->SAV< Void >::value()) Void(Void());
		this->~CallActor26State();
		static_cast<CallActor26*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Standalone<StringRef> const& s1,int loopDepth) 
	{
		loopDepth = a_body1cont1(s1, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Standalone<StringRef> && s1,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(s1), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CallActor26*>(this)->actor_wait_state > 0) static_cast<CallActor26*>(this)->actor_wait_state = 0;
		static_cast<CallActor26*>(this)->ActorCallback< CallActor26, 0, Standalone<StringRef> >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor26, 0, Standalone<StringRef> >*,Standalone<StringRef> const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor26*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CallActor26, 0, Standalone<StringRef> >*,Standalone<StringRef> && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor26*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CallActor26, 0, Standalone<StringRef> >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor26*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1322 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Reference<FlowTesterData> data;
															#line 1322 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Reference<InstructionData> instruction;
															#line 16473 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
};
// This generated class is to be used only via call()
															#line 1322 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
class CallActor26 final : public Actor<Void>, public ActorCallback< CallActor26, 0, Standalone<StringRef> >, public FastAllocated<CallActor26>, public CallActor26State<CallActor26> {
															#line 16478 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
public:
	using FastAllocated<CallActor26>::operator new;
	using FastAllocated<CallActor26>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9317237842190798848UL, 4308047855804869376UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CallActor26, 0, Standalone<StringRef> >;
															#line 1322 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	CallActor26(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 16495 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		 : Actor<Void>(),
		   CallActor26State<CallActor26>(data, instruction),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10719178397035329536UL, 4438558207666554368UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor26*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("call");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CallActor26, 0, Standalone<StringRef> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1322 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
[[nodiscard]] static Future<Void> call( Reference<FlowTesterData> const& data, Reference<InstructionData> const& instruction ) {
															#line 1322 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	return Future<Void>(new CallActor26(data, instruction));
															#line 16527 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
}

#line 1341 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
};
const char* EncodeDoubleFunc::name = "ENCODE_DOUBLE";
REGISTER_INSTRUCTION_FUNC(EncodeDoubleFunc);

// DECODE_FLOAT
struct DecodeFloatFunc : InstructionFunc {
	static const char* name;

																#line 16539 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
// This generated class is to be used only via call()
															#line 1349 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
template <class CallActor27>
															#line 1349 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
class CallActor27State {
															#line 16545 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
public:
															#line 1349 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	CallActor27State(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 1349 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
															#line 1349 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		 : data(data),
															#line 1349 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		   instruction(instruction)
															#line 16554 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
	{
		fdb_probe_actor_create("call", reinterpret_cast<unsigned long>(this));

	}
	~CallActor27State() 
	{
		fdb_probe_actor_destroy("call", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1350 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			std::vector<StackItem> items = data->stack.pop();
															#line 1351 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (items.size() != 1)
															#line 16571 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			{
															#line 1352 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
				if (!static_cast<CallActor27*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor27State(); static_cast<CallActor27*>(this)->destroy(); return 0; }
															#line 16575 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
				new (&static_cast<CallActor27*>(this)->SAV< Void >::value()) Void(Void());
				this->~CallActor27State();
				static_cast<CallActor27*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 1354 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			StrictFuture<Standalone<StringRef>> __when_expr_0 = items[0].value;
															#line 1354 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (static_cast<CallActor27*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 16585 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CallActor27*>(this)->actor_wait_state = 1;
															#line 1354 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CallActor27, 0, Standalone<StringRef> >*>(static_cast<CallActor27*>(this)));
															#line 16590 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CallActor27State();
		static_cast<CallActor27*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Standalone<StringRef> const& s1,int loopDepth) 
	{
															#line 1355 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		float fVal = Tuple::unpack(s1).getFloat(0);
															#line 1356 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		int32_t intVal = *(int32_t*)&fVal;
															#line 1357 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		intVal = bigEndian32(intVal);
															#line 1359 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		Tuple t;
															#line 1360 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		t.append(StringRef((uint8_t*)&intVal, 4), false);
															#line 1361 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		data->stack.push(t.pack());
															#line 1363 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (!static_cast<CallActor27*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor27State(); static_cast<CallActor27*>(this)->destroy(); return 0; }
															#line 16625 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		new (&static_cast<CallActor27*>(this)->SAV< Void >::value()) Void(Void());
		this->~CallActor27State();
		static_cast<CallActor27*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Standalone<StringRef> && s1,int loopDepth) 
	{
															#line 1355 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		float fVal = Tuple::unpack(s1).getFloat(0);
															#line 1356 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		int32_t intVal = *(int32_t*)&fVal;
															#line 1357 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		intVal = bigEndian32(intVal);
															#line 1359 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		Tuple t;
															#line 1360 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		t.append(StringRef((uint8_t*)&intVal, 4), false);
															#line 1361 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		data->stack.push(t.pack());
															#line 1363 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (!static_cast<CallActor27*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor27State(); static_cast<CallActor27*>(this)->destroy(); return 0; }
															#line 16649 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		new (&static_cast<CallActor27*>(this)->SAV< Void >::value()) Void(Void());
		this->~CallActor27State();
		static_cast<CallActor27*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Standalone<StringRef> const& s1,int loopDepth) 
	{
		loopDepth = a_body1cont1(s1, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Standalone<StringRef> && s1,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(s1), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CallActor27*>(this)->actor_wait_state > 0) static_cast<CallActor27*>(this)->actor_wait_state = 0;
		static_cast<CallActor27*>(this)->ActorCallback< CallActor27, 0, Standalone<StringRef> >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor27, 0, Standalone<StringRef> >*,Standalone<StringRef> const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor27*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CallActor27, 0, Standalone<StringRef> >*,Standalone<StringRef> && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor27*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CallActor27, 0, Standalone<StringRef> >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor27*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1349 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Reference<FlowTesterData> data;
															#line 1349 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Reference<InstructionData> instruction;
															#line 16736 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
};
// This generated class is to be used only via call()
															#line 1349 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
class CallActor27 final : public Actor<Void>, public ActorCallback< CallActor27, 0, Standalone<StringRef> >, public FastAllocated<CallActor27>, public CallActor27State<CallActor27> {
															#line 16741 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
public:
	using FastAllocated<CallActor27>::operator new;
	using FastAllocated<CallActor27>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9317237842190798848UL, 4308047855804869376UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CallActor27, 0, Standalone<StringRef> >;
															#line 1349 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	CallActor27(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 16758 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		 : Actor<Void>(),
		   CallActor27State<CallActor27>(data, instruction),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8970087501170865152UL, 18103189525278293248UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor27*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("call");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CallActor27, 0, Standalone<StringRef> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1349 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
[[nodiscard]] static Future<Void> call( Reference<FlowTesterData> const& data, Reference<InstructionData> const& instruction ) {
															#line 1349 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	return Future<Void>(new CallActor27(data, instruction));
															#line 16790 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
}

#line 1365 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
};
const char* DecodeFloatFunc::name = "DECODE_FLOAT";
REGISTER_INSTRUCTION_FUNC(DecodeFloatFunc);

// DECODE_DOUBLE
struct DecodeDoubleFunc : InstructionFunc {
	static const char* name;

																#line 16802 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
// This generated class is to be used only via call()
															#line 1373 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
template <class CallActor28>
															#line 1373 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
class CallActor28State {
															#line 16808 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
public:
															#line 1373 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	CallActor28State(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 1373 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
															#line 1373 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		 : data(data),
															#line 1373 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		   instruction(instruction)
															#line 16817 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
	{
		fdb_probe_actor_create("call", reinterpret_cast<unsigned long>(this));

	}
	~CallActor28State() 
	{
		fdb_probe_actor_destroy("call", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1374 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			std::vector<StackItem> items = data->stack.pop();
															#line 1375 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (items.size() != 1)
															#line 16834 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			{
															#line 1376 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
				if (!static_cast<CallActor28*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor28State(); static_cast<CallActor28*>(this)->destroy(); return 0; }
															#line 16838 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
				new (&static_cast<CallActor28*>(this)->SAV< Void >::value()) Void(Void());
				this->~CallActor28State();
				static_cast<CallActor28*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 1378 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			StrictFuture<Standalone<StringRef>> __when_expr_0 = items[0].value;
															#line 1378 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (static_cast<CallActor28*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 16848 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CallActor28*>(this)->actor_wait_state = 1;
															#line 1378 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CallActor28, 0, Standalone<StringRef> >*>(static_cast<CallActor28*>(this)));
															#line 16853 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CallActor28State();
		static_cast<CallActor28*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Standalone<StringRef> const& s1,int loopDepth) 
	{
															#line 1379 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		double dVal = Tuple::unpack(s1).getDouble(0);
															#line 1380 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		int64_t intVal = *(int64_t*)&dVal;
															#line 1381 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		intVal = bigEndian64(intVal);
															#line 1383 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		Tuple t;
															#line 1384 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		t.append(StringRef((uint8_t*)&intVal, 8), false);
															#line 1385 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		data->stack.push(t.pack());
															#line 1386 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (!static_cast<CallActor28*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor28State(); static_cast<CallActor28*>(this)->destroy(); return 0; }
															#line 16888 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		new (&static_cast<CallActor28*>(this)->SAV< Void >::value()) Void(Void());
		this->~CallActor28State();
		static_cast<CallActor28*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Standalone<StringRef> && s1,int loopDepth) 
	{
															#line 1379 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		double dVal = Tuple::unpack(s1).getDouble(0);
															#line 1380 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		int64_t intVal = *(int64_t*)&dVal;
															#line 1381 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		intVal = bigEndian64(intVal);
															#line 1383 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		Tuple t;
															#line 1384 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		t.append(StringRef((uint8_t*)&intVal, 8), false);
															#line 1385 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		data->stack.push(t.pack());
															#line 1386 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (!static_cast<CallActor28*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor28State(); static_cast<CallActor28*>(this)->destroy(); return 0; }
															#line 16912 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		new (&static_cast<CallActor28*>(this)->SAV< Void >::value()) Void(Void());
		this->~CallActor28State();
		static_cast<CallActor28*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Standalone<StringRef> const& s1,int loopDepth) 
	{
		loopDepth = a_body1cont1(s1, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Standalone<StringRef> && s1,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(s1), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CallActor28*>(this)->actor_wait_state > 0) static_cast<CallActor28*>(this)->actor_wait_state = 0;
		static_cast<CallActor28*>(this)->ActorCallback< CallActor28, 0, Standalone<StringRef> >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor28, 0, Standalone<StringRef> >*,Standalone<StringRef> const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor28*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CallActor28, 0, Standalone<StringRef> >*,Standalone<StringRef> && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor28*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CallActor28, 0, Standalone<StringRef> >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor28*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1373 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Reference<FlowTesterData> data;
															#line 1373 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Reference<InstructionData> instruction;
															#line 16999 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
};
// This generated class is to be used only via call()
															#line 1373 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
class CallActor28 final : public Actor<Void>, public ActorCallback< CallActor28, 0, Standalone<StringRef> >, public FastAllocated<CallActor28>, public CallActor28State<CallActor28> {
															#line 17004 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
public:
	using FastAllocated<CallActor28>::operator new;
	using FastAllocated<CallActor28>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9317237842190798848UL, 4308047855804869376UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CallActor28, 0, Standalone<StringRef> >;
															#line 1373 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	CallActor28(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 17021 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		 : Actor<Void>(),
		   CallActor28State<CallActor28>(data, instruction),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14967666843508415488UL, 14654547164090821376UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor28*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("call");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CallActor28, 0, Standalone<StringRef> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1373 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
[[nodiscard]] static Future<Void> call( Reference<FlowTesterData> const& data, Reference<InstructionData> const& instruction ) {
															#line 1373 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	return Future<Void>(new CallActor28(data, instruction));
															#line 17053 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
}

#line 1388 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
};
const char* DecodeDoubleFunc::name = "DECODE_DOUBLE";
REGISTER_INSTRUCTION_FUNC(DecodeDoubleFunc);

// Thread Operations
// START_THREAD
struct StartThreadFunc : InstructionFunc {
	static const char* name;

																#line 17066 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
// This generated class is to be used only via call()
															#line 1397 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
template <class CallActor29>
															#line 1397 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
class CallActor29State {
															#line 17072 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
public:
															#line 1397 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	CallActor29State(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 1397 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
															#line 1397 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		 : data(data),
															#line 1397 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		   instruction(instruction),
															#line 1398 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		   items(data->stack.pop())
															#line 17083 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
	{
		fdb_probe_actor_create("call", reinterpret_cast<unsigned long>(this));

	}
	~CallActor29State() 
	{
		fdb_probe_actor_destroy("call", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1399 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (items.size() != 1)
															#line 17098 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			{
															#line 1400 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
				if (!static_cast<CallActor29*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor29State(); static_cast<CallActor29*>(this)->destroy(); return 0; }
															#line 17102 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
				new (&static_cast<CallActor29*>(this)->SAV< Void >::value()) Void(Void());
				this->~CallActor29State();
				static_cast<CallActor29*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 1402 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			StrictFuture<Standalone<StringRef>> __when_expr_0 = items[0].value;
															#line 1402 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (static_cast<CallActor29*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17112 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CallActor29*>(this)->actor_wait_state = 1;
															#line 1402 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CallActor29, 0, Standalone<StringRef> >*>(static_cast<CallActor29*>(this)));
															#line 17117 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CallActor29State();
		static_cast<CallActor29*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Standalone<StringRef> const& s1,int loopDepth) 
	{
															#line 1403 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		prefix = Tuple::unpack(s1).getString(0);
															#line 1406 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		Reference<FlowTesterData> newData = Reference<FlowTesterData>(new FlowTesterData(data->api));
															#line 1407 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		data->subThreads.push_back(runTest(newData, data->db, prefix));
															#line 1409 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (!static_cast<CallActor29*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor29State(); static_cast<CallActor29*>(this)->destroy(); return 0; }
															#line 17146 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		new (&static_cast<CallActor29*>(this)->SAV< Void >::value()) Void(Void());
		this->~CallActor29State();
		static_cast<CallActor29*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Standalone<StringRef> && s1,int loopDepth) 
	{
															#line 1403 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		prefix = Tuple::unpack(s1).getString(0);
															#line 1406 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		Reference<FlowTesterData> newData = Reference<FlowTesterData>(new FlowTesterData(data->api));
															#line 1407 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		data->subThreads.push_back(runTest(newData, data->db, prefix));
															#line 1409 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (!static_cast<CallActor29*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor29State(); static_cast<CallActor29*>(this)->destroy(); return 0; }
															#line 17164 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		new (&static_cast<CallActor29*>(this)->SAV< Void >::value()) Void(Void());
		this->~CallActor29State();
		static_cast<CallActor29*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Standalone<StringRef> const& s1,int loopDepth) 
	{
		loopDepth = a_body1cont1(s1, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Standalone<StringRef> && s1,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(s1), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CallActor29*>(this)->actor_wait_state > 0) static_cast<CallActor29*>(this)->actor_wait_state = 0;
		static_cast<CallActor29*>(this)->ActorCallback< CallActor29, 0, Standalone<StringRef> >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor29, 0, Standalone<StringRef> >*,Standalone<StringRef> const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor29*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CallActor29, 0, Standalone<StringRef> >*,Standalone<StringRef> && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor29*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CallActor29, 0, Standalone<StringRef> >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor29*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1397 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Reference<FlowTesterData> data;
															#line 1397 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Reference<InstructionData> instruction;
															#line 1398 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	std::vector<StackItem> items;
															#line 1403 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Standalone<StringRef> prefix;
															#line 17255 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
};
// This generated class is to be used only via call()
															#line 1397 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
class CallActor29 final : public Actor<Void>, public ActorCallback< CallActor29, 0, Standalone<StringRef> >, public FastAllocated<CallActor29>, public CallActor29State<CallActor29> {
															#line 17260 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
public:
	using FastAllocated<CallActor29>::operator new;
	using FastAllocated<CallActor29>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9317237842190798848UL, 4308047855804869376UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CallActor29, 0, Standalone<StringRef> >;
															#line 1397 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	CallActor29(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 17277 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		 : Actor<Void>(),
		   CallActor29State<CallActor29>(data, instruction),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7102676801709485056UL, 9656805009988847616UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor29*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("call");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CallActor29, 0, Standalone<StringRef> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1397 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
[[nodiscard]] static Future<Void> call( Reference<FlowTesterData> const& data, Reference<InstructionData> const& instruction ) {
															#line 1397 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	return Future<Void>(new CallActor29(data, instruction));
															#line 17309 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
}

#line 1411 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
};
const char* StartThreadFunc::name = "START_THREAD";
REGISTER_INSTRUCTION_FUNC(StartThreadFunc);

															#line 17317 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
namespace {
// This generated class is to be used only via read()
															#line 1415 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
template <class Function, class ReadActor>
															#line 1415 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
class ReadActorState {
															#line 17324 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
public:
															#line 1415 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	ReadActorState(Reference<Database> const& db,Function const& func) 
															#line 1415 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
															#line 1415 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		 : db(db),
															#line 1415 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		   func(func),
															#line 1418 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		   tr(db->createTransaction())
															#line 17335 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
	{
		fdb_probe_actor_create("read", reinterpret_cast<unsigned long>(this));

	}
	~ReadActorState() 
	{
		fdb_probe_actor_destroy("read", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1419 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			;
															#line 17350 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ReadActorState();
		static_cast<ReadActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 1421 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			StrictFuture<decltype(std::declval<Function>()(Reference<ReadTransaction>()).getValue())> __when_expr_0 = func(tr);
															#line 1421 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (static_cast<ReadActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 17383 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ReadActor*>(this)->actor_wait_state = 1;
															#line 1421 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ReadActor, 0, decltype(std::declval<Function>()(Reference<ReadTransaction>()).getValue()) >*>(static_cast<ReadActor*>(this)));
															#line 17388 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1424 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr->onError(e);
															#line 1424 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (static_cast<ReadActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 17412 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<ReadActor*>(this)->actor_wait_state = 2;
															#line 1424 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ReadActor, 1, Void >*>(static_cast<ReadActor*>(this)));
															#line 17417 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 1422 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (!static_cast<ReadActor*>(this)->SAV<decltype(std::declval<Function>()(Reference<ReadTransaction>()).getValue())>::futures) { (void)(result); this->~ReadActorState(); static_cast<ReadActor*>(this)->destroy(); return 0; }
															#line 17432 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		new (&static_cast<ReadActor*>(this)->SAV< decltype(std::declval<Function>()(Reference<ReadTransaction>()).getValue()) >::value()) decltype(std::declval<Function>()(Reference<ReadTransaction>()).getValue())(std::move(result)); // state_var_RVO
		this->~ReadActorState();
		static_cast<ReadActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(decltype(std::declval<Function>()(Reference<ReadTransaction>()).getValue()) const& __result,int loopDepth) 
	{
															#line 1421 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		result = __result;
															#line 17444 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(decltype(std::declval<Function>()(Reference<ReadTransaction>()).getValue()) && __result,int loopDepth) 
	{
		result = std::move(__result);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ReadActor*>(this)->actor_wait_state > 0) static_cast<ReadActor*>(this)->actor_wait_state = 0;
		static_cast<ReadActor*>(this)->ActorCallback< ReadActor, 0, decltype(std::declval<Function>()(Reference<ReadTransaction>()).getValue()) >::remove();

	}
	void a_callback_fire(ActorCallback< ReadActor, 0, decltype(std::declval<Function>()(Reference<ReadTransaction>()).getValue()) >*,decltype(std::declval<Function>()(Reference<ReadTransaction>()).getValue()) const& value) 
	{
		fdb_probe_actor_enter("read", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("read", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ReadActor, 0, decltype(std::declval<Function>()(Reference<ReadTransaction>()).getValue()) >*,decltype(std::declval<Function>()(Reference<ReadTransaction>()).getValue()) && value) 
	{
		fdb_probe_actor_enter("read", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("read", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ReadActor, 0, decltype(std::declval<Function>()(Reference<ReadTransaction>()).getValue()) >*,Error err) 
	{
		fdb_probe_actor_enter("read", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("read", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ReadActor*>(this)->actor_wait_state > 0) static_cast<ReadActor*>(this)->actor_wait_state = 0;
		static_cast<ReadActor*>(this)->ActorCallback< ReadActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ReadActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("read", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("read", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ReadActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("read", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("read", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ReadActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("read", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("read", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1415 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Reference<Database> db;
															#line 1415 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Function func;
															#line 1418 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Reference<ReadTransaction> tr;
															#line 1421 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	decltype(std::declval<Function>()(Reference<ReadTransaction>()).getValue()) result;
															#line 17614 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
};
// This generated class is to be used only via read()
															#line 1415 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
template <class Function>
															#line 1415 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
class ReadActor final : public Actor<decltype(std::declval<Function>()(Reference<ReadTransaction>()).getValue())>, public ActorCallback< ReadActor<Function>, 0, decltype(std::declval<Function>()(Reference<ReadTransaction>()).getValue()) >, public ActorCallback< ReadActor<Function>, 1, Void >, public FastAllocated<ReadActor<Function>>, public ReadActorState<Function, ReadActor<Function>> {
															#line 17621 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
public:
	using FastAllocated<ReadActor<Function>>::operator new;
	using FastAllocated<ReadActor<Function>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9773162892405291776UL, 3894654623157241856UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<decltype(std::declval<Function>()(Reference<ReadTransaction>()).getValue())>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ReadActor<Function>, 0, decltype(std::declval<Function>()(Reference<ReadTransaction>()).getValue()) >;
friend struct ActorCallback< ReadActor<Function>, 1, Void >;
															#line 1415 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	ReadActor(Reference<Database> const& db,Function const& func) 
															#line 17639 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		 : Actor<decltype(std::declval<Function>()(Reference<ReadTransaction>()).getValue())>(),
		   ReadActorState<Function, ReadActor<Function>>(db, func),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("read", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3377648328873480704UL, 6210503387287458048UL);
		ActorExecutionContextHelper __helper(static_cast<ReadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("read");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("read", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ReadActor<Function>, 0, decltype(std::declval<Function>()(Reference<ReadTransaction>()).getValue()) >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ReadActor<Function>, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1415 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
template <class Function>
															#line 1415 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
[[nodiscard]] Future<decltype(std::declval<Function>()(Reference<ReadTransaction>()).getValue())> read( Reference<Database> const& db, Function const& func ) {
															#line 1415 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	return Future<decltype(std::declval<Function>()(Reference<ReadTransaction>()).getValue())>(new ReadActor<Function>(db, func));
															#line 17675 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
}

#line 1428 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"

// WAIT_EMPTY
struct WaitEmptyFunc : InstructionFunc {
	static const char* name;

																#line 17684 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
// This generated class is to be used only via call()
															#line 1433 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
template <class CallActor30>
															#line 1433 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
class CallActor30State {
															#line 17690 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
public:
															#line 1433 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	CallActor30State(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 1433 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
															#line 1433 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		 : data(data),
															#line 1433 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		   instruction(instruction),
															#line 1434 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		   items(data->stack.pop())
															#line 17701 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
	{
		fdb_probe_actor_create("call", reinterpret_cast<unsigned long>(this));

	}
	~CallActor30State() 
	{
		fdb_probe_actor_destroy("call", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1435 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (items.size() != 1)
															#line 17716 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			{
															#line 1436 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
				if (!static_cast<CallActor30*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor30State(); static_cast<CallActor30*>(this)->destroy(); return 0; }
															#line 17720 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
				new (&static_cast<CallActor30*>(this)->SAV< Void >::value()) Void(Void());
				this->~CallActor30State();
				static_cast<CallActor30*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 1438 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			StrictFuture<Standalone<StringRef>> __when_expr_0 = items[0].value;
															#line 1438 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (static_cast<CallActor30*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17730 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CallActor30*>(this)->actor_wait_state = 1;
															#line 1438 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CallActor30, 0, Standalone<StringRef> >*>(static_cast<CallActor30*>(this)));
															#line 17735 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CallActor30State();
		static_cast<CallActor30*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Standalone<StringRef> const& s1,int loopDepth) 
	{
															#line 1439 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		Standalone<StringRef> prefix = Tuple::unpack(s1).getString(0);
															#line 1442 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		StrictFuture<Void> __when_expr_1 = read(data->db, [=](Reference<ReadTransaction> tr) -> Future<Void> { return checkEmptyPrefix(tr, prefix); });
															#line 1442 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (static_cast<CallActor30*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17762 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CallActor30*>(this)->actor_wait_state = 2;
															#line 1442 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CallActor30, 1, Void >*>(static_cast<CallActor30*>(this)));
															#line 17767 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Standalone<StringRef> && s1,int loopDepth) 
	{
															#line 1439 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		Standalone<StringRef> prefix = Tuple::unpack(s1).getString(0);
															#line 1442 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		StrictFuture<Void> __when_expr_1 = read(data->db, [=](Reference<ReadTransaction> tr) -> Future<Void> { return checkEmptyPrefix(tr, prefix); });
															#line 1442 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (static_cast<CallActor30*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17780 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CallActor30*>(this)->actor_wait_state = 2;
															#line 1442 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CallActor30, 1, Void >*>(static_cast<CallActor30*>(this)));
															#line 17785 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Standalone<StringRef> const& s1,int loopDepth) 
	{
		loopDepth = a_body1cont1(s1, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Standalone<StringRef> && s1,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(s1), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CallActor30*>(this)->actor_wait_state > 0) static_cast<CallActor30*>(this)->actor_wait_state = 0;
		static_cast<CallActor30*>(this)->ActorCallback< CallActor30, 0, Standalone<StringRef> >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor30, 0, Standalone<StringRef> >*,Standalone<StringRef> const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor30*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CallActor30, 0, Standalone<StringRef> >*,Standalone<StringRef> && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor30*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CallActor30, 0, Standalone<StringRef> >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor30*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 1445 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (!static_cast<CallActor30*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor30State(); static_cast<CallActor30*>(this)->destroy(); return 0; }
															#line 17869 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		new (&static_cast<CallActor30*>(this)->SAV< Void >::value()) Void(Void());
		this->~CallActor30State();
		static_cast<CallActor30*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 1445 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (!static_cast<CallActor30*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor30State(); static_cast<CallActor30*>(this)->destroy(); return 0; }
															#line 17881 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		new (&static_cast<CallActor30*>(this)->SAV< Void >::value()) Void(Void());
		this->~CallActor30State();
		static_cast<CallActor30*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CallActor30*>(this)->actor_wait_state > 0) static_cast<CallActor30*>(this)->actor_wait_state = 0;
		static_cast<CallActor30*>(this)->ActorCallback< CallActor30, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor30, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor30*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CallActor30, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor30*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CallActor30, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor30*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1433 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Reference<FlowTesterData> data;
															#line 1433 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Reference<InstructionData> instruction;
															#line 1434 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	std::vector<StackItem> items;
															#line 17970 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
};
// This generated class is to be used only via call()
															#line 1433 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
class CallActor30 final : public Actor<Void>, public ActorCallback< CallActor30, 0, Standalone<StringRef> >, public ActorCallback< CallActor30, 1, Void >, public FastAllocated<CallActor30>, public CallActor30State<CallActor30> {
															#line 17975 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
public:
	using FastAllocated<CallActor30>::operator new;
	using FastAllocated<CallActor30>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9317237842190798848UL, 4308047855804869376UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CallActor30, 0, Standalone<StringRef> >;
friend struct ActorCallback< CallActor30, 1, Void >;
															#line 1433 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	CallActor30(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 17993 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		 : Actor<Void>(),
		   CallActor30State<CallActor30>(data, instruction),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1734496403516867072UL, 11248655684985797120UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor30*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("call");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CallActor30, 0, Standalone<StringRef> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CallActor30, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1433 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
[[nodiscard]] static Future<Void> call( Reference<FlowTesterData> const& data, Reference<InstructionData> const& instruction ) {
															#line 1433 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	return Future<Void>(new CallActor30(data, instruction));
															#line 18026 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
}

#line 1447 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"

private:
																#line 18032 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
// This generated class is to be used only via checkEmptyPrefix()
															#line 1449 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
template <class CheckEmptyPrefixActor>
															#line 1449 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
class CheckEmptyPrefixActorState {
															#line 18038 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
public:
															#line 1449 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	CheckEmptyPrefixActorState(Reference<ReadTransaction> const& tr,Standalone<StringRef> const& prefix) 
															#line 1449 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
															#line 1449 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		 : tr(tr),
															#line 1449 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		   prefix(prefix)
															#line 18047 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
	{
		fdb_probe_actor_create("checkEmptyPrefix", reinterpret_cast<unsigned long>(this));

	}
	~CheckEmptyPrefixActorState() 
	{
		fdb_probe_actor_destroy("checkEmptyPrefix", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1450 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			StrictFuture<FDBStandalone<RangeResultRef>> __when_expr_0 = tr->getRange(KeyRangeRef(prefix, strinc(prefix)), 1);
															#line 1450 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (static_cast<CheckEmptyPrefixActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 18064 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CheckEmptyPrefixActor*>(this)->actor_wait_state = 1;
															#line 1450 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckEmptyPrefixActor, 0, FDBStandalone<RangeResultRef> >*>(static_cast<CheckEmptyPrefixActor*>(this)));
															#line 18069 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckEmptyPrefixActorState();
		static_cast<CheckEmptyPrefixActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(FDBStandalone<RangeResultRef> const& results,int loopDepth) 
	{
															#line 1451 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (results.size() > 0)
															#line 18092 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		{
															#line 1452 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			return a_body1Catch1(not_committed(), loopDepth);
															#line 18096 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		}
															#line 1454 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (!static_cast<CheckEmptyPrefixActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckEmptyPrefixActorState(); static_cast<CheckEmptyPrefixActor*>(this)->destroy(); return 0; }
															#line 18100 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		new (&static_cast<CheckEmptyPrefixActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CheckEmptyPrefixActorState();
		static_cast<CheckEmptyPrefixActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(FDBStandalone<RangeResultRef> && results,int loopDepth) 
	{
															#line 1451 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (results.size() > 0)
															#line 18112 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		{
															#line 1452 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			return a_body1Catch1(not_committed(), loopDepth);
															#line 18116 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		}
															#line 1454 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (!static_cast<CheckEmptyPrefixActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckEmptyPrefixActorState(); static_cast<CheckEmptyPrefixActor*>(this)->destroy(); return 0; }
															#line 18120 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		new (&static_cast<CheckEmptyPrefixActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CheckEmptyPrefixActorState();
		static_cast<CheckEmptyPrefixActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(FDBStandalone<RangeResultRef> const& results,int loopDepth) 
	{
		loopDepth = a_body1cont1(results, loopDepth);

		return loopDepth;
	}
	int a_body1when1(FDBStandalone<RangeResultRef> && results,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(results), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckEmptyPrefixActor*>(this)->actor_wait_state > 0) static_cast<CheckEmptyPrefixActor*>(this)->actor_wait_state = 0;
		static_cast<CheckEmptyPrefixActor*>(this)->ActorCallback< CheckEmptyPrefixActor, 0, FDBStandalone<RangeResultRef> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckEmptyPrefixActor, 0, FDBStandalone<RangeResultRef> >*,FDBStandalone<RangeResultRef> const& value) 
	{
		fdb_probe_actor_enter("checkEmptyPrefix", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckEmptyPrefixActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkEmptyPrefix", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckEmptyPrefixActor, 0, FDBStandalone<RangeResultRef> >*,FDBStandalone<RangeResultRef> && value) 
	{
		fdb_probe_actor_enter("checkEmptyPrefix", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckEmptyPrefixActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkEmptyPrefix", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckEmptyPrefixActor, 0, FDBStandalone<RangeResultRef> >*,Error err) 
	{
		fdb_probe_actor_enter("checkEmptyPrefix", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckEmptyPrefixActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkEmptyPrefix", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1449 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Reference<ReadTransaction> tr;
															#line 1449 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Standalone<StringRef> prefix;
															#line 18207 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
};
// This generated class is to be used only via checkEmptyPrefix()
															#line 1449 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
class CheckEmptyPrefixActor final : public Actor<Void>, public ActorCallback< CheckEmptyPrefixActor, 0, FDBStandalone<RangeResultRef> >, public FastAllocated<CheckEmptyPrefixActor>, public CheckEmptyPrefixActorState<CheckEmptyPrefixActor> {
															#line 18212 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
public:
	using FastAllocated<CheckEmptyPrefixActor>::operator new;
	using FastAllocated<CheckEmptyPrefixActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14613377013399832064UL, 8955832163398787072UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckEmptyPrefixActor, 0, FDBStandalone<RangeResultRef> >;
															#line 1449 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	CheckEmptyPrefixActor(Reference<ReadTransaction> const& tr,Standalone<StringRef> const& prefix) 
															#line 18229 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		 : Actor<Void>(),
		   CheckEmptyPrefixActorState<CheckEmptyPrefixActor>(tr, prefix),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkEmptyPrefix", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2706872653385050880UL, 9867639705385673984UL);
		ActorExecutionContextHelper __helper(static_cast<CheckEmptyPrefixActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkEmptyPrefix");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkEmptyPrefix", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckEmptyPrefixActor, 0, FDBStandalone<RangeResultRef> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1449 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
[[nodiscard]] static Future<Void> checkEmptyPrefix( Reference<ReadTransaction> const& tr, Standalone<StringRef> const& prefix ) {
															#line 1449 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	return Future<Void>(new CheckEmptyPrefixActor(tr, prefix));
															#line 18261 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
}

#line 1456 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
};
const char* WaitEmptyFunc::name = "WAIT_EMPTY";
REGISTER_INSTRUCTION_FUNC(WaitEmptyFunc);

// DISABLE_WRITE_CONFLICT
struct DisableWriteConflictFunc : InstructionFunc {
	static const char* name;

	static Future<Void> call(Reference<FlowTesterData> const& data, Reference<InstructionData> const& instruction) {
		if (instruction->tr) {
			instruction->tr->setOption(FDBTransactionOption::FDB_TR_OPTION_NEXT_WRITE_NO_WRITE_CONFLICT_RANGE);
		}
		return Void();
	}
};
const char* DisableWriteConflictFunc::name = "DISABLE_WRITE_CONFLICT";
REGISTER_INSTRUCTION_FUNC(DisableWriteConflictFunc);

// READ_CONFLICT_KEY
struct ReadConflictKeyFunc : InstructionFunc {
	static const char* name;

																#line 18287 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
// This generated class is to be used only via call()
															#line 1478 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
template <class CallActor31>
															#line 1478 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
class CallActor31State {
															#line 18293 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
public:
															#line 1478 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	CallActor31State(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 1478 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
															#line 1478 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		 : data(data),
															#line 1478 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		   instruction(instruction),
															#line 1479 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		   items(data->stack.pop())
															#line 18304 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
	{
		fdb_probe_actor_create("call", reinterpret_cast<unsigned long>(this));

	}
	~CallActor31State() 
	{
		fdb_probe_actor_destroy("call", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1480 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (items.size() != 1)
															#line 18319 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			{
															#line 1481 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
				if (!static_cast<CallActor31*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor31State(); static_cast<CallActor31*>(this)->destroy(); return 0; }
															#line 18323 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
				new (&static_cast<CallActor31*>(this)->SAV< Void >::value()) Void(Void());
				this->~CallActor31State();
				static_cast<CallActor31*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 1483 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			StrictFuture<Standalone<StringRef>> __when_expr_0 = items[0].value;
															#line 1483 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (static_cast<CallActor31*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 18333 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CallActor31*>(this)->actor_wait_state = 1;
															#line 1483 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CallActor31, 0, Standalone<StringRef> >*>(static_cast<CallActor31*>(this)));
															#line 18338 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CallActor31State();
		static_cast<CallActor31*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Standalone<StringRef> const& s1,int loopDepth) 
	{
															#line 1484 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		key = Tuple::unpack(s1).getString(0);
															#line 1486 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		instruction->tr->addReadConflictKey(key);
															#line 1488 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		data->stack.pushTuple("SET_CONFLICT_KEY"_sr);
															#line 1489 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (!static_cast<CallActor31*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor31State(); static_cast<CallActor31*>(this)->destroy(); return 0; }
															#line 18367 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		new (&static_cast<CallActor31*>(this)->SAV< Void >::value()) Void(Void());
		this->~CallActor31State();
		static_cast<CallActor31*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Standalone<StringRef> && s1,int loopDepth) 
	{
															#line 1484 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		key = Tuple::unpack(s1).getString(0);
															#line 1486 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		instruction->tr->addReadConflictKey(key);
															#line 1488 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		data->stack.pushTuple("SET_CONFLICT_KEY"_sr);
															#line 1489 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (!static_cast<CallActor31*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor31State(); static_cast<CallActor31*>(this)->destroy(); return 0; }
															#line 18385 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		new (&static_cast<CallActor31*>(this)->SAV< Void >::value()) Void(Void());
		this->~CallActor31State();
		static_cast<CallActor31*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Standalone<StringRef> const& s1,int loopDepth) 
	{
		loopDepth = a_body1cont1(s1, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Standalone<StringRef> && s1,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(s1), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CallActor31*>(this)->actor_wait_state > 0) static_cast<CallActor31*>(this)->actor_wait_state = 0;
		static_cast<CallActor31*>(this)->ActorCallback< CallActor31, 0, Standalone<StringRef> >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor31, 0, Standalone<StringRef> >*,Standalone<StringRef> const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor31*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CallActor31, 0, Standalone<StringRef> >*,Standalone<StringRef> && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor31*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CallActor31, 0, Standalone<StringRef> >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor31*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1478 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Reference<FlowTesterData> data;
															#line 1478 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Reference<InstructionData> instruction;
															#line 1479 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	std::vector<StackItem> items;
															#line 1484 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Standalone<StringRef> key;
															#line 18476 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
};
// This generated class is to be used only via call()
															#line 1478 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
class CallActor31 final : public Actor<Void>, public ActorCallback< CallActor31, 0, Standalone<StringRef> >, public FastAllocated<CallActor31>, public CallActor31State<CallActor31> {
															#line 18481 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
public:
	using FastAllocated<CallActor31>::operator new;
	using FastAllocated<CallActor31>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9317237842190798848UL, 4308047855804869376UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CallActor31, 0, Standalone<StringRef> >;
															#line 1478 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	CallActor31(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 18498 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		 : Actor<Void>(),
		   CallActor31State<CallActor31>(data, instruction),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11705224089973412352UL, 13116687056052882176UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor31*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("call");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CallActor31, 0, Standalone<StringRef> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1478 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
[[nodiscard]] static Future<Void> call( Reference<FlowTesterData> const& data, Reference<InstructionData> const& instruction ) {
															#line 1478 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	return Future<Void>(new CallActor31(data, instruction));
															#line 18530 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
}

#line 1491 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
};
const char* ReadConflictKeyFunc::name = "READ_CONFLICT_KEY";
REGISTER_INSTRUCTION_FUNC(ReadConflictKeyFunc);

// WRITE_CONFLICT_KEY
struct WriteConflictKeyFunc : InstructionFunc {
	static const char* name;

																#line 18542 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
// This generated class is to be used only via call()
															#line 1499 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
template <class CallActor32>
															#line 1499 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
class CallActor32State {
															#line 18548 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
public:
															#line 1499 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	CallActor32State(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 1499 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
															#line 1499 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		 : data(data),
															#line 1499 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		   instruction(instruction),
															#line 1500 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		   items(data->stack.pop())
															#line 18559 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
	{
		fdb_probe_actor_create("call", reinterpret_cast<unsigned long>(this));

	}
	~CallActor32State() 
	{
		fdb_probe_actor_destroy("call", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1501 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (items.size() != 1)
															#line 18574 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			{
															#line 1502 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
				if (!static_cast<CallActor32*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor32State(); static_cast<CallActor32*>(this)->destroy(); return 0; }
															#line 18578 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
				new (&static_cast<CallActor32*>(this)->SAV< Void >::value()) Void(Void());
				this->~CallActor32State();
				static_cast<CallActor32*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 1504 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			StrictFuture<Standalone<StringRef>> __when_expr_0 = items[0].value;
															#line 1504 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (static_cast<CallActor32*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 18588 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CallActor32*>(this)->actor_wait_state = 1;
															#line 1504 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CallActor32, 0, Standalone<StringRef> >*>(static_cast<CallActor32*>(this)));
															#line 18593 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CallActor32State();
		static_cast<CallActor32*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Standalone<StringRef> const& s1,int loopDepth) 
	{
															#line 1505 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		key = Tuple::unpack(s1).getString(0);
															#line 1507 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		instruction->tr->addWriteConflictKey(key);
															#line 1509 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		data->stack.pushTuple("SET_CONFLICT_KEY"_sr);
															#line 1510 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (!static_cast<CallActor32*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor32State(); static_cast<CallActor32*>(this)->destroy(); return 0; }
															#line 18622 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		new (&static_cast<CallActor32*>(this)->SAV< Void >::value()) Void(Void());
		this->~CallActor32State();
		static_cast<CallActor32*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Standalone<StringRef> && s1,int loopDepth) 
	{
															#line 1505 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		key = Tuple::unpack(s1).getString(0);
															#line 1507 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		instruction->tr->addWriteConflictKey(key);
															#line 1509 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		data->stack.pushTuple("SET_CONFLICT_KEY"_sr);
															#line 1510 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (!static_cast<CallActor32*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor32State(); static_cast<CallActor32*>(this)->destroy(); return 0; }
															#line 18640 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		new (&static_cast<CallActor32*>(this)->SAV< Void >::value()) Void(Void());
		this->~CallActor32State();
		static_cast<CallActor32*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Standalone<StringRef> const& s1,int loopDepth) 
	{
		loopDepth = a_body1cont1(s1, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Standalone<StringRef> && s1,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(s1), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CallActor32*>(this)->actor_wait_state > 0) static_cast<CallActor32*>(this)->actor_wait_state = 0;
		static_cast<CallActor32*>(this)->ActorCallback< CallActor32, 0, Standalone<StringRef> >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor32, 0, Standalone<StringRef> >*,Standalone<StringRef> const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor32*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CallActor32, 0, Standalone<StringRef> >*,Standalone<StringRef> && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor32*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CallActor32, 0, Standalone<StringRef> >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor32*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1499 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Reference<FlowTesterData> data;
															#line 1499 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Reference<InstructionData> instruction;
															#line 1500 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	std::vector<StackItem> items;
															#line 1505 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	Standalone<StringRef> key;
															#line 18731 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
};
// This generated class is to be used only via call()
															#line 1499 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
class CallActor32 final : public Actor<Void>, public ActorCallback< CallActor32, 0, Standalone<StringRef> >, public FastAllocated<CallActor32>, public CallActor32State<CallActor32> {
															#line 18736 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
public:
	using FastAllocated<CallActor32>::operator new;
	using FastAllocated<CallActor32>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9317237842190798848UL, 4308047855804869376UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CallActor32, 0, Standalone<StringRef> >;
															#line 1499 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	CallActor32(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 18753 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		 : Actor<Void>(),
		   CallActor32State<CallActor32>(data, instruction),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11803163882220193792UL, 11938450498002317824UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor32*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("call");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CallActor32, 0, Standalone<StringRef> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1499 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
[[nodiscard]] static Future<Void> call( Reference<FlowTesterData> const& data, Reference<InstructionData> const& instruction ) {
															#line 1499 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	return Future<Void>(new CallActor32(data, instruction));
															#line 18785 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
}

#line 1512 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
};
const char* WriteConflictKeyFunc::name = "WRITE_CONFLICT_KEY";
REGISTER_INSTRUCTION_FUNC(WriteConflictKeyFunc);

// READ_CONFLICT_RANGE
struct ReadConflictRangeFunc : InstructionFunc {
	static const char* name;

																#line 18797 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
// This generated class is to be used only via call()
															#line 1520 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
template <class CallActor33>
															#line 1520 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
class CallActor33State {
															#line 18803 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
public:
															#line 1520 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
	CallActor33State(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 1520 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
															#line 1520 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		 : data(data),
															#line 1520 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		   instruction(instruction),
															#line 1521 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		   items(data->stack.pop(2))
															#line 18814 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
	{
		fdb_probe_actor_create("call", reinterpret_cast<unsigned long>(this));

	}
	~CallActor33State() 
	{
		fdb_probe_actor_destroy("call", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1522 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (items.size() != 2)
															#line 18829 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			{
															#line 1523 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
				if (!static_cast<CallActor33*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor33State(); static_cast<CallActor33*>(this)->destroy(); return 0; }
															#line 18833 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
				new (&static_cast<CallActor33*>(this)->SAV< Void >::value()) Void(Void());
				this->~CallActor33State();
				static_cast<CallActor33*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 1525 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			StrictFuture<Standalone<StringRef>> __when_expr_0 = items[0].value;
															#line 1525 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			if (static_cast<CallActor33*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 18843 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CallActor33*>(this)->actor_wait_state = 1;
															#line 1525 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CallActor33, 0, Standalone<StringRef> >*>(static_cast<CallActor33*>(this)));
															#line 18848 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CallActor33State();
		static_cast<CallActor33*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Standalone<StringRef> const& s1,int loopDepth) 
	{
															#line 1526 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		begin = Tuple::unpack(s1).getString(0);
															#line 1527 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		StrictFuture<Standalone<StringRef>> __when_expr_1 = items[1].value;
															#line 1527 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (static_cast<CallActor33*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 18875 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CallActor33*>(this)->actor_wait_state = 2;
															#line 1527 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CallActor33, 1, Standalone<StringRef> >*>(static_cast<CallActor33*>(this)));
															#line 18880 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Standalone<StringRef> && s1,int loopDepth) 
	{
															#line 1526 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		begin = Tuple::unpack(s1).getString(0);
															#line 1527 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		StrictFuture<Standalone<StringRef>> __when_expr_1 = items[1].value;
															#line 1527 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/Tester.actor.cpp"
		if (static_cast<CallActor33*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 18893 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/Tester.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CallActor33*>(this)->actor_wait_state = 2;
															#line 1527 "