#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
/*
 * DirectoryTester.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "Tester.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

using namespace FDB;

															#line 28 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
namespace {
// This generated class is to be used only via popTuples()
															#line 26 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
template <class PopTuplesActor>
															#line 26 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
class PopTuplesActorState {
															#line 35 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
public:
															#line 26 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	PopTuplesActorState(Reference<FlowTesterData> const& data,int const& count = 1) 
															#line 26 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
															#line 26 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		 : data(data),
															#line 26 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		   count(count),
															#line 27 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		   tuples()
															#line 46 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
	{
		fdb_probe_actor_create("popTuples", reinterpret_cast<unsigned long>(this));

	}
	~PopTuplesActorState() 
	{
		fdb_probe_actor_destroy("popTuples", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 29 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			;
															#line 61 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PopTuplesActorState();
		static_cast<PopTuplesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 45 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		if (!static_cast<PopTuplesActor*>(this)->SAV<std::vector<Tuple>>::futures) { (void)(tuples); this->~PopTuplesActorState(); static_cast<PopTuplesActor*>(this)->destroy(); return 0; }
															#line 84 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		new (&static_cast<PopTuplesActor*>(this)->SAV< std::vector<Tuple> >::value()) std::vector<Tuple>(std::move(tuples)); // state_var_RVO
		this->~PopTuplesActorState();
		static_cast<PopTuplesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 29 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		if (!(tuples.size() < count))
															#line 103 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 30 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		StrictFuture<Standalone<StringRef>> __when_expr_0 = data->stack.pop()[0].value;
															#line 30 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		if (static_cast<PopTuplesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 111 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<PopTuplesActor*>(this)->actor_wait_state = 1;
															#line 30 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PopTuplesActor, 0, Standalone<StringRef> >*>(static_cast<PopTuplesActor*>(this)));
															#line 116 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Standalone<StringRef> const& sizeStr,int loopDepth) 
	{
															#line 31 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		int size = Tuple::unpack(sizeStr).getInt(0);
															#line 33 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		tupleItems = data->stack.pop(size);
															#line 34 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		tuple = Tuple();
															#line 36 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		index = int();
															#line 37 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		index = 0;
															#line 146 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Standalone<StringRef> && sizeStr,int loopDepth) 
	{
															#line 31 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		int size = Tuple::unpack(sizeStr).getInt(0);
															#line 33 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		tupleItems = data->stack.pop(size);
															#line 34 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		tuple = Tuple();
															#line 36 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		index = int();
															#line 37 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		index = 0;
															#line 163 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Standalone<StringRef> const& sizeStr,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(sizeStr, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Standalone<StringRef> && sizeStr,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(sizeStr), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PopTuplesActor*>(this)->actor_wait_state > 0) static_cast<PopTuplesActor*>(this)->actor_wait_state = 0;
		static_cast<PopTuplesActor*>(this)->ActorCallback< PopTuplesActor, 0, Standalone<StringRef> >::remove();

	}
	void a_callback_fire(ActorCallback< PopTuplesActor, 0, Standalone<StringRef> >*,Standalone<StringRef> const& value) 
	{
		fdb_probe_actor_enter("popTuples", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PopTuplesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("popTuples", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PopTuplesActor, 0, Standalone<StringRef> >*,Standalone<StringRef> && value) 
	{
		fdb_probe_actor_enter("popTuples", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PopTuplesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("popTuples", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PopTuplesActor, 0, Standalone<StringRef> >*,Error err) 
	{
		fdb_probe_actor_enter("popTuples", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PopTuplesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("popTuples", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 42 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		tuples.push_back(tuple);
															#line 247 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1(int loopDepth) 
	{
															#line 37 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		if (!(index < tupleItems.size()))
															#line 263 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		{
			return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 38 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		StrictFuture<Standalone<StringRef>> __when_expr_1 = tupleItems[index].value;
															#line 38 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		if (static_cast<PopTuplesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 271 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<PopTuplesActor*>(this)->actor_wait_state = 2;
															#line 38 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PopTuplesActor, 1, Standalone<StringRef> >*>(static_cast<PopTuplesActor*>(this)));
															#line 276 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont1(Standalone<StringRef> const& itemStr,int loopDepth) 
	{
															#line 39 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		tuple.append(Tuple::unpack(itemStr));
															#line 37 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		++index;
															#line 300 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont1(Standalone<StringRef> && itemStr,int loopDepth) 
	{
															#line 39 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		tuple.append(Tuple::unpack(itemStr));
															#line 37 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		++index;
															#line 311 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when1(Standalone<StringRef> const& itemStr,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont1(itemStr, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when1(Standalone<StringRef> && itemStr,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont1(std::move(itemStr), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<PopTuplesActor*>(this)->actor_wait_state > 0) static_cast<PopTuplesActor*>(this)->actor_wait_state = 0;
		static_cast<PopTuplesActor*>(this)->ActorCallback< PopTuplesActor, 1, Standalone<StringRef> >::remove();

	}
	void a_callback_fire(ActorCallback< PopTuplesActor, 1, Standalone<StringRef> >*,Standalone<StringRef> const& value) 
	{
		fdb_probe_actor_enter("popTuples", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PopTuplesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("popTuples", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< PopTuplesActor, 1, Standalone<StringRef> >*,Standalone<StringRef> && value) 
	{
		fdb_probe_actor_enter("popTuples", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PopTuplesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("popTuples", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< PopTuplesActor, 1, Standalone<StringRef> >*,Error err) 
	{
		fdb_probe_actor_enter("popTuples", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PopTuplesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("popTuples", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 26 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	Reference<FlowTesterData> data;
															#line 26 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	int count;
															#line 27 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	std::vector<Tuple> tuples;
															#line 33 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	std::vector<StackItem> tupleItems;
															#line 34 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	Tuple tuple;
															#line 36 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	int index;
															#line 403 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
};
// This generated class is to be used only via popTuples()
															#line 26 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
class PopTuplesActor final : public Actor<std::vector<Tuple>>, public ActorCallback< PopTuplesActor, 0, Standalone<StringRef> >, public ActorCallback< PopTuplesActor, 1, Standalone<StringRef> >, public FastAllocated<PopTuplesActor>, public PopTuplesActorState<PopTuplesActor> {
															#line 408 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
public:
	using FastAllocated<PopTuplesActor>::operator new;
	using FastAllocated<PopTuplesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14211972229009993984UL, 3576366954018061824UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<Tuple>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PopTuplesActor, 0, Standalone<StringRef> >;
friend struct ActorCallback< PopTuplesActor, 1, Standalone<StringRef> >;
															#line 26 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	PopTuplesActor(Reference<FlowTesterData> const& data,int const& count = 1) 
															#line 426 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		 : Actor<std::vector<Tuple>>(),
		   PopTuplesActorState<PopTuplesActor>(data, count),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("popTuples", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4388028879129618944UL, 17087352442478034944UL);
		ActorExecutionContextHelper __helper(static_cast<PopTuplesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("popTuples");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("popTuples", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PopTuplesActor, 0, Standalone<StringRef> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< PopTuplesActor, 1, Standalone<StringRef> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 26 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
[[nodiscard]] Future<std::vector<Tuple>> popTuples( Reference<FlowTesterData> const& data, int const& count = 1 ) {
															#line 26 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	return Future<std::vector<Tuple>>(new PopTuplesActor(data, count));
															#line 460 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
}

#line 47 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"

															#line 465 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
namespace {
// This generated class is to be used only via popTuple()
															#line 48 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
template <class PopTupleActor>
															#line 48 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
class PopTupleActorState {
															#line 472 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
public:
															#line 48 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	PopTupleActorState(Reference<FlowTesterData> const& data) 
															#line 48 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
															#line 48 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		 : data(data)
															#line 479 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
	{
		fdb_probe_actor_create("popTuple", reinterpret_cast<unsigned long>(this));

	}
	~PopTupleActorState() 
	{
		fdb_probe_actor_destroy("popTuple", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 49 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			StrictFuture<std::vector<Tuple>> __when_expr_0 = popTuples(data);
															#line 49 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			if (static_cast<PopTupleActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 496 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<PopTupleActor*>(this)->actor_wait_state = 1;
															#line 49 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PopTupleActor, 0, std::vector<Tuple> >*>(static_cast<PopTupleActor*>(this)));
															#line 501 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PopTupleActorState();
		static_cast<PopTupleActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<Tuple> const& tuples,int loopDepth) 
	{
															#line 50 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		if (!static_cast<PopTupleActor*>(this)->SAV<Tuple>::futures) { (void)(tuples[0]); this->~PopTupleActorState(); static_cast<PopTupleActor*>(this)->destroy(); return 0; }
															#line 524 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		new (&static_cast<PopTupleActor*>(this)->SAV< Tuple >::value()) Tuple(tuples[0]);
		this->~PopTupleActorState();
		static_cast<PopTupleActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<Tuple> && tuples,int loopDepth) 
	{
															#line 50 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		if (!static_cast<PopTupleActor*>(this)->SAV<Tuple>::futures) { (void)(tuples[0]); this->~PopTupleActorState(); static_cast<PopTupleActor*>(this)->destroy(); return 0; }
															#line 536 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		new (&static_cast<PopTupleActor*>(this)->SAV< Tuple >::value()) Tuple(tuples[0]);
		this->~PopTupleActorState();
		static_cast<PopTupleActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(std::vector<Tuple> const& tuples,int loopDepth) 
	{
		loopDepth = a_body1cont1(tuples, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<Tuple> && tuples,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(tuples), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PopTupleActor*>(this)->actor_wait_state > 0) static_cast<PopTupleActor*>(this)->actor_wait_state = 0;
		static_cast<PopTupleActor*>(this)->ActorCallback< PopTupleActor, 0, std::vector<Tuple> >::remove();

	}
	void a_callback_fire(ActorCallback< PopTupleActor, 0, std::vector<Tuple> >*,std::vector<Tuple> const& value) 
	{
		fdb_probe_actor_enter("popTuple", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PopTupleActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("popTuple", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PopTupleActor, 0, std::vector<Tuple> >*,std::vector<Tuple> && value) 
	{
		fdb_probe_actor_enter("popTuple", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PopTupleActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("popTuple", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PopTupleActor, 0, std::vector<Tuple> >*,Error err) 
	{
		fdb_probe_actor_enter("popTuple", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PopTupleActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("popTuple", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 48 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	Reference<FlowTesterData> data;
															#line 621 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
};
// This generated class is to be used only via popTuple()
															#line 48 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
class PopTupleActor final : public Actor<Tuple>, public ActorCallback< PopTupleActor, 0, std::vector<Tuple> >, public FastAllocated<PopTupleActor>, public PopTupleActorState<PopTupleActor> {
															#line 626 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
public:
	using FastAllocated<PopTupleActor>::operator new;
	using FastAllocated<PopTupleActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10668090226064708608UL, 16330105506591968512UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Tuple>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PopTupleActor, 0, std::vector<Tuple> >;
															#line 48 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	PopTupleActor(Reference<FlowTesterData> const& data) 
															#line 643 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		 : Actor<Tuple>(),
		   PopTupleActorState<PopTupleActor>(data),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("popTuple", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13812416297347228928UL, 11731259956073423360UL);
		ActorExecutionContextHelper __helper(static_cast<PopTupleActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("popTuple");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("popTuple", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PopTupleActor, 0, std::vector<Tuple> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 48 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
[[nodiscard]] Future<Tuple> popTuple( Reference<FlowTesterData> const& data ) {
															#line 48 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	return Future<Tuple>(new PopTupleActor(data));
															#line 676 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
}

#line 52 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"

															#line 681 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
namespace {
// This generated class is to be used only via popPaths()
															#line 53 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
template <class PopPathsActor>
															#line 53 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
class PopPathsActorState {
															#line 688 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
public:
															#line 53 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	PopPathsActorState(Reference<FlowTesterData> const& data,int const& count = 1) 
															#line 53 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
															#line 53 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		 : data(data),
															#line 53 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		   count(count)
															#line 697 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
	{
		fdb_probe_actor_create("popPaths", reinterpret_cast<unsigned long>(this));

	}
	~PopPathsActorState() 
	{
		fdb_probe_actor_destroy("popPaths", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 54 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			StrictFuture<std::vector<Tuple>> __when_expr_0 = popTuples(data, count);
															#line 54 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			if (static_cast<PopPathsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 714 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<PopPathsActor*>(this)->actor_wait_state = 1;
															#line 54 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PopPathsActor, 0, std::vector<Tuple> >*>(static_cast<PopPathsActor*>(this)));
															#line 719 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PopPathsActorState();
		static_cast<PopPathsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<Tuple> const& tuples,int loopDepth) 
	{
															#line 56 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		std::vector<IDirectory::Path> paths;
															#line 57 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		for( auto& tuple : tuples ) {
															#line 58 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			IDirectory::Path path;
															#line 59 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			for(int i = 0;i < tuple.size();++i) {
															#line 60 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
				path.push_back(tuple.getString(i));
															#line 750 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
			}
															#line 63 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			paths.push_back(path);
															#line 754 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		}
															#line 66 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		if (!static_cast<PopPathsActor*>(this)->SAV<std::vector<IDirectory::Path>>::futures) { (void)(paths); this->~PopPathsActorState(); static_cast<PopPathsActor*>(this)->destroy(); return 0; }
															#line 758 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		new (&static_cast<PopPathsActor*>(this)->SAV< std::vector<IDirectory::Path> >::value()) std::vector<IDirectory::Path>(paths);
		this->~PopPathsActorState();
		static_cast<PopPathsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<Tuple> && tuples,int loopDepth) 
	{
															#line 56 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		std::vector<IDirectory::Path> paths;
															#line 57 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		for( auto& tuple : tuples ) {
															#line 58 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			IDirectory::Path path;
															#line 59 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			for(int i = 0;i < tuple.size();++i) {
															#line 60 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
				path.push_back(tuple.getString(i));
															#line 778 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
			}
															#line 63 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			paths.push_back(path);
															#line 782 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		}
															#line 66 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		if (!static_cast<PopPathsActor*>(this)->SAV<std::vector<IDirectory::Path>>::futures) { (void)(paths); this->~PopPathsActorState(); static_cast<PopPathsActor*>(this)->destroy(); return 0; }
															#line 786 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		new (&static_cast<PopPathsActor*>(this)->SAV< std::vector<IDirectory::Path> >::value()) std::vector<IDirectory::Path>(paths);
		this->~PopPathsActorState();
		static_cast<PopPathsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(std::vector<Tuple> const& tuples,int loopDepth) 
	{
		loopDepth = a_body1cont1(tuples, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<Tuple> && tuples,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(tuples), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PopPathsActor*>(this)->actor_wait_state > 0) static_cast<PopPathsActor*>(this)->actor_wait_state = 0;
		static_cast<PopPathsActor*>(this)->ActorCallback< PopPathsActor, 0, std::vector<Tuple> >::remove();

	}
	void a_callback_fire(ActorCallback< PopPathsActor, 0, std::vector<Tuple> >*,std::vector<Tuple> const& value) 
	{
		fdb_probe_actor_enter("popPaths", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PopPathsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("popPaths", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PopPathsActor, 0, std::vector<Tuple> >*,std::vector<Tuple> && value) 
	{
		fdb_probe_actor_enter("popPaths", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PopPathsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("popPaths", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PopPathsActor, 0, std::vector<Tuple> >*,Error err) 
	{
		fdb_probe_actor_enter("popPaths", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PopPathsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("popPaths", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 53 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	Reference<FlowTesterData> data;
															#line 53 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	int count;
															#line 873 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
};
// This generated class is to be used only via popPaths()
															#line 53 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
class PopPathsActor final : public Actor<std::vector<IDirectory::Path>>, public ActorCallback< PopPathsActor, 0, std::vector<Tuple> >, public FastAllocated<PopPathsActor>, public PopPathsActorState<PopPathsActor> {
															#line 878 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
public:
	using FastAllocated<PopPathsActor>::operator new;
	using FastAllocated<PopPathsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11038457759210445824UL, 367229483380520448UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<IDirectory::Path>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PopPathsActor, 0, std::vector<Tuple> >;
															#line 53 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	PopPathsActor(Reference<FlowTesterData> const& data,int const& count = 1) 
															#line 895 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		 : Actor<std::vector<IDirectory::Path>>(),
		   PopPathsActorState<PopPathsActor>(data, count),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("popPaths", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16337739367481354752UL, 4019964550771202304UL);
		ActorExecutionContextHelper __helper(static_cast<PopPathsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("popPaths");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("popPaths", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PopPathsActor, 0, std::vector<Tuple> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 53 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
[[nodiscard]] Future<std::vector<IDirectory::Path>> popPaths( Reference<FlowTesterData> const& data, int const& count = 1 ) {
															#line 53 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	return Future<std::vector<IDirectory::Path>>(new PopPathsActor(data, count));
															#line 928 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
}

#line 68 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"

															#line 933 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
namespace {
// This generated class is to be used only via popPath()
															#line 69 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
template <class PopPathActor>
															#line 69 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
class PopPathActorState {
															#line 940 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
public:
															#line 69 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	PopPathActorState(Reference<FlowTesterData> const& data) 
															#line 69 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
															#line 69 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		 : data(data)
															#line 947 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
	{
		fdb_probe_actor_create("popPath", reinterpret_cast<unsigned long>(this));

	}
	~PopPathActorState() 
	{
		fdb_probe_actor_destroy("popPath", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 70 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			StrictFuture<std::vector<IDirectory::Path>> __when_expr_0 = popPaths(data);
															#line 70 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			if (static_cast<PopPathActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 964 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<PopPathActor*>(this)->actor_wait_state = 1;
															#line 70 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PopPathActor, 0, std::vector<IDirectory::Path> >*>(static_cast<PopPathActor*>(this)));
															#line 969 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PopPathActorState();
		static_cast<PopPathActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<IDirectory::Path> const& paths,int loopDepth) 
	{
															#line 71 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		if (!static_cast<PopPathActor*>(this)->SAV<IDirectory::Path>::futures) { (void)(paths[0]); this->~PopPathActorState(); static_cast<PopPathActor*>(this)->destroy(); return 0; }
															#line 992 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		new (&static_cast<PopPathActor*>(this)->SAV< IDirectory::Path >::value()) IDirectory::Path(paths[0]);
		this->~PopPathActorState();
		static_cast<PopPathActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<IDirectory::Path> && paths,int loopDepth) 
	{
															#line 71 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		if (!static_cast<PopPathActor*>(this)->SAV<IDirectory::Path>::futures) { (void)(paths[0]); this->~PopPathActorState(); static_cast<PopPathActor*>(this)->destroy(); return 0; }
															#line 1004 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		new (&static_cast<PopPathActor*>(this)->SAV< IDirectory::Path >::value()) IDirectory::Path(paths[0]);
		this->~PopPathActorState();
		static_cast<PopPathActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(std::vector<IDirectory::Path> const& paths,int loopDepth) 
	{
		loopDepth = a_body1cont1(paths, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<IDirectory::Path> && paths,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(paths), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PopPathActor*>(this)->actor_wait_state > 0) static_cast<PopPathActor*>(this)->actor_wait_state = 0;
		static_cast<PopPathActor*>(this)->ActorCallback< PopPathActor, 0, std::vector<IDirectory::Path> >::remove();

	}
	void a_callback_fire(ActorCallback< PopPathActor, 0, std::vector<IDirectory::Path> >*,std::vector<IDirectory::Path> const& value) 
	{
		fdb_probe_actor_enter("popPath", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PopPathActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("popPath", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PopPathActor, 0, std::vector<IDirectory::Path> >*,std::vector<IDirectory::Path> && value) 
	{
		fdb_probe_actor_enter("popPath", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PopPathActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("popPath", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PopPathActor, 0, std::vector<IDirectory::Path> >*,Error err) 
	{
		fdb_probe_actor_enter("popPath", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PopPathActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("popPath", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 69 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	Reference<FlowTesterData> data;
															#line 1089 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
};
// This generated class is to be used only via popPath()
															#line 69 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
class PopPathActor final : public Actor<IDirectory::Path>, public ActorCallback< PopPathActor, 0, std::vector<IDirectory::Path> >, public FastAllocated<PopPathActor>, public PopPathActorState<PopPathActor> {
															#line 1094 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
public:
	using FastAllocated<PopPathActor>::operator new;
	using FastAllocated<PopPathActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4983424153238485248UL, 7568695008509851136UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<IDirectory::Path>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PopPathActor, 0, std::vector<IDirectory::Path> >;
															#line 69 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	PopPathActor(Reference<FlowTesterData> const& data) 
															#line 1111 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		 : Actor<IDirectory::Path>(),
		   PopPathActorState<PopPathActor>(data),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("popPath", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16366006460548666368UL, 7916334782890060288UL);
		ActorExecutionContextHelper __helper(static_cast<PopPathActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("popPath");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("popPath", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PopPathActor, 0, std::vector<IDirectory::Path> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 69 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
[[nodiscard]] Future<IDirectory::Path> popPath( Reference<FlowTesterData> const& data ) {
															#line 69 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	return Future<IDirectory::Path>(new PopPathActor(data));
															#line 1144 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
}

#line 73 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"

std::string pathToString(IDirectory::Path const& path) {
	std::string str;
	str += "[";
	for (int i = 0; i < path.size(); ++i) {
		str += path[i].toString();
		if (i < path.size() - 1) {
			str += ", ";
		}
	}

	return str + "]";
}

IDirectory::Path combinePaths(IDirectory::Path const& path1, IDirectory::Path const& path2) {
	IDirectory::Path outPath(path1.begin(), path1.end());
	for (auto p : path2) {
		outPath.push_back(p);
	}

	return outPath;
}

void logOp(std::string message, bool force = false) {
	if (LOG_OPS || force) {
		printf("%s\n", message.c_str());
		fflush(stdout);
	}
}

// DIRECTORY_CREATE_SUBSPACE
struct DirectoryCreateSubspaceFunc : InstructionFunc {
	static const char* name;

																#line 1182 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
// This generated class is to be used only via call()
															#line 107 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
template <class CallActor>
															#line 107 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
class CallActorState {
															#line 1188 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
public:
															#line 107 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	CallActorState(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 107 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
															#line 107 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		 : data(data),
															#line 107 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		   instruction(instruction)
															#line 1197 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
	{
		fdb_probe_actor_create("call", reinterpret_cast<unsigned long>(this));

	}
	~CallActorState() 
	{
		fdb_probe_actor_destroy("call", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 108 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			StrictFuture<Tuple> __when_expr_0 = popTuple(data);
															#line 108 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			if (static_cast<CallActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1214 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CallActor*>(this)->actor_wait_state = 1;
															#line 108 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CallActor, 0, Tuple >*>(static_cast<CallActor*>(this)));
															#line 1219 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CallActorState();
		static_cast<CallActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 109 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		StrictFuture<Tuple> __when_expr_1 = data->stack.waitAndPop();
															#line 109 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		if (static_cast<CallActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1244 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CallActor*>(this)->actor_wait_state = 2;
															#line 109 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CallActor, 1, Tuple >*>(static_cast<CallActor*>(this)));
															#line 1249 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Tuple const& __path,int loopDepth) 
	{
															#line 108 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		path = __path;
															#line 1258 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Tuple && __path,int loopDepth) 
	{
		path = std::move(__path);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CallActor*>(this)->actor_wait_state > 0) static_cast<CallActor*>(this)->actor_wait_state = 0;
		static_cast<CallActor*>(this)->ActorCallback< CallActor, 0, Tuple >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor, 0, Tuple >*,Tuple const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CallActor, 0, Tuple >*,Tuple && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CallActor, 0, Tuple >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Tuple const& rawPrefix,int loopDepth) 
	{
															#line 111 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		logOp(format( "Created subspace at %s: %s", tupleToString(path).c_str(), rawPrefix.getString(0).printable().c_str()));
															#line 113 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		data->directoryData.push(new Subspace(path, rawPrefix.getString(0)));
															#line 114 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		if (!static_cast<CallActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActorState(); static_cast<CallActor*>(this)->destroy(); return 0; }
															#line 1341 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		new (&static_cast<CallActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CallActorState();
		static_cast<CallActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Tuple && rawPrefix,int loopDepth) 
	{
															#line 111 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		logOp(format( "Created subspace at %s: %s", tupleToString(path).c_str(), rawPrefix.getString(0).printable().c_str()));
															#line 113 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		data->directoryData.push(new Subspace(path, rawPrefix.getString(0)));
															#line 114 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		if (!static_cast<CallActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActorState(); static_cast<CallActor*>(this)->destroy(); return 0; }
															#line 1357 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		new (&static_cast<CallActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CallActorState();
		static_cast<CallActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Tuple const& rawPrefix,int loopDepth) 
	{
		loopDepth = a_body1cont2(rawPrefix, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Tuple && rawPrefix,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(rawPrefix), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CallActor*>(this)->actor_wait_state > 0) static_cast<CallActor*>(this)->actor_wait_state = 0;
		static_cast<CallActor*>(this)->ActorCallback< CallActor, 1, Tuple >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor, 1, Tuple >*,Tuple const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CallActor, 1, Tuple >*,Tuple && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CallActor, 1, Tuple >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 107 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	Reference<FlowTesterData> data;
															#line 107 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	Reference<InstructionData> instruction;
															#line 108 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	Tuple path;
															#line 1446 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
};
// This generated class is to be used only via call()
															#line 107 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
class CallActor final : public Actor<Void>, public ActorCallback< CallActor, 0, Tuple >, public ActorCallback< CallActor, 1, Tuple >, public FastAllocated<CallActor>, public CallActorState<CallActor> {
															#line 1451 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
public:
	using FastAllocated<CallActor>::operator new;
	using FastAllocated<CallActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2925340698391154432UL, 7906335506767893504UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CallActor, 0, Tuple >;
friend struct ActorCallback< CallActor, 1, Tuple >;
															#line 107 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	CallActor(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 1469 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		 : Actor<Void>(),
		   CallActorState<CallActor>(data, instruction),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7627573813278715136UL, 12862468809175655680UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("call");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CallActor, 0, Tuple >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CallActor, 1, Tuple >*)0, actor_cancelled()); break;
		}

	}
};
															#line 107 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
[[nodiscard]] static Future<Void> call( Reference<FlowTesterData> const& data, Reference<InstructionData> const& instruction ) {
															#line 107 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	return Future<Void>(new CallActor(data, instruction));
															#line 1502 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
}

#line 116 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
};
const char* DirectoryCreateSubspaceFunc::name = "DIRECTORY_CREATE_SUBSPACE";
REGISTER_INSTRUCTION_FUNC(DirectoryCreateSubspaceFunc);

// DIRECTORY_CREATE_LAYER
struct DirectoryCreateLayerFunc : InstructionFunc {
	static const char* name;

																#line 1514 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
// This generated class is to be used only via call()
															#line 124 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
template <class CallActor1>
															#line 124 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
class CallActor1State {
															#line 1520 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
public:
															#line 124 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	CallActor1State(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 124 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
															#line 124 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		 : data(data),
															#line 124 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		   instruction(instruction)
															#line 1529 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
	{
		fdb_probe_actor_create("call", reinterpret_cast<unsigned long>(this));

	}
	~CallActor1State() 
	{
		fdb_probe_actor_destroy("call", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 125 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			StrictFuture<std::vector<Tuple>> __when_expr_0 = data->stack.waitAndPop(3);
															#line 125 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			if (static_cast<CallActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1546 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CallActor1*>(this)->actor_wait_state = 1;
															#line 125 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CallActor1, 0, std::vector<Tuple> >*>(static_cast<CallActor1*>(this)));
															#line 1551 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CallActor1State();
		static_cast<CallActor1*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<Tuple> const& args,int loopDepth) 
	{
															#line 127 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		int index1 = args[0].getInt(0);
															#line 128 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		int index2 = args[1].getInt(0);
															#line 129 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		bool allowManualPrefixes = args[2].getInt(0) != 0;
															#line 131 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		if (!data->directoryData.directoryList[index1].valid() || !data->directoryData.directoryList[index2].valid())
															#line 1580 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		{
															#line 132 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			logOp("Create directory layer: None");
															#line 133 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			data->directoryData.push();
															#line 1586 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		}
		else
		{
															#line 135 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			Subspace* nodeSubspace = data->directoryData.directoryList[index1].subspace.get();
															#line 136 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			Subspace* contentSubspace = data->directoryData.directoryList[index2].subspace.get();
															#line 137 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			logOp(format("Create directory layer: node_subspace (%d) = %s, content_subspace (%d) = %s, " "allow_manual_prefixes = %d", index1, nodeSubspace->key().printable().c_str(), index2, nodeSubspace->key().printable().c_str(), allowManualPrefixes));
															#line 144 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			data->directoryData.push( Reference<IDirectory>(new DirectoryLayer(*nodeSubspace, *contentSubspace, allowManualPrefixes)));
															#line 1598 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		}
															#line 148 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		if (!static_cast<CallActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor1State(); static_cast<CallActor1*>(this)->destroy(); return 0; }
															#line 1602 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		new (&static_cast<CallActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~CallActor1State();
		static_cast<CallActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<Tuple> && args,int loopDepth) 
	{
															#line 127 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		int index1 = args[0].getInt(0);
															#line 128 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		int index2 = args[1].getInt(0);
															#line 129 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		bool allowManualPrefixes = args[2].getInt(0) != 0;
															#line 131 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		if (!data->directoryData.directoryList[index1].valid() || !data->directoryData.directoryList[index2].valid())
															#line 1620 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		{
															#line 132 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			logOp("Create directory layer: None");
															#line 133 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			data->directoryData.push();
															#line 1626 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		}
		else
		{
															#line 135 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			Subspace* nodeSubspace = data->directoryData.directoryList[index1].subspace.get();
															#line 136 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			Subspace* contentSubspace = data->directoryData.directoryList[index2].subspace.get();
															#line 137 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			logOp(format("Create directory layer: node_subspace (%d) = %s, content_subspace (%d) = %s, " "allow_manual_prefixes = %d", index1, nodeSubspace->key().printable().c_str(), index2, nodeSubspace->key().printable().c_str(), allowManualPrefixes));
															#line 144 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			data->directoryData.push( Reference<IDirectory>(new DirectoryLayer(*nodeSubspace, *contentSubspace, allowManualPrefixes)));
															#line 1638 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		}
															#line 148 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		if (!static_cast<CallActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor1State(); static_cast<CallActor1*>(this)->destroy(); return 0; }
															#line 1642 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		new (&static_cast<CallActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~CallActor1State();
		static_cast<CallActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(std::vector<Tuple> const& args,int loopDepth) 
	{
		loopDepth = a_body1cont1(args, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<Tuple> && args,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(args), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CallActor1*>(this)->actor_wait_state > 0) static_cast<CallActor1*>(this)->actor_wait_state = 0;
		static_cast<CallActor1*>(this)->ActorCallback< CallActor1, 0, std::vector<Tuple> >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor1, 0, std::vector<Tuple> >*,std::vector<Tuple> const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CallActor1, 0, std::vector<Tuple> >*,std::vector<Tuple> && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CallActor1, 0, std::vector<Tuple> >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 124 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	Reference<FlowTesterData> data;
															#line 124 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	Reference<InstructionData> instruction;
															#line 1729 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
};
// This generated class is to be used only via call()
															#line 124 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
class CallActor1 final : public Actor<Void>, public ActorCallback< CallActor1, 0, std::vector<Tuple> >, public FastAllocated<CallActor1>, public CallActor1State<CallActor1> {
															#line 1734 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
public:
	using FastAllocated<CallActor1>::operator new;
	using FastAllocated<CallActor1>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2925340698391154432UL, 7906335506767893504UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CallActor1, 0, std::vector<Tuple> >;
															#line 124 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	CallActor1(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 1751 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		 : Actor<Void>(),
		   CallActor1State<CallActor1>(data, instruction),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11408034284726002688UL, 16335413270408340480UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("call");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CallActor1, 0, std::vector<Tuple> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 124 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
[[nodiscard]] static Future<Void> call( Reference<FlowTesterData> const& data, Reference<InstructionData> const& instruction ) {
															#line 124 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	return Future<Void>(new CallActor1(data, instruction));
															#line 1783 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
}

#line 150 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
};
const char* DirectoryCreateLayerFunc::name = "DIRECTORY_CREATE_LAYER";
REGISTER_INSTRUCTION_FUNC(DirectoryCreateLayerFunc);

// DIRECTORY_CHANGE
struct DirectoryChangeFunc : InstructionFunc {
	static const char* name;

																#line 1795 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
// This generated class is to be used only via call()
															#line 158 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
template <class CallActor2>
															#line 158 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
class CallActor2State {
															#line 1801 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
public:
															#line 158 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	CallActor2State(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 158 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
															#line 158 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		 : data(data),
															#line 158 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		   instruction(instruction)
															#line 1810 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
	{
		fdb_probe_actor_create("call", reinterpret_cast<unsigned long>(this));

	}
	~CallActor2State() 
	{
		fdb_probe_actor_destroy("call", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 159 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			StrictFuture<Tuple> __when_expr_0 = data->stack.waitAndPop();
															#line 159 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			if (static_cast<CallActor2*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1827 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CallActor2*>(this)->actor_wait_state = 1;
															#line 159 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CallActor2, 0, Tuple >*>(static_cast<CallActor2*>(this)));
															#line 1832 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CallActor2State();
		static_cast<CallActor2*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Tuple const& index,int loopDepth) 
	{
															#line 160 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		data->directoryData.directoryListIndex = index.getInt(0);
															#line 161 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		ASSERT(data->directoryData.directoryListIndex < data->directoryData.directoryList.size());
															#line 163 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		if (!data->directoryData.directoryList[data->directoryData.directoryListIndex].valid())
															#line 1859 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		{
															#line 164 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			data->directoryData.directoryListIndex = data->directoryData.directoryErrorIndex;
															#line 1863 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		}
															#line 167 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		if (LOG_DIRS)
															#line 1867 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		{
															#line 168 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			DirectoryOrSubspace d = data->directoryData.directoryList[data->directoryData.directoryListIndex];
															#line 169 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			printf("Changed directory to %d (%s @\'%s\')\n", data->directoryData.directoryListIndex, d.typeString().c_str(), d.directory.present() ? pathToString(d.directory.get()->getPath()).c_str() : d.subspace.get()->key().printable().c_str());
															#line 174 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			fflush(stdout);
															#line 1875 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		}
															#line 177 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		if (!static_cast<CallActor2*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor2State(); static_cast<CallActor2*>(this)->destroy(); return 0; }
															#line 1879 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		new (&static_cast<CallActor2*>(this)->SAV< Void >::value()) Void(Void());
		this->~CallActor2State();
		static_cast<CallActor2*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Tuple && index,int loopDepth) 
	{
															#line 160 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		data->directoryData.directoryListIndex = index.getInt(0);
															#line 161 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		ASSERT(data->directoryData.directoryListIndex < data->directoryData.directoryList.size());
															#line 163 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		if (!data->directoryData.directoryList[data->directoryData.directoryListIndex].valid())
															#line 1895 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		{
															#line 164 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			data->directoryData.directoryListIndex = data->directoryData.directoryErrorIndex;
															#line 1899 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		}
															#line 167 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		if (LOG_DIRS)
															#line 1903 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		{
															#line 168 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			DirectoryOrSubspace d = data->directoryData.directoryList[data->directoryData.directoryListIndex];
															#line 169 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			printf("Changed directory to %d (%s @\'%s\')\n", data->directoryData.directoryListIndex, d.typeString().c_str(), d.directory.present() ? pathToString(d.directory.get()->getPath()).c_str() : d.subspace.get()->key().printable().c_str());
															#line 174 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			fflush(stdout);
															#line 1911 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		}
															#line 177 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		if (!static_cast<CallActor2*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor2State(); static_cast<CallActor2*>(this)->destroy(); return 0; }
															#line 1915 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		new (&static_cast<CallActor2*>(this)->SAV< Void >::value()) Void(Void());
		this->~CallActor2State();
		static_cast<CallActor2*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Tuple const& index,int loopDepth) 
	{
		loopDepth = a_body1cont1(index, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Tuple && index,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(index), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CallActor2*>(this)->actor_wait_state > 0) static_cast<CallActor2*>(this)->actor_wait_state = 0;
		static_cast<CallActor2*>(this)->ActorCallback< CallActor2, 0, Tuple >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor2, 0, Tuple >*,Tuple const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor2*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CallActor2, 0, Tuple >*,Tuple && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor2*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CallActor2, 0, Tuple >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor2*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 158 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	Reference<FlowTesterData> data;
															#line 158 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	Reference<InstructionData> instruction;
															#line 2002 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
};
// This generated class is to be used only via call()
															#line 158 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
class CallActor2 final : public Actor<Void>, public ActorCallback< CallActor2, 0, Tuple >, public FastAllocated<CallActor2>, public CallActor2State<CallActor2> {
															#line 2007 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
public:
	using FastAllocated<CallActor2>::operator new;
	using FastAllocated<CallActor2>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2925340698391154432UL, 7906335506767893504UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CallActor2, 0, Tuple >;
															#line 158 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	CallActor2(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 2024 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		 : Actor<Void>(),
		   CallActor2State<CallActor2>(data, instruction),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3817665306019306496UL, 7653278230371291904UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor2*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("call");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CallActor2, 0, Tuple >*)0, actor_cancelled()); break;
		}

	}
};
															#line 158 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
[[nodiscard]] static Future<Void> call( Reference<FlowTesterData> const& data, Reference<InstructionData> const& instruction ) {
															#line 158 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	return Future<Void>(new CallActor2(data, instruction));
															#line 2056 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
}

#line 179 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
};
const char* DirectoryChangeFunc::name = "DIRECTORY_CHANGE";
REGISTER_INSTRUCTION_FUNC(DirectoryChangeFunc);

// DIRECTORY_SET_ERROR_INDEX
struct DirectorySetErrorIndexFunc : InstructionFunc {
	static const char* name;

																#line 2068 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
// This generated class is to be used only via call()
															#line 187 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
template <class CallActor3>
															#line 187 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
class CallActor3State {
															#line 2074 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
public:
															#line 187 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	CallActor3State(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 187 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
															#line 187 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		 : data(data),
															#line 187 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		   instruction(instruction)
															#line 2083 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
	{
		fdb_probe_actor_create("call", reinterpret_cast<unsigned long>(this));

	}
	~CallActor3State() 
	{
		fdb_probe_actor_destroy("call", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 188 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			StrictFuture<Tuple> __when_expr_0 = data->stack.waitAndPop();
															#line 188 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			if (static_cast<CallActor3*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2100 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CallActor3*>(this)->actor_wait_state = 1;
															#line 188 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CallActor3, 0, Tuple >*>(static_cast<CallActor3*>(this)));
															#line 2105 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CallActor3State();
		static_cast<CallActor3*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Tuple const& index,int loopDepth) 
	{
															#line 189 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		data->directoryData.directoryErrorIndex = index.getInt(0);
															#line 191 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		if (!static_cast<CallActor3*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor3State(); static_cast<CallActor3*>(this)->destroy(); return 0; }
															#line 2130 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		new (&static_cast<CallActor3*>(this)->SAV< Void >::value()) Void(Void());
		this->~CallActor3State();
		static_cast<CallActor3*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Tuple && index,int loopDepth) 
	{
															#line 189 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		data->directoryData.directoryErrorIndex = index.getInt(0);
															#line 191 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		if (!static_cast<CallActor3*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor3State(); static_cast<CallActor3*>(this)->destroy(); return 0; }
															#line 2144 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		new (&static_cast<CallActor3*>(this)->SAV< Void >::value()) Void(Void());
		this->~CallActor3State();
		static_cast<CallActor3*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Tuple const& index,int loopDepth) 
	{
		loopDepth = a_body1cont1(index, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Tuple && index,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(index), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CallActor3*>(this)->actor_wait_state > 0) static_cast<CallActor3*>(this)->actor_wait_state = 0;
		static_cast<CallActor3*>(this)->ActorCallback< CallActor3, 0, Tuple >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor3, 0, Tuple >*,Tuple const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor3*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CallActor3, 0, Tuple >*,Tuple && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor3*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CallActor3, 0, Tuple >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor3*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 187 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	Reference<FlowTesterData> data;
															#line 187 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	Reference<InstructionData> instruction;
															#line 2231 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
};
// This generated class is to be used only via call()
															#line 187 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
class CallActor3 final : public Actor<Void>, public ActorCallback< CallActor3, 0, Tuple >, public FastAllocated<CallActor3>, public CallActor3State<CallActor3> {
															#line 2236 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
public:
	using FastAllocated<CallActor3>::operator new;
	using FastAllocated<CallActor3>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2925340698391154432UL, 7906335506767893504UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CallActor3, 0, Tuple >;
															#line 187 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	CallActor3(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 2253 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		 : Actor<Void>(),
		   CallActor3State<CallActor3>(data, instruction),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14974279663439659008UL, 13489961173622453504UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor3*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("call");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CallActor3, 0, Tuple >*)0, actor_cancelled()); break;
		}

	}
};
															#line 187 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
[[nodiscard]] static Future<Void> call( Reference<FlowTesterData> const& data, Reference<InstructionData> const& instruction ) {
															#line 187 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	return Future<Void>(new CallActor3(data, instruction));
															#line 2285 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
}

#line 193 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
};
const char* DirectorySetErrorIndexFunc::name = "DIRECTORY_SET_ERROR_INDEX";
REGISTER_INSTRUCTION_FUNC(DirectorySetErrorIndexFunc);

// DIRECTORY_CREATE_OR_OPEN
struct DirectoryCreateOrOpenFunc : InstructionFunc {
	static const char* name;

																#line 2297 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
// This generated class is to be used only via call()
															#line 201 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
template <class CallActor4>
															#line 201 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
class CallActor4State {
															#line 2303 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
public:
															#line 201 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	CallActor4State(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 201 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
															#line 201 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		 : data(data),
															#line 201 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		   instruction(instruction)
															#line 2312 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
	{
		fdb_probe_actor_create("call", reinterpret_cast<unsigned long>(this));

	}
	~CallActor4State() 
	{
		fdb_probe_actor_destroy("call", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 202 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			StrictFuture<IDirectory::Path> __when_expr_0 = popPath(data);
															#line 202 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			if (static_cast<CallActor4*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2329 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CallActor4*>(this)->actor_wait_state = 1;
															#line 202 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CallActor4, 0, IDirectory::Path >*>(static_cast<CallActor4*>(this)));
															#line 2334 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CallActor4State();
		static_cast<CallActor4*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 203 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		StrictFuture<Tuple> __when_expr_1 = data->stack.waitAndPop();
															#line 203 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		if (static_cast<CallActor4*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2359 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CallActor4*>(this)->actor_wait_state = 2;
															#line 203 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CallActor4, 1, Tuple >*>(static_cast<CallActor4*>(this)));
															#line 2364 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(IDirectory::Path const& __path,int loopDepth) 
	{
															#line 202 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		path = __path;
															#line 2373 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(IDirectory::Path && __path,int loopDepth) 
	{
		path = std::move(__path);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CallActor4*>(this)->actor_wait_state > 0) static_cast<CallActor4*>(this)->actor_wait_state = 0;
		static_cast<CallActor4*>(this)->ActorCallback< CallActor4, 0, IDirectory::Path >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor4, 0, IDirectory::Path >*,IDirectory::Path const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor4*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CallActor4, 0, IDirectory::Path >*,IDirectory::Path && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor4*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CallActor4, 0, IDirectory::Path >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor4*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Tuple const& layerTuple,int loopDepth) 
	{
															#line 204 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		Standalone<StringRef> layer = layerTuple.getType(0) == Tuple::NULL_TYPE ? StringRef() : layerTuple.getString(0);
															#line 206 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		Reference<IDirectory> directory = data->directoryData.directory();
															#line 207 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		logOp(format("create_or_open %s: layer=%s", pathToString(combinePaths(directory->getPath(), path)).c_str(), layer.printable().c_str()));
															#line 211 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		StrictFuture<Reference<DirectorySubspace>> __when_expr_2 = executeMutation( instruction, [this, directory, layer]() { return directory->createOrOpen(instruction->tr, path, layer); });
															#line 211 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		if (static_cast<CallActor4*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2460 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<CallActor4*>(this)->actor_wait_state = 3;
															#line 211 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CallActor4, 2, Reference<DirectorySubspace> >*>(static_cast<CallActor4*>(this)));
															#line 2465 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Tuple && layerTuple,int loopDepth) 
	{
															#line 204 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		Standalone<StringRef> layer = layerTuple.getType(0) == Tuple::NULL_TYPE ? StringRef() : layerTuple.getString(0);
															#line 206 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		Reference<IDirectory> directory = data->directoryData.directory();
															#line 207 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		logOp(format("create_or_open %s: layer=%s", pathToString(combinePaths(directory->getPath(), path)).c_str(), layer.printable().c_str()));
															#line 211 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		StrictFuture<Reference<DirectorySubspace>> __when_expr_2 = executeMutation( instruction, [this, directory, layer]() { return directory->createOrOpen(instruction->tr, path, layer); });
															#line 211 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		if (static_cast<CallActor4*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2482 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<CallActor4*>(this)->actor_wait_state = 3;
															#line 211 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CallActor4, 2, Reference<DirectorySubspace> >*>(static_cast<CallActor4*>(this)));
															#line 2487 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Tuple const& layerTuple,int loopDepth) 
	{
		loopDepth = a_body1cont2(layerTuple, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Tuple && layerTuple,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(layerTuple), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CallActor4*>(this)->actor_wait_state > 0) static_cast<CallActor4*>(this)->actor_wait_state = 0;
		static_cast<CallActor4*>(this)->ActorCallback< CallActor4, 1, Tuple >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor4, 1, Tuple >*,Tuple const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor4*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CallActor4, 1, Tuple >*,Tuple && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor4*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CallActor4, 1, Tuple >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor4*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Reference<DirectorySubspace> const& dirSubspace,int loopDepth) 
	{
															#line 214 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		data->directoryData.push(dirSubspace);
															#line 216 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		if (!static_cast<CallActor4*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor4State(); static_cast<CallActor4*>(this)->destroy(); return 0; }
															#line 2573 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		new (&static_cast<CallActor4*>(this)->SAV< Void >::value()) Void(Void());
		this->~CallActor4State();
		static_cast<CallActor4*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Reference<DirectorySubspace> && dirSubspace,int loopDepth) 
	{
															#line 214 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		data->directoryData.push(dirSubspace);
															#line 216 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		if (!static_cast<CallActor4*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor4State(); static_cast<CallActor4*>(this)->destroy(); return 0; }
															#line 2587 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		new (&static_cast<CallActor4*>(this)->SAV< Void >::value()) Void(Void());
		this->~CallActor4State();
		static_cast<CallActor4*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(Reference<DirectorySubspace> const& dirSubspace,int loopDepth) 
	{
		loopDepth = a_body1cont3(dirSubspace, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Reference<DirectorySubspace> && dirSubspace,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(dirSubspace), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CallActor4*>(this)->actor_wait_state > 0) static_cast<CallActor4*>(this)->actor_wait_state = 0;
		static_cast<CallActor4*>(this)->ActorCallback< CallActor4, 2, Reference<DirectorySubspace> >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor4, 2, Reference<DirectorySubspace> >*,Reference<DirectorySubspace> const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor4*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CallActor4, 2, Reference<DirectorySubspace> >*,Reference<DirectorySubspace> && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor4*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CallActor4, 2, Reference<DirectorySubspace> >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor4*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 201 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	Reference<FlowTesterData> data;
															#line 201 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	Reference<InstructionData> instruction;
															#line 202 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	IDirectory::Path path;
															#line 2676 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
};
// This generated class is to be used only via call()
															#line 201 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
class CallActor4 final : public Actor<Void>, public ActorCallback< CallActor4, 0, IDirectory::Path >, public ActorCallback< CallActor4, 1, Tuple >, public ActorCallback< CallActor4, 2, Reference<DirectorySubspace> >, public FastAllocated<CallActor4>, public CallActor4State<CallActor4> {
															#line 2681 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
public:
	using FastAllocated<CallActor4>::operator new;
	using FastAllocated<CallActor4>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2925340698391154432UL, 7906335506767893504UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CallActor4, 0, IDirectory::Path >;
friend struct ActorCallback< CallActor4, 1, Tuple >;
friend struct ActorCallback< CallActor4, 2, Reference<DirectorySubspace> >;
															#line 201 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	CallActor4(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 2700 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		 : Actor<Void>(),
		   CallActor4State<CallActor4>(data, instruction),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1885067825512278016UL, 1963067322261558784UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor4*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("call");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CallActor4, 0, IDirectory::Path >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CallActor4, 1, Tuple >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CallActor4, 2, Reference<DirectorySubspace> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 201 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
[[nodiscard]] static Future<Void> call( Reference<FlowTesterData> const& data, Reference<InstructionData> const& instruction ) {
															#line 201 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	return Future<Void>(new CallActor4(data, instruction));
															#line 2734 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
}

#line 218 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
};
const char* DirectoryCreateOrOpenFunc::name = "DIRECTORY_CREATE_OR_OPEN";
REGISTER_INSTRUCTION_FUNC(DirectoryCreateOrOpenFunc);

// DIRECTORY_CREATE
struct DirectoryCreateFunc : InstructionFunc {
	static const char* name;

																#line 2746 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
// This generated class is to be used only via call()
															#line 226 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
template <class CallActor5>
															#line 226 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
class CallActor5State {
															#line 2752 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
public:
															#line 226 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	CallActor5State(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 226 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
															#line 226 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		 : data(data),
															#line 226 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		   instruction(instruction)
															#line 2761 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
	{
		fdb_probe_actor_create("call", reinterpret_cast<unsigned long>(this));

	}
	~CallActor5State() 
	{
		fdb_probe_actor_destroy("call", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 227 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			StrictFuture<IDirectory::Path> __when_expr_0 = popPath(data);
															#line 227 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			if (static_cast<CallActor5*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2778 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CallActor5*>(this)->actor_wait_state = 1;
															#line 227 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CallActor5, 0, IDirectory::Path >*>(static_cast<CallActor5*>(this)));
															#line 2783 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CallActor5State();
		static_cast<CallActor5*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 228 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		StrictFuture<std::vector<Tuple>> __when_expr_1 = data->stack.waitAndPop(2);
															#line 228 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		if (static_cast<CallActor5*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2808 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CallActor5*>(this)->actor_wait_state = 2;
															#line 228 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CallActor5, 1, std::vector<Tuple> >*>(static_cast<CallActor5*>(this)));
															#line 2813 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(IDirectory::Path const& __path,int loopDepth) 
	{
															#line 227 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		path = __path;
															#line 2822 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(IDirectory::Path && __path,int loopDepth) 
	{
		path = std::move(__path);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CallActor5*>(this)->actor_wait_state > 0) static_cast<CallActor5*>(this)->actor_wait_state = 0;
		static_cast<CallActor5*>(this)->ActorCallback< CallActor5, 0, IDirectory::Path >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor5, 0, IDirectory::Path >*,IDirectory::Path const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor5*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CallActor5, 0, IDirectory::Path >*,IDirectory::Path && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor5*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CallActor5, 0, IDirectory::Path >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor5*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(std::vector<Tuple> const& args,int loopDepth) 
	{
															#line 229 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		Standalone<StringRef> layer = args[0].getType(0) == Tuple::NULL_TYPE ? StringRef() : args[0].getString(0);
															#line 230 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		Optional<Standalone<StringRef>> prefix = args[1].getType(0) == Tuple::NULL_TYPE ? Optional<Standalone<StringRef>>() : args[1].getString(0);
															#line 233 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		Reference<IDirectory> directory = data->directoryData.directory();
															#line 234 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		logOp(format("create %s: layer=%s, prefix=%s", pathToString(combinePaths(directory->getPath(), path)).c_str(), layer.printable().c_str(), prefix.present() ? prefix.get().printable().c_str() : "<not present>"));
															#line 239 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		StrictFuture<Reference<DirectorySubspace>> __when_expr_2 = executeMutation(instruction, [this, directory, layer, prefix]() { return directory->create(instruction->tr, path, layer, prefix); });
															#line 239 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		if (static_cast<CallActor5*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2911 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<CallActor5*>(this)->actor_wait_state = 3;
															#line 239 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CallActor5, 2, Reference<DirectorySubspace> >*>(static_cast<CallActor5*>(this)));
															#line 2916 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(std::vector<Tuple> && args,int loopDepth) 
	{
															#line 229 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		Standalone<StringRef> layer = args[0].getType(0) == Tuple::NULL_TYPE ? StringRef() : args[0].getString(0);
															#line 230 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		Optional<Standalone<StringRef>> prefix = args[1].getType(0) == Tuple::NULL_TYPE ? Optional<Standalone<StringRef>>() : args[1].getString(0);
															#line 233 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		Reference<IDirectory> directory = data->directoryData.directory();
															#line 234 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		logOp(format("create %s: layer=%s, prefix=%s", pathToString(combinePaths(directory->getPath(), path)).c_str(), layer.printable().c_str(), prefix.present() ? prefix.get().printable().c_str() : "<not present>"));
															#line 239 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		StrictFuture<Reference<DirectorySubspace>> __when_expr_2 = executeMutation(instruction, [this, directory, layer, prefix]() { return directory->create(instruction->tr, path, layer, prefix); });
															#line 239 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		if (static_cast<CallActor5*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2935 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<CallActor5*>(this)->actor_wait_state = 3;
															#line 239 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CallActor5, 2, Reference<DirectorySubspace> >*>(static_cast<CallActor5*>(this)));
															#line 2940 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(std::vector<Tuple> const& args,int loopDepth) 
	{
		loopDepth = a_body1cont2(args, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(std::vector<Tuple> && args,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(args), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CallActor5*>(this)->actor_wait_state > 0) static_cast<CallActor5*>(this)->actor_wait_state = 0;
		static_cast<CallActor5*>(this)->ActorCallback< CallActor5, 1, std::vector<Tuple> >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor5, 1, std::vector<Tuple> >*,std::vector<Tuple> const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor5*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CallActor5, 1, std::vector<Tuple> >*,std::vector<Tuple> && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor5*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CallActor5, 1, std::vector<Tuple> >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor5*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Reference<DirectorySubspace> const& dirSubspace,int loopDepth) 
	{
															#line 244 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		data->directoryData.push(dirSubspace);
															#line 246 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		if (!static_cast<CallActor5*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor5State(); static_cast<CallActor5*>(this)->destroy(); return 0; }
															#line 3026 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		new (&static_cast<CallActor5*>(this)->SAV< Void >::value()) Void(Void());
		this->~CallActor5State();
		static_cast<CallActor5*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Reference<DirectorySubspace> && dirSubspace,int loopDepth) 
	{
															#line 244 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		data->directoryData.push(dirSubspace);
															#line 246 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		if (!static_cast<CallActor5*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor5State(); static_cast<CallActor5*>(this)->destroy(); return 0; }
															#line 3040 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		new (&static_cast<CallActor5*>(this)->SAV< Void >::value()) Void(Void());
		this->~CallActor5State();
		static_cast<CallActor5*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(Reference<DirectorySubspace> const& dirSubspace,int loopDepth) 
	{
		loopDepth = a_body1cont3(dirSubspace, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Reference<DirectorySubspace> && dirSubspace,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(dirSubspace), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CallActor5*>(this)->actor_wait_state > 0) static_cast<CallActor5*>(this)->actor_wait_state = 0;
		static_cast<CallActor5*>(this)->ActorCallback< CallActor5, 2, Reference<DirectorySubspace> >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor5, 2, Reference<DirectorySubspace> >*,Reference<DirectorySubspace> const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor5*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CallActor5, 2, Reference<DirectorySubspace> >*,Reference<DirectorySubspace> && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor5*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CallActor5, 2, Reference<DirectorySubspace> >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor5*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 226 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	Reference<FlowTesterData> data;
															#line 226 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	Reference<InstructionData> instruction;
															#line 227 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	IDirectory::Path path;
															#line 3129 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
};
// This generated class is to be used only via call()
															#line 226 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
class CallActor5 final : public Actor<Void>, public ActorCallback< CallActor5, 0, IDirectory::Path >, public ActorCallback< CallActor5, 1, std::vector<Tuple> >, public ActorCallback< CallActor5, 2, Reference<DirectorySubspace> >, public FastAllocated<CallActor5>, public CallActor5State<CallActor5> {
															#line 3134 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
public:
	using FastAllocated<CallActor5>::operator new;
	using FastAllocated<CallActor5>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2925340698391154432UL, 7906335506767893504UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CallActor5, 0, IDirectory::Path >;
friend struct ActorCallback< CallActor5, 1, std::vector<Tuple> >;
friend struct ActorCallback< CallActor5, 2, Reference<DirectorySubspace> >;
															#line 226 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	CallActor5(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 3153 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		 : Actor<Void>(),
		   CallActor5State<CallActor5>(data, instruction),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8830978267066932480UL, 12194855831069212160UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor5*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("call");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CallActor5, 0, IDirectory::Path >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CallActor5, 1, std::vector<Tuple> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CallActor5, 2, Reference<DirectorySubspace> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 226 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
[[nodiscard]] static Future<Void> call( Reference<FlowTesterData> const& data, Reference<InstructionData> const& instruction ) {
															#line 226 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	return Future<Void>(new CallActor5(data, instruction));
															#line 3187 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
}

#line 248 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
};
const char* DirectoryCreateFunc::name = "DIRECTORY_CREATE";
REGISTER_INSTRUCTION_FUNC(DirectoryCreateFunc);

// DIRECTORY_OPEN
struct DirectoryOpenFunc : InstructionFunc {
	static const char* name;

																#line 3199 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
// This generated class is to be used only via call()
															#line 256 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
template <class CallActor6>
															#line 256 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
class CallActor6State {
															#line 3205 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
public:
															#line 256 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	CallActor6State(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 256 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
															#line 256 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		 : data(data),
															#line 256 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		   instruction(instruction)
															#line 3214 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
	{
		fdb_probe_actor_create("call", reinterpret_cast<unsigned long>(this));

	}
	~CallActor6State() 
	{
		fdb_probe_actor_destroy("call", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 257 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			StrictFuture<IDirectory::Path> __when_expr_0 = popPath(data);
															#line 257 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			if (static_cast<CallActor6*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3231 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CallActor6*>(this)->actor_wait_state = 1;
															#line 257 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CallActor6, 0, IDirectory::Path >*>(static_cast<CallActor6*>(this)));
															#line 3236 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CallActor6State();
		static_cast<CallActor6*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 258 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		StrictFuture<Tuple> __when_expr_1 = data->stack.waitAndPop();
															#line 258 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		if (static_cast<CallActor6*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3261 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CallActor6*>(this)->actor_wait_state = 2;
															#line 258 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CallActor6, 1, Tuple >*>(static_cast<CallActor6*>(this)));
															#line 3266 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(IDirectory::Path const& __path,int loopDepth) 
	{
															#line 257 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		path = __path;
															#line 3275 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(IDirectory::Path && __path,int loopDepth) 
	{
		path = std::move(__path);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CallActor6*>(this)->actor_wait_state > 0) static_cast<CallActor6*>(this)->actor_wait_state = 0;
		static_cast<CallActor6*>(this)->ActorCallback< CallActor6, 0, IDirectory::Path >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor6, 0, IDirectory::Path >*,IDirectory::Path const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor6*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CallActor6, 0, IDirectory::Path >*,IDirectory::Path && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor6*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CallActor6, 0, IDirectory::Path >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor6*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Tuple const& layerTuple,int loopDepth) 
	{
															#line 259 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		Standalone<StringRef> layer = layerTuple.getType(0) == Tuple::NULL_TYPE ? StringRef() : layerTuple.getString(0);
															#line 261 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		Reference<IDirectory> directory = data->directoryData.directory();
															#line 262 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		logOp(format("open %s: layer=%s", pathToString(combinePaths(directory->getPath(), path)).c_str(), layer.printable().c_str()));
															#line 265 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		StrictFuture<Reference<DirectorySubspace>> __when_expr_2 = directory->open(instruction->tr, path, layer);
															#line 265 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		if (static_cast<CallActor6*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3362 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<CallActor6*>(this)->actor_wait_state = 3;
															#line 265 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CallActor6, 2, Reference<DirectorySubspace> >*>(static_cast<CallActor6*>(this)));
															#line 3367 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Tuple && layerTuple,int loopDepth) 
	{
															#line 259 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		Standalone<StringRef> layer = layerTuple.getType(0) == Tuple::NULL_TYPE ? StringRef() : layerTuple.getString(0);
															#line 261 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		Reference<IDirectory> directory = data->directoryData.directory();
															#line 262 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		logOp(format("open %s: layer=%s", pathToString(combinePaths(directory->getPath(), path)).c_str(), layer.printable().c_str()));
															#line 265 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		StrictFuture<Reference<DirectorySubspace>> __when_expr_2 = directory->open(instruction->tr, path, layer);
															#line 265 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		if (static_cast<CallActor6*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3384 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<CallActor6*>(this)->actor_wait_state = 3;
															#line 265 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CallActor6, 2, Reference<DirectorySubspace> >*>(static_cast<CallActor6*>(this)));
															#line 3389 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Tuple const& layerTuple,int loopDepth) 
	{
		loopDepth = a_body1cont2(layerTuple, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Tuple && layerTuple,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(layerTuple), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CallActor6*>(this)->actor_wait_state > 0) static_cast<CallActor6*>(this)->actor_wait_state = 0;
		static_cast<CallActor6*>(this)->ActorCallback< CallActor6, 1, Tuple >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor6, 1, Tuple >*,Tuple const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor6*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CallActor6, 1, Tuple >*,Tuple && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor6*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CallActor6, 1, Tuple >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor6*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Reference<DirectorySubspace> const& dirSubspace,int loopDepth) 
	{
															#line 266 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		data->directoryData.push(dirSubspace);
															#line 268 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		if (!static_cast<CallActor6*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor6State(); static_cast<CallActor6*>(this)->destroy(); return 0; }
															#line 3475 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		new (&static_cast<CallActor6*>(this)->SAV< Void >::value()) Void(Void());
		this->~CallActor6State();
		static_cast<CallActor6*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Reference<DirectorySubspace> && dirSubspace,int loopDepth) 
	{
															#line 266 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		data->directoryData.push(dirSubspace);
															#line 268 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		if (!static_cast<CallActor6*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor6State(); static_cast<CallActor6*>(this)->destroy(); return 0; }
															#line 3489 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		new (&static_cast<CallActor6*>(this)->SAV< Void >::value()) Void(Void());
		this->~CallActor6State();
		static_cast<CallActor6*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(Reference<DirectorySubspace> const& dirSubspace,int loopDepth) 
	{
		loopDepth = a_body1cont3(dirSubspace, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Reference<DirectorySubspace> && dirSubspace,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(dirSubspace), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CallActor6*>(this)->actor_wait_state > 0) static_cast<CallActor6*>(this)->actor_wait_state = 0;
		static_cast<CallActor6*>(this)->ActorCallback< CallActor6, 2, Reference<DirectorySubspace> >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor6, 2, Reference<DirectorySubspace> >*,Reference<DirectorySubspace> const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor6*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CallActor6, 2, Reference<DirectorySubspace> >*,Reference<DirectorySubspace> && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor6*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CallActor6, 2, Reference<DirectorySubspace> >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor6*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 256 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	Reference<FlowTesterData> data;
															#line 256 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	Reference<InstructionData> instruction;
															#line 257 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	IDirectory::Path path;
															#line 3578 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
};
// This generated class is to be used only via call()
															#line 256 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
class CallActor6 final : public Actor<Void>, public ActorCallback< CallActor6, 0, IDirectory::Path >, public ActorCallback< CallActor6, 1, Tuple >, public ActorCallback< CallActor6, 2, Reference<DirectorySubspace> >, public FastAllocated<CallActor6>, public CallActor6State<CallActor6> {
															#line 3583 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
public:
	using FastAllocated<CallActor6>::operator new;
	using FastAllocated<CallActor6>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2925340698391154432UL, 7906335506767893504UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CallActor6, 0, IDirectory::Path >;
friend struct ActorCallback< CallActor6, 1, Tuple >;
friend struct ActorCallback< CallActor6, 2, Reference<DirectorySubspace> >;
															#line 256 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	CallActor6(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 3602 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		 : Actor<Void>(),
		   CallActor6State<CallActor6>(data, instruction),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2057654832222722560UL, 6470415639012464640UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor6*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("call");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CallActor6, 0, IDirectory::Path >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CallActor6, 1, Tuple >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CallActor6, 2, Reference<DirectorySubspace> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 256 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
[[nodiscard]] static Future<Void> call( Reference<FlowTesterData> const& data, Reference<InstructionData> const& instruction ) {
															#line 256 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	return Future<Void>(new CallActor6(data, instruction));
															#line 3636 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
}

#line 270 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
};
const char* DirectoryOpenFunc::name = "DIRECTORY_OPEN";
REGISTER_INSTRUCTION_FUNC(DirectoryOpenFunc);

// DIRECTORY_MOVE
struct DirectoryMoveFunc : InstructionFunc {
	static const char* name;

																#line 3648 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
// This generated class is to be used only via call()
															#line 278 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
template <class CallActor7>
															#line 278 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
class CallActor7State {
															#line 3654 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
public:
															#line 278 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	CallActor7State(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 278 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
															#line 278 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		 : data(data),
															#line 278 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		   instruction(instruction)
															#line 3663 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
	{
		fdb_probe_actor_create("call", reinterpret_cast<unsigned long>(this));

	}
	~CallActor7State() 
	{
		fdb_probe_actor_destroy("call", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 279 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			StrictFuture<std::vector<IDirectory::Path>> __when_expr_0 = popPaths(data, 2);
															#line 279 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			if (static_cast<CallActor7*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3680 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CallActor7*>(this)->actor_wait_state = 1;
															#line 279 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CallActor7, 0, std::vector<IDirectory::Path> >*>(static_cast<CallActor7*>(this)));
															#line 3685 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CallActor7State();
		static_cast<CallActor7*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<IDirectory::Path> const& paths,int loopDepth) 
	{
															#line 281 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		Reference<IDirectory> directory = data->directoryData.directory();
															#line 282 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		logOp(format("move %s to %s", pathToString(combinePaths(directory->getPath(), paths[0])).c_str(), pathToString(combinePaths(directory->getPath(), paths[1])).c_str()));
															#line 286 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		StrictFuture<Reference<DirectorySubspace>> __when_expr_1 = executeMutation( instruction, [this, directory, paths]() { return directory->move(instruction->tr, paths[0], paths[1]); });
															#line 286 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		if (static_cast<CallActor7*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3714 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CallActor7*>(this)->actor_wait_state = 2;
															#line 286 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CallActor7, 1, Reference<DirectorySubspace> >*>(static_cast<CallActor7*>(this)));
															#line 3719 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<IDirectory::Path> && paths,int loopDepth) 
	{
															#line 281 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		Reference<IDirectory> directory = data->directoryData.directory();
															#line 282 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		logOp(format("move %s to %s", pathToString(combinePaths(directory->getPath(), paths[0])).c_str(), pathToString(combinePaths(directory->getPath(), paths[1])).c_str()));
															#line 286 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		StrictFuture<Reference<DirectorySubspace>> __when_expr_1 = executeMutation( instruction, [this, directory, paths]() { return directory->move(instruction->tr, paths[0], paths[1]); });
															#line 286 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		if (static_cast<CallActor7*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3734 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CallActor7*>(this)->actor_wait_state = 2;
															#line 286 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CallActor7, 1, Reference<DirectorySubspace> >*>(static_cast<CallActor7*>(this)));
															#line 3739 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(std::vector<IDirectory::Path> const& paths,int loopDepth) 
	{
		loopDepth = a_body1cont1(paths, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<IDirectory::Path> && paths,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(paths), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CallActor7*>(this)->actor_wait_state > 0) static_cast<CallActor7*>(this)->actor_wait_state = 0;
		static_cast<CallActor7*>(this)->ActorCallback< CallActor7, 0, std::vector<IDirectory::Path> >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor7, 0, std::vector<IDirectory::Path> >*,std::vector<IDirectory::Path> const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor7*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CallActor7, 0, std::vector<IDirectory::Path> >*,std::vector<IDirectory::Path> && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor7*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CallActor7, 0, std::vector<IDirectory::Path> >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor7*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Reference<DirectorySubspace> const& dirSubspace,int loopDepth) 
	{
															#line 289 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		data->directoryData.push(dirSubspace);
															#line 291 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		if (!static_cast<CallActor7*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor7State(); static_cast<CallActor7*>(this)->destroy(); return 0; }
															#line 3825 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		new (&static_cast<CallActor7*>(this)->SAV< Void >::value()) Void(Void());
		this->~CallActor7State();
		static_cast<CallActor7*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Reference<DirectorySubspace> && dirSubspace,int loopDepth) 
	{
															#line 289 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		data->directoryData.push(dirSubspace);
															#line 291 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		if (!static_cast<CallActor7*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor7State(); static_cast<CallActor7*>(this)->destroy(); return 0; }
															#line 3839 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		new (&static_cast<CallActor7*>(this)->SAV< Void >::value()) Void(Void());
		this->~CallActor7State();
		static_cast<CallActor7*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Reference<DirectorySubspace> const& dirSubspace,int loopDepth) 
	{
		loopDepth = a_body1cont2(dirSubspace, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Reference<DirectorySubspace> && dirSubspace,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(dirSubspace), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CallActor7*>(this)->actor_wait_state > 0) static_cast<CallActor7*>(this)->actor_wait_state = 0;
		static_cast<CallActor7*>(this)->ActorCallback< CallActor7, 1, Reference<DirectorySubspace> >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor7, 1, Reference<DirectorySubspace> >*,Reference<DirectorySubspace> const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor7*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CallActor7, 1, Reference<DirectorySubspace> >*,Reference<DirectorySubspace> && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor7*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CallActor7, 1, Reference<DirectorySubspace> >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor7*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 278 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	Reference<FlowTesterData> data;
															#line 278 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	Reference<InstructionData> instruction;
															#line 3926 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
};
// This generated class is to be used only via call()
															#line 278 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
class CallActor7 final : public Actor<Void>, public ActorCallback< CallActor7, 0, std::vector<IDirectory::Path> >, public ActorCallback< CallActor7, 1, Reference<DirectorySubspace> >, public FastAllocated<CallActor7>, public CallActor7State<CallActor7> {
															#line 3931 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
public:
	using FastAllocated<CallActor7>::operator new;
	using FastAllocated<CallActor7>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2925340698391154432UL, 7906335506767893504UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CallActor7, 0, std::vector<IDirectory::Path> >;
friend struct ActorCallback< CallActor7, 1, Reference<DirectorySubspace> >;
															#line 278 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	CallActor7(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 3949 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		 : Actor<Void>(),
		   CallActor7State<CallActor7>(data, instruction),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16126275780308219648UL, 15827223303016527872UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor7*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("call");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CallActor7, 0, std::vector<IDirectory::Path> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CallActor7, 1, Reference<DirectorySubspace> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 278 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
[[nodiscard]] static Future<Void> call( Reference<FlowTesterData> const& data, Reference<InstructionData> const& instruction ) {
															#line 278 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	return Future<Void>(new CallActor7(data, instruction));
															#line 3982 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
}

#line 293 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
};
const char* DirectoryMoveFunc::name = "DIRECTORY_MOVE";
REGISTER_INSTRUCTION_FUNC(DirectoryMoveFunc);

// DIRECTORY_MOVE_TO
struct DirectoryMoveToFunc : InstructionFunc {
	static const char* name;

																#line 3994 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
// This generated class is to be used only via call()
															#line 301 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
template <class CallActor8>
															#line 301 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
class CallActor8State {
															#line 4000 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
public:
															#line 301 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	CallActor8State(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 301 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
															#line 301 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		 : data(data),
															#line 301 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		   instruction(instruction)
															#line 4009 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
	{
		fdb_probe_actor_create("call", reinterpret_cast<unsigned long>(this));

	}
	~CallActor8State() 
	{
		fdb_probe_actor_destroy("call", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 302 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			StrictFuture<IDirectory::Path> __when_expr_0 = popPath(data);
															#line 302 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			if (static_cast<CallActor8*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4026 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CallActor8*>(this)->actor_wait_state = 1;
															#line 302 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CallActor8, 0, IDirectory::Path >*>(static_cast<CallActor8*>(this)));
															#line 4031 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CallActor8State();
		static_cast<CallActor8*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(IDirectory::Path const& path,int loopDepth) 
	{
															#line 304 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		Reference<IDirectory> directory = data->directoryData.directory();
															#line 305 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		logOp(format("move %s to %s", pathToString(directory->getPath()).c_str(), pathToString(path).c_str()));
															#line 307 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		StrictFuture<Reference<DirectorySubspace>> __when_expr_1 = executeMutation( instruction, [this, directory, path]() { return directory->moveTo(instruction->tr, path); });
															#line 307 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		if (static_cast<CallActor8*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4060 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CallActor8*>(this)->actor_wait_state = 2;
															#line 307 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CallActor8, 1, Reference<DirectorySubspace> >*>(static_cast<CallActor8*>(this)));
															#line 4065 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(IDirectory::Path && path,int loopDepth) 
	{
															#line 304 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		Reference<IDirectory> directory = data->directoryData.directory();
															#line 305 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		logOp(format("move %s to %s", pathToString(directory->getPath()).c_str(), pathToString(path).c_str()));
															#line 307 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		StrictFuture<Reference<DirectorySubspace>> __when_expr_1 = executeMutation( instruction, [this, directory, path]() { return directory->moveTo(instruction->tr, path); });
															#line 307 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		if (static_cast<CallActor8*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4080 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CallActor8*>(this)->actor_wait_state = 2;
															#line 307 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CallActor8, 1, Reference<DirectorySubspace> >*>(static_cast<CallActor8*>(this)));
															#line 4085 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(IDirectory::Path const& path,int loopDepth) 
	{
		loopDepth = a_body1cont1(path, loopDepth);

		return loopDepth;
	}
	int a_body1when1(IDirectory::Path && path,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(path), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CallActor8*>(this)->actor_wait_state > 0) static_cast<CallActor8*>(this)->actor_wait_state = 0;
		static_cast<CallActor8*>(this)->ActorCallback< CallActor8, 0, IDirectory::Path >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor8, 0, IDirectory::Path >*,IDirectory::Path const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor8*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CallActor8, 0, IDirectory::Path >*,IDirectory::Path && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor8*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CallActor8, 0, IDirectory::Path >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor8*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Reference<DirectorySubspace> const& dirSubspace,int loopDepth) 
	{
															#line 310 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		data->directoryData.push(dirSubspace);
															#line 312 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		if (!static_cast<CallActor8*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor8State(); static_cast<CallActor8*>(this)->destroy(); return 0; }
															#line 4171 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		new (&static_cast<CallActor8*>(this)->SAV< Void >::value()) Void(Void());
		this->~CallActor8State();
		static_cast<CallActor8*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Reference<DirectorySubspace> && dirSubspace,int loopDepth) 
	{
															#line 310 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		data->directoryData.push(dirSubspace);
															#line 312 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		if (!static_cast<CallActor8*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor8State(); static_cast<CallActor8*>(this)->destroy(); return 0; }
															#line 4185 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		new (&static_cast<CallActor8*>(this)->SAV< Void >::value()) Void(Void());
		this->~CallActor8State();
		static_cast<CallActor8*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Reference<DirectorySubspace> const& dirSubspace,int loopDepth) 
	{
		loopDepth = a_body1cont2(dirSubspace, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Reference<DirectorySubspace> && dirSubspace,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(dirSubspace), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CallActor8*>(this)->actor_wait_state > 0) static_cast<CallActor8*>(this)->actor_wait_state = 0;
		static_cast<CallActor8*>(this)->ActorCallback< CallActor8, 1, Reference<DirectorySubspace> >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor8, 1, Reference<DirectorySubspace> >*,Reference<DirectorySubspace> const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor8*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CallActor8, 1, Reference<DirectorySubspace> >*,Reference<DirectorySubspace> && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor8*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CallActor8, 1, Reference<DirectorySubspace> >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor8*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 301 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	Reference<FlowTesterData> data;
															#line 301 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	Reference<InstructionData> instruction;
															#line 4272 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
};
// This generated class is to be used only via call()
															#line 301 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
class CallActor8 final : public Actor<Void>, public ActorCallback< CallActor8, 0, IDirectory::Path >, public ActorCallback< CallActor8, 1, Reference<DirectorySubspace> >, public FastAllocated<CallActor8>, public CallActor8State<CallActor8> {
															#line 4277 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
public:
	using FastAllocated<CallActor8>::operator new;
	using FastAllocated<CallActor8>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2925340698391154432UL, 7906335506767893504UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CallActor8, 0, IDirectory::Path >;
friend struct ActorCallback< CallActor8, 1, Reference<DirectorySubspace> >;
															#line 301 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	CallActor8(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 4295 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		 : Actor<Void>(),
		   CallActor8State<CallActor8>(data, instruction),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3112439155534353664UL, 8740650210331251712UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor8*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("call");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CallActor8, 0, IDirectory::Path >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CallActor8, 1, Reference<DirectorySubspace> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 301 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
[[nodiscard]] static Future<Void> call( Reference<FlowTesterData> const& data, Reference<InstructionData> const& instruction ) {
															#line 301 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	return Future<Void>(new CallActor8(data, instruction));
															#line 4328 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
}

#line 314 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
};
const char* DirectoryMoveToFunc::name = "DIRECTORY_MOVE_TO";
REGISTER_INSTRUCTION_FUNC(DirectoryMoveToFunc);

// DIRECTORY_REMOVE
struct DirectoryRemoveFunc : InstructionFunc {
	static const char* name;

																#line 4340 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
// This generated class is to be used only via call()
															#line 322 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
template <class CallActor9>
															#line 322 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
class CallActor9State {
															#line 4346 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
public:
															#line 322 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	CallActor9State(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 322 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
															#line 322 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		 : data(data),
															#line 322 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		   instruction(instruction)
															#line 4355 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
	{
		fdb_probe_actor_create("call", reinterpret_cast<unsigned long>(this));

	}
	~CallActor9State() 
	{
		fdb_probe_actor_destroy("call", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 323 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			StrictFuture<Tuple> __when_expr_0 = data->stack.waitAndPop();
															#line 323 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			if (static_cast<CallActor9*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4372 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CallActor9*>(this)->actor_wait_state = 1;
															#line 323 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CallActor9, 0, Tuple >*>(static_cast<CallActor9*>(this)));
															#line 4377 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CallActor9State();
		static_cast<CallActor9*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Tuple const& count,int loopDepth) 
	{
															#line 324 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		directory = data->directoryData.directory();
															#line 325 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		if (count.getInt(0) == 0)
															#line 4402 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		{
															#line 326 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			logOp(format("remove %s", pathToString(directory->getPath()).c_str()));
															#line 328 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			StrictFuture<Void> __when_expr_1 = executeMutation(instruction, [this]() { return directory->remove(instruction->tr); });
															#line 328 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			if (static_cast<CallActor9*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4410 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<CallActor9*>(this)->actor_wait_state = 2;
															#line 328 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CallActor9, 1, Void >*>(static_cast<CallActor9*>(this)));
															#line 4415 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 330 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			StrictFuture<IDirectory::Path> __when_expr_2 = popPath(data);
															#line 330 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			if (static_cast<CallActor9*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4424 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1when2(__when_expr_2.get(), loopDepth); };
			static_cast<CallActor9*>(this)->actor_wait_state = 3;
															#line 330 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CallActor9, 2, IDirectory::Path >*>(static_cast<CallActor9*>(this)));
															#line 4429 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont1(Tuple && count,int loopDepth) 
	{
															#line 324 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		directory = data->directoryData.directory();
															#line 325 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		if (count.getInt(0) == 0)
															#line 4441 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		{
															#line 326 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			logOp(format("remove %s", pathToString(directory->getPath()).c_str()));
															#line 328 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			StrictFuture<Void> __when_expr_1 = executeMutation(instruction, [this]() { return directory->remove(instruction->tr); });
															#line 328 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			if (static_cast<CallActor9*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4449 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<CallActor9*>(this)->actor_wait_state = 2;
															#line 328 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CallActor9, 1, Void >*>(static_cast<CallActor9*>(this)));
															#line 4454 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 330 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			StrictFuture<IDirectory::Path> __when_expr_2 = popPath(data);
															#line 330 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			if (static_cast<CallActor9*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4463 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1when2(__when_expr_2.get(), loopDepth); };
			static_cast<CallActor9*>(this)->actor_wait_state = 3;
															#line 330 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CallActor9, 2, IDirectory::Path >*>(static_cast<CallActor9*>(this)));
															#line 4468 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1when1(Tuple const& count,int loopDepth) 
	{
		loopDepth = a_body1cont1(count, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Tuple && count,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(count), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CallActor9*>(this)->actor_wait_state > 0) static_cast<CallActor9*>(this)->actor_wait_state = 0;
		static_cast<CallActor9*>(this)->ActorCallback< CallActor9, 0, Tuple >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor9, 0, Tuple >*,Tuple const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor9*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CallActor9, 0, Tuple >*,Tuple && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor9*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CallActor9, 0, Tuple >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor9*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 336 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		if (!static_cast<CallActor9*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor9State(); static_cast<CallActor9*>(this)->destroy(); return 0; }
															#line 4553 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		new (&static_cast<CallActor9*>(this)->SAV< Void >::value()) Void(Void());
		this->~CallActor9State();
		static_cast<CallActor9*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CallActor9*>(this)->actor_wait_state > 0) static_cast<CallActor9*>(this)->actor_wait_state = 0;
		static_cast<CallActor9*>(this)->ActorCallback< CallActor9, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor9, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor9*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CallActor9, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor9*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CallActor9, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor9*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(IDirectory::Path const& path,int loopDepth) 
	{
															#line 331 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		logOp(format("remove %s", pathToString(combinePaths(directory->getPath(), path)).c_str()));
															#line 333 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		StrictFuture<Void> __when_expr_3 = executeMutation(instruction, [this, path]() { return directory->remove(instruction->tr, path); });
															#line 333 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		if (static_cast<CallActor9*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4656 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont4when1(__when_expr_3.get(), loopDepth); };
		static_cast<CallActor9*>(this)->actor_wait_state = 4;
															#line 333 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CallActor9, 3, Void >*>(static_cast<CallActor9*>(this)));
															#line 4661 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(IDirectory::Path && path,int loopDepth) 
	{
															#line 331 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		logOp(format("remove %s", pathToString(combinePaths(directory->getPath(), path)).c_str()));
															#line 333 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		StrictFuture<Void> __when_expr_3 = executeMutation(instruction, [this, path]() { return directory->remove(instruction->tr, path); });
															#line 333 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		if (static_cast<CallActor9*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4674 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont4when1(__when_expr_3.get(), loopDepth); };
		static_cast<CallActor9*>(this)->actor_wait_state = 4;
															#line 333 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CallActor9, 3, Void >*>(static_cast<CallActor9*>(this)));
															#line 4679 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when2(IDirectory::Path const& path,int loopDepth) 
	{
		loopDepth = a_body1cont4(path, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when2(IDirectory::Path && path,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(path), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CallActor9*>(this)->actor_wait_state > 0) static_cast<CallActor9*>(this)->actor_wait_state = 0;
		static_cast<CallActor9*>(this)->ActorCallback< CallActor9, 2, IDirectory::Path >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor9, 2, IDirectory::Path >*,IDirectory::Path const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor9*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CallActor9, 2, IDirectory::Path >*,IDirectory::Path && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor9*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CallActor9, 2, IDirectory::Path >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor9*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<CallActor9*>(this)->actor_wait_state > 0) static_cast<CallActor9*>(this)->actor_wait_state = 0;
		static_cast<CallActor9*>(this)->ActorCallback< CallActor9, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor9, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor9*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< CallActor9, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor9*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< CallActor9, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor9*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 322 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	Reference<FlowTesterData> data;
															#line 322 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	Reference<InstructionData> instruction;
															#line 324 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	Reference<IDirectory> directory;
															#line 4852 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
};
// This generated class is to be used only via call()
															#line 322 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
class CallActor9 final : public Actor<Void>, public ActorCallback< CallActor9, 0, Tuple >, public ActorCallback< CallActor9, 1, Void >, public ActorCallback< CallActor9, 2, IDirectory::Path >, public ActorCallback< CallActor9, 3, Void >, public FastAllocated<CallActor9>, public CallActor9State<CallActor9> {
															#line 4857 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
public:
	using FastAllocated<CallActor9>::operator new;
	using FastAllocated<CallActor9>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2925340698391154432UL, 7906335506767893504UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CallActor9, 0, Tuple >;
friend struct ActorCallback< CallActor9, 1, Void >;
friend struct ActorCallback< CallActor9, 2, IDirectory::Path >;
friend struct ActorCallback< CallActor9, 3, Void >;
															#line 322 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	CallActor9(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 4877 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		 : Actor<Void>(),
		   CallActor9State<CallActor9>(data, instruction),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1262208671142567936UL, 15420667126183834624UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor9*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("call");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CallActor9, 0, Tuple >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CallActor9, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CallActor9, 2, IDirectory::Path >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< CallActor9, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 322 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
[[nodiscard]] static Future<Void> call( Reference<FlowTesterData> const& data, Reference<InstructionData> const& instruction ) {
															#line 322 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	return Future<Void>(new CallActor9(data, instruction));
															#line 4912 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
}

#line 338 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
};
const char* DirectoryRemoveFunc::name = "DIRECTORY_REMOVE";
REGISTER_INSTRUCTION_FUNC(DirectoryRemoveFunc);

// DIRECTORY_REMOVE_IF_EXISTS
struct DirectoryRemoveIfExistsFunc : InstructionFunc {
	static const char* name;

																#line 4924 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
// This generated class is to be used only via call()
															#line 346 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
template <class CallActor10>
															#line 346 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
class CallActor10State {
															#line 4930 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
public:
															#line 346 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	CallActor10State(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 346 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
															#line 346 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		 : data(data),
															#line 346 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		   instruction(instruction)
															#line 4939 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
	{
		fdb_probe_actor_create("call", reinterpret_cast<unsigned long>(this));

	}
	~CallActor10State() 
	{
		fdb_probe_actor_destroy("call", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 347 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			StrictFuture<Tuple> __when_expr_0 = data->stack.waitAndPop();
															#line 347 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			if (static_cast<CallActor10*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4956 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CallActor10*>(this)->actor_wait_state = 1;
															#line 347 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CallActor10, 0, Tuple >*>(static_cast<CallActor10*>(this)));
															#line 4961 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CallActor10State();
		static_cast<CallActor10*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Tuple const& count,int loopDepth) 
	{
															#line 348 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		directory = data->directoryData.directory();
															#line 349 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		if (count.getInt(0) == 0)
															#line 4986 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		{
															#line 350 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			logOp(format("remove_if_exists %s", pathToString(directory->getPath()).c_str()));
															#line 352 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			StrictFuture<Void> __when_expr_1 = success(executeMutation(instruction, [this]() { return directory->removeIfExists(instruction->tr); }));
															#line 352 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			if (static_cast<CallActor10*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4994 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<CallActor10*>(this)->actor_wait_state = 2;
															#line 352 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CallActor10, 1, Void >*>(static_cast<CallActor10*>(this)));
															#line 4999 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 355 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			StrictFuture<IDirectory::Path> __when_expr_2 = popPath(data);
															#line 355 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			if (static_cast<CallActor10*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5008 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1when2(__when_expr_2.get(), loopDepth); };
			static_cast<CallActor10*>(this)->actor_wait_state = 3;
															#line 355 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CallActor10, 2, IDirectory::Path >*>(static_cast<CallActor10*>(this)));
															#line 5013 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont1(Tuple && count,int loopDepth) 
	{
															#line 348 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		directory = data->directoryData.directory();
															#line 349 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		if (count.getInt(0) == 0)
															#line 5025 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		{
															#line 350 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			logOp(format("remove_if_exists %s", pathToString(directory->getPath()).c_str()));
															#line 352 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			StrictFuture<Void> __when_expr_1 = success(executeMutation(instruction, [this]() { return directory->removeIfExists(instruction->tr); }));
															#line 352 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			if (static_cast<CallActor10*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5033 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<CallActor10*>(this)->actor_wait_state = 2;
															#line 352 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CallActor10, 1, Void >*>(static_cast<CallActor10*>(this)));
															#line 5038 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 355 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			StrictFuture<IDirectory::Path> __when_expr_2 = popPath(data);
															#line 355 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			if (static_cast<CallActor10*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5047 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1when2(__when_expr_2.get(), loopDepth); };
			static_cast<CallActor10*>(this)->actor_wait_state = 3;
															#line 355 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CallActor10, 2, IDirectory::Path >*>(static_cast<CallActor10*>(this)));
															#line 5052 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1when1(Tuple const& count,int loopDepth) 
	{
		loopDepth = a_body1cont1(count, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Tuple && count,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(count), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CallActor10*>(this)->actor_wait_state > 0) static_cast<CallActor10*>(this)->actor_wait_state = 0;
		static_cast<CallActor10*>(this)->ActorCallback< CallActor10, 0, Tuple >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor10, 0, Tuple >*,Tuple const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor10*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CallActor10, 0, Tuple >*,Tuple && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor10*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CallActor10, 0, Tuple >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor10*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 362 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		if (!static_cast<CallActor10*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor10State(); static_cast<CallActor10*>(this)->destroy(); return 0; }
															#line 5137 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		new (&static_cast<CallActor10*>(this)->SAV< Void >::value()) Void(Void());
		this->~CallActor10State();
		static_cast<CallActor10*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CallActor10*>(this)->actor_wait_state > 0) static_cast<CallActor10*>(this)->actor_wait_state = 0;
		static_cast<CallActor10*>(this)->ActorCallback< CallActor10, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor10, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor10*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CallActor10, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor10*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CallActor10, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor10*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(IDirectory::Path const& path,int loopDepth) 
	{
															#line 356 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		logOp(format("remove_if_exists %s", pathToString(combinePaths(directory->getPath(), path)).c_str()));
															#line 358 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		StrictFuture<Void> __when_expr_3 = success(executeMutation(instruction, [this, path]() { return directory->removeIfExists(instruction->tr, path); }));
															#line 358 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		if (static_cast<CallActor10*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5240 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont4when1(__when_expr_3.get(), loopDepth); };
		static_cast<CallActor10*>(this)->actor_wait_state = 4;
															#line 358 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CallActor10, 3, Void >*>(static_cast<CallActor10*>(this)));
															#line 5245 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(IDirectory::Path && path,int loopDepth) 
	{
															#line 356 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		logOp(format("remove_if_exists %s", pathToString(combinePaths(directory->getPath(), path)).c_str()));
															#line 358 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		StrictFuture<Void> __when_expr_3 = success(executeMutation(instruction, [this, path]() { return directory->removeIfExists(instruction->tr, path); }));
															#line 358 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		if (static_cast<CallActor10*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5258 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont4when1(__when_expr_3.get(), loopDepth); };
		static_cast<CallActor10*>(this)->actor_wait_state = 4;
															#line 358 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CallActor10, 3, Void >*>(static_cast<CallActor10*>(this)));
															#line 5263 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when2(IDirectory::Path const& path,int loopDepth) 
	{
		loopDepth = a_body1cont4(path, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when2(IDirectory::Path && path,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(path), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CallActor10*>(this)->actor_wait_state > 0) static_cast<CallActor10*>(this)->actor_wait_state = 0;
		static_cast<CallActor10*>(this)->ActorCallback< CallActor10, 2, IDirectory::Path >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor10, 2, IDirectory::Path >*,IDirectory::Path const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor10*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CallActor10, 2, IDirectory::Path >*,IDirectory::Path && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor10*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CallActor10, 2, IDirectory::Path >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor10*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<CallActor10*>(this)->actor_wait_state > 0) static_cast<CallActor10*>(this)->actor_wait_state = 0;
		static_cast<CallActor10*>(this)->ActorCallback< CallActor10, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor10, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor10*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< CallActor10, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor10*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< CallActor10, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor10*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 346 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	Reference<FlowTesterData> data;
															#line 346 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	Reference<InstructionData> instruction;
															#line 348 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	Reference<IDirectory> directory;
															#line 5436 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
};
// This generated class is to be used only via call()
															#line 346 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
class CallActor10 final : public Actor<Void>, public ActorCallback< CallActor10, 0, Tuple >, public ActorCallback< CallActor10, 1, Void >, public ActorCallback< CallActor10, 2, IDirectory::Path >, public ActorCallback< CallActor10, 3, Void >, public FastAllocated<CallActor10>, public CallActor10State<CallActor10> {
															#line 5441 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
public:
	using FastAllocated<CallActor10>::operator new;
	using FastAllocated<CallActor10>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2925340698391154432UL, 7906335506767893504UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CallActor10, 0, Tuple >;
friend struct ActorCallback< CallActor10, 1, Void >;
friend struct ActorCallback< CallActor10, 2, IDirectory::Path >;
friend struct ActorCallback< CallActor10, 3, Void >;
															#line 346 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	CallActor10(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 5461 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		 : Actor<Void>(),
		   CallActor10State<CallActor10>(data, instruction),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3522948110971150336UL, 7853058901089034240UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor10*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("call");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CallActor10, 0, Tuple >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CallActor10, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CallActor10, 2, IDirectory::Path >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< CallActor10, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 346 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
[[nodiscard]] static Future<Void> call( Reference<FlowTesterData> const& data, Reference<InstructionData> const& instruction ) {
															#line 346 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	return Future<Void>(new CallActor10(data, instruction));
															#line 5496 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
}

#line 364 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
};
const char* DirectoryRemoveIfExistsFunc::name = "DIRECTORY_REMOVE_IF_EXISTS";
REGISTER_INSTRUCTION_FUNC(DirectoryRemoveIfExistsFunc);

// DIRECTORY_LIST
struct DirectoryListFunc : InstructionFunc {
	static const char* name;

																#line 5508 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
// This generated class is to be used only via call()
															#line 372 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
template <class CallActor11>
															#line 372 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
class CallActor11State {
															#line 5514 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
public:
															#line 372 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	CallActor11State(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 372 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
															#line 372 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		 : data(data),
															#line 372 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		   instruction(instruction)
															#line 5523 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
	{
		fdb_probe_actor_create("call", reinterpret_cast<unsigned long>(this));

	}
	~CallActor11State() 
	{
		fdb_probe_actor_destroy("call", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 373 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			StrictFuture<Tuple> __when_expr_0 = data->stack.waitAndPop();
															#line 373 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			if (static_cast<CallActor11*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5540 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CallActor11*>(this)->actor_wait_state = 1;
															#line 373 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CallActor11, 0, Tuple >*>(static_cast<CallActor11*>(this)));
															#line 5545 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CallActor11State();
		static_cast<CallActor11*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Tuple const& count,int loopDepth) 
	{
															#line 374 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		directory = data->directoryData.directory();
															#line 375 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		subdirs = Standalone<VectorRef<StringRef>>();
															#line 376 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		if (count.getInt(0) == 0)
															#line 5572 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		{
															#line 377 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			logOp(format("list %s", pathToString(directory->getPath()).c_str()));
															#line 378 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			StrictFuture<Standalone<VectorRef<StringRef>>> __when_expr_1 = directory->list(instruction->tr);
															#line 378 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			if (static_cast<CallActor11*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5580 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<CallActor11*>(this)->actor_wait_state = 2;
															#line 378 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CallActor11, 1, Standalone<VectorRef<StringRef>> >*>(static_cast<CallActor11*>(this)));
															#line 5585 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 381 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			StrictFuture<IDirectory::Path> __when_expr_2 = popPath(data);
															#line 381 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			if (static_cast<CallActor11*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5594 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1when2(__when_expr_2.get(), loopDepth); };
			static_cast<CallActor11*>(this)->actor_wait_state = 3;
															#line 381 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CallActor11, 2, IDirectory::Path >*>(static_cast<CallActor11*>(this)));
															#line 5599 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont1(Tuple && count,int loopDepth) 
	{
															#line 374 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		directory = data->directoryData.directory();
															#line 375 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		subdirs = Standalone<VectorRef<StringRef>>();
															#line 376 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		if (count.getInt(0) == 0)
															#line 5613 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		{
															#line 377 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			logOp(format("list %s", pathToString(directory->getPath()).c_str()));
															#line 378 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			StrictFuture<Standalone<VectorRef<StringRef>>> __when_expr_1 = directory->list(instruction->tr);
															#line 378 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			if (static_cast<CallActor11*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5621 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<CallActor11*>(this)->actor_wait_state = 2;
															#line 378 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CallActor11, 1, Standalone<VectorRef<StringRef>> >*>(static_cast<CallActor11*>(this)));
															#line 5626 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 381 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			StrictFuture<IDirectory::Path> __when_expr_2 = popPath(data);
															#line 381 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			if (static_cast<CallActor11*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5635 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1when2(__when_expr_2.get(), loopDepth); };
			static_cast<CallActor11*>(this)->actor_wait_state = 3;
															#line 381 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CallActor11, 2, IDirectory::Path >*>(static_cast<CallActor11*>(this)));
															#line 5640 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1when1(Tuple const& count,int loopDepth) 
	{
		loopDepth = a_body1cont1(count, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Tuple && count,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(count), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CallActor11*>(this)->actor_wait_state > 0) static_cast<CallActor11*>(this)->actor_wait_state = 0;
		static_cast<CallActor11*>(this)->ActorCallback< CallActor11, 0, Tuple >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor11, 0, Tuple >*,Tuple const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor11*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CallActor11, 0, Tuple >*,Tuple && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor11*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CallActor11, 0, Tuple >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor11*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 387 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		Tuple subdirTuple;
															#line 388 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		for( auto& sd : subdirs ) {
															#line 389 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			subdirTuple.append(sd, true);
															#line 5729 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		}
															#line 392 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		data->stack.pushTuple(subdirTuple.pack());
															#line 393 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		if (!static_cast<CallActor11*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor11State(); static_cast<CallActor11*>(this)->destroy(); return 0; }
															#line 5735 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		new (&static_cast<CallActor11*>(this)->SAV< Void >::value()) Void(Void());
		this->~CallActor11State();
		static_cast<CallActor11*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Standalone<VectorRef<StringRef>> const& _subdirs,int loopDepth) 
	{
															#line 379 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		subdirs = _subdirs;
															#line 5747 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Standalone<VectorRef<StringRef>> && _subdirs,int loopDepth) 
	{
															#line 379 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		subdirs = _subdirs;
															#line 5756 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Standalone<VectorRef<StringRef>> const& _subdirs,int loopDepth) 
	{
		loopDepth = a_body1cont3(_subdirs, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Standalone<VectorRef<StringRef>> && _subdirs,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_subdirs), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CallActor11*>(this)->actor_wait_state > 0) static_cast<CallActor11*>(this)->actor_wait_state = 0;
		static_cast<CallActor11*>(this)->ActorCallback< CallActor11, 1, Standalone<VectorRef<StringRef>> >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor11, 1, Standalone<VectorRef<StringRef>> >*,Standalone<VectorRef<StringRef>> const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor11*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CallActor11, 1, Standalone<VectorRef<StringRef>> >*,Standalone<VectorRef<StringRef>> && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor11*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CallActor11, 1, Standalone<VectorRef<StringRef>> >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor11*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(IDirectory::Path const& path,int loopDepth) 
	{
															#line 382 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		logOp(format("list %s", pathToString(combinePaths(directory->getPath(), path)).c_str()));
															#line 383 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		StrictFuture<Standalone<VectorRef<StringRef>>> __when_expr_3 = directory->list(instruction->tr, path);
															#line 383 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		if (static_cast<CallActor11*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5844 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont5when1(__when_expr_3.get(), loopDepth); };
		static_cast<CallActor11*>(this)->actor_wait_state = 4;
															#line 383 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CallActor11, 3, Standalone<VectorRef<StringRef>> >*>(static_cast<CallActor11*>(this)));
															#line 5849 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5(IDirectory::Path && path,int loopDepth) 
	{
															#line 382 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		logOp(format("list %s", pathToString(combinePaths(directory->getPath(), path)).c_str()));
															#line 383 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		StrictFuture<Standalone<VectorRef<StringRef>>> __when_expr_3 = directory->list(instruction->tr, path);
															#line 383 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		if (static_cast<CallActor11*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5862 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont5when1(__when_expr_3.get(), loopDepth); };
		static_cast<CallActor11*>(this)->actor_wait_state = 4;
															#line 383 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CallActor11, 3, Standalone<VectorRef<StringRef>> >*>(static_cast<CallActor11*>(this)));
															#line 5867 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when2(IDirectory::Path const& path,int loopDepth) 
	{
		loopDepth = a_body1cont5(path, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when2(IDirectory::Path && path,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(path), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CallActor11*>(this)->actor_wait_state > 0) static_cast<CallActor11*>(this)->actor_wait_state = 0;
		static_cast<CallActor11*>(this)->ActorCallback< CallActor11, 2, IDirectory::Path >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor11, 2, IDirectory::Path >*,IDirectory::Path const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor11*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CallActor11, 2, IDirectory::Path >*,IDirectory::Path && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor11*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CallActor11, 2, IDirectory::Path >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor11*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont6(Standalone<VectorRef<StringRef>> const& _subdirs,int loopDepth) 
	{
															#line 384 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		subdirs = _subdirs;
															#line 5951 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Standalone<VectorRef<StringRef>> && _subdirs,int loopDepth) 
	{
															#line 384 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		subdirs = _subdirs;
															#line 5960 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Standalone<VectorRef<StringRef>> const& _subdirs,int loopDepth) 
	{
		loopDepth = a_body1cont6(_subdirs, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Standalone<VectorRef<StringRef>> && _subdirs,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_subdirs), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<CallActor11*>(this)->actor_wait_state > 0) static_cast<CallActor11*>(this)->actor_wait_state = 0;
		static_cast<CallActor11*>(this)->ActorCallback< CallActor11, 3, Standalone<VectorRef<StringRef>> >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor11, 3, Standalone<VectorRef<StringRef>> >*,Standalone<VectorRef<StringRef>> const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor11*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< CallActor11, 3, Standalone<VectorRef<StringRef>> >*,Standalone<VectorRef<StringRef>> && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor11*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< CallActor11, 3, Standalone<VectorRef<StringRef>> >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor11*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 372 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	Reference<FlowTesterData> data;
															#line 372 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	Reference<InstructionData> instruction;
															#line 374 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	Reference<IDirectory> directory;
															#line 375 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	Standalone<VectorRef<StringRef>> subdirs;
															#line 6048 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
};
// This generated class is to be used only via call()
															#line 372 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
class CallActor11 final : public Actor<Void>, public ActorCallback< CallActor11, 0, Tuple >, public ActorCallback< CallActor11, 1, Standalone<VectorRef<StringRef>> >, public ActorCallback< CallActor11, 2, IDirectory::Path >, public ActorCallback< CallActor11, 3, Standalone<VectorRef<StringRef>> >, public FastAllocated<CallActor11>, public CallActor11State<CallActor11> {
															#line 6053 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
public:
	using FastAllocated<CallActor11>::operator new;
	using FastAllocated<CallActor11>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2925340698391154432UL, 7906335506767893504UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CallActor11, 0, Tuple >;
friend struct ActorCallback< CallActor11, 1, Standalone<VectorRef<StringRef>> >;
friend struct ActorCallback< CallActor11, 2, IDirectory::Path >;
friend struct ActorCallback< CallActor11, 3, Standalone<VectorRef<StringRef>> >;
															#line 372 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	CallActor11(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 6073 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		 : Actor<Void>(),
		   CallActor11State<CallActor11>(data, instruction),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6696347954121557504UL, 1612576802491870464UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor11*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("call");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CallActor11, 0, Tuple >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CallActor11, 1, Standalone<VectorRef<StringRef>> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CallActor11, 2, IDirectory::Path >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< CallActor11, 3, Standalone<VectorRef<StringRef>> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 372 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
[[nodiscard]] static Future<Void> call( Reference<FlowTesterData> const& data, Reference<InstructionData> const& instruction ) {
															#line 372 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	return Future<Void>(new CallActor11(data, instruction));
															#line 6108 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
}

#line 395 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
};
const char* DirectoryListFunc::name = "DIRECTORY_LIST";
REGISTER_INSTRUCTION_FUNC(DirectoryListFunc);

// DIRECTORY_EXISTS
struct DirectoryExistsFunc : InstructionFunc {
	static const char* name;

																#line 6120 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
// This generated class is to be used only via call()
															#line 403 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
template <class CallActor12>
															#line 403 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
class CallActor12State {
															#line 6126 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
public:
															#line 403 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	CallActor12State(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 403 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
															#line 403 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		 : data(data),
															#line 403 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		   instruction(instruction)
															#line 6135 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
	{
		fdb_probe_actor_create("call", reinterpret_cast<unsigned long>(this));

	}
	~CallActor12State() 
	{
		fdb_probe_actor_destroy("call", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 404 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			StrictFuture<Tuple> __when_expr_0 = data->stack.waitAndPop();
															#line 404 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			if (static_cast<CallActor12*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6152 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CallActor12*>(this)->actor_wait_state = 1;
															#line 404 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CallActor12, 0, Tuple >*>(static_cast<CallActor12*>(this)));
															#line 6157 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CallActor12State();
		static_cast<CallActor12*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Tuple const& count,int loopDepth) 
	{
															#line 405 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		directory = data->directoryData.directory();
															#line 406 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		result = bool();
															#line 407 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		if (count.getInt(0) == 0)
															#line 6184 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		{
															#line 408 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			StrictFuture<bool> __when_expr_1 = directory->exists(instruction->tr);
															#line 408 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			if (static_cast<CallActor12*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6190 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<CallActor12*>(this)->actor_wait_state = 2;
															#line 408 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CallActor12, 1, bool >*>(static_cast<CallActor12*>(this)));
															#line 6195 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 412 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			StrictFuture<IDirectory::Path> __when_expr_2 = popPath(data);
															#line 412 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			if (static_cast<CallActor12*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6204 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1when2(__when_expr_2.get(), loopDepth); };
			static_cast<CallActor12*>(this)->actor_wait_state = 3;
															#line 412 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CallActor12, 2, IDirectory::Path >*>(static_cast<CallActor12*>(this)));
															#line 6209 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont1(Tuple && count,int loopDepth) 
	{
															#line 405 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		directory = data->directoryData.directory();
															#line 406 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		result = bool();
															#line 407 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		if (count.getInt(0) == 0)
															#line 6223 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		{
															#line 408 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			StrictFuture<bool> __when_expr_1 = directory->exists(instruction->tr);
															#line 408 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			if (static_cast<CallActor12*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6229 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<CallActor12*>(this)->actor_wait_state = 2;
															#line 408 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CallActor12, 1, bool >*>(static_cast<CallActor12*>(this)));
															#line 6234 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 412 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			StrictFuture<IDirectory::Path> __when_expr_2 = popPath(data);
															#line 412 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			if (static_cast<CallActor12*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6243 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1when2(__when_expr_2.get(), loopDepth); };
			static_cast<CallActor12*>(this)->actor_wait_state = 3;
															#line 412 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CallActor12, 2, IDirectory::Path >*>(static_cast<CallActor12*>(this)));
															#line 6248 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1when1(Tuple const& count,int loopDepth) 
	{
		loopDepth = a_body1cont1(count, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Tuple && count,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(count), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CallActor12*>(this)->actor_wait_state > 0) static_cast<CallActor12*>(this)->actor_wait_state = 0;
		static_cast<CallActor12*>(this)->ActorCallback< CallActor12, 0, Tuple >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor12, 0, Tuple >*,Tuple const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor12*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CallActor12, 0, Tuple >*,Tuple && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor12*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CallActor12, 0, Tuple >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor12*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 418 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		data->stack.push(Tuple().append(result ? 1 : 0).pack());
															#line 419 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		if (!static_cast<CallActor12*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor12State(); static_cast<CallActor12*>(this)->destroy(); return 0; }
															#line 6335 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		new (&static_cast<CallActor12*>(this)->SAV< Void >::value()) Void(Void());
		this->~CallActor12State();
		static_cast<CallActor12*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(bool const& _result,int loopDepth) 
	{
															#line 409 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		result = _result;
															#line 410 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		logOp(format("exists %s: %d", pathToString(directory->getPath()).c_str(), result));
															#line 6349 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(bool && _result,int loopDepth) 
	{
															#line 409 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		result = _result;
															#line 410 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		logOp(format("exists %s: %d", pathToString(directory->getPath()).c_str(), result));
															#line 6360 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(bool const& _result,int loopDepth) 
	{
		loopDepth = a_body1cont3(_result, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(bool && _result,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CallActor12*>(this)->actor_wait_state > 0) static_cast<CallActor12*>(this)->actor_wait_state = 0;
		static_cast<CallActor12*>(this)->ActorCallback< CallActor12, 1, bool >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor12, 1, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor12*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CallActor12, 1, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor12*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CallActor12, 1, bool >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor12*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(int loopDepth) 
	{
															#line 413 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		StrictFuture<bool> __when_expr_3 = directory->exists(instruction->tr, path);
															#line 413 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		if (static_cast<CallActor12*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6446 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont5when1(__when_expr_3.get(), loopDepth); };
		static_cast<CallActor12*>(this)->actor_wait_state = 4;
															#line 413 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CallActor12, 3, bool >*>(static_cast<CallActor12*>(this)));
															#line 6451 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when2(IDirectory::Path const& __path,int loopDepth) 
	{
															#line 412 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		path = __path;
															#line 6460 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when2(IDirectory::Path && __path,int loopDepth) 
	{
		path = std::move(__path);
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CallActor12*>(this)->actor_wait_state > 0) static_cast<CallActor12*>(this)->actor_wait_state = 0;
		static_cast<CallActor12*>(this)->ActorCallback< CallActor12, 2, IDirectory::Path >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor12, 2, IDirectory::Path >*,IDirectory::Path const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor12*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CallActor12, 2, IDirectory::Path >*,IDirectory::Path && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor12*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CallActor12, 2, IDirectory::Path >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor12*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont6(bool const& _result,int loopDepth) 
	{
															#line 414 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		result = _result;
															#line 415 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		logOp(format("exists %s: %d", pathToString(combinePaths(directory->getPath(), path)).c_str(), result));
															#line 6541 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(bool && _result,int loopDepth) 
	{
															#line 414 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		result = _result;
															#line 415 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		logOp(format("exists %s: %d", pathToString(combinePaths(directory->getPath(), path)).c_str(), result));
															#line 6552 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(bool const& _result,int loopDepth) 
	{
		loopDepth = a_body1cont6(_result, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(bool && _result,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<CallActor12*>(this)->actor_wait_state > 0) static_cast<CallActor12*>(this)->actor_wait_state = 0;
		static_cast<CallActor12*>(this)->ActorCallback< CallActor12, 3, bool >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor12, 3, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor12*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< CallActor12, 3, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor12*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< CallActor12, 3, bool >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor12*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 403 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	Reference<FlowTesterData> data;
															#line 403 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	Reference<InstructionData> instruction;
															#line 405 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	Reference<IDirectory> directory;
															#line 406 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	bool result;
															#line 412 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	IDirectory::Path path;
															#line 6642 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
};
// This generated class is to be used only via call()
															#line 403 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
class CallActor12 final : public Actor<Void>, public ActorCallback< CallActor12, 0, Tuple >, public ActorCallback< CallActor12, 1, bool >, public ActorCallback< CallActor12, 2, IDirectory::Path >, public ActorCallback< CallActor12, 3, bool >, public FastAllocated<CallActor12>, public CallActor12State<CallActor12> {
															#line 6647 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
public:
	using FastAllocated<CallActor12>::operator new;
	using FastAllocated<CallActor12>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2925340698391154432UL, 7906335506767893504UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CallActor12, 0, Tuple >;
friend struct ActorCallback< CallActor12, 1, bool >;
friend struct ActorCallback< CallActor12, 2, IDirectory::Path >;
friend struct ActorCallback< CallActor12, 3, bool >;
															#line 403 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	CallActor12(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 6667 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		 : Actor<Void>(),
		   CallActor12State<CallActor12>(data, instruction),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17568513329667169024UL, 4132702070643368960UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor12*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("call");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CallActor12, 0, Tuple >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CallActor12, 1, bool >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CallActor12, 2, IDirectory::Path >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< CallActor12, 3, bool >*)0, actor_cancelled()); break;
		}

	}
};
															#line 403 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
[[nodiscard]] static Future<Void> call( Reference<FlowTesterData> const& data, Reference<InstructionData> const& instruction ) {
															#line 403 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	return Future<Void>(new CallActor12(data, instruction));
															#line 6702 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
}

#line 421 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
};
const char* DirectoryExistsFunc::name = "DIRECTORY_EXISTS";
REGISTER_INSTRUCTION_FUNC(DirectoryExistsFunc);

// DIRECTORY_PACK_KEY
struct DirectoryPackKeyFunc : InstructionFunc {
	static const char* name;

																#line 6714 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
// This generated class is to be used only via call()
															#line 429 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
template <class CallActor13>
															#line 429 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
class CallActor13State {
															#line 6720 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
public:
															#line 429 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	CallActor13State(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 429 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
															#line 429 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		 : data(data),
															#line 429 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		   instruction(instruction)
															#line 6729 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
	{
		fdb_probe_actor_create("call", reinterpret_cast<unsigned long>(this));

	}
	~CallActor13State() 
	{
		fdb_probe_actor_destroy("call", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 430 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			StrictFuture<Tuple> __when_expr_0 = popTuple(data);
															#line 430 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			if (static_cast<CallActor13*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6746 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CallActor13*>(this)->actor_wait_state = 1;
															#line 430 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CallActor13, 0, Tuple >*>(static_cast<CallActor13*>(this)));
															#line 6751 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CallActor13State();
		static_cast<CallActor13*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Tuple const& tuple,int loopDepth) 
	{
															#line 431 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		data->stack.pushTuple(data->directoryData.subspace()->pack(tuple));
															#line 433 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		if (!static_cast<CallActor13*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor13State(); static_cast<CallActor13*>(this)->destroy(); return 0; }
															#line 6776 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		new (&static_cast<CallActor13*>(this)->SAV< Void >::value()) Void(Void());
		this->~CallActor13State();
		static_cast<CallActor13*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Tuple && tuple,int loopDepth) 
	{
															#line 431 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		data->stack.pushTuple(data->directoryData.subspace()->pack(tuple));
															#line 433 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		if (!static_cast<CallActor13*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor13State(); static_cast<CallActor13*>(this)->destroy(); return 0; }
															#line 6790 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		new (&static_cast<CallActor13*>(this)->SAV< Void >::value()) Void(Void());
		this->~CallActor13State();
		static_cast<CallActor13*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Tuple const& tuple,int loopDepth) 
	{
		loopDepth = a_body1cont1(tuple, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Tuple && tuple,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(tuple), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CallActor13*>(this)->actor_wait_state > 0) static_cast<CallActor13*>(this)->actor_wait_state = 0;
		static_cast<CallActor13*>(this)->ActorCallback< CallActor13, 0, Tuple >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor13, 0, Tuple >*,Tuple const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor13*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CallActor13, 0, Tuple >*,Tuple && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor13*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CallActor13, 0, Tuple >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor13*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 429 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	Reference<FlowTesterData> data;
															#line 429 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	Reference<InstructionData> instruction;
															#line 6877 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
};
// This generated class is to be used only via call()
															#line 429 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
class CallActor13 final : public Actor<Void>, public ActorCallback< CallActor13, 0, Tuple >, public FastAllocated<CallActor13>, public CallActor13State<CallActor13> {
															#line 6882 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
public:
	using FastAllocated<CallActor13>::operator new;
	using FastAllocated<CallActor13>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2925340698391154432UL, 7906335506767893504UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CallActor13, 0, Tuple >;
															#line 429 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	CallActor13(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 6899 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		 : Actor<Void>(),
		   CallActor13State<CallActor13>(data, instruction),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11142119912061252096UL, 1170081608514710272UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor13*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("call");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CallActor13, 0, Tuple >*)0, actor_cancelled()); break;
		}

	}
};
															#line 429 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
[[nodiscard]] static Future<Void> call( Reference<FlowTesterData> const& data, Reference<InstructionData> const& instruction ) {
															#line 429 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	return Future<Void>(new CallActor13(data, instruction));
															#line 6931 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
}

#line 435 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
};
const char* DirectoryPackKeyFunc::name = "DIRECTORY_PACK_KEY";
REGISTER_INSTRUCTION_FUNC(DirectoryPackKeyFunc);

// DIRECTORY_UNPACK_KEY
struct DirectoryUnpackKeyFunc : InstructionFunc {
	static const char* name;

																#line 6943 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
// This generated class is to be used only via call()
															#line 443 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
template <class CallActor14>
															#line 443 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
class CallActor14State {
															#line 6949 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
public:
															#line 443 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	CallActor14State(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 443 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
															#line 443 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		 : data(data),
															#line 443 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		   instruction(instruction)
															#line 6958 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
	{
		fdb_probe_actor_create("call", reinterpret_cast<unsigned long>(this));

	}
	~CallActor14State() 
	{
		fdb_probe_actor_destroy("call", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 444 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			StrictFuture<Tuple> __when_expr_0 = data->stack.waitAndPop();
															#line 444 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			if (static_cast<CallActor14*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6975 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CallActor14*>(this)->actor_wait_state = 1;
															#line 444 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CallActor14, 0, Tuple >*>(static_cast<CallActor14*>(this)));
															#line 6980 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CallActor14State();
		static_cast<CallActor14*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Tuple const& key,int loopDepth) 
	{
															#line 445 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		Subspace* subspace = data->directoryData.subspace();
															#line 446 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		logOp(format("Unpack %s in subspace with prefix %s", key.getString(0).printable().c_str(), subspace->key().printable().c_str()));
															#line 449 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		Tuple tuple = subspace->unpack(key.getString(0));
															#line 450 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		for(int i = 0;i < tuple.size();++i) {
															#line 451 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			data->stack.push(tuple.subTuple(i, i + 1).pack());
															#line 7011 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		}
															#line 454 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		if (!static_cast<CallActor14*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor14State(); static_cast<CallActor14*>(this)->destroy(); return 0; }
															#line 7015 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		new (&static_cast<CallActor14*>(this)->SAV< Void >::value()) Void(Void());
		this->~CallActor14State();
		static_cast<CallActor14*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Tuple && key,int loopDepth) 
	{
															#line 445 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		Subspace* subspace = data->directoryData.subspace();
															#line 446 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		logOp(format("Unpack %s in subspace with prefix %s", key.getString(0).printable().c_str(), subspace->key().printable().c_str()));
															#line 449 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		Tuple tuple = subspace->unpack(key.getString(0));
															#line 450 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		for(int i = 0;i < tuple.size();++i) {
															#line 451 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			data->stack.push(tuple.subTuple(i, i + 1).pack());
															#line 7035 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		}
															#line 454 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		if (!static_cast<CallActor14*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor14State(); static_cast<CallActor14*>(this)->destroy(); return 0; }
															#line 7039 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		new (&static_cast<CallActor14*>(this)->SAV< Void >::value()) Void(Void());
		this->~CallActor14State();
		static_cast<CallActor14*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Tuple const& key,int loopDepth) 
	{
		loopDepth = a_body1cont1(key, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Tuple && key,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(key), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CallActor14*>(this)->actor_wait_state > 0) static_cast<CallActor14*>(this)->actor_wait_state = 0;
		static_cast<CallActor14*>(this)->ActorCallback< CallActor14, 0, Tuple >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor14, 0, Tuple >*,Tuple const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor14*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CallActor14, 0, Tuple >*,Tuple && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor14*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CallActor14, 0, Tuple >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor14*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 443 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	Reference<FlowTesterData> data;
															#line 443 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	Reference<InstructionData> instruction;
															#line 7126 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
};
// This generated class is to be used only via call()
															#line 443 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
class CallActor14 final : public Actor<Void>, public ActorCallback< CallActor14, 0, Tuple >, public FastAllocated<CallActor14>, public CallActor14State<CallActor14> {
															#line 7131 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
public:
	using FastAllocated<CallActor14>::operator new;
	using FastAllocated<CallActor14>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2925340698391154432UL, 7906335506767893504UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CallActor14, 0, Tuple >;
															#line 443 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	CallActor14(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 7148 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		 : Actor<Void>(),
		   CallActor14State<CallActor14>(data, instruction),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9789270765737524736UL, 5353044720919876096UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor14*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("call");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CallActor14, 0, Tuple >*)0, actor_cancelled()); break;
		}

	}
};
															#line 443 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
[[nodiscard]] static Future<Void> call( Reference<FlowTesterData> const& data, Reference<InstructionData> const& instruction ) {
															#line 443 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	return Future<Void>(new CallActor14(data, instruction));
															#line 7180 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
}

#line 456 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
};
const char* DirectoryUnpackKeyFunc::name = "DIRECTORY_UNPACK_KEY";
REGISTER_INSTRUCTION_FUNC(DirectoryUnpackKeyFunc);

// DIRECTORY_RANGE
struct DirectoryRangeFunc : InstructionFunc {
	static const char* name;

																#line 7192 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
// This generated class is to be used only via call()
															#line 464 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
template <class CallActor15>
															#line 464 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
class CallActor15State {
															#line 7198 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
public:
															#line 464 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	CallActor15State(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 464 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
															#line 464 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		 : data(data),
															#line 464 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		   instruction(instruction)
															#line 7207 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
	{
		fdb_probe_actor_create("call", reinterpret_cast<unsigned long>(this));

	}
	~CallActor15State() 
	{
		fdb_probe_actor_destroy("call", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 465 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			StrictFuture<Tuple> __when_expr_0 = popTuple(data);
															#line 465 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			if (static_cast<CallActor15*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7224 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CallActor15*>(this)->actor_wait_state = 1;
															#line 465 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CallActor15, 0, Tuple >*>(static_cast<CallActor15*>(this)));
															#line 7229 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CallActor15State();
		static_cast<CallActor15*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Tuple const& tuple,int loopDepth) 
	{
															#line 466 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		KeyRange range = data->directoryData.subspace()->range(tuple);
															#line 467 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		data->stack.pushTuple(range.begin);
															#line 468 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		data->stack.pushTuple(range.end);
															#line 470 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		if (!static_cast<CallActor15*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor15State(); static_cast<CallActor15*>(this)->destroy(); return 0; }
															#line 7258 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		new (&static_cast<CallActor15*>(this)->SAV< Void >::value()) Void(Void());
		this->~CallActor15State();
		static_cast<CallActor15*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Tuple && tuple,int loopDepth) 
	{
															#line 466 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		KeyRange range = data->directoryData.subspace()->range(tuple);
															#line 467 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		data->stack.pushTuple(range.begin);
															#line 468 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		data->stack.pushTuple(range.end);
															#line 470 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		if (!static_cast<CallActor15*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor15State(); static_cast<CallActor15*>(this)->destroy(); return 0; }
															#line 7276 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		new (&static_cast<CallActor15*>(this)->SAV< Void >::value()) Void(Void());
		this->~CallActor15State();
		static_cast<CallActor15*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Tuple const& tuple,int loopDepth) 
	{
		loopDepth = a_body1cont1(tuple, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Tuple && tuple,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(tuple), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CallActor15*>(this)->actor_wait_state > 0) static_cast<CallActor15*>(this)->actor_wait_state = 0;
		static_cast<CallActor15*>(this)->ActorCallback< CallActor15, 0, Tuple >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor15, 0, Tuple >*,Tuple const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor15*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CallActor15, 0, Tuple >*,Tuple && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor15*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CallActor15, 0, Tuple >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor15*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 464 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	Reference<FlowTesterData> data;
															#line 464 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	Reference<InstructionData> instruction;
															#line 7363 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
};
// This generated class is to be used only via call()
															#line 464 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
class CallActor15 final : public Actor<Void>, public ActorCallback< CallActor15, 0, Tuple >, public FastAllocated<CallActor15>, public CallActor15State<CallActor15> {
															#line 7368 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
public:
	using FastAllocated<CallActor15>::operator new;
	using FastAllocated<CallActor15>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2925340698391154432UL, 7906335506767893504UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CallActor15, 0, Tuple >;
															#line 464 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	CallActor15(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 7385 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		 : Actor<Void>(),
		   CallActor15State<CallActor15>(data, instruction),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1001577460772027136UL, 5007029484457101568UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor15*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("call");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CallActor15, 0, Tuple >*)0, actor_cancelled()); break;
		}

	}
};
															#line 464 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
[[nodiscard]] static Future<Void> call( Reference<FlowTesterData> const& data, Reference<InstructionData> const& instruction ) {
															#line 464 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	return Future<Void>(new CallActor15(data, instruction));
															#line 7417 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
}

#line 472 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
};
const char* DirectoryRangeFunc::name = "DIRECTORY_RANGE";
REGISTER_INSTRUCTION_FUNC(DirectoryRangeFunc);

// DIRECTORY_CONTAINS
struct DirectoryContainsFunc : InstructionFunc {
	static const char* name;

																#line 7429 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
// This generated class is to be used only via call()
															#line 480 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
template <class CallActor16>
															#line 480 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
class CallActor16State {
															#line 7435 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
public:
															#line 480 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	CallActor16State(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 480 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
															#line 480 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		 : data(data),
															#line 480 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		   instruction(instruction)
															#line 7444 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
	{
		fdb_probe_actor_create("call", reinterpret_cast<unsigned long>(this));

	}
	~CallActor16State() 
	{
		fdb_probe_actor_destroy("call", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 481 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			StrictFuture<Tuple> __when_expr_0 = data->stack.waitAndPop();
															#line 481 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			if (static_cast<CallActor16*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7461 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CallActor16*>(this)->actor_wait_state = 1;
															#line 481 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CallActor16, 0, Tuple >*>(static_cast<CallActor16*>(this)));
															#line 7466 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CallActor16State();
		static_cast<CallActor16*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Tuple const& key,int loopDepth) 
	{
															#line 482 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		bool result = data->directoryData.subspace()->contains(key.getString(0));
															#line 483 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		data->stack.push(Tuple().append(result ? 1 : 0).pack());
															#line 485 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		if (!static_cast<CallActor16*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor16State(); static_cast<CallActor16*>(this)->destroy(); return 0; }
															#line 7493 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		new (&static_cast<CallActor16*>(this)->SAV< Void >::value()) Void(Void());
		this->~CallActor16State();
		static_cast<CallActor16*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Tuple && key,int loopDepth) 
	{
															#line 482 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		bool result = data->directoryData.subspace()->contains(key.getString(0));
															#line 483 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		data->stack.push(Tuple().append(result ? 1 : 0).pack());
															#line 485 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		if (!static_cast<CallActor16*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor16State(); static_cast<CallActor16*>(this)->destroy(); return 0; }
															#line 7509 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		new (&static_cast<CallActor16*>(this)->SAV< Void >::value()) Void(Void());
		this->~CallActor16State();
		static_cast<CallActor16*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Tuple const& key,int loopDepth) 
	{
		loopDepth = a_body1cont1(key, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Tuple && key,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(key), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CallActor16*>(this)->actor_wait_state > 0) static_cast<CallActor16*>(this)->actor_wait_state = 0;
		static_cast<CallActor16*>(this)->ActorCallback< CallActor16, 0, Tuple >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor16, 0, Tuple >*,Tuple const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor16*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CallActor16, 0, Tuple >*,Tuple && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor16*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CallActor16, 0, Tuple >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor16*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 480 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	Reference<FlowTesterData> data;
															#line 480 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	Reference<InstructionData> instruction;
															#line 7596 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
};
// This generated class is to be used only via call()
															#line 480 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
class CallActor16 final : public Actor<Void>, public ActorCallback< CallActor16, 0, Tuple >, public FastAllocated<CallActor16>, public CallActor16State<CallActor16> {
															#line 7601 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
public:
	using FastAllocated<CallActor16>::operator new;
	using FastAllocated<CallActor16>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2925340698391154432UL, 7906335506767893504UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CallActor16, 0, Tuple >;
															#line 480 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	CallActor16(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 7618 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		 : Actor<Void>(),
		   CallActor16State<CallActor16>(data, instruction),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10377893681063907840UL, 14239149758808705280UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor16*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("call");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CallActor16, 0, Tuple >*)0, actor_cancelled()); break;
		}

	}
};
															#line 480 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
[[nodiscard]] static Future<Void> call( Reference<FlowTesterData> const& data, Reference<InstructionData> const& instruction ) {
															#line 480 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	return Future<Void>(new CallActor16(data, instruction));
															#line 7650 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
}

#line 487 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
};
const char* DirectoryContainsFunc::name = "DIRECTORY_CONTAINS";
REGISTER_INSTRUCTION_FUNC(DirectoryContainsFunc);

// DIRECTORY_OPEN_SUBSPACE
struct DirectoryOpenSubspaceFunc : InstructionFunc {
	static const char* name;

																#line 7662 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
// This generated class is to be used only via call()
															#line 495 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
template <class CallActor17>
															#line 495 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
class CallActor17State {
															#line 7668 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
public:
															#line 495 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	CallActor17State(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 495 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
															#line 495 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		 : data(data),
															#line 495 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		   instruction(instruction)
															#line 7677 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
	{
		fdb_probe_actor_create("call", reinterpret_cast<unsigned long>(this));

	}
	~CallActor17State() 
	{
		fdb_probe_actor_destroy("call", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 496 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			StrictFuture<Tuple> __when_expr_0 = popTuple(data);
															#line 496 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			if (static_cast<CallActor17*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7694 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CallActor17*>(this)->actor_wait_state = 1;
															#line 496 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CallActor17, 0, Tuple >*>(static_cast<CallActor17*>(this)));
															#line 7699 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CallActor17State();
		static_cast<CallActor17*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Tuple const& tuple,int loopDepth) 
	{
															#line 497 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		Subspace* subspace = data->directoryData.subspace();
															#line 498 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		logOp(format("open_subspace %s (at %s)", tupleToString(tuple).c_str(), subspace->key().printable().c_str()));
															#line 499 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		Subspace* child = new Subspace(subspace->subspace(tuple));
															#line 500 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		data->directoryData.push(child);
															#line 502 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		if (!static_cast<CallActor17*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor17State(); static_cast<CallActor17*>(this)->destroy(); return 0; }
															#line 7730 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		new (&static_cast<CallActor17*>(this)->SAV< Void >::value()) Void(Void());
		this->~CallActor17State();
		static_cast<CallActor17*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Tuple && tuple,int loopDepth) 
	{
															#line 497 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		Subspace* subspace = data->directoryData.subspace();
															#line 498 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		logOp(format("open_subspace %s (at %s)", tupleToString(tuple).c_str(), subspace->key().printable().c_str()));
															#line 499 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		Subspace* child = new Subspace(subspace->subspace(tuple));
															#line 500 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		data->directoryData.push(child);
															#line 502 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		if (!static_cast<CallActor17*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor17State(); static_cast<CallActor17*>(this)->destroy(); return 0; }
															#line 7750 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		new (&static_cast<CallActor17*>(this)->SAV< Void >::value()) Void(Void());
		this->~CallActor17State();
		static_cast<CallActor17*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Tuple const& tuple,int loopDepth) 
	{
		loopDepth = a_body1cont1(tuple, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Tuple && tuple,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(tuple), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CallActor17*>(this)->actor_wait_state > 0) static_cast<CallActor17*>(this)->actor_wait_state = 0;
		static_cast<CallActor17*>(this)->ActorCallback< CallActor17, 0, Tuple >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor17, 0, Tuple >*,Tuple const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor17*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CallActor17, 0, Tuple >*,Tuple && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor17*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CallActor17, 0, Tuple >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor17*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 495 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	Reference<FlowTesterData> data;
															#line 495 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	Reference<InstructionData> instruction;
															#line 7837 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
};
// This generated class is to be used only via call()
															#line 495 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
class CallActor17 final : public Actor<Void>, public ActorCallback< CallActor17, 0, Tuple >, public FastAllocated<CallActor17>, public CallActor17State<CallActor17> {
															#line 7842 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
public:
	using FastAllocated<CallActor17>::operator new;
	using FastAllocated<CallActor17>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2925340698391154432UL, 7906335506767893504UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CallActor17, 0, Tuple >;
															#line 495 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	CallActor17(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 7859 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		 : Actor<Void>(),
		   CallActor17State<CallActor17>(data, instruction),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14162605372392254464UL, 17481129796109892096UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor17*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("call");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CallActor17, 0, Tuple >*)0, actor_cancelled()); break;
		}

	}
};
															#line 495 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
[[nodiscard]] static Future<Void> call( Reference<FlowTesterData> const& data, Reference<InstructionData> const& instruction ) {
															#line 495 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	return Future<Void>(new CallActor17(data, instruction));
															#line 7891 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
}

#line 504 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
};
const char* DirectoryOpenSubspaceFunc::name = "DIRECTORY_OPEN_SUBSPACE";
REGISTER_INSTRUCTION_FUNC(DirectoryOpenSubspaceFunc);

// DIRECTORY_LOG_SUBSPACE
struct DirectoryLogSubspaceFunc : InstructionFunc {
	static const char* name;

																#line 7903 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
// This generated class is to be used only via call()
															#line 512 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
template <class CallActor18>
															#line 512 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
class CallActor18State {
															#line 7909 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
public:
															#line 512 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	CallActor18State(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 512 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
															#line 512 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		 : data(data),
															#line 512 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		   instruction(instruction)
															#line 7918 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
	{
		fdb_probe_actor_create("call", reinterpret_cast<unsigned long>(this));

	}
	~CallActor18State() 
	{
		fdb_probe_actor_destroy("call", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 513 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			StrictFuture<Tuple> __when_expr_0 = data->stack.waitAndPop();
															#line 513 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			if (static_cast<CallActor18*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7935 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CallActor18*>(this)->actor_wait_state = 1;
															#line 513 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CallActor18, 0, Tuple >*>(static_cast<CallActor18*>(this)));
															#line 7940 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CallActor18State();
		static_cast<CallActor18*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Tuple const& prefix,int loopDepth) 
	{
															#line 514 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		Tuple tuple;
															#line 515 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		tuple.append(data->directoryData.directoryListIndex);
															#line 516 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		instruction->tr->set(Subspace(tuple, prefix.getString(0)).key(), data->directoryData.subspace()->key());
															#line 518 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		if (!static_cast<CallActor18*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor18State(); static_cast<CallActor18*>(this)->destroy(); return 0; }
															#line 7969 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		new (&static_cast<CallActor18*>(this)->SAV< Void >::value()) Void(Void());
		this->~CallActor18State();
		static_cast<CallActor18*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Tuple && prefix,int loopDepth) 
	{
															#line 514 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		Tuple tuple;
															#line 515 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		tuple.append(data->directoryData.directoryListIndex);
															#line 516 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		instruction->tr->set(Subspace(tuple, prefix.getString(0)).key(), data->directoryData.subspace()->key());
															#line 518 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		if (!static_cast<CallActor18*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor18State(); static_cast<CallActor18*>(this)->destroy(); return 0; }
															#line 7987 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		new (&static_cast<CallActor18*>(this)->SAV< Void >::value()) Void(Void());
		this->~CallActor18State();
		static_cast<CallActor18*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Tuple const& prefix,int loopDepth) 
	{
		loopDepth = a_body1cont1(prefix, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Tuple && prefix,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(prefix), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CallActor18*>(this)->actor_wait_state > 0) static_cast<CallActor18*>(this)->actor_wait_state = 0;
		static_cast<CallActor18*>(this)->ActorCallback< CallActor18, 0, Tuple >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor18, 0, Tuple >*,Tuple const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor18*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CallActor18, 0, Tuple >*,Tuple && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor18*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CallActor18, 0, Tuple >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor18*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 512 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	Reference<FlowTesterData> data;
															#line 512 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	Reference<InstructionData> instruction;
															#line 8074 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
};
// This generated class is to be used only via call()
															#line 512 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
class CallActor18 final : public Actor<Void>, public ActorCallback< CallActor18, 0, Tuple >, public FastAllocated<CallActor18>, public CallActor18State<CallActor18> {
															#line 8079 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
public:
	using FastAllocated<CallActor18>::operator new;
	using FastAllocated<CallActor18>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2925340698391154432UL, 7906335506767893504UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CallActor18, 0, Tuple >;
															#line 512 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	CallActor18(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 8096 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		 : Actor<Void>(),
		   CallActor18State<CallActor18>(data, instruction),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12288014878387528448UL, 17479771282318694656UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor18*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("call");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CallActor18, 0, Tuple >*)0, actor_cancelled()); break;
		}

	}
};
															#line 512 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
[[nodiscard]] static Future<Void> call( Reference<FlowTesterData> const& data, Reference<InstructionData> const& instruction ) {
															#line 512 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	return Future<Void>(new CallActor18(data, instruction));
															#line 8128 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
}

#line 520 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
};
const char* DirectoryLogSubspaceFunc::name = "DIRECTORY_LOG_SUBSPACE";
REGISTER_INSTRUCTION_FUNC(DirectoryLogSubspaceFunc);

// DIRECTORY_LOG_DIRECTORY
struct DirectoryLogDirectoryFunc : InstructionFunc {
	static const char* name;

																#line 8140 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
// This generated class is to be used only via call()
															#line 528 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
template <class CallActor19>
															#line 528 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
class CallActor19State {
															#line 8146 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
public:
															#line 528 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	CallActor19State(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 528 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
															#line 528 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		 : data(data),
															#line 528 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		   instruction(instruction),
															#line 529 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		   directory(data->directoryData.directory())
															#line 8157 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
	{
		fdb_probe_actor_create("call", reinterpret_cast<unsigned long>(this));

	}
	~CallActor19State() 
	{
		fdb_probe_actor_destroy("call", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 530 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			StrictFuture<Tuple> __when_expr_0 = data->stack.waitAndPop();
															#line 530 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			if (static_cast<CallActor19*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8174 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CallActor19*>(this)->actor_wait_state = 1;
															#line 530 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CallActor19, 0, Tuple >*>(static_cast<CallActor19*>(this)));
															#line 8179 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CallActor19State();
		static_cast<CallActor19*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 531 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		StrictFuture<bool> __when_expr_1 = directory->exists(instruction->tr);
															#line 531 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		if (static_cast<CallActor19*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8204 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CallActor19*>(this)->actor_wait_state = 2;
															#line 531 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CallActor19, 1, bool >*>(static_cast<CallActor19*>(this)));
															#line 8209 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Tuple const& __prefix,int loopDepth) 
	{
															#line 530 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		prefix = __prefix;
															#line 8218 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Tuple && __prefix,int loopDepth) 
	{
		prefix = std::move(__prefix);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CallActor19*>(this)->actor_wait_state > 0) static_cast<CallActor19*>(this)->actor_wait_state = 0;
		static_cast<CallActor19*>(this)->ActorCallback< CallActor19, 0, Tuple >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor19, 0, Tuple >*,Tuple const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor19*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CallActor19, 0, Tuple >*,Tuple && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor19*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CallActor19, 0, Tuple >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor19*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 533 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		childrenTuple = Tuple();
															#line 534 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		if (exists)
															#line 8299 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		{
															#line 535 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			StrictFuture<Standalone<VectorRef<StringRef>>> __when_expr_2 = directory->list(instruction->tr);
															#line 535 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			if (static_cast<CallActor19*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8305 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<CallActor19*>(this)->actor_wait_state = 3;
															#line 535 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CallActor19, 2, Standalone<VectorRef<StringRef>> >*>(static_cast<CallActor19*>(this)));
															#line 8310 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1when1(bool const& __exists,int loopDepth) 
	{
															#line 531 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		exists = __exists;
															#line 8324 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(bool && __exists,int loopDepth) 
	{
		exists = std::move(__exists);
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CallActor19*>(this)->actor_wait_state > 0) static_cast<CallActor19*>(this)->actor_wait_state = 0;
		static_cast<CallActor19*>(this)->ActorCallback< CallActor19, 1, bool >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor19, 1, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor19*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CallActor19, 1, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor19*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CallActor19, 1, bool >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor19*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 541 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		Subspace logSubspace(Tuple().append(data->directoryData.directoryListIndex), prefix.getString(0));
															#line 543 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		Tuple pathTuple;
															#line 544 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		for( auto& p : directory->getPath() ) {
															#line 545 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			pathTuple.append(p, true);
															#line 8409 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		}
															#line 548 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		instruction->tr->set(logSubspace.pack("path"_sr, true), pathTuple.pack());
															#line 549 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		instruction->tr->set(logSubspace.pack("layer"_sr, true), Tuple().append(directory->getLayer()).pack());
															#line 550 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		instruction->tr->set(logSubspace.pack("exists"_sr, true), Tuple().append(exists ? 1 : 0).pack());
															#line 551 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		instruction->tr->set(logSubspace.pack("children"_sr, true), childrenTuple.pack());
															#line 553 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		if (!static_cast<CallActor19*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor19State(); static_cast<CallActor19*>(this)->destroy(); return 0; }
															#line 8421 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		new (&static_cast<CallActor19*>(this)->SAV< Void >::value()) Void(Void());
		this->~CallActor19State();
		static_cast<CallActor19*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4(Standalone<VectorRef<StringRef>> const& children,int loopDepth) 
	{
															#line 536 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		for( auto& c : children ) {
															#line 537 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			childrenTuple.append(c, true);
															#line 8435 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		}
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Standalone<VectorRef<StringRef>> && children,int loopDepth) 
	{
															#line 536 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		for( auto& c : children ) {
															#line 537 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			childrenTuple.append(c, true);
															#line 8447 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		}
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Standalone<VectorRef<StringRef>> const& children,int loopDepth) 
	{
		loopDepth = a_body1cont4(children, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Standalone<VectorRef<StringRef>> && children,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(children), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CallActor19*>(this)->actor_wait_state > 0) static_cast<CallActor19*>(this)->actor_wait_state = 0;
		static_cast<CallActor19*>(this)->ActorCallback< CallActor19, 2, Standalone<VectorRef<StringRef>> >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor19, 2, Standalone<VectorRef<StringRef>> >*,Standalone<VectorRef<StringRef>> const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor19*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CallActor19, 2, Standalone<VectorRef<StringRef>> >*,Standalone<VectorRef<StringRef>> && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor19*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CallActor19, 2, Standalone<VectorRef<StringRef>> >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor19*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 528 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	Reference<FlowTesterData> data;
															#line 528 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	Reference<InstructionData> instruction;
															#line 529 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	Reference<IDirectory> directory;
															#line 530 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	Tuple prefix;
															#line 531 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	bool exists;
															#line 533 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	Tuple childrenTuple;
															#line 8540 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
};
// This generated class is to be used only via call()
															#line 528 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
class CallActor19 final : public Actor<Void>, public ActorCallback< CallActor19, 0, Tuple >, public ActorCallback< CallActor19, 1, bool >, public ActorCallback< CallActor19, 2, Standalone<VectorRef<StringRef>> >, public FastAllocated<CallActor19>, public CallActor19State<CallActor19> {
															#line 8545 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
public:
	using FastAllocated<CallActor19>::operator new;
	using FastAllocated<CallActor19>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2925340698391154432UL, 7906335506767893504UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CallActor19, 0, Tuple >;
friend struct ActorCallback< CallActor19, 1, bool >;
friend struct ActorCallback< CallActor19, 2, Standalone<VectorRef<StringRef>> >;
															#line 528 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	CallActor19(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 8564 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		 : Actor<Void>(),
		   CallActor19State<CallActor19>(data, instruction),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7745861353199056384UL, 1084195677578843392UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor19*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("call");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CallActor19, 0, Tuple >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CallActor19, 1, bool >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CallActor19, 2, Standalone<VectorRef<StringRef>> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 528 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
[[nodiscard]] static Future<Void> call( Reference<FlowTesterData> const& data, Reference<InstructionData> const& instruction ) {
															#line 528 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	return Future<Void>(new CallActor19(data, instruction));
															#line 8598 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
}

#line 555 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
};
const char* DirectoryLogDirectoryFunc::name = "DIRECTORY_LOG_DIRECTORY";
REGISTER_INSTRUCTION_FUNC(DirectoryLogDirectoryFunc);

// DIRECTORY_STRIP_PREFIX
struct DirectoryStripPrefixFunc : InstructionFunc {
	static const char* name;

																#line 8610 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
// This generated class is to be used only via call()
															#line 563 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
template <class CallActor20>
															#line 563 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
class CallActor20State {
															#line 8616 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
public:
															#line 563 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	CallActor20State(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 563 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
															#line 563 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		 : data(data),
															#line 563 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		   instruction(instruction)
															#line 8625 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
	{
		fdb_probe_actor_create("call", reinterpret_cast<unsigned long>(this));

	}
	~CallActor20State() 
	{
		fdb_probe_actor_destroy("call", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 564 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			StrictFuture<Tuple> __when_expr_0 = data->stack.waitAndPop();
															#line 564 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			if (static_cast<CallActor20*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8642 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CallActor20*>(this)->actor_wait_state = 1;
															#line 564 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CallActor20, 0, Tuple >*>(static_cast<CallActor20*>(this)));
															#line 8647 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CallActor20State();
		static_cast<CallActor20*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Tuple const& str,int loopDepth) 
	{
															#line 565 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		Subspace* subspace = data->directoryData.subspace();
															#line 566 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		ASSERT(str.getString(0).startsWith(subspace->key()));
															#line 567 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		data->stack.pushTuple(str.getString(0).substr(subspace->key().size()));
															#line 568 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		if (!static_cast<CallActor20*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor20State(); static_cast<CallActor20*>(this)->destroy(); return 0; }
															#line 8676 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		new (&static_cast<CallActor20*>(this)->SAV< Void >::value()) Void(Void());
		this->~CallActor20State();
		static_cast<CallActor20*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Tuple && str,int loopDepth) 
	{
															#line 565 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		Subspace* subspace = data->directoryData.subspace();
															#line 566 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		ASSERT(str.getString(0).startsWith(subspace->key()));
															#line 567 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		data->stack.pushTuple(str.getString(0).substr(subspace->key().size()));
															#line 568 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
		if (!static_cast<CallActor20*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CallActor20State(); static_cast<CallActor20*>(this)->destroy(); return 0; }
															#line 8694 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		new (&static_cast<CallActor20*>(this)->SAV< Void >::value()) Void(Void());
		this->~CallActor20State();
		static_cast<CallActor20*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Tuple const& str,int loopDepth) 
	{
		loopDepth = a_body1cont1(str, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Tuple && str,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(str), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CallActor20*>(this)->actor_wait_state > 0) static_cast<CallActor20*>(this)->actor_wait_state = 0;
		static_cast<CallActor20*>(this)->ActorCallback< CallActor20, 0, Tuple >::remove();

	}
	void a_callback_fire(ActorCallback< CallActor20, 0, Tuple >*,Tuple const& value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor20*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CallActor20, 0, Tuple >*,Tuple && value) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor20*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CallActor20, 0, Tuple >*,Error err) 
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor20*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 563 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	Reference<FlowTesterData> data;
															#line 563 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	Reference<InstructionData> instruction;
															#line 8781 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
};
// This generated class is to be used only via call()
															#line 563 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
class CallActor20 final : public Actor<Void>, public ActorCallback< CallActor20, 0, Tuple >, public FastAllocated<CallActor20>, public CallActor20State<CallActor20> {
															#line 8786 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
public:
	using FastAllocated<CallActor20>::operator new;
	using FastAllocated<CallActor20>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2925340698391154432UL, 7906335506767893504UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CallActor20, 0, Tuple >;
															#line 563 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	CallActor20(Reference<FlowTesterData> const& data,Reference<InstructionData> const& instruction) 
															#line 8803 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
		 : Actor<Void>(),
		   CallActor20State<CallActor20>(data, instruction),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("call", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4151036423440242688UL, 3717798664353829376UL);
		ActorExecutionContextHelper __helper(static_cast<CallActor20*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("call");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("call", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CallActor20, 0, Tuple >*)0, actor_cancelled()); break;
		}

	}
};
															#line 563 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
[[nodiscard]] static Future<Void> call( Reference<FlowTesterData> const& data, Reference<InstructionData> const& instruction ) {
															#line 563 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
	return Future<Void>(new CallActor20(data, instruction));
															#line 8835 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/build_output/bindings/flow/tester/DirectoryTester.actor.g.cpp"
}

#line 570 "/codebuild/output/src4111079991/src/github.com/apple/foundationdb/bindings/flow/tester/DirectoryTester.actor.cpp"
};
const char* DirectoryStripPrefixFunc::name = "DIRECTORY_STRIP_PREFIX";
REGISTER_INSTRUCTION_FUNC(DirectoryStripPrefixFunc);
