#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
/*
 * MachineAttrition.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/FDBOptions.g.h"
#include "fdbclient/NativeAPI.actor.h"
#include "fdbclient/CoordinationInterface.h"
#include "fdbserver/TesterInterface.actor.h"
#include "fdbserver/WorkerInterface.actor.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "fdbrpc/simulator.h"
#include "fdbclient/ManagementAPI.actor.h"
#include "flow/FaultInjection.h"
#include "flow/DeterministicRandom.h"
#include "fdbrpc/SimulatorProcessInfo.h"
#include "flow/actorcompiler.h" // This must be the last #include.

static std::set<int> const& normalAttritionErrors() {
	static std::set<int> s;
	if (s.empty()) {
		s.insert(error_code_please_reboot);
		s.insert(error_code_please_reboot_delete);
	}
	return s;
}

															#line 45 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via ignoreSSFailuresForDuration()
															#line 43 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
template <class IgnoreSSFailuresForDurationActor>
															#line 43 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
class IgnoreSSFailuresForDurationActorState {
															#line 52 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
public:
															#line 43 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
	IgnoreSSFailuresForDurationActorState(Database const& cx,double const& duration) 
															#line 43 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
															#line 43 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
		 : cx(cx),
															#line 43 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
		   duration(duration)
															#line 61 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("ignoreSSFailuresForDuration", reinterpret_cast<unsigned long>(this));

	}
	~IgnoreSSFailuresForDurationActorState() 
	{
		fdb_probe_actor_destroy("ignoreSSFailuresForDuration", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 45 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
			TraceEvent("IgnoreSSFailureStart").log();
															#line 46 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
			StrictFuture<Void> __when_expr_0 = success(setHealthyZone(cx, ignoreSSFailuresZoneString, 0));
															#line 46 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
			if (static_cast<IgnoreSSFailuresForDurationActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 80 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<IgnoreSSFailuresForDurationActor*>(this)->actor_wait_state = 1;
															#line 46 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< IgnoreSSFailuresForDurationActor, 0, Void >*>(static_cast<IgnoreSSFailuresForDurationActor*>(this)));
															#line 85 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~IgnoreSSFailuresForDurationActorState();
		static_cast<IgnoreSSFailuresForDurationActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 47 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
		TraceEvent("IgnoreSSFailureWait").log();
															#line 48 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(duration);
															#line 48 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
		if (static_cast<IgnoreSSFailuresForDurationActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 112 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<IgnoreSSFailuresForDurationActor*>(this)->actor_wait_state = 2;
															#line 48 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< IgnoreSSFailuresForDurationActor, 1, Void >*>(static_cast<IgnoreSSFailuresForDurationActor*>(this)));
															#line 117 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 47 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
		TraceEvent("IgnoreSSFailureWait").log();
															#line 48 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(duration);
															#line 48 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
		if (static_cast<IgnoreSSFailuresForDurationActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 130 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<IgnoreSSFailuresForDurationActor*>(this)->actor_wait_state = 2;
															#line 48 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< IgnoreSSFailuresForDurationActor, 1, Void >*>(static_cast<IgnoreSSFailuresForDurationActor*>(this)));
															#line 135 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<IgnoreSSFailuresForDurationActor*>(this)->actor_wait_state > 0) static_cast<IgnoreSSFailuresForDurationActor*>(this)->actor_wait_state = 0;
		static_cast<IgnoreSSFailuresForDurationActor*>(this)->ActorCallback< IgnoreSSFailuresForDurationActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< IgnoreSSFailuresForDurationActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("ignoreSSFailuresForDuration", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IgnoreSSFailuresForDurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ignoreSSFailuresForDuration", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< IgnoreSSFailuresForDurationActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("ignoreSSFailuresForDuration", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IgnoreSSFailuresForDurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ignoreSSFailuresForDuration", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< IgnoreSSFailuresForDurationActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("ignoreSSFailuresForDuration", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<IgnoreSSFailuresForDurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ignoreSSFailuresForDuration", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 49 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
		TraceEvent("IgnoreSSFailureClear").log();
															#line 50 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
		tr = Transaction(cx);
															#line 51 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
		;
															#line 223 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 49 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
		TraceEvent("IgnoreSSFailureClear").log();
															#line 50 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
		tr = Transaction(cx);
															#line 51 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
		;
															#line 236 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<IgnoreSSFailuresForDurationActor*>(this)->actor_wait_state > 0) static_cast<IgnoreSSFailuresForDurationActor*>(this)->actor_wait_state = 0;
		static_cast<IgnoreSSFailuresForDurationActor*>(this)->ActorCallback< IgnoreSSFailuresForDurationActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< IgnoreSSFailuresForDurationActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("ignoreSSFailuresForDuration", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IgnoreSSFailuresForDurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ignoreSSFailuresForDuration", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< IgnoreSSFailuresForDurationActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("ignoreSSFailuresForDuration", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IgnoreSSFailuresForDurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ignoreSSFailuresForDuration", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< IgnoreSSFailuresForDurationActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("ignoreSSFailuresForDuration", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<IgnoreSSFailuresForDurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ignoreSSFailuresForDuration", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1(int loopDepth) 
	{
		try {
															#line 53 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 54 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 55 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
			tr.clear(healthyZoneKey);
															#line 56 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.commit();
															#line 56 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
			if (static_cast<IgnoreSSFailuresForDurationActor*>(this)->actor_wait_state < 0) return a_body1cont2loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 336 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont2loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2loopBody1when1(__when_expr_2.get(), loopDepth); };
			static_cast<IgnoreSSFailuresForDurationActor*>(this)->actor_wait_state = 3;
															#line 56 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< IgnoreSSFailuresForDurationActor, 2, Void >*>(static_cast<IgnoreSSFailuresForDurationActor*>(this)));
															#line 341 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont2loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 60 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr.onError(e);
															#line 60 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
			if (static_cast<IgnoreSSFailuresForDurationActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 365 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<IgnoreSSFailuresForDurationActor*>(this)->actor_wait_state = 4;
															#line 60 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< IgnoreSSFailuresForDurationActor, 3, Void >*>(static_cast<IgnoreSSFailuresForDurationActor*>(this)));
															#line 370 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 57 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
		TraceEvent("IgnoreSSFailureComplete").log();
															#line 58 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
		if (!static_cast<IgnoreSSFailuresForDurationActor*>(this)->SAV<bool>::futures) { (void)(true); this->~IgnoreSSFailuresForDurationActorState(); static_cast<IgnoreSSFailuresForDurationActor*>(this)->destroy(); return 0; }
															#line 387 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
		new (&static_cast<IgnoreSSFailuresForDurationActor*>(this)->SAV< bool >::value()) bool(true);
		this->~IgnoreSSFailuresForDurationActorState();
		static_cast<IgnoreSSFailuresForDurationActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 57 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
		TraceEvent("IgnoreSSFailureComplete").log();
															#line 58 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
		if (!static_cast<IgnoreSSFailuresForDurationActor*>(this)->SAV<bool>::futures) { (void)(true); this->~IgnoreSSFailuresForDurationActorState(); static_cast<IgnoreSSFailuresForDurationActor*>(this)->destroy(); return 0; }
															#line 401 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
		new (&static_cast<IgnoreSSFailuresForDurationActor*>(this)->SAV< bool >::value()) bool(true);
		this->~IgnoreSSFailuresForDurationActorState();
		static_cast<IgnoreSSFailuresForDurationActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<IgnoreSSFailuresForDurationActor*>(this)->actor_wait_state > 0) static_cast<IgnoreSSFailuresForDurationActor*>(this)->actor_wait_state = 0;
		static_cast<IgnoreSSFailuresForDurationActor*>(this)->ActorCallback< IgnoreSSFailuresForDurationActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< IgnoreSSFailuresForDurationActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("ignoreSSFailuresForDuration", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IgnoreSSFailuresForDurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ignoreSSFailuresForDuration", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< IgnoreSSFailuresForDurationActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("ignoreSSFailuresForDuration", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IgnoreSSFailuresForDurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ignoreSSFailuresForDuration", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< IgnoreSSFailuresForDurationActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("ignoreSSFailuresForDuration", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<IgnoreSSFailuresForDurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ignoreSSFailuresForDuration", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont2loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<IgnoreSSFailuresForDurationActor*>(this)->actor_wait_state > 0) static_cast<IgnoreSSFailuresForDurationActor*>(this)->actor_wait_state = 0;
		static_cast<IgnoreSSFailuresForDurationActor*>(this)->ActorCallback< IgnoreSSFailuresForDurationActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< IgnoreSSFailuresForDurationActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("ignoreSSFailuresForDuration", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IgnoreSSFailuresForDurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ignoreSSFailuresForDuration", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< IgnoreSSFailuresForDurationActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("ignoreSSFailuresForDuration", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IgnoreSSFailuresForDurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ignoreSSFailuresForDuration", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< IgnoreSSFailuresForDurationActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("ignoreSSFailuresForDuration", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<IgnoreSSFailuresForDurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ignoreSSFailuresForDuration", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 43 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
	Database cx;
															#line 43 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
	double duration;
															#line 50 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
	Transaction tr;
															#line 577 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
};
// This generated class is to be used only via ignoreSSFailuresForDuration()
															#line 43 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
class IgnoreSSFailuresForDurationActor final : public Actor<bool>, public ActorCallback< IgnoreSSFailuresForDurationActor, 0, Void >, public ActorCallback< IgnoreSSFailuresForDurationActor, 1, Void >, public ActorCallback< IgnoreSSFailuresForDurationActor, 2, Void >, public ActorCallback< IgnoreSSFailuresForDurationActor, 3, Void >, public FastAllocated<IgnoreSSFailuresForDurationActor>, public IgnoreSSFailuresForDurationActorState<IgnoreSSFailuresForDurationActor> {
															#line 582 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
public:
	using FastAllocated<IgnoreSSFailuresForDurationActor>::operator new;
	using FastAllocated<IgnoreSSFailuresForDurationActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13066474475005364480UL, 15970219922467801856UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< IgnoreSSFailuresForDurationActor, 0, Void >;
friend struct ActorCallback< IgnoreSSFailuresForDurationActor, 1, Void >;
friend struct ActorCallback< IgnoreSSFailuresForDurationActor, 2, Void >;
friend struct ActorCallback< IgnoreSSFailuresForDurationActor, 3, Void >;
															#line 43 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
	IgnoreSSFailuresForDurationActor(Database const& cx,double const& duration) 
															#line 602 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
		 : Actor<bool>(),
		   IgnoreSSFailuresForDurationActorState<IgnoreSSFailuresForDurationActor>(cx, duration),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("ignoreSSFailuresForDuration", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9872128848443265536UL, 13303471999045995264UL);
		ActorExecutionContextHelper __helper(static_cast<IgnoreSSFailuresForDurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("ignoreSSFailuresForDuration");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("ignoreSSFailuresForDuration", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< IgnoreSSFailuresForDurationActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< IgnoreSSFailuresForDurationActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< IgnoreSSFailuresForDurationActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< IgnoreSSFailuresForDurationActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 43 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
[[nodiscard]] Future<bool> ignoreSSFailuresForDuration( Database const& cx, double const& duration ) {
															#line 43 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
	return Future<bool>(new IgnoreSSFailuresForDurationActor(cx, duration));
															#line 638 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
}

#line 64 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"

struct MachineAttritionWorkload : FailureInjectionWorkload {
	static constexpr auto NAME = "Attrition";
	bool enabled;
	int machinesToKill = 2, machinesToLeave = 1, workersToKill = 2, workersToLeave = 1;
	double testDuration = 10.0, suspendDuration = 1.0, liveDuration = 5.0;
	bool iterate = false;
	bool reboot = false;
	bool killDc = false;
	bool killMachine = false;
	bool killDatahall = false;
	bool killProcess = false;
	bool killZone = false;
	bool killSelf = false;
	bool killAll = false;
	std::vector<std::string> targetIds;
	bool replacement = false;
	bool waitForVersion = false;
	bool allowFaultInjection = true;
	Future<bool> ignoreSSFailures = true;
	double maxRunDuration = 60.0, backoff = 1.5;

	// This is set in setup from the list of workers when the cluster is started
	std::vector<LocalityData> machines;

	MachineAttritionWorkload(WorkloadContext const& wcx, NoOptions) : FailureInjectionWorkload(wcx) {
		enabled = !clientId && g_network->isSimulated() && faultInjectionActivated;
		suspendDuration = 10.0;
		iterate = true;
	}

	MachineAttritionWorkload(WorkloadContext const& wcx) : FailureInjectionWorkload(wcx) {
		// only do this on the "first" client, and only when in simulation and only when fault injection is enabled
		enabled = !clientId && g_network->isSimulated() && faultInjectionActivated;
		machinesToKill = getOption(options, "machinesToKill"_sr, machinesToKill);
		machinesToLeave = getOption(options, "machinesToLeave"_sr, machinesToLeave);
		workersToKill = getOption(options, "workersToKill"_sr, workersToKill);
		workersToLeave = getOption(options, "workersToLeave"_sr, workersToLeave);
		testDuration = getOption(options, "testDuration"_sr, testDuration);
		suspendDuration = getOption(options, "suspendDuration"_sr, suspendDuration);
		liveDuration = getOption(options, "liveDuration"_sr, liveDuration);
		reboot = getOption(options, "reboot"_sr, reboot);
		killDc = getOption(options, "killDc"_sr, g_network->isSimulated() && deterministicRandom()->random01() < 0.25);
		killMachine = getOption(options, "killMachine"_sr, killMachine);
		killDatahall = getOption(options, "killDatahall"_sr, killDatahall);
		killProcess = getOption(options, "killProcess"_sr, killProcess);
		killZone = getOption(options, "killZone"_sr, killZone);
		killSelf = getOption(options, "killSelf"_sr, killSelf);
		killAll =
		    getOption(options,
		              "killAll"_sr,
		              g_network->isSimulated() && !g_simulator->extraDatabases.empty() && BUGGIFY_WITH_PROB(0.01));
		targetIds = getOption(options, "targetIds"_sr, std::vector<std::string>());
		replacement = getOption(options, "replacement"_sr, reboot && deterministicRandom()->random01() < 0.5);
		waitForVersion = getOption(options, "waitForVersion"_sr, waitForVersion);
		allowFaultInjection = getOption(options, "allowFaultInjection"_sr, allowFaultInjection);
	}

	bool shouldInject(DeterministicRandom& random,
	                  const WorkloadRequest& work,
	                  const unsigned alreadyAdded) const override {
		if (g_network->isSimulated() && !g_simulator->extraDatabases.empty()) {
			// Remove this as soon as we track extra databases properly
			return false;
		}
		return work.useDatabase && random.random01() < 1.0 / (2.0 + alreadyAdded);
	}

	void initializeForInjection(DeterministicRandom& random) {
		reboot = random.random01() < 0.25;
		replacement = random.random01() < 0.25;
		allowFaultInjection = random.random01() < 0.5;
		suspendDuration = 10.0 * random.random01();
		if (g_network->isSimulated()) {
			std::set<Optional<StringRef>> dataCenters;
			std::set<Optional<StringRef>> dataHalls;
			std::set<Optional<StringRef>> zones;
			for (auto process : g_simulator->getAllProcesses()) {
				dataCenters.emplace(process->locality.dcId().castTo<StringRef>());
				dataHalls.emplace(process->locality.dataHallId().castTo<StringRef>());
				zones.emplace(process->locality.zoneId().castTo<StringRef>());
			}
			killDc = dataCenters.size() > 0 && random.random01() > (dataHalls.size() < 0 ? 0.1 : 0.25);
			killDatahall = dataHalls.size() > 0 && killDc && random.random01() < 0.5;
			killZone = zones.size() > 0 && random.random01() < 0.2;
		}
		TraceEvent("AddingFailureInjection")
		    .detail("Reboot", reboot)
		    .detail("Replacement", replacement)
		    .detail("AllowFaultInjection", allowFaultInjection)
		    .detail("KillDC", killDc)
		    .detail("KillDataHall", killDatahall)
		    .detail("KillZone", killZone);
	}

	static std::vector<ISimulator::ProcessInfo*> getServers() {
		std::vector<ISimulator::ProcessInfo*> machines;
		std::vector<ISimulator::ProcessInfo*> all = g_simulator->getAllProcesses();
		for (int i = 0; i < all.size(); i++)
			if (!all[i]->failed && all[i]->name == std::string("Server") &&
			    all[i]->startingClass != ProcessClass::TesterClass)
				machines.push_back(all[i]);
		return machines;
	}

	Future<Void> setup(Database const& cx) override { return Void(); }
	Future<Void> start(Database const& cx) override {
		if (enabled) {
			std::map<Optional<Standalone<StringRef>>, LocalityData> machineIDMap;
			auto processes = getServers();
			for (auto it = processes.begin(); it != processes.end(); ++it) {
				machineIDMap[(*it)->locality.zoneId()] = (*it)->locality;
			}
			machines.clear();
			for (auto it = machineIDMap.begin(); it != machineIDMap.end(); ++it) {
				machines.push_back(it->second);
			}
			deterministicRandom()->randomShuffle(machines);
			double meanDelay = testDuration / machinesToKill;
			TraceEvent("AttritionStarting")
			    .detail("KillDataCenters", killDc)
			    .detail("Reboot", reboot)
			    .detail("MachinesToLeave", machinesToLeave)
			    .detail("MachinesToKill", machinesToKill)
			    .detail("MeanDelay", meanDelay);

			return timeout(
			    reportErrorsExcept(
			        machineKillWorker(this, meanDelay, cx), "machineKillWorkerError", UID(), &normalAttritionErrors()),
			    testDuration,
			    Void());
		}
		if (!clientId && !g_network->isSimulated()) {
			return timeout(
			    reportErrorsExcept(
			        noSimMachineKillWorker(this, cx), "noSimMachineKillWorkerError", UID(), &normalAttritionErrors()),
			    testDuration,
			    Void());
		}
		if (killSelf)
			throw please_reboot();
		return Void();
	}
	Future<bool> check(Database const& cx) override { return ignoreSSFailures; }
	void getMetrics(std::vector<PerfMetric>& m) override {}

	static bool noSimIsViableKill(WorkerDetails worker) {
		return (worker.processClass != ProcessClass::ClassType::TesterClass);
	}

	template <typename Proc>
	static void sendRebootRequests(std::vector<WorkerDetails> workers,
	                               std::vector<std::string> targets,
	                               RebootRequest rbReq,
	                               Proc idAccess) {
		for (const auto& worker : workers) {
			// kill all matching workers
			if (idAccess(worker).present() &&
			    std::find(targets.begin(), targets.end(), idAccess(worker).get().toString()) != targets.end()) {
				TraceEvent("SendingRebootRequest").detail("TargetWorker", worker.interf.locality.toString());
				worker.interf.clientInterface.reboot.send(rbReq);
			}
		}
	}

																#line 807 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
// This generated class is to be used only via noSimMachineKillWorker()
															#line 229 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
template <class NoSimMachineKillWorkerActor>
															#line 229 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
class NoSimMachineKillWorkerActorState {
															#line 813 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
public:
															#line 229 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
	NoSimMachineKillWorkerActorState(MachineAttritionWorkload* const& self,Database const& cx) 
															#line 229 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
															#line 229 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
		 : self(self),
															#line 229 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
		   cx(cx)
															#line 822 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("noSimMachineKillWorker", reinterpret_cast<unsigned long>(this));

	}
	~NoSimMachineKillWorkerActorState() 
	{
		fdb_probe_actor_destroy("noSimMachineKillWorker", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 230 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
			ASSERT(!g_network->isSimulated());
															#line 231 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
			killedWorkers = 0;
															#line 232 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
			StrictFuture<std::vector<WorkerDetails>> __when_expr_0 = self->dbInfo->get().clusterInterface.getWorkers.getReply(GetWorkersRequest());
															#line 232 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
			if (static_cast<NoSimMachineKillWorkerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 843 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<NoSimMachineKillWorkerActor*>(this)->actor_wait_state = 1;
															#line 232 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< NoSimMachineKillWorkerActor, 0, std::vector<WorkerDetails> >*>(static_cast<NoSimMachineKillWorkerActor*>(this)));
															#line 848 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~NoSimMachineKillWorkerActorState();
		static_cast<NoSimMachineKillWorkerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 235 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
		rbReq = RebootRequest();
															#line 236 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
		if (self->reboot)
															#line 873 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
		{
															#line 237 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
			rbReq.waitForDuration = self->suspendDuration;
															#line 877 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
		}
		else
		{
															#line 239 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
			rbReq.waitForDuration = std::numeric_limits<uint32_t>::max();
															#line 883 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
		}
															#line 241 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
		workers = std::vector<WorkerDetails>();
															#line 243 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
		for( const auto& worker : allWorkers ) {
															#line 244 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
			if (noSimIsViableKill(worker))
															#line 891 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
			{
															#line 245 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
				workers.push_back(worker);
															#line 895 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
			}
		}
															#line 248 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
		deterministicRandom()->randomShuffle(workers);
															#line 249 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(self->liveDuration);
															#line 249 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
		if (static_cast<NoSimMachineKillWorkerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 904 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<NoSimMachineKillWorkerActor*>(this)->actor_wait_state = 2;
															#line 249 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< NoSimMachineKillWorkerActor, 1, Void >*>(static_cast<NoSimMachineKillWorkerActor*>(this)));
															#line 909 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(std::vector<WorkerDetails> const& __allWorkers,int loopDepth) 
	{
															#line 232 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
		allWorkers = __allWorkers;
															#line 918 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<WorkerDetails> && __allWorkers,int loopDepth) 
	{
		allWorkers = std::move(__allWorkers);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<NoSimMachineKillWorkerActor*>(this)->actor_wait_state > 0) static_cast<NoSimMachineKillWorkerActor*>(this)->actor_wait_state = 0;
		static_cast<NoSimMachineKillWorkerActor*>(this)->ActorCallback< NoSimMachineKillWorkerActor, 0, std::vector<WorkerDetails> >::remove();

	}
	void a_callback_fire(ActorCallback< NoSimMachineKillWorkerActor, 0, std::vector<WorkerDetails> >*,std::vector<WorkerDetails> const& value) 
	{
		fdb_probe_actor_enter("noSimMachineKillWorker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NoSimMachineKillWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("noSimMachineKillWorker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< NoSimMachineKillWorkerActor, 0, std::vector<WorkerDetails> >*,std::vector<WorkerDetails> && value) 
	{
		fdb_probe_actor_enter("noSimMachineKillWorker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NoSimMachineKillWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("noSimMachineKillWorker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< NoSimMachineKillWorkerActor, 0, std::vector<WorkerDetails> >*,Error err) 
	{
		fdb_probe_actor_enter("noSimMachineKillWorker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<NoSimMachineKillWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("noSimMachineKillWorker", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 252 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
		if (self->killDc)
															#line 997 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
		{
															#line 253 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
			TraceEvent("Assassination").detail("TargetDataCenterIds", describe(self->targetIds));
															#line 254 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
			sendRebootRequests(workers, self->targetIds, rbReq, [](WorkerDetails worker) { return worker.interf.locality.dcId(); });
															#line 1003 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
			loopDepth = a_body1cont7(loopDepth);
		}
		else
		{
															#line 259 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
			if (self->killMachine)
															#line 1010 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
			{
															#line 260 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
				TraceEvent("Assassination").detail("TargetMachineIds", describe(self->targetIds));
															#line 261 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
				sendRebootRequests(workers, self->targetIds, rbReq, [](WorkerDetails worker) { return worker.interf.locality.machineId(); });
															#line 1016 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
				loopDepth = a_body1cont9(loopDepth);
			}
			else
			{
															#line 266 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
				if (self->killDatahall)
															#line 1023 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
				{
															#line 267 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
					TraceEvent("Assassination").detail("TargetDatahallIds", describe(self->targetIds));
															#line 268 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
					sendRebootRequests(workers, self->targetIds, rbReq, [](WorkerDetails worker) { return worker.interf.locality.dataHallId(); });
															#line 1029 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
					loopDepth = a_body1cont11(loopDepth);
				}
				else
				{
															#line 273 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
					if (self->killProcess)
															#line 1036 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
					{
															#line 274 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
						TraceEvent("Assassination").detail("TargetProcessIds", describe(self->targetIds));
															#line 275 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
						sendRebootRequests(workers, self->targetIds, rbReq, [](WorkerDetails worker) { return worker.interf.locality.processId(); });
															#line 1042 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
						loopDepth = a_body1cont13(loopDepth);
					}
					else
					{
															#line 280 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
						if (self->killZone)
															#line 1049 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
						{
															#line 281 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
							TraceEvent("Assassination").detail("TargetZoneIds", describe(self->targetIds));
															#line 282 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
							sendRebootRequests(workers, self->targetIds, rbReq, [](WorkerDetails worker) { return worker.interf.locality.zoneId(); });
															#line 1055 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
							loopDepth = a_body1cont15(loopDepth);
						}
						else
						{
															#line 288 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
							;
															#line 1062 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
							loopDepth = a_body1cont2loopHead1(loopDepth);
						}
					}
				}
			}
		}

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 252 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
		if (self->killDc)
															#line 1076 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
		{
															#line 253 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
			TraceEvent("Assassination").detail("TargetDataCenterIds", describe(self->targetIds));
															#line 254 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
			sendRebootRequests(workers, self->targetIds, rbReq, [](WorkerDetails worker) { return worker.interf.locality.dcId(); });
															#line 1082 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
			loopDepth = a_body1cont7(loopDepth);
		}
		else
		{
															#line 259 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
			if (self->killMachine)
															#line 1089 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
			{
															#line 260 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
				TraceEvent("Assassination").detail("TargetMachineIds", describe(self->targetIds));
															#line 261 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
				sendRebootRequests(workers, self->targetIds, rbReq, [](WorkerDetails worker) { return worker.interf.locality.machineId(); });
															#line 1095 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
				loopDepth = a_body1cont9(loopDepth);
			}
			else
			{
															#line 266 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
				if (self->killDatahall)
															#line 1102 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
				{
															#line 267 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
					TraceEvent("Assassination").detail("TargetDatahallIds", describe(self->targetIds));
															#line 268 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
					sendRebootRequests(workers, self->targetIds, rbReq, [](WorkerDetails worker) { return worker.interf.locality.dataHallId(); });
															#line 1108 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
					loopDepth = a_body1cont11(loopDepth);
				}
				else
				{
															#line 273 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
					if (self->killProcess)
															#line 1115 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
					{
															#line 274 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
						TraceEvent("Assassination").detail("TargetProcessIds", describe(self->targetIds));
															#line 275 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
						sendRebootRequests(workers, self->targetIds, rbReq, [](WorkerDetails worker) { return worker.interf.locality.processId(); });
															#line 1121 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
						loopDepth = a_body1cont13(loopDepth);
					}
					else
					{
															#line 280 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
						if (self->killZone)
															#line 1128 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
						{
															#line 281 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
							TraceEvent("Assassination").detail("TargetZoneIds", describe(self->targetIds));
															#line 282 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
							sendRebootRequests(workers, self->targetIds, rbReq, [](WorkerDetails worker) { return worker.interf.locality.zoneId(); });
															#line 1134 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
							loopDepth = a_body1cont15(loopDepth);
						}
						else
						{
															#line 288 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
							;
															#line 1141 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
							loopDepth = a_body1cont2loopHead1(loopDepth);
						}
					}
				}
			}
		}

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<NoSimMachineKillWorkerActor*>(this)->actor_wait_state > 0) static_cast<NoSimMachineKillWorkerActor*>(this)->actor_wait_state = 0;
		static_cast<NoSimMachineKillWorkerActor*>(this)->ActorCallback< NoSimMachineKillWorkerActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< NoSimMachineKillWorkerActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("noSimMachineKillWorker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NoSimMachineKillWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("noSimMachineKillWorker", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< NoSimMachineKillWorkerActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("noSimMachineKillWorker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NoSimMachineKillWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("noSimMachineKillWorker", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< NoSimMachineKillWorkerActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("noSimMachineKillWorker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<NoSimMachineKillWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("noSimMachineKillWorker", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont7(int loopDepth) 
	{
															#line 322 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
		if (!static_cast<NoSimMachineKillWorkerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~NoSimMachineKillWorkerActorState(); static_cast<NoSimMachineKillWorkerActor*>(this)->destroy(); return 0; }
															#line 1230 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
		new (&static_cast<NoSimMachineKillWorkerActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~NoSimMachineKillWorkerActorState();
		static_cast<NoSimMachineKillWorkerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont9(int loopDepth) 
	{
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont11(int loopDepth) 
	{
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont13(int loopDepth) 
	{
		loopDepth = a_body1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1cont15(int loopDepth) 
	{
		loopDepth = a_body1cont13(loopDepth);

		return loopDepth;
	}
	int a_body1cont17(int loopDepth) 
	{
		loopDepth = a_body1cont15(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1(int loopDepth) 
	{
															#line 288 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
		if (!(killedWorkers < self->workersToKill && workers.size() > self->workersToLeave))
															#line 1279 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
		{
			return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 289 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
		TraceEvent("WorkerKillBegin") .detail("KilledWorkers", killedWorkers) .detail("WorkersToKill", self->workersToKill) .detail("WorkersToLeave", self->workersToLeave) .detail("Workers", workers.size());
															#line 294 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
		if (self->waitForVersion)
															#line 1287 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
		{
															#line 295 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
			tr = Transaction(cx);
															#line 296 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
			;
															#line 1293 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
			loopDepth = a_body1cont2loopBody1loopHead1(loopDepth);
		}
		else
		{
			loopDepth = a_body1cont2loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2break1(int loopDepth) 
	{
		try {
			return a_body1cont17(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(int loopDepth) 
	{
															#line 308 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
		targetWorker = WorkerDetails();
															#line 309 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
		targetWorker = workers.back();
															#line 310 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
		TraceEvent("Assassination") .detail("TargetWorker", targetWorker.interf.locality.toString()) .detail("ZoneId", targetWorker.interf.locality.zoneId()) .detail("KilledWorkers", killedWorkers) .detail("WorkersToKill", self->workersToKill) .detail("WorkersToLeave", self->workersToLeave) .detail("Workers", workers.size());
															#line 317 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
		targetWorker.interf.clientInterface.reboot.send(rbReq);
															#line 318 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
		killedWorkers++;
															#line 319 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
		workers.pop_back();
															#line 1330 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont3(int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1loopBody1(int loopDepth) 
	{
		try {
															#line 298 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 299 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 300 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
			StrictFuture<Void> __when_expr_2 = success(tr.getReadVersion());
															#line 300 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
			if (static_cast<NoSimMachineKillWorkerActor*>(this)->actor_wait_state < 0) return a_body1cont2loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1359 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont2loopBody1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2loopBody1loopBody1when1(__when_expr_2.get(), loopDepth); };
			static_cast<NoSimMachineKillWorkerActor*>(this)->actor_wait_state = 3;
															#line 300 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< NoSimMachineKillWorkerActor, 2, Void >*>(static_cast<NoSimMachineKillWorkerActor*>(this)));
															#line 1364 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont2loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1cont2loopBody1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont2loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 303 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr.onError(e);
															#line 303 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
			if (static_cast<NoSimMachineKillWorkerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 1401 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 2)); else return a_body1cont2loopBody1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<NoSimMachineKillWorkerActor*>(this)->actor_wait_state = 4;
															#line 303 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< NoSimMachineKillWorkerActor, 3, Void >*>(static_cast<NoSimMachineKillWorkerActor*>(this)));
															#line 1406 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1loopBody1cont2(Void const& _,int loopDepth) 
	{
		return a_body1cont2loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont2loopBody1loopBody1cont2(Void && _,int loopDepth) 
	{
		return a_body1cont2loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont2loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<NoSimMachineKillWorkerActor*>(this)->actor_wait_state > 0) static_cast<NoSimMachineKillWorkerActor*>(this)->actor_wait_state = 0;
		static_cast<NoSimMachineKillWorkerActor*>(this)->ActorCallback< NoSimMachineKillWorkerActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< NoSimMachineKillWorkerActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("noSimMachineKillWorker", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NoSimMachineKillWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("noSimMachineKillWorker", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< NoSimMachineKillWorkerActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("noSimMachineKillWorker", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NoSimMachineKillWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("noSimMachineKillWorker", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< NoSimMachineKillWorkerActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("noSimMachineKillWorker", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<NoSimMachineKillWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("noSimMachineKillWorker", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont2loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<NoSimMachineKillWorkerActor*>(this)->actor_wait_state > 0) static_cast<NoSimMachineKillWorkerActor*>(this)->actor_wait_state = 0;
		static_cast<NoSimMachineKillWorkerActor*>(this)->ActorCallback< NoSimMachineKillWorkerActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< NoSimMachineKillWorkerActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("noSimMachineKillWorker", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NoSimMachineKillWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("noSimMachineKillWorker", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< NoSimMachineKillWorkerActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("noSimMachineKillWorker", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NoSimMachineKillWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("noSimMachineKillWorker", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< NoSimMachineKillWorkerActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("noSimMachineKillWorker", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<NoSimMachineKillWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("noSimMachineKillWorker", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 229 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
	MachineAttritionWorkload* self;
															#line 229 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
	Database cx;
															#line 231 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
	int killedWorkers;
															#line 232 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
	std::vector<WorkerDetails> allWorkers;
															#line 235 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
	RebootRequest rbReq;
															#line 241 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
	std::vector<WorkerDetails> workers;
															#line 295 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
	Transaction tr;
															#line 308 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
	WorkerDetails targetWorker;
															#line 1607 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
};
// This generated class is to be used only via noSimMachineKillWorker()
															#line 229 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
class NoSimMachineKillWorkerActor final : public Actor<Void>, public ActorCallback< NoSimMachineKillWorkerActor, 0, std::vector<WorkerDetails> >, public ActorCallback< NoSimMachineKillWorkerActor, 1, Void >, public ActorCallback< NoSimMachineKillWorkerActor, 2, Void >, public ActorCallback< NoSimMachineKillWorkerActor, 3, Void >, public FastAllocated<NoSimMachineKillWorkerActor>, public NoSimMachineKillWorkerActorState<NoSimMachineKillWorkerActor> {
															#line 1612 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
public:
	using FastAllocated<NoSimMachineKillWorkerActor>::operator new;
	using FastAllocated<NoSimMachineKillWorkerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3141253031169491968UL, 12109918513092818176UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< NoSimMachineKillWorkerActor, 0, std::vector<WorkerDetails> >;
friend struct ActorCallback< NoSimMachineKillWorkerActor, 1, Void >;
friend struct ActorCallback< NoSimMachineKillWorkerActor, 2, Void >;
friend struct ActorCallback< NoSimMachineKillWorkerActor, 3, Void >;
															#line 229 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
	NoSimMachineKillWorkerActor(MachineAttritionWorkload* const& self,Database const& cx) 
															#line 1632 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   NoSimMachineKillWorkerActorState<NoSimMachineKillWorkerActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("noSimMachineKillWorker", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6269304509595024640UL, 7239239269586344448UL);
		ActorExecutionContextHelper __helper(static_cast<NoSimMachineKillWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("noSimMachineKillWorker");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("noSimMachineKillWorker", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< NoSimMachineKillWorkerActor, 0, std::vector<WorkerDetails> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< NoSimMachineKillWorkerActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< NoSimMachineKillWorkerActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< NoSimMachineKillWorkerActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 229 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
[[nodiscard]] static Future<Void> noSimMachineKillWorker( MachineAttritionWorkload* const& self, Database const& cx ) {
															#line 229 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
	return Future<Void>(new NoSimMachineKillWorkerActor(self, cx));
															#line 1667 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
}

#line 324 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"

																#line 1672 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
// This generated class is to be used only via machineKillWorker()
															#line 325 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
template <class MachineKillWorkerActor>
															#line 325 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
class MachineKillWorkerActorState {
															#line 1678 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
public:
															#line 325 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
	MachineKillWorkerActorState(MachineAttritionWorkload* const& self,double const& meanDelay,Database const& cx) 
															#line 325 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
															#line 325 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
		 : self(self),
															#line 325 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
		   meanDelay(meanDelay),
															#line 325 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
		   cx(cx)
															#line 1689 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("machineKillWorker", reinterpret_cast<unsigned long>(this));

	}
	~MachineKillWorkerActorState() 
	{
		fdb_probe_actor_destroy("machineKillWorker", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 326 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
			ASSERT(g_network->isSimulated());
															#line 327 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
			delayBeforeKill = double();
															#line 328 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
			suspendDuration = self->suspendDuration;
															#line 329 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
			startTime = now();
															#line 331 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
			;
															#line 1712 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MachineKillWorkerActorState();
		static_cast<MachineKillWorkerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 485 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
		if (self->killSelf)
															#line 1735 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
		{
															#line 486 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
			return a_body1Catch1(please_reboot(), loopDepth);
															#line 1739 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
		}
															#line 487 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
		if (!static_cast<MachineKillWorkerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~MachineKillWorkerActorState(); static_cast<MachineKillWorkerActor*>(this)->destroy(); return 0; }
															#line 1743 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
		new (&static_cast<MachineKillWorkerActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~MachineKillWorkerActorState();
		static_cast<MachineKillWorkerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 332 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
		if (self->killDc)
															#line 1762 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
		{
															#line 333 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
			delayBeforeKill = deterministicRandom()->random01() * meanDelay;
															#line 334 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(delayBeforeKill);
															#line 334 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
			if (static_cast<MachineKillWorkerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1770 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<MachineKillWorkerActor*>(this)->actor_wait_state = 1;
															#line 334 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MachineKillWorkerActor, 0, Void >*>(static_cast<MachineKillWorkerActor*>(this)));
															#line 1775 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
															#line 358 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
			if (self->killDatahall)
															#line 1782 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
			{
															#line 359 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
				delayBeforeKill = deterministicRandom()->random01() * meanDelay;
															#line 360 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
				StrictFuture<Void> __when_expr_1 = delay(delayBeforeKill);
															#line 360 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
				if (static_cast<MachineKillWorkerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1790 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
				static_cast<MachineKillWorkerActor*>(this)->actor_wait_state = 2;
															#line 360 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MachineKillWorkerActor, 1, Void >*>(static_cast<MachineKillWorkerActor*>(this)));
															#line 1795 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
															#line 370 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
				if (self->killAll)
															#line 1802 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
				{
															#line 371 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
					kt = ISimulator::KillType::RebootProcessAndSwitch;
															#line 372 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
					TraceEvent("Assassination").detail("KillType", kt);
															#line 373 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
					g_simulator->killAll(kt, true);
															#line 374 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
					g_simulator->toggleGlobalSwitchCluster();
															#line 375 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
					StrictFuture<Void> __when_expr_2 = delay(self->testDuration / 2);
															#line 375 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
					if (static_cast<MachineKillWorkerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1816 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
					if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when3(__when_expr_2.get(), loopDepth); };
					static_cast<MachineKillWorkerActor*>(this)->actor_wait_state = 3;
															#line 375 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
					__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MachineKillWorkerActor, 2, Void >*>(static_cast<MachineKillWorkerActor*>(this)));
															#line 1821 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
					loopDepth = 0;
				}
				else
				{
															#line 379 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
					killedMachines = 0;
															#line 380 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
					;
															#line 1830 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
					loopDepth = a_body1loopBody1loopHead1(loopDepth);
				}
			}
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 477 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
		if (!self->iterate || now() - startTime > self->maxRunDuration)
															#line 1855 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		else
		{
															#line 480 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
			StrictFuture<Void> __when_expr_8 = delay(suspendDuration);
															#line 480 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
			if (static_cast<MachineKillWorkerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1865 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
			if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_8.get(), loopDepth); };
			static_cast<MachineKillWorkerActor*>(this)->actor_wait_state = 9;
															#line 480 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
			__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< MachineKillWorkerActor, 8, Void >*>(static_cast<MachineKillWorkerActor*>(this)));
															#line 1870 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 337 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
		ASSERT(self->machines.size());
															#line 338 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
		Optional<Standalone<StringRef>> target = self->machines.back().dcId();
															#line 340 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
		ISimulator::KillType kt = ISimulator::KillType::Reboot;
															#line 341 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
		if (!self->reboot)
															#line 1886 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
		{
															#line 342 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
			int killType = deterministicRandom()->randomInt(0, 3);
															#line 343 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
			if (killType == 0)
															#line 1892 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
			{
															#line 344 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
				kt = ISimulator::KillType::KillInstantly;
															#line 1896 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
			}
			else
			{
															#line 345 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
				if (killType == 1)
															#line 1902 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
				{
															#line 346 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
					kt = ISimulator::KillType::InjectFaults;
															#line 1906 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
				}
				else
				{
															#line 347 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
					if (killType == 2)
															#line 1912 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
					{
															#line 348 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
						kt = ISimulator::KillType::RebootAndDelete;
															#line 1916 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
					}
					else
					{
															#line 350 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
						kt = ISimulator::KillType::FailDisk;
															#line 1922 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
					}
				}
			}
		}
															#line 352 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
		TraceEvent("Assassination") .detail("TargetDatacenter", target) .detail("Reboot", self->reboot) .detail("KillType", kt);
															#line 357 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
		g_simulator->killDataCenter(target, kt);
															#line 1931 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 337 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
		ASSERT(self->machines.size());
															#line 338 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
		Optional<Standalone<StringRef>> target = self->machines.back().dcId();
															#line 340 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
		ISimulator::KillType kt = ISimulator::KillType::Reboot;
															#line 341 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
		if (!self->reboot)
															#line 1946 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
		{
															#line 342 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
			int killType = deterministicRandom()->randomInt(0, 3);
															#line 343 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
			if (killType == 0)
															#line 1952 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
			{
															#line 344 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
				kt = ISimulator::KillType::KillInstantly;
															#line 1956 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
			}
			else
			{
															#line 345 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
				if (killType == 1)
															#line 1962 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
				{
															#line 346 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
					kt = ISimulator::KillType::InjectFaults;
															#line 1966 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
				}
				else
				{
															#line 347 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
					if (killType == 2)
															#line 1972 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
					{
															#line 348 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
						kt = ISimulator::KillType::RebootAndDelete;
															#line 1976 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
					}
					else
					{
															#line 350 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
						kt = ISimulator::KillType::FailDisk;
															#line 1982 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
					}
				}
			}
		}
															#line 352 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
		TraceEvent("Assassination") .detail("TargetDatacenter", target) .detail("Reboot", self->reboot) .detail("KillType", kt);
															#line 357 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
		g_simulator->killDataCenter(target, kt);
															#line 1991 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MachineKillWorkerActor*>(this)->actor_wait_state > 0) static_cast<MachineKillWorkerActor*>(this)->actor_wait_state = 0;
		static_cast<MachineKillWorkerActor*>(this)->ActorCallback< MachineKillWorkerActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MachineKillWorkerActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("machineKillWorker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MachineKillWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("machineKillWorker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MachineKillWorkerActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("machineKillWorker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MachineKillWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("machineKillWorker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MachineKillWorkerActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("machineKillWorker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MachineKillWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("machineKillWorker", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont11(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont12(Void const& _,int loopDepth) 
	{
															#line 363 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
		ASSERT(self->targetIds.size() == 1);
															#line 364 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
		auto target = self->targetIds.front();
															#line 366 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
		auto kt = ISimulator::KillType::KillInstantly;
															#line 367 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
		TraceEvent("Assassination").detail("TargetDataHall", target).detail("KillType", kt);
															#line 369 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
		g_simulator->killDataHall(target, kt);
															#line 2089 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont12(Void && _,int loopDepth) 
	{
															#line 363 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
		ASSERT(self->targetIds.size() == 1);
															#line 364 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
		auto target = self->targetIds.front();
															#line 366 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
		auto kt = ISimulator::KillType::KillInstantly;
															#line 367 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
		TraceEvent("Assassination").detail("TargetDataHall", target).detail("KillType", kt);
															#line 369 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
		g_simulator->killDataHall(target, kt);
															#line 2106 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont12(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont12(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<MachineKillWorkerActor*>(this)->actor_wait_state > 0) static_cast<MachineKillWorkerActor*>(this)->actor_wait_state = 0;
		static_cast<MachineKillWorkerActor*>(this)->ActorCallback< MachineKillWorkerActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MachineKillWorkerActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("machineKillWorker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MachineKillWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("machineKillWorker", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MachineKillWorkerActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("machineKillWorker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MachineKillWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("machineKillWorker", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< MachineKillWorkerActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("machineKillWorker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MachineKillWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("machineKillWorker", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont13(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont14(Void const& _,int loopDepth) 
	{
															#line 376 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
		g_simulator->killAll(kt, true);
															#line 377 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
		g_simulator->toggleGlobalSwitchCluster();
															#line 2198 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont13(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont14(Void && _,int loopDepth) 
	{
															#line 376 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
		g_simulator->killAll(kt, true);
															#line 377 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
		g_simulator->toggleGlobalSwitchCluster();
															#line 2209 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont13(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont14(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont14(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<MachineKillWorkerActor*>(this)->actor_wait_state > 0) static_cast<MachineKillWorkerActor*>(this)->actor_wait_state = 0;
		static_cast<MachineKillWorkerActor*>(this)->ActorCallback< MachineKillWorkerActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MachineKillWorkerActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("machineKillWorker", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MachineKillWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("machineKillWorker", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< MachineKillWorkerActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("machineKillWorker", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MachineKillWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("machineKillWorker", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< MachineKillWorkerActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("machineKillWorker", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MachineKillWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("machineKillWorker", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont15(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont13(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
															#line 380 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
		if (!(killedMachines < self->machinesToKill && self->machines.size() > self->machinesToLeave))
															#line 2306 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
		{
			return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 381 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
		TraceEvent("WorkerKillBegin") .detail("KilledMachines", killedMachines) .detail("MachinesToKill", self->machinesToKill) .detail("MachinesToLeave", self->machinesToLeave) .detail("Machines", self->machines.size());
															#line 386 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
		CODE_PROBE(true, "Killing a machine");
															#line 388 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
		delayBeforeKill = deterministicRandom()->random01() * meanDelay;
															#line 389 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
		StrictFuture<Void> __when_expr_3 = delay(delayBeforeKill);
															#line 389 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
		if (static_cast<MachineKillWorkerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 2320 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1when1(__when_expr_3.get(), loopDepth); };
		static_cast<MachineKillWorkerActor*>(this)->actor_wait_state = 4;
															#line 389 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< MachineKillWorkerActor, 3, Void >*>(static_cast<MachineKillWorkerActor*>(this)));
															#line 2325 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont15(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 390 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
		TraceEvent("WorkerKillAfterDelay").log();
															#line 392 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
		if (self->waitForVersion)
															#line 2349 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
		{
															#line 393 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
			tr = Transaction(cx);
															#line 394 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
			;
															#line 2355 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
			loopDepth = a_body1loopBody1loopBody1cont1loopHead1(loopDepth);
		}
		else
		{
			loopDepth = a_body1loopBody1loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 390 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
		TraceEvent("WorkerKillAfterDelay").log();
															#line 392 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
		if (self->waitForVersion)
															#line 2371 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
		{
															#line 393 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
			tr = Transaction(cx);
															#line 394 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
			;
															#line 2377 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
			loopDepth = a_body1loopBody1loopBody1cont1loopHead1(loopDepth);
		}
		else
		{
			loopDepth = a_body1loopBody1loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<MachineKillWorkerActor*>(this)->actor_wait_state > 0) static_cast<MachineKillWorkerActor*>(this)->actor_wait_state = 0;
		static_cast<MachineKillWorkerActor*>(this)->ActorCallback< MachineKillWorkerActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MachineKillWorkerActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("machineKillWorker", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MachineKillWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("machineKillWorker", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< MachineKillWorkerActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("machineKillWorker", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MachineKillWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("machineKillWorker", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< MachineKillWorkerActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("machineKillWorker", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MachineKillWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("machineKillWorker", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1loopBody1cont3(int loopDepth) 
	{
															#line 407 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
		targetMachine = self->machines.back();
															#line 408 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
		if (BUGGIFY_WITH_PROB(0.01))
															#line 2468 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
		{
															#line 409 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
			CODE_PROBE(true, "Marked a zone for maintenance before killing it");
															#line 410 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
			StrictFuture<Void> __when_expr_6 = success( setHealthyZone(cx, targetMachine.zoneId().get(), deterministicRandom()->random01() * 20));
															#line 410 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
			if (static_cast<MachineKillWorkerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 2476 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
			if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1cont3when1(__when_expr_6.get(), loopDepth); };
			static_cast<MachineKillWorkerActor*>(this)->actor_wait_state = 7;
															#line 410 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
			__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< MachineKillWorkerActor, 6, Void >*>(static_cast<MachineKillWorkerActor*>(this)));
															#line 2481 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
															#line 412 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
			if (!g_simulator->willRestart && BUGGIFY_WITH_PROB(0.005))
															#line 2488 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
			{
															#line 415 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
				CODE_PROBE(true, "Disable DD for all storage server failures");
															#line 416 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
				self->ignoreSSFailures = uncancellable(ignoreSSFailuresForDuration(cx, deterministicRandom()->random01() * 5));
															#line 2494 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
			}
			loopDepth = a_body1loopBody1loopBody1cont5(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont4(int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1loopBody1(int loopDepth) 
	{
		try {
															#line 396 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 397 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 398 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
			StrictFuture<Void> __when_expr_4 = success(tr.getReadVersion());
															#line 398 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
			if (static_cast<MachineKillWorkerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2525 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1loopBody1loopBody1cont1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1loopBody1loopBody1cont1loopBody1when1(__when_expr_4.get(), loopDepth); };
			static_cast<MachineKillWorkerActor*>(this)->actor_wait_state = 5;
															#line 398 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< MachineKillWorkerActor, 4, Void >*>(static_cast<MachineKillWorkerActor*>(this)));
															#line 2530 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1loopBody1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1loopBody1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1loopBody1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopBody1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 401 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
			StrictFuture<Void> __when_expr_5 = tr.onError(e);
															#line 401 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
			if (static_cast<MachineKillWorkerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 3));
															#line 2567 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 3)); else return a_body1loopBody1loopBody1cont1loopBody1Catch1when1(__when_expr_5.get(), loopDepth); };
			static_cast<MachineKillWorkerActor*>(this)->actor_wait_state = 6;
															#line 401 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< MachineKillWorkerActor, 5, Void >*>(static_cast<MachineKillWorkerActor*>(this)));
															#line 2572 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 3));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 3));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1loopBody1cont2(Void const& _,int loopDepth) 
	{
		return a_body1loopBody1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1loopBody1cont2(Void && _,int loopDepth) 
	{
		return a_body1loopBody1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<MachineKillWorkerActor*>(this)->actor_wait_state > 0) static_cast<MachineKillWorkerActor*>(this)->actor_wait_state = 0;
		static_cast<MachineKillWorkerActor*>(this)->ActorCallback< MachineKillWorkerActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MachineKillWorkerActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("machineKillWorker", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MachineKillWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1loopBody1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("machineKillWorker", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< MachineKillWorkerActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("machineKillWorker", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MachineKillWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1loopBody1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("machineKillWorker", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< MachineKillWorkerActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("machineKillWorker", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MachineKillWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1loopBody1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("machineKillWorker", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1loopBody1loopBody1cont1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<MachineKillWorkerActor*>(this)->actor_wait_state > 0) static_cast<MachineKillWorkerActor*>(this)->actor_wait_state = 0;
		static_cast<MachineKillWorkerActor*>(this)->ActorCallback< MachineKillWorkerActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MachineKillWorkerActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("machineKillWorker", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MachineKillWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1loopBody1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("machineKillWorker", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< MachineKillWorkerActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("machineKillWorker", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MachineKillWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1loopBody1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("machineKillWorker", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< MachineKillWorkerActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("machineKillWorker", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MachineKillWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("machineKillWorker", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1loopBody1loopBody1cont5(int loopDepth) 
	{
															#line 420 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
		TraceEvent("Assassination") .detail("TargetMachine", targetMachine.toString()) .detail("ZoneId", targetMachine.zoneId()) .detail("Reboot", self->reboot) .detail("KilledMachines", killedMachines) .detail("MachinesToKill", self->machinesToKill) .detail("MachinesToLeave", self->machinesToLeave) .detail("Machines", self->machines.size()) .detail("Replace", self->replacement);
															#line 430 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
		if (self->reboot)
															#line 2763 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
		{
															#line 431 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
			if (deterministicRandom()->random01() > 0.5)
															#line 2767 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
			{
															#line 432 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
				g_simulator->rebootProcess(targetMachine.zoneId(), deterministicRandom()->random01() > 0.5);
															#line 2771 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
			}
			else
			{
															#line 434 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
				g_simulator->killZone(targetMachine.zoneId(), ISimulator::KillType::Reboot);
															#line 2777 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
			}
		}
		else
		{
															#line 437 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
			auto randomDouble = deterministicRandom()->random01();
															#line 438 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
			TraceEvent("WorkerKill") .detail("MachineCount", self->machines.size()) .detail("RandomValue", randomDouble);
															#line 441 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
			if (randomDouble < 0.33)
															#line 2788 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
			{
															#line 442 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
				TraceEvent("RebootAndDelete").detail("TargetMachine", targetMachine.toString());
															#line 443 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
				g_simulator->killZone(targetMachine.zoneId(), ISimulator::KillType::RebootAndDelete);
															#line 2794 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
			}
			else
			{
															#line 445 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
				auto kt = ISimulator::KillType::KillInstantly;
															#line 446 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
				if (self->allowFaultInjection)
															#line 2802 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
				{
															#line 447 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
					if (randomDouble < 0.50)
															#line 2806 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
					{
															#line 448 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
						kt = ISimulator::KillType::InjectFaults;
															#line 2810 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
					}
				}
															#line 459 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
				g_simulator->killZone(targetMachine.zoneId(), kt);
															#line 2815 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
			}
		}
															#line 463 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
		killedMachines++;
															#line 464 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
		if (self->replacement)
															#line 2822 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
		{
															#line 466 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
			deterministicRandom()->randomShuffle(self->machines);
															#line 2826 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
		}
		else
		{
															#line 468 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
			self->machines.pop_back();
															#line 2832 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
		}
															#line 471 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
		StrictFuture<Void> __when_expr_7 = delay(meanDelay - delayBeforeKill) && success(self->ignoreSSFailures);
															#line 471 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
		if (static_cast<MachineKillWorkerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 2838 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1cont5when1(__when_expr_7.get(), loopDepth); };
		static_cast<MachineKillWorkerActor*>(this)->actor_wait_state = 8;
															#line 471 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< MachineKillWorkerActor, 7, Void >*>(static_cast<MachineKillWorkerActor*>(this)));
															#line 2843 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<MachineKillWorkerActor*>(this)->actor_wait_state > 0) static_cast<MachineKillWorkerActor*>(this)->actor_wait_state = 0;
		static_cast<MachineKillWorkerActor*>(this)->ActorCallback< MachineKillWorkerActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MachineKillWorkerActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("machineKillWorker", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MachineKillWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("machineKillWorker", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< MachineKillWorkerActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("machineKillWorker", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MachineKillWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("machineKillWorker", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< MachineKillWorkerActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("machineKillWorker", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MachineKillWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("machineKillWorker", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1loopBody1loopBody1cont9(Void const& _,int loopDepth) 
	{
															#line 473 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
		delayBeforeKill = deterministicRandom()->random01() * meanDelay;
															#line 474 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
		TraceEvent("WorkerKillAfterMeanDelay").detail("DelayBeforeKill", delayBeforeKill);
															#line 2941 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont9(Void && _,int loopDepth) 
	{
															#line 473 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
		delayBeforeKill = deterministicRandom()->random01() * meanDelay;
															#line 474 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
		TraceEvent("WorkerKillAfterMeanDelay").detail("DelayBeforeKill", delayBeforeKill);
															#line 2952 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<MachineKillWorkerActor*>(this)->actor_wait_state > 0) static_cast<MachineKillWorkerActor*>(this)->actor_wait_state = 0;
		static_cast<MachineKillWorkerActor*>(this)->ActorCallback< MachineKillWorkerActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MachineKillWorkerActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("machineKillWorker", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MachineKillWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1loopBody1loopBody1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("machineKillWorker", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< MachineKillWorkerActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("machineKillWorker", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MachineKillWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1loopBody1loopBody1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("machineKillWorker", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< MachineKillWorkerActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("machineKillWorker", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MachineKillWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("machineKillWorker", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1loopBody1cont16(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont18(Void const& _,int loopDepth) 
	{
															#line 481 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
		suspendDuration *= self->backoff;
															#line 3042 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont16(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont18(Void && _,int loopDepth) 
	{
															#line 481 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
		suspendDuration *= self->backoff;
															#line 3051 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont16(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont18(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont18(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<MachineKillWorkerActor*>(this)->actor_wait_state > 0) static_cast<MachineKillWorkerActor*>(this)->actor_wait_state = 0;
		static_cast<MachineKillWorkerActor*>(this)->ActorCallback< MachineKillWorkerActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MachineKillWorkerActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("machineKillWorker", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MachineKillWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("machineKillWorker", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< MachineKillWorkerActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("machineKillWorker", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MachineKillWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("machineKillWorker", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< MachineKillWorkerActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("machineKillWorker", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MachineKillWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("machineKillWorker", reinterpret_cast<unsigned long>(this), 8);

	}
															#line 325 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
	MachineAttritionWorkload* self;
															#line 325 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
	double meanDelay;
															#line 325 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
	Database cx;
															#line 327 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
	double delayBeforeKill;
															#line 328 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
	double suspendDuration;
															#line 329 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
	double startTime;
															#line 371 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
	ISimulator::KillType kt;
															#line 379 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
	int killedMachines;
															#line 393 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
	Transaction tr;
															#line 407 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
	LocalityData targetMachine;
															#line 3151 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
};
// This generated class is to be used only via machineKillWorker()
															#line 325 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
class MachineKillWorkerActor final : public Actor<Void>, public ActorCallback< MachineKillWorkerActor, 0, Void >, public ActorCallback< MachineKillWorkerActor, 1, Void >, public ActorCallback< MachineKillWorkerActor, 2, Void >, public ActorCallback< MachineKillWorkerActor, 3, Void >, public ActorCallback< MachineKillWorkerActor, 4, Void >, public ActorCallback< MachineKillWorkerActor, 5, Void >, public ActorCallback< MachineKillWorkerActor, 6, Void >, public ActorCallback< MachineKillWorkerActor, 7, Void >, public ActorCallback< MachineKillWorkerActor, 8, Void >, public FastAllocated<MachineKillWorkerActor>, public MachineKillWorkerActorState<MachineKillWorkerActor> {
															#line 3156 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
public:
	using FastAllocated<MachineKillWorkerActor>::operator new;
	using FastAllocated<MachineKillWorkerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4382445621235272448UL, 3470774251937012992UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MachineKillWorkerActor, 0, Void >;
friend struct ActorCallback< MachineKillWorkerActor, 1, Void >;
friend struct ActorCallback< MachineKillWorkerActor, 2, Void >;
friend struct ActorCallback< MachineKillWorkerActor, 3, Void >;
friend struct ActorCallback< MachineKillWorkerActor, 4, Void >;
friend struct ActorCallback< MachineKillWorkerActor, 5, Void >;
friend struct ActorCallback< MachineKillWorkerActor, 6, Void >;
friend struct ActorCallback< MachineKillWorkerActor, 7, Void >;
friend struct ActorCallback< MachineKillWorkerActor, 8, Void >;
															#line 325 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
	MachineKillWorkerActor(MachineAttritionWorkload* const& self,double const& meanDelay,Database const& cx) 
															#line 3181 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   MachineKillWorkerActorState<MachineKillWorkerActor>(self, meanDelay, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("machineKillWorker", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15130967940671696896UL, 10834506323715476224UL);
		ActorExecutionContextHelper __helper(static_cast<MachineKillWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("machineKillWorker");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("machineKillWorker", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MachineKillWorkerActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< MachineKillWorkerActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< MachineKillWorkerActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< MachineKillWorkerActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< MachineKillWorkerActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< MachineKillWorkerActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< MachineKillWorkerActor, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< MachineKillWorkerActor, 7, Void >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< MachineKillWorkerActor, 8, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 325 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
[[nodiscard]] static Future<Void> machineKillWorker( MachineAttritionWorkload* const& self, double const& meanDelay, Database const& cx ) {
															#line 325 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
	return Future<Void>(new MachineKillWorkerActor(self, meanDelay, cx));
															#line 3221 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MachineAttrition.actor.g.cpp.py_gen"
}

#line 489 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/MachineAttrition.actor.cpp"
};

WorkloadFactory<MachineAttritionWorkload> MachineAttritionWorkloadFactory;
FailureInjectorFactory<MachineAttritionWorkload> MachineAttritionFailureWorkloadFactory;
