#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
/*
 * DiskDurability.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbserver/workloads/workloads.actor.h"
#include "flow/ActorCollection.h"
#include "flow/SystemMonitor.h"
#include "flow/IAsyncFile.h"
#include "fdbserver/workloads/AsyncFile.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

struct DiskDurabilityWorkload : public AsyncFileWorkload {
	static constexpr auto NAME = "DiskDurability";
	struct FileBlock {
		FileBlock(int blockNum) : blockNum(blockNum), lastData(0), lock(new FlowLock(1)) {}
		~FileBlock() {}
		int blockNum;
		int64_t lastData;
		Reference<FlowLock> lock;

																	#line 39 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurability.actor.g.cpp.py_gen"
// This generated class is to be used only via test_impl()
															#line 37 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
template <class Test_implActor>
															#line 37 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
class Test_implActorState {
															#line 45 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurability.actor.g.cpp.py_gen"
public:
															#line 37 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
	Test_implActorState(FileBlock* const& self,Reference<AsyncFileHandle> const& file,int const& pages,Reference<AsyncFileBuffer> const& buffer) 
															#line 37 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
															#line 37 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
		 : self(self),
															#line 37 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
		   file(file),
															#line 37 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
		   pages(pages),
															#line 37 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
		   buffer(buffer)
															#line 58 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurability.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("test_impl", reinterpret_cast<unsigned long>(this));

	}
	~Test_implActorState() 
	{
		fdb_probe_actor_destroy("test_impl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 41 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->lock->take();
															#line 41 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
			if (static_cast<Test_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 75 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurability.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<Test_implActor*>(this)->actor_wait_state = 1;
															#line 41 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< Test_implActor, 0, Void >*>(static_cast<Test_implActor*>(this)));
															#line 80 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurability.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~Test_implActorState();
		static_cast<Test_implActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 43 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
		offset = (int64_t)self->blockNum * pages * _PAGE_SIZE;
															#line 44 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
		size = pages * _PAGE_SIZE;
															#line 46 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
		newData = 0;
															#line 47 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
		if (self->lastData == 0)
															#line 109 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurability.actor.g.cpp.py_gen"
		{
															#line 48 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
			newData = deterministicRandom()->randomInt64(std::numeric_limits<int64_t>::min(), std::numeric_limits<int64_t>::max());
															#line 113 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurability.actor.g.cpp.py_gen"
			loopDepth = a_body1cont2(loopDepth);
		}
		else
		{
															#line 51 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
			++newData;
															#line 52 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
			StrictFuture<int> __when_expr_1 = file->file->read(buffer->buffer, size, offset);
															#line 52 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
			if (static_cast<Test_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 124 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurability.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<Test_implActor*>(this)->actor_wait_state = 2;
															#line 52 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< Test_implActor, 1, int >*>(static_cast<Test_implActor*>(this)));
															#line 129 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurability.actor.g.cpp.py_gen"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 43 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
		offset = (int64_t)self->blockNum * pages * _PAGE_SIZE;
															#line 44 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
		size = pages * _PAGE_SIZE;
															#line 46 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
		newData = 0;
															#line 47 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
		if (self->lastData == 0)
															#line 145 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurability.actor.g.cpp.py_gen"
		{
															#line 48 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
			newData = deterministicRandom()->randomInt64(std::numeric_limits<int64_t>::min(), std::numeric_limits<int64_t>::max());
															#line 149 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurability.actor.g.cpp.py_gen"
			loopDepth = a_body1cont2(loopDepth);
		}
		else
		{
															#line 51 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
			++newData;
															#line 52 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
			StrictFuture<int> __when_expr_1 = file->file->read(buffer->buffer, size, offset);
															#line 52 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
			if (static_cast<Test_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 160 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurability.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<Test_implActor*>(this)->actor_wait_state = 2;
															#line 52 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< Test_implActor, 1, int >*>(static_cast<Test_implActor*>(this)));
															#line 165 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurability.actor.g.cpp.py_gen"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<Test_implActor*>(this)->actor_wait_state > 0) static_cast<Test_implActor*>(this)->actor_wait_state = 0;
		static_cast<Test_implActor*>(this)->ActorCallback< Test_implActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< Test_implActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("test_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Test_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("test_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< Test_implActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("test_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Test_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("test_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< Test_implActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("test_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<Test_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("test_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 56 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
		if (newData == 0)
															#line 250 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurability.actor.g.cpp.py_gen"
		{
															#line 57 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
			newData = 1;
															#line 254 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurability.actor.g.cpp.py_gen"
		}
															#line 58 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
		int64_t* arr = (int64_t*)buffer->buffer;
															#line 59 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
		for(int i = 0, imax = size / sizeof(int64_t);i < imax;++i) {
															#line 60 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
			if (self->lastData != 0 && arr[i] != self->lastData)
															#line 262 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurability.actor.g.cpp.py_gen"
			{
															#line 61 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
				TraceEvent(SevError, "WriteWasNotDurable") .detail("Filename", file->path) .detail("Offset", offset) .detail("OpSize", size) .detail("Expected", self->lastData) .detail("Found", arr[i]) .detail("Index", i);
															#line 68 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
				return a_body1Catch1(io_error(), loopDepth);
															#line 268 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurability.actor.g.cpp.py_gen"
			}
															#line 70 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
			arr[i] = newData;
															#line 272 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurability.actor.g.cpp.py_gen"
		}
															#line 73 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
		StrictFuture<Void> __when_expr_2 = file->file->write(buffer->buffer, size, offset);
															#line 73 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
		if (static_cast<Test_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 278 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurability.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<Test_implActor*>(this)->actor_wait_state = 3;
															#line 73 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< Test_implActor, 2, Void >*>(static_cast<Test_implActor*>(this)));
															#line 283 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurability.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(int const& readBytes,int loopDepth) 
	{
															#line 53 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
		ASSERT(readBytes == size);
															#line 292 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurability.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(int && readBytes,int loopDepth) 
	{
															#line 53 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
		ASSERT(readBytes == size);
															#line 301 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurability.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(int const& readBytes,int loopDepth) 
	{
		loopDepth = a_body1cont4(readBytes, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(int && readBytes,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(readBytes), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<Test_implActor*>(this)->actor_wait_state > 0) static_cast<Test_implActor*>(this)->actor_wait_state = 0;
		static_cast<Test_implActor*>(this)->ActorCallback< Test_implActor, 1, int >::remove();

	}
	void a_callback_fire(ActorCallback< Test_implActor, 1, int >*,int const& value) 
	{
		fdb_probe_actor_enter("test_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Test_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("test_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< Test_implActor, 1, int >*,int && value) 
	{
		fdb_probe_actor_enter("test_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Test_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("test_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< Test_implActor, 1, int >*,Error err) 
	{
		fdb_probe_actor_enter("test_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<Test_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("test_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 74 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
		self->lock->release(1);
															#line 75 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
		self->lastData = newData;
															#line 76 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
		if (!static_cast<Test_implActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~Test_implActorState(); static_cast<Test_implActor*>(this)->destroy(); return 0; }
															#line 389 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurability.actor.g.cpp.py_gen"
		new (&static_cast<Test_implActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~Test_implActorState();
		static_cast<Test_implActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 74 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
		self->lock->release(1);
															#line 75 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
		self->lastData = newData;
															#line 76 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
		if (!static_cast<Test_implActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~Test_implActorState(); static_cast<Test_implActor*>(this)->destroy(); return 0; }
															#line 405 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurability.actor.g.cpp.py_gen"
		new (&static_cast<Test_implActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~Test_implActorState();
		static_cast<Test_implActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<Test_implActor*>(this)->actor_wait_state > 0) static_cast<Test_implActor*>(this)->actor_wait_state = 0;
		static_cast<Test_implActor*>(this)->ActorCallback< Test_implActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< Test_implActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("test_impl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Test_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("test_impl", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< Test_implActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("test_impl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Test_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("test_impl", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< Test_implActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("test_impl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<Test_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("test_impl", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 37 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
	FileBlock* self;
															#line 37 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
	Reference<AsyncFileHandle> file;
															#line 37 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
	int pages;
															#line 37 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
	Reference<AsyncFileBuffer> buffer;
															#line 43 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
	int64_t offset;
															#line 44 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
	int size;
															#line 46 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
	int64_t newData;
															#line 502 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurability.actor.g.cpp.py_gen"
};
// This generated class is to be used only via test_impl()
															#line 37 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
class Test_implActor final : public Actor<Void>, public ActorCallback< Test_implActor, 0, Void >, public ActorCallback< Test_implActor, 1, int >, public ActorCallback< Test_implActor, 2, Void >, public FastAllocated<Test_implActor>, public Test_implActorState<Test_implActor> {
															#line 507 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurability.actor.g.cpp.py_gen"
public:
	using FastAllocated<Test_implActor>::operator new;
	using FastAllocated<Test_implActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5428325283492733696UL, 7569280143468658432UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< Test_implActor, 0, Void >;
friend struct ActorCallback< Test_implActor, 1, int >;
friend struct ActorCallback< Test_implActor, 2, Void >;
															#line 37 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
	Test_implActor(FileBlock* const& self,Reference<AsyncFileHandle> const& file,int const& pages,Reference<AsyncFileBuffer> const& buffer) 
															#line 526 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurability.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   Test_implActorState<Test_implActor>(self, file, pages, buffer),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("test_impl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14892430577732329472UL, 13421837041016126464UL);
		ActorExecutionContextHelper __helper(static_cast<Test_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("test_impl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("test_impl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< Test_implActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< Test_implActor, 1, int >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< Test_implActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 37 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
[[nodiscard]] static Future<Void> test_impl( FileBlock* const& self, Reference<AsyncFileHandle> const& file, int const& pages, Reference<AsyncFileBuffer> const& buffer ) {
															#line 37 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
	return Future<Void>(new Test_implActor(self, file, pages, buffer));
															#line 560 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurability.actor.g.cpp.py_gen"
}

#line 78 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"

		Future<Void> test(Reference<AsyncFileHandle> file, int pages, Reference<AsyncFileBuffer> buffer) {
			return test_impl(this, file, pages, buffer);
		}
	};

	std::vector<FileBlock> blocks;
	int pagesPerWrite;
	int filePages;
	int writers;
	double syncInterval;

	DiskDurabilityWorkload(WorkloadContext const& wcx) : AsyncFileWorkload(wcx) {
		writers = getOption(options, "writers"_sr, 1);
		filePages = getOption(options, "filePages"_sr, 1000000);
		fileSize = filePages * _PAGE_SIZE;
		unbufferedIO = true;
		uncachedIO = true;
		fillRandom = false;
		pagesPerWrite = getOption(options, "pagesPerWrite"_sr, 1);
		syncInterval = (double)(getOption(options, "syncIntervalMs"_sr, 2000)) / 1000;
	}

	~DiskDurabilityWorkload() override {}

	Future<Void> setup(Database const& cx) override {
		if (enabled)
			return _setup(this);

		return Void();
	}

																#line 596 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurability.actor.g.cpp.py_gen"
// This generated class is to be used only via _setup()
															#line 110 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
template <class _setupActor>
															#line 110 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
class _setupActorState {
															#line 602 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurability.actor.g.cpp.py_gen"
public:
															#line 110 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
	_setupActorState(DiskDurabilityWorkload* const& self) 
															#line 110 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
															#line 110 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
		 : self(self)
															#line 609 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurability.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("_setup", reinterpret_cast<unsigned long>(this));

	}
	~_setupActorState() 
	{
		fdb_probe_actor_destroy("_setup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 111 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
			ASSERT(!self->path.empty());
															#line 113 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
			int flags = IAsyncFile::OPEN_READWRITE | IAsyncFile::OPEN_CREATE;
															#line 115 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
			if (self->unbufferedIO)
															#line 628 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurability.actor.g.cpp.py_gen"
			{
															#line 116 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
				flags |= IAsyncFile::OPEN_UNBUFFERED;
															#line 632 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurability.actor.g.cpp.py_gen"
			}
															#line 117 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
			if (self->uncachedIO)
															#line 636 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurability.actor.g.cpp.py_gen"
			{
															#line 118 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
				flags |= IAsyncFile::OPEN_UNCACHED;
															#line 640 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurability.actor.g.cpp.py_gen"
			}
			try {
															#line 121 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
				StrictFuture<Reference<IAsyncFile>> __when_expr_0 = IAsyncFileSystem::filesystem()->open(self->path, flags, 0666);
															#line 121 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
				if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 647 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurability.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<_setupActor*>(this)->actor_wait_state = 1;
															#line 121 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 0, Reference<IAsyncFile> >*>(static_cast<_setupActor*>(this)));
															#line 652 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurability.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 131 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
		if (!static_cast<_setupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_setupActorState(); static_cast<_setupActor*>(this)->destroy(); return 0; }
															#line 681 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurability.actor.g.cpp.py_gen"
		new (&static_cast<_setupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& error,int loopDepth=0) 
	{
		try {
															#line 127 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
			TraceEvent(SevError, "TestFailure").detail("Reason", "Could not open file");
															#line 128 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
			return a_body1Catch1(error, loopDepth);
															#line 696 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurability.actor.g.cpp.py_gen"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4(int loopDepth) 
	{
															#line 122 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
		if (self->fileHandle.getPtr() == nullptr)
															#line 710 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurability.actor.g.cpp.py_gen"
		{
															#line 123 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
			self->fileHandle = makeReference<AsyncFileHandle>(file, self->path, false);
															#line 714 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurability.actor.g.cpp.py_gen"
		}
		else
		{
															#line 125 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
			self->fileHandle->file = file;
															#line 720 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurability.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Reference<IAsyncFile> const& __file,int loopDepth) 
	{
															#line 121 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
		file = __file;
															#line 730 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurability.actor.g.cpp.py_gen"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Reference<IAsyncFile> && __file,int loopDepth) 
	{
		file = std::move(__file);
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_setupActor*>(this)->actor_wait_state > 0) static_cast<_setupActor*>(this)->actor_wait_state = 0;
		static_cast<_setupActor*>(this)->ActorCallback< _setupActor, 0, Reference<IAsyncFile> >::remove();

	}
	void a_callback_fire(ActorCallback< _setupActor, 0, Reference<IAsyncFile> >*,Reference<IAsyncFile> const& value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _setupActor, 0, Reference<IAsyncFile> >*,Reference<IAsyncFile> && value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _setupActor, 0, Reference<IAsyncFile> >*,Error err) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont8(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 110 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
	DiskDurabilityWorkload* self;
															#line 121 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
	Reference<IAsyncFile> file;
															#line 822 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurability.actor.g.cpp.py_gen"
};
// This generated class is to be used only via _setup()
															#line 110 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
class _setupActor final : public Actor<Void>, public ActorCallback< _setupActor, 0, Reference<IAsyncFile> >, public FastAllocated<_setupActor>, public _setupActorState<_setupActor> {
															#line 827 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurability.actor.g.cpp.py_gen"
public:
	using FastAllocated<_setupActor>::operator new;
	using FastAllocated<_setupActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(623701758759310592UL, 2574021989563246080UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _setupActor, 0, Reference<IAsyncFile> >;
															#line 110 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
	_setupActor(DiskDurabilityWorkload* const& self) 
															#line 844 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurability.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   _setupActorState<_setupActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3044502327521131520UL, 13387266639422932480UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_setup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _setupActor, 0, Reference<IAsyncFile> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 110 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
[[nodiscard]] Future<Void> _setup( DiskDurabilityWorkload* const& self ) {
															#line 110 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
	return Future<Void>(new _setupActor(self));
															#line 876 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurability.actor.g.cpp.py_gen"
}

#line 133 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"

	Future<Void> start(Database const& cx) override {
		if (enabled)
			return _start(this);

		return Void();
	}

	static unsigned int intHash(unsigned int x) {
		x = ((x >> 16) ^ x) * 0x45d9f3b;
		x = ((x >> 16) ^ x) * 0x45d9f3b;
		x = (x >> 16) ^ x;
		return x;
	}

																#line 895 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurability.actor.g.cpp.py_gen"
// This generated class is to be used only via worker()
															#line 148 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
template <class WorkerActor>
															#line 148 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
class WorkerActorState {
															#line 901 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurability.actor.g.cpp.py_gen"
public:
															#line 148 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
	WorkerActorState(DiskDurabilityWorkload* const& self) 
															#line 148 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
															#line 148 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
		 : self(self),
															#line 149 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
		   buffer(makeReference<AsyncFileBuffer>(_PAGE_SIZE, true)),
															#line 150 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
		   logfp((int)ceil(log2(self->filePages)))
															#line 912 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurability.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("worker", reinterpret_cast<unsigned long>(this));

	}
	~WorkerActorState() 
	{
		fdb_probe_actor_destroy("worker", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 151 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
			;
															#line 927 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurability.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WorkerActorState();
		static_cast<WorkerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 152 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
		int block = intHash(std::min<int>( deterministicRandom()->randomInt(0, 1 << deterministicRandom()->randomInt(0, logfp)), self->filePages - 1)) % self->filePages;
															#line 156 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
		StrictFuture<Void> __when_expr_0 = self->blocks[block].test(self->fileHandle, self->pagesPerWrite, buffer);
															#line 156 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
		if (static_cast<WorkerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 961 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurability.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<WorkerActor*>(this)->actor_wait_state = 1;
															#line 156 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WorkerActor, 0, Void >*>(static_cast<WorkerActor*>(this)));
															#line 966 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurability.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WorkerActor*>(this)->actor_wait_state > 0) static_cast<WorkerActor*>(this)->actor_wait_state = 0;
		static_cast<WorkerActor*>(this)->ActorCallback< WorkerActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WorkerActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("worker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("worker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WorkerActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("worker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("worker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WorkerActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("worker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("worker", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 148 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
	DiskDurabilityWorkload* self;
															#line 149 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
	Reference<AsyncFileBuffer> buffer;
															#line 150 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
	int logfp;
															#line 1064 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurability.actor.g.cpp.py_gen"
};
// This generated class is to be used only via worker()
															#line 148 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
class WorkerActor final : public Actor<Void>, public ActorCallback< WorkerActor, 0, Void >, public FastAllocated<WorkerActor>, public WorkerActorState<WorkerActor> {
															#line 1069 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurability.actor.g.cpp.py_gen"
public:
	using FastAllocated<WorkerActor>::operator new;
	using FastAllocated<WorkerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13806491667886118912UL, 11105927761973609216UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WorkerActor, 0, Void >;
															#line 148 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
	WorkerActor(DiskDurabilityWorkload* const& self) 
															#line 1086 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurability.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   WorkerActorState<WorkerActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("worker", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9305151550442981632UL, 410782307204870400UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("worker");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("worker", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WorkerActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 148 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
[[nodiscard]] static Future<Void> worker( DiskDurabilityWorkload* const& self ) {
															#line 148 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
	return Future<Void>(new WorkerActor(self));
															#line 1118 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurability.actor.g.cpp.py_gen"
}

#line 159 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"

																#line 1123 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurability.actor.g.cpp.py_gen"
// This generated class is to be used only via syncLoop()
															#line 160 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
template <class SyncLoopActor>
															#line 160 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
class SyncLoopActorState {
															#line 1129 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurability.actor.g.cpp.py_gen"
public:
															#line 160 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
	SyncLoopActorState(DiskDurabilityWorkload* const& self) 
															#line 160 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
															#line 160 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
		 : self(self)
															#line 1136 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurability.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("syncLoop", reinterpret_cast<unsigned long>(this));

	}
	~SyncLoopActorState() 
	{
		fdb_probe_actor_destroy("syncLoop", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 161 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
			;
															#line 1151 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurability.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SyncLoopActorState();
		static_cast<SyncLoopActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 162 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delay(deterministicRandom()->random01() * self->syncInterval);
															#line 162 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
		if (static_cast<SyncLoopActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1183 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurability.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<SyncLoopActor*>(this)->actor_wait_state = 1;
															#line 162 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SyncLoopActor, 0, Void >*>(static_cast<SyncLoopActor*>(this)));
															#line 1188 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurability.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 163 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->fileHandle->file->sync();
															#line 163 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
		if (static_cast<SyncLoopActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1199 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurability.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<SyncLoopActor*>(this)->actor_wait_state = 2;
															#line 163 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SyncLoopActor, 1, Void >*>(static_cast<SyncLoopActor*>(this)));
															#line 1204 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurability.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 163 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->fileHandle->file->sync();
															#line 163 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
		if (static_cast<SyncLoopActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1215 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurability.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<SyncLoopActor*>(this)->actor_wait_state = 2;
															#line 163 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SyncLoopActor, 1, Void >*>(static_cast<SyncLoopActor*>(this)));
															#line 1220 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurability.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SyncLoopActor*>(this)->actor_wait_state > 0) static_cast<SyncLoopActor*>(this)->actor_wait_state = 0;
		static_cast<SyncLoopActor*>(this)->ActorCallback< SyncLoopActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SyncLoopActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("syncLoop", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SyncLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("syncLoop", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SyncLoopActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("syncLoop", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SyncLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("syncLoop", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SyncLoopActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("syncLoop", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SyncLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("syncLoop", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<SyncLoopActor*>(this)->actor_wait_state > 0) static_cast<SyncLoopActor*>(this)->actor_wait_state = 0;
		static_cast<SyncLoopActor*>(this)->ActorCallback< SyncLoopActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SyncLoopActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("syncLoop", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SyncLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("syncLoop", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< SyncLoopActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("syncLoop", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SyncLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("syncLoop", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< SyncLoopActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("syncLoop", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SyncLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("syncLoop", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 160 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
	DiskDurabilityWorkload* self;
															#line 1389 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurability.actor.g.cpp.py_gen"
};
// This generated class is to be used only via syncLoop()
															#line 160 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
class SyncLoopActor final : public Actor<Void>, public ActorCallback< SyncLoopActor, 0, Void >, public ActorCallback< SyncLoopActor, 1, Void >, public FastAllocated<SyncLoopActor>, public SyncLoopActorState<SyncLoopActor> {
															#line 1394 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurability.actor.g.cpp.py_gen"
public:
	using FastAllocated<SyncLoopActor>::operator new;
	using FastAllocated<SyncLoopActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16546781044396690688UL, 4466618967614773760UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SyncLoopActor, 0, Void >;
friend struct ActorCallback< SyncLoopActor, 1, Void >;
															#line 160 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
	SyncLoopActor(DiskDurabilityWorkload* const& self) 
															#line 1412 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurability.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   SyncLoopActorState<SyncLoopActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("syncLoop", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14439914170781768448UL, 2851065546291867648UL);
		ActorExecutionContextHelper __helper(static_cast<SyncLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("syncLoop");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("syncLoop", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SyncLoopActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< SyncLoopActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 160 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
[[nodiscard]] static Future<Void> syncLoop( DiskDurabilityWorkload* const& self ) {
															#line 160 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
	return Future<Void>(new SyncLoopActor(self));
															#line 1445 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurability.actor.g.cpp.py_gen"
}

#line 166 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"

																#line 1450 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurability.actor.g.cpp.py_gen"
// This generated class is to be used only via _start()
															#line 167 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
template <class _startActor>
															#line 167 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
class _startActorState {
															#line 1456 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurability.actor.g.cpp.py_gen"
public:
															#line 167 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
	_startActorState(DiskDurabilityWorkload* const& self) 
															#line 167 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
															#line 167 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
		 : self(self)
															#line 1463 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurability.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 168 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
			self->blocks.reserve(self->filePages);
															#line 169 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
			for(int i = 0;i < self->filePages;++i) {
															#line 170 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
				self->blocks.push_back(FileBlock(i));
															#line 1482 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurability.actor.g.cpp.py_gen"
			}
															#line 172 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
			tasks = std::vector<Future<Void>>();
															#line 173 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
			tasks.push_back(syncLoop(self));
															#line 175 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
			for(int i = 0;i < self->writers;++i) {
															#line 176 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
				tasks.push_back(worker(self));
															#line 1492 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurability.actor.g.cpp.py_gen"
			}
															#line 178 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
			StrictFuture<Void> __when_expr_0 = timeout(waitForAll(tasks), self->testDuration, Void());
															#line 178 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1498 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurability.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 178 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, Void >*>(static_cast<_startActor*>(this)));
															#line 1503 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurability.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 180 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 1526 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurability.actor.g.cpp.py_gen"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 180 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 1538 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurability.actor.g.cpp.py_gen"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 167 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
	DiskDurabilityWorkload* self;
															#line 172 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
	std::vector<Future<Void>> tasks;
															#line 1625 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurability.actor.g.cpp.py_gen"
};
// This generated class is to be used only via _start()
															#line 167 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, Void >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 1630 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurability.actor.g.cpp.py_gen"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16867563665277979648UL, 11209991661643533056UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, Void >;
															#line 167 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
	_startActor(DiskDurabilityWorkload* const& self) 
															#line 1647 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurability.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   _startActorState<_startActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 167 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
[[nodiscard]] Future<Void> _start( DiskDurabilityWorkload* const& self ) {
															#line 167 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"
	return Future<Void>(new _startActor(self));
															#line 1679 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurability.actor.g.cpp.py_gen"
}

#line 182 "/codebuild/output/src2900330747/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurability.actor.cpp"

	void getMetrics(std::vector<PerfMetric>& m) override {}
};

WorkloadFactory<DiskDurabilityWorkload> DiskDurabilityWorkloadFactory;
