#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/workloads/CreateTenant.actor.cpp"
/*
 * CreateTenant.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <cstdint>

#include "fdbclient/Tenant.h"
#include "fdbclient/TenantManagement.actor.h"
#include "fdbserver/Knobs.h"
#include "fdbserver/workloads/workloads.actor.h"

#include "flow/actorcompiler.h" // This must be the last #include.

struct CreateTenantWorkload : TestWorkload {
	static constexpr auto NAME = "CreateTenant";
	TenantName tenant;
	Optional<TenantGroupName> tenantGroup;

	CreateTenantWorkload(WorkloadContext const& wcx) : TestWorkload(wcx) {
		tenant = getOption(options, "name"_sr, "DefaultTenant"_sr);
		if (hasOption(options, "group"_sr)) {
			tenantGroup = getOption(options, "group"_sr, "DefaultGroup"_sr);
		}
	}

	Future<Void> setup(Database const& cx) override {
		if (clientId == 0) {
			return _setup(this, cx);
		}
		return Void();
	}

	Future<Void> start(Database const& cx) override { return Void(); }
	Future<bool> check(Database const& cx) override { return true; }
	virtual void getMetrics(std::vector<PerfMetric>& m) override {}

																#line 55 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CreateTenant.actor.g.cpp"
// This generated class is to be used only via _setup()
															#line 53 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/workloads/CreateTenant.actor.cpp"
template <class _setupActor>
															#line 53 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/workloads/CreateTenant.actor.cpp"
class _setupActorState {
															#line 61 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CreateTenant.actor.g.cpp"
public:
															#line 53 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/workloads/CreateTenant.actor.cpp"
	_setupActorState(CreateTenantWorkload* const& self,Database const& db) 
															#line 53 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/workloads/CreateTenant.actor.cpp"
															#line 53 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/workloads/CreateTenant.actor.cpp"
		 : self(self),
															#line 53 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/workloads/CreateTenant.actor.cpp"
		   db(db)
															#line 70 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CreateTenant.actor.g.cpp"
	{
		fdb_probe_actor_create("_setup", reinterpret_cast<unsigned long>(this));

	}
	~_setupActorState() 
	{
		fdb_probe_actor_destroy("_setup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 55 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/workloads/CreateTenant.actor.cpp"
				TenantMapEntry givenEntry;
															#line 56 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/workloads/CreateTenant.actor.cpp"
				if (self->tenantGroup.present())
															#line 88 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CreateTenant.actor.g.cpp"
				{
															#line 57 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/workloads/CreateTenant.actor.cpp"
					givenEntry.tenantGroup = self->tenantGroup.get();
															#line 92 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CreateTenant.actor.g.cpp"
				}
															#line 59 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/workloads/CreateTenant.actor.cpp"
				StrictFuture<Optional<TenantMapEntry>> __when_expr_0 = TenantAPI::createTenant(db.getReference(), self->tenant, givenEntry);
															#line 59 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/workloads/CreateTenant.actor.cpp"
				if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 98 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CreateTenant.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<_setupActor*>(this)->actor_wait_state = 1;
															#line 59 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/workloads/CreateTenant.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 0, Optional<TenantMapEntry> >*>(static_cast<_setupActor*>(this)));
															#line 103 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CreateTenant.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 68 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/workloads/CreateTenant.actor.cpp"
		if (!static_cast<_setupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_setupActorState(); static_cast<_setupActor*>(this)->destroy(); return 0; }
															#line 132 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CreateTenant.actor.g.cpp"
		new (&static_cast<_setupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 62 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/workloads/CreateTenant.actor.cpp"
			TraceEvent(SevError, "TenantCreationFailed").error(e);
															#line 63 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/workloads/CreateTenant.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 147 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CreateTenant.actor.g.cpp"
			{
															#line 64 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/workloads/CreateTenant.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 151 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CreateTenant.actor.g.cpp"
			}
															#line 66 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/workloads/CreateTenant.actor.cpp"
			ASSERT(false);
															#line 155 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CreateTenant.actor.g.cpp"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Optional<TenantMapEntry> const& entry,int loopDepth) 
	{
															#line 60 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/workloads/CreateTenant.actor.cpp"
		ASSERT(entry.present());
															#line 170 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CreateTenant.actor.g.cpp"
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Optional<TenantMapEntry> && entry,int loopDepth) 
	{
															#line 60 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/workloads/CreateTenant.actor.cpp"
		ASSERT(entry.present());
															#line 179 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CreateTenant.actor.g.cpp"
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<TenantMapEntry> const& entry,int loopDepth) 
	{
		loopDepth = a_body1cont2(entry, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<TenantMapEntry> && entry,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(entry), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_setupActor*>(this)->actor_wait_state > 0) static_cast<_setupActor*>(this)->actor_wait_state = 0;
		static_cast<_setupActor*>(this)->ActorCallback< _setupActor, 0, Optional<TenantMapEntry> >::remove();

	}
	void a_callback_fire(ActorCallback< _setupActor, 0, Optional<TenantMapEntry> >*,Optional<TenantMapEntry> const& value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _setupActor, 0, Optional<TenantMapEntry> >*,Optional<TenantMapEntry> && value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _setupActor, 0, Optional<TenantMapEntry> >*,Error err) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 53 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/workloads/CreateTenant.actor.cpp"
	CreateTenantWorkload* self;
															#line 53 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/workloads/CreateTenant.actor.cpp"
	Database db;
															#line 276 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CreateTenant.actor.g.cpp"
};
// This generated class is to be used only via _setup()
															#line 53 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/workloads/CreateTenant.actor.cpp"
class _setupActor final : public Actor<Void>, public ActorCallback< _setupActor, 0, Optional<TenantMapEntry> >, public FastAllocated<_setupActor>, public _setupActorState<_setupActor> {
															#line 281 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CreateTenant.actor.g.cpp"
public:
	using FastAllocated<_setupActor>::operator new;
	using FastAllocated<_setupActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(18074901573498356224UL, 11843351796820094976UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _setupActor, 0, Optional<TenantMapEntry> >;
															#line 53 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/workloads/CreateTenant.actor.cpp"
	_setupActor(CreateTenantWorkload* const& self,Database const& db) 
															#line 298 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CreateTenant.actor.g.cpp"
		 : Actor<Void>(),
		   _setupActorState<_setupActor>(self, db),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3044502327521131520UL, 13387266639422932480UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_setup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _setupActor, 0, Optional<TenantMapEntry> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 53 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/workloads/CreateTenant.actor.cpp"
[[nodiscard]] static Future<Void> _setup( CreateTenantWorkload* const& self, Database const& db ) {
															#line 53 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/workloads/CreateTenant.actor.cpp"
	return Future<Void>(new _setupActor(self, db));
															#line 330 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CreateTenant.actor.g.cpp"
}

#line 70 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/workloads/CreateTenant.actor.cpp"
};

WorkloadFactory<CreateTenantWorkload> CreateTenantWorkload;
