#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
/*
 * TenantCache.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <limits>
#include <string>

#include "fdbclient/FDBOptions.g.h"
#include "fdbclient/KeyBackedTypes.actor.h"
#include "fdbclient/SystemData.h"
#include "fdbclient/FDBTypes.h"
#include "fdbclient/Tenant.h"
#include "fdbserver/DDTeamCollection.h"
#include "fdbserver/TenantCache.h"
#include "flow/flow.h"
#include "flow/Trace.h"
#include "flow/WipedString.h"
#include "flow/actorcompiler.h" // This must be the last #include.

class TenantCacheImpl {

																#line 40 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
// This generated class is to be used only via getTenantList()
															#line 38 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
template <class GetTenantListActor>
															#line 38 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
class GetTenantListActorState {
															#line 46 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
public:
															#line 38 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
	GetTenantListActorState(TenantCache* const& tenantCache,Transaction* const& tr) 
															#line 38 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
															#line 38 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		 : tenantCache(tenantCache),
															#line 38 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		   tr(tr)
															#line 55 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
	{
		fdb_probe_actor_create("getTenantList", reinterpret_cast<unsigned long>(this));

	}
	~GetTenantListActorState() 
	{
		fdb_probe_actor_destroy("getTenantList", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 40 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
			tr->setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 41 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
			tr->setOption(FDBTransactionOptions::READ_LOCK_AWARE);
															#line 43 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
			StrictFuture<KeyBackedRangeResult<std::pair<int64_t, TenantMapEntry>>> __when_expr_0 = TenantMetadata::tenantMap().getRange(tr, {}, {}, CLIENT_KNOBS->MAX_TENANTS_PER_CLUSTER + 1);
															#line 43 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
			if (static_cast<GetTenantListActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 76 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetTenantListActor*>(this)->actor_wait_state = 1;
															#line 43 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetTenantListActor, 0, KeyBackedRangeResult<std::pair<int64_t, TenantMapEntry>> >*>(static_cast<GetTenantListActor*>(this)));
															#line 81 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetTenantListActorState();
		static_cast<GetTenantListActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(KeyBackedRangeResult<std::pair<int64_t, TenantMapEntry>> const& tenantList,int loopDepth) 
	{
															#line 45 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		ASSERT(tenantList.results.size() <= CLIENT_KNOBS->MAX_TENANTS_PER_CLUSTER && !tenantList.more);
															#line 47 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		if (!static_cast<GetTenantListActor*>(this)->SAV<std::vector<std::pair<int64_t, TenantMapEntry>>>::futures) { (void)(tenantList.results); this->~GetTenantListActorState(); static_cast<GetTenantListActor*>(this)->destroy(); return 0; }
															#line 106 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
		new (&static_cast<GetTenantListActor*>(this)->SAV< std::vector<std::pair<int64_t, TenantMapEntry>> >::value()) std::vector<std::pair<int64_t, TenantMapEntry>>(tenantList.results);
		this->~GetTenantListActorState();
		static_cast<GetTenantListActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(KeyBackedRangeResult<std::pair<int64_t, TenantMapEntry>> && tenantList,int loopDepth) 
	{
															#line 45 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		ASSERT(tenantList.results.size() <= CLIENT_KNOBS->MAX_TENANTS_PER_CLUSTER && !tenantList.more);
															#line 47 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		if (!static_cast<GetTenantListActor*>(this)->SAV<std::vector<std::pair<int64_t, TenantMapEntry>>>::futures) { (void)(tenantList.results); this->~GetTenantListActorState(); static_cast<GetTenantListActor*>(this)->destroy(); return 0; }
															#line 120 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
		new (&static_cast<GetTenantListActor*>(this)->SAV< std::vector<std::pair<int64_t, TenantMapEntry>> >::value()) std::vector<std::pair<int64_t, TenantMapEntry>>(tenantList.results);
		this->~GetTenantListActorState();
		static_cast<GetTenantListActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(KeyBackedRangeResult<std::pair<int64_t, TenantMapEntry>> const& tenantList,int loopDepth) 
	{
		loopDepth = a_body1cont1(tenantList, loopDepth);

		return loopDepth;
	}
	int a_body1when1(KeyBackedRangeResult<std::pair<int64_t, TenantMapEntry>> && tenantList,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(tenantList), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetTenantListActor*>(this)->actor_wait_state > 0) static_cast<GetTenantListActor*>(this)->actor_wait_state = 0;
		static_cast<GetTenantListActor*>(this)->ActorCallback< GetTenantListActor, 0, KeyBackedRangeResult<std::pair<int64_t, TenantMapEntry>> >::remove();

	}
	void a_callback_fire(ActorCallback< GetTenantListActor, 0, KeyBackedRangeResult<std::pair<int64_t, TenantMapEntry>> >*,KeyBackedRangeResult<std::pair<int64_t, TenantMapEntry>> const& value) 
	{
		fdb_probe_actor_enter("getTenantList", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTenantListActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTenantList", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetTenantListActor, 0, KeyBackedRangeResult<std::pair<int64_t, TenantMapEntry>> >*,KeyBackedRangeResult<std::pair<int64_t, TenantMapEntry>> && value) 
	{
		fdb_probe_actor_enter("getTenantList", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTenantListActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTenantList", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetTenantListActor, 0, KeyBackedRangeResult<std::pair<int64_t, TenantMapEntry>> >*,Error err) 
	{
		fdb_probe_actor_enter("getTenantList", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetTenantListActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTenantList", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 38 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
	TenantCache* tenantCache;
															#line 38 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
	Transaction* tr;
															#line 207 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
};
// This generated class is to be used only via getTenantList()
															#line 38 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
class GetTenantListActor final : public Actor<std::vector<std::pair<int64_t, TenantMapEntry>>>, public ActorCallback< GetTenantListActor, 0, KeyBackedRangeResult<std::pair<int64_t, TenantMapEntry>> >, public FastAllocated<GetTenantListActor>, public GetTenantListActorState<GetTenantListActor> {
															#line 212 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
public:
	using FastAllocated<GetTenantListActor>::operator new;
	using FastAllocated<GetTenantListActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5036362036324553984UL, 8002813818505003776UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<std::pair<int64_t, TenantMapEntry>>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetTenantListActor, 0, KeyBackedRangeResult<std::pair<int64_t, TenantMapEntry>> >;
															#line 38 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
	GetTenantListActor(TenantCache* const& tenantCache,Transaction* const& tr) 
															#line 229 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
		 : Actor<std::vector<std::pair<int64_t, TenantMapEntry>>>(),
		   GetTenantListActorState<GetTenantListActor>(tenantCache, tr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getTenantList", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1189576443889321728UL, 1285806307834110464UL);
		ActorExecutionContextHelper __helper(static_cast<GetTenantListActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getTenantList");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getTenantList", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetTenantListActor, 0, KeyBackedRangeResult<std::pair<int64_t, TenantMapEntry>> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 38 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
[[nodiscard]] static Future<std::vector<std::pair<int64_t, TenantMapEntry>>> getTenantList( TenantCache* const& tenantCache, Transaction* const& tr ) {
															#line 38 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
	return Future<std::vector<std::pair<int64_t, TenantMapEntry>>>(new GetTenantListActor(tenantCache, tr));
															#line 261 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
}

#line 49 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"

public:
																#line 267 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
// This generated class is to be used only via build()
															#line 51 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
template <class BuildActor>
															#line 51 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
class BuildActorState {
															#line 273 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
public:
															#line 51 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
	BuildActorState(TenantCache* const& tenantCache) 
															#line 51 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
															#line 51 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		 : tenantCache(tenantCache),
															#line 52 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		   tr(tenantCache->dbcx())
															#line 282 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
	{
		fdb_probe_actor_create("build", reinterpret_cast<unsigned long>(this));

	}
	~BuildActorState() 
	{
		fdb_probe_actor_destroy("build", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 54 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
			TraceEvent(SevInfo, "TenantCacheBuildStarting", tenantCache->id());
															#line 297 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
			try {
															#line 57 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
				StrictFuture<std::vector<std::pair<int64_t, TenantMapEntry>>> __when_expr_0 = getTenantList(tenantCache, &tr);
															#line 57 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
				if (static_cast<BuildActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 303 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<BuildActor*>(this)->actor_wait_state = 1;
															#line 57 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< BuildActor, 0, std::vector<std::pair<int64_t, TenantMapEntry>> >*>(static_cast<BuildActor*>(this)));
															#line 308 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~BuildActorState();
		static_cast<BuildActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 71 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		TraceEvent(SevInfo, "TenantCacheBuildDone", tenantCache->id());
															#line 73 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		if (!static_cast<BuildActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~BuildActorState(); static_cast<BuildActor*>(this)->destroy(); return 0; }
															#line 339 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
		new (&static_cast<BuildActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~BuildActorState();
		static_cast<BuildActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 68 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 68 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
			if (static_cast<BuildActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 354 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1Catch2when1(__when_expr_1.get(), loopDepth); };
			static_cast<BuildActor*>(this)->actor_wait_state = 2;
															#line 68 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< BuildActor, 1, Void >*>(static_cast<BuildActor*>(this)));
															#line 359 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 59 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		for(int i = 0;i < tenantList.size();i++) {
															#line 60 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
			tenantCache->insert(tenantList[i].second);
															#line 62 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
			TraceEvent(SevDebug, "TenantCacheTenantFound", tenantCache->id()) .detail("TenantName", tenantList[i].second.tenantName) .detail("TenantID", tenantList[i].first) .detail("TenantPrefix", tenantList[i].second.prefix);
															#line 378 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
		}
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<std::pair<int64_t, TenantMapEntry>> const& __tenantList,int loopDepth) 
	{
															#line 57 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		tenantList = __tenantList;
															#line 388 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<std::pair<int64_t, TenantMapEntry>> && __tenantList,int loopDepth) 
	{
		tenantList = std::move(__tenantList);
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<BuildActor*>(this)->actor_wait_state > 0) static_cast<BuildActor*>(this)->actor_wait_state = 0;
		static_cast<BuildActor*>(this)->ActorCallback< BuildActor, 0, std::vector<std::pair<int64_t, TenantMapEntry>> >::remove();

	}
	void a_callback_fire(ActorCallback< BuildActor, 0, std::vector<std::pair<int64_t, TenantMapEntry>> >*,std::vector<std::pair<int64_t, TenantMapEntry>> const& value) 
	{
		fdb_probe_actor_enter("build", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BuildActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("build", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< BuildActor, 0, std::vector<std::pair<int64_t, TenantMapEntry>> >*,std::vector<std::pair<int64_t, TenantMapEntry>> && value) 
	{
		fdb_probe_actor_enter("build", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BuildActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("build", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< BuildActor, 0, std::vector<std::pair<int64_t, TenantMapEntry>> >*,Error err) 
	{
		fdb_probe_actor_enter("build", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BuildActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("build", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch2cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1Catch2cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1Catch2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1Catch2cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1Catch2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1Catch2cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<BuildActor*>(this)->actor_wait_state > 0) static_cast<BuildActor*>(this)->actor_wait_state = 0;
		static_cast<BuildActor*>(this)->ActorCallback< BuildActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BuildActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("build", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BuildActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("build", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< BuildActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("build", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BuildActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("build", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< BuildActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("build", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BuildActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("build", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 51 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
	TenantCache* tenantCache;
															#line 52 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
	Transaction tr;
															#line 57 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
	std::vector<std::pair<int64_t, TenantMapEntry>> tenantList;
															#line 569 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
};
// This generated class is to be used only via build()
															#line 51 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
class BuildActor final : public Actor<Void>, public ActorCallback< BuildActor, 0, std::vector<std::pair<int64_t, TenantMapEntry>> >, public ActorCallback< BuildActor, 1, Void >, public FastAllocated<BuildActor>, public BuildActorState<BuildActor> {
															#line 574 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
public:
	using FastAllocated<BuildActor>::operator new;
	using FastAllocated<BuildActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10746546772724121344UL, 1839195763854627584UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< BuildActor, 0, std::vector<std::pair<int64_t, TenantMapEntry>> >;
friend struct ActorCallback< BuildActor, 1, Void >;
															#line 51 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
	BuildActor(TenantCache* const& tenantCache) 
															#line 592 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
		 : Actor<Void>(),
		   BuildActorState<BuildActor>(tenantCache),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("build", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8613508667439472384UL, 16068863012148696320UL);
		ActorExecutionContextHelper __helper(static_cast<BuildActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("build");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("build", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< BuildActor, 0, std::vector<std::pair<int64_t, TenantMapEntry>> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< BuildActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 51 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
[[nodiscard]] static Future<Void> build( TenantCache* const& tenantCache ) {
															#line 51 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
	return Future<Void>(new BuildActor(tenantCache));
															#line 625 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
}

#line 75 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"

																#line 630 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
// This generated class is to be used only via monitorTenantMap()
															#line 76 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
template <class MonitorTenantMapActor>
															#line 76 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
class MonitorTenantMapActorState {
															#line 636 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
public:
															#line 76 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
	MonitorTenantMapActorState(TenantCache* const& tenantCache) 
															#line 76 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
															#line 76 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		 : tenantCache(tenantCache)
															#line 643 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
	{
		fdb_probe_actor_create("monitorTenantMap", reinterpret_cast<unsigned long>(this));

	}
	~MonitorTenantMapActorState() 
	{
		fdb_probe_actor_destroy("monitorTenantMap", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 77 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
			TraceEvent(SevInfo, "TenantCacheMonitorStarting", tenantCache->id());
															#line 79 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
			tr = Transaction(tenantCache->dbcx());
															#line 81 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
			lastTenantListFetchTime = now();
															#line 83 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
			;
															#line 664 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MonitorTenantMapActorState();
		static_cast<MonitorTenantMapActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 85 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
			if (now() - lastTenantListFetchTime > (2 * SERVER_KNOBS->TENANT_CACHE_LIST_REFRESH_INTERVAL))
															#line 695 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
			{
															#line 86 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
				TraceEvent(SevWarn, "TenantCacheListRefreshSlow", tenantCache->id()) .detail("RefreshTime", now() - lastTenantListFetchTime);
															#line 699 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
			}
															#line 90 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
			StrictFuture<std::vector<std::pair<int64_t, TenantMapEntry>>> __when_expr_0 = getTenantList(tenantCache, &tr);
															#line 90 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
			if (static_cast<MonitorTenantMapActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 705 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<MonitorTenantMapActor*>(this)->actor_wait_state = 1;
															#line 90 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MonitorTenantMapActor, 0, std::vector<std::pair<int64_t, TenantMapEntry>> >*>(static_cast<MonitorTenantMapActor*>(this)));
															#line 710 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 117 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
			if (e.code() != error_code_actor_cancelled)
															#line 732 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
			{
															#line 118 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
				TraceEvent("TenantCacheGetListError", tenantCache->id()).errorUnsuppressed(e).suppressFor(1.0);
															#line 736 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
			}
															#line 120 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 120 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
			if (static_cast<MonitorTenantMapActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 742 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<MonitorTenantMapActor*>(this)->actor_wait_state = 3;
															#line 120 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MonitorTenantMapActor, 2, Void >*>(static_cast<MonitorTenantMapActor*>(this)));
															#line 747 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 93 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		tenantCache->startRefresh();
															#line 94 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		bool tenantListUpdated = false;
															#line 96 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		for(int i = 0;i < tenantList.size();i++) {
															#line 97 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
			if (tenantCache->update(tenantList[i].second))
															#line 768 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
			{
															#line 98 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
				tenantListUpdated = true;
															#line 99 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
				TenantCacheTenantCreated req(tenantList[i].second.prefix);
															#line 100 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
				tenantCache->tenantCreationSignal.send(req);
															#line 776 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
			}
		}
															#line 104 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		if (tenantCache->cleanup())
															#line 781 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
		{
															#line 105 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
			tenantListUpdated = true;
															#line 785 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
		}
															#line 108 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		if (tenantListUpdated)
															#line 789 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
		{
															#line 109 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
			TraceEvent(SevDebug, "TenantCacheListUpdated", tenantCache->id()) .detail("List", tenantCache->desc());
															#line 793 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
		}
															#line 113 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		lastTenantListFetchTime = now();
															#line 114 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		tr.reset();
															#line 115 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(SERVER_KNOBS->TENANT_CACHE_LIST_REFRESH_INTERVAL);
															#line 115 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		if (static_cast<MonitorTenantMapActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 803 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<MonitorTenantMapActor*>(this)->actor_wait_state = 2;
															#line 115 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MonitorTenantMapActor, 1, Void >*>(static_cast<MonitorTenantMapActor*>(this)));
															#line 808 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(std::vector<std::pair<int64_t, TenantMapEntry>> const& __tenantList,int loopDepth) 
	{
															#line 90 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		tenantList = __tenantList;
															#line 817 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(std::vector<std::pair<int64_t, TenantMapEntry>> && __tenantList,int loopDepth) 
	{
		tenantList = std::move(__tenantList);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MonitorTenantMapActor*>(this)->actor_wait_state > 0) static_cast<MonitorTenantMapActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorTenantMapActor*>(this)->ActorCallback< MonitorTenantMapActor, 0, std::vector<std::pair<int64_t, TenantMapEntry>> >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorTenantMapActor, 0, std::vector<std::pair<int64_t, TenantMapEntry>> >*,std::vector<std::pair<int64_t, TenantMapEntry>> const& value) 
	{
		fdb_probe_actor_enter("monitorTenantMap", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorTenantMapActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorTenantMap", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MonitorTenantMapActor, 0, std::vector<std::pair<int64_t, TenantMapEntry>> >*,std::vector<std::pair<int64_t, TenantMapEntry>> && value) 
	{
		fdb_probe_actor_enter("monitorTenantMap", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorTenantMapActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorTenantMap", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MonitorTenantMapActor, 0, std::vector<std::pair<int64_t, TenantMapEntry>> >*,Error err) 
	{
		fdb_probe_actor_enter("monitorTenantMap", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorTenantMapActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorTenantMap", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<MonitorTenantMapActor*>(this)->actor_wait_state > 0) static_cast<MonitorTenantMapActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorTenantMapActor*>(this)->ActorCallback< MonitorTenantMapActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorTenantMapActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorTenantMap", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorTenantMapActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorTenantMap", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MonitorTenantMapActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorTenantMap", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorTenantMapActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorTenantMap", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< MonitorTenantMapActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorTenantMap", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorTenantMapActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorTenantMap", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont9(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<MonitorTenantMapActor*>(this)->actor_wait_state > 0) static_cast<MonitorTenantMapActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorTenantMapActor*>(this)->ActorCallback< MonitorTenantMapActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorTenantMapActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorTenantMap", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorTenantMapActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorTenantMap", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< MonitorTenantMapActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorTenantMap", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorTenantMapActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorTenantMap", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< MonitorTenantMapActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorTenantMap", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorTenantMapActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorTenantMap", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 76 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
	TenantCache* tenantCache;
															#line 79 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
	Transaction tr;
															#line 81 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
	double lastTenantListFetchTime;
															#line 90 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
	std::vector<std::pair<int64_t, TenantMapEntry>> tenantList;
															#line 1087 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
};
// This generated class is to be used only via monitorTenantMap()
															#line 76 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
class MonitorTenantMapActor final : public Actor<Void>, public ActorCallback< MonitorTenantMapActor, 0, std::vector<std::pair<int64_t, TenantMapEntry>> >, public ActorCallback< MonitorTenantMapActor, 1, Void >, public ActorCallback< MonitorTenantMapActor, 2, Void >, public FastAllocated<MonitorTenantMapActor>, public MonitorTenantMapActorState<MonitorTenantMapActor> {
															#line 1092 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
public:
	using FastAllocated<MonitorTenantMapActor>::operator new;
	using FastAllocated<MonitorTenantMapActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15532104268874486528UL, 11153126402055508736UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MonitorTenantMapActor, 0, std::vector<std::pair<int64_t, TenantMapEntry>> >;
friend struct ActorCallback< MonitorTenantMapActor, 1, Void >;
friend struct ActorCallback< MonitorTenantMapActor, 2, Void >;
															#line 76 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
	MonitorTenantMapActor(TenantCache* const& tenantCache) 
															#line 1111 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
		 : Actor<Void>(),
		   MonitorTenantMapActorState<MonitorTenantMapActor>(tenantCache),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("monitorTenantMap", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11309718560506457856UL, 13240064496480253440UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorTenantMapActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("monitorTenantMap");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("monitorTenantMap", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MonitorTenantMapActor, 0, std::vector<std::pair<int64_t, TenantMapEntry>> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< MonitorTenantMapActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< MonitorTenantMapActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 76 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
[[nodiscard]] static Future<Void> monitorTenantMap( TenantCache* const& tenantCache ) {
															#line 76 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
	return Future<Void>(new MonitorTenantMapActor(tenantCache));
															#line 1145 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
}

#line 124 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"

																#line 1150 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
// This generated class is to be used only via monitorStorageUsage()
															#line 125 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
template <class MonitorStorageUsageActor>
															#line 125 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
class MonitorStorageUsageActorState {
															#line 1156 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
public:
															#line 125 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
	MonitorStorageUsageActorState(TenantCache* const& tenantCache) 
															#line 125 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
															#line 125 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		 : tenantCache(tenantCache)
															#line 1163 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
	{
		fdb_probe_actor_create("monitorStorageUsage", reinterpret_cast<unsigned long>(this));

	}
	~MonitorStorageUsageActorState() 
	{
		fdb_probe_actor_destroy("monitorStorageUsage", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 126 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
			TraceEvent(SevInfo, "StorageQuotaMonitorUsageStarting", tenantCache->id());
															#line 128 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
			refreshInterval = SERVER_KNOBS->TENANT_CACHE_STORAGE_USAGE_REFRESH_INTERVAL;
															#line 129 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
			lastTraceTime = 0;
															#line 131 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
			;
															#line 1184 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MonitorStorageUsageActorState();
		static_cast<MonitorStorageUsageActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 132 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		currentFetchStartTime = now();
															#line 134 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		toTrace = false;
															#line 135 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		if (currentFetchStartTime - lastTraceTime > SERVER_KNOBS->TENANT_CACHE_STORAGE_USAGE_TRACE_INTERVAL)
															#line 1218 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
		{
															#line 136 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
			toTrace = true;
															#line 137 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
			lastTraceTime = currentFetchStartTime;
															#line 1224 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
		}
															#line 140 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		groups = std::vector<TenantGroupName>();
															#line 141 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		for( const auto& [group, storage] : tenantCache->tenantStorageMap ) {
															#line 142 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
			groups.push_back(group);
															#line 1232 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
		}
															#line 145 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		if (groups.empty())
															#line 1236 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
		{
															#line 146 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(refreshInterval);
															#line 146 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
			if (static_cast<MonitorStorageUsageActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1242 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<MonitorStorageUsageActor*>(this)->actor_wait_state = 1;
															#line 146 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MonitorStorageUsageActor, 0, Void >*>(static_cast<MonitorStorageUsageActor*>(this)));
															#line 1247 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 149 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		i = int();
															#line 150 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		i = 0;
															#line 1263 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MonitorStorageUsageActor*>(this)->actor_wait_state > 0) static_cast<MonitorStorageUsageActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorStorageUsageActor*>(this)->ActorCallback< MonitorStorageUsageActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorStorageUsageActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorStorageUsage", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageUsageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorStorageUsage", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MonitorStorageUsageActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorStorageUsage", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageUsageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorStorageUsage", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MonitorStorageUsageActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorStorageUsage", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageUsageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorStorageUsage", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont5(int loopDepth) 
	{
															#line 195 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		if (now() - currentFetchStartTime > (2 * refreshInterval))
															#line 1359 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
		{
															#line 196 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
			TraceEvent(SevWarn, "StorageQuotaUsageRefreshSlow", tenantCache->id()) .detail("RefreshTime", now() - currentFetchStartTime);
															#line 1363 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1(int loopDepth) 
	{
															#line 150 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		if (!(i < groups.size()))
															#line 1380 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
		{
			return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 155 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		delayTime = (currentFetchStartTime + refreshInterval - now()) / (groups.size() - i);
															#line 156 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		delayTimer = delay(std::max(delayTime, 0.0));
															#line 158 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		group = groups[i];
															#line 159 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		usage = 0;
															#line 162 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		tenants = tenantCache->tenantStorageMap[group].tenants;
															#line 163 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		iter = tenants.begin();
															#line 164 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		;
															#line 1398 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont1(int loopDepth) 
	{
															#line 183 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		tenantCache->tenantStorageMap[group].usage = usage;
															#line 185 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		if (toTrace)
															#line 1422 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
		{
															#line 187 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
			TraceEvent(SevInfo, "StorageQuotaUsageUpdated", tenantCache->id()) .detail("TenantGroup", group) .detail("Quota", tenantCache->tenantStorageMap[group].quota) .detail("Usage", tenantCache->tenantStorageMap[group].usage);
															#line 1426 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
		}
															#line 192 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		StrictFuture<Void> __when_expr_3 = delayTimer;
															#line 192 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		if (static_cast<MonitorStorageUsageActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 1432 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1cont1when1(__when_expr_3.get(), loopDepth); };
		static_cast<MonitorStorageUsageActor*>(this)->actor_wait_state = 4;
															#line 192 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< MonitorStorageUsageActor, 3, Void >*>(static_cast<MonitorStorageUsageActor*>(this)));
															#line 1437 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody1(int loopDepth) 
	{
															#line 164 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		if (!(iter != tenants.end()))
															#line 1453 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
		{
			return a_body1loopBody1cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 165 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		tenantId = *iter;
															#line 166 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		tr = ReadYourWritesTransaction(tenantCache->dbcx(), makeReference<Tenant>(tenantId));
															#line 167 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		;
															#line 1463 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1loopBody1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody1cont1(int loopDepth) 
	{
															#line 164 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		iter++;
															#line 1485 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1cont1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont1loopBody1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody1loopBody1(int loopDepth) 
	{
		try {
															#line 169 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
			StrictFuture<int64_t> __when_expr_1 = tr.getEstimatedRangeSizeBytes(normalKeys);
															#line 169 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
			if (static_cast<MonitorStorageUsageActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1504 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1cont1loopBody1loopBody1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1loopBody1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<MonitorStorageUsageActor*>(this)->actor_wait_state = 2;
															#line 169 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MonitorStorageUsageActor, 1, int64_t >*>(static_cast<MonitorStorageUsageActor*>(this)));
															#line 1509 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1loopBody1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1loopBody1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1loopBody1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 3));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 3));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont1loopBody1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 173 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
			if (e.code() == error_code_tenant_not_found)
															#line 1544 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
			{
															#line 174 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
				tenantCache->tenantStorageMap[group].tenants.erase(tenantId);
															#line 1548 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
				return a_body1loopBody1cont1loopBody1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
			}
			else
			{
															#line 177 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
				TraceEvent("StorageQuotaGetUsageError", tenantCache->id()).error(e);
															#line 178 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
				StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 178 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
				if (static_cast<MonitorStorageUsageActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 4));
															#line 1559 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
				if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 4)); else return a_body1loopBody1cont1loopBody1loopBody1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
				static_cast<MonitorStorageUsageActor*>(this)->actor_wait_state = 3;
															#line 178 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
				__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MonitorStorageUsageActor, 2, Void >*>(static_cast<MonitorStorageUsageActor*>(this)));
															#line 1564 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 4));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 4));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody1loopBody1cont2(int loopDepth) 
	{
															#line 170 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		usage += size;
															#line 1580 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
		return a_body1loopBody1cont1loopBody1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody1loopBody1when1(int64_t const& __size,int loopDepth) 
	{
															#line 169 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		size = __size;
															#line 1589 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1loopBody1loopBody1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody1loopBody1when1(int64_t && __size,int loopDepth) 
	{
		size = std::move(__size);
		loopDepth = a_body1loopBody1cont1loopBody1loopBody1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<MonitorStorageUsageActor*>(this)->actor_wait_state > 0) static_cast<MonitorStorageUsageActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorStorageUsageActor*>(this)->ActorCallback< MonitorStorageUsageActor, 1, int64_t >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorStorageUsageActor, 1, int64_t >*,int64_t const& value) 
	{
		fdb_probe_actor_enter("monitorStorageUsage", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageUsageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorStorageUsage", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MonitorStorageUsageActor, 1, int64_t >*,int64_t && value) 
	{
		fdb_probe_actor_enter("monitorStorageUsage", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageUsageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorStorageUsage", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< MonitorStorageUsageActor, 1, int64_t >*,Error err) 
	{
		fdb_probe_actor_enter("monitorStorageUsage", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageUsageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorStorageUsage", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont1loopBody1loopBody1loopBody1Catch1cont1(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody1loopBody1Catch1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1loopBody1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody1loopBody1Catch1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1loopBody1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1loopBody1loopBody1Catch1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1loopBody1loopBody1Catch1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<MonitorStorageUsageActor*>(this)->actor_wait_state > 0) static_cast<MonitorStorageUsageActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorStorageUsageActor*>(this)->ActorCallback< MonitorStorageUsageActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorStorageUsageActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorStorageUsage", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageUsageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1loopBody1loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorStorageUsage", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< MonitorStorageUsageActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorStorageUsage", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageUsageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1loopBody1loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorStorageUsage", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< MonitorStorageUsageActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorStorageUsage", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageUsageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorStorageUsage", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 150 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		i++;
															#line 1761 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 150 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		i++;
															#line 1770 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<MonitorStorageUsageActor*>(this)->actor_wait_state > 0) static_cast<MonitorStorageUsageActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorStorageUsageActor*>(this)->ActorCallback< MonitorStorageUsageActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorStorageUsageActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorStorageUsage", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageUsageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorStorageUsage", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< MonitorStorageUsageActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorStorageUsage", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageUsageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorStorageUsage", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< MonitorStorageUsageActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorStorageUsage", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageUsageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorStorageUsage", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 125 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
	TenantCache* tenantCache;
															#line 128 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
	int refreshInterval;
															#line 129 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
	double lastTraceTime;
															#line 132 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
	double currentFetchStartTime;
															#line 134 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
	bool toTrace;
															#line 140 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
	std::vector<TenantGroupName> groups;
															#line 149 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
	int i;
															#line 155 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
	double delayTime;
															#line 156 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
	Future<Void> delayTimer;
															#line 158 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
	TenantGroupName group;
															#line 159 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
	int64_t usage;
															#line 162 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
	std::unordered_set<int64_t> tenants;
															#line 163 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
	std::unordered_set<int64_t>::iterator iter;
															#line 165 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
	int64_t tenantId;
															#line 166 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
	ReadYourWritesTransaction tr;
															#line 169 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
	int64_t size;
															#line 1882 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
};
// This generated class is to be used only via monitorStorageUsage()
															#line 125 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
class MonitorStorageUsageActor final : public Actor<Void>, public ActorCallback< MonitorStorageUsageActor, 0, Void >, public ActorCallback< MonitorStorageUsageActor, 1, int64_t >, public ActorCallback< MonitorStorageUsageActor, 2, Void >, public ActorCallback< MonitorStorageUsageActor, 3, Void >, public FastAllocated<MonitorStorageUsageActor>, public MonitorStorageUsageActorState<MonitorStorageUsageActor> {
															#line 1887 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
public:
	using FastAllocated<MonitorStorageUsageActor>::operator new;
	using FastAllocated<MonitorStorageUsageActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8000642695897266432UL, 12184144976450892544UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MonitorStorageUsageActor, 0, Void >;
friend struct ActorCallback< MonitorStorageUsageActor, 1, int64_t >;
friend struct ActorCallback< MonitorStorageUsageActor, 2, Void >;
friend struct ActorCallback< MonitorStorageUsageActor, 3, Void >;
															#line 125 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
	MonitorStorageUsageActor(TenantCache* const& tenantCache) 
															#line 1907 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
		 : Actor<Void>(),
		   MonitorStorageUsageActorState<MonitorStorageUsageActor>(tenantCache),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("monitorStorageUsage", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5098599803641453056UL, 17988650215389540096UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageUsageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("monitorStorageUsage");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("monitorStorageUsage", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MonitorStorageUsageActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< MonitorStorageUsageActor, 1, int64_t >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< MonitorStorageUsageActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< MonitorStorageUsageActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 125 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
[[nodiscard]] static Future<Void> monitorStorageUsage( TenantCache* const& tenantCache ) {
															#line 125 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
	return Future<Void>(new MonitorStorageUsageActor(tenantCache));
															#line 1942 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
}

#line 201 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"

																#line 1947 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
// This generated class is to be used only via monitorStorageQuota()
															#line 202 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
template <class MonitorStorageQuotaActor>
															#line 202 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
class MonitorStorageQuotaActorState {
															#line 1953 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
public:
															#line 202 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
	MonitorStorageQuotaActorState(TenantCache* const& tenantCache) 
															#line 202 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
															#line 202 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		 : tenantCache(tenantCache)
															#line 1960 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
	{
		fdb_probe_actor_create("monitorStorageQuota", reinterpret_cast<unsigned long>(this));

	}
	~MonitorStorageQuotaActorState() 
	{
		fdb_probe_actor_destroy("monitorStorageQuota", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 203 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
			TraceEvent(SevInfo, "StorageQuotaMonitorQuotaStarting", tenantCache->id());
															#line 205 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
			tr = tenantCache->dbcx()->createTransaction();
															#line 207 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
			;
															#line 1979 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MonitorStorageQuotaActorState();
		static_cast<MonitorStorageQuotaActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 209 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
			tr->setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 210 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
			StrictFuture<KeyBackedRangeResult<std::pair<TenantGroupName, int64_t>>> __when_expr_0 = TenantMetadata::storageQuota().getRange(tr, {}, {}, CLIENT_KNOBS->MAX_TENANTS_PER_CLUSTER);
															#line 210 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
			if (static_cast<MonitorStorageQuotaActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2014 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<MonitorStorageQuotaActor*>(this)->actor_wait_state = 1;
															#line 210 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MonitorStorageQuotaActor, 0, KeyBackedRangeResult<std::pair<TenantGroupName, int64_t>> >*>(static_cast<MonitorStorageQuotaActor*>(this)));
															#line 2019 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 223 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
			TraceEvent("StorageQuotaGetQuotaError", tenantCache->id()).error(e);
															#line 224 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr->onError(e);
															#line 224 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
			if (static_cast<MonitorStorageQuotaActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2045 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<MonitorStorageQuotaActor*>(this)->actor_wait_state = 3;
															#line 224 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MonitorStorageQuotaActor, 2, Void >*>(static_cast<MonitorStorageQuotaActor*>(this)));
															#line 2050 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 214 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		for( auto& [group, storage] : tenantCache->tenantStorageMap ) {
															#line 215 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
			storage.quota = std::numeric_limits<int64_t>::max();
															#line 2067 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
		}
															#line 217 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		for( const auto& [groupName, quota] : currentQuotas.results ) {
															#line 218 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
			tenantCache->tenantStorageMap[groupName].quota = quota;
															#line 2073 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
		}
															#line 220 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		tr->reset();
															#line 221 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(SERVER_KNOBS->TENANT_CACHE_STORAGE_QUOTA_REFRESH_INTERVAL);
															#line 221 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		if (static_cast<MonitorStorageQuotaActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2081 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<MonitorStorageQuotaActor*>(this)->actor_wait_state = 2;
															#line 221 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MonitorStorageQuotaActor, 1, Void >*>(static_cast<MonitorStorageQuotaActor*>(this)));
															#line 2086 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(KeyBackedRangeResult<std::pair<TenantGroupName, int64_t>> const& __currentQuotas,int loopDepth) 
	{
															#line 210 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		currentQuotas = __currentQuotas;
															#line 2095 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(KeyBackedRangeResult<std::pair<TenantGroupName, int64_t>> && __currentQuotas,int loopDepth) 
	{
		currentQuotas = std::move(__currentQuotas);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MonitorStorageQuotaActor*>(this)->actor_wait_state > 0) static_cast<MonitorStorageQuotaActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorStorageQuotaActor*>(this)->ActorCallback< MonitorStorageQuotaActor, 0, KeyBackedRangeResult<std::pair<TenantGroupName, int64_t>> >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorStorageQuotaActor, 0, KeyBackedRangeResult<std::pair<TenantGroupName, int64_t>> >*,KeyBackedRangeResult<std::pair<TenantGroupName, int64_t>> const& value) 
	{
		fdb_probe_actor_enter("monitorStorageQuota", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageQuotaActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorStorageQuota", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MonitorStorageQuotaActor, 0, KeyBackedRangeResult<std::pair<TenantGroupName, int64_t>> >*,KeyBackedRangeResult<std::pair<TenantGroupName, int64_t>> && value) 
	{
		fdb_probe_actor_enter("monitorStorageQuota", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageQuotaActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorStorageQuota", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MonitorStorageQuotaActor, 0, KeyBackedRangeResult<std::pair<TenantGroupName, int64_t>> >*,Error err) 
	{
		fdb_probe_actor_enter("monitorStorageQuota", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageQuotaActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorStorageQuota", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<MonitorStorageQuotaActor*>(this)->actor_wait_state > 0) static_cast<MonitorStorageQuotaActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorStorageQuotaActor*>(this)->ActorCallback< MonitorStorageQuotaActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorStorageQuotaActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorStorageQuota", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageQuotaActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorStorageQuota", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MonitorStorageQuotaActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorStorageQuota", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageQuotaActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorStorageQuota", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< MonitorStorageQuotaActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorStorageQuota", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageQuotaActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorStorageQuota", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont6(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<MonitorStorageQuotaActor*>(this)->actor_wait_state > 0) static_cast<MonitorStorageQuotaActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorStorageQuotaActor*>(this)->ActorCallback< MonitorStorageQuotaActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorStorageQuotaActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorStorageQuota", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageQuotaActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorStorageQuota", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< MonitorStorageQuotaActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorStorageQuota", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageQuotaActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorStorageQuota", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< MonitorStorageQuotaActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorStorageQuota", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageQuotaActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorStorageQuota", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 202 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
	TenantCache* tenantCache;
															#line 205 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 210 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
	KeyBackedRangeResult<std::pair<TenantGroupName, int64_t>> currentQuotas;
															#line 2363 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
};
// This generated class is to be used only via monitorStorageQuota()
															#line 202 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
class MonitorStorageQuotaActor final : public Actor<Void>, public ActorCallback< MonitorStorageQuotaActor, 0, KeyBackedRangeResult<std::pair<TenantGroupName, int64_t>> >, public ActorCallback< MonitorStorageQuotaActor, 1, Void >, public ActorCallback< MonitorStorageQuotaActor, 2, Void >, public FastAllocated<MonitorStorageQuotaActor>, public MonitorStorageQuotaActorState<MonitorStorageQuotaActor> {
															#line 2368 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
public:
	using FastAllocated<MonitorStorageQuotaActor>::operator new;
	using FastAllocated<MonitorStorageQuotaActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5362629028889077504UL, 1853600069488015872UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MonitorStorageQuotaActor, 0, KeyBackedRangeResult<std::pair<TenantGroupName, int64_t>> >;
friend struct ActorCallback< MonitorStorageQuotaActor, 1, Void >;
friend struct ActorCallback< MonitorStorageQuotaActor, 2, Void >;
															#line 202 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
	MonitorStorageQuotaActor(TenantCache* const& tenantCache) 
															#line 2387 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
		 : Actor<Void>(),
		   MonitorStorageQuotaActorState<MonitorStorageQuotaActor>(tenantCache),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("monitorStorageQuota", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15214553883737319680UL, 17518665595637246464UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageQuotaActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("monitorStorageQuota");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("monitorStorageQuota", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MonitorStorageQuotaActor, 0, KeyBackedRangeResult<std::pair<TenantGroupName, int64_t>> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< MonitorStorageQuotaActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< MonitorStorageQuotaActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 202 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
[[nodiscard]] static Future<Void> monitorStorageQuota( TenantCache* const& tenantCache ) {
															#line 202 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
	return Future<Void>(new MonitorStorageQuotaActor(tenantCache));
															#line 2421 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
}

#line 228 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
};

void TenantCache::insert(TenantMapEntry& tenant) {
	ASSERT(tenantCache.find(tenant.prefix) == tenantCache.end());

	TenantInfo tenantInfo(tenant.id, Optional<WipedString>());
	tenantCache[tenantInfo.prefix.get()] = makeReference<TCTenantInfo>(tenantInfo);
	tenantCache[tenantInfo.prefix.get()]->updateCacheGeneration(generation);

	if (tenant.tenantGroup.present()) {
		tenantStorageMap[tenant.tenantGroup.get()].tenants.insert(tenant.id);
	}
}

void TenantCache::startRefresh() {
	ASSERT(generation < std::numeric_limits<uint64_t>::max());
	generation++;
}

void TenantCache::keep(TenantMapEntry& tenant) {
	ASSERT(tenantCache.find(tenant.prefix) != tenantCache.end());
	tenantCache[tenant.prefix]->updateCacheGeneration(generation);
}

bool TenantCache::update(TenantMapEntry& tenant) {
	if (tenantCache.find(tenant.prefix) != tenantCache.end()) {
		keep(tenant);
		return false;
	}

	insert(tenant);
	return true;
}

int TenantCache::cleanup() {
	int tenantsRemoved = 0;
	std::vector<Key> keysToErase;

	for (auto& t : tenantCache) {
		ASSERT(t.value->cacheGeneration() <= generation);
		if (t.value->cacheGeneration() != generation) {
			keysToErase.push_back(t.key);
		}
	}

	for (auto& k : keysToErase) {
		tenantCache.erase(k);
		tenantsRemoved++;
	}

	return tenantsRemoved;
}

std::vector<int64_t> TenantCache::getTenantList() const {
	std::vector<int64_t> tenants;
	for (const auto& [prefix, entry] : tenantCache) {
		tenants.push_back(entry->id());
	}
	return tenants;
}

std::string TenantCache::desc() const {
	std::string s("@Generation: ");
	s += std::to_string(generation) + " ";
	int count = 0;
	for (auto& [tenantPrefix, tenant] : tenantCache) {
		if (count) {
			s += ", ";
		}

		s += "ID: " + std::to_string(tenant->id()) + " Prefix: " + tenantPrefix.toString();
		count++;
	}

	return s;
}

bool TenantCache::isTenantKey(KeyRef key) const {
	auto it = tenantCache.lastLessOrEqual(key);
	if (it == tenantCache.end()) {
		return false;
	}

	if (!key.startsWith(it->key)) {
		return false;
	}

	return true;
}

Future<Void> TenantCache::build() {
	return TenantCacheImpl::build(this);
}

Optional<Reference<TCTenantInfo>> TenantCache::tenantOwning(KeyRef key) const {
	auto it = tenantCache.lastLessOrEqual(key);
	if (it == tenantCache.end()) {
		return {};
	}

	if (!key.startsWith(it->key)) {
		return {};
	}

	return it->value;
}

std::unordered_set<int64_t> TenantCache::getTenantsOverQuota() const {
	std::unordered_set<int64_t> tenantsOverQuota;
	for (const auto& [tenantGroup, storage] : tenantStorageMap) {
		if (storage.usage > storage.quota) {
			tenantsOverQuota.insert(storage.tenants.begin(), storage.tenants.end());
		}
	}
	return tenantsOverQuota;
}

Future<Void> TenantCache::monitorTenantMap() {
	return TenantCacheImpl::monitorTenantMap(this);
}

Future<Void> TenantCache::monitorStorageUsage() {
	return TenantCacheImpl::monitorStorageUsage(this);
}

Future<Void> TenantCache::monitorStorageQuota() {
	return TenantCacheImpl::monitorStorageQuota(this);
}

class TenantCacheUnitTest {
public:
																#line 2556 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
// This generated class is to be used only via InsertAndTestPresence()
															#line 359 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
template <class InsertAndTestPresenceActor>
															#line 359 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
class InsertAndTestPresenceActorState {
															#line 2562 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
public:
															#line 359 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
	InsertAndTestPresenceActorState() 
															#line 359 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
	{
															#line 2568 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
		fdb_probe_actor_create("InsertAndTestPresence", reinterpret_cast<unsigned long>(this));

	}
	~InsertAndTestPresenceActorState() 
	{
		fdb_probe_actor_destroy("InsertAndTestPresence", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 360 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
			StrictFuture<Void> __when_expr_0 = Future<Void>(Void());
															#line 360 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
			if (static_cast<InsertAndTestPresenceActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2584 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<InsertAndTestPresenceActor*>(this)->actor_wait_state = 1;
															#line 360 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< InsertAndTestPresenceActor, 0, Void >*>(static_cast<InsertAndTestPresenceActor*>(this)));
															#line 2589 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~InsertAndTestPresenceActorState();
		static_cast<InsertAndTestPresenceActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 362 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		Database cx;
															#line 363 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		TenantCache tenantCache(cx, UID(1, 0));
															#line 365 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		constexpr static uint16_t tenantLimit = 64;
															#line 367 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		uint16_t tenantCount = deterministicRandom()->randomInt(1, tenantLimit);
															#line 368 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		uint16_t tenantNumber = deterministicRandom()->randomInt(0, std::numeric_limits<uint16_t>::max());
															#line 370 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		for(uint16_t i = 0;i < tenantCount;i++) {
															#line 371 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
			TenantName tenantName(format("%s_%08d", "ddtc_test_tenant", tenantNumber + i));
															#line 372 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
			TenantMapEntry tenant(tenantNumber + i, tenantName);
															#line 374 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
			tenantCache.insert(tenant);
															#line 2628 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
		}
															#line 377 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		for(int i = 0;i < tenantLimit;i++) {
															#line 378 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
			Key k(format("%d", i));
															#line 379 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
			ASSERT(tenantCache.isTenantKey(k.withPrefix(TenantAPI::idToPrefix(tenantNumber + (i % tenantCount)))));
															#line 380 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
			ASSERT(!tenantCache.isTenantKey(k.withPrefix(allKeys.begin)));
															#line 381 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
			ASSERT(!tenantCache.isTenantKey(k));
															#line 2640 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
		}
															#line 384 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		if (!static_cast<InsertAndTestPresenceActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~InsertAndTestPresenceActorState(); static_cast<InsertAndTestPresenceActor*>(this)->destroy(); return 0; }
															#line 2644 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
		new (&static_cast<InsertAndTestPresenceActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~InsertAndTestPresenceActorState();
		static_cast<InsertAndTestPresenceActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 362 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		Database cx;
															#line 363 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		TenantCache tenantCache(cx, UID(1, 0));
															#line 365 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		constexpr static uint16_t tenantLimit = 64;
															#line 367 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		uint16_t tenantCount = deterministicRandom()->randomInt(1, tenantLimit);
															#line 368 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		uint16_t tenantNumber = deterministicRandom()->randomInt(0, std::numeric_limits<uint16_t>::max());
															#line 370 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		for(uint16_t i = 0;i < tenantCount;i++) {
															#line 371 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
			TenantName tenantName(format("%s_%08d", "ddtc_test_tenant", tenantNumber + i));
															#line 372 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
			TenantMapEntry tenant(tenantNumber + i, tenantName);
															#line 374 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
			tenantCache.insert(tenant);
															#line 2672 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
		}
															#line 377 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		for(int i = 0;i < tenantLimit;i++) {
															#line 378 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
			Key k(format("%d", i));
															#line 379 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
			ASSERT(tenantCache.isTenantKey(k.withPrefix(TenantAPI::idToPrefix(tenantNumber + (i % tenantCount)))));
															#line 380 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
			ASSERT(!tenantCache.isTenantKey(k.withPrefix(allKeys.begin)));
															#line 381 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
			ASSERT(!tenantCache.isTenantKey(k));
															#line 2684 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
		}
															#line 384 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		if (!static_cast<InsertAndTestPresenceActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~InsertAndTestPresenceActorState(); static_cast<InsertAndTestPresenceActor*>(this)->destroy(); return 0; }
															#line 2688 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
		new (&static_cast<InsertAndTestPresenceActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~InsertAndTestPresenceActorState();
		static_cast<InsertAndTestPresenceActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<InsertAndTestPresenceActor*>(this)->actor_wait_state > 0) static_cast<InsertAndTestPresenceActor*>(this)->actor_wait_state = 0;
		static_cast<InsertAndTestPresenceActor*>(this)->ActorCallback< InsertAndTestPresenceActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< InsertAndTestPresenceActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("InsertAndTestPresence", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InsertAndTestPresenceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("InsertAndTestPresence", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< InsertAndTestPresenceActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("InsertAndTestPresence", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InsertAndTestPresenceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("InsertAndTestPresence", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< InsertAndTestPresenceActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("InsertAndTestPresence", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<InsertAndTestPresenceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("InsertAndTestPresence", reinterpret_cast<unsigned long>(this), 0);

	}
};
// This generated class is to be used only via InsertAndTestPresence()
															#line 359 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
class InsertAndTestPresenceActor final : public Actor<Void>, public ActorCallback< InsertAndTestPresenceActor, 0, Void >, public FastAllocated<InsertAndTestPresenceActor>, public InsertAndTestPresenceActorState<InsertAndTestPresenceActor> {
															#line 2775 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
public:
	using FastAllocated<InsertAndTestPresenceActor>::operator new;
	using FastAllocated<InsertAndTestPresenceActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4060261861657723904UL, 15200045107393209344UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< InsertAndTestPresenceActor, 0, Void >;
															#line 359 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
	InsertAndTestPresenceActor() 
															#line 2792 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
		 : Actor<Void>(),
		   InsertAndTestPresenceActorState<InsertAndTestPresenceActor>(),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("InsertAndTestPresence", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15576235747455273216UL, 16054016863638268160UL);
		ActorExecutionContextHelper __helper(static_cast<InsertAndTestPresenceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("InsertAndTestPresence");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("InsertAndTestPresence", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< InsertAndTestPresenceActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 359 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
[[nodiscard]] static Future<Void> InsertAndTestPresence(  ) {
															#line 359 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
	return Future<Void>(new InsertAndTestPresenceActor());
															#line 2824 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
}

#line 386 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"

																#line 2829 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
// This generated class is to be used only via RefreshAndTestPresence()
															#line 387 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
template <class RefreshAndTestPresenceActor>
															#line 387 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
class RefreshAndTestPresenceActorState {
															#line 2835 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
public:
															#line 387 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
	RefreshAndTestPresenceActorState() 
															#line 387 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
	{
															#line 2841 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
		fdb_probe_actor_create("RefreshAndTestPresence", reinterpret_cast<unsigned long>(this));

	}
	~RefreshAndTestPresenceActorState() 
	{
		fdb_probe_actor_destroy("RefreshAndTestPresence", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 388 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
			StrictFuture<Void> __when_expr_0 = Future<Void>(Void());
															#line 388 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
			if (static_cast<RefreshAndTestPresenceActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2857 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RefreshAndTestPresenceActor*>(this)->actor_wait_state = 1;
															#line 388 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RefreshAndTestPresenceActor, 0, Void >*>(static_cast<RefreshAndTestPresenceActor*>(this)));
															#line 2862 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RefreshAndTestPresenceActorState();
		static_cast<RefreshAndTestPresenceActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 390 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		Database cx;
															#line 391 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		TenantCache tenantCache(cx, UID(1, 0));
															#line 393 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		constexpr static uint16_t tenantLimit = 64;
															#line 395 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		uint16_t tenantCount = deterministicRandom()->randomInt(1, tenantLimit);
															#line 396 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		uint16_t tenantNumber = deterministicRandom()->randomInt(0, std::numeric_limits<uint16_t>::max());
															#line 398 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		for(uint16_t i = 0;i < tenantCount;i++) {
															#line 399 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
			uint16_t tenantOrdinal = tenantNumber + i;
															#line 400 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
			TenantName tenantName(format("%s_%08d", "ddtc_test_tenant", tenantOrdinal));
															#line 401 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
			TenantMapEntry tenant(tenantOrdinal, tenantName);
															#line 403 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
			tenantCache.insert(tenant);
															#line 2903 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
		}
															#line 406 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		uint16_t staleTenantFraction = deterministicRandom()->randomInt(1, 8);
															#line 407 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		tenantCache.startRefresh();
															#line 409 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		int keepCount = 0, removeCount = 0;
															#line 410 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		for(int i = 0;i < tenantCount;i++) {
															#line 411 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
			uint16_t tenantOrdinal = tenantNumber + i;
															#line 413 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
			if (tenantOrdinal % staleTenantFraction != 0)
															#line 2917 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
			{
															#line 414 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
				TenantName tenantName(format("%s_%08d", "ddtc_test_tenant", tenantOrdinal));
															#line 415 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
				TenantMapEntry tenant(tenantOrdinal, tenantName);
															#line 416 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
				bool newTenant = tenantCache.update(tenant);
															#line 417 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
				ASSERT(!newTenant);
															#line 418 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
				keepCount++;
															#line 2929 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
			}
			else
			{
															#line 420 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
				removeCount++;
															#line 2935 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
			}
		}
															#line 423 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		int tenantsRemoved = tenantCache.cleanup();
															#line 424 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		ASSERT(tenantsRemoved == removeCount);
															#line 426 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		int keptCount = 0, removedCount = 0;
															#line 427 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		for(int i = 0;i < tenantCount;i++) {
															#line 428 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
			uint16_t tenantOrdinal = tenantNumber + i;
															#line 429 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
			Key k(format("%d", i));
															#line 430 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
			if (tenantOrdinal % staleTenantFraction != 0)
															#line 2952 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
			{
															#line 431 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
				ASSERT(tenantCache.isTenantKey(k.withPrefix(TenantAPI::idToPrefix(tenantOrdinal))));
															#line 432 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
				keptCount++;
															#line 2958 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
			}
			else
			{
															#line 434 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
				ASSERT(!tenantCache.isTenantKey(k.withPrefix(TenantAPI::idToPrefix(tenantOrdinal))));
															#line 435 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
				removedCount++;
															#line 2966 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
			}
		}
															#line 439 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		ASSERT(keepCount == keptCount);
															#line 440 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		ASSERT(removeCount == removedCount);
															#line 442 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		if (!static_cast<RefreshAndTestPresenceActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RefreshAndTestPresenceActorState(); static_cast<RefreshAndTestPresenceActor*>(this)->destroy(); return 0; }
															#line 2975 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
		new (&static_cast<RefreshAndTestPresenceActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RefreshAndTestPresenceActorState();
		static_cast<RefreshAndTestPresenceActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 390 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		Database cx;
															#line 391 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		TenantCache tenantCache(cx, UID(1, 0));
															#line 393 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		constexpr static uint16_t tenantLimit = 64;
															#line 395 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		uint16_t tenantCount = deterministicRandom()->randomInt(1, tenantLimit);
															#line 396 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		uint16_t tenantNumber = deterministicRandom()->randomInt(0, std::numeric_limits<uint16_t>::max());
															#line 398 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		for(uint16_t i = 0;i < tenantCount;i++) {
															#line 399 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
			uint16_t tenantOrdinal = tenantNumber + i;
															#line 400 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
			TenantName tenantName(format("%s_%08d", "ddtc_test_tenant", tenantOrdinal));
															#line 401 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
			TenantMapEntry tenant(tenantOrdinal, tenantName);
															#line 403 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
			tenantCache.insert(tenant);
															#line 3005 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
		}
															#line 406 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		uint16_t staleTenantFraction = deterministicRandom()->randomInt(1, 8);
															#line 407 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		tenantCache.startRefresh();
															#line 409 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		int keepCount = 0, removeCount = 0;
															#line 410 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		for(int i = 0;i < tenantCount;i++) {
															#line 411 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
			uint16_t tenantOrdinal = tenantNumber + i;
															#line 413 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
			if (tenantOrdinal % staleTenantFraction != 0)
															#line 3019 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
			{
															#line 414 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
				TenantName tenantName(format("%s_%08d", "ddtc_test_tenant", tenantOrdinal));
															#line 415 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
				TenantMapEntry tenant(tenantOrdinal, tenantName);
															#line 416 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
				bool newTenant = tenantCache.update(tenant);
															#line 417 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
				ASSERT(!newTenant);
															#line 418 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
				keepCount++;
															#line 3031 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
			}
			else
			{
															#line 420 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
				removeCount++;
															#line 3037 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
			}
		}
															#line 423 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		int tenantsRemoved = tenantCache.cleanup();
															#line 424 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		ASSERT(tenantsRemoved == removeCount);
															#line 426 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		int keptCount = 0, removedCount = 0;
															#line 427 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		for(int i = 0;i < tenantCount;i++) {
															#line 428 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
			uint16_t tenantOrdinal = tenantNumber + i;
															#line 429 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
			Key k(format("%d", i));
															#line 430 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
			if (tenantOrdinal % staleTenantFraction != 0)
															#line 3054 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
			{
															#line 431 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
				ASSERT(tenantCache.isTenantKey(k.withPrefix(TenantAPI::idToPrefix(tenantOrdinal))));
															#line 432 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
				keptCount++;
															#line 3060 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
			}
			else
			{
															#line 434 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
				ASSERT(!tenantCache.isTenantKey(k.withPrefix(TenantAPI::idToPrefix(tenantOrdinal))));
															#line 435 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
				removedCount++;
															#line 3068 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
			}
		}
															#line 439 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		ASSERT(keepCount == keptCount);
															#line 440 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		ASSERT(removeCount == removedCount);
															#line 442 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		if (!static_cast<RefreshAndTestPresenceActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RefreshAndTestPresenceActorState(); static_cast<RefreshAndTestPresenceActor*>(this)->destroy(); return 0; }
															#line 3077 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
		new (&static_cast<RefreshAndTestPresenceActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RefreshAndTestPresenceActorState();
		static_cast<RefreshAndTestPresenceActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RefreshAndTestPresenceActor*>(this)->actor_wait_state > 0) static_cast<RefreshAndTestPresenceActor*>(this)->actor_wait_state = 0;
		static_cast<RefreshAndTestPresenceActor*>(this)->ActorCallback< RefreshAndTestPresenceActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RefreshAndTestPresenceActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("RefreshAndTestPresence", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RefreshAndTestPresenceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("RefreshAndTestPresence", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RefreshAndTestPresenceActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("RefreshAndTestPresence", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RefreshAndTestPresenceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("RefreshAndTestPresence", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RefreshAndTestPresenceActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("RefreshAndTestPresence", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RefreshAndTestPresenceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("RefreshAndTestPresence", reinterpret_cast<unsigned long>(this), 0);

	}
};
// This generated class is to be used only via RefreshAndTestPresence()
															#line 387 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
class RefreshAndTestPresenceActor final : public Actor<Void>, public ActorCallback< RefreshAndTestPresenceActor, 0, Void >, public FastAllocated<RefreshAndTestPresenceActor>, public RefreshAndTestPresenceActorState<RefreshAndTestPresenceActor> {
															#line 3164 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
public:
	using FastAllocated<RefreshAndTestPresenceActor>::operator new;
	using FastAllocated<RefreshAndTestPresenceActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7550543788874659072UL, 2424246011461740032UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RefreshAndTestPresenceActor, 0, Void >;
															#line 387 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
	RefreshAndTestPresenceActor() 
															#line 3181 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
		 : Actor<Void>(),
		   RefreshAndTestPresenceActorState<RefreshAndTestPresenceActor>(),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("RefreshAndTestPresence", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11292424308358826496UL, 17157789825290380032UL);
		ActorExecutionContextHelper __helper(static_cast<RefreshAndTestPresenceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("RefreshAndTestPresence");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("RefreshAndTestPresence", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RefreshAndTestPresenceActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 387 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
[[nodiscard]] static Future<Void> RefreshAndTestPresence(  ) {
															#line 387 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
	return Future<Void>(new RefreshAndTestPresenceActor());
															#line 3213 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
}

#line 444 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
};

															#line 3219 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase446()
															#line 446 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
template <class FlowTestCase446Actor>
															#line 446 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
class FlowTestCase446ActorState {
															#line 3226 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
public:
															#line 446 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
	FlowTestCase446ActorState(UnitTestParameters const& params) 
															#line 446 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
															#line 446 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		 : params(params)
															#line 3233 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase446", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase446ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase446", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 447 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
			StrictFuture<Void> __when_expr_0 = TenantCacheUnitTest::InsertAndTestPresence();
															#line 447 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
			if (static_cast<FlowTestCase446Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3250 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase446Actor*>(this)->actor_wait_state = 1;
															#line 447 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase446Actor, 0, Void >*>(static_cast<FlowTestCase446Actor*>(this)));
															#line 3255 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase446ActorState();
		static_cast<FlowTestCase446Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 448 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		if (!static_cast<FlowTestCase446Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase446ActorState(); static_cast<FlowTestCase446Actor*>(this)->destroy(); return 0; }
															#line 3278 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
		new (&static_cast<FlowTestCase446Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase446ActorState();
		static_cast<FlowTestCase446Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 448 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		if (!static_cast<FlowTestCase446Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase446ActorState(); static_cast<FlowTestCase446Actor*>(this)->destroy(); return 0; }
															#line 3290 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
		new (&static_cast<FlowTestCase446Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase446ActorState();
		static_cast<FlowTestCase446Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase446Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase446Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase446Actor*>(this)->ActorCallback< FlowTestCase446Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase446Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase446", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase446Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase446", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase446Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase446", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase446Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase446", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase446Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase446", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase446Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase446", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 446 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
	UnitTestParameters params;
															#line 3375 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase446()
															#line 446 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
class FlowTestCase446Actor final : public Actor<Void>, public ActorCallback< FlowTestCase446Actor, 0, Void >, public FastAllocated<FlowTestCase446Actor>, public FlowTestCase446ActorState<FlowTestCase446Actor> {
															#line 3380 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase446Actor>::operator new;
	using FastAllocated<FlowTestCase446Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12878241447549253376UL, 18125172796910578944UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase446Actor, 0, Void >;
															#line 446 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
	FlowTestCase446Actor(UnitTestParameters const& params) 
															#line 3397 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase446ActorState<FlowTestCase446Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase446", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10817455555241227520UL, 5671982768332001792UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase446Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase446");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase446", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase446Actor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 446 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
static Future<Void> flowTestCase446( UnitTestParameters const& params ) {
															#line 446 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
	return Future<Void>(new FlowTestCase446Actor(params));
															#line 3430 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase446, "/TenantCache/InsertAndTestPresence")

#line 450 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"

															#line 3436 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase451()
															#line 451 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
template <class FlowTestCase451Actor>
															#line 451 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
class FlowTestCase451ActorState {
															#line 3443 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
public:
															#line 451 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
	FlowTestCase451ActorState(UnitTestParameters const& params) 
															#line 451 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
															#line 451 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		 : params(params)
															#line 3450 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase451", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase451ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase451", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 452 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
			StrictFuture<Void> __when_expr_0 = TenantCacheUnitTest::RefreshAndTestPresence();
															#line 452 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
			if (static_cast<FlowTestCase451Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3467 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase451Actor*>(this)->actor_wait_state = 1;
															#line 452 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase451Actor, 0, Void >*>(static_cast<FlowTestCase451Actor*>(this)));
															#line 3472 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase451ActorState();
		static_cast<FlowTestCase451Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 453 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		if (!static_cast<FlowTestCase451Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase451ActorState(); static_cast<FlowTestCase451Actor*>(this)->destroy(); return 0; }
															#line 3495 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
		new (&static_cast<FlowTestCase451Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase451ActorState();
		static_cast<FlowTestCase451Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 453 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
		if (!static_cast<FlowTestCase451Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase451ActorState(); static_cast<FlowTestCase451Actor*>(this)->destroy(); return 0; }
															#line 3507 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
		new (&static_cast<FlowTestCase451Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase451ActorState();
		static_cast<FlowTestCase451Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase451Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase451Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase451Actor*>(this)->ActorCallback< FlowTestCase451Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase451Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase451", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase451Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase451", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase451Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase451", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase451Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase451", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase451Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase451", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase451Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase451", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 451 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
	UnitTestParameters params;
															#line 3592 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase451()
															#line 451 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
class FlowTestCase451Actor final : public Actor<Void>, public ActorCallback< FlowTestCase451Actor, 0, Void >, public FastAllocated<FlowTestCase451Actor>, public FlowTestCase451ActorState<FlowTestCase451Actor> {
															#line 3597 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase451Actor>::operator new;
	using FastAllocated<FlowTestCase451Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6107632162065554688UL, 4328156939105654272UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase451Actor, 0, Void >;
															#line 451 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
	FlowTestCase451Actor(UnitTestParameters const& params) 
															#line 3614 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase451ActorState<FlowTestCase451Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase451", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6006995798443108352UL, 17524001220744579072UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase451Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase451");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase451", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase451Actor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 451 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
static Future<Void> flowTestCase451( UnitTestParameters const& params ) {
															#line 451 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
	return Future<Void>(new FlowTestCase451Actor(params));
															#line 3647 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbserver/TenantCache.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase451, "/TenantCache/RefreshAndTestPresence")

#line 455 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbserver/TenantCache.actor.cpp"
