#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
/*
 * S3Client.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <string>
#include <vector>
#include <unordered_set>
#include <algorithm>
#include <sstream>
#include <iomanip>

#ifdef _WIN32
#include <io.h>
#endif

#include "fdbclient/S3Client.actor.h"
#include "flow/IAsyncFile.h"
#include "flow/Trace.h"
#include "flow/Traceable.h"
#include "flow/flow.h"
#include "flow/xxhash.h"
#include "flow/Error.h"
#include "rapidxml/rapidxml.hpp"
#include <openssl/sha.h>
#include "libb64/encode.h"

#include "flow/actorcompiler.h" // has to be last include

// Configuration constants
#define S3_CHECKSUM_TAG_NAME "xxhash64"
#define S3_CHECKSUM_FILE_SUFFIX ".checksum"

typedef XXH64_state_t XXHashState;

using ::format; // Use FoundationDB's format, not std::format

// State for a part of a multipart upload.
struct PartState {
	int partNumber = 0;
	std::string etag;
	int64_t offset = 0;
	int64_t size = 0;
	std::string checksum; // MD5 or SHA256 depending on integrity check setting
	bool completed = false;
	std::string partData; // Part data kept for sequential XXH64 checksum calculation after upload

	PartState() = default; // Add explicit default constructor

	PartState(int pNum, int64_t off, int64_t sz, std::string checksum = "")
	  : partNumber(pNum), offset(off), size(sz), checksum(checksum) {}
};

// Config for S3 operations with configurable parameters
struct PartConfig {
	// Basic part configuration
	int64_t partSizeBytes = CLIENT_KNOBS->BLOBSTORE_MULTIPART_MIN_PART_SIZE;
	int baseRetryDelayMs = CLIENT_KNOBS->BLOBSTORE_MULTIPART_RETRY_DELAY_MS;

	// Retry configuration - now configurable instead of magic numbers
	// TODO: Add these to CLIENT_KNOBS for runtime configuration
	int maxPartRetries = 3; // Default: 3 retries per part
	int maxFileRetries = 3; // Default: 3 retries per file
	int maxRetryDelayMs = 30000; // Default: 30 second cap on retry delay

	// Checksum configuration
	// TODO: Add these to CLIENT_KNOBS for runtime configuration
	bool enableChecksumValidation = true; // Default: enable checksum validation
};

// Calculate hash of a file.
// Uses xxhash library because it's fast (supposedly) and used elsewhere in fdb.
// If size is -1, the function will determine the file size automatically.
// Returns a hex string representation of the xxhash64 checksum.
															#line 92 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
namespace {
// This generated class is to be used only via calculateFileChecksum()
															#line 90 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
template <class CalculateFileChecksumActor>
															#line 90 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
class CalculateFileChecksumActorState {
															#line 99 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
public:
															#line 90 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	CalculateFileChecksumActorState(Reference<IAsyncFile> const& file,int64_t const& size) 
															#line 90 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
															#line 90 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		 : file(file),
															#line 90 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   size(size),
															#line 91 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   pos(0),
															#line 92 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   hashState(XXH64_createState()),
															#line 93 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   buffer(65536),
															#line 94 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   readSize()
															#line 116 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
	{
		fdb_probe_actor_create("calculateFileChecksum", reinterpret_cast<unsigned long>(this));

	}
	~CalculateFileChecksumActorState() 
	{
		fdb_probe_actor_destroy("calculateFileChecksum", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 96 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			XXH64_reset(hashState, 0);
															#line 131 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			try {
															#line 99 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				if (size == -1)
															#line 135 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
				{
															#line 100 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
					StrictFuture<int64_t> __when_expr_0 = file->size();
															#line 100 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
					if (static_cast<CalculateFileChecksumActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 141 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
					if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
					static_cast<CalculateFileChecksumActor*>(this)->actor_wait_state = 1;
															#line 100 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
					__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CalculateFileChecksumActor, 0, int64_t >*>(static_cast<CalculateFileChecksumActor*>(this)));
															#line 146 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
					loopDepth = 0;
				}
				else
				{
					loopDepth = a_body1cont2(loopDepth);
				}
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CalculateFileChecksumActorState();
		static_cast<CalculateFileChecksumActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 123 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			XXH64_freeState(hashState);
															#line 124 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 183 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 104 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		;
															#line 197 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(int64_t const& s,int loopDepth) 
	{
															#line 101 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		size = s;
															#line 206 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(int64_t && s,int loopDepth) 
	{
															#line 101 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		size = s;
															#line 215 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1when1(int64_t const& s,int loopDepth) 
	{
		loopDepth = a_body1cont3(s, loopDepth);

		return loopDepth;
	}
	int a_body1when1(int64_t && s,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(s), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CalculateFileChecksumActor*>(this)->actor_wait_state > 0) static_cast<CalculateFileChecksumActor*>(this)->actor_wait_state = 0;
		static_cast<CalculateFileChecksumActor*>(this)->ActorCallback< CalculateFileChecksumActor, 0, int64_t >::remove();

	}
	void a_callback_fire(ActorCallback< CalculateFileChecksumActor, 0, int64_t >*,int64_t const& value) 
	{
		fdb_probe_actor_enter("calculateFileChecksum", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CalculateFileChecksumActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("calculateFileChecksum", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CalculateFileChecksumActor, 0, int64_t >*,int64_t && value) 
	{
		fdb_probe_actor_enter("calculateFileChecksum", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CalculateFileChecksumActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("calculateFileChecksum", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CalculateFileChecksumActor, 0, int64_t >*,Error err) 
	{
		fdb_probe_actor_enter("calculateFileChecksum", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CalculateFileChecksumActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("calculateFileChecksum", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont5(int loopDepth) 
	{
															#line 119 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		uint64_t hash = XXH64_digest(hashState);
															#line 120 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		XXH64_freeState(hashState);
															#line 121 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!static_cast<CalculateFileChecksumActor*>(this)->SAV<std::string>::futures) { (void)(format("%016llx", hash)); this->~CalculateFileChecksumActorState(); static_cast<CalculateFileChecksumActor*>(this)->destroy(); return 0; }
															#line 303 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		new (&static_cast<CalculateFileChecksumActor*>(this)->SAV< std::string >::value()) std::string(format("%016llx", hash));
		this->~CalculateFileChecksumActorState();
		static_cast<CalculateFileChecksumActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1(int loopDepth) 
	{
															#line 104 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!(pos < size))
															#line 322 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
			return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 105 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		readSize = std::min<int64_t>(buffer.size(), size - pos);
															#line 106 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<int> __when_expr_1 = file->read(buffer.data(), readSize, pos);
															#line 106 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<CalculateFileChecksumActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 332 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CalculateFileChecksumActor*>(this)->actor_wait_state = 2;
															#line 106 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CalculateFileChecksumActor, 1, int >*>(static_cast<CalculateFileChecksumActor*>(this)));
															#line 337 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2break1(int loopDepth) 
	{
		try {
			return a_body1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(int const& bytesRead,int loopDepth) 
	{
															#line 107 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (bytesRead != readSize)
															#line 359 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
															#line 108 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			XXH64_freeState(hashState);
															#line 109 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(SevError, "S3ClientCalculateChecksumReadError") .detail("Expected", readSize) .detail("Actual", bytesRead) .detail("Position", pos);
															#line 113 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			return a_body1Catch2(io_error(), std::max(0, loopDepth - 1));
															#line 367 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		}
															#line 115 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		XXH64_update(hashState, buffer.data(), bytesRead);
															#line 116 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		pos += bytesRead;
															#line 373 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(int && bytesRead,int loopDepth) 
	{
															#line 107 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (bytesRead != readSize)
															#line 382 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
															#line 108 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			XXH64_freeState(hashState);
															#line 109 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(SevError, "S3ClientCalculateChecksumReadError") .detail("Expected", readSize) .detail("Actual", bytesRead) .detail("Position", pos);
															#line 113 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			return a_body1Catch2(io_error(), std::max(0, loopDepth - 1));
															#line 390 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		}
															#line 115 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		XXH64_update(hashState, buffer.data(), bytesRead);
															#line 116 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		pos += bytesRead;
															#line 396 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(int const& bytesRead,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(bytesRead, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(int && bytesRead,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(std::move(bytesRead), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CalculateFileChecksumActor*>(this)->actor_wait_state > 0) static_cast<CalculateFileChecksumActor*>(this)->actor_wait_state = 0;
		static_cast<CalculateFileChecksumActor*>(this)->ActorCallback< CalculateFileChecksumActor, 1, int >::remove();

	}
	void a_callback_fire(ActorCallback< CalculateFileChecksumActor, 1, int >*,int const& value) 
	{
		fdb_probe_actor_enter("calculateFileChecksum", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CalculateFileChecksumActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("calculateFileChecksum", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CalculateFileChecksumActor, 1, int >*,int && value) 
	{
		fdb_probe_actor_enter("calculateFileChecksum", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CalculateFileChecksumActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("calculateFileChecksum", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CalculateFileChecksumActor, 1, int >*,Error err) 
	{
		fdb_probe_actor_enter("calculateFileChecksum", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CalculateFileChecksumActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("calculateFileChecksum", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 90 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	Reference<IAsyncFile> file;
															#line 90 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	int64_t size;
															#line 91 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	int64_t pos;
															#line 92 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	XXH64_state_t* hashState;
															#line 93 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::vector<uint8_t> buffer;
															#line 94 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	int readSize;
															#line 488 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
};
// This generated class is to be used only via calculateFileChecksum()
															#line 90 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
class CalculateFileChecksumActor final : public Actor<std::string>, public ActorCallback< CalculateFileChecksumActor, 0, int64_t >, public ActorCallback< CalculateFileChecksumActor, 1, int >, public FastAllocated<CalculateFileChecksumActor>, public CalculateFileChecksumActorState<CalculateFileChecksumActor> {
															#line 493 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
public:
	using FastAllocated<CalculateFileChecksumActor>::operator new;
	using FastAllocated<CalculateFileChecksumActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5495996159267793152UL, 2307555730081612800UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::string>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CalculateFileChecksumActor, 0, int64_t >;
friend struct ActorCallback< CalculateFileChecksumActor, 1, int >;
															#line 90 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	CalculateFileChecksumActor(Reference<IAsyncFile> const& file,int64_t const& size) 
															#line 511 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		 : Actor<std::string>(),
		   CalculateFileChecksumActorState<CalculateFileChecksumActor>(file, size),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("calculateFileChecksum", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12128180428655768320UL, 2149007350426683136UL);
		ActorExecutionContextHelper __helper(static_cast<CalculateFileChecksumActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("calculateFileChecksum");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("calculateFileChecksum", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CalculateFileChecksumActor, 0, int64_t >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CalculateFileChecksumActor, 1, int >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 90 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
[[nodiscard]] Future<std::string> calculateFileChecksum( Reference<IAsyncFile> const& file, int64_t const& size ) {
															#line 90 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	return Future<std::string>(new CalculateFileChecksumActor(file, size));
															#line 545 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
}

#line 127 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"

// Get the endpoint for the given s3url.
// Populates parameters and resource with parse of s3url.
Reference<S3BlobStoreEndpoint> getEndpoint(const std::string& s3url,
                                           std::string& resource,
                                           S3BlobStoreEndpoint::ParametersT& parameters) {
	try {
		std::string error;
		Optional<std::string> proxy;
		auto res = g_network->global(INetwork::enProxy);
		if (res) {
			proxy = *static_cast<Optional<std::string>*>(res);
		}
		Reference<S3BlobStoreEndpoint> endpoint =
		    S3BlobStoreEndpoint::fromString(s3url, proxy, &resource, &error, &parameters);

		if (!endpoint) {
			TraceEvent(SevError, "S3ClientGetEndpointNullEndpoint").detail("URL", s3url).detail("Error", error);
			throw backup_invalid_url();
		}

		// Let empty resource path be valid - it means list root of bucket

		// Validate bucket parameter exists
		if (parameters.find("bucket") == parameters.end()) {
			TraceEvent(SevError, "S3ClientGetEndpointMissingBucket").detail("URL", s3url).detail("Error", error);
			throw backup_invalid_url();
		}

		// Validate resource path characters
		for (char c : resource) {
			if (!isalnum(c) && c != '_' && c != '-' && c != '.' && c != '/') {
				TraceEvent(SevError, "S3ClientGetEndpointIllegalCharacter")
				    .detail("URL", s3url)
				    .detail("Character", std::string(1, c))
				    .detail("Error", error);
				throw backup_invalid_url();
			}
		}

		if (!error.empty()) {
			TraceEvent(SevError, "S3ClientGetEndpointError").detail("URL", s3url).detail("Error", error);
			throw backup_invalid_url();
		}

		return endpoint;

	} catch (Error& e) {
		TraceEvent(SevError, "S3ClientGetEndpointFailed").detail("URL", StringRef(s3url)).detail("Error", e.what());
		throw;
	}
}

// Helper function to determine if an error is retryable
bool isRetryableError(int errorCode) {
	return errorCode == error_code_http_bad_response || errorCode == error_code_connection_failed ||
	       errorCode == error_code_lookup_failed || errorCode == error_code_http_request_failed ||
	       errorCode == error_code_io_error || errorCode == error_code_platform_error;
}

// Write checksum with configurable fallback strategy
															#line 610 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
namespace {
// This generated class is to be used only via writeChecksumWithFallback()
															#line 188 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
template <class WriteChecksumWithFallbackActor>
															#line 188 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
class WriteChecksumWithFallbackActorState {
															#line 617 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
public:
															#line 188 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	WriteChecksumWithFallbackActorState(Reference<S3BlobStoreEndpoint> const& endpoint,std::string const& bucket,std::string const& objectName,std::string const& checksum,PartConfig const& config) 
															#line 188 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
															#line 188 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		 : endpoint(endpoint),
															#line 188 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   bucket(bucket),
															#line 188 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   objectName(objectName),
															#line 188 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   checksum(checksum),
															#line 188 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   config(config)
															#line 632 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
	{
		fdb_probe_actor_create("writeChecksumWithFallback", reinterpret_cast<unsigned long>(this));

	}
	~WriteChecksumWithFallbackActorState() 
	{
		fdb_probe_actor_destroy("writeChecksumWithFallback", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 193 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (!config.enableChecksumValidation)
															#line 647 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			{
															#line 194 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				TraceEvent(SevWarn, "S3ClientChecksumValidationDisabled") .suppressFor(60) .detail("Bucket", bucket) .detail("Object", objectName);
															#line 198 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				if (!static_cast<WriteChecksumWithFallbackActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WriteChecksumWithFallbackActorState(); static_cast<WriteChecksumWithFallbackActor*>(this)->destroy(); return 0; }
															#line 653 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
				new (&static_cast<WriteChecksumWithFallbackActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~WriteChecksumWithFallbackActorState();
				static_cast<WriteChecksumWithFallbackActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			try {
															#line 203 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				tags = std::map<std::string, std::string>();
															#line 204 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				tags[S3_CHECKSUM_TAG_NAME] = checksum;
															#line 205 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				StrictFuture<Void> __when_expr_0 = endpoint->putObjectTags(bucket, objectName, tags);
															#line 205 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				if (static_cast<WriteChecksumWithFallbackActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 668 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<WriteChecksumWithFallbackActor*>(this)->actor_wait_state = 1;
															#line 205 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WriteChecksumWithFallbackActor, 0, Void >*>(static_cast<WriteChecksumWithFallbackActor*>(this)));
															#line 673 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WriteChecksumWithFallbackActorState();
		static_cast<WriteChecksumWithFallbackActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 222 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<Void> __when_expr_1 = endpoint->writeEntireFile(bucket, objectName + S3_CHECKSUM_FILE_SUFFIX, checksum);
															#line 222 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<WriteChecksumWithFallbackActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 704 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<WriteChecksumWithFallbackActor*>(this)->actor_wait_state = 2;
															#line 222 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WriteChecksumWithFallbackActor, 1, Void >*>(static_cast<WriteChecksumWithFallbackActor*>(this)));
															#line 709 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 212 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (e.code() != error_code_http_bad_response && e.code() != error_code_file_not_found)
															#line 719 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			{
															#line 213 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 723 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			}
															#line 215 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(s3VerboseEventSev(), "S3ClientTaggingFallback") .detail("Bucket", bucket) .detail("Object", objectName) .detail("Reason", "Tagging not supported, using companion file");
															#line 727 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 206 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		TraceEvent(SevDebug, "S3ClientChecksumStoredAsTags") .detail("Bucket", bucket) .detail("Object", objectName) .detail("Checksum", checksum);
															#line 210 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!static_cast<WriteChecksumWithFallbackActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WriteChecksumWithFallbackActorState(); static_cast<WriteChecksumWithFallbackActor*>(this)->destroy(); return 0; }
															#line 744 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		new (&static_cast<WriteChecksumWithFallbackActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WriteChecksumWithFallbackActorState();
		static_cast<WriteChecksumWithFallbackActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 206 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		TraceEvent(SevDebug, "S3ClientChecksumStoredAsTags") .detail("Bucket", bucket) .detail("Object", objectName) .detail("Checksum", checksum);
															#line 210 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!static_cast<WriteChecksumWithFallbackActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WriteChecksumWithFallbackActorState(); static_cast<WriteChecksumWithFallbackActor*>(this)->destroy(); return 0; }
															#line 758 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		new (&static_cast<WriteChecksumWithFallbackActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WriteChecksumWithFallbackActorState();
		static_cast<WriteChecksumWithFallbackActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WriteChecksumWithFallbackActor*>(this)->actor_wait_state > 0) static_cast<WriteChecksumWithFallbackActor*>(this)->actor_wait_state = 0;
		static_cast<WriteChecksumWithFallbackActor*>(this)->ActorCallback< WriteChecksumWithFallbackActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteChecksumWithFallbackActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeChecksumWithFallback", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteChecksumWithFallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeChecksumWithFallback", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WriteChecksumWithFallbackActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeChecksumWithFallback", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteChecksumWithFallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeChecksumWithFallback", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WriteChecksumWithFallbackActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeChecksumWithFallback", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteChecksumWithFallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeChecksumWithFallback", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 223 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		TraceEvent(SevDebug, "S3ClientChecksumStoredAsFile") .detail("Bucket", bucket) .detail("Object", objectName) .detail("ChecksumFile", objectName + S3_CHECKSUM_FILE_SUFFIX) .detail("Checksum", checksum);
															#line 228 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!static_cast<WriteChecksumWithFallbackActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WriteChecksumWithFallbackActorState(); static_cast<WriteChecksumWithFallbackActor*>(this)->destroy(); return 0; }
															#line 847 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		new (&static_cast<WriteChecksumWithFallbackActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WriteChecksumWithFallbackActorState();
		static_cast<WriteChecksumWithFallbackActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 223 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		TraceEvent(SevDebug, "S3ClientChecksumStoredAsFile") .detail("Bucket", bucket) .detail("Object", objectName) .detail("ChecksumFile", objectName + S3_CHECKSUM_FILE_SUFFIX) .detail("Checksum", checksum);
															#line 228 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!static_cast<WriteChecksumWithFallbackActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WriteChecksumWithFallbackActorState(); static_cast<WriteChecksumWithFallbackActor*>(this)->destroy(); return 0; }
															#line 861 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		new (&static_cast<WriteChecksumWithFallbackActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WriteChecksumWithFallbackActorState();
		static_cast<WriteChecksumWithFallbackActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WriteChecksumWithFallbackActor*>(this)->actor_wait_state > 0) static_cast<WriteChecksumWithFallbackActor*>(this)->actor_wait_state = 0;
		static_cast<WriteChecksumWithFallbackActor*>(this)->ActorCallback< WriteChecksumWithFallbackActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteChecksumWithFallbackActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeChecksumWithFallback", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteChecksumWithFallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeChecksumWithFallback", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WriteChecksumWithFallbackActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeChecksumWithFallback", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteChecksumWithFallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeChecksumWithFallback", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WriteChecksumWithFallbackActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeChecksumWithFallback", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteChecksumWithFallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeChecksumWithFallback", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 188 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	Reference<S3BlobStoreEndpoint> endpoint;
															#line 188 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string bucket;
															#line 188 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string objectName;
															#line 188 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string checksum;
															#line 188 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	PartConfig config;
															#line 203 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::map<std::string, std::string> tags;
															#line 956 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
};
// This generated class is to be used only via writeChecksumWithFallback()
															#line 188 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
class WriteChecksumWithFallbackActor final : public Actor<Void>, public ActorCallback< WriteChecksumWithFallbackActor, 0, Void >, public ActorCallback< WriteChecksumWithFallbackActor, 1, Void >, public FastAllocated<WriteChecksumWithFallbackActor>, public WriteChecksumWithFallbackActorState<WriteChecksumWithFallbackActor> {
															#line 961 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
public:
	using FastAllocated<WriteChecksumWithFallbackActor>::operator new;
	using FastAllocated<WriteChecksumWithFallbackActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15192697708197451008UL, 6197780211816215552UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WriteChecksumWithFallbackActor, 0, Void >;
friend struct ActorCallback< WriteChecksumWithFallbackActor, 1, Void >;
															#line 188 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	WriteChecksumWithFallbackActor(Reference<S3BlobStoreEndpoint> const& endpoint,std::string const& bucket,std::string const& objectName,std::string const& checksum,PartConfig const& config) 
															#line 979 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		 : Actor<Void>(),
		   WriteChecksumWithFallbackActorState<WriteChecksumWithFallbackActor>(endpoint, bucket, objectName, checksum, config),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("writeChecksumWithFallback", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18335821694256988416UL, 390065426227613696UL);
		ActorExecutionContextHelper __helper(static_cast<WriteChecksumWithFallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("writeChecksumWithFallback");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("writeChecksumWithFallback", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WriteChecksumWithFallbackActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WriteChecksumWithFallbackActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 188 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
[[nodiscard]] static Future<Void> writeChecksumWithFallback( Reference<S3BlobStoreEndpoint> const& endpoint, std::string const& bucket, std::string const& objectName, std::string const& checksum, PartConfig const& config ) {
															#line 188 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	return Future<Void>(new WriteChecksumWithFallbackActor(endpoint, bucket, objectName, checksum, config));
															#line 1013 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
}

#line 230 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"

// Read checksum with configurable fallback strategy
															#line 1019 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
namespace {
// This generated class is to be used only via readChecksumWithFallback()
															#line 232 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
template <class ReadChecksumWithFallbackActor>
															#line 232 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
class ReadChecksumWithFallbackActorState {
															#line 1026 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
public:
															#line 232 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	ReadChecksumWithFallbackActorState(Reference<S3BlobStoreEndpoint> const& endpoint,std::string const& bucket,std::string const& objectName,PartConfig const& config) 
															#line 232 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
															#line 232 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		 : endpoint(endpoint),
															#line 232 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   bucket(bucket),
															#line 232 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   objectName(objectName),
															#line 232 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   config(config)
															#line 1039 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
	{
		fdb_probe_actor_create("readChecksumWithFallback", reinterpret_cast<unsigned long>(this));

	}
	~ReadChecksumWithFallbackActorState() 
	{
		fdb_probe_actor_destroy("readChecksumWithFallback", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 236 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (!config.enableChecksumValidation)
															#line 1054 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			{
															#line 237 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				TraceEvent(SevDebug, "S3ClientChecksumValidationDisabled") .detail("Bucket", bucket) .detail("Object", objectName);
															#line 240 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				if (!static_cast<ReadChecksumWithFallbackActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(Optional<std::string>()); this->~ReadChecksumWithFallbackActorState(); static_cast<ReadChecksumWithFallbackActor*>(this)->destroy(); return 0; }
															#line 1060 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
				new (&static_cast<ReadChecksumWithFallbackActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(Optional<std::string>());
				this->~ReadChecksumWithFallbackActorState();
				static_cast<ReadChecksumWithFallbackActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			try {
															#line 245 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				StrictFuture<std::map<std::string, std::string>> __when_expr_0 = endpoint->getObjectTags(bucket, objectName);
															#line 245 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				if (static_cast<ReadChecksumWithFallbackActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 1071 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<ReadChecksumWithFallbackActor*>(this)->actor_wait_state = 1;
															#line 245 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ReadChecksumWithFallbackActor, 0, std::map<std::string, std::string> >*>(static_cast<ReadChecksumWithFallbackActor*>(this)));
															#line 1076 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ReadChecksumWithFallbackActorState();
		static_cast<ReadChecksumWithFallbackActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
		try {
															#line 266 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			StrictFuture<std::string> __when_expr_1 = endpoint->readEntireFile(bucket, objectName + S3_CHECKSUM_FILE_SUFFIX);
															#line 266 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (static_cast<ReadChecksumWithFallbackActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 1108 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<ReadChecksumWithFallbackActor*>(this)->actor_wait_state = 2;
															#line 266 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ReadChecksumWithFallbackActor, 1, std::string >*>(static_cast<ReadChecksumWithFallbackActor*>(this)));
															#line 1113 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 255 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (e.code() != error_code_http_bad_response && e.code() != error_code_file_not_found)
															#line 1129 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			{
															#line 256 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 1133 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			}
															#line 258 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(s3VerboseEventSev(), "S3ClientTagsNotAvailable") .detail("Bucket", bucket) .detail("Object", objectName) .detail("FallingBackToFile", "true");
															#line 1137 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3(int loopDepth) 
	{
															#line 246 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		auto it = tags.find(S3_CHECKSUM_TAG_NAME);
															#line 247 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (it != tags.end() && !it->second.empty())
															#line 1154 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
															#line 248 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(SevDebug, "S3ClientChecksumFoundInTags") .detail("Bucket", bucket) .detail("Object", objectName) .detail("Checksum", it->second);
															#line 252 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (!static_cast<ReadChecksumWithFallbackActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(Optional<std::string>(it->second)); this->~ReadChecksumWithFallbackActorState(); static_cast<ReadChecksumWithFallbackActor*>(this)->destroy(); return 0; }
															#line 1160 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			new (&static_cast<ReadChecksumWithFallbackActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(Optional<std::string>(it->second));
			this->~ReadChecksumWithFallbackActorState();
			static_cast<ReadChecksumWithFallbackActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::map<std::string, std::string> const& __tags,int loopDepth) 
	{
															#line 245 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		tags = __tags;
															#line 1174 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::map<std::string, std::string> && __tags,int loopDepth) 
	{
		tags = std::move(__tags);
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ReadChecksumWithFallbackActor*>(this)->actor_wait_state > 0) static_cast<ReadChecksumWithFallbackActor*>(this)->actor_wait_state = 0;
		static_cast<ReadChecksumWithFallbackActor*>(this)->ActorCallback< ReadChecksumWithFallbackActor, 0, std::map<std::string, std::string> >::remove();

	}
	void a_callback_fire(ActorCallback< ReadChecksumWithFallbackActor, 0, std::map<std::string, std::string> >*,std::map<std::string, std::string> const& value) 
	{
		fdb_probe_actor_enter("readChecksumWithFallback", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadChecksumWithFallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readChecksumWithFallback", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ReadChecksumWithFallbackActor, 0, std::map<std::string, std::string> >*,std::map<std::string, std::string> && value) 
	{
		fdb_probe_actor_enter("readChecksumWithFallback", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadChecksumWithFallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readChecksumWithFallback", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ReadChecksumWithFallbackActor, 0, std::map<std::string, std::string> >*,Error err) 
	{
		fdb_probe_actor_enter("readChecksumWithFallback", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadChecksumWithFallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readChecksumWithFallback", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont6(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont7(int loopDepth) 
	{
															#line 279 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		TraceEvent(SevDebug, "S3ClientNoChecksumFound") .detail("Bucket", bucket) .detail("Object", objectName) .detail("ChecksumValidationEnabled", config.enableChecksumValidation ? "true" : "false");
															#line 283 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!static_cast<ReadChecksumWithFallbackActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(Optional<std::string>()); this->~ReadChecksumWithFallbackActorState(); static_cast<ReadChecksumWithFallbackActor*>(this)->destroy(); return 0; }
															#line 1268 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		new (&static_cast<ReadChecksumWithFallbackActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(Optional<std::string>());
		this->~ReadChecksumWithFallbackActorState();
		static_cast<ReadChecksumWithFallbackActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 274 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (e.code() != error_code_file_not_found)
															#line 1281 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			{
															#line 275 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 1285 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			}
			loopDepth = a_body1cont7(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont8(std::string const& checksum,int loopDepth) 
	{
															#line 267 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		TraceEvent(SevDebug, "S3ClientChecksumFoundInFile") .detail("Bucket", bucket) .detail("Object", objectName) .detail("ChecksumFile", objectName + S3_CHECKSUM_FILE_SUFFIX) .detail("Checksum", checksum);
															#line 272 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!static_cast<ReadChecksumWithFallbackActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(Optional<std::string>(checksum)); this->~ReadChecksumWithFallbackActorState(); static_cast<ReadChecksumWithFallbackActor*>(this)->destroy(); return 0; }
															#line 1303 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		new (&static_cast<ReadChecksumWithFallbackActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(Optional<std::string>(checksum));
		this->~ReadChecksumWithFallbackActorState();
		static_cast<ReadChecksumWithFallbackActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont8(std::string && checksum,int loopDepth) 
	{
															#line 267 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		TraceEvent(SevDebug, "S3ClientChecksumFoundInFile") .detail("Bucket", bucket) .detail("Object", objectName) .detail("ChecksumFile", objectName + S3_CHECKSUM_FILE_SUFFIX) .detail("Checksum", checksum);
															#line 272 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!static_cast<ReadChecksumWithFallbackActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(Optional<std::string>(checksum)); this->~ReadChecksumWithFallbackActorState(); static_cast<ReadChecksumWithFallbackActor*>(this)->destroy(); return 0; }
															#line 1317 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		new (&static_cast<ReadChecksumWithFallbackActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(Optional<std::string>(checksum));
		this->~ReadChecksumWithFallbackActorState();
		static_cast<ReadChecksumWithFallbackActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(std::string const& checksum,int loopDepth) 
	{
		loopDepth = a_body1cont8(checksum, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(std::string && checksum,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(checksum), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ReadChecksumWithFallbackActor*>(this)->actor_wait_state > 0) static_cast<ReadChecksumWithFallbackActor*>(this)->actor_wait_state = 0;
		static_cast<ReadChecksumWithFallbackActor*>(this)->ActorCallback< ReadChecksumWithFallbackActor, 1, std::string >::remove();

	}
	void a_callback_fire(ActorCallback< ReadChecksumWithFallbackActor, 1, std::string >*,std::string const& value) 
	{
		fdb_probe_actor_enter("readChecksumWithFallback", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadChecksumWithFallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readChecksumWithFallback", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ReadChecksumWithFallbackActor, 1, std::string >*,std::string && value) 
	{
		fdb_probe_actor_enter("readChecksumWithFallback", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadChecksumWithFallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readChecksumWithFallback", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ReadChecksumWithFallbackActor, 1, std::string >*,Error err) 
	{
		fdb_probe_actor_enter("readChecksumWithFallback", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadChecksumWithFallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readChecksumWithFallback", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 232 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	Reference<S3BlobStoreEndpoint> endpoint;
															#line 232 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string bucket;
															#line 232 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string objectName;
															#line 232 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	PartConfig config;
															#line 245 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::map<std::string, std::string> tags;
															#line 1410 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
};
// This generated class is to be used only via readChecksumWithFallback()
															#line 232 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
class ReadChecksumWithFallbackActor final : public Actor<Optional<std::string>>, public ActorCallback< ReadChecksumWithFallbackActor, 0, std::map<std::string, std::string> >, public ActorCallback< ReadChecksumWithFallbackActor, 1, std::string >, public FastAllocated<ReadChecksumWithFallbackActor>, public ReadChecksumWithFallbackActorState<ReadChecksumWithFallbackActor> {
															#line 1415 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
public:
	using FastAllocated<ReadChecksumWithFallbackActor>::operator new;
	using FastAllocated<ReadChecksumWithFallbackActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3769279112877598208UL, 18070066671229874176UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Optional<std::string>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ReadChecksumWithFallbackActor, 0, std::map<std::string, std::string> >;
friend struct ActorCallback< ReadChecksumWithFallbackActor, 1, std::string >;
															#line 232 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	ReadChecksumWithFallbackActor(Reference<S3BlobStoreEndpoint> const& endpoint,std::string const& bucket,std::string const& objectName,PartConfig const& config) 
															#line 1433 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		 : Actor<Optional<std::string>>(),
		   ReadChecksumWithFallbackActorState<ReadChecksumWithFallbackActor>(endpoint, bucket, objectName, config),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("readChecksumWithFallback", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5279133990643063552UL, 16030994525704471296UL);
		ActorExecutionContextHelper __helper(static_cast<ReadChecksumWithFallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("readChecksumWithFallback");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("readChecksumWithFallback", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ReadChecksumWithFallbackActor, 0, std::map<std::string, std::string> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ReadChecksumWithFallbackActor, 1, std::string >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 232 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
[[nodiscard]] static Future<Optional<std::string>> readChecksumWithFallback( Reference<S3BlobStoreEndpoint> const& endpoint, std::string const& bucket, std::string const& objectName, PartConfig const& config ) {
															#line 232 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	return Future<Optional<std::string>>(new ReadChecksumWithFallbackActor(endpoint, bucket, objectName, config));
															#line 1467 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
}

#line 285 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"

// Upload a part of a multipart upload with configurable retry logic.

															#line 1474 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
namespace {
// This generated class is to be used only via uploadPart()
															#line 288 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
template <class UploadPartActor>
															#line 288 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
class UploadPartActorState {
															#line 1481 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
public:
															#line 288 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	UploadPartActorState(Reference<S3BlobStoreEndpoint> const& endpoint,std::string const& bucket,std::string const& objectName,std::string const& uploadID,Reference<IAsyncFile> const& file,PartState const& part,PartConfig const& config) 
															#line 288 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
															#line 288 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		 : endpoint(endpoint),
															#line 288 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   bucket(bucket),
															#line 288 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   objectName(objectName),
															#line 288 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   uploadID(uploadID),
															#line 288 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   file(file),
															#line 288 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   part(part),
															#line 288 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   config(config),
															#line 295 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   startTime(now()),
															#line 296 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   resultPart(part),
															#line 297 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   attempt(0),
															#line 298 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   maxRetries(config.maxPartRetries),
															#line 299 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   delayMs(config.baseRetryDelayMs),
															#line 300 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   packets()
															#line 1512 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
	{
		fdb_probe_actor_create("uploadPart", reinterpret_cast<unsigned long>(this));

	}
	~UploadPartActorState() 
	{
		fdb_probe_actor_destroy("uploadPart", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 302 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(SevDebug, "S3ClientUploadPartStart") .detail("Bucket", StringRef(bucket)) .detail("Object", StringRef(objectName)) .detail("PartNumber", part.partNumber) .detail("Offset", resultPart.offset) .detail("Size", resultPart.size) .detail("MaxRetries", maxRetries);
															#line 310 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			;
															#line 1529 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~UploadPartActorState();
		static_cast<UploadPartActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 313 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			partData = std::string();
															#line 314 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			partData.resize(resultPart.size);
															#line 316 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			StrictFuture<int> __when_expr_0 = file->read(&partData[0], resultPart.size, resultPart.offset);
															#line 316 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (static_cast<UploadPartActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1566 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<UploadPartActor*>(this)->actor_wait_state = 1;
															#line 316 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< UploadPartActor, 0, int >*>(static_cast<UploadPartActor*>(this)));
															#line 1571 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 377 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			attempt++;
															#line 378 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (attempt >= maxRetries || !isRetryableError(e.code()))
															#line 1595 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			{
															#line 379 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				TraceEvent(SevWarnAlways, "S3ClientUploadPartFailed") .detail("Bucket", StringRef(bucket)) .detail("Object", StringRef(objectName)) .detail("PartNumber", part.partNumber) .detail("ErrorCode", e.code()) .detail("Attempts", attempt) .detail("MaxRetries", maxRetries) .detail("FinalError", e.what());
															#line 387 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 1601 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			}
															#line 390 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(SevDebug, "S3ClientUploadPartRetry") .detail("Bucket", StringRef(bucket)) .detail("Object", StringRef(objectName)) .detail("PartNumber", part.partNumber) .detail("Attempt", attempt) .detail("Error", e.what()) .detail("DelayMs", delayMs);
															#line 398 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			StrictFuture<Void> __when_expr_2 = delay(delayMs / 1000.0);
															#line 398 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (static_cast<UploadPartActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1609 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<UploadPartActor*>(this)->actor_wait_state = 3;
															#line 398 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< UploadPartActor, 2, Void >*>(static_cast<UploadPartActor*>(this)));
															#line 1614 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int const& bytesRead,int loopDepth) 
	{
															#line 317 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (bytesRead != resultPart.size)
															#line 1629 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
															#line 318 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(SevError, "S3ClientUploadPartReadError") .detail("Expected", resultPart.size) .detail("Actual", bytesRead) .detail("Offset", resultPart.offset);
															#line 322 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			return a_body1loopBody1Catch1(io_error(), loopDepth);
															#line 1635 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		}
															#line 328 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		resultPart.partData = std::move(partData);
															#line 331 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		std::string checksum;
															#line 332 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (CLIENT_KNOBS->BLOBSTORE_ENABLE_OBJECT_INTEGRITY_CHECK)
															#line 1643 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
															#line 334 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			unsigned char hash[SHA256_DIGEST_LENGTH];
															#line 335 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			SHA256_CTX sha256;
															#line 336 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			SHA256_Init(&sha256);
															#line 337 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			SHA256_Update(&sha256, resultPart.partData.data(), resultPart.partData.size());
															#line 338 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			SHA256_Final(hash, &sha256);
															#line 339 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			std::string hashAsStr = std::string((char*)hash, SHA256_DIGEST_LENGTH);
															#line 340 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			std::string sig = base64::encoder::from_string(hashAsStr);
															#line 342 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			sig.resize(sig.size() - 1);
															#line 343 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			checksum = sig;
															#line 1663 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		}
		else
		{
															#line 346 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			checksum = HTTP::computeMD5Sum(resultPart.partData);
															#line 1669 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		}
															#line 350 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		resultPart.checksum = checksum;
															#line 353 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		packets.discardAll();
															#line 354 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		PacketWriter pw(packets.getWriteBuffer(resultPart.partData.size()), nullptr, Unversioned());
															#line 355 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		pw.serializeBytes(resultPart.partData);
															#line 357 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<std::string> __when_expr_1 = endpoint->uploadPart(bucket, objectName, uploadID, resultPart.partNumber, &packets, resultPart.partData.size(), resultPart.checksum);
															#line 357 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<UploadPartActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1683 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<UploadPartActor*>(this)->actor_wait_state = 2;
															#line 357 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< UploadPartActor, 1, std::string >*>(static_cast<UploadPartActor*>(this)));
															#line 1688 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(int && bytesRead,int loopDepth) 
	{
															#line 317 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (bytesRead != resultPart.size)
															#line 1697 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
															#line 318 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(SevError, "S3ClientUploadPartReadError") .detail("Expected", resultPart.size) .detail("Actual", bytesRead) .detail("Offset", resultPart.offset);
															#line 322 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			return a_body1loopBody1Catch1(io_error(), loopDepth);
															#line 1703 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		}
															#line 328 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		resultPart.partData = std::move(partData);
															#line 331 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		std::string checksum;
															#line 332 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (CLIENT_KNOBS->BLOBSTORE_ENABLE_OBJECT_INTEGRITY_CHECK)
															#line 1711 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
															#line 334 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			unsigned char hash[SHA256_DIGEST_LENGTH];
															#line 335 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			SHA256_CTX sha256;
															#line 336 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			SHA256_Init(&sha256);
															#line 337 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			SHA256_Update(&sha256, resultPart.partData.data(), resultPart.partData.size());
															#line 338 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			SHA256_Final(hash, &sha256);
															#line 339 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			std::string hashAsStr = std::string((char*)hash, SHA256_DIGEST_LENGTH);
															#line 340 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			std::string sig = base64::encoder::from_string(hashAsStr);
															#line 342 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			sig.resize(sig.size() - 1);
															#line 343 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			checksum = sig;
															#line 1731 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		}
		else
		{
															#line 346 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			checksum = HTTP::computeMD5Sum(resultPart.partData);
															#line 1737 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		}
															#line 350 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		resultPart.checksum = checksum;
															#line 353 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		packets.discardAll();
															#line 354 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		PacketWriter pw(packets.getWriteBuffer(resultPart.partData.size()), nullptr, Unversioned());
															#line 355 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		pw.serializeBytes(resultPart.partData);
															#line 357 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<std::string> __when_expr_1 = endpoint->uploadPart(bucket, objectName, uploadID, resultPart.partNumber, &packets, resultPart.partData.size(), resultPart.checksum);
															#line 357 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<UploadPartActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1751 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<UploadPartActor*>(this)->actor_wait_state = 2;
															#line 357 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< UploadPartActor, 1, std::string >*>(static_cast<UploadPartActor*>(this)));
															#line 1756 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(int const& bytesRead,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(bytesRead, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(int && bytesRead,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(bytesRead), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UploadPartActor*>(this)->actor_wait_state > 0) static_cast<UploadPartActor*>(this)->actor_wait_state = 0;
		static_cast<UploadPartActor*>(this)->ActorCallback< UploadPartActor, 0, int >::remove();

	}
	void a_callback_fire(ActorCallback< UploadPartActor, 0, int >*,int const& value) 
	{
		fdb_probe_actor_enter("uploadPart", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UploadPartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("uploadPart", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UploadPartActor, 0, int >*,int && value) 
	{
		fdb_probe_actor_enter("uploadPart", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UploadPartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("uploadPart", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< UploadPartActor, 0, int >*,Error err) 
	{
		fdb_probe_actor_enter("uploadPart", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UploadPartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("uploadPart", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(std::string const& etag,int loopDepth) 
	{
															#line 365 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		resultPart.etag = etag;
															#line 366 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		resultPart.completed = true;
															#line 367 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		TraceEvent(SevDebug, "S3ClientUploadPartEnd") .detail("Bucket", StringRef(bucket)) .detail("Object", StringRef(objectName)) .detail("PartNumber", part.partNumber) .detail("Offset", resultPart.offset) .detail("Duration", now() - startTime) .detail("Size", resultPart.size) .detail("Attempts", attempt + 1);
															#line 375 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!static_cast<UploadPartActor*>(this)->SAV<PartState>::futures) { (void)(resultPart); this->~UploadPartActorState(); static_cast<UploadPartActor*>(this)->destroy(); return 0; }
															#line 1846 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		new (&static_cast<UploadPartActor*>(this)->SAV< PartState >::value()) PartState(std::move(resultPart)); // state_var_RVO
		this->~UploadPartActorState();
		static_cast<UploadPartActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(std::string && etag,int loopDepth) 
	{
															#line 365 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		resultPart.etag = etag;
															#line 366 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		resultPart.completed = true;
															#line 367 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		TraceEvent(SevDebug, "S3ClientUploadPartEnd") .detail("Bucket", StringRef(bucket)) .detail("Object", StringRef(objectName)) .detail("PartNumber", part.partNumber) .detail("Offset", resultPart.offset) .detail("Duration", now() - startTime) .detail("Size", resultPart.size) .detail("Attempts", attempt + 1);
															#line 375 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!static_cast<UploadPartActor*>(this)->SAV<PartState>::futures) { (void)(resultPart); this->~UploadPartActorState(); static_cast<UploadPartActor*>(this)->destroy(); return 0; }
															#line 1864 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		new (&static_cast<UploadPartActor*>(this)->SAV< PartState >::value()) PartState(std::move(resultPart)); // state_var_RVO
		this->~UploadPartActorState();
		static_cast<UploadPartActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(std::string const& etag,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(etag, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(std::string && etag,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(etag), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<UploadPartActor*>(this)->actor_wait_state > 0) static_cast<UploadPartActor*>(this)->actor_wait_state = 0;
		static_cast<UploadPartActor*>(this)->ActorCallback< UploadPartActor, 1, std::string >::remove();

	}
	void a_callback_fire(ActorCallback< UploadPartActor, 1, std::string >*,std::string const& value) 
	{
		fdb_probe_actor_enter("uploadPart", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UploadPartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("uploadPart", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< UploadPartActor, 1, std::string >*,std::string && value) 
	{
		fdb_probe_actor_enter("uploadPart", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UploadPartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("uploadPart", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< UploadPartActor, 1, std::string >*,Error err) 
	{
		fdb_probe_actor_enter("uploadPart", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UploadPartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("uploadPart", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
															#line 399 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		delayMs = std::min(delayMs * 2, config.maxRetryDelayMs);
															#line 1951 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
															#line 399 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		delayMs = std::min(delayMs * 2, config.maxRetryDelayMs);
															#line 1960 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<UploadPartActor*>(this)->actor_wait_state > 0) static_cast<UploadPartActor*>(this)->actor_wait_state = 0;
		static_cast<UploadPartActor*>(this)->ActorCallback< UploadPartActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UploadPartActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("uploadPart", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UploadPartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("uploadPart", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< UploadPartActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("uploadPart", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UploadPartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("uploadPart", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< UploadPartActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("uploadPart", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UploadPartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("uploadPart", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 288 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	Reference<S3BlobStoreEndpoint> endpoint;
															#line 288 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string bucket;
															#line 288 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string objectName;
															#line 288 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string uploadID;
															#line 288 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	Reference<IAsyncFile> file;
															#line 288 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	PartState part;
															#line 288 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	PartConfig config;
															#line 295 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	double startTime;
															#line 296 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	PartState resultPart;
															#line 297 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	int attempt;
															#line 298 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	int maxRetries;
															#line 299 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	int delayMs;
															#line 300 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	UnsentPacketQueue packets;
															#line 313 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string partData;
															#line 2068 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
};
// This generated class is to be used only via uploadPart()
															#line 288 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
class UploadPartActor final : public Actor<PartState>, public ActorCallback< UploadPartActor, 0, int >, public ActorCallback< UploadPartActor, 1, std::string >, public ActorCallback< UploadPartActor, 2, Void >, public FastAllocated<UploadPartActor>, public UploadPartActorState<UploadPartActor> {
															#line 2073 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
public:
	using FastAllocated<UploadPartActor>::operator new;
	using FastAllocated<UploadPartActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10748606568443356416UL, 7368413312582546944UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<PartState>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< UploadPartActor, 0, int >;
friend struct ActorCallback< UploadPartActor, 1, std::string >;
friend struct ActorCallback< UploadPartActor, 2, Void >;
															#line 288 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	UploadPartActor(Reference<S3BlobStoreEndpoint> const& endpoint,std::string const& bucket,std::string const& objectName,std::string const& uploadID,Reference<IAsyncFile> const& file,PartState const& part,PartConfig const& config) 
															#line 2092 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		 : Actor<PartState>(),
		   UploadPartActorState<UploadPartActor>(endpoint, bucket, objectName, uploadID, file, part, config),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("uploadPart", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8500122340480301312UL, 500718127134435072UL);
		ActorExecutionContextHelper __helper(static_cast<UploadPartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("uploadPart");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("uploadPart", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< UploadPartActor, 0, int >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< UploadPartActor, 1, std::string >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< UploadPartActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 288 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
[[nodiscard]] static Future<PartState> uploadPart( Reference<S3BlobStoreEndpoint> const& endpoint, std::string const& bucket, std::string const& objectName, std::string const& uploadID, Reference<IAsyncFile> const& file, PartState const& part, PartConfig const& config ) {
															#line 288 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	return Future<PartState>(new UploadPartActor(endpoint, bucket, objectName, uploadID, file, part, config));
															#line 2127 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
}

#line 403 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"

// Copy filepath to bucket at resource in s3.
															#line 2133 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
namespace {
// This generated class is to be used only via copyUpFile()
															#line 405 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
template <class CopyUpFileActor>
															#line 405 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
class CopyUpFileActorState {
															#line 2140 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
public:
															#line 405 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	CopyUpFileActorState(Reference<S3BlobStoreEndpoint> const& endpoint,std::string const& bucket,std::string const& objectName,std::string const& filepath,PartConfig const& config = PartConfig()) 
															#line 405 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
															#line 405 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		 : endpoint(endpoint),
															#line 405 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   bucket(bucket),
															#line 405 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   objectName(objectName),
															#line 405 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   filepath(filepath),
															#line 405 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   config(config),
															#line 410 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   startTime(now()),
															#line 411 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   file(),
															#line 412 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   uploadID(),
															#line 413 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   parts(),
															#line 414 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   size(),
															#line 415 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   hashState(XXH64_createState()),
															#line 416 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   retries(0),
															#line 417 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   offset(),
															#line 418 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   partNumber(),
															#line 419 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   maxConcurrentUploads(),
															#line 420 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   activeFutures(),
															#line 421 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   activePartIndices(),
															#line 422 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   partSize(),
															#line 423 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   numParts(),
															#line 424 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   checksum(),
															#line 425 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   part(),
															#line 426 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   tags()
															#line 2189 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
	{
		fdb_probe_actor_create("copyUpFile", reinterpret_cast<unsigned long>(this));

	}
	~CopyUpFileActorState() 
	{
		fdb_probe_actor_destroy("copyUpFile", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 428 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			;
															#line 2204 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CopyUpFileActorState();
		static_cast<CopyUpFileActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 631 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!static_cast<CopyUpFileActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CopyUpFileActorState(); static_cast<CopyUpFileActor*>(this)->destroy(); return 0; }
															#line 2227 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		new (&static_cast<CopyUpFileActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CopyUpFileActorState();
		static_cast<CopyUpFileActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 430 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(s3VerboseEventSev(), "S3ClientCopyUpFileStart") .detail("Bucket", bucket) .detail("Object", objectName) .detail("FilePath", filepath) .detail("Attempt", retries);
															#line 437 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (!hashState)
															#line 2249 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			{
															#line 438 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				hashState = XXH64_createState();
															#line 2253 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			}
															#line 440 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			XXH64_reset(hashState, 0);
															#line 442 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			StrictFuture<Reference<IAsyncFile>> __when_expr_0 = IAsyncFileSystem::filesystem()->open( filepath, IAsyncFile::OPEN_READONLY | IAsyncFile::OPEN_UNCACHED | IAsyncFile::OPEN_NO_AIO, 0644);
															#line 442 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (static_cast<CopyUpFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2261 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CopyUpFileActor*>(this)->actor_wait_state = 1;
															#line 442 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CopyUpFileActor, 0, Reference<IAsyncFile> >*>(static_cast<CopyUpFileActor*>(this)));
															#line 2266 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 554 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 2301 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			{
															#line 555 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 2305 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			}
															#line 558 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if ((e.code() == error_code_file_not_found || e.code() == error_code_http_request_failed || e.code() == error_code_io_error) && retries < config.maxFileRetries)
															#line 2309 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			{
															#line 561 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				retryError = e;
															#line 562 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				TraceEvent(SevWarn, "S3ClientCopyUpFileRetry") .errorUnsuppressed(retryError) .detail("Bucket", bucket) .detail("Object", objectName) .detail("FilePath", filepath) .detail("Retries", retries);
															#line 568 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				retries++;
															#line 571 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				XXH64_freeState(hashState);
															#line 572 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				hashState = nullptr;
															#line 573 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				parts.clear();
															#line 574 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				activeFutures.clear();
															#line 575 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				activePartIndices.clear();
															#line 577 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				if (file)
															#line 2329 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
				{
															#line 578 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
					file = Reference<IAsyncFile>();
															#line 2333 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
				}
															#line 582 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				if (!uploadID.empty())
															#line 2337 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
				{
					try {
															#line 584 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
						StrictFuture<Void> __when_expr_6 = endpoint->abortMultiPartUpload(bucket, objectName, uploadID);
															#line 584 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
						if (static_cast<CopyUpFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1Catch1(actor_cancelled(), loopDepth);
															#line 2344 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
						if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1loopBody1Catch1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1loopBody1Catch1when1(__when_expr_6.get(), loopDepth); };
						static_cast<CopyUpFileActor*>(this)->actor_wait_state = 7;
															#line 584 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
						__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< CopyUpFileActor, 6, Void >*>(static_cast<CopyUpFileActor*>(this)));
															#line 2349 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
						loopDepth = 0;
					}
					catch (Error& error) {
						loopDepth = a_body1loopBody1Catch1Catch1(error, loopDepth);
					} catch (...) {
						loopDepth = a_body1loopBody1Catch1Catch1(unknown_error(), loopDepth);
					}
				}
				else
				{
					loopDepth = a_body1loopBody1Catch1cont3(loopDepth);
				}
			}
			else
			{
															#line 602 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				err = e;
															#line 603 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				XXH64_freeState(hashState);
															#line 604 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				hashState = nullptr;
															#line 605 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				TraceEvent(SevWarnAlways, "S3ClientCopyUpFileError") .detail("Filepath", filepath) .detail("Bucket", bucket) .detail("ObjectName", objectName) .detail("Error", err.what()) .detail("Attempts", retries + 1);
															#line 613 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				file = Reference<IAsyncFile>();
															#line 616 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				if (!uploadID.empty())
															#line 2377 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
				{
					try {
															#line 618 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
						StrictFuture<Void> __when_expr_9 = endpoint->abortMultiPartUpload(bucket, objectName, uploadID);
															#line 618 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
						if (static_cast<CopyUpFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1Catch2(actor_cancelled(), loopDepth);
															#line 2384 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
						if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1loopBody1Catch1Catch2(__when_expr_9.getError(), loopDepth); else return a_body1loopBody1Catch1when2(__when_expr_9.get(), loopDepth); };
						static_cast<CopyUpFileActor*>(this)->actor_wait_state = 10;
															#line 618 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
						__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< CopyUpFileActor, 9, Void >*>(static_cast<CopyUpFileActor*>(this)));
															#line 2389 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
						loopDepth = 0;
					}
					catch (Error& error) {
						loopDepth = a_body1loopBody1Catch1Catch2(error, loopDepth);
					} catch (...) {
						loopDepth = a_body1loopBody1Catch1Catch2(unknown_error(), loopDepth);
					}
				}
				else
				{
					loopDepth = a_body1loopBody1Catch1cont12(loopDepth);
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Reference<IAsyncFile> const& f,int loopDepth) 
	{
															#line 444 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		file = f;
															#line 446 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<int64_t> __when_expr_1 = file->size();
															#line 446 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<CopyUpFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2420 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<CopyUpFileActor*>(this)->actor_wait_state = 2;
															#line 446 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CopyUpFileActor, 1, int64_t >*>(static_cast<CopyUpFileActor*>(this)));
															#line 2425 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Reference<IAsyncFile> && f,int loopDepth) 
	{
															#line 444 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		file = f;
															#line 446 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<int64_t> __when_expr_1 = file->size();
															#line 446 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<CopyUpFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2438 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<CopyUpFileActor*>(this)->actor_wait_state = 2;
															#line 446 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CopyUpFileActor, 1, int64_t >*>(static_cast<CopyUpFileActor*>(this)));
															#line 2443 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Reference<IAsyncFile> const& f,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(f, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Reference<IAsyncFile> && f,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(f), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CopyUpFileActor*>(this)->actor_wait_state > 0) static_cast<CopyUpFileActor*>(this)->actor_wait_state = 0;
		static_cast<CopyUpFileActor*>(this)->ActorCallback< CopyUpFileActor, 0, Reference<IAsyncFile> >::remove();

	}
	void a_callback_fire(ActorCallback< CopyUpFileActor, 0, Reference<IAsyncFile> >*,Reference<IAsyncFile> const& value) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CopyUpFileActor, 0, Reference<IAsyncFile> >*,Reference<IAsyncFile> && value) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CopyUpFileActor, 0, Reference<IAsyncFile> >*,Error err) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont4(int64_t const& fileSize,int loopDepth) 
	{
															#line 447 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		size = fileSize;
															#line 449 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<std::string> __when_expr_2 = endpoint->beginMultiPartUpload(bucket, objectName);
															#line 449 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<CopyUpFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2531 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont4when1(__when_expr_2.get(), loopDepth); };
		static_cast<CopyUpFileActor*>(this)->actor_wait_state = 3;
															#line 449 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CopyUpFileActor, 2, std::string >*>(static_cast<CopyUpFileActor*>(this)));
															#line 2536 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont4(int64_t && fileSize,int loopDepth) 
	{
															#line 447 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		size = fileSize;
															#line 449 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<std::string> __when_expr_2 = endpoint->beginMultiPartUpload(bucket, objectName);
															#line 449 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<CopyUpFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2549 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont4when1(__when_expr_2.get(), loopDepth); };
		static_cast<CopyUpFileActor*>(this)->actor_wait_state = 3;
															#line 449 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CopyUpFileActor, 2, std::string >*>(static_cast<CopyUpFileActor*>(this)));
															#line 2554 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(int64_t const& fileSize,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(fileSize, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(int64_t && fileSize,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(fileSize), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CopyUpFileActor*>(this)->actor_wait_state > 0) static_cast<CopyUpFileActor*>(this)->actor_wait_state = 0;
		static_cast<CopyUpFileActor*>(this)->ActorCallback< CopyUpFileActor, 1, int64_t >::remove();

	}
	void a_callback_fire(ActorCallback< CopyUpFileActor, 1, int64_t >*,int64_t const& value) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CopyUpFileActor, 1, int64_t >*,int64_t && value) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CopyUpFileActor, 1, int64_t >*,Error err) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont5(std::string const& id,int loopDepth) 
	{
															#line 450 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		uploadID = id;
															#line 452 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		offset = 0;
															#line 453 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		partNumber = 1;
															#line 454 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		maxConcurrentUploads = CLIENT_KNOBS->BLOBSTORE_CONCURRENT_WRITES_PER_FILE;
															#line 455 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		activeFutures.clear();
															#line 456 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		activePartIndices.clear();
															#line 459 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		;
															#line 2650 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = a_body1loopBody1cont5loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5(std::string && id,int loopDepth) 
	{
															#line 450 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		uploadID = id;
															#line 452 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		offset = 0;
															#line 453 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		partNumber = 1;
															#line 454 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		maxConcurrentUploads = CLIENT_KNOBS->BLOBSTORE_CONCURRENT_WRITES_PER_FILE;
															#line 455 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		activeFutures.clear();
															#line 456 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		activePartIndices.clear();
															#line 459 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		;
															#line 2671 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = a_body1loopBody1cont5loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4when1(std::string const& id,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(id, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4when1(std::string && id,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(std::move(id), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CopyUpFileActor*>(this)->actor_wait_state > 0) static_cast<CopyUpFileActor*>(this)->actor_wait_state = 0;
		static_cast<CopyUpFileActor*>(this)->ActorCallback< CopyUpFileActor, 2, std::string >::remove();

	}
	void a_callback_fire(ActorCallback< CopyUpFileActor, 2, std::string >*,std::string const& value) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CopyUpFileActor, 2, std::string >*,std::string && value) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CopyUpFileActor, 2, std::string >*,Error err) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont6(int loopDepth) 
	{
															#line 491 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		std::map<int, S3BlobStoreEndpoint::PartInfo> etagMap;
															#line 492 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		for( const auto& part : parts ) {
															#line 493 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (!part.completed)
															#line 2759 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			{
															#line 494 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				TraceEvent(SevWarnAlways, "S3ClientCopyUpFilePartNotCompleted") .detail("PartNumber", part.partNumber) .detail("Offset", part.offset) .detail("Size", part.size);
															#line 498 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				XXH64_freeState(hashState);
															#line 499 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				return a_body1loopBody1Catch1(http_bad_response(), loopDepth);
															#line 2767 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			}
															#line 501 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			etagMap[part.partNumber] = S3BlobStoreEndpoint::PartInfo(part.etag, part.checksum);
															#line 2771 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		}
															#line 504 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<Optional<std::string>> __when_expr_4 = endpoint->finishMultiPartUpload(bucket, objectName, uploadID, etagMap);
															#line 504 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<CopyUpFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2777 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1loopBody1cont6when1(__when_expr_4.get(), loopDepth); };
		static_cast<CopyUpFileActor*>(this)->actor_wait_state = 5;
															#line 504 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< CopyUpFileActor, 4, Optional<std::string> >*>(static_cast<CopyUpFileActor*>(this)));
															#line 2782 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont5loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont5loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5loopBody1(int loopDepth) 
	{
															#line 459 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!(offset < size))
															#line 2798 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
			return a_body1loopBody1cont5break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 461 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		for(;activeFutures.size() < maxConcurrentUploads && offset < size;) {
															#line 462 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			partSize = std::min(config.partSizeBytes, size - offset);
															#line 464 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			part = PartState();
															#line 465 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			part.partNumber = partNumber;
															#line 466 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			part.offset = offset;
															#line 467 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			part.size = partSize;
															#line 468 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			parts.push_back(part);
															#line 470 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			activeFutures.push_back(uploadPart(endpoint, bucket, objectName, uploadID, file, part, config));
															#line 471 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			activePartIndices.push_back(partNumber - 1);
															#line 473 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			offset += partSize;
															#line 474 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			partNumber++;
															#line 2824 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		}
															#line 478 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!activeFutures.empty())
															#line 2828 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
															#line 479 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			StrictFuture<std::vector<PartState>> __when_expr_3 = getAll(activeFutures);
															#line 479 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (static_cast<CopyUpFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2834 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont5loopBody1when1(__when_expr_3.get(), loopDepth); };
			static_cast<CopyUpFileActor*>(this)->actor_wait_state = 4;
															#line 479 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CopyUpFileActor, 3, std::vector<PartState> >*>(static_cast<CopyUpFileActor*>(this)));
															#line 2839 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont5loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont5break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont6(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont5loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont5loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont5loopBody1cont4(std::vector<PartState> const& completedParts,int loopDepth) 
	{
															#line 481 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		for(int i = 0;i < completedParts.size();i++) {
															#line 482 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			parts[activePartIndices[i]] = completedParts[i];
															#line 2874 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		}
															#line 485 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		activeFutures.clear();
															#line 486 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		activePartIndices.clear();
															#line 2880 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = a_body1loopBody1cont5loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5loopBody1cont4(std::vector<PartState> && completedParts,int loopDepth) 
	{
															#line 481 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		for(int i = 0;i < completedParts.size();i++) {
															#line 482 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			parts[activePartIndices[i]] = completedParts[i];
															#line 2891 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		}
															#line 485 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		activeFutures.clear();
															#line 486 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		activePartIndices.clear();
															#line 2897 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = a_body1loopBody1cont5loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5loopBody1when1(std::vector<PartState> const& completedParts,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5loopBody1cont4(completedParts, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5loopBody1when1(std::vector<PartState> && completedParts,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5loopBody1cont4(std::move(completedParts), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<CopyUpFileActor*>(this)->actor_wait_state > 0) static_cast<CopyUpFileActor*>(this)->actor_wait_state = 0;
		static_cast<CopyUpFileActor*>(this)->ActorCallback< CopyUpFileActor, 3, std::vector<PartState> >::remove();

	}
	void a_callback_fire(ActorCallback< CopyUpFileActor, 3, std::vector<PartState> >*,std::vector<PartState> const& value) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont5loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< CopyUpFileActor, 3, std::vector<PartState> >*,std::vector<PartState> && value) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont5loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< CopyUpFileActor, 3, std::vector<PartState> >*,Error err) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont7(Optional<std::string> const& s3Checksum,int loopDepth) 
	{
															#line 508 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (s3Checksum.present())
															#line 2981 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
															#line 509 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(SevDebug, "S3ClientMultipartUploadChecksum") .detail("Bucket", bucket) .detail("Object", objectName) .detail("S3ChecksumSHA256", s3Checksum.get());
															#line 2985 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		}
															#line 517 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		TraceEvent(SevDebug, "S3ClientCalculatingFileChecksum") .detail("Bucket", bucket) .detail("Object", objectName) .detail("NumParts", parts.size());
															#line 522 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		for( const auto& part : parts ) {
															#line 523 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (!part.partData.empty())
															#line 2993 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			{
															#line 524 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				XXH64_update(hashState, part.partData.data(), part.partData.size());
															#line 2997 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			}
		}
															#line 529 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		numParts = parts.size();
															#line 530 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		parts.clear();
															#line 533 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		uint64_t hash = XXH64_digest(hashState);
															#line 534 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		XXH64_freeState(hashState);
															#line 535 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		checksum = format("%016llx", hash);
															#line 538 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		file = Reference<IAsyncFile>();
															#line 541 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<Void> __when_expr_5 = writeChecksumWithFallback(endpoint, bucket, objectName, checksum, config);
															#line 541 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<CopyUpFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3016 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1loopBody1cont7when1(__when_expr_5.get(), loopDepth); };
		static_cast<CopyUpFileActor*>(this)->actor_wait_state = 6;
															#line 541 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< CopyUpFileActor, 5, Void >*>(static_cast<CopyUpFileActor*>(this)));
															#line 3021 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont7(Optional<std::string> && s3Checksum,int loopDepth) 
	{
															#line 508 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (s3Checksum.present())
															#line 3030 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
															#line 509 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(SevDebug, "S3ClientMultipartUploadChecksum") .detail("Bucket", bucket) .detail("Object", objectName) .detail("S3ChecksumSHA256", s3Checksum.get());
															#line 3034 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		}
															#line 517 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		TraceEvent(SevDebug, "S3ClientCalculatingFileChecksum") .detail("Bucket", bucket) .detail("Object", objectName) .detail("NumParts", parts.size());
															#line 522 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		for( const auto& part : parts ) {
															#line 523 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (!part.partData.empty())
															#line 3042 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			{
															#line 524 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				XXH64_update(hashState, part.partData.data(), part.partData.size());
															#line 3046 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			}
		}
															#line 529 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		numParts = parts.size();
															#line 530 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		parts.clear();
															#line 533 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		uint64_t hash = XXH64_digest(hashState);
															#line 534 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		XXH64_freeState(hashState);
															#line 535 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		checksum = format("%016llx", hash);
															#line 538 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		file = Reference<IAsyncFile>();
															#line 541 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<Void> __when_expr_5 = writeChecksumWithFallback(endpoint, bucket, objectName, checksum, config);
															#line 541 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<CopyUpFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3065 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1loopBody1cont7when1(__when_expr_5.get(), loopDepth); };
		static_cast<CopyUpFileActor*>(this)->actor_wait_state = 6;
															#line 541 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< CopyUpFileActor, 5, Void >*>(static_cast<CopyUpFileActor*>(this)));
															#line 3070 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont6when1(Optional<std::string> const& s3Checksum,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(s3Checksum, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6when1(Optional<std::string> && s3Checksum,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(std::move(s3Checksum), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<CopyUpFileActor*>(this)->actor_wait_state > 0) static_cast<CopyUpFileActor*>(this)->actor_wait_state = 0;
		static_cast<CopyUpFileActor*>(this)->ActorCallback< CopyUpFileActor, 4, Optional<std::string> >::remove();

	}
	void a_callback_fire(ActorCallback< CopyUpFileActor, 4, Optional<std::string> >*,Optional<std::string> const& value) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< CopyUpFileActor, 4, Optional<std::string> >*,Optional<std::string> && value) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< CopyUpFileActor, 4, Optional<std::string> >*,Error err) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1loopBody1cont10(Void const& _,int loopDepth) 
	{
															#line 543 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		TraceEvent(s3VerboseEventSev(), "S3ClientCopyUpFileEnd") .detail("Bucket", bucket) .detail("ObjectName", objectName) .detail("FileSize", size) .detail("Parts", numParts) .detail("Checksum", checksum) .detail("Duration", now() - startTime) .detail("Attempts", retries + 1);
															#line 3154 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont10(Void && _,int loopDepth) 
	{
															#line 543 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		TraceEvent(s3VerboseEventSev(), "S3ClientCopyUpFileEnd") .detail("Bucket", bucket) .detail("ObjectName", objectName) .detail("FileSize", size) .detail("Parts", numParts) .detail("Checksum", checksum) .detail("Duration", now() - startTime) .detail("Attempts", retries + 1);
															#line 3163 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont7when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont7when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<CopyUpFileActor*>(this)->actor_wait_state > 0) static_cast<CopyUpFileActor*>(this)->actor_wait_state = 0;
		static_cast<CopyUpFileActor*>(this)->ActorCallback< CopyUpFileActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CopyUpFileActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< CopyUpFileActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< CopyUpFileActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1loopBody1Catch1cont1(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont3(int loopDepth) 
	{
															#line 596 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (g_network->isSimulated())
															#line 3253 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
															#line 597 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			StrictFuture<Void> __when_expr_7 = delay(0);
															#line 597 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (static_cast<CopyUpFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3259 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1cont3when1(__when_expr_7.get(), loopDepth); };
			static_cast<CopyUpFileActor*>(this)->actor_wait_state = 8;
															#line 597 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< CopyUpFileActor, 7, Void >*>(static_cast<CopyUpFileActor*>(this)));
															#line 3264 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1Catch1cont9(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont5(int loopDepth) 
	{
															#line 593 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		uploadID = "";
															#line 3278 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = a_body1loopBody1Catch1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1Catch1(const Error& abortError,int loopDepth=0) 
	{
		try {
															#line 586 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(SevWarn, "S3ClientCopyUpFileAbortError") .error(abortError) .detail("Bucket", bucket) .detail("Object", objectName) .detail("UploadID", uploadID) .detail("OriginalError", retryError.what());
															#line 3288 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			loopDepth = a_body1loopBody1Catch1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<CopyUpFileActor*>(this)->actor_wait_state > 0) static_cast<CopyUpFileActor*>(this)->actor_wait_state = 0;
		static_cast<CopyUpFileActor*>(this)->ActorCallback< CopyUpFileActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CopyUpFileActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< CopyUpFileActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< CopyUpFileActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1Catch1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1loopBody1Catch1cont7(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1Catch1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont9(int loopDepth) 
	{
															#line 600 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<Void> __when_expr_8 = delay(1.0 * retries);
															#line 600 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<CopyUpFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3405 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1cont9when1(__when_expr_8.get(), loopDepth); };
		static_cast<CopyUpFileActor*>(this)->actor_wait_state = 9;
															#line 600 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< CopyUpFileActor, 8, Void >*>(static_cast<CopyUpFileActor*>(this)));
															#line 3410 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont10(Void const& _,int loopDepth) 
	{
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont10(Void && _,int loopDepth) 
	{
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<CopyUpFileActor*>(this)->actor_wait_state > 0) static_cast<CopyUpFileActor*>(this)->actor_wait_state = 0;
		static_cast<CopyUpFileActor*>(this)->ActorCallback< CopyUpFileActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CopyUpFileActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1loopBody1Catch1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< CopyUpFileActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1loopBody1Catch1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< CopyUpFileActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1loopBody1Catch1cont11(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont11(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont9when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont11(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont9when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont11(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<CopyUpFileActor*>(this)->actor_wait_state > 0) static_cast<CopyUpFileActor*>(this)->actor_wait_state = 0;
		static_cast<CopyUpFileActor*>(this)->ActorCallback< CopyUpFileActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CopyUpFileActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1loopBody1Catch1cont9when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< CopyUpFileActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1loopBody1Catch1cont9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< CopyUpFileActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1loopBody1Catch1cont12(int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont13(int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1Catch2(const Error& abortError,int loopDepth=0) 
	{
		try {
															#line 621 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(SevWarnAlways, "S3ClientCopyUpFileAbortError") .error(abortError) .detail("Bucket", bucket) .detail("Object", objectName) .detail("OriginalError", err.what());
															#line 3606 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			loopDepth = a_body1loopBody1Catch1cont13(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont14(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont14cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont14(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont14cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont14(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont14(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<CopyUpFileActor*>(this)->actor_wait_state > 0) static_cast<CopyUpFileActor*>(this)->actor_wait_state = 0;
		static_cast<CopyUpFileActor*>(this)->ActorCallback< CopyUpFileActor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CopyUpFileActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1loopBody1Catch1when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1Catch2(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< CopyUpFileActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1loopBody1Catch1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1Catch2(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< CopyUpFileActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1loopBody1Catch1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1Catch2(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1loopBody1Catch1cont14cont1(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1Catch1cont13(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 405 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	Reference<S3BlobStoreEndpoint> endpoint;
															#line 405 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string bucket;
															#line 405 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string objectName;
															#line 405 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string filepath;
															#line 405 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	PartConfig config;
															#line 410 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	double startTime;
															#line 411 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	Reference<IAsyncFile> file;
															#line 412 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string uploadID;
															#line 413 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::vector<PartState> parts;
															#line 414 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	int64_t size;
															#line 415 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	XXH64_state_t* hashState;
															#line 416 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	int retries;
															#line 417 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	int64_t offset;
															#line 418 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	int partNumber;
															#line 419 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	int maxConcurrentUploads;
															#line 420 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::vector<Future<PartState>> activeFutures;
															#line 421 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::vector<int> activePartIndices;
															#line 422 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	int64_t partSize;
															#line 423 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	int numParts;
															#line 424 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string checksum;
															#line 425 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	PartState part;
															#line 426 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::map<std::string, std::string> tags;
															#line 561 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	Error retryError;
															#line 602 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	Error err;
															#line 3765 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
};
// This generated class is to be used only via copyUpFile()
															#line 405 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
class CopyUpFileActor final : public Actor<Void>, public ActorCallback< CopyUpFileActor, 0, Reference<IAsyncFile> >, public ActorCallback< CopyUpFileActor, 1, int64_t >, public ActorCallback< CopyUpFileActor, 2, std::string >, public ActorCallback< CopyUpFileActor, 3, std::vector<PartState> >, public ActorCallback< CopyUpFileActor, 4, Optional<std::string> >, public ActorCallback< CopyUpFileActor, 5, Void >, public ActorCallback< CopyUpFileActor, 6, Void >, public ActorCallback< CopyUpFileActor, 7, Void >, public ActorCallback< CopyUpFileActor, 8, Void >, public ActorCallback< CopyUpFileActor, 9, Void >, public FastAllocated<CopyUpFileActor>, public CopyUpFileActorState<CopyUpFileActor> {
															#line 3770 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
public:
	using FastAllocated<CopyUpFileActor>::operator new;
	using FastAllocated<CopyUpFileActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14880635582240467456UL, 18164845246560292352UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CopyUpFileActor, 0, Reference<IAsyncFile> >;
friend struct ActorCallback< CopyUpFileActor, 1, int64_t >;
friend struct ActorCallback< CopyUpFileActor, 2, std::string >;
friend struct ActorCallback< CopyUpFileActor, 3, std::vector<PartState> >;
friend struct ActorCallback< CopyUpFileActor, 4, Optional<std::string> >;
friend struct ActorCallback< CopyUpFileActor, 5, Void >;
friend struct ActorCallback< CopyUpFileActor, 6, Void >;
friend struct ActorCallback< CopyUpFileActor, 7, Void >;
friend struct ActorCallback< CopyUpFileActor, 8, Void >;
friend struct ActorCallback< CopyUpFileActor, 9, Void >;
															#line 405 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	CopyUpFileActor(Reference<S3BlobStoreEndpoint> const& endpoint,std::string const& bucket,std::string const& objectName,std::string const& filepath,PartConfig const& config = PartConfig()) 
															#line 3796 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		 : Actor<Void>(),
		   CopyUpFileActorState<CopyUpFileActor>(endpoint, bucket, objectName, filepath, config),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5029125091406905600UL, 16817405566823635200UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("copyUpFile");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CopyUpFileActor, 0, Reference<IAsyncFile> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CopyUpFileActor, 1, int64_t >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CopyUpFileActor, 2, std::string >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< CopyUpFileActor, 3, std::vector<PartState> >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< CopyUpFileActor, 4, Optional<std::string> >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< CopyUpFileActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< CopyUpFileActor, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< CopyUpFileActor, 7, Void >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< CopyUpFileActor, 8, Void >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< CopyUpFileActor, 9, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 405 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
[[nodiscard]] static Future<Void> copyUpFile( Reference<S3BlobStoreEndpoint> const& endpoint, std::string const& bucket, std::string const& objectName, std::string const& filepath, PartConfig const& config = PartConfig() ) {
															#line 405 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	return Future<Void>(new CopyUpFileActor(endpoint, bucket, objectName, filepath, config));
															#line 3838 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
}

#line 633 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"

															#line 3843 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
namespace {
// This generated class is to be used only via copyUpFile()
															#line 634 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
template <class CopyUpFileActor1>
															#line 634 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
class CopyUpFileActor1State {
															#line 3850 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
public:
															#line 634 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	CopyUpFileActor1State(std::string const& filepath,std::string const& s3url) 
															#line 634 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
															#line 634 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		 : filepath(filepath),
															#line 634 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   s3url(s3url)
															#line 3859 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
	{
		fdb_probe_actor_create("copyUpFile", reinterpret_cast<unsigned long>(this));

	}
	~CopyUpFileActor1State() 
	{
		fdb_probe_actor_destroy("copyUpFile", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 635 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			std::string resource;
															#line 636 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			S3BlobStoreEndpoint::ParametersT parameters;
															#line 637 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			Reference<S3BlobStoreEndpoint> endpoint = getEndpoint(s3url, resource, parameters);
															#line 638 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			StrictFuture<Void> __when_expr_0 = copyUpFile(endpoint, parameters["bucket"], resource, filepath);
															#line 638 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (static_cast<CopyUpFileActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3882 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CopyUpFileActor1*>(this)->actor_wait_state = 1;
															#line 638 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CopyUpFileActor1, 0, Void >*>(static_cast<CopyUpFileActor1*>(this)));
															#line 3887 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CopyUpFileActor1State();
		static_cast<CopyUpFileActor1*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 639 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!static_cast<CopyUpFileActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CopyUpFileActor1State(); static_cast<CopyUpFileActor1*>(this)->destroy(); return 0; }
															#line 3910 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		new (&static_cast<CopyUpFileActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~CopyUpFileActor1State();
		static_cast<CopyUpFileActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 639 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!static_cast<CopyUpFileActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CopyUpFileActor1State(); static_cast<CopyUpFileActor1*>(this)->destroy(); return 0; }
															#line 3922 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		new (&static_cast<CopyUpFileActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~CopyUpFileActor1State();
		static_cast<CopyUpFileActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CopyUpFileActor1*>(this)->actor_wait_state > 0) static_cast<CopyUpFileActor1*>(this)->actor_wait_state = 0;
		static_cast<CopyUpFileActor1*>(this)->ActorCallback< CopyUpFileActor1, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CopyUpFileActor1, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CopyUpFileActor1, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CopyUpFileActor1, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 634 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string filepath;
															#line 634 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string s3url;
															#line 4009 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
};
// This generated class is to be used only via copyUpFile()
															#line 634 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
class CopyUpFileActor1 final : public Actor<Void>, public ActorCallback< CopyUpFileActor1, 0, Void >, public FastAllocated<CopyUpFileActor1>, public CopyUpFileActor1State<CopyUpFileActor1> {
															#line 4014 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
public:
	using FastAllocated<CopyUpFileActor1>::operator new;
	using FastAllocated<CopyUpFileActor1>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14880635582240467456UL, 18164845246560292352UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CopyUpFileActor1, 0, Void >;
															#line 634 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	CopyUpFileActor1(std::string const& filepath,std::string const& s3url) 
															#line 4031 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		 : Actor<Void>(),
		   CopyUpFileActor1State<CopyUpFileActor1>(filepath, s3url),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(794650894807017472UL, 16661816041386160896UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("copyUpFile");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CopyUpFileActor1, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 634 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
[[nodiscard]] Future<Void> copyUpFile( std::string const& filepath, std::string const& s3url ) {
															#line 634 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	return Future<Void>(new CopyUpFileActor1(filepath, s3url));
															#line 4064 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
}

#line 641 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"

															#line 4069 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
namespace {
// This generated class is to be used only via copyUpDirectory()
															#line 642 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
template <class CopyUpDirectoryActor>
															#line 642 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
class CopyUpDirectoryActorState {
															#line 4076 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
public:
															#line 642 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	CopyUpDirectoryActorState(std::string const& dirpath,std::string const& s3url) 
															#line 642 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
															#line 642 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		 : dirpath(dirpath),
															#line 642 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   s3url(s3url),
															#line 643 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   resource()
															#line 4087 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
	{
		fdb_probe_actor_create("copyUpDirectory", reinterpret_cast<unsigned long>(this));

	}
	~CopyUpDirectoryActorState() 
	{
		fdb_probe_actor_destroy("copyUpDirectory", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 644 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			S3BlobStoreEndpoint::ParametersT parameters;
															#line 645 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			endpoint = getEndpoint(s3url, resource, parameters);
															#line 646 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			bucket = parameters["bucket"];
															#line 647 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			files = std::vector<std::string>();
															#line 648 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			platform::findFilesRecursively(dirpath, files);
															#line 649 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(s3VerboseEventSev(), "S3ClientUploadDirStart") .detail("Filecount", files.size()) .detail("Bucket", bucket) .detail("Resource", resource);
															#line 653 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			RangeForbody1Iterator0 = std::begin(files);
															#line 4114 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CopyUpDirectoryActorState();
		static_cast<CopyUpDirectoryActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 658 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		TraceEvent(s3VerboseEventSev(), "S3ClientUploadDirEnd").detail("Bucket", bucket).detail("Resource", resource);
															#line 659 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!static_cast<CopyUpDirectoryActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CopyUpDirectoryActorState(); static_cast<CopyUpDirectoryActor*>(this)->destroy(); return 0; }
															#line 4139 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		new (&static_cast<CopyUpDirectoryActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CopyUpDirectoryActorState();
		static_cast<CopyUpDirectoryActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 653 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!(RangeForbody1Iterator0 != std::end(files)))
															#line 4158 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 653 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		const auto& file = *RangeForbody1Iterator0;
															#line 4164 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
															#line 654 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			std::string filepath = file;
															#line 655 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			std::string s3path = resource + "/" + file.substr(dirpath.size() + 1);
															#line 656 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			StrictFuture<Void> __when_expr_0 = copyUpFile(endpoint, bucket, s3path, filepath);
															#line 656 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (static_cast<CopyUpDirectoryActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4174 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CopyUpDirectoryActor*>(this)->actor_wait_state = 1;
															#line 656 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CopyUpDirectoryActor, 0, Void >*>(static_cast<CopyUpDirectoryActor*>(this)));
															#line 4179 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 653 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		++RangeForbody1Iterator0;
															#line 4202 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CopyUpDirectoryActor*>(this)->actor_wait_state > 0) static_cast<CopyUpDirectoryActor*>(this)->actor_wait_state = 0;
		static_cast<CopyUpDirectoryActor*>(this)->ActorCallback< CopyUpDirectoryActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CopyUpDirectoryActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("copyUpDirectory", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpDirectoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpDirectory", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CopyUpDirectoryActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("copyUpDirectory", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpDirectoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpDirectory", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CopyUpDirectoryActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("copyUpDirectory", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpDirectoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpDirectory", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 642 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string dirpath;
															#line 642 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string s3url;
															#line 643 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string resource;
															#line 645 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	Reference<S3BlobStoreEndpoint> endpoint;
															#line 646 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string bucket;
															#line 647 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::vector<std::string> files;
															#line 653 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	decltype(std::begin(std::declval<std::vector<std::string>>())) RangeForbody1Iterator0;
															#line 4308 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
};
// This generated class is to be used only via copyUpDirectory()
															#line 642 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
class CopyUpDirectoryActor final : public Actor<Void>, public ActorCallback< CopyUpDirectoryActor, 0, Void >, public FastAllocated<CopyUpDirectoryActor>, public CopyUpDirectoryActorState<CopyUpDirectoryActor> {
															#line 4313 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
public:
	using FastAllocated<CopyUpDirectoryActor>::operator new;
	using FastAllocated<CopyUpDirectoryActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8676860388403149312UL, 6463288978272486144UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CopyUpDirectoryActor, 0, Void >;
															#line 642 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	CopyUpDirectoryActor(std::string const& dirpath,std::string const& s3url) 
															#line 4330 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		 : Actor<Void>(),
		   CopyUpDirectoryActorState<CopyUpDirectoryActor>(dirpath, s3url),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("copyUpDirectory", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11526468938747652608UL, 2529043041251822336UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpDirectoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("copyUpDirectory");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("copyUpDirectory", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CopyUpDirectoryActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 642 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
[[nodiscard]] Future<Void> copyUpDirectory( std::string const& dirpath, std::string const& s3url ) {
															#line 642 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	return Future<Void>(new CopyUpDirectoryActor(dirpath, s3url));
															#line 4363 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
}

#line 661 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"

															#line 4368 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
namespace {
// This generated class is to be used only via copyUpBulkDumpFileSet()
															#line 662 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
template <class CopyUpBulkDumpFileSetActor>
															#line 662 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
class CopyUpBulkDumpFileSetActorState {
															#line 4375 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
public:
															#line 662 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	CopyUpBulkDumpFileSetActorState(std::string const& s3url,BulkLoadFileSet const& sourceFileSet,BulkLoadFileSet const& destinationFileSet) 
															#line 662 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
															#line 662 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		 : s3url(s3url),
															#line 662 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   sourceFileSet(sourceFileSet),
															#line 662 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   destinationFileSet(destinationFileSet),
															#line 665 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   resource()
															#line 4388 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
	{
		fdb_probe_actor_create("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this));

	}
	~CopyUpBulkDumpFileSetActorState() 
	{
		fdb_probe_actor_destroy("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 666 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			S3BlobStoreEndpoint::ParametersT parameters;
															#line 667 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			endpoint = getEndpoint(s3url, resource, parameters);
															#line 668 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			bucket = parameters["bucket"];
															#line 670 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(s3VerboseEventSev(), "S3ClientCopyUpBulkDumpFileSetStart") .detail("Bucket", bucket) .detail("SourceFileSet", sourceFileSet.toString()) .detail("DestinationFileSet", destinationFileSet.toString());
															#line 674 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			pNumDeleted = 0;
															#line 675 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			pBytesDeleted = 0;
															#line 676 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			batch_dir = joinPath(getPath(s3url), destinationFileSet.getRelativePath());
															#line 679 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			StrictFuture<bool> __when_expr_0 = endpoint->bucketExists(bucket);
															#line 679 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (static_cast<CopyUpBulkDumpFileSetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4419 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CopyUpBulkDumpFileSetActor*>(this)->actor_wait_state = 1;
															#line 679 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CopyUpBulkDumpFileSetActor, 0, bool >*>(static_cast<CopyUpBulkDumpFileSetActor*>(this)));
															#line 4424 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CopyUpBulkDumpFileSetActorState();
		static_cast<CopyUpBulkDumpFileSetActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(bool const& exists,int loopDepth) 
	{
															#line 680 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (exists)
															#line 4447 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
															#line 681 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			StrictFuture<Void> __when_expr_1 = endpoint->deleteRecursively(bucket, batch_dir, &pNumDeleted, &pBytesDeleted);
															#line 681 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (static_cast<CopyUpBulkDumpFileSetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4453 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<CopyUpBulkDumpFileSetActor*>(this)->actor_wait_state = 2;
															#line 681 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CopyUpBulkDumpFileSetActor, 1, Void >*>(static_cast<CopyUpBulkDumpFileSetActor*>(this)));
															#line 4458 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(bool && exists,int loopDepth) 
	{
															#line 680 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (exists)
															#line 4472 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
															#line 681 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			StrictFuture<Void> __when_expr_1 = endpoint->deleteRecursively(bucket, batch_dir, &pNumDeleted, &pBytesDeleted);
															#line 681 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (static_cast<CopyUpBulkDumpFileSetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4478 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<CopyUpBulkDumpFileSetActor*>(this)->actor_wait_state = 2;
															#line 681 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CopyUpBulkDumpFileSetActor, 1, Void >*>(static_cast<CopyUpBulkDumpFileSetActor*>(this)));
															#line 4483 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(bool const& exists,int loopDepth) 
	{
		loopDepth = a_body1cont1(exists, loopDepth);

		return loopDepth;
	}
	int a_body1when1(bool && exists,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(exists), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CopyUpBulkDumpFileSetActor*>(this)->actor_wait_state > 0) static_cast<CopyUpBulkDumpFileSetActor*>(this)->actor_wait_state = 0;
		static_cast<CopyUpBulkDumpFileSetActor*>(this)->ActorCallback< CopyUpBulkDumpFileSetActor, 0, bool >::remove();

	}
	void a_callback_fire(ActorCallback< CopyUpBulkDumpFileSetActor, 0, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpBulkDumpFileSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CopyUpBulkDumpFileSetActor, 0, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpBulkDumpFileSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CopyUpBulkDumpFileSetActor, 0, bool >*,Error err) 
	{
		fdb_probe_actor_enter("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpBulkDumpFileSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 684 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		auto destinationManifestPath = joinPath(batch_dir, destinationFileSet.getManifestFileName());
															#line 685 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<Void> __when_expr_2 = copyUpFile(endpoint, bucket, destinationManifestPath, sourceFileSet.getManifestFileFullPath());
															#line 685 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<CopyUpBulkDumpFileSetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4576 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<CopyUpBulkDumpFileSetActor*>(this)->actor_wait_state = 3;
															#line 685 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CopyUpBulkDumpFileSetActor, 2, Void >*>(static_cast<CopyUpBulkDumpFileSetActor*>(this)));
															#line 4581 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CopyUpBulkDumpFileSetActor*>(this)->actor_wait_state > 0) static_cast<CopyUpBulkDumpFileSetActor*>(this)->actor_wait_state = 0;
		static_cast<CopyUpBulkDumpFileSetActor*>(this)->ActorCallback< CopyUpBulkDumpFileSetActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CopyUpBulkDumpFileSetActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpBulkDumpFileSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CopyUpBulkDumpFileSetActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpBulkDumpFileSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CopyUpBulkDumpFileSetActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpBulkDumpFileSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 686 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (sourceFileSet.hasDataFile())
															#line 4677 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
															#line 687 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			auto destinationDataPath = joinPath(batch_dir, destinationFileSet.getDataFileName());
															#line 688 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			StrictFuture<Void> __when_expr_3 = copyUpFile(endpoint, bucket, destinationDataPath, sourceFileSet.getDataFileFullPath());
															#line 688 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (static_cast<CopyUpBulkDumpFileSetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4685 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont4when1(__when_expr_3.get(), loopDepth); };
			static_cast<CopyUpBulkDumpFileSetActor*>(this)->actor_wait_state = 4;
															#line 688 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CopyUpBulkDumpFileSetActor, 3, Void >*>(static_cast<CopyUpBulkDumpFileSetActor*>(this)));
															#line 4690 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont5(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 686 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (sourceFileSet.hasDataFile())
															#line 4704 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
															#line 687 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			auto destinationDataPath = joinPath(batch_dir, destinationFileSet.getDataFileName());
															#line 688 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			StrictFuture<Void> __when_expr_3 = copyUpFile(endpoint, bucket, destinationDataPath, sourceFileSet.getDataFileFullPath());
															#line 688 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (static_cast<CopyUpBulkDumpFileSetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4712 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont4when1(__when_expr_3.get(), loopDepth); };
			static_cast<CopyUpBulkDumpFileSetActor*>(this)->actor_wait_state = 4;
															#line 688 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CopyUpBulkDumpFileSetActor, 3, Void >*>(static_cast<CopyUpBulkDumpFileSetActor*>(this)));
															#line 4717 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont5(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CopyUpBulkDumpFileSetActor*>(this)->actor_wait_state > 0) static_cast<CopyUpBulkDumpFileSetActor*>(this)->actor_wait_state = 0;
		static_cast<CopyUpBulkDumpFileSetActor*>(this)->ActorCallback< CopyUpBulkDumpFileSetActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CopyUpBulkDumpFileSetActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpBulkDumpFileSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CopyUpBulkDumpFileSetActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpBulkDumpFileSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CopyUpBulkDumpFileSetActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpBulkDumpFileSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont5(int loopDepth) 
	{
															#line 690 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (sourceFileSet.hasByteSampleFile())
															#line 4806 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
															#line 691 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			ASSERT(sourceFileSet.hasDataFile());
															#line 692 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			auto destinationByteSamplePath = joinPath(batch_dir, destinationFileSet.getByteSampleFileName());
															#line 693 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			StrictFuture<Void> __when_expr_4 = copyUpFile(endpoint, bucket, destinationByteSamplePath, sourceFileSet.getBytesSampleFileFullPath());
															#line 693 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (static_cast<CopyUpBulkDumpFileSetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4816 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont5when1(__when_expr_4.get(), loopDepth); };
			static_cast<CopyUpBulkDumpFileSetActor*>(this)->actor_wait_state = 5;
															#line 693 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< CopyUpBulkDumpFileSetActor, 4, Void >*>(static_cast<CopyUpBulkDumpFileSetActor*>(this)));
															#line 4821 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont7(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<CopyUpBulkDumpFileSetActor*>(this)->actor_wait_state > 0) static_cast<CopyUpBulkDumpFileSetActor*>(this)->actor_wait_state = 0;
		static_cast<CopyUpBulkDumpFileSetActor*>(this)->ActorCallback< CopyUpBulkDumpFileSetActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CopyUpBulkDumpFileSetActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpBulkDumpFileSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< CopyUpBulkDumpFileSetActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpBulkDumpFileSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< CopyUpBulkDumpFileSetActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpBulkDumpFileSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont7(int loopDepth) 
	{
															#line 695 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		TraceEvent(s3VerboseEventSev(), "S3ClientCopyUpBulkDumpFileSetEnd") .detail("BatchDir", batch_dir) .detail("NumDeleted", pNumDeleted) .detail("BytesDeleted", pBytesDeleted);
															#line 699 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!static_cast<CopyUpBulkDumpFileSetActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CopyUpBulkDumpFileSetActorState(); static_cast<CopyUpBulkDumpFileSetActor*>(this)->destroy(); return 0; }
															#line 4924 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		new (&static_cast<CopyUpBulkDumpFileSetActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CopyUpBulkDumpFileSetActorState();
		static_cast<CopyUpBulkDumpFileSetActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont8(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont8(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<CopyUpBulkDumpFileSetActor*>(this)->actor_wait_state > 0) static_cast<CopyUpBulkDumpFileSetActor*>(this)->actor_wait_state = 0;
		static_cast<CopyUpBulkDumpFileSetActor*>(this)->ActorCallback< CopyUpBulkDumpFileSetActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CopyUpBulkDumpFileSetActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpBulkDumpFileSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< CopyUpBulkDumpFileSetActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpBulkDumpFileSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< CopyUpBulkDumpFileSetActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpBulkDumpFileSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 662 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string s3url;
															#line 662 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	BulkLoadFileSet sourceFileSet;
															#line 662 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	BulkLoadFileSet destinationFileSet;
															#line 665 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string resource;
															#line 667 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	Reference<S3BlobStoreEndpoint> endpoint;
															#line 668 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string bucket;
															#line 674 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	int pNumDeleted;
															#line 675 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	int64_t pBytesDeleted;
															#line 676 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string batch_dir;
															#line 5037 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
};
// This generated class is to be used only via copyUpBulkDumpFileSet()
															#line 662 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
class CopyUpBulkDumpFileSetActor final : public Actor<Void>, public ActorCallback< CopyUpBulkDumpFileSetActor, 0, bool >, public ActorCallback< CopyUpBulkDumpFileSetActor, 1, Void >, public ActorCallback< CopyUpBulkDumpFileSetActor, 2, Void >, public ActorCallback< CopyUpBulkDumpFileSetActor, 3, Void >, public ActorCallback< CopyUpBulkDumpFileSetActor, 4, Void >, public FastAllocated<CopyUpBulkDumpFileSetActor>, public CopyUpBulkDumpFileSetActorState<CopyUpBulkDumpFileSetActor> {
															#line 5042 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
public:
	using FastAllocated<CopyUpBulkDumpFileSetActor>::operator new;
	using FastAllocated<CopyUpBulkDumpFileSetActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5477137649632108544UL, 16787607528360966144UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CopyUpBulkDumpFileSetActor, 0, bool >;
friend struct ActorCallback< CopyUpBulkDumpFileSetActor, 1, Void >;
friend struct ActorCallback< CopyUpBulkDumpFileSetActor, 2, Void >;
friend struct ActorCallback< CopyUpBulkDumpFileSetActor, 3, Void >;
friend struct ActorCallback< CopyUpBulkDumpFileSetActor, 4, Void >;
															#line 662 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	CopyUpBulkDumpFileSetActor(std::string const& s3url,BulkLoadFileSet const& sourceFileSet,BulkLoadFileSet const& destinationFileSet) 
															#line 5063 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		 : Actor<Void>(),
		   CopyUpBulkDumpFileSetActorState<CopyUpBulkDumpFileSetActor>(s3url, sourceFileSet, destinationFileSet),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(469867549170568960UL, 8064918125250259712UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpBulkDumpFileSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("copyUpBulkDumpFileSet");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CopyUpBulkDumpFileSetActor, 0, bool >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CopyUpBulkDumpFileSetActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CopyUpBulkDumpFileSetActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< CopyUpBulkDumpFileSetActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< CopyUpBulkDumpFileSetActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 662 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
[[nodiscard]] Future<Void> copyUpBulkDumpFileSet( std::string const& s3url, BulkLoadFileSet const& sourceFileSet, BulkLoadFileSet const& destinationFileSet ) {
															#line 662 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	return Future<Void>(new CopyUpBulkDumpFileSetActor(s3url, sourceFileSet, destinationFileSet));
															#line 5100 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
}

#line 701 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"

															#line 5105 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
namespace {
// This generated class is to be used only via downloadPart()
															#line 702 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
template <class DownloadPartActor>
															#line 702 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
class DownloadPartActorState {
															#line 5112 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
public:
															#line 702 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	DownloadPartActorState(Reference<S3BlobStoreEndpoint> const& endpoint,std::string const& bucket,std::string const& objectName,Reference<IAsyncFile> const& file,PartState const& part,PartConfig const& config) 
															#line 702 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
															#line 702 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		 : endpoint(endpoint),
															#line 702 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   bucket(bucket),
															#line 702 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   objectName(objectName),
															#line 702 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   file(file),
															#line 702 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   part(part),
															#line 702 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   config(config),
															#line 708 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   resultPart(part),
															#line 709 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   attempt(0),
															#line 710 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   maxRetries(config.maxPartRetries),
															#line 711 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   delayMs(config.baseRetryDelayMs)
															#line 5137 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
	{
		fdb_probe_actor_create("downloadPart", reinterpret_cast<unsigned long>(this));

	}
	~DownloadPartActorState() 
	{
		fdb_probe_actor_destroy("downloadPart", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 713 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(SevDebug, "S3ClientDownloadPartStart") .detail("Bucket", bucket) .detail("Object", objectName) .detail("PartNumber", part.partNumber) .detail("Offset", resultPart.offset) .detail("Size", resultPart.size);
															#line 720 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			;
															#line 5154 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DownloadPartActorState();
		static_cast<DownloadPartActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 722 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			buffer = std::vector<uint8_t>();
															#line 723 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			totalBytesRead = 0;
															#line 724 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			buffer.resize(resultPart.size);
															#line 727 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (resultPart.offset < 0 || resultPart.size <= 0)
															#line 5191 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			{
															#line 728 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				TraceEvent(SevError, "S3ClientDownloadPartInvalidRange") .detail("Offset", resultPart.offset) .detail("Size", resultPart.size);
															#line 731 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				return a_body1loopBody1Catch1(http_bad_response(), loopDepth);
															#line 5197 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			}
															#line 734 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			;
															#line 5201 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			loopDepth = a_body1loopBody1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 782 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			attempt++;
															#line 783 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (attempt >= maxRetries || !isRetryableError(e.code()))
															#line 5225 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			{
															#line 784 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				TraceEvent(SevWarnAlways, "S3ClientDownloadPartFailed") .detail("Bucket", bucket) .detail("Object", objectName) .detail("PartNumber", part.partNumber) .detail("ErrorCode", e.code()) .detail("Attempts", attempt) .detail("FinalError", e.what());
															#line 791 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 5231 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			}
															#line 794 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(SevInfo, "S3ClientDownloadPartRetry") .detail("Bucket", bucket) .detail("Object", objectName) .detail("PartNumber", part.partNumber) .detail("Attempt", attempt) .detail("Error", e.what()) .detail("DelayMs", delayMs);
															#line 802 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			StrictFuture<Void> __when_expr_2 = delay(delayMs / 1000.0);
															#line 802 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (static_cast<DownloadPartActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5239 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<DownloadPartActor*>(this)->actor_wait_state = 3;
															#line 802 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< DownloadPartActor, 2, Void >*>(static_cast<DownloadPartActor*>(this)));
															#line 5244 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 750 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (totalBytesRead != resultPart.size)
															#line 5259 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
															#line 751 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(SevError, "S3ClientDownloadPartSizeMismatch") .detail("Expected", resultPart.size) .detail("Actual", totalBytesRead) .detail("Offset", resultPart.offset) .detail("FilePath", file->getFilename());
															#line 756 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			return a_body1loopBody1Catch1(io_error(), loopDepth);
															#line 5265 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		}
															#line 760 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!resultPart.checksum.empty())
															#line 5269 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
															#line 761 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			std::string calculatedMD5 = HTTP::computeMD5Sum(std::string((char*)buffer.data(), totalBytesRead));
															#line 762 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (resultPart.checksum != calculatedMD5)
															#line 5275 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			{
															#line 763 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				TraceEvent(SevWarnAlways, "S3ClientDownloadPartChecksumMismatch") .detail("Expected", resultPart.checksum) .detail("Calculated", calculatedMD5);
															#line 766 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				return a_body1loopBody1Catch1(checksum_failed(), loopDepth);
															#line 5281 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			}
		}
															#line 770 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<Void> __when_expr_1 = file->write(buffer.data(), totalBytesRead, resultPart.offset);
															#line 770 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<DownloadPartActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5288 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<DownloadPartActor*>(this)->actor_wait_state = 2;
															#line 770 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DownloadPartActor, 1, Void >*>(static_cast<DownloadPartActor*>(this)));
															#line 5293 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
															#line 734 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!(totalBytesRead < resultPart.size))
															#line 5309 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
			return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 735 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<int> __when_expr_0 = endpoint->readObject(bucket, objectName, buffer.data() + totalBytesRead, resultPart.size - totalBytesRead, resultPart.offset + totalBytesRead);
															#line 735 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<DownloadPartActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5317 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<DownloadPartActor*>(this)->actor_wait_state = 1;
															#line 735 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DownloadPartActor, 0, int >*>(static_cast<DownloadPartActor*>(this)));
															#line 5322 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int const& bytesRead,int loopDepth) 
	{
															#line 740 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (bytesRead == 0)
															#line 5344 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
															#line 742 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(SevError, "S3ClientDownloadPartUnexpectedEOF") .detail("Expected", resultPart.size) .detail("Actual", totalBytesRead);
															#line 745 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			return a_body1loopBody1Catch1(io_error(), std::max(0, loopDepth - 1));
															#line 5350 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		}
															#line 747 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		totalBytesRead += bytesRead;
															#line 5354 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int && bytesRead,int loopDepth) 
	{
															#line 740 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (bytesRead == 0)
															#line 5363 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
															#line 742 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(SevError, "S3ClientDownloadPartUnexpectedEOF") .detail("Expected", resultPart.size) .detail("Actual", totalBytesRead);
															#line 745 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			return a_body1loopBody1Catch1(io_error(), std::max(0, loopDepth - 1));
															#line 5369 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		}
															#line 747 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		totalBytesRead += bytesRead;
															#line 5373 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(int const& bytesRead,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(bytesRead, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(int && bytesRead,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(std::move(bytesRead), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DownloadPartActor*>(this)->actor_wait_state > 0) static_cast<DownloadPartActor*>(this)->actor_wait_state = 0;
		static_cast<DownloadPartActor*>(this)->ActorCallback< DownloadPartActor, 0, int >::remove();

	}
	void a_callback_fire(ActorCallback< DownloadPartActor, 0, int >*,int const& value) 
	{
		fdb_probe_actor_enter("downloadPart", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DownloadPartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("downloadPart", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DownloadPartActor, 0, int >*,int && value) 
	{
		fdb_probe_actor_enter("downloadPart", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DownloadPartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("downloadPart", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DownloadPartActor, 0, int >*,Error err) 
	{
		fdb_probe_actor_enter("downloadPart", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DownloadPartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("downloadPart", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
															#line 772 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		resultPart.completed = true;
															#line 773 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		TraceEvent(SevDebug, "S3ClientDownloadPartEnd") .detail("Bucket", bucket) .detail("Object", objectName) .detail("PartNumber", part.partNumber) .detail("Offset", resultPart.offset) .detail("Size", resultPart.size) .detail("Attempts", attempt + 1);
															#line 780 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!static_cast<DownloadPartActor*>(this)->SAV<PartState>::futures) { (void)(resultPart); this->~DownloadPartActorState(); static_cast<DownloadPartActor*>(this)->destroy(); return 0; }
															#line 5461 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		new (&static_cast<DownloadPartActor*>(this)->SAV< PartState >::value()) PartState(std::move(resultPart)); // state_var_RVO
		this->~DownloadPartActorState();
		static_cast<DownloadPartActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
															#line 772 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		resultPart.completed = true;
															#line 773 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		TraceEvent(SevDebug, "S3ClientDownloadPartEnd") .detail("Bucket", bucket) .detail("Object", objectName) .detail("PartNumber", part.partNumber) .detail("Offset", resultPart.offset) .detail("Size", resultPart.size) .detail("Attempts", attempt + 1);
															#line 780 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!static_cast<DownloadPartActor*>(this)->SAV<PartState>::futures) { (void)(resultPart); this->~DownloadPartActorState(); static_cast<DownloadPartActor*>(this)->destroy(); return 0; }
															#line 5477 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		new (&static_cast<DownloadPartActor*>(this)->SAV< PartState >::value()) PartState(std::move(resultPart)); // state_var_RVO
		this->~DownloadPartActorState();
		static_cast<DownloadPartActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DownloadPartActor*>(this)->actor_wait_state > 0) static_cast<DownloadPartActor*>(this)->actor_wait_state = 0;
		static_cast<DownloadPartActor*>(this)->ActorCallback< DownloadPartActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DownloadPartActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("downloadPart", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DownloadPartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("downloadPart", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DownloadPartActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("downloadPart", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DownloadPartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("downloadPart", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DownloadPartActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("downloadPart", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DownloadPartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("downloadPart", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
															#line 803 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		delayMs = std::min(delayMs * 2, config.maxRetryDelayMs);
															#line 5564 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
															#line 803 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		delayMs = std::min(delayMs * 2, config.maxRetryDelayMs);
															#line 5573 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<DownloadPartActor*>(this)->actor_wait_state > 0) static_cast<DownloadPartActor*>(this)->actor_wait_state = 0;
		static_cast<DownloadPartActor*>(this)->ActorCallback< DownloadPartActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DownloadPartActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("downloadPart", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DownloadPartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("downloadPart", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< DownloadPartActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("downloadPart", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DownloadPartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("downloadPart", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< DownloadPartActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("downloadPart", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DownloadPartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("downloadPart", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 702 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	Reference<S3BlobStoreEndpoint> endpoint;
															#line 702 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string bucket;
															#line 702 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string objectName;
															#line 702 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	Reference<IAsyncFile> file;
															#line 702 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	PartState part;
															#line 702 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	PartConfig config;
															#line 708 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	PartState resultPart;
															#line 709 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	int attempt;
															#line 710 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	int maxRetries;
															#line 711 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	int delayMs;
															#line 722 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::vector<uint8_t> buffer;
															#line 723 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	int64_t totalBytesRead;
															#line 5677 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
};
// This generated class is to be used only via downloadPart()
															#line 702 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
class DownloadPartActor final : public Actor<PartState>, public ActorCallback< DownloadPartActor, 0, int >, public ActorCallback< DownloadPartActor, 1, Void >, public ActorCallback< DownloadPartActor, 2, Void >, public FastAllocated<DownloadPartActor>, public DownloadPartActorState<DownloadPartActor> {
															#line 5682 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
public:
	using FastAllocated<DownloadPartActor>::operator new;
	using FastAllocated<DownloadPartActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16630590284442543872UL, 1548918660122829056UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<PartState>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DownloadPartActor, 0, int >;
friend struct ActorCallback< DownloadPartActor, 1, Void >;
friend struct ActorCallback< DownloadPartActor, 2, Void >;
															#line 702 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	DownloadPartActor(Reference<S3BlobStoreEndpoint> const& endpoint,std::string const& bucket,std::string const& objectName,Reference<IAsyncFile> const& file,PartState const& part,PartConfig const& config) 
															#line 5701 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		 : Actor<PartState>(),
		   DownloadPartActorState<DownloadPartActor>(endpoint, bucket, objectName, file, part, config),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("downloadPart", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7678294994590579968UL, 4572654359242003456UL);
		ActorExecutionContextHelper __helper(static_cast<DownloadPartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("downloadPart");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("downloadPart", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DownloadPartActor, 0, int >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DownloadPartActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< DownloadPartActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 702 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
[[nodiscard]] static Future<PartState> downloadPart( Reference<S3BlobStoreEndpoint> const& endpoint, std::string const& bucket, std::string const& objectName, Reference<IAsyncFile> const& file, PartState const& part, PartConfig const& config ) {
															#line 702 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	return Future<PartState>(new DownloadPartActor(endpoint, bucket, objectName, file, part, config));
															#line 5736 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
}

#line 807 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"

															#line 5741 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
namespace {
// This generated class is to be used only via getExpectedChecksum()
															#line 808 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
template <class GetExpectedChecksumActor>
															#line 808 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
class GetExpectedChecksumActorState {
															#line 5748 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
public:
															#line 808 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	GetExpectedChecksumActorState(Reference<S3BlobStoreEndpoint> const& endpoint,std::string const& bucket,std::string const& objectName) 
															#line 808 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
															#line 808 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		 : endpoint(endpoint),
															#line 808 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   bucket(bucket),
															#line 808 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   objectName(objectName)
															#line 5759 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
	{
		fdb_probe_actor_create("getExpectedChecksum", reinterpret_cast<unsigned long>(this));

	}
	~GetExpectedChecksumActorState() 
	{
		fdb_probe_actor_destroy("getExpectedChecksum", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 811 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			PartConfig config;
															#line 812 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			StrictFuture<Optional<std::string>> __when_expr_0 = readChecksumWithFallback(endpoint, bucket, objectName, config);
															#line 812 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (static_cast<GetExpectedChecksumActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5778 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetExpectedChecksumActor*>(this)->actor_wait_state = 1;
															#line 812 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetExpectedChecksumActor, 0, Optional<std::string> >*>(static_cast<GetExpectedChecksumActor*>(this)));
															#line 5783 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetExpectedChecksumActorState();
		static_cast<GetExpectedChecksumActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<std::string> const& result,int loopDepth) 
	{
															#line 813 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!static_cast<GetExpectedChecksumActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(result); this->~GetExpectedChecksumActorState(); static_cast<GetExpectedChecksumActor*>(this)->destroy(); return 0; }
															#line 5806 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		new (&static_cast<GetExpectedChecksumActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(result);
		this->~GetExpectedChecksumActorState();
		static_cast<GetExpectedChecksumActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<std::string> && result,int loopDepth) 
	{
															#line 813 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!static_cast<GetExpectedChecksumActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(result); this->~GetExpectedChecksumActorState(); static_cast<GetExpectedChecksumActor*>(this)->destroy(); return 0; }
															#line 5818 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		new (&static_cast<GetExpectedChecksumActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(result);
		this->~GetExpectedChecksumActorState();
		static_cast<GetExpectedChecksumActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Optional<std::string> const& result,int loopDepth) 
	{
		loopDepth = a_body1cont1(result, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<std::string> && result,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetExpectedChecksumActor*>(this)->actor_wait_state > 0) static_cast<GetExpectedChecksumActor*>(this)->actor_wait_state = 0;
		static_cast<GetExpectedChecksumActor*>(this)->ActorCallback< GetExpectedChecksumActor, 0, Optional<std::string> >::remove();

	}
	void a_callback_fire(ActorCallback< GetExpectedChecksumActor, 0, Optional<std::string> >*,Optional<std::string> const& value) 
	{
		fdb_probe_actor_enter("getExpectedChecksum", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetExpectedChecksumActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getExpectedChecksum", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetExpectedChecksumActor, 0, Optional<std::string> >*,Optional<std::string> && value) 
	{
		fdb_probe_actor_enter("getExpectedChecksum", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetExpectedChecksumActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getExpectedChecksum", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetExpectedChecksumActor, 0, Optional<std::string> >*,Error err) 
	{
		fdb_probe_actor_enter("getExpectedChecksum", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetExpectedChecksumActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getExpectedChecksum", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 808 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	Reference<S3BlobStoreEndpoint> endpoint;
															#line 808 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string bucket;
															#line 808 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string objectName;
															#line 5907 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
};
// This generated class is to be used only via getExpectedChecksum()
															#line 808 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
class GetExpectedChecksumActor final : public Actor<Optional<std::string>>, public ActorCallback< GetExpectedChecksumActor, 0, Optional<std::string> >, public FastAllocated<GetExpectedChecksumActor>, public GetExpectedChecksumActorState<GetExpectedChecksumActor> {
															#line 5912 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
public:
	using FastAllocated<GetExpectedChecksumActor>::operator new;
	using FastAllocated<GetExpectedChecksumActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17815084523164786688UL, 16727875375126076416UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Optional<std::string>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetExpectedChecksumActor, 0, Optional<std::string> >;
															#line 808 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	GetExpectedChecksumActor(Reference<S3BlobStoreEndpoint> const& endpoint,std::string const& bucket,std::string const& objectName) 
															#line 5929 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		 : Actor<Optional<std::string>>(),
		   GetExpectedChecksumActorState<GetExpectedChecksumActor>(endpoint, bucket, objectName),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getExpectedChecksum", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(871911475965399040UL, 1400255941565895168UL);
		ActorExecutionContextHelper __helper(static_cast<GetExpectedChecksumActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getExpectedChecksum");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getExpectedChecksum", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetExpectedChecksumActor, 0, Optional<std::string> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 808 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
[[nodiscard]] static Future<Optional<std::string>> getExpectedChecksum( Reference<S3BlobStoreEndpoint> const& endpoint, std::string const& bucket, std::string const& objectName ) {
															#line 808 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	return Future<Optional<std::string>>(new GetExpectedChecksumActor(endpoint, bucket, objectName));
															#line 5962 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
}

#line 815 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"

// Copy down file from s3 to filepath.
															#line 5968 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
namespace {
// This generated class is to be used only via copyDownFile()
															#line 817 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
template <class CopyDownFileActor>
															#line 817 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
class CopyDownFileActorState {
															#line 5975 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
public:
															#line 817 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	CopyDownFileActorState(Reference<S3BlobStoreEndpoint> const& endpoint,std::string const& bucket,std::string const& objectName,std::string const& filepath,PartConfig const& config = PartConfig()) 
															#line 817 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
															#line 817 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		 : endpoint(endpoint),
															#line 817 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   bucket(bucket),
															#line 817 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   objectName(objectName),
															#line 817 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   filepath(filepath),
															#line 817 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   config(config),
															#line 822 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   startTime(now()),
															#line 823 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   file(),
															#line 824 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   parts(),
															#line 825 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   fileSize(0),
															#line 826 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   offset(0),
															#line 827 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   partNumber(1),
															#line 828 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   partSize(),
															#line 829 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   expectedChecksum(),
															#line 830 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   retries(0),
															#line 831 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   maxConcurrentDownloads(),
															#line 832 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   activeDownloadFutures(),
															#line 833 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   activePartIndices()
															#line 6014 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
	{
		fdb_probe_actor_create("copyDownFile", reinterpret_cast<unsigned long>(this));

	}
	~CopyDownFileActorState() 
	{
		fdb_probe_actor_destroy("copyDownFile", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 835 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			;
															#line 6029 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CopyDownFileActorState();
		static_cast<CopyDownFileActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 993 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!static_cast<CopyDownFileActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CopyDownFileActorState(); static_cast<CopyDownFileActor*>(this)->destroy(); return 0; }
															#line 6052 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		new (&static_cast<CopyDownFileActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CopyDownFileActorState();
		static_cast<CopyDownFileActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 837 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(s3VerboseEventSev(), "S3ClientCopyDownFileStart") .detail("Bucket", bucket) .detail("Object", objectName) .detail("FilePath", filepath) .detail("Attempt", retries);
															#line 843 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			StrictFuture<int64_t> __when_expr_0 = endpoint->objectSize(bucket, objectName);
															#line 843 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (static_cast<CopyDownFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6076 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CopyDownFileActor*>(this)->actor_wait_state = 1;
															#line 843 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CopyDownFileActor, 0, int64_t >*>(static_cast<CopyDownFileActor*>(this)));
															#line 6081 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 938 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if ((e.code() == error_code_file_not_found || e.code() == error_code_http_request_failed || e.code() == error_code_io_error) && retries < config.maxFileRetries)
															#line 6116 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			{
															#line 941 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				TraceEvent(SevWarn, "S3ClientCopyDownFileRetry") .errorUnsuppressed(e) .detail("Bucket", bucket) .detail("Object", objectName) .detail("FilePath", filepath) .detail("Retries", retries);
															#line 947 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				retries++;
															#line 950 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				parts.clear();
															#line 951 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				activeDownloadFutures.clear();
															#line 952 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				activePartIndices.clear();
															#line 954 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				if (file)
															#line 6130 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
				{
					try {
															#line 956 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
						file = Reference<IAsyncFile>();
															#line 957 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
						IAsyncFileSystem::filesystem()->deleteFile(filepath, true);
															#line 6137 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
						loopDepth = a_body1loopBody1Catch1cont5(loopDepth);
					}
					catch (Error& error) {
						loopDepth = a_body1loopBody1Catch1Catch1(error, loopDepth);
					} catch (...) {
						loopDepth = a_body1loopBody1Catch1Catch1(unknown_error(), loopDepth);
					}
				}
				else
				{
					loopDepth = a_body1loopBody1Catch1cont2(loopDepth);
				}
			}
			else
			{
															#line 970 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				err = e;
															#line 971 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				TraceEvent(SevWarnAlways, "S3ClientCopyDownFileError") .detail("Bucket", bucket) .detail("ObjectName", objectName) .errorUnsuppressed(err) .detail("FilePath", filepath) .detail("FileSize", fileSize);
															#line 978 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				if (file)
															#line 6159 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
				{
					try {
															#line 980 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
						StrictFuture<Void> __when_expr_11 = file->sync();
															#line 980 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
						if (static_cast<CopyDownFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1Catch2(actor_cancelled(), loopDepth);
															#line 6166 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
						if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1loopBody1Catch1Catch2(__when_expr_11.getError(), loopDepth); else return a_body1loopBody1Catch1when1(__when_expr_11.get(), loopDepth); };
						static_cast<CopyDownFileActor*>(this)->actor_wait_state = 12;
															#line 980 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
						__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< CopyDownFileActor, 11, Void >*>(static_cast<CopyDownFileActor*>(this)));
															#line 6171 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
						loopDepth = 0;
					}
					catch (Error& error) {
						loopDepth = a_body1loopBody1Catch1Catch2(error, loopDepth);
					} catch (...) {
						loopDepth = a_body1loopBody1Catch1Catch2(unknown_error(), loopDepth);
					}
				}
				else
				{
					loopDepth = a_body1loopBody1Catch1cont10(loopDepth);
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int64_t const& s,int loopDepth) 
	{
															#line 844 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (s <= 0)
															#line 6198 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
															#line 845 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(SevWarnAlways, "S3ClientCopyDownFileEmptyFile") .detail("Bucket", bucket) .detail("Object", objectName);
															#line 848 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			return a_body1loopBody1Catch1(file_not_found(), loopDepth);
															#line 6204 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		}
															#line 850 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		fileSize = s;
															#line 852 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		std::string dirPath = filepath.substr(0, filepath.find_last_of("/"));
															#line 853 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!dirPath.empty())
															#line 6212 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
															#line 854 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			platform::createDirectory(dirPath);
															#line 6216 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		}
															#line 857 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		int numParts = (fileSize + config.partSizeBytes - 1) / config.partSizeBytes;
															#line 858 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		parts.reserve(numParts);
															#line 859 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<Reference<IAsyncFile>> __when_expr_1 = IAsyncFileSystem::filesystem()->open( filepath, IAsyncFile::OPEN_CREATE | IAsyncFile::OPEN_READWRITE | IAsyncFile::OPEN_UNCACHED | IAsyncFile::OPEN_ATOMIC_WRITE_AND_CREATE | IAsyncFile::OPEN_NO_AIO, 0644);
															#line 859 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<CopyDownFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6226 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<CopyDownFileActor*>(this)->actor_wait_state = 2;
															#line 859 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CopyDownFileActor, 1, Reference<IAsyncFile> >*>(static_cast<CopyDownFileActor*>(this)));
															#line 6231 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(int64_t && s,int loopDepth) 
	{
															#line 844 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (s <= 0)
															#line 6240 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
															#line 845 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(SevWarnAlways, "S3ClientCopyDownFileEmptyFile") .detail("Bucket", bucket) .detail("Object", objectName);
															#line 848 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			return a_body1loopBody1Catch1(file_not_found(), loopDepth);
															#line 6246 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		}
															#line 850 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		fileSize = s;
															#line 852 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		std::string dirPath = filepath.substr(0, filepath.find_last_of("/"));
															#line 853 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!dirPath.empty())
															#line 6254 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
															#line 854 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			platform::createDirectory(dirPath);
															#line 6258 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		}
															#line 857 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		int numParts = (fileSize + config.partSizeBytes - 1) / config.partSizeBytes;
															#line 858 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		parts.reserve(numParts);
															#line 859 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<Reference<IAsyncFile>> __when_expr_1 = IAsyncFileSystem::filesystem()->open( filepath, IAsyncFile::OPEN_CREATE | IAsyncFile::OPEN_READWRITE | IAsyncFile::OPEN_UNCACHED | IAsyncFile::OPEN_ATOMIC_WRITE_AND_CREATE | IAsyncFile::OPEN_NO_AIO, 0644);
															#line 859 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<CopyDownFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6268 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<CopyDownFileActor*>(this)->actor_wait_state = 2;
															#line 859 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CopyDownFileActor, 1, Reference<IAsyncFile> >*>(static_cast<CopyDownFileActor*>(this)));
															#line 6273 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(int64_t const& s,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(s, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(int64_t && s,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(s), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CopyDownFileActor*>(this)->actor_wait_state > 0) static_cast<CopyDownFileActor*>(this)->actor_wait_state = 0;
		static_cast<CopyDownFileActor*>(this)->ActorCallback< CopyDownFileActor, 0, int64_t >::remove();

	}
	void a_callback_fire(ActorCallback< CopyDownFileActor, 0, int64_t >*,int64_t const& value) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CopyDownFileActor, 0, int64_t >*,int64_t && value) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CopyDownFileActor, 0, int64_t >*,Error err) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Reference<IAsyncFile> const& f,int loopDepth) 
	{
															#line 864 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		file = f;
															#line 866 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<Void> __when_expr_2 = file->truncate(fileSize);
															#line 866 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<CopyDownFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6361 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<CopyDownFileActor*>(this)->actor_wait_state = 3;
															#line 866 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CopyDownFileActor, 2, Void >*>(static_cast<CopyDownFileActor*>(this)));
															#line 6366 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Reference<IAsyncFile> && f,int loopDepth) 
	{
															#line 864 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		file = f;
															#line 866 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<Void> __when_expr_2 = file->truncate(fileSize);
															#line 866 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<CopyDownFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6379 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<CopyDownFileActor*>(this)->actor_wait_state = 3;
															#line 866 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CopyDownFileActor, 2, Void >*>(static_cast<CopyDownFileActor*>(this)));
															#line 6384 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Reference<IAsyncFile> const& f,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(f, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Reference<IAsyncFile> && f,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(f), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CopyDownFileActor*>(this)->actor_wait_state > 0) static_cast<CopyDownFileActor*>(this)->actor_wait_state = 0;
		static_cast<CopyDownFileActor*>(this)->ActorCallback< CopyDownFileActor, 1, Reference<IAsyncFile> >::remove();

	}
	void a_callback_fire(ActorCallback< CopyDownFileActor, 1, Reference<IAsyncFile> >*,Reference<IAsyncFile> const& value) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CopyDownFileActor, 1, Reference<IAsyncFile> >*,Reference<IAsyncFile> && value) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CopyDownFileActor, 1, Reference<IAsyncFile> >*,Error err) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont6(Void const& _,int loopDepth) 
	{
															#line 867 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<Void> __when_expr_3 = file->truncate(fileSize);
															#line 867 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<CopyDownFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6470 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont6when1(__when_expr_3.get(), loopDepth); };
		static_cast<CopyDownFileActor*>(this)->actor_wait_state = 4;
															#line 867 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CopyDownFileActor, 3, Void >*>(static_cast<CopyDownFileActor*>(this)));
															#line 6475 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void && _,int loopDepth) 
	{
															#line 867 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<Void> __when_expr_3 = file->truncate(fileSize);
															#line 867 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<CopyDownFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6486 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont6when1(__when_expr_3.get(), loopDepth); };
		static_cast<CopyDownFileActor*>(this)->actor_wait_state = 4;
															#line 867 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CopyDownFileActor, 3, Void >*>(static_cast<CopyDownFileActor*>(this)));
															#line 6491 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CopyDownFileActor*>(this)->actor_wait_state > 0) static_cast<CopyDownFileActor*>(this)->actor_wait_state = 0;
		static_cast<CopyDownFileActor*>(this)->ActorCallback< CopyDownFileActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CopyDownFileActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CopyDownFileActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CopyDownFileActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont7(Void const& _,int loopDepth) 
	{
															#line 869 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		offset = 0;
															#line 870 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		partNumber = 1;
															#line 871 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		maxConcurrentDownloads = CLIENT_KNOBS->BLOBSTORE_CONCURRENT_READS_PER_FILE;
															#line 872 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		activeDownloadFutures.clear();
															#line 873 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		activePartIndices.clear();
															#line 876 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		;
															#line 6585 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = a_body1loopBody1cont7loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont7(Void && _,int loopDepth) 
	{
															#line 869 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		offset = 0;
															#line 870 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		partNumber = 1;
															#line 871 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		maxConcurrentDownloads = CLIENT_KNOBS->BLOBSTORE_CONCURRENT_READS_PER_FILE;
															#line 872 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		activeDownloadFutures.clear();
															#line 873 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		activePartIndices.clear();
															#line 876 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		;
															#line 6604 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = a_body1loopBody1cont7loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<CopyDownFileActor*>(this)->actor_wait_state > 0) static_cast<CopyDownFileActor*>(this)->actor_wait_state = 0;
		static_cast<CopyDownFileActor*>(this)->ActorCallback< CopyDownFileActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CopyDownFileActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< CopyDownFileActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< CopyDownFileActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont8(int loopDepth) 
	{
															#line 902 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		for( const auto& part : parts ) {
															#line 903 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (!part.completed)
															#line 6690 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			{
															#line 904 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				TraceEvent(SevError, "S3ClientCopyDownFilePartNotCompleted").detail("PartNumber", part.partNumber);
															#line 905 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				return a_body1loopBody1Catch1(http_bad_response(), loopDepth);
															#line 6696 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			}
		}
															#line 909 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<Void> __when_expr_5 = file->truncate(fileSize);
															#line 909 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<CopyDownFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6703 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1loopBody1cont8when1(__when_expr_5.get(), loopDepth); };
		static_cast<CopyDownFileActor*>(this)->actor_wait_state = 6;
															#line 909 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< CopyDownFileActor, 5, Void >*>(static_cast<CopyDownFileActor*>(this)));
															#line 6708 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont7loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont7loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont7loopBody1(int loopDepth) 
	{
															#line 876 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!(offset < fileSize))
															#line 6724 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
			return a_body1loopBody1cont7break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 878 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		for(;activeDownloadFutures.size() < maxConcurrentDownloads && offset < fileSize;) {
															#line 879 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			partSize = std::min(config.partSizeBytes, fileSize - offset);
															#line 880 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			parts.emplace_back(partNumber, offset, partSize, "");
															#line 881 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			activeDownloadFutures.push_back( downloadPart(endpoint, bucket, objectName, file, parts.back(), config));
															#line 883 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			activePartIndices.push_back(partNumber - 1);
															#line 884 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			offset += partSize;
															#line 885 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			partNumber++;
															#line 6742 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		}
															#line 889 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!activeDownloadFutures.empty())
															#line 6746 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
															#line 890 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			StrictFuture<std::vector<PartState>> __when_expr_4 = getAll(activeDownloadFutures);
															#line 890 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (static_cast<CopyDownFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6752 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1loopBody1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont7loopBody1when1(__when_expr_4.get(), loopDepth); };
			static_cast<CopyDownFileActor*>(this)->actor_wait_state = 5;
															#line 890 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< CopyDownFileActor, 4, std::vector<PartState> >*>(static_cast<CopyDownFileActor*>(this)));
															#line 6757 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont7loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont7break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont8(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont7loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont7loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont7loopBody1cont4(std::vector<PartState> const& completedParts,int loopDepth) 
	{
															#line 892 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		for(int i = 0;i < completedParts.size();i++) {
															#line 893 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			parts[activePartIndices[i]] = completedParts[i];
															#line 6792 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		}
															#line 896 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		activeDownloadFutures.clear();
															#line 897 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		activePartIndices.clear();
															#line 6798 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = a_body1loopBody1cont7loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont7loopBody1cont4(std::vector<PartState> && completedParts,int loopDepth) 
	{
															#line 892 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		for(int i = 0;i < completedParts.size();i++) {
															#line 893 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			parts[activePartIndices[i]] = completedParts[i];
															#line 6809 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		}
															#line 896 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		activeDownloadFutures.clear();
															#line 897 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		activePartIndices.clear();
															#line 6815 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = a_body1loopBody1cont7loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont7loopBody1when1(std::vector<PartState> const& completedParts,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7loopBody1cont4(completedParts, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont7loopBody1when1(std::vector<PartState> && completedParts,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7loopBody1cont4(std::move(completedParts), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<CopyDownFileActor*>(this)->actor_wait_state > 0) static_cast<CopyDownFileActor*>(this)->actor_wait_state = 0;
		static_cast<CopyDownFileActor*>(this)->ActorCallback< CopyDownFileActor, 4, std::vector<PartState> >::remove();

	}
	void a_callback_fire(ActorCallback< CopyDownFileActor, 4, std::vector<PartState> >*,std::vector<PartState> const& value) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont7loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< CopyDownFileActor, 4, std::vector<PartState> >*,std::vector<PartState> && value) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont7loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< CopyDownFileActor, 4, std::vector<PartState> >*,Error err) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1loopBody1cont9(Void const& _,int loopDepth) 
	{
															#line 910 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<Void> __when_expr_6 = file->sync();
															#line 910 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<CopyDownFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6901 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1loopBody1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1loopBody1cont9when1(__when_expr_6.get(), loopDepth); };
		static_cast<CopyDownFileActor*>(this)->actor_wait_state = 7;
															#line 910 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< CopyDownFileActor, 6, Void >*>(static_cast<CopyDownFileActor*>(this)));
															#line 6906 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont9(Void && _,int loopDepth) 
	{
															#line 910 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<Void> __when_expr_6 = file->sync();
															#line 910 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<CopyDownFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6917 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1loopBody1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1loopBody1cont9when1(__when_expr_6.get(), loopDepth); };
		static_cast<CopyDownFileActor*>(this)->actor_wait_state = 7;
															#line 910 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< CopyDownFileActor, 6, Void >*>(static_cast<CopyDownFileActor*>(this)));
															#line 6922 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont8when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont8when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<CopyDownFileActor*>(this)->actor_wait_state > 0) static_cast<CopyDownFileActor*>(this)->actor_wait_state = 0;
		static_cast<CopyDownFileActor*>(this)->ActorCallback< CopyDownFileActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CopyDownFileActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< CopyDownFileActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< CopyDownFileActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1loopBody1cont12(Void const& _,int loopDepth) 
	{
															#line 913 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<Optional<std::string>> __when_expr_7 = getExpectedChecksum(endpoint, bucket, objectName);
															#line 913 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<CopyDownFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7008 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1loopBody1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1loopBody1cont12when1(__when_expr_7.get(), loopDepth); };
		static_cast<CopyDownFileActor*>(this)->actor_wait_state = 8;
															#line 913 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< CopyDownFileActor, 7, Optional<std::string> >*>(static_cast<CopyDownFileActor*>(this)));
															#line 7013 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont12(Void && _,int loopDepth) 
	{
															#line 913 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<Optional<std::string>> __when_expr_7 = getExpectedChecksum(endpoint, bucket, objectName);
															#line 913 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<CopyDownFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7024 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1loopBody1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1loopBody1cont12when1(__when_expr_7.get(), loopDepth); };
		static_cast<CopyDownFileActor*>(this)->actor_wait_state = 8;
															#line 913 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< CopyDownFileActor, 7, Optional<std::string> >*>(static_cast<CopyDownFileActor*>(this)));
															#line 7029 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont9when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont12(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont9when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont12(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<CopyDownFileActor*>(this)->actor_wait_state > 0) static_cast<CopyDownFileActor*>(this)->actor_wait_state = 0;
		static_cast<CopyDownFileActor*>(this)->ActorCallback< CopyDownFileActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CopyDownFileActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1cont9when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< CopyDownFileActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1cont9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< CopyDownFileActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1loopBody1cont12cont1(Optional<std::string> const& cs,int loopDepth) 
	{
															#line 915 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (cs.present())
															#line 7113 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
															#line 916 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			expectedChecksum = cs.get();
															#line 917 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			StrictFuture<std::string> __when_expr_8 = calculateFileChecksum(file, fileSize);
															#line 917 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (static_cast<CopyDownFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7121 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1loopBody1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1loopBody1cont12cont1when1(__when_expr_8.get(), loopDepth); };
			static_cast<CopyDownFileActor*>(this)->actor_wait_state = 9;
															#line 917 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< CopyDownFileActor, 8, std::string >*>(static_cast<CopyDownFileActor*>(this)));
															#line 7126 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont12cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont12cont1(Optional<std::string> && cs,int loopDepth) 
	{
															#line 915 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (cs.present())
															#line 7140 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
															#line 916 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			expectedChecksum = cs.get();
															#line 917 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			StrictFuture<std::string> __when_expr_8 = calculateFileChecksum(file, fileSize);
															#line 917 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (static_cast<CopyDownFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7148 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1loopBody1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1loopBody1cont12cont1when1(__when_expr_8.get(), loopDepth); };
			static_cast<CopyDownFileActor*>(this)->actor_wait_state = 9;
															#line 917 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< CopyDownFileActor, 8, std::string >*>(static_cast<CopyDownFileActor*>(this)));
															#line 7153 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont12cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont12when1(Optional<std::string> const& cs,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont12cont1(cs, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont12when1(Optional<std::string> && cs,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont12cont1(std::move(cs), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<CopyDownFileActor*>(this)->actor_wait_state > 0) static_cast<CopyDownFileActor*>(this)->actor_wait_state = 0;
		static_cast<CopyDownFileActor*>(this)->ActorCallback< CopyDownFileActor, 7, Optional<std::string> >::remove();

	}
	void a_callback_fire(ActorCallback< CopyDownFileActor, 7, Optional<std::string> >*,Optional<std::string> const& value) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1loopBody1cont12when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< CopyDownFileActor, 7, Optional<std::string> >*,Optional<std::string> && value) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1loopBody1cont12when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< CopyDownFileActor, 7, Optional<std::string> >*,Error err) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1loopBody1cont12cont2(int loopDepth) 
	{
															#line 926 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		file = Reference<IAsyncFile>();
															#line 928 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		TraceEvent(s3VerboseEventSev(), "S3ClientCopyDownFileEnd") .detail("Bucket", bucket) .detail("ObjectName", objectName) .detail("FileSize", fileSize) .detail("Duration", now() - startTime) .detail("Checksum", expectedChecksum) .detail("Parts", parts.size());
															#line 7244 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont12cont3(int loopDepth) 
	{
															#line 918 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (actualChecksum != expectedChecksum)
															#line 7253 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
															#line 919 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(SevWarnAlways, "S3ClientCopyDownFileChecksumMismatch") .detail("Expected", expectedChecksum) .detail("Calculated", actualChecksum);
															#line 922 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			return a_body1loopBody1Catch1(checksum_failed(), loopDepth);
															#line 7259 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont12cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont12cont1when1(std::string const& __actualChecksum,int loopDepth) 
	{
															#line 917 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		actualChecksum = __actualChecksum;
															#line 7269 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = a_body1loopBody1cont12cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont12cont1when1(std::string && __actualChecksum,int loopDepth) 
	{
		actualChecksum = std::move(__actualChecksum);
		loopDepth = a_body1loopBody1cont12cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<CopyDownFileActor*>(this)->actor_wait_state > 0) static_cast<CopyDownFileActor*>(this)->actor_wait_state = 0;
		static_cast<CopyDownFileActor*>(this)->ActorCallback< CopyDownFileActor, 8, std::string >::remove();

	}
	void a_callback_fire(ActorCallback< CopyDownFileActor, 8, std::string >*,std::string const& value) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1loopBody1cont12cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< CopyDownFileActor, 8, std::string >*,std::string && value) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1loopBody1cont12cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< CopyDownFileActor, 8, std::string >*,Error err) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1loopBody1Catch1cont1(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2(int loopDepth) 
	{
															#line 964 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (g_network->isSimulated())
															#line 7354 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
															#line 965 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			StrictFuture<Void> __when_expr_9 = delay(0);
															#line 965 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (static_cast<CopyDownFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7360 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1cont2when1(__when_expr_9.get(), loopDepth); };
			static_cast<CopyDownFileActor*>(this)->actor_wait_state = 10;
															#line 965 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< CopyDownFileActor, 9, Void >*>(static_cast<CopyDownFileActor*>(this)));
															#line 7365 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1Catch1cont6(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont3(int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1Catch1(const Error& cleanupError,int loopDepth=0) 
	{
		try {
															#line 959 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(SevWarnAlways, "S3ClientCopyDownFileCleanupError") .detail("FilePath", filepath) .errorUnsuppressed(cleanupError);
															#line 7386 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			loopDepth = a_body1loopBody1Catch1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1Catch1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont6(int loopDepth) 
	{
															#line 968 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<Void> __when_expr_10 = delay(1.0 * retries);
															#line 968 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<CopyDownFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7416 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1Catch1(__when_expr_10.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1cont6when1(__when_expr_10.get(), loopDepth); };
		static_cast<CopyDownFileActor*>(this)->actor_wait_state = 11;
															#line 968 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< CopyDownFileActor, 10, Void >*>(static_cast<CopyDownFileActor*>(this)));
															#line 7421 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont7(Void const& _,int loopDepth) 
	{
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont7(Void && _,int loopDepth) 
	{
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<CopyDownFileActor*>(this)->actor_wait_state > 0) static_cast<CopyDownFileActor*>(this)->actor_wait_state = 0;
		static_cast<CopyDownFileActor*>(this)->ActorCallback< CopyDownFileActor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CopyDownFileActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1loopBody1Catch1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< CopyDownFileActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1loopBody1Catch1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< CopyDownFileActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1loopBody1Catch1cont9(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont9(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose11() 
	{
		if (static_cast<CopyDownFileActor*>(this)->actor_wait_state > 0) static_cast<CopyDownFileActor*>(this)->actor_wait_state = 0;
		static_cast<CopyDownFileActor*>(this)->ActorCallback< CopyDownFileActor, 10, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CopyDownFileActor, 10, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1loopBody1Catch1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< CopyDownFileActor, 10, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1loopBody1Catch1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< CopyDownFileActor, 10, Void >*,Error err) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 10);

	}
	int a_body1loopBody1Catch1cont10(int loopDepth) 
	{
															#line 989 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		return a_body1Catch1(err, std::max(0, loopDepth - 1));
															#line 7604 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont11(int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1Catch2(const Error& e2,int loopDepth=0) 
	{
		try {
															#line 984 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(SevWarnAlways, "S3ClientCopyDownFileCleanupError") .detail("FilePath", filepath) .errorUnsuppressed(e2);
															#line 7619 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			loopDepth = a_body1loopBody1Catch1cont11(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont12(Void const& _,int loopDepth) 
	{
															#line 981 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		file = Reference<IAsyncFile>();
															#line 982 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		IAsyncFileSystem::filesystem()->deleteFile(filepath, false);
															#line 7636 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = a_body1loopBody1Catch1cont12cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont12(Void && _,int loopDepth) 
	{
															#line 981 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		file = Reference<IAsyncFile>();
															#line 982 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		IAsyncFileSystem::filesystem()->deleteFile(filepath, false);
															#line 7647 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = a_body1loopBody1Catch1cont12cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont12(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont12(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose12() 
	{
		if (static_cast<CopyDownFileActor*>(this)->actor_wait_state > 0) static_cast<CopyDownFileActor*>(this)->actor_wait_state = 0;
		static_cast<CopyDownFileActor*>(this)->ActorCallback< CopyDownFileActor, 11, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CopyDownFileActor, 11, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1Catch2(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorCallback< CopyDownFileActor, 11, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1Catch2(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_error(ActorCallback< CopyDownFileActor, 11, Void >*,Error err) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1loopBody1Catch1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1Catch2(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 11);

	}
	int a_body1loopBody1Catch1cont12cont2(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1Catch1cont11(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 817 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	Reference<S3BlobStoreEndpoint> endpoint;
															#line 817 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string bucket;
															#line 817 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string objectName;
															#line 817 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string filepath;
															#line 817 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	PartConfig config;
															#line 822 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	double startTime;
															#line 823 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	Reference<IAsyncFile> file;
															#line 824 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::vector<PartState> parts;
															#line 825 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	int64_t fileSize;
															#line 826 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	int64_t offset;
															#line 827 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	int partNumber;
															#line 828 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	int64_t partSize;
															#line 829 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string expectedChecksum;
															#line 830 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	int retries;
															#line 831 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	int maxConcurrentDownloads;
															#line 832 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::vector<Future<PartState>> activeDownloadFutures;
															#line 833 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::vector<int> activePartIndices;
															#line 917 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string actualChecksum;
															#line 970 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	Error err;
															#line 7778 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
};
// This generated class is to be used only via copyDownFile()
															#line 817 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
class CopyDownFileActor final : public Actor<Void>, public ActorCallback< CopyDownFileActor, 0, int64_t >, public ActorCallback< CopyDownFileActor, 1, Reference<IAsyncFile> >, public ActorCallback< CopyDownFileActor, 2, Void >, public ActorCallback< CopyDownFileActor, 3, Void >, public ActorCallback< CopyDownFileActor, 4, std::vector<PartState> >, public ActorCallback< CopyDownFileActor, 5, Void >, public ActorCallback< CopyDownFileActor, 6, Void >, public ActorCallback< CopyDownFileActor, 7, Optional<std::string> >, public ActorCallback< CopyDownFileActor, 8, std::string >, public ActorCallback< CopyDownFileActor, 9, Void >, public ActorCallback< CopyDownFileActor, 10, Void >, public ActorCallback< CopyDownFileActor, 11, Void >, public FastAllocated<CopyDownFileActor>, public CopyDownFileActorState<CopyDownFileActor> {
															#line 7783 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
public:
	using FastAllocated<CopyDownFileActor>::operator new;
	using FastAllocated<CopyDownFileActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7070236765059331840UL, 17868524166764789504UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CopyDownFileActor, 0, int64_t >;
friend struct ActorCallback< CopyDownFileActor, 1, Reference<IAsyncFile> >;
friend struct ActorCallback< CopyDownFileActor, 2, Void >;
friend struct ActorCallback< CopyDownFileActor, 3, Void >;
friend struct ActorCallback< CopyDownFileActor, 4, std::vector<PartState> >;
friend struct ActorCallback< CopyDownFileActor, 5, Void >;
friend struct ActorCallback< CopyDownFileActor, 6, Void >;
friend struct ActorCallback< CopyDownFileActor, 7, Optional<std::string> >;
friend struct ActorCallback< CopyDownFileActor, 8, std::string >;
friend struct ActorCallback< CopyDownFileActor, 9, Void >;
friend struct ActorCallback< CopyDownFileActor, 10, Void >;
friend struct ActorCallback< CopyDownFileActor, 11, Void >;
															#line 817 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	CopyDownFileActor(Reference<S3BlobStoreEndpoint> const& endpoint,std::string const& bucket,std::string const& objectName,std::string const& filepath,PartConfig const& config = PartConfig()) 
															#line 7811 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		 : Actor<Void>(),
		   CopyDownFileActorState<CopyDownFileActor>(endpoint, bucket, objectName, filepath, config),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7359276511881238784UL, 3382961653916387328UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("copyDownFile");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CopyDownFileActor, 0, int64_t >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CopyDownFileActor, 1, Reference<IAsyncFile> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CopyDownFileActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< CopyDownFileActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< CopyDownFileActor, 4, std::vector<PartState> >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< CopyDownFileActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< CopyDownFileActor, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< CopyDownFileActor, 7, Optional<std::string> >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< CopyDownFileActor, 8, std::string >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< CopyDownFileActor, 9, Void >*)0, actor_cancelled()); break;
		case 11: this->a_callback_error((ActorCallback< CopyDownFileActor, 10, Void >*)0, actor_cancelled()); break;
		case 12: this->a_callback_error((ActorCallback< CopyDownFileActor, 11, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 817 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
[[nodiscard]] static Future<Void> copyDownFile( Reference<S3BlobStoreEndpoint> const& endpoint, std::string const& bucket, std::string const& objectName, std::string const& filepath, PartConfig const& config = PartConfig() ) {
															#line 817 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	return Future<Void>(new CopyDownFileActor(endpoint, bucket, objectName, filepath, config));
															#line 7855 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
}

#line 995 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"

															#line 7860 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
namespace {
// This generated class is to be used only via copyDownFile()
															#line 996 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
template <class CopyDownFileActor1>
															#line 996 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
class CopyDownFileActor1State {
															#line 7867 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
public:
															#line 996 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	CopyDownFileActor1State(std::string const& s3url,std::string const& filepath) 
															#line 996 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
															#line 996 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		 : s3url(s3url),
															#line 996 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   filepath(filepath)
															#line 7876 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
	{
		fdb_probe_actor_create("copyDownFile", reinterpret_cast<unsigned long>(this));

	}
	~CopyDownFileActor1State() 
	{
		fdb_probe_actor_destroy("copyDownFile", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 997 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			std::string resource;
															#line 998 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			S3BlobStoreEndpoint::ParametersT parameters;
															#line 999 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			Reference<S3BlobStoreEndpoint> endpoint = getEndpoint(s3url, resource, parameters);
															#line 1000 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			StrictFuture<Void> __when_expr_0 = copyDownFile(endpoint, parameters["bucket"], resource, filepath);
															#line 1000 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (static_cast<CopyDownFileActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7899 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CopyDownFileActor1*>(this)->actor_wait_state = 1;
															#line 1000 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CopyDownFileActor1, 0, Void >*>(static_cast<CopyDownFileActor1*>(this)));
															#line 7904 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CopyDownFileActor1State();
		static_cast<CopyDownFileActor1*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1001 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!static_cast<CopyDownFileActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CopyDownFileActor1State(); static_cast<CopyDownFileActor1*>(this)->destroy(); return 0; }
															#line 7927 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		new (&static_cast<CopyDownFileActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~CopyDownFileActor1State();
		static_cast<CopyDownFileActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1001 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!static_cast<CopyDownFileActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CopyDownFileActor1State(); static_cast<CopyDownFileActor1*>(this)->destroy(); return 0; }
															#line 7939 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		new (&static_cast<CopyDownFileActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~CopyDownFileActor1State();
		static_cast<CopyDownFileActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CopyDownFileActor1*>(this)->actor_wait_state > 0) static_cast<CopyDownFileActor1*>(this)->actor_wait_state = 0;
		static_cast<CopyDownFileActor1*>(this)->ActorCallback< CopyDownFileActor1, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CopyDownFileActor1, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CopyDownFileActor1, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CopyDownFileActor1, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 996 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string s3url;
															#line 996 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string filepath;
															#line 8026 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
};
// This generated class is to be used only via copyDownFile()
															#line 996 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
class CopyDownFileActor1 final : public Actor<Void>, public ActorCallback< CopyDownFileActor1, 0, Void >, public FastAllocated<CopyDownFileActor1>, public CopyDownFileActor1State<CopyDownFileActor1> {
															#line 8031 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
public:
	using FastAllocated<CopyDownFileActor1>::operator new;
	using FastAllocated<CopyDownFileActor1>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7070236765059331840UL, 17868524166764789504UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CopyDownFileActor1, 0, Void >;
															#line 996 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	CopyDownFileActor1(std::string const& s3url,std::string const& filepath) 
															#line 8048 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		 : Actor<Void>(),
		   CopyDownFileActor1State<CopyDownFileActor1>(s3url, filepath),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17010639406587595520UL, 2888716185831900672UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("copyDownFile");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CopyDownFileActor1, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 996 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
[[nodiscard]] Future<Void> copyDownFile( std::string const& s3url, std::string const& filepath ) {
															#line 996 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	return Future<Void>(new CopyDownFileActor1(s3url, filepath));
															#line 8081 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
}

#line 1003 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"

															#line 8086 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
namespace {
// This generated class is to be used only via copyDownDirectory()
															#line 1004 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
template <class CopyDownDirectoryActor>
															#line 1004 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
class CopyDownDirectoryActorState {
															#line 8093 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
public:
															#line 1004 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	CopyDownDirectoryActorState(std::string const& s3url,std::string const& dirpath) 
															#line 1004 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
															#line 1004 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		 : s3url(s3url),
															#line 1004 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   dirpath(dirpath),
															#line 1005 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   resource()
															#line 8104 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
	{
		fdb_probe_actor_create("copyDownDirectory", reinterpret_cast<unsigned long>(this));

	}
	~CopyDownDirectoryActorState() 
	{
		fdb_probe_actor_destroy("copyDownDirectory", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1006 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			S3BlobStoreEndpoint::ParametersT parameters;
															#line 1007 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			endpoint = getEndpoint(s3url, resource, parameters);
															#line 1008 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			bucket = parameters["bucket"];
															#line 1009 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			StrictFuture<S3BlobStoreEndpoint::ListResult> __when_expr_0 = endpoint->listObjects(bucket, resource);
															#line 1009 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (static_cast<CopyDownDirectoryActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8127 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CopyDownDirectoryActor*>(this)->actor_wait_state = 1;
															#line 1009 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CopyDownDirectoryActor, 0, S3BlobStoreEndpoint::ListResult >*>(static_cast<CopyDownDirectoryActor*>(this)));
															#line 8132 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CopyDownDirectoryActorState();
		static_cast<CopyDownDirectoryActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(S3BlobStoreEndpoint::ListResult const& items,int loopDepth) 
	{
															#line 1010 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		objects = items.objects;
															#line 1011 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		TraceEvent(s3VerboseEventSev(), "S3ClientDownDirectoryStart") .detail("Filecount", objects.size()) .detail("Bucket", bucket) .detail("Resource", resource);
															#line 1015 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		RangeForbody1cont1Iterator0 = std::begin(objects);
															#line 8159 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(S3BlobStoreEndpoint::ListResult && items,int loopDepth) 
	{
															#line 1010 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		objects = items.objects;
															#line 1011 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		TraceEvent(s3VerboseEventSev(), "S3ClientDownDirectoryStart") .detail("Filecount", objects.size()) .detail("Bucket", bucket) .detail("Resource", resource);
															#line 1015 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		RangeForbody1cont1Iterator0 = std::begin(objects);
															#line 8172 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(S3BlobStoreEndpoint::ListResult const& items,int loopDepth) 
	{
		loopDepth = a_body1cont1(items, loopDepth);

		return loopDepth;
	}
	int a_body1when1(S3BlobStoreEndpoint::ListResult && items,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(items), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CopyDownDirectoryActor*>(this)->actor_wait_state > 0) static_cast<CopyDownDirectoryActor*>(this)->actor_wait_state = 0;
		static_cast<CopyDownDirectoryActor*>(this)->ActorCallback< CopyDownDirectoryActor, 0, S3BlobStoreEndpoint::ListResult >::remove();

	}
	void a_callback_fire(ActorCallback< CopyDownDirectoryActor, 0, S3BlobStoreEndpoint::ListResult >*,S3BlobStoreEndpoint::ListResult const& value) 
	{
		fdb_probe_actor_enter("copyDownDirectory", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownDirectoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownDirectory", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CopyDownDirectoryActor, 0, S3BlobStoreEndpoint::ListResult >*,S3BlobStoreEndpoint::ListResult && value) 
	{
		fdb_probe_actor_enter("copyDownDirectory", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownDirectoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownDirectory", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CopyDownDirectoryActor, 0, S3BlobStoreEndpoint::ListResult >*,Error err) 
	{
		fdb_probe_actor_enter("copyDownDirectory", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownDirectoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownDirectory", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 1020 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		TraceEvent(s3VerboseEventSev(), "S3ClientDownDirectoryEnd").detail("Bucket", bucket).detail("Resource", resource);
															#line 1021 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!static_cast<CopyDownDirectoryActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CopyDownDirectoryActorState(); static_cast<CopyDownDirectoryActor*>(this)->destroy(); return 0; }
															#line 8258 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		new (&static_cast<CopyDownDirectoryActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CopyDownDirectoryActorState();
		static_cast<CopyDownDirectoryActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 1015 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!(RangeForbody1cont1Iterator0 != std::end(objects)))
															#line 8277 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1015 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		const auto& object = *RangeForbody1cont1Iterator0;
															#line 8283 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
															#line 1016 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			std::string filepath = dirpath + "/" + object.name.substr(resource.size());
															#line 1017 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			std::string s3path = object.name;
															#line 1018 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			StrictFuture<Void> __when_expr_1 = copyDownFile(endpoint, bucket, s3path, filepath);
															#line 1018 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (static_cast<CopyDownDirectoryActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8293 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<CopyDownDirectoryActor*>(this)->actor_wait_state = 2;
															#line 1018 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CopyDownDirectoryActor, 1, Void >*>(static_cast<CopyDownDirectoryActor*>(this)));
															#line 8298 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
															#line 1015 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		++RangeForbody1cont1Iterator0;
															#line 8321 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CopyDownDirectoryActor*>(this)->actor_wait_state > 0) static_cast<CopyDownDirectoryActor*>(this)->actor_wait_state = 0;
		static_cast<CopyDownDirectoryActor*>(this)->ActorCallback< CopyDownDirectoryActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CopyDownDirectoryActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("copyDownDirectory", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownDirectoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownDirectory", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CopyDownDirectoryActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("copyDownDirectory", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownDirectoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownDirectory", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CopyDownDirectoryActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("copyDownDirectory", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownDirectoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownDirectory", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1004 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string s3url;
															#line 1004 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string dirpath;
															#line 1005 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string resource;
															#line 1007 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	Reference<S3BlobStoreEndpoint> endpoint;
															#line 1008 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string bucket;
															#line 1010 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::vector<S3BlobStoreEndpoint::ObjectInfo> objects;
															#line 1015 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	decltype(std::begin(std::declval<std::vector<S3BlobStoreEndpoint::ObjectInfo>>())) RangeForbody1cont1Iterator0;
															#line 8427 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
};
// This generated class is to be used only via copyDownDirectory()
															#line 1004 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
class CopyDownDirectoryActor final : public Actor<Void>, public ActorCallback< CopyDownDirectoryActor, 0, S3BlobStoreEndpoint::ListResult >, public ActorCallback< CopyDownDirectoryActor, 1, Void >, public FastAllocated<CopyDownDirectoryActor>, public CopyDownDirectoryActorState<CopyDownDirectoryActor> {
															#line 8432 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
public:
	using FastAllocated<CopyDownDirectoryActor>::operator new;
	using FastAllocated<CopyDownDirectoryActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14853426593148681984UL, 7438575562770153216UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CopyDownDirectoryActor, 0, S3BlobStoreEndpoint::ListResult >;
friend struct ActorCallback< CopyDownDirectoryActor, 1, Void >;
															#line 1004 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	CopyDownDirectoryActor(std::string const& s3url,std::string const& dirpath) 
															#line 8450 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		 : Actor<Void>(),
		   CopyDownDirectoryActorState<CopyDownDirectoryActor>(s3url, dirpath),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("copyDownDirectory", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10236592472061799424UL, 16660351427764155904UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownDirectoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("copyDownDirectory");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("copyDownDirectory", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CopyDownDirectoryActor, 0, S3BlobStoreEndpoint::ListResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CopyDownDirectoryActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1004 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
[[nodiscard]] Future<Void> copyDownDirectory( std::string const& s3url, std::string const& dirpath ) {
															#line 1004 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	return Future<Void>(new CopyDownDirectoryActor(s3url, dirpath));
															#line 8484 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
}

#line 1023 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"

															#line 8489 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
namespace {
// This generated class is to be used only via deleteResource()
															#line 1024 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
template <class DeleteResourceActor>
															#line 1024 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
class DeleteResourceActorState {
															#line 8496 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
public:
															#line 1024 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	DeleteResourceActorState(std::string const& s3url) 
															#line 1024 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
															#line 1024 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		 : s3url(s3url),
															#line 1025 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   resource()
															#line 8505 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
	{
		fdb_probe_actor_create("deleteResource", reinterpret_cast<unsigned long>(this));

	}
	~DeleteResourceActorState() 
	{
		fdb_probe_actor_destroy("deleteResource", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1026 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			S3BlobStoreEndpoint::ParametersT parameters;
															#line 1027 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			Reference<S3BlobStoreEndpoint> endpoint = getEndpoint(s3url, resource, parameters);
															#line 1028 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			bucket = parameters["bucket"];
															#line 1029 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			StrictFuture<Void> __when_expr_0 = endpoint->deleteRecursively(bucket, resource);
															#line 1029 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (static_cast<DeleteResourceActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8528 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DeleteResourceActor*>(this)->actor_wait_state = 1;
															#line 1029 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DeleteResourceActor, 0, Void >*>(static_cast<DeleteResourceActor*>(this)));
															#line 8533 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DeleteResourceActorState();
		static_cast<DeleteResourceActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1030 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!static_cast<DeleteResourceActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DeleteResourceActorState(); static_cast<DeleteResourceActor*>(this)->destroy(); return 0; }
															#line 8556 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		new (&static_cast<DeleteResourceActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DeleteResourceActorState();
		static_cast<DeleteResourceActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1030 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!static_cast<DeleteResourceActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DeleteResourceActorState(); static_cast<DeleteResourceActor*>(this)->destroy(); return 0; }
															#line 8568 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		new (&static_cast<DeleteResourceActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DeleteResourceActorState();
		static_cast<DeleteResourceActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DeleteResourceActor*>(this)->actor_wait_state > 0) static_cast<DeleteResourceActor*>(this)->actor_wait_state = 0;
		static_cast<DeleteResourceActor*>(this)->ActorCallback< DeleteResourceActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DeleteResourceActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("deleteResource", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteResourceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteResource", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DeleteResourceActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("deleteResource", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteResourceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteResource", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DeleteResourceActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("deleteResource", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteResourceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteResource", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1024 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string s3url;
															#line 1025 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string resource;
															#line 1028 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string bucket;
															#line 8657 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
};
// This generated class is to be used only via deleteResource()
															#line 1024 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
class DeleteResourceActor final : public Actor<Void>, public ActorCallback< DeleteResourceActor, 0, Void >, public FastAllocated<DeleteResourceActor>, public DeleteResourceActorState<DeleteResourceActor> {
															#line 8662 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
public:
	using FastAllocated<DeleteResourceActor>::operator new;
	using FastAllocated<DeleteResourceActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9702806056078085376UL, 1967139069200274688UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DeleteResourceActor, 0, Void >;
															#line 1024 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	DeleteResourceActor(std::string const& s3url) 
															#line 8679 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		 : Actor<Void>(),
		   DeleteResourceActorState<DeleteResourceActor>(s3url),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("deleteResource", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14827851668417892864UL, 17501710632754782464UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteResourceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("deleteResource");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("deleteResource", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DeleteResourceActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1024 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
[[nodiscard]] Future<Void> deleteResource( std::string const& s3url ) {
															#line 1024 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	return Future<Void>(new DeleteResourceActor(s3url));
															#line 8712 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
}

#line 1032 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"

															#line 8717 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
namespace {
// This generated class is to be used only via listFiles()
															#line 1033 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
template <class ListFilesActor>
															#line 1033 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
class ListFilesActorState {
															#line 8724 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
public:
															#line 1033 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	ListFilesActorState(std::string const& s3url,int const& maxDepth) 
															#line 1033 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
															#line 1033 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		 : s3url(s3url),
															#line 1033 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   maxDepth(maxDepth)
															#line 8733 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
	{
		fdb_probe_actor_create("listFiles", reinterpret_cast<unsigned long>(this));

	}
	~ListFilesActorState() 
	{
		fdb_probe_actor_destroy("listFiles", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 1035 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				resource = std::string();
															#line 1036 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				error = std::string();
															#line 1037 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				parameters = S3BlobStoreEndpoint::ParametersT();
															#line 1038 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				bstore = getEndpoint(s3url, resource, parameters);
															#line 1040 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				if (!bstore)
															#line 8757 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
				{
															#line 1041 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
					TraceEvent(SevError, "S3ClientListingFailed").detail("Error", error);
															#line 1042 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
					return a_body1Catch2(backup_invalid_url(), loopDepth);
															#line 8763 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
				}
															#line 1046 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				bucket = parameters["bucket"];
															#line 1049 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				StrictFuture<bool> __when_expr_0 = bstore->bucketExists(bucket);
															#line 1049 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				if (static_cast<ListFilesActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 8771 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<ListFilesActor*>(this)->actor_wait_state = 1;
															#line 1049 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ListFilesActor, 0, bool >*>(static_cast<ListFilesActor*>(this)));
															#line 8776 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ListFilesActorState();
		static_cast<ListFilesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1133 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!static_cast<ListFilesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ListFilesActorState(); static_cast<ListFilesActor*>(this)->destroy(); return 0; }
															#line 8805 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		new (&static_cast<ListFilesActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ListFilesActorState();
		static_cast<ListFilesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1111 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(SevError, "S3ClientListFilesError").detail("URL", s3url).detail("Error", e.what());
															#line 1112 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (e.code() == error_code_backup_invalid_url)
															#line 8820 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			{
															#line 1113 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				std::cerr << "ERROR: Invalid blobstore URL: " << s3url << std::endl;
															#line 8824 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			}
			else
			{
															#line 1114 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				if (e.code() == error_code_backup_auth_missing)
															#line 8830 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
				{
															#line 1115 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
					std::cerr << "ERROR: Authentication information missing from URL" << std::endl;
															#line 8834 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
				}
				else
				{
															#line 1116 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
					if (e.code() == error_code_backup_auth_unreadable)
															#line 8840 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
					{
															#line 1117 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
						std::cerr << "ERROR: Could not read authentication information" << std::endl;
															#line 8844 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
					}
					else
					{
															#line 1118 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
						if (e.code() == error_code_http_request_failed)
															#line 8850 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
						{
															#line 1120 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
							if (e.what() && strstr(e.what(), "NoSuchBucket") != nullptr)
															#line 8854 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
							{
															#line 1121 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
								std::cerr << "ERROR: Bucket does not exist" << std::endl;
															#line 8858 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
							}
							else
							{
															#line 1122 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
								if (e.what() && strstr(e.what(), "NoSuchKey") != nullptr)
															#line 8864 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
								{
															#line 1123 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
									std::cerr << "ERROR: Resource does not exist in bucket" << std::endl;
															#line 1124 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
									return a_body1Catch1(resource_not_found(), loopDepth);
															#line 8870 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
								}
								else
								{
															#line 1126 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
									std::cerr << "ERROR: HTTP request to blobstore failed" << std::endl;
															#line 8876 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
								}
							}
						}
						else
						{
															#line 1129 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
							std::cerr << "ERROR: " << e.what() << std::endl;
															#line 8884 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
						}
					}
				}
			}
															#line 1131 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 8891 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(bool const& exists,int loopDepth) 
	{
															#line 1050 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!exists)
															#line 8905 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
															#line 1051 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			std::cerr << "ERROR: Bucket '" << bucket << "' does not exist" << std::endl;
															#line 1052 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			return a_body1Catch2(http_request_failed(), loopDepth);
															#line 8911 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		}
															#line 1056 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		delimiter = Optional<char>();
															#line 1057 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (maxDepth <= 1)
															#line 8917 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
															#line 1058 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			delimiter = Optional<char>('/');
															#line 8921 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		}
															#line 1062 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<S3BlobStoreEndpoint::ListResult> __when_expr_1 = bstore->listObjects(bucket, resource, delimiter, maxDepth);
															#line 1062 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<ListFilesActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 8927 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<ListFilesActor*>(this)->actor_wait_state = 2;
															#line 1062 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ListFilesActor, 1, S3BlobStoreEndpoint::ListResult >*>(static_cast<ListFilesActor*>(this)));
															#line 8932 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(bool && exists,int loopDepth) 
	{
															#line 1050 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!exists)
															#line 8941 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
															#line 1051 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			std::cerr << "ERROR: Bucket '" << bucket << "' does not exist" << std::endl;
															#line 1052 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			return a_body1Catch2(http_request_failed(), loopDepth);
															#line 8947 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		}
															#line 1056 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		delimiter = Optional<char>();
															#line 1057 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (maxDepth <= 1)
															#line 8953 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
															#line 1058 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			delimiter = Optional<char>('/');
															#line 8957 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		}
															#line 1062 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<S3BlobStoreEndpoint::ListResult> __when_expr_1 = bstore->listObjects(bucket, resource, delimiter, maxDepth);
															#line 1062 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<ListFilesActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 8963 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<ListFilesActor*>(this)->actor_wait_state = 2;
															#line 1062 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ListFilesActor, 1, S3BlobStoreEndpoint::ListResult >*>(static_cast<ListFilesActor*>(this)));
															#line 8968 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(bool const& exists,int loopDepth) 
	{
		loopDepth = a_body1cont2(exists, loopDepth);

		return loopDepth;
	}
	int a_body1when1(bool && exists,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(exists), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ListFilesActor*>(this)->actor_wait_state > 0) static_cast<ListFilesActor*>(this)->actor_wait_state = 0;
		static_cast<ListFilesActor*>(this)->ActorCallback< ListFilesActor, 0, bool >::remove();

	}
	void a_callback_fire(ActorCallback< ListFilesActor, 0, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("listFiles", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListFilesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listFiles", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ListFilesActor, 0, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("listFiles", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListFilesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listFiles", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ListFilesActor, 0, bool >*,Error err) 
	{
		fdb_probe_actor_enter("listFiles", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ListFilesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listFiles", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 1065 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		std::cout << "Contents of " << s3url << ":" << std::endl;
															#line 1068 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		std::set<std::string> directories;
															#line 1071 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		auto formatSize = [](int64_t size) -> std::string { const char* units[] = { "B", "KB", "MB", "GB", "TB", "PB" }; int unit = 0; double value = static_cast<double>(size); while (value >= 1024.0 && unit < 5) { value /= 1024.0; unit++; } char buffer[32]; snprintf(buffer, sizeof(buffer), "%.2f %s", value, units[unit]); return std::string(buffer); };
															#line 1085 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		for( const auto& prefix : result.commonPrefixes ) {
															#line 1086 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			std::string dirName = prefix;
															#line 1088 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (!dirName.empty() && dirName.back() == '/')
															#line 9062 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			{
															#line 1089 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				dirName.pop_back();
															#line 9066 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			}
															#line 1091 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			directories.insert(dirName);
															#line 1092 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			std::cout << "  " << dirName << "/" << std::endl;
															#line 9072 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		}
															#line 1096 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		for( const auto& object : result.objects ) {
															#line 1097 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			std::string objectName = object.name;
															#line 1099 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			bool skip = false;
															#line 1100 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			for( const auto& dir : directories ) {
															#line 1101 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				if (objectName.find(dir + "/") == 0)
															#line 9084 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
				{
															#line 1102 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
					skip = true;
															#line 9088 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
					break;
				}
			}
															#line 1106 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (!skip)
															#line 9094 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			{
															#line 1107 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				std::cout << " " << objectName << " " << formatSize(object.size) << std::endl;
															#line 9098 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			}
		}
		loopDepth = a_body1cont14(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(S3BlobStoreEndpoint::ListResult const& __result,int loopDepth) 
	{
															#line 1062 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		result = __result;
															#line 9109 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(S3BlobStoreEndpoint::ListResult && __result,int loopDepth) 
	{
		result = std::move(__result);
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ListFilesActor*>(this)->actor_wait_state > 0) static_cast<ListFilesActor*>(this)->actor_wait_state = 0;
		static_cast<ListFilesActor*>(this)->ActorCallback< ListFilesActor, 1, S3BlobStoreEndpoint::ListResult >::remove();

	}
	void a_callback_fire(ActorCallback< ListFilesActor, 1, S3BlobStoreEndpoint::ListResult >*,S3BlobStoreEndpoint::ListResult const& value) 
	{
		fdb_probe_actor_enter("listFiles", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListFilesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listFiles", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ListFilesActor, 1, S3BlobStoreEndpoint::ListResult >*,S3BlobStoreEndpoint::ListResult && value) 
	{
		fdb_probe_actor_enter("listFiles", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListFilesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listFiles", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ListFilesActor, 1, S3BlobStoreEndpoint::ListResult >*,Error err) 
	{
		fdb_probe_actor_enter("listFiles", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ListFilesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listFiles", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont14(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 1033 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string s3url;
															#line 1033 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	int maxDepth;
															#line 1035 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string resource;
															#line 1036 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string error;
															#line 1037 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	S3BlobStoreEndpoint::ParametersT parameters;
															#line 1038 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	Reference<S3BlobStoreEndpoint> bstore;
															#line 1046 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string bucket;
															#line 1056 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	Optional<char> delimiter;
															#line 1062 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	S3BlobStoreEndpoint::ListResult result;
															#line 9215 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
};
// This generated class is to be used only via listFiles()
															#line 1033 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
class ListFilesActor final : public Actor<Void>, public ActorCallback< ListFilesActor, 0, bool >, public ActorCallback< ListFilesActor, 1, S3BlobStoreEndpoint::ListResult >, public FastAllocated<ListFilesActor>, public ListFilesActorState<ListFilesActor> {
															#line 9220 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
public:
	using FastAllocated<ListFilesActor>::operator new;
	using FastAllocated<ListFilesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10761436077267403776UL, 13668523145853469696UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ListFilesActor, 0, bool >;
friend struct ActorCallback< ListFilesActor, 1, S3BlobStoreEndpoint::ListResult >;
															#line 1033 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	ListFilesActor(std::string const& s3url,int const& maxDepth) 
															#line 9238 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		 : Actor<Void>(),
		   ListFilesActorState<ListFilesActor>(s3url, maxDepth),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("listFiles", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7548829570599198464UL, 17955669203805414144UL);
		ActorExecutionContextHelper __helper(static_cast<ListFilesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("listFiles");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("listFiles", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ListFilesActor, 0, bool >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ListFilesActor, 1, S3BlobStoreEndpoint::ListResult >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1033 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
[[nodiscard]] Future<Void> listFiles( std::string const& s3url, int const& maxDepth ) {
															#line 1033 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	return Future<Void>(new ListFilesActor(s3url, maxDepth));
															#line 9272 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
}

#line 1135 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"

															#line 9277 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
namespace {
// This generated class is to be used only via listFiles_impl()
															#line 1136 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
template <class ListFiles_implActor>
															#line 1136 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
class ListFiles_implActorState {
															#line 9284 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
public:
															#line 1136 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	ListFiles_implActorState(Reference<S3BlobStoreEndpoint> const& bstore,std::string const& bucket,std::string const& path) 
															#line 1136 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
															#line 1136 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		 : bstore(bstore),
															#line 1136 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   bucket(bucket),
															#line 1136 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   path(path)
															#line 9295 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
	{
		fdb_probe_actor_create("listFiles_impl", reinterpret_cast<unsigned long>(this));

	}
	~ListFiles_implActorState() 
	{
		fdb_probe_actor_destroy("listFiles_impl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1139 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			StrictFuture<Void> __when_expr_0 = bstore->requestRateRead->getAllowance(1);
															#line 1139 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (static_cast<ListFiles_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9312 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ListFiles_implActor*>(this)->actor_wait_state = 1;
															#line 1139 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ListFiles_implActor, 0, Void >*>(static_cast<ListFiles_implActor*>(this)));
															#line 9317 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ListFiles_implActorState();
		static_cast<ListFiles_implActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1141 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		resource = bstore->constructResourcePath(bucket, path);
															#line 1142 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		headers = HTTP::Headers();
															#line 1143 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		fullResource = resource + "?list-type=2&prefix=" + path;
															#line 1145 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<Reference<HTTP::IncomingResponse>> __when_expr_1 = bstore->doRequest("GET", fullResource, headers, nullptr, 0, { 200, 404 });
															#line 1145 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<ListFiles_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9348 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ListFiles_implActor*>(this)->actor_wait_state = 2;
															#line 1145 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ListFiles_implActor, 1, Reference<HTTP::IncomingResponse> >*>(static_cast<ListFiles_implActor*>(this)));
															#line 9353 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1141 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		resource = bstore->constructResourcePath(bucket, path);
															#line 1142 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		headers = HTTP::Headers();
															#line 1143 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		fullResource = resource + "?list-type=2&prefix=" + path;
															#line 1145 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<Reference<HTTP::IncomingResponse>> __when_expr_1 = bstore->doRequest("GET", fullResource, headers, nullptr, 0, { 200, 404 });
															#line 1145 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<ListFiles_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9370 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ListFiles_implActor*>(this)->actor_wait_state = 2;
															#line 1145 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ListFiles_implActor, 1, Reference<HTTP::IncomingResponse> >*>(static_cast<ListFiles_implActor*>(this)));
															#line 9375 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ListFiles_implActor*>(this)->actor_wait_state > 0) static_cast<ListFiles_implActor*>(this)->actor_wait_state = 0;
		static_cast<ListFiles_implActor*>(this)->ActorCallback< ListFiles_implActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ListFiles_implActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("listFiles_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListFiles_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listFiles_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ListFiles_implActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("listFiles_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListFiles_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listFiles_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ListFiles_implActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("listFiles_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ListFiles_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listFiles_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Reference<HTTP::IncomingResponse> const& r,int loopDepth) 
	{
															#line 1148 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (r->code == 404)
															#line 9459 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
															#line 1149 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(SevWarn, "S3ClientListFilesNotFound").detail("Bucket", bucket).detail("Path", path);
															#line 1150 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			return a_body1Catch1(file_not_found(), loopDepth);
															#line 9465 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		}
		try {
															#line 1154 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			rapidxml::xml_document<> doc;
															#line 1155 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			std::string content = r->data.content;
															#line 1156 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			doc.parse<0>((char*)content.c_str());
															#line 1158 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			rapidxml::xml_node<>* result = doc.first_node();
															#line 1159 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (result == nullptr || strcmp(result->name(), "ListBucketResult") != 0)
															#line 9478 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			{
															#line 1160 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				TraceEvent(SevWarn, "S3ClientListFilesInvalidResponse") .detail("NodeName", result ? result->name() : "null");
															#line 1162 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				return a_body1cont2Catch1(http_bad_response(), loopDepth);
															#line 9484 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			}
															#line 1165 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			std::vector<std::string> files;
															#line 1166 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			rapidxml::xml_node<>* n = result->first_node();
															#line 1167 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			for(;n != nullptr;) {
															#line 1168 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				const char* name = n->name();
															#line 1169 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				if (strcmp(name, "Contents") == 0)
															#line 9496 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
				{
															#line 1170 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
					rapidxml::xml_node<>* key = n->first_node("Key");
															#line 1171 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
					if (key == nullptr)
															#line 9502 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
					{
															#line 1172 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
						TraceEvent(SevWarn, "S3ClientListFilesMissingKey").detail("NodeName", name);
															#line 1173 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
						return a_body1cont2Catch1(http_bad_response(), loopDepth);
															#line 9508 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
					}
															#line 1175 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
					std::string file = key->value();
															#line 1176 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
					if (file.size() > path.size() && file.substr(0, path.size()) == path)
															#line 9514 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
					{
															#line 1177 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
						file = file.substr(path.size());
															#line 9518 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
					}
															#line 1179 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
					files.push_back(file);
															#line 9522 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
				}
															#line 1181 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				n = n->next_sibling();
															#line 9526 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			}
															#line 1184 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (!static_cast<ListFiles_implActor*>(this)->SAV<std::vector<std::string>>::futures) { (void)(files); this->~ListFiles_implActorState(); static_cast<ListFiles_implActor*>(this)->destroy(); return 0; }
															#line 9530 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			new (&static_cast<ListFiles_implActor*>(this)->SAV< std::vector<std::string> >::value()) std::vector<std::string>(files);
			this->~ListFiles_implActorState();
			static_cast<ListFiles_implActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont2Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Reference<HTTP::IncomingResponse> && r,int loopDepth) 
	{
															#line 1148 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (r->code == 404)
															#line 9548 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
															#line 1149 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(SevWarn, "S3ClientListFilesNotFound").detail("Bucket", bucket).detail("Path", path);
															#line 1150 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			return a_body1Catch1(file_not_found(), loopDepth);
															#line 9554 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		}
		try {
															#line 1154 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			rapidxml::xml_document<> doc;
															#line 1155 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			std::string content = r->data.content;
															#line 1156 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			doc.parse<0>((char*)content.c_str());
															#line 1158 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			rapidxml::xml_node<>* result = doc.first_node();
															#line 1159 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (result == nullptr || strcmp(result->name(), "ListBucketResult") != 0)
															#line 9567 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			{
															#line 1160 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				TraceEvent(SevWarn, "S3ClientListFilesInvalidResponse") .detail("NodeName", result ? result->name() : "null");
															#line 1162 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				return a_body1cont2Catch1(http_bad_response(), loopDepth);
															#line 9573 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			}
															#line 1165 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			std::vector<std::string> files;
															#line 1166 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			rapidxml::xml_node<>* n = result->first_node();
															#line 1167 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			for(;n != nullptr;) {
															#line 1168 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				const char* name = n->name();
															#line 1169 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				if (strcmp(name, "Contents") == 0)
															#line 9585 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
				{
															#line 1170 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
					rapidxml::xml_node<>* key = n->first_node("Key");
															#line 1171 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
					if (key == nullptr)
															#line 9591 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
					{
															#line 1172 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
						TraceEvent(SevWarn, "S3ClientListFilesMissingKey").detail("NodeName", name);
															#line 1173 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
						return a_body1cont2Catch1(http_bad_response(), loopDepth);
															#line 9597 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
					}
															#line 1175 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
					std::string file = key->value();
															#line 1176 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
					if (file.size() > path.size() && file.substr(0, path.size()) == path)
															#line 9603 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
					{
															#line 1177 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
						file = file.substr(path.size());
															#line 9607 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
					}
															#line 1179 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
					files.push_back(file);
															#line 9611 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
				}
															#line 1181 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				n = n->next_sibling();
															#line 9615 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			}
															#line 1184 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (!static_cast<ListFiles_implActor*>(this)->SAV<std::vector<std::string>>::futures) { (void)(files); this->~ListFiles_implActorState(); static_cast<ListFiles_implActor*>(this)->destroy(); return 0; }
															#line 9619 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			new (&static_cast<ListFiles_implActor*>(this)->SAV< std::vector<std::string> >::value()) std::vector<std::string>(files);
			this->~ListFiles_implActorState();
			static_cast<ListFiles_implActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont2Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1when1(Reference<HTTP::IncomingResponse> const& r,int loopDepth) 
	{
		loopDepth = a_body1cont2(r, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Reference<HTTP::IncomingResponse> && r,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(r), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ListFiles_implActor*>(this)->actor_wait_state > 0) static_cast<ListFiles_implActor*>(this)->actor_wait_state = 0;
		static_cast<ListFiles_implActor*>(this)->ActorCallback< ListFiles_implActor, 1, Reference<HTTP::IncomingResponse> >::remove();

	}
	void a_callback_fire(ActorCallback< ListFiles_implActor, 1, Reference<HTTP::IncomingResponse> >*,Reference<HTTP::IncomingResponse> const& value) 
	{
		fdb_probe_actor_enter("listFiles_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListFiles_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listFiles_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ListFiles_implActor, 1, Reference<HTTP::IncomingResponse> >*,Reference<HTTP::IncomingResponse> && value) 
	{
		fdb_probe_actor_enter("listFiles_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListFiles_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listFiles_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ListFiles_implActor, 1, Reference<HTTP::IncomingResponse> >*,Error err) 
	{
		fdb_probe_actor_enter("listFiles_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ListFiles_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listFiles_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont2Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1186 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(SevWarn, "S3ClientListFilesError").error(e).detail("Bucket", bucket).detail("Path", path);
															#line 1187 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 9715 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 1136 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	Reference<S3BlobStoreEndpoint> bstore;
															#line 1136 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string bucket;
															#line 1136 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string path;
															#line 1141 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string resource;
															#line 1142 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	HTTP::Headers headers;
															#line 1143 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string fullResource;
															#line 9737 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
};
// This generated class is to be used only via listFiles_impl()
															#line 1136 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
class ListFiles_implActor final : public Actor<std::vector<std::string>>, public ActorCallback< ListFiles_implActor, 0, Void >, public ActorCallback< ListFiles_implActor, 1, Reference<HTTP::IncomingResponse> >, public FastAllocated<ListFiles_implActor>, public ListFiles_implActorState<ListFiles_implActor> {
															#line 9742 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
public:
	using FastAllocated<ListFiles_implActor>::operator new;
	using FastAllocated<ListFiles_implActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(274507253867108864UL, 8154964418300437504UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<std::string>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ListFiles_implActor, 0, Void >;
friend struct ActorCallback< ListFiles_implActor, 1, Reference<HTTP::IncomingResponse> >;
															#line 1136 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	ListFiles_implActor(Reference<S3BlobStoreEndpoint> const& bstore,std::string const& bucket,std::string const& path) 
															#line 9760 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		 : Actor<std::vector<std::string>>(),
		   ListFiles_implActorState<ListFiles_implActor>(bstore, bucket, path),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("listFiles_impl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14489544770152881408UL, 3479841887926592000UL);
		ActorExecutionContextHelper __helper(static_cast<ListFiles_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("listFiles_impl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("listFiles_impl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ListFiles_implActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ListFiles_implActor, 1, Reference<HTTP::IncomingResponse> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1136 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
[[nodiscard]] Future<std::vector<std::string>> listFiles_impl( Reference<S3BlobStoreEndpoint> const& bstore, std::string const& bucket, std::string const& path ) {
															#line 1136 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	return Future<std::vector<std::string>>(new ListFiles_implActor(bstore, bucket, path));
															#line 9794 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
}

#line 1190 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
